-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_139
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_139`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_139` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_139`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3205 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2618,20012,'',0,'22','1','139','PURCHASES','','2020-08-10 22:33:37',5,0.00,0.00,'','479','2020-08-10 22:33:37','479',0,1),(2619,400096,'',0,'24','1','139','PURCHASES','','2020-08-10 22:34:12',5,0.00,0.00,'','479','2020-08-10 22:34:12','479',0,1),(2620,20020,'',0,'20','1','139','SALES','','2020-08-10 22:34:31',5,0.00,0.00,'','479','2020-08-10 22:34:31','479',0,1),(2621,400097,'',0,'24','1','139','SALARIES & WAGES','','2020-08-10 22:34:46',5,0.00,0.00,'','479','2020-08-10 22:34:46','479',0,1),(2622,400229,'',0,'2','1','139','ZBN(POS):1015965368','','2020-08-10 22:35:01',5,0.00,0.00,'','479','2020-08-10 22:35:01','479',0,1),(2623,400230,'',0,'2','1','139','ZB(E-BILL)1015372548','','2020-08-10 22:35:16',5,0.00,0.00,'','479','2020-08-10 22:35:16','479',0,1),(2624,40019,'',0,'6.1','1','139','CASH','','2020-08-10 22:36:00',5,0.00,0.00,'','479','2020-08-10 22:36:00','479',0,1),(2650,400242,'',0,'2','1','139','Unity Bank (0024061656)','','2020-08-12 14:20:02',5,0.00,0.00,'','487','2020-08-12 14:20:02','487',0,1),(2657,400108,'',0,'24','1','139','OPERATIONAL LOSS','ALL LOSSES DURING SALES/RECEPTION.','2020-08-13 13:58:55',5,0.00,0.00,'','479','2020-08-13 13:58:55','479',0,1),(2900,400317,'',0,'2','1','139','DANKANO-EBILLS(ZNB:1014717618)','','2020-10-29 13:32:17',5,0.00,0.00,'','489','2020-10-29 13:32:17','489',0,1),(3202,400481,'',0,'2','1','139','FID POS COLLECTION-5620141491','','2021-02-26 15:57:28',5,0.00,0.00,'','489','2021-02-26 15:57:28','489',0,1),(3203,400482,'',0,'2','1','139','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:42:42',5,0.00,0.00,'','792','2023-02-20 14:42:42','792',0,0),(3204,400483,'',0,'2','1','139','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:45:53',5,0.00,0.00,'2023-03-15','792','2023-03-17 14:02:13','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4246 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1588,'','1','139','ALL DEALERS','MUSTAPHA','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','LAFIA OMBI 1','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-12 12:53:05',5,'509','2020-08-12 12:53:05','509'),(1606,'','1','139','OPERATIONAL LOSS','HAFIZ NURA GAYA','08069129774','hgaya@aaranonigeria.com','KANO','KANO','AA RANO HOUSE HOTORO KANO.','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 13:58:09',5,'479','2020-08-13 13:58:09','479'),(2133,'','1','139','shabu gas','shabu','08034679093','shabu@gmail.com','LAFIA','NASARAWA','shabu opp plaza','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 08:28:08',5,'509','2021-02-22 08:28:08','509'),(2134,'','1','139','biyaminu gas','bilyaminu','09021799915','bilyaminu@gmail.com','awe','NASARAWA','azara ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 08:32:43',5,'509','2021-02-22 08:32:43','509'),(2136,'','1','139','Eike gas','ejike','08160583680','ejike@gmail.com','akwanga','NASARAWA','akwanga','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 09:00:21',5,'509','2021-02-22 09:00:21','509'),(2145,'','1','139','SONIA GAS','SONIA GAS','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','AWE','Nigeria',38880.00,0.00,0.00,'0000-00-00','2021-02-22 11:32:35',5,'509','2021-02-22 11:32:35','509'),(2147,'','1','139','ISAH Gas','isah','08106103698','isah@gmail.com','nasarawa','NASARAWACredit limit	','nasarawa eggon','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 12:04:13',5,'509','2021-02-22 12:04:13','509'),(2148,'','1','139','israel gas','israel','07043988444','israel@mail.com','AGWANGA','NASARAWA','Agwanga','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 12:09:14',5,'509','2021-02-22 12:09:14','509'),(2153,'','1','139','WRIGHT WAY GAS','WRIGHT WAY','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','SHABU','Nigeria',16200.00,0.00,0.00,'0000-00-00','2021-02-22 15:03:28',5,'509','2021-02-22 15:03:28','509'),(2154,'','1','139','MONACO GAS','MONACO','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','LAFIA','Nigeria',2000.00,0.00,0.00,'0000-00-00','2021-02-22 15:31:44',5,'509','2021-02-22 15:31:44','509'),(2156,'','1','139','JOHN GAS','JOHN','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','POLY','Nigeria',16200.00,0.00,0.00,'0000-00-00','2021-02-22 15:52:34',5,'509','2021-02-22 15:52:34','509'),(2168,'','1','139','jerry gas','jerry','09013003049','jerrygas@gmail.com','LAFIA','NASARAWA','bukan sidi','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-23 13:57:35',5,'509','2021-02-23 13:57:35','509'),(2169,'','1','139','Enenche','ENENCHE','08068071932','enench@gmail.com','awe','NASARAWA','awe','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-23 14:18:20',5,'509','2021-02-23 14:18:20','509'),(2171,'','1','139','I K GAS','I K','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','MAKURDI RD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-23 16:02:35',5,'509','2021-02-23 16:02:35','509'),(2172,'','1','139','RIMI UKU GAS','RIMI UKU','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','MAKURDI RD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-23 16:05:33',5,'509','2021-02-23 16:05:33','509'),(2173,'','1','139','ODISON GAS','ODISON','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','JOS RD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-23 16:12:18',5,'509','2021-02-23 16:12:18','509'),(2174,'','1','139','BIG FISH GAS','BIG FISH','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','MAKURDI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-23 16:19:36',5,'509','2021-02-23 16:19:36','509'),(2176,'','1','139','Right wayb gas','right way','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','Nnguwan Nungu','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-24 07:42:58',5,'509','2021-02-24 07:42:58','509'),(2178,'','1','139','OKESE GAS','OKESE GAS','08065718168','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','LAFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-24 08:25:54',5,'509','2021-02-24 08:25:54','509'),(2179,'','1','139','CHEUKS GAS','CHEUKS ','08066372755','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','OPP COLLEGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-24 09:29:10',5,'509','2021-02-24 09:29:10','509'),(2181,'','1','139','JK GAS','JK AKWANGA','08135946930','jkakwanga@gmail.com','LAFIA','NASARAWA','AKWANGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-24 11:32:16',5,'509','2021-02-24 11:32:16','509'),(2183,'','1','139','DANLAMI GAS','DANLAMI','08037436386','dlgas@gmail.com','LAFIA','NASARAWA','BUKAN SIDI OPP NURTW GARAGE LAFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-24 11:59:19',5,'509','2021-02-24 11:59:19','509'),(2187,'','1','139','K C GAS','KC GAS','08026870758','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','OPP POCILE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-24 15:02:55',5,'509','2021-02-24 15:02:55','509'),(2188,'','1','139','DEBO GAS','DEBO GAS','08125392015','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','BUKKAN CIDY','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-24 15:46:37',5,'509','2021-02-24 15:46:37','509'),(2190,'','1','139','PETER GAS','PETER','0705304447','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','LAFIA EAST','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-25 07:57:49',5,'509','2021-02-25 07:57:49','509'),(2192,'','1','139','ETHAN','SAMUEL','08038317578','mustaphakhalid606@gmail.com','DOMA','NASARAWA','RUKUBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-25 14:26:24',5,'509','2021-02-25 14:26:24','509'),(2197,'','1','139','I K SHABU  GAS','I K SHABU','08062813848','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','SHABU PLASA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-26 08:39:01',5,'509','2021-02-26 08:39:01','509'),(2200,'','1','139','NONSO GAS','NONSO','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','JOS RD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-26 09:24:15',5,'509','2021-02-26 09:24:15','509'),(2201,'','1','139','ARIENZE GAS','ARIENZE','08032211234','mustaphakhalid606@gmail.com','WAMBA','NASARAWA','WAMBA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-26 09:42:00',5,'509','2021-02-26 09:42:00','509'),(2207,'','1','139','KENET DOMA','KENET','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','DOMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-26 12:16:41',5,'509','2021-02-26 12:16:41','509'),(2208,'','1','139','PASTOR GAS','PASTOR','08068166002','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','SHAMDAM ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-26 12:27:49',5,'509','2021-02-26 12:27:49','509'),(2216,'','1','139','NURUDDEEN GAS','NURA','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','LAFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-26 16:14:07',5,'509','2021-02-26 16:14:07','509'),(2223,'','1','139','ESRIEL GAS','ESRIEL','08032211234','mustaphakhalid606@gmail.com','akwanga','NASARAWA','AKWANGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-27 12:01:37',5,'509','2021-02-27 12:01:37','509'),(2229,'','1','139','azara gas','azara','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','nasarawa','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-28 09:39:40',5,'509','2021-02-28 09:39:40','509'),(2233,'','1','139','BLESSED GAS','BLESSED','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','JOS RD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-28 16:47:00',5,'509','2021-02-28 16:47:00','509'),(2239,'','1','139','i.k doma gas','i.k','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','doma','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-01 09:22:22',5,'509','2021-03-01 09:22:22','509'),(2240,'','1','139','reality gas','reality','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','akwanga','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-01 09:39:34',5,'509','2021-03-01 09:39:34','509'),(2244,'','1','139','RIGHT WAY GAS','right way','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','POLY','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-01 12:11:19',5,'509','2021-03-01 12:11:19','509'),(2246,'','1','139','AKWANGA GAS','AKWANGA','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','AKWANGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-01 14:07:54',5,'509','2021-03-01 14:07:54','509'),(2251,'','1','139','EARLY GAS MAKURDI','EARLY','08032211234','mustaphakhalid606@gmail.com','MAKURDI','BENUE','MAKURDI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-01 17:36:18',5,'509','2021-03-01 17:36:18','509'),(2252,'','1','139','EBUKA GAS','EBUKA','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','LAFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-02 08:16:44',5,'509','2021-03-02 08:16:44','509'),(2257,'','1','139','SAMUEL RUKUBI GAS','SAMEL','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','RUKUBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-02 15:54:57',5,'509','2021-03-02 15:54:57','509'),(2282,'','1','139','ANDY GAS','ANDY','08032211234','mustaphakhalid606@gmail.com','BENUE','BENUE','MAKURDI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-04 17:01:14',5,'509','2021-03-04 17:01:14','509'),(2286,'','1','139','BENCO GAS','BENCO','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','T/GWANDARA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-05 12:14:06',5,'509','2021-03-05 12:14:06','509'),(2328,'','1','139','SKY WAVES GAS','SKY','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','LAFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-15 09:04:29',5,'509','2021-03-15 09:04:29','509'),(2334,'','1','139','S.N GAS','SANI','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','LAFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-15 12:25:07',5,'509','2021-03-15 12:25:07','509'),(2361,'','1','139','YELLOW GAS','YELLOW','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','LAFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-19 10:49:02',5,'509','2021-03-19 10:49:02','509'),(2366,'','1','139','FRIDAY GAS','FRIDAY','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','LAFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-20 13:12:38',5,'509','2021-03-20 13:12:38','509'),(2371,'','1','139','O.Z GAS MAKODI','O.Z','08032211234','mustaphakhalid606@gmail.com','MAKODI','BENUE','MAKURDI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-21 17:37:22',5,'509','2021-03-21 17:37:22','509'),(2372,'','1','139','PERFECT GAS MAKODI','PERFECT','08032211234','mustaphakhalid606@gmail.com','MAKODI','BENUE','MAKODI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-21 17:42:28',5,'509','2021-03-21 17:42:28','509'),(2378,'','1','139','C.K GAS','C K','08032211234','mustaphakhalid606@gmail.comlaf','LAFIA','NASARAWA','LAFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-22 14:41:53',5,'509','2021-03-22 14:41:53','509'),(2379,'','1','139','U. LIGHT GAS','LIGHT','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','LAFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-22 17:07:26',5,'509','2021-03-22 17:07:26','509'),(2407,'','1','139','U.K WAMBA GAS','U.K','08135946930','ukwamba@gmail.com','WAMBA','NASARAWA','OPP ODAKOS CLINIC WAMBA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-26 12:13:42',5,'509','2021-03-26 12:13:42','509'),(2552,'','1','139','NAMU GAS','NAMU','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','LAFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-13 11:00:59',5,'509','2021-04-13 11:00:59','509'),(2554,'','1','139','ZAGI GAS','DAN ZAGI','07039242180','mustaphakhalid606@gmail.com','GWANTU','KADUNA','GWATU ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-13 13:34:48',5,'509','2021-04-13 13:34:48','509'),(2558,'','1','139','MADAM IYKE','IYKE','07066109293','madamiyke@gmail.com','LAFIA','NASARAWA','MAKURDI ROAD LAFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-14 07:31:24',5,'509','2021-04-14 07:31:24','509'),(2559,'','1','139','SHANDAM GAS','DAVID','08032211234','shandamgas@gmail.com','shandam','plateu','shandam jos plateu state','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-14 09:37:14',5,'509','2021-04-14 09:37:14','509'),(2570,'','1','139','UCHE GAS','UCHE','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','LAFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-16 16:47:52',5,'509','2021-04-16 16:47:52','509'),(2587,'','1','139','EMMER','EMMER','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','AKWANGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-22 07:09:12',5,'509','2021-04-22 07:09:12','509'),(2589,'','1','139','SUCCESS GAS','SUCCESS','07060679728','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','SHENDAM ROAD LAFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-22 07:49:06',5,'509','2021-04-22 07:49:06','509'),(2593,'','1','139','GWANTU GAS','KADUNA','08032211234','mustaphakhalid606@gmail.com','KADUNA','KADUNA','SANGA\r\n','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-23 07:47:48',5,'509','2021-04-23 07:47:48','509'),(2608,'','1','139','OBI GAS','YAHYA  OBI','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','OBI ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-25 12:46:13',5,'509','2021-04-25 12:46:13','509'),(2616,'','1','139','EKENE SHABU GAS','EKENE','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','SHABU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-27 08:13:06',5,'509','2021-04-27 08:13:06','509'),(2643,'','1','139','prancise peter ','living world','09039333064','peterprancise252@gmail.com','gwantu','KADUNA','gwantu','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-03 07:31:41',5,'509','2021-05-03 07:31:41','509'),(2646,'','1','139','emenike','emenike gas','07049179548','mustaphakhalid606@gmail.com','akwanga','NASARAWA','akwanga college','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-03 11:16:07',5,'509','2021-05-03 11:16:07','509'),(2660,'','1','139','AN,KANI GAS','ABBAS','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','LAFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-08 09:36:06',5,'509','2021-05-08 09:36:06','509'),(2662,'','1','139','AJIKE AKWANGA','AJIKE GAS','08032211234','mustaphakhalid606@gmail.com','akwanga','NASARAWA','AKWANGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-08 16:57:18',5,'509','2021-05-08 16:57:18','509'),(2675,'','1','139','ASSAKEO','ASSAKEO','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','OBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-14 14:05:44',5,'509','2021-05-14 14:05:44','509'),(2676,'','1','139','GALUX MAKURDI','GALUX NIG','08032211234','mustaphakhalid606@gmail.com','MAKURDI','BENUE','MAKURDI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-14 15:58:19',5,'509','2021-05-14 15:58:19','509'),(2680,'','1','139','J.B GAS','J.B','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','ANGUWAR NUGU B DIVISION','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-17 07:42:12',5,'509','2021-05-17 07:42:12','509'),(2689,'','1','139','CHUKS GAS','CHUKS','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','LAFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-19 09:01:39',5,'509','2021-05-19 09:01:39','509'),(2696,'','1','139','EDU GAS','EDU','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','B/DIVISION','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-20 13:05:12',5,'509','2021-05-20 13:05:12','509'),(2711,'','1','139','DAMUWA GAS','DAMUWA','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','COLLEGE IN LAFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-30 07:26:57',5,'509','2021-05-30 07:26:57','509'),(2718,'','1','139','FRANCK GAS','FRANCK','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','SHABU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-02 09:23:34',5,'509','2021-06-02 09:23:34','509'),(2754,'','1','139','RUKUBI','RUKUBI 2','08032211234','mustyrano17@gmail.com','LAFIA','NASARAWA','LAFIA NORTH','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-17 15:02:03',5,'509','2021-06-17 15:02:03','509'),(2779,'','1','139','PAPA MAKODI ','PAPA','08032211234','mustyrano17@gmail.com','BUNUER','BUNUE','MAKODI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-19 13:30:57',5,'509','2021-06-19 13:30:57','509'),(2804,'','1','139','ELLOSON GAS','ELLOSON','08032211234','mustaphakhalid606@gmail.com','MAKURDI','BENUE','MAKURDI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-22 14:08:15',5,'509','2021-06-22 14:08:15','509'),(2866,'','1','139','ABDUL VENTURES GAS','ABDUL','08067853657','mustyrano17@gmail.com','LAFIA','NASARAWA','AZUBA CENTER','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-29 14:28:50',5,'509','2021-06-29 14:28:50','509'),(2920,'','1','139','EPHRIEAM AKWANGA','EPRIEAM','08032211234','mustaphakhalid606@gmail.com','akwanga','NASARAWA','NASARAWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-08 13:28:35',5,'509','2021-07-08 13:28:35','509'),(3018,'','1','139','ZION GAS','ZION KWANDARI','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','KWANDARI ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-06 07:52:54',5,'509','2021-08-06 07:52:54','509'),(3162,'','1','139','ZAKIRU GAS','ZAKIRU','08032211234','mustaphakhalid606@gmail.com','akwanga','NASARAWA','NASSARAWA EGGON','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-30 08:14:32',5,'509','2021-08-30 08:14:32','509'),(3172,'','1','139','JOHN AKWANGA  GAS','JOHN AKWANGA','08032211234','mustaphakhalid606@gmail.com','akwanga','NASARAWA','AKWANGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-30 14:56:00',5,'509','2021-08-30 14:56:00','509'),(3323,'','1','139','VINCENT GAS','VINCENT','08032211234','mustaphakhalid606@gmail.com','NASSARAWA EGGON','NASARAWA','MADA STATION  RD NASSARAW EGGON','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-19 13:12:50',5,'509','2021-09-19 13:12:50','509'),(3355,'','1','139','CHARNCE  MAKURDI ','CHARNCE GAS','08032211234','mustaphakhalid606@gmail.com','MAKODI','BENUE','BENUE STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-24 18:16:10',5,'509','2021-09-24 18:16:10','509'),(3363,'','1','139','ABDUL AZUBA','AZUBA','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','AZUBA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-25 15:24:38',5,'509','2021-09-25 15:24:38','509'),(3367,'','1','139','KENET DOMA GAS','KENET','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','DOMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-27 08:14:07',5,'509','2021-09-27 08:14:07','509'),(3368,'','1','139','NONSO CHIOKE AKWANGA','NONSO  AKWANGA','0806476674','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','AKWANGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-27 08:35:42',5,'509','2021-09-27 08:35:42','509'),(3383,'','1','139','OSTINE GAS LAFIA','OSTIN','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','OMBI ONE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-02 07:30:51',5,'509','2021-10-02 07:30:51','509'),(3417,'','1','139','EPECO GAS','EPECO','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','LAFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-08 08:02:16',5,'509','2021-10-08 08:02:16','509'),(3464,'','1','139','ADAMS GAS','ADAM','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','DOMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-13 11:46:46',5,'509','2021-10-13 11:46:46','509'),(3606,'','1','139','COLLINS GAS','COLLINS ','08032211234','mustaphakhalid606@gmail.com','AKWANGA','NASARAWA','AKWANGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-26 08:09:40',5,'509','2021-10-26 08:09:40','509'),(3621,'','1','139','EMEKA GAS','EMEKA','08032211234','mustaphakhalid606@gmail.com','akwanga','NASARAWA','`AKWANGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-28 11:54:37',5,'509','2021-10-28 11:54:37','509'),(3637,'','1','139','JOE GAS SHANDAM','JOE GAS','08032211234','mustaphakhalid606@gmail.com','SHANDAM','JOS','SHANDAM','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-31 09:15:48',5,'509','2021-10-31 09:15:48','509'),(3686,'','1','139','AUSTINE GAS','AUSTINE','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','COMAN S/SCHOOL','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-08 11:49:57',5,'509','2021-11-08 11:49:57','509'),(3701,'','1','139','MADAM WAMBA GAS','WAMBA','08060256667','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','LAFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-10 09:45:13',5,'509','2021-11-10 09:45:13','509'),(3704,'','1','139','REHOBOT GAS','REHOBOT','08032211234','mustaphakhalid606@gmail.com','shandam','JOS','SHANDAM','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-10 10:49:00',5,'509','2021-11-10 10:49:00','509'),(3816,'','1','139','PETER AKWANGA','AKWANGA','08032211234','mustaphakhalid606@gmail.com','akwanga','NASARAWA','AKWANGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-20 08:25:48',5,'509','2021-11-20 08:25:48','509'),(3878,'','1','139','SULAIMAN GAS','SULE','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','LAFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-28 09:24:50',5,'509','2021-11-28 09:24:50','509'),(3888,'','1','139','KURGWI GAS','KURGWI','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','NASSARAWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-29 11:56:58',5,'509','2021-11-29 11:56:58','509'),(3980,'','1','139','GOD GRACE GAS','GOD GRACE','08032211234','mustaphakhalid606@gmail.com','JOS','JOS','SHANDAM','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-08 11:15:51',5,'509','2021-12-08 11:15:51','509'),(4095,'','1','139','MADAM RUKUBI GAS','MADAM RUKU','08032211234','mustaphakhalid606@gmail.com','DOMA','NASARAWA','RUKUBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-26 15:11:20',5,'509','2021-12-26 15:11:20','509'),(4172,'','1','139','AL FAHIM GAS','FAHIM','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','SHABU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-14 09:29:09',5,'509','2022-01-14 09:29:09','509'),(4233,'','1','139','PAPA  GAS','PAPA AKWANGA','08032211234','mustaphakhalid606@gmail.com','AKWANGA','NASARAWA STATE','AKWANGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-24 15:50:48',5,'509','2022-01-24 15:50:48','509'),(4234,'','1','139','PETER SHANDAN ','SHANDAM','08060739878','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','SHANDAM LGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-08 14:02:36',5,'509','2022-02-08 14:02:36','509'),(4235,'','1','139','T.G.R. GAS KWANDARI ROAD','T G RKWANDARI','07067767696','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','KWANDARI ROAD LAFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-08 14:12:21',5,'509','2022-02-08 14:12:21','509'),(4236,'','1','139','VICTOM  NAMU GAS','NAMU','08060531146','mustaphakhalid606@gmail.com','akwanga','NASARAWA','NAMU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-12 17:21:32',5,'509','2022-02-12 17:21:32','509'),(4237,'','1','139','A.Y GAS AKWANGA ','KEFFI BYE PASS AKWANGA','07032439094','mustaphakhalid606@gmail.com','akwanga','NASARAWA','AKWANGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-22 15:13:49',5,'509','2022-02-22 15:13:49','509'),(4238,'','1','139','BC. GAS','ZAKARI','08032211234','mustaphakhalid606@gmail.com','PLATOU','JOS','KWURGWI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-17 10:48:41',5,'509','2022-03-17 10:48:41','509'),(4239,'','1','139','ANDAHA GAS KADUNA','ANDAHA GAS','08068166002','mustaphakhalid606@gmail.com','GWANTU','KADUNA','ANDAHA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-25 16:43:44',5,'509','2022-03-25 16:43:44','509'),(4240,'','1','139','U. K AKWANGA GAS','U.K','08032211234','mustaphakhalid606@gmail.com','AKWANGA','NASARAWA','AKWANGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-13 09:37:52',5,'509','2022-04-13 09:37:52','509'),(4241,'','1','139','IYKE DOMA GAS','IYKE','08160492200','mustaphakhalid606@gmail.com','DOMA','NASARAWA','DAMO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-15 13:25:49',5,'509','2022-04-15 13:25:49','509'),(4242,'','1','139','TANKO GAS','TANKO','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA STATE','LPY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-03 13:28:27',5,'509','2022-06-03 13:28:27','509'),(4243,'','1','139','SUNDAY GAS','SUNDAY','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','NASSARAWA EGGON','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-10 12:57:57',5,'509','2022-07-10 12:57:57','509'),(4244,'','1','139','IYKE MAKURDI ROAD GAS','IYKE','08032211234','mustaphakhalid606@gmail.com','LAFIA','NASARAWA','MAKURDI  ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-15 17:37:30',5,'509','2022-09-15 17:37:30','509'),(4245,'','1','139','ABDUL MUMINU','OSIKEMA GAS','08032211234','mustaphakhalid606@gmail.com','KEANNA','NASARAWA','KEANA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-01 12:31:10',5,'509','2023-01-01 12:31:10','509');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16352 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','139',15137,'772',24074.00,23000.00,'2021-05-31','','2021-05-31 12:55:04','483','483',2021,'483','2021-05-31 12:55:04',5),('1','139',16350,'772',6364.08,3584.00,'2021-09-08','new dipping','2021-09-08 14:36:36','483','483',2021,'483','2021-09-08 14:36:36',5),('1','139',16351,'772',21059.11,20000.00,'2022-04-04','new','2022-04-04 14:31:22','483','483',2022,'483','2022-04-04 14:31:22',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2187 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','139','772',2143,'5','LPG NOZZLE ',3500372.95,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','139','772',2186,'5','LPG NOZZLE 2',2655.03,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257952 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','139',146991,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-12 13:06:00','509','2020-08-12 13:07:30',10,0),('1','139',147016,'DAILY SHIFT','2020-08-07','2020-08-07 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-12 14:08:25','509','2020-08-12 14:09:02',10,0),('1','139',147072,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-12 16:12:02','509','2020-08-12 16:12:32',10,0),('1','139',147084,'DAILY SHIFT','2020-08-09','2020-08-09 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-12 16:37:46','509','2020-08-12 16:38:12',10,0),('1','139',147090,'DAILY SHIFT','2020-08-10','2020-08-10 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-12 22:17:36','509','2020-08-12 22:22:53',10,0),('1','139',147115,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-12 22:44:01','509','2020-08-12 22:44:43',10,0),('1','139',147137,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-13 08:23:49','509','2020-08-13 08:24:28',10,0),('1','139',147159,'DAILY SHIFT','2020-08-13','2020-08-13 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-14 21:54:41','509','2020-08-14 21:55:12',10,0),('1','139',147437,'DAILY SHIFT','2020-08-14','2020-08-14 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-14 22:07:44','509','2020-08-14 22:08:11',10,0),('1','139',147555,'DAILY SHIFT','2020-08-15','2020-08-15 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-15 18:28:21','509','2020-08-15 18:28:52',10,0),('1','139',147676,'DAILY SHIFT','2020-08-16','2020-08-16 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-16 18:46:34','509','2020-08-16 18:46:59',10,0),('1','139',147686,'DAILY SHIFT','2020-08-16','2020-08-16 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-17 19:59:13','509','2020-08-17 19:59:48',10,0),('1','139',147989,'DAILY SHIFT','2020-08-18','2020-08-18 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-18 19:43:41','509','2020-08-18 19:44:17',10,0),('1','139',148124,'DAILY SHIFT','2020-08-19','2020-08-19 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-19 18:53:20','509','2020-08-19 18:53:43',10,0),('1','139',148287,'DAILY SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-20 21:37:29','509','2020-08-20 21:38:55',10,0),('1','139',148409,'DAILY SHIFT','2020-08-21','2020-08-21 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-21 18:12:08','509','2020-08-21 18:12:32',10,0),('1','139',148556,'DAILY SHIFT','2020-08-22','2020-08-22 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-22 18:44:34','509','2020-08-22 18:45:05',10,0),('1','139',148662,'DAILY SHIFT','2020-08-23','2020-08-23 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-24 10:15:37','509','2020-08-24 10:16:10',10,0),('1','139',148713,'DAILY SHIFT','2020-08-23','2020-08-23 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-24 18:48:02','509','2020-08-24 18:48:35',10,0),('1','139',148972,'DAILY SHIFT','2020-08-25','2020-08-25 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-25 23:23:53','509','2020-08-25 23:24:33',10,0),('1','139',149136,'DAILY SHIFT','2020-08-26','2020-08-26 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-26 18:17:27','509','2020-08-26 18:17:45',10,0),('1','139',149295,'DAILY SHIFT','2020-08-27','2020-08-27 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-27 18:23:55','509','2020-08-27 18:24:24',10,0),('1','139',149444,'DAILY SHIFT','2020-08-28','2020-08-28 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-28 18:48:49','509','2020-08-28 18:49:10',10,0),('1','139',149598,'DAILY SHIFT','2020-08-29','2020-08-29 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-29 20:31:03','509','2020-08-29 20:31:24',10,0),('1','139',149687,'DAILY SHIFT','2020-08-30','2020-08-30 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-30 18:47:48','509','2020-08-30 18:52:53',10,0),('1','139',149754,'DAILY SHIFT','2020-08-31','2020-08-31 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-31 11:38:42','509','2020-08-31 11:39:41',10,0),('1','139',149759,'DAILY SHIFT','2020-08-31','2020-08-31 00:00:00',NULL,'509',0.00,0.00,'509','2020-08-31 18:08:07','509','2020-08-31 18:08:31',10,0),('1','139',150005,'DAILY SHIFT','2020-09-01','2020-09-01 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-01 19:57:34','509','2020-09-01 19:58:28',10,0),('1','139',150144,'DAILY SHIFT','2020-09-02','2020-09-02 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-02 19:01:32','509','2020-09-02 19:01:57',10,0),('1','139',150370,'DAILY SHIFT','2020-09-03','2020-09-03 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-03 18:27:19','509','2020-09-03 18:27:43',10,0),('1','139',150543,'DAILY SHIFT','2020-09-04','2020-09-04 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-04 18:41:07','509','2020-09-04 18:41:42',10,0),('1','139',150705,'DAILY SHIFT','2020-09-05','2020-09-05 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-05 18:38:26','509','2020-09-05 18:38:47',10,0),('1','139',150708,'DAILY SHIFT','2020-09-05','2020-09-05 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-06 18:13:49','509','2020-09-06 18:15:08',10,0),('1','139',150832,'DAILY SHIFT','2020-09-06','2020-09-06 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-06 18:23:38','509','2020-09-06 18:24:10',10,0),('1','139',150999,'DAILY SHIFT','2020-09-07','2020-09-07 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-07 19:45:17','509','2020-09-07 19:45:37',10,0),('1','139',151149,'DAILY SHIFT','2020-09-08','2020-09-08 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-08 19:48:15','509','2020-09-08 19:49:23',10,0),('1','139',151286,'DAILY SHIFT','2020-09-09','2020-09-09 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-09 20:39:05','509','2020-09-09 20:39:43',10,0),('1','139',151444,'DAILY SHIFT','2020-09-10','2020-09-10 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-10 22:00:55','509','2020-09-10 22:01:19',10,0),('1','139',151581,'DAILY SHIFT','2020-09-11','2020-09-11 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-11 18:32:02','509','2020-09-11 18:32:50',10,0),('1','139',151690,'DAILY SHIFT','2020-09-12','2020-09-12 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-12 18:29:41','509','2020-09-12 18:30:52',10,0),('1','139',151814,'DAILY SHIFT','2020-09-13','2020-09-13 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-13 18:32:29','509','2020-09-13 18:32:53',10,0),('1','139',152000,'DAILY SHIFT','2020-09-14','2020-09-14 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-14 18:43:21','509','2020-09-14 18:44:23',10,0),('1','139',152158,'DAILY SHIFT','2020-09-15','2020-09-15 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-16 17:25:58','509','2020-09-16 17:26:27',10,0),('1','139',152315,'DAILY SHIFT','2020-09-16','2020-09-16 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-17 09:36:47','509','2020-09-17 09:37:43',10,0),('1','139',152352,'DAILY SHIFT','2020-09-17','2020-09-17 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-17 09:47:32','509','2020-09-17 09:47:58',10,0),('1','139',152353,'DAILY SHIFT','2020-09-17','2020-09-17 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-17 10:48:03','509','2020-09-17 10:49:40',10,0),('1','139',152458,'DAILY SHIFT','2020-09-17','2020-09-17 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-17 18:22:17','509','2020-09-17 18:25:46',10,0),('1','139',152618,'DAILY SHIFT','2020-09-18','2020-09-18 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-18 22:51:34','509','2020-09-18 22:52:03',10,0),('1','139',152773,'DAILY SHIFT','2020-09-19','2020-09-19 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-19 21:42:23','509','2020-09-19 21:44:27',10,0),('1','139',152901,'DAILY SHIFT','2020-09-20','2020-09-20 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-20 21:37:07','509','2020-09-20 21:39:02',10,0),('1','139',153071,'DAILY SHIFT','2020-09-21','2020-09-21 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-21 18:14:53','509','2020-09-21 18:15:21',10,0),('1','139',153072,'DAILY SHIFT','2020-09-21','2020-09-21 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-23 14:55:22','509','2020-09-23 14:55:44',10,0),('1','139',153434,'DAILY SHIFT','2020-09-23','2020-09-23 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-23 18:19:32','509','2020-09-23 18:19:51',10,0),('1','139',153645,'DAILY SHIFT','2020-09-24','2020-09-24 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-24 19:21:55','509','2020-09-24 19:22:53',10,0),('1','139',153797,'DAILY SHIFT','2020-09-25','2020-09-25 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-25 18:33:36','509','2020-09-25 18:33:57',10,0),('1','139',153931,'DAILY SHIFT','2020-09-26','2020-09-26 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-26 22:05:40','509','2020-09-26 22:06:04',10,0),('1','139',154066,'DAILY SHIFT','2020-09-27','2020-09-27 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-27 21:28:06','509','2020-09-27 21:29:45',10,0),('1','139',154250,'DAILY SHIFT','2020-09-28','2020-09-28 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-28 21:50:56','509','2020-09-28 21:51:17',10,0),('1','139',154405,'DAILY SHIFT','2020-09-29','2020-09-29 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-29 18:32:16','509','2020-09-29 18:33:45',10,0),('1','139',154557,'DAILY SHIFT','2020-09-30','2020-09-30 00:00:00',NULL,'509',0.00,0.00,'509','2020-09-30 16:31:37','509','2020-09-30 16:32:04',10,0),('1','139',154558,'DAILY SHIFT','2020-09-30','2020-09-30 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-03 21:04:15','509','2020-10-03 21:04:44',10,0),('1','139',155025,'DAILY SHIFT','2020-10-03','2020-10-03 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-03 21:17:30','509','2020-10-03 21:17:49',10,0),('1','139',155136,'DAILY SHIFT','2020-10-04','2020-10-04 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-04 21:33:44','509','2020-10-04 21:34:04',10,0),('1','139',155298,'DAILY SHIFT','2020-10-05','2020-10-05 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-05 19:17:47','509','2020-10-05 19:18:27',10,0),('1','139',155447,'DAILY SHIFT','2020-10-06','2020-10-06 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-06 18:04:15','509','2020-10-06 18:05:06',10,0),('1','139',155450,'DAILY SHIFT','2020-10-06','2020-10-06 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-06 18:32:01','509','2020-10-06 18:32:37',10,0),('1','139',155645,'DAILY SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-07 20:28:12','509','2020-10-07 20:28:37',10,0),('1','139',155782,'DAILY SHIFT','2020-10-08','2020-10-08 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-08 21:08:14','509','2020-10-08 21:08:34',10,0),('1','139',155938,'DAILY SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-09 22:43:57','509','2020-10-09 22:44:45',10,0),('1','139',156089,'DAILY SHIFT','2020-10-10','2020-10-10 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-10 20:56:30','509','2020-10-10 20:57:49',10,0),('1','139',156298,'DAILY SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-12 12:02:06','509','2020-10-12 12:02:34',10,0),('1','139',156301,'DAILY SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-12 12:23:15','509','2020-10-12 12:23:38',10,0),('1','139',156417,'DAILY SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-12 19:03:43','509','2020-10-12 19:04:00',10,0),('1','139',156560,'DAILY SHIFT','2020-10-13','2020-10-13 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-13 18:24:56','509','2020-10-13 18:25:15',10,0),('1','139',156736,'DAILY SHIFT','2020-10-14','2020-10-14 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-15 20:47:12','509','2020-10-15 20:47:56',10,0),('1','139',156907,'DAILY SHIFT','2020-10-15','2020-10-15 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-15 20:53:06','509','2020-10-15 20:53:24',10,0),('1','139',157088,'DAILY SHIFT','2020-10-16','2020-10-16 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-16 21:45:53','509','2020-10-16 21:46:14',10,0),('1','139',157282,'DAILY SHIFT','2020-10-17','2020-10-17 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-17 21:39:27','509','2020-10-17 21:39:45',10,0),('1','139',157451,'DAILY SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-18 21:35:20','509','2020-10-18 21:35:40',10,0),('1','139',157452,'DAILY SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-19 18:02:24','509','2020-10-19 18:02:42',10,0),('1','139',157640,'DAILY SHIFT','2020-10-19','2020-10-19 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-19 18:06:50','509','2020-10-19 18:07:09',10,0),('1','139',157822,'DAILY SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-20 22:20:56','509','2020-10-20 22:21:15',10,0),('1','139',157953,'DAILY SHIFT','2020-10-21','2020-10-21 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-21 21:42:15','509','2020-10-21 21:42:36',10,0),('1','139',158089,'DAILY SHIFT','2020-10-22','2020-10-22 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-22 20:54:40','509','2020-10-22 20:56:24',10,0),('1','139',158202,'DAILY SHIFT','2020-10-23','2020-10-23 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-23 15:04:33','509','2020-10-23 15:05:30',10,0),('1','139',158209,'DAILY SHIFT','2020-10-23','2020-10-23 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-23 15:26:22','509','2020-10-24 21:35:33',10,0),('1','139',158426,'DAILY SHIFT','2020-10-24','2020-10-24 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-24 21:40:30','509','2020-10-24 21:41:02',10,0),('1','139',158582,'DAILY SHIFT','2020-10-25','2020-10-25 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-25 21:56:11','509','2020-10-25 21:56:31',10,0),('1','139',158753,'DAILY SHIFT','2020-10-26','2020-10-26 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-26 22:06:09','509','2020-10-26 22:06:30',10,0),('1','139',158925,'DAILY SHIFT','2020-10-27','2020-10-27 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-28 18:21:37','509','2020-10-28 18:22:23',10,0),('1','139',159112,'DAILY SHIFT','2020-10-28','2020-10-28 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-28 18:30:02','509','2020-10-28 18:30:26',10,0),('1','139',159279,'DAILY SHIFT','2020-10-29','2020-10-29 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-29 23:05:56','509','2020-10-29 23:06:28',10,0),('1','139',159280,'DAILY SHIFT','2020-10-29','2020-10-29 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-30 22:31:14','509','2020-10-30 22:31:45',10,0),('1','139',159460,'DAILY SHIFT','2020-10-30','2020-10-30 00:00:00',NULL,'509',0.00,0.00,'509','2020-10-30 22:37:51','509','2020-10-30 22:38:40',10,0),('1','139',159742,'DAILY SHIFT','2020-10-31','2020-10-31 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-01 22:06:24','509','2020-11-01 22:07:12',10,0),('1','139',159743,'DAILY SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-01 22:18:14','509','2020-11-01 22:19:01',10,0),('1','139',159953,'DAILY SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-02 22:34:35','509','2020-11-02 22:35:17',10,0),('1','139',160106,'DAILY SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-03 16:44:54','509','2020-11-03 16:45:16',10,0),('1','139',160107,'DAILY SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-03 16:53:12','509','2020-11-03 16:53:49',10,0),('1','139',160368,'DAILY SHIFT','2020-11-05','2020-11-05 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-05 11:00:52','509','2020-11-05 11:01:17',10,0),('1','139',160459,'DAILY SHIFT','2020-11-05','2020-11-05 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-05 22:53:00','509','2020-11-05 22:53:22',10,0),('1','139',160609,'DAILY SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-06 22:41:21','509','2020-11-06 22:41:41',10,0),('1','139',160610,'DAILY SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-06 22:47:22','509','2020-11-06 22:47:56',10,0),('1','139',160736,'DAILY SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-07 18:06:53','509','2020-11-07 18:07:21',10,0),('1','139',160738,'DAILY SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-08 22:29:25','509','2020-11-08 22:29:45',10,0),('1','139',160900,'DAILY SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-08 22:37:28','509','2020-11-08 22:37:46',10,0),('1','139',160901,'DAILY SHIFT','2020-11-08','2020-11-08 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-08 22:43:49','509','2020-11-08 22:44:09',10,0),('1','139',161099,'DAILY SHIFT','2020-11-09','2020-11-09 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-09 19:52:37','509','2020-11-09 19:53:07',10,0),('1','139',161283,'DAILY SHIFT','2020-11-10','2020-11-10 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-10 21:15:09','509','2020-11-10 21:16:49',10,0),('1','139',161425,'DAILY SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-11 16:21:33','509','2020-11-11 16:21:53',10,0),('1','139',161428,'DAILY SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-11 16:27:10','509','2020-11-11 16:27:26',10,0),('1','139',161450,'DAILY SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-11 17:58:18','509','2020-11-11 17:58:37',10,0),('1','139',161659,'DAILY SHIFT','2020-11-12','2020-11-12 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-12 18:42:54','509','2020-11-12 18:43:15',10,0),('1','139',161869,'DAILY SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-13 18:38:06','509','2020-11-13 18:38:30',10,0),('1','139',162051,'DAILY SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-14 20:57:17','509','2020-11-14 20:57:40',10,0),('1','139',162235,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-15 18:31:47','509','2020-11-15 18:32:24',10,0),('1','139',162447,'DAILY SHIFT','2020-11-16','2020-11-16 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-16 18:14:55','509','2020-11-16 18:15:17',10,0),('1','139',162581,'DAILY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-17 13:23:34','509','2020-11-17 13:26:53',10,0),('1','139',162587,'DAILY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-17 13:33:08','509','2020-11-17 13:33:25',10,0),('1','139',162806,'DAILY SHIFT','2020-11-18','2020-11-18 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-18 18:29:08','509','2020-11-18 18:29:28',10,0),('1','139',162996,'DAILY SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-19 17:41:53','509','2020-11-19 17:42:24',10,0),('1','139',163198,'DAILY SHIFT','2020-11-20','2020-11-20 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-20 18:01:47','509','2020-11-20 18:02:03',10,0),('1','139',163372,'DAILY SHIFT','2020-11-21','2020-11-21 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-21 19:11:34','509','2020-11-21 19:11:57',10,0),('1','139',163556,'DAILY SHIFT','2020-11-22','2020-11-22 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-22 22:33:55','509','2020-11-22 22:35:38',10,0),('1','139',163557,'DAILY SHIFT','2020-11-22','2020-11-22 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-22 22:58:19','509','2020-11-22 22:59:26',10,0),('1','139',163747,'DAILY SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-23 23:01:46','509','2020-11-23 23:02:05',10,0),('1','139',163899,'DAILY SHIFT','2020-11-24','2020-11-24 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-24 19:29:56','509','2020-11-24 19:30:18',10,0),('1','139',164080,'DAILY SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-25 20:27:31','509','2020-11-25 20:27:49',10,0),('1','139',164081,'DAILY SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-26 19:24:35','509','2020-11-26 19:24:52',10,0),('1','139',164261,'DAILY SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-26 19:31:03','509','2020-11-26 19:31:23',10,0),('1','139',164438,'DAILY SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-27 18:47:42','509','2020-11-27 18:48:00',10,0),('1','139',164599,'DAILY SHIFT','2020-11-28','2020-11-28 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-28 18:47:07','509','2020-11-28 18:47:31',10,0),('1','139',164754,'DAILY SHIFT','2020-11-29','2020-11-29 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-29 19:05:02','509','2020-11-29 19:05:24',10,0),('1','139',164963,'DAILY SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'509',0.00,0.00,'509','2020-11-30 18:19:29','509','2020-11-30 18:19:47',10,0),('1','139',165132,'DAILY SHIFT','2020-12-01','2020-12-01 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-01 22:24:05','509','2020-12-01 22:24:29',10,0),('1','139',165281,'DAILY SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-02 17:15:35','509','2020-12-02 17:17:05',10,0),('1','139',165283,'DAILY SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-03 19:37:05','509','2020-12-03 19:38:15',10,0),('1','139',165441,'DAILY SHIFT','2020-12-03','2020-12-03 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-03 19:45:55','509','2020-12-03 19:46:41',10,0),('1','139',165615,'DAILY SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-04 18:59:30','509','2020-12-04 19:00:20',10,0),('1','139',165737,'DAILY SHIFT','2020-12-05','2020-12-05 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-05 14:15:40','509','2020-12-05 14:16:15',10,0),('1','139',165744,'DAILY SHIFT','2020-12-05','2020-12-05 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-05 17:26:36','509','2020-12-05 17:27:03',10,0),('1','139',165931,'DAILY SHIFT','2020-12-06','2020-12-06 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-06 19:48:29','509','2020-12-06 19:48:52',10,0),('1','139',166152,'DAILY SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-07 23:30:03','509','2020-12-07 23:30:35',10,0),('1','139',166313,'DAILY SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-08 18:42:50','509','2020-12-08 18:43:12',10,0),('1','139',166494,'DAILY SHIFT','2020-12-09','2020-12-09 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-10 18:31:44','509','2020-12-10 18:32:04',10,0),('1','139',166696,'DAILY SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-10 18:40:04','509','2020-12-10 18:40:53',10,0),('1','139',166698,'DAILY SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-11 18:42:27','509','2020-12-11 18:42:54',10,0),('1','139',166881,'DAILY SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-11 18:54:03','509','2020-12-11 18:54:30',10,0),('1','139',167027,'DAILY SHIFT','2020-12-12','2020-12-12 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-12 18:01:31','509','2020-12-12 18:01:54',10,0),('1','139',167175,'DAILY SHIFT','2020-12-13','2020-12-13 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-13 18:10:50','509','2020-12-13 18:11:07',10,0),('1','139',167369,'DAILY SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-14 18:43:54','509','2020-12-14 18:44:15',10,0),('1','139',167565,'DAILY SHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-15 18:25:42','509','2020-12-15 18:26:01',10,0),('1','139',167723,'DAILY SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-16 17:52:04','509','2020-12-16 17:52:24',10,0),('1','139',167725,'DAILY SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-16 18:01:39','509','2020-12-16 18:01:57',10,0),('1','139',167866,'DAILY SHIFT','2020-12-17','2020-12-17 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-17 15:45:09','509','2020-12-17 15:45:28',10,0),('1','139',169084,'DAILY SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-24 17:44:15','509','2020-12-24 17:44:31',10,0),('1','139',169086,'DAILY SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-24 17:49:19','509','2020-12-24 17:49:40',10,0),('1','139',169089,'DAILY SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-24 18:22:37','509','2020-12-24 18:22:56',10,0),('1','139',169093,'DAILY SHIFT','2020-12-19','2020-12-19 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-24 18:34:11','509','2020-12-24 18:34:55',10,0),('1','139',169097,'DAILY SHIFT','2020-12-20','2020-12-20 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-24 18:46:46','509','2020-12-24 18:47:12',10,0),('1','139',169100,'DAILY SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-24 18:55:57','509','2020-12-24 18:56:18',10,0),('1','139',169103,'DAILY SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-24 19:16:07','509','2020-12-24 19:16:26',10,0),('1','139',169109,'DAILY SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-25 10:53:02','509','2020-12-25 10:53:24',10,0),('1','139',169171,'DAILY SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-25 11:00:49','509','2020-12-25 11:01:23',10,0),('1','139',169179,'DAILY SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-25 11:19:25','509','2020-12-25 11:19:46',10,0),('1','139',169263,'DAILY SHIFT','2020-12-25','2020-12-25 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-25 18:32:13','509','2020-12-25 18:33:03',10,0),('1','139',169431,'DAILY SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-26 17:57:13','509','2020-12-26 17:57:39',10,0),('1','139',169434,'DAILY SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-27 18:30:26','509','2020-12-27 18:30:47',10,0),('1','139',169569,'DAILY SHIFT','2020-12-27','2020-12-27 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-27 18:36:58','509','2020-12-27 18:37:51',10,0),('1','139',169767,'DAILY SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-28 18:30:32','509','2020-12-28 18:30:57',10,0),('1','139',169920,'DAILY SHIFT','2020-12-29','2020-12-29 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-29 18:27:30','509','2020-12-29 18:27:51',10,0),('1','139',170144,'DAILY SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-30 19:18:44','509','2020-12-30 19:19:05',10,0),('1','139',170331,'DAILY SHIFT','2020-12-31','2020-12-31 00:00:00',NULL,'509',0.00,0.00,'509','2020-12-31 19:12:53','509','2020-12-31 19:13:19',10,0),('1','139',170500,'DAILY SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-01 22:32:47','509','2021-01-01 22:33:46',10,0),('1','139',170675,'DAILY SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-02 23:01:38','509','2021-01-02 23:02:03',10,0),('1','139',170819,'DAILY SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-03 21:41:34','509','2021-01-03 21:42:06',10,0),('1','139',171006,'DAILY SHIFT','2021-01-04','2021-01-04 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-04 22:51:14','509','2021-01-04 22:51:59',10,0),('1','139',171007,'DAILY SHIFT','2021-01-04','2021-01-04 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-05 21:59:24','509','2021-01-05 21:59:45',10,0),('1','139',171217,'DAILY SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-05 22:06:21','509','2021-01-05 22:07:43',10,0),('1','139',171525,'DAILY SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-07 14:55:10','509','2021-01-07 14:55:54',10,0),('1','139',171591,'DAILY SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-07 22:54:47','509','2021-01-07 22:58:21',10,0),('1','139',171936,'DAILY SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-09 17:55:41','509','2021-01-09 17:56:41',10,0),('1','139',171937,'DAILY SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-09 18:11:05','509','2021-01-09 18:11:27',10,0),('1','139',172091,'DAILY SHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-10 21:18:28','509','2021-01-10 21:18:49',10,0),('1','139',172093,'DAILY SHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-10 21:38:21','509','2021-01-10 21:38:49',10,0),('1','139',172285,'DAILY SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-12 14:34:42','509','2021-01-12 14:37:55',10,0),('1','139',172423,'DAILY SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-12 15:13:35','509','2021-01-12 15:14:00',10,0),('1','139',172492,'DAILY SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-12 18:58:22','509','2021-01-12 18:58:43',10,0),('1','139',172689,'DAILY SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-13 18:08:56','509','2021-01-13 18:09:31',10,0),('1','139',172859,'DAILY SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-14 17:51:13','509','2021-01-14 17:51:58',10,0),('1','139',173039,'DAILY SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-15 17:46:14','509','2021-01-15 17:46:40',10,0),('1','139',173199,'DAILY SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-16 18:16:05','509','2021-01-16 18:16:43',10,0),('1','139',173359,'DAILY SHIFT','2021-01-17','2021-01-17 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-18 18:00:53','509','2021-01-18 18:01:11',10,0),('1','139',173578,'DAILY SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-18 18:31:27','509','2021-01-18 18:31:52',10,0),('1','139',173585,'DAILY SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-19 18:54:18','509','2021-01-19 18:54:40',10,0),('1','139',173756,'DAILY SHIFT','2021-01-19','2021-01-19 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-19 19:01:46','509','2021-01-19 19:02:51',10,0),('1','139',173939,'DAILY SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-20 19:36:52','509','2021-01-20 19:37:21',10,0),('1','139',174124,'DAILY SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-21 19:07:29','509','2021-01-21 19:07:54',10,0),('1','139',174299,'DAILY SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-22 17:59:06','509','2021-01-22 17:59:33',10,0),('1','139',174301,'DAILY SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-23 18:49:24','509','2021-01-23 18:49:51',10,0),('1','139',174479,'DAILY SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-23 18:57:18','509','2021-01-23 18:57:52',10,0),('1','139',174615,'DAILY SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-24 18:03:14','509','2021-01-24 18:03:30',10,0),('1','139',174835,'DAILY SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-25 18:49:48','509','2021-01-25 18:50:06',10,0),('1','139',175022,'DAILY SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-26 18:03:27','509','2021-01-26 18:03:51',10,0),('1','139',175027,'DAILY SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-27 19:27:07','509','2021-01-27 19:27:35',10,0),('1','139',175234,'DAILY SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-27 19:33:05','509','2021-01-27 19:33:24',10,0),('1','139',175398,'DAILY SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-28 18:17:54','509','2021-01-28 18:18:12',10,0),('1','139',175581,'DAILY SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-29 18:23:43','509','2021-01-29 18:24:05',10,0),('1','139',175758,'DAILY SHIFT','2021-01-30','2021-01-30 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-30 21:22:38','509','2021-01-30 21:22:56',10,0),('1','139',175903,'DAILY SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'509',0.00,0.00,'509','2021-01-31 17:54:48','509','2021-01-31 17:55:09',10,0),('1','139',175904,'DAILY SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-01 18:51:53','509','2021-02-01 18:52:18',10,0),('1','139',176134,'DAILY SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-01 19:06:02','509','2021-02-01 19:06:27',10,0),('1','139',176308,'DAILY SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-02 18:20:02','509','2021-02-02 18:20:22',10,0),('1','139',176536,'DAILY SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-03 19:42:13','509','2021-02-03 19:42:41',10,0),('1','139',176961,'DAILY SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-05 18:46:32','509','2021-02-05 18:47:00',10,0),('1','139',176965,'DAILY SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-05 19:03:41','509','2021-02-05 19:04:02',10,0),('1','139',176966,'DAILY SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-05 19:13:40','509','2021-02-05 19:14:22',10,0),('1','139',177224,'DAILY SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-06 22:36:09','509','2021-02-06 22:36:32',10,0),('1','139',177565,'DAILY SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-08 15:04:04','509','2021-02-08 15:04:24',10,0),('1','139',177568,'DAILY SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-08 15:08:14','509','2021-02-08 15:08:35',10,0),('1','139',177607,'DAILY SHIFT','2021-02-08','2021-02-08 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-08 18:40:19','509','2021-02-08 18:40:39',10,0),('1','139',177861,'DAILY SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-09 18:35:34','509','2021-02-09 18:35:58',10,0),('1','139',178060,'DAILY SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-10 18:59:09','509','2021-02-10 18:59:33',10,0),('1','139',178284,'DAILY SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-11 20:13:42','509','2021-02-11 20:14:04',10,0),('1','139',178475,'DAILY SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-12 19:20:35','509','2021-02-12 19:20:57',10,0),('1','139',178479,'DAILY SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-12 19:39:45','509','2021-02-12 19:40:08',10,0),('1','139',178698,'DAILY SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-13 18:43:15','509','2021-02-13 18:43:36',10,0),('1','139',178864,'DAILY SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-14 17:32:07','509','2021-02-14 17:34:02',10,0),('1','139',178865,'DAILY SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-14 17:39:57','509','2021-02-14 17:40:23',10,0),('1','139',179102,'DAILY SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-15 18:23:54','509','2021-02-15 18:24:12',10,0),('1','139',179345,'DAILY SHIFT','2021-02-16','2021-02-16 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-16 17:48:51','509','2021-02-16 17:49:25',10,0),('1','139',179418,'DAILY SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-18 18:14:46','509','2021-02-18 18:15:06',10,0),('1','139',179754,'DAILY SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-18 18:19:54','509','2021-02-18 18:20:14',10,0),('1','139',179756,'DAILY SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-18 18:29:40','509','2021-02-18 18:30:10',10,0),('1','139',179978,'DAILY SHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-19 18:10:59','509','2021-02-19 18:11:34',10,0),('1','139',180080,'DAILY SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-20 13:14:18','509','2021-02-20 13:14:44',10,0),('1','139',180143,'DAILY SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-21 12:28:04','509','2021-02-21 12:28:35',10,0),('1','139',180246,'DAILY SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-21 12:31:00','509','2021-02-21 12:31:57',10,0),('1','139',180248,'DAILY SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-21 12:37:05','509','2021-02-21 12:37:24',10,0),('1','139',180296,'DAILY SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-21 16:47:44','509','2021-02-21 16:48:07',10,0),('1','139',180360,'DAILY SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-22 16:23:26','509','2021-02-22 16:33:25',10,0),('1','139',180549,'DAILY SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-23 16:33:24','509','2021-02-23 16:33:58',10,0),('1','139',180740,'DAILY SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-24 17:13:58','509','2021-02-24 17:14:57',10,0),('1','139',180961,'DAILY SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-25 16:16:47','509','2021-02-25 16:18:02',10,0),('1','139',181134,'DAILY SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-26 17:17:21','509','2021-02-26 17:17:53',10,0),('1','139',181361,'DAILY SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-27 17:17:38','509','2021-02-27 17:18:07',10,0),('1','139',181531,'DAILY SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'509',0.00,0.00,'509','2021-02-28 19:09:52','509','2021-02-28 19:10:18',10,0),('1','139',181711,'DAILY SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-01 17:59:20','509','2021-03-01 17:59:44',10,0),('1','139',181907,'DAILY SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-02 18:28:06','509','2021-03-02 18:29:50',10,0),('1','139',182109,'DAILY SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-03 12:34:08','509','2021-03-03 12:34:50',10,0),('1','139',182188,'DAILY SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-03 18:50:21','509','2021-03-03 18:50:55',10,0),('1','139',182315,'DAILY SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-04 19:41:55','509','2021-03-04 19:42:31',10,0),('1','139',182505,'DAILY SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-05 18:50:16','509','2021-03-05 18:50:47',10,0),('1','139',182692,'DAILY SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-11 08:56:59','509','2021-03-11 08:57:23',10,0),('1','139',183678,'DAILY SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-11 09:14:05','509','2021-03-11 09:14:32',10,0),('1','139',183684,'DAILY SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-11 09:22:22','509','2021-03-11 09:22:48',10,0),('1','139',183695,'DAILY SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-11 09:56:55','509','2021-03-11 09:57:16',10,0),('1','139',183703,'DAILY SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-11 10:04:28','509','2021-03-11 10:04:48',10,0),('1','139',183725,'DAILY SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-11 17:26:17','509','2021-03-11 17:26:40',10,0),('1','139',183833,'DAILY SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-11 18:31:19','509','2021-03-11 18:31:38',10,0),('1','139',183953,'DAILY SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-12 10:19:02','509','2021-03-12 10:19:24',10,0),('1','139',183957,'DAILY SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-12 10:29:33','509','2021-03-12 10:29:56',10,0),('1','139',183995,'DAILY SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-13 18:19:46','509','2021-03-13 18:20:26',10,0),('1','139',184282,'DAILY SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-14 17:48:32','509','2021-03-14 17:48:51',10,0),('1','139',184486,'DAILY SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-15 18:13:25','509','2021-03-15 18:14:00',10,0),('1','139',184696,'DAILY SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-16 18:43:24','509','2021-03-16 18:44:01',10,0),('1','139',184899,'DAILY SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-17 13:36:01','509','2021-03-17 13:36:44',10,0),('1','139',185006,'DAILY SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-17 14:46:55','509','2021-03-17 14:47:27',10,0),('1','139',185033,'DAILY SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-17 19:05:37','509','2021-03-17 19:17:46',10,0),('1','139',185109,'DAILY SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-18 17:53:41','509','2021-03-18 17:54:23',10,0),('1','139',185264,'DAILY SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-19 17:31:08','509','2021-03-19 17:31:50',10,0),('1','139',185478,'DAILY SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-20 19:30:51','509','2021-03-20 19:32:49',10,0),('1','139',185693,'DAILY SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-21 18:34:06','509','2021-03-21 18:35:11',10,0),('1','139',185881,'DAILY SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-22 17:55:52','509','2021-03-22 17:56:29',10,0),('1','139',186100,'DAILY SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-23 14:59:13','509','2021-03-23 15:02:30',10,0),('1','139',186241,'DAILY SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-23 15:41:10','509','2021-03-23 15:41:56',10,0),('1','139',186276,'DAILY SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-23 17:56:40','509','2021-03-23 17:57:07',10,0),('1','139',186321,'DAILY SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-24 18:24:19','509','2021-03-24 18:25:15',10,0),('1','139',186534,'DAILY SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-25 18:32:56','509','2021-03-25 18:33:35',10,0),('1','139',186762,'DAILY SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-26 17:20:00','509','2021-03-26 17:20:35',10,0),('1','139',187007,'DAILY SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-27 17:33:29','509','2021-03-27 17:37:04',10,0),('1','139',187167,'DAILY SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-28 17:53:52','509','2021-03-28 17:54:17',10,0),('1','139',187359,'DAILY SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-29 14:09:22','509','2021-03-29 14:09:51',10,0),('1','139',187497,'DAILY SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-29 14:56:23','509','2021-03-29 14:56:46',10,0),('1','139',187507,'DAILY SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-29 18:02:08','509','2021-03-29 18:02:56',10,0),('1','139',187588,'DAILY SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-30 17:33:06','509','2021-03-30 17:33:52',10,0),('1','139',187834,'DAILY SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'509',0.00,0.00,'509','2021-03-31 17:55:20','509','2021-03-31 17:56:10',10,0),('1','139',188028,'DAILY SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-01 17:37:55','509','2021-04-01 17:38:32',10,0),('1','139',188226,'DAILY SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-02 17:33:26','509','2021-04-02 17:35:34',10,0),('1','139',188426,'DAILY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-03 11:13:20','509','2021-04-03 11:13:54',10,0),('1','139',188500,'DAILY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-03 11:55:03','509','2021-04-03 11:55:28',10,0),('1','139',188506,'DAILY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-04 18:18:02','509','2021-04-04 18:18:22',10,0),('1','139',188835,'DAILY SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-05 18:13:07','509','2021-04-05 18:14:48',10,0),('1','139',189018,'DAILY SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-06 17:48:42','509','2021-04-06 17:49:54',10,0),('1','139',189204,'DAILY SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-07 19:08:44','509','2021-04-07 19:09:20',10,0),('1','139',189428,'DAILY SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-08 17:48:56','509','2021-04-08 17:49:21',10,0),('1','139',189627,'DAILY SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-09 09:12:28','509','2021-04-09 09:12:49',10,0),('1','139',189670,'DAILY SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-09 09:33:49','509','2021-04-09 09:34:18',10,0),('1','139',189687,'DAILY SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-09 17:49:16','509','2021-04-09 17:49:48',10,0),('1','139',189846,'DAILY SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-10 17:45:18','509','2021-04-10 17:45:42',10,0),('1','139',190033,'DAILY SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-11 17:41:09','509','2021-04-11 17:41:39',10,0),('1','139',190223,'DAILY SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-12 17:58:24','509','2021-04-12 18:00:41',10,0),('1','139',190448,'DAILY SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-13 18:49:00','509','2021-04-13 18:49:50',10,0),('1','139',190669,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-14 10:52:48','509','2021-04-14 10:53:17',10,0),('1','139',190744,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-14 11:32:30','509','2021-04-14 11:33:02',10,0),('1','139',190755,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-14 17:31:28','509','2021-04-14 17:33:32',10,0),('1','139',190897,'DAILY SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-15 17:46:46','509','2021-04-15 17:47:47',10,0),('1','139',191092,'DAILY SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-16 17:20:28','509','2021-04-16 17:25:15',10,0),('1','139',191300,'DAILY SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-17 18:01:35','509','2021-04-17 18:02:52',10,0),('1','139',191507,'DAILY SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-18 17:36:17','509','2021-04-18 17:36:44',10,0),('1','139',191722,'DAILY SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-19 09:10:14','509','2021-04-19 09:10:48',10,0),('1','139',191759,'DAILY SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-19 17:45:51','509','2021-04-19 17:51:00',10,0),('1','139',191944,'DAILY SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-20 17:29:38','509','2021-04-20 17:30:16',10,0),('1','139',192140,'DAILY SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-21 16:59:23','509','2021-04-21 17:00:40',10,0),('1','139',192346,'DAILY SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-22 16:43:48','509','2021-04-22 16:44:45',10,0),('1','139',192576,'DAILY SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-23 17:34:41','509','2021-04-23 17:36:12',10,0),('1','139',192782,'DAILY SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-24 17:14:56','509','2021-04-24 17:15:47',10,0),('1','139',192913,'DAILY SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-25 08:45:39','509','2021-04-25 08:46:14',10,0),('1','139',192986,'DAILY SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-25 17:08:07','509','2021-04-25 17:09:34',10,0),('1','139',193186,'DAILY SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-26 17:12:49','509','2021-04-26 17:14:11',10,0),('1','139',193411,'DAILY SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-27 17:31:32','509','2021-04-27 17:32:30',10,0),('1','139',193629,'DAILY SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-28 17:43:21','509','2021-04-28 17:44:20',10,0),('1','139',193863,'DAILY SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-29 16:34:08','509','2021-04-29 16:37:26',10,0),('1','139',194085,'DAILY SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'509',0.00,0.00,'509','2021-04-30 17:02:25','509','2021-04-30 17:03:05',10,0),('1','139',194312,'DAILY SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-01 16:59:09','509','2021-05-01 17:09:06',10,0),('1','139',194495,'DAILY SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-02 18:22:55','509','2021-05-02 18:23:24',10,0),('1','139',194652,'DAILY SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-02 20:36:03','509','2021-05-02 20:36:25',10,0),('1','139',194680,'DAILY SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-03 19:40:28','509','2021-05-03 19:43:29',10,0),('1','139',194870,'DAILY SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-04 17:37:28','509','2021-05-04 17:37:53',10,0),('1','139',195086,'DAILY SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-05 17:33:54','509','2021-05-05 17:34:52',10,0),('1','139',195316,'DAILY SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-06 09:59:18','509','2021-05-06 09:59:55',10,0),('1','139',195502,'DAILY SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-06 21:31:34','509','2021-05-06 21:31:54',10,0),('1','139',195549,'DAILY SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-07 17:21:01','509','2021-05-07 17:21:37',10,0),('1','139',195789,'DAILY SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-08 17:10:39','509','2021-05-08 17:11:23',10,0),('1','139',196014,'DAILY SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-09 17:23:06','509','2021-05-09 17:23:37',10,0),('1','139',196254,'DAILY SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-10 17:43:15','509','2021-05-10 17:43:46',10,0),('1','139',196456,'DAILY SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-11 13:12:22','509','2021-05-11 13:14:15',10,0),('1','139',196564,'DAILY SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-11 13:41:37','509','2021-05-11 13:42:04',10,0),('1','139',196585,'DAILY SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-11 17:38:21','509','2021-05-11 17:40:12',10,0),('1','139',196667,'DAILY SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-12 17:10:10','509','2021-05-12 17:10:33',10,0),('1','139',196921,'DAILY SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-13 15:19:04','509','2021-05-13 15:19:34',10,0),('1','139',197117,'DAILY SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-14 16:24:59','509','2021-05-14 16:27:02',10,0),('1','139',197347,'DAILY SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-16 12:53:06','509','2021-05-16 12:53:33',10,0),('1','139',197370,'DAILY SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-16 17:17:19','509','2021-05-16 17:17:58',10,0),('1','139',197514,'DAILY SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-17 19:28:13','509','2021-05-17 19:28:34',10,0),('1','139',197842,'DAILY SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-18 09:08:06','509','2021-05-18 09:08:29',10,0),('1','139',198083,'DAILY SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-18 18:38:10','509','2021-05-18 18:38:49',10,0),('1','139',198127,'DAILY SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-19 17:37:45','509','2021-05-19 17:38:46',10,0),('1','139',198365,'DAILY SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-20 17:17:55','509','2021-05-20 17:18:25',10,0),('1','139',198574,'DAILY SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-21 18:07:31','509','2021-05-21 18:08:10',10,0),('1','139',198790,'DAILY SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-22 17:27:27','509','2021-05-22 17:29:19',10,0),('1','139',198996,'DAILY SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-23 17:24:55','509','2021-05-23 17:25:28',10,0),('1','139',199216,'DAILY SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-24 12:20:12','509','2021-05-24 12:20:41',10,0),('1','139',199374,'Daily shift','2021-05-24','2021-05-24 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-24 15:41:23','509','2021-05-24 15:41:48',10,0),('1','139',199382,'DAILY SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-24 17:38:13','509','2021-05-24 17:38:46',10,0),('1','139',199438,'DAILY SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-25 17:47:40','509','2021-05-25 17:48:13',10,0),('1','139',199672,'DAILY SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-26 17:26:18','509','2021-05-26 17:26:45',10,0),('1','139',199880,'DAILY SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-27 17:31:08','509','2021-05-27 17:31:38',10,0),('1','139',200109,'DAILY SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-28 18:05:53','509','2021-05-28 18:06:20',10,0),('1','139',200337,'DAILY SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-29 17:53:28','509','2021-05-29 17:54:01',10,0),('1','139',200500,'DAILY SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-30 17:52:37','509','2021-05-30 17:53:07',10,0),('1','139',200703,'DAILY SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-31 12:04:52','509','2021-05-31 12:05:12',10,0),('1','139',200803,'DAILY SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-31 12:25:19','509','2021-05-31 12:25:43',10,0),('1','139',200830,'DAILY SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'509',0.00,0.00,'509','2021-05-31 17:26:26','509','2021-05-31 17:27:21',10,0),('1','139',200942,'DAILY SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-01 18:38:43','509','2021-06-01 18:39:13',10,0),('1','139',201130,'DAILY SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-02 18:41:33','509','2021-06-02 18:42:04',10,0),('1','139',201323,'DAILY SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-03 17:44:23','509','2021-06-03 17:44:49',10,0),('1','139',201503,'DAILY SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-04 17:24:10','509','2021-06-04 17:24:35',10,0),('1','139',201772,'DAILY SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-05 12:11:04','509','2021-06-05 12:11:29',10,0),('1','139',201879,'DAILY SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-05 17:42:53','509','2021-06-05 17:43:39',10,0),('1','139',202035,'DAILY SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-06 17:13:09','509','2021-06-06 17:13:57',10,0),('1','139',202316,'DAILY SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-07 18:43:52','509','2021-06-07 18:44:21',10,0),('1','139',202443,'DAILY SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-08 17:45:50','509','2021-06-08 17:47:01',10,0),('1','139',202694,'DAILY SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-09 18:08:52','509','2021-06-09 18:09:25',10,0),('1','139',202861,'DAILY SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-10 10:16:43','509','2021-06-10 10:17:05',10,0),('1','139',202944,'DAILY SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-10 10:34:30','509','2021-06-10 10:34:52',10,0),('1','139',202946,'DAILY SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-10 17:36:52','509','2021-06-11 07:01:42',10,0),('1','139',203120,'DAILY SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-11 19:00:13','509','2021-06-11 19:00:39',10,0),('1','139',203319,'DAILY SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-12 17:50:04','509','2021-06-12 17:50:45',10,0),('1','139',203534,'DAILY SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-13 17:36:13','509','2021-06-13 17:36:41',10,0),('1','139',203745,'DAILY SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-14 16:57:24','509','2021-06-14 16:58:26',10,0),('1','139',203976,'DAILY SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-15 17:20:47','509','2021-06-15 17:21:11',10,0),('1','139',204209,'DAILY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-16 17:36:22','509','2021-06-16 17:37:02',10,0),('1','139',204412,'DAILY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-17 11:43:49','509','2021-06-17 11:45:28',10,0),('1','139',204505,'DAILY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-17 11:59:14','509','2021-06-17 11:59:39',10,0),('1','139',204512,'DAILY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-17 17:58:13','509','2021-06-17 17:58:42',10,0),('1','139',204632,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-18 18:11:54','509','2021-06-18 18:12:31',10,0),('1','139',204875,'DAILY SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-19 17:50:20','509','2021-06-19 17:50:49',10,0),('1','139',205052,'DAILY SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-20 17:56:11','509','2021-06-20 17:56:52',10,0),('1','139',205265,'DAILY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-21 15:17:24','509','2021-06-21 15:17:50',10,0),('1','139',205405,'DAILY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-21 16:16:11','509','2021-06-21 16:16:43',10,0),('1','139',205416,'DAILY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-21 19:25:44','509','2021-06-21 19:26:19',10,0),('1','139',205527,'DAILY SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-22 17:50:55','509','2021-06-22 17:51:39',10,0),('1','139',205733,'DAILY SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-23 17:43:37','509','2021-06-23 17:44:12',10,0),('1','139',205958,'DAILY SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-24 18:02:43','509','2021-06-24 18:03:18',10,0),('1','139',206157,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-25 18:08:09','509','2021-06-25 18:08:32',10,0),('1','139',206411,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-26 14:02:02','509','2021-06-26 14:02:38',10,0),('1','139',206498,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-26 14:23:06','509','2021-06-26 14:23:34',10,0),('1','139',206508,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-26 18:29:50','509','2021-06-26 18:30:18',10,0),('1','139',206582,'DAILY SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-27 17:51:23','509','2021-06-27 17:51:51',10,0),('1','139',206814,'DAILY SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-28 18:19:39','509','2021-06-28 18:20:13',10,0),('1','139',207036,'DAILY SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-29 17:40:05','509','2021-06-29 17:40:34',10,0),('1','139',207259,'DAILY SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'509',0.00,0.00,'509','2021-06-30 17:45:27','509','2021-06-30 17:46:16',10,0),('1','139',207483,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-01 16:03:32','509','2021-07-01 16:04:11',10,0),('1','139',207643,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-01 16:16:11','509','2021-07-01 16:16:37',10,0),('1','139',207654,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-01 17:46:43','509','2021-07-01 17:47:23',10,0),('1','139',207721,'DAILY SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-02 18:02:58','509','2021-07-02 18:03:36',10,0),('1','139',207940,'DAILY SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-03 18:28:48','509','2021-07-03 18:29:33',10,0),('1','139',208117,'DAILY SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-04 18:04:55','509','2021-07-04 18:05:28',10,0),('1','139',208342,'DAILY SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-05 17:57:18','509','2021-07-05 17:57:47',10,0),('1','139',208549,'DAILY SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-06 17:57:22','509','2021-07-06 17:57:50',10,0),('1','139',208767,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-07 17:46:28','509','2021-07-07 17:46:53',10,0),('1','139',208954,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-08 07:00:51','509','2021-07-08 07:04:17',10,0),('1','139',209009,'DAILY SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-08 18:01:18','509','2021-07-08 18:01:47',10,0),('1','139',209253,'DAILY SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-09 17:45:52','509','2021-07-09 17:47:37',10,0),('1','139',209486,'DAILY SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-10 18:27:28','509','2021-07-10 18:28:58',10,0),('1','139',209665,'DAILY SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-11 18:07:02','509','2021-07-11 18:10:00',10,0),('1','139',209879,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-12 18:10:07','509','2021-07-12 18:10:45',10,0),('1','139',210137,'DAILY SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-13 11:47:46','509','2021-07-13 11:48:18',10,0),('1','139',210206,'DAILY SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-15 09:32:31','509','2021-07-15 09:33:12',10,0),('1','139',210574,'DAILY SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-15 19:03:05','509','2021-07-15 19:04:05',10,0),('1','139',210735,'DAILY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-16 17:56:45','509','2021-07-16 17:57:17',10,0),('1','139',210961,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-17 18:06:18','509','2021-07-17 18:08:05',10,0),('1','139',211173,'DAILY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-19 08:22:50','509','2021-07-19 08:24:24',10,0),('1','139',211429,'DAILY SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-19 20:16:51','509','2021-07-19 20:28:18',10,0),('1','139',211667,'DAILY SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-20 13:32:44','509','2021-07-20 13:33:10',10,0),('1','139',211684,'DAILY SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-20 17:07:50','509','2021-07-20 17:08:24',10,0),('1','139',211822,'DAILY SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-21 17:13:30','509','2021-07-21 17:14:13',10,0),('1','139',212003,'DAILY SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-22 17:51:19','509','2021-07-22 17:53:23',10,0),('1','139',212241,'DAILY SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-23 17:44:50','509','2021-07-23 17:55:04',10,0),('1','139',212463,'DAILY SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-25 06:52:20','509','2021-07-25 06:56:26',10,0),('1','139',212676,'DAILY SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-25 17:37:08','509','2021-07-25 17:38:06',10,0),('1','139',212889,'DAILY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-26 14:29:41','509','2021-07-26 14:30:24',10,0),('1','139',213033,'DAILY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-26 14:47:19','509','2021-07-26 14:47:47',10,0),('1','139',213141,'DAILY SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-27 18:15:57','509','2021-07-27 18:17:17',10,0),('1','139',213399,'DAILY SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-28 18:02:43','509','2021-07-28 18:03:43',10,0),('1','139',213639,'DAILY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-29 18:05:03','509','2021-07-29 18:06:05',10,0),('1','139',213896,'DAILY SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-30 17:50:51','509','2021-07-30 17:53:05',10,0),('1','139',214150,'DAILY SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-31 18:24:08','509','2021-07-31 18:24:59',10,0),('1','139',214288,'DAILY SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'509',0.00,0.00,'509','2021-07-31 18:29:08','509','2021-07-31 18:29:33',10,0),('1','139',214354,'DAILY SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-01 18:37:58','509','2021-08-01 18:38:32',10,0),('1','139',214545,'DAILY SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-02 18:33:59','509','2021-08-02 18:37:07',10,0),('1','139',214785,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-03 19:04:26','509','2021-08-03 19:07:37',10,0),('1','139',215324,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-05 18:42:40','509','2021-08-05 18:43:08',10,0),('1','139',215453,'DAILY SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-06 18:13:07','509','2021-08-06 18:14:34',10,0),('1','139',215685,'DAILY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-07 18:48:53','509','2021-08-07 18:49:28',10,0),('1','139',215921,'DAILY SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-08 18:04:46','509','2021-08-08 18:05:20',10,0),('1','139',216060,'DAILY SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-08 18:12:45','509','2021-08-08 18:13:11',10,0),('1','139',216113,'DAILY SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-09 18:23:24','509','2021-08-09 18:23:59',10,0),('1','139',216337,'DAILY SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-10 18:17:08','509','2021-08-10 18:19:29',10,0),('1','139',216563,'DAILY SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-11 18:00:05','509','2021-08-11 18:00:30',10,0),('1','139',216799,'DAILY SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-12 17:57:30','509','2021-08-12 17:58:20',10,0),('1','139',217032,'DAILY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-13 18:19:00','509','2021-08-13 18:19:31',10,0),('1','139',217285,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-14 18:03:10','509','2021-08-14 18:06:19',10,0),('1','139',217465,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-14 18:15:22','509','2021-08-14 18:16:12',10,0),('1','139',217860,'DAILY SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-16 18:51:43','509','2021-08-16 18:52:38',10,0),('1','139',217994,'DAILY SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-17 18:06:19','509','2021-08-17 18:07:17',10,0),('1','139',218235,'DAILY SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-18 17:46:14','509','2021-08-18 17:47:08',10,0),('1','139',218443,'DAILY SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-19 18:10:13','509','2021-08-19 18:11:09',10,0),('1','139',218690,'DAILY SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-20 18:28:11','509','2021-08-20 18:28:58',10,0),('1','139',218915,'DAILY SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-21 14:13:43','509','2021-08-21 14:14:19',10,0),('1','139',219049,'DAILY SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-21 14:35:46','509','2021-08-21 14:36:33',10,0),('1','139',219074,'DAILY SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-23 06:21:20','509','2021-08-23 06:22:12',10,0),('1','139',219338,'DAILY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-23 22:09:24','509','2021-08-23 22:10:54',10,0),('1','139',219606,'DAILY SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-24 22:06:24','509','2021-08-24 22:07:10',10,0),('1','139',219818,'DAILY SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-25 22:51:51','509','2021-08-25 22:52:25',10,0),('1','139',220045,'DAILY SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-26 21:39:29','509','2021-08-26 21:40:14',10,0),('1','139',220270,'DAILY SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-28 09:08:34','509','2021-08-28 09:09:05',10,0),('1','139',220528,'DAILY SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-29 11:57:18','509','2021-08-29 12:09:18',10,0),('1','139',220775,'DAILY SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-29 12:55:55','509','2021-08-29 12:57:33',10,0),('1','139',220788,'DAILY SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-29 18:04:55','509','2021-08-29 18:05:35',10,0),('1','139',220924,'DAILY SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-30 19:28:26','509','2021-08-30 19:30:25',10,0),('1','139',221154,'DAILY SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'509',0.00,0.00,'509','2021-08-31 18:31:56','509','2021-08-31 18:34:48',10,0),('1','139',221406,'DAILY SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-01 18:17:07','509','2021-09-01 18:18:54',10,0),('1','139',221625,'DAILY SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-02 11:23:06','509','2021-09-02 11:23:53',10,0),('1','139',221713,'DAILY SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-02 11:39:15','509','2021-09-02 11:39:42',10,0),('1','139',221794,'DAILY SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-02 18:04:26','509','2021-09-02 18:05:12',10,0),('1','139',221850,'DAILY SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-03 18:44:27','509','2021-09-03 18:46:53',10,0),('1','139',222066,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-04 18:27:23','509','2021-09-04 18:29:13',10,0),('1','139',222279,'DAILY SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-05 18:12:27','509','2021-09-05 18:13:05',10,0),('1','139',222511,'DAILY SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-08 15:17:17','509','2021-09-08 15:18:11',10,0),('1','139',223110,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-08 15:24:16','509','2021-09-08 15:24:44',10,0),('1','139',223118,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-09 06:52:14','509','2021-09-09 06:53:11',10,0),('1','139',223187,'DAILY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-09 18:50:34','509','2021-09-09 18:51:59',10,0),('1','139',223423,'DAILY SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-10 18:21:01','509','2021-09-10 18:23:30',10,0),('1','139',223646,'DAILY SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-11 17:51:49','509','2021-09-11 17:53:46',10,0),('1','139',223879,'DAILY SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-12 12:52:41','509','2021-09-12 12:53:19',10,0),('1','139',224146,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-13 10:05:43','509','2021-09-13 10:06:09',10,0),('1','139',224165,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-13 20:11:03','509','2021-09-13 20:12:08',10,0),('1','139',224336,'DAILY SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-14 18:35:21','509','2021-09-14 18:36:24',10,0),('1','139',224533,'DAILY SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-15 18:37:31','509','2021-09-15 18:38:47',10,0),('1','139',224783,'DAILY SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-16 18:09:05','509','2021-09-16 18:09:37',10,0),('1','139',225026,'DAILY SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-17 12:01:21','509','2021-09-17 12:02:44',10,0),('1','139',225129,'DAILY SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-17 14:43:33','509','2021-09-17 14:44:10',10,0),('1','139',225184,'DAILY SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-17 18:13:18','509','2021-09-17 18:14:02',10,0),('1','139',225274,'DAILY SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-18 18:44:34','509','2021-09-18 18:47:15',10,0),('1','139',225486,'DAILY SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-19 17:59:09','509','2021-09-19 18:00:04',10,0),('1','139',225703,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-20 18:06:33','509','2021-09-20 18:07:48',10,0),('1','139',225984,'DAILY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-21 18:08:29','509','2021-09-21 18:10:53',10,0),('1','139',226231,'DAILY SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-22 18:54:25','509','2021-09-22 18:55:42',10,0),('1','139',226491,'DAILY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-23 14:13:40','509','2021-09-23 14:29:37',10,0),('1','139',226648,'DAILY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-23 14:51:12','509','2021-09-23 14:51:50',10,0),('1','139',226735,'DAILY SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-24 18:32:11','509','2021-09-24 18:34:50',10,0),('1','139',227026,'DAILY SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-25 18:01:54','509','2021-09-25 18:03:07',10,0),('1','139',227192,'DAILY SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-26 18:05:21','509','2021-09-26 18:07:00',10,0),('1','139',227381,'DAILY SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-27 18:22:03','509','2021-09-27 18:23:41',10,0),('1','139',227615,'DAILY SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-28 10:04:36','509','2021-09-28 10:05:06',10,0),('1','139',227756,'Daily shift ','2021-09-28','2021-09-28 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-28 13:41:23','509','2021-09-28 13:41:52',10,0),('1','139',227832,'DAILY SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-30 19:23:11','509','2021-09-30 19:23:53',10,0),('1','139',228320,'DAILY SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-30 19:55:59','509','2021-09-30 19:56:54',10,0),('1','139',228325,'DAILY SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'509',0.00,0.00,'509','2021-09-30 20:16:03','509','2021-09-30 20:16:45',10,0),('1','139',228357,'DAILY SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-01 18:48:31','509','2021-10-01 18:49:32',10,0),('1','139',228539,'DAILY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-02 17:48:03','509','2021-10-02 17:52:19',10,0),('1','139',228757,'DAILY SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-03 20:51:33','509','2021-10-03 20:52:14',10,0),('1','139',228919,'DAILY SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-04 06:41:20','509','2021-10-04 06:41:59',10,0),('1','139',228951,'DAILY SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-04 19:18:40','509','2021-10-04 19:20:09',10,0),('1','139',229174,'DAILY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-06 09:29:31','509','2021-10-06 09:30:26',10,0),('1','139',229485,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-06 18:45:36','509','2021-10-06 18:46:21',10,0),('1','139',229633,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-06 19:20:22','509','2021-10-06 19:20:51',10,0),('1','139',229670,'DAILY SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-07 19:51:02','509','2021-10-07 19:52:28',10,0),('1','139',229910,'DAILY SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-08 19:21:58','509','2021-10-08 19:24:13',10,0),('1','139',230098,'DAILY SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-09 17:50:50','509','2021-10-09 17:51:32',10,0),('1','139',230455,'DAILY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-10 20:21:11','509','2021-10-10 20:21:46',10,0),('1','139',230539,'DAILY SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-11 20:29:35','509','2021-10-11 20:31:06',10,0),('1','139',230796,'DAILY SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-12 19:17:40','509','2021-10-12 19:27:17',10,0),('1','139',231076,'DAILY SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-13 18:18:54','509','2021-10-13 18:20:31',10,0),('1','139',231379,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-14 10:34:02','509','2021-10-14 10:34:47',10,0),('1','139',231805,'DAILY SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-15 14:39:36','509','2021-10-15 14:40:06',10,0),('1','139',231910,'DAILY SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-16 18:23:06','509','2021-10-16 18:25:32',10,0),('1','139',232109,'DAILY SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-17 19:05:48','509','2021-10-17 19:08:33',10,0),('1','139',232352,'DAILY SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-18 18:54:45','509','2021-10-18 18:59:51',10,0),('1','139',232602,'DAILY SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-19 18:15:17','509','2021-10-19 18:20:05',10,0),('1','139',232862,'DAILY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-20 16:32:25','509','2021-10-20 16:34:17',10,0),('1','139',233287,'DAILY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-21 14:59:56','509','2021-10-21 15:00:59',10,0),('1','139',233396,'DAILY SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-22 18:02:54','509','2021-10-22 18:05:10',10,0),('1','139',233623,'DAILY SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-23 18:35:42','509','2021-10-23 18:38:32',10,0),('1','139',233857,'DAILY SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-24 17:45:57','509','2021-10-24 17:47:42',10,0),('1','139',234069,'DAILY SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-25 17:54:58','509','2021-10-25 17:56:43',10,0),('1','139',234322,'DAILY SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-26 17:56:15','509','2021-10-26 17:57:57',10,0),('1','139',234572,'DAILY SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-27 18:36:19','509','2021-10-27 18:39:49',10,0),('1','139',234773,'DAILY SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-28 06:33:55','509','2021-10-28 06:34:57',10,0),('1','139',234844,'DAILY SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-28 18:22:29','509','2021-10-28 18:26:20',10,0),('1','139',235080,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-29 18:30:19','509','2021-10-29 18:31:46',10,0),('1','139',235376,'DAILY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-30 17:43:35','509','2021-10-30 17:45:48',10,0),('1','139',235548,'DAILY SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'509',0.00,0.00,'509','2021-10-31 18:37:42','509','2021-10-31 18:39:14',10,0),('1','139',235770,'DAILY SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-02 06:20:52','509','2021-11-02 06:22:40',10,0),('1','139',236043,'DAILY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-02 18:03:51','509','2021-11-02 18:10:19',10,0),('1','139',236246,'DAILY SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-03 15:33:50','509','2021-11-03 15:37:32',10,0),('1','139',236615,'DAILY SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-04 11:53:14','509','2021-11-04 11:53:35',10,0),('1','139',236623,'DAILY SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-04 18:33:05','509','2021-11-04 18:33:40',10,0),('1','139',236751,'DAILY SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-05 18:28:56','509','2021-11-05 18:29:25',10,0),('1','139',236975,'DAILY SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-06 18:10:14','509','2021-11-06 18:11:35',10,0),('1','139',237236,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-07 09:28:30','509','2021-11-07 09:29:36',10,0),('1','139',237242,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-08 06:50:16','509','2021-11-08 06:50:37',10,0),('1','139',237406,'DAILY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-08 17:36:07','509','2021-11-08 17:37:03',10,0),('1','139',237628,'DAILY SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-09 19:36:15','509','2021-11-09 19:36:45',10,0),('1','139',237887,'DAILY SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-10 18:23:26','509','2021-11-10 18:23:58',10,0),('1','139',238123,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-11 12:49:40','509','2021-11-11 12:50:04',10,0),('1','139',238251,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-11 12:54:21','509','2021-11-11 12:54:51',10,0),('1','139',238275,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-11 18:21:06','509','2021-11-11 18:21:31',10,0),('1','139',238363,'DAILY SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-12 18:02:34','509','2021-11-12 18:03:01',10,0),('1','139',238614,'DAILY SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-13 18:12:30','509','2021-11-13 18:12:59',10,0),('1','139',238840,'DAILY SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-14 17:36:47','509','2021-11-14 17:37:20',10,0),('1','139',239076,'DAILY SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-15 18:09:20','509','2021-11-15 18:10:04',10,0),('1','139',239307,'DAILY SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-16 12:55:17','509','2021-11-16 12:55:43',10,0),('1','139',239441,'DAILY SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-16 15:03:56','509','2021-11-16 15:04:13',10,0),('1','139',239445,'DAILY SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-16 17:57:25','509','2021-11-16 17:58:06',10,0),('1','139',239544,'DAILY SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-17 17:40:25','509','2021-11-17 17:41:14',10,0),('1','139',239787,'DAILY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-18 17:56:00','509','2021-11-18 17:57:04',10,0),('1','139',240000,'DAILY SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-19 17:40:06','509','2021-11-19 17:41:26',10,0),('1','139',240208,'DAILY SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-20 17:50:38','509','2021-11-20 17:51:11',10,0),('1','139',240463,'DAILY SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-21 17:44:59','509','2021-11-21 17:45:27',10,0),('1','139',240708,'DAILY SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-22 10:37:58','509','2021-11-22 10:38:24',10,0),('1','139',240791,'DAILY SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-22 11:08:50','509','2021-11-22 11:09:11',10,0),('1','139',240794,'DAILY SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-22 17:31:54','509','2021-11-22 17:35:03',10,0),('1','139',240982,'DAILY SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-23 17:33:39','509','2021-11-23 17:34:28',10,0),('1','139',241236,'DAILY SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-24 17:39:25','509','2021-11-24 17:40:11',10,0),('1','139',241504,'DAILY SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-25 17:31:35','509','2021-11-25 17:32:08',10,0),('1','139',241752,'DAILY SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-26 17:25:07','509','2021-11-26 17:27:07',10,0),('1','139',242043,'DAILY SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-27 17:39:38','509','2021-11-27 17:40:03',10,0),('1','139',242219,'DAILY SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-28 17:35:07','509','2021-11-28 17:36:23',10,0),('1','139',242451,'DAILY SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-29 17:36:04','509','2021-11-29 17:36:44',10,0),('1','139',242698,'DAILY SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-30 12:09:26','509','2021-11-30 12:11:13',10,0),('1','139',242793,'DAILY SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-30 12:15:39','509','2021-11-30 12:16:37',10,0),('1','139',242796,'DAILY SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'509',0.00,0.00,'509','2021-11-30 17:39:32','509','2021-11-30 17:40:10',10,0),('1','139',242940,'DAILY SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-01 18:04:38','509','2021-12-01 18:05:10',10,0),('1','139',243154,'DAILY SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-02 17:49:28','509','2021-12-02 17:50:46',10,0),('1','139',243379,'DAILY SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-03 17:29:11','509','2021-12-03 17:30:04',10,0),('1','139',243605,'DAILY SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-04 11:49:16','509','2021-12-04 11:50:14',10,0),('1','139',243694,'DAILY SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-04 11:55:27','509','2021-12-04 11:56:01',10,0),('1','139',244154,'DAILY SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-06 18:28:08','509','2021-12-06 18:28:52',10,0),('1','139',244304,'DAILY SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-07 18:07:39','509','2021-12-07 18:08:30',10,0),('1','139',244525,'DAILY SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-08 18:07:44','509','2021-12-08 18:12:02',10,0),('1','139',244752,'DAILY SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-09 17:49:15','509','2021-12-09 17:50:02',10,0),('1','139',244982,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-10 18:01:48','509','2021-12-10 18:02:52',10,0),('1','139',245219,'DAILY SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-12 06:01:53','509','2021-12-12 06:02:31',10,0),('1','139',245438,'Daily shift ','2021-12-12','2021-12-12 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-12 08:14:38','509','2021-12-12 08:15:11',10,0),('1','139',245492,'DAILY SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-12 17:49:26','509','2021-12-12 17:50:10',10,0),('1','139',245680,'DAILY SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-13 18:10:20','509','2021-12-13 18:11:30',10,0),('1','139',245941,'DAILY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-14 18:01:14','509','2021-12-14 18:02:00',10,0),('1','139',246195,'DAILY SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-15 17:51:02','509','2021-12-15 17:51:42',10,0),('1','139',246462,'DAILY SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-16 18:49:33','509','2021-12-16 18:50:05',10,0),('1','139',246651,'DAILY SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-17 06:22:15','509','2021-12-17 06:22:41',10,0),('1','139',246713,'DAILY SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-17 18:30:07','509','2021-12-17 18:30:43',10,0),('1','139',246936,'DAILY SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-18 17:40:37','509','2021-12-18 17:41:30',10,0),('1','139',247174,'DAILY SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-19 17:46:23','509','2021-12-19 17:46:55',10,0),('1','139',247405,'DAILY SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-20 18:04:47','509','2021-12-20 18:05:41',10,0),('1','139',247669,'DAILY SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-21 18:26:42','509','2021-12-21 18:27:53',10,0),('1','139',247919,'DAILY SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-22 09:52:28','509','2021-12-22 09:53:01',10,0),('1','139',248003,'DAILY SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-22 14:16:58','509','2021-12-22 14:17:34',10,0),('1','139',248063,'DAILY SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-22 17:50:49','509','2021-12-22 17:52:19',10,0),('1','139',248165,'DAILY SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-23 17:41:11','509','2021-12-23 17:41:45',10,0),('1','139',248413,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-24 18:13:12','509','2021-12-24 18:14:07',10,0),('1','139',248648,'DAILY SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-25 17:32:42','509','2021-12-25 17:33:34',10,0),('1','139',248862,'DAILY SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-26 17:36:22','509','2021-12-26 17:36:59',10,0),('1','139',249113,'DAILY SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-27 17:25:53','509','2021-12-27 17:27:14',10,0),('1','139',249348,'DAILY SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-28 17:22:21','509','2021-12-28 17:22:53',10,0),('1','139',249600,'DAILY SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-29 17:14:45','509','2021-12-29 17:15:23',10,0),('1','139',249866,'DAILY SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-30 17:43:15','509','2021-12-30 17:44:38',10,0),('1','139',250112,'DAILY SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-31 11:29:23','509','2021-12-31 11:29:57',10,0),('1','139',250205,'DAILY SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-31 15:04:29','509','2021-12-31 15:04:58',10,0),('1','139',250245,'DAILY SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'509',0.00,0.00,'509','2021-12-31 17:39:26','509','2021-12-31 17:40:29',10,0),('1','139',250354,'DAILY SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-01 17:34:21','509','2022-01-01 17:37:34',10,0),('1','139',250576,'DAILY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-02 17:48:51','509','2022-01-02 17:51:09',10,0),('1','139',250823,'DAILY SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-03 17:54:01','509','2022-01-03 17:54:45',10,0),('1','139',251042,'DAILY SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-04 18:05:58','509','2022-01-04 18:06:31',10,0),('1','139',251292,'DAILY SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-05 17:10:57','509','2022-01-05 17:14:46',10,0),('1','139',251677,'Daily shift ','2022-01-06','2022-01-06 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-06 16:28:09','509','2022-01-06 16:28:32',10,0),('1','139',251683,'DAILY SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-06 18:36:27','509','2022-01-06 18:36:59',10,0),('1','139',251784,'DAILY SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-07 18:47:26','509','2022-01-07 18:48:36',10,0),('1','139',252011,'DAILY SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-08 19:22:04','509','2022-01-08 19:22:50',10,0),('1','139',252257,'DAILY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-09 18:42:35','509','2022-01-09 18:43:15',10,0),('1','139',252492,'DAILY SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-10 19:11:42','509','2022-01-10 19:12:57',10,0),('1','139',252733,'DAILY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-11 11:42:52','509','2022-01-11 11:48:47',10,0),('1','139',252820,'Daily shifts ','2022-01-11','2022-01-11 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-11 13:18:22','509','2022-01-11 13:18:45',10,0),('1','139',252841,'DAILY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-11 19:12:46','509','2022-01-11 19:15:35',10,0),('1','139',252986,'DAILY SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-12 18:57:02','509','2022-01-12 19:03:07',10,0),('1','139',253227,'DAILY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-13 19:24:58','509','2022-01-13 19:27:06',10,0),('1','139',253495,'DAILY SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-14 18:41:41','509','2022-01-14 18:46:29',10,0),('1','139',253730,'DAILY SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-15 12:41:43','509','2022-01-15 12:42:12',10,0),('1','139',253896,'Daily shift ','2022-01-15','2022-01-15 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-16 09:21:58','509','2022-01-16 09:23:19',10,0),('1','139',254005,'DAILY SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-16 19:04:46','509','2022-01-16 19:06:25',10,0),('1','139',254228,'DAILY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-17 19:26:11','509','2022-01-17 19:27:36',10,0),('1','139',254464,'DAILY SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-18 19:01:47','509','2022-01-18 19:03:55',10,0),('1','139',254718,'DAILY SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-19 19:07:06','509','2022-01-19 19:07:43',10,0),('1','139',254969,'DAILY SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-20 18:55:53','509','2022-01-20 19:02:32',10,0),('1','139',255199,'DAILY SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-21 18:48:55','509','2022-01-21 18:54:07',10,0),('1','139',255491,'DAILY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-22 11:09:27','509','2022-01-22 11:10:28',10,0),('1','139',255555,'DAILY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-22 11:54:45','509','2022-01-22 11:56:45',10,0),('1','139',255564,'DAILY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-22 19:04:25','509','2022-01-22 19:08:05',10,0),('1','139',255720,'DAILY SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-23 18:47:49','509','2022-01-23 18:49:25',10,0),('1','139',255966,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-24 19:05:00','509','2022-01-24 19:06:20',10,0),('1','139',256231,'DAILY SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-25 19:00:48','509','2022-01-25 19:02:18',10,0),('1','139',256503,'DAILY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-26 19:30:30','509','2022-01-26 19:44:25',10,0),('1','139',256738,'DAILY SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-27 19:44:48','509','2022-01-27 19:46:10',10,0),('1','139',256905,'DAILY SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-28 07:47:43','509','2022-01-28 07:48:04',10,0),('1','139',256985,'DAILY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-28 19:43:46','509','2022-01-28 19:44:23',10,0),('1','139',257292,'DAILY SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-29 18:54:38','509','2022-01-29 18:56:08',10,0),('1','139',257505,'DAILY SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-30 19:00:06','509','2022-01-30 19:03:17',10,0),('1','139',257506,'DAILY SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'509',0.00,0.00,'509','2022-01-31 19:07:23','509','2022-01-31 19:07:47',10,0),('1','139',257507,'DAILY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-01 19:18:08','509','2022-02-01 19:18:33',10,0),('1','139',257508,'DAILY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-02 07:39:44','509','2022-02-02 07:40:06',10,0),('1','139',257509,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-02 20:14:47','509','2022-02-02 20:15:08',10,0),('1','139',257510,'DAILY SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-05 19:06:26','509','2022-02-05 19:06:50',10,0),('1','139',257511,'DAILY SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-06 18:57:08','509','2022-02-06 18:57:48',10,0),('1','139',257512,'DAILY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-07 19:11:09','509','2022-02-07 19:11:44',10,0),('1','139',257513,'DAILY SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-08 18:25:27','509','2022-02-08 18:25:51',10,0),('1','139',257514,'DAILY SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-08 19:20:14','509','2022-02-08 19:20:43',10,0),('1','139',257515,'DAILY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-09 19:13:09','509','2022-02-09 19:13:38',10,0),('1','139',257516,'DAILY SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-10 18:49:09','509','2022-02-10 18:50:15',10,0),('1','139',257517,'DAILY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-11 19:04:36','509','2022-02-11 19:05:00',10,0),('1','139',257518,'DAILY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-12 19:01:09','509','2022-02-12 19:04:40',10,0),('1','139',257519,'DAILY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-13 18:48:08','509','2022-02-13 18:48:36',10,0),('1','139',257520,'DAILY SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-14 18:54:30','509','2022-02-14 18:54:48',10,0),('1','139',257521,'DAILY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-15 14:38:25','509','2022-02-15 14:39:31',10,0),('1','139',257522,'DAILY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-15 15:48:26','509','2022-02-15 15:48:47',10,0),('1','139',257523,'DAILY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-15 19:22:36','509','2022-02-15 19:23:10',10,0),('1','139',257524,'DAILY SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-16 19:10:55','509','2022-02-16 19:11:30',10,0),('1','139',257525,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-17 18:42:40','509','2022-02-17 18:43:03',10,0),('1','139',257526,'DAILY SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-18 18:49:03','509','2022-02-18 18:49:32',10,0),('1','139',257527,'DAILY SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-19 18:50:18','509','2022-02-19 18:50:53',10,0),('1','139',257528,'DAILY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-20 19:02:09','509','2022-02-20 19:02:30',10,0),('1','139',257529,'DAILY SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'509',0.00,0.00,'509','2022-02-21 18:46:58','509','2022-02-21 18:47:47',10,0),('1','139',257530,'DAILY SHIFT','2022-02-22','2022-02-22 07:45:18','2022-02-23 07:45:18','509',0.00,0.00,'509','2022-02-22 18:52:52','509','2022-02-22 18:53:11',10,0),('1','139',257531,'DAILY SHIFT','2022-02-23','2022-02-23 07:43:11','2022-02-24 07:43:11','509',0.00,0.00,'509','2022-02-23 11:45:55','509','2022-02-23 11:46:18',10,0),('1','139',257532,'DAILY SHIFT','2022-02-23','2022-02-23 11:46:54','2022-02-24 11:46:54','509',0.00,0.00,'509','2022-02-23 14:48:25','509','2022-02-23 14:48:42',10,0),('1','139',257533,'DAILY SHIFT','2022-02-23','2022-02-23 14:49:03','2022-02-24 14:49:03','509',0.00,0.00,'509','2022-02-23 19:02:14','509','2022-02-23 19:02:52',10,0),('1','139',257534,'DAILY SHIFT','2022-02-24','2022-02-24 07:42:50','2022-02-25 07:42:50','509',0.00,0.00,'509','2022-02-24 18:51:51','509','2022-02-24 18:52:11',10,0),('1','139',257535,'DAILY SHIFT','2022-02-25','2022-02-25 07:39:42','2022-02-26 07:39:42','509',0.00,0.00,'509','2022-02-25 18:47:45','509','2022-02-25 18:48:16',10,0),('1','139',257536,'DAILY SHIFT','2022-02-26','2022-02-26 10:04:57','2022-02-27 10:04:57','509',0.00,0.00,'509','2022-02-26 18:55:03','509','2022-02-26 18:55:24',10,0),('1','139',257537,'DAILY SHIFT','2022-02-27','2022-02-27 08:04:23','2022-02-28 08:04:23','509',0.00,0.00,'509','2022-02-27 18:45:15','509','2022-02-27 18:46:22',10,0),('1','139',257538,'DAILY SHIFT','2022-02-28','2022-02-28 07:41:22','2022-03-01 07:41:22','509',0.00,0.00,'509','2022-02-28 18:51:45','509','2022-02-28 18:52:02',10,0),('1','139',257539,'DAILY SHIFT','2022-03-01','2022-03-01 07:47:45','2022-03-02 07:47:45','509',0.00,0.00,'509','2022-03-01 19:11:27','509','2022-03-01 19:12:07',10,0),('1','139',257540,'DAILY SHIFT','2022-03-02','2022-03-02 07:35:55','2022-03-03 07:35:55','509',0.00,0.00,'509','2022-03-02 18:41:17','509','2022-03-02 18:41:37',10,0),('1','139',257541,'DAILY SHIFT','2022-03-03','2022-03-03 07:43:29','2022-03-04 07:43:29','509',0.00,0.00,'509','2022-03-03 14:42:12','509','2022-03-03 14:42:35',10,0),('1','139',257542,'DAILY SHIFT','2022-03-03','2022-03-03 14:53:10','2022-03-04 14:53:10','509',0.00,0.00,'509','2022-03-03 15:09:30','509','2022-03-03 15:09:55',10,0),('1','139',257543,'DAILY SHIFT','2022-03-03','2022-03-03 15:10:30','2022-03-04 15:10:30','509',0.00,0.00,'509','2022-03-03 19:09:06','509','2022-03-03 19:09:23',10,0),('1','139',257544,'DAILY SHIFT','2022-03-04','2022-03-04 07:49:12','2022-03-05 07:49:12','509',0.00,0.00,'509','2022-03-04 18:57:10','509','2022-03-04 18:57:32',10,0),('1','139',257545,'DAILY SHIFT','2022-03-05','2022-03-05 07:34:55','2022-03-06 07:34:55','509',0.00,0.00,'509','2022-03-05 18:59:20','509','2022-03-05 18:59:51',10,0),('1','139',257546,'DAILY SHIFT','2022-03-06','2022-03-06 07:31:36','2022-03-07 07:31:36','509',0.00,0.00,'509','2022-03-06 18:51:02','509','2022-03-06 18:51:48',10,0),('1','139',257547,'DAILY SHIFT','2022-03-07','2022-03-07 07:38:48','2022-03-08 07:38:48','509',0.00,0.00,'509','2022-03-07 19:31:38','509','2022-03-07 19:31:59',10,0),('1','139',257548,'DAILY SHIFT','2022-03-08','2022-03-08 07:40:32','2022-03-09 07:40:32','509',0.00,0.00,'509','2022-03-08 19:37:52','509','2022-03-08 19:39:45',10,0),('1','139',257549,'DAILY SHIFT','2022-03-09','2022-03-09 07:25:38','2022-03-10 07:25:38','509',0.00,0.00,'509','2022-03-09 19:13:42','509','2022-03-09 19:14:04',10,0),('1','139',257550,'DAILY SHIFT','2022-03-10','2022-03-10 07:37:21','2022-03-11 07:37:21','509',0.00,0.00,'509','2022-03-10 19:51:31','509','2022-03-10 19:51:57',10,0),('1','139',257551,'DAILY SHIFT','2022-03-11','2022-03-11 07:33:53','2022-03-12 07:33:53','509',0.00,0.00,'509','2022-03-11 11:40:32','509','2022-03-11 11:40:54',10,0),('1','139',257552,'DAILY SHIFT','2022-03-11','2022-03-11 11:42:44','2022-03-12 11:42:44','509',0.00,0.00,'509','2022-03-11 11:47:51','509','2022-03-11 11:48:16',10,0),('1','139',257553,'DAILY SHIFT','2022-03-13','2022-03-13 07:41:53','2022-03-14 07:41:53','509',0.00,0.00,'509','2022-03-13 19:30:35','509','2022-03-13 19:30:58',10,0),('1','139',257554,'DAILY SHIFT','2022-03-14','2022-03-14 07:27:42','2022-03-15 07:27:42','509',0.00,0.00,'509','2022-03-14 18:45:38','509','2022-03-14 18:46:02',10,0),('1','139',257555,'DAILY SHIFT','2022-03-15','2022-03-15 07:14:34','2022-03-16 07:14:34','509',0.00,0.00,'509','2022-03-15 19:21:19','509','2022-03-15 19:21:45',10,0),('1','139',257556,'DAILY SHIFT','2022-03-16','2022-03-16 07:04:16','2022-03-17 07:04:16','509',0.00,0.00,'509','2022-03-16 18:58:07','509','2022-03-16 18:58:30',10,0),('1','139',257557,'DAILY SHIFT','2022-03-17','2022-03-17 07:19:25','2022-03-18 07:19:25','509',0.00,0.00,'509','2022-03-17 18:56:33','509','2022-03-17 18:57:34',10,0),('1','139',257558,'DAILY SHIFT','2022-03-18','2022-03-18 07:53:54','2022-03-19 07:53:54','509',0.00,0.00,'509','2022-03-18 18:45:03','509','2022-03-18 18:45:23',10,0),('1','139',257559,'DAILY SHIFT','2022-03-19','2022-03-19 07:47:42','2022-03-20 07:47:42','509',0.00,0.00,'509','2022-03-19 16:45:53','509','2022-03-19 16:46:19',10,0),('1','139',257560,'DAILY SHIFT','2022-03-19','2022-03-19 17:57:35','2022-03-20 17:57:35','509',0.00,0.00,'509','2022-03-19 18:12:04','509','2022-03-19 18:12:23',10,0),('1','139',257561,'DAILY SHIFT','2022-03-20','2022-03-20 07:52:14','2022-03-21 07:52:14','509',0.00,0.00,'509','2022-03-20 18:45:11','509','2022-03-20 18:45:30',10,0),('1','139',257562,'DAILY SHIFT','2022-03-21','2022-03-21 07:40:58','2022-03-22 07:40:58','509',0.00,0.00,'509','2022-03-21 18:56:47','509','2022-03-21 18:57:06',10,0),('1','139',257563,'DAILY SHIFT','2022-03-22','2022-03-22 07:38:07','2022-03-23 07:38:07','509',0.00,0.00,'509','2022-03-22 18:48:47','509','2022-03-22 18:49:18',10,0),('1','139',257564,'DAILY SHIFT','2022-03-23','2022-03-23 07:36:26','2022-03-24 07:36:26','509',0.00,0.00,'509','2022-03-23 18:48:31','509','2022-03-23 18:48:56',10,0),('1','139',257565,'DAILY SHIFT','2022-03-24','2022-03-24 07:32:37','2022-03-25 07:32:37','509',0.00,0.00,'509','2022-03-24 18:46:34','509','2022-03-24 18:46:52',10,0),('1','139',257566,'DAILY SHIFT','2022-03-25','2022-03-25 07:38:07','2022-03-26 07:38:07','509',0.00,0.00,'509','2022-03-25 19:08:29','509','2022-03-25 19:08:51',10,0),('1','139',257567,'DAILY SHIFT','2022-03-26','2022-03-26 09:54:17','2022-03-27 09:54:17','509',0.00,0.00,'509','2022-03-26 18:42:57','509','2022-03-26 18:43:23',10,0),('1','139',257568,'DAILY SHIFT','2022-03-27','2022-03-27 07:34:09','2022-03-28 07:34:09','509',0.00,0.00,'509','2022-03-27 18:59:25','509','2022-03-27 18:59:43',10,0),('1','139',257569,'DAILY SHIFT','2022-03-28','2022-03-28 07:39:04','2022-03-29 07:39:04','509',0.00,0.00,'509','2022-03-29 00:16:28','509','2022-03-29 00:17:40',10,0),('1','139',257570,'DAILY SHIFT','2022-03-29','2022-03-29 00:18:24','2022-03-30 00:18:24','509',0.00,0.00,'509','2022-03-29 00:24:39','509','2022-03-29 00:25:03',10,0),('1','139',257571,'DAILY SHIFT','2022-03-29','2022-03-29 07:50:12','2022-03-30 07:50:12','509',0.00,0.00,'509','2022-03-29 19:01:54','509','2022-03-29 19:03:02',10,0),('1','139',257572,'DAILY SHIFT','2022-03-30','2022-03-30 07:36:06','2022-03-31 07:36:06','509',0.00,0.00,'509','2022-03-30 18:49:11','509','2022-03-30 18:49:37',10,0),('1','139',257573,'DAILY SHIFT','2022-03-31','2022-03-31 07:38:20','2022-04-01 07:38:20','509',0.00,0.00,'509','2022-03-31 18:51:14','509','2022-03-31 18:51:35',10,0),('1','139',257574,'DAILY SHIFT','2022-04-01','2022-04-01 07:37:47','2022-04-02 07:37:47','509',0.00,0.00,'509','2022-04-01 18:45:12','509','2022-04-01 18:45:39',10,0),('1','139',257575,'DAILY SHIFT','2022-04-02','2022-04-02 07:51:54','2022-04-03 07:51:54','509',0.00,0.00,'509','2022-04-02 18:53:50','509','2022-04-02 18:54:13',10,0),('1','139',257576,'DAILY SHIFT','2022-04-03','2022-04-03 07:38:05','2022-04-04 07:38:05','509',0.00,0.00,'509','2022-04-03 18:24:22','509','2022-04-03 18:24:46',10,0),('1','139',257577,'DAILY SHIFT','2022-04-04','2022-04-04 07:46:51','2022-04-05 07:46:51','509',0.00,0.00,'509','2022-04-04 12:45:59','509','2022-04-04 12:46:26',10,0),('1','139',257578,'DAILY SHIFT','2022-04-04','2022-04-04 13:49:02','2022-04-05 13:49:02','509',0.00,0.00,'509','2022-04-04 15:48:49','509','2022-04-04 15:49:54',10,0),('1','139',257579,'DAILY SHIFT','2022-04-04','2022-04-04 15:51:56','2022-04-05 15:51:56','509',0.00,0.00,'509','2022-04-04 18:49:22','509','2022-04-04 18:49:45',10,0),('1','139',257580,'DAILY SHIFT','2022-04-05','2022-04-05 07:45:54','2022-04-06 07:45:54','509',0.00,0.00,'509','2022-04-05 18:26:21','509','2022-04-05 18:26:46',10,0),('1','139',257581,'DAILY SHIFT','2022-04-06','2022-04-06 07:49:12','2022-04-07 07:49:12','509',0.00,0.00,'509','2022-04-06 18:32:27','509','2022-04-06 18:33:21',10,0),('1','139',257582,'DAILY SHIFT','2022-04-07','2022-04-07 07:36:03','2022-04-08 07:36:03','509',0.00,0.00,'509','2022-04-07 18:43:46','509','2022-04-07 18:44:26',10,0),('1','139',257583,'DAILY SHIFT','2022-04-08','2022-04-08 07:37:24','2022-04-09 07:37:24','509',0.00,0.00,'509','2022-04-08 18:30:23','509','2022-04-08 18:30:47',10,0),('1','139',257584,'DAILY SHIFT','2022-04-09','2022-04-09 07:46:12','2022-04-10 07:46:12','509',0.00,0.00,'509','2022-04-10 07:53:10','509','2022-04-10 07:53:32',10,0),('1','139',257585,'DAILY SHIFT','2022-04-10','2022-04-10 07:54:00','2022-04-11 07:54:00','509',0.00,0.00,'509','2022-04-10 17:13:06','509','2022-04-10 17:13:45',10,0),('1','139',257586,'Daily shift ','2022-04-10','2022-04-10 17:15:26','2022-04-11 17:15:26','509',0.00,0.00,'509','2022-04-10 18:00:10','509','2022-04-10 18:00:33',10,0),('1','139',257587,'DAILY SHIFT','2022-04-12','2022-04-12 08:09:46','2022-04-13 08:09:46','509',0.00,0.00,'509','2022-04-12 18:39:21','509','2022-04-12 19:07:18',10,0),('1','139',257588,'DAILY SHIFT','2022-04-13','2022-04-13 07:23:17','2022-04-14 07:23:17','509',0.00,0.00,'509','2022-04-13 18:49:45','509','2022-04-13 18:50:15',10,0),('1','139',257589,'DAILY SHIFT','2022-04-14','2022-04-14 07:19:47','2022-04-15 07:19:47','509',0.00,0.00,'509','2022-04-14 18:40:48','509','2022-04-14 18:41:11',10,0),('1','139',257590,'DAILY SHIFT','2022-04-15','2022-04-15 08:43:44','2022-04-16 08:43:44','509',0.00,0.00,'509','2022-04-15 18:53:10','509','2022-04-15 18:54:39',10,0),('1','139',257591,'DAILY SHIFT','2022-04-16','2022-04-16 07:34:56','2022-04-17 07:34:56','509',0.00,0.00,'509','2022-04-16 18:48:45','509','2022-04-16 18:49:09',10,0),('1','139',257592,'DAILY SHIFT','2022-04-17','2022-04-17 07:46:29','2022-04-18 07:46:29','509',0.00,0.00,'509','2022-04-17 18:31:58','509','2022-04-17 18:32:16',10,0),('1','139',257593,'DAILY SHIFT','2022-04-18','2022-04-18 07:41:55','2022-04-19 07:41:55','509',0.00,0.00,'509','2022-04-18 19:41:37','509','2022-04-18 19:42:01',10,0),('1','139',257594,'Daily shift ','2022-04-19','2022-04-19 06:21:42','2022-04-20 06:21:42','509',0.00,0.00,'509','2022-04-19 06:34:10','509','2022-04-19 06:34:59',10,0),('1','139',257595,'DAILY SHIFT','2022-04-19','2022-04-19 07:55:15','2022-04-20 07:55:15','509',0.00,0.00,'509','2022-04-19 18:53:18','509','2022-04-19 18:53:42',10,0),('1','139',257596,'DAILY SHIFT','2022-04-20','2022-04-20 08:07:26','2022-04-21 08:07:26','509',0.00,0.00,'509','2022-04-20 18:45:43','509','2022-04-20 18:46:05',10,0),('1','139',257597,'DAILY SHIFT','2022-04-21','2022-04-21 07:47:35','2022-04-22 07:47:35','509',0.00,0.00,'509','2022-04-21 18:23:05','509','2022-04-21 18:23:30',10,0),('1','139',257598,'DAILY SHIFT','2022-04-22','2022-04-22 08:05:48','2022-04-23 08:05:48','509',0.00,0.00,'509','2022-04-22 18:26:38','509','2022-04-22 18:27:08',10,0),('1','139',257599,'DAILY SHIFT','2022-04-23','2022-04-23 10:07:50','2022-04-24 10:07:50','509',0.00,0.00,'509','2022-04-23 18:25:16','509','2022-04-23 18:25:36',10,0),('1','139',257600,'DAILY SHIFT','2022-04-24','2022-04-24 07:53:29','2022-04-25 07:53:29','509',0.00,0.00,'509','2022-04-24 18:45:45','509','2022-04-24 18:46:08',10,0),('1','139',257601,'DAILY SHIFT','2022-04-25','2022-04-25 08:02:41','2022-04-26 08:02:41','509',0.00,0.00,'509','2022-04-25 18:50:23','509','2022-04-25 18:50:59',10,0),('1','139',257602,'DAILY SHIFT','2022-04-26','2022-04-26 07:53:55','2022-04-27 07:53:55','509',0.00,0.00,'509','2022-04-26 16:16:29','509','2022-04-26 16:16:49',10,0),('1','139',257603,'DAILY SHIFT','2022-04-26','2022-04-26 16:26:48','2022-04-27 16:26:48','509',0.00,0.00,'509','2022-04-26 16:27:16','509','2022-04-26 16:31:40',10,0),('1','139',257604,'DAILY SHIFT','2022-04-26','2022-04-26 16:32:09','2022-04-27 16:32:09','509',0.00,0.00,'509','2022-04-26 18:37:41','509','2022-04-26 18:38:10',10,0),('1','139',257605,'DAILY SHIFT','2022-04-27','2022-04-27 07:58:10','2022-04-28 07:58:10','509',0.00,0.00,'509','2022-04-27 18:40:29','509','2022-04-27 18:40:49',10,0),('1','139',257606,'DAILY SHIFT','2022-04-28','2022-04-28 07:41:06','2022-04-29 07:41:06','509',0.00,0.00,'509','2022-04-28 18:28:04','509','2022-04-28 18:28:26',10,0),('1','139',257607,'DAILY SHIFT','2022-04-29','2022-04-29 09:05:39','2022-04-30 09:05:39','509',0.00,0.00,'509','2022-04-29 18:34:04','509','2022-04-29 18:34:24',10,0),('1','139',257608,'DAILY SHIFT','2022-04-30','2022-04-30 07:54:40','2022-05-01 07:54:40','509',0.00,0.00,'509','2022-04-30 18:50:03','509','2022-04-30 18:50:30',10,0),('1','139',257609,'DAILY SHIFT','2022-05-01','2022-05-01 08:24:36','2022-05-02 08:24:36','509',0.00,0.00,'509','2022-05-01 18:48:41','509','2022-05-01 18:49:07',10,0),('1','139',257610,'DAILY SHIFT','2022-05-02','2022-05-02 12:47:42','2022-05-03 12:47:42','509',0.00,0.00,'509','2022-05-02 17:15:49','509','2022-05-02 17:16:10',10,0),('1','139',257611,'DAILY SHIFT','2022-05-03','2022-05-03 11:36:05','2022-05-04 11:36:05','509',0.00,0.00,'509','2022-05-03 17:50:27','509','2022-05-03 17:50:52',10,0),('1','139',257612,'DAILY SHIFT','2022-05-04','2022-05-04 08:58:07','2022-05-05 08:58:07','509',0.00,0.00,'509','2022-05-04 14:29:30','509','2022-05-04 14:29:58',10,0),('1','139',257613,'DAILY SHIFT','2022-05-04','2022-05-04 14:31:44','2022-05-05 14:31:44','509',0.00,0.00,'509','2022-05-04 14:46:38','509','2022-05-04 14:47:07',10,0),('1','139',257614,'DAILY SHIFT','2022-05-04','2022-05-04 14:47:37','2022-05-05 14:47:37','509',0.00,0.00,'509','2022-05-04 19:00:08','509','2022-05-04 19:00:30',10,0),('1','139',257615,'DAILY SHIFT','2022-05-05','2022-05-05 07:47:56','2022-05-06 07:47:56','509',0.00,0.00,'509','2022-05-05 19:07:02','509','2022-05-05 19:07:27',10,0),('1','139',257616,'DAILY SHIFT','2022-05-06','2022-05-06 07:47:01','2022-05-07 07:47:01','509',0.00,0.00,'509','2022-05-06 18:54:40','509','2022-05-06 18:55:12',10,0),('1','139',257617,'DAILY SHIFT','2022-05-07','2022-05-07 07:53:22','2022-05-08 07:53:22','509',0.00,0.00,'509','2022-05-07 18:48:32','509','2022-05-07 18:49:49',10,0),('1','139',257618,'DAILY SHIFT','2022-05-08','2022-05-08 07:35:54','2022-05-09 07:35:54','509',0.00,0.00,'509','2022-05-08 19:28:58','509','2022-05-08 19:29:27',10,0),('1','139',257619,'DAILY SHIFT','2022-05-09','2022-05-09 07:15:27','2022-05-10 07:15:27','509',0.00,0.00,'509','2022-05-09 18:51:26','509','2022-05-09 18:51:53',10,0),('1','139',257620,'DAILY SHIFT','2022-05-10','2022-05-10 08:00:07','2022-05-11 08:00:07','509',0.00,0.00,'509','2022-05-10 19:39:31','509','2022-05-10 19:39:53',10,0),('1','139',257621,'Daily shift ','2022-05-10','2022-05-10 21:37:52','2022-05-11 21:37:52','509',0.00,0.00,'509','2022-05-14 19:59:12','509','2022-05-14 19:59:31',10,0),('1','139',257622,'DAILY SHIFT','2022-05-15','2022-05-15 07:21:00','2022-05-16 07:21:00','509',0.00,0.00,'509','2022-05-15 18:53:43','509','2022-05-15 18:54:07',10,0),('1','139',257623,'DAILY SHIFT','2022-05-16','2022-05-16 07:35:06','2022-05-17 07:35:06','509',0.00,0.00,'509','2022-05-16 19:03:25','509','2022-05-16 19:03:51',10,0),('1','139',257624,'DAILY SHIFT','2022-05-17','2022-05-17 07:53:27','2022-05-18 07:53:27','509',0.00,0.00,'509','2022-05-17 19:03:18','509','2022-05-17 19:03:46',10,0),('1','139',257625,'DAILY SHIFT','2022-05-18','2022-05-18 07:08:26','2022-05-19 07:08:26','509',0.00,0.00,'509','2022-05-18 19:03:43','509','2022-05-18 19:04:09',10,0),('1','139',257626,'DAILY SHIFT','2022-05-19','2022-05-19 07:36:33','2022-05-20 07:36:33','509',0.00,0.00,'509','2022-05-19 15:16:34','509','2022-05-19 15:16:57',10,0),('1','139',257627,'Daily shift ','2022-05-19','2022-05-19 19:04:28','2022-05-20 19:04:28','509',0.00,0.00,'509','2022-05-25 12:31:22','509','2022-05-25 12:32:41',10,0),('1','139',257628,'DAILY SHIFT','2022-05-25','2022-05-25 12:38:39','2022-05-26 12:38:39','509',0.00,0.00,'509','2022-05-25 20:28:16','509','2022-05-25 20:28:45',10,0),('1','139',257629,'Daily shirft','2022-05-26','2022-05-26 07:24:25','2022-05-27 07:24:25','509',0.00,0.00,'509','2022-05-26 19:49:37','509','2022-05-26 19:50:03',10,0),('1','139',257630,'daily shift','2022-05-27','2022-05-27 06:45:47','2022-05-28 06:45:47','509',0.00,0.00,'509','2022-05-27 19:15:45','509','2022-05-27 19:16:30',10,0),('1','139',257631,'DAILY SHIFT','2022-05-28','2022-05-28 10:08:49','2022-05-29 10:08:49','509',0.00,0.00,'509','2022-05-28 19:49:51','509','2022-05-28 19:50:19',10,0),('1','139',257632,'Daily shift','2022-05-29','2022-05-29 07:01:55','2022-05-30 07:01:55','509',0.00,0.00,'509','2022-05-29 18:45:57','509','2022-05-29 18:46:35',10,0),('1','139',257633,'DAILY SHIFT','2022-05-30','2022-05-30 06:50:59','2022-05-31 06:50:59','509',0.00,0.00,'509','2022-05-30 19:28:36','509','2022-05-30 19:29:07',10,0),('1','139',257634,'DAILY SHIFT','2022-05-31','2022-05-31 07:07:58','2022-06-01 07:07:58','509',0.00,0.00,'509','2022-05-31 12:08:16','509','2022-05-31 12:08:49',10,0),('1','139',257635,'DAILY SHIFT','2022-05-31','2022-05-31 13:08:45','2022-06-01 13:08:45','509',0.00,0.00,'509','2022-05-31 18:42:02','509','2022-05-31 18:42:48',10,0),('1','139',257636,'DAILY SHIFT','2022-06-01','2022-06-01 07:10:52','2022-06-02 07:10:52','509',0.00,0.00,'509','2022-06-01 19:09:52','509','2022-06-01 19:10:38',10,0),('1','139',257637,'Daily shift','2022-06-02','2022-06-02 07:09:45','2022-06-03 07:09:45','509',0.00,0.00,'509','2022-06-02 19:11:30','509','2022-06-02 19:12:00',10,0),('1','139',257638,'Daily shift','2022-06-03','2022-06-03 07:11:26','2022-06-04 07:11:26','509',0.00,0.00,'509','2022-06-03 19:02:57','509','2022-06-03 19:03:25',10,0),('1','139',257639,'Daily shirft','2022-06-04','2022-06-04 07:12:05','2022-06-05 07:12:05','509',0.00,0.00,'509','2022-06-04 19:24:15','509','2022-06-04 19:26:12',10,0),('1','139',257640,'Daily shirft','2022-06-05','2022-06-05 07:09:37','2022-06-06 07:09:37','509',0.00,0.00,'509','2022-06-05 18:41:05','509','2022-06-05 18:41:35',10,0),('1','139',257641,'Daily shirft','2022-06-06','2022-06-06 07:00:18','2022-06-07 07:00:18','509',0.00,0.00,'509','2022-06-06 18:49:35','509','2022-06-06 18:50:05',10,0),('1','139',257642,'DAILY SHIFT','2022-06-07','2022-06-07 07:00:45','2022-06-08 07:00:45','509',0.00,0.00,'509','2022-06-07 11:31:33','509','2022-06-07 11:32:00',10,0),('1','139',257643,'DAILY SHIFT','2022-06-07','2022-06-07 11:34:48','2022-06-08 11:34:48','509',0.00,0.00,'509','2022-06-09 12:52:38','509','2022-06-09 12:53:04',10,0),('1','139',257644,'DAILY SHIFT','2022-06-09','2022-06-09 14:08:57','2022-06-10 14:08:57','509',0.00,0.00,'509','2022-06-09 20:05:26','509','2022-06-09 20:19:12',10,0),('1','139',257645,'Daily shift','2022-06-10','2022-06-10 07:01:18','2022-06-11 07:01:18','509',0.00,0.00,'509','2022-06-10 18:56:02','509','2022-06-10 18:56:33',10,0),('1','139',257646,'Daily shift','2022-06-11','2022-06-11 06:48:46','2022-06-12 06:48:46','509',0.00,0.00,'509','2022-06-11 19:06:34','509','2022-06-11 19:07:10',10,0),('1','139',257647,'Daily shift','2022-06-12','2022-06-12 07:16:57','2022-06-13 07:16:57','509',0.00,0.00,'509','2022-06-12 18:35:06','509','2022-06-12 18:35:36',10,0),('1','139',257648,'Daily shift','2022-06-13','2022-06-13 06:52:37','2022-06-14 06:52:37','509',0.00,0.00,'509','2022-06-13 18:46:33','509','2022-06-13 18:47:08',10,0),('1','139',257649,'Daily shift','2022-06-14','2022-06-14 06:52:36','2022-06-15 06:52:36','509',0.00,0.00,'509','2022-06-14 18:45:44','509','2022-06-14 18:46:22',10,0),('1','139',257650,'Daily shirft','2022-06-15','2022-06-15 07:00:58','2022-06-16 07:00:58','509',0.00,0.00,'509','2022-06-15 10:06:35','509','2022-06-15 10:08:48',10,0),('1','139',257651,'DAILY SHIFT','2022-06-15','2022-06-15 10:10:44','2022-06-16 10:10:44','509',0.00,0.00,'509','2022-06-15 10:22:25','509','2022-06-15 10:22:51',10,0),('1','139',257652,'DAILY SHIFT','2022-06-15','2022-06-15 13:15:41','2022-06-16 13:15:41','509',0.00,0.00,'509','2022-06-15 18:48:35','509','2022-06-15 18:55:00',10,0),('1','139',257653,'Daily shift','2022-06-16','2022-06-16 07:06:42','2022-06-17 07:06:42','509',0.00,0.00,'509','2022-06-16 18:38:09','509','2022-06-16 18:40:11',10,0),('1','139',257654,'Daily shift','2022-06-17','2022-06-17 07:12:08','2022-06-18 07:12:08','509',0.00,0.00,'509','2022-06-17 18:45:28','509','2022-06-17 18:52:12',10,0),('1','139',257655,'Daily shift','2022-06-18','2022-06-18 07:01:16','2022-06-19 07:01:16','509',0.00,0.00,'509','2022-06-18 18:32:03','509','2022-06-18 18:32:27',10,0),('1','139',257656,'Daily shift','2022-06-19','2022-06-19 06:57:18','2022-06-20 06:57:18','509',0.00,0.00,'509','2022-06-19 18:56:42','509','2022-06-19 18:57:13',10,0),('1','139',257657,'Daily shift','2022-06-20','2022-06-20 06:44:50','2022-06-21 06:44:50','509',0.00,0.00,'509','2022-06-20 19:10:39','509','2022-06-20 19:11:09',10,0),('1','139',257658,'Daily shift','2022-06-21','2022-06-21 06:53:16','2022-06-22 06:53:16','509',0.00,0.00,'509','2022-06-21 18:55:55','509','2022-06-21 18:56:18',10,0),('1','139',257659,'Daily shift','2022-06-22','2022-06-22 07:01:28','2022-06-23 07:01:28','509',0.00,0.00,'509','2022-06-22 18:59:26','509','2022-06-22 19:00:52',10,0),('1','139',257660,'Daily shift','2022-06-23','2022-06-23 06:59:29','2022-06-24 06:59:29','509',0.00,0.00,'509','2022-06-23 19:02:20','509','2022-06-23 19:02:46',10,0),('1','139',257661,'Daily shift','2022-06-24','2022-06-24 07:05:31','2022-06-25 07:05:31','509',0.00,0.00,'509','2022-06-24 17:59:22','509','2022-06-24 17:59:53',10,0),('1','139',257662,'DAILY SHIFT','2022-06-24','2022-06-24 18:13:51','2022-06-25 18:13:51','509',0.00,0.00,'509','2022-06-24 18:34:39','509','2022-06-24 18:36:01',10,0),('1','139',257663,'Daily shift','2022-06-25','2022-06-25 09:47:23','2022-06-26 09:47:23','509',0.00,0.00,'509','2022-06-25 19:10:31','509','2022-06-25 19:11:03',10,0),('1','139',257664,'Daily shift','2022-06-26','2022-06-26 07:02:03','2022-06-27 07:02:03','509',0.00,0.00,'509','2022-06-26 18:36:42','509','2022-06-26 18:37:12',10,0),('1','139',257665,'Daily shift','2022-06-27','2022-06-27 07:02:18','2022-06-28 07:02:18','509',0.00,0.00,'509','2022-06-27 18:46:35','509','2022-06-27 18:47:03',10,0),('1','139',257666,'Daily shift','2022-06-28','2022-06-28 06:49:35','2022-06-29 06:49:35','509',0.00,0.00,'509','2022-06-28 19:08:54','509','2022-06-28 19:10:16',10,0),('1','139',257667,'Daily shift','2022-06-29','2022-06-29 06:55:33','2022-06-30 06:55:33','509',0.00,0.00,'509','2022-06-29 18:42:48','509','2022-06-29 18:43:20',10,0),('1','139',257668,'DAILY SHIFT','2022-06-30','2022-06-30 07:25:56','2022-07-01 07:25:56','509',0.00,0.00,'509','2022-06-30 19:00:11','509','2022-06-30 19:00:45',10,0),('1','139',257669,'Daily shift','2022-07-01','2022-07-01 06:51:47','2022-07-02 06:51:47','509',0.00,0.00,'509','2022-07-01 18:53:47','509','2022-07-01 18:54:23',10,0),('1','139',257670,'Daily shift','2022-07-02','2022-07-02 06:42:45','2022-07-03 06:42:45','509',0.00,0.00,'509','2022-07-02 18:54:07','509','2022-07-02 18:54:46',10,0),('1','139',257671,'Daily shift','2022-07-03','2022-07-03 07:13:32','2022-07-04 07:13:32','509',0.00,0.00,'509','2022-07-03 16:17:17','509','2022-07-03 16:18:58',10,0),('1','139',257672,'DAILY SHIFT','2022-07-03','2022-07-03 16:21:33','2022-07-04 16:21:33','509',0.00,0.00,'509','2022-07-03 16:53:18','509','2022-07-03 16:53:47',10,0),('1','139',257673,'DAILY SHIFT','2022-07-03','2022-07-03 16:54:15','2022-07-04 16:54:15','509',0.00,0.00,'509','2022-07-03 19:40:18','509','2022-07-03 19:41:05',10,0),('1','139',257674,'Daily shift','2022-07-04','2022-07-04 07:07:02','2022-07-05 07:07:02','509',0.00,0.00,'509','2022-07-04 19:40:36','509','2022-07-04 19:41:00',10,0),('1','139',257675,'Daily shift','2022-07-05','2022-07-05 07:34:58','2022-07-06 07:34:58','509',0.00,0.00,'509','2022-07-05 19:15:28','509','2022-07-05 19:16:05',10,0),('1','139',257676,'Daily shift','2022-07-06','2022-07-06 07:09:52','2022-07-07 07:09:52','509',0.00,0.00,'509','2022-07-06 19:01:33','509','2022-07-06 19:03:14',10,0),('1','139',257677,'Daily shift','2022-07-07','2022-07-07 07:00:11','2022-07-08 07:00:11','509',0.00,0.00,'509','2022-07-08 07:13:47','509','2022-07-08 07:24:00',10,0),('1','139',257678,'DAILY SHIFT','2022-07-08','2022-07-08 07:24:32','2022-07-09 07:24:32','509',0.00,0.00,'509','2022-07-08 18:58:43','509','2022-07-08 18:59:27',10,0),('1','139',257679,'DAILY SHIFT','2022-07-09','2022-07-09 11:11:52','2022-07-10 11:11:52','509',0.00,0.00,'509','2022-07-09 17:54:34','509','2022-07-09 17:55:01',10,0),('1','139',257680,'Daily shift','2022-07-10','2022-07-10 09:57:52','2022-07-11 09:57:52','509',0.00,0.00,'509','2022-07-10 19:13:42','509','2022-07-10 19:14:03',10,0),('1','139',257681,'Daily shift ','2022-07-10','2022-07-10 19:14:47','2022-07-11 19:14:47','509',0.00,0.00,'509','2022-07-10 19:17:25','509','2022-07-10 19:17:46',10,0),('1','139',257682,'Daily shift','2022-07-11','2022-07-11 06:58:32','2022-07-12 06:58:32','509',0.00,0.00,'509','2022-07-11 19:29:50','509','2022-07-11 19:30:26',10,0),('1','139',257683,'Daily shift¹','2022-07-12','2022-07-12 06:41:30','2022-07-13 06:41:30','509',0.00,0.00,'509','2022-07-13 01:27:06','509','2022-07-13 01:27:31',10,0),('1','139',257684,'Daily shirft','2022-07-13','2022-07-13 07:03:28','2022-07-14 07:03:28','509',0.00,0.00,'509','2022-07-13 20:49:41','509','2022-07-13 20:50:00',10,0),('1','139',257685,'Daily shirft','2022-07-14','2022-07-14 06:55:47','2022-07-15 06:55:47','509',0.00,0.00,'509','2022-07-14 19:12:14','509','2022-07-14 19:12:50',10,0),('1','139',257686,'DAILY SHIFT','2022-07-15','2022-07-15 07:44:36','2022-07-16 07:44:36','509',0.00,0.00,'509','2022-07-15 18:58:29','509','2022-07-15 18:58:58',10,0),('1','139',257687,'DAILY SHIFT','2022-07-16','2022-07-16 07:49:48','2022-07-17 07:49:48','509',0.00,0.00,'509','2022-07-16 19:10:26','509','2022-07-16 19:12:23',10,0),('1','139',257688,'DAILY SHIFT','2022-07-17','2022-07-17 08:13:50','2022-07-18 08:13:50','509',0.00,0.00,'509','2022-07-17 18:38:30','509','2022-07-17 18:39:02',10,0),('1','139',257689,'DAILY SHIFT','2022-07-18','2022-07-18 07:25:40','2022-07-19 07:25:40','509',0.00,0.00,'509','2022-07-18 18:59:04','509','2022-07-18 18:59:33',10,0),('1','139',257690,'Daily shift ','2022-07-18','2022-07-18 19:44:58','2022-07-19 19:44:58','509',0.00,0.00,'509','2022-07-18 19:57:10','509','2022-07-18 19:57:36',10,0),('1','139',257691,'DAILY SHIFT','2022-07-21','2022-07-21 09:28:54','2022-07-22 09:28:54','509',0.00,0.00,'509','2022-07-21 19:52:37','509','2022-07-21 19:53:00',10,0),('1','139',257692,'DAILY','2022-07-22','2022-07-22 06:38:44','2022-07-23 06:38:44','509',0.00,0.00,'509','2022-07-22 18:52:52','509','2022-07-22 18:53:44',10,0),('1','139',257693,'DAILY','2022-07-23','2022-07-23 06:28:36','2022-07-24 06:28:36','509',0.00,0.00,'509','2022-07-23 19:28:13','509','2022-07-23 19:29:08',10,0),('1','139',257694,'DAILY','2022-07-24','2022-07-24 06:42:56','2022-07-25 06:42:56','509',0.00,0.00,'509','2022-07-24 19:14:19','509','2022-07-24 19:14:46',10,0),('1','139',257695,'DAILY','2022-07-25','2022-07-25 06:54:23','2022-07-26 06:54:23','509',0.00,0.00,'509','2022-07-25 19:34:07','509','2022-07-25 19:34:33',10,0),('1','139',257696,'DAILY','2022-07-26','2022-07-26 06:31:37','2022-07-27 06:31:37','509',0.00,0.00,'509','2022-07-26 18:57:47','509','2022-07-26 18:58:13',10,0),('1','139',257697,'DAILY','2022-07-27','2022-07-27 06:59:46','2022-07-28 06:59:46','509',0.00,0.00,'509','2022-07-27 19:33:20','509','2022-07-27 19:33:45',10,0),('1','139',257698,'DAILY SHIFT','2022-07-28','2022-07-28 07:35:04','2022-07-29 07:35:04','509',0.00,0.00,'509','2022-07-29 07:56:55','509','2022-07-29 07:57:46',10,0),('1','139',257699,'DAILY SHIFT','2022-07-29','2022-07-29 07:58:13','2022-07-30 07:58:13','509',0.00,0.00,'509','2022-07-29 12:54:33','509','2022-07-29 12:55:03',10,0),('1','139',257700,'DAILY SHIFT','2022-07-29','2022-07-29 12:56:19','2022-07-30 12:56:19','509',0.00,0.00,'509','2022-07-29 13:19:10','509','2022-07-29 13:19:34',10,0),('1','139',257701,'DAILY','2022-07-31','2022-07-31 07:06:20','2022-08-01 07:06:20','509',0.00,0.00,'509','2022-07-31 20:23:30','509','2022-07-31 20:24:03',10,0),('1','139',257702,'DAILY SHIFT','2022-08-01','2022-08-01 07:40:00','2022-08-02 07:40:00','509',0.00,0.00,'509','2022-08-01 19:35:25','509','2022-08-01 19:35:49',10,0),('1','139',257703,'DAILY SHIFT','2022-08-02','2022-08-02 07:43:24','2022-08-03 07:43:24','509',0.00,0.00,'509','2022-08-03 07:52:52','509','2022-08-03 07:53:32',10,0),('1','139',257704,'DAILY SHIFT','2022-08-03','2022-08-03 07:54:00','2022-08-04 07:54:00','509',0.00,0.00,'509','2022-08-03 18:41:58','509','2022-08-03 18:42:25',10,0),('1','139',257705,'DAILY SHIFT','2022-08-04','2022-08-04 07:40:28','2022-08-05 07:40:28','509',0.00,0.00,'509','2022-08-04 18:18:38','509','2022-08-04 18:19:46',10,0),('1','139',257706,'Daily shift ','2022-08-04','2022-08-04 22:48:42','2022-08-05 22:48:42','509',0.00,0.00,'509','2022-08-04 22:53:14','509','2022-08-04 22:57:26',10,0),('1','139',257707,'DAILY','2022-08-05','2022-08-05 07:13:55','2022-08-06 07:13:55','509',0.00,0.00,'509','2022-08-05 19:02:37','509','2022-08-05 19:03:07',10,0),('1','139',257708,'DAILY SHIFT','2022-08-06','2022-08-06 08:05:03','2022-08-07 08:05:03','509',0.00,0.00,'509','2022-08-06 18:36:06','509','2022-08-06 18:36:32',10,0),('1','139',257709,'DAILY','2022-08-07','2022-08-07 07:01:14','2022-08-08 07:01:14','509',0.00,0.00,'509','2022-08-07 19:23:26','509','2022-08-07 19:23:56',10,0),('1','139',257710,'DAILY','2022-08-08','2022-08-08 07:06:56','2022-08-09 07:06:56','509',0.00,0.00,'509','2022-08-08 18:39:05','509','2022-08-08 18:39:43',10,0),('1','139',257711,'DAILY','2022-08-09','2022-08-09 07:14:23','2022-08-10 07:14:23','509',0.00,0.00,'509','2022-08-09 18:40:54','509','2022-08-09 18:41:44',10,0),('1','139',257712,'DAILY','2022-08-10','2022-08-10 06:39:06','2022-08-11 06:39:06','509',0.00,0.00,'509','2022-08-10 19:32:19','509','2022-08-10 19:32:53',10,0),('1','139',257713,'DAILY','2022-08-11','2022-08-11 07:00:12','2022-08-12 07:00:12','509',0.00,0.00,'509','2022-08-11 12:43:43','509','2022-08-11 12:44:11',10,0),('1','139',257714,'DAILY SHIFT','2022-08-11','2022-08-11 12:45:02','2022-08-12 12:45:02','509',0.00,0.00,'509','2022-08-12 13:25:37','509','2022-08-12 13:26:07',10,0),('1','139',257715,'DAILY','2022-08-12','2022-08-12 13:26:36','2022-08-13 13:26:36','509',0.00,0.00,'509','2022-08-12 13:53:46','509','2022-08-12 13:54:08',10,0),('1','139',257716,'DAILY SHIFT','2022-08-12','2022-08-12 14:21:59','2022-08-13 14:21:59','509',0.00,0.00,'509','2022-08-12 18:29:27','509','2022-08-12 18:29:50',10,0),('1','139',257717,'DAILY','2022-08-13','2022-08-13 07:06:31','2022-08-14 07:06:31','509',0.00,0.00,'509','2022-08-13 18:37:50','509','2022-08-13 18:38:36',10,0),('1','139',257718,'DAILY SHIFT','2022-08-14','2022-08-14 08:01:49','2022-08-15 08:01:49','509',0.00,0.00,'509','2022-08-14 18:19:45','509','2022-08-14 18:20:09',10,0),('1','139',257719,'DAILY SHIFT','2022-08-15','2022-08-15 07:39:45','2022-08-16 07:39:45','509',0.00,0.00,'509','2022-08-15 18:55:23','509','2022-08-15 18:55:50',10,0),('1','139',257720,'DAILY SHIFT','2022-08-16','2022-08-16 08:00:10','2022-08-17 08:00:10','509',0.00,0.00,'509','2022-08-16 18:43:27','509','2022-08-16 18:44:13',10,0),('1','139',257721,'DAILY SHIFT','2022-08-17','2022-08-17 07:31:40','2022-08-18 07:31:40','509',0.00,0.00,'509','2022-08-17 18:52:21','509','2022-08-17 18:52:50',10,0),('1','139',257722,'DAILY SHIFT','2022-08-18','2022-08-18 07:46:44','2022-08-19 07:46:44','509',0.00,0.00,'509','2022-08-18 18:24:35','509','2022-08-18 18:25:02',10,0),('1','139',257723,'DAILY SHIFT','2022-08-19','2022-08-19 07:47:16','2022-08-20 07:47:16','509',0.00,0.00,'509','2022-08-19 17:20:54','509','2022-08-19 17:21:47',10,0),('1','139',257724,'Daily shift ','2022-08-19','2022-08-19 17:23:00','2022-08-20 17:23:00','509',0.00,0.00,'509','2022-08-19 17:33:24','509','2022-08-19 17:33:49',10,0),('1','139',257725,'DAILY SHIFT','2022-08-19','2022-08-19 18:21:24','2022-08-20 18:21:24','509',0.00,0.00,'509','2022-08-19 19:05:26','509','2022-08-19 19:05:57',10,0),('1','139',257726,'DAILY SHIFT','2022-08-20','2022-08-20 07:14:49','2022-08-21 07:14:49','509',0.00,0.00,'509','2022-08-20 19:13:44','509','2022-08-20 19:14:10',10,0),('1','139',257727,'DAILY SHIFT','2022-08-21','2022-08-21 07:42:55','2022-08-22 07:42:55','509',0.00,0.00,'509','2022-08-21 18:47:10','509','2022-08-21 18:47:45',10,0),('1','139',257728,'DAILY','2022-08-22','2022-08-22 07:18:40','2022-08-23 07:18:40','509',0.00,0.00,'509','2022-08-22 18:49:02','509','2022-08-22 18:50:23',10,0),('1','139',257729,'DAILY','2022-08-23','2022-08-23 07:17:17','2022-08-24 07:17:17','509',0.00,0.00,'509','2022-08-23 18:46:09','509','2022-08-23 18:46:59',10,0),('1','139',257730,'DAILY','2022-08-24','2022-08-24 07:19:30','2022-08-25 07:19:30','509',0.00,0.00,'509','2022-08-24 18:29:10','509','2022-08-24 18:30:39',10,0),('1','139',257731,'DAILY','2022-08-25','2022-08-25 06:46:43','2022-08-26 06:46:43','509',0.00,0.00,'509','2022-08-25 18:54:54','509','2022-08-25 18:55:21',10,0),('1','139',257732,'DAILY SHIFT','2022-08-26','2022-08-26 07:38:25','2022-08-27 07:38:25','509',0.00,0.00,'509','2022-08-27 10:21:06','509','2022-08-27 10:22:06',10,0),('1','139',257733,'DAILY SHIFT','2022-08-27','2022-08-27 10:23:28','2022-08-28 10:23:28','509',0.00,0.00,'509','2022-08-27 16:07:10','509','2022-08-27 16:07:49',10,0),('1','139',257734,'DAILY SHIFT','2022-08-27','2022-08-27 16:11:15','2022-08-28 16:11:15','509',0.00,0.00,'509','2022-08-27 16:16:54','509','2022-08-27 16:17:21',10,0),('1','139',257735,'DAILY SHIFT','2022-08-27','2022-08-27 17:36:06','2022-08-28 17:36:06','509',0.00,0.00,'509','2022-08-27 19:04:27','509','2022-08-27 19:04:51',10,0),('1','139',257736,'DAILY SHIFT','2022-08-28','2022-08-28 08:11:12','2022-08-29 08:11:12','509',0.00,0.00,'509','2022-08-28 18:26:04','509','2022-08-28 18:26:43',10,0),('1','139',257737,'DAILY SHIFT','2022-08-29','2022-08-29 07:49:39','2022-08-30 07:49:39','509',0.00,0.00,'509','2022-08-29 18:49:40','509','2022-08-29 18:50:19',10,0),('1','139',257738,'Daily shift','2022-08-30','2022-08-30 06:50:52','2022-08-31 06:50:52','509',0.00,0.00,'509','2022-08-30 18:52:53','509','2022-08-30 18:53:20',10,0),('1','139',257739,'Daily shift','2022-08-31','2022-08-31 06:58:05','2022-09-01 06:58:05','509',0.00,0.00,'509','2022-08-31 18:47:55','509','2022-08-31 18:49:58',10,0),('1','139',257740,'Daily shift','2022-09-01','2022-09-01 07:34:13','2022-09-02 07:34:13','509',0.00,0.00,'509','2022-09-01 19:01:30','509','2022-09-01 19:02:17',10,0),('1','139',257741,'Daily shift','2022-09-02','2022-09-02 07:27:07','2022-09-03 07:27:07','509',0.00,0.00,'509','2022-09-02 18:35:21','509','2022-09-02 18:35:51',10,0),('1','139',257742,'Daily shift','2022-09-03','2022-09-03 07:22:26','2022-09-04 07:22:26','509',0.00,0.00,'509','2022-09-03 11:43:46','509','2022-09-03 11:44:15',10,0),('1','139',257743,'DAILY SHIFT','2022-09-03','2022-09-03 11:48:15','2022-09-04 11:48:15','509',0.00,0.00,'509','2022-09-03 12:40:50','509','2022-09-03 12:41:29',10,0),('1','139',257744,'DAILY SHIFT','2022-09-03','2022-09-03 12:41:54','2022-09-04 12:41:54','509',0.00,0.00,'509','2022-09-03 19:00:01','509','2022-09-03 19:00:35',10,0),('1','139',257745,'DAILY SHIFT','2022-09-04','2022-09-04 08:07:21','2022-09-05 08:07:21','509',0.00,0.00,'509','2022-09-04 18:52:50','509','2022-09-04 18:53:20',10,0),('1','139',257746,'Daily shift','2022-09-05','2022-09-05 07:17:48','2022-09-06 07:17:48','509',0.00,0.00,'509','2022-09-05 19:14:28','509','2022-09-05 19:15:06',10,0),('1','139',257747,'Daily shift','2022-09-06','2022-09-06 07:00:28','2022-09-07 07:00:28','509',0.00,0.00,'509','2022-09-06 19:06:10','509','2022-09-06 19:06:52',10,0),('1','139',257748,'Daily shift','2022-09-07','2022-09-07 07:24:56','2022-09-08 07:24:56','509',0.00,0.00,'509','2022-09-07 18:51:25','509','2022-09-07 18:51:56',10,0),('1','139',257749,'Daily shift','2022-09-08','2022-09-08 07:03:06','2022-09-09 07:03:06','509',0.00,0.00,'509','2022-09-08 19:16:42','509','2022-09-08 19:17:07',10,0),('1','139',257750,'Daily shift','2022-09-09','2022-09-09 07:15:49','2022-09-10 07:15:49','509',0.00,0.00,'509','2022-09-09 19:11:54','509','2022-09-09 19:12:18',10,0),('1','139',257751,'Daily shift','2022-09-10','2022-09-10 07:05:28','2022-09-11 07:05:28','509',0.00,0.00,'509','2022-09-10 18:30:44','509','2022-09-10 18:31:17',10,0),('1','139',257752,'Daily shift','2022-09-11','2022-09-11 07:39:12','2022-09-12 07:39:12','509',0.00,0.00,'509','2022-09-11 12:46:27','509','2022-09-11 12:47:19',10,0),('1','139',257753,'DAILY SHIFT','2022-09-11','2022-09-11 12:47:56','2022-09-12 12:47:56','509',0.00,0.00,'509','2022-09-11 13:04:14','509','2022-09-11 13:04:42',10,0),('1','139',257754,'DAILY SHIFT','2022-09-11','2022-09-11 14:31:48','2022-09-12 14:31:48','509',0.00,0.00,'509','2022-09-11 18:39:01','509','2022-09-11 18:39:32',10,0),('1','139',257755,'Daily shift','2022-09-12','2022-09-12 07:11:30','2022-09-13 07:11:30','509',0.00,0.00,'509','2022-09-12 18:45:17','509','2022-09-12 18:45:50',10,0),('1','139',257756,'Daily shift','2022-09-13','2022-09-13 07:39:20','2022-09-14 07:39:20','509',0.00,0.00,'509','2022-09-13 19:10:30','509','2022-09-13 19:10:57',10,0),('1','139',257757,'DAILY SHIFT','2022-09-14','2022-09-14 07:40:55','2022-09-15 07:40:55','509',0.00,0.00,'509','2022-09-14 19:01:52','509','2022-09-14 19:02:46',10,0),('1','139',257758,'DAILY SHIFT','2022-09-15','2022-09-15 07:50:21','2022-09-16 07:50:21','509',0.00,0.00,'509','2022-09-15 18:52:31','509','2022-09-15 18:52:58',10,0),('1','139',257759,'DAILY SHIFT','2022-09-16','2022-09-16 07:50:58','2022-09-17 07:50:58','509',0.00,0.00,'509','2022-09-16 18:53:23','509','2022-09-16 18:54:31',10,0),('1','139',257760,'DAILY SHIFT','2022-09-17','2022-09-17 07:54:07','2022-09-18 07:54:07','509',0.00,0.00,'509','2022-09-17 18:47:41','509','2022-09-17 18:48:15',10,0),('1','139',257761,'DAILY SHIFT','2022-09-18','2022-09-18 08:08:24','2022-09-19 08:08:24','509',0.00,0.00,'509','2022-09-18 18:27:25','509','2022-09-18 18:28:07',10,0),('1','139',257762,'Daily shift ','2022-09-18','2022-09-18 19:18:16','2022-09-19 19:18:16','509',0.00,0.00,'509','2022-09-18 19:23:36','509','2022-09-18 19:23:55',10,0),('1','139',257763,'DAILY SHIFT','2022-09-19','2022-09-19 11:35:07','2022-09-20 11:35:07','509',0.00,0.00,'509','2022-09-19 18:53:08','509','2022-09-19 18:54:30',10,0),('1','139',257764,'DAILY SHIFT','2022-09-20','2022-09-20 07:46:17','2022-09-21 07:46:17','509',0.00,0.00,'509','2022-09-20 18:50:56','509','2022-09-20 18:56:34',10,0),('1','139',257765,'DAILY SHIFT','2022-09-21','2022-09-21 07:49:15','2022-09-22 07:49:15','509',0.00,0.00,'509','2022-09-21 19:15:12','509','2022-09-21 19:16:23',10,0),('1','139',257766,'DAILY SHIFT','2022-09-22','2022-09-22 07:39:38','2022-09-23 07:39:38','509',0.00,0.00,'509','2022-09-22 18:56:57','509','2022-09-22 18:57:32',10,0),('1','139',257767,'DAILY SHIFT','2022-09-23','2022-09-23 08:09:12','2022-09-24 08:09:12','509',0.00,0.00,'509','2022-09-23 18:40:09','509','2022-09-23 18:42:13',10,0),('1','139',257768,'DAILY SHIFT','2022-09-24','2022-09-24 08:06:53','2022-09-25 08:06:53','509',0.00,0.00,'509','2022-09-24 19:03:11','509','2022-09-24 19:06:33',10,0),('1','139',257769,'DAILY SHIFT','2022-09-25','2022-09-25 07:43:00','2022-09-26 07:43:00','509',0.00,0.00,'509','2022-09-25 18:48:15','509','2022-09-25 18:49:47',10,0),('1','139',257770,'DAILY SHIFT','2022-09-26','2022-09-26 08:41:24','2022-09-27 08:41:24','509',0.00,0.00,'509','2022-09-26 16:49:23','509','2022-09-26 16:49:50',10,0),('1','139',257771,'DAILY SHIFT','2022-09-28','2022-09-28 10:10:16','2022-09-29 10:10:16','509',0.00,0.00,'509','2022-09-28 10:13:47','509','2022-09-28 10:14:28',10,0),('1','139',257772,'DAILY SHIFT','2022-09-28','2022-09-28 11:41:31','2022-09-29 11:41:31','509',0.00,0.00,'509','2022-09-28 18:52:11','509','2022-09-28 18:52:36',10,0),('1','139',257773,'DAILY SHIFT','2022-09-29','2022-09-29 07:48:18','2022-09-30 07:48:18','509',0.00,0.00,'509','2022-09-29 18:26:16','509','2022-09-29 18:26:42',10,0),('1','139',257774,'DAILY SHIFT','2022-09-30','2022-09-30 08:12:06','2022-10-01 08:12:06','509',0.00,0.00,'509','2022-09-30 18:34:44','509','2022-09-30 18:35:17',10,0),('1','139',257775,'DAILY SHIFT','2022-10-01','2022-10-01 07:32:57','2022-10-02 07:32:57','509',0.00,0.00,'509','2022-10-01 18:36:42','509','2022-10-01 18:38:08',10,0),('1','139',257776,'DAILY SHIFT','2022-10-02','2022-10-02 08:02:32','2022-10-03 08:02:32','509',0.00,0.00,'509','2022-10-02 18:37:19','509','2022-10-02 18:40:30',10,0),('1','139',257777,'DAILY SHIFT','2022-10-03','2022-10-03 07:49:24','2022-10-04 07:49:24','509',0.00,0.00,'509','2022-10-03 18:33:14','509','2022-10-03 18:33:48',10,0),('1','139',257778,'DAILY SHIFT','2022-10-04','2022-10-04 07:44:37','2022-10-05 07:44:37','509',0.00,0.00,'509','2022-10-04 18:45:00','509','2022-10-04 18:46:32',10,0),('1','139',257779,'DAILY SHIFT','2022-10-05','2022-10-05 07:45:27','2022-10-06 07:45:27','509',0.00,0.00,'509','2022-10-05 10:52:14','509','2022-10-05 10:52:38',10,0),('1','139',257780,'DAILY SHIFT','2022-10-05','2022-10-05 11:05:06','2022-10-06 11:05:06','509',0.00,0.00,'509','2022-10-05 11:11:14','509','2022-10-05 11:11:36',10,0),('1','139',257781,'DAILY SHIFT','2022-10-07','2022-10-07 11:06:52','2022-10-08 11:06:52','509',0.00,0.00,'509','2022-10-07 21:03:45','509','2022-10-07 21:04:10',10,0),('1','139',257782,'DAILY SHIFT','2022-10-08','2022-10-08 07:52:02','2022-10-09 07:52:02','509',0.00,0.00,'509','2022-10-08 18:50:55','509','2022-10-08 18:51:59',10,0),('1','139',257783,'DAILY SHIFT','2022-10-09','2022-10-09 08:04:16','2022-10-10 08:04:16','509',0.00,0.00,'509','2022-10-09 18:57:27','509','2022-10-09 18:58:25',10,0),('1','139',257784,'DAILY SHIFT','2022-10-10','2022-10-10 07:53:47','2022-10-11 07:53:47','509',0.00,0.00,'509','2022-10-10 13:32:03','509','2022-10-10 13:32:34',10,0),('1','139',257785,'DAILY SHIFT','2022-10-14','2022-10-14 00:32:18','2022-10-15 00:32:18','509',0.00,0.00,'509','2022-10-14 00:35:48','509','2022-10-14 00:36:14',10,0),('1','139',257786,'DAILY SHIFT','2022-10-14','2022-10-14 07:38:19','2022-10-15 07:38:19','509',0.00,0.00,'509','2022-10-14 18:54:28','509','2022-10-14 18:54:56',10,0),('1','139',257787,'DAILY SHIFT','2022-10-15','2022-10-15 07:50:32','2022-10-16 07:50:32','509',0.00,0.00,'509','2022-10-15 19:15:21','509','2022-10-15 19:15:54',10,0),('1','139',257788,'DAILY SHIFT','2022-10-16','2022-10-16 07:42:15','2022-10-17 07:42:15','509',0.00,0.00,'509','2022-10-16 18:40:49','509','2022-10-16 18:50:48',10,0),('1','139',257789,'DAILY SHIFT','2022-10-17','2022-10-17 07:51:57','2022-10-18 07:51:57','509',0.00,0.00,'509','2022-10-17 18:52:52','509','2022-10-17 18:53:20',10,0),('1','139',257790,'DAILY SHIFT','2022-10-18','2022-10-18 07:49:55','2022-10-19 07:49:55','509',0.00,0.00,'509','2022-10-18 17:15:29','509','2022-10-18 17:15:59',10,0),('1','139',257791,'Daily shift ','2022-10-20','2022-10-20 10:18:06','2022-10-21 10:18:06','509',0.00,0.00,'509','2022-10-20 10:23:39','509','2022-10-20 10:24:01',10,0),('1','139',257792,'DAILY SHIFT','2022-10-22','2022-10-22 09:30:20','2022-10-23 09:30:20','509',0.00,0.00,'509','2022-10-22 18:58:47','509','2022-10-22 19:00:17',10,0),('1','139',257793,'DAILY SHIFT','2022-10-23','2022-10-23 07:56:08','2022-10-24 07:56:08','509',0.00,0.00,'509','2022-10-23 18:21:58','509','2022-10-23 18:22:22',10,0),('1','139',257794,'DAILY SHIFT','2022-10-24','2022-10-24 07:44:10','2022-10-25 07:44:10','509',0.00,0.00,'509','2022-10-24 18:46:26','509','2022-10-24 18:52:51',10,0),('1','139',257795,'DAILY SHIFT','2022-10-25','2022-10-25 07:45:33','2022-10-26 07:45:33','509',0.00,0.00,'509','2022-10-25 18:38:48','509','2022-10-25 18:39:31',10,0),('1','139',257796,'DAILY SHIFT','2022-10-26','2022-10-26 07:19:20','2022-10-27 07:19:20','509',0.00,0.00,'509','2022-10-26 18:34:00','509','2022-10-26 18:34:40',10,0),('1','139',257797,'DAILY SHIFT','2022-10-27','2022-10-27 07:46:30','2022-10-28 07:46:30','509',0.00,0.00,'509','2022-10-27 18:51:43','509','2022-10-27 18:52:13',10,0),('1','139',257798,'DAILY SHIFT','2022-10-28','2022-10-28 07:54:36','2022-10-29 07:54:36','509',0.00,0.00,'509','2022-10-28 19:10:58','509','2022-10-28 19:11:26',10,0),('1','139',257799,'DAILY SHIFT','2022-10-28','2022-10-28 19:13:56','2022-10-29 19:13:56','509',0.00,0.00,'509','2022-10-28 19:28:56','509','2022-10-28 19:33:11',10,0),('1','139',257800,'DAILY SHIFT','2022-11-06','2022-11-06 07:53:11','2022-11-07 07:53:11','509',0.00,0.00,'509','2022-11-06 20:25:19','509','2022-11-06 20:26:07',10,0),('1','139',257801,'DAILY SHIFT','2022-11-07','2022-11-07 07:49:25','2022-11-08 07:49:25','509',0.00,0.00,'509','2022-11-07 19:00:03','509','2022-11-07 19:10:17',10,0),('1','139',257802,'DAILY SHIFT','2022-11-08','2022-11-08 07:07:13','2022-11-09 07:07:13','509',0.00,0.00,'509','2022-11-08 18:24:08','509','2022-11-08 18:24:46',10,0),('1','139',257803,'DAILY SHIFT','2022-11-09','2022-11-09 07:06:23','2022-11-10 07:06:23','509',0.00,0.00,'509','2022-11-09 12:58:33','509','2022-11-09 12:59:02',10,0),('1','139',257804,'DAILY SHIFT','2022-11-09','2022-11-09 13:18:00','2022-11-10 13:18:00','509',0.00,0.00,'509','2022-11-09 14:26:21','509','2022-11-09 14:29:49',10,0),('1','139',257805,'DAILY SHIFT','2022-11-09','2022-11-09 14:30:30','2022-11-10 14:30:30','509',0.00,0.00,'509','2022-11-09 18:50:50','509','2022-11-09 18:51:14',10,0),('1','139',257806,'DAILY SHIFT','2022-11-10','2022-11-10 07:22:56','2022-11-11 07:22:56','509',0.00,0.00,'509','2022-11-10 19:59:18','509','2022-11-10 20:00:42',10,0),('1','139',257807,'DAILY SHIFT','2022-11-11','2022-11-11 08:17:01','2022-11-12 08:17:01','509',0.00,0.00,'509','2022-11-11 18:43:12','509','2022-11-11 18:43:39',10,0),('1','139',257808,'Daily shift','2022-11-12','2022-11-12 07:06:22','2022-11-13 07:06:22','509',0.00,0.00,'509','2022-11-12 18:33:18','509','2022-11-12 18:33:44',10,0),('1','139',257809,'Daily shift','2022-11-13','2022-11-13 07:29:50','2022-11-14 07:29:50','509',0.00,0.00,'509','2022-11-13 18:52:10','509','2022-11-13 18:52:52',10,0),('1','139',257810,'DAILY SHIFT','2022-11-14','2022-11-14 07:32:36','2022-11-15 07:32:36','509',0.00,0.00,'509','2022-11-14 18:35:25','509','2022-11-14 18:35:54',10,0),('1','139',257811,'DAILY SHIFT','2022-11-15','2022-11-15 07:15:31','2022-11-16 07:15:31','509',0.00,0.00,'509','2022-11-15 18:40:40','509','2022-11-15 18:41:05',10,0),('1','139',257812,'DAILY SHIFT','2022-11-16','2022-11-16 07:34:10','2022-11-17 07:34:10','509',0.00,0.00,'509','2022-11-16 18:28:16','509','2022-11-16 18:28:51',10,0),('1','139',257813,'DAILY SHIFT','2022-11-17','2022-11-17 07:18:26','2022-11-18 07:18:26','509',0.00,0.00,'509','2022-11-17 18:37:40','509','2022-11-17 18:38:20',10,0),('1','139',257814,'DAILY SHIFT','2022-11-18','2022-11-18 07:28:45','2022-11-19 07:28:45','509',0.00,0.00,'509','2022-11-18 18:39:38','509','2022-11-18 18:40:23',10,0),('1','139',257815,'DAILY SHIFT','2022-11-19','2022-11-19 07:31:57','2022-11-20 07:31:57','509',0.00,0.00,'509','2022-11-19 14:20:08','509','2022-11-19 14:20:38',10,0),('1','139',257816,'Daily shift ','2022-11-19','2022-11-19 17:09:36','2022-11-20 17:09:36','509',0.00,0.00,'509','2022-11-19 17:34:36','509','2022-11-19 17:34:55',10,0),('1','139',257817,'DAILY SHIFT','2022-11-19','2022-11-19 17:41:55','2022-11-20 17:41:55','509',0.00,0.00,'509','2022-11-19 18:38:34','509','2022-11-19 18:38:58',10,0),('1','139',257818,'DAILY SHIFT','2022-11-20','2022-11-20 07:23:11','2022-11-21 07:23:11','509',0.00,0.00,'509','2022-11-20 18:33:49','509','2022-11-20 18:34:17',10,0),('1','139',257819,'DAILY SHIFT','2022-11-21','2022-11-21 07:28:39','2022-11-22 07:28:39','509',0.00,0.00,'509','2022-11-21 18:21:51','509','2022-11-21 18:22:19',10,0),('1','139',257820,'DAILY SHIFT','2022-11-22','2022-11-22 07:46:27','2022-11-23 07:46:27','509',0.00,0.00,'509','2022-11-22 18:23:00','509','2022-11-22 18:32:50',10,0),('1','139',257821,'DAILY SHIFT','2022-11-23','2022-11-23 07:28:43','2022-11-24 07:28:43','509',0.00,0.00,'509','2022-11-23 18:22:19','509','2022-11-23 18:26:52',10,0),('1','139',257822,'DAILY SHIFT','2022-11-24','2022-11-24 07:26:49','2022-11-25 07:26:49','509',0.00,0.00,'509','2022-11-24 18:30:00','509','2022-11-24 18:31:05',10,0),('1','139',257823,'DAILY SHIFT','2022-11-25','2022-11-25 07:37:12','2022-11-26 07:37:12','509',0.00,0.00,'509','2022-11-25 18:38:02','509','2022-11-25 18:38:29',10,0),('1','139',257824,'DAILY SHIFT','2022-11-26','2022-11-26 10:00:25','2022-11-27 10:00:25','509',0.00,0.00,'509','2022-11-26 18:27:08','509','2022-11-26 18:27:47',10,0),('1','139',257825,'DAILY SHIFT','2022-11-27','2022-11-27 07:54:37','2022-11-28 07:54:37','509',0.00,0.00,'509','2022-11-27 18:31:57','509','2022-11-27 18:32:27',10,0),('1','139',257826,'DAILY SHIFT','2022-11-28','2022-11-28 07:36:10','2022-11-29 07:36:10','509',0.00,0.00,'509','2022-11-28 14:56:42','509','2022-11-28 14:57:06',10,0),('1','139',257827,'DAILY SHIFT','2022-11-28','2022-11-28 14:57:55','2022-11-29 14:57:55','509',0.00,0.00,'509','2022-11-28 15:21:28','509','2022-11-28 15:21:50',10,0),('1','139',257828,'DAILY SHIFT','2022-11-28','2022-11-28 17:25:46','2022-11-29 17:25:46','509',0.00,0.00,'509','2022-11-28 18:35:42','509','2022-11-28 18:36:50',10,0),('1','139',257829,'Daily shirft','2022-11-29','2022-11-29 07:33:02','2022-11-30 07:33:02','509',0.00,0.00,'509','2022-11-29 18:32:31','509','2022-11-29 18:39:38',10,0),('1','139',257830,'Daily shirft','2022-11-30','2022-11-30 07:22:09','2022-12-01 07:22:09','509',0.00,0.00,'509','2022-11-30 18:35:11','509','2022-11-30 18:35:44',10,0),('1','139',257831,'Daily shirft','2022-12-01','2022-12-01 07:10:08','2022-12-02 07:10:08','509',0.00,0.00,'509','2022-12-01 18:45:58','509','2022-12-01 18:46:28',10,0),('1','139',257832,'Daily shirft','2022-12-02','2022-12-02 07:31:32','2022-12-03 07:31:32','509',0.00,0.00,'509','2022-12-02 18:38:40','509','2022-12-02 18:39:42',10,0),('1','139',257833,'Daily shirft','2022-12-03','2022-12-03 07:16:03','2022-12-04 07:16:03','509',0.00,0.00,'509','2022-12-04 07:14:09','509','2022-12-04 07:14:48',10,0),('1','139',257834,'Daily shift','2022-12-04','2022-12-04 07:15:35','2022-12-05 07:15:35','509',0.00,0.00,'509','2022-12-04 18:11:54','509','2022-12-04 18:13:55',10,0),('1','139',257835,'Daily shirft','2022-12-05','2022-12-05 07:08:55','2022-12-06 07:08:55','509',0.00,0.00,'509','2022-12-05 19:16:09','509','2022-12-05 19:16:33',10,0),('1','139',257836,'Daily shirft','2022-12-06','2022-12-06 07:07:33','2022-12-07 07:07:33','509',0.00,0.00,'509','2022-12-06 18:43:21','509','2022-12-06 18:51:30',10,0),('1','139',257837,'Daily shirft','2022-12-07','2022-12-07 07:18:44','2022-12-08 07:18:44','509',0.00,0.00,'509','2022-12-07 15:44:34','509','2022-12-07 15:45:00',10,0),('1','139',257838,'DAILY SHIFT','2022-12-07','2022-12-07 15:46:03','2022-12-08 15:46:03','509',0.00,0.00,'509','2022-12-07 15:52:53','509','2022-12-07 15:53:21',10,0),('1','139',257839,'Daily shift','2022-12-08','2022-12-08 07:24:25','2022-12-09 07:24:25','509',0.00,0.00,'509','2022-12-08 18:16:32','509','2022-12-08 18:17:04',10,0),('1','139',257840,'DAILY SHIFT','2022-12-09','2022-12-09 07:25:45','2022-12-10 07:25:45','509',0.00,0.00,'509','2022-12-09 18:44:27','509','2022-12-09 18:45:15',10,0),('1','139',257841,'DAILY SHIFT','2022-12-10','2022-12-10 07:25:08','2022-12-11 07:25:08','509',0.00,0.00,'509','2022-12-10 18:39:21','509','2022-12-10 18:41:00',10,0),('1','139',257842,'DAILY SHIFT','2022-12-11','2022-12-11 07:28:41','2022-12-12 07:28:41','509',0.00,0.00,'509','2022-12-11 18:40:03','509','2022-12-11 18:40:37',10,0),('1','139',257843,'DAILY SHIFT','2022-12-12','2022-12-12 07:39:14','2022-12-13 07:39:14','509',0.00,0.00,'509','2022-12-12 18:25:31','509','2022-12-12 18:26:04',10,0),('1','139',257844,'Daily shift','2022-12-13','2022-12-13 07:00:04','2022-12-14 07:00:04','509',0.00,0.00,'509','2022-12-13 18:28:35','509','2022-12-13 18:29:03',10,0),('1','139',257845,'Daily shirft','2022-12-14','2022-12-14 07:20:36','2022-12-15 07:20:36','509',0.00,0.00,'509','2022-12-14 18:18:35','509','2022-12-14 18:19:07',10,0),('1','139',257846,'Daily shift','2022-12-15','2022-12-15 07:19:36','2022-12-16 07:19:36','509',0.00,0.00,'509','2022-12-15 18:43:07','509','2022-12-15 18:43:34',10,0),('1','139',257847,'DAILY SHIFT','2022-12-16','2022-12-16 07:37:03','2022-12-17 07:37:03','509',0.00,0.00,'509','2022-12-16 18:36:12','509','2022-12-16 18:36:43',10,0),('1','139',257848,'DAILY SHIFT','2022-12-17','2022-12-17 09:46:58','2022-12-18 09:46:58','509',0.00,0.00,'509','2022-12-17 18:29:58','509','2022-12-17 18:31:12',10,0),('1','139',257849,'DAILY SHIFT','2022-12-18','2022-12-18 07:32:18','2022-12-19 07:32:18','509',0.00,0.00,'509','2022-12-18 20:38:36','509','2022-12-18 20:39:03',10,0),('1','139',257850,'DAILY SHIFT','2022-12-19','2022-12-19 07:41:25','2022-12-20 07:41:25','509',0.00,0.00,'509','2022-12-19 07:47:04','509','2022-12-19 07:47:31',10,0),('1','139',257851,'DAILY SHIFT','2022-12-19','2022-12-19 08:21:04','2022-12-20 08:21:04','509',0.00,0.00,'509','2022-12-19 18:58:11','509','2022-12-19 18:58:35',10,0),('1','139',257852,'DAILY SHIFT','2022-12-20','2022-12-20 07:24:13','2022-12-21 07:24:13','509',0.00,0.00,'509','2022-12-20 18:52:48','509','2022-12-20 18:53:16',10,0),('1','139',257853,'DAILY SHIFT','2022-12-21','2022-12-21 07:29:35','2022-12-22 07:29:35','509',0.00,0.00,'509','2022-12-21 18:41:33','509','2022-12-21 18:41:56',10,0),('1','139',257854,'DAILY SHIFT','2022-12-22','2022-12-22 07:36:08','2022-12-23 07:36:08','509',0.00,0.00,'509','2022-12-22 18:31:35','509','2022-12-22 18:34:25',10,0),('1','139',257855,'DAILY SHIFT','2022-12-23','2022-12-23 07:40:27','2022-12-24 07:40:27','509',0.00,0.00,'509','2022-12-23 18:20:44','509','2022-12-23 18:22:01',10,0),('1','139',257856,'DAILY SHIFT','2022-12-24','2022-12-24 07:37:21','2022-12-25 07:37:21','509',0.00,0.00,'509','2022-12-24 18:57:39','509','2022-12-24 18:58:46',10,0),('1','139',257857,'DAILY SHIFT','2022-12-25','2022-12-25 07:38:38','2022-12-26 07:38:38','509',0.00,0.00,'509','2022-12-25 18:03:47','509','2022-12-25 18:04:12',10,0),('1','139',257858,'DAILY SHIFT','2022-12-26','2022-12-26 07:52:33','2022-12-27 07:52:33','509',0.00,0.00,'509','2022-12-26 18:52:33','509','2022-12-26 18:53:07',10,0),('1','139',257859,'DAILY SHIFT','2022-12-27','2022-12-27 07:46:20','2022-12-28 07:46:20','509',0.00,0.00,'509','2022-12-27 19:12:27','509','2022-12-27 19:15:01',10,0),('1','139',257860,'Daily shift ','2022-12-28','2022-12-28 08:00:57','2022-12-29 08:00:57','509',0.00,0.00,'509','2022-12-28 08:06:16','509','2022-12-28 08:06:41',10,0),('1','139',257861,'DAILY SHIFT','2022-12-28','2022-12-28 08:33:35','2022-12-29 08:33:35','509',0.00,0.00,'509','2022-12-28 18:42:12','509','2022-12-28 18:43:12',10,0),('1','139',257862,'Daily shift','2022-12-29','2022-12-29 07:11:33','2022-12-30 07:11:33','509',0.00,0.00,'509','2022-12-29 18:26:49','509','2022-12-29 18:27:15',10,0),('1','139',257863,'DAILY','2022-12-30','2022-12-30 07:28:23','2022-12-31 07:28:23','509',0.00,0.00,'509','2022-12-30 18:29:11','509','2022-12-30 18:29:38',10,0),('1','139',257864,'DAILY SHIFT','2022-12-31','2022-12-31 08:18:01','2023-01-01 08:18:01','509',0.00,0.00,'509','2022-12-31 18:28:28','509','2022-12-31 18:28:54',10,0),('1','139',257865,'DAILY SHIFT','2023-01-01','2023-01-01 07:41:12','2023-01-02 07:41:12','509',0.00,0.00,'509','2023-01-01 18:18:10','509','2023-01-01 18:18:36',10,0),('1','139',257866,'DAILY SHIFT','2023-01-02','2023-01-02 07:42:09','2023-01-03 07:42:09','509',0.00,0.00,'509','2023-01-02 18:21:15','509','2023-01-02 18:21:41',10,0),('1','139',257867,'DAILY SHIFT','2023-01-03','2023-01-03 07:53:50','2023-01-04 07:53:50','509',0.00,0.00,'509','2023-01-03 18:30:50','509','2023-01-03 18:31:13',10,0),('1','139',257868,'DAILY SHIFT','2023-01-04','2023-01-04 07:45:50','2023-01-05 07:45:50','509',0.00,0.00,'509','2023-01-04 18:45:44','509','2023-01-04 18:46:18',10,0),('1','139',257869,'DAILY SHIFT','2023-01-05','2023-01-05 07:51:55','2023-01-06 07:51:55','509',0.00,0.00,'509','2023-01-05 18:34:13','509','2023-01-05 18:34:35',10,0),('1','139',257870,'DAILY SHIFT','2023-01-06','2023-01-06 08:24:53','2023-01-07 08:24:53','509',0.00,0.00,'509','2023-01-06 18:33:44','509','2023-01-06 18:34:37',10,0),('1','139',257871,'DAILY','2023-01-07','2023-01-07 07:14:59','2023-01-08 07:14:59','509',0.00,0.00,'509','2023-01-07 18:43:50','509','2023-01-07 18:45:10',10,0),('1','139',257872,'DAILY SHIFT','2023-01-08','2023-01-08 07:57:30','2023-01-09 07:57:30','509',0.00,0.00,'509','2023-01-08 19:25:07','509','2023-01-08 19:25:34',10,0),('1','139',257873,'DAILY SHIFT','2023-01-08','2023-01-08 19:26:21','2023-01-09 19:26:21','509',0.00,0.00,'509','2023-01-08 19:29:13','509','2023-01-08 19:29:40',10,0),('1','139',257874,'DAILY SHIFT','2023-01-09','2023-01-09 07:51:29','2023-01-10 07:51:29','509',0.00,0.00,'509','2023-01-09 18:51:40','509','2023-01-09 18:52:23',10,0),('1','139',257875,'DAILY SHIFT','2023-01-10','2023-01-10 08:09:46','2023-01-11 08:09:46','509',0.00,0.00,'509','2023-01-10 18:44:23','509','2023-01-10 18:44:56',10,0),('1','139',257876,'DAILY SHIFT','2023-01-11','2023-01-11 07:49:23','2023-01-12 07:49:23','509',0.00,0.00,'509','2023-01-11 18:29:08','509','2023-01-11 18:29:32',10,0),('1','139',257877,'DAILY SHIFT','2023-01-12','2023-01-12 07:48:01','2023-01-13 07:48:01','509',0.00,0.00,'509','2023-01-12 18:41:21','509','2023-01-12 18:41:46',10,0),('1','139',257878,'DAILY SHIFT','2023-01-13','2023-01-13 07:53:44','2023-01-14 07:53:44','509',0.00,0.00,'509','2023-01-13 18:36:46','509','2023-01-13 18:37:15',10,0),('1','139',257879,'DAILY SHIFT','2023-01-14','2023-01-14 07:48:49','2023-01-15 07:48:49','509',0.00,0.00,'509','2023-01-14 18:43:21','509','2023-01-14 18:43:50',10,0),('1','139',257880,'DAILY SHIFT','2023-01-15','2023-01-15 07:45:52','2023-01-16 07:45:52','509',0.00,0.00,'509','2023-01-15 18:33:57','509','2023-01-15 18:34:29',10,0),('1','139',257881,'DAILY SHIFT','2023-01-16','2023-01-16 07:50:40','2023-01-17 07:50:40','509',0.00,0.00,'509','2023-01-16 18:28:59','509','2023-01-16 18:29:26',10,0),('1','139',257882,'DAILY SHIFT','2023-01-17','2023-01-17 07:49:54','2023-01-18 07:49:54','509',0.00,0.00,'509','2023-01-17 11:28:10','509','2023-01-17 11:28:34',10,0),('1','139',257883,'DAILY SHIFT','2023-01-17','2023-01-17 11:29:06','2023-01-18 11:29:06','509',0.00,0.00,'509','2023-01-17 11:33:45','509','2023-01-17 11:34:09',10,0),('1','139',257884,'DAILY SHIFT','2023-01-17','2023-01-17 14:18:23','2023-01-18 14:18:23','509',0.00,0.00,'509','2023-01-17 18:45:18','509','2023-01-17 18:45:48',10,0),('1','139',257885,'DAILY SHIFT','2023-01-18','2023-01-18 07:51:00','2023-01-19 07:51:00','509',0.00,0.00,'509','2023-01-18 18:42:35','509','2023-01-18 18:43:04',10,0),('1','139',257886,'DAILY SHIFT','2023-01-19','2023-01-19 07:45:37','2023-01-20 07:45:37','509',0.00,0.00,'509','2023-01-19 18:44:46','509','2023-01-19 18:49:58',10,0),('1','139',257887,'DAILY SHIFT','2023-01-20','2023-01-20 07:53:19','2023-01-21 07:53:19','509',0.00,0.00,'509','2023-01-20 19:15:53','509','2023-01-20 19:16:22',10,0),('1','139',257888,'DAILY SHIFT','2023-01-21','2023-01-21 07:27:43','2023-01-22 07:27:43','509',0.00,0.00,'509','2023-01-21 18:46:53','509','2023-01-21 18:47:23',10,0),('1','139',257889,'Daily shirft','2023-01-22','2023-01-22 07:33:32','2023-01-23 07:33:32','509',0.00,0.00,'509','2023-01-22 18:31:26','509','2023-01-22 18:31:56',10,0),('1','139',257890,'Daily shirft','2023-01-23','2023-01-23 07:30:59','2023-01-24 07:30:59','509',0.00,0.00,'509','2023-01-23 19:00:40','509','2023-01-23 19:01:22',10,0),('1','139',257891,'Daily shirft','2023-01-24','2023-01-24 07:05:10','2023-01-25 07:05:10','509',0.00,0.00,'509','2023-01-24 19:33:39','509','2023-01-24 19:36:04',10,0),('1','139',257892,'Daily shirft','2023-01-25','2023-01-25 07:29:09','2023-01-26 07:29:09','509',0.00,0.00,'509','2023-01-25 14:11:10','509','2023-01-25 14:12:45',10,0),('1','139',257893,'DAILY SHIFT','2023-01-25','2023-01-25 14:17:33','2023-01-26 14:17:33','509',0.00,0.00,'509','2023-01-25 16:49:39','509','2023-01-25 16:50:07',10,0),('1','139',257894,'Daily shift','2023-01-26','2023-01-26 07:43:04','2023-01-27 07:43:04','509',0.00,0.00,'509','2023-01-27 07:45:12','509','2023-01-27 07:45:49',10,0),('1','139',257895,'Daily shift','2023-01-27','2023-01-27 07:47:07','2023-01-28 07:47:07','509',0.00,0.00,'509','2023-01-27 19:28:56','509','2023-01-27 19:29:26',10,0),('1','139',257896,'Daily shirft','2023-01-28','2023-01-28 10:18:46','2023-01-29 10:18:46','509',0.00,0.00,'509','2023-01-29 07:13:44','509','2023-01-29 07:16:37',10,0),('1','139',257897,'Daily shift','2023-01-29','2023-01-29 07:17:11','2023-01-30 07:17:11','509',0.00,0.00,'509','2023-01-29 18:42:57','509','2023-01-29 18:43:32',10,0),('1','139',257898,'Daily shirft','2023-01-30','2023-01-30 07:25:20','2023-01-31 07:25:20','509',0.00,0.00,'509','2023-01-30 18:52:04','509','2023-01-30 18:52:37',10,0),('1','139',257899,'Daily shirft','2023-01-31','2023-01-31 07:15:58','2023-02-01 07:15:58','509',0.00,0.00,'509','2023-01-31 19:11:01','509','2023-01-31 19:11:56',10,0),('1','139',257900,'Daily shirft','2023-02-01','2023-02-01 07:20:39','2023-02-02 07:20:39','509',0.00,0.00,'509','2023-02-01 18:51:09','509','2023-02-01 18:51:58',10,0),('1','139',257901,'Daily shirft','2023-02-02','2023-02-02 07:33:46','2023-02-03 07:33:46','509',0.00,0.00,'509','2023-02-03 07:24:05','509','2023-02-03 07:24:29',10,0),('1','139',257902,'Daily shirft','2023-02-03','2023-02-03 07:24:59','2023-02-04 07:24:59','509',0.00,0.00,'509','2023-02-03 19:38:53','509','2023-02-03 19:39:16',10,0),('1','139',257903,'Daily shift','2023-02-04','2023-02-04 07:34:12','2023-02-05 07:34:12','509',0.00,0.00,'509','2023-02-04 18:50:05','509','2023-02-04 18:50:56',10,0),('1','139',257904,'Daily shift','2023-02-05','2023-02-05 07:20:21','2023-02-06 07:20:21','509',0.00,0.00,'509','2023-02-05 21:04:18','509','2023-02-05 21:04:40',10,0),('1','139',257905,'DAILY SHIFT','2023-02-05','2023-02-05 21:05:07','2023-02-06 21:05:07','509',0.00,0.00,'509','2023-02-06 10:23:18','509','2023-02-06 10:23:49',10,0),('1','139',257906,'DAILY SHIFT','2023-02-06','2023-02-06 10:24:33','2023-02-07 10:24:33','509',0.00,0.00,'509','2023-02-06 19:42:24','509','2023-02-06 19:42:52',10,0),('1','139',257907,'DAILY SHIFT','2023-02-07','2023-02-07 07:34:23','2023-02-08 07:34:23','509',0.00,0.00,'509','2023-02-07 19:11:03','509','2023-02-07 19:11:32',10,0),('1','139',257908,'DAILY SHIFT','2023-02-08','2023-02-08 07:34:45','2023-02-09 07:34:45','509',0.00,0.00,'509','2023-02-08 18:57:52','509','2023-02-08 18:58:16',10,0),('1','139',257909,'DAILY SHIFT','2023-02-09','2023-02-09 07:42:10','2023-02-10 07:42:10','509',0.00,0.00,'509','2023-02-09 19:12:23','509','2023-02-09 19:18:05',10,0),('1','139',257910,'DAILY SHIFT','2023-02-10','2023-02-10 07:49:05','2023-02-11 07:49:05','509',0.00,0.00,'509','2023-02-10 19:04:25','509','2023-02-10 19:04:59',10,0),('1','139',257911,'DAILY SHIFT','2023-02-11','2023-02-11 07:51:15','2023-02-12 07:51:15','509',0.00,0.00,'509','2023-02-11 19:02:10','509','2023-02-11 19:02:58',10,0),('1','139',257912,'DAILY SHIFT','2023-02-12','2023-02-12 07:52:49','2023-02-13 07:52:49','509',0.00,0.00,'509','2023-02-12 18:58:13','509','2023-02-12 18:58:38',10,0),('1','139',257913,'DAILY SHIFT','2023-02-13','2023-02-13 07:51:29','2023-02-14 07:51:29','509',0.00,0.00,'509','2023-02-13 19:22:11','509','2023-02-13 19:22:38',10,0),('1','139',257914,'DAILY SHIFT','2023-02-14','2023-02-14 07:49:13','2023-02-15 07:49:13','509',0.00,0.00,'509','2023-02-14 18:42:18','509','2023-02-14 18:43:04',10,0),('1','139',257915,'DAILY SHIFT','2023-02-15','2023-02-15 07:49:38','2023-02-16 07:49:38','509',0.00,0.00,'509','2023-02-15 17:27:54','509','2023-02-15 17:29:38',10,0),('1','139',257916,'Daily shift ','2023-02-15','2023-02-15 17:42:15','2023-02-16 17:42:15','509',0.00,0.00,'509','2023-02-15 17:50:59','509','2023-02-15 17:51:32',10,0),('1','139',257917,'DAILY SHIFT','2023-02-16','2023-02-16 08:42:44','2023-02-17 08:42:44','509',0.00,0.00,'509','2023-02-16 19:31:34','509','2023-02-16 19:32:07',10,0),('1','139',257918,'DAILY SHIFT','2023-02-17','2023-02-17 08:07:54','2023-02-18 08:07:54','509',0.00,0.00,'509','2023-02-17 18:57:32','509','2023-02-17 18:57:57',10,0),('1','139',257919,'DAILY SHIFT','2023-02-18','2023-02-18 07:50:51','2023-02-19 07:50:51','509',0.00,0.00,'509','2023-02-18 19:38:27','509','2023-02-18 19:38:59',10,0),('1','139',257920,'DAILY SHIFT','2023-02-19','2023-02-19 07:50:58','2023-02-20 07:50:58','509',0.00,0.00,'509','2023-02-19 19:04:51','509','2023-02-19 19:05:17',10,0),('1','139',257921,'DAILY SHIFT','2023-02-20','2023-02-20 07:46:01','2023-02-21 07:46:01','509',0.00,0.00,'509','2023-02-20 19:03:07','509','2023-02-20 19:03:37',10,0),('1','139',257922,'DAILY SHIFT','2023-02-21','2023-02-21 07:51:58','2023-02-22 07:51:58','509',0.00,0.00,'509','2023-02-21 18:55:12','509','2023-02-21 18:56:27',10,0),('1','139',257923,'DAILY SHIFT','2023-02-22','2023-02-22 08:04:29','2023-02-23 08:04:29','509',0.00,0.00,'509','2023-02-22 18:54:17','509','2023-02-22 18:54:49',10,0),('1','139',257924,'DAILY SHIFT','2023-02-23','2023-02-23 07:58:43','2023-02-24 07:58:43','509',0.00,0.00,'509','2023-02-23 19:16:01','509','2023-02-23 19:16:28',10,0),('1','139',257925,'DAILY SHIFT','2023-02-24','2023-02-24 08:01:47','2023-02-25 08:01:47','509',0.00,0.00,'509','2023-02-24 19:39:01','509','2023-02-24 19:39:43',10,0),('1','139',257926,'DAILY SHIFT','2023-02-26','2023-02-26 08:16:40','2023-02-27 08:16:40','509',0.00,0.00,'509','2023-02-26 18:56:30','509','2023-02-26 18:57:04',10,0),('1','139',257927,'DAILY SHIFT','2023-02-27','2023-02-27 08:01:15','2023-02-28 08:01:15','509',0.00,0.00,'509','2023-02-27 19:19:56','509','2023-02-27 19:20:28',10,0),('1','139',257928,'DAILY SHIFT','2023-02-28','2023-02-28 07:50:23','2023-03-01 07:50:23','509',0.00,0.00,'509','2023-02-28 19:18:03','509','2023-02-28 19:18:37',10,0),('1','139',257929,'DAILY SHIFT','2023-03-01','2023-03-01 07:40:23','2023-03-02 07:40:23','509',0.00,0.00,'509','2023-03-01 16:27:37','509','2023-03-01 16:28:01',10,0),('1','139',257930,'DAILY SHIFT','2023-03-01','2023-03-01 16:28:27','2023-03-02 16:28:27','509',0.00,0.00,'509','2023-03-01 16:36:19','509','2023-03-01 16:36:54',10,0),('1','139',257931,'DAILY SHIFT','2023-03-01','2023-03-01 17:01:38','2023-03-02 17:01:38','509',0.00,0.00,'509','2023-03-01 19:28:59','509','2023-03-01 19:29:34',10,0),('1','139',257932,'DAILY SHIFT','2023-03-02','2023-03-02 07:47:03','2023-03-03 07:47:03','509',0.00,0.00,'509','2023-03-02 19:35:21','509','2023-03-02 19:35:45',10,0),('1','139',257933,'DAILY SHIFT','2023-03-03','2023-03-03 07:50:24','2023-03-04 07:50:24','509',0.00,0.00,'509','2023-03-03 19:15:24','509','2023-03-03 19:15:58',10,0),('1','139',257934,'DAILY SHIFT','2023-03-04','2023-03-04 08:01:59','2023-03-05 08:01:59','509',0.00,0.00,'509','2023-03-04 19:12:47','509','2023-03-04 19:13:19',10,0),('1','139',257935,'DAILY SHIFT','2023-03-05','2023-03-05 08:08:59','2023-03-06 08:08:59','509',0.00,0.00,'509','2023-03-05 19:13:36','509','2023-03-05 19:14:24',10,0),('1','139',257936,'DAILY SHIFT','2023-03-06','2023-03-06 07:50:00','2023-03-07 07:50:00','509',0.00,0.00,'509','2023-03-06 18:49:30','509','2023-03-06 18:49:52',10,0),('1','139',257937,'DAILY SHIFT','2023-03-07','2023-03-07 07:36:29','2023-03-08 07:36:29','509',0.00,0.00,'509','2023-03-07 19:06:06','509','2023-03-07 19:06:31',10,0),('1','139',257938,'Daily shift','2023-03-08','2023-03-08 07:38:18','2023-03-09 07:38:18','509',0.00,0.00,'509','2023-03-08 19:12:42','509','2023-03-08 19:13:08',10,0),('1','139',257939,'Daily shirft','2023-03-09','2023-03-09 07:14:03','2023-03-10 07:14:03','509',0.00,0.00,'509','2023-03-09 19:08:20','509','2023-03-09 19:15:18',10,0),('1','139',257940,'DAILY SHIFT','2023-03-10','2023-03-10 07:34:30','2023-03-11 07:34:30','509',0.00,0.00,'509','2023-03-10 19:08:12','509','2023-03-10 19:08:41',10,0),('1','139',257941,'DAILY SHIFT','2023-03-11','2023-03-11 07:53:14','2023-03-12 07:53:14','509',0.00,0.00,'509','2023-03-11 19:14:11','509','2023-03-11 19:15:20',10,0),('1','139',257942,'DAILY SHIFT','2023-03-12','2023-03-12 07:48:03','2023-03-13 07:48:03','509',0.00,0.00,'509','2023-03-12 19:19:46','509','2023-03-12 19:20:20',10,0),('1','139',257943,'DAILY SHIFT','2023-03-13','2023-03-13 07:37:40','2023-03-14 07:37:40','509',0.00,0.00,'509','2023-03-13 19:20:05','509','2023-03-13 19:20:41',10,0),('1','139',257944,'DAILY SHIFT','2023-03-14','2023-03-14 07:48:14','2023-03-15 07:48:14','509',0.00,0.00,'509','2023-03-14 19:17:27','509','2023-03-14 19:19:05',10,0),('1','139',257945,'DAILY SHIFT','2023-03-15','2023-03-15 07:39:30','2023-03-16 07:39:30','509',0.00,0.00,'509','2023-03-15 13:38:26','509','2023-03-15 13:38:48',10,0),('1','139',257946,'Daily shift ','2023-03-15','2023-03-15 13:39:24','2023-03-16 13:39:24','509',0.00,0.00,'509','2023-03-15 14:32:12','509','2023-03-15 14:32:59',10,0),('1','139',257947,'DAILY SHIFT','2023-03-15','2023-03-15 15:14:32','2023-03-16 15:14:32','509',0.00,0.00,'509','2023-03-15 19:04:49','509','2023-03-15 19:05:49',10,0),('1','139',257948,'DAILY SHIFT','2023-03-16','2023-03-16 07:42:43','2023-03-17 07:42:43','509',0.00,0.00,'509','2023-03-16 19:02:35','509','2023-03-16 19:03:12',10,0),('1','139',257949,'Daily shift','2023-03-17','2023-03-17 07:36:47','2023-03-18 07:36:47','509',0.00,0.00,'509','2023-03-18 07:43:35','509','2023-03-18 07:44:07',10,0),('1','139',257950,'Daily shirft','2023-03-19','2023-03-19 07:43:36','2023-03-20 07:43:36','509',0.00,0.00,'509','2023-03-20 07:38:24','509','2023-03-20 07:38:59',10,0),('1','139',257951,'DAILY SHIFT','2023-03-20','2023-03-20 07:39:30','2023-03-21 07:39:30','509',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4904560 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','139','772','146991',2940301,'2143','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','146991',2940302,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','147016',2940647,'2143','330',0.00,4687.60,0.00,0.00,4687.60,1054845.60,0.00,0.00,0.00),('1','139','772','147016',2940648,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','147072',2941516,'2143','330',4687.60,6520.40,0.00,0.00,1832.80,431324.80,0.00,0.00,0.00),('1','139','772','147072',2941517,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','147084',2941573,'2143','330',6520.40,8148.10,0.00,0.00,1627.70,395403.20,0.00,0.00,0.00),('1','139','772','147084',2941574,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','147090',2941607,'2143','330',8148.10,10594.10,0.00,0.00,2446.00,567609.60,0.00,0.00,0.00),('1','139','772','147090',2941608,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','147115',2941803,'2143','330',10594.10,12960.90,0.00,0.00,2366.80,555472.80,0.00,0.00,0.00),('1','139','772','147115',2941804,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','147137',2942089,'2143','330',12960.90,14849.80,0.00,0.00,1888.90,442848.40,0.00,0.00,0.00),('1','139','772','147137',2942090,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','147159',2942372,'2143','330',14849.80,17631.40,0.00,0.00,2781.60,626345.60,0.00,0.00,0.00),('1','139','772','147159',2942373,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','147437',2946717,'2143','330',17631.40,18746.40,0.00,0.00,1115.00,270612.00,0.00,0.00,0.00),('1','139','772','147437',2946718,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','147555',2948888,'2143','330',18746.40,21752.20,0.00,0.00,3005.80,694464.80,0.00,0.00,0.00),('1','139','772','147555',2948889,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','147676',2950948,'2143','330',21752.20,23356.10,0.00,0.00,1603.90,372961.20,0.00,0.00,0.00),('1','139','772','147676',2950949,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','147686',2951073,'2143','330',23356.10,25673.10,0.00,0.00,2317.00,528840.00,0.00,0.00,0.00),('1','139','772','147686',2951074,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','147989',2956332,'2143','330',25673.10,33351.10,0.00,0.00,7678.00,1660764.00,0.00,0.00,0.00),('1','139','772','147989',2956333,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','148124',2958645,'2143','330',33351.10,35019.40,0.00,0.00,1668.30,390430.80,0.00,0.00,0.00),('1','139','772','148124',2958646,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','148287',2961394,'2143','330',35019.40,37121.20,0.00,0.00,2101.80,483340.80,0.00,0.00,0.00),('1','139','772','148287',2961395,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','148409',2963708,'2143','330',37121.20,40487.20,0.00,0.00,3366.00,756255.20,0.00,0.00,0.00),('1','139','772','148409',2963709,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','148556',2966164,'2143','330',40487.20,42614.10,0.00,0.00,2126.90,486392.40,0.00,0.00,0.00),('1','139','772','148556',2966165,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','148662',2967976,'2143','330',42614.10,45720.70,0.00,0.00,3106.60,695393.60,0.00,0.00,0.00),('1','139','772','148662',2967977,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','148713',2968803,'2143','330',45720.70,46960.00,0.00,0.00,1239.30,289426.80,0.00,0.00,0.00),('1','139','772','148713',2968804,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','148972',2973420,'2143','330',46960.00,48232.10,0.00,0.00,1272.10,295875.60,0.00,0.00,0.00),('1','139','772','148972',2973421,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','149136',2976710,'2143','330',48232.10,52305.00,0.00,0.00,4072.90,908123.60,0.00,0.00,0.00),('1','139','772','149136',2976711,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','149295',2979438,'2143','330',52305.00,55360.40,0.00,0.00,3055.40,683825.40,0.00,0.00,0.00),('1','139','772','149295',2979439,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','149444',2981945,'2143','330',55360.40,60448.90,0.00,0.00,5088.50,1127398.00,0.00,0.00,0.00),('1','139','772','149444',2981946,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','149598',2984593,'2143','330',60448.90,65132.30,0.00,0.00,4683.40,1046814.40,0.00,0.00,0.00),('1','139','772','149598',2984594,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','149687',2985918,'2143','330',65132.30,67138.80,0.00,0.00,2006.50,466606.00,0.00,0.00,0.00),('1','139','772','149687',2985919,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','149754',2987080,'2143','330',67138.80,68045.60,0.00,0.00,906.80,203076.80,0.00,0.00,0.00),('1','139','772','149754',2987081,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','149759',2987193,'2143','330',68045.60,71586.80,0.00,0.00,3541.20,794373.60,0.00,0.00,0.00),('1','139','772','149759',2987194,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','150005',2991814,'2143','330',71586.80,75078.50,0.00,0.00,3491.70,799671.10,0.00,0.00,0.00),('1','139','772','150005',2991815,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','150144',2994759,'2143','330',75078.50,79130.90,0.00,0.00,4052.40,915362.40,0.00,0.00,0.00),('1','139','772','150144',2994760,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','150370',2998250,'2143','330',79130.90,82852.20,0.00,0.00,3721.30,833010.80,0.00,0.00,0.00),('1','139','772','150370',2998251,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','150543',3001728,'2143','330',82852.20,87258.00,0.00,0.00,4405.80,981726.40,0.00,0.00,0.00),('1','139','772','150543',3001729,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','150705',3005067,'2143','330',87258.00,89397.40,0.00,0.00,2139.40,485695.20,0.00,0.00,0.00),('1','139','772','150705',3005068,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','150708',3005111,'2143','330',89397.40,89397.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','150708',3005112,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','150832',3007348,'2143','330',89397.40,92509.60,0.00,0.00,3112.20,715900.00,0.00,0.00,0.00),('1','139','772','150832',3007349,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','150999',3010287,'2143','330',92509.60,94894.20,0.00,0.00,2384.60,548963.20,0.00,0.00,0.00),('1','139','772','150999',3010288,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','151149',3013068,'2143','330',94894.20,96956.60,0.00,0.00,2062.40,486030.40,0.00,0.00,0.00),('1','139','772','151149',3013069,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','151286',3015765,'2143','330',96956.60,99622.80,0.00,0.00,2666.20,615150.40,0.00,0.00,0.00),('1','139','772','151286',3015766,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','151444',3018649,'2143','330',99622.80,103043.50,0.00,0.00,3420.70,771738.80,0.00,0.00,0.00),('1','139','772','151444',3018650,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','151581',3021187,'2143','330',103043.50,104815.60,0.00,0.00,1772.10,417491.60,0.00,0.00,0.00),('1','139','772','151581',3021188,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','151690',3023156,'2143','330',104815.60,106465.80,0.00,0.00,1650.20,396739.20,0.00,0.00,0.00),('1','139','772','151690',3023157,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','151814',3025420,'2143','330',106465.80,108022.90,0.00,0.00,1557.10,365479.60,0.00,0.00,0.00),('1','139','772','151814',3025421,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','152000',3029091,'2143','330',108022.90,111485.60,0.00,0.00,3462.70,841697.20,0.00,0.00,0.00),('1','139','772','152000',3029092,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','152158',3031896,'2143','330',111485.60,111825.70,0.00,0.00,340.10,74822.00,0.00,0.00,0.00),('1','139','772','152158',3031897,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','152315',3034975,'2143','330',111825.70,111825.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','152315',3034976,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','152352',3035554,'2143','330',111825.70,113337.90,0.00,0.00,1512.20,352219.20,0.00,0.00,0.00),('1','139','772','152352',3035555,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','152353',3035556,'2143','330',113337.90,117595.10,0.00,0.00,4257.20,963575.20,0.00,0.00,0.00),('1','139','772','152353',3035557,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','152458',3037465,'2143','330',117595.10,120452.10,0.00,0.00,2857.00,648832.00,0.00,0.00,0.00),('1','139','772','152458',3037466,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','152618',3040275,'2143','330',120452.10,125757.50,0.00,0.00,5305.40,1182742.40,0.00,0.00,0.00),('1','139','772','152618',3040276,'2186','330',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','152773',3043079,'2143','330',125757.50,130780.00,0.00,0.00,5022.50,1103210.00,0.00,0.00,0.00),('1','139','772','152773',3043080,'2186','330',0.00,627.00,0.00,0.00,627.00,137940.00,0.00,0.00,0.00),('1','139','772','152901',3045404,'2143','330',130780.00,132168.10,0.00,0.00,1388.10,333042.40,0.00,0.00,0.00),('1','139','772','152901',3045405,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','153071',3048434,'2143','330',132168.10,133611.30,0.00,0.00,1443.20,323010.40,0.00,0.00,0.00),('1','139','772','153071',3048435,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','153072',3048436,'2143','330',133611.30,133611.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','153072',3048437,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','153434',3054987,'2143','330',133611.30,137518.50,0.00,0.00,3907.20,879620.80,0.00,0.00,0.00),('1','139','772','153434',3054988,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','153645',3058909,'2143','330',137518.50,139256.00,0.00,0.00,1737.50,410530.00,0.00,0.00,0.00),('1','139','772','153645',3058910,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','153797',3061594,'2143','330',139256.00,141922.40,0.00,0.00,2666.40,610606.40,0.00,0.00,0.00),('1','139','772','153797',3061595,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','153931',3063928,'2143','330',141922.40,144405.70,0.00,0.00,2483.30,586810.80,0.00,0.00,0.00),('1','139','772','153931',3063929,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','154066',3066187,'2143','330',144405.70,147183.70,0.00,0.00,2778.00,643556.00,0.00,0.00,0.00),('1','139','772','154066',3066188,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','154250',3069494,'2143','330',147183.70,150661.60,0.00,0.00,3477.90,801956.40,0.00,0.00,0.00),('1','139','772','154250',3069495,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','154405',3072380,'2143','330',150661.60,153252.70,0.00,0.00,2591.10,611607.60,0.00,0.00,0.00),('1','139','772','154405',3072381,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','154557',3075397,'2143','330',153252.70,156020.50,0.00,0.00,2767.80,615712.80,0.00,0.00,0.00),('1','139','772','154557',3075398,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','154558',3075399,'2143','330',156020.50,156020.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','154558',3075400,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','155025',3084088,'2143','330',156020.50,167653.60,0.00,0.00,11633.10,2637420.00,0.00,0.00,0.00),('1','139','772','155025',3084089,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','155136',3086276,'2143','330',167653.60,172889.80,0.00,0.00,5236.20,1207596.00,0.00,0.00,0.00),('1','139','772','155136',3086277,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','155298',3089284,'2143','330',172889.80,176213.50,0.00,0.00,3323.70,781618.40,0.00,0.00,0.00),('1','139','772','155298',3089285,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','155447',3092196,'2143','330',176213.50,178523.80,0.00,0.00,2310.30,531684.00,0.00,0.00,0.00),('1','139','772','155447',3092197,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','155450',3092232,'2143','330',178523.80,178523.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','155450',3092233,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','155645',3095698,'2143','330',178523.80,189580.70,0.00,0.00,11056.90,2546682.00,0.00,0.00,0.00),('1','139','772','155645',3095699,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','155782',3098142,'2143','330',189580.70,195581.60,0.00,0.00,6000.90,1381820.00,0.00,0.00,0.00),('1','139','772','155782',3098143,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','155938',3100828,'2143','330',195581.60,198090.30,0.00,0.00,2508.70,596148.40,0.00,0.00,0.00),('1','139','772','155938',3100829,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','156089',3103480,'2143','330',198090.30,201134.20,0.00,0.00,3043.90,720195.20,0.00,0.00,0.00),('1','139','772','156089',3103481,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','156298',3107225,'2143','330',201134.20,201134.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','156298',3107226,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','156301',3107265,'2143','330',201134.20,204163.80,0.00,0.00,3029.60,729679.20,0.00,0.00,0.00),('1','139','772','156301',3107266,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','156417',3109552,'2143','330',204163.80,208816.50,0.00,0.00,4652.70,1092817.20,0.00,0.00,0.00),('1','139','772','156417',3109553,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','156560',3112324,'2143','330',208816.50,210293.80,0.00,0.00,1477.30,361718.00,0.00,0.00,0.00),('1','139','772','156560',3112325,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','156736',3115519,'2143','330',210293.80,213066.50,0.00,0.00,2772.70,656442.00,0.00,0.00,0.00),('1','139','772','156736',3115520,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','156907',3118552,'2143','330',213066.50,215205.00,0.00,0.00,2138.50,509108.00,0.00,0.00,0.00),('1','139','772','156907',3118553,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','157088',3121771,'2143','330',215205.00,218510.00,0.00,0.00,3305.00,777056.00,0.00,0.00,0.00),('1','139','772','157088',3121772,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','157282',3125307,'2143','330',218510.00,221467.20,0.00,0.00,2957.20,705042.00,0.00,0.00,0.00),('1','139','772','157282',3125308,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','157451',3128068,'2143','330',221467.20,224579.60,0.00,0.00,3112.40,743176.00,0.00,0.00,0.00),('1','139','772','157451',3128069,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','157452',3128070,'2143','330',224579.60,224579.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','157452',3128071,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','157640',3131529,'2143','330',224579.60,227274.30,0.00,0.00,2694.70,645202.00,0.00,0.00,0.00),('1','139','772','157640',3131530,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','157822',3134751,'2143','330',227274.30,231896.90,0.00,0.00,4622.60,1079122.40,0.00,0.00,0.00),('1','139','772','157822',3134752,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','157953',3137332,'2143','330',231896.90,240037.30,0.00,0.00,8140.40,1859432.00,0.00,0.00,0.00),('1','139','772','157953',3137333,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','158089',3139798,'2143','330',240037.30,242756.30,0.00,0.00,2719.00,645810.00,0.00,0.00,0.00),('1','139','772','158089',3139799,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','158202',3141954,'2143','330',242756.30,244268.80,0.00,0.00,1512.50,355668.00,0.00,0.00,0.00),('1','139','772','158202',3141955,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','158209',3142062,'2143','330',244268.80,244268.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','158209',3142063,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','158426',3146210,'2143','330',244268.80,248881.90,0.00,0.00,4613.10,1066988.00,0.00,0.00,0.00),('1','139','772','158426',3146211,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','158582',3148835,'2143','330',248881.90,250114.40,0.00,0.00,1232.50,309220.00,0.00,0.00,0.00),('1','139','772','158582',3148836,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','158753',3152048,'2143','330',250114.40,252942.20,0.00,0.00,2827.80,667432.00,0.00,0.00,0.00),('1','139','772','158753',3152049,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','158925',3154997,'2143','330',252942.20,259485.90,0.00,0.00,6543.70,1506598.00,0.00,0.00,0.00),('1','139','772','158925',3154998,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','159112',3158304,'2143','330',259485.90,263491.20,0.00,0.00,4005.30,934448.00,0.00,0.00,0.00),('1','139','772','159112',3158305,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','159279',3161436,'2143','330',263491.20,266678.00,0.00,0.00,3186.80,739764.00,0.00,0.00,0.00),('1','139','772','159279',3161437,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','159280',3161438,'2143','330',266678.00,266678.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','159280',3161439,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','159460',3164201,'2143','330',266678.00,269688.90,0.00,0.00,3010.90,710596.00,0.00,0.00,0.00),('1','139','772','159460',3164202,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','159742',3169088,'2143','330',269688.90,275150.30,0.00,0.00,5461.40,1279546.00,0.00,0.00,0.00),('1','139','772','159742',3169089,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','159743',3169090,'2143','330',275150.30,279489.90,0.00,0.00,4339.60,1031104.00,0.00,0.00,0.00),('1','139','772','159743',3169091,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','159953',3172870,'2143','330',279489.90,288304.50,0.00,0.00,8814.60,2031972.00,0.00,0.00,0.00),('1','139','772','159953',3172871,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','160106',3175951,'2143','330',288304.50,289401.00,0.00,0.00,1096.50,255960.00,0.00,0.00,0.00),('1','139','772','160106',3175952,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','160107',3175953,'2143','330',289401.00,289401.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','160107',3175954,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','160368',3180548,'2143','330',289401.00,293660.00,0.00,0.00,4259.00,985644.00,0.00,0.00,0.00),('1','139','772','160368',3180549,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','160459',3182107,'2143','330',293660.00,303358.90,0.00,0.00,9698.90,2233612.00,0.00,0.00,0.00),('1','139','772','160459',3182108,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','160609',3184784,'2143','330',303358.90,303358.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','160609',3184785,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','160610',3184786,'2143','330',303358.90,310846.10,0.00,0.00,7487.20,1888622.60,0.00,0.00,0.00),('1','139','772','160610',3184787,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','160736',3186975,'2143','330',310846.10,311747.60,0.00,0.00,901.50,226456.00,0.00,0.00,0.00),('1','139','772','160736',3186976,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','160738',3186978,'2143','330',311747.60,311747.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','160738',3186979,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','160900',3189648,'2143','330',311747.60,316540.10,0.00,0.00,4792.50,1228008.00,0.00,0.00,0.00),('1','139','772','160900',3189649,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','160901',3189650,'2143','330',316540.10,319953.60,0.00,0.00,3413.50,884286.00,0.00,0.00,0.00),('1','139','772','160901',3189651,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','161099',3193377,'2143','330',319953.60,324053.80,0.00,0.00,4100.20,1053789.60,0.00,0.00,0.00),('1','139','772','161099',3193378,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','161283',3196687,'2143','330',324053.80,332284.80,0.00,0.00,8231.00,2060257.00,0.00,0.00,0.00),('1','139','772','161283',3196688,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','161425',3199144,'2143','330',332284.80,334080.20,0.00,0.00,1795.40,451001.60,0.00,0.00,0.00),('1','139','772','161425',3199145,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','161428',3199212,'2143','330',334080.20,334080.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','161428',3199213,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','161450',3199442,'2143','330',334080.20,336184.50,0.00,0.00,2104.30,542145.20,0.00,0.00,0.00),('1','139','772','161450',3199443,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','161659',3202957,'2143','330',336184.50,337888.50,0.00,0.00,1704.00,454678.00,0.00,0.00,0.00),('1','139','772','161659',3202958,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','161869',3206490,'2143','330',337888.50,342035.20,0.00,0.00,4146.70,1061483.80,0.00,0.00,0.00),('1','139','772','161869',3206491,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','162051',3209798,'2143','330',342035.20,346453.90,0.00,0.00,4418.70,1126176.60,0.00,0.00,0.00),('1','139','772','162051',3209799,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','162235',3213007,'2143','330',346453.90,349336.30,0.00,0.00,2882.40,748611.60,0.00,0.00,0.00),('1','139','772','162235',3213008,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','162447',3216603,'2143','330',349336.30,353091.90,0.00,0.00,3755.60,961537.60,0.00,0.00,0.00),('1','139','772','162447',3216604,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','162581',3218560,'2143','330',353091.90,356394.20,0.00,0.00,3302.30,825299.20,0.00,0.00,0.00),('1','139','772','162581',3218561,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','162587',3218635,'2143','330',356394.20,356394.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','162587',3218636,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','162806',3222724,'2143','330',356394.20,361364.60,0.00,0.00,4970.40,1252220.80,0.00,0.00,0.00),('1','139','772','162806',3222725,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','162996',3226151,'2143','330',361364.60,363305.00,0.00,0.00,1940.40,505021.60,0.00,0.00,0.00),('1','139','772','162996',3226152,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','163198',3229699,'2143','330',363305.00,365496.80,0.00,0.00,2191.80,568837.20,0.00,0.00,0.00),('1','139','772','163198',3229700,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','163372',3232736,'2143','330',365496.80,373358.50,0.00,0.00,7861.70,1944266.80,0.00,0.00,0.00),('1','139','772','163372',3232737,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','163556',3236104,'2143','330',373358.50,378758.30,0.00,0.00,5399.80,1346965.20,0.00,0.00,0.00),('1','139','772','163556',3236105,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','163557',3236106,'2143','330',378758.30,378758.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','163557',3236107,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','163747',3239520,'2143','330',378758.30,386969.10,0.00,0.00,8210.80,2046395.00,0.00,0.00,0.00),('1','139','772','163747',3239521,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','163899',3242254,'2143','330',386969.10,393493.60,0.00,0.00,6524.50,1678528.00,0.00,0.00,0.00),('1','139','772','163899',3242255,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','164080',3245526,'2143','330',393493.60,400100.70,0.00,0.00,6607.10,1724304.80,0.00,0.00,0.00),('1','139','772','164080',3245527,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','164081',3245528,'2143','330',400100.70,400100.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','164081',3245529,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','164261',3248742,'2143','330',400100.70,403297.40,0.00,0.00,3196.70,851516.00,0.00,0.00,0.00),('1','139','772','164261',3248743,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','164438',3252220,'2143','330',403297.40,405618.80,0.00,0.00,2321.40,639225.60,0.00,0.00,0.00),('1','139','772','164438',3252221,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','164599',3255009,'2143','330',405618.80,408162.30,0.00,0.00,2543.50,700633.00,0.00,0.00,0.00),('1','139','772','164599',3255010,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','164754',3257870,'2143','330',408162.30,411251.10,0.00,0.00,3088.80,840131.40,0.00,0.00,0.00),('1','139','772','164754',3257871,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','164963',3261557,'2143','330',411251.10,415492.30,0.00,0.00,4241.20,1132124.80,0.00,0.00,0.00),('1','139','772','164963',3261558,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','165132',3264508,'2143','330',415492.30,418994.10,0.00,0.00,3501.80,1027270.00,0.00,0.00,0.00),('1','139','772','165132',3264509,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','165281',3267118,'2143','330',418994.10,422421.10,0.00,0.00,3427.00,992810.00,0.00,0.00,0.00),('1','139','772','165281',3267119,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','165283',3267150,'2143','330',422421.10,422421.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','165283',3267151,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','165441',3269903,'2143','330',422421.10,435069.60,0.00,0.00,12648.50,3625124.00,0.00,0.00,0.00),('1','139','772','165441',3269904,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','165615',3272901,'2143','330',435069.60,442360.00,0.00,0.00,7290.40,2086796.00,0.00,0.00,0.00),('1','139','772','165615',3272902,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','165737',3275215,'2143','330',442360.00,445020.40,0.00,0.00,2660.40,779828.00,0.00,0.00,0.00),('1','139','772','165737',3275216,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','165744',3275384,'2143','330',445020.40,445020.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','165744',3275385,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','165931',3278721,'2143','330',445020.40,451660.40,0.00,0.00,6640.00,1924750.00,0.00,0.00,0.00),('1','139','772','165931',3278722,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','166152',3282578,'2143','330',451660.40,455903.00,0.00,0.00,4242.60,1237278.00,0.00,0.00,0.00),('1','139','772','166152',3282579,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','166313',3285528,'2143','330',455903.00,459649.80,0.00,0.00,3746.80,1093576.00,0.00,0.00,0.00),('1','139','772','166313',3285529,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','166494',3288940,'2143','330',459649.80,463675.30,0.00,0.00,4025.50,1176976.00,0.00,0.00,0.00),('1','139','772','166494',3288941,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','166696',3292323,'2143','330',463675.30,467467.60,0.00,0.00,3792.30,1102558.00,0.00,0.00,0.00),('1','139','772','166696',3292324,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','166698',3292341,'2143','330',467467.60,467467.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','166698',3292342,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','166881',3295522,'2143','330',467467.60,470585.40,0.00,0.00,3117.80,917134.00,0.00,0.00,0.00),('1','139','772','166881',3295523,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','167027',3298138,'2143','330',470585.40,476094.50,0.00,0.00,5509.10,1598732.00,0.00,0.00,0.00),('1','139','772','167027',3298139,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','167175',3300783,'2143','330',476094.50,477832.00,0.00,0.00,1737.50,513000.00,0.00,0.00,0.00),('1','139','772','167175',3300784,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','167369',3304260,'2143','330',477832.00,480764.50,0.00,0.00,2932.50,863400.00,0.00,0.00,0.00),('1','139','772','167369',3304261,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','167565',3307838,'2143','330',480764.50,483496.40,0.00,0.00,2731.90,1156828.00,0.00,0.00,0.00),('1','139','772','167565',3307839,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','167723',3310602,'2143','330',483496.40,483496.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','167723',3310603,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','167725',3310635,'2143','330',483496.40,485328.30,0.00,0.00,1831.90,541920.00,0.00,0.00,0.00),('1','139','772','167725',3310636,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','167866',3313030,'2143','330',485328.30,488603.90,0.00,0.00,3275.60,955876.00,0.00,0.00,0.00),('1','139','772','167866',3313031,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','169084',3335130,'2143','330',488603.90,488603.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','169084',3335131,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','169086',3335133,'2143','330',488603.90,488603.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','169086',3335134,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','169089',3335191,'2143','330',488603.90,492998.10,0.00,0.00,4394.20,1283554.00,0.00,0.00,0.00),('1','139','772','169089',3335192,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','169093',3335219,'2143','330',492998.10,497024.00,0.00,0.00,4025.90,1179642.00,0.00,0.00,0.00),('1','139','772','169093',3335220,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','169097',3335287,'2143','330',497024.00,501450.90,0.00,0.00,4426.90,1276514.00,0.00,0.00,0.00),('1','139','772','169097',3335288,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','169100',3335367,'2143','330',501450.90,505936.50,0.00,0.00,4485.60,1292127.00,0.00,0.00,0.00),('1','139','772','169100',3335368,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','169103',3335420,'2143','330',505936.50,510088.00,0.00,0.00,4151.50,1215500.00,0.00,0.00,0.00),('1','139','772','169103',3335421,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','169109',3335503,'2143','330',510088.00,510088.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','169109',3335504,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','169171',3336499,'2143','330',510088.00,514707.00,0.00,0.00,4619.00,1354065.00,0.00,0.00,0.00),('1','139','772','169171',3336500,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','169179',3336637,'2143','330',514707.00,524848.50,0.00,0.00,10141.50,2902055.00,0.00,0.00,0.00),('1','139','772','169179',3336638,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','169263',3338470,'2143','330',524848.50,528235.40,0.00,0.00,3386.90,1001848.00,0.00,0.00,0.00),('1','139','772','169263',3338471,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','169431',3341805,'2143','330',528235.40,532513.60,0.00,0.00,4278.20,1240994.00,0.00,0.00,0.00),('1','139','772','169431',3341806,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','169434',3341836,'2143','330',532513.60,532513.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','169434',3341837,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','169569',3344630,'2143','330',532513.60,539311.40,0.00,0.00,6797.80,1936552.00,0.00,0.00,0.00),('1','139','772','169569',3344631,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','169767',3348137,'2143','330',539311.40,541439.70,0.00,0.00,2128.30,675948.00,0.00,0.00,0.00),('1','139','772','169767',3348138,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','169920',3351120,'2143','330',541439.70,545470.50,0.00,0.00,4030.80,1258082.00,0.00,0.00,0.00),('1','139','772','169920',3351121,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','170144',3355047,'2143','330',545470.50,547149.30,0.00,0.00,1678.80,535450.00,0.00,0.00,0.00),('1','139','772','170144',3355048,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','170331',3358232,'2143','330',547149.30,550215.50,0.00,0.00,3066.20,962603.00,0.00,0.00,0.00),('1','139','772','170331',3358233,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','170500',3361127,'2143','330',550215.50,551542.50,0.00,0.00,1327.00,433669.00,0.00,0.00,0.00),('1','139','772','170500',3361128,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','170675',3364377,'2143','330',551542.50,553585.40,0.00,0.00,2042.90,652911.00,0.00,0.00,0.00),('1','139','772','170675',3364378,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','170819',3366821,'2143','330',553585.40,556862.60,0.00,0.00,3277.20,1021940.00,0.00,0.00,0.00),('1','139','772','170819',3366822,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','171006',3370197,'2143','330',556862.60,556862.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','171006',3370198,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','171007',3370199,'2143','330',556862.60,560172.90,0.00,0.00,3310.30,1042174.00,0.00,0.00,0.00),('1','139','772','171007',3370200,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','171217',3374221,'2143','330',560172.90,563247.10,0.00,0.00,3074.20,966115.00,0.00,0.00,0.00),('1','139','772','171217',3374222,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','171525',3379872,'2143','330',563247.10,567421.40,0.00,0.00,4174.30,1309137.00,0.00,0.00,0.00),('1','139','772','171525',3379873,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','171591',3380951,'2143','330',567421.40,569907.90,0.00,0.00,2486.50,787030.00,0.00,0.00,0.00),('1','139','772','171591',3380952,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','171936',3387148,'2143','330',569907.90,574678.10,0.00,0.00,4770.20,1487768.00,0.00,0.00,0.00),('1','139','772','171936',3387149,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','171937',3387150,'2143','330',574678.10,576456.60,0.00,0.00,1778.50,566832.00,0.00,0.00,0.00),('1','139','772','171937',3387151,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','172091',3389818,'2143','330',576456.60,580230.10,0.00,0.00,3773.50,1174090.00,0.00,0.00,0.00),('1','139','772','172091',3389819,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','172093',3389822,'2143','330',580230.10,581115.10,0.00,0.00,885.00,270810.00,0.00,0.00,0.00),('1','139','772','172093',3389823,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','172285',3393465,'2143','330',581115.10,581115.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','172285',3393466,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','172423',3395967,'2143','330',581115.10,583679.20,0.00,0.00,2564.10,784362.00,0.00,0.00,0.00),('1','139','772','172423',3395968,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','172492',3397212,'2143','330',583679.20,587419.80,0.00,0.00,3740.60,1141328.00,0.00,0.00,0.00),('1','139','772','172492',3397213,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','172689',3400876,'2143','330',587419.80,590575.60,0.00,0.00,3155.80,965932.00,0.00,0.00,0.00),('1','139','772','172689',3400877,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','172859',3403964,'2143','330',590575.60,592367.60,0.00,0.00,1792.00,556520.00,0.00,0.00,0.00),('1','139','772','172859',3403965,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','173039',3407366,'2143','330',592367.60,595044.60,0.00,0.00,2677.00,822960.00,0.00,0.00,0.00),('1','139','772','173039',3407367,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','173199',3410666,'2143','330',595044.60,597563.80,0.00,0.00,2519.20,779328.00,0.00,0.00,0.00),('1','139','772','173199',3410667,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','173359',3413526,'2143','330',597563.80,599839.00,0.00,0.00,2275.20,707928.00,0.00,0.00,0.00),('1','139','772','173359',3413527,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','173578',3417568,'2143','330',599839.00,604650.60,0.00,0.00,4811.60,1449824.00,0.00,0.00,0.00),('1','139','772','173578',3417569,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','173585',3417710,'2143','330',604650.60,604650.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','173585',3417711,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','173756',3420712,'2143','330',604650.60,609116.80,0.00,0.00,4466.20,1358240.00,0.00,0.00,0.00),('1','139','772','173756',3420713,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','173939',3424066,'2143','330',609116.80,616538.50,0.00,0.00,7421.70,2220684.00,0.00,0.00,0.00),('1','139','772','173939',3424067,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','174124',3427303,'2143','330',616538.50,624185.70,0.00,0.00,7647.20,2302788.00,0.00,0.00,0.00),('1','139','772','174124',3427304,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','174299',3430532,'2143','330',624185.70,628719.40,0.00,0.00,4533.70,1366618.00,0.00,0.00,0.00),('1','139','772','174299',3430533,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','174301',3430557,'2143','330',628719.40,628719.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','174301',3430558,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','174479',3433542,'2143','330',628719.40,637412.70,0.00,0.00,8693.30,2604932.00,0.00,0.00,0.00),('1','139','772','174479',3433543,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','174615',3435902,'2143','330',637412.70,641549.50,0.00,0.00,4136.80,1237043.20,0.00,0.00,0.00),('1','139','772','174615',3435903,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','174835',3440023,'2143','330',641549.50,648328.30,0.00,0.00,6778.80,2054272.00,0.00,0.00,0.00),('1','139','772','174835',3440024,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','175022',3443744,'2143','330',648328.30,652636.20,0.00,0.00,4307.90,1334088.80,0.00,0.00,0.00),('1','139','772','175022',3443745,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','175027',3443830,'2143','330',652636.20,652636.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','175027',3443831,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','175234',3447410,'2143','330',652636.20,659740.70,0.00,0.00,7104.50,2230988.00,0.00,0.00,0.00),('1','139','772','175234',3447411,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','175398',3450537,'2143','330',659740.70,663424.90,0.00,0.00,3684.20,1187838.40,0.00,0.00,0.00),('1','139','772','175398',3450538,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','175581',3453844,'2143','330',663424.90,665417.00,0.00,0.00,1992.10,655259.20,0.00,0.00,0.00),('1','139','772','175581',3453845,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','175758',3457061,'2143','330',665417.00,673249.80,0.00,0.00,7832.80,2446285.60,0.00,0.00,0.00),('1','139','772','175758',3457062,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','175903',3459562,'2143','330',673249.80,677041.70,0.00,0.00,3791.90,1180180.80,0.00,0.00,0.00),('1','139','772','175903',3459563,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','175904',3459564,'2143','330',677041.70,677041.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','175904',3459565,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','176134',3463804,'2143','330',677041.70,687230.60,0.00,0.00,10188.90,3188292.80,0.00,0.00,0.00),('1','139','772','176134',3463805,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','176308',3467112,'2143','330',687230.60,695132.10,0.00,0.00,7901.50,2494448.00,0.00,0.00,0.00),('1','139','772','176308',3467113,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','176536',3471355,'2143','330',695132.10,701316.40,0.00,0.00,6184.30,1966049.60,0.00,0.00,0.00),('1','139','772','176536',3471356,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','176961',3479104,'2143','330',701316.40,701316.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','176961',3479105,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','176965',3479166,'2143','330',701316.40,711762.70,0.00,0.00,10446.30,3214721.60,0.00,0.00,0.00),('1','139','772','176965',3479167,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','176966',3479168,'2143','330',711762.70,714349.50,0.00,0.00,2586.80,848473.60,0.00,0.00,0.00),('1','139','772','176966',3479169,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','177224',3484181,'2143','330',714349.50,725969.10,0.00,0.00,11619.60,3628039.20,0.00,0.00,0.00),('1','139','772','177224',3484182,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','177565',3491259,'2143','330',725969.10,725969.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','177565',3491260,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','177568',3491308,'2143','330',725969.10,728730.50,0.00,0.00,2761.40,901772.80,0.00,0.00,0.00),('1','139','772','177568',3491309,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','177607',3492074,'2143','330',728730.50,735242.20,0.00,0.00,6511.70,2067874.40,0.00,0.00,0.00),('1','139','772','177607',3492075,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','177861',3496571,'2143','330',735242.20,737715.60,0.00,0.00,2473.40,803516.80,0.00,0.00,0.00),('1','139','772','177861',3496572,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','178060',3500499,'2143','330',737715.60,741787.50,0.00,0.00,4071.90,1308188.80,0.00,0.00,0.00),('1','139','772','178060',3500500,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','178284',3504543,'2143','330',741787.50,750314.60,0.00,0.00,8527.10,2677459.20,0.00,0.00,0.00),('1','139','772','178284',3504544,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','178475',3508094,'2143','330',750314.60,750314.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','178475',3508095,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','178479',3508149,'2143','330',750314.60,758062.60,0.00,0.00,7748.00,2384028.00,0.00,0.00,0.00),('1','139','772','178479',3508150,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','178698',3512260,'2143','330',758062.60,761518.60,0.00,0.00,3456.00,1149836.00,0.00,0.00,0.00),('1','139','772','178698',3512261,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','178864',3515315,'2143','330',761518.60,761518.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','178864',3515316,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','178865',3515317,'2143','330',761518.60,763206.40,0.00,0.00,1687.80,569269.60,0.00,0.00,0.00),('1','139','772','178865',3515318,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','179102',3519531,'2143','330',763206.40,769235.10,0.00,0.00,6028.70,1950781.60,0.00,0.00,0.00),('1','139','772','179102',3519532,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','179345',3524398,'2143','330',769235.10,774693.70,0.00,0.00,5458.60,1768720.00,0.00,0.00,0.00),('1','139','772','179345',3524399,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','179418',3525435,'2143','330',774693.70,774693.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','179418',3525436,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','179754',3532200,'2143','330',774693.70,786194.20,0.00,0.00,11500.50,3700204.00,0.00,0.00,0.00),('1','139','772','179754',3532201,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','179756',3532226,'2143','330',786194.20,790694.20,0.00,0.00,4500.00,1488133.20,0.00,0.00,0.00),('1','139','772','179756',3532227,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','179978',3536235,'2143','330',790694.20,795012.80,0.00,0.00,4318.60,1411909.20,0.00,0.00,0.00),('1','139','772','179978',3536236,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','180080',3537955,'2143','330',795012.80,798746.70,0.00,0.00,3733.90,1204714.80,0.00,0.00,0.00),('1','139','772','180080',3537956,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','180143',3539337,'2143','330',798746.70,798746.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','180143',3539338,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','180246',3541145,'2143','330',798746.70,798746.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','180246',3541146,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','180248',3541156,'2143','330',798746.70,800697.30,0.00,0.00,1950.60,634675.20,0.00,0.00,0.00),('1','139','772','180248',3541157,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','180296',3542174,'2143','330',800697.30,802890.80,0.00,0.00,2193.50,738076.00,0.00,0.00,0.00),('1','139','772','180296',3542175,'2186','330',627.00,627.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','180360',3543096,'2143','330',802890.80,804458.79,0.00,0.00,1567.99,542175.72,0.00,0.00,0.00),('1','139','772','180360',3543097,'2186','330',627.00,2160.00,0.00,0.00,1533.00,491760.00,0.00,0.00,0.00),('1','139','772','180549',3546696,'2143','330',804458.79,808605.83,0.00,0.00,4147.04,1365338.08,0.00,0.00,0.00),('1','139','772','180549',3546697,'2186','330',2160.00,2440.00,0.00,0.00,280.00,90720.00,0.00,0.00,0.00),('1','139','772','180740',3550077,'2143','330',808605.83,812865.02,0.00,0.00,4259.19,1406990.92,0.00,0.00,0.00),('1','139','772','180740',3550078,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','180961',3554396,'2143','330',812865.02,815599.89,0.00,0.00,2734.87,906208.76,0.00,0.00,0.00),('1','139','772','180961',3554397,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','181134',3557668,'2143','330',815599.89,820214.20,0.00,0.00,4614.31,1511729.00,0.00,0.00,0.00),('1','139','772','181134',3557669,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','181361',3562041,'2143','330',820214.20,823095.94,0.00,0.00,2881.74,949618.88,0.00,0.00,0.00),('1','139','772','181361',3562042,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','181531',3565108,'2143','330',823095.94,826930.88,0.00,0.00,3834.94,1252652.08,0.00,0.00,0.00),('1','139','772','181531',3565109,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','181711',3568183,'2143','330',826930.88,834384.20,0.00,0.00,7453.32,2394816.84,0.00,0.00,0.00),('1','139','772','181711',3568184,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','181907',3571581,'2143','330',834384.20,837387.97,0.00,0.00,3003.77,986121.04,0.00,0.00,0.00),('1','139','772','181907',3571582,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','182109',3575511,'2143','330',837387.97,843532.92,0.00,0.00,6144.95,1968675.60,0.00,0.00,0.00),('1','139','772','182109',3575512,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','182188',3576831,'2143','330',843532.92,845974.06,0.00,0.00,2441.14,796010.48,0.00,0.00,0.00),('1','139','772','182188',3576832,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','182315',3578949,'2143','330',845974.06,852256.30,0.00,0.00,6282.24,2017296.48,0.00,0.00,0.00),('1','139','772','182315',3578950,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','182505',3582397,'2143','330',852256.30,857385.11,0.00,0.00,5128.81,1656420.72,0.00,0.00,0.00),('1','139','772','182505',3582398,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','182692',3585901,'2143','330',857385.11,864235.61,0.00,0.00,6850.50,2236172.00,0.00,0.00,0.00),('1','139','772','182692',3585902,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','183678',3603827,'2143','330',864235.61,866344.51,0.00,0.00,2108.90,696140.80,0.00,0.00,0.00),('1','139','772','183678',3603828,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','183684',3603916,'2143','330',866344.51,866344.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','183684',3603917,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','183695',3604070,'2143','330',866344.51,874843.11,0.00,0.00,8498.60,2741376.80,0.00,0.00,0.00),('1','139','772','183695',3604071,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','183703',3604205,'2143','330',874843.11,878391.11,0.00,0.00,3548.00,1164172.00,0.00,0.00,0.00),('1','139','772','183703',3604206,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','183725',3604751,'2143','330',878391.11,884432.11,0.00,0.00,6041.00,1962714.80,0.00,0.00,0.00),('1','139','772','183725',3604752,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','183833',3606849,'2143','330',884432.11,890590.21,0.00,0.00,6158.10,1982823.20,0.00,0.00,0.00),('1','139','772','183833',3606850,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','183953',3609008,'2143','330',890590.21,890730.91,0.00,0.00,140.70,49526.40,0.00,0.00,0.00),('1','139','772','183953',3609009,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','183957',3609112,'2143','330',890730.91,890730.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','183957',3609113,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','183995',3609733,'2143','330',890730.91,901554.60,0.00,0.00,10823.69,3578010.84,0.00,0.00,0.00),('1','139','772','183995',3609734,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','184282',3614793,'2143','330',901554.60,903423.46,0.00,0.00,1868.86,629108.56,0.00,0.00,0.00),('1','139','772','184282',3614794,'2186','330',2440.00,2440.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','184486',3618274,'2143','330',903423.46,909237.61,0.00,0.00,5814.15,1926543.80,0.00,0.00,0.00),('1','139','772','184486',3618275,'2186','330',2440.00,2446.01,0.00,0.00,6.01,2139.56,0.00,0.00,0.00),('1','139','772','184696',3622273,'2143','330',909237.61,913124.44,0.00,0.00,3886.83,1298458.68,0.00,0.00,0.00),('1','139','772','184696',3622274,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','184899',3625892,'2143','330',913124.44,914713.02,0.00,0.00,1588.58,528954.48,0.00,0.00,0.00),('1','139','772','184899',3625893,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','185006',3627707,'2143','330',914713.02,914713.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','185006',3627708,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','185033',3628267,'2143','330',914713.02,915641.90,0.00,0.00,928.88,317001.28,0.00,0.00,0.00),('1','139','772','185033',3628268,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','185109',3629493,'2143','330',915641.90,918459.66,0.00,0.00,2817.76,955733.36,0.00,0.00,0.00),('1','139','772','185109',3629494,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','185264',3631950,'2143','330',918459.66,922118.47,0.00,0.00,3658.81,1224278.76,0.00,0.00,0.00),('1','139','772','185264',3631951,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','185478',3635914,'2143','330',922118.47,928131.88,0.00,0.00,6013.41,1996113.96,0.00,0.00,0.00),('1','139','772','185478',3635915,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','185693',3639735,'2143','330',928131.88,933081.80,0.00,0.00,4949.92,1640046.72,0.00,0.00,0.00),('1','139','772','185693',3639736,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','185881',3643150,'2143','330',933081.80,936659.40,0.00,0.00,3577.60,1198954.40,0.00,0.00,0.00),('1','139','772','185881',3643151,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','186100',3647115,'2143','330',936659.40,939022.51,0.00,0.00,2363.11,786786.36,0.00,0.00,0.00),('1','139','772','186100',3647116,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','186241',3649492,'2143','330',939022.51,939022.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','186241',3649493,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','186276',3650031,'2143','330',939022.51,940319.20,0.00,0.00,1296.69,435141.64,0.00,0.00,0.00),('1','139','772','186276',3650032,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','186321',3650713,'2143','330',940319.20,943160.25,0.00,0.00,2841.05,956545.00,0.00,0.00,0.00),('1','139','772','186321',3650714,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','186534',3654406,'2143','330',943160.25,948743.38,0.00,0.00,5583.13,1849724.88,0.00,0.00,0.00),('1','139','772','186534',3654407,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','186762',3658244,'2143','330',948743.38,952977.12,0.00,0.00,4233.74,1404169.44,0.00,0.00,0.00),('1','139','772','186762',3658245,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','187007',3662286,'2143','330',952977.12,956906.79,0.00,0.00,3929.67,1302956.92,0.00,0.00,0.00),('1','139','772','187007',3662287,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','187167',3665067,'2143','330',956906.79,958932.81,0.00,0.00,2026.02,686787.12,0.00,0.00,0.00),('1','139','772','187167',3665068,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','187359',3668611,'2143','330',958932.81,963335.92,0.00,0.00,4403.11,1446499.56,0.00,0.00,0.00),('1','139','772','187359',3668612,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','187497',3671120,'2143','330',963335.92,963335.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','187497',3671121,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','187507',3671281,'2143','330',963335.92,965875.22,0.00,0.00,2539.30,848648.00,0.00,0.00,0.00),('1','139','772','187507',3671282,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','187588',3672602,'2143','330',965875.22,968498.57,0.00,0.00,2623.35,882183.60,0.00,0.00,0.00),('1','139','772','187588',3672603,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','187834',3676889,'2143','330',968498.57,977266.07,0.00,0.00,8767.50,2882985.60,0.00,0.00,0.00),('1','139','772','187834',3676890,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','188028',3680372,'2143','330',977266.07,979010.90,0.00,0.00,1744.83,599379.48,0.00,0.00,0.00),('1','139','772','188028',3680373,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','188226',3683778,'2143','330',979010.90,986198.93,0.00,0.00,7188.03,2381745.28,0.00,0.00,0.00),('1','139','772','188226',3683779,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','188426',3687250,'2143','330',986198.93,986914.61,0.00,0.00,715.68,243526.08,0.00,0.00,0.00),('1','139','772','188426',3687251,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','188500',3688608,'2143','330',986914.61,987614.61,0.00,0.00,700.00,228200.00,0.00,0.00,0.00),('1','139','772','188500',3688609,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','188506',3688666,'2143','330',987614.61,987614.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','188506',3688667,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','188835',3694334,'2143','330',987614.61,992356.19,0.00,0.00,4741.58,1579612.68,0.00,0.00,0.00),('1','139','772','188835',3694335,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','189018',3697745,'2143','330',992356.19,996670.42,0.00,0.00,4314.23,1442067.48,0.00,0.00,0.00),('1','139','772','189018',3697746,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','189204',3701063,'2143','330',996670.42,1002718.18,0.00,0.00,6047.76,2008827.36,0.00,0.00,0.00),('1','139','772','189204',3701064,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','189428',3705124,'2143','330',1002718.18,1008402.94,0.00,0.00,5684.76,1885725.36,0.00,0.00,0.00),('1','139','772','189428',3705125,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','189627',3708532,'2143','330',1008402.94,1011982.68,0.00,0.00,3579.74,1169388.24,0.00,0.00,0.00),('1','139','772','189627',3708533,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','189670',3709253,'2143','330',1011982.68,1011982.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','189670',3709254,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','189687',3709603,'2143','330',1011982.68,1016331.28,0.00,0.00,4348.60,1449783.60,0.00,0.00,0.00),('1','139','772','189687',3709604,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','189846',3712348,'2143','330',1016331.28,1017567.71,0.00,0.00,1236.43,426153.08,0.00,0.00,0.00),('1','139','772','189846',3712349,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','190033',3716240,'2143','330',1017567.71,1019981.64,0.00,0.00,2413.93,816877.08,0.00,0.00,0.00),('1','139','772','190033',3716241,'2186','330',2446.01,2446.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','190223',3719817,'2143','330',1019981.64,1023441.82,0.00,0.00,3460.18,1164588.08,0.00,0.00,0.00),('1','139','772','190223',3719818,'2186','330',2446.01,2454.44,0.00,0.00,8.43,3001.08,0.00,0.00,0.00),('1','139','772','190448',3723922,'2143','330',1023441.82,1030279.04,0.00,0.00,6837.22,2267126.72,0.00,0.00,0.00),('1','139','772','190448',3723923,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','190669',3728161,'2143','330',1030279.04,1036344.12,0.00,0.00,6065.08,1987746.48,0.00,0.00,0.00),('1','139','772','190669',3728162,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','190744',3729533,'2143','330',1036344.12,1036344.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','190744',3729534,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','190755',3729754,'2143','330',1036344.12,1037602.67,0.00,0.00,1258.55,428476.60,0.00,0.00,0.00),('1','139','772','190755',3729755,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','190897',3732275,'2143','330',1037602.67,1043558.50,0.00,0.00,5955.83,1961889.28,0.00,0.00,0.00),('1','139','772','190897',3732276,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','191092',3735640,'2143','330',1043558.50,1049291.11,0.00,0.00,5732.61,1893248.36,0.00,0.00,0.00),('1','139','772','191092',3735641,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','191300',3739348,'2143','330',1049291.11,1056988.96,0.00,0.00,7697.85,2538626.20,0.00,0.00,0.00),('1','139','772','191300',3739349,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','191507',3743044,'2143','330',1056988.96,1060650.69,0.00,0.00,3661.73,1214959.88,0.00,0.00,0.00),('1','139','772','191507',3743045,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','191722',3747312,'2143','330',1060650.69,1060650.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','191722',3747313,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','191759',3747883,'2143','330',1060650.69,1065138.09,0.00,0.00,4487.40,1489402.40,0.00,0.00,0.00),('1','139','772','191759',3747884,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','191944',3751645,'2143','330',1065138.09,1068009.75,0.00,0.00,2871.66,965667.76,0.00,0.00,0.00),('1','139','772','191944',3751646,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','192140',3754992,'2143','330',1068009.75,1075105.80,0.00,0.00,7096.05,2333586.20,0.00,0.00,0.00),('1','139','772','192140',3754993,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','192346',3758922,'2143','330',1075105.80,1076873.55,0.00,0.00,1767.75,609867.00,0.00,0.00,0.00),('1','139','772','192346',3758923,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','192576',3762921,'2143','330',1076873.55,1079050.65,0.00,0.00,2177.10,738860.00,0.00,0.00,0.00),('1','139','772','192576',3762922,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','192782',3766576,'2143','330',1079050.65,1084924.59,0.00,0.00,5873.94,1939296.94,0.00,0.00,0.00),('1','139','772','192782',3766577,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','192913',3769337,'2143','330',1084924.59,1084924.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','192913',3769338,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','192986',3770378,'2143','330',1084924.59,1087670.07,0.00,0.00,2745.48,927022.88,0.00,0.00,0.00),('1','139','772','192986',3770379,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','193186',3774212,'2143','330',1087670.07,1089403.13,0.00,0.00,1733.06,592110.16,0.00,0.00,0.00),('1','139','772','193186',3774213,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','193411',3778858,'2143','330',1089403.13,1093373.83,0.00,0.00,3970.70,1328487.60,0.00,0.00,0.00),('1','139','772','193411',3778859,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','193629',3782888,'2143','330',1093373.83,1095971.89,0.00,0.00,2598.06,874302.96,0.00,0.00,0.00),('1','139','772','193629',3782889,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','193863',3786972,'2143','330',1095971.89,1098798.64,0.00,0.00,2826.75,950663.00,0.00,0.00,0.00),('1','139','772','193863',3786973,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','194085',3790943,'2143','330',1098798.64,1100281.15,0.00,0.00,1482.51,511069.56,0.00,0.00,0.00),('1','139','772','194085',3790944,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','194312',3795143,'2143','330',1100281.15,1103981.06,0.00,0.00,3699.91,1244278.36,0.00,0.00,0.00),('1','139','772','194312',3795144,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','194495',3798402,'2143','330',1103981.06,1108985.97,0.00,0.00,5004.91,1666516.76,0.00,0.00,0.00),('1','139','772','194495',3798403,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','194652',3801324,'2143','330',1108985.97,1108985.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','194652',3801325,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','194680',3801726,'2143','330',1108985.97,1117097.23,0.00,0.00,8111.26,2706872.16,0.00,0.00,0.00),('1','139','772','194680',3801727,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','194870',3805720,'2143','330',1117097.23,1123371.39,0.00,0.00,6274.16,2082361.98,0.00,0.00,0.00),('1','139','772','194870',3805721,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','195086',3809457,'2143','330',1123371.39,1133011.71,0.00,0.00,9640.32,3194842.92,0.00,0.00,0.00),('1','139','772','195086',3809458,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','195316',3813443,'2143','330',1133011.71,1133676.93,0.00,0.00,665.22,226942.32,0.00,0.00,0.00),('1','139','772','195316',3813444,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','195502',3816951,'2143','330',1133676.93,1133676.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','195502',3816952,'2186','330',2454.44,2454.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','195549',3817532,'2143','330',1133676.93,1139458.68,0.00,0.00,5781.75,1922424.00,0.00,0.00,0.00),('1','139','772','195549',3817533,'2186','330',2454.44,2457.45,0.00,0.00,3.01,1071.56,0.00,0.00,0.00),('1','139','772','195789',3821548,'2143','330',1139458.68,1143293.22,0.00,0.00,3834.54,1290953.04,0.00,0.00,0.00),('1','139','772','195789',3821549,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','196014',3825746,'2143','330',1143293.22,1147770.58,0.00,0.00,4477.36,1491227.16,0.00,0.00,0.00),('1','139','772','196014',3825747,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','196254',3830184,'2143','330',1147770.58,1154636.38,0.00,0.00,6865.80,2270718.80,0.00,0.00,0.00),('1','139','772','196254',3830185,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','196456',3833885,'2143','330',1154636.38,1158276.12,0.00,0.00,3639.74,1203471.04,0.00,0.00,0.00),('1','139','772','196456',3833886,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','196564',3835861,'2143','330',1158276.12,1158276.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','196564',3835862,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','196585',3836340,'2143','330',1158276.12,1160045.55,0.00,0.00,1769.43,592881.08,0.00,0.00,0.00),('1','139','772','196585',3836341,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','196667',3837668,'2143','330',1160045.55,1164970.57,0.00,0.00,4925.02,1635587.12,0.00,0.00,0.00),('1','139','772','196667',3837669,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','196921',3842087,'2143','330',1164970.57,1165964.43,0.00,0.00,993.86,337254.16,0.00,0.00,0.00),('1','139','772','196921',3842088,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','197117',3845684,'2143','330',1165964.43,1170724.99,0.00,0.00,4760.56,1560619.90,0.00,0.00,0.00),('1','139','772','197117',3845685,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','197347',3850149,'2143','330',1170724.99,1173362.69,0.00,0.00,2637.70,883629.20,0.00,0.00,0.00),('1','139','772','197347',3850150,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','197370',3850301,'2143','330',1173362.69,1177530.84,0.00,0.00,4168.15,1397581.40,0.00,0.00,0.00),('1','139','772','197370',3850302,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','197514',3852433,'2143','330',1177530.84,1182900.57,0.00,0.00,5369.73,1788161.08,0.00,0.00,0.00),('1','139','772','197514',3852434,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','197842',3858373,'2143','330',1182900.57,1182900.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','197842',3858374,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','198083',3862633,'2143','330',1182900.57,1187615.77,0.00,0.00,4715.20,1565838.40,0.00,0.00,0.00),('1','139','772','198083',3862634,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','198127',3863215,'2143','330',1187615.77,1192281.97,0.00,0.00,4666.20,1550207.20,0.00,0.00,0.00),('1','139','772','198127',3863216,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','198365',3867217,'2143','330',1192281.97,1195916.61,0.00,0.00,3634.64,1213129.84,0.00,0.00,0.00),('1','139','772','198365',3867218,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','198574',3870869,'2143','330',1195916.61,1197278.68,0.00,0.00,1362.07,467316.92,0.00,0.00,0.00),('1','139','772','198574',3870870,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','198790',3874475,'2143','330',1197278.68,1200352.98,0.00,0.00,3074.30,1031458.80,0.00,0.00,0.00),('1','139','772','198790',3874476,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','198996',3878043,'2143','330',1200352.98,1202906.47,0.00,0.00,2553.49,860038.44,0.00,0.00,0.00),('1','139','772','198996',3878044,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','199216',3882008,'2143','330',1202906.47,1207506.92,0.00,0.00,4600.45,1514808.20,0.00,0.00,0.00),('1','139','772','199216',3882009,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','199374',3884584,'2143','330',1207506.92,1207506.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','199374',3884585,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','199382',3884746,'2143','330',1207506.92,1209517.32,0.00,0.00,2010.40,671214.40,0.00,0.00,0.00),('1','139','772','199382',3884747,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','199438',3885522,'2143','330',1209517.32,1214027.70,0.00,0.00,4510.38,1500699.28,0.00,0.00,0.00),('1','139','772','199438',3885523,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','199672',3889410,'2143','330',1214027.70,1217929.32,0.00,0.00,3901.62,1302300.72,0.00,0.00,0.00),('1','139','772','199672',3889411,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','199880',3892671,'2143','330',1217929.32,1220986.49,0.00,0.00,3057.17,1027117.32,0.00,0.00,0.00),('1','139','772','199880',3892672,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','200109',3896873,'2143','330',1220986.49,1223217.90,0.00,0.00,2231.41,756066.76,0.00,0.00,0.00),('1','139','772','200109',3896874,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','200337',3900778,'2143','330',1223217.90,1227864.14,0.00,0.00,4646.24,1541781.44,0.00,0.00,0.00),('1','139','772','200337',3900779,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','200500',3904050,'2143','330',1227864.14,1230150.46,0.00,0.00,2286.32,776632.32,0.00,0.00,0.00),('1','139','772','200500',3904051,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','200703',3907620,'2143','330',1230150.46,1232191.11,0.00,0.00,2040.65,674729.80,0.00,0.00,0.00),('1','139','772','200703',3907621,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','200803',3909373,'2143','330',1232191.11,1232191.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','200803',3909374,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','200830',3909974,'2143','330',1232191.11,1235520.12,0.00,0.00,3329.01,1109078.76,0.00,0.00,0.00),('1','139','772','200830',3909975,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','200942',3911702,'2143','330',1235520.12,1242613.51,0.00,0.00,7093.39,2355176.04,0.00,0.00,0.00),('1','139','772','200942',3911703,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','201130',3914794,'2143','330',1242613.51,1248246.75,0.00,0.00,5633.24,1875602.68,0.00,0.00,0.00),('1','139','772','201130',3914795,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','201323',3918153,'2143','330',1248246.75,1252173.91,0.00,0.00,3927.16,1311660.96,0.00,0.00,0.00),('1','139','772','201323',3918154,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','201503',3921547,'2143','330',1252173.91,1254754.81,0.00,0.00,2580.90,876087.00,0.00,0.00,0.00),('1','139','772','201503',3921548,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','201772',3926707,'2143','330',1254754.81,1256896.03,0.00,0.00,2141.22,721855.92,0.00,0.00,0.00),('1','139','772','201772',3926708,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','201879',3928638,'2143','330',1256896.03,1261899.89,0.00,0.00,5003.86,1663467.76,0.00,0.00,0.00),('1','139','772','201879',3928639,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','202035',3931672,'2143','330',1261899.89,1263935.31,0.00,0.00,2035.42,701545.52,0.00,0.00,0.00),('1','139','772','202035',3931673,'2186','330',2457.45,2457.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','202316',3936414,'2143','330',1263935.31,1268247.12,0.00,0.00,4311.81,1461481.60,0.00,0.00,0.00),('1','139','772','202316',3936415,'2186','330',2457.45,2463.01,0.00,0.00,5.56,2001.60,0.00,0.00,0.00),('1','139','772','202443',3938590,'2143','330',1268247.12,1274044.23,0.00,0.00,5797.11,1952452.80,0.00,0.00,0.00),('1','139','772','202443',3938591,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','202694',3942893,'2143','330',1274044.23,1278692.48,0.00,0.00,4648.25,1576429.60,0.00,0.00,0.00),('1','139','772','202694',3942894,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','202861',3946038,'2143','330',1278692.48,1281535.33,0.00,0.00,2842.85,951178.80,0.00,0.00,0.00),('1','139','772','202861',3946039,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','202944',3947495,'2143','330',1281535.33,1281535.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','202944',3947496,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','202946',3947515,'2143','330',1281535.33,1284364.96,0.00,0.00,2829.63,955766.80,0.00,0.00,0.00),('1','139','772','202946',3947516,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','203120',3950930,'2143','330',1284364.96,1287347.14,0.00,0.00,2982.18,1028751.00,0.00,0.00,0.00),('1','139','772','203120',3950931,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','203319',3954581,'2143','330',1287347.14,1291021.19,0.00,0.00,3674.05,1260882.00,0.00,0.00,0.00),('1','139','772','203319',3954582,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','203534',3958434,'2143','330',1291021.19,1294202.33,0.00,0.00,3181.14,1092042.40,0.00,0.00,0.00),('1','139','772','203534',3958435,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','203745',3962182,'2143','330',1294202.33,1297613.22,0.00,0.00,3410.89,1167480.40,0.00,0.00,0.00),('1','139','772','203745',3962183,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','203976',3966232,'2143','330',1297613.22,1299006.12,0.00,0.00,1392.90,488372.00,0.00,0.00,0.00),('1','139','772','203976',3966233,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','204209',3970532,'2143','330',1299006.12,1303311.65,0.00,0.00,4305.53,1478170.80,0.00,0.00,0.00),('1','139','772','204209',3970533,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','204412',3974175,'2143','330',1303311.65,1305970.40,0.00,0.00,2658.75,892570.00,0.00,0.00,0.00),('1','139','772','204412',3974176,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','204505',3975898,'2143','330',1305970.40,1305970.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','204505',3975899,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','204512',3976045,'2143','330',1305970.40,1308132.25,0.00,0.00,2161.85,744232.00,0.00,0.00,0.00),('1','139','772','204512',3976046,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','204632',3978190,'2143','330',1308132.25,1315035.11,0.00,0.00,6902.86,2333776.80,0.00,0.00,0.00),('1','139','772','204632',3978191,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','204875',3982129,'2143','330',1315035.11,1322449.25,0.00,0.00,7414.14,2502670.40,0.00,0.00,0.00),('1','139','772','204875',3982130,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','205052',3985299,'2143','330',1322449.25,1328027.72,0.00,0.00,5578.47,1889335.00,0.00,0.00,0.00),('1','139','772','205052',3985300,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','205265',3989133,'2143','330',1328027.72,1330679.12,0.00,0.00,2651.40,898284.00,0.00,0.00,0.00),('1','139','772','205265',3989134,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','205405',3991817,'2143','330',1330679.12,1330679.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','205405',3991818,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','205416',3992074,'2143','330',1330679.12,1332440.30,0.00,0.00,1761.18,605091.60,0.00,0.00,0.00),('1','139','772','205416',3992075,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','205527',3993890,'2143','330',1332440.30,1339975.13,0.00,0.00,7534.83,2548188.80,0.00,0.00,0.00),('1','139','772','205527',3993891,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','205733',3997766,'2143','330',1339975.13,1344295.77,0.00,0.00,4320.64,1480530.40,0.00,0.00,0.00),('1','139','772','205733',3997767,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','205958',4001730,'2143','330',1344295.77,1346809.22,0.00,0.00,2513.45,870542.00,0.00,0.00,0.00),('1','139','772','205958',4001731,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','206157',4005332,'2143','330',1346809.22,1350261.33,0.00,0.00,3452.11,1186512.00,0.00,0.00,0.00),('1','139','772','206157',4005333,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','206411',4009598,'2143','330',1350261.33,1352990.50,0.00,0.00,2729.17,926921.20,0.00,0.00,0.00),('1','139','772','206411',4009599,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','206498',4011285,'2143','330',1352990.50,1352990.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','206498',4011286,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','206508',4011497,'2143','330',1352990.50,1354394.09,0.00,0.00,1403.59,484392.40,0.00,0.00,0.00),('1','139','772','206508',4011498,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','206582',4012641,'2143','330',1354394.09,1357929.92,0.00,0.00,3535.83,1218358.80,0.00,0.00,0.00),('1','139','772','206582',4012642,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','206814',4016750,'2143','330',1357929.92,1361089.38,0.00,0.00,3159.46,1086165.60,0.00,0.00,0.00),('1','139','772','206814',4016751,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','207036',4020771,'2143','330',1361089.38,1366293.53,0.00,0.00,5204.15,1770178.00,0.00,0.00,0.00),('1','139','772','207036',4020772,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','207259',4024783,'2143','330',1366293.53,1370408.68,0.00,0.00,4115.15,1413595.20,0.00,0.00,0.00),('1','139','772','207259',4024784,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','207483',4028854,'2143','330',1370408.68,1376618.17,0.00,0.00,6209.49,2099514.40,0.00,0.00,0.00),('1','139','772','207483',4028855,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','207643',4031665,'2143','330',1376618.17,1376618.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','207643',4031666,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','207654',4031840,'2143','330',1376618.17,1377380.47,0.00,0.00,762.30,265888.00,0.00,0.00,0.00),('1','139','772','207654',4031841,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','207721',4032798,'2143','330',1377380.47,1379761.27,0.00,0.00,2380.80,852833.20,0.00,0.00,0.00),('1','139','772','207721',4032799,'2186','330',2463.01,2463.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','207940',4036522,'2143','330',1379761.27,1385199.29,0.00,0.00,5438.02,1912859.36,0.00,0.00,0.00),('1','139','772','207940',4036523,'2186','330',2463.01,2465.01,0.00,0.00,2.00,736.00,0.00,0.00,0.00),('1','139','772','208117',4039672,'2143','330',1385199.29,1387323.52,0.00,0.00,2124.23,763307.30,0.00,0.00,0.00),('1','139','772','208117',4039673,'2186','330',2465.01,2471.01,0.00,0.00,6.00,2208.00,0.00,0.00,0.00),('1','139','772','208342',4043735,'2143','330',1387323.52,1392566.39,0.00,0.00,5242.87,1844393.96,0.00,0.00,0.00),('1','139','772','208342',4043736,'2186','330',2471.01,2471.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','208549',4047458,'2143','330',1392566.39,1396304.84,0.00,0.00,3738.45,1320488.80,0.00,0.00,0.00),('1','139','772','208549',4047459,'2186','330',2471.01,2471.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','208767',4051147,'2143','330',1396304.84,1401200.36,0.00,0.00,4895.52,1712403.96,0.00,0.00,0.00),('1','139','772','208767',4051148,'2186','330',2471.01,2471.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','208954',4054604,'2143','330',1401200.36,1401200.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','208954',4054605,'2186','330',2471.01,2471.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','209009',4055241,'2143','330',1401200.36,1408644.61,0.00,0.00,7444.25,2702117.00,0.00,0.00,0.00),('1','139','772','209009',4055242,'2186','330',2471.01,2482.01,0.00,0.00,11.00,4400.00,0.00,0.00,0.00),('1','139','772','209253',4059548,'2143','330',1408644.61,1413795.04,0.00,0.00,5150.43,1906060.00,0.00,0.00,0.00),('1','139','772','209253',4059549,'2186','330',2482.01,2482.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','209486',4063765,'2143','330',1413795.04,1417736.02,0.00,0.00,3940.98,1481182.70,0.00,0.00,0.00),('1','139','772','209486',4063766,'2186','330',2482.01,2482.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','209665',4066841,'2143','330',1417736.02,1420350.12,0.00,0.00,2614.10,987246.50,0.00,0.00,0.00),('1','139','772','209665',4066842,'2186','330',2482.01,2482.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','209879',4070644,'2143','330',1420350.12,1422739.82,0.00,0.00,2389.70,930419.80,0.00,0.00,0.00),('1','139','772','209879',4070645,'2186','330',2482.01,2482.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','210137',4075223,'2143','330',1422739.82,1425912.95,0.00,0.00,3173.13,1195784.60,0.00,0.00,0.00),('1','139','772','210137',4075224,'2186','330',2482.01,2482.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','210206',4076410,'2143','330',1425912.95,1425912.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','210206',4076411,'2186','330',2482.01,2482.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','210574',4083086,'2143','330',1425912.95,1431325.30,0.00,0.00,5412.35,2067831.40,0.00,0.00,0.00),('1','139','772','210574',4083087,'2186','330',2482.01,2482.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','210735',4086024,'2143','330',1431325.30,1435180.98,0.00,0.00,3855.68,1490163.38,0.00,0.00,0.00),('1','139','772','210735',4086025,'2186','330',2482.01,2482.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','210961',4089760,'2143','330',1435180.98,1440236.01,0.00,0.00,5055.03,1937845.60,0.00,0.00,0.00),('1','139','772','210961',4089761,'2186','330',2482.01,2482.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','211173',4093605,'2143','330',1440236.01,1444494.01,0.00,0.00,4258.00,1652428.00,0.00,0.00,0.00),('1','139','772','211173',4093606,'2186','330',2482.01,2482.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','211429',4098097,'2143','330',1444494.01,1450510.55,0.00,0.00,6016.54,2390796.20,0.00,0.00,0.00),('1','139','772','211429',4098098,'2186','330',2482.01,2482.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','211667',4102239,'2143','330',1450510.55,1450510.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','211667',4102240,'2186','330',2482.01,2482.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','211684',4102506,'2143','330',1450510.55,1452961.32,0.00,0.00,2450.77,972434.70,0.00,0.00,0.00),('1','139','772','211684',4102507,'2186','330',2482.01,2482.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','211822',4104772,'2143','330',1452961.32,1456365.02,0.00,0.00,3403.70,1373621.00,0.00,0.00,0.00),('1','139','772','211822',4104773,'2186','330',2482.01,2482.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','212003',4108059,'2143','330',1456365.02,1458717.32,0.00,0.00,2352.30,949350.60,0.00,0.00,0.00),('1','139','772','212003',4108060,'2186','330',2482.01,2482.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','212241',4112238,'2143','330',1458717.32,1463166.12,0.00,0.00,4448.80,1784210.80,0.00,0.00,0.00),('1','139','772','212241',4112239,'2186','330',2482.01,2482.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','212463',4116364,'2143','330',1463166.12,1468236.86,0.00,0.00,5070.74,2029391.40,0.00,0.00,0.00),('1','139','772','212463',4116365,'2186','330',2482.01,2482.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','212676',4120160,'2143','330',1468236.86,1471939.18,0.00,0.00,3702.32,1478443.20,0.00,0.00,0.00),('1','139','772','212676',4120161,'2186','330',2482.01,2482.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','212889',4123852,'2143','330',1471939.18,1475156.47,0.00,0.00,3217.29,1271520.70,0.00,0.00,0.00),('1','139','772','212889',4123853,'2186','330',2482.01,2484.01,0.00,0.00,2.00,860.00,0.00,0.00,0.00),('1','139','772','213033',4126589,'2143','330',1475156.47,1475156.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','213033',4126590,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','213141',4128248,'2143','330',1475156.47,1481772.71,0.00,0.00,6616.24,2635927.20,0.00,0.00,0.00),('1','139','772','213141',4128249,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','213399',4132465,'2143','330',1481772.71,1486606.12,0.00,0.00,4833.41,1931980.38,0.00,0.00,0.00),('1','139','772','213399',4132466,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','213639',4136494,'2143','330',1486606.12,1490503.74,0.00,0.00,3897.62,1572488.60,0.00,0.00,0.00),('1','139','772','213639',4136495,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','213896',4140723,'2143','330',1490503.74,1492834.48,0.00,0.00,2330.74,947802.60,0.00,0.00,0.00),('1','139','772','213896',4140724,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','214150',4144998,'2143','330',1492834.48,1499715.95,0.00,0.00,6881.47,2704133.38,0.00,0.00,0.00),('1','139','772','214150',4144999,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','214288',4147630,'2143','330',1499715.95,1499715.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','214288',4147631,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','214354',4148533,'2143','330',1499715.95,1502963.31,0.00,0.00,3247.36,1305379.60,0.00,0.00,0.00),('1','139','772','214354',4148534,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','214545',4151729,'2143','330',1502963.31,1512227.88,0.00,0.00,9264.57,3672349.10,0.00,0.00,0.00),('1','139','772','214545',4151730,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','214785',4155962,'2143','330',1512227.88,1524270.14,0.00,0.00,12042.26,4758090.06,0.00,0.00,0.00),('1','139','772','214785',4155963,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','215324',4165160,'2143','330',1524270.14,1532488.73,0.00,0.00,8218.59,3352714.54,0.00,0.00,0.00),('1','139','772','215324',4165161,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','215453',4167138,'2143','330',1532488.73,1541471.41,0.00,0.00,8982.68,3684906.48,0.00,0.00,0.00),('1','139','772','215453',4167139,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','215685',4171182,'2143','330',1541471.41,1546040.85,0.00,0.00,4569.44,1901865.84,0.00,0.00,0.00),('1','139','772','215685',4171183,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','215921',4175252,'2143','330',1546040.85,1548793.88,0.00,0.00,2753.03,1143516.58,0.00,0.00,0.00),('1','139','772','215921',4175253,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','216060',4177789,'2143','330',1548793.88,1548793.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','216060',4177790,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','216113',4178606,'2143','330',1548793.88,1551566.30,0.00,0.00,2772.42,1170069.62,0.00,0.00,0.00),('1','139','772','216113',4178607,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','216337',4182424,'2143','330',1551566.30,1556681.14,0.00,0.00,5114.84,2127349.14,0.00,0.00,0.00),('1','139','772','216337',4182425,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','216563',4186347,'2143','330',1556681.14,1560031.75,0.00,0.00,3350.61,1403765.46,0.00,0.00,0.00),('1','139','772','216563',4186348,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','216799',4190579,'2143','330',1560031.75,1564067.61,0.00,0.00,4035.86,1688696.56,0.00,0.00,0.00),('1','139','772','216799',4190580,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','217032',4194599,'2143','330',1564067.61,1570680.49,0.00,0.00,6612.88,2738912.88,0.00,0.00,0.00),('1','139','772','217032',4194600,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','217285',4199473,'2143','330',1570680.49,1573105.79,0.00,0.00,2425.30,993354.80,0.00,0.00,0.00),('1','139','772','217285',4199474,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','217465',4202567,'2143','330',1573105.79,1573105.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','217465',4202568,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','217860',4209601,'2143','330',1573105.79,1575571.92,0.00,0.00,2466.13,1095482.72,0.00,0.00,0.00),('1','139','772','217860',4209602,'2186','330',2484.01,2484.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','217994',4211819,'2143','330',1575571.92,1579008.71,0.00,0.00,3436.79,1523850.56,0.00,0.00,0.00),('1','139','772','217994',4211820,'2186','330',2484.01,2496.01,0.00,0.00,12.00,5568.00,0.00,0.00,0.00),('1','139','772','218235',4215976,'2143','330',1579008.71,1583545.01,0.00,0.00,4536.30,1997366.40,0.00,0.00,0.00),('1','139','772','218235',4215977,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','218443',4219810,'2143','330',1583545.01,1587740.33,0.00,0.00,4195.32,1854308.48,0.00,0.00,0.00),('1','139','772','218443',4219811,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','218690',4224075,'2143','330',1587740.33,1593067.25,0.00,0.00,5326.92,2349470.88,0.00,0.00,0.00),('1','139','772','218690',4224076,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','218915',4228046,'2143','330',1593067.25,1597471.47,0.00,0.00,4404.22,1925786.08,0.00,0.00,0.00),('1','139','772','218915',4228047,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','219049',4230336,'2143','330',1597471.47,1597471.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','219049',4230337,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','219074',4230870,'2143','330',1597471.47,1599772.92,0.00,0.00,2301.45,1036332.80,0.00,0.00,0.00),('1','139','772','219074',4230871,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','219338',4235368,'2143','330',1599772.92,1604728.99,0.00,0.00,4956.07,2189136.48,0.00,0.00,0.00),('1','139','772','219338',4235369,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','219606',4239879,'2143','330',1604728.99,1607235.49,0.00,0.00,2506.50,1129399.20,0.00,0.00,0.00),('1','139','772','219606',4239880,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','219818',4243761,'2143','330',1607235.49,1609748.04,0.00,0.00,2512.55,1125550.32,0.00,0.00,0.00),('1','139','772','219818',4243762,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','220045',4247908,'2143','330',1609748.04,1613167.57,0.00,0.00,3419.53,1529175.84,0.00,0.00,0.00),('1','139','772','220045',4247909,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','220270',4251697,'2143','330',1613167.57,1617657.78,0.00,0.00,4490.21,1997969.44,0.00,0.00,0.00),('1','139','772','220270',4251698,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','220528',4256416,'2143','330',1617657.78,1622032.02,0.00,0.00,4374.24,1932047.36,0.00,0.00,0.00),('1','139','772','220528',4256417,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','220775',4260612,'2143','330',1622032.02,1622032.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','220775',4260613,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','220788',4260857,'2143','330',1622032.02,1625089.42,0.00,0.00,3057.40,1354973.60,0.00,0.00,0.00),('1','139','772','220788',4260858,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','220924',4263422,'2143','330',1625089.42,1630966.22,0.00,0.00,5876.80,2592275.20,0.00,0.00,0.00),('1','139','772','220924',4263423,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','221154',4267448,'2143','330',1630966.22,1636634.61,0.00,0.00,5668.39,2504633.76,0.00,0.00,0.00),('1','139','772','221154',4267449,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','221406',4271968,'2143','330',1636634.61,1642173.17,0.00,0.00,5538.56,2449558.24,0.00,0.00,0.00),('1','139','772','221406',4271969,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','221625',4276115,'2143','330',1642173.17,1646546.78,0.00,0.00,4373.61,1917467.04,0.00,0.00,0.00),('1','139','772','221625',4276116,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','221713',4277620,'2143','330',1646546.78,1646546.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','221713',4277621,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','221794',4279276,'2143','330',1646546.78,1648257.50,0.00,0.00,1710.72,769155.84,0.00,0.00,0.00),('1','139','772','221794',4279277,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','221850',4279988,'2143','330',1648257.50,1653011.88,0.00,0.00,4754.38,2113885.32,0.00,0.00,0.00),('1','139','772','221850',4279989,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','222066',4284081,'2143','330',1653011.88,1660552.09,0.00,0.00,7540.21,3324889.44,0.00,0.00,0.00),('1','139','772','222066',4284082,'2186','330',2496.01,2496.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','222279',4287594,'2143','330',1660552.09,1663969.88,0.00,0.00,3417.79,1533668.56,0.00,0.00,0.00),('1','139','772','222279',4287595,'2186','330',2496.01,2498.60,0.00,0.00,2.59,1201.76,0.00,0.00,0.00),('1','139','772','222511',4291557,'2143','330',1663969.88,1671185.42,0.00,0.00,7215.54,3176146.56,0.00,0.00,0.00),('1','139','772','222511',4291558,'2186','330',2498.60,2498.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','223110',4302807,'2143','330',1671185.42,1671185.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','223110',4302808,'2186','330',2498.60,2498.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','223118',4303002,'2143','330',1671185.42,1673542.46,0.00,0.00,2357.04,1063068.96,0.00,0.00,0.00),('1','139','772','223118',4303003,'2186','330',2498.60,2498.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','223187',4303821,'2143','330',1673542.46,1678922.73,0.00,0.00,5380.27,2443043.98,0.00,0.00,0.00),('1','139','772','223187',4303822,'2186','330',2498.60,2498.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','223423',4307993,'2143','330',1678922.73,1687913.15,0.00,0.00,8990.42,4080078.28,0.00,0.00,0.00),('1','139','772','223423',4307994,'2186','330',2498.60,2501.10,0.00,0.00,2.50,1185.00,0.00,0.00,0.00),('1','139','772','223646',4312103,'2143','330',1687913.15,1691321.64,0.00,0.00,3408.49,1586201.12,0.00,0.00,0.00),('1','139','772','223646',4312104,'2186','330',2501.10,2501.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','223879',4316444,'2143','330',1691321.64,1695867.06,0.00,0.00,4545.42,2059988.40,0.00,0.00,0.00),('1','139','772','223879',4316445,'2186','330',2501.10,2501.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','224146',4320893,'2143','330',1695867.06,1695867.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','224146',4320894,'2186','330',2501.10,2501.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','224165',4321234,'2143','330',1695867.06,1704534.58,0.00,0.00,8667.52,4014488.64,0.00,0.00,0.00),('1','139','772','224165',4321235,'2186','330',2501.10,2501.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','224336',4324427,'2143','330',1704534.58,1708672.46,0.00,0.00,4137.88,2048786.68,0.00,0.00,0.00),('1','139','772','224336',4324428,'2186','330',2501.10,2501.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','224533',4327944,'2143','330',1708672.46,1710991.29,0.00,0.00,2318.83,1152671.28,0.00,0.00,0.00),('1','139','772','224533',4327945,'2186','330',2501.10,2501.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','224783',4332258,'2143','330',1710991.29,1712664.84,0.00,0.00,1673.55,839640.80,0.00,0.00,0.00),('1','139','772','224783',4332259,'2186','330',2501.10,2505.10,0.00,0.00,4.00,2064.00,0.00,0.00,0.00),('1','139','772','225026',4336616,'2143','330',1712664.84,1720479.33,0.00,0.00,7814.49,3812766.84,0.00,0.00,0.00),('1','139','772','225026',4336617,'2186','330',2505.10,2505.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','225129',4338597,'2143','330',1720479.33,1720479.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','225129',4338598,'2186','330',2505.10,2505.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','225184',4339575,'2143','330',1720479.33,1721488.77,0.00,0.00,1009.44,457400.24,0.00,0.00,0.00),('1','139','772','225184',4339576,'2186','330',2505.10,2505.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','225274',4341167,'2143','330',1721488.77,1725232.18,0.00,0.00,3743.41,1843864.76,0.00,0.00,0.00),('1','139','772','225274',4341168,'2186','330',2505.10,2505.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','225486',4345132,'2143','330',1725232.18,1727926.69,0.00,0.00,2694.51,1338416.36,0.00,0.00,0.00),('1','139','772','225486',4345133,'2186','330',2505.10,2511.11,0.00,0.00,6.01,3101.16,0.00,0.00,0.00),('1','139','772','225703',4348755,'2143','330',1727926.69,1731109.32,0.00,0.00,3182.63,1572142.08,0.00,0.00,0.00),('1','139','772','225703',4348756,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','225984',4353550,'2143','330',1731109.32,1735215.72,0.00,0.00,4106.40,2027967.00,0.00,0.00,0.00),('1','139','772','225984',4353551,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','226231',4358362,'2143','330',1735215.72,1739259.59,0.00,0.00,4043.87,1997595.60,0.00,0.00,0.00),('1','139','772','226231',4358363,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','226491',4362708,'2143','330',1739259.59,1745020.77,0.00,0.00,5761.18,2818482.68,0.00,0.00,0.00),('1','139','772','226491',4362709,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','226648',4365837,'2143','330',1745020.77,1745020.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','226648',4365838,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','226735',4367298,'2143','330',1745020.77,1753835.72,0.00,0.00,8814.95,4308841.20,0.00,0.00,0.00),('1','139','772','226735',4367299,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','227026',4372269,'2143','330',1753835.72,1759175.74,0.00,0.00,5340.02,2628875.72,0.00,0.00,0.00),('1','139','772','227026',4372270,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','227192',4375319,'2143','330',1759175.74,1762981.46,0.00,0.00,3805.72,1879807.52,0.00,0.00,0.00),('1','139','772','227192',4375320,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','227381',4378653,'2143','330',1762981.46,1767463.94,0.00,0.00,4482.48,2217264.20,0.00,0.00,0.00),('1','139','772','227381',4378654,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','227615',4382656,'2143','330',1767463.94,1769641.02,0.00,0.00,2177.08,1060324.48,0.00,0.00,0.00),('1','139','772','227615',4382657,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','227756',4385327,'2143','330',1769641.02,1769641.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','227756',4385328,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','227832',4386747,'2143','330',1769641.02,1771679.12,0.00,0.00,2038.10,1060707.40,0.00,0.00,0.00),('1','139','772','227832',4386748,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','228320',4396128,'2143','330',1771679.12,1775076.02,0.00,0.00,3396.90,1744512.60,0.00,0.00,0.00),('1','139','772','228320',4396129,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','228325',4396198,'2143','330',1775076.02,1781373.52,0.00,0.00,6297.50,3218788.00,0.00,0.00,0.00),('1','139','772','228325',4396199,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','228357',4396536,'2143','330',1781373.52,1787368.19,0.00,0.00,5994.67,3065045.78,0.00,0.00,0.00),('1','139','772','228357',4396537,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','228539',4399894,'2143','330',1787368.19,1791747.53,0.00,0.00,4379.34,2250555.76,0.00,0.00,0.00),('1','139','772','228539',4399895,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','228757',4404117,'2143','330',1791747.53,1794171.73,0.00,0.00,2424.20,1252766.80,0.00,0.00,0.00),('1','139','772','228757',4404118,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','228919',4407223,'2143','330',1794171.73,1794171.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','228919',4407224,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','228951',4407548,'2143','330',1794171.73,1802073.07,0.00,0.00,7901.34,4048452.76,0.00,0.00,0.00),('1','139','772','228951',4407549,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','229174',4412037,'2143','330',1802073.07,1814698.09,0.00,0.00,12625.02,6447502.68,0.00,0.00,0.00),('1','139','772','229174',4412038,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','229485',4417494,'2143','330',1814698.09,1818880.26,0.00,0.00,4182.17,2263897.48,0.00,0.00,0.00),('1','139','772','229485',4417495,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','229633',4420822,'2143','330',1818880.26,1818880.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','229633',4420823,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','229670',4421278,'2143','330',1818880.26,1832074.87,0.00,0.00,13194.61,7134424.24,0.00,0.00,0.00),('1','139','772','229670',4421279,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','229910',4425888,'2143','330',1832074.87,1839632.82,0.00,0.00,7557.95,4094928.80,0.00,0.00,0.00),('1','139','772','229910',4425889,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','230098',4429448,'2143','330',1839632.82,1843584.22,0.00,0.00,3951.40,2153774.60,0.00,0.00,0.00),('1','139','772','230098',4429449,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','230455',4436461,'2143','330',1843584.22,1849955.03,0.00,0.00,6370.81,3427457.04,0.00,0.00,0.00),('1','139','772','230455',4436462,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','230539',4437701,'2143','330',1849955.03,1859076.17,0.00,0.00,9121.14,4942914.76,0.00,0.00,0.00),('1','139','772','230539',4437702,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','230796',4442205,'2143','330',1859076.17,1864843.51,0.00,0.00,5767.34,3128396.16,0.00,0.00,0.00),('1','139','772','230796',4442206,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','231076',4447067,'2143','330',1864843.51,1866600.68,0.00,0.00,1757.17,967829.28,0.00,0.00,0.00),('1','139','772','231076',4447068,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','231379',4451850,'2143','330',1866600.68,1868264.72,0.00,0.00,1664.04,896871.96,0.00,0.00,0.00),('1','139','772','231379',4451851,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','231805',4459626,'2143','330',1868264.72,1868264.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','231805',4459627,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','231910',4461238,'2143','330',1868264.72,1874699.21,0.00,0.00,6434.49,3665226.80,0.00,0.00,0.00),('1','139','772','231910',4461239,'2186','330',2511.11,2511.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','232109',4464980,'2143','330',1874699.21,1878461.77,0.00,0.00,3762.56,2154371.20,0.00,0.00,0.00),('1','139','772','232109',4464981,'2186','330',2511.11,2530.61,0.00,0.00,19.50,11700.00,0.00,0.00,0.00),('1','139','772','232352',4469198,'2143','330',1878461.77,1884219.84,0.00,0.00,5758.07,3282083.44,0.00,0.00,0.00),('1','139','772','232352',4469199,'2186','330',2530.61,2531.61,0.00,0.00,1.00,600.00,0.00,0.00,0.00),('1','139','772','232602',4473785,'2143','330',1884219.84,1890152.15,0.00,0.00,5932.31,3389818.00,0.00,0.00,0.00),('1','139','772','232602',4473786,'2186','330',2531.61,2531.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','232862',4478370,'2143','330',1890152.15,1892918.34,0.00,0.00,2766.19,1575948.40,0.00,0.00,0.00),('1','139','772','232862',4478371,'2186','330',2531.61,2531.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','233287',4486338,'2143','330',1892918.34,1892918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','233287',4486339,'2186','330',2531.61,2531.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','233396',4488104,'2143','330',1892918.34,1898838.55,0.00,0.00,5920.21,3426589.44,0.00,0.00,0.00),('1','139','772','233396',4488105,'2186','330',2531.61,2531.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','233623',4492185,'2143','330',1898838.55,1903044.05,0.00,0.00,4205.50,2492114.00,0.00,0.00,0.00),('1','139','772','233623',4492186,'2186','330',2531.61,2531.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','233857',4496343,'2143','330',1903044.05,1904674.81,0.00,0.00,1630.76,983034.24,0.00,0.00,0.00),('1','139','772','233857',4496344,'2186','330',2531.61,2531.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','234069',4500158,'2143','330',1904674.81,1907141.47,0.00,0.00,2466.66,1467081.04,0.00,0.00,0.00),('1','139','772','234069',4500159,'2186','330',2531.61,2531.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','234322',4504787,'2143','330',1907141.47,1910463.61,0.00,0.00,3322.14,1974049.36,0.00,0.00,0.00),('1','139','772','234322',4504788,'2186','330',2531.61,2531.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','234572',4509317,'2143','330',1910463.61,1917417.19,0.00,0.00,6953.58,4083099.92,0.00,0.00,0.00),('1','139','772','234572',4509318,'2186','330',2531.61,2531.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','234773',4512988,'2143','330',1917417.19,1917417.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','234773',4512989,'2186','330',2531.61,2531.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','234844',4514067,'2143','330',1917417.19,1919351.50,0.00,0.00,1934.31,1163483.28,0.00,0.00,0.00),('1','139','772','234844',4514068,'2186','330',2531.61,2531.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','235080',4518328,'2143','330',1919351.50,1921354.97,0.00,0.00,2003.47,1203239.28,0.00,0.00,0.00),('1','139','772','235080',4518329,'2186','330',2531.61,2534.61,0.00,0.00,3.00,1872.00,0.00,0.00,0.00),('1','139','772','235376',4523463,'2143','330',1921354.97,1924213.74,0.00,0.00,2858.77,1699625.68,0.00,0.00,0.00),('1','139','772','235376',4523464,'2186','330',2534.61,2534.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','235548',4526427,'2143','330',1924213.74,1928237.13,0.00,0.00,4023.39,2380895.36,0.00,0.00,0.00),('1','139','772','235548',4526428,'2186','330',2534.61,2534.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','235770',4530344,'2143','330',1928237.13,1931490.09,0.00,0.00,3252.96,1931411.04,0.00,0.00,0.00),('1','139','772','235770',4530345,'2186','330',2534.61,2534.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','236043',4535054,'2143','330',1931490.09,1937897.52,0.00,0.00,6407.43,3757278.88,0.00,0.00,0.00),('1','139','772','236043',4535055,'2186','330',2534.61,2534.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','236246',4538784,'2143','330',1937897.52,1941662.26,0.00,0.00,3764.74,2215809.76,0.00,0.00,0.00),('1','139','772','236246',4538785,'2186','330',2534.61,2534.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','236615',4545286,'2143','330',1941662.26,1941662.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','236615',4545287,'2186','330',2534.61,2534.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','236623',4545371,'2143','330',1941662.26,1947646.64,0.00,0.00,5984.38,3570240.28,0.00,0.00,0.00),('1','139','772','236623',4545372,'2186','330',2534.61,2534.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','236751',4547439,'2143','330',1947646.64,1956097.75,0.00,0.00,8451.11,5040630.85,0.00,0.00,0.00),('1','139','772','236751',4547440,'2186','330',2534.61,2534.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','236975',4551464,'2143','330',1956097.75,1965201.51,0.00,0.00,9103.76,5433195.60,0.00,0.00,0.00),('1','139','772','236975',4551465,'2186','330',2534.61,2534.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','237236',4555989,'2143','330',1965201.51,1966329.51,0.00,0.00,1128.00,674480.00,0.00,0.00,0.00),('1','139','772','237236',4555990,'2186','330',2534.61,2534.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','237242',4556101,'2143','330',1966329.51,1966329.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','237242',4556102,'2186','330',2534.61,2534.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','237406',4559190,'2143','330',1966329.51,1971639.24,0.00,0.00,5309.73,3183838.55,0.00,0.00,0.00),('1','139','772','237406',4559191,'2186','330',2534.61,2534.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','237628',4563070,'2143','330',1971639.24,1982352.08,0.00,0.00,10712.84,6526169.20,0.00,0.00,0.00),('1','139','772','237628',4563071,'2186','330',2534.61,2538.61,0.00,0.00,4.00,2624.00,0.00,0.00,0.00),('1','139','772','237887',4567343,'2143','330',1982352.08,1987694.46,0.00,0.00,5342.38,3332445.04,0.00,0.00,0.00),('1','139','772','237887',4567344,'2186','330',2538.61,2543.18,0.00,0.00,4.57,2997.92,0.00,0.00,0.00),('1','139','772','238123',4571144,'2143','330',1987694.46,1990982.83,0.00,0.00,3288.37,2040958.52,0.00,0.00,0.00),('1','139','772','238123',4571145,'2186','330',2543.18,2543.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','238251',4573494,'2143','330',1990982.83,1990982.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','238251',4573495,'2186','330',2543.18,2543.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','238275',4573786,'2143','330',1990982.83,1992645.32,0.00,0.00,1662.49,1054539.44,0.00,0.00,0.00),('1','139','772','238275',4573787,'2186','330',2543.18,2546.18,0.00,0.00,3.00,1968.00,0.00,0.00,0.00),('1','139','772','238363',4575373,'2143','330',1992645.32,1999129.31,0.00,0.00,6483.99,3978565.44,0.00,0.00,0.00),('1','139','772','238363',4575374,'2186','330',2546.18,2546.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','238614',4579435,'2143','330',1999129.31,2003986.14,0.00,0.00,4856.83,3031108.44,0.00,0.00,0.00),('1','139','772','238614',4579436,'2186','330',2546.18,2548.47,0.00,0.00,2.29,1502.24,0.00,0.00,0.00),('1','139','772','238840',4583516,'2143','330',2003986.14,2006940.35,0.00,0.00,2954.21,1854250.92,0.00,0.00,0.00),('1','139','772','238840',4583517,'2186','330',2548.47,2548.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','239076',4587729,'2143','330',2006940.35,2012349.29,0.00,0.00,5408.94,3372976.64,0.00,0.00,0.00),('1','139','772','239076',4587730,'2186','330',2548.47,2548.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','239307',4591708,'2143','330',2012349.29,2015589.18,0.00,0.00,3239.89,2011239.84,0.00,0.00,0.00),('1','139','772','239307',4591709,'2186','330',2548.47,2548.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','239441',4594071,'2143','330',2015589.18,2015589.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','239441',4594072,'2186','330',2548.47,2548.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','239445',4594108,'2143','330',2015589.18,2017677.41,0.00,0.00,2088.23,1316958.88,0.00,0.00,0.00),('1','139','772','239445',4594109,'2186','330',2548.47,2548.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','239544',4595667,'2143','330',2017677.41,2020329.43,0.00,0.00,2652.02,1678391.52,0.00,0.00,0.00),('1','139','772','239544',4595668,'2186','330',2548.47,2548.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','239787',4599987,'2143','330',2020329.43,2025308.57,0.00,0.00,4979.14,3097922.64,0.00,0.00,0.00),('1','139','772','239787',4599988,'2186','330',2548.47,2548.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','240000',4603643,'2143','330',2025308.57,2030908.86,0.00,0.00,5600.29,3483086.24,0.00,0.00,0.00),('1','139','772','240000',4603644,'2186','330',2548.47,2548.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','240208',4607354,'2143','330',2030908.86,2036818.19,0.00,0.00,5909.33,3604427.28,0.00,0.00,0.00),('1','139','772','240208',4607355,'2186','330',2548.47,2548.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','240463',4611407,'2143','330',2036818.19,2039024.83,0.00,0.00,2206.64,1392904.64,0.00,0.00,0.00),('1','139','772','240463',4611408,'2186','330',2548.47,2548.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','240708',4615193,'2143','330',2039024.83,2040261.27,0.00,0.00,1236.44,773664.64,0.00,0.00,0.00),('1','139','772','240708',4615194,'2186','330',2548.47,2548.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','240791',4616676,'2143','330',2040261.27,2040261.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','240791',4616677,'2186','330',2548.47,2548.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','240794',4616690,'2143','330',2040261.27,2041428.97,0.00,0.00,1167.70,740505.20,0.00,0.00,0.00),('1','139','772','240794',4616691,'2186','330',2548.47,2548.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','240982',4620066,'2143','330',2041428.97,2046430.07,0.00,0.00,5001.10,3120917.60,0.00,0.00,0.00),('1','139','772','240982',4620067,'2186','330',2548.47,2548.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','241236',4624650,'2143','330',2046430.07,2048638.66,0.00,0.00,2208.59,1400955.04,0.00,0.00,0.00),('1','139','772','241236',4624651,'2186','330',2548.47,2548.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','241504',4629189,'2143','330',2048638.66,2050995.48,0.00,0.00,2356.82,1483275.52,0.00,0.00,0.00),('1','139','772','241504',4629190,'2186','330',2548.47,2548.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','241752',4633557,'2143','330',2050995.48,2052687.11,0.00,0.00,1691.63,1074645.28,0.00,0.00,0.00),('1','139','772','241752',4633558,'2186','330',2548.47,2548.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','242043',4638594,'2143','330',2052687.11,2056109.29,0.00,0.00,3422.18,2137210.48,0.00,0.00,0.00),('1','139','772','242043',4638595,'2186','330',2548.47,2550.97,0.00,0.00,2.50,1640.00,0.00,0.00,0.00),('1','139','772','242219',4641705,'2143','330',2056109.29,2058598.20,0.00,0.00,2488.91,1540687.40,0.00,0.00,0.00),('1','139','772','242219',4641706,'2186','330',2550.97,2550.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','242451',4645666,'2143','330',2058598.20,2061502.96,0.00,0.00,2904.76,1794221.40,0.00,0.00,0.00),('1','139','772','242451',4645667,'2186','330',2550.97,2550.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','242698',4650098,'2143','330',2061502.96,2064773.06,0.00,0.00,3270.10,1995689.00,0.00,0.00,0.00),('1','139','772','242698',4650099,'2186','330',2550.97,2550.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','242793',4651696,'2143','330',2064773.06,2064773.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','242793',4651697,'2186','330',2550.97,2550.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','242796',4651712,'2143','330',2064773.06,2066899.84,0.00,0.00,2126.78,1307057.20,0.00,0.00,0.00),('1','139','772','242796',4651713,'2186','330',2550.97,2550.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','242940',4654122,'2143','330',2066899.84,2075586.42,0.00,0.00,8686.58,5284521.20,0.00,0.00,0.00),('1','139','772','242940',4654123,'2186','330',2550.97,2550.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','243154',4657878,'2143','330',2075586.42,2080729.24,0.00,0.00,5142.82,3149198.80,0.00,0.00,0.00),('1','139','772','243154',4657879,'2186','330',2550.97,2550.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','243379',4661991,'2143','330',2080729.24,2088082.43,0.00,0.00,7353.19,4469887.60,0.00,0.00,0.00),('1','139','772','243379',4661992,'2186','330',2550.97,2550.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','243605',4665819,'2143','330',2088082.43,2089444.81,0.00,0.00,1362.38,831740.30,0.00,0.00,0.00),('1','139','772','243605',4665820,'2186','330',2550.97,2550.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','243694',4667419,'2143','330',2089444.81,2089444.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','243694',4667420,'2186','330',2550.97,2550.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','244154',4675400,'2143','330',2089444.81,2093470.69,0.00,0.00,4025.88,2469353.20,0.00,0.00,0.00),('1','139','772','244154',4675401,'2186','330',2550.97,2550.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','244304',4677840,'2143','330',2093470.69,2098123.36,0.00,0.00,4652.67,2866856.20,0.00,0.00,0.00),('1','139','772','244304',4677841,'2186','330',2550.97,2550.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','244525',4681749,'2143','330',2098123.36,2104112.54,0.00,0.00,5989.18,3680525.20,0.00,0.00,0.00),('1','139','772','244525',4681750,'2186','330',2550.97,2550.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','244752',4685543,'2143','330',2104112.54,2107783.26,0.00,0.00,3670.72,2254930.80,0.00,0.00,0.00),('1','139','772','244752',4685544,'2186','330',2550.97,2550.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','244982',4689654,'2143','330',2107783.26,2113492.18,0.00,0.00,5708.92,3235472.52,0.00,0.00,0.00),('1','139','772','244982',4689655,'2186','330',2550.97,2555.72,0.00,0.00,4.75,3002.00,0.00,0.00,0.00),('1','139','772','245219',4693867,'2143','330',2113492.18,2114017.14,0.00,0.00,524.96,321019.72,0.00,0.00,0.00),('1','139','772','245219',4693868,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','245438',4697714,'2143','330',2114017.14,2114017.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','245438',4697715,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','245492',4698539,'2143','330',2114017.14,2116339.08,0.00,0.00,2321.94,1422222.08,0.00,0.00,0.00),('1','139','772','245492',4698540,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','245680',4701909,'2143','330',2116339.08,2124234.69,0.00,0.00,7895.61,4749117.52,0.00,0.00,0.00),('1','139','772','245680',4701910,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','245941',4705862,'2143','330',2124234.69,2130339.54,0.00,0.00,6104.85,3561527.60,0.00,0.00,0.00),('1','139','772','245941',4705863,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','246195',4710134,'2143','330',2130339.54,2133109.06,0.00,0.00,2769.52,1631824.32,0.00,0.00,0.00),('1','139','772','246195',4710135,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','246462',4714615,'2143','330',2133109.06,2138648.11,0.00,0.00,5539.05,3217072.80,0.00,0.00,0.00),('1','139','772','246462',4714616,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','246651',4718120,'2143','330',2138648.11,2138648.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','246651',4718121,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','246713',4718888,'2143','330',2138648.11,2143374.59,0.00,0.00,4726.48,2735459.68,0.00,0.00,0.00),('1','139','772','246713',4718889,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','246936',4723051,'2143','330',2143374.59,2147077.91,0.00,0.00,3703.32,2171483.12,0.00,0.00,0.00),('1','139','772','246936',4723052,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','247174',4726949,'2143','330',2147077.91,2150707.99,0.00,0.00,3630.08,2133845.28,0.00,0.00,0.00),('1','139','772','247174',4726950,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','247405',4731083,'2143','330',2150707.99,2155580.18,0.00,0.00,4872.19,2810995.44,0.00,0.00,0.00),('1','139','772','247405',4731084,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','247669',4735540,'2143','330',2155580.18,2161603.77,0.00,0.00,6023.59,3515585.04,0.00,0.00,0.00),('1','139','772','247669',4735541,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','247919',4739724,'2143','330',2161603.77,2163274.02,0.00,0.00,1670.25,971634.00,0.00,0.00,0.00),('1','139','772','247919',4739725,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','248003',4741215,'2143','330',2163274.02,2163274.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','248003',4741216,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','248063',4742158,'2143','330',2163274.02,2163722.40,0.00,0.00,448.38,267655.32,0.00,0.00,0.00),('1','139','772','248063',4742159,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','248165',4743902,'2143','330',2163722.40,2167217.33,0.00,0.00,3494.93,2052668.88,0.00,0.00,0.00),('1','139','772','248165',4743903,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','248413',4748132,'2143','330',2167217.33,2172878.21,0.00,0.00,5660.88,3312154.08,0.00,0.00,0.00),('1','139','772','248413',4748133,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','248648',4752040,'2143','330',2172878.21,2174752.93,0.00,0.00,1874.72,1116191.52,0.00,0.00,0.00),('1','139','772','248648',4752041,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','248862',4755823,'2143','330',2174752.93,2176081.38,0.00,0.00,1328.45,749708.40,0.00,0.00,0.00),('1','139','772','248862',4755824,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','249113',4759891,'2143','330',2176081.38,2177946.33,0.00,0.00,1864.95,1044570.40,0.00,0.00,0.00),('1','139','772','249113',4759892,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','249348',4763971,'2143','330',2177946.33,2179942.42,0.00,0.00,1996.09,1118033.28,0.00,0.00,0.00),('1','139','772','249348',4763972,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','249600',4768214,'2143','330',2179942.42,2182844.98,0.00,0.00,2902.56,1618059.12,0.00,0.00,0.00),('1','139','772','249600',4768215,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','249866',4772638,'2143','330',2182844.98,2185863.19,0.00,0.00,3018.21,1679215.32,0.00,0.00,0.00),('1','139','772','249866',4772639,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','250112',4776699,'2143','330',2185863.19,2187780.07,0.00,0.00,1916.88,1056556.96,0.00,0.00,0.00),('1','139','772','250112',4776700,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','250205',4778387,'2143','330',2187780.07,2187780.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','250205',4778388,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','250245',4779087,'2143','330',2187780.07,2189148.67,0.00,0.00,1368.60,772012.20,0.00,0.00,0.00),('1','139','772','250245',4779088,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','250354',4780831,'2143','330',2189148.67,2191524.31,0.00,0.00,2375.64,1335094.88,0.00,0.00,0.00),('1','139','772','250354',4780832,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','250576',4784466,'2143','330',2191524.31,2194164.75,0.00,0.00,2640.44,1484674.48,0.00,0.00,0.00),('1','139','772','250576',4784467,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','250823',4788740,'2143','330',2194164.75,2199486.79,0.00,0.00,5322.04,2956521.08,0.00,0.00,0.00),('1','139','772','250823',4788741,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','251042',4792790,'2143','330',2199486.79,2207693.92,0.00,0.00,8207.13,4512576.96,0.00,0.00,0.00),('1','139','772','251042',4792791,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','251292',4797009,'2143','330',2207693.92,2212299.95,0.00,0.00,4606.03,2529474.76,0.00,0.00,0.00),('1','139','772','251292',4797010,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','251677',4803976,'2143','330',2212299.95,2212299.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','251677',4803977,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','251683',4804033,'2143','330',2212299.95,2213480.42,0.00,0.00,1180.47,649168.60,0.00,0.00,0.00),('1','139','772','251683',4804034,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','251784',4805627,'2143','330',2213480.42,2218946.42,0.00,0.00,5466.00,2962320.00,0.00,0.00,0.00),('1','139','772','251784',4805628,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','252011',4809528,'2143','330',2218946.42,2228743.99,0.00,0.00,9797.57,5254290.60,0.00,0.00,0.00),('1','139','772','252011',4809529,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','252257',4813781,'2143','330',2228743.99,2231002.36,0.00,0.00,2258.37,1255322.60,0.00,0.00,0.00),('1','139','772','252257',4813782,'2186','330',2555.72,2555.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','252492',4818118,'2143','330',2231002.36,2235681.90,0.00,0.00,4679.54,2562785.20,0.00,0.00,0.00),('1','139','772','252492',4818119,'2186','330',2555.72,2560.22,0.00,0.00,4.50,2610.00,0.00,0.00,0.00),('1','139','772','252733',4822248,'2143','330',2235681.90,2236990.69,0.00,0.00,1308.79,715810.20,0.00,0.00,0.00),('1','139','772','252733',4822249,'2186','330',2560.22,2560.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','252820',4823621,'2143','330',2236990.69,2236990.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','252820',4823622,'2186','330',2560.22,2560.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','252841',4823974,'2143','330',2236990.69,2239853.90,0.00,0.00,2863.21,1559773.80,0.00,0.00,0.00),('1','139','772','252841',4823975,'2186','330',2560.22,2560.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','252986',4826276,'2143','330',2239853.90,2246052.72,0.00,0.00,6198.82,3366531.60,0.00,0.00,0.00),('1','139','772','252986',4826277,'2186','330',2560.22,2560.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','253227',4830378,'2143','330',2246052.72,2255229.28,0.00,0.00,9176.56,4939436.80,0.00,0.00,0.00),('1','139','772','253227',4830379,'2186','330',2560.22,2565.39,0.00,0.00,5.17,2998.60,0.00,0.00,0.00),('1','139','772','253495',4834942,'2143','330',2255229.28,2259716.72,0.00,0.00,4487.44,2439947.20,0.00,0.00,0.00),('1','139','772','253495',4834943,'2186','330',2565.39,2565.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','253730',4838901,'2143','330',2259716.72,2261443.22,0.00,0.00,1726.50,939734.00,0.00,0.00,0.00),('1','139','772','253730',4838902,'2186','330',2565.39,2565.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','253896',4842236,'2143','330',2261443.22,2261443.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','253896',4842237,'2186','330',2565.39,2565.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','254005',4843675,'2143','330',2261443.22,2264812.39,0.00,0.00,3369.17,1943803.94,0.00,0.00,0.00),('1','139','772','254005',4843676,'2186','330',2565.39,2568.39,0.00,0.00,3.00,1824.00,0.00,0.00,0.00),('1','139','772','254228',4847770,'2143','330',2264812.39,2269177.16,0.00,0.00,4364.77,2511412.34,0.00,0.00,0.00),('1','139','772','254228',4847771,'2186','330',2568.39,2568.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','254464',4851822,'2143','330',2269177.16,2274700.59,0.00,0.00,5523.43,3162982.44,0.00,0.00,0.00),('1','139','772','254464',4851823,'2186','330',2568.39,2568.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','254718',4856249,'2143','330',2274700.59,2278202.79,0.00,0.00,3502.20,2020392.60,0.00,0.00,0.00),('1','139','772','254718',4856250,'2186','330',2568.39,2568.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','254969',4860544,'2143','330',2278202.79,2281191.03,0.00,0.00,2988.24,1725626.32,0.00,0.00,0.00),('1','139','772','254969',4860545,'2186','330',2568.39,2568.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','255199',4864548,'2143','330',2281191.03,2284896.22,0.00,0.00,3705.19,2143689.92,0.00,0.00,0.00),('1','139','772','255199',4864549,'2186','330',2568.39,2568.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','255491',4869422,'2143','330',2284896.22,2286135.93,0.00,0.00,1239.71,712812.68,0.00,0.00,0.00),('1','139','772','255491',4869423,'2186','330',2568.39,2568.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','255555',4870390,'2143','330',2286135.93,2286135.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','255555',4870391,'2186','330',2568.39,2568.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','255564',4870614,'2143','330',2286135.93,2288403.76,0.00,0.00,2267.83,1248001.40,0.00,0.00,0.00),('1','139','772','255564',4870615,'2186','330',2568.39,2568.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','255720',4873327,'2143','330',2288403.76,2290996.39,0.00,0.00,2592.63,1428445.40,0.00,0.00,0.00),('1','139','772','255720',4873328,'2186','330',2568.39,2573.56,0.00,0.00,5.17,2998.60,0.00,0.00,0.00),('1','139','772','255966',4877242,'2143','330',2290996.39,2295438.45,0.00,0.00,4442.06,2416394.80,0.00,0.00,0.00),('1','139','772','255966',4877243,'2186','330',2573.56,2573.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','256231',4881445,'2143','330',2295438.45,2299486.24,0.00,0.00,4047.79,2209477.80,0.00,0.00,0.00),('1','139','772','256231',4881446,'2186','330',2573.56,2573.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','256503',4886248,'2143','330',2299486.24,2306517.89,0.00,0.00,7031.65,3785410.60,0.00,0.00,0.00),('1','139','772','256503',4886249,'2186','330',2573.56,2573.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','256738',4890083,'2143','330',2306517.89,2310684.93,0.00,0.00,4167.04,2269360.40,0.00,0.00,0.00),('1','139','772','256738',4890084,'2186','330',2573.56,2573.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','256905',4893236,'2143','330',2310684.93,2310684.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','256905',4893237,'2186','330',2573.56,2573.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','256985',4894377,'2143','330',2310684.93,2319045.48,0.00,0.00,8360.55,4487979.00,0.00,0.00,0.00),('1','139','772','256985',4894378,'2186','330',2573.56,2573.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257292',4899973,'2143','330',2319045.48,2324007.25,0.00,0.00,4961.77,2695830.60,0.00,0.00,0.00),('1','139','772','257292',4899974,'2186','330',2573.56,2573.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257505',4903666,'2143','330',2324007.25,2328051.32,0.00,0.00,4044.07,2211558.20,0.00,0.00,0.00),('1','139','772','257505',4903667,'2186','330',2573.56,2573.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257506',4903668,'2143','330',2328051.32,2331992.18,0.00,0.00,3940.86,2155058.80,0.00,0.00,0.00),('1','139','772','257506',4903669,'2186','330',2573.56,2573.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257507',4903670,'2143','330',2331992.18,2335301.69,0.00,0.00,3309.51,1819615.80,0.00,0.00,0.00),('1','139','772','257507',4903671,'2186','330',2573.56,2573.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257508',4903672,'2143','330',2335301.69,2335301.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257508',4903673,'2186','330',2573.56,2573.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257509',4903674,'2143','330',2335301.69,2337067.88,0.00,0.00,1766.19,925226.40,0.00,0.00,0.00),('1','139','772','257509',4903675,'2186','330',2573.56,2573.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257510',4903676,'2143','330',2337067.88,2345849.21,0.00,0.00,8781.33,4587920.80,0.00,0.00,0.00),('1','139','772','257510',4903677,'2186','330',2573.56,2573.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257511',4903678,'2143','330',2345849.21,2348697.00,0.00,0.00,2847.79,1520634.40,0.00,0.00,0.00),('1','139','772','257511',4903679,'2186','330',2573.56,2573.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257512',4903680,'2143','330',2348697.00,2355357.45,0.00,0.00,6660.45,3486300.00,0.00,0.00,0.00),('1','139','772','257512',4903681,'2186','330',2573.56,2573.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257513',4903682,'2143','330',2355357.45,2359978.29,0.00,0.00,4620.84,2422690.40,0.00,0.00,0.00),('1','139','772','257513',4903683,'2186','330',2573.56,2573.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257514',4903684,'2143','330',2359978.29,2359978.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257514',4903685,'2186','330',2573.56,2573.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257515',4903686,'2143','330',2359978.29,2366143.89,0.00,0.00,6165.60,3221156.00,0.00,0.00,0.00),('1','139','772','257515',4903687,'2186','330',2573.56,2573.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257516',4903688,'2143','330',2366143.89,2368852.48,0.00,0.00,2708.59,1439878.40,0.00,0.00,0.00),('1','139','772','257516',4903689,'2186','330',2573.56,2573.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257517',4903690,'2143','330',2368852.48,2372613.47,0.00,0.00,3760.99,1979898.40,0.00,0.00,0.00),('1','139','772','257517',4903691,'2186','330',2573.56,2573.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257518',4903692,'2143','330',2372613.47,2377065.15,0.00,0.00,4451.68,2340180.80,0.00,0.00,0.00),('1','139','772','257518',4903693,'2186','330',2573.56,2573.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257519',4903694,'2143','330',2377065.15,2380090.20,0.00,0.00,3025.05,1604988.00,0.00,0.00,0.00),('1','139','772','257519',4903695,'2186','330',2573.56,2576.24,0.00,0.00,2.68,1500.80,0.00,0.00,0.00),('1','139','772','257520',4903696,'2143','330',2380090.20,2383438.67,0.00,0.00,3348.47,1775515.20,0.00,0.00,0.00),('1','139','772','257520',4903697,'2186','330',2576.24,2576.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257521',4903698,'2143','330',2383438.67,2385531.19,0.00,0.00,2092.52,1100291.20,0.00,0.00,0.00),('1','139','772','257521',4903699,'2186','330',2576.24,2576.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257522',4903700,'2143','330',2385531.19,2385531.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257522',4903701,'2186','330',2576.24,2576.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257523',4903702,'2143','330',2385531.19,2386528.16,0.00,0.00,996.97,530014.72,0.00,0.00,0.00),('1','139','772','257523',4903703,'2186','330',2576.24,2576.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257524',4903704,'2143','330',2386528.16,2390696.87,0.00,0.00,4168.71,2251605.56,0.00,0.00,0.00),('1','139','772','257524',4903705,'2186','330',2576.24,2576.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257525',4903706,'2143','330',2390696.87,2393197.83,0.00,0.00,2500.96,1360476.96,0.00,0.00,0.00),('1','139','772','257525',4903707,'2186','330',2576.24,2576.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257526',4903708,'2143','330',2393197.83,2396281.71,0.00,0.00,3083.88,1671028.46,0.00,0.00,0.00),('1','139','772','257526',4903709,'2186','330',2576.24,2577.98,0.00,0.00,1.74,1002.24,0.00,0.00,0.00),('1','139','772','257527',4903710,'2143','330',2396281.71,2399307.98,0.00,0.00,3026.27,1648955.52,0.00,0.00,0.00),('1','139','772','257527',4903711,'2186','330',2577.98,2577.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257528',4903712,'2143','330',2399307.98,2401964.17,0.00,0.00,2656.19,1446342.44,0.00,0.00,0.00),('1','139','772','257528',4903713,'2186','330',2577.98,2577.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257529',4903714,'2143','330',2401964.17,2405073.33,0.00,0.00,3109.16,1684677.44,0.00,0.00,0.00),('1','139','772','257529',4903715,'2186','330',2577.98,2577.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257530',4903716,'2143','330',2405073.33,2408772.38,0.00,0.00,3699.05,1995638.80,0.00,0.00,0.00),('1','139','772','257530',4903717,'2186','330',2577.98,2577.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257531',4903718,'2143','330',2408772.38,2409960.73,0.00,0.00,1188.35,637669.60,0.00,0.00,0.00),('1','139','772','257531',4903719,'2186','330',2577.98,2577.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257532',4903720,'2143','330',2409960.73,2409960.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257532',4903721,'2186','330',2577.98,2577.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257533',4903722,'2143','330',2409960.73,2412648.75,0.00,0.00,2688.02,1475208.00,0.00,0.00,0.00),('1','139','772','257533',4903723,'2186','330',2577.98,2577.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257534',4903724,'2143','330',2412648.75,2414356.49,0.00,0.00,1707.74,943019.60,0.00,0.00,0.00),('1','139','772','257534',4903725,'2186','330',2577.98,2577.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257535',4903726,'2143','330',2414356.49,2416708.60,0.00,0.00,2352.11,1293991.80,0.00,0.00,0.00),('1','139','772','257535',4903727,'2186','330',2577.98,2577.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257536',4903728,'2143','330',2416708.60,2418486.91,0.00,0.00,1778.31,990939.80,0.00,0.00,0.00),('1','139','772','257536',4903729,'2186','330',2577.98,2581.48,0.00,0.00,3.50,2030.00,0.00,0.00,0.00),('1','139','772','257537',4903730,'2143','330',2418486.91,2420465.03,0.00,0.00,1978.12,1099709.60,0.00,0.00,0.00),('1','139','772','257537',4903731,'2186','330',2581.48,2581.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257538',4903732,'2143','330',2420465.03,2424763.43,0.00,0.00,4298.40,2346572.00,0.00,0.00,0.00),('1','139','772','257538',4903733,'2186','330',2581.48,2581.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257539',4903734,'2143','330',2424763.43,2429796.17,0.00,0.00,5032.74,2733718.80,0.00,0.00,0.00),('1','139','772','257539',4903735,'2186','330',2581.48,2581.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257540',4903736,'2143','330',2429796.17,2431766.46,0.00,0.00,1970.29,1087548.20,0.00,0.00,0.00),('1','139','772','257540',4903737,'2186','330',2581.48,2581.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257541',4903738,'2143','330',2431766.46,2434416.46,0.00,0.00,2650.00,1439480.00,0.00,0.00,0.00),('1','139','772','257541',4903739,'2186','330',2581.48,2581.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257542',4903740,'2143','330',2434416.46,2434416.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257542',4903741,'2186','330',2581.48,2581.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257543',4903742,'2143','330',2434416.46,2435197.28,0.00,0.00,780.82,434435.60,0.00,0.00,0.00),('1','139','772','257543',4903743,'2186','330',2581.48,2581.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257544',4903744,'2143','330',2435197.28,2439186.14,0.00,0.00,3988.86,2179398.80,0.00,0.00,0.00),('1','139','772','257544',4903745,'2186','330',2581.48,2581.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257545',4903746,'2143','330',2439186.14,2442340.65,0.00,0.00,3154.51,1730375.80,0.00,0.00,0.00),('1','139','772','257545',4903747,'2186','330',2581.48,2581.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257546',4903748,'2143','330',2442340.65,2446137.20,0.00,0.00,3796.55,2071759.00,0.00,0.00,0.00),('1','139','772','257546',4903749,'2186','330',2581.48,2581.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257547',4903750,'2143','330',2446137.20,2448702.29,0.00,0.00,2565.09,1414412.20,0.00,0.00,0.00),('1','139','772','257547',4903751,'2186','330',2581.48,2581.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257548',4903752,'2143','330',2448702.29,2453211.74,0.00,0.00,4509.45,2462781.00,0.00,0.00,0.00),('1','139','772','257548',4903753,'2186','330',2581.48,2581.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257549',4903754,'2143','330',2453211.74,2456119.69,0.00,0.00,2907.95,1677948.00,0.00,0.00,0.00),('1','139','772','257549',4903755,'2186','330',2581.48,2581.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257550',4903756,'2143','330',2456119.69,2458115.24,0.00,0.00,1995.55,1247452.00,0.00,0.00,0.00),('1','139','772','257550',4903757,'2186','330',2581.48,2583.82,0.00,0.00,2.34,1497.60,0.00,0.00,0.00),('1','139','772','257551',4903758,'2143','330',2458115.24,2458927.46,0.00,0.00,812.22,507710.80,0.00,0.00,0.00),('1','139','772','257551',4903759,'2186','330',2583.82,2583.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257552',4903760,'2143','330',2458927.46,2458927.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257552',4903761,'2186','330',2583.82,2583.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257553',4903762,'2143','330',2458927.46,2462603.26,0.00,0.00,3675.80,2280792.00,0.00,0.00,0.00),('1','139','772','257553',4903763,'2186','330',2583.82,2583.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257554',4903764,'2143','330',2462603.26,2465259.61,0.00,0.00,2656.35,1659984.00,0.00,0.00,0.00),('1','139','772','257554',4903765,'2186','330',2583.82,2583.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257555',4903766,'2143','330',2465259.61,2470361.49,0.00,0.00,5101.88,3264808.40,0.00,0.00,0.00),('1','139','772','257555',4903767,'2186','330',2583.82,2586.76,0.00,0.00,2.94,1999.20,0.00,0.00,0.00),('1','139','772','257556',4903768,'2143','330',2470361.49,2473150.11,0.00,0.00,2788.62,1803353.60,0.00,0.00,0.00),('1','139','772','257556',4903769,'2186','330',2586.76,2586.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257557',4903770,'2143','330',2473150.11,2476925.75,0.00,0.00,3775.64,2434235.20,0.00,0.00,0.00),('1','139','772','257557',4903771,'2186','330',2586.76,2586.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257558',4903772,'2143','330',2476925.75,2479758.61,0.00,0.00,2832.86,1833232.80,0.00,0.00,0.00),('1','139','772','257558',4903773,'2186','330',2586.76,2586.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257559',4903774,'2143','330',2479758.61,2483603.93,0.00,0.00,3845.32,2464267.60,0.00,0.00,0.00),('1','139','772','257559',4903775,'2186','330',2586.76,2586.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257560',4903776,'2143','330',2483603.93,2483603.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257560',4903777,'2186','330',2586.76,2586.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257561',4903778,'2143','330',2483603.93,2485394.74,0.00,0.00,1790.81,1140614.60,0.00,0.00,0.00),('1','139','772','257561',4903779,'2186','330',2586.76,2586.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257562',4903780,'2143','330',2485394.74,2489109.42,0.00,0.00,3714.68,2330728.80,0.00,0.00,0.00),('1','139','772','257562',4903781,'2186','330',2586.76,2586.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257563',4903782,'2143','330',2489109.42,2491643.28,0.00,0.00,2533.86,1596387.60,0.00,0.00,0.00),('1','139','772','257563',4903783,'2186','330',2586.76,2586.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257564',4903784,'2143','330',2491643.28,2494334.72,0.00,0.00,2691.44,1696550.40,0.00,0.00,0.00),('1','139','772','257564',4903785,'2186','330',2586.76,2586.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257565',4903786,'2143','330',2494334.72,2497394.55,0.00,0.00,3059.83,1911587.80,0.00,0.00,0.00),('1','139','772','257565',4903787,'2186','330',2586.76,2586.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257566',4903788,'2143','330',2497394.55,2500901.34,0.00,0.00,3506.79,2198309.40,0.00,0.00,0.00),('1','139','772','257566',4903789,'2186','330',2586.76,2586.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257567',4903790,'2143','330',2500901.34,2502185.68,0.00,0.00,1284.34,822944.40,0.00,0.00,0.00),('1','139','772','257567',4903791,'2186','330',2586.76,2586.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257568',4903792,'2143','330',2502185.68,2504285.22,0.00,0.00,2099.54,1354252.20,0.00,0.00,0.00),('1','139','772','257568',4903793,'2186','330',2586.76,2586.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257569',4903794,'2143','330',2504285.22,2508331.45,0.00,0.00,4046.23,2562006.40,0.00,0.00,0.00),('1','139','772','257569',4903795,'2186','330',2586.76,2586.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257570',4903796,'2143','330',2508331.45,2508331.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257570',4903797,'2186','330',2586.76,2586.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257571',4903798,'2143','330',2508331.45,2511419.17,0.00,0.00,3087.72,1973179.60,0.00,0.00,0.00),('1','139','772','257571',4903799,'2186','330',2586.76,2586.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257572',4903800,'2143','330',2511419.17,2514647.37,0.00,0.00,3228.20,2056371.00,0.00,0.00,0.00),('1','139','772','257572',4903801,'2186','330',2586.76,2596.76,0.00,0.00,10.00,6800.00,0.00,0.00,0.00),('1','139','772','257573',4903802,'2143','330',2514647.37,2517124.69,0.00,0.00,2477.32,1593507.60,0.00,0.00,0.00),('1','139','772','257573',4903803,'2186','330',2596.76,2596.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257574',4903804,'2143','330',2517124.69,2522573.33,0.00,0.00,5448.64,3474420.20,0.00,0.00,0.00),('1','139','772','257574',4903805,'2186','330',2596.76,2596.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257575',4903806,'2143','330',2522573.33,2527798.32,0.00,0.00,5224.99,3352968.20,0.00,0.00,0.00),('1','139','772','257575',4903807,'2186','330',2596.76,2596.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257576',4903808,'2143','330',2527798.32,2529827.03,0.00,0.00,2028.71,1321212.80,0.00,0.00,0.00),('1','139','772','257576',4903809,'2186','330',2596.76,2596.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257577',4903810,'2143','330',2529827.03,2532981.79,0.00,0.00,3154.76,1985126.80,0.00,0.00,0.00),('1','139','772','257577',4903811,'2186','330',2596.76,2596.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257578',4903812,'2143','330',2532981.79,2532981.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257578',4903813,'2186','330',2596.76,2596.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257579',4903814,'2143','330',2532981.79,2534307.36,0.00,0.00,1325.57,857522.60,0.00,0.00,0.00),('1','139','772','257579',4903815,'2186','330',2596.76,2596.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257580',4903816,'2143','330',2534307.36,2537772.22,0.00,0.00,3464.86,2230514.80,0.00,0.00,0.00),('1','139','772','257580',4903817,'2186','330',2596.76,2596.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257581',4903818,'2143','330',2537772.22,2541703.21,0.00,0.00,3930.99,2510223.20,0.00,0.00,0.00),('1','139','772','257581',4903819,'2186','330',2596.76,2596.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257582',4903820,'2143','330',2541703.21,2546299.84,0.00,0.00,4596.63,2926723.40,0.00,0.00,0.00),('1','139','772','257582',4903821,'2186','330',2596.76,2596.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257583',4903822,'2143','330',2546299.84,2549409.71,0.00,0.00,3109.87,1994951.60,0.00,0.00,0.00),('1','139','772','257583',4903823,'2186','330',2596.76,2596.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257584',4903824,'2143','330',2549409.71,2553649.03,0.00,0.00,4239.32,2726547.60,0.00,0.00,0.00),('1','139','772','257584',4903825,'2186','330',2596.76,2602.76,0.00,0.00,6.00,4080.00,0.00,0.00,0.00),('1','139','772','257585',4903826,'2143','330',2553649.03,2557598.71,0.00,0.00,3949.68,2505917.40,0.00,0.00,0.00),('1','139','772','257585',4903827,'2186','330',2602.76,2602.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257586',4903828,'2143','330',2557598.71,2557598.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257586',4903829,'2186','330',2602.76,2602.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257587',4903830,'2143','330',2557598.71,2563375.98,0.00,0.00,5777.27,3654588.60,0.00,0.00,0.00),('1','139','772','257587',4903831,'2186','330',2602.76,2602.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257588',4903832,'2143','330',2563375.98,2566113.34,0.00,0.00,2737.36,1756354.80,0.00,0.00,0.00),('1','139','772','257588',4903833,'2186','330',2602.76,2602.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257589',4903834,'2143','330',2566113.34,2568130.54,0.00,0.00,2017.20,1302661.00,0.00,0.00,0.00),('1','139','772','257589',4903835,'2186','330',2602.76,2604.97,0.00,0.00,2.21,1502.80,0.00,0.00,0.00),('1','139','772','257590',4903836,'2143','330',2568130.54,2572677.68,0.00,0.00,4547.14,2907530.20,0.00,0.00,0.00),('1','139','772','257590',4903837,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257591',4903838,'2143','330',2572677.68,2576111.00,0.00,0.00,3433.32,2192037.60,0.00,0.00,0.00),('1','139','772','257591',4903839,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257592',4903840,'2143','330',2576111.00,2578598.90,0.00,0.00,2487.90,1601002.00,0.00,0.00,0.00),('1','139','772','257592',4903841,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257593',4903842,'2143','330',2578598.90,2582237.74,0.00,0.00,3638.84,2302561.20,0.00,0.00,0.00),('1','139','772','257593',4903843,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257594',4903844,'2143','330',2582237.74,2582237.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257594',4903845,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257595',4903846,'2143','330',2582237.74,2585396.43,0.00,0.00,3158.69,1967934.80,0.00,0.00,0.00),('1','139','772','257595',4903847,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257596',4903848,'2143','330',2585396.43,2587131.12,0.00,0.00,1734.69,1089188.50,0.00,0.00,0.00),('1','139','772','257596',4903849,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257597',4903850,'2143','330',2587131.12,2591491.22,0.00,0.00,4360.10,2696065.00,0.00,0.00,0.00),('1','139','772','257597',4903851,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257598',4903852,'2143','330',2591491.22,2593701.22,0.00,0.00,2210.00,1374833.00,0.00,0.00,0.00),('1','139','772','257598',4903853,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257599',4903854,'2143','330',2593701.22,2595364.47,0.00,0.00,1663.25,1049017.50,0.00,0.00,0.00),('1','139','772','257599',4903855,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257600',4903856,'2143','330',2595364.47,2597804.97,0.00,0.00,2440.50,1538130.00,0.00,0.00,0.00),('1','139','772','257600',4903857,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257601',4903858,'2143','330',2597804.97,2603498.59,0.00,0.00,5693.62,3499181.00,0.00,0.00,0.00),('1','139','772','257601',4903859,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257602',4903860,'2143','330',2603498.59,2606944.39,0.00,0.00,3445.80,2123678.00,0.00,0.00,0.00),('1','139','772','257602',4903861,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257603',4903862,'2143','330',2606944.39,2606944.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257603',4903863,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257604',4903864,'2143','330',2606944.39,2606944.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257604',4903865,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257605',4903866,'2143','330',2606944.39,2610939.63,0.00,0.00,3995.24,2475116.00,0.00,0.00,0.00),('1','139','772','257605',4903867,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257606',4903868,'2143','330',2610939.63,2612764.51,0.00,0.00,1824.88,1150909.50,0.00,0.00,0.00),('1','139','772','257606',4903869,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257607',4903870,'2143','330',2612764.51,2617174.21,0.00,0.00,4409.70,2738545.00,0.00,0.00,0.00),('1','139','772','257607',4903871,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257608',4903872,'2143','330',2617174.21,2622224.25,0.00,0.00,5050.04,3150553.50,0.00,0.00,0.00),('1','139','772','257608',4903873,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257609',4903874,'2143','330',2622224.25,2624770.75,0.00,0.00,2546.50,1580564.50,0.00,0.00,0.00),('1','139','772','257609',4903875,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257610',4903876,'2143','330',2624770.75,2625872.05,0.00,0.00,1101.30,692380.00,0.00,0.00,0.00),('1','139','772','257610',4903877,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257611',4903878,'2143','330',2625872.05,2628606.95,0.00,0.00,2734.90,1692403.00,0.00,0.00,0.00),('1','139','772','257611',4903879,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257612',4903880,'2143','330',2628606.95,2631711.45,0.00,0.00,3104.50,1915610.50,0.00,0.00,0.00),('1','139','772','257612',4903881,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257613',4903882,'2143','330',2631711.45,2631711.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257613',4903883,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257614',4903884,'2143','330',2631711.45,2635453.79,0.00,0.00,3742.34,2311968.50,0.00,0.00,0.00),('1','139','772','257614',4903885,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257615',4903886,'2143','330',2635453.79,2637897.73,0.00,0.00,2443.94,1530336.00,0.00,0.00,0.00),('1','139','772','257615',4903887,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257616',4903888,'2143','330',2637897.73,2643123.74,0.00,0.00,5226.01,3234176.00,0.00,0.00,0.00),('1','139','772','257616',4903889,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257617',4903890,'2143','330',2643123.74,2647367.88,0.00,0.00,4244.14,2642081.00,0.00,0.00,0.00),('1','139','772','257617',4903891,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257618',4903892,'2143','330',2647367.88,2649639.32,0.00,0.00,2271.44,1432430.00,0.00,0.00,0.00),('1','139','772','257618',4903893,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257619',4903894,'2143','330',2649639.32,2653506.37,0.00,0.00,3867.05,2401206.50,0.00,0.00,0.00),('1','139','772','257619',4903895,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257620',4903896,'2143','330',2653506.37,2656348.79,0.00,0.00,2842.42,1766371.00,0.00,0.00,0.00),('1','139','772','257620',4903897,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257621',4903898,'2143','330',2656348.79,2656348.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257621',4903899,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257622',4903900,'2143','330',2656348.79,2665159.72,0.00,0.00,8810.93,5540547.40,0.00,0.00,0.00),('1','139','772','257622',4903901,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257623',4903902,'2143','330',2665159.72,2671980.79,0.00,0.00,6821.07,4329337.60,0.00,0.00,0.00),('1','139','772','257623',4903903,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257624',4903904,'2143','330',2671980.79,2677509.29,0.00,0.00,5528.50,3549135.00,0.00,0.00,0.00),('1','139','772','257624',4903905,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257625',4903906,'2143','330',2677509.29,2678983.92,0.00,0.00,1474.63,969843.40,0.00,0.00,0.00),('1','139','772','257625',4903907,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257626',4903908,'2143','330',2678983.92,2680931.95,0.00,0.00,1948.03,1234631.05,0.00,0.00,0.00),('1','139','772','257626',4903909,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257627',4903910,'2143','330',2680931.95,2680931.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257627',4903911,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257628',4903912,'2143','330',2680931.95,2691290.83,0.00,0.00,10358.88,7096304.90,0.00,0.00,0.00),('1','139','772','257628',4903913,'2186','330',2604.97,2604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257629',4903914,'2143','330',2691290.83,2696016.19,0.00,0.00,4725.36,3290112.80,0.00,0.00,0.00),('1','139','772','257629',4903915,'2186','330',2604.97,2616.97,0.00,0.00,12.00,8760.00,0.00,0.00,0.00),('1','139','772','257630',4903916,'2143','330',2696016.19,2698297.01,0.00,0.00,2280.82,1605348.60,0.00,0.00,0.00),('1','139','772','257630',4903917,'2186','330',2616.97,2618.97,0.00,0.00,2.00,1460.00,0.00,0.00,0.00),('1','139','772','257631',4903918,'2143','330',2698297.01,2700110.78,0.00,0.00,1813.77,1300202.10,0.00,0.00,0.00),('1','139','772','257631',4903919,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257632',4903920,'2143','330',2700110.78,2702911.41,0.00,0.00,2800.63,1946459.90,0.00,0.00,0.00),('1','139','772','257632',4903921,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257633',4903922,'2143','330',2702911.41,2703793.45,0.00,0.00,882.04,643889.20,0.00,0.00,0.00),('1','139','772','257633',4903923,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257634',4903924,'2143','330',2703793.45,2705645.09,0.00,0.00,1851.64,1274697.20,0.00,0.00,0.00),('1','139','772','257634',4903925,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257635',4903926,'2143','330',2705645.09,2706599.73,0.00,0.00,954.64,689267.20,0.00,0.00,0.00),('1','139','772','257635',4903927,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257636',4903928,'2143','330',2706599.73,2709858.33,0.00,0.00,3258.60,2301118.00,0.00,0.00,0.00),('1','139','772','257636',4903929,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257637',4903930,'2143','330',2709858.33,2713459.92,0.00,0.00,3601.59,2533660.70,0.00,0.00,0.00),('1','139','772','257637',4903931,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257638',4903932,'2143','330',2713459.92,2715979.10,0.00,0.00,2519.18,1796386.40,0.00,0.00,0.00),('1','139','772','257638',4903933,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257639',4903934,'2143','330',2715979.10,2722467.37,0.00,0.00,6488.27,4543321.10,0.00,0.00,0.00),('1','139','772','257639',4903935,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257640',4903936,'2143','330',2722467.37,2725350.14,0.00,0.00,2882.77,2038057.10,0.00,0.00,0.00),('1','139','772','257640',4903937,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257641',4903938,'2143','330',2725350.14,2728276.99,0.00,0.00,2926.85,2060535.50,0.00,0.00,0.00),('1','139','772','257641',4903939,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257642',4903940,'2143','330',2728276.99,2730237.69,0.00,0.00,1960.70,1371311.00,0.00,0.00,0.00),('1','139','772','257642',4903941,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257643',4903942,'2143','330',2730237.69,2730237.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257643',4903943,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257644',4903944,'2143','330',2730237.69,2732828.52,0.00,0.00,2590.83,1910050.10,0.00,0.00,0.00),('1','139','772','257644',4903945,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257645',4903946,'2143','330',2732828.52,2737420.44,0.00,0.00,4591.92,3374258.40,0.00,0.00,0.00),('1','139','772','257645',4903947,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257646',4903948,'2143','330',2737420.44,2741952.06,0.00,0.00,4531.62,3342087.40,0.00,0.00,0.00),('1','139','772','257646',4903949,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257647',4903950,'2143','330',2741952.06,2745355.08,0.00,0.00,3403.02,2513830.40,0.00,0.00,0.00),('1','139','772','257647',4903951,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257648',4903952,'2143','330',2745355.08,2749970.46,0.00,0.00,4615.38,3413762.60,0.00,0.00,0.00),('1','139','772','257648',4903953,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257649',4903954,'2143','330',2749970.46,2751398.60,0.00,0.00,1428.14,1073827.80,0.00,0.00,0.00),('1','139','772','257649',4903955,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257650',4903956,'2143','330',2751398.60,2754947.49,0.00,0.00,3548.89,2567245.30,0.00,0.00,0.00),('1','139','772','257650',4903957,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257651',4903958,'2143','330',2754947.49,2754947.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257651',4903959,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257652',4903960,'2143','330',2754947.49,2755843.06,0.00,0.00,895.57,669908.90,0.00,0.00,0.00),('1','139','772','257652',4903961,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257653',4903962,'2143','330',2755843.06,2757180.27,0.00,0.00,1337.21,1009663.70,0.00,0.00,0.00),('1','139','772','257653',4903963,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257654',4903964,'2143','330',2757180.27,2758571.39,0.00,0.00,1391.12,1044122.40,0.00,0.00,0.00),('1','139','772','257654',4903965,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257655',4903966,'2143','330',2758571.39,2760925.63,0.00,0.00,2354.24,1753624.80,0.00,0.00,0.00),('1','139','772','257655',4903967,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257656',4903968,'2143','330',2760925.63,2763450.96,0.00,0.00,2525.33,1868104.10,0.00,0.00,0.00),('1','139','772','257656',4903969,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257657',4903970,'2143','330',2763450.96,2766162.12,0.00,0.00,2711.16,2008793.20,0.00,0.00,0.00),('1','139','772','257657',4903971,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257658',4903972,'2143','330',2766162.12,2769569.68,0.00,0.00,3407.56,2519996.20,0.00,0.00,0.00),('1','139','772','257658',4903973,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257659',4903974,'2143','330',2769569.68,2773668.44,0.00,0.00,4098.76,3017225.20,0.00,0.00,0.00),('1','139','772','257659',4903975,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257660',4903976,'2143','330',2773668.44,2777032.84,0.00,0.00,3364.40,2482958.00,0.00,0.00,0.00),('1','139','772','257660',4903977,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257661',4903978,'2143','330',2777032.84,2779569.17,0.00,0.00,2536.33,1867774.10,0.00,0.00,0.00),('1','139','772','257661',4903979,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257662',4903980,'2143','330',2779569.17,2779569.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257662',4903981,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257663',4903982,'2143','330',2779569.17,2781909.21,0.00,0.00,2340.04,1746030.80,0.00,0.00,0.00),('1','139','772','257663',4903983,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257664',4903984,'2143','330',2781909.21,2784083.52,0.00,0.00,2174.31,1621978.70,0.00,0.00,0.00),('1','139','772','257664',4903985,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257665',4903986,'2143','330',2784083.52,2787685.72,0.00,0.00,3602.20,2652934.00,0.00,0.00,0.00),('1','139','772','257665',4903987,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257666',4903988,'2143','330',2787685.72,2791485.49,0.00,0.00,3799.77,2796322.90,0.00,0.00,0.00),('1','139','772','257666',4903989,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257667',4903990,'2143','330',2791485.49,2793880.04,0.00,0.00,2394.55,1777803.50,0.00,0.00,0.00),('1','139','772','257667',4903991,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257668',4903992,'2143','330',2793880.04,2796684.06,0.00,0.00,2804.02,2071891.40,0.00,0.00,0.00),('1','139','772','257668',4903993,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257669',4903994,'2143','330',2796684.06,2799022.96,0.00,0.00,2338.90,1751493.00,0.00,0.00,0.00),('1','139','772','257669',4903995,'2186','330',2618.97,2618.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257670',4903996,'2143','330',2799022.96,2801844.32,0.00,0.00,2821.36,2112367.20,0.00,0.00,0.00),('1','139','772','257670',4903997,'2186','330',2618.97,2621.57,0.00,0.00,2.60,2002.00,0.00,0.00,0.00),('1','139','772','257671',4903998,'2143','330',2801844.32,2804234.57,0.00,0.00,2390.25,1759272.50,0.00,0.00,0.00),('1','139','772','257671',4903999,'2186','330',2621.57,2621.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257672',4904000,'2143','330',2804234.57,2804234.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257672',4904001,'2186','330',2621.57,2621.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257673',4904002,'2143','330',2804234.57,2804757.31,0.00,0.00,522.74,390509.80,0.00,0.00,0.00),('1','139','772','257673',4904003,'2186','330',2621.57,2621.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257674',4904004,'2143','330',2804757.31,2809535.52,0.00,0.00,4778.21,3513221.70,0.00,0.00,0.00),('1','139','772','257674',4904005,'2186','330',2621.57,2621.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257675',4904006,'2143','330',2809535.52,2813551.01,0.00,0.00,4015.49,2967267.30,0.00,0.00,0.00),('1','139','772','257675',4904007,'2186','330',2621.57,2621.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257676',4904008,'2143','330',2813551.01,2817266.35,0.00,0.00,3715.34,2745131.80,0.00,0.00,0.00),('1','139','772','257676',4904009,'2186','330',2621.57,2622.87,0.00,0.00,1.30,1001.00,0.00,0.00,0.00),('1','139','772','257677',4904010,'2143','330',2817266.35,2820618.84,0.00,0.00,3352.49,2478567.30,0.00,0.00,0.00),('1','139','772','257677',4904011,'2186','330',2622.87,2622.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257678',4904012,'2143','330',2820618.84,2824488.52,0.00,0.00,3869.68,2866633.60,0.00,0.00,0.00),('1','139','772','257678',4904013,'2186','330',2622.87,2622.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257679',4904014,'2143','330',2824488.52,2826167.83,0.00,0.00,1679.31,1243628.70,0.00,0.00,0.00),('1','139','772','257679',4904015,'2186','330',2622.87,2622.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257680',4904016,'2143','330',2826167.83,2828916.57,0.00,0.00,2748.74,2032465.80,0.00,0.00,0.00),('1','139','772','257680',4904017,'2186','330',2622.87,2622.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257681',4904018,'2143','330',2828916.57,2828916.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257681',4904019,'2186','330',2622.87,2622.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257682',4904020,'2143','330',2828916.57,2830214.03,0.00,0.00,1297.46,974364.20,0.00,0.00,0.00),('1','139','772','257682',4904021,'2186','330',2622.87,2622.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257683',4904022,'2143','330',2830214.03,2833264.01,0.00,0.00,3049.98,2249484.60,0.00,0.00,0.00),('1','139','772','257683',4904023,'2186','330',2622.87,2622.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257684',4904024,'2143','330',2833264.01,2837534.02,0.00,0.00,4270.01,3140067.70,0.00,0.00,0.00),('1','139','772','257684',4904025,'2186','330',2622.87,2622.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257685',4904026,'2143','330',2837534.02,2839712.87,0.00,0.00,2178.85,1615226.50,0.00,0.00,0.00),('1','139','772','257685',4904027,'2186','330',2622.87,2622.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257686',4904028,'2143','330',2839712.87,2844465.12,0.00,0.00,4752.25,3483504.50,0.00,0.00,0.00),('1','139','772','257686',4904029,'2186','330',2622.87,2622.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257687',4904030,'2143','330',2844465.12,2847731.06,0.00,0.00,3265.94,2421553.80,0.00,0.00,0.00),('1','139','772','257687',4904031,'2186','330',2622.87,2622.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257688',4904032,'2143','330',2847731.06,2850843.60,0.00,0.00,3112.54,2299267.80,0.00,0.00,0.00),('1','139','772','257688',4904033,'2186','330',2622.87,2622.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257689',4904034,'2143','330',2850843.60,2853517.07,0.00,0.00,2673.47,1961943.90,0.00,0.00,0.00),('1','139','772','257689',4904035,'2186','330',2622.87,2622.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257690',4904036,'2143','330',2853517.07,2853517.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257690',4904037,'2186','330',2622.87,2622.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257691',4904038,'2143','330',2853517.07,2856324.34,0.00,0.00,2807.27,2048525.20,0.00,0.00,0.00),('1','139','772','257691',4904039,'2186','330',2622.87,2622.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257692',4904040,'2143','330',2856324.34,2858974.67,0.00,0.00,2650.33,1935170.80,0.00,0.00,0.00),('1','139','772','257692',4904041,'2186','330',2622.87,2622.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257693',4904042,'2143','330',2858974.67,2861008.32,0.00,0.00,2033.65,1502714.00,0.00,0.00,0.00),('1','139','772','257693',4904043,'2186','330',2622.87,2622.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257694',4904044,'2143','330',2861008.32,2862234.78,0.00,0.00,1226.46,906989.60,0.00,0.00,0.00),('1','139','772','257694',4904045,'2186','330',2622.87,2622.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257695',4904046,'2143','330',2862234.78,2866620.12,0.00,0.00,4385.34,3173030.40,0.00,0.00,0.00),('1','139','772','257695',4904047,'2186','330',2622.87,2622.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257696',4904048,'2143','330',2866620.12,2870175.62,0.00,0.00,3555.50,2576948.00,0.00,0.00,0.00),('1','139','772','257696',4904049,'2186','330',2622.87,2625.90,0.00,0.00,3.03,2302.80,0.00,0.00,0.00),('1','139','772','257697',4904050,'2143','330',2870175.62,2872306.92,0.00,0.00,2131.30,1559104.00,0.00,0.00,0.00),('1','139','772','257697',4904051,'2186','330',2625.90,2625.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257698',4904052,'2143','330',2872306.92,2876258.43,0.00,0.00,3951.51,2859947.60,0.00,0.00,0.00),('1','139','772','257698',4904053,'2186','330',2625.90,2625.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257699',4904054,'2143','330',2876258.43,2878162.62,0.00,0.00,1904.19,1379008.40,0.00,0.00,0.00),('1','139','772','257699',4904055,'2186','330',2625.90,2625.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257700',4904056,'2143','330',2878162.62,2878162.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257700',4904057,'2186','330',2625.90,2625.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257701',4904058,'2143','330',2878162.62,2884844.83,0.00,0.00,6682.21,4832371.60,0.00,0.00,0.00),('1','139','772','257701',4904059,'2186','330',2625.90,2625.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257702',4904060,'2143','330',2884844.83,2889478.60,0.00,0.00,4633.77,3361555.20,0.00,0.00,0.00),('1','139','772','257702',4904061,'2186','330',2625.90,2625.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257703',4904062,'2143','330',2889478.60,2894885.73,0.00,0.00,5407.13,3938263.80,0.00,0.00,0.00),('1','139','772','257703',4904063,'2186','330',2625.90,2628.90,0.00,0.00,3.00,2280.00,0.00,0.00,0.00),('1','139','772','257704',4904064,'2143','330',2894885.73,2899038.44,0.00,0.00,4152.71,3026729.60,0.00,0.00,0.00),('1','139','772','257704',4904065,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257705',4904066,'2143','330',2899038.44,2902854.66,0.00,0.00,3816.22,2769327.20,0.00,0.00,0.00),('1','139','772','257705',4904067,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257706',4904068,'2143','330',2902854.66,2902854.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257706',4904069,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257707',4904070,'2143','330',2902854.66,2906448.56,0.00,0.00,3593.90,2612484.00,0.00,0.00,0.00),('1','139','772','257707',4904071,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257708',4904072,'2143','330',2906448.56,2910201.80,0.00,0.00,3753.24,2735246.40,0.00,0.00,0.00),('1','139','772','257708',4904073,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257709',4904074,'2143','330',2910201.80,2912628.39,0.00,0.00,2426.59,1781608.40,0.00,0.00,0.00),('1','139','772','257709',4904075,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257710',4904076,'2143','330',2912628.39,2917245.28,0.00,0.00,4616.89,3347746.40,0.00,0.00,0.00),('1','139','772','257710',4904077,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257711',4904078,'2143','330',2917245.28,2921852.08,0.00,0.00,4606.80,3349256.00,0.00,0.00,0.00),('1','139','772','257711',4904079,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257712',4904080,'2143','330',2921852.08,2926489.50,0.00,0.00,4637.42,3364307.20,0.00,0.00,0.00),('1','139','772','257712',4904081,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257713',4904082,'2143','330',2926489.50,2927516.54,0.00,0.00,1027.04,748270.40,0.00,0.00,0.00),('1','139','772','257713',4904083,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257714',4904084,'2143','330',2927516.54,2927516.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257714',4904085,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257715',4904086,'2143','330',2927516.54,2927516.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257715',4904087,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257716',4904088,'2143','330',2927516.54,2928765.83,0.00,0.00,1249.29,917900.40,0.00,0.00,0.00),('1','139','772','257716',4904089,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257717',4904090,'2143','330',2928765.83,2933200.13,0.00,0.00,4434.30,3217301.00,0.00,0.00,0.00),('1','139','772','257717',4904091,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257718',4904092,'2143','330',2933200.13,2935708.40,0.00,0.00,2508.27,1838895.20,0.00,0.00,0.00),('1','139','772','257718',4904093,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257719',4904094,'2143','330',2935708.40,2938427.61,0.00,0.00,2719.21,1990467.60,0.00,0.00,0.00),('1','139','772','257719',4904095,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257720',4904096,'2143','330',2938427.61,2944250.88,0.00,0.00,5823.27,4213645.20,0.00,0.00,0.00),('1','139','772','257720',4904097,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257721',4904098,'2143','330',2944250.88,2946848.68,0.00,0.00,2597.80,1904528.00,0.00,0.00,0.00),('1','139','772','257721',4904099,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257722',4904100,'2143','330',2946848.68,2949864.45,0.00,0.00,3015.77,2198945.20,0.00,0.00,0.00),('1','139','772','257722',4904101,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257723',4904102,'2143','330',2949864.45,2952160.49,0.00,0.00,2296.04,1672780.40,0.00,0.00,0.00),('1','139','772','257723',4904103,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257724',4904104,'2143','330',2952160.49,2952160.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257724',4904105,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257725',4904106,'2143','330',2952160.49,2953123.11,0.00,0.00,962.62,699769.20,0.00,0.00,0.00),('1','139','772','257725',4904107,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257726',4904108,'2143','330',2953123.11,2956845.19,0.00,0.00,3722.08,2706736.80,0.00,0.00,0.00),('1','139','772','257726',4904109,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257727',4904110,'2143','330',2956845.19,2959347.59,0.00,0.00,2502.40,1822012.00,0.00,0.00,0.00),('1','139','772','257727',4904111,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257728',4904112,'2143','330',2959347.59,2962211.51,0.00,0.00,2863.92,2084323.20,0.00,0.00,0.00),('1','139','772','257728',4904113,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257729',4904114,'2143','330',2962211.51,2964868.59,0.00,0.00,2657.08,1950956.40,0.00,0.00,0.00),('1','139','772','257729',4904115,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257730',4904116,'2143','330',2964868.59,2967656.56,0.00,0.00,2787.97,2045897.20,0.00,0.00,0.00),('1','139','772','257730',4904117,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257731',4904118,'2143','330',2967656.56,2971762.31,0.00,0.00,4105.75,2990393.20,0.00,0.00,0.00),('1','139','772','257731',4904119,'2186','330',2628.90,2628.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257732',4904120,'2143','330',2971762.31,2975501.20,0.00,0.00,3738.89,2729056.40,0.00,0.00,0.00),('1','139','772','257732',4904121,'2186','330',2628.90,2634.90,0.00,0.00,6.00,4560.00,0.00,0.00,0.00),('1','139','772','257733',4904122,'2143','330',2975501.20,2976705.42,0.00,0.00,1204.22,885627.20,0.00,0.00,0.00),('1','139','772','257733',4904123,'2186','330',2634.90,2636.22,0.00,0.00,1.32,1003.20,0.00,0.00,0.00),('1','139','772','257734',4904124,'2143','330',2976705.42,2976705.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257734',4904125,'2186','330',2636.22,2636.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257735',4904126,'2143','330',2976705.42,2977333.58,0.00,0.00,628.16,459501.60,0.00,0.00,0.00),('1','139','772','257735',4904127,'2186','330',2636.22,2636.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257736',4904128,'2143','330',2977333.58,2980267.15,0.00,0.00,2933.57,2116286.70,0.00,0.00,0.00),('1','139','772','257736',4904129,'2186','330',2636.22,2636.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257737',4904130,'2143','330',2980267.15,2985931.03,0.00,0.00,5663.88,4063698.80,0.00,0.00,0.00),('1','139','772','257737',4904131,'2186','330',2636.22,2636.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257738',4904132,'2143','330',2985931.03,2991891.46,0.00,0.00,5960.43,4255726.80,0.00,0.00,0.00),('1','139','772','257738',4904133,'2186','330',2636.22,2636.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257739',4904134,'2143','330',2991891.46,2994592.76,0.00,0.00,2701.30,1964948.00,0.00,0.00,0.00),('1','139','772','257739',4904135,'2186','330',2636.22,2636.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257740',4904136,'2143','330',2994592.76,2996649.52,0.00,0.00,2056.76,1506262.60,0.00,0.00,0.00),('1','139','772','257740',4904137,'2186','330',2636.22,2636.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257741',4904138,'2143','330',2996649.52,3000504.23,0.00,0.00,3854.71,2777879.60,0.00,0.00,0.00),('1','139','772','257741',4904139,'2186','330',2636.22,2636.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257742',4904140,'2143','330',3000504.23,3001368.20,0.00,0.00,863.97,623442.20,0.00,0.00,0.00),('1','139','772','257742',4904141,'2186','330',2636.22,2636.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257743',4904142,'2143','330',3001368.20,3001368.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257743',4904143,'2186','330',2636.22,2636.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257744',4904144,'2143','330',3001368.20,3003604.00,0.00,0.00,2235.80,1612403.00,0.00,0.00,0.00),('1','139','772','257744',4904145,'2186','330',2636.22,2636.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257745',4904146,'2143','330',3003604.00,3006941.70,0.00,0.00,3337.70,2408022.00,0.00,0.00,0.00),('1','139','772','257745',4904147,'2186','330',2636.22,2636.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257746',4904148,'2143','330',3006941.70,3009583.49,0.00,0.00,2641.79,1914510.40,0.00,0.00,0.00),('1','139','772','257746',4904149,'2186','330',2636.22,2636.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257747',4904150,'2143','330',3009583.49,3013720.27,0.00,0.00,4136.78,2966552.80,0.00,0.00,0.00),('1','139','772','257747',4904151,'2186','330',2636.22,2636.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257748',4904152,'2143','330',3013720.27,3015911.30,0.00,0.00,2191.03,1595832.80,0.00,0.00,0.00),('1','139','772','257748',4904153,'2186','330',2636.22,2642.22,0.00,0.00,6.00,4560.00,0.00,0.00,0.00),('1','139','772','257749',4904154,'2143','330',3015911.30,3019142.43,0.00,0.00,3231.13,2326158.80,0.00,0.00,0.00),('1','139','772','257749',4904155,'2186','330',2642.22,2644.72,0.00,0.00,2.50,1900.00,0.00,0.00,0.00),('1','139','772','257750',4904156,'2143','330',3019142.43,3021257.04,0.00,0.00,2114.61,1551603.60,0.00,0.00,0.00),('1','139','772','257750',4904157,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257751',4904158,'2143','330',3021257.04,3024764.79,0.00,0.00,3507.75,2534465.00,0.00,0.00,0.00),('1','139','772','257751',4904159,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257752',4904160,'2143','330',3024764.79,3026063.14,0.00,0.00,1298.35,944896.00,0.00,0.00,0.00),('1','139','772','257752',4904161,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257753',4904162,'2143','330',3026063.14,3026063.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257753',4904163,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257754',4904164,'2143','330',3026063.14,3026719.08,0.00,0.00,655.94,483514.40,0.00,0.00,0.00),('1','139','772','257754',4904165,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257755',4904166,'2143','330',3026719.08,3030707.04,0.00,0.00,3987.96,2858974.60,0.00,0.00,0.00),('1','139','772','257755',4904167,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257756',4904168,'2143','330',3030707.04,3033839.85,0.00,0.00,3132.81,2256985.60,0.00,0.00,0.00),('1','139','772','257756',4904169,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257757',4904170,'2143','330',3033839.85,3036340.26,0.00,0.00,2500.41,1817061.60,0.00,0.00,0.00),('1','139','772','257757',4904171,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257758',4904172,'2143','330',3036340.26,3040630.94,0.00,0.00,4290.68,3086871.80,0.00,0.00,0.00),('1','139','772','257758',4904173,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257759',4904174,'2143','330',3040630.94,3044117.90,0.00,0.00,3486.96,2521339.60,0.00,0.00,0.00),('1','139','772','257759',4904175,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257760',4904176,'2143','330',3044117.90,3048138.17,0.00,0.00,4020.27,2886465.20,0.00,0.00,0.00),('1','139','772','257760',4904177,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257761',4904178,'2143','330',3048138.17,3050685.58,0.00,0.00,2547.41,1826862.85,0.00,0.00,0.00),('1','139','772','257761',4904179,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257762',4904180,'2143','330',3050685.58,3050685.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257762',4904181,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257763',4904182,'2143','330',3050685.58,3052714.93,0.00,0.00,2029.35,1475481.00,0.00,0.00,0.00),('1','139','772','257763',4904183,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257764',4904184,'2143','330',3052714.93,3057377.89,0.00,0.00,4662.96,3350849.60,0.00,0.00,0.00),('1','139','772','257764',4904185,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257765',4904186,'2143','330',3057377.89,3060422.76,0.00,0.00,3044.87,2191531.20,0.00,0.00,0.00),('1','139','772','257765',4904187,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257766',4904188,'2143','330',3060422.76,3062340.97,0.00,0.00,1918.21,1391689.60,0.00,0.00,0.00),('1','139','772','257766',4904189,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257767',4904190,'2143','330',3062340.97,3064984.10,0.00,0.00,2643.13,1902428.80,0.00,0.00,0.00),('1','139','772','257767',4904191,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257768',4904192,'2143','330',3064984.10,3069644.73,0.00,0.00,4660.63,3336478.80,0.00,0.00,0.00),('1','139','772','257768',4904193,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257769',4904194,'2143','330',3069644.73,3072102.81,0.00,0.00,2458.08,1778120.80,0.00,0.00,0.00),('1','139','772','257769',4904195,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257770',4904196,'2143','330',3072102.81,3075345.86,0.00,0.00,3243.05,2314233.00,0.00,0.00,0.00),('1','139','772','257770',4904197,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257771',4904198,'2143','330',3075345.86,3075345.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257771',4904199,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257772',4904200,'2143','330',3075345.86,3080453.88,0.00,0.00,5108.02,3620260.70,0.00,0.00,0.00),('1','139','772','257772',4904201,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257773',4904202,'2143','330',3080453.88,3083651.24,0.00,0.00,3197.36,2293591.10,0.00,0.00,0.00),('1','139','772','257773',4904203,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257774',4904204,'2143','330',3083651.24,3085986.33,0.00,0.00,2335.09,1690807.90,0.00,0.00,0.00),('1','139','772','257774',4904205,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257775',4904206,'2143','330',3085986.33,3090330.45,0.00,0.00,4344.12,3123026.20,0.00,0.00,0.00),('1','139','772','257775',4904207,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257776',4904208,'2143','330',3090330.45,3092789.43,0.00,0.00,2458.98,1793424.80,0.00,0.00,0.00),('1','139','772','257776',4904209,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257777',4904210,'2143','330',3092789.43,3096269.98,0.00,0.00,3480.55,2506682.50,0.00,0.00,0.00),('1','139','772','257777',4904211,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257778',4904212,'2143','330',3096269.98,3099056.86,0.00,0.00,2786.88,2014823.80,0.00,0.00,0.00),('1','139','772','257778',4904213,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257779',4904214,'2143','330',3099056.86,3100024.10,0.00,0.00,967.24,688272.40,0.00,0.00,0.00),('1','139','772','257779',4904215,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257780',4904216,'2143','330',3100024.10,3100024.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257780',4904217,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257781',4904218,'2143','330',3100024.10,3109492.50,0.00,0.00,9468.40,6690376.00,0.00,0.00,0.00),('1','139','772','257781',4904219,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257782',4904220,'2143','330',3109492.50,3116749.41,0.00,0.00,7256.91,5145862.60,0.00,0.00,0.00),('1','139','772','257782',4904221,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257783',4904222,'2143','330',3116749.41,3122951.91,0.00,0.00,6202.50,4410950.00,0.00,0.00,0.00),('1','139','772','257783',4904223,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257784',4904224,'2143','330',3122951.91,3124681.84,0.00,0.00,1729.93,1245636.80,0.00,0.00,0.00),('1','139','772','257784',4904225,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257785',4904226,'2143','330',3124681.84,3124681.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257785',4904227,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257786',4904228,'2143','330',3124681.84,3130261.58,0.00,0.00,5579.74,3959732.40,0.00,0.00,0.00),('1','139','772','257786',4904229,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257787',4904230,'2143','330',3130261.58,3137670.12,0.00,0.00,7408.54,5254685.40,0.00,0.00,0.00),('1','139','772','257787',4904231,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257788',4904232,'2143','330',3137670.12,3140806.14,0.00,0.00,3136.02,2273886.70,0.00,0.00,0.00),('1','139','772','257788',4904233,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257789',4904234,'2143','330',3140806.14,3145393.58,0.00,0.00,4587.44,3282517.40,0.00,0.00,0.00),('1','139','772','257789',4904235,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257790',4904236,'2143','330',3145393.58,3149278.62,0.00,0.00,3885.04,2765866.90,0.00,0.00,0.00),('1','139','772','257790',4904237,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257791',4904238,'2143','330',3149278.62,3149278.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257791',4904239,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257792',4904240,'2143','330',3149278.62,3156216.17,0.00,0.00,6937.55,4894379.50,0.00,0.00,0.00),('1','139','772','257792',4904241,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257793',4904242,'2143','330',3156216.17,3158341.00,0.00,0.00,2124.83,1543150.80,0.00,0.00,0.00),('1','139','772','257793',4904243,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257794',4904244,'2143','330',3158341.00,3160542.02,0.00,0.00,2201.02,1597342.70,0.00,0.00,0.00),('1','139','772','257794',4904245,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257795',4904246,'2143','330',3160542.02,3165041.28,0.00,0.00,4499.26,3203326.45,0.00,0.00,0.00),('1','139','772','257795',4904247,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257796',4904248,'2143','330',3165041.28,3168309.93,0.00,0.00,3268.65,2478491.90,0.00,0.00,0.00),('1','139','772','257796',4904249,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257797',4904250,'2143','330',3168309.93,3171072.07,0.00,0.00,2762.14,2093243.20,0.00,0.00,0.00),('1','139','772','257797',4904251,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257798',4904252,'2143','330',3171072.07,3173827.08,0.00,0.00,2755.01,2081863.30,0.00,0.00,0.00),('1','139','772','257798',4904253,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257799',4904254,'2143','330',3173827.08,3173827.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257799',4904255,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257800',4904256,'2143','330',3173827.08,3186346.58,0.00,0.00,12519.50,9242456.40,0.00,0.00,0.00),('1','139','772','257800',4904257,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257801',4904258,'2143','330',3186346.58,3193693.79,0.00,0.00,7347.21,5452287.80,0.00,0.00,0.00),('1','139','772','257801',4904259,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257802',4904260,'2143','330',3193693.79,3196575.95,0.00,0.00,2882.16,2154844.80,0.00,0.00,0.00),('1','139','772','257802',4904261,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257803',4904262,'2143','330',3196575.95,3198427.38,0.00,0.00,1851.43,1371745.40,0.00,0.00,0.00),('1','139','772','257803',4904263,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257804',4904264,'2143','330',3198427.38,3198427.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257804',4904265,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257805',4904266,'2143','330',3198427.38,3199888.79,0.00,0.00,1461.41,1092799.80,0.00,0.00,0.00),('1','139','772','257805',4904267,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257806',4904268,'2143','330',3199888.79,3203133.83,0.00,0.00,3245.04,2424591.20,0.00,0.00,0.00),('1','139','772','257806',4904269,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257807',4904270,'2143','330',3203133.83,3205597.04,0.00,0.00,2463.21,1848247.00,0.00,0.00,0.00),('1','139','772','257807',4904271,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257808',4904272,'2143','330',3205597.04,3207312.09,0.00,0.00,1715.05,1313279.00,0.00,0.00,0.00),('1','139','772','257808',4904273,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257809',4904274,'2143','330',3207312.09,3209619.23,0.00,0.00,2307.14,1730939.20,0.00,0.00,0.00),('1','139','772','257809',4904275,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257810',4904276,'2143','330',3209619.23,3212168.06,0.00,0.00,2548.83,1911146.40,0.00,0.00,0.00),('1','139','772','257810',4904277,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257811',4904278,'2143','330',3212168.06,3214336.96,0.00,0.00,2168.90,1632834.00,0.00,0.00,0.00),('1','139','772','257811',4904279,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257812',4904280,'2143','330',3214336.96,3216955.64,0.00,0.00,2618.68,1957758.40,0.00,0.00,0.00),('1','139','772','257812',4904281,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257813',4904282,'2143','330',3216955.64,3220147.64,0.00,0.00,3192.00,2383720.00,0.00,0.00,0.00),('1','139','772','257813',4904283,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257814',4904284,'2143','330',3220147.64,3221926.13,0.00,0.00,1778.49,1351854.20,0.00,0.00,0.00),('1','139','772','257814',4904285,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257815',4904286,'2143','330',3221926.13,3223063.81,0.00,0.00,1137.68,843808.00,0.00,0.00,0.00),('1','139','772','257815',4904287,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257816',4904288,'2143','330',3223063.81,3223063.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257816',4904289,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257817',4904290,'2143','330',3223063.81,3224206.56,0.00,0.00,1142.75,865305.00,0.00,0.00,0.00),('1','139','772','257817',4904291,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257818',4904292,'2143','330',3224206.56,3227920.68,0.00,0.00,3714.12,2770809.60,0.00,0.00,0.00),('1','139','772','257818',4904293,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257819',4904294,'2143','330',3227920.68,3230043.38,0.00,0.00,2122.70,1594186.00,0.00,0.00,0.00),('1','139','772','257819',4904295,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257820',4904296,'2143','330',3230043.38,3232898.67,0.00,0.00,2855.29,2134306.20,0.00,0.00,0.00),('1','139','772','257820',4904297,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257821',4904298,'2143','330',3232898.67,3235160.19,0.00,0.00,2261.52,1688385.60,0.00,0.00,0.00),('1','139','772','257821',4904299,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257822',4904300,'2143','330',3235160.19,3239562.31,0.00,0.00,4402.12,3272321.60,0.00,0.00,0.00),('1','139','772','257822',4904301,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257823',4904302,'2143','330',3239562.31,3241752.38,0.00,0.00,2190.07,1640602.60,0.00,0.00,0.00),('1','139','772','257823',4904303,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257824',4904304,'2143','330',3241752.38,3243424.01,0.00,0.00,1671.63,1261339.40,0.00,0.00,0.00),('1','139','772','257824',4904305,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257825',4904306,'2143','330',3243424.01,3245224.72,0.00,0.00,1800.71,1358513.80,0.00,0.00,0.00),('1','139','772','257825',4904307,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257826',4904308,'2143','330',3245224.72,3247736.10,0.00,0.00,2511.38,1860576.40,0.00,0.00,0.00),('1','139','772','257826',4904309,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257827',4904310,'2143','330',3247736.10,3247736.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257827',4904311,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257828',4904312,'2143','330',3247736.10,3249395.41,0.00,0.00,1659.31,1218458.70,0.00,0.00,0.00),('1','139','772','257828',4904313,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257829',4904314,'2143','330',3249395.41,3251061.29,0.00,0.00,1665.88,1243731.60,0.00,0.00,0.00),('1','139','772','257829',4904315,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257830',4904316,'2143','330',3251061.29,3254445.52,0.00,0.00,3384.23,2496557.10,0.00,0.00,0.00),('1','139','772','257830',4904317,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257831',4904318,'2143','330',3254445.52,3256086.25,0.00,0.00,1640.73,1230222.10,0.00,0.00,0.00),('1','139','772','257831',4904319,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257832',4904320,'2143','330',3256086.25,3258091.08,0.00,0.00,2004.83,1484719.10,0.00,0.00,0.00),('1','139','772','257832',4904321,'2186','330',2644.72,2644.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257833',4904322,'2143','330',3258091.08,3262274.98,0.00,0.00,4183.90,3086138.00,0.00,0.00,0.00),('1','139','772','257833',4904323,'2186','330',2644.72,2646.67,0.00,0.00,1.95,1501.50,0.00,0.00,0.00),('1','139','772','257834',4904324,'2143','330',3262274.98,3264940.00,0.00,0.00,2665.02,1971815.40,0.00,0.00,0.00),('1','139','772','257834',4904325,'2186','330',2646.67,2646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257835',4904326,'2143','330',3264940.00,3269030.92,0.00,0.00,4090.92,3003828.40,0.00,0.00,0.00),('1','139','772','257835',4904327,'2186','330',2646.67,2646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257836',4904328,'2143','330',3269030.92,3270802.04,0.00,0.00,1771.12,1315932.40,0.00,0.00,0.00),('1','139','772','257836',4904329,'2186','330',2646.67,2646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257837',4904330,'2143','330',3270802.04,3272378.50,0.00,0.00,1576.46,1164884.20,0.00,0.00,0.00),('1','139','772','257837',4904331,'2186','330',2646.67,2646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257838',4904332,'2143','330',3272378.50,3272378.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257838',4904333,'2186','330',2646.67,2646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257839',4904334,'2143','330',3272378.50,3275399.93,0.00,0.00,3021.43,2227361.10,0.00,0.00,0.00),('1','139','772','257839',4904335,'2186','330',2646.67,2646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257840',4904336,'2143','330',3275399.93,3276645.29,0.00,0.00,1245.36,927387.20,0.00,0.00,0.00),('1','139','772','257840',4904337,'2186','330',2646.67,2646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257841',4904338,'2143','330',3276645.29,3279399.52,0.00,0.00,2754.23,2033581.10,0.00,0.00,0.00),('1','139','772','257841',4904339,'2186','330',2646.67,2652.17,0.00,0.00,5.50,4235.00,0.00,0.00,0.00),('1','139','772','257842',4904340,'2143','330',3279399.52,3281518.21,0.00,0.00,2118.69,1576699.30,0.00,0.00,0.00),('1','139','772','257842',4904341,'2186','330',2652.17,2652.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257843',4904342,'2143','330',3281518.21,3284724.62,0.00,0.00,3206.41,2356935.70,0.00,0.00,0.00),('1','139','772','257843',4904343,'2186','330',2652.17,2652.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257844',4904344,'2143','330',3284724.62,3286130.09,0.00,0.00,1405.47,1045931.90,0.00,0.00,0.00),('1','139','772','257844',4904345,'2186','330',2652.17,2652.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257845',4904346,'2143','330',3286130.09,3287686.85,0.00,0.00,1556.76,1155505.20,0.00,0.00,0.00),('1','139','772','257845',4904347,'2186','330',2652.17,2652.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257846',4904348,'2143','330',3287686.85,3288622.05,0.00,0.00,935.20,700624.00,0.00,0.00,0.00),('1','139','772','257846',4904349,'2186','330',2652.17,2652.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257847',4904350,'2143','330',3288622.05,3290233.05,0.00,0.00,1611.00,1200670.00,0.00,0.00,0.00),('1','139','772','257847',4904351,'2186','330',2652.17,2652.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257848',4904352,'2143','330',3290233.05,3294923.10,0.00,0.00,4690.05,3436798.50,0.00,0.00,0.00),('1','139','772','257848',4904353,'2186','330',2652.17,2652.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257849',4904354,'2143','330',3294923.10,3296995.04,0.00,0.00,2071.94,1531337.80,0.00,0.00,0.00),('1','139','772','257849',4904355,'2186','330',2652.17,2652.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257850',4904356,'2143','330',3296995.04,3296995.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257850',4904357,'2186','330',2652.17,2652.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257851',4904358,'2143','330',3296995.04,3298293.50,0.00,0.00,1298.46,965735.40,0.00,0.00,0.00),('1','139','772','257851',4904359,'2186','330',2652.17,2655.03,0.00,0.00,2.86,2202.20,0.00,0.00,0.00),('1','139','772','257852',4904360,'2143','330',3298293.50,3302278.95,0.00,0.00,3985.45,2924240.50,0.00,0.00,0.00),('1','139','772','257852',4904361,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257853',4904362,'2143','330',3302278.95,3304423.76,0.00,0.00,2144.81,1589633.70,0.00,0.00,0.00),('1','139','772','257853',4904363,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257854',4904364,'2143','330',3304423.76,3306956.09,0.00,0.00,2532.33,1873834.10,0.00,0.00,0.00),('1','139','772','257854',4904365,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257855',4904366,'2143','330',3306956.09,3309025.53,0.00,0.00,2069.44,1541792.80,0.00,0.00,0.00),('1','139','772','257855',4904367,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257856',4904368,'2143','330',3309025.53,3313509.39,0.00,0.00,4483.86,3303692.20,0.00,0.00,0.00),('1','139','772','257856',4904369,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257857',4904370,'2143','330',3313509.39,3315388.53,0.00,0.00,1879.14,1383717.80,0.00,0.00,0.00),('1','139','772','257857',4904371,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257858',4904372,'2143','330',3315388.53,3317454.08,0.00,0.00,2065.55,1523857.50,0.00,0.00,0.00),('1','139','772','257858',4904373,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257859',4904374,'2143','330',3317454.08,3321586.35,0.00,0.00,4132.27,3025342.90,0.00,0.00,0.00),('1','139','772','257859',4904375,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257860',4904376,'2143','330',3321586.35,3321586.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257860',4904377,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257861',4904378,'2143','330',3321586.35,3322518.62,0.00,0.00,932.27,696135.90,0.00,0.00,0.00),('1','139','772','257861',4904379,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257862',4904380,'2143','330',3322518.62,3325173.79,0.00,0.00,2655.17,1939736.90,0.00,0.00,0.00),('1','139','772','257862',4904381,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257863',4904382,'2143','330',3325173.79,3327663.51,0.00,0.00,2489.72,1828396.40,0.00,0.00,0.00),('1','139','772','257863',4904383,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257864',4904384,'2143','330',3327663.51,3329035.97,0.00,0.00,1372.46,1015622.20,0.00,0.00,0.00),('1','139','772','257864',4904385,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257865',4904386,'2143','330',3329035.97,3329837.48,0.00,0.00,801.51,598762.70,0.00,0.00,0.00),('1','139','772','257865',4904387,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257866',4904388,'2143','330',3329837.48,3333632.26,0.00,0.00,3794.78,2760730.60,0.00,0.00,0.00),('1','139','772','257866',4904389,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257867',4904390,'2143','330',3333632.26,3335909.92,0.00,0.00,2277.66,1675974.20,0.00,0.00,0.00),('1','139','772','257867',4904391,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257868',4904392,'2143','330',3335909.92,3337739.41,0.00,0.00,1829.49,1354367.30,0.00,0.00,0.00),('1','139','772','257868',4904393,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257869',4904394,'2143','330',3337739.41,3338995.63,0.00,0.00,1256.22,938625.40,0.00,0.00,0.00),('1','139','772','257869',4904395,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257870',4904396,'2143','330',3338995.63,3341266.93,0.00,0.00,2271.30,1667101.00,0.00,0.00,0.00),('1','139','772','257870',4904397,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257871',4904398,'2143','330',3341266.93,3343638.82,0.00,0.00,2371.89,1745075.30,0.00,0.00,0.00),('1','139','772','257871',4904399,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257872',4904400,'2143','330',3343638.82,3346062.68,0.00,0.00,2423.86,1786716.20,0.00,0.00,0.00),('1','139','772','257872',4904401,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257873',4904402,'2143','330',3346062.68,3346062.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257873',4904403,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257874',4904404,'2143','330',3346062.68,3349415.34,0.00,0.00,3352.66,2391408.30,0.00,0.00,0.00),('1','139','772','257874',4904405,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257875',4904406,'2143','330',3349415.34,3352572.24,0.00,0.00,3156.90,2255904.50,0.00,0.00,0.00),('1','139','772','257875',4904407,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257876',4904408,'2143','330',3352572.24,3355540.84,0.00,0.00,2968.60,2124103.00,0.00,0.00,0.00),('1','139','772','257876',4904409,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257877',4904410,'2143','330',3355540.84,3359230.74,0.00,0.00,3689.90,2643584.50,0.00,0.00,0.00),('1','139','772','257877',4904411,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257878',4904412,'2143','330',3359230.74,3361258.74,0.00,0.00,2028.00,1476622.50,0.00,0.00,0.00),('1','139','772','257878',4904413,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257879',4904414,'2143','330',3361258.74,3364709.22,0.00,0.00,3450.48,2479362.40,0.00,0.00,0.00),('1','139','772','257879',4904415,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257880',4904416,'2143','330',3364709.22,3366785.85,0.00,0.00,2076.63,1507342.35,0.00,0.00,0.00),('1','139','772','257880',4904417,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257881',4904418,'2143','330',3366785.85,3369819.15,0.00,0.00,3033.30,2180376.50,0.00,0.00,0.00),('1','139','772','257881',4904419,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257882',4904420,'2143','330',3369819.15,3370661.27,0.00,0.00,842.12,607315.60,0.00,0.00,0.00),('1','139','772','257882',4904421,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257883',4904422,'2143','330',3370661.27,3370661.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257883',4904423,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257884',4904424,'2143','330',3370661.27,3371732.67,0.00,0.00,1071.40,774932.00,0.00,0.00,0.00),('1','139','772','257884',4904425,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257885',4904426,'2143','330',3371732.67,3375038.94,0.00,0.00,3306.27,2366596.35,0.00,0.00,0.00),('1','139','772','257885',4904427,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257886',4904428,'2143','330',3375038.94,3379910.20,0.00,0.00,4871.26,3466733.80,0.00,0.00,0.00),('1','139','772','257886',4904429,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257887',4904430,'2143','330',3379910.20,3381685.96,0.00,0.00,1775.76,1284398.80,0.00,0.00,0.00),('1','139','772','257887',4904431,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257888',4904432,'2143','330',3381685.96,3384410.22,0.00,0.00,2724.26,1953031.30,0.00,0.00,0.00),('1','139','772','257888',4904433,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257889',4904434,'2143','330',3384410.22,3386916.07,0.00,0.00,2505.85,1801216.75,0.00,0.00,0.00),('1','139','772','257889',4904435,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257890',4904436,'2143','330',3386916.07,3390712.17,0.00,0.00,3796.10,2708805.50,0.00,0.00,0.00),('1','139','772','257890',4904437,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257891',4904438,'2143','330',3390712.17,3393552.49,0.00,0.00,2840.32,2038401.60,0.00,0.00,0.00),('1','139','772','257891',4904439,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257892',4904440,'2143','330',3393552.49,3395282.67,0.00,0.00,1730.18,1226768.40,0.00,0.00,0.00),('1','139','772','257892',4904441,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257893',4904442,'2143','330',3395282.67,3395282.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257893',4904443,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257894',4904444,'2143','330',3395282.67,3397585.97,0.00,0.00,2303.30,1651106.50,0.00,0.00,0.00),('1','139','772','257894',4904445,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257895',4904446,'2143','330',3397585.97,3399535.97,0.00,0.00,1950.00,1404250.00,0.00,0.00,0.00),('1','139','772','257895',4904447,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257896',4904448,'2143','330',3399535.97,3401496.69,0.00,0.00,1960.72,1407068.60,0.00,0.00,0.00),('1','139','772','257896',4904449,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257897',4904450,'2143','330',3401496.69,3403152.23,0.00,0.00,1655.54,1204703.20,0.00,0.00,0.00),('1','139','772','257897',4904451,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257898',4904452,'2143','330',3403152.23,3405156.27,0.00,0.00,2004.04,1445050.20,0.00,0.00,0.00),('1','139','772','257898',4904453,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257899',4904454,'2143','330',3405156.27,3407989.11,0.00,0.00,2832.84,2024794.20,0.00,0.00,0.00),('1','139','772','257899',4904455,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257900',4904456,'2143','330',3407989.11,3409431.21,0.00,0.00,1442.10,1048285.50,0.00,0.00,0.00),('1','139','772','257900',4904457,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257901',4904458,'2143','330',3409431.21,3411285.91,0.00,0.00,1854.70,1336073.50,0.00,0.00,0.00),('1','139','772','257901',4904459,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257902',4904460,'2143','330',3411285.91,3415509.31,0.00,0.00,4223.40,3003017.00,0.00,0.00,0.00),('1','139','772','257902',4904461,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257903',4904462,'2143','330',3415509.31,3417192.11,0.00,0.00,1682.80,1223264.00,0.00,0.00,0.00),('1','139','772','257903',4904463,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257904',4904464,'2143','330',3417192.11,3419816.31,0.00,0.00,2624.20,1862671.00,0.00,0.00,0.00),('1','139','772','257904',4904465,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257905',4904466,'2143','330',3419816.31,3419816.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257905',4904467,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257906',4904468,'2143','330',3419816.31,3422823.41,0.00,0.00,3007.10,2151328.00,0.00,0.00,0.00),('1','139','772','257906',4904469,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257907',4904470,'2143','330',3422823.41,3425504.04,0.00,0.00,2680.63,1919835.65,0.00,0.00,0.00),('1','139','772','257907',4904471,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257908',4904472,'2143','330',3425504.04,3428375.79,0.00,0.00,2871.75,2049671.25,0.00,0.00,0.00),('1','139','772','257908',4904473,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257909',4904474,'2143','330',3428375.79,3430889.49,0.00,0.00,2513.70,1801653.50,0.00,0.00,0.00),('1','139','772','257909',4904475,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257910',4904476,'2143','330',3430889.49,3434563.11,0.00,0.00,3673.62,2615725.60,0.00,0.00,0.00),('1','139','772','257910',4904477,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257911',4904478,'2143','330',3434563.11,3436508.52,0.00,0.00,1945.41,1413187.05,0.00,0.00,0.00),('1','139','772','257911',4904479,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257912',4904480,'2143','330',3436508.52,3438033.43,0.00,0.00,1524.91,1111032.05,0.00,0.00,0.00),('1','139','772','257912',4904481,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257913',4904482,'2143','330',3438033.43,3440843.68,0.00,0.00,2810.25,2015573.75,0.00,0.00,0.00),('1','139','772','257913',4904483,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257914',4904484,'2143','330',3440843.68,3443001.17,0.00,0.00,2157.49,1541569.95,0.00,0.00,0.00),('1','139','772','257914',4904485,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257915',4904486,'2143','330',3443001.17,3444429.87,0.00,0.00,1428.70,1016953.00,0.00,0.00,0.00),('1','139','772','257915',4904487,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257916',4904488,'2143','330',3444429.87,3444429.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257916',4904489,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257917',4904490,'2143','330',3444429.87,3446021.09,0.00,0.00,1591.22,1153221.10,0.00,0.00,0.00),('1','139','772','257917',4904491,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257918',4904492,'2143','330',3446021.09,3447315.50,0.00,0.00,1294.41,942854.55,0.00,0.00,0.00),('1','139','772','257918',4904493,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257919',4904494,'2143','330',3447315.50,3449110.23,0.00,0.00,1794.73,1295176.15,0.00,0.00,0.00),('1','139','772','257919',4904495,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257920',4904496,'2143','330',3449110.23,3450120.43,0.00,0.00,1010.20,733991.00,0.00,0.00,0.00),('1','139','772','257920',4904497,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257921',4904498,'2143','330',3450120.43,3451763.20,0.00,0.00,1642.77,1188091.35,0.00,0.00,0.00),('1','139','772','257921',4904499,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257922',4904500,'2143','330',3451763.20,3453185.12,0.00,0.00,1421.92,1028842.10,0.00,0.00,0.00),('1','139','772','257922',4904501,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257923',4904502,'2143','330',3453185.12,3455069.15,0.00,0.00,1884.03,1349897.65,0.00,0.00,0.00),('1','139','772','257923',4904503,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257924',4904504,'2143','330',3455069.15,3457035.26,0.00,0.00,1966.11,1410038.05,0.00,0.00,0.00),('1','139','772','257924',4904505,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257925',4904506,'2143','330',3457035.26,3459407.11,0.00,0.00,2371.85,1702690.75,0.00,0.00,0.00),('1','139','772','257925',4904507,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257926',4904508,'2143','330',3459407.11,3460471.91,0.00,0.00,1064.80,775529.00,0.00,0.00,0.00),('1','139','772','257926',4904509,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257927',4904510,'2143','330',3460471.91,3462502.21,0.00,0.00,2030.30,1454536.50,0.00,0.00,0.00),('1','139','772','257927',4904511,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257928',4904512,'2143','330',3462502.21,3466759.38,0.00,0.00,4257.17,3031533.35,0.00,0.00,0.00),('1','139','772','257928',4904513,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257929',4904514,'2143','330',3466759.38,3468912.59,0.00,0.00,2153.21,1531652.70,0.00,0.00,0.00),('1','139','772','257929',4904515,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257930',4904516,'2143','330',3468912.59,3468912.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257930',4904517,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257931',4904518,'2143','330',3468912.59,3469571.60,0.00,0.00,659.01,478652.55,0.00,0.00,0.00),('1','139','772','257931',4904519,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257932',4904520,'2143','330',3469571.60,3471575.25,0.00,0.00,2003.65,1430395.75,0.00,0.00,0.00),('1','139','772','257932',4904521,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257933',4904522,'2143','330',3471575.25,3473515.62,0.00,0.00,1940.37,1390769.35,0.00,0.00,0.00),('1','139','772','257933',4904523,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257934',4904524,'2143','330',3473515.62,3474805.01,0.00,0.00,1289.39,929830.40,0.00,0.00,0.00),('1','139','772','257934',4904525,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257935',4904526,'2143','330',3474805.01,3475526.26,0.00,0.00,721.25,524829.25,0.00,0.00,0.00),('1','139','772','257935',4904527,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257936',4904528,'2143','330',3475526.26,3476785.74,0.00,0.00,1259.48,916977.40,0.00,0.00,0.00),('1','139','772','257936',4904529,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257937',4904530,'2143','330',3476785.74,3478098.84,0.00,0.00,1313.10,948685.50,0.00,0.00,0.00),('1','139','772','257937',4904531,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257938',4904532,'2143','330',3478098.84,3480651.96,0.00,0.00,2553.12,1793286.30,0.00,0.00,0.00),('1','139','772','257938',4904533,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257939',4904534,'2143','330',3480651.96,3482874.88,0.00,0.00,2222.92,1552308.30,0.00,0.00,0.00),('1','139','772','257939',4904535,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257940',4904536,'2143','330',3482874.88,3485235.76,0.00,0.00,2360.88,1645603.20,0.00,0.00,0.00),('1','139','772','257940',4904537,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257941',4904538,'2143','330',3485235.76,3486928.10,0.00,0.00,1692.34,1201731.60,0.00,0.00,0.00),('1','139','772','257941',4904539,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257942',4904540,'2143','330',3486928.10,3488082.52,0.00,0.00,1154.42,821895.80,0.00,0.00,0.00),('1','139','772','257942',4904541,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257943',4904542,'2143','330',3488082.52,3490335.44,0.00,0.00,2252.92,1576760.80,0.00,0.00,0.00),('1','139','772','257943',4904543,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257944',4904544,'2143','330',3490335.44,3491976.13,0.00,0.00,1640.69,1165684.10,0.00,0.00,0.00),('1','139','772','257944',4904545,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257945',4904546,'2143','330',3491976.13,3493537.34,0.00,0.00,1561.21,1080395.40,0.00,0.00,0.00),('1','139','772','257945',4904547,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257946',4904548,'2143','330',3493537.34,3493537.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257946',4904549,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257947',4904550,'2143','330',3493537.34,3494187.35,0.00,0.00,650.01,460197.40,0.00,0.00,0.00),('1','139','772','257947',4904551,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257948',4904552,'2143','330',3494187.35,3495585.45,0.00,0.00,1398.10,983297.50,0.00,0.00,0.00),('1','139','772','257948',4904553,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257949',4904554,'2143','330',3495585.45,3497653.10,0.00,0.00,2067.65,1452511.00,0.00,0.00,0.00),('1','139','772','257949',4904555,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257950',4904556,'2143','330',3497653.10,3500372.95,0.00,0.00,2719.85,1905489.00,0.00,0.00,0.00),('1','139','772','257950',4904557,'2186','330',2655.03,2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','139','772','257951',4904558,'2143','330',3500372.95,0.00,0.00,0.00,1744.65,1227991.00,0.00,0.00,0.00),('1','139','772','257951',4904559,'2186','330',2655.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730104 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','139','146991','330',213.00,276.00,0.00,0.00,0.00,0.00,0.00,441530),('1','139','147016','330',213.00,227676.00,0.00,4687.60,998458.80,1054845.60,56386.80,441584),('1','139','147072','330',213.00,0.00,0.00,1832.80,390386.40,431324.80,40938.40,441718),('1','139','147084','330',213.00,0.00,0.00,1627.70,346700.10,395403.20,48703.10,441734),('1','139','147090','330',213.00,276.00,0.00,2446.00,520998.00,567609.60,46611.60,441744),('1','139','147115','330',213.00,276.00,0.00,2366.80,504128.40,555472.80,51344.40,441785),('1','139','147137','330',213.00,276.00,0.00,1888.90,402335.70,442848.40,40512.70,441836),('1','139','147159','330',213.00,212.00,0.00,2781.60,592480.80,626345.60,33864.80,441883),('1','139','147437','330',213.00,276.00,0.00,1115.00,237495.00,270612.00,33117.00,442550),('1','139','147555','330',213.00,276.00,0.00,3005.80,640235.40,694464.80,54229.40,442887),('1','139','147676','330',213.00,276.00,0.00,1603.90,341630.70,372961.20,31330.50,443200),('1','139','147686','330',213.00,276.00,0.00,2317.00,486570.00,528840.00,42270.00,443225),('1','139','147989','330',210.00,276.00,0.00,7678.00,1612380.00,1660764.00,48384.00,444044),('1','139','148124','330',210.00,276.00,0.00,1668.30,350343.00,390430.80,40087.80,444397),('1','139','148287','330',210.00,276.00,0.00,2101.80,441378.00,483340.80,41962.80,444806),('1','139','148409','330',210.00,276.00,0.00,3366.00,706860.00,756255.20,49395.20,445151),('1','139','148556','330',210.00,276.00,0.00,2126.90,446649.00,486392.40,39743.40,445528),('1','139','148662','330',210.00,276.00,0.00,3106.60,652386.00,695393.60,43007.60,445797),('1','139','148713','330',210.00,276.00,0.00,1239.30,260253.00,289426.80,29173.80,445930),('1','139','148972','330',210.00,276.00,0.00,1272.10,267141.00,295875.60,28734.60,446598),('1','139','149136','330',210.00,276.00,0.00,4072.90,855309.00,908123.60,52814.60,447048),('1','139','149295','330',210.00,276.00,0.00,3055.40,641634.00,683825.40,42191.40,447458),('1','139','149444','330',210.00,276.00,0.00,5088.50,1068585.00,1127398.00,58813.00,447857),('1','139','149598','330',210.00,276.00,0.00,4683.40,983514.00,1046814.40,63300.40,448284),('1','139','149687','330',210.00,276.00,0.00,2006.50,421365.00,466606.00,45241.00,448517),('1','139','149754','330',210.00,276.00,0.00,906.80,190428.00,203076.80,12648.80,448690),('1','139','149759','330',210.00,276.00,0.00,3541.20,725946.00,794373.60,68427.60,448704),('1','139','150005','330',205.00,276.00,0.00,3491.70,715798.50,799671.10,83872.60,449363),('1','139','150144','330',205.00,276.00,0.00,4052.40,830742.00,915362.40,84620.40,449732),('1','139','150370','330',205.00,276.00,0.00,3721.30,762866.50,833010.80,70144.30,450310),('1','139','150543','330',205.00,276.00,0.00,4405.80,903189.00,981726.40,78537.40,450783),('1','139','150705','330',205.00,276.00,0.00,2139.40,438577.00,485695.20,47118.20,451205),('1','139','150708','330',205.00,276.00,0.00,0.00,0.00,0.00,0.00,451210),('1','139','150832','330',205.00,276.00,0.00,3112.20,638001.00,715900.00,77899.00,451541),('1','139','150999','330',205.00,276.00,0.00,2384.60,488843.00,548963.20,60120.20,451976),('1','139','151149','330',205.00,276.00,0.00,2062.40,422792.00,486030.40,63238.40,452390),('1','139','151286','330',205.00,276.00,0.00,2666.20,546571.00,615150.40,68579.40,452757),('1','139','151444','330',205.00,276.00,0.00,3420.70,701243.50,771738.80,70495.30,453185),('1','139','151581','330',205.00,276.00,0.00,1772.10,363280.50,417491.60,54211.10,453571),('1','139','151690','330',205.00,276.00,0.00,1650.20,338291.00,396739.20,58448.20,453870),('1','139','151814','330',205.00,276.00,0.00,1557.10,319205.50,365479.60,46274.10,454189),('1','139','152000','330',205.00,276.00,0.00,3462.70,709853.50,841697.20,131843.70,454696),('1','139','152158','330',205.00,276.00,0.00,340.10,69720.50,74822.00,5101.50,455110),('1','139','152315','330',205.00,276.00,0.00,0.00,0.00,0.00,0.00,455526),('1','139','152352','330',205.00,276.00,0.00,1512.20,310001.00,352219.20,42218.20,455620),('1','139','152353','330',205.00,276.00,0.00,4257.20,872726.00,963575.20,90849.20,455621),('1','139','152458','330',205.00,276.00,0.00,2857.00,585685.00,648832.00,63147.00,455906),('1','139','152618','330',205.00,276.00,0.00,5305.40,1087607.00,1182742.40,95135.40,456327),('1','139','152773','330',205.00,276.00,0.00,5649.50,1158147.50,1241150.00,83002.50,456748),('1','139','152901','330',205.00,276.00,0.00,1388.10,284560.50,333042.40,48481.90,457096),('1','139','153071','330',205.00,276.00,0.00,1443.20,295856.00,323010.40,27154.40,457553),('1','139','153072','330',205.00,276.00,0.00,0.00,0.00,0.00,0.00,457554),('1','139','153434','330',205.00,276.00,0.00,3907.20,800976.00,879620.80,78644.80,458564),('1','139','153645','330',205.00,276.00,0.00,1737.50,356187.50,410530.00,54342.50,459115),('1','139','153797','330',205.00,276.00,0.00,2666.40,546612.00,610606.40,63994.40,459532),('1','139','153931','330',205.00,276.00,0.00,2483.30,509076.50,586810.80,77734.30,459866),('1','139','154066','330',205.00,276.00,0.00,2778.00,569490.00,643556.00,74066.00,460215),('1','139','154250','330',205.00,276.00,0.00,3477.90,712969.50,801956.40,88986.90,460725),('1','139','154405','330',205.00,276.00,0.00,2591.10,531175.50,611607.60,80432.10,461130),('1','139','154557','330',205.00,276.00,0.00,2767.80,567399.00,615712.80,48313.80,461556),('1','139','154558','330',205.00,276.00,0.00,0.00,0.00,0.00,0.00,461557),('1','139','155025','330',210.00,280.00,0.00,11633.10,2442951.00,2637420.00,194469.00,462821),('1','139','155136','330',210.00,280.00,0.00,5236.20,1099602.00,1207596.00,107994.00,463123),('1','139','155298','330',210.00,280.00,0.00,3323.70,697977.00,781618.40,83641.40,463562),('1','139','155447','330',210.00,280.00,0.00,2310.30,485163.00,531684.00,46521.00,463961),('1','139','155450','330',210.00,280.00,0.00,0.00,0.00,0.00,0.00,463968),('1','139','155645','330',210.00,280.00,0.00,11056.90,2321949.00,2546682.00,224733.00,464499),('1','139','155782','330',210.00,280.00,0.00,6000.90,1260189.00,1381820.00,121631.00,464867),('1','139','155938','330',210.00,280.00,0.00,2508.70,526827.00,596148.40,69321.40,465260),('1','139','156089','330',210.00,280.00,0.00,3043.90,639219.00,720195.20,80976.20,465667),('1','139','156298','330',210.00,280.00,0.00,0.00,0.00,0.00,0.00,466223),('1','139','156301','330',210.00,280.00,0.00,3029.60,636216.00,729679.20,93463.20,466231),('1','139','156417','330',210.00,280.00,0.00,4652.70,977067.00,1092817.20,115750.20,466536),('1','139','156560','330',210.00,280.00,0.00,1477.30,310233.00,361718.00,51485.00,466928),('1','139','156736','330',210.00,280.00,0.00,2772.70,582267.00,656442.00,74175.00,467410),('1','139','156907','330',210.00,280.00,0.00,2138.50,449085.00,509108.00,60023.00,467873),('1','139','157088','330',210.00,280.00,0.00,3305.00,694050.00,777056.00,83006.00,468335),('1','139','157282','330',210.00,280.00,0.00,2957.20,621012.00,705042.00,84030.00,468843),('1','139','157451','330',210.00,280.00,0.00,3112.40,653604.00,743176.00,89572.00,469275),('1','139','157452','330',210.00,280.00,0.00,0.00,0.00,0.00,0.00,469276),('1','139','157640','330',210.00,280.00,0.00,2694.70,565887.00,645202.00,79315.00,469773),('1','139','157822','330',210.00,280.00,0.00,4622.60,970746.00,1079122.40,108376.40,470250),('1','139','157953','330',210.00,280.00,0.00,8140.40,1709484.00,1859432.00,149948.00,470607),('1','139','158089','330',210.00,280.00,0.00,2719.00,570990.00,645810.00,74820.00,470955),('1','139','158202','330',210.00,280.00,0.00,1512.50,317625.00,355668.00,38043.00,471268),('1','139','158209','330',210.00,280.00,0.00,0.00,0.00,0.00,0.00,471286),('1','139','158426','330',210.00,280.00,0.00,4613.10,968751.00,1066988.00,98237.00,471852),('1','139','158582','330',210.00,280.00,0.00,1232.50,258825.00,309220.00,50395.00,472252),('1','139','158753','330',210.00,280.00,0.00,2827.80,593838.00,667432.00,73594.00,472704),('1','139','158925','330',210.00,280.00,0.00,6543.70,1374177.00,1506598.00,132421.00,473155),('1','139','159112','330',210.00,280.00,0.00,4005.30,841113.00,934448.00,93335.00,473657),('1','139','159279','330',210.00,280.00,0.00,3186.80,669228.00,739764.00,70536.00,474107),('1','139','159280','330',210.00,280.00,0.00,0.00,0.00,0.00,0.00,474108),('1','139','159460','330',210.00,0.00,0.00,3010.90,632289.00,710596.00,78307.00,474547),('1','139','159742','330',210.00,280.00,0.00,5461.40,1146894.00,1279546.00,132652.00,475268),('1','139','159743','330',210.00,280.00,0.00,4339.60,911316.00,1031104.00,119788.00,475269),('1','139','159953','330',210.00,280.00,0.00,8814.60,1851066.00,2031972.00,180906.00,475822),('1','139','160106','330',210.00,280.00,0.00,1096.50,230265.00,255960.00,25695.00,476234),('1','139','160107','330',210.00,280.00,0.00,0.00,0.00,0.00,0.00,476235),('1','139','160368','330',210.00,280.00,0.00,4259.00,894390.00,985644.00,91254.00,476912),('1','139','160459','330',210.00,280.00,0.00,9698.90,2036769.00,2233612.00,196843.00,477142),('1','139','160609','330',210.00,681.90,0.00,0.00,0.00,0.00,0.00,477529),('1','139','160610','330',210.00,304.00,0.00,7487.20,1572312.00,1888622.60,316310.60,477530),('1','139','160736','330',210.00,304.00,0.00,901.50,189315.00,226456.00,37141.00,477873),('1','139','160738','330',210.00,280.00,0.00,0.00,0.00,0.00,0.00,477875),('1','139','160900','330',220.00,304.00,0.00,4792.50,1054350.00,1228008.00,173658.00,478260),('1','139','160901','330',220.00,304.00,0.00,3413.50,750970.00,884286.00,133316.00,478261),('1','139','161099','330',220.00,304.00,0.00,4100.20,902044.00,1053789.60,151745.60,478797),('1','139','161283','330',220.00,304.00,0.00,8231.00,1810820.00,2060257.00,249437.00,479271),('1','139','161425','330',220.00,304.00,0.00,1795.40,394988.00,451001.60,56013.60,479646),('1','139','161428','330',220.00,304.00,0.00,0.00,0.00,0.00,0.00,479653),('1','139','161450','330',220.00,304.00,0.00,2104.30,462946.00,542145.20,79199.20,479700),('1','139','161659','330',220.00,304.00,0.00,1704.00,374880.00,454678.00,79798.00,480235),('1','139','161869','330',220.00,304.00,0.00,4146.70,912274.00,1061483.80,149209.80,480756),('1','139','162051','330',220.00,304.00,0.00,4418.70,972114.00,1126176.60,154062.60,481245),('1','139','162235','330',220.00,304.00,0.00,2882.40,634128.00,748611.60,114483.60,481713),('1','139','162447','330',220.00,304.00,0.00,3755.60,826232.00,961537.60,135305.60,482262),('1','139','162581','330',220.00,304.00,0.00,3302.30,726506.00,825299.20,98793.20,482575),('1','139','162587','330',220.00,304.00,0.00,0.00,0.00,0.00,0.00,482591),('1','139','162806','330',220.00,304.00,0.00,4970.40,1093488.00,1252220.80,158732.80,483175),('1','139','162996','330',220.00,304.00,0.00,1940.40,426888.00,505021.60,78133.60,483685),('1','139','163198','330',220.00,304.00,0.00,2191.80,482196.00,568837.20,86641.20,484190),('1','139','163372','330',220.00,304.00,0.00,7861.70,1729574.00,1944266.80,214692.80,484640),('1','139','163556','330',220.00,304.00,0.00,5399.80,1187956.00,1346965.20,159009.20,485120),('1','139','163557','330',220.00,304.00,0.00,0.00,0.00,0.00,0.00,485121),('1','139','163747','330',237.00,304.00,0.00,8210.80,1945959.60,2046395.00,100435.40,485619),('1','139','163899','330',237.00,304.00,0.00,6524.50,1546306.50,1678528.00,132221.50,486017),('1','139','164080','330',237.00,304.00,0.00,6607.10,1565882.70,1724304.80,158422.10,486489),('1','139','164081','330',237.00,304.00,0.00,0.00,0.00,0.00,0.00,486490),('1','139','164261','330',237.00,304.00,0.00,3196.70,757617.90,851516.00,93898.10,486966),('1','139','164438','330',237.00,304.00,0.00,2321.40,550171.80,639225.60,89053.80,487446),('1','139','164599','330',237.00,304.00,0.00,2543.50,602809.50,700633.00,97823.50,487883),('1','139','164754','330',237.00,304.00,0.00,3088.80,732045.60,840131.40,108085.80,488296),('1','139','164963','330',237.00,304.00,0.00,4241.20,1005164.40,1132124.80,126960.40,488834),('1','139','165132','330',237.00,320.00,0.00,3501.80,829926.60,1027270.00,197343.40,489257),('1','139','165281','330',237.00,320.00,0.00,3427.00,812199.00,992810.00,180611.00,489656),('1','139','165283','330',237.00,304.00,0.00,0.00,0.00,0.00,0.00,489660),('1','139','165441','330',237.00,320.00,0.00,12648.50,2997694.50,3625124.00,627429.50,490071),('1','139','165615','330',237.00,320.00,0.00,7290.40,1727824.80,2086796.00,358971.20,490526),('1','139','165737','330',237.00,320.00,0.00,2660.40,630514.80,779828.00,149313.20,490862),('1','139','165744','330',237.00,320.00,0.00,0.00,0.00,0.00,0.00,490881),('1','139','165931','330',261.00,320.00,0.00,6640.00,1733040.00,1924750.00,191710.00,491372),('1','139','166152','330',261.00,320.00,0.00,4242.60,1107318.60,1237278.00,129959.40,491944),('1','139','166313','330',261.00,320.00,0.00,3746.80,977914.80,1093576.00,115661.20,492380),('1','139','166494','330',261.00,320.00,0.00,4025.50,1050655.50,1176976.00,126320.50,492873),('1','139','166696','330',261.00,320.00,0.00,3792.30,989790.30,1102558.00,112767.70,493410),('1','139','166698','330',261.00,320.00,0.00,0.00,0.00,0.00,0.00,493414),('1','139','166881','330',261.00,320.00,0.00,3117.80,813745.80,917134.00,103388.20,493918),('1','139','167027','330',261.00,320.00,0.00,5509.10,1437875.10,1598732.00,160856.90,494313),('1','139','167175','330',261.00,320.00,0.00,1737.50,453487.50,513000.00,59512.50,494704),('1','139','167369','330',261.00,320.00,0.00,2932.50,765382.50,863400.00,98017.50,495231),('1','139','167565','330',261.00,320.00,0.00,2731.90,713025.90,1156828.00,443802.10,495738),('1','139','167723','330',261.00,320.00,0.00,0.00,0.00,0.00,0.00,496155),('1','139','167725','330',261.00,320.00,0.00,1831.90,478125.90,541920.00,63794.10,496159),('1','139','167866','330',261.00,320.00,0.00,3275.60,854931.60,955876.00,100944.40,496529),('1','139','169084','330',261.00,320.00,0.00,0.00,0.00,0.00,0.00,499761),('1','139','169086','330',261.00,320.00,0.00,0.00,0.00,0.00,0.00,499763),('1','139','169089','330',261.00,320.00,0.00,4394.20,1146886.20,1283554.00,136667.80,499770),('1','139','169093','330',261.00,320.00,0.00,4025.90,1050759.90,1179642.00,128882.10,499776),('1','139','169097','330',261.00,320.00,0.00,4426.90,1155420.90,1276514.00,121093.10,499783),('1','139','169100','330',261.00,320.00,0.00,4485.60,1170741.60,1292127.00,121385.40,499790),('1','139','169103','330',261.00,320.00,0.00,4151.50,1083541.50,1215500.00,131958.50,499795),('1','139','169109','330',261.00,320.00,0.00,0.00,0.00,0.00,0.00,499806),('1','139','169171','330',261.00,320.00,0.00,4619.00,1205559.00,1354065.00,148506.00,499963),('1','139','169179','330',261.00,320.00,0.00,10141.50,2646931.50,2902055.00,255123.50,499985),('1','139','169263','330',261.00,320.00,0.00,3386.90,883980.90,1001848.00,117867.10,500203),('1','139','169431','330',261.00,320.00,0.00,4278.20,1116610.20,1240994.00,124383.80,500634),('1','139','169434','330',261.00,320.00,0.00,0.00,0.00,0.00,0.00,500639),('1','139','169569','330',261.00,340.00,0.00,6797.80,1774225.80,1936552.00,162326.20,500995),('1','139','169767','330',261.00,340.00,0.00,2128.30,555486.30,675948.00,120461.70,501526),('1','139','169920','330',261.00,340.00,0.00,4030.80,1052038.80,1258082.00,206043.20,501949),('1','139','170144','330',261.00,340.00,0.00,1678.80,438166.80,535450.00,97283.20,502510),('1','139','170331','330',261.00,340.00,0.00,3066.20,800278.20,962603.00,162324.80,503000),('1','139','170500','330',261.00,340.00,0.00,1327.00,346347.00,433669.00,87322.00,503439),('1','139','170675','330',261.00,340.00,0.00,2042.90,533196.90,652911.00,119714.10,503895),('1','139','170819','330',261.00,340.00,0.00,3277.20,855349.20,1021940.00,166590.80,504266),('1','139','171006','330',261.00,340.00,0.00,0.00,0.00,0.00,0.00,504764),('1','139','171007','330',261.00,340.00,0.00,3310.30,863988.30,1042174.00,178185.70,504765),('1','139','171217','330',261.00,340.00,0.00,3074.20,802366.20,966115.00,163748.80,505342),('1','139','171525','330',261.00,340.00,0.00,4174.30,1089492.30,1309137.00,219644.70,506175),('1','139','171591','330',261.00,340.00,0.00,2486.50,648976.50,787030.00,138053.50,506333),('1','139','171936','330',261.00,340.00,0.00,4770.20,1245022.20,1487768.00,242745.80,507258),('1','139','171937','330',261.00,340.00,0.00,1778.50,464188.50,566832.00,102643.50,507259),('1','139','172091','330',261.00,340.00,0.00,3773.50,984883.50,1174090.00,189206.50,507642),('1','139','172093','330',261.00,340.00,0.00,885.00,230985.00,270810.00,39825.00,507644),('1','139','172285','330',261.00,340.00,0.00,0.00,0.00,0.00,0.00,508170),('1','139','172423','330',278.00,340.00,0.00,2564.10,712819.80,784362.00,71542.20,508545),('1','139','172492','330',278.00,340.00,0.00,3740.60,1039886.80,1141328.00,101441.20,508725),('1','139','172689','330',278.00,340.00,0.00,3155.80,877312.40,965932.00,88619.60,509245),('1','139','172859','330',278.00,340.00,0.00,1792.00,498176.00,556520.00,58344.00,509698),('1','139','173039','330',278.00,340.00,0.00,2677.00,744206.00,822960.00,78754.00,510175),('1','139','173199','330',278.00,340.00,0.00,2519.20,700337.60,779328.00,78990.40,510599),('1','139','173359','330',278.00,340.00,0.00,2275.20,632505.60,707928.00,75422.40,511015),('1','139','173578','330',278.00,340.00,0.00,4811.60,1337624.80,1449824.00,112199.20,511612),('1','139','173585','330',278.00,340.00,0.00,0.00,0.00,0.00,0.00,511629),('1','139','173756','330',278.00,340.00,0.00,4466.20,1241603.60,1358240.00,116636.40,512072),('1','139','173939','330',278.00,340.00,0.00,7421.70,2063232.60,2220684.00,157451.40,512550),('1','139','174124','330',278.00,340.00,0.00,7647.20,2125921.60,2302788.00,176866.40,513042),('1','139','174299','330',278.00,340.00,0.00,4533.70,1260368.60,1366618.00,106249.40,513504),('1','139','174301','330',278.00,340.00,0.00,0.00,0.00,0.00,0.00,513508),('1','139','174479','330',278.00,340.00,0.00,8693.30,2416737.40,2604932.00,188194.60,513963),('1','139','174615','330',278.00,340.00,0.00,4136.80,1150030.40,1237043.20,87012.80,514301),('1','139','174835','330',278.00,340.00,0.00,6778.80,1884506.40,2054272.00,169765.60,514890),('1','139','175022','330',278.00,352.00,0.00,4307.90,1197596.20,1334088.80,136492.60,515392),('1','139','175027','330',278.00,340.00,0.00,0.00,0.00,0.00,0.00,515403),('1','139','175234','330',290.00,352.00,0.00,7104.50,2060305.00,2230988.00,170683.00,515941),('1','139','175398','330',290.00,352.00,0.00,3684.20,1068418.00,1187838.40,119420.40,516379),('1','139','175581','330',290.00,352.00,0.00,1992.10,577709.00,655259.20,77550.20,516854),('1','139','175758','330',290.00,352.00,0.00,7832.80,2271512.00,2446285.60,174773.60,517315),('1','139','175903','330',290.00,352.00,0.00,3791.90,1099651.00,1180180.80,80529.80,517702),('1','139','175904','330',290.00,352.00,0.00,0.00,0.00,0.00,0.00,517703),('1','139','176134','330',290.00,352.00,0.00,10188.90,2954781.00,3188292.80,233511.80,518281),('1','139','176308','330',290.00,352.00,0.00,7901.50,2291435.00,2494448.00,203013.00,518735),('1','139','176536','330',290.00,352.00,0.00,6184.30,1793447.00,1966049.60,172602.60,519320),('1','139','176961','330',293.00,352.00,0.00,0.00,0.00,0.00,0.00,520467),('1','139','176965','330',293.00,352.00,0.00,10446.30,3060765.90,3214721.60,153955.70,520477),('1','139','176966','330',293.00,352.00,0.00,2586.80,757932.40,848473.60,90541.20,520478),('1','139','177224','330',293.00,352.00,0.00,11619.60,3404542.80,3628039.20,223496.40,521136),('1','139','177565','330',293.00,352.00,0.00,0.00,0.00,0.00,0.00,522058),('1','139','177568','330',293.00,352.00,0.00,2761.40,809090.20,901772.80,92682.60,522065),('1','139','177607','330',293.00,352.00,0.00,6511.70,1907928.10,2067874.40,159946.30,522167),('1','139','177861','330',293.00,352.00,0.00,2473.40,724706.20,803516.80,78810.60,522848),('1','139','178060','330',293.00,352.00,0.00,4071.90,1193066.70,1308188.80,115122.10,523372),('1','139','178284','330',293.00,352.00,0.00,8527.10,2498440.30,2677459.20,179018.90,523944),('1','139','178475','330',293.00,352.00,0.00,0.00,0.00,0.00,0.00,524447),('1','139','178479','330',288.00,352.00,0.00,7748.00,2231424.00,2384028.00,152604.00,524457),('1','139','178698','330',288.00,352.00,0.00,3456.00,995328.00,1149836.00,154508.00,525041),('1','139','178864','330',288.00,352.00,0.00,0.00,0.00,0.00,0.00,525480),('1','139','178865','330',288.00,352.00,0.00,1687.80,486086.40,569269.60,83183.20,525481),('1','139','179102','330',288.00,352.00,0.00,6028.70,1736265.60,1950781.60,214516.00,526082),('1','139','179345','330',288.00,352.00,0.00,5458.60,1572076.80,1768720.00,196643.20,526746),('1','139','179418','330',288.00,352.00,0.00,0.00,0.00,0.00,0.00,526929),('1','139','179754','330',288.00,352.00,0.00,11500.50,3312144.00,3700204.00,388060.00,527842),('1','139','179756','330',288.00,352.00,0.00,4500.00,1296000.00,1488133.20,192133.20,527846),('1','139','179978','330',288.00,352.00,0.00,4318.60,1243756.80,1411909.20,168152.40,528420),('1','139','180080','330',288.00,352.00,0.00,3733.90,1075363.20,1204714.80,129351.60,528678),('1','139','180143','330',288.00,352.00,0.00,0.00,0.00,0.00,0.00,528852),('1','139','180246','330',303.00,352.00,0.00,0.00,0.00,0.00,0.00,529110),('1','139','180248','330',303.00,352.00,0.00,1950.60,591031.80,634675.20,43643.40,529114),('1','139','180296','330',303.00,352.00,0.00,2193.50,664630.50,738076.00,73445.50,529239),('1','139','180360','330',303.00,352.00,0.00,3100.99,939599.97,1033935.72,94335.75,529386),('1','139','180549','330',303.00,352.00,0.00,4427.04,1341393.12,1456058.08,114664.96,529907),('1','139','180740','330',303.00,352.00,0.00,4259.19,1290534.57,1406990.92,116456.35,530398),('1','139','180961','330',303.00,352.00,0.00,2734.87,828665.61,906208.76,77543.15,530993),('1','139','181134','330',303.00,352.00,0.00,4614.31,1398135.93,1511729.00,113593.07,531447),('1','139','181361','330',303.00,352.00,0.00,2881.74,873167.22,949618.88,76451.66,532054),('1','139','181531','330',303.00,352.00,0.00,3834.94,1161986.82,1252652.08,90665.26,532496),('1','139','181711','330',303.00,352.00,0.00,7453.32,2258355.96,2394816.84,136460.88,532970),('1','139','181907','330',303.00,352.00,0.00,3003.77,910142.31,986121.04,75978.73,533509),('1','139','182109','330',303.00,352.00,0.00,6144.95,1861919.85,1968675.60,106755.75,534049),('1','139','182188','330',303.00,352.00,0.00,2441.14,751871.12,796010.48,44139.36,534253),('1','139','182315','330',308.00,352.00,0.00,6282.24,1934929.92,2017296.48,82366.56,534570),('1','139','182505','330',308.00,352.00,0.00,5128.81,1579673.48,1656420.72,76747.24,535082),('1','139','182692','330',308.00,352.00,0.00,6850.50,2075701.50,2236172.00,160470.50,535577),('1','139','183678','330',303.00,352.00,0.00,2108.90,638996.70,696140.80,57144.10,538179),('1','139','183684','330',303.00,352.00,0.00,0.00,0.00,0.00,0.00,538192),('1','139','183695','330',308.00,352.00,0.00,8498.60,2617568.80,2741376.80,123808.00,538219),('1','139','183703','330',308.00,352.00,0.00,3548.00,1092784.00,1164172.00,71388.00,538241),('1','139','183725','330',308.00,352.00,0.00,6041.00,1860628.00,1962714.80,102086.80,538304),('1','139','183833','330',308.00,352.00,0.00,6158.10,1896694.80,1982823.20,86128.40,538604),('1','139','183953','330',308.00,352.00,0.00,140.70,43335.60,49526.40,6190.80,538910),('1','139','183957','330',308.00,352.00,0.00,0.00,0.00,0.00,0.00,538920),('1','139','183995','330',317.00,356.00,0.00,10823.69,3431109.73,3578010.84,146901.11,539030),('1','139','184282','330',317.00,356.00,0.00,1868.86,592428.62,629108.56,36679.94,539786),('1','139','184486','330',317.00,356.00,0.00,5820.16,1844990.72,1928683.36,83692.64,540304),('1','139','184696','330',317.00,356.00,0.00,3886.83,1232125.11,1298458.68,66333.57,540885),('1','139','184899','330',317.00,356.00,0.00,1588.58,503579.86,528954.48,25374.62,541425),('1','139','185006','330',317.00,356.00,0.00,0.00,0.00,0.00,0.00,541708),('1','139','185033','330',317.00,356.00,0.00,928.88,294454.96,317001.28,22546.32,541783),('1','139','185109','330',317.00,356.00,0.00,2817.76,893229.92,955733.36,62503.44,541962),('1','139','185264','330',317.00,356.00,0.00,3658.81,1159842.77,1224278.76,64435.99,542345),('1','139','185478','330',317.00,356.00,0.00,6013.41,1906250.97,1996113.96,89862.99,542911),('1','139','185693','330',317.00,356.00,0.00,4949.92,1569124.64,1640046.72,70922.08,543483),('1','139','185881','330',317.00,356.00,0.00,3577.60,1134099.20,1198954.40,64855.20,543988),('1','139','186100','330',317.00,356.00,0.00,2363.11,749105.87,786786.36,37680.49,544563),('1','139','186241','330',317.00,356.00,0.00,0.00,0.00,0.00,0.00,544951),('1','139','186276','330',315.00,356.00,0.00,1296.69,408457.35,435141.64,26684.29,545037),('1','139','186321','330',315.00,356.00,0.00,2841.05,894930.75,956545.00,61614.25,545142),('1','139','186534','330',315.00,356.00,0.00,5583.13,1758685.95,1849724.88,91038.93,545712),('1','139','186762','330',315.00,356.00,0.00,4233.74,1333628.10,1404169.44,70541.34,546294),('1','139','187007','330',315.00,356.00,0.00,3929.67,1237846.05,1302956.92,65110.87,546910),('1','139','187167','330',315.00,356.00,0.00,2026.02,638196.30,686787.12,48590.82,547343),('1','139','187359','330',315.00,356.00,0.00,4403.11,1386979.65,1446499.56,59519.91,547850),('1','139','187497','330',315.00,356.00,0.00,0.00,0.00,0.00,0.00,548223),('1','139','187507','330',315.00,356.00,0.00,2539.30,799879.50,848648.00,48768.50,548251),('1','139','187588','330',315.00,356.00,0.00,2623.35,826355.25,882183.60,55828.35,548449),('1','139','187834','330',315.00,356.00,0.00,8767.50,2761762.50,2882985.60,121223.10,549102),('1','139','188028','330',315.00,356.00,0.00,1744.83,549621.45,599379.48,49758.03,549607),('1','139','188226','330',315.00,356.00,0.00,7188.03,2264229.45,2381745.28,117515.83,550123),('1','139','188426','330',315.00,356.00,0.00,715.68,225439.20,243526.08,18086.88,550646),('1','139','188500','330',315.00,356.00,0.00,700.00,220500.00,228200.00,7700.00,550832),('1','139','188506','330',315.00,356.00,0.00,0.00,0.00,0.00,0.00,550844),('1','139','188835','330',315.00,356.00,0.00,4741.58,1493597.70,1579612.68,86014.98,551701),('1','139','189018','330',315.00,356.00,0.00,4314.23,1358982.45,1442067.48,83085.03,552183),('1','139','189204','330',315.00,356.00,0.00,6047.76,1905044.40,2008827.36,103782.96,552673),('1','139','189428','330',315.00,356.00,0.00,5684.76,1790699.40,1885725.36,95025.96,553260),('1','139','189627','330',315.00,356.00,0.00,3579.74,1127618.10,1169388.24,41770.14,553771),('1','139','189670','330',315.00,356.00,0.00,0.00,0.00,0.00,0.00,553884),('1','139','189687','330',315.00,356.00,0.00,4348.60,1369809.00,1449783.60,79974.60,553926),('1','139','189846','330',315.00,356.00,0.00,1236.43,389475.45,426153.08,36677.63,554326),('1','139','190033','330',315.00,356.00,0.00,2413.93,760387.95,816877.08,56489.13,554830),('1','139','190223','330',315.00,356.00,0.00,3468.61,1092612.15,1167589.16,74977.01,555323),('1','139','190448','330',315.00,356.00,0.00,6837.22,2153724.30,2267126.72,113402.42,555907),('1','139','190669','330',315.00,356.00,0.00,6065.08,1910500.20,1987746.48,77246.28,556506),('1','139','190744','330',315.00,356.00,0.00,0.00,0.00,0.00,0.00,556702),('1','139','190755','330',313.00,356.00,0.00,1258.55,393926.15,428476.60,34550.45,556731),('1','139','190897','330',313.00,356.00,0.00,5955.83,1864174.79,1961889.28,97714.49,557099),('1','139','191092','330',313.00,356.00,0.00,5732.61,1794306.93,1893248.36,98941.43,557602),('1','139','191300','330',313.00,356.00,0.00,7697.85,2409427.05,2538626.20,129199.15,558154),('1','139','191507','330',313.00,356.00,0.00,3661.73,1146121.49,1214959.88,68838.39,558699),('1','139','191722','330',313.00,356.00,0.00,0.00,0.00,0.00,0.00,559271),('1','139','191759','330',313.00,356.00,0.00,4487.40,1404556.20,1489402.40,84846.20,559368),('1','139','191944','330',313.00,356.00,0.00,2871.66,898829.58,965667.76,66838.18,559873),('1','139','192140','330',313.00,356.00,0.00,7096.05,2221063.65,2333586.20,112522.55,560387),('1','139','192346','330',313.00,356.00,0.00,1767.75,553305.75,609867.00,56561.25,560929),('1','139','192576','330',313.00,356.00,0.00,2177.10,681432.30,738860.00,57427.70,561521),('1','139','192782','330',313.00,356.00,0.00,5873.94,1838543.22,1939296.94,100753.72,562056),('1','139','192913','330',313.00,356.00,0.00,0.00,0.00,0.00,0.00,562419),('1','139','192986','330',313.00,356.00,0.00,2745.48,859335.24,927022.88,67687.64,562596),('1','139','193186','330',313.00,356.00,0.00,1733.06,542447.78,592110.16,49662.38,563128),('1','139','193411','330',313.00,356.00,0.00,3970.70,1242829.10,1328487.60,85658.50,563723),('1','139','193629','330',313.00,356.00,0.00,2598.06,813192.78,874302.96,61110.18,564292),('1','139','193863','330',313.00,356.00,0.00,2826.75,884772.75,950663.00,65890.25,564869),('1','139','194085','330',313.00,356.00,0.00,1482.51,464025.63,511069.56,47043.93,565428),('1','139','194312','330',313.00,356.00,0.00,3699.91,1158071.83,1244278.36,86206.53,566020),('1','139','194495','330',313.00,356.00,0.00,5004.91,1566536.83,1666516.76,99979.93,566478),('1','139','194652','330',313.00,356.00,0.00,0.00,0.00,0.00,0.00,566895),('1','139','194680','330',313.00,356.00,0.00,8111.26,2538824.38,2706872.16,168047.78,566949),('1','139','194870','330',313.00,356.00,0.00,6274.16,1963812.08,2082361.98,118549.90,567467),('1','139','195086','330',313.00,356.00,0.00,9640.32,3017420.16,3194842.92,177422.76,568020),('1','139','195316','330',313.00,356.00,0.00,665.22,208213.86,226942.32,18728.46,568609),('1','139','195502','330',313.00,356.00,0.00,0.00,0.00,0.00,0.00,569106),('1','139','195549','330',313.00,356.00,0.00,5784.76,1810629.88,1923495.56,112865.68,569202),('1','139','195789','330',313.00,356.00,0.00,3834.54,1200211.02,1290953.04,90742.02,569806),('1','139','196014','330',313.00,356.00,0.00,4477.36,1401413.68,1491227.16,89813.48,570381),('1','139','196254','330',313.00,356.00,0.00,6865.80,2148995.40,2270718.80,121723.40,570973),('1','139','196456','330',313.00,356.00,0.00,3639.74,1139238.62,1203471.04,64232.42,571505),('1','139','196564','330',313.00,356.00,0.00,0.00,0.00,0.00,0.00,571784),('1','139','196585','330',315.00,356.00,0.00,1769.43,557370.45,592881.08,35510.63,571842),('1','139','196667','330',315.00,356.00,0.00,4925.02,1551381.30,1635587.12,84205.82,572043),('1','139','196921','330',315.00,356.00,0.00,993.86,313065.90,337254.16,24188.26,572705),('1','139','197117','330',315.00,356.00,0.00,4760.56,1499576.40,1560619.90,61043.50,573220),('1','139','197347','330',315.00,356.00,0.00,2637.70,830875.50,883629.20,52753.70,573822),('1','139','197370','330',315.00,356.00,0.00,4168.15,1312967.25,1397581.40,84614.15,573851),('1','139','197514','330',315.00,356.00,0.00,5369.73,1691464.95,1788161.08,96696.13,574162),('1','139','197842','330',315.00,356.00,0.00,0.00,0.00,0.00,0.00,575049),('1','139','198083','330',306.00,356.00,0.00,4715.20,1442851.20,1565838.40,122987.20,575673),('1','139','198127','330',306.00,356.00,0.00,4666.20,1427857.20,1550207.20,122350.00,575774),('1','139','198365','330',306.00,356.00,0.00,3634.64,1112199.84,1213129.84,100930.00,576385),('1','139','198574','330',306.00,356.00,0.00,1362.07,416793.42,467316.92,50523.50,576941),('1','139','198790','330',306.00,356.00,0.00,3074.30,940735.80,1031458.80,90723.00,577466),('1','139','198996','330',306.00,356.00,0.00,2553.49,781367.94,860038.44,78670.50,578002),('1','139','199216','330',306.00,356.00,0.00,4600.45,1407737.70,1514808.20,107070.50,578555),('1','139','199374','330',306.00,356.00,0.00,0.00,0.00,0.00,0.00,578943),('1','139','199382','330',306.00,356.00,0.00,2010.40,615182.40,671214.40,56032.00,578962),('1','139','199438','330',306.00,356.00,0.00,4510.38,1380176.28,1500699.28,120523.00,579101),('1','139','199672','330',306.00,356.00,0.00,3901.62,1193895.72,1302300.72,108405.00,579677),('1','139','199880','330',306.00,356.00,0.00,3057.17,935494.02,1027117.32,91623.30,580187),('1','139','200109','330',306.00,356.00,0.00,2231.41,682811.46,756066.76,73255.30,580785),('1','139','200337','330',306.00,356.00,0.00,4646.24,1421749.44,1541781.44,120032.00,581377),('1','139','200500','330',306.00,356.00,0.00,2286.32,699613.92,776632.32,77018.40,581804),('1','139','200703','330',306.00,356.00,0.00,2040.65,624438.90,674729.80,50290.90,582338),('1','139','200803','330',306.00,356.00,0.00,0.00,0.00,0.00,0.00,582593),('1','139','200830','330',307.00,356.00,0.00,3329.01,1022006.07,1109078.76,87072.69,582669),('1','139','200942','330',307.00,356.00,0.00,7093.39,2177670.73,2355176.04,177505.31,582934),('1','139','201130','330',307.00,356.00,0.00,5633.24,1729404.68,1875602.68,146198.00,583414),('1','139','201323','330',307.00,356.00,0.00,3927.16,1205638.12,1311660.96,106022.84,583921),('1','139','201503','330',307.00,356.00,0.00,2580.90,792336.30,876087.00,83750.70,584394),('1','139','201772','330',307.00,356.00,0.00,2141.22,657354.54,721855.92,64501.38,585104),('1','139','201879','330',307.00,356.00,0.00,5003.86,1536185.02,1663467.76,127282.74,585388),('1','139','202035','330',307.00,356.00,0.00,2035.42,624873.94,701545.52,76671.58,585799),('1','139','202316','330',307.00,360.00,0.00,4317.37,1325432.59,1463483.20,138050.61,586524),('1','139','202443','330',307.00,360.00,0.00,5797.11,1779712.77,1952452.80,172740.03,586843),('1','139','202694','330',307.00,360.00,0.00,4648.25,1427012.75,1576429.60,149416.85,587479),('1','139','202861','330',307.00,360.00,0.00,2842.85,872754.95,951178.80,78423.85,587918),('1','139','202944','330',307.00,360.00,0.00,0.00,0.00,0.00,0.00,588129),('1','139','202946','330',317.00,360.00,0.00,2829.63,896992.71,955766.80,58774.09,588133),('1','139','203120','330',317.00,360.00,0.00,2982.18,945351.06,1028751.00,83399.94,588588),('1','139','203319','330',317.00,360.00,0.00,3674.05,1164673.85,1260882.00,96208.15,589116),('1','139','203534','330',317.00,360.00,0.00,3181.14,1008421.38,1092042.40,83621.02,589657),('1','139','203745','330',317.00,360.00,0.00,3410.89,1081252.13,1167480.40,86228.27,590200),('1','139','203976','330',317.00,360.00,0.00,1392.90,441549.30,488372.00,46822.70,590793),('1','139','204209','330',317.00,360.00,0.00,4305.53,1364853.01,1478170.80,113317.79,591405),('1','139','204412','330',317.00,360.00,0.00,2658.75,842823.75,892570.00,49746.25,591933),('1','139','204505','330',317.00,360.00,0.00,0.00,0.00,0.00,0.00,592175),('1','139','204512','330',317.00,360.00,0.00,2161.85,685306.45,744232.00,58925.55,592190),('1','139','204632','330',317.00,360.00,0.00,6902.86,2188206.62,2333776.80,145570.18,592494),('1','139','204875','330',317.00,360.00,0.00,7414.14,2350282.38,2502670.40,152388.02,593079),('1','139','205052','330',317.00,360.00,0.00,5578.47,1768374.99,1889335.00,120960.01,593532),('1','139','205265','330',317.00,360.00,0.00,2651.40,840493.80,898284.00,57790.20,594094),('1','139','205405','330',317.00,360.00,0.00,0.00,0.00,0.00,0.00,594461),('1','139','205416','330',317.00,360.00,0.00,1761.18,558294.06,605091.60,46797.54,594488),('1','139','205527','330',317.00,360.00,0.00,7534.83,2388541.11,2548188.80,159647.69,594758),('1','139','205733','330',317.00,360.00,0.00,4320.64,1369642.88,1480530.40,110887.52,595304),('1','139','205958','330',317.00,360.00,0.00,2513.45,796763.65,870542.00,73778.35,595880),('1','139','206157','330',317.00,360.00,0.00,3452.11,1094318.87,1186512.00,92193.13,596393),('1','139','206411','330',317.00,360.00,0.00,2729.17,865146.89,926921.20,61774.31,597035),('1','139','206498','330',317.00,360.00,0.00,0.00,0.00,0.00,0.00,597265),('1','139','206508','330',318.00,360.00,0.00,1403.59,446341.62,484392.40,38050.78,597291),('1','139','206582','330',318.00,360.00,0.00,3535.83,1124393.94,1218358.80,93964.86,597470),('1','139','206814','330',318.00,360.00,0.00,3159.46,1004708.28,1086165.60,81457.32,598070),('1','139','207036','330',318.00,360.00,0.00,5204.15,1654919.70,1770178.00,115258.30,598646),('1','139','207259','330',318.00,360.00,0.00,4115.15,1308617.70,1413595.20,104977.50,599224),('1','139','207483','330',318.00,360.00,0.00,6209.49,1974617.82,2099514.40,124896.58,599809),('1','139','207643','330',318.00,360.00,0.00,0.00,0.00,0.00,0.00,600219),('1','139','207654','330',326.00,360.00,0.00,762.30,248509.80,265888.00,17378.20,600246),('1','139','207721','330',326.00,368.00,0.00,2380.80,776140.80,852833.20,76692.40,600400),('1','139','207940','330',326.00,368.00,0.00,5440.02,1773446.52,1913595.36,140148.84,600960),('1','139','208117','330',326.00,368.00,0.00,2130.23,694454.98,765515.30,71060.32,601419),('1','139','208342','330',326.00,368.00,0.00,5242.87,1709175.62,1844393.96,135218.34,601996),('1','139','208549','330',326.00,368.00,0.00,3738.45,1218734.70,1320488.80,101754.10,602534),('1','139','208767','330',326.00,368.00,0.00,4895.52,1595939.52,1712403.96,116464.44,603090),('1','139','208954','330',326.00,368.00,0.00,0.00,0.00,0.00,0.00,603571),('1','139','209009','330',335.00,400.00,0.00,7455.25,2497508.75,2706517.00,209008.25,603692),('1','139','209253','330',335.00,400.00,0.00,5150.43,1725394.05,1906060.00,180665.95,604321),('1','139','209486','330',335.00,400.00,0.00,3940.98,1320228.30,1481182.70,160954.40,604917),('1','139','209665','330',335.00,400.00,0.00,2614.10,875723.50,987246.50,111523.00,605370),('1','139','209879','330',335.00,420.00,0.00,2389.70,800549.50,930419.80,129870.30,605926),('1','139','210137','330',335.00,420.00,0.00,3173.13,1062998.55,1195784.60,132786.05,606598),('1','139','210206','330',335.00,420.00,0.00,0.00,0.00,0.00,0.00,606772),('1','139','210574','330',335.00,420.00,0.00,5412.35,1948446.00,2067831.40,119385.40,607738),('1','139','210735','330',360.00,420.00,0.00,3855.68,1388044.80,1490163.38,102118.58,608166),('1','139','210961','330',360.00,420.00,0.00,5055.03,1819810.80,1937845.60,118034.80,608745),('1','139','211173','330',360.00,430.00,0.00,4258.00,1532880.00,1652428.00,119548.00,609291),('1','139','211429','330',360.00,430.00,0.00,6016.54,2165954.40,2390796.20,224841.80,609957),('1','139','211667','330',360.00,430.00,0.00,0.00,0.00,0.00,0.00,610570),('1','139','211684','330',378.00,430.00,0.00,2450.77,926391.06,972434.70,46043.64,610607),('1','139','211822','330',378.00,430.00,0.00,3403.70,1286598.60,1373621.00,87022.40,610961),('1','139','212003','330',378.00,430.00,0.00,2352.30,889169.40,949350.60,60181.20,611434),('1','139','212241','330',378.00,430.00,0.00,4448.80,1681646.40,1784210.80,102564.40,612053),('1','139','212463','330',378.00,430.00,0.00,5070.74,1916739.72,2029391.40,112651.68,612642),('1','139','212676','330',378.00,430.00,0.00,3702.32,1399476.96,1478443.20,78966.24,613209),('1','139','212889','330',378.00,430.00,0.00,3219.29,1216891.62,1272380.70,55489.08,613758),('1','139','213033','330',378.00,430.00,0.00,0.00,0.00,0.00,0.00,614154),('1','139','213141','330',378.00,430.00,0.00,6616.24,2500938.72,2635927.20,134988.48,614420),('1','139','213399','330',378.00,430.00,0.00,4833.41,1827028.98,1931980.38,104951.40,615080),('1','139','213639','330',378.00,430.00,0.00,3897.62,1473300.36,1572488.60,99188.24,615726),('1','139','213896','330',378.00,430.00,0.00,2330.74,881019.72,947802.60,66782.88,616398),('1','139','214150','330',378.00,430.00,0.00,6881.47,2601195.66,2704133.38,102937.72,617058),('1','139','214288','330',378.00,430.00,0.00,0.00,0.00,0.00,0.00,617424),('1','139','214354','330',378.00,430.00,0.00,3247.36,1227502.08,1305379.60,77877.52,617585),('1','139','214545','330',378.00,430.00,0.00,9264.57,3502007.46,3672349.10,170341.64,618077),('1','139','214785','330',378.00,430.00,0.00,12042.26,4551974.28,4758090.06,206115.78,618705),('1','139','215324','330',378.00,430.00,0.00,8218.59,3106627.02,3352714.54,246087.52,620108),('1','139','215453','330',378.00,446.00,0.00,8982.68,3395453.04,3684906.48,289453.44,620421),('1','139','215685','330',378.00,446.00,0.00,4569.44,1727248.32,1901865.84,174617.52,621028),('1','139','215921','330',378.00,446.00,0.00,2753.03,1040645.34,1143516.58,102871.24,621629),('1','139','216060','330',378.00,446.00,0.00,0.00,0.00,0.00,0.00,622003),('1','139','216113','330',378.00,446.00,0.00,2772.42,1047974.76,1170069.62,122094.86,622133),('1','139','216337','330',378.00,446.00,0.00,5114.84,1933409.52,2127349.14,193939.62,622712),('1','139','216563','330',378.00,446.00,0.00,3350.61,1266530.58,1403765.46,137234.88,623312),('1','139','216799','330',378.00,446.00,0.00,4035.86,1525555.08,1688696.56,163141.48,623932),('1','139','217032','330',378.00,446.00,0.00,6612.88,2499668.64,2738912.88,239244.24,624541),('1','139','217285','330',378.00,446.00,0.00,2425.30,916763.40,993354.80,76591.40,625208),('1','139','217465','330',378.00,446.00,0.00,0.00,0.00,0.00,0.00,625695),('1','139','217860','330',423.00,464.00,0.00,2466.13,1043172.99,1095482.72,52309.73,626721),('1','139','217994','330',423.00,464.00,0.00,3448.79,1458838.17,1529418.56,70580.39,627063),('1','139','218235','330',423.00,464.00,0.00,4536.30,1918854.90,1997366.40,78511.50,627699),('1','139','218443','330',423.00,464.00,0.00,4195.32,1774620.36,1854308.48,79688.12,628256),('1','139','218690','330',423.00,464.00,0.00,5326.92,2253287.16,2349470.88,96183.72,628883),('1','139','218915','330',423.00,464.00,0.00,4404.22,1862985.06,1925786.08,62801.02,629474),('1','139','219049','330',423.00,464.00,0.00,0.00,0.00,0.00,0.00,629830),('1','139','219074','330',464.00,464.00,0.00,2301.45,1067872.80,1036332.80,-31540.00,629898),('1','139','219338','330',464.00,464.00,0.00,4956.07,2299616.48,2189136.48,-110480.00,630583),('1','139','219606','330',464.00,464.00,0.00,2506.50,1163016.00,1129399.20,-33616.80,631282),('1','139','219818','330',464.00,464.00,0.00,2512.55,1165823.20,1125550.32,-40272.88,631836),('1','139','220045','330',464.00,464.00,0.00,3419.53,1586661.92,1529175.84,-57486.08,632451),('1','139','220270','330',464.00,464.00,0.00,4490.21,2083457.44,1997969.44,-85488.00,633033),('1','139','220528','330',464.00,464.00,0.00,4374.24,2029647.36,1932047.36,-97600.00,633717),('1','139','220775','330',464.00,464.00,0.00,0.00,0.00,0.00,0.00,634356),('1','139','220788','330',423.00,464.00,0.00,3057.40,1293280.20,1354973.60,61693.40,634389),('1','139','220924','330',423.00,464.00,0.00,5876.80,2485886.40,2592275.20,106388.80,634742),('1','139','221154','330',423.00,464.00,0.00,5668.39,2397728.97,2504633.76,106904.79,635332),('1','139','221406','330',423.00,464.00,0.00,5538.56,2342810.88,2449558.24,106747.36,635994),('1','139','221625','330',423.00,464.00,0.00,4373.61,1850037.03,1917467.04,67430.01,636570),('1','139','221713','330',423.00,464.00,0.00,0.00,0.00,0.00,0.00,636807),('1','139','221794','330',424.00,464.00,0.00,1710.72,725345.28,769155.84,43810.56,637026),('1','139','221850','330',424.00,464.00,0.00,4754.38,2015857.12,2113885.32,98028.20,637150),('1','139','222066','330',424.00,464.00,0.00,7540.21,3197049.04,3324889.44,127840.40,637723),('1','139','222279','330',424.00,464.00,0.00,3420.38,1450241.12,1534870.32,84629.20,638262),('1','139','222511','330',424.00,464.00,0.00,7215.54,3059388.96,3176146.56,116757.60,638856),('1','139','223110','330',424.00,464.00,0.00,0.00,0.00,0.00,0.00,640470),('1','139','223118','330',435.00,474.00,0.00,2357.04,1025312.40,1063068.96,37756.56,640492),('1','139','223187','330',435.00,474.00,0.00,5380.27,2340417.45,2443043.98,102626.53,640639),('1','139','223423','330',435.00,474.00,0.00,8992.92,3911920.20,4081263.28,169343.08,641222),('1','139','223646','330',435.00,480.00,0.00,3408.49,1482693.15,1586201.12,103507.97,641790),('1','139','223879','330',435.00,480.00,0.00,4545.42,1977257.70,2059988.40,82730.70,642391),('1','139','224146','330',435.00,480.00,0.00,0.00,0.00,0.00,0.00,643078),('1','139','224165','330',453.00,504.00,0.00,8667.52,3926386.56,4014488.64,88102.08,643128),('1','139','224336','330',453.00,516.00,0.00,4137.88,1874459.64,2048786.68,174327.04,643566),('1','139','224533','330',453.00,516.00,0.00,2318.83,1050429.99,1152671.28,102241.29,644100),('1','139','224783','330',453.00,516.00,0.00,1677.55,759930.15,841704.80,81774.65,644732),('1','139','225026','330',453.00,516.00,0.00,7814.49,3539963.97,3812766.84,272802.87,645355),('1','139','225129','330',453.00,516.00,0.00,0.00,0.00,0.00,0.00,645633),('1','139','225184','330',475.00,516.00,0.00,1009.44,479484.00,457400.24,-22083.76,645779),('1','139','225274','330',475.00,516.00,0.00,3743.41,1778119.75,1843864.76,65745.01,645994),('1','139','225486','330',475.00,516.00,0.00,2700.52,1282747.00,1341517.52,58770.52,646550),('1','139','225703','330',475.00,516.00,0.00,3182.63,1511749.25,1572142.08,60392.83,647108),('1','139','225984','330',475.00,516.00,0.00,4106.40,1950540.00,2027967.00,77427.00,647845),('1','139','226231','330',475.00,516.00,0.00,4043.87,1920838.25,1997595.60,76757.35,648494),('1','139','226491','330',475.00,516.00,0.00,5761.18,2736560.50,2818482.68,81922.18,649142),('1','139','226648','330',475.00,516.00,0.00,0.00,0.00,0.00,0.00,649572),('1','139','226735','330',475.00,516.00,0.00,8814.95,4187101.25,4308841.20,121739.95,649784),('1','139','227026','330',475.00,516.00,0.00,5340.02,2536509.50,2628875.72,92366.22,650544),('1','139','227192','330',475.00,516.00,0.00,3805.72,1807717.00,1879807.52,72090.52,650974),('1','139','227381','330',475.00,516.00,0.00,4482.48,2129178.00,2217264.20,88086.20,651452),('1','139','227615','330',475.00,516.00,0.00,2177.08,1034113.00,1060324.48,26211.48,652057),('1','139','227756','330',475.00,516.00,0.00,0.00,0.00,0.00,0.00,652429),('1','139','227832','330',475.00,534.00,0.00,2038.10,968097.50,1060707.40,92609.90,652638),('1','139','228320','330',475.00,534.00,0.00,3396.90,1613527.50,1744512.60,130985.10,653927),('1','139','228325','330',475.00,534.00,0.00,6297.50,2991312.50,3218788.00,227475.50,653936),('1','139','228357','330',475.00,534.00,0.00,5994.67,2847468.25,3065045.78,217577.53,653995),('1','139','228539','330',475.00,534.00,0.00,4379.34,2080186.50,2250555.76,170369.26,654452),('1','139','228757','330',475.00,534.00,0.00,2424.20,1151495.00,1252766.80,101271.80,655019),('1','139','228919','330',475.00,534.00,0.00,0.00,0.00,0.00,0.00,655442),('1','139','228951','330',492.00,534.00,0.00,7901.34,3887459.28,4048452.76,160993.48,655507),('1','139','229174','330',492.00,534.00,0.00,12625.02,6211509.84,6447502.68,235992.84,656102),('1','139','229485','330',492.00,584.00,0.00,4182.17,2057627.64,2263897.48,206269.84,656896),('1','139','229633','330',492.00,584.00,0.00,0.00,0.00,0.00,0.00,657297),('1','139','229670','330',518.00,584.00,0.00,13194.61,6834807.98,7134424.24,299616.26,657372),('1','139','229910','330',518.00,584.00,0.00,7557.95,3915018.10,4094928.80,179910.70,657982),('1','139','230098','330',518.00,584.00,0.00,3951.40,2046825.20,2153774.60,106949.40,658468),('1','139','230455','330',518.00,584.00,0.00,6370.81,3300079.58,3427457.04,127377.46,659411),('1','139','230539','330',518.00,584.00,0.00,9121.14,4724750.52,4942914.76,218164.24,659608),('1','139','230796','330',518.00,584.00,0.00,5767.34,2987482.12,3128396.16,140914.04,660271),('1','139','231076','330',518.00,584.00,0.00,1757.17,910214.06,967829.28,57615.22,661022),('1','139','231379','330',518.00,584.00,0.00,1664.04,861972.72,896871.96,34899.24,661835),('1','139','231805','330',518.00,584.00,0.00,0.00,0.00,0.00,0.00,662977),('1','139','231910','330',550.00,600.00,0.00,6434.49,3538969.50,3665226.80,126257.30,663246),('1','139','232109','330',550.00,600.00,0.00,3782.06,2080133.00,2166071.20,85938.20,663780),('1','139','232352','330',550.00,600.00,0.00,5759.07,3167488.50,3282683.44,115194.94,664402),('1','139','232602','330',550.00,600.00,0.00,5932.31,3262770.50,3389818.00,127047.50,665066),('1','139','232862','330',550.00,600.00,0.00,2766.19,1521404.50,1575948.40,54543.90,665754),('1','139','233287','330',550.00,600.00,0.00,0.00,0.00,0.00,0.00,666881),('1','139','233396','330',550.00,600.00,0.00,5920.21,3256115.50,3426589.44,170473.94,667156),('1','139','233623','330',550.00,624.00,0.00,4205.50,2313025.00,2492114.00,179089.00,667742),('1','139','233857','330',550.00,624.00,0.00,1630.76,896918.00,983034.24,86116.24,668354),('1','139','234069','330',550.00,624.00,0.00,2466.66,1356663.00,1467081.04,110418.04,668918),('1','139','234322','330',550.00,624.00,0.00,3322.14,1827177.00,1974049.36,146872.36,669586),('1','139','234572','330',550.00,624.00,0.00,6953.58,3824469.00,4083099.92,258630.92,670260),('1','139','234773','330',550.00,624.00,0.00,0.00,0.00,0.00,0.00,670802),('1','139','234844','330',550.00,624.00,0.00,1934.31,1063870.50,1163483.28,99612.78,670970),('1','139','235080','330',550.00,624.00,0.00,2006.47,1103558.50,1205111.28,101552.78,671618),('1','139','235376','330',550.00,624.00,0.00,2858.77,1572323.50,1699625.68,127302.18,672379),('1','139','235548','330',550.00,624.00,0.00,4023.39,2212864.50,2380895.36,168030.86,672815),('1','139','235770','330',550.00,624.00,0.00,3252.96,1789128.00,1931411.04,142283.04,673393),('1','139','236043','330',550.00,624.00,0.00,6407.43,3524086.50,3757278.88,233192.38,674113),('1','139','236246','330',550.00,624.00,0.00,3764.74,2070607.00,2215809.76,145202.76,674651),('1','139','236615','330',550.00,624.00,0.00,0.00,0.00,0.00,0.00,675622),('1','139','236623','330',580.00,624.00,0.00,5984.38,3470940.40,3570240.28,99299.88,675642),('1','139','236751','330',580.00,635.00,0.00,8451.11,4901643.80,5040630.85,138987.05,675966),('1','139','236975','330',580.00,635.00,0.00,9103.76,5280180.80,5433195.60,153014.80,676552),('1','139','237236','330',580.00,635.00,0.00,1128.00,654240.00,674480.00,20240.00,677219),('1','139','237242','330',580.00,635.00,0.00,0.00,0.00,0.00,0.00,677233),('1','139','237406','330',580.00,635.00,0.00,5309.73,3079643.40,3183838.55,104195.15,677655),('1','139','237628','330',580.00,656.00,0.00,10716.84,6215767.20,6528793.20,313026.00,678236),('1','139','237887','330',580.00,656.00,0.00,5346.95,3101231.00,3335442.96,234211.96,678910),('1','139','238123','330',580.00,656.00,0.00,3288.37,1907254.60,2040958.52,133703.92,679528),('1','139','238251','330',580.00,656.00,0.00,0.00,0.00,0.00,0.00,679855),('1','139','238275','330',594.00,656.00,0.00,1665.49,989301.06,1056507.44,67206.38,679914),('1','139','238363','330',594.00,656.00,0.00,6483.99,3851490.06,3978565.44,127075.38,680134),('1','139','238614','330',594.00,656.00,0.00,4859.12,2886317.28,3032610.68,146293.40,680795),('1','139','238840','330',594.00,656.00,0.00,2954.21,1754800.74,1854250.92,99450.18,681381),('1','139','239076','330',594.00,656.00,0.00,5408.94,3212910.36,3372976.64,160066.28,681988),('1','139','239307','330',594.00,656.00,0.00,3239.89,1924494.66,2011239.84,86745.18,682589),('1','139','239441','330',594.00,656.00,0.00,0.00,0.00,0.00,0.00,682953),('1','139','239445','330',594.00,656.00,0.00,2088.23,1240408.62,1316958.88,76550.26,682961),('1','139','239544','330',594.00,656.00,0.00,2652.02,1575299.88,1678391.52,103091.64,683206),('1','139','239787','330',594.00,656.00,0.00,4979.14,2957609.16,3097922.64,140313.48,683843),('1','139','240000','330',594.00,656.00,0.00,5600.29,3326572.26,3483086.24,156513.98,684393),('1','139','240208','330',594.00,656.00,0.00,5909.33,3510142.02,3604427.28,94285.26,684934),('1','139','240463','330',594.00,656.00,0.00,2206.64,1310744.16,1392904.64,82160.48,685599),('1','139','240708','330',594.00,656.00,0.00,1236.44,734445.36,773664.64,39219.28,686190),('1','139','240791','330',594.00,656.00,0.00,0.00,0.00,0.00,0.00,686405),('1','139','240794','330',594.00,656.00,0.00,1167.70,693613.80,740505.20,46891.40,686413),('1','139','240982','330',594.00,656.00,0.00,5001.10,2970653.40,3120917.60,150264.20,686927),('1','139','241236','330',594.00,656.00,0.00,2208.59,1311902.46,1400955.04,89052.58,687589),('1','139','241504','330',594.00,656.00,0.00,2356.82,1399951.08,1483275.52,83324.44,688307),('1','139','241752','330',594.00,656.00,0.00,1691.63,1004828.22,1074645.28,69817.06,688964),('1','139','242043','330',594.00,656.00,0.00,3424.68,2034259.92,2138850.48,104590.56,689713),('1','139','242219','330',594.00,640.00,0.00,2488.91,1478412.54,1540687.40,62274.86,690177),('1','139','242451','330',594.00,640.00,0.00,2904.76,1725427.44,1794221.40,68793.96,690764),('1','139','242698','330',594.00,640.00,0.00,3270.10,1942439.40,1995689.00,53249.60,691410),('1','139','242793','330',594.00,640.00,0.00,0.00,0.00,0.00,0.00,691661),('1','139','242796','330',594.00,640.00,0.00,2126.78,1259053.76,1307057.20,48003.44,691668),('1','139','242940','330',592.00,640.00,0.00,8686.58,5142455.36,5284521.20,142065.84,692041),('1','139','243154','330',592.00,640.00,0.00,5142.82,3044549.44,3149198.80,104649.36,692604),('1','139','243379','330',592.00,640.00,0.00,7353.19,4353088.48,4469887.60,116799.12,693202),('1','139','243605','330',592.00,640.00,0.00,1362.38,806528.96,831740.30,25211.34,693781),('1','139','243694','330',592.00,640.00,0.00,0.00,0.00,0.00,0.00,694005),('1','139','244154','330',592.00,640.00,0.00,4025.88,2383320.96,2469353.20,86032.24,695190),('1','139','244304','330',592.00,640.00,0.00,4652.67,2754380.64,2866856.20,112475.56,695594),('1','139','244525','330',592.00,640.00,0.00,5989.18,3545594.56,3680525.20,134930.64,696163),('1','139','244752','330',592.00,640.00,0.00,3670.72,2173066.24,2254930.80,81864.56,696762),('1','139','244982','330',592.00,640.00,0.00,5713.67,3382492.64,3238474.52,-144018.12,697359),('1','139','245219','330',592.00,632.00,0.00,524.96,310776.32,321019.72,10243.40,697967),('1','139','245438','330',592.00,632.00,0.00,0.00,0.00,0.00,0.00,698534),('1','139','245492','330',564.00,632.00,0.00,2321.94,1309574.16,1422222.08,112647.92,698664),('1','139','245680','330',564.00,632.00,0.00,7895.61,4453124.04,4749117.52,295993.48,699159),('1','139','245941','330',564.00,616.00,0.00,6104.85,3443135.40,3561527.60,118392.20,699839),('1','139','246195','330',564.00,616.00,0.00,2769.52,1562009.28,1631824.32,69815.04,700486),('1','139','246462','330',564.00,616.00,0.00,5539.05,3124024.20,3217072.80,93048.60,701198),('1','139','246651','330',564.00,616.00,0.00,0.00,0.00,0.00,0.00,701709),('1','139','246713','330',548.00,616.00,0.00,4726.48,2590111.04,2735459.68,145348.64,701853),('1','139','246936','330',548.00,616.00,0.00,3703.32,2029419.36,2171483.12,142063.76,702433),('1','139','247174','330',548.00,616.00,0.00,3630.08,1989283.84,2133845.28,144561.44,703045),('1','139','247405','330',548.00,616.00,0.00,4872.19,2669960.12,2810995.44,141035.32,703624),('1','139','247669','330',548.00,616.00,0.00,6023.59,3300927.32,3515585.04,214657.72,704328),('1','139','247919','330',548.00,616.00,0.00,1670.25,915297.00,971634.00,56337.00,704969),('1','139','248003','330',548.00,616.00,0.00,0.00,0.00,0.00,0.00,705172),('1','139','248063','330',548.00,616.00,0.00,448.38,245712.24,267655.32,21943.08,705342),('1','139','248165','330',548.00,616.00,0.00,3494.93,1915221.64,2052668.88,137447.24,705602),('1','139','248413','330',548.00,616.00,0.00,5660.88,3102162.24,3312154.08,209991.84,706246),('1','139','248648','330',548.00,616.00,0.00,1874.72,1027346.56,1116191.52,88844.96,706843),('1','139','248862','330',548.00,592.00,0.00,1328.45,727990.60,749708.40,21717.80,707401),('1','139','249113','330',548.00,592.00,0.00,1864.95,1021992.60,1044570.40,22577.80,708040),('1','139','249348','330',548.00,592.00,0.00,1996.09,1093857.32,1118033.28,24175.96,708638),('1','139','249600','330',548.00,592.00,0.00,2902.56,1590602.88,1618059.12,27456.24,709283),('1','139','249866','330',548.00,592.00,0.00,3018.21,1653979.08,1679215.32,25236.24,709963),('1','139','250112','330',548.00,592.00,0.00,1916.88,1050450.24,1056556.96,6106.72,710592),('1','139','250205','330',548.00,592.00,0.00,0.00,0.00,0.00,0.00,710832),('1','139','250245','330',530.00,592.00,0.00,1368.60,725358.00,772012.20,46654.20,710940),('1','139','250354','330',530.00,592.00,0.00,2375.64,1259089.20,1335094.88,76005.68,711205),('1','139','250576','330',530.00,592.00,0.00,2640.44,1399433.20,1484674.48,85241.28,711767),('1','139','250823','330',530.00,592.00,0.00,5322.04,2820681.20,2956521.08,135839.88,712407),('1','139','251042','330',530.00,592.00,0.00,8207.13,4349778.90,4512576.96,162798.06,712980),('1','139','251292','330',530.00,592.00,0.00,4606.03,2441195.90,2529474.76,88278.86,713628),('1','139','251677','330',530.00,592.00,0.00,0.00,0.00,0.00,0.00,714650),('1','139','251683','330',517.00,580.00,0.00,1180.47,610302.99,649168.60,38865.61,714665),('1','139','251784','330',517.00,580.00,0.00,5466.00,2825922.00,2962320.00,136398.00,714918),('1','139','252011','330',517.00,580.00,0.00,9797.57,5065343.69,5254290.60,188946.91,715515),('1','139','252257','330',517.00,580.00,0.00,2258.37,1167577.29,1255322.60,87745.31,716158),('1','139','252492','330',517.00,580.00,0.00,4684.04,2421648.68,2565395.20,143746.52,716767),('1','139','252733','330',517.00,580.00,0.00,1308.79,676644.43,715810.20,39165.77,717391),('1','139','252820','330',517.00,580.00,0.00,0.00,0.00,0.00,0.00,717611),('1','139','252841','330',520.00,580.00,0.00,2863.21,1488869.20,1559773.80,70904.60,717671),('1','139','252986','330',520.00,580.00,0.00,6198.82,3223386.40,3366531.60,143145.20,718047),('1','139','253227','330',520.00,580.00,0.00,9181.73,4774499.60,4942435.40,167935.80,718677),('1','139','253495','330',520.00,580.00,0.00,4487.44,2333468.80,2439947.20,106478.40,719372),('1','139','253730','330',520.00,580.00,0.00,1726.50,897780.00,939734.00,41954.00,719973),('1','139','253896','330',520.00,580.00,0.00,0.00,0.00,0.00,0.00,720429),('1','139','254005','330',520.00,608.00,0.00,3372.17,1753528.40,1945627.94,192099.54,720695),('1','139','254228','330',520.00,608.00,0.00,4364.77,2269680.40,2511412.34,241731.94,721267),('1','139','254464','330',520.00,608.00,0.00,5523.43,2872183.60,3162982.44,290798.84,721883),('1','139','254718','330',520.00,608.00,0.00,3502.20,1821144.00,2020392.60,199248.60,722525),('1','139','254969','330',520.00,608.00,0.00,2988.24,1553884.80,1725626.32,171741.52,723166),('1','139','255199','330',520.00,608.00,0.00,3705.19,1926698.80,2143689.92,216991.12,723766),('1','139','255491','330',520.00,608.00,0.00,1239.71,644649.20,712812.68,68163.48,724476),('1','139','255555','330',520.00,608.00,0.00,0.00,0.00,0.00,0.00,724623),('1','139','255564','330',520.00,608.00,0.00,2267.83,1179271.60,1248001.40,68729.80,724646),('1','139','255720','330',520.00,580.00,0.00,2597.80,1350856.00,1431444.00,80588.00,725060),('1','139','255966','330',520.00,580.00,0.00,4442.06,2309871.20,2416394.80,106523.60,725678),('1','139','256231','330',520.00,580.00,0.00,4047.79,2104850.80,2209477.80,104627.00,726328),('1','139','256503','330',520.00,580.00,0.00,7031.65,3656458.00,3785410.60,128952.60,727043),('1','139','256738','330',520.00,580.00,0.00,4167.04,2166860.80,2269360.40,102499.60,727646),('1','139','256905','330',520.00,580.00,0.00,0.00,0.00,0.00,0.00,728102),('1','139','256985','330',520.00,580.00,0.00,8360.55,4347486.00,4487979.00,140493.00,728294),('1','139','257292','330',520.00,580.00,0.00,4961.77,2580120.40,2695830.60,115710.20,729094),('1','139','257505','330',520.00,580.00,0.00,4044.07,2102916.40,2211558.20,108641.80,729657),('1','139','257506','330',520.00,580.00,0.00,3940.86,2049247.20,2155058.80,105811.60,729658),('1','139','257507','330',520.00,580.00,0.00,3309.51,1720945.20,1819615.80,98670.60,729659),('1','139','257508','330',520.00,580.00,0.00,0.00,0.00,0.00,0.00,729660),('1','139','257509','330',503.00,560.00,0.00,1766.19,888393.57,925226.40,36832.83,729661),('1','139','257510','330',503.00,560.00,0.00,8781.33,4417008.99,4587920.80,170911.81,729662),('1','139','257511','330',503.00,560.00,0.00,2847.79,1432438.37,1520634.40,88196.03,729663),('1','139','257512','330',503.00,560.00,0.00,6660.45,3350206.35,3486300.00,136093.65,729664),('1','139','257513','330',503.00,560.00,0.00,4620.84,2324282.52,2422690.40,98407.88,729665),('1','139','257514','330',503.00,560.00,0.00,0.00,0.00,0.00,0.00,729666),('1','139','257515','330',503.00,560.00,0.00,6165.60,3101296.80,3221156.00,119859.20,729667),('1','139','257516','330',503.00,560.00,0.00,2708.59,1362420.77,1439878.40,77457.63,729668),('1','139','257517','330',503.00,560.00,0.00,3760.99,1891777.97,1979898.40,88120.43,729669),('1','139','257518','330',503.00,560.00,0.00,4451.68,2239195.04,2340180.80,100985.76,729670),('1','139','257519','330',503.00,560.00,0.00,3027.73,1522948.19,1606488.80,83540.61,729671),('1','139','257520','330',503.00,560.00,0.00,3348.47,1684280.41,1775515.20,91234.79,729672),('1','139','257521','330',503.00,560.00,0.00,2092.52,1052537.56,1100291.20,47753.64,729673),('1','139','257522','330',503.00,560.00,0.00,0.00,0.00,0.00,0.00,729674),('1','139','257523','330',519.00,576.00,0.00,996.97,517427.43,530014.72,12587.29,729675),('1','139','257524','330',519.00,576.00,0.00,4168.71,2163560.49,2251605.56,88045.07,729676),('1','139','257525','330',519.00,576.00,0.00,2500.96,1297998.24,1360476.96,62478.72,729677),('1','139','257526','330',519.00,576.00,0.00,3085.62,1601436.78,1672030.70,70593.92,729678),('1','139','257527','330',519.00,576.00,0.00,3026.27,1570634.13,1648955.52,78321.39,729679),('1','139','257528','330',519.00,576.00,0.00,2656.19,1378562.61,1446342.44,67779.83,729680),('1','139','257529','330',519.00,576.00,0.00,3109.16,1613654.04,1684677.44,71023.40,729681),('1','139','257530','330',519.00,576.00,0.00,3699.05,1919806.95,1995638.80,75831.85,729682),('1','139','257531','330',519.00,576.00,0.00,1188.35,616753.65,637669.60,20915.95,729683),('1','139','257532','330',519.00,576.00,0.00,0.00,0.00,0.00,0.00,729684),('1','139','257533','330',523.00,576.00,0.00,2688.02,1405834.46,1475208.00,69373.54,729685),('1','139','257534','330',523.00,600.00,0.00,1707.74,893148.02,943019.60,49871.58,729686),('1','139','257535','330',523.00,580.00,0.00,2352.11,1230153.53,1293991.80,63838.27,729687),('1','139','257536','330',523.00,580.00,0.00,1781.81,931886.63,992969.80,61083.17,729688),('1','139','257537','330',523.00,580.00,0.00,1978.12,1034556.76,1099709.60,65152.84,729689),('1','139','257538','330',523.00,580.00,0.00,4298.40,2248063.20,2346572.00,98508.80,729690),('1','139','257539','330',523.00,580.00,0.00,5032.74,2632123.02,2733718.80,101595.78,729691),('1','139','257540','330',523.00,580.00,0.00,1970.29,1030461.67,1087548.20,57086.53,729692),('1','139','257541','330',523.00,580.00,0.00,2650.00,1385950.00,1439480.00,53530.00,729693),('1','139','257542','330',523.00,580.00,0.00,0.00,0.00,0.00,0.00,729694),('1','139','257543','330',523.00,580.00,0.00,780.82,408368.86,434435.60,26066.74,729695),('1','139','257544','330',523.00,580.00,0.00,3988.86,2086173.78,2179398.80,93225.02,729696),('1','139','257545','330',523.00,580.00,0.00,3154.51,1649808.73,1730375.80,80567.07,729697),('1','139','257546','330',523.00,580.00,0.00,3796.55,1985595.65,2071759.00,86163.35,729698),('1','139','257547','330',523.00,580.00,0.00,2565.09,1341542.07,1414412.20,72870.13,729699),('1','139','257548','330',523.00,580.00,0.00,4509.45,2358442.35,2462781.00,104338.65,729700),('1','139','257549','330',523.00,640.00,0.00,2907.95,1520857.85,1677948.00,157090.15,729701),('1','139','257550','330',523.00,640.00,0.00,1997.89,1044896.47,1248949.60,204053.13,729702),('1','139','257551','330',523.00,640.00,0.00,812.22,424791.06,507710.80,82919.74,729703),('1','139','257552','330',523.00,640.00,0.00,0.00,0.00,0.00,0.00,729704),('1','139','257553','330',598.00,640.00,0.00,3675.80,2198128.40,2280792.00,82663.60,729705),('1','139','257554','330',598.00,640.00,0.00,2656.35,1588497.30,1659984.00,71486.70,729706),('1','139','257555','330',598.00,680.00,0.00,5104.82,3052682.36,3266807.60,214125.24,729707),('1','139','257556','330',598.00,680.00,0.00,2788.62,1667594.76,1803353.60,135758.84,729708),('1','139','257557','330',598.00,680.00,0.00,3775.64,2257832.72,2434235.20,176402.48,729709),('1','139','257558','330',598.00,680.00,0.00,2832.86,1694050.28,1833232.80,139182.52,729710),('1','139','257559','330',598.00,680.00,0.00,3845.32,2299501.36,2464267.60,164766.24,729711),('1','139','257560','330',598.00,680.00,0.00,0.00,0.00,0.00,0.00,729712),('1','139','257561','330',598.00,680.00,0.00,1790.81,1070904.38,1140614.60,69710.22,729713),('1','139','257562','330',598.00,660.00,0.00,3714.68,2221378.64,2330728.80,109350.16,729714),('1','139','257563','330',598.00,660.00,0.00,2533.86,1515248.28,1596387.60,81139.32,729715),('1','139','257564','330',598.00,660.00,0.00,2691.44,1609481.12,1696550.40,87069.28,729716),('1','139','257565','330',598.00,660.00,0.00,3059.83,1829778.34,1911587.80,81809.46,729717),('1','139','257566','330',598.00,660.00,0.00,3506.79,2097060.42,2198309.40,101248.98,729718),('1','139','257567','330',598.00,660.00,0.00,1284.34,768035.32,822944.40,54909.08,729719),('1','139','257568','330',598.00,680.00,0.00,2099.54,1255524.92,1354252.20,98727.28,729720),('1','139','257569','330',598.00,680.00,0.00,4046.23,2419645.54,2562006.40,142360.86,729721),('1','139','257570','330',598.00,680.00,0.00,0.00,0.00,0.00,0.00,729722),('1','139','257571','330',598.00,680.00,0.00,3087.72,1846456.56,1973179.60,126723.04,729723),('1','139','257572','330',598.00,680.00,0.00,3238.20,1936443.60,2063171.00,126727.40,729724),('1','139','257573','330',598.00,680.00,0.00,2477.32,1481437.36,1593507.60,112070.24,729725),('1','139','257574','330',598.00,680.00,0.00,5448.64,3258286.72,3474420.20,216133.48,729726),('1','139','257575','330',598.00,680.00,0.00,5224.99,3124544.02,3352968.20,228424.18,729727),('1','139','257576','330',598.00,680.00,0.00,2028.71,1213168.58,1321212.80,108044.22,729728),('1','139','257577','330',598.00,680.00,0.00,3154.76,1886546.48,1985126.80,98580.32,729729),('1','139','257578','330',598.00,680.00,0.00,0.00,0.00,0.00,0.00,729730),('1','139','257579','330',600.00,680.00,0.00,1325.57,795342.00,857522.60,62180.60,729731),('1','139','257580','330',600.00,680.00,0.00,3464.86,2078916.00,2230514.80,151598.80,729732),('1','139','257581','330',600.00,680.00,0.00,3930.99,2358594.00,2510223.20,151629.20,729733),('1','139','257582','330',600.00,680.00,0.00,4596.63,2757978.00,2926723.40,168745.40,729734),('1','139','257583','330',600.00,680.00,0.00,3109.87,1865922.00,1994951.60,129029.60,729735),('1','139','257584','330',600.00,680.00,0.00,4245.32,2547192.00,2730627.60,183435.60,729736),('1','139','257585','330',600.00,680.00,0.00,3949.68,2369808.00,2505917.40,136109.40,729737),('1','139','257586','330',600.00,680.00,0.00,0.00,0.00,0.00,0.00,729738),('1','139','257587','330',600.00,680.00,0.00,5777.27,3466362.00,3654588.60,188226.60,729739),('1','139','257588','330',600.00,680.00,0.00,2737.36,1642416.00,1756354.80,113938.80,729740),('1','139','257589','330',600.00,680.00,0.00,2019.41,1211646.00,1304163.80,92517.80,729741),('1','139','257590','330',600.00,680.00,0.00,4547.14,2728284.00,2907530.20,179246.20,729742),('1','139','257591','330',600.00,680.00,0.00,3433.32,2059992.00,2192037.60,132045.60,729743),('1','139','257592','330',600.00,680.00,0.00,2487.90,1492740.00,1601002.00,108262.00,729744),('1','139','257593','330',600.00,680.00,0.00,3638.84,2183304.00,2302561.20,119257.20,729745),('1','139','257594','330',600.00,680.00,0.00,0.00,0.00,0.00,0.00,729746),('1','139','257595','330',590.00,680.00,0.00,3158.69,1863627.10,1967934.80,104307.70,729747),('1','139','257596','330',590.00,650.00,0.00,1734.69,1023467.10,1089188.50,65721.40,729748),('1','139','257597','330',590.00,650.00,0.00,4360.10,2572459.00,2696065.00,123606.00,729749),('1','139','257598','330',590.00,650.00,0.00,2210.00,1303900.00,1374833.00,70933.00,729750),('1','139','257599','330',590.00,650.00,0.00,1663.25,981317.50,1049017.50,67700.00,729751),('1','139','257600','330',590.00,650.00,0.00,2440.50,1439895.00,1538130.00,98235.00,729752),('1','139','257601','330',590.00,650.00,0.00,5693.62,3359235.80,3499181.00,139945.20,729753),('1','139','257602','330',590.00,650.00,0.00,3445.80,2033022.00,2123678.00,90656.00,729754),('1','139','257603','330',590.00,650.00,0.00,0.00,0.00,0.00,0.00,729755),('1','139','257604','330',590.00,650.00,0.00,0.00,0.00,0.00,0.00,729756),('1','139','257605','330',590.00,650.00,0.00,3995.24,2357191.60,2475116.00,117924.40,729757),('1','139','257606','330',590.00,650.00,0.00,1824.88,1076679.20,1150909.50,74230.30,729758),('1','139','257607','330',590.00,650.00,0.00,4409.70,2601723.00,2738545.00,136822.00,729759),('1','139','257608','330',590.00,650.00,0.00,5050.04,2979523.60,3150553.50,171029.90,729760),('1','139','257609','330',590.00,650.00,0.00,2546.50,1502435.00,1580564.50,78129.50,729761),('1','139','257610','330',590.00,650.00,0.00,1101.30,649767.00,692380.00,42613.00,729762),('1','139','257611','330',590.00,650.00,0.00,2734.90,1613591.00,1692403.00,78812.00,729763),('1','139','257612','330',590.00,650.00,0.00,3104.50,1831655.00,1915610.50,83955.50,729764),('1','139','257613','330',590.00,650.00,0.00,0.00,0.00,0.00,0.00,729765),('1','139','257614','330',590.00,650.00,0.00,3742.34,2207980.60,2311968.50,103987.90,729766),('1','139','257615','330',590.00,650.00,0.00,2443.94,1441924.60,1530336.00,88411.40,729767),('1','139','257616','330',590.00,650.00,0.00,5226.01,3083345.90,3234176.00,150830.10,729768),('1','139','257617','330',590.00,650.00,0.00,4244.14,2504042.60,2642081.00,138038.40,729769),('1','139','257618','330',590.00,650.00,0.00,2271.44,1340149.60,1432430.00,92280.40,729770),('1','139','257619','330',590.00,650.00,0.00,3867.05,2281559.50,2401206.50,119647.00,729771),('1','139','257620','330',590.00,650.00,0.00,2842.42,1677027.80,1766371.00,89343.20,729772),('1','139','257621','330',590.00,650.00,0.00,0.00,0.00,0.00,0.00,729773),('1','139','257622','330',600.00,650.00,0.00,8810.93,5286558.00,5540547.40,253989.40,729774),('1','139','257623','330',600.00,680.00,0.00,6821.07,4092642.00,4329337.60,236695.60,729775),('1','139','257624','330',600.00,680.00,0.00,5528.50,3317100.00,3549135.00,232035.00,729776),('1','139','257625','330',600.00,680.00,0.00,1474.63,884778.00,969843.40,85065.40,729777),('1','139','257626','330',600.00,680.00,0.00,1948.03,1168818.00,1234631.05,65813.05,729778),('1','139','257627','330',600.00,680.00,0.00,0.00,0.00,0.00,0.00,729779),('1','139','257628','330',660.00,730.00,0.00,10358.88,6836860.80,7096304.90,259444.10,729780),('1','139','257629','330',660.00,730.00,0.00,4737.36,3126657.60,3298872.80,172215.20,729781),('1','139','257630','330',660.00,730.00,0.00,2282.82,1506661.20,1606808.60,100147.40,729782),('1','139','257631','330',660.00,730.00,0.00,1813.77,1197088.20,1300202.10,103113.90,729783),('1','139','257632','330',660.00,730.00,0.00,2800.63,1848415.80,1946459.90,98044.10,729784),('1','139','257633','330',660.00,730.00,0.00,882.04,582146.40,643889.20,61742.80,729785),('1','139','257634','330',660.00,730.00,0.00,1851.64,1222082.40,1274697.20,52614.80,729786),('1','139','257635','330',660.00,730.00,0.00,954.64,630062.40,689267.20,59204.80,729787),('1','139','257636','330',660.00,730.00,0.00,3258.60,2150676.00,2301118.00,150442.00,729788),('1','139','257637','330',660.00,730.00,0.00,3601.59,2377049.40,2533660.70,156611.30,729789),('1','139','257638','330',660.00,730.00,0.00,2519.18,1662658.80,1796386.40,133727.60,729790),('1','139','257639','330',660.00,730.00,0.00,6488.27,4282258.20,4543321.10,261062.90,729791),('1','139','257640','330',660.00,730.00,0.00,2882.77,1902628.20,2038057.10,135428.90,729792),('1','139','257641','330',660.00,730.00,0.00,2926.85,1931721.00,2060535.50,128814.50,729793),('1','139','257642','330',660.00,730.00,0.00,1960.70,1294062.00,1371311.00,77249.00,729794),('1','139','257643','330',660.00,730.00,0.00,0.00,0.00,0.00,0.00,729795),('1','139','257644','330',690.00,770.00,0.00,2590.83,1787672.70,1910050.10,122377.40,729796),('1','139','257645','330',690.00,770.00,0.00,4591.92,3168424.80,3374258.40,205833.60,729797),('1','139','257646','330',690.00,770.00,0.00,4531.62,3126817.80,3342087.40,215269.60,729798),('1','139','257647','330',690.00,770.00,0.00,3403.02,2348083.80,2513830.40,165746.60,729799),('1','139','257648','330',690.00,770.00,0.00,4615.38,3184612.20,3413762.60,229150.40,729800),('1','139','257649','330',690.00,770.00,0.00,1428.14,985416.60,1073827.80,88411.20,729801),('1','139','257650','330',690.00,770.00,0.00,3548.89,2448734.10,2567245.30,118511.20,729802),('1','139','257651','330',690.00,770.00,0.00,0.00,0.00,0.00,0.00,729803),('1','139','257652','330',690.00,770.00,0.00,895.57,617943.30,669908.90,51965.60,729804),('1','139','257653','330',690.00,770.00,0.00,1337.21,922674.90,1009663.70,86988.80,729805),('1','139','257654','330',690.00,770.00,0.00,1391.12,959872.80,1044122.40,84249.60,729806),('1','139','257655','330',690.00,770.00,0.00,2354.24,1624425.60,1753624.80,129199.20,729807),('1','139','257656','330',690.00,770.00,0.00,2525.33,1742477.70,1868104.10,125626.40,729808),('1','139','257657','330',690.00,770.00,0.00,2711.16,1870700.40,2008793.20,138092.80,729809),('1','139','257658','330',690.00,770.00,0.00,3407.56,2351216.40,2519996.20,168779.80,729810),('1','139','257659','330',690.00,770.00,0.00,4098.76,2828144.40,3017225.20,189080.80,729811),('1','139','257660','330',690.00,770.00,0.00,3364.40,2321436.00,2482958.00,161522.00,729812),('1','139','257661','330',690.00,770.00,0.00,2536.33,1750067.70,1867774.10,117706.40,729813),('1','139','257662','330',690.00,770.00,0.00,0.00,0.00,0.00,0.00,729814),('1','139','257663','330',690.00,770.00,0.00,2340.04,1614627.60,1746030.80,131403.20,729815),('1','139','257664','330',690.00,770.00,0.00,2174.31,1500273.90,1621978.70,121704.80,729816),('1','139','257665','330',690.00,770.00,0.00,3602.20,2485518.00,2652934.00,167416.00,729817),('1','139','257666','330',690.00,770.00,0.00,3799.77,2621841.30,2796322.90,174481.60,729818),('1','139','257667','330',690.00,770.00,0.00,2394.55,1652239.50,1777803.50,125564.00,729819),('1','139','257668','330',690.00,770.00,0.00,2804.02,1934773.80,2071891.40,137117.60,729820),('1','139','257669','330',690.00,770.00,0.00,2338.90,1613841.00,1751493.00,137652.00,729821),('1','139','257670','330',690.00,770.00,0.00,2823.96,1948532.40,2114369.20,165836.80,729822),('1','139','257671','330',690.00,770.00,0.00,2390.25,1649272.50,1759272.50,110000.00,729823),('1','139','257672','330',690.00,770.00,0.00,0.00,0.00,0.00,0.00,729824),('1','139','257673','330',690.00,770.00,0.00,522.74,360690.60,390509.80,29819.20,729825),('1','139','257674','330',690.00,770.00,0.00,4778.21,3296964.90,3513221.70,216256.80,729826),('1','139','257675','330',690.00,770.00,0.00,4015.49,2770688.10,2967267.30,196579.20,729827),('1','139','257676','330',690.00,770.00,0.00,3716.64,2564481.60,2746132.80,181651.20,729828),('1','139','257677','330',690.00,770.00,0.00,3352.49,2313218.10,2478567.30,165349.20,729829),('1','139','257678','330',690.00,770.00,0.00,3869.68,2670079.20,2866633.60,196554.40,729830),('1','139','257679','330',690.00,770.00,0.00,1679.31,1158723.90,1243628.70,84904.80,729831),('1','139','257680','330',690.00,770.00,0.00,2748.74,1896630.60,2032465.80,135835.20,729832),('1','139','257681','330',690.00,770.00,0.00,0.00,0.00,0.00,0.00,729833),('1','139','257682','330',690.00,770.00,0.00,1297.46,895247.40,974364.20,79116.80,729834),('1','139','257683','330',690.00,770.00,0.00,3049.98,2104486.20,2249484.60,144998.40,729835),('1','139','257684','330',690.00,770.00,0.00,4270.01,2946306.90,3140067.70,193760.80,729836),('1','139','257685','330',690.00,770.00,0.00,2178.85,1503406.50,1615226.50,111820.00,729837),('1','139','257686','330',690.00,770.00,0.00,4752.25,3279052.50,3483504.50,204452.00,729838),('1','139','257687','330',690.00,770.00,0.00,3265.94,2253498.60,2421553.80,168055.20,729839),('1','139','257688','330',690.00,770.00,0.00,3112.54,2147652.60,2299267.80,151615.20,729840),('1','139','257689','330',690.00,770.00,0.00,2673.47,1844694.30,1961943.90,117249.60,729841),('1','139','257690','330',690.00,770.00,0.00,0.00,0.00,0.00,0.00,729842),('1','139','257691','330',682.00,760.00,0.00,2807.27,1914558.14,2048525.20,133967.06,729843),('1','139','257692','330',682.00,760.00,0.00,2650.33,1807525.06,1935170.80,127645.74,729844),('1','139','257693','330',682.00,760.00,0.00,2033.65,1386949.30,1502714.00,115764.70,729845),('1','139','257694','330',682.00,760.00,0.00,1226.46,836445.72,906989.60,70543.88,729846),('1','139','257695','330',682.00,760.00,0.00,4385.34,2990801.88,3173030.40,182228.52,729847),('1','139','257696','330',682.00,760.00,0.00,3558.53,2426917.46,2579250.80,152333.34,729848),('1','139','257697','330',682.00,760.00,0.00,2131.30,1453546.60,1559104.00,105557.40,729849),('1','139','257698','330',682.00,760.00,0.00,3951.51,2694929.82,2859947.60,165017.78,729850),('1','139','257699','330',682.00,760.00,0.00,1904.19,1298657.58,1379008.40,80350.82,729851),('1','139','257700','330',682.00,760.00,0.00,0.00,0.00,0.00,0.00,729852),('1','139','257701','330',682.00,760.00,0.00,6682.21,4557267.22,4832371.60,275104.38,729853),('1','139','257702','330',682.00,760.00,0.00,4633.77,3160231.14,3361555.20,201324.06,729854),('1','139','257703','330',682.00,760.00,0.00,5410.13,3689708.66,3940543.80,250835.14,729855),('1','139','257704','330',682.00,760.00,0.00,4152.71,2832148.22,3026729.60,194581.38,729856),('1','139','257705','330',682.00,760.00,0.00,3816.22,2602662.04,2769327.20,166665.16,729857),('1','139','257706','330',682.00,760.00,0.00,0.00,0.00,0.00,0.00,729858),('1','139','257707','330',682.00,760.00,0.00,3593.90,2451039.80,2612484.00,161444.20,729859),('1','139','257708','330',682.00,760.00,0.00,3753.24,2559709.68,2735246.40,175536.72,729860),('1','139','257709','330',682.00,760.00,0.00,2426.59,1654934.38,1781608.40,126674.02,729861),('1','139','257710','330',682.00,760.00,0.00,4616.89,3148718.98,3347746.40,199027.42,729862),('1','139','257711','330',682.00,760.00,0.00,4606.80,3141837.60,3349256.00,207418.40,729863),('1','139','257712','330',682.00,760.00,0.00,4637.42,3162720.44,3364307.20,201586.76,729864),('1','139','257713','330',682.00,760.00,0.00,1027.04,700441.28,748270.40,47829.12,729865),('1','139','257714','330',682.00,760.00,0.00,0.00,0.00,0.00,0.00,729866),('1','139','257715','330',682.00,760.00,0.00,0.00,0.00,0.00,0.00,729867),('1','139','257716','330',685.00,760.00,0.00,1249.29,855763.65,917900.40,62136.75,729868),('1','139','257717','330',685.00,760.00,0.00,4434.30,3037495.50,3217301.00,179805.50,729869),('1','139','257718','330',685.00,760.00,0.00,2508.27,1718164.95,1838895.20,120730.25,729870),('1','139','257719','330',685.00,760.00,0.00,2719.21,1862658.85,1990467.60,127808.75,729871),('1','139','257720','330',685.00,760.00,0.00,5823.27,3988939.95,4213645.20,224705.25,729872),('1','139','257721','330',685.00,760.00,0.00,2597.80,1779493.00,1904528.00,125035.00,729873),('1','139','257722','330',685.00,760.00,0.00,3015.77,2065802.45,2198945.20,133142.75,729874),('1','139','257723','330',685.00,760.00,0.00,2296.04,1572787.40,1672780.40,99993.00,729875),('1','139','257724','330',685.00,760.00,0.00,0.00,0.00,0.00,0.00,729876),('1','139','257725','330',685.00,760.00,0.00,962.62,659394.70,699769.20,40374.50,729877),('1','139','257726','330',685.00,760.00,0.00,3722.08,2549624.80,2706736.80,157112.00,729878),('1','139','257727','330',685.00,760.00,0.00,2502.40,1714144.00,1822012.00,107868.00,729879),('1','139','257728','330',685.00,760.00,0.00,2863.92,1961785.20,2084323.20,122538.00,729880),('1','139','257729','330',685.00,760.00,0.00,2657.08,1820099.80,1950956.40,130856.60,729881),('1','139','257730','330',685.00,760.00,0.00,2787.97,1909759.45,2045897.20,136137.75,729882),('1','139','257731','330',685.00,760.00,0.00,4105.75,2812438.75,2990393.20,177954.45,729883),('1','139','257732','330',685.00,760.00,0.00,3744.89,2565249.65,2733616.40,168366.75,729884),('1','139','257733','330',685.00,760.00,0.00,1205.54,825794.90,886630.40,60835.50,729885),('1','139','257734','330',685.00,760.00,0.00,0.00,0.00,0.00,0.00,729886),('1','139','257735','330',657.00,760.00,0.00,628.16,412701.12,459501.60,46800.48,729887),('1','139','257736','330',657.00,760.00,0.00,2933.57,1927355.49,2116286.70,188931.21,729888),('1','139','257737','330',657.00,760.00,0.00,5663.88,3721169.16,4063698.80,342529.64,729889),('1','139','257738','330',657.00,760.00,0.00,5960.43,3916002.51,4255726.80,339724.29,729890),('1','139','257739','330',657.00,760.00,0.00,2701.30,1774754.10,1964948.00,190193.90,729891),('1','139','257740','330',657.00,760.00,0.00,2056.76,1351291.32,1506262.60,154971.28,729892),('1','139','257741','330',657.00,760.00,0.00,3854.71,2532544.47,2777879.60,245335.13,729893),('1','139','257742','330',657.00,760.00,0.00,863.97,567628.29,623442.20,55813.91,729894),('1','139','257743','330',657.00,760.00,0.00,0.00,0.00,0.00,0.00,729895),('1','139','257744','330',657.00,760.00,0.00,2235.80,1468920.60,1612403.00,143482.40,729896),('1','139','257745','330',657.00,760.00,0.00,3337.70,2192868.90,2408022.00,215153.10,729897),('1','139','257746','330',657.00,760.00,0.00,2641.79,1735656.03,1914510.40,178854.37,729898),('1','139','257747','330',657.00,760.00,0.00,4136.78,2717864.46,2966552.80,248688.34,729899),('1','139','257748','330',657.00,760.00,0.00,2197.03,1443448.71,1600392.80,156944.09,729900),('1','139','257749','330',657.00,760.00,0.00,3233.63,2124494.91,2328058.80,203563.89,729901),('1','139','257750','330',657.00,760.00,0.00,2114.61,1389298.77,1551603.60,162304.83,729902),('1','139','257751','330',657.00,760.00,0.00,3507.75,2304591.75,2534465.00,229873.25,729903),('1','139','257752','330',657.00,760.00,0.00,1298.35,853015.95,944896.00,91880.05,729904),('1','139','257753','330',657.00,760.00,0.00,0.00,0.00,0.00,0.00,729905),('1','139','257754','330',670.00,760.00,0.00,655.94,439479.80,483514.40,44034.60,729906),('1','139','257755','330',670.00,760.00,0.00,3987.96,2671933.20,2858974.60,187041.40,729907),('1','139','257756','330',670.00,760.00,0.00,3132.81,2098982.70,2256985.60,158002.90,729908),('1','139','257757','330',670.00,760.00,0.00,2500.41,1675274.70,1817061.60,141786.90,729909),('1','139','257758','330',670.00,760.00,0.00,4290.68,2874755.60,3086871.80,212116.20,729910),('1','139','257759','330',670.00,760.00,0.00,3486.96,2336263.20,2521339.60,185076.40,729911),('1','139','257760','330',670.00,760.00,0.00,4020.27,2693580.90,2886465.20,192884.30,729912),('1','139','257761','330',670.00,760.00,0.00,2547.41,1706764.70,1826862.85,120098.15,729913),('1','139','257762','330',670.00,760.00,0.00,0.00,0.00,0.00,0.00,729914),('1','139','257763','330',670.00,760.00,0.00,2029.35,1312989.45,1475481.00,162491.55,729915),('1','139','257764','330',647.00,760.00,0.00,4662.96,3016935.12,3350849.60,333914.48,729916),('1','139','257765','330',647.00,760.00,0.00,3044.87,1970030.89,2191531.20,221500.31,729917),('1','139','257766','330',647.00,760.00,0.00,1918.21,1241081.87,1391689.60,150607.73,729918),('1','139','257767','330',647.00,760.00,0.00,2643.13,1710105.11,1902428.80,192323.69,729919),('1','139','257768','330',647.00,760.00,0.00,4660.63,3015427.61,3336478.80,321051.19,729920),('1','139','257769','330',647.00,760.00,0.00,2458.08,1590377.76,1778120.80,187743.04,729921),('1','139','257770','330',647.00,760.00,0.00,3243.05,2098253.35,2314233.00,215979.65,729922),('1','139','257771','330',647.00,760.00,0.00,0.00,0.00,0.00,0.00,729923),('1','139','257772','330',670.00,760.00,0.00,5108.02,3422373.40,3620260.70,197887.30,729924),('1','139','257773','330',670.00,760.00,0.00,3197.36,2142231.20,2293591.10,151359.90,729925),('1','139','257774','330',670.00,760.00,0.00,2335.09,1564510.30,1690807.90,126297.60,729926),('1','139','257775','330',670.00,760.00,0.00,4344.12,2910560.40,3123026.20,212465.80,729927),('1','139','257776','330',670.00,760.00,0.00,2458.98,1647516.60,1793424.80,145908.20,729928),('1','139','257777','330',670.00,760.00,0.00,3480.55,2331968.50,2506682.50,174714.00,729929),('1','139','257778','330',670.00,760.00,0.00,2786.88,1867209.60,2014823.80,147614.20,729930),('1','139','257779','330',670.00,760.00,0.00,967.24,648050.80,688272.40,40221.60,729931),('1','139','257780','330',670.00,760.00,0.00,0.00,0.00,0.00,0.00,729932),('1','139','257781','330',645.00,760.00,0.00,9468.40,6107118.00,6690376.00,583258.00,729933),('1','139','257782','330',645.00,760.00,0.00,7256.91,4680706.95,5145862.60,465155.65,729934),('1','139','257783','330',645.00,760.00,0.00,6202.50,4000612.50,4410950.00,410337.50,729935),('1','139','257784','330',645.00,760.00,0.00,1729.93,1115804.85,1245636.80,129831.95,729936),('1','139','257785','330',645.00,760.00,0.00,0.00,0.00,0.00,0.00,729937),('1','139','257786','330',645.00,760.00,0.00,5579.74,3598932.30,3959732.40,360800.10,729938),('1','139','257787','330',645.00,760.00,0.00,7408.54,4778508.30,5254685.40,476177.10,729939),('1','139','257788','330',645.00,760.00,0.00,3136.02,2022732.90,2273886.70,251153.80,729940),('1','139','257789','330',645.00,760.00,0.00,4587.44,2958898.80,3282517.40,323618.60,729941),('1','139','257790','330',645.00,760.00,0.00,3885.04,2505850.80,2765866.90,260016.10,729942),('1','139','257791','330',645.00,760.00,0.00,0.00,0.00,0.00,0.00,729943),('1','139','257792','330',656.00,760.00,0.00,6937.55,4551032.80,4894379.50,343346.70,729944),('1','139','257793','330',656.00,760.00,0.00,2124.83,1393888.48,1543150.80,149262.32,729945),('1','139','257794','330',656.00,760.00,0.00,2201.02,1443869.12,1597342.70,153473.58,729946),('1','139','257795','330',656.00,760.00,0.00,4499.26,2951514.56,3203326.45,251811.89,729947),('1','139','257796','330',656.00,780.00,0.00,3268.65,2144234.40,2478491.90,334257.50,729948),('1','139','257797','330',656.00,780.00,0.00,2762.14,1811963.84,2093243.20,281279.36,729949),('1','139','257798','330',656.00,780.00,0.00,2755.01,1807286.56,2081863.30,274576.74,729950),('1','139','257799','330',656.00,780.00,0.00,0.00,0.00,0.00,0.00,729951),('1','139','257800','330',675.00,780.00,0.00,12519.50,8450662.50,9242456.40,791793.90,729952),('1','139','257801','330',675.00,780.00,0.00,7347.21,4959366.75,5452287.80,492921.05,729953),('1','139','257802','330',675.00,780.00,0.00,2882.16,1945458.00,2154844.80,209386.80,729954),('1','139','257803','330',675.00,780.00,0.00,1851.43,1249715.25,1371745.40,122030.15,729955),('1','139','257804','330',675.00,780.00,0.00,0.00,0.00,0.00,0.00,729956),('1','139','257805','330',663.00,780.00,0.00,1461.41,968914.83,1092799.80,123884.97,729957),('1','139','257806','330',663.00,780.00,0.00,3245.04,2151461.52,2424591.20,273129.68,729958),('1','139','257807','330',663.00,780.00,0.00,2463.21,1633108.23,1848247.00,215138.77,729959),('1','139','257808','330',663.00,780.00,0.00,1715.05,1137078.15,1313279.00,176200.85,729960),('1','139','257809','330',663.00,780.00,0.00,2307.14,1529633.82,1730939.20,201305.38,729961),('1','139','257810','330',663.00,780.00,0.00,2548.83,1689874.29,1911146.40,221272.11,729962),('1','139','257811','330',663.00,780.00,0.00,2168.90,1437980.70,1632834.00,194853.30,729963),('1','139','257812','330',663.00,780.00,0.00,2618.68,1736184.84,1957758.40,221573.56,729964),('1','139','257813','330',663.00,780.00,0.00,3192.00,2116296.00,2383720.00,267424.00,729965),('1','139','257814','330',663.00,780.00,0.00,1778.49,1179138.87,1351854.20,172715.33,729966),('1','139','257815','330',663.00,780.00,0.00,1137.68,754281.84,843808.00,89526.16,729967),('1','139','257816','330',663.00,780.00,0.00,0.00,0.00,0.00,0.00,729968),('1','139','257817','330',663.00,780.00,0.00,1142.75,757643.25,865305.00,107661.75,729969),('1','139','257818','330',663.00,780.00,0.00,3714.12,2462461.56,2770809.60,308348.04,729970),('1','139','257819','330',663.00,780.00,0.00,2122.70,1407350.10,1594186.00,186835.90,729971),('1','139','257820','330',663.00,780.00,0.00,2855.29,1893057.27,2134306.20,241248.93,729972),('1','139','257821','330',663.00,780.00,0.00,2261.52,1499387.76,1688385.60,188997.84,729973),('1','139','257822','330',663.00,780.00,0.00,4402.12,2918605.56,3272321.60,353716.04,729974),('1','139','257823','330',663.00,780.00,0.00,2190.07,1452016.41,1640602.60,188586.19,729975),('1','139','257824','330',663.00,780.00,0.00,1671.63,1108290.69,1261339.40,153048.71,729976),('1','139','257825','330',663.00,780.00,0.00,1800.71,1193870.73,1358513.80,164643.07,729977),('1','139','257826','330',663.00,780.00,0.00,2511.38,1665044.94,1860576.40,195531.46,729978),('1','139','257827','330',663.00,780.00,0.00,0.00,0.00,0.00,0.00,729979),('1','139','257828','330',675.00,770.00,0.00,1659.31,1120034.25,1218458.70,98424.45,729980),('1','139','257829','330',675.00,770.00,0.00,1665.88,1124469.00,1243731.60,119262.60,729981),('1','139','257830','330',675.00,770.00,0.00,3384.23,2284355.25,2496557.10,212201.85,729982),('1','139','257831','330',675.00,770.00,0.00,1640.73,1107492.75,1230222.10,122729.35,729983),('1','139','257832','330',675.00,770.00,0.00,2004.83,1353260.25,1484719.10,131458.85,729984),('1','139','257833','330',675.00,770.00,0.00,4185.85,2825448.75,3087639.50,262190.75,729985),('1','139','257834','330',675.00,770.00,0.00,2665.02,1798888.50,1971815.40,172926.90,729986),('1','139','257835','330',675.00,770.00,0.00,4090.92,2761371.00,3003828.40,242457.40,729987),('1','139','257836','330',675.00,770.00,0.00,1771.12,1195506.00,1315932.40,120426.40,729988),('1','139','257837','330',675.00,770.00,0.00,1576.46,1064110.50,1164884.20,100773.70,729989),('1','139','257838','330',675.00,770.00,0.00,0.00,0.00,0.00,0.00,729990),('1','139','257839','330',667.00,770.00,0.00,3021.43,2015293.81,2227361.10,212067.29,729991),('1','139','257840','330',667.00,770.00,0.00,1245.36,830655.12,927387.20,96732.08,729992),('1','139','257841','330',667.00,770.00,0.00,2759.73,1840739.91,2037816.10,197076.19,729993),('1','139','257842','330',667.00,770.00,0.00,2118.69,1413166.23,1576699.30,163533.07,729994),('1','139','257843','330',667.00,770.00,0.00,3206.41,2138675.47,2356935.70,218260.23,729995),('1','139','257844','330',667.00,770.00,0.00,1405.47,937448.49,1045931.90,108483.41,729996),('1','139','257845','330',667.00,770.00,0.00,1556.76,1038358.92,1155505.20,117146.28,729997),('1','139','257846','330',667.00,770.00,0.00,935.20,623778.40,700624.00,76845.60,729998),('1','139','257847','330',667.00,770.00,0.00,1611.00,1074537.00,1200670.00,126133.00,729999),('1','139','257848','330',667.00,770.00,0.00,4690.05,3128263.35,3436798.50,308535.15,730000),('1','139','257849','330',667.00,770.00,0.00,2071.94,1381983.98,1531337.80,149353.82,730001),('1','139','257850','330',667.00,770.00,0.00,0.00,0.00,0.00,0.00,730002),('1','139','257851','330',667.00,770.00,0.00,1301.32,867980.44,967937.60,99957.16,730003),('1','139','257852','330',667.00,770.00,0.00,3985.45,2658295.15,2924240.50,265945.35,730004),('1','139','257853','330',667.00,770.00,0.00,2144.81,1430588.27,1589633.70,159045.43,730005),('1','139','257854','330',667.00,770.00,0.00,2532.33,1689064.11,1873834.10,184769.99,730006),('1','139','257855','330',667.00,770.00,0.00,2069.44,1380316.48,1541792.80,161476.32,730007),('1','139','257856','330',667.00,770.00,0.00,4483.86,2990734.62,3303692.20,312957.58,730008),('1','139','257857','330',667.00,770.00,0.00,1879.14,1253386.38,1383717.80,130331.42,730009),('1','139','257858','330',667.00,770.00,0.00,2065.55,1377721.85,1523857.50,146135.65,730010),('1','139','257859','330',667.00,770.00,0.00,4132.27,2756224.09,3025342.90,269118.81,730011),('1','139','257860','330',667.00,770.00,0.00,0.00,0.00,0.00,0.00,730012),('1','139','257861','330',666.00,770.00,0.00,932.27,620891.82,696135.90,75244.08,730013),('1','139','257862','330',666.00,770.00,0.00,2655.17,1768343.22,1939736.90,171393.68,730014),('1','139','257863','330',666.00,770.00,0.00,2489.72,1658153.52,1828396.40,170242.88,730015),('1','139','257864','330',666.00,770.00,0.00,1372.46,914058.36,1015622.20,101563.84,730016),('1','139','257865','330',666.00,770.00,0.00,801.51,533805.66,598762.70,64957.04,730017),('1','139','257866','330',666.00,770.00,0.00,3794.78,2527323.48,2760730.60,233407.12,730018),('1','139','257867','330',666.00,770.00,0.00,2277.66,1516921.56,1675974.20,159052.64,730019),('1','139','257868','330',666.00,770.00,0.00,1829.49,1218440.34,1354367.30,135926.96,730020),('1','139','257869','330',666.00,770.00,0.00,1256.22,836642.52,938625.40,101982.88,730021),('1','139','257870','330',666.00,770.00,0.00,2271.30,1512685.80,1667101.00,154415.20,730022),('1','139','257871','330',666.00,770.00,0.00,2371.89,1579678.74,1745075.30,165396.56,730023),('1','139','257872','330',666.00,770.00,0.00,2423.86,1614290.76,1786716.20,172425.44,730024),('1','139','257873','330',666.00,770.00,0.00,0.00,0.00,0.00,0.00,730025),('1','139','257874','330',666.00,770.00,0.00,3352.66,2232871.56,2391408.30,158536.74,730026),('1','139','257875','330',666.00,755.00,0.00,3156.90,2102495.40,2255904.50,153409.10,730027),('1','139','257876','330',666.00,755.00,0.00,2968.60,1977087.60,2124103.00,147015.40,730028),('1','139','257877','330',666.00,755.00,0.00,3689.90,2457473.40,2643584.50,186111.10,730029),('1','139','257878','330',666.00,755.00,0.00,2028.00,1350648.00,1476622.50,125974.50,730030),('1','139','257879','330',666.00,755.00,0.00,3450.48,2298019.68,2479362.40,181342.72,730031),('1','139','257880','330',666.00,755.00,0.00,2076.63,1383035.58,1507342.35,124306.77,730032),('1','139','257881','330',666.00,755.00,0.00,3033.30,2020177.80,2180376.50,160198.70,730033),('1','139','257882','330',666.00,755.00,0.00,842.12,560851.92,607315.60,46463.68,730034),('1','139','257883','330',666.00,755.00,0.00,0.00,0.00,0.00,0.00,730035),('1','139','257884','330',621.00,755.00,0.00,1071.40,665339.40,774932.00,109592.60,730036),('1','139','257885','330',621.00,755.00,0.00,3306.27,2053193.67,2366596.35,313402.68,730037),('1','139','257886','330',621.00,755.00,0.00,4871.26,3025052.46,3466733.80,441681.34,730038),('1','139','257887','330',621.00,755.00,0.00,1775.76,1102746.96,1284398.80,181651.84,730039),('1','139','257888','330',621.00,755.00,0.00,2724.26,1691765.46,1953031.30,261265.84,730040),('1','139','257889','330',621.00,755.00,0.00,2505.85,1556132.85,1801216.75,245083.90,730041),('1','139','257890','330',621.00,755.00,0.00,3796.10,2357378.10,2708805.50,351427.40,730042),('1','139','257891','330',621.00,755.00,0.00,2840.32,1763838.72,2038401.60,274562.88,730043),('1','139','257892','330',621.00,755.00,0.00,1730.18,1074441.78,1226768.40,152326.62,730044),('1','139','257893','330',621.00,755.00,0.00,0.00,0.00,0.00,0.00,730045),('1','139','257894','330',639.00,755.00,0.00,2303.30,1471808.70,1651106.50,179297.80,730046),('1','139','257895','330',639.00,755.00,0.00,1950.00,1246050.00,1404250.00,158200.00,730047),('1','139','257896','330',639.00,755.00,0.00,1960.72,1252900.08,1407068.60,154168.52,730048),('1','139','257897','330',639.00,755.00,0.00,1655.54,1057890.06,1204703.20,146813.14,730049),('1','139','257898','330',639.00,755.00,0.00,2004.04,1280581.56,1445050.20,164468.64,730050),('1','139','257899','330',639.00,755.00,0.00,2832.84,1810184.76,2024794.20,214609.44,730051),('1','139','257900','330',639.00,755.00,0.00,1442.10,921501.90,1048285.50,126783.60,730052),('1','139','257901','330',639.00,755.00,0.00,1854.70,1185153.30,1336073.50,150920.20,730053),('1','139','257902','330',639.00,755.00,0.00,4223.40,2698752.60,3003017.00,304264.40,730054),('1','139','257903','330',639.00,755.00,0.00,1682.80,1075309.20,1223264.00,147954.80,730055),('1','139','257904','330',639.00,755.00,0.00,2624.20,1676863.80,1862671.00,185807.20,730056),('1','139','257905','330',639.00,755.00,0.00,0.00,0.00,0.00,0.00,730057),('1','139','257906','330',649.00,755.00,0.00,3007.10,1951607.90,2151328.00,199720.10,730058),('1','139','257907','330',649.00,755.00,0.00,2680.63,1739728.87,1919835.65,180106.78,730059),('1','139','257908','330',649.00,755.00,0.00,2871.75,1863765.75,2049671.25,185905.50,730060),('1','139','257909','330',649.00,755.00,0.00,2513.70,1631391.30,1801653.50,170262.20,730061),('1','139','257910','330',649.00,755.00,0.00,3673.62,2384179.38,2615725.60,231546.22,730062),('1','139','257911','330',649.00,755.00,0.00,1945.41,1262571.09,1413187.05,150615.96,730063),('1','139','257912','330',649.00,755.00,0.00,1524.91,989666.59,1111032.05,121365.46,730064),('1','139','257913','330',649.00,755.00,0.00,2810.25,1823852.25,2015573.75,191721.50,730065),('1','139','257914','330',649.00,755.00,0.00,2157.49,1400211.01,1541569.95,141358.94,730066),('1','139','257915','330',649.00,755.00,0.00,1428.70,927226.30,1016953.00,89726.70,730067),('1','139','257916','330',649.00,755.00,0.00,0.00,0.00,0.00,0.00,730068),('1','139','257917','330',649.00,755.00,0.00,1591.22,1032701.78,1153221.10,120519.32,730069),('1','139','257918','330',649.00,755.00,0.00,1294.41,840072.09,942854.55,102782.46,730070),('1','139','257919','330',649.00,755.00,0.00,1794.73,1164779.77,1295176.15,130396.38,730071),('1','139','257920','330',649.00,755.00,0.00,1010.20,655619.80,733991.00,78371.20,730072),('1','139','257921','330',649.00,755.00,0.00,1642.77,1066157.73,1188091.35,121933.62,730073),('1','139','257922','330',649.00,755.00,0.00,1421.92,922826.08,1028842.10,106016.02,730074),('1','139','257923','330',649.00,755.00,0.00,1884.03,1222735.47,1349897.65,127162.18,730075),('1','139','257924','330',649.00,755.00,0.00,1966.11,1276005.39,1410038.05,134032.66,730076),('1','139','257925','330',649.00,755.00,0.00,2371.85,1539330.65,1702690.75,163360.10,730077),('1','139','257926','330',649.00,755.00,0.00,1064.80,691055.20,775529.00,84473.80,730078),('1','139','257927','330',649.00,755.00,0.00,2030.30,1317664.70,1454536.50,136871.80,730079),('1','139','257928','330',649.00,755.00,0.00,4257.17,2762903.33,3031533.35,268630.02,730080),('1','139','257929','330',649.00,755.00,0.00,2153.21,1397433.29,1531652.70,134219.41,730081),('1','139','257930','330',649.00,755.00,0.00,0.00,0.00,0.00,0.00,730082),('1','139','257931','330',649.00,755.00,0.00,659.01,427697.49,478652.55,50955.06,730083),('1','139','257932','330',649.00,755.00,0.00,2003.65,1300368.85,1430395.75,130026.90,730084),('1','139','257933','330',649.00,755.00,0.00,1940.37,1259300.13,1390769.35,131469.22,730085),('1','139','257934','330',649.00,755.00,0.00,1289.39,836814.11,929830.40,93016.29,730086),('1','139','257935','330',649.00,755.00,0.00,721.25,468091.25,524829.25,56738.00,730087),('1','139','257936','330',649.00,755.00,0.00,1259.48,817402.52,916977.40,99574.88,730088),('1','139','257937','330',649.00,755.00,0.00,1313.10,852201.90,948685.50,96483.60,730089),('1','139','257938','330',649.00,755.00,0.00,2553.12,1656974.88,1793286.30,136311.42,730090),('1','139','257939','330',649.00,740.00,0.00,2222.92,1442675.08,1552308.30,109633.22,730091),('1','139','257940','330',649.00,740.00,0.00,2360.88,1532211.12,1645603.20,113392.08,730092),('1','139','257941','330',649.00,740.00,0.00,1692.34,1098328.66,1201731.60,103402.94,730093),('1','139','257942','330',649.00,740.00,0.00,1154.42,749218.58,821895.80,72677.22,730094),('1','139','257943','330',649.00,740.00,0.00,2252.92,1462145.08,1576760.80,114615.72,730095),('1','139','257944','330',649.00,740.00,0.00,1640.69,1064807.81,1165684.10,100876.29,730096),('1','139','257945','330',649.00,740.00,0.00,1561.21,1013225.29,1080395.40,67170.11,730097),('1','139','257946','330',649.00,740.00,0.00,0.00,0.00,0.00,0.00,730098),('1','139','257947','330',639.00,740.00,0.00,650.01,415356.39,460197.40,44841.01,730099),('1','139','257948','330',639.00,740.00,0.00,1398.10,893385.90,983297.50,89911.60,730100),('1','139','257949','330',639.00,740.00,0.00,2067.65,1321228.35,1452511.00,131282.65,730101),('1','139','257950','330',639.00,740.00,0.00,2719.85,1737984.15,1905489.00,167504.85,730102),('1','139','257951','330',639.00,740.00,0.00,1744.65,1114831.35,1227991.00,113159.65,730103);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=308 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',307,'139','PRODUCT TANK','TANK CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=773 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','139','307',772,1,'330','LPG TANK',25000.00,1.00,6364.08,'TANK CONTAINING LPG','479','2020-08-10 22:31:40','2020-08-10 22:31:40','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','139',772,111599.74,'2023-03-20 18:44:52');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2712175 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2108491,'1','139','772',330,'Retail Sale Id 1254255',4000.00,0.00,0.00,0.00,300.00,'2021-12-01 06:51:44','',''),(2108492,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 06:51:44','',''),(2108522,'1','139','772',330,'Retail Sale Id 1254270',998.40,0.00,0.00,0.00,74.88,'2021-12-01 06:53:14','',''),(2108523,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 06:53:14','',''),(2108550,'1','139','772',330,'Retail Sale Id 1254283',1497.60,0.00,0.00,0.00,112.32,'2021-12-01 06:54:32','',''),(2108551,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 06:54:32','',''),(2108577,'1','139','772',330,'Retail Sale Id 1254297',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 06:55:37','',''),(2108578,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:55:37','',''),(2108609,'1','139','772',330,'Retail Sale Id 1254313',998.40,0.00,0.00,0.00,74.88,'2021-12-01 06:56:50','',''),(2108610,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 06:56:50','',''),(2108630,'1','139','772',330,'Retail Sale Id 1254325',3001.60,0.00,0.00,0.00,225.12,'2021-12-01 06:57:46','',''),(2108631,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 06:57:46','',''),(2108650,'1','139','772',330,'Retail Sale Id 1254335',1280.00,0.00,0.00,0.00,96.00,'2021-12-01 06:58:46','',''),(2108651,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 06:58:46','',''),(2108676,'1','139','772',330,'Retail Sale Id 1254344',1920.00,0.00,0.00,0.00,144.00,'2021-12-01 07:00:03','',''),(2108677,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 07:00:03','',''),(2108771,'1','139','772',330,'Retail Sale Id 1254386',7680.00,0.00,0.00,0.00,576.00,'2021-12-01 07:05:00','',''),(2108772,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-01 07:05:00','',''),(2108891,'1','139','772',330,'Retail Sale Id 1254435',8640.00,0.00,0.00,0.00,648.00,'2021-12-01 07:10:09','',''),(2108892,'1','139','772',330,'Retail sales',0.00,0.00,0.00,13.50,0.00,'2021-12-01 07:10:09','',''),(2108927,'1','139','772',330,'Retail Sale Id 1254447',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 07:11:20','',''),(2108928,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:11:20','',''),(2108977,'1','139','772',330,'Retail Sale Id 1254468',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 07:13:34','',''),(2108978,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:13:34','',''),(2109023,'1','139','772',330,'Retail Sale Id 1254492',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 07:16:17','',''),(2109024,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 07:16:17','',''),(2109057,'1','139','772',330,'Retail Sale Id 1254512',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 07:18:12','',''),(2109058,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:18:12','',''),(2109081,'1','139','772',330,'Retail Sale Id 1254523',998.40,0.00,0.00,0.00,74.88,'2021-12-01 07:19:15','',''),(2109082,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 07:19:15','',''),(2109154,'1','139','772',330,'Retail Sale Id 1254551',3840.00,0.00,0.00,0.00,288.00,'2021-12-01 07:22:24','',''),(2109155,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 07:22:24','',''),(2109217,'1','139','772',330,'Retail Sale Id 1254568',1280.00,0.00,0.00,0.00,96.00,'2021-12-01 07:24:22','',''),(2109218,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 07:24:22','',''),(2109248,'1','139','772',330,'Retail Sale Id 1254579',640.00,0.00,0.00,0.00,48.00,'2021-12-01 07:26:21','',''),(2109249,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-01 07:26:21','',''),(2109255,'1','139','772',330,'Retail Sale Id 1254585',1920.00,0.00,0.00,0.00,144.00,'2021-12-01 07:27:10','',''),(2109256,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 07:27:10','',''),(2109310,'1','139','772',330,'Retail Sale Id 1254608',5120.00,0.00,0.00,0.00,384.00,'2021-12-01 07:29:52','',''),(2109311,'1','139','772',330,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-01 07:29:52','',''),(2109342,'1','139','772',330,'Retail Sale Id 1254627',2560.00,0.00,0.00,0.00,192.00,'2021-12-01 07:31:54','',''),(2109343,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 07:31:54','',''),(2109366,'1','139','772',330,'Retail Sale Id 1254645',1497.60,0.00,0.00,0.00,112.32,'2021-12-01 07:33:18','',''),(2109367,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 07:33:18','',''),(2109394,'1','139','772',330,'Retail Sale Id 1254662',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 07:34:38','',''),(2109395,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 07:34:38','',''),(2109410,'1','139','772',330,'Retail Sale Id 1254666',6003.20,0.00,0.00,0.00,450.24,'2021-12-01 07:35:34','',''),(2109411,'1','139','772',330,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-01 07:35:34','',''),(2109488,'1','139','772',330,'Retail Sale Id 1254711',20130.00,0.00,0.00,0.00,594.00,'2021-12-01 07:39:00','',''),(2109489,'1','139','772',330,'Retail sales',0.00,0.00,0.00,33.00,0.00,'2021-12-01 07:39:00','',''),(2109671,'1','139','772',330,'Retail Sale Id 1254775',7500.80,0.00,0.00,0.00,562.56,'2021-12-01 07:45:47','',''),(2109672,'1','139','772',330,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-01 07:45:47','',''),(2109711,'1','139','772',330,'Retail Sale Id 1254797',2240.00,0.00,0.00,0.00,168.00,'2021-12-01 07:47:31','',''),(2109712,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-01 07:47:31','',''),(2109780,'1','139','772',330,'Retail Sale Id 1254830',8320.00,0.00,0.00,0.00,624.00,'2021-12-01 07:50:36','',''),(2109781,'1','139','772',330,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-01 07:50:36','',''),(2109812,'1','139','772',330,'Retail Sale Id 1254842',2502.40,0.00,0.00,0.00,187.68,'2021-12-01 07:52:28','',''),(2109813,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 07:52:28','',''),(2110001,'1','139','772',330,'Retail Sale Id 1254942',1497.60,0.00,0.00,0.00,112.32,'2021-12-01 08:02:47','',''),(2110002,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 08:02:47','',''),(2110090,'1','139','772',330,'Retail Sale Id 1254977',3200.00,0.00,0.00,0.00,240.00,'2021-12-01 08:06:29','',''),(2110091,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:06:29','',''),(2110278,'1','139','772',330,'Retail Sale Id 1255074',697.60,0.00,0.00,0.00,52.32,'2021-12-01 08:17:42','',''),(2110279,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-01 08:17:42','',''),(2110298,'1','139','772',330,'Retail Sale Id 1255085',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 08:18:44','',''),(2110299,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 08:18:44','',''),(2110411,'1','139','772',330,'Retail Sale Id 1255142',2560.00,0.00,0.00,0.00,192.00,'2021-12-01 08:25:36','',''),(2110412,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 08:25:36','',''),(2110433,'1','139','772',330,'Retail Sale Id 1255154',73200.00,0.00,0.00,0.00,2160.00,'2021-12-01 08:27:18','',''),(2110434,'1','139','772',330,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-01 08:27:18','',''),(2110463,'1','139','772',330,'Retail Sale Id 1255172',1600.00,0.00,0.00,0.00,120.00,'2021-12-01 08:29:38','',''),(2110464,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-01 08:29:38','',''),(2110507,'1','139','772',330,'Retail Sale Id 1255192',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 08:32:02','',''),(2110508,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 08:32:02','',''),(2110588,'1','139','772',330,'Retail Sale Id 1255227',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 08:35:54','',''),(2110589,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 08:35:54','',''),(2110714,'1','139','772',330,'Retail Sale Id 1255287',3001.60,0.00,0.00,0.00,225.12,'2021-12-01 08:42:51','',''),(2110715,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 08:42:51','',''),(2110828,'1','139','772',330,'Retail Sale Id 1255352',697.60,0.00,0.00,0.00,52.32,'2021-12-01 08:49:43','',''),(2110829,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-01 08:49:43','',''),(2110840,'1','139','772',330,'Retail Sale Id 1255359',1920.00,0.00,0.00,0.00,144.00,'2021-12-01 08:50:31','',''),(2110841,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 08:50:31','',''),(2110916,'1','139','772',330,'Retail Sale Id 1255397',131150.00,0.00,0.00,0.00,3870.00,'2021-12-01 08:55:11','',''),(2110917,'1','139','772',330,'Retail sales',0.00,0.00,0.00,215.00,0.00,'2021-12-01 08:55:11','',''),(2110930,'1','139','772',330,'Retail Sale Id 1255406',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 08:55:59','',''),(2110931,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 08:55:59','',''),(2110949,'1','139','772',330,'Retail Sale Id 1255416',7001.60,0.00,0.00,0.00,525.12,'2021-12-01 08:56:55','',''),(2110950,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-01 08:56:55','',''),(2110965,'1','139','772',330,'Retail Sale Id 1255425',6400.00,0.00,0.00,0.00,480.00,'2021-12-01 08:58:17','',''),(2110966,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 08:58:17','',''),(2110995,'1','139','772',330,'Return of Retail Sale Id 1255416',0.00,7001.60,10.94,0.00,-525.12,'2021-12-01 08:59:54','',''),(2111006,'1','139','772',330,'Retail Sale Id 1255445',640.00,0.00,0.00,0.00,48.00,'2021-12-01 09:00:36','',''),(2111007,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-01 09:00:36','',''),(2111044,'1','139','772',330,'Retail Sale Id 1255461',2502.40,0.00,0.00,0.00,187.68,'2021-12-01 09:02:48','',''),(2111045,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 09:02:48','',''),(2111070,'1','139','772',330,'Retail Sale Id 1255475',1920.00,0.00,0.00,0.00,144.00,'2021-12-01 09:03:49','',''),(2111071,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:03:50','',''),(2111100,'1','139','772',330,'Retail Sale Id 1255490',2240.00,0.00,0.00,0.00,168.00,'2021-12-01 09:05:15','',''),(2111101,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-01 09:05:15','',''),(2111252,'1','139','772',330,'Retail Sale Id 1255571',640.00,0.00,0.00,0.00,48.00,'2021-12-01 09:15:30','',''),(2111253,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-01 09:15:30','',''),(2111280,'1','139','772',330,'Retail Sale Id 1255587',2201.60,0.00,0.00,0.00,165.12,'2021-12-01 09:16:32','',''),(2111281,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.44,0.00,'2021-12-01 09:16:32','',''),(2111305,'1','139','772',330,'Return of Retail Sale Id 1255587',0.00,2201.60,3.44,0.00,-165.12,'2021-12-01 09:18:29','',''),(2111326,'1','139','772',330,'Retail Sale Id 1255614',800.00,0.00,0.00,0.00,60.00,'2021-12-01 09:19:49','',''),(2111327,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-01 09:19:49','',''),(2111378,'1','139','772',330,'Retail Sale Id 1255641',4998.40,0.00,0.00,0.00,374.88,'2021-12-01 09:23:12','',''),(2111379,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 09:23:12','',''),(2111444,'1','139','772',330,'Retail Sale Id 1255651',73200.00,0.00,0.00,0.00,2160.00,'2021-12-01 09:26:24','',''),(2111445,'1','139','772',330,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-01 09:26:24','',''),(2111464,'1','139','772',330,'Retail Sale Id 1255680',24400.00,0.00,0.00,0.00,720.00,'2021-12-01 09:27:46','',''),(2111465,'1','139','772',330,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-01 09:27:46','',''),(2111490,'1','139','772',330,'Retail Sale Id 1255694',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 09:29:19','',''),(2111491,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 09:29:19','',''),(2111512,'1','139','772',330,'Retail Sale Id 1255704',998.40,0.00,0.00,0.00,74.88,'2021-12-01 09:30:59','',''),(2111513,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 09:30:59','',''),(2111529,'1','139','772',330,'Retail Sale Id 1255714',1920.00,0.00,0.00,0.00,144.00,'2021-12-01 09:32:49','',''),(2111530,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:32:49','',''),(2111640,'1','139','772',330,'Retail Sale Id 1255772',51240.00,0.00,0.00,0.00,1512.00,'2021-12-01 09:38:57','',''),(2111641,'1','139','772',330,'Retail sales',0.00,0.00,0.00,84.00,0.00,'2021-12-01 09:38:57','',''),(2111664,'1','139','772',330,'Retail Sale Id 1255789',36600.00,0.00,0.00,0.00,1080.00,'2021-12-01 09:40:32','',''),(2111665,'1','139','772',330,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-01 09:40:32','',''),(2111672,'1','139','772',330,'Retail Sale Id 1255792',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 09:41:31','',''),(2111673,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 09:41:31','',''),(2111762,'1','139','772',330,'Retail Sale Id 1255845',800.00,0.00,0.00,0.00,60.00,'2021-12-01 09:48:21','',''),(2111763,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-01 09:48:21','',''),(2112064,'1','139','772',330,'Retail Sale Id 1255982',2502.40,0.00,0.00,0.00,187.68,'2021-12-01 10:09:28','',''),(2112065,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 10:09:28','',''),(2112080,'1','139','772',330,'Retail Sale Id 1255990',640.00,0.00,0.00,0.00,48.00,'2021-12-01 10:10:48','',''),(2112081,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-01 10:10:48','',''),(2112100,'1','139','772',330,'Retail Sale Id 1256004',4000.00,0.00,0.00,0.00,300.00,'2021-12-01 10:11:44','',''),(2112101,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 10:11:44','',''),(2112130,'1','139','772',330,'Retail Sale Id 1256020',8320.00,0.00,0.00,0.00,624.00,'2021-12-01 10:13:21','',''),(2112131,'1','139','772',330,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-01 10:13:21','',''),(2112166,'1','139','772',330,'Retail Sale Id 1256035',3520.00,0.00,0.00,0.00,264.00,'2021-12-01 10:15:32','',''),(2112167,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-01 10:15:32','',''),(2112405,'1','139','772',330,'Retail Sale Id 1256149',7680.00,0.00,0.00,0.00,576.00,'2021-12-01 10:33:25','',''),(2112406,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-01 10:33:25','',''),(2112540,'1','139','772',330,'Retail Sale Id 1256215',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 10:44:24','',''),(2112541,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 10:44:24','',''),(2112598,'1','139','772',330,'Retail Sale Id 1256246',5120.00,0.00,0.00,0.00,384.00,'2021-12-01 10:48:40','',''),(2112599,'1','139','772',330,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-01 10:48:40','',''),(2112648,'1','139','772',330,'Retail Sale Id 1256271',902.40,0.00,0.00,0.00,67.68,'2021-12-01 10:53:41','',''),(2112649,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-01 10:53:41','',''),(2112666,'1','139','772',330,'Retail Sale Id 1256282',2560.00,0.00,0.00,0.00,192.00,'2021-12-01 10:56:01','',''),(2112667,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 10:56:01','',''),(2112678,'1','139','772',330,'Retail Sale Id 1256291',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 10:57:10','',''),(2112679,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 10:57:10','',''),(2112755,'1','139','772',330,'Retail Sale Id 1256329',4160.00,0.00,0.00,0.00,312.00,'2021-12-01 11:03:09','',''),(2112756,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-01 11:03:09','',''),(2112830,'1','139','772',330,'Retail Sale Id 1256369',1280.00,0.00,0.00,0.00,96.00,'2021-12-01 11:08:15','',''),(2112831,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 11:08:15','',''),(2112860,'1','139','772',330,'Retail Sale Id 1256387',3001.60,0.00,0.00,0.00,225.12,'2021-12-01 11:10:42','',''),(2112861,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 11:10:42','',''),(2112878,'1','139','772',330,'Retail Sale Id 1256393',3001.60,0.00,0.00,0.00,225.12,'2021-12-01 11:11:34','',''),(2112879,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 11:11:34','',''),(2112972,'1','139','772',330,'Retail Sale Id 1256431',3840.00,0.00,0.00,0.00,288.00,'2021-12-01 11:16:38','',''),(2112973,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 11:16:38','',''),(2113070,'1','139','772',330,'Retail Sale Id 1256474',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 11:22:19','',''),(2113071,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 11:22:19','',''),(2113084,'1','139','772',330,'Retail Sale Id 1256482',1920.00,0.00,0.00,0.00,144.00,'2021-12-01 11:23:23','',''),(2113085,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 11:23:23','',''),(2113112,'1','139','772',330,'Retail Sale Id 1256493',1600.00,0.00,0.00,0.00,120.00,'2021-12-01 11:25:01','',''),(2113113,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-01 11:25:01','',''),(2113160,'1','139','772',330,'Retail Sale Id 1256511',8960.00,0.00,0.00,0.00,672.00,'2021-12-01 11:26:44','',''),(2113161,'1','139','772',330,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-01 11:26:44','',''),(2113210,'1','139','772',330,'Retail Sale Id 1256540',2560.00,0.00,0.00,0.00,192.00,'2021-12-01 11:30:33','',''),(2113211,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 11:30:33','',''),(2113258,'1','139','772',330,'Retail Sale Id 1256571',998.40,0.00,0.00,0.00,74.88,'2021-12-01 11:34:59','',''),(2113259,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 11:34:59','',''),(2113280,'1','139','772',330,'Retail Sale Id 1256583',998.40,0.00,0.00,0.00,74.88,'2021-12-01 11:36:28','',''),(2113281,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 11:36:28','',''),(2113408,'1','139','772',330,'Retail Sale Id 1256651',7001.60,0.00,0.00,0.00,525.12,'2021-12-01 11:45:56','',''),(2113409,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-01 11:45:56','',''),(2113453,'1','139','772',330,'Retail Sale Id 1256672',2240.00,0.00,0.00,0.00,168.00,'2021-12-01 11:49:28','',''),(2113454,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-01 11:49:28','',''),(2113501,'1','139','772',330,'Retail Sale Id 1256694',3520.00,0.00,0.00,0.00,264.00,'2021-12-01 11:53:33','',''),(2113502,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-01 11:53:33','',''),(2113531,'1','139','772',330,'Retail Sale Id 1256713',100650.00,0.00,0.00,0.00,2970.00,'2021-12-01 11:55:33','',''),(2113532,'1','139','772',330,'Retail sales',0.00,0.00,0.00,165.00,0.00,'2021-12-01 11:55:33','',''),(2113593,'1','139','772',330,'Retail Sale Id 1256748',1600.00,0.00,0.00,0.00,120.00,'2021-12-01 12:01:23','',''),(2113594,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-01 12:01:23','',''),(2113599,'1','139','772',330,'Retail Sale Id 1256754',1920.00,0.00,0.00,0.00,144.00,'2021-12-01 12:02:55','',''),(2113600,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 12:02:55','',''),(2113607,'1','139','772',330,'Retail Sale Id 1256757',1280.00,0.00,0.00,0.00,96.00,'2021-12-01 12:04:18','',''),(2113608,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 12:04:18','',''),(2113621,'1','139','772',330,'Retail Sale Id 1256765',3001.60,0.00,0.00,0.00,225.12,'2021-12-01 12:06:46','',''),(2113622,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 12:06:46','',''),(2113701,'1','139','772',330,'Retail Sale Id 1256809',998.40,0.00,0.00,0.00,74.88,'2021-12-01 12:12:42','',''),(2113702,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 12:12:42','',''),(2113811,'1','139','772',330,'Retail Sale Id 1256862',1299.20,0.00,0.00,0.00,97.44,'2021-12-01 12:19:56','',''),(2113812,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 12:19:56','',''),(2113827,'1','139','772',330,'Retail Sale Id 1256868',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 12:20:52','',''),(2113828,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 12:20:52','',''),(2113861,'1','139','772',330,'Retail Sale Id 1256887',2560.00,0.00,0.00,0.00,192.00,'2021-12-01 12:22:30','',''),(2113862,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 12:22:30','',''),(2113911,'1','139','772',330,'Retail Sale Id 1256912',1280.00,0.00,0.00,0.00,96.00,'2021-12-01 12:26:41','',''),(2113912,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 12:26:41','',''),(2113937,'1','139','772',330,'Retail Sale Id 1256924',7680.00,0.00,0.00,0.00,576.00,'2021-12-01 12:28:22','',''),(2113938,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-01 12:28:22','',''),(2113951,'1','139','772',330,'Retail Sale Id 1256932',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 12:29:21','',''),(2113952,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 12:29:21','',''),(2113987,'1','139','772',330,'Retail Sale Id 1256948',16000.00,0.00,0.00,0.00,1200.00,'2021-12-01 12:32:39','',''),(2113988,'1','139','772',330,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 12:32:39','',''),(2114031,'1','139','772',330,'Retail Sale Id 1256972',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 12:36:43','',''),(2114032,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 12:36:43','',''),(2114095,'1','139','772',330,'Retail Sale Id 1257004',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 12:44:08','',''),(2114096,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 12:44:08','',''),(2114246,'1','139','772',330,'Retail Sale Id 1257082',30500.00,0.00,0.00,0.00,900.00,'2021-12-01 13:01:14','',''),(2114247,'1','139','772',330,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 13:01:14','',''),(2114266,'1','139','772',330,'Retail Sale Id 1257091',2502.40,0.00,0.00,0.00,187.68,'2021-12-01 13:02:39','',''),(2114267,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 13:02:39','',''),(2114342,'1','139','772',330,'Retail Sale Id 1257115',2560.00,0.00,0.00,0.00,192.00,'2021-12-01 13:06:44','',''),(2114343,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 13:06:44','',''),(2114360,'1','139','772',330,'Retail Sale Id 1257121',4480.00,0.00,0.00,0.00,336.00,'2021-12-01 13:08:09','',''),(2114361,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 13:08:09','',''),(2114468,'1','139','772',330,'Retail Sale Id 1257225',2502.40,0.00,0.00,0.00,187.68,'2021-12-01 13:15:14','',''),(2114469,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 13:15:14','',''),(2114506,'1','139','772',330,'Retail Sale Id 1257245',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 13:18:16','',''),(2114507,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 13:18:16','',''),(2114516,'1','139','772',330,'Retail Sale Id 1257250',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 13:19:05','',''),(2114517,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 13:19:05','',''),(2114633,'1','139','772',330,'Retail Sale Id 1257306',1280.00,0.00,0.00,0.00,96.00,'2021-12-01 13:27:52','',''),(2114634,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 13:27:52','',''),(2114645,'1','139','772',330,'Retail Sale Id 1257312',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 13:29:35','',''),(2114646,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 13:29:35','',''),(2114687,'1','139','772',330,'Retail Sale Id 1257334',3520.00,0.00,0.00,0.00,264.00,'2021-12-01 13:33:12','',''),(2114688,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-01 13:33:12','',''),(2114766,'1','139','772',330,'Retail Sale Id 1257365',1280.00,0.00,0.00,0.00,96.00,'2021-12-01 13:38:14','',''),(2114767,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 13:38:14','',''),(2114934,'1','139','772',330,'Retail Sale Id 1257409',3001.60,0.00,0.00,0.00,225.12,'2021-12-01 13:46:03','',''),(2114935,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 13:46:03','',''),(2114954,'1','139','772',330,'Retail Sale Id 1257418',3500.80,0.00,0.00,0.00,262.56,'2021-12-01 13:47:18','',''),(2114955,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 13:47:18','',''),(2115275,'1','139','772',330,'Retail Sale Id 1257565',9280.00,0.00,0.00,0.00,696.00,'2021-12-01 14:04:29','',''),(2115276,'1','139','772',330,'Retail sales',0.00,0.00,0.00,14.50,0.00,'2021-12-01 14:04:29','',''),(2115305,'1','139','772',330,'Retail Sale Id 1257579',3001.60,0.00,0.00,0.00,225.12,'2021-12-01 14:06:17','',''),(2115306,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 14:06:17','',''),(2115319,'1','139','772',330,'Retail Sale Id 1257588',2560.00,0.00,0.00,0.00,192.00,'2021-12-01 14:07:24','',''),(2115320,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 14:07:24','',''),(2115345,'1','139','772',330,'Retail Sale Id 1257600',1280.00,0.00,0.00,0.00,96.00,'2021-12-01 14:09:11','',''),(2115346,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 14:09:11','',''),(2115383,'1','139','772',330,'Retail Sale Id 1257630',1600.00,0.00,0.00,0.00,120.00,'2021-12-01 14:12:08','',''),(2115384,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-01 14:12:08','',''),(2115471,'1','139','772',330,'Retail Sale Id 1257677',1920.00,0.00,0.00,0.00,144.00,'2021-12-01 14:18:21','',''),(2115472,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 14:18:21','',''),(2115483,'1','139','772',330,'Retail Sale Id 1257684',3481.60,0.00,0.00,0.00,261.12,'2021-12-01 14:19:12','',''),(2115484,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.44,0.00,'2021-12-01 14:19:12','',''),(2115508,'1','139','772',330,'Retail Sale Id 1257690',5760.00,0.00,0.00,0.00,432.00,'2021-12-01 14:20:17','',''),(2115509,'1','139','772',330,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-01 14:20:17','',''),(2115526,'1','139','772',330,'Retail Sale Id 1257698',4000.00,0.00,0.00,0.00,300.00,'2021-12-01 14:21:44','',''),(2115527,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 14:21:44','',''),(2115544,'1','139','772',330,'Retail Sale Id 1257707',1798.40,0.00,0.00,0.00,134.88,'2021-12-01 14:22:59','',''),(2115545,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-01 14:22:59','',''),(2115559,'1','139','772',330,'Retail Sale Id 1257718',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 14:24:46','',''),(2115560,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 14:24:46','',''),(2115585,'1','139','772',330,'Retail Sale Id 1257738',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 14:26:03','',''),(2115586,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 14:26:03','',''),(2115656,'1','139','772',330,'Retail Sale Id 1257772',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 14:31:06','',''),(2115657,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 14:31:06','',''),(2115817,'1','139','772',330,'Retail Sale Id 1257848',1600.00,0.00,0.00,0.00,120.00,'2021-12-01 14:43:34','',''),(2115818,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-01 14:43:34','',''),(2115835,'1','139','772',330,'Retail Sale Id 1257859',2502.40,0.00,0.00,0.00,187.68,'2021-12-01 14:45:50','',''),(2115836,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 14:45:50','',''),(2115851,'1','139','772',330,'Retail Sale Id 1257866',5760.00,0.00,0.00,0.00,432.00,'2021-12-01 14:46:50','',''),(2115852,'1','139','772',330,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-01 14:46:50','',''),(2115881,'1','139','772',330,'Retail Sale Id 1257883',1299.20,0.00,0.00,0.00,97.44,'2021-12-01 14:48:35','',''),(2115882,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 14:48:35','',''),(2115903,'1','139','772',330,'Retail Sale Id 1257894',4499.20,0.00,0.00,0.00,337.44,'2021-12-01 14:50:01','',''),(2115904,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-01 14:50:01','',''),(2115937,'1','139','772',330,'Retail Sale Id 1257902',1920.00,0.00,0.00,0.00,144.00,'2021-12-01 14:51:16','',''),(2115938,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 14:51:16','',''),(2116032,'1','139','772',330,'Retail Sale Id 1257923',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 14:53:58','',''),(2116033,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 14:53:58','',''),(2116072,'1','139','772',330,'Retail Sale Id 1257945',1203.20,0.00,0.00,0.00,90.24,'2021-12-01 14:57:52','',''),(2116073,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-01 14:57:52','',''),(2116104,'1','139','772',330,'Retail Sale Id 1257959',2502.40,0.00,0.00,0.00,187.68,'2021-12-01 14:59:51','',''),(2116105,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 14:59:51','',''),(2116124,'1','139','772',330,'Retail Sale Id 1257969',3840.00,0.00,0.00,0.00,288.00,'2021-12-01 15:01:28','',''),(2116125,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:01:28','',''),(2116158,'1','139','772',330,'Retail Sale Id 1257987',998.40,0.00,0.00,0.00,74.88,'2021-12-01 15:03:45','',''),(2116159,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 15:03:45','',''),(2116261,'1','139','772',330,'Retail Sale Id 1258042',800.00,0.00,0.00,0.00,60.00,'2021-12-01 15:13:00','',''),(2116262,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-01 15:13:00','',''),(2116378,'1','139','772',330,'Retail Sale Id 1258096',902.40,0.00,0.00,0.00,67.68,'2021-12-01 15:19:27','',''),(2116379,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-01 15:19:27','',''),(2116410,'1','139','772',330,'Retail Sale Id 1258112',697.60,0.00,0.00,0.00,52.32,'2021-12-01 15:21:24','',''),(2116411,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-01 15:21:24','',''),(2116473,'1','139','772',330,'Retail Sale Id 1258136',3520.00,0.00,0.00,0.00,264.00,'2021-12-01 15:24:34','',''),(2116474,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-01 15:24:34','',''),(2116521,'1','139','772',330,'Retail Sale Id 1258162',30500.00,0.00,0.00,0.00,900.00,'2021-12-01 15:28:08','',''),(2116522,'1','139','772',330,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 15:28:08','',''),(2116543,'1','139','772',330,'Retail Sale Id 1258172',3001.60,0.00,0.00,0.00,225.12,'2021-12-01 15:29:19','',''),(2116544,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 15:29:19','',''),(2116565,'1','139','772',330,'Retail Sale Id 1258183',2560.00,0.00,0.00,0.00,192.00,'2021-12-01 15:30:58','',''),(2116566,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 15:30:58','',''),(2116583,'1','139','772',330,'Retail Sale Id 1258191',1280.00,0.00,0.00,0.00,96.00,'2021-12-01 15:32:30','',''),(2116584,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 15:32:30','',''),(2116630,'1','139','772',330,'Retail Sale Id 1258215',1702.40,0.00,0.00,0.00,127.68,'2021-12-01 15:35:25','',''),(2116631,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-01 15:35:25','',''),(2116650,'1','139','772',330,'Retail Sale Id 1258227',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 15:36:49','',''),(2116651,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 15:36:49','',''),(2116676,'1','139','772',330,'Retail Sale Id 1258238',1280.00,0.00,0.00,0.00,96.00,'2021-12-01 15:38:44','',''),(2116677,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 15:38:44','',''),(2116704,'1','139','772',330,'Retail Sale Id 1258254',3840.00,0.00,0.00,0.00,288.00,'2021-12-01 15:40:22','',''),(2116705,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:40:22','',''),(2116722,'1','139','772',330,'Retail Sale Id 1258263',3200.00,0.00,0.00,0.00,240.00,'2021-12-01 15:42:00','',''),(2116723,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 15:42:00','',''),(2116768,'1','139','772',330,'Retail Sale Id 1258283',2560.00,0.00,0.00,0.00,192.00,'2021-12-01 15:44:19','',''),(2116769,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 15:44:19','',''),(2116810,'1','139','772',330,'Retail Sale Id 1258297',1280.00,0.00,0.00,0.00,96.00,'2021-12-01 15:45:54','',''),(2116811,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 15:45:54','',''),(2116828,'1','139','772',330,'Retail Sale Id 1258310',2880.00,0.00,0.00,0.00,216.00,'2021-12-01 15:46:42','',''),(2116829,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-01 15:46:42','',''),(2116896,'1','139','772',330,'Retail Sale Id 1258341',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 15:49:48','',''),(2116897,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 15:49:48','',''),(2116930,'1','139','772',330,'Retail Sale Id 1258359',1280.00,0.00,0.00,0.00,96.00,'2021-12-01 15:50:49','',''),(2116931,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 15:50:49','',''),(2117010,'1','139','772',330,'Retail Sale Id 1258392',2560.00,0.00,0.00,0.00,192.00,'2021-12-01 15:54:06','',''),(2117011,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 15:54:06','',''),(2117033,'1','139','772',330,'Retail Sale Id 1258406',1497.60,0.00,0.00,0.00,112.32,'2021-12-01 15:55:09','',''),(2117034,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 15:55:09','',''),(2117064,'1','139','772',330,'Retail Sale Id 1258418',1280.00,0.00,0.00,0.00,96.00,'2021-12-01 15:56:07','',''),(2117065,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 15:56:07','',''),(2117137,'1','139','772',330,'Retail Sale Id 1258449',3200.00,0.00,0.00,0.00,240.00,'2021-12-01 15:59:25','',''),(2117138,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 15:59:25','',''),(2117149,'1','139','772',330,'Retail Sale Id 1258466',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 16:00:18','',''),(2117150,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:00:18','',''),(2117177,'1','139','772',330,'Retail Sale Id 1258478',1920.00,0.00,0.00,0.00,144.00,'2021-12-01 16:01:17','',''),(2117178,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:01:17','',''),(2117233,'1','139','772',330,'Retail Sale Id 1258507',697.60,0.00,0.00,0.00,52.32,'2021-12-01 16:04:20','',''),(2117234,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-01 16:04:20','',''),(2117259,'1','139','772',330,'Retail Sale Id 1258519',1497.60,0.00,0.00,0.00,112.32,'2021-12-01 16:05:15','',''),(2117260,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 16:05:15','',''),(2117289,'1','139','772',330,'Retail Sale Id 1258532',3840.00,0.00,0.00,0.00,288.00,'2021-12-01 16:06:16','',''),(2117290,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:06:16','',''),(2117322,'1','139','772',330,'Retail Sale Id 1258542',2560.00,0.00,0.00,0.00,192.00,'2021-12-01 16:07:20','',''),(2117323,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 16:07:20','',''),(2117364,'1','139','772',330,'Retail Sale Id 1258557',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 16:08:35','',''),(2117365,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:08:35','',''),(2117401,'1','139','772',330,'Retail Sale Id 1258572',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 16:10:24','',''),(2117402,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:10:24','',''),(2117432,'1','139','772',330,'Retail Sale Id 1258581',2240.00,0.00,0.00,0.00,168.00,'2021-12-01 16:11:31','',''),(2117433,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-01 16:11:31','',''),(2117450,'1','139','772',330,'Retail Sale Id 1258592',2560.00,0.00,0.00,0.00,192.00,'2021-12-01 16:12:45','',''),(2117451,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 16:12:45','',''),(2117488,'1','139','772',330,'Retail Sale Id 1258606',1600.00,0.00,0.00,0.00,120.00,'2021-12-01 16:13:54','',''),(2117489,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-01 16:13:54','',''),(2117529,'1','139','772',330,'Retail Sale Id 1258626',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 16:15:25','',''),(2117530,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:15:25','',''),(2117557,'1','139','772',330,'Retail Sale Id 1258638',3840.00,0.00,0.00,0.00,288.00,'2021-12-01 16:16:26','',''),(2117558,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:16:26','',''),(2117575,'1','139','772',330,'Retail Sale Id 1258650',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 16:17:14','',''),(2117576,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:17:14','',''),(2117609,'1','139','772',330,'Retail Sale Id 1258665',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 16:18:46','',''),(2117610,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:18:46','',''),(2117658,'1','139','772',330,'Retail Sale Id 1258691',3840.00,0.00,0.00,0.00,288.00,'2021-12-01 16:20:49','',''),(2117659,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:20:49','',''),(2117700,'1','139','772',330,'Retail Sale Id 1258713',1497.60,0.00,0.00,0.00,112.32,'2021-12-01 16:22:22','',''),(2117701,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 16:22:22','',''),(2117752,'1','139','772',330,'Retail Sale Id 1258745',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 16:24:59','',''),(2117753,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:24:59','',''),(2117786,'1','139','772',330,'Retail Sale Id 1258770',4000.00,0.00,0.00,0.00,300.00,'2021-12-01 16:26:30','',''),(2117787,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 16:26:30','',''),(2117828,'1','139','772',330,'Retail Sale Id 1258797',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 16:28:33','',''),(2117829,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:28:33','',''),(2117952,'1','139','772',330,'Retail Sale Id 1258858',73200.00,0.00,0.00,0.00,2160.00,'2021-12-01 16:34:38','',''),(2117953,'1','139','772',330,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-01 16:34:38','',''),(2117974,'1','139','772',330,'Retail Sale Id 1258874',998.40,0.00,0.00,0.00,74.88,'2021-12-01 16:35:42','',''),(2117975,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 16:35:42','',''),(2117992,'1','139','772',330,'Retail Sale Id 1258884',998.40,0.00,0.00,0.00,74.88,'2021-12-01 16:36:53','',''),(2117993,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 16:36:53','',''),(2118030,'1','139','772',330,'Retail Sale Id 1258903',998.40,0.00,0.00,0.00,74.88,'2021-12-01 16:38:18','',''),(2118031,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 16:38:18','',''),(2118045,'1','139','772',330,'Retail Sale Id 1258912',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 16:39:08','',''),(2118046,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:39:08','',''),(2118078,'1','139','772',330,'Retail Sale Id 1258931',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 16:40:57','',''),(2118079,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:40:57','',''),(2118160,'1','139','772',330,'Retail Sale Id 1258975',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 16:44:58','',''),(2118161,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:44:58','',''),(2118184,'1','139','772',330,'Retail Sale Id 1258986',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 16:46:07','',''),(2118185,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:46:07','',''),(2118236,'1','139','772',330,'Retail Sale Id 1259013',3520.00,0.00,0.00,0.00,264.00,'2021-12-01 16:48:39','',''),(2118237,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-01 16:48:39','',''),(2118270,'1','139','772',330,'Retail Sale Id 1259032',998.40,0.00,0.00,0.00,74.88,'2021-12-01 16:50:39','',''),(2118271,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 16:50:39','',''),(2118407,'1','139','772',330,'Retail Sale Id 1259095',998.40,0.00,0.00,0.00,74.88,'2021-12-01 16:55:53','',''),(2118408,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 16:55:53','',''),(2118430,'1','139','772',330,'Retail Sale Id 1259105',3001.60,0.00,0.00,0.00,225.12,'2021-12-01 16:57:00','',''),(2118431,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 16:57:00','',''),(2118444,'1','139','772',330,'Retail Sale Id 1259113',3200.00,0.00,0.00,0.00,240.00,'2021-12-01 16:57:48','',''),(2118445,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:57:48','',''),(2118488,'1','139','772',330,'Retail Sale Id 1259136',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 16:59:23','',''),(2118489,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:59:23','',''),(2118508,'1','139','772',330,'Retail Sale Id 1259146',1497.60,0.00,0.00,0.00,112.32,'2021-12-01 17:00:15','',''),(2118509,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 17:00:15','',''),(2118534,'1','139','772',330,'Retail Sale Id 1259160',3001.60,0.00,0.00,0.00,225.12,'2021-12-01 17:01:42','',''),(2118535,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 17:01:42','',''),(2118552,'1','139','772',330,'Retail Sale Id 1259172',3200.00,0.00,0.00,0.00,240.00,'2021-12-01 17:02:28','',''),(2118553,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 17:02:28','',''),(2118586,'1','139','772',330,'Retail Sale Id 1259186',4160.00,0.00,0.00,0.00,312.00,'2021-12-01 17:03:54','',''),(2118587,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-01 17:03:54','',''),(2118602,'1','139','772',330,'Retail Sale Id 1259193',640.00,0.00,0.00,0.00,48.00,'2021-12-01 17:04:51','',''),(2118603,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-01 17:04:51','',''),(2118624,'1','139','772',330,'Retail Sale Id 1259201',2560.00,0.00,0.00,0.00,192.00,'2021-12-01 17:05:53','',''),(2118625,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 17:05:53','',''),(2118644,'1','139','772',330,'Retail Sale Id 1259211',2560.00,0.00,0.00,0.00,192.00,'2021-12-01 17:07:00','',''),(2118645,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 17:07:00','',''),(2118670,'1','139','772',330,'Retail Sale Id 1259224',2201.60,0.00,0.00,0.00,165.12,'2021-12-01 17:08:18','',''),(2118671,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.44,0.00,'2021-12-01 17:08:18','',''),(2118688,'1','139','772',330,'Retail Sale Id 1259235',1920.00,0.00,0.00,0.00,144.00,'2021-12-01 17:09:16','',''),(2118689,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 17:09:16','',''),(2118734,'1','139','772',330,'Retail Sale Id 1259257',3840.00,0.00,0.00,0.00,288.00,'2021-12-01 17:12:01','',''),(2118735,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 17:12:01','',''),(2118770,'1','139','772',330,'Retail Sale Id 1259280',6720.00,0.00,0.00,0.00,504.00,'2021-12-01 17:13:46','',''),(2118771,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.50,0.00,'2021-12-01 17:13:46','',''),(2118784,'1','139','772',330,'Retail Sale Id 1259286',998.40,0.00,0.00,0.00,74.88,'2021-12-01 17:14:34','',''),(2118785,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 17:14:34','',''),(2118808,'1','139','772',330,'Retail Sale Id 1259298',998.40,0.00,0.00,0.00,74.88,'2021-12-01 17:15:51','',''),(2118809,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 17:15:51','',''),(2118822,'1','139','772',330,'Retail Sale Id 1259304',800.00,0.00,0.00,0.00,60.00,'2021-12-01 17:16:36','',''),(2118823,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-01 17:16:36','',''),(2118846,'1','139','772',330,'Retail Sale Id 1259316',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 17:18:21','',''),(2118847,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:18:22','',''),(2118896,'1','139','772',330,'Retail Sale Id 1259339',640.00,0.00,0.00,0.00,48.00,'2021-12-01 17:21:35','',''),(2118897,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-01 17:21:35','',''),(2118912,'1','139','772',330,'Retail Sale Id 1259350',998.40,0.00,0.00,0.00,74.88,'2021-12-01 17:22:32','',''),(2118913,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 17:22:32','',''),(2118924,'1','139','772',330,'Retail Sale Id 1259353',998.40,0.00,0.00,0.00,74.88,'2021-12-01 17:23:35','',''),(2118925,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 17:23:35','',''),(2118991,'1','139','772',330,'Retail Sale Id 1259391',1280.00,0.00,0.00,0.00,96.00,'2021-12-01 17:28:33','',''),(2118992,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 17:28:33','',''),(2119011,'1','139','772',330,'Retail Sale Id 1259398',998.40,0.00,0.00,0.00,74.88,'2021-12-01 17:29:33','',''),(2119012,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 17:29:33','',''),(2119163,'1','139','772',330,'Retail Sale Id 1259474',3618000.00,0.00,0.00,0.00,66000.00,'2021-12-01 17:40:41','',''),(2119164,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6000.00,0.00,'2021-12-01 17:40:41','',''),(2119189,'1','139','772',330,'Retail Sale Id 1259487',213500.00,0.00,0.00,0.00,6300.00,'2021-12-01 17:42:23','',''),(2119190,'1','139','772',330,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-01 17:42:23','',''),(2119203,'1','139','772',330,'Retail Sale Id 1259495',176900.00,0.00,0.00,0.00,5220.00,'2021-12-01 17:43:47','',''),(2119204,'1','139','772',330,'Retail sales',0.00,0.00,0.00,290.00,0.00,'2021-12-01 17:43:47','',''),(2119222,'1','139','772',330,'Retail Sale Id 1259504',40260.00,0.00,0.00,0.00,1188.00,'2021-12-01 17:45:13','',''),(2119223,'1','139','772',330,'Retail sales',0.00,0.00,0.00,66.00,0.00,'2021-12-01 17:45:13','',''),(2120963,'1','139','772',330,'Retail Sale Id 1260097',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 06:42:54','',''),(2120964,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 06:42:54','',''),(2121008,'1','139','772',330,'Retail Sale Id 1260107',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 06:44:58','',''),(2121009,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 06:44:58','',''),(2121044,'1','139','772',330,'Retail Sale Id 1260125',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 06:47:17','',''),(2121045,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 06:47:17','',''),(2121076,'1','139','772',330,'Retail Sale Id 1260140',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 06:48:39','',''),(2121077,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 06:48:39','',''),(2121108,'1','139','772',330,'Retail Sale Id 1260159',7001.60,0.00,0.00,0.00,525.12,'2021-12-02 06:50:45','',''),(2121109,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-02 06:50:45','',''),(2121134,'1','139','772',330,'Retail Sale Id 1260174',640.00,0.00,0.00,0.00,48.00,'2021-12-02 06:52:10','',''),(2121135,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-02 06:52:10','',''),(2121170,'1','139','772',330,'Retail Sale Id 1260191',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 06:55:21','',''),(2121171,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 06:55:21','',''),(2121234,'1','139','772',330,'Retail Sale Id 1260211',3200.00,0.00,0.00,0.00,240.00,'2021-12-02 06:58:21','',''),(2121235,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 06:58:21','',''),(2121256,'1','139','772',330,'Retail Sale Id 1260223',7680.00,0.00,0.00,0.00,576.00,'2021-12-02 06:59:29','',''),(2121257,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 06:59:29','',''),(2121272,'1','139','772',330,'Retail Sale Id 1260230',2560.00,0.00,0.00,0.00,192.00,'2021-12-02 07:00:19','',''),(2121273,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 07:00:19','',''),(2121290,'1','139','772',330,'Retail Sale Id 1260240',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 07:01:36','',''),(2121291,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 07:01:36','',''),(2121302,'1','139','772',330,'Retail Sale Id 1260246',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 07:02:35','',''),(2121303,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 07:02:35','',''),(2121354,'1','139','772',330,'Retail Sale Id 1260275',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 07:05:20','',''),(2121355,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:05:20','',''),(2121378,'1','139','772',330,'Retail Sale Id 1260286',3200.00,0.00,0.00,0.00,240.00,'2021-12-02 07:06:37','',''),(2121379,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 07:06:37','',''),(2121396,'1','139','772',330,'Retail Sale Id 1260294',998.40,0.00,0.00,0.00,74.88,'2021-12-02 07:07:35','',''),(2121397,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 07:07:35','',''),(2121530,'1','139','772',330,'Retail Sale Id 1260343',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 07:13:27','',''),(2121531,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 07:13:27','',''),(2121562,'1','139','772',330,'Retail Sale Id 1260359',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 07:14:59','',''),(2121563,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 07:14:59','',''),(2121578,'1','139','772',330,'Retail Sale Id 1260371',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 07:16:04','',''),(2121579,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 07:16:04','',''),(2121593,'1','139','772',330,'Retail Sale Id 1260376',998.40,0.00,0.00,0.00,74.88,'2021-12-02 07:16:57','',''),(2121594,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 07:16:57','',''),(2121621,'1','139','772',330,'Retail Sale Id 1260394',6400.00,0.00,0.00,0.00,480.00,'2021-12-02 07:18:03','',''),(2121622,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 07:18:03','',''),(2121661,'1','139','772',330,'Retail Sale Id 1260408',2502.40,0.00,0.00,0.00,187.68,'2021-12-02 07:20:06','',''),(2121662,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 07:20:06','',''),(2121719,'1','139','772',330,'Retail Sale Id 1260431',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 07:22:41','',''),(2121720,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 07:22:41','',''),(2121745,'1','139','772',330,'Retail Sale Id 1260448',998.40,0.00,0.00,0.00,74.88,'2021-12-02 07:24:11','',''),(2121746,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 07:24:11','',''),(2121795,'1','139','772',330,'Retail Sale Id 1260472',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 07:26:28','',''),(2121796,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:26:28','',''),(2121857,'1','139','772',330,'Retail Sale Id 1260507',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 07:29:37','',''),(2121858,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:29:37','',''),(2121875,'1','139','772',330,'Retail Sale Id 1260521',1600.00,0.00,0.00,0.00,120.00,'2021-12-02 07:30:52','',''),(2121876,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-02 07:30:52','',''),(2121943,'1','139','772',330,'Retail Sale Id 1260568',3840.00,0.00,0.00,0.00,288.00,'2021-12-02 07:35:18','',''),(2121944,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 07:35:18','',''),(2122013,'1','139','772',330,'Retail Sale Id 1260602',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 07:38:28','',''),(2122014,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:38:28','',''),(2122062,'1','139','772',330,'Retail Sale Id 1260630',3200.00,0.00,0.00,0.00,240.00,'2021-12-02 07:40:32','',''),(2122063,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 07:40:32','',''),(2122094,'1','139','772',330,'Retail Sale Id 1260646',20130.00,0.00,0.00,0.00,594.00,'2021-12-02 07:41:50','',''),(2122095,'1','139','772',330,'Retail sales',0.00,0.00,0.00,33.00,0.00,'2021-12-02 07:41:50','',''),(2122130,'1','139','772',330,'Retail Sale Id 1260664',998.40,0.00,0.00,0.00,74.88,'2021-12-02 07:43:15','',''),(2122131,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 07:43:15','',''),(2122143,'1','139','772',330,'Retail Sale Id 1260669',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 07:44:06','',''),(2122144,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 07:44:06','',''),(2122163,'1','139','772',330,'Retail Sale Id 1260681',2560.00,0.00,0.00,0.00,192.00,'2021-12-02 07:45:24','',''),(2122164,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 07:45:24','',''),(2122189,'1','139','772',330,'Retail Sale Id 1260695',640.00,0.00,0.00,0.00,48.00,'2021-12-02 07:46:57','',''),(2122190,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-02 07:46:57','',''),(2122221,'1','139','772',330,'Retail Sale Id 1260711',640.00,0.00,0.00,0.00,48.00,'2021-12-02 07:48:16','',''),(2122222,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-02 07:48:16','',''),(2122247,'1','139','772',330,'Retail Sale Id 1260725',2502.40,0.00,0.00,0.00,187.68,'2021-12-02 07:49:29','',''),(2122248,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 07:49:29','',''),(2122307,'1','139','772',330,'Retail Sale Id 1260741',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 07:50:37','',''),(2122308,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 07:50:37','',''),(2122351,'1','139','772',330,'Retail Sale Id 1260763',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 07:52:15','',''),(2122352,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 07:52:15','',''),(2122387,'1','139','772',330,'Retail Sale Id 1260781',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 07:53:41','',''),(2122388,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 07:53:41','',''),(2122404,'1','139','772',330,'Retail Sale Id 1260790',998.40,0.00,0.00,0.00,74.88,'2021-12-02 07:54:47','',''),(2122405,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 07:54:47','',''),(2122462,'1','139','772',330,'Retail Sale Id 1260815',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 07:56:54','',''),(2122463,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 07:56:54','',''),(2122514,'1','139','772',330,'Retail Sale Id 1260834',2560.00,0.00,0.00,0.00,192.00,'2021-12-02 07:58:28','',''),(2122515,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 07:58:28','',''),(2122568,'1','139','772',330,'Retail Sale Id 1260858',1600.00,0.00,0.00,0.00,120.00,'2021-12-02 08:00:04','',''),(2122569,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-02 08:00:04','',''),(2122595,'1','139','772',330,'Retail Sale Id 1260868',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 08:01:24','',''),(2122596,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 08:01:24','',''),(2122677,'1','139','772',330,'Retail Sale Id 1260911',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 08:05:24','',''),(2122678,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 08:05:24','',''),(2122717,'1','139','772',330,'Retail Sale Id 1260928',4480.00,0.00,0.00,0.00,336.00,'2021-12-02 08:07:22','',''),(2122718,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 08:07:22','',''),(2122735,'1','139','772',330,'Retail Sale Id 1260939',998.40,0.00,0.00,0.00,74.88,'2021-12-02 08:08:21','',''),(2122736,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 08:08:21','',''),(2122771,'1','139','772',330,'Retail Sale Id 1260958',3840.00,0.00,0.00,0.00,288.00,'2021-12-02 08:10:35','',''),(2122772,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 08:10:35','',''),(2122801,'1','139','772',330,'Retail Sale Id 1260975',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 08:12:25','',''),(2122802,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 08:12:25','',''),(2122844,'1','139','772',330,'Retail Sale Id 1260997',4160.00,0.00,0.00,0.00,312.00,'2021-12-02 08:14:49','',''),(2122845,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-02 08:14:49','',''),(2122868,'1','139','772',330,'Retail Sale Id 1261012',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 08:16:21','',''),(2122869,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 08:16:21','',''),(2122954,'1','139','772',330,'Retail Sale Id 1261056',640.00,0.00,0.00,0.00,48.00,'2021-12-02 08:20:24','',''),(2122955,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-02 08:20:24','',''),(2122980,'1','139','772',330,'Retail Sale Id 1261071',1203.20,0.00,0.00,0.00,90.24,'2021-12-02 08:21:37','',''),(2122981,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-02 08:21:37','',''),(2123035,'1','139','772',330,'Retail Sale Id 1261098',1798.40,0.00,0.00,0.00,134.88,'2021-12-02 08:24:08','',''),(2123036,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-02 08:24:08','',''),(2123239,'1','139','772',330,'Retail Sale Id 1261202',5120.00,0.00,0.00,0.00,384.00,'2021-12-02 08:35:18','',''),(2123240,'1','139','772',330,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-02 08:35:18','',''),(2123267,'1','139','772',330,'Retail Sale Id 1261213',27450.00,0.00,0.00,0.00,810.00,'2021-12-02 08:36:59','',''),(2123268,'1','139','772',330,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-02 08:36:59','',''),(2123387,'1','139','772',330,'Retail Sale Id 1261251',36600.00,0.00,0.00,0.00,1080.00,'2021-12-02 08:40:58','',''),(2123388,'1','139','772',330,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-02 08:40:58','',''),(2123413,'1','139','772',330,'Retail Sale Id 1261266',7001.60,0.00,0.00,0.00,525.12,'2021-12-02 08:42:37','',''),(2123414,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-02 08:42:37','',''),(2123443,'1','139','772',330,'Retail Sale Id 1261280',3200.00,0.00,0.00,0.00,240.00,'2021-12-02 08:44:15','',''),(2123444,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 08:44:15','',''),(2123717,'1','139','772',330,'Retail Sale Id 1261418',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 09:00:10','',''),(2123718,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 09:00:10','',''),(2123741,'1','139','772',330,'Retail Sale Id 1261429',2560.00,0.00,0.00,0.00,192.00,'2021-12-02 09:01:04','',''),(2123742,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 09:01:04','',''),(2123989,'1','139','772',330,'Retail Sale Id 1261563',3520.00,0.00,0.00,0.00,264.00,'2021-12-02 09:12:53','',''),(2123990,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-02 09:12:53','',''),(2124132,'1','139','772',330,'Retail Sale Id 1261614',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 09:18:32','',''),(2124133,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 09:18:32','',''),(2124246,'1','139','772',330,'Retail Sale Id 1261676',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 09:25:22','',''),(2124247,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 09:25:22','',''),(2124264,'1','139','772',330,'Retail Sale Id 1261684',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 09:26:33','',''),(2124265,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 09:26:33','',''),(2124304,'1','139','772',330,'Retail Sale Id 1261703',9150.00,0.00,0.00,0.00,270.00,'2021-12-02 09:28:49','',''),(2124305,'1','139','772',330,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-02 09:28:49','',''),(2124479,'1','139','772',330,'Retail Sale Id 1261788',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 09:41:11','',''),(2124480,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:41:11','',''),(2124541,'1','139','772',330,'Retail Sale Id 1261822',640.00,0.00,0.00,0.00,48.00,'2021-12-02 09:44:14','',''),(2124542,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-02 09:44:14','',''),(2124578,'1','139','772',330,'Retail Sale Id 1261838',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 09:45:54','',''),(2124579,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 09:45:54','',''),(2124592,'1','139','772',330,'Retail Sale Id 1261845',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 09:46:56','',''),(2124593,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 09:46:56','',''),(2124655,'1','139','772',330,'Retail Sale Id 1261874',1600.00,0.00,0.00,0.00,120.00,'2021-12-02 09:50:14','',''),(2124656,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-02 09:50:14','',''),(2125057,'1','139','772',330,'Retail Sale Id 1262092',998.40,0.00,0.00,0.00,74.88,'2021-12-02 10:12:11','',''),(2125058,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 10:12:11','',''),(2125096,'1','139','772',330,'Retail Sale Id 1262107',3520.00,0.00,0.00,0.00,264.00,'2021-12-02 10:13:47','',''),(2125097,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-02 10:13:47','',''),(2125222,'1','139','772',330,'Retail Sale Id 1262178',2560.00,0.00,0.00,0.00,192.00,'2021-12-02 10:21:25','',''),(2125223,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 10:21:25','',''),(2125295,'1','139','772',330,'Retail Sale Id 1262205',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 10:24:41','',''),(2125296,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 10:24:41','',''),(2125321,'1','139','772',330,'Retail Sale Id 1262218',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 10:25:54','',''),(2125322,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 10:25:54','',''),(2125394,'1','139','772',330,'Retail Sale Id 1262258',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 10:30:57','',''),(2125395,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 10:30:57','',''),(2125416,'1','139','772',330,'Retail Sale Id 1262271',748.80,0.00,0.00,0.00,56.16,'2021-12-02 10:32:10','',''),(2125417,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.17,0.00,'2021-12-02 10:32:10','',''),(2125428,'1','139','772',330,'Retail Sale Id 1262276',54900.00,0.00,0.00,0.00,1620.00,'2021-12-02 10:33:25','',''),(2125429,'1','139','772',330,'Retail sales',0.00,0.00,0.00,90.00,0.00,'2021-12-02 10:33:25','',''),(2125506,'1','139','772',330,'Retail Sale Id 1262315',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 10:37:38','',''),(2125507,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 10:37:38','',''),(2125564,'1','139','772',330,'Retail Sale Id 1262342',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 10:41:41','',''),(2125565,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 10:41:41','',''),(2125652,'1','139','772',330,'Retail Sale Id 1262383',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 10:45:55','',''),(2125653,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:45:55','',''),(2125722,'1','139','772',330,'Retail Sale Id 1262414',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 10:51:06','',''),(2125723,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 10:51:06','',''),(2125746,'1','139','772',330,'Retail Sale Id 1262425',998.40,0.00,0.00,0.00,74.88,'2021-12-02 10:52:16','',''),(2125747,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 10:52:16','',''),(2125770,'1','139','772',330,'Retail Sale Id 1262439',2240.00,0.00,0.00,0.00,168.00,'2021-12-02 10:53:58','',''),(2125771,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-02 10:53:58','',''),(2125818,'1','139','772',330,'Retail Sale Id 1262463',6400.00,0.00,0.00,0.00,480.00,'2021-12-02 10:58:05','',''),(2125819,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 10:58:05','',''),(2125871,'1','139','772',330,'Retail Sale Id 1262487',2560.00,0.00,0.00,0.00,192.00,'2021-12-02 11:01:31','',''),(2125873,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 11:01:31','',''),(2125950,'1','139','772',330,'Retail Sale Id 1262531',1299.20,0.00,0.00,0.00,97.44,'2021-12-02 11:06:11','',''),(2125951,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 11:06:11','',''),(2126084,'1','139','772',330,'Retail Sale Id 1262609',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 11:14:35','',''),(2126085,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 11:14:35','',''),(2126250,'1','139','772',330,'Retail Sale Id 1262703',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 11:23:49','',''),(2126251,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 11:23:49','',''),(2126304,'1','139','772',330,'Retail Sale Id 1262727',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 11:27:23','',''),(2126305,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 11:27:23','',''),(2126435,'1','139','772',330,'Retail Sale Id 1262785',2560.00,0.00,0.00,0.00,192.00,'2021-12-02 11:32:47','',''),(2126436,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 11:32:47','',''),(2126470,'1','139','772',330,'Retail Sale Id 1262799',3001.60,0.00,0.00,0.00,225.12,'2021-12-02 11:34:37','',''),(2126471,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 11:34:37','',''),(2126828,'1','139','772',330,'Retail Sale Id 1262966',5120.00,0.00,0.00,0.00,384.00,'2021-12-02 11:58:45','',''),(2126829,'1','139','772',330,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-02 11:58:45','',''),(2126847,'1','139','772',330,'Retail Sale Id 1262977',7680.00,0.00,0.00,0.00,576.00,'2021-12-02 12:00:34','',''),(2126848,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 12:00:34','',''),(2126881,'1','139','772',330,'Retail Sale Id 1262994',3500.80,0.00,0.00,0.00,262.56,'2021-12-02 12:03:59','',''),(2126882,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 12:03:59','',''),(2127302,'1','139','772',330,'Retail Sale Id 1263227',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 12:37:57','',''),(2127303,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 12:37:57','',''),(2127359,'1','139','772',330,'Retail Sale Id 1263258',26230.00,0.00,0.00,0.00,774.00,'2021-12-02 12:42:36','',''),(2127360,'1','139','772',330,'Retail sales',0.00,0.00,0.00,43.00,0.00,'2021-12-02 12:42:36','',''),(2127630,'1','139','772',330,'Retail Sale Id 1263373',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 13:01:52','',''),(2127631,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 13:01:52','',''),(2127662,'1','139','772',330,'Retail Sale Id 1263395',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 13:04:25','',''),(2127663,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 13:04:25','',''),(2127716,'1','139','772',330,'Retail Sale Id 1263422',7320.00,0.00,0.00,0.00,216.00,'2021-12-02 13:08:42','',''),(2127717,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 13:08:42','',''),(2127768,'1','139','772',330,'Retail Sale Id 1263449',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 13:12:39','',''),(2127769,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 13:12:39','',''),(2127959,'1','139','772',330,'Retail Sale Id 1263523',6400.00,0.00,0.00,0.00,480.00,'2021-12-02 13:24:23','',''),(2127960,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 13:24:23','',''),(2128045,'1','139','772',330,'Retail Sale Id 1263557',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 13:30:08','',''),(2128046,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 13:30:08','',''),(2128194,'1','139','772',330,'Retail Sale Id 1263611',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 13:40:01','',''),(2128195,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 13:40:01','',''),(2128248,'1','139','772',330,'Retail Sale Id 1263640',4998.40,0.00,0.00,0.00,374.88,'2021-12-02 13:43:57','',''),(2128249,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 13:43:57','',''),(2128286,'1','139','772',330,'Retail Sale Id 1263656',122000.00,0.00,0.00,0.00,3600.00,'2021-12-02 13:46:10','',''),(2128287,'1','139','772',330,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-02 13:46:10','',''),(2128438,'1','139','772',330,'Retail Sale Id 1263729',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 13:54:38','',''),(2128439,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 13:54:38','',''),(2128455,'1','139','772',330,'Retail Sale Id 1263740',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 13:55:39','',''),(2128456,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 13:55:39','',''),(2128499,'1','139','772',330,'Retail Sale Id 1263754',2560.00,0.00,0.00,0.00,192.00,'2021-12-02 13:57:03','',''),(2128500,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 13:57:03','',''),(2128531,'1','139','772',330,'Retail Sale Id 1263768',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 13:58:44','',''),(2128532,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 13:58:44','',''),(2128592,'1','139','772',330,'Retail Sale Id 1263794',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 14:03:24','',''),(2128593,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 14:03:24','',''),(2128616,'1','139','772',330,'Retail Sale Id 1263806',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 14:04:36','',''),(2128617,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 14:04:36','',''),(2128636,'1','139','772',330,'Retail Sale Id 1263816',2560.00,0.00,0.00,0.00,192.00,'2021-12-02 14:05:52','',''),(2128637,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 14:05:52','',''),(2128690,'1','139','772',330,'Retail Sale Id 1263845',800.00,0.00,0.00,0.00,60.00,'2021-12-02 14:09:25','',''),(2128691,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-02 14:09:25','',''),(2128826,'1','139','772',330,'Retail Sale Id 1263902',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 14:17:18','',''),(2128827,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 14:17:18','',''),(2128868,'1','139','772',330,'Retail Sale Id 1263924',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 14:19:15','',''),(2128869,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 14:19:15','',''),(2128906,'1','139','772',330,'Retail Sale Id 1263943',3840.00,0.00,0.00,0.00,288.00,'2021-12-02 14:21:27','',''),(2128907,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 14:21:27','',''),(2128950,'1','139','772',330,'Retail Sale Id 1263958',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 14:22:59','',''),(2128951,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 14:22:59','',''),(2128997,'1','139','772',330,'Retail Sale Id 1263970',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 14:24:39','',''),(2128998,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:24:39','',''),(2129158,'1','139','772',330,'Retail Sale Id 1264031',4160.00,0.00,0.00,0.00,312.00,'2021-12-02 14:30:48','',''),(2129159,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-02 14:30:48','',''),(2129196,'1','139','772',330,'Retail Sale Id 1264040',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 14:31:59','',''),(2129197,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:31:59','',''),(2129230,'1','139','772',330,'Retail Sale Id 1264055',3001.60,0.00,0.00,0.00,225.12,'2021-12-02 14:34:21','',''),(2129231,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 14:34:21','',''),(2129256,'1','139','772',330,'Retail Sale Id 1264070',6400.00,0.00,0.00,0.00,480.00,'2021-12-02 14:36:00','',''),(2129257,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 14:36:00','',''),(2129349,'1','139','772',330,'Retail Sale Id 1264105',3840.00,0.00,0.00,0.00,288.00,'2021-12-02 14:39:23','',''),(2129350,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 14:39:23','',''),(2129433,'1','139','772',330,'Retail Sale Id 1264133',1600.00,0.00,0.00,0.00,120.00,'2021-12-02 14:42:55','',''),(2129434,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-02 14:42:55','',''),(2129519,'1','139','772',330,'Retail Sale Id 1264179',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 14:48:27','',''),(2129520,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 14:48:27','',''),(2129693,'1','139','772',330,'Retail Sale Id 1264276',8960.00,0.00,0.00,0.00,672.00,'2021-12-02 14:58:01','',''),(2129694,'1','139','772',330,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-02 14:58:01','',''),(2129717,'1','139','772',330,'Retail Sale Id 1264285',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 14:58:56','',''),(2129718,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 14:58:56','',''),(2129892,'1','139','772',330,'Retail Sale Id 1264372',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 15:12:46','',''),(2129893,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 15:12:46','',''),(2129902,'1','139','772',330,'Retail Sale Id 1264378',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 15:13:34','',''),(2129903,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 15:13:34','',''),(2129930,'1','139','772',330,'Retail Sale Id 1264391',4160.00,0.00,0.00,0.00,312.00,'2021-12-02 15:14:29','',''),(2129931,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-02 15:14:29','',''),(2130118,'1','139','772',330,'Retail Sale Id 1264488',3840.00,0.00,0.00,0.00,288.00,'2021-12-02 15:24:13','',''),(2130119,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 15:24:13','',''),(2130136,'1','139','772',330,'Retail Sale Id 1264495',2880.00,0.00,0.00,0.00,216.00,'2021-12-02 15:25:17','',''),(2130137,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-02 15:25:17','',''),(2130188,'1','139','772',330,'Retail Sale Id 1264524',4160.00,0.00,0.00,0.00,312.00,'2021-12-02 15:27:24','',''),(2130189,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-02 15:27:24','',''),(2130223,'1','139','772',330,'Retail Sale Id 1264538',3001.60,0.00,0.00,0.00,225.12,'2021-12-02 15:28:23','',''),(2130224,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 15:28:23','',''),(2130277,'1','139','772',330,'Retail Sale Id 1264561',1600.00,0.00,0.00,0.00,120.00,'2021-12-02 15:30:49','',''),(2130278,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-02 15:30:49','',''),(2130291,'1','139','772',330,'Retail Sale Id 1264569',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 15:31:38','',''),(2130292,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 15:31:38','',''),(2130337,'1','139','772',330,'Retail Sale Id 1264591',4480.00,0.00,0.00,0.00,336.00,'2021-12-02 15:33:51','',''),(2130338,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 15:33:51','',''),(2130366,'1','139','772',330,'Retail Sale Id 1264604',2560.00,0.00,0.00,0.00,192.00,'2021-12-02 15:34:57','',''),(2130367,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 15:34:57','',''),(2130400,'1','139','772',330,'Retail Sale Id 1264616',998.40,0.00,0.00,0.00,74.88,'2021-12-02 15:36:26','',''),(2130401,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 15:36:26','',''),(2130474,'1','139','772',330,'Retail Sale Id 1264656',5120.00,0.00,0.00,0.00,384.00,'2021-12-02 15:40:18','',''),(2130475,'1','139','772',330,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-02 15:40:18','',''),(2130512,'1','139','772',330,'Retail Sale Id 1264674',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 15:41:49','',''),(2130513,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:41:49','',''),(2130532,'1','139','772',330,'Retail Sale Id 1264690',2560.00,0.00,0.00,0.00,192.00,'2021-12-02 15:42:59','',''),(2130533,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 15:42:59','',''),(2130582,'1','139','772',330,'Retail Sale Id 1264719',9600.00,0.00,0.00,0.00,720.00,'2021-12-02 15:44:58','',''),(2130583,'1','139','772',330,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-02 15:44:58','',''),(2130620,'1','139','772',330,'Retail Sale Id 1264742',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 15:46:36','',''),(2130621,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:46:36','',''),(2130646,'1','139','772',330,'Retail Sale Id 1264757',3520.00,0.00,0.00,0.00,264.00,'2021-12-02 15:48:09','',''),(2130647,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-02 15:48:09','',''),(2130676,'1','139','772',330,'Retail Sale Id 1264772',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 15:49:24','',''),(2130677,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:49:24','',''),(2130694,'1','139','772',330,'Retail Sale Id 1264785',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 15:50:31','',''),(2130695,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:50:31','',''),(2130726,'1','139','772',330,'Retail Sale Id 1264801',2502.40,0.00,0.00,0.00,187.68,'2021-12-02 15:51:35','',''),(2130727,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 15:51:35','',''),(2130760,'1','139','772',330,'Retail Sale Id 1264818',3001.60,0.00,0.00,0.00,225.12,'2021-12-02 15:53:09','',''),(2130761,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 15:53:09','',''),(2130792,'1','139','772',330,'Retail Sale Id 1264832',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 15:54:17','',''),(2130793,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 15:54:17','',''),(2130828,'1','139','772',330,'Retail Sale Id 1264853',5120.00,0.00,0.00,0.00,384.00,'2021-12-02 15:55:27','',''),(2130829,'1','139','772',330,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-02 15:55:27','',''),(2130852,'1','139','772',330,'Retail Sale Id 1264864',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 15:56:34','',''),(2130853,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:56:34','',''),(2130968,'1','139','772',330,'Retail Sale Id 1264921',3840.00,0.00,0.00,0.00,288.00,'2021-12-02 16:01:53','',''),(2130969,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:01:53','',''),(2131004,'1','139','772',330,'Retail Sale Id 1264936',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 16:03:19','',''),(2131005,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:03:19','',''),(2131031,'1','139','772',330,'Retail Sale Id 1264946',1600.00,0.00,0.00,0.00,120.00,'2021-12-02 16:04:35','',''),(2131032,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-02 16:04:35','',''),(2131056,'1','139','772',330,'Retail Sale Id 1264958',1600.00,0.00,0.00,0.00,120.00,'2021-12-02 16:05:48','',''),(2131057,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-02 16:05:48','',''),(2131140,'1','139','772',330,'Retail Sale Id 1264991',183000.00,0.00,0.00,0.00,5400.00,'2021-12-02 16:08:53','',''),(2131141,'1','139','772',330,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-02 16:08:53','',''),(2131164,'1','139','772',330,'Retail Sale Id 1265007',3200.00,0.00,0.00,0.00,240.00,'2021-12-02 16:09:52','',''),(2131165,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 16:09:52','',''),(2131180,'1','139','772',330,'Retail Sale Id 1265017',3840.00,0.00,0.00,0.00,288.00,'2021-12-02 16:10:54','',''),(2131181,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:10:54','',''),(2131210,'1','139','772',330,'Retail Sale Id 1265034',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 16:12:30','',''),(2131211,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 16:12:30','',''),(2131240,'1','139','772',330,'Retail Sale Id 1265052',2240.00,0.00,0.00,0.00,168.00,'2021-12-02 16:14:05','',''),(2131241,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-02 16:14:05','',''),(2131257,'1','139','772',330,'Retail Sale Id 1265058',2502.40,0.00,0.00,0.00,187.68,'2021-12-02 16:14:55','',''),(2131258,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 16:14:55','',''),(2131293,'1','139','772',330,'Retail Sale Id 1265075',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 16:16:36','',''),(2131294,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 16:16:36','',''),(2131321,'1','139','772',330,'Retail Sale Id 1265090',3001.60,0.00,0.00,0.00,225.12,'2021-12-02 16:18:19','',''),(2131322,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 16:18:19','',''),(2131375,'1','139','772',330,'Retail Sale Id 1265118',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 16:20:56','',''),(2131376,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:20:56','',''),(2131394,'1','139','772',330,'Retail Sale Id 1265131',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 16:21:56','',''),(2131395,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 16:21:56','',''),(2131416,'1','139','772',330,'Retail Sale Id 1265139',3840.00,0.00,0.00,0.00,288.00,'2021-12-02 16:23:08','',''),(2131417,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:23:08','',''),(2131460,'1','139','772',330,'Retail Sale Id 1265159',3200.00,0.00,0.00,0.00,240.00,'2021-12-02 16:25:25','',''),(2131461,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 16:25:25','',''),(2131502,'1','139','772',330,'Retail Sale Id 1265181',3500.80,0.00,0.00,0.00,262.56,'2021-12-02 16:27:14','',''),(2131503,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 16:27:14','',''),(2131546,'1','139','772',330,'Retail Sale Id 1265202',3840.00,0.00,0.00,0.00,288.00,'2021-12-02 16:28:59','',''),(2131547,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:28:59','',''),(2131608,'1','139','772',330,'Retail Sale Id 1265221',3001.60,0.00,0.00,0.00,225.12,'2021-12-02 16:30:02','',''),(2131609,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 16:30:02','',''),(2131638,'1','139','772',330,'Retail Sale Id 1265234',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 16:30:59','',''),(2131639,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:30:59','',''),(2131664,'1','139','772',330,'Retail Sale Id 1265247',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 16:32:03','',''),(2131665,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:32:03','',''),(2131678,'1','139','772',330,'Retail Sale Id 1265258',2560.00,0.00,0.00,0.00,192.00,'2021-12-02 16:33:02','',''),(2131679,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 16:33:02','',''),(2131712,'1','139','772',330,'Retail Sale Id 1265280',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 16:34:31','',''),(2131713,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:34:31','',''),(2131742,'1','139','772',330,'Retail Sale Id 1265293',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 16:36:15','',''),(2131743,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 16:36:15','',''),(2131766,'1','139','772',330,'Retail Sale Id 1265308',2560.00,0.00,0.00,0.00,192.00,'2021-12-02 16:38:13','',''),(2131767,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 16:38:13','',''),(2131784,'1','139','772',330,'Retail Sale Id 1265314',3200.00,0.00,0.00,0.00,240.00,'2021-12-02 16:39:33','',''),(2131785,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 16:39:33','',''),(2131812,'1','139','772',330,'Retail Sale Id 1265325',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 16:40:34','',''),(2131813,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 16:40:34','',''),(2131863,'1','139','772',330,'Retail Sale Id 1265352',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 16:43:07','',''),(2131864,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 16:43:07','',''),(2131887,'1','139','772',330,'Retail Sale Id 1265360',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 16:44:02','',''),(2131888,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:44:02','',''),(2131919,'1','139','772',330,'Retail Sale Id 1265375',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 16:45:07','',''),(2131920,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:45:07','',''),(2131940,'1','139','772',330,'Retail Sale Id 1265388',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 16:46:12','',''),(2131941,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:46:12','',''),(2131968,'1','139','772',330,'Retail Sale Id 1265403',2240.00,0.00,0.00,0.00,168.00,'2021-12-02 16:47:29','',''),(2131969,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-02 16:47:29','',''),(2131982,'1','139','772',330,'Retail Sale Id 1265412',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 16:48:28','',''),(2131983,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:48:28','',''),(2132001,'1','139','772',330,'Retail Sale Id 1265420',2560.00,0.00,0.00,0.00,192.00,'2021-12-02 16:49:50','',''),(2132003,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 16:49:50','',''),(2132024,'1','139','772',330,'Retail Sale Id 1265439',902.40,0.00,0.00,0.00,67.68,'2021-12-02 16:51:14','',''),(2132025,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-02 16:51:14','',''),(2132040,'1','139','772',330,'Retail Sale Id 1265445',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 16:52:23','',''),(2132041,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:52:23','',''),(2132058,'1','139','772',330,'Retail Sale Id 1265454',3001.60,0.00,0.00,0.00,225.12,'2021-12-02 16:53:23','',''),(2132059,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 16:53:23','',''),(2132072,'1','139','772',330,'Retail Sale Id 1265462',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 16:54:28','',''),(2132073,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 16:54:28','',''),(2132099,'1','139','772',330,'Retail Sale Id 1265472',1600.00,0.00,0.00,0.00,120.00,'2021-12-02 16:55:50','',''),(2132100,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-02 16:55:50','',''),(2132114,'1','139','772',330,'Retail Sale Id 1265481',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 16:56:55','',''),(2132115,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:56:55','',''),(2132133,'1','139','772',330,'Retail Sale Id 1265491',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 16:58:07','',''),(2132134,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:58:07','',''),(2132152,'1','139','772',330,'Retail Sale Id 1265504',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 16:59:14','',''),(2132153,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 16:59:14','',''),(2132187,'1','139','772',330,'Retail Sale Id 1265514',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 17:01:26','',''),(2132188,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 17:01:26','',''),(2132213,'1','139','772',330,'Retail Sale Id 1265525',3840.00,0.00,0.00,0.00,288.00,'2021-12-02 17:02:38','',''),(2132214,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 17:02:38','',''),(2132241,'1','139','772',330,'Retail Sale Id 1265536',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 17:04:31','',''),(2132242,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 17:04:31','',''),(2132282,'1','139','772',330,'Retail Sale Id 1265557',3840.00,0.00,0.00,0.00,288.00,'2021-12-02 17:06:57','',''),(2132283,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 17:06:57','',''),(2132299,'1','139','772',330,'Retail Sale Id 1265565',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 17:08:00','',''),(2132300,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 17:08:00','',''),(2132309,'1','139','772',330,'Retail Sale Id 1265572',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 17:08:59','',''),(2132310,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 17:08:59','',''),(2132325,'1','139','772',330,'Retail Sale Id 1265580',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 17:10:09','',''),(2132326,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 17:10:09','',''),(2132340,'1','139','772',330,'Retail Sale Id 1265587',1280.00,0.00,0.00,0.00,96.00,'2021-12-02 17:11:20','',''),(2132341,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 17:11:20','',''),(2132362,'1','139','772',330,'Retail Sale Id 1265596',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 17:12:34','',''),(2132363,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 17:12:34','',''),(2132375,'1','139','772',330,'Retail Sale Id 1265603',7680.00,0.00,0.00,0.00,576.00,'2021-12-02 17:13:24','',''),(2132376,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 17:13:24','',''),(2132404,'1','139','772',330,'Retail Sale Id 1265622',89487.00,0.00,0.00,0.00,2640.60,'2021-12-02 17:15:18','',''),(2132405,'1','139','772',330,'Retail sales',0.00,0.00,0.00,146.70,0.00,'2021-12-02 17:15:18','',''),(2132464,'1','139','772',330,'Retail Sale Id 1265642',122000.00,0.00,0.00,0.00,3600.00,'2021-12-02 17:18:12','',''),(2132465,'1','139','772',330,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-02 17:18:12','',''),(2132485,'1','139','772',330,'Retail Sale Id 1265651',1798.40,0.00,0.00,0.00,134.88,'2021-12-02 17:19:04','',''),(2132486,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-02 17:19:04','',''),(2132503,'1','139','772',330,'Retail Sale Id 1265659',1920.00,0.00,0.00,0.00,144.00,'2021-12-02 17:20:22','',''),(2132504,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 17:20:22','',''),(2132549,'1','139','772',330,'Retail Sale Id 1265674',115900.00,0.00,0.00,0.00,3420.00,'2021-12-02 17:22:08','',''),(2132550,'1','139','772',330,'Retail sales',0.00,0.00,0.00,190.00,0.00,'2021-12-02 17:22:08','',''),(2132565,'1','139','772',330,'Retail Sale Id 1265685',3355.00,0.00,0.00,0.00,99.00,'2021-12-02 17:23:21','',''),(2132566,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-02 17:23:21','',''),(2132603,'1','139','772',330,'Retail Sale Id 1265706',1818000.00,0.00,0.00,0.00,42000.00,'2021-12-02 17:26:45','',''),(2132604,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3000.00,0.00,'2021-12-02 17:26:45','',''),(2134264,'1','139','772',330,'Retail Sale Id 1266218',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 06:34:59','',''),(2134265,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 06:34:59','',''),(2134294,'1','139','772',330,'Retail Sale Id 1266232',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 06:36:38','',''),(2134295,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 06:36:38','',''),(2134311,'1','139','772',330,'Retail Sale Id 1266240',1600.00,0.00,0.00,0.00,120.00,'2021-12-03 06:37:42','',''),(2134312,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-03 06:37:42','',''),(2134338,'1','139','772',330,'Retail Sale Id 1266253',1600.00,0.00,0.00,0.00,120.00,'2021-12-03 06:38:51','',''),(2134339,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-03 06:38:51','',''),(2134366,'1','139','772',330,'Retail Sale Id 1266272',2240.00,0.00,0.00,0.00,168.00,'2021-12-03 06:40:32','',''),(2134367,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-03 06:40:32','',''),(2134381,'1','139','772',330,'Retail Sale Id 1266279',1600.00,0.00,0.00,0.00,120.00,'2021-12-03 06:41:39','',''),(2134382,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-03 06:41:39','',''),(2134401,'1','139','772',330,'Retail Sale Id 1266290',3840.00,0.00,0.00,0.00,288.00,'2021-12-03 06:42:49','',''),(2134402,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 06:42:49','',''),(2134423,'1','139','772',330,'Retail Sale Id 1266300',998.40,0.00,0.00,0.00,74.88,'2021-12-03 06:43:46','',''),(2134424,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 06:43:46','',''),(2134443,'1','139','772',330,'Retail Sale Id 1266311',3500.80,0.00,0.00,0.00,262.56,'2021-12-03 06:44:48','',''),(2134444,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-03 06:44:48','',''),(2134509,'1','139','772',330,'Retail Sale Id 1266344',1280.00,0.00,0.00,0.00,96.00,'2021-12-03 06:48:03','',''),(2134510,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 06:48:03','',''),(2134557,'1','139','772',330,'Retail Sale Id 1266364',1702.40,0.00,0.00,0.00,127.68,'2021-12-03 06:50:46','',''),(2134558,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-03 06:50:46','',''),(2134639,'1','139','772',330,'Retail Sale Id 1266407',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 06:55:07','',''),(2134640,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 06:55:07','',''),(2134661,'1','139','772',330,'Retail Sale Id 1266419',1920.00,0.00,0.00,0.00,144.00,'2021-12-03 06:56:11','',''),(2134662,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 06:56:11','',''),(2134683,'1','139','772',330,'Retail Sale Id 1266430',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 06:57:17','',''),(2134684,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 06:57:17','',''),(2134700,'1','139','772',330,'Retail Sale Id 1266436',1920.00,0.00,0.00,0.00,144.00,'2021-12-03 06:58:13','',''),(2134701,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 06:58:13','',''),(2134801,'1','139','772',330,'Retail Sale Id 1266488',4998.40,0.00,0.00,0.00,374.88,'2021-12-03 07:04:39','',''),(2134802,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 07:04:39','',''),(2134827,'1','139','772',330,'Retail Sale Id 1266504',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 07:06:12','',''),(2134828,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:06:12','',''),(2134855,'1','139','772',330,'Retail Sale Id 1266521',1920.00,0.00,0.00,0.00,144.00,'2021-12-03 07:07:52','',''),(2134856,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 07:07:52','',''),(2134873,'1','139','772',330,'Retail Sale Id 1266530',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 07:09:06','',''),(2134874,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 07:09:06','',''),(2134885,'1','139','772',330,'Retail Sale Id 1266536',7680.00,0.00,0.00,0.00,576.00,'2021-12-03 07:10:09','',''),(2134886,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-03 07:10:09','',''),(2134897,'1','139','772',330,'Retail Sale Id 1266543',1920.00,0.00,0.00,0.00,144.00,'2021-12-03 07:11:07','',''),(2134898,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 07:11:07','',''),(2134948,'1','139','772',330,'Retail Sale Id 1266555',998.40,0.00,0.00,0.00,74.88,'2021-12-03 07:12:31','',''),(2134949,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 07:12:31','',''),(2134978,'1','139','772',330,'Retail Sale Id 1266572',6400.00,0.00,0.00,0.00,480.00,'2021-12-03 07:14:17','',''),(2134979,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 07:14:17','',''),(2134994,'1','139','772',330,'Retail Sale Id 1266581',1920.00,0.00,0.00,0.00,144.00,'2021-12-03 07:15:21','',''),(2134995,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 07:15:21','',''),(2135016,'1','139','772',330,'Retail Sale Id 1266593',36600.00,0.00,0.00,0.00,1080.00,'2021-12-03 07:16:27','',''),(2135017,'1','139','772',330,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-03 07:16:27','',''),(2135097,'1','139','772',330,'Retail Sale Id 1266627',697.60,0.00,0.00,0.00,52.32,'2021-12-03 07:20:34','',''),(2135098,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-03 07:20:34','',''),(2135113,'1','139','772',330,'Retail Sale Id 1266635',1920.00,0.00,0.00,0.00,144.00,'2021-12-03 07:21:44','',''),(2135114,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 07:21:44','',''),(2135151,'1','139','772',330,'Retail Sale Id 1266655',3520.00,0.00,0.00,0.00,264.00,'2021-12-03 07:23:54','',''),(2135152,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-03 07:23:54','',''),(2135182,'1','139','772',330,'Retail Sale Id 1266670',998.40,0.00,0.00,0.00,74.88,'2021-12-03 07:25:48','',''),(2135183,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 07:25:48','',''),(2135218,'1','139','772',330,'Retail Sale Id 1266687',640.00,0.00,0.00,0.00,48.00,'2021-12-03 07:27:50','',''),(2135219,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 07:27:50','',''),(2135240,'1','139','772',330,'Retail Sale Id 1266700',998.40,0.00,0.00,0.00,74.88,'2021-12-03 07:29:21','',''),(2135241,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 07:29:21','',''),(2135246,'1','139','772',330,'Retail Sale Id 1266703',1920.00,0.00,0.00,0.00,144.00,'2021-12-03 07:30:18','',''),(2135247,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 07:30:18','',''),(2135266,'1','139','772',330,'Retail Sale Id 1266713',1920.00,0.00,0.00,0.00,144.00,'2021-12-03 07:31:16','',''),(2135267,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 07:31:16','',''),(2135284,'1','139','772',330,'Retail Sale Id 1266722',998.40,0.00,0.00,0.00,74.88,'2021-12-03 07:32:21','',''),(2135285,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 07:32:21','',''),(2135409,'1','139','772',330,'Retail Sale Id 1266778',3840.00,0.00,0.00,0.00,288.00,'2021-12-03 07:38:18','',''),(2135410,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 07:38:18','',''),(2135445,'1','139','772',330,'Retail Sale Id 1266796',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 07:40:14','',''),(2135446,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 07:40:14','',''),(2135457,'1','139','772',330,'Retail Sale Id 1266804',640.00,0.00,0.00,0.00,48.00,'2021-12-03 07:41:24','',''),(2135458,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 07:41:24','',''),(2135536,'1','139','772',330,'Retail Sale Id 1266840',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 07:46:03','',''),(2135537,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 07:46:03','',''),(2135742,'1','139','772',330,'Retail Sale Id 1266934',800.00,0.00,0.00,0.00,60.00,'2021-12-03 07:56:33','',''),(2135743,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-03 07:56:33','',''),(2135866,'1','139','772',330,'Retail Sale Id 1266979',4480.00,0.00,0.00,0.00,336.00,'2021-12-03 08:01:57','',''),(2135867,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-03 08:01:57','',''),(2135921,'1','139','772',330,'Retail Sale Id 1266995',4499.20,0.00,0.00,0.00,337.44,'2021-12-03 08:03:06','',''),(2135922,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-03 08:03:06','',''),(2135943,'1','139','772',330,'Retail Sale Id 1267006',640.00,0.00,0.00,0.00,48.00,'2021-12-03 08:04:28','',''),(2135944,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 08:04:28','',''),(2135974,'1','139','772',330,'Retail Sale Id 1267025',697.60,0.00,0.00,0.00,52.32,'2021-12-03 08:05:48','',''),(2135975,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-03 08:05:48','',''),(2136044,'1','139','772',330,'Retail Sale Id 1267046',2240.00,0.00,0.00,0.00,168.00,'2021-12-03 08:08:23','',''),(2136045,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-03 08:08:23','',''),(2136074,'1','139','772',330,'Retail Sale Id 1267068',36600.00,0.00,0.00,0.00,1080.00,'2021-12-03 08:10:18','',''),(2136075,'1','139','772',330,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-03 08:10:18','',''),(2136098,'1','139','772',330,'Retail Sale Id 1267085',3302.40,0.00,0.00,0.00,247.68,'2021-12-03 08:11:20','',''),(2136099,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.16,0.00,'2021-12-03 08:11:20','',''),(2136126,'1','139','772',330,'Retail Sale Id 1267095',1920.00,0.00,0.00,0.00,144.00,'2021-12-03 08:12:51','',''),(2136127,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 08:12:51','',''),(2136230,'1','139','772',330,'Retail Sale Id 1267156',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 08:18:18','',''),(2136231,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 08:18:18','',''),(2136257,'1','139','772',330,'Retail Sale Id 1267167',1920.00,0.00,0.00,0.00,144.00,'2021-12-03 08:20:08','',''),(2136258,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 08:20:08','',''),(2136304,'1','139','772',330,'Retail Sale Id 1267190',36600.00,0.00,0.00,0.00,1080.00,'2021-12-03 08:22:42','',''),(2136305,'1','139','772',330,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-03 08:22:42','',''),(2136346,'1','139','772',330,'Retail Sale Id 1267211',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 08:25:06','',''),(2136347,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 08:25:06','',''),(2136362,'1','139','772',330,'Retail Sale Id 1267217',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 08:25:53','',''),(2136363,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 08:25:53','',''),(2136487,'1','139','772',330,'Retail Sale Id 1267266',1280.00,0.00,0.00,0.00,96.00,'2021-12-03 08:33:59','',''),(2136488,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 08:33:59','',''),(2136583,'1','139','772',330,'Retail Sale Id 1267287',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 08:37:14','',''),(2136584,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 08:37:14','',''),(2136637,'1','139','772',330,'Retail Sale Id 1267300',1920.00,0.00,0.00,0.00,144.00,'2021-12-03 08:38:41','',''),(2136638,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 08:38:41','',''),(2136776,'1','139','772',330,'Retail Sale Id 1267348',998.40,0.00,0.00,0.00,74.88,'2021-12-03 08:43:48','',''),(2136777,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 08:43:48','',''),(2136812,'1','139','772',330,'Retail Sale Id 1267360',134200.00,0.00,0.00,0.00,3960.00,'2021-12-03 08:45:53','',''),(2136813,'1','139','772',330,'Retail sales',0.00,0.00,0.00,220.00,0.00,'2021-12-03 08:45:53','',''),(2136854,'1','139','772',330,'Retail Sale Id 1267386',1920.00,0.00,0.00,0.00,144.00,'2021-12-03 08:48:40','',''),(2136855,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 08:48:40','',''),(2137040,'1','139','772',330,'Retail Sale Id 1267483',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 08:59:37','',''),(2137041,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 08:59:37','',''),(2137229,'1','139','772',330,'Retail Sale Id 1267583',1280.00,0.00,0.00,0.00,96.00,'2021-12-03 09:08:21','',''),(2137230,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 09:08:21','',''),(2137257,'1','139','772',330,'Retail Sale Id 1267604',2880.00,0.00,0.00,0.00,216.00,'2021-12-03 09:10:00','',''),(2137258,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-03 09:10:00','',''),(2137296,'1','139','772',330,'Retail Sale Id 1267636',4480.00,0.00,0.00,0.00,336.00,'2021-12-03 09:12:10','',''),(2137297,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-03 09:12:10','',''),(2137332,'1','139','772',330,'Retail Sale Id 1267658',100650.00,0.00,0.00,0.00,2970.00,'2021-12-03 09:13:44','',''),(2137333,'1','139','772',330,'Retail sales',0.00,0.00,0.00,165.00,0.00,'2021-12-03 09:13:44','',''),(2137352,'1','139','772',330,'Retail Sale Id 1267666',998.40,0.00,0.00,0.00,74.88,'2021-12-03 09:14:44','',''),(2137353,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 09:14:44','',''),(2137378,'1','139','772',330,'Retail Sale Id 1267679',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 09:15:48','',''),(2137379,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 09:15:48','',''),(2137405,'1','139','772',330,'Retail Sale Id 1267699',3840.00,0.00,0.00,0.00,288.00,'2021-12-03 09:17:19','',''),(2137406,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 09:17:19','',''),(2137461,'1','139','772',330,'Retail Sale Id 1267722',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 09:19:53','',''),(2137462,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 09:19:53','',''),(2137473,'1','139','772',330,'Retail Sale Id 1267728',4998.40,0.00,0.00,0.00,374.88,'2021-12-03 09:20:51','',''),(2137474,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 09:20:51','',''),(2137503,'1','139','772',330,'Retail Sale Id 1267745',1280.00,0.00,0.00,0.00,96.00,'2021-12-03 09:22:43','',''),(2137504,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 09:22:43','',''),(2137541,'1','139','772',330,'Retail Sale Id 1267767',36600.00,0.00,0.00,0.00,1080.00,'2021-12-03 09:25:15','',''),(2137542,'1','139','772',330,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-03 09:25:15','',''),(2137583,'1','139','772',330,'Retail Sale Id 1267789',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 09:27:44','',''),(2137584,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 09:27:44','',''),(2137629,'1','139','772',330,'Retail Sale Id 1267819',998.40,0.00,0.00,0.00,74.88,'2021-12-03 09:30:48','',''),(2137630,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 09:30:48','',''),(2137653,'1','139','772',330,'Retail Sale Id 1267829',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 09:32:19','',''),(2137654,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 09:32:19','',''),(2137669,'1','139','772',330,'Retail Sale Id 1267840',697.60,0.00,0.00,0.00,52.32,'2021-12-03 09:33:26','',''),(2137670,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-03 09:33:26','',''),(2137695,'1','139','772',330,'Retail Sale Id 1267853',1280.00,0.00,0.00,0.00,96.00,'2021-12-03 09:34:52','',''),(2137696,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 09:34:52','',''),(2137713,'1','139','772',330,'Retail Sale Id 1267863',1280.00,0.00,0.00,0.00,96.00,'2021-12-03 09:35:53','',''),(2137714,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 09:35:53','',''),(2137944,'1','139','772',330,'Retail Sale Id 1267982',697.60,0.00,0.00,0.00,52.32,'2021-12-03 09:49:47','',''),(2137945,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-03 09:49:47','',''),(2138046,'1','139','772',330,'Retail Sale Id 1268035',697.60,0.00,0.00,0.00,52.32,'2021-12-03 09:56:49','',''),(2138047,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-03 09:56:49','',''),(2138114,'1','139','772',330,'Retail Sale Id 1268067',1920.00,0.00,0.00,0.00,144.00,'2021-12-03 10:00:54','',''),(2138115,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 10:00:54','',''),(2138144,'1','139','772',330,'Retail Sale Id 1268078',2560.00,0.00,0.00,0.00,192.00,'2021-12-03 10:02:38','',''),(2138145,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 10:02:38','',''),(2138171,'1','139','772',330,'Retail Sale Id 1268096',2502.40,0.00,0.00,0.00,187.68,'2021-12-03 10:04:25','',''),(2138172,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 10:04:25','',''),(2138209,'1','139','772',330,'Retail Sale Id 1268117',176900.00,0.00,0.00,0.00,5220.00,'2021-12-03 10:06:27','',''),(2138210,'1','139','772',330,'Retail sales',0.00,0.00,0.00,290.00,0.00,'2021-12-03 10:06:27','',''),(2138237,'1','139','772',330,'Retail Sale Id 1268131',998.40,0.00,0.00,0.00,74.88,'2021-12-03 10:07:40','',''),(2138238,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 10:07:40','',''),(2138286,'1','139','772',330,'Retail Sale Id 1268154',5120.00,0.00,0.00,0.00,384.00,'2021-12-03 10:10:08','',''),(2138287,'1','139','772',330,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-03 10:10:08','',''),(2138319,'1','139','772',330,'Retail Sale Id 1268172',998.40,0.00,0.00,0.00,74.88,'2021-12-03 10:11:42','',''),(2138321,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 10:11:42','',''),(2138421,'1','139','772',330,'Retail Sale Id 1268221',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 10:17:32','',''),(2138422,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 10:17:32','',''),(2138490,'1','139','772',330,'Retail Sale Id 1268254',697.60,0.00,0.00,0.00,52.32,'2021-12-03 10:22:01','',''),(2138491,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-03 10:22:01','',''),(2138584,'1','139','772',330,'Retail Sale Id 1268298',1920.00,0.00,0.00,0.00,144.00,'2021-12-03 10:26:51','',''),(2138585,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 10:26:51','',''),(2138621,'1','139','772',330,'Retail Sale Id 1268319',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 10:29:45','',''),(2138622,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 10:29:45','',''),(2138676,'1','139','772',330,'Retail Sale Id 1268345',8320.00,0.00,0.00,0.00,624.00,'2021-12-03 10:32:42','',''),(2138677,'1','139','772',330,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-03 10:32:42','',''),(2138703,'1','139','772',330,'Retail Sale Id 1268355',1280.00,0.00,0.00,0.00,96.00,'2021-12-03 10:35:02','',''),(2138704,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 10:35:02','',''),(2138747,'1','139','772',330,'Retail Sale Id 1268375',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 10:37:00','',''),(2138748,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 10:37:00','',''),(2138809,'1','139','772',330,'Retail Sale Id 1268407',1100.80,0.00,0.00,0.00,82.56,'2021-12-03 10:40:45','',''),(2138810,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.72,0.00,'2021-12-03 10:40:45','',''),(2138847,'1','139','772',330,'Retail Sale Id 1268433',998.40,0.00,0.00,0.00,74.88,'2021-12-03 10:43:55','',''),(2138848,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 10:43:55','',''),(2138997,'1','139','772',330,'Retail Sale Id 1268511',73200.00,0.00,0.00,0.00,2160.00,'2021-12-03 10:56:20','',''),(2138998,'1','139','772',330,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-03 10:56:20','',''),(2139054,'1','139','772',330,'Retail Sale Id 1268539',697.60,0.00,0.00,0.00,52.32,'2021-12-03 11:00:55','',''),(2139055,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-03 11:00:55','',''),(2139103,'1','139','772',330,'Retail Sale Id 1268559',43920.00,0.00,0.00,0.00,1296.00,'2021-12-03 11:04:20','',''),(2139104,'1','139','772',330,'Retail sales',0.00,0.00,0.00,72.00,0.00,'2021-12-03 11:04:20','',''),(2139127,'1','139','772',330,'Retail Sale Id 1268578',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 11:05:52','',''),(2139128,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:05:52','',''),(2139139,'1','139','772',330,'Retail Sale Id 1268584',3840.00,0.00,0.00,0.00,288.00,'2021-12-03 11:07:02','',''),(2139140,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 11:07:02','',''),(2139233,'1','139','772',330,'Retail Sale Id 1268634',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 11:14:20','',''),(2139234,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 11:14:20','',''),(2139370,'1','139','772',330,'Retail Sale Id 1268700',2240.00,0.00,0.00,0.00,168.00,'2021-12-03 11:24:26','',''),(2139371,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-03 11:24:26','',''),(2139437,'1','139','772',330,'Retail Sale Id 1268741',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 11:29:50','',''),(2139438,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:29:50','',''),(2139480,'1','139','772',330,'Retail Sale Id 1268764',640.00,0.00,0.00,0.00,48.00,'2021-12-03 11:33:37','',''),(2139481,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 11:33:37','',''),(2139580,'1','139','772',330,'Retail Sale Id 1268826',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 11:41:52','',''),(2139581,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 11:41:52','',''),(2139628,'1','139','772',330,'Retail Sale Id 1268849',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 11:45:18','',''),(2139629,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 11:45:18','',''),(2139781,'1','139','772',330,'Retail Sale Id 1268935',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 11:56:41','',''),(2139782,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 11:56:41','',''),(2139837,'1','139','772',330,'Retail Sale Id 1268962',2880.00,0.00,0.00,0.00,216.00,'2021-12-03 12:00:59','',''),(2139838,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-03 12:00:59','',''),(2139857,'1','139','772',330,'Retail Sale Id 1268974',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 12:02:14','',''),(2139858,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 12:02:14','',''),(2139891,'1','139','772',330,'Retail Sale Id 1268989',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 12:03:49','',''),(2139892,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 12:03:49','',''),(2140024,'1','139','772',330,'Retail Sale Id 1269079',7040.00,0.00,0.00,0.00,528.00,'2021-12-03 12:14:32','',''),(2140025,'1','139','772',330,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-03 12:14:32','',''),(2140056,'1','139','772',330,'Retail Sale Id 1269097',6502.40,0.00,0.00,0.00,487.68,'2021-12-03 12:17:22','',''),(2140057,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-03 12:17:22','',''),(2140250,'1','139','772',330,'Retail Sale Id 1269209',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 12:33:50','',''),(2140251,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:33:50','',''),(2140425,'1','139','772',330,'Retail Sale Id 1269292',1920.00,0.00,0.00,0.00,144.00,'2021-12-03 12:47:27','',''),(2140426,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 12:47:27','',''),(2140592,'1','139','772',330,'Retail Sale Id 1269374',2502.40,0.00,0.00,0.00,187.68,'2021-12-03 12:59:00','',''),(2140593,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 12:59:00','',''),(2140604,'1','139','772',330,'Retail Sale Id 1269379',1600.00,0.00,0.00,0.00,120.00,'2021-12-03 13:00:26','',''),(2140605,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-03 13:00:26','',''),(2140727,'1','139','772',330,'Retail Sale Id 1269436',2560.00,0.00,0.00,0.00,192.00,'2021-12-03 13:10:00','',''),(2140728,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 13:10:00','',''),(2140745,'1','139','772',330,'Retail Sale Id 1269445',24400.00,0.00,0.00,0.00,720.00,'2021-12-03 13:12:47','',''),(2140746,'1','139','772',330,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-03 13:12:47','',''),(2140851,'1','139','772',330,'Retail Sale Id 1269483',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 13:20:10','',''),(2140852,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 13:20:10','',''),(2140873,'1','139','772',330,'Retail Sale Id 1269494',2880.00,0.00,0.00,0.00,216.00,'2021-12-03 13:21:46','',''),(2140874,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-03 13:21:46','',''),(2140956,'1','139','772',330,'Retail Sale Id 1269537',8960.00,0.00,0.00,0.00,672.00,'2021-12-03 13:28:25','',''),(2140957,'1','139','772',330,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-03 13:28:25','',''),(2141003,'1','139','772',330,'Retail Sale Id 1269564',2502.40,0.00,0.00,0.00,187.68,'2021-12-03 13:32:09','',''),(2141004,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 13:32:09','',''),(2141029,'1','139','772',330,'Retail Sale Id 1269575',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 13:33:34','',''),(2141030,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 13:33:34','',''),(2141063,'1','139','772',330,'Retail Sale Id 1269592',6400.00,0.00,0.00,0.00,480.00,'2021-12-03 13:35:57','',''),(2141064,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 13:35:57','',''),(2141256,'1','139','772',330,'Retail Sale Id 1269679',4480.00,0.00,0.00,0.00,336.00,'2021-12-03 13:45:53','',''),(2141257,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-03 13:45:53','',''),(2141431,'1','139','772',330,'Retail Sale Id 1269724',1600.00,0.00,0.00,0.00,120.00,'2021-12-03 13:51:25','',''),(2141432,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-03 13:51:26','',''),(2141477,'1','139','772',330,'Retail Sale Id 1269744',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 13:54:01','',''),(2141478,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 13:54:01','',''),(2141495,'1','139','772',330,'Retail Sale Id 1269756',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 13:54:54','',''),(2141496,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 13:54:54','',''),(2141574,'1','139','772',330,'Retail Sale Id 1269795',1600.00,0.00,0.00,0.00,120.00,'2021-12-03 14:01:19','',''),(2141575,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-03 14:01:19','',''),(2141682,'1','139','772',330,'Retail Sale Id 1269831',24400.00,0.00,0.00,0.00,720.00,'2021-12-03 14:07:04','',''),(2141683,'1','139','772',330,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-03 14:07:04','',''),(2141999,'1','139','772',330,'Retail Sale Id 1269959',1280.00,0.00,0.00,0.00,96.00,'2021-12-03 14:25:27','',''),(2142000,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 14:25:27','',''),(2142064,'1','139','772',330,'Retail Sale Id 1269992',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 14:30:20','',''),(2142065,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 14:30:20','',''),(2142162,'1','139','772',330,'Retail Sale Id 1270025',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 14:35:19','',''),(2142163,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 14:35:19','',''),(2142240,'1','139','772',330,'Retail Sale Id 1270049',1280.00,0.00,0.00,0.00,96.00,'2021-12-03 14:39:21','',''),(2142241,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 14:39:21','',''),(2142329,'1','139','772',330,'Retail Sale Id 1270084',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 14:43:02','',''),(2142330,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 14:43:02','',''),(2142363,'1','139','772',330,'Retail Sale Id 1270098',1280.00,0.00,0.00,0.00,96.00,'2021-12-03 14:44:10','',''),(2142364,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 14:44:10','',''),(2142439,'1','139','772',330,'Retail Sale Id 1270136',998.40,0.00,0.00,0.00,74.88,'2021-12-03 14:47:17','',''),(2142440,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 14:47:17','',''),(2142490,'1','139','772',330,'Retail Sale Id 1270161',640.00,0.00,0.00,0.00,48.00,'2021-12-03 14:49:23','',''),(2142491,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 14:49:23','',''),(2142513,'1','139','772',330,'Retail Sale Id 1270173',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 14:50:51','',''),(2142514,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 14:50:51','',''),(2142533,'1','139','772',330,'Retail Sale Id 1270184',1920.00,0.00,0.00,0.00,144.00,'2021-12-03 14:51:47','',''),(2142534,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:51:47','',''),(2142583,'1','139','772',330,'Retail Sale Id 1270209',1280.00,0.00,0.00,0.00,96.00,'2021-12-03 14:54:06','',''),(2142584,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 14:54:06','',''),(2142653,'1','139','772',330,'Retail Sale Id 1270232',1600.00,0.00,0.00,0.00,120.00,'2021-12-03 14:56:40','',''),(2142654,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-03 14:56:40','',''),(2142668,'1','139','772',330,'Retail Sale Id 1270240',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 14:57:31','',''),(2142669,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 14:57:31','',''),(2142675,'1','139','772',330,'Retail Sale Id 1270243',1280.00,0.00,0.00,0.00,96.00,'2021-12-03 14:58:24','',''),(2142676,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 14:58:24','',''),(2142742,'1','139','772',330,'Retail Sale Id 1270278',2880.00,0.00,0.00,0.00,216.00,'2021-12-03 15:02:26','',''),(2142743,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-03 15:02:26','',''),(2143071,'1','139','772',330,'Retail Sale Id 1270462',1401.60,0.00,0.00,0.00,105.12,'2021-12-03 15:20:04','',''),(2143072,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-03 15:20:04','',''),(2143101,'1','139','772',330,'Retail Sale Id 1270474',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 15:21:08','',''),(2143102,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 15:21:08','',''),(2143233,'1','139','772',330,'Retail Sale Id 1270542',3840.00,0.00,0.00,0.00,288.00,'2021-12-03 15:28:46','',''),(2143234,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:28:46','',''),(2143259,'1','139','772',330,'Retail Sale Id 1270554',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 15:29:43','',''),(2143260,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 15:29:43','',''),(2143295,'1','139','772',330,'Retail Sale Id 1270569',1299.20,0.00,0.00,0.00,97.44,'2021-12-03 15:31:20','',''),(2143296,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 15:31:20','',''),(2143329,'1','139','772',330,'Retail Sale Id 1270588',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 15:33:23','',''),(2143330,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 15:33:23','',''),(2143397,'1','139','772',330,'Retail Sale Id 1270615',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 15:35:23','',''),(2143398,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:35:23','',''),(2143427,'1','139','772',330,'Retail Sale Id 1270635',2880.00,0.00,0.00,0.00,216.00,'2021-12-03 15:36:52','',''),(2143428,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-03 15:36:52','',''),(2143514,'1','139','772',330,'Retail Sale Id 1270683',1280.00,0.00,0.00,0.00,96.00,'2021-12-03 15:40:21','',''),(2143515,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 15:40:21','',''),(2143536,'1','139','772',330,'Retail Sale Id 1270693',640.00,0.00,0.00,0.00,48.00,'2021-12-03 15:41:21','',''),(2143537,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 15:41:21','',''),(2143714,'1','139','772',330,'Retail Sale Id 1270775',3840.00,0.00,0.00,0.00,288.00,'2021-12-03 15:47:55','',''),(2143715,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:47:55','',''),(2143752,'1','139','772',330,'Retail Sale Id 1270793',1280.00,0.00,0.00,0.00,96.00,'2021-12-03 15:49:26','',''),(2143753,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 15:49:26','',''),(2143802,'1','139','772',330,'Retail Sale Id 1270823',640.00,0.00,0.00,0.00,48.00,'2021-12-03 15:52:09','',''),(2143803,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 15:52:09','',''),(2143832,'1','139','772',330,'Retail Sale Id 1270837',1280.00,0.00,0.00,0.00,96.00,'2021-12-03 15:53:43','',''),(2143833,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 15:53:43','',''),(2143846,'1','139','772',330,'Retail Sale Id 1270845',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 15:54:33','',''),(2143847,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:54:33','',''),(2143885,'1','139','772',330,'Retail Sale Id 1270863',800.00,0.00,0.00,0.00,60.00,'2021-12-03 15:56:13','',''),(2143886,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-03 15:56:13','',''),(2143895,'1','139','772',330,'Retail Sale Id 1270870',4480.00,0.00,0.00,0.00,336.00,'2021-12-03 15:57:05','',''),(2143896,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-03 15:57:05','',''),(2143952,'1','139','772',330,'Retail Sale Id 1270897',2240.00,0.00,0.00,0.00,168.00,'2021-12-03 15:59:42','',''),(2143953,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-03 15:59:42','',''),(2143977,'1','139','772',330,'Retail Sale Id 1270908',3840.00,0.00,0.00,0.00,288.00,'2021-12-03 16:00:34','',''),(2143978,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 16:00:34','',''),(2144071,'1','139','772',330,'Retail Sale Id 1270956',2502.40,0.00,0.00,0.00,187.68,'2021-12-03 16:04:41','',''),(2144072,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 16:04:41','',''),(2144123,'1','139','772',330,'Retail Sale Id 1270979',2560.00,0.00,0.00,0.00,192.00,'2021-12-03 16:06:28','',''),(2144124,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 16:06:28','',''),(2144153,'1','139','772',330,'Retail Sale Id 1270988',1299.20,0.00,0.00,0.00,97.44,'2021-12-03 16:07:48','',''),(2144154,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 16:07:48','',''),(2144184,'1','139','772',330,'Retail Sale Id 1271001',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 16:09:22','',''),(2144185,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:09:22','',''),(2144234,'1','139','772',330,'Retail Sale Id 1271035',5760.00,0.00,0.00,0.00,432.00,'2021-12-03 16:11:32','',''),(2144236,'1','139','772',330,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-03 16:11:32','',''),(2144274,'1','139','772',330,'Retail Sale Id 1271057',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 16:13:57','',''),(2144275,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:13:57','',''),(2144298,'1','139','772',330,'Retail Sale Id 1271073',7680.00,0.00,0.00,0.00,576.00,'2021-12-03 16:15:37','',''),(2144299,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-03 16:15:37','',''),(2144328,'1','139','772',330,'Retail Sale Id 1271084',1280.00,0.00,0.00,0.00,96.00,'2021-12-03 16:17:47','',''),(2144329,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 16:17:47','',''),(2144372,'1','139','772',330,'Retail Sale Id 1271108',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 16:19:21','',''),(2144373,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:19:21','',''),(2144394,'1','139','772',330,'Retail Sale Id 1271119',710.40,0.00,0.00,0.00,53.28,'2021-12-03 16:20:28','',''),(2144395,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-03 16:20:28','',''),(2144478,'1','139','772',330,'Retail Sale Id 1271160',1280.00,0.00,0.00,0.00,96.00,'2021-12-03 16:24:53','',''),(2144480,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 16:24:53','',''),(2144492,'1','139','772',330,'Retail Sale Id 1271168',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 16:25:50','',''),(2144493,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:25:50','',''),(2144514,'1','139','772',330,'Retail Sale Id 1271178',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 16:26:46','',''),(2144515,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 16:26:46','',''),(2144534,'1','139','772',330,'Retail Sale Id 1271190',1280.00,0.00,0.00,0.00,96.00,'2021-12-03 16:28:04','',''),(2144535,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 16:28:04','',''),(2144576,'1','139','772',330,'Retail Sale Id 1271213',4480.00,0.00,0.00,0.00,336.00,'2021-12-03 16:30:27','',''),(2144577,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-03 16:30:27','',''),(2144620,'1','139','772',330,'Retail Sale Id 1271231',3840.00,0.00,0.00,0.00,288.00,'2021-12-03 16:32:27','',''),(2144621,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 16:32:27','',''),(2144653,'1','139','772',330,'Retail Sale Id 1271248',640.00,0.00,0.00,0.00,48.00,'2021-12-03 16:34:17','',''),(2144654,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 16:34:17','',''),(2144685,'1','139','772',330,'Retail Sale Id 1271264',1280.00,0.00,0.00,0.00,96.00,'2021-12-03 16:35:42','',''),(2144686,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 16:35:42','',''),(2144732,'1','139','772',330,'Retail Sale Id 1271291',1920.00,0.00,0.00,0.00,144.00,'2021-12-03 16:38:14','',''),(2144733,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:38:14','',''),(2144779,'1','139','772',330,'Retail Sale Id 1271316',640.00,0.00,0.00,0.00,48.00,'2021-12-03 16:40:13','',''),(2144780,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 16:40:13','',''),(2144820,'1','139','772',330,'Retail Sale Id 1271332',998.40,0.00,0.00,0.00,74.88,'2021-12-03 16:41:44','',''),(2144821,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 16:41:44','',''),(2144854,'1','139','772',330,'Retail Sale Id 1271348',3520.00,0.00,0.00,0.00,264.00,'2021-12-03 16:43:30','',''),(2144855,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-03 16:43:30','',''),(2144887,'1','139','772',330,'Retail Sale Id 1271365',1280.00,0.00,0.00,0.00,96.00,'2021-12-03 16:45:05','',''),(2144888,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 16:45:05','',''),(2144909,'1','139','772',330,'Retail Sale Id 1271377',2240.00,0.00,0.00,0.00,168.00,'2021-12-03 16:46:48','',''),(2144910,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-03 16:46:48','',''),(2144945,'1','139','772',330,'Retail Sale Id 1271396',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 16:49:05','',''),(2144946,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:49:05','',''),(2144981,'1','139','772',330,'Retail Sale Id 1271412',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 16:50:58','',''),(2144982,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:50:58','',''),(2145029,'1','139','772',330,'Retail Sale Id 1271429',4480.00,0.00,0.00,0.00,336.00,'2021-12-03 16:52:55','',''),(2145030,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-03 16:52:55','',''),(2145070,'1','139','772',330,'Retail Sale Id 1271439',6400.00,0.00,0.00,0.00,480.00,'2021-12-03 16:54:01','',''),(2145071,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 16:54:01','',''),(2145188,'1','139','772',330,'Retail Sale Id 1271484',1280.00,0.00,0.00,0.00,96.00,'2021-12-03 16:58:57','',''),(2145189,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 16:58:57','',''),(2145202,'1','139','772',330,'Retail Sale Id 1271491',2560.00,0.00,0.00,0.00,192.00,'2021-12-03 17:00:04','',''),(2145203,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 17:00:04','',''),(2145292,'1','139','772',330,'Retail Sale Id 1271539',640.00,0.00,0.00,0.00,48.00,'2021-12-03 17:05:52','',''),(2145293,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 17:05:52','',''),(2145310,'1','139','772',330,'Retail Sale Id 1271550',697.60,0.00,0.00,0.00,52.32,'2021-12-03 17:07:35','',''),(2145311,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-03 17:07:35','',''),(2145377,'1','139','772',330,'Retail Sale Id 1271585',3256200.00,0.00,0.00,0.00,59400.00,'2021-12-03 17:13:49','',''),(2145378,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5400.00,0.00,'2021-12-03 17:13:49','',''),(2145397,'1','139','772',330,'Retail Sale Id 1271594',15128.00,0.00,0.00,0.00,446.40,'2021-12-03 17:15:31','',''),(2145398,'1','139','772',330,'Retail sales',0.00,0.00,0.00,24.80,0.00,'2021-12-03 17:15:31','',''),(2146832,'1','139','772',330,'Retail Sale Id 1272063',1920.00,0.00,0.00,0.00,144.00,'2021-12-04 06:23:11','',''),(2146833,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 06:23:11','',''),(2146886,'1','139','772',330,'Retail Sale Id 1272078',998.40,0.00,0.00,0.00,74.88,'2021-12-04 06:25:12','',''),(2146887,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 06:25:12','',''),(2146998,'1','139','772',330,'Retail Sale Id 1272114',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 06:30:04','',''),(2146999,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 06:30:04','',''),(2147054,'1','139','772',330,'Retail Sale Id 1272144',3840.00,0.00,0.00,0.00,288.00,'2021-12-04 06:33:54','',''),(2147057,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 06:33:54','',''),(2147146,'1','139','772',330,'Retail Sale Id 1272184',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 06:39:03','',''),(2147147,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 06:39:03','',''),(2147235,'1','139','772',330,'Retail Sale Id 1272219',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 06:43:02','',''),(2147236,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 06:43:02','',''),(2147283,'1','139','772',330,'Retail Sale Id 1272145',3840.00,0.00,0.00,0.00,288.00,'2021-12-04 06:45:37','',''),(2147284,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 06:45:37','',''),(2147483,'1','139','772',330,'Retail Sale Id 1272327',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 06:56:05','',''),(2147484,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 06:56:05','',''),(2147566,'1','139','772',330,'Retail Sale Id 1272373',6003.20,0.00,0.00,0.00,450.24,'2021-12-04 07:00:23','',''),(2147567,'1','139','772',330,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-04 07:00:23','',''),(2147709,'1','139','772',330,'Retail Sale Id 1272435',4160.00,0.00,0.00,0.00,312.00,'2021-12-04 07:07:58','',''),(2147710,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-04 07:07:58','',''),(2147827,'1','139','772',330,'Retail Sale Id 1272506',82002.30,0.00,0.00,0.00,2419.74,'2021-12-04 07:15:01','',''),(2147828,'1','139','772',330,'Retail sales',0.00,0.00,0.00,134.43,0.00,'2021-12-04 07:15:01','',''),(2147932,'1','139','772',330,'Retail Sale Id 1272556',1600.00,0.00,0.00,0.00,120.00,'2021-12-04 07:20:12','',''),(2147933,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-04 07:20:12','',''),(2148212,'1','139','772',330,'Retail Sale Id 1272713',1280.00,0.00,0.00,0.00,96.00,'2021-12-04 07:34:02','',''),(2148213,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 07:34:02','',''),(2148353,'1','139','772',330,'Retail Sale Id 1272794',2880.00,0.00,0.00,0.00,216.00,'2021-12-04 07:40:16','',''),(2148354,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-04 07:40:16','',''),(2148484,'1','139','772',330,'Retail Sale Id 1272911',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 07:48:24','',''),(2148485,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:48:24','',''),(2148535,'1','139','772',330,'Retail Sale Id 1272942',640.00,0.00,0.00,0.00,48.00,'2021-12-04 07:51:05','',''),(2148536,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-04 07:51:05','',''),(2148552,'1','139','772',330,'Retail Sale Id 1272955',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 07:52:12','',''),(2148553,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 07:52:12','',''),(2148725,'1','139','772',330,'Retail Sale Id 1273054',5760.00,0.00,0.00,0.00,432.00,'2021-12-04 08:01:19','',''),(2148726,'1','139','772',330,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-04 08:01:19','',''),(2148797,'1','139','772',330,'Retail Sale Id 1273089',1600.00,0.00,0.00,0.00,120.00,'2021-12-04 08:04:31','',''),(2148798,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-04 08:04:31','',''),(2148829,'1','139','772',330,'Retail Sale Id 1273110',640.00,0.00,0.00,0.00,48.00,'2021-12-04 08:05:51','',''),(2148830,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-04 08:05:51','',''),(2148872,'1','139','772',330,'Retail Sale Id 1273130',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 08:07:14','',''),(2148873,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:07:14','',''),(2148888,'1','139','772',330,'Retail Sale Id 1273143',1280.00,0.00,0.00,0.00,96.00,'2021-12-04 08:08:17','',''),(2148889,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 08:08:17','',''),(2149067,'1','139','772',330,'Retail Sale Id 1273236',2560.00,0.00,0.00,0.00,192.00,'2021-12-04 08:15:31','',''),(2149068,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 08:15:31','',''),(2149162,'1','139','772',330,'Retail Sale Id 1273285',6100.00,0.00,0.00,0.00,180.00,'2021-12-04 08:19:54','',''),(2149163,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 08:19:54','',''),(2149233,'1','139','772',330,'Retail Sale Id 1273364',800.00,0.00,0.00,0.00,60.00,'2021-12-04 08:23:04','',''),(2149234,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-04 08:23:04','',''),(2149302,'1','139','772',330,'Retail Sale Id 1273412',640.00,0.00,0.00,0.00,48.00,'2021-12-04 08:25:49','',''),(2149303,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-04 08:25:49','',''),(2149446,'1','139','772',330,'Retail Sale Id 1273515',748.80,0.00,0.00,0.00,56.16,'2021-12-04 08:31:37','',''),(2149447,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.17,0.00,'2021-12-04 08:31:37','',''),(2149590,'1','139','772',330,'Retail Sale Id 1273576',2560.00,0.00,0.00,0.00,192.00,'2021-12-04 08:36:44','',''),(2149591,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 08:36:44','',''),(2149654,'1','139','772',330,'Retail Sale Id 1273596',697.60,0.00,0.00,0.00,52.32,'2021-12-04 08:38:10','',''),(2149655,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-04 08:38:10','',''),(2149666,'1','139','772',330,'Retail Sale Id 1273607',2880.00,0.00,0.00,0.00,216.00,'2021-12-04 08:39:23','',''),(2149667,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-04 08:39:23','',''),(2149739,'1','139','772',330,'Retail Sale Id 1273642',2502.40,0.00,0.00,0.00,187.68,'2021-12-04 08:42:58','',''),(2149740,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 08:42:58','',''),(2149796,'1','139','772',330,'Retail Sale Id 1273673',640.00,0.00,0.00,0.00,48.00,'2021-12-04 08:44:51','',''),(2149797,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-04 08:44:51','',''),(2149822,'1','139','772',330,'Retail Sale Id 1273691',4160.00,0.00,0.00,0.00,312.00,'2021-12-04 08:45:50','',''),(2149823,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-04 08:45:50','',''),(2149926,'1','139','772',330,'Retail Sale Id 1273743',1280.00,0.00,0.00,0.00,96.00,'2021-12-04 08:50:31','',''),(2149927,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 08:50:31','',''),(2149980,'1','139','772',330,'Retail Sale Id 1273776',998.40,0.00,0.00,0.00,74.88,'2021-12-04 08:53:04','',''),(2149981,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 08:53:04','',''),(2150239,'1','139','772',330,'Retail Sale Id 1273916',1600.00,0.00,0.00,0.00,120.00,'2021-12-04 09:04:58','',''),(2150240,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-04 09:04:58','',''),(2150351,'1','139','772',330,'Retail Sale Id 1273975',1280.00,0.00,0.00,0.00,96.00,'2021-12-04 09:11:19','',''),(2150352,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 09:11:19','',''),(2150453,'1','139','772',330,'Retail Sale Id 1274024',1280.00,0.00,0.00,0.00,96.00,'2021-12-04 09:16:27','',''),(2150454,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 09:16:27','',''),(2150587,'1','139','772',330,'Retail Sale Id 1274096',640.00,0.00,0.00,0.00,48.00,'2021-12-04 09:22:08','',''),(2150588,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-04 09:22:08','',''),(2150605,'1','139','772',330,'Retail Sale Id 1274105',1280.00,0.00,0.00,0.00,96.00,'2021-12-04 09:23:01','',''),(2150606,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 09:23:01','',''),(2150690,'1','139','772',330,'Retail Sale Id 1274147',1401.60,0.00,0.00,0.00,105.12,'2021-12-04 09:27:32','',''),(2150691,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-04 09:27:32','',''),(2152413,'1','139','772',330,'Retail Sale Id 1274331',1920.00,0.00,0.00,0.00,144.00,'2021-12-04 10:29:59','',''),(2152414,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 10:29:59','',''),(2152531,'1','139','772',330,'Retail Sale Id 1274422',165120.00,0.00,0.00,0.00,12384.00,'2021-12-04 10:39:56','',''),(2152532,'1','139','772',330,'Retail sales',0.00,0.00,0.00,258.00,0.00,'2021-12-04 10:39:56','',''),(2153243,'1','139','772',330,'Retail Sale Id 1274740',22592.00,0.00,0.00,0.00,1694.40,'2021-12-04 11:17:32','',''),(2153244,'1','139','772',330,'Retail sales',0.00,0.00,0.00,35.30,0.00,'2021-12-04 11:17:32','',''),(2153295,'1','139','772',330,'Retail Sale Id 1274762',453000.00,0.00,0.00,0.00,9000.00,'2021-12-04 11:20:25','',''),(2153296,'1','139','772',330,'Retail sales',0.00,0.00,0.00,750.00,0.00,'2021-12-04 11:20:25','',''),(2153428,'1','139','772',330,'Return of Retail Sale Id 1274422',0.00,165120.00,258.00,0.00,-12384.00,'2021-12-04 11:28:26','',''),(2153519,'1','139','772',330,'Retail Sale Id 1274884',146400.00,0.00,0.00,0.00,4320.00,'2021-12-04 11:32:46','',''),(2153520,'1','139','772',330,'Retail sales',0.00,0.00,0.00,240.00,0.00,'2021-12-04 11:32:46','',''),(2153590,'1','139','772',330,'Retail Sale Id 1274916',33550.00,0.00,0.00,0.00,990.00,'2021-12-04 11:36:33','',''),(2153591,'1','139','772',330,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-04 11:36:33','',''),(2153659,'1','139','772',330,'Retail Sale Id 1274257',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 11:38:55','',''),(2153660,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 11:38:55','',''),(2153669,'1','139','772',330,'Return of Retail Sale Id 1274257',0.00,3001.60,4.69,0.00,-225.12,'2021-12-04 11:39:16','',''),(2153682,'1','139','772',330,'Return of Retail Sale Id 1274331',0.00,1920.00,3.00,0.00,-144.00,'2021-12-04 11:40:29','',''),(2153923,'1','139','772',330,'Distributed to OPERATIONAL LOSS for sales id:337160',194324.00,0.00,0.00,328.25,0.00,'2021-12-04 11:54:16','',''),(2178189,'1','139',NULL,330,'Purchased from AA RANO NIGERIA LIMITED',0.00,14776320.00,24960.00,0.00,0.00,'2021-12-06 09:55:03','',''),(2178204,'1','139',NULL,330,'Reception corrector for bridging 126361',0.00,0.00,0.00,24960.00,0.00,'2021-12-06 09:56:32','',''),(2178205,'1','139','772',330,'Received from bridging 126361',0.00,0.00,24960.00,0.00,0.00,'2021-12-06 09:56:32','',''),(2178723,'1','139','772',330,'Retail Sale Id 1286754',7001.60,0.00,0.00,0.00,525.12,'2021-12-06 10:29:45','',''),(2178724,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-06 10:29:45','',''),(2178747,'1','139','772',330,'Retail Sale Id 1286766',1920.00,0.00,0.00,0.00,144.00,'2021-12-06 10:31:10','',''),(2178748,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 10:31:10','',''),(2178796,'1','139','772',330,'Retail Sale Id 1286787',1280.00,0.00,0.00,0.00,96.00,'2021-12-06 10:34:30','',''),(2178797,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 10:34:30','',''),(2178814,'1','139','772',330,'Retail Sale Id 1286802',640.00,0.00,0.00,0.00,48.00,'2021-12-06 10:36:29','',''),(2178815,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-06 10:36:29','',''),(2178856,'1','139','772',330,'Retail Sale Id 1286829',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 10:38:55','',''),(2178857,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 10:38:55','',''),(2178872,'1','139','772',330,'Retail Sale Id 1286835',3840.00,0.00,0.00,0.00,288.00,'2021-12-06 10:40:18','',''),(2178873,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 10:40:18','',''),(2178912,'1','139','772',330,'Retail Sale Id 1286858',36600.00,0.00,0.00,0.00,1080.00,'2021-12-06 10:43:03','',''),(2178913,'1','139','772',330,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-06 10:43:03','',''),(2178934,'1','139','772',330,'Retail Sale Id 1286871',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 10:44:03','',''),(2178935,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:44:03','',''),(2178956,'1','139','772',330,'Retail Sale Id 1286878',2240.00,0.00,0.00,0.00,168.00,'2021-12-06 10:45:22','',''),(2178957,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-06 10:45:22','',''),(2178978,'1','139','772',330,'Retail Sale Id 1286891',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 10:46:19','',''),(2178979,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 10:46:19','',''),(2179052,'1','139','772',330,'Retail Sale Id 1286940',998.40,0.00,0.00,0.00,74.88,'2021-12-06 10:50:34','',''),(2179053,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 10:50:34','',''),(2179114,'1','139','772',330,'Retail Sale Id 1286975',176900.00,0.00,0.00,0.00,5220.00,'2021-12-06 10:54:46','',''),(2179115,'1','139','772',330,'Retail sales',0.00,0.00,0.00,290.00,0.00,'2021-12-06 10:54:46','',''),(2179147,'1','139','772',330,'Retail Sale Id 1286993',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 10:56:38','',''),(2179148,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 10:56:38','',''),(2179175,'1','139','772',330,'Retail Sale Id 1287013',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 10:58:14','',''),(2179176,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 10:58:14','',''),(2179201,'1','139','772',330,'Retail Sale Id 1287029',2560.00,0.00,0.00,0.00,192.00,'2021-12-06 10:59:33','',''),(2179202,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 10:59:33','',''),(2179215,'1','139','772',330,'Retail Sale Id 1287036',1100.80,0.00,0.00,0.00,82.56,'2021-12-06 11:00:43','',''),(2179216,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.72,0.00,'2021-12-06 11:00:43','',''),(2179263,'1','139','772',330,'Retail Sale Id 1287065',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 11:04:08','',''),(2179264,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 11:04:08','',''),(2179355,'1','139','772',330,'Retail Sale Id 1287115',4160.00,0.00,0.00,0.00,312.00,'2021-12-06 11:09:04','',''),(2179356,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-06 11:09:04','',''),(2179369,'1','139','772',330,'Retail Sale Id 1287121',697.60,0.00,0.00,0.00,52.32,'2021-12-06 11:10:18','',''),(2179370,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-06 11:10:18','',''),(2179403,'1','139','772',330,'Retail Sale Id 1287140',7680.00,0.00,0.00,0.00,576.00,'2021-12-06 11:12:35','',''),(2179404,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-06 11:12:35','',''),(2179427,'1','139','772',330,'Retail Sale Id 1287145',6400.00,0.00,0.00,0.00,480.00,'2021-12-06 11:13:32','',''),(2179428,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 11:13:32','',''),(2179459,'1','139','772',330,'Retail Sale Id 1287160',3520.00,0.00,0.00,0.00,264.00,'2021-12-06 11:15:21','',''),(2179460,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-06 11:15:21','',''),(2179485,'1','139','772',330,'Retail Sale Id 1287178',2240.00,0.00,0.00,0.00,168.00,'2021-12-06 11:17:04','',''),(2179486,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-06 11:17:04','',''),(2179571,'1','139','772',330,'Retail Sale Id 1287228',27450.00,0.00,0.00,0.00,810.00,'2021-12-06 11:22:04','',''),(2179572,'1','139','772',330,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-06 11:22:04','',''),(2179603,'1','139','772',330,'Retail Sale Id 1287251',1203.20,0.00,0.00,0.00,90.24,'2021-12-06 11:24:35','',''),(2179604,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-06 11:24:35','',''),(2179623,'1','139','772',330,'Retail Sale Id 1287262',800.00,0.00,0.00,0.00,60.00,'2021-12-06 11:26:08','',''),(2179624,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-06 11:26:08','',''),(2179639,'1','139','772',330,'Retail Sale Id 1287271',2899.20,0.00,0.00,0.00,217.44,'2021-12-06 11:27:33','',''),(2179640,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.53,0.00,'2021-12-06 11:27:33','',''),(2179689,'1','139','772',330,'Retail Sale Id 1287297',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 11:30:45','',''),(2179690,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 11:30:45','',''),(2179703,'1','139','772',330,'Retail Sale Id 1287305',1920.00,0.00,0.00,0.00,144.00,'2021-12-06 11:31:47','',''),(2179704,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 11:31:47','',''),(2179724,'1','139','772',330,'Retail Sale Id 1287317',1600.00,0.00,0.00,0.00,120.00,'2021-12-06 11:33:14','',''),(2179725,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 11:33:14','',''),(2179732,'1','139','772',330,'Retail Sale Id 1287320',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 11:34:09','',''),(2179733,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 11:34:09','',''),(2179808,'1','139','772',330,'Retail Sale Id 1287358',4499.20,0.00,0.00,0.00,337.44,'2021-12-06 11:41:08','',''),(2179809,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-06 11:41:08','',''),(2179819,'1','139','772',330,'Retail Sale Id 1287365',4499.20,0.00,0.00,0.00,337.44,'2021-12-06 11:41:53','',''),(2179820,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-06 11:41:53','',''),(2180022,'1','139','772',330,'Retail Sale Id 1287525',2880.00,0.00,0.00,0.00,216.00,'2021-12-06 11:55:46','',''),(2180023,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-06 11:55:46','',''),(2180056,'1','139','772',330,'Retail Sale Id 1287546',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 11:58:15','',''),(2180057,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 11:58:15','',''),(2180104,'1','139','772',330,'Retail Sale Id 1287567',54900.00,0.00,0.00,0.00,1620.00,'2021-12-06 12:01:17','',''),(2180105,'1','139','772',330,'Retail sales',0.00,0.00,0.00,90.00,0.00,'2021-12-06 12:01:17','',''),(2180118,'1','139','772',330,'Retail Sale Id 1287576',27450.00,0.00,0.00,0.00,810.00,'2021-12-06 12:02:20','',''),(2180119,'1','139','772',330,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-06 12:02:20','',''),(2180206,'1','139','772',330,'Retail Sale Id 1287620',73200.00,0.00,0.00,0.00,2160.00,'2021-12-06 12:07:29','',''),(2180207,'1','139','772',330,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-06 12:07:29','',''),(2180238,'1','139','772',330,'Retail Sale Id 1287636',1280.00,0.00,0.00,0.00,96.00,'2021-12-06 12:09:25','',''),(2180239,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 12:09:25','',''),(2180320,'1','139','772',330,'Retail Sale Id 1287692',4998.40,0.00,0.00,0.00,374.88,'2021-12-06 12:14:14','',''),(2180321,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 12:14:14','',''),(2180412,'1','139','772',330,'Retail Sale Id 1287743',697.60,0.00,0.00,0.00,52.32,'2021-12-06 12:19:05','',''),(2180413,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-06 12:19:05','',''),(2180520,'1','139','772',330,'Retail Sale Id 1287800',1203.20,0.00,0.00,0.00,90.24,'2021-12-06 12:27:01','',''),(2180521,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-06 12:27:01','',''),(2180532,'1','139','772',330,'Retail Sale Id 1287809',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 12:27:55','',''),(2180533,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 12:27:55','',''),(2180566,'1','139','772',330,'Retail Sale Id 1287828',998.40,0.00,0.00,0.00,74.88,'2021-12-06 12:29:49','',''),(2180567,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 12:29:49','',''),(2180596,'1','139','772',330,'Retail Sale Id 1287841',4160.00,0.00,0.00,0.00,312.00,'2021-12-06 12:31:55','',''),(2180597,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-06 12:31:55','',''),(2180623,'1','139','772',330,'Retail Sale Id 1287853',3520.00,0.00,0.00,0.00,264.00,'2021-12-06 12:33:16','',''),(2180624,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-06 12:33:16','',''),(2180734,'1','139','772',330,'Retail Sale Id 1287911',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 12:39:14','',''),(2180735,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 12:39:14','',''),(2180750,'1','139','772',330,'Retail Sale Id 1287917',697.60,0.00,0.00,0.00,52.32,'2021-12-06 12:40:32','',''),(2180751,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-06 12:40:32','',''),(2180758,'1','139','772',330,'Retail Sale Id 1287921',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 12:41:18','',''),(2180759,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 12:41:18','',''),(2180772,'1','139','772',330,'Retail Sale Id 1287928',8960.00,0.00,0.00,0.00,672.00,'2021-12-06 12:42:11','',''),(2180773,'1','139','772',330,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-06 12:42:11','',''),(2180882,'1','139','772',330,'Retail Sale Id 1287986',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 12:48:50','',''),(2180883,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 12:48:50','',''),(2180955,'1','139','772',330,'Retail Sale Id 1288027',3840.00,0.00,0.00,0.00,288.00,'2021-12-06 12:53:46','',''),(2180956,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 12:53:46','',''),(2181016,'1','139','772',330,'Retail Sale Id 1288056',8320.00,0.00,0.00,0.00,624.00,'2021-12-06 12:57:20','',''),(2181017,'1','139','772',330,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-06 12:57:20','',''),(2181047,'1','139','772',330,'Retail Sale Id 1288074',5120.00,0.00,0.00,0.00,384.00,'2021-12-06 12:58:31','',''),(2181048,'1','139','772',330,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-06 12:58:31','',''),(2181094,'1','139','772',330,'Retail Sale Id 1288096',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 13:00:52','',''),(2181095,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 13:00:52','',''),(2181124,'1','139','772',330,'Retail Sale Id 1288106',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 13:02:17','',''),(2181125,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 13:02:17','',''),(2181150,'1','139','772',330,'Retail Sale Id 1288122',7040.00,0.00,0.00,0.00,528.00,'2021-12-06 13:04:26','',''),(2181151,'1','139','772',330,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-06 13:04:26','',''),(2181182,'1','139','772',330,'Retail Sale Id 1288128',36600.00,0.00,0.00,0.00,1080.00,'2021-12-06 13:06:28','',''),(2181183,'1','139','772',330,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-06 13:06:28','',''),(2181200,'1','139','772',330,'Retail Sale Id 1288145',1920.00,0.00,0.00,0.00,144.00,'2021-12-06 13:07:18','',''),(2181201,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 13:07:18','',''),(2181220,'1','139','772',330,'Retail Sale Id 1288157',12200.00,0.00,0.00,0.00,360.00,'2021-12-06 13:08:31','',''),(2181221,'1','139','772',330,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-06 13:08:31','',''),(2181234,'1','139','772',330,'Retail Sale Id 1288164',1920.00,0.00,0.00,0.00,144.00,'2021-12-06 13:09:22','',''),(2181235,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 13:09:22','',''),(2181274,'1','139','772',330,'Retail Sale Id 1288189',1920.00,0.00,0.00,0.00,144.00,'2021-12-06 13:11:19','',''),(2181275,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 13:11:19','',''),(2181462,'1','139','772',330,'Retail Sale Id 1288263',800.00,0.00,0.00,0.00,60.00,'2021-12-06 13:19:51','',''),(2181463,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-06 13:19:51','',''),(2181506,'1','139','772',330,'Retail Sale Id 1288283',2560.00,0.00,0.00,0.00,192.00,'2021-12-06 13:22:49','',''),(2181507,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 13:22:49','',''),(2181670,'1','139','772',330,'Retail Sale Id 1288356',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 13:34:30','',''),(2181671,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 13:34:30','',''),(2181704,'1','139','772',330,'Retail Sale Id 1288363',3500.80,0.00,0.00,0.00,262.56,'2021-12-06 13:35:39','',''),(2181705,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-06 13:35:39','',''),(2181858,'1','139','772',330,'Retail Sale Id 1288437',2880.00,0.00,0.00,0.00,216.00,'2021-12-06 13:43:04','',''),(2181859,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-06 13:43:04','',''),(2182091,'1','139','772',330,'Retail Sale Id 1288543',4480.00,0.00,0.00,0.00,336.00,'2021-12-06 13:54:53','',''),(2182092,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-06 13:54:53','',''),(2182117,'1','139','772',330,'Retail Sale Id 1288562',1280.00,0.00,0.00,0.00,96.00,'2021-12-06 13:55:57','',''),(2182118,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 13:55:57','',''),(2182127,'1','139','772',330,'Retail Sale Id 1288569',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 13:56:57','',''),(2182128,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 13:56:57','',''),(2182161,'1','139','772',330,'Retail Sale Id 1288581',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 13:58:32','',''),(2182162,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 13:58:32','',''),(2182247,'1','139','772',330,'Retail Sale Id 1288616',4998.40,0.00,0.00,0.00,374.88,'2021-12-06 14:01:43','',''),(2182248,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 14:01:43','',''),(2182285,'1','139','772',330,'Retail Sale Id 1288638',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 14:03:42','',''),(2182286,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 14:03:42','',''),(2182333,'1','139','772',330,'Retail Sale Id 1288656',7680.00,0.00,0.00,0.00,576.00,'2021-12-06 14:06:03','',''),(2182334,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-06 14:06:03','',''),(2182416,'1','139','772',330,'Retail Sale Id 1288694',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 14:09:51','',''),(2182417,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 14:09:51','',''),(2182499,'1','139','772',330,'Retail Sale Id 1288722',1280.00,0.00,0.00,0.00,96.00,'2021-12-06 14:12:40','',''),(2182500,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 14:12:40','',''),(2182533,'1','139','772',330,'Retail Sale Id 1288739',3520.00,0.00,0.00,0.00,264.00,'2021-12-06 14:14:42','',''),(2182534,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-06 14:14:42','',''),(2182642,'1','139','772',330,'Retail Sale Id 1288793',1280.00,0.00,0.00,0.00,96.00,'2021-12-06 14:19:36','',''),(2182643,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 14:19:36','',''),(2182696,'1','139','772',330,'Retail Sale Id 1288818',697.60,0.00,0.00,0.00,52.32,'2021-12-06 14:22:27','',''),(2182697,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-06 14:22:27','',''),(2182736,'1','139','772',330,'Retail Sale Id 1288838',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 14:24:42','',''),(2182737,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 14:24:42','',''),(2182774,'1','139','772',330,'Retail Sale Id 1288858',152500.00,0.00,0.00,0.00,4500.00,'2021-12-06 14:26:43','',''),(2182775,'1','139','772',330,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-06 14:26:43','',''),(2182800,'1','139','772',330,'Retail Sale Id 1288873',131150.00,0.00,0.00,0.00,3870.00,'2021-12-06 14:28:22','',''),(2182801,'1','139','772',330,'Retail sales',0.00,0.00,0.00,215.00,0.00,'2021-12-06 14:28:22','',''),(2182824,'1','139','772',330,'Retail Sale Id 1288884',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 14:30:05','',''),(2182825,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 14:30:05','',''),(2182852,'1','139','772',330,'Retail Sale Id 1288899',1280.00,0.00,0.00,0.00,96.00,'2021-12-06 14:31:37','',''),(2182853,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 14:31:37','',''),(2182885,'1','139','772',330,'Retail Sale Id 1288912',1280.00,0.00,0.00,0.00,96.00,'2021-12-06 14:33:11','',''),(2182886,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 14:33:11','',''),(2182919,'1','139','772',330,'Retail Sale Id 1288932',1920.00,0.00,0.00,0.00,144.00,'2021-12-06 14:34:55','',''),(2182920,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:34:55','',''),(2182940,'1','139','772',330,'Retail Sale Id 1288940',6003.20,0.00,0.00,0.00,450.24,'2021-12-06 14:35:58','',''),(2182941,'1','139','772',330,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-06 14:35:58','',''),(2182952,'1','139','772',330,'Retail Sale Id 1288946',1600.00,0.00,0.00,0.00,120.00,'2021-12-06 14:36:54','',''),(2182953,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 14:36:54','',''),(2183002,'1','139','772',330,'Retail Sale Id 1288970',1920.00,0.00,0.00,0.00,144.00,'2021-12-06 14:40:04','',''),(2183003,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:40:04','',''),(2183047,'1','139','772',330,'Retail Sale Id 1288982',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 14:41:34','',''),(2183048,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 14:41:34','',''),(2183083,'1','139','772',330,'Retail Sale Id 1288995',1600.00,0.00,0.00,0.00,120.00,'2021-12-06 14:42:49','',''),(2183084,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 14:42:49','',''),(2183170,'1','139','772',330,'Retail Sale Id 1289032',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 14:47:42','',''),(2183171,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 14:47:42','',''),(2183210,'1','139','772',330,'Retail Sale Id 1289047',1920.00,0.00,0.00,0.00,144.00,'2021-12-06 14:49:17','',''),(2183211,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:49:17','',''),(2183256,'1','139','772',330,'Retail Sale Id 1289071',2240.00,0.00,0.00,0.00,168.00,'2021-12-06 14:51:38','',''),(2183257,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-06 14:51:38','',''),(2183297,'1','139','772',330,'Retail Sale Id 1289089',998.40,0.00,0.00,0.00,74.88,'2021-12-06 14:53:22','',''),(2183298,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 14:53:22','',''),(2183325,'1','139','772',330,'Retail Sale Id 1289103',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 14:54:54','',''),(2183326,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 14:54:54','',''),(2183345,'1','139','772',330,'Retail Sale Id 1289112',998.40,0.00,0.00,0.00,74.88,'2021-12-06 14:55:42','',''),(2183346,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 14:55:42','',''),(2183363,'1','139','772',330,'Retail Sale Id 1289119',1920.00,0.00,0.00,0.00,144.00,'2021-12-06 14:56:29','',''),(2183364,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:56:29','',''),(2183389,'1','139','772',330,'Retail Sale Id 1289134',1280.00,0.00,0.00,0.00,96.00,'2021-12-06 14:58:26','',''),(2183390,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 14:58:26','',''),(2183413,'1','139','772',330,'Retail Sale Id 1289145',2880.00,0.00,0.00,0.00,216.00,'2021-12-06 14:59:28','',''),(2183414,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-06 14:59:28','',''),(2183463,'1','139','772',330,'Retail Sale Id 1289172',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 15:02:21','',''),(2183464,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 15:02:21','',''),(2183497,'1','139','772',330,'Retail Sale Id 1289191',998.40,0.00,0.00,0.00,74.88,'2021-12-06 15:04:01','',''),(2183498,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 15:04:01','',''),(2183525,'1','139','772',330,'Retail Sale Id 1289200',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 15:05:16','',''),(2183526,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 15:05:16','',''),(2183549,'1','139','772',330,'Retail Sale Id 1289218',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 15:07:00','',''),(2183550,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 15:07:00','',''),(2183576,'1','139','772',330,'Retail Sale Id 1289230',998.40,0.00,0.00,0.00,74.88,'2021-12-06 15:08:37','',''),(2183577,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 15:08:37','',''),(2183588,'1','139','772',330,'Retail Sale Id 1289235',1280.00,0.00,0.00,0.00,96.00,'2021-12-06 15:09:26','',''),(2183589,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 15:09:26','',''),(2183623,'1','139','772',330,'Retail Sale Id 1289246',1600.00,0.00,0.00,0.00,120.00,'2021-12-06 15:11:30','',''),(2183624,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 15:11:30','',''),(2183669,'1','139','772',330,'Retail Sale Id 1289267',2598.40,0.00,0.00,0.00,194.88,'2021-12-06 15:14:03','',''),(2183670,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-06 15:14:03','',''),(2183699,'1','139','772',330,'Retail Sale Id 1289276',2240.00,0.00,0.00,0.00,168.00,'2021-12-06 15:15:14','',''),(2183700,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-06 15:15:14','',''),(2183710,'1','139','772',330,'Retail Sale Id 1289283',998.40,0.00,0.00,0.00,74.88,'2021-12-06 15:16:10','',''),(2183711,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 15:16:10','',''),(2183730,'1','139','772',330,'Retail Sale Id 1289295',1280.00,0.00,0.00,0.00,96.00,'2021-12-06 15:17:05','',''),(2183731,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 15:17:05','',''),(2183748,'1','139','772',330,'Retail Sale Id 1289304',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 15:18:04','',''),(2183749,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 15:18:04','',''),(2183796,'1','139','772',330,'Retail Sale Id 1289322',3520.00,0.00,0.00,0.00,264.00,'2021-12-06 15:19:45','',''),(2183797,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-06 15:19:45','',''),(2183814,'1','139','772',330,'Retail Sale Id 1289330',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 15:20:37','',''),(2183815,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 15:20:37','',''),(2183837,'1','139','772',330,'Retail Sale Id 1289341',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 15:21:56','',''),(2183838,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 15:21:56','',''),(2183899,'1','139','772',330,'Retail Sale Id 1289361',1280.00,0.00,0.00,0.00,96.00,'2021-12-06 15:24:07','',''),(2183900,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 15:24:07','',''),(2183933,'1','139','772',330,'Retail Sale Id 1289385',998.40,0.00,0.00,0.00,74.88,'2021-12-06 15:25:29','',''),(2183934,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 15:25:29','',''),(2183976,'1','139','772',330,'Retail Sale Id 1289406',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 15:27:36','',''),(2183977,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:27:36','',''),(2184003,'1','139','772',330,'Retail Sale Id 1289416',2560.00,0.00,0.00,0.00,192.00,'2021-12-06 15:29:08','',''),(2184004,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 15:29:08','',''),(2184039,'1','139','772',330,'Retail Sale Id 1289439',1280.00,0.00,0.00,0.00,96.00,'2021-12-06 15:31:18','',''),(2184040,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 15:31:18','',''),(2184099,'1','139','772',330,'Retail Sale Id 1289469',7680.00,0.00,0.00,0.00,576.00,'2021-12-06 15:34:47','',''),(2184100,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-06 15:34:47','',''),(2184124,'1','139','772',330,'Retail Sale Id 1289481',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 15:36:15','',''),(2184125,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 15:36:15','',''),(2184146,'1','139','772',330,'Retail Sale Id 1289493',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 15:37:11','',''),(2184147,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 15:37:11','',''),(2184181,'1','139','772',330,'Retail Sale Id 1289505',2880.00,0.00,0.00,0.00,216.00,'2021-12-06 15:38:27','',''),(2184182,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-06 15:38:27','',''),(2184215,'1','139','772',330,'Retail Sale Id 1289517',1600.00,0.00,0.00,0.00,120.00,'2021-12-06 15:39:40','',''),(2184216,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 15:39:40','',''),(2184278,'1','139','772',330,'Retail Sale Id 1289526',2240.00,0.00,0.00,0.00,168.00,'2021-12-06 15:41:27','',''),(2184279,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-06 15:41:27','',''),(2184311,'1','139','772',330,'Retail Sale Id 1289542',1280.00,0.00,0.00,0.00,96.00,'2021-12-06 15:42:38','',''),(2184312,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 15:42:38','',''),(2184357,'1','139','772',330,'Retail Sale Id 1289552',1280.00,0.00,0.00,0.00,96.00,'2021-12-06 15:43:51','',''),(2184358,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 15:43:51','',''),(2184391,'1','139','772',330,'Retail Sale Id 1289568',1600.00,0.00,0.00,0.00,120.00,'2021-12-06 15:45:01','',''),(2184392,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 15:45:01','',''),(2184418,'1','139','772',330,'Retail Sale Id 1289580',1920.00,0.00,0.00,0.00,144.00,'2021-12-06 15:46:05','',''),(2184419,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:46:05','',''),(2184460,'1','139','772',330,'Retail Sale Id 1289593',1920.00,0.00,0.00,0.00,144.00,'2021-12-06 15:47:45','',''),(2184461,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:47:45','',''),(2184500,'1','139','772',330,'Retail Sale Id 1289614',6400.00,0.00,0.00,0.00,480.00,'2021-12-06 15:49:49','',''),(2184501,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 15:49:49','',''),(2184524,'1','139','772',330,'Retail Sale Id 1289621',1280.00,0.00,0.00,0.00,96.00,'2021-12-06 15:51:11','',''),(2184525,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 15:51:11','',''),(2184559,'1','139','772',330,'Retail Sale Id 1289642',1920.00,0.00,0.00,0.00,144.00,'2021-12-06 15:53:16','',''),(2184560,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:53:16','',''),(2184580,'1','139','772',330,'Retail Sale Id 1289651',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 15:54:03','',''),(2184581,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 15:54:03','',''),(2184598,'1','139','772',330,'Retail Sale Id 1289658',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 15:54:58','',''),(2184599,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 15:54:58','',''),(2184642,'1','139','772',330,'Retail Sale Id 1289680',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 15:57:32','',''),(2184643,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 15:57:32','',''),(2184668,'1','139','772',330,'Retail Sale Id 1289691',1280.00,0.00,0.00,0.00,96.00,'2021-12-06 15:58:33','',''),(2184669,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 15:58:33','',''),(2184683,'1','139','772',330,'Retail Sale Id 1289702',1920.00,0.00,0.00,0.00,144.00,'2021-12-06 15:59:54','',''),(2184684,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:59:54','',''),(2184712,'1','139','772',330,'Retail Sale Id 1289717',4998.40,0.00,0.00,0.00,374.88,'2021-12-06 16:01:23','',''),(2184713,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 16:01:23','',''),(2184729,'1','139','772',330,'Retail Sale Id 1289723',1920.00,0.00,0.00,0.00,144.00,'2021-12-06 16:02:22','',''),(2184730,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:02:22','',''),(2184748,'1','139','772',330,'Retail Sale Id 1289729',1600.00,0.00,0.00,0.00,120.00,'2021-12-06 16:03:33','',''),(2184749,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 16:03:33','',''),(2185760,'1','139','772',330,'Retail Sale Id 1290224',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 16:59:46','',''),(2185761,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:59:46','',''),(2185778,'1','139','772',330,'Retail Sale Id 1290235',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 17:01:06','',''),(2185779,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 17:01:06','',''),(2185798,'1','139','772',330,'Retail Sale Id 1290246',30500.00,0.00,0.00,0.00,900.00,'2021-12-06 17:02:40','',''),(2185799,'1','139','772',330,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 17:02:40','',''),(2185818,'1','139','772',330,'Retail Sale Id 1290257',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 17:03:54','',''),(2185819,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 17:03:54','',''),(2185834,'1','139','772',330,'Retail Sale Id 1290265',4499.20,0.00,0.00,0.00,337.44,'2021-12-06 17:05:04','',''),(2185835,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-06 17:05:04','',''),(2185850,'1','139','772',330,'Retail Sale Id 1290272',1920.00,0.00,0.00,0.00,144.00,'2021-12-06 17:06:13','',''),(2185851,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 17:06:13','',''),(2185871,'1','139','772',330,'Retail Sale Id 1290280',6400.00,0.00,0.00,0.00,480.00,'2021-12-06 17:07:39','',''),(2185872,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 17:07:39','',''),(2185903,'1','139','772',330,'Retail Sale Id 1290299',30500.00,0.00,0.00,0.00,900.00,'2021-12-06 17:09:35','',''),(2185904,'1','139','772',330,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 17:09:35','',''),(2185919,'1','139','772',330,'Retail Sale Id 1290309',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 17:10:42','',''),(2185920,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 17:10:42','',''),(2185943,'1','139','772',330,'Retail Sale Id 1290320',1920.00,0.00,0.00,0.00,144.00,'2021-12-06 17:12:18','',''),(2185944,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 17:12:18','',''),(2185961,'1','139','772',330,'Retail Sale Id 1290332',1920.00,0.00,0.00,0.00,144.00,'2021-12-06 17:13:23','',''),(2185962,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 17:13:23','',''),(2185981,'1','139','772',330,'Retail Sale Id 1290343',3840.00,0.00,0.00,0.00,288.00,'2021-12-06 17:14:45','',''),(2185982,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 17:14:45','',''),(2185999,'1','139','772',330,'Retail Sale Id 1290351',800.00,0.00,0.00,0.00,60.00,'2021-12-06 17:16:34','',''),(2186000,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-06 17:16:34','',''),(2186037,'1','139','772',330,'Retail Sale Id 1290372',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 17:21:22','',''),(2186038,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 17:21:22','',''),(2186116,'1','139','772',330,'Retail Sale Id 1290412',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 17:27:42','',''),(2186117,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 17:27:42','',''),(2186195,'1','139','772',330,'Retail Sale Id 1290444',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 17:36:34','',''),(2186196,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 17:36:34','',''),(2186217,'1','139','772',330,'Retail Sale Id 1290452',7320.00,0.00,0.00,0.00,216.00,'2021-12-06 17:38:02','',''),(2186218,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-06 17:38:02','',''),(2186244,'1','139','772',330,'Retail Sale Id 1290470',1280000.00,0.00,0.00,0.00,96000.00,'2021-12-06 17:40:41','',''),(2186245,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2000.00,0.00,'2021-12-06 17:40:41','',''),(2186306,'1','139','772',330,'Retail Sale Id 1290521',64000.00,0.00,0.00,0.00,4800.00,'2021-12-06 17:49:42','',''),(2186307,'1','139','772',330,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 17:49:42','',''),(2186494,'1','139','772',330,'Return of Retail Sale Id 1290470',0.00,1280000.00,2000.00,0.00,-96000.00,'2021-12-06 18:21:06','',''),(2186495,'1','139','772',330,'Retail Sale Id 1290566',1212000.00,0.00,0.00,0.00,28000.00,'2021-12-06 18:23:03','',''),(2186496,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2000.00,0.00,'2021-12-06 18:23:03','',''),(2187517,'1','139','772',330,'Retail Sale Id 1290842',3840.00,0.00,0.00,0.00,288.00,'2021-12-07 06:33:53','',''),(2187518,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 06:33:53','',''),(2187547,'1','139','772',330,'Retail Sale Id 1290857',2502.40,0.00,0.00,0.00,187.68,'2021-12-07 06:35:47','',''),(2187548,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-07 06:35:47','',''),(2187573,'1','139','772',330,'Retail Sale Id 1290868',32940.00,0.00,0.00,0.00,972.00,'2021-12-07 06:37:34','',''),(2187574,'1','139','772',330,'Retail sales',0.00,0.00,0.00,54.00,0.00,'2021-12-07 06:37:34','',''),(2187585,'1','139','772',330,'Retail Sale Id 1290878',998.40,0.00,0.00,0.00,74.88,'2021-12-07 06:38:47','',''),(2187586,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 06:38:47','',''),(2187603,'1','139','772',330,'Retail Sale Id 1290887',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 06:39:40','',''),(2187604,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:39:40','',''),(2187619,'1','139','772',330,'Retail Sale Id 1290896',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 06:40:40','',''),(2187620,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 06:40:40','',''),(2187637,'1','139','772',330,'Retail Sale Id 1290905',1920.00,0.00,0.00,0.00,144.00,'2021-12-07 06:41:48','',''),(2187638,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 06:41:48','',''),(2187689,'1','139','772',330,'Retail Sale Id 1290934',1280.00,0.00,0.00,0.00,96.00,'2021-12-07 06:45:11','',''),(2187690,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 06:45:11','',''),(2187699,'1','139','772',330,'Retail Sale Id 1290943',3520.00,0.00,0.00,0.00,264.00,'2021-12-07 06:46:19','',''),(2187700,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-07 06:46:19','',''),(2187710,'1','139','772',330,'Retail Sale Id 1290949',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 06:47:23','',''),(2187711,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 06:47:23','',''),(2187728,'1','139','772',330,'Retail Sale Id 1290957',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 06:48:21','',''),(2187729,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 06:48:21','',''),(2187736,'1','139','772',330,'Retail Sale Id 1290960',4998.40,0.00,0.00,0.00,374.88,'2021-12-07 06:49:13','',''),(2187737,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-07 06:49:13','',''),(2187817,'1','139','772',330,'Retail Sale Id 1290984',2560.00,0.00,0.00,0.00,192.00,'2021-12-07 06:52:45','',''),(2187818,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 06:52:45','',''),(2187940,'1','139','772',330,'Retail Sale Id 1291043',800.00,0.00,0.00,0.00,60.00,'2021-12-07 07:00:45','',''),(2187941,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-07 07:00:45','',''),(2187992,'1','139','772',330,'Retail Sale Id 1291071',8320.00,0.00,0.00,0.00,624.00,'2021-12-07 07:03:05','',''),(2187993,'1','139','772',330,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-07 07:03:05','',''),(2188022,'1','139','772',330,'Retail Sale Id 1291086',2560.00,0.00,0.00,0.00,192.00,'2021-12-07 07:04:42','',''),(2188023,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 07:04:42','',''),(2188052,'1','139','772',330,'Retail Sale Id 1291099',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 07:05:58','',''),(2188053,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 07:05:58','',''),(2188072,'1','139','772',330,'Retail Sale Id 1291110',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 07:06:57','',''),(2188073,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 07:06:57','',''),(2188120,'1','139','772',330,'Retail Sale Id 1291127',9600.00,0.00,0.00,0.00,720.00,'2021-12-07 07:09:09','',''),(2188121,'1','139','772',330,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-07 07:09:09','',''),(2188148,'1','139','772',330,'Retail Sale Id 1291148',6400.00,0.00,0.00,0.00,480.00,'2021-12-07 07:10:38','',''),(2188149,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 07:10:38','',''),(2188204,'1','139','772',330,'Retail Sale Id 1291174',6400.00,0.00,0.00,0.00,480.00,'2021-12-07 07:13:17','',''),(2188205,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 07:13:17','',''),(2188232,'1','139','772',330,'Retail Sale Id 1291189',998.40,0.00,0.00,0.00,74.88,'2021-12-07 07:14:30','',''),(2188233,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 07:14:30','',''),(2188260,'1','139','772',330,'Retail Sale Id 1291198',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 07:15:33','',''),(2188261,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 07:15:33','',''),(2188346,'1','139','772',330,'Retail Sale Id 1291244',640.00,0.00,0.00,0.00,48.00,'2021-12-07 07:19:35','',''),(2188347,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 07:19:35','',''),(2188362,'1','139','772',330,'Retail Sale Id 1291255',1280.00,0.00,0.00,0.00,96.00,'2021-12-07 07:20:33','',''),(2188363,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 07:20:33','',''),(2188386,'1','139','772',330,'Retail Sale Id 1291268',2502.40,0.00,0.00,0.00,187.68,'2021-12-07 07:21:25','',''),(2188387,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-07 07:21:25','',''),(2188434,'1','139','772',330,'Retail Sale Id 1291294',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 07:24:12','',''),(2188435,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 07:24:12','',''),(2188462,'1','139','772',330,'Retail Sale Id 1291305',800.00,0.00,0.00,0.00,60.00,'2021-12-07 07:25:06','',''),(2188463,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-07 07:25:06','',''),(2188494,'1','139','772',330,'Retail Sale Id 1291321',1280.00,0.00,0.00,0.00,96.00,'2021-12-07 07:27:07','',''),(2188495,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 07:27:07','',''),(2188563,'1','139','772',330,'Retail Sale Id 1291352',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 07:29:43','',''),(2188564,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 07:29:43','',''),(2188583,'1','139','772',330,'Retail Sale Id 1291364',4697.60,0.00,0.00,0.00,352.32,'2021-12-07 07:30:44','',''),(2188584,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.34,0.00,'2021-12-07 07:30:44','',''),(2188616,'1','139','772',330,'Retail Sale Id 1291383',640.00,0.00,0.00,0.00,48.00,'2021-12-07 07:31:55','',''),(2188617,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 07:31:55','',''),(2188650,'1','139','772',330,'Retail Sale Id 1291401',1600.00,0.00,0.00,0.00,120.00,'2021-12-07 07:33:57','',''),(2188651,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-07 07:33:57','',''),(2188714,'1','139','772',330,'Retail Sale Id 1291430',640.00,0.00,0.00,0.00,48.00,'2021-12-07 07:37:09','',''),(2188715,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 07:37:09','',''),(2188744,'1','139','772',330,'Retail Sale Id 1291447',4480.00,0.00,0.00,0.00,336.00,'2021-12-07 07:38:22','',''),(2188745,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 07:38:22','',''),(2188762,'1','139','772',330,'Retail Sale Id 1291457',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 07:39:32','',''),(2188763,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 07:39:32','',''),(2188860,'1','139','772',330,'Retail Sale Id 1291523',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 07:44:54','',''),(2188861,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 07:44:54','',''),(2188906,'1','139','772',330,'Retail Sale Id 1291554',6400.00,0.00,0.00,0.00,480.00,'2021-12-07 07:47:17','',''),(2188907,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 07:47:17','',''),(2188996,'1','139','772',330,'Retail Sale Id 1291596',2240.00,0.00,0.00,0.00,168.00,'2021-12-07 07:52:15','',''),(2188997,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-07 07:52:15','',''),(2189268,'1','139','772',330,'Retail Sale Id 1291729',2240.00,0.00,0.00,0.00,168.00,'2021-12-07 08:07:45','',''),(2189269,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-07 08:07:45','',''),(2189355,'1','139','772',330,'Retail Sale Id 1291764',10240.00,0.00,0.00,0.00,768.00,'2021-12-07 08:11:51','',''),(2189356,'1','139','772',330,'Retail sales',0.00,0.00,0.00,16.00,0.00,'2021-12-07 08:11:51','',''),(2189371,'1','139','772',330,'Retail Sale Id 1291772',30500.00,0.00,0.00,0.00,900.00,'2021-12-07 08:13:24','',''),(2189372,'1','139','772',330,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 08:13:24','',''),(2189422,'1','139','772',330,'Retail Sale Id 1291797',697.60,0.00,0.00,0.00,52.32,'2021-12-07 08:15:56','',''),(2189423,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-07 08:15:56','',''),(2189456,'1','139','772',330,'Retail Sale Id 1291812',2240.00,0.00,0.00,0.00,168.00,'2021-12-07 08:17:43','',''),(2189457,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-07 08:17:43','',''),(2189469,'1','139','772',330,'Retail Sale Id 1291821',1203.20,0.00,0.00,0.00,90.24,'2021-12-07 08:18:33','',''),(2189470,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-07 08:18:33','',''),(2189497,'1','139','772',330,'Retail Sale Id 1291834',640.00,0.00,0.00,0.00,48.00,'2021-12-07 08:20:10','',''),(2189498,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 08:20:10','',''),(2189515,'1','139','772',330,'Retail Sale Id 1291845',30500.00,0.00,0.00,0.00,900.00,'2021-12-07 08:21:24','',''),(2189516,'1','139','772',330,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 08:21:24','',''),(2189531,'1','139','772',330,'Retail Sale Id 1291853',2502.40,0.00,0.00,0.00,187.68,'2021-12-07 08:22:12','',''),(2189532,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-07 08:22:12','',''),(2189561,'1','139','772',330,'Retail Sale Id 1291863',6400.00,0.00,0.00,0.00,480.00,'2021-12-07 08:23:55','',''),(2189562,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 08:23:55','',''),(2189577,'1','139','772',330,'Retail Sale Id 1291872',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 08:25:03','',''),(2189578,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 08:25:03','',''),(2189615,'1','139','772',330,'Retail Sale Id 1291889',3520.00,0.00,0.00,0.00,264.00,'2021-12-07 08:27:43','',''),(2189616,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-07 08:27:43','',''),(2189669,'1','139','772',330,'Retail Sale Id 1291918',5120.00,0.00,0.00,0.00,384.00,'2021-12-07 08:31:28','',''),(2189670,'1','139','772',330,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-07 08:31:28','',''),(2189683,'1','139','772',330,'Retail Sale Id 1291925',6710.00,0.00,0.00,0.00,198.00,'2021-12-07 08:32:41','',''),(2189684,'1','139','772',330,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-07 08:32:41','',''),(2189730,'1','139','772',330,'Retail Sale Id 1291945',640.00,0.00,0.00,0.00,48.00,'2021-12-07 08:34:32','',''),(2189731,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 08:34:32','',''),(2189756,'1','139','772',330,'Retail Sale Id 1291953',1600.00,0.00,0.00,0.00,120.00,'2021-12-07 08:35:25','',''),(2189757,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-07 08:35:25','',''),(2189846,'1','139','772',330,'Retail Sale Id 1291976',998.40,0.00,0.00,0.00,74.88,'2021-12-07 08:38:42','',''),(2189847,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 08:38:42','',''),(2189866,'1','139','772',330,'Retail Sale Id 1291987',1920.00,0.00,0.00,0.00,144.00,'2021-12-07 08:40:31','',''),(2189867,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 08:40:31','',''),(2189892,'1','139','772',330,'Retail Sale Id 1292002',800.00,0.00,0.00,0.00,60.00,'2021-12-07 08:42:02','',''),(2189893,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-07 08:42:02','',''),(2189920,'1','139','772',330,'Retail Sale Id 1292016',4499.20,0.00,0.00,0.00,337.44,'2021-12-07 08:43:18','',''),(2189921,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-07 08:43:18','',''),(2189989,'1','139','772',330,'Retail Sale Id 1292039',3840.00,0.00,0.00,0.00,288.00,'2021-12-07 08:46:11','',''),(2189990,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 08:46:11','',''),(2190039,'1','139','772',330,'Retail Sale Id 1292062',2560.00,0.00,0.00,0.00,192.00,'2021-12-07 08:48:55','',''),(2190040,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 08:48:55','',''),(2190088,'1','139','772',330,'Retail Sale Id 1292086',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 08:50:46','',''),(2190089,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 08:50:46','',''),(2190116,'1','139','772',330,'Retail Sale Id 1292099',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 08:52:36','',''),(2190117,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 08:52:36','',''),(2190140,'1','139','772',330,'Retail Sale Id 1292110',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 08:53:44','',''),(2190141,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:53:44','',''),(2190180,'1','139','772',330,'Retail Sale Id 1292132',640.00,0.00,0.00,0.00,48.00,'2021-12-07 08:55:58','',''),(2190181,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 08:55:58','',''),(2190250,'1','139','772',330,'Retail Sale Id 1292164',5120.00,0.00,0.00,0.00,384.00,'2021-12-07 09:01:21','',''),(2190251,'1','139','772',330,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-07 09:01:21','',''),(2190275,'1','139','772',330,'Retail Sale Id 1292180',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 09:03:33','',''),(2190276,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 09:03:33','',''),(2190347,'1','139','772',330,'Retail Sale Id 1292212',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 09:07:28','',''),(2190348,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 09:07:28','',''),(2190367,'1','139','772',330,'Retail Sale Id 1292221',640.00,0.00,0.00,0.00,48.00,'2021-12-07 09:08:14','',''),(2190368,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 09:08:14','',''),(2190381,'1','139','772',330,'Retail Sale Id 1292229',4998.40,0.00,0.00,0.00,374.88,'2021-12-07 09:09:05','',''),(2190382,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-07 09:09:05','',''),(2190401,'1','139','772',330,'Retail Sale Id 1292239',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 09:10:00','',''),(2190402,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 09:10:00','',''),(2190433,'1','139','772',330,'Retail Sale Id 1292250',5120.00,0.00,0.00,0.00,384.00,'2021-12-07 09:11:40','',''),(2190434,'1','139','772',330,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-07 09:11:40','',''),(2190449,'1','139','772',330,'Retail Sale Id 1292264',2560.00,0.00,0.00,0.00,192.00,'2021-12-07 09:12:43','',''),(2190450,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 09:12:43','',''),(2190547,'1','139','772',330,'Retail Sale Id 1292316',6502.40,0.00,0.00,0.00,487.68,'2021-12-07 09:17:39','',''),(2190548,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-07 09:17:39','',''),(2190561,'1','139','772',330,'Retail Sale Id 1292324',697.60,0.00,0.00,0.00,52.32,'2021-12-07 09:18:56','',''),(2190562,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-07 09:18:56','',''),(2190591,'1','139','772',330,'Retail Sale Id 1292331',1280.00,0.00,0.00,0.00,96.00,'2021-12-07 09:20:23','',''),(2190592,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 09:20:23','',''),(2190647,'1','139','772',330,'Retail Sale Id 1292360',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 09:23:22','',''),(2190648,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 09:23:23','',''),(2190669,'1','139','772',330,'Retail Sale Id 1292373',8320.00,0.00,0.00,0.00,624.00,'2021-12-07 09:24:32','',''),(2190670,'1','139','772',330,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-07 09:24:32','',''),(2190719,'1','139','772',330,'Retail Sale Id 1292394',1600.00,0.00,0.00,0.00,120.00,'2021-12-07 09:27:00','',''),(2190720,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-07 09:27:00','',''),(2190778,'1','139','772',330,'Retail Sale Id 1292421',30500.00,0.00,0.00,0.00,900.00,'2021-12-07 09:29:10','',''),(2190779,'1','139','772',330,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 09:29:10','',''),(2190804,'1','139','772',330,'Retail Sale Id 1292434',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 09:30:07','',''),(2190805,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 09:30:07','',''),(2190952,'1','139','772',330,'Retail Sale Id 1292505',640.00,0.00,0.00,0.00,48.00,'2021-12-07 09:38:15','',''),(2190953,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 09:38:15','',''),(2191014,'1','139','772',330,'Retail Sale Id 1292540',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 09:41:34','',''),(2191015,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 09:41:34','',''),(2191036,'1','139','772',330,'Retail Sale Id 1292551',1203.20,0.00,0.00,0.00,90.24,'2021-12-07 09:42:25','',''),(2191037,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-07 09:42:25','',''),(2191056,'1','139','772',330,'Retail Sale Id 1292563',4480.00,0.00,0.00,0.00,336.00,'2021-12-07 09:43:59','',''),(2191057,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 09:43:59','',''),(2191252,'1','139','772',330,'Retail Sale Id 1292667',697.60,0.00,0.00,0.00,52.32,'2021-12-07 09:58:30','',''),(2191253,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-07 09:58:30','',''),(2191278,'1','139','772',330,'Retail Sale Id 1292680',1798.40,0.00,0.00,0.00,134.88,'2021-12-07 10:00:04','',''),(2191279,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-07 10:00:04','',''),(2191289,'1','139','772',330,'Retail Sale Id 1292692',1600.00,0.00,0.00,0.00,120.00,'2021-12-07 10:01:06','',''),(2191290,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-07 10:01:06','',''),(2191395,'1','139','772',330,'Retail Sale Id 1292736',10003.20,0.00,0.00,0.00,750.24,'2021-12-07 10:08:01','',''),(2191396,'1','139','772',330,'Retail sales',0.00,0.00,0.00,15.63,0.00,'2021-12-07 10:08:01','',''),(2191425,'1','139','772',330,'Retail Sale Id 1292751',640.00,0.00,0.00,0.00,48.00,'2021-12-07 10:09:59','',''),(2191426,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 10:09:59','',''),(2191467,'1','139','772',330,'Retail Sale Id 1292780',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 10:12:34','',''),(2191468,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 10:12:34','',''),(2191501,'1','139','772',330,'Retail Sale Id 1292798',998.40,0.00,0.00,0.00,74.88,'2021-12-07 10:15:02','',''),(2191502,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 10:15:02','',''),(2191519,'1','139','772',330,'Retail Sale Id 1292806',1600.00,0.00,0.00,0.00,120.00,'2021-12-07 10:16:04','',''),(2191520,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-07 10:16:04','',''),(2191547,'1','139','772',330,'Retail Sale Id 1292819',7680.00,0.00,0.00,0.00,576.00,'2021-12-07 10:17:36','',''),(2191548,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 10:17:36','',''),(2191567,'1','139','772',330,'Retail Sale Id 1292830',1920.00,0.00,0.00,0.00,144.00,'2021-12-07 10:19:27','',''),(2191568,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 10:19:27','',''),(2191577,'1','139','772',330,'Retail Sale Id 1292837',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 10:20:30','',''),(2191578,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 10:20:30','',''),(2191605,'1','139','772',330,'Retail Sale Id 1292850',1920.00,0.00,0.00,0.00,144.00,'2021-12-07 10:22:03','',''),(2191606,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 10:22:03','',''),(2191629,'1','139','772',330,'Retail Sale Id 1292861',902.40,0.00,0.00,0.00,67.68,'2021-12-07 10:24:31','',''),(2191630,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-07 10:24:31','',''),(2191643,'1','139','772',330,'Retail Sale Id 1292870',152500.00,0.00,0.00,0.00,4500.00,'2021-12-07 10:26:07','',''),(2191644,'1','139','772',330,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-07 10:26:07','',''),(2191659,'1','139','772',330,'Retail Sale Id 1292877',16000.00,0.00,0.00,0.00,1200.00,'2021-12-07 10:26:51','',''),(2191660,'1','139','772',330,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 10:26:51','',''),(2191680,'1','139','772',330,'Retail Sale Id 1292885',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 10:28:02','',''),(2191681,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 10:28:02','',''),(2191692,'1','139','772',330,'Retail Sale Id 1292892',3500.80,0.00,0.00,0.00,262.56,'2021-12-07 10:29:28','',''),(2191693,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-07 10:29:28','',''),(2191712,'1','139','772',330,'Retail Sale Id 1292896',58560.00,0.00,0.00,0.00,1728.00,'2021-12-07 10:31:29','',''),(2191713,'1','139','772',330,'Retail sales',0.00,0.00,0.00,96.00,0.00,'2021-12-07 10:31:29','',''),(2191755,'1','139','772',330,'Retail Sale Id 1292926',998.40,0.00,0.00,0.00,74.88,'2021-12-07 10:35:12','',''),(2191756,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 10:35:12','',''),(2191769,'1','139','772',330,'Retail Sale Id 1292935',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 10:36:34','',''),(2191770,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 10:36:34','',''),(2191835,'1','139','772',330,'Retail Sale Id 1292966',998.40,0.00,0.00,0.00,74.88,'2021-12-07 10:39:58','',''),(2191836,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 10:39:58','',''),(2191855,'1','139','772',330,'Retail Sale Id 1292975',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 10:41:18','',''),(2191856,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 10:41:18','',''),(2191873,'1','139','772',330,'Retail Sale Id 1292987',998.40,0.00,0.00,0.00,74.88,'2021-12-07 10:42:22','',''),(2191874,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 10:42:22','',''),(2191897,'1','139','772',330,'Retail Sale Id 1292997',2560.00,0.00,0.00,0.00,192.00,'2021-12-07 10:43:44','',''),(2191898,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 10:43:44','',''),(2191973,'1','139','772',330,'Retail Sale Id 1293027',2240.00,0.00,0.00,0.00,168.00,'2021-12-07 10:46:42','',''),(2191974,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-07 10:46:42','',''),(2192056,'1','139','772',330,'Retail Sale Id 1293070',4998.40,0.00,0.00,0.00,374.88,'2021-12-07 10:51:03','',''),(2192057,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-07 10:51:03','',''),(2192074,'1','139','772',330,'Retail Sale Id 1293078',998.40,0.00,0.00,0.00,74.88,'2021-12-07 10:51:53','',''),(2192075,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 10:51:53','',''),(2192094,'1','139','772',330,'Retail Sale Id 1293089',2240.00,0.00,0.00,0.00,168.00,'2021-12-07 10:53:03','',''),(2192095,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-07 10:53:03','',''),(2192125,'1','139','772',330,'Retail Sale Id 1293101',1600.00,0.00,0.00,0.00,120.00,'2021-12-07 10:54:43','',''),(2192126,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-07 10:54:43','',''),(2192154,'1','139','772',330,'Retail Sale Id 1293117',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 10:56:20','',''),(2192155,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 10:56:20','',''),(2192169,'1','139','772',330,'Retail Sale Id 1293125',640.00,0.00,0.00,0.00,48.00,'2021-12-07 10:57:17','',''),(2192170,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 10:57:17','',''),(2192189,'1','139','772',330,'Retail Sale Id 1293133',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 10:58:24','',''),(2192190,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 10:58:24','',''),(2192217,'1','139','772',330,'Retail Sale Id 1293150',7680.00,0.00,0.00,0.00,576.00,'2021-12-07 11:00:11','',''),(2192218,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 11:00:11','',''),(2192276,'1','139','772',330,'Retail Sale Id 1293163',1920.00,0.00,0.00,0.00,144.00,'2021-12-07 11:02:06','',''),(2192277,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:02:06','',''),(2192312,'1','139','772',330,'Retail Sale Id 1293183',998.40,0.00,0.00,0.00,74.88,'2021-12-07 11:04:05','',''),(2192313,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 11:04:05','',''),(2192362,'1','139','772',330,'Retail Sale Id 1293207',2560.00,0.00,0.00,0.00,192.00,'2021-12-07 11:07:05','',''),(2192363,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 11:07:05','',''),(2192408,'1','139','772',330,'Retail Sale Id 1293229',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 11:08:48','',''),(2192409,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 11:08:48','',''),(2192432,'1','139','772',330,'Retail Sale Id 1293240',998.40,0.00,0.00,0.00,74.88,'2021-12-07 11:10:01','',''),(2192433,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 11:10:01','',''),(2192478,'1','139','772',330,'Retail Sale Id 1293266',1920.00,0.00,0.00,0.00,144.00,'2021-12-07 11:12:07','',''),(2192479,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:12:07','',''),(2192508,'1','139','772',330,'Retail Sale Id 1293290',998.40,0.00,0.00,0.00,74.88,'2021-12-07 11:14:21','',''),(2192509,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 11:14:21','',''),(2192524,'1','139','772',330,'Retail Sale Id 1293299',2560.00,0.00,0.00,0.00,192.00,'2021-12-07 11:15:35','',''),(2192525,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 11:15:35','',''),(2192540,'1','139','772',330,'Retail Sale Id 1293303',1600.00,0.00,0.00,0.00,120.00,'2021-12-07 11:16:37','',''),(2192541,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-07 11:16:37','',''),(2192610,'1','139','772',330,'Retail Sale Id 1293359',1280.00,0.00,0.00,0.00,96.00,'2021-12-07 11:21:45','',''),(2192611,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 11:21:45','',''),(2192632,'1','139','772',330,'Retail Sale Id 1293377',2560.00,0.00,0.00,0.00,192.00,'2021-12-07 11:23:24','',''),(2192633,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 11:23:24','',''),(2192646,'1','139','772',330,'Retail Sale Id 1293386',697.60,0.00,0.00,0.00,52.32,'2021-12-07 11:24:30','',''),(2192647,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-07 11:24:30','',''),(2192736,'1','139','772',330,'Retail Sale Id 1293432',1920.00,0.00,0.00,0.00,144.00,'2021-12-07 11:30:30','',''),(2192737,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:30:30','',''),(2192771,'1','139','772',330,'Retail Sale Id 1293445',1280.00,0.00,0.00,0.00,96.00,'2021-12-07 11:33:37','',''),(2192772,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 11:33:37','',''),(2192785,'1','139','772',330,'Retail Sale Id 1293454',7680.00,0.00,0.00,0.00,576.00,'2021-12-07 11:34:55','',''),(2192786,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 11:34:55','',''),(2192803,'1','139','772',330,'Retail Sale Id 1293463',998.40,0.00,0.00,0.00,74.88,'2021-12-07 11:36:16','',''),(2192804,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 11:36:16','',''),(2192841,'1','139','772',330,'Retail Sale Id 1293483',1920.00,0.00,0.00,0.00,144.00,'2021-12-07 11:39:00','',''),(2192842,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:39:00','',''),(2192865,'1','139','772',330,'Retail Sale Id 1293498',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 11:40:30','',''),(2192866,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 11:40:30','',''),(2192879,'1','139','772',330,'Retail Sale Id 1293505',4480.00,0.00,0.00,0.00,336.00,'2021-12-07 11:41:29','',''),(2192880,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 11:41:29','',''),(2192915,'1','139','772',330,'Retail Sale Id 1293528',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 11:44:13','',''),(2192916,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 11:44:13','',''),(2193065,'1','139','772',330,'Retail Sale Id 1293596',1280.00,0.00,0.00,0.00,96.00,'2021-12-07 11:55:07','',''),(2193066,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 11:55:07','',''),(2193079,'1','139','772',330,'Retail Sale Id 1293602',1702.40,0.00,0.00,0.00,127.68,'2021-12-07 11:56:44','',''),(2193080,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-07 11:56:44','',''),(2193099,'1','139','772',330,'Retail Sale Id 1293612',2560.00,0.00,0.00,0.00,192.00,'2021-12-07 11:58:19','',''),(2193100,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 11:58:19','',''),(2193139,'1','139','772',330,'Retail Sale Id 1293634',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 12:01:46','',''),(2193140,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 12:01:46','',''),(2193147,'1','139','772',330,'Retail Sale Id 1293639',640.00,0.00,0.00,0.00,48.00,'2021-12-07 12:02:37','',''),(2193148,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 12:02:37','',''),(2193159,'1','139','772',330,'Retail Sale Id 1293644',1920.00,0.00,0.00,0.00,144.00,'2021-12-07 12:03:40','',''),(2193160,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 12:03:40','',''),(2193213,'1','139','772',330,'Retail Sale Id 1293679',1152.00,0.00,0.00,0.00,86.40,'2021-12-07 12:10:34','',''),(2193214,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.80,0.00,'2021-12-07 12:10:34','',''),(2193261,'1','139','772',330,'Retail Sale Id 1293702',7680.00,0.00,0.00,0.00,576.00,'2021-12-07 12:12:56','',''),(2193262,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 12:12:56','',''),(2193301,'1','139','772',330,'Retail Sale Id 1293725',1280.00,0.00,0.00,0.00,96.00,'2021-12-07 12:16:31','',''),(2193302,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 12:16:31','',''),(2193327,'1','139','772',330,'Retail Sale Id 1293736',1920.00,0.00,0.00,0.00,144.00,'2021-12-07 12:18:23','',''),(2193328,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 12:18:23','',''),(2193351,'1','139','772',330,'Retail Sale Id 1293754',1920.00,0.00,0.00,0.00,144.00,'2021-12-07 12:19:52','',''),(2193352,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 12:19:52','',''),(2193365,'1','139','772',330,'Retail Sale Id 1293761',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 12:22:08','',''),(2193366,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 12:22:08','',''),(2193515,'1','139','772',330,'Retail Sale Id 1293834',998.40,0.00,0.00,0.00,74.88,'2021-12-07 12:35:43','',''),(2193516,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 12:35:43','',''),(2193589,'1','139','772',330,'Retail Sale Id 1293880',2560.00,0.00,0.00,0.00,192.00,'2021-12-07 12:41:44','',''),(2193590,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 12:41:44','',''),(2193610,'1','139','772',330,'Retail Sale Id 1293887',998.40,0.00,0.00,0.00,74.88,'2021-12-07 12:43:10','',''),(2193611,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 12:43:10','',''),(2193658,'1','139','772',330,'Retail Sale Id 1293930',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 12:47:36','',''),(2193659,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 12:47:36','',''),(2193687,'1','139','772',330,'Retail Sale Id 1293941',640.00,0.00,0.00,0.00,48.00,'2021-12-07 12:49:16','',''),(2193688,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 12:49:16','',''),(2193707,'1','139','772',330,'Retail Sale Id 1293952',3840.00,0.00,0.00,0.00,288.00,'2021-12-07 12:50:33','',''),(2193708,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 12:50:33','',''),(2193737,'1','139','772',330,'Retail Sale Id 1293966',3840.00,0.00,0.00,0.00,288.00,'2021-12-07 12:51:49','',''),(2193738,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 12:51:49','',''),(2193757,'1','139','772',330,'Retail Sale Id 1293978',998.40,0.00,0.00,0.00,74.88,'2021-12-07 12:52:51','',''),(2193758,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 12:52:51','',''),(2193783,'1','139','772',330,'Retail Sale Id 1293990',1600.00,0.00,0.00,0.00,120.00,'2021-12-07 12:54:57','',''),(2193784,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-07 12:54:57','',''),(2193800,'1','139','772',330,'Retail Sale Id 1293998',1280.00,0.00,0.00,0.00,96.00,'2021-12-07 12:56:22','',''),(2193801,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 12:56:22','',''),(2193843,'1','139','772',330,'Retail Sale Id 1294024',3840.00,0.00,0.00,0.00,288.00,'2021-12-07 12:58:56','',''),(2193844,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 12:58:56','',''),(2193877,'1','139','772',330,'Retail Sale Id 1294036',4480.00,0.00,0.00,0.00,336.00,'2021-12-07 13:00:16','',''),(2193878,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 13:00:16','',''),(2193894,'1','139','772',330,'Retail Sale Id 1294045',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 13:01:10','',''),(2193895,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 13:01:10','',''),(2193907,'1','139','772',330,'Retail Sale Id 1294051',4480.00,0.00,0.00,0.00,336.00,'2021-12-07 13:02:09','',''),(2193908,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 13:02:09','',''),(2193926,'1','139','772',330,'Retail Sale Id 1294059',2560.00,0.00,0.00,0.00,192.00,'2021-12-07 13:03:50','',''),(2193927,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 13:03:50','',''),(2193954,'1','139','772',330,'Retail Sale Id 1294072',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 13:05:39','',''),(2193955,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 13:05:39','',''),(2193972,'1','139','772',330,'Retail Sale Id 1294080',7040.00,0.00,0.00,0.00,528.00,'2021-12-07 13:07:13','',''),(2193973,'1','139','772',330,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-07 13:07:13','',''),(2193984,'1','139','772',330,'Retail Sale Id 1294087',800.00,0.00,0.00,0.00,60.00,'2021-12-07 13:08:14','',''),(2193985,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-07 13:08:14','',''),(2193995,'1','139','772',330,'Retail Sale Id 1294094',4998.40,0.00,0.00,0.00,374.88,'2021-12-07 13:09:20','',''),(2193996,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-07 13:09:20','',''),(2194011,'1','139','772',330,'Retail Sale Id 1294103',3500.80,0.00,0.00,0.00,262.56,'2021-12-07 13:10:42','',''),(2194012,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-07 13:10:42','',''),(2194027,'1','139','772',330,'Retail Sale Id 1294109',998.40,0.00,0.00,0.00,74.88,'2021-12-07 13:11:35','',''),(2194028,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 13:11:35','',''),(2194111,'1','139','772',330,'Retail Sale Id 1294156',1280.00,0.00,0.00,0.00,96.00,'2021-12-07 13:16:23','',''),(2194112,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 13:16:23','',''),(2194127,'1','139','772',330,'Retail Sale Id 1294164',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 13:17:37','',''),(2194128,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 13:17:37','',''),(2194165,'1','139','772',330,'Retail Sale Id 1294181',3840.00,0.00,0.00,0.00,288.00,'2021-12-07 13:19:38','',''),(2194166,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 13:19:38','',''),(2194223,'1','139','772',330,'Retail Sale Id 1294275',3840.00,0.00,0.00,0.00,288.00,'2021-12-07 13:24:33','',''),(2194224,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 13:24:33','',''),(2194317,'1','139','772',330,'Retail Sale Id 1294331',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 13:27:32','',''),(2194318,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 13:27:32','',''),(2194363,'1','139','772',330,'Retail Sale Id 1294347',5120.00,0.00,0.00,0.00,384.00,'2021-12-07 13:29:37','',''),(2194364,'1','139','772',330,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-07 13:29:37','',''),(2194398,'1','139','772',330,'Retail Sale Id 1294358',1600.00,0.00,0.00,0.00,120.00,'2021-12-07 13:31:03','',''),(2194399,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-07 13:31:03','',''),(2194427,'1','139','772',330,'Retail Sale Id 1294367',998.40,0.00,0.00,0.00,74.88,'2021-12-07 13:32:29','',''),(2194428,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 13:32:29','',''),(2194461,'1','139','772',330,'Retail Sale Id 1294382',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 13:34:47','',''),(2194462,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 13:34:47','',''),(2194522,'1','139','772',330,'Retail Sale Id 1294408',7001.60,0.00,0.00,0.00,525.12,'2021-12-07 13:38:09','',''),(2194523,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-07 13:38:09','',''),(2194546,'1','139','772',330,'Retail Sale Id 1294418',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 13:38:58','',''),(2194547,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 13:38:58','',''),(2194569,'1','139','772',330,'Retail Sale Id 1294423',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 13:40:17','',''),(2194570,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 13:40:17','',''),(2194597,'1','139','772',330,'Retail Sale Id 1294443',1280.00,0.00,0.00,0.00,96.00,'2021-12-07 13:42:51','',''),(2194598,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 13:42:51','',''),(2194631,'1','139','772',330,'Retail Sale Id 1294460',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 13:45:21','',''),(2194632,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:45:21','',''),(2194657,'1','139','772',330,'Retail Sale Id 1294471',8320.00,0.00,0.00,0.00,624.00,'2021-12-07 13:46:37','',''),(2194658,'1','139','772',330,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-07 13:46:37','',''),(2194678,'1','139','772',330,'Retail Sale Id 1294482',4480.00,0.00,0.00,0.00,336.00,'2021-12-07 13:48:09','',''),(2194679,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 13:48:09','',''),(2194703,'1','139','772',330,'Retail Sale Id 1294489',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 13:49:12','',''),(2194704,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 13:49:12','',''),(2194755,'1','139','772',330,'Retail Sale Id 1294508',1600.00,0.00,0.00,0.00,120.00,'2021-12-07 13:52:23','',''),(2194756,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-07 13:52:23','',''),(2194774,'1','139','772',330,'Retail Sale Id 1294516',1280.00,0.00,0.00,0.00,96.00,'2021-12-07 13:53:37','',''),(2194775,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 13:53:37','',''),(2194798,'1','139','772',330,'Retail Sale Id 1294534',3500.80,0.00,0.00,0.00,262.56,'2021-12-07 13:55:10','',''),(2194799,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-07 13:55:10','',''),(2194859,'1','139','772',330,'Retail Sale Id 1294563',640.00,0.00,0.00,0.00,48.00,'2021-12-07 13:59:33','',''),(2194860,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 13:59:33','',''),(2194881,'1','139','772',330,'Retail Sale Id 1294579',3840.00,0.00,0.00,0.00,288.00,'2021-12-07 14:01:15','',''),(2194882,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 14:01:15','',''),(2194937,'1','139','772',330,'Retail Sale Id 1294606',1203.20,0.00,0.00,0.00,90.24,'2021-12-07 14:04:53','',''),(2194938,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-07 14:04:53','',''),(2194949,'1','139','772',330,'Retail Sale Id 1294612',748.80,0.00,0.00,0.00,56.16,'2021-12-07 14:06:04','',''),(2194950,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.17,0.00,'2021-12-07 14:06:04','',''),(2194969,'1','139','772',330,'Retail Sale Id 1294623',1280.00,0.00,0.00,0.00,96.00,'2021-12-07 14:07:17','',''),(2194970,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 14:07:17','',''),(2195008,'1','139','772',330,'Retail Sale Id 1294640',1920.00,0.00,0.00,0.00,144.00,'2021-12-07 14:09:03','',''),(2195009,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 14:09:03','',''),(2195029,'1','139','772',330,'Retail Sale Id 1294650',640.00,0.00,0.00,0.00,48.00,'2021-12-07 14:10:15','',''),(2195030,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 14:10:15','',''),(2195045,'1','139','772',330,'Retail Sale Id 1294658',1600.00,0.00,0.00,0.00,120.00,'2021-12-07 14:11:01','',''),(2195046,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-07 14:11:01','',''),(2195109,'1','139','772',330,'Retail Sale Id 1294678',640.00,0.00,0.00,0.00,48.00,'2021-12-07 14:13:26','',''),(2195110,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 14:13:26','',''),(2195132,'1','139','772',330,'Retail Sale Id 1294684',6003.20,0.00,0.00,0.00,450.24,'2021-12-07 14:14:42','',''),(2195133,'1','139','772',330,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-07 14:14:42','',''),(2195159,'1','139','772',330,'Retail Sale Id 1294691',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 14:15:33','',''),(2195160,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:15:33','',''),(2195212,'1','139','772',330,'Retail Sale Id 1294708',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 14:18:43','',''),(2195213,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 14:18:43','',''),(2195226,'1','139','772',330,'Retail Sale Id 1294715',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 14:19:38','',''),(2195227,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 14:19:38','',''),(2195256,'1','139','772',330,'Retail Sale Id 1294732',3840.00,0.00,0.00,0.00,288.00,'2021-12-07 14:21:55','',''),(2195257,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 14:21:55','',''),(2195284,'1','139','772',330,'Retail Sale Id 1294745',1702.40,0.00,0.00,0.00,127.68,'2021-12-07 14:23:12','',''),(2195285,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-07 14:23:12','',''),(2195306,'1','139','772',330,'Retail Sale Id 1294755',3840.00,0.00,0.00,0.00,288.00,'2021-12-07 14:24:15','',''),(2195307,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 14:24:15','',''),(2195372,'1','139','772',330,'Retail Sale Id 1294789',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 14:27:32','',''),(2195373,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 14:27:32','',''),(2195392,'1','139','772',330,'Retail Sale Id 1294801',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 14:28:32','',''),(2195393,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 14:28:32','',''),(2195403,'1','139','772',330,'Retail Sale Id 1294805',3840.00,0.00,0.00,0.00,288.00,'2021-12-07 14:29:25','',''),(2195404,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 14:29:25','',''),(2195436,'1','139','772',330,'Retail Sale Id 1294817',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 14:31:19','',''),(2195437,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 14:31:19','',''),(2195509,'1','139','772',330,'Retail Sale Id 1294865',4480.00,0.00,0.00,0.00,336.00,'2021-12-07 14:35:48','',''),(2195510,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 14:35:48','',''),(2195535,'1','139','772',330,'Retail Sale Id 1294879',100650.00,0.00,0.00,0.00,2970.00,'2021-12-07 14:37:02','',''),(2195536,'1','139','772',330,'Retail sales',0.00,0.00,0.00,165.00,0.00,'2021-12-07 14:37:02','',''),(2195559,'1','139','772',330,'Retail Sale Id 1294895',697.60,0.00,0.00,0.00,52.32,'2021-12-07 14:38:36','',''),(2195560,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-07 14:38:36','',''),(2195573,'1','139','772',330,'Retail Sale Id 1294900',3603.20,0.00,0.00,0.00,270.24,'2021-12-07 14:39:33','',''),(2195574,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.63,0.00,'2021-12-07 14:39:33','',''),(2195583,'1','139','772',330,'Retail Sale Id 1294907',9600.00,0.00,0.00,0.00,720.00,'2021-12-07 14:40:28','',''),(2195584,'1','139','772',330,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-07 14:40:28','',''),(2195629,'1','139','772',330,'Retail Sale Id 1294926',4480.00,0.00,0.00,0.00,336.00,'2021-12-07 14:42:20','',''),(2195630,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 14:42:20','',''),(2195672,'1','139','772',330,'Retail Sale Id 1294945',1203.20,0.00,0.00,0.00,90.24,'2021-12-07 14:44:16','',''),(2195673,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-07 14:44:16','',''),(2195740,'1','139','772',330,'Retail Sale Id 1294981',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 14:47:51','',''),(2195741,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:47:51','',''),(2195750,'1','139','772',330,'Retail Sale Id 1294989',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 14:48:44','',''),(2195751,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 14:48:44','',''),(2195802,'1','139','772',330,'Retail Sale Id 1295017',1280.00,0.00,0.00,0.00,96.00,'2021-12-07 14:50:46','',''),(2195803,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 14:50:46','',''),(2195858,'1','139','772',330,'Retail Sale Id 1295051',2560.00,0.00,0.00,0.00,192.00,'2021-12-07 14:53:19','',''),(2195859,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 14:53:19','',''),(2195872,'1','139','772',330,'Retail Sale Id 1295057',3699.20,0.00,0.00,0.00,277.44,'2021-12-07 14:54:09','',''),(2195873,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.78,0.00,'2021-12-07 14:54:09','',''),(2195886,'1','139','772',330,'Retail Sale Id 1295062',2560.00,0.00,0.00,0.00,192.00,'2021-12-07 14:55:13','',''),(2195887,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 14:55:13','',''),(2195942,'1','139','772',330,'Retail Sale Id 1295094',2560.00,0.00,0.00,0.00,192.00,'2021-12-07 14:59:06','',''),(2195943,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 14:59:06','',''),(2195968,'1','139','772',330,'Retail Sale Id 1295105',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 15:01:13','',''),(2195969,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 15:01:13','',''),(2196007,'1','139','772',330,'Retail Sale Id 1295115',2598.40,0.00,0.00,0.00,194.88,'2021-12-07 15:02:49','',''),(2196008,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-07 15:02:49','',''),(2196042,'1','139','772',330,'Retail Sale Id 1295134',5497.60,0.00,0.00,0.00,412.32,'2021-12-07 15:05:01','',''),(2196043,'1','139','772',330,'Retail sales',0.00,0.00,0.00,8.59,0.00,'2021-12-07 15:05:01','',''),(2196082,'1','139','772',330,'Retail Sale Id 1295153',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 15:07:27','',''),(2196083,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 15:07:27','',''),(2196110,'1','139','772',330,'Retail Sale Id 1295169',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 15:09:04','',''),(2196111,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 15:09:04','',''),(2196156,'1','139','772',330,'Retail Sale Id 1295193',697.60,0.00,0.00,0.00,52.32,'2021-12-07 15:11:14','',''),(2196157,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-07 15:11:14','',''),(2196196,'1','139','772',330,'Retail Sale Id 1295212',1920.00,0.00,0.00,0.00,144.00,'2021-12-07 15:12:57','',''),(2196197,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:12:57','',''),(2196236,'1','139','772',330,'Retail Sale Id 1295232',2560.00,0.00,0.00,0.00,192.00,'2021-12-07 15:15:07','',''),(2196237,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 15:15:07','',''),(2196288,'1','139','772',330,'Retail Sale Id 1295255',8640.00,0.00,0.00,0.00,648.00,'2021-12-07 15:17:41','',''),(2196289,'1','139','772',330,'Retail sales',0.00,0.00,0.00,13.50,0.00,'2021-12-07 15:17:41','',''),(2196342,'1','139','772',330,'Retail Sale Id 1295282',7625.00,0.00,0.00,0.00,225.00,'2021-12-07 15:20:59','',''),(2196343,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:20:59','',''),(2196374,'1','139','772',330,'Retail Sale Id 1295298',800.00,0.00,0.00,0.00,60.00,'2021-12-07 15:23:03','',''),(2196375,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-07 15:23:03','',''),(2196399,'1','139','772',330,'Retail Sale Id 1295318',1280.00,0.00,0.00,0.00,96.00,'2021-12-07 15:24:14','',''),(2196400,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 15:24:14','',''),(2196436,'1','139','772',330,'Retail Sale Id 1295336',4480.00,0.00,0.00,0.00,336.00,'2021-12-07 15:25:48','',''),(2196437,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 15:25:48','',''),(2196512,'1','139','772',330,'Retail Sale Id 1295372',3840.00,0.00,0.00,0.00,288.00,'2021-12-07 15:29:16','',''),(2196513,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:29:16','',''),(2196544,'1','139','772',330,'Retail Sale Id 1295389',2560.00,0.00,0.00,0.00,192.00,'2021-12-07 15:30:52','',''),(2196545,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 15:30:52','',''),(2196570,'1','139','772',330,'Retail Sale Id 1295402',998.40,0.00,0.00,0.00,74.88,'2021-12-07 15:32:06','',''),(2196571,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 15:32:06','',''),(2196604,'1','139','772',330,'Retail Sale Id 1295419',2560.00,0.00,0.00,0.00,192.00,'2021-12-07 15:33:43','',''),(2196605,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 15:33:43','',''),(2196654,'1','139','772',330,'Retail Sale Id 1295446',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 15:36:39','',''),(2196655,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 15:36:39','',''),(2196684,'1','139','772',330,'Retail Sale Id 1295458',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 15:37:43','',''),(2196685,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 15:37:43','',''),(2196730,'1','139','772',330,'Retail Sale Id 1295480',3660.00,0.00,0.00,0.00,108.00,'2021-12-07 15:39:24','',''),(2196731,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:39:24','',''),(2196805,'1','139','772',330,'Retail Sale Id 1295513',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 15:43:02','',''),(2196806,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 15:43:02','',''),(2196831,'1','139','772',330,'Retail Sale Id 1295526',3840.00,0.00,0.00,0.00,288.00,'2021-12-07 15:44:19','',''),(2196832,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:44:19','',''),(2196871,'1','139','772',330,'Retail Sale Id 1295545',1280.00,0.00,0.00,0.00,96.00,'2021-12-07 15:45:59','',''),(2196872,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 15:45:59','',''),(2196923,'1','139','772',330,'Retail Sale Id 1295573',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 15:48:51','',''),(2196924,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:48:51','',''),(2196984,'1','139','772',330,'Retail Sale Id 1295605',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 15:51:40','',''),(2196985,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 15:51:40','',''),(2197042,'1','139','772',330,'Retail Sale Id 1295636',11840.00,0.00,0.00,0.00,888.00,'2021-12-07 15:53:57','',''),(2197043,'1','139','772',330,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-07 15:53:57','',''),(2197054,'1','139','772',330,'Retail Sale Id 1295649',1222.40,0.00,0.00,0.00,91.68,'2021-12-07 15:54:55','',''),(2197055,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.91,0.00,'2021-12-07 15:54:55','',''),(2197084,'1','139','772',330,'Retail Sale Id 1295658',3840.00,0.00,0.00,0.00,288.00,'2021-12-07 15:56:05','',''),(2197085,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:56:05','',''),(2197129,'1','139','772',330,'Retail Sale Id 1295677',1920.00,0.00,0.00,0.00,144.00,'2021-12-07 15:57:56','',''),(2197130,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:57:56','',''),(2197145,'1','139','772',330,'Retail Sale Id 1295688',7680.00,0.00,0.00,0.00,576.00,'2021-12-07 15:58:52','',''),(2197146,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 15:58:52','',''),(2197166,'1','139','772',330,'Retail Sale Id 1295698',998.40,0.00,0.00,0.00,74.88,'2021-12-07 16:00:19','',''),(2197167,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 16:00:19','',''),(2197261,'1','139','772',330,'Retail Sale Id 1295743',8960.00,0.00,0.00,0.00,672.00,'2021-12-07 16:05:03','',''),(2197262,'1','139','772',330,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-07 16:05:03','',''),(2197298,'1','139','772',330,'Retail Sale Id 1295765',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 16:06:05','',''),(2197299,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 16:06:05','',''),(2197312,'1','139','772',330,'Retail Sale Id 1295777',697.60,0.00,0.00,0.00,52.32,'2021-12-07 16:07:03','',''),(2197313,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-07 16:07:03','',''),(2197336,'1','139','772',330,'Retail Sale Id 1295789',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 16:08:21','',''),(2197337,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:08:21','',''),(2197378,'1','139','772',330,'Retail Sale Id 1295803',27450.00,0.00,0.00,0.00,810.00,'2021-12-07 16:10:24','',''),(2197379,'1','139','772',330,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-07 16:10:24','',''),(2197404,'1','139','772',330,'Retail Sale Id 1295821',1600.00,0.00,0.00,0.00,120.00,'2021-12-07 16:11:51','',''),(2197405,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-07 16:11:51','',''),(2197422,'1','139','772',330,'Retail Sale Id 1295831',1280.00,0.00,0.00,0.00,96.00,'2021-12-07 16:12:51','',''),(2197425,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 16:12:51','',''),(2197498,'1','139','772',330,'Retail Sale Id 1295872',4480.00,0.00,0.00,0.00,336.00,'2021-12-07 16:16:11','',''),(2197499,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 16:16:11','',''),(2197530,'1','139','772',330,'Retail Sale Id 1295892',1920.00,0.00,0.00,0.00,144.00,'2021-12-07 16:17:37','',''),(2197531,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:17:37','',''),(2197585,'1','139','772',330,'Retail Sale Id 1295927',3001.20,0.00,0.00,0.00,88.56,'2021-12-07 16:19:41','',''),(2197586,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.92,0.00,'2021-12-07 16:19:41','',''),(2197605,'1','139','772',330,'Retail Sale Id 1295934',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 16:20:46','',''),(2197606,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 16:20:46','',''),(2197633,'1','139','772',330,'Retail Sale Id 1295949',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 16:21:52','',''),(2197634,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:21:52','',''),(2197657,'1','139','772',330,'Retail Sale Id 1295957',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 16:22:53','',''),(2197658,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 16:22:53','',''),(2197689,'1','139','772',330,'Retail Sale Id 1295980',1920.00,0.00,0.00,0.00,144.00,'2021-12-07 16:24:54','',''),(2197690,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:24:54','',''),(2197717,'1','139','772',330,'Retail Sale Id 1295990',4480.00,0.00,0.00,0.00,336.00,'2021-12-07 16:26:39','',''),(2197718,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 16:26:39','',''),(2197755,'1','139','772',330,'Retail Sale Id 1296010',4998.40,0.00,0.00,0.00,374.88,'2021-12-07 16:28:01','',''),(2197756,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-07 16:28:01','',''),(2197803,'1','139','772',330,'Retail Sale Id 1296035',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 16:30:05','',''),(2197804,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 16:30:05','',''),(2197852,'1','139','772',330,'Retail Sale Id 1296061',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 16:32:29','',''),(2197853,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 16:32:29','',''),(2197887,'1','139','772',330,'Retail Sale Id 1296079',1920.00,0.00,0.00,0.00,144.00,'2021-12-07 16:34:17','',''),(2197888,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:34:17','',''),(2197922,'1','139','772',330,'Retail Sale Id 1296098',998.40,0.00,0.00,0.00,74.88,'2021-12-07 16:36:04','',''),(2197923,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 16:36:04','',''),(2198850,'1','139','772',330,'Retail Sale Id 1296580',610000.00,0.00,0.00,0.00,18000.00,'2021-12-07 17:41:33','',''),(2198851,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1000.00,0.00,'2021-12-07 17:41:33','',''),(2198868,'1','139','772',330,'Retail Sale Id 1296586',606000.00,0.00,0.00,0.00,14000.00,'2021-12-07 17:42:51','',''),(2198869,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1000.00,0.00,'2021-12-07 17:42:51','',''),(2198880,'1','139','772',330,'Retail Sale Id 1296591',606000.00,0.00,0.00,0.00,14000.00,'2021-12-07 17:44:46','',''),(2198881,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1000.00,0.00,'2021-12-07 17:44:46','',''),(2198900,'1','139','772',330,'Retail Sale Id 1296595',61000.00,0.00,0.00,0.00,1800.00,'2021-12-07 17:46:15','',''),(2198901,'1','139','772',330,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-07 17:46:15','',''),(2198950,'1','139','772',330,'Retail Sale Id 1296617',152500.00,0.00,0.00,0.00,4500.00,'2021-12-07 17:50:14','',''),(2198951,'1','139','772',330,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-07 17:50:14','',''),(2198964,'1','139','772',330,'Retail Sale Id 1296628',112240.00,0.00,0.00,0.00,3312.00,'2021-12-07 17:51:48','',''),(2198965,'1','139','772',330,'Retail sales',0.00,0.00,0.00,184.00,0.00,'2021-12-07 17:51:48','',''),(2199003,'1','139','772',330,'Return of Retail Sale Id 1296580',0.00,610000.00,1000.00,0.00,-18000.00,'2021-12-07 17:55:12','',''),(2199060,'1','139','772',330,'Retail Sale Id 1296603',152500.00,0.00,0.00,0.00,4500.00,'2021-12-07 18:00:11','',''),(2199061,'1','139','772',330,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-07 18:00:11','',''),(2199063,'1','139','772',330,'Return of Retail Sale Id 1296603',0.00,152500.00,250.00,0.00,-4500.00,'2021-12-07 18:00:24','',''),(2199076,'1','139','772',330,'Retail Sale Id 1296663',61000.00,0.00,0.00,0.00,1800.00,'2021-12-07 18:02:41','',''),(2199077,'1','139','772',330,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-07 18:02:41','',''),(2199842,'1','139','772',330,'Retail Sale Id 1296820',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 06:19:21','',''),(2199843,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 06:19:21','',''),(2199868,'1','139','772',330,'Retail Sale Id 1296835',2502.40,0.00,0.00,0.00,187.68,'2021-12-08 06:22:02','',''),(2199869,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-08 06:22:02','',''),(2199880,'1','139','772',330,'Retail Sale Id 1296838',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 06:23:21','',''),(2199881,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 06:23:21','',''),(2199894,'1','139','772',330,'Retail Sale Id 1296848',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 06:25:05','',''),(2199895,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 06:25:05','',''),(2199980,'1','139','772',330,'Retail Sale Id 1296890',998.40,0.00,0.00,0.00,74.88,'2021-12-08 06:35:07','',''),(2199981,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 06:35:07','',''),(2200109,'1','139','772',330,'Retail Sale Id 1296945',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 06:43:47','',''),(2200110,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 06:43:47','',''),(2200159,'1','139','772',330,'Retail Sale Id 1296962',1920.00,0.00,0.00,0.00,144.00,'2021-12-08 06:45:59','',''),(2200160,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 06:45:59','',''),(2200227,'1','139','772',330,'Retail Sale Id 1296982',1920.00,0.00,0.00,0.00,144.00,'2021-12-08 06:48:24','',''),(2200228,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 06:48:24','',''),(2200413,'1','139','772',330,'Retail Sale Id 1297057',998.40,0.00,0.00,0.00,74.88,'2021-12-08 06:58:54','',''),(2200414,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 06:58:54','',''),(2200553,'1','139','772',330,'Retail Sale Id 1297129',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 07:07:01','',''),(2200554,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 07:07:01','',''),(2200719,'1','139','772',330,'Retail Sale Id 1297207',7040.00,0.00,0.00,0.00,528.00,'2021-12-08 07:18:06','',''),(2200720,'1','139','772',330,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-08 07:18:06','',''),(2200764,'1','139','772',330,'Retail Sale Id 1297224',2560.00,0.00,0.00,0.00,192.00,'2021-12-08 07:19:43','',''),(2200765,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 07:19:43','',''),(2200867,'1','139','772',330,'Retail Sale Id 1297275',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 07:25:18','',''),(2200868,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 07:25:18','',''),(2200889,'1','139','772',330,'Retail Sale Id 1297285',640.00,0.00,0.00,0.00,48.00,'2021-12-08 07:26:35','',''),(2200890,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 07:26:35','',''),(2200975,'1','139','772',330,'Retail Sale Id 1297323',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 07:31:13','',''),(2200976,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 07:31:13','',''),(2201084,'1','139','772',330,'Retail Sale Id 1297368',2240.00,0.00,0.00,0.00,168.00,'2021-12-08 07:36:04','',''),(2201085,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-08 07:36:04','',''),(2201132,'1','139','772',330,'Retail Sale Id 1297389',1401.60,0.00,0.00,0.00,105.12,'2021-12-08 07:38:20','',''),(2201133,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-08 07:38:20','',''),(2201158,'1','139','772',330,'Retail Sale Id 1297404',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 07:40:04','',''),(2201159,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 07:40:04','',''),(2201190,'1','139','772',330,'Retail Sale Id 1297420',8960.00,0.00,0.00,0.00,672.00,'2021-12-08 07:42:01','',''),(2201191,'1','139','772',330,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-08 07:42:01','',''),(2201254,'1','139','772',330,'Retail Sale Id 1297453',8960.00,0.00,0.00,0.00,672.00,'2021-12-08 07:46:38','',''),(2201255,'1','139','772',330,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-08 07:46:38','',''),(2201290,'1','139','772',330,'Retail Sale Id 1297473',2880.00,0.00,0.00,0.00,216.00,'2021-12-08 07:48:51','',''),(2201291,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-08 07:48:51','',''),(2201312,'1','139','772',330,'Retail Sale Id 1297484',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 07:50:10','',''),(2201313,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 07:50:10','',''),(2201355,'1','139','772',330,'Retail Sale Id 1297502',4160.00,0.00,0.00,0.00,312.00,'2021-12-08 07:51:49','',''),(2201356,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-08 07:51:49','',''),(2201466,'1','139','772',330,'Retail Sale Id 1297541',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 07:55:42','',''),(2201467,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 07:55:42','',''),(2201495,'1','139','772',330,'Retail Sale Id 1297555',23040.00,0.00,0.00,0.00,1728.00,'2021-12-08 07:57:28','',''),(2201496,'1','139','772',330,'Retail sales',0.00,0.00,0.00,36.00,0.00,'2021-12-08 07:57:28','',''),(2201539,'1','139','772',330,'Retail Sale Id 1297573',640.00,0.00,0.00,0.00,48.00,'2021-12-08 07:59:28','',''),(2201540,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 07:59:28','',''),(2201575,'1','139','772',330,'Retail Sale Id 1297591',640.00,0.00,0.00,0.00,48.00,'2021-12-08 08:01:40','',''),(2201576,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 08:01:40','',''),(2201605,'1','139','772',330,'Retail Sale Id 1297605',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 08:03:22','',''),(2201606,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 08:03:22','',''),(2201641,'1','139','772',330,'Retail Sale Id 1297621',7625.00,0.00,0.00,0.00,225.00,'2021-12-08 08:04:52','',''),(2201642,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:04:52','',''),(2201669,'1','139','772',330,'Retail Sale Id 1297636',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 08:06:08','',''),(2201670,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 08:06:08','',''),(2201722,'1','139','772',330,'Retail Sale Id 1297664',5760.00,0.00,0.00,0.00,432.00,'2021-12-08 08:10:29','',''),(2201723,'1','139','772',330,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-08 08:10:29','',''),(2201744,'1','139','772',330,'Retail Sale Id 1297675',2240.00,0.00,0.00,0.00,168.00,'2021-12-08 08:12:04','',''),(2201745,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-08 08:12:04','',''),(2201762,'1','139','772',330,'Retail Sale Id 1297686',6400.00,0.00,0.00,0.00,480.00,'2021-12-08 08:13:27','',''),(2201763,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 08:13:27','',''),(2201776,'1','139','772',330,'Retail Sale Id 1297694',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 08:14:38','',''),(2201777,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 08:14:38','',''),(2201829,'1','139','772',330,'Retail Sale Id 1297724',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 08:17:49','',''),(2201830,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 08:17:49','',''),(2201861,'1','139','772',330,'Retail Sale Id 1297738',5120.00,0.00,0.00,0.00,384.00,'2021-12-08 08:19:52','',''),(2201862,'1','139','772',330,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-08 08:19:52','',''),(2201885,'1','139','772',330,'Retail Sale Id 1297748',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 08:21:20','',''),(2201886,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 08:21:20','',''),(2201951,'1','139','772',330,'Retail Sale Id 1297785',640.00,0.00,0.00,0.00,48.00,'2021-12-08 08:25:23','',''),(2201952,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 08:25:23','',''),(2201971,'1','139','772',330,'Retail Sale Id 1297795',800.00,0.00,0.00,0.00,60.00,'2021-12-08 08:26:48','',''),(2201972,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-08 08:26:48','',''),(2201987,'1','139','772',330,'Retail Sale Id 1297802',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 08:27:37','',''),(2201988,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 08:27:37','',''),(2202022,'1','139','772',330,'Retail Sale Id 1297816',2880.00,0.00,0.00,0.00,216.00,'2021-12-08 08:30:00','',''),(2202023,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-08 08:30:00','',''),(2202036,'1','139','772',330,'Retail Sale Id 1297823',697.60,0.00,0.00,0.00,52.32,'2021-12-08 08:31:03','',''),(2202037,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-08 08:31:03','',''),(2202112,'1','139','772',330,'Retail Sale Id 1297859',5120.00,0.00,0.00,0.00,384.00,'2021-12-08 08:35:51','',''),(2202113,'1','139','772',330,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-08 08:35:51','',''),(2202158,'1','139','772',330,'Retail Sale Id 1297880',122000.00,0.00,0.00,0.00,3600.00,'2021-12-08 08:38:41','',''),(2202159,'1','139','772',330,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-08 08:38:41','',''),(2202204,'1','139','772',330,'Retail Sale Id 1297897',2560.00,0.00,0.00,0.00,192.00,'2021-12-08 08:40:28','',''),(2202205,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 08:40:28','',''),(2202256,'1','139','772',330,'Retail Sale Id 1297913',2240.00,0.00,0.00,0.00,168.00,'2021-12-08 08:42:35','',''),(2202257,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-08 08:42:35','',''),(2202320,'1','139','772',330,'Retail Sale Id 1297924',1203.20,0.00,0.00,0.00,90.24,'2021-12-08 08:44:11','',''),(2202321,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-08 08:44:11','',''),(2202342,'1','139','772',330,'Retail Sale Id 1297933',4480.00,0.00,0.00,0.00,336.00,'2021-12-08 08:45:41','',''),(2202343,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 08:45:41','',''),(2202370,'1','139','772',330,'Retail Sale Id 1297946',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 08:46:57','',''),(2202371,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 08:46:57','',''),(2202423,'1','139','772',330,'Retail Sale Id 1297965',4480.00,0.00,0.00,0.00,336.00,'2021-12-08 08:49:32','',''),(2202424,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 08:49:32','',''),(2202546,'1','139','772',330,'Retail Sale Id 1298014',1600.00,0.00,0.00,0.00,120.00,'2021-12-08 08:55:08','',''),(2202547,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-08 08:55:08','',''),(2202572,'1','139','772',330,'Retail Sale Id 1298023',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 08:56:29','',''),(2202573,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 08:56:29','',''),(2202596,'1','139','772',330,'Retail Sale Id 1298034',2560.00,0.00,0.00,0.00,192.00,'2021-12-08 08:57:46','',''),(2202597,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 08:57:46','',''),(2202640,'1','139','772',330,'Retail Sale Id 1298054',640.00,0.00,0.00,0.00,48.00,'2021-12-08 09:01:05','',''),(2202641,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 09:01:05','',''),(2202664,'1','139','772',330,'Retail Sale Id 1298067',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 09:02:49','',''),(2202665,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 09:02:49','',''),(2202698,'1','139','772',330,'Retail Sale Id 1298085',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 09:04:32','',''),(2202699,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 09:04:32','',''),(2202732,'1','139','772',330,'Retail Sale Id 1298103',640.00,0.00,0.00,0.00,48.00,'2021-12-08 09:06:13','',''),(2202733,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 09:06:13','',''),(2202758,'1','139','772',330,'Retail Sale Id 1298123',640.00,0.00,0.00,0.00,48.00,'2021-12-08 09:07:45','',''),(2202759,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 09:07:45','',''),(2202783,'1','139','772',330,'Retail Sale Id 1298139',67100.00,0.00,0.00,0.00,1980.00,'2021-12-08 09:09:49','',''),(2202784,'1','139','772',330,'Retail sales',0.00,0.00,0.00,110.00,0.00,'2021-12-08 09:09:49','',''),(2202821,'1','139','772',330,'Retail Sale Id 1298157',4480.00,0.00,0.00,0.00,336.00,'2021-12-08 09:11:59','',''),(2202822,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 09:11:59','',''),(2202868,'1','139','772',330,'Retail Sale Id 1298174',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 09:14:10','',''),(2202869,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 09:14:10','',''),(2202902,'1','139','772',330,'Retail Sale Id 1298188',1600.00,0.00,0.00,0.00,120.00,'2021-12-08 09:16:17','',''),(2202903,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-08 09:16:17','',''),(2202932,'1','139','772',330,'Retail Sale Id 1298201',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 09:17:43','',''),(2202933,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 09:17:43','',''),(2202952,'1','139','772',330,'Retail Sale Id 1298212',2560.00,0.00,0.00,0.00,192.00,'2021-12-08 09:18:59','',''),(2202953,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 09:18:59','',''),(2202978,'1','139','772',330,'Retail Sale Id 1298224',640.00,0.00,0.00,0.00,48.00,'2021-12-08 09:20:30','',''),(2202979,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 09:20:30','',''),(2202991,'1','139','772',330,'Retail Sale Id 1298231',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 09:21:45','',''),(2202992,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 09:21:45','',''),(2203019,'1','139','772',330,'Retail Sale Id 1298246',7680.00,0.00,0.00,0.00,576.00,'2021-12-08 09:24:01','',''),(2203020,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-08 09:24:01','',''),(2203053,'1','139','772',330,'Retail Sale Id 1298262',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 09:27:37','',''),(2203054,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 09:27:37','',''),(2203147,'1','139','772',330,'Retail Sale Id 1298308',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 09:35:41','',''),(2203148,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 09:35:41','',''),(2203173,'1','139','772',330,'Retail Sale Id 1298319',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 09:37:19','',''),(2203174,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 09:37:19','',''),(2203209,'1','139','772',330,'Retail Sale Id 1298340',640.00,0.00,0.00,0.00,48.00,'2021-12-08 09:40:08','',''),(2203210,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 09:40:08','',''),(2203279,'1','139','772',330,'Retail Sale Id 1298378',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 09:46:41','',''),(2203280,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 09:46:41','',''),(2203308,'1','139','772',330,'Retail Sale Id 1298392',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 09:48:13','',''),(2203309,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 09:48:13','',''),(2203340,'1','139','772',330,'Retail Sale Id 1298398',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 09:49:54','',''),(2203341,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 09:49:54','',''),(2203374,'1','139','772',330,'Retail Sale Id 1298416',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 09:51:40','',''),(2203375,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 09:51:40','',''),(2203390,'1','139','772',330,'Retail Sale Id 1298426',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 09:53:55','',''),(2203391,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 09:53:55','',''),(2203436,'1','139','772',330,'Retail Sale Id 1298448',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 09:57:09','',''),(2203437,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 09:57:09','',''),(2203598,'1','139','772',330,'Retail Sale Id 1298519',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 10:08:58','',''),(2203599,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 10:08:58','',''),(2203700,'1','139','772',330,'Retail Sale Id 1298561',998.40,0.00,0.00,0.00,74.88,'2021-12-08 10:14:30','',''),(2203701,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 10:14:30','',''),(2203879,'1','139','772',330,'Retail Sale Id 1298650',1920.00,0.00,0.00,0.00,144.00,'2021-12-08 10:25:28','',''),(2203880,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:25:28','',''),(2203989,'1','139','772',330,'Retail Sale Id 1298697',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 10:31:54','',''),(2203990,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 10:31:54','',''),(2204025,'1','139','772',330,'Retail Sale Id 1298713',998.40,0.00,0.00,0.00,74.88,'2021-12-08 10:34:03','',''),(2204026,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 10:34:03','',''),(2204119,'1','139','772',330,'Retail Sale Id 1298766',998.40,0.00,0.00,0.00,74.88,'2021-12-08 10:42:05','',''),(2204120,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 10:42:05','',''),(2204139,'1','139','772',330,'Retail Sale Id 1298775',7680.00,0.00,0.00,0.00,576.00,'2021-12-08 10:44:06','',''),(2204140,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-08 10:44:06','',''),(2204156,'1','139','772',330,'Retail Sale Id 1298783',998.40,0.00,0.00,0.00,74.88,'2021-12-08 10:45:58','',''),(2204157,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 10:45:58','',''),(2204298,'1','139','772',330,'Retail Sale Id 1298855',2560.00,0.00,0.00,0.00,192.00,'2021-12-08 10:57:58','',''),(2204299,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 10:57:58','',''),(2204321,'1','139','772',330,'Retail Sale Id 1298866',4480.00,0.00,0.00,0.00,336.00,'2021-12-08 11:00:07','',''),(2204322,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 11:00:07','',''),(2204347,'1','139','772',330,'Retail Sale Id 1298877',2560.00,0.00,0.00,0.00,192.00,'2021-12-08 11:02:15','',''),(2204348,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 11:02:15','',''),(2204366,'1','139','772',330,'Retail Sale Id 1298885',36600.00,0.00,0.00,0.00,1080.00,'2021-12-08 11:03:36','',''),(2204367,'1','139','772',330,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-08 11:03:36','',''),(2204390,'1','139','772',330,'Retail Sale Id 1298901',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 11:05:40','',''),(2204391,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 11:05:40','',''),(2204410,'1','139','772',330,'Retail Sale Id 1298913',2560.00,0.00,0.00,0.00,192.00,'2021-12-08 11:07:20','',''),(2204411,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 11:07:20','',''),(2204460,'1','139','772',330,'Retail Sale Id 1298937',6003.20,0.00,0.00,0.00,450.24,'2021-12-08 11:09:17','',''),(2204461,'1','139','772',330,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-08 11:09:17','',''),(2204496,'1','139','772',330,'Retail Sale Id 1298958',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 11:11:20','',''),(2204497,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 11:11:20','',''),(2204506,'1','139','772',330,'Retail Sale Id 1298963',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 11:12:16','',''),(2204507,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 11:12:16','',''),(2204586,'1','139','772',330,'Retail Sale Id 1299005',6400.00,0.00,0.00,0.00,480.00,'2021-12-08 11:18:32','',''),(2204587,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 11:18:32','',''),(2204598,'1','139','772',330,'Retail Sale Id 1299010',2560.00,0.00,0.00,0.00,192.00,'2021-12-08 11:20:02','',''),(2204599,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 11:20:02','',''),(2204622,'1','139','772',330,'Retail Sale Id 1299021',6400.00,0.00,0.00,0.00,480.00,'2021-12-08 11:21:16','',''),(2204623,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 11:21:16','',''),(2204642,'1','139','772',330,'Retail Sale Id 1299034',697.60,0.00,0.00,0.00,52.32,'2021-12-08 11:22:27','',''),(2204643,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-08 11:22:27','',''),(2204662,'1','139','772',330,'Retail Sale Id 1299042',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 11:23:47','',''),(2204663,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 11:23:47','',''),(2204716,'1','139','772',330,'Retail Sale Id 1299071',33550.00,0.00,0.00,0.00,990.00,'2021-12-08 11:28:01','',''),(2204717,'1','139','772',330,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-08 11:28:01','',''),(2204740,'1','139','772',330,'Retail Sale Id 1299081',998.40,0.00,0.00,0.00,74.88,'2021-12-08 11:30:02','',''),(2204741,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 11:30:02','',''),(2204758,'1','139','772',330,'Retail Sale Id 1299092',2880.00,0.00,0.00,0.00,216.00,'2021-12-08 11:31:36','',''),(2204759,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-08 11:31:36','',''),(2204798,'1','139','772',330,'Retail Sale Id 1299115',6400.00,0.00,0.00,0.00,480.00,'2021-12-08 11:34:12','',''),(2204799,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 11:34:12','',''),(2204832,'1','139','772',330,'Retail Sale Id 1299128',3520.00,0.00,0.00,0.00,264.00,'2021-12-08 11:35:44','',''),(2204833,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-08 11:35:44','',''),(2204860,'1','139','772',330,'Retail Sale Id 1299143',1600.00,0.00,0.00,0.00,120.00,'2021-12-08 11:37:39','',''),(2204861,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-08 11:37:39','',''),(2204904,'1','139','772',330,'Retail Sale Id 1299166',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 11:39:22','',''),(2204905,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 11:39:22','',''),(2204938,'1','139','772',330,'Retail Sale Id 1299188',998.40,0.00,0.00,0.00,74.88,'2021-12-08 11:41:16','',''),(2204939,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 11:41:16','',''),(2204986,'1','139','772',330,'Retail Sale Id 1299210',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 11:43:44','',''),(2204987,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:43:44','',''),(2205066,'1','139','772',330,'Retail Sale Id 1299246',800.00,0.00,0.00,0.00,60.00,'2021-12-08 11:50:08','',''),(2205067,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-08 11:50:08','',''),(2205072,'1','139','772',330,'Retail Sale Id 1299249',697.60,0.00,0.00,0.00,52.32,'2021-12-08 11:51:00','',''),(2205073,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-08 11:51:00','',''),(2205082,'1','139','772',330,'Retail Sale Id 1299254',998.40,0.00,0.00,0.00,74.88,'2021-12-08 11:51:46','',''),(2205083,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 11:51:46','',''),(2205102,'1','139','772',330,'Retail Sale Id 1299266',7040.00,0.00,0.00,0.00,528.00,'2021-12-08 11:53:00','',''),(2205103,'1','139','772',330,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-08 11:53:00','',''),(2205114,'1','139','772',330,'Retail Sale Id 1299271',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 11:53:49','',''),(2205115,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 11:53:49','',''),(2205128,'1','139','772',330,'Retail Sale Id 1299277',998.40,0.00,0.00,0.00,74.88,'2021-12-08 11:54:46','',''),(2205129,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 11:54:46','',''),(2205136,'1','139','772',330,'Retail Sale Id 1299282',998.40,0.00,0.00,0.00,74.88,'2021-12-08 11:55:36','',''),(2205137,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 11:55:36','',''),(2205148,'1','139','772',330,'Retail Sale Id 1299288',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 11:56:37','',''),(2205149,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 11:56:37','',''),(2205158,'1','139','772',330,'Retail Sale Id 1299293',998.40,0.00,0.00,0.00,74.88,'2021-12-08 11:57:54','',''),(2205159,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 11:57:54','',''),(2205186,'1','139','772',330,'Retail Sale Id 1299307',800.00,0.00,0.00,0.00,60.00,'2021-12-08 11:59:49','',''),(2205187,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-08 11:59:49','',''),(2205204,'1','139','772',330,'Retail Sale Id 1299318',7680.00,0.00,0.00,0.00,576.00,'2021-12-08 12:01:00','',''),(2205205,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-08 12:01:00','',''),(2205226,'1','139','772',330,'Retail Sale Id 1299328',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 12:02:22','',''),(2205227,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:02:22','',''),(2205249,'1','139','772',330,'Retail Sale Id 1299331',2560.00,0.00,0.00,0.00,192.00,'2021-12-08 12:03:20','',''),(2205250,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 12:03:20','',''),(2205275,'1','139','772',330,'Retail Sale Id 1299338',2560.00,0.00,0.00,0.00,192.00,'2021-12-08 12:05:14','',''),(2205276,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 12:05:14','',''),(2205301,'1','139','772',330,'Retail Sale Id 1299352',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 12:08:15','',''),(2205302,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:08:15','',''),(2205349,'1','139','772',330,'Retail Sale Id 1299372',7625.00,0.00,0.00,0.00,225.00,'2021-12-08 12:11:18','',''),(2205350,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:11:18','',''),(2205371,'1','139','772',330,'Retail Sale Id 1299383',2598.40,0.00,0.00,0.00,194.88,'2021-12-08 12:13:01','',''),(2205372,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-08 12:13:01','',''),(2205387,'1','139','772',330,'Retail Sale Id 1299389',1920.00,0.00,0.00,0.00,144.00,'2021-12-08 12:14:23','',''),(2205388,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 12:14:23','',''),(2205397,'1','139','772',330,'Retail Sale Id 1299395',998.40,0.00,0.00,0.00,74.88,'2021-12-08 12:15:19','',''),(2205398,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 12:15:19','',''),(2205457,'1','139','772',330,'Retail Sale Id 1299421',2560.00,0.00,0.00,0.00,192.00,'2021-12-08 12:19:53','',''),(2205458,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 12:19:53','',''),(2205471,'1','139','772',330,'Retail Sale Id 1299429',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 12:21:15','',''),(2205472,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 12:21:15','',''),(2205489,'1','139','772',330,'Retail Sale Id 1299439',998.40,0.00,0.00,0.00,74.88,'2021-12-08 12:23:13','',''),(2205490,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 12:23:13','',''),(2205499,'1','139','772',330,'Retail Sale Id 1299444',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 12:24:13','',''),(2205500,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:24:13','',''),(2205530,'1','139','772',330,'Retail Sale Id 1299458',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 12:25:53','',''),(2205531,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 12:25:53','',''),(2205552,'1','139','772',330,'Retail Sale Id 1299473',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 12:28:56','',''),(2205553,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 12:28:56','',''),(2205600,'1','139','772',330,'Retail Sale Id 1299494',998.40,0.00,0.00,0.00,74.88,'2021-12-08 12:32:19','',''),(2205601,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 12:32:19','',''),(2205632,'1','139','772',330,'Retail Sale Id 1299507',7040.00,0.00,0.00,0.00,528.00,'2021-12-08 12:34:32','',''),(2205633,'1','139','772',330,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-08 12:34:32','',''),(2205664,'1','139','772',330,'Retail Sale Id 1299525',2560.00,0.00,0.00,0.00,192.00,'2021-12-08 12:36:48','',''),(2205665,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 12:36:48','',''),(2205682,'1','139','772',330,'Retail Sale Id 1299532',640.00,0.00,0.00,0.00,48.00,'2021-12-08 12:37:57','',''),(2205683,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 12:37:57','',''),(2205709,'1','139','772',330,'Retail Sale Id 1299546',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 12:39:36','',''),(2205710,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 12:39:36','',''),(2205726,'1','139','772',330,'Retail Sale Id 1299553',998.40,0.00,0.00,0.00,74.88,'2021-12-08 12:40:49','',''),(2205727,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 12:40:49','',''),(2205864,'1','139','772',330,'Retail Sale Id 1299613',4480.00,0.00,0.00,0.00,336.00,'2021-12-08 12:48:55','',''),(2205865,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 12:48:55','',''),(2205923,'1','139','772',330,'Retail Sale Id 1299633',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 12:50:38','',''),(2205924,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 12:50:38','',''),(2205977,'1','139','772',330,'Retail Sale Id 1299655',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 12:55:13','',''),(2205978,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 12:55:13','',''),(2206050,'1','139','772',330,'Retail Sale Id 1299685',998.40,0.00,0.00,0.00,74.88,'2021-12-08 13:00:57','',''),(2206051,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 13:00:57','',''),(2206175,'1','139','772',330,'Retail Sale Id 1299748',998.40,0.00,0.00,0.00,74.88,'2021-12-08 13:09:55','',''),(2206176,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 13:09:55','',''),(2206195,'1','139','772',330,'Retail Sale Id 1299755',4160.00,0.00,0.00,0.00,312.00,'2021-12-08 13:10:54','',''),(2206196,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-08 13:10:54','',''),(2206223,'1','139','772',330,'Retail Sale Id 1299768',998.40,0.00,0.00,0.00,74.88,'2021-12-08 13:12:51','',''),(2206224,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 13:12:51','',''),(2206237,'1','139','772',330,'Retail Sale Id 1299776',6502.40,0.00,0.00,0.00,487.68,'2021-12-08 13:13:56','',''),(2206238,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-08 13:13:56','',''),(2206271,'1','139','772',330,'Retail Sale Id 1299791',30500.00,0.00,0.00,0.00,900.00,'2021-12-08 13:15:11','',''),(2206272,'1','139','772',330,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 13:15:11','',''),(2206327,'1','139','772',330,'Retail Sale Id 1299816',2560.00,0.00,0.00,0.00,192.00,'2021-12-08 13:18:59','',''),(2206328,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 13:18:59','',''),(2206355,'1','139','772',330,'Retail Sale Id 1299834',998.40,0.00,0.00,0.00,74.88,'2021-12-08 13:21:33','',''),(2206356,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 13:21:33','',''),(2206379,'1','139','772',330,'Retail Sale Id 1299847',640.00,0.00,0.00,0.00,48.00,'2021-12-08 13:23:50','',''),(2206380,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 13:23:50','',''),(2206391,'1','139','772',330,'Retail Sale Id 1299854',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 13:24:55','',''),(2206392,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 13:24:55','',''),(2206475,'1','139','772',330,'Retail Sale Id 1299836',998.40,0.00,0.00,0.00,74.88,'2021-12-08 13:29:46','',''),(2206476,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 13:29:46','',''),(2206527,'1','139','772',330,'Retail Sale Id 1299905',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 13:31:50','',''),(2206528,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:31:50','',''),(2206578,'1','139','772',330,'Retail Sale Id 1299924',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 13:34:46','',''),(2206579,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:34:46','',''),(2206590,'1','139','772',330,'Retail Sale Id 1299934',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 13:35:49','',''),(2206592,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:35:49','',''),(2206612,'1','139','772',330,'Retail Sale Id 1299945',27450.00,0.00,0.00,0.00,810.00,'2021-12-08 13:37:48','',''),(2206613,'1','139','772',330,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-08 13:37:48','',''),(2206653,'1','139','772',330,'Retail Sale Id 1299959',1600.00,0.00,0.00,0.00,120.00,'2021-12-08 13:39:36','',''),(2206654,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-08 13:39:36','',''),(2206672,'1','139','772',330,'Retail Sale Id 1299969',3603.20,0.00,0.00,0.00,270.24,'2021-12-08 13:40:58','',''),(2206673,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.63,0.00,'2021-12-08 13:40:58','',''),(2206698,'1','139','772',330,'Retail Sale Id 1299974',3603.20,0.00,0.00,0.00,270.24,'2021-12-08 13:41:52','',''),(2206699,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.63,0.00,'2021-12-08 13:41:52','',''),(2206763,'1','139','772',330,'Retail Sale Id 1300000',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 13:44:31','',''),(2206764,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:44:31','',''),(2206797,'1','139','772',330,'Retail Sale Id 1300012',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 13:45:57','',''),(2206798,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 13:45:57','',''),(2206805,'1','139','772',330,'Retail Sale Id 1300016',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 13:46:48','',''),(2206806,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 13:46:48','',''),(2206828,'1','139','772',330,'Retail Sale Id 1300024',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 13:47:53','',''),(2206829,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 13:47:53','',''),(2206856,'1','139','772',330,'Retail Sale Id 1300032',640.00,0.00,0.00,0.00,48.00,'2021-12-08 13:49:31','',''),(2206857,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 13:49:31','',''),(2206864,'1','139','772',330,'Retail Sale Id 1300037',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 13:50:33','',''),(2206865,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 13:50:33','',''),(2206886,'1','139','772',330,'Retail Sale Id 1300048',998.40,0.00,0.00,0.00,74.88,'2021-12-08 13:51:53','',''),(2206887,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 13:51:53','',''),(2206963,'1','139','772',330,'Retail Sale Id 1300076',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 13:55:44','',''),(2206964,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 13:55:44','',''),(2206999,'1','139','772',330,'Retail Sale Id 1300093',640.00,0.00,0.00,0.00,48.00,'2021-12-08 13:58:11','',''),(2207000,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 13:58:11','',''),(2207061,'1','139','772',330,'Retail Sale Id 1300117',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 14:02:53','',''),(2207062,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 14:02:53','',''),(2207090,'1','139','772',330,'Retail Sale Id 1300132',4480.00,0.00,0.00,0.00,336.00,'2021-12-08 14:04:24','',''),(2207091,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 14:04:24','',''),(2207113,'1','139','772',330,'Retail Sale Id 1300141',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 14:06:26','',''),(2207114,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 14:06:26','',''),(2207129,'1','139','772',330,'Retail Sale Id 1300152',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 14:07:43','',''),(2207130,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 14:07:43','',''),(2207158,'1','139','772',330,'Retail Sale Id 1300161',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 14:09:02','',''),(2207159,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 14:09:02','',''),(2207210,'1','139','772',330,'Retail Sale Id 1300182',6400.00,0.00,0.00,0.00,480.00,'2021-12-08 14:12:11','',''),(2207211,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 14:12:11','',''),(2207227,'1','139','772',330,'Retail Sale Id 1300190',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 14:13:56','',''),(2207228,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 14:13:56','',''),(2207243,'1','139','772',330,'Retail Sale Id 1300201',998.40,0.00,0.00,0.00,74.88,'2021-12-08 14:15:08','',''),(2207244,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 14:15:08','',''),(2207271,'1','139','772',330,'Retail Sale Id 1300213',697.60,0.00,0.00,0.00,52.32,'2021-12-08 14:16:29','',''),(2207272,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-08 14:16:29','',''),(2207299,'1','139','772',330,'Retail Sale Id 1300229',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 14:17:48','',''),(2207300,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 14:17:48','',''),(2207321,'1','139','772',330,'Retail Sale Id 1300241',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 14:19:27','',''),(2207322,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 14:19:27','',''),(2207349,'1','139','772',330,'Retail Sale Id 1300267',998.40,0.00,0.00,0.00,74.88,'2021-12-08 14:20:48','',''),(2207350,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 14:20:48','',''),(2207369,'1','139','772',330,'Retail Sale Id 1300275',1920.00,0.00,0.00,0.00,144.00,'2021-12-08 14:22:01','',''),(2207370,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:22:01','',''),(2207397,'1','139','772',330,'Retail Sale Id 1300292',640.00,0.00,0.00,0.00,48.00,'2021-12-08 14:24:05','',''),(2207398,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 14:24:05','',''),(2207433,'1','139','772',330,'Retail Sale Id 1300303',4160.00,0.00,0.00,0.00,312.00,'2021-12-08 14:25:34','',''),(2207434,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-08 14:25:34','',''),(2207462,'1','139','772',330,'Retail Sale Id 1300317',4160.00,0.00,0.00,0.00,312.00,'2021-12-08 14:26:59','',''),(2207463,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-08 14:26:59','',''),(2207504,'1','139','772',330,'Retail Sale Id 1300335',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 14:28:59','',''),(2207505,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 14:28:59','',''),(2207537,'1','139','772',330,'Retail Sale Id 1300349',998.40,0.00,0.00,0.00,74.88,'2021-12-08 14:30:15','',''),(2207538,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 14:30:15','',''),(2207634,'1','139','772',330,'Retail Sale Id 1300383',1920.00,0.00,0.00,0.00,144.00,'2021-12-08 14:33:42','',''),(2207635,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:33:42','',''),(2207649,'1','139','772',330,'Retail Sale Id 1300390',1920.00,0.00,0.00,0.00,144.00,'2021-12-08 14:34:32','',''),(2207650,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:34:32','',''),(2207674,'1','139','772',330,'Retail Sale Id 1300398',2560.00,0.00,0.00,0.00,192.00,'2021-12-08 14:35:33','',''),(2207675,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 14:35:33','',''),(2207696,'1','139','772',330,'Retail Sale Id 1300412',1920.00,0.00,0.00,0.00,144.00,'2021-12-08 14:36:37','',''),(2207697,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:36:37','',''),(2207712,'1','139','772',330,'Retail Sale Id 1300420',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 14:37:33','',''),(2207713,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 14:37:33','',''),(2207724,'1','139','772',330,'Retail Sale Id 1300427',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 14:38:27','',''),(2207725,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 14:38:27','',''),(2207738,'1','139','772',330,'Retail Sale Id 1300435',8960.00,0.00,0.00,0.00,672.00,'2021-12-08 14:39:16','',''),(2207739,'1','139','772',330,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-08 14:39:16','',''),(2207758,'1','139','772',330,'Retail Sale Id 1300444',1600.00,0.00,0.00,0.00,120.00,'2021-12-08 14:40:37','',''),(2207759,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-08 14:40:37','',''),(2207820,'1','139','772',330,'Retail Sale Id 1300478',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 14:43:40','',''),(2207821,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 14:43:40','',''),(2207841,'1','139','772',330,'Retail Sale Id 1300491',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 14:45:12','',''),(2207842,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 14:45:12','',''),(2207863,'1','139','772',330,'Retail Sale Id 1300503',1920.00,0.00,0.00,0.00,144.00,'2021-12-08 14:46:40','',''),(2207864,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:46:40','',''),(2207887,'1','139','772',330,'Retail Sale Id 1300520',1920.00,0.00,0.00,0.00,144.00,'2021-12-08 14:47:50','',''),(2207888,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:47:50','',''),(2207905,'1','139','772',330,'Retail Sale Id 1300529',1600.00,0.00,0.00,0.00,120.00,'2021-12-08 14:48:56','',''),(2207906,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-08 14:48:56','',''),(2207933,'1','139','772',330,'Retail Sale Id 1300543',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 14:50:33','',''),(2207934,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 14:50:33','',''),(2207957,'1','139','772',330,'Retail Sale Id 1300555',2240.00,0.00,0.00,0.00,168.00,'2021-12-08 14:52:01','',''),(2207958,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-08 14:52:01','',''),(2207989,'1','139','772',330,'Retail Sale Id 1300570',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 14:54:02','',''),(2207990,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 14:54:02','',''),(2208037,'1','139','772',330,'Retail Sale Id 1300588',1100.80,0.00,0.00,0.00,82.56,'2021-12-08 14:57:24','',''),(2208038,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.72,0.00,'2021-12-08 14:57:24','',''),(2208065,'1','139','772',330,'Retail Sale Id 1300604',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 15:00:13','',''),(2208066,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:00:13','',''),(2208085,'1','139','772',330,'Retail Sale Id 1300614',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 15:01:48','',''),(2208086,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 15:01:48','',''),(2208104,'1','139','772',330,'Retail Sale Id 1300623',4160.00,0.00,0.00,0.00,312.00,'2021-12-08 15:03:12','',''),(2208105,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-08 15:03:12','',''),(2208132,'1','139','772',330,'Retail Sale Id 1300633',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 15:04:53','',''),(2208133,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 15:04:53','',''),(2208152,'1','139','772',330,'Retail Sale Id 1300642',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 15:06:34','',''),(2208153,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 15:06:34','',''),(2208187,'1','139','772',330,'Retail Sale Id 1300652',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 15:08:06','',''),(2208188,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:08:06','',''),(2208215,'1','139','772',330,'Retail Sale Id 1300664',902.40,0.00,0.00,0.00,67.68,'2021-12-08 15:10:03','',''),(2208216,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-08 15:10:03','',''),(2208267,'1','139','772',330,'Retail Sale Id 1300686',1299.20,0.00,0.00,0.00,97.44,'2021-12-08 15:12:20','',''),(2208268,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-08 15:12:20','',''),(2208293,'1','139','772',330,'Retail Sale Id 1300702',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 15:13:54','',''),(2208294,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 15:13:54','',''),(2208317,'1','139','772',330,'Retail Sale Id 1300716',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 15:15:11','',''),(2208318,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 15:15:11','',''),(2208363,'1','139','772',330,'Retail Sale Id 1300737',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 15:17:59','',''),(2208364,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:17:59','',''),(2208403,'1','139','772',330,'Retail Sale Id 1300754',640.00,0.00,0.00,0.00,48.00,'2021-12-08 15:19:35','',''),(2208404,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 15:19:35','',''),(2208429,'1','139','772',330,'Retail Sale Id 1300764',1798.40,0.00,0.00,0.00,134.88,'2021-12-08 15:20:50','',''),(2208430,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-08 15:20:50','',''),(2208476,'1','139','772',330,'Retail Sale Id 1300787',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 15:23:18','',''),(2208477,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:23:18','',''),(2208512,'1','139','772',330,'Retail Sale Id 1300806',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 15:25:24','',''),(2208513,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:25:24','',''),(2208552,'1','139','772',330,'Retail Sale Id 1300825',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 15:27:02','',''),(2208553,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:27:02','',''),(2208635,'1','139','772',330,'Retail Sale Id 1300866',640.00,0.00,0.00,0.00,48.00,'2021-12-08 15:31:47','',''),(2208636,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 15:31:47','',''),(2208707,'1','139','772',330,'Retail Sale Id 1300910',1600.00,0.00,0.00,0.00,120.00,'2021-12-08 15:35:12','',''),(2208708,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-08 15:35:12','',''),(2208745,'1','139','772',330,'Retail Sale Id 1300927',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 15:36:47','',''),(2208746,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 15:36:47','',''),(2208771,'1','139','772',330,'Retail Sale Id 1300942',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 15:38:12','',''),(2208772,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:38:12','',''),(2208801,'1','139','772',330,'Retail Sale Id 1300958',73200.00,0.00,0.00,0.00,2160.00,'2021-12-08 15:39:42','',''),(2208802,'1','139','772',330,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-08 15:39:42','',''),(2208829,'1','139','772',330,'Retail Sale Id 1300974',640.00,0.00,0.00,0.00,48.00,'2021-12-08 15:41:13','',''),(2208830,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 15:41:13','',''),(2208855,'1','139','772',330,'Retail Sale Id 1300987',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 15:42:29','',''),(2208856,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 15:42:29','',''),(2208891,'1','139','772',330,'Retail Sale Id 1301002',15360.00,0.00,0.00,0.00,1152.00,'2021-12-08 15:44:06','',''),(2208892,'1','139','772',330,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-08 15:44:06','',''),(2208909,'1','139','772',330,'Retail Sale Id 1301017',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 15:45:24','',''),(2208910,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 15:45:24','',''),(2208925,'1','139','772',330,'Retail Sale Id 1301025',8320.00,0.00,0.00,0.00,624.00,'2021-12-08 15:46:26','',''),(2208926,'1','139','772',330,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-08 15:46:26','',''),(2208951,'1','139','772',330,'Retail Sale Id 1301038',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 15:47:34','',''),(2208952,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 15:47:34','',''),(2208965,'1','139','772',330,'Retail Sale Id 1301044',3660.00,0.00,0.00,0.00,108.00,'2021-12-08 15:48:30','',''),(2208966,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:48:30','',''),(2208991,'1','139','772',330,'Retail Sale Id 1301056',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 15:50:12','',''),(2208992,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:50:12','',''),(2209019,'1','139','772',330,'Retail Sale Id 1301065',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 15:52:02','',''),(2209020,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 15:52:02','',''),(2209065,'1','139','772',330,'Retail Sale Id 1301081',6502.40,0.00,0.00,0.00,487.68,'2021-12-08 15:53:48','',''),(2209066,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-08 15:53:48','',''),(2209079,'1','139','772',330,'Retail Sale Id 1301090',6003.20,0.00,0.00,0.00,450.24,'2021-12-08 15:54:59','',''),(2209080,'1','139','772',330,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-08 15:54:59','',''),(2209105,'1','139','772',330,'Retail Sale Id 1301109',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 15:57:00','',''),(2209106,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:57:00','',''),(2209153,'1','139','772',330,'Retail Sale Id 1301130',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 15:59:23','',''),(2209154,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 15:59:23','',''),(2209195,'1','139','772',330,'Retail Sale Id 1301150',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 16:00:56','',''),(2209196,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 16:00:56','',''),(2209239,'1','139','772',330,'Retail Sale Id 1301177',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 16:03:03','',''),(2209240,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:03:03','',''),(2209281,'1','139','772',330,'Retail Sale Id 1301196',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 16:04:54','',''),(2209282,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 16:04:54','',''),(2209295,'1','139','772',330,'Retail Sale Id 1301205',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 16:05:49','',''),(2209296,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:05:49','',''),(2209345,'1','139','772',330,'Retail Sale Id 1301223',34160.00,0.00,0.00,0.00,1008.00,'2021-12-08 16:08:16','',''),(2209346,'1','139','772',330,'Retail sales',0.00,0.00,0.00,56.00,0.00,'2021-12-08 16:08:16','',''),(2209373,'1','139','772',330,'Retail Sale Id 1301237',2700.80,0.00,0.00,0.00,202.56,'2021-12-08 16:09:07','',''),(2209374,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.22,0.00,'2021-12-08 16:09:07','',''),(2209404,'1','139','772',330,'Retail Sale Id 1301245',4160.00,0.00,0.00,0.00,312.00,'2021-12-08 16:10:27','',''),(2209405,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-08 16:10:27','',''),(2209458,'1','139','772',330,'Retail Sale Id 1301276',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 16:12:08','',''),(2209459,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 16:12:08','',''),(2209500,'1','139','772',330,'Retail Sale Id 1301300',6400.00,0.00,0.00,0.00,480.00,'2021-12-08 16:14:19','',''),(2209501,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 16:14:19','',''),(2209528,'1','139','772',330,'Retail Sale Id 1301308',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 16:15:09','',''),(2209529,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 16:15:09','',''),(2209538,'1','139','772',330,'Retail Sale Id 1301315',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 16:15:56','',''),(2209539,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 16:15:56','',''),(2209584,'1','139','772',330,'Retail Sale Id 1301328',2297.60,0.00,0.00,0.00,172.32,'2021-12-08 16:16:44','',''),(2209585,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.59,0.00,'2021-12-08 16:16:44','',''),(2209604,'1','139','772',330,'Retail Sale Id 1301337',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 16:17:25','',''),(2209605,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 16:17:25','',''),(2209614,'1','139','772',330,'Retail Sale Id 1301341',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 16:18:14','',''),(2209615,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 16:18:14','',''),(2209636,'1','139','772',330,'Retail Sale Id 1301350',998.40,0.00,0.00,0.00,74.88,'2021-12-08 16:19:02','',''),(2209637,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 16:19:02','',''),(2209672,'1','139','772',330,'Retail Sale Id 1301362',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 16:20:44','',''),(2209673,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:20:44','',''),(2209688,'1','139','772',330,'Retail Sale Id 1301378',2880.00,0.00,0.00,0.00,216.00,'2021-12-08 16:21:46','',''),(2209689,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-08 16:21:46','',''),(2209702,'1','139','772',330,'Retail Sale Id 1301388',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 16:22:43','',''),(2209703,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:22:43','',''),(2209749,'1','139','772',330,'Retail Sale Id 1301406',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 16:24:42','',''),(2209750,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:24:42','',''),(2209823,'1','139','772',330,'Retail Sale Id 1301569',2880.00,0.00,0.00,0.00,216.00,'2021-12-08 16:29:57','',''),(2209824,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-08 16:29:57','',''),(2209845,'1','139','772',330,'Retail Sale Id 1301576',4480.00,0.00,0.00,0.00,336.00,'2021-12-08 16:30:47','',''),(2209846,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 16:30:47','',''),(2209861,'1','139','772',330,'Retail Sale Id 1301583',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 16:31:36','',''),(2209862,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:31:36','',''),(2209883,'1','139','772',330,'Retail Sale Id 1301594',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 16:32:46','',''),(2209884,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:32:46','',''),(2209903,'1','139','772',330,'Retail Sale Id 1301603',8320.00,0.00,0.00,0.00,624.00,'2021-12-08 16:33:40','',''),(2209904,'1','139','772',330,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-08 16:33:40','',''),(2209925,'1','139','772',330,'Retail Sale Id 1301611',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 16:34:39','',''),(2209926,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:34:39','',''),(2209963,'1','139','772',330,'Retail Sale Id 1301631',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 16:36:09','',''),(2209964,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:36:09','',''),(2209983,'1','139','772',330,'Retail Sale Id 1301641',2240.00,0.00,0.00,0.00,168.00,'2021-12-08 16:37:12','',''),(2209984,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-08 16:37:12','',''),(2209995,'1','139','772',330,'Retail Sale Id 1301649',1920.00,0.00,0.00,0.00,144.00,'2021-12-08 16:37:57','',''),(2209996,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:37:57','',''),(2210015,'1','139','772',330,'Retail Sale Id 1301658',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 16:38:45','',''),(2210016,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:38:45','',''),(2210033,'1','139','772',330,'Retail Sale Id 1301666',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 16:39:33','',''),(2210034,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 16:39:33','',''),(2210055,'1','139','772',330,'Retail Sale Id 1301677',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 16:40:17','',''),(2210056,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:40:17','',''),(2210075,'1','139','772',330,'Retail Sale Id 1301686',4998.40,0.00,0.00,0.00,374.88,'2021-12-08 16:41:09','',''),(2210076,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-08 16:41:09','',''),(2210099,'1','139','772',330,'Retail Sale Id 1301701',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 16:42:24','',''),(2210100,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:42:24','',''),(2210113,'1','139','772',330,'Retail Sale Id 1301708',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 16:43:08','',''),(2210114,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:43:08','',''),(2210145,'1','139','772',330,'Retail Sale Id 1301725',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 16:44:44','',''),(2210146,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:44:44','',''),(2210167,'1','139','772',330,'Retail Sale Id 1301735',1280.00,0.00,0.00,0.00,96.00,'2021-12-08 16:45:46','',''),(2210168,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 16:45:46','',''),(2210189,'1','139','772',330,'Retail Sale Id 1301746',8320.00,0.00,0.00,0.00,624.00,'2021-12-08 16:47:11','',''),(2210190,'1','139','772',330,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-08 16:47:11','',''),(2210233,'1','139','772',330,'Retail Sale Id 1301768',2502.40,0.00,0.00,0.00,187.68,'2021-12-08 16:49:16','',''),(2210234,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-08 16:49:16','',''),(2210263,'1','139','772',330,'Retail Sale Id 1301785',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 16:50:53','',''),(2210264,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 16:50:53','',''),(2210308,'1','139','772',330,'Retail Sale Id 1301807',1920.00,0.00,0.00,0.00,144.00,'2021-12-08 16:53:44','',''),(2210309,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:53:44','',''),(2210356,'1','139','772',330,'Retail Sale Id 1301831',640.00,0.00,0.00,0.00,48.00,'2021-12-08 16:56:30','',''),(2210357,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 16:56:30','',''),(2210394,'1','139','772',330,'Retail Sale Id 1301857',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 16:59:23','',''),(2210395,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:59:23','',''),(2210416,'1','139','772',330,'Retail Sale Id 1301867',2502.40,0.00,0.00,0.00,187.68,'2021-12-08 17:00:47','',''),(2210417,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-08 17:00:47','',''),(2210442,'1','139','772',330,'Retail Sale Id 1301880',902.40,0.00,0.00,0.00,67.68,'2021-12-08 17:02:31','',''),(2210443,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-08 17:02:31','',''),(2210466,'1','139','772',330,'Retail Sale Id 1301893',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 17:05:05','',''),(2210467,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 17:05:05','',''),(2210493,'1','139','772',330,'Retail Sale Id 1301909',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 17:07:35','',''),(2210494,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 17:07:35','',''),(2210509,'1','139','772',330,'Retail Sale Id 1301921',1920.00,0.00,0.00,0.00,144.00,'2021-12-08 17:09:23','',''),(2210510,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 17:09:23','',''),(2210529,'1','139','772',330,'Retail Sale Id 1301930',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 17:11:05','',''),(2210530,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 17:11:05','',''),(2210559,'1','139','772',330,'Retail Sale Id 1301947',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 17:13:13','',''),(2210560,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 17:13:13','',''),(2210571,'1','139','772',330,'Retail Sale Id 1301954',1920.00,0.00,0.00,0.00,144.00,'2021-12-08 17:14:24','',''),(2210572,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 17:14:24','',''),(2210597,'1','139','772',330,'Retail Sale Id 1301969',800.00,0.00,0.00,0.00,60.00,'2021-12-08 17:16:51','',''),(2210598,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-08 17:16:51','',''),(2210613,'1','139','772',330,'Retail Sale Id 1301983',998.40,0.00,0.00,0.00,74.88,'2021-12-08 17:18:33','',''),(2210614,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 17:18:33','',''),(2210686,'1','139','772',330,'Retail Sale Id 1302024',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 17:27:28','',''),(2210687,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 17:27:28','',''),(2210706,'1','139','772',330,'Retail Sale Id 1302034',998.40,0.00,0.00,0.00,74.88,'2021-12-08 17:28:39','',''),(2210707,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 17:28:39','',''),(2210720,'1','139','772',330,'Retail Sale Id 1302040',697.60,0.00,0.00,0.00,52.32,'2021-12-08 17:29:47','',''),(2210721,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-08 17:29:47','',''),(2210761,'1','139','772',330,'Retail Sale Id 1302062',909000.00,0.00,0.00,0.00,21000.00,'2021-12-08 17:34:57','',''),(2210762,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1500.00,0.00,'2021-12-08 17:34:57','',''),(2210797,'1','139','772',330,'Retail Sale Id 1302080',909000.00,0.00,0.00,0.00,21000.00,'2021-12-08 17:39:01','',''),(2210798,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1500.00,0.00,'2021-12-08 17:39:01','',''),(2210807,'1','139','772',330,'Retail Sale Id 1302089',152500.00,0.00,0.00,0.00,4500.00,'2021-12-08 17:40:30','',''),(2210808,'1','139','772',330,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-08 17:40:30','',''),(2210829,'1','139','772',330,'Retail Sale Id 1302097',91500.00,0.00,0.00,0.00,2700.00,'2021-12-08 17:42:00','',''),(2210830,'1','139','772',330,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-08 17:42:00','',''),(2210836,'1','139','772',330,'Retail Sale Id 1302101',244000.00,0.00,0.00,0.00,7200.00,'2021-12-08 17:43:28','',''),(2210837,'1','139','772',330,'Retail sales',0.00,0.00,0.00,400.00,0.00,'2021-12-08 17:43:28','',''),(2210900,'1','139','772',330,'Retail Sale Id 1302113',96380.00,0.00,0.00,0.00,2844.00,'2021-12-08 17:47:47','',''),(2210901,'1','139','772',330,'Retail sales',0.00,0.00,0.00,158.00,0.00,'2021-12-08 17:47:47','',''),(2212004,'1','139','772',330,'Retail Sale Id 1302377',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 06:11:51','',''),(2212005,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 06:11:51','',''),(2212048,'1','139','772',330,'Retail Sale Id 1302398',3840.00,0.00,0.00,0.00,288.00,'2021-12-09 06:15:07','',''),(2212049,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 06:15:07','',''),(2212060,'1','139','772',330,'Retail Sale Id 1302403',4998.40,0.00,0.00,0.00,374.88,'2021-12-09 06:16:27','',''),(2212061,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-09 06:16:27','',''),(2212099,'1','139','772',330,'Retail Sale Id 1302419',998.40,0.00,0.00,0.00,74.88,'2021-12-09 06:18:44','',''),(2212100,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 06:18:44','',''),(2212163,'1','139','772',330,'Retail Sale Id 1302441',1920.00,0.00,0.00,0.00,144.00,'2021-12-09 06:22:04','',''),(2212164,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 06:22:04','',''),(2212222,'1','139','772',330,'Retail Sale Id 1302465',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 06:25:08','',''),(2212223,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 06:25:08','',''),(2212412,'1','139','772',330,'Retail Sale Id 1302545',1401.60,0.00,0.00,0.00,105.12,'2021-12-09 06:36:58','',''),(2212413,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-09 06:36:58','',''),(2212432,'1','139','772',330,'Retail Sale Id 1302555',5760.00,0.00,0.00,0.00,432.00,'2021-12-09 06:38:08','',''),(2212433,'1','139','772',330,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-09 06:38:08','',''),(2212462,'1','139','772',330,'Retail Sale Id 1302571',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 06:40:07','',''),(2212463,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 06:40:07','',''),(2212522,'1','139','772',330,'Retail Sale Id 1302600',4998.40,0.00,0.00,0.00,374.88,'2021-12-09 06:43:07','',''),(2212523,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-09 06:43:07','',''),(2212550,'1','139','772',330,'Retail Sale Id 1302613',1280.00,0.00,0.00,0.00,96.00,'2021-12-09 06:44:42','',''),(2212551,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 06:44:42','',''),(2212646,'1','139','772',330,'Retail Sale Id 1302657',176900.00,0.00,0.00,0.00,5220.00,'2021-12-09 06:49:32','',''),(2212647,'1','139','772',330,'Retail sales',0.00,0.00,0.00,290.00,0.00,'2021-12-09 06:49:32','',''),(2212854,'1','139','772',330,'Retail Sale Id 1302752',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 07:01:01','',''),(2212855,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:01:01','',''),(2213184,'1','139','772',330,'Retail Sale Id 1302897',5760.00,0.00,0.00,0.00,432.00,'2021-12-09 07:17:22','',''),(2213185,'1','139','772',330,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-09 07:17:22','',''),(2213260,'1','139','772',330,'Retail Sale Id 1302932',4499.20,0.00,0.00,0.00,337.44,'2021-12-09 07:20:23','',''),(2213261,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-09 07:20:23','',''),(2213352,'1','139','772',330,'Retail Sale Id 1302979',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 07:24:21','',''),(2213353,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 07:24:21','',''),(2213374,'1','139','772',330,'Retail Sale Id 1302994',2502.40,0.00,0.00,0.00,187.68,'2021-12-09 07:25:52','',''),(2213375,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-09 07:25:52','',''),(2213404,'1','139','772',330,'Retail Sale Id 1303009',4998.40,0.00,0.00,0.00,374.88,'2021-12-09 07:26:51','',''),(2213405,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-09 07:26:51','',''),(2213574,'1','139','772',330,'Retail Sale Id 1303092',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 07:34:55','',''),(2213575,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 07:34:55','',''),(2213626,'1','139','772',330,'Retail Sale Id 1303115',1280.00,0.00,0.00,0.00,96.00,'2021-12-09 07:37:55','',''),(2213627,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 07:37:55','',''),(2213689,'1','139','772',330,'Retail Sale Id 1303151',4160.00,0.00,0.00,0.00,312.00,'2021-12-09 07:41:23','',''),(2213690,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-09 07:41:23','',''),(2213864,'1','139','772',330,'Retail Sale Id 1303232',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 07:49:33','',''),(2213865,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 07:49:33','',''),(2213911,'1','139','772',330,'Retail Sale Id 1303253',2880.00,0.00,0.00,0.00,216.00,'2021-12-09 07:52:36','',''),(2213913,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-09 07:52:36','',''),(2214100,'1','139','772',330,'Retail Sale Id 1303351',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 08:03:40','',''),(2214101,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 08:03:40','',''),(2214124,'1','139','772',330,'Retail Sale Id 1303363',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 08:04:48','',''),(2214125,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 08:04:48','',''),(2214240,'1','139','772',330,'Retail Sale Id 1303425',5120.00,0.00,0.00,0.00,384.00,'2021-12-09 08:10:23','',''),(2214241,'1','139','772',330,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-09 08:10:23','',''),(2214266,'1','139','772',330,'Retail Sale Id 1303438',1600.00,0.00,0.00,0.00,120.00,'2021-12-09 08:11:55','',''),(2214267,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-09 08:11:55','',''),(2214310,'1','139','772',330,'Retail Sale Id 1303456',640.00,0.00,0.00,0.00,48.00,'2021-12-09 08:14:35','',''),(2214311,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 08:14:35','',''),(2214531,'1','139','772',330,'Retail Sale Id 1303547',3520.00,0.00,0.00,0.00,264.00,'2021-12-09 08:24:31','',''),(2214532,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-09 08:24:31','',''),(2214596,'1','139','772',330,'Retail Sale Id 1303572',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 08:26:44','',''),(2214597,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 08:26:44','',''),(2214620,'1','139','772',330,'Retail Sale Id 1303585',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 08:28:12','',''),(2214621,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 08:28:12','',''),(2214700,'1','139','772',330,'Retail Sale Id 1303616',36600.00,0.00,0.00,0.00,1080.00,'2021-12-09 08:31:45','',''),(2214701,'1','139','772',330,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-09 08:31:45','',''),(2214742,'1','139','772',330,'Retail Sale Id 1303638',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 08:33:41','',''),(2214743,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 08:33:41','',''),(2214766,'1','139','772',330,'Retail Sale Id 1303655',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 08:35:06','',''),(2214767,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 08:35:06','',''),(2214799,'1','139','772',330,'Retail Sale Id 1303672',35380.00,0.00,0.00,0.00,1044.00,'2021-12-09 08:37:11','',''),(2214800,'1','139','772',330,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-09 08:37:11','',''),(2214903,'1','139','772',330,'Retail Sale Id 1303721',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 08:41:23','',''),(2214904,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 08:41:23','',''),(2214937,'1','139','772',330,'Retail Sale Id 1303737',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 08:43:05','',''),(2214938,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 08:43:05','',''),(2214991,'1','139','772',330,'Retail Sale Id 1303754',640.00,0.00,0.00,0.00,48.00,'2021-12-09 08:45:17','',''),(2214992,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 08:45:17','',''),(2215114,'1','139','772',330,'Retail Sale Id 1303818',4160.00,0.00,0.00,0.00,312.00,'2021-12-09 08:53:22','',''),(2215115,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-09 08:53:22','',''),(2215194,'1','139','772',330,'Retail Sale Id 1303860',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 08:58:07','',''),(2215195,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 08:58:07','',''),(2215321,'1','139','772',330,'Retail Sale Id 1303924',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 09:05:12','',''),(2215322,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 09:05:12','',''),(2215340,'1','139','772',330,'Retail Sale Id 1303932',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 09:06:25','',''),(2215341,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 09:06:25','',''),(2215374,'1','139','772',330,'Retail Sale Id 1303951',2502.40,0.00,0.00,0.00,187.68,'2021-12-09 09:08:48','',''),(2215375,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-09 09:08:48','',''),(2215426,'1','139','772',330,'Retail Sale Id 1303978',902.40,0.00,0.00,0.00,67.68,'2021-12-09 09:11:36','',''),(2215427,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-09 09:11:36','',''),(2215444,'1','139','772',330,'Retail Sale Id 1303988',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 09:13:03','',''),(2215445,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 09:13:03','',''),(2215521,'1','139','772',330,'Retail Sale Id 1304029',640.00,0.00,0.00,0.00,48.00,'2021-12-09 09:18:21','',''),(2215522,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 09:18:21','',''),(2215636,'1','139','772',330,'Retail Sale Id 1304081',800.00,0.00,0.00,0.00,60.00,'2021-12-09 09:23:48','',''),(2215637,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-09 09:23:48','',''),(2215766,'1','139','772',330,'Retail Sale Id 1304151',998.40,0.00,0.00,0.00,74.88,'2021-12-09 09:31:29','',''),(2215767,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 09:31:29','',''),(2215839,'1','139','772',330,'Retail Sale Id 1304183',652.80,0.00,0.00,0.00,48.96,'2021-12-09 09:34:21','',''),(2215840,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-09 09:34:21','',''),(2215885,'1','139','772',330,'Retail Sale Id 1304194',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 09:35:49','',''),(2215886,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 09:35:49','',''),(2216100,'1','139','772',330,'Retail Sale Id 1304274',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 09:45:45','',''),(2216101,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 09:45:45','',''),(2216348,'1','139','772',330,'Retail Sale Id 1304386',7680.00,0.00,0.00,0.00,576.00,'2021-12-09 09:57:49','',''),(2216349,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-09 09:57:49','',''),(2216463,'1','139','772',330,'Retail Sale Id 1304438',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 10:03:51','',''),(2216464,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 10:03:51','',''),(2216500,'1','139','772',330,'Retail Sale Id 1304452',30500.00,0.00,0.00,0.00,900.00,'2021-12-09 10:05:45','',''),(2216501,'1','139','772',330,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 10:05:45','',''),(2216533,'1','139','772',330,'Retail Sale Id 1304473',1600.00,0.00,0.00,0.00,120.00,'2021-12-09 10:07:26','',''),(2216534,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-09 10:07:26','',''),(2216595,'1','139','772',330,'Retail Sale Id 1304508',35380.00,0.00,0.00,0.00,1044.00,'2021-12-09 10:11:49','',''),(2216596,'1','139','772',330,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-09 10:11:49','',''),(2216681,'1','139','772',330,'Retail Sale Id 1304556',1600.00,0.00,0.00,0.00,120.00,'2021-12-09 10:18:25','',''),(2216682,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-09 10:18:25','',''),(2216803,'1','139','772',330,'Retail Sale Id 1304620',640.00,0.00,0.00,0.00,48.00,'2021-12-09 10:26:01','',''),(2216804,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 10:26:01','',''),(2217046,'1','139','772',330,'Retail Sale Id 1304744',6400.00,0.00,0.00,0.00,480.00,'2021-12-09 10:42:36','',''),(2217047,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 10:42:36','',''),(2217176,'1','139','772',330,'Retail Sale Id 1304816',697.60,0.00,0.00,0.00,52.32,'2021-12-09 10:50:09','',''),(2217177,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-09 10:50:09','',''),(2217232,'1','139','772',330,'Retail Sale Id 1304841',2560.00,0.00,0.00,0.00,192.00,'2021-12-09 10:53:56','',''),(2217233,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 10:53:56','',''),(2217319,'1','139','772',330,'Retail Sale Id 1304882',43920.00,0.00,0.00,0.00,1296.00,'2021-12-09 11:00:16','',''),(2217320,'1','139','772',330,'Retail sales',0.00,0.00,0.00,72.00,0.00,'2021-12-09 11:00:16','',''),(2217473,'1','139','772',330,'Retail Sale Id 1304961',697.60,0.00,0.00,0.00,52.32,'2021-12-09 11:11:34','',''),(2217474,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-09 11:11:34','',''),(2217524,'1','139','772',330,'Retail Sale Id 1304987',2240.00,0.00,0.00,0.00,168.00,'2021-12-09 11:15:33','',''),(2217525,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-09 11:15:33','',''),(2217536,'1','139','772',330,'Retail Sale Id 1304993',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 11:16:30','',''),(2217537,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 11:16:30','',''),(2217628,'1','139','772',330,'Retail Sale Id 1305035',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 11:21:24','',''),(2217629,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 11:21:24','',''),(2217658,'1','139','772',330,'Retail Sale Id 1305049',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 11:22:42','',''),(2217659,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 11:22:42','',''),(2217689,'1','139','772',330,'Retail Sale Id 1305066',640.00,0.00,0.00,0.00,48.00,'2021-12-09 11:23:52','',''),(2217690,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 11:23:52','',''),(2217735,'1','139','772',330,'Retail Sale Id 1305087',3520.00,0.00,0.00,0.00,264.00,'2021-12-09 11:27:21','',''),(2217736,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-09 11:27:21','',''),(2217778,'1','139','772',330,'Retail Sale Id 1305108',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 11:29:33','',''),(2217779,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 11:29:33','',''),(2217805,'1','139','772',330,'Retail Sale Id 1305121',16000.00,0.00,0.00,0.00,1200.00,'2021-12-09 11:30:43','',''),(2217806,'1','139','772',330,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-09 11:30:43','',''),(2217841,'1','139','772',330,'Retail Sale Id 1305136',2560.00,0.00,0.00,0.00,192.00,'2021-12-09 11:32:55','',''),(2217842,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 11:32:56','',''),(2218132,'1','139','772',330,'Retail Sale Id 1305280',640.00,0.00,0.00,0.00,48.00,'2021-12-09 11:51:26','',''),(2218133,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 11:51:26','',''),(2218170,'1','139','772',330,'Retail Sale Id 1305296',640.00,0.00,0.00,0.00,48.00,'2021-12-09 11:53:49','',''),(2218171,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 11:53:49','',''),(2218198,'1','139','772',330,'Retail Sale Id 1305312',2560.00,0.00,0.00,0.00,192.00,'2021-12-09 11:55:40','',''),(2218199,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 11:55:40','',''),(2218288,'1','139','772',330,'Retail Sale Id 1305363',697.60,0.00,0.00,0.00,52.32,'2021-12-09 12:01:57','',''),(2218289,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-09 12:01:57','',''),(2218379,'1','139','772',330,'Retail Sale Id 1305409',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 12:08:21','',''),(2218380,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 12:08:21','',''),(2218582,'1','139','772',330,'Retail Sale Id 1305508',2560.00,0.00,0.00,0.00,192.00,'2021-12-09 12:20:34','',''),(2218583,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 12:20:34','',''),(2218608,'1','139','772',330,'Retail Sale Id 1305521',697.60,0.00,0.00,0.00,52.32,'2021-12-09 12:22:18','',''),(2218609,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-09 12:22:18','',''),(2218682,'1','139','772',330,'Retail Sale Id 1305571',640.00,0.00,0.00,0.00,48.00,'2021-12-09 12:27:57','',''),(2218683,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 12:27:57','',''),(2218868,'1','139','772',330,'Retail Sale Id 1305666',4480.00,0.00,0.00,0.00,336.00,'2021-12-09 12:39:37','',''),(2218869,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-09 12:39:37','',''),(2218922,'1','139','772',330,'Retail Sale Id 1305691',697.60,0.00,0.00,0.00,52.32,'2021-12-09 12:41:48','',''),(2218923,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-09 12:41:48','',''),(2219139,'1','139','772',330,'Retail Sale Id 1305798',2560.00,0.00,0.00,0.00,192.00,'2021-12-09 12:53:22','',''),(2219140,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 12:53:22','',''),(2219227,'1','139','772',330,'Retail Sale Id 1305840',2880.00,0.00,0.00,0.00,216.00,'2021-12-09 12:57:41','',''),(2219228,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-09 12:57:41','',''),(2219271,'1','139','772',330,'Retail Sale Id 1305858',2880.00,0.00,0.00,0.00,216.00,'2021-12-09 13:00:25','',''),(2219272,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-09 13:00:25','',''),(2219299,'1','139','772',330,'Retail Sale Id 1305876',4480.00,0.00,0.00,0.00,336.00,'2021-12-09 13:01:57','',''),(2219300,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-09 13:01:57','',''),(2219341,'1','139','772',330,'Retail Sale Id 1305900',8320.00,0.00,0.00,0.00,624.00,'2021-12-09 13:06:19','',''),(2219342,'1','139','772',330,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-09 13:06:19','',''),(2219383,'1','139','772',330,'Retail Sale Id 1305931',1798.40,0.00,0.00,0.00,134.88,'2021-12-09 13:09:16','',''),(2219384,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-09 13:09:16','',''),(2219454,'1','139','772',330,'Retail Sale Id 1305957',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 13:12:37','',''),(2219455,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 13:12:37','',''),(2219506,'1','139','772',330,'Retail Sale Id 1305977',1203.20,0.00,0.00,0.00,90.24,'2021-12-09 13:16:32','',''),(2219507,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-09 13:16:32','',''),(2219569,'1','139','772',330,'Retail Sale Id 1306002',2502.40,0.00,0.00,0.00,187.68,'2021-12-09 13:20:39','',''),(2219570,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-09 13:20:39','',''),(2219573,'1','139','772',330,'Retail Sale Id 1306009',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 13:22:03','',''),(2219574,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 13:22:03','',''),(2219698,'1','139','772',330,'Retail Sale Id 1306059',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 13:29:31','',''),(2219699,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 13:29:31','',''),(2219759,'1','139','772',330,'Retail Sale Id 1306078',4160.00,0.00,0.00,0.00,312.00,'2021-12-09 13:31:49','',''),(2219760,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-09 13:31:49','',''),(2219960,'1','139','772',330,'Retail Sale Id 1306133',2880.00,0.00,0.00,0.00,216.00,'2021-12-09 13:40:48','',''),(2219961,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-09 13:40:48','',''),(2219994,'1','139','772',330,'Retail Sale Id 1306152',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 13:42:45','',''),(2219995,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 13:42:45','',''),(2220012,'1','139','772',330,'Retail Sale Id 1306164',902.40,0.00,0.00,0.00,67.68,'2021-12-09 13:44:13','',''),(2220013,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-09 13:44:13','',''),(2220052,'1','139','772',330,'Retail Sale Id 1306184',640.00,0.00,0.00,0.00,48.00,'2021-12-09 13:46:42','',''),(2220053,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 13:46:42','',''),(2220068,'1','139','772',330,'Retail Sale Id 1306195',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 13:47:58','',''),(2220069,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 13:47:58','',''),(2220094,'1','139','772',330,'Retail Sale Id 1306204',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 13:49:31','',''),(2220095,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 13:49:31','',''),(2220122,'1','139','772',330,'Retail Sale Id 1306217',640.00,0.00,0.00,0.00,48.00,'2021-12-09 13:51:30','',''),(2220123,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 13:51:30','',''),(2220173,'1','139','772',330,'Retail Sale Id 1306244',7040.00,0.00,0.00,0.00,528.00,'2021-12-09 13:54:53','',''),(2220174,'1','139','772',330,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-09 13:54:53','',''),(2220326,'1','139','772',330,'Retail Sale Id 1306313',2803.20,0.00,0.00,0.00,210.24,'2021-12-09 14:06:14','',''),(2220327,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.38,0.00,'2021-12-09 14:06:14','',''),(2220374,'1','139','772',330,'Retail Sale Id 1306335',640.00,0.00,0.00,0.00,48.00,'2021-12-09 14:09:38','',''),(2220375,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 14:09:38','',''),(2220429,'1','139','772',330,'Retail Sale Id 1306349',1830.00,0.00,0.00,0.00,54.00,'2021-12-09 14:11:33','',''),(2220430,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 14:11:33','',''),(2220442,'1','139','772',330,'Retail Sale Id 1306360',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 14:12:45','',''),(2220443,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 14:12:45','',''),(2220458,'1','139','772',330,'Retail Sale Id 1306386',4480.00,0.00,0.00,0.00,336.00,'2021-12-09 14:14:06','',''),(2220459,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-09 14:14:06','',''),(2220492,'1','139','772',330,'Retail Sale Id 1306421',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 14:15:39','',''),(2220493,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 14:15:39','',''),(2220514,'1','139','772',330,'Retail Sale Id 1306432',1600.00,0.00,0.00,0.00,120.00,'2021-12-09 14:16:32','',''),(2220515,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-09 14:16:32','',''),(2220562,'1','139','772',330,'Retail Sale Id 1306459',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 14:20:33','',''),(2220563,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 14:20:33','',''),(2220576,'1','139','772',330,'Retail Sale Id 1306464',998.40,0.00,0.00,0.00,74.88,'2021-12-09 14:21:27','',''),(2220577,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 14:21:27','',''),(2220620,'1','139','772',330,'Retail Sale Id 1306485',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 14:22:45','',''),(2220621,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 14:22:45','',''),(2220661,'1','139','772',330,'Retail Sale Id 1306508',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 14:25:03','',''),(2220662,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 14:25:03','',''),(2220708,'1','139','772',330,'Retail Sale Id 1306527',1401.60,0.00,0.00,0.00,105.12,'2021-12-09 14:26:50','',''),(2220709,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-09 14:26:50','',''),(2220770,'1','139','772',330,'Retail Sale Id 1306559',998.40,0.00,0.00,0.00,74.88,'2021-12-09 14:30:22','',''),(2220771,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 14:30:22','',''),(2221108,'1','139','772',330,'Retail Sale Id 1306712',1920.00,0.00,0.00,0.00,144.00,'2021-12-09 14:44:17','',''),(2221109,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 14:44:17','',''),(2221169,'1','139','772',330,'Retail Sale Id 1306738',1280.00,0.00,0.00,0.00,96.00,'2021-12-09 14:46:47','',''),(2221170,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 14:46:47','',''),(2221256,'1','139','772',330,'Retail Sale Id 1306770',7680.00,0.00,0.00,0.00,576.00,'2021-12-09 14:50:10','',''),(2221257,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-09 14:50:10','',''),(2221345,'1','139','772',330,'Retail Sale Id 1306790',1920.00,0.00,0.00,0.00,144.00,'2021-12-09 14:52:35','',''),(2221346,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 14:52:35','',''),(2221357,'1','139','772',330,'Retail Sale Id 1306797',998.40,0.00,0.00,0.00,74.88,'2021-12-09 14:53:25','',''),(2221358,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 14:53:25','',''),(2221371,'1','139','772',330,'Retail Sale Id 1306805',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 14:54:18','',''),(2221372,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 14:54:18','',''),(2221426,'1','139','772',330,'Retail Sale Id 1306818',1600.00,0.00,0.00,0.00,120.00,'2021-12-09 14:56:06','',''),(2221427,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-09 14:56:06','',''),(2221440,'1','139','772',330,'Retail Sale Id 1306825',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 14:57:04','',''),(2221441,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 14:57:04','',''),(2221456,'1','139','772',330,'Retail Sale Id 1306833',998.40,0.00,0.00,0.00,74.88,'2021-12-09 14:57:50','',''),(2221457,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 14:57:50','',''),(2221468,'1','139','772',330,'Retail Sale Id 1306839',1203.20,0.00,0.00,0.00,90.24,'2021-12-09 14:58:37','',''),(2221469,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-09 14:58:37','',''),(2221490,'1','139','772',330,'Retail Sale Id 1306851',998.40,0.00,0.00,0.00,74.88,'2021-12-09 15:00:01','',''),(2221491,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 15:00:01','',''),(2221504,'1','139','772',330,'Retail Sale Id 1306859',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 15:00:54','',''),(2221505,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 15:00:54','',''),(2221528,'1','139','772',330,'Retail Sale Id 1306873',998.40,0.00,0.00,0.00,74.88,'2021-12-09 15:02:46','',''),(2221529,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 15:02:46','',''),(2221546,'1','139','772',330,'Retail Sale Id 1306883',1280.00,0.00,0.00,0.00,96.00,'2021-12-09 15:03:39','',''),(2221547,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 15:03:39','',''),(2221572,'1','139','772',330,'Retail Sale Id 1306896',998.40,0.00,0.00,0.00,74.88,'2021-12-09 15:04:33','',''),(2221573,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 15:04:33','',''),(2221588,'1','139','772',330,'Retail Sale Id 1306907',1920.00,0.00,0.00,0.00,144.00,'2021-12-09 15:05:37','',''),(2221589,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:05:37','',''),(2221622,'1','139','772',330,'Retail Sale Id 1306923',1280.00,0.00,0.00,0.00,96.00,'2021-12-09 15:06:55','',''),(2221623,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 15:06:55','',''),(2221634,'1','139','772',330,'Retail Sale Id 1306929',1920.00,0.00,0.00,0.00,144.00,'2021-12-09 15:07:46','',''),(2221635,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:07:46','',''),(2221699,'1','139','772',330,'Retail Sale Id 1306960',640.00,0.00,0.00,0.00,48.00,'2021-12-09 15:10:32','',''),(2221700,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 15:10:32','',''),(2221729,'1','139','772',330,'Retail Sale Id 1306980',1920.00,0.00,0.00,0.00,144.00,'2021-12-09 15:11:56','',''),(2221730,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:11:56','',''),(2221745,'1','139','772',330,'Retail Sale Id 1306988',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 15:13:05','',''),(2221746,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 15:13:05','',''),(2221769,'1','139','772',330,'Retail Sale Id 1306999',3520.00,0.00,0.00,0.00,264.00,'2021-12-09 15:14:11','',''),(2221770,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-09 15:14:11','',''),(2221837,'1','139','772',330,'Retail Sale Id 1307040',3840.00,0.00,0.00,0.00,288.00,'2021-12-09 15:17:57','',''),(2221838,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 15:17:57','',''),(2221891,'1','139','772',330,'Retail Sale Id 1307060',3520.00,0.00,0.00,0.00,264.00,'2021-12-09 15:20:22','',''),(2221892,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-09 15:20:22','',''),(2221923,'1','139','772',330,'Retail Sale Id 1307078',1920.00,0.00,0.00,0.00,144.00,'2021-12-09 15:21:40','',''),(2221924,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:21:40','',''),(2221941,'1','139','772',330,'Retail Sale Id 1307087',3520.00,0.00,0.00,0.00,264.00,'2021-12-09 15:22:40','',''),(2221942,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-09 15:22:40','',''),(2221955,'1','139','772',330,'Retail Sale Id 1307095',3840.00,0.00,0.00,0.00,288.00,'2021-12-09 15:23:39','',''),(2221956,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 15:23:39','',''),(2221975,'1','139','772',330,'Retail Sale Id 1307105',640.00,0.00,0.00,0.00,48.00,'2021-12-09 15:24:49','',''),(2221976,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 15:24:49','',''),(2222005,'1','139','772',330,'Retail Sale Id 1307125',800.00,0.00,0.00,0.00,60.00,'2021-12-09 15:26:05','',''),(2222006,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-09 15:26:05','',''),(2222025,'1','139','772',330,'Retail Sale Id 1307133',7680.00,0.00,0.00,0.00,576.00,'2021-12-09 15:27:04','',''),(2222026,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-09 15:27:04','',''),(2222045,'1','139','772',330,'Retail Sale Id 1307145',1280.00,0.00,0.00,0.00,96.00,'2021-12-09 15:28:08','',''),(2222046,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 15:28:08','',''),(2222075,'1','139','772',330,'Retail Sale Id 1307159',2560.00,0.00,0.00,0.00,192.00,'2021-12-09 15:29:25','',''),(2222076,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 15:29:25','',''),(2222099,'1','139','772',330,'Retail Sale Id 1307173',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 15:30:41','',''),(2222100,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 15:30:41','',''),(2222128,'1','139','772',330,'Retail Sale Id 1307180',1920.00,0.00,0.00,0.00,144.00,'2021-12-09 15:31:38','',''),(2222129,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:31:39','',''),(2222152,'1','139','772',330,'Retail Sale Id 1307194',800.00,0.00,0.00,0.00,60.00,'2021-12-09 15:32:54','',''),(2222153,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-09 15:32:54','',''),(2222164,'1','139','772',330,'Retail Sale Id 1307201',998.40,0.00,0.00,0.00,74.88,'2021-12-09 15:33:48','',''),(2222165,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 15:33:48','',''),(2222190,'1','139','772',330,'Retail Sale Id 1307208',7040.00,0.00,0.00,0.00,528.00,'2021-12-09 15:35:14','',''),(2222191,'1','139','772',330,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-09 15:35:14','',''),(2222218,'1','139','772',330,'Retail Sale Id 1307225',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 15:36:45','',''),(2222219,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 15:36:45','',''),(2222294,'1','139','772',330,'Retail Sale Id 1307262',1600.00,0.00,0.00,0.00,120.00,'2021-12-09 15:40:13','',''),(2222295,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-09 15:40:13','',''),(2222415,'1','139','772',330,'Retail Sale Id 1307323',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 15:47:55','',''),(2222416,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 15:47:55','',''),(2222535,'1','139','772',330,'Retail Sale Id 1307384',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 15:54:23','',''),(2222536,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 15:54:23','',''),(2222654,'1','139','772',330,'Retail Sale Id 1307441',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 16:00:42','',''),(2222655,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 16:00:42','',''),(2222678,'1','139','772',330,'Retail Sale Id 1307452',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 16:01:43','',''),(2222679,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 16:01:43','',''),(2222686,'1','139','772',330,'Retail Sale Id 1307457',640.00,0.00,0.00,0.00,48.00,'2021-12-09 16:02:37','',''),(2222687,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 16:02:37','',''),(2222723,'1','139','772',330,'Retail Sale Id 1307474',7040.00,0.00,0.00,0.00,528.00,'2021-12-09 16:04:12','',''),(2222724,'1','139','772',330,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-09 16:04:12','',''),(2222755,'1','139','772',330,'Retail Sale Id 1307490',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 16:05:50','',''),(2222756,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 16:05:50','',''),(2222783,'1','139','772',330,'Retail Sale Id 1307504',1280.00,0.00,0.00,0.00,96.00,'2021-12-09 16:07:11','',''),(2222784,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 16:07:11','',''),(2222805,'1','139','772',330,'Retail Sale Id 1307515',1920.00,0.00,0.00,0.00,144.00,'2021-12-09 16:08:33','',''),(2222806,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:08:33','',''),(2222831,'1','139','772',330,'Retail Sale Id 1307531',3840.00,0.00,0.00,0.00,288.00,'2021-12-09 16:09:27','',''),(2222832,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 16:09:27','',''),(2222869,'1','139','772',330,'Retail Sale Id 1307551',1280.00,0.00,0.00,0.00,96.00,'2021-12-09 16:11:19','',''),(2222870,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 16:11:19','',''),(2222883,'1','139','772',330,'Retail Sale Id 1307559',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 16:12:17','',''),(2222884,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 16:12:17','',''),(2222899,'1','139','772',330,'Retail Sale Id 1307565',998.40,0.00,0.00,0.00,74.88,'2021-12-09 16:13:19','',''),(2222900,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 16:13:20','',''),(2222919,'1','139','772',330,'Retail Sale Id 1307574',640.00,0.00,0.00,0.00,48.00,'2021-12-09 16:14:18','',''),(2222920,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 16:14:18','',''),(2222963,'1','139','772',330,'Retail Sale Id 1307597',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 16:16:31','',''),(2222964,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 16:16:31','',''),(2222979,'1','139','772',330,'Retail Sale Id 1307608',3840.00,0.00,0.00,0.00,288.00,'2021-12-09 16:17:31','',''),(2222980,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 16:17:31','',''),(2223005,'1','139','772',330,'Retail Sale Id 1307617',3840.00,0.00,0.00,0.00,288.00,'2021-12-09 16:18:44','',''),(2223006,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 16:18:44','',''),(2223017,'1','139','772',330,'Retail Sale Id 1307625',1600.00,0.00,0.00,0.00,120.00,'2021-12-09 16:19:53','',''),(2223018,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-09 16:19:53','',''),(2223051,'1','139','772',330,'Retail Sale Id 1307638',1280.00,0.00,0.00,0.00,96.00,'2021-12-09 16:21:06','',''),(2223052,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 16:21:06','',''),(2223067,'1','139','772',330,'Retail Sale Id 1307646',1280.00,0.00,0.00,0.00,96.00,'2021-12-09 16:22:22','',''),(2223068,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 16:22:22','',''),(2223093,'1','139','772',330,'Retail Sale Id 1307659',1280.00,0.00,0.00,0.00,96.00,'2021-12-09 16:24:18','',''),(2223094,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 16:24:18','',''),(2223117,'1','139','772',330,'Retail Sale Id 1307671',1280.00,0.00,0.00,0.00,96.00,'2021-12-09 16:25:38','',''),(2223118,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 16:25:38','',''),(2223148,'1','139','772',330,'Retail Sale Id 1307679',640.00,0.00,0.00,0.00,48.00,'2021-12-09 16:26:37','',''),(2223149,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 16:26:37','',''),(2223174,'1','139','772',330,'Retail Sale Id 1307693',1920.00,0.00,0.00,0.00,144.00,'2021-12-09 16:27:50','',''),(2223175,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:27:50','',''),(2223198,'1','139','772',330,'Retail Sale Id 1307705',998.40,0.00,0.00,0.00,74.88,'2021-12-09 16:28:43','',''),(2223199,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 16:28:43','',''),(2223230,'1','139','772',330,'Retail Sale Id 1307719',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 16:30:51','',''),(2223231,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 16:30:51','',''),(2223243,'1','139','772',330,'Retail Sale Id 1307725',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 16:31:41','',''),(2223244,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 16:31:41','',''),(2223254,'1','139','772',330,'Retail Sale Id 1307732',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 16:32:29','',''),(2223255,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 16:32:29','',''),(2223294,'1','139','772',330,'Retail Sale Id 1307749',640.00,0.00,0.00,0.00,48.00,'2021-12-09 16:34:35','',''),(2223295,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 16:34:35','',''),(2223324,'1','139','772',330,'Retail Sale Id 1307765',3520.00,0.00,0.00,0.00,264.00,'2021-12-09 16:36:06','',''),(2223325,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-09 16:36:06','',''),(2223356,'1','139','772',330,'Retail Sale Id 1307780',4998.40,0.00,0.00,0.00,374.88,'2021-12-09 16:38:18','',''),(2223357,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-09 16:38:18','',''),(2223380,'1','139','772',330,'Retail Sale Id 1307785',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 16:39:25','',''),(2223381,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 16:39:25','',''),(2223409,'1','139','772',330,'Retail Sale Id 1307797',697.60,0.00,0.00,0.00,52.32,'2021-12-09 16:40:39','',''),(2223410,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-09 16:40:39','',''),(2223472,'1','139','772',330,'Retail Sale Id 1307817',998.40,0.00,0.00,0.00,74.88,'2021-12-09 16:42:59','',''),(2223473,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 16:42:59','',''),(2223492,'1','139','772',330,'Retail Sale Id 1307826',1920.00,0.00,0.00,0.00,144.00,'2021-12-09 16:44:03','',''),(2223493,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:44:03','',''),(2223516,'1','139','772',330,'Retail Sale Id 1307833',998.40,0.00,0.00,0.00,74.88,'2021-12-09 16:45:10','',''),(2223517,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 16:45:10','',''),(2223532,'1','139','772',330,'Retail Sale Id 1307841',6400.00,0.00,0.00,0.00,480.00,'2021-12-09 16:46:21','',''),(2223533,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 16:46:21','',''),(2223566,'1','139','772',330,'Retail Sale Id 1307855',1920.00,0.00,0.00,0.00,144.00,'2021-12-09 16:48:13','',''),(2223567,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:48:13','',''),(2223582,'1','139','772',330,'Retail Sale Id 1307864',1920.00,0.00,0.00,0.00,144.00,'2021-12-09 16:49:28','',''),(2223583,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:49:28','',''),(2223611,'1','139','772',330,'Retail Sale Id 1307878',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 16:51:19','',''),(2223612,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:51:19','',''),(2223635,'1','139','772',330,'Retail Sale Id 1307890',998.40,0.00,0.00,0.00,74.88,'2021-12-09 16:52:30','',''),(2223636,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 16:52:30','',''),(2223649,'1','139','772',330,'Retail Sale Id 1307897',2803.20,0.00,0.00,0.00,210.24,'2021-12-09 16:53:37','',''),(2223650,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.38,0.00,'2021-12-09 16:53:37','',''),(2223659,'1','139','772',330,'Retail Sale Id 1307903',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 16:54:21','',''),(2223660,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 16:54:21','',''),(2223681,'1','139','772',330,'Retail Sale Id 1307909',998.40,0.00,0.00,0.00,74.88,'2021-12-09 16:55:14','',''),(2223682,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 16:55:14','',''),(2223705,'1','139','772',330,'Retail Sale Id 1307921',7040.00,0.00,0.00,0.00,528.00,'2021-12-09 16:56:35','',''),(2223706,'1','139','772',330,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-09 16:56:35','',''),(2223729,'1','139','772',330,'Retail Sale Id 1307931',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 16:58:22','',''),(2223730,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 16:58:22','',''),(2223745,'1','139','772',330,'Retail Sale Id 1307940',3801.60,0.00,0.00,0.00,285.12,'2021-12-09 16:59:27','',''),(2223746,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-09 16:59:27','',''),(2223764,'1','139','772',330,'Retail Sale Id 1307949',998.40,0.00,0.00,0.00,74.88,'2021-12-09 17:00:11','',''),(2223765,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 17:00:11','',''),(2223772,'1','139','772',330,'Retail Sale Id 1307954',1280.00,0.00,0.00,0.00,96.00,'2021-12-09 17:00:58','',''),(2223773,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 17:00:58','',''),(2223804,'1','139','772',330,'Retail Sale Id 1307968',3801.60,0.00,0.00,0.00,285.12,'2021-12-09 17:02:53','',''),(2223805,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-09 17:02:53','',''),(2223826,'1','139','772',330,'Retail Sale Id 1307978',998.40,0.00,0.00,0.00,74.88,'2021-12-09 17:03:38','',''),(2223827,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 17:03:38','',''),(2223838,'1','139','772',330,'Retail Sale Id 1307984',1333200.00,0.00,0.00,0.00,30800.00,'2021-12-09 17:04:21','',''),(2223839,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2200.00,0.00,'2021-12-09 17:04:21','',''),(2223847,'1','139','772',330,'Retail Sale Id 1307988',1100.80,0.00,0.00,0.00,82.56,'2021-12-09 17:04:44','',''),(2223848,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.72,0.00,'2021-12-09 17:04:44','',''),(2223871,'1','139','772',330,'Retail Sale Id 1308000',4480.00,0.00,0.00,0.00,336.00,'2021-12-09 17:06:40','',''),(2223872,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-09 17:06:40','',''),(2223889,'1','139','772',330,'Retail Sale Id 1308008',1280.00,0.00,0.00,0.00,96.00,'2021-12-09 17:08:02','',''),(2223890,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 17:08:02','',''),(2223906,'1','139','772',330,'Retail Sale Id 1308017',998.40,0.00,0.00,0.00,74.88,'2021-12-09 17:09:53','',''),(2223907,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 17:09:53','',''),(2223916,'1','139','772',330,'Retail Sale Id 1308022',36600.00,0.00,0.00,0.00,1080.00,'2021-12-09 17:10:49','',''),(2223917,'1','139','772',330,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-09 17:10:49','',''),(2223920,'1','139','772',330,'Retail Sale Id 1308026',3840.00,0.00,0.00,0.00,288.00,'2021-12-09 17:11:00','',''),(2223921,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 17:11:00','',''),(2223932,'1','139','772',330,'Retail Sale Id 1308030',998.40,0.00,0.00,0.00,74.88,'2021-12-09 17:11:47','',''),(2223933,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 17:11:47','',''),(2223946,'1','139','772',330,'Retail Sale Id 1308035',3840.00,0.00,0.00,0.00,288.00,'2021-12-09 17:12:46','',''),(2223947,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 17:12:46','',''),(2223987,'1','139','772',330,'Retail Sale Id 1308063',6400.00,0.00,0.00,0.00,480.00,'2021-12-09 17:16:57','',''),(2223988,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 17:16:57','',''),(2224002,'1','139','772',330,'Retail Sale Id 1308069',1280.00,0.00,0.00,0.00,96.00,'2021-12-09 17:18:36','',''),(2224003,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 17:18:36','',''),(2224086,'1','139','772',330,'Retail Sale Id 1308109',4998.40,0.00,0.00,0.00,374.88,'2021-12-09 17:27:54','',''),(2224087,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-09 17:27:54','',''),(2225022,'1','139','772',330,'Retail Sale Id 1308329',1920.00,0.00,0.00,0.00,144.00,'2021-12-10 05:52:34','',''),(2225023,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 05:52:34','',''),(2225046,'1','139','772',330,'Retail Sale Id 1308343',998.40,0.00,0.00,0.00,74.88,'2021-12-10 05:57:41','',''),(2225047,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-10 05:57:41','',''),(2225059,'1','139','772',330,'Retail Sale Id 1308348',1280.00,0.00,0.00,0.00,96.00,'2021-12-10 06:00:12','',''),(2225060,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 06:00:12','',''),(2225077,'1','139','772',330,'Retail Sale Id 1308358',3200.00,0.00,0.00,0.00,240.00,'2021-12-10 06:03:00','',''),(2225078,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 06:03:00','',''),(2225120,'1','139','772',330,'Retail Sale Id 1308370',3840.00,0.00,0.00,0.00,288.00,'2021-12-10 06:06:02','',''),(2225121,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 06:06:02','',''),(2225136,'1','139','772',330,'Retail Sale Id 1308378',8000.00,0.00,0.00,0.00,600.00,'2021-12-10 06:09:07','',''),(2225137,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 06:09:07','',''),(2225223,'1','139','772',330,'Retail Sale Id 1308415',3001.60,0.00,0.00,0.00,225.12,'2021-12-10 06:20:02','',''),(2225224,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-10 06:20:02','',''),(2225351,'1','139','772',330,'Retail Sale Id 1308476',2003.20,0.00,0.00,0.00,150.24,'2021-12-10 06:29:42','',''),(2225352,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-10 06:29:42','',''),(2225365,'1','139','772',330,'Retail Sale Id 1308484',800.00,0.00,0.00,0.00,60.00,'2021-12-10 06:31:59','',''),(2225366,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-10 06:31:59','',''),(2225421,'1','139','772',330,'Retail Sale Id 1308507',2560.00,0.00,0.00,0.00,192.00,'2021-12-10 06:35:55','',''),(2225422,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 06:35:55','',''),(2225525,'1','139','772',330,'Retail Sale Id 1308551',2233.00,0.00,0.00,0.00,161.00,'2021-12-10 06:43:37','',''),(2225526,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-10 06:43:37','',''),(2225731,'1','139','772',330,'Retail Sale Id 1308656',5742.00,0.00,0.00,0.00,414.00,'2021-12-10 06:57:09','',''),(2225732,'1','139','772',330,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-10 06:57:09','',''),(2225765,'1','139','772',330,'Retail Sale Id 1308674',638.00,0.00,0.00,0.00,46.00,'2021-12-10 07:00:17','',''),(2225766,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-10 07:00:17','',''),(2225780,'1','139','772',330,'Retail Sale Id 1308683',5001.92,0.00,0.00,0.00,360.64,'2021-12-10 07:01:47','',''),(2225781,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.84,0.00,'2021-12-10 07:01:47','',''),(2225816,'1','139','772',330,'Retail Sale Id 1308702',4000.26,0.00,0.00,0.00,288.42,'2021-12-10 07:03:59','',''),(2225817,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.27,0.00,'2021-12-10 07:03:59','',''),(2225952,'1','139','772',330,'Retail Sale Id 1308776',7662.38,0.00,0.00,0.00,552.46,'2021-12-10 07:12:06','',''),(2225953,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.01,0.00,'2021-12-10 07:12:06','',''),(2226071,'1','139','772',330,'Retail Sale Id 1308835',7037.14,0.00,0.00,0.00,507.38,'2021-12-10 07:18:59','',''),(2226072,'1','139','772',330,'Retail sales',0.00,0.00,0.00,11.03,0.00,'2021-12-10 07:18:59','',''),(2226387,'1','139','772',330,'Retail Sale Id 1308985',638.00,0.00,0.00,0.00,46.00,'2021-12-10 07:35:32','',''),(2226388,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-10 07:35:32','',''),(2226459,'1','139','772',330,'Retail Sale Id 1309019',2698.74,0.00,0.00,0.00,194.58,'2021-12-10 07:39:49','',''),(2226460,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.23,0.00,'2021-12-10 07:39:49','',''),(2226657,'1','139','772',330,'Retail Sale Id 1309117',638.00,0.00,0.00,0.00,46.00,'2021-12-10 07:51:06','',''),(2226658,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-10 07:51:06','',''),(2226706,'1','139','772',330,'Retail Sale Id 1309127',1901.24,0.00,0.00,0.00,137.08,'2021-12-10 07:52:13','',''),(2226707,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.98,0.00,'2021-12-10 07:52:13','',''),(2226767,'1','139','772',330,'Retail Sale Id 1309163',180600.00,0.00,0.00,0.00,3000.00,'2021-12-10 07:56:10','',''),(2226768,'1','139','772',330,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-10 07:56:10','',''),(2226808,'1','139','772',330,'Retail Sale Id 1309177',3502.62,0.00,0.00,0.00,252.54,'2021-12-10 07:58:08','',''),(2226809,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.49,0.00,'2021-12-10 07:58:08','',''),(2226875,'1','139','772',330,'Retail Sale Id 1309190',2998.60,0.00,0.00,0.00,216.20,'2021-12-10 07:59:49','',''),(2226876,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.70,0.00,'2021-12-10 07:59:49','',''),(2227019,'1','139','772',330,'Retail Sale Id 1309254',701.80,0.00,0.00,0.00,50.60,'2021-12-10 08:06:32','',''),(2227020,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.10,0.00,'2021-12-10 08:06:32','',''),(2227088,'1','139','772',330,'Retail Sale Id 1309274',1397.22,0.00,0.00,0.00,100.74,'2021-12-10 08:09:49','',''),(2227089,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-10 08:09:49','',''),(2227297,'1','139','772',330,'Retail Sale Id 1309372',30100.00,0.00,0.00,0.00,500.00,'2021-12-10 08:21:07','',''),(2227298,'1','139','772',330,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 08:21:07','',''),(2227439,'1','139','772',330,'Retail Sale Id 1309418',36120.00,0.00,0.00,0.00,600.00,'2021-12-10 08:25:41','',''),(2227440,'1','139','772',330,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-10 08:25:41','',''),(2227493,'1','139','772',330,'Retail Sale Id 1309453',2528.00,0.00,0.00,0.00,160.00,'2021-12-10 08:29:18','',''),(2227494,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 08:29:18','',''),(2227546,'1','139','772',330,'Retail Sale Id 1309481',638.32,0.00,0.00,0.00,40.40,'2021-12-10 08:31:45','',''),(2227547,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.01,0.00,'2021-12-10 08:31:45','',''),(2227583,'1','139','772',330,'Retail Sale Id 1309500',1598.96,0.00,0.00,0.00,101.20,'2021-12-10 08:33:33','',''),(2227584,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.53,0.00,'2021-12-10 08:33:33','',''),(2227603,'1','139','772',330,'Retail Sale Id 1309511',638.32,0.00,0.00,0.00,40.40,'2021-12-10 08:34:27','',''),(2227604,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.01,0.00,'2021-12-10 08:34:27','',''),(2227631,'1','139','772',330,'Retail Sale Id 1309527',3002.00,0.00,0.00,0.00,190.00,'2021-12-10 08:36:08','',''),(2227632,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 08:36:08','',''),(2227710,'1','139','772',330,'Retail Sale Id 1309562',2528.00,0.00,0.00,0.00,160.00,'2021-12-10 08:40:54','',''),(2227711,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 08:40:54','',''),(2227742,'1','139','772',330,'Retail Sale Id 1309581',632.00,0.00,0.00,0.00,40.00,'2021-12-10 08:42:55','',''),(2227743,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-10 08:42:56','',''),(2227768,'1','139','772',330,'Retail Sale Id 1309593',3002.00,0.00,0.00,0.00,190.00,'2021-12-10 08:43:56','',''),(2227769,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 08:43:56','',''),(2227790,'1','139','772',330,'Retail Sale Id 1309604',7002.56,0.00,0.00,0.00,443.20,'2021-12-10 08:44:58','',''),(2227791,'1','139','772',330,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-10 08:44:58','',''),(2227934,'1','139','772',330,'Retail Sale Id 1309661',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 08:49:47','',''),(2227935,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 08:49:47','',''),(2227954,'1','139','772',330,'Retail Sale Id 1309675',7002.56,0.00,0.00,0.00,443.20,'2021-12-10 08:50:43','',''),(2227955,'1','139','772',330,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-10 08:50:43','',''),(2227986,'1','139','772',330,'Retail Sale Id 1309684',3501.28,0.00,0.00,0.00,221.60,'2021-12-10 08:52:03','',''),(2227987,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.54,0.00,'2021-12-10 08:52:03','',''),(2228004,'1','139','772',330,'Retail Sale Id 1309700',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 08:53:18','',''),(2228005,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 08:53:18','',''),(2228074,'1','139','772',330,'Retail Sale Id 1309728',3002.00,0.00,0.00,0.00,190.00,'2021-12-10 08:56:40','',''),(2228075,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 08:56:40','',''),(2228146,'1','139','772',330,'Retail Sale Id 1309765',2528.00,0.00,0.00,0.00,160.00,'2021-12-10 08:59:45','',''),(2228147,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 08:59:45','',''),(2228352,'1','139','772',330,'Retail Sale Id 1309868',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 09:09:37','',''),(2228353,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 09:09:37','',''),(2228543,'1','139','772',330,'Retail Sale Id 1309953',1700.08,0.00,0.00,0.00,107.60,'2021-12-10 09:21:04','',''),(2228544,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.69,0.00,'2021-12-10 09:21:04','',''),(2228775,'1','139','772',330,'Retail Sale Id 1310056',638.32,0.00,0.00,0.00,40.40,'2021-12-10 09:34:16','',''),(2228776,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.01,0.00,'2021-12-10 09:34:16','',''),(2228851,'1','139','772',330,'Retail Sale Id 1310098',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 09:39:19','',''),(2228852,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 09:39:19','',''),(2228863,'1','139','772',330,'Retail Sale Id 1310105',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 09:40:15','',''),(2228864,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 09:40:15','',''),(2228887,'1','139','772',330,'Retail Sale Id 1310115',638.32,0.00,0.00,0.00,40.40,'2021-12-10 09:41:18','',''),(2228888,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.01,0.00,'2021-12-10 09:41:18','',''),(2228947,'1','139','772',330,'Retail Sale Id 1310142',30100.00,0.00,0.00,0.00,500.00,'2021-12-10 09:44:23','',''),(2228948,'1','139','772',330,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 09:44:23','',''),(2228993,'1','139','772',330,'Retail Sale Id 1310177',2528.00,0.00,0.00,0.00,160.00,'2021-12-10 09:47:14','',''),(2228994,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 09:47:14','',''),(2229002,'1','139','772',330,'Retail Sale Id 1310181',2528.00,0.00,0.00,0.00,160.00,'2021-12-10 09:48:04','',''),(2229003,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 09:48:04','',''),(2229021,'1','139','772',330,'Retail Sale Id 1310190',1264.00,0.00,0.00,0.00,80.00,'2021-12-10 09:49:06','',''),(2229022,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 09:49:06','',''),(2229113,'1','139','772',330,'Retail Sale Id 1310234',650.96,0.00,0.00,0.00,41.20,'2021-12-10 09:54:13','',''),(2229114,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.03,0.00,'2021-12-10 09:54:13','',''),(2229323,'1','139','772',330,'Retail Sale Id 1310324',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 10:07:01','',''),(2229324,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 10:07:01','',''),(2229347,'1','139','772',330,'Retail Sale Id 1310334',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 10:08:04','',''),(2229348,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 10:08:04','',''),(2229361,'1','139','772',330,'Retail Sale Id 1310342',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 10:08:56','',''),(2229362,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 10:08:56','',''),(2229527,'1','139','772',330,'Retail Sale Id 1310417',3002.00,0.00,0.00,0.00,190.00,'2021-12-10 10:16:31','',''),(2229528,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 10:16:31','',''),(2229575,'1','139','772',330,'Retail Sale Id 1310441',3002.00,0.00,0.00,0.00,190.00,'2021-12-10 10:19:26','',''),(2229576,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 10:19:26','',''),(2229747,'1','139','772',330,'Retail Sale Id 1310523',1200.80,0.00,0.00,0.00,76.00,'2021-12-10 10:28:51','',''),(2229748,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-10 10:28:51','',''),(2229933,'1','139','772',330,'Retail Sale Id 1310608',3002.00,0.00,0.00,0.00,190.00,'2021-12-10 10:40:27','',''),(2229934,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 10:40:27','',''),(2229985,'1','139','772',330,'Retail Sale Id 1310632',701.52,0.00,0.00,0.00,44.40,'2021-12-10 10:44:24','',''),(2229986,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-10 10:44:24','',''),(2230204,'1','139','772',330,'Retail Sale Id 1310722',4000.56,0.00,0.00,0.00,253.20,'2021-12-10 10:54:39','',''),(2230205,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-10 10:54:39','',''),(2230220,'1','139','772',330,'Retail Sale Id 1310728',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 10:56:18','',''),(2230221,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 10:56:18','',''),(2230386,'1','139','772',330,'Retail Sale Id 1310808',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 11:05:08','',''),(2230387,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 11:05:08','',''),(2230402,'1','139','772',330,'Retail Sale Id 1310818',998.56,0.00,0.00,0.00,63.20,'2021-12-10 11:05:57','',''),(2230403,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 11:05:57','',''),(2230611,'1','139','772',330,'Retail Sale Id 1310907',638.32,0.00,0.00,0.00,40.40,'2021-12-10 11:18:37','',''),(2230612,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.01,0.00,'2021-12-10 11:18:37','',''),(2230686,'1','139','772',330,'Retail Sale Id 1310923',9480.00,0.00,0.00,0.00,600.00,'2021-12-10 11:21:16','',''),(2230687,'1','139','772',330,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-10 11:21:16','',''),(2230697,'1','139','772',330,'Retail Sale Id 1310926',998.56,0.00,0.00,0.00,63.20,'2021-12-10 11:22:17','',''),(2230698,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 11:22:17','',''),(2230705,'1','139','772',330,'Retail Sale Id 1310931',4999.12,0.00,0.00,0.00,316.40,'2021-12-10 11:23:07','',''),(2230706,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-10 11:23:07','',''),(2230751,'1','139','772',330,'Retail Sale Id 1310953',701.52,0.00,0.00,0.00,44.40,'2021-12-10 11:26:22','',''),(2230752,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-10 11:26:22','',''),(2230881,'1','139','772',330,'Retail Sale Id 1311021',1200.80,0.00,0.00,0.00,76.00,'2021-12-10 11:35:24','',''),(2230882,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-10 11:35:24','',''),(2230999,'1','139','772',330,'Retail Sale Id 1311086',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 11:44:53','',''),(2231000,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 11:44:53','',''),(2231045,'1','139','772',330,'Retail Sale Id 1311112',72240.00,0.00,0.00,0.00,1200.00,'2021-12-10 11:48:48','',''),(2231046,'1','139','772',330,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-10 11:48:48','',''),(2231120,'1','139','772',330,'Retail Sale Id 1311149',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 11:54:44','',''),(2231121,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 11:54:44','',''),(2231177,'1','139','772',330,'Retail Sale Id 1311172',36120.00,0.00,0.00,0.00,600.00,'2021-12-10 11:56:58','',''),(2231178,'1','139','772',330,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-10 11:56:58','',''),(2231246,'1','139','772',330,'Retail Sale Id 1311214',701.52,0.00,0.00,0.00,44.40,'2021-12-10 12:03:14','',''),(2231247,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-10 12:03:14','',''),(2231489,'1','139','772',330,'Retail Sale Id 1311336',638.32,0.00,0.00,0.00,40.40,'2021-12-10 12:22:08','',''),(2231490,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.01,0.00,'2021-12-10 12:22:08','',''),(2231531,'1','139','772',330,'Retail Sale Id 1311356',638.32,0.00,0.00,0.00,40.40,'2021-12-10 12:25:32','',''),(2231532,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.01,0.00,'2021-12-10 12:25:32','',''),(2231548,'1','139','772',330,'Retail Sale Id 1311367',1801.20,0.00,0.00,0.00,114.00,'2021-12-10 12:26:26','',''),(2231549,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.85,0.00,'2021-12-10 12:26:26','',''),(2231570,'1','139','772',330,'Retail Sale Id 1311378',3002.00,0.00,0.00,0.00,190.00,'2021-12-10 12:27:57','',''),(2231571,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 12:27:57','',''),(2231690,'1','139','772',330,'Retail Sale Id 1311455',998.56,0.00,0.00,0.00,63.20,'2021-12-10 12:42:09','',''),(2231691,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 12:42:09','',''),(2232431,'1','139','772',330,'Retail Sale Id 1311804',998.56,0.00,0.00,0.00,63.20,'2021-12-10 13:30:33','',''),(2232432,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 13:30:33','',''),(2232461,'1','139','772',330,'Retail Sale Id 1311818',998.56,0.00,0.00,0.00,63.20,'2021-12-10 13:32:13','',''),(2232462,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 13:32:13','',''),(2232473,'1','139','772',330,'Retail Sale Id 1311823',998.56,0.00,0.00,0.00,63.20,'2021-12-10 13:33:03','',''),(2232474,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 13:33:03','',''),(2232501,'1','139','772',330,'Retail Sale Id 1311838',2098.24,0.00,0.00,0.00,132.80,'2021-12-10 13:34:31','',''),(2232502,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.32,0.00,'2021-12-10 13:34:31','',''),(2232529,'1','139','772',330,'Retail Sale Id 1311853',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 13:35:39','',''),(2232530,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 13:35:39','',''),(2232554,'1','139','772',330,'Retail Sale Id 1311865',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 13:37:01','',''),(2232555,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 13:37:01','',''),(2232687,'1','139','772',330,'Retail Sale Id 1311916',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 13:42:43','',''),(2232688,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 13:42:43','',''),(2232721,'1','139','772',330,'Retail Sale Id 1311928',33110.00,0.00,0.00,0.00,550.00,'2021-12-10 13:44:13','',''),(2232722,'1','139','772',330,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-10 13:44:13','',''),(2232813,'1','139','772',330,'Retail Sale Id 1311966',2502.72,0.00,0.00,0.00,158.40,'2021-12-10 13:47:56','',''),(2232814,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-10 13:47:56','',''),(2233013,'1','139','772',330,'Retail Sale Id 1312058',998.56,0.00,0.00,0.00,63.20,'2021-12-10 13:58:15','',''),(2233014,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 13:58:15','',''),(2233058,'1','139','772',330,'Retail Sale Id 1312081',7002.56,0.00,0.00,0.00,443.20,'2021-12-10 14:00:25','',''),(2233059,'1','139','772',330,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-10 14:00:25','',''),(2233215,'1','139','772',330,'Retail Sale Id 1312126',998.56,0.00,0.00,0.00,63.20,'2021-12-10 14:06:07','',''),(2233216,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 14:06:07','',''),(2233273,'1','139','772',330,'Retail Sale Id 1312152',701.52,0.00,0.00,0.00,44.40,'2021-12-10 14:10:10','',''),(2233274,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-10 14:10:10','',''),(2233375,'1','139','772',330,'Retail Sale Id 1312207',998.56,0.00,0.00,0.00,63.20,'2021-12-10 14:16:15','',''),(2233376,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 14:16:15','',''),(2233435,'1','139','772',330,'Retail Sale Id 1312234',1200.80,0.00,0.00,0.00,76.00,'2021-12-10 14:19:23','',''),(2233436,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-10 14:19:23','',''),(2233453,'1','139','772',330,'Retail Sale Id 1312242',3501.28,0.00,0.00,0.00,221.60,'2021-12-10 14:20:14','',''),(2233454,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.54,0.00,'2021-12-10 14:20:14','',''),(2233500,'1','139','772',330,'Retail Sale Id 1312263',701.52,0.00,0.00,0.00,44.40,'2021-12-10 14:22:11','',''),(2233501,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-10 14:22:11','',''),(2233541,'1','139','772',330,'Retail Sale Id 1312277',998.56,0.00,0.00,0.00,63.20,'2021-12-10 14:24:05','',''),(2233542,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 14:24:05','',''),(2233735,'1','139','772',330,'Retail Sale Id 1312358',998.56,0.00,0.00,0.00,63.20,'2021-12-10 14:31:46','',''),(2233736,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 14:31:46','',''),(2233771,'1','139','772',330,'Retail Sale Id 1312376',2528.00,0.00,0.00,0.00,160.00,'2021-12-10 14:33:14','',''),(2233772,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 14:33:14','',''),(2233795,'1','139','772',330,'Retail Sale Id 1312385',4999.12,0.00,0.00,0.00,316.40,'2021-12-10 14:34:17','',''),(2233796,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-10 14:34:17','',''),(2234141,'1','139','772',330,'Retail Sale Id 1312528',802.64,0.00,0.00,0.00,50.80,'2021-12-10 14:47:46','',''),(2234142,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.27,0.00,'2021-12-10 14:47:46','',''),(2234197,'1','139','772',330,'Retail Sale Id 1312559',7002.56,0.00,0.00,0.00,443.20,'2021-12-10 14:49:48','',''),(2234198,'1','139','772',330,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-10 14:49:48','',''),(2234292,'1','139','772',330,'Retail Sale Id 1312601',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 14:54:26','',''),(2234293,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 14:54:26','',''),(2234310,'1','139','772',330,'Retail Sale Id 1312612',1080.72,0.00,0.00,0.00,68.40,'2021-12-10 14:55:26','',''),(2234311,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.71,0.00,'2021-12-10 14:55:26','',''),(2234372,'1','139','772',330,'Retail Sale Id 1312639',701.52,0.00,0.00,0.00,44.40,'2021-12-10 14:59:33','',''),(2234373,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-10 14:59:33','',''),(2234396,'1','139','772',330,'Retail Sale Id 1312652',1700.08,0.00,0.00,0.00,107.60,'2021-12-10 15:00:46','',''),(2234397,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.69,0.00,'2021-12-10 15:00:46','',''),(2234412,'1','139','772',330,'Retail Sale Id 1312664',4000.56,0.00,0.00,0.00,253.20,'2021-12-10 15:02:18','',''),(2234413,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-10 15:02:18','',''),(2234452,'1','139','772',330,'Retail Sale Id 1312681',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 15:04:24','',''),(2234453,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 15:04:24','',''),(2234510,'1','139','772',330,'Retail Sale Id 1312708',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 15:07:06','',''),(2234511,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 15:07:06','',''),(2234737,'1','139','772',330,'Retail Sale Id 1312820',802.64,0.00,0.00,0.00,50.80,'2021-12-10 15:16:52','',''),(2234738,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.27,0.00,'2021-12-10 15:16:52','',''),(2234757,'1','139','772',330,'Retail Sale Id 1312831',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 15:17:55','',''),(2234758,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 15:17:55','',''),(2234797,'1','139','772',330,'Retail Sale Id 1312853',3002.00,0.00,0.00,0.00,190.00,'2021-12-10 15:19:33','',''),(2234798,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 15:19:33','',''),(2234848,'1','139','772',330,'Retail Sale Id 1312879',998.56,0.00,0.00,0.00,63.20,'2021-12-10 15:21:33','',''),(2234849,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 15:21:33','',''),(2234874,'1','139','772',330,'Retail Sale Id 1312893',2199.36,0.00,0.00,0.00,139.20,'2021-12-10 15:22:37','',''),(2234875,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.48,0.00,'2021-12-10 15:22:37','',''),(2234926,'1','139','772',330,'Retail Sale Id 1312926',4424.00,0.00,0.00,0.00,280.00,'2021-12-10 15:24:26','',''),(2234927,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-10 15:24:26','',''),(2235050,'1','139','772',330,'Retail Sale Id 1312971',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 15:28:03','',''),(2235051,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 15:28:03','',''),(2235105,'1','139','772',330,'Retail Sale Id 1312994',2502.72,0.00,0.00,0.00,158.40,'2021-12-10 15:30:02','',''),(2235106,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-10 15:30:02','',''),(2235215,'1','139','772',330,'Retail Sale Id 1313045',8001.12,0.00,0.00,0.00,506.40,'2021-12-10 15:35:07','',''),(2235216,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.66,0.00,'2021-12-10 15:35:07','',''),(2235239,'1','139','772',330,'Retail Sale Id 1313058',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 15:36:17','',''),(2235240,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 15:36:17','',''),(2235279,'1','139','772',330,'Retail Sale Id 1313075',998.56,0.00,0.00,0.00,63.20,'2021-12-10 15:37:37','',''),(2235280,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 15:37:37','',''),(2235301,'1','139','772',330,'Retail Sale Id 1313086',5062.32,0.00,0.00,0.00,320.40,'2021-12-10 15:38:56','',''),(2235302,'1','139','772',330,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-10 15:38:56','',''),(2235321,'1','139','772',330,'Retail Sale Id 1313097',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 15:39:56','',''),(2235322,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 15:39:56','',''),(2235365,'1','139','772',330,'Retail Sale Id 1313114',3482.32,0.00,0.00,0.00,220.40,'2021-12-10 15:41:36','',''),(2235366,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.51,0.00,'2021-12-10 15:41:36','',''),(2235391,'1','139','772',330,'Retail Sale Id 1313126',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 15:42:28','',''),(2235392,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 15:42:28','',''),(2235417,'1','139','772',330,'Retail Sale Id 1313144',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 15:43:35','',''),(2235418,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 15:43:35','',''),(2235441,'1','139','772',330,'Retail Sale Id 1313157',2528.00,0.00,0.00,0.00,160.00,'2021-12-10 15:44:37','',''),(2235442,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 15:44:37','',''),(2235491,'1','139','772',330,'Retail Sale Id 1313187',998.56,0.00,0.00,0.00,63.20,'2021-12-10 15:47:05','',''),(2235492,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 15:47:05','',''),(2235546,'1','139','772',330,'Retail Sale Id 1313222',4499.84,0.00,0.00,0.00,284.80,'2021-12-10 15:49:59','',''),(2235547,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.12,0.00,'2021-12-10 15:49:59','',''),(2235572,'1','139','772',330,'Retail Sale Id 1313241',701.52,0.00,0.00,0.00,44.40,'2021-12-10 15:51:37','',''),(2235573,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-10 15:51:37','',''),(2235595,'1','139','772',330,'Retail Sale Id 1313255',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 15:52:51','',''),(2235596,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 15:52:52','',''),(2235622,'1','139','772',330,'Retail Sale Id 1313266',6320.00,0.00,0.00,0.00,400.00,'2021-12-10 15:54:05','',''),(2235623,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 15:54:05','',''),(2235640,'1','139','772',330,'Retail Sale Id 1313278',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 15:55:05','',''),(2235641,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 15:55:06','',''),(2235710,'1','139','772',330,'Retail Sale Id 1313308',4499.84,0.00,0.00,0.00,284.80,'2021-12-10 15:58:01','',''),(2235711,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.12,0.00,'2021-12-10 15:58:01','',''),(2235769,'1','139','772',330,'Retail Sale Id 1313337',1801.20,0.00,0.00,0.00,114.00,'2021-12-10 16:00:10','',''),(2235770,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.85,0.00,'2021-12-10 16:00:10','',''),(2235849,'1','139','772',330,'Retail Sale Id 1313380',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 16:04:36','',''),(2235850,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 16:04:36','',''),(2235993,'1','139','772',330,'Retail Sale Id 1313432',1580.00,0.00,0.00,0.00,100.00,'2021-12-10 16:10:13','',''),(2235994,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-10 16:10:13','',''),(2236041,'1','139','772',330,'Retail Sale Id 1313457',701.52,0.00,0.00,0.00,44.40,'2021-12-10 16:12:35','',''),(2236042,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-10 16:12:35','',''),(2236144,'1','139','772',330,'Retail Sale Id 1313516',2528.00,0.00,0.00,0.00,160.00,'2021-12-10 16:17:47','',''),(2236145,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 16:17:47','',''),(2236203,'1','139','772',330,'Retail Sale Id 1313550',632.00,0.00,0.00,0.00,40.00,'2021-12-10 16:20:17','',''),(2236204,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-10 16:20:17','',''),(2236280,'1','139','772',330,'Retail Sale Id 1313599',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 16:23:23','',''),(2236281,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 16:23:23','',''),(2237357,'1','139','772',330,'Retail Sale Id 1314098',1935500.00,0.00,0.00,0.00,-136500.00,'2021-12-10 17:29:50','',''),(2237358,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3500.00,0.00,'2021-12-10 17:29:50','',''),(2237409,'1','139','772',330,'Retail Sale Id 1314113',556000.00,0.00,0.00,0.00,-36000.00,'2021-12-10 17:35:08','',''),(2237410,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1000.00,0.00,'2021-12-10 17:35:08','',''),(2238538,'1','139','772',330,'Retail Sale Id 1314458',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 06:10:54','',''),(2238539,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 06:10:54','',''),(2238560,'1','139','772',330,'Retail Sale Id 1314471',4999.12,0.00,0.00,0.00,316.40,'2021-12-11 06:12:46','',''),(2238561,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-11 06:12:46','',''),(2238566,'1','139','772',330,'Retail Sale Id 1314474',27090.00,0.00,0.00,0.00,450.00,'2021-12-11 06:14:14','',''),(2238567,'1','139','772',330,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-11 06:14:14','',''),(2238627,'1','139','772',330,'Retail Sale Id 1314499',1896.00,0.00,0.00,0.00,120.00,'2021-12-11 06:20:26','',''),(2238628,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 06:20:26','',''),(2238654,'1','139','772',330,'Retail Sale Id 1314512',3160.00,0.00,0.00,0.00,200.00,'2021-12-11 06:22:06','',''),(2238655,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 06:22:06','',''),(2238741,'1','139','772',330,'Retail Sale Id 1314558',6320.00,0.00,0.00,0.00,400.00,'2021-12-11 06:28:30','',''),(2238742,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 06:28:30','',''),(2238760,'1','139','772',330,'Retail Sale Id 1314567',3913.00,0.00,0.00,0.00,65.00,'2021-12-11 06:30:00','',''),(2238761,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-11 06:30:00','',''),(2238864,'1','139','772',330,'Retail Sale Id 1314603',10234.00,0.00,0.00,0.00,170.00,'2021-12-11 06:35:58','',''),(2238865,'1','139','772',330,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-11 06:35:58','',''),(2238888,'1','139','772',330,'Retail Sale Id 1314615',3792.00,0.00,0.00,0.00,240.00,'2021-12-11 06:37:35','',''),(2238889,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 06:37:35','',''),(2239168,'1','139','772',330,'Retail Sale Id 1314625',2528.00,0.00,0.00,0.00,160.00,'2021-12-11 06:57:37','',''),(2239169,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 06:57:37','',''),(2239190,'1','139','772',330,'Retail Sale Id 1314766',8848.00,0.00,0.00,0.00,560.00,'2021-12-11 06:58:34','',''),(2239191,'1','139','772',330,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-11 06:58:34','',''),(2239227,'1','139','772',330,'Retail Sale Id 1314799',5688.00,0.00,0.00,0.00,360.00,'2021-12-11 07:00:58','',''),(2239228,'1','139','772',330,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-11 07:00:58','',''),(2239262,'1','139','772',330,'Retail Sale Id 1314816',30100.00,0.00,0.00,0.00,500.00,'2021-12-11 07:02:42','',''),(2239263,'1','139','772',330,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 07:02:42','',''),(2239294,'1','139','772',330,'Retail Sale Id 1314831',24080.00,0.00,0.00,0.00,400.00,'2021-12-11 07:04:49','',''),(2239295,'1','139','772',330,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-11 07:04:49','',''),(2239491,'1','139','772',330,'Retail Sale Id 1314935',15800.00,0.00,0.00,0.00,1000.00,'2021-12-11 07:17:06','',''),(2239492,'1','139','772',330,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-11 07:17:06','',''),(2239551,'1','139','772',330,'Retail Sale Id 1314966',2528.00,0.00,0.00,0.00,160.00,'2021-12-11 07:21:13','',''),(2239552,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 07:21:13','',''),(2239634,'1','139','772',330,'Retail Sale Id 1315027',7002.56,0.00,0.00,0.00,443.20,'2021-12-11 07:25:35','',''),(2239635,'1','139','772',330,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-11 07:25:35','',''),(2239726,'1','139','772',330,'Retail Sale Id 1315074',6952.00,0.00,0.00,0.00,440.00,'2021-12-11 07:31:00','',''),(2239727,'1','139','772',330,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-11 07:31:00','',''),(2239795,'1','139','772',330,'Retail Sale Id 1315101',2502.72,0.00,0.00,0.00,158.40,'2021-12-11 07:33:24','',''),(2239796,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-11 07:33:24','',''),(2239855,'1','139','772',330,'Retail Sale Id 1315137',3476.00,0.00,0.00,0.00,220.00,'2021-12-11 07:36:33','',''),(2239856,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-11 07:36:33','',''),(2239953,'1','139','772',330,'Retail Sale Id 1315189',12008.00,0.00,0.00,0.00,760.00,'2021-12-11 07:41:40','',''),(2239954,'1','139','772',330,'Retail sales',0.00,0.00,0.00,19.00,0.00,'2021-12-11 07:41:40','',''),(2239983,'1','139','772',330,'Retail Sale Id 1315203',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 07:43:03','',''),(2239984,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:43:03','',''),(2240080,'1','139','772',330,'Retail Sale Id 1315260',1902.32,0.00,0.00,0.00,120.40,'2021-12-11 07:47:40','',''),(2240081,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 07:47:40','',''),(2240469,'1','139','772',330,'Retail Sale Id 1315424',120400.00,0.00,0.00,0.00,2000.00,'2021-12-11 08:03:14','',''),(2240470,'1','139','772',330,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-11 08:03:14','',''),(2252068,'1','139','772',330,'Distributed to OPERATIONAL LOSS for sales id:338978',226688.64,0.00,0.00,382.92,0.00,'2021-12-12 06:08:30','',''),(2253696,'1','139',NULL,330,'Purchased from AA RANO NIGERIA LIMITED',0.00,14100000.00,25000.00,0.00,0.00,'2021-12-12 08:05:40','',''),(2253713,'1','139',NULL,330,'Reception corrector for bridging 127095',0.00,0.00,0.00,25000.00,0.00,'2021-12-12 08:07:03','',''),(2253714,'1','139','772',330,'Received from bridging 127095',0.00,0.00,25000.00,0.00,0.00,'2021-12-12 08:07:03','',''),(2253883,'1','139','772',330,'Retail Sale Id 1321708',1902.32,0.00,0.00,0.00,204.68,'2021-12-12 08:18:50','',''),(2253884,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 08:18:50','',''),(2253903,'1','139','772',330,'Retail Sale Id 1321717',632.00,0.00,0.00,0.00,68.00,'2021-12-12 08:20:09','',''),(2253904,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-12 08:20:09','',''),(2253987,'1','139','772',330,'Retail Sale Id 1321754',1580.00,0.00,0.00,0.00,170.00,'2021-12-12 08:25:11','',''),(2253988,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-12 08:25:11','',''),(2254051,'1','139','772',330,'Retail Sale Id 1321791',6320.00,0.00,0.00,0.00,680.00,'2021-12-12 08:30:27','',''),(2254052,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-12 08:30:27','',''),(2254069,'1','139','772',330,'Retail Sale Id 1321806',72240.00,0.00,0.00,0.00,4560.00,'2021-12-12 08:32:47','',''),(2254070,'1','139','772',330,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-12 08:32:47','',''),(2254096,'1','139','772',330,'Retail Sale Id 1321813',3002.00,0.00,0.00,0.00,323.00,'2021-12-12 08:33:52','',''),(2254097,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 08:33:52','',''),(2254122,'1','139','772',330,'Retail Sale Id 1321826',701.52,0.00,0.00,0.00,75.48,'2021-12-12 08:35:16','',''),(2254123,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-12 08:35:16','',''),(2254142,'1','139','772',330,'Retail Sale Id 1321840',1997.12,0.00,0.00,0.00,214.88,'2021-12-12 08:36:32','',''),(2254143,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 08:36:32','',''),(2254160,'1','139','772',330,'Retail Sale Id 1321848',3798.32,0.00,0.00,0.00,408.68,'2021-12-12 08:37:50','',''),(2254161,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 08:37:50','',''),(2254186,'1','139','772',330,'Retail Sale Id 1321858',2528.00,0.00,0.00,0.00,272.00,'2021-12-12 08:39:12','',''),(2254187,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 08:39:12','',''),(2254208,'1','139','772',330,'Retail Sale Id 1321873',1902.32,0.00,0.00,0.00,204.68,'2021-12-12 08:40:28','',''),(2254209,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 08:40:28','',''),(2254233,'1','139','772',330,'Retail Sale Id 1321885',3798.32,0.00,0.00,0.00,408.68,'2021-12-12 08:41:42','',''),(2254234,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 08:41:42','',''),(2254259,'1','139','772',330,'Retail Sale Id 1321891',1264.00,0.00,0.00,0.00,136.00,'2021-12-12 08:42:39','',''),(2254260,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 08:42:39','',''),(2254316,'1','139','772',330,'Retail Sale Id 1321917',3160.00,0.00,0.00,0.00,340.00,'2021-12-12 08:45:50','',''),(2254317,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 08:45:50','',''),(2254332,'1','139','772',330,'Retail Sale Id 1321926',2528.00,0.00,0.00,0.00,272.00,'2021-12-12 08:46:49','',''),(2254333,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 08:46:49','',''),(2254346,'1','139','772',330,'Retail Sale Id 1321936',998.56,0.00,0.00,0.00,107.44,'2021-12-12 08:47:40','',''),(2254347,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 08:47:40','',''),(2254362,'1','139','772',330,'Retail Sale Id 1321944',3798.32,0.00,0.00,0.00,408.68,'2021-12-12 08:48:34','',''),(2254363,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 08:48:34','',''),(2254383,'1','139','772',330,'Retail Sale Id 1321952',3160.00,0.00,0.00,0.00,340.00,'2021-12-12 08:49:23','',''),(2254384,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 08:49:23','',''),(2254426,'1','139','772',330,'Retail Sale Id 1321902',632.00,0.00,0.00,0.00,68.00,'2021-12-12 08:51:20','',''),(2254427,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-12 08:51:20','',''),(2254444,'1','139','772',330,'Retail Sale Id 1321977',4000.56,0.00,0.00,0.00,430.44,'2021-12-12 08:52:32','',''),(2254445,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-12 08:52:32','',''),(2254458,'1','139','772',330,'Retail Sale Id 1321984',1902.32,0.00,0.00,0.00,204.68,'2021-12-12 08:53:32','',''),(2254459,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 08:53:32','',''),(2254485,'1','139','772',330,'Retail Sale Id 1321997',632.00,0.00,0.00,0.00,68.00,'2021-12-12 08:55:57','',''),(2254486,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-12 08:55:57','',''),(2254520,'1','139','772',330,'Retail Sale Id 1322013',632.00,0.00,0.00,0.00,68.00,'2021-12-12 08:57:36','',''),(2254521,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-12 08:57:36','',''),(2254538,'1','139','772',330,'Retail Sale Id 1322023',1497.84,0.00,0.00,0.00,161.16,'2021-12-12 08:58:31','',''),(2254539,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 08:58:31','',''),(2254558,'1','139','772',330,'Retail Sale Id 1322032',4108.00,0.00,0.00,0.00,442.00,'2021-12-12 08:59:42','',''),(2254559,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-12 08:59:42','',''),(2254574,'1','139','772',330,'Retail Sale Id 1322039',1997.12,0.00,0.00,0.00,214.88,'2021-12-12 09:00:42','',''),(2254575,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 09:00:42','',''),(2254582,'1','139','772',330,'Retail Sale Id 1322045',998.56,0.00,0.00,0.00,107.44,'2021-12-12 09:01:29','',''),(2254583,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 09:01:29','',''),(2254608,'1','139','772',330,'Retail Sale Id 1322057',2502.72,0.00,0.00,0.00,269.28,'2021-12-12 09:02:25','',''),(2254609,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-12 09:02:25','',''),(2254641,'1','139','772',330,'Retail Sale Id 1322073',1902.32,0.00,0.00,0.00,204.68,'2021-12-12 09:04:05','',''),(2254642,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 09:04:05','',''),(2254659,'1','139','772',330,'Retail Sale Id 1322083',701.52,0.00,0.00,0.00,75.48,'2021-12-12 09:05:16','',''),(2254660,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-12 09:05:16','',''),(2254693,'1','139','772',330,'Retail Sale Id 1322103',1264.00,0.00,0.00,0.00,136.00,'2021-12-12 09:07:09','',''),(2254694,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 09:07:09','',''),(2254803,'1','139','772',330,'Retail Sale Id 1322156',632.00,0.00,0.00,0.00,68.00,'2021-12-12 09:12:23','',''),(2254804,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-12 09:12:23','',''),(2254847,'1','139','772',330,'Retail Sale Id 1322179',8848.00,0.00,0.00,0.00,952.00,'2021-12-12 09:15:03','',''),(2254848,'1','139','772',330,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-12 09:15:03','',''),(2254905,'1','139','772',330,'Retail Sale Id 1322213',3160.00,0.00,0.00,0.00,340.00,'2021-12-12 09:18:23','',''),(2254906,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 09:18:23','',''),(2255000,'1','139','772',330,'Retail Sale Id 1322259',1902.32,0.00,0.00,0.00,204.68,'2021-12-12 09:24:10','',''),(2255001,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 09:24:10','',''),(2255020,'1','139','772',330,'Retail Sale Id 1322270',4424.00,0.00,0.00,0.00,476.00,'2021-12-12 09:25:13','',''),(2255021,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-12 09:25:13','',''),(2255038,'1','139','772',330,'Retail Sale Id 1322278',1902.32,0.00,0.00,0.00,204.68,'2021-12-12 09:26:35','',''),(2255039,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 09:26:35','',''),(2255088,'1','139','772',330,'Retail Sale Id 1322300',3002.00,0.00,0.00,0.00,323.00,'2021-12-12 09:30:03','',''),(2255089,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 09:30:03','',''),(2255110,'1','139','772',330,'Retail Sale Id 1322310',7900.00,0.00,0.00,0.00,850.00,'2021-12-12 09:30:48','',''),(2255111,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:30:48','',''),(2255150,'1','139','772',330,'Retail Sale Id 1322328',1497.84,0.00,0.00,0.00,161.16,'2021-12-12 09:32:48','',''),(2255151,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 09:32:48','',''),(2255201,'1','139','772',330,'Retail Sale Id 1322351',8532.00,0.00,0.00,0.00,918.00,'2021-12-12 09:35:24','',''),(2255202,'1','139','772',330,'Retail sales',0.00,0.00,0.00,13.50,0.00,'2021-12-12 09:35:24','',''),(2255347,'1','139','772',330,'Retail Sale Id 1322429',5498.40,0.00,0.00,0.00,591.60,'2021-12-12 09:45:53','',''),(2255348,'1','139','772',330,'Retail sales',0.00,0.00,0.00,8.70,0.00,'2021-12-12 09:45:53','',''),(2255367,'1','139','772',330,'Retail Sale Id 1322441',1497.84,0.00,0.00,0.00,161.16,'2021-12-12 09:46:49','',''),(2255368,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 09:46:49','',''),(2255399,'1','139','772',330,'Retail Sale Id 1322450',701.52,0.00,0.00,0.00,75.48,'2021-12-12 09:48:11','',''),(2255400,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-12 09:48:11','',''),(2255427,'1','139','772',330,'Retail Sale Id 1322463',1264.00,0.00,0.00,0.00,136.00,'2021-12-12 09:49:34','',''),(2255428,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 09:49:34','',''),(2255445,'1','139','772',330,'Retail Sale Id 1322472',1497.84,0.00,0.00,0.00,161.16,'2021-12-12 09:50:57','',''),(2255446,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 09:50:57','',''),(2255498,'1','139','772',330,'Retail Sale Id 1322496',3798.32,0.00,0.00,0.00,408.68,'2021-12-12 09:53:08','',''),(2255499,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 09:53:08','',''),(2255522,'1','139','772',330,'Retail Sale Id 1322506',3798.32,0.00,0.00,0.00,408.68,'2021-12-12 09:54:02','',''),(2255523,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 09:54:02','',''),(2255540,'1','139','772',330,'Retail Sale Id 1322514',1902.32,0.00,0.00,0.00,204.68,'2021-12-12 09:54:55','',''),(2255541,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 09:54:55','',''),(2255569,'1','139','772',330,'Retail Sale Id 1322527',998.56,0.00,0.00,0.00,107.44,'2021-12-12 09:55:50','',''),(2255570,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 09:55:50','',''),(2255597,'1','139','772',330,'Retail Sale Id 1322538',3482.32,0.00,0.00,0.00,374.68,'2021-12-12 09:56:52','',''),(2255598,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.51,0.00,'2021-12-12 09:56:52','',''),(2255624,'1','139','772',330,'Retail Sale Id 1322551',1902.32,0.00,0.00,0.00,204.68,'2021-12-12 09:57:54','',''),(2255625,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 09:57:54','',''),(2255644,'1','139','772',330,'Retail Sale Id 1322560',1497.84,0.00,0.00,0.00,161.16,'2021-12-12 09:58:50','',''),(2255645,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 09:58:50','',''),(2255658,'1','139','772',330,'Retail Sale Id 1322565',998.56,0.00,0.00,0.00,107.44,'2021-12-12 09:59:40','',''),(2255659,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 09:59:40','',''),(2255678,'1','139','772',330,'Retail Sale Id 1322576',1497.84,0.00,0.00,0.00,161.16,'2021-12-12 10:00:36','',''),(2255679,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 10:00:36','',''),(2255694,'1','139','772',330,'Retail Sale Id 1322583',998.56,0.00,0.00,0.00,107.44,'2021-12-12 10:01:22','',''),(2255695,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 10:01:22','',''),(2255741,'1','139','772',330,'Retail Sale Id 1322598',180000.00,0.00,0.00,0.00,10800.00,'2021-12-12 10:03:15','',''),(2255742,'1','139','772',330,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-12 10:03:15','',''),(2255795,'1','139','772',330,'Retail Sale Id 1322626',1902.32,0.00,0.00,0.00,204.68,'2021-12-12 10:05:23','',''),(2255796,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 10:05:23','',''),(2255819,'1','139','772',330,'Retail Sale Id 1322645',1200.80,0.00,0.00,0.00,129.20,'2021-12-12 10:06:54','',''),(2255820,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-12 10:06:54','',''),(2255888,'1','139','772',330,'Retail Sale Id 1322680',6952.00,0.00,0.00,0.00,748.00,'2021-12-12 10:10:46','',''),(2255889,'1','139','772',330,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-12 10:10:46','',''),(2255920,'1','139','772',330,'Retail Sale Id 1322694',1902.32,0.00,0.00,0.00,204.68,'2021-12-12 10:11:51','',''),(2255922,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 10:11:51','',''),(2255950,'1','139','772',330,'Retail Sale Id 1322708',1264.00,0.00,0.00,0.00,136.00,'2021-12-12 10:13:27','',''),(2255951,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 10:13:27','',''),(2255974,'1','139','772',330,'Retail Sale Id 1322720',1902.32,0.00,0.00,0.00,204.68,'2021-12-12 10:14:22','',''),(2255975,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 10:14:22','',''),(2256065,'1','139','772',330,'Retail Sale Id 1322773',1997.12,0.00,0.00,0.00,214.88,'2021-12-12 10:19:31','',''),(2256066,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 10:19:31','',''),(2256075,'1','139','772',330,'Retail Sale Id 1322783',3482.32,0.00,0.00,0.00,374.68,'2021-12-12 10:20:42','',''),(2256076,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.51,0.00,'2021-12-12 10:20:42','',''),(2256109,'1','139','772',330,'Retail Sale Id 1322798',1264.00,0.00,0.00,0.00,136.00,'2021-12-12 10:23:17','',''),(2256110,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 10:23:17','',''),(2256129,'1','139','772',330,'Retail Sale Id 1322810',998.56,0.00,0.00,0.00,107.44,'2021-12-12 10:24:23','',''),(2256130,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 10:24:23','',''),(2256183,'1','139','772',330,'Retail Sale Id 1322836',54000.00,0.00,0.00,0.00,3240.00,'2021-12-12 10:26:49','',''),(2256184,'1','139','772',330,'Retail sales',0.00,0.00,0.00,90.00,0.00,'2021-12-12 10:26:49','',''),(2256257,'1','139','772',330,'Retail Sale Id 1322876',998.56,0.00,0.00,0.00,107.44,'2021-12-12 10:30:36','',''),(2256258,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 10:30:36','',''),(2256299,'1','139','772',330,'Retail Sale Id 1322901',1997.12,0.00,0.00,0.00,214.88,'2021-12-12 10:33:20','',''),(2256300,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 10:33:20','',''),(2256367,'1','139','772',330,'Retail Sale Id 1322939',998.56,0.00,0.00,0.00,107.44,'2021-12-12 10:36:32','',''),(2256368,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 10:36:32','',''),(2256427,'1','139','772',330,'Retail Sale Id 1322970',632.00,0.00,0.00,0.00,68.00,'2021-12-12 10:39:52','',''),(2256428,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-12 10:39:52','',''),(2256469,'1','139','772',330,'Retail Sale Id 1322991',3798.32,0.00,0.00,0.00,408.68,'2021-12-12 10:41:33','',''),(2256470,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 10:41:33','',''),(2256506,'1','139','772',330,'Retail Sale Id 1323006',1264.00,0.00,0.00,0.00,136.00,'2021-12-12 10:42:54','',''),(2256507,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 10:42:54','',''),(2256534,'1','139','772',330,'Retail Sale Id 1323015',2218.32,0.00,0.00,0.00,238.68,'2021-12-12 10:44:08','',''),(2256535,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.51,0.00,'2021-12-12 10:44:08','',''),(2256564,'1','139','772',330,'Retail Sale Id 1323030',5997.68,0.00,0.00,0.00,645.32,'2021-12-12 10:45:36','',''),(2256565,'1','139','772',330,'Retail sales',0.00,0.00,0.00,9.49,0.00,'2021-12-12 10:45:36','',''),(2256590,'1','139','772',330,'Retail Sale Id 1323042',3002.00,0.00,0.00,0.00,323.00,'2021-12-12 10:46:33','',''),(2256591,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 10:46:33','',''),(2256622,'1','139','772',330,'Retail Sale Id 1323059',1997.12,0.00,0.00,0.00,214.88,'2021-12-12 10:48:21','',''),(2256623,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 10:48:21','',''),(2256646,'1','139','772',330,'Retail Sale Id 1323077',632.00,0.00,0.00,0.00,68.00,'2021-12-12 10:49:40','',''),(2256647,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-12 10:49:40','',''),(2256687,'1','139','772',330,'Retail Sale Id 1323094',701.52,0.00,0.00,0.00,75.48,'2021-12-12 10:51:34','',''),(2256688,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-12 10:51:34','',''),(2256717,'1','139','772',330,'Retail Sale Id 1323113',998.56,0.00,0.00,0.00,107.44,'2021-12-12 10:53:01','',''),(2256718,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 10:53:01','',''),(2256857,'1','139','772',330,'Retail Sale Id 1323181',3798.32,0.00,0.00,0.00,408.68,'2021-12-12 10:59:00','',''),(2256858,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 10:59:00','',''),(2256881,'1','139','772',330,'Retail Sale Id 1323195',701.52,0.00,0.00,0.00,75.48,'2021-12-12 10:59:58','',''),(2256882,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-12 10:59:58','',''),(2256903,'1','139','772',330,'Retail Sale Id 1323208',998.56,0.00,0.00,0.00,107.44,'2021-12-12 11:00:48','',''),(2256904,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 11:00:48','',''),(2256932,'1','139','772',330,'Retail Sale Id 1323217',998.56,0.00,0.00,0.00,107.44,'2021-12-12 11:01:38','',''),(2256933,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 11:01:38','',''),(2256958,'1','139','772',330,'Retail Sale Id 1323229',1264.00,0.00,0.00,0.00,136.00,'2021-12-12 11:02:44','',''),(2256959,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 11:02:44','',''),(2256982,'1','139','772',330,'Retail Sale Id 1323237',3160.00,0.00,0.00,0.00,340.00,'2021-12-12 11:03:43','',''),(2256983,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 11:03:43','',''),(2257018,'1','139','772',330,'Retail Sale Id 1323259',1902.32,0.00,0.00,0.00,204.68,'2021-12-12 11:05:13','',''),(2257019,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 11:05:13','',''),(2257052,'1','139','772',330,'Retail Sale Id 1323280',1497.84,0.00,0.00,0.00,161.16,'2021-12-12 11:06:47','',''),(2257053,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 11:06:47','',''),(2257088,'1','139','772',330,'Retail Sale Id 1323297',8222.32,0.00,0.00,0.00,884.68,'2021-12-12 11:08:20','',''),(2257089,'1','139','772',330,'Retail sales',0.00,0.00,0.00,13.01,0.00,'2021-12-12 11:08:20','',''),(2257158,'1','139','772',330,'Retail Sale Id 1323333',7900.00,0.00,0.00,0.00,850.00,'2021-12-12 11:10:29','',''),(2257159,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:10:30','',''),(2257174,'1','139','772',330,'Retail Sale Id 1323342',1902.32,0.00,0.00,0.00,204.68,'2021-12-12 11:11:41','',''),(2257175,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 11:11:41','',''),(2257221,'1','139','772',330,'Retail Sale Id 1323364',1497.84,0.00,0.00,0.00,161.16,'2021-12-12 11:13:35','',''),(2257222,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 11:13:35','',''),(2257241,'1','139','772',330,'Retail Sale Id 1323374',4398.72,0.00,0.00,0.00,473.28,'2021-12-12 11:14:58','',''),(2257242,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.96,0.00,'2021-12-12 11:14:58','',''),(2257313,'1','139','772',330,'Retail Sale Id 1323402',1497.84,0.00,0.00,0.00,161.16,'2021-12-12 11:16:45','',''),(2257314,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 11:16:45','',''),(2257347,'1','139','772',330,'Retail Sale Id 1323424',1497.84,0.00,0.00,0.00,161.16,'2021-12-12 11:18:27','',''),(2257348,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 11:18:27','',''),(2257361,'1','139','772',330,'Retail Sale Id 1323440',998.56,0.00,0.00,0.00,107.44,'2021-12-12 11:19:22','',''),(2257362,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 11:19:22','',''),(2257417,'1','139','772',330,'Retail Sale Id 1323458',998.56,0.00,0.00,0.00,107.44,'2021-12-12 11:21:29','',''),(2257418,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 11:21:29','',''),(2257451,'1','139','772',330,'Retail Sale Id 1323476',632.00,0.00,0.00,0.00,68.00,'2021-12-12 11:23:03','',''),(2257452,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-12 11:23:03','',''),(2257475,'1','139','772',330,'Retail Sale Id 1323488',1902.32,0.00,0.00,0.00,204.68,'2021-12-12 11:24:10','',''),(2257476,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 11:24:10','',''),(2257522,'1','139','772',330,'Retail Sale Id 1323510',7900.00,0.00,0.00,0.00,850.00,'2021-12-12 11:26:25','',''),(2257523,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:26:25','',''),(2257572,'1','139','772',330,'Retail Sale Id 1323545',4424.00,0.00,0.00,0.00,476.00,'2021-12-12 11:28:38','',''),(2257573,'1','139','772',330,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-12 11:28:38','',''),(2257596,'1','139','772',330,'Retail Sale Id 1323564',998.56,0.00,0.00,0.00,107.44,'2021-12-12 11:29:55','',''),(2257597,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 11:29:55','',''),(2257614,'1','139','772',330,'Retail Sale Id 1323574',1997.12,0.00,0.00,0.00,214.88,'2021-12-12 11:31:03','',''),(2257615,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 11:31:03','',''),(2257670,'1','139','772',330,'Retail Sale Id 1323596',3160.00,0.00,0.00,0.00,340.00,'2021-12-12 11:33:28','',''),(2257671,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 11:33:28','',''),(2257705,'1','139','772',330,'Retail Sale Id 1323615',701.52,0.00,0.00,0.00,75.48,'2021-12-12 11:35:07','',''),(2257706,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-12 11:35:07','',''),(2257729,'1','139','772',330,'Retail Sale Id 1323627',1580.00,0.00,0.00,0.00,170.00,'2021-12-12 11:36:27','',''),(2257730,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-12 11:36:27','',''),(2257757,'1','139','772',330,'Retail Sale Id 1323644',1580.00,0.00,0.00,0.00,170.00,'2021-12-12 11:37:56','',''),(2257758,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-12 11:37:56','',''),(2257777,'1','139','772',330,'Retail Sale Id 1323652',1902.32,0.00,0.00,0.00,204.68,'2021-12-12 11:38:58','',''),(2257778,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 11:38:58','',''),(2257804,'1','139','772',330,'Retail Sale Id 1323666',3482.32,0.00,0.00,0.00,374.68,'2021-12-12 11:40:10','',''),(2257805,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.51,0.00,'2021-12-12 11:40:10','',''),(2257844,'1','139','772',330,'Retail Sale Id 1323679',6320.00,0.00,0.00,0.00,680.00,'2021-12-12 11:41:46','',''),(2257845,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-12 11:41:46','',''),(2257893,'1','139','772',330,'Retail Sale Id 1323706',1902.32,0.00,0.00,0.00,204.68,'2021-12-12 11:43:49','',''),(2257894,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 11:43:49','',''),(2257961,'1','139','772',330,'Retail Sale Id 1323739',1902.32,0.00,0.00,0.00,204.68,'2021-12-12 11:47:12','',''),(2257962,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 11:47:12','',''),(2257991,'1','139','772',330,'Retail Sale Id 1323421',1497.84,0.00,0.00,0.00,161.16,'2021-12-12 11:48:52','',''),(2257992,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 11:48:52','',''),(2258038,'1','139','772',330,'Retail Sale Id 1323773',1264.00,0.00,0.00,0.00,136.00,'2021-12-12 11:50:57','',''),(2258039,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 11:50:57','',''),(2258062,'1','139','772',330,'Retail Sale Id 1323784',3798.32,0.00,0.00,0.00,408.68,'2021-12-12 11:51:55','',''),(2258063,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 11:51:55','',''),(2258088,'1','139','772',330,'Retail Sale Id 1323798',998.56,0.00,0.00,0.00,107.44,'2021-12-12 11:52:50','',''),(2258089,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 11:52:50','',''),(2258106,'1','139','772',330,'Retail Sale Id 1323805',1997.12,0.00,0.00,0.00,214.88,'2021-12-12 11:53:39','',''),(2258107,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 11:53:39','',''),(2258127,'1','139','772',330,'Retail Sale Id 1323815',1264.00,0.00,0.00,0.00,136.00,'2021-12-12 11:54:34','',''),(2258128,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 11:54:34','',''),(2258188,'1','139','772',330,'Retail Sale Id 1323846',632.00,0.00,0.00,0.00,68.00,'2021-12-12 11:57:43','',''),(2258189,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-12 11:57:43','',''),(2258228,'1','139','772',330,'Retail Sale Id 1323865',2212.00,0.00,0.00,0.00,238.00,'2021-12-12 11:59:44','',''),(2258229,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-12 11:59:44','',''),(2258253,'1','139','772',330,'Retail Sale Id 1323877',632.00,0.00,0.00,0.00,68.00,'2021-12-12 12:01:15','',''),(2258254,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-12 12:01:15','',''),(2258280,'1','139','772',330,'Retail Sale Id 1323888',3798.32,0.00,0.00,0.00,408.68,'2021-12-12 12:02:46','',''),(2258281,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 12:02:46','',''),(2258302,'1','139','772',330,'Retail Sale Id 1323899',1497.84,0.00,0.00,0.00,161.16,'2021-12-12 12:03:53','',''),(2258303,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 12:03:53','',''),(2258322,'1','139','772',330,'Retail Sale Id 1323909',1902.32,0.00,0.00,0.00,204.68,'2021-12-12 12:05:03','',''),(2258323,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 12:05:03','',''),(2258342,'1','139','772',330,'Retail Sale Id 1323916',3160.00,0.00,0.00,0.00,340.00,'2021-12-12 12:06:44','',''),(2258343,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 12:06:44','',''),(2258358,'1','139','772',330,'Retail Sale Id 1323925',632.00,0.00,0.00,0.00,68.00,'2021-12-12 12:07:44','',''),(2258359,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-12 12:07:44','',''),(2258382,'1','139','772',330,'Retail Sale Id 1323937',632.00,0.00,0.00,0.00,68.00,'2021-12-12 12:09:04','',''),(2258383,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-12 12:09:04','',''),(2258394,'1','139','772',330,'Retail Sale Id 1323944',6320.00,0.00,0.00,0.00,680.00,'2021-12-12 12:10:03','',''),(2258395,'1','139','772',330,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-12 12:10:03','',''),(2258410,'1','139','772',330,'Retail Sale Id 1323954',4000.56,0.00,0.00,0.00,430.44,'2021-12-12 12:10:58','',''),(2258411,'1','139','772',330,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-12 12:10:58','',''),(2258436,'1','139','772',330,'Retail Sale Id 1323966',3002.00,0.00,0.00,0.00,323.00,'2021-12-12 12:12:04','',''),(2258437,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 12:12:04','',''),(2258496,'1','139','772',330,'Retail Sale Id 1323990',701.52,0.00,0.00,0.00,75.48,'2021-12-12 12:14:45','',''),(2258497,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-12 12:14:45','',''),(2258512,'1','139','772',330,'Retail Sale Id 1323998',1997.12,0.00,0.00,0.00,214.88,'2021-12-12 12:15:42','',''),(2258513,'1','139','772',330,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 12:15:42','',''),(2258548,'1','139','772',330,'Retail Sale Id 1324013',2844.00,0.00,0.00,0.00,306.00,'2021-12-12 12:17:06','',''),(2258549,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-12 12:17:06','',''),(2258576,'1','139','772',330,'Retail Sale Id 1324032',632.00,0.00,0.00,0.00,68.00,'2021-12-12 12:18:33','',''),(2258577,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-12 12:18:33','',''),(2258610,'1','139','772',330,'Retail Sale Id 1324043',998.56,0.00,0.00,0.00,107.44,'2021-12-12 12:19:56','',''),(2258611,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 12:19:56','',''),(2258650,'1','139','772',330,'Retail Sale Id 1324068',7584.00,0.00,0.00,0.00,816.00,'2021-12-12 12:22:28','',''),(2258651,'1','139','772',330,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-12 12:22:28','',''),(2258696,'1','139','772',330,'Retail Sale Id 1324088',3160.00,0.00,0.00,0.00,340.00,'2021-12-12 12:24:53','',''),(2258697,'1','139','772',330,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 12:24:53','',''),(2258782,'1','139','772',330,'Retail Sale Id 1324121',1497.84,0.00,0.00,0.00,161.16,'2021-12-12 12:27:43','',''),(2258783,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 12:27:43','',''),(2258832,'1','139','772',330,'Retail Sale Id 1324148',1497.84,0.00,0.00,0.00,161.16,'2021-12-12 12:29:53','',''),(2258833,'1','139','772',330,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 12:29:53','',''),(2258895,'1','139','772',330,'Retail Sale Id 1324178',2844.00,0.00,0.00,0.00,306.00,'2021-12-12 12:32:12','',''),(2258896,'1','139','772',330,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-12 12:32:12','',''),(2258915,'1','139','772',330,'Retail Sale Id 1324191',802.64,0.00,0.00,0.00,86.36,'2021-12-12 12:33:13','',''),(2258916,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.27,0.00,'2021-12-12 12:33:13','',''),(2259024,'1','139','772',330,'Retail Sale Id 1324237',701.52,0.00,0.00,0.00,75.48,'2021-12-12 12:38:03','',''),(2259025,'1','139','772',330,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-12 12:38:03','',''),(2259107,'1','139','772',330,'Retail Sale Id 1324287',145200.00,0.00,0.00,0.00,8712.00,'2021-12-12 12:42:18','',''),(2259108,'1','139','772',330,'Retail sales',0.00,0.00,0.00,242.00,0.00,'2021-12-12 12:42:18','',''),(2259141,'1','139','772',330,'Retail Sale Id 1324303',5997.68,0.00,0.00,0.00,645.32,'2021-12-12 12:43:52','',''),(2259142,'1','139','772',330,'Retail sales',0.00,0.00,0.00,9.49,0.00,'2021-12-12 12:43:52','',''),(2259262,'1','139','772',330,'Retail Sale Id 1