-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_138
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_138`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_138` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_138`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3205 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2569,20005,'',0,'22','1','138','PURCHASES','','2020-08-10 18:35:15',5,0.00,0.00,'','479','2020-08-10 18:35:15','479',0,1),(2570,20013,'',0,'20','1','138','SALES','','2020-08-10 18:35:37',5,0.00,0.00,'','479','2020-08-10 18:35:37','479',0,1),(2571,40012,'',0,'6.1','1','138','CASH','','2020-08-10 18:35:57',5,0.00,0.00,'','479','2020-08-10 18:35:57','479',0,1),(2572,400082,'',0,'24','1','138','SALARIES & WAGES','','2020-08-10 18:36:26',5,0.00,0.00,'','479','2020-08-10 18:36:26','479',0,1),(2573,400215,'',0,'2','1','138','ZBN(POS):1015965368','','2020-08-10 18:37:07',5,0.00,0.00,'','479','2020-08-10 18:37:07','479',0,1),(2574,400216,'',0,'2','1','138','ZB(E-BILL)1015372548','','2020-08-10 18:37:36',5,0.00,0.00,'','479','2020-08-10 18:37:36','479',0,1),(2575,400083,'',0,'24','1','138','PURCHASES','','2020-08-10 18:38:51',5,0.00,0.00,'','479','2020-08-10 18:38:51','479',0,1),(2656,400107,'',0,'24','1','138','OPERATIONAL LOSS','ALL LOSSES DURING SALES/RECEPTION.','2020-08-13 13:57:03',5,0.00,0.00,'','479','2020-08-13 13:57:03','479',0,1),(2899,400316,'',0,'2','1','138','DANKANO-EBILLS(ZNB:1014717618)','','2020-10-29 13:31:07',5,0.00,0.00,'','489','2020-10-29 13:31:07','489',0,1),(3201,400480,'',0,'2','1','138','FID POS COLLECTION-5620141491','','2021-02-26 15:57:03',5,0.00,0.00,'','489','2021-02-26 15:57:03','489',0,1),(3202,400481,'',0,'2','1','138','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:36:26',5,0.00,0.00,'','792','2023-02-20 14:36:26','792',0,0),(3203,400482,'',0,'2','1','138','ZNB BANK AA RANO:-1227959823','ZNB BANK AA RANO KATAMPE','2023-03-08 11:33:59',5,0.00,0.00,'','792','2023-03-08 11:33:59','792',0,0),(3204,400483,'',0,'2','1','138','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:38:59',5,0.00,0.00,'2023-03-15','792','2023-03-17 13:54:29','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4297 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1595,'','1','138','ALL DEALER','BUHARI','08136784069','bigaya78@gmail.com','abuja','fct','katampe abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 10:26:40',5,'500','2020-08-13 10:26:40','500'),(1605,'','1','138','OPERATIONAL LOSS','HAFIZ NURA GAYA','08069129774','hgaya@aaranonigeria.com','KANO','KANO','AA RANO HOUSE HOTORO KANO.','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 13:55:56',5,'479','2020-08-13 13:55:56','479'),(2017,'','1','138','AARANO','TIM GAS','08033174780','bigaya78@gmail.com','abuja','fct','JAHI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 08:06:30',5,'500','2021-02-17 08:06:30','500'),(2018,'','1','138','EZE GAS ','EZE GAS ','08034261741','bigaya78@gmail.com','abuja','fct','DUTSE MAKARANTA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 08:12:33',5,'500','2021-02-21 09:32:12','500'),(2019,'','1','138','ONYEDIKA ','ONYEDIKA GAS','08034905328','bigaya78@gmail.com','abuja','fct','DUTSE ALHAJI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 08:14:03',5,'500','2021-02-17 08:14:03','500'),(2020,'','1','138','OKWISCO GAS','OKWISCO','08037258644','bigaya78@gmail.com','abuja','fct','NNPC BEBRIGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 08:22:31',5,'500','2021-02-17 08:22:31','500'),(2023,'','1','138','AKPUGO','A.K GAS','08095643669','bigaya78@gmail.com','abuja','fct','RANO H/Q','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 09:24:44',5,'500','2021-02-17 09:24:44','500'),(2024,'','1','138','EMEKA GAS','EMEKA','08069504673','bigaya78@gmail.com','abuja','fct','JAYI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 09:37:55',5,'500','2021-02-17 09:37:55','500'),(2025,'','1','138','UCHE GAS','UCHE GAS','07067771951','bigaya78@gmail.com','abuja','fct','GISHIRI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 10:10:14',5,'500','2021-02-17 10:10:14','500'),(2027,'','1','138','PAPA GAS','PAPA','07013070555','bigaya78@gmail.com','abuja','fct','GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 10:21:33',5,'500','2021-02-17 10:21:33','500'),(2029,'','1','138','OKEY GAS LTD','OKEY','07030844496','bigaya78@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 10:34:06',5,'500','2021-02-17 10:34:06','500'),(2031,'','1','138','SOLO DUTSE','SOLO','08085597382','bigaya78@gmail.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 12:00:34',5,'500','2021-02-17 12:00:34','500'),(2032,'','1','138','VICTOR GAS','VICTOR','08050401560','bigaya78@gmail.com','abuja','fct','JAHI 1','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 12:27:19',5,'500','2021-02-17 12:27:19','500'),(2033,'','1','138','NEKON GAS LTD','NEKON','08107550054','bigaya78@gmail.com','abuja','fct','AJEGULE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 12:30:54',5,'500','2021-04-09 08:20:17','500'),(2034,'','1','138','NAPSON GAS','NAPSON','08035918906','bigaya78@gmail.com','abuja','fct','GARKI ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 12:34:31',5,'500','2021-02-17 12:34:31','500'),(2035,'','1','138','BUM GAS','BUM','07068123431','bigaya78@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 12:45:41',5,'500','2021-02-17 12:45:41','500'),(2036,'','1','138','RABIU GAS','RABIU','08063935299','bigaya78@gmail.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 13:08:23',5,'500','2021-02-17 13:08:23','500'),(2037,'','1','138','UC GAS','MARK','08071025272','bigaya78@gmail.com','abuja','fct','DUTSE POLICE SYMBOL','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 13:28:56',5,'500','2021-02-17 13:28:56','500'),(2038,'','1','138','EVER BRIGHT GAS','EVER BRIGHT','08065399451','bigaya78@gmail.com','abuja','fct','WUYE F. QTRS','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 13:46:56',5,'500','2021-02-17 13:46:56','500'),(2039,'','1','138','WINNERS GAS LTD','OLAWINNER','08038065178','bigaya78@gmail.com','abuja','fct','LUGBE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 13:54:58',5,'500','2021-02-17 14:02:03','500'),(2041,'','1','138','GAS URGENTLY','BISOLA','07038507805','bigaya78@gmail.com','abuja','fct','MAITAMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 14:42:12',5,'500','2021-02-17 14:42:12','500'),(2042,'','1','138','KOLA GAS','KOREDEKOLA','08138447802','bigaya78@gmail.com','abuja','fct','GUDU PRINCES AREA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 14:57:59',5,'500','2021-02-17 14:57:59','500'),(2044,'','1','138','AKA GAS','AKA','09152182186','bigaya78@gmail.com','abuja','fct','KADO ESTATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 16:17:39',5,'500','2021-02-17 16:17:39','500'),(2045,'','1','138','NAIJA OIL AND GAS','NAIJA GAS','07068252188','bigaya78@gmail.com','abuja','fct','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-18 07:26:41',5,'500','2021-02-18 07:26:41','500'),(2048,'','1','138','AMOS GAS ','BARNABAS AMOS','08062151608','bigaya78@gmail.com','abuja','fct','MARABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-18 08:15:28',5,'500','2021-02-21 09:31:16','500'),(2049,'','1','138','ROYAL ALKO GAS','ROYAL GAS','07030152943','bigaya78@gmail.com','abuja','fct','ASOKORO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-18 08:28:47',5,'500','2021-02-18 08:28:47','500'),(2050,'','1','138','MICHAEL GAS ','MICHAEL GAS','08063051043','bigaya78@gmail.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-18 09:01:03',5,'500','2021-02-21 09:15:57','500'),(2052,'','1','138','JOE GAS ','JOE GAS','07034133689','bigaya78@gmail.com','abuja','fct','CITEC GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-18 11:06:08',5,'500','2021-02-21 09:30:33','500'),(2053,'','1','138','NIKON GAS ','NIKON GAS','08107550054','bigaya78@gmail.com','abuja','fct','AJEGULE ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-18 11:10:01',5,'500','2021-02-21 09:30:01','500'),(2055,'','1','138','DELP GAS ','DELP GAS','09066455665','hafiz@aaranonigeria.com','abuja','fct','MABUSHI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-18 11:12:59',5,'500','2021-02-21 09:27:50','500'),(2057,'','1','138','JUMBO GAS ','JUMBO GAS','07031138684','hafiz@aaranonigeria.com','abuja','fct','A1 AWA PLAZA DAWAKI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-18 11:28:35',5,'500','2021-02-21 09:27:03','500'),(2058,'','1','138','ZICO GAS','ZICO','08060924427','bigaya78@gmail.com','abuja','fct','WUSE 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-18 11:49:48',5,'500','2021-02-18 11:49:48','500'),(2059,'','1','138','GEORGE GAS','GEORGE','08033451123','bigaya78@gmail.com','abuja','fct','JAHI 1','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-18 11:51:32',5,'500','2021-02-18 11:51:32','500'),(2061,'','1','138','ENE GAS NIG. LTD','ENE','08182101771','bigaya78@gmail.com','abuja','fct','AREA 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-18 15:47:12',5,'500','2021-02-18 15:47:12','500'),(2063,'','1','138','SOLOMON MPAPE GAS','SOLO MPAPE','08051625176','bigaya78@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-19 10:52:36',5,'500','2021-02-19 10:52:36','500'),(2064,'','1','138','A.Y. GAS LTD','A.Y. MABUSHI','07032919407','bigaya78@gmail.com','abuja','fct','MABUSHI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-19 12:01:56',5,'500','2021-02-19 12:01:56','500'),(2065,'','1','138','I.K. GAS ','I.K GAS','08033073565','bigaya78@gmail.com','abuja','fct','OANDO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-19 12:35:44',5,'500','2021-02-24 13:43:30','500'),(2066,'','1','138','O. EDESON GLOBAL VENT.','EDESON','08036782042','bigaya78@gmail.com','abuja','fct','PRINCE AND PRINCES','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-19 13:33:16',5,'500','2021-02-19 13:33:16','500'),(2068,'','1','138','KANE GAS LTD','MR. KANE','07030150069','bigaya78@gmail.com','abuja','fct','MAITAMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-19 15:13:57',5,'500','2021-02-19 15:13:57','500'),(2069,'','1','138','OIL BASE GAS ','OIL BASE','08094500991','bigaya78@gmail.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-19 15:21:49',5,'500','2021-02-28 15:44:43','500'),(2071,'','1','138','CHICHRISEA GAS ','CHICHRISEA GAS','08037661001','hafiz@aaranonigeria.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 08:32:33',5,'500','2021-02-21 09:26:19','500'),(2072,'','1','138','CLEMENT GAS ','CLEMENT GAS','07061899146','hafiz@aaranonigeria.com','abuja','fct','KWAI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 08:33:27',5,'500','2021-02-21 09:25:39','500'),(2073,'','1','138','PAL0 PLACE GAS ','PALOUR','08064075455','hafiz@aaranonigeria.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 08:42:54',5,'500','2021-02-21 09:24:45','500'),(2074,'','1','138','EFINE GAS ','EFINE MPAPE','08035962521','hafiz@aaranonigeria.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 09:04:51',5,'500','2021-02-21 10:33:06','500'),(2075,'','1','138','EMMY GAS ','EMMY GAS','08037041876','hafiz@aaranonigeria.com','abuja','fct','WUYE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 09:38:33',5,'500','2021-02-21 09:23:48','500'),(2076,'','1','138','RABIU GAS DUTSE','RABIU GAS','08063935299','hafiz@aaranonigeria.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 09:52:49',5,'500','2021-02-21 09:23:09','500'),(2077,'','1','138','PAPA GWARIMPE GAS','PAPA GAS','07013070555','hafiz@aaranonigeria.com','abuja','fct','GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 10:06:34',5,'500','2021-02-20 10:06:34','500'),(2078,'','1','138','AGIDO GAS ','AGIDO GAS','08132737927','hafiz@aaranonigeria.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 10:45:18',5,'500','2021-02-21 09:20:51','500'),(2079,'','1','138','EMMA GAS ','EMMA GAS','08140062063','hafiz@aaranonigeria.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 10:53:19',5,'500','2021-02-21 09:22:19','500'),(2080,'','1','138','EASY ACCESS GAS','EASY ACCESS','08109358186','hafiz@aaranonigeria.com','abuja','fct','GISHIRI ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 11:09:51',5,'500','2021-02-20 11:09:51','500'),(2081,'','1','138','EMMERSON GAS ','EMMERSON GAS','08063366941','hafiz@aaranonigeria.com','abuja','fct','ZONE 1','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 11:18:04',5,'500','2021-02-21 09:17:14','500'),(2082,'','1','138','PAPA BF GAS ','BF GAS','08034524579','hafiz@aaranonigeria.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 11:39:15',5,'500','2021-02-21 09:21:42','500'),(2083,'','1','138','YUNUSA GAS ','YUNUSA GAS','08035931975','hafiz@aaranonigeria.com','abuja','fct','LUNGI BARRACK','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 12:05:22',5,'500','2021-02-21 09:16:34','500'),(2084,'','1','138','MELODY GAS SHOP','MELODY GAS','09019753744','hafiz@aaranonigeria.com','abuja','fct','BEGGER','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 12:17:47',5,'500','2021-02-20 12:17:47','500'),(2090,'','1','138','EZU GAS','EZU','08066614047','bigaya78@gmail.com','abuja','fct','GISHIRI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 13:05:27',5,'500','2021-02-20 13:05:27','500'),(2091,'','1','138','SAMSY GAS SHOP','SAMSY GAS','08063653220','hafiz@aaranonigeria.com','abuja','fct','MASHAFA ROAD MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 14:22:21',5,'500','2021-12-23 17:13:13','500'),(2092,'','1','138','M AND  B GAS','M AND B','08071625300','bigaya78@gmail.com','abuja','fct','KUBWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 16:17:24',5,'500','2021-02-20 16:17:24','500'),(2093,'','1','138','HUMBLE GAS','HUMBLE','08069836312','bigaya78@gmail.com','abuja','fct','GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 16:48:14',5,'500','2021-02-20 16:48:14','500'),(2094,'','1','138','AMAZING GRACE GAS','AMAZING GRACE','07034315405','hafiz@aaranonigeria.com','abuja','fct','AIRPORT ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 07:59:56',5,'500','2021-02-21 07:59:56','500'),(2097,'','1','138','EVER BEST GAS','EVER BEST','08035937780','bigaya78@gmail.com','abuja','fct','SECTOR F. CAR WASH','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 08:16:06',5,'500','2021-02-21 08:16:06','500'),(2101,'','1','138','M.D.GAS','M.D.','07068971864','bigaya78@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 08:29:13',5,'500','2021-02-21 08:29:13','500'),(2110,'','1','138','SUNNY GAS','SUNNY','08036860643','bigaya78@gmail.com','abuja','fct','AREA 1','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 09:37:05',5,'500','2021-02-21 09:37:05','500'),(2111,'','1','138','WAZOBIYA','WZBY','08120781783','bigaya78@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 09:47:36',5,'500','2021-02-21 09:47:36','500'),(2112,'','1','138','MUSA GAS','MUSA','07067149178','bigaya78@gmail.com','abuja','fct','MPape','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 10:15:16',5,'500','2021-02-21 10:15:16','500'),(2113,'','1','138','SAMO GAS','Mr. SAMO','08073414109','bigaya78@gmail.com','abuja','fct','DURUMI 1','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 10:50:41',5,'500','2021-02-21 10:50:41','500'),(2115,'','1','138','K.C.AYA GAS','K.C. AYA','08023195485','bigaya78@gmail.com','abuja','fct','AYA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 11:21:56',5,'500','2021-02-21 11:21:56','500'),(2116,'','1','138','GODSWILL GAS','GODSWILL','080-38899231','bigaya78@gmail.com','abuja','fct','GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 11:30:41',5,'500','2021-02-21 11:30:41','500'),(2117,'','1','138','U.C.DENCO','UC DENCO','08036240053','bigaya78@gmail.com','abuja','fct','KUBWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 11:43:47',5,'500','2021-02-21 11:43:47','500'),(2119,'','1','138','D-LIGHT GAS','D-LIGHT','08107591053','bigaya78@gmail.com','abuja','fct','MABUSHI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 11:48:45',5,'500','2021-02-21 11:48:45','500'),(2120,'','1','138','RAIN GAS  SHOP','RAIN GAS','08072968020','hafiz@aaranonigeria.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 12:48:12',5,'500','2021-02-21 12:48:12','500'),(2121,'','1','138','IFANYI MPAPE GAS','IFANYI MPAPE','08032216296','hafiz@aaranonigeria.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 12:57:55',5,'500','2021-02-21 12:57:55','500'),(2124,'','1','138','ONYEMA GAS','ONYEMA','08119626829','bigaya78@gmail.com','abuja','fct','ASOKORO EXT.','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 13:56:00',5,'500','2021-02-21 13:56:00','500'),(2125,'','1','138','WILLINS GAS','WILLINS','07036352014','bigaya78@gmail.com','abuja','fct','NICON JUNCTION','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 14:25:48',5,'500','2021-02-21 14:25:48','500'),(2126,'','1','138','GODSTIME GAS','GODSTIME','08030836198','bigaya78@gmail.com','abuja','fct','TIFA GARRAGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 16:01:51',5,'500','2021-02-21 16:01:51','500'),(2127,'','1','138','DUMEZ MPAPE GAS','DUMEZ','08032947457','hafiz@aaranonigeria.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 16:28:28',5,'500','2021-02-21 16:28:28','500'),(2130,'','1','138','TIM GAS SHOP','TIM GAS','08033174780','hafiz@aaranonigeria.com','abuja','fct','JAHI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 06:35:34',5,'500','2021-02-22 06:35:34','500'),(2131,'','1','138','K.S GAS SHOP','K.S GAS','08183113920','hafiz@aaranonigeria.com','abuja','fct','GISHIRI BALA ESTASTE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 07:20:02',5,'500','2021-02-22 07:20:02','500'),(2132,'','1','138','LAWI  GAS SHOP','LAWI GAS','08065621595','hafiz@aaranonigeria.com','abuja','fct','GARKI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 08:06:56',5,'500','2021-02-22 08:06:56','500'),(2135,'','1','138','TO BEST GAS SHOP','TO BEST','08035899212','hafiz@aaranonigeria.com','abuja','fct','GARKI AREA 11','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 08:43:08',5,'500','2021-02-22 08:43:08','500'),(2137,'','1','138','DASAT GAS SHOP','DASAT GAS','08119675533','hafiz@aaranonigeria.com','abuja','fct','GUZAFE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 09:19:46',5,'500','2021-02-22 09:19:46','500'),(2140,'','1','138','TONY GAS','TONY','08036050677','bigaya78@gmail.com','abuja','fct','TIFA GARRAGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 09:40:46',5,'500','2021-02-22 09:40:46','500'),(2141,'','1','138','OSYBES GAS','OSYBES','07036759431','bigaya78@gmail.com','abuja','fct','MABUSHI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 10:05:56',5,'500','2021-02-22 10:05:56','500'),(2142,'','1','138','ANYTHING GAS','ANYTHING','08167579066','bigaya78@gmail.com','abuja','fct','JAHI 1','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 10:18:00',5,'500','2021-02-22 10:18:00','500'),(2143,'','1','138','HABU SMALL MPAPE','HABU','08171952327','bigaya78@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 10:41:08',5,'500','2021-02-22 10:41:08','500'),(2146,'','1','138','PETER GAS','PETER','07036188103','bigaya78@gmail.com','abuja','fct','CENTRAL AREA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 11:53:24',5,'500','2021-02-22 11:53:24','500'),(2149,'','1','138','ONYEKA GAS','ONYEKA','08033073565','bigaya78@gmail.com','abuja','fct','KATAMPE ESTATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 12:45:26',5,'500','2021-02-22 12:45:26','500'),(2150,'','1','138','KAMIS GAS ','KAMIS GAS','08172361541','hafiz@aaranonigeria.com','KWAI','KADUNA','KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 13:27:51',5,'500','2021-02-24 13:41:20','500'),(2151,'','1','138','GRACE GAS SHOP','GRACE GAS','08096927410','hafiz@aaranonigeria.com','abuja','fct','MABUSHI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 13:52:15',5,'500','2021-02-22 13:52:15','500'),(2157,'','1','138','S.K.GAS','S.K.','08065667327','bigaya78@gmail.com','abuja','fct','MAITAMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 16:21:38',5,'500','2021-02-22 16:21:38','500'),(2158,'','1','138','I.K.GAS DUTSE','I.K.','08064510351','bigaya78@gmail.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 16:40:20',5,'500','2021-02-22 16:40:20','500'),(2159,'','1','138','KC GWARIMPA GAS ','KC GAS PAPA','08035970819','hafiz@aaranonigeria.com','abuja','fct','GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-23 07:10:10',5,'500','2021-03-12 09:47:59','500'),(2160,'','1','138','DAN GAS','DAN','08068565651','bigaya78@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-23 08:58:20',5,'500','2021-02-23 08:58:20','500'),(2161,'','1','138','ASOKORO GAS','ASOKORO','07055481392','bigaya78@gmail.com','abuja','fct','ASOKORO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-23 09:30:38',5,'500','2021-02-23 09:30:38','500'),(2175,'','1','138','0TALE GAS','OTALE','08037388762','bigaya78@gmail.com','abuja','fct','KUBWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-23 17:18:00',5,'500','2021-02-23 17:18:00','500'),(2177,'','1','138','WILLIAMS GAS SHOP','WILLIAMS GAS','08103130061','hafiz@aaranonigeria.com','abuja','fct','DAWAKI ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-24 07:55:16',5,'500','2021-02-24 07:55:16','500'),(2182,'','1','138','EVERGREEN GAS','EVERGREEN','08035861408','bigaya78@gmail.com','abuja','fct','GAMES VILLAGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-24 11:55:09',5,'500','2021-02-24 11:55:09','500'),(2186,'','1','138','CUE GAS','CUE','08035400672','bigaya78@gmail.com','abuja','fct','WUSE ZONE  2','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-24 14:41:30',5,'500','2021-02-24 14:41:30','500'),(2193,'','1','138','ABUBAKAR HABU GAS','ABUBAKAR GAS','07036068441','hafiz@aaranonigeria.com','abuja','fct','WUSE  II','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-26 07:09:03',5,'500','2021-02-26 07:09:03','500'),(2194,'','1','138','EMMENUEL GAS SHIOP','EMMANUEL GAS','08141266850','hafiz@aaranonigeria.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-26 07:26:57',5,'500','2021-02-26 07:26:57','500'),(2195,'','1','138','NIC GAS SHOP','NIC GAS','070309196502','hafiz@aaranonigeria.com','abuja','fct','GARKI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-26 07:36:20',5,'500','2021-02-26 07:36:20','500'),(2196,'','1','138','ASUK GAS SHOP','ASUK GAS','08130066995','hafiz@aaranonigeria.com','abuja','fct','AREA 10','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-26 08:02:30',5,'500','2021-02-26 08:02:30','500'),(2198,'','1','138','EMMA BEST GAS','EMMABEST','08068502811','bigaya78@gmail.com','abuja','fct','GARKI ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-26 09:10:55',5,'500','2021-02-26 09:10:55','500'),(2199,'','1','138','ISAH GAS','ISAH','08036456147','bigaya78@gmail.com','abuja','fct','GARKI ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-26 09:24:01',5,'500','2021-02-26 09:24:01','500'),(2206,'','1','138','UPTYNE GAS','UPTYNE','07064744710','bigaya78@gmail.com','abuja','fct','NO;30 GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-26 10:51:56',5,'500','2021-02-26 10:51:56','500'),(2209,'','1','138','SAMTINO GAS SHOP','SAMTINO GAS','08058379882','hafiz@aaranonigeria.com','abuja','fct','DUTSE MAKARANTA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-26 12:28:19',5,'500','2021-02-26 12:28:19','500'),(2210,'','1','138','LOLO GAS SHOP','LOLO GAS','08035958700','hafiz@aaranonigeria.com','abuja','fct','PRINCE AND PRINCESS','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-26 12:37:03',5,'500','2021-02-26 12:37:03','500'),(2211,'','1','138','OTALE GAS','OTALE','08037388762','bigaya78@gmail.com','abuja','fct','KUBWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-26 13:06:48',5,'500','2021-02-26 13:06:48','500'),(2215,'','1','138','CHIWAMS GAS','CHIWAM','08135534062','bigaya78@gmail.com','abuja','fct','GARKI AREA 3','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-26 16:10:30',5,'500','2021-02-26 16:10:30','500'),(2217,'','1','138','BLESSING GAS','BLESSING','07034750366','bigaya78@gmail.com','abuja','fct','LUGBE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-26 16:15:21',5,'500','2021-02-26 16:15:21','500'),(2218,'','1','138','JONNAH GAS SHOP','JONNAH GAS','07030307428','hafiz@aaranonigeria.com','abuja','fct','AREA 1','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-27 07:03:11',5,'500','2021-02-27 07:03:11','500'),(2219,'','1','138','KC DAWAKI GAS SHOP','KC DAWAKI GAS','08065812051','hafiz@aaranonigeria.com','abuja','fct','DAWAKI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-27 07:24:00',5,'500','2021-02-27 07:24:00','500'),(2220,'','1','138','CHI MU CHI GAS ','CHI MU CHI GAS','08034065478','hafiz@aaranonigeria.com','abuja','fct','KUBWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-27 09:23:35',5,'500','2021-11-02 08:56:22','500'),(2222,'','1','138','BISOLA GAS SHOP','BISOLA GAS','07038507805','hafiz@aaranonigeria.com','abuja','fct','AMAZON MAITAMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-27 11:04:40',5,'500','2021-02-27 11:04:40','500'),(2225,'','1','138','ERICSON GAS PLANT','ERICSON GAS','08172361541','hafiz@aaranonigeria.com','abuja','fct','KWAI KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-27 12:31:28',5,'500','2021-02-27 12:31:28','500'),(2227,'','1','138','WILLIE GAS','WILLIE','08035929405','bigaya78@gmail.com','abuja','fct','AIRPORT ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-27 14:08:01',5,'500','2021-02-27 14:08:01','500'),(2228,'','1','138','VICHUGOS GAS SHOP','VICHUGOS GAS','07034694165','hafiz@aaranonigeria.com','abuja','fct','AIRPORT ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-27 16:58:47',5,'500','2021-02-27 16:58:47','500'),(2230,'','1','138','GAS RIGHT LTD','GAS RIGHT','08065635593','bigaya78@gmail.com','abuja','fct','AKPO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-28 12:47:46',5,'500','2021-02-28 12:47:46','500'),(2231,'','1','138','ISAAC GAS','ISAAC','07035370044','bigaya78@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-28 12:51:30',5,'500','2021-02-28 12:51:30','500'),(2234,'','1','138','FROST GAS SHOP','FROST GAS','08163309511','hafiz@aaranonigeria.com','abuja','fct','KUBWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-01 06:47:47',5,'500','2021-03-01 06:47:47','500'),(2235,'','1','138','NO COMPLAIN GAS SHOP','NO COMPLAIN GAS','08065706912','hafiz@aaranonigeria.com','abuja','fct','BETTER LIFE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-01 06:50:57',5,'500','2021-03-01 06:50:57','500'),(2236,'','1','138','OMO GAS SHOP','OMO GAS','08054805521','hafiz@aaranonigeria.com','abuja','fct','BADUMA ONE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-01 06:57:18',5,'500','2021-03-01 06:57:18','500'),(2241,'','1','138','FAB GAS','FAB','07012689266','bigaya78@gmail.com','abuja','fct','ZONE 1','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-01 09:40:02',5,'500','2021-03-01 09:40:02','500'),(2242,'','1','138','SUNNYBOB GAS','SUNNYBOB','09019385154','bigaya78@gmail.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-01 09:56:57',5,'500','2021-03-01 09:56:57','500'),(2245,'','1','138','HARRISON GAS','HARRISON','08023645313','bigaya78@gmail.com','abuja','fct','LUGBE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-01 13:02:13',5,'500','2021-03-01 13:02:13','500'),(2250,'','1','138','EDEMA GAS','EDEMA','08037864458','bigaya78@gmail.com','abuja','fct','GUDU NNPC','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-01 16:52:20',5,'500','2021-03-01 16:52:20','500'),(2253,'','1','138','LUCKY GAS','LUCKY','08077871537','bigaya78@gmail.com','abuja','fct','GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-02 09:49:44',5,'500','2021-03-02 09:49:44','500'),(2256,'','1','138','PARAGON GAS','DE--PARAGON','09053162230','bigaya78@gmail.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-02 11:09:29',5,'500','2021-03-02 11:09:29','500'),(2258,'','1','138','IFE TEX GAS SHOP','IFE TEX GAS','09060565671','hafiz@aaranonigeria.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-03 08:02:48',5,'500','2021-03-03 08:02:48','500'),(2260,'','1','138','AJIMONA GAS ','AJIMONA GAS','08035902946','hafiz@aaranonigeria.com','abuja','fct','GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-03 08:27:56',5,'500','2021-11-05 08:06:39','500'),(2261,'','1','138','DESTINY GAS','DESTINY','08035900536','bigaya78@gmail.com','abuja','fct','ASOKORO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-03 08:53:00',5,'500','2021-03-03 08:53:00','500'),(2263,'','1','138','NILE MOBILE GAS','NILE','08038080405','bigaya78@gmail.com','abuja','fct','MINNA STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-03 10:28:27',5,'500','2021-03-03 10:28:27','500'),(2264,'','1','138','TIMOTHY GAS','TIMOTHY','08068037188','bigaya78@gmail.com','abuja','fct','ASOKORO VILL','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-03 11:22:23',5,'500','2021-03-03 11:22:23','500'),(2266,'','1','138','LIBERTY GAS','LIBERTY','09066937859','bigaya78@gmail.com','abuja','fct','ASOKORO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-03 14:32:31',5,'500','2021-03-03 14:32:31','500'),(2267,'','1','138','IYKCE GAS SHOP','IYKCE GAS','08035046152','hafiz@aaranonigeria.com','abuja','fct','MAITAMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-03 15:19:21',5,'500','2021-03-03 15:19:21','500'),(2268,'','1','138','METRO GAS','METRO','08036120277','bigaya78@gmail.com','abuja','fct','AREA 10 UTC','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-03 16:24:21',5,'500','2021-03-03 16:24:21','500'),(2270,'','1','138','UGO BEST GAS ','UGO BEST GAS','08083040627','hafiz@aaranonigeria.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-04 06:51:35',5,'500','2021-11-05 08:08:29','500'),(2271,'','1','138','SUNNY MPAPE BRANCH','SUNNY BRANCH GAS','09086540562','hafiz@aaranonigeria.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-04 08:37:42',5,'500','2021-03-04 08:37:42','500'),(2275,'','1','138','VISSION GAS','VISSION','08035861080','bigaya78@gmail.com','abuja','fct','ASOKORO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-04 12:13:32',5,'500','2021-03-04 12:13:32','500'),(2276,'','1','138','OBB GAS','OBB','08036631738','bigaya78@gmail.com','abuja','fct','FADAMA STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-04 13:06:55',5,'500','2021-03-04 13:06:55','500'),(2277,'','1','138','FIDELIS GAS','FIDELIS','09036220077','bigaya78@gmail.com','abuja','fct','MPAPE ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-04 13:35:56',5,'500','2021-03-04 13:35:56','500'),(2278,'','1','138','FAKO 1ST GAS','FIRST','08037241122','bigaya78@gmail.com','abuja','fct','GUDU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-04 13:56:12',5,'500','2021-03-04 13:56:12','500'),(2279,'','1','138','CHINEDU GAS','CND','08060302354','bigaya78@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-04 14:14:51',5,'500','2021-03-04 14:14:51','500'),(2280,'','1','138','FRANCO GAS','FRANCO','08060312287','bigaya78@gmail.com','abuja','fct','GARKI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-04 14:55:29',5,'500','2021-03-04 14:55:29','500'),(2283,'','1','138','KACIYA GAS LTD','KACIYA GAS','09085398488','hafiz@aaranonigeria.com','KADUNA','KADUNA','KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-05 08:52:51',5,'500','2021-04-09 08:17:28','500'),(2284,'','1','138','UK GAS ','UK GAS','08138437679','hafiz@aaranonigeria.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-05 09:33:19',5,'500','2021-11-05 08:07:35','500'),(2290,'','1','138','TM BORROW','BORROW','08102779807','bigaya78@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-05 14:42:09',5,'500','2021-03-05 14:42:09','500'),(2291,'','1','138','U LIGHT GAS','U LIGHT','08035990135','bigaya78@gmail.com','abuja','fct','TIFA GARRAGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-05 15:21:13',5,'500','2021-03-05 15:21:13','500'),(2301,'','1','138','IFE GAS','IFE','08035962521','bigaya78@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-09 10:29:03',5,'500','2021-03-09 10:29:03','500'),(2302,'','1','138','OPTIMUM GAS','OPT.','08061318057','bigaya78@gmail.com','abuja','fct','AYA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-09 10:37:15',5,'500','2021-03-09 10:37:15','500'),(2306,'','1','138','OKEKE ANDREW','OKEKE','08060348948','bigaya78@gmail.com','KADUNA','KADUNA','KADUNA STATE KWOI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-10 07:53:10',5,'500','2021-03-10 07:53:10','500'),(2317,'','1','138','NOVICE GAS','NOVICE','09069988388','bigaya78@gmail.com','abuja','fct','KUBWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-11 12:36:29',5,'500','2021-03-11 12:36:29','500'),(2319,'','1','138','SAMUEL GAS','SAM','08126687793','bigaya78@gmail.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-12 10:40:49',5,'500','2021-03-12 10:40:49','500'),(2320,'','1','138','MAZIGWE','MAX.','08039429552','bigaya78@gmail.com','abuja','fct','GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-12 13:10:50',5,'500','2021-03-12 13:10:50','500'),(2323,'','1','138','AUSTIN GAS','AUST.','08096598885','bigaya78@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-14 11:53:09',5,'500','2021-03-14 11:53:09','500'),(2324,'','1','138','MOSES GAS','MOSES','08124667980','bigaya78@gmail.com','abuja','fct','DAWAKI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-14 14:19:21',5,'500','2021-03-14 14:19:21','500'),(2326,'','1','138','CHRIS DOMARK GAS','CHRIS','08034510052','bigaya78@gmail.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-15 07:57:26',5,'500','2021-04-09 07:23:27','500'),(2327,'','1','138','UNCLE PETE','UNCLE','08035893542','bigaya78@gmail.com','abuja','fct','WUSE ZONE 1','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-15 08:24:23',5,'500','2021-03-15 08:24:23','500'),(2333,'','1','138','SUCCESS GAS','SUCS.','08100328407','bigaya78@gmail.com','abuja','fct','AREA 8','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-15 11:37:06',5,'500','2021-03-15 11:37:06','500'),(2338,'','1','138','NOBLE GAS','NOB','08037793016','bigaya78@gmail.com','abuja','fct','GARKI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-16 07:47:07',5,'500','2021-03-16 07:47:07','500'),(2339,'','1','138','UNJ. EXCEL.','UNJ','08063007118','bigaya78@gmail.com','abuja','fct','LUGBE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-16 09:13:54',5,'500','2021-03-16 09:13:54','500'),(2340,'','1','138','JAMES  GAS','JAMES','07032343959','bigaya78@gmail.com','abuja','fct','AIR PORT ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-16 09:50:09',5,'500','2021-03-16 09:50:09','500'),(2341,'','1','138','ATIKU GAS','ATIKU','08188494599','bigaya78@gmail.com','abuja','fct','GAME VILLAGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-16 11:59:42',5,'500','2021-03-16 11:59:42','500'),(2350,'','1','138','GEORGE OTI GAS','GEORGE','08038914536','bigaya78@gmail.com','abuja','fct','AKPO ZONE C','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-17 14:44:25',5,'500','2021-03-17 14:44:25','500'),(2351,'','1','138','PACO GAS LTD','PACO','08037141121','bigaya78@gmail.com','abuja','fct','LUGBE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-17 16:39:21',5,'500','2021-03-17 16:39:21','500'),(2352,'','1','138','OKENWA GAS','0KE','08055242035','bigaya78@gmail.com','abuja','fct','BANEX','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-17 17:00:12',5,'500','2021-03-17 17:00:12','500'),(2359,'','1','138','UGOCHUKWU GAS SHOP','UGOCHUKWU  GAS','09095318531','hafiz@aaranonigeria.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-19 07:40:08',5,'500','2021-03-19 07:40:08','500'),(2360,'','1','138','GEORGA OTR APO GAS','GEORGA GAS','08038914536','hafiz@aaranonigeria.com','abuja','fct','APO ZONE  C','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-19 09:29:50',5,'500','2021-03-19 09:29:50','500'),(2367,'','1','138','SHAIBU GAS','SHUAIBU GAS','08109285655','hafiz@aaranonigeria.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-21 09:00:08',5,'500','2021-11-08 07:10:41','500'),(2368,'','1','138','ZACHIOUS GAS SHOP','ZACHIOUS GAS','07059277155','hafiz@aaranonigeria.com','abuja','fct','KWAI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-21 09:29:35',5,'500','2021-03-21 09:29:35','500'),(2381,'','1','138','I.K APO GAS SHOP','I.K APO GAS','08033713967','hafiz@aaranonigeria.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-23 08:30:16',5,'500','2021-03-23 08:30:16','500'),(2383,'','1','138','SWIFT GAS SERVICES','SWIFT GAS','09038884046','hafiz@aaranonigeria.com','abuja','fct','GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-23 09:37:10',5,'500','2021-11-05 08:05:42','500'),(2384,'','1','138','PAPPY GAS SHOP','PAPPY GAS','07064787192','hafiz@aaranonigeria.com','abuja','fct','AREA 1','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-23 10:18:38',5,'500','2021-03-23 10:18:38','500'),(2385,'','1','138','S.I NNEJI GAS SHOP','S.I NNEJI GAS','07036013978','hafiz@aaranonigeria.com','abuja','fct','DEI DEI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-23 11:17:08',5,'500','2021-03-23 11:17:08','500'),(2387,'','1','138','SUNNY MPOL  GAS SHOP','SUNNY MPOL  GAS','08058167686','hafiz@aaranonigeria.com','abuja','fct','MPOL BARRACK','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-23 14:48:40',5,'500','2021-03-23 14:48:40','500'),(2398,'','1','138','OBEFLAME GAS SHOP','OBEFLAME GAS','08033197741','hafiz@aaranonigeria.com','abuja','fct','ZONE 1','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-25 15:25:24',5,'500','2021-03-25 15:25:24','500'),(2403,'','1','138','FRIDAY GAS ','FRIDAY GAS','08088812269','hafiz@aaranonigeria.com','abuja','fct','GIMBIYA GARKI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-26 08:30:50',5,'500','2021-11-02 08:54:57','500'),(2404,'','1','138','BIGJOE GAS SHOP','BIGJOE GAS','07044331430','hafiz@aaranonigeria.com','abuja','fct','BWARI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-26 09:52:42',5,'500','2021-03-26 09:52:42','500'),(2410,'','1','138','PAUBELT  GAS SHOP','PAULBELT GAS','08039646914','hafiz@aaranonigeria.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-27 07:23:11',5,'500','2021-03-27 07:23:11','500'),(2422,'','1','138','JAM BEST GAS ','JAM GAS','08032771812','hafiz@aaranonigeria.com','abuja','fct','APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-28 08:39:37',5,'500','2021-11-02 08:54:15','500'),(2429,'','1','138','NAMS GAS','NAMS','08037258529','bigaya78@gmail.com','abuja','fct','KUBWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-28 16:42:20',5,'500','2021-03-28 16:42:20','500'),(2451,'','1','138','AG GAS LTD','ALEX','08034523076','bigaya78@gmail.com','abuja','fct','WUSE 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-30 08:22:48',5,'500','2021-03-30 08:22:48','500'),(2464,'','1','138','CHIDERA GAS ','CHIDERA GAS','070446868669','hafiz@aaranonigeria.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-01 08:57:35',5,'500','2021-11-02 08:53:38','500'),(2465,'','1','138','PRINSEN GAS','PRINS','08052372647','bigaya78@gmail.com','abuja','fct','UZAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-01 10:24:13',5,'500','2021-04-01 10:24:13','500'),(2472,'','1','138','KN  GAS GWARIMPA','KN GAS','08033623370','bigaya78@gmail.com','abuja','fct','GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-01 12:04:16',5,'500','2021-04-01 12:04:16','500'),(2477,'','1','138','BUKASIA GAS ','BUKA','08032895744','bigaya78@gmail.com','abuja','fct','WUSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-02 09:53:15',5,'500','2021-04-02 09:53:15','500'),(2486,'','1','138','UCHE LUGBE','UCHE ','08061574237','bigaya78@gmail.com','abuja','fct','LUGBE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-03 09:55:34',5,'500','2021-04-03 09:55:34','500'),(2504,'','1','138','SOLOMON TAURA','SOLO','08069621995','bigaya78@gmail.com','abuja','fct','TAURA MARKET','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-04 15:31:28',5,'500','2021-04-04 15:31:28','500'),(2508,'','1','138','DONALD GAS','DONALD','07065659275','bigaya78@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-05 08:34:18',5,'500','2021-04-05 08:34:18','500'),(2511,'','1','138','SUNNY GAS DUTSE','SUNNY DUTSE','08169894022','hafiz@aaranonigeria.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-06 07:46:04',5,'500','2021-04-06 07:46:04','500'),(2512,'','1','138','NNAJI GAS','NNEIJ','08107430691','bigaya78@gmail.com','abuja','fct','DEIDEI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-06 09:22:39',5,'500','2021-06-26 10:36:56','500'),(2516,'','1','138','EMEKA MAITAMA GAS','EMEKA MAITAMA','08039429552','hafiz@aaranonigeria.com','abuja','fct','MAITAMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-07 06:49:28',5,'500','2021-04-07 06:49:28','500'),(2517,'','1','138','OYI TEX GAS  ','OYI TEX','07034745501','hafiz@aaranonigeria.com','abuja','fct','TIPPER GARAGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-07 07:06:19',5,'500','2021-04-07 07:06:19','500'),(2536,'','1','138','TO BEST GARKI','TO BEST','08036271195','bigaya78@gmail.com','abuja','fct','GARKI 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-09 16:29:38',5,'500','2021-04-09 16:29:38','500'),(2537,'','1','138','DURA GAS ','DURA GAS','08163338437','hafiz@aaranonigeria.com','abuja','fct','GARKI  II','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-10 06:38:56',5,'500','2021-11-02 08:52:56','500'),(2538,'','1','138','CHRIS OKESON','OKESON','08034261741','bigaya78@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-10 09:14:45',5,'500','2021-04-10 09:14:45','500'),(2540,'','1','138','NAS GAS','NAS','08160245085','bigaya78@gmail.com','abuja','fct','WUSE ZONE 1','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-10 11:34:06',5,'500','2021-04-10 11:34:06','500'),(2541,'','1','138','FAVOUR GAS DUTSE','FAVOUR','07033697323','bigaya78@gmail.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-10 14:24:30',5,'500','2021-04-10 14:24:30','500'),(2548,'','1','138','CHUKESON GAS','SON','08064286621','bigaya78@gmail.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-11 13:56:14',5,'500','2021-04-11 13:56:14','500'),(2557,'','1','138','NZEBEST GAS ','BEST','08036007633','bigaya78@gmail.com','abuja','fct','LUGBE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-13 15:32:18',5,'500','2021-04-13 15:32:18','500'),(2568,'','1','138','CITY GAS','CITY','09071061000','bigaya78@gmail.com','abuja','fct','LUGBE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-16 13:44:07',5,'500','2021-04-16 13:44:07','500'),(2613,'','1','138','CN CHOOSE GAS','CHOOSE','08037171367','bigaya78@gmail.com','abuja','fct','AREA 3','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-26 15:28:28',5,'500','2021-04-26 15:28:28','500'),(2627,'','1','138','CROWN GAS','CROWN','07034666297','bigaya78@gmail.com','abuja','fct','LUGBE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-30 06:49:45',5,'500','2021-04-30 06:49:45','500'),(2634,'','1','138','IMO   ORJI','IMO','08037061795','bigaya78@gmail.com','abuja','fct','MAITAMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-01 11:24:36',5,'500','2021-05-01 11:24:36','500'),(2635,'','1','138','NAPS0N  GAS','     MODEL MARKET GARKI','08035918906','bigaya78@gmail.com','abuja','fct','GARKI 11 ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-01 12:34:41',5,'500','2021-05-01 12:34:41','500'),(2648,'','1','138','vio  gas','vio','08062173957','bigaya78@gmail.com','abuja','fct','gwarinfa','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-03 12:42:24',5,'500','2021-05-03 12:42:24','500'),(2669,'','1','138','JOHN B','JOHN','07063061033','bigaya78@gmail.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-12 09:31:40',5,'500','2021-05-12 09:31:40','500'),(2690,'','1','138','EMESON GAS','EMESON','07035560376','bigaya78@gmail.com','abuja','fct','GARKI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-19 09:14:30',5,'500','2021-05-19 09:14:30','500'),(2692,'','1','138','BORN TO RAIN','B RAIN','08130581690','bigaya78@gmail.com','abuja','fct','DAFE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-19 11:36:28',5,'500','2021-05-19 11:36:28','500'),(2703,'','1','138','ATUSON GAS','ATUSON','09039177615','aaranokatampe@gmail.com','abuja','fct','garki','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-23 15:17:34',5,'500','2021-05-23 15:17:34','500'),(2745,'','1','138','CARFAM GAS','CAR','08059789680','aaranokatampe@gmail.com','abuja','fct','BARNEX','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-14 10:26:25',5,'500','2021-06-14 10:26:25','500'),(2873,'','1','138','AL-HAWA GLOBAL ENERGY','ALHAWA','07064433707','aaranokatampe@gmail.com','NIGER','NIGER','AGWADALA MADALLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-30 10:09:32',5,'500','2021-06-30 10:09:32','500'),(2908,'','1','138','EMMA GODSTIME','EMMA','09099020909','aaranokatampe@gmail.com','abuja','fct','KUBWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-07 12:54:03',5,'500','2021-07-07 12:54:03','500'),(2912,'','1','138','GABBY','GAS','08066103797','aaranokatampe@gmail.com','abuja','fct','KATAMPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-08 11:01:21',5,'500','2021-07-08 11:01:21','500'),(2932,'','1','138','AMMASCO GAS ','AMMASCO','09034427873','aaranokatampe@gmail.com','abuja','fct','KUBWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-11 13:02:24',5,'500','2021-07-11 13:02:24','500'),(2933,'','1','138','CONFIDENCE GAS','CONFIDENCE','09071061000','aaranokatampe@gmail.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-11 14:31:47',5,'500','2021-07-11 14:31:47','500'),(3055,'','1','138','HARUNA GAS','HARUNA','08141266850','aaranokatampe@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-11 06:50:13',5,'500','2021-08-11 06:50:13','500'),(3057,'','1','138','SINC0  GAS','SINCO','09071061000','aaranokatampe@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-11 09:40:36',5,'500','2021-08-11 09:40:36','500'),(3097,'','1','138','ZOE GAS','JOHN','07084780751','aaranokatampe@gmail.com','abuja','fct','SITE TIME GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-17 12:18:10',5,'500','2021-08-17 12:18:10','500'),(3136,'','1','138','LAZARUS GAS','GISHIRI','08088040016','aaranokatampe@gmail.com','abuja','fct','GISHIRI ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-21 12:47:25',5,'500','2021-08-21 12:47:25','500'),(3157,'','1','138','KEAPTROL OIL GAS','GAS','08163596159','aaranokatampe@gmail.com','abuja','fct','PAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-27 16:24:20',5,'500','2021-08-27 16:24:20','500'),(3159,'','1','138','ZUBI GAS','ZUBI','08066903797','aaranokatampe@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-29 09:58:59',5,'500','2021-08-29 09:58:59','500'),(3168,'','1','138','FARAAB GAS LTD','FARAAB','08086853267','aaranokatampe@gmail.com','abuja','fct','GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-30 13:18:07',5,'500','2021-08-30 13:18:07','500'),(3268,'','1','138','sefcon','GAS','08035325607','aaranokatampe@gmail.com','abuja','fct','kwarimpa abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-14 13:07:56',5,'500','2021-09-14 13:07:56','500'),(3271,'','1','138','MAX GAS','MAX','08095355555','aaranokatampe@gmail.com','abuja','fct','GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-14 16:49:16',5,'500','2021-09-14 16:49:16','500'),(3305,'','1','138','STANLEY GAS','STANLEY','09071061000','aaranokatampe@gmail.com','abuja','fct','JAHI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-17 14:08:43',5,'500','2021-09-17 14:08:43','500'),(3308,'','1','138','LORDS WILL ENERGY','WILL','09071061000','aaranokatampe@gmail.com','abuja','fct','GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-17 17:47:26',5,'500','2021-09-17 17:47:26','500'),(3321,'','1','138','yusifa','GAS','08154420532','aaranokatampe@gmail.com','abuja','fct','pape','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-19 10:42:50',5,'500','2021-09-19 10:42:50','500'),(3358,'','1','138','IFEANYI J. GAS','JOEL','08096598885','aaranokatampe@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-25 10:21:46',5,'500','2021-09-25 10:21:46','500'),(3364,'','1','138','DE BASH GAS','BASH','08024026231','aaranokatampe@gmail.com','abuja','fct','KUBWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-26 09:18:30',5,'500','2021-09-26 09:18:30','500'),(3388,'','1','138','PRINCE  GAS','PRINCE','07031062524','aaranokatampe@gmail.com','abuja','fct','KUBWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-04 14:52:28',5,'500','2021-10-04 14:52:28','500'),(3607,'','1','138','GUBSUM    GAS','GUBS.','08120290873','aaranokatampe@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-27 07:23:25',5,'500','2021-10-27 07:23:25','500'),(3619,'','1','138','GG   GAS','GG GAS','07035849719','aaranokatampe@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-28 08:10:50',5,'500','2021-10-28 08:10:50','500'),(3666,'','1','138','O.N  ONYI BEST','BEST GAS','08167184393','aaranokatampe@gmail.com','abuja','fct','GIMBIYA STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-03 14:15:49',5,'500','2021-11-03 14:15:49','500'),(3668,'','1','138','LACE GAS','AN ADAMS','09071061000','aaranokatampe@gmail.com','abuja','fct','TETFUND MAITAMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-03 17:05:33',5,'500','2021-11-03 17:05:33','500'),(3672,'','1','138','JERE GAS','HAYATU IBRAHIM JERE','08064344133','hayatuibrahimjere@gmail.com','JERE','KADUNA ','JERE LGA KADUNA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-05 12:58:30',5,'500','2021-11-05 12:58:30','500'),(3676,'','1','138','ADMOND   GAS','ADMOND','08037020544','aaranokatampe@gmail.com','abuja','fct','JABI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-07 08:43:49',5,'500','2021-11-07 08:43:49','500'),(3678,'','1','138','RICHI GAS','RICHI GAS','08033950318','aaranokatampe@gmail.com','abuja','fct','GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-07 10:25:58',5,'500','2021-11-07 10:25:58','500'),(3679,'','1','138','ABDULLAHI GAS','ABDULLAHI SHUAIBU','07033733051','abbdullahigas@gmail.com','ABUJA','FCT','OKADA JUCTION MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-07 14:38:06',5,'500','2021-11-07 14:38:06','500'),(3680,'','1','138','C C FAVOUR  GAS','C.C FAVOUR ','08066894250','ccgas@gmail.com','ABUJA','FCT','DIIYE DIYE SABURI 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-07 16:47:42',5,'500','2021-11-07 16:47:42','500'),(3681,'','1','138','EJIK E GAS','EJIKE','08160100670','ejike@gmail.com','ABUJA','FCT','ZONE 6 , DUTSEN ALHAJI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-07 16:56:39',5,'500','2021-11-07 16:56:39','500'),(3700,'','1','138','IK  MASHAFA','MASHA','08065708197','aaranokatampe@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-10 09:33:58',5,'500','2021-11-14 11:43:07','500'),(3718,'','1','138','JOLAKA   GAS','JOLAKA','08034441740','aaranokatampe@gmail.com','abuja','fct','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-10 14:27:23',5,'500','2021-11-10 14:27:23','500'),(3806,'','1','138','YUNUSA AUDU GAS','YUNUSA AUDU','09053115251','yunusaaudugas@gmail.com','ABUJA','FCT','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-17 13:48:21',5,'500','2021-12-09 08:58:09','500'),(3821,'','1','138','HAJIYA  ASIYA','HAJIYA GAS','08036088525','aaranokatampe@gmail.com','abuja','fct','WUSE 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-21 11:33:37',5,'500','2021-11-21 11:33:37','500'),(3838,'','1','138','AHMAD  DAWAKI','AHMAD GAS','08112857033','aaranokatampe@gmail.com','abuja','fct','DAWAKI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-24 09:10:53',5,'500','2021-11-24 09:10:53','500'),(3931,'','1','138','ODEN GAS','ODEN','08037864259','ezehosita@yahoo.com','MARABA ','NASSARAWA','26 baba street Maraba - NASSARAWA STATE ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-02 08:25:45',5,'500','2021-12-02 08:25:45','500'),(3941,'','1','138','PHILIP  GAS','PHILIP','08061548649','aaranokatampe@gmail.com','abuja','fct','GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-03 07:39:17',5,'500','2021-12-03 07:39:17','500'),(4001,'','1','138','Nnamdi Gas  Dutse','Nnamdi','08165924148','nnamdiwobodo25@gmail','DUTSE','FCT','Dutse','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-11 06:38:54',5,'500','2021-12-11 06:38:54','500'),(4036,'','1','138','EMMPU GAS','EMMPU','0813324507','aaranokatampe@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-16 10:28:54',5,'500','2021-12-16 10:28:54','500'),(4133,'','1','138','ODOGWU GAS','ODOGWU ','08100204985','aaranokatampe@gmail.com','abuja','fct','JAHI 2 BWARI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-02 10:45:18',5,'500','2022-01-02 10:45:18','500'),(4139,'','1','138','CY GAS','CY GAS','08033113888','aaranokatampe@gmail.com','abuja','fct','JABI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-04 09:33:21',5,'500','2022-01-04 09:33:21','500'),(4197,'','1','138','EJIMA GAS','EJIMA ','09094367039','@gmail. com','abuja','FCT','DUTSE ZONE 6','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-19 09:07:52',5,'500','2022-01-19 09:07:52','500'),(4208,'','1','138','DENCO GAS MPAPE','DENCO ','09046272707','aaranokatampe@gmail.com','ABUJA','FCT','MPAPE FCT','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-20 11:12:00',5,'500','2022-01-20 11:12:00','500'),(4248,'','1','138','BUY MY GAS NIG LTD.','Goni ahmad','08131375754,08188424274','gonimuktarahmad@gmail.com','abuja','fct','Little accoms lokogoma abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-28 22:00:19',5,'500','2022-01-28 22:00:19','500'),(4249,'','1','138','Zak\'s gas','Zakariyya','09034593368','mustyrano17@gmail.com','Lafia','Nasarawa','Maraba nasarawa state.','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-03 12:19:07',5,'500','2022-02-03 12:19:07','500'),(4250,'','1','138','Blessed A&D Gas','Alfred Liu Elija','08060067222','alfredelija@gmail.com','ABUJA','FCT','Mashafa road MPAPE ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-05 11:44:07',5,'500','2022-02-05 11:44:07','500'),(4251,'','1','138','Nafi\'u gas','Naf gas','08169996705','mustyrano17@gmail.com','abuja','fct','Maitama federal housing','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-09 17:10:53',5,'500','2022-02-09 17:10:53','500'),(4252,'','1','138','OG CHRIS OIL & GAS','CHRIS GWARIPA','08108798386','ogemmauel20@gmail.com','ABUJA','FCT','GWARIPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-10 18:13:29',5,'500','2022-02-10 18:13:29','500'),(4253,'','1','138','CITIZEN GAS','Thioplus ','08035965273','citizegas@gmail.com','ABUJA','FCT','zubas','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-17 14:12:43',5,'500','2022-02-17 14:12:43','500'),(4254,'','1','138','MC4 GAS','MC4 GAS','08031520136','aaranokatampe@gmail.com','ABUJA','FCT','KUBWA ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-01 13:11:52',5,'500','2022-03-01 13:11:52','500'),(4255,'','1','138','King kecy oil & gas','kingsley','08145582829','kingsgley@gmail.com','ABUJA','FCT','GWARINPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-06 09:55:03',5,'500','2022-03-06 09:55:03','500'),(4256,'','1','138','Corby gas','Corby gas','08170800051','corbygas01@gmail.com','abuja','fct','No,1 fina Minna junction kubwa ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-20 16:56:12',5,'500','2022-03-20 16:56:12','500'),(4257,'','1','138','sofan Energy','sylvanus ','07034823141','sylvanus2021@gmail.com','ABUJA','FCT','zone 7 DUtsen Alhaji','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-21 07:09:14',5,'500','2022-03-21 07:09:14','500'),(4258,'','1','138','Safety gas','Safety gas ','08166544622','safetygas@gmail.com','abuja','fct','Dutse bwari lga','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-24 14:43:28',5,'500','2022-03-24 14:43:28','500'),(4259,'','1','138','Tunztob nig ltd','Odumosu olatunji','07037775006','tunji_3@yahoo.com','abuja','fct','7 zone D bumko bwari abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-27 16:34:39',5,'500','2022-03-27 16:34:39','500'),(4260,'','1','138','KING K.C GAS','KING K.C DAWAKI','08145582829','aaranokatampe@gmail.com','abuja','fct','DAWAKI NEWS ENGINEERING','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-02 12:26:34',5,'500','2022-04-02 12:26:34','500'),(4261,'','1','138','MAHMUD GAS','MAHMUD','08036151100','aaranokatampe@gmail.com','ABUJA','fct','NO 37 USUMA STREET MAITAMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-02 12:30:06',5,'500','2022-04-02 12:30:06','500'),(4262,'','1','138','DM DEMEX LTD','Nnamdi David ','08035911650','dmex2022@gmail.com','ABUJA','FCT','War college Gwarinpa Estate ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-06 10:00:05',5,'500','2022-04-06 10:00:05','500'),(4263,'','1','138','A.Y  BAKORI GAS','ABDULFATAH YAHUZA','08130671918','abdulfatahyahuza@gmail.com','ABUJA','FCT','DUtse Sagwari lay out FCT ABUJA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-09 16:54:23',5,'500','2022-04-09 16:54:23','500'),(4264,'','1','138','EDU  GAS  GWARIMPA','EDU GAS','08030994816','aaranokatampe@gmail.com','ABUJA','FCT','GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-03 08:11:14',5,'500','2022-05-03 08:11:14','500'),(4265,'','1','138','WISDOM  GAS','WISDOM','09121567797','aaranokatampe@gmail.com','abuja','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-07 08:09:21',5,'500','2022-05-07 08:09:21','500'),(4266,'','1','138','O.J. OIL and GAS LTD','O.J','07031133236','aaranokatampe@gmail.com','abuja','FCT','DAWAKI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-28 11:47:56',5,'500','2022-05-28 11:47:56','500'),(4267,'','1','138','Nestling gas','Stanley','07061204843','mustyrano17@gmail.com','abuja','fct','Wuye Opp zatex ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-29 18:26:33',5,'500','2022-06-29 18:26:33','500'),(4268,'','1','138','SAIDU GAS','SAIDU','09071061000','aaranokatampe@gmail.com','ABUJA','FCT','DUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-20 14:09:56',5,'500','2022-07-20 14:09:56','500'),(4269,'','1','138','RICHARD GAS','RICHARD','07044963573','aaranokatampe@gmail.com','ABUJA','fct','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-21 09:57:14',5,'500','2022-07-21 09:57:14','500'),(4270,'','1','138','ZION GAS','ZION','08112889272','aaranokatampe@gmail.com','ABUJA','FCT','GWAGWALADA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-22 15:21:59',5,'500','2022-07-22 15:21:59','500'),(4271,'','1','138','TRUNIC  GAS DAWAKI','ERIC','09043563469','aaranokatampe@gmail.com','ABUJA','FCT','DAWAKI ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-30 13:42:49',5,'500','2022-07-30 14:35:42','500'),(4272,'','1','138','KIMS  RESTAURANT','KIMS','07069655562','aaranokatampe@gmail.com','abuja','fct','MAITAMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-20 14:22:25',5,'500','2022-08-20 14:22:25','500'),(4273,'','1','138','BUCHI BEST GAS','BUCHI','08036538502','aaranokatampe@gmail.com','abuja','fct','KADO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-22 14:25:01',5,'500','2022-08-22 14:25:01','500'),(4274,'','1','138','WINNYS GAS ','WINNYS','09071061000','katampelpg@gmail.com','Abuja','Fct','Dawaki','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-25 18:13:59',5,'500','2022-08-25 18:13:59','500'),(4275,'','1','138','DANTY KLASS KITCHEN','DANTY','08068254076','katampelpg@gmail.com','Abuja','Fct','KOGO EXT.','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-25 18:15:47',5,'500','2022-08-25 18:15:47','500'),(4276,'','1','138','CHIKE  OIL and GAS','CHIKE','08147224375','abkrwakili@gmail.com','ABUJA','FCT','ASOKORO VLG','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-29 10:00:32',5,'500','2022-09-29 10:00:32','500'),(4277,'','1','138','MURTALA MPAPE','MURTALA GAS','09133886270','aaranolpg@gmail.com','ABUJA','FCT','MPAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-08 16:36:28',5,'500','2022-12-08 16:36:28','500'),(4278,'','1','138','EZE UDO GAS','EZE UDO','08039597042','aaranolpg@gmail.com','ABUJA','FCT','KUBWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-13 15:25:25',5,'500','2022-12-13 15:25:25','500'),(4279,'','1','138','DEJ GAS ','07034778817','07034778817','aaranolpg@gmail.com','ABUJA','FCT','BEHIND NEWS ENGIEERING DAWAKI ABUJA','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-12-15 10:40:24',5,'500','2022-12-15 10:40:24','500'),(4280,'','1','138','SUEZ GAS LTD','SUEZ GAS','07066887934','aaranolpg@gmail.com','ABUJA','FCT','WUSE 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-15 16:10:41',5,'500','2022-12-15 16:10:41','500'),(4281,'','1','138','RAIMON GAS','07062683133','07062683133','aaranolpg@gmail.com','ABUJA','FCT','OSHAFA BUWARI','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-12-23 08:57:25',5,'500','2022-12-23 08:57:25','500'),(4282,'','1','138','ENIGMA GAS','08038607722','08038530991','aaranolpg@gmail.com','ABUJA','FCT','SOKALE FIRST HIGH TENSION','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-12-25 15:03:27',5,'500','2022-12-25 15:03:27','500'),(4283,'','1','138','SULAIMAN GAS ','07045719880','07045719880','aaranolpg@gmail.com','ABUJA','FCT','ZONE1 CALABAR CHURCH','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-12-26 17:03:14',5,'500','2022-12-26 17:03:14','500'),(4284,'','1','138','KAMBAI S.D.K GAS','08169563355','08099105013','aaranolpg@gmail.com','ABUJA','FCT','TIPPER GARAGE 3 AVENUE GWARIMPA ESTATE ABUJA ','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-12-26 17:08:05',5,'500','2022-12-26 17:08:05','500'),(4285,'','1','138','chimon','07068749296','07068749296','aaranolpg@gmail.com','ABUJA','FCT','69 road by lungu','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-12-27 11:09:17',5,'500','2022-12-27 11:09:17','500'),(4286,'','1','138','AMBAI','08169563355','08169563355','aaranolpg@gmail.com','ABUJA','FCT','3 ABINUE TIFFEI GAREJI','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-12-30 16:01:46',5,'500','2022-12-30 16:01:46','500'),(4287,'','1','138','NA;IKE GAs','09099696916','09099696916','aaranolpg@gmail.com','ABUJA','FCT','GWARINPA VILLAGE ','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-12-30 16:05:26',5,'500','2022-12-30 16:05:26','500'),(4288,'','1','138','DELIGHT','08036273217','08036273217','aaranolpg@gmail.com','ABUJA','FCT','ecows aya','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-03 11:39:38',5,'500','2023-01-03 11:39:38','500'),(4289,'','1','138','BAZIF GAS','08066816197','08066816197','aaranolpg@gmail.com','ABUJA','FCT','NO OKEMESI CRESENT','Nigeria',200.00,0.00,0.00,'0000-00-00','2023-01-11 13:38:36',5,'500','2023-01-11 13:38:36','500'),(4290,'','1','138','EBUBE COOKING GAS','08153580724','08152580724','aaranolpg@gmail.com','ABUJA','FCT','GISHIRI,MABUSHI EXPRESS WAY','Nigeria',200.00,0.00,0.00,'0000-00-00','2023-01-16 14:07:17',5,'500','2023-01-16 14:07:17','500'),(4291,'','1','138','KINCIN GAS','08075922043','08075922043','aaranolpg@gmail.com','ABUJA','FCT','NEW MARKET MPAPE','Nigeria',200.00,0.00,0.00,'0000-00-00','2023-01-19 10:38:46',5,'500','2023-01-19 10:38:46','500'),(4292,'','1','138','EXCELLECY','08035961897','08035961897','aaranolpg@gmail.com','ABUJA','FCT','SULEJA EXX','Nigeria',200.00,0.00,0.00,'0000-00-00','2023-01-21 16:58:39',5,'500','2023-01-21 16:58:39','500'),(4293,'','1','138','HABU KUBWA GAS','09072915860','090729125860','aaranolpg@gmail.com','ABUJA','FCT','KUBWA TWO/ONE','Nigeria',200.00,0.00,0.00,'0000-00-00','2023-01-29 16:29:30',5,'500','2023-01-29 16:29:30','500'),(4294,'','1','138','KING JOE GAS ','08061338106','08061338106','kingjoegas@gmail.com','FCT','ABUJA','TIJMA MAJE FCT ABUJA','Nigeria',500.00,0.00,0.00,'0000-00-00','2023-02-23 12:38:03',5,'500','2023-02-23 12:38:03','500'),(4295,'','1','138','SAVERS GAS','08146352664','08146352664','onowusavers@gmail.com','FCT','ABUJA','21 JUNCTION KUBWA ','Nigeria',500.00,0.00,0.00,'0000-00-00','2023-03-02 12:40:06',5,'500','2023-03-02 12:40:06','500'),(4296,'','1','138','WINNY\'S RESTAURANT','OLA WOLE','08100576171','winnysrestaurants@gmail.com','FCT','ABUJA','ASOKORO','Nigeria',250.00,0.00,0.00,'0000-00-00','2023-03-02 14:45:36',5,'500','2023-03-02 14:45:36','500');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16367 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','138',16059,'765',5924.19,5310.00,'2021-08-14','reconciliation','2021-08-14 11:30:21','483','483',2021,'483','2021-08-14 11:30:21',5),('1','138',16366,'765',1030.28,398.00,'2021-09-08','new dipping','2021-09-08 22:07:22','483','483',2021,'483','2021-09-08 22:07:22',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2140 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','138','765',2136,'5','LPG NOZZLE ',5330660.64,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','138','765',2137,'5','LPG NOZZLE 2',415.96,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','138','765',2138,'5','LPG NOZZLE 3',28.36,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','138','765',2139,'5','LPG NOZZLE 4',86.02,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258106 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','138',146997,'DAILY SHIFT','2020-08-02','2020-08-02 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-12 13:31:57','500','2020-08-12 13:35:39',10,0),('1','138',147075,'DAILY SHIFT','2020-08-03','2020-08-03 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-12 17:10:26','500','2020-08-12 17:10:56',10,0),('1','138',147102,'DAILY SHIFT','2020-08-04','2020-08-04 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-13 09:47:44','500','2020-08-13 09:48:13',10,0),('1','138',147164,'DAILY SHIFT','2020-08-06','2020-08-06 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-13 10:02:19','500','2020-08-13 10:03:00',10,0),('1','138',147168,'DAILY SHIFT','2020-08-06','2020-08-06 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-13 10:32:58','500','2020-08-13 10:43:32',10,0),('1','138',147189,'DAILY SHIFT','2020-08-07','2020-08-07 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-13 11:19:35','500','2020-08-13 11:23:16',10,0),('1','138',147198,'DAILY SHIFT','2020-08-08','2020-08-08 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-13 11:28:35','500','2020-08-13 11:34:26',10,0),('1','138',147202,'DAILY SHIFT','2020-08-09','2020-08-09 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-13 11:42:37','500','2020-08-13 11:43:05',10,0),('1','138',147205,'DAILY SHIFT','2020-08-10','2020-08-10 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-13 11:50:27','500','2020-08-13 11:50:45',10,0),('1','138',147209,'DAILY SHIFT','2020-08-10','2020-08-10 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-13 12:05:40','500','2020-08-13 12:15:34',10,0),('1','138',147218,'DAILY SHIFT','2020-08-11','2020-08-11 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-13 12:24:10','500','2020-08-13 12:26:19',10,0),('1','138',147228,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-13 12:46:06','500','2020-08-13 12:46:51',10,0),('1','138',147278,'DAILY SHIFT','2020-08-07','2020-08-07 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-13 16:28:55','500','2020-08-13 17:10:33',10,0),('1','138',147295,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-14 09:01:44','500','2020-08-14 09:02:44',10,0),('1','138',147330,'DAILY SHIFT','2020-08-13','2020-08-13 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-14 09:12:35','500','2020-08-14 09:14:08',10,0),('1','138',147428,'DAILY SHIFT','2020-08-14','2020-08-14 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-14 19:25:55','500','2020-08-14 19:26:53',10,0),('1','138',147577,'DAILY SHIFT','2020-08-15','2020-08-15 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-16 06:25:18','500','2020-08-16 06:26:15',10,0),('1','138',147578,'DAILY SHIFT','2020-08-16','2020-08-16 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-17 20:17:25','500','2020-08-17 20:17:53',10,0),('1','138',147870,'DAILY SHIFT','2020-08-17','2020-08-17 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-17 20:24:18','500','2020-08-17 20:24:52',10,0),('1','138',147871,'DAILY SHIFT','2020-08-17','2020-08-17 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-17 20:46:58','500','2020-08-17 20:48:15',10,0),('1','138',147873,'DAILY SHIFT','2020-08-17','2020-08-17 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-17 20:55:07','500','2020-08-17 20:55:38',10,0),('1','138',147991,'DAILY SHIFT','2020-08-18','2020-08-18 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-18 19:59:43','500','2020-08-18 20:03:05',10,0),('1','138',148107,'DAILY SHIFT','2020-08-19','2020-08-19 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-19 17:43:55','500','2020-08-19 17:44:34',10,0),('1','138',148280,'DAILY SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-20 19:26:41','500','2020-08-20 19:27:43',10,0),('1','138',148281,'DAILY SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-20 19:45:12','500','2020-08-20 19:45:36',10,0),('1','138',148282,'DAILY SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-20 19:55:52','500','2020-08-20 19:56:42',10,0),('1','138',148427,'DAILY SHIFT','2020-08-21','2020-08-21 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-21 19:29:28','500','2020-08-21 19:31:23',10,0),('1','138',148430,'DAILY SHIFT','2020-08-21','2020-08-21 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-22 20:02:30','500','2020-08-22 20:02:55',10,0),('1','138',148561,'DAILY SHIFT','2020-08-22','2020-08-22 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-22 20:09:26','500','2020-08-22 20:09:58',10,0),('1','138',148799,'DAILY SHIFT','2020-08-24','2020-08-24 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-24 17:54:47','500','2020-08-24 17:55:52',10,0),('1','138',148957,'DAILY SHIFT','2020-08-25','2020-08-25 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-25 18:21:07','500','2020-08-25 18:21:57',10,0),('1','138',149036,'DAILY SHIFT','2020-08-26','2020-08-26 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-26 12:20:57','500','2020-08-26 12:21:40',10,0),('1','138',149127,'DAILY SHIFT','2020-08-26','2020-08-26 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-26 17:01:00','500','2020-08-26 17:01:30',10,0),('1','138',149312,'DAILY SHIFT','2020-08-27','2020-08-27 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-27 21:16:01','500','2020-08-27 21:16:41',10,0),('1','138',149433,'DAILY SHIFT','2020-08-28','2020-08-28 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-28 18:15:23','500','2020-08-28 18:16:20',10,0),('1','138',149582,'DAILY SHIFT','2020-08-29','2020-08-29 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-29 17:26:41','500','2020-08-29 17:27:19',10,0),('1','138',149590,'DAILY SHIFT','2020-08-29','2020-08-29 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-29 18:19:12','500','2020-08-29 18:19:32',10,0),('1','138',149679,'DAILY SHIFT','2020-08-30','2020-08-30 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-30 17:22:06','500','2020-08-30 17:22:25',10,0),('1','138',149832,'DAILY SHIFT','2020-08-31','2020-08-31 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-31 17:49:58','500','2020-08-31 17:50:24',10,0),('1','138',149839,'DAILY SHIFT','2020-08-31','2020-08-31 00:00:00',NULL,'500',0.00,0.00,'500','2020-08-31 18:52:38','500','2020-08-31 18:53:03',10,0),('1','138',149988,'DAILY SHIFT','2020-09-01','2020-09-01 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-01 18:09:13','500','2020-09-01 18:09:31',10,0),('1','138',150112,'DAILY SHIFT','2020-09-02','2020-09-02 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-02 15:37:58','500','2020-09-02 15:38:14',10,0),('1','138',150126,'DAILY SHIFT','2020-09-02','2020-09-02 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-02 17:08:40','500','2020-09-02 17:09:22',10,0),('1','138',150129,'DAILY SHIFT','2020-09-02','2020-09-02 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-03 19:41:06','500','2020-09-03 19:41:28',10,0),('1','138',150386,'DAILY SHIFT','2020-09-03','2020-09-03 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-03 19:44:34','500','2020-09-03 19:44:52',10,0),('1','138',150562,'DAILY SHIFT','2020-09-05','2020-09-05 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-05 06:22:24','500','2020-09-05 06:22:53',10,0),('1','138',150722,'DAILY SHIFT','2020-09-05','2020-09-05 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-06 06:32:37','500','2020-09-06 06:33:01',10,0),('1','138',150817,'DAILY SHIFT','2020-09-06','2020-09-06 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-06 16:45:52','500','2020-09-06 16:47:21',10,0),('1','138',151154,'DAILY SHIFT','2020-09-08','2020-09-08 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-08 20:51:30','500','2020-09-08 20:51:53',10,0),('1','138',151273,'DAILY SHIFT','2020-09-09','2020-09-09 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-09 18:53:23','500','2020-09-09 18:53:42',10,0),('1','138',151420,'DAILY SHIFT','2020-09-10','2020-09-10 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-10 18:20:18','500','2020-09-10 18:21:08',10,0),('1','138',151551,'DAILY SHIFT','2020-09-11','2020-09-11 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-12 18:35:00','500','2020-09-12 18:35:40',10,0),('1','138',151695,'DAILY SHIFT','2020-09-12','2020-09-12 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-12 18:39:46','500','2020-09-12 18:40:06',10,0),('1','138',151805,'DAILY SHIFT','2020-09-13','2020-09-13 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-13 17:47:21','500','2020-09-13 17:47:47',10,0),('1','138',151949,'DAILY SHIFT','2020-09-14','2020-09-14 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-14 16:25:31','500','2020-09-14 16:26:23',10,0),('1','138',152011,'DAILY SHIFT','2020-09-14','2020-09-14 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-14 20:03:07','500','2020-09-14 20:05:22',10,0),('1','138',152155,'DAILY SHIFT','2020-09-15','2020-09-15 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-15 18:33:21','500','2020-09-15 18:34:29',10,0),('1','138',152310,'DAILY SHIFT','2020-09-16','2020-09-16 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-16 17:47:26','500','2020-09-16 17:47:47',10,0),('1','138',152312,'DAILY SHIFT','2020-09-16','2020-09-16 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-17 18:06:39','500','2020-09-17 18:06:59',10,0),('1','138',152455,'DAILY SHIFT','2020-09-17','2020-09-17 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-17 18:11:53','500','2020-09-17 18:12:11',10,0),('1','138',152587,'DAILY SHIFT','2020-09-18','2020-09-18 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-18 16:32:52','500','2020-09-18 16:33:15',10,0),('1','138',152592,'DAILY SHIFT','2020-09-18','2020-09-18 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-18 16:45:23','500','2020-09-18 16:45:43',10,0),('1','138',152595,'DAILY SHIFT','2020-09-18','2020-09-18 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-18 16:55:12','500','2020-09-18 16:55:38',10,0),('1','138',152597,'DAILY SHIFT','2020-09-18','2020-09-18 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-18 18:10:59','500','2020-09-18 18:11:25',10,0),('1','138',152603,'DAILY SHIFT','2020-09-18','2020-09-18 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-19 08:26:19','500','2020-09-19 08:26:42',10,0),('1','138',152747,'DAILY SHIFT','2020-09-19','2020-09-19 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-19 17:29:04','500','2020-09-19 17:29:26',10,0),('1','138',152872,'DAILY SHIFT','2020-09-20','2020-09-20 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-20 17:12:58','500','2020-09-20 17:13:17',10,0),('1','138',153075,'DAILY SHIFT','2020-09-21','2020-09-21 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-21 18:27:45','500','2020-09-21 18:28:03',10,0),('1','138',153255,'DAILY SHIFT','2020-09-22','2020-09-22 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-22 17:54:34','500','2020-09-22 17:54:51',10,0),('1','138',153382,'DAILY SHIFT','2020-09-23','2020-09-23 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-23 12:45:59','500','2020-09-23 12:46:16',10,0),('1','138',153463,'DAILY SHIFT','2020-09-23','2020-09-23 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-23 18:07:37','500','2020-09-23 18:08:16',10,0),('1','138',153640,'DAILY SHIFT','2020-09-24','2020-09-24 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-24 18:55:39','500','2020-09-24 18:56:07',10,0),('1','138',153800,'DAILY SHIFT','2020-09-25','2020-09-25 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-25 18:55:44','500','2020-09-25 18:56:29',10,0),('1','138',153918,'DAILY SHIFT','2020-09-26','2020-09-26 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-26 18:50:26','500','2020-09-26 18:51:03',10,0),('1','138',153923,'DAILY SHIFT','2020-09-26','2020-09-26 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-26 19:18:02','500','2020-09-26 19:19:00',10,0),('1','138',154041,'DAILY SHIFT','2020-09-27','2020-09-27 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-27 16:52:59','500','2020-09-27 16:53:18',10,0),('1','138',154176,'DAILY SHIFT','2020-09-28','2020-09-28 00:00:00',NULL,'500',0.00,0.00,'500','2020-09-28 14:43:40','500','2020-09-28 14:44:09',10,0),('1','138',154638,'DAILY SHIFT','2020-10-01','2020-10-01 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-01 19:27:46','500','2020-10-01 19:28:42',10,0),('1','138',154728,'Daily shift','2020-10-01','2020-10-01 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-01 19:35:06','500','2020-10-01 19:35:34',10,0),('1','138',154871,'Daily shift','2020-10-02','2020-10-02 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-02 19:18:35','500','2020-10-02 19:19:12',10,0),('1','138',155020,'Daily shift','2020-10-03','2020-10-03 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-03 19:36:40','500','2020-10-03 19:37:01',10,0),('1','138',155131,'Daily shift','2020-10-04','2020-10-04 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-04 19:35:03','500','2020-10-04 19:35:23',10,0),('1','138',155141,'DAILY SHIFT','2020-10-05','2020-10-05 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-05 19:24:45','500','2020-10-05 19:24:58',10,0),('1','138',155301,'Daily shift','2020-10-05','2020-10-05 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-05 19:31:11','500','2020-10-05 19:31:31',10,0),('1','138',155457,'Daily shift','2020-10-06','2020-10-06 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-06 19:55:08','500','2020-10-06 19:55:25',10,0),('1','138',155535,'DAILY SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-07 11:48:17','500','2020-10-07 11:48:41',10,0),('1','138',155538,'DAILY SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-07 12:05:31','500','2020-10-07 12:06:43',10,0),('1','138',155569,'DAILY SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-07 20:17:59','500','2020-10-07 20:18:35',10,0),('1','138',155644,'Daily shift','2020-10-07','2020-10-07 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-08 20:47:48','500','2020-10-08 20:48:07',10,0),('1','138',155781,'Daily shift','2020-10-08','2020-10-08 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-08 20:55:10','500','2020-10-08 20:55:53',10,0),('1','138',155887,'DAILY SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-09 15:39:48','500','2020-10-09 15:40:09',10,0),('1','138',155891,'DAILY SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-09 19:39:00','500','2020-10-09 19:39:15',10,0),('1','138',155929,'Daily shift','2020-10-09','2020-10-09 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-09 19:43:41','500','2020-10-09 19:44:45',10,0),('1','138',156073,'Daily shift','2020-10-10','2020-10-10 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-10 18:55:54','500','2020-10-10 18:56:18',10,0),('1','138',156194,'Daily shift','2020-10-11','2020-10-11 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-11 18:02:52','500','2020-10-11 18:03:41',10,0),('1','138',156291,'DAILY SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-12 11:32:38','500','2020-10-12 11:32:58',10,0),('1','138',156293,'DAILY SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-12 11:46:46','500','2020-10-12 11:47:13',10,0),('1','138',156422,'Daily shift','2020-10-12','2020-10-12 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-12 20:04:37','500','2020-10-12 20:04:58',10,0),('1','138',156512,'DAILY SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-13 13:40:05','500','2020-10-13 13:40:23',10,0),('1','138',156514,'DAILY SHIFT','2020-10-13','2020-10-13 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-13 13:47:00','500','2020-10-13 13:47:33',10,0),('1','138',156589,'DAILY SHIFT','2020-10-14','2020-10-14 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-14 08:03:28','500','2020-10-14 08:03:58',10,0),('1','138',157073,'Daily shift','2020-10-16','2020-10-16 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-16 18:19:58','500','2020-10-16 18:20:14',10,0),('1','138',157266,'Daily shift','2020-10-17','2020-10-17 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-17 18:16:29','500','2020-10-17 18:16:45',10,0),('1','138',157428,'DAILY SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-18 16:49:31','500','2020-10-18 16:50:06',10,0),('1','138',157429,'DAILY SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-18 18:22:12','500','2020-10-18 18:22:32',10,0),('1','138',157442,'Daily shift','2020-10-18','2020-10-18 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-19 15:50:26','500','2020-10-19 15:51:14',10,0),('1','138',157646,'DAILY SHIFT','2020-10-19','2020-10-19 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-19 18:35:27','500','2020-10-19 18:35:48',10,0),('1','138',157748,'DAILY SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-20 13:08:15','500','2020-10-20 13:08:45',10,0),('1','138',157750,'DAILY SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-20 13:20:15','500','2020-10-20 13:20:37',10,0),('1','138',157813,'Daily shift','2020-10-20','2020-10-20 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-20 18:50:28','500','2020-10-20 18:50:45',10,0),('1','138',157937,'Daily shift','2020-10-21','2020-10-21 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-21 17:04:06','500','2020-10-21 17:04:24',10,0),('1','138',158039,'DAILY SHIFT','2020-10-22','2020-10-22 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-22 19:12:36','500','2020-10-22 19:12:50',10,0),('1','138',158084,'Daily shift','2020-10-22','2020-10-22 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-22 19:16:33','500','2020-10-22 19:16:55',10,0),('1','138',158254,'Daily shift','2020-10-23','2020-10-23 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-23 18:10:53','500','2020-10-23 18:11:10',10,0),('1','138',158413,'Daily shift','2020-10-24','2020-10-24 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-24 18:27:49','500','2020-10-24 18:40:09',10,0),('1','138',158418,'Daily shift','2020-10-24','2020-10-24 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-25 17:48:57','500','2020-10-25 17:49:25',10,0),('1','138',158563,'Daily shift','2020-10-25','2020-10-25 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-25 17:51:42','500','2020-10-25 17:52:09',10,0),('1','138',158739,'Daily shift','2020-10-26','2020-10-26 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-26 17:55:49','500','2020-10-26 17:56:13',10,0),('1','138',158797,'DAILY SHIFT','2020-10-27','2020-10-27 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-27 09:09:35','500','2020-10-27 09:09:56',10,0),('1','138',159104,'DAILY SHIFT','2020-10-28','2020-10-28 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-28 18:04:13','500','2020-10-28 18:04:58',10,0),('1','138',159107,'Daily shift','2020-10-28','2020-10-28 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-28 18:07:35','500','2020-10-28 18:07:57',10,0),('1','138',159264,'DAILY SHIFT','2020-10-29','2020-10-29 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-29 18:24:15','500','2020-10-29 18:25:31',10,0),('1','138',159267,'Daily shift','2020-10-29','2020-10-29 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-29 18:28:57','500','2020-10-29 18:30:18',10,0),('1','138',159452,'Daily shift','2020-10-30','2020-10-30 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-30 19:23:36','500','2020-10-30 19:23:54',10,0),('1','138',159623,'Daily shift','2020-10-31','2020-10-31 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-31 21:12:28','500','2020-10-31 21:12:54',10,0),('1','138',159640,'Daily shift','2020-10-31','2020-10-31 00:00:00',NULL,'500',0.00,0.00,'500','2020-10-31 21:19:05','500','2020-10-31 21:19:41',10,0),('1','138',159721,'Daily shift','2020-11-01','2020-11-01 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-01 17:28:02','500','2020-11-01 17:28:19',10,0),('1','138',159722,'Daily shift','2020-11-01','2020-11-01 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-01 17:36:14','500','2020-11-01 17:36:30',10,0),('1','138',159726,'Daily shift','2020-11-01','2020-11-01 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-01 18:07:06','500','2020-11-01 18:07:26',10,0),('1','138',159915,'DAILY SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-02 17:14:27','500','2020-11-02 17:18:58',10,0),('1','138',159917,'DAILY SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-03 14:33:08','500','2020-11-03 14:33:33',10,0),('1','138',160125,'Daily shift','2020-11-03','2020-11-03 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-03 18:55:45','500','2020-11-03 18:56:03',10,0),('1','138',160294,'DAILY SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-04 17:13:46','500','2020-11-04 17:14:25',10,0),('1','138',160297,'DAILY SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-04 17:24:11','500','2020-11-04 17:24:41',10,0),('1','138',160380,'Daily shift','2020-11-05','2020-11-05 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-05 11:46:40','500','2020-11-05 11:47:06',10,0),('1','138',160455,'Daily shift','2020-11-05','2020-11-05 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-05 19:13:02','500','2020-11-05 19:13:20',10,0),('1','138',160587,'Daily shift','2020-11-06','2020-11-06 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-06 18:15:21','500','2020-11-06 18:15:44',10,0),('1','138',160640,'DAILY SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-07 09:30:26','500','2020-11-07 09:32:04',10,0),('1','138',160643,'DAILY SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-07 18:29:52','500','2020-11-07 18:30:12',10,0),('1','138',160744,'Daily shift','2020-11-07','2020-11-07 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-07 18:34:38','500','2020-11-07 18:34:57',10,0),('1','138',160881,'DAILY SHIFT','2020-11-08','2020-11-08 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-08 17:12:37','500','2020-11-08 17:13:27',10,0),('1','138',161084,'Daily shift','2020-11-09','2020-11-09 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-09 18:13:26','500','2020-11-09 18:13:47',10,0),('1','138',161086,'Daily shift','2020-11-09','2020-11-09 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-10 18:28:32','500','2020-11-10 18:28:58',10,0),('1','138',161263,'Daily shift','2020-11-10','2020-11-10 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-10 18:38:28','500','2020-11-10 18:39:33',10,0),('1','138',161451,'Daily shift','2020-11-11','2020-11-11 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-11 17:57:03','500','2020-11-11 17:59:14',10,0),('1','138',161656,'Daily shift','2020-11-12','2020-11-12 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-12 18:21:53','500','2020-11-12 18:22:18',10,0),('1','138',161865,'Daily shift','2020-11-13','2020-11-13 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-13 18:10:08','500','2020-11-13 18:10:47',10,0),('1','138',161985,'DAILY SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-14 13:44:22','500','2020-11-14 13:44:39',10,0),('1','138',162145,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-15 13:29:43','500','2020-11-15 13:30:24',10,0),('1','138',162149,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-15 13:47:49','500','2020-11-15 13:48:09',10,0),('1','138',162154,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-15 18:15:50','500','2020-11-15 18:16:04',10,0),('1','138',162232,'Daily shift','2020-11-15','2020-11-15 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-15 18:19:20','500','2020-11-15 18:19:39',10,0),('1','138',162449,'Daily shift','2020-11-16','2020-11-16 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-16 18:19:28','500','2020-11-16 18:20:10',10,0),('1','138',162639,'Daily shift','2020-11-17','2020-11-17 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-17 18:08:55','500','2020-11-17 18:09:12',10,0),('1','138',162800,'Daily shift','2020-11-18','2020-11-18 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-18 17:51:00','500','2020-11-18 17:51:18',10,0),('1','138',162971,'DAILY SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-19 15:28:50','500','2020-11-19 15:29:13',10,0),('1','138',163009,'Daily shift','2020-11-19','2020-11-19 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-19 19:15:27','500','2020-11-19 19:15:46',10,0),('1','138',163200,'Daily shift','2020-11-20','2020-11-20 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-20 18:10:41','500','2020-11-20 18:10:57',10,0),('1','138',163370,'Daily shift','2020-11-21','2020-11-21 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-21 18:28:54','500','2020-11-21 18:29:13',10,0),('1','138',163549,'Daily shift','2020-11-22','2020-11-22 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-22 19:30:14','500','2020-11-22 19:30:34',10,0),('1','138',163740,'Daily shift','2020-11-23','2020-11-23 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-23 18:39:28','500','2020-11-23 18:39:44',10,0),('1','138',163896,'Daily shift','2020-11-24','2020-11-24 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-24 18:03:08','500','2020-11-24 18:03:36',10,0),('1','138',164076,'Daily shift','2020-11-25','2020-11-25 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-25 18:18:42','500','2020-11-25 18:19:21',10,0),('1','138',164254,'Daily shift','2020-11-26','2020-11-26 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-26 18:23:28','500','2020-11-26 18:23:45',10,0),('1','138',164436,'Daily shift','2020-11-27','2020-11-27 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-27 18:39:33','500','2020-11-27 18:40:12',10,0),('1','138',164597,'Daily shift','2020-11-28','2020-11-28 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-28 18:23:46','500','2020-11-28 18:28:26',10,0),('1','138',164744,'Daily shift','2020-11-29','2020-11-29 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-29 17:54:03','500','2020-11-29 17:54:31',10,0),('1','138',164883,'DAILY SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-30 13:57:38','500','2020-11-30 13:57:57',10,0),('1','138',164961,'Daily shift','2020-11-30','2020-11-30 00:00:00',NULL,'500',0.00,0.00,'500','2020-11-30 18:12:44','500','2020-11-30 18:13:00',10,0),('1','138',165125,'Daily shift','2020-12-01','2020-12-01 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-01 18:14:46','500','2020-12-01 18:15:45',10,0),('1','138',165300,'Daily shift','2020-12-02','2020-12-02 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-02 18:33:37','500','2020-12-02 18:33:56',10,0),('1','138',165439,'Daily shift','2020-12-03','2020-12-03 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-03 18:23:47','500','2020-12-03 18:24:09',10,0),('1','138',165545,'DAILY SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-04 13:54:18','500','2020-12-04 13:54:52',10,0),('1','138',165554,'DAILY SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-04 14:39:26','500','2020-12-04 14:39:51',10,0),('1','138',165560,'DAILY SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-04 18:25:04','500','2020-12-04 18:25:23',10,0),('1','138',165611,'Daily shift','2020-12-04','2020-12-04 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-04 18:30:48','500','2020-12-04 18:31:07',10,0),('1','138',165795,'Daily shift','2020-12-05','2020-12-05 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-05 19:03:30','500','2020-12-05 19:03:52',10,0),('1','138',165923,'Daily shift','2020-12-06','2020-12-06 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-06 18:24:24','500','2020-12-06 18:24:42',10,0),('1','138',166139,'Daily shift','2020-12-07','2020-12-07 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-07 18:36:14','500','2020-12-07 18:36:35',10,0),('1','138',166170,'DAILY SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-08 08:12:02','500','2020-12-08 08:12:45',10,0),('1','138',166310,'Daily shift','2020-12-08','2020-12-08 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-08 18:20:47','500','2020-12-08 18:22:17',10,0),('1','138',166490,'Daily shift','2020-12-09','2020-12-09 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-09 18:27:08','500','2020-12-09 18:27:37',10,0),('1','138',166715,'DAILY SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-10 21:02:10','500','2020-12-10 21:02:45',10,0),('1','138',166890,'DAILY SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-11 21:00:39','500','2020-12-11 21:01:14',10,0),('1','138',167045,'DAILY SHIFT','2020-12-12','2020-12-12 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-12 23:01:12','500','2020-12-12 23:01:57',10,0),('1','138',167188,'DAILY SHIFT','2020-12-13','2020-12-13 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-13 21:50:25','500','2020-12-13 21:51:15',10,0),('1','138',167390,'DAILY SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-14 21:34:34','500','2020-12-14 21:35:52',10,0),('1','138',167542,'DAILY SHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-15 17:05:32','500','2020-12-15 17:06:09',10,0),('1','138',167570,'DAILY SHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-15 19:33:24','500','2020-12-15 19:35:58',10,0),('1','138',167732,'Daily shift','2020-12-16','2020-12-16 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-16 19:09:46','500','2020-12-16 19:10:04',10,0),('1','138',167912,'Daily shift','2020-12-17','2020-12-17 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-17 18:37:55','500','2020-12-17 18:38:15',10,0),('1','138',168036,'DAILY SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-18 14:16:45','500','2020-12-18 14:17:14',10,0),('1','138',168046,'DAILY SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-18 14:55:52','500','2020-12-18 14:56:44',10,0),('1','138',168052,'DAILY SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-18 15:08:06','500','2020-12-18 15:09:23',10,0),('1','138',168054,'DAILY SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-18 15:15:51','500','2020-12-18 15:16:59',10,0),('1','138',168111,'Daily shift','2020-12-18','2020-12-18 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-18 18:32:00','500','2020-12-18 18:32:17',10,0),('1','138',168285,'Daily shift','2020-12-19','2020-12-19 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-19 18:47:45','500','2020-12-19 18:48:51',10,0),('1','138',168410,'Daily shift','2020-12-20','2020-12-20 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-20 18:40:59','500','2020-12-20 18:41:54',10,0),('1','138',168468,'DAILY SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-21 18:27:22','500','2020-12-21 18:27:58',10,0),('1','138',168735,'DAILY SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-22 15:45:39','500','2020-12-22 15:46:07',10,0),('1','138',168940,'Daily shift','2020-12-23','2020-12-23 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-23 20:16:09','500','2020-12-23 20:16:29',10,0),('1','138',169085,'DAILY SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-24 17:32:10','500','2020-12-24 17:32:30',10,0),('1','138',169122,'Daily shift','2020-12-24','2020-12-24 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-24 22:25:26','500','2020-12-24 22:25:56',10,0),('1','138',169274,'Daily shift','2020-12-25','2020-12-25 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-25 20:29:53','500','2020-12-25 20:31:05',10,0),('1','138',169399,'DAILY SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-26 16:05:49','500','2020-12-26 16:06:09',10,0),('1','138',169403,'DAILY SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-26 16:12:15','500','2020-12-26 16:13:30',10,0),('1','138',169408,'DAILY SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-26 16:22:41','500','2020-12-26 16:23:15',10,0),('1','138',169411,'DAILY SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-26 16:31:03','500','2020-12-26 16:31:29',10,0),('1','138',169413,'DAILY SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-26 16:38:52','500','2020-12-26 16:39:14',10,0),('1','138',169414,'DAILY SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-26 16:43:54','500','2020-12-26 16:44:20',10,0),('1','138',169416,'DAILY SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-26 16:49:20','500','2020-12-26 16:49:42',10,0),('1','138',169420,'DAILY SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-26 17:01:19','500','2020-12-26 17:01:39',10,0),('1','138',169443,'Daily shift','2020-12-26','2020-12-26 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-26 18:59:36','500','2020-12-26 19:00:12',10,0),('1','138',169567,'Daily shift','2020-12-27','2020-12-27 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-27 18:30:38','500','2020-12-27 18:31:20',10,0),('1','138',169692,'DAILY SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-28 12:45:37','500','2020-12-28 12:45:56',10,0),('1','138',169695,'DAILY SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-28 18:23:24','500','2020-12-28 18:23:45',10,0),('1','138',169766,'Daily shift','2020-12-28','2020-12-28 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-28 18:27:59','500','2020-12-28 18:28:24',10,0),('1','138',169923,'Daily shift','2020-12-29','2020-12-29 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-29 18:32:33','500','2020-12-29 18:32:50',10,0),('1','138',170122,'Daily shift','2020-12-30','2020-12-30 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-30 17:56:42','500','2020-12-30 17:56:57',10,0),('1','138',170300,'DAILY SHIFT','2020-12-31','2020-12-31 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-31 16:02:21','500','2020-12-31 16:02:42',10,0),('1','138',170305,'DAILY SHIFT','2020-12-31','2020-12-31 00:00:00',NULL,'500',0.00,0.00,'500','2020-12-31 16:11:06','500','2020-12-31 16:11:26',10,0),('1','138',170481,'DAILY SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-01 18:13:39','500','2021-01-01 18:14:45',10,0),('1','138',170650,'Daily shift','2021-01-02','2021-01-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-02 18:39:31','500','2021-01-02 18:39:51',10,0),('1','138',170732,'DAILY SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-03 12:00:08','500','2021-01-03 12:00:32',10,0),('1','138',170733,'DAILY SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-03 12:06:44','500','2021-01-03 12:07:05',10,0),('1','138',170734,'DAILY SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-03 12:24:04','500','2021-01-03 12:24:22',10,0),('1','138',170807,'Daily shift','2021-01-03','2021-01-03 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-03 18:00:56','500','2021-01-03 18:01:09',10,0),('1','138',170977,'Daily shift','2021-01-04','2021-01-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-04 18:31:11','500','2021-01-04 18:31:41',10,0),('1','138',171208,'Daily shift','2021-01-05','2021-01-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-05 19:09:55','500','2021-01-05 19:10:28',10,0),('1','138',171287,'DAILY SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-06 12:47:05','500','2021-01-06 12:48:06',10,0),('1','138',171291,'DAILY SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-06 13:00:24','500','2021-01-06 13:00:57',10,0),('1','138',171370,'Daily shift','2021-01-06','2021-01-06 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-06 18:58:10','500','2021-01-06 18:58:51',10,0),('1','138',171583,'Daily shift','2021-01-07','2021-01-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-07 20:29:25','500','2021-01-07 20:29:45',10,0),('1','138',171762,'Daily shift','2021-01-08','2021-01-08 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-08 19:03:58','500','2021-01-08 19:04:11',10,0),('1','138',171871,'DAILY SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-09 12:40:58','500','2021-01-09 12:41:16',10,0),('1','138',171872,'DAILY SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-09 12:49:29','500','2021-01-09 12:49:45',10,0),('1','138',171948,'Daily shift','2021-01-09','2021-01-09 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-09 20:07:48','500','2021-01-09 20:08:09',10,0),('1','138',172077,'Daily shift','2021-01-10','2021-01-10 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-10 18:39:29','500','2021-01-10 18:39:43',10,0),('1','138',172222,'DAILY SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-11 14:57:30','500','2021-01-11 14:57:51',10,0),('1','138',172225,'DAILY SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-11 15:06:44','500','2021-01-11 15:07:02',10,0),('1','138',172262,'DAILY SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-11 17:37:53','500','2021-01-11 17:38:14',10,0),('1','138',172474,'DAILY SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-12 17:45:41','500','2021-01-12 17:46:01',10,0),('1','138',172692,'Daily shift','2021-01-13','2021-01-13 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-13 18:25:27','500','2021-01-13 18:26:19',10,0),('1','138',172726,'DAILY SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-14 09:03:22','500','2021-01-14 09:03:46',10,0),('1','138',172729,'DAILY SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-14 09:19:33','500','2021-01-14 09:19:58',10,0),('1','138',172866,'Daily shift','2021-01-14','2021-01-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-14 18:51:42','500','2021-01-14 18:51:58',10,0),('1','138',173058,'Daily shift','2021-01-15','2021-01-15 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-15 21:44:48','500','2021-01-15 21:46:55',10,0),('1','138',173217,'Daily shift','2021-01-16','2021-01-16 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-16 21:40:34','500','2021-01-16 21:40:51',10,0),('1','138',173219,'Daily shift','2021-01-16','2021-01-16 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-16 21:52:04','500','2021-01-16 21:52:18',10,0),('1','138',173220,'Daily shift','2021-01-16','2021-01-16 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-16 21:57:11','500','2021-01-16 21:57:27',10,0),('1','138',173388,'Daily shift','2021-01-17','2021-01-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-17 21:13:42','500','2021-01-17 21:15:19',10,0),('1','138',173596,'Daily shift','2021-01-18','2021-01-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-18 21:18:02','500','2021-01-18 21:18:15',10,0),('1','138',173597,'Daily shift','2021-01-18','2021-01-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-18 21:27:37','500','2021-01-18 21:28:11',10,0),('1','138',173599,'Daily shift','2021-01-18','2021-01-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-18 21:30:35','500','2021-01-18 21:30:51',10,0),('1','138',173755,'Daily shift','2021-01-19','2021-01-19 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-19 18:47:09','500','2021-01-19 18:47:26',10,0),('1','138',173931,'Daily shift','2021-01-20','2021-01-20 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-20 18:22:52','500','2021-01-20 18:23:08',10,0),('1','138',173987,'DAILY SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-21 09:29:24','500','2021-01-21 09:29:42',10,0),('1','138',173988,'DAILY SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-21 09:38:41','500','2021-01-21 09:38:59',10,0),('1','138',174122,'Daily shift','2021-01-21','2021-01-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-21 19:01:04','500','2021-01-21 19:01:21',10,0),('1','138',174311,'Daily shift','2021-01-22','2021-01-22 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-22 18:41:37','500','2021-01-22 18:41:53',10,0),('1','138',174446,'DAILY SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-23 15:11:53','500','2021-01-23 15:12:11',10,0),('1','138',174448,'DAILY SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-23 15:21:52','500','2021-01-23 15:22:14',10,0),('1','138',174482,'Daily shift','2021-01-23','2021-01-23 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-23 19:11:57','500','2021-01-23 19:12:19',10,0),('1','138',174647,'DAILY SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-24 21:25:45','500','2021-01-24 21:26:55',10,0),('1','138',174845,'DAILY SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-25 21:49:34','500','2021-01-25 21:50:09',10,0),('1','138',174865,'DAILY SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-26 08:54:48','500','2021-01-26 08:55:19',10,0),('1','138',175227,'Daily shift','2021-01-27','2021-01-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-27 18:46:54','500','2021-01-27 18:47:10',10,0),('1','138',175399,'Daily shift','2021-01-28','2021-01-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-28 18:21:36','500','2021-01-28 18:21:52',10,0),('1','138',175586,'Daily shift','2021-01-29','2021-01-29 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-29 18:40:22','500','2021-01-29 18:40:50',10,0),('1','138',175756,'Daily shift','2021-01-30','2021-01-30 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-30 20:22:20','500','2021-01-30 20:23:18',10,0),('1','138',175759,'Daily shift','2021-01-30','2021-01-30 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-30 22:32:55','500','2021-01-30 22:33:19',10,0),('1','138',175920,'DAILY SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'500',0.00,0.00,'500','2021-01-31 21:00:37','500','2021-01-31 21:01:16',10,0),('1','138',176141,'DAILY SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-01 19:47:39','500','2021-02-01 19:48:20',10,0),('1','138',176325,'Daily shift','2021-02-02','2021-02-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-02 20:04:50','500','2021-02-02 20:05:23',10,0),('1','138',176327,'Daily shift','2021-02-02','2021-02-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-02 20:17:04','500','2021-02-02 20:18:06',10,0),('1','138',176529,'Daily shift','2021-02-03','2021-02-03 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-03 18:49:31','500','2021-02-03 18:51:04',10,0),('1','138',176754,'Daily shift','2021-02-04','2021-02-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-04 18:51:17','500','2021-02-04 18:51:34',10,0),('1','138',176946,'DAILY SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-05 17:30:57','500','2021-02-05 17:31:17',10,0),('1','138',176949,'DAILY SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-05 17:36:34','500','2021-02-05 17:36:51',10,0),('1','138',177213,'Daily shift','2021-02-06','2021-02-06 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-06 19:44:03','500','2021-02-06 19:44:17',10,0),('1','138',177403,'Daily shift','2021-02-07','2021-02-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-07 18:26:22','500','2021-02-07 18:26:39',10,0),('1','138',177609,'Daily shift','2021-02-08','2021-02-08 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-08 18:47:04','500','2021-02-08 18:47:39',10,0),('1','138',177737,'Daily shift','2021-02-09','2021-02-09 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-09 12:04:55','500','2021-02-09 12:05:11',10,0),('1','138',177739,'Daily shift','2021-02-09','2021-02-09 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-09 18:11:56','500','2021-02-09 18:12:29',10,0),('1','138',177857,'Daily shift','2021-02-09','2021-02-09 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-09 18:15:40','500','2021-02-09 18:16:08',10,0),('1','138',178050,'Daily shift','2021-02-10','2021-02-10 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-10 18:24:28','500','2021-02-10 18:24:43',10,0),('1','138',178269,'Daily shift','2021-02-11','2021-02-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-11 18:25:39','500','2021-02-11 18:25:53',10,0),('1','138',178466,'Daily shift','2021-02-12','2021-02-12 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-12 18:31:03','500','2021-02-12 18:31:15',10,0),('1','138',178558,'DAILY SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-13 10:14:50','500','2021-02-13 10:15:15',10,0),('1','138',178562,'DAILY SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-13 10:22:19','500','2021-02-13 10:22:48',10,0),('1','138',178700,'Daily shift','2021-02-13','2021-02-13 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-13 18:39:53','500','2021-02-13 18:41:08',10,0),('1','138',178866,'DAILY SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-14 17:41:49','500','2021-02-14 17:42:08',10,0),('1','138',178928,'DAILY SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-15 18:07:24','500','2021-02-15 18:44:48',10,0),('1','138',179111,'DAILY SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-15 19:18:20','500','2021-02-15 19:18:45',10,0),('1','138',179350,'Daily shift','2021-02-16','2021-02-16 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-16 18:40:01','500','2021-02-16 18:40:19',10,0),('1','138',179378,'DAILY SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-17 17:54:32','500','2021-02-17 17:54:53',10,0),('1','138',179574,'DAILY SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-18 09:24:21','500','2021-02-18 09:24:41',10,0),('1','138',179609,'DAILY SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-18 09:50:23','500','2021-02-18 09:50:39',10,0),('1','138',179621,'DAILY SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-18 17:57:10','500','2021-02-18 17:57:32',10,0),('1','138',179774,'DAILY SHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-19 17:47:00','500','2021-02-19 17:47:18',10,0),('1','138',180005,'DAILY SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-20 18:11:39','500','2021-02-20 18:11:56',10,0),('1','138',180178,'DAILY SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-21 16:54:21','500','2021-02-21 16:54:42',10,0),('1','138',180299,'DAILY SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-21 17:05:42','500','2021-02-21 17:06:07',10,0),('1','138',180338,'DAILY SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-22 18:30:30','500','2021-02-22 18:30:58',10,0),('1','138',180548,'DAILY SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-23 18:23:07','500','2021-02-23 18:23:32',10,0),('1','138',180738,'DAILY SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-24 17:54:30','500','2021-02-24 17:54:46',10,0),('1','138',180958,'DAILY SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-25 11:21:44','500','2021-02-25 11:22:13',10,0),('1','138',181021,'DAILY SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-25 11:29:55','500','2021-02-25 11:30:13',10,0),('1','138',181133,'DAILY SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-26 18:01:01','500','2021-02-26 18:02:18',10,0),('1','138',181335,'DAILY SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-27 18:23:09','500','2021-02-27 18:23:29',10,0),('1','138',181525,'DAILY SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-28 10:24:43','500','2021-02-28 10:25:04',10,0),('1','138',181572,'DAILY SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-28 10:34:37','500','2021-02-28 10:34:57',10,0),('1','138',181589,'DAILY SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-02-28 17:56:01','500','2021-02-28 17:56:47',10,0),('1','138',181709,'DAILY SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-01 18:23:49','500','2021-03-01 18:24:09',10,0),('1','138',181906,'DAILY SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-02 15:56:15','500','2021-03-02 15:56:35',10,0),('1','138',182065,'DAILY SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-02 16:09:19','500','2021-03-02 16:09:36',10,0),('1','138',182068,'DAILY SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-03 18:04:07','500','2021-03-03 18:04:32',10,0),('1','138',182310,'DAILY SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-04 18:04:09','500','2021-03-04 18:04:31',10,0),('1','138',182481,'DAILY SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-05 06:36:12','500','2021-03-05 06:36:28',10,0),('1','138',182500,'DAILY SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-05 18:34:44','500','2021-03-05 18:35:09',10,0),('1','138',182688,'DAILY SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-08 12:11:39','500','2021-03-08 12:12:21',10,0),('1','138',183091,'DAILY SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-08 12:23:43','500','2021-03-08 12:24:01',10,0),('1','138',183096,'DAILY SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-08 12:40:16','500','2021-03-08 12:40:37',10,0),('1','138',183148,'DAILY SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-08 15:44:57','500','2021-03-08 15:45:14',10,0),('1','138',183150,'DAILY SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-08 15:59:01','500','2021-03-08 15:59:18',10,0),('1','138',183207,'DAILY SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-09 18:31:08','500','2021-03-09 18:33:25',10,0),('1','138',183427,'DAILY SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-10 18:41:29','500','2021-03-10 18:42:22',10,0),('1','138',183730,'DAILY SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-11 17:11:11','500','2021-03-11 17:11:31',10,0),('1','138',183826,'Daily shift','2021-03-11','2021-03-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-11 17:23:23','500','2021-03-11 17:23:44',10,0),('1','138',183849,'DAILY SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-11 20:18:45','500','2021-03-11 20:19:15',10,0),('1','138',183894,'Daily shift','2021-03-11','2021-03-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-12 07:02:51','500','2021-03-12 07:03:11',10,0),('1','138',183905,'DAILY SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-12 18:37:00','500','2021-03-12 18:37:35',10,0),('1','138',184270,'DAILY SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-14 07:27:54','500','2021-03-14 07:51:56',10,0),('1','138',184292,'DAILY SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-14 08:00:23','500','2021-03-14 08:00:52',10,0),('1','138',184297,'Daily shift','2021-03-14','2021-03-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-14 08:54:38','500','2021-03-14 08:54:59',10,0),('1','138',184307,'DAILY SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-14 18:02:15','500','2021-03-14 18:02:43',10,0),('1','138',184485,'DAILY SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-15 18:33:26','500','2021-03-15 18:34:03',10,0),('1','138',184664,'Daily shift','2021-03-15','2021-03-15 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-15 20:08:51','500','2021-03-15 20:09:11',10,0),('1','138',184687,'DAILY SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-16 18:19:01','500','2021-03-16 18:19:20',10,0),('1','138',184883,'DAILY SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-17 12:14:04','500','2021-03-17 12:14:32',10,0),('1','138',185003,'Daily shift','2021-03-17','2021-03-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-17 13:58:13','500','2021-03-17 13:58:35',10,0),('1','138',185015,'DAILY SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-17 18:14:40','500','2021-03-17 18:15:17',10,0),('1','138',185107,'DAILY SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-18 18:26:50','500','2021-03-18 18:27:22',10,0),('1','138',185259,'DAILY SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-19 11:55:06','500','2021-03-19 11:56:25',10,0),('1','138',185325,'DAILY SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-19 17:53:42','500','2021-03-19 17:54:06',10,0),('1','138',185468,'DAILY SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-20 18:19:37','500','2021-03-20 18:20:02',10,0),('1','138',185677,'DAILY SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-21 13:02:26','500','2021-03-21 13:02:46',10,0),('1','138',185777,'DAILY SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-21 13:10:42','500','2021-03-21 13:11:01',10,0),('1','138',185870,'DAILY SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-22 18:30:34','500','2021-03-22 18:30:57',10,0),('1','138',186095,'DAILY SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-23 18:33:46','500','2021-03-23 18:34:11',10,0),('1','138',186345,'DAILY SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-24 08:36:40','500','2021-03-24 08:37:08',10,0),('1','138',186359,'DAILY SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-24 08:45:21','500','2021-03-24 08:45:43',10,0),('1','138',186615,'DAILY SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-25 18:18:45','500','2021-03-25 18:19:05',10,0),('1','138',186751,'DAILY SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-26 15:32:53','500','2021-03-26 15:33:13',10,0),('1','138',186903,'DAILY SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-26 15:43:11','500','2021-03-26 15:43:39',10,0),('1','138',186980,'DAILY SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-27 18:39:08','500','2021-03-27 18:39:30',10,0),('1','138',187163,'DAILY SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-28 17:25:45','500','2021-03-28 17:26:13',10,0),('1','138',187360,'DAILY SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-29 13:22:36','500','2021-03-29 13:22:58',10,0),('1','138',187480,'DAILY SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-29 13:44:54','500','2021-03-29 13:45:13',10,0),('1','138',187487,'DAILY SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-29 17:43:23','500','2021-03-29 17:43:50',10,0),('1','138',187586,'DAILY SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-30 18:20:54','500','2021-03-30 18:21:15',10,0),('1','138',187802,'DAILY SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-31 18:19:31','500','2021-03-31 18:19:58',10,0),('1','138',187982,'DAILY SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'500',0.00,0.00,'500','2021-03-31 18:28:40','500','2021-03-31 18:28:57',10,0),('1','138',188018,'DAILY SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-01 18:38:26','500','2021-04-01 18:38:54',10,0),('1','138',188234,'DAILY SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-02 18:22:32','500','2021-04-02 18:23:00',10,0),('1','138',188417,'DAILY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-03 13:26:25','500','2021-04-03 13:26:48',10,0),('1','138',188517,'Daily shift','2021-04-03','2021-04-03 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-03 13:52:46','500','2021-04-03 13:53:13',10,0),('1','138',188528,'DAILY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-03 19:06:06','500','2021-04-03 19:06:37',10,0),('1','138',188605,'DAILY SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-04 18:11:13','500','2021-04-04 18:11:43',10,0),('1','138',188805,'DAILY SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-05 12:47:58','500','2021-04-05 12:50:05',10,0),('1','138',188899,'DAILY SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-05 13:34:03','500','2021-04-05 13:34:25',10,0),('1','138',188915,'DAILY SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-05 19:31:31','500','2021-04-05 19:31:59',10,0),('1','138',189028,'DAILY SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-06 17:32:53','500','2021-04-06 17:33:18',10,0),('1','138',189202,'DAILY SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-07 11:13:54','500','2021-04-07 11:14:24',10,0),('1','138',189299,'DAILY SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-07 11:27:01','500','2021-04-07 11:27:24',10,0),('1','138',189324,'DAILY SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-07 17:51:37','500','2021-04-07 17:51:55',10,0),('1','138',189431,'DAILY SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-08 17:45:23','500','2021-04-08 17:45:46',10,0),('1','138',189623,'DAILY SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-09 17:18:22','500','2021-04-09 17:18:49',10,0),('1','138',189778,'DAILY SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-09 17:27:10','500','2021-04-09 17:27:28',10,0),('1','138',189814,'DAILY SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-10 17:54:12','500','2021-04-10 17:54:31',10,0),('1','138',190030,'DAILY SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-11 17:50:12','500','2021-04-11 17:50:30',10,0),('1','138',190215,'DAILY SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-12 14:04:49','500','2021-04-12 14:05:19',10,0),('1','138',190362,'DAILY SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-12 15:27:16','500','2021-04-12 15:27:32',10,0),('1','138',190374,'DAILY SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-12 18:06:28','500','2021-04-12 18:06:46',10,0),('1','138',190436,'DAILY SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-13 18:12:46','500','2021-04-13 18:13:08',10,0),('1','138',190668,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-14 15:32:31','500','2021-04-14 15:32:49',10,0),('1','138',190838,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-16 06:42:08','500','2021-04-16 06:42:27',10,0),('1','138',191088,'DAILY SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-16 17:56:08','500','2021-04-16 17:56:30',10,0),('1','138',191299,'DAILY SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-17 17:48:12','500','2021-04-17 17:48:33',10,0),('1','138',191469,'Daily shift','2021-04-17','2021-04-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-17 18:19:24','500','2021-04-17 18:19:42',10,0),('1','138',191493,'DAILY SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-18 17:41:37','500','2021-04-18 17:41:58',10,0),('1','138',191711,'DAILY SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-19 17:29:42','500','2021-04-19 17:30:08',10,0),('1','138',191939,'DAILY SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-20 17:46:45','500','2021-04-20 17:47:08',10,0),('1','138',192127,'DAILY shifts','2021-04-21','2021-04-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-21 09:18:21','500','2021-04-21 09:18:50',10,0),('1','138',192186,'DAILY SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-21 10:14:26','500','2021-04-21 10:14:49',10,0),('1','138',192201,'DAILY SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-21 17:29:29','500','2021-04-21 17:29:57',10,0),('1','138',192339,'DAILY SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-22 17:37:09','500','2021-04-22 17:37:42',10,0),('1','138',192573,'DAILY SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-23 17:37:10','500','2021-04-23 17:37:50',10,0),('1','138',192752,'DAILY SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-24 14:30:58','500','2021-04-24 14:31:29',10,0),('1','138',192884,'DAILY SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-24 14:45:46','500','2021-04-24 14:46:12',10,0),('1','138',192889,'DAILY SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-24 17:39:01','500','2021-04-24 17:39:23',10,0),('1','138',192953,'DAILY SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-25 17:11:04','500','2021-04-25 17:11:28',10,0),('1','138',193165,'DAILY SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-26 17:14:19','500','2021-04-26 17:15:26',10,0),('1','138',193421,'DAILY SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-27 17:19:32','500','2021-04-27 17:20:06',10,0),('1','138',193617,'DAILY SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-28 12:37:40','500','2021-04-28 12:38:17',10,0),('1','138',193747,'DAILY SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-28 13:44:31','500','2021-04-28 13:44:59',10,0),('1','138',193752,'DAILY SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-28 13:52:09','500','2021-04-28 13:52:34',10,0),('1','138',193756,'DAILY SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-28 17:15:22','500','2021-04-28 17:15:44',10,0),('1','138',193877,'DAILY SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-29 17:26:41','500','2021-04-29 17:27:30',10,0),('1','138',194079,'DAILY SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'500',0.00,0.00,'500','2021-04-30 17:31:32','500','2021-04-30 17:31:56',10,0),('1','138',194282,'DAILY SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-01 18:20:32','500','2021-05-01 18:22:03',10,0),('1','138',194512,'DAILY SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-02 07:57:23','500','2021-05-02 07:57:56',10,0),('1','138',194514,'DAILY SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-02 08:11:43','500','2021-05-02 08:12:09',10,0),('1','138',194527,'DAILY SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-02 17:19:42','500','2021-05-02 17:20:07',10,0),('1','138',194662,'DAILY SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-03 17:10:48','500','2021-05-03 17:11:15',10,0),('1','138',194876,'DAILY SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-05 07:43:00','500','2021-05-05 07:43:22',10,0),('1','138',195113,'DAILY SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-05 14:31:26','500','2021-05-05 14:32:09',10,0),('1','138',195246,'DAILY SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-05 14:57:06','500','2021-05-05 14:57:29',10,0),('1','138',195258,'DAILY SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-05 17:47:20','500','2021-05-05 17:47:41',10,0),('1','138',195320,'DAILY SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-06 18:02:14','500','2021-05-06 18:03:58',10,0),('1','138',195542,'DAILY SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-07 17:30:47','500','2021-05-07 17:31:08',10,0),('1','138',195791,'DAILY SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-08 17:20:58','500','2021-05-08 17:21:29',10,0),('1','138',196005,'DAILY SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-09 08:52:43','500','2021-05-09 08:53:08',10,0),('1','138',196065,'DAILY SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-09 17:11:16','500','2021-05-09 17:11:47',10,0),('1','138',196248,'DAILY SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-10 18:02:34','500','2021-05-10 18:03:08',10,0),('1','138',196453,'DAILY SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-11 17:59:34','500','2021-05-11 17:59:59',10,0),('1','138',196660,'DAILY SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-12 14:42:48','500','2021-05-12 14:43:14',10,0),('1','138',196796,'DAILY SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-12 15:01:57','500','2021-05-12 15:02:18',10,0),('1','138',196810,'DAILY SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-13 04:53:40','500','2021-05-13 04:54:10',10,0),('1','138',196899,'DAILY SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-13 19:55:44','500','2021-05-13 19:56:12',10,0),('1','138',197030,'DAILY SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-14 17:51:41','500','2021-05-14 17:52:01',10,0),('1','138',197414,'DAILY SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-16 13:45:46','500','2021-05-16 13:46:07',10,0),('1','138',197421,'DAILY SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-16 17:47:28','500','2021-05-16 17:47:59',10,0),('1','138',197526,'DAILY SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-17 11:54:06','500','2021-05-17 11:54:29',10,0),('1','138',197669,'DAILY SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-17 12:03:59','500','2021-05-17 12:04:18',10,0),('1','138',197674,'DAILY SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-17 12:08:29','500','2021-05-17 12:08:51',10,0),('1','138',197680,'DAILY SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-17 17:57:59','500','2021-05-17 17:58:27',10,0),('1','138',197877,'DAILY SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-18 17:32:03','500','2021-05-18 17:32:34',10,0),('1','138',198118,'DAILY SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-19 17:34:49','500','2021-05-19 17:35:14',10,0),('1','138',198362,'DAILY SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-20 18:10:24','500','2021-05-20 18:10:47',10,0),('1','138',198575,'DAILY SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-21 15:26:51','500','2021-05-21 15:27:16',10,0),('1','138',198712,'DAILY SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-21 15:37:03','500','2021-05-21 15:37:26',10,0),('1','138',198714,'DAILY SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-21 15:42:55','500','2021-05-21 15:43:17',10,0),('1','138',198716,'DAILY SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-22 07:01:18','500','2021-05-22 07:01:46',10,0),('1','138',198794,'DAILY SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-22 17:50:17','500','2021-05-22 17:50:47',10,0),('1','138',198995,'DAILY SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-23 17:11:50','500','2021-05-23 17:12:17',10,0),('1','138',199223,'DAILY SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-24 18:13:49','500','2021-05-24 18:14:18',10,0),('1','138',199443,'DAILY SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-25 11:27:45','500','2021-05-25 11:28:15',10,0),('1','138',199539,'DAILY SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-25 11:41:33','500','2021-05-25 11:41:58',10,0),('1','138',199541,'DAILY SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-25 11:57:50','500','2021-05-25 11:58:17',10,0),('1','138',199542,'DAILY SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-25 17:50:58','500','2021-05-25 17:51:28',10,0),('1','138',199666,'DAILY SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-26 17:45:48','500','2021-05-26 17:46:18',10,0),('1','138',199887,'DAILY SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-27 17:58:30','500','2021-05-27 17:59:09',10,0),('1','138',200099,'DAILY SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-28 16:30:50','500','2021-05-28 16:31:22',10,0),('1','138',200257,'DAILY SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-28 17:04:37','500','2021-05-28 17:05:11',10,0),('1','138',200261,'DAILY SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-28 17:20:34','500','2021-05-28 17:20:55',10,0),('1','138',200293,'DAILY SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-29 17:59:40','500','2021-05-29 18:00:07',10,0),('1','138',200494,'DAILY SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-30 17:59:07','500','2021-05-30 17:59:33',10,0),('1','138',200701,'DAILY SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'500',0.00,0.00,'500','2021-05-31 18:15:09','500','2021-05-31 18:15:38',10,0),('1','138',200935,'DAILY SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-01 18:17:41','500','2021-06-01 18:18:09',10,0),('1','138',201112,'DAILY SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-02 06:26:41','500','2021-06-02 06:27:28',10,0),('1','138',201121,'DAILY SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-02 17:57:01','500','2021-06-02 17:57:29',10,0),('1','138',201327,'DAILY SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-03 18:24:42','500','2021-06-03 18:25:27',10,0),('1','138',201516,'DAILY SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-04 18:11:55','500','2021-06-04 18:12:23',10,0),('1','138',201871,'DAILY SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-05 11:57:19','500','2021-06-05 11:58:00',10,0),('1','138',201874,'DAILY SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-05 12:08:45','500','2021-06-05 12:09:07',10,0),('1','138',201878,'DAILY SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-05 12:16:06','500','2021-06-05 12:16:28',10,0),('1','138',201980,'DAILY SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-05 18:33:26','500','2021-06-05 18:33:52',10,0),('1','138',202084,'DAILY SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-06 10:20:53','500','2021-06-06 10:21:15',10,0),('1','138',202087,'DAILY SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-06 16:00:06','500','2021-06-06 16:00:31',10,0),('1','138',202168,'DAILY SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-06 17:41:55','500','2021-06-06 17:42:18',10,0),('1','138',202221,'DAILY SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-07 18:08:24','500','2021-06-07 18:08:51',10,0),('1','138',202438,'DAILY SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-08 14:25:36','500','2021-06-08 14:26:07',10,0),('1','138',202562,'DAILY SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-08 14:35:19','500','2021-06-08 14:35:55',10,0),('1','138',202565,'DAILY SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-08 15:09:07','500','2021-06-08 15:09:30',10,0),('1','138',202582,'DAILY SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-08 17:52:53','500','2021-06-08 17:53:16',10,0),('1','138',202649,'DAILY SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-09 17:44:32','500','2021-06-09 17:45:04',10,0),('1','138',202870,'DAILY SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-10 18:06:48','500','2021-06-10 18:07:16',10,0),('1','138',203118,'DAILY SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-12 07:59:33','500','2021-06-12 08:00:04',10,0),('1','138',203339,'DAILY SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-12 08:08:28','500','2021-06-12 08:08:48',10,0),('1','138',203344,'DAILY SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-12 08:37:58','500','2021-06-12 08:38:19',10,0),('1','138',203384,'DAILY SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-12 18:08:54','500','2021-06-12 18:09:18',10,0),('1','138',203543,'DAILY SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-13 18:08:44','500','2021-06-13 18:09:11',10,0),('1','138',203728,'DAILY SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-14 15:13:59','500','2021-06-14 15:14:48',10,0),('1','138',203904,'DAILY SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-14 15:52:57','500','2021-06-14 15:53:17',10,0),('1','138',203908,'DAILY SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-14 16:03:18','500','2021-06-14 16:03:46',10,0),('1','138',203914,'DAILY SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-14 17:40:34','500','2021-06-14 17:40:58',10,0),('1','138',203934,'DAILY SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-14 19:04:12','500','2021-06-14 19:04:32',10,0),('1','138',203981,'DAILY SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-15 17:08:35','500','2021-06-15 17:09:51',10,0),('1','138',204216,'DAILY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-16 17:38:08','500','2021-06-16 17:42:55',10,0),('1','138',204414,'DAILY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-17 18:00:51','500','2021-06-17 18:01:17',10,0),('1','138',204629,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-18 15:03:29','500','2021-06-18 15:03:49',10,0),('1','138',204753,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-18 15:09:06','500','2021-06-18 15:09:25',10,0),('1','138',204756,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-18 15:25:42','500','2021-06-18 15:26:05',10,0),('1','138',204926,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-19 13:47:15','500','2021-06-19 13:47:37',10,0),('1','138',204973,'DAILY SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-19 17:32:52','500','2021-06-19 17:33:22',10,0),('1','138',205044,'DAILY SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-20 17:50:39','500','2021-06-20 17:51:01',10,0),('1','138',205266,'DAILY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-21 17:50:07','500','2021-06-21 17:50:30',10,0),('1','138',205500,'DAILY SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-22 17:57:54','500','2021-06-22 17:58:16',10,0),('1','138',205801,'DAILY SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-23 10:22:23','500','2021-06-23 10:23:06',10,0),('1','138',205814,'DAILY SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-23 11:04:53','500','2021-06-23 11:05:15',10,0),('1','138',205823,'DAILY SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-24 09:12:31','500','2021-06-24 09:12:58',10,0),('1','138',206002,'DAILY SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-24 18:40:00','500','2021-06-24 18:40:35',10,0),('1','138',206172,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-25 18:08:44','500','2021-06-25 18:09:12',10,0),('1','138',206348,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-26 18:06:21','500','2021-06-26 18:06:42',10,0),('1','138',206573,'DAILY SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-27 13:46:22','500','2021-06-27 13:46:47',10,0),('1','138',206698,'DAILY SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-27 14:08:07','500','2021-06-27 14:08:28',10,0),('1','138',206700,'DAILY SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-27 14:18:18','500','2021-06-27 14:18:36',10,0),('1','138',206726,'DAILY SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-27 17:52:15','500','2021-06-27 17:52:35',10,0),('1','138',206800,'DAILY SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-28 17:54:11','500','2021-06-28 17:54:47',10,0),('1','138',207032,'DAILY SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-29 18:23:06','500','2021-06-29 18:23:26',10,0),('1','138',207251,'DAILY SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-30 15:55:25','500','2021-06-30 15:56:12',10,0),('1','138',207427,'DAILY SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'500',0.00,0.00,'500','2021-06-30 16:26:07','500','2021-06-30 16:26:30',10,0),('1','138',207439,'DAILY SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-01 09:24:17','500','2021-07-01 09:24:40',10,0),('1','138',207538,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-01 18:33:00','500','2021-07-01 18:34:11',10,0),('1','138',207710,'DAILY SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-02 17:56:10','500','2021-07-02 17:56:52',10,0),('1','138',207909,'DAILY SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-03 17:46:29','500','2021-07-03 17:46:50',10,0),('1','138',208075,'DAILY SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-03 17:54:31','500','2021-07-03 17:54:51',10,0),('1','138',208077,'DAILY SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-03 18:00:07','500','2021-07-03 18:00:27',10,0),('1','138',208233,'DAILY SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-04 17:38:45','500','2021-07-04 17:39:05',10,0),('1','138',208285,'DAILY SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-04 17:55:34','500','2021-07-04 17:55:54',10,0),('1','138',208286,'DAILY SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-04 18:34:22','500','2021-07-04 18:34:42',10,0),('1','138',208387,'DAILY SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-05 18:36:10','500','2021-07-05 18:36:45',10,0),('1','138',208553,'DAILY SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-07 07:16:02','500','2021-07-07 07:16:29',10,0),('1','138',208781,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-08 09:42:19','500','2021-07-08 09:43:37',10,0),('1','138',209079,'DAILY SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-08 10:25:04','500','2021-07-08 10:25:38',10,0),('1','138',209087,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-08 10:41:08','500','2021-07-08 10:41:39',10,0),('1','138',209091,'DAILY SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-08 18:04:03','500','2021-07-08 18:04:36',10,0),('1','138',209208,'DAILY SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-10 06:00:43','500','2021-07-10 06:02:22',10,0),('1','138',209435,'DAILY SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-10 18:03:41','500','2021-07-10 18:04:06',10,0),('1','138',209660,'DAILY SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-11 18:31:46','500','2021-07-11 18:32:12',10,0),('1','138',209931,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-12 10:25:49','500','2021-07-12 10:26:31',10,0),('1','138',209951,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-12 10:38:00','500','2021-07-12 10:38:24',10,0),('1','138',209959,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-12 10:52:11','500','2021-07-12 10:53:02',10,0),('1','138',209972,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-12 17:33:13','500','2021-07-12 17:33:38',10,0),('1','138',210060,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-13 10:00:09','500','2021-07-13 10:00:38',10,0),('1','138',210179,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-13 10:07:12','500','2021-07-13 10:07:41',10,0),('1','138',210189,'DAILY SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-13 17:50:49','500','2021-07-13 17:51:27',10,0),('1','138',210310,'DAILY SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-14 17:38:45','500','2021-07-14 17:39:15',10,0),('1','138',210614,'DAILY SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-15 17:42:45','500','2021-07-15 17:43:13',10,0),('1','138',210780,'DAILY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-16 17:48:36','500','2021-07-16 17:49:02',10,0),('1','138',210959,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-17 16:13:35','500','2021-07-17 16:14:05',10,0),('1','138',211111,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-17 16:35:57','500','2021-07-17 16:36:18',10,0),('1','138',211121,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-17 17:09:09','500','2021-07-17 17:09:35',10,0),('1','138',211176,'DAILY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-18 18:12:06','500','2021-07-18 18:12:27',10,0),('1','138',211417,'DAILY SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-19 19:45:12','500','2021-07-19 19:46:56',10,0),('1','138',211646,'DAILY SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-21 06:53:53','500','2021-07-21 06:56:47',10,0),('1','138',211790,'DAILY SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-21 17:34:28','500','2021-07-21 17:34:49',10,0),('1','138',212005,'DAILY SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-22 13:53:01','500','2021-07-22 13:53:27',10,0),('1','138',212130,'DAILY SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-22 14:01:23','500','2021-07-22 14:01:57',10,0),('1','138',212135,'DAILY SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-22 14:10:14','500','2021-07-22 14:10:40',10,0),('1','138',212148,'DAILY SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-22 17:59:38','500','2021-07-22 18:00:00',10,0),('1','138',212250,'DAILY SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-23 17:50:07','500','2021-07-23 17:50:34',10,0),('1','138',212519,'DAILY SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-24 17:18:38','500','2021-07-24 17:18:59',10,0),('1','138',212727,'DAILY SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-25 19:53:52','500','2021-07-25 19:54:23',10,0),('1','138',212942,'DAILY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-26 15:35:38','500','2021-07-26 15:36:06',10,0),('1','138',213184,'DAILY SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-27 09:09:33','500','2021-07-27 09:11:48',10,0),('1','138',213198,'DAILY SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-27 09:35:42','500','2021-07-27 09:36:03',10,0),('1','138',213208,'DAILY SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-27 18:27:15','500','2021-07-27 18:27:39',10,0),('1','138',213423,'DAILY SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-28 18:15:58','500','2021-07-28 18:17:24',10,0),('1','138',213648,'DAILY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-30 07:54:08','500','2021-07-30 07:55:25',10,0),('1','138',213918,'DAILY SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-31 16:09:50','500','2021-07-31 16:12:02',10,0),('1','138',214264,'DAILY SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-31 16:22:41','500','2021-07-31 16:23:38',10,0),('1','138',214270,'DAILY SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'500',0.00,0.00,'500','2021-07-31 16:47:40','500','2021-07-31 16:48:02',10,0),('1','138',214276,'DAILY SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-04 14:41:37','500','2021-08-04 14:42:36',10,0),('1','138',215154,'DAILY SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-04 14:52:27','500','2021-08-04 14:52:55',10,0),('1','138',215156,'DAILY SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-04 15:07:19','500','2021-08-04 15:07:44',10,0),('1','138',215164,'DAILY SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-04 15:36:06','500','2021-08-04 15:36:32',10,0),('1','138',215167,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-04 15:47:33','500','2021-08-04 15:48:02',10,0),('1','138',215170,'DAILY SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-04 16:00:21','500','2021-08-04 16:00:48',10,0),('1','138',215172,'DAILY SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-04 18:01:11','500','2021-08-04 18:01:35',10,0),('1','138',215189,'DAILY SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-04 18:11:10','500','2021-08-04 18:11:44',10,0),('1','138',215258,'DAILY SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-05 09:46:48','500','2021-08-05 09:47:13',10,0),('1','138',215370,'DAILY SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-05 14:24:00','500','2021-08-05 14:24:19',10,0),('1','138',215381,'DAILY SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-05 18:08:36','500','2021-08-05 18:09:00',10,0),('1','138',215446,'DAILY SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-06 18:19:55','500','2021-08-06 18:20:21',10,0),('1','138',215633,'DAILY SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-06 18:32:21','500','2021-08-06 18:32:41',10,0),('1','138',215635,'DAILY SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-07 13:24:08','500','2021-08-07 13:24:53',10,0),('1','138',215804,'DAILY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-07 19:20:07','500','2021-08-07 19:20:53',10,0),('1','138',215877,'DAILY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-07 19:35:52','500','2021-08-07 19:36:16',10,0),('1','138',215878,'DAILY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-07 19:43:49','500','2021-08-07 19:44:11',10,0),('1','138',216038,'DAILY SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-08 17:55:50','500','2021-08-08 17:56:17',10,0),('1','138',216121,'DAILY SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-09 18:15:42','500','2021-08-09 18:16:12',10,0),('1','138',216315,'DAILY SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-10 19:20:11','500','2021-08-10 19:20:34',10,0),('1','138',216564,'DAILY SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-11 18:49:23','500','2021-08-11 18:49:49',10,0),('1','138',216987,'DAILY SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-13 07:24:39','500','2021-08-13 07:25:10',10,0),('1','138',217042,'DAILY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-14 06:49:45','500','2021-08-14 06:50:25',10,0),('1','138',217286,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-14 10:24:16','500','2021-08-14 10:24:43',10,0),('1','138',217365,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-14 11:12:05','500','2021-08-14 11:13:38',10,0),('1','138',217376,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-14 18:03:13','500','2021-08-14 18:08:01',10,0),('1','138',217499,'DAILY SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-15 17:14:08','500','2021-08-15 17:14:38',10,0),('1','138',217711,'DAILY SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-16 15:49:48','500','2021-08-16 15:50:24',10,0),('1','138',217928,'DAILY SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-16 16:34:14','500','2021-08-16 16:34:36',10,0),('1','138',218019,'DAILY SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-17 17:40:11','500','2021-08-17 17:41:36',10,0),('1','138',218239,'DAILY SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-18 18:02:57','500','2021-08-18 18:03:48',10,0),('1','138',218454,'DAILY SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-19 18:34:04','500','2021-08-19 18:34:34',10,0),('1','138',218694,'DAILY SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-20 17:51:39','500','2021-08-20 17:52:11',10,0),('1','138',218869,'DAILY SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-20 18:14:44','500','2021-08-20 18:15:17',10,0),('1','138',218911,'DAILY SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-21 18:01:50','500','2021-08-21 18:02:50',10,0),('1','138',219122,'DAILY SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-22 17:20:40','500','2021-08-22 17:21:32',10,0),('1','138',219335,'DAILY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-23 17:51:11','500','2021-08-23 17:52:01',10,0),('1','138',219594,'DAILY SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-24 15:48:53','500','2021-08-24 15:49:20',10,0),('1','138',219759,'DAILY SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-24 18:42:31','500','2021-08-24 18:42:55',10,0),('1','138',219823,'DAILY SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-25 18:14:50','500','2021-08-25 18:15:53',10,0),('1','138',220060,'DAILY SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-26 18:16:17','500','2021-08-26 18:16:43',10,0),('1','138',220208,'DAILY SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-27 04:45:19','500','2021-08-27 04:45:41',10,0),('1','138',220261,'DAILY SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-27 18:29:01','500','2021-08-27 18:29:30',10,0),('1','138',220472,'DAILY SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-28 17:16:24','500','2021-08-28 17:16:50',10,0),('1','138',220647,'DAILY SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-28 17:46:50','500','2021-08-28 17:47:13',10,0),('1','138',220648,'DAILY SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-28 17:51:48','500','2021-08-28 17:52:11',10,0),('1','138',220687,'DAILY SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-29 17:43:15','500','2021-08-29 17:43:46',10,0),('1','138',220920,'DAILY SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-30 19:08:41','500','2021-08-30 19:09:47',10,0),('1','138',221148,'DAILY SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'500',0.00,0.00,'500','2021-08-31 18:12:23','500','2021-08-31 18:12:52',10,0),('1','138',221395,'DAILY SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-01 18:22:10','500','2021-09-01 18:23:21',10,0),('1','138',221651,'DAILY SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-02 09:22:42','500','2021-09-02 09:24:25',10,0),('1','138',221684,'DAILY SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-02 09:39:16','500','2021-09-02 09:40:58',10,0),('1','138',221718,'DAILY SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-02 18:04:52','500','2021-09-02 18:05:44',10,0),('1','138',221865,'DAILY SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-03 17:51:33','500','2021-09-03 17:52:27',10,0),('1','138',222074,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-04 10:17:38','500','2021-09-04 10:19:42',10,0),('1','138',222128,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-04 10:28:00','500','2021-09-04 10:28:26',10,0),('1','138',222136,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-04 18:26:33','500','2021-09-04 18:32:42',10,0),('1','138',222282,'DAILY SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-05 17:43:56','500','2021-09-05 17:44:20',10,0),('1','138',222552,'DAILY SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-06 17:49:48','500','2021-09-06 17:50:44',10,0),('1','138',222745,'DAILY SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-09 06:47:08','500','2021-09-09 06:47:37',10,0),('1','138',223245,'DAILY SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-09 09:46:15','500','2021-09-09 09:47:43',10,0),('1','138',223252,'DAILY SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-09 09:51:38','500','2021-09-09 09:52:23',10,0),('1','138',223257,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-09 10:09:09','500','2021-09-09 10:09:31',10,0),('1','138',223262,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-09 10:34:01','500','2021-09-09 10:34:27',10,0),('1','138',223267,'DAILY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-09 18:05:45','500','2021-09-09 18:06:36',10,0),('1','138',223426,'DAILY SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-10 17:33:55','500','2021-09-10 17:35:19',10,0),('1','138',223603,'DAILY SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-10 17:59:00','500','2021-09-10 17:59:22',10,0),('1','138',223640,'DAILY SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-11 18:20:24','500','2021-09-11 18:20:52',10,0),('1','138',223876,'DAILY SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-12 17:41:11','500','2021-09-12 17:41:30',10,0),('1','138',224085,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-13 18:01:02','500','2021-09-13 18:02:13',10,0),('1','138',224309,'DAILY SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-14 18:34:33','500','2021-09-14 18:35:13',10,0),('1','138',224551,'DAILY SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-15 18:11:04','500','2021-09-15 18:11:39',10,0),('1','138',224778,'DAILY SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-16 18:13:22','500','2021-09-16 18:13:48',10,0),('1','138',225021,'DAILY SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-18 07:02:42','500','2021-09-18 07:03:29',10,0),('1','138',225279,'DAILY SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-18 07:06:49','500','2021-09-18 07:07:29',10,0),('1','138',225281,'DAILY SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-18 07:49:30','500','2021-09-18 07:50:37',10,0),('1','138',225318,'DAILY SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-19 06:49:38','500','2021-09-19 06:51:38',10,0),('1','138',225490,'DAILY SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-19 13:22:56','500','2021-09-19 13:23:25',10,0),('1','138',225602,'DAILY SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-19 14:50:44','500','2021-09-19 14:51:22',10,0),('1','138',225627,'DAILY SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-19 17:59:25','500','2021-09-19 18:00:11',10,0),('1','138',225698,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-20 17:36:52','500','2021-09-20 17:37:24',10,0),('1','138',226027,'Daily sales','2021-09-21','2021-09-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-21 08:52:35','500','2021-09-21 08:53:02',10,0),('1','138',226101,'DAILY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-21 18:35:45','500','2021-09-21 18:36:30',10,0),('1','138',226228,'DAILY SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-22 19:18:11','500','2021-09-22 19:19:15',10,0),('1','138',226470,'DAILY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-23 18:15:34','500','2021-09-23 18:16:11',10,0),('1','138',226728,'DAILY SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-24 15:04:55','500','2021-09-24 15:07:11',10,0),('1','138',226891,'DAILY SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-24 19:21:49','500','2021-09-24 19:22:23',10,0),('1','138',226966,'DAILY SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-25 18:32:39','500','2021-09-25 18:35:53',10,0),('1','138',227196,'DAILY SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-27 08:32:39','500','2021-09-27 08:33:26',10,0),('1','138',227429,'DAILY SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-27 08:46:47','500','2021-09-27 08:47:30',10,0),('1','138',227444,'DAILY SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-27 18:58:06','500','2021-09-27 18:58:28',10,0),('1','138',227606,'DAILY SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-28 18:31:15','500','2021-09-28 21:52:42',10,0),('1','138',227850,'DAILY SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-29 17:37:39','500','2021-09-29 17:38:46',10,0),('1','138',228129,'DAILY SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-30 15:35:33','500','2021-09-30 15:36:00',10,0),('1','138',228297,'DAILY SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-30 17:14:54','500','2021-09-30 17:15:15',10,0),('1','138',228302,'DAILY SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'500',0.00,0.00,'500','2021-09-30 18:29:38','500','2021-09-30 18:29:57',10,0),('1','138',228461,'DAILY SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-01 17:50:01','500','2021-10-01 18:08:12',10,0),('1','138',228530,'DAILY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-02 10:13:47','500','2021-10-02 10:14:45',10,0),('1','138',228584,'DAILY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-02 10:24:41','500','2021-10-02 10:25:27',10,0),('1','138',228591,'DAILY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-02 17:52:49','500','2021-10-02 17:56:26',10,0),('1','138',228761,'DAILY SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-03 18:15:21','500','2021-10-03 18:15:56',10,0),('1','138',228960,'DAILY SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-04 19:08:44','500','2021-10-04 19:10:06',10,0),('1','138',229266,'DAILY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-05 16:20:51','500','2021-10-05 16:21:23',10,0),('1','138',229369,'DAILY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-05 16:39:36','500','2021-10-05 16:39:56',10,0),('1','138',229473,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-06 20:33:37','500','2021-10-06 20:34:09',10,0),('1','138',229715,'DAILY SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-07 09:27:08','500','2021-10-07 09:27:26',10,0),('1','138',229723,'DAILY SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-07 18:39:37','500','2021-10-07 18:40:10',10,0),('1','138',229945,'DAILY SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-08 18:18:52','500','2021-10-08 18:19:14',10,0),('1','138',230084,'DAILY SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-09 18:16:59','500','2021-10-09 18:18:25',10,0),('1','138',230288,'DAILY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-10 14:07:50','500','2021-10-10 14:08:22',10,0),('1','138',230431,'DAILY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-10 17:05:45','500','2021-10-10 17:06:05',10,0),('1','138',230480,'DAILY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-10 18:27:40','500','2021-10-10 18:28:02',10,0),('1','138',230523,'DAILY SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-11 18:08:20','500','2021-10-11 18:09:13',10,0),('1','138',230777,'DAILY SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-12 18:53:19','500','2021-10-12 18:54:37',10,0),('1','138',231065,'DAILY SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-13 18:06:46','500','2021-10-13 18:08:01',10,0),('1','138',231374,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-14 10:31:16','500','2021-10-14 10:37:21',10,0),('1','138',231475,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-14 11:35:53','500','2021-10-14 11:36:22',10,0),('1','138',231500,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-14 18:11:59','500','2021-10-14 18:12:42',10,0),('1','138',231644,'DAILY SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-15 18:17:11','500','2021-10-15 18:18:01',10,0),('1','138',231890,'DAILY SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-16 18:19:44','500','2021-10-16 18:23:15',10,0),('1','138',232114,'DAILY SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-17 07:13:59','500','2021-10-17 07:15:10',10,0),('1','138',232120,'DAILY SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-17 17:55:01','500','2021-10-17 17:58:14',10,0),('1','138',232330,'DAILY SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-18 18:55:50','500','2021-10-18 18:57:06',10,0),('1','138',232587,'DAILY SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-19 18:31:53','500','2021-10-19 18:33:13',10,0),('1','138',232847,'DAILY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-20 18:29:41','500','2021-10-20 18:30:25',10,0),('1','138',233123,'DAILY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-21 16:42:48','500','2021-10-21 16:43:28',10,0),('1','138',233305,'DAILY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-21 17:00:13','500','2021-10-21 17:00:54',10,0),('1','138',233497,'DAILY SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-22 17:45:15','500','2021-10-22 17:45:45',10,0),('1','138',233613,'DAILY SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-23 17:57:18','500','2021-10-23 17:57:42',10,0),('1','138',233847,'DAILY SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-24 17:49:46','500','2021-10-24 17:50:17',10,0),('1','138',234024,'Daily sales','2021-10-24','2021-10-24 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-24 21:55:55','500','2021-10-24 21:56:20',10,0),('1','138',234102,'DAILY SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-25 17:53:49','500','2021-10-25 17:55:20',10,0),('1','138',234329,'DAILY SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-26 18:11:27','500','2021-10-26 18:13:12',10,0),('1','138',234568,'DAILY SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-27 18:18:43','500','2021-10-27 18:19:26',10,0),('1','138',234814,'DAILY SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-28 19:04:48','500','2021-10-28 19:05:30',10,0),('1','138',235062,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-29 16:00:48','500','2021-10-29 16:02:03',10,0),('1','138',235239,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-29 16:12:36','500','2021-10-29 16:13:20',10,0),('1','138',235241,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-29 18:47:17','500','2021-10-29 18:47:54',10,0),('1','138',235301,'DAILY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-30 19:05:28','500','2021-10-30 19:06:13',10,0),('1','138',235526,'DAILY SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'500',0.00,0.00,'500','2021-10-31 18:38:21','500','2021-10-31 18:39:30',10,0),('1','138',235747,'DAILY SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-01 19:31:12','500','2021-11-01 19:33:24',10,0),('1','138',236002,'DAILY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-03 11:32:48','500','2021-11-03 11:33:10',10,0),('1','138',236369,'DAILY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-03 11:57:41','500','2021-11-03 11:58:19',10,0),('1','138',236379,'DAILY SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-03 18:55:50','500','2021-11-03 18:56:48',10,0),('1','138',236496,'DAILY SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-04 18:52:40','500','2021-11-04 18:54:13',10,0),('1','138',236723,'DAILY SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-05 18:30:24','500','2021-11-05 18:32:16',10,0),('1','138',236960,'DAILY SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-06 18:07:32','500','2021-11-06 18:08:52',10,0),('1','138',237158,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-07 05:16:11','500','2021-11-07 05:16:36',10,0),('1','138',237165,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-07 05:39:01','500','2021-11-07 05:39:23',10,0),('1','138',237184,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-07 18:41:23','500','2021-11-07 18:42:31',10,0),('1','138',237384,'DAILY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-08 19:00:00','500','2021-11-08 19:00:48',10,0),('1','138',237602,'DAILY SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-09 18:47:59','500','2021-11-09 18:48:37',10,0),('1','138',237868,'DAILY SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-10 18:08:05','500','2021-11-10 18:08:44',10,0),('1','138',238115,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-11 05:51:40','500','2021-11-11 05:51:58',10,0),('1','138',238116,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-11 05:55:47','500','2021-11-11 05:56:05',10,0),('1','138',238120,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-11 14:03:03','500','2021-11-11 14:03:39',10,0),('1','138',238273,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-11 14:12:22','500','2021-11-11 14:12:38',10,0),('1','138',238276,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-11 21:23:49','500','2021-11-11 21:25:38',10,0),('1','138',238350,'DAILY SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-12 18:32:28','500','2021-11-12 18:33:56',10,0),('1','138',238601,'DAILY SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-13 19:58:50','500','2021-11-13 20:00:22',10,0),('1','138',238826,'DAILY SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-14 05:43:06','500','2021-11-14 05:43:28',10,0),('1','138',238837,'DAILY SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-14 15:40:27','500','2021-11-14 15:40:56',10,0),('1','138',238974,'DAILY SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-14 15:47:09','500','2021-11-14 15:47:30',10,0),('1','138',239124,'DAILY SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-15 13:12:50','500','2021-11-15 13:13:16',10,0),('1','138',239195,'DAILY SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-15 14:51:09','500','2021-11-15 14:53:17',10,0),('1','138',239216,'DAILY SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-16 06:12:00','500','2021-11-16 06:12:28',10,0),('1','138',239290,'DAILY SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-16 11:44:15','500','2021-11-16 11:44:37',10,0),('1','138',239397,'DAILY SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-16 12:07:29','500','2021-11-16 12:07:51',10,0),('1','138',239443,'DAILY SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-16 18:30:27','500','2021-11-16 18:30:51',10,0),('1','138',239517,'DAILY SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-17 10:47:29','500','2021-11-17 10:47:50',10,0),('1','138',239626,'DAILY SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-17 10:52:04','500','2021-11-17 10:52:21',10,0),('1','138',239639,'DAILY SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-17 17:33:23','500','2021-11-17 17:34:19',10,0),('1','138',239839,'DAILY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-18 08:54:02','500','2021-11-18 08:54:25',10,0),('1','138',239840,'DAILY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-18 14:23:09','500','2021-11-18 14:23:58',10,0),('1','138',239911,'DAILY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-18 15:03:45','500','2021-11-18 15:04:04',10,0),('1','138',239921,'DAILY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-18 18:40:58','500','2021-11-18 18:44:29',10,0),('1','138',239985,'DAILY SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-19 17:07:55','500','2021-11-19 17:08:41',10,0),('1','138',240144,'DAILY SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-19 17:39:34','500','2021-11-19 17:39:51',10,0),('1','138',240252,'DAILY SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-20 18:16:09','500','2021-11-20 20:41:06',10,0),('1','138',240442,'DAILY SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-21 08:05:42','500','2021-11-21 08:06:06',10,0),('1','138',240492,'DAILY SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-21 08:18:59','500','2021-11-21 08:19:17',10,0),('1','138',240502,'DAILY SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-21 19:27:44','500','2021-11-21 19:28:56',10,0),('1','138',240682,'DAILY SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-22 17:59:54','500','2021-11-22 18:01:03',10,0),('1','138',240985,'DAILY SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-23 18:37:35','500','2021-11-23 18:40:31',10,0),('1','138',241215,'DAILY SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-24 18:31:12','500','2021-11-24 18:32:47',10,0),('1','138',241482,'DAILY SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-25 18:33:17','500','2021-11-25 18:33:45',10,0),('1','138',241731,'DAILY SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-26 18:24:47','500','2021-11-26 18:25:06',10,0),('1','138',241979,'DAILY SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-27 11:39:19','500','2021-11-27 11:39:42',10,0),('1','138',242073,'DAILY SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-27 11:50:01','500','2021-11-27 11:50:22',10,0),('1','138',242085,'DAILY SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-27 18:36:19','500','2021-11-27 18:36:43',10,0),('1','138',242195,'DAILY SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-28 08:40:50','500','2021-11-28 08:41:12',10,0),('1','138',242257,'DAILY SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-28 08:46:49','500','2021-11-28 08:47:07',10,0),('1','138',242267,'DAILY SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-28 18:20:48','500','2021-11-28 18:21:10',10,0),('1','138',242419,'DAILY SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-29 12:01:40','500','2021-11-29 12:02:11',10,0),('1','138',242555,'DAILY SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-29 12:15:33','500','2021-11-29 12:15:56',10,0),('1','138',242556,'DAILY SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-29 18:34:14','500','2021-11-29 18:35:20',10,0),('1','138',242674,'DAILY SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'500',0.00,0.00,'500','2021-11-30 18:11:04','500','2021-11-30 18:17:04',10,0),('1','138',242909,'DAILY SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-01 18:30:37','500','2021-12-01 18:31:06',10,0),('1','138',243147,'DAILY SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-02 18:32:13','500','2021-12-02 18:34:22',10,0),('1','138',243358,'DAILY SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-03 18:38:53','500','2021-12-03 18:39:36',10,0),('1','138',243592,'DAILY SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-04 07:18:54','500','2021-12-04 07:19:54',10,0),('1','138',243635,'DAILY SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-04 07:37:00','500','2021-12-04 07:37:20',10,0),('1','138',243640,'DAILY SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-04 18:32:15','500','2021-12-04 18:33:53',10,0),('1','138',243826,'DAILY SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-05 18:11:15','500','2021-12-05 18:12:24',10,0),('1','138',244038,'DAILY SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-06 18:10:35','500','2021-12-06 18:11:05',10,0),('1','138',244279,'DAILY SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-07 18:17:48','500','2021-12-07 18:19:18',10,0),('1','138',244509,'DAILY SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-08 18:41:33','500','2021-12-08 18:43:27',10,0),('1','138',244740,'DAILY SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-09 12:08:10','500','2021-12-09 12:08:36',10,0),('1','138',244850,'DAILY SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-09 12:17:02','500','2021-12-09 12:17:27',10,0),('1','138',244852,'DAILY SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-09 12:23:09','500','2021-12-09 12:23:32',10,0),('1','138',244861,'Daily sales','2021-12-09','2021-12-09 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-09 18:33:42','500','2021-12-09 18:38:09',10,0),('1','138',244988,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-10 18:23:07','500','2021-12-10 18:24:32',10,0),('1','138',245214,'DAILY SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-11 18:50:00','500','2021-12-11 18:50:48',10,0),('1','138',245442,'DAILY SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-12 18:25:22','500','2021-12-12 18:31:52',10,0),('1','138',245668,'DAILY SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-13 11:32:50','500','2021-12-13 11:33:14',10,0),('1','138',245778,'DAILY SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-13 11:42:27','500','2021-12-13 11:42:55',10,0),('1','138',245781,'DAILY SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-13 16:46:13','500','2021-12-13 16:46:35',10,0),('1','138',245873,'DAILY SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-13 17:22:15','500','2021-12-13 17:22:34',10,0),('1','138',245934,'DAILY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-14 14:28:41','500','2021-12-14 14:29:31',10,0),('1','138',246089,'DAILY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-14 14:37:08','500','2021-12-14 14:37:39',10,0),('1','138',246095,'DAILY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-14 19:27:23','500','2021-12-14 19:27:52',10,0),('1','138',246187,'DAILY SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-15 14:46:20','500','2021-12-15 14:46:49',10,0),('1','138',246368,'DAILY SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-15 14:50:44','500','2021-12-15 14:51:02',10,0),('1','138',246439,'DAILY SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-16 16:15:55','500','2021-12-16 16:16:22',10,0),('1','138',246629,'DAILY SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-16 16:22:43','500','2021-12-16 16:23:06',10,0),('1','138',246634,'DAILY SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-16 19:24:53','500','2021-12-16 19:25:18',10,0),('1','138',246692,'DAILY SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-17 18:28:48','500','2021-12-17 18:29:19',10,0),('1','138',246958,'DAILY SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-18 07:30:21','500','2021-12-18 07:40:57',10,0),('1','138',246981,'DAILY SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-18 08:14:20','500','2021-12-18 08:14:35',10,0),('1','138',246999,'DAILY SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-18 18:16:18','500','2021-12-18 18:17:15',10,0),('1','138',247120,'DAILY SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-18 18:24:44','500','2021-12-18 18:25:03',10,0),('1','138',247236,'DAILY SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-19 18:10:06','500','2021-12-19 18:10:47',10,0),('1','138',247402,'DAILY SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-20 18:30:32','500','2021-12-20 18:31:42',10,0),('1','138',247665,'DAILY SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-21 18:28:15','500','2021-12-21 18:28:53',10,0),('1','138',247899,'DAILY SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-22 18:37:44','500','2021-12-22 18:38:16',10,0),('1','138',248148,'DAILY SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-23 17:48:12','500','2021-12-23 17:48:43',10,0),('1','138',248333,'DAILY SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-23 17:54:20','500','2021-12-23 17:54:41',10,0),('1','138',248336,'DAILY SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-23 17:59:39','500','2021-12-23 18:00:58',10,0),('1','138',248401,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-24 18:49:31','500','2021-12-24 18:49:55',10,0),('1','138',248633,'DAILY SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-25 18:23:43','500','2021-12-25 18:24:05',10,0),('1','138',248884,'DAILY SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-26 18:33:11','500','2021-12-26 18:33:48',10,0),('1','138',249097,'DAILY SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-27 13:39:09','500','2021-12-27 13:39:36',10,0),('1','138',249245,'DAILY SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-27 13:51:32','500','2021-12-27 13:51:53',10,0),('1','138',249248,'DAILY SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-27 18:14:51','500','2021-12-27 18:15:40',10,0),('1','138',249335,'DAILY SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-29 06:02:29','500','2021-12-29 06:04:03',10,0),('1','138',249588,'DAILY SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-29 18:33:24','500','2021-12-29 18:33:50',10,0),('1','138',249844,'DAILY SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-30 18:20:01','500','2021-12-30 18:20:30',10,0),('1','138',250117,'DAILY SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-31 15:44:39','500','2021-12-31 15:45:06',10,0),('1','138',250256,'DAILY SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-31 16:01:00','500','2021-12-31 16:01:16',10,0),('1','138',250260,'DAILY SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-31 16:05:28','500','2021-12-31 16:05:48',10,0),('1','138',250261,'DAILY SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'500',0.00,0.00,'500','2021-12-31 18:15:04','500','2021-12-31 18:15:33',10,0),('1','138',250338,'DAILY SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-01 18:21:02','500','2022-01-01 18:21:22',10,0),('1','138',250571,'DAILY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-02 17:53:29','500','2022-01-02 17:54:56',10,0),('1','138',250807,'DAILY SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-03 18:17:56','500','2022-01-03 18:18:55',10,0),('1','138',251057,'Daily sales','2022-01-04','2022-01-04 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-04 19:45:40','500','2022-01-04 19:46:51',10,0),('1','138',251276,'DAILY SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-05 13:23:19','500','2022-01-05 13:25:39',10,0),('1','138',251382,'DAILY SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-05 13:34:16','500','2022-01-05 13:35:28',10,0),('1','138',251389,'DAILY SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-05 19:40:04','500','2022-01-05 19:40:30',10,0),('1','138',251531,'DAILY SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-06 19:42:21','500','2022-01-06 19:44:57',10,0),('1','138',251764,'DAILY SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-07 19:30:12','500','2022-01-07 19:30:40',10,0),('1','138',251993,'DAILY SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-08 19:22:52','500','2022-01-08 19:24:04',10,0),('1','138',252238,'DAILY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-09 18:37:16','500','2022-01-09 18:37:51',10,0),('1','138',252402,'DAILY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-09 18:43:55','500','2022-01-09 18:44:17',10,0),('1','138',252403,'DAILY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-09 18:53:45','500','2022-01-09 18:54:05',10,0),('1','138',252532,'DAILY SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-10 15:51:12','500','2022-01-10 15:51:38',10,0),('1','138',252633,'DAILY SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-10 16:39:10','500','2022-01-10 16:39:29',10,0),('1','138',252757,'DAILY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-11 15:58:19','500','2022-01-11 15:58:57',10,0),('1','138',252880,'DAILY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-11 16:05:23','500','2022-01-11 16:05:48',10,0),('1','138',252977,'DAILY SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-12 20:49:32','500','2022-01-12 20:53:20',10,0),('1','138',253198,'DAILY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-13 12:49:55','500','2022-01-13 12:50:15',10,0),('1','138',253339,'DAILY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-13 12:54:04','500','2022-01-13 12:54:22',10,0),('1','138',253340,'DAILY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-13 19:38:53','500','2022-01-13 19:39:37',10,0),('1','138',253476,'DAILY SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-14 19:35:45','500','2022-01-14 19:36:59',10,0),('1','138',253724,'DAILY SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-15 19:39:01','500','2022-01-15 19:41:39',10,0),('1','138',253966,'DAILY SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-16 19:27:47','500','2022-01-16 19:29:05',10,0),('1','138',254200,'DAILY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-17 19:48:15','500','2022-01-17 19:49:01',10,0),('1','138',254454,'DAILY SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-18 10:54:59','500','2022-01-18 10:55:31',10,0),('1','138',254543,'DAILY SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-18 11:02:18','500','2022-01-18 11:02:36',10,0),('1','138',254546,'DAILY SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-18 19:39:35','500','2022-01-18 19:41:05',10,0),('1','138',254704,'DAILY SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-19 20:10:27','500','2022-01-19 20:11:14',10,0),('1','138',254955,'DAILY SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-20 19:39:07','500','2022-01-20 19:41:04',10,0),('1','138',255203,'DAILY SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-21 19:51:59','500','2022-01-21 19:54:22',10,0),('1','138',255448,'DAILY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-22 19:45:20','500','2022-01-22 20:07:06',10,0),('1','138',255671,'DAILY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-22 20:37:59','500','2022-01-22 20:38:24',10,0),('1','138',255768,'DAILY SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-23 20:23:05','500','2022-01-23 20:24:31',10,0),('1','138',255939,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-24 13:18:20','500','2022-01-24 13:31:01',10,0),('1','138',256085,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-24 14:01:21','500','2022-01-24 14:02:17',10,0),('1','138',256118,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-24 19:39:44','500','2022-01-24 20:07:41',10,0),('1','138',256218,'DAILY SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-25 19:51:10','500','2022-01-25 20:09:07',10,0),('1','138',256478,'DAILY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-26 19:36:59','500','2022-01-26 19:53:50',10,0),('1','138',256725,'DAILY SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-27 20:09:49','500','2022-01-27 20:10:15',10,0),('1','138',256964,'DAILY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-28 19:43:35','500','2022-01-28 19:44:17',10,0),('1','138',257233,'DAILY SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-29 15:44:14','500','2022-01-29 15:44:52',10,0),('1','138',257397,'DAILY SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-29 16:07:27','500','2022-01-29 16:07:46',10,0),('1','138',257400,'DAILY SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-29 20:03:26','500','2022-01-29 20:03:49',10,0),('1','138',257483,'DAILY SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-30 19:14:13','500','2022-01-30 19:15:50',10,0),('1','138',257484,'DAILY SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'500',0.00,0.00,'500','2022-01-31 19:39:36','500','2022-01-31 19:39:54',10,0),('1','138',257485,'DAILY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-01 14:47:59','500','2022-02-01 14:48:25',10,0),('1','138',257486,'DAILY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-01 14:58:12','500','2022-02-01 14:58:32',10,0),('1','138',257487,'DAILY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-01 15:03:35','500','2022-02-01 15:03:52',10,0),('1','138',257488,'DAILY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-01 19:35:46','500','2022-02-01 19:36:14',10,0),('1','138',257489,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-02 12:02:08','500','2022-02-02 12:02:27',10,0),('1','138',257490,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-02 12:06:58','500','2022-02-02 12:07:26',10,0),('1','138',257491,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-02 20:05:07','500','2022-02-02 20:05:22',10,0),('1','138',257492,'DAILY SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-03 19:56:19','500','2022-02-03 19:56:41',10,0),('1','138',257493,'DAILY SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-04 19:50:33','500','2022-02-04 19:51:07',10,0),('1','138',257494,'DAILY SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-05 19:52:56','500','2022-02-05 19:53:13',10,0),('1','138',257495,'DAILY SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-05 22:42:53','500','2022-02-05 22:43:12',10,0),('1','138',257496,'DAILY SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-05 23:09:11','500','2022-02-05 23:09:33',10,0),('1','138',257497,'DAILY SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-06 19:13:15','500','2022-02-06 19:13:33',10,0),('1','138',257498,'DAILY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-07 19:43:18','500','2022-02-07 19:43:52',10,0),('1','138',257499,'DAILY SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-08 19:41:01','500','2022-02-08 19:41:29',10,0),('1','138',257500,'DAILY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-09 14:02:41','500','2022-02-09 14:03:05',10,0),('1','138',257501,'DAILY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-09 14:09:55','500','2022-02-09 14:10:12',10,0),('1','138',257502,'DAILY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-09 14:19:27','500','2022-02-09 14:19:46',10,0),('1','138',257503,'DAILY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-09 19:32:59','500','2022-02-09 19:33:21',10,0),('1','138',257504,'DAILY SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-10 14:13:43','500','2022-02-10 14:14:02',10,0),('1','138',257505,'DAILY SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-10 15:15:51','500','2022-02-10 15:16:09',10,0),('1','138',257506,'DAILY SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-10 20:02:38','500','2022-02-10 20:03:01',10,0),('1','138',257507,'DAILY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-11 12:07:33','500','2022-02-11 12:07:52',10,0),('1','138',257508,'DAILY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-11 12:12:27','500','2022-02-11 12:12:46',10,0),('1','138',257509,'DAILY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-11 19:32:01','500','2022-02-11 19:32:18',10,0),('1','138',257510,'DAILY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-12 19:27:35','500','2022-02-12 19:28:05',10,0),('1','138',257511,'DAILY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-13 19:49:18','500','2022-02-13 19:49:45',10,0),('1','138',257512,'DAILY SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-14 19:56:16','500','2022-02-14 19:56:41',10,0),('1','138',257513,'DAILY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-15 17:05:23','500','2022-02-15 17:05:39',10,0),('1','138',257514,'DAILY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-15 17:12:15','500','2022-02-15 17:12:33',10,0),('1','138',257515,'DAILY SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-16 17:13:43','500','2022-02-16 17:14:01',10,0),('1','138',257516,'DAILY SHIFT ','2022-02-16','2022-02-16 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-16 17:32:05','500','2022-02-16 17:32:20',10,0),('1','138',257517,'DAILY SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-16 19:57:57','500','2022-02-16 19:58:15',10,0),('1','138',257518,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-17 15:14:27','500','2022-02-17 15:14:43',10,0),('1','138',257519,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-17 16:05:06','500','2022-02-17 16:06:32',10,0),('1','138',257520,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-17 19:47:12','500','2022-02-17 19:48:17',10,0),('1','138',257521,'DAILY SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-18 15:59:38','500','2022-02-18 15:59:59',10,0),('1','138',257522,'DAILY SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-18 16:19:51','500','2022-02-18 16:20:14',10,0),('1','138',257523,'DAILY SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-18 20:09:51','500','2022-02-18 20:10:16',10,0),('1','138',257524,'DAILY SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-19 14:05:14','500','2022-02-19 14:06:02',10,0),('1','138',257525,'DAILY SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-19 14:46:15','500','2022-02-19 14:46:31',10,0),('1','138',257526,'DAILY SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-19 19:39:42','500','2022-02-19 19:40:01',10,0),('1','138',257527,'DAILY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-20 12:14:25','500','2022-02-20 12:14:43',10,0),('1','138',257528,'DAILY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-20 12:20:48','500','2022-02-20 12:21:10',10,0),('1','138',257529,'DAILY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-20 19:37:09','500','2022-02-20 19:37:29',10,0),('1','138',257530,'DAILY SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-21 08:41:23','500','2022-02-21 08:41:47',10,0),('1','138',257531,'DAILY SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-21 09:33:34','500','2022-02-21 09:33:50',10,0),('1','138',257532,'DAILY SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'500',0.00,0.00,'500','2022-02-21 19:52:47','500','2022-02-21 19:53:10',10,0),('1','138',257533,'DAILY SHIFT','2022-02-22','2022-02-22 07:07:51','2022-02-23 07:07:51','500',0.00,0.00,'500','2022-02-22 20:21:08','500','2022-02-22 20:21:28',10,0),('1','138',257534,'DAILY SHIFT','2022-02-23','2022-02-23 06:42:38','2022-02-24 06:42:38','500',0.00,0.00,'500','2022-02-23 19:55:59','500','2022-02-23 19:56:19',10,0),('1','138',257535,'DAILY SHIFT','2022-02-24','2022-02-24 06:33:10','2022-02-25 06:33:10','500',0.00,0.00,'500','2022-02-24 17:13:51','500','2022-02-24 17:14:17',10,0),('1','138',257536,'DAILY SHIFT','2022-02-24','2022-02-24 17:15:16','2022-02-25 17:15:16','500',0.00,0.00,'500','2022-02-24 17:31:23','500','2022-02-24 17:31:48',10,0),('1','138',257537,'DAILY SHIFT','2022-02-25','2022-02-25 17:43:09','2022-02-26 17:43:09','500',0.00,0.00,'500','2022-02-25 19:21:54','500','2022-02-25 19:22:25',10,0),('1','138',257538,'DAILY SHIFT','2022-02-26','2022-02-26 10:42:48','2022-02-27 10:42:48','500',0.00,0.00,'500','2022-02-26 19:38:38','500','2022-02-26 19:39:08',10,0),('1','138',257539,'DAILY SHIFT','2022-02-27','2022-02-27 06:39:56','2022-02-28 06:39:56','500',0.00,0.00,'500','2022-02-27 19:34:33','500','2022-02-27 19:34:50',10,0),('1','138',257540,'DAILY SHIFT','2022-02-28','2022-02-28 06:41:31','2022-03-01 06:41:31','500',0.00,0.00,'500','2022-02-28 19:49:54','500','2022-02-28 19:50:24',10,0),('1','138',257541,'DAILY SHIFT','2022-03-01','2022-03-01 06:44:44','2022-03-02 06:44:44','500',0.00,0.00,'500','2022-03-01 20:16:39','500','2022-03-01 20:17:06',10,0),('1','138',257542,'DAILY SHIFT','2022-03-01','2022-03-01 22:45:45','2022-03-02 22:45:45','500',0.00,0.00,'500','2022-03-01 22:51:42','500','2022-03-01 22:52:02',10,0),('1','138',257543,'DAILY SHIFT','2022-03-02','2022-03-02 06:51:25','2022-03-03 06:51:25','500',0.00,0.00,'500','2022-03-02 19:46:18','500','2022-03-02 19:46:38',10,0),('1','138',257544,'DAILY SHIFT','2022-03-03','2022-03-03 06:40:01','2022-03-04 06:40:01','500',0.00,0.00,'500','2022-03-03 19:39:58','500','2022-03-03 19:40:23',10,0),('1','138',257545,'DAILY SHIFT','2022-03-04','2022-03-04 06:55:11','2022-03-05 06:55:11','500',0.00,0.00,'500','2022-03-04 20:08:48','500','2022-03-04 20:09:04',10,0),('1','138',257546,'DAILY SHIFT','2022-03-05','2022-03-05 06:47:05','2022-03-06 06:47:05','500',0.00,0.00,'500','2022-03-05 15:16:59','500','2022-03-05 15:17:16',10,0),('1','138',257547,'DAILY SHIFT','2022-03-05','2022-03-05 15:17:47','2022-03-06 15:17:47','500',0.00,0.00,'500','2022-03-05 15:20:30','500','2022-03-05 15:20:48',10,0),('1','138',257548,'DAILY SHIFT','2022-03-05','2022-03-05 15:25:42','2022-03-06 15:25:42','500',0.00,0.00,'500','2022-03-05 19:47:38','500','2022-03-05 19:48:23',10,0),('1','138',257549,'DAILY SHIFT','2022-03-06','2022-03-06 07:13:20','2022-03-07 07:13:20','500',0.00,0.00,'500','2022-03-06 19:33:39','500','2022-03-06 19:33:56',10,0),('1','138',257550,'DAILY SHIFT','2022-03-07','2022-03-07 07:22:56','2022-03-08 07:22:56','500',0.00,0.00,'500','2022-03-07 19:45:10','500','2022-03-07 19:45:31',10,0),('1','138',257551,'DAILY SHIFT','2022-03-07','2022-03-07 23:07:06','2022-03-08 23:07:06','500',0.00,0.00,'500','2022-03-07 23:20:19','500','2022-03-07 23:20:44',10,0),('1','138',257552,'DAILY SHIFT','2022-03-08','2022-03-08 07:30:19','2022-03-09 07:30:19','500',0.00,0.00,'500','2022-03-08 13:39:50','500','2022-03-08 13:40:09',10,0),('1','138',257553,'DAILY SHIFT','2022-03-08','2022-03-08 13:41:30','2022-03-09 13:41:30','500',0.00,0.00,'500','2022-03-08 13:53:38','500','2022-03-08 13:55:15',10,0),('1','138',257554,'DAILY SHIFT','2022-03-08','2022-03-08 14:08:50','2022-03-09 14:08:50','500',0.00,0.00,'500','2022-03-08 19:11:23','500','2022-03-08 19:11:43',10,0),('1','138',257555,'DAILY SHIFT','2022-03-08','2022-03-08 19:12:17','2022-03-09 19:12:17','500',0.00,0.00,'500','2022-03-08 19:17:08','500','2022-03-08 19:17:27',10,0),('1','138',257556,'DAILY SHIFT','2022-03-08','2022-03-08 20:09:43','2022-03-09 20:09:43','500',0.00,0.00,'500','2022-03-08 20:32:33','500','2022-03-08 20:33:07',10,0),('1','138',257557,'DAILY SHIFT','2022-03-09','2022-03-09 07:25:34','2022-03-10 07:25:34','500',0.00,0.00,'500','2022-03-09 19:47:02','500','2022-03-09 19:47:20',10,0),('1','138',257558,'DAILY SHIFT','2022-03-10','2022-03-10 07:09:31','2022-03-11 07:09:31','500',0.00,0.00,'500','2022-03-10 20:19:15','500','2022-03-10 20:19:46',10,0),('1','138',257559,'DAILY SHIFT','2022-03-11','2022-03-11 06:58:37','2022-03-12 06:58:37','500',0.00,0.00,'500','2022-03-11 17:23:06','500','2022-03-11 17:23:38',10,0),('1','138',257560,'DAILY SHIFT','2022-03-11','2022-03-11 17:26:18','2022-03-12 17:26:18','500',0.00,0.00,'500','2022-03-11 17:29:34','500','2022-03-11 17:29:52',10,0),('1','138',257561,'DAILY SHIFT','2022-03-11','2022-03-11 19:35:52','2022-03-12 19:35:52','500',0.00,0.00,'500','2022-03-11 19:53:12','500','2022-03-11 19:53:28',10,0),('1','138',257562,'DAILY SHIFT','2022-03-12','2022-03-12 06:51:32','2022-03-13 06:51:32','500',0.00,0.00,'500','2022-03-12 19:30:37','500','2022-03-12 19:30:56',10,0),('1','138',257563,'DAILY SHIFT','2022-03-13','2022-03-13 06:49:56','2022-03-14 06:49:56','500',0.00,0.00,'500','2022-03-13 19:30:34','500','2022-03-13 19:30:55',10,0),('1','138',257564,'DAILY SHIFT','2022-03-14','2022-03-14 07:52:37','2022-03-15 07:52:37','500',0.00,0.00,'500','2022-03-14 12:17:20','500','2022-03-14 12:17:36',10,0),('1','138',257565,'DAILY SHIFT','2022-03-14','2022-03-14 12:18:51','2022-03-15 12:18:51','500',0.00,0.00,'500','2022-03-14 12:21:55','500','2022-03-14 12:22:17',10,0),('1','138',257566,'DAILY SHIFT','2022-03-14','2022-03-14 14:05:09','2022-03-15 14:05:09','500',0.00,0.00,'500','2022-03-14 19:35:41','500','2022-03-14 19:36:06',10,0),('1','138',257567,'DAILY SHIFT','2022-03-15','2022-03-15 06:57:59','2022-03-16 06:57:59','500',0.00,0.00,'500','2022-03-15 21:36:37','500','2022-03-15 21:36:57',10,0),('1','138',257568,'DAILY SHIFT','2022-03-16','2022-03-16 07:06:20','2022-03-17 07:06:20','500',0.00,0.00,'500','2022-03-16 20:17:31','500','2022-03-16 20:17:58',10,0),('1','138',257569,'DAILY SHIFT','2022-03-17','2022-03-17 07:12:49','2022-03-18 07:12:49','500',0.00,0.00,'500','2022-03-17 15:40:02','500','2022-03-17 15:40:23',10,0),('1','138',257570,'DAILY SHIFT','2022-03-17','2022-03-17 16:00:05','2022-03-18 16:00:05','500',0.00,0.00,'500','2022-03-17 16:07:09','500','2022-03-17 16:07:34',10,0),('1','138',257571,'DAILY SHIFT','2022-03-17','2022-03-17 16:31:07','2022-03-18 16:31:07','500',0.00,0.00,'500','2022-03-17 19:56:14','500','2022-03-17 19:56:33',10,0),('1','138',257572,'DAILY SHIFT','2022-03-18','2022-03-18 06:55:29','2022-03-19 06:55:29','500',0.00,0.00,'500','2022-03-18 20:14:46','500','2022-03-18 20:15:05',10,0),('1','138',257573,'DAILY SHIFT','2022-03-19','2022-03-19 06:54:22','2022-03-20 06:54:22','500',0.00,0.00,'500','2022-03-19 19:51:20','500','2022-03-19 19:51:42',10,0),('1','138',257574,'DAILY SHIFT','2022-03-20','2022-03-20 07:05:21','2022-03-21 07:05:21','500',0.00,0.00,'500','2022-03-20 19:47:12','500','2022-03-20 19:47:32',10,0),('1','138',257575,'DAILY SHIFT','2022-03-21','2022-03-21 06:52:27','2022-03-22 06:52:27','500',0.00,0.00,'500','2022-03-21 22:32:40','500','2022-03-21 22:33:00',10,0),('1','138',257576,'DAILY SHIFT','2022-03-22','2022-03-22 07:10:14','2022-03-23 07:10:14','500',0.00,0.00,'500','2022-03-22 13:29:23','500','2022-03-22 13:29:44',10,0),('1','138',257577,'DAILY SHIFT','2022-03-22','2022-03-22 13:31:15','2022-03-23 13:31:15','500',0.00,0.00,'500','2022-03-22 13:36:51','500','2022-03-22 13:37:08',10,0),('1','138',257578,'DAILY SHIFT','2022-03-22','2022-03-22 13:44:11','2022-03-23 13:44:11','500',0.00,0.00,'500','2022-03-22 19:45:30','500','2022-03-22 19:46:15',10,0),('1','138',257579,'DAILY SHIFT','2022-03-23','2022-03-23 07:04:30','2022-03-24 07:04:30','500',0.00,0.00,'500','2022-03-23 19:38:00','500','2022-03-23 19:38:35',10,0),('1','138',257580,'DAILY SHIFT','2022-03-24','2022-03-24 07:10:02','2022-03-25 07:10:02','500',0.00,0.00,'500','2022-03-24 20:15:45','500','2022-03-24 20:16:21',10,0),('1','138',257581,'DAILY SHIFT','2022-03-25','2022-03-25 07:09:58','2022-03-26 07:09:58','500',0.00,0.00,'500','2022-03-25 19:47:10','500','2022-03-25 19:47:40',10,0),('1','138',257582,'DAILY SHIFT','2022-03-26','2022-03-26 06:50:44','2022-03-27 06:50:44','500',0.00,0.00,'500','2022-03-26 13:22:10','500','2022-03-26 13:22:31',10,0),('1','138',257583,'DAILY SHIFT','2022-03-26','2022-03-26 13:24:30','2022-03-27 13:24:30','500',0.00,0.00,'500','2022-03-26 13:29:44','500','2022-03-26 13:30:08',10,0),('1','138',257584,'DAILY SHIFT','2022-03-26','2022-03-26 13:43:24','2022-03-27 13:43:24','500',0.00,0.00,'500','2022-03-26 19:46:21','500','2022-03-26 19:46:39',10,0),('1','138',257585,'DAILY SHIFT','2022-03-27','2022-03-27 06:50:48','2022-03-28 06:50:48','500',0.00,0.00,'500','2022-03-27 20:27:41','500','2022-03-27 20:28:06',10,0),('1','138',257586,'DAILY SHIFT','2022-03-28','2022-03-28 06:54:58','2022-03-29 06:54:58','500',0.00,0.00,'500','2022-03-28 20:14:32','500','2022-03-28 20:15:39',10,0),('1','138',257587,'DAILY SHIFT','2022-03-29','2022-03-29 06:46:27','2022-03-30 06:46:27','500',0.00,0.00,'500','2022-03-29 19:43:00','500','2022-03-29 19:43:19',10,0),('1','138',257588,'DAILY SHIFT','2022-03-30','2022-03-30 06:47:53','2022-03-31 06:47:53','500',0.00,0.00,'500','2022-03-30 19:38:51','500','2022-03-30 19:39:14',10,0),('1','138',257589,'DAILY SHIFT','2022-03-31','2022-03-31 06:45:24','2022-04-01 06:45:24','500',0.00,0.00,'500','2022-03-31 19:48:12','500','2022-03-31 19:48:38',10,0),('1','138',257590,'DAILY SHIFT','2022-04-01','2022-04-01 06:33:14','2022-04-02 06:33:14','500',0.00,0.00,'500','2022-04-01 14:52:45','500','2022-04-01 14:53:02',10,0),('1','138',257591,'DAILY SHIFT','2022-04-01','2022-04-01 14:54:08','2022-04-02 14:54:08','500',0.00,0.00,'500','2022-04-01 15:00:47','500','2022-04-01 15:01:11',10,0),('1','138',257592,'DAILY SHIFT','2022-04-01','2022-04-01 15:33:58','2022-04-02 15:33:58','500',0.00,0.00,'500','2022-04-01 19:50:43','500','2022-04-01 19:51:02',10,0),('1','138',257593,'DAILY SHIFT','2022-04-02','2022-04-02 06:53:30','2022-04-03 06:53:30','500',0.00,0.00,'500','2022-04-02 13:50:43','500','2022-04-02 13:51:02',10,0),('1','138',257594,'DAILY SHIFT','2022-04-02','2022-04-02 13:52:29','2022-04-03 13:52:29','500',0.00,0.00,'500','2022-04-02 14:00:20','500','2022-04-02 14:00:40',10,0),('1','138',257595,'DAILY SHIFT','2022-04-02','2022-04-02 14:48:07','2022-04-03 14:48:07','500',0.00,0.00,'500','2022-04-02 19:36:11','500','2022-04-02 19:37:30',10,0),('1','138',257596,'DAILY SHIFT','2022-04-03','2022-04-03 06:55:55','2022-04-04 06:55:55','500',0.00,0.00,'500','2022-04-03 19:52:10','500','2022-04-03 19:52:32',10,0),('1','138',257597,'DAILY SHIFT','2022-04-04','2022-04-04 06:57:58','2022-04-05 06:57:58','500',0.00,0.00,'500','2022-04-04 21:04:52','500','2022-04-04 21:05:15',10,0),('1','138',257598,'DAILY SHIFT','2022-04-05','2022-04-05 06:51:12','2022-04-06 06:51:12','500',0.00,0.00,'500','2022-04-05 20:21:14','500','2022-04-05 20:22:25',10,0),('1','138',257599,'DAILY SHIFT','2022-04-06','2022-04-06 06:57:50','2022-04-07 06:57:50','500',0.00,0.00,'500','2022-04-06 13:10:36','500','2022-04-06 13:11:04',10,0),('1','138',257600,'DAILY SHIFT','2022-04-06','2022-04-06 13:12:36','2022-04-07 13:12:36','500',0.00,0.00,'500','2022-04-06 13:20:23','500','2022-04-06 13:20:43',10,0),('1','138',257601,'DAILY SHIFT','2022-04-06','2022-04-06 14:49:30','2022-04-07 14:49:30','500',0.00,0.00,'500','2022-04-06 20:55:23','500','2022-04-06 20:56:13',10,0),('1','138',257602,'DAILY SHIFT','2022-04-07','2022-04-07 07:15:24','2022-04-08 07:15:24','500',0.00,0.00,'500','2022-04-07 11:52:14','500','2022-04-07 11:54:13',10,0),('1','138',257603,'DAILY SHIFT','2022-04-07','2022-04-07 11:55:33','2022-04-08 11:55:33','500',0.00,0.00,'500','2022-04-07 12:35:44','500','2022-04-07 12:36:31',10,0),('1','138',257604,'DAILY SHIFT','2022-04-07','2022-04-07 12:52:51','2022-04-08 12:52:51','500',0.00,0.00,'500','2022-04-07 22:06:34','500','2022-04-07 22:06:52',10,0),('1','138',257605,'DAILY SHIFT','2022-04-08','2022-04-08 06:53:40','2022-04-09 06:53:40','500',0.00,0.00,'500','2022-04-08 13:26:42','500','2022-04-08 13:30:15',10,0),('1','138',257606,'DAILY SHIFT','2022-04-08','2022-04-08 13:32:09','2022-04-09 13:32:09','500',0.00,0.00,'500','2022-04-08 13:35:43','500','2022-04-08 13:36:06',10,0),('1','138',257607,'DAILY SHIFT','2022-04-08','2022-04-08 16:55:26','2022-04-09 16:55:26','500',0.00,0.00,'500','2022-04-08 19:56:27','500','2022-04-08 19:57:01',10,0),('1','138',257608,'DAILY SHIFT','2022-04-09','2022-04-09 07:23:40','2022-04-10 07:23:40','500',0.00,0.00,'500','2022-04-09 19:44:09','500','2022-04-09 19:44:53',10,0),('1','138',257609,'DAILY SHIFT','2022-04-10','2022-04-10 06:45:31','2022-04-11 06:45:31','500',0.00,0.00,'500','2022-04-10 20:06:55','500','2022-04-10 20:19:14',10,0),('1','138',257610,'DAILY SHIFT','2022-04-11','2022-04-11 06:46:41','2022-04-12 06:46:41','500',0.00,0.00,'500','2022-04-11 16:53:07','500','2022-04-11 16:53:25',10,0),('1','138',257611,'DAILY SHIFT','2022-04-11','2022-04-11 20:43:46','2022-04-12 20:43:46','500',0.00,0.00,'500','2022-04-11 21:06:08','500','2022-04-11 21:07:45',10,0),('1','138',257612,'DAILY SHIFT','2022-04-12','2022-04-12 11:29:50','2022-04-13 11:29:50','500',0.00,0.00,'500','2022-04-12 20:32:10','500','2022-04-12 20:32:35',10,0),('1','138',257613,'DAILY SHIFT','2022-04-13','2022-04-13 07:03:14','2022-04-14 07:03:14','500',0.00,0.00,'500','2022-04-13 21:38:25','500','2022-04-13 21:38:51',10,0),('1','138',257614,'DAILY SHIFT','2022-04-14','2022-04-14 06:50:38','2022-04-15 06:50:38','500',0.00,0.00,'500','2022-04-14 17:00:33','500','2022-04-14 17:01:04',10,0),('1','138',257615,'DAILY SHIFT','2022-04-14','2022-04-14 17:01:49','2022-04-15 17:01:49','500',0.00,0.00,'500','2022-04-14 17:12:08','500','2022-04-14 17:12:31',10,0),('1','138',257616,'DAILY SHIFT','2022-04-15','2022-04-15 08:12:34','2022-04-16 08:12:34','500',0.00,0.00,'500','2022-04-15 19:47:32','500','2022-04-15 19:47:50',10,0),('1','138',257617,'DAILY SHIFT','2022-04-16','2022-04-16 06:51:05','2022-04-17 06:51:05','500',0.00,0.00,'500','2022-04-16 11:17:59','500','2022-04-16 11:18:17',10,0),('1','138',257618,'DAILY SHIFT','2022-04-16','2022-04-16 11:25:26','2022-04-17 11:25:26','500',0.00,0.00,'500','2022-04-16 11:32:25','500','2022-04-16 11:32:55',10,0),('1','138',257619,'DAILY SHIFT','2022-04-16','2022-04-16 11:47:53','2022-04-17 11:47:53','500',0.00,0.00,'500','2022-04-16 20:21:44','500','2022-04-16 20:22:25',10,0),('1','138',257620,'DAILY SHIFT','2022-04-17','2022-04-17 06:49:51','2022-04-18 06:49:51','500',0.00,0.00,'500','2022-04-17 19:55:48','500','2022-04-17 19:56:06',10,0),('1','138',257621,'DAILY SHIFT','2022-04-18','2022-04-18 06:55:09','2022-04-19 06:55:09','500',0.00,0.00,'500','2022-04-18 20:34:08','500','2022-04-18 20:34:30',10,0),('1','138',257622,'DAILY SHIFT','2022-04-19','2022-04-19 06:55:26','2022-04-20 06:55:26','500',0.00,0.00,'500','2022-04-19 13:37:59','500','2022-04-19 13:38:18',10,0),('1','138',257623,'DAILY SHIFT','2022-04-19','2022-04-19 13:43:23','2022-04-20 13:43:23','500',0.00,0.00,'500','2022-04-19 14:16:39','500','2022-04-19 14:17:09',10,0),('1','138',257624,'DAILY SHIFT','2022-04-19','2022-04-19 15:05:25','2022-04-20 15:05:25','500',0.00,0.00,'500','2022-04-19 20:19:58','500','2022-04-19 20:20:18',10,0),('1','138',257625,'DAILY SHIFT','2022-04-20','2022-04-20 06:51:51','2022-04-21 06:51:51','500',0.00,0.00,'500','2022-04-20 21:11:25','500','2022-04-20 21:12:07',10,0),('1','138',257626,'DAILY SHIFT','2022-04-21','2022-04-21 06:48:00','2022-04-22 06:48:00','500',0.00,0.00,'500','2022-04-21 20:41:58','500','2022-04-21 20:42:33',10,0),('1','138',257627,'DAILY SHIFT','2022-04-22','2022-04-22 06:37:35','2022-04-23 06:37:35','500',0.00,0.00,'500','2022-04-22 20:40:47','500','2022-04-22 20:43:30',10,0),('1','138',257628,'DAILY SHIFT','2022-04-23','2022-04-23 06:29:23','2022-04-24 06:29:23','500',0.00,0.00,'500','2022-04-23 11:50:41','500','2022-04-23 11:51:04',10,0),('1','138',257629,'DAILY SHIFT','2022-04-23','2022-04-23 11:51:45','2022-04-24 11:51:45','500',0.00,0.00,'500','2022-04-23 11:56:49','500','2022-04-23 11:57:08',10,0),('1','138',257630,'DAILY SHIFT','2022-04-23','2022-04-23 12:38:15','2022-04-24 12:38:15','500',0.00,0.00,'500','2022-04-23 15:27:38','500','2022-04-23 15:27:58',10,0),('1','138',257631,'DAILY SHIFT','2022-04-23','2022-04-23 15:28:49','2022-04-24 15:28:49','500',0.00,0.00,'500','2022-04-23 15:35:47','500','2022-04-23 15:36:15',10,0),('1','138',257632,'DAILY SHIFT','2022-04-23','2022-04-23 15:44:45','2022-04-24 15:44:45','500',0.00,0.00,'500','2022-04-23 21:26:08','500','2022-04-23 21:26:26',10,0),('1','138',257633,'DAILY SHIFT','2022-04-24','2022-04-24 06:32:58','2022-04-25 06:32:58','500',0.00,0.00,'500','2022-04-24 21:08:44','500','2022-04-24 21:09:04',10,0),('1','138',257634,'DAILY SHIFT','2022-04-25','2022-04-25 06:29:08','2022-04-26 06:29:08','500',0.00,0.00,'500','2022-04-25 21:00:22','500','2022-04-25 21:00:40',10,0),('1','138',257635,'DAILY SHIFT','2022-04-26','2022-04-26 06:34:49','2022-04-27 06:34:49','500',0.00,0.00,'500','2022-04-26 11:18:28','500','2022-04-26 11:18:45',10,0),('1','138',257636,'DAILY SHIFT','2022-04-26','2022-04-26 11:20:44','2022-04-27 11:20:44','500',0.00,0.00,'500','2022-04-26 11:25:07','500','2022-04-26 11:25:23',10,0),('1','138',257637,'DAILY SHIFT','2022-04-26','2022-04-26 11:31:06','2022-04-27 11:31:06','500',0.00,0.00,'500','2022-04-26 19:22:48','500','2022-04-26 19:23:14',10,0),('1','138',257638,'DAILY SHIFT','2022-04-27','2022-04-27 06:39:32','2022-04-28 06:39:32','500',0.00,0.00,'500','2022-04-27 20:07:32','500','2022-04-27 20:07:54',10,0),('1','138',257639,'DAILY SHIFT','2022-04-28','2022-04-28 06:33:59','2022-04-29 06:33:59','500',0.00,0.00,'500','2022-04-28 17:39:53','500','2022-04-28 17:40:09',10,0),('1','138',257640,'DAILY SHIFT','2022-04-28','2022-04-28 17:41:34','2022-04-29 17:41:34','500',0.00,0.00,'500','2022-04-28 17:46:03','500','2022-04-28 17:46:20',10,0),('1','138',257641,'DAILY SHIFT','2022-04-28','2022-04-28 18:16:32','2022-04-29 18:16:32','500',0.00,0.00,'500','2022-04-28 18:28:09','500','2022-04-28 18:28:42',10,0),('1','138',257642,'DAILY SHIFT','2022-04-29','2022-04-29 06:35:34','2022-04-30 06:35:34','500',0.00,0.00,'500','2022-04-29 19:35:38','500','2022-04-29 19:35:56',10,0),('1','138',257643,'DAILY SHIFT','2022-04-30','2022-04-30 06:32:48','2022-05-01 06:32:48','500',0.00,0.00,'500','2022-04-30 19:17:09','500','2022-04-30 19:18:12',10,0),('1','138',257644,'DAILY SHIFT','2022-04-30','2022-04-30 19:31:32','2022-05-01 19:31:32','500',0.00,0.00,'500','2022-04-30 19:36:17','500','2022-04-30 19:36:38',10,0),('1','138',257645,'DAILY SHIFT','2022-05-01','2022-05-01 10:40:35','2022-05-02 10:40:35','500',0.00,0.00,'500','2022-05-01 19:01:01','500','2022-05-01 19:01:19',10,0),('1','138',257646,'DAILY SHIFT','2022-05-02','2022-05-02 10:15:46','2022-05-03 10:15:46','500',0.00,0.00,'500','2022-05-02 19:02:45','500','2022-05-02 19:03:04',10,0),('1','138',257647,'DAILY SHIFT','2022-05-03','2022-05-03 07:00:51','2022-05-04 07:00:51','500',0.00,0.00,'500','2022-05-03 14:01:29','500','2022-05-03 14:02:14',10,0),('1','138',257648,'DAILY SHIFT','2022-05-03','2022-05-03 14:06:01','2022-05-04 14:06:01','500',0.00,0.00,'500','2022-05-03 14:11:45','500','2022-05-03 14:12:04',10,0),('1','138',257649,'DAILY SHIFT','2022-05-03','2022-05-03 14:17:33','2022-05-04 14:17:33','500',0.00,0.00,'500','2022-05-03 19:24:50','500','2022-05-03 19:25:08',10,0),('1','138',257650,'DAILY SHIFT','2022-05-04','2022-05-04 07:42:10','2022-05-05 07:42:10','500',0.00,0.00,'500','2022-05-04 18:58:27','500','2022-05-04 18:58:44',10,0),('1','138',257651,'DAILY SHIFT','2022-05-05','2022-05-05 07:16:43','2022-05-06 07:16:43','500',0.00,0.00,'500','2022-05-05 19:24:09','500','2022-05-05 19:24:32',10,0),('1','138',257652,'DAILY SHIFT','2022-05-06','2022-05-06 07:01:47','2022-05-07 07:01:47','500',0.00,0.00,'500','2022-05-06 21:06:26','500','2022-05-06 21:06:44',10,0),('1','138',257653,'DAILY SHIFT','2022-05-07','2022-05-07 00:01:44','2022-05-08 00:01:44','500',0.00,0.00,'500','2022-05-07 00:06:29','500','2022-05-07 00:06:49',10,0),('1','138',257654,'DAILY SHIFT','2022-05-07','2022-05-07 07:09:25','2022-05-08 07:09:25','500',0.00,0.00,'500','2022-05-07 12:05:43','500','2022-05-07 12:06:02',10,0),('1','138',257655,'DAILY SHIFT','2022-05-07','2022-05-07 12:07:16','2022-05-08 12:07:16','500',0.00,0.00,'500','2022-05-07 14:02:40','500','2022-05-07 14:04:33',10,0),('1','138',257656,'DAILY SHIFT','2022-05-07','2022-05-07 16:17:24','2022-05-08 16:17:24','500',0.00,0.00,'500','2022-05-07 19:25:37','500','2022-05-07 19:26:10',10,0),('1','138',257657,'DAILY SHIFT','2022-05-08','2022-05-08 06:43:05','2022-05-09 06:43:05','500',0.00,0.00,'500','2022-05-08 06:47:38','500','2022-05-08 06:47:53',10,0),('1','138',257658,'DAILY SHIFT','2022-05-08','2022-05-08 18:42:55','2022-05-09 18:42:55','500',0.00,0.00,'500','2022-05-08 19:31:33','500','2022-05-08 19:31:50',10,0),('1','138',257659,'DAILY SHIFT','2022-05-09','2022-05-09 07:00:11','2022-05-10 07:00:11','500',0.00,0.00,'500','2022-05-09 20:11:31','500','2022-05-09 20:12:23',10,0),('1','138',257660,'DAILY SHIFT','2022-05-10','2022-05-10 07:14:32','2022-05-11 07:14:32','500',0.00,0.00,'500','2022-05-10 18:10:42','500','2022-05-10 18:11:02',10,0),('1','138',257661,'DAILY SHIFT','2022-05-10','2022-05-10 18:17:40','2022-05-11 18:17:40','500',0.00,0.00,'500','2022-05-10 18:21:03','500','2022-05-10 18:21:21',10,0),('1','138',257662,'DAILY SHIFT','2022-05-12','2022-05-12 10:23:54','2022-05-13 10:23:54','500',0.00,0.00,'500','2022-05-13 07:14:44','500','2022-05-13 07:15:04',10,0),('1','138',257663,'DAILY SHIFT','2022-05-13','2022-05-13 07:15:29','2022-05-14 07:15:29','500',0.00,0.00,'500','2022-05-13 19:18:25','500','2022-05-13 19:18:43',10,0),('1','138',257664,'DAILY SHIFT','2022-05-14','2022-05-14 06:59:52','2022-05-15 06:59:52','500',0.00,0.00,'500','2022-05-14 19:28:54','500','2022-05-14 19:29:13',10,0),('1','138',257665,'DAILY SHIFT','2022-05-15','2022-05-15 07:02:25','2022-05-16 07:02:25','500',0.00,0.00,'500','2022-05-15 13:17:25','500','2022-05-15 13:17:47',10,0),('1','138',257666,'DAILY SHIFT','2022-05-15','2022-05-15 14:07:35','2022-05-16 14:07:35','500',0.00,0.00,'500','2022-05-15 14:11:45','500','2022-05-15 14:12:03',10,0),('1','138',257667,'DAILY SHIFT','2022-05-17','2022-05-17 08:44:53','2022-05-18 08:44:53','500',0.00,0.00,'500','2022-05-18 06:50:05','500','2022-05-18 06:50:27',10,0),('1','138',257668,'DAILY SHIFT','2022-05-18','2022-05-18 06:50:55','2022-05-19 06:50:55','500',0.00,0.00,'500','2022-05-18 16:40:06','500','2022-05-18 16:40:27',10,0),('1','138',257669,'DAILY SHIFT','2022-05-18','2022-05-18 16:42:17','2022-05-19 16:42:17','500',0.00,0.00,'500','2022-05-18 16:48:18','500','2022-05-18 16:48:34',10,0),('1','138',257670,'DAILY SHIFT','2022-05-19','2022-05-19 13:42:12','2022-05-20 13:42:12','500',0.00,0.00,'500','2022-05-19 19:58:32','500','2022-05-19 19:58:54',10,0),('1','138',257671,'DAILY SHIFT','2022-05-20','2022-05-20 07:00:44','2022-05-21 07:00:44','500',0.00,0.00,'500','2022-05-20 18:37:13','500','2022-05-20 18:37:32',10,0),('1','138',257672,'DAILY SHIFT','2022-05-20','2022-05-20 18:41:23','2022-05-21 18:41:23','500',0.00,0.00,'500','2022-05-20 18:44:36','500','2022-05-20 18:44:55',10,0),('1','138',257673,'DAILY SHIFT','2022-05-21','2022-05-21 15:30:07','2022-05-22 15:30:07','500',0.00,0.00,'500','2022-05-21 19:58:24','500','2022-05-21 19:58:42',10,0),('1','138',257674,'DAILY SHIFT','2022-05-22','2022-05-22 06:46:04','2022-05-23 06:46:04','500',0.00,0.00,'500','2022-05-22 22:55:14','500','2022-05-22 22:55:35',10,0),('1','138',257675,'DAILY SHIFT','2022-05-23','2022-05-23 06:45:54','2022-05-24 06:45:54','500',0.00,0.00,'500','2022-05-23 19:00:57','500','2022-05-23 19:01:14',10,0),('1','138',257676,'DAILY SHIFT','2022-05-23','2022-05-23 22:02:50','2022-05-24 22:02:50','500',0.00,0.00,'500','2022-05-23 22:14:30','500','2022-05-23 22:14:58',10,0),('1','138',257677,'DAILY SHIFT','2022-05-24','2022-05-24 09:02:32','2022-05-25 09:02:32','500',0.00,0.00,'500','2022-05-24 20:30:24','500','2022-05-24 20:30:40',10,0),('1','138',257678,'DAILY SHIFT','2022-05-25','2022-05-25 06:33:19','2022-05-26 06:33:19','500',0.00,0.00,'500','2022-05-25 17:49:10','500','2022-05-25 17:49:35',10,0),('1','138',257679,'DAILY SHIFT','2022-05-25','2022-05-25 18:05:58','2022-05-26 18:05:58','500',0.00,0.00,'500','2022-05-25 18:10:00','500','2022-05-25 18:10:18',10,0),('1','138',257680,'DAILY SHIFT','2022-05-26','2022-05-26 07:49:46','2022-05-27 07:49:46','500',0.00,0.00,'500','2022-05-26 19:33:47','500','2022-05-26 19:34:23',10,0),('1','138',257681,'DAILY SHIFT','2022-05-27','2022-05-27 06:57:22','2022-05-28 06:57:22','500',0.00,0.00,'500','2022-05-27 19:28:09','500','2022-05-27 19:28:51',10,0),('1','138',257682,'DAILY SHIFT','2022-05-28','2022-05-28 06:45:37','2022-05-29 06:45:37','500',0.00,0.00,'500','2022-05-28 19:36:50','500','2022-05-28 19:37:07',10,0),('1','138',257683,'DAILY SHIFT','2022-05-29','2022-05-29 06:53:17','2022-05-30 06:53:17','500',0.00,0.00,'500','2022-05-29 11:08:36','500','2022-05-29 11:08:53',10,0),('1','138',257684,'DAILY SHIFT','2022-05-29','2022-05-29 11:09:17','2022-05-30 11:09:17','500',0.00,0.00,'500','2022-05-29 11:16:13','500','2022-05-29 11:16:31',10,0),('1','138',257685,'DAILY SHIFT','2022-05-29','2022-05-29 12:50:57','2022-05-30 12:50:57','500',0.00,0.00,'500','2022-05-29 18:33:46','500','2022-05-29 18:34:05',10,0),('1','138',257686,'DAILY SHIFT','2022-05-30','2022-05-30 08:35:46','2022-05-31 08:35:46','500',0.00,0.00,'500','2022-05-30 08:40:51','500','2022-05-30 08:41:08',10,0),('1','138',257687,'DAILY SHIFT','2022-05-30','2022-05-30 10:55:17','2022-05-31 10:55:17','500',0.00,0.00,'500','2022-05-30 17:42:29','500','2022-05-30 17:43:18',10,0),('1','138',257688,'DAILY SHIFT','2022-05-30','2022-05-30 18:04:58','2022-05-31 18:04:58','500',0.00,0.00,'500','2022-05-30 18:42:52','500','2022-05-30 18:43:18',10,0),('1','138',257689,'DAILY SHIFT','2022-05-31','2022-05-31 10:14:25','2022-06-01 10:14:25','500',0.00,0.00,'500','2022-05-31 14:43:14','500','2022-05-31 14:43:30',10,0),('1','138',257690,'DAILY SHIFT','2022-05-31','2022-05-31 14:44:05','2022-06-01 14:44:05','500',0.00,0.00,'500','2022-05-31 14:48:21','500','2022-05-31 14:48:40',10,0),('1','138',257691,'DAILY SHIFT','2022-06-01','2022-06-01 09:14:16','2022-06-02 09:14:16','500',0.00,0.00,'500','2022-06-01 18:29:37','500','2022-06-01 18:31:22',10,0),('1','138',257692,'DAILY SHIFT','2022-06-01','2022-06-01 18:32:18','2022-06-02 18:32:18','500',0.00,0.00,'500','2022-06-01 18:36:03','500','2022-06-01 18:36:22',10,0),('1','138',257693,'DAILY SHIFT','2022-06-02','2022-06-02 08:48:07','2022-06-03 08:48:07','500',0.00,0.00,'500','2022-06-02 17:19:48','500','2022-06-02 17:20:03',10,0),('1','138',257694,'DAILY SHIFT','2022-06-02','2022-06-02 17:20:25','2022-06-03 17:20:25','500',0.00,0.00,'500','2022-06-02 18:19:07','500','2022-06-02 18:19:26',10,0),('1','138',257695,'DAILY SHIFT','2022-06-02','2022-06-02 18:19:51','2022-06-03 18:19:51','500',0.00,0.00,'500','2022-06-02 20:05:13','500','2022-06-02 20:05:46',10,0),('1','138',257696,'DAILY SHIFT','2022-06-03','2022-06-03 06:03:25','2022-06-04 06:03:25','500',0.00,0.00,'500','2022-06-03 12:00:04','500','2022-06-03 12:00:21',10,0),('1','138',257697,'DAILY SHIFT','2022-06-03','2022-06-03 12:00:59','2022-06-04 12:00:59','500',0.00,0.00,'500','2022-06-03 12:04:28','500','2022-06-03 12:04:46',10,0),('1','138',257698,'DAILY SHIFT','2022-06-03','2022-06-03 12:07:56','2022-06-04 12:07:56','500',0.00,0.00,'500','2022-06-03 20:24:41','500','2022-06-03 20:25:03',10,0),('1','138',257699,'DAILY SHIFT','2022-06-04','2022-06-04 06:45:01','2022-06-05 06:45:01','500',0.00,0.00,'500','2022-06-04 19:37:21','500','2022-06-04 19:37:37',10,0),('1','138',257700,'DAILY SHIFT','2022-06-05','2022-06-05 06:51:13','2022-06-06 06:51:13','500',0.00,0.00,'500','2022-06-05 19:57:47','500','2022-06-05 19:58:10',10,0),('1','138',257701,'DAILY SHIFT','2022-06-06','2022-06-06 06:31:05','2022-06-07 06:31:05','500',0.00,0.00,'500','2022-06-06 19:57:23','500','2022-06-06 19:57:50',10,0),('1','138',257702,'DAILY SHIFT','2022-06-07','2022-06-07 06:53:32','2022-06-08 06:53:32','500',0.00,0.00,'500','2022-06-07 14:16:59','500','2022-06-07 14:17:22',10,0),('1','138',257703,'DAILY SHIFT','2022-06-07','2022-06-07 14:19:52','2022-06-08 14:19:52','500',0.00,0.00,'500','2022-06-07 14:24:39','500','2022-06-07 14:25:01',10,0),('1','138',257704,'DAILY SHIFT','2022-06-07','2022-06-07 14:30:53','2022-06-08 14:30:53','500',0.00,0.00,'500','2022-06-07 20:11:52','500','2022-06-07 20:12:15',10,0),('1','138',257705,'DAILY SHIFT','2022-06-08','2022-06-08 06:53:37','2022-06-09 06:53:37','500',0.00,0.00,'500','2022-06-08 19:53:36','500','2022-06-08 19:53:57',10,0),('1','138',257706,'DAILY SHIFT','2022-06-09','2022-06-09 06:50:35','2022-06-10 06:50:35','500',0.00,0.00,'500','2022-06-09 14:51:06','500','2022-06-09 14:51:31',10,0),('1','138',257707,'DAILY SHIFT','2022-06-09','2022-06-09 14:52:20','2022-06-10 14:52:20','500',0.00,0.00,'500','2022-06-09 15:11:13','500','2022-06-09 15:11:30',10,0),('1','138',257708,'DAILY SHIFT','2022-06-09','2022-06-09 16:45:24','2022-06-10 16:45:24','500',0.00,0.00,'500','2022-06-09 19:26:59','500','2022-06-09 19:27:17',10,0),('1','138',257709,'DAILY SHIFT','2022-06-10','2022-06-10 06:53:48','2022-06-11 06:53:48','500',0.00,0.00,'500','2022-06-10 20:38:02','500','2022-06-10 20:38:21',10,0),('1','138',257710,'DAILY SHIFT','2022-06-11','2022-06-11 07:03:02','2022-06-12 07:03:02','500',0.00,0.00,'500','2022-06-11 20:30:47','500','2022-06-11 20:31:07',10,0),('1','138',257711,'DAILY SHIFT','2022-06-11','2022-06-11 20:39:02','2022-06-12 20:39:02','500',0.00,0.00,'500','2022-06-11 20:40:08','500','2022-06-11 20:40:24',10,0),('1','138',257712,'DAILY SHIFT','2022-06-11','2022-06-11 20:41:41','2022-06-12 20:41:41','500',0.00,0.00,'500','2022-06-11 20:47:54','500','2022-06-11 20:48:12',10,0),('1','138',257713,'DAILY SHIFT','2022-06-12','2022-06-12 09:53:25','2022-06-13 09:53:25','500',0.00,0.00,'500','2022-06-12 20:04:32','500','2022-06-12 20:04:53',10,0),('1','138',257714,'DAILY SHIFT','2022-06-13','2022-06-13 06:59:22','2022-06-14 06:59:22','500',0.00,0.00,'500','2022-06-13 13:25:39','500','2022-06-13 13:26:16',10,0),('1','138',257715,'DAILY SHIFT','2022-06-13','2022-06-13 13:28:01','2022-06-14 13:28:01','500',0.00,0.00,'500','2022-06-13 13:31:55','500','2022-06-13 13:32:13',10,0),('1','138',257716,'DAILY SHIFT','2022-06-13','2022-06-13 16:22:35','2022-06-14 16:22:35','500',0.00,0.00,'500','2022-06-13 19:44:44','500','2022-06-13 19:45:01',10,0),('1','138',257717,'DAILY SHIFT','2022-06-14','2022-06-14 06:58:03','2022-06-15 06:58:03','500',0.00,0.00,'500','2022-06-14 13:36:57','500','2022-06-14 13:37:14',10,0),('1','138',257718,'DAILY SHIFT','2022-06-14','2022-06-14 13:38:27','2022-06-15 13:38:27','500',0.00,0.00,'500','2022-06-14 13:43:04','500','2022-06-14 13:43:23',10,0),('1','138',257719,'DAILY SHIFT','2022-06-15','2022-06-15 08:43:32','2022-06-16 08:43:32','500',0.00,0.00,'500','2022-06-15 19:58:48','500','2022-06-15 20:00:20',10,0),('1','138',257720,'DAILY SHIFT','2022-06-16','2022-06-16 07:10:17','2022-06-17 07:10:17','500',0.00,0.00,'500','2022-06-16 19:32:28','500','2022-06-16 19:33:26',10,0),('1','138',257721,'DAILY SHIFT','2022-06-17','2022-06-17 07:19:20','2022-06-18 07:19:20','500',0.00,0.00,'500','2022-06-17 20:46:55','500','2022-06-17 20:47:11',10,0),('1','138',257722,'DAILY SHIFT','2022-06-18','2022-06-18 06:57:30','2022-06-19 06:57:30','500',0.00,0.00,'500','2022-06-18 19:22:25','500','2022-06-18 19:22:57',10,0),('1','138',257723,'DAILY SHIFT','2022-06-19','2022-06-19 07:21:48','2022-06-20 07:21:48','500',0.00,0.00,'500','2022-06-19 19:27:18','500','2022-06-19 19:27:41',10,0),('1','138',257724,'DAILY SHIFT','2022-06-20','2022-06-20 07:00:41','2022-06-21 07:00:41','500',0.00,0.00,'500','2022-06-20 19:38:27','500','2022-06-20 19:38:45',10,0),('1','138',257725,'DAILY SHIFT','2022-06-21','2022-06-21 06:55:24','2022-06-22 06:55:24','500',0.00,0.00,'500','2022-06-21 19:35:50','500','2022-06-21 19:36:07',10,0),('1','138',257726,'DAILY SHIFT','2022-06-22','2022-06-22 06:46:43','2022-06-23 06:46:43','500',0.00,0.00,'500','2022-06-22 19:46:39','500','2022-06-22 19:46:59',10,0),('1','138',257727,'DAILY SHIFT','2022-06-23','2022-06-23 06:58:21','2022-06-24 06:58:21','500',0.00,0.00,'500','2022-06-23 20:06:52','500','2022-06-23 20:07:10',10,0),('1','138',257728,'DAILY SHIFT','2022-06-24','2022-06-24 06:55:13','2022-06-25 06:55:13','500',0.00,0.00,'500','2022-06-24 19:42:21','500','2022-06-24 19:42:43',10,0),('1','138',257729,'DAILY SHIFT','2022-06-25','2022-06-25 06:12:49','2022-06-26 06:12:49','500',0.00,0.00,'500','2022-06-25 11:41:53','500','2022-06-25 11:42:16',10,0),('1','138',257730,'DAILY SHIFT','2022-06-25','2022-06-25 11:42:37','2022-06-26 11:42:37','500',0.00,0.00,'500','2022-06-25 11:46:38','500','2022-06-25 11:46:54',10,0),('1','138',257731,'DAILY SHIFT','2022-06-25','2022-06-25 11:50:43','2022-06-26 11:50:43','500',0.00,0.00,'500','2022-06-25 20:01:16','500','2022-06-25 20:01:38',10,0),('1','138',257732,'DAILY SHIFT','2022-06-26','2022-06-26 06:44:03','2022-06-27 06:44:03','500',0.00,0.00,'500','2022-06-26 19:39:58','500','2022-06-26 19:40:15',10,0),('1','138',257733,'DAILY SHIFT','2022-06-27','2022-06-27 06:43:51','2022-06-28 06:43:51','500',0.00,0.00,'500','2022-06-27 19:40:35','500','2022-06-27 19:40:54',10,0),('1','138',257734,'DAILY SHIFT','2022-06-28','2022-06-28 06:44:26','2022-06-29 06:44:26','500',0.00,0.00,'500','2022-06-28 22:04:21','500','2022-06-28 22:04:36',10,0),('1','138',257735,'DAILY SHIFT','2022-06-29','2022-06-29 06:48:26','2022-06-30 06:48:26','500',0.00,0.00,'500','2022-06-29 18:34:14','500','2022-06-29 18:34:34',10,0),('1','138',257736,'DAILY SHIFT','2022-06-29','2022-06-29 18:35:15','2022-06-30 18:35:15','500',0.00,0.00,'500','2022-06-29 18:40:16','500','2022-06-29 18:40:36',10,0),('1','138',257737,'DAILY SHIFT','2022-06-30','2022-06-30 09:00:00','2022-07-01 09:00:00','500',0.00,0.00,'500','2022-06-30 15:52:38','500','2022-06-30 15:53:00',10,0),('1','138',257738,'DAILY SHIFT','2022-06-30','2022-06-30 15:54:03','2022-07-01 15:54:03','500',0.00,0.00,'500','2022-06-30 18:09:39','500','2022-06-30 18:09:57',10,0),('1','138',257739,'DAILY SHIFT','2022-06-30','2022-06-30 18:12:47','2022-07-01 18:12:47','500',0.00,0.00,'500','2022-06-30 19:48:32','500','2022-06-30 19:48:58',10,0),('1','138',257740,'Shift','2022-07-01','2022-07-01 05:29:04','2022-07-02 05:29:04','500',0.00,0.00,'500','2022-07-01 18:46:58','500','2022-07-01 18:47:15',10,0),('1','138',257741,'DAILY SHIFT','2022-07-01','2022-07-01 18:54:27','2022-07-02 18:54:27','500',0.00,0.00,'500','2022-07-01 18:57:43','500','2022-07-01 18:58:01',10,0),('1','138',257742,'DAILY SHIFT','2022-07-02','2022-07-02 09:17:51','2022-07-03 09:17:51','500',0.00,0.00,'500','2022-07-02 18:33:08','500','2022-07-02 18:33:26',10,0),('1','138',257743,'DAILY SHIFT','2022-07-02','2022-07-02 18:34:22','2022-07-03 18:34:22','500',0.00,0.00,'500','2022-07-02 18:38:06','500','2022-07-02 18:38:24',10,0),('1','138',257744,'DAILY SHIFT ','2022-07-03','2022-07-03 05:41:32','2022-07-04 05:41:32','500',0.00,0.00,'500','2022-07-03 19:47:00','500','2022-07-03 19:47:18',10,0),('1','138',257745,'DAILY SHIFT ','2022-07-04','2022-07-04 05:26:58','2022-07-05 05:26:58','500',0.00,0.00,'500','2022-07-04 19:48:14','500','2022-07-04 19:48:43',10,0),('1','138',257746,'DAILY SHIFT ','2022-07-05','2022-07-05 05:27:27','2022-07-06 05:27:27','500',0.00,0.00,'500','2022-07-05 19:45:44','500','2022-07-05 19:46:05',10,0),('1','138',257747,'DAILY SHIFT ','2022-07-06','2022-07-06 05:31:26','2022-07-07 05:31:26','500',0.00,0.00,'500','2022-07-06 19:44:17','500','2022-07-06 19:56:40',10,0),('1','138',257748,'DAILY SHIFT','2022-07-07','2022-07-07 06:31:15','2022-07-08 06:31:15','500',0.00,0.00,'500','2022-07-07 13:21:57','500','2022-07-07 13:22:15',10,0),('1','138',257749,'DAILY SHIFT','2022-07-07','2022-07-07 13:41:56','2022-07-08 13:41:56','500',0.00,0.00,'500','2022-07-07 13:45:18','500','2022-07-07 13:45:57',10,0),('1','138',257750,'DAILY SHIFT','2022-07-07','2022-07-07 13:50:19','2022-07-08 13:50:19','500',0.00,0.00,'500','2022-07-07 19:43:19','500','2022-07-07 19:43:38',10,0),('1','138',257751,'DAILY SHIFT ','2022-07-08','2022-07-08 05:35:44','2022-07-09 05:35:44','500',0.00,0.00,'500','2022-07-08 19:33:02','500','2022-07-08 19:33:19',10,0),('1','138',257752,'DAILY SHIFT','2022-07-09','2022-07-09 10:15:23','2022-07-10 10:15:23','500',0.00,0.00,'500','2022-07-09 19:33:39','500','2022-07-09 19:34:03',10,0),('1','138',257753,'DAILY SHIFT ','2022-07-10','2022-07-10 05:33:29','2022-07-11 05:33:29','500',0.00,0.00,'500','2022-07-10 19:25:07','500','2022-07-10 19:25:26',10,0),('1','138',257754,'DAILY SHIFT ','2022-07-11','2022-07-11 05:25:20','2022-07-12 05:25:20','500',0.00,0.00,'500','2022-07-11 19:34:40','500','2022-07-11 19:35:01',10,0),('1','138',257755,'DAILY SHIFT','2022-07-12','2022-07-12 06:59:10','2022-07-13 06:59:10','500',0.00,0.00,'500','2022-07-12 20:46:58','500','2022-07-12 20:47:17',10,0),('1','138',257756,'DAILY SHIFT','2022-07-13','2022-07-13 06:59:11','2022-07-14 06:59:11','500',0.00,0.00,'500','2022-07-13 20:07:13','500','2022-07-13 20:07:31',10,0),('1','138',257757,'DAILY SHIFT','2022-07-14','2022-07-14 06:50:38','2022-07-15 06:50:38','500',0.00,0.00,'500','2022-07-14 19:48:10','500','2022-07-14 19:48:27',10,0),('1','138',257758,'DAILY SHIFT','2022-07-15','2022-07-15 07:03:47','2022-07-16 07:03:47','500',0.00,0.00,'500','2022-07-15 19:22:52','500','2022-07-15 19:23:13',10,0),('1','138',257759,'DAILY SHIFT','2022-07-16','2022-07-16 07:03:16','2022-07-17 07:03:16','500',0.00,0.00,'500','2022-07-16 11:24:49','500','2022-07-16 11:25:12',10,0),('1','138',257760,'DAILY SHIFT','2022-07-16','2022-07-16 11:29:47','2022-07-17 11:29:47','500',0.00,0.00,'500','2022-07-16 11:34:17','500','2022-07-16 11:34:34',10,0),('1','138',257761,'DAILY SHIFT','2022-07-16','2022-07-16 11:58:07','2022-07-17 11:58:07','500',0.00,0.00,'500','2022-07-16 19:26:55','500','2022-07-16 19:27:12',10,0),('1','138',257762,'DAILY SHIFT','2022-07-17','2022-07-17 07:03:46','2022-07-18 07:03:46','500',0.00,0.00,'500','2022-07-17 20:22:56','500','2022-07-17 20:24:16',10,0),('1','138',257763,'DAILY SHIFT','2022-07-18','2022-07-18 06:57:31','2022-07-19 06:57:31','500',0.00,0.00,'500','2022-07-18 14:59:53','500','2022-07-18 15:00:13',10,0),('1','138',257764,'DAILY SHIFT','2022-07-18','2022-07-18 15:00:32','2022-07-19 15:00:32','500',0.00,0.00,'500','2022-07-18 15:09:04','500','2022-07-18 15:09:21',10,0),('1','138',257765,'DAILY SHIFT','2022-07-18','2022-07-18 15:17:10','2022-07-19 15:17:10','500',0.00,0.00,'500','2022-07-18 19:39:36','500','2022-07-18 19:39:53',10,0),('1','138',257766,'DAILY SHIFT','2022-07-19','2022-07-19 07:03:58','2022-07-20 07:03:58','500',0.00,0.00,'500','2022-07-19 19:44:44','500','2022-07-19 19:45:05',10,0),('1','138',257767,'DAILY SHIFT','2022-07-20','2022-07-20 06:52:07','2022-07-21 06:52:07','500',0.00,0.00,'500','2022-07-20 20:35:00','500','2022-07-20 20:35:14',10,0),('1','138',257768,'DAILY SHIFT','2022-07-21','2022-07-21 06:33:49','2022-07-22 06:33:49','500',0.00,0.00,'500','2022-07-21 19:57:22','500','2022-07-21 19:57:45',10,0),('1','138',257769,'DAILY SHIFT','2022-07-22','2022-07-22 06:43:39','2022-07-23 06:43:39','500',0.00,0.00,'500','2022-07-22 20:02:12','500','2022-07-22 20:41:59',10,0),('1','138',257770,'DAILY SHIFT','2022-07-23','2022-07-23 06:32:42','2022-07-24 06:32:42','500',0.00,0.00,'500','2022-07-23 21:50:02','500','2022-07-23 21:50:19',10,0),('1','138',257771,'DAILY SHIFT','2022-07-24','2022-07-24 06:43:28','2022-07-25 06:43:28','500',0.00,0.00,'500','2022-07-24 13:38:34','500','2022-07-24 13:38:53',10,0),('1','138',257772,'DAILY SHIFT','2022-07-24','2022-07-24 13:43:05','2022-07-25 13:43:05','500',0.00,0.00,'500','2022-07-24 13:50:21','500','2022-07-24 13:50:37',10,0),('1','138',257773,'DAILY SHIFT','2022-07-24','2022-07-24 13:50:56','2022-07-25 13:50:56','500',0.00,0.00,'500','2022-07-24 13:55:36','500','2022-07-24 13:55:55',10,0),('1','138',257774,'DAILY SHIFT','2022-07-24','2022-07-24 14:00:57','2022-07-25 14:00:57','500',0.00,0.00,'500','2022-07-24 19:37:12','500','2022-07-24 19:37:33',10,0),('1','138',257775,'DAILY SHIFT','2022-07-25','2022-07-25 06:54:13','2022-07-26 06:54:13','500',0.00,0.00,'500','2022-07-25 19:41:11','500','2022-07-25 19:41:30',10,0),('1','138',257776,'DAILY SHIFT','2022-07-26','2022-07-26 07:04:07','2022-07-27 07:04:07','500',0.00,0.00,'500','2022-07-26 19:50:02','500','2022-07-26 19:50:22',10,0),('1','138',257777,'DAILY SHIFT','2022-07-27','2022-07-27 07:00:21','2022-07-28 07:00:21','500',0.00,0.00,'500','2022-07-28 08:56:33','500','2022-07-28 08:57:00',10,0),('1','138',257778,'DAILY SHIFT','2022-07-28','2022-07-28 08:57:27','2022-07-29 08:57:27','500',0.00,0.00,'500','2022-07-28 17:10:25','500','2022-07-28 17:10:45',10,0),('1','138',257779,'DAILY SHIFT','2022-07-28','2022-07-28 17:11:20','2022-07-29 17:11:20','500',0.00,0.00,'500','2022-07-28 17:16:07','500','2022-07-28 17:16:25',10,0),('1','138',257780,'DAILY SHIFT','2022-07-28','2022-07-28 17:20:25','2022-07-29 17:20:25','500',0.00,0.00,'500','2022-07-28 20:56:16','500','2022-07-28 20:56:44',10,0),('1','138',257781,'DAILY shirt','2022-07-29','2022-07-29 07:06:12','2022-07-30 07:06:12','500',0.00,0.00,'500','2022-07-29 20:04:43','500','2022-07-29 20:04:59',10,0),('1','138',257782,'DAILY SHIFT','2022-07-30','2022-07-30 06:50:52','2022-07-31 06:50:52','500',0.00,0.00,'500','2022-07-30 20:20:27','500','2022-07-30 20:20:43',10,0),('1','138',257783,'DAILY SHIFT','2022-07-31','2022-07-31 07:05:56','2022-08-01 07:05:56','500',0.00,0.00,'500','2022-07-31 15:44:11','500','2022-07-31 15:44:30',10,0),('1','138',257784,'DAILY SHIFT','2022-07-31','2022-07-31 15:48:53','2022-08-01 15:48:53','500',0.00,0.00,'500','2022-07-31 20:12:48','500','2022-07-31 20:13:12',10,0),('1','138',257785,'DAILY SHIFT','2022-08-01','2022-08-01 06:58:21','2022-08-02 06:58:21','500',0.00,0.00,'500','2022-08-01 23:53:54','500','2022-08-01 23:54:15',10,0),('1','138',257786,'DAILY SHIFT','2022-08-02','2022-08-02 07:01:51','2022-08-03 07:01:51','500',0.00,0.00,'500','2022-08-02 22:55:06','500','2022-08-02 22:55:38',10,0),('1','138',257787,'DAILY SHIFT','2022-08-03','2022-08-03 07:05:25','2022-08-04 07:05:25','500',0.00,0.00,'500','2022-08-03 20:07:22','500','2022-08-03 20:09:36',10,0),('1','138',257788,'DAILY SHIFT','2022-08-04','2022-08-04 07:01:26','2022-08-05 07:01:26','500',0.00,0.00,'500','2022-08-04 20:09:45','500','2022-08-04 20:10:06',10,0),('1','138',257789,'DAILY SHIFT','2022-08-05','2022-08-05 07:04:14','2022-08-06 07:04:14','500',0.00,0.00,'500','2022-08-05 17:24:08','500','2022-08-05 17:24:27',10,0),('1','138',257790,'DAILY SHIFT','2022-08-05','2022-08-05 17:24:48','2022-08-06 17:24:48','500',0.00,0.00,'500','2022-08-05 17:36:35','500','2022-08-05 17:36:55',10,0),('1','138',257791,'DAILY SHIFT','2022-08-05','2022-08-05 17:37:53','2022-08-06 17:37:53','500',0.00,0.00,'500','2022-08-05 17:43:40','500','2022-08-05 17:44:00',10,0),('1','138',257792,'DAILY SHIFT','2022-08-05','2022-08-05 23:40:28','2022-08-06 23:40:28','500',0.00,0.00,'500','2022-08-05 23:40:53','500','2022-08-05 23:41:34',10,0),('1','138',257793,'DAILY SHIFT','2022-08-05','2022-08-05 23:42:06','2022-08-06 23:42:06','500',0.00,0.00,'500','2022-08-05 23:56:03','500','2022-08-05 23:56:19',10,0),('1','138',257794,'DAILY SHIFT','2022-08-06','2022-08-06 07:04:34','2022-08-07 07:04:34','500',0.00,0.00,'500','2022-08-06 17:14:05','500','2022-08-06 17:59:14',10,0),('1','138',257795,'DAILY SHIFT','2022-08-06','2022-08-06 17:59:50','2022-08-07 17:59:50','500',0.00,0.00,'500','2022-08-06 21:08:03','500','2022-08-06 21:08:24',10,0),('1','138',257796,'DAILY SHIFT','2022-08-07','2022-08-07 07:07:48','2022-08-08 07:07:48','500',0.00,0.00,'500','2022-08-07 14:47:19','500','2022-08-07 14:47:41',10,0),('1','138',257797,'DAILY SHIFT','2022-08-07','2022-08-07 15:30:51','2022-08-08 15:30:51','500',0.00,0.00,'500','2022-08-07 19:58:03','500','2022-08-07 19:58:19',10,0),('1','138',257798,'DAILY SHIFT','2022-08-08','2022-08-08 07:07:40','2022-08-09 07:07:40','500',0.00,0.00,'500','2022-08-08 19:56:02','500','2022-08-08 19:56:20',10,0),('1','138',257799,'DAILY SHIFT','2022-08-09','2022-08-09 07:00:49','2022-08-10 07:00:49','500',0.00,0.00,'500','2022-08-09 18:38:28','500','2022-08-09 18:39:03',10,0),('1','138',257800,'DAILY SHIFT','2022-08-09','2022-08-09 18:43:01','2022-08-10 18:43:01','500',0.00,0.00,'500','2022-08-09 19:28:01','500','2022-08-09 19:28:17',10,0),('1','138',257801,'DAILY SHIFT','2022-08-10','2022-08-10 07:09:13','2022-08-11 07:09:13','500',0.00,0.00,'500','2022-08-10 17:35:08','500','2022-08-10 17:35:31',10,0),('1','138',257802,'DAILY SHIFT ','2022-08-10','2022-08-10 22:13:12','2022-08-11 22:13:12','500',0.00,0.00,'500','2022-08-10 23:10:32','500','2022-08-10 23:10:47',10,0),('1','138',257803,'DAILY SHIFT','2022-08-11','2022-08-11 07:24:23','2022-08-12 07:24:23','500',0.00,0.00,'500','2022-08-11 19:52:20','500','2022-08-11 19:52:41',10,0),('1','138',257804,'DAILY SHIFT','2022-08-12','2022-08-12 07:03:15','2022-08-13 07:03:15','500',0.00,0.00,'500','2022-08-12 21:05:04','500','2022-08-12 21:05:18',10,0),('1','138',257805,'DAILY SHIFT','2022-08-13','2022-08-13 07:06:23','2022-08-14 07:06:23','500',0.00,0.00,'500','2022-08-13 19:27:51','500','2022-08-13 19:28:09',10,0),('1','138',257806,'DAILY SHIFT','2022-08-14','2022-08-14 07:08:05','2022-08-15 07:08:05','500',0.00,0.00,'500','2022-08-14 12:37:23','500','2022-08-14 12:38:12',10,0),('1','138',257807,'DAILY SHIFT','2022-08-14','2022-08-14 14:29:44','2022-08-15 14:29:44','500',0.00,0.00,'500','2022-08-14 19:55:20','500','2022-08-14 19:55:51',10,0),('1','138',257808,'DAILY SHIFT','2022-08-15','2022-08-15 07:23:21','2022-08-16 07:23:21','500',0.00,0.00,'500','2022-08-15 20:59:16','500','2022-08-15 20:59:38',10,0),('1','138',257809,'DAILY SHIFT','2022-08-16','2022-08-16 07:04:25','2022-08-17 07:04:25','500',0.00,0.00,'500','2022-08-16 16:03:34','500','2022-08-16 16:03:52',10,0),('1','138',257810,'DAILY SHIFT','2022-08-16','2022-08-16 16:05:33','2022-08-17 16:05:33','500',0.00,0.00,'500','2022-08-16 16:08:43','500','2022-08-16 16:09:01',10,0),('1','138',257811,'DAILY SHIFT','2022-08-16','2022-08-16 16:12:39','2022-08-17 16:12:39','500',0.00,0.00,'500','2022-08-17 07:05:13','500','2022-08-17 07:05:33',10,0),('1','138',257812,'DAILY SHIFT','2022-08-17','2022-08-17 07:05:51','2022-08-18 07:05:51','500',0.00,0.00,'500','2022-08-17 19:43:23','500','2022-08-17 19:43:39',10,0),('1','138',257813,'DAILY SHIFT','2022-08-18','2022-08-18 06:26:42','2022-08-19 06:26:42','500',0.00,0.00,'500','2022-08-18 20:09:04','500','2022-08-18 20:09:41',10,0),('1','138',257814,'DAILY SHIFT','2022-08-19','2022-08-19 06:56:33','2022-08-20 06:56:33','500',0.00,0.00,'500','2022-08-19 19:32:27','500','2022-08-19 19:32:56',10,0),('1','138',257815,'DAILY SHIFT','2022-08-20','2022-08-20 07:07:35','2022-08-21 07:07:35','500',0.00,0.00,'500','2022-08-20 18:32:27','500','2022-08-20 18:32:48',10,0),('1','138',257816,'DAILY SHIFT','2022-08-21','2022-08-21 06:13:17','2022-08-22 06:13:17','500',0.00,0.00,'500','2022-08-21 06:19:46','500','2022-08-21 06:20:01',10,0),('1','138',257817,'DAILY SHIFT','2022-08-21','2022-08-21 08:17:58','2022-08-22 08:17:58','500',0.00,0.00,'500','2022-08-21 19:50:30','500','2022-08-21 19:50:54',10,0),('1','138',257818,'DAILY SHIFT','2022-08-22','2022-08-22 07:03:57','2022-08-23 07:03:57','500',0.00,0.00,'500','2022-08-22 10:26:28','500','2022-08-22 10:27:17',10,0),('1','138',257819,'DAILY SHIFT ','2022-08-22','2022-08-22 10:49:30','2022-08-23 10:49:30','500',0.00,0.00,'500','2022-08-22 11:02:49','500','2022-08-22 11:03:22',10,0),('1','138',257820,'DAILY SHIFT','2022-08-22','2022-08-22 11:08:36','2022-08-23 11:08:36','500',0.00,0.00,'500','2022-08-23 02:20:44','500','2022-08-23 02:21:01',10,0),('1','138',257821,'DAILY SHIFT','2022-08-23','2022-08-23 02:32:09','2022-08-24 02:32:09','500',0.00,0.00,'500','2022-08-23 02:37:25','500','2022-08-23 02:37:41',10,0),('1','138',257822,'DAILY SHIFT ','2022-08-23','2022-08-23 09:22:42','2022-08-24 09:22:42','500',0.00,0.00,'500','2022-08-23 19:30:23','500','2022-08-23 19:30:43',10,0),('1','138',257823,'DAILY SHIFT','2022-08-24','2022-08-24 07:14:56','2022-08-25 07:14:56','500',0.00,0.00,'500','2022-08-24 17:24:52','500','2022-08-24 17:25:10',10,0),('1','138',257824,'DAILY SHIFT','2022-08-24','2022-08-24 17:26:08','2022-08-25 17:26:08','500',0.00,0.00,'500','2022-08-24 17:31:12','500','2022-08-24 17:31:34',10,0),('1','138',257825,'DAILY SHIFT','2022-08-27','2022-08-27 09:30:16','2022-08-28 09:30:16','500',0.00,0.00,'500','2022-08-28 07:07:27','500','2022-08-28 07:07:47',10,0),('1','138',257826,'DAILY SHIFT','2022-08-28','2022-08-28 07:08:08','2022-08-29 07:08:08','500',0.00,0.00,'500','2022-08-28 19:36:49','500','2022-08-28 19:37:24',10,0),('1','138',257827,'DAILY SHIFT','2022-08-29','2022-08-29 07:07:36','2022-08-30 07:07:36','500',0.00,0.00,'500','2022-08-29 20:07:07','500','2022-08-29 20:07:29',10,0),('1','138',257828,'DAILY SHIFT','2022-08-30','2022-08-30 07:03:27','2022-08-31 07:03:27','500',0.00,0.00,'500','2022-08-31 00:19:36','500','2022-08-31 00:20:24',10,0),('1','138',257829,'DAILY SHIFT','2022-08-31','2022-08-31 07:05:31','2022-09-01 07:05:31','500',0.00,0.00,'500','2022-09-01 07:08:57','500','2022-09-01 07:09:13',10,0),('1','138',257830,'DAILY SHIFT','2022-09-01','2022-09-01 07:09:33','2022-09-02 07:09:33','500',0.00,0.00,'500','2022-09-01 18:05:52','500','2022-09-01 21:49:42',10,0),('1','138',257831,'DAILY SHIFT ','2022-09-01','2022-09-01 21:58:30','2022-09-02 21:58:30','500',0.00,0.00,'500','2022-09-02 05:23:45','500','2022-09-02 05:24:13',10,0),('1','138',257832,'DAILY SHIFT','2022-09-02','2022-09-02 07:07:10','2022-09-03 07:07:10','500',0.00,0.00,'500','2022-09-02 20:21:50','500','2022-09-02 20:22:19',10,0),('1','138',257833,'DAILY SHIFT','2022-09-03','2022-09-03 07:13:39','2022-09-04 07:13:39','500',0.00,0.00,'500','2022-09-03 15:16:49','500','2022-09-03 15:17:16',10,0),('1','138',257834,'DAILY SHIFT','2022-09-03','2022-09-03 15:20:28','2022-09-04 15:20:28','500',0.00,0.00,'500','2022-09-03 15:25:32','500','2022-09-03 15:25:58',10,0),('1','138',257835,'DAILY SHIFT','2022-09-03','2022-09-03 17:49:35','2022-09-04 17:49:35','500',0.00,0.00,'500','2022-09-03 19:43:16','500','2022-09-03 19:43:40',10,0),('1','138',257836,'DAILY SHIFT','2022-09-04','2022-09-04 07:18:29','2022-09-05 07:18:29','500',0.00,0.00,'500','2022-09-04 17:04:08','500','2022-09-04 17:04:32',10,0),('1','138',257837,'DAILY SHIFT','2022-09-04','2022-09-04 17:10:53','2022-09-05 17:10:53','500',0.00,0.00,'500','2022-09-04 17:14:05','500','2022-09-04 17:14:25',10,0),('1','138',257838,'DAILY SHIFT','2022-09-04','2022-09-04 17:26:26','2022-09-05 17:26:26','500',0.00,0.00,'500','2022-09-04 21:33:34','500','2022-09-04 21:33:58',10,0),('1','138',257839,'DAILY SHIFT','2022-09-05','2022-09-05 07:17:42','2022-09-06 07:17:42','500',0.00,0.00,'500','2022-09-05 19:54:26','500','2022-09-05 19:55:57',10,0),('1','138',257840,'DAILY SHIFT','2022-09-06','2022-09-06 07:09:52','2022-09-07 07:09:52','500',0.00,0.00,'500','2022-09-06 19:56:55','500','2022-09-06 19:57:22',10,0),('1','138',257841,'DAILY SHIFT','2022-09-07','2022-09-07 07:08:57','2022-09-08 07:08:57','500',0.00,0.00,'500','2022-09-07 19:35:38','500','2022-09-07 19:35:59',10,0),('1','138',257842,'DAILY SHIFT','2022-09-08','2022-09-08 07:18:28','2022-09-09 07:18:28','500',0.00,0.00,'500','2022-09-08 19:34:24','500','2022-09-08 19:34:51',10,0),('1','138',257843,'DAILY SHIFT see','2022-09-09','2022-09-09 07:35:19','2022-09-10 07:35:19','500',0.00,0.00,'500','2022-09-09 15:03:22','500','2022-09-09 15:03:46',10,0),('1','138',257844,'DAILY SHIFT','2022-09-09','2022-09-09 15:04:15','2022-09-10 15:04:15','500',0.00,0.00,'500','2022-09-09 15:10:40','500','2022-09-09 15:10:59',10,0),('1','138',257845,'DAILY SHIFT','2022-09-10','2022-09-10 07:02:28','2022-09-11 07:02:28','500',0.00,0.00,'500','2022-09-10 19:40:12','500','2022-09-10 19:40:34',10,0),('1','138',257846,'DAILY SHIFT','2022-09-11','2022-09-11 07:11:39','2022-09-12 07:11:39','500',0.00,0.00,'500','2022-09-11 17:51:30','500','2022-09-11 17:52:01',10,0),('1','138',257847,'DAILY SHIFT','2022-09-12','2022-09-12 15:37:37','2022-09-13 15:37:37','500',0.00,0.00,'500','2022-09-12 15:44:18','500','2022-09-12 15:44:36',10,0),('1','138',257848,'DAILY SHIFT','2022-09-12','2022-09-12 15:47:36','2022-09-13 15:47:36','500',0.00,0.00,'500','2022-09-12 19:56:06','500','2022-09-12 19:56:25',10,0),('1','138',257849,'DAILY SHIFT','2022-09-13','2022-09-13 07:11:26','2022-09-14 07:11:26','500',0.00,0.00,'500','2022-09-13 19:57:08','500','2022-09-13 19:57:40',10,0),('1','138',257850,'DAILY SHIFT','2022-09-14','2022-09-14 07:08:03','2022-09-15 07:08:03','500',0.00,0.00,'500','2022-09-14 20:29:29','500','2022-09-14 20:29:47',10,0),('1','138',257851,'DAILY SHIFT','2022-09-14','2022-09-14 20:36:03','2022-09-15 20:36:03','500',0.00,0.00,'500','2022-09-14 20:44:13','500','2022-09-14 20:44:47',10,0),('1','138',257852,'DAILY SHIFT','2022-09-15','2022-09-15 08:56:56','2022-09-16 08:56:56','500',0.00,0.00,'500','2022-09-15 19:27:25','500','2022-09-15 19:27:47',10,0),('1','138',257853,'DAILY SHIFT','2022-09-16','2022-09-16 07:16:36','2022-09-17 07:16:36','500',0.00,0.00,'500','2022-09-16 19:28:06','500','2022-09-16 19:28:29',10,0),('1','138',257854,'DAILY SHIFT','2022-09-17','2022-09-17 07:08:07','2022-09-18 07:08:07','500',0.00,0.00,'500','2022-09-17 14:28:08','500','2022-09-17 14:28:36',10,0),('1','138',257855,'DAILY SHIFT','2022-09-17','2022-09-17 14:29:05','2022-09-18 14:29:05','500',0.00,0.00,'500','2022-09-17 14:35:15','500','2022-09-17 14:35:45',10,0),('1','138',257856,'DAILY SHIFT','2022-09-17','2022-09-17 18:52:12','2022-09-18 18:52:12','500',0.00,0.00,'500','2022-09-18 07:10:18','500','2022-09-18 07:10:36',10,0),('1','138',257857,'DAILY SHIFT','2022-09-18','2022-09-18 07:10:53','2022-09-19 07:10:53','500',0.00,0.00,'500','2022-09-18 19:40:27','500','2022-09-18 19:40:52',10,0),('1','138',257858,'DAILY SHIFT','2022-09-19','2022-09-19 07:18:57','2022-09-20 07:18:57','500',0.00,0.00,'500','2022-09-19 15:14:09','500','2022-09-19 15:14:33',10,0),('1','138',257859,'DAILY SHIFT','2022-09-19','2022-09-19 15:15:00','2022-09-20 15:15:00','500',0.00,0.00,'500','2022-09-19 15:20:11','500','2022-09-19 15:20:32',10,0),('1','138',257860,'DAILY SHIFT','2022-09-20','2022-09-20 07:09:55','2022-09-21 07:09:55','500',0.00,0.00,'500','2022-09-20 18:56:01','500','2022-09-20 18:56:23',10,0),('1','138',257861,'DAILY SHIFT','2022-09-21','2022-09-21 06:42:58','2022-09-22 06:42:58','500',0.00,0.00,'500','2022-09-21 19:24:54','500','2022-09-21 19:25:15',10,0),('1','138',257862,'DAILY SHIFT','2022-09-22','2022-09-22 07:13:35','2022-09-23 07:13:35','500',0.00,0.00,'500','2022-09-22 19:20:31','500','2022-09-22 19:20:57',10,0),('1','138',257863,'DAILY SHIFT','2022-09-23','2022-09-23 07:10:37','2022-09-24 07:10:37','500',0.00,0.00,'500','2022-09-23 13:58:24','500','2022-09-23 13:58:48',10,0),('1','138',257864,'DAILY SHIFT','2022-09-23','2022-09-23 14:08:28','2022-09-24 14:08:28','500',0.00,0.00,'500','2022-09-23 14:42:49','500','2022-09-23 14:43:07',10,0),('1','138',257865,'DAILY SHIFT','2022-09-23','2022-09-23 15:50:08','2022-09-24 15:50:08','500',0.00,0.00,'500','2022-09-23 19:12:32','500','2022-09-23 19:12:57',10,0),('1','138',257866,'DAILY SHIFT','2022-09-24','2022-09-24 07:10:10','2022-09-25 07:10:10','500',0.00,0.00,'500','2022-09-24 19:24:22','500','2022-09-24 19:25:17',10,0),('1','138',257867,'DAILY SHIFT','2022-09-25','2022-09-25 07:03:33','2022-09-26 07:03:33','500',0.00,0.00,'500','2022-09-25 20:41:03','500','2022-09-25 20:41:34',10,0),('1','138',257868,'DAILY SHIFT','2022-09-26','2022-09-26 06:50:46','2022-09-27 06:50:46','500',0.00,0.00,'500','2022-09-26 15:43:49','500','2022-09-26 15:44:08',10,0),('1','138',257869,'DAILY SHIFT','2022-09-26','2022-09-26 15:53:16','2022-09-27 15:53:16','500',0.00,0.00,'500','2022-09-26 16:01:20','500','2022-09-26 16:01:37',10,0),('1','138',257870,'DAILY SHIFT','2022-09-27','2022-09-27 07:06:51','2022-09-28 07:06:51','500',0.00,0.00,'500','2022-09-27 20:21:34','500','2022-09-27 20:21:57',10,0),('1','138',257871,'DAILY SHIFT','2022-09-28','2022-09-28 07:12:35','2022-09-29 07:12:35','500',0.00,0.00,'500','2022-09-28 19:30:56','500','2022-09-28 19:31:14',10,0),('1','138',257872,'DAILY SHIFT','2022-09-29','2022-09-29 06:46:42','2022-09-30 06:46:42','500',0.00,0.00,'500','2022-09-29 20:36:50','500','2022-09-29 20:37:14',10,0),('1','138',257873,'DAILY SHIFT','2022-09-30','2022-09-30 06:42:42','2022-10-01 06:42:42','500',0.00,0.00,'500','2022-09-30 19:35:44','500','2022-09-30 19:36:03',10,0),('1','138',257874,'DAILY SHIFT','2022-10-01','2022-10-01 06:34:29','2022-10-02 06:34:29','500',0.00,0.00,'500','2022-10-01 21:29:10','500','2022-10-01 21:29:30',10,0),('1','138',257875,'DAILY SHIFT','2022-10-02','2022-10-02 06:39:01','2022-10-03 06:39:01','500',0.00,0.00,'500','2022-10-02 11:33:19','500','2022-10-02 11:33:35',10,0),('1','138',257876,'DAILY SHIFT','2022-10-02','2022-10-02 11:34:05','2022-10-03 11:34:05','500',0.00,0.00,'500','2022-10-02 11:42:57','500','2022-10-02 11:43:17',10,0),('1','138',257877,'DAILY SHIFT','2022-10-02','2022-10-02 13:28:09','2022-10-03 13:28:09','500',0.00,0.00,'500','2022-10-02 21:15:03','500','2022-10-02 21:15:25',10,0),('1','138',257878,'DAILY SHIFT','2022-10-03','2022-10-03 06:50:56','2022-10-04 06:50:56','500',0.00,0.00,'500','2022-10-03 20:23:16','500','2022-10-03 20:23:36',10,0),('1','138',257879,'DAILY SHIFT','2022-10-04','2022-10-04 06:34:55','2022-10-05 06:34:55','500',0.00,0.00,'500','2022-10-04 13:37:31','500','2022-10-04 13:37:49',10,0),('1','138',257880,'DAILY SHIFT','2022-10-04','2022-10-04 14:38:11','2022-10-05 14:38:11','500',0.00,0.00,'500','2022-10-04 14:41:27','500','2022-10-04 14:41:45',10,0),('1','138',257881,'DAILY SHIFT','2022-10-06','2022-10-06 17:18:22','2022-10-07 17:18:22','500',0.00,0.00,'500','2022-10-06 19:48:44','500','2022-10-06 19:49:40',10,0),('1','138',257882,'DAILY SHIFT','2022-10-07','2022-10-07 06:49:38','2022-10-08 06:49:38','500',0.00,0.00,'500','2022-10-07 19:46:53','500','2022-10-07 19:47:14',10,0),('1','138',257883,'DAILY SHIFT','2022-10-08','2022-10-08 06:58:53','2022-10-09 06:58:53','500',0.00,0.00,'500','2022-10-08 13:43:16','500','2022-10-08 13:43:34',10,0),('1','138',257884,'DAILY SHIFT','2022-10-08','2022-10-08 13:46:38','2022-10-09 13:46:38','500',0.00,0.00,'500','2022-10-08 13:59:48','500','2022-10-08 14:00:06',10,0),('1','138',257885,'DAILY SHIFT','2022-10-11','2022-10-11 09:21:49','2022-10-12 09:21:49','500',0.00,0.00,'500','2022-10-11 21:14:36','500','2022-10-11 21:15:15',10,0),('1','138',257886,'DAILY SHIFT','2022-10-12','2022-10-12 06:46:33','2022-10-13 06:46:33','500',0.00,0.00,'500','2022-10-12 15:52:10','500','2022-10-12 15:52:29',10,0),('1','138',257887,'DAILY SHIFT','2022-10-12','2022-10-12 15:52:55','2022-10-13 15:52:55','500',0.00,0.00,'500','2022-10-12 15:59:21','500','2022-10-12 15:59:44',10,0),('1','138',257888,'DAILY SHIFT','2022-10-12','2022-10-12 16:51:06','2022-10-13 16:51:06','500',0.00,0.00,'500','2022-10-12 19:40:27','500','2022-10-12 19:40:46',10,0),('1','138',257889,'DAILY SHIFT','2022-10-13','2022-10-13 07:05:07','2022-10-14 07:05:07','500',0.00,0.00,'500','2022-10-13 19:28:11','500','2022-10-13 19:28:35',10,0),('1','138',257890,'DAILY SHIFT','2022-10-14','2022-10-14 06:55:20','2022-10-15 06:55:20','500',0.00,0.00,'500','2022-10-14 09:00:04','500','2022-10-14 09:00:24',10,0),('1','138',257891,'DAILY SHIFT','2022-10-14','2022-10-14 09:01:19','2022-10-15 09:01:19','500',0.00,0.00,'500','2022-10-14 09:06:04','500','2022-10-14 09:06:28',10,0),('1','138',257892,'DAILY SHIFT','2022-10-14','2022-10-14 11:27:25','2022-10-15 11:27:25','500',0.00,0.00,'500','2022-10-14 19:11:24','500','2022-10-14 19:11:45',10,0),('1','138',257893,'DAILY SHIFT','2022-10-15','2022-10-15 07:02:42','2022-10-16 07:02:42','500',0.00,0.00,'500','2022-10-15 11:43:41','500','2022-10-15 11:44:07',10,0),('1','138',257894,'DAILY SHIFT','2022-10-16','2022-10-16 12:30:04','2022-10-17 12:30:04','500',0.00,0.00,'500','2022-10-16 13:18:14','500','2022-10-16 13:19:03',10,0),('1','138',257895,'DAILY SHIFT','2022-10-16','2022-10-16 13:19:32','2022-10-17 13:19:32','500',0.00,0.00,'500','2022-10-16 18:37:46','500','2022-10-16 18:38:06',10,0),('1','138',257896,'DAILY SHIFT','2022-10-17','2022-10-17 06:40:07','2022-10-18 06:40:07','500',0.00,0.00,'500','2022-10-18 06:43:46','500','2022-10-18 06:44:06',10,0),('1','138',257897,'DAILY SHIFT','2022-10-18','2022-10-18 06:44:31','2022-10-19 06:44:31','500',0.00,0.00,'500','2022-10-18 19:07:02','500','2022-10-18 19:07:25',10,0),('1','138',257898,'DAILY SHIFT','2022-10-19','2022-10-19 06:40:57','2022-10-20 06:40:57','500',0.00,0.00,'500','2022-10-20 10:06:56','500','2022-10-20 10:07:11',10,0),('1','138',257899,'DAILY SHIFT','2022-10-20','2022-10-20 10:07:26','2022-10-21 10:07:26','500',0.00,0.00,'500','2022-10-20 20:29:03','500','2022-10-20 20:29:21',10,0),('1','138',257900,'DAILY SHIFT','2022-10-21','2022-10-21 07:17:47','2022-10-22 07:17:47','500',0.00,0.00,'500','2022-10-21 19:34:14','500','2022-10-21 19:34:58',10,0),('1','138',257901,'DAILY SHIFT','2022-10-22','2022-10-22 06:57:17','2022-10-23 06:57:17','500',0.00,0.00,'500','2022-10-22 12:41:09','500','2022-10-22 12:41:54',10,0),('1','138',257902,'DAILY SHIFT','2022-10-22','2022-10-22 16:54:12','2022-10-23 16:54:12','500',0.00,0.00,'500','2022-10-22 19:09:01','500','2022-10-22 19:09:25',10,0),('1','138',257903,'DAILY SHIFT','2022-10-23','2022-10-23 07:04:30','2022-10-24 07:04:30','500',0.00,0.00,'500','2022-10-23 18:51:21','500','2022-10-23 18:51:41',10,0),('1','138',257904,'DAILY SHIFT','2022-10-24','2022-10-24 07:03:26','2022-10-25 07:03:26','500',0.00,0.00,'500','2022-10-24 19:09:39','500','2022-10-24 19:10:09',10,0),('1','138',257905,'DAILY SHIFT','2022-10-25','2022-10-25 06:52:59','2022-10-26 06:52:59','500',0.00,0.00,'500','2022-10-25 16:15:54','500','2022-10-25 16:16:20',10,0),('1','138',257906,'DAILY SHIFT','2022-10-25','2022-10-25 17:02:58','2022-10-26 17:02:58','500',0.00,0.00,'500','2022-10-25 18:58:32','500','2022-10-25 18:58:51',10,0),('1','138',257907,'DAILY SHIFT','2022-10-26','2022-10-26 07:04:48','2022-10-27 07:04:48','500',0.00,0.00,'500','2022-10-26 19:02:31','500','2022-10-26 19:02:57',10,0),('1','138',257908,'DAILY SHIFT','2022-10-27','2022-10-27 06:13:43','2022-10-28 06:13:43','500',0.00,0.00,'500','2022-10-27 19:00:44','500','2022-10-27 19:01:02',10,0),('1','138',257909,'DAILY SHIFT','2022-10-28','2022-10-28 07:01:39','2022-10-29 07:01:39','500',0.00,0.00,'500','2022-10-28 18:48:56','500','2022-10-29 06:45:19',10,0),('1','138',257910,'DAILY SHIFT','2022-10-29','2022-10-29 06:45:34','2022-10-30 06:45:34','500',0.00,0.00,'500','2022-10-29 15:14:23','500','2022-10-29 15:14:46',10,0),('1','138',257911,'DAILY SHIFT','2022-10-29','2022-10-29 15:15:11','2022-10-30 15:15:11','500',0.00,0.00,'500','2022-10-29 15:20:25','500','2022-10-29 15:20:47',10,0),('1','138',257912,'DAILY SHIFT','2022-10-29','2022-10-29 18:06:47','2022-10-30 18:06:47','500',0.00,0.00,'500','2022-10-29 19:06:45','500','2022-10-29 19:07:02',10,0),('1','138',257913,'DAILY SHIFT','2022-10-30','2022-10-30 06:52:32','2022-10-31 06:52:32','500',0.00,0.00,'500','2022-10-31 07:33:28','500','2022-10-31 07:33:45',10,0),('1','138',257914,'DAILY SHIFT','2022-10-31','2022-10-31 07:33:59','2022-11-01 07:33:59','500',0.00,0.00,'500','2022-11-01 07:02:18','500','2022-11-01 07:02:35',10,0),('1','138',257915,'DAILY SHIFT','2022-11-01','2022-11-01 07:02:50','2022-11-02 07:02:50','500',0.00,0.00,'500','2022-11-01 19:23:28','500','2022-11-01 19:23:56',10,0),('1','138',257916,'DAILY SHIFT ','2022-11-05','2022-11-05 07:58:13','2022-11-06 07:58:13','500',0.00,0.00,'500','2022-11-05 08:04:13','500','2022-11-05 08:04:49',10,0),('1','138',257917,'DAILY SHIFT','2022-11-05','2022-11-05 08:41:47','2022-11-06 08:41:47','500',0.00,0.00,'500','2022-11-05 19:02:13','500','2022-11-05 19:02:36',10,0),('1','138',257918,'DAILY SHIFT','2022-11-06','2022-11-06 07:55:10','2022-11-07 07:55:10','500',0.00,0.00,'500','2022-11-07 07:02:37','500','2022-11-07 07:02:54',10,0),('1','138',257919,'DAILY SHIFT','2022-11-07','2022-11-07 07:03:36','2022-11-08 07:03:36','500',0.00,0.00,'500','2022-11-07 18:49:12','500','2022-11-07 18:50:07',10,0),('1','138',257920,'DAILY SHIFT','2022-11-07','2022-11-07 19:22:42','2022-11-08 19:22:42','500',0.00,0.00,'500','2022-11-08 09:49:47','500','2022-11-08 09:50:03',10,0),('1','138',257921,'DAILY SHIFT','2022-11-08','2022-11-08 09:50:34','2022-11-09 09:50:34','500',0.00,0.00,'500','2022-11-08 19:01:41','500','2022-11-08 19:02:27',10,0),('1','138',257922,'DAILY SHIFT','2022-11-09','2022-11-09 07:22:32','2022-11-10 07:22:32','500',0.00,0.00,'500','2022-11-09 19:06:29','500','2022-11-09 19:06:49',10,0),('1','138',257923,'DAILY SHIFT','2022-11-10','2022-11-10 06:55:23','2022-11-11 06:55:23','500',0.00,0.00,'500','2022-11-11 06:59:52','500','2022-11-11 07:00:08',10,0),('1','138',257924,'DAILY SHIFT','2022-11-11','2022-11-11 07:00:22','2022-11-12 07:00:22','500',0.00,0.00,'500','2022-11-11 19:02:07','500','2022-11-11 19:02:25',10,0),('1','138',257925,'DAILY SHIFT','2022-11-12','2022-11-12 07:10:17','2022-11-13 07:10:17','500',0.00,0.00,'500','2022-11-12 14:02:14','500','2022-11-12 14:02:55',10,0),('1','138',257926,'DAILY SHIFT','2022-11-12','2022-11-12 14:19:28','2022-11-13 14:19:28','500',0.00,0.00,'500','2022-11-12 18:50:43','500','2022-11-12 18:51:08',10,0),('1','138',257927,'DAILY SHIFT','2022-11-13','2022-11-13 07:08:16','2022-11-14 07:08:16','500',0.00,0.00,'500','2022-11-13 18:46:14','500','2022-11-13 18:46:35',10,0),('1','138',257928,'DAILY SHIFT','2022-11-14','2022-11-14 07:09:14','2022-11-15 07:09:14','500',0.00,0.00,'500','2022-11-15 06:48:19','500','2022-11-15 06:48:37',10,0),('1','138',257929,'DAILY SHIFT','2022-11-15','2022-11-15 06:48:53','2022-11-16 06:48:53','500',0.00,0.00,'500','2022-11-15 18:49:56','500','2022-11-15 18:50:16',10,0),('1','138',257930,'DAILY SHIFT','2022-11-16','2022-11-16 06:59:16','2022-11-17 06:59:16','500',0.00,0.00,'500','2022-11-16 20:27:55','500','2022-11-16 20:28:15',10,0),('1','138',257931,'DAILY SHIFT','2022-11-17','2022-11-17 07:01:51','2022-11-18 07:01:51','500',0.00,0.00,'500','2022-11-17 19:59:54','500','2022-11-17 20:00:14',10,0),('1','138',257932,'DAILY SHIFT','2022-11-18','2022-11-18 08:05:11','2022-11-19 08:05:11','500',0.00,0.00,'500','2022-11-18 19:30:02','500','2022-11-18 19:30:24',10,0),('1','138',257933,'DAILY SHIFT','2022-11-19','2022-11-19 07:21:16','2022-11-20 07:21:16','500',0.00,0.00,'500','2022-11-20 07:11:48','500','2022-11-20 07:12:09',10,0),('1','138',257934,'DAILY SHIFT','2022-11-20','2022-11-20 07:12:30','2022-11-21 07:12:30','500',0.00,0.00,'500','2022-11-20 19:11:06','500','2022-11-20 19:11:26',10,0),('1','138',257935,'DAILY SHIFT','2022-11-21','2022-11-21 07:11:06','2022-11-22 07:11:06','500',0.00,0.00,'500','2022-11-22 07:16:00','500','2022-11-22 07:16:19',10,0),('1','138',257936,'DAILY SHIFT','2022-11-22','2022-11-22 07:16:34','2022-11-23 07:16:34','500',0.00,0.00,'500','2022-11-22 19:30:00','500','2022-11-22 19:30:20',10,0),('1','138',257937,'DAILY SHIFT','2022-11-23','2022-11-23 07:08:14','2022-11-24 07:08:14','500',0.00,0.00,'500','2022-11-23 13:38:09','500','2022-11-23 13:38:26',10,0),('1','138',257938,'DAILY SHIFT','2022-11-23','2022-11-23 14:28:29','2022-11-24 14:28:29','500',0.00,0.00,'500','2022-11-23 19:20:10','500','2022-11-23 19:20:28',10,0),('1','138',257939,'DAILY SHIFT','2022-11-24','2022-11-24 07:09:50','2022-11-25 07:09:50','500',0.00,0.00,'500','2022-11-25 07:04:51','500','2022-11-25 07:05:09',10,0),('1','138',257940,'DAILY SHIFT','2022-11-25','2022-11-25 07:05:24','2022-11-26 07:05:24','500',0.00,0.00,'500','2022-11-25 19:46:42','500','2022-11-25 19:47:13',10,0),('1','138',257941,'DAILY SHIFT','2022-11-26','2022-11-26 06:50:29','2022-11-27 06:50:29','500',0.00,0.00,'500','2022-11-26 19:19:57','500','2022-11-26 19:20:19',10,0),('1','138',257942,'DAILY SHIFT','2022-11-27','2022-11-27 06:50:18','2022-11-28 06:50:18','500',0.00,0.00,'500','2022-11-27 18:39:47','500','2022-11-27 18:40:02',10,0),('1','138',257943,'DAILY SHIFT','2022-11-28','2022-11-28 07:10:10','2022-11-29 07:10:10','500',0.00,0.00,'500','2022-11-28 19:41:46','500','2022-11-28 19:43:20',10,0),('1','138',257944,'DAILY SHIFT','2022-11-29','2022-11-29 07:08:07','2022-11-30 07:08:07','500',0.00,0.00,'500','2022-11-30 06:53:33','500','2022-11-30 06:53:59',10,0),('1','138',257945,'DAILY SHIFT','2022-11-30','2022-11-30 07:06:20','2022-12-01 07:06:20','500',0.00,0.00,'500','2022-11-30 14:01:49','500','2022-11-30 14:02:06',10,0),('1','138',257946,'DAILY SHIFT','2022-11-30','2022-11-30 14:26:08','2022-12-01 14:26:08','500',0.00,0.00,'500','2022-11-30 14:33:02','500','2022-11-30 14:33:20',10,0),('1','138',257947,'DAILY SHIFT','2022-11-30','2022-11-30 14:37:12','2022-12-01 14:37:12','500',0.00,0.00,'500','2022-11-30 21:08:24','500','2022-11-30 21:08:47',10,0),('1','138',257948,'DAILY SHIFT','2022-12-01','2022-12-01 07:03:30','2022-12-02 07:03:30','500',0.00,0.00,'500','2022-12-01 19:09:54','500','2022-12-01 19:10:27',10,0),('1','138',257949,'DAILY SHIFT','2022-12-02','2022-12-02 07:06:43','2022-12-03 07:06:43','500',0.00,0.00,'500','2022-12-03 06:47:36','500','2022-12-03 06:47:55',10,0),('1','138',257950,'DAILY SHIFT','2022-12-03','2022-12-03 06:48:15','2022-12-04 06:48:15','500',0.00,0.00,'500','2022-12-03 19:19:27','500','2022-12-03 19:19:50',10,0),('1','138',257951,'DAILY SHIFT','2022-12-04','2022-12-04 06:55:21','2022-12-05 06:55:21','500',0.00,0.00,'500','2022-12-04 18:58:49','500','2022-12-04 18:59:07',10,0),('1','138',257952,'DAILY SHIFT','2022-12-05','2022-12-05 06:58:45','2022-12-06 06:58:45','500',0.00,0.00,'500','2022-12-05 12:43:23','500','2022-12-05 12:47:52',10,0),('1','138',257953,'DAILY SHIFT','2022-12-05','2022-12-05 12:49:44','2022-12-06 12:49:44','500',0.00,0.00,'500','2022-12-05 13:28:51','500','2022-12-05 13:29:11',10,0),('1','138',257954,'DAILY SHIFT','2022-12-05','2022-12-05 13:29:36','2022-12-06 13:29:36','500',0.00,0.00,'500','2022-12-06 07:22:36','500','2022-12-06 07:22:53',10,0),('1','138',257955,'DAILY SHIFT','2022-12-06','2022-12-06 07:23:09','2022-12-07 07:23:09','500',0.00,0.00,'500','2022-12-07 07:00:05','500','2022-12-07 07:00:22',10,0),('1','138',257956,'DAILY SHIFT','2022-12-07','2022-12-07 07:00:35','2022-12-08 07:00:35','500',0.00,0.00,'500','2022-12-07 20:14:09','500','2022-12-07 20:14:27',10,0),('1','138',257957,'DAILY SHIFT','2022-12-08','2022-12-08 07:01:31','2022-12-09 07:01:31','500',0.00,0.00,'500','2022-12-08 20:18:02','500','2022-12-08 20:18:29',10,0),('1','138',257958,'DAILY SHIFT','2022-12-09','2022-12-09 06:55:50','2022-12-10 06:55:50','500',0.00,0.00,'500','2022-12-09 19:18:04','500','2022-12-09 19:19:11',10,0),('1','138',257959,'DAILY SHIFT','2022-12-10','2022-12-10 06:55:13','2022-12-11 06:55:13','500',0.00,0.00,'500','2022-12-10 12:44:49','500','2022-12-10 12:45:15',10,0),('1','138',257960,'DAILY SHIFT','2022-12-10','2022-12-10 12:49:34','2022-12-11 12:49:34','500',0.00,0.00,'500','2022-12-10 13:13:11','500','2022-12-10 13:13:41',10,0),('1','138',257961,'DAILY SHIFT','2022-12-10','2022-12-10 14:13:51','2022-12-11 14:13:51','500',0.00,0.00,'500','2022-12-10 19:20:29','500','2022-12-10 19:20:50',10,0),('1','138',257962,'DAILY SHIFT','2022-12-11','2022-12-11 06:51:50','2022-12-12 06:51:50','500',0.00,0.00,'500','2022-12-11 12:08:33','500','2022-12-11 12:08:52',10,0),('1','138',257963,'DAILY SHIFT','2022-12-11','2022-12-11 13:25:35','2022-12-12 13:25:35','500',0.00,0.00,'500','2022-12-11 13:31:11','500','2022-12-11 13:31:43',10,0),('1','138',257964,'DAILY SHIFT','2022-12-11','2022-12-11 13:42:10','2022-12-12 13:42:10','500',0.00,0.00,'500','2022-12-11 18:31:23','500','2022-12-11 18:31:48',10,0),('1','138',257965,'DAILY SHIFT','2022-12-12','2022-12-12 07:09:22','2022-12-13 07:09:22','500',0.00,0.00,'500','2022-12-12 19:05:18','500','2022-12-12 19:05:36',10,0),('1','138',257966,'DAILY SHIFT','2022-12-13','2022-12-13 07:02:21','2022-12-14 07:02:21','500',0.00,0.00,'500','2022-12-14 06:47:16','500','2022-12-14 06:47:48',10,0),('1','138',257967,'DAILY SHIFT','2022-12-14','2022-12-14 06:48:04','2022-12-15 06:48:04','500',0.00,0.00,'500','2022-12-14 19:06:22','500','2022-12-14 19:06:40',10,0),('1','138',257968,'DAILY SHIFT','2022-12-15','2022-12-15 07:03:34','2022-12-16 07:03:34','500',0.00,0.00,'500','2022-12-15 19:40:43','500','2022-12-15 19:41:03',10,0),('1','138',257969,'DAILY SHIFT','2022-12-16','2022-12-16 06:53:51','2022-12-17 06:53:51','500',0.00,0.00,'500','2022-12-16 14:17:50','500','2022-12-16 14:18:15',10,0),('1','138',257970,'DAILY SHIFT','2022-12-16','2022-12-16 14:19:41','2022-12-17 14:19:41','500',0.00,0.00,'500','2022-12-16 14:27:52','500','2022-12-16 14:28:10',10,0),('1','138',257971,'DAILY SHIFT','2022-12-16','2022-12-16 19:07:27','2022-12-17 19:07:27','500',0.00,0.00,'500','2022-12-16 20:05:34','500','2022-12-16 20:05:52',10,0),('1','138',257972,'DAILY SHIFT','2022-12-17','2022-12-17 07:13:07','2022-12-18 07:13:07','500',0.00,0.00,'500','2022-12-17 16:02:16','500','2022-12-17 16:02:32',10,0),('1','138',257973,'DAILY SHIFT','2022-12-17','2022-12-17 18:10:59','2022-12-18 18:10:59','500',0.00,0.00,'500','2022-12-17 19:24:59','500','2022-12-17 19:25:20',10,0),('1','138',257974,'DAILY SHIFT','2022-12-18','2022-12-18 07:03:59','2022-12-19 07:03:59','500',0.00,0.00,'500','2022-12-18 15:33:49','500','2022-12-18 15:34:12',10,0),('1','138',257975,'DAILY SHIFT','2022-12-18','2022-12-18 15:35:24','2022-12-19 15:35:24','500',0.00,0.00,'500','2022-12-19 01:03:10','500','2022-12-19 06:49:11',10,0),('1','138',257976,'DAILY SHIFT','2022-12-19','2022-12-19 06:49:26','2022-12-20 06:49:26','500',0.00,0.00,'500','2022-12-19 20:05:00','500','2022-12-19 20:05:17',10,0),('1','138',257977,'DAILY SHIFT','2022-12-20','2022-12-20 07:20:57','2022-12-21 07:20:57','500',0.00,0.00,'500','2022-12-20 07:40:30','500','2022-12-20 07:40:45',10,0),('1','138',257978,'DAILY SHIFT','2022-12-20','2022-12-20 07:40:59','2022-12-21 07:40:59','500',0.00,0.00,'500','2022-12-20 15:48:18','500','2022-12-20 15:48:36',10,0),('1','138',257979,'DAILY SHIFT','2022-12-20','2022-12-20 15:51:40','2022-12-21 15:51:40','500',0.00,0.00,'500','2022-12-20 15:53:12','500','2022-12-20 15:53:30',10,0),('1','138',257980,'DAILY SHIFT','2022-12-20','2022-12-20 15:57:25','2022-12-21 15:57:25','500',0.00,0.00,'500','2022-12-20 19:30:41','500','2022-12-20 19:31:05',10,0),('1','138',257981,'DAILY SHIFT','2022-12-21','2022-12-21 06:57:45','2022-12-22 06:57:45','500',0.00,0.00,'500','2022-12-21 19:25:19','500','2022-12-21 19:26:22',10,0),('1','138',257982,'DAILY SHIFT','2022-12-22','2022-12-22 06:55:44','2022-12-23 06:55:44','500',0.00,0.00,'500','2022-12-22 19:30:29','500','2022-12-22 19:30:47',10,0),('1','138',257983,'DAILY SHIFT','2022-12-23','2022-12-23 06:57:52','2022-12-24 06:57:52','500',0.00,0.00,'500','2022-12-23 11:48:52','500','2022-12-23 11:49:09',10,0),('1','138',257984,'DAILY SHIFT','2022-12-23','2022-12-23 12:40:43','2022-12-24 12:40:43','500',0.00,0.00,'500','2022-12-23 12:45:41','500','2022-12-23 12:46:00',10,0),('1','138',257985,'DAILY SHIFT','2022-12-23','2022-12-23 12:51:57','2022-12-24 12:51:57','500',0.00,0.00,'500','2022-12-23 19:14:03','500','2022-12-23 19:14:42',10,0),('1','138',257986,'DAILY SHIFT','2022-12-24','2022-12-24 07:01:49','2022-12-25 07:01:49','500',0.00,0.00,'500','2022-12-24 19:45:43','500','2022-12-24 19:46:05',10,0),('1','138',257987,'DAILY SHIFT','2022-12-25','2022-12-25 06:55:41','2022-12-26 06:55:41','500',0.00,0.00,'500','2022-12-26 07:12:57','500','2022-12-26 07:13:37',10,0),('1','138',257988,'DAILY SHIFT','2022-12-26','2022-12-26 07:14:20','2022-12-27 07:14:20','500',0.00,0.00,'500','2022-12-26 14:59:58','500','2022-12-26 15:00:16',10,0),('1','138',257989,'DAILY SHIFT','2022-12-26','2022-12-26 15:00:33','2022-12-27 15:00:33','500',0.00,0.00,'500','2022-12-26 15:04:45','500','2022-12-26 15:05:00',10,0),('1','138',257990,'DAILY SHIFT','2022-12-26','2022-12-26 15:11:13','2022-12-27 15:11:13','500',0.00,0.00,'500','2022-12-27 07:06:23','500','2022-12-27 07:10:03',10,0),('1','138',257991,'DAILY SHIFT','2022-12-27','2022-12-27 07:11:17','2022-12-28 07:11:17','500',0.00,0.00,'500','2022-12-27 21:37:29','500','2022-12-27 21:37:46',10,0),('1','138',257992,'DAILY SHIFT','2022-12-28','2022-12-28 06:58:09','2022-12-29 06:58:09','500',0.00,0.00,'500','2022-12-29 07:01:55','500','2022-12-29 07:02:11',10,0),('1','138',257993,'DAILY SHIFT','2022-12-29','2022-12-29 07:02:26','2022-12-30 07:02:26','500',0.00,0.00,'500','2022-12-29 19:36:25','500','2022-12-29 19:37:15',10,0),('1','138',257994,'DAILY SHIFT','2022-12-30','2022-12-30 06:57:13','2022-12-31 06:57:13','500',0.00,0.00,'500','2022-12-30 19:11:38','500','2022-12-30 19:12:19',10,0),('1','138',257995,'DAILY SHIFT ','2022-12-31','2022-12-31 06:43:02','2023-01-01 06:43:02','500',0.00,0.00,'500','2022-12-31 12:04:12','500','2022-12-31 12:04:44',10,0),('1','138',257996,'DAILY SHIFT','2022-12-31','2022-12-31 12:05:56','2023-01-01 12:05:56','500',0.00,0.00,'500','2022-12-31 12:12:34','500','2022-12-31 12:13:06',10,0),('1','138',257997,'DAILY SHIFT','2022-12-31','2022-12-31 12:17:25','2023-01-01 12:17:25','500',0.00,0.00,'500','2022-12-31 19:21:33','500','2022-12-31 19:22:06',10,0),('1','138',257998,'DAILY SHIFT','2023-01-01','2023-01-01 07:01:05','2023-01-02 07:01:05','500',0.00,0.00,'500','2023-01-01 07:01:52','500','2023-01-01 07:02:30',10,0),('1','138',257999,'DAILY SHIFT','2023-01-01','2023-01-01 07:04:06','2023-01-02 07:04:06','500',0.00,0.00,'500','2023-01-01 19:02:31','500','2023-01-01 19:02:59',10,0),('1','138',258000,'DAILY SHIFT','2023-01-02','2023-01-02 07:12:42','2023-01-03 07:12:42','500',0.00,0.00,'500','2023-01-02 19:12:12','500','2023-01-02 19:12:39',10,0),('1','138',258001,'DAILY SHIFT','2023-01-03','2023-01-03 06:47:51','2023-01-04 06:47:51','500',0.00,0.00,'500','2023-01-04 06:47:57','500','2023-01-04 06:48:13',10,0),('1','138',258002,'DAILY SHIFT ','2023-01-04','2023-01-04 06:48:41','2023-01-05 06:48:41','500',0.00,0.00,'500','2023-01-04 13:33:54','500','2023-01-04 13:34:11',10,0),('1','138',258003,'DAILY SHIFT','2023-01-04','2023-01-04 13:46:15','2023-01-05 13:46:15','500',0.00,0.00,'500','2023-01-04 13:51:28','500','2023-01-04 13:51:54',10,0),('1','138',258004,'DAILY SHIFT','2023-01-04','2023-01-04 13:58:18','2023-01-05 13:58:18','500',0.00,0.00,'500','2023-01-04 19:09:32','500','2023-01-04 19:09:47',10,0),('1','138',258005,'DAILY SHIFT','2023-01-05','2023-01-05 06:42:43','2023-01-06 06:42:43','500',0.00,0.00,'500','2023-01-05 06:43:59','500','2023-01-05 06:44:33',10,0),('1','138',258006,'DAILY SHIFT','2023-01-05','2023-01-05 06:45:16','2023-01-06 06:45:16','500',0.00,0.00,'500','2023-01-05 19:05:33','500','2023-01-05 19:06:02',10,0),('1','138',258007,'DAILY SHIFT','2023-01-06','2023-01-06 06:57:26','2023-01-07 06:57:26','500',0.00,0.00,'500','2023-01-06 19:09:39','500','2023-01-06 19:10:05',10,0),('1','138',258008,'DAILY SHIFT','2023-01-07','2023-01-07 06:37:21','2023-01-08 06:37:21','500',0.00,0.00,'500','2023-01-07 19:48:51','500','2023-01-07 19:49:33',10,0),('1','138',258009,'DAILY SHIFT','2023-01-08','2023-01-08 07:01:54','2023-01-09 07:01:54','500',0.00,0.00,'500','2023-01-08 17:18:48','500','2023-01-08 17:19:12',10,0),('1','138',258010,'DAILY SHIFT','2023-01-08','2023-01-08 17:20:17','2023-01-09 17:20:17','500',0.00,0.00,'500','2023-01-08 17:29:12','500','2023-01-08 17:29:54',10,0),('1','138',258011,'DAILY SHIFT','2023-01-08','2023-01-08 17:42:35','2023-01-09 17:42:35','500',0.00,0.00,'500','2023-01-08 19:13:56','500','2023-01-08 19:14:25',10,0),('1','138',258012,'DAILY SHIFT','2023-01-09','2023-01-09 06:43:03','2023-01-10 06:43:03','500',0.00,0.00,'500','2023-01-09 19:39:36','500','2023-01-09 19:40:08',10,0),('1','138',258013,'DAILY SHIFT','2023-01-10','2023-01-10 07:04:40','2023-01-11 07:04:40','500',0.00,0.00,'500','2023-01-10 19:38:17','500','2023-01-10 19:39:02',10,0),('1','138',258014,'DAILY SHIFT','2023-01-11','2023-01-11 06:42:29','2023-01-12 06:42:29','500',0.00,0.00,'500','2023-01-11 19:23:02','500','2023-01-11 19:23:21',10,0),('1','138',258015,'DAILY SHIFT','2023-01-12','2023-01-12 07:05:59','2023-01-13 07:05:59','500',0.00,0.00,'500','2023-01-12 09:49:26','500','2023-01-12 09:49:42',10,0),('1','138',258016,'DAILY SHIFT','2023-01-12','2023-01-12 09:50:31','2023-01-13 09:50:31','500',0.00,0.00,'500','2023-01-12 09:55:56','500','2023-01-12 09:56:12',10,0),('1','138',258017,'DAILY SHIFT','2023-01-12','2023-01-12 10:04:10','2023-01-13 10:04:10','500',0.00,0.00,'500','2023-01-12 19:32:47','500','2023-01-12 19:33:14',10,0),('1','138',258018,'DAILY SHIFT','2023-01-13','2023-01-13 06:40:42','2023-01-14 06:40:42','500',0.00,0.00,'500','2023-01-13 19:28:13','500','2023-01-13 19:28:41',10,0),('1','138',258019,'DAILY SHIFT','2023-01-14','2023-01-14 07:03:17','2023-01-15 07:03:17','500',0.00,0.00,'500','2023-01-14 19:19:19','500','2023-01-14 19:19:46',10,0),('1','138',258020,'DAILY SHIFT','2023-01-15','2023-01-15 06:26:51','2023-01-16 06:26:51','500',0.00,0.00,'500','2023-01-16 07:01:37','500','2023-01-16 07:01:55',10,0),('1','138',258021,'DAILY SHIFT','2023-01-16','2023-01-16 07:02:11','2023-01-17 07:02:11','500',0.00,0.00,'500','2023-01-17 07:06:10','500','2023-01-17 07:06:31',10,0),('1','138',258022,'DAILY SHIFT','2023-01-17','2023-01-17 07:06:53','2023-01-18 07:06:53','500',0.00,0.00,'500','2023-01-17 09:29:45','500','2023-01-17 09:30:01',10,0),('1','138',258023,'DAILY SHIFT','2023-01-17','2023-01-17 09:40:02','2023-01-18 09:40:02','500',0.00,0.00,'500','2023-01-17 19:30:23','500','2023-01-17 19:30:46',10,0),('1','138',258024,'DAILY SHIFT','2023-01-18','2023-01-18 07:05:41','2023-01-19 07:05:41','500',0.00,0.00,'500','2023-01-18 19:22:13','500','2023-01-18 19:23:37',10,0),('1','138',258025,'DAILY SHIFT','2023-01-19','2023-01-19 06:55:04','2023-01-20 06:55:04','500',0.00,0.00,'500','2023-01-19 19:16:21','500','2023-01-19 19:16:40',10,0),('1','138',258026,'DAILY SHIFT','2023-01-20','2023-01-20 07:01:33','2023-01-21 07:01:33','500',0.00,0.00,'500','2023-01-21 07:02:03','500','2023-01-21 07:02:20',10,0),('1','138',258027,'DAILY SHIFT','2023-01-21','2023-01-21 07:02:36','2023-01-22 07:02:36','500',0.00,0.00,'500','2023-01-21 12:24:38','500','2023-01-21 12:24:52',10,0),('1','138',258028,'DAILY SHIFT','2023-01-21','2023-01-21 13:18:46','2023-01-22 13:18:46','500',0.00,0.00,'500','2023-01-21 13:22:22','500','2023-01-21 13:23:29',10,0),('1','138',258029,'DAILY SHIFT','2023-01-21','2023-01-21 14:55:00','2023-01-22 14:55:00','500',0.00,0.00,'500','2023-01-21 19:00:19','500','2023-01-21 19:00:39',10,0),('1','138',258030,'DAILY SHIFT ','2023-01-22','2023-01-22 06:39:24','2023-01-23 06:39:24','500',0.00,0.00,'500','2023-01-22 09:40:02','500','2023-01-22 09:40:21',10,0),('1','138',258031,'DAILY SHIFT','2023-01-22','2023-01-22 10:11:41','2023-01-23 10:11:41','500',0.00,0.00,'500','2023-01-22 19:01:15','500','2023-01-22 19:01:33',10,0),('1','138',258032,'DAILY SHIFT','2023-01-23','2023-01-23 06:45:02','2023-01-24 06:45:02','500',0.00,0.00,'500','2023-01-23 19:08:59','500','2023-01-23 19:09:18',10,0),('1','138',258033,'DAILY SHIFT','2023-01-24','2023-01-24 07:16:02','2023-01-25 07:16:02','500',0.00,0.00,'500','2023-01-25 07:00:42','500','2023-01-25 07:00:57',10,0),('1','138',258034,'DAILY SHIFT','2023-01-25','2023-01-25 07:01:11','2023-01-26 07:01:11','500',0.00,0.00,'500','2023-01-25 19:25:43','500','2023-01-25 19:26:45',10,0),('1','138',258035,'DAILY SHIFT','2023-01-26','2023-01-26 07:00:29','2023-01-27 07:00:29','500',0.00,0.00,'500','2023-01-26 10:01:47','500','2023-01-26 10:02:21',10,0),('1','138',258036,'DAILY SHIFT','2023-01-26','2023-01-26 10:02:44','2023-01-27 10:02:44','500',0.00,0.00,'500','2023-01-26 10:08:10','500','2023-01-26 10:08:39',10,0),('1','138',258037,'DAILY SHIFT','2023-01-26','2023-01-26 10:42:02','2023-01-27 10:42:02','500',0.00,0.00,'500','2023-01-27 07:00:34','500','2023-01-27 07:00:54',10,0),('1','138',258038,'DAILY SHIFT','2023-01-27','2023-01-27 07:01:10','2023-01-28 07:01:10','500',0.00,0.00,'500','2023-01-27 19:14:47','500','2023-01-28 06:28:59',10,0),('1','138',258039,'DAILY SHIFT','2023-01-28','2023-01-28 06:29:40','2023-01-29 06:29:40','500',0.00,0.00,'500','2023-01-28 19:23:44','500','2023-01-28 19:24:09',10,0),('1','138',258040,'DAILY SHIFT','2023-01-29','2023-01-29 06:53:58','2023-01-30 06:53:58','500',0.00,0.00,'500','2023-01-29 19:20:29','500','2023-01-29 19:21:03',10,0),('1','138',258041,'DAILY SHIFT','2023-01-30','2023-01-30 06:45:49','2023-01-31 06:45:49','500',0.00,0.00,'500','2023-01-30 13:05:10','500','2023-01-30 13:38:27',10,0),('1','138',258042,'DAILY SHIFT','2023-01-30','2023-01-30 13:39:31','2023-01-31 13:39:31','500',0.00,0.00,'500','2023-01-30 14:38:06','500','2023-01-30 14:38:30',10,0),('1','138',258043,'DAILY SHIFT ','2023-01-30','2023-01-30 14:39:20','2023-01-31 14:39:20','500',0.00,0.00,'500','2023-01-30 20:14:23','500','2023-01-30 20:14:51',10,0),('1','138',258044,'DAILY SHIFT','2023-01-31','2023-01-31 06:51:47','2023-02-01 06:51:47','500',0.00,0.00,'500','2023-01-31 20:56:16','500','2023-01-31 21:00:46',10,0),('1','138',258045,'DAILY SHIFT','2023-02-01','2023-02-01 06:42:10','2023-02-02 06:42:10','500',0.00,0.00,'500','2023-02-02 06:56:41','500','2023-02-02 06:57:52',10,0),('1','138',258046,'DAILY SHIFT','2023-02-02','2023-02-02 06:58:38','2023-02-03 06:58:38','500',0.00,0.00,'500','2023-02-02 22:22:42','500','2023-02-02 22:24:00',10,0),('1','138',258047,'DAILY SHIFT','2023-02-03','2023-02-03 07:03:10','2023-02-04 07:03:10','500',0.00,0.00,'500','2023-02-03 21:28:05','500','2023-02-03 21:28:51',10,0),('1','138',258048,'DAILY SHIFT','2023-02-04','2023-02-04 07:16:12','2023-02-05 07:16:12','500',0.00,0.00,'500','2023-02-05 06:58:54','500','2023-02-05 06:59:21',10,0),('1','138',258049,'DAILY SHIFT','2023-02-05','2023-02-05 07:00:15','2023-02-06 07:00:15','500',0.00,0.00,'500','2023-02-06 06:56:03','500','2023-02-06 06:56:40',10,0),('1','138',258050,'DAILY SHIFT','2023-02-06','2023-02-06 07:02:48','2023-02-07 07:02:48','500',0.00,0.00,'500','2023-02-07 06:51:43','500','2023-02-07 06:52:28',10,0),('1','138',258051,'DAILY SHIFT','2023-02-07','2023-02-07 06:53:02','2023-02-08 06:53:02','500',0.00,0.00,'500','2023-02-07 13:36:53','500','2023-02-07 13:37:46',10,0),('1','138',258052,'DAILY SHIFT','2023-02-07','2023-02-07 13:49:02','2023-02-08 13:49:02','500',0.00,0.00,'500','2023-02-07 13:56:11','500','2023-02-07 13:56:30',10,0),('1','138',258053,'DAILY SHIFT','2023-02-07','2023-02-07 13:57:19','2023-02-08 13:57:19','500',0.00,0.00,'500','2023-02-08 07:07:17','500','2023-02-08 07:07:38',10,0),('1','138',258054,'DAILY SHIFT','2023-02-08','2023-02-08 07:08:47','2023-02-09 07:08:47','500',0.00,0.00,'500','2023-02-08 19:44:09','500','2023-02-08 19:44:26',10,0),('1','138',258055,'DAILY SHIFT','2023-02-09','2023-02-09 06:52:12','2023-02-10 06:52:12','500',0.00,0.00,'500','2023-02-10 07:20:03','500','2023-02-10 07:21:36',10,0),('1','138',258056,'DAILY SHIFT','2023-02-10','2023-02-10 07:21:53','2023-02-11 07:21:53','500',0.00,0.00,'500','2023-02-10 19:28:46','500','2023-02-10 19:29:12',10,0),('1','138',258057,'DAILY SHIFT','2023-02-11','2023-02-11 06:49:29','2023-02-12 06:49:29','500',0.00,0.00,'500','2023-02-11 19:45:01','500','2023-02-11 19:45:38',10,0),('1','138',258058,'DAILY SHIFT','2023-02-12','2023-02-12 06:40:47','2023-02-13 06:40:47','500',0.00,0.00,'500','2023-02-12 13:40:59','500','2023-02-12 13:41:22',10,0),('1','138',258059,'DAILY SHIFT ','2023-02-12','2023-02-12 16:27:10','2023-02-13 16:27:10','500',0.00,0.00,'500','2023-02-12 19:15:25','500','2023-02-12 19:15:51',10,0),('1','138',258060,'DAILY SHIFT ','2023-02-13','2023-02-13 06:42:52','2023-02-14 06:42:52','500',0.00,0.00,'500','2023-02-14 06:42:33','500','2023-02-14 06:43:01',10,0),('1','138',258061,'DAILY SHIFT ','2023-02-14','2023-02-14 06:43:34','2023-02-15 06:43:34','500',0.00,0.00,'500','2023-02-15 06:38:01','500','2023-02-15 06:38:23',10,0),('1','138',258062,'DAILY SHIFT ','2023-02-15','2023-02-15 06:38:49','2023-02-16 06:38:49','500',0.00,0.00,'500','2023-02-15 20:08:29','500','2023-02-15 20:08:57',10,0),('1','138',258063,'DAILY SHIFT ','2023-02-16','2023-02-16 06:46:14','2023-02-17 06:46:14','500',0.00,0.00,'500','2023-02-16 18:27:37','500','2023-02-16 18:27:57',10,0),('1','138',258064,'DAILY SHIFT ','2023-02-16','2023-02-16 18:28:57','2023-02-17 18:28:57','500',0.00,0.00,'500','2023-02-16 18:37:58','500','2023-02-16 18:38:30',10,0),('1','138',258065,'DAILY SHIFT ','2023-02-17','2023-02-17 07:05:36','2023-02-18 07:05:36','500',0.00,0.00,'500','2023-02-18 07:32:38','500','2023-02-18 07:33:08',10,0),('1','138',258066,'DAILY SHIFT ','2023-02-18','2023-02-18 07:33:37','2023-02-19 07:33:37','500',0.00,0.00,'500','2023-02-19 06:58:48','500','2023-02-19 06:59:04',10,0),('1','138',258067,'DAILY SHIFT ','2023-02-19','2023-02-19 06:59:16','2023-02-20 06:59:16','500',0.00,0.00,'500','2023-02-20 06:44:54','500','2023-02-20 06:45:19',10,0),('1','138',258068,'DAILY SHIFT ','2023-02-20','2023-02-20 06:46:09','2023-02-21 06:46:09','500',0.00,0.00,'500','2023-02-20 19:28:32','500','2023-02-20 19:28:47',10,0),('1','138',258069,'DAILY SHIFT ','2023-02-21','2023-02-21 06:50:32','2023-02-22 06:50:32','500',0.00,0.00,'500','2023-02-21 16:33:57','500','2023-02-21 16:34:25',10,0),('1','138',258070,'DAILY SHIFT ','2023-02-21','2023-02-21 16:37:32','2023-02-22 16:37:32','500',0.00,0.00,'500','2023-02-21 16:43:08','500','2023-02-21 16:43:26',10,0),('1','138',258071,'DAILY SHIFT ','2023-02-21','2023-02-21 16:47:38','2023-02-22 16:47:38','500',0.00,0.00,'500','2023-02-22 06:36:30','500','2023-02-22 06:36:54',10,0),('1','138',258072,'DAILY SHIFT ','2023-02-22','2023-02-22 06:37:52','2023-02-23 06:37:52','500',0.00,0.00,'500','2023-02-22 19:41:57','500','2023-02-22 19:45:57',10,0),('1','138',258073,'DAILY SHIFT ','2023-02-23','2023-02-23 07:07:17','2023-02-24 07:07:17','500',0.00,0.00,'500','2023-02-23 20:04:26','500','2023-02-23 20:04:44',10,0),('1','138',258074,'DAILY SHIFT ','2023-02-24','2023-02-24 06:38:18','2023-02-25 06:38:18','500',0.00,0.00,'500','2023-02-24 19:46:52','500','2023-02-24 19:47:16',10,0),('1','138',258075,'DAILY SHIFT ','2023-02-26','2023-02-26 06:59:19','2023-02-27 06:59:19','500',0.00,0.00,'500','2023-02-26 13:30:00','500','2023-02-26 13:30:20',10,0),('1','138',258076,'DAILY SHIFT ','2023-02-26','2023-02-26 14:15:08','2023-02-27 14:15:08','500',0.00,0.00,'500','2023-02-26 14:20:29','500','2023-02-26 14:20:45',10,0),('1','138',258077,'DAILY SHIFT ','2023-02-26','2023-02-26 17:13:25','2023-02-27 17:13:25','500',0.00,0.00,'500','2023-02-26 19:06:06','500','2023-02-26 19:06:35',10,0),('1','138',258078,'DAILY SHIFT ','2023-02-27','2023-02-27 06:49:40','2023-02-28 06:49:40','500',0.00,0.00,'500','2023-02-27 20:00:08','500','2023-02-27 20:00:37',10,0),('1','138',258079,'DAILY SHIFT ','2023-02-28','2023-02-28 06:49:50','2023-03-01 06:49:50','500',0.00,0.00,'500','2023-02-28 19:38:59','500','2023-02-28 19:39:18',10,0),('1','138',258080,'DAILY SHIFT ','2023-03-01','2023-03-01 06:44:18','2023-03-02 06:44:18','500',0.00,0.00,'500','2023-03-01 19:16:55','500','2023-03-01 19:23:04',10,0),('1','138',258081,'DAILY SHIFT ','2023-03-02','2023-03-02 07:02:04','2023-03-03 07:02:04','500',0.00,0.00,'500','2023-03-03 06:41:51','500','2023-03-03 06:42:18',10,0),('1','138',258082,'DAILY SHIFT ','2023-03-03','2023-03-03 06:42:47','2023-03-04 06:42:47','500',0.00,0.00,'500','2023-03-03 17:58:16','500','2023-03-03 17:59:48',10,0),('1','138',258083,'DAILY SHIFT ','2023-03-03','2023-03-03 18:11:06','2023-03-04 18:11:06','500',0.00,0.00,'500','2023-03-03 18:17:51','500','2023-03-03 18:18:09',10,0),('1','138',258084,'DAILY SHIFT ','2023-03-04','2023-03-04 07:02:50','2023-03-05 07:02:50','500',0.00,0.00,'500','2023-03-04 19:13:31','500','2023-03-04 19:14:13',10,0),('1','138',258085,'DAILY SHIFT ','2023-03-05','2023-03-05 06:30:44','2023-03-06 06:30:44','500',0.00,0.00,'500','2023-03-06 07:09:55','500','2023-03-06 07:10:10',10,0),('1','138',258086,'DAILY SHIFT ','2023-03-06','2023-03-06 07:10:27','2023-03-07 07:10:27','500',0.00,0.00,'500','2023-03-06 20:09:41','500','2023-03-06 20:10:12',10,0),('1','138',258087,'DAILY SHIFT ','2023-03-07','2023-03-07 06:37:02','2023-03-08 06:37:02','500',0.00,0.00,'500','2023-03-08 06:34:05','500','2023-03-08 06:34:22',10,0),('1','138',258088,'DAILY SHIFT ','2023-03-08','2023-03-08 06:34:48','2023-03-09 06:34:48','500',0.00,0.00,'500','2023-03-08 07:06:43','500','2023-03-08 07:07:02',10,0),('1','138',258089,'DAILY SHIFT ','2023-03-08','2023-03-08 07:11:34','2023-03-09 07:11:34','500',0.00,0.00,'500','2023-03-09 06:47:00','500','2023-03-09 06:47:25',10,0),('1','138',258090,'DAILY SHIFT ','2023-03-09','2023-03-09 06:47:53','2023-03-10 06:47:53','500',0.00,0.00,'500','2023-03-09 19:18:33','500','2023-03-09 19:21:49',10,0),('1','138',258091,'DAILY SHIFT ','2023-03-10','2023-03-10 06:56:11','2023-03-11 06:56:11','500',0.00,0.00,'500','2023-03-10 19:35:53','500','2023-03-10 19:36:12',10,0),('1','138',258092,'DAILY SHIFT ','2023-03-11','2023-03-11 07:09:05','2023-03-12 07:09:05','500',0.00,0.00,'500','2023-03-11 12:48:09','500','2023-03-11 12:48:31',10,0),('1','138',258093,'DAILY SHIFT ','2023-03-11','2023-03-11 13:32:45','2023-03-12 13:32:45','500',0.00,0.00,'500','2023-03-11 13:38:43','500','2023-03-11 13:39:06',10,0),('1','138',258094,'DAILY SHIFT ','2023-03-11','2023-03-11 16:19:42','2023-03-12 16:19:42','500',0.00,0.00,'500','2023-03-12 07:07:22','500','2023-03-12 07:08:13',10,0),('1','138',258095,'DAILY SHIFT ','2023-03-12','2023-03-12 07:10:08','2023-03-13 07:10:08','500',0.00,0.00,'500','2023-03-12 19:33:18','500','2023-03-12 19:35:41',10,0),('1','138',258096,'DAILY SHIFT ','2023-03-13','2023-03-13 07:13:43','2023-03-14 07:13:43','500',0.00,0.00,'500','2023-03-13 19:24:12','500','2023-03-13 19:55:14',10,0),('1','138',258097,'DAILY SHIFT ','2023-03-14','2023-03-14 07:06:24','2023-03-15 07:06:24','500',0.00,0.00,'500','2023-03-15 07:21:54','500','2023-03-15 07:22:10',10,0),('1','138',258098,'DAILY SHIFT ','2023-03-15','2023-03-15 07:22:26','2023-03-16 07:22:26','500',0.00,0.00,'500','2023-03-15 07:26:21','500','2023-03-15 07:26:43',10,0),('1','138',258099,'DAILY SHIFT ','2023-03-15','2023-03-15 09:49:22','2023-03-16 09:49:22','500',0.00,0.00,'500','2023-03-15 19:38:53','500','2023-03-15 19:39:35',10,0),('1','138',258100,'DAILY SHIFT ','2023-03-16','2023-03-16 06:58:40','2023-03-17 06:58:40','500',0.00,0.00,'500','2023-03-16 19:17:30','500','2023-03-16 19:21:32',10,0),('1','138',258101,'DAILY SHIFT ','2023-03-17','2023-03-17 07:05:18','2023-03-18 07:05:18','500',0.00,0.00,'500','2023-03-17 19:59:01','500','2023-03-18 07:03:03',10,0),('1','138',258102,'DAILY SHIFT ','2023-03-18','2023-03-18 07:03:29','2023-03-19 07:03:29','500',0.00,0.00,'500','2023-03-18 11:48:01','500','2023-03-18 11:49:43',10,0),('1','138',258103,'DAILY SHIFT ','2023-03-18','2023-03-18 11:52:08','2023-03-19 11:52:08','500',0.00,0.00,'500','2023-03-18 19:16:19','500','2023-03-18 19:16:38',10,0),('1','138',258104,'DAILY SHIFT ','2023-03-19','2023-03-19 07:04:29','2023-03-20 07:04:29','500',0.00,0.00,'500','2023-03-20 07:06:02','500','2023-03-20 07:06:46',10,0),('1','138',258105,'DAILY SHIFT ','2023-03-20','2023-03-20 07:07:01','2023-03-21 07:07:01','500',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4904991 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','138','765','146997',2940355,'2136','323',0.00,670.00,0.00,0.00,670.00,187600.00,0.00,0.00,0.00),('1','138','765','147075',2941521,'2136','323',670.00,1540.00,0.00,0.00,870.00,243600.00,0.00,0.00,0.00),('1','138','765','147102',2941632,'2136','323',1540.00,3064.40,0.00,0.00,1524.40,426832.00,0.00,0.00,0.00),('1','138','765','147164',2942378,'2136','323',3064.40,3722.30,0.00,0.00,657.90,184212.00,0.00,0.00,0.00),('1','138','765','147168',2942399,'2136','323',3722.30,4718.70,0.00,0.00,996.40,234322.00,0.00,0.00,0.00),('1','138','765','147189',2942724,'2136','323',4718.70,12282.40,0.00,0.00,7563.70,1691660.00,0.00,0.00,0.00),('1','138','765','147198',2942817,'2136','323',12282.40,21754.20,0.00,0.00,9471.80,2091592.00,0.00,0.00,0.00),('1','138','765','147202',2942845,'2136','323',21754.20,27578.20,0.00,0.00,5824.00,1316064.00,0.00,0.00,0.00),('1','138','765','147205',2942892,'2136','323',27578.20,28322.80,0.00,0.00,744.60,160833.60,0.00,0.00,0.00),('1','138','765','147209',2942941,'2136','323',28322.80,39829.00,0.00,0.00,11506.20,2520856.00,0.00,0.00,0.00),('1','138','765','147218',2943029,'2136','323',39829.00,46436.00,0.00,0.00,6607.00,1470248.00,0.00,0.00,0.00),('1','138','765','147228',2943123,'2136','323',46436.00,51573.30,0.00,0.00,5137.30,1145804.00,0.00,0.00,0.00),('1','138','765','147278',2943865,'2136','323',51573.30,51573.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','147295',2944058,'2136','323',51573.30,51573.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','147330',2944650,'2136','323',51573.30,59387.80,0.00,0.00,7814.50,1748092.00,0.00,0.00,0.00),('1','138','765','147428',2946553,'2136','323',59387.80,64665.60,0.00,0.00,5277.80,1052028.00,0.00,0.00,0.00),('1','138','765','147577',2949237,'2136','323',64665.60,73394.60,0.00,0.00,8729.00,1913506.00,0.00,0.00,0.00),('1','138','765','147578',2949238,'2136','323',73394.60,73394.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','147870',2954477,'2136','323',73394.60,79109.60,0.00,0.00,5715.00,1262472.00,0.00,0.00,0.00),('1','138','765','147871',2954478,'2136','323',79109.60,79282.60,0.00,0.00,173.00,48440.00,0.00,0.00,0.00),('1','138','765','147873',2954480,'2136','323',79282.60,80496.10,0.00,0.00,1213.50,262116.00,0.00,0.00,0.00),('1','138','765','147991',2956336,'2136','323',80496.10,89693.40,0.00,0.00,9197.30,2439244.00,0.00,0.00,0.00),('1','138','765','148107',2958443,'2136','323',89693.40,94156.40,0.00,0.00,4463.00,1004852.80,0.00,0.00,0.00),('1','138','765','148280',2961385,'2136','323',94156.40,98870.90,0.00,0.00,4714.50,1043644.00,0.00,0.00,0.00),('1','138','765','148281',2961386,'2136','323',98870.90,98870.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','148282',2961387,'2136','323',98870.90,100279.40,0.00,0.00,1408.50,319116.00,0.00,0.00,0.00),('1','138','765','148427',2963950,'2136','323',100279.40,106904.60,0.00,0.00,6625.20,1463209.60,0.00,0.00,0.00),('1','138','765','148430',2963976,'2136','323',106904.60,106904.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','148561',2966211,'2136','323',106904.60,112149.60,0.00,0.00,5245.00,1118328.00,0.00,0.00,0.00),('1','138','765','148799',2970127,'2136','323',112149.60,119828.40,0.00,0.00,7678.80,1699312.00,0.00,0.00,0.00),('1','138','765','148957',2973236,'2136','323',119828.40,132201.10,0.00,0.00,12372.70,2724134.80,0.00,0.00,0.00),('1','138','765','149036',2974731,'2136','323',132201.10,134929.10,0.00,0.00,2728.00,596032.00,0.00,0.00,0.00),('1','138','765','149127',2976570,'2136','323',134929.10,137079.90,0.00,0.00,2150.80,486128.00,0.00,0.00,0.00),('1','138','765','149312',2979678,'2136','323',137079.90,142790.80,0.00,0.00,5710.90,1275372.00,0.00,0.00,0.00),('1','138','765','149433',2981822,'2136','323',142790.80,150611.80,0.00,0.00,7821.00,1730232.00,0.00,0.00,0.00),('1','138','765','149582',2984296,'2136','323',150611.80,157014.30,0.00,0.00,6402.50,1421493.60,0.00,0.00,0.00),('1','138','765','149590',2984449,'2136','323',157014.30,161211.30,0.00,0.00,4197.00,929816.00,0.00,0.00,0.00),('1','138','765','149679',2985829,'2136','323',161211.30,170067.30,0.00,0.00,8856.00,1951824.00,0.00,0.00,0.00),('1','138','765','149832',2988639,'2136','323',170067.30,179482.40,0.00,0.00,9415.10,2059543.20,0.00,0.00,0.00),('1','138','765','149839',2988711,'2136','323',179482.40,183733.60,0.00,0.00,4251.20,938880.00,0.00,0.00,0.00),('1','138','765','149988',2991400,'2136','323',183733.60,193090.40,0.00,0.00,9356.80,2073248.00,0.00,0.00,0.00),('1','138','765','150112',2994176,'2136','323',193090.40,193476.90,0.00,0.00,386.50,83484.00,0.00,0.00,0.00),('1','138','765','150126',2994510,'2136','323',193476.90,202030.90,0.00,0.00,8554.00,1875344.00,0.00,0.00,0.00),('1','138','765','150129',2994581,'2136','323',202030.90,204130.90,0.00,0.00,2100.00,453600.00,0.00,0.00,0.00),('1','138','765','150386',2998614,'2136','323',204130.90,206673.90,0.00,0.00,2543.00,598504.00,0.00,0.00,0.00),('1','138','765','150562',3001990,'2136','323',206673.90,207341.80,0.00,0.00,667.90,187012.00,0.00,0.00,0.00),('1','138','765','150722',3005367,'2136','323',207341.80,208254.00,0.00,0.00,912.20,255416.00,0.00,0.00,0.00),('1','138','765','150817',3007116,'2136','323',208254.00,209525.00,0.00,0.00,1271.00,355880.00,0.00,0.00,0.00),('1','138','765','151154',3013089,'2136','323',209525.00,220880.10,0.00,0.00,11355.10,2500324.00,0.00,0.00,0.00),('1','138','765','151273',3015589,'2136','323',220880.10,233353.40,0.00,0.00,12473.30,2743573.60,0.00,0.00,0.00),('1','138','765','151420',3018369,'2136','323',233353.40,245649.10,0.00,0.00,12295.70,2694347.60,0.00,0.00,0.00),('1','138','765','151551',3020650,'2136','323',245649.10,255745.10,0.00,0.00,10096.00,2198826.00,0.00,0.00,0.00),('1','138','765','151695',3023247,'2136','323',255745.10,268608.50,0.00,0.00,12863.40,2813044.00,0.00,0.00,0.00),('1','138','765','151805',3025284,'2136','323',268608.50,274975.00,0.00,0.00,6366.50,1410108.00,0.00,0.00,0.00),('1','138','765','151949',3028065,'2136','323',274975.00,278340.00,0.00,0.00,3365.00,729816.00,0.00,0.00,0.00),('1','138','765','152011',3029314,'2136','323',278340.00,284701.50,0.00,0.00,6361.50,1402458.00,0.00,0.00,0.00),('1','138','765','152155',3031850,'2136','323',284701.50,292906.00,0.00,0.00,8204.50,1799124.00,0.00,0.00,0.00),('1','138','765','152310',3034927,'2136','323',292906.00,300849.00,0.00,0.00,7943.00,1733292.00,0.00,0.00,0.00),('1','138','765','152312',3034945,'2136','323',300849.00,304559.70,0.00,0.00,3710.70,815585.20,0.00,0.00,0.00),('1','138','765','152455',3037447,'2136','323',304559.70,319002.20,0.00,0.00,14442.50,3149037.20,0.00,0.00,0.00),('1','138','765','152587',3039841,'2136','323',319002.20,323034.70,0.00,0.00,4032.50,878383.20,0.00,0.00,0.00),('1','138','765','152592',3039882,'2136','323',323034.70,325241.60,0.00,0.00,2206.90,518257.60,0.00,0.00,0.00),('1','138','765','152595',3039914,'2136','323',325241.60,325241.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','152597',3039931,'2136','323',325241.60,328241.20,0.00,0.00,2999.60,643493.60,0.00,0.00,0.00),('1','138','765','152603',3040075,'2136','323',328241.20,330190.30,0.00,0.00,1949.10,443992.00,0.00,0.00,0.00),('1','138','765','152747',3042711,'2136','323',330190.30,340317.70,0.00,0.00,10127.40,2275820.00,0.00,0.00,0.00),('1','138','765','152872',3045027,'2136','323',340317.70,343049.30,0.00,0.00,2731.60,647640.00,0.00,0.00,0.00),('1','138','765','153075',3048473,'2136','323',343049.30,345721.80,0.00,0.00,2672.50,636496.00,0.00,0.00,0.00),('1','138','765','153255',3051681,'2136','323',345721.80,349492.00,0.00,0.00,3770.20,885668.00,0.00,0.00,0.00),('1','138','765','153382',3054034,'2136','323',349492.00,350690.10,0.00,0.00,1198.10,283836.00,0.00,0.00,0.00),('1','138','765','153463',3055644,'2136','323',350690.10,352152.60,0.00,0.00,1462.50,351960.00,0.00,0.00,0.00),('1','138','765','153640',3058811,'2136','323',352152.60,358476.30,0.00,0.00,6323.70,1457960.00,0.00,0.00,0.00),('1','138','765','153800',3061599,'2136','323',358476.30,370073.10,0.00,0.00,11596.80,2634878.00,0.00,0.00,0.00),('1','138','765','153918',3063829,'2136','323',370073.10,372381.60,0.00,0.00,2308.50,524440.00,0.00,0.00,0.00),('1','138','765','153923',3063900,'2136','323',372381.60,381049.10,0.00,0.00,8667.50,1966606.00,0.00,0.00,0.00),('1','138','765','154041',3065904,'2136','323',381049.10,389736.00,0.00,0.00,8686.90,1991018.40,0.00,0.00,0.00),('1','138','765','154176',3068105,'2136','323',389736.00,395499.50,0.00,0.00,5763.50,1297016.00,0.00,0.00,0.00),('1','138','765','154638',3076788,'2136','323',395499.50,396274.50,0.00,0.00,775.00,167400.00,0.00,0.00,0.00),('1','138','765','154728',3078631,'2136','323',396274.50,397162.20,0.00,0.00,887.70,248556.00,0.00,0.00,0.00),('1','138','765','154871',3081261,'2136','323',397162.20,399797.20,0.00,0.00,2635.00,624792.00,0.00,0.00,0.00),('1','138','765','155020',3084039,'2136','323',399797.20,416516.60,0.00,0.00,16719.40,3756649.60,0.00,0.00,0.00),('1','138','765','155131',3086164,'2136','323',416516.60,422163.80,0.00,0.00,5647.20,1291743.20,0.00,0.00,0.00),('1','138','765','155141',3086344,'2136','323',422163.80,422163.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','155301',3089315,'2136','323',422163.80,432135.10,0.00,0.00,9971.30,2257648.00,0.00,0.00,0.00),('1','138','765','155457',3092277,'2136','323',432135.10,441037.10,0.00,0.00,8902.00,2024148.00,0.00,0.00,0.00),('1','138','765','155535',3093481,'2136','323',441037.10,444768.30,0.00,0.00,3731.20,843836.00,0.00,0.00,0.00),('1','138','765','155538',3093514,'2136','323',444768.30,444768.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','155569',3094051,'2136','323',444768.30,444768.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','155644',3095697,'2136','323',444768.30,446903.80,0.00,0.00,2135.50,499212.00,0.00,0.00,0.00),('1','138','765','155781',3098141,'2136','323',446903.80,459520.80,0.00,0.00,12617.00,2855924.00,0.00,0.00,0.00),('1','138','765','155887',3099977,'2136','323',459520.80,467375.90,0.00,0.00,7855.10,1789662.40,0.00,0.00,0.00),('1','138','765','155891',3100044,'2136','323',467375.90,467375.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','155929',3100759,'2136','323',467375.90,468827.40,0.00,0.00,1451.50,336140.00,0.00,0.00,0.00),('1','138','765','156073',3103332,'2136','323',468827.40,481652.80,0.00,0.00,12825.40,2902264.00,0.00,0.00,0.00),('1','138','765','156194',3105538,'2136','323',481652.80,488268.30,0.00,0.00,6615.50,1515508.00,0.00,0.00,0.00),('1','138','765','156291',3107154,'2136','323',488268.30,489928.30,0.00,0.00,1660.00,371840.00,0.00,0.00,0.00),('1','138','765','156293',3107156,'2136','323',489928.30,489928.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','156422',3109624,'2136','323',489928.30,502718.70,0.00,0.00,12790.40,2910292.00,0.00,0.00,0.00),('1','138','765','156512',3111236,'2136','323',502718.70,506276.70,0.00,0.00,3558.00,782760.00,0.00,0.00,0.00),('1','138','765','156514',3111255,'2136','323',506276.70,512549.70,0.00,0.00,6273.00,1405430.80,0.00,0.00,0.00),('1','138','765','156589',3112820,'2136','323',512549.70,512549.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','157073',3121669,'2136','323',512549.70,514291.50,0.00,0.00,1741.80,408128.00,0.00,0.00,0.00),('1','138','765','157266',3125098,'2136','323',514291.50,530489.40,0.00,0.00,16197.90,3635665.60,0.00,0.00,0.00),('1','138','765','157428',3127784,'2136','323',530489.40,535817.90,0.00,0.00,5328.50,1219988.00,0.00,0.00,0.00),('1','138','765','157429',3127785,'2136','323',535817.90,535817.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','157442',3127957,'2136','323',535817.90,537204.10,0.00,0.00,1386.20,319188.80,0.00,0.00,0.00),('1','138','765','157646',3131606,'2136','323',537204.10,555874.80,0.00,0.00,18670.70,4171420.00,0.00,0.00,0.00),('1','138','765','157748',3133506,'2136','323',555874.80,558471.40,0.00,0.00,2596.60,584332.00,0.00,0.00,0.00),('1','138','765','157750',3133523,'2136','323',558471.40,558471.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','157813',3134646,'2136','323',558471.40,567351.80,0.00,0.00,8880.40,2001709.60,0.00,0.00,0.00),('1','138','765','157937',3137081,'2136','323',567351.80,581103.80,0.00,0.00,13752.00,3079372.80,0.00,0.00,0.00),('1','138','765','158039',3138902,'2136','323',581103.80,581103.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','158084',3139694,'2136','323',581103.80,598892.60,0.00,0.00,17788.80,4007679.20,0.00,0.00,0.00),('1','138','765','158254',3142916,'2136','323',598892.60,601406.30,0.00,0.00,2513.70,636636.00,0.00,0.00,0.00),('1','138','765','158413',3146069,'2136','323',601406.30,603786.30,0.00,0.00,2380.00,666400.00,0.00,0.00,0.00),('1','138','765','158418',3146098,'2136','323',603786.30,603786.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','158563',3148636,'2136','323',603786.30,605336.70,0.00,0.00,1550.40,434112.00,0.00,0.00,0.00),('1','138','765','158739',3151838,'2136','323',605336.70,608618.70,0.00,0.00,3282.00,918960.00,0.00,0.00,0.00),('1','138','765','158797',3152682,'2136','323',608618.70,609344.40,0.00,0.00,725.70,203196.00,0.00,0.00,0.00),('1','138','765','159104',3158276,'2136','323',609344.40,609344.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','159107',3158280,'2136','323',609344.40,610283.90,0.00,0.00,939.50,278092.00,0.00,0.00,0.00),('1','138','765','159264',3161328,'2136','323',610283.90,610283.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','159267',3161331,'2136','323',610283.90,611543.90,0.00,0.00,1260.00,372960.00,0.00,0.00,0.00),('1','138','765','159452',3164089,'2136','323',611543.90,612426.40,0.00,0.00,882.50,261220.00,0.00,0.00,0.00),('1','138','765','159623',3167262,'2136','323',612426.40,613115.40,0.00,0.00,689.00,209456.00,0.00,0.00,0.00),('1','138','765','159640',3167479,'2136','323',613115.40,613308.40,0.00,0.00,193.00,57128.00,0.00,0.00,0.00),('1','138','765','159721',3168936,'2136','323',613308.40,614576.90,0.00,0.00,1268.50,301708.00,0.00,0.00,0.00),('1','138','765','159722',3168937,'2136','323',614576.90,614576.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','159726',3168972,'2136','323',614576.90,623777.90,0.00,0.00,9201.00,2175852.00,0.00,0.00,0.00),('1','138','765','159915',3172303,'2136','323',623777.90,637090.60,0.00,0.00,13312.70,3097547.20,0.00,0.00,0.00),('1','138','765','159917',3172334,'2136','323',637090.60,637090.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','160125',3176281,'2136','323',637090.60,647298.00,0.00,0.00,10207.40,2380421.60,0.00,0.00,0.00),('1','138','765','160294',3179299,'2136','323',647298.00,659649.70,0.00,0.00,12351.70,2890533.60,0.00,0.00,0.00),('1','138','765','160297',3179321,'2136','323',659649.70,659649.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','160380',3180762,'2136','323',659649.70,659649.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','160455',3182101,'2136','323',659649.70,677032.80,0.00,0.00,17383.10,4187868.00,0.00,0.00,0.00),('1','138','765','160587',3184563,'2136','323',677032.80,681843.70,0.00,0.00,4810.90,1267449.60,0.00,0.00,0.00),('1','138','765','160640',3185266,'2136','323',681843.70,682250.20,0.00,0.00,406.50,104064.00,0.00,0.00,0.00),('1','138','765','160643',3185301,'2136','323',682250.20,682250.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','160744',3187053,'2136','323',682250.20,691381.50,0.00,0.00,9131.30,2371571.20,0.00,0.00,0.00),('1','138','765','160881',3189417,'2136','323',691381.50,698104.30,0.00,0.00,6722.80,1749452.80,0.00,0.00,0.00),('1','138','765','161084',3193120,'2136','323',698104.30,704852.80,0.00,0.00,6748.50,1725696.00,0.00,0.00,0.00),('1','138','765','161086',3193122,'2136','323',704852.80,704852.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','161263',3196480,'2136','323',704852.80,709306.80,0.00,0.00,4454.00,1179008.00,0.00,0.00,0.00),('1','138','765','161451',3199444,'2136','323',709306.80,714399.30,0.00,0.00,5092.50,1343680.00,0.00,0.00,0.00),('1','138','765','161656',3202921,'2136','323',714399.30,718175.90,0.00,0.00,3776.60,1011712.00,0.00,0.00,0.00),('1','138','765','161865',3206457,'2136','323',718175.90,724114.80,0.00,0.00,5938.90,1562118.40,0.00,0.00,0.00),('1','138','765','161985',3208751,'2136','323',724114.80,727286.20,0.00,0.00,3171.40,825747.20,0.00,0.00,0.00),('1','138','765','162145',3211360,'2136','323',727286.20,730355.20,0.00,0.00,3069.00,804792.00,0.00,0.00,0.00),('1','138','765','162149',3211402,'2136','323',730355.20,730355.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','162154',3211493,'2136','323',730355.20,730355.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','162232',3212964,'2136','323',730355.20,733611.10,0.00,0.00,3255.90,846129.60,0.00,0.00,0.00),('1','138','765','162449',3216606,'2136','323',733611.10,740762.10,0.00,0.00,7151.00,1850696.00,0.00,0.00,0.00),('1','138','765','162639',3219693,'2136','323',740762.10,746751.90,0.00,0.00,5989.80,1567219.20,0.00,0.00,0.00),('1','138','765','162800',3222646,'2136','323',746751.90,751180.90,0.00,0.00,4429.00,1147894.40,0.00,0.00,0.00),('1','138','765','162971',3225674,'2136','323',751180.90,752959.10,0.00,0.00,1778.20,460787.20,0.00,0.00,0.00),('1','138','765','163009',3226315,'2136','323',752959.10,754903.30,0.00,0.00,1944.20,505971.20,0.00,0.00,0.00),('1','138','765','163200',3229702,'2136','323',754903.30,759198.20,0.00,0.00,4294.90,1117864.00,0.00,0.00,0.00),('1','138','765','163370',3232709,'2136','323',759198.20,764349.50,0.00,0.00,5151.30,1332851.20,0.00,0.00,0.00),('1','138','765','163549',3235989,'2136','323',764349.50,769603.20,0.00,0.00,5253.70,1358172.80,0.00,0.00,0.00),('1','138','765','163740',3239449,'2136','323',769603.20,774658.90,0.00,0.00,5055.70,1315316.80,0.00,0.00,0.00),('1','138','765','163896',3242230,'2136','323',774658.90,777565.10,0.00,0.00,2906.20,807848.80,0.00,0.00,0.00),('1','138','765','164076',3245520,'2136','323',777565.10,780037.10,0.00,0.00,2472.00,686202.00,0.00,0.00,0.00),('1','138','765','164254',3248718,'2136','323',780037.10,782260.40,0.00,0.00,2223.30,615259.20,0.00,0.00,0.00),('1','138','765','164436',3252191,'2136','323',782260.40,785475.70,0.00,0.00,3215.30,886936.40,0.00,0.00,0.00),('1','138','765','164597',3254986,'2136','323',785475.70,788558.60,0.00,0.00,3082.90,851791.60,0.00,0.00,0.00),('1','138','765','164744',3257765,'2136','323',788558.60,795543.20,0.00,0.00,6984.60,1868538.40,0.00,0.00,0.00),('1','138','765','164883',3260094,'2136','323',795543.20,797400.50,0.00,0.00,1857.30,503635.20,0.00,0.00,0.00),('1','138','765','164961',3261533,'2136','323',797400.50,801431.50,0.00,0.00,4031.00,1084448.00,0.00,0.00,0.00),('1','138','765','165125',3264421,'2136','323',801431.50,804364.00,0.00,0.00,2932.50,867690.00,0.00,0.00,0.00),('1','138','765','165300',3267465,'2136','323',804364.00,810243.20,0.00,0.00,5879.20,1645316.80,0.00,0.00,0.00),('1','138','765','165439',3269878,'2136','323',810243.20,818576.00,0.00,0.00,8332.80,2327812.80,0.00,0.00,0.00),('1','138','765','165545',3271587,'2136','323',818576.00,820378.30,0.00,0.00,1802.30,509830.40,0.00,0.00,0.00),('1','138','765','165554',3271724,'2136','323',820378.30,820378.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','165560',3271825,'2136','323',820378.30,820378.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','165611',3272823,'2136','323',820378.30,824580.20,0.00,0.00,4201.90,1168842.40,0.00,0.00,0.00),('1','138','765','165795',3276340,'2136','323',824580.20,832269.90,0.00,0.00,7689.70,2147660.80,0.00,0.00,0.00),('1','138','765','165923',3278645,'2136','323',832269.90,840247.90,0.00,0.00,7978.00,2227424.00,0.00,0.00,0.00),('1','138','765','166139',3282447,'2136','323',840247.90,842623.20,0.00,0.00,2375.30,684291.20,0.00,0.00,0.00),('1','138','765','166170',3282825,'2136','323',842623.20,843084.20,0.00,0.00,461.00,129080.00,0.00,0.00,0.00),('1','138','765','166310',3285512,'2136','323',843084.20,844647.70,0.00,0.00,1563.50,452972.00,0.00,0.00,0.00),('1','138','765','166490',3288881,'2136','323',844647.70,847687.10,0.00,0.00,3039.40,867421.60,0.00,0.00,0.00),('1','138','765','166715',3292593,'2136','323',847687.10,854758.10,0.00,0.00,7071.00,1992082.40,0.00,0.00,0.00),('1','138','765','166890',3295620,'2136','323',854758.10,859749.30,0.00,0.00,4991.20,1416956.80,0.00,0.00,0.00),('1','138','765','167045',3298531,'2136','323',859749.30,865686.20,0.00,0.00,5936.90,1671538.40,0.00,0.00,0.00),('1','138','765','167188',3300985,'2136','323',865686.20,873197.50,0.00,0.00,7511.30,2115108.00,0.00,0.00,0.00),('1','138','765','167390',3304466,'2136','323',873197.50,881862.50,0.00,0.00,8665.00,2436580.00,0.00,0.00,0.00),('1','138','765','167542',3307528,'2136','323',881862.50,888136.20,0.00,0.00,6273.70,1758177.60,0.00,0.00,0.00),('1','138','765','167570',3307891,'2136','323',888136.20,890385.50,0.00,0.00,2249.30,629644.00,0.00,0.00,0.00),('1','138','765','167732',3310750,'2136','323',890385.50,898866.40,0.00,0.00,8480.90,2370657.60,0.00,0.00,0.00),('1','138','765','167912',3313843,'2136','323',898866.40,908108.90,0.00,0.00,9242.50,2569772.00,0.00,0.00,0.00),('1','138','765','168036',3316194,'2136','323',908108.90,910227.10,0.00,0.00,2118.20,582902.40,0.00,0.00,0.00),('1','138','765','168046',3316369,'2136','323',910227.10,910227.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','168052',3316513,'2136','323',910227.10,910227.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','168054',3316540,'2136','323',910227.10,910227.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','168111',3317682,'2136','323',910227.10,914492.90,0.00,0.00,4265.80,1199304.00,0.00,0.00,0.00),('1','138','765','168285',3320894,'2136','323',914492.90,924465.40,0.00,0.00,9972.50,2767724.00,0.00,0.00,0.00),('1','138','765','168410',3323161,'2136','323',924465.40,932695.50,0.00,0.00,8230.10,2297686.40,0.00,0.00,0.00),('1','138','765','168468',3324098,'2136','323',932695.50,945151.90,0.00,0.00,12456.40,3467097.60,0.00,0.00,0.00),('1','138','765','168735',3328944,'2136','323',945151.90,955264.20,0.00,0.00,10112.30,2831043.20,0.00,0.00,0.00),('1','138','765','168940',3332462,'2136','323',955264.20,971068.40,0.00,0.00,15804.20,4421844.80,0.00,0.00,0.00),('1','138','765','169085',3335132,'2136','323',971068.40,974818.80,0.00,0.00,3750.40,1057201.60,0.00,0.00,0.00),('1','138','765','169122',3335740,'2136','323',974818.80,982437.50,0.00,0.00,7618.70,2112628.80,0.00,0.00,0.00),('1','138','765','169274',3338639,'2136','323',982437.50,997531.10,0.00,0.00,15093.60,4367870.40,0.00,0.00,0.00),('1','138','765','169399',3341265,'2136','323',997531.10,997531.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','169403',3341338,'2136','323',997531.10,997531.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','169408',3341455,'2136','323',997531.10,997531.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','169411',3341479,'2136','323',997531.10,997531.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','169413',3341499,'2136','323',997531.10,997531.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','169414',3341500,'2136','323',997531.10,997531.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','169416',3341525,'2136','323',997531.10,997531.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','169420',3341593,'2136','323',997531.10,997531.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','169443',3342032,'2136','323',997531.10,1007254.10,0.00,0.00,9723.00,2830608.00,0.00,0.00,0.00),('1','138','765','169567',3344579,'2136','323',1007254.10,1014776.00,0.00,0.00,7521.90,2203623.60,0.00,0.00,0.00),('1','138','765','169692',3346864,'2136','323',1014776.00,1022261.20,0.00,0.00,7485.20,2189250.80,0.00,0.00,0.00),('1','138','765','169695',3346889,'2136','323',1022261.20,1022261.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','169766',3348136,'2136','323',1022261.20,1025089.60,0.00,0.00,2828.40,828207.60,0.00,0.00,0.00),('1','138','765','169923',3351148,'2136','323',1025089.60,1031117.40,0.00,0.00,6027.80,1758272.40,0.00,0.00,0.00),('1','138','765','170122',3354612,'2136','323',1031117.40,1037339.60,0.00,0.00,6222.20,1827129.20,0.00,0.00,0.00),('1','138','765','170300',3357725,'2136','323',1037339.60,1041382.10,0.00,0.00,4042.50,1185942.00,0.00,0.00,0.00),('1','138','765','170305',3357778,'2136','323',1041382.10,1041382.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','170481',3360820,'2136','323',1041382.10,1051389.80,0.00,0.00,10007.70,2912501.60,0.00,0.00,0.00),('1','138','765','170650',3363992,'2136','323',1051389.80,1061268.50,0.00,0.00,9878.70,2864228.80,0.00,0.00,0.00),('1','138','765','170732',3365322,'2136','323',1061268.50,1061268.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','170733',3365323,'2136','323',1061268.50,1061268.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','170734',3365324,'2136','323',1061268.50,1061268.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','170807',3366748,'2136','323',1061268.50,1066206.00,0.00,0.00,4937.50,1438666.00,0.00,0.00,0.00),('1','138','765','170977',3369616,'2136','323',1066206.00,1074892.60,0.00,0.00,8686.60,2538879.60,0.00,0.00,0.00),('1','138','765','171208',3374060,'2136','323',1074892.60,1083679.70,0.00,0.00,8787.10,2574043.60,0.00,0.00,0.00),('1','138','765','171287',3375523,'2136','323',1083679.70,1085748.10,0.00,0.00,2068.40,606352.80,0.00,0.00,0.00),('1','138','765','171291',3375592,'2136','323',1085748.10,1085748.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','171370',3377003,'2136','323',1085748.10,1089460.80,0.00,0.00,3712.70,1088193.60,0.00,0.00,0.00),('1','138','765','171583',3380842,'2136','323',1089460.80,1096512.10,0.00,0.00,7051.30,2070042.00,0.00,0.00,0.00),('1','138','765','171762',3384036,'2136','323',1096512.10,1105799.90,0.00,0.00,9287.80,2716936.00,0.00,0.00,0.00),('1','138','765','171871',3386014,'2136','323',1105799.90,1110544.60,0.00,0.00,4744.70,1395972.00,0.00,0.00,0.00),('1','138','765','171872',3386015,'2136','323',1110544.60,1110544.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','171948',3387338,'2136','323',1110544.60,1118828.70,0.00,0.00,8284.10,2419447.20,0.00,0.00,0.00),('1','138','765','172077',3389736,'2136','323',1118828.70,1125610.90,0.00,0.00,6782.20,1999906.40,0.00,0.00,0.00),('1','138','765','172222',3392317,'2136','323',1125610.90,1135282.30,0.00,0.00,9671.40,2824076.80,0.00,0.00,0.00),('1','138','765','172225',3392390,'2136','323',1135282.30,1135282.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','172262',3393046,'2136','323',1135282.30,1138067.50,0.00,0.00,2785.20,816952.00,0.00,0.00,0.00),('1','138','765','172474',3396914,'2136','323',1138067.50,1148429.60,0.00,0.00,10362.10,3022314.00,0.00,0.00,0.00),('1','138','765','172692',3400936,'2136','323',1148429.60,1158694.70,0.00,0.00,10265.10,2991810.80,0.00,0.00,0.00),('1','138','765','172726',3401422,'2136','323',1158694.70,1160175.00,0.00,0.00,1480.30,432667.60,0.00,0.00,0.00),('1','138','765','172729',3401443,'2136','323',1160175.00,1160175.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','172866',3404036,'2136','323',1160175.00,1167290.30,0.00,0.00,7115.30,2079064.80,0.00,0.00,0.00),('1','138','765','173058',3407659,'2136','323',1167290.30,1178756.70,0.00,0.00,11466.40,3351657.20,0.00,0.00,0.00),('1','138','765','173217',3410997,'2136','323',1178756.70,1184825.50,0.00,0.00,6068.80,1786994.00,0.00,0.00,0.00),('1','138','765','173219',3411026,'2136','323',1184825.50,1184825.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','173220',3411027,'2136','323',1184825.50,1190994.20,0.00,0.00,6168.70,1790725.20,0.00,0.00,0.00),('1','138','765','173388',3413940,'2136','323',1190994.20,1199899.50,0.00,0.00,8905.30,2601635.60,0.00,0.00,0.00),('1','138','765','173596',3417784,'2136','323',1199899.50,1209699.20,0.00,0.00,9799.70,2852572.00,0.00,0.00,0.00),('1','138','765','173597',3417785,'2136','323',1209699.20,1209699.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','173599',3417799,'2136','323',1209699.20,1212672.80,0.00,0.00,2973.60,876680.00,0.00,0.00,0.00),('1','138','765','173755',3420711,'2136','323',1212672.80,1224571.00,0.00,0.00,11898.20,3475044.40,0.00,0.00,0.00),('1','138','765','173931',3423925,'2136','323',1224571.00,1233515.30,0.00,0.00,8944.30,2625024.00,0.00,0.00,0.00),('1','138','765','173987',3424882,'2136','323',1233515.30,1234474.90,0.00,0.00,959.60,281835.60,0.00,0.00,0.00),('1','138','765','173988',3424883,'2136','323',1234474.90,1234474.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','174122',3427301,'2136','323',1234474.90,1242124.20,0.00,0.00,7649.30,2229064.00,0.00,0.00,0.00),('1','138','765','174311',3430776,'2136','323',1242124.20,1252702.20,0.00,0.00,10578.00,3083634.00,0.00,0.00,0.00),('1','138','765','174446',3432886,'2136','323',1252702.20,1259022.60,0.00,0.00,6320.40,1852228.00,0.00,0.00,0.00),('1','138','765','174448',3432921,'2136','323',1259022.60,1259022.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','174482',3433546,'2136','323',1259022.60,1263452.50,0.00,0.00,4429.90,1288140.00,0.00,0.00,0.00),('1','138','765','174647',3436488,'2136','323',1263452.50,1272210.10,0.00,0.00,8757.60,2566700.00,0.00,0.00,0.00),('1','138','765','174845',3440183,'2136','323',1272210.10,1283539.40,0.00,0.00,11329.30,3320642.00,0.00,0.00,0.00),('1','138','765','174865',3440464,'2136','323',1283539.40,1283539.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','175227',3447341,'2136','323',1283539.40,1287106.80,0.00,0.00,3567.40,1146506.00,0.00,0.00,0.00),('1','138','765','175399',3450539,'2136','323',1287106.80,1290211.00,0.00,0.00,3104.20,1006123.20,0.00,0.00,0.00),('1','138','765','175586',3453893,'2136','323',1290211.00,1295682.10,0.00,0.00,5471.10,1733360.00,0.00,0.00,0.00),('1','138','765','175756',3457038,'2136','323',1295682.10,1308291.10,0.00,0.00,12609.00,3949272.00,0.00,0.00,0.00),('1','138','765','175759',3457063,'2136','323',1308291.10,1308291.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','175920',3459798,'2136','323',1308291.10,1319860.80,0.00,0.00,11569.70,3647618.40,0.00,0.00,0.00),('1','138','765','176141',3463883,'2136','323',1319860.80,1327752.50,0.00,0.00,7891.70,2510929.60,0.00,0.00,0.00),('1','138','765','176325',3467320,'2136','323',1327752.50,1333121.10,0.00,0.00,5368.60,1690325.60,0.00,0.00,0.00),('1','138','765','176327',3467322,'2136','323',1333121.10,1333157.10,0.00,0.00,36.00,11232.00,0.00,0.00,0.00),('1','138','765','176529',3471236,'2136','323',1333157.10,1339674.80,0.00,0.00,6517.70,2063727.60,0.00,0.00,0.00),('1','138','765','176754',3475262,'2136','323',1339674.80,1350926.00,0.00,0.00,11251.20,3542978.40,0.00,0.00,0.00),('1','138','765','176946',3478914,'2136','323',1350926.00,1357923.30,0.00,0.00,6997.30,2207839.20,0.00,0.00,0.00),('1','138','765','176949',3478940,'2136','323',1357923.30,1357923.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','177213',3484032,'2136','323',1357923.30,1367668.50,0.00,0.00,9745.20,3072469.60,0.00,0.00,0.00),('1','138','765','177403',3487854,'2136','323',1367668.50,1375166.80,0.00,0.00,7498.30,2360216.80,0.00,0.00,0.00),('1','138','765','177609',3492078,'2136','323',1375166.80,1380977.10,0.00,0.00,5810.30,1847757.60,0.00,0.00,0.00),('1','138','765','177737',3494337,'2136','323',1380977.10,1382735.00,0.00,0.00,1757.90,556106.40,0.00,0.00,0.00),('1','138','765','177739',3494354,'2136','323',1382735.00,1382735.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','177857',3496482,'2136','323',1382735.00,1386606.80,0.00,0.00,3871.80,1223232.00,0.00,0.00,0.00),('1','138','765','178050',3500319,'2136','323',1386606.80,1393566.30,0.00,0.00,6959.50,2194674.40,0.00,0.00,0.00),('1','138','765','178269',3504327,'2136','323',1393566.30,1400432.40,0.00,0.00,6866.10,2169872.80,0.00,0.00,0.00),('1','138','765','178466',3507961,'2136','323',1400432.40,1406778.90,0.00,0.00,6346.50,2009383.20,0.00,0.00,0.00),('1','138','765','178558',3509570,'2136','323',1406778.90,1407551.50,0.00,0.00,772.60,246312.00,0.00,0.00,0.00),('1','138','765','178562',3509641,'2136','323',1407551.50,1407551.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','178700',3512263,'2136','323',1407551.50,1409427.40,0.00,0.00,1875.90,625053.80,0.00,0.00,0.00),('1','138','765','178866',3515319,'2136','323',1409427.40,1415650.00,0.00,0.00,6222.60,2025245.00,0.00,0.00,0.00),('1','138','765','178928',3516210,'2136','323',1415650.00,1418579.14,0.00,0.00,2929.14,945765.40,0.00,0.00,0.00),('1','138','765','179111',3519709,'2136','323',1418579.14,1420512.94,0.00,0.00,1933.80,634416.00,0.00,0.00,0.00),('1','138','765','179350',3524461,'2136','323',1420512.94,1424654.54,0.00,0.00,4141.60,1358922.20,0.00,0.00,0.00),('1','138','765','179378',3524763,'2136','323',1424654.54,1431190.13,0.00,0.00,6535.59,2123034.00,0.00,0.00,0.00),('1','138','765','179574',3528483,'2136','323',1431190.13,1432287.63,0.00,0.00,1097.50,358525.00,0.00,0.00,0.00),('1','138','765','179609',3529039,'2136','323',1432287.63,1432287.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','179621',3529309,'2136','323',1432287.63,1436116.20,0.00,0.00,3828.57,1256111.20,0.00,0.00,0.00),('1','138','765','179774',3532473,'2136','323',1436116.20,1441352.42,0.00,0.00,5236.22,1719479.60,0.00,0.00,0.00),('1','138','765','180005',3536565,'2136','323',1441352.42,1448559.39,0.00,0.00,7206.97,2375222.60,0.00,0.00,0.00),('1','138','765','180178',3539985,'2136','323',1448559.39,1456556.20,0.00,0.00,7996.81,2605037.60,0.00,0.00,0.00),('1','138','765','180299',3542204,'2136','323',1456556.20,1456556.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','180338',3542806,'2136','323',1456556.20,1466719.70,0.00,0.00,10163.50,3289672.00,0.00,0.00,0.00),('1','138','765','180548',3546695,'2136','323',1466719.70,1473884.68,0.00,0.00,7164.98,2315369.60,0.00,0.00,0.00),('1','138','765','180738',3550064,'2136','323',1473884.68,1477943.70,0.00,0.00,4059.02,1330823.60,0.00,0.00,0.00),('1','138','765','180958',3554393,'2136','323',1477943.70,1480779.80,0.00,0.00,2836.10,923697.00,0.00,0.00,0.00),('1','138','765','181021',3555478,'2136','323',1480779.80,1480779.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','181133',3557667,'2136','323',1480779.80,1490321.61,0.00,0.00,9541.81,3067153.60,0.00,0.00,0.00),('1','138','765','181335',3561712,'2136','323',1490321.61,1502847.97,0.00,0.00,12526.36,4014885.60,0.00,0.00,0.00),('1','138','765','181525',3565089,'2136','323',1502847.97,1505400.44,0.00,0.00,2552.47,824253.20,0.00,0.00,0.00),('1','138','765','181572',3565725,'2136','323',1505400.44,1505400.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','181589',3566060,'2136','323',1505400.44,1510912.44,0.00,0.00,5512.00,1774456.00,0.00,0.00,0.00),('1','138','765','181709',3568180,'2136','323',1510912.44,1521583.66,0.00,0.00,10671.22,3427688.00,0.00,0.00,0.00),('1','138','765','181906',3571580,'2136','323',1521583.66,1529960.90,0.00,0.00,8377.24,2681890.40,0.00,0.00,0.00),('1','138','765','182065',3574725,'2136','323',1529960.90,1529960.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','182068',3574782,'2136','323',1529960.90,1541126.44,0.00,0.00,11165.54,3588214.00,0.00,0.00,0.00),('1','138','765','182310',3578900,'2136','323',1541126.44,1554378.53,0.00,0.00,13252.09,4243202.80,0.00,0.00,0.00),('1','138','765','182481',3582150,'2136','323',1554378.53,1554378.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','182500',3582362,'2136','323',1554378.53,1565582.81,0.00,0.00,11204.28,3584816.80,0.00,0.00,0.00),('1','138','765','182688',3585877,'2136','323',1565582.81,1578727.21,0.00,0.00,13144.40,4219528.00,0.00,0.00,0.00),('1','138','765','183091',3593496,'2136','323',1578727.21,1578727.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','183096',3593516,'2136','323',1578727.21,1589644.41,0.00,0.00,10917.20,3511544.00,0.00,0.00,0.00),('1','138','765','183148',3594345,'2136','323',1589644.41,1598241.31,0.00,0.00,8596.90,2757356.00,0.00,0.00,0.00),('1','138','765','183150',3594396,'2136','323',1598241.31,1598241.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','183207',3595522,'2136','323',1598241.31,1609556.23,0.00,0.00,11314.92,3640231.20,0.00,0.00,0.00),('1','138','765','183427',3599408,'2136','323',1609556.23,1618964.23,0.00,0.00,9408.00,3022865.60,0.00,0.00,0.00),('1','138','765','183730',3604839,'2136','323',1618964.23,1622612.12,0.00,0.00,3647.89,1177692.40,0.00,0.00,0.00),('1','138','765','183826',3606751,'2136','323',1622612.12,1622612.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','183849',3607177,'2136','323',1622612.12,1622612.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','183894',3607963,'2136','323',1622612.12,1623933.32,0.00,0.00,1321.20,428620.00,0.00,0.00,0.00),('1','138','765','183905',3608123,'2136','323',1623933.32,1635889.01,0.00,0.00,11955.69,3832769.20,0.00,0.00,0.00),('1','138','765','184270',3614594,'2136','323',1635889.01,1635889.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','184292',3614931,'2136','323',1635889.01,1647212.11,0.00,0.00,11323.10,3624962.80,0.00,0.00,0.00),('1','138','765','184297',3614987,'2136','323',1647212.11,1647212.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','184307',3615096,'2136','323',1647212.11,1657809.84,0.00,0.00,10597.73,3398344.80,0.00,0.00,0.00),('1','138','765','184485',3618273,'2136','323',1657809.84,1671856.32,0.00,0.00,14046.48,4505916.80,0.00,0.00,0.00),('1','138','765','184664',3621875,'2136','323',1671856.32,1671856.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','184687',3622193,'2136','323',1671856.32,1691650.89,0.00,0.00,19794.57,6337984.40,0.00,0.00,0.00),('1','138','765','184883',3625686,'2136','323',1691650.89,1696561.85,0.00,0.00,4910.96,1577393.60,0.00,0.00,0.00),('1','138','765','185003',3627631,'2136','323',1696561.85,1696561.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','185015',3627862,'2136','323',1696561.85,1701702.60,0.00,0.00,5140.75,1648748.00,0.00,0.00,0.00),('1','138','765','185107',3629490,'2136','323',1701702.60,1715660.20,0.00,0.00,13957.60,4473644.00,0.00,0.00,0.00),('1','138','765','185259',3631893,'2136','323',1715660.20,1720848.11,0.00,0.00,5187.91,1650375.60,0.00,0.00,0.00),('1','138','765','185325',3633020,'2136','323',1720848.11,1726529.01,0.00,0.00,5680.90,1834170.40,0.00,0.00,0.00),('1','138','765','185468',3635785,'2136','323',1726529.01,1739408.68,0.00,0.00,12879.67,4196102.80,0.00,0.00,0.00),('1','138','765','185677',3639533,'2136','323',1739408.68,1745587.69,0.00,0.00,6179.01,2023377.60,0.00,0.00,0.00),('1','138','765','185777',3641149,'2136','323',1745587.69,1745587.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','185870',3643040,'2136','323',1745587.69,1754839.32,0.00,0.00,9251.63,3030496.16,0.00,0.00,0.00),('1','138','765','186095',3647104,'2136','323',1754839.32,1769518.51,0.00,0.00,14679.19,4803950.80,0.00,0.00,0.00),('1','138','765','186345',3651070,'2136','323',1769518.51,1770208.11,0.00,0.00,689.60,226188.80,0.00,0.00,0.00),('1','138','765','186359',3651298,'2136','323',1770208.11,1770208.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','186615',3655808,'2136','323',1770208.11,1782394.65,0.00,0.00,12186.54,3976244.00,0.00,0.00,0.00),('1','138','765','186751',3658145,'2136','323',1782394.65,1792898.11,0.00,0.00,10503.46,3433540.40,0.00,0.00,0.00),('1','138','765','186903',3660780,'2136','323',1792898.11,1792898.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','186980',3661903,'2136','323',1792898.11,1803379.94,0.00,0.00,10481.83,3434518.00,0.00,0.00,0.00),('1','138','765','187163',3665045,'2136','323',1803379.94,1812923.87,0.00,0.00,9543.93,3126526.80,0.00,0.00,0.00),('1','138','765','187360',3668613,'2136','323',1812923.87,1816416.92,0.00,0.00,3493.05,1146412.80,0.00,0.00,0.00),('1','138','765','187480',3670856,'2136','323',1816416.92,1816416.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','187487',3670949,'2136','323',1816416.92,1817818.29,0.00,0.00,1401.37,469642.00,0.00,0.00,0.00),('1','138','765','187586',3672599,'2136','323',1817818.29,1829644.24,0.00,0.00,11825.95,3880160.00,0.00,0.00,0.00),('1','138','765','187802',3676469,'2136','323',1829644.24,1839700.05,0.00,0.00,10055.81,3294191.20,0.00,0.00,0.00),('1','138','765','187982',3679720,'2136','323',1839700.05,1839700.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','188018',3680267,'2136','323',1839700.05,1848124.30,0.00,0.00,8424.25,2769616.40,0.00,0.00,0.00),('1','138','765','188234',3683910,'2136','323',1848124.30,1859396.60,0.00,0.00,11272.30,3699446.80,0.00,0.00,0.00),('1','138','765','188417',3687117,'2136','323',1859396.60,1864220.46,0.00,0.00,4823.86,1587211.60,0.00,0.00,0.00),('1','138','765','188517',3688842,'2136','323',1864220.46,1864220.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','188528',3689036,'2136','323',1864220.46,1871788.16,0.00,0.00,7567.70,2474610.40,0.00,0.00,0.00),('1','138','765','188605',3690376,'2136','323',1871788.16,1882069.23,0.00,0.00,10281.07,3384289.20,0.00,0.00,0.00),('1','138','765','188805',3693953,'2136','323',1882069.23,1888906.32,0.00,0.00,6837.09,2240100.00,0.00,0.00,0.00),('1','138','765','188899',3695603,'2136','323',1888906.32,1888906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','188915',3695904,'2136','323',1888906.32,1896432.52,0.00,0.00,7526.20,2458850.00,0.00,0.00,0.00),('1','138','765','189028',3697873,'2136','323',1896432.52,1909089.94,0.00,0.00,12657.42,4147087.20,0.00,0.00,0.00),('1','138','765','189202',3701061,'2136','323',1909089.94,1913523.24,0.00,0.00,4433.30,1453180.80,0.00,0.00,0.00),('1','138','765','189299',3702871,'2136','323',1913523.24,1913523.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','189324',3703436,'2136','323',1913523.24,1918996.52,0.00,0.00,5473.28,1793848.80,0.00,0.00,0.00),('1','138','765','189431',3705140,'2136','323',1918996.52,1932571.01,0.00,0.00,13574.49,4450617.60,0.00,0.00,0.00),('1','138','765','189623',3708492,'2136','323',1932571.01,1938168.54,0.00,0.00,5597.53,1850963.60,0.00,0.00,0.00),('1','138','765','189778',3711319,'2136','323',1938168.54,1938168.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','189814',3711906,'2136','323',1938168.54,1950537.10,0.00,0.00,12368.56,4060354.40,0.00,0.00,0.00),('1','138','765','190030',3716236,'2136','323',1950537.10,1956763.42,0.00,0.00,6226.32,2062126.80,0.00,0.00,0.00),('1','138','765','190215',3719770,'2136','323',1956763.42,1963018.77,0.00,0.00,6255.35,2049268.88,0.00,0.00,0.00),('1','138','765','190362',3722480,'2136','323',1963018.77,1963018.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','190374',3722749,'2136','323',1963018.77,1966295.58,0.00,0.00,3276.81,1064047.60,0.00,0.00,0.00),('1','138','765','190436',3723805,'2136','323',1966295.58,1980223.11,0.00,0.00,13927.53,4572231.68,0.00,0.00,0.00),('1','138','765','190668',3728160,'2136','323',1980223.11,1987654.33,0.00,0.00,7431.22,2430402.80,0.00,0.00,0.00),('1','138','765','190838',3731372,'2136','323',1987654.33,1989214.53,0.00,0.00,1560.20,521384.00,0.00,0.00,0.00),('1','138','765','191088',3735619,'2136','323',1989214.53,1996249.28,0.00,0.00,7034.75,2312930.40,0.00,0.00,0.00),('1','138','765','191299',3739347,'2136','323',1996249.28,2006024.76,0.00,0.00,9775.48,3227080.16,0.00,0.00,0.00),('1','138','765','191469',3742534,'2136','323',2006024.76,2006024.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','191493',3742922,'2136','323',2006024.76,2014684.22,0.00,0.00,8659.46,2862972.80,0.00,0.00,0.00),('1','138','765','191711',3747189,'2136','323',2014684.22,2022138.38,0.00,0.00,7454.16,2470825.60,0.00,0.00,0.00),('1','138','765','191939',3751600,'2136','323',2022138.38,2029834.11,0.00,0.00,7695.73,2535389.20,0.00,0.00,0.00),('1','138','765','192127',3754921,'2136','323',2029834.11,2030686.31,0.00,0.00,852.20,282280.00,0.00,0.00,0.00),('1','138','765','192186',3755853,'2136','323',2030686.31,2030686.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','192201',3756129,'2136','323',2030686.31,2037262.45,0.00,0.00,6576.14,2170178.40,0.00,0.00,0.00),('1','138','765','192339',3758857,'2136','323',2037262.45,2045912.95,0.00,0.00,8650.50,2858808.00,0.00,0.00,0.00),('1','138','765','192573',3762899,'2136','323',2045912.95,2051169.95,0.00,0.00,5257.00,1744904.00,0.00,0.00,0.00),('1','138','765','192752',3766235,'2136','323',2051169.95,2055313.48,0.00,0.00,4143.53,1381430.80,0.00,0.00,0.00),('1','138','765','192884',3768668,'2136','323',2055313.48,2055313.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','192889',3768757,'2136','323',2055313.48,2057634.17,0.00,0.00,2320.69,769736.40,0.00,0.00,0.00),('1','138','765','192953',3769904,'2136','323',2057634.17,2064904.11,0.00,0.00,7269.94,2398972.40,0.00,0.00,0.00),('1','138','765','193165',3773946,'2136','323',2064904.11,2069801.12,0.00,0.00,4897.01,1624355.60,0.00,0.00,0.00),('1','138','765','193421',3778926,'2136','323',2069801.12,2076964.14,0.00,0.00,7163.02,2368653.20,0.00,0.00,0.00),('1','138','765','193617',3782821,'2136','323',2076964.14,2079852.81,0.00,0.00,2888.67,957569.20,0.00,0.00,0.00),('1','138','765','193747',3784933,'2136','323',2079852.81,2079852.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','193752',3784995,'2136','323',2079852.81,2079852.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','193756',3785077,'2136','323',2079852.81,2081367.08,0.00,0.00,1514.27,506425.20,0.00,0.00,0.00),('1','138','765','193877',3787180,'2136','323',2081367.08,2088931.30,0.00,0.00,7564.22,2493128.80,0.00,0.00,0.00),('1','138','765','194079',3790902,'2136','323',2088931.30,2094376.55,0.00,0.00,5445.25,1808514.00,0.00,0.00,0.00),('1','138','765','194282',3794807,'2136','323',2094376.55,2104279.19,0.00,0.00,9902.64,3270464.80,0.00,0.00,0.00),('1','138','765','194512',3798694,'2136','323',2104279.19,2104300.19,0.00,0.00,21.00,6888.00,0.00,0.00,0.00),('1','138','765','194514',3798713,'2136','323',2104300.19,2104300.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','194527',3798884,'2136','323',2104300.19,2111221.44,0.00,0.00,6921.25,2285669.04,0.00,0.00,0.00),('1','138','765','194662',3801525,'2136','323',2111221.44,2119064.74,0.00,0.00,7843.30,2585029.20,0.00,0.00,0.00),('1','138','765','194876',3805797,'2136','323',2119064.74,2123413.98,0.00,0.00,4349.24,1447154.40,0.00,0.00,0.00),('1','138','765','195113',3809940,'2136','323',2123413.98,2128693.90,0.00,0.00,5279.92,1728926.40,0.00,0.00,0.00),('1','138','765','195246',3812314,'2136','323',2128693.90,2128693.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','195258',3812532,'2136','323',2128693.90,2130832.20,0.00,0.00,2138.30,703948.00,0.00,0.00,0.00),('1','138','765','195320',3813446,'2136','323',2130832.20,2142667.57,0.00,0.00,11835.37,3893521.20,0.00,0.00,0.00),('1','138','765','195542',3817458,'2136','323',2142667.57,2146944.93,0.00,0.00,4277.36,1420401.60,0.00,0.00,0.00),('1','138','765','195791',3821552,'2136','323',2146944.93,2152190.83,0.00,0.00,5245.90,1737978.80,0.00,0.00,0.00),('1','138','765','196005',3825603,'2136','323',2152190.83,2153039.53,0.00,0.00,848.70,279317.60,0.00,0.00,0.00),('1','138','765','196065',3826536,'2136','323',2153039.53,2157926.80,0.00,0.00,4887.27,1619551.60,0.00,0.00,0.00),('1','138','765','196248',3830154,'2136','323',2157926.80,2163624.98,0.00,0.00,5698.18,1889012.80,0.00,0.00,0.00),('1','138','765','196453',3833852,'2136','323',2163624.98,2169961.74,0.00,0.00,6336.76,2102813.36,0.00,0.00,0.00),('1','138','765','196660',3837599,'2136','323',2169961.74,2177748.14,0.00,0.00,7786.40,2554646.00,0.00,0.00,0.00),('1','138','765','196796',3839990,'2136','323',2177748.14,2177748.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','196810',3840280,'2136','323',2177748.14,2178942.94,0.00,0.00,1194.80,391428.00,0.00,0.00,0.00),('1','138','765','196899',3841762,'2136','323',2178942.94,2185940.76,0.00,0.00,6997.82,2278100.00,0.00,0.00,0.00),('1','138','765','197030',3844240,'2136','323',2185940.76,2190901.12,0.00,0.00,4960.36,1615615.20,0.00,0.00,0.00),('1','138','765','197414',3850531,'2136','323',2190901.12,2196467.62,0.00,0.00,5566.50,1818336.00,0.00,0.00,0.00),('1','138','765','197421',3850633,'2136','323',2196467.62,2200479.59,0.00,0.00,4011.97,1313320.68,0.00,0.00,0.00),('1','138','765','197526',3852567,'2136','323',2200479.59,2201948.15,0.00,0.00,1468.56,482853.60,0.00,0.00,0.00),('1','138','765','197669',3855238,'2136','323',2201948.15,2201948.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','197674',3855337,'2136','323',2201948.15,2201948.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','197680',3855400,'2136','323',2201948.15,2204939.68,0.00,0.00,2991.53,980074.80,0.00,0.00,0.00),('1','138','765','197877',3858908,'2136','323',2204939.68,2209128.42,0.00,0.00,4188.74,1380636.00,0.00,0.00,0.00),('1','138','765','198118',3863137,'2136','323',2209128.42,2213634.73,0.00,0.00,4506.31,1470849.60,0.00,0.00,0.00),('1','138','765','198362',3867211,'2136','323',2213634.73,2220973.23,0.00,0.00,7338.50,2384020.00,0.00,0.00,0.00),('1','138','765','198575',3870871,'2136','323',2220973.23,2226090.36,0.00,0.00,5117.13,1650520.80,0.00,0.00,0.00),('1','138','765','198712',3873575,'2136','323',2226090.36,2226090.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','198714',3873578,'2136','323',2226090.36,2226090.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','198716',3873602,'2136','323',2226090.36,2227565.58,0.00,0.00,1475.22,476647.20,0.00,0.00,0.00),('1','138','765','198794',3874497,'2136','323',2227565.58,2235433.88,0.00,0.00,7868.30,2540536.00,0.00,0.00,0.00),('1','138','765','198995',3878042,'2136','323',2235433.88,2239726.29,0.00,0.00,4292.41,1396419.60,0.00,0.00,0.00),('1','138','765','199223',3882085,'2136','323',2239726.29,2249625.58,0.00,0.00,9899.29,3190508.80,0.00,0.00,0.00),('1','138','765','199443',3885572,'2136','323',2249625.58,2250124.29,0.00,0.00,498.71,164215.60,0.00,0.00,0.00),('1','138','765','199539',3887208,'2136','323',2250124.29,2250124.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','199541',3887224,'2136','323',2250124.29,2250124.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','199542',3887225,'2136','323',2250124.29,2252954.20,0.00,0.00,2829.91,921643.60,0.00,0.00,0.00),('1','138','765','199666',3889337,'2136','323',2252954.20,2260555.25,0.00,0.00,7601.05,2452716.80,0.00,0.00,0.00),('1','138','765','199887',3892728,'2136','323',2260555.25,2268764.52,0.00,0.00,8209.27,2650791.20,0.00,0.00,0.00),('1','138','765','200099',3896788,'2136','323',2268764.52,2274457.22,0.00,0.00,5692.70,1829944.00,0.00,0.00,0.00),('1','138','765','200257',3899767,'2136','323',2274457.22,2274457.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','200261',3899818,'2136','323',2274457.22,2274457.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','200293',3900205,'2136','323',2274457.22,2281223.02,0.00,0.00,6765.80,2180628.00,0.00,0.00,0.00),('1','138','765','200494',3904001,'2136','323',2281223.02,2286823.59,0.00,0.00,5600.57,1813302.00,0.00,0.00,0.00),('1','138','765','200701',3907601,'2136','323',2286823.59,2292150.14,0.00,0.00,5326.55,1728094.00,0.00,0.00,0.00),('1','138','765','200935',3911650,'2136','323',2292150.14,2298747.52,0.00,0.00,6597.38,2130692.00,0.00,0.00,0.00),('1','138','765','201112',3914652,'2136','323',2298747.52,2298747.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','201121',3914699,'2136','323',2298747.52,2305880.83,0.00,0.00,7133.31,2296016.80,0.00,0.00,0.00),('1','138','765','201327',3918202,'2136','323',2305880.83,2313266.18,0.00,0.00,7385.35,2376108.00,0.00,0.00,0.00),('1','138','765','201516',3921648,'2136','323',2313266.18,2322665.83,0.00,0.00,9399.65,3032618.00,0.00,0.00,0.00),('1','138','765','201871',3928528,'2136','323',2322665.83,2322949.43,0.00,0.00,283.60,90752.00,0.00,0.00,0.00),('1','138','765','201874',3928573,'2136','323',2322949.43,2322949.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','201878',3928637,'2136','323',2322949.43,2322949.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','201980',3930789,'2136','323',2322949.43,2327548.83,0.00,0.00,4599.40,1548452.80,0.00,0.00,0.00),('1','138','765','202084',3932494,'2136','323',2327548.83,2327548.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','202087',3932523,'2136','323',2327548.83,2327548.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','202168',3934033,'2136','323',2327548.83,2331369.26,0.00,0.00,3820.43,1282474.80,0.00,0.00,0.00),('1','138','765','202221',3934777,'2136','323',2331369.26,2336918.79,0.00,0.00,5549.53,1879484.40,0.00,0.00,0.00),('1','138','765','202438',3938556,'2136','323',2336918.79,2339906.52,0.00,0.00,2987.73,1006318.80,0.00,0.00,0.00),('1','138','765','202562',3940773,'2136','323',2339906.52,2339906.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','202565',3940811,'2136','323',2339906.52,2339906.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','202582',3941171,'2136','323',2339906.52,2341513.90,0.00,0.00,1607.38,547881.60,0.00,0.00,0.00),('1','138','765','202649',3942222,'2136','323',2341513.90,2349836.33,0.00,0.00,8322.43,2804371.60,0.00,0.00,0.00),('1','138','765','202870',3946116,'2136','323',2349836.33,2357207.71,0.00,0.00,7371.38,2487825.60,0.00,0.00,0.00),('1','138','765','203118',3950928,'2136','323',2357207.71,2364033.52,0.00,0.00,6825.81,2301802.64,0.00,0.00,0.00),('1','138','765','203339',3954868,'2136','323',2364033.52,2364033.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','203344',3954969,'2136','323',2364033.52,2364033.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','203384',3955744,'2136','323',2364033.52,2369013.47,0.00,0.00,4979.95,1676961.60,0.00,0.00,0.00),('1','138','765','203543',3958566,'2136','323',2369013.47,2378723.27,0.00,0.00,9709.80,3263943.52,0.00,0.00,0.00),('1','138','765','203728',3962019,'2136','323',2378723.27,2388113.19,0.00,0.00,9389.92,3159346.32,0.00,0.00,0.00),('1','138','765','203904',3965233,'2136','323',2388113.19,2388113.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','203908',3965282,'2136','323',2388113.19,2388113.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','203914',3965371,'2136','323',2388113.19,2388113.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','203934',3965726,'2136','323',2388113.19,2390528.39,0.00,0.00,2415.20,818355.20,0.00,0.00,0.00),('1','138','765','203981',3966280,'2136','323',2390528.39,2394958.17,0.00,0.00,4429.78,1542173.28,0.00,0.00,0.00),('1','138','765','204216',3970603,'2136','323',2394958.17,2401026.28,0.00,0.00,6068.11,2104550.96,0.00,0.00,0.00),('1','138','765','204414',3974179,'2136','323',2401026.28,2407472.29,0.00,0.00,6446.01,2231107.76,0.00,0.00,0.00),('1','138','765','204629',3978132,'2136','323',2407472.29,2411924.89,0.00,0.00,4452.60,1532261.60,0.00,0.00,0.00),('1','138','765','204753',3980520,'2136','323',2411924.89,2411924.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','204756',3980580,'2136','323',2411924.89,2411924.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','204926',3983079,'2136','323',2411924.89,2413273.39,0.00,0.00,1348.50,469916.00,0.00,0.00,0.00),('1','138','765','204973',3983917,'2136','323',2413273.39,2420631.40,0.00,0.00,7358.01,2541123.76,0.00,0.00,0.00),('1','138','765','205044',3985240,'2136','323',2420631.40,2426998.11,0.00,0.00,6366.71,2204615.76,0.00,0.00,0.00),('1','138','765','205266',3989135,'2136','323',2426998.11,2431582.03,0.00,0.00,4583.92,1589770.56,0.00,0.00,0.00),('1','138','765','205500',3993385,'2136','323',2431582.03,2435794.30,0.00,0.00,4212.27,1462171.92,0.00,0.00,0.00),('1','138','765','205801',3998952,'2136','323',2435794.30,2435794.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','205814',3999189,'2136','323',2435794.30,2435794.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','205823',3999353,'2136','323',2435794.30,2440244.08,0.00,0.00,4449.78,1545494.88,0.00,0.00,0.00),('1','138','765','206002',4002501,'2136','323',2440244.08,2446142.80,0.00,0.00,5898.72,2044307.52,0.00,0.00,0.00),('1','138','765','206172',4005582,'2136','323',2446142.80,2450268.53,0.00,0.00,4125.73,1448758.48,0.00,0.00,0.00),('1','138','765','206348',4008744,'2136','323',2450268.53,2455901.80,0.00,0.00,5633.27,1957399.52,0.00,0.00,0.00),('1','138','765','206573',4012560,'2136','323',2455901.80,2459686.59,0.00,0.00,3784.79,1309503.44,0.00,0.00,0.00),('1','138','765','206698',4014844,'2136','323',2459686.59,2459686.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','206700',4014862,'2136','323',2459686.59,2459686.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','206726',4015287,'2136','323',2459686.59,2461823.74,0.00,0.00,2137.15,741584.40,0.00,0.00,0.00),('1','138','765','206800',4016538,'2136','323',2461823.74,2466849.85,0.00,0.00,5026.11,1738310.16,0.00,0.00,0.00),('1','138','765','207032',4020744,'2136','323',2466849.85,2476679.62,0.00,0.00,9829.77,3398314.32,0.00,0.00,0.00),('1','138','765','207251',4024706,'2136','323',2476679.62,2483578.60,0.00,0.00,6898.98,2379709.76,0.00,0.00,0.00),('1','138','765','207427',4027885,'2136','323',2483578.60,2483578.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','207439',4028114,'2136','323',2483578.60,2483578.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','207538',4029782,'2136','323',2483578.60,2494206.96,0.00,0.00,10628.36,3672224.96,0.00,0.00,0.00),('1','138','765','207710',4032667,'2136','323',2494206.96,2502082.17,0.00,0.00,7875.21,2778888.64,0.00,0.00,0.00),('1','138','765','207909',4036088,'2136','323',2502082.17,2506244.77,0.00,0.00,4162.60,1485359.60,0.00,0.00,0.00),('1','138','765','208075',4039027,'2136','323',2506244.77,2506244.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','208077',4039040,'2136','323',2506244.77,2506244.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','208233',4041915,'2136','323',2506244.77,2510415.71,0.00,0.00,4170.94,1478104.96,0.00,0.00,0.00),('1','138','765','208285',4043002,'2136','323',2510415.71,2510415.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','208286',4043003,'2136','323',2510415.71,2510415.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','208387',4044533,'2136','323',2510415.71,2518659.66,0.00,0.00,8243.95,2925724.80,0.00,0.00,0.00),('1','138','765','208553',4047482,'2136','323',2518659.66,2524375.57,0.00,0.00,5715.91,2022625.44,0.00,0.00,0.00),('1','138','765','208781',4051321,'2136','323',2524375.57,2534052.06,0.00,0.00,9676.49,3411709.76,0.00,0.00,0.00),('1','138','765','209079',4056406,'2136','323',2534052.06,2534052.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','209087',4056567,'2136','323',2534052.06,2534052.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','209091',4056644,'2136','323',2534052.06,2539391.56,0.00,0.00,5339.50,1997092.00,0.00,0.00,0.00),('1','138','765','209208',4058917,'2136','323',2539391.56,2545968.70,0.00,0.00,6577.14,2462819.08,0.00,0.00,0.00),('1','138','765','209435',4062875,'2136','323',2545968.70,2553065.83,0.00,0.00,7097.13,2662324.00,0.00,0.00,0.00),('1','138','765','209660',4066783,'2136','323',2553065.83,2557896.28,0.00,0.00,4830.45,1818844.40,0.00,0.00,0.00),('1','138','765','209931',4071715,'2136','323',2557896.28,2557944.62,0.00,0.00,48.34,20302.80,0.00,0.00,0.00),('1','138','765','209951',4072090,'2136','323',2557944.62,2557944.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','209959',4072199,'2136','323',2557944.62,2557944.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','209972',4072431,'2136','323',2557944.62,2562167.02,0.00,0.00,4222.40,1612265.04,0.00,0.00,0.00),('1','138','765','210060',4074011,'2136','323',2562167.02,2562167.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','210179',4075946,'2136','323',2562167.02,2562167.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','210189',4076168,'2136','323',2562167.02,2563207.42,0.00,0.00,1040.40,436968.00,0.00,0.00,0.00),('1','138','765','210310',4078370,'2136','323',2563207.42,2564099.58,0.00,0.00,892.16,374707.20,0.00,0.00,0.00),('1','138','765','210614',4083923,'2136','323',2564099.58,2564903.18,0.00,0.00,803.60,337512.00,0.00,0.00,0.00),('1','138','765','210780',4086734,'2136','323',2564903.18,2565992.91,0.00,0.00,1089.73,457686.60,0.00,0.00,0.00),('1','138','765','210959',4089742,'2136','323',2565992.91,2566257.93,0.00,0.00,265.02,111308.40,0.00,0.00,0.00),('1','138','765','211111',4092579,'2136','323',2566257.93,2566257.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','211121',4092746,'2136','323',2566257.93,2566257.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','211176',4093628,'2136','323',2566257.93,2571059.02,0.00,0.00,4801.09,1893222.16,0.00,0.00,0.00),('1','138','765','211417',4097865,'2136','323',2571059.02,2577940.90,0.00,0.00,6881.88,2721474.32,0.00,0.00,0.00),('1','138','765','211646',4101944,'2136','323',2577940.90,2580914.38,0.00,0.00,2973.48,1172043.52,0.00,0.00,0.00),('1','138','765','211790',4104190,'2136','323',2580914.38,2588990.98,0.00,0.00,8076.60,3170208.40,0.00,0.00,0.00),('1','138','765','212005',4108066,'2136','323',2588990.98,2590071.78,0.00,0.00,1080.80,420459.20,0.00,0.00,0.00),('1','138','765','212130',4110414,'2136','323',2590071.78,2590071.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','212135',4110435,'2136','323',2590071.78,2590071.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','212148',4110644,'2136','323',2590071.78,2590997.88,0.00,0.00,926.10,392666.40,0.00,0.00,0.00),('1','138','765','212250',4112392,'2136','323',2590997.88,2592073.05,0.00,0.00,1075.17,455872.08,0.00,0.00,0.00),('1','138','765','212519',4117364,'2136','323',2592073.05,2592925.55,0.00,0.00,852.50,361460.00,0.00,0.00,0.00),('1','138','765','212727',4121029,'2136','323',2592925.55,2593931.53,0.00,0.00,1005.98,426535.52,0.00,0.00,0.00),('1','138','765','212942',4124874,'2136','323',2593931.53,2594296.12,0.00,0.00,364.59,154586.16,0.00,0.00,0.00),('1','138','765','213184',4128994,'2136','323',2594296.12,2594296.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','213198',4129210,'2136','323',2594296.12,2594296.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','213208',4129394,'2136','323',2594296.12,2598953.64,0.00,0.00,4657.52,1837316.48,0.00,0.00,0.00),('1','138','765','213423',4132852,'2136','323',2598953.64,2603951.42,0.00,0.00,4997.78,1979222.72,0.00,0.00,0.00),('1','138','765','213648',4136621,'2136','323',2603951.42,2608094.82,0.00,0.00,4143.40,1638457.60,0.00,0.00,0.00),('1','138','765','213918',4140947,'2136','323',2608094.82,2613382.46,0.00,0.00,5287.64,2083172.96,0.00,0.00,0.00),('1','138','765','214264',4147215,'2136','323',2613382.46,2618110.44,0.00,0.00,4727.98,1853026.16,0.00,0.00,0.00),('1','138','765','214270',4147308,'2136','323',2618110.44,2618110.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','214276',4147381,'2136','323',2618110.44,2618110.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','215154',4162311,'2136','323',2618110.44,2618110.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','215156',4162328,'2136','323',2618110.44,2624213.04,0.00,0.00,6102.60,2404820.80,0.00,0.00,0.00),('1','138','765','215164',4162460,'2136','323',2624213.04,2632325.04,0.00,0.00,8112.00,3200064.00,0.00,0.00,0.00),('1','138','765','215167',4162502,'2136','323',2632325.04,2640519.54,0.00,0.00,8194.50,3223760.00,0.00,0.00,0.00),('1','138','765','215170',4162554,'2136','323',2640519.54,2642738.94,0.00,0.00,2219.40,874276.00,0.00,0.00,0.00),('1','138','765','215172',4162596,'2136','323',2642738.94,2642738.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','215189',4162866,'2136','323',2642738.94,2642738.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','215258',4163950,'2136','323',2642738.94,2642738.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','215370',4165936,'2136','323',2642738.94,2643353.44,0.00,0.00,614.50,248708.00,0.00,0.00,0.00),('1','138','765','215381',4166140,'2136','323',2643353.44,2645342.05,0.00,0.00,1988.61,842097.28,0.00,0.00,0.00),('1','138','765','215446',4167090,'2136','323',2645342.05,2646910.84,0.00,0.00,1568.79,672124.16,0.00,0.00,0.00),('1','138','765','215633',4170429,'2136','323',2646910.84,2646910.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','215635',4170444,'2136','323',2646910.84,2646910.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','215804',4173406,'2136','323',2646910.84,2651052.64,0.00,0.00,4141.80,1740518.00,0.00,0.00,0.00),('1','138','765','215877',4174671,'2136','323',2651052.64,2651052.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','215878',4174672,'2136','323',2651052.64,2651052.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','216038',4177356,'2136','323',2651052.64,2655629.24,0.00,0.00,4576.60,1912550.40,0.00,0.00,0.00),('1','138','765','216121',4178677,'2136','323',2655629.24,2660413.31,0.00,0.00,4784.07,2012366.40,0.00,0.00,0.00),('1','138','765','216315',4182237,'2136','323',2660413.31,2667869.00,0.00,0.00,7455.69,3112027.88,0.00,0.00,0.00),('1','138','765','216564',4186349,'2136','323',2667869.00,2675766.82,0.00,0.00,7897.82,3311482.64,0.00,0.00,0.00),('1','138','765','216987',4194086,'2136','323',2675766.82,2676617.12,0.00,0.00,850.30,384335.60,0.00,0.00,0.00),('1','138','765','217042',4194723,'2136','323',2676617.12,2678305.19,0.00,0.00,1688.07,810273.60,0.00,0.00,0.00),('1','138','765','217286',4199475,'2136','323',2678305.19,2678771.13,0.00,0.00,465.94,223651.20,0.00,0.00,0.00),('1','138','765','217365',4200682,'2136','323',2678771.13,2678771.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','217376',4200856,'2136','323',2678771.13,2679888.12,0.00,0.00,1116.99,536155.20,0.00,0.00,0.00),('1','138','765','217499',4203213,'2136','323',2679888.12,2681427.60,0.00,0.00,1539.48,738950.40,0.00,0.00,0.00),('1','138','765','217711',4206705,'2136','323',2681427.60,2683948.81,0.00,0.00,2521.21,1129828.80,0.00,0.00,0.00),('1','138','765','217928',4210942,'2136','323',2683948.81,2683948.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','218019',4212217,'2136','323',2683948.81,2692616.09,0.00,0.00,8667.28,3833896.40,0.00,0.00,0.00),('1','138','765','218239',4216051,'2136','323',2692616.09,2698355.63,0.00,0.00,5739.54,2545250.40,0.00,0.00,0.00),('1','138','765','218454',4219865,'2136','323',2698355.63,2702996.34,0.00,0.00,4640.71,2062059.20,0.00,0.00,0.00),('1','138','765','218694',4224156,'2136','323',2702996.34,2708207.89,0.00,0.00,5211.55,2321846.80,0.00,0.00,0.00),('1','138','765','218869',4227379,'2136','323',2708207.89,2708207.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','218911',4228017,'2136','323',2708207.89,2716767.75,0.00,0.00,8559.86,3793452.80,0.00,0.00,0.00),('1','138','765','219122',4231587,'2136','323',2716767.75,2722574.71,0.00,0.00,5806.96,2578268.00,0.00,0.00,0.00),('1','138','765','219335',4235350,'2136','323',2722574.71,2728736.18,0.00,0.00,6161.47,2748215.60,0.00,0.00,0.00),('1','138','765','219594',4239775,'2136','323',2728736.18,2732210.93,0.00,0.00,3474.75,1551040.00,0.00,0.00,0.00),('1','138','765','219759',4242899,'2136','323',2732210.93,2734336.46,0.00,0.00,2125.53,937178.40,0.00,0.00,0.00),('1','138','765','219823',4243795,'2136','323',2734336.46,2743142.04,0.00,0.00,8805.58,3905270.80,0.00,0.00,0.00),('1','138','765','220060',4248080,'2136','323',2743142.04,2746933.49,0.00,0.00,3791.45,1667269.60,0.00,0.00,0.00),('1','138','765','220208',4250965,'2136','323',2746933.49,2746933.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','220261',4251640,'2136','323',2746933.49,2753063.92,0.00,0.00,6130.43,2672966.40,0.00,0.00,0.00),('1','138','765','220472',4255595,'2136','323',2753063.92,2756601.62,0.00,0.00,3537.70,1541507.20,0.00,0.00,0.00),('1','138','765','220647',4258686,'2136','323',2756601.62,2756601.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','220648',4258687,'2136','323',2756601.62,2756601.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','220687',4259290,'2136','323',2756601.62,2763412.62,0.00,0.00,6811.00,2969286.88,0.00,0.00,0.00),('1','138','765','220920',4263356,'2136','323',2763412.62,2769498.56,0.00,0.00,6085.94,2663680.80,0.00,0.00,0.00),('1','138','765','221148',4267422,'2136','323',2769498.56,2775464.27,0.00,0.00,5965.71,2617288.00,0.00,0.00,0.00),('1','138','765','221395',4271862,'2136','323',2775464.27,2780880.05,0.00,0.00,5415.78,2368416.40,0.00,0.00,0.00),('1','138','765','221651',4276506,'2136','323',2780880.05,2781183.65,0.00,0.00,303.60,134448.00,0.00,0.00,0.00),('1','138','765','221684',4277100,'2136','323',2781183.65,2781183.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','221718',4277708,'2136','323',2781183.65,2782142.85,0.00,0.00,959.20,460416.00,0.00,0.00,0.00),('1','138','765','221865',4280251,'2136','323',2782142.85,2785623.33,0.00,0.00,3480.48,1561758.40,0.00,0.00,0.00),('1','138','765','222074',4284173,'2136','323',2785623.33,2786274.09,0.00,0.00,650.76,298884.80,0.00,0.00,0.00),('1','138','765','222128',4285090,'2136','323',2786274.09,2786274.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','222136',4285186,'2136','323',2786274.09,2788460.09,0.00,0.00,2186.00,994532.00,0.00,0.00,0.00),('1','138','765','222282',4287612,'2136','323',2788460.09,2789811.41,0.00,0.00,1351.32,648633.60,0.00,0.00,0.00),('1','138','765','222552',4292240,'2136','323',2789811.41,2790755.46,0.00,0.00,944.05,453144.00,0.00,0.00,0.00),('1','138','765','222745',4295919,'2136','323',2790755.46,2791415.46,0.00,0.00,660.00,316800.00,0.00,0.00,0.00),('1','138','765','223245',4304659,'2136','323',2791415.46,2791415.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','223252',4304735,'2136','323',2791415.46,2792329.66,0.00,0.00,914.20,438816.00,0.00,0.00,0.00),('1','138','765','223257',4304846,'2136','323',2792329.66,2793747.66,0.00,0.00,1418.00,680640.00,0.00,0.00,0.00),('1','138','765','223262',4304897,'2136','323',2793747.66,2793747.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','223267',4304929,'2136','323',2793747.66,2794727.09,0.00,0.00,979.43,470126.40,0.00,0.00,0.00),('1','138','765','223426',4308015,'2136','323',2794727.09,2796760.67,0.00,0.00,2033.58,954195.52,0.00,0.00,0.00),('1','138','765','223603',4311438,'2136','323',2796760.67,2796760.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','223640',4312024,'2136','323',2796760.67,2799707.93,0.00,0.00,2947.26,1416938.40,0.00,0.00,0.00),('1','138','765','223876',4316419,'2136','323',2799707.93,2803382.72,0.00,0.00,3674.79,1745100.48,0.00,0.00,0.00),('1','138','765','224085',4319968,'2136','323',2803382.72,2807102.98,0.00,0.00,3720.26,1752930.00,0.00,0.00,0.00),('1','138','765','224309',4324107,'2136','323',2807102.98,2810890.46,0.00,0.00,3787.48,1858032.60,0.00,0.00,0.00),('1','138','765','224551',4328151,'2136','323',2810890.46,2813537.65,0.00,0.00,2647.19,1313456.34,0.00,0.00,0.00),('1','138','765','224778',4332227,'2136','323',2813537.65,2816407.13,0.00,0.00,2869.48,1412022.36,0.00,0.00,0.00),('1','138','765','225021',4336596,'2136','323',2816407.13,2821272.95,0.00,0.00,4865.82,2372709.84,0.00,0.00,0.00),('1','138','765','225279',4341232,'2136','323',2821272.95,2821372.95,0.00,0.00,100.00,48400.00,0.00,0.00,0.00),('1','138','765','225281',4341234,'2136','323',2821372.95,2821372.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','225318',4341776,'2136','323',2821372.95,2825386.16,0.00,0.00,4013.21,1961906.56,0.00,0.00,0.00),('1','138','765','225490',4345141,'2136','323',2825386.16,2826623.80,0.00,0.00,1237.64,607025.20,0.00,0.00,0.00),('1','138','765','225602',4347322,'2136','323',2826623.80,2826623.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','225627',4347758,'2136','323',2826623.80,2827825.40,0.00,0.00,1201.60,590335.60,0.00,0.00,0.00),('1','138','765','225698',4348723,'2136','323',2827825.40,2831945.10,0.00,0.00,4119.70,2031312.68,0.00,0.00,0.00),('1','138','765','226027',4354239,'2136','323',2831945.10,2831945.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','226101',4355744,'2136','323',2831945.10,2835878.24,0.00,0.00,3933.14,1960867.16,0.00,0.00,0.00),('1','138','765','226228',4358316,'2136','323',2835878.24,2842503.28,0.00,0.00,6625.04,3294331.66,0.00,0.00,0.00),('1','138','765','226470',4362490,'2136','323',2842503.28,2853070.42,0.00,0.00,10567.14,5233303.76,0.00,0.00,0.00),('1','138','765','226728',4367248,'2136','323',2853070.42,2856584.14,0.00,0.00,3513.72,1727246.68,0.00,0.00,0.00),('1','138','765','226891',4370179,'2136','323',2856584.14,2860209.72,0.00,0.00,3625.58,1787830.72,0.00,0.00,0.00),('1','138','765','226966',4371376,'2136','323',2860209.72,2868649.46,0.00,0.00,8439.74,4175072.22,0.00,0.00,0.00),('1','138','765','227196',4375364,'2136','323',2868649.46,2875732.51,0.00,0.00,7083.05,3493163.78,0.00,0.00,0.00),('1','138','765','227429',4379508,'2136','323',2875732.51,2875732.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','227444',4379870,'2136','323',2875732.51,2884698.25,0.00,0.00,8965.74,4439319.56,0.00,0.00,0.00),('1','138','765','227606',4382559,'2136','323',2884698.25,2895098.07,0.00,0.00,10399.82,5131421.26,0.00,0.00,0.00),('1','138','765','227850',4386918,'2136','323',2895098.07,2899320.71,0.00,0.00,4222.64,2111178.88,0.00,0.00,0.00),('1','138','765','228129',4392154,'2136','323',2899320.71,2900283.85,0.00,0.00,963.14,523948.16,0.00,0.00,0.00),('1','138','765','228297',4395807,'2136','323',2900283.85,2900283.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','228302',4395867,'2136','323',2900283.85,2900747.19,0.00,0.00,463.34,252056.96,0.00,0.00,0.00),('1','138','765','228461',4398730,'2136','323',2900747.19,2902865.10,0.00,0.00,2117.91,1132596.00,0.00,0.00,0.00),('1','138','765','228530',4399848,'2136','323',2902865.10,2903654.82,0.00,0.00,789.72,410212.80,0.00,0.00,0.00),('1','138','765','228584',4400663,'2136','323',2903654.82,2903654.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','228591',4400793,'2136','323',2903654.82,2908070.03,0.00,0.00,4415.21,2273505.60,0.00,0.00,0.00),('1','138','765','228761',4404157,'2136','323',2908070.03,2914243.14,0.00,0.00,6173.11,3191965.12,0.00,0.00,0.00),('1','138','765','228960',4407634,'2136','323',2914243.14,2923534.42,0.00,0.00,9291.28,4786669.20,0.00,0.00,0.00),('1','138','765','229266',4413705,'2136','323',2923534.42,2928443.81,0.00,0.00,4909.39,2552549.60,0.00,0.00,0.00),('1','138','765','229369',4415656,'2136','323',2928443.81,2928443.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','229473',4417245,'2136','323',2928443.81,2929704.01,0.00,0.00,1260.20,735956.80,0.00,0.00,0.00),('1','138','765','229715',4422009,'2136','323',2929704.01,2929704.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','229723',4422208,'2136','323',2929704.01,2930585.82,0.00,0.00,881.81,514977.04,0.00,0.00,0.00),('1','138','765','229945',4426529,'2136','323',2930585.82,2931767.50,0.00,0.00,1181.68,690101.12,0.00,0.00,0.00),('1','138','765','230084',4429306,'2136','323',2931767.50,2933558.74,0.00,0.00,1791.24,1046084.16,0.00,0.00,0.00),('1','138','765','230288',4433078,'2136','323',2933558.74,2934951.88,0.00,0.00,1393.14,813593.76,0.00,0.00,0.00),('1','138','765','230431',4435968,'2136','323',2934951.88,2934951.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','230480',4436811,'2136','323',2934951.88,2935202.61,0.00,0.00,250.73,146426.32,0.00,0.00,0.00),('1','138','765','230523',4437559,'2136','323',2935202.61,2936959.60,0.00,0.00,1756.99,1026082.16,0.00,0.00,0.00),('1','138','765','230777',4442060,'2136','323',2936959.60,2938452.53,0.00,0.00,1492.93,871871.12,0.00,0.00,0.00),('1','138','765','231065',4446948,'2136','323',2938452.53,2939600.96,0.00,0.00,1148.43,670683.12,0.00,0.00,0.00),('1','138','765','231374',4451832,'2136','323',2939600.96,2939992.96,0.00,0.00,392.00,228928.00,0.00,0.00,0.00),('1','138','765','231475',4453364,'2136','323',2939992.96,2939992.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','231500',4453850,'2136','323',2939992.96,2941231.82,0.00,0.00,1238.86,723494.24,0.00,0.00,0.00),('1','138','765','231644',4456466,'2136','323',2941231.82,2942459.03,0.00,0.00,1227.21,716690.64,0.00,0.00,0.00),('1','138','765','231890',4461041,'2136','323',2942459.03,2945196.87,0.00,0.00,2737.84,1598898.56,0.00,0.00,0.00),('1','138','765','232114',4465018,'2136','323',2945196.87,2945196.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','232120',4465126,'2136','323',2945196.87,2949461.59,0.00,0.00,4264.72,2429479.10,0.00,0.00,0.00),('1','138','765','232330',4468894,'2136','323',2949461.59,2955630.71,0.00,0.00,6169.12,3500550.68,0.00,0.00,0.00),('1','138','765','232587',4473608,'2136','323',2955630.71,2961008.80,0.00,0.00,5378.09,3061334.00,0.00,0.00,0.00),('1','138','765','232847',4478235,'2136','323',2961008.80,2966936.78,0.00,0.00,5927.98,3372907.12,0.00,0.00,0.00),('1','138','765','233123',4483120,'2136','323',2966936.78,2970001.64,0.00,0.00,3064.86,1751153.20,0.00,0.00,0.00),('1','138','765','233305',4486724,'2136','323',2970001.64,2970001.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','233497',4489862,'2136','323',2970001.64,2970745.59,0.00,0.00,743.95,464224.80,0.00,0.00,0.00),('1','138','765','233613',4492132,'2136','323',2970745.59,2972364.02,0.00,0.00,1618.43,1009900.32,0.00,0.00,0.00),('1','138','765','233847',4496279,'2136','323',2972364.02,2974139.85,0.00,0.00,1775.83,1058515.12,0.00,0.00,0.00),('1','138','765','234024',4499584,'2136','323',2974139.85,2974139.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','234102',4500812,'2136','323',2974139.85,2976630.42,0.00,0.00,2490.57,1464857.68,0.00,0.00,0.00),('1','138','765','234329',4504902,'2136','323',2976630.42,2981992.73,0.00,0.00,5362.31,3133920.44,0.00,0.00,0.00),('1','138','765','234568',4509257,'2136','323',2981992.73,2987598.25,0.00,0.00,5605.52,3269255.24,0.00,0.00,0.00),('1','138','765','234814',4513676,'2136','323',2987598.25,2993564.86,0.00,0.00,5966.61,3480126.84,0.00,0.00,0.00),('1','138','765','235062',4518077,'2136','323',2993564.86,2998457.51,0.00,0.00,4892.65,2840297.02,0.00,0.00,0.00),('1','138','765','235239',4521112,'2136','323',2998457.51,2998457.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','235241',4521129,'2136','323',2998457.51,2998711.22,0.00,0.00,253.71,151387.44,0.00,0.00,0.00),('1','138','765','235301',4522113,'2136','323',2998711.22,3009253.32,0.00,0.00,10542.10,6126107.32,0.00,0.00,0.00),('1','138','765','235526',4526076,'2136','323',3009253.32,3012174.35,0.00,0.00,2921.03,1716699.62,0.00,0.00,0.00),('1','138','765','235747',4530099,'2136','323',3012174.35,3017675.69,0.00,0.00,5501.34,3323537.60,0.00,0.00,0.00),('1','138','765','236002',4534524,'2136','323',3017675.69,3022955.92,0.00,0.00,5280.23,3188812.40,0.00,0.00,0.00),('1','138','765','236369',4541018,'2136','323',3022955.92,3022955.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','236379',4541199,'2136','323',3022955.92,3032065.40,0.00,0.00,9109.48,5483101.20,0.00,0.00,0.00),('1','138','765','236496',4543320,'2136','323',3032065.40,3036488.62,0.00,0.00,4423.22,2687217.60,0.00,0.00,0.00),('1','138','765','236723',4547052,'2136','323',3036488.62,3042663.28,0.00,0.00,6174.66,3727100.00,0.00,0.00,0.00),('1','138','765','236960',4551206,'2136','323',3042663.28,3047633.44,0.00,0.00,4970.16,3023289.20,0.00,0.00,0.00),('1','138','765','237158',4554851,'2136','323',3047633.44,3047683.44,0.00,0.00,50.00,30000.00,0.00,0.00,0.00),('1','138','765','237165',4554863,'2136','323',3047683.44,3047683.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','237184',4555086,'2136','323',3047683.44,3051710.01,0.00,0.00,4026.57,2456464.80,0.00,0.00,0.00),('1','138','765','237384',4558848,'2136','323',3051710.01,3059138.16,0.00,0.00,7428.15,4480129.20,0.00,0.00,0.00),('1','138','765','237602',4562747,'2136','323',3059138.16,3064825.81,0.00,0.00,5687.65,3550682.40,0.00,0.00,0.00),('1','138','765','237868',4567108,'2136','323',3064825.81,3072226.09,0.00,0.00,7400.28,4541557.60,0.00,0.00,0.00),('1','138','765','238115',4571096,'2136','323',3072226.09,3072226.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','238116',4571097,'2136','323',3072226.09,3072226.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','238120',4571113,'2136','323',3072226.09,3077249.95,0.00,0.00,5023.86,3066237.92,0.00,0.00,0.00),('1','138','765','238273',4573779,'2136','323',3077249.95,3077249.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','238276',4573788,'2136','323',3077249.95,3082143.34,0.00,0.00,4893.39,2981650.32,0.00,0.00,0.00),('1','138','765','238350',4575221,'2136','323',3082143.34,3092502.48,0.00,0.00,10359.14,6314073.44,0.00,0.00,0.00),('1','138','765','238601',4579337,'2136','323',3092502.48,3101911.08,0.00,0.00,9408.60,5736522.80,0.00,0.00,0.00),('1','138','765','238826',4583376,'2136','323',3101911.08,3101911.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','238837',4583506,'2136','323',3101911.08,3107495.37,0.00,0.00,5584.29,3398195.76,0.00,0.00,0.00),('1','138','765','238974',4586172,'2136','323',3107495.37,3107495.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','239124',4588636,'2136','323',3107495.37,3112561.66,0.00,0.00,5066.29,3081200.80,0.00,0.00,0.00),('1','138','765','239195',4589832,'2136','323',3112561.66,3112561.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','239216',4590201,'2136','323',3112561.66,3116440.44,0.00,0.00,3878.78,2372576.00,0.00,0.00,0.00),('1','138','765','239290',4591508,'2136','323',3116440.44,3117603.19,0.00,0.00,1162.75,713056.00,0.00,0.00,0.00),('1','138','765','239397',4593323,'2136','323',3117603.19,3117603.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','239443',4594091,'2136','323',3117603.19,3120565.76,0.00,0.00,2962.57,1804285.76,0.00,0.00,0.00),('1','138','765','239517',4595409,'2136','323',3120565.76,3122931.59,0.00,0.00,2365.83,1444483.20,0.00,0.00,0.00),('1','138','765','239626',4597231,'2136','323',3122931.59,3122931.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','239639',4597504,'2136','323',3122931.59,3128176.06,0.00,0.00,5244.47,3191399.20,0.00,0.00,0.00),('1','138','765','239839',4601001,'2136','323',3128176.06,3128176.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','239840',4601002,'2136','323',3128176.06,3132234.30,0.00,0.00,4058.24,2493613.20,0.00,0.00,0.00),('1','138','765','239911',4602221,'2136','323',3132234.30,3132234.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','239921',4602446,'2136','323',3132234.30,3134449.05,0.00,0.00,2214.75,1382581.80,0.00,0.00,0.00),('1','138','765','239985',4603546,'2136','323',3134449.05,3137364.09,0.00,0.00,2915.04,1817170.20,0.00,0.00,0.00),('1','138','765','240144',4606358,'2136','323',3137364.09,3137364.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','240252',4608142,'2136','323',3137364.09,3142049.12,0.00,0.00,4685.03,2918553.20,0.00,0.00,0.00),('1','138','765','240442',4611201,'2136','323',3142049.12,3142219.62,0.00,0.00,170.50,106960.00,0.00,0.00,0.00),('1','138','765','240492',4611891,'2136','323',3142219.62,3142219.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','240502',4612097,'2136','323',3142219.62,3146559.50,0.00,0.00,4339.88,2699554.40,0.00,0.00,0.00),('1','138','765','240682',4614876,'2136','323',3146559.50,3148093.27,0.00,0.00,1533.77,962093.40,0.00,0.00,0.00),('1','138','765','240985',4620101,'2136','323',3148093.27,3150982.93,0.00,0.00,2889.66,1791858.58,0.00,0.00,0.00),('1','138','765','241215',4624448,'2136','323',3150982.93,3157141.66,0.00,0.00,6158.73,3754235.92,0.00,0.00,0.00),('1','138','765','241482',4628934,'2136','323',3157141.66,3161288.94,0.00,0.00,4147.28,2530656.20,0.00,0.00,0.00),('1','138','765','241731',4633276,'2136','323',3161288.94,3165342.92,0.00,0.00,4053.98,2469279.58,0.00,0.00,0.00),('1','138','765','241979',4637455,'2136','323',3165342.92,3166591.35,0.00,0.00,1248.43,764628.00,0.00,0.00,0.00),('1','138','765','242073',4639135,'2136','323',3166591.35,3166591.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','242085',4639372,'2136','323',3166591.35,3171307.92,0.00,0.00,4716.57,2872728.80,0.00,0.00,0.00),('1','138','765','242195',4641424,'2136','323',3171307.92,3171464.95,0.00,0.00,157.03,95977.20,0.00,0.00,0.00),('1','138','765','242257',4642358,'2136','323',3171464.95,3171464.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','242267',4642565,'2136','323',3171464.95,3175838.71,0.00,0.00,4373.76,2675859.50,0.00,0.00,0.00),('1','138','765','242419',4645329,'2136','323',3175838.71,3176845.66,0.00,0.00,1006.95,614109.80,0.00,0.00,0.00),('1','138','765','242555',4647653,'2136','323',3176845.66,3176845.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','242556',4647654,'2136','323',3176845.66,3180737.72,0.00,0.00,3892.06,2370584.36,0.00,0.00,0.00),('1','138','765','242674',4649745,'2136','323',3180737.72,3185849.29,0.00,0.00,5111.57,3125316.46,0.00,0.00,0.00),('1','138','765','242909',4653748,'2136','323',3185849.29,3191756.08,0.00,0.00,5906.79,3573145.60,0.00,0.00,0.00),('1','138','765','243147',4657789,'2136','323',3191756.08,3197045.48,0.00,0.00,5289.40,3204976.00,0.00,0.00,0.00),('1','138','765','243358',4661763,'2136','323',3197045.48,3201323.80,0.00,0.00,4278.32,2585618.80,0.00,0.00,0.00),('1','138','765','243592',4665718,'2136','323',3201323.80,3201564.47,0.00,0.00,240.67,145602.00,0.00,0.00,0.00),('1','138','765','243635',4666298,'2136','323',3201564.47,3201564.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','243640',4666375,'2136','323',3201564.47,3205921.06,0.00,0.00,4356.59,2635158.80,0.00,0.00,0.00),('1','138','765','243826',4669837,'2136','323',3205921.06,3210734.38,0.00,0.00,4813.32,2906227.60,0.00,0.00,0.00),('1','138','765','244038',4673547,'2136','323',3210734.38,3215925.55,0.00,0.00,5191.17,3142042.80,0.00,0.00,0.00),('1','138','765','244279',4677555,'2136','323',3215925.55,3219639.08,0.00,0.00,3713.53,2255332.80,0.00,0.00,0.00),('1','138','765','244509',4681607,'2136','323',3219639.08,3223345.93,0.00,0.00,3706.85,2258037.20,0.00,0.00,0.00),('1','138','765','244740',4685433,'2136','323',3223345.93,3226137.32,0.00,0.00,2791.39,1677933.60,0.00,0.00,0.00),('1','138','765','244850',4687458,'2136','323',3226137.32,3226137.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','244852',4687483,'2136','323',3226137.32,3226137.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','244861',4687639,'2136','323',3226137.32,3227600.83,0.00,0.00,1463.51,893333.20,0.00,0.00,0.00),('1','138','765','244988',4689729,'2136','323',3227600.83,3234714.22,0.00,0.00,7113.39,4211606.88,0.00,0.00,0.00),('1','138','765','245214',4693832,'2136','323',3234714.22,3243132.85,0.00,0.00,8418.63,4980171.32,0.00,0.00,0.00),('1','138','765','245442',4697735,'2136','323',3243132.85,3248585.61,0.00,0.00,5452.76,3242594.32,0.00,0.00,0.00),('1','138','765','245668',4701785,'2136','323',3248585.61,3250855.37,0.00,0.00,2269.76,1345497.88,0.00,0.00,0.00),('1','138','765','245778',4703626,'2136','323',3250855.37,3250855.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','245781',4703655,'2136','323',3250855.37,3255799.66,0.00,0.00,4944.29,2918333.28,0.00,0.00,0.00),('1','138','765','245873',4704935,'2136','323',3255799.66,3255799.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','245934',4705808,'2136','323',3255799.66,3261124.91,0.00,0.00,5325.25,3019709.20,0.00,0.00,0.00),('1','138','765','246089',4708506,'2136','323',3261124.91,3261124.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','246095',4708566,'2136','323',3261124.91,3263916.54,0.00,0.00,2791.63,1597184.08,0.00,0.00,0.00),('1','138','765','246187',4710036,'2136','323',3263916.54,3266150.11,0.00,0.00,2233.57,1272079.32,0.00,0.00,0.00),('1','138','765','246368',4712966,'2136','323',3266150.11,3266150.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','246439',4714405,'2136','323',3266150.11,3271152.29,0.00,0.00,5002.18,2846009.28,0.00,0.00,0.00),('1','138','765','246629',4717744,'2136','323',3271152.29,3271152.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','246634',4717820,'2136','323',3271152.29,3272247.22,0.00,0.00,1094.93,626636.88,0.00,0.00,0.00),('1','138','765','246692',4718708,'2136','323',3272247.22,3275838.04,0.00,0.00,3590.82,2038448.60,0.00,0.00,0.00),('1','138','765','246958',4723273,'2136','323',3275838.04,3276245.04,0.00,0.00,407.00,229808.00,0.00,0.00,0.00),('1','138','765','246981',4723620,'2136','323',3276245.04,3276245.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','246999',4723949,'2136','323',3276245.04,3281269.13,0.00,0.00,5024.09,2875776.28,0.00,0.00,0.00),('1','138','765','247120',4726196,'2136','323',3281269.13,3281269.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','247236',4728059,'2136','323',3281269.13,3286369.49,0.00,0.00,5100.36,2912615.36,0.00,0.00,0.00),('1','138','765','247402',4731065,'2136','323',3286369.49,3289068.03,0.00,0.00,2698.54,1565814.64,0.00,0.00,0.00),('1','138','765','247665',4735497,'2136','323',3289068.03,3293020.30,0.00,0.00,3952.27,2247523.08,0.00,0.00,0.00),('1','138','765','247899',4739529,'2136','323',3293020.30,3300296.77,0.00,0.00,7276.47,4068224.76,0.00,0.00,0.00),('1','138','765','248148',4743755,'2136','323',3300296.77,3305803.27,0.00,0.00,5506.50,3091608.40,0.00,0.00,0.00),('1','138','765','248333',4746931,'2136','323',3305803.27,3305803.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','248336',4746994,'2136','323',3305803.27,3305803.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','248401',4747981,'2136','323',3305803.27,3313879.27,0.00,0.00,8076.00,4519068.84,0.00,0.00,0.00),('1','138','765','248633',4751894,'2136','323',3313879.27,3320758.48,0.00,0.00,6879.21,3843662.96,0.00,0.00,0.00),('1','138','765','248884',4756115,'2136','323',3320758.48,3326550.73,0.00,0.00,5792.25,3130980.94,0.00,0.00,0.00),('1','138','765','249097',4759763,'2136','323',3326550.73,3330517.79,0.00,0.00,3967.06,2110952.52,0.00,0.00,0.00),('1','138','765','249245',4762304,'2136','323',3330517.79,3330517.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','249248',4762340,'2136','323',3330517.79,3332413.42,0.00,0.00,1895.63,1023446.96,0.00,0.00,0.00),('1','138','765','249335',4763867,'2136','323',3332413.42,3337653.04,0.00,0.00,5239.62,2805344.20,0.00,0.00,0.00),('1','138','765','249588',4768039,'2136','323',3337653.04,3343314.89,0.00,0.00,5661.85,3039817.20,0.00,0.00,0.00),('1','138','765','249844',4772437,'2136','323',3343314.89,3349428.64,0.00,0.00,6113.75,3283437.48,0.00,0.00,0.00),('1','138','765','250117',4776751,'2136','323',3349428.64,3354870.96,0.00,0.00,5442.32,2894662.14,0.00,0.00,0.00),('1','138','765','250256',4779293,'2136','323',3354870.96,3354870.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','250260',4779354,'2136','323',3354870.96,3354870.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','250261',4779355,'2136','323',3354870.96,3355866.56,0.00,0.00,995.60,538369.20,0.00,0.00,0.00),('1','138','765','250338',4780672,'2136','323',3355866.56,3362489.42,0.00,0.00,6622.86,3533742.84,0.00,0.00,0.00),('1','138','765','250571',4784429,'2136','323',3362489.42,3366375.97,0.00,0.00,3886.55,2090383.94,0.00,0.00,0.00),('1','138','765','250807',4788550,'2136','323',3366375.97,3373112.73,0.00,0.00,6736.76,3614881.92,0.00,0.00,0.00),('1','138','765','251057',4792960,'2136','323',3373112.73,3377612.51,0.00,0.00,4499.78,2432950.76,0.00,0.00,0.00),('1','138','765','251276',4796817,'2136','323',3377612.51,3379556.76,0.00,0.00,1944.25,1052183.50,0.00,0.00,0.00),('1','138','765','251382',4798591,'2136','323',3379556.76,3379556.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','251389',4798699,'2136','323',3379556.76,3382457.82,0.00,0.00,2901.06,1570878.50,0.00,0.00,0.00),('1','138','765','251531',4801068,'2136','323',3382457.82,3388087.98,0.00,0.00,5630.16,3028122.12,0.00,0.00,0.00),('1','138','765','251764',4805378,'2136','323',3388087.98,3394045.29,0.00,0.00,5957.31,3202787.40,0.00,0.00,0.00),('1','138','765','251993',4809360,'2136','323',3394045.29,3398857.26,0.00,0.00,4811.97,2608070.44,0.00,0.00,0.00),('1','138','765','252238',4813567,'2136','323',3398857.26,3404170.41,0.00,0.00,5313.15,2846503.40,0.00,0.00,0.00),('1','138','765','252402',4816640,'2136','323',3404170.41,3404170.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','252403',4816641,'2136','323',3404170.41,3404170.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','252532',4818782,'2136','323',3404170.41,3409173.80,0.00,0.00,5003.39,2672958.50,0.00,0.00,0.00),('1','138','765','252633',4820623,'2136','323',3409173.80,3409173.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','252757',4822516,'2136','323',3409173.80,3414160.30,0.00,0.00,4986.50,2701797.20,0.00,0.00,0.00),('1','138','765','252880',4824709,'2136','323',3414160.30,3414160.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','252977',4826190,'2136','323',3414160.30,3418161.66,0.00,0.00,4001.36,2182833.68,0.00,0.00,0.00),('1','138','765','253198',4830192,'2136','323',3418161.66,3419525.39,0.00,0.00,1363.73,737050.16,0.00,0.00,0.00),('1','138','765','253339',4832304,'2136','323',3419525.39,3419525.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','253340',4832305,'2136','323',3419525.39,3423158.37,0.00,0.00,3632.98,1939704.16,0.00,0.00,0.00),('1','138','765','253476',4834799,'2136','323',3423158.37,3428132.79,0.00,0.00,4974.42,2665706.64,0.00,0.00,0.00),('1','138','765','253724',4838839,'2136','323',3428132.79,3433042.28,0.00,0.00,4909.49,2626940.08,0.00,0.00,0.00),('1','138','765','253966',4843118,'2136','323',3433042.28,3436123.21,0.00,0.00,3080.93,1671109.80,0.00,0.00,0.00),('1','138','765','254200',4847417,'2136','323',3436123.21,3443315.96,0.00,0.00,7192.75,3825430.00,0.00,0.00,0.00),('1','138','765','254454',4851774,'2136','323',3443315.96,3444321.26,0.00,0.00,1005.30,532611.60,0.00,0.00,0.00),('1','138','765','254543',4853332,'2136','323',3444321.26,3444321.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','254546',4853375,'2136','323',3444321.26,3447731.31,0.00,0.00,3410.05,1835508.64,0.00,0.00,0.00),('1','138','765','254704',4856118,'2136','323',3447731.31,3453481.99,0.00,0.00,5750.68,3075964.68,0.00,0.00,0.00),('1','138','765','254955',4860368,'2136','323',3453481.99,3458417.89,0.00,0.00,4935.90,2640079.60,0.00,0.00,0.00),('1','138','765','255203',4864571,'2136','323',3458417.89,3462427.64,0.00,0.00,4009.75,2160603.56,0.00,0.00,0.00),('1','138','765','255448',4869028,'2136','323',3462427.64,3469109.80,0.00,0.00,6682.16,3562040.80,0.00,0.00,0.00),('1','138','765','255671',4872716,'2136','323',3469109.80,3469109.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','255768',4873970,'2136','323',3469109.80,3473417.17,0.00,0.00,4307.37,2310728.52,0.00,0.00,0.00),('1','138','765','255939',4876965,'2136','323',3473417.17,3474420.95,0.00,0.00,1003.78,534268.56,0.00,0.00,0.00),('1','138','765','256085',4879438,'2136','323',3474420.95,3474420.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','256118',4880015,'2136','323',3474420.95,3475977.75,0.00,0.00,1556.80,864161.52,0.00,0.00,0.00),('1','138','765','256218',4881278,'2136','323',3475977.75,3479759.35,0.00,0.00,3781.60,2036811.80,0.00,0.00,0.00),('1','138','765','256478',4885956,'2136','323',3479759.35,3485042.09,0.00,0.00,5282.74,2821404.40,0.00,0.00,0.00),('1','138','765','256725',4889969,'2136','323',3485042.09,3489079.50,0.00,0.00,4037.41,2168917.24,0.00,0.00,0.00),('1','138','765','256964',4894128,'2136','323',3489079.50,3494284.70,0.00,0.00,5205.20,2793737.12,0.00,0.00,0.00),('1','138','765','257233',4899044,'2136','323',3494284.70,3498426.39,0.00,0.00,4141.69,2188513.28,0.00,0.00,0.00),('1','138','765','257397',4902093,'2136','323',3498426.39,3498426.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257400',4902126,'2136','323',3498426.39,3503073.55,0.00,0.00,4647.16,2464396.72,0.00,0.00,0.00),('1','138','765','257483',4903468,'2136','323',3503073.55,3507985.61,0.00,0.00,4912.06,2585400.72,0.00,0.00,0.00),('1','138','765','257484',4903469,'2136','323',3507985.61,3517542.71,0.00,0.00,9557.10,4981336.04,0.00,0.00,0.00),('1','138','765','257485',4903470,'2136','323',3517542.71,3522787.58,0.00,0.00,5244.87,2707478.46,0.00,0.00,0.00),('1','138','765','257486',4903471,'2136','323',3522787.58,3522787.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257487',4903472,'2136','323',3522787.58,3522787.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257488',4903473,'2136','323',3522787.58,3524885.05,0.00,0.00,2097.47,1099589.96,0.00,0.00,0.00),('1','138','765','257489',4903474,'2136','323',3524885.05,3527769.25,0.00,0.00,2884.20,1495993.60,0.00,0.00,0.00),('1','138','765','257490',4903475,'2136','323',3527769.25,3527769.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257491',4903476,'2136','323',3527769.25,3531549.94,0.00,0.00,3780.69,1975953.78,0.00,0.00,0.00),('1','138','765','257492',4903477,'2136','323',3531549.94,3538550.16,0.00,0.00,7000.22,3631715.00,0.00,0.00,0.00),('1','138','765','257493',4903478,'2136','323',3538550.16,3545125.67,0.00,0.00,6575.51,3433650.48,0.00,0.00,0.00),('1','138','765','257494',4903479,'2136','323',3545125.67,3552090.20,0.00,0.00,6964.53,3624206.30,0.00,0.00,0.00),('1','138','765','257495',4903480,'2136','323',3552090.20,3552090.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257496',4903481,'2136','323',3552090.20,3552090.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257497',4903482,'2136','323',3552090.20,3559759.56,0.00,0.00,7669.36,3985603.44,0.00,0.00,0.00),('1','138','765','257498',4903483,'2136','323',3559759.56,3568459.17,0.00,0.00,8699.61,4501800.86,0.00,0.00,0.00),('1','138','765','257499',4903484,'2136','323',3568459.17,3573657.91,0.00,0.00,5198.74,2726108.94,0.00,0.00,0.00),('1','138','765','257500',4903485,'2136','323',3573657.91,3576493.44,0.00,0.00,2835.53,1472461.88,0.00,0.00,0.00),('1','138','765','257501',4903486,'2136','323',3576493.44,3576493.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257502',4903487,'2136','323',3576493.44,3576493.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257503',4903488,'2136','323',3576493.44,3579426.72,0.00,0.00,2933.28,1539743.04,0.00,0.00,0.00),('1','138','765','257504',4903489,'2136','323',3579426.72,3581747.82,0.00,0.00,2321.10,1209141.78,0.00,0.00,0.00),('1','138','765','257505',4903490,'2136','323',3581747.82,3581747.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257506',4903491,'2136','323',3581747.82,3584819.08,0.00,0.00,3071.26,1605285.68,0.00,0.00,0.00),('1','138','765','257507',4903492,'2136','323',3584819.08,3586579.65,0.00,0.00,1760.57,915993.96,0.00,0.00,0.00),('1','138','765','257508',4903493,'2136','323',3586579.65,3586579.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257509',4903494,'2136','323',3586579.65,3589734.90,0.00,0.00,3155.25,1651075.02,0.00,0.00,0.00),('1','138','765','257510',4903495,'2136','323',3589734.90,3593436.77,0.00,0.00,3701.87,1917576.16,0.00,0.00,0.00),('1','138','765','257511',4903496,'2136','323',3593436.77,3601163.85,0.00,0.00,7727.08,4011477.46,0.00,0.00,0.00),('1','138','765','257512',4903497,'2136','323',3601163.85,3606266.49,0.00,0.00,5102.64,2660272.94,0.00,0.00,0.00),('1','138','765','257513',4903498,'2136','323',3606266.49,3611044.26,0.00,0.00,4777.77,2472956.36,0.00,0.00,0.00),('1','138','765','257514',4903499,'2136','323',3611044.26,3611044.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257515',4903500,'2136','323',3611044.26,3616529.92,0.00,0.00,5485.66,2836255.48,0.00,0.00,0.00),('1','138','765','257516',4903501,'2136','323',3616529.92,3616529.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257517',4903502,'2136','323',3616529.92,3617168.89,0.00,0.00,638.97,348435.96,0.00,0.00,0.00),('1','138','765','257518',4903503,'2136','323',3617168.89,3621891.49,0.00,0.00,4722.60,2456347.80,0.00,0.00,0.00),('1','138','765','257519',4903504,'2136','323',3621891.49,3621891.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257520',4903505,'2136','323',3621891.49,3623095.78,0.00,0.00,1204.29,646911.72,0.00,0.00,0.00),('1','138','765','257521',4903506,'2136','323',3623095.78,3627126.70,0.00,0.00,4030.92,2092764.94,0.00,0.00,0.00),('1','138','765','257522',4903507,'2136','323',3627126.70,3627126.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257523',4903508,'2136','323',3627126.70,3628383.37,0.00,0.00,1256.67,661624.56,0.00,0.00,0.00),('1','138','765','257524',4903509,'2136','323',3628383.37,3632126.25,0.00,0.00,3742.88,1952060.32,0.00,0.00,0.00),('1','138','765','257525',4903510,'2136','323',3632126.25,3632126.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257526',4903511,'2136','323',3632126.25,3635719.41,0.00,0.00,3593.16,1862579.88,0.00,0.00,0.00),('1','138','765','257527',4903512,'2136','323',3635719.41,3637377.36,0.00,0.00,1657.95,857268.20,0.00,0.00,0.00),('1','138','765','257528',4903513,'2136','323',3637377.36,3637377.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257529',4903514,'2136','323',3637377.36,3642118.66,0.00,0.00,4741.30,2478598.40,0.00,0.00,0.00),('1','138','765','257530',4903515,'2136','323',3642118.66,3642767.79,0.00,0.00,649.13,338573.84,0.00,0.00,0.00),('1','138','765','257531',4903516,'2136','323',3642767.79,3642767.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257532',4903517,'2136','323',3642767.79,3649147.36,0.00,0.00,6379.57,3309482.96,0.00,0.00,0.00),('1','138','765','257533',4903518,'2136','323',3649147.36,3655815.12,0.00,0.00,6667.76,3467776.48,0.00,0.00,0.00),('1','138','765','257534',4903519,'2136','323',3655815.12,3662100.58,0.00,0.00,6285.46,3269698.56,0.00,0.00,0.00),('1','138','765','257535',4903520,'2136','323',3662100.58,3666974.93,0.00,0.00,4874.35,2522784.80,0.00,0.00,0.00),('1','138','765','257536',4903521,'2136','323',3666974.93,3666974.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257537',4903522,'2136','323',3666974.93,3667498.97,0.00,0.00,524.04,278255.76,0.00,0.00,0.00),('1','138','765','257538',4903523,'2136','323',3667498.97,3674313.68,0.00,0.00,6814.71,3531187.74,0.00,0.00,0.00),('1','138','765','257539',4903524,'2136','323',3674313.68,3678795.96,0.00,0.00,4482.28,2343977.56,0.00,0.00,0.00),('1','138','765','257540',4903525,'2136','323',3678795.96,3683261.38,0.00,0.00,4465.42,2304974.12,0.00,0.00,0.00),('1','138','765','257541',4903526,'2136','323',3683261.38,3691452.23,0.00,0.00,8190.85,4251824.36,0.00,0.00,0.00),('1','138','765','257542',4903527,'2136','323',3691452.23,3691452.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257543',4903528,'2136','323',3691452.23,3699366.43,0.00,0.00,7914.20,4103667.22,0.00,0.00,0.00),('1','138','765','257544',4903529,'2136','323',3699366.43,3704330.79,0.00,0.00,4964.36,2717556.40,0.00,0.00,0.00),('1','138','765','257545',4903530,'2136','323',3704330.79,3712619.42,0.00,0.00,8288.63,4496336.20,0.00,0.00,0.00),('1','138','765','257546',4903531,'2136','323',3712619.42,3716434.04,0.00,0.00,3814.62,2072911.60,0.00,0.00,0.00),('1','138','765','257547',4903532,'2136','323',3716434.04,3716434.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257548',4903533,'2136','323',3716434.04,3723847.36,0.00,0.00,7413.32,4005895.60,0.00,0.00,0.00),('1','138','765','257549',4903534,'2136','323',3723847.36,3730303.09,0.00,0.00,6455.73,3518301.80,0.00,0.00,0.00),('1','138','765','257550',4903535,'2136','323',3730303.09,3740964.84,0.00,0.00,10661.75,5776116.60,0.00,0.00,0.00),('1','138','765','257551',4903536,'2136','323',3740964.84,3740964.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257552',4903537,'2136','323',3740964.84,3745785.23,0.00,0.00,4820.39,2612891.80,0.00,0.00,0.00),('1','138','765','257553',4903538,'2136','323',3745785.23,3745785.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257554',4903539,'2136','323',3745785.23,3750634.73,0.00,0.00,4849.50,2630760.40,0.00,0.00,0.00),('1','138','765','257555',4903540,'2136','323',3750634.73,3750634.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257556',4903541,'2136','323',3750634.73,3751192.83,0.00,0.00,558.10,304886.00,0.00,0.00,0.00),('1','138','765','257557',4903542,'2136','323',3751192.83,3752802.53,0.00,0.00,1609.70,1030208.00,0.00,0.00,0.00),('1','138','765','257558',4903543,'2136','323',3752802.53,3754698.50,0.00,0.00,1895.97,1213420.80,0.00,0.00,0.00),('1','138','765','257559',4903544,'2136','323',3754698.50,3755675.90,0.00,0.00,977.40,625536.00,0.00,0.00,0.00),('1','138','765','257560',4903545,'2136','323',3755675.90,3755675.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257561',4903546,'2136','323',3755675.90,3756374.50,0.00,0.00,698.60,447104.00,0.00,0.00,0.00),('1','138','765','257562',4903547,'2136','323',3756374.50,3758472.84,0.00,0.00,2098.34,1342937.60,0.00,0.00,0.00),('1','138','765','257563',4903548,'2136','323',3758472.84,3760618.68,0.00,0.00,2145.84,1373337.60,0.00,0.00,0.00),('1','138','765','257564',4903549,'2136','323',3760618.68,3760932.68,0.00,0.00,314.00,200960.00,0.00,0.00,0.00),('1','138','765','257565',4903550,'2136','323',3760932.68,3760932.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257566',4903551,'2136','323',3760932.68,3761854.18,0.00,0.00,921.50,589760.00,0.00,0.00,0.00),('1','138','765','257567',4903552,'2136','323',3761854.18,3763031.03,0.00,0.00,1176.85,784158.00,0.00,0.00,0.00),('1','138','765','257568',4903553,'2136','323',3763031.03,3765089.98,0.00,0.00,2058.95,1352294.00,0.00,0.00,0.00),('1','138','765','257569',4903554,'2136','323',3765089.98,3765901.76,0.00,0.00,811.78,538010.40,0.00,0.00,0.00),('1','138','765','257570',4903555,'2136','323',3765901.76,3765901.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257571',4903556,'2136','323',3765901.76,3766472.78,0.00,0.00,571.02,381413.20,0.00,0.00,0.00),('1','138','765','257572',4903557,'2136','323',3766472.78,3771292.03,0.00,0.00,4819.25,2999730.00,0.00,0.00,0.00),('1','138','765','257573',4903558,'2136','323',3771292.03,3777564.17,0.00,0.00,6272.14,3884907.28,0.00,0.00,0.00),('1','138','765','257574',4903559,'2136','323',3777564.17,3780586.83,0.00,0.00,3022.66,1880103.92,0.00,0.00,0.00),('1','138','765','257575',4903560,'2136','323',3780586.83,3786992.50,0.00,0.00,6405.67,3929989.36,0.00,0.00,0.00),('1','138','765','257576',4903561,'2136','323',3786992.50,3790018.82,0.00,0.00,3026.32,1857143.60,0.00,0.00,0.00),('1','138','765','257577',4903562,'2136','323',3790018.82,3790018.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257578',4903563,'2136','323',3790018.82,3793556.96,0.00,0.00,3538.14,2165032.08,0.00,0.00,0.00),('1','138','765','257579',4903564,'2136','323',3793556.96,3800003.68,0.00,0.00,6446.72,3954424.08,0.00,0.00,0.00),('1','138','765','257580',4903565,'2136','323',3800003.68,3805535.55,0.00,0.00,5531.87,3417955.60,0.00,0.00,0.00),('1','138','765','257581',4903566,'2136','323',3805535.55,3812235.44,0.00,0.00,6699.89,4106720.80,0.00,0.00,0.00),('1','138','765','257582',4903567,'2136','323',3812235.44,3814580.03,0.00,0.00,2344.59,1447153.20,0.00,0.00,0.00),('1','138','765','257583',4903568,'2136','323',3814580.03,3814580.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257584',4903569,'2136','323',3814580.03,3818626.11,0.00,0.00,4046.08,2492647.16,0.00,0.00,0.00),('1','138','765','257585',4903570,'2136','323',3818626.11,3821690.01,0.00,0.00,3063.90,1940927.84,0.00,0.00,0.00),('1','138','765','257586',4903571,'2136','323',3821690.01,3825619.35,0.00,0.00,3929.34,2509742.80,0.00,0.00,0.00),('1','138','765','257587',4903572,'2136','323',3825619.35,3829397.99,0.00,0.00,3778.64,2404861.44,0.00,0.00,0.00),('1','138','765','257588',4903573,'2136','323',3829397.99,3831755.06,0.00,0.00,2357.07,1515412.80,0.00,0.00,0.00),('1','138','765','257589',4903574,'2136','323',3831755.06,3834813.28,0.00,0.00,3058.22,1910978.24,0.00,0.00,0.00),('1','138','765','257590',4903575,'2136','323',3834813.28,3838709.29,0.00,0.00,3896.01,2404469.40,0.00,0.00,0.00),('1','138','765','257591',4903576,'2136','323',3838709.29,3838709.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257592',4903577,'2136','323',3838709.29,3840768.96,0.00,0.00,2059.67,1282744.88,0.00,0.00,0.00),('1','138','765','257593',4903578,'2136','323',3840768.96,3843319.09,0.00,0.00,2550.13,1585949.92,0.00,0.00,0.00),('1','138','765','257594',4903579,'2136','323',3843319.09,3843319.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257595',4903580,'2136','323',3843319.09,3847143.47,0.00,0.00,3824.38,2373350.72,0.00,0.00,0.00),('1','138','765','257596',4903581,'2136','323',3847143.47,3854307.02,0.00,0.00,7163.55,4443355.28,0.00,0.00,0.00),('1','138','765','257597',4903582,'2136','323',3854307.02,3859470.80,0.00,0.00,5163.78,3199436.00,0.00,0.00,0.00),('1','138','765','257598',4903583,'2136','323',3859470.80,3866033.02,0.00,0.00,6562.22,4020051.01,0.00,0.00,0.00),('1','138','765','257599',4903584,'2136','323',3866033.02,3868116.21,0.00,0.00,2083.19,1266283.63,0.00,0.00,0.00),('1','138','765','257600',4903585,'2136','323',3868116.21,3868116.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257601',4903586,'2136','323',3868116.21,3873117.83,0.00,0.00,5001.62,3056254.98,0.00,0.00,0.00),('1','138','765','257602',4903587,'2136','323',3873117.83,3874161.50,0.00,0.00,1043.67,643841.03,0.00,0.00,0.00),('1','138','765','257603',4903588,'2136','323',3874161.50,3874161.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257604',4903589,'2136','323',3874161.50,3878501.07,0.00,0.00,4339.57,2648228.95,0.00,0.00,0.00),('1','138','765','257605',4903590,'2136','323',3878501.07,3881313.83,0.00,0.00,2812.76,1723096.13,0.00,0.00,0.00),('1','138','765','257606',4903591,'2136','323',3881313.83,3881313.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257607',4903592,'2136','323',3881313.83,3882356.49,0.00,0.00,1042.66,656454.24,0.00,0.00,0.00),('1','138','765','257608',4903593,'2136','323',3882356.49,3883929.15,0.00,0.00,1572.66,1044246.24,0.00,0.00,0.00),('1','138','765','257609',4903594,'2136','323',3883929.15,3886305.84,0.00,0.00,2376.69,1578122.16,0.00,0.00,0.00),('1','138','765','257610',4903595,'2136','323',3886305.84,3887235.48,0.00,0.00,929.64,617280.96,0.00,0.00,0.00),('1','138','765','257611',4903596,'2136','323',3887235.48,3887235.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257612',4903597,'2136','323',3887235.48,3888561.20,0.00,0.00,1325.72,880278.08,0.00,0.00,0.00),('1','138','765','257613',4903598,'2136','323',3888561.20,3890226.44,0.00,0.00,1665.24,1105719.36,0.00,0.00,0.00),('1','138','765','257614',4903599,'2136','323',3890226.44,3891348.56,0.00,0.00,1122.12,745087.68,0.00,0.00,0.00),('1','138','765','257615',4903600,'2136','323',3891348.56,3891348.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257616',4903601,'2136','323',3891348.56,3895009.78,0.00,0.00,3661.22,2283894.72,0.00,0.00,0.00),('1','138','765','257617',4903602,'2136','323',3895009.78,3896683.36,0.00,0.00,1673.58,1019251.62,0.00,0.00,0.00),('1','138','765','257618',4903603,'2136','323',3896683.36,3896683.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257619',4903604,'2136','323',3896683.36,3904124.67,0.00,0.00,7441.31,4557486.07,0.00,0.00,0.00),('1','138','765','257620',4903605,'2136','323',3904124.67,3911640.60,0.00,0.00,7515.93,4610576.41,0.00,0.00,0.00),('1','138','765','257621',4903606,'2136','323',3911640.60,3918747.60,0.00,0.00,7107.00,4340968.30,0.00,0.00,0.00),('1','138','765','257622',4903607,'2136','323',3918747.60,3921602.65,0.00,0.00,2855.05,1743553.50,0.00,0.00,0.00),('1','138','765','257623',4903608,'2136','323',3921602.65,3921602.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257624',4903609,'2136','323',3921602.65,3924214.48,0.00,0.00,2611.83,1606077.12,0.00,0.00,0.00),('1','138','765','257625',4903610,'2136','323',3924214.48,3930763.26,0.00,0.00,6548.78,3972613.62,0.00,0.00,0.00),('1','138','765','257626',4903611,'2136','323',3930763.26,3937382.61,0.00,0.00,6619.35,4027630.38,0.00,0.00,0.00),('1','138','765','257627',4903612,'2136','323',3937382.61,3944179.42,0.00,0.00,6796.81,4118348.64,0.00,0.00,0.00),('1','138','765','257628',4903613,'2136','323',3944179.42,3945804.72,0.00,0.00,1625.30,985702.54,0.00,0.00,0.00),('1','138','765','257629',4903614,'2136','323',3945804.72,3945804.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257630',4903615,'2136','323',3945804.72,3951131.57,0.00,0.00,5326.85,3204413.40,0.00,0.00,0.00),('1','138','765','257631',4903616,'2136','323',3951131.57,3951131.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257632',4903617,'2136','323',3951131.57,3953698.66,0.00,0.00,2567.09,1556237.46,0.00,0.00,0.00),('1','138','765','257633',4903618,'2136','323',3953698.66,3960248.13,0.00,0.00,6549.47,3965843.08,0.00,0.00,0.00),('1','138','765','257634',4903619,'2136','323',3960248.13,3970133.20,0.00,0.00,9885.07,5959689.04,0.00,0.00,0.00),('1','138','765','257635',4903620,'2136','323',3970133.20,3970762.80,0.00,0.00,629.60,381028.40,0.00,0.00,0.00),('1','138','765','257636',4903621,'2136','323',3970762.80,3970762.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257637',4903622,'2136','323',3970762.80,3978579.38,0.00,0.00,7816.58,4697802.12,0.00,0.00,0.00),('1','138','765','257638',4903623,'2136','323',3978579.38,3987042.50,0.00,0.00,8463.12,5110204.48,0.00,0.00,0.00),('1','138','765','257639',4903624,'2136','323',3987042.50,3995553.20,0.00,0.00,8510.70,5103226.16,0.00,0.00,0.00),('1','138','765','257640',4903625,'2136','323',3995553.20,3995553.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257641',4903626,'2136','323',3995553.20,3996601.90,0.00,0.00,1048.70,631656.80,0.00,0.00,0.00),('1','138','765','257642',4903627,'2136','323',3996601.90,4005745.48,0.00,0.00,9143.58,5535397.88,0.00,0.00,0.00),('1','138','765','257643',4903628,'2136','323',4005745.48,4020152.68,0.00,0.00,14407.20,8646579.22,0.00,0.00,0.00),('1','138','765','257644',4903629,'2136','323',4020152.68,4020152.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257645',4903630,'2136','323',4020152.68,4029707.32,0.00,0.00,9554.64,5767699.46,0.00,0.00,0.00),('1','138','765','257646',4903631,'2136','323',4029707.32,4039368.72,0.00,0.00,9661.40,5805765.12,0.00,0.00,0.00),('1','138','765','257647',4903632,'2136','323',4039368.72,4044951.90,0.00,0.00,5583.18,3352956.52,0.00,0.00,0.00),('1','138','765','257648',4903633,'2136','323',4044951.90,4044951.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257649',4903634,'2136','323',4044951.90,4050225.00,0.00,0.00,5273.10,3154761.72,0.00,0.00,0.00),('1','138','765','257650',4903635,'2136','323',4050225.00,4057845.20,0.00,0.00,7620.20,4600129.52,0.00,0.00,0.00),('1','138','765','257651',4903636,'2136','323',4057845.20,4064928.25,0.00,0.00,7083.05,4285902.60,0.00,0.00,0.00),('1','138','765','257652',4903637,'2136','323',4064928.25,4069427.40,0.00,0.00,4499.15,2706103.60,0.00,0.00,0.00),('1','138','765','257653',4903638,'2136','323',4069427.40,4069427.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257654',4903639,'2136','323',4069427.40,4074957.94,0.00,0.00,5530.54,3333051.82,0.00,0.00,0.00),('1','138','765','257655',4903640,'2136','323',4074957.94,4074957.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257656',4903641,'2136','323',4074957.94,4079741.71,0.00,0.00,4783.77,2873099.28,0.00,0.00,0.00),('1','138','765','257657',4903642,'2136','323',4079741.71,4079741.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257658',4903643,'2136','323',4079741.71,4080209.53,0.00,0.00,467.82,310632.48,0.00,0.00,0.00),('1','138','765','257659',4903644,'2136','323',4080209.53,4081161.23,0.00,0.00,951.70,631928.80,0.00,0.00,0.00),('1','138','765','257660',4903645,'2136','323',4081161.23,4082733.54,0.00,0.00,1572.31,1044013.84,0.00,0.00,0.00),('1','138','765','257661',4903646,'2136','323',4082733.54,4082733.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257662',4903647,'2136','323',4082733.54,4083711.81,0.00,0.00,978.27,649571.28,0.00,0.00,0.00),('1','138','765','257663',4903648,'2136','323',4083711.81,4084875.61,0.00,0.00,1163.80,772763.20,0.00,0.00,0.00),('1','138','765','257664',4903649,'2136','323',4084875.61,4085908.80,0.00,0.00,1033.19,686038.16,0.00,0.00,0.00),('1','138','765','257665',4903650,'2136','323',4085908.80,4086781.24,0.00,0.00,872.44,593259.20,0.00,0.00,0.00),('1','138','765','257666',4903651,'2136','323',4086781.24,4086781.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257667',4903652,'2136','323',4086781.24,4088277.60,0.00,0.00,1496.36,1017524.80,0.00,0.00,0.00),('1','138','765','257668',4903653,'2136','323',4088277.60,4089265.32,0.00,0.00,987.72,671649.60,0.00,0.00,0.00),('1','138','765','257669',4903654,'2136','323',4089265.32,4089265.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257670',4903655,'2136','323',4089265.32,4090481.28,0.00,0.00,1215.96,826852.80,0.00,0.00,0.00),('1','138','765','257671',4903656,'2136','323',4090481.28,4092106.69,0.00,0.00,1625.41,1105278.80,0.00,0.00,0.00),('1','138','765','257672',4903657,'2136','323',4092106.69,4092106.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257673',4903658,'2136','323',4092106.69,4093200.70,0.00,0.00,1094.01,743926.80,0.00,0.00,0.00),('1','138','765','257674',4903659,'2136','323',4093200.70,4095305.64,0.00,0.00,2104.94,1431359.20,0.00,0.00,0.00),('1','138','765','257675',4903660,'2136','323',4095305.64,4097461.46,0.00,0.00,2155.82,1465957.60,0.00,0.00,0.00),('1','138','765','257676',4903661,'2136','323',4097461.46,4097461.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257677',4903662,'2136','323',4097461.46,4099634.45,0.00,0.00,2172.99,1477633.20,0.00,0.00,0.00),('1','138','765','257678',4903663,'2136','323',4099634.45,4102171.77,0.00,0.00,2537.32,1742934.43,0.00,0.00,0.00),('1','138','765','257679',4903664,'2136','323',4102171.77,4102171.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257680',4903665,'2136','323',4102171.77,4105959.41,0.00,0.00,3787.64,2603741.97,0.00,0.00,0.00),('1','138','765','257681',4903666,'2136','323',4105959.41,4111878.73,0.00,0.00,5919.32,4039108.54,0.00,0.00,0.00),('1','138','765','257682',4903667,'2136','323',4111878.73,4125136.90,0.00,0.00,13258.17,9011901.28,0.00,0.00,0.00),('1','138','765','257683',4903668,'2136','323',4125136.90,4126730.48,0.00,0.00,1593.58,1088725.60,0.00,0.00,0.00),('1','138','765','257684',4903669,'2136','323',4126730.48,4126730.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257685',4903670,'2136','323',4126730.48,4131861.96,0.00,0.00,5131.48,3502345.96,0.00,0.00,0.00),('1','138','765','257686',4903671,'2136','323',4131861.96,4131861.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257687',4903672,'2136','323',4131861.96,4136733.80,0.00,0.00,4871.84,3312414.50,0.00,0.00,0.00),('1','138','765','257688',4903673,'2136','323',4136733.80,4136733.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257689',4903674,'2136','323',4136733.80,4142734.00,0.00,0.00,6000.20,4216667.80,0.00,0.00,0.00),('1','138','765','257690',4903675,'2136','323',4142734.00,4142734.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257691',4903676,'2136','323',4142734.00,4147583.01,0.00,0.00,4849.01,3424073.60,0.00,0.00,0.00),('1','138','765','257692',4903677,'2136','323',4147583.01,4147583.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257693',4903678,'2136','323',4147583.01,4151678.59,0.00,0.00,4095.58,2905361.80,0.00,0.00,0.00),('1','138','765','257694',4903679,'2136','323',4151678.59,4151678.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257695',4903680,'2136','323',4151678.59,4153975.57,0.00,0.00,2296.98,1626814.80,0.00,0.00,0.00),('1','138','765','257696',4903681,'2136','323',4153975.57,4155923.38,0.00,0.00,1947.81,1387995.60,0.00,0.00,0.00),('1','138','765','257697',4903682,'2136','323',4155923.38,4155923.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257698',4903683,'2136','323',4155923.38,4160142.44,0.00,0.00,4219.06,2996703.00,0.00,0.00,0.00),('1','138','765','257699',4903684,'2136','323',4160142.44,4170858.46,0.00,0.00,10716.02,7557819.20,0.00,0.00,0.00),('1','138','765','257700',4903685,'2136','323',4170858.46,4179220.03,0.00,0.00,8361.57,5926959.80,0.00,0.00,0.00),('1','138','765','257701',4903686,'2136','323',4179220.03,4180068.59,0.00,0.00,848.56,644905.60,0.00,0.00,0.00),('1','138','765','257702',4903687,'2136','323',4180068.59,4180768.91,0.00,0.00,700.32,532243.20,0.00,0.00,0.00),('1','138','765','257703',4903688,'2136','323',4180768.91,4180768.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257704',4903689,'2136','323',4180768.91,4181732.53,0.00,0.00,963.62,732351.20,0.00,0.00,0.00),('1','138','765','257705',4903690,'2136','323',4181732.53,4182667.49,0.00,0.00,934.96,710569.60,0.00,0.00,0.00),('1','138','765','257706',4903691,'2136','323',4182667.49,4184388.57,0.00,0.00,1721.08,1308020.80,0.00,0.00,0.00),('1','138','765','257707',4903692,'2136','323',4184388.57,4184388.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257708',4903693,'2136','323',4184388.57,4184928.62,0.00,0.00,540.05,410438.00,0.00,0.00,0.00),('1','138','765','257709',4903694,'2136','323',4184928.62,4187158.63,0.00,0.00,2230.01,1694807.60,0.00,0.00,0.00),('1','138','765','257710',4903695,'2136','323',4187158.63,4190123.09,0.00,0.00,2964.46,2252989.60,0.00,0.00,0.00),('1','138','765','257711',4903696,'2136','323',4190123.09,4190123.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257712',4903697,'2136','323',4190123.09,4190123.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257713',4903698,'2136','323',4190123.09,4193108.56,0.00,0.00,2985.47,2268957.20,0.00,0.00,0.00),('1','138','765','257714',4903699,'2136','323',4193108.56,4195234.92,0.00,0.00,2126.36,1616033.60,0.00,0.00,0.00),('1','138','765','257715',4903700,'2136','323',4195234.92,4195234.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257716',4903701,'2136','323',4195234.92,4198579.06,0.00,0.00,3344.14,2541546.40,0.00,0.00,0.00),('1','138','765','257717',4903702,'2136','323',4198579.06,4200184.06,0.00,0.00,1605.00,1219800.00,0.00,0.00,0.00),('1','138','765','257718',4903703,'2136','323',4200184.06,4200184.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257719',4903704,'2136','323',4200184.06,4201991.79,0.00,0.00,1807.73,1373874.80,0.00,0.00,0.00),('1','138','765','257720',4903705,'2136','323',4201991.79,4204464.37,0.00,0.00,2472.58,1879160.80,0.00,0.00,0.00),('1','138','765','257721',4903706,'2136','323',4204464.37,4206084.15,0.00,0.00,1619.78,1231032.80,0.00,0.00,0.00),('1','138','765','257722',4903707,'2136','323',4206084.15,4208177.30,0.00,0.00,2093.15,1590794.00,0.00,0.00,0.00),('1','138','765','257723',4903708,'2136','323',4208177.30,4209680.12,0.00,0.00,1502.82,1142143.20,0.00,0.00,0.00),('1','138','765','257724',4903709,'2136','323',4209680.12,4211296.36,0.00,0.00,1616.24,1228342.40,0.00,0.00,0.00),('1','138','765','257725',4903710,'2136','323',4211296.36,4212664.95,0.00,0.00,1368.59,1040128.40,0.00,0.00,0.00),('1','138','765','257726',4903711,'2136','323',4212664.95,4214215.93,0.00,0.00,1550.98,1178744.80,0.00,0.00,0.00),('1','138','765','257727',4903712,'2136','323',4214215.93,4215301.57,0.00,0.00,1085.64,825086.40,0.00,0.00,0.00),('1','138','765','257728',4903713,'2136','323',4215301.57,4223671.64,0.00,0.00,8370.07,6058883.20,0.00,0.00,0.00),('1','138','765','257729',4903714,'2136','323',4223671.64,4224856.32,0.00,0.00,1184.68,861516.80,0.00,0.00,0.00),('1','138','765','257730',4903715,'2136','323',4224856.32,4224856.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257731',4903716,'2136','323',4224856.32,4229083.91,0.00,0.00,4227.59,3067811.60,0.00,0.00,0.00),('1','138','765','257732',4903717,'2136','323',4229083.91,4233610.75,0.00,0.00,4526.84,3299471.20,0.00,0.00,0.00),('1','138','765','257733',4903718,'2136','323',4233610.75,4237839.03,0.00,0.00,4228.28,3076356.40,0.00,0.00,0.00),('1','138','765','257734',4903719,'2136','323',4237839.03,4243296.97,0.00,0.00,5457.94,3961666.40,0.00,0.00,0.00),('1','138','765','257735',4903720,'2136','323',4243296.97,4249512.86,0.00,0.00,6215.89,4493186.80,0.00,0.00,0.00),('1','138','765','257736',4903721,'2136','323',4249512.86,4249512.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257737',4903722,'2136','323',4249512.86,4253849.09,0.00,0.00,4336.23,3140710.80,0.00,0.00,0.00),('1','138','765','257738',4903723,'2136','323',4253849.09,4253849.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257739',4903724,'2136','323',4253849.09,4254607.02,0.00,0.00,757.93,555506.80,0.00,0.00,0.00),('1','138','765','257740',4903725,'2136','323',4254607.02,4259101.56,0.00,0.00,4494.54,3253502.40,0.00,0.00,0.00),('1','138','765','257741',4903726,'2136','323',4259101.56,4259101.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257742',4903727,'2136','323',4259101.56,4264343.41,0.00,0.00,5241.85,3806228.00,0.00,0.00,0.00),('1','138','765','257743',4903728,'2136','323',4264343.41,4264343.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257744',4903729,'2136','323',4264343.41,4271736.20,0.00,0.00,7392.79,5354102.40,0.00,0.00,0.00),('1','138','765','257745',4903730,'2136','323',4271736.20,4276761.01,0.00,0.00,5024.81,3661105.60,0.00,0.00,0.00),('1','138','765','257746',4903731,'2136','323',4276761.01,4282918.90,0.00,0.00,6157.89,4464402.40,0.00,0.00,0.00),('1','138','765','257747',4903732,'2136','323',4282918.90,4287082.20,0.00,0.00,4163.30,3037348.00,0.00,0.00,0.00),('1','138','765','257748',4903733,'2136','323',4287082.20,4288703.71,0.00,0.00,1621.51,1181207.60,0.00,0.00,0.00),('1','138','765','257749',4903734,'2136','323',4288703.71,4288703.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257750',4903735,'2136','323',4288703.71,4290919.10,0.00,0.00,2215.39,1620129.20,0.00,0.00,0.00),('1','138','765','257751',4903736,'2136','323',4290919.10,4294317.52,0.00,0.00,3398.42,2492708.00,0.00,0.00,0.00),('1','138','765','257752',4903737,'2136','323',4294317.52,4297268.37,0.00,0.00,2950.85,2154562.00,0.00,0.00,0.00),('1','138','765','257753',4903738,'2136','323',4297268.37,4303434.72,0.00,0.00,6166.35,4461883.20,0.00,0.00,0.00),('1','138','765','257754',4903739,'2136','323',4303434.72,4306756.89,0.00,0.00,3322.17,2421317.20,0.00,0.00,0.00),('1','138','765','257755',4903740,'2136','323',4306756.89,4307689.53,0.00,0.00,932.64,708806.40,0.00,0.00,0.00),('1','138','765','257756',4903741,'2136','323',4307689.53,4308794.82,0.00,0.00,1105.29,840020.40,0.00,0.00,0.00),('1','138','765','257757',4903742,'2136','323',4308794.82,4310099.57,0.00,0.00,1304.75,991610.00,0.00,0.00,0.00),('1','138','765','257758',4903743,'2136','323',4310099.57,4312531.93,0.00,0.00,2432.36,1848593.60,0.00,0.00,0.00),('1','138','765','257759',4903744,'2136','323',4312531.93,4313042.21,0.00,0.00,510.28,387812.80,0.00,0.00,0.00),('1','138','765','257760',4903745,'2136','323',4313042.21,4313042.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257761',4903746,'2136','323',4313042.21,4314443.56,0.00,0.00,1401.35,1065026.00,0.00,0.00,0.00),('1','138','765','257762',4903747,'2136','323',4314443.56,4316131.40,0.00,0.00,1687.84,1282758.40,0.00,0.00,0.00),('1','138','765','257763',4903748,'2136','323',4316131.40,4318455.75,0.00,0.00,2324.35,1687524.00,0.00,0.00,0.00),('1','138','765','257764',4903749,'2136','323',4318455.75,4318455.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257765',4903750,'2136','323',4318455.75,4319894.89,0.00,0.00,1439.14,1053466.40,0.00,0.00,0.00),('1','138','765','257766',4903751,'2136','323',4319894.89,4325277.58,0.00,0.00,5382.69,3890228.40,0.00,0.00,0.00),('1','138','765','257767',4903752,'2136','323',4325277.58,4329318.84,0.00,0.00,4041.26,2914051.20,0.00,0.00,0.00),('1','138','765','257768',4903753,'2136','323',4329318.84,4332113.14,0.00,0.00,2794.30,2033452.00,0.00,0.00,0.00),('1','138','765','257769',4903754,'2136','323',4332113.14,4335219.13,0.00,0.00,3105.99,2258792.40,0.00,0.00,0.00),('1','138','765','257770',4903755,'2136','323',4335219.13,4340349.08,0.00,0.00,5129.95,3622481.80,0.00,0.00,0.00),('1','138','765','257771',4903756,'2136','323',4340349.08,4341840.90,0.00,0.00,1491.82,1054617.58,0.00,0.00,0.00),('1','138','765','257772',4903757,'2136','323',4341840.90,4341840.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257773',4903758,'2136','323',4341840.90,4341840.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257774',4903759,'2136','323',4341840.90,4345078.52,0.00,0.00,3237.62,2272436.98,0.00,0.00,0.00),('1','138','765','257775',4903760,'2136','323',4345078.52,4351510.43,0.00,0.00,6431.91,4517022.35,0.00,0.00,0.00),('1','138','765','257776',4903761,'2136','323',4351510.43,4356677.75,0.00,0.00,5167.32,3631824.98,0.00,0.00,0.00),('1','138','765','257777',4903762,'2136','323',4356677.75,4363337.68,0.00,0.00,6659.93,4632716.55,0.00,0.00,0.00),('1','138','765','257778',4903763,'2136','323',4363337.68,4366450.31,0.00,0.00,3112.63,2190563.01,0.00,0.00,0.00),('1','138','765','257779',4903764,'2136','323',4366450.31,4366450.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257780',4903765,'2136','323',4366450.31,4369034.62,0.00,0.00,2584.31,1806824.94,0.00,0.00,0.00),('1','138','765','257781',4903766,'2136','323',4369034.62,4376420.24,0.00,0.00,7385.62,5193466.28,0.00,0.00,0.00),('1','138','765','257782',4903767,'2136','323',4376420.24,4383427.08,0.00,0.00,7006.84,4933635.13,0.00,0.00,0.00),('1','138','765','257783',4903768,'2136','323',4383427.08,4386279.10,0.00,0.00,2852.02,2005766.51,0.00,0.00,0.00),('1','138','765','257784',4903769,'2136','323',4386279.10,4389985.60,0.00,0.00,3706.50,2593763.38,0.00,0.00,0.00),('1','138','765','257785',4903770,'2136','323',4389985.60,4398127.17,0.00,0.00,8141.57,5729321.64,0.00,0.00,0.00),('1','138','765','257786',4903771,'2136','323',4398127.17,4402559.79,0.00,0.00,4432.62,3185855.28,0.00,0.00,0.00),('1','138','765','257787',4903772,'2136','323',4402559.79,4404000.27,0.00,0.00,1440.48,1071717.12,0.00,0.00,0.00),('1','138','765','257788',4903773,'2136','323',4404000.27,4407132.91,0.00,0.00,3132.64,2242361.66,0.00,0.00,0.00),('1','138','765','257789',4903774,'2136','323',4407132.91,4410479.64,0.00,0.00,3346.73,2356195.42,0.00,0.00,0.00),('1','138','765','257790',4903775,'2136','323',4410479.64,4410479.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257791',4903776,'2136','323',4410479.64,4410479.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257792',4903777,'2136','323',4410479.64,4410479.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257793',4903778,'2136','323',4410479.64,4412476.53,0.00,0.00,1996.89,1392167.72,0.00,0.00,0.00),('1','138','765','257794',4903779,'2136','323',4412476.53,4417440.20,0.00,0.00,4963.67,3497758.40,0.00,0.00,0.00),('1','138','765','257795',4903780,'2136','323',4417440.20,4421753.66,0.00,0.00,4313.46,3026105.69,0.00,0.00,0.00),('1','138','765','257796',4903781,'2136','323',4421753.66,4422522.20,0.00,0.00,768.54,569804.36,0.00,0.00,0.00),('1','138','765','257797',4903782,'2136','323',4422522.20,4425255.34,0.00,0.00,2733.14,1939942.60,0.00,0.00,0.00),('1','138','765','257798',4903783,'2136','323',4425255.34,4427770.03,0.00,0.00,2514.69,1877674.36,0.00,0.00,0.00),('1','138','765','257799',4903784,'2136','323',4427770.03,4429106.74,0.00,0.00,1336.71,1010366.80,0.00,0.00,0.00),('1','138','765','257800',4903785,'2136','323',4429106.74,4429549.83,0.00,0.00,443.09,336748.40,0.00,0.00,0.00),('1','138','765','257801',4903786,'2136','323',4429549.83,4431178.34,0.00,0.00,1628.51,1237667.60,0.00,0.00,0.00),('1','138','765','257802',4903787,'2136','323',4431178.34,4431518.38,0.00,0.00,340.04,258430.40,0.00,0.00,0.00),('1','138','765','257803',4903788,'2136','323',4431518.38,4433634.49,0.00,0.00,2116.11,1608243.60,0.00,0.00,0.00),('1','138','765','257804',4903789,'2136','323',4433634.49,4435066.68,0.00,0.00,1432.19,1088464.40,0.00,0.00,0.00),('1','138','765','257805',4903790,'2136','323',4435066.68,4437124.56,0.00,0.00,2057.88,1563988.80,0.00,0.00,0.00),('1','138','765','257806',4903791,'2136','323',4437124.56,4437581.37,0.00,0.00,456.81,347175.60,0.00,0.00,0.00),('1','138','765','257806',4903792,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257806',4903793,'2138','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257806',4903794,'2139','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257807',4903795,'2136','323',4437581.37,4439357.30,0.00,0.00,1775.93,1349706.80,0.00,0.00,0.00),('1','138','765','257807',4903796,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257807',4903797,'2138','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257807',4903798,'2139','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257808',4903799,'2136','323',4439357.30,4441145.60,0.00,0.00,1788.30,1359108.00,0.00,0.00,0.00),('1','138','765','257808',4903800,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257808',4903801,'2138','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257808',4903802,'2139','323',0.00,50.00,0.00,0.00,50.00,38000.00,0.00,0.00,0.00),('1','138','765','257809',4903803,'2136','323',4441145.60,4443559.69,0.00,0.00,2414.09,1739812.18,0.00,0.00,0.00),('1','138','765','257809',4903804,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257809',4903805,'2138','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257809',4903806,'2139','323',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257810',4903807,'2136','323',4443559.69,4443559.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257810',4903808,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257810',4903809,'2138','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257810',4903810,'2139','323',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257811',4903811,'2136','323',4443559.69,4445382.83,0.00,0.00,1823.14,1306883.12,0.00,0.00,0.00),('1','138','765','257811',4903812,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257811',4903813,'2138','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257811',4903814,'2139','323',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257812',4903815,'2136','323',4445382.83,4450281.84,0.00,0.00,4899.01,3518853.32,0.00,0.00,0.00),('1','138','765','257812',4903816,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257812',4903817,'2138','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257812',4903818,'2139','323',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257813',4903819,'2136','323',4450281.84,4457215.32,0.00,0.00,6933.48,4967616.26,0.00,0.00,0.00),('1','138','765','257813',4903820,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257813',4903821,'2138','323',0.00,12.50,0.00,0.00,12.50,9300.00,0.00,0.00,0.00),('1','138','765','257813',4903822,'2139','323',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257814',4903823,'2136','323',4457215.32,4461960.65,0.00,0.00,4745.33,3414441.02,0.00,0.00,0.00),('1','138','765','257814',4903824,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257814',4903825,'2138','323',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257814',4903826,'2139','323',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257815',4903827,'2136','323',4461960.65,4468458.47,0.00,0.00,6497.82,4637972.36,0.00,0.00,0.00),('1','138','765','257815',4903828,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257815',4903829,'2138','323',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257815',4903830,'2139','323',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257816',4903831,'2136','323',4468458.47,4468458.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257816',4903832,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257816',4903833,'2138','323',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257816',4903834,'2139','323',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257817',4903835,'2136','323',4468458.47,4473753.81,0.00,0.00,5295.34,3797068.28,0.00,0.00,0.00),('1','138','765','257817',4903836,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257817',4903837,'2138','323',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257817',4903838,'2139','323',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257818',4903839,'2136','323',4473753.81,4474251.97,0.00,0.00,498.16,354754.06,0.00,0.00,0.00),('1','138','765','257818',4903840,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257818',4903841,'2138','323',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257818',4903842,'2139','323',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257819',4903843,'2136','323',4474251.97,4474251.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257819',4903844,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257819',4903845,'2138','323',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257819',4903846,'2139','323',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257820',4903847,'2136','323',4474251.97,4479378.73,0.00,0.00,5126.76,3672260.58,0.00,0.00,0.00),('1','138','765','257820',4903848,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257820',4903849,'2138','323',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257820',4903850,'2139','323',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257821',4903851,'2136','323',4479378.73,4479378.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257821',4903852,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257821',4903853,'2138','323',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257821',4903854,'2139','323',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257822',4903855,'2136','323',4479378.73,4482347.81,0.00,0.00,2969.08,2156346.52,0.00,0.00,0.00),('1','138','765','257822',4903856,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257822',4903857,'2138','323',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257822',4903858,'2139','323',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257823',4903859,'2136','323',4482347.81,4484060.41,0.00,0.00,1712.60,1274174.40,0.00,0.00,0.00),('1','138','765','257823',4903860,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257823',4903861,'2138','323',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257823',4903862,'2139','323',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257824',4903863,'2136','323',4484060.41,4484060.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257824',4903864,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257824',4903865,'2138','323',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257824',4903866,'2139','323',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257825',4903867,'2136','323',4484060.41,4486010.79,0.00,0.00,1950.38,1418773.88,0.00,0.00,0.00),('1','138','765','257825',4903868,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257825',4903869,'2138','323',12.50,15.86,0.00,0.00,3.36,2499.84,0.00,0.00,0.00),('1','138','765','257825',4903870,'2139','323',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257826',4903871,'2136','323',4486010.79,4491081.23,0.00,0.00,5070.44,3647900.04,0.00,0.00,0.00),('1','138','765','257826',4903872,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257826',4903873,'2138','323',15.86,15.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257826',4903874,'2139','323',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257827',4903875,'2136','323',4491081.23,4495220.60,0.00,0.00,4139.37,2973500.28,0.00,0.00,0.00),('1','138','765','257827',4903876,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257827',4903877,'2138','323',15.86,15.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257827',4903878,'2139','323',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257828',4903879,'2136','323',4495220.60,4499976.79,0.00,0.00,4756.19,3422166.92,0.00,0.00,0.00),('1','138','765','257828',4903880,'2137','323',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257828',4903881,'2138','323',15.86,15.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257828',4903882,'2139','323',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257829',4903883,'2136','323',4499976.79,4504653.97,0.00,0.00,4677.18,3362202.92,0.00,0.00,0.00),('1','138','765','257829',4903884,'2137','323',0.00,57.50,0.00,0.00,57.50,41250.00,0.00,0.00,0.00),('1','138','765','257829',4903885,'2138','323',15.86,15.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257829',4903886,'2139','323',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257830',4903887,'2136','323',4504653.97,4508503.50,0.00,0.00,3849.53,2771645.46,0.00,0.00,0.00),('1','138','765','257830',4903888,'2137','323',57.50,57.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257830',4903889,'2138','323',15.86,15.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257830',4903890,'2139','323',50.00,86.02,0.00,0.00,36.02,26798.88,0.00,0.00,0.00),('1','138','765','257831',4903891,'2136','323',4508503.50,4508503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257831',4903892,'2137','323',57.50,57.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257831',4903893,'2138','323',15.86,15.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257831',4903894,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257832',4903895,'2136','323',4508503.50,4512058.97,0.00,0.00,3555.47,2565460.46,0.00,0.00,0.00),('1','138','765','257832',4903896,'2137','323',57.50,57.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257832',4903897,'2138','323',15.86,15.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257832',4903898,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257833',4903899,'2136','323',4512058.97,4513561.37,0.00,0.00,1502.40,1082324.62,0.00,0.00,0.00),('1','138','765','257833',4903900,'2137','323',57.50,57.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257833',4903901,'2138','323',15.86,15.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257833',4903902,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257834',4903903,'2136','323',4513561.37,4513561.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257834',4903904,'2137','323',57.50,57.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257834',4903905,'2138','323',15.86,15.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257834',4903906,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257835',4903907,'2136','323',4513561.37,4515553.93,0.00,0.00,1992.56,1449365.64,0.00,0.00,0.00),('1','138','765','257835',4903908,'2137','323',57.50,57.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257835',4903909,'2138','323',15.86,28.36,0.00,0.00,12.50,9300.00,0.00,0.00,0.00),('1','138','765','257835',4903910,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257836',4903911,'2136','323',4515553.93,4518886.37,0.00,0.00,3332.44,2397051.62,0.00,0.00,0.00),('1','138','765','257836',4903912,'2137','323',57.50,70.00,0.00,0.00,12.50,9300.00,0.00,0.00,0.00),('1','138','765','257836',4903913,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257836',4903914,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257837',4903915,'2136','323',4518886.37,4518947.81,0.00,0.00,61.44,43622.40,0.00,0.00,0.00),('1','138','765','257837',4903916,'2137','323',70.00,70.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257837',4903917,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257837',4903918,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257838',4903919,'2136','323',4518947.81,4519565.49,0.00,0.00,617.68,442383.92,0.00,0.00,0.00),('1','138','765','257838',4903920,'2137','323',70.00,70.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257838',4903921,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257838',4903922,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257839',4903923,'2136','323',4519565.49,4523785.65,0.00,0.00,4220.16,3047663.12,0.00,0.00,0.00),('1','138','765','257839',4903924,'2137','323',70.00,70.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257839',4903925,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257839',4903926,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257840',4903927,'2136','323',4523785.65,4530799.58,0.00,0.00,7013.93,4965030.20,0.00,0.00,0.00),('1','138','765','257840',4903928,'2137','323',70.00,70.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257840',4903929,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257840',4903930,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257841',4903931,'2136','323',4530799.58,4537154.62,0.00,0.00,6355.04,4491227.92,0.00,0.00,0.00),('1','138','765','257841',4903932,'2137','323',70.00,70.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257841',4903933,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257841',4903934,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257842',4903935,'2136','323',4537154.62,4542556.41,0.00,0.00,5401.79,3843849.60,0.00,0.00,0.00),('1','138','765','257842',4903936,'2137','323',70.00,70.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257842',4903937,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257842',4903938,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257843',4903939,'2136','323',4542556.41,4543320.99,0.00,0.00,764.58,568847.52,0.00,0.00,0.00),('1','138','765','257843',4903940,'2137','323',70.00,70.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257843',4903941,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257843',4903942,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257844',4903943,'2136','323',4543320.99,4543320.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257844',4903944,'2137','323',70.00,70.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257844',4903945,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257844',4903946,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257845',4903947,'2136','323',4543320.99,4544802.29,0.00,0.00,1481.30,1102087.20,0.00,0.00,0.00),('1','138','765','257845',4903948,'2137','323',70.00,70.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257845',4903949,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257845',4903950,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257846',4903951,'2136','323',4544802.29,4545947.29,0.00,0.00,1145.00,851880.00,0.00,0.00,0.00),('1','138','765','257846',4903952,'2137','323',70.00,70.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257846',4903953,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257846',4903954,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257847',4903955,'2136','323',4545947.29,4545947.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257847',4903956,'2137','323',70.00,70.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257847',4903957,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257847',4903958,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257848',4903959,'2136','323',4545947.29,4547231.86,0.00,0.00,1284.57,955720.08,0.00,0.00,0.00),('1','138','765','257848',4903960,'2137','323',70.00,70.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257848',4903961,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257848',4903962,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257849',4903963,'2136','323',4547231.86,4549149.42,0.00,0.00,1917.56,1426664.64,0.00,0.00,0.00),('1','138','765','257849',4903964,'2137','323',70.00,70.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257849',4903965,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257849',4903966,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257850',4903967,'2136','323',4549149.42,4550539.87,0.00,0.00,1390.45,1034494.80,0.00,0.00,0.00),('1','138','765','257850',4903968,'2137','323',70.00,70.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257850',4903969,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257850',4903970,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257851',4903971,'2136','323',4550539.87,4550539.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257851',4903972,'2137','323',70.00,70.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257851',4903973,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257851',4903974,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257852',4903975,'2136','323',4550539.87,4551826.50,0.00,0.00,1286.63,957252.72,0.00,0.00,0.00),('1','138','765','257852',4903976,'2137','323',70.00,74.50,0.00,0.00,4.50,3348.00,0.00,0.00,0.00),('1','138','765','257852',4903977,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257852',4903978,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257853',4903979,'2136','323',4551826.50,4553490.71,0.00,0.00,1664.21,1238172.24,0.00,0.00,0.00),('1','138','765','257853',4903980,'2137','323',74.50,74.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257853',4903981,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257853',4903982,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257854',4903983,'2136','323',4553490.71,4554654.22,0.00,0.00,1163.51,865651.44,0.00,0.00,0.00),('1','138','765','257854',4903984,'2137','323',74.50,74.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257854',4903985,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257854',4903986,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257855',4903987,'2136','323',4554654.22,4554654.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257855',4903988,'2137','323',74.50,74.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257855',4903989,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257855',4903990,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257856',4903991,'2136','323',4554654.22,4554919.86,0.00,0.00,265.64,197636.16,0.00,0.00,0.00),('1','138','765','257856',4903992,'2137','323',74.50,74.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257856',4903993,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257856',4903994,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257857',4903995,'2136','323',4554919.86,4556687.12,0.00,0.00,1767.26,1314841.44,0.00,0.00,0.00),('1','138','765','257857',4903996,'2137','323',74.50,87.00,0.00,0.00,12.50,9300.00,0.00,0.00,0.00),('1','138','765','257857',4903997,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257857',4903998,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257858',4903999,'2136','323',4556687.12,4557592.82,0.00,0.00,905.70,673840.80,0.00,0.00,0.00),('1','138','765','257858',4904000,'2137','323',87.00,87.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257858',4904001,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257858',4904002,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257859',4904003,'2136','323',4557592.82,4557592.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257859',4904004,'2137','323',87.00,87.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257859',4904005,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257859',4904006,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257860',4904007,'2136','323',4557592.82,4559168.56,0.00,0.00,1575.74,1172350.56,0.00,0.00,0.00),('1','138','765','257860',4904008,'2137','323',87.00,87.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257860',4904009,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257860',4904010,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257861',4904011,'2136','323',4559168.56,4560413.53,0.00,0.00,1244.97,926257.68,0.00,0.00,0.00),('1','138','765','257861',4904012,'2137','323',87.00,87.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257861',4904013,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257861',4904014,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257862',4904015,'2136','323',4560413.53,4562371.76,0.00,0.00,1958.23,1456923.12,0.00,0.00,0.00),('1','138','765','257862',4904016,'2137','323',87.00,87.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257862',4904017,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257862',4904018,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257863',4904019,'2136','323',4562371.76,4562585.44,0.00,0.00,213.68,158977.92,0.00,0.00,0.00),('1','138','765','257863',4904020,'2137','323',87.00,87.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257863',4904021,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257863',4904022,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257864',4904023,'2136','323',4562585.44,4562585.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257864',4904024,'2137','323',87.00,87.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257864',4904025,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257864',4904026,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257865',4904027,'2136','323',4562585.44,4563225.08,0.00,0.00,639.64,475892.16,0.00,0.00,0.00),('1','138','765','257865',4904028,'2137','323',87.00,87.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257865',4904029,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257865',4904030,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257866',4904031,'2136','323',4563225.08,4565380.18,0.00,0.00,2155.10,1603394.40,0.00,0.00,0.00),('1','138','765','257866',4904032,'2137','323',87.00,87.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257866',4904033,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257866',4904034,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257867',4904035,'2136','323',4565380.18,4566896.85,0.00,0.00,1516.67,1124829.44,0.00,0.00,0.00),('1','138','765','257867',4904036,'2137','323',87.00,99.50,0.00,0.00,12.50,9300.00,0.00,0.00,0.00),('1','138','765','257867',4904037,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257867',4904038,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257868',4904039,'2136','323',4566896.85,4567577.90,0.00,0.00,681.05,501252.80,0.00,0.00,0.00),('1','138','765','257868',4904040,'2137','323',99.50,99.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257868',4904041,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257868',4904042,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257869',4904043,'2136','323',4567577.90,4567577.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257869',4904044,'2137','323',99.50,99.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257869',4904045,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257869',4904046,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257870',4904047,'2136','323',4567577.90,4570762.93,0.00,0.00,3185.03,2284682.72,0.00,0.00,0.00),('1','138','765','257870',4904048,'2137','323',99.50,99.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257870',4904049,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257870',4904050,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257871',4904051,'2136','323',4570762.93,4575302.61,0.00,0.00,4539.68,3223207.32,0.00,0.00,0.00),('1','138','765','257871',4904052,'2137','323',99.50,112.00,0.00,0.00,12.50,9200.00,0.00,0.00,0.00),('1','138','765','257871',4904053,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257871',4904054,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257872',4904055,'2136','323',4575302.61,4579901.16,0.00,0.00,4598.55,3260033.68,0.00,0.00,0.00),('1','138','765','257872',4904056,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257872',4904057,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257872',4904058,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257873',4904059,'2136','323',4579901.16,4586552.89,0.00,0.00,6651.73,4698660.08,0.00,0.00,0.00),('1','138','765','257873',4904060,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257873',4904061,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257873',4904062,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257874',4904063,'2136','323',4586552.89,4591547.93,0.00,0.00,4995.04,3546452.08,0.00,0.00,0.00),('1','138','765','257874',4904064,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257874',4904065,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257874',4904066,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257875',4904067,'2136','323',4591547.93,4592141.19,0.00,0.00,593.26,422347.36,0.00,0.00,0.00),('1','138','765','257875',4904068,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257875',4904069,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257875',4904070,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257876',4904071,'2136','323',4592141.19,4592141.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257876',4904072,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257876',4904073,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257876',4904074,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257877',4904075,'2136','323',4592141.19,4594747.23,0.00,0.00,2606.04,1860287.36,0.00,0.00,0.00),('1','138','765','257877',4904076,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257877',4904077,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257877',4904078,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257878',4904079,'2136','323',4594747.23,4596936.49,0.00,0.00,2189.26,1611295.36,0.00,0.00,0.00),('1','138','765','257878',4904080,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257878',4904081,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257878',4904082,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257879',4904083,'2136','323',4596936.49,4597566.48,0.00,0.00,629.99,463672.64,0.00,0.00,0.00),('1','138','765','257879',4904084,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257879',4904085,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257879',4904086,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257880',4904087,'2136','323',4597566.48,4597566.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257880',4904088,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257880',4904089,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257880',4904090,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257881',4904091,'2136','323',4597566.48,4597896.67,0.00,0.00,330.19,243019.84,0.00,0.00,0.00),('1','138','765','257881',4904092,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257881',4904093,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257881',4904094,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257882',4904095,'2136','323',4597896.67,4599233.84,0.00,0.00,1337.17,984157.12,0.00,0.00,0.00),('1','138','765','257882',4904096,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257882',4904097,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257882',4904098,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257883',4904099,'2136','323',4599233.84,4601765.08,0.00,0.00,2531.24,1862992.64,0.00,0.00,0.00),('1','138','765','257883',4904100,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257883',4904101,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257883',4904102,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257884',4904103,'2136','323',4601765.08,4601765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257884',4904104,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257884',4904105,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257884',4904106,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257885',4904107,'2136','323',4601765.08,4604960.01,0.00,0.00,3194.93,2440926.52,0.00,0.00,0.00),('1','138','765','257885',4904108,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257885',4904109,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257885',4904110,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257886',4904111,'2136','323',4604960.01,4606366.52,0.00,0.00,1406.51,1052069.48,0.00,0.00,0.00),('1','138','765','257886',4904112,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257886',4904113,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257886',4904114,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257887',4904115,'2136','323',4606366.52,4606366.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257887',4904116,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257887',4904117,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257887',4904118,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257888',4904119,'2136','323',4606366.52,4607257.90,0.00,0.00,891.38,666752.24,0.00,0.00,0.00),('1','138','765','257888',4904120,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257888',4904121,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257888',4904122,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257889',4904123,'2136','323',4607257.90,4611596.98,0.00,0.00,4339.08,3245631.84,0.00,0.00,0.00),('1','138','765','257889',4904124,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257889',4904125,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257889',4904126,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257890',4904127,'2136','323',4611596.98,4611904.82,0.00,0.00,307.84,230264.32,0.00,0.00,0.00),('1','138','765','257890',4904128,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257890',4904129,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257890',4904130,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257891',4904131,'2136','323',4611904.82,4611946.52,0.00,0.00,41.70,31191.60,0.00,0.00,0.00),('1','138','765','257891',4904132,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257891',4904133,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257891',4904134,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257892',4904135,'2136','323',4611946.52,4615323.97,0.00,0.00,3377.45,2526332.60,0.00,0.00,0.00),('1','138','765','257892',4904136,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257892',4904137,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257892',4904138,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257893',4904139,'2136','323',4615323.97,4616844.06,0.00,0.00,1520.09,1137027.32,0.00,0.00,0.00),('1','138','765','257893',4904140,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257893',4904141,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257893',4904142,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257894',4904143,'2136','323',4616844.06,4616844.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257894',4904144,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257894',4904145,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257894',4904146,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257895',4904147,'2136','323',4616844.06,4617677.46,0.00,0.00,833.40,623383.20,0.00,0.00,0.00),('1','138','765','257895',4904148,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257895',4904149,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257895',4904150,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257896',4904151,'2136','323',4617677.46,4619170.24,0.00,0.00,1492.78,1116599.44,0.00,0.00,0.00),('1','138','765','257896',4904152,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257896',4904153,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257896',4904154,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257897',4904155,'2136','323',4619170.24,4620585.22,0.00,0.00,1414.98,1058405.04,0.00,0.00,0.00),('1','138','765','257897',4904156,'2137','323',112.00,112.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257897',4904157,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257897',4904158,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257898',4904159,'2136','323',4620585.22,4622021.06,0.00,0.00,1435.84,1091238.40,0.00,0.00,0.00),('1','138','765','257898',4904160,'2137','323',112.00,122.00,0.00,0.00,10.00,7600.00,0.00,0.00,0.00),('1','138','765','257898',4904161,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257898',4904162,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257899',4904163,'2136','323',4622021.06,4623479.58,0.00,0.00,1458.52,1108475.20,0.00,0.00,0.00),('1','138','765','257899',4904164,'2137','323',122.00,122.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257899',4904165,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257899',4904166,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257900',4904167,'2136','323',4623479.58,4626174.90,0.00,0.00,2695.32,2048443.20,0.00,0.00,0.00),('1','138','765','257900',4904168,'2137','323',122.00,122.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257900',4904169,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257900',4904170,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257901',4904171,'2136','323',4626174.90,4627486.58,0.00,0.00,1311.68,996876.80,0.00,0.00,0.00),('1','138','765','257901',4904172,'2137','323',122.00,122.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257901',4904173,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257901',4904174,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257902',4904175,'2136','323',4627486.58,4628306.32,0.00,0.00,819.74,623002.40,0.00,0.00,0.00),('1','138','765','257902',4904176,'2137','323',122.00,122.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257902',4904177,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257902',4904178,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257903',4904179,'2136','323',4628306.32,4630089.44,0.00,0.00,1783.12,1355171.20,0.00,0.00,0.00),('1','138','765','257903',4904180,'2137','323',122.00,134.50,0.00,0.00,12.50,9500.00,0.00,0.00,0.00),('1','138','765','257903',4904181,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257903',4904182,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257904',4904183,'2136','323',4630089.44,4631835.96,0.00,0.00,1746.52,1327355.20,0.00,0.00,0.00),('1','138','765','257904',4904184,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257904',4904185,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257904',4904186,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257905',4904187,'2136','323',4631835.96,4632930.60,0.00,0.00,1094.64,831926.40,0.00,0.00,0.00),('1','138','765','257905',4904188,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257905',4904189,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257905',4904190,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257906',4904191,'2136','323',4632930.60,4633525.63,0.00,0.00,595.03,452222.80,0.00,0.00,0.00),('1','138','765','257906',4904192,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257906',4904193,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257906',4904194,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257907',4904195,'2136','323',4633525.63,4634883.79,0.00,0.00,1358.16,1086528.00,0.00,0.00,0.00),('1','138','765','257907',4904196,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257907',4904197,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257907',4904198,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257908',4904199,'2136','323',4634883.79,4636201.39,0.00,0.00,1317.60,1054080.00,0.00,0.00,0.00),('1','138','765','257908',4904200,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257908',4904201,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257908',4904202,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257909',4904203,'2136','323',4636201.39,4637422.41,0.00,0.00,1221.02,976816.00,0.00,0.00,0.00),('1','138','765','257909',4904204,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257909',4904205,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257909',4904206,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257910',4904207,'2136','323',4637422.41,4638236.96,0.00,0.00,814.55,619058.00,0.00,0.00,0.00),('1','138','765','257910',4904208,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257910',4904209,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257910',4904210,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257911',4904211,'2136','323',4638236.96,4638236.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257911',4904212,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257911',4904213,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257911',4904214,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257912',4904215,'2136','323',4638236.96,4638919.67,0.00,0.00,682.71,518859.60,0.00,0.00,0.00),('1','138','765','257912',4904216,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257912',4904217,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257912',4904218,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257913',4904219,'2136','323',4638919.67,4640238.91,0.00,0.00,1319.24,1002622.40,0.00,0.00,0.00),('1','138','765','257913',4904220,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257913',4904221,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257913',4904222,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257914',4904223,'2136','323',4640238.91,4641879.79,0.00,0.00,1640.88,1247068.80,0.00,0.00,0.00),('1','138','765','257914',4904224,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257914',4904225,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257914',4904226,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257915',4904227,'2136','323',4641879.79,4643435.63,0.00,0.00,1555.84,1182438.40,0.00,0.00,0.00),('1','138','765','257915',4904228,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257915',4904229,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257915',4904230,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257916',4904231,'2136','323',4643435.63,4643435.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257916',4904232,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257916',4904233,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257916',4904234,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257917',4904235,'2136','323',4643435.63,4644815.91,0.00,0.00,1380.28,1049012.80,0.00,0.00,0.00),('1','138','765','257917',4904236,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257917',4904237,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257917',4904238,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257918',4904239,'2136','323',4644815.91,4645842.30,0.00,0.00,1026.39,780056.40,0.00,0.00,0.00),('1','138','765','257918',4904240,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257918',4904241,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257918',4904242,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257919',4904243,'2136','323',4645842.30,4647206.20,0.00,0.00,1363.90,1036564.00,0.00,0.00,0.00),('1','138','765','257919',4904244,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257919',4904245,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257919',4904246,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257920',4904247,'2136','323',4647206.20,4647206.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257920',4904248,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257920',4904249,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257920',4904250,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257921',4904251,'2136','323',4647206.20,4648514.18,0.00,0.00,1307.98,994064.80,0.00,0.00,0.00),('1','138','765','257921',4904252,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257921',4904253,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257921',4904254,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257922',4904255,'2136','323',4648514.18,4649586.33,0.00,0.00,1072.15,814834.00,0.00,0.00,0.00),('1','138','765','257922',4904256,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257922',4904257,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257922',4904258,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257923',4904259,'2136','323',4649586.33,4650833.25,0.00,0.00,1246.92,947659.20,0.00,0.00,0.00),('1','138','765','257923',4904260,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257923',4904261,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257923',4904262,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257924',4904263,'2136','323',4650833.25,4652050.77,0.00,0.00,1217.52,925315.20,0.00,0.00,0.00),('1','138','765','257924',4904264,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257924',4904265,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257924',4904266,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257925',4904267,'2136','323',4652050.77,4652271.36,0.00,0.00,220.59,167648.40,0.00,0.00,0.00),('1','138','765','257925',4904268,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257925',4904269,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257925',4904270,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257926',4904271,'2136','323',4652271.36,4652776.42,0.00,0.00,505.06,383845.60,0.00,0.00,0.00),('1','138','765','257926',4904272,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257926',4904273,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257926',4904274,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257927',4904275,'2136','323',4652776.42,4654578.27,0.00,0.00,1801.85,1369406.00,0.00,0.00,0.00),('1','138','765','257927',4904276,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257927',4904277,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257927',4904278,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257928',4904279,'2136','323',4654578.27,4656919.86,0.00,0.00,2341.59,1779608.40,0.00,0.00,0.00),('1','138','765','257928',4904280,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257928',4904281,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257928',4904282,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257929',4904283,'2136','323',4656919.86,4660995.10,0.00,0.00,4075.24,2961458.40,0.00,0.00,0.00),('1','138','765','257929',4904284,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257929',4904285,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257929',4904286,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257930',4904287,'2136','323',4660995.10,4664417.49,0.00,0.00,3422.39,2477296.25,0.00,0.00,0.00),('1','138','765','257930',4904288,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257930',4904289,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257930',4904290,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257931',4904291,'2136','323',4664417.49,4664459.15,0.00,0.00,41.66,31346.60,0.00,0.00,0.00),('1','138','765','257931',4904292,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257931',4904293,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257931',4904294,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257932',4904295,'2136','323',4664459.15,4667399.67,0.00,0.00,2940.52,2137347.70,0.00,0.00,0.00),('1','138','765','257932',4904296,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257932',4904297,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257932',4904298,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257933',4904299,'2136','323',4667399.67,4669828.12,0.00,0.00,2428.45,1788157.00,0.00,0.00,0.00),('1','138','765','257933',4904300,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257933',4904301,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257933',4904302,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257934',4904303,'2136','323',4669828.12,4672557.62,0.00,0.00,2729.50,2016685.00,0.00,0.00,0.00),('1','138','765','257934',4904304,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257934',4904305,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257934',4904306,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257935',4904307,'2136','323',4672557.62,4673895.88,0.00,0.00,1338.26,983620.10,0.00,0.00,0.00),('1','138','765','257935',4904308,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257935',4904309,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257935',4904310,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257936',4904311,'2136','323',4673895.88,4675771.07,0.00,0.00,1875.19,1379285.80,0.00,0.00,0.00),('1','138','765','257936',4904312,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257936',4904313,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257936',4904314,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257937',4904315,'2136','323',4675771.07,4676582.94,0.00,0.00,811.87,592718.99,0.00,0.00,0.00),('1','138','765','257937',4904316,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257937',4904317,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257937',4904318,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257938',4904319,'2136','323',4676582.94,4678738.70,0.00,0.00,2155.76,1560605.66,0.00,0.00,0.00),('1','138','765','257938',4904320,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257938',4904321,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257938',4904322,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257939',4904323,'2136','323',4678738.70,4680789.90,0.00,0.00,2051.20,1508737.00,0.00,0.00,0.00),('1','138','765','257939',4904324,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257939',4904325,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257939',4904326,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257940',4904327,'2136','323',4680789.90,4683472.61,0.00,0.00,2682.71,1959124.10,0.00,0.00,0.00),('1','138','765','257940',4904328,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257940',4904329,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257940',4904330,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257941',4904331,'2136','323',4683472.61,4686859.90,0.00,0.00,3387.29,2463322.90,0.00,0.00,0.00),('1','138','765','257941',4904332,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257941',4904333,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257941',4904334,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257942',4904335,'2136','323',4686859.90,4690646.30,0.00,0.00,3786.40,2725402.50,0.00,0.00,0.00),('1','138','765','257942',4904336,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257942',4904337,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257942',4904338,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257943',4904339,'2136','323',4690646.30,4695752.65,0.00,0.00,5106.35,3659245.70,0.00,0.00,0.00),('1','138','765','257943',4904340,'2137','323',134.50,134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257943',4904341,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257943',4904342,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257944',4904343,'2136','323',4695752.65,4698916.43,0.00,0.00,3163.78,2281922.30,0.00,0.00,0.00),('1','138','765','257944',4904344,'2137','323',134.50,152.92,0.00,0.00,18.42,13999.20,0.00,0.00,0.00),('1','138','765','257944',4904345,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257944',4904346,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257945',4904347,'2136','323',4698916.43,4700838.36,0.00,0.00,1921.93,1366981.00,0.00,0.00,0.00),('1','138','765','257945',4904348,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257945',4904349,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257945',4904350,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257946',4904351,'2136','323',4700838.36,4700838.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257946',4904352,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257946',4904353,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257946',4904354,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257947',4904355,'2136','323',4700838.36,4704660.69,0.00,0.00,3822.33,2690696.80,0.00,0.00,0.00),('1','138','765','257947',4904356,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257947',4904357,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257947',4904358,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257948',4904359,'2136','323',4704660.69,4709206.97,0.00,0.00,4546.28,3233041.80,0.00,0.00,0.00),('1','138','765','257948',4904360,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257948',4904361,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257948',4904362,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257949',4904363,'2136','323',4709206.97,4714895.80,0.00,0.00,5688.83,4033424.80,0.00,0.00,0.00),('1','138','765','257949',4904364,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257949',4904365,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257949',4904366,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257950',4904367,'2136','323',4714895.80,4719670.88,0.00,0.00,4775.08,3381674.80,0.00,0.00,0.00),('1','138','765','257950',4904368,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257950',4904369,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257950',4904370,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257951',4904371,'2136','323',4719670.88,4723813.35,0.00,0.00,4142.47,2949268.00,0.00,0.00,0.00),('1','138','765','257951',4904372,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257951',4904373,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257951',4904374,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257952',4904375,'2136','323',4723813.35,4725546.09,0.00,0.00,1732.74,1223551.20,0.00,0.00,0.00),('1','138','765','257952',4904376,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257952',4904377,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257952',4904378,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257953',4904379,'2136','323',4725546.09,4725546.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257953',4904380,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257953',4904381,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257953',4904382,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257954',4904383,'2136','323',4725546.09,4728846.90,0.00,0.00,3300.81,2338681.40,0.00,0.00,0.00),('1','138','765','257954',4904384,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257954',4904385,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257954',4904386,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257955',4904387,'2136','323',4728846.90,4734442.69,0.00,0.00,5595.79,3963931.40,0.00,0.00,0.00),('1','138','765','257955',4904388,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257955',4904389,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257955',4904390,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257956',4904391,'2136','323',4734442.69,4740111.66,0.00,0.00,5668.97,4012063.80,0.00,0.00,0.00),('1','138','765','257956',4904392,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257956',4904393,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257956',4904394,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257957',4904395,'2136','323',4740111.66,4745076.74,0.00,0.00,4965.08,3538158.40,0.00,0.00,0.00),('1','138','765','257957',4904396,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257957',4904397,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257957',4904398,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257958',4904399,'2136','323',4745076.74,4748862.26,0.00,0.00,3785.52,2706095.64,0.00,0.00,0.00),('1','138','765','257958',4904400,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257958',4904401,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257958',4904402,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257959',4904403,'2136','323',4748862.26,4750051.03,0.00,0.00,1188.77,853802.00,0.00,0.00,0.00),('1','138','765','257959',4904404,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257959',4904405,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257959',4904406,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257960',4904407,'2136','323',4750051.03,4750051.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257960',4904408,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257960',4904409,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257960',4904410,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257961',4904411,'2136','323',4750051.03,4753025.41,0.00,0.00,2974.38,2105235.80,0.00,0.00,0.00),('1','138','765','257961',4904412,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257961',4904413,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257961',4904414,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257962',4904415,'2136','323',4753025.41,4754970.46,0.00,0.00,1945.05,1382748.00,0.00,0.00,0.00),('1','138','765','257962',4904416,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257962',4904417,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257962',4904418,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257963',4904419,'2136','323',4754970.46,4754970.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257963',4904420,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257963',4904421,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257963',4904422,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257964',4904423,'2136','323',4754970.46,4757559.98,0.00,0.00,2589.52,1827350.20,0.00,0.00,0.00),('1','138','765','257964',4904424,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257964',4904425,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257964',4904426,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257965',4904427,'2136','323',4757559.98,4760124.32,0.00,0.00,2564.34,1819602.24,0.00,0.00,0.00),('1','138','765','257965',4904428,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257965',4904429,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257965',4904430,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257966',4904431,'2136','323',4760124.32,4765342.50,0.00,0.00,5218.18,3686975.68,0.00,0.00,0.00),('1','138','765','257966',4904432,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257966',4904433,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257966',4904434,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257967',4904435,'2136','323',4765342.50,4770360.88,0.00,0.00,5018.38,3533256.20,0.00,0.00,0.00),('1','138','765','257967',4904436,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257967',4904437,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257967',4904438,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257968',4904439,'2136','323',4770360.88,4776967.79,0.00,0.00,6606.91,4650015.76,0.00,0.00,0.00),('1','138','765','257968',4904440,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257968',4904441,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257968',4904442,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257969',4904443,'2136','323',4776967.79,4778947.08,0.00,0.00,1979.29,1397887.36,0.00,0.00,0.00),('1','138','765','257969',4904444,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257969',4904445,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257969',4904446,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257970',4904447,'2136','323',4778947.08,4778947.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257970',4904448,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257970',4904449,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257970',4904450,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257971',4904451,'2136','323',4778947.08,4780558.31,0.00,0.00,1611.23,1135393.28,0.00,0.00,0.00),('1','138','765','257971',4904452,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257971',4904453,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257971',4904454,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257972',4904455,'2136','323',4780558.31,4784627.51,0.00,0.00,4069.20,2877068.12,0.00,0.00,0.00),('1','138','765','257972',4904456,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257972',4904457,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257972',4904458,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257973',4904459,'2136','323',4784627.51,4787125.37,0.00,0.00,2497.86,1751942.96,0.00,0.00,0.00),('1','138','765','257973',4904460,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257973',4904461,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257973',4904462,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257974',4904463,'2136','323',4787125.37,4790456.84,0.00,0.00,3331.47,2360203.32,0.00,0.00,0.00),('1','138','765','257974',4904464,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257974',4904465,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257974',4904466,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257975',4904467,'2136','323',4790456.84,4790456.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257975',4904468,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257975',4904469,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257975',4904470,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257976',4904471,'2136','323',4790456.84,4797080.80,0.00,0.00,6623.96,4661657.76,0.00,0.00,0.00),('1','138','765','257976',4904472,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257976',4904473,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257976',4904474,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257977',4904475,'2136','323',4797080.80,4797080.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257977',4904476,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257977',4904477,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257977',4904478,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257978',4904479,'2136','323',4797080.80,4802450.80,0.00,0.00,5370.00,3784762.52,0.00,0.00,0.00),('1','138','765','257978',4904480,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257978',4904481,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257978',4904482,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257979',4904483,'2136','323',4802450.80,4802527.30,0.00,0.00,76.50,53550.00,0.00,0.00,0.00),('1','138','765','257979',4904484,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257979',4904485,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257979',4904486,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257980',4904487,'2136','323',4802527.30,4805751.67,0.00,0.00,3224.37,2269989.20,0.00,0.00,0.00),('1','138','765','257980',4904488,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257980',4904489,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257980',4904490,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257981',4904491,'2136','323',4805751.67,4814365.36,0.00,0.00,8613.69,6059611.84,0.00,0.00,0.00),('1','138','765','257981',4904492,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257981',4904493,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257981',4904494,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257982',4904495,'2136','323',4814365.36,4823681.63,0.00,0.00,9316.27,6559121.04,0.00,0.00,0.00),('1','138','765','257982',4904496,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257982',4904497,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257982',4904498,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257983',4904499,'2136','323',4823681.63,4825927.57,0.00,0.00,2245.94,1587257.48,0.00,0.00,0.00),('1','138','765','257983',4904500,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257983',4904501,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257983',4904502,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257984',4904503,'2136','323',4825927.57,4825927.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257984',4904504,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257984',4904505,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257984',4904506,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257985',4904507,'2136','323',4825927.57,4828460.46,0.00,0.00,2532.89,1810765.04,0.00,0.00,0.00),('1','138','765','257985',4904508,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257985',4904509,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257985',4904510,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257986',4904511,'2136','323',4828460.46,4837064.80,0.00,0.00,8604.34,6070843.60,0.00,0.00,0.00),('1','138','765','257986',4904512,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257986',4904513,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257986',4904514,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257987',4904515,'2136','323',4837064.80,4845321.46,0.00,0.00,8256.66,5799409.76,0.00,0.00,0.00),('1','138','765','257987',4904516,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257987',4904517,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257987',4904518,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257988',4904519,'2136','323',4845321.46,4850463.49,0.00,0.00,5142.03,3612252.84,0.00,0.00,0.00),('1','138','765','257988',4904520,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257988',4904521,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257988',4904522,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257989',4904523,'2136','323',4850463.49,4850463.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257989',4904524,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257989',4904525,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257989',4904526,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257990',4904527,'2136','323',4850463.49,4851520.01,0.00,0.00,1056.52,743498.80,0.00,0.00,0.00),('1','138','765','257990',4904528,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257990',4904529,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257990',4904530,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257991',4904531,'2136','323',4851520.01,4858502.90,0.00,0.00,6982.89,4913457.04,0.00,0.00,0.00),('1','138','765','257991',4904532,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257991',4904533,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257991',4904534,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257992',4904535,'2136','323',4858502.90,4862271.24,0.00,0.00,3768.34,2672734.60,0.00,0.00,0.00),('1','138','765','257992',4904536,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257992',4904537,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257992',4904538,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257993',4904539,'2136','323',4862271.24,4870060.94,0.00,0.00,7789.70,5483239.04,0.00,0.00,0.00),('1','138','765','257993',4904540,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257993',4904541,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257993',4904542,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257994',4904543,'2136','323',4870060.94,4874436.93,0.00,0.00,4375.99,3085620.64,0.00,0.00,0.00),('1','138','765','257994',4904544,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257994',4904545,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257994',4904546,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257995',4904547,'2136','323',4874436.93,4875257.49,0.00,0.00,820.56,575935.32,0.00,0.00,0.00),('1','138','765','257995',4904548,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257995',4904549,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257995',4904550,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257996',4904551,'2136','323',4875257.49,4875257.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257996',4904552,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257996',4904553,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257996',4904554,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257997',4904555,'2136','323',4875257.49,4880371.91,0.00,0.00,5114.42,3591090.48,0.00,0.00,0.00),('1','138','765','257997',4904556,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257997',4904557,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257997',4904558,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257998',4904559,'2136','323',4880371.91,4880371.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257998',4904560,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257998',4904561,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257998',4904562,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257999',4904563,'2136','323',4880371.91,4885614.90,0.00,0.00,5242.99,3697370.20,0.00,0.00,0.00),('1','138','765','257999',4904564,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257999',4904565,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','257999',4904566,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258000',4904567,'2136','323',4885614.90,4891341.01,0.00,0.00,5726.11,4031932.96,0.00,0.00,0.00),('1','138','765','258000',4904568,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258000',4904569,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258000',4904570,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258001',4904571,'2136','323',4891341.01,4897573.95,0.00,0.00,6232.94,4392017.72,0.00,0.00,0.00),('1','138','765','258001',4904572,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258001',4904573,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258001',4904574,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258002',4904575,'2136','323',4897573.95,4899226.39,0.00,0.00,1652.44,1164251.08,0.00,0.00,0.00),('1','138','765','258002',4904576,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258002',4904577,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258002',4904578,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258003',4904579,'2136','323',4899226.39,4899226.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258003',4904580,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258003',4904581,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258003',4904582,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258004',4904583,'2136','323',4899226.39,4901157.24,0.00,0.00,1930.85,1371775.52,0.00,0.00,0.00),('1','138','765','258004',4904584,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258004',4904585,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258004',4904586,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258005',4904587,'2136','323',4901157.24,4901157.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258005',4904588,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258005',4904589,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258005',4904590,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258006',4904591,'2136','323',4901157.24,4907765.00,0.00,0.00,6607.76,4653501.08,0.00,0.00,0.00),('1','138','765','258006',4904592,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258006',4904593,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258006',4904594,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258007',4904595,'2136','323',4907765.00,4912697.26,0.00,0.00,4932.26,3445856.32,0.00,0.00,0.00),('1','138','765','258007',4904596,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258007',4904597,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258007',4904598,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258008',4904599,'2136','323',4912697.26,4919954.34,0.00,0.00,7257.08,5046403.92,0.00,0.00,0.00),('1','138','765','258008',4904600,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258008',4904601,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258008',4904602,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258009',4904603,'2136','323',4919954.34,4923389.37,0.00,0.00,3435.03,2393940.30,0.00,0.00,0.00),('1','138','765','258009',4904604,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258009',4904605,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258009',4904606,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258010',4904607,'2136','323',4923389.37,4923389.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258010',4904608,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258010',4904609,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258010',4904610,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258011',4904611,'2136','323',4923389.37,4925438.24,0.00,0.00,2048.87,1415914.18,0.00,0.00,0.00),('1','138','765','258011',4904612,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258011',4904613,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258011',4904614,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258012',4904615,'2136','323',4925438.24,4933804.75,0.00,0.00,8366.51,5812557.16,0.00,0.00,0.00),('1','138','765','258012',4904616,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258012',4904617,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258012',4904618,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258013',4904619,'2136','323',4933804.75,4941611.94,0.00,0.00,7807.19,5430578.28,0.00,0.00,0.00),('1','138','765','258013',4904620,'2137','323',152.92,152.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258013',4904621,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258013',4904622,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258014',4904623,'2136','323',4941611.94,4947797.47,0.00,0.00,6185.53,4306314.56,0.00,0.00,0.00),('1','138','765','258014',4904624,'2137','323',152.92,164.92,0.00,0.00,12.00,8832.00,0.00,0.00,0.00),('1','138','765','258014',4904625,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258014',4904626,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258015',4904627,'2136','323',4947797.47,4948287.47,0.00,0.00,490.00,338711.34,0.00,0.00,0.00),('1','138','765','258015',4904628,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258015',4904629,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258015',4904630,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258016',4904631,'2136','323',4948287.47,4948287.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258016',4904632,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258016',4904633,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258016',4904634,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258017',4904635,'2136','323',4948287.47,4952855.29,0.00,0.00,4567.82,3180043.20,0.00,0.00,0.00),('1','138','765','258017',4904636,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258017',4904637,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258017',4904638,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258018',4904639,'2136','323',4952855.29,4957231.31,0.00,0.00,4376.02,3057338.48,0.00,0.00,0.00),('1','138','765','258018',4904640,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258018',4904641,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258018',4904642,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258019',4904643,'2136','323',4957231.31,4960015.12,0.00,0.00,2783.81,1963799.34,0.00,0.00,0.00),('1','138','765','258019',4904644,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258019',4904645,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258019',4904646,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258020',4904647,'2136','323',4960015.12,4967531.69,0.00,0.00,7516.57,5227896.16,0.00,0.00,0.00),('1','138','765','258020',4904648,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258020',4904649,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258020',4904650,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258021',4904651,'2136','323',4967531.69,4972699.69,0.00,0.00,5168.00,3598857.28,0.00,0.00,0.00),('1','138','765','258021',4904652,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258021',4904653,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258021',4904654,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258022',4904655,'2136','323',4972699.69,4973419.73,0.00,0.00,720.04,502727.56,0.00,0.00,0.00),('1','138','765','258022',4904656,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258022',4904657,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258022',4904658,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258023',4904659,'2136','323',4973419.73,4978760.18,0.00,0.00,5340.45,3731016.76,0.00,0.00,0.00),('1','138','765','258023',4904660,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258023',4904661,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258023',4904662,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258024',4904663,'2136','323',4978760.18,4984467.14,0.00,0.00,5706.96,3992018.80,0.00,0.00,0.00),('1','138','765','258024',4904664,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258024',4904665,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258024',4904666,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258025',4904667,'2136','323',4984467.14,4990976.87,0.00,0.00,6509.73,4526212.10,0.00,0.00,0.00),('1','138','765','258025',4904668,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258025',4904669,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258025',4904670,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258026',4904671,'2136','323',4990976.87,4995238.04,0.00,0.00,4261.17,2990263.36,0.00,0.00,0.00),('1','138','765','258026',4904672,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258026',4904673,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258026',4904674,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258027',4904675,'2136','323',4995238.04,4997902.54,0.00,0.00,2664.50,1847175.20,0.00,0.00,0.00),('1','138','765','258027',4904676,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258027',4904677,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258027',4904678,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258028',4904679,'2136','323',4997902.54,4997902.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258028',4904680,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258028',4904681,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258028',4904682,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258029',4904683,'2136','323',4997902.54,5001977.24,0.00,0.00,4074.70,2831099.00,0.00,0.00,0.00),('1','138','765','258029',4904684,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258029',4904685,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258029',4904686,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258030',4904687,'2136','323',5001977.24,5002227.79,0.00,0.00,250.55,177320.80,0.00,0.00,0.00),('1','138','765','258030',4904688,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258030',4904689,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258030',4904690,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258031',4904691,'2136','323',5002227.79,5006769.73,0.00,0.00,4541.94,3167072.74,0.00,0.00,0.00),('1','138','765','258031',4904692,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258031',4904693,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258031',4904694,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258032',4904695,'2136','323',5006769.73,5011435.18,0.00,0.00,4665.45,3255079.60,0.00,0.00,0.00),('1','138','765','258032',4904696,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258032',4904697,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258032',4904698,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258033',4904699,'2136','323',5011435.18,5018767.26,0.00,0.00,7332.08,5043604.96,0.00,0.00,0.00),('1','138','765','258033',4904700,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258033',4904701,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258033',4904702,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258034',4904703,'2136','323',5018767.26,5026773.18,0.00,0.00,8005.92,5494693.68,0.00,0.00,0.00),('1','138','765','258034',4904704,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258034',4904705,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258034',4904706,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258035',4904707,'2136','323',5026773.18,5027160.02,0.00,0.00,386.84,273514.24,0.00,0.00,0.00),('1','138','765','258035',4904708,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258035',4904709,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258035',4904710,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258036',4904711,'2136','323',5027160.02,5027160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258036',4904712,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258036',4904713,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258036',4904714,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258037',4904715,'2136','323',5027160.02,5032386.53,0.00,0.00,5226.51,3589243.36,0.00,0.00,0.00),('1','138','765','258037',4904716,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258037',4904717,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258037',4904718,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258038',4904719,'2136','323',5032386.53,5038192.91,0.00,0.00,5806.38,3996528.08,0.00,0.00,0.00),('1','138','765','258038',4904720,'2137','323',164.92,164.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258038',4904721,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258038',4904722,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258039',4904723,'2136','323',5038192.91,5045038.58,0.00,0.00,6845.67,4713333.04,0.00,0.00,0.00),('1','138','765','258039',4904724,'2137','323',164.92,171.03,0.00,0.00,6.11,4496.96,0.00,0.00,0.00),('1','138','765','258039',4904725,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258039',4904726,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258040',4904727,'2136','323',5045038.58,5050256.46,0.00,0.00,5217.88,3603812.88,0.00,0.00,0.00),('1','138','765','258040',4904728,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258040',4904729,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258040',4904730,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258041',4904731,'2136','323',5050256.46,5051811.21,0.00,0.00,1554.75,1066932.00,0.00,0.00,0.00),('1','138','765','258041',4904732,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258041',4904733,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258041',4904734,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258042',4904735,'2136','323',5051811.21,5051811.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258042',4904736,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258042',4904737,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258042',4904738,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258043',4904739,'2136','323',5051811.21,5055124.46,0.00,0.00,3313.25,2293322.16,0.00,0.00,0.00),('1','138','765','258043',4904740,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258043',4904741,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258043',4904742,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258044',4904743,'2136','323',5055124.46,5061589.73,0.00,0.00,6465.27,4454890.72,0.00,0.00,0.00),('1','138','765','258044',4904744,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258044',4904745,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258044',4904746,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258045',4904747,'2136','323',5061589.73,5069640.33,0.00,0.00,8050.60,5508558.16,0.00,0.00,0.00),('1','138','765','258045',4904748,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258045',4904749,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258045',4904750,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258046',4904751,'2136','323',5069640.33,5077070.04,0.00,0.00,7429.71,5105997.92,0.00,0.00,0.00),('1','138','765','258046',4904752,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258046',4904753,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258046',4904754,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258047',4904755,'2136','323',5077070.04,5083257.28,0.00,0.00,6187.24,4264320.24,0.00,0.00,0.00),('1','138','765','258047',4904756,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258047',4904757,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258047',4904758,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258048',4904759,'2136','323',5083257.28,5090383.62,0.00,0.00,7126.34,4891144.56,0.00,0.00,0.00),('1','138','765','258048',4904760,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258048',4904761,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258048',4904762,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258049',4904763,'2136','323',5090383.62,5095073.29,0.00,0.00,4689.67,3259957.28,0.00,0.00,0.00),('1','138','765','258049',4904764,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258049',4904765,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258049',4904766,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258050',4904767,'2136','323',5095073.29,5099479.31,0.00,0.00,4406.02,3057174.48,0.00,0.00,0.00),('1','138','765','258050',4904768,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258050',4904769,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258050',4904770,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258051',4904771,'2136','323',5099479.31,5101722.90,0.00,0.00,2243.59,1534642.08,0.00,0.00,0.00),('1','138','765','258051',4904772,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258051',4904773,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258051',4904774,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258052',4904775,'2136','323',5101722.90,5101722.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258052',4904776,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258052',4904777,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258052',4904778,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258053',4904779,'2136','323',5101722.90,5103932.61,0.00,0.00,2209.71,1529659.76,0.00,0.00,0.00),('1','138','765','258053',4904780,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258053',4904781,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258053',4904782,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258054',4904783,'2136','323',5103932.61,5108937.62,0.00,0.00,5005.01,3454013.76,0.00,0.00,0.00),('1','138','765','258054',4904784,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258054',4904785,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258054',4904786,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258055',4904787,'2136','323',5108937.62,5114042.98,0.00,0.00,5105.36,3516849.33,0.00,0.00,0.00),('1','138','765','258055',4904788,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258055',4904789,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258055',4904790,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258056',4904791,'2136','323',5114042.98,5118676.36,0.00,0.00,4633.38,3186872.91,0.00,0.00,0.00),('1','138','765','258056',4904792,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258056',4904793,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258056',4904794,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258057',4904795,'2136','323',5118676.36,5125118.97,0.00,0.00,6442.61,4409838.12,0.00,0.00,0.00),('1','138','765','258057',4904796,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258057',4904797,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258057',4904798,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258058',4904799,'2136','323',5125118.97,5126861.74,0.00,0.00,1742.77,1203474.49,0.00,0.00,0.00),('1','138','765','258058',4904800,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258058',4904801,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258058',4904802,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258059',4904803,'2136','323',5126861.74,5128212.93,0.00,0.00,1351.19,934137.08,0.00,0.00,0.00),('1','138','765','258059',4904804,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258059',4904805,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258059',4904806,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258060',4904807,'2136','323',5128212.93,5134044.48,0.00,0.00,5831.55,3997033.95,0.00,0.00,0.00),('1','138','765','258060',4904808,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258060',4904809,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258060',4904810,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258061',4904811,'2136','323',5134044.48,5141410.70,0.00,0.00,7366.22,5041442.65,0.00,0.00,0.00),('1','138','765','258061',4904812,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258061',4904813,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258061',4904814,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258062',4904815,'2136','323',5141410.70,5147272.59,0.00,0.00,5861.89,4016758.27,0.00,0.00,0.00),('1','138','765','258062',4904816,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258062',4904817,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258062',4904818,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258063',4904819,'2136','323',5147272.59,5151672.91,0.00,0.00,4400.32,3035486.76,0.00,0.00,0.00),('1','138','765','258063',4904820,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258063',4904821,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258063',4904822,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258064',4904823,'2136','323',5151672.91,5151672.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258064',4904824,'2137','323',171.03,171.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258064',4904825,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258064',4904826,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258065',4904827,'2136','323',5151672.91,5156963.37,0.00,0.00,5290.46,3638342.34,0.00,0.00,0.00),('1','138','765','258065',4904828,'2137','323',171.03,183.53,0.00,0.00,12.50,9200.00,0.00,0.00,0.00),('1','138','765','258065',4904829,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258065',4904830,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258066',4904831,'2136','323',5156963.37,5162043.78,0.00,0.00,5080.41,3508321.24,0.00,0.00,0.00),('1','138','765','258066',4904832,'2137','323',183.53,183.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258066',4904833,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258066',4904834,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258067',4904835,'2136','323',5162043.78,5166867.26,0.00,0.00,4823.48,3331806.35,0.00,0.00,0.00),('1','138','765','258067',4904836,'2137','323',183.53,196.03,0.00,0.00,12.50,9200.00,0.00,0.00,0.00),('1','138','765','258067',4904837,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258067',4904838,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258068',4904839,'2136','323',5166867.26,5170923.24,0.00,0.00,4055.98,2807738.44,0.00,0.00,0.00),('1','138','765','258068',4904840,'2137','323',196.03,196.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258068',4904841,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258068',4904842,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258069',4904843,'2136','323',5170923.24,5176454.63,0.00,0.00,5531.39,3779629.18,0.00,0.00,0.00),('1','138','765','258069',4904844,'2137','323',196.03,196.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258069',4904845,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258069',4904846,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258070',4904847,'2136','323',5176454.63,5176454.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258070',4904848,'2137','323',196.03,196.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258070',4904849,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258070',4904850,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258071',4904851,'2136','323',5176454.63,5178447.13,0.00,0.00,1992.50,1381141.00,0.00,0.00,0.00),('1','138','765','258071',4904852,'2137','323',196.03,196.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258071',4904853,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258071',4904854,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258072',4904855,'2136','323',5178447.13,5182778.66,0.00,0.00,4331.53,3011731.94,0.00,0.00,0.00),('1','138','765','258072',4904856,'2137','323',196.03,196.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258072',4904857,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258072',4904858,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258073',4904859,'2136','323',5182778.66,5191331.00,0.00,0.00,8552.34,5887908.74,0.00,0.00,0.00),('1','138','765','258073',4904860,'2137','323',196.03,196.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258073',4904861,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258073',4904862,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258074',4904863,'2136','323',5191331.00,5196022.55,0.00,0.00,4691.55,3265469.39,0.00,0.00,0.00),('1','138','765','258074',4904864,'2137','323',196.03,196.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258074',4904865,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258074',4904866,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258075',4904867,'2136','323',5196022.55,5201292.69,0.00,0.00,5270.14,3607043.37,0.00,0.00,0.00),('1','138','765','258075',4904868,'2137','323',196.03,196.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258075',4904869,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258075',4904870,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258076',4904871,'2136','323',5201292.69,5201292.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258076',4904872,'2137','323',196.03,196.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258076',4904873,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258076',4904874,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258077',4904875,'2136','323',5201292.69,5202943.23,0.00,0.00,1650.54,1124303.94,0.00,0.00,0.00),('1','138','765','258077',4904876,'2137','323',196.03,196.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258077',4904877,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258077',4904878,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258078',4904879,'2136','323',5202943.23,5207737.40,0.00,0.00,4794.17,3304872.28,0.00,0.00,0.00),('1','138','765','258078',4904880,'2137','323',196.03,196.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258078',4904881,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258078',4904882,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258079',4904883,'2136','323',5207737.40,5213992.89,0.00,0.00,6255.49,4291093.98,0.00,0.00,0.00),('1','138','765','258079',4904884,'2137','323',196.03,196.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258079',4904885,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258079',4904886,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258080',4904887,'2136','323',5213992.89,5217496.70,0.00,0.00,3503.81,2414616.56,0.00,0.00,0.00),('1','138','765','258080',4904888,'2137','323',196.03,196.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258080',4904889,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258080',4904890,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258081',4904891,'2136','323',5217496.70,5222182.11,0.00,0.00,4685.41,3228120.61,0.00,0.00,0.00),('1','138','765','258081',4904892,'2137','323',196.03,196.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258081',4904893,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258081',4904894,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258082',4904895,'2136','323',5222182.11,5225930.35,0.00,0.00,3748.24,2589668.15,0.00,0.00,0.00),('1','138','765','258082',4904896,'2137','323',196.03,196.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258082',4904897,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258082',4904898,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258083',4904899,'2136','323',5225930.35,5225930.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258083',4904900,'2137','323',196.03,196.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258083',4904901,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258083',4904902,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258084',4904903,'2136','323',5225930.35,5230376.40,0.00,0.00,4446.05,3069409.24,0.00,0.00,0.00),('1','138','765','258084',4904904,'2137','323',196.03,196.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258084',4904905,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258084',4904906,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258085',4904907,'2136','323',5230376.40,5236879.75,0.00,0.00,6503.35,4465031.59,0.00,0.00,0.00),('1','138','765','258085',4904908,'2137','323',196.03,208.53,0.00,0.00,12.50,9200.00,0.00,0.00,0.00),('1','138','765','258085',4904909,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258085',4904910,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258086',4904911,'2136','323',5236879.75,5244650.85,0.00,0.00,7771.10,5292493.10,0.00,0.00,0.00),('1','138','765','258086',4904912,'2137','323',208.53,208.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258086',4904913,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258086',4904914,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258087',4904915,'2136','323',5244650.85,5250540.10,0.00,0.00,5889.25,4044270.13,0.00,0.00,0.00),('1','138','765','258087',4904916,'2137','323',208.53,208.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258087',4904917,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258087',4904918,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258088',4904919,'2136','323',5250540.10,5250540.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258088',4904920,'2137','323',208.53,208.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258088',4904921,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258088',4904922,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258089',4904923,'2136','323',5250540.10,5258039.13,0.00,0.00,7499.03,4971684.24,0.00,0.00,0.00),('1','138','765','258089',4904924,'2137','323',208.53,208.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258089',4904925,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258089',4904926,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258090',4904927,'2136','323',5258039.13,5265648.48,0.00,0.00,7609.35,5062404.48,0.00,0.00,0.00),('1','138','765','258090',4904928,'2137','323',208.53,318.53,0.00,0.00,110.00,72380.00,0.00,0.00,0.00),('1','138','765','258090',4904929,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258090',4904930,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258091',4904931,'2136','323',5265648.48,5272317.90,0.00,0.00,6669.42,4430396.42,0.00,0.00,0.00),('1','138','765','258091',4904932,'2137','323',318.53,318.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258091',4904933,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258091',4904934,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258092',4904935,'2136','323',5272317.90,5274702.84,0.00,0.00,2384.94,1588579.86,0.00,0.00,0.00),('1','138','765','258092',4904936,'2137','323',318.53,331.03,0.00,0.00,12.50,8750.00,0.00,0.00,0.00),('1','138','765','258092',4904937,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258092',4904938,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258093',4904939,'2136','323',5274702.84,5274702.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258093',4904940,'2137','323',331.03,331.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258093',4904941,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258093',4904942,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258094',4904943,'2136','323',5274702.84,5279050.28,0.00,0.00,4347.44,2869177.18,0.00,0.00,0.00),('1','138','765','258094',4904944,'2137','323',331.03,331.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258094',4904945,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258094',4904946,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258095',4904947,'2136','323',5279050.28,5287088.59,0.00,0.00,8038.31,5365598.00,0.00,0.00,0.00),('1','138','765','258095',4904948,'2137','323',331.03,403.46,0.00,0.00,72.43,48139.00,0.00,0.00,0.00),('1','138','765','258095',4904949,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258095',4904950,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258096',4904951,'2136','323',5287088.59,5292746.04,0.00,0.00,5657.45,3751621.46,0.00,0.00,0.00),('1','138','765','258096',4904952,'2137','323',403.46,403.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258096',4904953,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258096',4904954,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258097',4904955,'2136','323',5292746.04,5298888.29,0.00,0.00,6142.25,4094095.50,0.00,0.00,0.00),('1','138','765','258097',4904956,'2137','323',403.46,415.96,0.00,0.00,12.50,8750.00,0.00,0.00,0.00),('1','138','765','258097',4904957,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258097',4904958,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258098',4904959,'2136','323',5298888.29,5298888.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258098',4904960,'2137','323',415.96,415.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258098',4904961,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258098',4904962,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258099',4904963,'2136','323',5298888.29,5304419.77,0.00,0.00,5531.48,3670970.00,0.00,0.00,0.00),('1','138','765','258099',4904964,'2137','323',415.96,415.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258099',4904965,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258099',4904966,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258100',4904967,'2136','323',5304419.77,5314018.41,0.00,0.00,9598.64,6353780.40,0.00,0.00,0.00),('1','138','765','258100',4904968,'2137','323',415.96,415.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258100',4904969,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258100',4904970,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258101',4904971,'2136','323',5314018.41,5318615.84,0.00,0.00,4597.43,3071915.00,0.00,0.00,0.00),('1','138','765','258101',4904972,'2137','323',415.96,415.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258101',4904973,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258101',4904974,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258102',4904975,'2136','323',5318615.84,5321343.84,0.00,0.00,2728.00,1810837.00,0.00,0.00,0.00),('1','138','765','258102',4904976,'2137','323',415.96,415.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258102',4904977,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258102',4904978,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258103',4904979,'2136','323',5321343.84,5323841.44,0.00,0.00,2497.60,1643193.50,0.00,0.00,0.00),('1','138','765','258103',4904980,'2137','323',415.96,415.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258103',4904981,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258103',4904982,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258104',4904983,'2136','323',5323841.44,5330660.64,0.00,0.00,6819.20,4480595.00,0.00,0.00,0.00),('1','138','765','258104',4904984,'2137','323',415.96,415.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258104',4904985,'2138','323',28.36,28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258104',4904986,'2139','323',86.02,86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258105',4904987,'2136','323',5330660.64,0.00,0.00,0.00,4709.75,3110826.50,0.00,0.00,0.00),('1','138','765','258105',4904988,'2137','323',415.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258105',4904989,'2138','323',28.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','138','765','258105',4904990,'2139','323',86.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730235 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','138','146997','323',210.00,280.00,0.00,670.00,140700.00,187600.00,46900.00,441542),('1','138','147075','323',210.00,280.00,0.00,870.00,182700.00,243600.00,60900.00,441721),('1','138','147102','323',210.00,280.00,0.00,1524.40,320124.00,426832.00,106708.00,441758),('1','138','147164','323',210.00,280.00,0.00,657.90,138159.00,184212.00,46053.00,441888),('1','138','147168','323',210.00,280.00,0.00,996.40,209244.00,234322.00,25078.00,441894),('1','138','147189','323',210.00,280.00,0.00,7563.70,1588377.00,1691660.00,103283.00,441939),('1','138','147198','323',210.00,280.00,0.00,9471.80,1989078.00,2091592.00,102514.00,441955),('1','138','147202','323',210.00,280.00,0.00,5824.00,1223040.00,1316064.00,93024.00,441962),('1','138','147205','323',210.00,280.00,0.00,744.60,156366.00,160833.60,4467.60,441968),('1','138','147209','323',210.00,216.00,0.00,11506.20,2416302.00,2520856.00,104554.00,441976),('1','138','147218','323',210.00,216.00,0.00,6607.00,1387470.00,1470248.00,82778.00,441992),('1','138','147228','323',210.00,280.00,0.00,5137.30,1078833.00,1145804.00,66971.00,442012),('1','138','147278','323',210.00,280.00,0.00,0.00,0.00,0.00,0.00,442134),('1','138','147295','323',210.00,280.00,0.00,0.00,0.00,0.00,0.00,442172),('1','138','147330','323',210.00,280.00,0.00,7814.50,1641045.00,1748092.00,107047.00,442263),('1','138','147428','323',210.00,280.00,0.00,5277.80,1108338.00,1052028.00,-56310.00,442529),('1','138','147577','323',210.00,280.00,0.00,8729.00,1833090.00,1913506.00,80416.00,442942),('1','138','147578','323',210.00,216.00,0.00,0.00,0.00,0.00,0.00,442943),('1','138','147870','323',210.00,280.00,0.00,5715.00,1200150.00,1262472.00,62322.00,443735),('1','138','147871','323',210.00,280.00,0.00,173.00,36330.00,48440.00,12110.00,443736),('1','138','147873','323',210.00,280.00,0.00,1213.50,254835.00,262116.00,7281.00,443738),('1','138','147991','323',210.00,280.00,0.00,9197.30,1931433.00,2439244.00,507811.00,444046),('1','138','148107','323',210.00,280.00,0.00,4463.00,937230.00,1004852.80,67622.80,444357),('1','138','148280','323',210.00,280.00,0.00,4714.50,990045.00,1043644.00,53599.00,444799),('1','138','148281','323',210.00,216.00,0.00,0.00,0.00,0.00,0.00,444800),('1','138','148282','323',202.00,280.00,0.00,1408.50,284517.00,319116.00,34599.00,444801),('1','138','148427','323',202.00,280.00,0.00,6625.20,1338290.40,1463209.60,124919.20,445193),('1','138','148430','323',202.00,280.00,0.00,0.00,0.00,0.00,0.00,445198),('1','138','148561','323',222.00,280.00,0.00,5245.00,1164390.00,1118328.00,-46062.00,445539),('1','138','148799','323',202.00,280.00,0.00,7678.80,1551117.60,1699312.00,148194.40,446149),('1','138','148957','323',202.00,280.00,0.00,12372.70,2499285.40,2724134.80,224849.40,446569),('1','138','149036','323',202.00,280.00,0.00,2728.00,551056.00,596032.00,44976.00,446769),('1','138','149127','323',205.00,280.00,0.00,2150.80,440914.00,486128.00,45214.00,447025),('1','138','149312','323',205.00,280.00,0.00,5710.90,1170734.50,1275372.00,104637.50,447495),('1','138','149433','323',205.00,280.00,0.00,7821.00,1603305.00,1730232.00,126927.00,447832),('1','138','149582','323',205.00,280.00,0.00,6402.50,1312512.50,1421493.60,108981.10,448244),('1','138','149590','323',205.00,280.00,0.00,4197.00,860385.00,929816.00,69431.00,448264),('1','138','149679','323',205.00,280.00,0.00,8856.00,1815480.00,1951824.00,136344.00,448497),('1','138','149832','323',205.00,280.00,0.00,9415.10,1930095.50,2059543.20,129447.70,448907),('1','138','149839','323',205.00,280.00,0.00,4251.20,871496.00,938880.00,67384.00,448920),('1','138','149988','323',205.00,280.00,0.00,9356.80,1918144.00,2073248.00,155104.00,449323),('1','138','150112','323',205.00,216.00,0.00,386.50,79232.50,83484.00,4251.50,449647),('1','138','150126','323',205.00,280.00,0.00,8554.00,1753570.00,1875344.00,121774.00,449687),('1','138','150129','323',205.00,216.00,0.00,2100.00,430500.00,453600.00,23100.00,449694),('1','138','150386','323',225.00,280.00,0.00,2543.00,572175.00,598504.00,26329.00,450347),('1','138','150562','323',225.00,280.00,0.00,667.90,150277.50,187012.00,36734.50,450826),('1','138','150722','323',225.00,280.00,0.00,912.20,205245.00,255416.00,50171.00,451241),('1','138','150817','323',225.00,280.00,0.00,1271.00,285975.00,355880.00,69905.00,451508),('1','138','151154','323',205.00,280.00,0.00,11355.10,2327795.50,2500324.00,172528.50,452398),('1','138','151273','323',205.00,280.00,0.00,12473.30,2557026.50,2743573.60,186547.10,452731),('1','138','151420','323',205.00,280.00,0.00,12295.70,2520618.50,2694347.60,173729.10,453129),('1','138','151551','323',205.00,280.00,0.00,10096.00,2069680.00,2198826.00,129146.00,453491),('1','138','151695','323',205.00,280.00,0.00,12863.40,2636997.00,2813044.00,176047.00,453883),('1','138','151805','323',205.00,280.00,0.00,6366.50,1305132.50,1410108.00,104975.50,454168),('1','138','151949','323',205.00,280.00,0.00,3365.00,689825.00,729816.00,39991.00,454560),('1','138','152011','323',205.00,280.00,0.00,6361.50,1304107.50,1402458.00,98350.50,454718),('1','138','152155','323',205.00,280.00,0.00,8204.50,1681922.50,1799124.00,117201.50,455103),('1','138','152310','323',205.00,280.00,0.00,7943.00,1628315.00,1733292.00,104977.00,455514),('1','138','152312','323',205.00,280.00,0.00,3710.70,760693.50,815585.20,54891.70,455518),('1','138','152455','323',205.00,280.00,0.00,14442.50,2960712.50,3149037.20,188324.70,455901),('1','138','152587','323',205.00,280.00,0.00,4032.50,826662.50,878383.20,51720.70,456262),('1','138','152592','323',205.00,280.00,0.00,2206.90,452414.50,518257.60,65843.10,456275),('1','138','152595','323',205.00,212.00,0.00,0.00,0.00,0.00,0.00,456280),('1','138','152597','323',225.00,212.00,0.00,2999.60,674910.00,643493.60,-31416.40,456284),('1','138','152603','323',210.00,280.00,0.00,1949.10,409311.00,443992.00,34681.00,456300),('1','138','152747','323',210.00,280.00,0.00,10127.40,2126754.00,2275820.00,149066.00,456692),('1','138','152872','323',210.00,280.00,0.00,2731.60,573636.00,647640.00,74004.00,457025),('1','138','153075','323',210.00,280.00,0.00,2672.50,561225.00,636496.00,75271.00,457561),('1','138','153255','323',210.00,280.00,0.00,3770.20,791742.00,885668.00,93926.00,458068),('1','138','153382','323',210.00,280.00,0.00,1198.10,251601.00,283836.00,32235.00,458416),('1','138','153463','323',205.00,280.00,0.00,1462.50,299812.50,351960.00,52147.50,458643),('1','138','153640','323',205.00,280.00,0.00,6323.70,1296358.50,1457960.00,161601.50,459102),('1','138','153800','323',205.00,280.00,0.00,11596.80,2377344.00,2634878.00,257534.00,459535),('1','138','153918','323',205.00,280.00,0.00,2308.50,473242.50,524440.00,51197.50,459843),('1','138','153923','323',205.00,280.00,0.00,8667.50,1776837.50,1966606.00,189768.50,459856),('1','138','154041','323',205.00,280.00,0.00,8686.90,1780814.50,1991018.40,210203.90,460161),('1','138','154176','323',205.00,280.00,0.00,5763.50,1181517.50,1297016.00,115498.50,460521),('1','138','154638','323',205.00,216.00,0.00,775.00,158875.00,167400.00,8525.00,461767),('1','138','154728','323',225.00,280.00,0.00,887.70,199732.50,248556.00,48823.50,462022),('1','138','154871','323',225.00,280.00,0.00,2635.00,592875.00,624792.00,31917.00,462417),('1','138','155020','323',205.00,280.00,0.00,16719.40,3427477.00,3756649.60,329172.60,462812),('1','138','155131','323',205.00,280.00,0.00,5647.20,1157676.00,1291743.20,134067.20,463114),('1','138','155141','323',205.00,280.00,0.00,0.00,0.00,0.00,0.00,463136),('1','138','155301','323',205.00,280.00,0.00,9971.30,2044116.50,2257648.00,213531.50,463567),('1','138','155457','323',205.00,280.00,0.00,8902.00,1824910.00,2024148.00,199238.00,463979),('1','138','155535','323',205.00,280.00,0.00,3731.20,764896.00,843836.00,78940.00,464191),('1','138','155538','323',205.00,224.00,0.00,0.00,0.00,0.00,0.00,464199),('1','138','155569','323',205.00,280.00,0.00,0.00,0.00,0.00,0.00,464290),('1','138','155644','323',205.00,280.00,0.00,2135.50,437777.50,499212.00,61434.50,464498),('1','138','155781','323',205.00,280.00,0.00,12617.00,2586485.00,2855924.00,269439.00,464866),('1','138','155887','323',205.00,280.00,0.00,7855.10,1610295.50,1789662.40,179366.90,465143),('1','138','155891','323',205.00,224.00,0.00,0.00,0.00,0.00,0.00,465153),('1','138','155929','323',205.00,280.00,0.00,1451.50,297557.50,336140.00,38582.50,465247),('1','138','156073','323',205.00,280.00,0.00,12825.40,2629207.00,2902264.00,273057.00,465631),('1','138','156194','323',205.00,280.00,0.00,6615.50,1356177.50,1515508.00,159330.50,465949),('1','138','156291','323',205.00,224.00,0.00,1660.00,340300.00,371840.00,31540.00,466206),('1','138','156293','323',205.00,205.00,0.00,0.00,0.00,0.00,0.00,466208),('1','138','156422','323',205.00,280.00,0.00,12790.40,2622032.00,2910292.00,288260.00,466550),('1','138','156512','323',205.00,280.00,0.00,3558.00,729390.00,782760.00,53370.00,466799),('1','138','156514','323',205.00,280.00,0.00,6273.00,1285965.00,1405430.80,119465.80,466803),('1','138','156589','323',205.00,280.00,0.00,0.00,0.00,0.00,0.00,466996),('1','138','157073','323',205.00,280.00,0.00,1741.80,357069.00,408128.00,51059.00,468312),('1','138','157266','323',205.00,280.00,0.00,16197.90,3320569.50,3635665.60,315096.10,468809),('1','138','157428','323',205.00,280.00,0.00,5328.50,1092342.50,1219988.00,127645.50,469226),('1','138','157429','323',205.00,280.00,0.00,0.00,0.00,0.00,0.00,469227),('1','138','157442','323',205.00,280.00,0.00,1386.20,284171.00,319188.80,35017.80,469254),('1','138','157646','323',205.00,0.00,0.00,18670.70,3827493.50,4171420.00,343926.50,469787),('1','138','157748','323',205.00,280.00,0.00,2596.60,532303.00,584332.00,52029.00,470065),('1','138','157750','323',205.00,280.00,0.00,0.00,0.00,0.00,0.00,470069),('1','138','157813','323',205.00,0.00,0.00,8880.40,1820482.00,2001709.60,181227.60,470234),('1','138','157937','323',205.00,280.00,0.00,13752.00,2819160.00,3079372.80,260212.80,470573),('1','138','158039','323',205.00,280.00,0.00,0.00,0.00,0.00,0.00,470840),('1','138','158084','323',205.00,280.00,0.00,17788.80,3646704.00,4007679.20,360975.20,470947),('1','138','158254','323',205.00,280.00,0.00,2513.70,515308.50,636636.00,121327.50,471399),('1','138','158413','323',205.00,280.00,0.00,2380.00,487900.00,666400.00,178500.00,471827),('1','138','158418','323',205.00,280.00,0.00,0.00,0.00,0.00,0.00,471836),('1','138','158563','323',231.00,280.00,0.00,1550.40,358142.40,434112.00,75969.60,472211),('1','138','158739','323',231.00,280.00,0.00,3282.00,758142.00,918960.00,160818.00,472676),('1','138','158797','323',231.00,280.00,0.00,725.70,167636.70,203196.00,35559.30,472805),('1','138','159104','323',231.00,296.00,0.00,0.00,0.00,0.00,0.00,473648),('1','138','159107','323',231.00,296.00,0.00,939.50,217024.50,278092.00,61067.50,473651),('1','138','159264','323',231.00,296.00,0.00,0.00,0.00,0.00,0.00,474086),('1','138','159267','323',231.00,296.00,0.00,1260.00,291060.00,372960.00,81900.00,474089),('1','138','159452','323',231.00,296.00,0.00,882.50,203857.50,261220.00,57362.50,474532),('1','138','159623','323',231.00,304.00,0.00,689.00,159159.00,209456.00,50297.00,474999),('1','138','159640','323',231.00,296.00,0.00,193.00,44583.00,57128.00,12545.00,475028),('1','138','159721','323',231.00,304.00,0.00,1268.50,293023.50,301708.00,8684.50,475235),('1','138','159722','323',231.00,232.00,0.00,0.00,0.00,0.00,0.00,475236),('1','138','159726','323',215.00,304.00,0.00,9201.00,1978215.00,2175852.00,197637.00,475244),('1','138','159915','323',215.00,304.00,0.00,13312.70,2862230.50,3097547.20,235316.70,475742),('1','138','159917','323',215.00,232.00,0.00,0.00,0.00,0.00,0.00,475746),('1','138','160125','323',215.00,304.00,0.00,10207.40,2194591.00,2380421.60,185830.60,476268),('1','138','160294','323',215.00,304.00,0.00,12351.70,2655615.50,2890533.60,234918.10,476731),('1','138','160297','323',215.00,232.00,0.00,0.00,0.00,0.00,0.00,476735),('1','138','160380','323',215.00,232.00,0.00,0.00,0.00,0.00,0.00,476942),('1','138','160455','323',215.00,320.00,0.00,17383.10,3737366.50,4187868.00,450501.50,477138),('1','138','160587','323',215.00,320.00,0.00,4810.90,1034343.50,1267449.60,233106.10,477492),('1','138','160640','323',215.00,256.00,0.00,406.50,87397.50,104064.00,16666.50,477614),('1','138','160643','323',215.00,256.00,0.00,0.00,0.00,0.00,0.00,477621),('1','138','160744','323',215.00,320.00,0.00,9131.30,1963229.50,2371571.20,408341.70,477887),('1','138','160881','323',215.00,320.00,0.00,6722.80,1445402.00,1749452.80,304050.80,478221),('1','138','161084','323',215.00,320.00,0.00,6748.50,1450927.50,1725696.00,274768.50,478772),('1','138','161086','323',215.00,256.00,0.00,0.00,0.00,0.00,0.00,478774),('1','138','161263','323',215.00,320.00,0.00,4454.00,957610.00,1179008.00,221398.00,479235),('1','138','161451','323',215.00,320.00,0.00,5092.50,1094887.50,1343680.00,248792.50,479701),('1','138','161656','323',215.00,320.00,0.00,3776.60,811969.00,1011712.00,199743.00,480231),('1','138','161865','323',215.00,320.00,0.00,5938.90,1276863.50,1562118.40,285254.90,480747),('1','138','161985','323',215.00,320.00,0.00,3171.40,681851.00,825747.20,143896.20,481077),('1','138','162145','323',210.00,304.00,0.00,3069.00,644490.00,804792.00,160302.00,481491),('1','138','162149','323',210.00,248.00,0.00,0.00,0.00,0.00,0.00,481499),('1','138','162154','323',210.00,248.00,0.00,0.00,0.00,0.00,0.00,481512),('1','138','162232','323',216.00,304.00,0.00,3255.90,703274.40,846129.60,142855.20,481706),('1','138','162449','323',216.00,304.00,0.00,7151.00,1544616.00,1850696.00,306080.00,482264),('1','138','162639','323',216.00,304.00,0.00,5989.80,1293796.80,1567219.20,273422.40,482736),('1','138','162800','323',216.00,304.00,0.00,4429.00,956664.00,1147894.40,191230.40,483165),('1','138','162971','323',216.00,304.00,0.00,1778.20,384091.20,460787.20,76696.00,483621),('1','138','163009','323',215.00,304.00,0.00,1944.20,418003.00,505971.20,87968.20,483709),('1','138','163200','323',215.00,304.00,0.00,4294.90,923403.50,1117864.00,194460.50,484192),('1','138','163370','323',215.00,304.00,0.00,5151.30,1107529.50,1332851.20,225321.70,484637),('1','138','163549','323',215.00,304.00,0.00,5253.70,1129545.50,1358172.80,228627.30,485104),('1','138','163740','323',215.00,304.00,0.00,5055.70,1086975.50,1315316.80,228341.30,485608),('1','138','163896','323',216.00,304.00,0.00,2906.20,627739.20,807848.80,180109.60,486012),('1','138','164076','323',216.00,304.00,0.00,2472.00,533952.00,686202.00,152250.00,486485),('1','138','164254','323',216.00,304.00,0.00,2223.30,480232.80,615259.20,135026.40,486957),('1','138','164436','323',216.00,304.00,0.00,3215.30,694504.80,886936.40,192431.60,487442),('1','138','164597','323',216.00,304.00,0.00,3082.90,665906.40,851791.60,185885.20,487879),('1','138','164744','323',216.00,304.00,0.00,6984.60,1508673.60,1868538.40,359864.80,488274),('1','138','164883','323',216.00,304.00,0.00,1857.30,401176.80,503635.20,102458.40,488628),('1','138','164961','323',215.00,304.00,0.00,4031.00,866665.00,1084448.00,217783.00,488830),('1','138','165125','323',215.00,320.00,0.00,2932.50,630487.50,867690.00,237202.50,489244),('1','138','165300','323',215.00,304.00,0.00,5879.20,1264028.00,1645316.80,381288.80,489699),('1','138','165439','323',215.00,304.00,0.00,8332.80,1791552.00,2327812.80,536260.80,490068),('1','138','165545','323',215.00,304.00,0.00,1802.30,387494.50,509830.40,122335.90,490337),('1','138','165554','323',215.00,256.00,0.00,0.00,0.00,0.00,0.00,490362),('1','138','165560','323',215.00,212.00,0.00,0.00,0.00,0.00,0.00,490378),('1','138','165611','323',216.00,304.00,0.00,4201.90,907610.40,1168842.40,261232.00,490516),('1','138','165795','323',216.00,304.00,0.00,7689.70,1660975.20,2147660.80,486685.60,491012),('1','138','165923','323',216.00,304.00,0.00,7978.00,1723248.00,2227424.00,504176.00,491356),('1','138','166139','323',216.00,304.00,0.00,2375.30,513064.80,684291.20,171226.40,491917),('1','138','166170','323',216.00,280.00,0.00,461.00,99576.00,129080.00,29504.00,491988),('1','138','166310','323',216.00,304.00,0.00,1563.50,337716.00,452972.00,115256.00,492374),('1','138','166490','323',216.00,304.00,0.00,3039.40,656510.40,867421.60,210911.20,492864),('1','138','166715','323',216.00,304.00,0.00,7071.00,1527336.00,1992082.40,464746.40,493454),('1','138','166890','323',216.00,304.00,0.00,4991.20,1078099.20,1416956.80,338857.60,493935),('1','138','167045','323',216.00,304.00,0.00,5936.90,1282370.40,1671538.40,389168.00,494352),('1','138','167188','323',261.00,304.00,0.00,7511.30,1960449.30,2115108.00,154658.70,494729),('1','138','167390','323',261.00,304.00,0.00,8665.00,2261565.00,2436580.00,175015.00,495270),('1','138','167542','323',261.00,304.00,0.00,6273.70,1637435.70,1758177.60,120741.90,495688),('1','138','167570','323',261.00,304.00,0.00,2249.30,587067.30,629644.00,42576.70,495746),('1','138','167732','323',261.00,304.00,0.00,8480.90,2213514.90,2370657.60,157142.70,496175),('1','138','167912','323',261.00,304.00,0.00,9242.50,2412292.50,2569772.00,157479.50,496649),('1','138','168036','323',261.00,304.00,0.00,2118.20,552850.20,582902.40,30052.20,496993),('1','138','168046','323',261.00,272.00,0.00,0.00,0.00,0.00,0.00,497020),('1','138','168052','323',261.00,260.00,0.00,0.00,0.00,0.00,0.00,497034),('1','138','168054','323',261.00,272.00,0.00,0.00,0.00,0.00,0.00,497037),('1','138','168111','323',261.00,304.00,0.00,4265.80,1113373.80,1199304.00,85930.20,497178),('1','138','168285','323',261.00,304.00,0.00,9972.50,2602822.50,2767724.00,164901.50,497644),('1','138','168410','323',261.00,304.00,0.00,8230.10,2148056.10,2297686.40,149630.30,497981),('1','138','168468','323',261.00,304.00,0.00,12456.40,3251120.40,3467097.60,215977.20,498143),('1','138','168735','323',261.00,304.00,0.00,10112.30,2639310.30,2831043.20,191732.90,498848),('1','138','168940','323',261.00,304.00,0.00,15804.20,4124896.20,4421844.80,296948.60,499378),('1','138','169085','323',261.00,304.00,0.00,3750.40,978854.40,1057201.60,78347.20,499762),('1','138','169122','323',261.00,304.00,0.00,7618.70,1988480.70,2112628.80,124148.10,499839),('1','138','169274','323',261.00,304.00,0.00,15093.60,3939429.60,4367870.40,428440.80,500228),('1','138','169399','323',261.00,280.00,0.00,0.00,0.00,0.00,0.00,500561),('1','138','169403','323',261.00,280.00,0.00,0.00,0.00,0.00,0.00,500571),('1','138','169408','323',261.00,280.00,0.00,0.00,0.00,0.00,0.00,500583),('1','138','169411','323',261.00,280.00,0.00,0.00,0.00,0.00,0.00,500588),('1','138','169413','323',261.00,280.00,0.00,0.00,0.00,0.00,0.00,500592),('1','138','169414','323',261.00,280.00,0.00,0.00,0.00,0.00,0.00,500593),('1','138','169416','323',261.00,280.00,0.00,0.00,0.00,0.00,0.00,500597),('1','138','169420','323',261.00,280.00,0.00,0.00,0.00,0.00,0.00,500607),('1','138','169443','323',261.00,304.00,0.00,9723.00,2537703.00,2830608.00,292905.00,500664),('1','138','169567','323',261.00,304.00,0.00,7521.90,1963215.90,2203623.60,240407.70,500991),('1','138','169692','323',261.00,304.00,0.00,7485.20,1953637.20,2189250.80,235613.60,501326),('1','138','169695','323',261.00,292.00,0.00,0.00,0.00,0.00,0.00,501333),('1','138','169766','323',261.00,304.00,0.00,2828.40,738212.40,828207.60,89995.20,501525),('1','138','169923','323',261.00,304.00,0.00,6027.80,1573255.80,1758272.40,185016.60,501954),('1','138','170122','323',261.00,304.00,0.00,6222.20,1623994.20,1827129.20,203135.00,502452),('1','138','170300','323',261.00,304.00,0.00,4042.50,1055092.50,1185942.00,130849.50,502925),('1','138','170305','323',261.00,292.00,0.00,0.00,0.00,0.00,0.00,502936),('1','138','170481','323',261.00,304.00,0.00,10007.70,2612009.70,2912501.60,300491.90,503401),('1','138','170650','323',261.00,304.00,0.00,9878.70,2578340.70,2864228.80,285888.10,503834),('1','138','170732','323',261.00,284.00,0.00,0.00,0.00,0.00,0.00,504052),('1','138','170733','323',261.00,284.00,0.00,0.00,0.00,0.00,0.00,504053),('1','138','170734','323',261.00,292.00,0.00,0.00,0.00,0.00,0.00,504054),('1','138','170807','323',261.00,304.00,0.00,4937.50,1288687.50,1438666.00,149978.50,504250),('1','138','170977','323',261.00,320.00,0.00,8686.60,2267202.60,2538879.60,271677.00,504698),('1','138','171208','323',261.00,320.00,0.00,8787.10,2293433.10,2574043.60,280610.50,505323),('1','138','171287','323',261.00,320.00,0.00,2068.40,539852.40,606352.80,66500.40,505532),('1','138','171291','323',261.00,284.00,0.00,0.00,0.00,0.00,0.00,505542),('1','138','171370','323',261.00,320.00,0.00,3712.70,969014.70,1088193.60,119178.90,505740),('1','138','171583','323',261.00,320.00,0.00,7051.30,1840389.30,2070042.00,229652.70,506319),('1','138','171762','323',261.00,320.00,0.00,9287.80,2424115.80,2716936.00,292820.20,506792),('1','138','171871','323',261.00,320.00,0.00,4744.70,1238366.70,1395972.00,157605.30,507080),('1','138','171872','323',261.00,292.00,0.00,0.00,0.00,0.00,0.00,507081),('1','138','171948','323',261.00,320.00,0.00,8284.10,2162150.10,2419447.20,257297.10,507282),('1','138','172077','323',261.00,320.00,0.00,6782.20,1770154.20,1999906.40,229752.20,507620),('1','138','172222','323',261.00,320.00,0.00,9671.40,2524235.40,2824076.80,299841.40,508013),('1','138','172225','323',261.00,284.00,0.00,0.00,0.00,0.00,0.00,508020),('1','138','172262','323',261.00,320.00,0.00,2785.20,726937.20,816952.00,90014.80,508118),('1','138','172474','323',261.00,320.00,0.00,10362.10,2704508.10,3022314.00,317805.90,508679),('1','138','172692','323',261.00,320.00,0.00,10265.10,2679191.10,2991810.80,312619.70,509252),('1','138','172726','323',261.00,320.00,0.00,1480.30,386358.30,432667.60,46309.30,509335),('1','138','172729','323',261.00,284.00,0.00,0.00,0.00,0.00,0.00,509340),('1','138','172866','323',261.00,320.00,0.00,7115.30,1857093.30,2079064.80,221971.50,509711),('1','138','173058','323',261.00,320.00,0.00,11466.40,2992730.40,3351657.20,358926.80,510215),('1','138','173217','323',261.00,320.00,0.00,6068.80,1583956.80,1786994.00,203037.20,510642),('1','138','173219','323',261.00,284.00,0.00,0.00,0.00,0.00,0.00,510646),('1','138','173220','323',261.00,320.00,0.00,6168.70,1610030.70,1790725.20,180694.50,510647),('1','138','173388','323',261.00,320.00,0.00,8905.30,2324283.30,2601635.60,277352.30,511088),('1','138','173596','323',261.00,320.00,0.00,9799.70,2557721.70,2852572.00,294850.30,511643),('1','138','173597','323',261.00,284.00,0.00,0.00,0.00,0.00,0.00,511644),('1','138','173599','323',261.00,320.00,0.00,2973.60,776109.60,876680.00,100570.40,511648),('1','138','173755','323',261.00,320.00,0.00,11898.20,3105430.20,3475044.40,369614.20,512071),('1','138','173931','323',261.00,320.00,0.00,8944.30,2334462.30,2625024.00,290561.70,512531),('1','138','173987','323',261.00,320.00,0.00,959.60,250455.60,281835.60,31380.00,512680),('1','138','173988','323',261.00,292.00,0.00,0.00,0.00,0.00,0.00,512681),('1','138','174122','323',261.00,320.00,0.00,7649.30,1996467.30,2229064.00,232596.70,513040),('1','138','174311','323',261.00,320.00,0.00,10578.00,2760858.00,3083634.00,322776.00,513534),('1','138','174446','323',261.00,320.00,0.00,6320.40,1649624.40,1852228.00,202603.60,513878),('1','138','174448','323',261.00,284.00,0.00,0.00,0.00,0.00,0.00,513882),('1','138','174482','323',278.00,320.00,0.00,4429.90,1231512.20,1288140.00,56627.80,513966),('1','138','174647','323',278.00,320.00,0.00,8757.60,2434612.80,2566700.00,132087.20,514374),('1','138','174845','323',278.00,320.00,0.00,11329.30,3149545.40,3320642.00,171096.60,514910),('1','138','174865','323',278.00,284.00,0.00,0.00,0.00,0.00,0.00,514956),('1','138','175227','323',278.00,360.00,0.00,3567.40,991737.20,1146506.00,154768.80,515928),('1','138','175399','323',278.00,0.00,0.00,3104.20,862967.60,1006123.20,143155.60,516380),('1','138','175586','323',278.00,360.00,0.00,5471.10,1520965.80,1733360.00,212394.20,516863),('1','138','175756','323',278.00,360.00,0.00,12609.00,3505302.00,3949272.00,443970.00,517311),('1','138','175759','323',278.00,308.00,0.00,0.00,0.00,0.00,0.00,517316),('1','138','175920','323',290.00,360.00,0.00,11569.70,3355213.00,3647618.40,292405.40,517730),('1','138','176141','323',290.00,360.00,0.00,7891.70,2288593.00,2510929.60,222336.60,518296),('1','138','176325','323',290.00,360.00,0.00,5368.60,1556894.00,1690325.60,133431.60,518762),('1','138','176327','323',300.00,313.00,0.00,36.00,10800.00,11232.00,432.00,518764),('1','138','176529','323',293.00,360.00,0.00,6517.70,1909686.10,2063727.60,154041.50,519307),('1','138','176754','323',293.00,360.00,0.00,11251.20,3296601.60,3542978.40,246376.80,519916),('1','138','176946','323',293.00,360.00,0.00,6997.30,2050208.90,2207839.20,157630.30,520435),('1','138','176949','323',293.00,312.00,0.00,0.00,0.00,0.00,0.00,520439),('1','138','177213','323',293.00,360.00,0.00,9745.20,2855343.60,3072469.60,217126.00,521114),('1','138','177403','323',293.00,360.00,0.00,7498.30,2197001.90,2360216.80,163214.90,521612),('1','138','177609','323',293.00,360.00,0.00,5810.30,1702417.90,1847757.60,145339.70,522169),('1','138','177737','323',293.00,360.00,0.00,1757.90,515064.70,556106.40,41041.70,522522),('1','138','177739','323',293.00,308.00,0.00,0.00,0.00,0.00,0.00,522526),('1','138','177857','323',293.00,360.00,0.00,3871.80,1134437.40,1223232.00,88794.60,522838),('1','138','178050','323',293.00,360.00,0.00,6959.50,2039133.50,2194674.40,155540.90,523354),('1','138','178269','323',293.00,360.00,0.00,6866.10,2011767.30,2169872.80,158105.50,523918),('1','138','178466','323',293.00,360.00,0.00,6346.50,1859524.50,2009383.20,149858.70,524431),('1','138','178558','323',293.00,360.00,0.00,772.60,226371.80,246312.00,19940.20,524670),('1','138','178562','323',293.00,308.00,0.00,0.00,0.00,0.00,0.00,524680),('1','138','178700','323',293.00,360.00,0.00,1875.90,549638.70,625053.80,75415.10,525043),('1','138','178866','323',293.00,360.00,0.00,6222.60,1823221.80,2025245.00,202023.20,525482),('1','138','178928','323',293.00,360.00,0.00,2929.14,858238.02,945765.40,87527.38,525619),('1','138','179111','323',293.00,360.00,0.00,1933.80,566603.40,634416.00,67812.60,526106),('1','138','179350','323',293.00,360.00,0.00,4141.60,1213488.80,1358922.20,145433.40,526759),('1','138','179378','323',293.00,322.00,0.00,6535.59,1914927.87,2123034.00,208106.13,526819),('1','138','179574','323',293.00,360.00,0.00,1097.50,321567.50,358525.00,36957.50,527341),('1','138','179609','323',293.00,318.00,0.00,0.00,0.00,0.00,0.00,527430),('1','138','179621','323',293.00,360.00,0.00,3828.57,1121771.01,1256111.20,134340.19,527464),('1','138','179774','323',293.00,360.00,0.00,5236.22,1534212.46,1719479.60,185267.14,527882),('1','138','180005','323',293.00,360.00,0.00,7206.97,2111642.21,2375222.60,263580.39,528471),('1','138','180178','323',293.00,360.00,0.00,7996.81,2343065.33,2605037.60,261972.27,528937),('1','138','180299','323',293.00,318.00,0.00,0.00,0.00,0.00,0.00,529246),('1','138','180338','323',293.00,360.00,0.00,10163.50,2977905.50,3289672.00,311766.50,529345),('1','138','180548','323',293.00,360.00,0.00,7164.98,2099339.14,2315369.60,216030.46,529906),('1','138','180738','323',293.00,360.00,0.00,4059.02,1189292.86,1330823.60,141530.74,530394),('1','138','180958','323',293.00,360.00,0.00,2836.10,830977.30,923697.00,92719.70,530990),('1','138','181021','323',293.00,318.00,0.00,0.00,0.00,0.00,0.00,531149),('1','138','181133','323',293.00,360.00,0.00,9541.81,2795750.33,3067153.60,271403.27,531446),('1','138','181335','323',293.00,360.00,0.00,12526.36,3670223.48,4014885.60,344662.12,531996),('1','138','181525','323',293.00,360.00,0.00,2552.47,747873.71,824253.20,76379.49,532488),('1','138','181572','323',293.00,316.00,0.00,0.00,0.00,0.00,0.00,532606),('1','138','181589','323',293.00,360.00,0.00,5512.00,1615016.00,1774456.00,159440.00,532648),('1','138','181709','323',293.00,320.00,0.00,10671.22,3126667.46,3427688.00,301020.54,532968),('1','138','181906','323',293.00,320.00,0.00,8377.24,2454531.32,2681890.40,227359.08,533508),('1','138','182065','323',293.00,316.00,0.00,0.00,0.00,0.00,0.00,533948),('1','138','182068','323',293.00,316.00,0.00,11165.54,3438986.32,3588214.00,149227.68,533954),('1','138','182310','323',308.00,360.00,0.00,13252.09,4081643.72,4243202.80,161559.08,534561),('1','138','182481','323',308.00,316.00,0.00,0.00,0.00,0.00,0.00,535036),('1','138','182500','323',308.00,360.00,0.00,11204.28,3450918.24,3584816.80,133898.56,535075),('1','138','182688','323',308.00,360.00,0.00,13144.40,4048475.20,4219528.00,171052.80,535569),('1','138','183091','323',308.00,316.00,0.00,0.00,0.00,0.00,0.00,536670),('1','138','183096','323',308.00,360.00,0.00,10917.20,3362497.60,3511544.00,149046.40,536677),('1','138','183148','323',308.00,360.00,0.00,8596.90,2647845.20,2757356.00,109510.80,536800),('1','138','183150','323',308.00,316.00,0.00,0.00,0.00,0.00,0.00,536804),('1','138','183207','323',313.00,360.00,0.00,11314.92,3541569.96,3640231.20,98661.24,536955),('1','138','183427','323',313.00,360.00,0.00,9408.00,2944704.00,3022865.60,78161.60,537518),('1','138','183730','323',313.00,360.00,0.00,3647.89,1141789.57,1177692.40,35902.83,538317),('1','138','183826','323',313.00,312.00,0.00,0.00,0.00,0.00,0.00,538587),('1','138','183849','323',308.00,360.00,0.00,0.00,0.00,0.00,0.00,538644),('1','138','183894','323',308.00,360.00,0.00,1321.20,406929.60,428620.00,21690.40,538757),('1','138','183905','323',308.00,360.00,0.00,11955.69,3682352.52,3832769.20,150416.68,538786),('1','138','184270','323',308.00,360.00,0.00,0.00,0.00,0.00,0.00,539758),('1','138','184292','323',308.00,360.00,0.00,11323.10,3487514.80,3624962.80,137448.00,539812),('1','138','184297','323',308.00,312.00,0.00,0.00,0.00,0.00,0.00,539825),('1','138','184307','323',308.00,360.00,0.00,10597.73,3264100.84,3398344.80,134243.96,539849),('1','138','184485','323',308.00,360.00,0.00,14046.48,4326315.84,4505916.80,179600.96,540303),('1','138','184664','323',308.00,312.00,0.00,0.00,0.00,0.00,0.00,540811),('1','138','184687','323',308.00,360.00,0.00,19794.57,6096727.56,6337984.40,241256.84,540864),('1','138','184883','323',308.00,360.00,0.00,4910.96,1512575.68,1577393.60,64817.92,541386),('1','138','185003','323',308.00,312.00,0.00,0.00,0.00,0.00,0.00,541702),('1','138','185015','323',318.00,360.00,0.00,5140.75,1634758.50,1648748.00,13989.50,541732),('1','138','185107','323',318.00,360.00,0.00,13957.60,4438516.80,4473644.00,35127.20,541960),('1','138','185259','323',318.00,360.00,0.00,5187.91,1649755.38,1650375.60,620.22,542336),('1','138','185325','323',318.00,312.00,0.00,5680.90,1778121.70,1834170.40,56048.70,542503),('1','138','185468','323',313.00,360.00,0.00,12879.67,4031336.71,4196102.80,164766.09,542888),('1','138','185677','323',313.00,360.00,0.00,6179.01,1934030.13,2023377.60,89347.47,543445),('1','138','185777','323',313.00,320.00,0.00,0.00,0.00,0.00,0.00,543715),('1','138','185870','323',313.00,360.00,0.00,9251.63,2895760.19,3030496.16,134735.97,543966),('1','138','186095','323',313.00,360.00,0.00,14679.19,4594586.47,4803950.80,209364.33,544557),('1','138','186345','323',313.00,360.00,0.00,689.60,215844.80,226188.80,10344.00,545203),('1','138','186359','323',313.00,320.00,0.00,0.00,0.00,0.00,0.00,545242),('1','138','186615','323',313.00,360.00,0.00,12186.54,3814387.02,3976244.00,161856.98,545932),('1','138','186751','323',313.00,360.00,0.00,10503.46,3287582.98,3433540.40,145957.42,546273),('1','138','186903','323',313.00,320.00,0.00,0.00,0.00,0.00,0.00,546664),('1','138','186980','323',313.00,360.00,0.00,10481.83,3280812.79,3434518.00,153705.21,546846),('1','138','187163','323',313.00,360.00,0.00,9543.93,2987250.09,3126526.80,139276.71,547337),('1','138','187360','323',313.00,360.00,0.00,3493.05,1093324.65,1146412.80,53088.15,547851),('1','138','187480','323',313.00,320.00,0.00,0.00,0.00,0.00,0.00,548177),('1','138','187487','323',313.00,360.00,0.00,1401.37,438628.81,469642.00,31013.19,548196),('1','138','187586','323',313.00,360.00,0.00,11825.95,3701522.35,3880160.00,178637.65,548447),('1','138','187802','323',313.00,360.00,0.00,10055.81,3147468.53,3294191.20,146722.67,549023),('1','138','187982','323',313.00,320.00,0.00,0.00,0.00,0.00,0.00,549501),('1','138','188018','323',313.00,360.00,0.00,8424.25,2636790.25,2769616.40,132826.15,549587),('1','138','188234','323',313.00,360.00,0.00,11272.30,3528229.90,3699446.80,171216.90,550142),('1','138','188417','323',313.00,360.00,0.00,4823.86,1509868.18,1587211.60,77343.42,550625),('1','138','188517','323',313.00,360.00,0.00,0.00,0.00,0.00,0.00,550873),('1','138','188528','323',313.00,360.00,0.00,7567.70,2368690.10,2474610.40,105920.30,550902),('1','138','188605','323',313.00,360.00,0.00,10281.07,3217974.91,3384289.20,166314.29,551097),('1','138','188805','323',313.00,360.00,0.00,6837.09,2140009.17,2240100.00,100090.83,551629),('1','138','188899','323',313.00,360.00,0.00,0.00,0.00,0.00,0.00,551878),('1','138','188915','323',313.00,360.00,0.00,7526.20,2355700.60,2458850.00,103149.40,551923),('1','138','189028','323',313.00,360.00,0.00,12657.42,3961772.46,4147087.20,185314.74,552207),('1','138','189202','323',313.00,360.00,0.00,4433.30,1387622.90,1453180.80,65557.90,552671),('1','138','189299','323',313.00,360.00,0.00,0.00,0.00,0.00,0.00,552927),('1','138','189324','323',313.00,360.00,0.00,5473.28,1713136.64,1793848.80,80712.16,553000),('1','138','189431','323',313.00,360.00,0.00,13574.49,4248815.37,4450617.60,201802.23,553265),('1','138','189623','323',313.00,360.00,0.00,5597.53,1752026.89,1850963.60,98936.71,553763),('1','138','189778','323',313.00,320.00,0.00,0.00,0.00,0.00,0.00,554168),('1','138','189814','323',313.00,360.00,0.00,12368.56,3871359.28,4060354.40,188995.12,554257),('1','138','190030','323',313.00,360.00,0.00,6226.32,1948838.16,2062126.80,113288.64,554827),('1','138','190215','323',313.00,360.00,0.00,6255.35,1957924.55,2049268.88,91344.33,555307),('1','138','190362','323',313.00,320.00,0.00,0.00,0.00,0.00,0.00,555699),('1','138','190374','323',313.00,360.00,0.00,3276.81,1025641.53,1064047.60,38406.07,555733),('1','138','190436','323',313.00,360.00,0.00,13927.53,4359316.89,4572231.68,212914.79,555883),('1','138','190668','323',313.00,360.00,0.00,7431.22,2325971.86,2430402.80,104430.94,556505),('1','138','190838','323',313.00,320.00,0.00,1560.20,488342.60,521384.00,33041.40,556959),('1','138','191088','323',313.00,360.00,0.00,7034.75,2201876.75,2312930.40,111053.65,557596),('1','138','191299','323',313.00,360.00,0.00,9775.48,3059725.24,3227080.16,167354.92,558153),('1','138','191469','323',313.00,320.00,0.00,0.00,0.00,0.00,0.00,558620),('1','138','191493','323',313.00,360.00,0.00,8659.46,2710410.98,2862972.80,152561.82,558674),('1','138','191711','323',313.00,360.00,0.00,7454.16,2333152.08,2470825.60,137673.52,559251),('1','138','191939','323',313.00,360.00,0.00,7695.73,2408763.49,2535389.20,126625.71,559864),('1','138','192127','323',313.00,360.00,0.00,852.20,266738.60,282280.00,15541.40,560366),('1','138','192186','323',313.00,360.00,0.00,0.00,0.00,0.00,0.00,560513),('1','138','192201','323',313.00,360.00,0.00,6576.14,2058331.82,2170178.40,111846.58,560554),('1','138','192339','323',313.00,360.00,0.00,8650.50,2707606.50,2858808.00,151201.50,560916),('1','138','192573','323',313.00,360.00,0.00,5257.00,1645441.00,1744904.00,99463.00,561516),('1','138','192752','323',313.00,360.00,0.00,4143.53,1296924.89,1381430.80,84505.91,561997),('1','138','192884','323',313.00,360.00,0.00,0.00,0.00,0.00,0.00,562341),('1','138','192889','323',313.00,360.00,0.00,2320.69,726375.97,769736.40,43360.43,562354),('1','138','192953','323',313.00,360.00,0.00,7269.94,2275491.22,2398972.40,123481.18,562519),('1','138','193165','323',313.00,360.00,0.00,4897.01,1532764.13,1624355.60,91591.47,563080),('1','138','193421','323',313.00,360.00,0.00,7163.02,2242025.26,2368653.20,126627.94,563740),('1','138','193617','323',313.00,360.00,0.00,2888.67,904153.71,957569.20,53415.49,564274),('1','138','193747','323',313.00,360.00,0.00,0.00,0.00,0.00,0.00,564583),('1','138','193752','323',313.00,360.00,0.00,0.00,0.00,0.00,0.00,564594),('1','138','193756','323',313.00,360.00,0.00,1514.27,473966.51,506425.20,32458.69,564603),('1','138','193877','323',313.00,360.00,0.00,7564.22,2367600.86,2493128.80,125527.94,564904),('1','138','194079','323',313.00,360.00,0.00,5445.25,1704363.25,1808514.00,104150.75,565418),('1','138','194282','323',313.00,360.00,0.00,9902.64,3099526.32,3270464.80,170938.48,565959),('1','138','194512','323',313.00,360.00,0.00,21.00,6573.00,6888.00,315.00,566519),('1','138','194514','323',313.00,360.00,0.00,0.00,0.00,0.00,0.00,566522),('1','138','194527','323',313.00,360.00,0.00,6921.25,2166351.25,2285669.04,119317.79,566553),('1','138','194662','323',313.00,360.00,0.00,7843.30,2454952.90,2585029.20,130076.30,566917),('1','138','194876','323',313.00,360.00,0.00,4349.24,1361312.12,1447154.40,85842.28,567481),('1','138','195113','323',313.00,360.00,0.00,5279.92,1652614.96,1728926.40,76311.44,568090),('1','138','195246','323',313.00,360.00,0.00,0.00,0.00,0.00,0.00,568444),('1','138','195258','323',313.00,360.00,0.00,2138.30,669287.90,703948.00,34660.10,568474),('1','138','195320','323',313.00,360.00,0.00,11835.37,3704470.81,3893521.20,189050.39,568611),('1','138','195542','323',313.00,360.00,0.00,4277.36,1338813.68,1420401.60,81587.92,569189),('1','138','195791','323',313.00,360.00,0.00,5245.90,1641966.70,1737978.80,96012.10,569808),('1','138','196005','323',313.00,360.00,0.00,848.70,265643.10,279317.60,13674.50,570360),('1','138','196065','323',313.00,360.00,0.00,4887.27,1529715.51,1619551.60,89836.09,570509),('1','138','196248','323',313.00,360.00,0.00,5698.18,1783530.34,1889012.80,105482.46,570963),('1','138','196453','323',313.00,360.00,0.00,6336.76,1983405.88,2102813.36,119407.48,571498),('1','138','196660','323',313.00,360.00,0.00,7786.40,2437143.20,2554646.00,117502.80,572031),('1','138','196796','323',313.00,360.00,0.00,0.00,0.00,0.00,0.00,572391),('1','138','196810','323',313.00,360.00,0.00,1194.80,373972.40,391428.00,17455.60,572427),('1','138','196899','323',313.00,360.00,0.00,6997.82,2190317.66,2278100.00,87782.34,572656),('1','138','197030','323',313.00,360.00,0.00,4960.36,1552592.68,1615615.20,63022.52,572994),('1','138','197414','323',313.00,360.00,0.00,5566.50,1742314.50,1818336.00,76021.50,573921),('1','138','197421','323',313.00,360.00,0.00,4011.97,1255746.61,1313320.68,57574.07,573939),('1','138','197526','323',313.00,360.00,0.00,1468.56,459659.28,482853.60,23194.32,574184),('1','138','197669','323',313.00,360.00,0.00,0.00,0.00,0.00,0.00,574577),('1','138','197674','323',313.00,360.00,0.00,0.00,0.00,0.00,0.00,574589),('1','138','197680','323',313.00,360.00,0.00,2991.53,936348.89,980074.80,43725.91,574603),('1','138','197877','323',313.00,360.00,0.00,4188.74,1311075.62,1380636.00,69560.38,575135),('1','138','198118','323',313.00,360.00,0.00,4506.31,1410475.03,1470849.60,60374.57,575757),('1','138','198362','323',313.00,360.00,0.00,7338.50,2296950.50,2384020.00,87069.50,576382),('1','138','198575','323',313.00,360.00,0.00,5117.13,1601661.69,1650520.80,48859.11,576942),('1','138','198712','323',313.00,360.00,0.00,0.00,0.00,0.00,0.00,577313),('1','138','198714','323',313.00,360.00,0.00,0.00,0.00,0.00,0.00,577315),('1','138','198716','323',311.00,360.00,0.00,1475.22,458793.42,476647.20,17853.78,577319),('1','138','198794','323',311.00,360.00,0.00,7868.30,2447041.30,2540536.00,93494.70,577472),('1','138','198995','323',311.00,360.00,0.00,4292.41,1334939.51,1396419.60,61480.09,578001),('1','138','199223','323',311.00,360.00,0.00,9899.29,3078679.19,3190508.80,111829.61,578570),('1','138','199443','323',311.00,360.00,0.00,498.71,155098.81,164215.60,9116.79,579112),('1','138','199539','323',311.00,360.00,0.00,0.00,0.00,0.00,0.00,579356),('1','138','199541','323',311.00,360.00,0.00,0.00,0.00,0.00,0.00,579360),('1','138','199542','323',311.00,360.00,0.00,2829.91,880102.01,921643.60,41541.59,579361),('1','138','199666','323',311.00,360.00,0.00,7601.05,2363926.55,2452716.80,88790.25,579665),('1','138','199887','323',311.00,360.00,0.00,8209.27,2553082.97,2650791.20,97708.23,580200),('1','138','200099','323',311.00,360.00,0.00,5692.70,1770429.70,1829944.00,59514.30,580766),('1','138','200257','323',311.00,360.00,0.00,0.00,0.00,0.00,0.00,581191),('1','138','200261','323',311.00,360.00,0.00,0.00,0.00,0.00,0.00,581200),('1','138','200293','323',313.00,360.00,0.00,6765.80,2117695.40,2180628.00,62932.60,581271),('1','138','200494','323',313.00,360.00,0.00,5600.57,1752978.41,1813302.00,60323.59,581792),('1','138','200701','323',313.00,360.00,0.00,5326.55,1667210.15,1728094.00,60883.85,582334),('1','138','200935','323',313.00,360.00,0.00,6597.38,2064979.94,2130692.00,65712.06,582923),('1','138','201112','323',313.00,360.00,0.00,0.00,0.00,0.00,0.00,583381),('1','138','201121','323',313.00,360.00,0.00,7133.31,2232726.03,2296016.80,63290.77,583396),('1','138','201327','323',313.00,360.00,0.00,7385.35,2311614.55,2376108.00,64493.45,583929),('1','138','201516','323',313.00,360.00,0.00,9399.65,2942090.45,3032618.00,90527.55,584418),('1','138','201871','323',313.00,360.00,0.00,283.60,88766.80,90752.00,1985.20,585372),('1','138','201874','323',313.00,360.00,0.00,0.00,0.00,0.00,0.00,585377),('1','138','201878','323',313.00,360.00,0.00,0.00,0.00,0.00,0.00,585387),('1','138','201980','323',317.00,360.00,0.00,4599.40,1458009.80,1548452.80,90443.00,585664),('1','138','202084','323',317.00,360.00,0.00,0.00,0.00,0.00,0.00,585924),('1','138','202087','323',317.00,360.00,0.00,0.00,0.00,0.00,0.00,585928),('1','138','202168','323',317.00,360.00,0.00,3820.43,1211076.31,1282474.80,71398.49,586141),('1','138','202221','323',317.00,360.00,0.00,5549.53,1759201.01,1879484.40,120283.39,586274),('1','138','202438','323',317.00,360.00,0.00,2987.73,947110.41,1006318.80,59208.39,586834),('1','138','202562','323',317.00,360.00,0.00,0.00,0.00,0.00,0.00,587151),('1','138','202565','323',317.00,360.00,0.00,0.00,0.00,0.00,0.00,587157),('1','138','202582','323',317.00,360.00,0.00,1607.38,509539.46,547881.60,38342.14,587199),('1','138','202649','323',317.00,360.00,0.00,8322.43,2638210.31,2804371.60,166161.29,587375),('1','138','202870','323',317.00,360.00,0.00,7371.38,2336727.46,2487825.60,151098.14,587933),('1','138','203118','323',317.00,360.00,0.00,6825.81,2163781.77,2301802.64,138020.87,588586),('1','138','203339','323',317.00,360.00,0.00,0.00,0.00,0.00,0.00,589164),('1','138','203344','323',317.00,360.00,0.00,0.00,0.00,0.00,0.00,589177),('1','138','203384','323',317.00,360.00,0.00,4979.95,1578644.15,1676961.60,98317.45,589285),('1','138','203543','323',317.00,360.00,0.00,9709.80,3078006.60,3263943.52,185936.92,589678),('1','138','203728','323',317.00,376.00,0.00,9389.92,2882705.44,3159346.32,276640.88,590164),('1','138','203904','323',307.00,376.00,0.00,0.00,0.00,0.00,0.00,590631),('1','138','203908','323',307.00,376.00,0.00,0.00,0.00,0.00,0.00,590641),('1','138','203914','323',317.00,376.00,0.00,0.00,0.00,0.00,0.00,590656),('1','138','203934','323',317.00,376.00,0.00,2415.20,765618.40,818355.20,52736.80,590705),('1','138','203981','323',317.00,376.00,0.00,4429.78,1404240.26,1542173.28,137933.02,590804),('1','138','204216','323',317.00,376.00,0.00,6068.11,1923590.87,2104550.96,180960.09,591419),('1','138','204414','323',317.00,376.00,0.00,6446.01,2043385.17,2231107.76,187722.59,591935),('1','138','204629','323',317.00,376.00,0.00,4452.60,1411474.20,1532261.60,120787.40,592487),('1','138','204753','323',317.00,376.00,0.00,0.00,0.00,0.00,0.00,592814),('1','138','204756','323',317.00,376.00,0.00,0.00,0.00,0.00,0.00,592821),('1','138','204926','323',317.00,376.00,0.00,1348.50,427474.50,469916.00,42441.50,593216),('1','138','204973','323',317.00,376.00,0.00,7358.01,2332489.17,2541123.76,208634.59,593340),('1','138','205044','323',317.00,376.00,0.00,6366.71,2018247.07,2204615.76,186368.69,593518),('1','138','205266','323',317.00,376.00,0.00,4583.92,1453102.64,1589770.56,136667.92,594095),('1','138','205500','323',317.00,376.00,0.00,4212.27,1335289.59,1462171.92,126882.33,594686),('1','138','205801','323',317.00,376.00,0.00,0.00,0.00,0.00,0.00,595474),('1','138','205814','323',317.00,376.00,0.00,0.00,0.00,0.00,0.00,595512),('1','138','205823','323',376.00,376.00,0.00,4449.78,1673117.28,1545494.88,-127622.40,595532),('1','138','206002','323',376.00,376.00,0.00,5898.72,2217918.72,2044307.52,-173611.20,595995),('1','138','206172','323',376.00,376.00,0.00,4125.73,1551274.48,1448758.48,-102516.00,596427),('1','138','206348','323',376.00,376.00,0.00,5633.27,2118109.52,1957399.52,-160710.00,596886),('1','138','206573','323',376.00,376.00,0.00,3784.79,1423081.04,1309503.44,-113577.60,597451),('1','138','206698','323',376.00,376.00,0.00,0.00,0.00,0.00,0.00,597781),('1','138','206700','323',376.00,376.00,0.00,0.00,0.00,0.00,0.00,597785),('1','138','206726','323',318.00,376.00,0.00,2137.15,679613.70,741584.40,61970.70,597854),('1','138','206800','323',318.00,376.00,0.00,5026.11,1598302.98,1738310.16,140007.18,598036),('1','138','207032','323',318.00,376.00,0.00,9829.77,3125866.86,3398314.32,272447.46,598640),('1','138','207251','323',318.00,376.00,0.00,6898.98,2193875.64,2379709.76,185834.12,599207),('1','138','207427','323',318.00,376.00,0.00,0.00,0.00,0.00,0.00,599667),('1','138','207439','323',318.00,376.00,0.00,0.00,0.00,0.00,0.00,599699),('1','138','207538','323',318.00,376.00,0.00,10628.36,3379818.48,3672224.96,292406.48,599944),('1','138','207710','323',318.00,376.00,0.00,7875.21,2504316.78,2778888.64,274571.86,600376),('1','138','207909','323',318.00,384.00,0.00,4162.60,1323706.80,1485359.60,161652.80,600884),('1','138','208075','323',318.00,384.00,0.00,0.00,0.00,0.00,0.00,601319),('1','138','208077','323',318.00,384.00,0.00,0.00,0.00,0.00,0.00,601323),('1','138','208233','323',328.00,384.00,0.00,4170.94,1368068.32,1478104.96,110036.64,601725),('1','138','208285','323',328.00,384.00,0.00,0.00,0.00,0.00,0.00,601867),('1','138','208286','323',328.00,384.00,0.00,0.00,0.00,0.00,0.00,601868),('1','138','208387','323',335.00,384.00,0.00,8243.95,2761723.25,2925724.80,164001.55,602114),('1','138','208553','323',335.00,384.00,0.00,5715.91,1914829.85,2022625.44,107795.59,602539),('1','138','208781','323',335.00,384.00,0.00,9676.49,3241624.15,3411709.76,170085.61,603123),('1','138','209079','323',335.00,352.00,0.00,0.00,0.00,0.00,0.00,603872),('1','138','209087','323',335.00,352.00,0.00,0.00,0.00,0.00,0.00,603892),('1','138','209091','323',335.00,400.00,0.00,5339.50,1788732.50,1997092.00,208359.50,603902),('1','138','209208','323',335.00,400.00,0.00,6577.14,2203341.90,2462819.08,259477.18,604217),('1','138','209435','323',335.00,400.00,0.00,7097.13,2377538.55,2662324.00,284785.45,604786),('1','138','209660','323',335.00,400.00,0.00,4830.45,1618200.75,1818844.40,200643.65,605357),('1','138','209931','323',335.00,420.00,0.00,48.34,16193.90,20302.80,4108.90,606073),('1','138','209951','323',335.00,376.00,0.00,0.00,0.00,0.00,0.00,606127),('1','138','209959','323',335.00,376.00,0.00,0.00,0.00,0.00,0.00,606147),('1','138','209972','323',335.00,420.00,0.00,4222.40,1477840.00,1612265.04,134425.04,606175),('1','138','210060','323',350.00,376.00,0.00,0.00,0.00,0.00,0.00,606412),('1','138','210179','323',350.00,376.00,0.00,0.00,0.00,0.00,0.00,606709),('1','138','210189','323',350.00,420.00,0.00,1040.40,436968.00,436968.00,0.00,606733),('1','138','210310','323',420.00,420.00,0.00,892.16,374707.20,374707.20,0.00,607049),('1','138','210614','323',420.00,420.00,0.00,803.60,337512.00,337512.00,0.00,607846),('1','138','210780','323',420.00,420.00,0.00,1089.73,457686.60,457686.60,0.00,608281),('1','138','210959','323',420.00,420.00,0.00,265.02,111308.40,111308.40,0.00,608741),('1','138','211111','323',420.00,420.00,0.00,0.00,0.00,0.00,0.00,609138),('1','138','211121','323',420.00,420.00,0.00,0.00,0.00,0.00,0.00,609162),('1','138','211176','323',376.00,424.00,0.00,4801.09,1805209.84,1893222.16,88012.32,609298),('1','138','211417','323',376.00,424.00,0.00,6881.88,2587586.88,2721474.32,133887.44,609925),('1','138','211646','323',376.00,424.00,0.00,2973.48,1118028.48,1172043.52,54015.04,610522),('1','138','211790','323',376.00,424.00,0.00,8076.60,3036801.60,3170208.40,133406.80,610875),('1','138','212005','323',376.00,424.00,0.00,1080.80,406380.80,420459.20,14078.40,611437),('1','138','212130','323',376.00,392.00,0.00,0.00,0.00,0.00,0.00,611779),('1','138','212135','323',376.00,392.00,0.00,0.00,0.00,0.00,0.00,611788),('1','138','212148','323',376.00,424.00,0.00,926.10,351918.00,392666.40,40748.40,611824),('1','138','212250','323',380.00,424.00,0.00,1075.17,408564.60,455872.08,47307.48,612076),('1','138','212519','323',380.00,424.00,0.00,852.50,323950.00,361460.00,37510.00,612796),('1','138','212727','323',380.00,424.00,0.00,1005.98,382272.40,426535.52,44263.12,613344),('1','138','212942','323',380.00,424.00,0.00,364.59,138544.20,154586.16,16041.96,613904),('1','138','213184','323',380.00,424.00,0.00,0.00,0.00,0.00,0.00,614534),('1','138','213198','323',380.00,392.00,0.00,0.00,0.00,0.00,0.00,614574),('1','138','213208','323',424.00,424.00,0.00,4657.52,1974788.48,1837316.48,-137472.00,614599),('1','138','213423','323',424.00,424.00,0.00,4997.78,2119058.72,1979222.72,-139836.00,615139),('1','138','213648','323',424.00,424.00,0.00,4143.40,1756801.60,1638457.60,-118344.00,615745),('1','138','213918','323',424.00,424.00,0.00,5287.64,2241959.36,2083172.96,-158786.40,616447),('1','138','214264','323',424.00,424.00,0.00,4727.98,2004663.52,1853026.16,-151637.36,617363),('1','138','214270','323',424.00,292.00,0.00,0.00,0.00,0.00,0.00,617375),('1','138','214276','323',424.00,392.00,0.00,0.00,0.00,0.00,0.00,617391),('1','138','215154','323',376.00,424.00,0.00,0.00,0.00,0.00,0.00,619677),('1','138','215156','323',376.00,424.00,0.00,6102.60,2294577.60,2404820.80,110243.20,619681),('1','138','215164','323',376.00,424.00,0.00,8112.00,3050112.00,3200064.00,149952.00,619701),('1','138','215167','323',376.00,424.00,0.00,8194.50,3081132.00,3223760.00,142628.00,619708),('1','138','215170','323',376.00,424.00,0.00,2219.40,834494.40,874276.00,39781.60,619715),('1','138','215172','323',376.00,388.00,0.00,0.00,0.00,0.00,0.00,619719),('1','138','215189','323',380.00,392.00,0.00,0.00,0.00,0.00,0.00,619761),('1','138','215258','323',448.00,448.00,0.00,0.00,0.00,0.00,0.00,619926),('1','138','215370','323',376.00,424.00,0.00,614.50,231052.00,248708.00,17656.00,620228),('1','138','215381','323',380.00,448.00,0.00,1988.61,755671.80,842097.28,86425.48,620259),('1','138','215446','323',380.00,448.00,0.00,1568.79,596140.20,672124.16,75983.96,620409),('1','138','215633','323',380.00,448.00,0.00,0.00,0.00,0.00,0.00,620903),('1','138','215635','323',380.00,416.00,0.00,0.00,0.00,0.00,0.00,620908),('1','138','215804','323',380.00,448.00,0.00,4141.80,1573884.00,1740518.00,166634.00,621343),('1','138','215877','323',380.00,316.00,0.00,0.00,0.00,0.00,0.00,621528),('1','138','215878','323',380.00,316.00,0.00,0.00,0.00,0.00,0.00,621529),('1','138','216038','323',448.00,448.00,0.00,4576.60,2050316.80,1912550.40,-137766.40,621944),('1','138','216121','323',448.00,448.00,0.00,4784.07,2143263.36,2012366.40,-130896.96,622151),('1','138','216315','323',448.00,448.00,0.00,7455.69,3369971.88,3112027.88,-257944.00,622667),('1','138','216564','323',452.00,452.00,0.00,7897.82,3569814.64,3311482.64,-258332.00,623313),('1','138','216987','323',406.00,452.00,0.00,850.30,345221.80,384335.60,39113.80,624441),('1','138','217042','323',480.00,480.00,0.00,1688.07,810273.60,810273.60,0.00,624565),('1','138','217286','323',480.00,480.00,0.00,465.94,223651.20,223651.20,0.00,625209),('1','138','217365','323',480.00,480.00,0.00,0.00,0.00,0.00,0.00,625422),('1','138','217376','323',431.00,480.00,0.00,1116.99,481422.69,536155.20,54732.51,625448),('1','138','217499','323',431.00,480.00,0.00,1539.48,663515.88,738950.40,75434.52,625781),('1','138','217711','323',431.00,480.00,0.00,2521.21,1086641.51,1129828.80,43187.29,626321),('1','138','217928','323',431.00,480.00,0.00,0.00,0.00,0.00,0.00,626906),('1','138','218019','323',321.00,480.00,0.00,8667.28,2782196.88,3833896.40,1051699.52,627126),('1','138','218239','323',321.00,480.00,0.00,5739.54,2035571.34,2545250.40,509679.06,627708),('1','138','218454','323',421.00,480.00,0.00,4640.71,1953738.91,2062059.20,108320.29,628275),('1','138','218694','323',421.00,480.00,0.00,5211.55,2194062.55,2321846.80,127784.25,628893),('1','138','218869','323',421.00,436.00,0.00,0.00,0.00,0.00,0.00,629368),('1','138','218911','323',421.00,480.00,0.00,8559.86,3603701.06,3793452.80,189751.74,629468),('1','138','219122','323',421.00,480.00,0.00,5806.96,2444730.16,2578268.00,133537.84,630013),('1','138','219335','323',421.00,480.00,0.00,6161.47,2593978.87,2748215.60,154236.73,630576),('1','138','219594','323',421.00,480.00,0.00,3474.75,1462869.75,1551040.00,88170.25,631256),('1','138','219759','323',421.00,480.00,0.00,2125.53,894848.13,937178.40,42330.27,631706),('1','138','219823','323',421.00,480.00,0.00,8805.58,3707149.18,3905270.80,198121.62,631847),('1','138','220060','323',421.00,480.00,0.00,3791.45,1777864.99,1667269.60,-110595.39,632483),('1','138','220208','323',480.00,480.00,0.00,0.00,0.00,0.00,0.00,632896),('1','138','220261','323',480.00,480.00,0.00,6130.43,2942606.40,2672966.40,-269640.00,633018),('1','138','220472','323',480.00,480.00,0.00,3537.70,1698096.00,1541507.20,-156588.80,633567),('1','138','220647','323',480.00,480.00,0.00,0.00,0.00,0.00,0.00,634032),('1','138','220648','323',480.00,480.00,0.00,0.00,0.00,0.00,0.00,634033),('1','138','220687','323',413.00,480.00,0.00,6811.00,2812943.00,2969286.88,156343.88,634129),('1','138','220920','323',413.00,480.00,0.00,6085.94,2513493.22,2663680.80,150187.58,634732),('1','138','221148','323',413.00,480.00,0.00,5965.71,2463838.23,2617288.00,153449.77,635324),('1','138','221395','323',413.00,480.00,0.00,5415.78,2236717.14,2368416.40,131699.26,635972),('1','138','221651','323',413.00,480.00,0.00,303.60,125386.80,134448.00,9061.20,636636),('1','138','221684','323',413.00,428.00,0.00,0.00,0.00,0.00,0.00,636727),('1','138','221718','323',431.00,480.00,0.00,959.20,413415.20,460416.00,47000.80,636819),('1','138','221865','323',431.00,480.00,0.00,3480.48,1500086.88,1561758.40,61671.52,637189),('1','138','222074','323',431.00,480.00,0.00,650.76,280477.56,298884.80,18407.24,637741),('1','138','222128','323',431.00,436.00,0.00,0.00,0.00,0.00,0.00,637884),('1','138','222136','323',431.00,480.00,0.00,2186.00,942166.00,994532.00,52366.00,637898),('1','138','222282','323',431.00,480.00,0.00,1351.32,582418.92,648633.60,66214.68,638267),('1','138','222552','323',431.00,480.00,0.00,944.05,406885.55,453144.00,46258.45,638961),('1','138','222745','323',431.00,480.00,0.00,660.00,284460.00,316800.00,32340.00,639476),('1','138','223245','323',431.00,436.00,0.00,0.00,0.00,0.00,0.00,640778),('1','138','223252','323',431.00,480.00,0.00,914.20,394020.20,438816.00,44795.80,640793),('1','138','223257','323',431.00,480.00,0.00,1418.00,611158.00,680640.00,69482.00,640806),('1','138','223262','323',431.00,436.00,0.00,0.00,0.00,0.00,0.00,640814),('1','138','223267','323',431.00,480.00,0.00,979.43,422134.33,470126.40,47992.07,640823),('1','138','223426','323',431.00,480.00,0.00,2033.58,990768.84,954195.52,-36573.32,641227),('1','138','223603','323',512.00,436.00,0.00,0.00,0.00,0.00,0.00,641688),('1','138','223640','323',449.00,512.00,0.00,2947.26,1323319.74,1416938.40,93618.66,641777),('1','138','223876','323',449.00,512.00,0.00,3674.79,1649980.71,1745100.48,95119.77,642384),('1','138','224085','323',449.00,512.00,0.00,3720.26,1670396.74,1752930.00,82533.26,642927),('1','138','224309','323',449.00,512.00,0.00,3787.48,1700578.52,1858032.60,157454.08,643506),('1','138','224551','323',449.00,512.00,0.00,2647.19,1188588.31,1313456.34,124868.03,644140),('1','138','224778','323',449.00,512.00,0.00,2869.48,1417202.54,1412022.36,-5180.18,644723),('1','138','225021','323',512.00,512.00,0.00,4865.82,2491299.84,2372709.84,-118590.00,645346),('1','138','225279','323',512.00,512.00,0.00,100.00,51200.00,48400.00,-2800.00,646004),('1','138','225281','323',512.00,512.00,0.00,0.00,0.00,0.00,0.00,646006),('1','138','225318','323',459.00,512.00,0.00,4013.21,1842063.39,1961906.56,119843.17,646103),('1','138','225490','323',459.00,512.00,0.00,1237.64,568076.76,607025.20,38948.44,646554),('1','138','225602','323',459.00,480.00,0.00,0.00,0.00,0.00,0.00,646860),('1','138','225627','323',461.00,512.00,0.00,1201.60,553937.60,590335.60,36398.00,646923),('1','138','225698','323',461.00,512.00,0.00,4119.70,2143210.00,2031312.68,-111897.32,647097),('1','138','226027','323',544.00,486.00,0.00,0.00,0.00,0.00,0.00,647954),('1','138','226101','323',465.00,544.00,0.00,3933.14,1828910.10,1960867.16,131957.06,648156),('1','138','226228','323',465.00,544.00,0.00,6625.04,3080643.60,3294331.66,213688.06,648487),('1','138','226470','323',465.00,544.00,0.00,10567.14,4913720.10,5233303.76,319583.66,649103),('1','138','226728','323',465.00,544.00,0.00,3513.72,1633879.80,1727246.68,93366.88,649769),('1','138','226891','323',476.00,544.00,0.00,3625.58,1725776.08,1787830.72,62054.64,650205),('1','138','226966','323',476.00,544.00,0.00,8439.74,4017316.24,4175072.22,157755.98,650390),('1','138','227196','323',476.00,544.00,0.00,7083.05,3371531.80,3493163.78,121631.98,650983),('1','138','227429','323',476.00,544.00,0.00,0.00,0.00,0.00,0.00,651578),('1','138','227444','323',476.00,544.00,0.00,8965.74,4267692.24,4439319.56,171627.32,651619),('1','138','227606','323',476.00,544.00,0.00,10399.82,4950314.32,5131421.26,181106.94,652039),('1','138','227850','323',476.00,544.00,0.00,4222.64,2009976.64,2111178.88,101202.24,652672),('1','138','228129','323',476.00,544.00,0.00,963.14,458454.64,523948.16,65493.52,653405),('1','138','228297','323',476.00,544.00,0.00,0.00,0.00,0.00,0.00,653864),('1','138','228302','323',486.00,544.00,0.00,463.34,225183.24,252056.96,26873.72,653876),('1','138','228461','323',486.00,544.00,0.00,2117.91,1186029.60,1132596.00,-53433.60,654269),('1','138','228530','323',560.00,560.00,0.00,789.72,442243.20,410212.80,-32030.40,654439),('1','138','228584','323',560.00,560.00,0.00,0.00,0.00,0.00,0.00,654572),('1','138','228591','323',476.00,560.00,0.00,4415.21,2101639.96,2273505.60,171865.64,654588),('1','138','228761','323',476.00,560.00,0.00,6173.11,2938400.36,3191965.12,253564.76,655027),('1','138','228960','323',476.00,560.00,0.00,9291.28,4422649.28,4786669.20,364019.92,655524),('1','138','229266','323',476.00,560.00,0.00,4909.39,2336869.64,2552549.60,215679.96,656335),('1','138','229369','323',476.00,560.00,0.00,0.00,0.00,0.00,0.00,656621),('1','138','229473','323',516.00,584.00,0.00,1260.20,650263.20,735956.80,85693.60,656867),('1','138','229715','323',516.00,584.00,0.00,0.00,0.00,0.00,0.00,657486),('1','138','229723','323',526.00,584.00,0.00,881.81,463832.06,514977.04,51144.98,657506),('1','138','229945','323',526.00,584.00,0.00,1181.68,621563.68,690101.12,68537.44,658078),('1','138','230084','323',526.00,584.00,0.00,1791.24,942192.24,1046084.16,103891.92,658442),('1','138','230288','323',526.00,584.00,0.00,1393.14,732791.64,813593.76,80802.12,658957),('1','138','230431','323',526.00,584.00,0.00,0.00,0.00,0.00,0.00,659347),('1','138','230480','323',526.00,584.00,0.00,250.73,131883.98,146426.32,14542.34,659472),('1','138','230523','323',526.00,584.00,0.00,1756.99,924176.74,1026082.16,101905.42,659576),('1','138','230777','323',526.00,584.00,0.00,1492.93,785281.18,871871.12,86589.94,660240),('1','138','231065','323',526.00,584.00,0.00,1148.43,604074.18,670683.12,66608.94,660997),('1','138','231374','323',526.00,584.00,0.00,392.00,206192.00,228928.00,22736.00,661826),('1','138','231475','323',526.00,584.00,0.00,0.00,0.00,0.00,0.00,662090),('1','138','231500','323',526.00,584.00,0.00,1238.86,651640.36,723494.24,71853.88,662157),('1','138','231644','323',526.00,584.00,0.00,1227.21,645512.46,716690.64,71178.18,662527),('1','138','231890','323',526.00,584.00,0.00,2737.84,1440103.84,1598898.56,158794.72,663202),('1','138','232114','323',584.00,584.00,0.00,0.00,0.00,0.00,0.00,663791),('1','138','232120','323',516.00,584.00,0.00,4264.72,2200595.52,2429479.10,228883.58,663806),('1','138','232330','323',516.00,584.00,0.00,6169.12,3183265.92,3500550.68,317284.76,664348),('1','138','232587','323',600.00,600.00,0.00,5378.09,3226854.00,3061334.00,-165520.00,665034),('1','138','232847','323',600.00,600.00,0.00,5927.98,3556788.00,3372907.12,-183880.88,665723),('1','138','233123','323',600.00,600.00,0.00,3064.86,1838916.00,1751153.20,-87762.80,666430),('1','138','233305','323',600.00,562.00,0.00,0.00,0.00,0.00,0.00,666928),('1','138','233497','323',570.00,624.00,0.00,743.95,424051.50,464224.80,40173.30,667427),('1','138','233613','323',570.00,624.00,0.00,1618.43,922505.10,1009900.32,87395.22,667723),('1','138','233847','323',570.00,624.00,0.00,1775.83,1012223.10,1058515.12,46292.02,668335),('1','138','234024','323',570.00,624.00,0.00,0.00,0.00,0.00,0.00,668822),('1','138','234102','323',560.00,624.00,0.00,2490.57,1394719.20,1464857.68,70138.48,669006),('1','138','234329','323',560.00,624.00,0.00,5362.31,3002893.60,3133920.44,131026.84,669602),('1','138','234568','323',560.00,624.00,0.00,5605.52,3139091.20,3269255.24,130164.04,670250),('1','138','234814','323',560.00,624.00,0.00,5966.61,3341301.60,3480126.84,138825.24,670905),('1','138','235062','323',560.00,624.00,0.00,4892.65,2739884.00,2840297.02,100413.02,671576),('1','138','235239','323',560.00,574.00,0.00,0.00,0.00,0.00,0.00,672037),('1','138','235241','323',560.00,624.00,0.00,253.71,142077.60,151387.44,9309.84,672041),('1','138','235301','323',560.00,624.00,0.00,10542.10,5903576.00,6126107.32,222531.32,672190),('1','138','235526','323',560.00,624.00,0.00,2921.03,1635776.80,1716699.62,80922.82,672763),('1','138','235747','323',560.00,624.00,0.00,5501.34,3520857.60,3323537.60,-197320.00,673343),('1','138','236002','323',640.00,640.00,0.00,5280.23,3379347.20,3188812.40,-190534.80,674023),('1','138','236369','323',640.00,596.00,0.00,0.00,0.00,0.00,0.00,674985),('1','138','236379','323',582.00,640.00,0.00,9109.48,5301717.36,5483101.20,181383.84,675013),('1','138','236496','323',582.00,640.00,0.00,4423.22,2574314.04,2687217.60,112903.56,675326),('1','138','236723','323',582.00,640.00,0.00,6174.66,3593652.12,3727100.00,133447.88,675906),('1','138','236960','323',582.00,640.00,0.00,4970.16,2892633.12,3023289.20,130656.08,676515),('1','138','237158','323',582.00,640.00,0.00,50.00,29100.00,30000.00,900.00,677035),('1','138','237165','323',582.00,640.00,0.00,0.00,0.00,0.00,0.00,677042),('1','138','237184','323',582.00,640.00,0.00,4026.57,2343463.74,2456464.80,113001.06,677080),('1','138','237384','323',582.00,640.00,0.00,7428.15,4323183.30,4480129.20,156945.90,677600),('1','138','237602','323',656.00,656.00,0.00,5687.65,3731098.40,3550682.40,-180416.00,678177),('1','138','237868','323',656.00,656.00,0.00,7400.28,4774520.48,4541557.60,-232962.88,678871),('1','138','238115','323',640.00,640.00,0.00,0.00,0.00,0.00,0.00,679513),('1','138','238116','323',640.00,640.00,0.00,0.00,0.00,0.00,0.00,679514),('1','138','238120','323',592.00,640.00,0.00,5023.86,2974125.12,3066237.92,92112.80,679520),('1','138','238273','323',592.00,640.00,0.00,0.00,0.00,0.00,0.00,679910),('1','138','238276','323',592.00,640.00,0.00,4893.39,2896886.88,2981650.32,84763.44,679915),('1','138','238350','323',592.00,640.00,0.00,10359.14,6132610.88,6314073.44,181462.56,680109),('1','138','238601','323',592.00,640.00,0.00,9408.60,5569891.20,5736522.80,166631.60,680770),('1','138','238826','323',592.00,640.00,0.00,0.00,0.00,0.00,0.00,681351),('1','138','238837','323',592.00,640.00,0.00,5584.29,3305899.68,3398195.76,92296.08,681376),('1','138','238974','323',592.00,640.00,0.00,0.00,0.00,0.00,0.00,681734),('1','138','239124','323',592.00,640.00,0.00,5066.29,2999243.68,3081200.80,81957.12,682110),('1','138','239195','323',592.00,604.00,0.00,0.00,0.00,0.00,0.00,682310),('1','138','239216','323',592.00,640.00,0.00,3878.78,2296237.76,2372576.00,76338.24,682369),('1','138','239290','323',592.00,640.00,0.00,1162.75,688348.00,713056.00,24708.00,682557),('1','138','239397','323',592.00,640.00,0.00,0.00,0.00,0.00,0.00,682834),('1','138','239443','323',592.00,640.00,0.00,2962.57,1753841.44,1804285.76,50444.32,682957),('1','138','239517','323',592.00,640.00,0.00,2365.83,1400571.36,1444483.20,43911.84,683153),('1','138','239626','323',592.00,640.00,0.00,0.00,0.00,0.00,0.00,683426),('1','138','239639','323',592.00,640.00,0.00,5244.47,3104726.24,3191399.20,86672.96,683461),('1','138','239839','323',592.00,640.00,0.00,0.00,0.00,0.00,0.00,683985),('1','138','239840','323',592.00,640.00,0.00,4058.24,2477085.44,2493613.20,16527.76,683986),('1','138','239911','323',640.00,640.00,0.00,0.00,0.00,0.00,0.00,684174),('1','138','239921','323',602.00,640.00,0.00,2214.75,1333279.50,1382581.80,49302.30,684202),('1','138','239985','323',602.00,640.00,0.00,2915.04,1754854.08,1817170.20,62316.12,684371),('1','138','240144','323',602.00,618.00,0.00,0.00,0.00,0.00,0.00,684784),('1','138','240252','323',602.00,640.00,0.00,4685.03,2820388.06,2918553.20,98165.14,685042),('1','138','240442','323',602.00,640.00,0.00,170.50,102641.00,106960.00,4319.00,685555),('1','138','240492','323',602.00,640.00,0.00,0.00,0.00,0.00,0.00,685670),('1','138','240502','323',592.00,640.00,0.00,4339.88,2569208.96,2699554.40,130345.44,685697),('1','138','240682','323',592.00,640.00,0.00,1533.77,907991.84,962093.40,54101.56,686136),('1','138','240985','323',592.00,640.00,0.00,2889.66,1710678.72,1791858.58,81179.86,686932),('1','138','241215','323',592.00,640.00,0.00,6158.73,3645968.16,3754235.92,108267.76,687550),('1','138','241482','323',592.00,640.00,0.00,4147.28,2455189.76,2530656.20,75466.44,688255),('1','138','241731','323',592.00,640.00,0.00,4053.98,2399956.16,2469279.58,69323.42,688911),('1','138','241979','323',592.00,640.00,0.00,1248.43,739070.56,764628.00,25557.44,689558),('1','138','242073','323',592.00,602.00,0.00,0.00,0.00,0.00,0.00,689788),('1','138','242085','323',602.00,640.00,0.00,4716.57,2839375.14,2872728.80,33353.66,689822),('1','138','242195','323',602.00,640.00,0.00,157.03,94532.06,95977.20,1445.14,690118),('1','138','242257','323',602.00,640.00,0.00,0.00,0.00,0.00,0.00,690269),('1','138','242267','323',602.00,640.00,0.00,4373.76,2633003.52,2675859.50,42855.98,690294),('1','138','242419','323',602.00,640.00,0.00,1006.95,606183.90,614109.80,7925.90,690696),('1','138','242555','323',602.00,602.00,0.00,0.00,0.00,0.00,0.00,691047),('1','138','242556','323',592.00,640.00,0.00,3892.06,2304099.52,2370584.36,66484.84,691048),('1','138','242674','323',592.00,640.00,0.00,5111.57,3026049.44,3125316.46,99267.02,691353),('1','138','242909','323',592.00,640.00,0.00,5906.79,3775941.60,3573145.60,-202796.00,691979),('1','138','243147','323',640.00,640.00,0.00,5289.40,3385216.00,3204976.00,-180240.00,692589),('1','138','243358','323',640.00,640.00,0.00,4278.32,2738124.80,2585618.80,-152506.00,693159),('1','138','243592','323',640.00,640.00,0.00,240.67,154028.80,145602.00,-8426.80,693754),('1','138','243635','323',640.00,640.00,0.00,0.00,0.00,0.00,0.00,693854),('1','138','243640','323',592.00,640.00,0.00,4356.59,2579101.28,2635158.80,56057.52,693866),('1','138','243826','323',592.00,640.00,0.00,4813.32,2849485.44,2906227.60,56742.16,694361),('1','138','244038','323',592.00,640.00,0.00,5191.17,3073172.64,3142042.80,68870.16,694904),('1','138','244279','323',592.00,640.00,0.00,3713.53,2198409.76,2255332.80,56923.04,695537),('1','138','244509','323',592.00,640.00,0.00,3706.85,2194455.20,2258037.20,63582.00,696133),('1','138','244740','323',592.00,640.00,0.00,2791.39,1652502.88,1677933.60,25430.72,696736),('1','138','244850','323',592.00,595.00,0.00,0.00,0.00,0.00,0.00,697019),('1','138','244852','323',592.00,596.00,0.00,0.00,0.00,0.00,0.00,697023),('1','138','244861','323',592.00,640.00,0.00,1463.51,866397.92,893333.20,26935.28,697048),('1','138','244988','323',592.00,640.00,0.00,7113.39,4495662.48,4211606.88,-284055.60,697371),('1','138','245214','323',632.00,632.00,0.00,8418.63,5320574.16,4980171.32,-340402.84,697959),('1','138','245442','323',632.00,632.00,0.00,5452.76,3446144.32,3242594.32,-203550.00,698540),('1','138','245668','323',632.00,632.00,0.00,2269.76,1434488.32,1345497.88,-88990.44,699135),('1','138','245778','323',632.00,632.00,0.00,0.00,0.00,0.00,0.00,699399),('1','138','245781','323',572.00,632.00,0.00,4944.29,2828133.88,2918333.28,90199.40,699406),('1','138','245873','323',572.00,632.00,0.00,0.00,0.00,0.00,0.00,699668),('1','138','245934','323',572.00,632.00,0.00,5325.25,3280354.00,3019709.20,-260644.80,699825),('1','138','246089','323',616.00,616.00,0.00,0.00,0.00,0.00,0.00,700227),('1','138','246095','323',572.00,616.00,0.00,2791.63,1596812.36,1597184.08,371.72,700241),('1','138','246187','323',572.00,616.00,0.00,2233.57,1277602.04,1272079.32,-5522.72,700469),('1','138','246368','323',572.00,616.00,0.00,0.00,0.00,0.00,0.00,700968),('1','138','246439','323',558.00,616.00,0.00,5002.18,2791216.44,2846009.28,54792.84,701154),('1','138','246629','323',558.00,560.00,0.00,0.00,0.00,0.00,0.00,701654),('1','138','246634','323',558.00,616.00,0.00,1094.93,610970.94,626636.88,15665.94,701667),('1','138','246692','323',558.00,616.00,0.00,3590.82,2003677.56,2038448.60,34771.04,701816),('1','138','246958','323',558.00,616.00,0.00,407.00,227106.00,229808.00,2702.00,702480),('1','138','246981','323',558.00,616.00,0.00,0.00,0.00,0.00,0.00,702535),('1','138','246999','323',558.00,616.00,0.00,5024.09,2803442.22,2875776.28,72334.06,702577),('1','138','247120','323',558.00,616.00,0.00,0.00,0.00,0.00,0.00,702917),('1','138','247236','323',548.00,616.00,0.00,5100.36,2794997.28,2912615.36,117618.08,703198),('1','138','247402','323',548.00,616.00,0.00,2698.54,1478799.92,1565814.64,87014.72,703619),('1','138','247665','323',548.00,616.00,0.00,3952.27,2272968.56,2247523.08,-25445.48,704320),('1','138','247899','323',592.00,592.00,0.00,7276.47,4307670.24,4068224.76,-239445.48,704926),('1','138','248148','323',592.00,592.00,0.00,5506.50,3259848.00,3091608.40,-168239.60,705570),('1','138','248333','323',592.00,552.00,0.00,0.00,0.00,0.00,0.00,706051),('1','138','248336','323',592.00,552.00,0.00,0.00,0.00,0.00,0.00,706058),('1','138','248401','323',548.00,592.00,0.00,8076.00,4425648.00,4519068.84,93420.84,706219),('1','138','248633','323',548.00,592.00,0.00,6879.21,3769807.08,3843662.96,73855.88,706818),('1','138','248884','323',548.00,592.00,0.00,5792.25,3369345.80,3130980.94,-238364.86,707453),('1','138','249097','323',592.00,592.00,0.00,3967.06,2348499.52,2110952.52,-237547.00,708016),('1','138','249245','323',592.00,526.00,0.00,0.00,0.00,0.00,0.00,708382),('1','138','249248','323',500.00,592.00,0.00,1895.63,947815.00,1023446.96,75631.96,708389),('1','138','249335','323',500.00,592.00,0.00,5239.62,2619810.00,2805344.20,185534.20,708617),('1','138','249588','323',500.00,592.00,0.00,5661.85,2830925.00,3039817.20,208892.20,709256),('1','138','249844','323',500.00,592.00,0.00,6113.75,3056875.00,3283437.48,226562.48,709922),('1','138','250117','323',500.00,592.00,0.00,5442.32,2721160.00,2894662.14,173502.14,710600),('1','138','250256','323',500.00,592.00,0.00,0.00,0.00,0.00,0.00,710971),('1','138','250260','323',500.00,592.00,0.00,0.00,0.00,0.00,0.00,710980),('1','138','250261','323',500.00,592.00,0.00,995.60,497800.00,538369.20,40569.20,710981),('1','138','250338','323',500.00,592.00,0.00,6622.86,3311430.00,3533742.84,222312.84,711174),('1','138','250571','323',500.00,592.00,0.00,3886.55,1943275.00,2090383.94,147108.94,711758),('1','138','250807','323',500.00,592.00,0.00,6736.76,3368380.00,3614881.92,246501.92,712379),('1','138','251057','323',500.00,592.00,0.00,4499.78,2249890.00,2432950.76,183060.76,713016),('1','138','251276','323',500.00,592.00,0.00,1944.25,972125.00,1052183.50,80058.50,713594),('1','138','251382','323',500.00,526.00,0.00,0.00,0.00,0.00,0.00,713866),('1','138','251389','323',500.00,592.00,0.00,2901.06,1450530.00,1570878.50,120348.50,713885),('1','138','251531','323',500.00,592.00,0.00,5630.16,2815080.00,3028122.12,213042.12,714256),('1','138','251764','323',500.00,592.00,0.00,5957.31,2978655.00,3202787.40,224132.40,714876),('1','138','251993','323',500.00,592.00,0.00,4811.97,2405985.00,2608070.44,202085.44,715483),('1','138','252238','323',500.00,592.00,0.00,5313.15,2656575.00,2846503.40,189928.40,716121),('1','138','252402','323',500.00,526.00,0.00,0.00,0.00,0.00,0.00,716545),('1','138','252403','323',500.00,526.00,0.00,0.00,0.00,0.00,0.00,716546),('1','138','252532','323',510.00,592.00,0.00,5003.39,2551728.90,2672958.50,121229.60,716852),('1','138','252633','323',510.00,526.00,0.00,0.00,0.00,0.00,0.00,717143),('1','138','252757','323',510.00,592.00,0.00,4986.50,2543115.00,2701797.20,158682.20,717438),('1','138','252880','323',510.00,592.00,0.00,0.00,0.00,0.00,0.00,717780),('1','138','252977','323',510.00,592.00,0.00,4001.36,2040693.60,2182833.68,142140.08,718028),('1','138','253198','323',510.00,592.00,0.00,1363.73,806559.00,737050.16,-69508.84,718627),('1','138','253339','323',592.00,592.00,0.00,0.00,0.00,0.00,0.00,718977),('1','138','253340','323',500.00,592.00,0.00,3632.98,1816490.00,1939704.16,123214.16,718978),('1','138','253476','323',500.00,592.00,0.00,4974.42,2487210.00,2665706.64,178496.64,719336),('1','138','253724','323',500.00,592.00,0.00,4909.49,2454745.00,2626940.08,172195.08,719962),('1','138','253966','323',500.00,592.00,0.00,3080.93,1540465.00,1671109.80,130644.80,720594),('1','138','254200','323',500.00,592.00,0.00,7192.75,3596375.00,3825430.00,229055.00,721207),('1','138','254454','323',500.00,592.00,0.00,1005.30,502650.00,532611.60,29961.60,721869),('1','138','254543','323',500.00,592.00,0.00,0.00,0.00,0.00,0.00,722088),('1','138','254546','323',500.00,592.00,0.00,3410.05,1705025.00,1835508.64,130483.64,722093),('1','138','254704','323',500.00,592.00,0.00,5750.68,2875340.00,3075964.68,200624.68,722499),('1','138','254955','323',500.00,592.00,0.00,4935.90,2467950.00,2640079.60,172129.60,723137),('1','138','255203','323',500.00,592.00,0.00,4009.75,2004875.00,2160603.56,155728.56,723772),('1','138','255448','323',500.00,592.00,0.00,6682.16,3341080.00,3562040.80,220960.80,724400),('1','138','255671','323',500.00,520.00,0.00,0.00,0.00,0.00,0.00,724938),('1','138','255768','323',500.00,592.00,0.00,4307.37,2196758.70,2310728.52,113969.82,725170),('1','138','255939','323',510.00,592.00,0.00,1003.78,511927.80,534268.56,22340.76,725627),('1','138','256085','323',510.00,522.00,0.00,0.00,0.00,0.00,0.00,725980),('1','138','256118','323',500.00,592.00,0.00,1556.80,778400.00,864161.52,85761.52,726070),('1','138','256218','323',500.00,592.00,0.00,3781.60,1890800.00,2036811.80,146011.80,726299),('1','138','256478','323',500.00,592.00,0.00,5282.74,2641370.00,2821404.40,180034.40,726993),('1','138','256725','323',500.00,592.00,0.00,4037.41,2018705.00,2168917.24,150212.24,727626),('1','138','256964','323',500.00,592.00,0.00,5205.20,2602600.00,2793737.12,191137.12,728252),('1','138','257233','323',500.00,592.00,0.00,4141.69,2070845.00,2188513.28,117668.28,728953),('1','138','257397','323',500.00,520.00,0.00,0.00,0.00,0.00,0.00,729380),('1','138','257400','323',500.00,592.00,0.00,4647.16,2323580.00,2464396.72,140816.72,729387),('1','138','257483','323',500.00,568.00,0.00,4912.06,2456030.00,2585400.72,129370.72,729612),('1','138','257484','323',500.00,568.00,0.00,9557.10,4778550.00,4981336.04,202786.04,729613),('1','138','257485','323',500.00,568.00,0.00,5244.87,2622435.00,2707478.46,85043.46,729614),('1','138','257486','323',500.00,510.00,0.00,0.00,0.00,0.00,0.00,729615),('1','138','257487','323',500.00,510.00,0.00,0.00,0.00,0.00,0.00,729616),('1','138','257488','323',500.00,568.00,0.00,2097.47,1048735.00,1099589.96,50854.96,729617),('1','138','257489','323',500.00,568.00,0.00,2884.20,1442100.00,1495993.60,53893.60,729618),('1','138','257490','323',500.00,510.00,0.00,0.00,0.00,0.00,0.00,729619),('1','138','257491','323',490.00,568.00,0.00,3780.69,1852538.10,1975953.78,123415.68,729620),('1','138','257492','323',490.00,568.00,0.00,7000.22,3430107.80,3631715.00,201607.20,729621),('1','138','257493','323',490.00,568.00,0.00,6575.51,3221999.90,3433650.48,211650.58,729622),('1','138','257494','323',490.00,568.00,0.00,6964.53,3412619.70,3624206.30,211586.60,729623),('1','138','257495','323',490.00,510.00,0.00,0.00,0.00,0.00,0.00,729624),('1','138','257496','323',490.00,510.00,0.00,0.00,0.00,0.00,0.00,729625),('1','138','257497','323',490.00,568.00,0.00,7669.36,3757986.40,3985603.44,227617.04,729626),('1','138','257498','323',490.00,568.00,0.00,8699.61,4262808.90,4501800.86,238991.96,729627),('1','138','257499','323',490.00,568.00,0.00,5198.74,2547382.60,2726108.94,178726.34,729628),('1','138','257500','323',490.00,568.00,0.00,2835.53,1389409.70,1472461.88,83052.18,729629),('1','138','257501','323',490.00,510.00,0.00,0.00,0.00,0.00,0.00,729630),('1','138','257502','323',490.00,510.00,0.00,0.00,0.00,0.00,0.00,729631),('1','138','257503','323',500.00,568.00,0.00,2933.28,1466640.00,1539743.04,73103.04,729632),('1','138','257504','323',500.00,568.00,0.00,2321.10,1160550.00,1209141.78,48591.78,729633),('1','138','257505','323',500.00,510.00,0.00,0.00,0.00,0.00,0.00,729634),('1','138','257506','323',500.00,568.00,0.00,3071.26,1535630.00,1605285.68,69655.68,729635),('1','138','257507','323',500.00,568.00,0.00,1760.57,880285.00,915993.96,35708.96,729636),('1','138','257508','323',500.00,510.00,0.00,0.00,0.00,0.00,0.00,729637),('1','138','257509','323',490.00,568.00,0.00,3155.25,1546072.50,1651075.02,105002.52,729638),('1','138','257510','323',490.00,568.00,0.00,3701.87,1813916.30,1917576.16,103659.86,729639),('1','138','257511','323',490.00,568.00,0.00,7727.08,3786269.20,4011477.46,225208.26,729640),('1','138','257512','323',490.00,568.00,0.00,5102.64,2500293.60,2660272.94,159979.34,729641),('1','138','257513','323',490.00,568.00,0.00,4777.77,2341107.30,2472956.36,131849.06,729642),('1','138','257514','323',490.00,510.00,0.00,0.00,0.00,0.00,0.00,729643),('1','138','257515','323',500.00,568.00,0.00,5485.66,2742830.00,2836255.48,93425.48,729644),('1','138','257516','323',500.00,510.00,0.00,0.00,0.00,0.00,0.00,729645),('1','138','257517','323',500.00,568.00,0.00,638.97,319485.00,348435.96,28950.96,729646),('1','138','257518','323',500.00,568.00,0.00,4722.60,2361300.00,2456347.80,95047.80,729647),('1','138','257519','323',500.00,510.00,0.00,0.00,0.00,0.00,0.00,729648),('1','138','257520','323',500.00,568.00,0.00,1204.29,602145.00,646911.72,44766.72,729649),('1','138','257521','323',500.00,568.00,0.00,4030.92,2015460.00,2092764.94,77304.94,729650),('1','138','257522','323',500.00,510.00,0.00,0.00,0.00,0.00,0.00,729651),('1','138','257523','323',500.00,568.00,0.00,1256.67,628335.00,661624.56,33289.56,729652),('1','138','257524','323',500.00,568.00,0.00,3742.88,1871440.00,1952060.32,80620.32,729653),('1','138','257525','323',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729654),('1','138','257526','323',500.00,568.00,0.00,3593.16,1796580.00,1862579.88,65999.88,729655),('1','138','257527','323',500.00,568.00,0.00,1657.95,828975.00,857268.20,28293.20,729656),('1','138','257528','323',500.00,510.00,0.00,0.00,0.00,0.00,0.00,729657),('1','138','257529','323',500.00,568.00,0.00,4741.30,2370650.00,2478598.40,107948.40,729658),('1','138','257530','323',500.00,568.00,0.00,649.13,324565.00,338573.84,14008.84,729659),('1','138','257531','323',500.00,510.00,0.00,0.00,0.00,0.00,0.00,729660),('1','138','257532','323',490.00,568.00,0.00,6379.57,3125989.30,3309482.96,183493.66,729661),('1','138','257533','323',490.00,568.00,0.00,6667.76,3267202.40,3467776.48,200574.08,729662),('1','138','257534','323',490.00,568.00,0.00,6285.46,3079875.40,3269698.56,189823.16,729663),('1','138','257535','323',490.00,568.00,0.00,4874.35,2388431.50,2522784.80,134353.30,729664),('1','138','257536','323',490.00,510.00,0.00,0.00,0.00,0.00,0.00,729665),('1','138','257537','323',490.00,568.00,0.00,524.04,256779.60,278255.76,21476.16,729666),('1','138','257538','323',490.00,568.00,0.00,6814.71,3339207.90,3531187.74,191979.84,729667),('1','138','257539','323',490.00,568.00,0.00,4482.28,2196317.20,2343977.56,147660.36,729668),('1','138','257540','323',490.00,568.00,0.00,4465.42,2188055.80,2304974.12,116918.32,729669),('1','138','257541','323',490.00,568.00,0.00,8190.85,4013516.50,4251824.36,238307.86,729670),('1','138','257542','323',490.00,510.00,0.00,0.00,0.00,0.00,0.00,729671),('1','138','257543','323',490.00,568.00,0.00,7914.20,3877958.00,4103667.22,225709.22,729672),('1','138','257544','323',490.00,568.00,0.00,4964.36,2591395.92,2717556.40,126160.48,729673),('1','138','257545','323',522.00,580.00,0.00,8288.63,4326664.86,4496336.20,169671.34,729674),('1','138','257546','323',522.00,580.00,0.00,3814.62,1991231.64,2072911.60,81679.96,729675),('1','138','257547','323',522.00,536.00,0.00,0.00,0.00,0.00,0.00,729676),('1','138','257548','323',522.00,580.00,0.00,7413.32,3869753.04,4005895.60,136142.56,729677),('1','138','257549','323',522.00,580.00,0.00,6455.73,3369891.06,3518301.80,148410.74,729678),('1','138','257550','323',522.00,580.00,0.00,10661.75,5565433.50,5776116.60,210683.10,729679),('1','138','257551','323',522.00,536.00,0.00,0.00,0.00,0.00,0.00,729680),('1','138','257552','323',522.00,580.00,0.00,4820.39,2564447.48,2612891.80,48444.32,729681),('1','138','257553','323',532.00,536.00,0.00,0.00,0.00,0.00,0.00,729682),('1','138','257554','323',532.00,580.00,0.00,4849.50,2579934.00,2630760.40,50826.40,729683),('1','138','257555','323',532.00,536.00,0.00,0.00,0.00,0.00,0.00,729684),('1','138','257556','323',532.00,580.00,0.00,558.10,296909.20,304886.00,7976.80,729685),('1','138','257557','323',532.00,580.00,0.00,1609.70,856360.40,1030208.00,173847.60,729686),('1','138','257558','323',532.00,640.00,0.00,1895.97,1008656.04,1213420.80,204764.76,729687),('1','138','257559','323',532.00,640.00,0.00,977.40,519976.80,625536.00,105559.20,729688),('1','138','257560','323',532.00,640.00,0.00,0.00,0.00,0.00,0.00,729689),('1','138','257561','323',582.00,640.00,0.00,698.60,406585.20,447104.00,40518.80,729690),('1','138','257562','323',582.00,640.00,0.00,2098.34,1221233.88,1342937.60,121703.72,729691),('1','138','257563','323',582.00,640.00,0.00,2145.84,1248878.88,1373337.60,124458.72,729692),('1','138','257564','323',582.00,640.00,0.00,314.00,182748.00,200960.00,18212.00,729693),('1','138','257565','323',582.00,640.00,0.00,0.00,0.00,0.00,0.00,729694),('1','138','257566','323',582.00,640.00,0.00,921.50,536313.00,589760.00,53447.00,729695),('1','138','257567','323',582.00,680.00,0.00,1176.85,684926.70,784158.00,99231.30,729696),('1','138','257568','323',582.00,680.00,0.00,2058.95,1198308.90,1352294.00,153985.10,729697),('1','138','257569','323',582.00,680.00,0.00,811.78,472455.96,538010.40,65554.44,729698),('1','138','257570','323',582.00,640.00,0.00,0.00,0.00,0.00,0.00,729699),('1','138','257571','323',596.00,680.00,0.00,571.02,340327.92,381413.20,41085.28,729700),('1','138','257572','323',596.00,680.00,0.00,4819.25,2872273.00,2999730.00,127457.00,729701),('1','138','257573','323',596.00,680.00,0.00,6272.14,3738195.44,3884907.28,146711.84,729702),('1','138','257574','323',596.00,680.00,0.00,3022.66,1801505.36,1880103.92,78598.56,729703),('1','138','257575','323',596.00,680.00,0.00,6405.67,3817779.32,3929989.36,112210.04,729704),('1','138','257576','323',596.00,680.00,0.00,3026.32,1803686.72,1857143.60,53456.88,729705),('1','138','257577','323',596.00,604.00,0.00,0.00,0.00,0.00,0.00,729706),('1','138','257578','323',588.00,680.00,0.00,3538.14,2080426.32,2165032.08,84605.76,729707),('1','138','257579','323',588.00,680.00,0.00,6446.72,3790671.36,3954424.08,163752.72,729708),('1','138','257580','323',588.00,680.00,0.00,5531.87,3252739.56,3417955.60,165216.04,729709),('1','138','257581','323',588.00,680.00,0.00,6699.89,3939535.32,4106720.80,167185.48,729710),('1','138','257582','323',588.00,680.00,0.00,2344.59,1378618.92,1447153.20,68534.28,729711),('1','138','257583','323',588.00,604.00,0.00,0.00,0.00,0.00,0.00,729712),('1','138','257584','323',588.00,680.00,0.00,4046.08,2379095.04,2492647.16,113552.12,729713),('1','138','257585','323',588.00,680.00,0.00,3063.90,1801573.20,1940927.84,139354.64,729714),('1','138','257586','323',588.00,688.00,0.00,3929.34,2310451.92,2509742.80,199290.88,729715),('1','138','257587','323',588.00,688.00,0.00,3778.64,2221840.32,2404861.44,183021.12,729716),('1','138','257588','323',588.00,688.00,0.00,2357.07,1385957.16,1515412.80,129455.64,729717),('1','138','257589','323',588.00,688.00,0.00,3058.22,1798233.36,1910978.24,112744.88,729718),('1','138','257590','323',588.00,664.00,0.00,3896.01,2290853.88,2404469.40,113615.52,729719),('1','138','257591','323',588.00,608.00,0.00,0.00,0.00,0.00,0.00,729720),('1','138','257592','323',592.00,664.00,0.00,2059.67,1219324.64,1282744.88,63420.24,729721),('1','138','257593','323',592.00,664.00,0.00,2550.13,1509676.96,1585949.92,76272.96,729722),('1','138','257594','323',592.00,608.00,0.00,0.00,0.00,0.00,0.00,729723),('1','138','257595','323',592.00,664.00,0.00,3824.38,2264032.96,2373350.72,109317.76,729724),('1','138','257596','323',592.00,664.00,0.00,7163.55,4240821.60,4443355.28,202533.68,729725),('1','138','257597','323',592.00,664.00,0.00,5163.78,3056957.76,3199436.00,142478.24,729726),('1','138','257598','323',592.00,664.00,0.00,6562.22,3861696.32,4020051.01,158354.69,729727),('1','138','257599','323',588.00,664.00,0.00,2083.19,1224915.72,1266283.63,41367.91,729728),('1','138','257600','323',588.00,601.00,0.00,0.00,0.00,0.00,0.00,729729),('1','138','257601','323',592.00,664.00,0.00,5001.62,2960959.04,3056254.98,95295.94,729730),('1','138','257602','323',592.00,664.00,0.00,1043.67,617852.64,643841.03,25988.39,729731),('1','138','257603','323',592.00,601.00,0.00,0.00,0.00,0.00,0.00,729732),('1','138','257604','323',592.00,664.00,0.00,4339.57,2569025.44,2648228.95,79203.51,729733),('1','138','257605','323',592.00,664.00,0.00,2812.76,1665153.92,1723096.13,57942.21,729734),('1','138','257606','323',592.00,601.00,0.00,0.00,0.00,0.00,0.00,729735),('1','138','257607','323',592.00,664.00,0.00,1042.66,617254.72,656454.24,39199.52,729736),('1','138','257608','323',592.00,664.00,0.00,1572.66,931014.72,1044246.24,113231.52,729737),('1','138','257609','323',592.00,664.00,0.00,2376.69,1407000.48,1578122.16,171121.68,729738),('1','138','257610','323',592.00,664.00,0.00,929.64,550346.88,617280.96,66934.08,729739),('1','138','257611','323',592.00,601.00,0.00,0.00,0.00,0.00,0.00,729740),('1','138','257612','323',592.00,664.00,0.00,1325.72,784826.24,880278.08,95451.84,729741),('1','138','257613','323',592.00,664.00,0.00,1665.24,985822.08,1105719.36,119897.28,729742),('1','138','257614','323',592.00,664.00,0.00,1122.12,664295.04,745087.68,80792.64,729743),('1','138','257615','323',592.00,664.00,0.00,0.00,0.00,0.00,0.00,729744),('1','138','257616','323',592.00,664.00,0.00,3661.22,2167442.24,2283894.72,116452.48,729745),('1','138','257617','323',592.00,664.00,0.00,1673.58,990759.36,1019251.62,28492.26,729746),('1','138','257618','323',592.00,601.00,0.00,0.00,0.00,0.00,0.00,729747),('1','138','257619','323',592.00,664.00,0.00,7441.31,4405255.52,4557486.07,152230.55,729748),('1','138','257620','323',592.00,664.00,0.00,7515.93,4449430.56,4610576.41,161145.85,729749),('1','138','257621','323',592.00,664.00,0.00,7107.00,4207344.00,4340968.30,133624.30,729750),('1','138','257622','323',592.00,664.00,0.00,2855.05,1690189.60,1743553.50,53363.90,729751),('1','138','257623','323',592.00,601.00,0.00,0.00,0.00,0.00,0.00,729752),('1','138','257624','323',582.00,664.00,0.00,2611.83,1520085.06,1606077.12,85992.06,729753),('1','138','257625','323',582.00,664.00,0.00,6548.78,3811389.96,3972613.62,161223.66,729754),('1','138','257626','323',582.00,664.00,0.00,6619.35,3852461.70,4027630.38,175168.68,729755),('1','138','257627','323',582.00,664.00,0.00,6796.81,3955743.42,4118348.64,162605.22,729756),('1','138','257628','323',582.00,664.00,0.00,1625.30,945924.60,985702.54,39777.94,729757),('1','138','257629','323',582.00,594.00,0.00,0.00,0.00,0.00,0.00,729758),('1','138','257630','323',592.00,664.00,0.00,5326.85,3153495.20,3204413.40,50918.20,729759),('1','138','257631','323',592.00,594.00,0.00,0.00,0.00,0.00,0.00,729760),('1','138','257632','323',582.00,664.00,0.00,2567.09,1494046.38,1556237.46,62191.08,729761),('1','138','257633','323',582.00,664.00,0.00,6549.47,3811791.54,3965843.08,154051.54,729762),('1','138','257634','323',582.00,664.00,0.00,9885.07,5753110.74,5959689.04,206578.30,729763),('1','138','257635','323',582.00,664.00,0.00,629.60,366427.20,381028.40,14601.20,729764),('1','138','257636','323',582.00,594.00,0.00,0.00,0.00,0.00,0.00,729765),('1','138','257637','323',582.00,664.00,0.00,7816.58,4549249.56,4697802.12,148552.56,729766),('1','138','257638','323',582.00,664.00,0.00,8463.12,4925535.84,5110204.48,184668.64,729767),('1','138','257639','323',582.00,664.00,0.00,8510.70,4953227.40,5103226.16,149998.76,729768),('1','138','257640','323',582.00,594.00,0.00,0.00,0.00,0.00,0.00,729769),('1','138','257641','323',582.00,664.00,0.00,1048.70,610343.40,631656.80,21313.40,729770),('1','138','257642','323',582.00,664.00,0.00,9143.58,5321563.56,5535397.88,213834.32,729771),('1','138','257643','323',582.00,664.00,0.00,14407.20,8384990.40,8646579.22,261588.82,729772),('1','138','257644','323',582.00,594.00,0.00,0.00,0.00,0.00,0.00,729773),('1','138','257645','323',582.00,664.00,0.00,9554.64,5560800.48,5767699.46,206898.98,729774),('1','138','257646','323',582.00,664.00,0.00,9661.40,5622934.80,5805765.12,182830.32,729775),('1','138','257647','323',582.00,664.00,0.00,5583.18,3249410.76,3352956.52,103545.76,729776),('1','138','257648','323',582.00,664.00,0.00,0.00,0.00,0.00,0.00,729777),('1','138','257649','323',582.00,664.00,0.00,5273.10,3068944.20,3154761.72,85817.52,729778),('1','138','257650','323',582.00,664.00,0.00,7620.20,4434956.40,4600129.52,165173.12,729779),('1','138','257651','323',582.00,664.00,0.00,7083.05,4122335.10,4285902.60,163567.50,729780),('1','138','257652','323',582.00,664.00,0.00,4499.15,2618505.30,2706103.60,87598.30,729781),('1','138','257653','323',582.00,594.00,0.00,0.00,0.00,0.00,0.00,729782),('1','138','257654','323',582.00,664.00,0.00,5530.54,3218774.28,3333051.82,114277.54,729783),('1','138','257655','323',582.00,664.00,0.00,0.00,0.00,0.00,0.00,729784),('1','138','257656','323',582.00,664.00,0.00,4783.77,2784154.14,2873099.28,88945.14,729785),('1','138','257657','323',582.00,594.00,0.00,0.00,0.00,0.00,0.00,729786),('1','138','257658','323',582.00,664.00,0.00,467.82,272271.24,310632.48,38361.24,729787),('1','138','257659','323',582.00,664.00,0.00,951.70,553889.40,631928.80,78039.40,729788),('1','138','257660','323',582.00,664.00,0.00,1572.31,915084.42,1044013.84,128929.42,729789),('1','138','257661','323',582.00,594.00,0.00,0.00,0.00,0.00,0.00,729790),('1','138','257662','323',582.00,664.00,0.00,978.27,569353.14,649571.28,80218.14,729791),('1','138','257663','323',582.00,664.00,0.00,1163.80,677331.60,772763.20,95431.60,729792),('1','138','257664','323',582.00,664.00,0.00,1033.19,601316.58,686038.16,84721.58,729793),('1','138','257665','323',582.00,680.00,0.00,872.44,507760.08,593259.20,85499.12,729794),('1','138','257666','323',582.00,594.00,0.00,0.00,0.00,0.00,0.00,729795),('1','138','257667','323',592.00,680.00,0.00,1496.36,885845.12,1017524.80,131679.68,729796),('1','138','257668','323',592.00,680.00,0.00,987.72,584730.24,671649.60,86919.36,729797),('1','138','257669','323',592.00,594.00,0.00,0.00,0.00,0.00,0.00,729798),('1','138','257670','323',592.00,680.00,0.00,1215.96,719848.32,826852.80,107004.48,729799),('1','138','257671','323',592.00,680.00,0.00,1625.41,962242.72,1105278.80,143036.08,729800),('1','138','257672','323',592.00,594.00,0.00,0.00,0.00,0.00,0.00,729801),('1','138','257673','323',592.00,680.00,0.00,1094.01,647653.92,743926.80,96272.88,729802),('1','138','257674','323',592.00,680.00,0.00,2104.94,1246124.48,1431359.20,185234.72,729803),('1','138','257675','323',592.00,680.00,0.00,2155.82,1276245.44,1465957.60,189712.16,729804),('1','138','257676','323',592.00,594.00,0.00,0.00,0.00,0.00,0.00,729805),('1','138','257677','323',592.00,680.00,0.00,2172.99,1286410.08,1477633.20,191223.12,729806),('1','138','257678','323',592.00,680.00,0.00,2537.32,1629744.64,1742934.43,113189.79,729807),('1','138','257679','323',652.00,673.00,0.00,0.00,0.00,0.00,0.00,729808),('1','138','257680','323',652.00,720.00,0.00,3787.64,2469541.28,2603741.97,134200.69,729809),('1','138','257681','323',652.00,720.00,0.00,5919.32,3859396.64,4039108.54,179711.90,729810),('1','138','257682','323',652.00,720.00,0.00,13258.17,8644326.84,9011901.28,367574.44,729811),('1','138','257683','323',652.00,720.00,0.00,1593.58,1039014.16,1088725.60,49711.44,729812),('1','138','257684','323',652.00,720.00,0.00,0.00,0.00,0.00,0.00,729813),('1','138','257685','323',652.00,720.00,0.00,5131.48,3345724.96,3502345.96,156621.00,729814),('1','138','257686','323',652.00,720.00,0.00,0.00,0.00,0.00,0.00,729815),('1','138','257687','323',652.00,720.00,0.00,4871.84,3176439.68,3312414.50,135974.82,729816),('1','138','257688','323',652.00,673.00,0.00,0.00,0.00,0.00,0.00,729817),('1','138','257689','323',652.00,760.00,0.00,6000.20,3912130.40,4216667.80,304537.40,729818),('1','138','257690','323',652.00,760.00,0.00,0.00,0.00,0.00,0.00,729819),('1','138','257691','323',652.00,760.00,0.00,4849.01,3161554.52,3424073.60,262519.08,729820),('1','138','257692','323',652.00,760.00,0.00,0.00,0.00,0.00,0.00,729821),('1','138','257693','323',652.00,760.00,0.00,4095.58,2670318.16,2905361.80,235043.64,729822),('1','138','257694','323',652.00,760.00,0.00,0.00,0.00,0.00,0.00,729823),('1','138','257695','323',652.00,760.00,0.00,2296.98,1497630.96,1626814.80,129183.84,729824),('1','138','257696','323',652.00,760.00,0.00,1947.81,1269972.12,1387995.60,118023.48,729825),('1','138','257697','323',652.00,760.00,0.00,0.00,0.00,0.00,0.00,729826),('1','138','257698','323',652.00,760.00,0.00,4219.06,2750827.12,2996703.00,245875.88,729827),('1','138','257699','323',652.00,760.00,0.00,10716.02,6986845.04,7557819.20,570974.16,729828),('1','138','257700','323',652.00,760.00,0.00,8361.57,5451743.64,5926959.80,475216.16,729829),('1','138','257701','323',652.00,760.00,0.00,848.56,553261.12,644905.60,91644.48,729830),('1','138','257702','323',652.00,760.00,0.00,700.32,456608.64,532243.20,75634.56,729831),('1','138','257703','323',652.00,696.00,0.00,0.00,0.00,0.00,0.00,729832),('1','138','257704','323',672.00,760.00,0.00,963.62,647552.64,732351.20,84798.56,729833),('1','138','257705','323',672.00,760.00,0.00,934.96,628293.12,710569.60,82276.48,729834),('1','138','257706','323',672.00,760.00,0.00,1721.08,1156565.76,1308020.80,151455.04,729835),('1','138','257707','323',672.00,696.00,0.00,0.00,0.00,0.00,0.00,729836),('1','138','257708','323',672.00,760.00,0.00,540.05,362913.60,410438.00,47524.40,729837),('1','138','257709','323',672.00,760.00,0.00,2230.01,1498566.72,1694807.60,196240.88,729838),('1','138','257710','323',672.00,760.00,0.00,2964.46,1992117.12,2252989.60,260872.48,729839),('1','138','257711','323',672.00,696.00,0.00,0.00,0.00,0.00,0.00,729840),('1','138','257712','323',672.00,696.00,0.00,0.00,0.00,0.00,0.00,729841),('1','138','257713','323',672.00,760.00,0.00,2985.47,2006235.84,2268957.20,262721.36,729842),('1','138','257714','323',672.00,760.00,0.00,2126.36,1428913.92,1616033.60,187119.68,729843),('1','138','257715','323',672.00,696.00,0.00,0.00,0.00,0.00,0.00,729844),('1','138','257716','323',672.00,760.00,0.00,3344.14,2247262.08,2541546.40,294284.32,729845),('1','138','257717','323',672.00,760.00,0.00,1605.00,1078560.00,1219800.00,141240.00,729846),('1','138','257718','323',672.00,760.00,0.00,0.00,0.00,0.00,0.00,729847),('1','138','257719','323',672.00,760.00,0.00,1807.73,1214794.56,1373874.80,159080.24,729848),('1','138','257720','323',672.00,760.00,0.00,2472.58,1661573.76,1879160.80,217587.04,729849),('1','138','257721','323',672.00,760.00,0.00,1619.78,1088492.16,1231032.80,142540.64,729850),('1','138','257722','323',672.00,760.00,0.00,2093.15,1406596.80,1590794.00,184197.20,729851),('1','138','257723','323',672.00,760.00,0.00,1502.82,1009895.04,1142143.20,132248.16,729852),('1','138','257724','323',672.00,760.00,0.00,1616.24,1086113.28,1228342.40,142229.12,729853),('1','138','257725','323',672.00,760.00,0.00,1368.59,919692.48,1040128.40,120435.92,729854),('1','138','257726','323',672.00,760.00,0.00,1550.98,1042258.56,1178744.80,136486.24,729855),('1','138','257727','323',672.00,760.00,0.00,1085.64,729550.08,825086.40,95536.32,729856),('1','138','257728','323',596.00,760.00,0.00,8370.07,4988561.72,6058883.20,1070321.48,729857),('1','138','257729','323',596.00,760.00,0.00,1184.68,706069.28,861516.80,155447.52,729858),('1','138','257730','323',596.00,760.00,0.00,0.00,0.00,0.00,0.00,729859),('1','138','257731','323',682.00,760.00,0.00,4227.59,2883216.38,3067811.60,184595.22,729860),('1','138','257732','323',682.00,760.00,0.00,4526.84,3087304.88,3299471.20,212166.32,729861),('1','138','257733','323',682.00,760.00,0.00,4228.28,2883686.96,3076356.40,192669.44,729862),('1','138','257734','323',682.00,760.00,0.00,5457.94,3722315.08,3961666.40,239351.32,729863),('1','138','257735','323',682.00,760.00,0.00,6215.89,4239236.98,4493186.80,253949.82,729864),('1','138','257736','323',682.00,716.00,0.00,0.00,0.00,0.00,0.00,729865),('1','138','257737','323',682.00,760.00,0.00,4336.23,2957308.86,3140710.80,183401.94,729866),('1','138','257738','323',682.00,716.00,0.00,0.00,0.00,0.00,0.00,729867),('1','138','257739','323',682.00,760.00,0.00,757.93,516908.26,555506.80,38598.54,729868),('1','138','257740','323',682.00,760.00,0.00,4494.54,3065276.28,3253502.40,188226.12,729869),('1','138','257741','323',682.00,716.00,0.00,0.00,0.00,0.00,0.00,729870),('1','138','257742','323',682.00,760.00,0.00,5241.85,3574941.70,3806228.00,231286.30,729871),('1','138','257743','323',682.00,716.00,0.00,0.00,0.00,0.00,0.00,729872),('1','138','257744','323',682.00,760.00,0.00,7392.79,5041882.78,5354102.40,312219.62,729873),('1','138','257745','323',682.00,760.00,0.00,5024.81,3426920.42,3661105.60,234185.18,729874),('1','138','257746','323',682.00,760.00,0.00,6157.89,4199680.98,4464402.40,264721.42,729875),('1','138','257747','323',682.00,760.00,0.00,4163.30,2839370.60,3037348.00,197977.40,729876),('1','138','257748','323',682.00,760.00,0.00,1621.51,1105869.82,1181207.60,75337.78,729877),('1','138','257749','323',682.00,716.00,0.00,0.00,0.00,0.00,0.00,729878),('1','138','257750','323',682.00,760.00,0.00,2215.39,1510895.98,1620129.20,109233.22,729879),('1','138','257751','323',682.00,760.00,0.00,3398.42,2317722.44,2492708.00,174985.56,729880),('1','138','257752','323',682.00,760.00,0.00,2950.85,2012479.70,2154562.00,142082.30,729881),('1','138','257753','323',682.00,760.00,0.00,6166.35,4205450.70,4461883.20,256432.50,729882),('1','138','257754','323',682.00,760.00,0.00,3322.17,2265719.94,2421317.20,155597.26,729883),('1','138','257755','323',682.00,760.00,0.00,932.64,636060.48,708806.40,72745.92,729884),('1','138','257756','323',682.00,760.00,0.00,1105.29,753807.78,840020.40,86212.62,729885),('1','138','257757','323',682.00,760.00,0.00,1304.75,889839.50,991610.00,101770.50,729886),('1','138','257758','323',682.00,760.00,0.00,2432.36,1658869.52,1848593.60,189724.08,729887),('1','138','257759','323',682.00,760.00,0.00,510.28,348010.96,387812.80,39801.84,729888),('1','138','257760','323',682.00,716.00,0.00,0.00,0.00,0.00,0.00,729889),('1','138','257761','323',682.00,760.00,0.00,1401.35,955720.70,1065026.00,109305.30,729890),('1','138','257762','323',682.00,760.00,0.00,1687.84,1151106.88,1282758.40,131651.52,729891),('1','138','257763','323',682.00,760.00,0.00,2324.35,1585206.70,1687524.00,102317.30,729892),('1','138','257764','323',682.00,760.00,0.00,0.00,0.00,0.00,0.00,729893),('1','138','257765','323',682.00,760.00,0.00,1439.14,981493.48,1053466.40,71972.92,729894),('1','138','257766','323',682.00,760.00,0.00,5382.69,3670994.58,3890228.40,219233.82,729895),('1','138','257767','323',682.00,760.00,0.00,4041.26,2756139.32,2914051.20,157911.88,729896),('1','138','257768','323',682.00,760.00,0.00,2794.30,1905712.60,2033452.00,127739.40,729897),('1','138','257769','323',682.00,760.00,0.00,3105.99,2118285.18,2258792.40,140507.22,729898),('1','138','257770','323',682.00,760.00,0.00,5129.95,3816682.80,3622481.80,-194201.00,729899),('1','138','257771','323',744.00,744.00,0.00,1491.82,1109914.08,1054617.58,-55296.50,729900),('1','138','257772','323',744.00,744.00,0.00,0.00,0.00,0.00,0.00,729901),('1','138','257773','323',744.00,744.00,0.00,0.00,0.00,0.00,0.00,729902),('1','138','257774','323',665.00,744.00,0.00,3237.62,2153017.30,2272436.98,119419.68,729903),('1','138','257775','323',665.00,744.00,0.00,6431.91,4277220.15,4517022.35,239802.20,729904),('1','138','257776','323',665.00,744.00,0.00,5167.32,3436267.80,3631824.98,195557.18,729905),('1','138','257777','323',665.00,744.00,0.00,6659.93,4428853.45,4632716.55,203863.10,729906),('1','138','257778','323',665.00,744.00,0.00,3112.63,2069898.95,2190563.01,120664.06,729907),('1','138','257779','323',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729908),('1','138','257780','323',665.00,744.00,0.00,2584.31,1718566.15,1806824.94,88258.79,729909),('1','138','257781','323',665.00,744.00,0.00,7385.62,4911437.30,5193466.28,282028.98,729910),('1','138','257782','323',665.00,744.00,0.00,7006.84,4659548.60,4933635.13,274086.53,729911),('1','138','257783','323',665.00,744.00,0.00,2852.02,1896593.30,2005766.51,109173.21,729912),('1','138','257784','323',665.00,744.00,0.00,3706.50,2464822.50,2593763.38,128940.88,729913),('1','138','257785','323',665.00,744.00,0.00,8141.57,5414144.05,5729321.64,315177.59,729914),('1','138','257786','323',665.00,744.00,0.00,4432.62,2947692.30,3185855.28,238162.98,729915),('1','138','257787','323',665.00,744.00,0.00,1440.48,957919.20,1071717.12,113797.92,729916),('1','138','257788','323',665.00,744.00,0.00,3132.64,2083205.60,2242361.66,159156.06,729917),('1','138','257789','323',665.00,744.00,0.00,3346.73,2225575.45,2356195.42,130619.97,729918),('1','138','257790','323',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729919),('1','138','257791','323',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729920),('1','138','257792','323',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729921),('1','138','257793','323',665.00,744.00,0.00,1996.89,1327931.85,1392167.72,64235.87,729922),('1','138','257794','323',665.00,744.00,0.00,4963.67,3300840.55,3497758.40,196917.85,729923),('1','138','257795','323',665.00,744.00,0.00,4313.46,2868450.90,3026105.69,157654.79,729924),('1','138','257796','323',665.00,744.00,0.00,768.54,511079.10,569804.36,58725.26,729925),('1','138','257797','323',665.00,744.00,0.00,2733.14,1817538.10,1939942.60,122404.50,729926),('1','138','257798','323',665.00,744.00,0.00,2514.69,1672268.85,1877674.36,205405.51,729927),('1','138','257799','323',665.00,760.00,0.00,1336.71,888912.15,1010366.80,121454.65,729928),('1','138','257800','323',665.00,760.00,0.00,443.09,294654.85,336748.40,42093.55,729929),('1','138','257801','323',665.00,760.00,0.00,1628.51,1082959.15,1237667.60,154708.45,729930),('1','138','257802','323',665.00,760.00,0.00,340.04,226126.60,258430.40,32303.80,729931),('1','138','257803','323',665.00,760.00,0.00,2116.11,1407213.15,1608243.60,201030.45,729932),('1','138','257804','323',665.00,760.00,0.00,1432.19,952406.35,1088464.40,136058.05,729933),('1','138','257805','323',665.00,760.00,0.00,2057.88,1368490.20,1563988.80,195498.60,729934),('1','138','257806','323',665.00,760.00,0.00,456.81,303778.65,347175.60,43396.95,729935),('1','138','257807','323',665.00,760.00,0.00,1775.93,1180993.45,1349706.80,168713.35,729936),('1','138','257808','323',665.00,760.00,0.00,1838.30,1222469.50,1397108.00,174638.50,729937),('1','138','257809','323',665.00,760.00,0.00,2414.09,1605369.85,1739812.18,134442.33,729938),('1','138','257810','323',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729939),('1','138','257811','323',665.00,744.00,0.00,1823.14,1212388.10,1306883.12,94495.02,729940),('1','138','257812','323',665.00,744.00,0.00,4899.01,3257841.65,3518853.32,261011.67,729941),('1','138','257813','323',665.00,744.00,0.00,6945.98,4619076.70,4976916.26,357839.56,729942),('1','138','257814','323',665.00,744.00,0.00,4745.33,3155644.45,3414441.02,258796.57,729943),('1','138','257815','323',665.00,744.00,0.00,6497.82,4321050.30,4637972.36,316922.06,729944),('1','138','257816','323',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729945),('1','138','257817','323',665.00,744.00,0.00,5295.34,3521401.10,3797068.28,275667.18,729946),('1','138','257818','323',665.00,744.00,0.00,498.16,331276.40,354754.06,23477.66,729947),('1','138','257819','323',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729948),('1','138','257820','323',665.00,744.00,0.00,5126.76,3409295.40,3672260.58,262965.18,729949),('1','138','257821','323',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729950),('1','138','257822','323',665.00,744.00,0.00,2969.08,1974438.20,2156346.52,181908.32,729951),('1','138','257823','323',665.00,744.00,0.00,1712.60,1138879.00,1274174.40,135295.40,729952),('1','138','257824','323',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729953),('1','138','257825','323',665.00,744.00,0.00,1953.74,1299237.10,1421273.72,122036.62,729954),('1','138','257826','323',665.00,744.00,0.00,5070.44,3371842.60,3647900.04,276057.44,729955),('1','138','257827','323',665.00,744.00,0.00,4139.37,2752681.05,2973500.28,220819.23,729956),('1','138','257828','323',665.00,744.00,0.00,4756.19,3162866.35,3422166.92,259300.57,729957),('1','138','257829','323',665.00,744.00,0.00,4734.68,3148562.20,3403452.92,254890.72,729958),('1','138','257830','323',665.00,744.00,0.00,3885.55,2583890.75,2798444.34,214553.59,729959),('1','138','257831','323',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729960),('1','138','257832','323',665.00,744.00,0.00,3555.47,2364387.55,2565460.46,201072.91,729961),('1','138','257833','323',665.00,744.00,0.00,1502.40,999096.00,1082324.62,83228.62,729962),('1','138','257834','323',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729963),('1','138','257835','323',665.00,744.00,0.00,2005.06,1333364.90,1458665.64,125300.74,729964),('1','138','257836','323',665.00,744.00,0.00,3344.94,2224385.10,2406351.62,181966.52,729965),('1','138','257837','323',665.00,744.00,0.00,61.44,40857.60,43622.40,2764.80,729966),('1','138','257838','323',665.00,744.00,0.00,617.68,410757.20,442383.92,31626.72,729967),('1','138','257839','323',665.00,744.00,0.00,4220.16,2806406.40,3047663.12,241256.72,729968),('1','138','257840','323',665.00,744.00,0.00,7013.93,4664263.45,4965030.20,300766.75,729969),('1','138','257841','323',665.00,744.00,0.00,6355.04,4226101.60,4491227.92,265126.32,729970),('1','138','257842','323',665.00,744.00,0.00,5401.79,3592190.35,3843849.60,251659.25,729971),('1','138','257843','323',665.00,744.00,0.00,764.58,508445.70,568847.52,60401.82,729972),('1','138','257844','323',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729973),('1','138','257845','323',665.00,744.00,0.00,1481.30,985064.50,1102087.20,117022.70,729974),('1','138','257846','323',665.00,744.00,0.00,1145.00,761425.00,851880.00,90455.00,729975),('1','138','257847','323',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729976),('1','138','257848','323',665.00,744.00,0.00,1284.57,854239.05,955720.08,101481.03,729977),('1','138','257849','323',665.00,744.00,0.00,1917.56,1275177.40,1426664.64,151487.24,729978),('1','138','257850','323',665.00,744.00,0.00,1390.45,924649.25,1034494.80,109845.55,729979),('1','138','257851','323',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729980),('1','138','257852','323',665.00,744.00,0.00,1291.13,858601.45,960600.72,101999.27,729981),('1','138','257853','323',665.00,744.00,0.00,1664.21,1106699.65,1238172.24,131472.59,729982),('1','138','257854','323',665.00,744.00,0.00,1163.51,773734.15,865651.44,91917.29,729983),('1','138','257855','323',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729984),('1','138','257856','323',665.00,744.00,0.00,265.64,176650.60,197636.16,20985.56,729985),('1','138','257857','323',665.00,744.00,0.00,1779.76,1183540.40,1324141.44,140601.04,729986),('1','138','257858','323',665.00,744.00,0.00,905.70,602290.50,673840.80,71550.30,729987),('1','138','257859','323',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729988),('1','138','257860','323',665.00,744.00,0.00,1575.74,1047867.10,1172350.56,124483.46,729989),('1','138','257861','323',665.00,744.00,0.00,1244.97,827905.05,926257.68,98352.63,729990),('1','138','257862','323',665.00,744.00,0.00,1958.23,1302222.95,1456923.12,154700.17,729991),('1','138','257863','323',665.00,744.00,0.00,213.68,142097.20,158977.92,16880.72,729992),('1','138','257864','323',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729993),('1','138','257865','323',665.00,744.00,0.00,639.64,425360.60,475892.16,50531.56,729994),('1','138','257866','323',665.00,744.00,0.00,2155.10,1433141.50,1603394.40,170252.90,729995),('1','138','257867','323',665.00,744.00,0.00,1529.17,1014664.90,1134129.44,119464.54,729996),('1','138','257868','323',660.00,736.00,0.00,681.05,449493.00,501252.80,51759.80,729997),('1','138','257869','323',660.00,736.00,0.00,0.00,0.00,0.00,0.00,729998),('1','138','257870','323',660.00,736.00,0.00,3185.03,2102119.80,2284682.72,182562.92,729999),('1','138','257871','323',660.00,736.00,0.00,4552.18,3004438.80,3232407.32,227968.52,730000),('1','138','257872','323',660.00,736.00,0.00,4598.55,3035043.00,3260033.68,224990.68,730001),('1','138','257873','323',660.00,736.00,0.00,6651.73,4390141.80,4698660.08,308518.28,730002),('1','138','257874','323',660.00,736.00,0.00,4995.04,3296726.40,3546452.08,249725.68,730003),('1','138','257875','323',660.00,736.00,0.00,593.26,391551.60,422347.36,30795.76,730004),('1','138','257876','323',660.00,736.00,0.00,0.00,0.00,0.00,0.00,730005),('1','138','257877','323',660.00,736.00,0.00,2606.04,1719986.40,1860287.36,140300.96,730006),('1','138','257878','323',660.00,736.00,0.00,2189.26,1444911.60,1611295.36,166383.76,730007),('1','138','257879','323',660.00,736.00,0.00,629.99,415793.40,463672.64,47879.24,730008),('1','138','257880','323',660.00,736.00,0.00,0.00,0.00,0.00,0.00,730009),('1','138','257881','323',660.00,736.00,0.00,330.19,217925.40,243019.84,25094.44,730010),('1','138','257882','323',660.00,736.00,0.00,1337.17,882532.20,984157.12,101624.92,730011),('1','138','257883','323',660.00,736.00,0.00,2531.24,1670618.40,1862992.64,192374.24,730012),('1','138','257884','323',660.00,736.00,0.00,0.00,0.00,0.00,0.00,730013),('1','138','257885','323',665.00,764.00,0.00,3194.93,2124628.45,2440926.52,316298.07,730014),('1','138','257886','323',665.00,748.00,0.00,1406.51,935329.15,1052069.48,116740.33,730015),('1','138','257887','323',665.00,748.00,0.00,0.00,0.00,0.00,0.00,730016),('1','138','257888','323',665.00,748.00,0.00,891.38,592767.70,666752.24,73984.54,730017),('1','138','257889','323',665.00,748.00,0.00,4339.08,2885488.20,3245631.84,360143.64,730018),('1','138','257890','323',665.00,748.00,0.00,307.84,204713.60,230264.32,25550.72,730019),('1','138','257891','323',665.00,748.00,0.00,41.70,27730.50,31191.60,3461.10,730020),('1','138','257892','323',665.00,748.00,0.00,3377.45,2246004.25,2526332.60,280328.35,730021),('1','138','257893','323',665.00,748.00,0.00,1520.09,1010859.85,1137027.32,126167.47,730022),('1','138','257894','323',665.00,748.00,0.00,0.00,0.00,0.00,0.00,730023),('1','138','257895','323',665.00,748.00,0.00,833.40,554211.00,623383.20,69172.20,730024),('1','138','257896','323',665.00,748.00,0.00,1492.78,992698.70,1116599.44,123900.74,730025),('1','138','257897','323',665.00,748.00,0.00,1414.98,940961.70,1058405.04,117443.34,730026),('1','138','257898','323',660.00,760.00,0.00,1445.84,954254.40,1098838.40,144584.00,730027),('1','138','257899','323',660.00,760.00,0.00,1458.52,962623.20,1108475.20,145852.00,730028),('1','138','257900','323',660.00,760.00,0.00,2695.32,1778911.20,2048443.20,269532.00,730029),('1','138','257901','323',660.00,760.00,0.00,1311.68,865708.80,996876.80,131168.00,730030),('1','138','257902','323',660.00,760.00,0.00,819.74,541028.40,623002.40,81974.00,730031),('1','138','257903','323',660.00,760.00,0.00,1795.62,1185109.20,1364671.20,179562.00,730032),('1','138','257904','323',660.00,760.00,0.00,1746.52,1152703.20,1327355.20,174652.00,730033),('1','138','257905','323',660.00,760.00,0.00,1094.64,722462.40,831926.40,109464.00,730034),('1','138','257906','323',660.00,760.00,0.00,595.03,392719.80,452222.80,59503.00,730035),('1','138','257907','323',660.00,800.00,0.00,1358.16,896385.60,1086528.00,190142.40,730036),('1','138','257908','323',660.00,800.00,0.00,1317.60,869616.00,1054080.00,184464.00,730037),('1','138','257909','323',660.00,800.00,0.00,1221.02,805873.20,976816.00,170942.80,730038),('1','138','257910','323',660.00,760.00,0.00,814.55,537603.00,619058.00,81455.00,730039),('1','138','257911','323',660.00,760.00,0.00,0.00,0.00,0.00,0.00,730040),('1','138','257912','323',660.00,760.00,0.00,682.71,450588.60,518859.60,68271.00,730041),('1','138','257913','323',660.00,760.00,0.00,1319.24,870698.40,1002622.40,131924.00,730042),('1','138','257914','323',660.00,760.00,0.00,1640.88,1082980.80,1247068.80,164088.00,730043),('1','138','257915','323',660.00,760.00,0.00,1555.84,1026854.40,1182438.40,155584.00,730044),('1','138','257916','323',660.00,760.00,0.00,0.00,0.00,0.00,0.00,730045),('1','138','257917','323',660.00,760.00,0.00,1380.28,910984.80,1049012.80,138028.00,730046),('1','138','257918','323',660.00,760.00,0.00,1026.39,677417.40,780056.40,102639.00,730047),('1','138','257919','323',660.00,760.00,0.00,1363.90,900174.00,1036564.00,136390.00,730048),('1','138','257920','323',660.00,760.00,0.00,0.00,0.00,0.00,0.00,730049),('1','138','257921','323',660.00,760.00,0.00,1307.98,863266.80,994064.80,130798.00,730050),('1','138','257922','323',660.00,760.00,0.00,1072.15,711240.25,814834.00,103593.75,730051),('1','138','257923','323',685.00,760.00,0.00,1246.92,854140.20,947659.20,93519.00,730052),('1','138','257924','323',685.00,760.00,0.00,1217.52,834001.20,925315.20,91314.00,730053),('1','138','257925','323',685.00,760.00,0.00,220.59,151000.95,167648.40,16647.45,730054),('1','138','257926','323',685.00,760.00,0.00,505.06,345966.10,383845.60,37879.50,730055),('1','138','257927','323',685.00,760.00,0.00,1801.85,1234267.25,1369406.00,135138.75,730056),('1','138','257928','323',685.00,760.00,0.00,2341.59,1603989.15,1779608.40,175619.25,730057),('1','138','257929','323',685.00,760.00,0.00,4075.24,2791539.40,2961458.40,169919.00,730058),('1','138','257930','323',685.00,760.00,0.00,3422.39,2344337.15,2477296.25,132959.10,730059),('1','138','257931','323',685.00,760.00,0.00,41.66,28537.10,31346.60,2809.50,730060),('1','138','257932','323',685.00,760.00,0.00,2940.52,2014256.20,2137347.70,123091.50,730061),('1','138','257933','323',685.00,760.00,0.00,2428.45,1663488.25,1788157.00,124668.75,730062),('1','138','257934','323',685.00,760.00,0.00,2729.50,1869707.50,2016685.00,146977.50,730063),('1','138','257935','323',685.00,760.00,0.00,1338.26,916708.10,983620.10,66912.00,730064),('1','138','257936','323',685.00,760.00,0.00,1875.19,1284505.15,1379285.80,94780.65,730065),('1','138','257937','323',685.00,760.00,0.00,811.87,556130.95,592718.99,36588.04,730066),('1','138','257938','323',675.00,760.00,0.00,2155.76,1455138.00,1560605.66,105467.66,730067),('1','138','257939','323',675.00,760.00,0.00,2051.20,1384560.00,1508737.00,124177.00,730068),('1','138','257940','323',675.00,760.00,0.00,2682.71,1810829.25,1959124.10,148294.85,730069),('1','138','257941','323',675.00,760.00,0.00,3387.29,2286420.75,2463322.90,176902.15,730070),('1','138','257942','323',675.00,760.00,0.00,3786.40,2555820.00,2725402.50,169582.50,730071),('1','138','257943','323',675.00,760.00,0.00,5106.35,3446786.25,3659245.70,212459.45,730072),('1','138','257944','323',675.00,760.00,0.00,3182.20,2147985.00,2295921.50,147936.50,730073),('1','138','257945','323',660.00,760.00,0.00,1921.93,1268473.80,1366981.00,98507.20,730074),('1','138','257946','323',660.00,760.00,0.00,0.00,0.00,0.00,0.00,730075),('1','138','257947','323',675.00,760.00,0.00,3822.33,2580072.75,2690696.80,110624.05,730076),('1','138','257948','323',675.00,760.00,0.00,4546.28,3068739.00,3233041.80,164302.80,730077),('1','138','257949','323',675.00,760.00,0.00,5688.83,3839960.25,4033424.80,193464.55,730078),('1','138','257950','323',675.00,760.00,0.00,4775.08,3223179.00,3381674.80,158495.80,730079),('1','138','257951','323',675.00,760.00,0.00,4142.47,2796167.25,2949268.00,153100.75,730080),('1','138','257952','323',675.00,760.00,0.00,1732.74,1169599.50,1223551.20,53951.70,730081),('1','138','257953','323',675.00,760.00,0.00,0.00,0.00,0.00,0.00,730082),('1','138','257954','323',675.00,760.00,0.00,3300.81,2228046.75,2338681.40,110634.65,730083),('1','138','257955','323',675.00,760.00,0.00,5595.79,3777158.25,3963931.40,186773.15,730084),('1','138','257956','323',675.00,760.00,0.00,5668.97,3826554.75,4012063.80,185509.05,730085),('1','138','257957','323',675.00,760.00,0.00,4965.08,3351429.00,3538158.40,186729.40,730086),('1','138','257958','323',675.00,760.00,0.00,3785.52,2555226.00,2706095.64,150869.64,730087),('1','138','257959','323',675.00,736.00,0.00,1188.77,802419.75,853802.00,51382.25,730088),('1','138','257960','323',675.00,736.00,0.00,0.00,0.00,0.00,0.00,730089),('1','138','257961','323',675.00,736.00,0.00,2974.38,2007706.50,2105235.80,97529.30,730090),('1','138','257962','323',675.00,736.00,0.00,1945.05,1312908.75,1382748.00,69839.25,730091),('1','138','257963','323',675.00,736.00,0.00,0.00,0.00,0.00,0.00,730092),('1','138','257964','323',675.00,736.00,0.00,2589.52,1747926.00,1827350.20,79424.20,730093),('1','138','257965','323',675.00,736.00,0.00,2564.34,1700753.34,1819602.24,118848.90,730094),('1','138','257966','323',654.00,736.00,0.00,5218.18,3412689.72,3686975.68,274285.96,730095),('1','138','257967','323',654.00,736.00,0.00,5018.38,3282020.52,3533256.20,251235.68,730096),('1','138','257968','323',654.00,736.00,0.00,6606.91,4320919.14,4650015.76,329096.62,730097),('1','138','257969','323',654.00,736.00,0.00,1979.29,1294455.66,1397887.36,103431.70,730098),('1','138','257970','323',654.00,736.00,0.00,0.00,0.00,0.00,0.00,730099),('1','138','257971','323',654.00,736.00,0.00,1611.23,1053744.42,1135393.28,81648.86,730100),('1','138','257972','323',654.00,736.00,0.00,4069.20,2661256.80,2877068.12,215811.32,730101),('1','138','257973','323',654.00,736.00,0.00,2497.86,1633600.44,1751942.96,118342.52,730102),('1','138','257974','323',654.00,736.00,0.00,3331.47,2178781.38,2360203.32,181421.94,730103),('1','138','257975','323',654.00,736.00,0.00,0.00,0.00,0.00,0.00,730104),('1','138','257976','323',654.00,736.00,0.00,6623.96,4332069.84,4661657.76,329587.92,730105),('1','138','257977','323',654.00,736.00,0.00,0.00,0.00,0.00,0.00,730106),('1','138','257978','323',654.00,736.00,0.00,5370.00,3511980.00,3784762.52,272782.52,730107),('1','138','257979','323',654.00,736.00,0.00,76.50,50031.00,53550.00,3519.00,730108),('1','138','257980','323',654.00,736.00,0.00,3224.37,2108737.98,2269989.20,161251.22,730109),('1','138','257981','323',654.00,736.00,0.00,8613.69,5633353.26,6059611.84,426258.58,730110),('1','138','257982','323',654.00,736.00,0.00,9316.27,6092840.58,6559121.04,466280.46,730111),('1','138','257983','323',654.00,736.00,0.00,2245.94,1468844.76,1587257.48,118412.72,730112),('1','138','257984','323',654.00,736.00,0.00,0.00,0.00,0.00,0.00,730113),('1','138','257985','323',654.00,736.00,0.00,2532.89,1656510.06,1810765.04,154254.98,730114),('1','138','257986','323',654.00,736.00,0.00,8604.34,5627238.36,6070843.60,443605.24,730115),('1','138','257987','323',654.00,736.00,0.00,8256.66,5399855.64,5799409.76,399554.12,730116),('1','138','257988','323',654.00,736.00,0.00,5142.03,3362887.62,3612252.84,249365.22,730117),('1','138','257989','323',654.00,736.00,0.00,0.00,0.00,0.00,0.00,730118),('1','138','257990','323',654.00,736.00,0.00,1056.52,690964.08,743498.80,52534.72,730119),('1','138','257991','323',654.00,736.00,0.00,6982.89,4566810.06,4913457.04,346646.98,730120),('1','138','257992','323',654.00,736.00,0.00,3768.34,2464494.36,2672734.60,208240.24,730121),('1','138','257993','323',654.00,736.00,0.00,7789.70,5094463.80,5483239.04,388775.24,730122),('1','138','257994','323',654.00,736.00,0.00,4375.99,2861897.46,3085620.64,223723.18,730123),('1','138','257995','323',654.00,736.00,0.00,820.56,536646.24,575935.32,39289.08,730124),('1','138','257996','323',654.00,736.00,0.00,0.00,0.00,0.00,0.00,730125),('1','138','257997','323',654.00,736.00,0.00,5114.42,3344830.68,3591090.48,246259.80,730126),('1','138','257998','323',654.00,736.00,0.00,0.00,0.00,0.00,0.00,730127),('1','138','257999','323',654.00,736.00,0.00,5242.99,3428915.46,3697370.20,268454.74,730128),('1','138','258000','323',654.00,736.00,0.00,5726.11,3744875.94,4031932.96,287057.02,730129),('1','138','258001','323',654.00,736.00,0.00,6232.94,4076342.76,4392017.72,315674.96,730130),('1','138','258002','323',654.00,736.00,0.00,1652.44,1080695.76,1164251.08,83555.32,730131),('1','138','258003','323',654.00,736.00,0.00,0.00,0.00,0.00,0.00,730132),('1','138','258004','323',654.00,736.00,0.00,1930.85,1262775.90,1371775.52,108999.62,730133),('1','138','258005','323',654.00,736.00,0.00,0.00,0.00,0.00,0.00,730134),('1','138','258006','323',654.00,736.00,0.00,6607.76,4321475.04,4653501.08,332026.04,730135),('1','138','258007','323',654.00,736.00,0.00,4932.26,3225698.04,3445856.32,220158.28,730136),('1','138','258008','323',654.00,736.00,0.00,7257.08,4746130.32,5046403.92,300273.60,730137),('1','138','258009','323',654.00,736.00,0.00,3435.03,2246509.62,2393940.30,147430.68,730138),('1','138','258010','323',654.00,736.00,0.00,0.00,0.00,0.00,0.00,730139),('1','138','258011','323',654.00,736.00,0.00,2048.87,1339960.98,1415914.18,75953.20,730140),('1','138','258012','323',654.00,736.00,0.00,8366.51,5471697.54,5812557.16,340859.62,730141),('1','138','258013','323',654.00,736.00,0.00,7807.19,5105902.26,5430578.28,324676.02,730142),('1','138','258014','323',654.00,736.00,0.00,6197.53,4053184.62,4315146.56,261961.94,730143),('1','138','258015','323',654.00,736.00,0.00,490.00,320460.00,338711.34,18251.34,730144),('1','138','258016','323',654.00,736.00,0.00,0.00,0.00,0.00,0.00,730145),('1','138','258017','323',654.00,736.00,0.00,4567.82,2987354.28,3180043.20,192688.92,730146),('1','138','258018','323',654.00,736.00,0.00,4376.02,2861917.08,3057338.48,195421.40,730147),('1','138','258019','323',654.00,736.00,0.00,2783.81,1820611.74,1963799.34,143187.60,730148),('1','138','258020','323',654.00,736.00,0.00,7516.57,4915836.78,5227896.16,312059.38,730149),('1','138','258021','323',654.00,736.00,0.00,5168.00,3379872.00,3598857.28,218985.28,730150),('1','138','258022','323',654.00,736.00,0.00,720.04,470906.16,502727.56,31821.40,730151),('1','138','258023','323',654.00,736.00,0.00,5340.45,3492654.30,3731016.76,238362.46,730152),('1','138','258024','323',654.00,736.00,0.00,5706.96,3732351.84,3992018.80,259666.96,730153),('1','138','258025','323',654.00,736.00,0.00,6509.73,4257363.42,4526212.10,268848.68,730154),('1','138','258026','323',654.00,736.00,0.00,4261.17,2786805.18,2990263.36,203458.18,730155),('1','138','258027','323',654.00,736.00,0.00,2664.50,1742583.00,1847175.20,104592.20,730156),('1','138','258028','323',654.00,736.00,0.00,0.00,0.00,0.00,0.00,730157),('1','138','258029','323',630.00,736.00,0.00,4074.70,2567061.00,2831099.00,264038.00,730158),('1','138','258030','323',630.00,736.00,0.00,250.55,157846.50,177320.80,19474.30,730159),('1','138','258031','323',630.00,736.00,0.00,4541.94,2861422.20,3167072.74,305650.54,730160),('1','138','258032','323',630.00,736.00,0.00,4665.45,2939233.50,3255079.60,315846.10,730161),('1','138','258033','323',630.00,736.00,0.00,7332.08,4619210.40,5043604.96,424394.56,730162),('1','138','258034','323',630.00,736.00,0.00,8005.92,5043729.60,5494693.68,450964.08,730163),('1','138','258035','323',630.00,736.00,0.00,386.84,243709.20,273514.24,29805.04,730164),('1','138','258036','323',630.00,736.00,0.00,0.00,0.00,0.00,0.00,730165),('1','138','258037','323',630.00,736.00,0.00,5226.51,3292701.30,3589243.36,296542.06,730166),('1','138','258038','323',630.00,736.00,0.00,5806.38,3658019.40,3996528.08,338508.68,730167),('1','138','258039','323',630.00,736.00,0.00,6851.78,4316621.40,4717830.00,401208.60,730168),('1','138','258040','323',630.00,736.00,0.00,5217.88,3287264.40,3603812.88,316548.48,730169),('1','138','258041','323',630.00,736.00,0.00,1554.75,979492.50,1066932.00,87439.50,730170),('1','138','258042','323',630.00,736.00,0.00,0.00,0.00,0.00,0.00,730171),('1','138','258043','323',630.00,736.00,0.00,3313.25,2087347.50,2293322.16,205974.66,730172),('1','138','258044','323',630.00,736.00,0.00,6465.27,4073120.10,4454890.72,381770.62,730173),('1','138','258045','323',630.00,736.00,0.00,8050.60,5071878.00,5508558.16,436680.16,730174),('1','138','258046','323',630.00,736.00,0.00,7429.71,4680717.30,5105997.92,425280.62,730175),('1','138','258047','323',630.00,736.00,0.00,6187.24,3897961.20,4264320.24,366359.04,730176),('1','138','258048','323',630.00,736.00,0.00,7126.34,4489594.20,4891144.56,401550.36,730177),('1','138','258049','323',630.00,736.00,0.00,4689.67,2954492.10,3259957.28,305465.18,730178),('1','138','258050','323',630.00,736.00,0.00,4406.02,2775792.60,3057174.48,281381.88,730179),('1','138','258051','323',630.00,736.00,0.00,2243.59,1413461.70,1534642.08,121180.38,730180),('1','138','258052','323',630.00,736.00,0.00,0.00,0.00,0.00,0.00,730181),('1','138','258053','323',630.00,736.00,0.00,2209.71,1392117.30,1529659.76,137542.46,730182),('1','138','258054','323',630.00,736.00,0.00,5005.01,3153156.30,3454013.76,300857.46,730183),('1','138','258055','323',630.00,736.00,0.00,5105.36,3216376.80,3516849.33,300472.53,730184),('1','138','258056','323',630.00,736.00,0.00,4633.38,2919029.40,3186872.91,267843.51,730185),('1','138','258057','323',630.00,736.00,0.00,6442.61,4058844.30,4409838.12,350993.82,730186),('1','138','258058','323',630.00,736.00,0.00,1742.77,1097945.10,1203474.49,105529.39,730187),('1','138','258059','323',630.00,736.00,0.00,1351.19,851249.70,934137.08,82887.38,730188),('1','138','258060','323',630.00,736.00,0.00,5831.55,3673876.50,3997033.95,323157.45,730189),('1','138','258061','323',630.00,736.00,0.00,7366.22,4640718.60,5041442.65,400724.05,730190),('1','138','258062','323',630.00,736.00,0.00,5861.89,3692990.70,4016758.27,323767.57,730191),('1','138','258063','323',630.00,736.00,0.00,4400.32,2772201.60,3035486.76,263285.16,730192),('1','138','258064','323',630.00,736.00,0.00,0.00,0.00,0.00,0.00,730193),('1','138','258065','323',630.00,736.00,0.00,5302.96,3340864.80,3647542.34,306677.54,730194),('1','138','258066','323',630.00,736.00,0.00,5080.41,3200658.30,3508321.24,307662.94,730195),('1','138','258067','323',630.00,736.00,0.00,4835.98,3046667.40,3341006.35,294338.95,730196),('1','138','258068','323',630.00,736.00,0.00,4055.98,2555267.40,2807738.44,252471.04,730197),('1','138','258069','323',630.00,736.00,0.00,5531.39,3484775.70,3779629.18,294853.48,730198),('1','138','258070','323',630.00,736.00,0.00,0.00,0.00,0.00,0.00,730199),('1','138','258071','323',630.00,736.00,0.00,1992.50,1255275.00,1381141.00,125866.00,730200),('1','138','258072','323',630.00,736.00,0.00,4331.53,2728863.90,3011731.94,282868.04,730201),('1','138','258073','323',630.00,736.00,0.00,8552.34,5387974.20,5887908.74,499934.54,730202),('1','138','258074','323',630.00,736.00,0.00,4691.55,2955676.50,3265469.39,309792.89,730203),('1','138','258075','323',630.00,736.00,0.00,5270.14,3320188.20,3607043.37,286855.17,730204),('1','138','258076','323',630.00,736.00,0.00,0.00,0.00,0.00,0.00,730205),('1','138','258077','323',630.00,736.00,0.00,1650.54,1039840.20,1124303.94,84463.74,730206),('1','138','258078','323',630.00,736.00,0.00,4794.17,3020327.10,3304872.28,284545.18,730207),('1','138','258079','323',630.00,736.00,0.00,6255.49,3940958.70,4291093.98,350135.28,730208),('1','138','258080','323',630.00,736.00,0.00,3503.81,2207400.30,2414616.56,207216.26,730209),('1','138','258081','323',630.00,736.00,0.00,4685.41,2951808.30,3228120.61,276312.31,730210),('1','138','258082','323',630.00,736.00,0.00,3748.24,2361391.20,2589668.15,228276.95,730211),('1','138','258083','323',630.00,736.00,0.00,0.00,0.00,0.00,0.00,730212),('1','138','258084','323',630.00,736.00,0.00,4446.05,2801011.50,3069409.24,268397.74,730213),('1','138','258085','323',630.00,736.00,0.00,6515.85,4104985.50,4474231.59,369246.09,730214),('1','138','258086','323',630.00,736.00,0.00,7771.10,4895793.00,5292493.10,396700.10,730215),('1','138','258087','323',630.00,736.00,0.00,5889.25,3710227.50,4044270.13,334042.63,730216),('1','138','258088','323',630.00,736.00,0.00,0.00,0.00,0.00,0.00,730217),('1','138','258089','323',630.00,736.00,0.00,7499.03,4687893.72,4971684.24,283790.52,730218),('1','138','258090','323',624.00,700.00,0.00,7719.35,4816874.40,5134784.48,317910.08,730219),('1','138','258091','323',624.00,700.00,0.00,6669.42,4161718.08,4430396.42,268678.34,730220),('1','138','258092','323',624.00,700.00,0.00,2397.44,1496002.56,1597329.86,101327.30,730221),('1','138','258093','323',624.00,700.00,0.00,0.00,0.00,0.00,0.00,730222),('1','138','258094','323',624.00,700.00,0.00,4347.44,2712802.56,2869177.18,156374.62,730223),('1','138','258095','323',624.00,700.00,0.00,8110.74,5061101.76,5413737.00,352635.24,730224),('1','138','258096','323',624.00,700.00,0.00,5657.45,3530248.80,3751621.46,221372.66,730225),('1','138','258097','323',624.00,700.00,0.00,6154.75,3840564.00,4102845.50,262281.50,730226),('1','138','258098','323',624.00,700.00,0.00,0.00,0.00,0.00,0.00,730227),('1','138','258099','323',624.00,700.00,0.00,5531.48,3451643.52,3670970.00,219326.48,730228),('1','138','258100','323',624.00,700.00,0.00,9598.64,5989551.36,6353780.40,364229.04,730229),('1','138','258101','323',624.00,700.00,0.00,4597.43,2868796.32,3071915.00,203118.68,730230),('1','138','258102','323',624.00,700.00,0.00,2728.00,1702272.00,1810837.00,108565.00,730231),('1','138','258103','323',624.00,700.00,0.00,2497.60,1558502.40,1643193.50,84691.10,730232),('1','138','258104','323',624.00,700.00,0.00,6819.20,4255180.80,4480595.00,225414.20,730233),('1','138','258105','323',624.00,700.00,0.00,4709.75,2938884.00,3110826.50,171942.50,730234);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=301 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',300,'138','PRODUCT TANK','TANKS CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=766 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','138','300',765,1,'323','LPG TANK',27000.00,1.00,1030.28,'TANK CONTAINING LPG','479','2020-08-10 18:25:17','2021-04-28 13:57:50','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','138',765,13522.38,'2023-03-20 18:46:43');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2695684 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2107801,'1','138','765',323,'Retail Sale Id 1253924',3852.80,0.00,0.00,0.00,288.96,'2021-12-01 05:52:34','',''),(2107802,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 05:52:34','',''),(2107807,'1','138','765',323,'Retail Sale Id 1253927',3200.00,0.00,0.00,0.00,240.00,'2021-12-01 05:53:58','',''),(2107808,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 05:53:58','',''),(2107831,'1','138','765',323,'Retail Sale Id 1253941',3200.00,0.00,0.00,0.00,240.00,'2021-12-01 05:57:14','',''),(2107832,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 05:57:14','',''),(2107847,'1','138','765',323,'Retail Sale Id 1253948',19200.00,0.00,0.00,0.00,1440.00,'2021-12-01 05:58:37','',''),(2107848,'1','138','765',323,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-01 05:58:37','',''),(2107898,'1','138','765',323,'Retail Sale Id 1253970',1952.00,0.00,0.00,0.00,146.40,'2021-12-01 06:04:27','',''),(2107899,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 06:04:27','',''),(2107934,'1','138','765',323,'Retail Sale Id 1253987',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 06:07:24','',''),(2107935,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:07:24','',''),(2107972,'1','138','765',323,'Retail Sale Id 1254007',151500.00,0.00,0.00,0.00,3500.00,'2021-12-01 06:11:06','',''),(2107973,'1','138','765',323,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-01 06:11:06','',''),(2108201,'1','138','765',323,'Retail Sale Id 1254121',6400.00,0.00,0.00,0.00,480.00,'2021-12-01 06:31:37','',''),(2108202,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 06:31:37','',''),(2108213,'1','138','765',323,'Retail Sale Id 1254128',1497.60,0.00,0.00,0.00,112.32,'2021-12-01 06:32:32','',''),(2108214,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 06:32:32','',''),(2108243,'1','138','765',323,'Retail Sale Id 1254147',1920.00,0.00,0.00,0.00,144.00,'2021-12-01 06:35:03','',''),(2108244,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 06:35:03','',''),(2108391,'1','138','765',323,'Retail Sale Id 1254214',30300.00,0.00,0.00,0.00,700.00,'2021-12-01 06:45:19','',''),(2108392,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 06:45:19','',''),(2108526,'1','138','765',323,'Retail Sale Id 1254273',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 06:53:19','',''),(2108527,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:53:19','',''),(2108615,'1','138','765',323,'Retail Sale Id 1254317',88779.00,0.00,0.00,0.00,2051.00,'2021-12-01 06:57:10','',''),(2108616,'1','138','765',323,'Retail sales',0.00,0.00,0.00,146.50,0.00,'2021-12-01 06:57:10','',''),(2108703,'1','138','765',323,'Retail Sale Id 1254358',1497.60,0.00,0.00,0.00,112.32,'2021-12-01 07:01:08','',''),(2108704,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 07:01:08','',''),(2108856,'1','138','765',323,'Retail Sale Id 1254427',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 07:09:09','',''),(2108857,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:09:09','',''),(2109083,'1','138','765',323,'Retail Sale Id 1254526',2003.20,0.00,0.00,0.00,0.00,'2021-12-01 07:19:37','',''),(2109084,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 07:19:37','',''),(2109408,'1','138','765',323,'Retail Sale Id 1254668',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 07:35:34','',''),(2109409,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:35:34','',''),(2110054,'1','138','765',323,'Retail Sale Id 1254970',10880.00,0.00,0.00,0.00,0.00,'2021-12-01 08:04:41','',''),(2110055,'1','138','765',323,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-01 08:04:41','',''),(2110112,'1','138','765',323,'Retail Sale Id 1254992',5100.80,0.00,0.00,0.00,0.00,'2021-12-01 08:07:52','',''),(2110113,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.97,0.00,'2021-12-01 08:07:52','',''),(2110196,'1','138','765',323,'Retail Sale Id 1255033',30000.00,0.00,0.00,0.00,-2000.00,'2021-12-01 08:13:18','',''),(2110197,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 08:13:18','',''),(2110260,'1','138','765',323,'Retail Sale Id 1255065',69600.00,0.00,0.00,0.00,-4640.00,'2021-12-01 08:17:06','',''),(2110261,'1','138','765',323,'Retail sales',0.00,0.00,0.00,116.00,0.00,'2021-12-01 08:17:06','',''),(2110431,'1','138','765',323,'Retail Sale Id 1255153',1200.00,0.00,0.00,0.00,-80.00,'2021-12-01 08:27:11','',''),(2110432,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 08:27:11','',''),(2110506,'1','138','765',323,'Return of Retail Sale Id 1254317',0.00,88779.00,146.50,0.00,-2051.00,'2021-12-01 08:31:52','',''),(2110521,'1','138','765',323,'Retail Sale Id 1255199',9600.00,0.00,0.00,0.00,-640.00,'2021-12-01 08:32:37','',''),(2110522,'1','138','765',323,'Retail sales',0.00,0.00,0.00,16.00,0.00,'2021-12-01 08:32:37','',''),(2110566,'1','138','765',323,'Retail Sale Id 1255217',87900.00,0.00,0.00,0.00,-5860.00,'2021-12-01 08:34:39','',''),(2110567,'1','138','765',323,'Retail sales',0.00,0.00,0.00,146.50,0.00,'2021-12-01 08:34:39','',''),(2110580,'1','138','765',323,'Retail Sale Id 1255224',150000.00,0.00,0.00,0.00,-10000.00,'2021-12-01 08:35:43','',''),(2110581,'1','138','765',323,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-01 08:35:43','',''),(2110677,'1','138','765',323,'Retail Sale Id 1255262',150000.00,0.00,0.00,0.00,-10000.00,'2021-12-01 08:40:58','',''),(2110678,'1','138','765',323,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-01 08:40:58','',''),(2110689,'1','138','765',323,'Return of Retail Sale Id 1254007',0.00,151500.00,250.00,0.00,-3500.00,'2021-12-01 08:41:20','',''),(2110710,'1','138','765',323,'Retail Sale Id 1255280',30000.00,0.00,0.00,0.00,-2000.00,'2021-12-01 08:42:39','',''),(2110711,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 08:42:39','',''),(2110810,'1','138','765',323,'Retail Sale Id 1255344',2003.20,0.00,0.00,0.00,0.00,'2021-12-01 08:48:31','',''),(2110811,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 08:48:31','',''),(2110864,'1','138','765',323,'Retail Sale Id 1255372',21000.00,0.00,0.00,0.00,-1400.00,'2021-12-01 08:52:05','',''),(2110865,'1','138','765',323,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-01 08:52:05','',''),(2110898,'1','138','765',323,'Retail Sale Id 1255388',15000.00,0.00,0.00,0.00,-1000.00,'2021-12-01 08:54:07','',''),(2110899,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 08:54:07','',''),(2110942,'1','138','765',323,'Return of Retail Sale Id 1254214',0.00,30300.00,50.00,0.00,-700.00,'2021-12-01 08:56:38','',''),(2111050,'1','138','765',323,'Retail Sale Id 1255466',9000.00,0.00,0.00,0.00,-600.00,'2021-12-01 09:03:11','',''),(2111051,'1','138','765',323,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-01 09:03:11','',''),(2111200,'1','138','765',323,'Retail Sale Id 1255536',34800.00,0.00,0.00,0.00,-2320.00,'2021-12-01 09:12:18','',''),(2111201,'1','138','765',323,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-01 09:12:18','',''),(2111258,'1','138','765',323,'Retail Sale Id 1255574',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 09:15:36','',''),(2111259,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:15:36','',''),(2111322,'1','138','765',323,'Retail Sale Id 1255613',36900.00,0.00,0.00,0.00,-2460.00,'2021-12-01 09:19:11','',''),(2111323,'1','138','765',323,'Retail sales',0.00,0.00,0.00,61.50,0.00,'2021-12-01 09:19:11','',''),(2111397,'1','138','765',323,'Return of Retail Sale Id 1255224',0.00,150000.00,250.00,0.00,10000.00,'2021-12-01 09:24:01','',''),(2111448,'1','138','765',323,'Retail Sale Id 1255670',3200.00,0.00,0.00,0.00,0.00,'2021-12-01 09:26:30','',''),(2111449,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 09:26:30','',''),(2111660,'1','138','765',323,'Retail Sale Id 1255787',16000.00,0.00,0.00,0.00,0.00,'2021-12-01 09:40:21','',''),(2111661,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 09:40:21','',''),(2111720,'1','138','765',323,'Retail Sale Id 1255816',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 09:44:56','',''),(2111721,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:44:56','',''),(2111849,'1','138','765',323,'Retail Sale Id 1255883',3897.60,0.00,0.00,0.00,0.00,'2021-12-01 09:55:08','',''),(2111850,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 09:55:08','',''),(2111951,'1','138','765',323,'Retail Sale Id 1255926',3840.00,0.00,0.00,0.00,0.00,'2021-12-01 10:00:49','',''),(2111952,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 10:00:49','',''),(2111981,'1','138','765',323,'Retail Sale Id 1255942',54000.00,0.00,0.00,0.00,-3600.00,'2021-12-01 10:02:10','',''),(2111982,'1','138','765',323,'Retail sales',0.00,0.00,0.00,90.00,0.00,'2021-12-01 10:02:10','',''),(2112059,'1','138','765',323,'Retail Sale Id 1255980',4000.00,0.00,0.00,0.00,0.00,'2021-12-01 10:09:03','',''),(2112060,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 10:09:03','',''),(2112104,'1','138','765',323,'Retail Sale Id 1256006',3852.80,0.00,0.00,0.00,0.00,'2021-12-01 10:11:53','',''),(2112105,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 10:11:53','',''),(2112239,'1','138','765',323,'Retail Sale Id 1256070',10880.00,0.00,0.00,0.00,0.00,'2021-12-01 10:19:45','',''),(2112240,'1','138','765',323,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-01 10:19:45','',''),(2112355,'1','138','765',323,'Retail Sale Id 1256123',34800.00,0.00,0.00,0.00,-2320.00,'2021-12-01 10:29:32','',''),(2112356,'1','138','765',323,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-01 10:29:32','',''),(2112429,'1','138','765',323,'Retail Sale Id 1256165',198000.00,0.00,0.00,0.00,-13200.00,'2021-12-01 10:35:27','',''),(2112430,'1','138','765',323,'Retail sales',0.00,0.00,0.00,330.00,0.00,'2021-12-01 10:35:27','',''),(2112455,'1','138','765',323,'Retail Sale Id 1256174',2560.00,0.00,0.00,0.00,0.00,'2021-12-01 10:36:54','',''),(2112456,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 10:36:54','',''),(2112586,'1','138','765',323,'Retail Sale Id 1256239',2003.20,0.00,0.00,0.00,0.00,'2021-12-01 10:47:48','',''),(2112587,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 10:47:48','',''),(2112634,'1','138','765',323,'Retail Sale Id 1256264',30000.00,0.00,0.00,0.00,-2000.00,'2021-12-01 10:52:08','',''),(2112635,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 10:52:08','',''),(2112775,'1','138','765',323,'Retail Sale Id 1256342',626396.00,0.00,0.00,0.00,-46244.00,'2021-12-01 11:05:04','',''),(2112776,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1051.00,0.00,'2021-12-01 11:05:04','',''),(2112844,'1','138','765',323,'Retail Sale Id 1256375',99000.00,0.00,0.00,0.00,-6600.00,'2021-12-01 11:08:57','',''),(2112845,'1','138','765',323,'Retail sales',0.00,0.00,0.00,165.00,0.00,'2021-12-01 11:08:57','',''),(2112867,'1','138','765',323,'Retail Sale Id 1256390',5440.00,0.00,0.00,0.00,0.00,'2021-12-01 11:10:53','',''),(2112868,'1','138','765',323,'Retail sales',0.00,0.00,0.00,8.50,0.00,'2021-12-01 11:10:53','',''),(2112964,'1','138','765',323,'Retail Sale Id 1256426',162000.00,0.00,0.00,0.00,-10800.00,'2021-12-01 11:16:11','',''),(2112965,'1','138','765',323,'Retail sales',0.00,0.00,0.00,270.00,0.00,'2021-12-01 11:16:11','',''),(2113110,'1','138','765',323,'Retail Sale Id 1256496',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 11:24:54','',''),(2113111,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:24:54','',''),(2113148,'1','138','765',323,'Retail Sale Id 1256508',24000.00,0.00,0.00,0.00,-1600.00,'2021-12-01 11:26:29','',''),(2113149,'1','138','765',323,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-01 11:26:29','',''),(2113204,'1','138','765',323,'Retail Sale Id 1256538',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 11:30:21','',''),(2113205,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:30:21','',''),(2113373,'1','138','765',323,'Retail Sale Id 1256633',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 11:43:10','',''),(2113374,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:43:10','',''),(2113519,'1','138','765',323,'Retail Sale Id 1256705',3001.60,0.00,0.00,0.00,0.00,'2021-12-01 11:54:36','',''),(2113520,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 11:54:36','',''),(2113659,'1','138','765',323,'Retail Sale Id 1256780',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 12:09:59','',''),(2113660,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:09:59','',''),(2113699,'1','138','765',323,'Retail Sale Id 1256806',34800.00,0.00,0.00,0.00,-2320.00,'2021-12-01 12:12:41','',''),(2113700,'1','138','765',323,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-01 12:12:41','',''),(2113785,'1','138','765',323,'Retail Sale Id 1256849',1920.00,0.00,0.00,0.00,0.00,'2021-12-01 12:18:46','',''),(2113786,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 12:18:46','',''),(2113809,'1','138','765',323,'Retail Sale Id 1256861',3200.00,0.00,0.00,0.00,0.00,'2021-12-01 12:19:54','',''),(2113810,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 12:19:54','',''),(2113835,'1','138','765',323,'Retail Sale Id 1256873',12000.00,0.00,0.00,0.00,0.00,'2021-12-01 12:21:06','',''),(2113836,'1','138','765',323,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-01 12:21:06','',''),(2114166,'1','138','765',323,'Retail Sale Id 1257039',24000.00,0.00,0.00,0.00,-1600.00,'2021-12-01 12:51:52','',''),(2114167,'1','138','765',323,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-01 12:51:52','',''),(2114208,'1','138','765',323,'Retail Sale Id 1257066',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 12:56:52','',''),(2114209,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:56:52','',''),(2114264,'1','138','765',323,'Retail Sale Id 1257090',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 13:02:31','',''),(2114265,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:02:31','',''),(2114509,'1','138','765',323,'Retail Sale Id 1257246',34500.00,0.00,0.00,0.00,-2300.00,'2021-12-01 13:18:17','',''),(2114511,'1','138','765',323,'Retail sales',0.00,0.00,0.00,57.50,0.00,'2021-12-01 13:18:17','',''),(2114536,'1','138','765',323,'Retail Sale Id 1257262',6400.00,0.00,0.00,0.00,0.00,'2021-12-01 13:20:45','',''),(2114537,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 13:20:45','',''),(2114609,'1','138','765',323,'Retail Sale Id 1257295',6003.20,0.00,0.00,0.00,0.00,'2021-12-01 13:25:40','',''),(2114610,'1','138','765',323,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-01 13:25:40','',''),(2114647,'1','138','765',323,'Retail Sale Id 1257313',1952.00,0.00,0.00,0.00,0.00,'2021-12-01 13:29:45','',''),(2114648,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 13:29:45','',''),(2114705,'1','138','765',323,'Retail Sale Id 1257344',3801.60,0.00,0.00,0.00,0.00,'2021-12-01 13:34:58','',''),(2114706,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-01 13:34:58','',''),(2114917,'1','138','765',323,'Retail Sale Id 1257403',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 13:45:22','',''),(2114918,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:45:22','',''),(2115110,'1','138','765',323,'Retail Sale Id 1257486',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 13:56:12','',''),(2115111,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:56:12','',''),(2115261,'1','138','765',323,'Retail Sale Id 1257559',8320.00,0.00,0.00,0.00,0.00,'2021-12-01 14:03:36','',''),(2115262,'1','138','765',323,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-01 14:03:36','',''),(2115377,'1','138','765',323,'Retail Sale Id 1257622',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 14:11:32','',''),(2115378,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:11:32','',''),(2115399,'1','138','765',323,'Retail Sale Id 1257637',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 14:12:43','',''),(2115400,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:12:43','',''),(2115423,'1','138','765',323,'Retail Sale Id 1257648',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 14:14:15','',''),(2115424,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:14:15','',''),(2115437,'1','138','765',323,'Retail Sale Id 1257656',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 14:15:34','',''),(2115438,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:15:34','',''),(2115593,'1','138','765',323,'Retail Sale Id 1257741',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 14:26:48','',''),(2115594,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:26:48','',''),(2115648,'1','138','765',323,'Retail Sale Id 1257767',3852.80,0.00,0.00,0.00,0.00,'2021-12-01 14:30:41','',''),(2115649,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 14:30:41','',''),(2115660,'1','138','765',323,'Retail Sale Id 1257774',6003.20,0.00,0.00,0.00,0.00,'2021-12-01 14:31:53','',''),(2115661,'1','138','765',323,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-01 14:31:53','',''),(2115688,'1','138','765',323,'Retail Sale Id 1257785',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 14:33:29','',''),(2115689,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:33:29','',''),(2115784,'1','138','765',323,'Retail Sale Id 1257834',28740.00,0.00,0.00,0.00,-1916.00,'2021-12-01 14:40:17','',''),(2115785,'1','138','765',323,'Retail sales',0.00,0.00,0.00,47.90,0.00,'2021-12-01 14:40:17','',''),(2115975,'1','138','765',323,'Retail Sale Id 1257912',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 14:52:50','',''),(2115976,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:52:50','',''),(2116102,'1','138','765',323,'Retail Sale Id 1257958',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 14:59:44','',''),(2116103,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:59:44','',''),(2116142,'1','138','765',323,'Retail Sale Id 1257981',998.40,0.00,0.00,0.00,0.00,'2021-12-01 15:02:50','',''),(2116143,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 15:02:50','',''),(2116162,'1','138','765',323,'Retail Sale Id 1257989',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 15:03:56','',''),(2116163,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:03:56','',''),(2116174,'1','138','765',323,'Retail Sale Id 1257995',1952.00,0.00,0.00,0.00,0.00,'2021-12-01 15:04:55','',''),(2116175,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 15:04:55','',''),(2116249,'1','138','765',323,'Retail Sale Id 1258036',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 15:12:09','',''),(2116250,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:12:09','',''),(2116412,'1','138','765',323,'Retail Sale Id 1258113',3840.00,0.00,0.00,0.00,0.00,'2021-12-01 15:21:28','',''),(2116413,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:21:28','',''),(2116505,'1','138','765',323,'Retail Sale Id 1258152',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 15:27:17','',''),(2116506,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:27:17','',''),(2116575,'1','138','765',323,'Retail Sale Id 1258188',11840.00,0.00,0.00,0.00,0.00,'2021-12-01 15:31:34','',''),(2116576,'1','138','765',323,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-01 15:31:34','',''),(2116678,'1','138','765',323,'Retail Sale Id 1258242',4000.00,0.00,0.00,0.00,0.00,'2021-12-01 15:38:46','',''),(2116679,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 15:38:46','',''),(2116698,'1','138','765',323,'Retail Sale Id 1258251',2003.20,0.00,0.00,0.00,0.00,'2021-12-01 15:40:02','',''),(2116699,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 15:40:02','',''),(2116728,'1','138','765',323,'Retail Sale Id 1258265',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 15:42:07','',''),(2116729,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:42:07','',''),(2116984,'1','138','765',323,'Retail Sale Id 1258384',52200.00,0.00,0.00,0.00,-3480.00,'2021-12-01 15:52:59','',''),(2116985,'1','138','765',323,'Retail sales',0.00,0.00,0.00,87.00,0.00,'2021-12-01 15:52:59','',''),(2117072,'1','138','765',323,'Retail Sale Id 1258425',11840.00,0.00,0.00,0.00,0.00,'2021-12-01 15:56:35','',''),(2117073,'1','138','765',323,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-01 15:56:35','',''),(2117090,'1','138','765',323,'Retail Sale Id 1258436',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 15:57:39','',''),(2117091,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:57:39','',''),(2117535,'1','138','765',323,'Retail Sale Id 1258629',3500.80,0.00,0.00,0.00,0.00,'2021-12-01 16:15:29','',''),(2117536,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 16:15:29','',''),(2117625,'1','138','765',323,'Retail Sale Id 1258679',32000.00,0.00,0.00,0.00,0.00,'2021-12-01 16:19:36','',''),(2117626,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 16:19:36','',''),(2117666,'1','138','765',323,'Retail Sale Id 1258696',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 16:21:07','',''),(2117667,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:21:07','',''),(2117708,'1','138','765',323,'Retail Sale Id 1258718',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 16:22:54','',''),(2117709,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:22:54','',''),(2117822,'1','138','765',323,'Retail Sale Id 1258794',97500.00,0.00,0.00,0.00,-6500.00,'2021-12-01 16:28:12','',''),(2117823,'1','138','765',323,'Retail sales',0.00,0.00,0.00,162.50,0.00,'2021-12-01 16:28:12','',''),(2117858,'1','138','765',323,'Retail Sale Id 1258811',704.00,0.00,0.00,0.00,0.00,'2021-12-01 16:29:52','',''),(2117859,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1.10,0.00,'2021-12-01 16:29:52','',''),(2117882,'1','138','765',323,'Retail Sale Id 1258826',798640.00,0.00,0.00,0.00,-58960.00,'2021-12-01 16:31:03','',''),(2117883,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1340.00,0.00,'2021-12-01 16:31:03','',''),(2117940,'1','138','765',323,'Retail Sale Id 1258859',27000.00,0.00,0.00,0.00,-1800.00,'2021-12-01 16:33:51','',''),(2117941,'1','138','765',323,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-01 16:33:51','',''),(2118018,'1','138','765',323,'Retail Sale Id 1258896',12000.00,0.00,0.00,0.00,0.00,'2021-12-01 16:37:46','',''),(2118019,'1','138','765',323,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-01 16:37:46','',''),(2118126,'1','138','765',323,'Retail Sale Id 1258953',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 16:43:18','',''),(2118127,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:43:18','',''),(2118158,'1','138','765',323,'Retail Sale Id 1258973',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 16:44:42','',''),(2118159,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:44:42','',''),(2118186,'1','138','765',323,'Retail Sale Id 1258988',37500.00,0.00,0.00,0.00,-2500.00,'2021-12-01 16:46:14','',''),(2118187,'1','138','765',323,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-01 16:46:14','',''),(2118244,'1','138','765',323,'Retail Sale Id 1259014',33000.00,0.00,0.00,0.00,-2200.00,'2021-12-01 16:49:19','',''),(2118245,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-01 16:49:19','',''),(2118288,'1','138','765',323,'Retail Sale Id 1259040',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 16:51:29','',''),(2118289,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:51:29','',''),(2118324,'1','138','765',323,'Retail Sale Id 1259059',3852.80,0.00,0.00,0.00,0.00,'2021-12-01 16:53:07','',''),(2118325,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 16:53:07','',''),(2118426,'1','138','765',323,'Retail Sale Id 1259106',12000.00,0.00,0.00,0.00,0.00,'2021-12-01 16:56:53','',''),(2118427,'1','138','765',323,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-01 16:56:53','',''),(2118462,'1','138','765',323,'Retail Sale Id 1259123',21600.00,0.00,0.00,0.00,-1440.00,'2021-12-01 16:58:27','',''),(2118463,'1','138','765',323,'Retail sales',0.00,0.00,0.00,36.00,0.00,'2021-12-01 16:58:27','',''),(2118526,'1','138','765',323,'Retail Sale Id 1259155',34800.00,0.00,0.00,0.00,-2320.00,'2021-12-01 17:01:10','',''),(2118527,'1','138','765',323,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-01 17:01:10','',''),(2118638,'1','138','765',323,'Retail Sale Id 1259207',25600.00,0.00,0.00,0.00,0.00,'2021-12-01 17:06:38','',''),(2118639,'1','138','765',323,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-01 17:06:38','',''),(2118698,'1','138','765',323,'Retail Sale Id 1259241',3840.00,0.00,0.00,0.00,0.00,'2021-12-01 17:09:30','',''),(2118699,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 17:09:30','',''),(2118774,'1','138','765',323,'Retail Sale Id 1259281',3852.80,0.00,0.00,0.00,0.00,'2021-12-01 17:13:50','',''),(2118775,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 17:13:50','',''),(2118838,'1','138','765',323,'Retail Sale Id 1259312',6003.20,0.00,0.00,0.00,0.00,'2021-12-01 17:17:34','',''),(2118839,'1','138','765',323,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-01 17:17:34','',''),(2118856,'1','138','765',323,'Retail Sale Id 1259321',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 17:18:38','',''),(2118857,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:18:38','',''),(2118894,'1','138','765',323,'Retail Sale Id 1259344',1900.80,0.00,0.00,0.00,0.00,'2021-12-01 17:21:33','',''),(2118895,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-01 17:21:33','',''),(2119109,'1','138','765',323,'Retail Sale Id 1259449',2003.20,0.00,0.00,0.00,0.00,'2021-12-01 17:36:37','',''),(2119110,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 17:36:37','',''),(2119256,'1','138','765',323,'Retail Sale Id 1259519',7500.00,0.00,0.00,0.00,-500.00,'2021-12-01 17:48:05','',''),(2119257,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:48:05','',''),(2119304,'1','138','765',323,'Retail Sale Id 1259544',9600.00,0.00,0.00,0.00,0.00,'2021-12-01 17:54:26','',''),(2119305,'1','138','765',323,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-01 17:54:26','',''),(2119317,'1','138','765',323,'Retail Sale Id 1259550',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 17:55:44','',''),(2119318,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:55:44','',''),(2119330,'1','138','765',323,'Retail Sale Id 1259556',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 17:57:07','',''),(2119331,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:57:07','',''),(2119382,'1','138','765',323,'Retail Sale Id 1259580',2003.20,0.00,0.00,0.00,0.00,'2021-12-01 18:05:07','',''),(2119383,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 18:05:07','',''),(2119419,'1','138','765',323,'Retail Sale Id 1259603',8000.00,0.00,0.00,0.00,0.00,'2021-12-01 18:10:52','',''),(2119420,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 18:10:52','',''),(2120571,'1','138','765',323,'Retail Sale Id 1259935',64000.00,0.00,0.00,0.00,0.00,'2021-12-02 06:19:11','',''),(2120572,'1','138','765',323,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-02 06:19:11','',''),(2120594,'1','138','765',323,'Retail Sale Id 1259944',8000.00,0.00,0.00,0.00,0.00,'2021-12-02 06:20:29','',''),(2120595,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 06:20:29','',''),(2120704,'1','138','765',323,'Retail Sale Id 1260000',33000.00,0.00,0.00,0.00,-2200.00,'2021-12-02 06:29:40','',''),(2120705,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-02 06:29:40','',''),(2121012,'1','138','765',323,'Retail Sale Id 1260109',30000.00,0.00,0.00,0.00,-2000.00,'2021-12-02 06:45:02','',''),(2121013,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 06:45:02','',''),(2121038,'1','138','765',323,'Retail Sale Id 1260124',6400.00,0.00,0.00,0.00,0.00,'2021-12-02 06:47:07','',''),(2121039,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 06:47:07','',''),(2121230,'1','138','765',323,'Retail Sale Id 1260209',998.40,0.00,0.00,0.00,0.00,'2021-12-02 06:57:57','',''),(2121231,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 06:57:57','',''),(2121406,'1','138','765',323,'Retail Sale Id 1260303',30000.00,0.00,0.00,0.00,-2000.00,'2021-12-02 07:08:26','',''),(2121407,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 07:08:26','',''),(2121580,'1','138','765',323,'Retail Sale Id 1260370',11001.60,0.00,0.00,0.00,0.00,'2021-12-02 07:16:16','',''),(2121581,'1','138','765',323,'Retail sales',0.00,0.00,0.00,17.19,0.00,'2021-12-02 07:16:16','',''),(2121877,'1','138','765',323,'Retail Sale Id 1260524',12800.00,0.00,0.00,0.00,0.00,'2021-12-02 07:31:00','',''),(2121878,'1','138','765',323,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-02 07:31:00','',''),(2122118,'1','138','765',323,'Retail Sale Id 1260657',8000.00,0.00,0.00,0.00,0.00,'2021-12-02 07:42:41','',''),(2122119,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:42:41','',''),(2122120,'1','138','765',323,'Retail Sale Id 1260657',9600.00,0.00,0.00,0.00,0.00,'2021-12-02 07:42:41','',''),(2122121,'1','138','765',323,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-02 07:42:41','',''),(2122197,'1','138','765',323,'Retail Sale Id 1260701',1920.00,0.00,0.00,0.00,0.00,'2021-12-02 07:47:16','',''),(2122198,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:47:16','',''),(2122727,'1','138','765',323,'Retail Sale Id 1260933',33000.00,0.00,0.00,0.00,-2200.00,'2021-12-02 08:07:54','',''),(2122728,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-02 08:07:54','',''),(2122763,'1','138','765',323,'Retail Sale Id 1260953',12000.00,0.00,0.00,0.00,-800.00,'2021-12-02 08:09:57','',''),(2122764,'1','138','765',323,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-02 08:09:57','',''),(2122860,'1','138','765',323,'Retail Sale Id 1261007',30000.00,0.00,0.00,0.00,-2000.00,'2021-12-02 08:15:38','',''),(2122861,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 08:15:38','',''),(2123085,'1','138','765',323,'Retail Sale Id 1261121',285000.00,0.00,0.00,0.00,-19000.00,'2021-12-02 08:26:44','',''),(2123086,'1','138','765',323,'Retail sales',0.00,0.00,0.00,475.00,0.00,'2021-12-02 08:26:44','',''),(2123241,'1','138','765',323,'Retail Sale Id 1261204',8000.00,0.00,0.00,0.00,0.00,'2021-12-02 08:35:43','',''),(2123242,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:35:43','',''),(2123342,'1','138','765',323,'Retail Sale Id 1261226',75600.00,0.00,0.00,0.00,-5040.00,'2021-12-02 08:39:04','',''),(2123343,'1','138','765',323,'Retail sales',0.00,0.00,0.00,126.00,0.00,'2021-12-02 08:39:04','',''),(2123395,'1','138','765',323,'Retail Sale Id 1261259',30600.00,0.00,0.00,0.00,-2040.00,'2021-12-02 08:41:48','',''),(2123396,'1','138','765',323,'Retail sales',0.00,0.00,0.00,51.00,0.00,'2021-12-02 08:41:48','',''),(2123693,'1','138','765',323,'Retail Sale Id 1261404',4480.00,0.00,0.00,0.00,0.00,'2021-12-02 08:58:47','',''),(2123694,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 08:58:47','',''),(2123739,'1','138','765',323,'Retail Sale Id 1261426',8000.00,0.00,0.00,0.00,0.00,'2021-12-02 09:01:04','',''),(2123740,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:01:04','',''),(2123879,'1','138','765',323,'Retail Sale Id 1261515',19800.00,0.00,0.00,0.00,-1320.00,'2021-12-02 09:08:07','',''),(2123880,'1','138','765',323,'Retail sales',0.00,0.00,0.00,33.00,0.00,'2021-12-02 09:08:07','',''),(2123957,'1','138','765',323,'Retail Sale Id 1261546',4000.00,0.00,0.00,0.00,0.00,'2021-12-02 09:11:18','',''),(2123958,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 09:11:18','',''),(2124035,'1','138','765',323,'Retail Sale Id 1261578',176000.00,0.00,0.00,0.00,0.00,'2021-12-02 09:15:07','',''),(2124036,'1','138','765',323,'Retail sales',0.00,0.00,0.00,275.00,0.00,'2021-12-02 09:15:07','',''),(2124170,'1','138','765',323,'Retail Sale Id 1261633',83400.00,0.00,0.00,0.00,-5560.00,'2021-12-02 09:20:59','',''),(2124171,'1','138','765',323,'Retail sales',0.00,0.00,0.00,139.00,0.00,'2021-12-02 09:20:59','',''),(2124465,'1','138','765',323,'Retail Sale Id 1261784',42000.00,0.00,0.00,0.00,-2800.00,'2021-12-02 09:40:36','',''),(2124466,'1','138','765',323,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-02 09:40:36','',''),(2124535,'1','138','765',323,'Retail Sale Id 1261817',8000.00,0.00,0.00,0.00,0.00,'2021-12-02 09:43:59','',''),(2124536,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:43:59','',''),(2124795,'1','138','765',323,'Retail Sale Id 1261955',8000.00,0.00,0.00,0.00,0.00,'2021-12-02 09:56:52','',''),(2124796,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:56:52','',''),(2124902,'1','138','765',323,'Retail Sale Id 1262011',115200.00,0.00,0.00,0.00,-7680.00,'2021-12-02 10:02:30','',''),(2124903,'1','138','765',323,'Retail sales',0.00,0.00,0.00,192.00,0.00,'2021-12-02 10:02:30','',''),(2124918,'1','138','765',323,'Return of Retail Sale Id 1262011',0.00,115200.00,192.00,0.00,7680.00,'2021-12-02 10:02:58','',''),(2124933,'1','138','765',323,'Retail Sale Id 1262025',115200.00,0.00,0.00,0.00,-7680.00,'2021-12-02 10:03:40','',''),(2124934,'1','138','765',323,'Retail sales',0.00,0.00,0.00,192.00,0.00,'2021-12-02 10:03:40','',''),(2124993,'1','138','765',323,'Retail Sale Id 1262064',11200.00,0.00,0.00,0.00,0.00,'2021-12-02 10:08:24','',''),(2124994,'1','138','765',323,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-02 10:08:24','',''),(2125124,'1','138','765',323,'Retail Sale Id 1262129',24000.00,0.00,0.00,0.00,0.00,'2021-12-02 10:15:56','',''),(2125125,'1','138','765',323,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-02 10:15:56','',''),(2125216,'1','138','765',323,'Retail Sale Id 1262176',3840.00,0.00,0.00,0.00,0.00,'2021-12-02 10:21:12','',''),(2125217,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 10:21:12','',''),(2125380,'1','138','765',323,'Retail Sale Id 1262253',4000.00,0.00,0.00,0.00,0.00,'2021-12-02 10:29:37','',''),(2125381,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 10:29:37','',''),(2125508,'1','138','765',323,'Retail Sale Id 1262316',33000.00,0.00,0.00,0.00,-2200.00,'2021-12-02 10:37:40','',''),(2125509,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-02 10:37:40','',''),(2125588,'1','138','765',323,'Retail Sale Id 1262353',4000.00,0.00,0.00,0.00,0.00,'2021-12-02 10:43:02','',''),(2125589,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 10:43:02','',''),(2125630,'1','138','765',323,'Retail Sale Id 1262374',103500.00,0.00,0.00,0.00,-6900.00,'2021-12-02 10:44:59','',''),(2125631,'1','138','765',323,'Retail sales',0.00,0.00,0.00,172.50,0.00,'2021-12-02 10:44:59','',''),(2125704,'1','138','765',323,'Retail Sale Id 1262406',8000.00,0.00,0.00,0.00,0.00,'2021-12-02 10:49:37','',''),(2125705,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:49:37','',''),(2125748,'1','138','765',323,'Retail Sale Id 1262426',4000.00,0.00,0.00,0.00,0.00,'2021-12-02 10:52:24','',''),(2125749,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 10:52:24','',''),(2126210,'1','138','765',323,'Retail Sale Id 1262471',8000.00,0.00,0.00,0.00,0.00,'2021-12-02 11:21:12','',''),(2126211,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:21:12','',''),(2126234,'1','138','765',323,'Retail Sale Id 1262695',57600.00,0.00,0.00,0.00,-3840.00,'2021-12-02 11:22:31','',''),(2126235,'1','138','765',323,'Retail sales',0.00,0.00,0.00,96.00,0.00,'2021-12-02 11:22:31','',''),(2126284,'1','138','765',323,'Retail Sale Id 1262716',8000.00,0.00,0.00,0.00,0.00,'2021-12-02 11:26:12','',''),(2126285,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:26:12','',''),(2126437,'1','138','765',323,'Retail Sale Id 1262783',8000.00,0.00,0.00,0.00,0.00,'2021-12-02 11:32:53','',''),(2126438,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:32:53','',''),(2126513,'1','138','765',323,'Retail Sale Id 1262815',7040.00,0.00,0.00,0.00,0.00,'2021-12-02 11:36:43','',''),(2126514,'1','138','765',323,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-02 11:36:43','',''),(2126515,'1','138','765',323,'Retail Sale Id 1262815',11520.00,0.00,0.00,0.00,0.00,'2021-12-02 11:36:43','',''),(2126516,'1','138','765',323,'Retail sales',0.00,0.00,0.00,18.00,0.00,'2021-12-02 11:36:43','',''),(2127084,'1','138','765',323,'Retail Sale Id 1263095',446400.00,0.00,0.00,0.00,-29760.00,'2021-12-02 12:22:04','',''),(2127085,'1','138','765',323,'Retail sales',0.00,0.00,0.00,744.00,0.00,'2021-12-02 12:22:04','',''),(2127396,'1','138','765',323,'Retail Sale Id 1263275',8000.00,0.00,0.00,0.00,0.00,'2021-12-02 12:46:50','',''),(2127397,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:46:50','',''),(2127473,'1','138','765',323,'Retail Sale Id 1263300',44400.00,0.00,0.00,0.00,-2960.00,'2021-12-02 12:50:12','',''),(2127474,'1','138','765',323,'Retail sales',0.00,0.00,0.00,74.00,0.00,'2021-12-02 12:50:12','',''),(2127903,'1','138','765',323,'Retail Sale Id 1263500',27000.00,0.00,0.00,0.00,-1800.00,'2021-12-02 13:20:11','',''),(2127904,'1','138','765',323,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-02 13:20:11','',''),(2127917,'1','138','765',323,'Retail Sale Id 1263506',30000.00,0.00,0.00,0.00,-2000.00,'2021-12-02 13:21:38','',''),(2127918,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 13:21:38','',''),(2128035,'1','138','765',323,'Retail Sale Id 1263552',3200.00,0.00,0.00,0.00,0.00,'2021-12-02 13:28:52','',''),(2128036,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 13:28:52','',''),(2128049,'1','138','765',323,'Retail Sale Id 1263559',63000.00,0.00,0.00,0.00,-4200.00,'2021-12-02 13:30:14','',''),(2128050,'1','138','765',323,'Retail sales',0.00,0.00,0.00,105.00,0.00,'2021-12-02 13:30:14','',''),(2128288,'1','138','765',323,'Retail Sale Id 1263658',8000.00,0.00,0.00,0.00,0.00,'2021-12-02 13:46:10','',''),(2128289,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:46:10','',''),(2128332,'1','138','765',323,'Retail Sale Id 1263681',4000.00,0.00,0.00,0.00,0.00,'2021-12-02 13:48:15','',''),(2128333,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 13:48:15','',''),(2128515,'1','138','765',323,'Retail Sale Id 1263758',24000.00,0.00,0.00,0.00,-1600.00,'2021-12-02 13:57:27','',''),(2128516,'1','138','765',323,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-02 13:57:27','',''),(2128808,'1','138','765',323,'Retail Sale Id 1263888',150000.00,0.00,0.00,0.00,-10000.00,'2021-12-02 14:16:16','',''),(2128809,'1','138','765',323,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-02 14:16:16','',''),(2128995,'1','138','765',323,'Retail Sale Id 1263973',144000.00,0.00,0.00,0.00,-9600.00,'2021-12-02 14:24:39','',''),(2128996,'1','138','765',323,'Retail sales',0.00,0.00,0.00,240.00,0.00,'2021-12-02 14:24:39','',''),(2129055,'1','138','765',323,'Retail Sale Id 1263990',33000.00,0.00,0.00,0.00,-2200.00,'2021-12-02 14:26:43','',''),(2129056,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-02 14:26:43','',''),(2129128,'1','138','765',323,'Retail Sale Id 1264018',96000.00,0.00,0.00,0.00,-6400.00,'2021-12-02 14:29:13','',''),(2129129,'1','138','765',323,'Retail sales',0.00,0.00,0.00,160.00,0.00,'2021-12-02 14:29:13','',''),(2129409,'1','138','765',323,'Retail Sale Id 1264123',3852.80,0.00,0.00,0.00,0.00,'2021-12-02 14:41:42','',''),(2129410,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 14:41:43','',''),(2129509,'1','138','765',323,'Retail Sale Id 1264176',6400.00,0.00,0.00,0.00,0.00,'2021-12-02 14:48:05','',''),(2129510,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 14:48:05','',''),(2129644,'1','138','765',323,'Return of Retail Sale Id 1263888',0.00,150000.00,250.00,0.00,10000.00,'2021-12-02 14:55:46','',''),(2130372,'1','138','765',323,'Retail Sale Id 1264605',4000.00,0.00,0.00,0.00,0.00,'2021-12-02 15:35:26','',''),(2130373,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 15:35:26','',''),(2130502,'1','138','765',323,'Retail Sale Id 1264669',3500.80,0.00,0.00,0.00,0.00,'2021-12-02 15:41:20','',''),(2130503,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 15:41:20','',''),(2130542,'1','138','765',323,'Retail Sale Id 1264700',3840.00,0.00,0.00,0.00,0.00,'2021-12-02 15:43:26','',''),(2130543,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 15:43:26','',''),(2130594,'1','138','765',323,'Retail Sale Id 1264729',3840.00,0.00,0.00,0.00,0.00,'2021-12-02 15:45:23','',''),(2130595,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 15:45:23','',''),(2130702,'1','138','765',323,'Retail Sale Id 1264787',42000.00,0.00,0.00,0.00,-2800.00,'2021-12-02 15:50:53','',''),(2130703,'1','138','765',323,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-02 15:50:53','',''),(2130744,'1','138','765',323,'Retail Sale Id 1264810',3840.00,0.00,0.00,0.00,0.00,'2021-12-02 15:52:23','',''),(2130745,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 15:52:23','',''),(2130796,'1','138','765',323,'Retail Sale Id 1264843',3001.60,0.00,0.00,0.00,0.00,'2021-12-02 15:54:35','',''),(2130797,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 15:54:35','',''),(2130848,'1','138','765',323,'Retail Sale Id 1264862',8000.00,0.00,0.00,0.00,0.00,'2021-12-02 15:56:14','',''),(2130849,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:56:14','',''),(2131478,'1','138','765',323,'Retail Sale Id 1265167',3852.80,0.00,0.00,0.00,0.00,'2021-12-02 16:25:58','',''),(2131479,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 16:25:58','',''),(2131518,'1','138','765',323,'Retail Sale Id 1265190',5120.00,0.00,0.00,0.00,0.00,'2021-12-02 16:27:41','',''),(2131519,'1','138','765',323,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-02 16:27:41','',''),(2131562,'1','138','765',323,'Retail Sale Id 1265212',3852.80,0.00,0.00,0.00,0.00,'2021-12-02 16:29:18','',''),(2131563,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 16:29:18','',''),(2131847,'1','138','765',323,'Retail Sale Id 1265343',3852.80,0.00,0.00,0.00,0.00,'2021-12-02 16:42:20','',''),(2131848,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 16:42:20','',''),(2131875,'1','138','765',323,'Retail Sale Id 1265355',40200.00,0.00,0.00,0.00,-2680.00,'2021-12-02 16:43:46','',''),(2131876,'1','138','765',323,'Retail sales',0.00,0.00,0.00,67.00,0.00,'2021-12-02 16:43:46','',''),(2131988,'1','138','765',323,'Retail Sale Id 1265414',4998.40,0.00,0.00,0.00,0.00,'2021-12-02 16:48:35','',''),(2131989,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 16:48:35','',''),(2132034,'1','138','765',323,'Retail Sale Id 1265442',39680.00,0.00,0.00,0.00,0.00,'2021-12-02 16:51:57','',''),(2132035,'1','138','765',323,'Retail sales',0.00,0.00,0.00,62.00,0.00,'2021-12-02 16:51:57','',''),(2132338,'1','138','765',323,'Retail Sale Id 1265586',30000.00,0.00,0.00,0.00,-2000.00,'2021-12-02 17:11:08','',''),(2132339,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 17:11:08','',''),(2132943,'1','138','765',323,'Retail Sale Id 1265854',604940.00,0.00,0.00,0.00,-44660.00,'2021-12-02 18:00:11','',''),(2132944,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1015.00,0.00,'2021-12-02 18:00:11','',''),(2132951,'1','138','765',323,'Retail Sale Id 1265857',704.00,0.00,0.00,0.00,0.00,'2021-12-02 18:01:08','',''),(2132952,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1.10,0.00,'2021-12-02 18:01:08','',''),(2133930,'1','138','765',323,'Retail Sale Id 1266095',79200.00,0.00,0.00,0.00,-5280.00,'2021-12-03 06:06:21','',''),(2133931,'1','138','765',323,'Retail sales',0.00,0.00,0.00,132.00,0.00,'2021-12-03 06:06:21','',''),(2134131,'1','138','765',323,'Retail Sale Id 1266162',3852.80,0.00,0.00,0.00,0.00,'2021-12-03 06:25:23','',''),(2134132,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 06:25:23','',''),(2134665,'1','138','765',323,'Retail Sale Id 1266422',2502.40,0.00,0.00,0.00,0.00,'2021-12-03 06:56:28','',''),(2134666,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 06:56:28','',''),(2134698,'1','138','765',323,'Retail Sale Id 1266435',3852.80,0.00,0.00,0.00,0.00,'2021-12-03 06:58:11','',''),(2134699,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 06:58:11','',''),(2135133,'1','138','765',323,'Retail Sale Id 1266648',120000.00,0.00,0.00,0.00,-8000.00,'2021-12-03 07:22:56','',''),(2135134,'1','138','765',323,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-03 07:22:56','',''),(2135155,'1','138','765',323,'Retail Sale Id 1266656',34200.00,0.00,0.00,0.00,-2280.00,'2021-12-03 07:24:17','',''),(2135156,'1','138','765',323,'Retail sales',0.00,0.00,0.00,57.00,0.00,'2021-12-03 07:24:17','',''),(2135364,'1','138','765',323,'Retail Sale Id 1266761',12800.00,0.00,0.00,0.00,0.00,'2021-12-03 07:36:14','',''),(2135365,'1','138','765',323,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-03 07:36:14','',''),(2135441,'1','138','765',323,'Retail Sale Id 1266795',195000.00,0.00,0.00,0.00,-13000.00,'2021-12-03 07:40:12','',''),(2135442,'1','138','765',323,'Retail sales',0.00,0.00,0.00,325.00,0.00,'2021-12-03 07:40:12','',''),(2135692,'1','138','765',323,'Retail Sale Id 1266914',3852.80,0.00,0.00,0.00,0.00,'2021-12-03 07:53:32','',''),(2135693,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 07:53:32','',''),(2135709,'1','138','765',323,'Retail Sale Id 1266919',3200.00,0.00,0.00,0.00,0.00,'2021-12-03 07:54:47','',''),(2135710,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 07:54:47','',''),(2135818,'1','138','765',323,'Retail Sale Id 1266967',37800.00,0.00,0.00,0.00,-2520.00,'2021-12-03 08:00:38','',''),(2135819,'1','138','765',323,'Retail sales',0.00,0.00,0.00,63.00,0.00,'2021-12-03 08:00:38','',''),(2136368,'1','138','765',323,'Retail Sale Id 1267220',8000.00,0.00,0.00,0.00,0.00,'2021-12-03 08:26:23','',''),(2136369,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:26:23','',''),(2136400,'1','138','765',323,'Retail Sale Id 1267236',33000.00,0.00,0.00,0.00,-2200.00,'2021-12-03 08:28:29','',''),(2136401,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-03 08:28:29','',''),(2136587,'1','138','765',323,'Retail Sale Id 1267289',1952.00,0.00,0.00,0.00,0.00,'2021-12-03 08:37:25','',''),(2136588,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 08:37:25','',''),(2136700,'1','138','765',323,'Retail Sale Id 1267318',30000.00,0.00,0.00,0.00,-2000.00,'2021-12-03 08:40:36','',''),(2136701,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 08:40:36','',''),(2136772,'1','138','765',323,'Retail Sale Id 1267346',8000.00,0.00,0.00,0.00,0.00,'2021-12-03 08:43:30','',''),(2136773,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:43:30','',''),(2137164,'1','138','765',323,'Retail Sale Id 1267552',48000.00,0.00,0.00,0.00,-3200.00,'2021-12-03 09:05:30','',''),(2137165,'1','138','765',323,'Retail sales',0.00,0.00,0.00,80.00,0.00,'2021-12-03 09:05:30','',''),(2137198,'1','138','765',323,'Retail Sale Id 1267568',1920.00,0.00,0.00,0.00,0.00,'2021-12-03 09:06:54','',''),(2137199,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 09:06:54','',''),(2137579,'1','138','765',323,'Retail Sale Id 1267787',150000.00,0.00,0.00,0.00,-10000.00,'2021-12-03 09:27:18','',''),(2137580,'1','138','765',323,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-03 09:27:18','',''),(2137631,'1','138','765',323,'Retail Sale Id 1267820',11552.00,0.00,0.00,0.00,0.00,'2021-12-03 09:30:52','',''),(2137632,'1','138','765',323,'Retail sales',0.00,0.00,0.00,18.05,0.00,'2021-12-03 09:30:52','',''),(2137657,'1','138','765',323,'Retail Sale Id 1267835',57900.00,0.00,0.00,0.00,-3860.00,'2021-12-03 09:32:37','',''),(2137658,'1','138','765',323,'Retail sales',0.00,0.00,0.00,96.50,0.00,'2021-12-03 09:32:37','',''),(2137805,'1','138','765',323,'Retail Sale Id 1267917',8000.00,0.00,0.00,0.00,0.00,'2021-12-03 09:42:24','',''),(2137806,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:42:24','',''),(2138217,'1','138','765',323,'Retail Sale Id 1268122',3852.80,0.00,0.00,0.00,0.00,'2021-12-03 10:06:52','',''),(2138218,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 10:06:52','',''),(2138271,'1','138','765',323,'Retail Sale Id 1268147',30000.00,0.00,0.00,0.00,-2000.00,'2021-12-03 10:09:08','',''),(2138272,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 10:09:08','',''),(2138310,'1','138','765',323,'Retail Sale Id 1268164',7001.60,0.00,0.00,0.00,0.00,'2021-12-03 10:10:51','',''),(2138311,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-03 10:10:51','',''),(2138520,'1','138','765',323,'Retail Sale Id 1268269',24000.00,0.00,0.00,0.00,-1600.00,'2021-12-03 10:23:25','',''),(2138521,'1','138','765',323,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-03 10:23:25','',''),(2138546,'1','138','765',323,'Retail Sale Id 1268283',3000.00,0.00,0.00,0.00,-200.00,'2021-12-03 10:25:04','',''),(2138547,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 10:25:04','',''),(2139040,'1','138','765',323,'Retail Sale Id 1268535',8000.00,0.00,0.00,0.00,0.00,'2021-12-03 10:59:46','',''),(2139041,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:59:46','',''),(2139320,'1','138','765',323,'Retail Sale Id 1268675',8000.00,0.00,0.00,0.00,0.00,'2021-12-03 11:18:47','',''),(2139321,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:18:47','',''),(2139374,'1','138','765',323,'Retail Sale Id 1268704',8000.00,0.00,0.00,0.00,0.00,'2021-12-03 11:24:39','',''),(2139375,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:24:39','',''),(2139604,'1','138','765',323,'Retail Sale Id 1268838',30000.00,0.00,0.00,0.00,-2000.00,'2021-12-03 11:43:30','',''),(2139605,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 11:43:30','',''),(2139692,'1','138','765',323,'Retail Sale Id 1268884',120000.00,0.00,0.00,0.00,-8000.00,'2021-12-03 11:49:32','',''),(2139693,'1','138','765',323,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-03 11:49:32','',''),(2139719,'1','138','765',323,'Retail Sale Id 1268903',34800.00,0.00,0.00,0.00,-2320.00,'2021-12-03 11:51:59','',''),(2139720,'1','138','765',323,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-03 11:51:59','',''),(2139825,'1','138','765',323,'Retail Sale Id 1268959',3840.00,0.00,0.00,0.00,0.00,'2021-12-03 12:00:06','',''),(2139826,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 12:00:06','',''),(2140062,'1','138','765',323,'Retail Sale Id 1269100',9300.00,0.00,0.00,0.00,-620.00,'2021-12-03 12:18:26','',''),(2140063,'1','138','765',323,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-03 12:18:26','',''),(2140076,'1','138','765',323,'Retail Sale Id 1269110',3001.60,0.00,0.00,0.00,0.00,'2021-12-03 12:20:04','',''),(2140077,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 12:20:04','',''),(2140220,'1','138','765',323,'Retail Sale Id 1269186',15000.00,0.00,0.00,0.00,-1000.00,'2021-12-03 12:31:42','',''),(2140221,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 12:31:42','',''),(2140270,'1','138','765',323,'Retail Sale Id 1269221',30003.20,0.00,0.00,0.00,0.00,'2021-12-03 12:36:16','',''),(2140271,'1','138','765',323,'Retail sales',0.00,0.00,0.00,46.88,0.00,'2021-12-03 12:36:16','',''),(2140280,'1','138','765',323,'Retail Sale Id 1269230',3200.00,0.00,0.00,0.00,0.00,'2021-12-03 12:37:06','',''),(2140281,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 12:37:06','',''),(2140379,'1','138','765',323,'Retail Sale Id 1269270',12000.00,0.00,0.00,0.00,-800.00,'2021-12-03 12:43:26','',''),(2140380,'1','138','765',323,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-03 12:43:26','',''),(2140465,'1','138','765',323,'Retail Sale Id 1269310',8000.00,0.00,0.00,0.00,0.00,'2021-12-03 12:49:49','',''),(2140466,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:49:49','',''),(2140487,'1','138','765',323,'Retail Sale Id 1269322',11200.00,0.00,0.00,0.00,0.00,'2021-12-03 12:51:19','',''),(2140488,'1','138','765',323,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-03 12:51:19','',''),(2140507,'1','138','765',323,'Retail Sale Id 1269332',4998.40,0.00,0.00,0.00,0.00,'2021-12-03 12:52:26','',''),(2140508,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 12:52:26','',''),(2140577,'1','138','765',323,'Retail Sale Id 1269367',4998.40,0.00,0.00,0.00,0.00,'2021-12-03 12:57:09','',''),(2140578,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 12:57:09','',''),(2140612,'1','138','765',323,'Retail Sale Id 1269384',8000.00,0.00,0.00,0.00,0.00,'2021-12-03 13:00:52','',''),(2140613,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:00:52','',''),(2140705,'1','138','765',323,'Retail Sale Id 1269424',8000.00,0.00,0.00,0.00,0.00,'2021-12-03 13:07:42','',''),(2140706,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:07:42','',''),(2140731,'1','138','765',323,'Retail Sale Id 1269438',8000.00,0.00,0.00,0.00,0.00,'2021-12-03 13:11:07','',''),(2140732,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:11:07','',''),(2140747,'1','138','765',323,'Retail Sale Id 1269446',8000.00,0.00,0.00,0.00,0.00,'2021-12-03 13:12:52','',''),(2140748,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:12:52','',''),(2140954,'1','138','765',323,'Retail Sale Id 1269536',11840.00,0.00,0.00,0.00,0.00,'2021-12-03 13:28:18','',''),(2140955,'1','138','765',323,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-03 13:28:18','',''),(2140984,'1','138','765',323,'Retail Sale Id 1269552',8000.00,0.00,0.00,0.00,0.00,'2021-12-03 13:30:14','',''),(2140985,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:30:14','',''),(2141132,'1','138','765',323,'Retail Sale Id 1269630',3840.00,0.00,0.00,0.00,0.00,'2021-12-03 13:40:12','',''),(2141133,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 13:40:12','',''),(2141170,'1','138','765',323,'Retail Sale Id 1269645',16000.00,0.00,0.00,0.00,0.00,'2021-12-03 13:42:12','',''),(2141171,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 13:42:12','',''),(2141226,'1','138','765',323,'Retail Sale Id 1269665',11200.00,0.00,0.00,0.00,0.00,'2021-12-03 13:44:45','',''),(2141227,'1','138','765',323,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-03 13:44:45','',''),(2141758,'1','138','765',323,'Retail Sale Id 1269869',34800.00,0.00,0.00,0.00,-2320.00,'2021-12-03 14:11:23','',''),(2141759,'1','138','765',323,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-03 14:11:23','',''),(2141854,'1','138','765',323,'Retail Sale Id 1269912',8000.00,0.00,0.00,0.00,0.00,'2021-12-03 14:18:28','',''),(2141855,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:18:28','',''),(2141890,'1','138','765',323,'Retail Sale Id 1269924',33000.00,0.00,0.00,0.00,-2200.00,'2021-12-03 14:20:12','',''),(2141891,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-03 14:20:12','',''),(2141971,'1','138','765',323,'Retail Sale Id 1269948',8000.00,0.00,0.00,0.00,0.00,'2021-12-03 14:24:14','',''),(2141972,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:24:14','',''),(2142242,'1','138','765',323,'Retail Sale Id 1270050',3302.40,0.00,0.00,0.00,0.00,'2021-12-03 14:39:22','',''),(2142243,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.16,0.00,'2021-12-03 14:39:22','',''),(2142267,'1','138','765',323,'Retail Sale Id 1270062',1920.00,0.00,0.00,0.00,0.00,'2021-12-03 14:40:42','',''),(2142268,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:40:42','',''),(2142323,'1','138','765',323,'Retail Sale Id 1270083',33600.00,0.00,0.00,0.00,0.00,'2021-12-03 14:42:57','',''),(2142324,'1','138','765',323,'Retail sales',0.00,0.00,0.00,52.50,0.00,'2021-12-03 14:42:57','',''),(2142728,'1','138','765',323,'Retail Sale Id 1270272',3840.00,0.00,0.00,0.00,0.00,'2021-12-03 15:01:33','',''),(2142729,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:01:33','',''),(2142952,'1','138','765',323,'Retail Sale Id 1270385',8000.00,0.00,0.00,0.00,0.00,'2021-12-03 15:14:14','',''),(2142953,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:14:14','',''),(2143119,'1','138','765',323,'Retail Sale Id 1270487',8000.00,0.00,0.00,0.00,0.00,'2021-12-03 15:22:22','',''),(2143120,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:22:22','',''),(2143436,'1','138','765',323,'Retail Sale Id 1270639',3859.20,0.00,0.00,0.00,0.00,'2021-12-03 15:37:19','',''),(2143437,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.03,0.00,'2021-12-03 15:37:19','',''),(2143482,'1','138','765',323,'Retail Sale Id 1270658',33000.00,0.00,0.00,0.00,-2200.00,'2021-12-03 15:38:58','',''),(2143483,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-03 15:38:58','',''),(2143534,'1','138','765',323,'Retail Sale Id 1270692',30000.00,0.00,0.00,0.00,-2000.00,'2021-12-03 15:41:17','',''),(2143535,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 15:41:17','',''),(2143562,'1','138','765',323,'Retail Sale Id 1270704',8000.00,0.00,0.00,0.00,0.00,'2021-12-03 15:42:25','',''),(2143563,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:42:25','',''),(2143707,'1','138','765',323,'Retail Sale Id 1270762',1497.60,0.00,0.00,0.00,0.00,'2021-12-03 15:47:49','',''),(2143708,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 15:47:49','',''),(2143889,'1','138','765',323,'Retail Sale Id 1270867',3200.00,0.00,0.00,0.00,0.00,'2021-12-03 15:56:47','',''),(2143890,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 15:56:47','',''),(2143938,'1','138','765',323,'Retail Sale Id 1270890',3852.80,0.00,0.00,0.00,0.00,'2021-12-03 15:58:40','',''),(2143939,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 15:58:40','',''),(2144035,'1','138','765',323,'Retail Sale Id 1270936',6502.40,0.00,0.00,0.00,0.00,'2021-12-03 16:03:00','',''),(2144036,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-03 16:03:00','',''),(2144063,'1','138','765',323,'Retail Sale Id 1270951',1952.00,0.00,0.00,0.00,0.00,'2021-12-03 16:04:15','',''),(2144064,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:04:15','',''),(2144384,'1','138','765',323,'Retail Sale Id 1271114',789700.00,0.00,0.00,0.00,-58300.00,'2021-12-03 16:19:48','',''),(2144385,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1325.00,0.00,'2021-12-03 16:19:48','',''),(2144797,'1','138','765',323,'Retail Sale Id 1271326',3840.00,0.00,0.00,0.00,0.00,'2021-12-03 16:41:03','',''),(2144798,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 16:41:03','',''),(2144951,'1','138','765',323,'Retail Sale Id 1271399',4000.00,0.00,0.00,0.00,0.00,'2021-12-03 16:49:19','',''),(2144952,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 16:49:19','',''),(2145393,'1','138','765',323,'Retail Sale Id 1271592',30000.00,0.00,0.00,0.00,-2000.00,'2021-12-03 17:14:44','',''),(2145394,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 17:14:44','',''),(2145401,'1','138','765',323,'Retail Sale Id 1271597',8000.00,0.00,0.00,0.00,0.00,'2021-12-03 17:16:05','',''),(2145402,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 17:16:05','',''),(2145569,'1','138','765',323,'Retail Sale Id 1271682',91590.00,0.00,0.00,0.00,-6106.00,'2021-12-03 17:39:19','',''),(2145570,'1','138','765',323,'Retail sales',0.00,0.00,0.00,152.65,0.00,'2021-12-03 17:39:19','',''),(2145609,'1','138','765',323,'Retail Sale Id 1271713',97500.00,0.00,0.00,0.00,-6500.00,'2021-12-03 17:43:47','',''),(2145610,'1','138','765',323,'Retail sales',0.00,0.00,0.00,162.50,0.00,'2021-12-03 17:43:47','',''),(2145731,'1','138','765',323,'Retail Sale Id 1271757',4000.00,0.00,0.00,0.00,0.00,'2021-12-03 18:00:34','',''),(2145732,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 18:00:34','',''),(2145897,'1','138','765',323,'Retail Sale Id 1271812',3001.60,0.00,0.00,0.00,0.00,'2021-12-03 18:18:59','',''),(2145898,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 18:18:59','',''),(2146642,'1','138','765',323,'Retail Sale Id 1271999',3200.00,0.00,0.00,0.00,0.00,'2021-12-04 06:09:30','',''),(2146643,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 06:09:30','',''),(2146746,'1','138','765',323,'Retail Sale Id 1272029',8000.00,0.00,0.00,0.00,0.00,'2021-12-04 06:17:07','',''),(2146747,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:17:07','',''),(2146797,'1','138','765',323,'Retail Sale Id 1272047',28002.00,0.00,0.00,0.00,-1866.80,'2021-12-04 06:21:11','',''),(2146798,'1','138','765',323,'Retail sales',0.00,0.00,0.00,46.67,0.00,'2021-12-04 06:21:11','',''),(2147174,'1','138','765',323,'Retail Sale Id 1272199',8000.00,0.00,0.00,0.00,0.00,'2021-12-04 06:39:51','',''),(2147175,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:39:51','',''),(2147406,'1','138','765',323,'Retail Sale Id 1272298',68400.00,0.00,0.00,0.00,-4560.00,'2021-12-04 06:52:38','',''),(2147407,'1','138','765',323,'Retail sales',0.00,0.00,0.00,114.00,0.00,'2021-12-04 06:52:38','',''),(2147487,'1','138','765',323,'Retail Sale Id 1272333',30000.00,0.00,0.00,0.00,-2000.00,'2021-12-04 06:56:07','',''),(2147488,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 06:56:07','',''),(2148266,'1','138','765',323,'Distributed to OPERATIONAL LOSS for sales id:337102',179961.60,0.00,0.00,281.19,0.00,'2021-12-04 07:36:32','',''),(2148377,'1','138',NULL,323,'Purchased from AA RANO NIGERIA LIMITED',0.00,14817760.00,25030.00,0.00,0.00,'2021-12-04 07:41:34','',''),(2148412,'1','138',NULL,323,'Reception corrector for bridging 126156',0.00,0.00,0.00,25030.00,0.00,'2021-12-04 07:43:29','',''),(2148413,'1','138','765',323,'Received from bridging 126156',0.00,0.00,25030.00,0.00,0.00,'2021-12-04 07:43:29','',''),(2148735,'1','138','765',323,'Retail Sale Id 1273060',3840.00,0.00,0.00,0.00,288.00,'2021-12-04 08:01:36','',''),(2148736,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:01:36','',''),(2148761,'1','138','765',323,'Retail Sale Id 1273074',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 08:03:01','',''),(2148762,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:03:01','',''),(2148811,'1','138','765',323,'Retail Sale Id 1273097',90000.00,0.00,0.00,0.00,1200.00,'2021-12-04 08:05:08','',''),(2148812,'1','138','765',323,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-04 08:05:08','',''),(2148908,'1','138','765',323,'Retail Sale Id 1273162',60000.00,0.00,0.00,0.00,800.00,'2021-12-04 08:09:20','',''),(2148909,'1','138','765',323,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-04 08:09:20','',''),(2148962,'1','138','765',323,'Retail Sale Id 1273193',4998.40,0.00,0.00,0.00,374.88,'2021-12-04 08:11:56','',''),(2148963,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 08:11:56','',''),(2148992,'1','138','765',323,'Retail Sale Id 1273205',120000.00,0.00,0.00,0.00,1600.00,'2021-12-04 08:13:06','',''),(2148993,'1','138','765',323,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-04 08:13:06','',''),(2149047,'1','138','765',323,'Retail Sale Id 1273228',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 08:14:50','',''),(2149048,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 08:14:50','',''),(2149424,'1','138','765',323,'Retail Sale Id 1273486',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 08:30:47','',''),(2149425,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:30:47','',''),(2149487,'1','138','765',323,'Retail Sale Id 1273524',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 08:31:59','',''),(2149488,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:31:59','',''),(2149604,'1','138','765',323,'Retail Sale Id 1273583',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 08:37:07','',''),(2149605,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:37:07','',''),(2149976,'1','138','765',323,'Retail Sale Id 1273762',61800.00,0.00,0.00,0.00,824.00,'2021-12-04 08:53:03','',''),(2149977,'1','138','765',323,'Retail sales',0.00,0.00,0.00,103.00,0.00,'2021-12-04 08:53:03','',''),(2150057,'1','138','765',323,'Retail Sale Id 1273816',3852.80,0.00,0.00,0.00,288.96,'2021-12-04 08:56:35','',''),(2150058,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 08:56:35','',''),(2150339,'1','138','765',323,'Retail Sale Id 1273968',3852.80,0.00,0.00,0.00,288.96,'2021-12-04 09:10:30','',''),(2150340,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 09:10:30','',''),(2150381,'1','138','765',323,'Retail Sale Id 1273989',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 09:12:37','',''),(2150382,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:12:37','',''),(2150411,'1','138','765',323,'Retail Sale Id 1274001',6502.40,0.00,0.00,0.00,487.68,'2021-12-04 09:14:19','',''),(2150412,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-04 09:14:19','',''),(2150505,'1','138','765',323,'Retail Sale Id 1274054',26003.20,0.00,0.00,0.00,1950.24,'2021-12-04 09:18:49','',''),(2150506,'1','138','765',323,'Retail sales',0.00,0.00,0.00,40.63,0.00,'2021-12-04 09:18:49','',''),(2150645,'1','138','765',323,'Retail Sale Id 1274127',2502.40,0.00,0.00,0.00,187.68,'2021-12-04 09:25:03','',''),(2150646,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 09:25:03','',''),(2150669,'1','138','765',323,'Retail Sale Id 1274138',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 09:26:21','',''),(2150670,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:26:21','',''),(2150746,'1','138','765',323,'Retail Sale Id 1274177',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 09:30:17','',''),(2150747,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:30:17','',''),(2150784,'1','138','765',323,'Retail Sale Id 1274203',5400.00,0.00,0.00,0.00,72.00,'2021-12-04 09:32:19','',''),(2150785,'1','138','765',323,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-04 09:32:19','',''),(2152557,'1','138','765',323,'Retail Sale Id 1274240',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 10:42:24','',''),(2152558,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 10:42:24','',''),(2152592,'1','138','765',323,'Retail Sale Id 1274438',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 10:43:21','',''),(2152593,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 10:43:21','',''),(2152904,'1','138','765',323,'Retail Sale Id 1274570',2502.40,0.00,0.00,0.00,187.68,'2021-12-04 11:01:07','',''),(2152905,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 11:01:07','',''),(2153034,'1','138','765',323,'Retail Sale Id 1274635',11200.00,0.00,0.00,0.00,840.00,'2021-12-04 11:07:58','',''),(2153035,'1','138','765',323,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-04 11:07:58','',''),(2153368,'1','138','765',323,'Retail Sale Id 1274802',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 11:24:26','',''),(2153369,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:24:26','',''),(2153670,'1','138','765',323,'Retail Sale Id 1274948',3852.80,0.00,0.00,0.00,288.96,'2021-12-04 11:39:32','',''),(2153671,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 11:39:32','',''),(2153685,'1','138','765',323,'Retail Sale Id 1274956',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 11:40:37','',''),(2153686,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 11:40:37','',''),(2153980,'1','138','765',323,'Retail Sale Id 1275078',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 11:58:04','',''),(2153981,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 11:58:04','',''),(2154012,'1','138','765',323,'Retail Sale Id 1275085',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 11:59:26','',''),(2154013,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:59:26','',''),(2154262,'1','138','765',323,'Retail Sale Id 1275162',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 12:09:33','',''),(2154263,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 12:09:33','',''),(2154555,'1','138','765',323,'Retail Sale Id 1275310',6400.00,0.00,0.00,0.00,480.00,'2021-12-04 12:28:22','',''),(2154556,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 12:28:22','',''),(2154589,'1','138','765',323,'Retail Sale Id 1275327',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 12:30:11','',''),(2154590,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 12:30:11','',''),(2154976,'1','138','765',323,'Retail Sale Id 1275510',2560.00,0.00,0.00,0.00,192.00,'2021-12-04 12:55:34','',''),(2154977,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 12:55:34','',''),(2155202,'1','138','765',323,'Retail Sale Id 1275829',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 13:16:02','',''),(2155203,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 13:16:02','',''),(2155457,'1','138','765',323,'Retail Sale Id 1275914',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 13:28:27','',''),(2155458,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:28:27','',''),(2155510,'1','138','765',323,'Retail Sale Id 1275941',725928.00,0.00,0.00,0.00,4872.00,'2021-12-04 13:31:18','',''),(2155511,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1218.00,0.00,'2021-12-04 13:31:18','',''),(2155527,'1','138','765',323,'Retail Sale Id 1275951',39000.00,0.00,0.00,0.00,520.00,'2021-12-04 13:32:25','',''),(2155528,'1','138','765',323,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-04 13:32:25','',''),(2155553,'1','138','765',323,'Retail Sale Id 1275965',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 13:34:11','',''),(2155554,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 13:34:11','',''),(2155670,'1','138','765',323,'Retail Sale Id 1276018',1800.00,0.00,0.00,0.00,24.00,'2021-12-04 13:40:49','',''),(2155671,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 13:40:49','',''),(2155830,'1','138','765',323,'Retail Sale Id 1276095',10500.00,0.00,0.00,0.00,140.00,'2021-12-04 13:48:46','',''),(2155831,'1','138','765',323,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-04 13:48:46','',''),(2155876,'1','138','765',323,'Retail Sale Id 1276106',2880.00,0.00,0.00,0.00,216.00,'2021-12-04 13:49:53','',''),(2155877,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-04 13:49:53','',''),(2155912,'1','138','765',323,'Retail Sale Id 1276125',3123.20,0.00,0.00,0.00,234.24,'2021-12-04 13:52:28','',''),(2155913,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.88,0.00,'2021-12-04 13:52:28','',''),(2156064,'1','138','765',323,'Retail Sale Id 1276194',42000.00,0.00,0.00,0.00,560.00,'2021-12-04 14:00:07','',''),(2156065,'1','138','765',323,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-04 14:00:07','',''),(2156160,'1','138','765',323,'Retail Sale Id 1276233',285000.00,0.00,0.00,0.00,3800.00,'2021-12-04 14:03:49','',''),(2156161,'1','138','765',323,'Retail sales',0.00,0.00,0.00,475.00,0.00,'2021-12-04 14:03:49','',''),(2156208,'1','138','765',323,'Retail Sale Id 1276247',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 14:05:03','',''),(2156209,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:05:03','',''),(2156241,'1','138','765',323,'Retail Sale Id 1276263',3840.00,0.00,0.00,0.00,288.00,'2021-12-04 14:06:22','',''),(2156242,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:06:22','',''),(2156379,'1','138','765',323,'Retail Sale Id 1276338',63000.00,0.00,0.00,0.00,840.00,'2021-12-04 14:13:27','',''),(2156380,'1','138','765',323,'Retail sales',0.00,0.00,0.00,105.00,0.00,'2021-12-04 14:13:27','',''),(2156462,'1','138','765',323,'Retail Sale Id 1276374',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 14:16:38','',''),(2156463,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:16:38','',''),(2156576,'1','138','765',323,'Retail Sale Id 1276438',240000.00,0.00,0.00,0.00,3200.00,'2021-12-04 14:22:17','',''),(2156577,'1','138','765',323,'Retail sales',0.00,0.00,0.00,400.00,0.00,'2021-12-04 14:22:17','',''),(2156798,'1','138','765',323,'Retail Sale Id 1276540',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 14:35:12','',''),(2156799,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 14:35:12','',''),(2156828,'1','138','765',323,'Retail Sale Id 1276555',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 14:36:54','',''),(2156829,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:36:54','',''),(2157102,'1','138','765',323,'Retail Sale Id 1276649',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 14:49:28','',''),(2157103,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:49:28','',''),(2157104,'1','138','765',323,'Retail Sale Id 1276649',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 14:49:28','',''),(2157105,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:49:28','',''),(2157136,'1','138','765',323,'Retail Sale Id 1276666',2547.20,0.00,0.00,0.00,191.04,'2021-12-04 14:51:40','',''),(2157137,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.98,0.00,'2021-12-04 14:51:40','',''),(2157238,'1','138','765',323,'Retail Sale Id 1276702',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 14:56:15','',''),(2157239,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:56:15','',''),(2157560,'1','138','765',323,'Retail Sale Id 1276849',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 15:14:14','',''),(2157561,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:14:14','',''),(2157612,'1','138','765',323,'Retail Sale Id 1276874',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 15:17:22','',''),(2157613,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 15:17:22','',''),(2157660,'1','138','765',323,'Retail Sale Id 1276892',3500.80,0.00,0.00,0.00,262.56,'2021-12-04 15:19:10','',''),(2157661,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-04 15:19:10','',''),(2157684,'1','138','765',323,'Retail Sale Id 1276904',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 15:19:54','',''),(2157685,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:19:54','',''),(2157766,'1','138','765',323,'Retail Sale Id 1276936',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 15:24:13','',''),(2157767,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:24:13','',''),(2157816,'1','138','765',323,'Retail Sale Id 1276953',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 15:25:52','',''),(2157817,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:25:52','',''),(2157832,'1','138','765',323,'Retail Sale Id 1276958',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 15:26:34','',''),(2157833,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 15:26:34','',''),(2157939,'1','138','765',323,'Retail Sale Id 1277013',33000.00,0.00,0.00,0.00,440.00,'2021-12-04 15:31:17','',''),(2157940,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-04 15:31:17','',''),(2158056,'1','138','765',323,'Retail Sale Id 1277068',3840.00,0.00,0.00,0.00,288.00,'2021-12-04 15:36:22','',''),(2158057,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:36:22','',''),(2158526,'1','138','765',323,'Retail Sale Id 1277307',78000.00,0.00,0.00,0.00,1040.00,'2021-12-04 15:59:32','',''),(2158527,'1','138','765',323,'Retail sales',0.00,0.00,0.00,130.00,0.00,'2021-12-04 15:59:32','',''),(2158543,'1','138','765',323,'Retail Sale Id 1277319',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:00:05','',''),(2158544,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:00:05','',''),(2158698,'1','138','765',323,'Retail Sale Id 1277397',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:07:57','',''),(2158699,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:07:57','',''),(2158728,'1','138','765',323,'Retail Sale Id 1277410',3840.00,0.00,0.00,0.00,288.00,'2021-12-04 16:09:20','',''),(2158729,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:09:20','',''),(2158755,'1','138','765',323,'Retail Sale Id 1277424',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:10:39','',''),(2158756,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:10:39','',''),(2158821,'1','138','765',323,'Retail Sale Id 1277463',44502.00,0.00,0.00,0.00,593.36,'2021-12-04 16:13:51','',''),(2158822,'1','138','765',323,'Retail sales',0.00,0.00,0.00,74.17,0.00,'2021-12-04 16:13:51','',''),(2158873,'1','138','765',323,'Retail Sale Id 1277490',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 16:15:41','',''),(2158874,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:15:41','',''),(2158997,'1','138','765',323,'Retail Sale Id 1277548',3840.00,0.00,0.00,0.00,288.00,'2021-12-04 16:21:50','',''),(2158998,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:21:50','',''),(2159045,'1','138','765',323,'Retail Sale Id 1277580',159000.00,0.00,0.00,0.00,2120.00,'2021-12-04 16:23:49','',''),(2159046,'1','138','765',323,'Retail sales',0.00,0.00,0.00,265.00,0.00,'2021-12-04 16:23:49','',''),(2159199,'1','138','765',323,'Retail Sale Id 1277661',60000.00,0.00,0.00,0.00,800.00,'2021-12-04 16:30:15','',''),(2159200,'1','138','765',323,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-04 16:30:15','',''),(2159301,'1','138','765',323,'Retail Sale Id 1277711',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:36:12','',''),(2159302,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:36:12','',''),(2159325,'1','138','765',323,'Retail Sale Id 1277723',12000.00,0.00,0.00,0.00,900.00,'2021-12-04 16:37:26','',''),(2159326,'1','138','765',323,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-04 16:37:26','',''),(2159521,'1','138','765',323,'Retail Sale Id 1277842',9600.00,0.00,0.00,0.00,720.00,'2021-12-04 16:45:17','',''),(2159522,'1','138','765',323,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-04 16:45:17','',''),(2159558,'1','138','765',323,'Retail Sale Id 1277858',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:47:00','',''),(2159559,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:47:00','',''),(2159570,'1','138','765',323,'Retail Sale Id 1277866',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:47:49','',''),(2159571,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:47:49','',''),(2159787,'1','138','765',323,'Retail Sale Id 1277969',30000.00,0.00,0.00,0.00,400.00,'2021-12-04 16:59:16','',''),(2159788,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 16:59:16','',''),(2159948,'1','138','765',323,'Retail Sale Id 1278045',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 17:08:31','',''),(2159949,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 17:08:31','',''),(2159995,'1','138','765',323,'Retail Sale Id 1278069',3840.00,0.00,0.00,0.00,288.00,'2021-12-04 17:11:20','',''),(2159996,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 17:11:20','',''),(2160045,'1','138','765',323,'Retail Sale Id 1278094',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 17:15:14','',''),(2160046,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 17:15:14','',''),(2160079,'1','138','765',323,'Retail Sale Id 1278109',34200.00,0.00,0.00,0.00,456.00,'2021-12-04 17:17:28','',''),(2160080,'1','138','765',323,'Retail sales',0.00,0.00,0.00,57.00,0.00,'2021-12-04 17:17:28','',''),(2160097,'1','138','765',323,'Retail Sale Id 1278120',34800.00,0.00,0.00,0.00,464.00,'2021-12-04 17:18:25','',''),(2160098,'1','138','765',323,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-04 17:18:25','',''),(2160149,'1','138','765',323,'Retail Sale Id 1278147',998.40,0.00,0.00,0.00,74.88,'2021-12-04 17:21:43','',''),(2160150,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 17:21:43','',''),(2160313,'1','138','765',323,'Retail Sale Id 1278206',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 17:29:54','',''),(2160314,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 17:29:54','',''),(2160571,'1','138','765',323,'Retail Sale Id 1278293',7001.60,0.00,0.00,0.00,525.12,'2021-12-04 17:44:09','',''),(2160572,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-04 17:44:09','',''),(2160819,'1','138','765',323,'Retail Sale Id 1278398',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 18:05:09','',''),(2160820,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 18:05:09','',''),(2160833,'1','138','765',323,'Retail Sale Id 1278406',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 18:06:24','',''),(2160834,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 18:06:24','',''),(2160888,'1','138','765',323,'Return of Retail Sale Id 1278398',0.00,8000.00,12.50,0.00,-600.00,'2021-12-04 18:13:58','',''),(2160903,'1','138','765',323,'Retail Sale Id 1278438',6400.00,0.00,0.00,0.00,480.00,'2021-12-04 18:15:46','',''),(2160904,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 18:15:46','',''),(2162117,'1','138','765',323,'Retail Sale Id 1278696',34500.00,0.00,0.00,0.00,460.00,'2021-12-05 06:20:09','',''),(2162118,'1','138','765',323,'Retail sales',0.00,0.00,0.00,57.50,0.00,'2021-12-05 06:20:09','',''),(2162599,'1','138','765',323,'Retail Sale Id 1278911',54000.00,0.00,0.00,0.00,720.00,'2021-12-05 06:53:25','',''),(2162600,'1','138','765',323,'Retail sales',0.00,0.00,0.00,90.00,0.00,'2021-12-05 06:53:25','',''),(2162738,'1','138','765',323,'Retail Sale Id 1278986',34200.00,0.00,0.00,0.00,456.00,'2021-12-05 07:01:57','',''),(2162739,'1','138','765',323,'Retail sales',0.00,0.00,0.00,57.00,0.00,'2021-12-05 07:01:57','',''),(2162770,'1','138','765',323,'Retail Sale Id 1279007',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 07:03:42','',''),(2162771,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:03:42','',''),(2162861,'1','138','765',323,'Retail Sale Id 1279047',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 07:08:37','',''),(2162862,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 07:08:37','',''),(2163128,'1','138','765',323,'Retail Sale Id 1279218',36000.00,0.00,0.00,0.00,480.00,'2021-12-05 07:24:38','',''),(2163129,'1','138','765',323,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-05 07:24:38','',''),(2163193,'1','138','765',323,'Retail Sale Id 1279260',36000.00,0.00,0.00,0.00,480.00,'2021-12-05 07:27:31','',''),(2163194,'1','138','765',323,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-05 07:27:31','',''),(2163487,'1','138','765',323,'Retail Sale Id 1279430',36000.00,0.00,0.00,0.00,480.00,'2021-12-05 07:44:56','',''),(2163488,'1','138','765',323,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-05 07:44:56','',''),(2163497,'1','138','765',323,'Retail Sale Id 1279435',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 07:45:36','',''),(2163498,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 07:45:36','',''),(2163699,'1','138','765',323,'Retail Sale Id 1279533',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 07:56:31','',''),(2163700,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:56:31','',''),(2163730,'1','138','765',323,'Retail Sale Id 1279545',1920.00,0.00,0.00,0.00,144.00,'2021-12-05 07:58:24','',''),(2163731,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 07:58:24','',''),(2163820,'1','138','765',323,'Retail Sale Id 1279601',18000.00,0.00,0.00,0.00,240.00,'2021-12-05 08:03:17','',''),(2163821,'1','138','765',323,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-05 08:03:17','',''),(2163910,'1','138','765',323,'Retail Sale Id 1279658',24498.00,0.00,0.00,0.00,326.64,'2021-12-05 08:07:58','',''),(2163911,'1','138','765',323,'Retail sales',0.00,0.00,0.00,40.83,0.00,'2021-12-05 08:07:58','',''),(2164150,'1','138','765',323,'Retail Sale Id 1279790',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 08:20:04','',''),(2164151,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:20:04','',''),(2164392,'1','138','765',323,'Retail Sale Id 1279922',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 08:31:00','',''),(2164393,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:31:00','',''),(2164412,'1','138','765',323,'Retail Sale Id 1279927',3840.00,0.00,0.00,0.00,288.00,'2021-12-05 08:31:51','',''),(2164413,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 08:31:51','',''),(2164502,'1','138','765',323,'Retail Sale Id 1279980',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 08:36:19','',''),(2164503,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:36:19','',''),(2164721,'1','138','765',323,'Retail Sale Id 1280073',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 08:48:14','',''),(2164722,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 08:48:14','',''),(2164771,'1','138','765',323,'Retail Sale Id 1280099',33000.00,0.00,0.00,0.00,440.00,'2021-12-05 08:50:54','',''),(2164772,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-05 08:50:54','',''),(2164797,'1','138','765',323,'Retail Sale Id 1280115',30000.00,0.00,0.00,0.00,400.00,'2021-12-05 08:52:37','',''),(2164798,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 08:52:37','',''),(2165073,'1','138','765',323,'Retail Sale Id 1280266',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 09:07:42','',''),(2165074,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 09:07:42','',''),(2165146,'1','138','765',323,'Retail Sale Id 1280307',4480.00,0.00,0.00,0.00,336.00,'2021-12-05 09:10:44','',''),(2165147,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-05 09:10:44','',''),(2165148,'1','138','765',323,'Retail Sale Id 1280307',12800.00,0.00,0.00,0.00,960.00,'2021-12-05 09:10:44','',''),(2165149,'1','138','765',323,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-05 09:10:44','',''),(2165244,'1','138','765',323,'Retail Sale Id 1280388',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 09:17:13','',''),(2165245,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:17:13','',''),(2165268,'1','138','765',323,'Retail Sale Id 1280397',5120.00,0.00,0.00,0.00,384.00,'2021-12-05 09:18:24','',''),(2165269,'1','138','765',323,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 09:18:24','',''),(2165333,'1','138','765',323,'Retail Sale Id 1280434',165000.00,0.00,0.00,0.00,2200.00,'2021-12-05 09:22:03','',''),(2165334,'1','138','765',323,'Retail sales',0.00,0.00,0.00,275.00,0.00,'2021-12-05 09:22:03','',''),(2165380,'1','138','765',323,'Retail Sale Id 1280459',2560.00,0.00,0.00,0.00,192.00,'2021-12-05 09:25:03','',''),(2165381,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 09:25:03','',''),(2165408,'1','138','765',323,'Retail Sale Id 1280476',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 09:26:29','',''),(2165409,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 09:26:29','',''),(2165542,'1','138','765',323,'Retail Sale Id 1280556',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 09:33:06','',''),(2165543,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 09:33:06','',''),(2166140,'1','138','765',323,'Retail Sale Id 1280832',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 10:02:00','',''),(2166141,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 10:02:00','',''),(2166159,'1','138','765',323,'Retail Sale Id 1280840',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 10:03:13','',''),(2166160,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 10:03:13','',''),(2166245,'1','138','765',323,'Retail Sale Id 1280885',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 10:09:17','',''),(2166246,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:09:17','',''),(2166275,'1','138','765',323,'Retail Sale Id 1280897',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 10:11:12','',''),(2166276,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 10:11:12','',''),(2166305,'1','138','765',323,'Retail Sale Id 1280915',102000.00,0.00,0.00,0.00,1360.00,'2021-12-05 10:13:31','',''),(2166306,'1','138','765',323,'Retail sales',0.00,0.00,0.00,170.00,0.00,'2021-12-05 10:13:31','',''),(2166321,'1','138','765',323,'Retail Sale Id 1280922',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 10:14:32','',''),(2166322,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:14:32','',''),(2166347,'1','138','765',323,'Retail Sale Id 1280938',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 10:15:59','',''),(2166348,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 10:15:59','',''),(2166678,'1','138','765',323,'Retail Sale Id 1281108',150000.00,0.00,0.00,0.00,2000.00,'2021-12-05 10:36:44','',''),(2166679,'1','138','765',323,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-05 10:36:44','',''),(2166752,'1','138','765',323,'Retail Sale Id 1281146',3840.00,0.00,0.00,0.00,288.00,'2021-12-05 10:41:12','',''),(2166753,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:41:12','',''),(2166945,'1','138','765',323,'Retail Sale Id 1281248',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 10:50:50','',''),(2166946,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:50:50','',''),(2167094,'1','138','765',323,'Retail Sale Id 1281320',33000.00,0.00,0.00,0.00,440.00,'2021-12-05 10:59:32','',''),(2167095,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-05 10:59:32','',''),(2167132,'1','138','765',323,'Retail Sale Id 1281340',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 11:01:49','',''),(2167133,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 11:01:49','',''),(2167134,'1','138','765',323,'Retail Sale Id 1281340',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 11:01:49','',''),(2167135,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 11:01:49','',''),(2167220,'1','138','765',323,'Retail Sale Id 1281396',34002.00,0.00,0.00,0.00,453.36,'2021-12-05 11:07:52','',''),(2167221,'1','138','765',323,'Retail sales',0.00,0.00,0.00,56.67,0.00,'2021-12-05 11:07:52','',''),(2167250,'1','138','765',323,'Retail Sale Id 1281417',33000.00,0.00,0.00,0.00,440.00,'2021-12-05 11:09:11','',''),(2167251,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-05 11:09:11','',''),(2167268,'1','138','765',323,'Retail Sale Id 1281427',13800.00,0.00,0.00,0.00,184.00,'2021-12-05 11:10:13','',''),(2167269,'1','138','765',323,'Retail sales',0.00,0.00,0.00,23.00,0.00,'2021-12-05 11:10:13','',''),(2167502,'1','138','765',323,'Retail Sale Id 1281533',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 11:24:35','',''),(2167503,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:24:35','',''),(2167544,'1','138','765',323,'Retail Sale Id 1281558',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 11:27:14','',''),(2167545,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:27:14','',''),(2167575,'1','138','765',323,'Retail Sale Id 1281573',1920.00,0.00,0.00,0.00,144.00,'2021-12-05 11:28:47','',''),(2167576,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 11:28:47','',''),(2167788,'1','138','765',323,'Retail Sale Id 1281677',1280.00,0.00,0.00,0.00,96.00,'2021-12-05 11:40:01','',''),(2167789,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 11:40:01','',''),(2167840,'1','138','765',323,'Retail Sale Id 1281743',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 11:44:14','',''),(2167841,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 11:44:14','',''),(2168005,'1','138','765',323,'Retail Sale Id 1281838',9600.00,0.00,0.00,0.00,720.00,'2021-12-05 11:53:01','',''),(2168006,'1','138','765',323,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-05 11:53:01','',''),(2168081,'1','138','765',323,'Retail Sale Id 1281878',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 11:57:34','',''),(2168082,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:57:34','',''),(2168102,'1','138','765',323,'Retail Sale Id 1281889',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 11:59:14','',''),(2168103,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:59:14','',''),(2168297,'1','138','765',323,'Retail Sale Id 1281992',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 12:09:22','',''),(2168298,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:09:22','',''),(2168440,'1','138','765',323,'Retail Sale Id 1282054',2560.00,0.00,0.00,0.00,192.00,'2021-12-05 12:15:31','',''),(2168441,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 12:15:31','',''),(2168456,'1','138','765',323,'Retail Sale Id 1282063',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 12:16:16','',''),(2168457,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 12:16:16','',''),(2168498,'1','138','765',323,'Retail Sale Id 1282083',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 12:18:01','',''),(2168499,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 12:18:01','',''),(2168532,'1','138','765',323,'Retail Sale Id 1282101',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 12:19:19','',''),(2168533,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 12:19:19','',''),(2168558,'1','138','765',323,'Retail Sale Id 1282116',998.40,0.00,0.00,0.00,74.88,'2021-12-05 12:20:35','',''),(2168559,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 12:20:35','',''),(2168615,'1','138','765',323,'Retail Sale Id 1282143',42000.00,0.00,0.00,0.00,560.00,'2021-12-05 12:22:57','',''),(2168616,'1','138','765',323,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-05 12:22:57','',''),(2168728,'1','138','765',323,'Retail Sale Id 1282195',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 12:27:02','',''),(2168729,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:27:02','',''),(2169055,'1','138','765',323,'Retail Sale Id 1282373',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 12:44:05','',''),(2169056,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:44:05','',''),(2169077,'1','138','765',323,'Retail Sale Id 1282384',3500.80,0.00,0.00,0.00,262.56,'2021-12-05 12:45:20','',''),(2169078,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-05 12:45:20','',''),(2169097,'1','138','765',323,'Retail Sale Id 1282398',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 12:46:50','',''),(2169098,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:46:50','',''),(2169113,'1','138','765',323,'Retail Sale Id 1282415',5760.00,0.00,0.00,0.00,432.00,'2021-12-05 12:48:01','',''),(2169114,'1','138','765',323,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-05 12:48:01','',''),(2169313,'1','138','765',323,'Retail Sale Id 1282522',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 12:59:44','',''),(2169314,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 12:59:44','',''),(2169425,'1','138','765',323,'Retail Sale Id 1282571',6003.20,0.00,0.00,0.00,450.24,'2021-12-05 13:04:33','',''),(2169426,'1','138','765',323,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-05 13:04:33','',''),(2169493,'1','138','765',323,'Retail Sale Id 1282631',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:08:19','',''),(2169494,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:08:19','',''),(2169566,'1','138','765',323,'Retail Sale Id 1282668',16800.00,0.00,0.00,0.00,224.00,'2021-12-05 13:12:42','',''),(2169567,'1','138','765',323,'Retail sales',0.00,0.00,0.00,28.00,0.00,'2021-12-05 13:12:42','',''),(2169676,'1','138','765',323,'Retail Sale Id 1282718',30000.00,0.00,0.00,0.00,400.00,'2021-12-05 13:19:19','',''),(2169677,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 13:19:19','',''),(2169750,'1','138','765',323,'Retail Sale Id 1282761',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:24:04','',''),(2169751,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:24:04','',''),(2169867,'1','138','765',323,'Retail Sale Id 1282817',16000.00,0.00,0.00,0.00,1200.00,'2021-12-05 13:30:35','',''),(2169868,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 13:30:35','',''),(2169897,'1','138','765',323,'Retail Sale Id 1282829',3801.60,0.00,0.00,0.00,285.12,'2021-12-05 13:31:57','',''),(2169898,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-05 13:31:57','',''),(2169921,'1','138','765',323,'Retail Sale Id 1282839',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:33:13','',''),(2169922,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:33:13','',''),(2170001,'1','138','765',323,'Retail Sale Id 1282875',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 13:36:51','',''),(2170002,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 13:36:51','',''),(2170039,'1','138','765',323,'Retail Sale Id 1282890',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:38:57','',''),(2170040,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:38:57','',''),(2170180,'1','138','765',323,'Retail Sale Id 1282933',3840.00,0.00,0.00,0.00,288.00,'2021-12-05 13:45:02','',''),(2170181,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 13:45:02','',''),(2170271,'1','138','765',323,'Retail Sale Id 1282980',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 13:51:07','',''),(2170272,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 13:51:07','',''),(2170386,'1','138','765',323,'Retail Sale Id 1283028',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 13:56:42','',''),(2170387,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 13:56:42','',''),(2170435,'1','138','765',323,'Retail Sale Id 1283039',11840.00,0.00,0.00,0.00,888.00,'2021-12-05 13:58:21','',''),(2170436,'1','138','765',323,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-05 13:58:21','',''),(2170593,'1','138','765',323,'Retail Sale Id 1283121',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 14:08:57','',''),(2170594,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 14:08:57','',''),(2170709,'1','138','765',323,'Retail Sale Id 1283166',15000.00,0.00,0.00,0.00,200.00,'2021-12-05 14:14:52','',''),(2170710,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 14:14:52','',''),(2171379,'1','138','765',323,'Retail Sale Id 1283417',3840.00,0.00,0.00,0.00,288.00,'2021-12-05 14:48:40','',''),(2171380,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 14:48:40','',''),(2171561,'1','138','765',323,'Retail Sale Id 1283507',40998.00,0.00,0.00,0.00,546.64,'2021-12-05 15:01:36','',''),(2171562,'1','138','765',323,'Retail sales',0.00,0.00,0.00,68.33,0.00,'2021-12-05 15:01:36','',''),(2171595,'1','138','765',323,'Retail Sale Id 1283524',66000.00,0.00,0.00,0.00,880.00,'2021-12-05 15:04:50','',''),(2171596,'1','138','765',323,'Retail sales',0.00,0.00,0.00,110.00,0.00,'2021-12-05 15:04:50','',''),(2171679,'1','138','765',323,'Retail Sale Id 1283567',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 15:11:31','',''),(2171680,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 15:11:31','',''),(2171754,'1','138','765',323,'Retail Sale Id 1283605',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 15:16:42','',''),(2171755,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 15:16:42','',''),(2172307,'1','138','765',323,'Retail Sale Id 1283881',90000.00,0.00,0.00,0.00,1200.00,'2021-12-05 15:46:59','',''),(2172308,'1','138','765',323,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-05 15:46:59','',''),(2172910,'1','138','765',323,'Retail Sale Id 1284201',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 16:23:50','',''),(2172911,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:23:50','',''),(2173037,'1','138','765',323,'Retail Sale Id 1284273',42000.00,0.00,0.00,0.00,560.00,'2021-12-05 16:32:28','',''),(2173038,'1','138','765',323,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-05 16:32:28','',''),(2173085,'1','138','765',323,'Retail Sale Id 1284293',36000.00,0.00,0.00,0.00,480.00,'2021-12-05 16:35:00','',''),(2173086,'1','138','765',323,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-05 16:35:00','',''),(2173149,'1','138','765',323,'Retail Sale Id 1284326',36000.00,0.00,0.00,0.00,480.00,'2021-12-05 16:38:18','',''),(2173150,'1','138','765',323,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-05 16:38:18','',''),(2173347,'1','138','765',323,'Retail Sale Id 1284429',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 16:50:13','',''),(2173348,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 16:50:13','',''),(2173373,'1','138','765',323,'Retail Sale Id 1284441',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 16:52:20','',''),(2173374,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 16:52:21','',''),(2173465,'1','138','765',323,'Retail Sale Id 1284490',1222396.00,0.00,0.00,0.00,8204.00,'2021-12-05 16:58:22','',''),(2173466,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2051.00,0.00,'2021-12-05 16:58:22','',''),(2173485,'1','138','765',323,'Retail Sale Id 1284502',11712.00,0.00,0.00,0.00,878.40,'2021-12-05 16:59:43','',''),(2173486,'1','138','765',323,'Retail sales',0.00,0.00,0.00,18.30,0.00,'2021-12-05 16:59:43','',''),(2173508,'1','138','765',323,'Retail Sale Id 1284513',12800.00,0.00,0.00,0.00,960.00,'2021-12-05 17:01:12','',''),(2173509,'1','138','765',323,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-05 17:01:12','',''),(2173529,'1','138','765',323,'Retail Sale Id 1284522',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 17:02:47','',''),(2173530,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:02:47','',''),(2173626,'1','138','765',323,'Retail Sale Id 1284562',5120.00,0.00,0.00,0.00,384.00,'2021-12-05 17:08:28','',''),(2173627,'1','138','765',323,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 17:08:28','',''),(2173637,'1','138','765',323,'Return of Retail Sale Id 1284293',0.00,36000.00,60.00,0.00,-480.00,'2021-12-05 17:09:32','',''),(2173698,'1','138','765',323,'Retail Sale Id 1284592',15000.00,0.00,0.00,0.00,200.00,'2021-12-05 17:14:22','',''),(2173699,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 17:14:22','',''),(2173762,'1','138','765',323,'Retail Sale Id 1284624',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 17:20:17','',''),(2173763,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:20:17','',''),(2173858,'1','138','765',323,'Retail Sale Id 1284674',3840.00,0.00,0.00,0.00,288.00,'2021-12-05 17:28:19','',''),(2173859,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 17:28:19','',''),(2173928,'1','138','765',323,'Retail Sale Id 1284705',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 17:33:28','',''),(2173929,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:33:28','',''),(2173968,'1','138','765',323,'Retail Sale Id 1284723',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 17:36:33','',''),(2173969,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 17:36:33','',''),(2174072,'1','138','765',323,'Retail Sale Id 1284785',6400.00,0.00,0.00,0.00,480.00,'2021-12-05 17:54:05','',''),(2174073,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 17:54:05','',''),(2174833,'1','138','765',323,'Retail Sale Id 1284922',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 06:11:52','',''),(2174834,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 06:11:52','',''),(2174842,'1','138','765',323,'Retail Sale Id 1284925',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 06:12:59','',''),(2174843,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 06:12:59','',''),(2174872,'1','138','765',323,'Retail Sale Id 1284949',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 06:18:09','',''),(2174873,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:18:09','',''),(2175063,'1','138','765',323,'Retail Sale Id 1285008',34002.00,0.00,0.00,0.00,453.36,'2021-12-06 06:37:14','',''),(2175064,'1','138','765',323,'Retail sales',0.00,0.00,0.00,56.67,0.00,'2021-12-06 06:37:14','',''),(2175491,'1','138','765',323,'Retail Sale Id 1285199',30000.00,0.00,0.00,0.00,400.00,'2021-12-06 07:07:16','',''),(2175492,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 07:07:16','',''),(2175574,'1','138','765',323,'Retail Sale Id 1285237',24000.00,0.00,0.00,0.00,320.00,'2021-12-06 07:14:25','',''),(2175575,'1','138','765',323,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-06 07:14:25','',''),(2175728,'1','138','765',323,'Retail Sale Id 1285323',14003.20,0.00,0.00,0.00,1050.24,'2021-12-06 07:23:12','',''),(2175729,'1','138','765',323,'Retail sales',0.00,0.00,0.00,21.88,0.00,'2021-12-06 07:23:12','',''),(2175864,'1','138','765',323,'Retail Sale Id 1285388',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 07:31:29','',''),(2175865,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:31:29','',''),(2175885,'1','138','765',323,'Retail Sale Id 1285398',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 07:32:50','',''),(2175886,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:32:50','',''),(2176058,'1','138','765',323,'Retail Sale Id 1285481',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 07:41:44','',''),(2176059,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:41:44','',''),(2176184,'1','138','765',323,'Retail Sale Id 1285547',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 07:47:11','',''),(2176185,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:47:11','',''),(2176335,'1','138','765',323,'Retail Sale Id 1285602',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 07:53:16','',''),(2176336,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:53:16','',''),(2176702,'1','138','765',323,'Retail Sale Id 1285793',35400.00,0.00,0.00,0.00,472.00,'2021-12-06 08:13:03','',''),(2176703,'1','138','765',323,'Retail sales',0.00,0.00,0.00,59.00,0.00,'2021-12-06 08:13:03','',''),(2176800,'1','138','765',323,'Retail Sale Id 1285847',42000.00,0.00,0.00,0.00,560.00,'2021-12-06 08:20:37','',''),(2176801,'1','138','765',323,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-06 08:20:37','',''),(2176999,'1','138','765',323,'Retail Sale Id 1285946',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 08:37:52','',''),(2177000,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 08:37:52','',''),(2177094,'1','138','765',323,'Retail Sale Id 1285990',998.40,0.00,0.00,0.00,74.88,'2021-12-06 08:44:58','',''),(2177095,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 08:44:58','',''),(2177157,'1','138','765',323,'Retail Sale Id 1286018',998.40,0.00,0.00,0.00,74.88,'2021-12-06 08:49:22','',''),(2177158,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 08:49:22','',''),(2177171,'1','138','765',323,'Retail Sale Id 1286026',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 08:50:15','',''),(2177172,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:50:15','',''),(2177197,'1','138','765',323,'Retail Sale Id 1286041',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 08:52:44','',''),(2177198,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 08:52:44','',''),(2177297,'1','138','765',323,'Retail Sale Id 1286090',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 08:59:33','',''),(2177298,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 08:59:33','',''),(2177313,'1','138','765',323,'Retail Sale Id 1286098',12800.00,0.00,0.00,0.00,960.00,'2021-12-06 09:01:08','',''),(2177314,'1','138','765',323,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-06 09:01:08','',''),(2177389,'1','138','765',323,'Retail Sale Id 1286134',1280.00,0.00,0.00,0.00,96.00,'2021-12-06 09:06:03','',''),(2177390,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 09:06:03','',''),(2177419,'1','138','765',323,'Retail Sale Id 1286145',18000.00,0.00,0.00,0.00,240.00,'2021-12-06 09:07:37','',''),(2177420,'1','138','765',323,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-06 09:07:37','',''),(2177469,'1','138','765',323,'Retail Sale Id 1286169',60000.00,0.00,0.00,0.00,800.00,'2021-12-06 09:11:20','',''),(2177470,'1','138','765',323,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 09:11:20','',''),(2177484,'1','138','765',323,'Retail Sale Id 1286175',36000.00,0.00,0.00,0.00,480.00,'2021-12-06 09:13:13','',''),(2177485,'1','138','765',323,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-06 09:13:13','',''),(2177672,'1','138','765',323,'Retail Sale Id 1286263',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 09:25:18','',''),(2177673,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 09:25:18','',''),(2177712,'1','138','765',323,'Retail Sale Id 1286282',28200.00,0.00,0.00,0.00,376.00,'2021-12-06 09:27:33','',''),(2177713,'1','138','765',323,'Retail sales',0.00,0.00,0.00,47.00,0.00,'2021-12-06 09:27:33','',''),(2178020,'1','138','765',323,'Retail Sale Id 1286402',90000.00,0.00,0.00,0.00,1200.00,'2021-12-06 09:43:47','',''),(2178021,'1','138','765',323,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-06 09:43:47','',''),(2178086,'1','138','765',323,'Retail Sale Id 1286435',16000.00,0.00,0.00,0.00,1200.00,'2021-12-06 09:48:08','',''),(2178087,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 09:48:08','',''),(2178348,'1','138','765',323,'Retail Sale Id 1286562',36000.00,0.00,0.00,0.00,480.00,'2021-12-06 10:05:11','',''),(2178349,'1','138','765',323,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-06 10:05:11','',''),(2178374,'1','138','765',323,'Retail Sale Id 1286576',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 10:06:59','',''),(2178375,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 10:06:59','',''),(2178533,'1','138','765',323,'Retail Sale Id 1286652',61200.00,0.00,0.00,0.00,816.00,'2021-12-06 10:15:47','',''),(2178534,'1','138','765',323,'Retail sales',0.00,0.00,0.00,102.00,0.00,'2021-12-06 10:15:47','',''),(2178553,'1','138','765',323,'Retail Sale Id 1286664',6600.00,0.00,0.00,0.00,88.00,'2021-12-06 10:17:12','',''),(2178554,'1','138','765',323,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-06 10:17:12','',''),(2178701,'1','138','765',323,'Retail Sale Id 1286744',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 10:28:13','',''),(2178702,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 10:28:13','',''),(2178844,'1','138','765',323,'Retail Sale Id 1286823',32000.00,0.00,0.00,0.00,2400.00,'2021-12-06 10:37:56','',''),(2178845,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 10:37:56','',''),(2178928,'1','138','765',323,'Retail Sale Id 1286870',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 10:43:57','',''),(2178929,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:43:57','',''),(2178958,'1','138','765',323,'Retail Sale Id 1286880',30000.00,0.00,0.00,0.00,400.00,'2021-12-06 10:45:23','',''),(2178959,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 10:45:23','',''),(2179008,'1','138','765',323,'Retail Sale Id 1286908',40200.00,0.00,0.00,0.00,536.00,'2021-12-06 10:48:13','',''),(2179009,'1','138','765',323,'Retail sales',0.00,0.00,0.00,67.00,0.00,'2021-12-06 10:48:13','',''),(2179026,'1','138','765',323,'Retail Sale Id 1286920',34800.00,0.00,0.00,0.00,464.00,'2021-12-06 10:49:14','',''),(2179027,'1','138','765',323,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-06 10:49:14','',''),(2179191,'1','138','765',323,'Retail Sale Id 1287025',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 10:59:11','',''),(2179192,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 10:59:11','',''),(2179455,'1','138','765',323,'Retail Sale Id 1286955',7001.60,0.00,0.00,0.00,525.12,'2021-12-06 11:15:17','',''),(2179456,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-06 11:15:17','',''),(2179525,'1','138','765',323,'Retail Sale Id 1287205',30000.00,0.00,0.00,0.00,400.00,'2021-12-06 11:19:09','',''),(2179526,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 11:19:09','',''),(2179573,'1','138','765',323,'Retail Sale Id 1287234',157500.00,0.00,0.00,0.00,2100.00,'2021-12-06 11:22:10','',''),(2179574,'1','138','765',323,'Retail sales',0.00,0.00,0.00,262.50,0.00,'2021-12-06 11:22:10','',''),(2179984,'1','138','765',323,'Retail Sale Id 1287511',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 11:54:26','',''),(2179985,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 11:54:26','',''),(2180024,'1','138','765',323,'Retail Sale Id 1287528',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 11:55:47','',''),(2180025,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 11:55:47','',''),(2180080,'1','138','765',323,'Retail Sale Id 1287557',19852.80,0.00,0.00,0.00,1488.96,'2021-12-06 11:59:12','',''),(2180081,'1','138','765',323,'Retail sales',0.00,0.00,0.00,31.02,0.00,'2021-12-06 11:59:12','',''),(2180228,'1','138','765',323,'Retail Sale Id 1287634',24998.40,0.00,0.00,0.00,1874.88,'2021-12-06 12:08:51','',''),(2180229,'1','138','765',323,'Retail sales',0.00,0.00,0.00,39.06,0.00,'2021-12-06 12:08:51','',''),(2180256,'1','138','765',323,'Retail Sale Id 1287646',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 12:10:22','',''),(2180257,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 12:10:22','',''),(2180360,'1','138','765',323,'Retail Sale Id 1287718',42000.00,0.00,0.00,0.00,560.00,'2021-12-06 12:16:16','',''),(2180361,'1','138','765',323,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-06 12:16:16','',''),(2180718,'1','138','765',323,'Retail Sale Id 1287903',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 12:38:32','',''),(2180719,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 12:38:32','',''),(2180800,'1','138','765',323,'Retail Sale Id 1287943',33000.00,0.00,0.00,0.00,440.00,'2021-12-06 12:44:06','',''),(2180801,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-06 12:44:06','',''),(2180876,'1','138','765',323,'Retail Sale Id 1287984',63000.00,0.00,0.00,0.00,840.00,'2021-12-06 12:48:31','',''),(2180877,'1','138','765',323,'Retail sales',0.00,0.00,0.00,105.00,0.00,'2021-12-06 12:48:31','',''),(2181022,'1','138','765',323,'Retail Sale Id 1288061',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 12:57:42','',''),(2181023,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:57:42','',''),(2181088,'1','138','765',323,'Retail Sale Id 1288091',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 13:00:22','',''),(2181089,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 13:00:22','',''),(2181534,'1','138','765',323,'Retail Sale Id 1288299',25500.00,0.00,0.00,0.00,340.00,'2021-12-06 13:25:52','',''),(2181535,'1','138','765',323,'Retail sales',0.00,0.00,0.00,42.50,0.00,'2021-12-06 13:25:52','',''),(2181554,'1','138','765',323,'Retail Sale Id 1288310',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 13:27:18','',''),(2181555,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:27:18','',''),(2181820,'1','138','765',323,'Retail Sale Id 1288422',3840.00,0.00,0.00,0.00,288.00,'2021-12-06 13:41:12','',''),(2181821,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 13:41:12','',''),(2182027,'1','138','765',323,'Retail Sale Id 1288518',1920.00,0.00,0.00,0.00,144.00,'2021-12-06 13:51:53','',''),(2182028,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 13:51:53','',''),(2182167,'1','138','765',323,'Retail Sale Id 1288589',39000.00,0.00,0.00,0.00,520.00,'2021-12-06 13:58:38','',''),(2182168,'1','138','765',323,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-06 13:58:38','',''),(2182255,'1','138','765',323,'Retail Sale Id 1288620',16000.00,0.00,0.00,0.00,1200.00,'2021-12-06 14:01:55','',''),(2182256,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 14:01:55','',''),(2182420,'1','138','765',323,'Retail Sale Id 1288692',95700.00,0.00,0.00,0.00,1276.00,'2021-12-06 14:09:56','',''),(2182421,'1','138','765',323,'Retail sales',0.00,0.00,0.00,159.50,0.00,'2021-12-06 14:09:56','',''),(2182478,'1','138','765',323,'Retail Sale Id 1288715',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 14:11:50','',''),(2182479,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:11:50','',''),(2182595,'1','138','765',323,'Retail Sale Id 1288766',28800.00,0.00,0.00,0.00,384.00,'2021-12-06 14:17:04','',''),(2182596,'1','138','765',323,'Retail sales',0.00,0.00,0.00,48.00,0.00,'2021-12-06 14:17:04','',''),(2182640,'1','138','765',323,'Retail Sale Id 1288791',13998.00,0.00,0.00,0.00,186.64,'2021-12-06 14:19:34','',''),(2182641,'1','138','765',323,'Retail sales',0.00,0.00,0.00,23.33,0.00,'2021-12-06 14:19:34','',''),(2182756,'1','138','765',323,'Retail Sale Id 1288849',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 14:25:41','',''),(2182757,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:25:41','',''),(2182792,'1','138','765',323,'Retail Sale Id 1288868',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 14:28:06','',''),(2182793,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:28:06','',''),(2182814,'1','138','765',323,'Retail Sale Id 1288880',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 14:29:41','',''),(2182815,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:29:41','',''),(2183071,'1','138','765',323,'Retail Sale Id 1288989',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 14:42:30','',''),(2183072,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 14:42:30','',''),(2183141,'1','138','765',323,'Retail Sale Id 1289023',86700.00,0.00,0.00,0.00,1156.00,'2021-12-06 14:46:25','',''),(2183142,'1','138','765',323,'Retail sales',0.00,0.00,0.00,144.50,0.00,'2021-12-06 14:46:25','',''),(2183200,'1','138','765',323,'Retail Sale Id 1289043',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 14:49:01','',''),(2183201,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 14:49:01','',''),(2183505,'1','138','765',323,'Retail Sale Id 1289195',9600.00,0.00,0.00,0.00,720.00,'2021-12-06 15:04:45','',''),(2183506,'1','138','765',323,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-06 15:04:45','',''),(2183653,'1','138','765',323,'Retail Sale Id 1289260',18600.00,0.00,0.00,0.00,248.00,'2021-12-06 15:13:06','',''),(2183654,'1','138','765',323,'Retail sales',0.00,0.00,0.00,31.00,0.00,'2021-12-06 15:13:06','',''),(2183798,'1','138','765',323,'Retail Sale Id 1289323',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 15:19:53','',''),(2183799,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 15:19:53','',''),(2183826,'1','138','765',323,'Retail Sale Id 1289337',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 15:21:19','',''),(2183827,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:21:19','',''),(2183870,'1','138','765',323,'Retail Sale Id 1289348',54000.00,0.00,0.00,0.00,720.00,'2021-12-06 15:22:57','',''),(2183871,'1','138','765',323,'Retail sales',0.00,0.00,0.00,90.00,0.00,'2021-12-06 15:22:57','',''),(2184007,'1','138','765',323,'Retail Sale Id 1289423',6400.00,0.00,0.00,0.00,480.00,'2021-12-06 15:29:14','',''),(2184008,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 15:29:14','',''),(2184063,'1','138','765',323,'Retail Sale Id 1289449',3840.00,0.00,0.00,0.00,288.00,'2021-12-06 15:32:23','',''),(2184064,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:32:23','',''),(2184143,'1','138','765',323,'Retail Sale Id 1289490',6400.00,0.00,0.00,0.00,480.00,'2021-12-06 15:37:03','',''),(2184144,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 15:37:03','',''),(2184265,'1','138','765',323,'Retail Sale Id 1289528',30000.00,0.00,0.00,0.00,400.00,'2021-12-06 15:41:04','',''),(2184266,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 15:41:04','',''),(2184488,'1','138','765',323,'Retail Sale Id 1289606',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 15:49:18','',''),(2184489,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 15:49:18','',''),(2184530,'1','138','765',323,'Retail Sale Id 1289627',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 15:51:17','',''),(2184531,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:51:17','',''),(2184596,'1','138','765',323,'Retail Sale Id 1289659',1280.00,0.00,0.00,0.00,96.00,'2021-12-06 15:54:57','',''),(2184597,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 15:54:57','',''),(2184630,'1','138','765',323,'Retail Sale Id 1289675',32000.00,0.00,0.00,0.00,2400.00,'2021-12-06 15:56:46','',''),(2184631,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 15:56:46','',''),(2184737,'1','138','765',323,'Retail Sale Id 1289728',16000.00,0.00,0.00,0.00,1200.00,'2021-12-06 16:02:57','',''),(2184738,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 16:02:57','',''),(2184801,'1','138','765',323,'Retail Sale Id 1289753',42000.00,0.00,0.00,0.00,560.00,'2021-12-06 16:06:22','',''),(2184802,'1','138','765',323,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-06 16:06:22','',''),(2184833,'1','138','765',323,'Retail Sale Id 1289768',30080.00,0.00,0.00,0.00,2256.00,'2021-12-06 16:09:09','',''),(2184834,'1','138','765',323,'Retail sales',0.00,0.00,0.00,47.00,0.00,'2021-12-06 16:09:09','',''),(2184853,'1','138','765',323,'Retail Sale Id 1289778',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 16:10:08','',''),(2184854,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:10:08','',''),(2184890,'1','138','765',323,'Retail Sale Id 1289796',13452.80,0.00,0.00,0.00,1008.96,'2021-12-06 16:12:47','',''),(2184891,'1','138','765',323,'Retail sales',0.00,0.00,0.00,21.02,0.00,'2021-12-06 16:12:47','',''),(2184914,'1','138','765',323,'Retail Sale Id 1289805',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 16:14:46','',''),(2184915,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 16:14:46','',''),(2184936,'1','138','765',323,'Retail Sale Id 1289815',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 16:16:03','',''),(2184937,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:16:03','',''),(2184966,'1','138','765',323,'Retail Sale Id 1289829',6600.00,0.00,0.00,0.00,88.00,'2021-12-06 16:17:24','',''),(2184967,'1','138','765',323,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-06 16:17:24','',''),(2184983,'1','138','765',323,'Retail Sale Id 1289837',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 16:18:31','',''),(2184984,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:18:31','',''),(2185024,'1','138','765',323,'Retail Sale Id 1289860',16000.00,0.00,0.00,0.00,1200.00,'2021-12-06 16:20:23','',''),(2185025,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 16:20:23','',''),(2185268,'1','138','765',323,'Retail Sale Id 1289982',1055814.00,0.00,0.00,0.00,7086.00,'2021-12-06 16:32:41','',''),(2185269,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1771.50,0.00,'2021-12-06 16:32:41','',''),(2185324,'1','138','765',323,'Retail Sale Id 1290007',15000.00,0.00,0.00,0.00,200.00,'2021-12-06 16:35:11','',''),(2185325,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 16:35:11','',''),(2185346,'1','138','765',323,'Retail Sale Id 1290018',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 16:36:41','',''),(2185347,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:36:41','',''),(2185515,'1','138','765',323,'Retail Sale Id 1290097',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 16:46:53','',''),(2185516,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:46:53','',''),(2185549,'1','138','765',323,'Retail Sale Id 1290112',16000.00,0.00,0.00,0.00,1200.00,'2021-12-06 16:47:53','',''),(2185550,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 16:47:53','',''),(2185583,'1','138','765',323,'Retail Sale Id 1290129',4499.20,0.00,0.00,0.00,337.44,'2021-12-06 16:49:17','',''),(2185584,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-06 16:49:17','',''),(2185609,'1','138','765',323,'Return of Retail Sale Id 1290097',0.00,8000.00,12.50,0.00,-600.00,'2021-12-06 16:50:35','',''),(2185800,'1','138','765',323,'Retail Sale Id 1290247',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 17:02:45','',''),(2185801,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 17:02:45','',''),(2185877,'1','138','765',323,'Retail Sale Id 1290286',14400.00,0.00,0.00,0.00,192.00,'2021-12-06 17:08:09','',''),(2185878,'1','138','765',323,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-06 17:08:09','',''),(2185953,'1','138','765',323,'Retail Sale Id 1290328',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 17:12:47','',''),(2185954,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 17:12:47','',''),(2186045,'1','138','765',323,'Retail Sale Id 1290377',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 17:22:12','',''),(2186046,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 17:22:12','',''),(2186086,'1','138','765',323,'Retail Sale Id 1290394',34800.00,0.00,0.00,0.00,464.00,'2021-12-06 17:25:21','',''),(2186087,'1','138','765',323,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-06 17:25:21','',''),(2186331,'1','138','765',323,'Retail Sale Id 1290531',98400.00,0.00,0.00,0.00,1312.00,'2021-12-06 17:52:31','',''),(2186332,'1','138','765',323,'Retail sales',0.00,0.00,0.00,164.00,0.00,'2021-12-06 17:52:31','',''),(2186358,'1','138','765',323,'Retail Sale Id 1290543',3801.60,0.00,0.00,0.00,285.12,'2021-12-06 17:56:56','',''),(2186359,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-06 17:56:56','',''),(2187200,'1','138','765',323,'Retail Sale Id 1290687',93600.00,0.00,0.00,0.00,1248.00,'2021-12-07 06:05:32','',''),(2187201,'1','138','765',323,'Retail sales',0.00,0.00,0.00,156.00,0.00,'2021-12-07 06:05:32','',''),(2187382,'1','138','765',323,'Retail Sale Id 1290775',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 06:22:29','',''),(2187383,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 06:22:29','',''),(2187865,'1','138','765',323,'Retail Sale Id 1291007',8998.40,0.00,0.00,0.00,674.88,'2021-12-07 06:56:22','',''),(2187866,'1','138','765',323,'Retail sales',0.00,0.00,0.00,14.06,0.00,'2021-12-07 06:56:22','',''),(2188018,'1','138','765',323,'Retail Sale Id 1291084',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 07:04:20','',''),(2188019,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:04:20','',''),(2188432,'1','138','765',323,'Retail Sale Id 1291293',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 07:24:02','',''),(2188433,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:24:02','',''),(2188506,'1','138','765',323,'Retail Sale Id 1291326',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 07:27:22','',''),(2188507,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:27:22','',''),(2188630,'1','138','765',323,'Retail Sale Id 1291389',7001.60,0.00,0.00,0.00,525.12,'2021-12-07 07:32:37','',''),(2188631,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-07 07:32:37','',''),(2188810,'1','138','765',323,'Retail Sale Id 1291481',3852.80,0.00,0.00,0.00,288.96,'2021-12-07 07:41:44','',''),(2188811,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 07:41:44','',''),(2188894,'1','138','765',323,'Retail Sale Id 1291545',11200.00,0.00,0.00,0.00,840.00,'2021-12-07 07:46:23','',''),(2188895,'1','138','765',323,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-07 07:46:23','',''),(2189071,'1','138','765',323,'Retail Sale Id 1291598',180800.00,0.00,0.00,0.00,13560.00,'2021-12-07 07:56:12','',''),(2189072,'1','138','765',323,'Retail sales',0.00,0.00,0.00,282.50,0.00,'2021-12-07 07:56:12','',''),(2189115,'1','138','765',323,'Retail Sale Id 1291654',30000.00,0.00,0.00,0.00,400.00,'2021-12-07 07:59:08','',''),(2189116,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 07:59:08','',''),(2189165,'1','138','765',323,'Retail Sale Id 1291674',3840.00,0.00,0.00,0.00,288.00,'2021-12-07 08:01:30','',''),(2189166,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 08:01:30','',''),(2189203,'1','138','765',323,'Retail Sale Id 1291698',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 08:04:21','',''),(2189204,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 08:04:21','',''),(2189400,'1','138','765',323,'Retail Sale Id 1291785',5760.00,0.00,0.00,0.00,432.00,'2021-12-07 08:14:31','',''),(2189401,'1','138','765',323,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-07 08:14:31','',''),(2189512,'1','138','765',323,'Return of Retail Sale Id 1291598',0.00,180800.00,282.50,0.00,-13560.00,'2021-12-07 08:21:19','',''),(2189722,'1','138','765',323,'Retail Sale Id 1291942',42000.00,0.00,0.00,0.00,560.00,'2021-12-07 08:34:16','',''),(2189723,'1','138','765',323,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-07 08:34:16','',''),(2189975,'1','138','765',323,'Retail Sale Id 1292032',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 08:45:37','',''),(2189976,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 08:45:37','',''),(2190031,'1','138','765',323,'Retail Sale Id 1292064',25998.00,0.00,0.00,0.00,346.64,'2021-12-07 08:48:30','',''),(2190032,'1','138','765',323,'Retail sales',0.00,0.00,0.00,43.33,0.00,'2021-12-07 08:48:30','',''),(2190055,'1','138','765',323,'Retail Sale Id 1292077',49800.00,0.00,0.00,0.00,664.00,'2021-12-07 08:49:53','',''),(2190056,'1','138','765',323,'Retail sales',0.00,0.00,0.00,83.00,0.00,'2021-12-07 08:49:53','',''),(2190104,'1','138','765',323,'Retail Sale Id 1292095',30000.00,0.00,0.00,0.00,400.00,'2021-12-07 08:51:53','',''),(2190105,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 08:51:53','',''),(2190387,'1','138','765',323,'Retail Sale Id 1292232',16000.00,0.00,0.00,0.00,1200.00,'2021-12-07 09:09:18','',''),(2190388,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 09:09:18','',''),(2190409,'1','138','765',323,'Retail Sale Id 1292243',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 09:10:35','',''),(2190410,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:10:35','',''),(2190473,'1','138','765',323,'Retail Sale Id 1292277',67800.00,0.00,0.00,0.00,904.00,'2021-12-07 09:14:02','',''),(2190474,'1','138','765',323,'Retail sales',0.00,0.00,0.00,113.00,0.00,'2021-12-07 09:14:02','',''),(2190577,'1','138','765',323,'Retail Sale Id 1292333',3500.80,0.00,0.00,0.00,262.56,'2021-12-07 09:19:54','',''),(2190578,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-07 09:19:54','',''),(2190667,'1','138','765',323,'Retail Sale Id 1292370',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 09:24:25','',''),(2190668,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:24:25','',''),(2190774,'1','138','765',323,'Retail Sale Id 1292419',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 09:29:04','',''),(2190775,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:29:04','',''),(2190894,'1','138','765',323,'Retail Sale Id 1292478',7001.60,0.00,0.00,0.00,525.12,'2021-12-07 09:34:48','',''),(2190895,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-07 09:34:48','',''),(2190956,'1','138','765',323,'Retail Sale Id 1292508',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 09:38:28','',''),(2190957,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:38:28','',''),(2191351,'1','138','765',323,'Retail Sale Id 1292718',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 10:05:13','',''),(2191352,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:05:13','',''),(2191575,'1','138','765',323,'Retail Sale Id 1292835',6003.20,0.00,0.00,0.00,450.24,'2021-12-07 10:20:02','',''),(2191576,'1','138','765',323,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-07 10:20:02','',''),(2191726,'1','138','765',323,'Retail Sale Id 1292909',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 10:32:45','',''),(2191727,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:32:45','',''),(2191779,'1','138','765',323,'Retail Sale Id 1292939',1920.00,0.00,0.00,0.00,144.00,'2021-12-07 10:36:53','',''),(2191780,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 10:36:53','',''),(2191807,'1','138','765',323,'Retail Sale Id 1292952',6400.00,0.00,0.00,0.00,480.00,'2021-12-07 10:38:23','',''),(2191808,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 10:38:23','',''),(2191833,'1','138','765',323,'Retail Sale Id 1292967',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 10:39:57','',''),(2191834,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:39:57','',''),(2191921,'1','138','765',323,'Retail Sale Id 1293007',39198.00,0.00,0.00,0.00,522.64,'2021-12-07 10:44:40','',''),(2191922,'1','138','765',323,'Retail sales',0.00,0.00,0.00,65.33,0.00,'2021-12-07 10:44:41','',''),(2192106,'1','138','765',323,'Retail Sale Id 1293094',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 10:53:39','',''),(2192107,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:53:39','',''),(2192370,'1','138','765',323,'Retail Sale Id 1293208',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 11:07:27','',''),(2192371,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 11:07:27','',''),(2192704,'1','138','765',323,'Retail Sale Id 1293413',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 11:29:04','',''),(2192705,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 11:29:04','',''),(2192821,'1','138','765',323,'Retail Sale Id 1293471',3840.00,0.00,0.00,0.00,288.00,'2021-12-07 11:37:32','',''),(2192822,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 11:37:32','',''),(2192837,'1','138','765',323,'Retail Sale Id 1293482',7001.60,0.00,0.00,0.00,525.12,'2021-12-07 11:38:56','',''),(2192838,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-07 11:38:56','',''),(2192855,'1','138','765',323,'Retail Sale Id 1293492',1920.00,0.00,0.00,0.00,144.00,'2021-12-07 11:40:06','',''),(2192856,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:40:06','',''),(2192893,'1','138','765',323,'Retail Sale Id 1293514',39000.00,0.00,0.00,0.00,520.00,'2021-12-07 11:42:18','',''),(2192894,'1','138','765',323,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-07 11:42:18','',''),(2193227,'1','138','765',323,'Retail Sale Id 1293684',3500.80,0.00,0.00,0.00,262.56,'2021-12-07 12:11:04','',''),(2193228,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-07 12:11:04','',''),(2193325,'1','138','765',323,'Retail Sale Id 1293737',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 12:18:19','',''),(2193326,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 12:18:19','',''),(2193745,'1','138','765',323,'Retail Sale Id 1293969',6400.00,0.00,0.00,0.00,480.00,'2021-12-07 12:52:07','',''),(2193746,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 12:52:07','',''),(2193993,'1','138','765',323,'Retail Sale Id 1294092',54000.00,0.00,0.00,0.00,720.00,'2021-12-07 13:09:15','',''),(2193994,'1','138','765',323,'Retail sales',0.00,0.00,0.00,90.00,0.00,'2021-12-07 13:09:15','',''),(2194477,'1','138','765',323,'Retail Sale Id 1294388',998.40,0.00,0.00,0.00,74.88,'2021-12-07 13:35:30','',''),(2194478,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 13:35:30','',''),(2194563,'1','138','765',323,'Retail Sale Id 1294426',3840.00,0.00,0.00,0.00,288.00,'2021-12-07 13:40:04','',''),(2194564,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 13:40:04','',''),(2194688,'1','138','765',323,'Retail Sale Id 1294488',14720.00,0.00,0.00,0.00,1104.00,'2021-12-07 13:48:41','',''),(2194689,'1','138','765',323,'Retail sales',0.00,0.00,0.00,23.00,0.00,'2021-12-07 13:48:41','',''),(2194724,'1','138','765',323,'Retail Sale Id 1294496',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 13:50:32','',''),(2194725,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:50:32','',''),(2194893,'1','138','765',323,'Retail Sale Id 1294585',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 14:01:40','',''),(2194894,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:01:40','',''),(2194911,'1','138','765',323,'Retail Sale Id 1294591',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 14:02:56','',''),(2194912,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:02:56','',''),(2195270,'1','138','765',323,'Retail Sale Id 1294738',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 14:22:36','',''),(2195271,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:22:36','',''),(2195336,'1','138','765',323,'Retail Sale Id 1294771',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 14:25:41','',''),(2195337,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:25:41','',''),(2195718,'1','138','765',323,'Retail Sale Id 1294971',33000.00,0.00,0.00,0.00,440.00,'2021-12-07 14:46:50','',''),(2195719,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-07 14:46:50','',''),(2195766,'1','138','765',323,'Retail Sale Id 1294997',34800.00,0.00,0.00,0.00,464.00,'2021-12-07 14:49:14','',''),(2195767,'1','138','765',323,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-07 14:49:14','',''),(2195800,'1','138','765',323,'Retail Sale Id 1295016',4998.40,0.00,0.00,0.00,374.88,'2021-12-07 14:50:23','',''),(2195801,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-07 14:50:23','',''),(2195892,'1','138','765',323,'Retail Sale Id 1295067',114000.00,0.00,0.00,0.00,1520.00,'2021-12-07 14:55:44','',''),(2195893,'1','138','765',323,'Retail sales',0.00,0.00,0.00,190.00,0.00,'2021-12-07 14:55:44','',''),(2195914,'1','138','765',323,'Retail Sale Id 1295078',998.40,0.00,0.00,0.00,74.88,'2021-12-07 14:57:12','',''),(2195915,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 14:57:12','',''),(2196015,'1','138','765',323,'Retail Sale Id 1295119',3840.00,0.00,0.00,0.00,288.00,'2021-12-07 15:03:14','',''),(2196016,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:03:14','',''),(2196628,'1','138','765',323,'Retail Sale Id 1295433',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 15:35:14','',''),(2196629,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 15:35:14','',''),(2196705,'1','138','765',323,'Retail Sale Id 1295469',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 15:38:33','',''),(2196706,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:38:33','',''),(2196775,'1','138','765',323,'Retail Sale Id 1295498',34800.00,0.00,0.00,0.00,464.00,'2021-12-07 15:41:18','',''),(2196776,'1','138','765',323,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-07 15:41:18','',''),(2196799,'1','138','765',323,'Retail Sale Id 1295511',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 15:42:55','',''),(2196800,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:42:55','',''),(2197207,'1','138','765',323,'Retail Sale Id 1295719',184200.00,0.00,0.00,0.00,2456.00,'2021-12-07 16:02:04','',''),(2197208,'1','138','765',323,'Retail sales',0.00,0.00,0.00,307.00,0.00,'2021-12-07 16:02:04','',''),(2197267,'1','138','765',323,'Retail Sale Id 1295751',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 16:05:12','',''),(2197268,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:05:12','',''),(2197306,'1','138','765',323,'Retail Sale Id 1295774',8499.20,0.00,0.00,0.00,637.44,'2021-12-07 16:06:38','',''),(2197307,'1','138','765',323,'Retail sales',0.00,0.00,0.00,13.28,0.00,'2021-12-07 16:06:38','',''),(2197338,'1','138','765',323,'Retail Sale Id 1295788',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 16:08:21','',''),(2197339,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:08:21','',''),(2197402,'1','138','765',323,'Retail Sale Id 1295817',16000.00,0.00,0.00,0.00,1200.00,'2021-12-07 16:11:48','',''),(2197403,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 16:11:48','',''),(2197444,'1','138','765',323,'Retail Sale Id 1295843',14976.00,0.00,0.00,0.00,1123.20,'2021-12-07 16:13:31','',''),(2197445,'1','138','765',323,'Retail sales',0.00,0.00,0.00,23.40,0.00,'2021-12-07 16:13:31','',''),(2197486,'1','138','765',323,'Retail Sale Id 1295868',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 16:15:40','',''),(2197487,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:15:40','',''),(2197512,'1','138','765',323,'Retail Sale Id 1295885',720000.00,0.00,0.00,0.00,9600.00,'2021-12-07 16:16:56','',''),(2197513,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1200.00,0.00,'2021-12-07 16:16:56','',''),(2197527,'1','138','765',323,'Return of Retail Sale Id 1295885',0.00,720000.00,1200.00,0.00,-9600.00,'2021-12-07 16:17:24','',''),(2197556,'1','138','765',323,'Retail Sale Id 1295910',715200.00,0.00,0.00,0.00,4800.00,'2021-12-07 16:18:47','',''),(2197557,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1200.00,0.00,'2021-12-07 16:18:47','',''),(2197591,'1','138','765',323,'Retail Sale Id 1295929',13500.00,0.00,0.00,0.00,180.00,'2021-12-07 16:19:55','',''),(2197592,'1','138','765',323,'Retail sales',0.00,0.00,0.00,22.50,0.00,'2021-12-07 16:19:55','',''),(2197607,'1','138','765',323,'Retail Sale Id 1295936',32000.00,0.00,0.00,0.00,2400.00,'2021-12-07 16:20:52','',''),(2197608,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 16:20:52','',''),(2197651,'1','138','765',323,'Retail Sale Id 1295955',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 16:22:40','',''),(2197652,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:22:40','',''),(2197681,'1','138','765',323,'Retail Sale Id 1295975',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 16:24:35','',''),(2197682,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:24:35','',''),(2197767,'1','138','765',323,'Retail Sale Id 1296016',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 16:28:26','',''),(2197768,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:28:26','',''),(2197972,'1','138','765',323,'Retail Sale Id 1296129',35400.00,0.00,0.00,0.00,472.00,'2021-12-07 16:39:47','',''),(2197973,'1','138','765',323,'Retail sales',0.00,0.00,0.00,59.00,0.00,'2021-12-07 16:39:47','',''),(2198006,'1','138','765',323,'Retail Sale Id 1296144',15000.00,0.00,0.00,0.00,200.00,'2021-12-07 16:42:00','',''),(2198007,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 16:42:00','',''),(2198033,'1','138','765',323,'Retail Sale Id 1296158',40800.00,0.00,0.00,0.00,544.00,'2021-12-07 16:43:56','',''),(2198034,'1','138','765',323,'Retail sales',0.00,0.00,0.00,68.00,0.00,'2021-12-07 16:43:56','',''),(2198116,'1','138','765',323,'Retail Sale Id 1296202',24000.00,0.00,0.00,0.00,1800.00,'2021-12-07 16:48:34','',''),(2198117,'1','138','765',323,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-07 16:48:34','',''),(2198139,'1','138','765',323,'Retail Sale Id 1296212',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 16:50:07','',''),(2198140,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:50:07','',''),(2198200,'1','138','765',323,'Retail Sale Id 1296249',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 16:53:59','',''),(2198201,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 16:53:59','',''),(2198240,'1','138','765',323,'Retail Sale Id 1296264',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 16:55:18','',''),(2198241,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 16:55:18','',''),(2198290,'1','138','765',323,'Retail Sale Id 1296292',3840.00,0.00,0.00,0.00,288.00,'2021-12-07 16:57:29','',''),(2198291,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:57:29','',''),(2198343,'1','138','765',323,'Retail Sale Id 1296319',33000.00,0.00,0.00,0.00,440.00,'2021-12-07 17:00:20','',''),(2198344,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-07 17:00:20','',''),(2198380,'1','138','765',323,'Retail Sale Id 1296333',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 17:01:49','',''),(2198381,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:01:49','',''),(2198565,'1','138','765',323,'Retail Sale Id 1296444',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 17:15:08','',''),(2198566,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:15:08','',''),(2198589,'1','138','765',323,'Retail Sale Id 1296456',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 17:16:55','',''),(2198590,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:16:55','',''),(2198649,'1','138','765',323,'Retail Sale Id 1296490',1203.20,0.00,0.00,0.00,90.24,'2021-12-07 17:21:26','',''),(2198650,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-07 17:21:26','',''),(2198679,'1','138','765',323,'Retail Sale Id 1296507',4998.40,0.00,0.00,0.00,374.88,'2021-12-07 17:24:21','',''),(2198680,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-07 17:24:21','',''),(2199004,'1','138','765',323,'Retail Sale Id 1296640',5798.40,0.00,0.00,0.00,434.88,'2021-12-07 17:55:14','',''),(2199005,'1','138','765',323,'Retail sales',0.00,0.00,0.00,9.06,0.00,'2021-12-07 17:55:14','',''),(2199012,'1','138','765',323,'Retail Sale Id 1296642',3500.80,0.00,0.00,0.00,262.56,'2021-12-07 17:56:07','',''),(2199013,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-07 17:56:07','',''),(2199050,'1','138','765',323,'Retail Sale Id 1296648',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 17:58:11','',''),(2199051,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:58:11','',''),(2199064,'1','138','765',323,'Retail Sale Id 1296659',18000.00,0.00,0.00,0.00,240.00,'2021-12-07 18:00:38','',''),(2199065,'1','138','765',323,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-07 18:00:38','',''),(2199118,'1','138','765',323,'Retail Sale Id 1296679',4480.00,0.00,0.00,0.00,336.00,'2021-12-07 18:07:49','',''),(2199119,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 18:07:49','',''),(2199759,'1','138','765',323,'Retail Sale Id 1296797',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 06:07:43','',''),(2199760,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 06:07:43','',''),(2199766,'1','138','765',323,'Retail Sale Id 1296801',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 06:08:48','',''),(2199767,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 06:08:48','',''),(2200054,'1','138','765',323,'Retail Sale Id 1296925',34800.00,0.00,0.00,0.00,464.00,'2021-12-08 06:40:21','',''),(2200055,'1','138','765',323,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-08 06:40:22','',''),(2200280,'1','138','765',323,'Retail Sale Id 1297003',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 06:51:15','',''),(2200281,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 06:51:15','',''),(2200533,'1','138','765',323,'Retail Sale Id 1297119',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 07:05:55','',''),(2200534,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:05:55','',''),(2200557,'1','138','765',323,'Retail Sale Id 1297132',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 07:07:23','',''),(2200558,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:07:23','',''),(2200575,'1','138','765',323,'Retail Sale Id 1297137',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 07:08:27','',''),(2200576,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 07:08:27','',''),(2200743,'1','138','765',323,'Retail Sale Id 1297218',7680.00,0.00,0.00,0.00,576.00,'2021-12-08 07:18:55','',''),(2200744,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-08 07:18:55','',''),(2200822,'1','138','765',323,'Retail Sale Id 1297254',210000.00,0.00,0.00,0.00,2800.00,'2021-12-08 07:22:49','',''),(2200823,'1','138','765',323,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-08 07:22:49','',''),(2201184,'1','138','765',323,'Retail Sale Id 1297418',28000.00,0.00,0.00,0.00,2100.00,'2021-12-08 07:41:55','',''),(2201185,'1','138','765',323,'Retail sales',0.00,0.00,0.00,43.75,0.00,'2021-12-08 07:41:55','',''),(2201292,'1','138','765',323,'Retail Sale Id 1297474',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 07:49:02','',''),(2201293,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 07:49:02','',''),(2201351,'1','138','765',323,'Retail Sale Id 1297500',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 07:51:33','',''),(2201352,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 07:51:33','',''),(2201452,'1','138','765',323,'Retail Sale Id 1297534',6400.00,0.00,0.00,0.00,480.00,'2021-12-08 07:55:01','',''),(2201453,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 07:55:01','',''),(2201661,'1','138','765',323,'Retail Sale Id 1297632',120000.00,0.00,0.00,0.00,1600.00,'2021-12-08 08:05:35','',''),(2201662,'1','138','765',323,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-08 08:05:35','',''),(2202126,'1','138','765',323,'Retail Sale Id 1297864',998.40,0.00,0.00,0.00,74.88,'2021-12-08 08:36:22','',''),(2202127,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 08:36:22','',''),(2202376,'1','138','765',323,'Retail Sale Id 1297948',60000.00,0.00,0.00,0.00,800.00,'2021-12-08 08:47:06','',''),(2202377,'1','138','765',323,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-08 08:47:06','',''),(2202852,'1','138','765',323,'Retail Sale Id 1298164',44800.00,0.00,0.00,0.00,3360.00,'2021-12-08 09:12:56','',''),(2202853,'1','138','765',323,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-08 09:12:56','',''),(2202912,'1','138','765',323,'Retail Sale Id 1298194',15000.00,0.00,0.00,0.00,200.00,'2021-12-08 09:16:37','',''),(2202913,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 09:16:37','',''),(2203017,'1','138','765',323,'Retail Sale Id 1298245',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 09:23:46','',''),(2203018,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:23:46','',''),(2203077,'1','138','765',323,'Retail Sale Id 1298274',198000.00,0.00,0.00,0.00,2640.00,'2021-12-08 09:29:32','',''),(2203078,'1','138','765',323,'Retail sales',0.00,0.00,0.00,330.00,0.00,'2021-12-08 09:29:32','',''),(2203113,'1','138','765',323,'Retail Sale Id 1298293',8960.00,0.00,0.00,0.00,672.00,'2021-12-08 09:33:17','',''),(2203114,'1','138','765',323,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-08 09:33:17','',''),(2203149,'1','138','765',323,'Retail Sale Id 1298311',1952.00,0.00,0.00,0.00,146.40,'2021-12-08 09:35:45','',''),(2203150,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 09:35:45','',''),(2203183,'1','138','765',323,'Retail Sale Id 1298324',17497.60,0.00,0.00,0.00,1312.32,'2021-12-08 09:38:09','',''),(2203184,'1','138','765',323,'Retail sales',0.00,0.00,0.00,27.34,0.00,'2021-12-08 09:38:09','',''),(2203263,'1','138','765',323,'Retail Sale Id 1298363',54000.00,0.00,0.00,0.00,720.00,'2021-12-08 09:45:05','',''),(2203264,'1','138','765',323,'Retail sales',0.00,0.00,0.00,90.00,0.00,'2021-12-08 09:45:05','',''),(2203297,'1','138','765',323,'Retail Sale Id 1298383',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 09:47:36','',''),(2203298,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:47:36','',''),(2203538,'1','138','765',323,'Retail Sale Id 1298489',9000.00,0.00,0.00,0.00,120.00,'2021-12-08 10:04:12','',''),(2203539,'1','138','765',323,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-08 10:04:12','',''),(2203723,'1','138','765',323,'Retail Sale Id 1298579',20000.00,0.00,0.00,0.00,1500.00,'2021-12-08 10:15:55','',''),(2203724,'1','138','765',323,'Retail sales',0.00,0.00,0.00,31.25,0.00,'2021-12-08 10:15:55','',''),(2204087,'1','138','765',323,'Retail Sale Id 1298749',24000.00,0.00,0.00,0.00,1800.00,'2021-12-08 10:39:44','',''),(2204088,'1','138','765',323,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-08 10:39:44','',''),(2204141,'1','138','765',323,'Retail Sale Id 1298776',4998.40,0.00,0.00,0.00,374.88,'2021-12-08 10:44:14','',''),(2204142,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-08 10:44:14','',''),(2204244,'1','138','765',323,'Retail Sale Id 1298827',81000.00,0.00,0.00,0.00,1080.00,'2021-12-08 10:53:59','',''),(2204245,'1','138','765',323,'Retail sales',0.00,0.00,0.00,135.00,0.00,'2021-12-08 10:53:59','',''),(2204260,'1','138','765',323,'Retail Sale Id 1298836',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 10:55:16','',''),(2204261,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 10:55:16','',''),(2204418,'1','138','765',323,'Retail Sale Id 1298916',16000.00,0.00,0.00,0.00,1200.00,'2021-12-08 11:07:32','',''),(2204419,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 11:07:32','',''),(2204462,'1','138','765',323,'Retail Sale Id 1298938',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 11:09:32','',''),(2204463,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 11:09:32','',''),(2204582,'1','138','765',323,'Retail Sale Id 1299002',21600.00,0.00,0.00,0.00,288.00,'2021-12-08 11:18:09','',''),(2204583,'1','138','765',323,'Retail sales',0.00,0.00,0.00,36.00,0.00,'2021-12-08 11:18:09','',''),(2204954,'1','138','765',323,'Retail Sale Id 1299195',24000.00,0.00,0.00,0.00,320.00,'2021-12-08 11:42:17','',''),(2204955,'1','138','765',323,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-08 11:42:17','',''),(2205098,'1','138','765',323,'Retail Sale Id 1299264',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 11:52:47','',''),(2205099,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:52:47','',''),(2205140,'1','138','765',323,'Retail Sale Id 1299284',25902.00,0.00,0.00,0.00,345.36,'2021-12-08 11:56:01','',''),(2205141,'1','138','765',323,'Retail sales',0.00,0.00,0.00,43.17,0.00,'2021-12-08 11:56:01','',''),(2205160,'1','138','765',323,'Retail Sale Id 1299296',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 11:58:08','',''),(2205161,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:58:08','',''),(2205184,'1','138','765',323,'Retail Sale Id 1299308',53400.00,0.00,0.00,0.00,712.00,'2021-12-08 11:59:47','',''),(2205185,'1','138','765',323,'Retail sales',0.00,0.00,0.00,89.00,0.00,'2021-12-08 11:59:47','',''),(2205351,'1','138','765',323,'Retail Sale Id 1299374',30003.20,0.00,0.00,0.00,2250.24,'2021-12-08 12:11:25','',''),(2205352,'1','138','765',323,'Retail sales',0.00,0.00,0.00,46.88,0.00,'2021-12-08 12:11:25','',''),(2205487,'1','138','765',323,'Retail Sale Id 1299438',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 12:22:59','',''),(2205488,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:22:59','',''),(2205666,'1','138','765',323,'Retail Sale Id 1299526',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 12:36:57','',''),(2205667,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:36:57','',''),(2205734,'1','138','765',323,'Retail Sale Id 1299559',66000.00,0.00,0.00,0.00,880.00,'2021-12-08 12:41:15','',''),(2205735,'1','138','765',323,'Retail sales',0.00,0.00,0.00,110.00,0.00,'2021-12-08 12:41:15','',''),(2205829,'1','138','765',323,'Retail Sale Id 1299607',34200.00,0.00,0.00,0.00,456.00,'2021-12-08 12:47:31','',''),(2205830,'1','138','765',323,'Retail sales',0.00,0.00,0.00,57.00,0.00,'2021-12-08 12:47:31','',''),(2205953,'1','138','765',323,'Retail Sale Id 1299645',19800.00,0.00,0.00,0.00,264.00,'2021-12-08 12:52:15','',''),(2205954,'1','138','765',323,'Retail sales',0.00,0.00,0.00,33.00,0.00,'2021-12-08 12:52:15','',''),(2206098,'1','138','765',323,'Retail Sale Id 1299708',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 13:04:16','',''),(2206099,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 13:04:16','',''),(2206100,'1','138','765',323,'Retail Sale Id 1299708',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 13:04:16','',''),(2206101,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:04:16','',''),(2206138,'1','138','765',323,'Retail Sale Id 1299728',32000.00,0.00,0.00,0.00,2400.00,'2021-12-08 13:06:52','',''),(2206139,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 13:06:52','',''),(2206307,'1','138','765',323,'Retail Sale Id 1299803',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 13:17:50','',''),(2206308,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:17:50','',''),(2206401,'1','138','765',323,'Retail Sale Id 1299856',39000.00,0.00,0.00,0.00,520.00,'2021-12-08 13:25:24','',''),(2206402,'1','138','765',323,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-08 13:25:24','',''),(2206489,'1','138','765',323,'Retail Sale Id 1299892',1920.00,0.00,0.00,0.00,144.00,'2021-12-08 13:29:50','',''),(2206490,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:29:50','',''),(2206519,'1','138','765',323,'Retail Sale Id 1299904',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 13:31:09','',''),(2206520,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 13:31:09','',''),(2206787,'1','138','765',323,'Retail Sale Id 1300011',78000.00,0.00,0.00,0.00,1040.00,'2021-12-08 13:45:52','',''),(2206788,'1','138','765',323,'Retail sales',0.00,0.00,0.00,130.00,0.00,'2021-12-08 13:45:52','',''),(2206951,'1','138','765',323,'Retail Sale Id 1300069',3852.80,0.00,0.00,0.00,288.96,'2021-12-08 13:55:03','',''),(2206952,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 13:55:03','',''),(2207207,'1','138','765',323,'Retail Sale Id 1300180',11840.00,0.00,0.00,0.00,888.00,'2021-12-08 14:11:49','',''),(2207208,'1','138','765',323,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-08 14:11:49','',''),(2207220,'1','138','765',323,'Retail Sale Id 1300187',3852.80,0.00,0.00,0.00,288.96,'2021-12-08 14:13:18','',''),(2207221,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 14:13:18','',''),(2207275,'1','138','765',323,'Retail Sale Id 1300218',30000.00,0.00,0.00,0.00,400.00,'2021-12-08 14:16:34','',''),(2207276,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 14:16:34','',''),(2207315,'1','138','765',323,'Retail Sale Id 1300240',36000.00,0.00,0.00,0.00,480.00,'2021-12-08 14:19:11','',''),(2207316,'1','138','765',323,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-08 14:19:11','',''),(2207393,'1','138','765',323,'Retail Sale Id 1300291',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 14:23:51','',''),(2207394,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 14:23:51','',''),(2207494,'1','138','765',323,'Retail Sale Id 1300331',3852.80,0.00,0.00,0.00,288.96,'2021-12-08 14:28:43','',''),(2207495,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 14:28:43','',''),(2207573,'1','138','765',323,'Return of Retail Sale Id 1298164',0.00,44800.00,70.00,0.00,-3360.00,'2021-12-08 14:31:01','',''),(2207608,'1','138','765',323,'Retail Sale Id 1300365',42000.00,0.00,0.00,0.00,560.00,'2021-12-08 14:32:09','',''),(2207609,'1','138','765',323,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-08 14:32:09','',''),(2207951,'1','138','765',323,'Retail Sale Id 1300554',30000.00,0.00,0.00,0.00,400.00,'2021-12-08 14:51:47','',''),(2207952,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 14:51:47','',''),(2207975,'1','138','765',323,'Retail Sale Id 1300564',6400.00,0.00,0.00,0.00,480.00,'2021-12-08 14:53:18','',''),(2207976,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 14:53:18','',''),(2207999,'1','138','765',323,'Retail Sale Id 1300575',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 14:54:28','',''),(2208000,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 14:54:28','',''),(2208031,'1','138','765',323,'Retail Sale Id 1300591',33000.00,0.00,0.00,0.00,440.00,'2021-12-08 14:57:15','',''),(2208032,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-08 14:57:15','',''),(2208148,'1','138','765',323,'Retail Sale Id 1300640',3852.80,0.00,0.00,0.00,288.96,'2021-12-08 15:06:14','',''),(2208149,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 15:06:14','',''),(2208181,'1','138','765',323,'Retail Sale Id 1300649',7500.80,0.00,0.00,0.00,562.56,'2021-12-08 15:07:39','',''),(2208182,'1','138','765',323,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-08 15:07:39','',''),(2208305,'1','138','765',323,'Retail Sale Id 1300710',100200.00,0.00,0.00,0.00,1336.00,'2021-12-08 15:14:36','',''),(2208306,'1','138','765',323,'Retail sales',0.00,0.00,0.00,167.00,0.00,'2021-12-08 15:14:36','',''),(2208329,'1','138','765',323,'Retail Sale Id 1300721',3852.80,0.00,0.00,0.00,288.96,'2021-12-08 15:16:17','',''),(2208330,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 15:16:17','',''),(2208377,'1','138','765',323,'Retail Sale Id 1300743',6400.00,0.00,0.00,0.00,480.00,'2021-12-08 15:18:26','',''),(2208378,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 15:18:26','',''),(2208528,'1','138','765',323,'Retail Sale Id 1300815',30000.00,0.00,0.00,0.00,400.00,'2021-12-08 15:25:58','',''),(2208529,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 15:25:58','',''),(2208727,'1','138','765',323,'Retail Sale Id 1300919',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 15:36:04','',''),(2208728,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:36:04','',''),(2208767,'1','138','765',323,'Retail Sale Id 1300936',3840.00,0.00,0.00,0.00,288.00,'2021-12-08 15:38:03','',''),(2208770,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:38:03','',''),(2208873,'1','138','765',323,'Retail Sale Id 1300995',1920.00,0.00,0.00,0.00,144.00,'2021-12-08 15:43:14','',''),(2208874,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 15:43:14','',''),(2209063,'1','138','765',323,'Retail Sale Id 1301080',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 15:53:45','',''),(2209064,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:53:45','',''),(2209077,'1','138','765',323,'Retail Sale Id 1301088',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 15:54:58','',''),(2209078,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 15:54:58','',''),(2209175,'1','138','765',323,'Retail Sale Id 1301143',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 16:00:15','',''),(2209176,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:00:15','',''),(2209237,'1','138','765',323,'Retail Sale Id 1301176',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 16:02:55','',''),(2209238,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:02:55','',''),(2209283,'1','138','765',323,'Retail Sale Id 1301198',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 16:05:09','',''),(2209284,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:05:09','',''),(2209428,'1','138','765',323,'Retail Sale Id 1301259',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 16:11:08','',''),(2209429,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:11:08','',''),(2209602,'1','138','765',323,'Retail Sale Id 1301335',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 16:17:23','',''),(2209603,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:17:23','',''),(2209755,'1','138','765',323,'Retail Sale Id 1301418',1920.00,0.00,0.00,0.00,144.00,'2021-12-08 16:25:07','',''),(2209756,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:25:07','',''),(2209796,'1','138','765',323,'Retail Sale Id 1301537',1920.00,0.00,0.00,0.00,144.00,'2021-12-08 16:28:50','',''),(2209797,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:28:50','',''),(2210007,'1','138','765',323,'Retail Sale Id 1301656',204300.00,0.00,0.00,0.00,2724.00,'2021-12-08 16:38:29','',''),(2210008,'1','138','765',323,'Retail sales',0.00,0.00,0.00,340.50,0.00,'2021-12-08 16:38:29','',''),(2210213,'1','138','765',323,'Retail Sale Id 1301759',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 16:48:24','',''),(2210214,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:48:24','',''),(2210243,'1','138','765',323,'Retail Sale Id 1301775',42000.00,0.00,0.00,0.00,560.00,'2021-12-08 16:49:41','',''),(2210244,'1','138','765',323,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-08 16:49:41','',''),(2210292,'1','138','765',323,'Retail Sale Id 1301799',24000.00,0.00,0.00,0.00,320.00,'2021-12-08 16:52:35','',''),(2210293,'1','138','765',323,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-08 16:52:35','',''),(2210344,'1','138','765',323,'Retail Sale Id 1301825',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 16:55:34','',''),(2210345,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:55:34','',''),(2210420,'1','138','765',323,'Retail Sale Id 1301869',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 17:01:20','',''),(2210421,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 17:01:20','',''),(2210523,'1','138','765',323,'Retail Sale Id 1301926',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 17:10:36','',''),(2210524,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 17:10:36','',''),(2210653,'1','138','765',323,'Retail Sale Id 1302004',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 17:22:40','',''),(2210654,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 17:22:40','',''),(2210668,'1','138','765',323,'Retail Sale Id 1302012',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 17:24:17','',''),(2210669,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 17:24:17','',''),(2210763,'1','138','765',323,'Retail Sale Id 1302063',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 17:35:16','',''),(2210764,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 17:35:16','',''),(2210812,'1','138','765',323,'Retail Sale Id 1302093',2560.00,0.00,0.00,0.00,192.00,'2021-12-08 17:41:14','',''),(2210813,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 17:41:14','',''),(2211033,'1','138','765',323,'Retail Sale Id 1302162',35840.00,0.00,0.00,0.00,2688.00,'2021-12-08 18:13:41','',''),(2211034,'1','138','765',323,'Retail sales',0.00,0.00,0.00,56.00,0.00,'2021-12-08 18:13:41','',''),(2211051,'1','138','765',323,'Retail Sale Id 1302171',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 18:17:37','',''),(2211052,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 18:17:37','',''),(2212361,'1','138','765',323,'Retail Sale Id 1302528',72000.00,0.00,0.00,0.00,960.00,'2021-12-09 06:34:40','',''),(2212362,'1','138','765',323,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-09 06:34:40','',''),(2212436,'1','138','765',323,'Retail Sale Id 1302558',120000.00,0.00,0.00,0.00,1600.00,'2021-12-09 06:38:12','',''),(2212437,'1','138','765',323,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-09 06:38:12','',''),(2212595,'1','138','765',323,'Retail Sale Id 1302632',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 06:46:57','',''),(2212596,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 06:46:57','',''),(2212981,'1','138','765',323,'Retail Sale Id 1302809',15001.60,0.00,0.00,0.00,1125.12,'2021-12-09 07:08:41','',''),(2212982,'1','138','765',323,'Retail sales',0.00,0.00,0.00,23.44,0.00,'2021-12-09 07:08:41','',''),(2213428,'1','138','765',323,'Retail Sale Id 1303023',5760.00,0.00,0.00,0.00,432.00,'2021-12-09 07:28:29','',''),(2213429,'1','138','765',323,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-09 07:28:29','',''),(2213460,'1','138','765',323,'Retail Sale Id 1303037',25500.00,0.00,0.00,0.00,340.00,'2021-12-09 07:29:30','',''),(2213461,'1','138','765',323,'Retail sales',0.00,0.00,0.00,42.50,0.00,'2021-12-09 07:29:30','',''),(2213596,'1','138','765',323,'Retail Sale Id 1303102',42000.00,0.00,0.00,0.00,560.00,'2021-12-09 07:36:16','',''),(2213597,'1','138','765',323,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-09 07:36:16','',''),(2213644,'1','138','765',323,'Retail Sale Id 1303127',27000.00,0.00,0.00,0.00,360.00,'2021-12-09 07:38:47','',''),(2213645,'1','138','765',323,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-09 07:38:47','',''),(2213986,'1','138','765',323,'Retail Sale Id 1303287',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 07:55:49','',''),(2213987,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 07:55:49','',''),(2214104,'1','138','765',323,'Retail Sale Id 1303353',7001.60,0.00,0.00,0.00,525.12,'2021-12-09 08:03:48','',''),(2214105,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-09 08:03:48','',''),(2214182,'1','138','765',323,'Retail Sale Id 1303393',4998.40,0.00,0.00,0.00,374.88,'2021-12-09 08:08:00','',''),(2214183,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-09 08:08:00','',''),(2214744,'1','138','765',323,'Retail Sale Id 1303641',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 08:33:42','',''),(2214745,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 08:33:42','',''),(2214909,'1','138','765',323,'Retail Sale Id 1303725',36000.00,0.00,0.00,0.00,480.00,'2021-12-09 08:41:35','',''),(2214910,'1','138','765',323,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-09 08:41:35','',''),(2215204,'1','138','765',323,'Retail Sale Id 1303865',33000.00,0.00,0.00,0.00,440.00,'2021-12-09 08:58:59','',''),(2215205,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-09 08:58:59','',''),(2215261,'1','138','765',323,'Retail Sale Id 1303887',34800.00,0.00,0.00,0.00,464.00,'2021-12-09 09:01:30','',''),(2215262,'1','138','765',323,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-09 09:01:30','',''),(2215319,'1','138','765',323,'Retail Sale Id 1303921',60000.00,0.00,0.00,0.00,800.00,'2021-12-09 09:04:53','',''),(2215320,'1','138','765',323,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-09 09:04:53','',''),(2215527,'1','138','765',323,'Retail Sale Id 1304026',73500.00,0.00,0.00,0.00,980.00,'2021-12-09 09:18:38','',''),(2215528,'1','138','765',323,'Retail sales',0.00,0.00,0.00,122.50,0.00,'2021-12-09 09:18:38','',''),(2215740,'1','138','765',323,'Retail Sale Id 1304137',6000.00,0.00,0.00,0.00,80.00,'2021-12-09 09:29:28','',''),(2215741,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 09:29:28','',''),(2216078,'1','138','765',323,'Retail Sale Id 1304268',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 09:44:54','',''),(2216079,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 09:44:54','',''),(2216147,'1','138','765',323,'Retail Sale Id 1304290',6400.00,0.00,0.00,0.00,480.00,'2021-12-09 09:48:17','',''),(2216148,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 09:48:17','',''),(2216286,'1','138','765',323,'Retail Sale Id 1304353',120000.00,0.00,0.00,0.00,1600.00,'2021-12-09 09:55:07','',''),(2216287,'1','138','765',323,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-09 09:55:07','',''),(2216318,'1','138','765',323,'Retail Sale Id 1304374',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 09:56:33','',''),(2216319,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:56:33','',''),(2216352,'1','138','765',323,'Retail Sale Id 1304390',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 09:57:55','',''),(2216353,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:57:55','',''),(2216563,'1','138','765',323,'Retail Sale Id 1304481',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 10:09:18','',''),(2216564,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 10:09:18','',''),(2216629,'1','138','765',323,'Retail Sale Id 1304525',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 10:14:51','',''),(2216630,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:14:51','',''),(2216747,'1','138','765',323,'Retail Sale Id 1304595',3801.60,0.00,0.00,0.00,285.12,'2021-12-09 10:22:43','',''),(2216748,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-09 10:22:43','',''),(2216963,'1','138','765',323,'Retail Sale Id 1304706',72000.00,0.00,0.00,0.00,960.00,'2021-12-09 10:36:27','',''),(2216964,'1','138','765',323,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-09 10:36:27','',''),(2217010,'1','138','765',323,'Retail Sale Id 1304729',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 10:40:23','',''),(2217011,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 10:40:23','',''),(2217072,'1','138','765',323,'Retail Sale Id 1304764',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 10:43:53','',''),(2217073,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 10:43:53','',''),(2217277,'1','138','765',323,'Retail Sale Id 1304866',128400.00,0.00,0.00,0.00,1712.00,'2021-12-09 10:57:44','',''),(2217278,'1','138','765',323,'Retail sales',0.00,0.00,0.00,214.00,0.00,'2021-12-09 10:57:44','',''),(2217293,'1','138','765',323,'Retail Sale Id 1304875',36000.00,0.00,0.00,0.00,480.00,'2021-12-09 10:58:52','',''),(2217294,'1','138','765',323,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-09 10:58:52','',''),(2217325,'1','138','765',323,'Retail Sale Id 1304890',4998.40,0.00,0.00,0.00,374.88,'2021-12-09 11:00:47','',''),(2217326,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-09 11:00:47','',''),(2217358,'1','138','765',323,'Retail Sale Id 1304905',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 11:02:52','',''),(2217359,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:02:52','',''),(2217394,'1','138','765',323,'Retail Sale Id 1304925',625204.00,0.00,0.00,0.00,4196.00,'2021-12-09 11:05:16','',''),(2217395,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1049.00,0.00,'2021-12-09 11:05:16','',''),(2217426,'1','138','765',323,'Retail Sale Id 1304943',49800.00,0.00,0.00,0.00,664.00,'2021-12-09 11:07:05','',''),(2217427,'1','138','765',323,'Retail sales',0.00,0.00,0.00,83.00,0.00,'2021-12-09 11:07:05','',''),(2217673,'1','138','765',323,'Retail Sale Id 1305059',16000.00,0.00,0.00,0.00,1200.00,'2021-12-09 11:23:07','',''),(2217674,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-09 11:23:07','',''),(2217965,'1','138','765',323,'Return of Retail Sale Id 1305059',0.00,16000.00,25.00,0.00,-1200.00,'2021-12-09 11:41:57','',''),(2217992,'1','138','765',323,'Retail Sale Id 1305210',8960.00,0.00,0.00,0.00,672.00,'2021-12-09 11:44:00','',''),(2217993,'1','138','765',323,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-09 11:44:00','',''),(2218511,'1','138','765',323,'Distributed to OPERATIONAL LOSS for sales id:338208',142080.00,0.00,0.00,240.00,0.00,'2021-12-09 12:15:41','',''),(2218610,'1','138','765',323,'Distributed to OPERATIONAL LOSS for sales id:338209',128552.80,0.00,0.00,217.15,0.00,'2021-12-09 12:22:27','',''),(2219417,'1','138',NULL,323,'Purchased from AA RANO NIGERIA LIMITED',0.00,14800000.00,25000.00,0.00,0.00,'2021-12-09 13:10:56','',''),(2219456,'1','138',NULL,323,'Reception corrector for bridging 126736',0.00,0.00,0.00,25000.00,0.00,'2021-12-09 13:12:43','',''),(2219457,'1','138','765',323,'Received from bridging 126736',0.00,0.00,25000.00,0.00,0.00,'2021-12-09 13:12:43','',''),(2219607,'1','138','765',323,'Retail Sale Id 1306028',1920.00,0.00,0.00,0.00,144.00,'2021-12-09 13:25:28','',''),(2219608,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 13:25:28','',''),(2219996,'1','138','765',323,'Retail Sale Id 1306154',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 13:42:49','',''),(2219997,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 13:42:49','',''),(2220066,'1','138','765',323,'Retail Sale Id 1306194',3840.00,0.00,0.00,0.00,288.00,'2021-12-09 13:47:47','',''),(2220067,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 13:47:47','',''),(2220102,'1','138','765',323,'Retail Sale Id 1306206',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 13:49:43','',''),(2220103,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 13:49:43','',''),(2220128,'1','138','765',323,'Retail Sale Id 1306220',12800.00,0.00,0.00,0.00,960.00,'2021-12-09 13:51:36','',''),(2220129,'1','138','765',323,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-09 13:51:36','',''),(2220162,'1','138','765',323,'Retail Sale Id 1306239',4998.40,0.00,0.00,0.00,374.88,'2021-12-09 13:54:18','',''),(2220163,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-09 13:54:18','',''),(2220203,'1','138','765',323,'Retail Sale Id 1306260',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 13:56:36','',''),(2220204,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 13:56:36','',''),(2220223,'1','138','765',323,'Return of Retail Sale Id 1306260',0.00,3852.80,6.02,0.00,-288.96,'2021-12-09 13:58:27','',''),(2220224,'1','138','765',323,'Retail Sale Id 1306272',3897.60,0.00,0.00,0.00,292.32,'2021-12-09 13:58:49','',''),(2220225,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-09 13:58:49','',''),(2220431,'1','138','765',323,'Retail Sale Id 1306355',66600.00,0.00,0.00,0.00,888.00,'2021-12-09 14:11:40','',''),(2220432,'1','138','765',323,'Retail sales',0.00,0.00,0.00,111.00,0.00,'2021-12-09 14:11:40','',''),(2220512,'1','138','765',323,'Retail Sale Id 1306430',16998.00,0.00,0.00,0.00,226.64,'2021-12-09 14:16:28','',''),(2220513,'1','138','765',323,'Retail sales',0.00,0.00,0.00,28.33,0.00,'2021-12-09 14:16:28','',''),(2220829,'1','138','765',323,'Retail Sale Id 1306589',3840.00,0.00,0.00,0.00,288.00,'2021-12-09 14:33:16','',''),(2220830,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 14:33:16','',''),(2220903,'1','138','765',323,'Retail Sale Id 1306605',3897.60,0.00,0.00,0.00,292.32,'2021-12-09 14:35:50','',''),(2220904,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-09 14:35:50','',''),(2221008,'1','138','765',323,'Retail Sale Id 1306668',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 14:39:57','',''),(2221009,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:39:57','',''),(2221254,'1','138','765',323,'Retail Sale Id 1306769',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 14:49:51','',''),(2221255,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:49:51','',''),(2221321,'1','138','765',323,'Retail Sale Id 1306782',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 14:51:40','',''),(2221322,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:51:40','',''),(2221384,'1','138','765',323,'Retail Sale Id 1306807',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 14:54:47','',''),(2221385,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:54:47','',''),(2221480,'1','138','765',323,'Retail Sale Id 1306847',33000.00,0.00,0.00,0.00,440.00,'2021-12-09 14:59:29','',''),(2221481,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-09 14:59:29','',''),(2221562,'1','138','765',323,'Retail Sale Id 1306890',22080.00,0.00,0.00,0.00,1656.00,'2021-12-09 15:04:18','',''),(2221563,'1','138','765',323,'Retail sales',0.00,0.00,0.00,34.50,0.00,'2021-12-09 15:04:18','',''),(2222198,'1','138','765',323,'Retail Sale Id 1307219',39000.00,0.00,0.00,0.00,520.00,'2021-12-09 15:35:47','',''),(2222199,'1','138','765',323,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-09 15:35:47','',''),(2222238,'1','138','765',323,'Retail Sale Id 1307240',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 15:38:08','',''),(2222239,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 15:38:08','',''),(2222286,'1','138','765',323,'Retail Sale Id 1307259',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 15:39:44','',''),(2222287,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:39:44','',''),(2222656,'1','138','765',323,'Retail Sale Id 1307442',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 16:00:45','',''),(2222657,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:00:45','',''),(2222688,'1','138','765',323,'Retail Sale Id 1307458',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 16:02:41','',''),(2222689,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:02:41','',''),(2222959,'1','138','765',323,'Retail Sale Id 1307595',6400.00,0.00,0.00,0.00,480.00,'2021-12-09 16:16:30','',''),(2222960,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 16:16:30','',''),(2222961,'1','138','765',323,'Retail Sale Id 1307595',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 16:16:30','',''),(2222962,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:16:30','',''),(2222995,'1','138','765',323,'Retail Sale Id 1307616',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 16:18:27','',''),(2222996,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:18:27','',''),(2223101,'1','138','765',323,'Retail Sale Id 1307664',9600.00,0.00,0.00,0.00,720.00,'2021-12-09 16:25:03','',''),(2223102,'1','138','765',323,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-09 16:25:03','',''),(2223152,'1','138','765',323,'Retail Sale Id 1307682',16000.00,0.00,0.00,0.00,1200.00,'2021-12-09 16:26:42','',''),(2223153,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-09 16:26:42','',''),(2223190,'1','138','765',323,'Retail Sale Id 1307700',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 16:28:26','',''),(2223191,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:28:26','',''),(2223212,'1','138','765',323,'Retail Sale Id 1307711',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 16:29:39','',''),(2223213,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:29:39','',''),(2223232,'1','138','765',323,'Retail Sale Id 1307721',120000.00,0.00,0.00,0.00,1600.00,'2021-12-09 16:31:14','',''),(2223233,'1','138','765',323,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-09 16:31:14','',''),(2223268,'1','138','765',323,'Retail Sale Id 1307738',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 16:33:06','',''),(2223269,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:33:06','',''),(2223316,'1','138','765',323,'Retail Sale Id 1307761',6400.00,0.00,0.00,0.00,480.00,'2021-12-09 16:35:33','',''),(2223317,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 16:35:33','',''),(2223318,'1','138','765',323,'Retail Sale Id 1307761',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 16:35:33','',''),(2223319,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:35:33','',''),(2223346,'1','138','765',323,'Retail Sale Id 1307776',3897.60,0.00,0.00,0.00,292.32,'2021-12-09 16:37:27','',''),(2223347,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-09 16:37:27','',''),(2223389,'1','138','765',323,'Retail Sale Id 1307792',15000.00,0.00,0.00,0.00,200.00,'2021-12-09 16:39:53','',''),(2223390,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-09 16:39:53','',''),(2223570,'1','138','765',323,'Retail Sale Id 1307858',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 16:48:23','',''),(2223571,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 16:48:23','',''),(2224122,'1','138','765',323,'Retail Sale Id 1308128',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 17:33:44','',''),(2224123,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 17:33:44','',''),(2224207,'1','138','765',323,'Retail Sale Id 1308178',24960.00,0.00,0.00,0.00,1872.00,'2021-12-09 17:50:47','',''),(2224208,'1','138','765',323,'Retail sales',0.00,0.00,0.00,39.00,0.00,'2021-12-09 17:50:47','',''),(2224261,'1','138','765',323,'Retail Sale Id 1308194',329100.00,0.00,0.00,0.00,4388.00,'2021-12-09 17:56:46','',''),(2224262,'1','138','765',323,'Retail sales',0.00,0.00,0.00,548.50,0.00,'2021-12-09 17:56:46','',''),(2225176,'1','138','765',323,'Retail Sale Id 1308397',3200.00,0.00,0.00,0.00,240.00,'2021-12-10 06:14:23','',''),(2225177,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 06:14:23','',''),(2225231,'1','138','765',323,'Return of Retail Sale Id 1308397',0.00,3200.00,5.00,0.00,-240.00,'2021-12-10 06:20:12','',''),(2225260,'1','138','765',323,'Retail Sale Id 1308435',3160.00,0.00,0.00,0.00,0.00,'2021-12-10 06:22:43','',''),(2225261,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 06:22:43','',''),(2225325,'1','138','765',323,'Retail Sale Id 1308464',3798.32,0.00,0.00,0.00,0.00,'2021-12-10 06:28:03','',''),(2225326,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 06:28:03','',''),(2225417,'1','138','765',323,'Retail Sale Id 1308508',3197.92,0.00,0.00,0.00,0.00,'2021-12-10 06:35:45','',''),(2225418,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 06:35:45','',''),(2225896,'1','138','765',323,'Retail Sale Id 1308743',29400.00,0.00,0.00,0.00,-2200.00,'2021-12-10 07:09:05','',''),(2225897,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 07:09:05','',''),(2225918,'1','138','765',323,'Retail Sale Id 1308754',31752.00,0.00,0.00,0.00,-2376.00,'2021-12-10 07:10:13','',''),(2225919,'1','138','765',323,'Retail sales',0.00,0.00,0.00,54.00,0.00,'2021-12-10 07:10:13','',''),(2226026,'1','138','765',323,'Retail Sale Id 1308813',145824.00,0.00,0.00,0.00,-10912.00,'2021-12-10 07:16:38','',''),(2226027,'1','138','765',323,'Retail sales',0.00,0.00,0.00,248.00,0.00,'2021-12-10 07:16:38','',''),(2226220,'1','138','765',323,'Retail Sale Id 1308908',1997.12,0.00,0.00,0.00,0.00,'2021-12-10 07:26:41','',''),(2226221,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 07:26:41','',''),(2226509,'1','138','765',323,'Retail Sale Id 1309045',1902.32,0.00,0.00,0.00,0.00,'2021-12-10 07:42:25','',''),(2226510,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 07:42:25','',''),(2226587,'1','138','765',323,'Retail Sale Id 1309084',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 07:47:45','',''),(2226588,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 07:47:45','',''),(2226749,'1','138','765',323,'Retail Sale Id 1309155',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 07:55:00','',''),(2226750,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 07:55:00','',''),(2227132,'1','138','765',323,'Retail Sale Id 1309295',11760.00,0.00,0.00,0.00,-880.00,'2021-12-10 08:12:32','',''),(2227133,'1','138','765',323,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-10 08:12:32','',''),(2227219,'1','138','765',323,'Retail Sale Id 1309331',32340.00,0.00,0.00,0.00,-2420.00,'2021-12-10 08:16:38','',''),(2227220,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-10 08:16:38','',''),(2227441,'1','138','765',323,'Retail Sale Id 1309419',1497.84,0.00,0.00,0.00,0.00,'2021-12-10 08:25:52','',''),(2227442,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 08:25:52','',''),(2227517,'1','138','765',323,'Retail Sale Id 1309470',3798.32,0.00,0.00,0.00,0.00,'2021-12-10 08:30:23','',''),(2227518,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 08:30:23','',''),(2227920,'1','138','765',323,'Retail Sale Id 1309656',3160.00,0.00,0.00,0.00,0.00,'2021-12-10 08:48:59','',''),(2227921,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 08:48:59','',''),(2227976,'1','138','765',323,'Retail Sale Id 1309685',45504.00,0.00,0.00,0.00,0.00,'2021-12-10 08:51:36','',''),(2227977,'1','138','765',323,'Retail sales',0.00,0.00,0.00,72.00,0.00,'2021-12-10 08:51:36','',''),(2228057,'1','138','765',323,'Retail Sale Id 1309719',6952.00,0.00,0.00,0.00,0.00,'2021-12-10 08:55:28','',''),(2228058,'1','138','765',323,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-10 08:55:28','',''),(2228071,'1','138','765',323,'Return of Retail Sale Id 1309685',0.00,45504.00,72.00,0.00,0.00,'2021-12-10 08:56:21','',''),(2228088,'1','138','765',323,'Retail Sale Id 1309737',22436.00,0.00,0.00,0.00,0.00,'2021-12-10 08:57:18','',''),(2228089,'1','138','765',323,'Retail sales',0.00,0.00,0.00,35.50,0.00,'2021-12-10 08:57:18','',''),(2228188,'1','138','765',323,'Retail Sale Id 1309785',15800.00,0.00,0.00,0.00,0.00,'2021-12-10 09:00:55','',''),(2228189,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 09:00:55','',''),(2228250,'1','138','765',323,'Retail Sale Id 1309818',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 09:03:37','',''),(2228251,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 09:03:37','',''),(2228939,'1','138','765',323,'Retail Sale Id 1310141',20580.00,0.00,0.00,0.00,-1540.00,'2021-12-10 09:44:01','',''),(2228940,'1','138','765',323,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-10 09:44:01','',''),(2228969,'1','138','765',323,'Retail Sale Id 1310164',14700.00,0.00,0.00,0.00,-1100.00,'2021-12-10 09:45:26','',''),(2228970,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 09:45:26','',''),(2229089,'1','138','765',323,'Retail Sale Id 1310219',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 09:52:43','',''),(2229090,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 09:52:43','',''),(2229229,'1','138','765',323,'Retail Sale Id 1310288',3197.92,0.00,0.00,0.00,0.00,'2021-12-10 10:01:13','',''),(2229230,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 10:01:13','',''),(2229369,'1','138','765',323,'Retail Sale Id 1310348',29400.00,0.00,0.00,0.00,-2200.00,'2021-12-10 10:09:26','',''),(2229370,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 10:09:26','',''),(2229607,'1','138','765',323,'Retail Sale Id 1310460',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 10:21:19','',''),(2229608,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 10:21:19','',''),(2229717,'1','138','765',323,'Retail Sale Id 1310503',58800.00,0.00,0.00,0.00,-4400.00,'2021-12-10 10:26:47','',''),(2229718,'1','138','765',323,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 10:26:47','',''),(2229725,'1','138','765',323,'Retail Sale Id 1310513',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 10:27:46','',''),(2229726,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 10:27:46','',''),(2229757,'1','138','765',323,'Retail Sale Id 1310528',17640.00,0.00,0.00,0.00,-1320.00,'2021-12-10 10:29:32','',''),(2229758,'1','138','765',323,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-10 10:29:32','',''),(2229862,'1','138','765',323,'Retail Sale Id 1310573',6351.60,0.00,0.00,0.00,0.00,'2021-12-10 10:36:05','',''),(2229863,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.05,0.00,'2021-12-10 10:36:05','',''),(2230043,'1','138','765',323,'Retail Sale Id 1310341',82908.00,0.00,0.00,0.00,-6204.00,'2021-12-10 10:47:26','',''),(2230044,'1','138','765',323,'Retail sales',0.00,0.00,0.00,141.00,0.00,'2021-12-10 10:47:26','',''),(2230244,'1','138','765',323,'Retail Sale Id 1310749',88200.00,0.00,0.00,0.00,-6600.00,'2021-12-10 10:58:00','',''),(2230245,'1','138','765',323,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-10 10:58:00','',''),(2230398,'1','138','765',323,'Retail Sale Id 1310815',31600.00,0.00,0.00,0.00,0.00,'2021-12-10 11:05:42','',''),(2230399,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 11:05:42','',''),(2230757,'1','138','765',323,'Retail Sale Id 1310952',90552.00,0.00,0.00,0.00,-6776.00,'2021-12-10 11:26:51','',''),(2230758,'1','138','765',323,'Retail sales',0.00,0.00,0.00,154.00,0.00,'2021-12-10 11:26:51','',''),(2230795,'1','138','765',323,'Retail Sale Id 1310968',34104.00,0.00,0.00,0.00,-2552.00,'2021-12-10 11:30:24','',''),(2230796,'1','138','765',323,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-10 11:30:24','',''),(2230981,'1','138','765',323,'Retail Sale Id 1311075',3798.32,0.00,0.00,0.00,0.00,'2021-12-10 11:43:23','',''),(2230982,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 11:43:23','',''),(2231127,'1','138','765',323,'Retail Sale Id 1311152',41160.00,0.00,0.00,0.00,-3080.00,'2021-12-10 11:55:03','',''),(2231128,'1','138','765',323,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-10 11:55:03','',''),(2231149,'1','138','765',323,'Retail Sale Id 1311165',7002.56,0.00,0.00,0.00,0.00,'2021-12-10 11:56:10','',''),(2231150,'1','138','765',323,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-10 11:56:10','',''),(2231493,'1','138','765',323,'Retail Sale Id 1311338',3798.32,0.00,0.00,0.00,0.00,'2021-12-10 12:22:23','',''),(2231494,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 12:22:23','',''),(2231507,'1','138','765',323,'Retail Sale Id 1311345',1264.00,0.00,0.00,0.00,0.00,'2021-12-10 12:23:42','',''),(2231508,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 12:23:42','',''),(2231562,'1','138','765',323,'Retail Sale Id 1311373',26460.00,0.00,0.00,0.00,-1980.00,'2021-12-10 12:27:31','',''),(2231563,'1','138','765',323,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-10 12:27:31','',''),(2231602,'1','138','765',323,'Retail Sale Id 1311397',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 12:33:21','',''),(2231603,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 12:33:21','',''),(2231634,'1','138','765',323,'Retail Sale Id 1311414',38220.00,0.00,0.00,0.00,-2860.00,'2021-12-10 12:36:42','',''),(2231635,'1','138','765',323,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-10 12:36:42','',''),(2231694,'1','138','765',323,'Retail Sale Id 1311456',190512.00,0.00,0.00,0.00,-14256.00,'2021-12-10 12:42:15','',''),(2231695,'1','138','765',323,'Retail sales',0.00,0.00,0.00,324.00,0.00,'2021-12-10 12:42:15','',''),(2231769,'1','138','765',323,'Retail Sale Id 1311486',7002.56,0.00,0.00,0.00,0.00,'2021-12-10 12:47:48','',''),(2231770,'1','138','765',323,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-10 12:47:48','',''),(2231884,'1','138','765',323,'Retail Sale Id 1311544',15800.00,0.00,0.00,0.00,0.00,'2021-12-10 12:55:35','',''),(2231885,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 12:55:35','',''),(2232046,'1','138','765',323,'Retail Sale Id 1311630',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 13:07:13','',''),(2232047,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:07:13','',''),(2232141,'1','138','765',323,'Retail Sale Id 1311665',613784.00,0.00,0.00,0.00,-50448.00,'2021-12-10 13:12:04','',''),(2232142,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1051.00,0.00,'2021-12-10 13:12:04','',''),(2232290,'1','138','765',323,'Retail Sale Id 1311724',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 13:19:58','',''),(2232291,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:19:58','',''),(2232391,'1','138','765',323,'Retail Sale Id 1311772',5700.64,0.00,0.00,0.00,0.00,'2021-12-10 13:27:13','',''),(2232392,'1','138','765',323,'Retail sales',0.00,0.00,0.00,9.02,0.00,'2021-12-10 13:27:13','',''),(2232426,'1','138','765',323,'Retail Sale Id 1311789',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 13:30:05','',''),(2232427,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:30:05','',''),(2232448,'1','138','765',323,'Retail Sale Id 1311814',3197.92,0.00,0.00,0.00,0.00,'2021-12-10 13:31:46','',''),(2232449,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 13:31:46','',''),(2232527,'1','138','765',323,'Retail Sale Id 1311851',1997.12,0.00,0.00,0.00,0.00,'2021-12-10 13:35:31','',''),(2232528,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 13:35:31','',''),(2232807,'1','138','765',323,'Retail Sale Id 1311962',58800.00,0.00,0.00,0.00,-4400.00,'2021-12-10 13:47:26','',''),(2232808,'1','138','765',323,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 13:47:26','',''),(2232833,'1','138','765',323,'Retail Sale Id 1311980',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 13:49:18','',''),(2232834,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:49:18','',''),(2232853,'1','138','765',323,'Retail Sale Id 1311988',194040.00,0.00,0.00,0.00,-14520.00,'2021-12-10 13:50:36','',''),(2232854,'1','138','765',323,'Retail sales',0.00,0.00,0.00,330.00,0.00,'2021-12-10 13:50:36','',''),(2232901,'1','138','765',323,'Retail Sale Id 1312010',34104.00,0.00,0.00,0.00,-2552.00,'2021-12-10 13:53:05','',''),(2232902,'1','138','765',323,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-10 13:53:05','',''),(2232929,'1','138','765',323,'Retail Sale Id 1312020',29400.00,0.00,0.00,0.00,-2200.00,'2021-12-10 13:54:07','',''),(2232930,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 13:54:07','',''),(2232977,'1','138','765',323,'Retail Sale Id 1312042',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 13:56:40','',''),(2232978,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:56:40','',''),(2233009,'1','138','765',323,'Retail Sale Id 1312056',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 13:57:49','',''),(2233010,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:57:49','',''),(2233099,'1','138','765',323,'Retail Sale Id 1312087',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 14:01:27','',''),(2233100,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:01:27','',''),(2233181,'1','138','765',323,'Retail Sale Id 1312113',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 14:03:50','',''),(2233182,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:03:50','',''),(2233223,'1','138','765',323,'Retail Sale Id 1312131',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 14:06:38','',''),(2233224,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:06:38','',''),(2233261,'1','138','765',323,'Retail Sale Id 1312145',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 14:08:45','',''),(2233262,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:08:45','',''),(2233293,'1','138','765',323,'Retail Sale Id 1312161',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 14:11:51','',''),(2233294,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:11:51','',''),(2233317,'1','138','765',323,'Retail Sale Id 1312176',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 14:13:17','',''),(2233318,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:13:17','',''),(2233475,'1','138','765',323,'Retail Sale Id 1312253',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 14:21:11','',''),(2233476,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:21:11','',''),(2233711,'1','138','765',323,'Retail Sale Id 1312344',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 14:30:10','',''),(2233712,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:30:10','',''),(2233921,'1','138','765',323,'Retail Sale Id 1312432',41160.00,0.00,0.00,0.00,-3080.00,'2021-12-10 14:39:14','',''),(2233922,'1','138','765',323,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-10 14:39:14','',''),(2234179,'1','138','765',323,'Retail Sale Id 1312544',235200.00,0.00,0.00,0.00,-17600.00,'2021-12-10 14:49:04','',''),(2234180,'1','138','765',323,'Retail sales',0.00,0.00,0.00,400.00,0.00,'2021-12-10 14:49:04','',''),(2234256,'1','138','765',323,'Retail Sale Id 1312586',161700.00,0.00,0.00,0.00,-12100.00,'2021-12-10 14:52:55','',''),(2234257,'1','138','765',323,'Retail sales',0.00,0.00,0.00,275.00,0.00,'2021-12-10 14:52:55','',''),(2234320,'1','138','765',323,'Retail Sale Id 1312615',3160.00,0.00,0.00,0.00,0.00,'2021-12-10 14:55:50','',''),(2234321,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 14:55:50','',''),(2234332,'1','138','765',323,'Retail Sale Id 1312622',1902.32,0.00,0.00,0.00,0.00,'2021-12-10 14:56:59','',''),(2234333,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 14:56:59','',''),(2234777,'1','138','765',323,'Retail Sale Id 1312844',70560.00,0.00,0.00,0.00,-5280.00,'2021-12-10 15:18:56','',''),(2234778,'1','138','765',323,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-10 15:18:56','',''),(2234894,'1','138','765',323,'Retail Sale Id 1312907',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 15:23:27','',''),(2234895,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:23:27','',''),(2235000,'1','138','765',323,'Retail Sale Id 1312961',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 15:27:16','',''),(2235001,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:27:16','',''),(2235093,'1','138','765',323,'Retail Sale Id 1312983',117600.00,0.00,0.00,0.00,-8800.00,'2021-12-10 15:29:22','',''),(2235094,'1','138','765',323,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-10 15:29:22','',''),(2235131,'1','138','765',323,'Retail Sale Id 1313006',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 15:31:26','',''),(2235132,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:31:26','',''),(2235193,'1','138','765',323,'Retail Sale Id 1313036',58800.00,0.00,0.00,0.00,-4400.00,'2021-12-10 15:34:02','',''),(2235194,'1','138','765',323,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 15:34:02','',''),(2235233,'1','138','765',323,'Retail Sale Id 1313056',117600.00,0.00,0.00,0.00,-8800.00,'2021-12-10 15:36:07','',''),(2235234,'1','138','765',323,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-10 15:36:07','',''),(2235363,'1','138','765',323,'Retail Sale Id 1313113',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 15:41:22','',''),(2235364,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:41:22','',''),(2235407,'1','138','765',323,'Retail Sale Id 1313135',34104.00,0.00,0.00,0.00,-2552.00,'2021-12-10 15:43:04','',''),(2235408,'1','138','765',323,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-10 15:43:04','',''),(2235425,'1','138','765',323,'Retail Sale Id 1313149',32340.00,0.00,0.00,0.00,-2420.00,'2021-12-10 15:43:51','',''),(2235426,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-10 15:43:51','',''),(2235503,'1','138','765',323,'Retail Sale Id 1313197',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 15:47:40','',''),(2235504,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:47:40','',''),(2235527,'1','138','765',323,'Retail Sale Id 1313213',176400.00,0.00,0.00,0.00,-13200.00,'2021-12-10 15:49:05','',''),(2235528,'1','138','765',323,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-10 15:49:05','',''),(2235548,'1','138','765',323,'Retail Sale Id 1313226',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 15:50:08','',''),(2235549,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:50:08','',''),(2235630,'1','138','765',323,'Retail Sale Id 1313273',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 15:54:27','',''),(2235631,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:54:27','',''),(2235722,'1','138','765',323,'Retail Sale Id 1313304',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 15:58:37','',''),(2235723,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:58:37','',''),(2235784,'1','138','765',323,'Retail Sale Id 1313348',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 16:00:50','',''),(2235785,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:00:50','',''),(2235810,'1','138','765',323,'Retail Sale Id 1313362',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 16:02:34','',''),(2235811,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:02:34','',''),(2235846,'1','138','765',323,'Retail Sale Id 1313381',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 16:04:28','',''),(2235847,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:04:28','',''),(2236108,'1','138','765',323,'Retail Sale Id 1313501',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 16:15:59','',''),(2236109,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:15:59','',''),(2236146,'1','138','765',323,'Retail Sale Id 1313520',1997.12,0.00,0.00,0.00,0.00,'2021-12-10 16:17:47','',''),(2236147,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 16:17:47','',''),(2236156,'1','138','765',323,'Retail Sale Id 1313530',3792.00,0.00,0.00,0.00,0.00,'2021-12-10 16:18:34','',''),(2236157,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 16:18:34','',''),(2236215,'1','138','765',323,'Retail Sale Id 1313563',3197.92,0.00,0.00,0.00,0.00,'2021-12-10 16:20:43','',''),(2236216,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 16:20:43','',''),(2236245,'1','138','765',323,'Retail Sale Id 1313581',3798.32,0.00,0.00,0.00,0.00,'2021-12-10 16:22:01','',''),(2236246,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 16:22:01','',''),(2236359,'1','138','765',323,'Retail Sale Id 1313635',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 16:26:38','',''),(2236360,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:26:38','',''),(2236387,'1','138','765',323,'Retail Sale Id 1313650',1497.84,0.00,0.00,0.00,0.00,'2021-12-10 16:27:48','',''),(2236388,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 16:27:48','',''),(2236447,'1','138','765',323,'Retail Sale Id 1313677',3197.92,0.00,0.00,0.00,0.00,'2021-12-10 16:30:49','',''),(2236448,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 16:30:49','',''),(2236706,'1','138','765',323,'Retail Sale Id 1313789',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 16:43:30','',''),(2236707,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:43:30','',''),(2236754,'1','138','765',323,'Retail Sale Id 1313817',1902.32,0.00,0.00,0.00,0.00,'2021-12-10 16:46:28','',''),(2236755,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 16:46:28','',''),(2237152,'1','138','765',323,'Retail Sale Id 1314013',9480.00,0.00,0.00,0.00,0.00,'2021-12-10 17:12:32','',''),(2237153,'1','138','765',323,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-10 17:12:32','',''),(2237160,'1','138','765',323,'Retail Sale Id 1314018',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 17:14:09','',''),(2237161,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 17:14:09','',''),(2237162,'1','138','765',323,'Retail Sale Id 1314018',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 17:14:09','',''),(2237163,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 17:14:09','',''),(2237204,'1','138','765',323,'Retail Sale Id 1314040',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 17:17:25','',''),(2237205,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 17:17:25','',''),(2237258,'1','138','765',323,'Retail Sale Id 1314068',29400.00,0.00,0.00,0.00,-2200.00,'2021-12-10 17:22:20','',''),(2237259,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 17:22:20','',''),(2237288,'1','138','765',323,'Retail Sale Id 1314077',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 17:24:53','',''),(2237289,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 17:24:53','',''),(2237353,'1','138','765',323,'Retail Sale Id 1314095',5997.68,0.00,0.00,0.00,0.00,'2021-12-10 17:29:21','',''),(2237354,'1','138','765',323,'Retail sales',0.00,0.00,0.00,9.49,0.00,'2021-12-10 17:29:21','',''),(2237399,'1','138','765',323,'Retail Sale Id 1314108',29400.00,0.00,0.00,0.00,-2200.00,'2021-12-10 17:33:59','',''),(2237400,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 17:33:59','',''),(2237411,'1','138','765',323,'Retail Sale Id 1314114',8001.12,0.00,0.00,0.00,0.00,'2021-12-10 17:35:27','',''),(2237412,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.66,0.00,'2021-12-10 17:35:27','',''),(2237441,'1','138','765',323,'Retail Sale Id 1314128',651160.00,0.00,0.00,0.00,-53520.00,'2021-12-10 17:38:16','',''),(2237442,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1115.00,0.00,'2021-12-10 17:38:16','',''),(2237463,'1','138','765',323,'Retail Sale Id 1314135',1705.20,0.00,0.00,0.00,-127.60,'2021-12-10 17:39:42','',''),(2237464,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-10 17:39:42','',''),(2237504,'1','138','765',323,'Retail Sale Id 1314160',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 17:44:44','',''),(2237505,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 17:44:44','',''),(2237514,'1','138','765',323,'Retail Sale Id 1314172',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 17:46:05','',''),(2237515,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 17:46:05','',''),(2237530,'1','138','765',323,'Retail Sale Id 1314177',9802.32,0.00,0.00,0.00,0.00,'2021-12-10 17:47:21','',''),(2237531,'1','138','765',323,'Retail sales',0.00,0.00,0.00,15.51,0.00,'2021-12-10 17:47:21','',''),(2238417,'1','138','765',323,'Retail Sale Id 1314431',1301.92,0.00,0.00,0.00,0.00,'2021-12-11 06:01:18','',''),(2238418,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-11 06:01:18','',''),(2238840,'1','138','765',323,'Retail Sale Id 1314591',40572.00,0.00,0.00,0.00,-3036.00,'2021-12-11 06:34:46','',''),(2238841,'1','138','765',323,'Retail sales',0.00,0.00,0.00,69.00,0.00,'2021-12-11 06:34:46','',''),(2238922,'1','138','765',323,'Retail Sale Id 1314634',104076.00,0.00,0.00,0.00,-7788.00,'2021-12-11 06:40:33','',''),(2238923,'1','138','765',323,'Retail sales',0.00,0.00,0.00,177.00,0.00,'2021-12-11 06:40:33','',''),(2239302,'1','138','765',323,'Retail Sale Id 1314834',3697.20,0.00,0.00,0.00,0.00,'2021-12-11 07:05:02','',''),(2239303,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.85,0.00,'2021-12-11 07:05:02','',''),(2239320,'1','138','765',323,'Retail Sale Id 1314843',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 07:06:32','',''),(2239321,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:06:32','',''),(2239483,'1','138','765',323,'Retail Sale Id 1314931',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 07:16:43','',''),(2239484,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:16:43','',''),(2239503,'1','138','765',323,'Retail Sale Id 1314939',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 07:17:41','',''),(2239504,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:17:41','',''),(2239827,'1','138','765',323,'Retail Sale Id 1315119',1497.84,0.00,0.00,0.00,0.00,'2021-12-11 07:34:47','',''),(2239828,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-11 07:34:47','',''),(2239897,'1','138','765',323,'Retail Sale Id 1315164',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 07:38:56','',''),(2239898,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:38:56','',''),(2240022,'1','138','765',323,'Retail Sale Id 1315228',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 07:45:26','',''),(2240023,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:45:26','',''),(2240062,'1','138','765',323,'Retail Sale Id 1315249',3798.32,0.00,0.00,0.00,0.00,'2021-12-11 07:47:14','',''),(2240063,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 07:47:14','',''),(2240317,'1','138','765',323,'Retail Sale Id 1315357',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 07:56:46','',''),(2240318,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:56:46','',''),(2240379,'1','138','765',323,'Retail Sale Id 1315393',1497.84,0.00,0.00,0.00,0.00,'2021-12-11 07:59:24','',''),(2240380,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-11 07:59:24','',''),(2240593,'1','138','765',323,'Retail Sale Id 1315464',31600.00,0.00,0.00,0.00,0.00,'2021-12-11 08:08:19','',''),(2240594,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 08:08:19','',''),(2240650,'1','138','765',323,'Retail Sale Id 1315485',12640.00,0.00,0.00,0.00,0.00,'2021-12-11 08:10:47','',''),(2240651,'1','138','765',323,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-11 08:10:47','',''),(2240848,'1','138','765',323,'Retail Sale Id 1315594',12640.00,0.00,0.00,0.00,0.00,'2021-12-11 08:20:24','',''),(2240849,'1','138','765',323,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-11 08:20:24','',''),(2240906,'1','138','765',323,'Retail Sale Id 1315628',29400.00,0.00,0.00,0.00,-2200.00,'2021-12-11 08:23:03','',''),(2240907,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 08:23:03','',''),(2240934,'1','138','765',323,'Retail Sale Id 1315643',38220.00,0.00,0.00,0.00,-2860.00,'2021-12-11 08:25:00','',''),(2240935,'1','138','765',323,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-11 08:25:00','',''),(2241066,'1','138','765',323,'Retail Sale Id 1315703',35280.00,0.00,0.00,0.00,-2640.00,'2021-12-11 08:31:44','',''),(2241067,'1','138','765',323,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-11 08:31:44','',''),(2241461,'1','138','765',323,'Retail Sale Id 1315877',34104.00,0.00,0.00,0.00,-2552.00,'2021-12-11 08:50:30','',''),(2241462,'1','138','765',323,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-11 08:50:30','',''),(2241640,'1','138','765',323,'Retail Sale Id 1315951',99960.00,0.00,0.00,0.00,-7480.00,'2021-12-11 08:58:11','',''),(2241641,'1','138','765',323,'Retail sales',0.00,0.00,0.00,170.00,0.00,'2021-12-11 08:58:11','',''),(2241654,'1','138','765',323,'Retail Sale Id 1315959',1997.12,0.00,0.00,0.00,0.00,'2021-12-11 08:59:04','',''),(2241655,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 08:59:04','',''),(2241830,'1','138','765',323,'Retail Sale Id 1316047',6320.00,0.00,0.00,0.00,0.00,'2021-12-11 09:06:05','',''),(2241831,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 09:06:05','',''),(2242024,'1','138','765',323,'Retail Sale Id 1316140',1902.32,0.00,0.00,0.00,0.00,'2021-12-11 09:14:22','',''),(2242025,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 09:14:22','',''),(2242054,'1','138','765',323,'Retail Sale Id 1316152',3197.92,0.00,0.00,0.00,0.00,'2021-12-11 09:15:36','',''),(2242055,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 09:15:36','',''),(2242072,'1','138','765',323,'Retail Sale Id 1316175',3798.32,0.00,0.00,0.00,0.00,'2021-12-11 09:16:47','',''),(2242073,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 09:16:47','',''),(2242160,'1','138','765',323,'Retail Sale Id 1316202',4499.84,0.00,0.00,0.00,0.00,'2021-12-11 09:20:40','',''),(2242161,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.12,0.00,'2021-12-11 09:20:40','',''),(2242211,'1','138','765',323,'Retail Sale Id 1316225',12008.00,0.00,0.00,0.00,0.00,'2021-12-11 09:22:55','',''),(2242212,'1','138','765',323,'Retail sales',0.00,0.00,0.00,19.00,0.00,'2021-12-11 09:22:55','',''),(2242319,'1','138','765',323,'Retail Sale Id 1316280',26701.08,0.00,0.00,0.00,-1998.04,'2021-12-11 09:29:55','',''),(2242320,'1','138','765',323,'Retail sales',0.00,0.00,0.00,45.41,0.00,'2021-12-11 09:29:55','',''),(2242345,'1','138','765',323,'Retail Sale Id 1316294',58800.00,0.00,0.00,0.00,-4400.00,'2021-12-11 09:31:18','',''),(2242346,'1','138','765',323,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-11 09:31:18','',''),(2242378,'1','138','765',323,'Retail Sale Id 1316312',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 09:32:30','',''),(2242379,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:32:30','',''),(2242412,'1','138','765',323,'Retail Sale Id 1316328',3197.92,0.00,0.00,0.00,0.00,'2021-12-11 09:34:17','',''),(2242413,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 09:34:17','',''),(2242446,'1','138','765',323,'Retail Sale Id 1316343',8001.12,0.00,0.00,0.00,0.00,'2021-12-11 09:35:44','',''),(2242447,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.66,0.00,'2021-12-11 09:35:44','',''),(2242464,'1','138','765',323,'Retail Sale Id 1316356',4000.56,0.00,0.00,0.00,0.00,'2021-12-11 09:36:53','',''),(2242465,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-11 09:36:53','',''),(2242506,'1','138','765',323,'Retail Sale Id 1316378',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 09:38:32','',''),(2242507,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:38:32','',''),(2242548,'1','138','765',323,'Retail Sale Id 1316403',3798.32,0.00,0.00,0.00,0.00,'2021-12-11 09:40:15','',''),(2242549,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 09:40:15','',''),(2242730,'1','138','765',323,'Retail Sale Id 1316492',98490.00,0.00,0.00,0.00,-7370.00,'2021-12-11 09:48:38','',''),(2242731,'1','138','765',323,'Retail sales',0.00,0.00,0.00,167.50,0.00,'2021-12-11 09:48:38','',''),(2242790,'1','138','765',323,'Retail Sale Id 1316518',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 09:51:20','',''),(2242791,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:51:20','',''),(2242850,'1','138','765',323,'Retail Sale Id 1316550',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 09:55:15','',''),(2242851,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:55:15','',''),(2242882,'1','138','765',323,'Retail Sale Id 1316565',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 09:56:54','',''),(2242883,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:56:54','',''),(2242918,'1','138','765',323,'Retail Sale Id 1316577',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 09:58:30','',''),(2242919,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:58:30','',''),(2242963,'1','138','765',323,'Retail Sale Id 1316601',15168.00,0.00,0.00,0.00,0.00,'2021-12-11 10:00:36','',''),(2242964,'1','138','765',323,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-11 10:00:36','',''),(2243084,'1','138','765',323,'Retail Sale Id 1316659',3798.32,0.00,0.00,0.00,0.00,'2021-12-11 10:06:56','',''),(2243085,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 10:06:56','',''),(2243086,'1','138','765',323,'Retail Sale Id 1316659',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 10:06:56','',''),(2243087,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 10:06:56','',''),(2243184,'1','138','765',323,'Retail Sale Id 1316683',92904.00,0.00,0.00,0.00,-6952.00,'2021-12-11 10:10:38','',''),(2243185,'1','138','765',323,'Retail sales',0.00,0.00,0.00,158.00,0.00,'2021-12-11 10:10:38','',''),(2243196,'1','138','765',323,'Return of Retail Sale Id 1316683',0.00,92904.00,158.00,0.00,6952.00,'2021-12-11 10:11:14','',''),(2243215,'1','138','765',323,'Retail Sale Id 1316704',34104.00,0.00,0.00,0.00,-2552.00,'2021-12-11 10:12:24','',''),(2243216,'1','138','765',323,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-11 10:12:24','',''),(2243790,'1','138','765',323,'Retail Sale Id 1316972',93492.00,0.00,0.00,0.00,-6996.00,'2021-12-11 10:41:30','',''),(2243791,'1','138','765',323,'Retail sales',0.00,0.00,0.00,159.00,0.00,'2021-12-11 10:41:30','',''),(2243890,'1','138','765',323,'Retail Sale Id 1317022',86436.00,0.00,0.00,0.00,-6468.00,'2021-12-11 10:46:22','',''),(2243891,'1','138','765',323,'Retail sales',0.00,0.00,0.00,147.00,0.00,'2021-12-11 10:46:22','',''),(2244046,'1','138','765',323,'Retail Sale Id 1317104',15800.00,0.00,0.00,0.00,0.00,'2021-12-11 10:55:55','',''),(2244047,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-11 10:55:55','',''),(2244115,'1','138','765',323,'Retail Sale Id 1317134',1902.32,0.00,0.00,0.00,0.00,'2021-12-11 10:59:18','',''),(2244116,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 10:59:18','',''),(2244117,'1','138','765',323,'Retail Sale Id 1317134',15800.00,0.00,0.00,0.00,0.00,'2021-12-11 10:59:18','',''),(2244118,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-11 10:59:18','',''),(2244192,'1','138','765',323,'Retail Sale Id 1317161',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 11:02:03','',''),(2244193,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:02:03','',''),(2244249,'1','138','765',323,'Retail Sale Id 1317186',39984.00,0.00,0.00,0.00,-2992.00,'2021-12-11 11:04:23','',''),(2244250,'1','138','765',323,'Retail sales',0.00,0.00,0.00,68.00,0.00,'2021-12-11 11:04:23','',''),(2244303,'1','138','765',323,'Retail Sale Id 1317214',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 11:07:39','',''),(2244304,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:07:39','',''),(2244417,'1','138','765',323,'Retail Sale Id 1317271',47040.00,0.00,0.00,0.00,-3520.00,'2021-12-11 11:13:31','',''),(2244418,'1','138','765',323,'Retail sales',0.00,0.00,0.00,80.00,0.00,'2021-12-11 11:13:31','',''),(2244515,'1','138','765',323,'Retail Sale Id 1317318',264600.00,0.00,0.00,0.00,-19800.00,'2021-12-11 11:18:36','',''),(2244516,'1','138','765',323,'Retail sales',0.00,0.00,0.00,450.00,0.00,'2021-12-11 11:18:36','',''),(2244547,'1','138','765',323,'Return of Retail Sale Id 1317318',0.00,264600.00,450.00,0.00,19800.00,'2021-12-11 11:20:17','',''),(2244568,'1','138','765',323,'Retail Sale Id 1317347',117600.00,0.00,0.00,0.00,-8800.00,'2021-12-11 11:21:16','',''),(2244569,'1','138','765',323,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-11 11:21:16','',''),(2244636,'1','138','765',323,'Retail Sale Id 1317376',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 11:24:23','',''),(2244637,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:24:23','',''),(2244724,'1','138','765',323,'Retail Sale Id 1317413',33927.60,0.00,0.00,0.00,-2538.80,'2021-12-11 11:28:05','',''),(2244725,'1','138','765',323,'Retail sales',0.00,0.00,0.00,57.70,0.00,'2021-12-11 11:28:05','',''),(2244792,'1','138','765',323,'Retail Sale Id 1317445',29400.00,0.00,0.00,0.00,-2200.00,'2021-12-11 11:32:02','',''),(2244793,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 11:32:02','',''),(2244828,'1','138','765',323,'Retail Sale Id 1317473',3002.00,0.00,0.00,0.00,0.00,'2021-12-11 11:34:36','',''),(2244829,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 11:34:36','',''),(2244902,'1','138','765',323,'Retail Sale Id 1317514',15800.00,0.00,0.00,0.00,0.00,'2021-12-11 11:39:15','',''),(2244903,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-11 11:39:15','',''),(2244951,'1','138','765',323,'Retail Sale Id 1317547',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 11:42:00','',''),(2244952,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:42:00','',''),(2244987,'1','138','765',323,'Retail Sale Id 1317564',2528.00,0.00,0.00,0.00,0.00,'2021-12-11 11:44:28','',''),(2244988,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 11:44:28','',''),(2245005,'1','138','765',323,'Retail Sale Id 1317575',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 11:46:12','',''),(2245006,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:46:12','',''),(2245083,'1','138','765',323,'Retail Sale Id 1317606',462168.00,0.00,0.00,0.00,-34584.00,'2021-12-11 11:50:31','',''),(2245084,'1','138','765',323,'Retail sales',0.00,0.00,0.00,786.00,0.00,'2021-12-11 11:50:31','',''),(2245170,'1','138','765',323,'Retail Sale Id 1317653',29400.00,0.00,0.00,0.00,-2200.00,'2021-12-11 11:55:29','',''),(2245171,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 11:55:29','',''),(2245236,'1','138','765',323,'Retail Sale Id 1317687',58800.00,0.00,0.00,0.00,-4400.00,'2021-12-11 11:58:58','',''),(2245237,'1','138','765',323,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-11 11:58:58','',''),(2245507,'1','138','765',323,'Retail Sale Id 1317875',414540.00,0.00,0.00,0.00,-31020.00,'2021-12-11 12:17:37','',''),(2245508,'1','138','765',323,'Retail sales',0.00,0.00,0.00,705.00,0.00,'2021-12-11 12:17:37','',''),(2245573,'1','138','765',323,'Retail Sale Id 1317911',25001.92,0.00,0.00,0.00,0.00,'2021-12-11 12:20:53','',''),(2245574,'1','138','765',323,'Retail sales',0.00,0.00,0.00,39.56,0.00,'2021-12-11 12:20:53','',''),(2245941,'1','138','765',323,'Retail Sale Id 1318087',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 12:42:43','',''),(2245942,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 12:42:43','',''),(2246005,'1','138','765',323,'Retail Sale Id 1318120',31600.00,0.00,0.00,0.00,0.00,'2021-12-11 12:47:23','',''),(2246006,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 12:47:23','',''),(2246029,'1','138','765',323,'Retail Sale Id 1318134',4000.56,0.00,0.00,0.00,0.00,'2021-12-11 12:50:01','',''),(2246030,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-11 12:50:01','',''),(2246104,'1','138','765',323,'Retail Sale Id 1318156',158760.00,0.00,0.00,0.00,-11880.00,'2021-12-11 12:55:03','',''),(2246105,'1','138','765',323,'Retail sales',0.00,0.00,0.00,270.00,0.00,'2021-12-11 12:55:03','',''),(2246188,'1','138','765',323,'Retail Sale Id 1318215',4116.00,0.00,0.00,0.00,-308.00,'2021-12-11 13:00:59','',''),(2246189,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-11 13:00:59','',''),(2246268,'1','138','765',323,'Retail Sale Id 1318261',20002.80,0.00,0.00,0.00,0.00,'2021-12-11 13:07:09','',''),(2246269,'1','138','765',323,'Retail sales',0.00,0.00,0.00,31.65,0.00,'2021-12-11 13:07:09','',''),(2246302,'1','138','765',323,'Retail Sale Id 1318279',58800.00,0.00,0.00,0.00,-4400.00,'2021-12-11 13:11:09','',''),(2246303,'1','138','765',323,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-11 13:11:09','',''),(2246348,'1','138','765',323,'Retail Sale Id 1318307',32340.00,0.00,0.00,0.00,-2420.00,'2021-12-11 13:14:28','',''),(2246349,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-11 13:14:28','',''),(2246652,'1','138','765',323,'Retail Sale Id 1318434',36750.00,0.00,0.00,0.00,-2750.00,'2021-12-11 13:32:47','',''),(2246653,'1','138','765',323,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-11 13:32:47','',''),(2246708,'1','138','765',323,'Retail Sale Id 1318449',4202.80,0.00,0.00,0.00,0.00,'2021-12-11 13:35:12','',''),(2246709,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.65,0.00,'2021-12-11 13:35:12','',''),(2246763,'1','138','765',323,'Retail Sale Id 1318471',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 13:38:53','',''),(2246764,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 13:38:53','',''),(2246788,'1','138','765',323,'Retail Sale Id 1318483',12640.00,0.00,0.00,0.00,0.00,'2021-12-11 13:40:31','',''),(2246789,'1','138','765',323,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-11 13:40:31','',''),(2246812,'1','138','765',323,'Retail Sale Id 1318495',29400.00,0.00,0.00,0.00,-2200.00,'2021-12-11 13:43:15','',''),(2246813,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 13:43:15','',''),(2247065,'1','138','765',323,'Retail Sale Id 1318623',15800.00,0.00,0.00,0.00,0.00,'2021-12-11 14:00:11','',''),(2247066,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-11 14:00:11','',''),(2247095,'1','138','765',323,'Retail Sale Id 1318641',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 14:01:48','',''),(2247096,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 14:01:48','',''),(2247150,'1','138','765',323,'Retail Sale Id 1318667',35280.00,0.00,0.00,0.00,-2640.00,'2021-12-11 14:06:01','',''),(2247151,'1','138','765',323,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-11 14:06:01','',''),(2247190,'1','138','765',323,'Retail Sale Id 1318685',29400.00,0.00,0.00,0.00,-2200.00,'2021-12-11 14:08:28','',''),(2247191,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 14:08:28','',''),(2247341,'1','138','765',323,'Retail Sale Id 1318758',85260.00,0.00,0.00,0.00,-6380.00,'2021-12-11 14:16:07','',''),(2247342,'1','138','765',323,'Retail sales',0.00,0.00,0.00,145.00,0.00,'2021-12-11 14:16:07','',''),(2247742,'1','138','765',323,'Retail Sale Id 1318974',1497.84,0.00,0.00,0.00,0.00,'2021-12-11 14:43:13','',''),(2247743,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-11 14:43:13','',''),(2247814,'1','138','765',323,'Retail Sale Id 1319010',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 14:47:41','',''),(2247815,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 14:47:41','',''),(2248007,'1','138','765',323,'Retail Sale Id 1319108',3798.32,0.00,0.00,0.00,0.00,'2021-12-11 14:58:14','',''),(2248008,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 14:58:14','',''),(2248153,'1','138','765',323,'Retail Sale Id 1319175',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 15:06:57','',''),(2248154,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 15:06:57','',''),(2248237,'1','138','765',323,'Retail Sale Id 1319197',20286.00,0.00,0.00,0.00,-1518.00,'2021-12-11 15:09:23','',''),(2248238,'1','138','765',323,'Retail sales',0.00,0.00,0.00,34.50,0.00,'2021-12-11 15:09:23','',''),(2248414,'1','138','765',323,'Retail Sale Id 1319274',10800.88,0.00,0.00,0.00,0.00,'2021-12-11 15:17:43','',''),(2248415,'1','138','765',323,'Retail sales',0.00,0.00,0.00,17.09,0.00,'2021-12-11 15:17:43','',''),(2248472,'1','138','765',323,'Retail Sale Id 1319311',3792.00,0.00,0.00,0.00,0.00,'2021-12-11 15:21:15','',''),(2248473,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 15:21:15','',''),(2249202,'1','138','765',323,'Retail Sale Id 1319673',41160.00,0.00,0.00,0.00,-3080.00,'2021-12-11 15:56:12','',''),(2249203,'1','138','765',323,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-11 15:56:12','',''),(2249273,'1','138','765',323,'Retail Sale Id 1319699',3798.32,0.00,0.00,0.00,0.00,'2021-12-11 15:58:45','',''),(2249274,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 15:58:45','',''),(2249699,'1','138','765',323,'Retail Sale Id 1319954',88200.00,0.00,0.00,0.00,-6600.00,'2021-12-11 16:19:40','',''),(2249700,'1','138','765',323,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-11 16:19:40','',''),(2249729,'1','138','765',323,'Retail Sale Id 1319966',3792.00,0.00,0.00,0.00,0.00,'2021-12-11 16:21:49','',''),(2249730,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 16:21:49','',''),(2249770,'1','138','765',323,'Retail Sale Id 1319986',1902.32,0.00,0.00,0.00,0.00,'2021-12-11 16:23:18','',''),(2249771,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 16:23:18','',''),(2249804,'1','138','765',323,'Retail Sale Id 1320005',29400.00,0.00,0.00,0.00,-2200.00,'2021-12-11 16:25:44','',''),(2249805,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 16:25:44','',''),(2249872,'1','138','765',323,'Retail Sale Id 1320035',3798.32,0.00,0.00,0.00,0.00,'2021-12-11 16:29:43','',''),(2249873,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 16:29:43','',''),(2250023,'1','138','765',323,'Retail Sale Id 1320077',57036.00,0.00,0.00,0.00,-4268.00,'2021-12-11 16:36:19','',''),(2250024,'1','138','765',323,'Retail sales',0.00,0.00,0.00,97.00,0.00,'2021-12-11 16:36:19','',''),(2250158,'1','138','765',323,'Retail Sale Id 1320142',3197.92,0.00,0.00,0.00,0.00,'2021-12-11 16:42:32','',''),(2250159,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 16:42:32','',''),(2250198,'1','138','765',323,'Retail Sale Id 1320162',3792.00,0.00,0.00,0.00,0.00,'2021-12-11 16:46:16','',''),(2250199,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 16:46:16','',''),(2250496,'1','138','765',323,'Retail Sale Id 1320292',3792.00,0.00,0.00,0.00,0.00,'2021-12-11 17:02:44','',''),(2250497,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 17:02:44','',''),(2250528,'1','138','765',323,'Retail Sale Id 1320306',601520.00,0.00,0.00,0.00,-49440.00,'2021-12-11 17:04:07','',''),(2250529,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1030.00,0.00,'2021-12-11 17:04:07','',''),(2250588,'1','138','765',323,'Retail Sale Id 1320334',35280.00,0.00,0.00,0.00,-2640.00,'2021-12-11 17:08:56','',''),(2250589,'1','138','765',323,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-11 17:08:56','',''),(2250634,'1','138','765',323,'Retail Sale Id 1320367',33516.00,0.00,0.00,0.00,-2508.00,'2021-12-11 17:13:36','',''),(2250635,'1','138','765',323,'Retail sales',0.00,0.00,0.00,57.00,0.00,'2021-12-11 17:13:36','',''),(2250656,'1','138','765',323,'Retail Sale Id 1320376',4000.56,0.00,0.00,0.00,0.00,'2021-12-11 17:15:42','',''),(2250657,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-11 17:15:42','',''),(2250674,'1','138','765',323,'Retail Sale Id 1320385',3160.00,0.00,0.00,0.00,0.00,'2021-12-11 17:17:28','',''),(2250675,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 17:17:28','',''),(2250694,'1','138','765',323,'Retail Sale Id 1320396',1902.32,0.00,0.00,0.00,0.00,'2021-12-11 17:19:27','',''),(2250695,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 17:19:27','',''),(2250712,'1','138','765',323,'Retail Sale Id 1320404',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 17:21:05','',''),(2250713,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 17:21:05','',''),(2250806,'1','138','765',323,'Retail Sale Id 1320447',998.56,0.00,0.00,0.00,0.00,'2021-12-11 17:28:22','',''),(2250807,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 17:28:22','',''),(2250835,'1','138','765',323,'Retail Sale Id 1320463',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 17:30:44','',''),(2250836,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 17:30:44','',''),(2250845,'1','138','765',323,'Return of Retail Sale Id 1320463',0.00,7900.00,12.50,0.00,0.00,'2021-12-11 17:31:33','',''),(2250860,'1','138','765',323,'Retail Sale Id 1320476',3798.32,0.00,0.00,0.00,0.00,'2021-12-11 17:32:19','',''),(2250861,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 17:32:19','',''),(2250908,'1','138','765',323,'Retail Sale Id 1320498',147000.00,0.00,0.00,0.00,-11000.00,'2021-12-11 17:37:06','',''),(2250909,'1','138','765',323,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-11 17:37:06','',''),(2250945,'1','138','765',323,'Retail Sale Id 1320511',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 17:39:24','',''),(2250946,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 17:39:24','',''),(2250961,'1','138','765',323,'Retail Sale Id 1320520',3798.32,0.00,0.00,0.00,0.00,'2021-12-11 17:40:35','',''),(2250962,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 17:40:35','',''),(2251209,'1','138','765',323,'Retail Sale Id 1320622',868408.00,0.00,0.00,0.00,-71376.00,'2021-12-11 18:04:47','',''),(2251210,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1487.00,0.00,'2021-12-11 18:04:47','',''),(2251307,'1','138','765',323,'Retail Sale Id 1320651',7002.56,0.00,0.00,0.00,0.00,'2021-12-11 18:14:01','',''),(2251308,'1','138','765',323,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-11 18:14:01','',''),(2251356,'1','138','765',323,'Retail Sale Id 1320668',4999.12,0.00,0.00,0.00,0.00,'2021-12-11 18:19:03','',''),(2251357,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-11 18:19:03','',''),(2251398,'1','138','765',323,'Return of Retail Sale Id 1320520',0.00,3798.32,6.01,0.00,0.00,'2021-12-11 18:28:36','',''),(2252210,'1','138','765',323,'Retail Sale Id 1320897',147000.00,0.00,0.00,0.00,-11000.00,'2021-12-12 06:29:32','',''),(2252211,'1','138','765',323,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-12 06:29:32','',''),(2252366,'1','138','765',323,'Retail Sale Id 1320957',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 06:37:57','',''),(2252367,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 06:37:57','',''),(2252446,'1','138','765',323,'Retail Sale Id 1320991',35280.00,0.00,0.00,0.00,-2640.00,'2021-12-12 06:43:35','',''),(2252447,'1','138','765',323,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-12 06:43:35','',''),(2252520,'1','138','765',323,'Retail Sale Id 1321016',7002.56,0.00,0.00,0.00,0.00,'2021-12-12 06:47:12','',''),(2252521,'1','138','765',323,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-12 06:47:12','',''),(2252697,'1','138','765',323,'Retail Sale Id 1321082',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 06:58:04','',''),(2252698,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 06:58:04','',''),(2252753,'1','138','765',323,'Retail Sale Id 1321113',20580.00,0.00,0.00,0.00,-1540.00,'2021-12-12 07:03:16','',''),(2252754,'1','138','765',323,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-12 07:03:16','',''),(2252767,'1','138','765',323,'Retail Sale Id 1321117',14700.00,0.00,0.00,0.00,-1100.00,'2021-12-12 07:04:15','',''),(2252768,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-12 07:04:15','',''),(2252791,'1','138','765',323,'Retail Sale Id 1321130',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 07:06:39','',''),(2252792,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 07:06:39','',''),(2252819,'1','138','765',323,'Retail Sale Id 1321145',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 07:08:11','',''),(2252820,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 07:08:11','',''),(2252966,'1','138','765',323,'Retail Sale Id 1321218',3798.32,0.00,0.00,0.00,0.00,'2021-12-12 07:19:09','',''),(2252967,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 07:19:09','',''),(2253018,'1','138','765',323,'Retail Sale Id 1321245',4499.84,0.00,0.00,0.00,0.00,'2021-12-12 07:22:55','',''),(2253019,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.12,0.00,'2021-12-12 07:22:55','',''),(2253302,'1','138','765',323,'Retail Sale Id 1321406',58800.00,0.00,0.00,0.00,-4400.00,'2021-12-12 07:41:11','',''),(2253303,'1','138','765',323,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-12 07:41:11','',''),(2253634,'1','138','765',323,'Retail Sale Id 1321580',3197.92,0.00,0.00,0.00,0.00,'2021-12-12 08:02:18','',''),(2253635,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 08:02:18','',''),(2253666,'1','138','765',323,'Retail Sale Id 1321600',3798.32,0.00,0.00,0.00,0.00,'2021-12-12 08:04:59','',''),(2253667,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 08:04:59','',''),(2253857,'1','138','765',323,'Retail Sale Id 1321694',44100.00,0.00,0.00,0.00,-3300.00,'2021-12-12 08:16:56','',''),(2253858,'1','138','765',323,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-12 08:16:56','',''),(2253911,'1','138','765',323,'Retail Sale Id 1321722',1301.92,0.00,0.00,0.00,0.00,'2021-12-12 08:20:42','',''),(2253912,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 08:20:42','',''),(2253971,'1','138','765',323,'Retail Sale Id 1321746',35280.00,0.00,0.00,0.00,-2640.00,'2021-12-12 08:24:22','',''),(2253972,'1','138','765',323,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-12 08:24:22','',''),(2254063,'1','138','765',323,'Retail Sale Id 1321798',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 08:31:39','',''),(2254064,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 08:31:39','',''),(2254170,'1','138','765',323,'Retail Sale Id 1321855',7002.56,0.00,0.00,0.00,0.00,'2021-12-12 08:38:11','',''),(2254171,'1','138','765',323,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-12 08:38:11','',''),(2254172,'1','138','765',323,'Retail Sale Id 1321855',7002.56,0.00,0.00,0.00,0.00,'2021-12-12 08:38:11','',''),(2254173,'1','138','765',323,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-12 08:38:11','',''),(2254174,'1','138','765',323,'Retail Sale Id 1321855',7002.56,0.00,0.00,0.00,0.00,'2021-12-12 08:38:11','',''),(2254175,'1','138','765',323,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-12 08:38:11','',''),(2254200,'1','138','765',323,'Retail Sale Id 1321870',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 08:39:49','',''),(2254201,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 08:39:49','',''),(2254235,'1','138','765',323,'Retail Sale Id 1321887',32340.00,0.00,0.00,0.00,-2420.00,'2021-12-12 08:41:47','',''),(2254236,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-12 08:41:47','',''),(2254263,'1','138','765',323,'Retail Sale Id 1321893',29400.00,0.00,0.00,0.00,-2200.00,'2021-12-12 08:42:46','',''),(2254264,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 08:42:46','',''),(2254320,'1','138','765',323,'Retail Sale Id 1321922',35280.00,0.00,0.00,0.00,-2640.00,'2021-12-12 08:46:03','',''),(2254321,'1','138','765',323,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-12 08:46:03','',''),(2254366,'1','138','765',323,'Retail Sale Id 1321946',41160.00,0.00,0.00,0.00,-3080.00,'2021-12-12 08:48:48','',''),(2254367,'1','138','765',323,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-12 08:48:48','',''),(2254464,'1','138','765',323,'Retail Sale Id 1321987',64680.00,0.00,0.00,0.00,-4840.00,'2021-12-12 08:54:19','',''),(2254465,'1','138','765',323,'Retail sales',0.00,0.00,0.00,110.00,0.00,'2021-12-12 08:54:19','',''),(2254536,'1','138','765',323,'Retail Sale Id 1322021',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 08:58:22','',''),(2254537,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 08:58:22','',''),(2254596,'1','138','765',323,'Retail Sale Id 1322052',3798.32,0.00,0.00,0.00,0.00,'2021-12-12 09:01:59','',''),(2254597,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 09:01:59','',''),(2254673,'1','138','765',323,'Retail Sale Id 1322093',32340.00,0.00,0.00,0.00,-2420.00,'2021-12-12 09:06:09','',''),(2254674,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-12 09:06:09','',''),(2254717,'1','138','765',323,'Retail Sale Id 1322115',15800.00,0.00,0.00,0.00,0.00,'2021-12-12 09:08:36','',''),(2254718,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-12 09:08:36','',''),(2254741,'1','138','765',323,'Retail Sale Id 1322130',3798.32,0.00,0.00,0.00,0.00,'2021-12-12 09:10:04','',''),(2254742,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 09:10:04','',''),(2254781,'1','138','765',323,'Retail Sale Id 1322146',41454.00,0.00,0.00,0.00,-3102.00,'2021-12-12 09:11:35','',''),(2254782,'1','138','765',323,'Retail sales',0.00,0.00,0.00,70.50,0.00,'2021-12-12 09:11:35','',''),(2254853,'1','138','765',323,'Retail Sale Id 1322181',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 09:15:15','',''),(2254854,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:15:15','',''),(2254899,'1','138','765',323,'Retail Sale Id 1322210',1580.00,0.00,0.00,0.00,0.00,'2021-12-12 09:18:08','',''),(2254900,'1','138','765',323,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-12 09:18:08','',''),(2254957,'1','138','765',323,'Retail Sale Id 1322234',6320.00,0.00,0.00,0.00,0.00,'2021-12-12 09:20:57','',''),(2254958,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-12 09:20:57','',''),(2255098,'1','138','765',323,'Retail Sale Id 1322305',6636.00,0.00,0.00,0.00,0.00,'2021-12-12 09:30:26','',''),(2255099,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.50,0.00,'2021-12-12 09:30:26','',''),(2255100,'1','138','765',323,'Retail Sale Id 1322305',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 09:30:26','',''),(2255101,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:30:26','',''),(2255321,'1','138','765',323,'Retail Sale Id 1322416',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 09:44:31','',''),(2255322,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:44:31','',''),(2255575,'1','138','765',323,'Retail Sale Id 1322529',117600.00,0.00,0.00,0.00,-8800.00,'2021-12-12 09:55:58','',''),(2255576,'1','138','765',323,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-12 09:55:58','',''),(2255684,'1','138','765',323,'Retail Sale Id 1322578',88200.00,0.00,0.00,0.00,-6600.00,'2021-12-12 10:00:51','',''),(2255685,'1','138','765',323,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-12 10:00:51','',''),(2255771,'1','138','765',323,'Retail Sale Id 1322613',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 10:04:26','',''),(2255772,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:04:26','',''),(2255878,'1','138','765',323,'Retail Sale Id 1322674',3197.92,0.00,0.00,0.00,0.00,'2021-12-12 10:09:55','',''),(2255879,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 10:09:55','',''),(2255902,'1','138','765',323,'Retail Sale Id 1322685',1902.32,0.00,0.00,0.00,0.00,'2021-12-12 10:11:30','',''),(2255903,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 10:11:30','',''),(2255966,'1','138','765',323,'Retail Sale Id 1322711',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 10:14:06','',''),(2255967,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:14:06','',''),(2256028,'1','138','765',323,'Retail Sale Id 1322755',3197.92,0.00,0.00,0.00,0.00,'2021-12-12 10:16:59','',''),(2256029,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 10:16:59','',''),(2256057,'1','138','765',323,'Retail Sale Id 1322770',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 10:18:52','',''),(2256058,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:18:52','',''),(2256103,'1','138','765',323,'Retail Sale Id 1322793',108192.00,0.00,0.00,0.00,-8096.00,'2021-12-12 10:22:35','',''),(2256104,'1','138','765',323,'Retail sales',0.00,0.00,0.00,184.00,0.00,'2021-12-12 10:22:35','',''),(2256113,'1','138','765',323,'Retail Sale Id 1322802',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 10:23:20','',''),(2256116,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:23:21','',''),(2256157,'1','138','765',323,'Retail Sale Id 1322824',9480.00,0.00,0.00,0.00,0.00,'2021-12-12 10:25:30','',''),(2256158,'1','138','765',323,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-12 10:25:30','',''),(2256241,'1','138','765',323,'Retail Sale Id 1322870',3197.92,0.00,0.00,0.00,0.00,'2021-12-12 10:30:13','',''),(2256242,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 10:30:13','',''),(2256275,'1','138','765',323,'Retail Sale Id 1322889',36456.00,0.00,0.00,0.00,-2728.00,'2021-12-12 10:31:26','',''),(2256276,'1','138','765',323,'Retail sales',0.00,0.00,0.00,62.00,0.00,'2021-12-12 10:31:26','',''),(2256315,'1','138','765',323,'Retail Sale Id 1322905',3197.92,0.00,0.00,0.00,0.00,'2021-12-12 10:33:37','',''),(2256316,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 10:33:37','',''),(2256317,'1','138','765',323,'Retail Sale Id 1322905',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 10:33:37','',''),(2256318,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:33:37','',''),(2256341,'1','138','765',323,'Retail Sale Id 1322922',1902.32,0.00,0.00,0.00,0.00,'2021-12-12 10:34:41','',''),(2256342,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 10:34:41','',''),(2256751,'1','138','765',323,'Retail Sale Id 1323129',15800.00,0.00,0.00,0.00,0.00,'2021-12-12 10:54:37','',''),(2256752,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-12 10:54:37','',''),(2256781,'1','138','765',323,'Retail Sale Id 1323145',3798.32,0.00,0.00,0.00,0.00,'2021-12-12 10:55:59','',''),(2256782,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 10:55:59','',''),(2256905,'1','138','765',323,'Retail Sale Id 1323210',4000.56,0.00,0.00,0.00,0.00,'2021-12-12 11:00:49','',''),(2256906,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-12 11:00:49','',''),(2256940,'1','138','765',323,'Retail Sale Id 1323221',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 11:01:51','',''),(2256941,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:01:51','',''),(2256964,'1','138','765',323,'Retail Sale Id 1323235',3798.32,0.00,0.00,0.00,0.00,'2021-12-12 11:03:03','',''),(2256965,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 11:03:03','',''),(2256966,'1','138','765',323,'Retail Sale Id 1323235',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 11:03:03','',''),(2256967,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:03:03','',''),(2257054,'1','138','765',323,'Retail Sale Id 1323279',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 11:06:49','',''),(2257055,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:06:49','',''),(2257345,'1','138','765',323,'Retail Sale Id 1323429',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 11:18:24','',''),(2257346,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:18:24','',''),(2257556,'1','138','765',323,'Retail Sale Id 1323523',3798.32,0.00,0.00,0.00,0.00,'2021-12-12 11:27:48','',''),(2257557,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 11:27:48','',''),(2257558,'1','138','765',323,'Retail Sale Id 1323523',6320.00,0.00,0.00,0.00,0.00,'2021-12-12 11:27:48','',''),(2257559,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-12 11:27:48','',''),(2257759,'1','138','765',323,'Retail Sale Id 1323645',14700.00,0.00,0.00,0.00,-1100.00,'2021-12-12 11:37:58','',''),(2257760,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-12 11:37:58','',''),(2257796,'1','138','765',323,'Retail Sale Id 1323661',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 11:39:45','',''),(2257797,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:39:45','',''),(2257834,'1','138','765',323,'Retail Sale Id 1323676',3002.00,0.00,0.00,0.00,0.00,'2021-12-12 11:41:04','',''),(2257835,'1','138','765',323,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 11:41:04','',''),(2257977,'1','138','765',323,'Retail Sale Id 1323745',14997.36,0.00,0.00,0.00,0.00,'2021-12-12 11:48:02','',''),(2257978,'1','138','765',323,'Retail sales',0.00,0.00,0.00,23.73,0.00,'2021-12-12 11:48:02','',''),(2258016,'1','138','765',323,'Retail Sale Id 1323763',26460.00,0.00,0.00,0.00,-1980.00,'2021-12-12 11:50:01','',''),(2258017,'1','138','765',323,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-12 11:50:01','',''),(2258042,'1','138','765',323,'Retail Sale Id 1323776',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 11:51:08','',''),(2258043,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:51:08','',''),(2258086,'1','138','765',323,'Retail Sale Id 1323796',1902.32,0.00,0.00,0.00,0.00,'2021-12-12 11:52:39','',''),(2258087,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 11:52:39','',''),(2258360,'1','138','765',323,'Retail Sale Id 1323929',176400.00,0.00,0.00,0.00,-13200.00,'2021-12-12 12:07:49','',''),(2258361,'1','138','765',323,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-12 12:07:49','',''),(2258448,'1','138','765',323,'Retail Sale Id 1323972',3798.32,0.00,0.00,0.00,0.00,'2021-12-12 12:12:42','',''),(2258449,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 12:12:42','',''),(2258450,'1','138','765',323,'Retail Sale Id 1323972',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 12:12:42','',''),(2258451,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 12:12:42','',''),(2258486,'1','138','765',323,'Retail Sale Id 1323988',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 12:14:16','',''),(2258487,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 12:14:16','',''),(2258528,'1','138','765',323,'Retail Sale Id 1324007',3197.92,0.00,0.00,0.00,0.00,'2021-12-12 12:16:13','',''),(2258529,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 12:16:13','',''),(2258592,'1','138','765',323,'Retail Sale Id 1324039',1997.12,0.00,0.00,0.00,0.00,'2021-12-12 12:18:59','',''),(2258593,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 12:18:59','',''),(2258689,'1','138','765',323,'Retail Sale Id 1324078',88200.00,0.00,0.00,0.00,-6600.00,'2021-12-12 12:24:42','',''),(2258691,'1','138','765',323,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-12 12:24:42','',''),(2258855,'1','138','765',323,'Retail Sale Id 1324164',34104.00,0.00,0.00,0.00,-2552.00,'2021-12-12 12:30:47','',''),(2258856,'1','138','765',323,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-12 12:30:47','',''),(2259036,'1','138','765',323,'Retail Sale Id 1324248',7002.56,0.00,0.00,0.00,0.00,'2021-12-12 12:38:28','',''),(2259037,'1','138','765',323,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-12 12:38:28','',''),(2259190,'1','138','765',323,'Retail Sale Id 1324322',38220.00,0.00,0.00,0.00,-2860.00,'2021-12-12 12:45:50','',''),(2259191,'1','138','765',323,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-12 12:45:50','',''),(2259234,'1','138','765',323,'Retail Sale Id 1324341',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 12:48:00','',''),(2259235,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 12:48:00','',''),(2259272,'1','138','765',323,'Retail Sale Id 1324365',3197.92,0.00,0.00,0.00,0.00,'2021-12-12 12:49:31','',''),(2259273,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 12:49:31','',''),(2259296,'1','138','765',323,'Retail Sale Id 1324375',802.64,0.00,0.00,0.00,0.00,'2021-12-12 12:50:42','',''),(2259297,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1.27,0.00,'2021-12-12 12:50:42','',''),(2259322,'1','138','765',323,'Retail Sale Id 1324386',3798.32,0.00,0.00,0.00,0.00,'2021-12-12 12:51:59','',''),(2259323,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 12:51:59','',''),(2259374,'1','138','765',323,'Retail Sale Id 1324409',63200.00,0.00,0.00,0.00,0.00,'2021-12-12 12:54:29','',''),(2259375,'1','138','765',323,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-12 12:54:29','',''),(2259390,'1','138','765',323,'Return of Retail Sale Id 1324409',0.00,63200.00,100.00,0.00,0.00,'2021-12-12 12:55:14','',''),(2259617,'1','138','765',323,'Retail Sale Id 1324535',32340.00,0.00,0.00,0.00,-2420.00,'2021-12-12 13:08:11','',''),(2259618,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-12 13:08:11','',''),(2259631,'1','138','765',323,'Retail Sale Id 1324542',29400.00,0.00,0.00,0.00,-2200.00,'2021-12-12 13:09:09','',''),(2259632,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 13:09:09','',''),(2259663,'1','138','765',323,'Retail Sale Id 1324567',4499.84,0.00,0.00,0.00,0.00,'2021-12-12 13:11:31','',''),(2259664,'1','138','765',323,'Retail sales',0.00,0.00,0.00,7.12,0.00,'2021-12-12 13:11:31','',''),(2259756,'1','138','765',323,'Retail Sale Id 1324607',7002.56,0.00,0.00,0.00,0.00,'2021-12-12 13:15:50','',''),(2259757,'1','138','765',323,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-12 13:15:50','',''),(2259964,'1','138','765',323,'Retail Sale Id 1324693',1902.32,0.00,0.00,0.00,0.00,'2021-12-12 13:26:17','',''),(2259965,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 13:26:17','',''),(2260769,'1','138','765',323,'Retail Sale Id 1325019',38220.00,0.00,0.00,0.00,-2860.00,'2021-12-12 14:02:15','',''),(2260770,'1','138','765',323,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-12 14:02:15','',''),(2260904,'1','138','765',323,'Retail Sale Id 1325076',25872.00,0.00,0.00,0.00,-1936.00,'2021-12-12 14:08:08','',''),(2260905,'1','138','765',323,'Retail sales',0.00,0.00,0.00,44.00,0.00,'2021-12-12 14:08:08','',''),(2260993,'1','138','765',323,'Retail Sale Id 1325113',41160.00,0.00,0.00,0.00,-3080.00,'2021-12-12 14:12:24','',''),(2260994,'1','138','765',323,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-12 14:12:24','',''),(2261019,'1','138','765',323,'Retail Sale Id 1325125',32340.00,0.00,0.00,0.00,-2420.00,'2021-12-12 14:14:08','',''),(2261020,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-12 14:14:08','',''),(2261051,'1','138','765',323,'Retail Sale Id 1325142',3197.92,0.00,0.00,0.00,0.00,'2021-12-12 14:16:03','',''),(2261052,'1','138','765',323,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 14:16:03','',''),(2261406,'1','138','765',323,'Retail Sale Id 1325260',12652.64,0.00,0.00,0.00,0.00,'2021-12-12 14:30:46','',''),(2261407,'1','138','765',323,'Retail sales',0.00,0.00,0.00,20.02,0.00,'2021-12-12 14:30:46','',''),(2261425,'1','138','765',323,'Retail Sale Id 1325267',5997.68,0.00,0.00,0.00,0.00,'2021-12-12 14:32:24','',''),(2261426,'1','138','765',323,'Retail sales',0.00,0.00,0.00,9.49,0.00,'2021-12-12 14:32:24','',''),(2261582,'1','138','765',323,'Retail Sale Id 1325345',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 14:42:06','',''),(2261583,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 14:42:06','',''),(2261701,'1','138','765',323,'Retail Sale Id 1325399',9802.32,0.00,0.00,0.00,0.00,'2021-12-12 14:48:55','',''),(2261702,'1','138','765',323,'Retail sales',0.00,0.00,0.00,15.51,0.00,'2021-12-12 14:48:55','',''),(2261943,'1','138','765',323,'Retail Sale Id 1325505',1902.32,0.00,0.00,0.00,0.00,'2021-12-12 15:00:59','',''),(2261944,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 15:00:59','',''),(2262023,'1','138','765',323,'Retail Sale Id 1325530',6351.60,0.00,0.00,0.00,0.00,'2021-12-12 15:05:08','',''),(2262024,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.05,0.00,'2021-12-12 15:05:08','',''),(2262080,'1','138','765',323,'Retail Sale Id 1325551',3798.32,0.00,0.00,0.00,0.00,'2021-12-12 15:07:56','',''),(2262081,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 15:07:56','',''),(2262110,'1','138','765',323,'Retail Sale Id 1325566',3798.32,0.00,0.00,0.00,0.00,'2021-12-12 15:09:04','',''),(2262111,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 15:09:04','',''),(2262129,'1','138','765',323,'Retail Sale Id 1325573',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 15:10:24','',''),(2262130,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 15:10:24','',''),(2262179,'1','138','765',323,'Retail Sale Id 1325595',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 15:13:36','',''),(2262180,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 15:13:36','',''),(2262465,'1','138','765',323,'Retail Sale Id 1325736',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 15:30:23','',''),(2262466,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 15:30:23','',''),(2262489,'1','138','765',323,'Retail Sale Id 1325747',41160.00,0.00,0.00,0.00,-3080.00,'2021-12-12 15:31:39','',''),(2262490,'1','138','765',323,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-12 15:31:39','',''),(2262550,'1','138','765',323,'Retail Sale Id 1325776',88200.00,0.00,0.00,0.00,-6600.00,'2021-12-12 15:35:36','',''),(2262551,'1','138','765',323,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-12 15:35:36','',''),(2262676,'1','138','765',323,'Retail Sale Id 1325834',11760.00,0.00,0.00,0.00,-880.00,'2021-12-12 15:41:39','',''),(2262677,'1','138','765',323,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-12 15:41:39','',''),(2262963,'1','138','765',323,'Retail Sale Id 1325971',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 15:59:59','',''),(2262964,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 15:59:59','',''),(2262997,'1','138','765',323,'Retail Sale Id 1325987',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 16:01:41','',''),(2262998,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 16:01:41','',''),(2263025,'1','138','765',323,'Retail Sale Id 1326003',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 16:03:50','',''),(2263026,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 16:03:50','',''),(2263057,'1','138','765',323,'Retail Sale Id 1326019',6320.00,0.00,0.00,0.00,0.00,'2021-12-12 16:06:43','',''),(2263058,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-12 16:06:43','',''),(2263110,'1','138','765',323,'Retail Sale Id 1326050',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 16:10:26','',''),(2263111,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 16:10:26','',''),(2263232,'1','138','765',323,'Retail Sale Id 1326102',57624.00,0.00,0.00,0.00,-4312.00,'2021-12-12 16:18:08','',''),(2263233,'1','138','765',323,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-12 16:18:08','',''),(2263256,'1','138','765',323,'Retail Sale Id 1326115',88200.00,0.00,0.00,0.00,-6600.00,'2021-12-12 16:20:00','',''),(2263257,'1','138','765',323,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-12 16:20:00','',''),(2263352,'1','138','765',323,'Retail Sale Id 1326147',6636.00,0.00,0.00,0.00,0.00,'2021-12-12 16:24:28','',''),(2263353,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.50,0.00,'2021-12-12 16:24:28','',''),(2263433,'1','138','765',323,'Retail Sale Id 1326176',57624.00,0.00,0.00,0.00,-4312.00,'2021-12-12 16:29:02','',''),(2263434,'1','138','765',323,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-12 16:29:02','',''),(2263452,'1','138','765',323,'Retail Sale Id 1326188',59976.00,0.00,0.00,0.00,-4488.00,'2021-12-12 16:30:51','',''),(2263453,'1','138','765',323,'Retail sales',0.00,0.00,0.00,102.00,0.00,'2021-12-12 16:30:51','',''),(2263566,'1','138','765',323,'Retail Sale Id 1326247',54096.00,0.00,0.00,0.00,-4048.00,'2021-12-12 16:36:34','',''),(2263567,'1','138','765',323,'Retail sales',0.00,0.00,0.00,92.00,0.00,'2021-12-12 16:36:34','',''),(2263584,'1','138','765',323,'Retail Sale Id 1326256',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 16:37:54','',''),(2263585,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 16:37:54','',''),(2263681,'1','138','765',323,'Retail Sale Id 1326296',15800.00,0.00,0.00,0.00,0.00,'2021-12-12 16:44:11','',''),(2263682,'1','138','765',323,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-12 16:44:11','',''),(2263739,'1','138','765',323,'Retail Sale Id 1326319',3798.32,0.00,0.00,0.00,0.00,'2021-12-12 16:47:41','',''),(2263740,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 16:47:41','',''),(2263886,'1','138','765',323,'Retail Sale Id 1326392',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 16:55:22','',''),(2263887,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 16:55:22','',''),(2263953,'1','138','765',323,'Retail Sale Id 1326428',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 17:00:56','',''),(2263954,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 17:00:56','',''),(2264224,'1','138','765',323,'Retail Sale Id 1326541',598308.00,0.00,0.00,0.00,-49176.00,'2021-12-12 17:24:37','',''),(2264225,'1','138','765',323,'Retail sales',0.00,0.00,0.00,1024.50,0.00,'2021-12-12 17:24:37','',''),(2264238,'1','138','765',323,'Retail Sale Id 1326546',1902.32,0.00,0.00,0.00,0.00,'2021-12-12 17:25:26','',''),(2264239,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 17:25:26','',''),(2264248,'1','138','765',323,'Retail Sale Id 1326551',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 17:26:21','',''),(2264249,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 17:26:21','',''),(2264286,'1','138','765',323,'Retail Sale Id 1326569',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 17:30:31','',''),(2264287,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 17:30:31','',''),(2264385,'1','138','765',323,'Retail Sale Id 1326615',3798.32,0.00,0.00,0.00,0.00,'2021-12-12 17:44:52','',''),(2264386,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 17:44:52','',''),(2264412,'1','138','765',323,'Retail Sale Id 1326625',44100.00,0.00,0.00,0.00,-3300.00,'2021-12-12 17:47:36','',''),(2264413,'1','138','765',323,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-12 17:47:36','',''),(2265443,'1','138','765',323,'Retail Sale Id 1326845',29699.88,0.00,0.00,0.00,-2222.44,'2021-12-13 06:24:55','',''),(2265444,'1','138','765',323,'Retail sales',0.00,0.00,0.00,50.51,0.00,'2021-12-13 06:24:55','',''),(2265473,'1','138','765',323,'Retail Sale Id 1326859',6320.00,0.00,0.00,0.00,0.00,'2021-12-13 06:30:51','',''),(2265474,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-13 06:30:51','',''),(2265555,'1','138','765',323,'Retail Sale Id 1326894',1997.12,0.00,0.00,0.00,0.00,'2021-12-13 06:39:16','',''),(2265556,'1','138','765',323,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 06:39:16','',''),(2265621,'1','138','765',323,'Retail Sale Id 1326919',7900.00,0.00,0.00,0.00,0.00,'2021-12-13 06:44:52','',''),(2265622,'1','138','765',323,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 06:44:52','',''),(2265769,'1','138','765',323,'Retail Sale Id 1326996',4000.56,0.00,0.00,0.00,0.00,'2021-12-13 06:59:37','',''),(2265770,'1','138','765',323,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-13 06:59:37','',''),(2265841,'1','138','765',323,'Retail Sale Id 1327046',77910.00,0.00,0.00,0.00,-5830.00,'2021-12-13 07:04:31','',''),(2265842,'1','138','765',323,'Retail sales',0.00,0.00,0.00,132.50,0.00,'2021-12-13 07:04:31','',''),(2265901,'1','138','765',323,'Retail Sale Id 1327076',32340.00,0.00,0.00,0.00,-2420.00,'2021-12-13 07:07:42','',''),(2265902,'1','138','765',323,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-13 07:07:42','',''),(2265929,'1','138','765',323,'Retail Sale Id 1327089',19992.00,0.00,0.00,0.00,-1496.00,'2021-12-13 07:08:58','',''),(2265930,'1','138','765',323,'Retail sales',0.00,0.00,0.00,34.00,0.00,'2021-12-13 07:08:58','',''),(2265961,'1','138','765',323,'Retail Sale Id 1327109',6320.00,0.00,0.00,0.00,0.00,'2021-12-13 07:11:32','',''),(2265962,'1','138','765',323,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-13 07:11:32','',''),(2265997,'1','138','765',323,'Retail Sale Id 1327130',29072.00,0.00,0.00,0.00,0.00,'2021-12-13 07:13:42','',''),(2265998,'1','138','765',323,'Retail sales',0.00,0.0