-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_136
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_136`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_136` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_136`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3203 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2636,20014,'',0,'22','1','136','PURCHASES','','2020-08-12 11:52:42',5,0.00,0.00,'','479','2020-08-12 11:52:42','479',0,1),(2637,400100,'',0,'24','1','136','PURCHASES','','2020-08-12 11:53:15',5,0.00,0.00,'','479','2020-08-12 11:53:15','479',0,1),(2638,20022,'',0,'20','1','136','SALES','','2020-08-12 11:53:35',5,0.00,0.00,'','479','2020-08-12 11:53:35','479',0,1),(2639,40021,'',0,'6.1','1','136','CASH','','2020-08-12 11:53:51',5,0.00,0.00,'','479','2020-08-12 11:53:51','479',0,1),(2640,400101,'',0,'24','1','136','SALARIES & WAGES','','2020-08-12 11:54:09',5,0.00,0.00,'','479','2020-08-12 11:54:09','479',0,1),(2641,400237,'',0,'2','1','136','ZBN(POS):1015965368','','2020-08-12 11:55:16',5,0.00,0.00,'','479','2020-08-12 11:55:16','479',0,1),(2642,400238,'',0,'2','1','136','ZBN(E-BILL):1015372548','','2020-08-12 11:56:53',5,0.00,0.00,'','479','2020-08-12 11:56:53','479',0,1),(2653,400104,'',0,'24','1','136','OPERATIONAL LOSS','ALL LOSSES DURING SALES/RECEPTION','2020-08-13 12:26:25',5,0.00,0.00,'','479','2020-08-13 12:26:25','479',0,1),(2897,400314,'',0,'2','1','136','DANKANO-EBILLS(ZNB:1014717618)','','2020-10-29 13:29:14',5,0.00,0.00,'','489','2020-10-29 13:29:14','489',0,1),(3199,400478,'',0,'2','1','136','FID POS COLLECTION-5620141491','','2021-02-26 15:55:45',5,0.00,0.00,'','489','2021-02-26 15:55:45','489',0,1),(3200,400479,'',0,'2','1','136','UBA LPG COLL ACCT','UBA LPG COLL ACCT_1020811140','2022-11-11 15:10:05',5,0.00,0.00,'','489','2022-11-11 15:10:05','489',0,0),(3201,400480,'',0,'2','1','136','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:46:51',5,0.00,0.00,'','792','2023-02-20 14:46:51','792',0,0),(3202,400481,'',0,'2','1','136','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:49:37',5,0.00,0.00,'2023-03-15','792','2023-03-17 14:07:44','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4280 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1589,'','1','136','ALL DEALERS','ALEX KPOIJME ','09030207031','kpojimealexander@gmail.com','ABUJA','FCT','O A U QUARTERS ASOKORO','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-12 12:57:30',5,'513','2020-08-12 12:57:30','513'),(1602,'','1','136','OPERATIONAL LOSS','HAFIZ NURA GAYA','08069129774','hgaya@aaranonigeria.com','KANO','KANO','AA RANO HOUSE HOTORO KANO.','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 12:25:16',5,'479','2020-08-13 12:25:16','479'),(2021,'','1','136','FATHER GAS','LIFE CAMP JUNCTION','07032681317','fathergas@gmail.com','FCT','ABUJA','life CAMP JUNCTIOPN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 09:09:35',5,'513','2021-02-17 09:09:35','513'),(2022,'','1','136','CHUMOKS GAS','CITECH ESTATE MBORA','08039728600','chumoksworld @yahoo.com','FCT','ABUJA','CITECH ESTATER MBORA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 09:16:56',5,'513','2021-02-17 09:16:56','513'),(2026,'','1','136','JONAC GAS','EMPRESIT KAREMO','07038055591','jonacgas@gmail.com','FCT','ABUJA','IMPRESIT KAREMO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 10:14:46',5,'513','2021-02-17 10:14:46','513'),(2028,'','1','136','U D GAS','AGURA JUNCTION ,OPP RAIN OIL F','09060201630','udgas@gmail.com','FCT','ABUJA','GURA JUNCTION KAREMO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 10:24:38',5,'513','2021-02-17 10:24:38','513'),(2030,'','1','136','PALM GAS','PLOT 103 NGOZI IWELA UTACO ','08037038527','kenonyeji10@gmail.com','FCT','ABUJA','plot 103 ngozi iwuela street utaco','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 11:49:12',5,'513','2021-02-17 11:49:12','513'),(2040,'','1','136','EMMYCO GAS','1ST AVENUE KADO ESTAE ','08039188725','emmycogas@gmail.com','FCT','ABUJA','1ST AVENUE KADO ESTATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 14:11:53',5,'513','2021-02-17 14:11:53','513'),(2043,'','1','136','JOSHUA GAS','BABANGIDA ESTATE KAREMO','08166439620','joshuagas@gmai.l.com','FCT','ABUJA','BABANGIDA ESTATE , KAREMO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-17 15:25:29',5,'513','2021-02-17 15:25:29','513'),(2046,'','1','136','BORN TO REIGN GAS','DAKI BIYU JABI','08130581690','nwaegbolinus@gmai;com','FCT','ABUJA','DAKI BIYU JABI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-18 07:40:05',5,'513','2021-05-20 08:37:39','513'),(2047,'','1','136','ANDY GAS','FHA LUGBE','07035974602','andyogbadu@gmail.com','FCT','ABUJA','FHA LUGBE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-18 07:43:59',5,'513','2021-02-18 07:43:59','513'),(2051,'','1','136','EZE UDO GAS','21 ARMY ESTATE JUNCTION KUBWA','08039597042','ezeudogas@gmail.com','FCT','ABUJA','21,ARMY JUNCTION, KUBWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-18 09:54:51',5,'513','2021-02-18 09:54:51','513'),(2054,'','1','136','BLESSED IYKE','GWARIMPA 6TH AVENUE','08060405958','iyeke@gmail.com','ABUJA','ABUJA','GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-18 11:12:10',5,'513','2021-02-18 11:12:10','513'),(2056,'','1','136','SY GAS','KARMO','08134101929','sy@gmail.com','ABUJA','ABUJA','karmo','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-18 11:25:41',5,'513','2021-02-18 11:25:41','513'),(2060,'','1','136','CHIMON GAS','69 ROAD 3RD GWARINPA','07068749296','chukwuebuka@gmail.com','FCT','ABUJA','road 69,galadima gwarinpa','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-18 12:27:05',5,'513','2021-02-18 12:27:05','513'),(2062,'','1','136','GOTTENMS GAS','CLOST TO VIGILANTE GROUP ,LAST','08066430260','okee@gmail.com','FCT','ABUJA','LAST GATE ,CLOSE TO VIGILANTE GROUP,KAREMU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-18 16:18:22',5,'513','2021-04-24 10:43:38','513'),(2085,'','1','136','MB GAS ','GWAGWA KARMO AFTER BRIDGE','07037479226','mbgas@gmail.com','FCT','ABUJA','AFTER BRIDGE , GWAGWA KARMO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 12:21:45',5,'513','2021-02-20 12:21:45','513'),(2086,'','1','136','MB  GWAGWA GAS ','GWAGWA KARMO AFTER BRIDGE','07037479226','mbgas@gmail.com','FCT','ABUJA','AFTER BRIDGE , GWAGWA KARMO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 12:22:33',5,'513','2021-02-20 12:22:33','513'),(2087,'','1','136','AB GAS ','JIWA JUNCTION AFTER GWAGWA','09025426665','jiwagas@gmail.com','FCT','ABUJA','JIWA JUNCTION GWAGWA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 12:25:35',5,'513','2021-02-20 12:25:35','513'),(2088,'','1','136','EMZY GAS','OPP CHRIST EMBASY KARM0','07035838396','emzygas@gmail.com','FCT','ABUJA','OPP CHRIST EMBASY KARMO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 12:34:19',5,'513','2021-02-20 12:34:19','513'),(2089,'','1','136','CHARLES\'O GAS','BEHIND GWARINPA PLAZA','08152944567','odemirax63@yahoo.com','FCT','ABUJA','BEHIND GWARINPA PLAZA KADO ERSTENSION','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-20 12:42:59',5,'513','2021-02-20 12:42:59','513'),(2118,'','1','136','C-PAUL GAS','GAS DEPOT GWARINPA','08062882410','cpaulgas@gmail.com','FCT','ABUJA','GAS DEPOT QWARINPA ESTATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 11:46:21',5,'513','2021-02-21 11:46:21','513'),(2128,'','1','136','OTELE BONI GAS','JAJI  KUBWA ','08037388762','otelebonigas@gmail.com','FCT','ABUJA','biazin across  kubwa ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 16:39:29',5,'513','2021-02-21 16:39:29','513'),(2129,'','1','136','EVER GREEN GAS','GAMES VILLAGE ESTATE ','08035861408','unnamoko@yahoo.com','FCT','ABUJA','OPP MOSQUE GAMES VILLAGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 16:43:48',5,'513','2021-02-21 16:43:48','513'),(2152,'','1','136','MONDAY GREAT GAS','CLOSE TO ANGWA SHAHO KAREMU','08133365983','mondaygreatgas @gmail.com','FCT','ABUJA','close to angwa shawu town hall karemu','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 14:10:42',5,'513','2021-02-22 14:10:42','513'),(2162,'','1','136','GALA GAS','LOKO GOMA ','09061854885','galagas@gmail.com','FCT','ABUJA','LOKO GOMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-23 09:34:52',5,'513','2021-02-23 09:34:52','513'),(2163,'','1','136','PAUL GAS','LIVE CAMP BESIDE BEGGER','08065330135','paulgas@gmailcom','FCT','ABUJA','LIVE CAMP BESIDE BEGGER','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-23 09:48:10',5,'513','2021-02-23 09:48:10','513'),(2164,'','1','136','LUCKY BEST GAS','EFAB GLOBAL ESTATE IDU RAIL WA','08036829151','luckybestsyndicate@gail.com','FCT','ABUJA','EFAB ESTATE , IDU RAILWAY ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-23 09:55:55',5,'513','2021-08-12 10:13:50','513'),(2167,'','1','136','RICHI GAS','SECOND GATE GWARIMPA','08033950318','richigas@gmaicom','FCT','ABUJA','SECOND GATE GWARINPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-23 10:37:55',5,'513','2021-02-23 10:37:55','513'),(2191,'','1','136','LEGACY GAS','BY AKIIMI ROAD,GWAGWA KARIMO ','08039225916','legacygas@gmail.com','FCT','ABUJA','akimi road ,gwagwa karimo ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-25 13:23:17',5,'513','2021-02-25 13:23:17','513'),(2203,'','1','136','ZAKIOUS GAS','GWAI JABA AREA','07059277155','zakiousgas@gmailcom','KADUNA','KADUNA','GWAI JABA LOCAL GOVT','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-26 10:15:54',5,'513','2021-02-26 10:15:54','513'),(2213,'','1','136','EMMA GAS','BERGER YARD LIFE CAMP','09136139865','emmagas@gmail.com','FCT','ABUJA','BERGER YARD LIFE CAMP','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-26 13:35:18',5,'513','2021-02-26 13:35:18','513'),(2214,'','1','136','EASY GAS','ANGWA SHEU KAREMO OCHACHO ESTA','07038870954','easygas@mail.com','FCT','ABUJA','OCHACHO ESTATE ANGWAN SHEU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-26 14:04:32',5,'513','2021-12-20 10:25:19','513'),(2226,'','1','136','SUEZ GAS','NO.20 ALEXANDRIA CRESCENT WUSE','08168003677','suezgasoperations@gmailcom','FCT','ABUJA','no.20 ALEXANDRIA CRESRENT WUSE 2 ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-27 13:38:59',5,'513','2021-02-27 13:38:59','513'),(2238,'','1','136','UCHE GAS','NO:10 ZUDI JUNCTION TUDUN WADA','08061574372','uchejacob946@gmailcom','FCT','FCT','NO:ZUDI JUNCTTION TUDUN WADA LUGBE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-01 09:12:53',5,'513','2022-12-17 15:07:46','513'),(2243,'','1','136','OTUMALE GAS','PIWOYI LUBGE ROAD','07053322327','udilemonday@gmailcom','FCT','FCT','PIWOYI LUBGE ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-01 11:39:43',5,'513','2021-03-01 11:39:43','513'),(2247,'','1','136','PRESDOO GAS GLOBAL VENTURE NIG','ALIYETA AIR P0RT ROAD ABUJA','08120113718','onyekachukwueme@yahoocom','FCT','FCT','ALIYETA AIR PORT ROAD ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-01 14:57:06',5,'513','2021-03-01 14:57:06','513'),(2248,'','1','136','PRESDOO GAS GLOBAL VENTURE NIG','ALIYETA AIR P0RT ROAD ABUJA','08120113718','onyekachukwueme@yahoocom','FCT','FCT','ALIYETA AIR PORT ROAD ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-01 14:57:08',5,'513','2021-03-01 14:57:08','513'),(2249,'','1','136','W0RLD MART GAS','AREA 1 GARKI ABUJA','08136737706','worldmartgas@gmailcom','FCT','FCT','AREA 1 GARKI ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-01 15:43:11',5,'513','2021-03-01 15:43:11','513'),(2254,'','1','136','MB 1 GAS','KATAMPE ABUJA','08076706371','mb1gas@gmailcom','FCT','FCT','KATAMPE ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-02 10:30:47',5,'513','2021-03-02 10:30:47','513'),(2259,'','1','136','CHILINK GAS GLOBAL','GWAGWALADA ABUJA','09043224109','chilinkgasglobal@gmailcom','FCT','FCT','GWAGWALADA ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-03 08:24:20',5,'513','2022-01-04 08:20:32','513'),(2273,'','1','136','DM DEMEX OIL AND GAS LTD','GRWARINPA BRANCH','08035911650','mddemexgas@gmailcom','FCT','FCT','GWARINPA BRANCH ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-04 10:32:25',5,'513','2021-03-04 10:32:25','513'),(2288,'','1','136','MICHAEL GAS ','08033159614','KARMU OPP CATH CHURCH','michaelgsa@gmailcom','FCT','FCT','KARMU ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-05 13:14:39',5,'513','2021-03-05 13:14:39','513'),(2289,'','1','136','BRIGHT GAS','OPP. CATOLIC CHURCH KARMAJIJI','08152674807','brightgas@gmailcom','FCT','FCT','OPP CATOLIC CHURCH KARMAJIJI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-05 13:29:33',5,'513','2021-03-05 13:29:33','513'),(2303,'','1','136','CHIKESON GAS','KARMAJIJI AIR PORT ROAD ABUJA','08039577622','chikesongas@gmailcom','FCT','FCT','KARMAJIJI AIR PORT ROAD ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-09 13:18:57',5,'513','2021-03-09 13:18:57','513'),(2305,'','1','136','FAVOUR GAS','APO ABUJA','07037116669','favourgas@gmailcom','FCT','FCT','APO ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-09 14:47:56',5,'513','2021-03-09 14:47:56','513'),(2309,'','1','136','OBI GAS','KARMU ABUJA','08036160226','obigas@gmailcom','FCT','FCT','KARMU ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-11 09:41:03',5,'513','2021-03-11 09:41:03','513'),(2310,'','1','136','ARINZE GAS','OPP, CARTH CHURCH KARMO ABUJA','08056917907','arinzegas@gmailcom','FCT','FCT','OPP,CARTH CHURCH KARMO ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-11 09:50:54',5,'513','2021-03-11 09:50:54','513'),(2318,'','1','136','DIBEZGAS','DAI-DAI ABUJA','08104256127','dibezgas@gmailcom','FCT','FCT','DAI-DAI ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-12 08:58:44',5,'513','2021-03-12 08:58:44','513'),(2329,'','1','136','WAP GAS','OPP,BAKERY PIPELINE JIWA','08063378078','wapgas@gmailcom','FCT','FCT','OPP,BAKERY PIPELINE JIWA ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-15 09:10:06',5,'513','2021-03-15 09:10:06','513'),(2330,'','1','136','ROYAL GAS','GWAGWA FCT ABUJA','08161137521','royalgas@gmailcom','FCT','FCT','GWAGWA  FCT ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-15 09:46:31',5,'513','2021-03-15 09:46:31','513'),(2331,'','1','136','SAMIKO GAS','DEI-DEI FCT ABUJA','08038505732','samikogas@gmailcom','FCT','FCT','DEI-DEI FCT ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-15 10:13:48',5,'513','2021-03-15 10:13:48','513'),(2332,'','1','136','WILLIE GAS','AIR PORT ROAD ABUJA','08035929405','williegas@gmailcom','FCT','FCT','AIR PORT ROAD ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-15 10:17:04',5,'513','2021-03-15 10:17:04','513'),(2346,'','1','136','UPTYNE GAS','GWARINPA ABUJA','07064744710','uptyne@gmailcom','FCT','FCT','GWARIMPA ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-17 10:18:57',5,'513','2021-03-17 10:18:57','513'),(2356,'','1','136','KING-JOE GAS NIG ENT.','OPP.ANGLICAN CHURCH 1ST AVENUE','08034822929','kingjoegas@gmailcom','FCT','FCT','0PP,ANGLICAN CHURCH 1ST AVENUE GWARINPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-18 14:21:14',5,'513','2021-03-18 14:21:14','513'),(2357,'','1','136','LUCKY GAS','GWARINPA ABUJA','08077871537','luckygas@gmailcom','FCT','FCT','GWARINPA ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-18 14:54:33',5,'513','2021-03-18 14:54:33','513'),(2370,'','1','136','SP GAS ','OPP SUNNY VILL  ESTATE KABUSA','07037222125','spgas@gmail.com','FCT','ABUJA','OPP SUNNY VILLE ESTATE KABUSA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-21 16:26:52',5,'513','2021-03-21 16:26:52','513'),(2374,'','1','136','OLAWINNER GAS ','FEDERAL HOUSING LUGBE','08038065178','olawinner11@gmail.com','FCT','ABUJA','adjascent raod salty office fed housing lugbe','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-22 09:10:08',5,'513','2021-03-22 09:10:08','513'),(2376,'','1','136','FRIDAY GAS','OPP MANGROVER HIGH PET 7 ESATE','08103467539','fridaygas@gmail.com','FCT','ABUJA','opp mangrover high pet 7 estate gwarinpa','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-22 10:50:26',5,'513','2021-03-22 10:50:26','513'),(2382,'','1','136','OYITEX OIL AND GAS','AMINU KANO CRESCENT WUSE TWO','07034745501','oyitexgas@gmail.com','FCT','ABUJA','AMINU KANO CRESCENT WUSE TWO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-23 08:43:16',5,'513','2021-03-23 08:43:16','513'),(2388,'','1','136','KAMBAI SKD GAS','TIPPER GARAGE 3RD AVENUE GWARI','08169563355','kambaiskdgas@gmail.com ','FCT','ABUJA','TIPPER GARAGE ,3RD AVENUE GWARINPA ESTAATE ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-23 17:18:21',5,'513','2021-03-23 17:18:21','513'),(2389,'','1','136','GAS LORD','BEHIND SHOPRITE APO ','08060999616','chukwuebuka@gmail.com','FCT','ABUJA','BEHIND SHOPRITE  APO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-23 17:25:14',5,'513','2021-03-23 17:25:14','513'),(2391,'','1','136','JAMES GAS','PIWOYI VILLAGE ALONG AIRPORT R','07032343959','onyekachijame161@yahoo.com','FCT','ABUJA','PIWAYI VILLAGE ALONG AIRPORT ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-24 09:29:26',5,'513','2021-05-20 08:40:15','513'),(2392,'','1','136','SPECIAL GAS','ONDO LIFE CAMP','08036059117','specialgas@mail.com','FCT','ABUJA','INSIDE ONDO  FILLING STATION LIFE CAMP','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-24 09:51:10',5,'513','2021-03-24 09:51:10','513'),(2405,'','1','136','KC GAS','GWARINPA ABUJA','08035970819','kcgas@gmailcom','FCT','FCT','GWARINPA ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-26 11:24:05',5,'513','2021-03-26 11:24:05','513'),(2416,'','1','136','ABOBE GAS ','LUBGE ABUJA','08036170037','abobegas@gmailcom','FCT','FCT','LUBGE ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-27 11:35:02',5,'513','2021-03-27 11:35:02','513'),(2425,'','1','136','UNCLE PETE GAS LTD','WUSE ZONE 1GAS SITE ABUJA','08035893542','unclepetegas@gmailcom','FCT','FCT','WUSE ZONE 1 ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-28 11:33:05',5,'513','2021-03-28 11:33:05','513'),(2428,'','1','136','LAZ GAS','KT AIR PORT ROAD ABUJA','09063361112','lazgas@gmailcom','FCT','FCT','KT AIR PORT ROAD ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-28 14:09:34',5,'513','2021-03-28 14:09:34','513'),(2456,'','1','136','FRIDAY GAS MINNA','MINNA NIGER STATE','08035871204','fridaygasminna@gmailcom','MINNA','NIGER STATE','MINNA NIGER STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-30 14:16:19',5,'513','2021-03-30 14:16:19','513'),(2458,'','1','136','MACO GAS MINNA','MINNA NIGER STATE','08032435433','macogasminna@gmailcom','MINNA','NIGER STATE','MINNA NIGER STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-30 14:18:24',5,'513','2021-03-30 14:18:24','513'),(2462,'','1','136','C H GAS','LIFE CAMP ABUJA','08110775546','chgas@gmailcom','FCT','FCT','LIFE CAMP ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-01 07:14:55',5,'513','2021-04-01 07:14:55','513'),(2471,'','1','136','DEGRACIOUS GAS','AIR PORT ROAD KUCHI GORO','09030313179','degraiusgas@gmailcom','FCT','FCT','AIR PORT ROAD KUCHI GORO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-01 11:52:27',5,'513','2021-04-29 12:38:55','513'),(2475,'','1','136','ADMORE GAS','JABI ABUJA','08037020544','admoregas@gmailcom','FCT','FCT','JABI ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-02 08:48:50',5,'513','2021-04-02 08:48:50','513'),(2476,'','1','136','TONY GAS','KARIMO ABUJA','08036050677','tonygas@gmailcom','FCT','FCT','KARMO ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-02 08:52:08',5,'513','2021-04-29 12:24:12','513'),(2478,'','1','136','K N GAS','GWARIMPA ABUJA','08033623370','kngas@gmailcom','FCT','FCT','GWARIMPA ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-02 10:59:16',5,'513','2021-04-02 10:59:16','513'),(2483,'','1','136','BREAKTHROUGH GAS','LOCO GOMA ABUJA','08134696459','breakthroughgas@gmalcom','FCT','FCT','LOKO GOMA ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-03 07:28:52',5,'513','2021-04-03 07:28:52','513'),(2484,'','1','136','SUCCESS GAS','GOSA ABUJA','07011858715','sucessgas@gmailcom','FCT','FCT','GOSA ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-03 08:16:07',5,'513','2021-05-20 08:39:20','513'),(2485,'','1','136','UNJ EXCELLENT GAS','LUGBE ZONE 5 AFTER POLICE STAT','08063007118','unjexcellentgas@gmailcom','FCT','FCT','LUBGE ZONE 5 AFTER POLICE STATION','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-03 08:40:56',5,'513','2021-04-03 08:40:56','513'),(2500,'','1','136','BLESSED IK OIL AND GAS','TEAM 7 GALADIMA GWARINPA ESTAT','08106587293','blessedikoil@gmial.com','FCT','ABUJA','TEAM 7 MARKET GALADIMA GWARINPA ESTATE ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-04 12:37:33',5,'513','2021-04-04 12:37:33','513'),(2502,'','1','136','SAMTEX GAS','GWARINPA GAS SITE 1ST AVENUE','08038343201','samtexgas@mail.com ','FCT','FCT','GWARINPA GAS SITE 1ST AVENUE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-04 13:09:07',5,'513','2021-04-04 13:09:07','513'),(2505,'','1','136','JJ OIL AND GAS','ZUMMA GUEST INN','08112224477','jjoilandgas@gmail.com','FCT','ABUJA','OPP ZUMMA GUEST INN GWAGWA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-05 08:01:11',5,'513','2021-04-05 08:01:11','513'),(2506,'','1','136','V J OIL AND GAS','KINGS LAND JUNCTIO GWAGWA','090351112349','vjoilandgas@gmail.com','FCT','ABUJA','KINGS JUNCTION GWAGWA KAREMO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-05 08:11:08',5,'513','2021-04-05 08:11:08','513'),(2514,'','1','136','MACO AYE GAS','KARMU ABUJA','08065074814','macogas@gmailcom','FCT','FCT','KARMU ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-06 14:01:14',5,'513','2021-07-29 13:06:55','513'),(2515,'','1','136','MACO GAS KARMU','KARMU ABUJA','08065074814','macogas@gmailcom','FCT','FCT','KARMU ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-06 14:01:45',5,'513','2021-04-06 14:01:45','513'),(2523,'','1','136','MONDAY GAS','OPP GWARINPA PLAZA LIFE CAMP','08179295669','mondaygas@mail.com','FCT','ABUJA','OPP GWARINPA PLAZA LIFE CAMP','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-07 10:48:02',5,'513','2021-04-07 10:48:02','513'),(2527,'','1','136','3NITY OIL AND GAS LOGISTION LT','23 CRESCENT HAUSE 85 EFAB ESTA','08035082349','3nitygas@gmailcom','FCT','FCT','LIFE CAMP ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-08 11:23:26',5,'513','2021-04-08 11:23:26','513'),(2566,'','1','136','LUBE GAS','7 AVENUE GWARIMPA','08034760251','lubegas@gmailcom','FCT','FCT','7 AVENUE GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-16 09:16:52',5,'513','2021-04-16 09:16:52','513'),(2571,'','1','136','ABB GAS','PAIPE VILLEGE','08065559797','abbgas@gmailcom','FCT','FCT','PAIPE VELLAGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-17 09:11:37',5,'513','2021-04-17 09:11:37','513'),(2580,'','1','136','NAIJA GAS PLANT','NAIJA GAS ','09072744444','bigaya78@gmail.com','FCT','ABUJA','NO 5 KUMASI CRESCENT, WUSE 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-20 08:15:29',5,'513','2021-04-20 08:15:29','513'),(2583,'','1','136','S T  GAS','S T','09023693155','buhariobey@gmail.com','F C T','ABUJA','KUCHIBENA  GWARIMPA   ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-20 14:42:06',5,'513','2021-04-20 14:42:06','513'),(2584,'','1','136','EVER BEST GAS','EVER BEST','08035937780','okeoluwole01@yahoo.com','FCT','ABUJA','FHA LUGBE ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-21 07:17:46',5,'513','2021-04-21 07:17:46','513'),(2599,'','1','136','OLUWATOSIN  GAS','OLUWATOSIN','08135460586','shotayooluwatosin2008@gmail.co','FCT','ABUJA','IDU ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-23 14:17:49',5,'513','2021-04-29 12:23:16','513'),(2600,'','1','136','TO BEST GAS','TO BEST','08052918107','udgas@gmail.com','FCT','ABUJA','GWARINPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-23 15:05:16',5,'513','2021-04-23 15:05:16','513'),(2603,'','1','136','YUSUF GAS','YUSUF','08058605882','weseboy85@gmail.com','FCT','ABUJA','AIRPORT VILLAGE, BASSA\r\nALONG AIRPORT ROAD ABUJA\r\n','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-24 09:40:04',5,'513','2021-04-24 09:40:04','513'),(2604,'','1','136','IDRIS GAS','IDRIS','07060562115','udgas@gmail.com','FCT','ABUJA','ZAMANI, AIRPORT ROAD\r\nABUJA.','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-24 09:47:51',5,'513','2021-04-24 09:47:51','513'),(2605,'','1','136','UGOCITY GAS','UGOCITY','08160529384','streetmani490@gmail.com','FCT','ABUJA','CHIKA, AIRPORT ROAD\r\nABUJA.','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-24 13:34:44',5,'513','2021-04-24 13:34:44','513'),(2609,'','1','136','IFY GAS','IFY GAS','08025894544','udgas@gmail.com','FCT','ABUJA','KADO-KUCHI\r\nBEHIND NEXT CASH AND CARRY\r\nKADO ABUJA\r\n','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-25 12:53:25',5,'513','2021-04-25 12:53:25','513'),(2610,'','1','136','DENNIS GAS','DENNIS GAS','08152987340','www.aondoverterwasedennis@gmai','FCT','ABUJA','CHIKA, ALONG AIRPORT ROAD\r\nABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-26 08:03:28',5,'513','2021-04-26 08:03:28','513'),(2611,'','1','136','DE BASH GAS AUTOMOBILE REFILLI','DE BASH GAS','08024026231','debashgas@gmail.com','FCT','ABUJA','ARAB ROAD, KUBWA\r\nABUJA.','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-26 08:07:03',5,'513','2021-04-26 08:07:03','513'),(2618,'','1','136','UOC GAS','0LD KARMU','07082751845','breakthroughgas@gmalcom','FCT','ABUJA','OLD KARMU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-27 11:32:44',5,'513','2021-04-27 11:32:44','513'),(2619,'','1','136','OLD SCHOOL','TASH 1 GWAGWA','08073383900','shotayooluwatosin2008@gmail.co','FCT','ABUJA','TASH 1 GWAGWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-27 11:46:28',5,'513','2021-04-27 11:46:28','513'),(2624,'','1','136','JUMBO GAS','JUMBO GAS','07031138684','jumbolistic@gmail.com','FCT','ABUJA','DAWAKI\r\nABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-28 12:37:32',5,'513','2021-04-28 12:37:32','513'),(2637,'','1','136','EJIKE','DAWAKI','08171030511','shotayooluwatosin2008@gmail.co','FCT','ABUJA','DAWAKI  ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-02 10:38:40',5,'513','2021-05-02 10:38:40','513'),(2638,'','1','136','PETER GAS','PETER GAS','08169592459','peterchukwu050@gmailo.com','FCT','ABUJA','OBAFEMI AWOLOWO WAY ZONE B\r\nJABI, ABUJA.','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-02 11:02:00',5,'513','2021-05-02 11:02:00','513'),(2639,'','1','136','NNEJICO GAS','NNEJICO GAS','008063856586','nnejico586@gmail.com','FCT','ABUJA','GWARIMPA, ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-02 11:49:08',5,'513','2021-05-02 11:49:08','513'),(2641,'','1','136','BUCHI GAS','BUCHI GAS','08036538502','mbgas@gmail.com','FCT','ABUJA','GWARIMPA ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-02 12:33:20',5,'513','2021-05-02 12:33:20','513'),(2655,'','1','136','WINNER GAS','LOGA ABUJA','07037763534','breakthroughgas@gmalcom','FCT','ABUJA','LUGAABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-06 09:02:43',5,'513','2021-05-20 08:38:30','513'),(2656,'','1','136','DEALER CHEF JOSH','15FEMI KILA SATEET','08035490210','mbgas@gmail.com','FCT','ABUJA','15 FEMI KILA SATEET','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-06 11:08:55',5,'513','2021-05-06 11:08:55','513'),(2659,'','1','136','SANI GAS','LIFE CAMP ABUJA','08130113496','mbgas@gmail.com','FCT','ABUJA','LIFE CAMP   ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-08 07:03:08',5,'513','2021-05-08 07:03:08','513'),(2710,'','1','136','FEMCO GAS','FEMCO GAS','08037371758','femcokreation@gmail.com','FCT','ABUJA','ACO ESTATE, LUGBE \r\nAIRPORT ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-29 16:20:00',5,'513','2021-05-29 16:20:00','513'),(2713,'','1','136','FARAAB GAS','FARAAB GAS','08068853267','mbgas@gmail.com','FCT','ABUJA.','NO 24, YAOUNDE STREET\r\nZONE 6\r\n','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-31 07:33:37',5,'513','2021-05-31 07:33:37','513'),(2720,'','1','136','ABOVE GAS','ABOVE GAS','08036170737','mbgas@gmail.com','FCT','ABUJA','LUGBE, AIRPORT ROAD\r\n\r\n\r\n','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-02 16:57:50',5,'513','2021-06-02 16:57:50','513'),(2726,'','1','136','ZICO GAS','ZICO GAS','08060924427','ugochukwunwodo4@gmail.com','FCT','ABUJA.','NEAR BANEX PLAZA\r\nWUSE 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-04 10:12:17',5,'513','2021-06-04 10:12:17','513'),(2729,'','1','136','EMMY 7 GAS','EMMY 7 GAS','07065668112','innocentokonankwai@gmail.com','FCT','ABUJA','CHIKA, AIRPORT ROAD\r\nLUGBE\r\n','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-07 13:08:53',5,'513','2021-06-07 13:09:54','513'),(2732,'','1','136','ALAEGRA GAS','ALAEGRA GAS','08061178750','samueldaniel@gmail.com','FCT','ABUJA','LIFECAMP','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-09 08:32:25',5,'513','2021-06-09 08:32:25','513'),(2738,'','1','136','IK GAS','IK GAS','08133168091','mbgas@gmail.com','FCT','ABUJA.','OPPOSITE HAKIMI JUNCTION\r\nIDU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-11 08:03:59',5,'513','2021-06-11 08:03:59','513'),(2739,'','1','136','ECO EMMY GAS','ECO EMMY GAS','07063346930','emmanuelchijoke@gmail.com','FCT','ABUJA','JABI FOREST\r\nAFTER JABI GARAGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-11 10:42:19',5,'513','2021-06-11 10:42:19','513'),(2743,'','1','136','EMEKA GAS','EMEKA GAS','08108352955','mbgas@gmail.com','FCT','ABUJA','GWARINPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-13 15:51:59',5,'513','2021-06-13 15:51:59','513'),(2744,'','1','136','FROST GAS','FROST GAS','08163309511','frostgasng@gmail.com','FCT','ABUJA','KUBWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-14 09:21:56',5,'513','2021-06-14 09:21:56','513'),(2746,'','1','136','V. I. O. GAS','GWARIMPA ABUJA','08062173957','udgas@gmail.com','F C T','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-14 15:04:01',5,'513','2021-07-19 16:34:55','513'),(2747,'','1','136','DAMINA GAS','DAMINA GAS','07067160803','augustinedamina@gmail.com','FCT','ABUJA','LIFECAMP','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-16 09:45:14',5,'513','2021-06-16 09:46:36','513'),(2749,'','1','136','GODSTIME GAS','GODSTIME GAS','08030836198','goddstimegas@gmail.com','FCT','ABUJA','WUSE 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-16 10:44:12',5,'513','2021-06-16 10:44:12','513'),(2751,'','1','136','AMAZING GAS','AMAZING GAS','08160245085','amazinggas21@gmail.com','FCT','ABUJA.','WUSE ZONE 1','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-16 16:19:45',5,'513','2021-06-16 16:19:45','513'),(2752,'','1','136','AS0 GWA SABASTINE UCHE','KARAMAJIJI ,AIRPORT ROAD,LUGBE','0806812277','innocentokonankwai@gmail.com','FCT','FCT','LUGBE AIRPORT ROAD ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-17 06:40:23',5,'513','2021-06-17 06:40:23','513'),(2758,'','1','136','TOCHI GAS','TOCHI GAS','08175005154','mbgas@gmail.com','FCT','ABUJA','CUSTOMS QUARTERS\r\nOLD KARMO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-18 10:52:35',5,'513','2021-06-18 10:52:35','513'),(2767,'','1','136','EVER BRIGHT GAS','EVER BRIGHT GAS','08065399451','mbgas@gmail.com','FCT','ABUJA','FINANCE QUARTERS\r\nWUYE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-18 12:42:23',5,'513','2021-06-18 12:42:23','513'),(2768,'','1','136','K S GAS','K S GAS','08183113920','mbgas@gmail.com','FCT','ABUJA','GISHIRI VILLAGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-18 12:46:41',5,'513','2021-06-18 12:46:41','513'),(2773,'','1','136','SUNNY GAS','SUNNY GAS','08069079444','sunnygas11@gmail.com','FCT','ABUJA','KADO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-19 09:18:14',5,'513','2021-06-19 09:18:14','513'),(2775,'','1','136','GODSWILL GAS','GODSWILL GAS','08038899231','godswillgas21@gmail.com','FCT','ABUJA','GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-19 10:51:46',5,'513','2021-06-19 10:51:46','513'),(2781,'','1','136','ENYO GAS','ENYO GAS','08134159722','enyoatulukwu@gmail.com','FCT','ABUJA','BEHIND CITEC \r\nAIRPORT ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-19 16:42:10',5,'513','2021-06-19 16:42:10','513'),(2802,'','1','136','SUNDAY GAS','SUNDAY GAS','09071913357','mbgas@gmail.com','FCT','ABUJA','DAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-22 12:48:55',5,'513','2021-06-22 12:48:55','513'),(2851,'','1','136','AJIMOONA GAS','AJIMOONA GAS','0803590294','ajimoonagas12@gmail.com','FCT','ABUJA','LUGBE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-27 14:11:43',5,'513','2021-06-27 14:11:43','513'),(2868,'','1','136','EMMASON GAS','EMMASON GAS','08057999699','emmasongas21@gmail.com','FCT','ABUJA','WUSE ZONE1\r\n','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-29 16:10:48',5,'513','2021-06-29 16:10:48','513'),(2889,'','1','136','ENE GAS','ENE GAS','09024461979','philipiorgon97@gmail.com','FCT','ABUJA','AREA 2\r\nGARKI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-03 16:59:09',5,'513','2021-07-03 16:59:09','513'),(2911,'','1','136','ADAMU GAS','ADAMU GAS','08165562721','breakthroughgas@gmalcom','FCT','ABUJA.','LIFE CAMP ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-08 07:00:45',5,'513','2021-08-12 10:17:12','513'),(2918,'','1','136','TIMONY GAS.ENTERPRIU','KRAMU ABUJA','09021331929','innocentokonankwai@gmail.com','FCT','ABUJA','KRAMU ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-08 11:56:35',5,'513','2021-07-08 11:56:35','513'),(2921,'','1','136','CHUCAB GAS','CHUCAB GAS','08104842733','chucabgas11@gmail.com','FCT','ABUJA.','KADO ESTATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-09 12:05:08',5,'513','2021-07-09 12:05:08','513'),(2928,'','1','136','ISAH GAS','ISAH GAS','08036456147','isahgas@gmail.com','FCT','ABUJA','GARKI SUPERMARKET\r\nGARKI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-10 15:44:43',5,'513','2021-07-10 15:44:43','513'),(2977,'','1','136','GREAT GAS','GREAT GAS','07062099055','greatgas22@gmail.com','FCT','ABUJA','KARMAJIJI\r\nAIRPORT ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-21 13:04:55',5,'513','2021-07-21 13:04:55','513'),(2994,'','1','136','A E S GAS','JABA  ABUJA','08172458884','innocentokonankwai@gmail.com','FCT','ABUJA','JABA  ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-30 10:25:21',5,'513','2021-07-30 10:25:21','513'),(3003,'','1','136','NILE GAS','NILE GAS','08038080405','nilegas@gmail.com','FCT','ABUJA.','AREA 8','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-31 16:50:37',5,'513','2021-07-31 16:50:37','513'),(3004,'','1','136','NILE MOBILE GAS','NILE MOBILE GAS','08038080405','nilegas@gmail.com','FCT','ABUJA.','AREA 8','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-31 16:52:28',5,'513','2021-07-31 16:52:28','513'),(3013,'','1','136','ASOKORO GAS','ASOKORO GAS','09055481392','asokorogas22@gmail.com','FCT','ABUJA.','OPPOSITE ASOKORO HOSPITAL','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-04 10:49:11',5,'513','2021-08-04 10:49:11','513'),(3033,'','1','136','N D GAS GWAGWA','N D GAS GWAGWA','08064962338','udgas@gmail.com','FCT','ABUJA.','GWAGWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-07 15:13:54',5,'513','2021-08-07 17:40:35','513'),(3048,'','1','136','ARIZONA GAS','ARIZONA GAS','09058705325','udgas@gmail.com','FCT','ABUJA.','ZAUDA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-09 15:02:30',5,'513','2021-08-09 15:02:30','513'),(3064,'','1','136','M & B GAS','M & B GAS','08071625300','mbgas@gmail.com','FCT','ABUJA.','KUBWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-12 14:37:37',5,'513','2021-08-12 14:37:37','513'),(3065,'','1','136','DIVINE GAS','DIVINE GAS','08105604150','mbgas@gmail.com','FCT','ABUJA.','MASAKA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-12 15:57:09',5,'513','2021-08-12 15:57:09','513'),(3085,'','1','136','EASY ACCASS GAS','GISHIRI','08109358186','udgas@gmail.com','FCT','ABUJA.','ABUJA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-17 07:07:53',5,'513','2021-08-17 07:07:53','513'),(3086,'','1','136','NIC GAS','GWARINPA ABUJA','07030919650','innocentokonankwai@gmail.com','FCT','ABUJA.','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-17 07:29:09',5,'513','2021-08-17 07:29:09','513'),(3104,'','1','136','EMMY GAS','WUSE ZONE 1GAS SITE ABUJA','08037041876','innocentokonankwai@gmail.com','FCT','ABUJA.','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-17 13:02:36',5,'513','2021-08-17 13:02:36','513'),(3105,'','1','136','NNAMDI ENUGU  GAS','NNAMDI ENUGU  GAS','08165024148','mbgas@gmail.com','FCT','ABUJA.','DAWAKI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-17 14:06:10',5,'513','2021-08-18 09:20:10','513'),(3116,'','1','136','GEORGE OIL AND GAS','APO ABUJA','08038914536','breakthroughgas@gmalcom','FCT','ABUJA.','APO ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-19 08:39:09',5,'513','2021-08-19 09:30:44','513'),(3118,'','1','136','AGUMBA GAS','AGUMBA GAS','08143121623','mbgas@gmail.com','FCT','ABUJA.','GWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-19 11:14:31',5,'513','2021-08-19 11:14:31','513'),(3121,'','1','136','ATIKU GAS','GAMES VILLAGE GREEN AREA','08188494599','shotayooluwatosin2008@gmail.co','FCT','ABUJA','GAMES VILLAGE ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-19 15:23:17',5,'513','2021-08-19 15:23:17','513'),(3127,'','1','136','ABDUL GAS','ABDUL GAS','08105355989','mbgas@gmail.com','FCT','ABUJA.','GWAGWALADA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-20 14:13:12',5,'513','2021-08-20 14:13:12','513'),(3131,'','1','136','PUNWON INVESTEMENT','GWARINPA ABUJA','07061931946','isahgas@gmail.com','FCT','ABUJA.','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-21 08:13:45',5,'513','2021-08-23 11:38:10','513'),(3151,'','1','136','BLESSING GAS','BLESSING GAS','07034750366','blessinggas21@gmail.com','FCT','ABUJA.','LUGBE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-26 11:23:26',5,'513','2021-08-26 11:23:26','513'),(3152,'','1','136','CYARC INT.L LTD','AREA ,8 ABUJA','08033274001','isahgas@gmail.com','FCT','ABUJA.','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-27 09:18:39',5,'513','2021-08-27 09:18:39','513'),(3153,'','1','136','PROSPER GAS','PROSPER GAS','07015783842','mbgas@gmail.com','FCT','ABUJA.','ANGWAN CEMENT\r\nDAPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-27 14:05:51',5,'513','2021-08-27 14:05:51','513'),(3167,'','1','136','CHARLY-MORE OIL & GAS','CHARLY-MOREOIL & GAS','08075989630','mbgas@gmail.com','FCT','ABUJA.','AVIATION VILLAGE \r\nBASSA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-30 12:50:43',5,'513','2021-08-30 12:50:43','513'),(3240,'','1','136','HAJIYA HASIYA GAS','HAJIYA HASIYA GAS','08036088525','hajiyahasiya123@gmail.com','FCT','ABUJA.','WUSE MARKET','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-12 11:33:36',5,'513','2021-09-12 11:33:36','513'),(3309,'','1','136','CHRIS OIL AND GAS','BY IMPRESSIVE KARMO ABUJA','07019820299','isahgas@gmail.com','FCT','ABUJA.','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-18 06:11:56',5,'513','2021-09-18 06:11:56','513'),(3311,'','1','136','TOYIN GAS','TOYIN GAS','08142060589','mbgas@gmail.com','FCT','ABUJA.','TASHA 1','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-18 10:56:28',5,'513','2021-09-18 10:56:28','513'),(3319,'','1','136','CITIZEN GAS','CITIZEN GAS','08129569586','mbgas@gmail.com','FCT','ABUJA.','abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-19 07:11:07',5,'513','2021-09-26 16:01:12','513'),(3327,'','1','136','omoaje iol and gas','NILE GAS','08143773735','breakthroughgas@gmalcom','FCT','ABUJA','airport road abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-20 08:11:19',5,'513','2021-09-20 08:11:19','513'),(3341,'','1','136','EDEMA GAS','EDEMA GAS','08037864458','mbgas@gmail.com','FCT','ABUJA.','GARKI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-22 16:01:08',5,'513','2021-09-22 16:01:08','513'),(3345,'','1','136','NASONA GAS','NASONA GAS','09068515222','udgas@gmail.com','FCT','ABUJA.','JABI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-23 11:07:18',5,'513','2021-09-23 11:07:18','513'),(3356,'','1','136','JOSEPH GAS','GAGWA BY JUWA ROAD','07088133659','shotayooluwatosin2008@gmail.co','FCT','ABUJA.','ABUJA GAGWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-25 07:31:53',5,'513','2021-09-25 07:31:53','513'),(3360,'','1','136','IEESLINKS GAS','IEESLINKS GAS','07065692606','ieeslinksgas@gmail.com','FCT','ABUJA.','OLD KARMO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-25 11:50:01',5,'513','2021-09-25 11:50:01','513'),(3387,'','1','136','LUVEN LUSH GAS','LUVEN LUSH GAS','09038715233','luvenlushconfectionary@gmail.c','FCT','ABUJA','GWAGWA BUS STOP','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-03 16:13:58',5,'513','2021-10-03 16:13:58','513'),(3390,'','1','136','NEKE OIL AND GAS','GWARINPA ABUJA','09099696916','shotayooluwatosin2008@gmail.co','FCT','ABUJA.','GWARINPA ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-05 09:09:02',5,'513','2021-10-05 09:09:02','513'),(3392,'','1','136','A & B OIL AND GAS','A & B OIL AND GAS','08069542179','mbgas@gmail.com','FCT','ABUJA.','BWARI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-05 12:12:58',5,'513','2021-10-05 12:12:58','513'),(3398,'','1','136','S K GAS','S K GAS','09074595946','skgas100@gmail.com','FCT','ABUJA.','MAITAMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-05 12:59:55',5,'513','2021-10-05 12:59:55','513'),(3399,'','1','136','AKUKA OIL AND GAS','AKUKA OIL AND GAS','08036049206','mbgas@gmail.com','FCT','ABUJA.','BWARI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-05 13:05:29',5,'513','2021-10-05 13:05:29','513'),(3402,'','1','136','ZAKS GAS','ZAKS GAS','09040218828','udgas@gmail.com','FCT','ABUJA.','KARMO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-05 14:44:15',5,'513','2021-10-05 14:44:15','513'),(3407,'','1','136','NDUBUISI GAS','GWARINPA ABUJA','08037011816','udgas@gmail.com','FCT','ABUJA.','GWARINPA AMEH OBENI ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-06 09:03:24',5,'513','2021-10-06 09:03:24','513'),(3421,'','1','136','DELP GAS','DELP GAS','09066455665','delpgas01@gmail.com','F C T','ABUJA.','MABUSHI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-08 11:05:30',5,'513','2021-10-08 11:05:30','513'),(3620,'','1','136','ANGELIC RESOURCES','AGWARA SEMENT','08032432163','innocentokonankwai@gmail.com','FCT','ABUJA','ANGWAR SEMENT LIFE CAMP','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-28 09:40:15',5,'513','2021-10-28 09:40:15','513'),(3711,'','1','136','UC DENCO GAS','UC DENCO GAS','08036240053','mbgas@gmail.com','F C T','ABUJA.','TY JUNCTION, LAGOS STREET\r\nKUBWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-10 13:03:12',5,'513','2021-11-10 13:03:12','513'),(3712,'','1','136','C K GODSTIME GAS','C K GODSTIME GAS','08030836198','mbgas@gmail.com','F C T','ABUJA.','WUSE 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-10 13:16:54',5,'513','2021-11-10 13:17:34','513'),(3948,'','1','136','BAREEL GAS','JABI, ABUJA','08036014152','uchennaitalo@yahoo.com','ABUJA','ABUJA','JABI, ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-05 10:43:23',5,'513','2021-12-05 10:43:23','513'),(3995,'','1','136','CHI WISDOM GAS','DELP GAS','08062847588','delpgas01@gmail.com','F C T','ABUJA.','DELP ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-10 08:11:22',5,'513','2021-12-10 08:11:22','513'),(4016,'','1','136','AMAKA GAS','AMAKA GAS','08142281892','udgas@gmail.com','FCT','ABUJA.','AGURA JUNCTION\r\nOLD KARMO.','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-12 13:24:42',5,'513','2021-12-12 13:24:42','513'),(4027,'','1','136','GAS RORK','ASOKORO GAS','08036390514','delpgas01@gmail.com','F C T','ABUJA.','ASOKORO ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-15 09:08:37',5,'513','2021-12-15 09:08:37','513'),(4060,'','1','136','ND UTAKO GAS','ND UTAKO GAS','08133289636','ndutakogas@gmail.com','F C T','ABUJA.','UTAKO\r\n','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-20 10:51:23',5,'513','2021-12-20 10:51:23','513'),(4142,'','1','136','CY GAS','CY GAS','08033113888','cygas33@gmail.com','F C T','ABUJA.','JABI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-05 17:17:03',5,'513','2022-01-05 17:17:03','513'),(4161,'','1','136','TIM GAS','TIM GAS','08033174780','timgas123@gmail.com','F C T','ABUJA.','KATAMPE\r\n\r\n\r\n','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-09 12:12:49',5,'513','2022-01-09 12:12:49','513'),(4170,'','1','136','IFEANYI GAS','IFEANYI GAS','08115311561','ifeanyigas@gmail.com','FCT','ABUJA.','ONE MAN VILLAGE\r\nBEFORE BRIDGE, GWAGWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-13 13:52:21',5,'513','2022-01-13 13:52:21','513'),(4221,'','1','136','EMMANUEL GAS','EMMANUEL GAS','09155878276','mbgas@gmail.com','F C T','ABUJA.','BEHIND HAKIMI PALACE\r\nIDU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-21 13:18:40',5,'513','2022-01-21 13:18:40','513'),(4225,'','1','136','MEKASON GAS','JABI ABUJA','08038144238','innocentokonankwai@gmail.com','F C T','ABUJA','ABUJA JABI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-23 08:32:07',5,'513','2022-01-23 08:32:07','513'),(4245,'','1','136','BUY MY GAS LIMITED','GONI AHMED','08131375754, 08188424274','gonimuktarahmed@gmail.com','FCT','FCT','Little Accorns Lokogoma abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-28 12:55:55',5,'513','2022-01-28 13:03:09','513'),(4246,'','1','136','ODAN GAS','ODAN GAS','08036836549','mbgas@gmail.com','F C T','ABUJA.','ANGWAN IZZALA\r\nGWAGWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-11 13:02:13',5,'513','2022-02-11 13:02:13','513'),(4247,'','1','136','A D D GAS','GAGWA ABUJA','08162088702','innocentokonankwai@gmail.com','F C T','ABUJA.','GAGWA  KRAMO ABUAJ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-13 09:21:46',5,'513','2022-02-13 09:21:46','513'),(4248,'','1','136','DESTINY GAS','DESTINY GAS','09087826635','mbgas@gmail.com','F C T','ABUJA.','UNGWAN KIRYA\r\nGWAGWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-24 12:38:34',5,'513','2022-02-24 12:38:34','513'),(4249,'','1','136','DSP GAS','DSP GAS','09097256660','mbgas@gmail.com','F C T','ABUJA.','IDU INDUSTRIAL AREA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-24 15:46:35',5,'513','2022-02-24 15:46:35','513'),(4250,'','1','136','OMO GADS','ASOKOR ABUJA','08054805521','mbgas@gmail.com','F C T','ABUJA.','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-26 08:04:43',5,'513','2022-02-26 08:04:43','513'),(4251,'','1','136','FARDIRK MULTI CONCEPT','LIFE CAMP ABUJA','09089302272','innocentokonankwai@gmail.com','F C T','ABUJA.','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-01 18:45:18',5,'513','2022-03-01 18:45:18','513'),(4252,'','1','136','TFK GAS','TFK GAS','07039756913','mbgas@gmail.com','F C T','ABUJA.','OPPOSITE GSS JIWA\r\nJIWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-04 15:02:10',5,'513','2022-03-04 15:02:10','513'),(4253,'','1','136','CUE GAS','CUE GAS','08077524844','mbgas@gmail.com','F C T','ABUJA.','WUSE ZONE 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-04 16:36:45',5,'513','2022-03-04 16:36:45','513'),(4254,'','1','136','THRESHOLD GAS','THRESGHOLD GAS','08030641111','mbgas@gmail.com','F C T','ABUJA.','ONE MAN VILLAGE\r\nMARABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-05 18:40:44',5,'513','2022-03-05 18:40:44','513'),(4255,'','1','136','CNN ENERGY','ABDUL ','08039785869','mbgas@gmail.com','ABUJA','FCT','KUBUWA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-08 11:25:22',5,'513','2022-03-08 11:25:22','513'),(4256,'','1','136','OVERCOMER GAS','0VERCOMER GAS','09052190602','mbgas@gmail.com','ABUJA','FCT','2ND GATE\r\nGWARIMPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-01 11:55:32',5,'513','2022-04-01 11:56:17','513'),(4257,'','1','136','SUNNY GAZ','GWAGWALADA ABUJA','08062497287','mbgas@gmail.com','ABUJA','FCT','gwagwalada','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-04 08:55:42',5,'513','2022-04-04 08:55:42','513'),(4258,'','1','136','EYAA GAS','EYAA GAS','07034388111','eyaagasstation01@gmail.com','ABUJA','FCT','BEHIND ACCESS BANK\r\nKADO FISH MARKET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-04 12:56:20',5,'513','2022-04-04 12:56:20','513'),(4259,'','1','136','POWER POINT OIL & GAS','POWER POINT OIL & GAS','08115702003','powerpointoil&gasltd@gmail.com','ABUJA','FCT','JAHI VILLAGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-23 13:12:37',5,'513','2022-04-23 13:12:37','513'),(4260,'','1','136','ON GOD GAS','ON GOD GAS','09065320558','mbgas@gmail.com','ABUJA','FCT','IDU INDUSTRIAL AREA\r\nIDU RAILWAY ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-23 15:31:40',5,'513','2022-04-23 15:31:40','513'),(4261,'','1','136','EMMA GAS MINNA','EMMA GAS MINNA','08039208552','mbgas@gmail.com','ABUJA','FCT','MINNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-28 10:59:44',5,'513','2022-04-28 10:59:44','513'),(4262,'','1','136','EHIMA GAS','EHIMA GAS','08036825391','ehimagas@gmail.com','MINNA','NIGER','MINNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-03 13:11:29',5,'513','2022-05-03 13:11:29','513'),(4263,'','1','136','BLESSED UC GAS','BLESSED UC GAS','08036825391','ehimagas@gmail.com','ABUJA','FCT','BEFORE BRIDGE\r\nGWAGWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-04 17:11:21',5,'513','2022-05-04 17:11:21','513'),(4264,'','1','136','NESTLING GAS','NESTLING GAS','07061204843','ehimagas@gmail.com','ABUJA','FCT','WUYE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-27 16:01:41',5,'513','2022-05-27 16:01:41','513'),(4265,'','1','136','CORBY GAS','HASSAN AUDU MUSA','08170800051','ehimagas@gmail.com','ABUJA','FCT','QUEEN AMINA JNX BY YELLOW PAGE PHASE 2 KUBWA ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-29 12:32:19',5,'513','2022-05-29 12:32:19','513'),(4266,'','1','136','U C GAS','U C GAS','08071025272','ehimagas@gmail.com','ABUJA','FCT','POLICE SIGN BOARD\r\nDUSTE MAKARANTA\r\nDUTSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-30 15:17:52',5,'513','2022-05-30 15:17:52','513'),(4267,'','1','136','B M A GAS','YAHAYA UBALE','08065843215','ehimagas@gmail.com','ABUJA','FCT','SULE JA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-01 08:23:42',5,'513','2022-06-01 08:23:42','513'),(4268,'','1','136','John','A Y GAS','07032919407','eithsgjafg@gmail.com','Abuja ','FCT','Gearinpa','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-01 22:13:17',5,'513','2022-06-01 22:13:17','513'),(4269,'','1','136','SASFA GAS','SASFA GAS','08033328494','saidusaleh100@gmail.com','ABUJA','FCT','SHOP 2, MATAWALLE PLAZA\r\nPOLICE SIGN BOARD\r\nGWAGWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-05 11:02:43',5,'513','2022-07-05 11:02:43','513'),(4270,'','1','136','CHIBUZOR WINE','Chibuzor Wine','08144383344','lpg@aaranonigeria.com','ABUJA','FCT','Gwagwa Tashe 1','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-26 07:12:16',5,'513','2022-07-26 07:12:16','513'),(4271,'','1','136','FELIX GAS','FELIX ','08036128609','ehimagas@gmail.com','ABUJA','FCT','KUCHIIBENA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-06 09:32:35',5,'513','2022-08-06 09:32:35','513'),(4272,'','1','136','AES LUXY APARTMENT','HELLEN AKOWE','08065740946','lpg@aaranonigeria.com','ABUJA','FCT','SITE TECH JABI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-08 10:20:22',5,'513','2022-09-08 10:20:22','513'),(4273,'','1','136','EHIWISDOM GAS','ALFRED','07064434318','ehimagas@gmail.com','ABUJA','FCT','ANGWAN ROGO EDU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-05 14:14:52',5,'513','2022-10-05 14:14:52','513'),(4274,'','1','136','OBIDEX GAS','OSUJICHSOM JOVITA','08098008020','obidex@gmail.com','ABUJA','ABUJA','7th AVENUE GWARINPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 09:09:09',5,'513','2022-11-22 09:09:09','513'),(4275,'','1','136','ALSHADDAI GAS','WILLIAM','09066888040','obidex@gmail.com','ABUJA','ABUJA','ZAUDA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-25 10:04:47',5,'513','2022-11-25 10:04:47','513'),(4276,'','1','136','GAS POINT CAPITAL LIMITED','MBAH LEONA','07052422505','obidex@gmail.com','ABUJA','ABUJA','PLOT 513 WUSHISHI CRECENT UTAKO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-26 10:39:46',5,'513','2022-11-26 10:39:46','513'),(4277,'','1','136','SAMUEL GAS','SAMUEL GAS','08126687793','obidex@gmail.com','ABUJA','ABUJA','DUTSE SAUKALE\r\nDUTSE ALHAJI','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-27 15:39:47',5,'513','2023-01-27 15:39:47','513'),(4278,'','1','136','STANBEST GAS','STANBEST GAS','08181859160','obidex@gmail.com','FCT','ABUJA','KARMO GUEST INN\r\nKARMO\r\n','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-09 14:50:54',5,'513','2023-03-09 14:50:54','513'),(4279,'','1','136','NOBLE GAS','Bassey','09030705513','bassey@gmail.com','Abuja ','Abuja ','Akaraka Junction ','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-11 10:45:59',5,'513','2023-03-11 10:45:59','513');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16363 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','136',16362,'779',3947.52,4053.00,'2021-09-08','new','2021-09-08 18:39:14','483','483',2021,'483','2021-09-08 18:39:14',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2189 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','136','779',2188,'5','LPG NOZZLE',4174328.75,'LPG DISPENSER.','',NULL,NULL,'',5,'2020-08-12 11:47:31','479');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258077 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','136',146990,'daily shift','2020-08-12','2020-08-12 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-12 13:33:37','513','2020-08-12 13:35:58',10,0),('1','136',147046,'daily shift','2020-08-05','2020-08-05 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-12 21:01:43','513','2020-08-12 21:05:22',10,0),('1','136',147114,'daily shift','2020-08-06','2020-08-06 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-12 21:30:11','513','2020-08-13 02:26:36',10,0),('1','136',147161,'daily shift','2020-08-06','2020-08-06 00:00:00',NULL,'513',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','136',147179,'DIALY SHIFT','2020-08-06','2020-08-06 00:00:00',NULL,'487',0.00,0.00,'513','2020-08-13 10:45:07','513','2020-08-13 10:46:36',10,0),('1','136',147191,'daily shift','2020-08-07','2020-08-07 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-13 11:35:23','513','2020-08-13 11:36:40',10,0),('1','136',147206,'daily shift','2020-08-08','2020-08-08 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-13 11:53:55','513','2020-08-13 11:54:52',10,0),('1','136',147215,'daily shift','2020-08-09','2020-08-09 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-13 12:21:04','513','2020-08-13 12:23:04',10,0),('1','136',147227,'daily shift','2020-08-10','2020-08-10 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-13 13:06:39','513','2020-08-13 13:07:49',10,0),('1','136',147242,'daily shift','2020-08-13','2020-08-13 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-13 13:56:07','513','2020-08-13 13:56:42',10,0),('1','136',147255,'daily shift','2020-08-10','2020-08-10 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-13 14:13:54','513','2020-08-13 14:14:21',10,0),('1','136',147266,'daily shift','2020-08-11','2020-08-11 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-13 15:04:35','513','2020-08-13 15:05:09',10,0),('1','136',147277,'daily shift','2020-08-12','2020-08-12 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-13 15:28:28','513','2020-08-13 15:31:55',10,0),('1','136',147290,'daily shift','2020-08-13','2020-08-13 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-14 11:40:15','513','2020-08-14 12:04:34',10,0),('1','136',147376,'daily shift','2020-08-13','2020-08-13 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-14 14:45:58','513','2020-08-14 14:46:23',10,0),('1','136',147397,'daily shift','2020-08-13','2020-08-13 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-14 16:13:04','513','2020-08-14 16:13:40',10,0),('1','136',147407,'daily shift','2020-08-14','2020-08-14 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-14 16:37:45','513','2020-08-14 16:38:57',10,0),('1','136',147408,'daily shift','2020-08-14','2020-08-14 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-14 17:16:09','513','2020-08-14 17:17:06',10,0),('1','136',147823,'daily shift','2020-08-14','2020-08-14 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-17 15:49:03','513','2020-08-17 15:49:28',10,0),('1','136',147826,'daily shift','2020-08-15','2020-08-15 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-17 16:05:58','513','2020-08-17 16:06:21',10,0),('1','136',147831,'daily shift','2020-08-16','2020-08-16 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-17 16:20:19','513','2020-08-17 16:20:43',10,0),('1','136',147832,'daily shift','2020-08-17','2020-08-17 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-18 11:21:22','513','2020-08-18 11:21:43',10,0),('1','136',147910,'daily shift','2020-08-17','2020-08-17 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-18 11:42:50','513','2020-08-18 11:43:27',10,0),('1','136',148187,'daily shift','2020-08-18','2020-08-18 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-20 13:15:47','513','2020-08-20 13:16:27',10,0),('1','136',148295,'daily shift','2020-08-19','2020-08-19 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-21 10:48:15','513','2020-08-21 10:49:04',10,0),('1','136',148381,'daily shift','2020-08-19','2020-08-19 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-21 16:15:44','513','2020-08-21 16:16:10',10,0),('1','136',148608,'daily shift','2020-08-20','2020-08-20 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-23 13:48:30','513','2020-08-23 13:48:53',10,0),('1','136',148616,'daily shift','2020-08-21','2020-08-21 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-23 14:08:35','513','2020-08-23 14:08:57',10,0),('1','136',148621,'daily shift','2020-08-21','2020-08-21 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-23 14:29:21','513','2020-08-23 14:29:47',10,0),('1','136',148628,'daily shift','2020-08-22','2020-08-22 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-23 14:37:34','513','2020-08-23 14:38:43',10,0),('1','136',148632,'daily shift','2020-08-22','2020-08-22 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-23 15:01:26','513','2020-08-23 15:01:49',10,0),('1','136',148636,'daily shift','2020-08-22','2020-08-22 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-23 15:14:34','513','2020-08-23 15:15:02',10,0),('1','136',148637,'daily shift','2020-08-23','2020-08-23 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-24 15:24:46','513','2020-08-24 15:25:09',10,0),('1','136',148790,'daily shift','2020-08-24','2020-08-24 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-24 18:13:35','513','2020-08-24 18:16:24',10,0),('1','136',148994,'daily shift','2020-08-25','2020-08-25 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-26 09:36:00','513','2020-08-26 09:36:21',10,0),('1','136',149104,'daily shift','2020-08-26','2020-08-26 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-26 15:47:05','513','2020-08-26 15:48:08',10,0),('1','136',149393,'daily shift','2020-08-26','2020-08-26 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-28 14:33:55','513','2020-08-28 14:34:49',10,0),('1','136',149395,'daily shift','2020-08-27','2020-08-27 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-28 14:59:15','513','2020-08-28 14:59:47',10,0),('1','136',149430,'daily shift','2020-08-28','2020-08-28 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-28 17:17:24','513','2020-08-28 17:17:52',10,0),('1','136',149589,'daily shift','2020-08-29','2020-08-29 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-29 18:12:55','513','2020-08-29 18:13:16',10,0),('1','136',149593,'daily shift','2020-08-29','2020-08-29 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-29 21:21:11','513','2020-08-29 21:22:02',10,0),('1','136',149814,'daily shift','2020-08-30','2020-08-30 00:00:00',NULL,'513',0.00,0.00,'513','2020-08-31 15:34:26','513','2020-08-31 15:34:57',10,0),('1','136',149876,'daily shift','2020-08-31','2020-08-31 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-01 08:57:56','513','2020-09-01 08:58:19',10,0),('1','136',150024,'daily shift','2020-09-01','2020-09-01 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-02 08:31:20','513','2020-09-02 08:32:03',10,0),('1','136',150027,'daily shift','2020-09-01','2020-09-01 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-02 08:55:37','513','2020-09-02 08:56:02',10,0),('1','136',150158,'daily shift','2020-09-02','2020-09-02 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-02 20:07:28','513','2020-09-02 20:08:02',10,0),('1','136',150273,'daily shift','2020-09-03','2020-09-03 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-03 13:39:23','513','2020-09-03 13:39:50',10,0),('1','136',150356,'daily shift','2020-09-03','2020-09-03 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-03 17:33:15','513','2020-09-03 17:33:47',10,0),('1','136',150850,'daily shift','2020-09-04','2020-09-04 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-06 21:33:19','513','2020-09-06 21:33:51',10,0),('1','136',150851,'daily shift','2020-09-05','2020-09-05 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-06 21:42:26','513','2020-09-06 21:46:20',10,0),('1','136',150852,'daily shift','2020-09-06','2020-09-06 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-06 22:04:11','513','2020-09-06 22:05:27',10,0),('1','136',151003,'daily shift','2020-09-07','2020-09-07 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-07 20:35:56','513','2020-09-07 20:36:20',10,0),('1','136',151156,'daily shift','2020-09-08','2020-09-08 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-08 21:49:28','513','2020-09-08 21:49:53',10,0),('1','136',151285,'daily shift','2020-09-08','2020-09-08 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-09 20:35:10','513','2020-09-09 20:35:33',10,0),('1','136',151288,'daily shift','2020-09-09','2020-09-09 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-09 20:43:37','513','2020-09-09 20:45:18',10,0),('1','136',151421,'daily shift','2020-09-10','2020-09-10 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-10 18:39:56','513','2020-09-10 18:40:19',10,0),('1','136',151541,'daily shift','2020-09-11','2020-09-11 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-11 15:21:21','513','2020-09-11 15:21:46',10,0),('1','136',151761,'daily shift','2020-09-11','2020-09-11 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-13 13:48:42','513','2020-09-13 13:49:06',10,0),('1','136',151765,'daily shift','2020-09-12','2020-09-12 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-13 14:02:13','513','2020-09-13 14:02:39',10,0),('1','136',151770,'daily shift','2020-09-12','2020-09-12 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-13 14:14:13','513','2020-09-13 14:14:32',10,0),('1','136',151818,'daily shift','2020-09-13','2020-09-13 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-13 20:20:53','513','2020-09-13 20:21:29',10,0),('1','136',152072,'daily shift','2020-09-14','2020-09-14 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-15 11:59:20','513','2020-09-15 11:59:47',10,0),('1','136',152165,'daily shift','2020-09-15','2020-09-15 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-15 21:47:03','513','2020-09-15 21:47:34',10,0),('1','136',152385,'daily shift','2020-09-16','2020-09-16 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-17 13:07:16','513','2020-09-17 13:07:51',10,0),('1','136',152457,'DAILY SHIFT','2020-09-17','2020-09-17 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-17 18:24:27','513','2020-09-17 18:24:52',10,0),('1','136',152614,'DAILY SHIFT','2020-09-18','2020-09-18 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-18 20:11:41','513','2020-09-18 20:12:26',10,0),('1','136',152771,'DAILY SHIFT','2020-09-19','2020-09-19 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-19 21:26:52','513','2020-09-19 21:28:22',10,0),('1','136',152774,'DAILY SHIFT','2020-09-19','2020-09-19 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-20 12:09:04','513','2020-09-20 12:09:35',10,0),('1','136',152827,'DAILY SHIFT','2020-09-20','2020-09-20 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-20 12:16:44','513','2020-09-20 12:17:50',10,0),('1','136',152995,'DAILY SHIFT','2020-09-21','2020-09-21 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-21 13:51:18','513','2020-09-21 13:51:55',10,0),('1','136',152998,'DAILY SHIFT','2020-09-20','2020-09-20 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-21 14:00:12','513','2020-09-21 14:00:34',10,0),('1','136',153082,'DAILY SHIFT','2020-09-21','2020-09-21 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-21 19:31:20','513','2020-09-21 19:32:21',10,0),('1','136',153239,'DAILY SHIFT','2020-09-22','2020-09-22 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-23 12:26:19','513','2020-09-23 12:27:34',10,0),('1','136',153390,'DAILY SHIFT','2020-09-22','2020-09-22 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-23 13:15:11','513','2020-09-23 13:16:15',10,0),('1','136',153493,'DAILY SHIFT','2020-09-23','2020-09-23 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-24 08:06:51','513','2020-09-24 08:07:18',10,0),('1','136',153715,'DAILY SHIFT','2020-09-24','2020-09-24 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-25 12:47:02','513','2020-09-25 12:47:30',10,0),('1','136',153801,'DAILY SHIFT','2020-09-25','2020-09-25 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-25 20:05:36','513','2020-09-25 20:06:08',10,0),('1','136',153873,'DAILY SHIFT','2020-09-26','2020-09-26 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-28 16:58:47','513','2020-09-28 17:00:10',10,0),('1','136',154249,'DAILY SHIFT','2020-09-26','2020-09-26 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-28 21:48:22','513','2020-09-28 21:49:09',10,0),('1','136',154251,'DAILY SHIFT','2020-09-27','2020-09-27 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-28 22:00:05','513','2020-09-28 22:01:38',10,0),('1','136',154252,'DAILY SHIFT','2020-09-28','2020-09-28 00:00:00',NULL,'513',0.00,0.00,'513','2020-09-28 22:27:53','513','2020-09-28 22:28:22',10,0),('1','136',154623,'DAILY SHIFT','2020-09-30','2020-09-30 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-01 10:13:23','513','2020-10-01 10:13:44',10,0),('1','136',154825,'DAILY SHIFT','2020-10-01','2020-10-01 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-02 14:52:55','513','2020-10-02 14:53:36',10,0),('1','136',154832,'DAILY SHIFT','2020-10-02','2020-10-02 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-02 15:08:33','513','2020-10-02 15:09:04',10,0),('1','136',154857,'DAILY SHIFT','2020-10-02','2020-10-02 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-02 17:48:44','513','2020-10-02 17:49:05',10,0),('1','136',155118,'DAILY SHIFT','2020-10-03','2020-10-03 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-04 16:38:41','513','2020-10-04 16:39:06',10,0),('1','136',155256,'DAILY SHIFT','2020-10-04','2020-10-04 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-05 14:48:46','513','2020-10-05 14:49:10',10,0),('1','136',155280,'DAILY SHIFT','2020-10-05','2020-10-05 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-05 17:29:46','513','2020-10-05 17:30:26',10,0),('1','136',155642,'DAILY SHIFT','2020-10-06','2020-10-06 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-07 20:40:40','513','2020-10-07 20:41:03',10,0),('1','136',155648,'DAILY SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-07 21:08:39','513','2020-10-07 21:13:39',10,0),('1','136',155869,'DAILY SHIFT','2020-10-08','2020-10-08 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-09 15:25:02','513','2020-10-09 15:25:38',10,0),('1','136',155883,'DAILY SHIFT','2020-10-08','2020-10-08 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-09 15:52:26','513','2020-10-09 15:53:02',10,0),('1','136',155925,'DAILY SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-09 18:51:50','513','2020-10-09 18:52:16',10,0),('1','136',156009,'DAILY SHIFT','2020-10-10','2020-10-10 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-10 13:13:02','513','2020-10-10 13:13:34',10,0),('1','136',156135,'DAILY SHIFT','2020-10-10','2020-10-10 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-11 10:57:22','513','2020-10-11 10:57:58',10,0),('1','136',156380,'DAILY SHIFT ','2020-10-11','2020-10-11 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-12 16:01:51','513','2020-10-12 16:02:24',10,0),('1','136',156425,'DAILY SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-13 08:42:54','513','2020-10-13 08:43:30',10,0),('1','136',156579,'DAILY SHIFT','2020-10-13','2020-10-13 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-13 22:05:46','513','2020-10-13 22:06:09',10,0),('1','136',156739,'DAILY SHIFT','2020-10-14','2020-10-14 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-14 21:30:05','513','2020-10-14 21:30:37',10,0),('1','136',156870,'DAILY SHIFT','2020-10-15','2020-10-15 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-15 16:38:42','513','2020-10-15 16:39:54',10,0),('1','136',157087,'DAILY SHIFT','2020-10-16','2020-10-16 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-16 21:16:20','513','2020-10-16 21:16:46',10,0),('1','136',157274,'DAILY SHIFT','2020-10-17','2020-10-17 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-17 19:54:00','513','2020-10-17 19:54:26',10,0),('1','136',157484,'DAILY SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-19 09:11:19','513','2020-10-19 09:11:53',10,0),('1','136',157777,'DAILY SHIFT','2020-10-19','2020-10-19 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-20 15:52:09','513','2020-10-20 15:53:30',10,0),('1','136',157815,'DAILY SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-20 19:11:52','513','2020-10-20 19:12:25',10,0),('1','136',157976,'DAILY SHIFT ','2020-10-21','2020-10-21 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-22 09:28:23','513','2020-10-22 09:30:27',10,0),('1','136',158069,'DAILY SHIFT','2020-10-22','2020-10-22 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-22 17:35:39','513','2020-10-22 17:36:15',10,0),('1','136',158071,'DAILY SHIFT','2020-10-22','2020-10-22 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-22 17:51:32','513','2020-10-22 17:52:07',10,0),('1','136',158734,'DAILY SHIFT','2020-10-23','2020-10-23 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-26 17:28:49','513','2020-10-26 17:29:30',10,0),('1','136',158735,'DAILY SHIFT','2020-10-24','2020-10-24 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-26 17:43:43','513','2020-10-26 17:44:29',10,0),('1','136',158737,'DAILY SHIFT','2020-10-25','2020-10-25 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-26 17:49:20','513','2020-10-26 17:49:44',10,0),('1','136',158738,'DAILY SHIFT','2020-10-26','2020-10-26 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-27 12:00:45','513','2020-10-27 12:01:03',10,0),('1','136',158905,'DAILY SHIFT','2020-10-27','2020-10-27 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-27 18:01:00','513','2020-10-27 18:01:36',10,0),('1','136',159093,'DAILY SHIFT','2020-10-28','2020-10-28 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-28 16:52:33','513','2020-10-28 16:53:49',10,0),('1','136',159333,'DAILY SHIFT','2020-10-29','2020-10-29 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-30 10:09:15','513','2020-10-30 10:10:15',10,0),('1','136',159437,'DAILY SHIFT','2020-10-30','2020-10-30 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-30 17:06:51','513','2020-10-30 17:07:16',10,0),('1','136',159601,'DAILY SHIFT','2020-10-31','2020-10-31 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-31 16:06:43','513','2020-10-31 16:07:17',10,0),('1','136',159621,'DAILY SHIFT','2020-10-31','2020-10-31 00:00:00',NULL,'513',0.00,0.00,'513','2020-10-31 18:06:44','513','2020-10-31 18:07:27',10,0),('1','136',159732,'DAILY SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-01 19:04:20','513','2020-11-01 19:04:58',10,0),('1','136',159735,'DAILY SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-01 19:19:54','513','2020-11-01 19:20:27',10,0),('1','136',159947,'DAILY SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-02 20:01:52','513','2020-11-02 20:02:32',10,0),('1','136',160027,'DAILY SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-03 11:52:09','513','2020-11-03 11:53:06',10,0),('1','136',160121,'DAILY SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-03 18:30:33','513','2020-11-03 18:31:05',10,0),('1','136',160229,'DAILY SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-04 12:57:01','513','2020-11-04 12:58:06',10,0),('1','136',160300,'DAILY SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-04 17:38:49','513','2020-11-04 17:39:19',10,0),('1','136',160446,'DAILY SHIFT','2020-11-05','2020-11-05 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-05 18:12:31','513','2020-11-05 18:14:32',10,0),('1','136',160584,'DAILY SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-06 17:34:01','513','2020-11-06 17:34:32',10,0),('1','136',160805,'DAILY SHIFT','2020-11-08','2020-11-08 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-08 11:47:07','513','2020-11-08 11:47:29',10,0),('1','136',160808,'DAILY SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-08 11:58:52','513','2020-11-08 11:59:19',10,0),('1','136',160821,'DAILY SHIFT','2020-11-08','2020-11-08 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-09 11:13:17','513','2020-11-09 11:13:42',10,0),('1','136',161078,'DAILY SHIFT','2020-11-09','2020-11-09 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-10 09:43:31','513','2020-11-10 09:43:49',10,0),('1','136',161345,'DAILY SHIFT','2020-11-10','2020-11-10 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-13 12:15:26','513','2020-11-13 12:15:45',10,0),('1','136',161807,'DAILY SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-13 15:06:10','513','2020-11-13 15:06:32',10,0),('1','136',161811,'DAILY SHIFT','2020-11-12','2020-11-12 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-13 15:15:25','513','2020-11-13 15:15:46',10,0),('1','136',161853,'DAILY SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-13 17:59:00','513','2020-11-13 17:59:21',10,0),('1','136',162200,'DAILY SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-15 16:29:33','513','2020-11-15 16:29:52',10,0),('1','136',162212,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-15 17:24:29','513','2020-11-15 17:25:01',10,0),('1','136',162450,'DAILY SHIFT','2020-11-16','2020-11-16 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-16 18:25:34','513','2020-11-16 18:26:00',10,0),('1','136',162688,'DAILY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-18 09:27:59','513','2020-11-18 09:28:32',10,0),('1','136',162794,'DAILY SHIFT','2020-11-18','2020-11-18 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-18 17:32:44','513','2020-11-18 17:33:06',10,0),('1','136',163067,'DAILY SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-20 10:17:04','513','2020-11-20 10:17:37',10,0),('1','136',163188,'DAILY SHIFT','2020-11-20','2020-11-20 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-20 17:26:28','513','2020-11-20 17:27:41',10,0),('1','136',163359,'DAILY SHIFT','2020-11-21','2020-11-21 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-21 17:19:12','513','2020-11-21 17:19:47',10,0),('1','136',163536,'DAILY SHIFT','2020-11-22','2020-11-22 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-22 17:41:14','513','2020-11-22 17:41:37',10,0),('1','136',163773,'DAILY SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-24 09:31:15','513','2020-11-24 09:32:28',10,0),('1','136',163890,'DAILY SHIFT','2020-11-24','2020-11-24 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-24 17:19:50','513','2020-11-24 17:20:46',10,0),('1','136',164236,'DAILY SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-26 16:48:56','513','2020-11-26 16:49:11',10,0),('1','136',164239,'DAILY SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-26 17:04:53','513','2020-11-26 17:05:14',10,0),('1','136',164429,'DAILY SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-27 17:24:48','513','2020-11-27 17:25:13',10,0),('1','136',164591,'DAILY SHIFT','2020-11-28','2020-11-28 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-28 17:57:39','513','2020-11-28 17:58:09',10,0),('1','136',164729,'DAILY SHIFT','2020-11-29','2020-11-29 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-29 16:53:39','513','2020-11-29 16:54:00',10,0),('1','136',164953,'DAILY SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'513',0.00,0.00,'513','2020-11-30 17:29:47','513','2020-11-30 17:30:06',10,0),('1','136',165112,'DAILY SHIFT','2020-12-01','2020-12-01 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-01 17:19:48','513','2020-12-01 17:20:27',10,0),('1','136',165275,'DAILY SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-02 17:04:58','513','2020-12-02 17:05:17',10,0),('1','136',165435,'DAILY SHIFT','2020-12-03','2020-12-03 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-03 17:25:18','513','2020-12-03 17:25:55',10,0),('1','136',165599,'DAILY SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-04 17:33:42','513','2020-12-04 17:34:08',10,0),('1','136',165750,'DAILY SHIFT','2020-12-05','2020-12-05 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-05 15:10:52','513','2020-12-05 15:11:31',10,0),('1','136',165778,'DAILY SHIFT','2020-12-05','2020-12-05 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-05 17:21:10','513','2020-12-05 17:21:40',10,0),('1','136',165916,'DAILY SHIFT','2020-12-06','2020-12-06 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-06 17:50:05','513','2020-12-06 17:50:21',10,0),('1','136',166126,'DAILY SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-07 17:21:38','513','2020-12-07 17:22:09',10,0),('1','136',166305,'DAILY SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-08 17:30:28','513','2020-12-08 17:31:13',10,0),('1','136',166462,'DAILY SHIFT','2020-12-09','2020-12-09 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-09 17:13:58','513','2020-12-09 17:14:18',10,0),('1','136',166678,'DAILY SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-10 17:00:58','513','2020-12-10 17:01:25',10,0),('1','136',166864,'DAILY SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-11 17:01:29','513','2020-12-11 17:01:50',10,0),('1','136',167289,'DAILY SHIFT','2020-12-12','2020-12-12 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-14 13:13:39','513','2020-12-14 13:14:01',10,0),('1','136',167293,'DAILY SHIFT','2020-12-13','2020-12-13 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-14 13:27:13','513','2020-12-14 13:27:49',10,0),('1','136',167350,'DAILY SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-14 17:14:46','513','2020-12-14 17:15:12',10,0),('1','136',167555,'DAILY SHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-15 17:13:48','513','2020-12-15 17:14:16',10,0),('1','136',167712,'DAILY SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-16 17:18:39','513','2020-12-16 17:19:46',10,0),('1','136',167892,'DAILY SHIFT','2020-12-17','2020-12-17 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-17 17:05:58','513','2020-12-17 17:06:21',10,0),('1','136',168105,'DAILY SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-18 18:11:09','513','2020-12-18 18:11:31',10,0),('1','136',168109,'DAILY SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-18 18:31:14','513','2020-12-18 18:31:30',10,0),('1','136',168276,'DAILY SHIFT','2020-12-19','2020-12-19 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-21 08:53:19','513','2020-12-21 08:53:44',10,0),('1','136',168454,'DAILY SHIFT','2020-12-20','2020-12-20 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-21 09:04:54','513','2020-12-21 09:05:11',10,0),('1','136',168593,'DAILY SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-21 17:42:46','513','2020-12-21 17:43:09',10,0),('1','136',168807,'DAILY SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-23 08:21:05','513','2020-12-23 08:21:29',10,0),('1','136',168812,'DAILY SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-23 08:32:48','513','2020-12-23 08:34:00',10,0),('1','136',168997,'DAILY SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-24 10:47:23','513','2020-12-24 10:47:46',10,0),('1','136',169082,'DAILY SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-24 18:42:20','513','2020-12-24 18:43:16',10,0),('1','136',169102,'DAILY SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-24 19:29:51','513','2020-12-24 19:30:11',10,0),('1','136',169247,'DAILY SHIFT','2020-12-25','2020-12-25 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-25 17:17:30','513','2020-12-25 17:17:55',10,0),('1','136',169457,'DAILY SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-27 00:29:12','513','2020-12-27 00:29:53',10,0),('1','136',169552,'DAILY SHIFT','2020-12-27','2020-12-27 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-27 16:27:59','513','2020-12-27 16:28:43',10,0),('1','136',169917,'DAILY SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-29 18:17:48','513','2020-12-29 18:18:15',10,0),('1','136',170059,'DAILY SHIFT','2020-12-29','2020-12-29 00:00:00',NULL,'513',0.00,0.00,'513','2020-12-30 14:14:35','513','2020-12-30 14:15:21',10,0),('1','136',170466,'DAILY SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-01 16:42:38','513','2021-01-01 16:43:05',10,0),('1','136',170471,'DAILY SHIFT','2020-12-31','2020-12-31 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-01 17:15:34','513','2021-01-01 17:15:56',10,0),('1','136',170777,'DAILY SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-03 15:44:37','513','2021-01-03 15:45:14',10,0),('1','136',170946,'DAILY SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-04 15:30:07','513','2021-01-04 15:30:32',10,0),('1','136',171173,'DAILY SHIFT','2021-01-04','2021-01-04 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-05 15:44:16','513','2021-01-05 15:44:38',10,0),('1','136',171301,'DAILY SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-06 13:59:34','513','2021-01-06 14:00:10',10,0),('1','136',171303,'DAILY SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-06 14:06:59','513','2021-01-06 14:07:45',10,0),('1','136',171380,'DAILY SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-06 19:48:23','513','2021-01-06 19:48:51',10,0),('1','136',171657,'DAILY SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-08 11:21:32','513','2021-01-08 11:21:55',10,0),('1','136',171744,'DAILY SHIFT9','2021-01-08','2021-01-08 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-08 17:08:58','513','2021-01-08 17:09:30',10,0),('1','136',171938,'DAILY SHIFT9','2021-01-09','2021-01-09 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-09 18:05:53','513','2021-01-09 18:06:28',10,0),('1','136',172065,'DAILY SHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-10 17:10:42','513','2021-01-10 17:11:11',10,0),('1','136',172255,'DAILY SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-11 18:45:22','513','2021-01-11 18:45:41',10,0),('1','136',172462,'DAILY SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-12 17:12:45','513','2021-01-12 17:13:05',10,0),('1','136',172682,'DAILY SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-13 17:07:47','513','2021-01-13 17:08:07',10,0),('1','136',172857,'DAILY SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-14 17:34:04','513','2021-01-14 17:34:26',10,0),('1','136',173032,'DAILY SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-15 17:34:08','513','2021-01-15 17:34:33',10,0),('1','136',173194,'DAILY SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-16 17:25:40','513','2021-01-16 17:26:09',10,0),('1','136',173347,'DAILY SHIFT','2021-01-17','2021-01-17 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-17 17:20:32','513','2021-01-17 17:21:11',10,0),('1','136',173571,'DAILY SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-18 18:01:23','513','2021-01-18 18:01:45',10,0),('1','136',173745,'DAILY SHIFT','2021-01-19','2021-01-19 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-19 17:18:28','513','2021-01-19 17:18:57',10,0),('1','136',173927,'DAILY SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-20 17:57:26','513','2021-01-20 17:57:53',10,0),('1','136',173928,'DAILY SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-20 18:11:30','513','2021-01-20 18:11:48',10,0),('1','136',174115,'DAILY SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-21 18:21:48','513','2021-01-21 18:22:16',10,0),('1','136',174297,'DAILY SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-22 17:48:45','513','2021-01-22 17:49:22',10,0),('1','136',174471,'DAILY SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-23 17:52:27','513','2021-01-23 17:52:55',10,0),('1','136',174609,'DAILY SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-24 17:31:07','513','2021-01-24 17:31:48',10,0),('1','136',174822,'DAILY SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-25 18:09:33','513','2021-01-25 18:09:51',10,0),('1','136',175021,'DAILY SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-26 17:56:45','513','2021-01-26 17:57:02',10,0),('1','136',175276,'DAILY SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-28 09:04:35','513','2021-01-28 09:04:57',10,0),('1','136',175392,'DAILY SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-28 17:37:04','513','2021-01-28 17:41:44',10,0),('1','136',175573,'DAILY SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-30 07:33:44','513','2021-01-30 07:34:04',10,0),('1','136',175850,'DAILY SHIFT','2021-01-30','2021-01-30 00:00:00',NULL,'513',0.00,0.00,'513','2021-01-31 13:39:35','513','2021-01-31 13:40:38',10,0),('1','136',176051,'DAILY SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-01 13:24:49','513','2021-02-01 13:25:16',10,0),('1','136',176158,'DAILY SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-02 07:34:38','513','2021-02-02 07:35:00',10,0),('1','136',176307,'DAILY SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-02 18:16:37','513','2021-02-02 18:17:04',10,0),('1','136',176520,'DAILY SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-03 18:16:28','513','2021-02-03 18:17:07',10,0),('1','136',176744,'DAILY SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-04 17:54:52','513','2021-02-04 17:55:12',10,0),('1','136',176954,'DAILY S360','2021-02-05','2021-02-05 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-05 18:57:08','513','2021-02-05 18:57:36',10,0),('1','136',177149,'DAILY SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-06 15:41:07','513','2021-02-06 15:41:39',10,0),('1','136',177181,'DAILY SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-07 14:49:20','513','2021-02-07 14:49:51',10,0),('1','136',177400,'DAILY SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-07 18:22:49','513','2021-02-07 18:23:22',10,0),('1','136',177596,'DAILY SHIFT','2021-02-08','2021-02-08 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-08 17:38:14','513','2021-02-08 17:41:06',10,0),('1','136',177852,'DAILY SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-09 17:56:04','513','2021-02-09 17:56:35',10,0),('1','136',178043,'DAILY SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-10 17:51:29','513','2021-02-10 17:51:53',10,0),('1','136',178235,'DAILY SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-11 17:53:15','513','2021-02-11 17:53:56',10,0),('1','136',178393,'DAILY SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-12 14:13:48','513','2021-02-12 14:14:19',10,0),('1','136',178522,'DAILY SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-13 08:33:04','513','2021-02-13 08:33:29',10,0),('1','136',178599,'DAILY SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-13 12:34:26','513','2021-02-13 12:34:51',10,0),('1','136',178658,'DAILY SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-14 14:41:39','513','2021-02-14 14:42:20',10,0),('1','136',178918,'DAILY SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-15 08:16:54','513','2021-02-15 08:17:16',10,0),('1','136',178919,'DAILY SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-15 08:23:27','513','2021-02-15 08:23:49',10,0),('1','136',178994,'DAILY SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-16 13:02:48','513','2021-02-16 13:04:12',10,0),('1','136',179270,'DAILY SHIFT','2021-02-16','2021-02-16 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-16 18:32:09','513','2021-02-16 18:32:50',10,0),('1','136',179372,'DAILY SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-18 07:18:18','513','2021-02-18 07:19:17',10,0),('1','136',179581,'DAILY SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-18 17:31:00','513','2021-02-18 17:31:27',10,0),('1','136',179773,'DAILY SHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-19 17:42:03','513','2021-02-19 17:42:57',10,0),('1','136',179994,'DAILY SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-20 18:00:36','513','2021-02-20 18:01:49',10,0),('1','136',180180,'DAILY SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-22 07:04:57','513','2021-02-22 07:06:37',10,0),('1','136',180344,'DAILY SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-22 17:38:28','513','2021-02-22 17:38:59',10,0),('1','136',180546,'DAILY SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-23 08:24:49','513','2021-02-23 08:27:07',10,0),('1','136',180567,'DAILY SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-23 17:46:15','513','2021-02-23 17:49:14',10,0),('1','136',180735,'DAILY SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-24 18:11:39','513','2021-02-24 18:12:07',10,0),('1','136',180963,'DAILY SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-25 18:02:10','513','2021-02-25 18:02:34',10,0),('1','136',181136,'DAILY SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-26 18:59:20','513','2021-02-26 19:00:08',10,0),('1','136',181339,'DAILY SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-27 17:47:38','513','2021-02-27 17:48:11',10,0),('1','136',181529,'DAILY SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'513',0.00,0.00,'513','2021-02-28 17:47:18','513','2021-02-28 17:48:01',10,0),('1','136',181718,'DAILY SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-01 18:25:59','513','2021-03-01 18:26:41',10,0),('1','136',181910,'DAILY SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-02 18:12:09','513','2021-03-02 18:12:42',10,0),('1','136',182110,'DAILY SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-03 07:03:02','513','2021-03-03 07:05:36',10,0),('1','136',182111,'DAILY SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-03 17:52:36','513','2021-03-03 17:53:24',10,0),('1','136',182305,'DAILY SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-04 07:35:39','513','2021-03-04 07:40:56',10,0),('1','136',182321,'DAILY SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-04 17:56:02','513','2021-03-04 17:57:15',10,0),('1','136',182502,'DAILY SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-05 18:00:04','513','2021-03-05 18:00:33',10,0),('1','136',182680,'DAILY SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-08 12:22:10','513','2021-03-08 12:22:38',10,0),('1','136',183095,'DAILY SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-08 12:43:48','513','2021-03-08 12:44:18',10,0),('1','136',183180,'DAILY SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-08 18:35:32','513','2021-03-08 18:36:02',10,0),('1','136',183214,'DAILY SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-09 17:26:00','513','2021-03-09 17:26:43',10,0),('1','136',183424,'DAILY SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-10 08:40:57','513','2021-03-10 08:41:25',10,0),('1','136',183469,'DAILY SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-10 17:35:48','513','2021-03-10 17:36:28',10,0),('1','136',183643,'DAILY SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-11 17:30:59','513','2021-03-11 17:31:29',10,0),('1','136',183871,'DAILY SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-12 17:51:20','513','2021-03-12 17:51:52',10,0),('1','136',184153,'DAILY SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-13 18:12:31','513','2021-03-13 18:13:24',10,0),('1','136',184265,'DAILY SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-14 17:39:02','513','2021-03-14 17:39:36',10,0),('1','136',184469,'DAILY SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-15 15:55:38','513','2021-03-15 15:56:18',10,0),('1','136',184633,'DAILY SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-15 18:23:13','513','2021-03-15 18:24:30',10,0),('1','136',184697,'DAILY SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-16 17:29:38','513','2021-03-16 17:30:03',10,0),('1','136',184896,'DAILY SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-17 17:25:17','513','2021-03-17 17:26:48',10,0),('1','136',185114,'DAILY SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-18 17:18:03','513','2021-03-18 17:18:24',10,0),('1','136',185260,'DAILY SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-19 17:13:43','513','2021-03-19 17:14:07',10,0),('1','136',185467,'DAILY SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-20 17:14:18','513','2021-03-20 17:14:42',10,0),('1','136',185674,'DAILY SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-21 18:41:12','513','2021-03-21 18:41:36',10,0),('1','136',185880,'DAILY SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-22 13:14:15','513','2021-03-22 13:14:35',10,0),('1','136',185976,'DAILY SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-22 18:41:20','513','2021-03-22 18:42:08',10,0),('1','136',186078,'DAILY SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-23 17:48:21','513','2021-03-23 17:48:46',10,0),('1','136',186318,'DAILY SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-24 17:28:44','513','2021-03-24 17:29:18',10,0),('1','136',186533,'DAILY SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-25 18:13:02','513','2021-03-25 18:14:04',10,0),('1','136',186755,'DAILY SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-26 17:40:25','513','2021-03-26 17:40:52',10,0),('1','136',186985,'DAILY SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-27 17:19:25','513','2021-03-27 17:19:59',10,0),('1','136',187159,'DAILY SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-28 09:21:33','513','2021-03-28 09:22:15',10,0),('1','136',187207,'DAILY SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-28 17:33:57','513','2021-03-28 17:34:26',10,0),('1','136',187376,'DAILY SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-29 18:14:20','513','2021-03-29 18:14:58',10,0),('1','136',187611,'DAILY SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-30 18:02:34','513','2021-03-30 18:43:07',10,0),('1','136',187837,'DAILY SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'513',0.00,0.00,'513','2021-03-31 17:24:59','513','2021-03-31 17:25:37',10,0),('1','136',188020,'DAILY SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-01 18:20:21','513','2021-04-01 18:20:45',10,0),('1','136',188218,'DAILY SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-02 17:46:41','513','2021-04-02 17:47:08',10,0),('1','136',188429,'DAILY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-03 11:57:35','513','2021-04-03 11:58:04',10,0),('1','136',188504,'DAILY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-03 18:17:54','513','2021-04-03 18:18:23',10,0),('1','136',188609,'DAILY SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-04 06:49:21','513','2021-04-04 06:49:49',10,0),('1','136',188612,'DAILY SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-04 18:07:21','513','2021-04-04 18:07:53',10,0),('1','136',188812,'DAILY SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-05 17:37:55','513','2021-04-05 17:38:47',10,0),('1','136',189015,'DAILY SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-06 17:36:59','513','2021-04-06 17:37:47',10,0),('1','136',189212,'DAILY SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-07 18:05:01','513','2021-04-07 18:06:02',10,0),('1','136',189427,'DAILY SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-08 17:41:59','513','2021-04-08 17:42:30',10,0),('1','136',189622,'DAILY SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-09 17:33:32','513','2021-04-09 17:34:09',10,0),('1','136',189811,'DAILY SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-10 10:37:15','513','2021-04-10 10:37:44',10,0),('1','136',189890,'DAILY SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-10 17:49:35','513','2021-04-10 17:50:03',10,0),('1','136',190034,'DAILY SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-11 17:47:09','513','2021-04-11 17:47:36',10,0),('1','136',190216,'DAILY SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-12 18:20:32','513','2021-04-12 18:21:43',10,0),('1','136',190445,'DAILY SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-13 17:25:26','513','2021-04-13 17:25:56',10,0),('1','136',190667,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-15 07:03:11','513','2021-04-15 07:03:41',10,0),('1','136',190895,'DAILY SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-15 17:11:09','513','2021-04-15 17:13:17',10,0),('1','136',191087,'DAILY SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-16 16:52:09','513','2021-04-16 16:52:52',10,0),('1','136',191296,'DAILY SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-17 16:34:03','513','2021-04-17 16:34:40',10,0),('1','136',191501,'DAILY SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-18 07:20:12','513','2021-04-18 07:20:46',10,0),('1','136',191508,'DAILY SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-18 17:03:06','513','2021-04-18 17:03:41',10,0),('1','136',191708,'DAILY SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-19 17:30:30','513','2021-04-19 17:34:32',10,0),('1','136',191940,'DAILY SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-20 17:51:50','513','2021-04-20 17:52:35',10,0),('1','136',192135,'DAILY SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-21 21:04:25','513','2021-04-21 21:04:47',10,0),('1','136',192535,'DAILY SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-22 17:35:52','513','2021-04-22 17:36:09',10,0),('1','136',192569,'DAILY SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-23 17:26:10','513','2021-04-23 17:27:00',10,0),('1','136',192753,'DAILY SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-24 17:18:30','513','2021-04-24 17:19:20',10,0),('1','136',192955,'DAILY SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-26 07:09:51','513','2021-04-26 07:10:32',10,0),('1','136',193188,'DAILY SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-26 09:46:35','513','2021-04-26 09:47:00',10,0),('1','136',193237,'DAILY SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-26 17:28:12','513','2021-04-26 17:28:27',10,0),('1','136',193372,'Daily shift','2021-04-26','2021-04-26 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-26 17:33:02','513','2021-04-26 17:33:20',10,0),('1','136',193418,'DAILY SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-27 16:58:06','513','2021-04-27 16:58:44',10,0),('1','136',193621,'DAILY SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-28 17:57:19','513','2021-04-28 17:58:42',10,0),('1','136',193897,'DAILY SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'513',0.00,0.00,'513','2021-04-29 17:48:06','513','2021-04-29 17:48:54',10,0),('1','136',194237,'DAILY SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-01 16:21:12','513','2021-05-01 16:23:07',10,0),('1','136',194443,'DAILY SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-01 18:12:20','513','2021-05-01 18:12:44',10,0),('1','136',194485,'DAILY SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-02 16:38:30','513','2021-05-02 16:39:25',10,0),('1','136',194681,'DAILY SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-03 17:15:58','513','2021-05-03 17:17:06',10,0),('1','136',195046,'DAILY SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-04 17:39:27','513','2021-05-04 17:40:28',10,0),('1','136',195195,'Daily shift','2021-05-05','2021-05-05 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-05 11:52:01','513','2021-05-05 11:53:10',10,0),('1','136',195254,'DAILY SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-05 17:44:13','513','2021-05-05 17:44:36',10,0),('1','136',195330,'DAILY SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-06 17:01:00','513','2021-05-06 17:01:55',10,0),('1','136',195516,'DAILY SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-07 17:17:44','513','2021-05-07 17:18:18',10,0),('1','136',195782,'DAILY SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-08 17:59:13','513','2021-05-08 18:02:02',10,0),('1','136',196189,'Daily shift','2021-05-09','2021-05-09 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-09 19:23:52','513','2021-05-09 19:24:12',10,0),('1','136',196274,'Daily shift','2021-05-10','2021-05-10 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-10 08:13:48','513','2021-05-10 08:14:12',10,0),('1','136',196404,'DAILY SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-10 17:20:29','513','2021-05-10 17:21:02',10,0),('1','136',196600,'DAILY SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-11 17:34:08','513','2021-05-11 17:35:27',10,0),('1','136',196833,'DAILY SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-12 17:31:40','513','2021-05-12 17:31:56',10,0),('1','136',197002,'Daily shift','2021-05-13','2021-05-13 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-13 20:10:03','513','2021-05-13 20:10:23',10,0),('1','136',197179,'Daily shift','2021-05-14','2021-05-14 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-14 17:36:50','513','2021-05-14 17:37:08',10,0),('1','136',197404,'DAILY SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-16 13:29:16','513','2021-05-16 13:30:02',10,0),('1','136',197413,'DAILY SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-16 17:34:35','513','2021-05-16 17:34:55',10,0),('1','136',197512,'DAILY SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-17 17:16:33','513','2021-05-17 17:16:54',10,0),('1','136',197879,'DAILY SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-18 17:40:38','513','2021-05-18 17:41:16',10,0),('1','136',198138,'DAILY SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-19 12:52:15','513','2021-05-19 12:52:41',10,0),('1','136',198240,'DAILY SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-19 17:57:27','513','2021-05-19 17:58:03',10,0),('1','136',198352,'DAILY SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-20 22:47:34','513','2021-05-20 22:48:13',10,0),('1','136',198579,'DAILY SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-21 21:46:53','513','2021-05-22 05:58:12',10,0),('1','136',198796,'DAILY SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-23 07:19:23','513','2021-05-23 07:20:19',10,0),('1','136',199144,'Daily shift','2021-05-23','2021-05-23 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-23 16:07:19','513','2021-05-23 16:07:37',10,0),('1','136',199145,'DAILY SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-23 17:11:50','513','2021-05-23 17:12:16',10,0),('1','136',199151,'DAILY SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-24 13:21:12','513','2021-05-24 13:21:41',10,0),('1','136',199398,'DAILY SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-24 18:33:03','513','2021-05-24 18:33:29',10,0),('1','136',199604,'DAILY SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-25 17:14:40','513','2021-05-25 17:15:07',10,0),('1','136',199646,'DAILY SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-26 17:36:15','513','2021-05-26 17:36:30',10,0),('1','136',200040,'DAILY SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-27 15:27:08','513','2021-05-27 15:27:25',10,0),('1','136',200264,'DAILY SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-28 17:35:43','513','2021-05-28 17:36:23',10,0),('1','136',200331,'DAILY SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-29 17:18:19','513','2021-05-29 17:18:58',10,0),('1','136',200493,'DAILY SHIFT9','2021-05-30','2021-05-30 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-30 17:51:05','513','2021-05-30 17:51:43',10,0),('1','136',200697,'DAILY SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'513',0.00,0.00,'513','2021-05-31 17:19:53','513','2021-05-31 17:24:03',10,0),('1','136',200938,'DAILY SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-01 18:28:04','513','2021-06-01 18:29:16',10,0),('1','136',201114,'DAILY SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-02 18:08:09','513','2021-06-02 18:08:56',10,0),('1','136',201348,'DAILY SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-03 17:53:39','513','2021-06-03 17:54:24',10,0),('1','136',201499,'DAILY SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-04 17:22:20','513','2021-06-04 17:25:38',10,0),('1','136',201765,'DAILY SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-05 13:39:04','513','2021-06-05 13:39:52',10,0),('1','136',201948,'DAILY SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-05 15:48:22','513','2021-06-05 15:48:41',10,0),('1','136',202072,'Daily shift','2021-06-06','2021-06-06 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-06 09:04:55','513','2021-06-06 09:05:36',10,0),('1','136',202151,'DAILY SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-06 15:33:37','513','2021-06-06 15:33:54',10,0),('1','136',202317,'DAILY SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-07 18:21:06','513','2021-06-07 18:21:36',10,0),('1','136',202433,'DAILY SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-08 13:46:39','513','2021-06-08 13:47:34',10,0),('1','136',202556,'DAILY SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-08 17:59:54','513','2021-06-08 18:00:25',10,0),('1','136',202650,'DAILY SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-09 12:40:15','513','2021-06-09 12:40:48',10,0),('1','136',202801,'DAILY SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-09 17:39:18','513','2021-06-09 17:40:40',10,0),('1','136',202859,'DAILY SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-10 18:06:26','513','2021-06-10 18:07:29',10,0),('1','136',203119,'DAILY SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-11 16:02:05','513','2021-06-11 16:02:41',10,0),('1','136',203274,'DAILY SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-11 18:22:36','513','2021-06-11 18:22:53',10,0),('1','136',203481,'DAILY SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-12 17:02:15','513','2021-06-12 17:02:34',10,0),('1','136',203486,'DAILY SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-12 18:03:06','513','2021-06-12 18:03:21',10,0),('1','136',203628,'DAILY SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-13 13:32:08','513','2021-06-13 13:32:34',10,0),('1','136',203638,'DAILY SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-13 18:05:13','513','2021-06-13 18:05:42',10,0),('1','136',203741,'DAILY SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-14 18:37:26','513','2021-06-14 18:38:58',10,0),('1','136',203968,'DAILY SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-15 17:37:46','513','2021-06-15 17:38:24',10,0),('1','136',204195,'DAILY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-16 18:01:25','513','2021-06-16 18:02:08',10,0),('1','136',204403,'DAILY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-17 10:02:50','513','2021-06-17 10:03:11',10,0),('1','136',204481,'DAILY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-17 17:50:24','513','2021-06-17 17:55:21',10,0),('1','136',204624,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-18 18:10:41','513','2021-06-18 18:11:07',10,0),('1','136',204840,'DAILY SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-19 18:27:20','513','2021-06-19 18:28:01',10,0),('1','136',205041,'DAILY SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-20 17:43:49','513','2021-06-20 17:47:27',10,0),('1','136',205238,'DAILY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-21 12:50:12','513','2021-06-21 12:50:42',10,0),('1','136',205345,'DAILY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-21 13:31:01','513','2021-06-21 13:31:26',10,0),('1','136',205361,'DAILY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-21 18:26:57','513','2021-06-21 18:27:21',10,0),('1','136',205469,'DAILY SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-22 18:43:55','513','2021-06-22 18:44:16',10,0),('1','136',205749,'DAILY SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-23 18:51:32','513','2021-06-23 18:52:01',10,0),('1','136',205941,'DAILY SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-24 17:48:39','513','2021-06-24 17:49:03',10,0),('1','136',206148,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-25 18:10:04','513','2021-06-25 18:32:51',10,0),('1','136',206358,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-26 17:37:16','513','2021-06-26 17:38:32',10,0),('1','136',206525,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-26 18:21:54','513','2021-06-26 18:22:16',10,0),('1','136',206574,'DAILY SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-27 18:33:38','513','2021-06-27 18:34:22',10,0),('1','136',206811,'DAILY SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-28 18:10:43','513','2021-06-28 18:22:59',10,0),('1','136',207047,'DAILY SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-29 18:25:22','513','2021-06-29 18:26:14',10,0),('1','136',207247,'DAILY SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'513',0.00,0.00,'513','2021-06-30 18:20:51','513','2021-06-30 18:21:18',10,0),('1','136',207479,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-01 14:55:21','513','2021-07-01 14:55:40',10,0),('1','136',207655,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-01 17:32:06','513','2021-07-01 17:32:21',10,0),('1','136',207659,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-01 18:15:33','513','2021-07-01 18:16:07',10,0),('1','136',207707,'DAILY SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-02 20:24:04','513','2021-07-02 20:24:35',10,0),('1','136',207908,'DAILY SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-03 21:18:03','513','2021-07-03 21:18:30',10,0),('1','136',208108,'DAILY SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-04 18:50:18','513','2021-07-04 18:50:42',10,0),('1','136',208316,'DAILY SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-05 18:22:29','513','2021-07-05 18:22:58',10,0),('1','136',208643,'DAILY SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-06 11:18:48','513','2021-07-06 11:19:21',10,0),('1','136',208733,'DAILY SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-06 19:04:12','513','2021-07-06 19:04:32',10,0),('1','136',208961,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-07 18:50:30','513','2021-07-07 18:50:55',10,0),('1','136',208991,'DAILY SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-08 18:23:08','513','2021-07-08 18:23:30',10,0),('1','136',209223,'DAILY SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-09 17:57:11','513','2021-07-09 17:57:37',10,0),('1','136',209438,'DAILY SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-10 17:41:24','513','2021-07-10 17:42:14',10,0),('1','136',209645,'DAILY SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-11 13:19:52','513','2021-07-11 13:20:14',10,0),('1','136',209763,'DAILY SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-11 17:57:11','513','2021-07-11 17:57:39',10,0),('1','136',209858,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-12 11:27:07','513','2021-07-12 11:27:42',10,0),('1','136',209976,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-12 18:12:19','513','2021-07-12 18:12:52',10,0),('1','136',210099,'DAILY SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-13 18:08:56','513','2021-07-13 18:09:31',10,0),('1','136',210305,'DAILY SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-14 16:28:34','513','2021-07-14 16:28:58',10,0),('1','136',210511,'DAILY SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-15 17:42:45','513','2021-07-15 17:43:26',10,0),('1','136',210729,'DAILY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-16 18:06:48','513','2021-07-16 18:07:19',10,0),('1','136',210982,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-17 17:38:06','513','2021-07-17 17:38:32',10,0),('1','136',211137,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-17 18:20:29','513','2021-07-17 18:21:51',10,0),('1','136',211167,'DAILY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-18 18:18:49','513','2021-07-18 18:19:16',10,0),('1','136',211369,'DAILY SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-19 18:56:30','513','2021-07-19 18:57:48',10,0),('1','136',211651,'DAILY SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-20 19:29:07','513','2021-07-20 19:29:34',10,0),('1','136',211842,'DAILY SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-21 09:51:42','513','2021-07-21 09:52:06',10,0),('1','136',211848,'DAILY SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-21 18:25:30','513','2021-07-21 18:25:58',10,0),('1','136',211985,'DAILY SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-22 18:01:50','513','2021-07-22 18:02:45',10,0),('1','136',212196,'DAILY SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-22 18:36:54','513','2021-07-22 18:38:00',10,0),('1','136',212230,'DAILY SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-23 17:35:59','513','2021-07-23 17:38:06',10,0),('1','136',212453,'DAILY SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-24 18:06:07','513','2021-07-24 18:06:53',10,0),('1','136',212663,'DAILY SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-25 16:46:46','513','2021-07-25 16:47:36',10,0),('1','136',212940,'DAILY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-26 18:12:02','513','2021-07-26 18:12:45',10,0),('1','136',213131,'DAILY SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-27 22:47:43','513','2021-07-27 22:48:24',10,0),('1','136',213369,'Shift','2021-07-27','2021-07-27 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-27 22:53:18','513','2021-07-27 22:53:53',10,0),('1','136',213370,'Shift','2021-07-27','2021-07-27 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-27 23:00:40','513','2021-07-27 23:00:57',10,0),('1','136',213389,'DAILY SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-28 20:58:56','513','2021-07-28 21:00:15',10,0),('1','136',213627,'DAILY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-29 19:35:12','513','2021-07-29 19:36:15',10,0),('1','136',213892,'DAILY SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-31 06:27:43','513','2021-07-31 06:33:43',10,0),('1','136',214097,'DAILY SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'513',0.00,0.00,'513','2021-07-31 19:02:29','513','2021-07-31 19:03:03',10,0),('1','136',214326,'DAILY SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-01 18:41:16','513','2021-08-01 18:43:23',10,0),('1','136',214528,'DAILY SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-02 19:16:33','513','2021-08-02 19:18:24',10,0),('1','136',214857,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-03 18:17:11','513','2021-08-03 18:18:11',10,0),('1','136',214999,'DAILY SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-04 18:17:59','513','2021-08-04 18:20:21',10,0),('1','136',215230,'DAILY SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-05 18:16:07','513','2021-08-05 18:16:34',10,0),('1','136',215440,'DAILY SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-06 19:21:30','513','2021-08-06 19:23:00',10,0),('1','136',215675,'DAILY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-07 19:07:38','513','2021-08-07 19:08:16',10,0),('1','136',215903,'DAILY SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-08 10:41:41','513','2021-08-08 10:42:03',10,0),('1','136',215981,'DAILY SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-08 19:15:49','513','2021-08-08 19:17:21',10,0),('1','136',216097,'DAILY SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-09 18:16:12','513','2021-08-10 06:18:01',10,0),('1','136',216323,'DAILY SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-10 20:51:44','513','2021-08-10 20:52:36',10,0),('1','136',216557,'DAILY SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-11 18:34:39','513','2021-08-11 18:35:26',10,0),('1','136',216784,'DAILY SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-12 19:08:21','513','2021-08-12 19:09:44',10,0),('1','136',217025,'DAILY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-13 17:14:24','513','2021-08-13 17:16:13',10,0),('1','136',217234,'DAILY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-13 17:19:06','513','2021-08-13 17:19:23',10,0),('1','136',217241,'DAILY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-13 18:18:44','513','2021-08-13 18:19:03',10,0),('1','136',217268,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-14 18:13:01','513','2021-08-14 18:14:56',10,0),('1','136',217502,'DAILY SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-15 10:56:01','513','2021-08-15 10:56:30',10,0),('1','136',217569,'DAILY SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-15 17:44:46','513','2021-08-15 17:46:30',10,0),('1','136',217709,'DAILY SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-16 17:45:48','513','2021-08-16 17:46:39',10,0),('1','136',217976,'DAILY SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-17 11:37:37','513','2021-08-17 11:38:56',10,0),('1','136',218095,'DAILY SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-17 18:28:36','513','2021-08-17 18:29:01',10,0),('1','136',218216,'DAILY SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-18 18:18:13','513','2021-08-18 18:24:30',10,0),('1','136',218448,'DAILY SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-19 18:00:46','513','2021-08-19 18:01:22',10,0),('1','136',218681,'DAILY SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-20 18:22:14','513','2021-08-20 18:22:48',10,0),('1','136',218899,'DAILY SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-21 18:00:52','513','2021-08-21 18:01:38',10,0),('1','136',219133,'DAILY SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-22 11:33:46','513','2021-08-22 11:34:36',10,0),('1','136',219212,'DAILY SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-22 19:36:44','513','2021-08-22 19:37:39',10,0),('1','136',219343,'DAILY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-23 17:59:44','513','2021-08-23 18:03:00',10,0),('1','136',219601,'DAILY SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-24 18:27:01','513','2021-08-24 18:27:59',10,0),('1','136',219808,'DAILY SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-25 18:03:36','513','2021-08-25 18:06:50',10,0),('1','136',220039,'DAILY SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-26 18:24:29','513','2021-08-26 18:27:12',10,0),('1','136',220245,'DAILY SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-27 18:45:00','513','2021-08-27 18:49:21',10,0),('1','136',220465,'DAILY SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-28 19:14:37','513','2021-08-28 19:16:03',10,0),('1','136',220709,'DAILY SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-29 18:18:39','513','2021-08-29 18:20:03',10,0),('1','136',220904,'DAILY SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-30 18:23:48','513','2021-08-30 18:26:02',10,0),('1','136',221140,'DAILY SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'513',0.00,0.00,'513','2021-08-31 17:54:43','513','2021-08-31 17:58:50',10,0),('1','136',221380,'DAILY SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-01 18:08:53','513','2021-09-01 18:10:12',10,0),('1','136',221613,'DAILY SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-02 18:22:30','513','2021-09-02 18:29:37',10,0),('1','136',221830,'DAILY SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-03 10:15:41','513','2021-09-03 10:16:13',10,0),('1','136',221910,'DAILY SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-03 17:52:46','513','2021-09-03 17:53:46',10,0),('1','136',222056,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-04 12:05:35','513','2021-09-04 12:06:46',10,0),('1','136',222192,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-04 17:48:21','513','2021-09-04 17:49:00',10,0),('1','136',222263,'DAILY SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-05 12:37:28','513','2021-09-05 12:47:58',10,0),('1','136',222395,'DAILY SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-05 18:33:38','513','2021-09-05 18:35:08',10,0),('1','136',222485,'DAILY SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-07 06:00:56','513','2021-09-07 06:03:41',10,0),('1','136',222725,'DAILY SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-08 09:46:17','513','2021-09-08 09:46:41',10,0),('1','136',223007,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-08 17:45:51','513','2021-09-08 17:48:12',10,0),('1','136',223143,'Shift','2021-09-08','2021-09-08 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-09 06:08:23','513','2021-09-09 06:08:55',10,0),('1','136',223174,'DAILY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-09 17:40:58','513','2021-09-09 17:43:16',10,0),('1','136',223414,'DAILY SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-10 18:51:12','513','2021-09-10 18:52:10',10,0),('1','136',223738,'DAILY SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-11 13:52:16','513','2021-09-11 13:53:34',10,0),('1','136',223804,'DAILY SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-11 17:55:40','513','2021-09-11 17:56:05',10,0),('1','136',223946,'DAILY SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-12 18:30:45','513','2021-09-12 18:31:55',10,0),('1','136',224086,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-13 17:11:15','513','2021-09-13 17:11:44',10,0),('1','136',224276,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-13 19:34:28','513','2021-09-13 19:34:53',10,0),('1','136',224307,'DAILY SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-14 18:29:38','513','2021-09-14 18:31:19',10,0),('1','136',224527,'DAILY SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-15 18:34:39','513','2021-09-15 18:35:50',10,0),('1','136',224774,'DAILY SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-16 18:05:24','513','2021-09-16 18:36:51',10,0),('1','136',225011,'DAILY SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-17 18:43:57','513','2021-09-17 18:45:43',10,0),('1','136',225264,'DAILY SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-18 17:56:51','513','2021-09-18 18:04:22',10,0),('1','136',225478,'DAILY SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-19 17:21:03','513','2021-09-19 17:23:00',10,0),('1','136',225654,'DAILY SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-19 18:03:34','513','2021-09-19 18:03:52',10,0),('1','136',225701,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-20 11:54:52','513','2021-09-20 11:57:46',10,0),('1','136',225845,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-20 17:48:58','513','2021-09-20 17:50:08',10,0),('1','136',225977,'DAILY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-21 16:44:00','513','2021-09-21 16:46:22',10,0),('1','136',226185,'DAILY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-21 18:54:43','513','2021-09-21 18:55:08',10,0),('1','136',226355,'DAILY SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-22 12:41:41','513','2021-09-22 12:42:30',10,0),('1','136',226366,'DAILY SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-22 18:10:07','513','2021-09-22 18:11:27',10,0),('1','136',226477,'DAILY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-23 19:02:42','513','2021-09-23 19:07:36',10,0),('1','136',226729,'DAILY SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-24 18:05:19','513','2021-09-24 18:13:10',10,0),('1','136',226963,'DAILY SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-25 19:38:33','513','2021-09-25 19:40:40',10,0),('1','136',227213,'DAILY SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-26 20:09:03','513','2021-09-26 20:11:01',10,0),('1','136',227367,'DAILY SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-27 18:52:30','513','2021-09-27 18:54:43',10,0),('1','136',227616,'DAILY SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-28 21:04:42','513','2021-09-28 21:25:22',10,0),('1','136',227851,'DAILY SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-29 11:55:15','513','2021-09-29 12:03:11',10,0),('1','136',227976,'DAILY SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-29 17:45:27','513','2021-09-29 17:45:43',10,0),('1','136',228108,'DAILY SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'513',0.00,0.00,'513','2021-09-30 14:02:54','513','2021-09-30 14:03:23',10,0),('1','136',228324,'Shift','2021-09-30','2021-09-30 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-01 06:58:58','513','2021-10-01 06:59:22',10,0),('1','136',228362,'Shift','2021-10-01','2021-10-01 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-01 17:02:39','513','2021-10-01 17:03:16',10,0),('1','136',228500,'DAILY SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-01 19:54:44','513','2021-10-01 19:55:05',10,0),('1','136',228532,'DAILY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-02 18:29:44','513','2021-10-02 18:31:06',10,0),('1','136',228754,'DAILY SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-03 08:16:36','513','2021-10-03 08:16:57',10,0),('1','136',228788,'DAILY SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-03 18:18:44','513','2021-10-03 18:19:44',10,0),('1','136',228934,'DAILY SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-04 11:28:17','513','2021-10-04 11:28:47',10,0),('1','136',229032,'DAILY SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-04 18:13:31','513','2021-10-04 18:14:30',10,0),('1','136',229171,'DAILY SHIFT9','2021-10-05','2021-10-05 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-05 17:39:41','513','2021-10-05 17:41:03',10,0),('1','136',229414,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-06 18:12:26','513','2021-10-06 18:17:33',10,0),('1','136',229663,'DAILY SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-07 17:54:23','513','2021-10-07 17:55:16',10,0),('1','136',229878,'DAILY SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-08 16:45:19','513','2021-10-08 16:46:47',10,0),('1','136',230039,'DAILY SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-08 18:09:01','513','2021-10-08 18:09:31',10,0),('1','136',230086,'DAILY SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-09 15:24:54','513','2021-10-09 15:29:06',10,0),('1','136',230233,'DAILY SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-09 17:43:39','513','2021-10-09 17:44:13',10,0),('1','136',230281,'DAILY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-10 16:32:12','513','2021-10-10 16:34:51',10,0),('1','136',230595,'DAILY SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-11 17:59:10','513','2021-10-11 18:01:53',10,0),('1','136',230783,'DAILY SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-12 18:07:18','513','2021-10-12 18:10:20',10,0),('1','136',231059,'DAILY SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-13 12:46:54','513','2021-10-13 12:47:18',10,0),('1','136',231191,'DAILY SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-13 17:45:40','513','2021-10-13 17:46:33',10,0),('1','136',231375,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-14 17:49:50','513','2021-10-14 17:51:19',10,0),('1','136',231638,'DAILY SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-15 17:37:03','513','2021-10-15 17:37:58',10,0),('1','136',232024,'DAILY SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-16 15:22:03','513','2021-10-16 15:22:44',10,0),('1','136',232033,'DAILY SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-16 17:54:05','513','2021-10-16 17:56:34',10,0),('1','136',232100,'DAILY SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-17 13:59:42','513','2021-10-17 14:26:01',10,0),('1','136',232252,'DAILY SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-17 17:54:52','513','2021-10-17 17:56:23',10,0),('1','136',232325,'DAILY SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-18 18:08:05','513','2021-10-18 18:11:14',10,0),('1','136',232588,'DAILY SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-19 18:05:11','513','2021-10-19 18:21:18',10,0),('1','136',232853,'DAILY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-20 18:02:54','513','2021-10-20 18:06:13',10,0),('1','136',233120,'DAILY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-21 18:00:39','513','2021-10-21 18:02:18',10,0),('1','136',233361,'DAILY SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-22 17:55:11','513','2021-10-22 17:55:46',10,0),('1','136',233597,'DAILY SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-23 17:42:10','513','2021-10-23 17:46:24',10,0),('1','136',233840,'DAILY SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-24 18:16:14','513','2021-10-24 18:19:44',10,0),('1','136',234043,'DAILY SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-25 18:27:11','513','2021-10-25 18:33:50',10,0),('1','136',234309,'DAILY SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-26 11:02:48','513','2021-10-26 11:07:21',10,0),('1','136',234422,'DAILY SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-26 17:58:03','513','2021-10-26 17:59:07',10,0),('1','136',234551,'DAILY SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-27 17:47:41','513','2021-10-27 17:50:57',10,0),('1','136',234809,'DAILY SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-28 18:20:46','513','2021-10-28 18:25:15',10,0),('1','136',235059,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-29 18:19:51','513','2021-10-29 18:24:48',10,0),('1','136',235289,'DAILY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-30 19:36:37','513','2021-10-30 19:39:33',10,0),('1','136',235513,'DAILY SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'513',0.00,0.00,'513','2021-10-31 18:04:18','513','2021-10-31 18:12:30',10,0),('1','136',235751,'DAILY SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-01 21:04:27','513','2021-11-01 21:12:42',10,0),('1','136',236003,'DAILY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-02 18:25:12','513','2021-11-03 05:45:14',10,0),('1','136',236237,'DAILY SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-03 18:38:09','513','2021-11-03 18:38:56',10,0),('1','136',236514,'DAILY SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-04 18:29:11','513','2021-11-04 18:32:11',10,0),('1','136',236731,'DAILY SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-05 19:06:17','513','2021-11-05 19:06:43',10,0),('1','136',236944,'DAILY SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-06 18:09:39','513','2021-11-06 18:10:01',10,0),('1','136',237164,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-07 18:50:10','513','2021-11-07 18:51:38',10,0),('1','136',237370,'DAILY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-08 18:49:07','513','2021-11-08 18:49:23',10,0),('1','136',237649,'DAILY SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-09 18:29:23','513','2021-11-09 18:29:48',10,0),('1','136',237896,'DAILY SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-10 18:24:24','513','2021-11-10 18:25:23',10,0),('1','136',238113,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-11 12:56:42','513','2021-11-11 12:57:09',10,0),('1','136',238259,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-11 17:38:03','513','2021-11-11 17:38:46',10,0),('1','136',238352,'DAILY SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-12 10:35:20','513','2021-11-12 10:35:44',10,0),('1','136',238563,'Shift','2021-11-12','2021-11-12 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-12 19:59:14','513','2021-11-12 19:59:38',10,0),('1','136',238734,'Shift','2021-11-13','2021-11-13 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-13 13:16:32','513','2021-11-13 13:16:58',10,0),('1','136',238736,'Shift','2021-11-13','2021-11-13 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-13 13:20:37','513','2021-11-13 13:20:53',10,0),('1','136',238780,'Shift','2021-11-13','2021-11-13 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-13 19:09:22','513','2021-11-13 19:09:38',10,0),('1','136',239003,'Shift','2021-11-14','2021-11-14 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-14 19:06:51','513','2021-11-14 19:07:07',10,0),('1','136',239005,'Shift','2021-11-14','2021-11-14 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-14 19:22:54','513','2021-11-14 19:23:10',10,0),('1','136',239273,'Shift','2021-11-15','2021-11-15 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-15 22:16:12','513','2021-11-15 22:16:27',10,0),('1','136',239274,'Shift','2021-11-15','2021-11-15 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-15 22:34:22','513','2021-11-15 22:34:36',10,0),('1','136',239482,'Shift','2021-11-16','2021-11-16 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-16 20:24:40','513','2021-11-16 20:25:00',10,0),('1','136',239488,'Shift','2021-11-16','2021-11-16 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-16 20:34:25','513','2021-11-16 20:34:43',10,0),('1','136',239602,'DAILY SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-17 18:12:57','513','2021-11-17 18:17:24',10,0),('1','136',239882,'DAILY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-18 12:29:34','513','2021-11-18 12:29:57',10,0),('1','136',239890,'DAILY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-18 18:23:06','513','2021-11-18 18:23:29',10,0),('1','136',240071,'DAILY SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-19 18:15:59','513','2021-11-19 18:16:28',10,0),('1','136',240207,'DAILY SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-20 17:16:54','513','2021-11-20 17:18:17',10,0),('1','136',240503,'DAILY SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-22 05:16:11','513','2021-11-22 05:17:09',10,0),('1','136',240678,'DAILY SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-22 17:25:23','513','2021-11-22 17:25:43',10,0),('1','136',240967,'DAILY SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-23 07:09:05','513','2021-11-23 07:09:31',10,0),('1','136',241010,'DAILY SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-23 17:46:55','513','2021-11-23 17:47:35',10,0),('1','136',241214,'DAILY SHIFT9','2021-11-24','2021-11-24 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-24 18:13:04','513','2021-11-24 18:13:38',10,0),('1','136',241478,'DAILY SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-25 18:22:02','513','2021-11-25 18:22:36',10,0),('1','136',241722,'DAILY SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-26 18:24:39','513','2021-11-26 18:25:28',10,0),('1','136',241972,'DAILY SHIFT9','2021-11-27','2021-11-27 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-27 18:43:56','513','2021-11-27 18:44:28',10,0),('1','136',242193,'DAILY SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-28 17:39:17','513','2021-11-28 17:39:45',10,0),('1','136',242430,'DAILY SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-29 18:00:15','513','2021-11-29 18:00:56',10,0),('1','136',242673,'DAILY SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'513',0.00,0.00,'513','2021-11-30 18:13:13','513','2021-11-30 18:13:40',10,0),('1','136',242912,'DAILY SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-01 10:51:46','513','2021-12-01 10:52:18',10,0),('1','136',243015,'DAILY SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-01 18:28:16','513','2021-12-01 18:29:07',10,0),('1','136',243144,'DAILY SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-02 18:21:33','513','2021-12-02 18:22:12',10,0),('1','136',243350,'DAILY SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-03 18:35:58','513','2021-12-03 18:36:47',10,0),('1','136',243586,'DAILY SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-04 18:21:26','513','2021-12-04 18:24:22',10,0),('1','136',243829,'DAILY SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-05 17:49:53','513','2021-12-05 17:51:01',10,0),('1','136',244045,'DAILY SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-06 17:47:26','513','2021-12-06 17:48:12',10,0),('1','136',244272,'DAILY SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-07 17:44:45','513','2021-12-07 17:45:55',10,0),('1','136',244508,'DAILY SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-08 06:59:15','513','2021-12-08 06:59:44',10,0),('1','136',244553,'DAILY SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-08 17:51:28','513','2021-12-08 17:51:51',10,0),('1','136',244734,'DAILY SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-09 17:11:56','513','2021-12-09 17:13:13',10,0),('1','136',244964,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-10 18:12:44','513','2021-12-10 18:13:14',10,0),('1','136',245202,'DAILY SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-11 18:07:25','513','2021-12-11 18:08:48',10,0),('1','136',245432,'DAILY SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-12 18:01:39','513','2021-12-12 18:02:42',10,0),('1','136',245730,'DAILY SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-13 18:25:23','513','2021-12-13 18:25:51',10,0),('1','136',245931,'DAILY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-14 18:15:59','513','2021-12-14 18:16:47',10,0),('1','136',246188,'DAILY SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-15 16:14:05','513','2021-12-15 16:14:45',10,0),('1','136',246391,'DAILY SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-15 17:55:38','513','2021-12-15 17:56:03',10,0),('1','136',246454,'DAILY SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-16 18:32:40','513','2021-12-16 18:33:07',10,0),('1','136',246689,'DAILY SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-17 18:04:57','513','2021-12-17 18:05:53',10,0),('1','136',246928,'DAILY SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-18 18:14:05','513','2021-12-18 18:14:34',10,0),('1','136',247173,'DAILY SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-19 18:09:20','513','2021-12-19 18:10:35',10,0),('1','136',247399,'DAILY SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-20 18:02:13','513','2021-12-20 18:02:39',10,0),('1','136',247654,'DAILY SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-21 11:29:02','513','2021-12-21 11:29:21',10,0),('1','136',247764,'DAILY SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-21 18:59:04','513','2021-12-21 18:59:31',10,0),('1','136',247900,'DAILY SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-22 17:56:46','513','2021-12-22 17:59:44',10,0),('1','136',248137,'DAILY SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-23 18:05:17','513','2021-12-23 18:08:59',10,0),('1','136',248400,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-24 18:42:02','513','2021-12-24 18:42:34',10,0),('1','136',248641,'DAILY SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-25 18:00:04','513','2021-12-25 18:00:32',10,0),('1','136',248860,'DAILY SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-26 18:10:14','513','2021-12-26 18:10:47',10,0),('1','136',249104,'DAILY SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-27 16:46:23','513','2021-12-27 16:46:46',10,0),('1','136',249273,'DAILY SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-27 18:25:05','513','2021-12-27 18:26:12',10,0),('1','136',249340,'DAILY SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-28 18:42:50','513','2021-12-28 18:43:59',10,0),('1','136',249597,'DAILY SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-29 17:58:03','513','2021-12-29 17:58:47',10,0),('1','136',249850,'DAILY SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-30 18:08:19','513','2021-12-30 18:09:48',10,0),('1','136',250091,'DAILY SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'513',0.00,0.00,'513','2021-12-31 18:30:34','513','2021-12-31 18:31:43',10,0),('1','136',250333,'New shift','2022-01-01','2022-01-01 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-01 17:14:42','513','2022-01-01 17:15:12',10,0),('1','136',250498,'DAILY SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-01 18:52:45','513','2022-01-01 18:53:06',10,0),('1','136',250569,'DAILY SHIFT4','2022-01-02','2022-01-02 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-02 17:56:59','513','2022-01-02 17:58:28',10,0),('1','136',250782,'New shift','2022-01-03','2022-01-03 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-03 11:43:46','513','2022-01-03 11:44:19',10,0),('1','136',250890,'DAILY SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-03 18:41:44','513','2022-01-03 18:42:19',10,0),('1','136',251009,'New shift','2022-01-04','2022-01-04 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-04 18:23:28','513','2022-01-04 18:25:22',10,0),('1','136',251271,'DAILY SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-05 18:59:00','513','2022-01-05 18:59:29',10,0),('1','136',251518,'DAILY SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-06 19:09:25','513','2022-01-06 19:09:44',10,0),('1','136',251761,'DAILY SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-07 19:49:19','513','2022-01-07 19:50:20',10,0),('1','136',251995,'DAILY SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-08 19:39:02','513','2022-01-08 19:39:25',10,0),('1','136',252242,'DAILY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-09 09:07:56','513','2022-01-09 09:08:20',10,0),('1','136',252281,'DAILY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-09 19:02:24','513','2022-01-09 19:03:39',10,0),('1','136',252477,'DAILY SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-10 19:25:11','513','2022-01-10 19:25:36',10,0),('1','136',252707,'DAILY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-11 19:13:21','513','2022-01-11 19:14:56',10,0),('1','136',252964,'DAILY SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-12 19:33:30','513','2022-01-12 19:34:35',10,0),('1','136',253205,'DAILY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-13 19:11:18','513','2022-01-13 19:12:11',10,0),('1','136',253478,'DAILY SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-14 09:00:24','513','2022-01-14 09:00:48',10,0),('1','136',253531,'DAILY SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-14 19:15:50','513','2022-01-14 19:17:46',10,0),('1','136',253718,'DAILY SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-15 19:54:21','513','2022-01-15 19:55:01',10,0),('1','136',253944,'DAILY SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-16 19:29:43','513','2022-01-16 19:31:18',10,0),('1','136',254199,'DAILY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-17 19:36:42','513','2022-01-17 19:37:13',10,0),('1','136',254452,'DAILY SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-18 16:04:22','513','2022-01-18 16:14:53',10,0),('1','136',254642,'DAILY SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-18 19:24:24','513','2022-01-18 19:24:57',10,0),('1','136',254688,'New shift of','2022-01-19','2022-01-19 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-19 19:39:40','513','2022-01-19 19:40:16',10,0),('1','136',254946,'New shift50','2022-01-20','2022-01-20 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-20 18:48:31','513','2022-01-20 18:48:56',10,0),('1','136',255187,'New shift','2022-01-21','2022-01-21 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-21 08:32:18','513','2022-01-21 08:32:51',10,0),('1','136',255232,'DAILY SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-21 19:42:31','513','2022-01-21 19:43:22',10,0),('1','136',255471,'DAILY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-22 09:54:02','513','2022-01-22 09:58:27',10,0),('1','136',255534,'NEW SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-22 20:23:24','513','2022-01-22 20:28:49',10,0),('1','136',255701,'DAILY SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-23 16:34:47','513','2022-01-23 16:35:15',10,0),('1','136',255867,'DAILY SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-23 18:59:18','513','2022-01-23 19:00:31',10,0),('1','136',255946,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-24 11:52:06','513','2022-01-24 11:52:54',10,0),('1','136',256077,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-24 19:09:29','513','2022-01-24 19:14:11',10,0),('1','136',256203,'DAILY SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-25 19:22:00','513','2022-01-25 19:35:21',10,0),('1','136',256473,'DAILY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-26 19:18:35','513','2022-01-26 19:24:51',10,0),('1','136',256711,'DAILY SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-27 19:22:17','513','2022-01-27 19:23:08',10,0),('1','136',256965,'DAILY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-28 19:14:26','513','2022-01-28 19:15:40',10,0),('1','136',257238,'DAILY SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-29 19:10:11','513','2022-01-29 19:12:09',10,0),('1','136',257488,'DAILY SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-30 19:11:32','513','2022-01-30 19:12:05',10,0),('1','136',257489,'NEW SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-31 07:34:57','513','2022-01-31 07:35:14',10,0),('1','136',257490,'DAILY SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'513',0.00,0.00,'513','2022-01-31 19:27:39','513','2022-01-31 19:27:59',10,0),('1','136',257491,'DAILY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-01 19:24:25','513','2022-02-01 19:24:40',10,0),('1','136',257492,'New shift','2022-02-02','2022-02-02 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-02 19:27:51','513','2022-02-02 19:28:10',10,0),('1','136',257493,'DAILY SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-03 19:22:17','513','2022-02-03 19:23:13',10,0),('1','136',257494,'New shift it','2022-02-04','2022-02-04 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-04 19:30:51','513','2022-02-04 19:31:07',10,0),('1','136',257495,'DAILY SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-05 13:24:24','513','2022-02-05 13:24:42',10,0),('1','136',257496,'NEW SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-05 19:56:04','513','2022-02-05 19:57:07',10,0),('1','136',257497,'DAILY SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-06 12:41:40','513','2022-02-06 12:42:43',10,0),('1','136',257498,'NEW SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-06 19:35:10','513','2022-02-06 19:35:30',10,0),('1','136',257499,'DAILY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-07 15:35:14','513','2022-02-07 15:36:41',10,0),('1','136',257500,'NEW SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-07 19:44:50','513','2022-02-07 19:45:13',10,0),('1','136',257501,'New shift','2022-02-08','2022-02-08 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-08 19:22:53','513','2022-02-08 19:23:21',10,0),('1','136',257502,'DAILY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-09 19:18:01','513','2022-02-09 19:18:20',10,0),('1','136',257503,'DAILY SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-10 19:41:08','513','2022-02-10 19:41:28',10,0),('1','136',257504,'DAILY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-11 20:15:59','513','2022-02-11 20:28:12',10,0),('1','136',257505,'DAILY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-13 06:15:23','513','2022-02-13 06:15:59',10,0),('1','136',257506,'New shift it','2022-02-13','2022-02-13 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-13 18:42:05','513','2022-02-13 18:42:38',10,0),('1','136',257507,'DAILY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-13 20:26:58','513','2022-02-13 20:27:26',10,0),('1','136',257508,'DAILY SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-14 19:56:28','513','2022-02-14 19:57:28',10,0),('1','136',257509,'DAILY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-15 21:45:39','513','2022-02-15 21:45:59',10,0),('1','136',257510,'DAILY SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-16 19:36:21','513','2022-02-16 19:36:47',10,0),('1','136',257511,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-17 14:41:19','513','2022-02-17 15:10:20',10,0),('1','136',257512,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-18 06:29:58','513','2022-02-18 06:30:27',10,0),('1','136',257513,'DAILY SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-18 16:22:39','513','2022-02-18 16:22:59',10,0),('1','136',257514,'NEW SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-18 20:06:23','513','2022-02-18 20:06:45',10,0),('1','136',257515,'DAILY SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-19 18:42:27','513','2022-02-19 18:42:55',10,0),('1','136',257516,'DAILY SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-19 19:45:46','513','2022-02-19 19:46:29',10,0),('1','136',257517,'DAILY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-20 18:03:27','513','2022-02-20 18:09:40',10,0),('1','136',257518,'DAILY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-20 20:42:22','513','2022-02-20 20:42:50',10,0),('1','136',257519,'DAILY SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-21 18:42:13','513','2022-02-21 18:42:43',10,0),('1','136',257520,'NEW SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'513',0.00,0.00,'513','2022-02-22 06:47:11','513','2022-02-22 06:47:31',10,0),('1','136',257521,'DAILY SHIFT','2022-02-22','2022-02-22 06:47:49','2022-02-23 06:47:49','513',0.00,0.00,'513','2022-02-22 19:03:46','513','2022-02-22 19:04:03',10,0),('1','136',257522,'DAILY SHIFT','2022-02-23','2022-02-23 06:58:44','2022-02-24 06:58:44','513',0.00,0.00,'513','2022-02-23 19:56:25','513','2022-02-23 19:56:43',10,0),('1','136',257523,'DAILY SHIFT','2022-02-24','2022-02-24 06:37:05','2022-02-25 06:37:05','513',0.00,0.00,'513','2022-02-24 20:06:22','513','2022-02-24 20:08:58',10,0),('1','136',257524,'DAILY SHIFT','2022-02-25','2022-02-25 06:35:08','2022-02-26 06:35:08','513',0.00,0.00,'513','2022-02-25 19:07:11','513','2022-02-25 19:07:28',10,0),('1','136',257525,'DAILY SHIFT','2022-02-26','2022-02-26 06:39:20','2022-02-27 06:39:20','513',0.00,0.00,'513','2022-02-26 18:20:06','513','2022-02-26 18:21:15',10,0),('1','136',257526,'DAILY SHIFT','2022-02-26','2022-02-26 18:40:39','2022-02-27 18:40:39','513',0.00,0.00,'513','2022-02-26 19:52:38','513','2022-02-26 19:52:53',10,0),('1','136',257527,'DAILY SHIFT','2022-02-27','2022-02-27 06:11:36','2022-02-28 06:11:36','513',0.00,0.00,'513','2022-02-27 20:19:36','513','2022-02-27 20:19:55',10,0),('1','136',257528,'DAILY SHIFT','2022-02-28','2022-02-28 06:00:26','2022-03-01 06:00:26','513',0.00,0.00,'513','2022-02-28 19:29:00','513','2022-02-28 19:29:21',10,0),('1','136',257529,'NEW SHIFT','2022-03-01','2022-03-01 05:55:55','2022-03-02 05:55:55','513',0.00,0.00,'513','2022-03-01 20:03:15','513','2022-03-01 20:03:36',10,0),('1','136',257530,'DAILY SHIFT','2022-03-02','2022-03-02 06:56:06','2022-03-03 06:56:06','513',0.00,0.00,'513','2022-03-02 19:48:36','513','2022-03-02 19:48:55',10,0),('1','136',257531,'DAILY SHIFT','2022-03-03','2022-03-03 06:40:53','2022-03-04 06:40:53','513',0.00,0.00,'513','2022-03-03 18:37:21','513','2022-03-03 18:37:57',10,0),('1','136',257532,'NEW SHIFT','2022-03-03','2022-03-03 19:22:21','2022-03-04 19:22:21','513',0.00,0.00,'513','2022-03-03 19:36:49','513','2022-03-03 19:37:08',10,0),('1','136',257533,'DAILY SHIFT','2022-03-04','2022-03-04 06:37:33','2022-03-05 06:37:33','513',0.00,0.00,'513','2022-03-04 19:48:19','513','2022-03-04 19:48:38',10,0),('1','136',257534,'DAILY SHIFT','2022-03-05','2022-03-05 06:54:58','2022-03-06 06:54:58','513',0.00,0.00,'513','2022-03-05 19:58:22','513','2022-03-05 19:59:01',10,0),('1','136',257535,'DAILY SHIFT','2022-03-06','2022-03-06 06:18:18','2022-03-07 06:18:18','513',0.00,0.00,'513','2022-03-06 20:19:23','513','2022-03-06 20:20:09',10,0),('1','136',257536,'DAILY SHIFT','2022-03-07','2022-03-07 06:10:08','2022-03-08 06:10:08','513',0.00,0.00,'513','2022-03-07 20:08:33','513','2022-03-07 20:09:05',10,0),('1','136',257537,'DAILY SHIFT','2022-03-08','2022-03-08 06:22:36','2022-03-09 06:22:36','513',0.00,0.00,'513','2022-03-08 14:28:38','513','2022-03-08 14:29:20',10,0),('1','136',257538,'NEW SHIFT','2022-03-08','2022-03-08 14:45:44','2022-03-09 14:45:44','513',0.00,0.00,'513','2022-03-08 19:50:51','513','2022-03-08 19:51:27',10,0),('1','136',257539,'DAILY SHIFT','2022-03-09','2022-03-09 07:04:02','2022-03-10 07:04:02','513',0.00,0.00,'513','2022-03-09 09:20:33','513','2022-03-09 09:20:59',10,0),('1','136',257540,'DAILY SHIFT','2022-03-09','2022-03-09 09:32:36','2022-03-10 09:32:36','513',0.00,0.00,'513','2022-03-09 20:16:11','513','2022-03-09 20:16:32',10,0),('1','136',257541,'DAILY SHIFT','2022-03-10','2022-03-10 06:14:40','2022-03-11 06:14:40','513',0.00,0.00,'513','2022-03-10 19:06:56','513','2022-03-10 19:07:12',10,0),('1','136',257542,'DAILY SHIFT','2022-03-11','2022-03-11 06:19:13','2022-03-12 06:19:13','513',0.00,0.00,'513','2022-03-11 19:37:08','513','2022-03-11 19:37:24',10,0),('1','136',257543,'NEW SHIFT','2022-03-11','2022-03-11 19:46:12','2022-03-12 19:46:12','513',0.00,0.00,'513','2022-03-11 19:47:14','513','2022-03-11 19:47:32',10,0),('1','136',257544,'DAILY SHIFT','2022-03-12','2022-03-12 07:28:25','2022-03-13 07:28:25','513',0.00,0.00,'513','2022-03-12 19:16:31','513','2022-03-12 19:16:59',10,0),('1','136',257545,'DAILY SHIFT','2022-03-13','2022-03-13 06:09:43','2022-03-14 06:09:43','513',0.00,0.00,'513','2022-03-13 20:01:28','513','2022-03-13 20:01:58',10,0),('1','136',257546,'DAILY SHIFT','2022-03-14','2022-03-14 07:12:46','2022-03-15 07:12:46','513',0.00,0.00,'513','2022-03-14 20:05:10','513','2022-03-14 20:05:51',10,0),('1','136',257547,'DAILY SHIFT','2022-03-15','2022-03-15 08:22:03','2022-03-16 08:22:03','513',0.00,0.00,'513','2022-03-15 08:57:45','513','2022-03-15 08:58:03',10,0),('1','136',257548,'NEW SHIFT','2022-03-15','2022-03-15 09:03:45','2022-03-16 09:03:45','513',0.00,0.00,'513','2022-03-15 19:52:46','513','2022-03-15 19:53:03',10,0),('1','136',257549,'DAILY SHIFT','2022-03-16','2022-03-16 07:09:59','2022-03-17 07:09:59','513',0.00,0.00,'513','2022-03-16 19:42:57','513','2022-03-16 19:43:18',10,0),('1','136',257550,'DAILY SHIFT','2022-03-09','2022-03-16 19:53:31','2022-03-17 19:53:31','513',0.00,0.00,'513','2022-03-16 19:56:54','513','2022-03-16 19:57:22',10,0),('1','136',257551,'DAILY SHIFT','2022-03-17','2022-03-17 06:07:42','2022-03-18 06:07:42','513',0.00,0.00,'513','2022-03-17 19:20:30','513','2022-03-17 19:20:51',10,0),('1','136',257552,'DAILY SHIFT','2022-03-18','2022-03-18 06:57:45','2022-03-19 06:57:45','513',0.00,0.00,'513','2022-03-18 19:49:41','513','2022-03-18 19:49:58',10,0),('1','136',257553,'DAILY SHIFT','2022-03-19','2022-03-19 07:11:11','2022-03-20 07:11:11','513',0.00,0.00,'513','2022-03-19 19:21:24','513','2022-03-19 19:21:42',10,0),('1','136',257554,'DAILY SHIFT','2022-03-20','2022-03-20 06:58:01','2022-03-21 06:58:01','513',0.00,0.00,'513','2022-03-20 18:30:12','513','2022-03-20 18:31:40',10,0),('1','136',257555,'DAILY SHIFT','2022-03-21','2022-03-21 06:39:25','2022-03-22 06:39:25','513',0.00,0.00,'513','2022-03-21 19:15:19','513','2022-03-21 19:15:52',10,0),('1','136',257556,'DAILY SHIFT','2022-03-22','2022-03-22 07:02:08','2022-03-23 07:02:08','513',0.00,0.00,'513','2022-03-22 19:55:09','513','2022-03-22 19:55:26',10,0),('1','136',257557,'DAILY SHIFT','2022-03-23','2022-03-23 06:32:00','2022-03-24 06:32:00','513',0.00,0.00,'513','2022-03-23 19:05:50','513','2022-03-23 19:06:23',10,0),('1','136',257558,'DAILY SHIFT','2022-03-24','2022-03-24 06:45:04','2022-03-25 06:45:04','513',0.00,0.00,'513','2022-03-24 07:58:42','513','2022-03-24 07:59:00',10,0),('1','136',257559,'DAILY SHIFT','2022-03-24','2022-03-24 08:00:48','2022-03-25 08:00:48','513',0.00,0.00,'513','2022-03-24 19:27:23','513','2022-03-24 19:27:39',10,0),('1','136',257560,'DAILY SHIFT','2022-03-25','2022-03-25 07:07:31','2022-03-26 07:07:31','513',0.00,0.00,'513','2022-03-25 19:27:04','513','2022-03-25 19:27:33',10,0),('1','136',257561,'DAILY SHIFT','2022-03-26','2022-03-26 06:53:53','2022-03-27 06:53:53','513',0.00,0.00,'513','2022-03-26 20:22:40','513','2022-03-26 20:22:59',10,0),('1','136',257562,'DAILY SHIFT','2022-03-27','2022-03-27 07:07:43','2022-03-28 07:07:43','513',0.00,0.00,'513','2022-03-27 19:28:05','513','2022-03-27 19:28:31',10,0),('1','136',257563,'DAILY SHIFT','2022-03-28','2022-03-28 06:56:16','2022-03-29 06:56:16','513',0.00,0.00,'513','2022-03-28 19:19:06','513','2022-03-28 19:22:01',10,0),('1','136',257564,'DAILY SHIFT','2022-03-29','2022-03-29 07:06:37','2022-03-30 07:06:37','513',0.00,0.00,'513','2022-03-29 20:50:15','513','2022-03-29 20:51:06',10,0),('1','136',257565,'DAILY SHIFT','2022-03-30','2022-03-30 06:00:54','2022-03-31 06:00:54','513',0.00,0.00,'513','2022-03-30 19:26:41','513','2022-03-30 19:27:07',10,0),('1','136',257566,'DAILY SHIFT','2022-03-31','2022-03-31 06:58:24','2022-04-01 06:58:24','513',0.00,0.00,'513','2022-03-31 19:05:29','513','2022-03-31 19:05:50',10,0),('1','136',257567,'NEW SHIFT','2022-03-31','2022-03-31 19:25:06','2022-04-01 19:25:06','513',0.00,0.00,'513','2022-03-31 20:19:41','513','2022-03-31 20:20:16',10,0),('1','136',257568,'DAILY SHIFT','2022-04-01','2022-04-01 06:13:04','2022-04-02 06:13:04','513',0.00,0.00,'513','2022-04-01 20:25:00','513','2022-04-01 20:25:21',10,0),('1','136',257569,'DAILY SHIFT','2022-04-02','2022-04-02 06:06:42','2022-04-03 06:06:42','513',0.00,0.00,'513','2022-04-02 19:05:54','513','2022-04-02 19:06:12',10,0),('1','136',257570,'DAILY SHIFT','2022-04-03','2022-04-03 06:08:49','2022-04-04 06:08:49','513',0.00,0.00,'513','2022-04-03 19:38:22','513','2022-04-03 19:39:04',10,0),('1','136',257571,'DAILY SHIFT','2022-04-04','2022-04-04 06:09:01','2022-04-05 06:09:01','513',0.00,0.00,'513','2022-04-04 19:39:03','513','2022-04-04 19:39:27',10,0),('1','136',257572,'DAILY SHIFT','2022-04-05','2022-04-05 06:05:15','2022-04-06 06:05:15','513',0.00,0.00,'513','2022-04-05 19:11:13','513','2022-04-05 19:11:45',10,0),('1','136',257573,'DAILY SHIFT','2022-04-06','2022-04-06 08:42:13','2022-04-07 08:42:13','513',0.00,0.00,'513','2022-04-06 08:54:06','513','2022-04-06 08:54:25',10,0),('1','136',257574,'NEW SHIFT','2022-04-06','2022-04-06 09:56:01','2022-04-07 09:56:01','513',0.00,0.00,'513','2022-04-06 14:54:58','513','2022-04-06 14:55:16',10,0),('1','136',257575,'NEW SHIFT','2022-04-06','2022-04-06 15:16:33','2022-04-07 15:16:33','513',0.00,0.00,'513','2022-04-06 19:41:10','513','2022-04-06 19:41:31',10,0),('1','136',257576,'DAILY SHIFT','2022-04-07','2022-04-07 06:00:31','2022-04-08 06:00:31','513',0.00,0.00,'513','2022-04-07 11:41:57','513','2022-04-07 11:42:18',10,0),('1','136',257577,'NEW SHIFT','2022-04-07','2022-04-07 11:53:48','2022-04-08 11:53:48','513',0.00,0.00,'513','2022-04-07 20:54:21','513','2022-04-07 20:54:52',10,0),('1','136',257578,'DAILY SHIFT','2022-04-08','2022-04-08 06:12:55','2022-04-09 06:12:55','513',0.00,0.00,'513','2022-04-08 20:45:08','513','2022-04-08 20:46:00',10,0),('1','136',257579,'NEW SHIFT','2022-04-08','2022-04-08 20:59:57','2022-04-09 20:59:57','513',0.00,0.00,'513','2022-04-08 21:08:30','513','2022-04-08 21:08:54',10,0),('1','136',257580,'DAILY SHIFT','2022-04-09','2022-04-09 06:04:23','2022-04-10 06:04:23','513',0.00,0.00,'513','2022-04-09 19:28:53','513','2022-04-09 19:29:32',10,0),('1','136',257581,'DAILY SHIFT','2022-04-10','2022-04-10 06:03:55','2022-04-11 06:03:55','513',0.00,0.00,'513','2022-04-10 19:36:36','513','2022-04-10 19:37:06',10,0),('1','136',257582,'DAILY SHIFT','2022-04-11','2022-04-11 06:11:25','2022-04-12 06:11:25','513',0.00,0.00,'513','2022-04-11 17:11:44','513','2022-04-11 17:12:09',10,0),('1','136',257583,'DAILY SHIFT','2022-04-12','2022-04-12 08:01:03','2022-04-13 08:01:03','513',0.00,0.00,'513','2022-04-12 19:47:36','513','2022-04-12 19:48:06',10,0),('1','136',257584,'DAILY SHIFT','2022-04-13','2022-04-13 05:57:00','2022-04-14 05:57:00','513',0.00,0.00,'513','2022-04-13 19:21:04','513','2022-04-13 19:21:31',10,0),('1','136',257585,'DAILY SHIFT','2022-04-14','2022-04-14 06:00:47','2022-04-15 06:00:47','513',0.00,0.00,'513','2022-04-14 19:16:37','513','2022-04-14 19:17:12',10,0),('1','136',257586,'DAILY SHIFT','2022-04-15','2022-04-15 06:47:39','2022-04-16 06:47:39','513',0.00,0.00,'513','2022-04-15 19:28:49','513','2022-04-15 19:29:23',10,0),('1','136',257587,'NEW SHIFT','2022-04-15','2022-04-15 19:45:28','2022-04-16 19:45:28','513',0.00,0.00,'513','2022-04-15 20:02:08','513','2022-04-15 20:02:38',10,0),('1','136',257588,'NEW SHIFT','2022-04-15','2022-04-15 20:03:25','2022-04-16 20:03:25','513',0.00,0.00,'513','2022-04-15 20:04:56','513','2022-04-15 20:05:28',10,0),('1','136',257589,'DAILY SHIFT','2022-04-16','2022-04-16 06:07:29','2022-04-17 06:07:29','513',0.00,0.00,'513','2022-04-16 16:49:49','513','2022-04-16 16:50:13',10,0),('1','136',257590,'NEW SHIFT','2022-04-16','2022-04-16 17:04:35','2022-04-17 17:04:35','513',0.00,0.00,'513','2022-04-16 19:24:01','513','2022-04-16 19:26:17',10,0),('1','136',257591,'DAILY SHIFT','2022-04-17','2022-04-17 05:55:21','2022-04-18 05:55:21','513',0.00,0.00,'513','2022-04-17 19:03:18','513','2022-04-17 19:04:04',10,0),('1','136',257592,'DAILY SHIFT','2022-04-18','2022-04-18 05:48:41','2022-04-19 05:48:41','513',0.00,0.00,'513','2022-04-18 10:59:51','513','2022-04-18 11:00:09',10,0),('1','136',257593,'NEW SHIFT','2022-04-18','2022-04-18 11:10:53','2022-04-19 11:10:53','513',0.00,0.00,'513','2022-04-18 20:05:38','513','2022-04-18 20:06:01',10,0),('1','136',257594,'DAILY SHIFT','2022-04-19','2022-04-19 05:44:28','2022-04-20 05:44:28','513',0.00,0.00,'513','2022-04-19 14:06:24','513','2022-04-19 14:06:40',10,0),('1','136',257595,'NEW SHIFT','2022-04-19','2022-04-19 14:30:52','2022-04-20 14:30:52','513',0.00,0.00,'513','2022-04-19 14:33:52','513','2022-04-19 14:35:26',10,0),('1','136',257596,'NEW SHIFT','2022-04-19','2022-04-19 14:42:25','2022-04-20 14:42:25','513',0.00,0.00,'513','2022-04-19 19:12:55','513','2022-04-19 19:13:50',10,0),('1','136',257597,'DAILY SHIFT','2022-04-20','2022-04-20 05:50:39','2022-04-21 05:50:39','513',0.00,0.00,'513','2022-04-20 19:47:47','513','2022-04-20 19:48:20',10,0),('1','136',257598,'DAILY SHIFT','2022-04-21','2022-04-21 05:48:58','2022-04-22 05:48:58','513',0.00,0.00,'513','2022-04-21 19:17:10','513','2022-04-21 19:17:31',10,0),('1','136',257599,'DAILY SHIFT','2022-04-22','2022-04-22 06:46:56','2022-04-23 06:46:56','513',0.00,0.00,'513','2022-04-22 20:22:43','513','2022-04-22 20:23:07',10,0),('1','136',257600,'DAILY SHIFT','2022-04-23','2022-04-23 05:38:26','2022-04-24 05:38:26','513',0.00,0.00,'513','2022-04-23 19:45:57','513','2022-04-23 19:46:17',10,0),('1','136',257601,'DAILY SHIFT','2022-04-24','2022-04-24 06:56:02','2022-04-25 06:56:02','513',0.00,0.00,'513','2022-04-24 18:53:20','513','2022-04-24 18:53:49',10,0),('1','136',257602,'DAILY SHIFT','2022-04-25','2022-04-25 05:47:52','2022-04-26 05:47:52','513',0.00,0.00,'513','2022-04-25 17:37:48','513','2022-04-25 17:38:04',10,0),('1','136',257603,'NEW SHIFT','2022-04-25','2022-04-25 17:38:50','2022-04-26 17:38:50','513',0.00,0.00,'513','2022-04-25 17:56:07','513','2022-04-25 17:56:27',10,0),('1','136',257604,'NEW SHIFT','2022-04-25','2022-04-25 18:14:07','2022-04-26 18:14:07','513',0.00,0.00,'513','2022-04-25 20:21:40','513','2022-04-25 20:21:58',10,0),('1','136',257605,'DAILY SHIFT','2022-04-26','2022-04-26 06:31:48','2022-04-27 06:31:48','513',0.00,0.00,'513','2022-04-26 19:09:23','513','2022-04-26 19:45:06',10,0),('1','136',257606,'DAILY SHIFT','2022-04-27','2022-04-27 05:52:43','2022-04-28 05:52:43','513',0.00,0.00,'513','2022-04-27 18:56:15','513','2022-04-27 18:56:33',10,0),('1','136',257607,'DAILY SHIFT','2022-04-28','2022-04-28 05:45:27','2022-04-29 05:45:27','513',0.00,0.00,'513','2022-04-28 19:44:20','513','2022-04-28 19:45:27',10,0),('1','136',257608,'DAILY SHIFT','2022-04-29','2022-04-29 05:50:48','2022-04-30 05:50:48','513',0.00,0.00,'513','2022-04-29 20:22:34','513','2022-04-29 20:22:55',10,0),('1','136',257609,'DAILY SHIFT','2022-04-30','2022-04-30 06:47:11','2022-05-01 06:47:11','513',0.00,0.00,'513','2022-04-30 20:03:40','513','2022-04-30 20:04:28',10,0),('1','136',257610,'DAILY SHIFT','2022-05-01','2022-05-01 06:13:16','2022-05-02 06:13:16','513',0.00,0.00,'513','2022-05-01 14:30:50','513','2022-05-01 14:31:12',10,0),('1','136',257611,'OVERAGE ','2022-05-01','2022-05-01 14:57:44','2022-05-02 14:57:44','513',0.00,0.00,'513','2022-05-01 14:59:47','513','2022-05-01 15:00:05',10,0),('1','136',257612,'NEW SHIFT','2022-05-01','2022-05-01 15:15:32','2022-05-02 15:15:32','513',0.00,0.00,'513','2022-05-01 22:59:06','513','2022-05-01 22:59:26',10,0),('1','136',257613,'DAILY SHIFT','2022-05-02','2022-05-02 11:32:23','2022-05-03 11:32:23','513',0.00,0.00,'513','2022-05-03 00:00:36','513','2022-05-03 00:01:10',10,0),('1','136',257614,'DAILY SHIFT','2022-05-03','2022-05-03 07:47:08','2022-05-04 07:47:08','513',0.00,0.00,'513','2022-05-03 18:19:14','513','2022-05-03 18:19:30',10,0),('1','136',257615,'DAILY SHIFT','2022-05-04','2022-05-04 09:40:02','2022-05-05 09:40:02','513',0.00,0.00,'513','2022-05-04 18:52:25','513','2022-05-04 18:53:12',10,0),('1','136',257616,'DAILY SHIFT','2022-05-05','2022-05-05 07:20:00','2022-05-06 07:20:00','513',0.00,0.00,'513','2022-05-05 23:32:39','513','2022-05-05 23:32:55',10,0),('1','136',257617,'Daily Shift ','2022-05-06','2022-05-06 06:46:56','2022-05-07 06:46:56','513',0.00,0.00,'513','2022-05-06 15:50:43','513','2022-05-06 15:51:03',10,0),('1','136',257618,'NEW SHIFT ','2022-05-06','2022-05-06 15:52:02','2022-05-07 15:52:02','513',0.00,0.00,'513','2022-05-06 19:26:43','513','2022-05-06 19:27:07',10,0),('1','136',257619,'Daily Shift ','2022-05-07','2022-05-07 06:16:02','2022-05-08 06:16:02','513',0.00,0.00,'513','2022-05-07 15:23:45','513','2022-05-07 15:24:07',10,0),('1','136',257620,'NEW SHIFT ','2022-05-07','2022-05-07 15:27:20','2022-05-08 15:27:20','513',0.00,0.00,'513','2022-05-07 19:27:43','513','2022-05-07 19:28:04',10,0),('1','136',257621,'Daily Shift ','2022-05-08','2022-05-08 06:37:06','2022-05-09 06:37:06','513',0.00,0.00,'513','2022-05-08 13:31:53','513','2022-05-08 13:32:09',10,0),('1','136',257622,'DAILY SHIFT','2022-05-08','2022-05-08 13:32:31','2022-05-09 13:32:31','513',0.00,0.00,'513','2022-05-08 18:44:46','513','2022-05-08 18:45:03',10,0),('1','136',257623,'DAILY SHIFT','2022-05-09','2022-05-09 07:02:16','2022-05-10 07:02:16','513',0.00,0.00,'513','2022-05-09 19:13:42','513','2022-05-09 19:14:01',10,0),('1','136',257624,'DAILY SHIFT','2022-05-10','2022-05-10 06:41:43','2022-05-11 06:41:43','513',0.00,0.00,'513','2022-05-10 16:05:51','513','2022-05-10 16:06:09',10,0),('1','136',257625,'DAILY SHIFT','2022-05-11','2022-05-11 16:17:03','2022-05-12 16:17:03','513',0.00,0.00,'513','2022-05-11 16:22:11','513','2022-05-11 16:22:51',10,0),('1','136',257626,'DAILY SHIFT','2022-05-11','2022-05-11 16:24:12','2022-05-12 16:24:12','513',0.00,0.00,'513','2022-05-12 07:13:28','513','2022-05-12 07:13:45',10,0),('1','136',257627,'DAILY SHIFT','2022-05-12','2022-05-12 07:14:02','2022-05-13 07:14:02','513',0.00,0.00,'513','2022-05-12 18:25:08','513','2022-05-12 18:25:36',10,0),('1','136',257628,'DAILY SHIFT','2022-05-13','2022-05-13 06:12:47','2022-05-14 06:12:47','513',0.00,0.00,'513','2022-05-13 08:29:51','513','2022-05-13 08:30:08',10,0),('1','136',257629,'NEW SHIFT ','2022-05-13','2022-05-13 08:30:34','2022-05-14 08:30:34','513',0.00,0.00,'513','2022-05-13 08:36:15','513','2022-05-13 08:36:45',10,0),('1','136',257630,'NEW SHIFT ','2022-05-13','2022-05-13 08:46:55','2022-05-14 08:46:55','513',0.00,0.00,'513','2022-05-13 19:49:23','513','2022-05-13 19:49:45',10,0),('1','136',257631,'DAILY SHIFT','2022-05-14','2022-05-14 06:40:22','2022-05-15 06:40:22','513',0.00,0.00,'513','2022-05-14 19:20:09','513','2022-05-14 19:20:27',10,0),('1','136',257632,'DAILY SHIFT','2022-05-15','2022-05-15 07:21:44','2022-05-16 07:21:44','513',0.00,0.00,'513','2022-05-15 18:18:52','513','2022-05-15 18:19:09',10,0),('1','136',257633,'DAILY SHIFT','2022-05-16','2022-05-16 06:10:42','2022-05-17 06:10:42','513',0.00,0.00,'513','2022-05-16 14:44:13','513','2022-05-16 14:44:29',10,0),('1','136',257634,'NEW SHIFT ','2022-05-16','2022-05-16 15:01:51','2022-05-17 15:01:51','513',0.00,0.00,'513','2022-05-16 15:04:24','513','2022-05-16 15:04:44',10,0),('1','136',257635,'DAILY SHIFT','2022-05-16','2022-05-16 16:02:38','2022-05-17 16:02:38','513',0.00,0.00,'513','2022-05-16 19:00:07','513','2022-05-16 19:00:25',10,0),('1','136',257636,'DAILY SHIFT','2022-05-17','2022-05-17 06:44:17','2022-05-18 06:44:17','513',0.00,0.00,'513','2022-05-17 17:19:58','513','2022-05-17 17:20:13',10,0),('1','136',257637,'DAILY SHIFT','2022-05-18','2022-05-18 06:41:31','2022-05-19 06:41:31','513',0.00,0.00,'513','2022-05-18 11:31:41','513','2022-05-18 11:32:22',10,0),('1','136',257638,'NEW SHIFT ','2022-05-18','2022-05-18 11:33:21','2022-05-19 11:33:21','513',0.00,0.00,'513','2022-05-18 11:49:33','513','2022-05-18 11:49:48',10,0),('1','136',257639,'DAILY SHIFT','2022-05-18','2022-05-18 11:50:16','2022-05-19 11:50:16','513',0.00,0.00,'513','2022-05-18 22:47:43','513','2022-05-18 22:48:00',10,0),('1','136',257640,'DAILY SHIFT','2022-05-19','2022-05-19 06:45:37','2022-05-20 06:45:37','513',0.00,0.00,'513','2022-05-19 19:24:45','513','2022-05-19 19:25:07',10,0),('1','136',257641,'DAILY SHIFT','2022-05-20','2022-05-20 06:39:35','2022-05-21 06:39:35','513',0.00,0.00,'513','2022-05-20 17:03:46','513','2022-05-20 17:04:09',10,0),('1','136',257642,'NEW SHIFT ','2022-05-20','2022-05-20 17:04:39','2022-05-21 17:04:39','513',0.00,0.00,'513','2022-05-20 17:08:30','513','2022-05-20 17:08:48',10,0),('1','136',257643,'DAILY SHIFT','2022-05-20','2022-05-20 17:09:12','2022-05-21 17:09:12','513',0.00,0.00,'513','2022-05-20 19:28:17','513','2022-05-20 19:28:34',10,0),('1','136',257644,'DAILY SHIFT','2022-05-21','2022-05-21 06:48:26','2022-05-22 06:48:26','513',0.00,0.00,'513','2022-05-21 19:25:06','513','2022-05-21 19:25:25',10,0),('1','136',257645,'DAILY SHIFT','2022-05-22','2022-05-22 06:37:34','2022-05-23 06:37:34','513',0.00,0.00,'513','2022-05-22 09:27:56','513','2022-05-22 09:28:13',10,0),('1','136',257646,'NEW SHIFT ','2022-05-22','2022-05-22 09:28:54','2022-05-23 09:28:54','513',0.00,0.00,'513','2022-05-22 09:34:14','513','2022-05-22 09:34:31',10,0),('1','136',257647,'DAILY SHIFT','2022-05-22','2022-05-22 09:40:31','2022-05-23 09:40:31','513',0.00,0.00,'513','2022-05-22 19:14:35','513','2022-05-22 19:23:11',10,0),('1','136',257648,'DAILY SHIFT','2022-05-23','2022-05-23 06:52:30','2022-05-24 06:52:30','513',0.00,0.00,'513','2022-05-23 19:19:44','513','2022-05-23 19:20:03',10,0),('1','136',257649,'DAILY SHIFT','2022-05-24','2022-05-24 06:35:35','2022-05-25 06:35:35','513',0.00,0.00,'513','2022-05-24 19:14:56','513','2022-05-24 19:15:14',10,0),('1','136',257650,'DAILY SHIFT','2022-05-25','2022-05-25 06:54:30','2022-05-26 06:54:30','513',0.00,0.00,'513','2022-05-25 10:36:34','513','2022-05-25 10:36:52',10,0),('1','136',257651,'NEW SHIFT ','2022-05-25','2022-05-25 10:38:26','2022-05-26 10:38:26','513',0.00,0.00,'513','2022-05-25 10:54:47','513','2022-05-25 10:55:04',10,0),('1','136',257652,'DAILY SHIFT','2022-05-25','2022-05-25 11:32:04','2022-05-26 11:32:04','513',0.00,0.00,'513','2022-05-25 19:24:18','513','2022-05-25 19:24:56',10,0),('1','136',257653,'DAILY SHIFT','2022-05-26','2022-05-26 06:53:02','2022-05-27 06:53:02','513',0.00,0.00,'513','2022-05-26 20:23:12','513','2022-05-26 20:23:42',10,0),('1','136',257654,'DAILY SHIFT','2022-05-27','2022-05-27 06:45:16','2022-05-28 06:45:16','513',0.00,0.00,'513','2022-05-27 19:43:26','513','2022-05-27 19:43:57',10,0),('1','136',257655,'DAILY SHIFT','2022-05-28','2022-05-28 06:55:54','2022-05-29 06:55:54','513',0.00,0.00,'513','2022-05-28 19:16:37','513','2022-05-28 19:16:57',10,0),('1','136',257656,'DAILY SHIFT','2022-05-29','2022-05-29 06:59:20','2022-05-30 06:59:20','513',0.00,0.00,'513','2022-05-29 19:41:38','513','2022-05-29 19:42:00',10,0),('1','136',257657,'DAILY SHIFT','2022-05-30','2022-05-30 06:59:58','2022-05-31 06:59:58','513',0.00,0.00,'513','2022-05-30 19:38:48','513','2022-05-30 19:39:06',10,0),('1','136',257658,'DAILY SHIFT','2022-05-31','2022-05-31 06:40:24','2022-06-01 06:40:24','513',0.00,0.00,'513','2022-05-31 16:42:09','513','2022-05-31 16:42:31',10,0),('1','136',257659,'NEW SHIFT ','2022-05-31','2022-05-31 16:43:34','2022-06-01 16:43:34','513',0.00,0.00,'513','2022-05-31 16:50:49','513','2022-05-31 16:51:09',10,0),('1','136',257660,'DAILY SHIFT','2022-05-31','2022-05-31 16:51:30','2022-06-01 16:51:30','513',0.00,0.00,'513','2022-05-31 19:30:32','513','2022-05-31 19:30:56',10,0),('1','136',257661,'DAILY SHIFT','2022-06-01','2022-06-01 06:17:34','2022-06-02 06:17:34','513',0.00,0.00,'513','2022-06-01 11:40:59','513','2022-06-01 11:41:52',10,0),('1','136',257662,'NEW SHIFT ','2022-06-01','2022-06-01 11:44:23','2022-06-02 11:44:23','513',0.00,0.00,'513','2022-06-01 11:50:06','513','2022-06-01 11:50:43',10,0),('1','136',257663,'NEW SHIFT ','2022-06-01','2022-06-01 11:55:44','2022-06-02 11:55:44','513',0.00,0.00,'513','2022-06-01 19:38:42','513','2022-06-01 19:38:58',10,0),('1','136',257664,'DAILY SHIFT','2022-06-02','2022-06-02 06:42:59','2022-06-03 06:42:59','513',0.00,0.00,'513','2022-06-02 11:43:10','513','2022-06-02 11:43:27',10,0),('1','136',257665,'OPERATIONAL LOSS','2022-06-02','2022-06-02 11:43:59','2022-06-03 11:43:59','513',0.00,0.00,'513','2022-06-02 11:54:32','513','2022-06-02 11:54:48',10,0),('1','136',257666,'DAILY SHIFT','2022-06-02','2022-06-02 11:55:15','2022-06-03 11:55:15','513',0.00,0.00,'513','2022-06-02 20:53:24','513','2022-06-02 22:13:39',10,0),('1','136',257667,'OPERATIONAL LOSS','2022-06-02','2022-06-02 22:45:49','2022-06-03 22:45:49','513',0.00,0.00,'513','2022-06-02 22:51:06','513','2022-06-02 22:51:26',10,0),('1','136',257668,'DAILY SHIFT','2022-06-03','2022-06-03 08:07:55','2022-06-04 08:07:55','513',0.00,0.00,'513','2022-06-03 19:39:04','513','2022-06-03 19:39:21',10,0),('1','136',257669,'DAILY SHIFT','2022-06-04','2022-06-04 07:13:03','2022-06-05 07:13:03','513',0.00,0.00,'513','2022-06-04 12:31:21','513','2022-06-04 12:32:41',10,0),('1','136',257670,'OPERATIONAL LOSS','2022-06-04','2022-06-04 12:38:23','2022-06-05 12:38:23','513',0.00,0.00,'513','2022-06-04 12:47:34','513','2022-06-04 12:47:51',10,0),('1','136',257671,'DAILY SHIFT','2022-06-04','2022-06-04 12:48:40','2022-06-05 12:48:40','513',0.00,0.00,'513','2022-06-04 19:47:24','513','2022-06-04 19:47:41',10,0),('1','136',257672,'DAILY SHIFT','2022-06-05','2022-06-05 07:06:16','2022-06-06 07:06:16','513',0.00,0.00,'513','2022-06-06 07:24:44','513','2022-06-06 07:25:32',10,0),('1','136',257673,'DAILY SHIFT','2022-06-06','2022-06-06 07:26:18','2022-06-07 07:26:18','513',0.00,0.00,'513','2022-06-06 20:13:20','513','2022-06-06 20:14:19',10,0),('1','136',257674,'DAILY SHIFT','2022-06-07','2022-06-07 07:09:33','2022-06-08 07:09:33','513',0.00,0.00,'513','2022-06-07 19:49:57','513','2022-06-07 19:50:18',10,0),('1','136',257675,'DAILY SHIFT','2022-06-08','2022-06-08 06:57:54','2022-06-09 06:57:54','513',0.00,0.00,'513','2022-06-08 19:25:56','513','2022-06-08 19:26:14',10,0),('1','136',257676,'DAILY SHIFT','2022-06-09','2022-06-09 06:57:06','2022-06-10 06:57:06','513',0.00,0.00,'513','2022-06-09 19:40:54','513','2022-06-09 19:41:13',10,0),('1','136',257677,'DAILY SHIFT','2022-06-10','2022-06-10 06:56:24','2022-06-11 06:56:24','513',0.00,0.00,'513','2022-06-10 19:37:54','513','2022-06-10 19:38:15',10,0),('1','136',257678,'OPERATIONAL LOSS','2022-06-10','2022-06-10 19:38:49','2022-06-11 19:38:49','513',0.00,0.00,'513','2022-06-10 19:47:45','513','2022-06-10 19:48:03',10,0),('1','136',257679,'DAILY SHIFT','2022-06-11','2022-06-11 06:59:24','2022-06-12 06:59:24','513',0.00,0.00,'513','2022-06-11 19:39:19','513','2022-06-11 19:39:39',10,0),('1','136',257680,'DAILY SHIFT','2022-06-12','2022-06-12 07:03:57','2022-06-13 07:03:57','513',0.00,0.00,'513','2022-06-12 19:44:39','513','2022-06-12 19:45:02',10,0),('1','136',257681,'OPERATIONAL LOSS','2022-06-12','2022-06-12 19:45:39','2022-06-13 19:45:39','513',0.00,0.00,'513','2022-06-12 19:57:04','513','2022-06-12 19:57:24',10,0),('1','136',257682,'DAILY SHIFT','2022-06-13','2022-06-13 07:53:14','2022-06-14 07:53:14','513',0.00,0.00,'513','2022-06-13 20:04:25','513','2022-06-13 20:04:44',10,0),('1','136',257683,'DAILY SHIFT','2022-06-14','2022-06-14 07:18:52','2022-06-15 07:18:52','513',0.00,0.00,'513','2022-06-14 16:02:07','513','2022-06-14 16:02:25',10,0),('1','136',257684,'OPERATIONAL LOSS','2022-06-14','2022-06-14 16:03:14','2022-06-15 16:03:14','513',0.00,0.00,'513','2022-06-14 16:08:59','513','2022-06-14 16:09:17',10,0),('1','136',257685,'DAILY SHIFT','2022-06-14','2022-06-14 16:09:38','2022-06-15 16:09:38','513',0.00,0.00,'513','2022-06-14 19:05:46','513','2022-06-14 19:19:39',10,0),('1','136',257686,'DAILY SHIFT','2022-06-15','2022-06-15 06:58:03','2022-06-16 06:58:03','513',0.00,0.00,'513','2022-06-15 19:32:12','513','2022-06-15 19:32:28',10,0),('1','136',257687,'DAILY SHIFT','2022-06-16','2022-06-16 07:01:46','2022-06-17 07:01:46','513',0.00,0.00,'513','2022-06-16 15:37:51','513','2022-06-16 15:38:13',10,0),('1','136',257688,'OPERATIONAL LOSS','2022-06-16','2022-06-16 15:38:53','2022-06-17 15:38:53','513',0.00,0.00,'513','2022-06-16 15:44:46','513','2022-06-16 15:45:01',10,0),('1','136',257689,'DAILY SHIFT','2022-06-16','2022-06-16 15:45:21','2022-06-17 15:45:21','513',0.00,0.00,'513','2022-06-16 19:44:50','513','2022-06-16 19:45:08',10,0),('1','136',257690,'DAILY SHIFT','2022-06-17','2022-06-17 07:29:52','2022-06-18 07:29:52','513',0.00,0.00,'513','2022-06-17 19:21:13','513','2022-06-17 19:21:33',10,0),('1','136',257691,'DAILY SHIFT','2022-06-18','2022-06-18 07:17:55','2022-06-19 07:17:55','513',0.00,0.00,'513','2022-06-18 15:57:46','513','2022-06-18 15:58:03',10,0),('1','136',257692,'OPERATIONAL LOSS','2022-06-18','2022-06-18 15:58:49','2022-06-19 15:58:49','513',0.00,0.00,'513','2022-06-18 16:04:07','513','2022-06-18 16:04:26',10,0),('1','136',257693,'DAILY SHIFT','2022-06-18','2022-06-18 16:04:48','2022-06-19 16:04:48','513',0.00,0.00,'513','2022-06-18 19:41:19','513','2022-06-18 19:41:35',10,0),('1','136',257694,'DAILY SHIFT','2022-06-19','2022-06-19 07:48:51','2022-06-20 07:48:51','513',0.00,0.00,'513','2022-06-19 19:23:36','513','2022-06-19 19:23:58',10,0),('1','136',257695,'DAILY SHIFT','2022-06-20','2022-06-20 07:19:01','2022-06-21 07:19:01','513',0.00,0.00,'513','2022-06-20 18:40:16','513','2022-06-20 18:40:34',10,0),('1','136',257696,'DAILY SHIFT','2022-06-21','2022-06-21 07:08:36','2022-06-22 07:08:36','513',0.00,0.00,'513','2022-06-21 13:24:35','513','2022-06-21 13:24:53',10,0),('1','136',257697,'OPERATIONAL LOSS','2022-06-21','2022-06-21 13:25:22','2022-06-22 13:25:22','513',0.00,0.00,'513','2022-06-21 13:29:52','513','2022-06-21 13:30:07',10,0),('1','136',257698,'DAILY SHIFT','2022-06-21','2022-06-21 13:30:29','2022-06-22 13:30:29','513',0.00,0.00,'513','2022-06-21 19:35:46','513','2022-06-21 19:36:07',10,0),('1','136',257699,'DAILY SHIFT','2022-06-22','2022-06-22 07:23:26','2022-06-23 07:23:26','513',0.00,0.00,'513','2022-06-22 19:30:48','513','2022-06-22 19:31:27',10,0),('1','136',257700,'DAILY SHIFT','2022-06-23','2022-06-23 07:17:43','2022-06-24 07:17:43','513',0.00,0.00,'513','2022-06-23 19:31:00','513','2022-06-23 19:31:22',10,0),('1','136',257701,'DAILY SHIFT','2022-06-24','2022-06-24 08:19:38','2022-06-25 08:19:38','513',0.00,0.00,'513','2022-06-24 12:39:21','513','2022-06-24 12:39:42',10,0),('1','136',257702,'OPERATIONAL LOSS','2022-06-24','2022-06-24 12:40:20','2022-06-25 12:40:20','513',0.00,0.00,'513','2022-06-24 12:45:17','513','2022-06-24 12:45:35',10,0),('1','136',257703,'DAILY SHIFT ','2022-06-24','2022-06-24 12:46:28','2022-06-25 12:46:28','513',0.00,0.00,'513','2022-06-24 19:32:39','513','2022-06-24 19:33:09',10,0),('1','136',257704,'DAILY SHIFT','2022-06-25','2022-06-25 07:16:09','2022-06-26 07:16:09','513',0.00,0.00,'513','2022-06-25 20:11:01','513','2022-06-25 20:11:18',10,0),('1','136',257705,'DAILY SHIFT','2022-06-26','2022-06-26 08:08:49','2022-06-27 08:08:49','513',0.00,0.00,'513','2022-06-26 19:51:40','513','2022-06-26 19:52:06',10,0),('1','136',257706,'DAILY SHIFT','2022-06-27','2022-06-27 07:14:05','2022-06-28 07:14:05','513',0.00,0.00,'513','2022-06-27 19:44:14','513','2022-06-27 19:44:34',10,0),('1','136',257707,'DAILY SHIFT','2022-06-28','2022-06-28 07:48:56','2022-06-29 07:48:56','513',0.00,0.00,'513','2022-06-28 20:18:27','513','2022-06-28 20:18:49',10,0),('1','136',257708,'DAILY SHIFT','2022-06-29','2022-06-29 07:34:05','2022-06-30 07:34:05','513',0.00,0.00,'513','2022-06-29 19:24:33','513','2022-06-29 19:24:52',10,0),('1','136',257709,'DAILY SHIFT','2022-06-30','2022-06-30 06:54:49','2022-07-01 06:54:49','513',0.00,0.00,'513','2022-06-30 19:39:42','513','2022-06-30 19:40:00',10,0),('1','136',257710,'DAILY SHIFT','2022-07-01','2022-07-01 06:57:43','2022-07-02 06:57:43','513',0.00,0.00,'513','2022-07-01 20:09:59','513','2022-07-01 20:10:17',10,0),('1','136',257711,'DAILY SHIFT ','2022-07-02','2022-07-02 05:55:41','2022-07-03 05:55:41','513',0.00,0.00,'513','2022-07-02 18:07:31','513','2022-07-02 18:07:52',10,0),('1','136',257712,'OPERATIONAL LOSS','2022-07-02','2022-07-02 18:08:15','2022-07-03 18:08:15','513',0.00,0.00,'513','2022-07-02 18:09:10','513','2022-07-02 18:09:54',10,0),('1','136',257713,'OPERATIONAL LOSS','2022-07-02','2022-07-02 18:10:16','2022-07-03 18:10:16','513',0.00,0.00,'513','2022-07-02 18:12:40','513','2022-07-02 18:12:59',10,0),('1','136',257714,'DAILY SHIFT','2022-07-02','2022-07-02 18:13:22','2022-07-03 18:13:22','513',0.00,0.00,'513','2022-07-02 19:33:59','513','2022-07-02 19:34:22',10,0),('1','136',257715,'DAILY SHIFT ','2022-07-03','2022-07-03 05:47:39','2022-07-04 05:47:39','513',0.00,0.00,'513','2022-07-03 20:02:29','513','2022-07-03 20:02:49',10,0),('1','136',257716,'DAILY SHIFT ','2022-07-04','2022-07-04 05:46:02','2022-07-05 05:46:02','513',0.00,0.00,'513','2022-07-04 19:54:11','513','2022-07-04 19:54:29',10,0),('1','136',257717,'DAILY SHIFT ','2022-07-05','2022-07-05 06:05:40','2022-07-06 06:05:40','513',0.00,0.00,'513','2022-07-05 21:14:22','513','2022-07-05 21:14:41',10,0),('1','136',257718,'Daily Shift ','2022-07-06','2022-07-06 05:45:36','2022-07-07 05:45:36','513',0.00,0.00,'513','2022-07-06 20:06:16','513','2022-07-06 20:06:38',10,0),('1','136',257719,'DAILY SHIFT ','2022-07-07','2022-07-07 05:47:58','2022-07-08 05:47:58','513',0.00,0.00,'513','2022-07-07 19:38:34','513','2022-07-07 19:38:55',10,0),('1','136',257720,'DAILY SHIFT ','2022-07-08','2022-07-08 05:53:56','2022-07-09 05:53:56','513',0.00,0.00,'513','2022-07-08 20:06:21','513','2022-07-08 20:07:06',10,0),('1','136',257721,'DAILY SHIFT','2022-07-09','2022-07-09 11:17:34','2022-07-10 11:17:34','513',0.00,0.00,'513','2022-07-09 18:23:11','513','2022-07-09 18:25:45',10,0),('1','136',257722,'DAILY SHIFT ','2022-07-10','2022-07-10 06:04:09','2022-07-11 06:04:09','513',0.00,0.00,'513','2022-07-10 13:52:04','513','2022-07-10 13:52:21',10,0),('1','136',257723,'OPERATIONAL LOSS','2022-07-10','2022-07-10 13:52:51','2022-07-11 13:52:51','513',0.00,0.00,'513','2022-07-10 13:58:06','513','2022-07-10 13:58:23',10,0),('1','136',257724,'DAILY SHIFT','2022-07-10','2022-07-10 14:00:46','2022-07-11 14:00:46','513',0.00,0.00,'513','2022-07-10 18:42:10','513','2022-07-10 18:42:28',10,0),('1','136',257725,'DAILY SHIFT ','2022-07-11','2022-07-11 08:24:14','2022-07-12 08:24:14','513',0.00,0.00,'513','2022-07-11 18:26:11','513','2022-07-11 18:26:32',10,0),('1','136',257726,'DAILY SHIFT ','2022-07-12','2022-07-12 15:37:01','2022-07-13 15:37:01','513',0.00,0.00,'513','2022-07-12 16:04:11','513','2022-07-12 16:04:30',10,0),('1','136',257727,'OPERATIONAL LOSS','2022-07-12','2022-07-12 16:05:09','2022-07-13 16:05:09','513',0.00,0.00,'513','2022-07-12 16:07:41','513','2022-07-12 16:08:02',10,0),('1','136',257728,'DAILY SHIFT','2022-07-13','2022-07-13 16:14:22','2022-07-14 16:14:22','513',0.00,0.00,'513','2022-07-13 19:01:12','513','2022-07-13 19:01:35',10,0),('1','136',257729,'DAILY SHIFT','2022-07-14','2022-07-14 07:01:47','2022-07-15 07:01:47','513',0.00,0.00,'513','2022-07-14 19:05:29','513','2022-07-14 19:05:50',10,0),('1','136',257730,'DAILY SHIFT','2022-07-15','2022-07-15 07:06:24','2022-07-16 07:06:24','513',0.00,0.00,'513','2022-07-15 18:50:21','513','2022-07-15 18:50:42',10,0),('1','136',257731,'DAILY SHIFT','2022-07-16','2022-07-16 07:18:15','2022-07-17 07:18:15','513',0.00,0.00,'513','2022-07-16 19:23:57','513','2022-07-16 19:24:18',10,0),('1','136',257732,'DAILY SHIFT','2022-07-17','2022-07-17 07:25:11','2022-07-18 07:25:11','513',0.00,0.00,'513','2022-07-17 17:38:15','513','2022-07-17 17:38:39',10,0),('1','136',257733,'DAILY SHIFT ','2022-07-18','2022-07-18 06:05:45','2022-07-19 06:05:45','513',0.00,0.00,'513','2022-07-18 14:47:52','513','2022-07-18 14:48:09',10,0),('1','136',257734,'OPERATIONAL LOSS','2022-07-18','2022-07-18 14:48:45','2022-07-19 14:48:45','513',0.00,0.00,'513','2022-07-18 14:52:00','513','2022-07-18 14:52:14',10,0),('1','136',257735,'DAILY SHIFT','2022-07-18','2022-07-18 14:52:41','2022-07-19 14:52:41','513',0.00,0.00,'513','2022-07-18 20:01:28','513','2022-07-18 20:01:45',10,0),('1','136',257736,'Daily Shift','2022-07-19','2022-07-19 06:11:26','2022-07-20 06:11:26','513',0.00,0.00,'513','2022-07-19 19:44:32','513','2022-07-19 19:44:48',10,0),('1','136',257737,'DAILY SHIFT ','2022-07-20','2022-07-20 06:26:06','2022-07-21 06:26:06','513',0.00,0.00,'513','2022-07-20 14:44:06','513','2022-07-20 14:44:22',10,0),('1','136',257738,'OPERATIONAL LOSS','2022-07-20','2022-07-20 14:49:11','2022-07-21 14:49:11','513',0.00,0.00,'513','2022-07-20 14:52:27','513','2022-07-20 14:52:47',10,0),('1','136',257739,'DAILY SHIFT','2022-07-20','2022-07-20 14:54:29','2022-07-21 14:54:29','513',0.00,0.00,'513','2022-07-20 19:22:23','513','2022-07-20 19:22:40',10,0),('1','136',257740,'DAILY SHIFT ','2022-07-21','2022-07-21 06:20:13','2022-07-22 06:20:13','513',0.00,0.00,'513','2022-07-21 19:24:51','513','2022-07-21 19:26:14',10,0),('1','136',257741,'DAILY SHIFT ','2022-07-22','2022-07-22 05:21:46','2022-07-23 05:21:46','513',0.00,0.00,'513','2022-07-22 19:32:16','513','2022-07-22 19:32:57',10,0),('1','136',257742,'DAILY SHIFT','2022-07-23','2022-07-23 06:14:53','2022-07-24 06:14:53','513',0.00,0.00,'513','2022-07-23 19:33:31','513','2022-07-23 19:33:53',10,0),('1','136',257743,'DAILY SHIFT ','2022-07-24','2022-07-24 05:13:11','2022-07-25 05:13:11','513',0.00,0.00,'513','2022-07-24 19:20:48','513','2022-07-24 19:21:07',10,0),('1','136',257744,'DAILY SHIFF ','2022-07-25','2022-07-25 05:35:33','2022-07-26 05:35:33','513',0.00,0.00,'513','2022-07-25 19:24:48','513','2022-07-25 19:25:06',10,0),('1','136',257745,'DAILY SHIFT ','2022-07-26','2022-07-26 06:03:16','2022-07-27 06:03:16','513',0.00,0.00,'513','2022-07-26 19:59:39','513','2022-07-26 20:02:12',10,0),('1','136',257746,'DAILY SHIFT ','2022-07-27','2022-07-27 06:14:37','2022-07-28 06:14:37','513',0.00,0.00,'513','2022-07-27 20:42:10','513','2022-07-27 20:42:30',10,0),('1','136',257747,'DAILY SHIFT','2022-07-28','2022-07-28 06:02:37','2022-07-29 06:02:37','513',0.00,0.00,'513','2022-07-28 12:13:42','513','2022-07-28 12:14:03',10,0),('1','136',257748,'OPERATIONAL LOSS','2022-07-28','2022-07-28 12:14:31','2022-07-29 12:14:31','513',0.00,0.00,'513','2022-07-28 12:16:56','513','2022-07-28 12:17:13',10,0),('1','136',257749,'DAILY SHIFT','2022-07-28','2022-07-28 12:17:35','2022-07-29 12:17:35','513',0.00,0.00,'513','2022-07-28 21:12:17','513','2022-07-28 21:12:35',10,0),('1','136',257750,'DAILY SHIFF ','2022-07-29','2022-07-29 06:23:51','2022-07-30 06:23:51','513',0.00,0.00,'513','2022-07-29 20:15:57','513','2022-07-29 20:16:16',10,0),('1','136',257751,'DAILY SHIFT ','2022-07-30','2022-07-30 05:47:42','2022-07-31 05:47:42','513',0.00,0.00,'513','2022-07-30 23:28:16','513','2022-07-30 23:28:33',10,0),('1','136',257752,'DAILY SHIFT ','2022-07-31','2022-07-31 06:06:39','2022-08-01 06:06:39','513',0.00,0.00,'513','2022-07-31 22:54:52','513','2022-07-31 22:55:40',10,0),('1','136',257753,'DAILY SHIFT ','2022-08-01','2022-08-01 05:32:32','2022-08-02 05:32:32','513',0.00,0.00,'513','2022-08-02 06:11:05','513','2022-08-02 06:11:39',10,0),('1','136',257754,'DAILY SHIFT','2022-08-02','2022-08-02 06:12:46','2022-08-03 06:12:46','513',0.00,0.00,'513','2022-08-02 13:38:59','513','2022-08-02 13:39:38',10,0),('1','136',257755,'DAILY SHIFT','2022-08-02','2022-08-02 14:43:15','2022-08-03 14:43:15','513',0.00,0.00,'513','2022-08-02 17:46:37','513','2022-08-02 17:46:56',10,0),('1','136',257756,'DAILY SHIFT ','2022-08-02','2022-08-02 17:47:23','2022-08-03 17:47:23','513',0.00,0.00,'513','2022-08-02 22:53:09','513','2022-08-02 22:54:39',10,0),('1','136',257757,'DAILY SHIFF ','2022-08-03','2022-08-03 05:53:31','2022-08-04 05:53:31','513',0.00,0.00,'513','2022-08-03 22:42:04','513','2022-08-03 22:42:24',10,0),('1','136',257758,'DAILY SHIFT','2022-08-04','2022-08-04 05:58:33','2022-08-05 05:58:33','513',0.00,0.00,'513','2022-08-04 13:26:02','513','2022-08-04 13:26:18',10,0),('1','136',257759,'NEW SHIFT ','2022-08-04','2022-08-04 13:27:30','2022-08-05 13:27:30','513',0.00,0.00,'513','2022-08-04 13:32:35','513','2022-08-04 13:34:06',10,0),('1','136',257760,'NEW SHIFT ','2022-08-04','2022-08-04 13:37:46','2022-08-05 13:37:46','513',0.00,0.00,'513','2022-08-04 23:54:48','513','2022-08-04 23:56:14',10,0),('1','136',257761,'DAILY SHIFT','2022-08-05','2022-08-05 06:00:33','2022-08-06 06:00:33','513',0.00,0.00,'513','2022-08-05 22:53:26','513','2022-08-05 22:53:52',10,0),('1','136',257762,'DAILY SHIFT','2022-08-06','2022-08-06 06:04:56','2022-08-07 06:04:56','513',0.00,0.00,'513','2022-08-06 22:29:37','513','2022-08-06 22:30:01',10,0),('1','136',257763,'DAILY SHIFT','2022-08-07','2022-08-07 05:58:37','2022-08-08 05:58:37','513',0.00,0.00,'513','2022-08-07 23:41:13','513','2022-08-07 23:41:47',10,0),('1','136',257764,'DAILY SHIFT ','2022-08-08','2022-08-08 06:11:41','2022-08-09 06:11:41','513',0.00,0.00,'513','2022-08-08 22:44:25','513','2022-08-08 22:44:57',10,0),('1','136',257765,'DAILY SHIFT ','2022-08-09','2022-08-09 06:28:12','2022-08-10 06:28:12','513',0.00,0.00,'513','2022-08-09 10:39:48','513','2022-08-09 10:40:15',10,0),('1','136',257766,'OPERATIONAL LOSS','2022-08-09','2022-08-09 10:41:05','2022-08-10 10:41:05','513',0.00,0.00,'513','2022-08-09 12:33:24','513','2022-08-09 12:33:48',10,0),('1','136',257767,'DAILY SHIFT ','2022-08-09','2022-08-09 12:34:15','2022-08-10 12:34:15','513',0.00,0.00,'513','2022-08-09 23:10:18','513','2022-08-09 23:10:40',10,0),('1','136',257768,'DAILY SHIFT','2022-08-10','2022-08-10 06:25:47','2022-08-11 06:25:47','513',0.00,0.00,'513','2022-08-10 22:17:06','513','2022-08-10 22:17:46',10,0),('1','136',257769,'DAILY S HIFT','2022-08-11','2022-08-11 06:11:54','2022-08-12 06:11:54','513',0.00,0.00,'513','2022-08-11 19:52:19','513','2022-08-11 19:52:45',10,0),('1','136',257770,'DAILY SHIFT','2022-08-12','2022-08-12 06:04:25','2022-08-13 06:04:25','513',0.00,0.00,'513','2022-08-12 11:10:15','513','2022-08-12 11:10:40',10,0),('1','136',257771,'OPERATIONAL LOSS','2022-08-12','2022-08-12 11:11:11','2022-08-13 11:11:11','513',0.00,0.00,'513','2022-08-12 11:28:06','513','2022-08-12 11:28:27',10,0),('1','136',257772,'DAILY SHIFT','2022-08-12','2022-08-12 11:28:53','2022-08-13 11:28:53','513',0.00,0.00,'513','2022-08-12 19:24:05','513','2022-08-12 19:26:50',10,0),('1','136',257773,'DAILY SHIFT','2022-08-13','2022-08-13 06:09:43','2022-08-14 06:09:43','513',0.00,0.00,'513','2022-08-13 19:17:03','513','2022-08-13 19:17:22',10,0),('1','136',257774,'DAILY SHIFT','2022-08-14','2022-08-14 05:59:01','2022-08-15 05:59:01','513',0.00,0.00,'513','2022-08-14 19:30:38','513','2022-08-14 19:31:00',10,0),('1','136',257775,'DAILY SHIFT','2022-08-15','2022-08-15 06:40:04','2022-08-16 06:40:04','513',0.00,0.00,'513','2022-08-15 11:05:58','513','2022-08-15 11:06:18',10,0),('1','136',257776,'OPERATIONAL LOSS','2022-08-15','2022-08-15 11:06:46','2022-08-16 11:06:46','513',0.00,0.00,'513','2022-08-15 11:09:28','513','2022-08-15 11:09:48',10,0),('1','136',257777,'DAILY SHIFT','2022-08-15','2022-08-15 11:10:12','2022-08-16 11:10:12','513',0.00,0.00,'513','2022-08-15 19:33:21','513','2022-08-15 19:33:39',10,0),('1','136',257778,'DAILYSHIFT','2022-08-16','2022-08-16 06:06:58','2022-08-17 06:06:58','513',0.00,0.00,'513','2022-08-16 18:52:24','513','2022-08-16 18:52:47',10,0),('1','136',257779,'DAILY SHIFT','2022-08-17','2022-08-17 06:01:18','2022-08-18 06:01:18','513',0.00,0.00,'513','2022-08-17 11:24:35','513','2022-08-17 11:24:57',10,0),('1','136',257780,'OPERATIONAL LOSS','2022-08-17','2022-08-17 11:25:35','2022-08-18 11:25:35','513',0.00,0.00,'513','2022-08-17 11:29:16','513','2022-08-17 11:29:35',10,0),('1','136',257781,'DAILY SHIFT','2022-08-17','2022-08-17 11:30:04','2022-08-18 11:30:04','513',0.00,0.00,'513','2022-08-17 19:24:35','513','2022-08-17 19:24:57',10,0),('1','136',257782,'DAILY SHIFT ','2022-08-18','2022-08-18 06:02:06','2022-08-19 06:02:06','513',0.00,0.00,'513','2022-08-18 19:31:27','513','2022-08-18 19:31:47',10,0),('1','136',257783,'DAILY SHIFT','2022-08-19','2022-08-19 05:58:02','2022-08-20 05:58:02','513',0.00,0.00,'513','2022-08-19 19:28:41','513','2022-08-19 19:29:00',10,0),('1','136',257784,'DAILY SHIFT ','2022-08-20','2022-08-20 05:59:10','2022-08-21 05:59:10','513',0.00,0.00,'513','2022-08-20 19:21:29','513','2022-08-20 19:22:04',10,0),('1','136',257785,'DAILY SHIFT','2022-08-21','2022-08-21 05:55:05','2022-08-22 05:55:05','513',0.00,0.00,'513','2022-08-21 22:05:41','513','2022-08-21 22:06:15',10,0),('1','136',257786,'DAILY SHIFT','2022-08-22','2022-08-22 05:48:23','2022-08-23 05:48:23','513',0.00,0.00,'513','2022-08-22 19:26:19','513','2022-08-22 19:26:59',10,0),('1','136',257787,'DAILY SHIFT','2022-08-23','2022-08-23 05:44:55','2022-08-24 05:44:55','513',0.00,0.00,'513','2022-08-23 19:45:14','513','2022-08-23 19:45:41',10,0),('1','136',257788,'DAILY SHIFT','2022-08-24','2022-08-24 06:08:25','2022-08-25 06:08:25','513',0.00,0.00,'513','2022-08-24 21:27:27','513','2022-08-24 21:27:48',10,0),('1','136',257789,'DAILY SHIFT','2022-08-25','2022-08-25 06:07:42','2022-08-26 06:07:42','513',0.00,0.00,'513','2022-08-25 19:13:16','513','2022-08-25 19:13:41',10,0),('1','136',257790,'DAILY SHIFT','2022-08-26','2022-08-26 06:31:14','2022-08-27 06:31:14','513',0.00,0.00,'513','2022-08-26 17:42:48','513','2022-08-26 17:43:08',10,0),('1','136',257791,'DAILY SHIFT','2022-08-27','2022-08-27 06:59:10','2022-08-28 06:59:10','513',0.00,0.00,'513','2022-08-27 10:53:42','513','2022-08-27 10:54:02',10,0),('1','136',257792,'OPERATIONAL LOSS','2022-08-27','2022-08-27 10:54:31','2022-08-28 10:54:31','513',0.00,0.00,'513','2022-08-27 11:03:49','513','2022-08-27 11:04:07',10,0),('1','136',257793,'DAILY SHIFT','2022-08-27','2022-08-27 11:04:33','2022-08-28 11:04:33','513',0.00,0.00,'513','2022-08-27 19:59:39','513','2022-08-27 20:00:02',10,0),('1','136',257794,'DAILY SHIFT','2022-08-28','2022-08-28 06:01:42','2022-08-29 06:01:42','513',0.00,0.00,'513','2022-08-28 18:40:28','513','2022-08-28 18:40:45',10,0),('1','136',257795,'OPERATIONAL LOSS','2022-08-28','2022-08-28 18:42:06','2022-08-29 18:42:06','513',0.00,0.00,'513','2022-08-28 18:44:21','513','2022-08-28 18:44:40',10,0),('1','136',257796,'DAILY SHIFT','2022-08-28','2022-08-28 18:45:05','2022-08-29 18:45:05','513',0.00,0.00,'513','2022-08-28 19:41:19','513','2022-08-28 19:41:38',10,0),('1','136',257797,'DAILY SHIFT','2022-08-29','2022-08-29 06:13:39','2022-08-30 06:13:39','513',0.00,0.00,'513','2022-08-29 20:16:09','513','2022-08-29 20:16:28',10,0),('1','136',257798,'DAILY SHIFT ','2022-08-30','2022-08-30 06:09:20','2022-08-31 06:09:20','513',0.00,0.00,'513','2022-08-30 19:43:49','513','2022-08-30 19:44:09',10,0),('1','136',257799,'DAILY SHIFT','2022-08-31','2022-08-31 06:46:11','2022-09-01 06:46:11','513',0.00,0.00,'513','2022-08-31 13:57:41','513','2022-08-31 13:58:04',10,0),('1','136',257800,'OPERATIONAL LOSS','2022-08-31','2022-08-31 14:00:24','2022-09-01 14:00:24','513',0.00,0.00,'513','2022-08-31 14:02:42','513','2022-08-31 14:03:02',10,0),('1','136',257801,'DAILY SHIFT','2022-08-31','2022-08-31 14:03:22','2022-09-01 14:03:22','513',0.00,0.00,'513','2022-08-31 19:21:49','513','2022-08-31 19:22:07',10,0),('1','136',257802,'DAILY SHIFT','2022-09-01','2022-09-01 06:36:46','2022-09-02 06:36:46','513',0.00,0.00,'513','2022-09-01 19:16:41','513','2022-09-01 19:17:11',10,0),('1','136',257803,'DAILY SHIFT','2022-09-02','2022-09-02 06:57:30','2022-09-03 06:57:30','513',0.00,0.00,'513','2022-09-02 20:00:50','513','2022-09-02 20:01:12',10,0),('1','136',257804,'DAILY SHIFT ','2022-09-03','2022-09-03 06:13:37','2022-09-04 06:13:37','513',0.00,0.00,'513','2022-09-03 20:36:53','513','2022-09-03 20:37:37',10,0),('1','136',257805,'DAILY SHIFT ','2022-09-04','2022-09-04 06:32:40','2022-09-05 06:32:40','513',0.00,0.00,'513','2022-09-04 20:12:01','513','2022-09-04 20:12:21',10,0),('1','136',257806,'DAILY SHIFT','2022-09-05','2022-09-05 07:03:35','2022-09-06 07:03:35','513',0.00,0.00,'513','2022-09-05 19:38:50','513','2022-09-05 19:39:11',10,0),('1','136',257807,'DAILY SHIFT','2022-09-06','2022-09-06 06:13:16','2022-09-07 06:13:16','513',0.00,0.00,'513','2022-09-06 19:49:40','513','2022-09-06 19:50:02',10,0),('1','136',257808,'DAILY SHIFT','2022-09-07','2022-09-07 06:03:23','2022-09-08 06:03:23','513',0.00,0.00,'513','2022-09-07 20:14:10','513','2022-09-07 20:14:32',10,0),('1','136',257809,'DAILY SHIFT','2022-09-08','2022-09-08 06:06:25','2022-09-09 06:06:25','513',0.00,0.00,'513','2022-09-08 19:36:00','513','2022-09-08 19:36:23',10,0),('1','136',257810,'DAILY SHIFT','2022-09-09','2022-09-09 06:01:53','2022-09-10 06:01:53','513',0.00,0.00,'513','2022-09-09 19:42:19','513','2022-09-09 19:42:43',10,0),('1','136',257811,'DAILY SHIFT','2022-09-10','2022-09-10 06:56:04','2022-09-11 06:56:04','513',0.00,0.00,'513','2022-09-10 10:28:21','513','2022-09-10 10:28:39',10,0),('1','136',257812,'OPERATIONAL LOSS','2022-09-10','2022-09-10 10:29:06','2022-09-11 10:29:06','513',0.00,0.00,'513','2022-09-10 10:32:53','513','2022-09-10 10:33:09',10,0),('1','136',257813,'DAILY SHIFT','2022-09-12','2022-09-12 07:09:37','2022-09-13 07:09:37','513',0.00,0.00,'513','2022-09-12 19:23:06','513','2022-09-12 19:23:39',10,0),('1','136',257814,'DAILY SHIFT','2022-09-13','2022-09-13 06:16:27','2022-09-14 06:16:27','513',0.00,0.00,'513','2022-09-13 19:12:21','513','2022-09-13 19:13:01',10,0),('1','136',257815,'DAILY SHIFF','2022-09-14','2022-09-14 06:25:11','2022-09-15 06:25:11','513',0.00,0.00,'513','2022-09-14 09:04:26','513','2022-09-14 09:04:48',10,0),('1','136',257816,'OPERATIONAL LOSS','2022-09-14','2022-09-14 09:05:23','2022-09-15 09:05:23','513',0.00,0.00,'513','2022-09-14 09:26:44','513','2022-09-14 09:27:07',10,0),('1','136',257817,'NEW SHIFT ','2022-09-14','2022-09-14 09:36:09','2022-09-15 09:36:09','513',0.00,0.00,'513','2022-09-14 19:16:15','513','2022-09-14 19:16:58',10,0),('1','136',257818,'DAILY SHIP ','2022-09-15','2022-09-15 06:21:59','2022-09-16 06:21:59','513',0.00,0.00,'513','2022-09-15 18:18:49','513','2022-09-15 18:24:04',10,0),('1','136',257819,'DAILY SHIFT','2022-09-16','2022-09-16 06:30:02','2022-09-17 06:30:02','513',0.00,0.00,'513','2022-09-16 15:05:58','513','2022-09-16 15:06:18',10,0),('1','136',257820,'OPERATIONAL LOSS','2022-09-16','2022-09-16 15:06:42','2022-09-17 15:06:42','513',0.00,0.00,'513','2022-09-16 15:09:21','513','2022-09-16 15:09:39',10,0),('1','136',257821,'DAILY SHIFT','2022-09-17','2022-09-17 07:01:25','2022-09-18 07:01:25','513',0.00,0.00,'513','2022-09-17 19:09:38','513','2022-09-17 19:10:03',10,0),('1','136',257822,'DAILY SHIFT ','2022-09-18','2022-09-18 06:02:05','2022-09-19 06:02:05','513',0.00,0.00,'513','2022-09-18 17:35:34','513','2022-09-18 17:35:58',10,0),('1','136',257823,'DAILY SHIFT','2022-09-19','2022-09-19 06:11:12','2022-09-20 06:11:12','513',0.00,0.00,'513','2022-09-19 11:06:42','513','2022-09-19 11:07:03',10,0),('1','136',257824,'OPERATIONAL LOSS','2022-09-19','2022-09-19 11:07:41','2022-09-20 11:07:41','513',0.00,0.00,'513','2022-09-19 11:10:35','513','2022-09-19 11:10:52',10,0),('1','136',257825,'DAILY SHIFT','2022-09-19','2022-09-19 11:18:18','2022-09-20 11:18:18','513',0.00,0.00,'513','2022-09-19 18:55:14','513','2022-09-19 18:55:55',10,0),('1','136',257826,'DAILY SHIFT ','2022-09-20','2022-09-20 06:32:52','2022-09-21 06:32:52','513',0.00,0.00,'513','2022-09-20 18:59:44','513','2022-09-20 19:00:09',10,0),('1','136',257827,'DAILY SHIFT','2022-09-21','2022-09-21 06:28:58','2022-09-22 06:28:58','513',0.00,0.00,'513','2022-09-21 12:58:26','513','2022-09-21 12:58:46',10,0),('1','136',257828,'OPERATIONAL LOSS','2022-09-21','2022-09-21 12:59:09','2022-09-22 12:59:09','513',0.00,0.00,'513','2022-09-21 13:07:29','513','2022-09-21 13:07:47',10,0),('1','136',257829,'DAILY SHIFT','2022-09-21','2022-09-21 13:08:05','2022-09-22 13:08:05','513',0.00,0.00,'513','2022-09-21 19:11:01','513','2022-09-21 19:11:27',10,0),('1','136',257830,'DAILY SHIFT','2022-09-22','2022-09-22 07:00:32','2022-09-23 07:00:32','513',0.00,0.00,'513','2022-09-22 19:05:25','513','2022-09-22 19:05:44',10,0),('1','136',257831,'DAILY SHIFT','2022-09-23','2022-09-23 06:15:48','2022-09-24 06:15:48','513',0.00,0.00,'513','2022-09-23 19:05:52','513','2022-09-23 19:06:15',10,0),('1','136',257832,'DAILY SHIFT','2022-09-24','2022-09-24 06:27:53','2022-09-25 06:27:53','513',0.00,0.00,'513','2022-09-24 13:43:14','513','2022-09-24 13:43:34',10,0),('1','136',257833,'OPERATIONAL LOSS','2022-09-24','2022-09-24 13:43:58','2022-09-25 13:43:58','513',0.00,0.00,'513','2022-09-24 13:46:39','513','2022-09-24 13:47:01',10,0),('1','136',257834,'DAILY SHIFT','2022-09-24','2022-09-24 13:47:29','2022-09-25 13:47:29','513',0.00,0.00,'513','2022-09-24 19:00:36','513','2022-09-24 19:01:03',10,0),('1','136',257835,'DAILY SHIFT','2022-09-25','2022-09-25 07:01:32','2022-09-26 07:01:32','513',0.00,0.00,'513','2022-09-25 19:38:53','513','2022-09-25 19:39:35',10,0),('1','136',257836,'DAILY SHIFT','2022-09-26','2022-09-26 07:37:32','2022-09-27 07:37:32','513',0.00,0.00,'513','2022-09-26 18:51:08','513','2022-09-26 18:51:32',10,0),('1','136',257837,'DAILY SHIFT','2022-09-27','2022-09-27 06:08:08','2022-09-28 06:08:08','513',0.00,0.00,'513','2022-09-27 19:24:45','513','2022-09-27 19:25:16',10,0),('1','136',257838,'DAILY SHIFT','2022-09-28','2022-09-28 06:17:11','2022-09-29 06:17:11','513',0.00,0.00,'513','2022-09-28 19:10:48','513','2022-09-28 19:11:29',10,0),('1','136',257839,'DAILY SHIFT','2022-09-29','2022-09-29 06:20:54','2022-09-30 06:20:54','513',0.00,0.00,'513','2022-09-29 18:53:07','513','2022-09-29 18:53:38',10,0),('1','136',257840,'DAILY SHIFT','2022-09-30','2022-09-30 06:11:14','2022-10-01 06:11:14','513',0.00,0.00,'513','2022-09-30 18:51:15','513','2022-09-30 18:51:39',10,0),('1','136',257841,'DAILY SHIFT','2022-10-01','2022-10-01 06:38:25','2022-10-02 06:38:25','513',0.00,0.00,'513','2022-10-01 19:04:57','513','2022-10-01 19:05:42',10,0),('1','136',257842,'DAILY SHIFT ','2022-10-02','2022-10-02 06:27:37','2022-10-03 06:27:37','513',0.00,0.00,'513','2022-10-02 19:01:31','513','2022-10-02 19:01:57',10,0),('1','136',257843,'DAILY SHIFT','2022-10-03','2022-10-03 06:27:53','2022-10-04 06:27:53','513',0.00,0.00,'513','2022-10-03 10:43:51','513','2022-10-03 10:44:13',10,0),('1','136',257844,'NEW SHIFT ','2022-10-03','2022-10-03 10:45:49','2022-10-04 10:45:49','513',0.00,0.00,'513','2022-10-03 18:59:47','513','2022-10-03 19:00:25',10,0),('1','136',257845,'DAILY SHIFT','2022-10-04','2022-10-04 06:18:35','2022-10-05 06:18:35','513',0.00,0.00,'513','2022-10-04 18:38:25','513','2022-10-04 18:38:48',10,0),('1','136',257846,'DAILY SHIFT','2022-10-05','2022-10-05 06:18:40','2022-10-06 06:18:40','513',0.00,0.00,'513','2022-10-05 19:02:52','513','2022-10-05 19:03:18',10,0),('1','136',257847,'DAILY SHIFT','2022-10-06','2022-10-06 07:25:19','2022-10-07 07:25:19','513',0.00,0.00,'513','2022-10-06 09:12:13','513','2022-10-06 09:12:34',10,0),('1','136',257848,'OPERATIONAL LOSS','2022-10-06','2022-10-06 09:13:07','2022-10-07 09:13:07','513',0.00,0.00,'513','2022-10-06 09:33:42','513','2022-10-06 09:34:05',10,0),('1','136',257849,'NEW SHIFT ','2022-10-06','2022-10-06 09:39:34','2022-10-07 09:39:34','513',0.00,0.00,'513','2022-10-06 19:06:25','513','2022-10-06 19:06:59',10,0),('1','136',257850,'DAILY SHIFT','2022-10-07','2022-10-07 06:22:36','2022-10-08 06:22:36','513',0.00,0.00,'513','2022-10-07 11:06:54','513','2022-10-07 11:07:16',10,0),('1','136',257851,'OPERATIONAL LOSS','2022-10-07','2022-10-07 11:07:47','2022-10-08 11:07:47','513',0.00,0.00,'513','2022-10-07 11:15:42','513','2022-10-07 11:16:02',10,0),('1','136',257852,'NEW SHIFT ','2022-10-07','2022-10-07 11:19:24','2022-10-08 11:19:24','513',0.00,0.00,'513','2022-10-07 19:19:29','513','2022-10-07 19:19:52',10,0),('1','136',257853,'DAILY SHIFT','2022-10-08','2022-10-08 07:11:19','2022-10-09 07:11:19','513',0.00,0.00,'513','2022-10-08 10:47:01','513','2022-10-08 10:47:23',10,0),('1','136',257854,'OPERATIONAL LOSS','2022-10-08','2022-10-08 12:54:16','2022-10-09 12:54:16','513',0.00,0.00,'513','2022-10-08 13:01:23','513','2022-10-08 13:01:43',10,0),('1','136',257855,'NEW SHIFT ','2022-10-08','2022-10-08 13:05:54','2022-10-09 13:05:54','513',0.00,0.00,'513','2022-10-08 16:43:23','513','2022-10-08 16:43:44',10,0),('1','136',257856,'DAILY SHIFT','2022-10-08','2022-10-08 16:44:08','2022-10-09 16:44:08','513',0.00,0.00,'513','2022-10-08 18:44:24','513','2022-10-08 18:44:49',10,0),('1','136',257857,'DAILY SHIFT ','2022-10-09','2022-10-09 15:06:04','2022-10-10 15:06:04','513',0.00,0.00,'513','2022-10-09 15:08:03','513','2022-10-09 15:08:41',10,0),('1','136',257858,'OPERATIONAL LOSS','2022-10-09','2022-10-09 15:09:04','2022-10-10 15:09:04','513',0.00,0.00,'513','2022-10-09 15:13:44','513','2022-10-09 15:14:00',10,0),('1','136',257859,'DAILY SHIFT','2022-10-10','2022-10-10 08:03:15','2022-10-11 08:03:15','513',0.00,0.00,'513','2022-10-10 19:23:59','513','2022-10-10 19:24:20',10,0),('1','136',257860,'DAILY SHIFT','2022-10-11','2022-10-11 06:59:15','2022-10-12 06:59:15','513',0.00,0.00,'513','2022-10-11 11:28:53','513','2022-10-11 11:29:15',10,0),('1','136',257861,'OPERATIONAL LOSS','2022-10-11','2022-10-11 11:29:58','2022-10-12 11:29:58','513',0.00,0.00,'513','2022-10-11 11:33:37','513','2022-10-11 11:33:57',10,0),('1','136',257862,'NEW SHIFT ','2022-10-11','2022-10-11 11:48:25','2022-10-12 11:48:25','513',0.00,0.00,'513','2022-10-11 18:56:47','513','2022-10-11 18:57:18',10,0),('1','136',257863,'DAILY SHIFT','2022-10-12','2022-10-12 06:56:27','2022-10-13 06:56:27','513',0.00,0.00,'513','2022-10-12 19:29:27','513','2022-10-12 19:29:48',10,0),('1','136',257864,'DAILY SHIFT','2022-10-13','2022-10-13 06:49:29','2022-10-14 06:49:29','513',0.00,0.00,'513','2022-10-13 16:15:47','513','2022-10-13 16:16:06',10,0),('1','136',257865,'OPERATIONAL LOSS','2022-10-13','2022-10-13 16:16:33','2022-10-14 16:16:33','513',0.00,0.00,'513','2022-10-13 16:21:23','513','2022-10-13 16:21:39',10,0),('1','136',257866,'DAILY SHIFT','2022-10-13','2022-10-13 16:22:25','2022-10-14 16:22:25','513',0.00,0.00,'513','2022-10-13 18:49:13','513','2022-10-13 18:49:47',10,0),('1','136',257867,'DAILY SHIFT','2022-10-14','2022-10-14 06:45:17','2022-10-15 06:45:17','513',0.00,0.00,'513','2022-10-14 18:53:03','513','2022-10-14 18:53:36',10,0),('1','136',257868,'DAILY SHIFT','2022-10-15','2022-10-15 06:54:48','2022-10-16 06:54:48','513',0.00,0.00,'513','2022-10-15 11:31:01','513','2022-10-15 11:31:21',10,0),('1','136',257869,'OPERATIONAL LOSS','2022-10-15','2022-10-15 11:36:22','2022-10-16 11:36:22','513',0.00,0.00,'513','2022-10-15 11:41:30','513','2022-10-15 11:41:47',10,0),('1','136',257870,'DAILY SHIFT','2022-10-15','2022-10-15 11:42:10','2022-10-16 11:42:10','513',0.00,0.00,'513','2022-10-15 19:27:55','513','2022-10-15 19:28:16',10,0),('1','136',257871,'DAILY SHIFT','2022-10-16','2022-10-16 07:00:21','2022-10-17 07:00:21','513',0.00,0.00,'513','2022-10-16 10:46:49','513','2022-10-16 10:47:29',10,0),('1','136',257872,'OPERATIONAL LOSS','2022-10-16','2022-10-16 10:47:52','2022-10-17 10:47:52','513',0.00,0.00,'513','2022-10-16 10:50:18','513','2022-10-16 10:50:39',10,0),('1','136',257873,'DAILY SHIFT','2022-10-16','2022-10-16 10:50:59','2022-10-17 10:50:59','513',0.00,0.00,'513','2022-10-16 19:05:23','513','2022-10-16 19:05:54',10,0),('1','136',257874,'DAILY SHIFT','2022-10-17','2022-10-17 06:49:50','2022-10-18 06:49:50','513',0.00,0.00,'513','2022-10-17 18:46:16','513','2022-10-17 18:46:37',10,0),('1','136',257875,'DAILY SHIFT','2022-10-18','2022-10-18 06:57:27','2022-10-19 06:57:27','513',0.00,0.00,'513','2022-10-18 16:18:30','513','2022-10-18 16:18:51',10,0),('1','136',257876,'DAILY SHIFT','2022-10-18','2022-10-18 16:19:10','2022-10-19 16:19:10','513',0.00,0.00,'513','2022-10-18 16:21:13','513','2022-10-18 16:21:31',10,0),('1','136',257877,'DAILY SHIFT','2022-10-18','2022-10-18 16:21:52','2022-10-19 16:21:52','513',0.00,0.00,'513','2022-10-18 21:08:52','513','2022-10-18 21:09:17',10,0),('1','136',257878,'DAILY SHIFT','2022-10-19','2022-10-19 06:54:49','2022-10-20 06:54:49','513',0.00,0.00,'513','2022-10-19 18:34:35','513','2022-10-19 18:35:25',10,0),('1','136',257879,'DAILY SHIFT','2022-10-20','2022-10-20 06:55:42','2022-10-21 06:55:42','513',0.00,0.00,'513','2022-10-20 18:26:16','513','2022-10-20 18:26:46',10,0),('1','136',257880,'DAILY SHIFT','2022-10-21','2022-10-21 06:30:07','2022-10-22 06:30:07','513',0.00,0.00,'513','2022-10-21 14:15:46','513','2022-10-21 14:16:07',10,0),('1','136',257881,'OPERATIONAL LOSS','2022-10-21','2022-10-21 14:16:30','2022-10-22 14:16:30','513',0.00,0.00,'513','2022-10-21 14:19:07','513','2022-10-21 14:19:44',10,0),('1','136',257882,'DAILY SHIFT','2022-10-21','2022-10-21 14:20:37','2022-10-22 14:20:37','513',0.00,0.00,'513','2022-10-21 18:38:48','513','2022-10-21 18:39:13',10,0),('1','136',257883,'DAILY SHIFT','2022-10-22','2022-10-22 06:44:33','2022-10-23 06:44:33','513',0.00,0.00,'513','2022-10-22 17:54:45','513','2022-10-22 17:55:11',10,0),('1','136',257884,'DAILY SHIFT','2022-10-23','2022-10-23 06:38:24','2022-10-24 06:38:24','513',0.00,0.00,'513','2022-10-23 09:49:22','513','2022-10-23 09:50:21',10,0),('1','136',257885,'OPERATIONAL LOSS','2022-10-23','2022-10-23 09:50:46','2022-10-24 09:50:46','513',0.00,0.00,'513','2022-10-23 09:57:50','513','2022-10-23 09:58:16',10,0),('1','136',257886,'NEW SHIFT ','2022-10-23','2022-10-23 09:58:41','2022-10-24 09:58:41','513',0.00,0.00,'513','2022-10-23 19:01:27','513','2022-10-23 19:01:46',10,0),('1','136',257887,'DAILY SHIFT','2022-10-24','2022-10-24 06:56:07','2022-10-25 06:56:07','513',0.00,0.00,'513','2022-10-24 18:33:50','513','2022-10-24 18:34:20',10,0),('1','136',257888,'DAILY SHIFT','2022-10-25','2022-10-25 06:55:06','2022-10-26 06:55:06','513',0.00,0.00,'513','2022-10-25 15:39:51','513','2022-10-25 15:40:09',10,0),('1','136',257889,'OPERATIONAL LOSS','2022-10-25','2022-10-25 15:40:29','2022-10-26 15:40:29','513',0.00,0.00,'513','2022-10-25 15:42:52','513','2022-10-25 15:43:11',10,0),('1','136',257890,'DAILY SHIFT','2022-10-25','2022-10-25 15:43:29','2022-10-26 15:43:29','513',0.00,0.00,'513','2022-10-25 18:34:35','513','2022-10-25 18:35:07',10,0),('1','136',257891,'DAILY SHIFT','2022-10-26','2022-10-26 06:46:49','2022-10-27 06:46:49','513',0.00,0.00,'513','2022-10-26 18:41:58','513','2022-10-26 18:42:17',10,0),('1','136',257892,'DAILY SHIFT','2022-10-27','2022-10-27 06:37:52','2022-10-28 06:37:52','513',0.00,0.00,'513','2022-10-27 18:38:48','513','2022-10-27 18:39:42',10,0),('1','136',257893,'DAILY SHIFT','2022-10-28','2022-10-28 06:16:47','2022-10-29 06:16:47','513',0.00,0.00,'513','2022-10-28 15:55:29','513','2022-10-28 15:55:53',10,0),('1','136',257894,'OPERATIONAL LOSS','2022-10-28','2022-10-28 15:56:17','2022-10-29 15:56:17','513',0.00,0.00,'513','2022-10-28 16:00:46','513','2022-10-28 16:01:05',10,0),('1','136',257895,'NEW SHIFT ','2022-10-28','2022-10-28 16:06:25','2022-10-29 16:06:25','513',0.00,0.00,'513','2022-10-28 18:40:44','513','2022-10-28 18:41:08',10,0),('1','136',257896,'DAILY SHIFT','2022-10-29','2022-10-29 07:10:25','2022-10-30 07:10:25','513',0.00,0.00,'513','2022-10-29 18:40:29','513','2022-10-29 18:41:08',10,0),('1','136',257897,'DAILY SHIFT','2022-10-30','2022-10-30 06:30:15','2022-10-31 06:30:15','513',0.00,0.00,'513','2022-10-30 16:16:14','513','2022-10-30 16:16:51',10,0),('1','136',257898,'DAILY SHIFT','2022-10-31','2022-10-31 07:38:01','2022-11-01 07:38:01','513',0.00,0.00,'513','2022-10-31 09:20:02','513','2022-10-31 09:20:51',10,0),('1','136',257899,'OPERATIONAL LOSS','2022-10-31','2022-10-31 09:21:34','2022-11-01 09:21:34','513',0.00,0.00,'513','2022-10-31 09:25:04','513','2022-10-31 09:25:27',10,0),('1','136',257900,'DAILY SHIFT','2022-11-03','2022-11-03 13:44:58','2022-11-04 13:44:58','513',0.00,0.00,'513','2022-11-03 18:55:48','513','2022-11-03 18:56:13',10,0),('1','136',257901,'DAILY SHIFT','2022-11-04','2022-11-04 06:28:10','2022-11-05 06:28:10','513',0.00,0.00,'513','2022-11-04 18:35:40','513','2022-11-04 18:36:10',10,0),('1','136',257902,'DAILY SHIFT','2022-11-05','2022-11-05 10:58:54','2022-11-06 10:58:54','513',0.00,0.00,'513','2022-11-05 17:33:40','513','2022-11-05 17:34:08',10,0),('1','136',257903,'DAILY SHIFT','2022-11-06','2022-11-06 07:57:11','2022-11-07 07:57:11','513',0.00,0.00,'513','2022-11-06 08:12:08','513','2022-11-06 08:12:31',10,0),('1','136',257904,'OPERATIONAL LOSS','2022-11-06','2022-11-06 08:14:30','2022-11-07 08:14:30','513',0.00,0.00,'513','2022-11-06 08:18:47','513','2022-11-06 08:19:05',10,0),('1','136',257905,'NEW SHIFT','2022-11-06','2022-11-06 09:54:06','2022-11-07 09:54:06','513',0.00,0.00,'513','2022-11-06 18:33:41','513','2022-11-06 18:34:52',10,0),('1','136',257906,'DAILY SHIFT','2022-11-07','2022-11-07 06:13:01','2022-11-08 06:13:01','513',0.00,0.00,'513','2022-11-07 18:40:13','513','2022-11-07 18:40:58',10,0),('1','136',257907,'DAILY SHiFT ','2022-11-08','2022-11-08 06:18:30','2022-11-09 06:18:30','513',0.00,0.00,'513','2022-11-08 17:52:37','513','2022-11-08 17:53:11',10,0),('1','136',257908,'DAILY SHIFT','2022-11-09','2022-11-09 06:50:47','2022-11-10 06:50:47','513',0.00,0.00,'513','2022-11-09 07:31:56','513','2022-11-09 07:32:15',10,0),('1','136',257909,'OPERATIONAL LOSS','2022-11-09','2022-11-09 07:32:35','2022-11-10 07:32:35','513',0.00,0.00,'513','2022-11-09 07:36:47','513','2022-11-09 07:37:08',10,0),('1','136',257910,'NEW SHIFT','2022-11-09','2022-11-09 08:42:48','2022-11-10 08:42:48','513',0.00,0.00,'513','2022-11-09 18:39:12','513','2022-11-09 18:39:47',10,0),('1','136',257911,'DAILY SHIFT','2022-11-10','2022-11-10 07:07:05','2022-11-11 07:07:05','513',0.00,0.00,'513','2022-11-10 18:43:34','513','2022-11-10 18:44:51',10,0),('1','136',257912,'DAILY SHIFT','2022-11-11','2022-11-11 06:39:36','2022-11-12 06:39:36','513',0.00,0.00,'513','2022-11-11 18:30:56','513','2022-11-11 18:31:22',10,0),('1','136',257913,'DAILY SHIFT','2022-11-12','2022-11-12 07:07:23','2022-11-13 07:07:23','513',0.00,0.00,'513','2022-11-12 16:12:11','513','2022-11-12 16:12:33',10,0),('1','136',257914,'OPERATIONAL LOSS','2022-11-12','2022-11-12 16:13:15','2022-11-13 16:13:15','513',0.00,0.00,'513','2022-11-12 16:25:03','513','2022-11-12 16:25:36',10,0),('1','136',257915,'OPERATIONAL LOSS ','2022-11-12','2022-11-12 16:29:39','2022-11-13 16:29:39','513',0.00,0.00,'513','2022-11-12 16:40:51','513','2022-11-12 16:41:28',10,0),('1','136',257916,'NEW SHIFT','2022-11-12','2022-11-12 16:50:45','2022-11-13 16:50:45','513',0.00,0.00,'513','2022-11-12 18:35:25','513','2022-11-12 18:35:56',10,0),('1','136',257917,'DAILY SHIFT','2022-11-13','2022-11-13 07:03:49','2022-11-14 07:03:49','513',0.00,0.00,'513','2022-11-13 18:31:43','513','2022-11-13 18:32:14',10,0),('1','136',257918,'DAILY SHIFT','2022-11-14','2022-11-14 06:49:35','2022-11-15 06:49:35','513',0.00,0.00,'513','2022-11-14 18:40:42','513','2022-11-14 18:42:01',10,0),('1','136',257919,'DAILY SHIFT','2022-11-15','2022-11-15 07:00:35','2022-11-16 07:00:35','513',0.00,0.00,'513','2022-11-15 18:48:04','513','2022-11-15 18:48:40',10,0),('1','136',257920,'DAILY SHIFT','2022-11-16','2022-11-16 07:02:16','2022-11-17 07:02:16','513',0.00,0.00,'513','2022-11-16 09:34:05','513','2022-11-16 09:34:31',10,0),('1','136',257921,'OPERATIONAL LOSS','2022-11-16','2022-11-16 09:35:00','2022-11-17 09:35:00','513',0.00,0.00,'513','2022-11-16 09:44:34','513','2022-11-16 09:44:57',10,0),('1','136',257922,'NEW SHIFT','2022-11-16','2022-11-16 10:58:10','2022-11-17 10:58:10','513',0.00,0.00,'513','2022-11-16 18:34:36','513','2022-11-16 18:35:25',10,0),('1','136',257923,'DAILY SHIFT','2022-11-17','2022-11-17 06:34:32','2022-11-18 06:34:32','513',0.00,0.00,'513','2022-11-17 18:40:32','513','2022-11-17 18:41:03',10,0),('1','136',257924,'DAILY SHIFT','2022-11-18','2022-11-18 06:29:29','2022-11-19 06:29:29','513',0.00,0.00,'513','2022-11-19 06:15:34','513','2022-11-19 06:16:41',10,0),('1','136',257925,'DAILY SHIFT','2022-11-19','2022-11-19 06:18:29','2022-11-20 06:18:29','513',0.00,0.00,'513','2022-11-19 18:52:04','513','2022-11-19 18:52:44',10,0),('1','136',257926,'DAILY SHIFT','2022-11-20','2022-11-20 06:53:30','2022-11-21 06:53:30','513',0.00,0.00,'513','2022-11-20 18:31:07','513','2022-11-20 18:32:16',10,0),('1','136',257927,'DAILY SHIFT','2022-11-21','2022-11-21 06:41:00','2022-11-22 06:41:00','513',0.00,0.00,'513','2022-11-21 18:43:34','513','2022-11-21 18:44:30',10,0),('1','136',257928,'DAILY SHIFT ','2022-11-22','2022-11-22 06:42:47','2022-11-23 06:42:47','513',0.00,0.00,'513','2022-11-22 18:21:20','513','2022-11-22 18:21:53',10,0),('1','136',257929,'DAILY SHIT','2022-11-23','2022-11-23 06:26:56','2022-11-24 06:26:56','513',0.00,0.00,'513','2022-11-23 18:47:57','513','2022-11-23 18:48:43',10,0),('1','136',257930,'DAILY SHIFT','2022-11-24','2022-11-24 06:34:42','2022-11-25 06:34:42','513',0.00,0.00,'513','2022-11-24 18:34:41','513','2022-11-24 18:35:07',10,0),('1','136',257931,'DAILY SHIFT','2022-11-25','2022-11-25 06:31:09','2022-11-26 06:31:09','513',0.00,0.00,'513','2022-11-25 18:55:44','513','2022-11-25 18:56:20',10,0),('1','136',257932,'DAILY AsHIFT','2022-11-26','2022-11-26 06:21:07','2022-11-27 06:21:07','513',0.00,0.00,'513','2022-11-26 19:09:08','513','2022-11-26 19:09:39',10,0),('1','136',257933,'DAILY SHIFT','2022-11-27','2022-11-27 06:29:05','2022-11-28 06:29:05','513',0.00,0.00,'513','2022-11-27 15:22:28','513','2022-11-27 15:24:16',10,0),('1','136',257934,'OPERATIONAL LOSS','2022-11-27','2022-11-27 15:24:49','2022-11-28 15:24:49','513',0.00,0.00,'513','2022-11-27 15:28:11','513','2022-11-27 15:28:35',10,0),('1','136',257935,'NEW SHIFT','2022-11-27','2022-11-27 15:34:47','2022-11-28 15:34:47','513',0.00,0.00,'513','2022-11-27 19:11:03','513','2022-11-27 19:11:32',10,0),('1','136',257936,'DAILY SHIFT','2022-11-28','2022-11-28 06:11:09','2022-11-29 06:11:09','513',0.00,0.00,'513','2022-11-28 18:53:42','513','2022-11-28 18:55:13',10,0),('1','136',257937,'DAILY SHIFT','2022-11-29','2022-11-29 06:25:28','2022-11-30 06:25:28','513',0.00,0.00,'513','2022-11-29 18:42:39','513','2022-11-29 18:43:10',10,0),('1','136',257938,'DAILY SHIFT','2022-11-30','2022-11-30 06:11:43','2022-12-01 06:11:43','513',0.00,0.00,'513','2022-11-30 19:03:36','513','2022-11-30 19:04:08',10,0),('1','136',257939,'DAILY SHIFT','2022-12-01','2022-12-01 06:29:05','2022-12-02 06:29:05','513',0.00,0.00,'513','2022-12-01 19:04:51','513','2022-12-01 19:05:21',10,0),('1','136',257940,'DAILY SHIFT','2022-12-02','2022-12-02 06:14:57','2022-12-03 06:14:57','513',0.00,0.00,'513','2022-12-02 18:44:33','513','2022-12-02 18:45:04',10,0),('1','136',257941,'DAILY SHIFT','2022-12-03','2022-12-03 05:57:00','2022-12-04 05:57:00','513',0.00,0.00,'513','2022-12-03 19:05:25','513','2022-12-03 19:06:14',10,0),('1','136',257942,'DAILY SHIFT','2022-12-04','2022-12-04 06:05:20','2022-12-05 06:05:20','513',0.00,0.00,'513','2022-12-04 18:51:34','513','2022-12-04 18:52:34',10,0),('1','136',257943,'DAILY SHIFT','2022-12-05','2022-12-05 06:03:58','2022-12-06 06:03:58','513',0.00,0.00,'513','2022-12-05 18:58:52','513','2022-12-05 18:59:59',10,0),('1','136',257944,'DAILY SHIFT','2022-12-06','2022-12-06 05:52:45','2022-12-07 05:52:45','513',0.00,0.00,'513','2022-12-06 13:53:06','513','2022-12-06 13:54:45',10,0),('1','136',257945,'OPERATIONAL LOSS','2022-12-06','2022-12-06 14:02:36','2022-12-07 14:02:36','513',0.00,0.00,'513','2022-12-06 14:47:26','513','2022-12-06 14:47:51',10,0),('1','136',257946,'NEW SHIFT','2022-12-06','2022-12-06 14:48:25','2022-12-07 14:48:25','513',0.00,0.00,'513','2022-12-06 19:00:29','513','2022-12-06 19:01:00',10,0),('1','136',257947,'DAILY SHIFT','2022-12-07','2022-12-07 06:22:21','2022-12-08 06:22:21','513',0.00,0.00,'513','2022-12-07 18:55:07','513','2022-12-07 18:55:35',10,0),('1','136',257948,'DAILY SHIFT','2022-12-08','2022-12-08 06:34:40','2022-12-09 06:34:40','513',0.00,0.00,'513','2022-12-08 16:49:34','513','2022-12-08 16:49:57',10,0),('1','136',257949,'DAILY SHIFT','2022-12-09','2022-12-09 06:46:26','2022-12-10 06:46:26','513',0.00,0.00,'513','2022-12-09 08:31:50','513','2022-12-09 08:32:15',10,0),('1','136',257950,'OPERATIONAL LOSS','2022-12-09','2022-12-09 08:32:48','2022-12-10 08:32:48','513',0.00,0.00,'513','2022-12-09 08:54:23','513','2022-12-09 08:55:19',10,0),('1','136',257951,'NEW SHIFT ','2022-12-09','2022-12-09 09:30:46','2022-12-10 09:30:46','513',0.00,0.00,'513','2022-12-09 18:56:26','513','2022-12-09 18:57:03',10,0),('1','136',257952,'DAILY SHIFT','2022-12-10','2022-12-10 05:53:40','2022-12-11 05:53:40','513',0.00,0.00,'513','2022-12-10 17:25:21','513','2022-12-10 17:26:06',10,0),('1','136',257953,'DAILY SHIFT','2022-12-11','2022-12-11 06:46:03','2022-12-12 06:46:03','513',0.00,0.00,'513','2022-12-11 11:11:17','513','2022-12-11 11:12:37',10,0),('1','136',257954,'OPERATIONAL LOSS ','2022-12-11','2022-12-11 11:13:50','2022-12-12 11:13:50','513',0.00,0.00,'513','2022-12-11 11:19:10','513','2022-12-11 11:19:33',10,0),('1','136',257955,'NEW SHIFT','2022-12-11','2022-12-11 11:21:12','2022-12-12 11:21:12','513',0.00,0.00,'513','2022-12-11 18:34:52','513','2022-12-11 18:35:19',10,0),('1','136',257956,'DAILY SHIFT','2022-12-12','2022-12-12 06:25:21','2022-12-13 06:25:21','513',0.00,0.00,'513','2022-12-12 18:50:20','513','2022-12-12 18:50:41',10,0),('1','136',257957,'DAILY SHIFT','2022-12-13','2022-12-13 06:56:44','2022-12-14 06:56:44','513',0.00,0.00,'513','2022-12-13 18:52:04','513','2022-12-13 18:52:32',10,0),('1','136',257958,'DAILY SHIFT','2022-12-14','2022-12-14 05:51:58','2022-12-15 05:51:58','513',0.00,0.00,'513','2022-12-14 18:58:20','513','2022-12-14 18:58:41',10,0),('1','136',257959,'DAILY SHIFT','2022-12-15','2022-12-15 05:59:12','2022-12-16 05:59:12','513',0.00,0.00,'513','2022-12-15 18:57:08','513','2022-12-15 18:57:27',10,0),('1','136',257960,'DAILY SHIFT','2022-12-16','2022-12-16 05:51:55','2022-12-17 05:51:55','513',0.00,0.00,'513','2022-12-16 18:57:02','513','2022-12-16 18:57:40',10,0),('1','136',257961,'DAILY SHIFT','2022-12-17','2022-12-17 06:34:02','2022-12-18 06:34:02','513',0.00,0.00,'513','2022-12-17 19:00:25','513','2022-12-17 19:00:51',10,0),('1','136',257962,'DAILY SHIFT','2022-12-18','2022-12-18 05:21:56','2022-12-19 05:21:56','513',0.00,0.00,'513','2022-12-18 18:48:23','513','2022-12-18 18:48:50',10,0),('1','136',257963,'DAILY SHIFT','2022-12-19','2022-12-19 06:23:31','2022-12-20 06:23:31','513',0.00,0.00,'513','2022-12-19 10:24:24','513','2022-12-19 10:24:47',10,0),('1','136',257964,'OPERATIONAL LOSS','2022-12-19','2022-12-19 10:25:36','2022-12-20 10:25:36','513',0.00,0.00,'513','2022-12-19 10:26:04','513','2022-12-19 10:26:27',10,0),('1','136',257965,'NEW SHIFT','2022-12-19','2022-12-19 10:26:55','2022-12-20 10:26:55','513',0.00,0.00,'513','2022-12-19 19:08:48','513','2022-12-19 19:09:08',10,0),('1','136',257966,'DAILY SHIFT','2022-12-20','2022-12-20 05:55:29','2022-12-21 05:55:29','513',0.00,0.00,'513','2022-12-20 17:45:20','513','2022-12-20 17:45:56',10,0),('1','136',257967,'DAILY SHIFT','2022-12-21','2022-12-21 06:06:54','2022-12-22 06:06:54','513',0.00,0.00,'513','2022-12-21 10:09:04','513','2022-12-21 10:09:49',10,0),('1','136',257968,'OPERATIONAL LOSS','2022-12-21','2022-12-21 10:10:40','2022-12-22 10:10:40','513',0.00,0.00,'513','2022-12-21 10:14:02','513','2022-12-21 10:14:25',10,0),('1','136',257969,'NEW SHIFT','2022-12-21','2022-12-21 10:25:22','2022-12-22 10:25:22','513',0.00,0.00,'513','2022-12-21 19:00:48','513','2022-12-21 19:01:25',10,0),('1','136',257970,'DAILY SHIFT','2022-12-22','2022-12-22 05:48:17','2022-12-23 05:48:17','513',0.00,0.00,'513','2022-12-22 18:53:09','513','2022-12-22 18:53:36',10,0),('1','136',257971,'DAILY SHIFT','2022-12-23','2022-12-23 06:25:46','2022-12-24 06:25:46','513',0.00,0.00,'513','2022-12-23 19:23:50','513','2022-12-23 19:24:19',10,0),('1','136',257972,'DAILY SHIFT','2022-12-24','2022-12-24 05:40:06','2022-12-25 05:40:06','513',0.00,0.00,'513','2022-12-24 19:25:50','513','2022-12-24 19:26:22',10,0),('1','136',257973,'DAILY SHIFT','2022-12-25','2022-12-25 05:54:05','2022-12-26 05:54:05','513',0.00,0.00,'513','2022-12-25 18:48:44','513','2022-12-25 18:49:08',10,0),('1','136',257974,'DAILY SHIFT','2022-12-26','2022-12-26 05:57:18','2022-12-27 05:57:18','513',0.00,0.00,'513','2022-12-26 18:24:55','513','2022-12-26 18:25:18',10,0),('1','136',257975,'DAILY SHIFT','2022-12-27','2022-12-27 05:59:12','2022-12-28 05:59:12','513',0.00,0.00,'513','2022-12-27 09:15:43','513','2022-12-27 09:16:04',10,0),('1','136',257976,'OPERATIONAL LOSS ','2022-12-27','2022-12-27 09:17:07','2022-12-28 09:17:07','513',0.00,0.00,'513','2022-12-27 09:20:58','513','2022-12-27 09:21:20',10,0),('1','136',257977,'NEW SHIFT ','2022-12-27','2022-12-27 09:49:00','2022-12-28 09:49:00','513',0.00,0.00,'513','2022-12-27 19:44:03','513','2022-12-27 19:44:36',10,0),('1','136',257978,'DAILY SHIFT','2022-12-28','2022-12-28 05:59:26','2022-12-29 05:59:26','513',0.00,0.00,'513','2022-12-28 18:36:28','513','2022-12-28 18:36:52',10,0),('1','136',257979,'DAILY SHIFT','2022-12-29','2022-12-29 05:57:40','2022-12-30 05:57:40','513',0.00,0.00,'513','2022-12-29 19:53:32','513','2022-12-29 19:53:56',10,0),('1','136',257980,'DAILY SHIFT','2022-12-30','2022-12-30 06:12:45','2022-12-31 06:12:45','513',0.00,0.00,'513','2022-12-30 19:21:36','513','2022-12-30 19:22:00',10,0),('1','136',257981,'DAILY SHIFT','2022-12-31','2022-12-31 06:40:08','2023-01-01 06:40:08','513',0.00,0.00,'513','2022-12-31 19:39:20','513','2022-12-31 19:40:12',10,0),('1','136',257982,'DAILY SHIFT','2023-01-01','2023-01-01 06:24:34','2023-01-02 06:24:34','513',0.00,0.00,'513','2023-01-01 19:40:57','513','2023-01-01 19:41:22',10,0),('1','136',257983,'DAILY SHIFT','2023-01-02','2023-01-02 06:15:06','2023-01-03 06:15:06','513',0.00,0.00,'513','2023-01-02 19:13:47','513','2023-01-02 19:14:18',10,0),('1','136',257984,'DAILY SHIFT','2023-01-03','2023-01-03 06:14:41','2023-01-04 06:14:41','513',0.00,0.00,'513','2023-01-03 20:07:54','513','2023-01-03 20:08:18',10,0),('1','136',257985,'DAILY SHIFT','2023-01-04','2023-01-04 06:21:32','2023-01-05 06:21:32','513',0.00,0.00,'513','2023-01-04 19:08:27','513','2023-01-04 19:08:52',10,0),('1','136',257986,'DAILY SHIFT','2023-01-05','2023-01-05 07:30:25','2023-01-06 07:30:25','513',0.00,0.00,'513','2023-01-05 14:46:36','513','2023-01-05 14:51:58',10,0),('1','136',257987,'OPERATIONAL  LOSS ','2023-01-05','2023-01-05 14:53:04','2023-01-06 14:53:04','513',0.00,0.00,'513','2023-01-05 14:59:31','513','2023-01-05 14:59:58',10,0),('1','136',257988,'NEW SHIFT','2023-01-05','2023-01-05 15:17:04','2023-01-06 15:17:04','513',0.00,0.00,'513','2023-01-05 19:42:58','513','2023-01-05 19:43:20',10,0),('1','136',257989,'DAILY SHIFT','2023-01-06','2023-01-06 06:20:52','2023-01-07 06:20:52','513',0.00,0.00,'513','2023-01-06 19:31:01','513','2023-01-06 19:31:29',10,0),('1','136',257990,'DAILY SHIFT','2023-01-07','2023-01-07 06:32:15','2023-01-08 06:32:15','513',0.00,0.00,'513','2023-01-07 20:14:27','513','2023-01-07 20:14:54',10,0),('1','136',257991,'DAILY SHIFT','2023-01-08','2023-01-08 06:21:52','2023-01-09 06:21:52','513',0.00,0.00,'513','2023-01-08 19:42:05','513','2023-01-08 19:42:33',10,0),('1','136',257992,'DAILY SHIFT','2023-01-09','2023-01-09 06:23:06','2023-01-10 06:23:06','513',0.00,0.00,'513','2023-01-09 19:50:58','513','2023-01-09 19:51:23',10,0),('1','136',257993,'DAILY SHIFT','2023-01-10','2023-01-10 06:32:58','2023-01-11 06:32:58','513',0.00,0.00,'513','2023-01-10 19:42:29','513','2023-01-10 19:43:10',10,0),('1','136',257994,'DAILY SHIFT','2023-01-11','2023-01-11 06:40:01','2023-01-12 06:40:01','513',0.00,0.00,'513','2023-01-11 19:49:57','513','2023-01-11 19:50:44',10,0),('1','136',257995,'DAILY SHIFT','2023-01-12','2023-01-12 06:25:29','2023-01-13 06:25:29','513',0.00,0.00,'513','2023-01-12 19:27:44','513','2023-01-12 19:28:23',10,0),('1','136',257996,'DAILY SHIFT','2023-01-13','2023-01-13 06:43:20','2023-01-14 06:43:20','513',0.00,0.00,'513','2023-01-13 19:39:22','513','2023-01-13 19:39:47',10,0),('1','136',257997,'DAILY SHIFT','2023-01-14','2023-01-14 06:34:39','2023-01-15 06:34:39','513',0.00,0.00,'513','2023-01-14 19:50:34','513','2023-01-14 19:50:57',10,0),('1','136',257998,'DAILY SHIFT','2023-01-15','2023-01-15 05:12:43','2023-01-16 05:12:43','513',0.00,0.00,'513','2023-01-15 19:23:35','513','2023-01-15 19:23:59',10,0),('1','136',257999,'DAILY SHIFT','2023-01-16','2023-01-16 06:25:03','2023-01-17 06:25:03','513',0.00,0.00,'513','2023-01-16 19:53:57','513','2023-01-16 19:54:26',10,0),('1','136',258000,'DAILY SHIFT','2023-01-17','2023-01-17 06:11:45','2023-01-18 06:11:45','513',0.00,0.00,'513','2023-01-17 19:44:24','513','2023-01-17 19:45:05',10,0),('1','136',258001,'DAILY SHIFT','2023-01-18','2023-01-18 06:39:59','2023-01-19 06:39:59','513',0.00,0.00,'513','2023-01-18 13:49:44','513','2023-01-18 13:50:15',10,0),('1','136',258002,'OPERATIONAL LOSS','2023-01-18','2023-01-18 13:51:08','2023-01-19 13:51:08','513',0.00,0.00,'513','2023-01-18 14:04:41','513','2023-01-18 14:05:08',10,0),('1','136',258003,'NEW SHIFT','2023-01-18','2023-01-18 14:05:34','2023-01-19 14:05:34','513',0.00,0.00,'513','2023-01-18 19:41:17','513','2023-01-18 19:42:05',10,0),('1','136',258004,'DAILY SHIFT','2023-01-19','2023-01-19 06:56:59','2023-01-20 06:56:59','513',0.00,0.00,'513','2023-01-19 19:44:46','513','2023-01-19 19:46:10',10,0),('1','136',258005,'DAILY SHIFT','2023-01-20','2023-01-20 06:13:06','2023-01-21 06:13:06','513',0.00,0.00,'513','2023-01-20 19:07:34','513','2023-01-20 19:08:19',10,0),('1','136',258006,'DAILY SHIFT','2023-01-21','2023-01-21 07:01:27','2023-01-22 07:01:27','513',0.00,0.00,'513','2023-01-21 19:51:43','513','2023-01-21 19:52:51',10,0),('1','136',258007,'DAILY SHIFT','2023-01-22','2023-01-22 06:18:10','2023-01-23 06:18:10','513',0.00,0.00,'513','2023-01-22 19:30:22','513','2023-01-22 19:30:51',10,0),('1','136',258008,'DAILY SHIFT','2023-01-23','2023-01-23 06:20:41','2023-01-24 06:20:41','513',0.00,0.00,'513','2023-01-23 19:52:17','513','2023-01-23 19:53:04',10,0),('1','136',258009,'DAILY SHIFT','2023-01-24','2023-01-24 06:35:31','2023-01-25 06:35:31','513',0.00,0.00,'513','2023-01-24 19:46:19','513','2023-01-24 19:46:49',10,0),('1','136',258010,'DAILY SHIFT','2023-01-25','2023-01-25 06:19:04','2023-01-26 06:19:04','513',0.00,0.00,'513','2023-01-25 19:52:07','513','2023-01-25 19:52:36',10,0),('1','136',258011,'DAILY SHIFT','2023-01-26','2023-01-26 06:19:18','2023-01-27 06:19:18','513',0.00,0.00,'513','2023-01-26 20:06:20','513','2023-01-26 20:06:58',10,0),('1','136',258012,'DAILY SHIFT','2023-01-27','2023-01-27 06:00:48','2023-01-28 06:00:48','513',0.00,0.00,'513','2023-01-27 20:06:38','513','2023-01-27 20:07:05',10,0),('1','136',258013,'DAILY SHIFT','2023-01-28','2023-01-28 06:10:52','2023-01-29 06:10:52','513',0.00,0.00,'513','2023-01-28 20:09:47','513','2023-01-28 20:10:23',10,0),('1','136',258014,'DAILY SHIFT','2023-01-29','2023-01-29 06:20:37','2023-01-30 06:20:37','513',0.00,0.00,'513','2023-01-29 19:43:21','513','2023-01-29 19:44:14',10,0),('1','136',258015,'DAILY SHIFT','2023-01-30','2023-01-30 06:29:56','2023-01-31 06:29:56','513',0.00,0.00,'513','2023-01-30 20:01:34','513','2023-01-30 20:02:06',10,0),('1','136',258016,'DAILY SHIFT','2023-01-31','2023-01-31 05:48:22','2023-02-01 05:48:22','513',0.00,0.00,'513','2023-01-31 19:55:56','513','2023-01-31 19:56:31',10,0),('1','136',258017,'DAILY SHIFT','2023-02-01','2023-02-01 06:20:51','2023-02-02 06:20:51','513',0.00,0.00,'513','2023-02-01 19:38:40','513','2023-02-01 19:39:29',10,0),('1','136',258018,'DAILY SHIFT','2023-02-02','2023-02-02 06:07:24','2023-02-03 06:07:24','513',0.00,0.00,'513','2023-02-02 19:37:13','513','2023-02-02 19:38:13',10,0),('1','136',258019,'DAILY SHIFT','2023-02-03','2023-02-03 06:26:17','2023-02-04 06:26:17','513',0.00,0.00,'513','2023-02-03 17:30:43','513','2023-02-03 17:31:22',10,0),('1','136',258020,'OPERATIONAL LOSS','2023-02-03','2023-02-03 17:34:10','2023-02-04 17:34:10','513',0.00,0.00,'513','2023-02-03 17:46:37','513','2023-02-03 17:47:11',10,0),('1','136',258021,'NEW SHIFT ','2023-02-03','2023-02-03 17:47:50','2023-02-04 17:47:50','513',0.00,0.00,'513','2023-02-03 19:29:58','513','2023-02-03 19:30:38',10,0),('1','136',258022,'DAILY SHIFT','2023-02-04','2023-02-04 06:04:02','2023-02-05 06:04:02','513',0.00,0.00,'513','2023-02-04 20:14:04','513','2023-02-04 20:15:04',10,0),('1','136',258023,'DAILY SHIFT','2023-02-05','2023-02-05 06:10:53','2023-02-06 06:10:53','513',0.00,0.00,'513','2023-02-05 20:04:36','513','2023-02-05 20:05:08',10,0),('1','136',258024,'DAILY SHIFT','2023-02-06','2023-02-06 06:06:07','2023-02-07 06:06:07','513',0.00,0.00,'513','2023-02-06 20:35:37','513','2023-02-06 20:36:02',10,0),('1','136',258025,'DAILY SHIFT','2023-02-07','2023-02-07 05:59:43','2023-02-08 05:59:43','513',0.00,0.00,'513','2023-02-07 20:03:40','513','2023-02-07 20:04:25',10,0),('1','136',258026,'DAILY SHIFT','2023-02-08','2023-02-08 06:14:16','2023-02-09 06:14:16','513',0.00,0.00,'513','2023-02-08 19:53:46','513','2023-02-08 19:54:08',10,0),('1','136',258027,'DAILY SHIFT','2023-02-09','2023-02-09 06:05:32','2023-02-10 06:05:32','513',0.00,0.00,'513','2023-02-09 19:59:19','513','2023-02-09 19:59:51',10,0),('1','136',258028,'DAILY SHIFT','2023-02-10','2023-02-10 06:23:47','2023-02-11 06:23:47','513',0.00,0.00,'513','2023-02-10 19:44:41','513','2023-02-10 19:45:24',10,0),('1','136',258029,'DAILY SHIFT','2023-02-11','2023-02-11 06:43:26','2023-02-12 06:43:26','513',0.00,0.00,'513','2023-02-11 20:15:59','513','2023-02-11 20:16:46',10,0),('1','136',258030,'DAILY SHIFT','2023-02-12','2023-02-12 06:25:42','2023-02-13 06:25:42','513',0.00,0.00,'513','2023-02-12 19:17:06','513','2023-02-12 19:17:42',10,0),('1','136',258031,'DAILY SHIFT','2023-02-13','2023-02-13 06:14:24','2023-02-14 06:14:24','513',0.00,0.00,'513','2023-02-13 19:54:00','513','2023-02-13 19:55:10',10,0),('1','136',258032,'DAILY SHIFT','2023-02-14','2023-02-14 06:24:11','2023-02-15 06:24:11','513',0.00,0.00,'513','2023-02-14 20:13:39','513','2023-02-14 20:14:20',10,0),('1','136',258033,'DAILY SHIFT','2023-02-15','2023-02-15 06:52:11','2023-02-16 06:52:11','513',0.00,0.00,'513','2023-02-15 20:07:58','513','2023-02-15 20:08:38',10,0),('1','136',258034,'DAILY SHIFT','2023-02-16','2023-02-16 06:18:27','2023-02-17 06:18:27','513',0.00,0.00,'513','2023-02-16 20:38:02','513','2023-02-16 20:39:07',10,0),('1','136',258035,'DAILY SHIFT','2023-02-17','2023-02-17 06:35:41','2023-02-18 06:35:41','513',0.00,0.00,'513','2023-02-17 19:58:12','513','2023-02-17 19:58:41',10,0),('1','136',258036,'DAILY SHIFT','2023-02-18','2023-02-18 06:29:35','2023-02-19 06:29:35','513',0.00,0.00,'513','2023-02-18 20:10:38','513','2023-02-18 20:11:21',10,0),('1','136',258037,'DAILY SHIFT','2023-02-19','2023-02-19 05:46:15','2023-02-20 05:46:15','513',0.00,0.00,'513','2023-02-19 13:44:11','513','2023-02-19 13:44:44',10,0),('1','136',258038,'OPERATIONAL LOSS','2023-02-19','2023-02-19 13:45:43','2023-02-20 13:45:43','513',0.00,0.00,'513','2023-02-19 13:50:56','513','2023-02-19 13:51:30',10,0),('1','136',258039,'DAILY SHIFT','2023-02-19','2023-02-19 13:51:53','2023-02-20 13:51:53','513',0.00,0.00,'513','2023-02-19 19:57:44','513','2023-02-19 19:58:02',10,0),('1','136',258040,'DAILY SHIFT','2023-02-20','2023-02-20 06:51:20','2023-02-21 06:51:20','513',0.00,0.00,'513','2023-02-20 20:42:32','513','2023-02-20 20:42:56',10,0),('1','136',258041,'DAILY SHIFT','2023-02-21','2023-02-21 05:36:33','2023-02-22 05:36:33','513',0.00,0.00,'513','2023-02-21 20:30:35','513','2023-02-21 20:34:22',10,0),('1','136',258042,'DAILY SHIFT','2023-02-22','2023-02-22 05:24:12','2023-02-23 05:24:12','513',0.00,0.00,'513','2023-02-22 20:59:29','513','2023-02-22 21:07:48',10,0),('1','136',258043,'DAILY SHIFT','2023-02-23','2023-02-23 06:15:12','2023-02-24 06:15:12','513',0.00,0.00,'513','2023-02-23 20:20:18','513','2023-02-23 20:20:44',10,0),('1','136',258044,'DAILY SHIFT','2023-02-24','2023-02-24 05:59:06','2023-02-25 05:59:06','513',0.00,0.00,'513','2023-02-24 19:41:09','513','2023-02-24 19:41:43',10,0),('1','136',258045,'DAILY SHIFT','2023-02-26','2023-02-26 06:08:51','2023-02-27 06:08:51','513',0.00,0.00,'513','2023-02-26 15:07:18','513','2023-02-26 15:08:10',10,0),('1','136',258046,'OPERATIONAL LOSS ','2023-02-26','2023-02-26 15:09:14','2023-02-27 15:09:14','513',0.00,0.00,'513','2023-02-26 15:13:52','513','2023-02-26 15:14:15',10,0),('1','136',258047,'NEW SHIFT ','2023-02-26','2023-02-26 15:35:23','2023-02-27 15:35:23','513',0.00,0.00,'513','2023-02-26 18:52:10','513','2023-02-26 18:54:32',10,0),('1','136',258048,'DAILY SHIFT','2023-02-27','2023-02-27 06:26:46','2023-02-28 06:26:46','513',0.00,0.00,'513','2023-02-27 19:46:48','513','2023-02-27 19:47:32',10,0),('1','136',258049,'DAILY SHIFT','2023-02-28','2023-02-28 05:53:38','2023-03-01 05:53:38','513',0.00,0.00,'513','2023-02-28 19:47:47','513','2023-02-28 19:48:25',10,0),('1','136',258050,'DAILY SHIFT','2023-03-01','2023-03-01 05:38:57','2023-03-02 05:38:57','513',0.00,0.00,'513','2023-03-01 19:44:57','513','2023-03-01 19:45:33',10,0),('1','136',258051,'DAILY SHIFT','2023-03-02','2023-03-02 06:04:20','2023-03-03 06:04:20','513',0.00,0.00,'513','2023-03-02 19:37:53','513','2023-03-02 19:38:32',10,0),('1','136',258052,'DAILY SHIFT','2023-03-03','2023-03-03 06:11:03','2023-03-04 06:11:03','513',0.00,0.00,'513','2023-03-03 19:59:07','513','2023-03-03 19:59:47',10,0),('1','136',258053,'DAILY SHIFT','2023-03-04','2023-03-04 06:16:29','2023-03-05 06:16:29','513',0.00,0.00,'513','2023-03-04 11:50:52','513','2023-03-04 11:51:23',10,0),('1','136',258054,'OPERATIONAL LOSS ','2023-03-04','2023-03-04 11:52:01','2023-03-05 11:52:01','513',0.00,0.00,'513','2023-03-04 11:58:23','513','2023-03-04 11:58:42',10,0),('1','136',258055,'NEW SHIFT ','2023-03-04','2023-03-04 12:57:42','2023-03-05 12:57:42','513',0.00,0.00,'513','2023-03-04 19:34:50','513','2023-03-04 19:35:23',10,0),('1','136',258056,'DAILY SHIFT','2023-03-05','2023-03-05 06:15:14','2023-03-06 06:15:14','513',0.00,0.00,'513','2023-03-05 16:55:57','513','2023-03-05 16:56:55',10,0),('1','136',258057,'OPERATIONAL LOSS ','2023-03-05','2023-03-05 16:57:36','2023-03-06 16:57:36','513',0.00,0.00,'513','2023-03-05 17:00:44','513','2023-03-05 17:01:12',10,0),('1','136',258058,'NEW SHIFT','2023-03-05','2023-03-05 17:08:02','2023-03-06 17:08:02','513',0.00,0.00,'513','2023-03-05 20:05:01','513','2023-03-05 20:05:33',10,0),('1','136',258059,'DAILY SHIFT','2023-03-06','2023-03-06 06:10:36','2023-03-07 06:10:36','513',0.00,0.00,'513','2023-03-06 20:31:23','513','2023-03-06 20:31:46',10,0),('1','136',258060,'DAILY SHIFT','2023-03-07','2023-03-07 06:06:32','2023-03-08 06:06:32','513',0.00,0.00,'513','2023-03-07 19:55:04','513','2023-03-07 19:56:15',10,0),('1','136',258061,'DAILY SHIFT','2023-03-08','2023-03-08 06:35:08','2023-03-09 06:35:08','513',0.00,0.00,'513','2023-03-08 11:26:41','513','2023-03-08 11:27:03',10,0),('1','136',258062,'DAILY SHIFT','2023-03-08','2023-03-08 11:27:42','2023-03-09 11:27:42','513',0.00,0.00,'513','2023-03-08 20:18:39','513','2023-03-08 20:19:16',10,0),('1','136',258063,'DAILY SHIFT','2023-03-09','2023-03-09 06:56:25','2023-03-10 06:56:25','513',0.00,0.00,'513','2023-03-09 20:10:06','513','2023-03-09 20:10:27',10,0),('1','136',258064,'DAILY SHIFT','2023-03-10','2023-03-10 06:59:41','2023-03-11 06:59:41','513',0.00,0.00,'513','2023-03-10 18:05:51','513','2023-03-10 18:08:29',10,0),('1','136',258065,'NEW SHIFT','2023-03-10','2023-03-10 18:13:37','2023-03-11 18:13:37','513',0.00,0.00,'513','2023-03-10 20:09:35','513','2023-03-10 20:10:05',10,0),('1','136',258066,'DAILY SHIFT','2023-03-11','2023-03-11 08:42:36','2023-03-12 08:42:36','513',0.00,0.00,'513','2023-03-11 20:27:57','513','2023-03-11 20:28:40',10,0),('1','136',258067,'DAILY SHIFT','2023-03-12','2023-03-12 05:52:16','2023-03-13 05:52:16','513',0.00,0.00,'513','2023-03-12 19:50:28','513','2023-03-12 19:50:53',10,0),('1','136',258068,'DAILY SHIFT','2023-03-13','2023-03-13 06:25:57','2023-03-14 06:25:57','513',0.00,0.00,'513','2023-03-13 19:47:54','513','2023-03-13 19:48:18',10,0),('1','136',258069,'DAILY SHIFT','2023-03-14','2023-03-14 06:07:27','2023-03-15 06:07:27','513',0.00,0.00,'513','2023-03-14 19:47:10','513','2023-03-14 19:47:42',10,0),('1','136',258070,'DAILY SHIFT','2023-03-15','2023-03-15 05:58:51','2023-03-16 05:58:51','513',0.00,0.00,'513','2023-03-15 15:37:02','513','2023-03-15 15:37:36',10,0),('1','136',258071,'NEW SHIFT','2023-03-15','2023-03-15 15:41:30','2023-03-16 15:41:30','513',0.00,0.00,'513','2023-03-15 20:14:12','513','2023-03-15 20:15:21',10,0),('1','136',258072,'DAILY SHIFT','2023-03-16','2023-03-16 06:10:36','2023-03-17 06:10:36','513',0.00,0.00,'513','2023-03-17 06:06:10','513','2023-03-17 06:06:31',10,0),('1','136',258073,'DAILY SHIFT ','2023-03-17','2023-03-17 06:07:10','2023-03-18 06:07:10','513',0.00,0.00,'513','2023-03-17 19:27:40','513','2023-03-17 19:28:08',10,0),('1','136',258074,'DAILY SHIFT','2023-03-18','2023-03-18 07:21:08','2023-03-19 07:21:08','513',0.00,0.00,'513','2023-03-18 19:33:03','513','2023-03-18 19:33:28',10,0),('1','136',258075,'DAILY SHIFT','2023-03-19','2023-03-19 07:01:06','2023-03-20 07:01:06','513',0.00,0.00,'513','2023-03-19 19:27:57','513','2023-03-19 19:28:35',10,0),('1','136',258076,'DAILY SHIFT','2023-03-20','2023-03-20 07:07:39','2023-03-21 07:07:39','513',0.00,0.00,'513','2023-03-20 19:30:01','513','2023-03-20 19:30:31',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4904101 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','136','779','146990',2940300,'2188','334',0.00,501.40,0.00,0.00,501.40,140392.00,0.00,0.00,0.00),('1','136','779','147046',2940989,'2188','334',501.40,1229.70,0.00,0.00,728.30,203924.00,0.00,0.00,0.00),('1','136','779','147114',2941802,'2188','334',1229.70,6839.70,0.00,0.00,5610.00,1570800.00,0.00,0.00,0.00),('1','136','779','147161',2942375,'2188','334',6839.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','147179',2942555,'2188','334',6839.70,11298.00,0.00,0.00,4458.30,980644.00,0.00,0.00,0.00),('1','136','779','147191',2942741,'2188','334',11298.00,16311.00,0.00,0.00,5013.00,1142028.00,0.00,0.00,0.00),('1','136','779','147206',2942893,'2188','334',16311.00,24669.90,0.00,0.00,8358.90,1847720.00,0.00,0.00,0.00),('1','136','779','147215',2942996,'2188','334',24669.90,30343.00,0.00,0.00,5673.10,1271524.00,0.00,0.00,0.00),('1','136','779','147227',2943122,'2188','334',30343.00,35636.80,0.00,0.00,5293.80,1154150.00,0.00,0.00,0.00),('1','136','779','147242',2943356,'2188','334',35636.80,35636.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','147255',2943565,'2188','334',35636.80,37794.00,0.00,0.00,2157.20,471268.00,0.00,0.00,0.00),('1','136','779','147266',2943728,'2188','334',37794.00,45855.80,0.00,0.00,8061.80,1764860.00,0.00,0.00,0.00),('1','136','779','147277',2943864,'2188','334',45855.80,52114.90,0.00,0.00,6259.10,1387638.00,0.00,0.00,0.00),('1','136','779','147290',2943999,'2188','334',52114.90,52114.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','147376',2945495,'2188','334',52114.90,55345.40,0.00,0.00,3230.50,688816.00,0.00,0.00,0.00),('1','136','779','147397',2946002,'2188','334',55345.40,60111.80,0.00,0.00,4766.40,1047996.00,0.00,0.00,0.00),('1','136','779','147407',2946172,'2188','334',60111.80,60111.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','147408',2946173,'2188','334',60111.80,60664.80,0.00,0.00,553.00,117236.00,0.00,0.00,0.00),('1','136','779','147823',2953579,'2188','334',60664.80,67405.10,0.00,0.00,6740.30,1495268.00,0.00,0.00,0.00),('1','136','779','147826',2953615,'2188','334',67405.10,79778.00,0.00,0.00,12372.90,2698718.00,0.00,0.00,0.00),('1','136','779','147831',2953721,'2188','334',79778.00,81551.60,0.00,0.00,1773.60,248304.00,0.00,0.00,0.00),('1','136','779','147832',2953722,'2188','334',81551.60,83800.40,0.00,0.00,2248.80,500674.00,0.00,0.00,0.00),('1','136','779','147910',2955071,'2188','334',83800.40,94144.80,0.00,0.00,10344.40,2229582.00,0.00,0.00,0.00),('1','136','779','148187',2959925,'2188','334',94144.80,100326.10,0.00,0.00,6181.30,1352202.00,0.00,0.00,0.00),('1','136','779','148295',2961577,'2188','334',100326.10,105744.80,0.00,0.00,5418.70,1177934.00,0.00,0.00,0.00),('1','136','779','148381',2963171,'2188','334',105744.80,108871.80,0.00,0.00,3127.00,680076.00,0.00,0.00,0.00),('1','136','779','148608',2967150,'2188','334',108871.80,117369.30,0.00,0.00,8497.50,1840830.00,0.00,0.00,0.00),('1','136','779','148616',2967245,'2188','334',117369.30,119095.30,0.00,0.00,1726.00,381167.20,0.00,0.00,0.00),('1','136','779','148621',2967300,'2188','334',119095.30,124247.60,0.00,0.00,5152.30,1123197.20,0.00,0.00,0.00),('1','136','779','148628',2967407,'2188','334',124247.60,124752.20,0.00,0.00,504.60,121448.00,0.00,0.00,0.00),('1','136','779','148632',2967457,'2188','334',124752.20,130033.20,0.00,0.00,5281.00,1142378.00,0.00,0.00,0.00),('1','136','779','148636',2967568,'2188','334',130033.20,136080.00,0.00,0.00,6046.80,1319520.00,0.00,0.00,0.00),('1','136','779','148637',2967569,'2188','334',136080.00,136657.00,0.00,0.00,577.00,128280.00,0.00,0.00,0.00),('1','136','779','148790',2970055,'2188','334',136657.00,145113.90,0.00,0.00,8456.90,1863072.00,0.00,0.00,0.00),('1','136','779','148994',2973785,'2188','334',145113.90,153668.20,0.00,0.00,8554.30,1863834.00,0.00,0.00,0.00),('1','136','779','149104',2976142,'2188','334',153668.20,159362.40,0.00,0.00,5694.20,1232220.00,0.00,0.00,0.00),('1','136','779','149393',2981032,'2188','334',159362.40,162704.00,0.00,0.00,3341.60,728322.80,0.00,0.00,0.00),('1','136','779','149395',2981046,'2188','334',162704.00,167331.10,0.00,0.00,4627.10,1046152.00,0.00,0.00,0.00),('1','136','779','149430',2981786,'2188','334',167331.10,176762.20,0.00,0.00,9431.10,2058808.00,0.00,0.00,0.00),('1','136','779','149589',2984448,'2188','334',176762.20,182173.10,0.00,0.00,5410.90,1188892.00,0.00,0.00,0.00),('1','136','779','149593',2984518,'2188','334',182173.10,189225.10,0.00,0.00,7052.00,1526076.00,0.00,0.00,0.00),('1','136','779','149814',2988289,'2188','334',189225.10,193321.50,0.00,0.00,4096.40,929104.00,0.00,0.00,0.00),('1','136','779','149876',2989273,'2188','334',193321.50,203268.40,0.00,0.00,9946.90,2170088.00,0.00,0.00,0.00),('1','136','779','150024',2992015,'2188','334',203268.40,204827.40,0.00,0.00,1559.00,350716.00,0.00,0.00,0.00),('1','136','779','150027',2992040,'2188','334',204827.40,214255.00,0.00,0.00,9427.60,2033776.00,0.00,0.00,0.00),('1','136','779','150158',2994902,'2188','334',214255.00,225079.30,0.00,0.00,10824.30,2365226.00,0.00,0.00,0.00),('1','136','779','150273',2996568,'2188','334',225079.30,227443.90,0.00,0.00,2364.60,520018.00,0.00,0.00,0.00),('1','136','779','150356',2997965,'2188','334',227443.90,232535.00,0.00,0.00,5091.10,1117068.00,0.00,0.00,0.00),('1','136','779','150850',3007567,'2188','334',232535.00,235925.60,0.00,0.00,3390.60,757336.00,0.00,0.00,0.00),('1','136','779','150851',3007568,'2188','334',235925.60,236362.60,0.00,0.00,437.00,122360.00,0.00,0.00,0.00),('1','136','779','150852',3007569,'2188','334',236362.60,237621.80,0.00,0.00,1259.20,352576.00,0.00,0.00,0.00),('1','136','779','151003',3010338,'2188','334',237621.80,238273.10,0.00,0.00,651.30,182364.00,0.00,0.00,0.00),('1','136','779','151156',3013091,'2188','334',238273.10,239253.10,0.00,0.00,980.00,224020.00,0.00,0.00,0.00),('1','136','779','151285',3015764,'2188','334',239253.10,244718.80,0.00,0.00,5465.70,1193248.00,0.00,0.00,0.00),('1','136','779','151288',3015768,'2188','334',244718.80,253353.30,0.00,0.00,8634.50,1892042.40,0.00,0.00,0.00),('1','136','779','151421',3018370,'2188','334',253353.30,260720.60,0.00,0.00,7367.30,1620044.00,0.00,0.00,0.00),('1','136','779','151541',3020429,'2188','334',260720.60,260898.10,0.00,0.00,177.50,41956.00,0.00,0.00,0.00),('1','136','779','151761',3024347,'2188','334',260898.10,261810.40,0.00,0.00,912.30,255444.00,0.00,0.00,0.00),('1','136','779','151765',3024411,'2188','334',261810.40,263113.90,0.00,0.00,1303.50,302868.00,0.00,0.00,0.00),('1','136','779','151770',3024477,'2188','334',263113.90,269191.10,0.00,0.00,6077.20,1333040.00,0.00,0.00,0.00),('1','136','779','151818',3025461,'2188','334',269191.10,272338.10,0.00,0.00,3147.00,718224.00,0.00,0.00,0.00),('1','136','779','152072',3030251,'2188','334',272338.10,285840.60,0.00,0.00,13502.50,2917672.00,0.00,0.00,0.00),('1','136','779','152165',3031933,'2188','334',285840.60,288277.80,0.00,0.00,2437.20,559856.00,0.00,0.00,0.00),('1','136','779','152385',3036127,'2188','334',288277.80,297041.30,0.00,0.00,8763.50,1926582.00,0.00,0.00,0.00),('1','136','779','152457',3037464,'2188','334',297041.30,305402.80,0.00,0.00,8361.50,1822550.00,0.00,0.00,0.00),('1','136','779','152614',3040205,'2188','334',305402.80,312688.60,0.00,0.00,7285.80,1615744.00,0.00,0.00,0.00),('1','136','779','152771',3043059,'2188','334',312688.60,314365.10,0.00,0.00,1676.50,381640.00,0.00,0.00,0.00),('1','136','779','152774',3043081,'2188','334',314365.10,319462.60,0.00,0.00,5097.50,1155632.00,0.00,0.00,0.00),('1','136','779','152827',3044162,'2188','334',319462.60,319938.60,0.00,0.00,476.00,108080.00,0.00,0.00,0.00),('1','136','779','152995',3047122,'2188','334',319938.60,319938.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','152998',3047192,'2188','334',319938.60,329845.40,0.00,0.00,9906.80,2249868.00,0.00,0.00,0.00),('1','136','779','153082',3048562,'2188','334',329845.40,337680.80,0.00,0.00,7835.40,1769858.00,0.00,0.00,0.00),('1','136','779','153239',3051443,'2188','334',337680.80,343073.30,0.00,0.00,5392.50,1233314.40,0.00,0.00,0.00),('1','136','779','153390',3054150,'2188','334',343073.30,349924.20,0.00,0.00,6850.90,1528642.00,0.00,0.00,0.00),('1','136','779','153493',3056057,'2188','334',349924.20,360873.20,0.00,0.00,10949.00,2467413.60,0.00,0.00,0.00),('1','136','779','153715',3060086,'2188','334',360873.20,365552.20,0.00,0.00,4679.00,1078016.00,0.00,0.00,0.00),('1','136','779','153801',3061600,'2188','334',365552.20,370498.80,0.00,0.00,4946.60,1133852.00,0.00,0.00,0.00),('1','136','779','153873',3062884,'2188','334',370498.80,371408.20,0.00,0.00,909.40,211882.00,0.00,0.00,0.00),('1','136','779','154249',3069493,'2188','334',371408.20,383216.50,0.00,0.00,11808.30,2664402.00,0.00,0.00,0.00),('1','136','779','154251',3069496,'2188','334',383216.50,389675.90,0.00,0.00,6459.40,1476036.00,0.00,0.00,0.00),('1','136','779','154252',3069497,'2188','334',389675.90,393891.20,0.00,0.00,4215.30,946550.00,0.00,0.00,0.00),('1','136','779','154623',3076499,'2188','334',393891.20,402239.70,0.00,0.00,8348.50,1871884.00,0.00,0.00,0.00),('1','136','779','154825',3080378,'2188','334',402239.70,402921.80,0.00,0.00,682.10,190988.00,0.00,0.00,0.00),('1','136','779','154832',3080484,'2188','334',402921.80,403135.40,0.00,0.00,213.60,57008.00,0.00,0.00,0.00),('1','136','779','154857',3080986,'2188','334',403135.40,412118.80,0.00,0.00,8983.40,2013672.00,0.00,0.00,0.00),('1','136','779','155118',3085973,'2188','334',412118.80,425441.90,0.00,0.00,13323.10,2981110.00,0.00,0.00,0.00),('1','136','779','155256',3088429,'2188','334',425441.90,429732.80,0.00,0.00,4290.90,990900.00,0.00,0.00,0.00),('1','136','779','155280',3089010,'2188','334',429732.80,441297.20,0.00,0.00,11564.40,2590444.00,0.00,0.00,0.00),('1','136','779','155642',3095673,'2188','334',441297.20,447996.20,0.00,0.00,6699.00,1505996.00,0.00,0.00,0.00),('1','136','779','155648',3095729,'2188','334',447996.20,456777.30,0.00,0.00,8781.10,1984966.00,0.00,0.00,0.00),('1','136','779','155869',3099629,'2188','334',456777.30,459878.80,0.00,0.00,3101.50,698266.00,0.00,0.00,0.00),('1','136','779','155883',3099908,'2188','334',459878.80,466043.00,0.00,0.00,6164.20,1385016.00,0.00,0.00,0.00),('1','136','779','155925',3100659,'2188','334',466043.00,478456.50,0.00,0.00,12413.50,2774020.00,0.00,0.00,0.00),('1','136','779','156009',3102107,'2188','334',478456.50,482336.00,0.00,0.00,3879.50,880084.00,0.00,0.00,0.00),('1','136','779','156135',3104302,'2188','334',482336.00,490348.00,0.00,0.00,8012.00,1805376.00,0.00,0.00,0.00),('1','136','779','156380',3108900,'2188','334',490348.00,492709.30,0.00,0.00,2361.30,565012.00,0.00,0.00,0.00),('1','136','779','156425',3109627,'2188','334',492709.30,505385.10,0.00,0.00,12675.80,2794232.00,0.00,0.00,0.00),('1','136','779','156579',3112649,'2188','334',505385.10,513522.80,0.00,0.00,8137.70,1835478.00,0.00,0.00,0.00),('1','136','779','156739',3115543,'2188','334',513522.80,515428.80,0.00,0.00,1906.00,449568.00,0.00,0.00,0.00),('1','136','779','156870',3118039,'2188','334',515428.80,515947.10,0.00,0.00,518.30,145124.00,0.00,0.00,0.00),('1','136','779','157087',3121770,'2188','334',515947.10,516195.20,0.00,0.00,248.10,69468.00,0.00,0.00,0.00),('1','136','779','157274',3125236,'2188','334',516195.20,529595.00,0.00,0.00,13399.80,3006978.00,0.00,0.00,0.00),('1','136','779','157484',3128481,'2188','334',529595.00,535967.00,0.00,0.00,6372.00,1439354.00,0.00,0.00,0.00),('1','136','779','157777',3134013,'2188','334',535967.00,541684.90,0.00,0.00,5717.90,1282042.00,0.00,0.00,0.00),('1','136','779','157815',3134663,'2188','334',541684.90,550823.70,0.00,0.00,9138.80,2058636.00,0.00,0.00,0.00),('1','136','779','157976',3137741,'2188','334',550823.70,560772.10,0.00,0.00,9948.40,2249230.00,0.00,0.00,0.00),('1','136','779','158069',3139528,'2188','334',560772.10,564503.50,0.00,0.00,3731.40,836330.00,0.00,0.00,0.00),('1','136','779','158071',3139535,'2188','334',564503.50,572238.20,0.00,0.00,7734.70,1732336.00,0.00,0.00,0.00),('1','136','779','158734',3151820,'2188','334',572238.20,572837.80,0.00,0.00,599.60,167888.00,0.00,0.00,0.00),('1','136','779','158735',3151821,'2188','334',572837.80,575682.90,0.00,0.00,2845.10,665444.00,0.00,0.00,0.00),('1','136','779','158737',3151836,'2188','334',575682.90,576227.80,0.00,0.00,544.90,152572.00,0.00,0.00,0.00),('1','136','779','158738',3151837,'2188','334',576227.80,577283.20,0.00,0.00,1055.40,295512.00,0.00,0.00,0.00),('1','136','779','158905',3154655,'2188','334',577283.20,578949.10,0.00,0.00,1665.90,466452.00,0.00,0.00,0.00),('1','136','779','159093',3158073,'2188','334',578949.10,580417.20,0.00,0.00,1468.10,411068.00,0.00,0.00,0.00),('1','136','779','159333',3162157,'2188','334',580417.20,581558.00,0.00,0.00,1140.80,319424.00,0.00,0.00,0.00),('1','136','779','159437',3163922,'2188','334',581558.00,582429.90,0.00,0.00,871.90,244132.00,0.00,0.00,0.00),('1','136','779','159601',3166858,'2188','334',582429.90,585750.20,0.00,0.00,3320.30,763084.00,0.00,0.00,0.00),('1','136','779','159621',3167250,'2188','334',585750.20,594773.70,0.00,0.00,9023.50,2144804.00,0.00,0.00,0.00),('1','136','779','159732',3169040,'2188','334',594773.70,608598.70,0.00,0.00,13825.00,3279940.00,0.00,0.00,0.00),('1','136','779','159735',3169043,'2188','334',608598.70,611065.90,0.00,0.00,2467.20,590908.80,0.00,0.00,0.00),('1','136','779','159947',3172817,'2188','334',611065.90,613022.30,0.00,0.00,1956.40,516229.60,0.00,0.00,0.00),('1','136','779','160027',3174241,'2188','334',613022.30,614068.50,0.00,0.00,1046.20,241332.80,0.00,0.00,0.00),('1','136','779','160121',3176218,'2188','334',614068.50,628570.50,0.00,0.00,14502.00,3382902.00,0.00,0.00,0.00),('1','136','779','160229',3177943,'2188','334',628570.50,636455.80,0.00,0.00,7885.30,1847123.20,0.00,0.00,0.00),('1','136','779','160300',3179344,'2188','334',636455.80,642666.20,0.00,0.00,6210.40,1493037.60,0.00,0.00,0.00),('1','136','779','160446',3182053,'2188','334',642666.20,651525.90,0.00,0.00,8859.70,2089238.80,0.00,0.00,0.00),('1','136','779','160584',3184559,'2188','334',651525.90,653216.30,0.00,0.00,1690.40,466217.60,0.00,0.00,0.00),('1','136','779','160805',3188254,'2188','334',653216.30,653328.80,0.00,0.00,112.50,31800.00,0.00,0.00,0.00),('1','136','779','160808',3188279,'2188','334',653328.80,656432.60,0.00,0.00,3103.80,827496.80,0.00,0.00,0.00),('1','136','779','160821',3188471,'2188','334',656432.60,662693.50,0.00,0.00,6260.90,1644285.60,0.00,0.00,0.00),('1','136','779','161078',3193067,'2188','334',662693.50,674020.30,0.00,0.00,11326.80,2917743.20,0.00,0.00,0.00),('1','136','779','161345',3197558,'2188','334',674020.30,679312.30,0.00,0.00,5292.00,1373303.20,0.00,0.00,0.00),('1','136','779','161807',3205516,'2188','334',679312.30,683846.90,0.00,0.00,4534.60,1184046.40,0.00,0.00,0.00),('1','136','779','161811',3205612,'2188','334',683846.90,687974.80,0.00,0.00,4127.90,1089644.80,0.00,0.00,0.00),('1','136','779','161853',3206268,'2188','334',687974.80,694972.80,0.00,0.00,6998.00,1825026.00,0.00,0.00,0.00),('1','136','779','162200',3212495,'2188','334',694972.80,702120.30,0.00,0.00,7147.50,1858154.00,0.00,0.00,0.00),('1','136','779','162212',3212752,'2188','334',702120.30,707825.00,0.00,0.00,5704.70,1497444.80,0.00,0.00,0.00),('1','136','779','162450',3216607,'2188','334',707825.00,714687.40,0.00,0.00,6862.40,1772533.60,0.00,0.00,0.00),('1','136','779','162688',3220447,'2188','334',714687.40,719669.10,0.00,0.00,4981.70,1293582.80,0.00,0.00,0.00),('1','136','779','162794',3222539,'2188','334',719669.10,723108.80,0.00,0.00,3439.70,907740.80,0.00,0.00,0.00),('1','136','779','163067',3227109,'2188','334',723108.80,728138.10,0.00,0.00,5029.30,1304093.20,0.00,0.00,0.00),('1','136','779','163188',3229587,'2188','334',728138.10,734378.90,0.00,0.00,6240.80,1470175.70,0.00,0.00,0.00),('1','136','779','163359',3232585,'2188','334',734378.90,739514.00,0.00,0.00,5135.10,1340222.40,0.00,0.00,0.00),('1','136','779','163536',3235835,'2188','334',739514.00,743031.40,0.00,0.00,3517.40,937913.60,0.00,0.00,0.00),('1','136','779','163773',3239934,'2188','334',743031.40,747076.20,0.00,0.00,4044.80,1043523.20,0.00,0.00,0.00),('1','136','779','163890',3242136,'2188','334',747076.20,750275.80,0.00,0.00,3199.60,826898.40,0.00,0.00,0.00),('1','136','779','164236',3248405,'2188','334',750275.80,752425.00,0.00,0.00,2149.20,592516.80,0.00,0.00,0.00),('1','136','779','164239',3248445,'2188','334',752425.00,755867.50,0.00,0.00,3442.50,941058.00,0.00,0.00,0.00),('1','136','779','164429',3252114,'2188','334',755867.50,757487.20,0.00,0.00,1619.70,452104.80,0.00,0.00,0.00),('1','136','779','164591',3254898,'2188','334',757487.20,761901.50,0.00,0.00,4414.30,1208289.20,0.00,0.00,0.00),('1','136','779','164729',3257533,'2188','334',761901.50,764570.60,0.00,0.00,2669.10,742520.40,0.00,0.00,0.00),('1','136','779','164953',3261427,'2188','334',764570.60,772052.40,0.00,0.00,7481.80,2042479.20,0.00,0.00,0.00),('1','136','779','165112',3264173,'2188','334',772052.40,773572.40,0.00,0.00,1520.00,456910.00,0.00,0.00,0.00),('1','136','779','165275',3267026,'2188','334',773572.40,776960.10,0.00,0.00,3387.70,953824.80,0.00,0.00,0.00),('1','136','779','165435',3269836,'2188','334',776960.10,782873.10,0.00,0.00,5913.00,1671324.00,0.00,0.00,0.00),('1','136','779','165599',3272627,'2188','334',782873.10,786400.50,0.00,0.00,3527.40,998356.80,0.00,0.00,0.00),('1','136','779','165750',3275522,'2188','334',786400.50,789705.50,0.00,0.00,3305.00,839545.00,0.00,0.00,0.00),('1','136','779','165778',3276040,'2188','334',789705.50,793901.70,0.00,0.00,4196.20,1181724.80,0.00,0.00,0.00),('1','136','779','165916',3278562,'2188','334',793901.70,799243.80,0.00,0.00,5342.10,1416791.40,0.00,0.00,0.00),('1','136','779','166126',3282237,'2188','334',799243.80,805050.40,0.00,0.00,5806.60,1632158.40,0.00,0.00,0.00),('1','136','779','166305',3285446,'2188','334',805050.40,811745.30,0.00,0.00,6694.90,1871407.60,0.00,0.00,0.00),('1','136','779','166462',3288409,'2188','334',811745.30,818121.50,0.00,0.00,6376.20,1579410.80,0.00,0.00,0.00),('1','136','779','166678',3292112,'2188','334',818121.50,820703.00,0.00,0.00,2581.50,733104.00,0.00,0.00,0.00),('1','136','779','166864',3295291,'2188','334',820703.00,822435.70,0.00,0.00,1732.70,496320.80,0.00,0.00,0.00),('1','136','779','167289',3302785,'2188','334',822435.70,828982.00,0.00,0.00,6546.30,1834371.20,0.00,0.00,0.00),('1','136','779','167293',3302831,'2188','334',828982.00,834338.30,0.00,0.00,5356.30,1510507.20,0.00,0.00,0.00),('1','136','779','167350',3304036,'2188','334',834338.30,836525.60,0.00,0.00,2187.30,626995.20,0.00,0.00,0.00),('1','136','779','167555',3307782,'2188','334',836525.60,841320.60,0.00,0.00,4795.00,1343602.00,0.00,0.00,0.00),('1','136','779','167712',3310411,'2188','334',841320.60,847866.20,0.00,0.00,6545.60,1635064.40,0.00,0.00,0.00),('1','136','779','167892',3313544,'2188','334',847866.20,856911.30,0.00,0.00,9045.10,2323062.40,0.00,0.00,0.00),('1','136','779','168105',3317627,'2188','334',856911.30,857883.30,0.00,0.00,972.00,269748.00,0.00,0.00,0.00),('1','136','779','168109',3317680,'2188','334',857883.30,863379.10,0.00,0.00,5495.80,1548719.20,0.00,0.00,0.00),('1','136','779','168276',3320849,'2188','334',863379.10,866063.20,0.00,0.00,2684.10,768830.40,0.00,0.00,0.00),('1','136','779','168454',3323845,'2188','334',866063.20,871806.80,0.00,0.00,5743.60,1623642.40,0.00,0.00,0.00),('1','136','779','168593',3326398,'2188','334',871806.80,876594.00,0.00,0.00,4787.20,1360336.80,0.00,0.00,0.00),('1','136','779','168807',3330205,'2188','334',876594.00,876594.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','168812',3330238,'2188','334',876594.00,886795.10,0.00,0.00,10201.10,2568809.40,0.00,0.00,0.00),('1','136','779','168997',3333585,'2188','334',886795.10,895545.20,0.00,0.00,8750.10,2473758.40,0.00,0.00,0.00),('1','136','779','169082',3335123,'2188','334',895545.20,903880.70,0.00,0.00,8335.50,2260273.00,0.00,0.00,0.00),('1','136','779','169102',3335419,'2188','334',903880.70,912122.90,0.00,0.00,8242.20,2302322.80,0.00,0.00,0.00),('1','136','779','169247',3338185,'2188','334',912122.90,922773.60,0.00,0.00,10650.70,3112548.80,0.00,0.00,0.00),('1','136','779','169457',3342264,'2188','334',922773.60,934187.00,0.00,0.00,11413.40,3334097.60,0.00,0.00,0.00),('1','136','779','169552',3344124,'2188','334',934187.00,940753.40,0.00,0.00,6566.40,1916559.60,0.00,0.00,0.00),('1','136','779','169917',3351116,'2188','334',940753.40,945766.40,0.00,0.00,5013.00,1469544.00,0.00,0.00,0.00),('1','136','779','170059',3353567,'2188','334',945766.40,949049.50,0.00,0.00,3283.10,967102.40,0.00,0.00,0.00),('1','136','779','170466',3360536,'2188','334',949049.50,953266.80,0.00,0.00,4217.30,1235007.20,0.00,0.00,0.00),('1','136','779','170471',3360621,'2188','334',953266.80,958889.50,0.00,0.00,5622.70,1651646.80,0.00,0.00,0.00),('1','136','779','170777',3366224,'2188','334',958889.50,963998.50,0.00,0.00,5109.00,1494950.00,0.00,0.00,0.00),('1','136','779','170946',3369074,'2188','334',963998.50,968736.80,0.00,0.00,4738.30,1391916.00,0.00,0.00,0.00),('1','136','779','171173',3373369,'2188','334',968736.80,976704.80,0.00,0.00,7968.00,2031236.00,0.00,0.00,0.00),('1','136','779','171301',3375779,'2188','334',976704.80,977947.80,0.00,0.00,1243.00,370656.00,0.00,0.00,0.00),('1','136','779','171303',3375792,'2188','334',977947.80,982497.40,0.00,0.00,4549.60,1342640.00,0.00,0.00,0.00),('1','136','779','171380',3377211,'2188','334',982497.40,986998.90,0.00,0.00,4501.50,1334046.00,0.00,0.00,0.00),('1','136','779','171657',3382158,'2188','334',986998.90,991054.20,0.00,0.00,4055.30,1208258.00,0.00,0.00,0.00),('1','136','779','171744',3383745,'2188','334',991054.20,994166.30,0.00,0.00,3112.10,930828.00,0.00,0.00,0.00),('1','136','779','171938',3387152,'2188','334',994166.30,998247.80,0.00,0.00,4081.50,1212980.00,0.00,0.00,0.00),('1','136','779','172065',3389490,'2188','334',998247.80,1005383.10,0.00,0.00,7135.30,2103586.00,0.00,0.00,0.00),('1','136','779','172255',3392931,'2188','334',1005383.10,1011922.10,0.00,0.00,6539.00,1929512.00,0.00,0.00,0.00),('1','136','779','172462',3396713,'2188','334',1011922.10,1014377.80,0.00,0.00,2455.70,745756.00,0.00,0.00,0.00),('1','136','779','172682',3400717,'2188','334',1014377.80,1018390.00,0.00,0.00,4012.20,1195796.00,0.00,0.00,0.00),('1','136','779','172857',3403945,'2188','334',1018390.00,1024779.00,0.00,0.00,6389.00,1717924.00,0.00,0.00,0.00),('1','136','779','173032',3407249,'2188','334',1024779.00,1033571.10,0.00,0.00,8792.10,2405772.00,0.00,0.00,0.00),('1','136','779','173194',3410572,'2188','334',1033571.10,1040491.50,0.00,0.00,6920.40,2042338.00,0.00,0.00,0.00),('1','136','779','173347',3413314,'2188','334',1040491.50,1045143.10,0.00,0.00,4651.60,1390596.00,0.00,0.00,0.00),('1','136','779','173571',3417440,'2188','334',1045143.10,1050314.70,0.00,0.00,5171.60,1532874.00,0.00,0.00,0.00),('1','136','779','173745',3420547,'2188','334',1050314.70,1055360.00,0.00,0.00,5045.30,1481260.00,0.00,0.00,0.00),('1','136','779','173927',3423906,'2188','334',1055360.00,1056117.00,0.00,0.00,757.00,153364.00,0.00,0.00,0.00),('1','136','779','173928',3423907,'2188','334',1056117.00,1061132.70,0.00,0.00,5015.70,1485192.00,0.00,0.00,0.00),('1','136','779','174115',3427187,'2188','334',1061132.70,1066215.70,0.00,0.00,5083.00,1490776.00,0.00,0.00,0.00),('1','136','779','174297',3430529,'2188','334',1066215.70,1075084.30,0.00,0.00,8868.60,2404702.00,0.00,0.00,0.00),('1','136','779','174471',3433320,'2188','334',1075084.30,1082920.30,0.00,0.00,7836.00,2319380.00,0.00,0.00,0.00),('1','136','779','174609',3435824,'2188','334',1082920.30,1087895.80,0.00,0.00,4975.50,1473458.00,0.00,0.00,0.00),('1','136','779','174822',3439781,'2188','334',1087895.80,1098040.90,0.00,0.00,10145.10,2958936.00,0.00,0.00,0.00),('1','136','779','175021',3443743,'2188','334',1098040.90,1104807.90,0.00,0.00,6767.00,1924318.40,0.00,0.00,0.00),('1','136','779','175276',3448049,'2188','334',1104807.90,1106022.00,0.00,0.00,1214.10,403188.00,0.00,0.00,0.00),('1','136','779','175392',3450433,'2188','334',1106022.00,1112177.30,0.00,0.00,6155.30,1885284.00,0.00,0.00,0.00),('1','136','779','175573',3453627,'2188','334',1112177.30,1116160.10,0.00,0.00,3982.80,1268064.00,0.00,0.00,0.00),('1','136','779','175850',3458595,'2188','334',1116160.10,1125808.80,0.00,0.00,9648.70,2962684.00,0.00,0.00,0.00),('1','136','779','176051',3462178,'2188','334',1125808.80,1130573.60,0.00,0.00,4764.80,1512716.80,0.00,0.00,0.00),('1','136','779','176158',3464019,'2188','334',1130573.60,1134195.20,0.00,0.00,3621.60,1149760.00,0.00,0.00,0.00),('1','136','779','176307',3467111,'2188','334',1134195.20,1140984.90,0.00,0.00,6789.70,2064586.00,0.00,0.00,0.00),('1','136','779','176520',3471049,'2188','334',1140984.90,1146303.20,0.00,0.00,5318.30,1456692.00,0.00,0.00,0.00),('1','136','779','176744',3475097,'2188','334',1146303.20,1150857.50,0.00,0.00,4554.30,1448816.00,0.00,0.00,0.00),('1','136','779','176954',3479023,'2188','334',1150857.50,1154187.20,0.00,0.00,3329.70,1056508.00,0.00,0.00,0.00),('1','136','779','177149',3482726,'2188','334',1154187.20,1156179.60,0.00,0.00,1992.40,627235.20,0.00,0.00,0.00),('1','136','779','177181',3483380,'2188','334',1156179.60,1159420.00,0.00,0.00,3240.40,1031956.00,0.00,0.00,0.00),('1','136','779','177400',3487783,'2188','334',1159420.00,1163096.10,0.00,0.00,3676.10,1189344.00,0.00,0.00,0.00),('1','136','779','177596',3491888,'2188','334',1163096.10,1165984.50,0.00,0.00,2888.40,926130.00,0.00,0.00,0.00),('1','136','779','177852',3496382,'2188','334',1165984.50,1169450.70,0.00,0.00,3466.20,1099400.00,0.00,0.00,0.00),('1','136','779','178043',3500171,'2188','334',1169450.70,1171725.80,0.00,0.00,2275.10,740604.00,0.00,0.00,0.00),('1','136','779','178235',3503690,'2188','334',1171725.80,1176665.90,0.00,0.00,4940.10,1557800.00,0.00,0.00,0.00),('1','136','779','178393',3506558,'2188','334',1176665.90,1180914.70,0.00,0.00,4248.80,1264324.00,0.00,0.00,0.00),('1','136','779','178522',3508901,'2188','334',1180914.70,1181848.30,0.00,0.00,933.60,304376.00,0.00,0.00,0.00),('1','136','779','178599',3510426,'2188','334',1181848.30,1183553.00,0.00,0.00,1704.70,555012.00,0.00,0.00,0.00),('1','136','779','178658',3511412,'2188','334',1183553.00,1190858.80,0.00,0.00,7305.80,2266826.00,0.00,0.00,0.00),('1','136','779','178918',3516011,'2188','334',1190858.80,1190858.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','178919',3516012,'2188','334',1190858.80,1194664.20,0.00,0.00,3805.40,1256377.00,0.00,0.00,0.00),('1','136','779','178994',3517489,'2188','334',1194664.20,1197632.60,0.00,0.00,2968.40,974174.00,0.00,0.00,0.00),('1','136','779','179270',3522758,'2188','334',1197632.60,1201671.20,0.00,0.00,4038.60,1315722.00,0.00,0.00,0.00),('1','136','779','179372',3524728,'2188','334',1201671.20,1204714.70,0.00,0.00,3043.50,996409.25,0.00,0.00,0.00),('1','136','779','179581',3528526,'2188','334',1204714.70,1209511.90,0.00,0.00,4797.20,1563241.00,0.00,0.00,0.00),('1','136','779','179773',3532472,'2188','334',1209511.90,1212068.30,0.00,0.00,2556.40,846734.40,0.00,0.00,0.00),('1','136','779','179994',3536421,'2188','334',1212068.30,1221295.85,0.00,0.00,9227.55,2902855.00,0.00,0.00,0.00),('1','136','779','180180',3540006,'2188','334',1221295.85,1227074.53,0.00,0.00,5778.68,1885486.80,0.00,0.00,0.00),('1','136','779','180344',3542829,'2188','334',1227074.53,1231661.54,0.00,0.00,4587.01,1487302.60,0.00,0.00,0.00),('1','136','779','180546',3546682,'2188','334',1231661.54,1231883.54,0.00,0.00,222.00,71864.00,0.00,0.00,0.00),('1','136','779','180567',3546847,'2188','334',1231883.54,1234643.04,0.00,0.00,2759.50,897494.00,0.00,0.00,0.00),('1','136','779','180735',3550060,'2188','334',1234643.04,1238587.10,0.00,0.00,3944.06,1299239.60,0.00,0.00,0.00),('1','136','779','180963',3554410,'2188','334',1238587.10,1246473.67,0.00,0.00,7886.57,2488148.20,0.00,0.00,0.00),('1','136','779','181136',3557672,'2188','334',1246473.67,1250387.07,0.00,0.00,3913.40,1275890.00,0.00,0.00,0.00),('1','136','779','181339',3561732,'2188','334',1250387.07,1252930.92,0.00,0.00,2543.85,854426.00,0.00,0.00,0.00),('1','136','779','181529',3565105,'2188','334',1252930.92,1258836.48,0.00,0.00,5905.56,1916508.00,0.00,0.00,0.00),('1','136','779','181718',3568253,'2188','334',1258836.48,1264740.85,0.00,0.00,5904.37,1913030.20,0.00,0.00,0.00),('1','136','779','181910',3571621,'2188','334',1264740.85,1272284.98,0.00,0.00,7544.13,2424688.80,0.00,0.00,0.00),('1','136','779','182110',3575513,'2188','334',1272284.98,1272284.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','182111',3575514,'2188','334',1272284.98,1280844.07,0.00,0.00,8559.09,2711889.40,0.00,0.00,0.00),('1','136','779','182305',3578875,'2188','334',1280844.07,1280939.85,0.00,0.00,95.78,32040.80,0.00,0.00,0.00),('1','136','779','182321',3579002,'2188','334',1280939.85,1289719.99,0.00,0.00,8780.14,2821511.40,0.00,0.00,0.00),('1','136','779','182502',3582393,'2188','334',1289719.99,1297104.58,0.00,0.00,7384.59,2367750.40,0.00,0.00,0.00),('1','136','779','182680',3585804,'2188','334',1297104.58,1302214.18,0.00,0.00,5109.60,1668232.00,0.00,0.00,0.00),('1','136','779','183095',3593515,'2188','334',1302214.18,1309255.08,0.00,0.00,7040.90,2273614.00,0.00,0.00,0.00),('1','136','779','183180',3595005,'2188','334',1309255.08,1319568.78,0.00,0.00,10313.70,3305869.00,0.00,0.00,0.00),('1','136','779','183214',3595603,'2188','334',1319568.78,1330258.33,0.00,0.00,10689.55,3399655.00,0.00,0.00,0.00),('1','136','779','183424',3599390,'2188','334',1330258.33,1330524.46,0.00,0.00,266.13,92906.80,0.00,0.00,0.00),('1','136','779','183469',3599953,'2188','334',1330524.46,1335234.25,0.00,0.00,4709.79,1533826.60,0.00,0.00,0.00),('1','136','779','183643',3603289,'2188','334',1335234.25,1346660.54,0.00,0.00,11426.29,3646356.40,0.00,0.00,0.00),('1','136','779','183871',3607598,'2188','334',1346660.54,1353820.82,0.00,0.00,7160.28,2314513.80,0.00,0.00,0.00),('1','136','779','184153',3612464,'2188','334',1353820.82,1363160.01,0.00,0.00,9339.19,3032638.40,0.00,0.00,0.00),('1','136','779','184265',3614545,'2188','334',1363160.01,1370750.34,0.00,0.00,7590.33,2465786.80,0.00,0.00,0.00),('1','136','779','184469',3618123,'2188','334',1370750.34,1379985.55,0.00,0.00,9235.21,2923071.60,0.00,0.00,0.00),('1','136','779','184633',3621264,'2188','334',1379985.55,1382136.85,0.00,0.00,2151.30,694850.00,0.00,0.00,0.00),('1','136','779','184697',3622275,'2188','334',1382136.85,1390690.70,0.00,0.00,8553.85,2757456.00,0.00,0.00,0.00),('1','136','779','184896',3625863,'2188','334',1390690.70,1397123.06,0.00,0.00,6432.36,2079900.60,0.00,0.00,0.00),('1','136','779','185114',3629576,'2188','334',1397123.06,1402352.63,0.00,0.00,5229.57,1703333.20,0.00,0.00,0.00),('1','136','779','185260',3631894,'2188','334',1402352.63,1411627.07,0.00,0.00,9274.44,2982480.40,0.00,0.00,0.00),('1','136','779','185467',3635784,'2188','334',1411627.07,1417879.60,0.00,0.00,6252.53,2045138.80,0.00,0.00,0.00),('1','136','779','185674',3639525,'2188','334',1417879.60,1425586.54,0.00,0.00,7706.94,2519055.80,0.00,0.00,0.00),('1','136','779','185880',3643149,'2188','334',1425586.54,1429281.62,0.00,0.00,3695.08,1222832.80,0.00,0.00,0.00),('1','136','779','185976',3644941,'2188','334',1429281.62,1431872.67,0.00,0.00,2591.05,857155.60,0.00,0.00,0.00),('1','136','779','186078',3646820,'2188','334',1431872.67,1437975.23,0.00,0.00,6102.56,2023427.20,0.00,0.00,0.00),('1','136','779','186318',3650697,'2188','334',1437975.23,1449770.34,0.00,0.00,11795.11,3870247.60,0.00,0.00,0.00),('1','136','779','186533',3654405,'2188','334',1449770.34,1459183.31,0.00,0.00,9412.97,3081863.20,0.00,0.00,0.00),('1','136','779','186755',3658179,'2188','334',1459183.31,1464965.41,0.00,0.00,5782.10,1904488.00,0.00,0.00,0.00),('1','136','779','186985',3661981,'2188','334',1464965.41,1474557.08,0.00,0.00,9591.67,3116447.20,0.00,0.00,0.00),('1','136','779','187159',3665025,'2188','334',1474557.08,1475930.42,0.00,0.00,1373.34,451738.40,0.00,0.00,0.00),('1','136','779','187207',3665812,'2188','334',1475930.42,1481546.12,0.00,0.00,5615.70,1851918.00,0.00,0.00,0.00),('1','136','779','187376',3668840,'2188','334',1481546.12,1488909.09,0.00,0.00,7362.97,2414950.96,0.00,0.00,0.00),('1','136','779','187611',3673029,'2188','334',1488909.09,1494840.66,0.00,0.00,5931.57,1940703.60,0.00,0.00,0.00),('1','136','779','187837',3676920,'2188','334',1494840.66,1504982.62,0.00,0.00,10141.96,3295381.60,0.00,0.00,0.00),('1','136','779','188020',3680270,'2188','334',1504982.62,1511196.75,0.00,0.00,6214.13,2058370.80,0.00,0.00,0.00),('1','136','779','188218',3683684,'2188','334',1511196.75,1521206.06,0.00,0.00,10009.31,3284449.60,0.00,0.00,0.00),('1','136','779','188429',3687275,'2188','334',1521206.06,1524763.89,0.00,0.00,3557.83,1169476.40,0.00,0.00,0.00),('1','136','779','188504',3688649,'2188','334',1524763.89,1529902.97,0.00,0.00,5139.08,1685863.60,0.00,0.00,0.00),('1','136','779','188609',3690410,'2188','334',1529902.97,1530052.97,0.00,0.00,150.00,48600.00,0.00,0.00,0.00),('1','136','779','188612',3690432,'2188','334',1530052.97,1537997.12,0.00,0.00,7944.15,2622054.00,0.00,0.00,0.00),('1','136','779','188812',3693993,'2188','334',1537997.12,1550244.63,0.00,0.00,12247.51,4021671.60,0.00,0.00,0.00),('1','136','779','189015',3697741,'2188','334',1550244.63,1555348.43,0.00,0.00,5103.80,1674564.00,0.00,0.00,0.00),('1','136','779','189212',3701138,'2188','334',1555348.43,1562497.15,0.00,0.00,7148.72,2350017.20,0.00,0.00,0.00),('1','136','779','189427',3705123,'2188','334',1562497.15,1568529.05,0.00,0.00,6031.90,1992008.00,0.00,0.00,0.00),('1','136','779','189622',3708491,'2188','334',1568529.05,1575015.70,0.00,0.00,6486.65,2130036.00,0.00,0.00,0.00),('1','136','779','189811',3711886,'2188','334',1575015.70,1578377.71,0.00,0.00,3362.01,1102823.60,0.00,0.00,0.00),('1','136','779','189890',3713008,'2188','334',1578377.71,1582719.73,0.00,0.00,4342.02,1435061.20,0.00,0.00,0.00),('1','136','779','190034',3716242,'2188','334',1582719.73,1586614.26,0.00,0.00,3894.53,1296838.80,0.00,0.00,0.00),('1','136','779','190216',3719771,'2188','334',1586614.26,1595368.45,0.00,0.00,8754.19,2884490.40,0.00,0.00,0.00),('1','136','779','190445',3723882,'2188','334',1595368.45,1600816.11,0.00,0.00,5447.66,1798445.60,0.00,0.00,0.00),('1','136','779','190667',3728159,'2188','334',1600816.11,1606442.08,0.00,0.00,5625.97,1853587.20,0.00,0.00,0.00),('1','136','779','190895',3732249,'2188','334',1606442.08,1614849.27,0.00,0.00,8407.19,2765368.40,0.00,0.00,0.00),('1','136','779','191087',3735618,'2188','334',1614849.27,1622973.18,0.00,0.00,8123.91,2664335.60,0.00,0.00,0.00),('1','136','779','191296',3739321,'2188','334',1622973.18,1627683.19,0.00,0.00,4710.01,1546007.64,0.00,0.00,0.00),('1','136','779','191501',3743001,'2188','334',1627683.19,1627866.19,0.00,0.00,183.00,59400.00,0.00,0.00,0.00),('1','136','779','191508',3743046,'2188','334',1627866.19,1634335.59,0.00,0.00,6469.40,2143232.00,0.00,0.00,0.00),('1','136','779','191708',3747181,'2188','334',1634335.59,1641106.89,0.00,0.00,6771.30,2234120.00,0.00,0.00,0.00),('1','136','779','191940',3751601,'2188','334',1641106.89,1645279.76,0.00,0.00,4172.87,1388169.20,0.00,0.00,0.00),('1','136','779','192135',3754964,'2188','334',1645279.76,1652395.64,0.00,0.00,7115.88,2357032.80,0.00,0.00,0.00),('1','136','779','192535',3762428,'2188','334',1652395.64,1656686.34,0.00,0.00,4290.70,1429972.00,0.00,0.00,0.00),('1','136','779','192569',3762881,'2188','334',1656686.34,1662106.67,0.00,0.00,5420.33,1805542.80,0.00,0.00,0.00),('1','136','779','192753',3766236,'2188','334',1662106.67,1668450.02,0.00,0.00,6343.35,2108481.04,0.00,0.00,0.00),('1','136','779','192955',3769907,'2188','334',1668450.02,1672780.83,0.00,0.00,4330.81,1404731.60,0.00,0.00,0.00),('1','136','779','193188',3774215,'2188','334',1672780.83,1677169.60,0.00,0.00,4388.77,1416449.20,0.00,0.00,0.00),('1','136','779','193237',3775102,'2188','334',1677169.60,1677169.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','193372',3778266,'2188','334',1677169.60,1683989.40,0.00,0.00,6819.80,2240490.00,0.00,0.00,0.00),('1','136','779','193418',3778917,'2188','334',1683989.40,1688441.21,0.00,0.00,4451.81,1479752.40,0.00,0.00,0.00),('1','136','779','193621',3782829,'2188','334',1688441.21,1693523.70,0.00,0.00,5082.49,1693436.80,0.00,0.00,0.00),('1','136','779','193897',3787446,'2188','334',1693523.70,1697843.91,0.00,0.00,4320.21,1442616.52,0.00,0.00,0.00),('1','136','779','194237',3793875,'2188','334',1697843.91,1701918.53,0.00,0.00,4074.62,1309955.90,0.00,0.00,0.00),('1','136','779','194443',3797631,'2188','334',1701918.53,1709326.15,0.00,0.00,7407.62,2454861.60,0.00,0.00,0.00),('1','136','779','194485',3798319,'2188','334',1709326.15,1716383.56,0.00,0.00,7057.41,2495813.60,0.00,0.00,0.00),('1','136','779','194681',3801728,'2188','334',1716383.56,1721300.39,0.00,0.00,4916.83,1629964.80,0.00,0.00,0.00),('1','136','779','195046',3808810,'2188','334',1721300.39,1726047.39,0.00,0.00,4747.00,1575124.00,0.00,0.00,0.00),('1','136','779','195195',3811406,'2188','334',1726047.39,1726952.09,0.00,0.00,904.70,305056.00,0.00,0.00,0.00),('1','136','779','195254',3812456,'2188','334',1726952.09,1731122.03,0.00,0.00,4169.94,1384070.40,0.00,0.00,0.00),('1','136','779','195330',3813571,'2188','334',1731122.03,1735070.51,0.00,0.00,3948.48,1320000.00,0.00,0.00,0.00),('1','136','779','195516',3817117,'2188','334',1735070.51,1742132.80,0.00,0.00,7062.29,2319525.32,0.00,0.00,0.00),('1','136','779','195782',3821487,'2188','334',1742132.80,1747031.22,0.00,0.00,4898.42,1630333.60,0.00,0.00,0.00),('1','136','779','196189',3829249,'2188','334',1747031.22,1751385.52,0.00,0.00,4354.30,1448568.00,0.00,0.00,0.00),('1','136','779','196274',3830581,'2188','334',1751385.52,1751661.52,0.00,0.00,276.00,89424.00,0.00,0.00,0.00),('1','136','779','196404',3833085,'2188','334',1751661.52,1758042.81,0.00,0.00,6381.29,2103643.92,0.00,0.00,0.00),('1','136','779','196600',3836577,'2188','334',1758042.81,1763277.59,0.00,0.00,5234.78,1735574.00,0.00,0.00,0.00),('1','136','779','196833',3840747,'2188','334',1763277.59,1770240.79,0.00,0.00,6963.20,2278972.00,0.00,0.00,0.00),('1','136','779','197002',3843852,'2188','334',1770240.79,1773538.10,0.00,0.00,3297.31,1078453.60,0.00,0.00,0.00),('1','136','779','197179',3846797,'2188','334',1773538.10,1777896.50,0.00,0.00,4358.40,1421372.00,0.00,0.00,0.00),('1','136','779','197404',3850425,'2188','334',1777896.50,1785000.30,0.00,0.00,7103.80,2311394.00,0.00,0.00,0.00),('1','136','779','197413',3850530,'2188','334',1785000.30,1790177.05,0.00,0.00,5176.75,1700562.00,0.00,0.00,0.00),('1','136','779','197512',3852430,'2188','334',1790177.05,1796033.02,0.00,0.00,5855.97,1912708.80,0.00,0.00,0.00),('1','136','779','197879',3858928,'2188','334',1796033.02,1800644.77,0.00,0.00,4611.75,1512718.00,0.00,0.00,0.00),('1','136','779','198138',3863328,'2188','334',1800644.77,1801004.77,0.00,0.00,360.00,115200.00,0.00,0.00,0.00),('1','136','779','198240',3865023,'2188','334',1801004.77,1807731.93,0.00,0.00,6727.16,2170389.60,0.00,0.00,0.00),('1','136','779','198352',3867072,'2188','334',1807731.93,1811516.68,0.00,0.00,3784.75,1235972.80,0.00,0.00,0.00),('1','136','779','198579',3870915,'2188','334',1811516.68,1818569.59,0.00,0.00,7052.91,2259371.18,0.00,0.00,0.00),('1','136','779','198796',3874500,'2188','334',1818569.59,1824386.51,0.00,0.00,5816.92,1904311.16,0.00,0.00,0.00),('1','136','779','199144',3881030,'2188','334',1824386.51,1825753.51,0.00,0.00,1367.00,450920.00,0.00,0.00,0.00),('1','136','779','199145',3881031,'2188','334',1825753.51,1826740.51,0.00,0.00,987.00,450920.00,0.00,0.00,0.00),('1','136','779','199151',3881168,'2188','334',1826740.51,1831312.49,0.00,0.00,4571.98,1484650.80,0.00,0.00,0.00),('1','136','779','199398',3885063,'2188','334',1831312.49,1838050.49,0.00,0.00,6738.00,2163192.00,0.00,0.00,0.00),('1','136','779','199604',3888599,'2188','334',1838050.49,1842031.19,0.00,0.00,3980.70,1292684.00,0.00,0.00,0.00),('1','136','779','199646',3889211,'2188','334',1842031.19,1846575.57,0.00,0.00,4544.38,1471092.80,0.00,0.00,0.00),('1','136','779','200040',3895863,'2188','334',1846575.57,1851456.97,0.00,0.00,4881.40,1582362.00,0.00,0.00,0.00),('1','136','779','200264',3899871,'2188','334',1851456.97,1855731.07,0.00,0.00,4274.10,1395770.40,0.00,0.00,0.00),('1','136','779','200331',3900716,'2188','334',1855731.07,1862422.20,0.00,0.00,6691.13,2159674.80,0.00,0.00,0.00),('1','136','779','200493',3904000,'2188','334',1862422.20,1872166.13,0.00,0.00,9743.93,3126166.80,0.00,0.00,0.00),('1','136','779','200697',3907534,'2188','334',1872166.13,1876057.35,0.00,0.00,3891.22,1262019.20,0.00,0.00,0.00),('1','136','779','200938',3911682,'2188','334',1876057.35,1884154.34,0.00,0.00,8096.99,2606608.40,0.00,0.00,0.00),('1','136','779','201114',3914655,'2188','334',1884154.34,1888385.19,0.00,0.00,4230.85,1380543.20,0.00,0.00,0.00),('1','136','779','201348',3918481,'2188','334',1888385.19,1894286.65,0.00,0.00,5901.46,1908449.20,0.00,0.00,0.00),('1','136','779','201499',3921491,'2188','334',1894286.65,1899946.49,0.00,0.00,5659.84,1849822.40,0.00,0.00,0.00),('1','136','779','201765',3926613,'2188','334',1899946.49,1900799.41,0.00,0.00,852.92,276959.20,0.00,0.00,0.00),('1','136','779','201948',3930051,'2188','334',1900799.41,1905844.11,0.00,0.00,5044.70,1699796.00,0.00,0.00,0.00),('1','136','779','202072',3932217,'2188','334',1905844.11,1906704.11,0.00,0.00,860.00,285520.00,0.00,0.00,0.00),('1','136','779','202151',3933745,'2188','334',1906704.11,1911990.11,0.00,0.00,5286.00,1778432.00,0.00,0.00,0.00),('1','136','779','202317',3936416,'2188','334',1911990.11,1919543.58,0.00,0.00,7553.47,2548659.36,0.00,0.00,0.00),('1','136','779','202433',3938505,'2188','334',1919543.58,1923415.66,0.00,0.00,3872.08,1306588.56,0.00,0.00,0.00),('1','136','779','202556',3940636,'2188','334',1923415.66,1925428.80,0.00,0.00,2013.14,681450.40,0.00,0.00,0.00),('1','136','779','202650',3942223,'2188','334',1925428.80,1928526.20,0.00,0.00,3097.40,1048556.80,0.00,0.00,0.00),('1','136','779','202801',3945113,'2188','334',1928526.20,1931308.13,0.00,0.00,2781.93,941264.00,0.00,0.00,0.00),('1','136','779','202859',3946011,'2188','334',1931308.13,1936841.03,0.00,0.00,5532.90,1874486.00,0.00,0.00,0.00),('1','136','779','203119',3950929,'2188','334',1936841.03,1939691.04,0.00,0.00,2850.01,967401.20,0.00,0.00,0.00),('1','136','779','203274',3953926,'2188','334',1939691.04,1942548.04,0.00,0.00,2857.00,923440.00,0.00,0.00,0.00),('1','136','779','203481',3957675,'2188','334',1942548.04,1945436.04,0.00,0.00,2888.00,912015.00,0.00,0.00,0.00),('1','136','779','203486',3957762,'2188','334',1945436.04,1951831.74,0.00,0.00,6395.70,2158168.00,0.00,0.00,0.00),('1','136','779','203628',3960304,'2188','334',1951831.74,1953853.14,0.00,0.00,2021.40,673336.00,0.00,0.00,0.00),('1','136','779','203638',3960434,'2188','334',1953853.14,1959414.10,0.00,0.00,5560.96,1864885.60,0.00,0.00,0.00),('1','136','779','203741',3962150,'2188','334',1959414.10,1967436.86,0.00,0.00,8022.76,2729015.36,0.00,0.00,0.00),('1','136','779','203968',3966185,'2188','334',1967436.86,1971139.18,0.00,0.00,3702.32,1297728.32,0.00,0.00,0.00),('1','136','779','204195',3970389,'2188','334',1971139.18,1977667.05,0.00,0.00,6527.87,2258811.52,0.00,0.00,0.00),('1','136','779','204403',3974049,'2188','334',1977667.05,1978496.07,0.00,0.00,829.02,289983.52,0.00,0.00,0.00),('1','136','779','204481',3975469,'2188','334',1978496.07,1984301.95,0.00,0.00,5805.88,2008056.88,0.00,0.00,0.00),('1','136','779','204624',3978117,'2188','334',1984301.95,1995651.15,0.00,0.00,11349.20,3759513.44,0.00,0.00,0.00),('1','136','779','204840',3981604,'2188','334',1995651.15,2000377.92,0.00,0.00,4726.77,1645788.56,0.00,0.00,0.00),('1','136','779','205041',3985236,'2188','334',2000377.92,2003812.07,0.00,0.00,3434.15,1217184.40,0.00,0.00,0.00),('1','136','779','205238',3988779,'2188','334',2003812.07,2005026.24,0.00,0.00,1214.17,425551.92,0.00,0.00,0.00),('1','136','779','205345',3990683,'2188','334',2005026.24,2005026.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','205361',3990983,'2188','334',2005026.24,2008705.21,0.00,0.00,3678.97,1273618.72,0.00,0.00,0.00),('1','136','779','205469',3993098,'2188','334',2008705.21,2012065.52,0.00,0.00,3360.31,1174672.96,0.00,0.00,0.00),('1','136','779','205749',3997946,'2188','334',2012065.52,2016221.78,0.00,0.00,4156.26,1454409.48,0.00,0.00,0.00),('1','136','779','205941',4001554,'2188','334',2016221.78,2020755.17,0.00,0.00,4533.39,1570436.88,0.00,0.00,0.00),('1','136','779','206148',4005230,'2188','334',2020755.17,2024764.16,0.00,0.00,4008.99,1391536.28,0.00,0.00,0.00),('1','136','779','206358',4008832,'2188','334',2024764.16,2029886.49,0.00,0.00,5122.33,1695133.08,0.00,0.00,0.00),('1','136','779','206525',4011832,'2188','334',2029886.49,2032473.59,0.00,0.00,2587.10,905029.60,0.00,0.00,0.00),('1','136','779','206574',4012561,'2188','334',2032473.59,2039183.53,0.00,0.00,6709.94,2339000.00,0.00,0.00,0.00),('1','136','779','206811',4016697,'2188','334',2039183.53,2044328.21,0.00,0.00,5144.68,1786620.12,0.00,0.00,0.00),('1','136','779','207047',4020927,'2188','334',2044328.21,2049492.93,0.00,0.00,5164.72,1791362.72,0.00,0.00,0.00),('1','136','779','207247',4024687,'2188','334',2049492.93,2053805.24,0.00,0.00,4312.31,1508088.56,0.00,0.00,0.00),('1','136','779','207479',4028803,'2188','334',2053805.24,2054616.44,0.00,0.00,811.20,280891.20,0.00,0.00,0.00),('1','136','779','207655',4031842,'2188','334',2054616.44,2059574.44,0.00,0.00,4958.00,1623274.40,0.00,0.00,0.00),('1','136','779','207659',4031884,'2188','334',2059574.44,2060173.55,0.00,0.00,599.11,209817.36,0.00,0.00,0.00),('1','136','779','207707',4032660,'2188','334',2060173.55,2064398.84,0.00,0.00,4225.29,1510263.04,0.00,0.00,0.00),('1','136','779','207908',4036087,'2188','334',2064398.84,2070233.09,0.00,0.00,5834.25,2085468.32,0.00,0.00,0.00),('1','136','779','208108',4039604,'2188','334',2070233.09,2079972.62,0.00,0.00,9739.53,3327486.72,0.00,0.00,0.00),('1','136','779','208316',4043415,'2188','334',2079972.62,2083814.38,0.00,0.00,3841.76,1372047.84,0.00,0.00,0.00),('1','136','779','208643',4048984,'2188','334',2083814.38,2084048.04,0.00,0.00,233.66,84285.44,0.00,0.00,0.00),('1','136','779','208733',4050701,'2188','334',2084048.04,2086979.56,0.00,0.00,2931.52,1052752.08,0.00,0.00,0.00),('1','136','779','208961',4054708,'2188','334',2086979.56,2095307.06,0.00,0.00,8327.50,2813443.00,0.00,0.00,0.00),('1','136','779','208991',4055094,'2188','334',2095307.06,2099297.41,0.00,0.00,3990.35,1489453.28,0.00,0.00,0.00),('1','136','779','209223',4059054,'2188','334',2099297.41,2102559.70,0.00,0.00,3262.29,1224091.72,0.00,0.00,0.00),('1','136','779','209438',4062901,'2188','334',2102559.70,2107210.08,0.00,0.00,4650.38,1747238.00,0.00,0.00,0.00),('1','136','779','209645',4066587,'2188','334',2107210.08,2108683.76,0.00,0.00,1473.68,557856.96,0.00,0.00,0.00),('1','136','779','209763',4068751,'2188','334',2108683.76,2113287.11,0.00,0.00,4603.35,1716350.20,0.00,0.00,0.00),('1','136','779','209858',4070391,'2188','334',2113287.11,2113773.21,0.00,0.00,486.10,192656.00,0.00,0.00,0.00),('1','136','779','209976',4072473,'2188','334',2113773.21,2116048.82,0.00,0.00,2275.61,858969.80,0.00,0.00,0.00),('1','136','779','210099',4074752,'2188','334',2116048.82,2117189.23,0.00,0.00,1140.41,478972.20,0.00,0.00,0.00),('1','136','779','210305',4078324,'2188','334',2117189.23,2118096.73,0.00,0.00,907.50,381150.00,0.00,0.00,0.00),('1','136','779','210511',4082178,'2188','334',2118096.73,2119044.84,0.00,0.00,948.11,398206.20,0.00,0.00,0.00),('1','136','779','210729',4085962,'2188','334',2119044.84,2120180.76,0.00,0.00,1135.92,477086.40,0.00,0.00,0.00),('1','136','779','210982',4090010,'2188','334',2120180.76,2123427.05,0.00,0.00,3246.29,1145993.60,0.00,0.00,0.00),('1','136','779','211137',4093067,'2188','334',2123427.05,2126296.25,0.00,0.00,2869.20,1079794.20,0.00,0.00,0.00),('1','136','779','211167',4093572,'2188','334',2126296.25,2132519.54,0.00,0.00,6223.29,2479196.80,0.00,0.00,0.00),('1','136','779','211369',4097266,'2188','334',2132519.54,2142492.47,0.00,0.00,9972.93,3806783.80,0.00,0.00,0.00),('1','136','779','211651',4101996,'2188','334',2142492.47,2147911.28,0.00,0.00,5418.81,2135991.00,0.00,0.00,0.00),('1','136','779','211842',4105084,'2188','334',2147911.28,2148221.48,0.00,0.00,310.20,121598.40,0.00,0.00,0.00),('1','136','779','211848',4105213,'2188','334',2148221.48,2153219.53,0.00,0.00,4998.05,1979541.52,0.00,0.00,0.00),('1','136','779','211985',4107845,'2188','334',2153219.53,2153894.98,0.00,0.00,675.45,286390.80,0.00,0.00,0.00),('1','136','779','212196',4111596,'2188','334',2153894.98,2154312.97,0.00,0.00,417.99,177227.76,0.00,0.00,0.00),('1','136','779','212230',4112122,'2188','334',2154312.97,2155183.96,0.00,0.00,870.99,369299.76,0.00,0.00,0.00),('1','136','779','212453',4116291,'2188','334',2155183.96,2156509.28,0.00,0.00,1325.32,551750.92,0.00,0.00,0.00),('1','136','779','212663',4120055,'2188','334',2156509.28,2158397.03,0.00,0.00,1887.75,775475.28,0.00,0.00,0.00),('1','136','779','212940',4124861,'2188','334',2158397.03,2159757.59,0.00,0.00,1360.56,549189.12,0.00,0.00,0.00),('1','136','779','213131',4128154,'2188','334',2159757.59,2162167.08,0.00,0.00,2409.49,954025.68,0.00,0.00,0.00),('1','136','779','213369',4132178,'2188','334',2162167.08,2163998.05,0.00,0.00,1830.97,741408.08,0.00,0.00,0.00),('1','136','779','213370',4132179,'2188','334',2163998.05,2165369.78,0.00,0.00,1371.73,548392.24,0.00,0.00,0.00),('1','136','779','213389',4132376,'2188','334',2165369.78,2168087.68,0.00,0.00,2717.90,1109845.60,0.00,0.00,0.00),('1','136','779','213627',4136391,'2188','334',2168087.68,2172844.11,0.00,0.00,4756.43,1897233.20,0.00,0.00,0.00),('1','136','779','213892',4140694,'2188','334',2172844.11,2175768.31,0.00,0.00,2924.20,1172718.00,0.00,0.00,0.00),('1','136','779','214097',4144150,'2188','334',2175768.31,2180880.89,0.00,0.00,5112.58,2036219.52,0.00,0.00,0.00),('1','136','779','214326',4148257,'2188','334',2180880.89,2185734.57,0.00,0.00,4853.68,1939089.12,0.00,0.00,0.00),('1','136','779','214528',4151556,'2188','334',2185734.57,2188892.11,0.00,0.00,3157.54,1254268.96,0.00,0.00,0.00),('1','136','779','214857',4157285,'2188','334',2188892.11,2193336.49,0.00,0.00,4444.38,1759309.12,0.00,0.00,0.00),('1','136','779','214999',4159543,'2188','334',2193336.49,2199272.48,0.00,0.00,5935.99,2347277.36,0.00,0.00,0.00),('1','136','779','215230',4163555,'2188','334',2199272.48,2202954.09,0.00,0.00,3681.61,1547346.88,0.00,0.00,0.00),('1','136','779','215440',4167078,'2188','334',2202954.09,2209054.88,0.00,0.00,6100.79,2461888.32,0.00,0.00,0.00),('1','136','779','215675',4171115,'2188','334',2209054.88,2212875.18,0.00,0.00,3820.30,1613812.60,0.00,0.00,0.00),('1','136','779','215903',4175058,'2188','334',2212875.18,2213582.29,0.00,0.00,707.11,298657.28,0.00,0.00,0.00),('1','136','779','215981',4176286,'2188','334',2213582.29,2218189.16,0.00,0.00,4606.87,1938660.08,0.00,0.00,0.00),('1','136','779','216097',4178427,'2188','334',2218189.16,2221206.54,0.00,0.00,3017.38,1274618.16,0.00,0.00,0.00),('1','136','779','216323',4182272,'2188','334',2221206.54,2224952.10,0.00,0.00,3745.56,1578293.12,0.00,0.00,0.00),('1','136','779','216557',4186310,'2188','334',2224952.10,2228823.33,0.00,0.00,3871.23,1637087.56,0.00,0.00,0.00),('1','136','779','216784',4190460,'2188','334',2228823.33,2236614.57,0.00,0.00,7791.24,3265744.88,0.00,0.00,0.00),('1','136','779','217025',4194508,'2188','334',2236614.57,2237271.05,0.00,0.00,656.48,315110.40,0.00,0.00,0.00),('1','136','779','217234',4198685,'2188','334',2237271.05,2238960.75,0.00,0.00,1689.70,660599.50,0.00,0.00,0.00),('1','136','779','217241',4198837,'2188','334',2238960.75,2239999.65,0.00,0.00,1038.90,498672.00,0.00,0.00,0.00),('1','136','779','217268',4199299,'2188','334',2239999.65,2241568.58,0.00,0.00,1568.93,753086.40,0.00,0.00,0.00),('1','136','779','217502',4203256,'2188','334',2241568.58,2242097.95,0.00,0.00,529.37,254097.60,0.00,0.00,0.00),('1','136','779','217569',4204238,'2188','334',2242097.95,2243728.19,0.00,0.00,1630.24,782515.20,0.00,0.00,0.00),('1','136','779','217709',4206696,'2188','334',2243728.19,2245358.81,0.00,0.00,1630.62,741380.40,0.00,0.00,0.00),('1','136','779','217976',4211698,'2188','334',2245358.81,2246878.29,0.00,0.00,1519.48,683650.40,0.00,0.00,0.00),('1','136','779','218095',4213516,'2188','334',2246878.29,2252689.76,0.00,0.00,5811.47,2517462.60,0.00,0.00,0.00),('1','136','779','218216',4215733,'2188','334',2252689.76,2256151.84,0.00,0.00,3462.08,1550038.40,0.00,0.00,0.00),('1','136','779','218448',4219837,'2188','334',2256151.84,2259011.01,0.00,0.00,2859.17,1289049.24,0.00,0.00,0.00),('1','136','779','218681',4224041,'2188','334',2259011.01,2266251.13,0.00,0.00,7240.12,3141021.60,0.00,0.00,0.00),('1','136','779','218899',4227961,'2188','334',2266251.13,2270945.90,0.00,0.00,4694.77,2105355.08,0.00,0.00,0.00),('1','136','779','219133',4231733,'2188','334',2270945.90,2271189.90,0.00,0.00,244.00,109480.00,0.00,0.00,0.00),('1','136','779','219212',4233024,'2188','334',2271189.90,2276313.47,0.00,0.00,5123.57,2295956.40,0.00,0.00,0.00),('1','136','779','219343',4235383,'2188','334',2276313.47,2279499.08,0.00,0.00,3185.61,1433616.80,0.00,0.00,0.00),('1','136','779','219601',4239856,'2188','334',2279499.08,2282086.24,0.00,0.00,2587.16,1160481.36,0.00,0.00,0.00),('1','136','779','219808',4243715,'2188','334',2282086.24,2284927.75,0.00,0.00,2841.51,1277892.32,0.00,0.00,0.00),('1','136','779','220039',4247857,'2188','334',2284927.75,2288426.03,0.00,0.00,3498.28,1542263.20,0.00,0.00,0.00),('1','136','779','220245',4251456,'2188','334',2288426.03,2291725.40,0.00,0.00,3299.37,1460184.96,0.00,0.00,0.00),('1','136','779','220465',4255566,'2188','334',2291725.40,2295593.40,0.00,0.00,3868.00,1721642.00,0.00,0.00,0.00),('1','136','779','220709',4259553,'2188','334',2295593.40,2301378.31,0.00,0.00,5784.91,2533663.36,0.00,0.00,0.00),('1','136','779','220904',4263223,'2188','334',2301378.31,2305104.78,0.00,0.00,3726.47,1644783.08,0.00,0.00,0.00),('1','136','779','221140',4267371,'2188','334',2305104.78,2310054.89,0.00,0.00,4950.11,2176844.00,0.00,0.00,0.00),('1','136','779','221380',4271722,'2188','334',2310054.89,2313017.11,0.00,0.00,2962.22,1326100.88,0.00,0.00,0.00),('1','136','779','221613',4276035,'2188','334',2313017.11,2318537.01,0.00,0.00,5519.90,2446892.40,0.00,0.00,0.00),('1','136','779','221830',4279789,'2188','334',2318537.01,2320290.21,0.00,0.00,1753.20,756046.00,0.00,0.00,0.00),('1','136','779','221910',4281017,'2188','334',2320290.21,2323648.42,0.00,0.00,3358.21,1509099.20,0.00,0.00,0.00),('1','136','779','222056',4283988,'2188','334',2323648.42,2325440.90,0.00,0.00,1792.48,808426.40,0.00,0.00,0.00),('1','136','779','222192',4286224,'2188','334',2325440.90,2326550.40,0.00,0.00,1109.50,508960.00,0.00,0.00,0.00),('1','136','779','222263',4287454,'2188','334',2326550.40,2328240.69,0.00,0.00,1690.29,769208.80,0.00,0.00,0.00),('1','136','779','222395',4289518,'2188','334',2328240.69,2331009.92,0.00,0.00,2769.23,1242950.40,0.00,0.00,0.00),('1','136','779','222485',4291271,'2188','334',2331009.92,2332340.22,0.00,0.00,1330.30,638544.00,0.00,0.00,0.00),('1','136','779','222725',4295731,'2188','334',2332340.22,2333295.19,0.00,0.00,954.97,458385.60,0.00,0.00,0.00),('1','136','779','223007',4300862,'2188','334',2333295.19,2334461.43,0.00,0.00,1166.24,559795.20,0.00,0.00,0.00),('1','136','779','223143',4303325,'2188','334',2334461.43,2334461.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','223174',4303726,'2188','334',2334461.43,2335656.40,0.00,0.00,1194.97,573585.60,0.00,0.00,0.00),('1','136','779','223414',4307862,'2188','334',2335656.40,2337016.57,0.00,0.00,1360.17,646974.48,0.00,0.00,0.00),('1','136','779','223738',4313737,'2188','334',2337016.57,2338362.95,0.00,0.00,1346.38,657780.32,0.00,0.00,0.00),('1','136','779','223804',4315054,'2188','334',2338362.95,2339338.35,0.00,0.00,975.40,466236.80,0.00,0.00,0.00),('1','136','779','223946',4317480,'2188','334',2339338.35,2343093.69,0.00,0.00,3755.34,1791846.08,0.00,0.00,0.00),('1','136','779','224086',4319969,'2188','334',2343093.69,2343386.36,0.00,0.00,292.67,139959.04,0.00,0.00,0.00),('1','136','779','224276',4323633,'2188','334',2343386.36,2345981.61,0.00,0.00,2595.25,1244128.32,0.00,0.00,0.00),('1','136','779','224307',4324105,'2188','334',2345981.61,2349152.19,0.00,0.00,3170.58,1537406.08,0.00,0.00,0.00),('1','136','779','224527',4327907,'2188','334',2349152.19,2351875.47,0.00,0.00,2723.28,1344191.72,0.00,0.00,0.00),('1','136','779','224774',4332218,'2188','334',2351875.47,2354770.88,0.00,0.00,2895.41,1432401.06,0.00,0.00,0.00),('1','136','779','225011',4336506,'2188','334',2354770.88,2357413.22,0.00,0.00,2642.34,1305754.56,0.00,0.00,0.00),('1','136','779','225264',4341080,'2188','334',2357413.22,2364954.96,0.00,0.00,7541.74,3662431.88,0.00,0.00,0.00),('1','136','779','225478',4345032,'2188','334',2364954.96,2368095.74,0.00,0.00,3140.78,1553152.16,0.00,0.00,0.00),('1','136','779','225654',4348215,'2188','334',2368095.74,2370207.05,0.00,0.00,2111.31,1026655.32,0.00,0.00,0.00),('1','136','779','225701',4348745,'2188','334',2370207.05,2373139.28,0.00,0.00,2932.23,1428510.76,0.00,0.00,0.00),('1','136','779','225845',4351239,'2188','334',2373139.28,2375429.52,0.00,0.00,2290.24,1139521.14,0.00,0.00,0.00),('1','136','779','225977',4353457,'2188','334',2375429.52,2379482.81,0.00,0.00,4053.29,2006520.30,0.00,0.00,0.00),('1','136','779','226185',4357495,'2188','334',2379482.81,2380394.46,0.00,0.00,911.65,451529.00,0.00,0.00,0.00),('1','136','779','226355',4360420,'2188','334',2380394.46,2382079.05,0.00,0.00,1684.59,835578.96,0.00,0.00,0.00),('1','136','779','226366',4360601,'2188','334',2382079.05,2387374.51,0.00,0.00,5295.46,2623906.24,0.00,0.00,0.00),('1','136','779','226477',4362573,'2188','334',2387374.51,2394417.93,0.00,0.00,7043.42,3484096.48,0.00,0.00,0.00),('1','136','779','226729',4367249,'2188','334',2394417.93,2398590.64,0.00,0.00,4172.71,2077915.98,0.00,0.00,0.00),('1','136','779','226963',4371360,'2188','334',2398590.64,2406707.79,0.00,0.00,8117.15,4001619.02,0.00,0.00,0.00),('1','136','779','227213',4375551,'2188','334',2406707.79,2413103.19,0.00,0.00,6395.40,3181180.78,0.00,0.00,0.00),('1','136','779','227367',4378517,'2188','334',2413103.19,2418472.69,0.00,0.00,5369.50,2667795.00,0.00,0.00,0.00),('1','136','779','227616',4382658,'2188','334',2418472.69,2428940.23,0.00,0.00,10467.54,5149156.90,0.00,0.00,0.00),('1','136','779','227851',4386919,'2188','334',2428940.23,2431157.86,0.00,0.00,2217.63,1101114.78,0.00,0.00,0.00),('1','136','779','227976',4389239,'2188','334',2431157.86,2431977.03,0.00,0.00,819.17,425328.48,0.00,0.00,0.00),('1','136','779','228108',4391921,'2188','334',2431977.03,2432961.21,0.00,0.00,984.18,535393.92,0.00,0.00,0.00),('1','136','779','228324',4396197,'2188','334',2432961.21,2433813.37,0.00,0.00,852.16,463575.04,0.00,0.00,0.00),('1','136','779','228362',4396639,'2188','334',2433813.37,2436493.14,0.00,0.00,2679.77,1414564.56,0.00,0.00,0.00),('1','136','779','228500',4399417,'2188','334',2436493.14,2439178.50,0.00,0.00,2685.36,1370577.20,0.00,0.00,0.00),('1','136','779','228532',4399868,'2188','334',2439178.50,2443543.39,0.00,0.00,4364.89,2281870.12,0.00,0.00,0.00),('1','136','779','228754',4404089,'2188','334',2443543.39,2444069.96,0.00,0.00,526.57,277119.20,0.00,0.00,0.00),('1','136','779','228788',4404487,'2188','334',2444069.96,2448328.15,0.00,0.00,4258.19,2224561.28,0.00,0.00,0.00),('1','136','779','228934',4407388,'2188','334',2448328.15,2449163.85,0.00,0.00,835.70,399397.00,0.00,0.00,0.00),('1','136','779','229032',4409314,'2188','334',2449163.85,2455055.15,0.00,0.00,5891.30,2921230.40,0.00,0.00,0.00),('1','136','779','229171',4412011,'2188','334',2455055.15,2462669.72,0.00,0.00,7614.57,3930463.40,0.00,0.00,0.00),('1','136','779','229414',4416320,'2188','334',2462669.72,2466645.73,0.00,0.00,3976.01,2144774.48,0.00,0.00,0.00),('1','136','779','229663',4421203,'2188','334',2466645.73,2470039.71,0.00,0.00,3393.98,1831508.40,0.00,0.00,0.00),('1','136','779','229878',4425559,'2188','334',2470039.71,2474058.64,0.00,0.00,4018.93,2179279.12,0.00,0.00,0.00),('1','136','779','230039',4428534,'2188','334',2474058.64,2474390.99,0.00,0.00,332.35,190452.40,0.00,0.00,0.00),('1','136','779','230086',4429337,'2188','334',2474390.99,2476246.96,0.00,0.00,1855.97,1083886.48,0.00,0.00,0.00),('1','136','779','230233',4432000,'2188','334',2476246.96,2476766.93,0.00,0.00,519.97,303662.48,0.00,0.00,0.00),('1','136','779','230281',4433014,'2188','334',2476766.93,2478447.35,0.00,0.00,1680.42,981365.28,0.00,0.00,0.00),('1','136','779','230595',4438788,'2188','334',2478447.35,2479611.01,0.00,0.00,1163.66,679577.44,0.00,0.00,0.00),('1','136','779','230783',4442109,'2188','334',2479611.01,2481166.60,0.00,0.00,1555.59,908464.56,0.00,0.00,0.00),('1','136','779','231059',4446922,'2188','334',2481166.60,2481486.02,0.00,0.00,319.42,186541.28,0.00,0.00,0.00),('1','136','779','231191',4449155,'2188','334',2481486.02,2483493.16,0.00,0.00,2007.14,1172169.76,0.00,0.00,0.00),('1','136','779','231375',4451833,'2188','334',2483493.16,2485103.26,0.00,0.00,1610.10,912298.40,0.00,0.00,0.00),('1','136','779','231638',4456422,'2188','334',2485103.26,2486594.91,0.00,0.00,1491.65,871123.60,0.00,0.00,0.00),('1','136','779','232024',4463501,'2188','334',2486594.91,2486664.91,0.00,0.00,70.00,40880.00,0.00,0.00,0.00),('1','136','779','232033',4463741,'2188','334',2486664.91,2487502.21,0.00,0.00,837.30,488983.20,0.00,0.00,0.00),('1','136','779','232100',4464905,'2188','334',2487502.21,2488488.57,0.00,0.00,986.36,576034.24,0.00,0.00,0.00),('1','136','779','232252',4467531,'2188','334',2488488.57,2489254.32,0.00,0.00,765.75,427337.04,0.00,0.00,0.00),('1','136','779','232325',4468874,'2188','334',2489254.32,2494952.54,0.00,0.00,5698.22,2987990.26,0.00,0.00,0.00),('1','136','779','232588',4473609,'2188','334',2494952.54,2498186.37,0.00,0.00,3233.83,1855286.00,0.00,0.00,0.00),('1','136','779','232853',4478276,'2188','334',2498186.37,2502247.72,0.00,0.00,4061.35,2321839.46,0.00,0.00,0.00),('1','136','779','233120',4483112,'2188','334',2502247.72,2506553.24,0.00,0.00,4305.52,2455529.00,0.00,0.00,0.00),('1','136','779','233361',4487591,'2188','334',2506553.24,2507586.65,0.00,0.00,1033.41,629465.84,0.00,0.00,0.00),('1','136','779','233597',4491914,'2188','334',2507586.65,2509030.66,0.00,0.00,1444.01,881062.24,0.00,0.00,0.00),('1','136','779','233840',4496197,'2188','334',2509030.66,2511048.37,0.00,0.00,2017.71,1211159.54,0.00,0.00,0.00),('1','136','779','234043',4499795,'2188','334',2511048.37,2513251.41,0.00,0.00,2203.04,994421.12,0.00,0.00,0.00),('1','136','779','234309',4504687,'2188','334',2513251.41,2513847.87,0.00,0.00,596.46,350295.04,0.00,0.00,0.00),('1','136','779','234422',4506728,'2188','334',2513847.87,2515228.16,0.00,0.00,1380.29,829103.26,0.00,0.00,0.00),('1','136','779','234551',4509087,'2188','334',2515228.16,2516773.39,0.00,0.00,1545.23,923923.52,0.00,0.00,0.00),('1','136','779','234809',4513650,'2188','334',2516773.39,2518505.20,0.00,0.00,1731.81,1037455.44,0.00,0.00,0.00),('1','136','779','235059',4518072,'2188','334',2518505.20,2521079.89,0.00,0.00,2574.69,1523740.32,0.00,0.00,0.00),('1','136','779','235289',4522004,'2188','334',2521079.89,2524626.29,0.00,0.00,3546.40,2093390.34,0.00,0.00,0.00),('1','136','779','235513',4525953,'2188','334',2524626.29,2528743.04,0.00,0.00,4116.75,2419938.64,0.00,0.00,0.00),('1','136','779','235751',4530115,'2188','334',2528743.04,2532054.37,0.00,0.00,3311.33,2007917.60,0.00,0.00,0.00),('1','136','779','236003',4534525,'2188','334',2532054.37,2534320.99,0.00,0.00,2266.62,1397103.60,0.00,0.00,0.00),('1','136','779','236237',4538696,'2188','334',2534320.99,2535903.32,0.00,0.00,1582.33,979731.20,0.00,0.00,0.00),('1','136','779','236514',4543570,'2188','334',2535903.32,2538303.01,0.00,0.00,2399.69,1478441.60,0.00,0.00,0.00),('1','136','779','236731',4547125,'2188','334',2538303.01,2541077.29,0.00,0.00,2774.28,1691210.00,0.00,0.00,0.00),('1','136','779','236944',4551064,'2188','334',2541077.29,2544147.80,0.00,0.00,3070.51,1887900.00,0.00,0.00,0.00),('1','136','779','237164',4554862,'2188','334',2544147.80,2547117.23,0.00,0.00,2969.43,1798915.20,0.00,0.00,0.00),('1','136','779','237370',4558684,'2188','334',2547117.23,2549743.01,0.00,0.00,2625.78,1610139.20,0.00,0.00,0.00),('1','136','779','237649',4563395,'2188','334',2549743.01,2555273.04,0.00,0.00,5530.03,3385317.88,0.00,0.00,0.00),('1','136','779','237896',4567421,'2188','334',2555273.04,2560817.29,0.00,0.00,5544.25,3394797.86,0.00,0.00,0.00),('1','136','779','238113',4571079,'2188','334',2560817.29,2562920.12,0.00,0.00,2102.83,1295468.80,0.00,0.00,0.00),('1','136','779','238259',4573601,'2188','334',2562920.12,2566401.33,0.00,0.00,3481.21,2118154.64,0.00,0.00,0.00),('1','136','779','238352',4575223,'2188','334',2566401.33,2568234.44,0.00,0.00,1833.11,1116582.40,0.00,0.00,0.00),('1','136','779','238563',4578834,'2188','334',2568234.44,2571583.61,0.00,0.00,3349.17,2046847.80,0.00,0.00,0.00),('1','136','779','238734',4581639,'2188','334',2571583.61,2573125.06,0.00,0.00,1541.45,934118.70,0.00,0.00,0.00),('1','136','779','238736',4581670,'2188','334',2573125.06,2578327.81,0.00,0.00,5202.75,3175573.30,0.00,0.00,0.00),('1','136','779','238780',4582612,'2188','334',2578327.81,2583289.73,0.00,0.00,4961.92,3026241.72,0.00,0.00,0.00),('1','136','779','239003',4586634,'2188','334',2583289.73,2583593.73,0.00,0.00,304.00,184832.00,0.00,0.00,0.00),('1','136','779','239005',4586646,'2188','334',2583593.73,2586492.44,0.00,0.00,2898.71,1791454.40,0.00,0.00,0.00),('1','136','779','239273',4591314,'2188','334',2586492.44,2588737.05,0.00,0.00,2244.61,1378903.68,0.00,0.00,0.00),('1','136','779','239274',4591315,'2188','334',2588737.05,2592514.56,0.00,0.00,3777.51,2301666.84,0.00,0.00,0.00),('1','136','779','239482',4594874,'2188','334',2592514.56,2593757.02,0.00,0.00,1242.46,764006.40,0.00,0.00,0.00),('1','136','779','239488',4594975,'2188','334',2593757.02,2595451.66,0.00,0.00,1694.64,1038669.60,0.00,0.00,0.00),('1','136','779','239602',4596862,'2188','334',2595451.66,2598880.15,0.00,0.00,3428.49,2104033.60,0.00,0.00,0.00),('1','136','779','239882',4601687,'2188','334',2598880.15,2599637.31,0.00,0.00,757.16,467238.40,0.00,0.00,0.00),('1','136','779','239890',4601858,'2188','334',2599637.31,2603187.42,0.00,0.00,3550.11,2199366.40,0.00,0.00,0.00),('1','136','779','240071',4605045,'2188','334',2603187.42,2605979.82,0.00,0.00,2792.40,1743840.60,0.00,0.00,0.00),('1','136','779','240207',4607353,'2188','334',2605979.82,2609001.79,0.00,0.00,3021.97,1889372.62,0.00,0.00,0.00),('1','136','779','240503',4612098,'2188','334',2609001.79,2611660.23,0.00,0.00,2658.44,1665168.80,0.00,0.00,0.00),('1','136','779','240678',4614835,'2188','334',2611660.23,2613988.31,0.00,0.00,2328.08,1459990.60,0.00,0.00,0.00),('1','136','779','240967',4619939,'2188','334',2613988.31,2614172.85,0.00,0.00,184.54,115033.60,0.00,0.00,0.00),('1','136','779','241010',4620595,'2188','334',2614172.85,2616886.39,0.00,0.00,2713.54,1700531.32,0.00,0.00,0.00),('1','136','779','241214',4624447,'2188','334',2616886.39,2619400.83,0.00,0.00,2514.44,1553154.60,0.00,0.00,0.00),('1','136','779','241478',4628925,'2188','334',2619400.83,2621219.98,0.00,0.00,1819.15,1124723.16,0.00,0.00,0.00),('1','136','779','241722',4633178,'2188','334',2621219.98,2624254.45,0.00,0.00,3034.47,1859252.08,0.00,0.00,0.00),('1','136','779','241972',4637387,'2188','334',2624254.45,2627635.02,0.00,0.00,3380.57,2074517.10,0.00,0.00,0.00),('1','136','779','242193',4641421,'2188','334',2627635.02,2631128.56,0.00,0.00,3493.54,2157500.02,0.00,0.00,0.00),('1','136','779','242430',4645449,'2188','334',2631128.56,2636041.55,0.00,0.00,4912.99,2995848.60,0.00,0.00,0.00),('1','136','779','242673',4649744,'2188','334',2636041.55,2638286.12,0.00,0.00,2244.57,1386755.80,0.00,0.00,0.00),('1','136','779','242912',4653759,'2188','334',2638286.12,2639628.76,0.00,0.00,1342.64,823289.60,0.00,0.00,0.00),('1','136','779','243015',4655561,'2188','334',2639628.76,2642360.76,0.00,0.00,2732.00,1655636.28,0.00,0.00,0.00),('1','136','779','243144',4657767,'2188','334',2642360.76,2645296.62,0.00,0.00,2935.86,1798970.40,0.00,0.00,0.00),('1','136','779','243350',4661697,'2188','334',2645296.62,2649467.53,0.00,0.00,4170.91,2541506.20,0.00,0.00,0.00),('1','136','779','243586',4665673,'2188','334',2649467.53,2654418.54,0.00,0.00,4951.01,3008215.40,0.00,0.00,0.00),('1','136','779','243829',4669843,'2188','334',2654418.54,2657280.51,0.00,0.00,2861.97,1756860.80,0.00,0.00,0.00),('1','136','779','244045',4673612,'2188','334',2657280.51,2661166.00,0.00,0.00,3885.49,2360718.60,0.00,0.00,0.00),('1','136','779','244272',4677486,'2188','334',2661166.00,2663630.03,0.00,0.00,2464.03,1508524.40,0.00,0.00,0.00),('1','136','779','244508',4681606,'2188','334',2663630.03,2664151.80,0.00,0.00,521.77,313780.80,0.00,0.00,0.00),('1','136','779','244553',4682164,'2188','334',2664151.80,2667374.14,0.00,0.00,3222.34,1969403.40,0.00,0.00,0.00),('1','136','779','244734',4685352,'2188','334',2667374.14,2669496.47,0.00,0.00,2122.33,1307166.20,0.00,0.00,0.00),('1','136','779','244964',4689528,'2188','334',2669496.47,2671830.51,0.00,0.00,2334.04,1406899.28,0.00,0.00,0.00),('1','136','779','245202',4693695,'2188','334',2671830.51,2675593.83,0.00,0.00,3763.32,2259449.60,0.00,0.00,0.00),('1','136','779','245432',4697632,'2188','334',2675593.83,2678684.61,0.00,0.00,3090.78,1876152.96,0.00,0.00,0.00),('1','136','779','245730',4702751,'2188','334',2678684.61,2681608.63,0.00,0.00,2924.02,1750751.08,0.00,0.00,0.00),('1','136','779','245931',4705778,'2188','334',2681608.63,2686326.11,0.00,0.00,4717.48,2702210.88,0.00,0.00,0.00),('1','136','779','246188',4710037,'2188','334',2686326.11,2694191.04,0.00,0.00,7864.93,4472820.88,0.00,0.00,0.00),('1','136','779','246391',4713470,'2188','334',2694191.04,2695645.07,0.00,0.00,1454.03,829066.48,0.00,0.00,0.00),('1','136','779','246454',4714515,'2188','334',2695645.07,2700085.34,0.00,0.00,4440.27,2552129.92,0.00,0.00,0.00),('1','136','779','246689',4718700,'2188','334',2700085.34,2703539.59,0.00,0.00,3454.25,1988645.00,0.00,0.00,0.00),('1','136','779','246928',4722962,'2188','334',2703539.59,2708652.00,0.00,0.00,5112.41,2945615.56,0.00,0.00,0.00),('1','136','779','247173',4726948,'2188','334',2708652.00,2712786.12,0.00,0.00,4134.12,2396171.92,0.00,0.00,0.00),('1','136','779','247399',4731060,'2188','334',2712786.12,2717463.57,0.00,0.00,4677.45,2686219.16,0.00,0.00,0.00),('1','136','779','247654',4735403,'2188','334',2717463.57,2718952.89,0.00,0.00,1489.32,849545.12,0.00,0.00,0.00),('1','136','779','247764',4737165,'2188','334',2718952.89,2721592.69,0.00,0.00,2639.80,1488461.78,0.00,0.00,0.00),('1','136','779','247900',4739530,'2188','334',2721592.69,2725345.83,0.00,0.00,3753.14,2129766.40,0.00,0.00,0.00),('1','136','779','248137',4743652,'2188','334',2725345.83,2728229.63,0.00,0.00,2883.80,1646297.60,0.00,0.00,0.00),('1','136','779','248400',4747980,'2188','334',2728229.63,2732461.62,0.00,0.00,4231.99,2417995.00,0.00,0.00,0.00),('1','136','779','248641',4751999,'2188','334',2732461.62,2738118.44,0.00,0.00,5656.82,3192417.92,0.00,0.00,0.00),('1','136','779','248860',4755820,'2188','334',2738118.44,2740867.08,0.00,0.00,2748.64,1525320.96,0.00,0.00,0.00),('1','136','779','249104',4759840,'2188','334',2740867.08,2743658.15,0.00,0.00,2791.07,1508247.64,0.00,0.00,0.00),('1','136','779','249273',4762796,'2188','334',2743658.15,2744524.30,0.00,0.00,866.15,475622.80,0.00,0.00,0.00),('1','136','779','249340',4763925,'2188','334',2744524.30,2749160.75,0.00,0.00,4636.45,2500389.36,0.00,0.00,0.00),('1','136','779','249597',4768164,'2188','334',2749160.75,2753802.72,0.00,0.00,4641.97,2500741.34,0.00,0.00,0.00),('1','136','779','249850',4772487,'2188','334',2753802.72,2758934.67,0.00,0.00,5131.95,2776748.72,0.00,0.00,0.00),('1','136','779','250091',4776508,'2188','334',2758934.67,2763082.53,0.00,0.00,4147.86,2256044.04,0.00,0.00,0.00),('1','136','779','250333',4780620,'2188','334',2763082.53,2768285.70,0.00,0.00,5203.17,2805274.64,0.00,0.00,0.00),('1','136','779','250498',4783222,'2188','334',2768285.70,2768734.51,0.00,0.00,448.81,255199.52,0.00,0.00,0.00),('1','136','779','250569',4784426,'2188','334',2768734.51,2771432.35,0.00,0.00,2697.84,1469249.28,0.00,0.00,0.00),('1','136','779','250782',4788297,'2188','334',2771432.35,2773276.83,0.00,0.00,1844.48,996793.16,0.00,0.00,0.00),('1','136','779','250890',4790104,'2188','334',2773276.83,2775146.69,0.00,0.00,1869.86,1021721.12,0.00,0.00,0.00),('1','136','779','251009',4792372,'2188','334',2775146.69,2779837.76,0.00,0.00,4691.07,2529940.52,0.00,0.00,0.00),('1','136','779','251271',4796795,'2188','334',2779837.76,2783353.74,0.00,0.00,3515.98,1914506.16,0.00,0.00,0.00),('1','136','779','251518',4800931,'2188','334',2783353.74,2786876.41,0.00,0.00,3522.67,1913010.64,0.00,0.00,0.00),('1','136','779','251761',4805367,'2188','334',2786876.41,2791468.40,0.00,0.00,4591.99,2485146.08,0.00,0.00,0.00),('1','136','779','251995',4809367,'2188','334',2791468.40,2796968.52,0.00,0.00,5500.12,2971077.64,0.00,0.00,0.00),('1','136','779','252242',4813573,'2188','334',2796968.52,2797517.82,0.00,0.00,549.30,294508.00,0.00,0.00,0.00),('1','136','779','252281',4814176,'2188','334',2797517.82,2802611.69,0.00,0.00,5093.87,2760366.24,0.00,0.00,0.00),('1','136','779','252477',4817938,'2188','334',2802611.69,2808575.41,0.00,0.00,5963.72,3203204.36,0.00,0.00,0.00),('1','136','779','252707',4821954,'2188','334',2808575.41,2812094.84,0.00,0.00,3519.43,1922918.56,0.00,0.00,0.00),('1','136','779','252964',4826064,'2188','334',2812094.84,2818031.77,0.00,0.00,5936.93,3209088.72,0.00,0.00,0.00),('1','136','779','253205',4830226,'2188','334',2818031.77,2821223.74,0.00,0.00,3191.97,1736512.24,0.00,0.00,0.00),('1','136','779','253478',4834801,'2188','334',2821223.74,2822220.93,0.00,0.00,997.19,530608.48,0.00,0.00,0.00),('1','136','779','253531',4835496,'2188','334',2822220.93,2824896.24,0.00,0.00,2675.31,1450190.72,0.00,0.00,0.00),('1','136','779','253718',4838816,'2188','334',2824896.24,2830646.94,0.00,0.00,5750.70,3091082.60,0.00,0.00,0.00),('1','136','779','253944',4843001,'2188','334',2830646.94,2835862.72,0.00,0.00,5215.78,2811397.76,0.00,0.00,0.00),('1','136','779','254199',4847416,'2188','334',2835862.72,2839946.52,0.00,0.00,4083.80,2194641.80,0.00,0.00,0.00),('1','136','779','254452',4851771,'2188','334',2839946.52,2846686.69,0.00,0.00,6740.17,3545191.16,0.00,0.00,0.00),('1','136','779','254642',4855222,'2188','334',2846686.69,2847382.38,0.00,0.00,695.69,398588.48,0.00,0.00,0.00),('1','136','779','254688',4856005,'2188','334',2847382.38,2852002.52,0.00,0.00,4620.14,2480537.32,0.00,0.00,0.00),('1','136','779','254946',4860286,'2188','334',2852002.52,2856978.53,0.00,0.00,4976.01,2637541.12,0.00,0.00,0.00),('1','136','779','255187',4864477,'2188','334',2856978.53,2857278.98,0.00,0.00,300.45,160594.40,0.00,0.00,0.00),('1','136','779','255232',4864970,'2188','334',2857278.98,2861904.29,0.00,0.00,4625.31,2476875.52,0.00,0.00,0.00),('1','136','779','255471',4869214,'2188','334',2861904.29,2862273.48,0.00,0.00,369.19,200336.48,0.00,0.00,0.00),('1','136','779','255534',4870066,'2188','334',2862273.48,2866370.88,0.00,0.00,4097.40,2200090.80,0.00,0.00,0.00),('1','136','779','255701',4873187,'2188','334',2866370.88,2867479.10,0.00,0.00,1108.22,607119.16,0.00,0.00,0.00),('1','136','779','255867',4875763,'2188','334',2867479.10,2870443.06,0.00,0.00,2963.96,1607188.92,0.00,0.00,0.00),('1','136','779','255946',4876998,'2188','334',2870443.06,2871915.00,0.00,0.00,1471.94,787952.48,0.00,0.00,0.00),('1','136','779','256077',4879334,'2188','334',2871915.00,2874944.17,0.00,0.00,3029.17,1621656.64,0.00,0.00,0.00),('1','136','779','256203',4881191,'2188','334',2874944.17,2877614.13,0.00,0.00,2669.96,1453708.32,0.00,0.00,0.00),('1','136','779','256473',4885925,'2188','334',2877614.13,2881227.15,0.00,0.00,3613.02,1955925.32,0.00,0.00,0.00),('1','136','779','256711',4889826,'2188','334',2881227.15,2885054.27,0.00,0.00,3827.12,2061099.10,0.00,0.00,0.00),('1','136','779','256965',4894129,'2188','334',2885054.27,2888749.33,0.00,0.00,3695.06,1990960.64,0.00,0.00,0.00),('1','136','779','257238',4899114,'2188','334',2888749.33,2893355.49,0.00,0.00,4606.16,2489158.72,0.00,0.00,0.00),('1','136','779','257488',4903512,'2188','334',2893355.49,2895753.86,0.00,0.00,2398.37,1297415.58,0.00,0.00,0.00),('1','136','779','257489',4903513,'2188','334',2895753.86,2896975.24,0.00,0.00,1221.38,647156.64,0.00,0.00,0.00),('1','136','779','257490',4903514,'2188','334',2896975.24,2900433.00,0.00,0.00,3457.76,1850462.02,0.00,0.00,0.00),('1','136','779','257491',4903515,'2188','334',2900433.00,2905848.04,0.00,0.00,5415.04,2840233.30,0.00,0.00,0.00),('1','136','779','257492',4903516,'2188','334',2905848.04,2909687.27,0.00,0.00,3839.23,2030215.96,0.00,0.00,0.00),('1','136','779','257493',4903517,'2188','334',2909687.27,2915225.24,0.00,0.00,5537.97,2897792.96,0.00,0.00,0.00),('1','136','779','257494',4903518,'2188','334',2915225.24,2918635.70,0.00,0.00,3410.46,1817741.72,0.00,0.00,0.00),('1','136','779','257495',4903519,'2188','334',2918635.70,2920497.09,0.00,0.00,1861.39,1009588.60,0.00,0.00,0.00),('1','136','779','257496',4903520,'2188','334',2920497.09,2924297.54,0.00,0.00,3800.45,1991577.50,0.00,0.00,0.00),('1','136','779','257497',4903521,'2188','334',2924297.54,2925576.47,0.00,0.00,1278.93,680952.90,0.00,0.00,0.00),('1','136','779','257498',4903522,'2188','334',2925576.47,2928746.82,0.00,0.00,3170.35,1659716.80,0.00,0.00,0.00),('1','136','779','257499',4903523,'2188','334',2928746.82,2930878.01,0.00,0.00,2131.19,1123102.92,0.00,0.00,0.00),('1','136','779','257500',4903524,'2188','334',2930878.01,2933507.56,0.00,0.00,2629.55,1377356.40,0.00,0.00,0.00),('1','136','779','257501',4903525,'2188','334',2933507.56,2939814.49,0.00,0.00,6306.93,3275443.12,0.00,0.00,0.00),('1','136','779','257502',4903526,'2188','334',2939814.49,2943430.78,0.00,0.00,3616.29,1915584.72,0.00,0.00,0.00),('1','136','779','257503',4903527,'2188','334',2943430.78,2948370.94,0.00,0.00,4940.16,2570195.80,0.00,0.00,0.00),('1','136','779','257504',4903528,'2188','334',2948370.94,2955466.45,0.00,0.00,7095.51,3685760.64,0.00,0.00,0.00),('1','136','779','257505',4903529,'2188','334',2955466.45,2957201.58,0.00,0.00,1735.13,910709.84,0.00,0.00,0.00),('1','136','779','257506',4903530,'2188','334',2957201.58,2960443.09,0.00,0.00,3241.51,1706792.18,0.00,0.00,0.00),('1','136','779','257507',4903531,'2188','334',2960443.09,2962879.87,0.00,0.00,2436.78,1257591.04,0.00,0.00,0.00),('1','136','779','257508',4903532,'2188','334',2962879.87,2968322.25,0.00,0.00,5442.38,2840025.60,0.00,0.00,0.00),('1','136','779','257509',4903533,'2188','334',2968322.25,2975854.47,0.00,0.00,7532.22,3892719.58,0.00,0.00,0.00),('1','136','779','257510',4903534,'2188','334',2975854.47,2980927.67,0.00,0.00,5073.20,2660431.60,0.00,0.00,0.00),('1','136','779','257511',4903535,'2188','334',2980927.67,2984755.24,0.00,0.00,3827.57,1977840.56,0.00,0.00,0.00),('1','136','779','257512',4903536,'2188','334',2984755.24,2987922.00,0.00,0.00,3166.76,1636700.68,0.00,0.00,0.00),('1','136','779','257513',4903537,'2188','334',2987922.00,2989965.79,0.00,0.00,2043.79,1072069.72,0.00,0.00,0.00),('1','136','779','257514',4903538,'2188','334',2989965.79,2991144.36,0.00,0.00,1178.57,630184.76,0.00,0.00,0.00),('1','136','779','257515',4903539,'2188','334',2991144.36,2995114.59,0.00,0.00,3970.23,2104976.80,0.00,0.00,0.00),('1','136','779','257516',4903540,'2188','334',2995114.59,2997894.75,0.00,0.00,2780.16,1431326.88,0.00,0.00,0.00),('1','136','779','257517',4903541,'2188','334',2997894.75,3000381.92,0.00,0.00,2487.17,1332900.56,0.00,0.00,0.00),('1','136','779','257518',4903542,'2188','334',3000381.92,3001316.97,0.00,0.00,935.05,482736.40,0.00,0.00,0.00),('1','136','779','257519',4903543,'2188','334',3001316.97,3004888.83,0.00,0.00,3571.86,1867908.48,0.00,0.00,0.00),('1','136','779','257520',4903544,'2188','334',3004888.83,3009597.28,0.00,0.00,4708.45,2406378.30,0.00,0.00,0.00),('1','136','779','257521',4903545,'2188','334',3009597.28,3013517.38,0.00,0.00,3920.10,2041637.88,0.00,0.00,0.00),('1','136','779','257522',4903546,'2188','334',3013517.38,3017614.26,0.00,0.00,4096.88,2154436.76,0.00,0.00,0.00),('1','136','779','257523',4903547,'2188','334',3017614.26,3021131.07,0.00,0.00,3516.81,1850641.62,0.00,0.00,0.00),('1','136','779','257524',4903548,'2188','334',3021131.07,3024825.96,0.00,0.00,3694.89,1942429.52,0.00,0.00,0.00),('1','136','779','257525',4903549,'2188','334',3024825.96,3029399.39,0.00,0.00,4573.43,2382138.24,0.00,0.00,0.00),('1','136','779','257526',4903550,'2188','334',3029399.39,3030772.10,0.00,0.00,1372.71,730714.26,0.00,0.00,0.00),('1','136','779','257527',4903551,'2188','334',3030772.10,3035322.69,0.00,0.00,4550.59,2388016.04,0.00,0.00,0.00),('1','136','779','257528',4903552,'2188','334',3035322.69,3043643.25,0.00,0.00,8320.56,4318305.08,0.00,0.00,0.00),('1','136','779','257529',4903553,'2188','334',3043643.25,3046505.98,0.00,0.00,2862.73,1495560.32,0.00,0.00,0.00),('1','136','779','257530',4903554,'2188','334',3046505.98,3052186.67,0.00,0.00,5680.69,2970700.92,0.00,0.00,0.00),('1','136','779','257531',4903555,'2188','334',3052186.67,3053995.67,0.00,0.00,1809.00,1012294.00,0.00,0.00,0.00),('1','136','779','257532',4903556,'2188','334',3053995.67,3055695.17,0.00,0.00,1699.50,917890.00,0.00,0.00,0.00),('1','136','779','257533',4903557,'2188','334',3055695.17,3060337.24,0.00,0.00,4642.07,2543307.40,0.00,0.00,0.00),('1','136','779','257534',4903558,'2188','334',3060337.24,3065587.96,0.00,0.00,5250.72,2883937.60,0.00,0.00,0.00),('1','136','779','257535',4903559,'2188','334',3065587.96,3070439.62,0.00,0.00,4851.66,2658690.80,0.00,0.00,0.00),('1','136','779','257536',4903560,'2188','334',3070439.62,3076426.88,0.00,0.00,5987.26,3260215.20,0.00,0.00,0.00),('1','136','779','257537',4903561,'2188','334',3076426.88,3078517.87,0.00,0.00,2090.99,1147434.20,0.00,0.00,0.00),('1','136','779','257538',4903562,'2188','334',3078517.87,3082307.70,0.00,0.00,3789.83,2058419.40,0.00,0.00,0.00),('1','136','779','257539',4903563,'2188','334',3082307.70,3082307.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257540',4903564,'2188','334',3082307.70,3083602.52,0.00,0.00,1294.82,828684.80,0.00,0.00,0.00),('1','136','779','257541',4903565,'2188','334',3083602.52,3084796.84,0.00,0.00,1194.32,764364.80,0.00,0.00,0.00),('1','136','779','257542',4903566,'2188','334',3084796.84,3085944.77,0.00,0.00,1147.93,734675.20,0.00,0.00,0.00),('1','136','779','257543',4903567,'2188','334',3085944.77,3086016.32,0.00,0.00,71.55,45792.00,0.00,0.00,0.00),('1','136','779','257544',4903568,'2188','334',3086016.32,3087404.26,0.00,0.00,1387.94,888281.60,0.00,0.00,0.00),('1','136','779','257545',4903569,'2188','334',3087404.26,3088630.85,0.00,0.00,1226.59,785017.60,0.00,0.00,0.00),('1','136','779','257546',4903570,'2188','334',3088630.85,3090438.61,0.00,0.00,1807.76,1156966.40,0.00,0.00,0.00),('1','136','779','257547',4903571,'2188','334',3090438.61,3091031.89,0.00,0.00,593.28,382990.40,0.00,0.00,0.00),('1','136','779','257548',4903572,'2188','334',3091031.89,3093349.31,0.00,0.00,2317.42,1515584.00,0.00,0.00,0.00),('1','136','779','257549',4903573,'2188','334',3093349.31,3094947.91,0.00,0.00,1598.60,1056600.40,0.00,0.00,0.00),('1','136','779','257550',4903574,'2188','334',3094947.91,3095830.56,0.00,0.00,882.65,477833.00,0.00,0.00,0.00),('1','136','779','257551',4903575,'2188','334',3095830.56,3097296.09,0.00,0.00,1465.53,968840.40,0.00,0.00,0.00),('1','136','779','257552',4903576,'2188','334',3097296.09,3099880.88,0.00,0.00,2584.79,1610843.68,0.00,0.00,0.00),('1','136','779','257553',4903577,'2188','334',3099880.88,3103219.39,0.00,0.00,3338.51,2106514.80,0.00,0.00,0.00),('1','136','779','257554',4903578,'2188','334',3103219.39,3106772.64,0.00,0.00,3553.25,2236642.64,0.00,0.00,0.00),('1','136','779','257555',4903579,'2188','334',3106772.64,3109542.77,0.00,0.00,2770.13,1760570.56,0.00,0.00,0.00),('1','136','779','257556',4903580,'2188','334',3109542.77,3113445.11,0.00,0.00,3902.34,2437083.36,0.00,0.00,0.00),('1','136','779','257557',4903581,'2188','334',3113445.11,3116539.17,0.00,0.00,3094.06,1939665.60,0.00,0.00,0.00),('1','136','779','257558',4903582,'2188','334',3116539.17,3116712.54,0.00,0.00,173.37,105408.96,0.00,0.00,0.00),('1','136','779','257559',4903583,'2188','334',3116712.54,3119235.78,0.00,0.00,2523.24,1581645.60,0.00,0.00,0.00),('1','136','779','257560',4903584,'2188','334',3119235.78,3121258.39,0.00,0.00,2022.61,1293666.80,0.00,0.00,0.00),('1','136','779','257561',4903585,'2188','334',3121258.39,3125413.79,0.00,0.00,4155.40,2601074.48,0.00,0.00,0.00),('1','136','779','257562',4903586,'2188','334',3125413.79,3130011.71,0.00,0.00,4597.92,2936213.36,0.00,0.00,0.00),('1','136','779','257563',4903587,'2188','334',3130011.71,3132992.17,0.00,0.00,2980.46,1920964.48,0.00,0.00,0.00),('1','136','779','257564',4903588,'2188','334',3132992.17,3136223.50,0.00,0.00,3231.33,2062795.04,0.00,0.00,0.00),('1','136','779','257565',4903589,'2188','334',3136223.50,3139988.90,0.00,0.00,3765.40,2397603.96,0.00,0.00,0.00),('1','136','779','257566',4903590,'2188','334',3139988.90,3141466.92,0.00,0.00,1478.02,928179.64,0.00,0.00,0.00),('1','136','779','257567',4903591,'2188','334',3141466.92,3142215.46,0.00,0.00,748.54,481534.56,0.00,0.00,0.00),('1','136','779','257568',4903592,'2188','334',3142215.46,3143982.80,0.00,0.00,1767.34,1141875.92,0.00,0.00,0.00),('1','136','779','257569',4903593,'2188','334',3143982.80,3148105.18,0.00,0.00,4122.38,2602009.36,0.00,0.00,0.00),('1','136','779','257570',4903594,'2188','334',3148105.18,3154677.26,0.00,0.00,6572.08,4101808.32,0.00,0.00,0.00),('1','136','779','257571',4903595,'2188','334',3154677.26,3160785.71,0.00,0.00,6108.45,3783880.80,0.00,0.00,0.00),('1','136','779','257572',4903596,'2188','334',3160785.71,3165306.92,0.00,0.00,4521.21,2780940.62,0.00,0.00,0.00),('1','136','779','257573',4903597,'2188','334',3165306.92,3166051.62,0.00,0.00,744.70,450879.80,0.00,0.00,0.00),('1','136','779','257574',4903598,'2188','334',3166051.62,3169052.09,0.00,0.00,3000.47,1828257.08,0.00,0.00,0.00),('1','136','779','257575',4903599,'2188','334',3169052.09,3171180.40,0.00,0.00,2128.31,1315877.05,0.00,0.00,0.00),('1','136','779','257576',4903600,'2188','334',3171180.40,3172170.84,0.00,0.00,990.44,600992.69,0.00,0.00,0.00),('1','136','779','257577',4903601,'2188','334',3172170.84,3175026.57,0.00,0.00,2855.73,1780952.93,0.00,0.00,0.00),('1','136','779','257578',4903602,'2188','334',3175026.57,3178229.26,0.00,0.00,3202.69,1964984.41,0.00,0.00,0.00),('1','136','779','257579',4903603,'2188','334',3178229.26,3179005.99,0.00,0.00,776.73,485183.18,0.00,0.00,0.00),('1','136','779','257580',4903604,'2188','334',3179005.99,3180036.06,0.00,0.00,1030.07,683966.48,0.00,0.00,0.00),('1','136','779','257581',4903605,'2188','334',3180036.06,3181319.29,0.00,0.00,1283.23,852064.72,0.00,0.00,0.00),('1','136','779','257582',4903606,'2188','334',3181319.29,3183188.53,0.00,0.00,1869.24,1241175.36,0.00,0.00,0.00),('1','136','779','257583',4903607,'2188','334',3183188.53,3183994.74,0.00,0.00,806.21,535323.44,0.00,0.00,0.00),('1','136','779','257584',4903608,'2188','334',3183994.74,3184930.21,0.00,0.00,935.47,621152.08,0.00,0.00,0.00),('1','136','779','257585',4903609,'2188','334',3184930.21,3185906.56,0.00,0.00,976.35,648296.40,0.00,0.00,0.00),('1','136','779','257586',4903610,'2188','334',3185906.56,3188404.27,0.00,0.00,2497.71,1658479.44,0.00,0.00,0.00),('1','136','779','257587',4903611,'2188','334',3188404.27,3188404.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257588',4903612,'2188','334',3188404.27,3188482.61,0.00,0.00,78.34,52017.76,0.00,0.00,0.00),('1','136','779','257589',4903613,'2188','334',3188482.61,3190464.14,0.00,0.00,1981.53,1315735.92,0.00,0.00,0.00),('1','136','779','257590',4903614,'2188','334',3190464.14,3190791.80,0.00,0.00,327.66,203671.74,0.00,0.00,0.00),('1','136','779','257591',4903615,'2188','334',3190791.80,3193179.06,0.00,0.00,2387.26,1503376.96,0.00,0.00,0.00),('1','136','779','257592',4903616,'2188','334',3193179.06,3193750.19,0.00,0.00,571.13,351423.62,0.00,0.00,0.00),('1','136','779','257593',4903617,'2188','334',3193750.19,3197334.82,0.00,0.00,3584.63,2212529.26,0.00,0.00,0.00),('1','136','779','257594',4903618,'2188','334',3197334.82,3198942.34,0.00,0.00,1607.52,990458.07,0.00,0.00,0.00),('1','136','779','257595',4903619,'2188','334',3198942.34,3198942.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257596',4903620,'2188','334',3198942.34,3201216.82,0.00,0.00,2274.48,1397751.36,0.00,0.00,0.00),('1','136','779','257597',4903621,'2188','334',3201216.82,3204586.47,0.00,0.00,3369.65,2071246.24,0.00,0.00,0.00),('1','136','779','257598',4903622,'2188','334',3204586.47,3209407.52,0.00,0.00,4821.05,2936063.20,0.00,0.00,0.00),('1','136','779','257599',4903623,'2188','334',3209407.52,3212137.79,0.00,0.00,2730.27,1700450.34,0.00,0.00,0.00),('1','136','779','257600',4903624,'2188','334',3212137.79,3215647.33,0.00,0.00,3509.54,2169631.20,0.00,0.00,0.00),('1','136','779','257601',4903625,'2188','334',3215647.33,3219430.35,0.00,0.00,3783.02,2326775.94,0.00,0.00,0.00),('1','136','779','257602',4903626,'2188','334',3219430.35,3223410.35,0.00,0.00,3980.00,2408937.62,0.00,0.00,0.00),('1','136','779','257603',4903627,'2188','334',3223410.35,3223410.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257604',4903628,'2188','334',3223410.35,3224181.70,0.00,0.00,771.35,483257.84,0.00,0.00,0.00),('1','136','779','257605',4903629,'2188','334',3224181.70,3226333.90,0.00,0.00,2152.20,1337606.94,0.00,0.00,0.00),('1','136','779','257606',4903630,'2188','334',3226333.90,3230041.83,0.00,0.00,3707.93,2272889.36,0.00,0.00,0.00),('1','136','779','257607',4903631,'2188','334',3230041.83,3236741.32,0.00,0.00,6699.49,4059462.04,0.00,0.00,0.00),('1','136','779','257608',4903632,'2188','334',3236741.32,3240832.48,0.00,0.00,4091.16,2543299.88,0.00,0.00,0.00),('1','136','779','257609',4903633,'2188','334',3240832.48,3247692.70,0.00,0.00,6860.22,4213468.08,0.00,0.00,0.00),('1','136','779','257610',4903634,'2188','334',3247692.70,3248450.69,0.00,0.00,757.99,468900.22,0.00,0.00,0.00),('1','136','779','257611',4903635,'2188','334',3248450.69,3248764.40,0.00,0.00,313.71,187598.58,0.00,0.00,0.00),('1','136','779','257612',4903636,'2188','334',3248764.40,3253559.47,0.00,0.00,4795.07,2927824.42,0.00,0.00,0.00),('1','136','779','257613',4903637,'2188','334',3253559.47,3257808.89,0.00,0.00,4249.42,2589327.88,0.00,0.00,0.00),('1','136','779','257614',4903638,'2188','334',3257808.89,3262588.87,0.00,0.00,4779.98,2907548.46,0.00,0.00,0.00),('1','136','779','257615',4903639,'2188','334',3262588.87,3268311.25,0.00,0.00,5722.38,3498758.74,0.00,0.00,0.00),('1','136','779','257616',4903640,'2188','334',3268311.25,3271697.47,0.00,0.00,3386.22,2099725.68,0.00,0.00,0.00),('1','136','779','257617',4903641,'2188','334',3271697.47,3273474.68,0.00,0.00,1777.21,1087078.06,0.00,0.00,0.00),('1','136','779','257618',4903642,'2188','334',3273474.68,3275943.05,0.00,0.00,2468.37,1507195.68,0.00,0.00,0.00),('1','136','779','257619',4903643,'2188','334',3275943.05,3278747.29,0.00,0.00,2804.24,1716294.26,0.00,0.00,0.00),('1','136','779','257620',4903644,'2188','334',3278747.29,3281998.00,0.00,0.00,3250.71,1993538.44,0.00,0.00,0.00),('1','136','779','257621',4903645,'2188','334',3281998.00,3282568.70,0.00,0.00,570.70,346829.20,0.00,0.00,0.00),('1','136','779','257622',4903646,'2188','334',3282568.70,3283465.71,0.00,0.00,897.01,595614.64,0.00,0.00,0.00),('1','136','779','257623',4903647,'2188','334',3283465.71,3284800.85,0.00,0.00,1335.14,886532.96,0.00,0.00,0.00),('1','136','779','257624',4903648,'2188','334',3284800.85,3285306.45,0.00,0.00,505.60,304038.40,0.00,0.00,0.00),('1','136','779','257625',4903649,'2188','334',3285306.45,3285306.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257626',4903650,'2188','334',3285306.45,3285786.82,0.00,0.00,480.37,318965.68,0.00,0.00,0.00),('1','136','779','257627',4903651,'2188','334',3285786.82,3286710.90,0.00,0.00,924.08,613589.12,0.00,0.00,0.00),('1','136','779','257628',4903652,'2188','334',3286710.90,3287180.99,0.00,0.00,470.09,285805.76,0.00,0.00,0.00),('1','136','779','257629',4903653,'2188','334',3287180.99,3287180.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257630',4903654,'2188','334',3287180.99,3288561.25,0.00,0.00,1380.26,916492.64,0.00,0.00,0.00),('1','136','779','257631',4903655,'2188','334',3288561.25,3290471.68,0.00,0.00,1910.43,1268525.52,0.00,0.00,0.00),('1','136','779','257632',4903656,'2188','334',3290471.68,3291917.04,0.00,0.00,1445.36,982844.80,0.00,0.00,0.00),('1','136','779','257633',4903657,'2188','334',3291917.04,3292249.20,0.00,0.00,332.16,203400.80,0.00,0.00,0.00),('1','136','779','257634',4903658,'2188','334',3292249.20,3292249.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257635',4903659,'2188','334',3292249.20,3292818.11,0.00,0.00,568.91,386858.80,0.00,0.00,0.00),('1','136','779','257636',4903660,'2188','334',3292818.11,3294153.44,0.00,0.00,1335.33,908024.40,0.00,0.00,0.00),('1','136','779','257637',4903661,'2188','334',3294153.44,3294496.28,0.00,0.00,342.84,218593.20,0.00,0.00,0.00),('1','136','779','257638',4903662,'2188','334',3294496.28,3294496.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257639',4903663,'2188','334',3294496.28,3295695.00,0.00,0.00,1198.72,815129.60,0.00,0.00,0.00),('1','136','779','257640',4903664,'2188','334',3295695.00,3297361.35,0.00,0.00,1666.35,1133118.00,0.00,0.00,0.00),('1','136','779','257641',4903665,'2188','334',3297361.35,3297987.34,0.00,0.00,625.99,406053.20,0.00,0.00,0.00),('1','136','779','257642',4903666,'2188','334',3297987.34,3297987.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257643',4903667,'2188','334',3297987.34,3298276.43,0.00,0.00,289.09,196581.20,0.00,0.00,0.00),('1','136','779','257644',4903668,'2188','334',3298276.43,3300428.24,0.00,0.00,2151.81,1463230.80,0.00,0.00,0.00),('1','136','779','257645',4903669,'2188','334',3300428.24,3300939.94,0.00,0.00,511.70,317254.00,0.00,0.00,0.00),('1','136','779','257646',4903670,'2188','334',3300939.94,3300939.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257647',4903671,'2188','334',3300939.94,3302861.50,0.00,0.00,1921.56,1306660.80,0.00,0.00,0.00),('1','136','779','257648',4903672,'2188','334',3302861.50,3304135.20,0.00,0.00,1273.70,866116.00,0.00,0.00,0.00),('1','136','779','257649',4903673,'2188','334',3304135.20,3305579.91,0.00,0.00,1444.71,982402.80,0.00,0.00,0.00),('1','136','779','257650',4903674,'2188','334',3305579.91,3305834.54,0.00,0.00,254.63,161088.40,0.00,0.00,0.00),('1','136','779','257651',4903675,'2188','334',3305834.54,3305834.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257652',4903676,'2188','334',3305834.54,3307717.66,0.00,0.00,1883.12,1327880.06,0.00,0.00,0.00),('1','136','779','257653',4903677,'2188','334',3307717.66,3309676.02,0.00,0.00,1958.36,1376093.49,0.00,0.00,0.00),('1','136','779','257654',4903678,'2188','334',3309676.02,3312740.76,0.00,0.00,3064.74,2115450.60,0.00,0.00,0.00),('1','136','779','257655',4903679,'2188','334',3312740.76,3316329.81,0.00,0.00,3589.05,2485577.30,0.00,0.00,0.00),('1','136','779','257656',4903680,'2188','334',3316329.81,3320993.19,0.00,0.00,4663.38,3216970.83,0.00,0.00,0.00),('1','136','779','257657',4903681,'2188','334',3320993.19,3327417.37,0.00,0.00,6424.18,4397876.39,0.00,0.00,0.00),('1','136','779','257658',4903682,'2188','334',3327417.37,3330324.53,0.00,0.00,2907.16,2085808.96,0.00,0.00,0.00),('1','136','779','257659',4903683,'2188','334',3330324.53,3330324.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257660',4903684,'2188','334',3330324.53,3332217.94,0.00,0.00,1893.41,1363683.60,0.00,0.00,0.00),('1','136','779','257661',4903685,'2188','334',3332217.94,3334212.64,0.00,0.00,1994.70,1418274.60,0.00,0.00,0.00),('1','136','779','257662',4903686,'2188','334',3334212.64,3334212.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257663',4903687,'2188','334',3334212.64,3335802.86,0.00,0.00,1590.22,1139587.20,0.00,0.00,0.00),('1','136','779','257664',4903688,'2188','334',3335802.86,3336890.11,0.00,0.00,1087.25,766540.20,0.00,0.00,0.00),('1','136','779','257665',4903689,'2188','334',3336890.11,3336890.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257666',4903690,'2188','334',3336890.11,3340754.71,0.00,0.00,3864.60,2745449.80,0.00,0.00,0.00),('1','136','779','257667',4903691,'2188','334',3340754.71,3340754.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257668',4903692,'2188','334',3340754.71,3345135.74,0.00,0.00,4381.03,3146570.40,0.00,0.00,0.00),('1','136','779','257669',4903693,'2188','334',3345135.74,3346149.04,0.00,0.00,1013.30,716357.00,0.00,0.00,0.00),('1','136','779','257670',4903694,'2188','334',3346149.04,3346149.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257671',4903695,'2188','334',3346149.04,3353654.94,0.00,0.00,7505.90,5335408.32,0.00,0.00,0.00),('1','136','779','257672',4903696,'2188','334',3353654.94,3359004.85,0.00,0.00,5349.91,3822383.44,0.00,0.00,0.00),('1','136','779','257673',4903697,'2188','334',3359004.85,3362244.42,0.00,0.00,3239.57,2392697.20,0.00,0.00,0.00),('1','136','779','257674',4903698,'2188','334',3362244.42,3363755.82,0.00,0.00,1511.40,1148664.00,0.00,0.00,0.00),('1','136','779','257675',4903699,'2188','334',3363755.82,3365418.61,0.00,0.00,1662.79,1263720.40,0.00,0.00,0.00),('1','136','779','257676',4903700,'2188','334',3365418.61,3367166.80,0.00,0.00,1748.19,1328624.40,0.00,0.00,0.00),('1','136','779','257677',4903701,'2188','334',3367166.80,3370782.18,0.00,0.00,3615.38,2747688.80,0.00,0.00,0.00),('1','136','779','257678',4903702,'2188','334',3370782.18,3370782.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257679',4903703,'2188','334',3370782.18,3373701.45,0.00,0.00,2919.27,2218645.20,0.00,0.00,0.00),('1','136','779','257680',4903704,'2188','334',3373701.45,3376635.80,0.00,0.00,2934.35,2230106.00,0.00,0.00,0.00),('1','136','779','257681',4903705,'2188','334',3376635.80,3376635.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257682',4903706,'2188','334',3376635.80,3380049.41,0.00,0.00,3413.61,2594343.60,0.00,0.00,0.00),('1','136','779','257683',4903707,'2188','334',3380049.41,3381846.13,0.00,0.00,1796.72,1365507.20,0.00,0.00,0.00),('1','136','779','257684',4903708,'2188','334',3381846.13,3381846.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257685',4903709,'2188','334',3381846.13,3382736.53,0.00,0.00,890.40,676704.00,0.00,0.00,0.00),('1','136','779','257686',4903710,'2188','334',3382736.53,3385148.51,0.00,0.00,2411.98,1833104.80,0.00,0.00,0.00),('1','136','779','257687',4903711,'2188','334',3385148.51,3387110.15,0.00,0.00,1961.64,1490846.40,0.00,0.00,0.00),('1','136','779','257688',4903712,'2188','334',3387110.15,3387110.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257689',4903713,'2188','334',3387110.15,3387799.55,0.00,0.00,689.40,523944.00,0.00,0.00,0.00),('1','136','779','257690',4903714,'2188','334',3387799.55,3389863.24,0.00,0.00,2063.69,1568404.40,0.00,0.00,0.00),('1','136','779','257691',4903715,'2188','334',3389863.24,3391704.08,0.00,0.00,1840.84,1399038.40,0.00,0.00,0.00),('1','136','779','257692',4903716,'2188','334',3391704.08,3391704.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257693',4903717,'2188','334',3391704.08,3392193.67,0.00,0.00,489.59,372088.40,0.00,0.00,0.00),('1','136','779','257694',4903718,'2188','334',3392193.67,3394937.05,0.00,0.00,2743.38,2084968.80,0.00,0.00,0.00),('1','136','779','257695',4903719,'2188','334',3394937.05,3396012.51,0.00,0.00,1075.46,817349.60,0.00,0.00,0.00),('1','136','779','257696',4903720,'2188','334',3396012.51,3396925.18,0.00,0.00,912.67,693629.20,0.00,0.00,0.00),('1','136','779','257697',4903721,'2188','334',3396925.18,3396925.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257698',4903722,'2188','334',3396925.18,3398211.62,0.00,0.00,1286.44,977694.40,0.00,0.00,0.00),('1','136','779','257699',4903723,'2188','334',3398211.62,3400259.67,0.00,0.00,2048.05,1556518.00,0.00,0.00,0.00),('1','136','779','257700',4903724,'2188','334',3400259.67,3401757.16,0.00,0.00,1497.49,1138092.40,0.00,0.00,0.00),('1','136','779','257701',4903725,'2188','334',3401757.16,3402832.28,0.00,0.00,1075.12,795460.00,0.00,0.00,0.00),('1','136','779','257702',4903726,'2188','334',3402832.28,3402832.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257703',4903727,'2188','334',3402832.28,3403817.52,0.00,0.00,985.24,737548.40,0.00,0.00,0.00),('1','136','779','257704',4903728,'2188','334',3403817.52,3406759.21,0.00,0.00,2941.69,2175728.00,0.00,0.00,0.00),('1','136','779','257705',4903729,'2188','334',3406759.21,3410727.57,0.00,0.00,3968.36,2905813.36,0.00,0.00,0.00),('1','136','779','257706',4903730,'2188','334',3410727.57,3413029.66,0.00,0.00,2302.09,1697979.20,0.00,0.00,0.00),('1','136','779','257707',4903731,'2188','334',3413029.66,3416009.43,0.00,0.00,2979.77,2185173.40,0.00,0.00,0.00),('1','136','779','257708',4903732,'2188','334',3416009.43,3418584.23,0.00,0.00,2574.80,1903708.00,0.00,0.00,0.00),('1','136','779','257709',4903733,'2188','334',3418584.23,3421555.78,0.00,0.00,2971.55,2183085.60,0.00,0.00,0.00),('1','136','779','257710',4903734,'2188','334',3421555.78,3424639.47,0.00,0.00,3083.69,2262191.44,0.00,0.00,0.00),('1','136','779','257711',4903735,'2188','334',3424639.47,3427196.75,0.00,0.00,2557.28,1875927.04,0.00,0.00,0.00),('1','136','779','257712',4903736,'2188','334',3427196.75,3427196.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257713',4903737,'2188','334',3427196.75,3427196.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257714',4903738,'2188','334',3427196.75,3428895.86,0.00,0.00,1699.11,1225385.16,0.00,0.00,0.00),('1','136','779','257715',4903739,'2188','334',3428895.86,3433248.74,0.00,0.00,4352.88,3189169.64,0.00,0.00,0.00),('1','136','779','257716',4903740,'2188','334',3433248.74,3435558.01,0.00,0.00,2309.27,1712839.60,0.00,0.00,0.00),('1','136','779','257717',4903741,'2188','334',3435558.01,3439416.22,0.00,0.00,3858.21,2819267.60,0.00,0.00,0.00),('1','136','779','257718',4903742,'2188','334',3439416.22,3441823.45,0.00,0.00,2407.23,1794393.20,0.00,0.00,0.00),('1','136','779','257719',4903743,'2188','334',3441823.45,3445048.70,0.00,0.00,3225.25,2368665.56,0.00,0.00,0.00),('1','136','779','257720',4903744,'2188','334',3445048.70,3448203.94,0.00,0.00,3155.24,2325088.24,0.00,0.00,0.00),('1','136','779','257721',4903745,'2188','334',3448203.94,3450913.13,0.00,0.00,2709.19,1987644.40,0.00,0.00,0.00),('1','136','779','257722',4903746,'2188','334',3450913.13,3451786.33,0.00,0.00,873.20,628125.52,0.00,0.00,0.00),('1','136','779','257723',4903747,'2188','334',3451786.33,3451786.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257724',4903748,'2188','334',3451786.33,3454488.81,0.00,0.00,2702.48,1973115.28,0.00,0.00,0.00),('1','136','779','257725',4903749,'2188','334',3454488.81,3455976.00,0.00,0.00,1487.19,1130264.40,0.00,0.00,0.00),('1','136','779','257726',4903750,'2188','334',3455976.00,3456801.14,0.00,0.00,825.14,595691.60,0.00,0.00,0.00),('1','136','779','257727',4903751,'2188','334',3456801.14,3456801.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257728',4903752,'2188','334',3456801.14,3457789.17,0.00,0.00,988.03,750902.80,0.00,0.00,0.00),('1','136','779','257729',4903753,'2188','334',3457789.17,3459328.10,0.00,0.00,1538.93,1169586.80,0.00,0.00,0.00),('1','136','779','257730',4903754,'2188','334',3459328.10,3460749.55,0.00,0.00,1421.45,1080302.00,0.00,0.00,0.00),('1','136','779','257731',4903755,'2188','334',3460749.55,3462746.73,0.00,0.00,1997.18,1517856.80,0.00,0.00,0.00),('1','136','779','257732',4903756,'2188','334',3462746.73,3464303.73,0.00,0.00,1557.00,1183320.00,0.00,0.00,0.00),('1','136','779','257733',4903757,'2188','334',3464303.73,3464798.73,0.00,0.00,495.00,356400.00,0.00,0.00,0.00),('1','136','779','257734',4903758,'2188','334',3464798.73,3464798.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257735',4903759,'2188','334',3464798.73,3466105.48,0.00,0.00,1306.75,979454.80,0.00,0.00,0.00),('1','136','779','257736',4903760,'2188','334',3466105.48,3468581.29,0.00,0.00,2475.81,1799997.68,0.00,0.00,0.00),('1','136','779','257737',4903761,'2188','334',3468581.29,3469962.84,0.00,0.00,1381.55,1003285.84,0.00,0.00,0.00),('1','136','779','257738',4903762,'2188','334',3469962.84,3469962.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257739',4903763,'2188','334',3469962.84,3470867.40,0.00,0.00,904.56,670561.40,0.00,0.00,0.00),('1','136','779','257740',4903764,'2188','334',3470867.40,3473999.55,0.00,0.00,3132.15,2266375.04,0.00,0.00,0.00),('1','136','779','257741',4903765,'2188','334',3473999.55,3476024.97,0.00,0.00,2025.42,1495200.00,0.00,0.00,0.00),('1','136','779','257742',4903766,'2188','334',3476024.97,3479613.46,0.00,0.00,3588.49,2546048.56,0.00,0.00,0.00),('1','136','779','257743',4903767,'2188','334',3479613.46,3483138.19,0.00,0.00,3524.73,2514017.49,0.00,0.00,0.00),('1','136','779','257744',4903768,'2188','334',3483138.19,3485529.46,0.00,0.00,2391.27,1719006.38,0.00,0.00,0.00),('1','136','779','257745',4903769,'2188','334',3485529.46,3489711.42,0.00,0.00,4181.96,2955594.15,0.00,0.00,0.00),('1','136','779','257746',4903770,'2188','334',3489711.42,3493728.73,0.00,0.00,4017.31,2856503.44,0.00,0.00,0.00),('1','136','779','257747',4903771,'2188','334',3493728.73,3494556.43,0.00,0.00,827.70,576895.87,0.00,0.00,0.00),('1','136','779','257748',4903772,'2188','334',3494556.43,3494556.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257749',4903773,'2188','334',3494556.43,3498742.40,0.00,0.00,4185.97,2935159.04,0.00,0.00,0.00),('1','136','779','257750',4903774,'2188','334',3498742.40,3501430.02,0.00,0.00,2687.62,1908876.17,0.00,0.00,0.00),('1','136','779','257751',4903775,'2188','334',3501430.02,3506322.82,0.00,0.00,4892.80,3473088.53,0.00,0.00,0.00),('1','136','779','257752',4903776,'2188','334',3506322.82,3513086.47,0.00,0.00,6763.65,4777253.10,0.00,0.00,0.00),('1','136','779','257753',4903777,'2188','334',3513086.47,3516232.07,0.00,0.00,3145.60,2249676.40,0.00,0.00,0.00),('1','136','779','257754',4903778,'2188','334',3516232.07,3519202.88,0.00,0.00,2970.81,2106618.64,0.00,0.00,0.00),('1','136','779','257755',4903779,'2188','334',3519202.88,3519202.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257756',4903780,'2188','334',3519202.88,3520101.18,0.00,0.00,898.30,668335.20,0.00,0.00,0.00),('1','136','779','257757',4903781,'2188','334',3520101.18,3521810.76,0.00,0.00,1709.58,1271927.52,0.00,0.00,0.00),('1','136','779','257758',4903782,'2188','334',3521810.76,3523293.24,0.00,0.00,1482.48,1092430.12,0.00,0.00,0.00),('1','136','779','257759',4903783,'2188','334',3523293.24,3523293.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257760',4903784,'2188','334',3523293.24,3524753.76,0.00,0.00,1460.52,1045628.58,0.00,0.00,0.00),('1','136','779','257761',4903785,'2188','334',3524753.76,3530813.42,0.00,0.00,6059.66,4286271.04,0.00,0.00,0.00),('1','136','779','257762',4903786,'2188','334',3530813.42,3537142.78,0.00,0.00,6329.36,4483300.84,0.00,0.00,0.00),('1','136','779','257763',4903787,'2188','334',3537142.78,3544905.23,0.00,0.00,7762.45,5481779.80,0.00,0.00,0.00),('1','136','779','257764',4903788,'2188','334',3544905.23,3546567.32,0.00,0.00,1662.09,1263188.40,0.00,0.00,0.00),('1','136','779','257765',4903789,'2188','334',3546567.32,3547454.14,0.00,0.00,886.82,642913.20,0.00,0.00,0.00),('1','136','779','257766',4903790,'2188','334',3547454.14,3547454.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257767',4903791,'2188','334',3547454.14,3548554.24,0.00,0.00,1100.10,836076.00,0.00,0.00,0.00),('1','136','779','257768',4903792,'2188','334',3548554.24,3550548.76,0.00,0.00,1994.52,1515835.20,0.00,0.00,0.00),('1','136','779','257769',4903793,'2188','334',3550548.76,3552100.36,0.00,0.00,1551.60,1179216.00,0.00,0.00,0.00),('1','136','779','257770',4903794,'2188','334',3552100.36,3553123.13,0.00,0.00,1022.77,747055.20,0.00,0.00,0.00),('1','136','779','257771',4903795,'2188','334',3553123.13,3553123.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257772',4903796,'2188','334',3553123.13,3554101.77,0.00,0.00,978.64,743766.40,0.00,0.00,0.00),('1','136','779','257773',4903797,'2188','334',3554101.77,3556379.58,0.00,0.00,2277.81,1731135.60,0.00,0.00,0.00),('1','136','779','257774',4903798,'2188','334',3556379.58,3558822.82,0.00,0.00,2443.24,1856862.40,0.00,0.00,0.00),('1','136','779','257775',4903799,'2188','334',3558822.82,3559379.69,0.00,0.00,556.87,404046.20,0.00,0.00,0.00),('1','136','779','257776',4903800,'2188','334',3559379.69,3559379.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257777',4903801,'2188','334',3559379.69,3560853.47,0.00,0.00,1473.78,1120072.80,0.00,0.00,0.00),('1','136','779','257778',4903802,'2188','334',3560853.47,3563831.92,0.00,0.00,2978.45,2154095.44,0.00,0.00,0.00),('1','136','779','257779',4903803,'2188','334',3563831.92,3564872.31,0.00,0.00,1040.39,740666.88,0.00,0.00,0.00),('1','136','779','257780',4903804,'2188','334',3564872.31,3564872.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257781',4903805,'2188','334',3564872.31,3566929.97,0.00,0.00,2057.66,1486685.04,0.00,0.00,0.00),('1','136','779','257782',4903806,'2188','334',3566929.97,3569703.02,0.00,0.00,2773.05,2010195.70,0.00,0.00,0.00),('1','136','779','257783',4903807,'2188','334',3569703.02,3571981.30,0.00,0.00,2278.28,1651232.70,0.00,0.00,0.00),('1','136','779','257784',4903808,'2188','334',3571981.30,3575344.51,0.00,0.00,3363.21,2437742.96,0.00,0.00,0.00),('1','136','779','257785',4903809,'2188','334',3575344.51,3578310.95,0.00,0.00,2966.44,2148047.14,0.00,0.00,0.00),('1','136','779','257786',4903810,'2188','334',3578310.95,3580315.15,0.00,0.00,2004.20,1477150.80,0.00,0.00,0.00),('1','136','779','257787',4903811,'2188','334',3580315.15,3583776.29,0.00,0.00,3461.14,2500059.16,0.00,0.00,0.00),('1','136','779','257788',4903812,'2188','334',3583776.29,3585611.60,0.00,0.00,1835.31,1348861.64,0.00,0.00,0.00),('1','136','779','257789',4903813,'2188','334',3585611.60,3588136.15,0.00,0.00,2524.55,1840512.20,0.00,0.00,0.00),('1','136','779','257790',4903814,'2188','334',3588136.15,3589025.63,0.00,0.00,889.48,650634.72,0.00,0.00,0.00),('1','136','779','257791',4903815,'2188','334',3589025.63,3589325.39,0.00,0.00,299.76,213679.60,0.00,0.00,0.00),('1','136','779','257792',4903816,'2188','334',3589325.39,3589325.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257793',4903817,'2188','334',3589325.39,3591503.57,0.00,0.00,2178.18,1586715.22,0.00,0.00,0.00),('1','136','779','257794',4903818,'2188','334',3591503.57,3594418.61,0.00,0.00,2915.04,2099371.80,0.00,0.00,0.00),('1','136','779','257795',4903819,'2188','334',3594418.61,3594418.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257796',4903820,'2188','334',3594418.61,3594642.58,0.00,0.00,223.97,166633.68,0.00,0.00,0.00),('1','136','779','257797',4903821,'2188','334',3594642.58,3597143.43,0.00,0.00,2500.85,1811755.26,0.00,0.00,0.00),('1','136','779','257798',4903822,'2188','334',3597143.43,3600235.27,0.00,0.00,3091.84,2227640.18,0.00,0.00,0.00),('1','136','779','257799',4903823,'2188','334',3600235.27,3601150.92,0.00,0.00,915.65,667102.32,0.00,0.00,0.00),('1','136','779','257800',4903824,'2188','334',3601150.92,3601150.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257801',4903825,'2188','334',3601150.92,3601765.57,0.00,0.00,614.65,457299.60,0.00,0.00,0.00),('1','136','779','257802',4903826,'2188','334',3601765.57,3604835.60,0.00,0.00,3070.03,2236512.32,0.00,0.00,0.00),('1','136','779','257803',4903827,'2188','334',3604835.60,3606524.72,0.00,0.00,1689.12,1242938.00,0.00,0.00,0.00),('1','136','779','257804',4903828,'2188','334',3606524.72,3610696.66,0.00,0.00,4171.94,3019823.94,0.00,0.00,0.00),('1','136','779','257805',4903829,'2188','334',3610696.66,3614663.81,0.00,0.00,3967.15,2861661.12,0.00,0.00,0.00),('1','136','779','257806',4903830,'2188','334',3614663.81,3616613.15,0.00,0.00,1949.34,1426990.74,0.00,0.00,0.00),('1','136','779','257807',4903831,'2188','334',3616613.15,3619264.94,0.00,0.00,2651.79,1910390.72,0.00,0.00,0.00),('1','136','779','257808',4903832,'2188','334',3619264.94,3621255.29,0.00,0.00,1990.35,1450213.56,0.00,0.00,0.00),('1','136','779','257809',4903833,'2188','334',3621255.29,3623005.59,0.00,0.00,1750.30,1277700.24,0.00,0.00,0.00),('1','136','779','257810',4903834,'2188','334',3623005.59,3625242.15,0.00,0.00,2236.56,1664000.64,0.00,0.00,0.00),('1','136','779','257811',4903835,'2188','334',3625242.15,3625486.69,0.00,0.00,244.54,181937.76,0.00,0.00,0.00),('1','136','779','257812',4903836,'2188','334',3625486.69,3625486.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257813',4903837,'2188','334',3625486.69,3628626.93,0.00,0.00,3140.24,2286418.56,0.00,0.00,0.00),('1','136','779','257814',4903838,'2188','334',3628626.93,3630346.53,0.00,0.00,1719.60,1279382.40,0.00,0.00,0.00),('1','136','779','257815',4903839,'2188','334',3630346.53,3630518.74,0.00,0.00,172.21,128124.24,0.00,0.00,0.00),('1','136','779','257816',4903840,'2188','334',3630518.74,3630518.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257817',4903841,'2188','334',3630518.74,3633361.66,0.00,0.00,2842.92,2068332.48,0.00,0.00,0.00),('1','136','779','257818',4903842,'2188','334',3633361.66,3635312.75,0.00,0.00,1951.09,1451610.96,0.00,0.00,0.00),('1','136','779','257819',4903843,'2188','334',3635312.75,3635617.39,0.00,0.00,304.64,218794.64,0.00,0.00,0.00),('1','136','779','257820',4903844,'2188','334',3635617.39,3635617.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257821',4903845,'2188','334',3635617.39,3637994.59,0.00,0.00,2377.20,1749619.20,0.00,0.00,0.00),('1','136','779','257822',4903846,'2188','334',3637994.59,3639731.10,0.00,0.00,1736.51,1278071.36,0.00,0.00,0.00),('1','136','779','257823',4903847,'2188','334',3639731.10,3639882.16,0.00,0.00,151.06,105742.00,0.00,0.00,0.00),('1','136','779','257824',4903848,'2188','334',3639882.16,3639882.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257825',4903849,'2188','334',3639882.16,3641551.18,0.00,0.00,1669.02,1228398.72,0.00,0.00,0.00),('1','136','779','257826',4903850,'2188','334',3641551.18,3642928.11,0.00,0.00,1376.93,1013420.48,0.00,0.00,0.00),('1','136','779','257827',4903851,'2188','334',3642928.11,3643492.28,0.00,0.00,564.17,401287.76,0.00,0.00,0.00),('1','136','779','257828',4903852,'2188','334',3643492.28,3643492.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257829',4903853,'2188','334',3643492.28,3644615.32,0.00,0.00,1123.04,826557.44,0.00,0.00,0.00),('1','136','779','257830',4903854,'2188','334',3644615.32,3646702.01,0.00,0.00,2086.69,1535803.84,0.00,0.00,0.00),('1','136','779','257831',4903855,'2188','334',3646702.01,3648049.13,0.00,0.00,1347.12,991480.32,0.00,0.00,0.00),('1','136','779','257832',4903856,'2188','334',3648049.13,3648435.35,0.00,0.00,386.22,272132.40,0.00,0.00,0.00),('1','136','779','257833',4903857,'2188','334',3648435.35,3648435.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257834',4903858,'2188','334',3648435.35,3650171.63,0.00,0.00,1736.28,1277902.08,0.00,0.00,0.00),('1','136','779','257835',4903859,'2188','334',3650171.63,3653477.64,0.00,0.00,3306.01,2378108.96,0.00,0.00,0.00),('1','136','779','257836',4903860,'2188','334',3653477.64,3655288.22,0.00,0.00,1810.58,1332586.88,0.00,0.00,0.00),('1','136','779','257837',4903861,'2188','334',3655288.22,3657041.72,0.00,0.00,1753.50,1278273.36,0.00,0.00,0.00),('1','136','779','257838',4903862,'2188','334',3657041.72,3659418.75,0.00,0.00,2377.03,1733633.56,0.00,0.00,0.00),('1','136','779','257839',4903863,'2188','334',3659418.75,3662780.28,0.00,0.00,3361.53,2407073.56,0.00,0.00,0.00),('1','136','779','257840',4903864,'2188','334',3662780.28,3664822.67,0.00,0.00,2042.39,1490650.52,0.00,0.00,0.00),('1','136','779','257841',4903865,'2188','334',3664822.67,3668360.59,0.00,0.00,3537.92,2566409.12,0.00,0.00,0.00),('1','136','779','257842',4903866,'2188','334',3668360.59,3672172.87,0.00,0.00,3812.28,2747269.56,0.00,0.00,0.00),('1','136','779','257843',4903867,'2188','334',3672172.87,3672476.88,0.00,0.00,304.01,217271.36,0.00,0.00,0.00),('1','136','779','257844',4903868,'2188','334',3672476.88,3674431.03,0.00,0.00,1954.15,1438254.40,0.00,0.00,0.00),('1','136','779','257845',4903869,'2188','334',3674431.03,3675760.63,0.00,0.00,1329.60,978585.60,0.00,0.00,0.00),('1','136','779','257846',4903870,'2188','334',3675760.63,3676867.49,0.00,0.00,1106.86,814648.96,0.00,0.00,0.00),('1','136','779','257847',4903871,'2188','334',3676867.49,3677130.91,0.00,0.00,263.42,189269.12,0.00,0.00,0.00),('1','136','779','257848',4903872,'2188','334',3677130.91,3677130.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257849',4903873,'2188','334',3677130.91,3679218.87,0.00,0.00,2087.96,1536738.56,0.00,0.00,0.00),('1','136','779','257850',4903874,'2188','334',3679218.87,3680120.77,0.00,0.00,901.90,663798.40,0.00,0.00,0.00),('1','136','779','257851',4903875,'2188','334',3680120.77,3680120.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257852',4903876,'2188','334',3680120.77,3682201.06,0.00,0.00,2080.29,1531093.44,0.00,0.00,0.00),('1','136','779','257853',4903877,'2188','334',3682201.06,3682942.26,0.00,0.00,741.20,545523.20,0.00,0.00,0.00),('1','136','779','257854',4903878,'2188','334',3682942.26,3682942.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257855',4903879,'2188','334',3682942.26,3684829.40,0.00,0.00,1887.14,1388935.04,0.00,0.00,0.00),('1','136','779','257856',4903880,'2188','334',3684829.40,3685336.21,0.00,0.00,506.81,387202.84,0.00,0.00,0.00),('1','136','779','257857',4903881,'2188','334',3685336.21,3685393.21,0.00,0.00,57.00,43548.00,0.00,0.00,0.00),('1','136','779','257858',4903882,'2188','334',3685393.21,3685393.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257859',4903883,'2188','334',3685393.21,3688827.57,0.00,0.00,3434.36,2623851.04,0.00,0.00,0.00),('1','136','779','257860',4903884,'2188','334',3688827.57,3689549.67,0.00,0.00,722.10,551684.40,0.00,0.00,0.00),('1','136','779','257861',4903885,'2188','334',3689549.67,3689549.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257862',4903886,'2188','334',3689549.67,3690324.30,0.00,0.00,774.63,591817.32,0.00,0.00,0.00),('1','136','779','257863',4903887,'2188','334',3690324.30,3693055.30,0.00,0.00,2731.00,2042788.00,0.00,0.00,0.00),('1','136','779','257864',4903888,'2188','334',3693055.30,3695056.26,0.00,0.00,2000.96,1496718.08,0.00,0.00,0.00),('1','136','779','257865',4903889,'2188','334',3695056.26,3695056.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257866',4903890,'2188','334',3695056.26,3696973.37,0.00,0.00,1917.11,1433998.28,0.00,0.00,0.00),('1','136','779','257867',4903891,'2188','334',3696973.37,3699247.44,0.00,0.00,2274.07,1701004.36,0.00,0.00,0.00),('1','136','779','257868',4903892,'2188','334',3699247.44,3700396.24,0.00,0.00,1148.80,859302.40,0.00,0.00,0.00),('1','136','779','257869',4903893,'2188','334',3700396.24,3700396.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257870',4903894,'2188','334',3700396.24,3705007.68,0.00,0.00,4611.44,3449357.12,0.00,0.00,0.00),('1','136','779','257871',4903895,'2188','334',3705007.68,3705328.27,0.00,0.00,320.59,239801.32,0.00,0.00,0.00),('1','136','779','257872',4903896,'2188','334',3705328.27,3705328.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257873',4903897,'2188','334',3705328.27,3707333.44,0.00,0.00,2005.17,1499867.16,0.00,0.00,0.00),('1','136','779','257874',4903898,'2188','334',3707333.44,3708740.10,0.00,0.00,1406.66,1052181.68,0.00,0.00,0.00),('1','136','779','257875',4903899,'2188','334',3708740.10,3710072.82,0.00,0.00,1332.72,996874.56,0.00,0.00,0.00),('1','136','779','257876',4903900,'2188','334',3710072.82,3710072.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257877',4903901,'2188','334',3710072.82,3710499.26,0.00,0.00,426.44,318977.12,0.00,0.00,0.00),('1','136','779','257878',4903902,'2188','334',3710499.26,3713129.91,0.00,0.00,2630.65,1999294.00,0.00,0.00,0.00),('1','136','779','257879',4903903,'2188','334',3713129.91,3716119.10,0.00,0.00,2989.19,2271784.40,0.00,0.00,0.00),('1','136','779','257880',4903904,'2188','334',3716119.10,3717383.93,0.00,0.00,1264.83,961270.80,0.00,0.00,0.00),('1','136','779','257881',4903905,'2188','334',3717383.93,3717383.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257882',4903906,'2188','334',3717383.93,3718709.90,0.00,0.00,1325.97,1007737.20,0.00,0.00,0.00),('1','136','779','257883',4903907,'2188','334',3718709.90,3720886.02,0.00,0.00,2176.12,1653851.20,0.00,0.00,0.00),('1','136','779','257884',4903908,'2188','334',3720886.02,3721301.27,0.00,0.00,415.25,315590.00,0.00,0.00,0.00),('1','136','779','257885',4903909,'2188','334',3721301.27,3721301.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257886',4903910,'2188','334',3721301.27,3723675.43,0.00,0.00,2374.16,1804361.60,0.00,0.00,0.00),('1','136','779','257887',4903911,'2188','334',3723675.43,3725499.27,0.00,0.00,1823.84,1386118.40,0.00,0.00,0.00),('1','136','779','257888',4903912,'2188','334',3725499.27,3726570.96,0.00,0.00,1071.69,814484.40,0.00,0.00,0.00),('1','136','779','257889',4903913,'2188','334',3726570.96,3726570.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257890',4903914,'2188','334',3726570.96,3727320.58,0.00,0.00,749.62,569711.20,0.00,0.00,0.00),('1','136','779','257891',4903915,'2188','334',3727320.58,3729220.03,0.00,0.00,1899.45,1519560.00,0.00,0.00,0.00),('1','136','779','257892',4903916,'2188','334',3729220.03,3731167.89,0.00,0.00,1947.86,1558288.00,0.00,0.00,0.00),('1','136','779','257893',4903917,'2188','334',3731167.89,3732591.58,0.00,0.00,1423.69,1138952.00,0.00,0.00,0.00),('1','136','779','257894',4903918,'2188','334',3732591.58,3732591.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257895',4903919,'2188','334',3732591.58,3732937.36,0.00,0.00,345.78,276624.00,0.00,0.00,0.00),('1','136','779','257896',4903920,'2188','334',3732937.36,3735204.59,0.00,0.00,2267.23,1723094.80,0.00,0.00,0.00),('1','136','779','257897',4903921,'2188','334',3735204.59,3736963.85,0.00,0.00,1759.26,1337037.60,0.00,0.00,0.00),('1','136','779','257898',4903922,'2188','334',3736963.85,3737284.58,0.00,0.00,320.73,243754.80,0.00,0.00,0.00),('1','136','779','257899',4903923,'2188','334',3737284.58,3737284.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257900',4903924,'2188','334',3737284.58,3738245.72,0.00,0.00,961.14,730466.40,0.00,0.00,0.00),('1','136','779','257901',4903925,'2188','334',3738245.72,3739574.66,0.00,0.00,1328.94,1009994.40,0.00,0.00,0.00),('1','136','779','257902',4903926,'2188','334',3739574.66,3741059.32,0.00,0.00,1484.66,1128341.60,0.00,0.00,0.00),('1','136','779','257903',4903927,'2188','334',3741059.32,3741434.17,0.00,0.00,374.85,284886.00,0.00,0.00,0.00),('1','136','779','257904',4903928,'2188','334',3741434.17,3741434.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257905',4903929,'2188','334',3741434.17,3743446.04,0.00,0.00,2011.87,1529021.20,0.00,0.00,0.00),('1','136','779','257906',4903930,'2188','334',3743446.04,3744956.94,0.00,0.00,1510.90,1148284.00,0.00,0.00,0.00),('1','136','779','257907',4903931,'2188','334',3744956.94,3746041.98,0.00,0.00,1085.04,824630.40,0.00,0.00,0.00),('1','136','779','257908',4903932,'2188','334',3746041.98,3746437.99,0.00,0.00,396.01,300967.60,0.00,0.00,0.00),('1','136','779','257909',4903933,'2188','334',3746437.99,3746437.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257910',4903934,'2188','334',3746437.99,3748170.59,0.00,0.00,1732.60,1316776.00,0.00,0.00,0.00),('1','136','779','257911',4903935,'2188','334',3748170.59,3749553.09,0.00,0.00,1382.50,1050700.00,0.00,0.00,0.00),('1','136','779','257912',4903936,'2188','334',3749553.09,3750805.92,0.00,0.00,1252.83,952150.80,0.00,0.00,0.00),('1','136','779','257913',4903937,'2188','334',3750805.92,3752667.94,0.00,0.00,1862.02,1415135.20,0.00,0.00,0.00),('1','136','779','257914',4903938,'2188','334',3752667.94,3752667.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257915',4903939,'2188','334',3752667.94,3752667.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257916',4903940,'2188','334',3752667.94,3753169.08,0.00,0.00,501.14,380866.40,0.00,0.00,0.00),('1','136','779','257917',4903941,'2188','334',3753169.08,3755255.11,0.00,0.00,2086.03,1585382.80,0.00,0.00,0.00),('1','136','779','257918',4903942,'2188','334',3755255.11,3756657.70,0.00,0.00,1402.59,1065968.40,0.00,0.00,0.00),('1','136','779','257919',4903943,'2188','334',3756657.70,3757884.88,0.00,0.00,1227.18,931644.30,0.00,0.00,0.00),('1','136','779','257920',4903944,'2188','334',3757884.88,3758689.68,0.00,0.00,804.80,590138.00,0.00,0.00,0.00),('1','136','779','257921',4903945,'2188','334',3758689.68,3758689.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257922',4903946,'2188','334',3758689.68,3759911.96,0.00,0.00,1222.28,920176.25,0.00,0.00,0.00),('1','136','779','257923',4903947,'2188','334',3759911.96,3762039.31,0.00,0.00,2127.35,1593545.30,0.00,0.00,0.00),('1','136','779','257924',4903948,'2188','334',3762039.31,3763410.03,0.00,0.00,1370.72,1041747.20,0.00,0.00,0.00),('1','136','779','257925',4903949,'2188','334',3763410.03,3766198.82,0.00,0.00,2788.79,2076550.40,0.00,0.00,0.00),('1','136','779','257926',4903950,'2188','334',3766198.82,3769139.70,0.00,0.00,2940.88,2185613.80,0.00,0.00,0.00),('1','136','779','257927',4903951,'2188','334',3769139.70,3771025.73,0.00,0.00,1886.03,1424158.70,0.00,0.00,0.00),('1','136','779','257928',4903952,'2188','334',3771025.73,3772536.73,0.00,0.00,1511.00,1137335.00,0.00,0.00,0.00),('1','136','779','257929',4903953,'2188','334',3772536.73,3774355.01,0.00,0.00,1818.28,1366142.80,0.00,0.00,0.00),('1','136','779','257930',4903954,'2188','334',3774355.01,3775670.41,0.00,0.00,1315.40,999704.00,0.00,0.00,0.00),('1','136','779','257931',4903955,'2188','334',3775670.41,3777390.38,0.00,0.00,1719.97,1291652.20,0.00,0.00,0.00),('1','136','779','257932',4903956,'2188','334',3777390.38,3780621.25,0.00,0.00,3230.87,2392857.20,0.00,0.00,0.00),('1','136','779','257933',4903957,'2188','334',3780621.25,3782940.36,0.00,0.00,2319.11,1698843.60,0.00,0.00,0.00),('1','136','779','257934',4903958,'2188','334',3782940.36,3782940.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257935',4903959,'2188','334',3782940.36,3784156.44,0.00,0.00,1216.08,892710.80,0.00,0.00,0.00),('1','136','779','257936',4903960,'2188','334',3784156.44,3786246.32,0.00,0.00,2089.88,1553258.80,0.00,0.00,0.00),('1','136','779','257937',4903961,'2188','334',3786246.32,3788787.07,0.00,0.00,2540.75,1872070.00,0.00,0.00,0.00),('1','136','779','257938',4903962,'2188','334',3788787.07,3790794.30,0.00,0.00,2007.23,1499394.80,0.00,0.00,0.00),('1','136','779','257939',4903963,'2188','334',3790794.30,3793522.09,0.00,0.00,2727.79,1992530.40,0.00,0.00,0.00),('1','136','779','257940',4903964,'2188','334',3793522.09,3795780.98,0.00,0.00,2258.89,1663611.40,0.00,0.00,0.00),('1','136','779','257941',4903965,'2188','334',3795780.98,3799953.90,0.00,0.00,4172.92,3016494.20,0.00,0.00,0.00),('1','136','779','257942',4903966,'2188','334',3799953.90,3802964.92,0.00,0.00,3011.02,2196620.20,0.00,0.00,0.00),('1','136','779','257943',4903967,'2188','334',3802964.92,3806287.12,0.00,0.00,3322.20,2407992.00,0.00,0.00,0.00),('1','136','779','257944',4903968,'2188','334',3806287.12,3807513.36,0.00,0.00,1226.24,884813.40,0.00,0.00,0.00),('1','136','779','257945',4903969,'2188','334',3807513.36,3807513.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257946',4903970,'2188','334',3807513.36,3808528.60,0.00,0.00,1015.24,739362.40,0.00,0.00,0.00),('1','136','779','257947',4903971,'2188','334',3808528.60,3811120.85,0.00,0.00,2592.25,1890070.00,0.00,0.00,0.00),('1','136','779','257948',4903972,'2188','334',3811120.85,3812594.15,0.00,0.00,1473.30,1082043.00,0.00,0.00,0.00),('1','136','779','257949',4903973,'2188','334',3812594.15,3813123.85,0.00,0.00,529.70,380972.00,0.00,0.00,0.00),('1','136','779','257950',4903974,'2188','334',3813123.85,3813123.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257951',4903975,'2188','334',3813123.85,3815849.05,0.00,0.00,2725.20,1955787.20,0.00,0.00,0.00),('1','136','779','257952',4903976,'2188','334',3815849.05,3818228.28,0.00,0.00,2379.23,1701103.28,0.00,0.00,0.00),('1','136','779','257953',4903977,'2188','334',3818228.28,3819143.46,0.00,0.00,915.18,663312.48,0.00,0.00,0.00),('1','136','779','257954',4903978,'2188','334',3819143.46,3819143.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257955',4903979,'2188','334',3819143.46,3821600.48,0.00,0.00,2457.02,1748038.72,0.00,0.00,0.00),('1','136','779','257956',4903980,'2188','334',3821600.48,3823882.82,0.00,0.00,2282.34,1630275.24,0.00,0.00,0.00),('1','136','779','257957',4903981,'2188','334',3823882.82,3825907.00,0.00,0.00,2024.18,1452182.96,0.00,0.00,0.00),('1','136','779','257958',4903982,'2188','334',3825907.00,3828276.38,0.00,0.00,2369.38,1712759.68,0.00,0.00,0.00),('1','136','779','257959',4903983,'2188','334',3828276.38,3830732.15,0.00,0.00,2455.77,1772202.72,0.00,0.00,0.00),('1','136','779','257960',4903984,'2188','334',3830732.15,3833540.30,0.00,0.00,2808.15,2009400.32,0.00,0.00,0.00),('1','136','779','257961',4903985,'2188','334',3833540.30,3839750.61,0.00,0.00,6210.31,4402694.16,0.00,0.00,0.00),('1','136','779','257962',4903986,'2188','334',3839750.61,3843083.36,0.00,0.00,3332.75,2378140.00,0.00,0.00,0.00),('1','136','779','257963',4903987,'2188','334',3843083.36,3843784.95,0.00,0.00,701.59,508193.20,0.00,0.00,0.00),('1','136','779','257964',4903988,'2188','334',3843784.95,3843784.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257965',4903989,'2188','334',3843784.95,3845921.94,0.00,0.00,2136.99,1527608.64,0.00,0.00,0.00),('1','136','779','257966',4903990,'2188','334',3845921.94,3848063.87,0.00,0.00,2141.93,1531424.48,0.00,0.00,0.00),('1','136','779','257967',4903991,'2188','334',3848063.87,3848896.93,0.00,0.00,833.06,598552.16,0.00,0.00,0.00),('1','136','779','257968',4903992,'2188','334',3848896.93,3848896.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257969',4903993,'2188','334',3848896.93,3851473.95,0.00,0.00,2577.02,1849760.72,0.00,0.00,0.00),('1','136','779','257970',4903994,'2188','334',3851473.95,3855523.95,0.00,0.00,4050.00,2890276.00,0.00,0.00,0.00),('1','136','779','257971',4903995,'2188','334',3855523.95,3859292.68,0.00,0.00,3768.73,2713611.28,0.00,0.00,0.00),('1','136','779','257972',4903996,'2188','334',3859292.68,3864463.53,0.00,0.00,5170.85,3724081.60,0.00,0.00,0.00),('1','136','779','257973',4903997,'2188','334',3864463.53,3868555.94,0.00,0.00,4092.41,2917497.76,0.00,0.00,0.00),('1','136','779','257974',4903998,'2188','334',3868555.94,3873109.50,0.00,0.00,4553.56,3222996.16,0.00,0.00,0.00),('1','136','779','257975',4903999,'2188','334',3873109.50,3873836.58,0.00,0.00,727.08,513818.88,0.00,0.00,0.00),('1','136','779','257976',4904000,'2188','334',3873836.58,3873836.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257977',4904001,'2188','334',3873836.58,3875981.25,0.00,0.00,2144.67,1525793.08,0.00,0.00,0.00),('1','136','779','257978',4904002,'2188','334',3875981.25,3877482.44,0.00,0.00,1501.19,1077083.84,0.00,0.00,0.00),('1','136','779','257979',4904003,'2188','334',3877482.44,3879221.24,0.00,0.00,1738.80,1256572.80,0.00,0.00,0.00),('1','136','779','257980',4904004,'2188','334',3879221.24,3882623.43,0.00,0.00,3402.19,2418387.64,0.00,0.00,0.00),('1','136','779','257981',4904005,'2188','334',3882623.43,3884992.12,0.00,0.00,2368.69,1703324.20,0.00,0.00,0.00),('1','136','779','257982',4904006,'2188','334',3884992.12,3887220.09,0.00,0.00,2227.97,1586669.72,0.00,0.00,0.00),('1','136','779','257983',4904007,'2188','334',3887220.09,3890975.30,0.00,0.00,3755.21,2687612.48,0.00,0.00,0.00),('1','136','779','257984',4904008,'2188','334',3890975.30,3893983.47,0.00,0.00,3008.17,2151337.12,0.00,0.00,0.00),('1','136','779','257985',4904009,'2188','334',3893983.47,3896974.31,0.00,0.00,2990.84,2143071.80,0.00,0.00,0.00),('1','136','779','257986',4904010,'2188','334',3896974.31,3897954.95,0.00,0.00,980.64,714983.04,0.00,0.00,0.00),('1','136','779','257987',4904011,'2188','334',3897954.95,3897954.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','257988',4904012,'2188','334',3897954.95,3899804.63,0.00,0.00,1849.68,1318972.48,0.00,0.00,0.00),('1','136','779','257989',4904013,'2188','334',3899804.63,3902810.84,0.00,0.00,3006.21,2146375.18,0.00,0.00,0.00),('1','136','779','257990',4904014,'2188','334',3902810.84,3906790.39,0.00,0.00,3979.55,2832726.92,0.00,0.00,0.00),('1','136','779','257991',4904015,'2188','334',3906790.39,3910408.12,0.00,0.00,3617.73,2585246.92,0.00,0.00,0.00),('1','136','779','257992',4904016,'2188','334',3910408.12,3914476.82,0.00,0.00,4068.70,2884543.16,0.00,0.00,0.00),('1','136','779','257993',4904017,'2188','334',3914476.82,3917367.08,0.00,0.00,2890.26,2059700.68,0.00,0.00,0.00),('1','136','779','257994',4904018,'2188','334',3917367.08,3921688.55,0.00,0.00,4321.47,3069712.48,0.00,0.00,0.00),('1','136','779','257995',4904019,'2188','334',3921688.55,3925390.61,0.00,0.00,3702.06,2632189.52,0.00,0.00,0.00),('1','136','779','257996',4904020,'2188','334',3925390.61,3928998.13,0.00,0.00,3607.52,2573214.24,0.00,0.00,0.00),('1','136','779','257997',4904021,'2188','334',3928998.13,3932964.73,0.00,0.00,3966.60,2829576.38,0.00,0.00,0.00),('1','136','779','257998',4904022,'2188','334',3932964.73,3936849.82,0.00,0.00,3885.09,2756106.10,0.00,0.00,0.00),('1','136','779','257999',4904023,'2188','334',3936849.82,3940723.67,0.00,0.00,3873.85,2726390.28,0.00,0.00,0.00),('1','136','779','258000',4904024,'2188','334',3940723.67,3943496.13,0.00,0.00,2772.46,1975845.56,0.00,0.00,0.00),('1','136','779','258001',4904025,'2188','334',3943496.13,3945010.40,0.00,0.00,1514.27,1080692.72,0.00,0.00,0.00),('1','136','779','258002',4904026,'2188','334',3945010.40,3945010.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','258003',4904027,'2188','334',3945010.40,3946750.27,0.00,0.00,1739.87,1242847.32,0.00,0.00,0.00),('1','136','779','258004',4904028,'2188','334',3946750.27,3948721.88,0.00,0.00,1971.61,1436933.74,0.00,0.00,0.00),('1','136','779','258005',4904029,'2188','334',3948721.88,3951764.14,0.00,0.00,3042.26,2181084.02,0.00,0.00,0.00),('1','136','779','258006',4904030,'2188','334',3951764.14,3955350.78,0.00,0.00,3586.64,2536472.32,0.00,0.00,0.00),('1','136','779','258007',4904031,'2188','334',3955350.78,3959390.54,0.00,0.00,4039.76,2853867.44,0.00,0.00,0.00),('1','136','779','258008',4904032,'2188','334',3959390.54,3961989.87,0.00,0.00,2599.33,1857422.72,0.00,0.00,0.00),('1','136','779','258009',4904033,'2188','334',3961989.87,3964954.14,0.00,0.00,2964.27,2083266.96,0.00,0.00,0.00),('1','136','779','258010',4904034,'2188','334',3964954.14,3968253.95,0.00,0.00,3299.81,2346771.92,0.00,0.00,0.00),('1','136','779','258011',4904035,'2188','334',3968253.95,3971205.06,0.00,0.00,2951.11,2089492.56,0.00,0.00,0.00),('1','136','779','258012',4904036,'2188','334',3971205.06,3974755.97,0.00,0.00,3550.91,2482254.72,0.00,0.00,0.00),('1','136','779','258013',4904037,'2188','334',3974755.97,3979365.65,0.00,0.00,4609.68,3248330.72,0.00,0.00,0.00),('1','136','779','258014',4904038,'2188','334',3979365.65,3982424.87,0.00,0.00,3059.22,2174014.72,0.00,0.00,0.00),('1','136','779','258015',4904039,'2188','334',3982424.87,3985886.73,0.00,0.00,3461.86,2422771.20,0.00,0.00,0.00),('1','136','779','258016',4904040,'2188','334',3985886.73,3987630.60,0.00,0.00,1743.87,1242438.08,0.00,0.00,0.00),('1','136','779','258017',4904041,'2188','334',3987630.60,3990169.01,0.00,0.00,2538.41,1809220.56,0.00,0.00,0.00),('1','136','779','258018',4904042,'2188','334',3990169.01,3993229.40,0.00,0.00,3060.39,2165130.16,0.00,0.00,0.00),('1','136','779','258019',4904043,'2188','334',3993229.40,3994705.17,0.00,0.00,1475.77,1054547.44,0.00,0.00,0.00),('1','136','779','258020',4904044,'2188','334',3994705.17,3994705.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','258021',4904045,'2188','334',3994705.17,3995080.60,0.00,0.00,375.43,270794.88,0.00,0.00,0.00),('1','136','779','258022',4904046,'2188','334',3995080.60,3998869.16,0.00,0.00,3788.56,2684556.72,0.00,0.00,0.00),('1','136','779','258023',4904047,'2188','334',3998869.16,4002348.40,0.00,0.00,3479.24,2484564.00,0.00,0.00,0.00),('1','136','779','258024',4904048,'2188','334',4002348.40,4005469.58,0.00,0.00,3121.18,2220038.96,0.00,0.00,0.00),('1','136','779','258025',4904049,'2188','334',4005469.58,4008719.36,0.00,0.00,3249.78,2308593.52,0.00,0.00,0.00),('1','136','779','258026',4904050,'2188','334',4008719.36,4011794.80,0.00,0.00,3075.44,2190181.76,0.00,0.00,0.00),('1','136','779','258027',4904051,'2188','334',4011794.80,4014451.72,0.00,0.00,2656.92,1885973.25,0.00,0.00,0.00),('1','136','779','258028',4904052,'2188','334',4014451.72,4016566.25,0.00,0.00,2114.53,1516060.92,0.00,0.00,0.00),('1','136','779','258029',4904053,'2188','334',4016566.25,4020850.51,0.00,0.00,4284.26,3012238.06,0.00,0.00,0.00),('1','136','779','258030',4904054,'2188','334',4020850.51,4023382.81,0.00,0.00,2532.30,1802071.30,0.00,0.00,0.00),('1','136','779','258031',4904055,'2188','334',4023382.81,4026210.23,0.00,0.00,2827.42,1987834.73,0.00,0.00,0.00),('1','136','779','258032',4904056,'2188','334',4026210.23,4028997.50,0.00,0.00,2787.27,1985817.29,0.00,0.00,0.00),('1','136','779','258033',4904057,'2188','334',4028997.50,4032185.41,0.00,0.00,3187.91,2261500.17,0.00,0.00,0.00),('1','136','779','258034',4904058,'2188','334',4032185.41,4035208.47,0.00,0.00,3023.06,2106157.58,0.00,0.00,0.00),('1','136','779','258035',4904059,'2188','334',4035208.47,4037719.92,0.00,0.00,2511.45,1759420.88,0.00,0.00,0.00),('1','136','779','258036',4904060,'2188','334',4037719.92,4042913.88,0.00,0.00,5193.96,3614581.08,0.00,0.00,0.00),('1','136','779','258037',4904061,'2188','334',4042913.88,4044028.51,0.00,0.00,1114.63,804502.19,0.00,0.00,0.00),('1','136','779','258038',4904062,'2188','334',4044028.51,4044028.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','258039',4904063,'2188','334',4044028.51,4045824.76,0.00,0.00,1796.25,1265918.17,0.00,0.00,0.00),('1','136','779','258040',4904064,'2188','334',4045824.76,4049095.85,0.00,0.00,3271.09,2278179.67,0.00,0.00,0.00),('1','136','779','258041',4904065,'2188','334',4049095.85,4053000.52,0.00,0.00,3904.67,2735852.07,0.00,0.00,0.00),('1','136','779','258042',4904066,'2188','334',4053000.52,4056381.26,0.00,0.00,3380.74,2364392.20,0.00,0.00,0.00),('1','136','779','258043',4904067,'2188','334',4056381.26,4060085.25,0.00,0.00,3703.99,2615332.58,0.00,0.00,0.00),('1','136','779','258044',4904068,'2188','334',4060085.25,4065773.11,0.00,0.00,5687.86,4007611.21,0.00,0.00,0.00),('1','136','779','258045',4904069,'2188','334',4065773.11,4068943.47,0.00,0.00,3170.36,2191899.73,0.00,0.00,0.00),('1','136','779','258046',4904070,'2188','334',4068943.47,4068943.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','258047',4904071,'2188','334',4068943.47,4071758.47,0.00,0.00,2815.00,1986834.67,0.00,0.00,0.00),('1','136','779','258048',4904072,'2188','334',4071758.47,4077004.84,0.00,0.00,5246.37,3664366.03,0.00,0.00,0.00),('1','136','779','258049',4904073,'2188','334',4077004.84,4080397.27,0.00,0.00,3392.43,2391262.49,0.00,0.00,0.00),('1','136','779','258050',4904074,'2188','334',4080397.27,4084999.61,0.00,0.00,4602.34,3203290.68,0.00,0.00,0.00),('1','136','779','258051',4904075,'2188','334',4084999.61,4088268.12,0.00,0.00,3268.51,2309114.04,0.00,0.00,0.00),('1','136','779','258052',4904076,'2188','334',4088268.12,4092048.22,0.00,0.00,3780.10,2639496.56,0.00,0.00,0.00),('1','136','779','258053',4904077,'2188','334',4092048.22,4093690.77,0.00,0.00,1642.55,1156334.80,0.00,0.00,0.00),('1','136','779','258054',4904078,'2188','334',4093690.77,4093690.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','258055',4904079,'2188','334',4093690.77,4097847.68,0.00,0.00,4156.91,2915937.51,0.00,0.00,0.00),('1','136','779','258056',4904080,'2188','334',4097847.68,4100928.23,0.00,0.00,3080.55,2184955.54,0.00,0.00,0.00),('1','136','779','258057',4904081,'2188','334',4100928.23,4100928.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','136','779','258058',4904082,'2188','334',4100928.23,4102637.43,0.00,0.00,1709.20,1215204.10,0.00,0.00,0.00),('1','136','779','258059',4904083,'2188','334',4102637.43,4107863.80,0.00,0.00,5226.37,3644731.87,0.00,0.00,0.00),('1','136','779','258060',4904084,'2188','334',4107863.80,4111072.35,0.00,0.00,3208.55,2268224.41,0.00,0.00,0.00),('1','136','779','258061',4904085,'2188','334',4111072.35,4114331.33,0.00,0.00,3258.98,2170579.53,0.00,0.00,0.00),('1','136','779','258062',4904086,'2188','334',4114331.33,4117037.05,0.00,0.00,2705.72,1849423.52,0.00,0.00,0.00),('1','136','779','258063',4904087,'2188','334',4117037.05,4122186.21,0.00,0.00,5149.16,3482273.90,0.00,0.00,0.00),('1','136','779','258064',4904088,'2188','334',4122186.21,4125958.23,0.00,0.00,3772.02,2543287.32,0.00,0.00,0.00),('1','136','779','258065',4904089,'2188','334',4125958.23,4127508.86,0.00,0.00,1550.63,1051478.96,0.00,0.00,0.00),('1','136','779','258066',4904090,'2188','334',4127508.86,4132491.18,0.00,0.00,4982.32,3365915.30,0.00,0.00,0.00),('1','136','779','258067',4904091,'2188','334',4132491.18,4137517.62,0.00,0.00,5026.44,3393526.06,0.00,0.00,0.00),('1','136','779','258068',4904092,'2188','334',4137517.62,4143357.58,0.00,0.00,5839.96,3899725.90,0.00,0.00,0.00),('1','136','779','258069',4904093,'2188','334',4143357.58,4147339.42,0.00,0.00,3981.84,2688907.60,0.00,0.00,0.00),('1','136','779','258070',4904094,'2188','334',4147339.42,4150898.23,0.00,0.00,3558.81,2387658.00,0.00,0.00,0.00),('1','136','779','258071',4904095,'2188','334',4150898.23,4153040.93,0.00,0.00,2142.70,1437263.78,0.00,0.00,0.00),('1','136','779','258072',4904096,'2188','334',4153040.93,4156313.85,0.00,0.00,3272.92,2216504.92,0.00,0.00,0.00),('1','136','779','258073',4904097,'2188','334',4156313.85,4160382.94,0.00,0.00,4069.09,2738906.04,0.00,0.00,0.00),('1','136','779','258074',4904098,'2188','334',4160382.94,4165055.43,0.00,0.00,4672.49,3162113.04,0.00,0.00,0.00),('1','136','779','258075',4904099,'2188','334',4165055.43,4168942.66,0.00,0.00,3887.23,2638994.00,0.00,0.00,0.00),('1','136','779','258076',4904100,'2188','334',4168942.66,4174328.75,0.00,0.00,5386.09,3565769.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730213 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','136','146990','334',210.00,280.00,0.00,501.40,105294.00,140392.00,35098.00,441529),('1','136','147046','334',210.00,0.00,0.00,728.30,152943.00,203924.00,50981.00,441644),('1','136','147114','334',210.00,280.00,0.00,5610.00,1178100.00,1570800.00,392700.00,441784),('1','136','147161','334',210.00,212.00,0.00,0.00,0.00,0.00,0.00,441885),('1','136','147179','334',210.00,280.00,0.00,4458.30,936243.00,980644.00,44401.00,441919),('1','136','147191','334',210.00,220.00,0.00,5013.00,1052730.00,1142028.00,89298.00,441943),('1','136','147206','334',210.00,280.00,0.00,8358.90,1755369.00,1847720.00,92351.00,441969),('1','136','147215','334',210.00,216.00,0.00,5673.10,1191351.00,1271524.00,80173.00,441987),('1','136','147227','334',210.00,216.00,0.00,5293.80,1111698.00,1154150.00,42452.00,442011),('1','136','147242','334',210.00,280.00,0.00,0.00,0.00,0.00,0.00,442048),('1','136','147255','334',210.00,280.00,0.00,2157.20,453012.00,471268.00,18256.00,442080),('1','136','147266','334',210.00,216.00,0.00,8061.80,1692978.00,1764860.00,71882.00,442108),('1','136','147277','334',210.00,216.00,0.00,6259.10,1314411.00,1387638.00,73227.00,442133),('1','136','147290','334',210.00,280.00,0.00,0.00,0.00,0.00,0.00,442159),('1','136','147376','334',210.00,280.00,0.00,3230.50,678405.00,688816.00,10411.00,442391),('1','136','147397','334',210.00,280.00,0.00,4766.40,1000944.00,1047996.00,47052.00,442451),('1','136','147407','334',210.00,280.00,0.00,0.00,0.00,0.00,0.00,442477),('1','136','147408','334',210.00,280.00,0.00,553.00,116130.00,117236.00,1106.00,442478),('1','136','147823','334',210.00,280.00,0.00,6740.30,1415463.00,1495268.00,79805.00,443619),('1','136','147826','334',210.00,280.00,0.00,12372.90,2598309.00,2698718.00,100409.00,443626),('1','136','147831','334',210.00,280.00,0.00,1773.60,372456.00,248304.00,-124152.00,443637),('1','136','147832','334',210.00,280.00,0.00,2248.80,470301.60,500674.00,30372.40,443638),('1','136','147910','334',202.00,280.00,0.00,10344.40,2089568.80,2229582.00,140013.20,443835),('1','136','148187','334',210.00,280.00,0.00,6181.30,1298073.00,1352202.00,54129.00,444564),('1','136','148295','334',210.00,0.00,0.00,5418.70,1137927.00,1177934.00,40007.00,444828),('1','136','148381','334',210.00,280.00,0.00,3127.00,656670.00,680076.00,23406.00,445075),('1','136','148608','334',210.00,280.00,0.00,8497.50,1784475.00,1840830.00,56355.00,445666),('1','136','148616','334',210.00,280.00,0.00,1726.00,362460.00,381167.20,18707.20,445684),('1','136','148621','334',210.00,280.00,0.00,5152.30,1081983.00,1123197.20,41214.20,445695),('1','136','148628','334',210.00,280.00,0.00,504.60,105966.00,121448.00,15482.00,445712),('1','136','148632','334',210.00,280.00,0.00,5281.00,1109010.00,1142378.00,33368.00,445722),('1','136','148636','334',210.00,280.00,0.00,6046.80,1269828.00,1319520.00,49692.00,445730),('1','136','148637','334',210.00,280.00,0.00,577.00,121170.00,128280.00,7110.00,445731),('1','136','148790','334',210.00,280.00,0.00,8456.90,1775949.00,1863072.00,87123.00,446128),('1','136','148994','334',210.00,280.00,0.00,8554.30,1796403.00,1863834.00,67431.00,446651),('1','136','149104','334',205.00,205.00,0.00,5694.20,1167311.00,1232220.00,64909.00,446966),('1','136','149393','334',205.00,280.00,0.00,3341.60,685028.00,728322.80,43294.80,447716),('1','136','149395','334',205.00,280.00,0.00,4627.10,948555.50,1046152.00,97596.50,447720),('1','136','149430','334',205.00,280.00,0.00,9431.10,1933375.50,2058808.00,125432.50,447825),('1','136','149589','334',205.00,280.00,0.00,5410.90,1109234.50,1188892.00,79657.50,448263),('1','136','149593','334',205.00,280.00,0.00,7052.00,1445660.00,1526076.00,80416.00,448271),('1','136','149814','334',205.00,280.00,0.00,4096.40,839762.00,929104.00,89342.00,448861),('1','136','149876','334',205.00,280.00,0.00,9946.90,2039114.50,2170088.00,130973.50,449004),('1','136','150024','334',205.00,280.00,0.00,1559.00,319595.00,350716.00,31121.00,449401),('1','136','150027','334',205.00,280.00,0.00,9427.60,1932658.00,2033776.00,101118.00,449406),('1','136','150158','334',205.00,280.00,0.00,10824.30,2218981.50,2365226.00,146244.50,449768),('1','136','150273','334',205.00,280.00,0.00,2364.60,484743.00,520018.00,35275.00,450064),('1','136','150356','334',205.00,280.00,0.00,5091.10,1043675.50,1117068.00,73392.50,450280),('1','136','150850','334',205.00,280.00,0.00,3390.60,695073.00,757336.00,62263.00,451575),('1','136','150851','334',205.00,280.00,0.00,437.00,89585.00,122360.00,32775.00,451576),('1','136','150852','334',205.00,280.00,0.00,1259.20,258136.00,352576.00,94440.00,451577),('1','136','151003','334',205.00,280.00,0.00,651.30,133516.50,182364.00,48847.50,451984),('1','136','151156','334',205.00,280.00,0.00,980.00,200900.00,224020.00,23120.00,452400),('1','136','151285','334',205.00,280.00,0.00,5465.70,1120468.50,1193248.00,72779.50,452756),('1','136','151288','334',205.00,280.00,0.00,8634.50,1770072.50,1892042.40,121969.90,452759),('1','136','151421','334',205.00,280.00,0.00,7367.30,1510296.50,1620044.00,109747.50,453130),('1','136','151541','334',205.00,280.00,0.00,177.50,36387.50,41956.00,5568.50,453463),('1','136','151761','334',205.00,280.00,0.00,912.30,187021.50,255444.00,68422.50,454056),('1','136','151765','334',205.00,280.00,0.00,1303.50,267217.50,302868.00,35650.50,454064),('1','136','151770','334',205.00,280.00,0.00,6077.20,1245826.00,1333040.00,87214.00,454075),('1','136','151818','334',205.00,280.00,0.00,3147.00,645135.00,718224.00,73089.00,454197),('1','136','152072','334',205.00,280.00,0.00,13502.50,2768012.50,2917672.00,149659.50,454879),('1','136','152165','334',205.00,280.00,0.00,2437.20,499626.00,559856.00,60230.00,455119),('1','136','152385','334',205.00,280.00,0.00,8763.50,1796517.50,1926582.00,130064.50,455703),('1','136','152457','334',205.00,280.00,0.00,8361.50,1714107.50,1822550.00,108442.50,455905),('1','136','152614','334',205.00,280.00,0.00,7285.80,1493589.00,1615744.00,122155.00,456321),('1','136','152771','334',205.00,280.00,0.00,1676.50,343682.50,381640.00,37957.50,456744),('1','136','152774','334',205.00,280.00,0.00,5097.50,1044987.50,1155632.00,110644.50,456749),('1','136','152827','334',205.00,280.00,0.00,476.00,97580.00,108080.00,10500.00,456896),('1','136','152995','334',205.00,280.00,0.00,0.00,0.00,0.00,0.00,457363),('1','136','152998','334',205.00,0.00,0.00,9906.80,2030894.00,2249868.00,218974.00,457370),('1','136','153082','334',205.00,280.00,0.00,7835.40,1606257.00,1769858.00,163601.00,457577),('1','136','153239','334',205.00,280.00,0.00,5392.50,1105462.50,1233314.40,127851.90,458024),('1','136','153390','334',205.00,280.00,0.00,6850.90,1404434.50,1528642.00,124207.50,458436),('1','136','153493','334',205.00,280.00,0.00,10949.00,2244545.00,2467413.60,222868.60,458708),('1','136','153715','334',205.00,280.00,0.00,4679.00,959195.00,1078016.00,118821.00,459297),('1','136','153801','334',205.00,280.00,0.00,4946.60,1014053.00,1133852.00,119799.00,459536),('1','136','153873','334',205.00,280.00,0.00,909.40,186427.00,211882.00,25455.00,459727),('1','136','154249','334',205.00,280.00,0.00,11808.30,2420701.50,2664402.00,243700.50,460724),('1','136','154251','334',205.00,280.00,0.00,6459.40,1324177.00,1476036.00,151859.00,460726),('1','136','154252','334',205.00,280.00,0.00,4215.30,864136.50,946550.00,82413.50,460727),('1','136','154623','334',205.00,280.00,0.00,8348.50,1711442.50,1871884.00,160441.50,461728),('1','136','154825','334',205.00,280.00,0.00,682.10,139830.50,190988.00,51157.50,462292),('1','136','154832','334',205.00,280.00,0.00,213.60,43788.00,57008.00,13220.00,462310),('1','136','154857','334',205.00,280.00,0.00,8983.40,1841597.00,2013672.00,172075.00,462379),('1','136','155118','334',205.00,280.00,0.00,13323.10,2731235.50,2981110.00,249874.50,463085),('1','136','155256','334',205.00,280.00,0.00,4290.90,879634.50,990900.00,111265.50,463466),('1','136','155280','334',205.00,280.00,0.00,11564.40,2370702.00,2590444.00,219742.00,463526),('1','136','155642','334',205.00,280.00,0.00,6699.00,1373295.00,1505996.00,132701.00,464494),('1','136','155648','334',205.00,280.00,0.00,8781.10,1800125.50,1984966.00,184840.50,464504),('1','136','155869','334',205.00,280.00,0.00,3101.50,635807.50,698266.00,62458.50,465097),('1','136','155883','334',205.00,280.00,0.00,6164.20,1263661.00,1385016.00,121355.00,465135),('1','136','155925','334',205.00,280.00,0.00,12413.50,2544767.50,2774020.00,229252.50,465237),('1','136','156009','334',205.00,280.00,0.00,3879.50,795297.50,880084.00,84786.50,465463),('1','136','156135','334',205.00,0.00,0.00,8012.00,1642460.00,1805376.00,162916.00,465788),('1','136','156380','334',205.00,280.00,0.00,2361.30,484066.50,565012.00,80945.50,466443),('1','136','156425','334',205.00,280.00,0.00,12675.80,2598539.00,2794232.00,195693.00,466553),('1','136','156579','334',205.00,280.00,0.00,8137.70,1668228.50,1835478.00,167249.50,466968),('1','136','156739','334',205.00,280.00,0.00,1906.00,390730.00,449568.00,58838.00,467417),('1','136','156870','334',205.00,280.00,0.00,518.30,106251.50,145124.00,38872.50,467788),('1','136','157087','334',205.00,280.00,0.00,248.10,50860.50,69468.00,18607.50,468334),('1','136','157274','334',205.00,280.00,0.00,13399.80,2746959.00,3006978.00,260019.00,468825),('1','136','157484','334',205.00,280.00,0.00,6372.00,1306260.00,1439354.00,133094.00,469352),('1','136','157777','334',205.00,280.00,0.00,5717.90,1172169.50,1282042.00,109872.50,470142),('1','136','157815','334',205.00,280.00,0.00,9138.80,1873454.00,2058636.00,185182.00,470238),('1','136','157976','334',205.00,280.00,0.00,9948.40,2039422.00,2249230.00,209808.00,470670),('1','136','158069','334',205.00,280.00,0.00,3731.40,764937.00,836330.00,71393.00,470914),('1','136','158071','334',205.00,280.00,0.00,7734.70,1585613.50,1732336.00,146722.50,470918),('1','136','158734','334',205.00,280.00,0.00,599.60,122918.00,167888.00,44970.00,472668),('1','136','158735','334',205.00,280.00,0.00,2845.10,583245.50,665444.00,82198.50,472669),('1','136','158737','334',205.00,280.00,0.00,544.90,111704.50,152572.00,40867.50,472674),('1','136','158738','334',205.00,280.00,0.00,1055.40,216357.00,295512.00,79155.00,472675),('1','136','158905','334',205.00,280.00,0.00,1665.90,341509.50,466452.00,124942.50,473100),('1','136','159093','334',205.00,280.00,0.00,1468.10,300960.50,411068.00,110107.50,473621),('1','136','159333','334',205.00,280.00,0.00,1140.80,233864.00,319424.00,85560.00,474242),('1','136','159437','334',205.00,280.00,0.00,871.90,178739.50,244132.00,65392.50,474504),('1','136','159601','334',205.00,280.00,0.00,3320.30,680661.50,763084.00,82422.50,474945),('1','136','159621','334',215.00,280.00,0.00,9023.50,1940052.50,2144804.00,204751.50,474995),('1','136','159732','334',215.00,232.00,0.00,13825.00,2972375.00,3279940.00,307565.00,475257),('1','136','159735','334',215.00,232.00,0.00,2467.20,530448.00,590908.80,60460.80,475260),('1','136','159947','334',215.00,304.00,0.00,1956.40,420626.00,516229.60,95603.60,475812),('1','136','160027','334',215.00,304.00,0.00,1046.20,224933.00,241332.80,16399.80,476018),('1','136','160121','334',215.00,304.00,0.00,14502.00,3117930.00,3382902.00,264972.00,476262),('1','136','160229','334',215.00,232.00,0.00,7885.30,1695339.50,1847123.20,151783.70,476545),('1','136','160300','334',215.00,304.00,0.00,6210.40,1335236.00,1493037.60,157801.60,476739),('1','136','160446','334',215.00,304.00,0.00,8859.70,1904835.50,2089238.80,184403.30,477125),('1','136','160584','334',215.00,256.00,0.00,1690.40,363436.00,466217.60,102781.60,477489),('1','136','160805','334',215.00,304.00,0.00,112.50,24187.50,31800.00,7612.50,478043),('1','136','160808','334',215.00,256.00,0.00,3103.80,667317.00,827496.80,160179.80,478048),('1','136','160821','334',215.00,256.00,0.00,6260.90,1346093.50,1644285.60,298192.10,478077),('1','136','161078','334',215.00,304.00,0.00,11326.80,2435262.00,2917743.20,482481.20,478760),('1','136','161345','334',215.00,304.00,0.00,5292.00,1137780.00,1373303.20,235523.20,479415),('1','136','161807','334',215.00,304.00,0.00,4534.60,974939.00,1184046.40,209107.40,480615),('1','136','161811','334',215.00,304.00,0.00,4127.90,887498.50,1089644.80,202146.30,480625),('1','136','161853','334',215.00,320.00,0.00,6998.00,1504570.00,1825026.00,320456.00,480718),('1','136','162200','334',215.00,204.00,0.00,7147.50,1536712.50,1858154.00,321441.50,481634),('1','136','162212','334',215.00,304.00,0.00,5704.70,1226510.50,1497444.80,270934.30,481665),('1','136','162450','334',215.00,304.00,0.00,6862.40,1475416.00,1772533.60,297117.60,482265),('1','136','162688','334',215.00,304.00,0.00,4981.70,1071065.50,1293582.80,222517.30,482857),('1','136','162794','334',215.00,304.00,0.00,3439.70,739535.50,907740.80,168205.30,483153),('1','136','163067','334',215.00,304.00,0.00,5029.30,1081299.50,1304093.20,222793.70,483849),('1','136','163188','334',215.00,304.00,0.00,6240.80,1341772.00,1470175.70,128403.70,484170),('1','136','163359','334',215.00,304.00,0.00,5135.10,1104046.50,1340222.40,236175.90,484614),('1','136','163536','334',215.00,304.00,0.00,3517.40,756241.00,937913.60,181672.60,485083),('1','136','163773','334',215.00,304.00,0.00,4044.80,869632.00,1043523.20,173891.20,485688),('1','136','163890','334',237.00,304.00,0.00,3199.60,758305.20,826898.40,68593.20,485998),('1','136','164236','334',237.00,304.00,0.00,2149.20,509360.40,592516.80,83156.40,486918),('1','136','164239','334',237.00,304.00,0.00,3442.50,815872.50,941058.00,125185.50,486924),('1','136','164429','334',237.00,304.00,0.00,1619.70,383868.90,452104.80,68235.90,487429),('1','136','164591','334',237.00,304.00,0.00,4414.30,1046189.10,1208289.20,162100.10,487863),('1','136','164729','334',237.00,304.00,0.00,2669.10,632576.70,742520.40,109943.70,488238),('1','136','164953','334',237.00,320.00,0.00,7481.80,1773186.60,2042479.20,269292.60,488813),('1','136','165112','334',237.00,320.00,0.00,1520.00,360240.00,456910.00,96670.00,489213),('1','136','165275','334',237.00,304.00,0.00,3387.70,802884.90,953824.80,150939.90,489642),('1','136','165435','334',237.00,304.00,0.00,5913.00,1401381.00,1671324.00,269943.00,490059),('1','136','165599','334',237.00,304.00,0.00,3527.40,835993.80,998356.80,162363.00,490489),('1','136','165750','334',237.00,280.00,0.00,3305.00,783285.00,839545.00,56260.00,490897),('1','136','165778','334',237.00,304.00,0.00,4196.20,994499.40,1181724.80,187225.40,490975),('1','136','165916','334',261.00,304.00,0.00,5342.10,1394288.10,1416791.40,22503.30,491341),('1','136','166126','334',261.00,304.00,0.00,5806.60,1515522.60,1632158.40,116635.80,491892),('1','136','166305','334',261.00,304.00,0.00,6694.90,1747368.90,1871407.60,124038.70,492365),('1','136','166462','334',261.00,204.00,0.00,6376.20,1664188.20,1579410.80,-84777.40,492796),('1','136','166678','334',261.00,304.00,0.00,2581.50,673771.50,733104.00,59332.50,493372),('1','136','166864','334',261.00,304.00,0.00,1732.70,452234.70,496320.80,44086.10,493876),('1','136','167289','334',261.00,304.00,0.00,6546.30,1708584.30,1834371.20,125786.90,495007),('1','136','167293','334',261.00,304.00,0.00,5356.30,1397994.30,1510507.20,112512.90,495016),('1','136','167350','334',261.00,304.00,0.00,2187.30,570885.30,626995.20,56109.90,495182),('1','136','167555','334',261.00,304.00,0.00,4795.00,1251495.00,1343602.00,92107.00,495722),('1','136','167712','334',261.00,304.00,0.00,6545.60,1708401.60,1635064.40,-73337.20,496129),('1','136','167892','334',261.00,304.00,0.00,9045.10,2360771.10,2323062.40,-37708.70,496602),('1','136','168105','334',261.00,304.00,0.00,972.00,253692.00,269748.00,16056.00,497170),('1','136','168109','334',261.00,304.00,0.00,5495.80,1434403.80,1548719.20,114315.40,497176),('1','136','168276','334',261.00,304.00,0.00,2684.10,700550.10,768830.40,68280.30,497633),('1','136','168454','334',261.00,304.00,0.00,5743.60,1499079.60,1623642.40,124562.80,498101),('1','136','168593','334',261.00,304.00,0.00,4787.20,1249459.20,1360336.80,110877.60,498466),('1','136','168807','334',261.00,304.00,0.00,0.00,0.00,0.00,0.00,499031),('1','136','168812','334',261.00,304.00,0.00,10201.10,2662487.10,2568809.40,-93677.70,499038),('1','136','168997','334',261.00,304.00,0.00,8750.10,2283776.10,2473758.40,189982.30,499528),('1','136','169082','334',261.00,204.00,0.00,8335.50,2175565.50,2260273.00,84707.50,499757),('1','136','169102','334',261.00,304.00,0.00,8242.20,2151214.20,2302322.80,151108.60,499794),('1','136','169247','334',261.00,204.00,0.00,10650.70,2779832.70,3112548.80,332716.10,500165),('1','136','169457','334',261.00,304.00,0.00,11413.40,2978897.40,3334097.60,355200.20,500694),('1','136','169552','334',261.00,304.00,0.00,6566.40,1713830.40,1916559.60,202729.20,500955),('1','136','169917','334',261.00,304.00,0.00,5013.00,1308393.00,1469544.00,161151.00,501946),('1','136','170059','334',261.00,204.00,0.00,3283.10,856889.10,967102.40,110213.30,502302),('1','136','170466','334',261.00,204.00,0.00,4217.30,1100715.30,1235007.20,134291.90,503363),('1','136','170471','334',261.00,304.00,0.00,5622.70,1467524.70,1651646.80,184122.10,503374),('1','136','170777','334',261.00,204.00,0.00,5109.00,1333449.00,1494950.00,161501.00,504169),('1','136','170946','334',261.00,320.00,0.00,4738.30,1236696.30,1391916.00,155219.70,504623),('1','136','171173','334',261.00,320.00,0.00,7968.00,2079648.00,2031236.00,-48412.00,505234),('1','136','171301','334',261.00,320.00,0.00,1243.00,324423.00,370656.00,46233.00,505570),('1','136','171303','334',261.00,320.00,0.00,4549.60,1187445.60,1342640.00,155194.40,505574),('1','136','171380','334',261.00,320.00,0.00,4501.50,1174891.50,1334046.00,159154.50,505764),('1','136','171657','334',261.00,320.00,0.00,4055.30,1058433.30,1208258.00,149824.70,506517),('1','136','171744','334',261.00,320.00,0.00,3112.10,812258.10,930828.00,118569.90,506754),('1','136','171938','334',261.00,320.00,0.00,4081.50,1065271.50,1212980.00,147708.50,507260),('1','136','172065','334',261.00,320.00,0.00,7135.30,1862313.30,2103586.00,241272.70,507588),('1','136','172255','334',261.00,320.00,0.00,6539.00,1706679.00,1929512.00,222833.00,508102),('1','136','172462','334',261.00,320.00,0.00,2455.70,640937.70,745756.00,104818.30,508645),('1','136','172682','334',261.00,320.00,0.00,4012.20,1047184.20,1195796.00,148611.80,509227),('1','136','172857','334',261.00,320.00,0.00,6389.00,1667529.00,1717924.00,50395.00,509694),('1','136','173032','334',261.00,320.00,0.00,8792.10,2294738.10,2405772.00,111033.90,510160),('1','136','173194','334',261.00,320.00,0.00,6920.40,1806224.40,2042338.00,236113.60,510590),('1','136','173347','334',261.00,320.00,0.00,4651.60,1214067.60,1390596.00,176528.40,510982),('1','136','173571','334',261.00,320.00,0.00,5171.60,1349787.60,1532874.00,183086.40,511597),('1','136','173745','334',261.00,320.00,0.00,5045.30,1316823.30,1481260.00,164436.70,512047),('1','136','173927','334',261.00,320.00,0.00,757.00,197577.00,153364.00,-44213.00,512525),('1','136','173928','334',261.00,320.00,0.00,5015.70,1309097.70,1485192.00,176094.30,512526),('1','136','174115','334',278.00,320.00,0.00,5083.00,1413074.00,1490776.00,77702.00,513027),('1','136','174297','334',278.00,320.00,0.00,8868.60,2465470.80,2404702.00,-60768.80,513502),('1','136','174471','334',278.00,320.00,0.00,7836.00,2178408.00,2319380.00,140972.00,513941),('1','136','174609','334',278.00,320.00,0.00,4975.50,1383189.00,1473458.00,90269.00,514290),('1','136','174822','334',278.00,320.00,0.00,10145.10,2820337.80,2958936.00,138598.20,514859),('1','136','175021','334',278.00,360.00,0.00,6767.00,1881226.00,1924318.40,43092.40,515391),('1','136','175276','334',278.00,360.00,0.00,1214.10,337519.80,403188.00,65668.20,516043),('1','136','175392','334',290.00,360.00,0.00,6155.30,1785037.00,1885284.00,100247.00,516365),('1','136','175573','334',290.00,360.00,0.00,3982.80,1155012.00,1268064.00,113052.00,516834),('1','136','175850','334',290.00,360.00,0.00,9648.70,2798123.00,2962684.00,164561.00,517559),('1','136','176051','334',290.00,360.00,0.00,4764.80,1381792.00,1512716.80,130924.80,518059),('1','136','176158','334',290.00,360.00,0.00,3621.60,1050264.00,1149760.00,99496.00,518327),('1','136','176307','334',293.00,360.00,0.00,6789.70,1989382.10,2064586.00,75203.90,518734),('1','136','176520','334',293.00,360.00,0.00,5318.30,1558261.90,1456692.00,-101569.90,519288),('1','136','176744','334',293.00,360.00,0.00,4554.30,1334409.90,1448816.00,114406.10,519895),('1','136','176954','334',293.00,360.00,0.00,3329.70,975602.10,1056508.00,80905.90,520452),('1','136','177149','334',293.00,360.00,0.00,1992.40,583773.20,627235.20,43462.00,520959),('1','136','177181','334',293.00,360.00,0.00,3240.40,949437.20,1031956.00,82518.80,521039),('1','136','177400','334',293.00,360.00,0.00,3676.10,1077097.30,1189344.00,112246.70,521605),('1','136','177596','334',293.00,360.00,0.00,2888.40,846301.20,926130.00,79828.80,522141),('1','136','177852','334',293.00,350.00,0.00,3466.20,1015596.60,1099400.00,83803.40,522827),('1','136','178043','334',293.00,360.00,0.00,2275.10,666604.30,740604.00,73999.70,523338),('1','136','178235','334',293.00,360.00,0.00,4940.10,1447449.30,1557800.00,110350.70,523831),('1','136','178393','334',293.00,360.00,0.00,4248.80,1244898.40,1264324.00,19425.60,524237),('1','136','178522','334',293.00,360.00,0.00,933.60,273544.80,304376.00,30831.20,524565),('1','136','178599','334',293.00,360.00,0.00,1704.70,499477.10,555012.00,55534.90,524787),('1','136','178658','334',293.00,360.00,0.00,7305.80,2140599.40,2266826.00,126226.60,524935),('1','136','178918','334',288.00,0.00,0.00,0.00,0.00,0.00,0.00,525594),('1','136','178919','334',288.00,360.00,0.00,3805.40,1095955.20,1256377.00,160421.80,525595),('1','136','178994','334',288.00,360.00,0.00,2968.40,854899.20,974174.00,119274.80,525795),('1','136','179270','334',288.00,360.00,0.00,4038.60,1163116.80,1315722.00,152605.20,526549),('1','136','179372','334',288.00,360.00,0.00,3043.50,876528.00,996409.25,119881.25,526809),('1','136','179581','334',288.00,360.00,0.00,4797.20,1381593.60,1563241.00,181647.40,527352),('1','136','179773','334',288.00,360.00,0.00,2556.40,736243.20,846734.40,110491.20,527881),('1','136','179994','334',288.00,360.00,0.00,9227.55,2657534.40,2902855.00,245320.60,528449),('1','136','180180','334',288.00,360.00,0.00,5778.68,1664259.84,1885486.80,221226.96,528940),('1','136','180344','334',288.00,360.00,0.00,4587.01,1321058.88,1487302.60,166243.72,529353),('1','136','180546','334',288.00,360.00,0.00,222.00,63936.00,71864.00,7928.00,529902),('1','136','180567','334',288.00,70243.00,0.00,2759.50,799754.80,897494.00,97739.20,529941),('1','136','180735','334',308.00,360.00,0.00,3944.06,1214770.48,1299239.60,84469.12,530391),('1','136','180963','334',308.00,360.00,0.00,7886.57,2429063.56,2488148.20,59084.64,530997),('1','136','181136','334',308.00,360.00,0.00,3913.40,1205327.20,1275890.00,70562.80,531449),('1','136','181339','334',308.00,360.00,0.00,2543.85,783505.80,854426.00,70920.20,532002),('1','136','181529','334',308.00,360.00,0.00,5905.56,1818912.48,1916508.00,97595.52,532494),('1','136','181718','334',308.00,360.00,0.00,5904.37,1818545.96,1913030.20,94484.24,532984),('1','136','181910','334',308.00,360.00,0.00,7544.13,2323592.04,2424688.80,101096.76,533516),('1','136','182110','334',308.00,360.00,0.00,0.00,0.00,0.00,0.00,534050),('1','136','182111','334',308.00,360.00,0.00,8559.09,2636199.72,2711889.40,75689.68,534051),('1','136','182305','334',308.00,360.00,0.00,95.78,29500.24,32040.80,2540.56,534552),('1','136','182321','334',308.00,360.00,0.00,8780.14,2726002.42,2821511.40,95508.98,534580),('1','136','182502','334',313.00,360.00,0.00,7384.59,2311376.67,2367750.40,56373.73,535079),('1','136','182680','334',313.00,360.00,0.00,5109.60,1599304.80,1668232.00,68927.20,535554),('1','136','183095','334',313.00,360.00,0.00,7040.90,2203801.70,2273614.00,69812.30,536676),('1','136','183180','334',313.00,360.00,0.00,10313.70,3228188.10,3305869.00,77680.90,536888),('1','136','183214','334',313.00,360.00,0.00,10689.55,3345829.15,3399655.00,53825.85,536968),('1','136','183424','334',313.00,360.00,0.00,266.13,83298.69,92906.80,9608.11,537513),('1','136','183469','334',313.00,360.00,0.00,4709.79,1474164.27,1533826.60,59662.33,537619),('1','136','183643','334',313.00,360.00,0.00,11426.29,3576428.77,3646356.40,69927.63,538092),('1','136','183871','334',313.00,360.00,0.00,7160.28,2241167.64,2314513.80,73346.16,538701),('1','136','184153','334',313.00,360.00,0.00,9339.19,2923166.47,3032638.40,109471.93,539445),('1','136','184265','334',313.00,360.00,0.00,7590.33,2375773.29,2465786.80,90013.51,539749),('1','136','184469','334',313.00,360.00,0.00,9235.21,2890620.73,2923071.60,32450.87,540267),('1','136','184633','334',313.00,360.00,0.00,2151.30,673356.90,694850.00,21493.10,540724),('1','136','184697','334',313.00,360.00,0.00,8553.85,2677355.05,2757456.00,80100.95,540886),('1','136','184896','334',313.00,360.00,0.00,6432.36,2013328.68,2079900.60,66571.92,541421),('1','136','185114','334',313.00,360.00,0.00,5229.57,1636855.41,1703333.20,66477.79,541975),('1','136','185260','334',313.00,360.00,0.00,9274.44,2902899.72,2982480.40,79580.68,542337),('1','136','185467','334',313.00,360.00,0.00,6252.53,1957041.89,2045138.80,88096.91,542887),('1','136','185674','334',313.00,360.00,0.00,7706.94,2412272.22,2519055.80,106783.58,543441),('1','136','185880','334',313.00,360.00,0.00,3695.08,1156560.04,1222832.80,66272.76,543987),('1','136','185976','334',313.00,360.00,0.00,2591.05,810998.65,857155.60,46156.95,544245),('1','136','186078','334',313.00,360.00,0.00,6102.56,1910101.28,2023427.20,113325.92,544514),('1','136','186318','334',313.00,360.00,0.00,11795.11,3691869.43,3870247.60,178378.17,545137),('1','136','186533','334',313.00,360.00,0.00,9412.97,2946259.61,3081863.20,135603.59,545711),('1','136','186755','334',313.00,360.00,0.00,5782.10,1809797.30,1904488.00,94690.70,546281),('1','136','186985','334',313.00,360.00,0.00,9591.67,3002192.71,3116447.20,114254.49,546856),('1','136','187159','334',313.00,360.00,0.00,1373.34,429855.42,451738.40,21882.98,547331),('1','136','187207','334',313.00,360.00,0.00,5615.70,1757714.10,1851918.00,94203.90,547448),('1','136','187376','334',313.00,360.00,0.00,7362.97,2304609.61,2414950.96,110341.35,547892),('1','136','187611','334',313.00,360.00,0.00,5931.57,1856581.41,1940703.60,84122.19,548510),('1','136','187837','334',313.00,360.00,0.00,10141.96,3174433.48,3295381.60,120948.12,549109),('1','136','188020','334',313.00,360.00,0.00,6214.13,1945022.69,2058370.80,113348.11,549589),('1','136','188218','334',313.00,360.00,0.00,10009.31,3132914.03,3284449.60,151535.57,550105),('1','136','188429','334',313.00,360.00,0.00,3557.83,1113600.79,1169476.40,55875.61,550653),('1','136','188504','334',313.00,360.00,0.00,5139.08,1608532.04,1685863.60,77331.56,550840),('1','136','188609','334',313.00,360.00,0.00,150.00,46950.00,48600.00,1650.00,551105),('1','136','188612','334',313.00,360.00,0.00,7944.15,2486518.95,2622054.00,135535.05,551109),('1','136','188812','334',313.00,360.00,0.00,12247.51,3833470.63,4021671.60,188200.97,551640),('1','136','189015','334',313.00,360.00,0.00,5103.80,1597489.40,1674564.00,77074.60,552180),('1','136','189212','334',313.00,360.00,0.00,7148.72,2237549.36,2350017.20,112467.84,552690),('1','136','189427','334',313.00,360.00,0.00,6031.90,1887984.70,1992008.00,104023.30,553259),('1','136','189622','334',313.00,360.00,0.00,6486.65,2030321.45,2130036.00,99714.55,553762),('1','136','189811','334',313.00,360.00,0.00,3362.01,1052309.13,1102823.60,50514.47,554252),('1','136','189890','334',313.00,360.00,0.00,4342.02,1359052.26,1435061.20,76008.94,554445),('1','136','190034','334',313.00,360.00,0.00,3894.53,1218987.89,1296838.80,77850.91,554831),('1','136','190216','334',313.00,360.00,0.00,8754.19,2740061.47,2884490.40,144428.93,555308),('1','136','190445','334',313.00,360.00,0.00,5447.66,1705117.58,1798445.60,93328.02,555900),('1','136','190667','334',313.00,360.00,0.00,5625.97,1760928.61,1853587.20,92658.59,556504),('1','136','190895','334',313.00,360.00,0.00,8407.19,2631450.47,2765368.40,133917.93,557095),('1','136','191087','334',313.00,360.00,0.00,8123.91,2542783.83,2664335.60,121551.77,557595),('1','136','191296','334',313.00,360.00,0.00,4710.01,1474233.13,1546007.64,71774.51,558146),('1','136','191501','334',313.00,360.00,0.00,183.00,57279.00,59400.00,2121.00,558688),('1','136','191508','334',313.00,360.00,0.00,6469.40,2024922.20,2143232.00,118309.80,558700),('1','136','191708','334',313.00,360.00,0.00,6771.30,2119416.90,2234120.00,114703.10,559247),('1','136','191940','334',313.00,360.00,0.00,4172.87,1306108.31,1388169.20,82060.89,559865),('1','136','192135','334',313.00,360.00,0.00,7115.88,2227270.44,2357032.80,129762.36,560378),('1','136','192535','334',313.00,360.00,0.00,4290.70,1342989.10,1429972.00,86982.90,561438),('1','136','192569','334',313.00,360.00,0.00,5420.33,1696563.29,1805542.80,108979.51,561508),('1','136','192753','334',313.00,360.00,0.00,6343.35,1985468.55,2108481.04,123012.49,561998),('1','136','192955','334',313.00,360.00,0.00,4330.81,1355543.53,1404731.60,49188.07,562521),('1','136','193188','334',313.00,360.00,0.00,4388.77,1373685.01,1416449.20,42764.19,563130),('1','136','193237','334',313.00,320.00,0.00,0.00,0.00,0.00,0.00,563270),('1','136','193372','334',313.00,360.00,0.00,6819.80,2134597.40,2240490.00,105892.60,563632),('1','136','193418','334',313.00,360.00,0.00,4451.81,1393416.53,1479752.40,86335.87,563735),('1','136','193621','334',313.00,360.00,0.00,5082.49,1590819.37,1693436.80,102617.43,564278),('1','136','193897','334',313.00,360.00,0.00,4320.21,1352225.73,1442616.52,90390.79,564949),('1','136','194237','334',313.00,360.00,0.00,4074.62,1275356.06,1309955.90,34599.84,565840),('1','136','194443','334',313.00,360.00,0.00,7407.62,2318585.06,2454861.60,136276.54,566357),('1','136','194485','334',313.00,360.00,0.00,7057.41,2208969.33,2495813.60,286844.27,566459),('1','136','194681','334',313.00,360.00,0.00,4916.83,1538967.79,1629964.80,90997.01,566950),('1','136','195046','334',313.00,360.00,0.00,4747.00,1485811.00,1575124.00,89313.00,567925),('1','136','195195','334',313.00,360.00,0.00,904.70,283171.10,305056.00,21884.90,568304),('1','136','195254','334',313.00,360.00,0.00,4169.94,1305191.22,1384070.40,78879.18,568465),('1','136','195330','334',313.00,360.00,0.00,3948.48,1235874.24,1320000.00,84125.76,568633),('1','136','195516','334',313.00,360.00,0.00,7062.29,2210496.77,2319525.32,109028.55,569135),('1','136','195782','334',313.00,360.00,0.00,4898.42,1533205.46,1630333.60,97128.14,569793),('1','136','196189','334',313.00,360.00,0.00,4354.30,1362895.90,1448568.00,85672.10,570821),('1','136','196274','334',313.00,360.00,0.00,276.00,86388.00,89424.00,3036.00,571026),('1','136','196404','334',313.00,360.00,0.00,6381.29,1997343.77,2103643.92,106300.15,571376),('1','136','196600','334',313.00,360.00,0.00,5234.78,1638486.14,1735574.00,97087.86,571885),('1','136','196833','334',313.00,360.00,0.00,6963.20,2179481.60,2278972.00,99490.40,572488),('1','136','197002','334',313.00,360.00,0.00,3297.31,1032058.03,1078453.60,46395.57,572933),('1','136','197179','334',313.00,360.00,0.00,4358.40,1364179.20,1421372.00,57192.80,573389),('1','136','197404','334',313.00,360.00,0.00,7103.80,2223489.40,2311394.00,87904.60,573899),('1','136','197413','334',313.00,360.00,0.00,5176.75,1620322.75,1700562.00,80239.25,573920),('1','136','197512','334',313.00,360.00,0.00,5855.97,1832918.61,1912708.80,79790.19,574160),('1','136','197879','334',313.00,360.00,0.00,4611.75,1443477.75,1512718.00,69240.25,575139),('1','136','198138','334',313.00,360.00,0.00,360.00,112680.00,115200.00,2520.00,575795),('1','136','198240','334',311.00,360.00,0.00,6727.16,2092146.76,2170389.60,78242.84,576058),('1','136','198352','334',311.00,360.00,0.00,3784.75,1177057.25,1235972.80,58915.55,576360),('1','136','198579','334',311.00,360.00,0.00,7052.91,2193455.01,2259371.18,65916.17,576950),('1','136','198796','334',311.00,360.00,0.00,5816.92,1809062.12,1904311.16,95249.04,577474),('1','136','199144','334',311.00,360.00,0.00,1367.00,425137.00,450920.00,25783.00,578405),('1','136','199145','334',311.00,360.00,0.00,987.00,306957.00,450920.00,143963.00,578406),('1','136','199151','334',311.00,360.00,0.00,4571.98,1421885.78,1484650.80,62765.02,578422),('1','136','199398','334',311.00,360.00,0.00,6738.00,2095518.00,2163192.00,67674.00,579007),('1','136','199604','334',311.00,360.00,0.00,3980.70,1237997.70,1292684.00,54686.30,579535),('1','136','199646','334',311.00,360.00,0.00,4544.38,1413302.18,1471092.80,57790.62,579634),('1','136','200040','334',311.00,360.00,0.00,4881.40,1518115.40,1582362.00,64246.60,580627),('1','136','200264','334',307.00,360.00,0.00,4274.10,1312148.70,1395770.40,83621.70,581206),('1','136','200331','334',307.00,360.00,0.00,6691.13,2054176.91,2159674.80,105497.89,581365),('1','136','200493','334',307.00,360.00,0.00,9743.93,2991386.51,3126166.80,134780.29,581791),('1','136','200697','334',307.00,360.00,0.00,3891.22,1194604.54,1262019.20,67414.66,582325),('1','136','200938','334',307.00,360.00,0.00,8096.99,2485775.93,2606608.40,120832.47,582928),('1','136','201114','334',307.00,360.00,0.00,4230.85,1298870.95,1380543.20,81672.25,583383),('1','136','201348','334',307.00,360.00,0.00,5901.46,1811748.22,1908449.20,96700.98,583977),('1','136','201499','334',307.00,360.00,0.00,5659.84,1737570.88,1849822.40,112251.52,584384),('1','136','201765','334',307.00,360.00,0.00,852.92,261846.44,276959.20,15112.76,585089),('1','136','201948','334',317.00,360.00,0.00,5044.70,1599169.90,1699796.00,100626.10,585582),('1','136','202072','334',317.00,360.00,0.00,860.00,272620.00,285520.00,12900.00,585892),('1','136','202151','334',317.00,360.00,0.00,5286.00,1675662.00,1778432.00,102770.00,586101),('1','136','202317','334',307.00,360.00,0.00,7553.47,2318915.29,2548659.36,229744.07,586525),('1','136','202433','334',307.00,360.00,0.00,3872.08,1188728.56,1306588.56,117860.00,586821),('1','136','202556','334',317.00,360.00,0.00,2013.14,638165.38,681450.40,43285.02,587135),('1','136','202650','334',317.00,360.00,0.00,3097.40,981875.80,1048556.80,66681.00,587376),('1','136','202801','334',317.00,360.00,0.00,2781.93,881871.81,941264.00,59392.19,587771),('1','136','202859','334',317.00,360.00,0.00,5532.90,1753929.30,1874486.00,120556.70,587914),('1','136','203119','334',317.00,360.00,0.00,2850.01,903453.17,967401.20,63948.03,588587),('1','136','203274','334',317.00,360.00,0.00,2857.00,905669.00,923440.00,17771.00,589009),('1','136','203481','334',317.00,360.00,0.00,2888.00,915496.00,912015.00,-3481.00,589532),('1','136','203486','334',307.00,360.00,0.00,6395.70,1963479.90,2158168.00,194688.10,589544),('1','136','203628','334',307.00,360.00,0.00,2021.40,620569.80,673336.00,52766.20,589912),('1','136','203638','334',307.00,360.00,0.00,5560.96,1707214.72,1864885.60,157670.88,589937),('1','136','203741','334',307.00,360.00,0.00,8022.76,2462987.32,2729015.36,266028.04,590192),('1','136','203968','334',307.00,376.00,0.00,3702.32,1136612.24,1297728.32,161116.08,590778),('1','136','204195','334',307.00,376.00,0.00,6527.87,2004056.09,2258811.52,254755.43,591377),('1','136','204403','334',307.00,376.00,0.00,829.02,254509.14,289983.52,35474.38,591911),('1','136','204481','334',314.00,376.00,0.00,5805.88,1823046.32,2008056.88,185010.56,592119),('1','136','204624','334',314.00,376.00,0.00,11349.20,3563648.80,3759513.44,195864.64,592479),('1','136','204840','334',314.00,376.00,0.00,4726.77,1484205.78,1645788.56,161582.78,592994),('1','136','205041','334',314.00,376.00,0.00,3434.15,1078323.10,1217184.40,138861.30,593515),('1','136','205238','334',314.00,376.00,0.00,1214.17,381249.38,425551.92,44302.54,594029),('1','136','205345','334',314.00,344.00,0.00,0.00,0.00,0.00,0.00,594298),('1','136','205361','334',318.00,376.00,0.00,3678.97,1169912.46,1273618.72,103706.26,594342),('1','136','205469','334',318.00,376.00,0.00,3360.31,1068578.58,1174672.96,106094.38,594622),('1','136','205749','334',318.00,376.00,0.00,4156.26,1321690.68,1454409.48,132718.80,595337),('1','136','205941','334',318.00,376.00,0.00,4533.39,1441618.02,1570436.88,128818.86,595843),('1','136','206148','334',318.00,376.00,0.00,4008.99,1274858.82,1391536.28,116677.46,596372),('1','136','206358','334',318.00,376.00,0.00,5122.33,1628900.94,1695133.08,66232.14,596907),('1','136','206525','334',314.00,376.00,0.00,2587.10,812349.40,905029.60,92680.20,597337),('1','136','206574','334',314.00,376.00,0.00,6709.94,2106921.16,2339000.00,232078.84,597452),('1','136','206811','334',314.00,376.00,0.00,5144.68,1615429.52,1786620.12,171190.60,598063),('1','136','207047','334',314.00,376.00,0.00,5164.72,1621722.08,1791362.72,169640.64,598671),('1','136','207247','334',314.00,376.00,0.00,4312.31,1354065.34,1508088.56,154023.22,599200),('1','136','207479','334',314.00,376.00,0.00,811.20,254716.80,280891.20,26174.40,599799),('1','136','207655','334',322.00,376.00,0.00,4958.00,1596476.00,1623274.40,26798.40,600247),('1','136','207659','334',314.00,376.00,0.00,599.11,188120.54,209817.36,21696.82,600255),('1','136','207707','334',314.00,376.00,0.00,4225.29,1326741.06,1510263.04,183521.98,600372),('1','136','207908','334',314.00,384.00,0.00,5834.25,1831954.50,2085468.32,253513.82,600883),('1','136','208108','334',314.00,384.00,0.00,9739.53,3058212.42,3327486.72,269274.30,601402),('1','136','208316','334',314.00,384.00,0.00,3841.76,1206312.64,1372047.84,165735.20,601936),('1','136','208643','334',314.00,384.00,0.00,233.66,73369.24,84285.44,10916.20,602771),('1','136','208733','334',322.00,384.00,0.00,2931.52,943949.44,1052752.08,108802.64,603022),('1','136','208961','334',322.00,384.00,0.00,8327.50,2681455.00,2813443.00,131988.00,603589),('1','136','208991','334',322.00,384.00,0.00,3990.35,1590825.86,1489453.28,-101372.58,603662),('1','136','209223','334',400.00,400.00,0.00,3262.29,1304916.00,1224091.72,-80824.28,604247),('1','136','209438','334',400.00,400.00,0.00,4650.38,1860152.00,1747238.00,-112914.00,604791),('1','136','209645','334',400.00,400.00,0.00,1473.68,589472.00,557856.96,-31615.04,605322),('1','136','209763','334',322.00,400.00,0.00,4603.35,1482278.70,1716350.20,234071.50,605637),('1','136','209858','334',420.00,420.00,0.00,486.10,204162.00,192656.00,-11506.00,605882),('1','136','209976','334',420.00,420.00,0.00,2275.61,820690.80,858969.80,38279.00,606182),('1','136','210099','334',360.00,420.00,0.00,1140.41,410547.60,478972.20,68424.60,606512),('1','136','210305','334',360.00,420.00,0.00,907.50,326700.00,381150.00,54450.00,607042),('1','136','210511','334',260.00,420.00,0.00,948.11,246508.60,398206.20,151697.60,607586),('1','136','210729','334',260.00,420.00,0.00,1135.92,295339.20,477086.40,181747.20,608154),('1','136','210982','334',260.00,420.00,0.00,3246.29,1213571.40,1145993.60,-67577.80,608791),('1','136','211137','334',376.00,420.00,0.00,2869.20,1078819.20,1079794.20,975.00,609206),('1','136','211167','334',424.00,424.00,0.00,6223.29,2638674.96,2479196.80,-159478.16,609279),('1','136','211369','334',424.00,424.00,0.00,9972.93,4228522.32,3806783.80,-421738.52,609807),('1','136','211651','334',424.00,424.00,0.00,5418.81,2297575.44,2135991.00,-161584.44,610533),('1','136','211842','334',424.00,424.00,0.00,310.20,131524.80,121598.40,-9926.40,611013),('1','136','211848','334',376.00,424.00,0.00,4998.05,1879266.80,1979541.52,100274.72,611027),('1','136','211985','334',376.00,424.00,0.00,675.45,253969.20,286390.80,32421.60,611394),('1','136','212196','334',365.00,424.00,0.00,417.99,152566.35,177227.76,24661.41,611956),('1','136','212230','334',365.00,424.00,0.00,870.99,317911.35,369299.76,51388.41,612032),('1','136','212453','334',365.00,424.00,0.00,1325.32,483741.80,551750.92,68009.12,612625),('1','136','212663','334',365.00,424.00,0.00,1887.75,689028.75,775475.28,86446.53,613185),('1','136','212940','334',365.00,424.00,0.00,1360.56,496604.40,549189.12,52584.72,613900),('1','136','213131','334',365.00,424.00,0.00,2409.49,892918.41,954025.68,61107.27,614400),('1','136','213369','334',379.00,424.00,0.00,1830.97,693937.63,741408.08,47470.45,615025),('1','136','213370','334',379.00,424.00,0.00,1371.73,519885.67,548392.24,28506.57,615026),('1','136','213389','334',379.00,424.00,0.00,2717.90,1030084.10,1109845.60,79761.50,615065),('1','136','213627','334',379.00,424.00,0.00,4756.43,1802686.97,1897233.20,94546.23,615703),('1','136','213892','334',379.00,424.00,0.00,2924.20,1108271.80,1172718.00,64446.20,616391),('1','136','214097','334',379.00,424.00,0.00,5112.58,1937667.82,2036219.52,98551.70,616924),('1','136','214326','334',379.00,424.00,0.00,4853.68,1839544.72,1939089.12,99544.40,617526),('1','136','214528','334',379.00,424.00,0.00,3157.54,1196707.66,1254268.96,57561.30,618035),('1','136','214857','334',379.00,424.00,0.00,4444.38,1684420.02,1759309.12,74889.10,618899),('1','136','214999','334',379.00,424.00,0.00,5935.99,2249740.21,2347277.36,97537.15,619270),('1','136','215230','334',379.00,424.00,0.00,3681.61,1582983.28,1547346.88,-35636.40,619855),('1','136','215440','334',448.00,448.00,0.00,6100.79,2733153.92,2461888.32,-271265.60,620401),('1','136','215675','334',448.00,448.00,0.00,3820.30,1711494.40,1613812.60,-97681.80,621011),('1','136','215903','334',448.00,448.00,0.00,707.11,316785.28,298657.28,-18128.00,621591),('1','136','215981','334',379.00,448.00,0.00,4606.87,1746003.73,1938660.08,192656.35,621793),('1','136','216097','334',379.00,448.00,0.00,3017.38,1143587.02,1274618.16,131031.14,622099),('1','136','216323','334',379.00,448.00,0.00,3745.56,1692993.12,1578293.12,-114700.00,622681),('1','136','216557','334',452.00,452.00,0.00,3871.23,1749795.96,1637087.56,-112708.40,623302),('1','136','216784','334',452.00,452.00,0.00,7791.24,3521640.48,3265744.88,-255895.60,623903),('1','136','217025','334',480.00,480.00,0.00,656.48,315110.40,315110.40,0.00,624526),('1','136','217234','334',480.00,480.00,0.00,1689.70,811056.00,660599.50,-150456.50,625092),('1','136','217241','334',431.00,480.00,0.00,1038.90,447765.90,498672.00,50906.10,625111),('1','136','217268','334',431.00,480.00,0.00,1568.93,676208.83,753086.40,76877.57,625174),('1','136','217502','334',431.00,480.00,0.00,529.37,228158.47,254097.60,25939.13,625786),('1','136','217569','334',480.00,480.00,0.00,1630.24,782515.20,782515.20,0.00,625947),('1','136','217709','334',480.00,480.00,0.00,1630.62,782697.60,741380.40,-41317.20,626317),('1','136','217976','334',480.00,480.00,0.00,1519.48,729350.40,683650.40,-45700.00,627029),('1','136','218095','334',480.00,480.00,0.00,5811.47,2467063.52,2517462.60,50399.08,627330),('1','136','218216','334',421.00,480.00,0.00,3462.08,1457535.68,1550038.40,92502.72,627655),('1','136','218448','334',421.00,480.00,0.00,2859.17,1203710.57,1289049.24,85338.67,628265),('1','136','218681','334',421.00,480.00,0.00,7240.12,3048090.52,3141021.60,92931.08,628870),('1','136','218899','334',421.00,480.00,0.00,4694.77,1976498.17,2105355.08,128856.91,629446),('1','136','219133','334',421.00,480.00,0.00,244.00,102724.00,109480.00,6756.00,630042),('1','136','219212','334',421.00,480.00,0.00,5123.57,2157022.97,2295956.40,138933.43,630257),('1','136','219343','334',421.00,480.00,0.00,3185.61,1341141.81,1433616.80,92474.99,630590),('1','136','219601','334',421.00,480.00,0.00,2587.16,1089194.36,1160481.36,71287.00,631275),('1','136','219808','334',421.00,480.00,0.00,2841.51,1196275.71,1277892.32,81616.61,631819),('1','136','220039','334',421.00,480.00,0.00,3498.28,1472775.88,1542263.20,69487.32,632437),('1','136','220245','334',421.00,480.00,0.00,3299.37,1389034.77,1460184.96,71150.19,632976),('1','136','220465','334',421.00,480.00,0.00,3868.00,1628428.00,1721642.00,93214.00,633556),('1','136','220709','334',420.00,480.00,0.00,5784.91,2429662.20,2533663.36,104001.16,634180),('1','136','220904','334',420.00,480.00,0.00,3726.47,1565117.40,1644783.08,79665.68,634701),('1','136','221140','334',420.00,480.00,0.00,4950.11,2079046.20,2176844.00,97797.80,635310),('1','136','221380','334',420.00,480.00,0.00,2962.22,1244132.40,1326100.88,81968.48,635942),('1','136','221613','334',420.00,480.00,0.00,5519.90,2318358.00,2446892.40,128534.40,636545),('1','136','221830','334',420.00,480.00,0.00,1753.20,736344.00,756046.00,19702.00,637110),('1','136','221910','334',431.00,480.00,0.00,3358.21,1447388.51,1509099.20,61710.69,637308),('1','136','222056','334',431.00,480.00,0.00,1792.48,772558.88,808426.40,35867.52,637703),('1','136','222192','334',436.00,480.00,0.00,1109.50,483742.00,508960.00,25218.00,638047),('1','136','222263','334',436.00,480.00,0.00,1690.29,736966.44,769208.80,32242.36,638226),('1','136','222395','334',436.00,480.00,0.00,2769.23,1207384.28,1242950.40,35566.12,638567),('1','136','222485','334',436.00,480.00,0.00,1330.30,580010.80,638544.00,58533.20,638797),('1','136','222725','334',436.00,480.00,0.00,954.97,416366.92,458385.60,42018.68,639434),('1','136','223007','334',436.00,480.00,0.00,1166.24,508480.64,559795.20,51314.56,640189),('1','136','223143','334',436.00,480.00,0.00,0.00,0.00,0.00,0.00,640553),('1','136','223174','334',436.00,480.00,0.00,1194.97,521006.92,573585.60,52578.68,640617),('1','136','223414','334',436.00,480.00,0.00,1360.17,614437.23,646974.48,32537.25,641201),('1','136','223738','334',459.00,512.00,0.00,1346.38,617988.42,657780.32,39791.90,642028),('1','136','223804','334',459.00,512.00,0.00,975.40,447708.60,466236.80,18528.20,642202),('1','136','223946','334',459.00,512.00,0.00,3755.34,1723701.06,1791846.08,68145.02,642560),('1','136','224086','334',459.00,512.00,0.00,292.67,134335.53,139959.04,5623.51,642928),('1','136','224276','334',449.00,512.00,0.00,2595.25,1165267.25,1244128.32,78861.07,643435),('1','136','224307','334',449.00,512.00,0.00,3170.58,1423590.42,1537406.08,113815.66,643504),('1','136','224527','334',449.00,512.00,0.00,2723.28,1222752.72,1344191.72,121439.00,644091),('1','136','224774','334',449.00,512.00,0.00,2895.41,1300039.09,1432401.06,132361.97,644718),('1','136','225011','334',449.00,512.00,0.00,2642.34,1186410.66,1305754.56,119343.90,645328),('1','136','225264','334',449.00,512.00,0.00,7541.74,3386241.26,3662431.88,276190.62,645982),('1','136','225478','334',449.00,512.00,0.00,3140.78,1410210.22,1553152.16,142941.94,646532),('1','136','225654','334',475.00,512.00,0.00,2111.31,1002872.25,1026655.32,23783.07,646994),('1','136','225701','334',475.00,512.00,0.00,2932.23,1404347.33,1428510.76,24163.43,647104),('1','136','225845','334',475.00,512.00,0.00,2290.24,1245715.30,1139521.14,-106194.16,647490),('1','136','225977','334',544.00,544.00,0.00,4053.29,2204989.76,2006520.30,-198469.46,647828),('1','136','226185','334',475.00,544.00,0.00,911.65,433033.75,451529.00,18495.25,648382),('1','136','226355','334',475.00,544.00,0.00,1684.59,800180.25,835578.96,35398.71,648816),('1','136','226366','334',465.00,544.00,0.00,5295.46,2462388.90,2623906.24,161517.34,648845),('1','136','226477','334',465.00,544.00,0.00,7043.42,3275190.30,3484096.48,208906.18,649118),('1','136','226729','334',465.00,544.00,0.00,4172.71,1940310.15,2077915.98,137605.83,649770),('1','136','226963','334',465.00,544.00,0.00,8117.15,3774474.75,4001619.02,227144.27,650385),('1','136','227213','334',476.00,544.00,0.00,6395.40,3044210.40,3181180.78,136970.38,651024),('1','136','227367','334',476.00,544.00,0.00,5369.50,2555882.00,2667795.00,111913.00,651421),('1','136','227616','334',476.00,544.00,0.00,10467.54,4982549.04,5149156.90,166607.86,652058),('1','136','227851','334',476.00,544.00,0.00,2217.63,1055591.88,1101114.78,45522.90,652673),('1','136','227976','334',476.00,544.00,0.00,819.17,389924.92,425328.48,35403.56,653005),('1','136','228108','334',476.00,544.00,0.00,984.18,468469.68,535393.92,66924.24,653366),('1','136','228324','334',486.00,544.00,0.00,852.16,414149.76,463575.04,49425.28,653935),('1','136','228362','334',560.00,560.00,0.00,2679.77,1500671.20,1414564.56,-86106.64,654007),('1','136','228500','334',486.00,560.00,0.00,2685.36,1305084.96,1370577.20,65492.24,654375),('1','136','228532','334',486.00,560.00,0.00,4364.89,2121336.54,2281870.12,160533.58,654443),('1','136','228754','334',486.00,560.00,0.00,526.57,255913.02,277119.20,21206.18,655012),('1','136','228788','334',486.00,560.00,0.00,4258.19,2069480.34,2224561.28,155080.94,655088),('1','136','228934','334',486.00,560.00,0.00,835.70,406150.20,399397.00,-6753.20,655472),('1','136','229032','334',476.00,560.00,0.00,5891.30,2804258.80,2921230.40,116971.60,655721),('1','136','229171','334',476.00,560.00,0.00,7614.57,3624535.32,3930463.40,305928.08,656098),('1','136','229414','334',584.00,584.00,0.00,3976.01,2321989.84,2144774.48,-177215.36,656720),('1','136','229663','334',584.00,584.00,0.00,3393.98,1982084.32,1831508.40,-150575.92,657359),('1','136','229878','334',584.00,584.00,0.00,4018.93,2347055.12,2179279.12,-167776.00,657912),('1','136','230039','334',486.00,584.00,0.00,332.35,161522.10,190452.40,28930.30,658337),('1','136','230086','334',486.00,584.00,0.00,1855.97,902001.42,1083886.48,181885.06,658446),('1','136','230233','334',584.00,584.00,0.00,519.97,303662.48,303662.48,0.00,658840),('1','136','230281','334',584.00,584.00,0.00,1680.42,981365.28,981365.28,0.00,658946),('1','136','230595','334',586.00,584.00,0.00,1163.66,681904.76,679577.44,-2327.32,659756),('1','136','230783','334',586.00,584.00,0.00,1555.59,911575.74,908464.56,-3111.18,660250),('1','136','231059','334',586.00,584.00,0.00,319.42,156299.12,186541.28,30242.16,660987),('1','136','231191','334',486.00,584.00,0.00,2007.14,975470.04,1172169.76,196699.72,661326),('1','136','231375','334',486.00,584.00,0.00,1610.10,782508.60,912298.40,129789.80,661827),('1','136','231638','334',486.00,584.00,0.00,1491.65,724941.90,871123.60,146181.70,662513),('1','136','232024','334',486.00,584.00,0.00,70.00,34020.00,40880.00,6860.00,663563),('1','136','232033','334',526.00,584.00,0.00,837.30,440419.80,488983.20,48563.40,663586),('1','136','232100','334',526.00,584.00,0.00,986.36,518825.36,576034.24,57208.88,663763),('1','136','232252','334',516.00,584.00,0.00,765.75,395127.00,427337.04,32210.04,664153),('1','136','232325','334',516.00,584.00,0.00,5698.22,2940281.52,2987990.26,47708.74,664339),('1','136','232588','334',600.00,600.00,0.00,3233.83,1940298.00,1855286.00,-85012.00,665035),('1','136','232853','334',600.00,600.00,0.00,4061.35,2436810.00,2321839.46,-114970.54,665735),('1','136','233120','334',600.00,600.00,0.00,4305.52,2583312.00,2455529.00,-127783.00,666425),('1','136','233361','334',584.00,584.00,0.00,1033.41,644265.84,629465.84,-14800.00,667072),('1','136','233597','334',624.00,624.00,0.00,1444.01,901062.24,881062.24,-20000.00,667686),('1','136','233840','334',624.00,624.00,0.00,2017.71,1259051.04,1211159.54,-47891.50,668322),('1','136','234043','334',624.00,624.00,0.00,2203.04,1374696.96,994421.12,-380275.84,668859),('1','136','234309','334',624.00,624.00,0.00,596.46,372191.04,350295.04,-21896.00,669563),('1','136','234422','334',560.00,624.00,0.00,1380.29,772962.40,829103.26,56140.86,669864),('1','136','234551','334',560.00,624.00,0.00,1545.23,865328.80,923923.52,58594.72,670213),('1','136','234809','334',560.00,624.00,0.00,1731.81,969813.60,1037455.44,67641.84,670895),('1','136','235059','334',560.00,624.00,0.00,2574.69,1441826.40,1523740.32,81913.92,671573),('1','136','235289','334',560.00,624.00,0.00,3546.40,1985984.00,2093390.34,107406.34,672163),('1','136','235513','334',560.00,624.00,0.00,4116.75,2305380.00,2419938.64,114558.64,672741),('1','136','235751','334',560.00,624.00,0.00,3311.33,2102463.20,2007917.60,-94545.60,673349),('1','136','236003','334',640.00,640.00,0.00,2266.62,1450636.80,1397103.60,-53533.20,674024),('1','136','236237','334',640.00,640.00,0.00,1582.33,1012691.20,979731.20,-32960.00,674633),('1','136','236514','334',640.00,640.00,0.00,2399.69,1535801.60,1478441.60,-57360.00,675364),('1','136','236731','334',582.00,640.00,0.00,2774.28,1614630.96,1691210.00,76579.04,675924),('1','136','236944','334',582.00,640.00,0.00,3070.51,1787036.82,1887900.00,100863.18,676483),('1','136','237164','334',582.00,640.00,0.00,2969.43,1728208.26,1798915.20,70706.94,677041),('1','136','237370','334',582.00,640.00,0.00,2625.78,1528203.96,1610139.20,81935.24,677575),('1','136','237649','334',656.00,656.00,0.00,5530.03,3627699.68,3385317.88,-242381.80,678284),('1','136','237896','334',656.00,656.00,0.00,5544.25,3581015.36,3394797.86,-186217.50,678926),('1','136','238113','334',640.00,640.00,0.00,2102.83,1345811.20,1295468.80,-50342.40,679509),('1','136','238259','334',602.00,640.00,0.00,3481.21,2095688.42,2118154.64,22466.22,679877),('1','136','238352','334',602.00,640.00,0.00,1833.11,1103532.22,1116582.40,13050.18,680111),('1','136','238563','334',602.00,640.00,0.00,3349.17,2016200.34,2046847.80,30647.46,680683),('1','136','238734','334',602.00,640.00,0.00,1541.45,927952.90,934118.70,6165.80,681110),('1','136','238736','334',602.00,640.00,0.00,5202.75,3132055.50,3175573.30,43517.80,681114),('1','136','238780','334',602.00,640.00,0.00,4961.92,2987075.84,3026241.72,39165.88,681229),('1','136','239003','334',602.00,640.00,0.00,304.00,183008.00,184832.00,1824.00,681813),('1','136','239005','334',602.00,640.00,0.00,2898.71,1745023.42,1791454.40,46430.98,681817),('1','136','239273','334',602.00,640.00,0.00,2244.61,1351255.22,1378903.68,27648.46,682523),('1','136','239274','334',602.00,640.00,0.00,3777.51,2274061.02,2301666.84,27605.82,682524),('1','136','239482','334',602.00,640.00,0.00,1242.46,747960.92,764006.40,16045.48,683063),('1','136','239488','334',602.00,640.00,0.00,1694.64,1020173.28,1038669.60,18496.32,683079),('1','136','239602','334',602.00,640.00,0.00,3428.49,2063950.98,2104033.60,40082.62,683363),('1','136','239882','334',602.00,640.00,0.00,757.16,455810.32,467238.40,11428.08,684094),('1','136','239890','334',592.00,640.00,0.00,3550.11,2101665.12,2199366.40,97701.28,684116),('1','136','240071','334',592.00,640.00,0.00,2792.40,1653100.80,1743840.60,90739.80,684581),('1','136','240207','334',592.00,640.00,0.00,3021.97,1789006.24,1889372.62,100366.38,684933),('1','136','240503','334',602.00,640.00,0.00,2658.44,1600380.88,1665168.80,64787.92,685698),('1','136','240678','334',602.00,640.00,0.00,2328.08,1401504.16,1459990.60,58486.44,686126),('1','136','240967','334',602.00,640.00,0.00,184.54,111093.08,115033.60,3940.52,686897),('1','136','241010','334',592.00,640.00,0.00,2713.54,1606415.68,1700531.32,94115.64,686998),('1','136','241214','334',592.00,640.00,0.00,2514.44,1488548.48,1553154.60,64606.12,687549),('1','136','241478','334',592.00,640.00,0.00,1819.15,1076936.80,1124723.16,47786.36,688251),('1','136','241722','334',592.00,640.00,0.00,3034.47,1796406.24,1859252.08,62845.84,688885),('1','136','241972','334',592.00,640.00,0.00,3380.57,2001297.44,2074517.10,73219.66,689539),('1','136','242193','334',592.00,640.00,0.00,3493.54,2068175.68,2157500.02,89324.34,690116),('1','136','242430','334',592.00,640.00,0.00,4912.99,2908490.08,2995848.60,87358.52,690717),('1','136','242673','334',592.00,640.00,0.00,2244.57,1328785.44,1386755.80,57970.36,691352),('1','136','242912','334',592.00,640.00,0.00,1342.64,794842.88,823289.60,28446.72,691985),('1','136','243015','334',582.00,640.00,0.00,2732.00,1590024.00,1655636.28,65612.28,692244),('1','136','243144','334',582.00,640.00,0.00,2935.86,1708670.52,1798970.40,90299.88,692584),('1','136','243350','334',582.00,640.00,0.00,4170.91,2427469.62,2541506.20,114036.58,693145),('1','136','243586','334',582.00,640.00,0.00,4951.01,2881487.82,3008215.40,126727.58,693743),('1','136','243829','334',582.00,640.00,0.00,2861.97,1665666.54,1756860.80,91194.26,694364),('1','136','244045','334',582.00,640.00,0.00,3885.49,2261355.18,2360718.60,99363.42,694917),('1','136','244272','334',582.00,640.00,0.00,2464.03,1434065.46,1508524.40,74458.94,695523),('1','136','244508','334',582.00,640.00,0.00,521.77,303670.14,313780.80,10110.66,696132),('1','136','244553','334',582.00,640.00,0.00,3222.34,1907625.28,1969403.40,61778.12,696230),('1','136','244734','334',592.00,640.00,0.00,2122.33,1256419.36,1307166.20,50746.84,696721),('1','136','244964','334',592.00,640.00,0.00,2334.04,1381751.68,1406899.28,25147.60,697322),('1','136','245202','334',592.00,632.00,0.00,3763.32,2227885.44,2259449.60,31564.16,697932),('1','136','245432','334',592.00,632.00,0.00,3090.78,1829741.76,1876152.96,46411.20,698519),('1','136','245730','334',592.00,632.00,0.00,2924.02,1731019.84,1750751.08,19731.24,699272),('1','136','245931','334',592.00,632.00,0.00,4717.48,2792748.16,2702210.88,-90537.28,699818),('1','136','246188','334',592.00,616.00,0.00,7864.93,4656038.56,4472820.88,-183217.68,700470),('1','136','246391','334',548.00,616.00,0.00,1454.03,796808.44,829066.48,32258.04,701031),('1','136','246454','334',548.00,616.00,0.00,4440.27,2433267.96,2552129.92,118861.96,701180),('1','136','246689','334',548.00,616.00,0.00,3454.25,1892929.00,1988645.00,95716.00,701810),('1','136','246928','334',548.00,616.00,0.00,5112.41,2801600.68,2945615.56,144014.88,702417),('1','136','247173','334',548.00,616.00,0.00,4134.12,2265497.76,2396171.92,130674.16,703044),('1','136','247399','334',548.00,616.00,0.00,4677.45,2563242.60,2686219.16,122976.56,703616),('1','136','247654','334',548.00,616.00,0.00,1489.32,816147.36,849545.12,33397.76,704300),('1','136','247764','334',548.00,616.00,0.00,2639.80,1446610.40,1488461.78,41851.38,704550),('1','136','247900','334',548.00,592.00,0.00,3753.14,2056720.72,2129766.40,73045.68,704927),('1','136','248137','334',548.00,592.00,0.00,2883.80,1580322.40,1646297.60,65975.20,705546),('1','136','248400','334',548.00,592.00,0.00,4231.99,2319130.52,2417995.00,98864.48,706218),('1','136','248641','334',548.00,592.00,0.00,5656.82,3099937.36,3192417.92,92480.56,706832),('1','136','248860','334',548.00,592.00,0.00,2748.64,1506254.72,1525320.96,19066.24,707399),('1','136','249104','334',548.00,592.00,0.00,2791.07,1529506.36,1508247.64,-21258.72,708027),('1','136','249273','334',548.00,592.00,0.00,866.15,433075.00,475622.80,42547.80,708453),('1','136','249340','334',500.00,592.00,0.00,4636.45,2318225.00,2500389.36,182164.36,708626),('1','136','249597','334',500.00,592.00,0.00,4641.97,2320985.00,2500741.34,179756.34,709277),('1','136','249850','334',500.00,592.00,0.00,5131.95,2565975.00,2776748.72,210773.72,709931),('1','136','250091','334',500.00,592.00,0.00,4147.86,2073930.00,2256044.04,182114.04,710551),('1','136','250333','334',500.00,592.00,0.00,5203.17,2601585.00,2805274.64,203689.64,711164),('1','136','250498','334',500.00,592.00,0.00,448.81,224405.00,255199.52,30794.52,711582),('1','136','250569','334',500.00,592.00,0.00,2697.84,1348920.00,1469249.28,120329.28,711756),('1','136','250782','334',500.00,592.00,0.00,1844.48,922240.00,996793.16,74553.16,712332),('1','136','250890','334',500.00,592.00,0.00,1869.86,934930.00,1021721.12,86791.12,712583),('1','136','251009','334',500.00,592.00,0.00,4691.07,2345535.00,2529940.52,184405.52,712914),('1','136','251271','334',500.00,592.00,0.00,3515.98,1757990.00,1914506.16,156516.16,713587),('1','136','251518','334',500.00,592.00,0.00,3522.67,1761335.00,1913010.64,151675.64,714231),('1','136','251761','334',500.00,592.00,0.00,4591.99,2295995.00,2485146.08,189151.08,714871),('1','136','251995','334',500.00,592.00,0.00,5500.12,2750060.00,2971077.64,221017.64,715488),('1','136','252242','334',500.00,592.00,0.00,549.30,274650.00,294508.00,19858.00,716125),('1','136','252281','334',500.00,592.00,0.00,5093.87,2546935.00,2760366.24,213431.24,716214),('1','136','252477','334',500.00,592.00,0.00,5963.72,2981860.00,3203204.36,221344.36,716735),('1','136','252707','334',500.00,592.00,0.00,3519.43,1759715.00,1922918.56,163203.56,717341),('1','136','252964','334',500.00,592.00,0.00,5936.93,2968465.00,3209088.72,240623.72,718002),('1','136','253205','334',500.00,592.00,0.00,3191.97,1595985.00,1736512.24,140527.24,718638),('1','136','253478','334',500.00,592.00,0.00,997.19,498595.00,530608.48,32013.48,719338),('1','136','253531','334',500.00,592.00,0.00,2675.31,1337655.00,1450190.72,112535.72,719459),('1','136','253718','334',500.00,592.00,0.00,5750.70,2875350.00,3091082.60,215732.60,719954),('1','136','253944','334',500.00,592.00,0.00,5215.78,2607890.00,2811397.76,203507.76,720558),('1','136','254199','334',500.00,592.00,0.00,4083.80,2041900.00,2194641.80,152741.80,721206),('1','136','254452','334',500.00,592.00,0.00,6740.17,3370085.00,3545191.16,175106.16,721867),('1','136','254642','334',500.00,592.00,0.00,695.69,347845.00,398588.48,50743.48,722354),('1','136','254688','334',500.00,592.00,0.00,4620.14,2310070.00,2480537.32,170467.32,722470),('1','136','254946','334',500.00,592.00,0.00,4976.01,2488005.00,2637541.12,149536.12,723117),('1','136','255187','334',500.00,592.00,0.00,300.45,150225.00,160594.40,10369.40,723747),('1','136','255232','334',500.00,592.00,0.00,4625.31,2312655.00,2476875.52,164220.52,723832),('1','136','255471','334',500.00,592.00,0.00,369.19,184595.00,200336.48,15741.48,724441),('1','136','255534','334',500.00,592.00,0.00,4097.40,2048700.00,2200090.80,151390.80,724577),('1','136','255701','334',500.00,592.00,0.00,1108.22,554110.00,607119.16,53009.16,725023),('1','136','255867','334',500.00,592.00,0.00,2963.96,1481980.00,1607188.92,125208.92,725436),('1','136','255946','334',500.00,592.00,0.00,1471.94,735970.00,787952.48,51982.48,725635),('1','136','256077','334',500.00,592.00,0.00,3029.17,1514585.00,1621656.64,107071.64,725962),('1','136','256203','334',500.00,592.00,0.00,2669.96,1334980.00,1453708.32,118728.32,726276),('1','136','256473','334',500.00,592.00,0.00,3613.02,1806510.00,1955925.32,149415.32,726986),('1','136','256711','334',500.00,592.00,0.00,3827.12,1913560.00,2061099.10,147539.10,727594),('1','136','256965','334',500.00,592.00,0.00,3695.06,1847530.00,1990960.64,143430.64,728253),('1','136','257238','334',500.00,592.00,0.00,4606.16,2303080.00,2489158.72,186078.72,728962),('1','136','257488','334',500.00,592.00,0.00,2398.37,1199185.00,1297415.58,98230.58,729624),('1','136','257489','334',500.00,568.00,0.00,1221.38,610690.00,647156.64,36466.64,729625),('1','136','257490','334',500.00,568.00,0.00,3457.76,1728880.00,1850462.02,121582.02,729626),('1','136','257491','334',500.00,568.00,0.00,5415.04,2707520.00,2840233.30,132713.30,729627),('1','136','257492','334',500.00,568.00,0.00,3839.23,1919615.00,2030215.96,110600.96,729628),('1','136','257493','334',500.00,568.00,0.00,5537.97,2768985.00,2897792.96,128807.96,729629),('1','136','257494','334',500.00,568.00,0.00,3410.46,1705230.00,1817741.72,112511.72,729630),('1','136','257495','334',500.00,568.00,0.00,1861.39,930695.00,1009588.60,78893.60,729631),('1','136','257496','334',500.00,568.00,0.00,3800.45,1900225.00,1991577.50,91352.50,729632),('1','136','257497','334',500.00,568.00,0.00,1278.93,639465.00,680952.90,41487.90,729633),('1','136','257498','334',500.00,568.00,0.00,3170.35,1585175.00,1659716.80,74541.80,729634),('1','136','257499','334',500.00,568.00,0.00,2131.19,1065595.00,1123102.92,57507.92,729635),('1','136','257500','334',490.00,568.00,0.00,2629.55,1288479.50,1377356.40,88876.90,729636),('1','136','257501','334',490.00,568.00,0.00,6306.93,3090395.70,3275443.12,185047.42,729637),('1','136','257502','334',490.00,568.00,0.00,3616.29,1771982.10,1915584.72,143602.62,729638),('1','136','257503','334',490.00,568.00,0.00,4940.16,2420678.40,2570195.80,149517.40,729639),('1','136','257504','334',490.00,568.00,0.00,7095.51,3476799.90,3685760.64,208960.74,729640),('1','136','257505','334',500.00,568.00,0.00,1735.13,867565.00,910709.84,43144.84,729641),('1','136','257506','334',500.00,568.00,0.00,3241.51,1620755.00,1706792.18,86037.18,729642),('1','136','257507','334',500.00,568.00,0.00,2436.78,1218390.00,1257591.04,39201.04,729643),('1','136','257508','334',500.00,568.00,0.00,5442.38,2721190.00,2840025.60,118835.60,729644),('1','136','257509','334',500.00,568.00,0.00,7532.22,3766110.00,3892719.58,126609.58,729645),('1','136','257510','334',500.00,568.00,0.00,5073.20,2536600.00,2660431.60,123831.60,729646),('1','136','257511','334',500.00,568.00,0.00,3827.57,1913785.00,1977840.56,64055.56,729647),('1','136','257512','334',500.00,568.00,0.00,3166.76,1583380.00,1636700.68,53320.68,729648),('1','136','257513','334',500.00,568.00,0.00,2043.79,1021895.00,1072069.72,50174.72,729649),('1','136','257514','334',500.00,568.00,0.00,1178.57,589285.00,630184.76,40899.76,729650),('1','136','257515','334',500.00,568.00,0.00,3970.23,1985115.00,2104976.80,119861.80,729651),('1','136','257516','334',500.00,568.00,0.00,2780.16,1390080.00,1431326.88,41246.88,729652),('1','136','257517','334',500.00,568.00,0.00,2487.17,1243585.00,1332900.56,89315.56,729653),('1','136','257518','334',500.00,568.00,0.00,935.05,467525.00,482736.40,15211.40,729654),('1','136','257519','334',500.00,568.00,0.00,3571.86,1785930.00,1867908.48,81978.48,729655),('1','136','257520','334',490.00,568.00,0.00,4708.45,2307140.50,2406378.30,99237.80,729656),('1','136','257521','334',490.00,568.00,0.00,3920.10,1920849.00,2041637.88,120788.88,729657),('1','136','257522','334',490.00,568.00,0.00,4096.88,2007471.20,2154436.76,146965.56,729658),('1','136','257523','334',490.00,568.00,0.00,3516.81,1723236.90,1850641.62,127404.72,729659),('1','136','257524','334',490.00,568.00,0.00,3694.89,1810496.10,1942429.52,131933.42,729660),('1','136','257525','334',490.00,568.00,0.00,4573.43,2240980.70,2382138.24,141157.54,729661),('1','136','257526','334',490.00,568.00,0.00,1372.71,672627.90,730714.26,58086.36,729662),('1','136','257527','334',490.00,568.00,0.00,4550.59,2229789.10,2388016.04,158226.94,729663),('1','136','257528','334',490.00,568.00,0.00,8320.56,4077074.40,4318305.08,241230.68,729664),('1','136','257529','334',490.00,568.00,0.00,2862.73,1402737.70,1495560.32,92822.62,729665),('1','136','257530','334',490.00,568.00,0.00,5680.69,2783538.10,2970700.92,187162.82,729666),('1','136','257531','334',500.00,580.00,0.00,1809.00,904500.00,1012294.00,107794.00,729667),('1','136','257532','334',522.00,580.00,0.00,1699.50,887139.00,917890.00,30751.00,729668),('1','136','257533','334',522.00,580.00,0.00,4642.07,2423160.54,2543307.40,120146.86,729669),('1','136','257534','334',522.00,580.00,0.00,5250.72,2740875.84,2883937.60,143061.76,729670),('1','136','257535','334',522.00,580.00,0.00,4851.66,2532566.52,2658690.80,126124.28,729671),('1','136','257536','334',522.00,580.00,0.00,5987.26,3125349.72,3260215.20,134865.48,729672),('1','136','257537','334',522.00,580.00,0.00,2090.99,1091496.78,1147434.20,55937.42,729673),('1','136','257538','334',522.00,580.00,0.00,3789.83,1978291.26,2058419.40,80128.14,729674),('1','136','257539','334',522.00,580.00,0.00,0.00,0.00,0.00,0.00,729675),('1','136','257540','334',600.00,640.00,0.00,1294.82,828684.80,828684.80,0.00,729676),('1','136','257541','334',640.00,640.00,0.00,1194.32,764364.80,764364.80,0.00,729677),('1','136','257542','334',640.00,640.00,0.00,1147.93,734675.20,734675.20,0.00,729678),('1','136','257543','334',582.00,640.00,0.00,71.55,41642.10,45792.00,4149.90,729679),('1','136','257544','334',582.00,640.00,0.00,1387.94,807781.08,888281.60,80500.52,729680),('1','136','257545','334',582.00,640.00,0.00,1226.59,713875.38,785017.60,71142.22,729681),('1','136','257546','334',582.00,640.00,0.00,1807.76,1052116.32,1156966.40,104850.08,729682),('1','136','257547','334',592.00,640.00,0.00,593.28,351221.76,382990.40,31768.64,729683),('1','136','257548','334',592.00,680.00,0.00,2317.42,1381088.84,1515584.00,134495.16,729684),('1','136','257549','334',596.00,680.00,0.00,1598.60,952765.60,1056600.40,103834.80,729685),('1','136','257550','334',596.00,580.00,0.00,882.65,526059.40,477833.00,-48226.40,729686),('1','136','257551','334',596.00,680.00,0.00,1465.53,873455.88,968840.40,95384.52,729687),('1','136','257552','334',596.00,680.00,0.00,2584.79,1540534.84,1610843.68,70308.84,729688),('1','136','257553','334',596.00,680.00,0.00,3338.51,1989751.96,2106514.80,116762.84,729689),('1','136','257554','334',596.00,680.00,0.00,3553.25,2117737.00,2236642.64,118905.64,729690),('1','136','257555','334',596.00,680.00,0.00,2770.13,1650997.48,1760570.56,109573.08,729691),('1','136','257556','334',596.00,680.00,0.00,3902.34,2325794.64,2437083.36,111288.72,729692),('1','136','257557','334',596.00,680.00,0.00,3094.06,1844059.76,1939665.60,95605.84,729693),('1','136','257558','334',596.00,680.00,0.00,173.37,103328.52,105408.96,2080.44,729694),('1','136','257559','334',596.00,680.00,0.00,2523.24,1483665.12,1581645.60,97980.48,729695),('1','136','257560','334',588.00,680.00,0.00,2022.61,1189294.68,1293666.80,104372.12,729696),('1','136','257561','334',588.00,680.00,0.00,4155.40,2443375.20,2601074.48,157699.28,729697),('1','136','257562','334',588.00,680.00,0.00,4597.92,2703576.96,2936213.36,232636.40,729698),('1','136','257563','334',588.00,688.00,0.00,2980.46,1752510.48,1920964.48,168454.00,729699),('1','136','257564','334',588.00,688.00,0.00,3231.33,1900022.04,2062795.04,162773.00,729700),('1','136','257565','334',588.00,688.00,0.00,3765.40,2214055.20,2397603.96,183548.76,729701),('1','136','257566','334',588.00,664.00,0.00,1478.02,869075.76,928179.64,59103.88,729702),('1','136','257567','334',592.00,664.00,0.00,748.54,443135.68,481534.56,38398.88,729703),('1','136','257568','334',592.00,664.00,0.00,1767.34,1046265.28,1141875.92,95610.64,729704),('1','136','257569','334',592.00,664.00,0.00,4122.38,2440448.96,2602009.36,161560.40,729705),('1','136','257570','334',592.00,664.00,0.00,6572.08,3890671.36,4101808.32,211136.96,729706),('1','136','257571','334',592.00,664.00,0.00,6108.45,3616202.40,3783880.80,167678.40,729707),('1','136','257572','334',592.00,664.00,0.00,4521.21,2676556.32,2780940.62,104384.30,729708),('1','136','257573','334',592.00,664.00,0.00,744.70,440862.40,450879.80,10017.40,729709),('1','136','257574','334',617.00,664.00,0.00,3000.47,1814081.14,1828257.08,14175.94,729710),('1','136','257575','334',602.00,664.00,0.00,2128.31,1281242.62,1315877.05,34634.43,729711),('1','136','257576','334',602.00,664.00,0.00,990.44,596244.88,600992.69,4747.81,729712),('1','136','257577','334',602.00,664.00,0.00,2855.73,1719149.46,1780952.93,61803.47,729713),('1','136','257578','334',602.00,664.00,0.00,3202.69,1928019.38,1964984.41,36965.03,729714),('1','136','257579','334',592.00,664.00,0.00,776.73,459824.16,485183.18,25359.02,729715),('1','136','257580','334',592.00,664.00,0.00,1030.07,609801.44,683966.48,74165.04,729716),('1','136','257581','334',592.00,664.00,0.00,1283.23,759672.16,852064.72,92392.56,729717),('1','136','257582','334',592.00,664.00,0.00,1869.24,1106590.08,1241175.36,134585.28,729718),('1','136','257583','334',592.00,664.00,0.00,806.21,477276.32,535323.44,58047.12,729719),('1','136','257584','334',592.00,664.00,0.00,935.47,553798.24,621152.08,67353.84,729720),('1','136','257585','334',592.00,664.00,0.00,976.35,577999.20,648296.40,70297.20,729721),('1','136','257586','334',592.00,664.00,0.00,2497.71,1478644.32,1658479.44,179835.12,729722),('1','136','257587','334',592.00,664.00,0.00,0.00,0.00,0.00,0.00,729723),('1','136','257588','334',592.00,664.00,0.00,78.34,46377.28,52017.76,5640.48,729724),('1','136','257589','334',592.00,664.00,0.00,1981.53,1173065.76,1315735.92,142670.16,729725),('1','136','257590','334',592.00,664.00,0.00,327.66,193974.72,203671.74,9697.02,729726),('1','136','257591','334',592.00,664.00,0.00,2387.26,1413257.92,1503376.96,90119.04,729727),('1','136','257592','334',592.00,664.00,0.00,571.13,338108.96,351423.62,13314.66,729728),('1','136','257593','334',592.00,664.00,0.00,3584.63,2122100.96,2212529.26,90428.30,729729),('1','136','257594','334',592.00,664.00,0.00,1607.52,951651.84,990458.07,38806.23,729730),('1','136','257595','334',592.00,664.00,0.00,0.00,0.00,0.00,0.00,729731),('1','136','257596','334',582.00,664.00,0.00,2274.48,1323747.36,1397751.36,74004.00,729732),('1','136','257597','334',582.00,664.00,0.00,3369.65,1961136.30,2071246.24,110109.94,729733),('1','136','257598','334',582.00,664.00,0.00,4821.05,2805851.10,2936063.20,130212.10,729734),('1','136','257599','334',582.00,664.00,0.00,2730.27,1589017.14,1700450.34,111433.20,729735),('1','136','257600','334',582.00,664.00,0.00,3509.54,2042552.28,2169631.20,127078.92,729736),('1','136','257601','334',582.00,664.00,0.00,3783.02,2201717.64,2326775.94,125058.30,729737),('1','136','257602','334',582.00,664.00,0.00,3980.00,2316360.00,2408937.62,92577.62,729738),('1','136','257603','334',582.00,664.00,0.00,0.00,0.00,0.00,0.00,729739),('1','136','257604','334',582.00,664.00,0.00,771.35,448925.70,483257.84,34332.14,729740),('1','136','257605','334',582.00,664.00,0.00,2152.20,1252580.40,1337606.94,85026.54,729741),('1','136','257606','334',582.00,664.00,0.00,3707.93,2158015.26,2272889.36,114874.10,729742),('1','136','257607','334',582.00,664.00,0.00,6699.49,3899103.18,4059462.04,160358.86,729743),('1','136','257608','334',582.00,664.00,0.00,4091.16,2381055.12,2543299.88,162244.76,729744),('1','136','257609','334',582.00,664.00,0.00,6860.22,3992648.04,4213468.08,220820.04,729745),('1','136','257610','334',582.00,664.00,0.00,757.99,441150.18,468900.22,27750.04,729746),('1','136','257611','334',582.00,664.00,0.00,313.71,182579.22,187598.58,5019.36,729747),('1','136','257612','334',582.00,664.00,0.00,4795.07,2790730.74,2927824.42,137093.68,729748),('1','136','257613','334',582.00,664.00,0.00,4249.42,2473162.44,2589327.88,116165.44,729749),('1','136','257614','334',582.00,664.00,0.00,4779.98,2781948.36,2907548.46,125600.10,729750),('1','136','257615','334',582.00,664.00,0.00,5722.38,3330425.16,3498758.74,168333.58,729751),('1','136','257616','334',582.00,664.00,0.00,3386.22,1970780.04,2099725.68,128945.64,729752),('1','136','257617','334',582.00,664.00,0.00,1777.21,1034336.22,1087078.06,52741.84,729753),('1','136','257618','334',582.00,664.00,0.00,2468.37,1436591.34,1507195.68,70604.34,729754),('1','136','257619','334',582.00,664.00,0.00,2804.24,1632067.68,1716294.26,84226.58,729755),('1','136','257620','334',582.00,664.00,0.00,3250.71,1891913.22,1993538.44,101625.22,729756),('1','136','257621','334',582.00,664.00,0.00,570.70,332147.40,346829.20,14681.80,729757),('1','136','257622','334',582.00,664.00,0.00,897.01,525647.86,595614.64,69966.78,729758),('1','136','257623','334',586.00,664.00,0.00,1335.14,782392.04,886532.96,104140.92,729759),('1','136','257624','334',586.00,664.00,0.00,505.60,296281.60,304038.40,7756.80,729760),('1','136','257625','334',586.00,664.00,0.00,0.00,0.00,0.00,0.00,729761),('1','136','257626','334',586.00,664.00,0.00,480.37,279575.34,318965.68,39390.34,729762),('1','136','257627','334',582.00,664.00,0.00,924.08,537814.56,613589.12,75774.56,729763),('1','136','257628','334',582.00,664.00,0.00,470.09,273592.38,285805.76,12213.38,729764),('1','136','257629','334',582.00,664.00,0.00,0.00,0.00,0.00,0.00,729765),('1','136','257630','334',582.00,664.00,0.00,1380.26,803311.32,916492.64,113181.32,729766),('1','136','257631','334',582.00,664.00,0.00,1910.43,1111870.26,1268525.52,156655.26,729767),('1','136','257632','334',582.00,680.00,0.00,1445.36,841199.52,982844.80,141645.28,729768),('1','136','257633','334',582.00,680.00,0.00,332.16,193317.12,203400.80,10083.68,729769),('1','136','257634','334',582.00,680.00,0.00,0.00,0.00,0.00,0.00,729770),('1','136','257635','334',582.00,680.00,0.00,568.91,333257.42,386858.80,53601.38,729771),('1','136','257636','334',592.00,680.00,0.00,1335.33,790515.36,908024.40,117509.04,729772),('1','136','257637','334',592.00,680.00,0.00,342.84,202961.28,218593.20,15631.92,729773),('1','136','257638','334',592.00,680.00,0.00,0.00,0.00,0.00,0.00,729774),('1','136','257639','334',592.00,680.00,0.00,1198.72,709642.24,815129.60,105487.36,729775),('1','136','257640','334',592.00,680.00,0.00,1666.35,986479.20,1133118.00,146638.80,729776),('1','136','257641','334',592.00,680.00,0.00,625.99,370586.08,406053.20,35467.12,729777),('1','136','257642','334',592.00,680.00,0.00,0.00,0.00,0.00,0.00,729778),('1','136','257643','334',592.00,680.00,0.00,289.09,171141.28,196581.20,25439.92,729779),('1','136','257644','334',592.00,680.00,0.00,2151.81,1273871.52,1463230.80,189359.28,729780),('1','136','257645','334',592.00,680.00,0.00,511.70,302926.40,317254.00,14327.60,729781),('1','136','257646','334',592.00,680.00,0.00,0.00,0.00,0.00,0.00,729782),('1','136','257647','334',592.00,680.00,0.00,1921.56,1137563.52,1306660.80,169097.28,729783),('1','136','257648','334',592.00,680.00,0.00,1273.70,754030.40,866116.00,112085.60,729784),('1','136','257649','334',592.00,680.00,0.00,1444.71,855268.32,982402.80,127134.48,729785),('1','136','257650','334',592.00,680.00,0.00,254.63,150740.96,161088.40,10347.44,729786),('1','136','257651','334',592.00,680.00,0.00,0.00,0.00,0.00,0.00,729787),('1','136','257652','334',662.00,720.00,0.00,1883.12,1246625.44,1327880.06,81254.62,729788),('1','136','257653','334',662.00,720.00,0.00,1958.36,1296434.32,1376093.49,79659.17,729789),('1','136','257654','334',662.00,720.00,0.00,3064.74,2028857.88,2115450.60,86592.72,729790),('1','136','257655','334',662.00,720.00,0.00,3589.05,2375951.10,2485577.30,109626.20,729791),('1','136','257656','334',662.00,720.00,0.00,4663.38,3087157.56,3216970.83,129813.27,729792),('1','136','257657','334',662.00,720.00,0.00,6424.18,4252807.16,4397876.39,145069.23,729793),('1','136','257658','334',662.00,760.00,0.00,2907.16,1924539.92,2085808.96,161269.04,729794),('1','136','257659','334',662.00,760.00,0.00,0.00,0.00,0.00,0.00,729795),('1','136','257660','334',652.00,760.00,0.00,1893.41,1234503.32,1363683.60,129180.28,729796),('1','136','257661','334',652.00,760.00,0.00,1994.70,1300544.40,1418274.60,117730.20,729797),('1','136','257662','334',652.00,760.00,0.00,0.00,0.00,0.00,0.00,729798),('1','136','257663','334',652.00,760.00,0.00,1590.22,1036823.44,1139587.20,102763.76,729799),('1','136','257664','334',652.00,760.00,0.00,1087.25,708887.00,766540.20,57653.20,729800),('1','136','257665','334',652.00,760.00,0.00,0.00,0.00,0.00,0.00,729801),('1','136','257666','334',652.00,760.00,0.00,3864.60,2519719.20,2745449.80,225730.60,729802),('1','136','257667','334',652.00,760.00,0.00,0.00,0.00,0.00,0.00,729803),('1','136','257668','334',652.00,760.00,0.00,4381.03,2856431.56,3146570.40,290138.84,729804),('1','136','257669','334',652.00,760.00,0.00,1013.30,660671.60,716357.00,55685.40,729805),('1','136','257670','334',652.00,760.00,0.00,0.00,0.00,0.00,0.00,729806),('1','136','257671','334',672.00,760.00,0.00,7505.90,5043964.80,5335408.32,291443.52,729807),('1','136','257672','334',672.00,760.00,0.00,5349.91,3595139.52,3822383.44,227243.92,729808),('1','136','257673','334',672.00,760.00,0.00,3239.57,2176991.04,2392697.20,215706.16,729809),('1','136','257674','334',672.00,760.00,0.00,1511.40,1015660.80,1148664.00,133003.20,729810),('1','136','257675','334',672.00,760.00,0.00,1662.79,1117394.88,1263720.40,146325.52,729811),('1','136','257676','334',672.00,760.00,0.00,1748.19,1174783.68,1328624.40,153840.72,729812),('1','136','257677','334',672.00,760.00,0.00,3615.38,2429535.36,2747688.80,318153.44,729813),('1','136','257678','334',672.00,760.00,0.00,0.00,0.00,0.00,0.00,729814),('1','136','257679','334',672.00,760.00,0.00,2919.27,1961749.44,2218645.20,256895.76,729815),('1','136','257680','334',672.00,760.00,0.00,2934.35,1971883.20,2230106.00,258222.80,729816),('1','136','257681','334',672.00,760.00,0.00,0.00,0.00,0.00,0.00,729817),('1','136','257682','334',672.00,760.00,0.00,3413.61,2293945.92,2594343.60,300397.68,729818),('1','136','257683','334',672.00,760.00,0.00,1796.72,1207395.84,1365507.20,158111.36,729819),('1','136','257684','334',672.00,760.00,0.00,0.00,0.00,0.00,0.00,729820),('1','136','257685','334',672.00,760.00,0.00,890.40,598348.80,676704.00,78355.20,729821),('1','136','257686','334',672.00,760.00,0.00,2411.98,1620850.56,1833104.80,212254.24,729822),('1','136','257687','334',672.00,760.00,0.00,1961.64,1318222.08,1490846.40,172624.32,729823),('1','136','257688','334',672.00,760.00,0.00,0.00,0.00,0.00,0.00,729824),('1','136','257689','334',672.00,760.00,0.00,689.40,463276.80,523944.00,60667.20,729825),('1','136','257690','334',672.00,760.00,0.00,2063.69,1386799.68,1568404.40,181604.72,729826),('1','136','257691','334',672.00,760.00,0.00,1840.84,1237044.48,1399038.40,161993.92,729827),('1','136','257692','334',672.00,760.00,0.00,0.00,0.00,0.00,0.00,729828),('1','136','257693','334',672.00,760.00,0.00,489.59,329004.48,372088.40,43083.92,729829),('1','136','257694','334',672.00,760.00,0.00,2743.38,1843551.36,2084968.80,241417.44,729830),('1','136','257695','334',672.00,760.00,0.00,1075.46,722709.12,817349.60,94640.48,729831),('1','136','257696','334',672.00,760.00,0.00,912.67,613314.24,693629.20,80314.96,729832),('1','136','257697','334',672.00,760.00,0.00,0.00,0.00,0.00,0.00,729833),('1','136','257698','334',672.00,760.00,0.00,1286.44,864487.68,977694.40,113206.72,729834),('1','136','257699','334',672.00,760.00,0.00,2048.05,1376289.60,1556518.00,180228.40,729835),('1','136','257700','334',672.00,760.00,0.00,1497.49,1006313.28,1138092.40,131779.12,729836),('1','136','257701','334',682.00,760.00,0.00,1075.12,733231.84,795460.00,62228.16,729837),('1','136','257702','334',682.00,760.00,0.00,0.00,0.00,0.00,0.00,729838),('1','136','257703','334',682.00,760.00,0.00,985.24,671933.68,737548.40,65614.72,729839),('1','136','257704','334',682.00,760.00,0.00,2941.69,2006232.58,2175728.00,169495.42,729840),('1','136','257705','334',682.00,760.00,0.00,3968.36,2706421.52,2905813.36,199391.84,729841),('1','136','257706','334',682.00,760.00,0.00,2302.09,1570025.38,1697979.20,127953.82,729842),('1','136','257707','334',682.00,760.00,0.00,2979.77,2032203.14,2185173.40,152970.26,729843),('1','136','257708','334',682.00,760.00,0.00,2574.80,1756013.60,1903708.00,147694.40,729844),('1','136','257709','334',682.00,760.00,0.00,2971.55,2026597.10,2183085.60,156488.50,729845),('1','136','257710','334',682.00,760.00,0.00,3083.69,2103076.58,2262191.44,159114.86,729846),('1','136','257711','334',682.00,760.00,0.00,2557.28,1744064.96,1875927.04,131862.08,729847),('1','136','257712','334',682.00,760.00,0.00,0.00,0.00,0.00,0.00,729848),('1','136','257713','334',682.00,760.00,0.00,0.00,0.00,0.00,0.00,729849),('1','136','257714','334',682.00,760.00,0.00,1699.11,1158793.02,1225385.16,66592.14,729850),('1','136','257715','334',682.00,760.00,0.00,4352.88,2968664.16,3189169.64,220505.48,729851),('1','136','257716','334',682.00,760.00,0.00,2309.27,1574922.14,1712839.60,137917.46,729852),('1','136','257717','334',682.00,760.00,0.00,3858.21,2631299.22,2819267.60,187968.38,729853),('1','136','257718','334',682.00,760.00,0.00,2407.23,1641730.86,1794393.20,152662.34,729854),('1','136','257719','334',682.00,760.00,0.00,3225.25,2199620.50,2368665.56,169045.06,729855),('1','136','257720','334',682.00,760.00,0.00,3155.24,2151873.68,2325088.24,173214.56,729856),('1','136','257721','334',682.00,760.00,0.00,2709.19,1847667.58,1987644.40,139976.82,729857),('1','136','257722','334',682.00,760.00,0.00,873.20,595522.40,628125.52,32603.12,729858),('1','136','257723','334',682.00,760.00,0.00,0.00,0.00,0.00,0.00,729859),('1','136','257724','334',682.00,760.00,0.00,2702.48,1843091.36,1973115.28,130023.92,729860),('1','136','257725','334',682.00,760.00,0.00,1487.19,1014263.58,1130264.40,116000.82,729861),('1','136','257726','334',682.00,760.00,0.00,825.14,562745.48,595691.60,32946.12,729862),('1','136','257727','334',682.00,760.00,0.00,0.00,0.00,0.00,0.00,729863),('1','136','257728','334',682.00,760.00,0.00,988.03,673836.46,750902.80,77066.34,729864),('1','136','257729','334',682.00,760.00,0.00,1538.93,1049550.26,1169586.80,120036.54,729865),('1','136','257730','334',682.00,760.00,0.00,1421.45,969428.90,1080302.00,110873.10,729866),('1','136','257731','334',682.00,760.00,0.00,1997.18,1362076.76,1517856.80,155780.04,729867),('1','136','257732','334',682.00,760.00,0.00,1557.00,1061874.00,1183320.00,121446.00,729868),('1','136','257733','334',682.00,760.00,0.00,495.00,337590.00,356400.00,18810.00,729869),('1','136','257734','334',682.00,760.00,0.00,0.00,0.00,0.00,0.00,729870),('1','136','257735','334',682.00,760.00,0.00,1306.75,891203.50,979454.80,88251.30,729871),('1','136','257736','334',682.00,760.00,0.00,2475.81,1688502.42,1799997.68,111495.26,729872),('1','136','257737','334',682.00,760.00,0.00,1381.55,942217.10,1003285.84,61068.74,729873),('1','136','257738','334',682.00,760.00,0.00,0.00,0.00,0.00,0.00,729874),('1','136','257739','334',682.00,760.00,0.00,904.56,616909.92,670561.40,53651.48,729875),('1','136','257740','334',682.00,760.00,0.00,3132.15,2136126.30,2266375.04,130248.74,729876),('1','136','257741','334',682.00,760.00,0.00,2025.42,1381336.44,1495200.00,113863.56,729877),('1','136','257742','334',682.00,744.00,0.00,3588.49,2447350.18,2546048.56,98698.38,729878),('1','136','257743','334',682.00,744.00,0.00,3524.73,2403865.86,2514017.49,110151.63,729879),('1','136','257744','334',682.00,744.00,0.00,2391.27,1630846.14,1719006.38,88160.24,729880),('1','136','257745','334',682.00,744.00,0.00,4181.96,2852096.72,2955594.15,103497.43,729881),('1','136','257746','334',682.00,744.00,0.00,4017.31,2739805.42,2856503.44,116698.02,729882),('1','136','257747','334',682.00,744.00,0.00,827.70,564491.40,576895.87,12404.47,729883),('1','136','257748','334',682.00,744.00,0.00,0.00,0.00,0.00,0.00,729884),('1','136','257749','334',682.00,744.00,0.00,4185.97,2854831.54,2935159.04,80327.50,729885),('1','136','257750','334',682.00,744.00,0.00,2687.62,1832956.84,1908876.17,75919.33,729886),('1','136','257751','334',682.00,744.00,0.00,4892.80,3336889.60,3473088.53,136198.93,729887),('1','136','257752','334',682.00,744.00,0.00,6763.65,4612809.30,4777253.10,164443.80,729888),('1','136','257753','334',682.00,744.00,0.00,3145.60,2145299.20,2249676.40,104377.20,729889),('1','136','257754','334',682.00,744.00,0.00,2970.81,2026092.42,2106618.64,80526.22,729890),('1','136','257755','334',682.00,744.00,0.00,0.00,0.00,0.00,0.00,729891),('1','136','257756','334',665.00,744.00,0.00,898.30,597369.50,668335.20,70965.70,729892),('1','136','257757','334',665.00,744.00,0.00,1709.58,1136870.70,1271927.52,135056.82,729893),('1','136','257758','334',665.00,744.00,0.00,1482.48,985849.20,1092430.12,106580.92,729894),('1','136','257759','334',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729895),('1','136','257760','334',665.00,744.00,0.00,1460.52,971245.80,1045628.58,74382.78,729896),('1','136','257761','334',665.00,744.00,0.00,6059.66,4029673.90,4286271.04,256597.14,729897),('1','136','257762','334',665.00,744.00,0.00,6329.36,4209024.40,4483300.84,274276.44,729898),('1','136','257763','334',665.00,744.00,0.00,7762.45,5162029.25,5481779.80,319750.55,729899),('1','136','257764','334',665.00,760.00,0.00,1662.09,1105289.85,1263188.40,157898.55,729900),('1','136','257765','334',665.00,760.00,0.00,886.82,589735.30,642913.20,53177.90,729901),('1','136','257766','334',665.00,760.00,0.00,0.00,0.00,0.00,0.00,729902),('1','136','257767','334',665.00,760.00,0.00,1100.10,731566.50,836076.00,104509.50,729903),('1','136','257768','334',665.00,760.00,0.00,1994.52,1326355.80,1515835.20,189479.40,729904),('1','136','257769','334',665.00,760.00,0.00,1551.60,1031814.00,1179216.00,147402.00,729905),('1','136','257770','334',665.00,760.00,0.00,1022.77,680142.05,747055.20,66913.15,729906),('1','136','257771','334',665.00,760.00,0.00,0.00,0.00,0.00,0.00,729907),('1','136','257772','334',665.00,760.00,0.00,978.64,650795.60,743766.40,92970.80,729908),('1','136','257773','334',665.00,760.00,0.00,2277.81,1514743.65,1731135.60,216391.95,729909),('1','136','257774','334',665.00,760.00,0.00,2443.24,1624754.60,1856862.40,232107.80,729910),('1','136','257775','334',665.00,760.00,0.00,556.87,370318.55,404046.20,33727.65,729911),('1','136','257776','334',665.00,760.00,0.00,0.00,0.00,0.00,0.00,729912),('1','136','257777','334',665.00,760.00,0.00,1473.78,980063.70,1120072.80,140009.10,729913),('1','136','257778','334',655.00,744.00,0.00,2978.45,1950884.75,2154095.44,203210.69,729914),('1','136','257779','334',655.00,744.00,0.00,1040.39,681455.45,740666.88,59211.43,729915),('1','136','257780','334',655.00,744.00,0.00,0.00,0.00,0.00,0.00,729916),('1','136','257781','334',655.00,744.00,0.00,2057.66,1347767.30,1486685.04,138917.74,729917),('1','136','257782','334',655.00,744.00,0.00,2773.05,1816347.75,2010195.70,193847.95,729918),('1','136','257783','334',655.00,744.00,0.00,2278.28,1492273.40,1651232.70,158959.30,729919),('1','136','257784','334',655.00,744.00,0.00,3363.21,2202902.55,2437742.96,234840.41,729920),('1','136','257785','334',655.00,744.00,0.00,2966.44,1943018.20,2148047.14,205028.94,729921),('1','136','257786','334',655.00,744.00,0.00,2004.20,1312751.00,1477150.80,164399.80,729922),('1','136','257787','334',655.00,744.00,0.00,3461.14,2267046.70,2500059.16,233012.46,729923),('1','136','257788','334',655.00,744.00,0.00,1835.31,1202128.05,1348861.64,146733.59,729924),('1','136','257789','334',655.00,744.00,0.00,2524.55,1653580.25,1840512.20,186931.95,729925),('1','136','257790','334',655.00,744.00,0.00,889.48,582609.40,650634.72,68025.32,729926),('1','136','257791','334',655.00,744.00,0.00,299.76,196342.80,213679.60,17336.80,729927),('1','136','257792','334',655.00,744.00,0.00,0.00,0.00,0.00,0.00,729928),('1','136','257793','334',655.00,744.00,0.00,2178.18,1426707.90,1586715.22,160007.32,729929),('1','136','257794','334',655.00,744.00,0.00,2915.04,1909351.20,2099371.80,190020.60,729930),('1','136','257795','334',655.00,744.00,0.00,0.00,0.00,0.00,0.00,729931),('1','136','257796','334',655.00,744.00,0.00,223.97,146700.35,166633.68,19933.33,729932),('1','136','257797','334',655.00,744.00,0.00,2500.85,1638056.75,1811755.26,173698.51,729933),('1','136','257798','334',655.00,744.00,0.00,3091.84,2025155.20,2227640.18,202484.98,729934),('1','136','257799','334',655.00,744.00,0.00,915.65,599750.75,667102.32,67351.57,729935),('1','136','257800','334',655.00,744.00,0.00,0.00,0.00,0.00,0.00,729936),('1','136','257801','334',655.00,744.00,0.00,614.65,402595.75,457299.60,54703.85,729937),('1','136','257802','334',655.00,744.00,0.00,3070.03,2010869.65,2236512.32,225642.67,729938),('1','136','257803','334',655.00,744.00,0.00,1689.12,1106373.60,1242938.00,136564.40,729939),('1','136','257804','334',655.00,744.00,0.00,4171.94,2732620.70,3019823.94,287203.24,729940),('1','136','257805','334',655.00,744.00,0.00,3967.15,2598483.25,2861661.12,263177.87,729941),('1','136','257806','334',655.00,744.00,0.00,1949.34,1276817.70,1426990.74,150173.04,729942),('1','136','257807','334',665.00,744.00,0.00,2651.79,1763440.35,1910390.72,146950.37,729943),('1','136','257808','334',665.00,744.00,0.00,1990.35,1323582.75,1450213.56,126630.81,729944),('1','136','257809','334',665.00,744.00,0.00,1750.30,1163949.50,1277700.24,113750.74,729945),('1','136','257810','334',665.00,744.00,0.00,2236.56,1487312.40,1664000.64,176688.24,729946),('1','136','257811','334',665.00,744.00,0.00,244.54,162619.10,181937.76,19318.66,729947),('1','136','257812','334',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729948),('1','136','257813','334',665.00,744.00,0.00,3140.24,2088259.60,2286418.56,198158.96,729949),('1','136','257814','334',665.00,744.00,0.00,1719.60,1143534.00,1279382.40,135848.40,729950),('1','136','257815','334',665.00,744.00,0.00,172.21,114519.65,128124.24,13604.59,729951),('1','136','257816','334',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729952),('1','136','257817','334',665.00,744.00,0.00,2842.92,1890541.80,2068332.48,177790.68,729953),('1','136','257818','334',665.00,744.00,0.00,1951.09,1297474.85,1451610.96,154136.11,729954),('1','136','257819','334',665.00,744.00,0.00,304.64,202585.60,218794.64,16209.04,729955),('1','136','257820','334',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729956),('1','136','257821','334',665.00,736.00,0.00,2377.20,1580838.00,1749619.20,168781.20,729957),('1','136','257822','334',665.00,736.00,0.00,1736.51,1154779.15,1278071.36,123292.21,729958),('1','136','257823','334',665.00,736.00,0.00,151.06,100454.90,105742.00,5287.10,729959),('1','136','257824','334',665.00,736.00,0.00,0.00,0.00,0.00,0.00,729960),('1','136','257825','334',665.00,736.00,0.00,1669.02,1109898.30,1228398.72,118500.42,729961),('1','136','257826','334',665.00,736.00,0.00,1376.93,915658.45,1013420.48,97762.03,729962),('1','136','257827','334',665.00,736.00,0.00,564.17,375173.05,401287.76,26114.71,729963),('1','136','257828','334',665.00,736.00,0.00,0.00,0.00,0.00,0.00,729964),('1','136','257829','334',660.00,736.00,0.00,1123.04,741206.40,826557.44,85351.04,729965),('1','136','257830','334',660.00,736.00,0.00,2086.69,1377215.40,1535803.84,158588.44,729966),('1','136','257831','334',660.00,736.00,0.00,1347.12,889099.20,991480.32,102381.12,729967),('1','136','257832','334',660.00,736.00,0.00,386.22,254905.20,272132.40,17227.20,729968),('1','136','257833','334',660.00,736.00,0.00,0.00,0.00,0.00,0.00,729969),('1','136','257834','334',660.00,736.00,0.00,1736.28,1145944.80,1277902.08,131957.28,729970),('1','136','257835','334',660.00,736.00,0.00,3306.01,2181966.60,2378108.96,196142.36,729971),('1','136','257836','334',660.00,736.00,0.00,1810.58,1194982.80,1332586.88,137604.08,729972),('1','136','257837','334',660.00,736.00,0.00,1753.50,1157310.00,1278273.36,120963.36,729973),('1','136','257838','334',660.00,736.00,0.00,2377.03,1568839.80,1733633.56,164793.76,729974),('1','136','257839','334',660.00,736.00,0.00,3361.53,2218609.80,2407073.56,188463.76,729975),('1','136','257840','334',660.00,736.00,0.00,2042.39,1347977.40,1490650.52,142673.12,729976),('1','136','257841','334',660.00,736.00,0.00,3537.92,2335027.20,2566409.12,231381.92,729977),('1','136','257842','334',660.00,736.00,0.00,3812.28,2516104.80,2747269.56,231164.76,729978),('1','136','257843','334',660.00,736.00,0.00,304.01,200646.60,217271.36,16624.76,729979),('1','136','257844','334',660.00,736.00,0.00,1954.15,1289739.00,1438254.40,148515.40,729980),('1','136','257845','334',660.00,736.00,0.00,1329.60,877536.00,978585.60,101049.60,729981),('1','136','257846','334',660.00,736.00,0.00,1106.86,730527.60,814648.96,84121.36,729982),('1','136','257847','334',660.00,736.00,0.00,263.42,173857.20,189269.12,15411.92,729983),('1','136','257848','334',660.00,736.00,0.00,0.00,0.00,0.00,0.00,729984),('1','136','257849','334',660.00,736.00,0.00,2087.96,1378053.60,1536738.56,158684.96,729985),('1','136','257850','334',660.00,736.00,0.00,901.90,595254.00,663798.40,68544.40,729986),('1','136','257851','334',660.00,736.00,0.00,0.00,0.00,0.00,0.00,729987),('1','136','257852','334',660.00,736.00,0.00,2080.29,1372991.40,1531093.44,158102.04,729988),('1','136','257853','334',660.00,736.00,0.00,741.20,489192.00,545523.20,56331.20,729989),('1','136','257854','334',660.00,736.00,0.00,0.00,0.00,0.00,0.00,729990),('1','136','257855','334',660.00,736.00,0.00,1887.14,1245512.40,1388935.04,143422.64,729991),('1','136','257856','334',660.00,764.00,0.00,506.81,334494.60,387202.84,52708.24,729992),('1','136','257857','334',660.00,764.00,0.00,57.00,37620.00,43548.00,5928.00,729993),('1','136','257858','334',660.00,764.00,0.00,0.00,0.00,0.00,0.00,729994),('1','136','257859','334',660.00,764.00,0.00,3434.36,2266677.60,2623851.04,357173.44,729995),('1','136','257860','334',660.00,764.00,0.00,722.10,476586.00,551684.40,75098.40,729996),('1','136','257861','334',660.00,764.00,0.00,0.00,0.00,0.00,0.00,729997),('1','136','257862','334',660.00,764.00,0.00,774.63,511255.80,591817.32,80561.52,729998),('1','136','257863','334',660.00,748.00,0.00,2731.00,1802460.00,2042788.00,240328.00,729999),('1','136','257864','334',660.00,748.00,0.00,2000.96,1320633.60,1496718.08,176084.48,730000),('1','136','257865','334',660.00,748.00,0.00,0.00,0.00,0.00,0.00,730001),('1','136','257866','334',660.00,748.00,0.00,1917.11,1265292.60,1433998.28,168705.68,730002),('1','136','257867','334',660.00,748.00,0.00,2274.07,1500886.20,1701004.36,200118.16,730003),('1','136','257868','334',660.00,748.00,0.00,1148.80,758208.00,859302.40,101094.40,730004),('1','136','257869','334',660.00,748.00,0.00,0.00,0.00,0.00,0.00,730005),('1','136','257870','334',660.00,748.00,0.00,4611.44,3043550.40,3449357.12,405806.72,730006),('1','136','257871','334',660.00,748.00,0.00,320.59,211589.40,239801.32,28211.92,730007),('1','136','257872','334',660.00,748.00,0.00,0.00,0.00,0.00,0.00,730008),('1','136','257873','334',660.00,748.00,0.00,2005.17,1323412.20,1499867.16,176454.96,730009),('1','136','257874','334',660.00,748.00,0.00,1406.66,928395.60,1052181.68,123786.08,730010),('1','136','257875','334',660.00,748.00,0.00,1332.72,879595.20,996874.56,117279.36,730011),('1','136','257876','334',660.00,748.00,0.00,0.00,0.00,0.00,0.00,730012),('1','136','257877','334',660.00,748.00,0.00,426.44,281450.40,318977.12,37526.72,730013),('1','136','257878','334',660.00,760.00,0.00,2630.65,1736229.00,1999294.00,263065.00,730014),('1','136','257879','334',660.00,760.00,0.00,2989.19,1972865.40,2271784.40,298919.00,730015),('1','136','257880','334',660.00,760.00,0.00,1264.83,834787.80,961270.80,126483.00,730016),('1','136','257881','334',660.00,760.00,0.00,0.00,0.00,0.00,0.00,730017),('1','136','257882','334',660.00,760.00,0.00,1325.97,875140.20,1007737.20,132597.00,730018),('1','136','257883','334',660.00,760.00,0.00,2176.12,1436239.20,1653851.20,217612.00,730019),('1','136','257884','334',660.00,760.00,0.00,415.25,274065.00,315590.00,41525.00,730020),('1','136','257885','334',660.00,760.00,0.00,0.00,0.00,0.00,0.00,730021),('1','136','257886','334',660.00,760.00,0.00,2374.16,1566945.60,1804361.60,237416.00,730022),('1','136','257887','334',660.00,760.00,0.00,1823.84,1203734.40,1386118.40,182384.00,730023),('1','136','257888','334',660.00,760.00,0.00,1071.69,707315.40,814484.40,107169.00,730024),('1','136','257889','334',660.00,760.00,0.00,0.00,0.00,0.00,0.00,730025),('1','136','257890','334',660.00,760.00,0.00,749.62,494749.20,569711.20,74962.00,730026),('1','136','257891','334',660.00,800.00,0.00,1899.45,1253637.00,1519560.00,265923.00,730027),('1','136','257892','334',660.00,800.00,0.00,1947.86,1285587.60,1558288.00,272700.40,730028),('1','136','257893','334',660.00,800.00,0.00,1423.69,939635.40,1138952.00,199316.60,730029),('1','136','257894','334',660.00,800.00,0.00,0.00,0.00,0.00,0.00,730030),('1','136','257895','334',660.00,800.00,0.00,345.78,228214.80,276624.00,48409.20,730031),('1','136','257896','334',660.00,760.00,0.00,2267.23,1496371.80,1723094.80,226723.00,730032),('1','136','257897','334',660.00,760.00,0.00,1759.26,1161111.60,1337037.60,175926.00,730033),('1','136','257898','334',660.00,760.00,0.00,320.73,211681.80,243754.80,32073.00,730034),('1','136','257899','334',660.00,760.00,0.00,0.00,0.00,0.00,0.00,730035),('1','136','257900','334',660.00,760.00,0.00,961.14,634352.40,730466.40,96114.00,730036),('1','136','257901','334',660.00,760.00,0.00,1328.94,877100.40,1009994.40,132894.00,730037),('1','136','257902','334',660.00,760.00,0.00,1484.66,979875.60,1128341.60,148466.00,730038),('1','136','257903','334',660.00,760.00,0.00,374.85,247401.00,284886.00,37485.00,730039),('1','136','257904','334',660.00,760.00,0.00,0.00,0.00,0.00,0.00,730040),('1','136','257905','334',660.00,760.00,0.00,2011.87,1327834.20,1529021.20,201187.00,730041),('1','136','257906','334',660.00,760.00,0.00,1510.90,997194.00,1148284.00,151090.00,730042),('1','136','257907','334',660.00,760.00,0.00,1085.04,716126.40,824630.40,108504.00,730043),('1','136','257908','334',660.00,760.00,0.00,396.01,261366.60,300967.60,39601.00,730044),('1','136','257909','334',660.00,760.00,0.00,0.00,0.00,0.00,0.00,730045),('1','136','257910','334',660.00,760.00,0.00,1732.60,1143516.00,1316776.00,173260.00,730046),('1','136','257911','334',660.00,760.00,0.00,1382.50,912450.00,1050700.00,138250.00,730047),('1','136','257912','334',660.00,760.00,0.00,1252.83,826867.80,952150.80,125283.00,730048),('1','136','257913','334',660.00,760.00,0.00,1862.02,1228933.20,1415135.20,186202.00,730049),('1','136','257914','334',660.00,760.00,0.00,0.00,0.00,0.00,0.00,730050),('1','136','257915','334',660.00,760.00,0.00,0.00,0.00,0.00,0.00,730051),('1','136','257916','334',685.00,760.00,0.00,501.14,343280.90,380866.40,37585.50,730052),('1','136','257917','334',685.00,760.00,0.00,2086.03,1428930.55,1585382.80,156452.25,730053),('1','136','257918','334',685.00,760.00,0.00,1405.62,962849.70,1068271.20,105421.50,730054),('1','136','257919','334',685.00,760.00,0.00,1255.73,860175.05,953342.30,93167.25,730055),('1','136','257920','334',685.00,760.00,0.00,804.80,551288.00,590138.00,38850.00,730056),('1','136','257921','334',685.00,760.00,0.00,0.00,0.00,0.00,0.00,730057),('1','136','257922','334',685.00,760.00,0.00,1222.28,825039.00,920176.25,95137.25,730058),('1','136','257923','334',675.00,760.00,0.00,2138.40,1443420.00,1601943.30,158523.30,730059),('1','136','257924','334',675.00,760.00,0.00,1370.72,925236.00,1041747.20,116511.20,730060),('1','136','257925','334',675.00,760.00,0.00,2826.29,1907745.75,2105050.40,197304.65,730061),('1','136','257926','334',675.00,760.00,0.00,2945.88,1988469.00,2189413.80,200944.80,730062),('1','136','257927','334',675.00,760.00,0.00,1886.03,1273070.25,1424158.70,151088.45,730063),('1','136','257928','334',675.00,760.00,0.00,1511.00,1019925.00,1137335.00,117410.00,730064),('1','136','257929','334',675.00,760.00,0.00,1818.28,1227339.00,1366142.80,138803.80,730065),('1','136','257930','334',675.00,760.00,0.00,1315.40,887895.00,999704.00,111809.00,730066),('1','136','257931','334',675.00,760.00,0.00,1732.47,1169417.25,1301152.20,131734.95,730067),('1','136','257932','334',675.00,760.00,0.00,3230.87,2180837.25,2392857.20,212019.95,730068),('1','136','257933','334',675.00,760.00,0.00,2319.11,1565399.25,1698843.60,133444.35,730069),('1','136','257934','334',675.00,760.00,0.00,0.00,0.00,0.00,0.00,730070),('1','136','257935','334',675.00,760.00,0.00,1216.08,820854.00,892710.80,71856.80,730071),('1','136','257936','334',675.00,760.00,0.00,2089.88,1410669.00,1553258.80,142589.80,730072),('1','136','257937','334',675.00,760.00,0.00,2540.75,1715006.25,1872070.00,157063.75,730073),('1','136','257938','334',675.00,760.00,0.00,2007.23,1354880.25,1499394.80,144514.55,730074),('1','136','257939','334',675.00,760.00,0.00,2727.79,1841258.25,1992530.40,151272.15,730075),('1','136','257940','334',675.00,760.00,0.00,2258.89,1524750.75,1663611.40,138860.65,730076),('1','136','257941','334',675.00,760.00,0.00,4172.92,2816721.00,3016494.20,199773.20,730077),('1','136','257942','334',675.00,760.00,0.00,3011.02,2032438.50,2196620.20,164181.70,730078),('1','136','257943','334',675.00,760.00,0.00,3322.20,2242485.00,2407992.00,165507.00,730079),('1','136','257944','334',675.00,760.00,0.00,1226.24,827712.00,884813.40,57101.40,730080),('1','136','257945','334',675.00,760.00,0.00,0.00,0.00,0.00,0.00,730081),('1','136','257946','334',665.00,760.00,0.00,1015.24,675134.60,739362.40,64227.80,730082),('1','136','257947','334',665.00,760.00,0.00,2592.25,1723846.25,1890070.00,166223.75,730083),('1','136','257948','334',665.00,760.00,0.00,1473.30,979744.50,1082043.00,102298.50,730084),('1','136','257949','334',665.00,760.00,0.00,529.70,352250.50,380972.00,28721.50,730085),('1','136','257950','334',665.00,760.00,0.00,0.00,0.00,0.00,0.00,730086),('1','136','257951','334',665.00,736.00,0.00,2725.20,1812258.00,1955787.20,143529.20,730087),('1','136','257952','334',665.00,736.00,0.00,2379.23,1582187.95,1701103.28,118915.33,730088),('1','136','257953','334',665.00,736.00,0.00,915.18,608594.70,663312.48,54717.78,730089),('1','136','257954','334',665.00,736.00,0.00,0.00,0.00,0.00,0.00,730090),('1','136','257955','334',665.00,736.00,0.00,2457.02,1621633.20,1748038.72,126405.52,730091),('1','136','257956','334',660.00,736.00,0.00,2282.34,1506344.40,1630275.24,123930.84,730092),('1','136','257957','334',660.00,736.00,0.00,2024.18,1335958.80,1452182.96,116224.16,730093),('1','136','257958','334',660.00,736.00,0.00,2369.38,1563790.80,1712759.68,148968.88,730094),('1','136','257959','334',660.00,736.00,0.00,2455.77,1620808.20,1772202.72,151394.52,730095),('1','136','257960','334',660.00,736.00,0.00,2808.15,1853379.00,2009400.32,156021.32,730096),('1','136','257961','334',660.00,736.00,0.00,6210.31,4098804.60,4402694.16,303889.56,730097),('1','136','257962','334',660.00,736.00,0.00,3332.75,2199615.00,2378140.00,178525.00,730098),('1','136','257963','334',660.00,736.00,0.00,701.59,463049.40,508193.20,45143.80,730099),('1','136','257964','334',660.00,736.00,0.00,0.00,0.00,0.00,0.00,730100),('1','136','257965','334',660.00,736.00,0.00,2136.99,1410413.40,1527608.64,117195.24,730101),('1','136','257966','334',660.00,736.00,0.00,2141.93,1413673.80,1531424.48,117750.68,730102),('1','136','257967','334',660.00,736.00,0.00,833.06,549819.60,598552.16,48732.56,730103),('1','136','257968','334',660.00,736.00,0.00,0.00,0.00,0.00,0.00,730104),('1','136','257969','334',660.00,736.00,0.00,2577.02,1700833.20,1849760.72,148927.52,730105),('1','136','257970','334',660.00,736.00,0.00,4050.00,2673000.00,2890276.00,217276.00,730106),('1','136','257971','334',660.00,736.00,0.00,3768.73,2487361.80,2713611.28,226249.48,730107),('1','136','257972','334',660.00,736.00,0.00,5170.85,3412761.00,3724081.60,311320.60,730108),('1','136','257973','334',660.00,736.00,0.00,4092.41,2700990.60,2917497.76,216507.16,730109),('1','136','257974','334',660.00,736.00,0.00,4553.56,3005349.60,3222996.16,217646.56,730110),('1','136','257975','334',660.00,736.00,0.00,727.08,479872.80,513818.88,33946.08,730111),('1','136','257976','334',660.00,736.00,0.00,0.00,0.00,0.00,0.00,730112),('1','136','257977','334',654.00,736.00,0.00,2144.67,1402614.18,1525793.08,123178.90,730113),('1','136','257978','334',654.00,736.00,0.00,1501.19,981778.26,1077083.84,95305.58,730114),('1','136','257979','334',654.00,736.00,0.00,1738.80,1137175.20,1256572.80,119397.60,730115),('1','136','257980','334',654.00,736.00,0.00,3402.19,2225032.26,2418387.64,193355.38,730116),('1','136','257981','334',654.00,736.00,0.00,2368.69,1549123.26,1703324.20,154200.94,730117),('1','136','257982','334',654.00,736.00,0.00,2227.97,1457092.38,1586669.72,129577.34,730118),('1','136','257983','334',654.00,736.00,0.00,3755.21,2455907.34,2687612.48,231705.14,730119),('1','136','257984','334',654.00,736.00,0.00,3008.17,1967343.18,2151337.12,183993.94,730120),('1','136','257985','334',654.00,736.00,0.00,2990.84,1956009.36,2143071.80,187062.44,730121),('1','136','257986','334',654.00,736.00,0.00,980.64,641338.56,714983.04,73644.48,730122),('1','136','257987','334',654.00,736.00,0.00,0.00,0.00,0.00,0.00,730123),('1','136','257988','334',654.00,736.00,0.00,1849.68,1209690.72,1318972.48,109281.76,730124),('1','136','257989','334',654.00,736.00,0.00,3006.21,1966061.34,2146375.18,180313.84,730125),('1','136','257990','334',654.00,736.00,0.00,3979.55,2602625.70,2832726.92,230101.22,730126),('1','136','257991','334',654.00,736.00,0.00,3617.73,2365995.42,2585246.92,219251.50,730127),('1','136','257992','334',654.00,736.00,0.00,4068.70,2660929.80,2884543.16,223613.36,730128),('1','136','257993','334',654.00,736.00,0.00,2890.26,1890230.04,2059700.68,169470.64,730129),('1','136','257994','334',654.00,736.00,0.00,4321.47,2826241.38,3069712.48,243471.10,730130),('1','136','257995','334',654.00,736.00,0.00,3702.06,2421147.24,2632189.52,211042.28,730131),('1','136','257996','334',654.00,736.00,0.00,3607.52,2359318.08,2573214.24,213896.16,730132),('1','136','257997','334',654.00,736.00,0.00,3966.60,2594156.40,2829576.38,235419.98,730133),('1','136','257998','334',654.00,736.00,0.00,3885.09,2540848.86,2756106.10,215257.24,730134),('1','136','257999','334',654.00,736.00,0.00,3873.85,2533497.90,2726390.28,192892.38,730135),('1','136','258000','334',654.00,736.00,0.00,2772.46,1813188.84,1975845.56,162656.72,730136),('1','136','258001','334',654.00,736.00,0.00,1514.27,990332.58,1080692.72,90360.14,730137),('1','136','258002','334',654.00,736.00,0.00,0.00,0.00,0.00,0.00,730138),('1','136','258003','334',654.00,736.00,0.00,1739.87,1137874.98,1242847.32,104972.34,730139),('1','136','258004','334',654.00,736.00,0.00,1971.61,1289432.94,1436933.74,147500.80,730140),('1','136','258005','334',654.00,736.00,0.00,3042.26,1989638.04,2181084.02,191445.98,730141),('1','136','258006','334',654.00,736.00,0.00,3586.64,2345662.56,2536472.32,190809.76,730142),('1','136','258007','334',630.00,736.00,0.00,4039.76,2545048.80,2853867.44,308818.64,730143),('1','136','258008','334',630.00,736.00,0.00,2599.33,1637577.90,1857422.72,219844.82,730144),('1','136','258009','334',630.00,736.00,0.00,2964.27,1867490.10,2083266.96,215776.86,730145),('1','136','258010','334',630.00,736.00,0.00,3299.81,2078880.30,2346771.92,267891.62,730146),('1','136','258011','334',630.00,736.00,0.00,2951.11,1859199.30,2089492.56,230293.26,730147),('1','136','258012','334',630.00,736.00,0.00,3550.91,2237073.30,2482254.72,245181.42,730148),('1','136','258013','334',630.00,736.00,0.00,4609.68,2904098.40,3248330.72,344232.32,730149),('1','136','258014','334',630.00,736.00,0.00,3059.22,1927308.60,2174014.72,246706.12,730150),('1','136','258015','334',630.00,736.00,0.00,3461.86,2180971.80,2422771.20,241799.40,730151),('1','136','258016','334',630.00,736.00,0.00,1743.87,1098638.10,1242438.08,143799.98,730152),('1','136','258017','334',630.00,736.00,0.00,2538.41,1599198.30,1809220.56,210022.26,730153),('1','136','258018','334',630.00,736.00,0.00,3060.39,1928045.70,2165130.16,237084.46,730154),('1','136','258019','334',630.00,736.00,0.00,1475.77,929735.10,1054547.44,124812.34,730155),('1','136','258020','334',630.00,736.00,0.00,0.00,0.00,0.00,0.00,730156),('1','136','258021','334',630.00,736.00,0.00,375.43,236520.90,270794.88,34273.98,730157),('1','136','258022','334',630.00,736.00,0.00,3788.56,2386792.80,2684556.72,297763.92,730158),('1','136','258023','334',630.00,736.00,0.00,3479.24,2191921.20,2484564.00,292642.80,730159),('1','136','258024','334',630.00,736.00,0.00,3121.18,1966343.40,2220038.96,253695.56,730160),('1','136','258025','334',630.00,736.00,0.00,3249.78,2047361.40,2308593.52,261232.12,730161),('1','136','258026','334',630.00,736.00,0.00,3075.44,1937527.20,2190181.76,252654.56,730162),('1','136','258027','334',630.00,736.00,0.00,2656.92,1673859.60,1885973.25,212113.65,730163),('1','136','258028','334',630.00,736.00,0.00,2114.53,1332153.90,1516060.92,183907.02,730164),('1','136','258029','334',630.00,736.00,0.00,4284.26,2699083.80,3012238.06,313154.26,730165),('1','136','258030','334',630.00,736.00,0.00,2532.30,1595349.00,1802071.30,206722.30,730166),('1','136','258031','334',630.00,736.00,0.00,2827.42,1781274.60,1987834.73,206560.13,730167),('1','136','258032','334',630.00,736.00,0.00,2787.27,1755980.10,1985817.29,229837.19,730168),('1','136','258033','334',630.00,736.00,0.00,3187.91,2008383.30,2261500.17,253116.87,730169),('1','136','258034','334',630.00,736.00,0.00,3023.06,1904527.80,2106157.58,201629.78,730170),('1','136','258035','334',630.00,736.00,0.00,2511.45,1582213.50,1759420.88,177207.38,730171),('1','136','258036','334',630.00,736.00,0.00,5193.96,3272194.80,3614581.08,342386.28,730172),('1','136','258037','334',630.00,736.00,0.00,1114.63,702216.90,804502.19,102285.29,730173),('1','136','258038','334',630.00,736.00,0.00,0.00,0.00,0.00,0.00,730174),('1','136','258039','334',630.00,736.00,0.00,1796.25,1131637.50,1265918.17,134280.67,730175),('1','136','258040','334',630.00,736.00,0.00,3271.09,2060786.70,2278179.67,217392.97,730176),('1','136','258041','334',630.00,736.00,0.00,3904.67,2459942.10,2735852.07,275909.97,730177),('1','136','258042','334',630.00,736.00,0.00,3380.74,2129866.20,2364392.20,234526.00,730178),('1','136','258043','334',630.00,736.00,0.00,3703.99,2333513.70,2615332.58,281818.88,730179),('1','136','258044','334',630.00,736.00,0.00,5687.86,3583351.80,4007611.21,424259.41,730180),('1','136','258045','334',630.00,736.00,0.00,3170.36,1997326.80,2191899.73,194572.93,730181),('1','136','258046','334',630.00,736.00,0.00,0.00,0.00,0.00,0.00,730182),('1','136','258047','334',630.00,736.00,0.00,2815.00,1773450.00,1986834.67,213384.67,730183),('1','136','258048','334',630.00,736.00,0.00,5246.37,3305213.10,3664366.03,359152.93,730184),('1','136','258049','334',630.00,736.00,0.00,3392.43,2137230.90,2391262.49,254031.59,730185),('1','136','258050','334',630.00,736.00,0.00,4602.34,2899474.20,3203290.68,303816.48,730186),('1','136','258051','334',630.00,736.00,0.00,3268.51,2059161.30,2309114.04,249952.74,730187),('1','136','258052','334',630.00,736.00,0.00,3780.10,2381463.00,2639496.56,258033.56,730188),('1','136','258053','334',630.00,736.00,0.00,1642.55,1034806.50,1156334.80,121528.30,730189),('1','136','258054','334',630.00,736.00,0.00,0.00,0.00,0.00,0.00,730190),('1','136','258055','334',630.00,736.00,0.00,4156.91,2618853.30,2915937.51,297084.21,730191),('1','136','258056','334',630.00,736.00,0.00,3080.55,1940746.50,2184955.54,244209.04,730192),('1','136','258057','334',630.00,736.00,0.00,0.00,0.00,0.00,0.00,730193),('1','136','258058','334',630.00,736.00,0.00,1709.20,1076796.00,1215204.10,138408.10,730194),('1','136','258059','334',630.00,736.00,0.00,5226.37,3292613.10,3644731.87,352118.77,730195),('1','136','258060','334',630.00,736.00,0.00,3208.55,2021386.50,2268224.41,246837.91,730196),('1','136','258061','334',630.00,736.00,0.00,3258.98,2053157.40,2170579.53,117422.13,730197),('1','136','258062','334',624.00,700.00,0.00,2705.72,1688369.28,1849423.52,161054.24,730198),('1','136','258063','334',624.00,700.00,0.00,5149.16,3213075.84,3482273.90,269198.06,730199),('1','136','258064','334',624.00,700.00,0.00,3772.02,2353740.48,2543287.32,189546.84,730200),('1','136','258065','334',624.00,700.00,0.00,1550.63,967593.12,1051478.96,83885.84,730201),('1','136','258066','334',624.00,700.00,0.00,4982.32,3108967.68,3365915.30,256947.62,730202),('1','136','258067','334',624.00,700.00,0.00,5026.44,3136498.56,3393526.06,257027.50,730203),('1','136','258068','334',624.00,700.00,0.00,5839.96,3644135.04,3899725.90,255590.86,730204),('1','136','258069','334',624.00,700.00,0.00,3981.84,2484668.16,2688907.60,204239.44,730205),('1','136','258070','334',624.00,700.00,0.00,3558.81,2220697.44,2387658.00,166960.56,730206),('1','136','258071','334',624.00,700.00,0.00,2142.70,1337044.80,1437263.78,100218.98,730207),('1','136','258072','334',624.00,700.00,0.00,3272.92,2042302.08,2216504.92,174202.84,730208),('1','136','258073','334',624.00,700.00,0.00,4069.09,2539112.16,2738906.04,199793.88,730209),('1','136','258074','334',624.00,700.00,0.00,4672.49,2915633.76,3162113.04,246479.28,730210),('1','136','258075','334',624.00,700.00,0.00,3887.23,2425631.52,2638994.00,213362.48,730211),('1','136','258076','334',624.00,700.00,0.00,5386.09,3360920.16,3565769.00,204848.84,730212);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=311 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',310,'136','PRODUCT TANK','LPG TANK');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=780 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','136','310',779,1,'334','LPG TANK',60000.00,1.00,848.73,'TANK CONTAINING LPG PRODUCT.','487','2020-08-12 09:08:20','2020-08-12 11:46:42','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','136',779,26129.48,'2023-03-20 19:21:34');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2755173 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2107791,'1','136','779',334,'Retail Sale Id 1253918',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 05:49:46','',''),(2107792,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 05:49:46','',''),(2107885,'1','136','779',334,'Retail Sale Id 1253964',998.40,0.00,0.00,0.00,74.88,'2021-12-01 06:03:03','',''),(2107886,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 06:03:03','',''),(2107906,'1','136','779',334,'Retail Sale Id 1253974',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 06:04:37','',''),(2107907,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 06:04:37','',''),(2107946,'1','136','779',334,'Retail Sale Id 1253993',4000.00,0.00,0.00,0.00,300.00,'2021-12-01 06:08:31','',''),(2107947,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 06:08:31','',''),(2107960,'1','136','779',334,'Retail Sale Id 1254001',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 06:09:51','',''),(2107961,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 06:09:51','',''),(2107984,'1','136','779',334,'Retail Sale Id 1254013',3001.60,0.00,0.00,0.00,225.12,'2021-12-01 06:11:44','',''),(2107985,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 06:11:44','',''),(2108061,'1','136','779',334,'Retail Sale Id 1254045',4000.00,0.00,0.00,0.00,300.00,'2021-12-01 06:20:02','',''),(2108062,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 06:20:02','',''),(2108093,'1','136','779',334,'Retail Sale Id 1254064',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 06:23:08','',''),(2108094,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 06:23:08','',''),(2108113,'1','136','779',334,'Retail Sale Id 1254072',4000.00,0.00,0.00,0.00,300.00,'2021-12-01 06:24:58','',''),(2108114,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 06:24:58','',''),(2108137,'1','136','779',334,'Retail Sale Id 1254090',3200.00,0.00,0.00,0.00,240.00,'2021-12-01 06:26:57','',''),(2108138,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 06:26:57','',''),(2108229,'1','136','779',334,'Retail Sale Id 1254138',30000.00,0.00,0.00,0.00,400.00,'2021-12-01 06:33:58','',''),(2108230,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 06:33:58','',''),(2108289,'1','136','779',334,'Retail Sale Id 1254158',998.40,0.00,0.00,0.00,74.88,'2021-12-01 06:36:16','',''),(2108290,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 06:36:16','',''),(2108305,'1','136','779',334,'Retail Sale Id 1254168',4000.00,0.00,0.00,0.00,300.00,'2021-12-01 06:37:07','',''),(2108306,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 06:37:07','',''),(2108343,'1','136','779',334,'Retail Sale Id 1254189',24000.00,0.00,0.00,0.00,320.00,'2021-12-01 06:40:39','',''),(2108344,'1','136','779',334,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-01 06:40:39','',''),(2108363,'1','136','779',334,'Retail Sale Id 1254199',4000.00,0.00,0.00,0.00,300.00,'2021-12-01 06:42:36','',''),(2108364,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 06:42:36','',''),(2108379,'1','136','779',334,'Retail Sale Id 1254207',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 06:44:20','',''),(2108380,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 06:44:20','',''),(2108438,'1','136','779',334,'Retail Sale Id 1254235',4499.20,0.00,0.00,0.00,337.44,'2021-12-01 06:48:52','',''),(2108439,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-01 06:48:52','',''),(2108678,'1','136','779',334,'Retail Sale Id 1254349',998.40,0.00,0.00,0.00,74.88,'2021-12-01 07:00:03','',''),(2108679,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 07:00:03','',''),(2108727,'1','136','779',334,'Retail Sale Id 1254370',998.40,0.00,0.00,0.00,74.88,'2021-12-01 07:02:23','',''),(2108728,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 07:02:23','',''),(2108750,'1','136','779',334,'Retail Sale Id 1254379',3001.60,0.00,0.00,0.00,225.12,'2021-12-01 07:03:48','',''),(2108751,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 07:03:48','',''),(2108870,'1','136','779',334,'Retail Sale Id 1254430',66000.00,0.00,0.00,0.00,880.00,'2021-12-01 07:09:27','',''),(2108871,'1','136','779',334,'Retail sales',0.00,0.00,0.00,110.00,0.00,'2021-12-01 07:09:27','',''),(2108929,'1','136','779',334,'Retail Sale Id 1254449',3200.00,0.00,0.00,0.00,240.00,'2021-12-01 07:11:32','',''),(2108930,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 07:11:32','',''),(2109007,'1','136','779',334,'Retail Sale Id 1254482',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 07:15:14','',''),(2109008,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:15:14','',''),(2109043,'1','136','779',334,'Retail Sale Id 1254505',3200.00,0.00,0.00,0.00,240.00,'2021-12-01 07:17:23','',''),(2109044,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 07:17:23','',''),(2109063,'1','136','779',334,'Retail Sale Id 1254516',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 07:18:30','',''),(2109064,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 07:18:30','',''),(2109108,'1','136','779',334,'Retail Sale Id 1254536',998.40,0.00,0.00,0.00,74.88,'2021-12-01 07:20:49','',''),(2109109,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 07:20:49','',''),(2109152,'1','136','779',334,'Retail Sale Id 1254554',4000.00,0.00,0.00,0.00,300.00,'2021-12-01 07:22:20','',''),(2109153,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 07:22:20','',''),(2109236,'1','136','779',334,'Retail Sale Id 1254575',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 07:25:09','',''),(2109237,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:25:09','',''),(2109257,'1','136','779',334,'Retail Sale Id 1254584',4000.00,0.00,0.00,0.00,300.00,'2021-12-01 07:27:10','',''),(2109258,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 07:27:10','',''),(2109287,'1','136','779',334,'Retail Sale Id 1254594',4000.00,0.00,0.00,0.00,300.00,'2021-12-01 07:28:31','',''),(2109288,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 07:28:31','',''),(2109348,'1','136','779',334,'Retail Sale Id 1254633',108000.00,0.00,0.00,0.00,1440.00,'2021-12-01 07:32:17','',''),(2109349,'1','136','779',334,'Retail sales',0.00,0.00,0.00,180.00,0.00,'2021-12-01 07:32:17','',''),(2109388,'1','136','779',334,'Retail Sale Id 1254656',3001.60,0.00,0.00,0.00,225.12,'2021-12-01 07:34:29','',''),(2109389,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 07:34:29','',''),(2109464,'1','136','779',334,'Retail Sale Id 1254699',1497.60,0.00,0.00,0.00,112.32,'2021-12-01 07:37:59','',''),(2109465,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 07:37:59','',''),(2109484,'1','136','779',334,'Retail Sale Id 1254710',998.40,0.00,0.00,0.00,74.88,'2021-12-01 07:38:49','',''),(2109485,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 07:38:49','',''),(2109498,'1','136','779',334,'Retail Sale Id 1254718',1497.60,0.00,0.00,0.00,112.32,'2021-12-01 07:39:37','',''),(2109499,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 07:39:37','',''),(2109541,'1','136','779',334,'Retail Sale Id 1254725',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 07:40:37','',''),(2109542,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:40:37','',''),(2109574,'1','136','779',334,'Retail Sale Id 1254740',6080.00,0.00,0.00,0.00,456.00,'2021-12-01 07:42:11','',''),(2109575,'1','136','779',334,'Retail sales',0.00,0.00,0.00,9.50,0.00,'2021-12-01 07:42:11','',''),(2109629,'1','136','779',334,'Retail Sale Id 1254766',66000.00,0.00,0.00,0.00,880.00,'2021-12-01 07:44:52','',''),(2109630,'1','136','779',334,'Retail sales',0.00,0.00,0.00,110.00,0.00,'2021-12-01 07:44:52','',''),(2109691,'1','136','779',334,'Retail Sale Id 1254788',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 07:46:47','',''),(2109692,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:46:47','',''),(2109724,'1','136','779',334,'Retail Sale Id 1254803',1497.60,0.00,0.00,0.00,112.32,'2021-12-01 07:47:59','',''),(2109725,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 07:47:59','',''),(2109746,'1','136','779',334,'Retail Sale Id 1254815',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 07:48:55','',''),(2109747,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:48:55','',''),(2109786,'1','136','779',334,'Retail Sale Id 1254834',36000.00,0.00,0.00,0.00,480.00,'2021-12-01 07:50:53','',''),(2109787,'1','136','779',334,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-01 07:50:53','',''),(2109829,'1','136','779',334,'Retail Sale Id 1254849',6400.00,0.00,0.00,0.00,480.00,'2021-12-01 07:53:04','',''),(2109830,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 07:53:04','',''),(2109862,'1','136','779',334,'Retail Sale Id 1254871',4000.00,0.00,0.00,0.00,300.00,'2021-12-01 07:54:58','',''),(2109863,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 07:54:58','',''),(2109915,'1','136','779',334,'Retail Sale Id 1254898',4000.00,0.00,0.00,0.00,300.00,'2021-12-01 07:57:30','',''),(2109916,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 07:57:30','',''),(2109997,'1','136','779',334,'Retail Sale Id 1254941',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 08:02:32','',''),(2109998,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:02:32','',''),(2110017,'1','136','779',334,'Retail Sale Id 1254953',998.40,0.00,0.00,0.00,74.88,'2021-12-01 08:03:14','',''),(2110018,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 08:03:14','',''),(2110066,'1','136','779',334,'Retail Sale Id 1254976',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 08:05:47','',''),(2110067,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:05:47','',''),(2110144,'1','136','779',334,'Retail Sale Id 1255004',3200.00,0.00,0.00,0.00,240.00,'2021-12-01 08:09:45','',''),(2110145,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:09:45','',''),(2110218,'1','136','779',334,'Retail Sale Id 1255044',150000.00,0.00,0.00,0.00,2000.00,'2021-12-01 08:14:16','',''),(2110219,'1','136','779',334,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-01 08:14:16','',''),(2110238,'1','136','779',334,'Retail Sale Id 1255054',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 08:16:03','',''),(2110239,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:16:03','',''),(2110266,'1','136','779',334,'Retail Sale Id 1255069',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 08:17:21','',''),(2110267,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:17:21','',''),(2110286,'1','136','779',334,'Retail Sale Id 1255080',4000.00,0.00,0.00,0.00,300.00,'2021-12-01 08:18:02','',''),(2110287,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 08:18:02','',''),(2110342,'1','136','779',334,'Retail Sale Id 1255099',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 08:20:49','',''),(2110343,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:20:49','',''),(2110395,'1','136','779',334,'Retail Sale Id 1255136',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 08:24:08','',''),(2110396,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:24:08','',''),(2110407,'1','136','779',334,'Retail Sale Id 1255139',4000.00,0.00,0.00,0.00,300.00,'2021-12-01 08:25:16','',''),(2110408,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 08:25:16','',''),(2110421,'1','136','779',334,'Retail Sale Id 1255148',4000.00,0.00,0.00,0.00,300.00,'2021-12-01 08:26:22','',''),(2110422,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 08:26:22','',''),(2110451,'1','136','779',334,'Retail Sale Id 1255165',30000.00,0.00,0.00,0.00,400.00,'2021-12-01 08:28:31','',''),(2110452,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 08:28:31','',''),(2110475,'1','136','779',334,'Retail Sale Id 1255177',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 08:30:05','',''),(2110476,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 08:30:05','',''),(2110489,'1','136','779',334,'Retail Sale Id 1255183',998.40,0.00,0.00,0.00,74.88,'2021-12-01 08:31:10','',''),(2110490,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 08:31:10','',''),(2110592,'1','136','779',334,'Retail Sale Id 1255228',4000.00,0.00,0.00,0.00,300.00,'2021-12-01 08:36:32','',''),(2110593,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 08:36:32','',''),(2110625,'1','136','779',334,'Retail Sale Id 1255242',4000.00,0.00,0.00,0.00,300.00,'2021-12-01 08:38:26','',''),(2110626,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 08:38:26','',''),(2110832,'1','136','779',334,'Retail Sale Id 1255354',2598.40,0.00,0.00,0.00,194.88,'2021-12-01 08:49:50','',''),(2110833,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-01 08:49:50','',''),(2110844,'1','136','779',334,'Retail Sale Id 1255362',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 08:50:53','',''),(2110845,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:50:53','',''),(2110882,'1','136','779',334,'Retail Sale Id 1255381',11200.00,0.00,0.00,0.00,840.00,'2021-12-01 08:53:30','',''),(2110883,'1','136','779',334,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-01 08:53:30','',''),(2110912,'1','136','779',334,'Retail Sale Id 1255396',3001.60,0.00,0.00,0.00,225.12,'2021-12-01 08:54:58','',''),(2110913,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 08:54:58','',''),(2110979,'1','136','779',334,'Retail Sale Id 1255434',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 08:59:09','',''),(2110980,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:59:09','',''),(2111040,'1','136','779',334,'Retail Sale Id 1255462',8000.00,0.00,0.00,0.00,600.00,'2021-12-01 09:02:40','',''),(2111041,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:02:40','',''),(2111084,'1','136','779',334,'Retail Sale Id 1255482',2003.20,0.00,0.00,0.00,150.24,'2021-12-01 09:04:34','',''),(2111085,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 09:04:34','',''),(2111102,'1','136','779',334,'Retail Sale Id 1255491',4000.00,0.00,0.00,0.00,300.00,'2021-12-01 09:05:33','',''),(2111103,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 09:05:33','',''),(2111204,'1','136','779',334,'Retail Sale Id 1255532',30000.00,0.00,0.00,0.00,400.00,'2021-12-01 09:12:29','',''),(2111205,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 09:12:29','',''),(2112196,'1','136','779',334,'Retail Sale Id 1256048',17203.20,0.00,0.00,0.00,1290.24,'2021-12-01 10:16:20','',''),(2112197,'1','136','779',334,'Retail sales',0.00,0.00,0.00,26.88,0.00,'2021-12-01 10:16:20','',''),(2112744,'1','136',NULL,334,'Purchased from AA RANO NIGERIA LIMITED',0.00,14515080.00,24940.00,0.00,0.00,'2021-12-01 11:02:05','',''),(2112769,'1','136',NULL,334,'Reception corrector for bridging 125836',0.00,0.00,0.00,24940.00,0.00,'2021-12-01 11:04:23','',''),(2112770,'1','136','779',334,'Received from bridging 125836',0.00,0.00,24940.00,0.00,0.00,'2021-12-01 11:04:23','',''),(2112862,'1','136','779',334,'Distributed to BLESSED IYKE for sales id:274136',53568.00,0.00,0.00,186.00,0.00,'2021-12-01 11:10:47','',''),(2112869,'1','136','779',334,'Distributed to OPERATIONAL LOSS for sales id:254898',25843.00,0.00,0.00,120.20,0.00,'2021-12-01 11:11:01','',''),(2112941,'1','136','779',334,'Retail Sale Id 1256418',8000.00,0.00,0.00,0.00,725.00,'2021-12-01 11:15:31','',''),(2112942,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:15:31','',''),(2112987,'1','136','779',334,'Retail Sale Id 1256433',3200.00,0.00,0.00,0.00,290.00,'2021-12-01 11:16:51','',''),(2112988,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 11:16:51','',''),(2113014,'1','136','779',334,'Retail Sale Id 1256441',16000.00,0.00,0.00,0.00,1450.00,'2021-12-01 11:18:37','',''),(2113015,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 11:18:37','',''),(2113144,'1','136','779',334,'Retail Sale Id 1256507',4000.00,0.00,0.00,0.00,362.50,'2021-12-01 11:26:20','',''),(2113145,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 11:26:20','',''),(2113200,'1','136','779',334,'Retail Sale Id 1256534',30000.00,0.00,0.00,0.00,900.00,'2021-12-01 11:29:53','',''),(2113201,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 11:29:53','',''),(2113260,'1','136','779',334,'Retail Sale Id 1256572',2598.40,0.00,0.00,0.00,235.48,'2021-12-01 11:35:11','',''),(2113261,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-01 11:35:11','',''),(2113284,'1','136','779',334,'Retail Sale Id 1256585',9000.00,0.00,0.00,0.00,270.00,'2021-12-01 11:36:34','',''),(2113285,'1','136','779',334,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-01 11:36:34','',''),(2113404,'1','136','779',334,'Retail Sale Id 1256649',1497.60,0.00,0.00,0.00,135.72,'2021-12-01 11:45:24','',''),(2113405,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 11:45:24','',''),(2113435,'1','136','779',334,'Retail Sale Id 1256664',4000.00,0.00,0.00,0.00,362.50,'2021-12-01 11:48:24','',''),(2113436,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 11:48:24','',''),(2113527,'1','136','779',334,'Retail Sale Id 1256711',60000.00,0.00,0.00,0.00,1800.00,'2021-12-01 11:55:24','',''),(2113528,'1','136','779',334,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-01 11:55:24','',''),(2113539,'1','136','779',334,'Retail Sale Id 1256716',1299.20,0.00,0.00,0.00,117.74,'2021-12-01 11:56:07','',''),(2113540,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 11:56:07','',''),(2113555,'1','136','779',334,'Retail Sale Id 1256723',8000.00,0.00,0.00,0.00,725.00,'2021-12-01 11:57:16','',''),(2113556,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:57:16','',''),(2113569,'1','136','779',334,'Retail Sale Id 1256734',2003.20,0.00,0.00,0.00,181.54,'2021-12-01 11:59:08','',''),(2113570,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 11:59:08','',''),(2113595,'1','136','779',334,'Retail Sale Id 1256749',120000.00,0.00,0.00,0.00,3600.00,'2021-12-01 12:01:49','',''),(2113596,'1','136','779',334,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-01 12:01:49','',''),(2113673,'1','136','779',334,'Retail Sale Id 1256790',4000.00,0.00,0.00,0.00,362.50,'2021-12-01 12:11:33','',''),(2113674,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 12:11:33','',''),(2113723,'1','136','779',334,'Retail Sale Id 1256818',4000.00,0.00,0.00,0.00,362.50,'2021-12-01 12:14:22','',''),(2113724,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 12:14:22','',''),(2113797,'1','136','779',334,'Retail Sale Id 1256854',1401.60,0.00,0.00,0.00,127.02,'2021-12-01 12:19:23','',''),(2113798,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-01 12:19:23','',''),(2113897,'1','136','779',334,'Retail Sale Id 1256904',2003.20,0.00,0.00,0.00,181.54,'2021-12-01 12:25:29','',''),(2113898,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 12:25:29','',''),(2113927,'1','136','779',334,'Retail Sale Id 1256919',8000.00,0.00,0.00,0.00,725.00,'2021-12-01 12:27:49','',''),(2113928,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:27:49','',''),(2114043,'1','136','779',334,'Retail Sale Id 1256978',3200.00,0.00,0.00,0.00,290.00,'2021-12-01 12:39:24','',''),(2114044,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 12:39:24','',''),(2114081,'1','136','779',334,'Retail Sale Id 1256997',2003.20,0.00,0.00,0.00,181.54,'2021-12-01 12:42:48','',''),(2114082,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 12:42:48','',''),(2114107,'1','136','779',334,'Retail Sale Id 1257010',8000.00,0.00,0.00,0.00,725.00,'2021-12-01 12:45:43','',''),(2114108,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:45:43','',''),(2114146,'1','136','779',334,'Retail Sale Id 1257026',3001.60,0.00,0.00,0.00,272.02,'2021-12-01 12:49:49','',''),(2114147,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 12:49:49','',''),(2114244,'1','136','779',334,'Retail Sale Id 1257081',8000.00,0.00,0.00,0.00,725.00,'2021-12-01 13:01:11','',''),(2114245,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:01:11','',''),(2114362,'1','136','779',334,'Retail Sale Id 1257124',8000.00,0.00,0.00,0.00,725.00,'2021-12-01 13:08:11','',''),(2114363,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:08:11','',''),(2114428,'1','136','779',334,'Retail Sale Id 1257204',4000.00,0.00,0.00,0.00,362.50,'2021-12-01 13:13:03','',''),(2114429,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 13:13:03','',''),(2114484,'1','136','779',334,'Retail Sale Id 1257233',15000.00,0.00,0.00,0.00,450.00,'2021-12-01 13:16:13','',''),(2114485,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 13:16:13','',''),(2114560,'1','136','779',334,'Retail Sale Id 1257275',179400.00,0.00,0.00,0.00,4800.00,'2021-12-01 13:22:35','',''),(2114561,'1','136','779',334,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-01 13:22:35','',''),(2114592,'1','136','779',334,'Retail Sale Id 1257291',3200.00,0.00,0.00,0.00,290.00,'2021-12-01 13:24:24','',''),(2114593,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 13:24:24','',''),(2114697,'1','136','779',334,'Retail Sale Id 1257340',998.40,0.00,0.00,0.00,90.48,'2021-12-01 13:34:03','',''),(2114698,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 13:34:03','',''),(2114721,'1','136','779',334,'Retail Sale Id 1257352',8000.00,0.00,0.00,0.00,725.00,'2021-12-01 13:35:44','',''),(2114722,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:35:44','',''),(2114775,'1','136','779',334,'Retail Sale Id 1257366',24000.00,0.00,0.00,0.00,720.00,'2021-12-01 13:38:34','',''),(2114776,'1','136','779',334,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-01 13:38:34','',''),(2114818,'1','136','779',334,'Retail Sale Id 1257374',800.00,0.00,0.00,0.00,72.50,'2021-12-01 13:40:19','',''),(2114819,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-01 13:40:19','',''),(2114942,'1','136','779',334,'Retail Sale Id 1257413',2003.20,0.00,0.00,0.00,181.54,'2021-12-01 13:46:14','',''),(2114943,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 13:46:14','',''),(2115045,'1','136','779',334,'Retail Sale Id 1257453',1299.20,0.00,0.00,0.00,117.74,'2021-12-01 13:52:35','',''),(2115046,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 13:52:35','',''),(2115063,'1','136','779',334,'Retail Sale Id 1257461',6400.00,0.00,0.00,0.00,580.00,'2021-12-01 13:53:15','',''),(2115064,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 13:53:15','',''),(2115084,'1','136','779',334,'Retail Sale Id 1257468',1900.80,0.00,0.00,0.00,172.26,'2021-12-01 13:54:19','',''),(2115085,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-01 13:54:19','',''),(2115100,'1','136','779',334,'Retail Sale Id 1257481',998.40,0.00,0.00,0.00,90.48,'2021-12-01 13:55:37','',''),(2115101,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 13:55:37','',''),(2115186,'1','136','779',334,'Retail Sale Id 1257525',4000.00,0.00,0.00,0.00,362.50,'2021-12-01 13:59:44','',''),(2115187,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 13:59:44','',''),(2115243,'1','136','779',334,'Retail Sale Id 1257552',120000.00,0.00,0.00,0.00,3600.00,'2021-12-01 14:02:52','',''),(2115244,'1','136','779',334,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-01 14:02:52','',''),(2115313,'1','136','779',334,'Retail Sale Id 1257584',8000.00,0.00,0.00,0.00,725.00,'2021-12-01 14:07:00','',''),(2115314,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:07:00','',''),(2115329,'1','136','779',334,'Retail Sale Id 1257592',4000.00,0.00,0.00,0.00,362.50,'2021-12-01 14:08:04','',''),(2115330,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 14:08:04','',''),(2115425,'1','136','779',334,'Retail Sale Id 1257651',3200.00,0.00,0.00,0.00,290.00,'2021-12-01 14:14:35','',''),(2115426,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 14:14:35','',''),(2115506,'1','136','779',334,'Retail Sale Id 1257689',1497.60,0.00,0.00,0.00,135.72,'2021-12-01 14:20:04','',''),(2115507,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 14:20:04','',''),(2115520,'1','136','779',334,'Retail Sale Id 1257696',4601.60,0.00,0.00,0.00,417.02,'2021-12-01 14:21:18','',''),(2115521,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.19,0.00,'2021-12-01 14:21:18','',''),(2115534,'1','136','779',334,'Retail Sale Id 1257703',2003.20,0.00,0.00,0.00,181.54,'2021-12-01 14:22:17','',''),(2115535,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 14:22:17','',''),(2115565,'1','136','779',334,'Retail Sale Id 1257730',8000.00,0.00,0.00,0.00,725.00,'2021-12-01 14:24:57','',''),(2115566,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:24:57','',''),(2115597,'1','136','779',334,'Retail Sale Id 1257742',8640.00,0.00,0.00,0.00,783.00,'2021-12-01 14:26:59','',''),(2115598,'1','136','779',334,'Retail sales',0.00,0.00,0.00,13.50,0.00,'2021-12-01 14:26:59','',''),(2115616,'1','136','779',334,'Retail Sale Id 1257752',3001.60,0.00,0.00,0.00,272.02,'2021-12-01 14:27:58','',''),(2115617,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 14:27:58','',''),(2115644,'1','136','779',334,'Retail Sale Id 1257766',2003.20,0.00,0.00,0.00,181.54,'2021-12-01 14:30:30','',''),(2115645,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 14:30:30','',''),(2115720,'1','136','779',334,'Retail Sale Id 1257802',2003.20,0.00,0.00,0.00,181.54,'2021-12-01 14:35:29','',''),(2115721,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 14:35:29','',''),(2115732,'1','136','779',334,'Retail Sale Id 1257808',60000.00,0.00,0.00,0.00,1800.00,'2021-12-01 14:36:21','',''),(2115733,'1','136','779',334,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-01 14:36:21','',''),(2115754,'1','136','779',334,'Retail Sale Id 1257815',2003.20,0.00,0.00,0.00,181.54,'2021-12-01 14:37:57','',''),(2115755,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 14:37:57','',''),(2115764,'1','136','779',334,'Retail Sale Id 1257825',2003.20,0.00,0.00,0.00,181.54,'2021-12-01 14:38:31','',''),(2115765,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 14:38:31','',''),(2115821,'1','136','779',334,'Retail Sale Id 1257853',24000.00,0.00,0.00,0.00,2175.00,'2021-12-01 14:44:09','',''),(2115822,'1','136','779',334,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-01 14:44:09','',''),(2115856,'1','136','779',334,'Retail Sale Id 1257867',4998.40,0.00,0.00,0.00,452.98,'2021-12-01 14:47:25','',''),(2115858,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 14:47:25','',''),(2115955,'1','136','779',334,'Retail Sale Id 1257906',8000.00,0.00,0.00,0.00,725.00,'2021-12-01 14:51:52','',''),(2115956,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:51:52','',''),(2115973,'1','136','779',334,'Retail Sale Id 1257911',1497.60,0.00,0.00,0.00,135.72,'2021-12-01 14:52:41','',''),(2115974,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 14:52:41','',''),(2116074,'1','136','779',334,'Retail Sale Id 1257941',3200.00,0.00,0.00,0.00,290.00,'2021-12-01 14:57:56','',''),(2116075,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 14:57:56','',''),(2116312,'1','136','779',334,'Retail Sale Id 1258064',3500.80,0.00,0.00,0.00,317.26,'2021-12-01 15:15:18','',''),(2116313,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 15:15:18','',''),(2116800,'1','136','779',334,'Retail Sale Id 1258292',6400.00,0.00,0.00,0.00,580.00,'2021-12-01 15:45:21','',''),(2116801,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 15:45:21','',''),(2116834,'1','136','779',334,'Retail Sale Id 1258312',1497.60,0.00,0.00,0.00,135.72,'2021-12-01 15:46:52','',''),(2116835,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 15:46:52','',''),(2117141,'1','136','779',334,'Retail Sale Id 1258459',1299.20,0.00,0.00,0.00,117.74,'2021-12-01 15:59:32','',''),(2117142,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 15:59:32','',''),(2117147,'1','136','779',334,'Retail Sale Id 1258465',4000.00,0.00,0.00,0.00,362.50,'2021-12-01 16:00:14','',''),(2117148,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 16:00:14','',''),(2117346,'1','136','779',334,'Retail Sale Id 1258553',2598.40,0.00,0.00,0.00,235.48,'2021-12-01 16:08:21','',''),(2117348,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-01 16:08:21','',''),(2117646,'1','136','779',334,'Retail Sale Id 1258688',30000.00,0.00,0.00,0.00,900.00,'2021-12-01 16:20:12','',''),(2117647,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 16:20:12','',''),(2118020,'1','136','779',334,'Retail Sale Id 1258898',1952.00,0.00,0.00,0.00,176.90,'2021-12-01 16:37:47','',''),(2118021,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 16:37:47','',''),(2118196,'1','136','779',334,'Retail Sale Id 1258992',1299.20,0.00,0.00,0.00,117.74,'2021-12-01 16:46:48','',''),(2118197,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 16:46:48','',''),(2118228,'1','136','779',334,'Retail Sale Id 1259010',2598.40,0.00,0.00,0.00,235.48,'2021-12-01 16:48:24','',''),(2118229,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-01 16:48:24','',''),(2118280,'1','136','779',334,'Retail Sale Id 1259034',4000.00,0.00,0.00,0.00,362.50,'2021-12-01 16:50:52','',''),(2118281,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 16:50:52','',''),(2118363,'1','136','779',334,'Retail Sale Id 1259071',12000.00,0.00,0.00,0.00,360.00,'2021-12-01 16:54:02','',''),(2118364,'1','136','779',334,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-01 16:54:02','',''),(2118522,'1','136','779',334,'Retail Sale Id 1259150',2003.20,0.00,0.00,0.00,181.54,'2021-12-01 17:00:50','',''),(2118523,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 17:00:50','',''),(2118542,'1','136','779',334,'Retail Sale Id 1259165',3001.60,0.00,0.00,0.00,272.02,'2021-12-01 17:01:47','',''),(2118543,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 17:01:47','',''),(2118594,'1','136','779',334,'Retail Sale Id 1259189',8000.00,0.00,0.00,0.00,725.00,'2021-12-01 17:04:20','',''),(2118595,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:04:20','',''),(2118634,'1','136','779',334,'Retail Sale Id 1259205',4000.00,0.00,0.00,0.00,362.50,'2021-12-01 17:06:23','',''),(2118635,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 17:06:23','',''),(2118662,'1','136','779',334,'Retail Sale Id 1259220',3200.00,0.00,0.00,0.00,290.00,'2021-12-01 17:07:43','',''),(2118663,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 17:07:43','',''),(2118680,'1','136','779',334,'Retail Sale Id 1259232',8000.00,0.00,0.00,0.00,725.00,'2021-12-01 17:08:39','',''),(2118681,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:08:39','',''),(2118724,'1','136','779',334,'Retail Sale Id 1259251',3200.00,0.00,0.00,0.00,290.00,'2021-12-01 17:11:16','',''),(2118725,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 17:11:16','',''),(2118794,'1','136','779',334,'Retail Sale Id 1259292',2003.20,0.00,0.00,0.00,181.54,'2021-12-01 17:15:02','',''),(2118795,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 17:15:02','',''),(2118812,'1','136','779',334,'Retail Sale Id 1259299',2003.20,0.00,0.00,0.00,181.54,'2021-12-01 17:15:52','',''),(2118813,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 17:15:52','',''),(2119141,'1','136','779',334,'Retail Sale Id 1259462',321300.00,0.00,0.00,0.00,9639.00,'2021-12-01 17:39:01','',''),(2119142,'1','136','779',334,'Retail sales',0.00,0.00,0.00,535.50,0.00,'2021-12-01 17:39:01','',''),(2119187,'1','136','779',334,'Retail Sale Id 1259482',381918.68,0.00,0.00,0.00,10218.56,'2021-12-01 17:42:19','',''),(2119188,'1','136','779',334,'Retail sales',0.00,0.00,0.00,638.66,0.00,'2021-12-01 17:42:19','',''),(2120461,'1','136','779',334,'Retail Sale Id 1259887',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 06:11:00','',''),(2120462,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 06:11:00','',''),(2120476,'1','136','779',334,'Retail Sale Id 1259893',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 06:11:57','',''),(2120477,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 06:11:57','',''),(2120490,'1','136','779',334,'Retail Sale Id 1259899',3200.00,0.00,0.00,0.00,290.00,'2021-12-02 06:12:54','',''),(2120491,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 06:12:54','',''),(2120526,'1','136','779',334,'Retail Sale Id 1259917',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 06:16:10','',''),(2120527,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 06:16:10','',''),(2120626,'1','136','779',334,'Retail Sale Id 1259962',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 06:23:11','',''),(2120627,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 06:23:11','',''),(2120686,'1','136','779',334,'Retail Sale Id 1259991',3500.80,0.00,0.00,0.00,317.26,'2021-12-02 06:28:03','',''),(2120687,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 06:28:03','',''),(2120738,'1','136','779',334,'Retail Sale Id 1260020',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 06:31:57','',''),(2120739,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 06:31:57','',''),(2120752,'1','136','779',334,'Retail Sale Id 1260029',2502.40,0.00,0.00,0.00,226.78,'2021-12-02 06:32:57','',''),(2120753,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 06:32:58','',''),(2120768,'1','136','779',334,'Retail Sale Id 1260035',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 06:34:03','',''),(2120769,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 06:34:03','',''),(2120778,'1','136','779',334,'Retail Sale Id 1260041',1497.60,0.00,0.00,0.00,135.72,'2021-12-02 06:34:51','',''),(2120779,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 06:34:51','',''),(2120790,'1','136','779',334,'Retail Sale Id 1260047',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 06:35:48','',''),(2120791,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 06:35:48','',''),(2120814,'1','136','779',334,'Retail Sale Id 1260060',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 06:37:35','',''),(2120815,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 06:37:35','',''),(2120953,'1','136','779',334,'Retail Sale Id 1260093',6400.00,0.00,0.00,0.00,580.00,'2021-12-02 06:42:31','',''),(2120954,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 06:42:31','',''),(2121048,'1','136','779',334,'Retail Sale Id 1260127',1299.20,0.00,0.00,0.00,117.74,'2021-12-02 06:47:28','',''),(2121049,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 06:47:28','',''),(2121070,'1','136','779',334,'Retail Sale Id 1260138',998.40,0.00,0.00,0.00,90.48,'2021-12-02 06:48:35','',''),(2121071,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 06:48:35','',''),(2121104,'1','136','779',334,'Retail Sale Id 1260158',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 06:50:23','',''),(2121105,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 06:50:23','',''),(2121152,'1','136','779',334,'Retail Sale Id 1260185',30000.00,0.00,0.00,0.00,900.00,'2021-12-02 06:54:12','',''),(2121153,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 06:54:12','',''),(2121232,'1','136','779',334,'Retail Sale Id 1260212',45000.00,0.00,0.00,0.00,1350.00,'2021-12-02 06:58:20','',''),(2121233,'1','136','779',334,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-02 06:58:20','',''),(2121455,'1','136','779',334,'Retail Sale Id 1260319',998.40,0.00,0.00,0.00,90.48,'2021-12-02 07:10:28','',''),(2121456,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 07:10:28','',''),(2121546,'1','136','779',334,'Retail Sale Id 1260349',6003.20,0.00,0.00,0.00,544.04,'2021-12-02 07:14:14','',''),(2121547,'1','136','779',334,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 07:14:14','',''),(2121707,'1','136','779',334,'Retail Sale Id 1260426',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 07:22:03','',''),(2121708,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 07:22:03','',''),(2121729,'1','136','779',334,'Retail Sale Id 1260437',3001.60,0.00,0.00,0.00,272.02,'2021-12-02 07:23:21','',''),(2121730,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 07:23:21','',''),(2121861,'1','136','779',334,'Retail Sale Id 1260513',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 07:30:07','',''),(2121862,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 07:30:07','',''),(2121881,'1','136','779',334,'Retail Sale Id 1260526',30000.00,0.00,0.00,0.00,900.00,'2021-12-02 07:31:04','',''),(2121882,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 07:31:04','',''),(2121963,'1','136','779',334,'Retail Sale Id 1260579',210000.00,0.00,0.00,0.00,6300.00,'2021-12-02 07:36:24','',''),(2121964,'1','136','779',334,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-02 07:36:24','',''),(2122015,'1','136','779',334,'Retail Sale Id 1260605',1497.60,0.00,0.00,0.00,135.72,'2021-12-02 07:38:41','',''),(2122016,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 07:38:41','',''),(2122043,'1','136','779',334,'Retail Sale Id 1260624',1299.20,0.00,0.00,0.00,117.74,'2021-12-02 07:39:49','',''),(2122044,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 07:39:49','',''),(2122086,'1','136','779',334,'Retail Sale Id 1260644',7200.00,0.00,0.00,0.00,652.50,'2021-12-02 07:41:36','',''),(2122087,'1','136','779',334,'Retail sales',0.00,0.00,0.00,11.25,0.00,'2021-12-02 07:41:36','',''),(2122235,'1','136','779',334,'Retail Sale Id 1260721',3500.80,0.00,0.00,0.00,317.26,'2021-12-02 07:49:01','',''),(2122236,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 07:49:01','',''),(2122303,'1','136','779',334,'Retail Sale Id 1260739',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 07:50:28','',''),(2122304,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 07:50:28','',''),(2122349,'1','136','779',334,'Retail Sale Id 1260762',24000.00,0.00,0.00,0.00,720.00,'2021-12-02 07:52:03','',''),(2122350,'1','136','779',334,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-02 07:52:03','',''),(2122385,'1','136','779',334,'Retail Sale Id 1260780',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 07:53:40','',''),(2122386,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 07:53:40','',''),(2122399,'1','136','779',334,'Retail Sale Id 1260787',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 07:54:38','',''),(2122400,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 07:54:38','',''),(2122424,'1','136','779',334,'Retail Sale Id 1260800',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 07:55:22','',''),(2122425,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 07:55:22','',''),(2122448,'1','136','779',334,'Retail Sale Id 1260806',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 07:56:13','',''),(2122449,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:56:13','',''),(2122466,'1','136','779',334,'Retail Sale Id 1260817',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 07:57:02','',''),(2122467,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 07:57:02','',''),(2122500,'1','136','779',334,'Retail Sale Id 1260829',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 07:58:05','',''),(2122501,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:58:05','',''),(2122745,'1','136','779',334,'Retail Sale Id 1260945',7040.00,0.00,0.00,0.00,638.00,'2021-12-02 08:08:53','',''),(2122746,'1','136','779',334,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-02 08:08:53','',''),(2122760,'1','136','779',334,'Retail Sale Id 1260950',998.40,0.00,0.00,0.00,90.48,'2021-12-02 08:09:50','',''),(2122761,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 08:09:50','',''),(2122916,'1','136','779',334,'Retail Sale Id 1261036',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 08:18:34','',''),(2122917,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 08:18:34','',''),(2122946,'1','136','779',334,'Retail Sale Id 1261052',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 08:19:58','',''),(2122947,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 08:19:58','',''),(2123021,'1','136','779',334,'Retail Sale Id 1261096',998.40,0.00,0.00,0.00,90.48,'2021-12-02 08:23:39','',''),(2123022,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 08:23:39','',''),(2123145,'1','136','779',334,'Retail Sale Id 1261151',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 08:29:52','',''),(2123146,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 08:29:52','',''),(2123297,'1','136','779',334,'Retail Sale Id 1261211',60000.00,0.00,0.00,0.00,1800.00,'2021-12-02 08:37:53','',''),(2123298,'1','136','779',334,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-02 08:37:53','',''),(2123352,'1','136','779',334,'Retail Sale Id 1261235',1299.20,0.00,0.00,0.00,117.74,'2021-12-02 08:39:38','',''),(2123353,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 08:39:38','',''),(2123399,'1','136','779',334,'Retail Sale Id 1261255',36000.00,0.00,0.00,0.00,1080.00,'2021-12-02 08:41:50','',''),(2123400,'1','136','779',334,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-02 08:41:50','',''),(2123435,'1','136','779',334,'Retail Sale Id 1261279',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 08:43:58','',''),(2123436,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:43:58','',''),(2123461,'1','136','779',334,'Retail Sale Id 1261295',3001.60,0.00,0.00,0.00,272.02,'2021-12-02 08:45:28','',''),(2123462,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 08:45:28','',''),(2123529,'1','136','779',334,'Retail Sale Id 1261324',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 08:49:59','',''),(2123530,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 08:49:59','',''),(2123583,'1','136','779',334,'Retail Sale Id 1261347',6003.20,0.00,0.00,0.00,544.04,'2021-12-02 08:52:47','',''),(2123584,'1','136','779',334,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 08:52:47','',''),(2123681,'1','136','779',334,'Retail Sale Id 1261399',12000.00,0.00,0.00,0.00,1087.50,'2021-12-02 08:58:19','',''),(2123682,'1','136','779',334,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-02 08:58:19','',''),(2123703,'1','136','779',334,'Retail Sale Id 1261411',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 08:59:18','',''),(2123704,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 08:59:18','',''),(2123767,'1','136','779',334,'Retail Sale Id 1261458',3001.60,0.00,0.00,0.00,272.02,'2021-12-02 09:02:54','',''),(2123768,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 09:02:54','',''),(2123813,'1','136','779',334,'Retail Sale Id 1261475',51000.00,0.00,0.00,0.00,1530.00,'2021-12-02 09:04:50','',''),(2123814,'1','136','779',334,'Retail sales',0.00,0.00,0.00,85.00,0.00,'2021-12-02 09:04:50','',''),(2123845,'1','136','779',334,'Retail Sale Id 1261498',3001.60,0.00,0.00,0.00,272.02,'2021-12-02 09:06:42','',''),(2123846,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 09:06:42','',''),(2123885,'1','136','779',334,'Retail Sale Id 1261518',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 09:08:16','',''),(2123886,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 09:08:16','',''),(2123937,'1','136','779',334,'Retail Sale Id 1261542',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 09:10:54','',''),(2123938,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 09:10:54','',''),(2124011,'1','136','779',334,'Retail Sale Id 1261574',2598.40,0.00,0.00,0.00,235.48,'2021-12-02 09:14:13','',''),(2124012,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-02 09:14:13','',''),(2124058,'1','136','779',334,'Retail Sale Id 1261589',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 09:16:10','',''),(2124059,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:16:10','',''),(2124098,'1','136','779',334,'Retail Sale Id 1261599',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 09:17:02','',''),(2124099,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 09:17:02','',''),(2124154,'1','136','779',334,'Retail Sale Id 1261625',6400.00,0.00,0.00,0.00,580.00,'2021-12-02 09:20:09','',''),(2124155,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 09:20:09','',''),(2124282,'1','136','779',334,'Retail Sale Id 1261692',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 09:27:38','',''),(2124283,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 09:27:38','',''),(2124306,'1','136','779',334,'Retail Sale Id 1261702',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 09:28:51','',''),(2124307,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 09:28:51','',''),(2124332,'1','136','779',334,'Retail Sale Id 1261715',2502.40,0.00,0.00,0.00,226.78,'2021-12-02 09:30:38','',''),(2124333,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 09:30:38','',''),(2124370,'1','136','779',334,'Retail Sale Id 1261734',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 09:32:44','',''),(2124371,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 09:32:44','',''),(2124507,'1','136','779',334,'Retail Sale Id 1261805',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 09:42:38','',''),(2124508,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 09:42:38','',''),(2124527,'1','136','779',334,'Retail Sale Id 1261814',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 09:43:35','',''),(2124528,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 09:43:35','',''),(2124570,'1','136','779',334,'Retail Sale Id 1261835',5203.20,0.00,0.00,0.00,471.54,'2021-12-02 09:45:29','',''),(2124571,'1','136','779',334,'Retail sales',0.00,0.00,0.00,8.13,0.00,'2021-12-02 09:45:29','',''),(2124602,'1','136','779',334,'Retail Sale Id 1261848',16000.00,0.00,0.00,0.00,1450.00,'2021-12-02 09:47:29','',''),(2124603,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 09:47:29','',''),(2124623,'1','136','779',334,'Retail Sale Id 1261858',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 09:48:52','',''),(2124624,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 09:48:52','',''),(2124659,'1','136','779',334,'Retail Sale Id 1261876',25200.00,0.00,0.00,0.00,756.00,'2021-12-02 09:50:24','',''),(2124660,'1','136','779',334,'Retail sales',0.00,0.00,0.00,42.00,0.00,'2021-12-02 09:50:24','',''),(2124705,'1','136','779',334,'Retail Sale Id 1261911',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 09:52:27','',''),(2124706,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:52:27','',''),(2124731,'1','136','779',334,'Retail Sale Id 1261924',16000.00,0.00,0.00,0.00,1450.00,'2021-12-02 09:53:29','',''),(2124732,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 09:53:29','',''),(2124753,'1','136','779',334,'Retail Sale Id 1261936',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 09:54:31','',''),(2124754,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 09:54:31','',''),(2124807,'1','136','779',334,'Retail Sale Id 1261963',40000.00,0.00,0.00,0.00,3625.00,'2021-12-02 09:57:40','',''),(2124808,'1','136','779',334,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-02 09:57:40','',''),(2124898,'1','136','779',334,'Retail Sale Id 1262009',4998.40,0.00,0.00,0.00,452.98,'2021-12-02 10:02:23','',''),(2124899,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 10:02:23','',''),(2124923,'1','136','779',334,'Retail Sale Id 1262021',3200.00,0.00,0.00,0.00,290.00,'2021-12-02 10:03:10','',''),(2124924,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 10:03:10','',''),(2124991,'1','136','779',334,'Retail Sale Id 1262061',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 10:08:17','',''),(2124992,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 10:08:17','',''),(2125077,'1','136','779',334,'Retail Sale Id 1262103',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 10:13:00','',''),(2125078,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:13:00','',''),(2125118,'1','136','779',334,'Retail Sale Id 1262124',181800.00,0.00,0.00,0.00,5454.00,'2021-12-02 10:15:33','',''),(2125119,'1','136','779',334,'Retail sales',0.00,0.00,0.00,303.00,0.00,'2021-12-02 10:15:33','',''),(2125204,'1','136','779',334,'Retail Sale Id 1262167',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 10:19:56','',''),(2125205,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:19:56','',''),(2125214,'1','136','779',334,'Retail Sale Id 1262173',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 10:21:11','',''),(2125215,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 10:21:11','',''),(2125313,'1','136','779',334,'Retail Sale Id 1262214',5120.00,0.00,0.00,0.00,464.00,'2021-12-02 10:25:32','',''),(2125314,'1','136','779',334,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-02 10:25:32','',''),(2125340,'1','136','779',334,'Retail Sale Id 1262229',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 10:26:56','',''),(2125341,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:26:56','',''),(2125358,'1','136','779',334,'Retail Sale Id 1262241',10003.20,0.00,0.00,0.00,906.54,'2021-12-02 10:28:26','',''),(2125359,'1','136','779',334,'Retail sales',0.00,0.00,0.00,15.63,0.00,'2021-12-02 10:28:26','',''),(2125452,'1','136','779',334,'Retail Sale Id 1262288',3897.60,0.00,0.00,0.00,353.22,'2021-12-02 10:34:33','',''),(2125453,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 10:34:33','',''),(2125472,'1','136','779',334,'Retail Sale Id 1262297',3200.00,0.00,0.00,0.00,290.00,'2021-12-02 10:35:34','',''),(2125473,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 10:35:34','',''),(2125486,'1','136','779',334,'Retail Sale Id 1262304',800.00,0.00,0.00,0.00,72.50,'2021-12-02 10:36:20','',''),(2125487,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-02 10:36:20','',''),(2125502,'1','136','779',334,'Retail Sale Id 1262313',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 10:37:19','',''),(2125503,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:37:19','',''),(2125516,'1','136','779',334,'Retail Sale Id 1262320',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 10:38:16','',''),(2125517,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 10:38:16','',''),(2125550,'1','136','779',334,'Retail Sale Id 1262335',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 10:40:40','',''),(2125551,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:40:40','',''),(2125638,'1','136','779',334,'Retail Sale Id 1262379',998.40,0.00,0.00,0.00,90.48,'2021-12-02 10:45:22','',''),(2125639,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 10:45:22','',''),(2125656,'1','136','779',334,'Retail Sale Id 1262388',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 10:46:26','',''),(2125657,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:46:26','',''),(2125670,'1','136','779',334,'Retail Sale Id 1262395',3200.00,0.00,0.00,0.00,290.00,'2021-12-02 10:47:31','',''),(2125671,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 10:47:31','',''),(2125750,'1','136','779',334,'Retail Sale Id 1262429',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 10:52:29','',''),(2125751,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 10:52:29','',''),(2125800,'1','136','779',334,'Retail Sale Id 1262451',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 10:56:43','',''),(2125801,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:56:43','',''),(2125820,'1','136','779',334,'Retail Sale Id 1262466',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 10:58:11','',''),(2125821,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:58:11','',''),(2125830,'1','136','779',334,'Retail Sale Id 1262475',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 10:59:34','',''),(2125831,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 10:59:34','',''),(2125858,'1','136','779',334,'Retail Sale Id 1262488',3001.60,0.00,0.00,0.00,272.02,'2021-12-02 11:01:07','',''),(2125859,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 11:01:07','',''),(2126020,'1','136','779',334,'Retail Sale Id 1262578',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 11:10:41','',''),(2126021,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 11:10:41','',''),(2126045,'1','136','779',334,'Retail Sale Id 1262589',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 11:11:50','',''),(2126046,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:11:50','',''),(2126078,'1','136','779',334,'Retail Sale Id 1262605',3001.60,0.00,0.00,0.00,272.02,'2021-12-02 11:14:11','',''),(2126079,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 11:14:11','',''),(2126090,'1','136','779',334,'Retail Sale Id 1262617',6400.00,0.00,0.00,0.00,580.00,'2021-12-02 11:15:13','',''),(2126091,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 11:15:13','',''),(2126246,'1','136','779',334,'Retail Sale Id 1262701',998.40,0.00,0.00,0.00,90.48,'2021-12-02 11:23:35','',''),(2126247,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 11:23:35','',''),(2126274,'1','136','779',334,'Retail Sale Id 1262713',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 11:25:35','',''),(2126275,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 11:25:35','',''),(2126334,'1','136','779',334,'Retail Sale Id 1262744',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 11:28:38','',''),(2126335,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 11:28:38','',''),(2126352,'1','136','779',334,'Retail Sale Id 1262753',1497.60,0.00,0.00,0.00,135.72,'2021-12-02 11:29:24','',''),(2126353,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 11:29:24','',''),(2126392,'1','136','779',334,'Retail Sale Id 1262768',3200.00,0.00,0.00,0.00,290.00,'2021-12-02 11:31:00','',''),(2126393,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 11:31:00','',''),(2126484,'1','136','779',334,'Retail Sale Id 1262804',998.40,0.00,0.00,0.00,90.48,'2021-12-02 11:35:22','',''),(2126485,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 11:35:22','',''),(2126743,'1','136','779',334,'Retail Sale Id 1262921',3200.00,0.00,0.00,0.00,290.00,'2021-12-02 11:52:20','',''),(2126744,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 11:52:20','',''),(2126777,'1','136','779',334,'Retail Sale Id 1262942',30000.00,0.00,0.00,0.00,900.00,'2021-12-02 11:54:58','',''),(2126778,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 11:54:58','',''),(2126861,'1','136','779',334,'Retail Sale Id 1262983',3200.00,0.00,0.00,0.00,290.00,'2021-12-02 12:01:37','',''),(2126862,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 12:01:37','',''),(2126873,'1','136','779',334,'Retail Sale Id 1262989',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 12:03:08','',''),(2126874,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:03:08','',''),(2126895,'1','136','779',334,'Retail Sale Id 1263001',3001.60,0.00,0.00,0.00,272.02,'2021-12-02 12:05:02','',''),(2126896,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 12:05:02','',''),(2127019,'1','136','779',334,'Retail Sale Id 1263062',10200.00,0.00,0.00,0.00,306.00,'2021-12-02 12:16:16','',''),(2127020,'1','136','779',334,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-02 12:16:16','',''),(2127046,'1','136','779',334,'Retail Sale Id 1263075',3200.00,0.00,0.00,0.00,290.00,'2021-12-02 12:19:42','',''),(2127047,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 12:19:42','',''),(2127064,'1','136','779',334,'Retail Sale Id 1263088',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 12:20:44','',''),(2127065,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 12:20:44','',''),(2127202,'1','136','779',334,'Retail Sale Id 1263158',209300.00,0.00,0.00,0.00,5600.00,'2021-12-02 12:30:04','',''),(2127203,'1','136','779',334,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-02 12:30:04','',''),(2127276,'1','136','779',334,'Retail Sale Id 1263213',3500.80,0.00,0.00,0.00,317.26,'2021-12-02 12:35:46','',''),(2127277,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 12:35:46','',''),(2127332,'1','136','779',334,'Retail Sale Id 1263245',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 12:39:35','',''),(2127333,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 12:39:35','',''),(2127353,'1','136','779',334,'Retail Sale Id 1263255',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 12:42:13','',''),(2127354,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 12:42:13','',''),(2127398,'1','136','779',334,'Retail Sale Id 1263276',3200.00,0.00,0.00,0.00,290.00,'2021-12-02 12:46:50','',''),(2127399,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 12:46:50','',''),(2127718,'1','136','779',334,'Retail Sale Id 1263423',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 13:09:20','',''),(2127719,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 13:09:20','',''),(2127728,'1','136','779',334,'Retail Sale Id 1263428',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 13:10:22','',''),(2127729,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 13:10:22','',''),(2127738,'1','136','779',334,'Retail Sale Id 1263434',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 13:10:59','',''),(2127739,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 13:10:59','',''),(2127965,'1','136','779',334,'Retail Sale Id 1263529',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 13:24:56','',''),(2127966,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 13:24:56','',''),(2128188,'1','136','779',334,'Retail Sale Id 1263607',6400.00,0.00,0.00,0.00,580.00,'2021-12-02 13:39:36','',''),(2128189,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 13:39:36','',''),(2128204,'1','136','779',334,'Retail Sale Id 1263617',3200.00,0.00,0.00,0.00,290.00,'2021-12-02 13:41:02','',''),(2128205,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 13:41:02','',''),(2128274,'1','136','779',334,'Retail Sale Id 1263652',1299.20,0.00,0.00,0.00,117.74,'2021-12-02 13:45:29','',''),(2128275,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 13:45:29','',''),(2128399,'1','136','779',334,'Retail Sale Id 1263717',22800.00,0.00,0.00,0.00,684.00,'2021-12-02 13:52:49','',''),(2128400,'1','136','779',334,'Retail sales',0.00,0.00,0.00,38.00,0.00,'2021-12-02 13:52:49','',''),(2129843,'1','136','779',334,'Retail Sale Id 1264349',998.40,0.00,0.00,0.00,90.48,'2021-12-02 15:09:42','',''),(2129844,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 15:09:42','',''),(2130329,'1','136','779',334,'Retail Sale Id 1264583',67200.00,0.00,0.00,0.00,2016.00,'2021-12-02 15:33:40','',''),(2130330,'1','136','779',334,'Retail sales',0.00,0.00,0.00,112.00,0.00,'2021-12-02 15:33:40','',''),(2130564,'1','136','779',334,'Retail Sale Id 1264710',1497.60,0.00,0.00,0.00,135.72,'2021-12-02 15:44:15','',''),(2130565,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 15:44:15','',''),(2130616,'1','136','779',334,'Retail Sale Id 1264740',3001.60,0.00,0.00,0.00,272.02,'2021-12-02 15:46:28','',''),(2130617,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 15:46:28','',''),(2130662,'1','136','779',334,'Retail Sale Id 1264766',3200.00,0.00,0.00,0.00,290.00,'2021-12-02 15:48:41','',''),(2130663,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:48:41','',''),(2130948,'1','136','779',334,'Retail Sale Id 1264915',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 16:01:26','',''),(2130949,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:01:26','',''),(2131035,'1','136','779',334,'Retail Sale Id 1264952',1600.00,0.00,0.00,0.00,145.00,'2021-12-02 16:04:56','',''),(2131036,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-02 16:04:56','',''),(2131351,'1','136','779',334,'Retail Sale Id 1265107',998.40,0.00,0.00,0.00,90.48,'2021-12-02 16:19:28','',''),(2131352,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 16:19:28','',''),(2131698,'1','136','779',334,'Retail Sale Id 1265272',2502.40,0.00,0.00,0.00,226.78,'2021-12-02 16:33:59','',''),(2131699,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 16:33:59','',''),(2131833,'1','136','779',334,'Retail Sale Id 1265337',14400.00,0.00,0.00,0.00,1305.00,'2021-12-02 16:41:55','',''),(2131834,'1','136','779',334,'Retail sales',0.00,0.00,0.00,22.50,0.00,'2021-12-02 16:41:55','',''),(2131974,'1','136','779',334,'Retail Sale Id 1265409',30000.00,0.00,0.00,0.00,900.00,'2021-12-02 16:48:06','',''),(2131975,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 16:48:06','',''),(2132138,'1','136','779',334,'Retail Sale Id 1265494',2598.40,0.00,0.00,0.00,235.48,'2021-12-02 16:58:20','',''),(2132139,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-02 16:58:20','',''),(2132191,'1','136','779',334,'Retail Sale Id 1265516',6003.20,0.00,0.00,0.00,544.04,'2021-12-02 17:01:29','',''),(2132192,'1','136','779',334,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 17:01:29','',''),(2132239,'1','136','779',334,'Retail Sale Id 1265535',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 17:04:16','',''),(2132240,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 17:04:16','',''),(2132251,'1','136','779',334,'Retail Sale Id 1265542',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 17:05:17','',''),(2132252,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 17:05:17','',''),(2132263,'1','136','779',334,'Retail Sale Id 1265550',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 17:06:04','',''),(2132264,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 17:06:04','',''),(2132381,'1','136','779',334,'Retail Sale Id 1265607',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 17:14:08','',''),(2132382,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 17:14:08','',''),(2132420,'1','136','779',334,'Retail Sale Id 1265628',8000.00,0.00,0.00,0.00,725.00,'2021-12-02 17:16:10','',''),(2132421,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 17:16:10','',''),(2132470,'1','136','779',334,'Return of Retail Sale Id 1265628',0.00,8000.00,12.50,0.00,-725.00,'2021-12-02 17:18:23','',''),(2132479,'1','136','779',334,'Retail Sale Id 1265649',7001.60,0.00,0.00,0.00,634.52,'2021-12-02 17:18:54','',''),(2132480,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-02 17:18:54','',''),(2132759,'1','136','779',334,'Retail Sale Id 1265775',2003.20,0.00,0.00,0.00,181.54,'2021-12-02 17:41:08','',''),(2132760,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 17:41:08','',''),(2132792,'1','136','779',334,'Retail Sale Id 1265796',67744.00,0.00,0.00,0.00,6139.30,'2021-12-02 17:45:50','',''),(2132793,'1','136','779',334,'Retail sales',0.00,0.00,0.00,105.85,0.00,'2021-12-02 17:45:50','',''),(2132812,'1','136','779',334,'Retail Sale Id 1265805',119600.00,0.00,0.00,0.00,3200.00,'2021-12-02 17:47:13','',''),(2132813,'1','136','779',334,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-02 17:47:13','',''),(2132846,'1','136','779',334,'Retail Sale Id 1265816',3571.20,0.00,0.00,0.00,323.64,'2021-12-02 17:50:04','',''),(2132847,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.58,0.00,'2021-12-02 17:50:04','',''),(2133092,'1','136','779',334,'Return of Retail Sale Id 1261963',0.00,40000.00,62.50,0.00,-3625.00,'2021-12-02 18:13:25','',''),(2133097,'1','136','779',334,'Retail Sale Id 1265900',4000.00,0.00,0.00,0.00,362.50,'2021-12-02 18:14:09','',''),(2133098,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 18:14:09','',''),(2133976,'1','136','779',334,'Retail Sale Id 1266113',998.40,0.00,0.00,0.00,90.48,'2021-12-03 06:11:26','',''),(2133977,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 06:11:26','',''),(2134085,'1','136','779',334,'Retail Sale Id 1266138',10003.20,0.00,0.00,0.00,906.54,'2021-12-03 06:19:47','',''),(2134086,'1','136','779',334,'Retail sales',0.00,0.00,0.00,15.63,0.00,'2021-12-03 06:19:47','',''),(2134111,'1','136','779',334,'Retail Sale Id 1266153',16000.00,0.00,0.00,0.00,1450.00,'2021-12-03 06:23:20','',''),(2134112,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 06:23:20','',''),(2134133,'1','136','779',334,'Retail Sale Id 1266163',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 06:25:38','',''),(2134134,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 06:25:38','',''),(2134302,'1','136','779',334,'Retail Sale Id 1266236',6003.20,0.00,0.00,0.00,544.04,'2021-12-03 06:36:50','',''),(2134303,'1','136','779',334,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-03 06:36:50','',''),(2134445,'1','136','779',334,'Retail Sale Id 1266312',6400.00,0.00,0.00,0.00,580.00,'2021-12-03 06:44:55','',''),(2134446,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 06:44:55','',''),(2134536,'1','136','779',334,'Retail Sale Id 1266350',133500.00,0.00,0.00,0.00,4005.00,'2021-12-03 06:49:27','',''),(2134537,'1','136','779',334,'Retail sales',0.00,0.00,0.00,222.50,0.00,'2021-12-03 06:49:27','',''),(2134597,'1','136','779',334,'Retail Sale Id 1266384',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 06:52:57','',''),(2134598,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 06:52:57','',''),(2134613,'1','136','779',334,'Retail Sale Id 1266392',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 06:53:43','',''),(2134614,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 06:53:43','',''),(2134715,'1','136','779',334,'Retail Sale Id 1266441',18003.20,0.00,0.00,0.00,1631.54,'2021-12-03 06:59:05','',''),(2134716,'1','136','779',334,'Retail sales',0.00,0.00,0.00,28.13,0.00,'2021-12-03 06:59:05','',''),(2134735,'1','136','779',334,'Retail Sale Id 1266453',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 07:00:17','',''),(2134736,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 07:00:17','',''),(2134753,'1','136','779',334,'Retail Sale Id 1266462',15000.00,0.00,0.00,0.00,450.00,'2021-12-03 07:01:32','',''),(2134754,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 07:01:32','',''),(2134809,'1','136','779',334,'Retail Sale Id 1266492',3200.00,0.00,0.00,0.00,290.00,'2021-12-03 07:04:56','',''),(2134810,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 07:04:56','',''),(2134992,'1','136','779',334,'Retail Sale Id 1266580',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 07:15:11','',''),(2134993,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 07:15:11','',''),(2135014,'1','136','779',334,'Retail Sale Id 1266592',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 07:16:22','',''),(2135015,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 07:16:22','',''),(2135141,'1','136','779',334,'Retail Sale Id 1266649',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 07:23:01','',''),(2135142,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:23:01','',''),(2135168,'1','136','779',334,'Retail Sale Id 1266664',2598.40,0.00,0.00,0.00,235.48,'2021-12-03 07:25:16','',''),(2135169,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-03 07:25:16','',''),(2135234,'1','136','779',334,'Retail Sale Id 1266697',24000.00,0.00,0.00,0.00,720.00,'2021-12-03 07:29:02','',''),(2135235,'1','136','779',334,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-03 07:29:02','',''),(2135278,'1','136','779',334,'Retail Sale Id 1266716',30000.00,0.00,0.00,0.00,900.00,'2021-12-03 07:32:04','',''),(2135279,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 07:32:04','',''),(2135358,'1','136','779',334,'Retail Sale Id 1266759',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 07:35:54','',''),(2135359,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 07:35:54','',''),(2135382,'1','136','779',334,'Retail Sale Id 1266770',3200.00,0.00,0.00,0.00,290.00,'2021-12-03 07:37:15','',''),(2135383,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 07:37:15','',''),(2135411,'1','136','779',334,'Retail Sale Id 1266780',16000.00,0.00,0.00,0.00,1450.00,'2021-12-03 07:38:33','',''),(2135412,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 07:38:33','',''),(2135433,'1','136','779',334,'Retail Sale Id 1266793',2502.40,0.00,0.00,0.00,226.78,'2021-12-03 07:40:02','',''),(2135434,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 07:40:02','',''),(2135481,'1','136','779',334,'Retail Sale Id 1266814',37500.00,0.00,0.00,0.00,1125.00,'2021-12-03 07:42:56','',''),(2135482,'1','136','779',334,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-03 07:42:56','',''),(2135532,'1','136','779',334,'Retail Sale Id 1266838',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 07:45:46','',''),(2135533,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 07:45:46','',''),(2135647,'1','136','779',334,'Retail Sale Id 1266892',1299.20,0.00,0.00,0.00,117.74,'2021-12-03 07:50:53','',''),(2135648,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 07:50:53','',''),(2135810,'1','136','779',334,'Retail Sale Id 1266964',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 08:00:25','',''),(2135811,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 08:00:25','',''),(2135841,'1','136','779',334,'Retail Sale Id 1266972',2502.40,0.00,0.00,0.00,226.78,'2021-12-03 08:01:15','',''),(2135842,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 08:01:15','',''),(2135897,'1','136','779',334,'Retail Sale Id 1266987',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 08:02:36','',''),(2135898,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:02:36','',''),(2135947,'1','136','779',334,'Retail Sale Id 1267010',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 08:04:39','',''),(2135948,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 08:04:39','',''),(2136076,'1','136','779',334,'Retail Sale Id 1267072',3200.00,0.00,0.00,0.00,290.00,'2021-12-03 08:10:21','',''),(2136077,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 08:10:21','',''),(2136180,'1','136','779',334,'Retail Sale Id 1267128',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 08:15:48','',''),(2136181,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 08:15:48','',''),(2136196,'1','136','779',334,'Retail Sale Id 1267140',1299.20,0.00,0.00,0.00,117.74,'2021-12-03 08:16:55','',''),(2136197,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 08:16:55','',''),(2136249,'1','136','779',334,'Retail Sale Id 1267166',66000.00,0.00,0.00,0.00,1980.00,'2021-12-03 08:19:30','',''),(2136250,'1','136','779',334,'Retail sales',0.00,0.00,0.00,110.00,0.00,'2021-12-03 08:19:30','',''),(2136292,'1','136','779',334,'Retail Sale Id 1267185',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 08:21:57','',''),(2136293,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:21:57','',''),(2136318,'1','136','779',334,'Retail Sale Id 1267197',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 08:23:43','',''),(2136319,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 08:23:43','',''),(2136366,'1','136','779',334,'Retail Sale Id 1267219',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 08:26:18','',''),(2136367,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 08:26:18','',''),(2136443,'1','136','779',334,'Retail Sale Id 1267258',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 08:32:10','',''),(2136444,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 08:32:10','',''),(2136495,'1','136','779',334,'Retail Sale Id 1267270',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 08:34:41','',''),(2136496,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:34:41','',''),(2136728,'1','136','779',334,'Retail Sale Id 1267326',10003.20,0.00,0.00,0.00,906.54,'2021-12-03 08:41:41','',''),(2136729,'1','136','779',334,'Retail sales',0.00,0.00,0.00,15.63,0.00,'2021-12-03 08:41:41','',''),(2136762,'1','136','779',334,'Retail Sale Id 1267341',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 08:42:53','',''),(2136763,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 08:42:53','',''),(2136896,'1','136','779',334,'Retail Sale Id 1267410',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 08:51:15','',''),(2136897,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:51:15','',''),(2136944,'1','136','779',334,'Retail Sale Id 1267434',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 08:54:08','',''),(2136945,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 08:54:08','',''),(2136984,'1','136','779',334,'Retail Sale Id 1267454',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 08:56:23','',''),(2136985,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:56:23','',''),(2137088,'1','136','779',334,'Retail Sale Id 1267510',30000.00,0.00,0.00,0.00,900.00,'2021-12-03 09:01:47','',''),(2137089,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 09:01:47','',''),(2137140,'1','136','779',334,'Retail Sale Id 1267536',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 09:04:03','',''),(2137141,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:04:03','',''),(2137162,'1','136','779',334,'Retail Sale Id 1267550',998.40,0.00,0.00,0.00,90.48,'2021-12-03 09:05:19','',''),(2137163,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 09:05:19','',''),(2137245,'1','136','779',334,'Retail Sale Id 1267597',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 09:09:11','',''),(2137246,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:09:11','',''),(2137471,'1','136','779',334,'Retail Sale Id 1267729',179400.00,0.00,0.00,0.00,4800.00,'2021-12-03 09:20:47','',''),(2137472,'1','136','779',334,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-03 09:20:47','',''),(2137493,'1','136','779',334,'Retail Sale Id 1267740',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 09:22:23','',''),(2137494,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:22:23','',''),(2137511,'1','136','779',334,'Retail Sale Id 1267748',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 09:23:19','',''),(2137512,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:23:19','',''),(2137531,'1','136','779',334,'Retail Sale Id 1267759',16000.00,0.00,0.00,0.00,1450.00,'2021-12-03 09:24:39','',''),(2137532,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 09:24:39','',''),(2137577,'1','136','779',334,'Retail Sale Id 1267786',123000.00,0.00,0.00,0.00,3690.00,'2021-12-03 09:27:15','',''),(2137578,'1','136','779',334,'Retail sales',0.00,0.00,0.00,205.00,0.00,'2021-12-03 09:27:15','',''),(2137645,'1','136','779',334,'Retail Sale Id 1267828',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 09:31:40','',''),(2137646,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:31:40','',''),(2137681,'1','136','779',334,'Retail Sale Id 1267848',16000.00,0.00,0.00,0.00,1450.00,'2021-12-03 09:33:53','',''),(2137682,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 09:33:53','',''),(2137898,'1','136','779',334,'Retail Sale Id 1267962',18000.00,0.00,0.00,0.00,540.00,'2021-12-03 09:47:22','',''),(2137899,'1','136','779',334,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-03 09:47:22','',''),(2137980,'1','136','779',334,'Retail Sale Id 1268001',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 09:52:13','',''),(2137981,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:52:13','',''),(2138008,'1','136','779',334,'Retail Sale Id 1268015',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 09:53:59','',''),(2138009,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 09:53:59','',''),(2138028,'1','136','779',334,'Retail Sale Id 1268025',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 09:55:44','',''),(2138029,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:55:44','',''),(2138052,'1','136','779',334,'Retail Sale Id 1268037',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 09:56:54','',''),(2138053,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:56:54','',''),(2138068,'1','136','779',334,'Retail Sale Id 1268045',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 09:58:11','',''),(2138069,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:58:11','',''),(2138136,'1','136','779',334,'Retail Sale Id 1268076',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 10:02:19','',''),(2138137,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:02:19','',''),(2138304,'1','136','779',334,'Retail Sale Id 1268162',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 10:10:45','',''),(2138305,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 10:10:45','',''),(2138324,'1','136','779',334,'Retail Sale Id 1268174',2502.40,0.00,0.00,0.00,226.78,'2021-12-03 10:11:49','',''),(2138325,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 10:11:49','',''),(2138391,'1','136','779',334,'Retail Sale Id 1268208',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 10:16:09','',''),(2138392,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:16:09','',''),(2138417,'1','136','779',334,'Retail Sale Id 1268219',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 10:17:21','',''),(2138418,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 10:17:21','',''),(2138582,'1','136','779',334,'Retail Sale Id 1268299',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 10:26:48','',''),(2138583,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 10:26:48','',''),(2138602,'1','136','779',334,'Retail Sale Id 1268308',3200.00,0.00,0.00,0.00,290.00,'2021-12-03 10:28:10','',''),(2138603,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 10:28:10','',''),(2138612,'1','136','779',334,'Retail Sale Id 1268314',998.40,0.00,0.00,0.00,90.48,'2021-12-03 10:29:11','',''),(2138613,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 10:29:11','',''),(2138641,'1','136','779',334,'Retail Sale Id 1268326',998.40,0.00,0.00,0.00,90.48,'2021-12-03 10:30:47','',''),(2138642,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 10:30:47','',''),(2138693,'1','136','779',334,'Retail Sale Id 1268354',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 10:34:27','',''),(2138694,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 10:34:27','',''),(2138789,'1','136','779',334,'Retail Sale Id 1268398',6400.00,0.00,0.00,0.00,580.00,'2021-12-03 10:39:30','',''),(2138790,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 10:39:30','',''),(2138807,'1','136','779',334,'Retail Sale Id 1268409',210000.00,0.00,0.00,0.00,6300.00,'2021-12-03 10:40:44','',''),(2138808,'1','136','779',334,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-03 10:40:44','',''),(2138891,'1','136','779',334,'Retail Sale Id 1268458',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 10:47:31','',''),(2138892,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:47:31','',''),(2138907,'1','136','779',334,'Retail Sale Id 1268467',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 10:49:13','',''),(2138908,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 10:49:13','',''),(2138925,'1','136','779',334,'Retail Sale Id 1268475',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 10:50:15','',''),(2138926,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 10:50:15','',''),(2138935,'1','136','779',334,'Retail Sale Id 1268482',2598.40,0.00,0.00,0.00,235.48,'2021-12-03 10:51:12','',''),(2138936,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-03 10:51:12','',''),(2138955,'1','136','779',334,'Retail Sale Id 1268493',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 10:52:46','',''),(2138956,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:52:46','',''),(2138987,'1','136','779',334,'Retail Sale Id 1268506',3200.00,0.00,0.00,0.00,290.00,'2021-12-03 10:55:22','',''),(2138988,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 10:55:22','',''),(2139017,'1','136','779',334,'Retail Sale Id 1268521',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 10:58:30','',''),(2139018,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 10:58:30','',''),(2139153,'1','136','779',334,'Retail Sale Id 1268596',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 11:08:37','',''),(2139154,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 11:08:37','',''),(2139217,'1','136','779',334,'Retail Sale Id 1268629',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 11:13:47','',''),(2139218,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:13:47','',''),(2139283,'1','136','779',334,'Retail Sale Id 1268661',1299.20,0.00,0.00,0.00,117.74,'2021-12-03 11:17:19','',''),(2139284,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 11:17:19','',''),(2139291,'1','136','779',334,'Retail Sale Id 1268668',1497.60,0.00,0.00,0.00,135.72,'2021-12-03 11:18:04','',''),(2139292,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 11:18:04','',''),(2139409,'1','136','779',334,'Retail Sale Id 1268725',30000.00,0.00,0.00,0.00,900.00,'2021-12-03 11:28:00','',''),(2139410,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 11:28:00','',''),(2139484,'1','136','779',334,'Retail Sale Id 1268766',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 11:33:40','',''),(2139485,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 11:33:40','',''),(2139496,'1','136','779',334,'Retail Sale Id 1268772',998.40,0.00,0.00,0.00,90.48,'2021-12-03 11:34:23','',''),(2139497,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 11:34:23','',''),(2139502,'1','136','779',334,'Retail Sale Id 1268775',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 11:34:59','',''),(2139503,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:34:59','',''),(2139582,'1','136','779',334,'Retail Sale Id 1268828',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 11:41:56','',''),(2139583,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:41:56','',''),(2139785,'1','136','779',334,'Retail Sale Id 1268937',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 11:56:47','',''),(2139786,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 11:56:47','',''),(2139851,'1','136','779',334,'Retail Sale Id 1268972',352820.00,0.00,0.00,0.00,9440.00,'2021-12-03 12:02:01','',''),(2139852,'1','136','779',334,'Retail sales',0.00,0.00,0.00,590.00,0.00,'2021-12-03 12:02:01','',''),(2139883,'1','136','779',334,'Retail Sale Id 1268992',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 12:03:43','',''),(2139884,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:03:43','',''),(2140141,'1','136','779',334,'Retail Sale Id 1269142',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 12:25:35','',''),(2140142,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 12:25:35','',''),(2140184,'1','136','779',334,'Retail Sale Id 1269162',209300.00,0.00,0.00,0.00,5600.00,'2021-12-03 12:29:07','',''),(2140185,'1','136','779',334,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-03 12:29:07','',''),(2140240,'1','136','779',334,'Retail Sale Id 1269200',90000.00,0.00,0.00,0.00,2700.00,'2021-12-03 12:33:27','',''),(2140241,'1','136','779',334,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-03 12:33:27','',''),(2140276,'1','136','779',334,'Retail Sale Id 1269225',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 12:36:32','',''),(2140277,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 12:36:32','',''),(2140419,'1','136','779',334,'Retail Sale Id 1269289',4998.40,0.00,0.00,0.00,452.98,'2021-12-03 12:47:07','',''),(2140420,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 12:47:07','',''),(2140433,'1','136','779',334,'Retail Sale Id 1269298',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 12:48:05','',''),(2140434,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 12:48:05','',''),(2140569,'1','136','779',334,'Retail Sale Id 1269365',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 12:56:31','',''),(2140570,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:56:31','',''),(2140761,'1','136','779',334,'Retail Sale Id 1269455',12000.00,0.00,0.00,0.00,1087.50,'2021-12-03 13:14:24','',''),(2140762,'1','136','779',334,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-03 13:14:24','',''),(2140919,'1','136','779',334,'Retail Sale Id 1269520',4998.40,0.00,0.00,0.00,452.98,'2021-12-03 13:26:15','',''),(2140920,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 13:26:15','',''),(2140937,'1','136','779',334,'Retail Sale Id 1269528',33920.00,0.00,0.00,0.00,3074.00,'2021-12-03 13:27:11','',''),(2140938,'1','136','779',334,'Retail sales',0.00,0.00,0.00,53.00,0.00,'2021-12-03 13:27:11','',''),(2140939,'1','136','779',334,'Return of Retail Sale Id 1269528',0.00,33920.00,53.00,0.00,-3074.00,'2021-12-03 13:27:41','',''),(2140948,'1','136','779',334,'Retail Sale Id 1269533',3200.00,0.00,0.00,0.00,290.00,'2021-12-03 13:28:04','',''),(2140949,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 13:28:04','',''),(2140988,'1','136','779',334,'Retail Sale Id 1269555',12000.00,0.00,0.00,0.00,360.00,'2021-12-03 13:30:55','',''),(2140989,'1','136','779',334,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-03 13:30:55','',''),(2141021,'1','136','779',334,'Retail Sale Id 1269570',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 13:33:16','',''),(2141022,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 13:33:16','',''),(2141057,'1','136','779',334,'Retail Sale Id 1269590',998.40,0.00,0.00,0.00,90.48,'2021-12-03 13:35:35','',''),(2141058,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 13:35:35','',''),(2141116,'1','136','779',334,'Retail Sale Id 1269621',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 13:39:04','',''),(2141117,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 13:39:04','',''),(2141186,'1','136','779',334,'Retail Sale Id 1269647',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 13:42:58','',''),(2141187,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 13:42:58','',''),(2141202,'1','136','779',334,'Retail Sale Id 1269659',1798.40,0.00,0.00,0.00,162.98,'2021-12-03 13:43:44','',''),(2141203,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-03 13:43:44','',''),(2141230,'1','136','779',334,'Retail Sale Id 1269667',998.40,0.00,0.00,0.00,90.48,'2021-12-03 13:44:47','',''),(2141231,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 13:44:47','',''),(2141250,'1','136','779',334,'Retail Sale Id 1269675',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 13:45:41','',''),(2141251,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:45:41','',''),(2141405,'1','136','779',334,'Retail Sale Id 1269717',10003.20,0.00,0.00,0.00,906.54,'2021-12-03 13:50:10','',''),(2141406,'1','136','779',334,'Retail sales',0.00,0.00,0.00,15.63,0.00,'2021-12-03 13:50:10','',''),(2141437,'1','136','779',334,'Retail Sale Id 1269731',2502.40,0.00,0.00,0.00,226.78,'2021-12-03 13:51:44','',''),(2141438,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 13:51:44','',''),(2141503,'1','136','779',334,'Retail Sale Id 1269760',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 13:55:23','',''),(2141504,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 13:55:23','',''),(2141526,'1','136','779',334,'Retail Sale Id 1269773',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 13:57:31','',''),(2141527,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 13:57:31','',''),(2141554,'1','136','779',334,'Retail Sale Id 1269785',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 13:59:54','',''),(2141555,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 13:59:54','',''),(2141572,'1','136','779',334,'Retail Sale Id 1269792',64000.00,0.00,0.00,0.00,5800.00,'2021-12-03 14:01:01','',''),(2141573,'1','136','779',334,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-03 14:01:01','',''),(2141711,'1','136','779',334,'Retail Sale Id 1269841',9600.00,0.00,0.00,0.00,870.00,'2021-12-03 14:08:17','',''),(2141712,'1','136','779',334,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-03 14:08:17','',''),(2141737,'1','136','779',334,'Return of Retail Sale Id 1269717',0.00,10003.20,15.63,0.00,-906.54,'2021-12-03 14:09:55','',''),(2141754,'1','136','779',334,'Retail Sale Id 1269870',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 14:11:20','',''),(2141755,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 14:11:20','',''),(2141768,'1','136','779',334,'Retail Sale Id 1269875',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 14:12:03','',''),(2141769,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 14:12:03','',''),(2141850,'1','136','779',334,'Retail Sale Id 1269910',3200.00,0.00,0.00,0.00,290.00,'2021-12-03 14:18:21','',''),(2141851,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 14:18:21','',''),(2141967,'1','136','779',334,'Retail Sale Id 1269947',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 14:24:13','',''),(2141968,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 14:24:13','',''),(2142113,'1','136','779',334,'Retail Sale Id 1270015',3001.60,0.00,0.00,0.00,272.02,'2021-12-03 14:33:33','',''),(2142114,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 14:33:33','',''),(2142223,'1','136','779',334,'Retail Sale Id 1270045',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 14:38:38','',''),(2142224,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 14:38:38','',''),(2142273,'1','136','779',334,'Retail Sale Id 1270055',120000.00,0.00,0.00,0.00,3600.00,'2021-12-03 14:41:02','',''),(2142274,'1','136','779',334,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-03 14:41:02','',''),(2142293,'1','136','779',334,'Retail Sale Id 1270073',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 14:41:45','',''),(2142294,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 14:41:45','',''),(2142349,'1','136','779',334,'Retail Sale Id 1270091',2502.40,0.00,0.00,0.00,226.78,'2021-12-03 14:43:46','',''),(2142350,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 14:43:46','',''),(2142563,'1','136','779',334,'Retail Sale Id 1270202',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 14:53:10','',''),(2142564,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 14:53:10','',''),(2142598,'1','136','779',334,'Retail Sale Id 1270216',7360.00,0.00,0.00,0.00,667.00,'2021-12-03 14:54:50','',''),(2142599,'1','136','779',334,'Retail sales',0.00,0.00,0.00,11.50,0.00,'2021-12-03 14:54:50','',''),(2142644,'1','136','779',334,'Retail Sale Id 1270228',3200.00,0.00,0.00,0.00,290.00,'2021-12-03 14:56:10','',''),(2142645,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 14:56:10','',''),(2142663,'1','136','779',334,'Retail Sale Id 1270239',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 14:57:05','',''),(2142664,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 14:57:05','',''),(2142672,'1','136','779',334,'Retail Sale Id 1270242',4000.00,0.00,0.00,0.00,362.50,'2021-12-03 14:57:59','',''),(2142673,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 14:57:59','',''),(2142695,'1','136','779',334,'Retail Sale Id 1270254',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 14:59:21','',''),(2142696,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 14:59:21','',''),(2142726,'1','136','779',334,'Retail Sale Id 1270271',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 15:01:24','',''),(2142727,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:01:24','',''),(2142912,'1','136','779',334,'Retail Sale Id 1270364',1497.60,0.00,0.00,0.00,135.72,'2021-12-03 15:12:25','',''),(2142913,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 15:12:25','',''),(2143020,'1','136','779',334,'Retail Sale Id 1270429',3200.00,0.00,0.00,0.00,290.00,'2021-12-03 15:17:12','',''),(2143021,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 15:17:12','',''),(2143057,'1','136','779',334,'Retail Sale Id 1270453',8998.40,0.00,0.00,0.00,815.48,'2021-12-03 15:19:18','',''),(2143058,'1','136','779',334,'Retail sales',0.00,0.00,0.00,14.06,0.00,'2021-12-03 15:19:18','',''),(2143086,'1','136','779',334,'Return of Retail Sale Id 1270453',0.00,8998.40,14.06,0.00,-815.48,'2021-12-03 15:20:27','',''),(2143097,'1','136','779',334,'Retail Sale Id 1270476',9120.00,0.00,0.00,0.00,826.50,'2021-12-03 15:21:04','',''),(2143098,'1','136','779',334,'Retail sales',0.00,0.00,0.00,14.25,0.00,'2021-12-03 15:21:04','',''),(2143127,'1','136','779',334,'Retail Sale Id 1270492',2003.20,0.00,0.00,0.00,181.54,'2021-12-03 15:22:34','',''),(2143128,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:22:34','',''),(2143135,'1','136','779',334,'Retail Sale Id 1270498',4998.40,0.00,0.00,0.00,452.98,'2021-12-03 15:23:28','',''),(2143136,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 15:23:28','',''),(2143423,'1','136','779',334,'Retail Sale Id 1270634',11200.00,0.00,0.00,0.00,1015.00,'2021-12-03 15:36:37','',''),(2143424,'1','136','779',334,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-03 15:36:37','',''),(2143433,'1','136','779',334,'Return of Retail Sale Id 1270634',0.00,11200.00,17.50,0.00,-1015.00,'2021-12-03 15:37:06','',''),(2143462,'1','136','779',334,'Retail Sale Id 1270654',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 15:38:10','',''),(2143463,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:38:10','',''),(2143712,'1','136','779',334,'Retail Sale Id 1270774',998.40,0.00,0.00,0.00,90.48,'2021-12-03 15:47:52','',''),(2143713,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 15:47:52','',''),(2144015,'1','136','779',334,'Retail Sale Id 1270924',8000.00,0.00,0.00,0.00,725.00,'2021-12-03 16:02:09','',''),(2144016,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:02:09','',''),(2144095,'1','136','779',334,'Retail Sale Id 1270972',6003.20,0.00,0.00,0.00,544.04,'2021-12-03 16:05:52','',''),(2144096,'1','136','779',334,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-03 16:05:52','',''),(2144206,'1','136','779',334,'Retail Sale Id 1271021',1299.20,0.00,0.00,0.00,117.74,'2021-12-03 16:10:13','',''),(2144207,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 16:10:13','',''),(2144230,'1','136','779',334,'Retail Sale Id 1271032',3001.60,0.00,0.00,0.00,272.02,'2021-12-03 16:11:21','',''),(2144231,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 16:11:21','',''),(2144512,'1','136','779',334,'Retail Sale Id 1271179',1401.60,0.00,0.00,0.00,127.02,'2021-12-03 16:26:43','',''),(2144513,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-03 16:26:43','',''),(2144671,'1','136','779',334,'Retail Sale Id 1271258',4998.40,0.00,0.00,0.00,452.98,'2021-12-03 16:35:21','',''),(2144672,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 16:35:21','',''),(2144716,'1','136','779',334,'Retail Sale Id 1271282',56400.00,0.00,0.00,0.00,1692.00,'2021-12-03 16:37:17','',''),(2144717,'1','136','779',334,'Retail sales',0.00,0.00,0.00,94.00,0.00,'2021-12-03 16:37:17','',''),(2144756,'1','136','779',334,'Return of Retail Sale Id 1271282',0.00,56400.00,94.00,0.00,-1692.00,'2021-12-03 16:39:17','',''),(2144789,'1','136','779',334,'Retail Sale Id 1271321',58998.00,0.00,0.00,0.00,1769.94,'2021-12-03 16:40:48','',''),(2144790,'1','136','779',334,'Retail sales',0.00,0.00,0.00,98.33,0.00,'2021-12-03 16:40:48','',''),(2145320,'1','136','779',334,'Retail Sale Id 1271557',24600.00,0.00,0.00,0.00,738.00,'2021-12-03 17:08:36','',''),(2145321,'1','136','779',334,'Retail sales',0.00,0.00,0.00,41.00,0.00,'2021-12-03 17:08:36','',''),(2145571,'1','136','779',334,'Retail Sale Id 1271692',16000.00,0.00,0.00,0.00,1450.00,'2021-12-03 17:39:22','',''),(2145572,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 17:39:22','',''),(2145744,'1','136','779',334,'Retail Sale Id 1271763',108537.00,0.00,0.00,0.00,2904.00,'2021-12-03 18:02:27','',''),(2145745,'1','136','779',334,'Retail sales',0.00,0.00,0.00,181.50,0.00,'2021-12-03 18:02:27','',''),(2146483,'1','136','779',334,'Retail Sale Id 1271943',1203.20,0.00,0.00,0.00,109.04,'2021-12-04 05:35:02','',''),(2146484,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-04 05:35:02','',''),(2146511,'1','136','779',334,'Retail Sale Id 1271959',1600.00,0.00,0.00,0.00,145.00,'2021-12-04 05:49:49','',''),(2146512,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-04 05:49:49','',''),(2146724,'1','136','779',334,'Retail Sale Id 1272027',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 06:16:24','',''),(2146725,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 06:16:24','',''),(2146768,'1','136','779',334,'Retail Sale Id 1272037',1299.20,0.00,0.00,0.00,117.74,'2021-12-04 06:18:50','',''),(2146769,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 06:18:50','',''),(2146787,'1','136','779',334,'Retail Sale Id 1272044',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 06:20:16','',''),(2146788,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 06:20:16','',''),(2146801,'1','136','779',334,'Retail Sale Id 1272049',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 06:21:14','',''),(2146802,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 06:21:14','',''),(2146914,'1','136','779',334,'Retail Sale Id 1272089',1600.00,0.00,0.00,0.00,145.00,'2021-12-04 06:26:52','',''),(2146915,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-04 06:26:52','',''),(2146986,'1','136','779',334,'Retail Sale Id 1272108',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 06:29:15','',''),(2146987,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:29:15','',''),(2147016,'1','136','779',334,'Retail Sale Id 1272123',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 06:31:01','',''),(2147017,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 06:31:01','',''),(2147024,'1','136','779',334,'Retail Sale Id 1272128',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 06:31:52','',''),(2147025,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 06:31:52','',''),(2147148,'1','136','779',334,'Retail Sale Id 1272186',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 06:39:04','',''),(2147149,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 06:39:04','',''),(2147176,'1','136','779',334,'Retail Sale Id 1272197',998.40,0.00,0.00,0.00,90.48,'2021-12-04 06:39:51','',''),(2147177,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 06:39:51','',''),(2147336,'1','136','779',334,'Retail Sale Id 1272266',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 06:48:48','',''),(2147337,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 06:48:48','',''),(2147382,'1','136','779',334,'Retail Sale Id 1272284',998.40,0.00,0.00,0.00,90.48,'2021-12-04 06:50:46','',''),(2147383,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 06:50:46','',''),(2147418,'1','136','779',334,'Retail Sale Id 1272303',22800.00,0.00,0.00,0.00,684.00,'2021-12-04 06:53:24','',''),(2147419,'1','136','779',334,'Retail sales',0.00,0.00,0.00,38.00,0.00,'2021-12-04 06:53:24','',''),(2147444,'1','136','779',334,'Retail Sale Id 1272315',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 06:54:15','',''),(2147445,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 06:54:15','',''),(2147463,'1','136','779',334,'Retail Sale Id 1272324',6400.00,0.00,0.00,0.00,580.00,'2021-12-04 06:55:09','',''),(2147464,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 06:55:09','',''),(2147500,'1','136','779',334,'Retail Sale Id 1272337',24000.00,0.00,0.00,0.00,720.00,'2021-12-04 06:56:47','',''),(2147501,'1','136','779',334,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-04 06:56:47','',''),(2147530,'1','136','779',334,'Retail Sale Id 1272354',1497.60,0.00,0.00,0.00,135.72,'2021-12-04 06:58:13','',''),(2147531,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 06:58:13','',''),(2147546,'1','136','779',334,'Retail Sale Id 1272362',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 06:59:08','',''),(2147547,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 06:59:08','',''),(2147570,'1','136','779',334,'Retail Sale Id 1272377',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 07:00:46','',''),(2147571,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:00:46','',''),(2147617,'1','136','779',334,'Retail Sale Id 1272396',2502.40,0.00,0.00,0.00,226.78,'2021-12-04 07:02:41','',''),(2147618,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 07:02:41','',''),(2147635,'1','136','779',334,'Retail Sale Id 1272405',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 07:04:03','',''),(2147636,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:04:03','',''),(2147701,'1','136','779',334,'Retail Sale Id 1272428',1600.00,0.00,0.00,0.00,145.00,'2021-12-04 07:07:28','',''),(2147702,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-04 07:07:28','',''),(2147736,'1','136','779',334,'Retail Sale Id 1272453',1299.20,0.00,0.00,0.00,117.74,'2021-12-04 07:10:11','',''),(2147737,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 07:10:11','',''),(2147768,'1','136','779',334,'Retail Sale Id 1272474',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 07:11:55','',''),(2147769,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 07:11:55','',''),(2147882,'1','136','779',334,'Retail Sale Id 1272543',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 07:17:34','',''),(2147883,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 07:17:34','',''),(2147940,'1','136','779',334,'Retail Sale Id 1272569',63000.00,0.00,0.00,0.00,1890.00,'2021-12-04 07:20:40','',''),(2147941,'1','136','779',334,'Retail sales',0.00,0.00,0.00,105.00,0.00,'2021-12-04 07:20:40','',''),(2148038,'1','136','779',334,'Retail Sale Id 1272624',16000.00,0.00,0.00,0.00,1450.00,'2021-12-04 07:25:44','',''),(2148039,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 07:25:44','',''),(2148074,'1','136','779',334,'Retail Sale Id 1272637',3500.80,0.00,0.00,0.00,317.26,'2021-12-04 07:27:24','',''),(2148075,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-04 07:27:24','',''),(2148098,'1','136','779',334,'Retail Sale Id 1272655',3200.00,0.00,0.00,0.00,290.00,'2021-12-04 07:28:36','',''),(2148099,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 07:28:36','',''),(2148144,'1','136','779',334,'Retail Sale Id 1272667',6400.00,0.00,0.00,0.00,580.00,'2021-12-04 07:30:47','',''),(2148145,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 07:30:47','',''),(2148178,'1','136','779',334,'Retail Sale Id 1272686',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 07:32:23','',''),(2148179,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:32:23','',''),(2148271,'1','136','779',334,'Retail Sale Id 1272748',210000.00,0.00,0.00,0.00,6300.00,'2021-12-04 07:36:46','',''),(2148272,'1','136','779',334,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-04 07:36:46','',''),(2148319,'1','136','779',334,'Retail Sale Id 1272775',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 07:38:57','',''),(2148320,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 07:38:57','',''),(2148349,'1','136','779',334,'Retail Sale Id 1272795',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 07:40:09','',''),(2148350,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 07:40:09','',''),(2148373,'1','136','779',334,'Retail Sale Id 1272807',998.40,0.00,0.00,0.00,90.48,'2021-12-04 07:41:25','',''),(2148374,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 07:41:25','',''),(2148402,'1','136','779',334,'Retail Sale Id 1272844',3200.00,0.00,0.00,0.00,290.00,'2021-12-04 07:42:52','',''),(2148403,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 07:42:52','',''),(2148422,'1','136','779',334,'Retail Sale Id 1272868',998.40,0.00,0.00,0.00,90.48,'2021-12-04 07:44:07','',''),(2148423,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 07:44:07','',''),(2148442,'1','136','779',334,'Retail Sale Id 1272885',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 07:45:18','',''),(2148443,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 07:45:18','',''),(2148464,'1','136','779',334,'Retail Sale Id 1272900',998.40,0.00,0.00,0.00,90.48,'2021-12-04 07:47:03','',''),(2148465,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 07:47:03','',''),(2148490,'1','136','779',334,'Retail Sale Id 1272916',998.40,0.00,0.00,0.00,90.48,'2021-12-04 07:48:35','',''),(2148491,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 07:48:35','',''),(2148513,'1','136','779',334,'Retail Sale Id 1272929',1497.60,0.00,0.00,0.00,135.72,'2021-12-04 07:49:37','',''),(2148514,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 07:49:37','',''),(2148531,'1','136','779',334,'Retail Sale Id 1272940',1497.60,0.00,0.00,0.00,135.72,'2021-12-04 07:51:01','',''),(2148532,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 07:51:01','',''),(2148574,'1','136','779',334,'Retail Sale Id 1272973',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 07:54:22','',''),(2148575,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:54:22','',''),(2148606,'1','136','779',334,'Retail Sale Id 1272982',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 07:55:56','',''),(2148607,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 07:55:56','',''),(2148626,'1','136','779',334,'Retail Sale Id 1273011',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 07:57:18','',''),(2148627,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:57:18','',''),(2148747,'1','136','779',334,'Retail Sale Id 1273067',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 08:02:28','',''),(2148748,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:02:28','',''),(2148845,'1','136','779',334,'Retail Sale Id 1273109',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 08:06:12','',''),(2148846,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 08:06:12','',''),(2148948,'1','136','779',334,'Retail Sale Id 1273186',209300.00,0.00,0.00,0.00,5600.00,'2021-12-04 08:11:22','',''),(2148949,'1','136','779',334,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-04 08:11:22','',''),(2149005,'1','136','779',334,'Retail Sale Id 1273209',1299.20,0.00,0.00,0.00,117.74,'2021-12-04 08:13:26','',''),(2149006,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 08:13:26','',''),(2149043,'1','136','779',334,'Retail Sale Id 1273226',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 08:14:44','',''),(2149044,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 08:14:44','',''),(2149071,'1','136','779',334,'Retail Sale Id 1273238',3200.00,0.00,0.00,0.00,290.00,'2021-12-04 08:15:40','',''),(2149072,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:15:40','',''),(2149113,'1','136','779',334,'Retail Sale Id 1273256',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 08:17:27','',''),(2149114,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:17:27','',''),(2149180,'1','136','779',334,'Retail Sale Id 1273279',30000.00,0.00,0.00,0.00,900.00,'2021-12-04 08:20:26','',''),(2149181,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 08:20:26','',''),(2149225,'1','136','779',334,'Retail Sale Id 1273371',30000.00,0.00,0.00,0.00,900.00,'2021-12-04 08:22:43','',''),(2149226,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 08:22:43','',''),(2149260,'1','136','779',334,'Retail Sale Id 1273392',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 08:24:03','',''),(2149261,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:24:03','',''),(2149282,'1','136','779',334,'Retail Sale Id 1273402',2598.40,0.00,0.00,0.00,235.48,'2021-12-04 08:25:02','',''),(2149283,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-04 08:25:02','',''),(2149304,'1','136','779',334,'Retail Sale Id 1273414',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 08:26:08','',''),(2149305,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:26:08','',''),(2149326,'1','136','779',334,'Retail Sale Id 1273422',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 08:27:18','',''),(2149327,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:27:18','',''),(2149350,'1','136','779',334,'Retail Sale Id 1273435',998.40,0.00,0.00,0.00,90.48,'2021-12-04 08:28:06','',''),(2149351,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 08:28:06','',''),(2149414,'1','136','779',334,'Retail Sale Id 1273469',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 08:30:32','',''),(2149415,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 08:30:32','',''),(2149442,'1','136','779',334,'Retail Sale Id 1273516',1497.60,0.00,0.00,0.00,135.72,'2021-12-04 08:31:36','',''),(2149443,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 08:31:36','',''),(2149566,'1','136','779',334,'Retail Sale Id 1273560',998.40,0.00,0.00,0.00,90.48,'2021-12-04 08:35:14','',''),(2149567,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 08:35:14','',''),(2149646,'1','136','779',334,'Retail Sale Id 1273598',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 08:37:54','',''),(2149647,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:37:54','',''),(2149760,'1','136','779',334,'Retail Sale Id 1273649',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 08:43:25','',''),(2149761,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:43:25','',''),(2149792,'1','136','779',334,'Retail Sale Id 1273671',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 08:44:36','',''),(2149793,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:44:36','',''),(2150069,'1','136','779',334,'Retail Sale Id 1273822',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 08:57:13','',''),(2150070,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:57:13','',''),(2150089,'1','136','779',334,'Retail Sale Id 1273832',998.40,0.00,0.00,0.00,90.48,'2021-12-04 08:58:15','',''),(2150090,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 08:58:15','',''),(2150207,'1','136','779',334,'Retail Sale Id 1273895',58200.00,0.00,0.00,0.00,1746.00,'2021-12-04 09:03:44','',''),(2150208,'1','136','779',334,'Retail sales',0.00,0.00,0.00,97.00,0.00,'2021-12-04 09:03:44','',''),(2150313,'1','136','779',334,'Retail Sale Id 1273954',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 09:09:08','',''),(2150314,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:09:08','',''),(2150337,'1','136','779',334,'Retail Sale Id 1273966',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 09:10:29','',''),(2150338,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 09:10:29','',''),(2150389,'1','136','779',334,'Retail Sale Id 1273986',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 09:13:08','',''),(2150390,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:13:08','',''),(2150463,'1','136','779',334,'Retail Sale Id 1274029',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 09:16:46','',''),(2150464,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:16:46','',''),(2150482,'1','136','779',334,'Retail Sale Id 1274042',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 09:17:43','',''),(2150483,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 09:17:43','',''),(2150507,'1','136','779',334,'Retail Sale Id 1274055',16000.00,0.00,0.00,0.00,1450.00,'2021-12-04 09:18:49','',''),(2150508,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 09:18:49','',''),(2150537,'1','136','779',334,'Retail Sale Id 1274068',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 09:19:52','',''),(2150538,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:19:52','',''),(2150565,'1','136','779',334,'Retail Sale Id 1274087',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 09:21:14','',''),(2150566,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 09:21:14','',''),(2150589,'1','136','779',334,'Retail Sale Id 1274100',998.40,0.00,0.00,0.00,90.48,'2021-12-04 09:22:18','',''),(2150590,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 09:22:18','',''),(2150625,'1','136','779',334,'Retail Sale Id 1274117',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 09:23:40','',''),(2150626,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 09:23:40','',''),(2150655,'1','136','779',334,'Retail Sale Id 1274132',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 09:26:02','',''),(2150656,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:26:02','',''),(2150814,'1','136','779',334,'Retail Sale Id 1274217',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 09:33:49','',''),(2150815,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:33:49','',''),(2150848,'1','136','779',334,'Retail Sale Id 1274234',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 09:35:00','',''),(2150849,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 09:35:00','',''),(2152385,'1','136','779',334,'Retail Sale Id 1274358',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 10:28:31','',''),(2152386,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 10:28:31','',''),(2152430,'1','136','779',334,'Retail Sale Id 1274382',1299.20,0.00,0.00,0.00,117.74,'2021-12-04 10:31:28','',''),(2152431,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 10:31:28','',''),(2152444,'1','136','779',334,'Retail Sale Id 1274384',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 10:32:14','',''),(2152445,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 10:32:14','',''),(2152571,'1','136','779',334,'Retail Sale Id 1274432',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 10:42:38','',''),(2152572,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 10:42:38','',''),(2152636,'1','136','779',334,'Retail Sale Id 1274454',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 10:46:12','',''),(2152637,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 10:46:12','',''),(2152660,'1','136','779',334,'Retail Sale Id 1274464',3200.00,0.00,0.00,0.00,290.00,'2021-12-04 10:47:46','',''),(2152661,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 10:47:46','',''),(2152809,'1','136','779',334,'Retail Sale Id 1274524',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 10:55:32','',''),(2152810,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 10:55:32','',''),(2153087,'1','136','779',334,'Retail Sale Id 1274662',1299.20,0.00,0.00,0.00,117.74,'2021-12-04 11:10:31','',''),(2153088,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 11:10:31','',''),(2153191,'1','136','779',334,'Retail Sale Id 1274712',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 11:15:35','',''),(2153192,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 11:15:35','',''),(2153221,'1','136','779',334,'Retail Sale Id 1274729',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 11:16:35','',''),(2153222,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 11:16:35','',''),(2153237,'1','136','779',334,'Retail Sale Id 1274738',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 11:17:19','',''),(2153238,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 11:17:19','',''),(2153327,'1','136','779',334,'Retail Sale Id 1274780',2598.40,0.00,0.00,0.00,235.48,'2021-12-04 11:21:48','',''),(2153328,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-04 11:21:48','',''),(2153333,'1','136','779',334,'Return of Retail Sale Id 1274780',0.00,2598.40,4.06,0.00,-235.48,'2021-12-04 11:22:01','',''),(2153338,'1','136','779',334,'Retail Sale Id 1274786',3200.00,0.00,0.00,0.00,290.00,'2021-12-04 11:22:33','',''),(2153339,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 11:22:33','',''),(2153356,'1','136','779',334,'Retail Sale Id 1274796',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 11:23:48','',''),(2153357,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:23:48','',''),(2153414,'1','136','779',334,'Retail Sale Id 1274830',150000.00,0.00,0.00,0.00,4500.00,'2021-12-04 11:27:50','',''),(2153415,'1','136','779',334,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-04 11:27:50','',''),(2153429,'1','136','779',334,'Retail Sale Id 1274839',150000.00,0.00,0.00,0.00,4500.00,'2021-12-04 11:28:29','',''),(2153430,'1','136','779',334,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-04 11:28:29','',''),(2153576,'1','136','779',334,'Retail Sale Id 1274910',3001.60,0.00,0.00,0.00,272.02,'2021-12-04 11:35:43','',''),(2153577,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 11:35:43','',''),(2153625,'1','136','779',334,'Retail Sale Id 1274932',998.40,0.00,0.00,0.00,90.48,'2021-12-04 11:37:44','',''),(2153626,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 11:37:44','',''),(2153703,'1','136','779',334,'Retail Sale Id 1274962',998.40,0.00,0.00,0.00,90.48,'2021-12-04 11:41:53','',''),(2153704,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 11:41:53','',''),(2153727,'1','136','779',334,'Retail Sale Id 1274975',36000.00,0.00,0.00,0.00,1080.00,'2021-12-04 11:43:59','',''),(2153728,'1','136','779',334,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-04 11:43:59','',''),(2153747,'1','136','779',334,'Retail Sale Id 1274982',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 11:44:47','',''),(2153748,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 11:44:47','',''),(2153782,'1','136','779',334,'Retail Sale Id 1274999',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 11:46:38','',''),(2153783,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 11:46:38','',''),(2153893,'1','136','779',334,'Retail Sale Id 1275044',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 11:52:49','',''),(2153894,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 11:52:49','',''),(2153919,'1','136','779',334,'Retail Sale Id 1275053',3200.00,0.00,0.00,0.00,290.00,'2021-12-04 11:54:03','',''),(2153920,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 11:54:03','',''),(2154043,'1','136','779',334,'Retail Sale Id 1275090',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 12:00:02','',''),(2154044,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 12:00:02','',''),(2154184,'1','136','779',334,'Retail Sale Id 1275121',2502.40,0.00,0.00,0.00,226.78,'2021-12-04 12:04:44','',''),(2154185,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 12:04:44','',''),(2154232,'1','136','779',334,'Retail Sale Id 1275147',3200.00,0.00,0.00,0.00,290.00,'2021-12-04 12:08:00','',''),(2154233,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 12:08:00','',''),(2154244,'1','136','779',334,'Retail Sale Id 1275153',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 12:08:57','',''),(2154245,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 12:08:57','',''),(2154266,'1','136','779',334,'Retail Sale Id 1275163',1497.60,0.00,0.00,0.00,135.72,'2021-12-04 12:09:39','',''),(2154267,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 12:09:39','',''),(2154283,'1','136','779',334,'Retail Sale Id 1275172',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 12:10:51','',''),(2154284,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:10:51','',''),(2154321,'1','136','779',334,'Retail Sale Id 1275192',6400.00,0.00,0.00,0.00,580.00,'2021-12-04 12:13:17','',''),(2154322,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 12:13:17','',''),(2154417,'1','136','779',334,'Retail Sale Id 1275244',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 12:20:32','',''),(2154418,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 12:20:32','',''),(2154429,'1','136','779',334,'Retail Sale Id 1275251',998.40,0.00,0.00,0.00,90.48,'2021-12-04 12:21:30','',''),(2154430,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 12:21:30','',''),(2154569,'1','136','779',334,'Retail Sale Id 1275318',4998.40,0.00,0.00,0.00,452.98,'2021-12-04 12:29:24','',''),(2154570,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 12:29:24','',''),(2154641,'1','136','779',334,'Retail Sale Id 1275171',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 12:32:55','',''),(2154642,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 12:32:55','',''),(2154760,'1','136','779',334,'Retail Sale Id 1275414',3001.60,0.00,0.00,0.00,272.02,'2021-12-04 12:40:28','',''),(2154761,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 12:40:28','',''),(2154768,'1','136','779',334,'Retail Sale Id 1275419',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 12:41:25','',''),(2154769,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 12:41:25','',''),(2154784,'1','136','779',334,'Retail Sale Id 1275427',1299.20,0.00,0.00,0.00,117.74,'2021-12-04 12:42:47','',''),(2154785,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 12:42:47','',''),(2154804,'1','136','779',334,'Retail Sale Id 1275439',2598.40,0.00,0.00,0.00,235.48,'2021-12-04 12:44:54','',''),(2154805,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-04 12:44:54','',''),(2154845,'1','136','779',334,'Retail Sale Id 1275456',120000.00,0.00,0.00,0.00,3600.00,'2021-12-04 12:48:07','',''),(2154846,'1','136','779',334,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-04 12:48:07','',''),(2154952,'1','136','779',334,'Retail Sale Id 1275497',3500.80,0.00,0.00,0.00,317.26,'2021-12-04 12:53:54','',''),(2154953,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-04 12:53:54','',''),(2154968,'1','136','779',334,'Retail Sale Id 1275506',998.40,0.00,0.00,0.00,90.48,'2021-12-04 12:54:45','',''),(2154969,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 12:54:45','',''),(2155029,'1','136','779',334,'Retail Sale Id 1275739',331890.00,0.00,0.00,0.00,8880.00,'2021-12-04 13:05:26','',''),(2155030,'1','136','779',334,'Retail sales',0.00,0.00,0.00,555.00,0.00,'2021-12-04 13:05:26','',''),(2155079,'1','136','779',334,'Retail Sale Id 1275778',1798.40,0.00,0.00,0.00,162.98,'2021-12-04 13:08:57','',''),(2155080,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-04 13:08:57','',''),(2155694,'1','136','779',334,'Retail Sale Id 1276031',20400.00,0.00,0.00,0.00,612.00,'2021-12-04 13:42:03','',''),(2155695,'1','136','779',334,'Retail sales',0.00,0.00,0.00,34.00,0.00,'2021-12-04 13:42:03','',''),(2155720,'1','136','779',334,'Retail Sale Id 1276045',1299.20,0.00,0.00,0.00,117.74,'2021-12-04 13:43:22','',''),(2155721,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 13:43:22','',''),(2155776,'1','136','779',334,'Retail Sale Id 1276074',800.00,0.00,0.00,0.00,72.50,'2021-12-04 13:46:41','',''),(2155777,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-04 13:46:41','',''),(2156307,'1','136','779',334,'Retail Sale Id 1276302',45000.00,0.00,0.00,0.00,1350.00,'2021-12-04 14:09:50','',''),(2156308,'1','136','779',334,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-04 14:09:50','',''),(2156981,'1','136','779',334,'Retail Sale Id 1276609',33000.00,0.00,0.00,0.00,990.00,'2021-12-04 14:44:32','',''),(2156982,'1','136','779',334,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-04 14:44:32','',''),(2157584,'1','136','779',334,'Retail Sale Id 1276861',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 15:15:23','',''),(2157585,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 15:15:23','',''),(2157646,'1','136','779',334,'Retail Sale Id 1276883',60000.00,0.00,0.00,0.00,1800.00,'2021-12-04 15:18:40','',''),(2157647,'1','136','779',334,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-04 15:18:40','',''),(2157672,'1','136','779',334,'Retail Sale Id 1276895',998.40,0.00,0.00,0.00,90.48,'2021-12-04 15:19:21','',''),(2157673,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 15:19:21','',''),(2157740,'1','136','779',334,'Retail Sale Id 1276922',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 15:22:46','',''),(2157741,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 15:22:46','',''),(2157826,'1','136','779',334,'Retail Sale Id 1276961',30000.00,0.00,0.00,0.00,900.00,'2021-12-04 15:26:30','',''),(2157827,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 15:26:30','',''),(2157879,'1','136','779',334,'Retail Sale Id 1276982',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 15:28:08','',''),(2157880,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 15:28:08','',''),(2157917,'1','136','779',334,'Retail Sale Id 1276999',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 15:29:55','',''),(2157918,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 15:29:55','',''),(2157927,'1','136','779',334,'Retail Sale Id 1277007',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 15:30:43','',''),(2157928,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 15:30:43','',''),(2157947,'1','136','779',334,'Retail Sale Id 1277017',15000.00,0.00,0.00,0.00,450.00,'2021-12-04 15:31:30','',''),(2157948,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 15:31:30','',''),(2157971,'1','136','779',334,'Retail Sale Id 1277032',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 15:32:45','',''),(2157972,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:32:45','',''),(2158072,'1','136','779',334,'Retail Sale Id 1277078',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 15:37:22','',''),(2158073,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:37:22','',''),(2158116,'1','136','779',334,'Retail Sale Id 1277099',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 15:40:02','',''),(2158117,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 15:40:02','',''),(2158152,'1','136','779',334,'Retail Sale Id 1277114',1600.00,0.00,0.00,0.00,145.00,'2021-12-04 15:41:39','',''),(2158153,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-04 15:41:39','',''),(2158170,'1','136','779',334,'Retail Sale Id 1277126',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 15:42:31','',''),(2158171,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 15:42:31','',''),(2158238,'1','136','779',334,'Retail Sale Id 1277155',21600.00,0.00,0.00,0.00,648.00,'2021-12-04 15:45:22','',''),(2158239,'1','136','779',334,'Retail sales',0.00,0.00,0.00,36.00,0.00,'2021-12-04 15:45:22','',''),(2158252,'1','136','779',334,'Retail Sale Id 1277162',998.40,0.00,0.00,0.00,90.48,'2021-12-04 15:46:04','',''),(2158253,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 15:46:04','',''),(2158266,'1','136','779',334,'Retail Sale Id 1277168',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 15:46:56','',''),(2158267,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 15:46:56','',''),(2158344,'1','136','779',334,'Retail Sale Id 1277201',800.00,0.00,0.00,0.00,72.50,'2021-12-04 15:50:26','',''),(2158345,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-04 15:50:26','',''),(2158410,'1','136','779',334,'Retail Sale Id 1277235',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 15:53:47','',''),(2158411,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 15:53:47','',''),(2158426,'1','136','779',334,'Retail Sale Id 1277243',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 15:54:37','',''),(2158427,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:54:37','',''),(2158448,'1','136','779',334,'Retail Sale Id 1277260',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 15:55:36','',''),(2158449,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 15:55:36','',''),(2158474,'1','136','779',334,'Retail Sale Id 1277275',3001.60,0.00,0.00,0.00,272.02,'2021-12-04 15:56:41','',''),(2158475,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 15:56:41','',''),(2158553,'1','136','779',334,'Retail Sale Id 1277324',3200.00,0.00,0.00,0.00,290.00,'2021-12-04 16:00:34','',''),(2158554,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:00:34','',''),(2158608,'1','136','779',334,'Retail Sale Id 1277350',30000.00,0.00,0.00,0.00,900.00,'2021-12-04 16:02:35','',''),(2158609,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 16:02:35','',''),(2158660,'1','136','779',334,'Retail Sale Id 1277378',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 16:06:17','',''),(2158661,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 16:06:17','',''),(2158694,'1','136','779',334,'Retail Sale Id 1277393',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 16:07:46','',''),(2158695,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:07:46','',''),(2158720,'1','136','779',334,'Retail Sale Id 1277407',30000.00,0.00,0.00,0.00,900.00,'2021-12-04 16:08:58','',''),(2158721,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 16:08:58','',''),(2158749,'1','136','779',334,'Retail Sale Id 1277421',30000.00,0.00,0.00,0.00,900.00,'2021-12-04 16:10:13','',''),(2158750,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 16:10:13','',''),(2158785,'1','136','779',334,'Retail Sale Id 1277444',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 16:12:06','',''),(2158786,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:12:06','',''),(2158841,'1','136','779',334,'Retail Sale Id 1277472',60000.00,0.00,0.00,0.00,1800.00,'2021-12-04 16:14:16','',''),(2158842,'1','136','779',334,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-04 16:14:16','',''),(2158931,'1','136','779',334,'Retail Sale Id 1277521',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 16:18:38','',''),(2158932,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:18:38','',''),(2158953,'1','136','779',334,'Retail Sale Id 1277530',1600.00,0.00,0.00,0.00,145.00,'2021-12-04 16:19:48','',''),(2158954,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-04 16:19:48','',''),(2158979,'1','136','779',334,'Retail Sale Id 1277544',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 16:21:18','',''),(2158980,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 16:21:18','',''),(2159051,'1','136','779',334,'Retail Sale Id 1277586',3897.60,0.00,0.00,0.00,353.22,'2021-12-04 16:24:09','',''),(2159052,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 16:24:09','',''),(2159157,'1','136','779',334,'Retail Sale Id 1277642',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 16:28:29','',''),(2159158,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 16:28:29','',''),(2159255,'1','136','779',334,'Retail Sale Id 1277685',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 16:33:20','',''),(2159256,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 16:33:20','',''),(2159281,'1','136','779',334,'Retail Sale Id 1277698',30000.00,0.00,0.00,0.00,900.00,'2021-12-04 16:35:01','',''),(2159282,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 16:35:01','',''),(2159297,'1','136','779',334,'Retail Sale Id 1277710',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 16:36:07','',''),(2159298,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 16:36:07','',''),(2159309,'1','136','779',334,'Retail Sale Id 1277714',3001.60,0.00,0.00,0.00,272.02,'2021-12-04 16:36:54','',''),(2159310,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 16:36:54','',''),(2159333,'1','136','779',334,'Retail Sale Id 1277727',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 16:37:40','',''),(2159334,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 16:37:40','',''),(2159344,'1','136','779',334,'Retail Sale Id 1277732',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 16:38:19','',''),(2159345,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 16:38:19','',''),(2159427,'1','136','779',334,'Retail Sale Id 1277753',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 16:40:09','',''),(2159428,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 16:40:09','',''),(2159497,'1','136','779',334,'Retail Sale Id 1277829',3200.00,0.00,0.00,0.00,290.00,'2021-12-04 16:44:18','',''),(2159498,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:44:18','',''),(2159628,'1','136','779',334,'Retail Sale Id 1277891',6003.20,0.00,0.00,0.00,544.04,'2021-12-04 16:50:21','',''),(2159629,'1','136','779',334,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-04 16:50:21','',''),(2159690,'1','136','779',334,'Retail Sale Id 1277918',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 16:53:05','',''),(2159691,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 16:53:05','',''),(2159714,'1','136','779',334,'Retail Sale Id 1277931',3200.00,0.00,0.00,0.00,290.00,'2021-12-04 16:54:33','',''),(2159715,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:54:33','',''),(2159736,'1','136','779',334,'Retail Sale Id 1277941',1299.20,0.00,0.00,0.00,117.74,'2021-12-04 16:56:00','',''),(2159737,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 16:56:00','',''),(2159753,'1','136','779',334,'Retail Sale Id 1277950',149799.00,0.00,0.00,0.00,4008.00,'2021-12-04 16:57:17','',''),(2159754,'1','136','779',334,'Retail sales',0.00,0.00,0.00,250.50,0.00,'2021-12-04 16:57:17','',''),(2159775,'1','136','779',334,'Retail Sale Id 1277962',1299.20,0.00,0.00,0.00,117.74,'2021-12-04 16:58:37','',''),(2159776,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 16:58:37','',''),(2159799,'1','136','779',334,'Retail Sale Id 1277976',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 16:59:51','',''),(2159800,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 16:59:51','',''),(2159839,'1','136','779',334,'Retail Sale Id 1277989',12000.00,0.00,0.00,0.00,1087.50,'2021-12-04 17:01:35','',''),(2159840,'1','136','779',334,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-04 17:01:35','',''),(2159859,'1','136','779',334,'Retail Sale Id 1278000',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 17:02:45','',''),(2159860,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 17:02:45','',''),(2159903,'1','136','779',334,'Retail Sale Id 1278024',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 17:05:46','',''),(2159904,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 17:05:46','',''),(2159925,'1','136','779',334,'Return of Retail Sale Id 1277989',0.00,12000.00,18.75,0.00,-1087.50,'2021-12-04 17:07:15','',''),(2159944,'1','136','779',334,'Retail Sale Id 1278046',12000.00,0.00,0.00,0.00,360.00,'2021-12-04 17:08:20','',''),(2159945,'1','136','779',334,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-04 17:08:20','',''),(2160063,'1','136','779',334,'Retail Sale Id 1278104',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 17:16:46','',''),(2160064,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 17:16:46','',''),(2160123,'1','136','779',334,'Retail Sale Id 1278132',6003.20,0.00,0.00,0.00,544.04,'2021-12-04 17:20:32','',''),(2160124,'1','136','779',334,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-04 17:20:32','',''),(2160145,'1','136','779',334,'Retail Sale Id 1278146',8000.00,0.00,0.00,0.00,725.00,'2021-12-04 17:21:40','',''),(2160146,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 17:21:40','',''),(2160199,'1','136','779',334,'Retail Sale Id 1278169',4000.00,0.00,0.00,0.00,362.50,'2021-12-04 17:24:08','',''),(2160200,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 17:24:08','',''),(2160381,'1','136','779',334,'Retail Sale Id 1278233',367500.00,0.00,0.00,0.00,11025.00,'2021-12-04 17:35:43','',''),(2160382,'1','136','779',334,'Retail sales',0.00,0.00,0.00,612.50,0.00,'2021-12-04 17:35:43','',''),(2160417,'1','136','779',334,'Retail Sale Id 1278253',2003.20,0.00,0.00,0.00,181.54,'2021-12-04 17:38:19','',''),(2160418,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 17:38:19','',''),(2160925,'1','136','779',334,'Retail Sale Id 1278452',27564.80,0.00,0.00,0.00,2498.06,'2021-12-04 18:19:35','',''),(2160926,'1','136','779',334,'Retail sales',0.00,0.00,0.00,43.07,0.00,'2021-12-04 18:19:35','',''),(2161967,'1','136','779',334,'Retail Sale Id 1278624',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 06:01:04','',''),(2161968,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 06:01:04','',''),(2161973,'1','136','779',334,'Retail Sale Id 1278627',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 06:02:28','',''),(2161974,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 06:02:28','',''),(2162012,'1','136','779',334,'Retail Sale Id 1278646',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 06:06:33','',''),(2162013,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 06:06:33','',''),(2162070,'1','136','779',334,'Retail Sale Id 1278672',3500.80,0.00,0.00,0.00,317.26,'2021-12-05 06:13:35','',''),(2162071,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-05 06:13:35','',''),(2162101,'1','136','779',334,'Retail Sale Id 1278688',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 06:18:17','',''),(2162102,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 06:18:17','',''),(2162131,'1','136','779',334,'Retail Sale Id 1278701',4800.00,0.00,0.00,0.00,435.00,'2021-12-05 06:20:47','',''),(2162132,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.50,0.00,'2021-12-05 06:20:47','',''),(2162164,'1','136','779',334,'Retail Sale Id 1278718',1497.60,0.00,0.00,0.00,135.72,'2021-12-05 06:24:29','',''),(2162165,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 06:24:29','',''),(2162334,'1','136','779',334,'Retail Sale Id 1278792',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 06:39:08','',''),(2162335,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 06:39:08','',''),(2162404,'1','136','779',334,'Retail Sale Id 1278829',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 06:43:50','',''),(2162405,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 06:43:50','',''),(2162448,'1','136','779',334,'Retail Sale Id 1278837',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 06:44:44','',''),(2162449,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 06:44:44','',''),(2162516,'1','136','779',334,'Retail Sale Id 1278872',2598.40,0.00,0.00,0.00,235.48,'2021-12-05 06:49:42','',''),(2162517,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-05 06:49:42','',''),(2162553,'1','136','779',334,'Retail Sale Id 1278887',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 06:50:58','',''),(2162554,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 06:50:58','',''),(2162603,'1','136','779',334,'Retail Sale Id 1278915',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 06:53:56','',''),(2162604,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 06:53:56','',''),(2162643,'1','136','779',334,'Retail Sale Id 1278940',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 06:56:12','',''),(2162644,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 06:56:12','',''),(2162673,'1','136','779',334,'Retail Sale Id 1278958',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 06:57:33','',''),(2162674,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 06:57:33','',''),(2162732,'1','136','779',334,'Retail Sale Id 1278982',3001.60,0.00,0.00,0.00,272.02,'2021-12-05 07:01:40','',''),(2162733,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 07:01:40','',''),(2162784,'1','136','779',334,'Retail Sale Id 1279012',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 07:04:01','',''),(2162785,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 07:04:01','',''),(2162807,'1','136','779',334,'Retail Sale Id 1279021',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 07:05:17','',''),(2162808,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:05:17','',''),(2162905,'1','136','779',334,'Retail Sale Id 1279073',1900.80,0.00,0.00,0.00,172.26,'2021-12-05 07:10:51','',''),(2162906,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-05 07:10:51','',''),(2162925,'1','136','779',334,'Retail Sale Id 1279086',2099.20,0.00,0.00,0.00,190.24,'2021-12-05 07:11:56','',''),(2162926,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.28,0.00,'2021-12-05 07:11:56','',''),(2162947,'1','136','779',334,'Retail Sale Id 1279095',2598.40,0.00,0.00,0.00,235.48,'2021-12-05 07:13:02','',''),(2162948,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-05 07:13:02','',''),(2162963,'1','136','779',334,'Retail Sale Id 1279107',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 07:13:54','',''),(2162964,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 07:13:54','',''),(2162985,'1','136','779',334,'Retail Sale Id 1279116',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 07:14:58','',''),(2162986,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 07:14:58','',''),(2163009,'1','136','779',334,'Retail Sale Id 1279129',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 07:16:27','',''),(2163010,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:16:27','',''),(2163094,'1','136','779',334,'Retail Sale Id 1279174',1497.60,0.00,0.00,0.00,135.72,'2021-12-05 07:22:03','',''),(2163095,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 07:22:03','',''),(2163116,'1','136','779',334,'Retail Sale Id 1279210',7040.00,0.00,0.00,0.00,638.00,'2021-12-05 07:23:54','',''),(2163117,'1','136','779',334,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-05 07:23:54','',''),(2163140,'1','136','779',334,'Retail Sale Id 1279226',3500.80,0.00,0.00,0.00,317.26,'2021-12-05 07:25:03','',''),(2163141,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-05 07:25:03','',''),(2163165,'1','136','779',334,'Retail Sale Id 1279239',1299.20,0.00,0.00,0.00,117.74,'2021-12-05 07:26:07','',''),(2163166,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 07:26:07','',''),(2163187,'1','136','779',334,'Retail Sale Id 1279259',2598.40,0.00,0.00,0.00,235.48,'2021-12-05 07:27:14','',''),(2163188,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-05 07:27:14','',''),(2163240,'1','136','779',334,'Retail Sale Id 1279286',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 07:30:07','',''),(2163241,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 07:30:07','',''),(2163294,'1','136','779',334,'Retail Sale Id 1279322',1497.60,0.00,0.00,0.00,135.72,'2021-12-05 07:34:35','',''),(2163295,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 07:34:35','',''),(2163314,'1','136','779',334,'Retail Sale Id 1279333',1299.20,0.00,0.00,0.00,117.74,'2021-12-05 07:35:48','',''),(2163315,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 07:35:48','',''),(2163330,'1','136','779',334,'Retail Sale Id 1279340',998.40,0.00,0.00,0.00,90.48,'2021-12-05 07:36:42','',''),(2163331,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 07:36:42','',''),(2163346,'1','136','779',334,'Retail Sale Id 1279348',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 07:37:35','',''),(2163347,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 07:37:35','',''),(2163395,'1','136','779',334,'Retail Sale Id 1279383',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 07:39:30','',''),(2163396,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 07:39:30','',''),(2163419,'1','136','779',334,'Retail Sale Id 1279394',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 07:40:28','',''),(2163420,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 07:40:28','',''),(2163451,'1','136','779',334,'Retail Sale Id 1279412',4998.40,0.00,0.00,0.00,452.98,'2021-12-05 07:42:53','',''),(2163452,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 07:42:53','',''),(2163526,'1','136','779',334,'Retail Sale Id 1279453',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 07:47:18','',''),(2163527,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 07:47:18','',''),(2163550,'1','136','779',334,'Retail Sale Id 1279466',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 07:48:28','',''),(2163551,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 07:48:28','',''),(2163647,'1','136','779',334,'Retail Sale Id 1279499',27000.00,0.00,0.00,0.00,810.00,'2021-12-05 07:53:02','',''),(2163648,'1','136','779',334,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-05 07:53:02','',''),(2163687,'1','136','779',334,'Retail Sale Id 1279529',24000.00,0.00,0.00,0.00,720.00,'2021-12-05 07:55:38','',''),(2163688,'1','136','779',334,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-05 07:55:38','',''),(2163715,'1','136','779',334,'Retail Sale Id 1279538',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 07:57:14','',''),(2163716,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 07:57:14','',''),(2163736,'1','136','779',334,'Retail Sale Id 1279548',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 07:58:29','',''),(2163737,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 07:58:29','',''),(2163752,'1','136','779',334,'Retail Sale Id 1279560',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 07:59:42','',''),(2163753,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:59:42','',''),(2163770,'1','136','779',334,'Retail Sale Id 1279571',3001.60,0.00,0.00,0.00,272.02,'2021-12-05 08:00:35','',''),(2163771,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 08:00:35','',''),(2163786,'1','136','779',334,'Retail Sale Id 1279579',998.40,0.00,0.00,0.00,90.48,'2021-12-05 08:01:24','',''),(2163787,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 08:01:25','',''),(2163813,'1','136','779',334,'Retail Sale Id 1279592',1900.80,0.00,0.00,0.00,172.26,'2021-12-05 08:03:04','',''),(2163814,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-05 08:03:04','',''),(2163844,'1','136','779',334,'Retail Sale Id 1279617',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 08:04:46','',''),(2163845,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:04:46','',''),(2163868,'1','136','779',334,'Retail Sale Id 1279628',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 08:05:43','',''),(2163869,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:05:43','',''),(2163888,'1','136','779',334,'Retail Sale Id 1279640',998.40,0.00,0.00,0.00,90.48,'2021-12-05 08:06:38','',''),(2163889,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 08:06:38','',''),(2163908,'1','136','779',334,'Retail Sale Id 1279661',998.40,0.00,0.00,0.00,90.48,'2021-12-05 08:07:54','',''),(2163909,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 08:07:54','',''),(2163946,'1','136','779',334,'Retail Sale Id 1279675',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 08:09:20','',''),(2163947,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 08:09:20','',''),(2163970,'1','136','779',334,'Retail Sale Id 1279688',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 08:10:16','',''),(2163971,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:10:16','',''),(2163992,'1','136','779',334,'Retail Sale Id 1279705',1299.20,0.00,0.00,0.00,117.74,'2021-12-05 08:11:29','',''),(2163993,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 08:11:29','',''),(2164076,'1','136','779',334,'Retail Sale Id 1279757',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 08:16:42','',''),(2164077,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 08:16:42','',''),(2164190,'1','136','779',334,'Retail Sale Id 1279815',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 08:22:02','',''),(2164191,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 08:22:02','',''),(2164210,'1','136','779',334,'Retail Sale Id 1279824',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 08:22:56','',''),(2164211,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:22:56','',''),(2164264,'1','136','779',334,'Retail Sale Id 1279839',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 08:24:15','',''),(2164265,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:24:15','',''),(2164278,'1','136','779',334,'Retail Sale Id 1279846',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 08:25:17','',''),(2164279,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 08:25:17','',''),(2164302,'1','136','779',334,'Retail Sale Id 1279867',1497.60,0.00,0.00,0.00,135.72,'2021-12-05 08:26:29','',''),(2164303,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 08:26:29','',''),(2164340,'1','136','779',334,'Retail Sale Id 1279893',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 08:28:01','',''),(2164341,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 08:28:01','',''),(2164354,'1','136','779',334,'Retail Sale Id 1279900',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 08:28:49','',''),(2164355,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:28:49','',''),(2164378,'1','136','779',334,'Retail Sale Id 1279912',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 08:30:13','',''),(2164379,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 08:30:13','',''),(2164480,'1','136','779',334,'Retail Sale Id 1279951',20800.00,0.00,0.00,0.00,1885.00,'2021-12-05 08:35:02','',''),(2164481,'1','136','779',334,'Retail sales',0.00,0.00,0.00,32.50,0.00,'2021-12-05 08:35:02','',''),(2164512,'1','136','779',334,'Retail Sale Id 1279984',21000.00,0.00,0.00,0.00,630.00,'2021-12-05 08:36:56','',''),(2164513,'1','136','779',334,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-05 08:36:56','',''),(2164632,'1','136','779',334,'Retail Sale Id 1280035',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 08:43:23','',''),(2164633,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:43:23','',''),(2164717,'1','136','779',334,'Retail Sale Id 1280071',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 08:47:55','',''),(2164718,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:47:55','',''),(2164755,'1','136','779',334,'Retail Sale Id 1280092',2598.40,0.00,0.00,0.00,235.48,'2021-12-05 08:50:14','',''),(2164756,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-05 08:50:14','',''),(2164775,'1','136','779',334,'Retail Sale Id 1280103',7200.00,0.00,0.00,0.00,652.50,'2021-12-05 08:51:26','',''),(2164776,'1','136','779',334,'Retail sales',0.00,0.00,0.00,11.25,0.00,'2021-12-05 08:51:26','',''),(2164813,'1','136','779',334,'Retail Sale Id 1280122',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 08:53:21','',''),(2164814,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:53:21','',''),(2165033,'1','136','779',334,'Retail Sale Id 1280242',1600.00,0.00,0.00,0.00,145.00,'2021-12-05 09:05:35','',''),(2165034,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-05 09:05:35','',''),(2165047,'1','136','779',334,'Retail Sale Id 1280252',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 09:06:51','',''),(2165048,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 09:06:51','',''),(2165085,'1','136','779',334,'Retail Sale Id 1280274',7001.60,0.00,0.00,0.00,634.52,'2021-12-05 09:08:18','',''),(2165086,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-05 09:08:18','',''),(2165111,'1','136','779',334,'Retail Sale Id 1280291',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 09:09:22','',''),(2165112,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:09:22','',''),(2165129,'1','136','779',334,'Retail Sale Id 1280301',3500.80,0.00,0.00,0.00,317.26,'2021-12-05 09:10:19','',''),(2165130,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-05 09:10:19','',''),(2165177,'1','136','779',334,'Retail Sale Id 1280323',30000.00,0.00,0.00,0.00,900.00,'2021-12-05 09:12:26','',''),(2165178,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 09:12:26','',''),(2165209,'1','136','779',334,'Retail Sale Id 1280340',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 09:13:50','',''),(2165210,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 09:13:50','',''),(2165231,'1','136','779',334,'Return of Retail Sale Id 1280274',0.00,7001.60,10.94,0.00,-634.52,'2021-12-05 09:15:42','',''),(2165240,'1','136','779',334,'Retail Sale Id 1280375',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 09:17:06','',''),(2165241,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 09:17:06','',''),(2165266,'1','136','779',334,'Retail Sale Id 1280398',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 09:18:23','',''),(2165267,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 09:18:23','',''),(2165296,'1','136','779',334,'Retail Sale Id 1280413',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 09:20:00','',''),(2165297,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 09:20:00','',''),(2165356,'1','136','779',334,'Retail Sale Id 1280446',1497.60,0.00,0.00,0.00,135.72,'2021-12-05 09:23:56','',''),(2165357,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 09:23:56','',''),(2165442,'1','136','779',334,'Retail Sale Id 1280497',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 09:28:03','',''),(2165443,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 09:28:03','',''),(2165476,'1','136','779',334,'Retail Sale Id 1280516',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 09:29:36','',''),(2165477,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 09:29:36','',''),(2165502,'1','136','779',334,'Retail Sale Id 1280537',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 09:31:08','',''),(2165503,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 09:31:08','',''),(2165734,'1','136','779',334,'Retail Sale Id 1280652',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 09:42:54','',''),(2165737,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 09:42:54','',''),(2165764,'1','136','779',334,'Retail Sale Id 1280666',1798.40,0.00,0.00,0.00,162.98,'2021-12-05 09:43:54','',''),(2165765,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-05 09:43:54','',''),(2165801,'1','136','779',334,'Retail Sale Id 1280675',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 09:44:53','',''),(2165802,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 09:44:53','',''),(2165850,'1','136','779',334,'Retail Sale Id 1280693',1497.60,0.00,0.00,0.00,135.72,'2021-12-05 09:46:32','',''),(2165851,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 09:46:32','',''),(2165915,'1','136','779',334,'Retail Sale Id 1280711',1600.00,0.00,0.00,0.00,145.00,'2021-12-05 09:48:24','',''),(2165916,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-05 09:48:24','',''),(2165945,'1','136','779',334,'Retail Sale Id 1280729',3852.80,0.00,0.00,0.00,349.16,'2021-12-05 09:50:15','',''),(2165946,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 09:50:15','',''),(2165967,'1','136','779',334,'Retail Sale Id 1280738',998.40,0.00,0.00,0.00,90.48,'2021-12-05 09:51:54','',''),(2165968,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 09:51:54','',''),(2166023,'1','136','779',334,'Retail Sale Id 1280766',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 09:54:41','',''),(2166024,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 09:54:41','',''),(2166183,'1','136','779',334,'Retail Sale Id 1280852',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 10:04:34','',''),(2166184,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 10:04:34','',''),(2166211,'1','136','779',334,'Retail Sale Id 1280864',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 10:06:55','',''),(2166212,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 10:06:55','',''),(2166219,'1','136','779',334,'Retail Sale Id 1280873',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 10:07:54','',''),(2166220,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 10:07:54','',''),(2166259,'1','136','779',334,'Retail Sale Id 1280891',72000.00,0.00,0.00,0.00,2160.00,'2021-12-05 10:10:21','',''),(2166260,'1','136','779',334,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-05 10:10:21','',''),(2166297,'1','136','779',334,'Retail Sale Id 1280910',2598.40,0.00,0.00,0.00,235.48,'2021-12-05 10:12:53','',''),(2166298,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-05 10:12:53','',''),(2166357,'1','136','779',334,'Retail Sale Id 1280944',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 10:16:41','',''),(2166358,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 10:16:41','',''),(2166413,'1','136','779',334,'Retail Sale Id 1280971',1497.60,0.00,0.00,0.00,135.72,'2021-12-05 10:20:24','',''),(2166414,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 10:20:24','',''),(2166433,'1','136','779',334,'Retail Sale Id 1280981',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 10:21:24','',''),(2166434,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 10:21:24','',''),(2166469,'1','136','779',334,'Retail Sale Id 1281000',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 10:24:05','',''),(2166470,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 10:24:05','',''),(2166490,'1','136','779',334,'Retail Sale Id 1281009',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 10:25:23','',''),(2166491,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 10:25:23','',''),(2166518,'1','136','779',334,'Retail Sale Id 1281019',36000.00,0.00,0.00,0.00,1080.00,'2021-12-05 10:27:11','',''),(2166519,'1','136','779',334,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-05 10:27:11','',''),(2166547,'1','136','779',334,'Retail Sale Id 1281039',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 10:28:46','',''),(2166548,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 10:28:46','',''),(2166562,'1','136','779',334,'Retail Sale Id 1281046',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 10:29:35','',''),(2166563,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 10:29:35','',''),(2166574,'1','136','779',334,'Retail Sale Id 1281054',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 10:30:23','',''),(2166575,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 10:30:23','',''),(2166664,'1','136','779',334,'Retail Sale Id 1281098',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 10:35:43','',''),(2166665,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 10:35:43','',''),(2166684,'1','136','779',334,'Retail Sale Id 1281109',1497.60,0.00,0.00,0.00,135.72,'2021-12-05 10:36:54','',''),(2166685,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 10:36:54','',''),(2166724,'1','136','779',334,'Retail Sale Id 1281130',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 10:38:56','',''),(2166725,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 10:38:56','',''),(2166823,'1','136','779',334,'Retail Sale Id 1281181',135000.00,0.00,0.00,0.00,4050.00,'2021-12-05 10:45:14','',''),(2166824,'1','136','779',334,'Retail sales',0.00,0.00,0.00,225.00,0.00,'2021-12-05 10:45:14','',''),(2166867,'1','136','779',334,'Retail Sale Id 1281204',1299.20,0.00,0.00,0.00,117.74,'2021-12-05 10:47:24','',''),(2166868,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 10:47:24','',''),(2166921,'1','136','779',334,'Retail Sale Id 1281232',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 10:49:39','',''),(2166922,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:49:39','',''),(2166937,'1','136','779',334,'Retail Sale Id 1281246',998.40,0.00,0.00,0.00,90.48,'2021-12-05 10:50:37','',''),(2166938,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 10:50:37','',''),(2166963,'1','136','779',334,'Retail Sale Id 1281257',12998.40,0.00,0.00,0.00,1177.98,'2021-12-05 10:52:20','',''),(2166964,'1','136','779',334,'Retail sales',0.00,0.00,0.00,20.31,0.00,'2021-12-05 10:52:20','',''),(2166981,'1','136','779',334,'Retail Sale Id 1281267',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 10:53:23','',''),(2166982,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:53:23','',''),(2167001,'1','136','779',334,'Retail Sale Id 1281279',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 10:55:07','',''),(2167002,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 10:55:07','',''),(2167019,'1','136','779',334,'Retail Sale Id 1281288',1497.60,0.00,0.00,0.00,135.72,'2021-12-05 10:56:06','',''),(2167020,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 10:56:06','',''),(2167049,'1','136','779',334,'Retail Sale Id 1281302',1497.60,0.00,0.00,0.00,135.72,'2021-12-05 10:57:49','',''),(2167050,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 10:57:49','',''),(2167142,'1','136','779',334,'Retail Sale Id 1281345',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 11:02:43','',''),(2167143,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 11:02:43','',''),(2167162,'1','136','779',334,'Retail Sale Id 1281355',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 11:04:49','',''),(2167163,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 11:04:49','',''),(2167184,'1','136','779',334,'Retail Sale Id 1281366',998.40,0.00,0.00,0.00,90.48,'2021-12-05 11:05:38','',''),(2167185,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 11:05:38','',''),(2167214,'1','136','779',334,'Retail Sale Id 1281388',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 11:07:37','',''),(2167215,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 11:07:37','',''),(2167292,'1','136','779',334,'Retail Sale Id 1281439',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 11:11:34','',''),(2167293,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 11:11:34','',''),(2167308,'1','136','779',334,'Retail Sale Id 1281447',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 11:12:24','',''),(2167309,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 11:12:24','',''),(2167340,'1','136','779',334,'Retail Sale Id 1281464',2598.40,0.00,0.00,0.00,235.48,'2021-12-05 11:14:58','',''),(2167341,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-05 11:14:58','',''),(2167362,'1','136','779',334,'Retail Sale Id 1281476',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 11:16:33','',''),(2167363,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 11:16:33','',''),(2167443,'1','136','779',334,'Retail Sale Id 1281505',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 11:20:46','',''),(2167444,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 11:20:46','',''),(2167457,'1','136','779',334,'Retail Sale Id 1281515',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 11:22:02','',''),(2167458,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 11:22:02','',''),(2167475,'1','136','779',334,'Retail Sale Id 1281523',998.40,0.00,0.00,0.00,90.48,'2021-12-05 11:23:26','',''),(2167476,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 11:23:26','',''),(2167508,'1','136','779',334,'Retail Sale Id 1281537',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 11:24:52','',''),(2167509,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 11:24:52','',''),(2167536,'1','136','779',334,'Retail Sale Id 1281551',30000.00,0.00,0.00,0.00,900.00,'2021-12-05 11:26:25','',''),(2167537,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 11:26:25','',''),(2167567,'1','136','779',334,'Retail Sale Id 1281566',1900.80,0.00,0.00,0.00,172.26,'2021-12-05 11:28:00','',''),(2167568,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-05 11:28:00','',''),(2167591,'1','136','779',334,'Retail Sale Id 1281581',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 11:29:11','',''),(2167592,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 11:29:11','',''),(2167635,'1','136','779',334,'Retail Sale Id 1281602',3001.60,0.00,0.00,0.00,272.02,'2021-12-05 11:31:19','',''),(2167636,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 11:31:19','',''),(2167781,'1','136','779',334,'Retail Sale Id 1281672',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 11:39:29','',''),(2167782,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 11:39:29','',''),(2167790,'1','136','779',334,'Retail Sale Id 1281678',998.40,0.00,0.00,0.00,90.48,'2021-12-05 11:40:15','',''),(2167791,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 11:40:15','',''),(2167806,'1','136','779',334,'Retail Sale Id 1281724',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 11:41:55','',''),(2167807,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 11:41:55','',''),(2167820,'1','136','779',334,'Retail Sale Id 1281735',1299.20,0.00,0.00,0.00,117.74,'2021-12-05 11:42:36','',''),(2167821,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 11:42:36','',''),(2167860,'1','136','779',334,'Retail Sale Id 1281757',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 11:45:32','',''),(2167861,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:45:32','',''),(2167879,'1','136','779',334,'Retail Sale Id 1281764',3001.60,0.00,0.00,0.00,272.02,'2021-12-05 11:46:28','',''),(2167880,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 11:46:28','',''),(2167901,'1','136','779',334,'Retail Sale Id 1281774',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 11:47:27','',''),(2167902,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 11:47:27','',''),(2167917,'1','136','779',334,'Retail Sale Id 1281784',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 11:48:33','',''),(2167918,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 11:48:33','',''),(2168042,'1','136','779',334,'Retail Sale Id 1281859',1497.60,0.00,0.00,0.00,135.72,'2021-12-05 11:55:36','',''),(2168043,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 11:55:36','',''),(2168061,'1','136','779',334,'Retail Sale Id 1281868',998.40,0.00,0.00,0.00,90.48,'2021-12-05 11:56:24','',''),(2168062,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 11:56:24','',''),(2168192,'1','136','779',334,'Retail Sale Id 1281934',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 12:04:28','',''),(2168193,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:04:28','',''),(2168208,'1','136','779',334,'Retail Sale Id 1281948',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 12:05:14','',''),(2168209,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 12:05:14','',''),(2168250,'1','136','779',334,'Retail Sale Id 1281967',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 12:07:01','',''),(2168251,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 12:07:01','',''),(2168492,'1','136','779',334,'Retail Sale Id 1282081',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 12:17:54','',''),(2168493,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 12:17:54','',''),(2168516,'1','136','779',334,'Retail Sale Id 1282095',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 12:18:57','',''),(2168517,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 12:18:57','',''),(2168571,'1','136','779',334,'Retail Sale Id 1282119',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 12:20:58','',''),(2168572,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:20:58','',''),(2168599,'1','136','779',334,'Retail Sale Id 1282135',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 12:22:07','',''),(2168600,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 12:22:07','',''),(2168637,'1','136','779',334,'Retail Sale Id 1282156',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 12:23:50','',''),(2168638,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:23:50','',''),(2168668,'1','136','779',334,'Retail Sale Id 1282167',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 12:24:42','',''),(2168669,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:24:42','',''),(2168682,'1','136','779',334,'Retail Sale Id 1282173',998.40,0.00,0.00,0.00,90.48,'2021-12-05 12:25:36','',''),(2168683,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 12:25:36','',''),(2168710,'1','136','779',334,'Retail Sale Id 1282191',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 12:26:19','',''),(2168711,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:26:19','',''),(2168768,'1','136','779',334,'Retail Sale Id 1282218',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 12:28:34','',''),(2168769,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 12:28:34','',''),(2168894,'1','136','779',334,'Retail Sale Id 1282287',1497.60,0.00,0.00,0.00,135.72,'2021-12-05 12:35:27','',''),(2168895,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 12:35:27','',''),(2169013,'1','136','779',334,'Retail Sale Id 1282351',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 12:42:08','',''),(2169014,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 12:42:08','',''),(2169057,'1','136','779',334,'Retail Sale Id 1282374',60000.00,0.00,0.00,0.00,1800.00,'2021-12-05 12:44:09','',''),(2169058,'1','136','779',334,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-05 12:44:09','',''),(2169089,'1','136','779',334,'Retail Sale Id 1282389',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 12:46:04','',''),(2169090,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:46:04','',''),(2169173,'1','136','779',334,'Retail Sale Id 1282446',81000.00,0.00,0.00,0.00,2430.00,'2021-12-05 12:52:27','',''),(2169174,'1','136','779',334,'Retail sales',0.00,0.00,0.00,135.00,0.00,'2021-12-05 12:52:27','',''),(2169193,'1','136','779',334,'Retail Sale Id 1282461',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 12:53:32','',''),(2169194,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:53:32','',''),(2169223,'1','136','779',334,'Retail Sale Id 1282480',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 12:54:51','',''),(2169225,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 12:54:51','',''),(2169271,'1','136','779',334,'Retail Sale Id 1282497',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 12:56:47','',''),(2169272,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:56:47','',''),(2169305,'1','136','779',334,'Retail Sale Id 1282519',1299.20,0.00,0.00,0.00,117.74,'2021-12-05 12:59:27','',''),(2169306,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 12:59:27','',''),(2169365,'1','136','779',334,'Retail Sale Id 1282545',15000.00,0.00,0.00,0.00,450.00,'2021-12-05 13:01:43','',''),(2169366,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 13:01:43','',''),(2169401,'1','136','779',334,'Retail Sale Id 1282562',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 13:03:20','',''),(2169402,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 13:03:20','',''),(2169419,'1','136','779',334,'Retail Sale Id 1282567',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 13:04:20','',''),(2169420,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 13:04:20','',''),(2169734,'1','136','779',334,'Retail Sale Id 1282752',49800.00,0.00,0.00,0.00,1494.00,'2021-12-05 13:23:26','',''),(2169735,'1','136','779',334,'Retail sales',0.00,0.00,0.00,83.00,0.00,'2021-12-05 13:23:26','',''),(2169790,'1','136','779',334,'Retail Sale Id 1282785',90000.00,0.00,0.00,0.00,2700.00,'2021-12-05 13:26:50','',''),(2169791,'1','136','779',334,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-05 13:26:50','',''),(2169963,'1','136','779',334,'Retail Sale Id 1282857',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 13:34:55','',''),(2169964,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 13:34:55','',''),(2169979,'1','136','779',334,'Retail Sale Id 1282865',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 13:35:48','',''),(2169980,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 13:35:48','',''),(2170204,'1','136','779',334,'Retail Sale Id 1282946',30000.00,0.00,0.00,0.00,900.00,'2021-12-05 13:46:38','',''),(2170205,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 13:46:38','',''),(2170296,'1','136','779',334,'Retail Sale Id 1282987',16000.00,0.00,0.00,0.00,1450.00,'2021-12-05 13:51:45','',''),(2170297,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 13:51:45','',''),(2170336,'1','136','779',334,'Retail Sale Id 1283001',1401.60,0.00,0.00,0.00,127.02,'2021-12-05 13:53:48','',''),(2170337,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-05 13:53:48','',''),(2170433,'1','136','779',334,'Retail Sale Id 1283040',97200.00,0.00,0.00,0.00,2916.00,'2021-12-05 13:58:17','',''),(2170434,'1','136','779',334,'Retail sales',0.00,0.00,0.00,162.00,0.00,'2021-12-05 13:58:17','',''),(2170652,'1','136','779',334,'Retail Sale Id 1283147',1299.20,0.00,0.00,0.00,117.74,'2021-12-05 14:11:58','',''),(2170653,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 14:11:58','',''),(2170897,'1','136','779',334,'Retail Sale Id 1283239',27000.00,0.00,0.00,0.00,810.00,'2021-12-05 14:22:58','',''),(2170898,'1','136','779',334,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-05 14:22:58','',''),(2170939,'1','136','779',334,'Retail Sale Id 1283258',30000.00,0.00,0.00,0.00,900.00,'2021-12-05 14:25:13','',''),(2170940,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 14:25:13','',''),(2171219,'1','136','779',334,'Retail Sale Id 1283354',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 14:38:44','',''),(2171220,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 14:38:44','',''),(2171377,'1','136','779',334,'Retail Sale Id 1283414',998.40,0.00,0.00,0.00,90.48,'2021-12-05 14:48:13','',''),(2171378,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 14:48:13','',''),(2171429,'1','136','779',334,'Retail Sale Id 1283437',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 14:51:34','',''),(2171430,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:51:34','',''),(2171872,'1','136','779',334,'Retail Sale Id 1283664',697.60,0.00,0.00,0.00,63.22,'2021-12-05 15:24:55','',''),(2171873,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-05 15:24:55','',''),(2172018,'1','136','779',334,'Retail Sale Id 1283724',6400.00,0.00,0.00,0.00,580.00,'2021-12-05 15:32:44','',''),(2172019,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 15:32:44','',''),(2172155,'1','136','779',334,'Retail Sale Id 1283801',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 15:40:30','',''),(2172156,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 15:40:30','',''),(2172245,'1','136','779',334,'Retail Sale Id 1283843',2598.40,0.00,0.00,0.00,235.48,'2021-12-05 15:44:25','',''),(2172246,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-05 15:44:25','',''),(2172410,'1','136','779',334,'Retail Sale Id 1283939',1497.60,0.00,0.00,0.00,135.72,'2021-12-05 15:52:49','',''),(2172411,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 15:52:49','',''),(2172590,'1','136','779',334,'Retail Sale Id 1284032',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 16:03:58','',''),(2172591,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 16:03:58','',''),(2172602,'1','136','779',334,'Retail Sale Id 1284037',1900.80,0.00,0.00,0.00,172.26,'2021-12-05 16:04:30','',''),(2172603,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-05 16:04:30','',''),(2172696,'1','136','779',334,'Retail Sale Id 1284089',1920.00,0.00,0.00,0.00,174.00,'2021-12-05 16:10:08','',''),(2172697,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 16:10:08','',''),(2172756,'1','136','779',334,'Retail Sale Id 1284114',998.40,0.00,0.00,0.00,90.48,'2021-12-05 16:13:43','',''),(2172757,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 16:13:43','',''),(2172898,'1','136','779',334,'Retail Sale Id 1284194',998.40,0.00,0.00,0.00,90.48,'2021-12-05 16:23:14','',''),(2172899,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 16:23:14','',''),(2172928,'1','136','779',334,'Retail Sale Id 1284209',60000.00,0.00,0.00,0.00,1800.00,'2021-12-05 16:24:40','',''),(2172929,'1','136','779',334,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-05 16:24:40','',''),(2172979,'1','136','779',334,'Retail Sale Id 1284244',10003.20,0.00,0.00,0.00,906.54,'2021-12-05 16:28:42','',''),(2172980,'1','136','779',334,'Retail sales',0.00,0.00,0.00,15.63,0.00,'2021-12-05 16:28:42','',''),(2173045,'1','136','779',334,'Retail Sale Id 1284278',2502.40,0.00,0.00,0.00,226.78,'2021-12-05 16:33:09','',''),(2173046,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 16:33:09','',''),(2173167,'1','136','779',334,'Retail Sale Id 1284334',7360.00,0.00,0.00,0.00,667.00,'2021-12-05 16:39:11','',''),(2173168,'1','136','779',334,'Retail sales',0.00,0.00,0.00,11.50,0.00,'2021-12-05 16:39:11','',''),(2173195,'1','136','779',334,'Retail Sale Id 1284351',1600.00,0.00,0.00,0.00,145.00,'2021-12-05 16:41:00','',''),(2173196,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-05 16:41:00','',''),(2173255,'1','136','779',334,'Retail Sale Id 1284381',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 16:45:03','',''),(2173256,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 16:45:03','',''),(2173443,'1','136','779',334,'Retail Sale Id 1284479',18000.00,0.00,0.00,0.00,540.00,'2021-12-05 16:56:50','',''),(2173444,'1','136','779',334,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-05 16:56:50','',''),(2173491,'1','136','779',334,'Retail Sale Id 1284504',3200.00,0.00,0.00,0.00,290.00,'2021-12-05 17:00:04','',''),(2173492,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 17:00:04','',''),(2173514,'1','136','779',334,'Retail Sale Id 1284515',3001.60,0.00,0.00,0.00,272.02,'2021-12-05 17:01:36','',''),(2173515,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 17:01:36','',''),(2173547,'1','136','779',334,'Retail Sale Id 1284532',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 17:04:01','',''),(2173548,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 17:04:01','',''),(2173592,'1','136','779',334,'Retail Sale Id 1284547',2003.20,0.00,0.00,0.00,181.54,'2021-12-05 17:05:56','',''),(2173593,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 17:05:56','',''),(2173598,'1','136','779',334,'Retail Sale Id 1284551',8000.00,0.00,0.00,0.00,725.00,'2021-12-05 17:06:34','',''),(2173599,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:06:34','',''),(2173788,'1','136','779',334,'Retail Sale Id 1284639',2598.40,0.00,0.00,0.00,235.48,'2021-12-05 17:22:12','',''),(2173789,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-05 17:22:12','',''),(2173834,'1','136','779',334,'Retail Sale Id 1284661',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 17:26:24','',''),(2173835,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 17:26:24','',''),(2173882,'1','136','779',334,'Retail Sale Id 1284686',4000.00,0.00,0.00,0.00,362.50,'2021-12-05 17:30:28','',''),(2173883,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 17:30:28','',''),(2173952,'1','136','779',334,'Retail Sale Id 1284717',10016.00,0.00,0.00,0.00,907.70,'2021-12-05 17:35:43','',''),(2173953,'1','136','779',334,'Retail sales',0.00,0.00,0.00,15.65,0.00,'2021-12-05 17:35:43','',''),(2173970,'1','136','779',334,'Retail Sale Id 1284725',179400.00,0.00,0.00,0.00,4800.00,'2021-12-05 17:36:33','',''),(2173971,'1','136','779',334,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-05 17:36:33','',''),(2174792,'1','136','779',334,'Retail Sale Id 1284903',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 06:00:55','',''),(2174793,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 06:00:55','',''),(2174798,'1','136','779',334,'Retail Sale Id 1284906',7001.60,0.00,0.00,0.00,634.52,'2021-12-06 06:02:02','',''),(2174799,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-06 06:02:02','',''),(2174880,'1','136','779',334,'Retail Sale Id 1284954',27000.00,0.00,0.00,0.00,810.00,'2021-12-06 06:19:56','',''),(2174881,'1','136','779',334,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-06 06:19:56','',''),(2174886,'1','136','779',334,'Retail Sale Id 1284957',1299.20,0.00,0.00,0.00,117.74,'2021-12-06 06:20:59','',''),(2174887,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 06:20:59','',''),(2175071,'1','136','779',334,'Retail Sale Id 1285013',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 06:37:49','',''),(2175072,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:37:49','',''),(2175085,'1','136','779',334,'Retail Sale Id 1285019',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 06:39:04','',''),(2175086,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 06:39:04','',''),(2175103,'1','136','779',334,'Retail Sale Id 1285027',998.40,0.00,0.00,0.00,90.48,'2021-12-06 06:42:17','',''),(2175104,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 06:42:17','',''),(2175143,'1','136','779',334,'Retail Sale Id 1285047',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 06:45:50','',''),(2175144,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 06:45:50','',''),(2175213,'1','136','779',334,'Retail Sale Id 1285085',30000.00,0.00,0.00,0.00,900.00,'2021-12-06 06:51:03','',''),(2175214,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 06:51:03','',''),(2175242,'1','136','779',334,'Retail Sale Id 1285103',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 06:53:28','',''),(2175243,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 06:53:28','',''),(2175266,'1','136','779',334,'Retail Sale Id 1285114',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 06:55:16','',''),(2175267,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 06:55:16','',''),(2175297,'1','136','779',334,'Retail Sale Id 1285122',1299.20,0.00,0.00,0.00,117.74,'2021-12-06 06:57:02','',''),(2175298,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 06:57:02','',''),(2175314,'1','136','779',334,'Retail Sale Id 1285129',1299.20,0.00,0.00,0.00,117.74,'2021-12-06 06:57:36','',''),(2175315,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 06:57:36','',''),(2175336,'1','136','779',334,'Retail Sale Id 1285140',7680.00,0.00,0.00,0.00,696.00,'2021-12-06 06:58:40','',''),(2175337,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-06 06:58:40','',''),(2175387,'1','136','779',334,'Retail Sale Id 1285160',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 07:01:42','',''),(2175388,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 07:01:42','',''),(2175421,'1','136','779',334,'Retail Sale Id 1285167',1497.60,0.00,0.00,0.00,135.72,'2021-12-06 07:02:48','',''),(2175422,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 07:02:48','',''),(2175449,'1','136','779',334,'Retail Sale Id 1285177',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 07:03:51','',''),(2175450,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:03:51','',''),(2175463,'1','136','779',334,'Retail Sale Id 1285185',1299.20,0.00,0.00,0.00,117.74,'2021-12-06 07:05:13','',''),(2175464,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 07:05:13','',''),(2175481,'1','136','779',334,'Retail Sale Id 1285194',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 07:06:28','',''),(2175482,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:06:28','',''),(2175580,'1','136','779',334,'Retail Sale Id 1285239',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 07:14:43','',''),(2175581,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 07:14:43','',''),(2175626,'1','136','779',334,'Retail Sale Id 1285268',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 07:17:11','',''),(2175627,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 07:17:11','',''),(2175632,'1','136','779',334,'Retail Sale Id 1285272',3001.60,0.00,0.00,0.00,272.02,'2021-12-06 07:17:41','',''),(2175633,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 07:17:41','',''),(2175844,'1','136','779',334,'Retail Sale Id 1285380',4998.40,0.00,0.00,0.00,452.98,'2021-12-06 07:30:46','',''),(2175845,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 07:30:46','',''),(2175881,'1','136','779',334,'Retail Sale Id 1285394',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 07:32:33','',''),(2175882,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 07:32:33','',''),(2175949,'1','136','779',334,'Retail Sale Id 1285432',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 07:36:16','',''),(2175950,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:36:16','',''),(2175983,'1','136','779',334,'Retail Sale Id 1285450',60000.00,0.00,0.00,0.00,1800.00,'2021-12-06 07:38:26','',''),(2175984,'1','136','779',334,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 07:38:26','',''),(2176017,'1','136','779',334,'Retail Sale Id 1285464',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 07:40:29','',''),(2176018,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:40:29','',''),(2176103,'1','136','779',334,'Retail Sale Id 1285502',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 07:43:58','',''),(2176104,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 07:43:58','',''),(2176133,'1','136','779',334,'Retail Sale Id 1285515',6400.00,0.00,0.00,0.00,580.00,'2021-12-06 07:45:13','',''),(2176134,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 07:45:13','',''),(2176158,'1','136','779',334,'Retail Sale Id 1285540',210000.00,0.00,0.00,0.00,6300.00,'2021-12-06 07:46:31','',''),(2176159,'1','136','779',334,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-06 07:46:31','',''),(2176249,'1','136','779',334,'Retail Sale Id 1285577',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 07:50:17','',''),(2176250,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 07:50:17','',''),(2176389,'1','136','779',334,'Retail Sale Id 1285630',3001.60,0.00,0.00,0.00,272.02,'2021-12-06 07:55:40','',''),(2176390,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 07:55:40','',''),(2176499,'1','136','779',334,'Retail Sale Id 1285688',3200.00,0.00,0.00,0.00,290.00,'2021-12-06 08:01:24','',''),(2176500,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 08:01:24','',''),(2176658,'1','136','779',334,'Retail Sale Id 1285771',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 08:09:55','',''),(2176659,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 08:09:55','',''),(2176722,'1','136','779',334,'Retail Sale Id 1285807',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 08:14:31','',''),(2176723,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:14:31','',''),(2176748,'1','136','779',334,'Retail Sale Id 1285818',2598.40,0.00,0.00,0.00,235.48,'2021-12-06 08:15:57','',''),(2176749,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-06 08:15:57','',''),(2176766,'1','136','779',334,'Retail Sale Id 1285826',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 08:18:02','',''),(2176767,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 08:18:02','',''),(2176838,'1','136','779',334,'Retail Sale Id 1285868',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 08:25:08','',''),(2176839,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 08:25:08','',''),(2176897,'1','136','779',334,'Retail Sale Id 1285901',998.40,0.00,0.00,0.00,90.48,'2021-12-06 08:30:49','',''),(2176898,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 08:30:49','',''),(2176995,'1','136','779',334,'Retail Sale Id 1285944',6003.20,0.00,0.00,0.00,544.04,'2021-12-06 08:37:44','',''),(2176996,'1','136','779',334,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-06 08:37:44','',''),(2177011,'1','136','779',334,'Retail Sale Id 1285951',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 08:38:56','',''),(2177012,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 08:38:56','',''),(2177015,'1','136','779',334,'Retail Sale Id 1285955',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 08:39:34','',''),(2177016,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 08:39:34','',''),(2177114,'1','136','779',334,'Retail Sale Id 1285998',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 08:46:19','',''),(2177115,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 08:46:19','',''),(2177126,'1','136','779',334,'Retail Sale Id 1286002',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 08:47:23','',''),(2177127,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:47:23','',''),(2177203,'1','136','779',334,'Retail Sale Id 1286045',2598.40,0.00,0.00,0.00,235.48,'2021-12-06 08:53:32','',''),(2177204,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-06 08:53:32','',''),(2177225,'1','136','779',334,'Retail Sale Id 1286056',5760.00,0.00,0.00,0.00,522.00,'2021-12-06 08:55:06','',''),(2177226,'1','136','779',334,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-06 08:55:06','',''),(2177245,'1','136','779',334,'Retail Sale Id 1286067',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 08:56:00','',''),(2177246,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 08:56:00','',''),(2177260,'1','136','779',334,'Retail Sale Id 1286073',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 08:57:05','',''),(2177261,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 08:57:05','',''),(2177455,'1','136','779',334,'Retail Sale Id 1286162',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 09:10:31','',''),(2177456,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:10:31','',''),(2177498,'1','136','779',334,'Retail Sale Id 1286182',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 09:13:59','',''),(2177499,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:13:59','',''),(2177782,'1','136','779',334,'Retail Sale Id 1286314',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 09:31:27','',''),(2177783,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:31:27','',''),(2177809,'1','136','779',334,'Retail Sale Id 1286324',2502.40,0.00,0.00,0.00,226.78,'2021-12-06 09:33:07','',''),(2177810,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 09:33:07','',''),(2177887,'1','136','779',334,'Retail Sale Id 1286352',30000.00,0.00,0.00,0.00,900.00,'2021-12-06 09:37:07','',''),(2177888,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 09:37:07','',''),(2177918,'1','136','779',334,'Retail Sale Id 1286363',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 09:38:06','',''),(2177919,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 09:38:06','',''),(2177952,'1','136','779',334,'Retail Sale Id 1286370',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 09:39:17','',''),(2177953,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:39:17','',''),(2177968,'1','136','779',334,'Retail Sale Id 1286378',25500.00,0.00,0.00,0.00,765.00,'2021-12-06 09:40:38','',''),(2177969,'1','136','779',334,'Retail sales',0.00,0.00,0.00,42.50,0.00,'2021-12-06 09:40:38','',''),(2178032,'1','136','779',334,'Retail Sale Id 1286408',1497.60,0.00,0.00,0.00,135.72,'2021-12-06 09:44:38','',''),(2178033,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 09:44:38','',''),(2178052,'1','136','779',334,'Retail Sale Id 1286416',3200.00,0.00,0.00,0.00,290.00,'2021-12-06 09:45:47','',''),(2178053,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:45:47','',''),(2178072,'1','136','779',334,'Retail Sale Id 1286428',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 09:47:26','',''),(2178073,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:47:26','',''),(2178117,'1','136','779',334,'Retail Sale Id 1286451',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 09:50:38','',''),(2178118,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 09:50:38','',''),(2178129,'1','136','779',334,'Retail Sale Id 1286458',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 09:51:27','',''),(2178130,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 09:51:27','',''),(2178145,'1','136','779',334,'Retail Sale Id 1286468',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 09:52:49','',''),(2178146,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 09:52:49','',''),(2178169,'1','136','779',334,'Retail Sale Id 1286478',1497.60,0.00,0.00,0.00,135.72,'2021-12-06 09:54:05','',''),(2178170,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 09:54:05','',''),(2178212,'1','136','779',334,'Retail Sale Id 1286505',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 09:57:42','',''),(2178213,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 09:57:42','',''),(2178247,'1','136','779',334,'Retail Sale Id 1286522',30000.00,0.00,0.00,0.00,900.00,'2021-12-06 10:00:40','',''),(2178248,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 10:00:40','',''),(2178384,'1','136','779',334,'Retail Sale Id 1286581',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 10:07:36','',''),(2178385,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 10:07:36','',''),(2178406,'1','136','779',334,'Retail Sale Id 1286591',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 10:08:43','',''),(2178407,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 10:08:43','',''),(2178439,'1','136','779',334,'Retail Sale Id 1286602',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 10:09:51','',''),(2178440,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:09:52','',''),(2178467,'1','136','779',334,'Retail Sale Id 1286619',27000.00,0.00,0.00,0.00,810.00,'2021-12-06 10:11:32','',''),(2178468,'1','136','779',334,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-06 10:11:32','',''),(2178489,'1','136','779',334,'Retail Sale Id 1286630',1299.20,0.00,0.00,0.00,117.74,'2021-12-06 10:13:08','',''),(2178490,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 10:13:08','',''),(2178519,'1','136','779',334,'Retail Sale Id 1286647',209300.00,0.00,0.00,0.00,5600.00,'2021-12-06 10:15:21','',''),(2178520,'1','136','779',334,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-06 10:15:21','',''),(2178589,'1','136','779',334,'Retail Sale Id 1286685',6003.20,0.00,0.00,0.00,544.04,'2021-12-06 10:20:27','',''),(2178590,'1','136','779',334,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-06 10:20:27','',''),(2178601,'1','136','779',334,'Retail Sale Id 1286693',3001.60,0.00,0.00,0.00,272.02,'2021-12-06 10:21:13','',''),(2178602,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 10:21:13','',''),(2178611,'1','136','779',334,'Retail Sale Id 1286698',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 10:21:51','',''),(2178612,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 10:21:51','',''),(2178645,'1','136','779',334,'Retail Sale Id 1286715',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 10:24:53','',''),(2178646,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 10:24:53','',''),(2178653,'1','136','779',334,'Retail Sale Id 1286720',2598.40,0.00,0.00,0.00,235.48,'2021-12-06 10:25:35','',''),(2178654,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-06 10:25:35','',''),(2178677,'1','136','779',334,'Retail Sale Id 1286726',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 10:26:26','',''),(2178678,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 10:26:26','',''),(2178709,'1','136','779',334,'Retail Sale Id 1286743',5120.00,0.00,0.00,0.00,464.00,'2021-12-06 10:28:18','',''),(2178710,'1','136','779',334,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-06 10:28:18','',''),(2178717,'1','136','779',334,'Retail Sale Id 1286748',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 10:29:06','',''),(2178718,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 10:29:06','',''),(2178836,'1','136','779',334,'Retail Sale Id 1286816',6400.00,0.00,0.00,0.00,580.00,'2021-12-06 10:37:29','',''),(2178837,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 10:37:29','',''),(2178870,'1','136','779',334,'Retail Sale Id 1286836',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 10:40:17','',''),(2178871,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 10:40:17','',''),(2178882,'1','136','779',334,'Retail Sale Id 1286841',1299.20,0.00,0.00,0.00,117.74,'2021-12-06 10:41:24','',''),(2178883,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 10:41:24','',''),(2178902,'1','136','779',334,'Retail Sale Id 1286855',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 10:42:16','',''),(2178903,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 10:42:16','',''),(2178932,'1','136','779',334,'Retail Sale Id 1286864',69000.00,0.00,0.00,0.00,2070.00,'2021-12-06 10:43:58','',''),(2178933,'1','136','779',334,'Retail sales',0.00,0.00,0.00,115.00,0.00,'2021-12-06 10:43:58','',''),(2178984,'1','136','779',334,'Retail Sale Id 1286893',12800.00,0.00,0.00,0.00,1160.00,'2021-12-06 10:46:39','',''),(2178985,'1','136','779',334,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-06 10:46:39','',''),(2179151,'1','136','779',334,'Retail Sale Id 1286995',998.40,0.00,0.00,0.00,90.48,'2021-12-06 10:56:39','',''),(2179152,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 10:56:39','',''),(2179195,'1','136','779',334,'Retail Sale Id 1287028',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 10:59:25','',''),(2179196,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 10:59:25','',''),(2179329,'1','136','779',334,'Retail Sale Id 1287101',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 11:07:35','',''),(2179330,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 11:07:35','',''),(2179347,'1','136','779',334,'Retail Sale Id 1287110',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 11:08:47','',''),(2179348,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:08:47','',''),(2179359,'1','136','779',334,'Retail Sale Id 1287116',30000.00,0.00,0.00,0.00,900.00,'2021-12-06 11:09:43','',''),(2179360,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 11:09:43','',''),(2179383,'1','136','779',334,'Retail Sale Id 1287134',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 11:11:44','',''),(2179384,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:11:44','',''),(2179497,'1','136','779',334,'Retail Sale Id 1287189',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 11:17:32','',''),(2179498,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 11:17:32','',''),(2179567,'1','136','779',334,'Retail Sale Id 1287232',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 11:22:01','',''),(2179568,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 11:22:01','',''),(2179661,'1','136','779',334,'Retail Sale Id 1287284',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 11:28:49','',''),(2179662,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 11:28:49','',''),(2179691,'1','136','779',334,'Retail Sale Id 1287298',1299.20,0.00,0.00,0.00,117.74,'2021-12-06 11:30:51','',''),(2179692,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 11:30:51','',''),(2179708,'1','136','779',334,'Retail Sale Id 1287304',5120.00,0.00,0.00,0.00,464.00,'2021-12-06 11:32:09','',''),(2179709,'1','136','779',334,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-06 11:32:09','',''),(2179722,'1','136','779',334,'Retail Sale Id 1287316',998.40,0.00,0.00,0.00,90.48,'2021-12-06 11:33:07','',''),(2179723,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 11:33:07','',''),(2179752,'1','136','779',334,'Retail Sale Id 1287332',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 11:35:59','',''),(2179753,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:35:59','',''),(2179831,'1','136','779',334,'Retail Sale Id 1287371',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 11:42:48','',''),(2179832,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:42:48','',''),(2179859,'1','136','779',334,'Retail Sale Id 1287381',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 11:44:22','',''),(2179860,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 11:44:22','',''),(2179878,'1','136','779',334,'Retail Sale Id 1287439',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 11:47:22','',''),(2179879,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 11:47:22','',''),(2180026,'1','136','779',334,'Retail Sale Id 1287530',1299.20,0.00,0.00,0.00,117.74,'2021-12-06 11:56:00','',''),(2180027,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 11:56:00','',''),(2180072,'1','136','779',334,'Retail Sale Id 1287554',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 11:58:52','',''),(2180073,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 11:58:52','',''),(2180292,'1','136','779',334,'Retail Sale Id 1287675',3200.00,0.00,0.00,0.00,290.00,'2021-12-06 12:12:47','',''),(2180293,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 12:12:47','',''),(2180356,'1','136','779',334,'Retail Sale Id 1287714',209300.00,0.00,0.00,0.00,5600.00,'2021-12-06 12:15:56','',''),(2180357,'1','136','779',334,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-06 12:15:56','',''),(2180432,'1','136','779',334,'Retail Sale Id 1287755',998.40,0.00,0.00,0.00,90.48,'2021-12-06 12:20:17','',''),(2180433,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 12:20:17','',''),(2180448,'1','136','779',334,'Retail Sale Id 1287762',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 12:21:34','',''),(2180449,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 12:21:34','',''),(2180458,'1','136','779',334,'Retail Sale Id 1287767',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 12:22:44','',''),(2180459,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 12:22:44','',''),(2180482,'1','136','779',334,'Retail Sale Id 1287780',30000.00,0.00,0.00,0.00,900.00,'2021-12-06 12:24:25','',''),(2180483,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 12:24:25','',''),(2180504,'1','136','779',334,'Retail Sale Id 1287789',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 12:25:47','',''),(2180505,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:25:47','',''),(2180920,'1','136','779',334,'Retail Sale Id 1288008',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 12:51:32','',''),(2180921,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 12:51:32','',''),(2181090,'1','136','779',334,'Retail Sale Id 1288092',30000.00,0.00,0.00,0.00,900.00,'2021-12-06 13:00:36','',''),(2181091,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 13:00:36','',''),(2181126,'1','136','779',334,'Retail Sale Id 1288110',12000.00,0.00,0.00,0.00,360.00,'2021-12-06 13:02:44','',''),(2181127,'1','136','779',334,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-06 13:02:44','',''),(2181214,'1','136','779',334,'Retail Sale Id 1288155',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 13:08:12','',''),(2181215,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 13:08:12','',''),(2181280,'1','136','779',334,'Retail Sale Id 1288195',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 13:11:37','',''),(2181281,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 13:11:37','',''),(2181425,'1','136','779',334,'Retail Sale Id 1288248',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 13:18:09','',''),(2181426,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 13:18:09','',''),(2181449,'1','136','779',334,'Retail Sale Id 1288259',3840.00,0.00,0.00,0.00,348.00,'2021-12-06 13:19:27','',''),(2181450,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 13:19:27','',''),(2181476,'1','136','779',334,'Retail Sale Id 1288266',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 13:20:45','',''),(2181477,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:20:45','',''),(2181508,'1','136','779',334,'Retail Sale Id 1288284',11200.00,0.00,0.00,0.00,1015.00,'2021-12-06 13:22:53','',''),(2181509,'1','136','779',334,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-06 13:22:53','',''),(2181706,'1','136','779',334,'Retail Sale Id 1288368',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 13:36:10','',''),(2181707,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:36:10','',''),(2181728,'1','136','779',334,'Retail Sale Id 1288376',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 13:37:05','',''),(2181729,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 13:37:05','',''),(2181752,'1','136','779',334,'Retail Sale Id 1288388',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 13:38:19','',''),(2181753,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:38:19','',''),(2182227,'1','136','779',334,'Retail Sale Id 1288606',464945.00,0.00,0.00,0.00,12440.00,'2021-12-06 14:00:39','',''),(2182228,'1','136','779',334,'Retail sales',0.00,0.00,0.00,777.50,0.00,'2021-12-06 14:00:39','',''),(2182575,'1','136','779',334,'Retail Sale Id 1288758',998.40,0.00,0.00,0.00,90.48,'2021-12-06 14:16:21','',''),(2182576,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 14:16:21','',''),(2182601,'1','136','779',334,'Retail Sale Id 1288767',3001.60,0.00,0.00,0.00,272.02,'2021-12-06 14:17:12','',''),(2182602,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 14:17:12','',''),(2182636,'1','136','779',334,'Retail Sale Id 1288790',18000.00,0.00,0.00,0.00,540.00,'2021-12-06 14:19:23','',''),(2182637,'1','136','779',334,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-06 14:19:23','',''),(2182674,'1','136','779',334,'Retail Sale Id 1288809',1920.00,0.00,0.00,0.00,174.00,'2021-12-06 14:21:29','',''),(2182675,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:21:29','',''),(2182982,'1','136','779',334,'Retail Sale Id 1288963',39000.00,0.00,0.00,0.00,1170.00,'2021-12-06 14:38:57','',''),(2182983,'1','136','779',334,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-06 14:38:57','',''),(2183435,'1','136','779',334,'Retail Sale Id 1289157',3001.60,0.00,0.00,0.00,272.02,'2021-12-06 15:00:46','',''),(2183436,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 15:00:46','',''),(2183453,'1','136','779',334,'Retail Sale Id 1289168',6400.00,0.00,0.00,0.00,580.00,'2021-12-06 15:01:40','',''),(2183454,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 15:01:40','',''),(2183760,'1','136','779',334,'Retail Sale Id 1289310',3200.00,0.00,0.00,0.00,290.00,'2021-12-06 15:19:01','',''),(2183761,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 15:19:01','',''),(2183937,'1','136','779',334,'Retail Sale Id 1289386',1798.40,0.00,0.00,0.00,162.98,'2021-12-06 15:25:36','',''),(2183938,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-06 15:25:36','',''),(2184019,'1','136','779',334,'Retail Sale Id 1289428',27000.00,0.00,0.00,0.00,810.00,'2021-12-06 15:30:15','',''),(2184020,'1','136','779',334,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-06 15:30:15','',''),(2184037,'1','136','779',334,'Retail Sale Id 1289440',2598.40,0.00,0.00,0.00,235.48,'2021-12-06 15:31:17','',''),(2184038,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-06 15:31:17','',''),(2184128,'1','136','779',334,'Retail Sale Id 1289483',1203.20,0.00,0.00,0.00,109.04,'2021-12-06 15:36:31','',''),(2184129,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-06 15:36:31','',''),(2184307,'1','136','779',334,'Retail Sale Id 1289540',1497.60,0.00,0.00,0.00,135.72,'2021-12-06 15:42:18','',''),(2184308,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 15:42:18','',''),(2184791,'1','136','779',334,'Retail Sale Id 1289749',697.60,0.00,0.00,0.00,63.22,'2021-12-06 16:06:00','',''),(2184792,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-06 16:06:00','',''),(2184806,'1','136','779',334,'Retail Sale Id 1289755',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 16:06:41','',''),(2184807,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 16:06:41','',''),(2184822,'1','136','779',334,'Retail Sale Id 1289763',10400.00,0.00,0.00,0.00,942.50,'2021-12-06 16:08:11','',''),(2184823,'1','136','779',334,'Retail sales',0.00,0.00,0.00,16.25,0.00,'2021-12-06 16:08:11','',''),(2184903,'1','136','779',334,'Retail Sale Id 1289802',2502.40,0.00,0.00,0.00,226.78,'2021-12-06 16:13:53','',''),(2184904,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 16:13:53','',''),(2185014,'1','136','779',334,'Retail Sale Id 1289854',5760.00,0.00,0.00,0.00,522.00,'2021-12-06 16:19:53','',''),(2185015,'1','136','779',334,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-06 16:19:53','',''),(2185037,'1','136','779',334,'Retail Sale Id 1289866',1299.20,0.00,0.00,0.00,117.74,'2021-12-06 16:21:05','',''),(2185038,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 16:21:05','',''),(2185175,'1','136','779',334,'Retail Sale Id 1289933',90000.00,0.00,0.00,0.00,2700.00,'2021-12-06 16:28:08','',''),(2185176,'1','136','779',334,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-06 16:28:08','',''),(2185232,'1','136','779',334,'Retail Sale Id 1289964',1900.80,0.00,0.00,0.00,172.26,'2021-12-06 16:30:56','',''),(2185233,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-06 16:30:56','',''),(2185326,'1','136','779',334,'Retail Sale Id 1290008',2003.20,0.00,0.00,0.00,181.54,'2021-12-06 16:35:29','',''),(2185327,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 16:35:29','',''),(2185338,'1','136','779',334,'Retail Sale Id 1290016',6003.20,0.00,0.00,0.00,544.04,'2021-12-06 16:36:18','',''),(2185339,'1','136','779',334,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-06 16:36:18','',''),(2185384,'1','136','779',334,'Retail Sale Id 1290034',7040.00,0.00,0.00,0.00,638.00,'2021-12-06 16:38:35','',''),(2185385,'1','136','779',334,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-06 16:38:35','',''),(2185537,'1','136','779',334,'Retail Sale Id 1290109',998.40,0.00,0.00,0.00,90.48,'2021-12-06 16:47:33','',''),(2185538,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 16:47:33','',''),(2185746,'1','136','779',334,'Retail Sale Id 1290217',1702.40,0.00,0.00,0.00,154.28,'2021-12-06 16:59:06','',''),(2185747,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-06 16:59:06','',''),(2185810,'1','136','779',334,'Retail Sale Id 1290254',24000.00,0.00,0.00,0.00,720.00,'2021-12-06 17:03:47','',''),(2185811,'1','136','779',334,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-06 17:03:47','',''),(2185857,'1','136','779',334,'Retail Sale Id 1290275',12000.00,0.00,0.00,0.00,360.00,'2021-12-06 17:06:41','',''),(2185858,'1','136','779',334,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-06 17:06:41','',''),(2186013,'1','136','779',334,'Retail Sale Id 1290360',8000.00,0.00,0.00,0.00,725.00,'2021-12-06 17:17:48','',''),(2186014,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 17:17:48','',''),(2186017,'1','136','779',334,'Retail Sale Id 1290362',4000.00,0.00,0.00,0.00,362.50,'2021-12-06 17:18:27','',''),(2186018,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 17:18:27','',''),(2186057,'1','136','779',334,'Retail Sale Id 1290380',131560.00,0.00,0.00,0.00,-216476.00,'2021-12-06 17:23:14','',''),(2186058,'1','136','779',334,'Retail sales',0.00,0.00,0.00,598.00,0.00,'2021-12-06 17:23:14','',''),(2186069,'1','136','779',334,'Return of Retail Sale Id 1290380',0.00,131560.00,598.00,0.00,216476.00,'2021-12-06 17:23:37','',''),(2186076,'1','136','779',334,'Retail Sale Id 1290389',131560.00,0.00,0.00,0.00,3520.00,'2021-12-06 17:24:44','',''),(2186077,'1','136','779',334,'Retail sales',0.00,0.00,0.00,220.00,0.00,'2021-12-06 17:24:44','',''),(2187268,'1','136','779',334,'Retail Sale Id 1290723',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 06:12:27','',''),(2187269,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 06:12:27','',''),(2187287,'1','136','779',334,'Retail Sale Id 1290727',1497.60,0.00,0.00,0.00,135.72,'2021-12-07 06:13:25','',''),(2187288,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 06:13:25','',''),(2187384,'1','136','779',334,'Retail Sale Id 1290777',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 06:22:45','',''),(2187385,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 06:22:45','',''),(2187414,'1','136','779',334,'Retail Sale Id 1290790',8000.00,0.00,0.00,0.00,725.00,'2021-12-07 06:24:51','',''),(2187415,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:24:51','',''),(2187595,'1','136','779',334,'Retail Sale Id 1290883',1497.60,0.00,0.00,0.00,135.72,'2021-12-07 06:39:14','',''),(2187596,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 06:39:14','',''),(2187627,'1','136','779',334,'Retail Sale Id 1290901',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 06:41:04','',''),(2187628,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 06:41:04','',''),(2187635,'1','136','779',334,'Retail Sale Id 1290907',8000.00,0.00,0.00,0.00,725.00,'2021-12-07 06:41:46','',''),(2187636,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:41:46','',''),(2187811,'1','136','779',334,'Retail Sale Id 1290982',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 06:52:27','',''),(2187812,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 06:52:27','',''),(2187828,'1','136','779',334,'Retail Sale Id 1290991',998.40,0.00,0.00,0.00,90.48,'2021-12-07 06:53:32','',''),(2187829,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 06:53:32','',''),(2188016,'1','136','779',334,'Retail Sale Id 1291085',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 07:04:18','',''),(2188017,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 07:04:18','',''),(2188184,'1','136','779',334,'Retail Sale Id 1291168',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 07:12:39','',''),(2188185,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 07:12:39','',''),(2188246,'1','136','779',334,'Retail Sale Id 1291194',60000.00,0.00,0.00,0.00,1800.00,'2021-12-07 07:15:03','',''),(2188247,'1','136','779',334,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-07 07:15:03','',''),(2188282,'1','136','779',334,'Retail Sale Id 1291211',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 07:16:49','',''),(2188283,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 07:16:49','',''),(2188306,'1','136','779',334,'Retail Sale Id 1291222',8000.00,0.00,0.00,0.00,725.00,'2021-12-07 07:18:00','',''),(2188308,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:18:00','',''),(2188512,'1','136','779',334,'Retail Sale Id 1291329',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 07:27:47','',''),(2188513,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 07:27:47','',''),(2188579,'1','136','779',334,'Retail Sale Id 1291362',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 07:30:27','',''),(2188580,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 07:30:27','',''),(2188756,'1','136','779',334,'Retail Sale Id 1291454',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 07:39:05','',''),(2188757,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 07:39:05','',''),(2188822,'1','136','779',334,'Retail Sale Id 1291488',8000.00,0.00,0.00,0.00,725.00,'2021-12-07 07:42:33','',''),(2188823,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:42:33','',''),(2188862,'1','136','779',334,'Retail Sale Id 1291524',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 07:45:00','',''),(2188863,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 07:45:00','',''),(2188904,'1','136','779',334,'Retail Sale Id 1291539',15000.00,0.00,0.00,0.00,450.00,'2021-12-07 07:47:07','',''),(2188905,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 07:47:07','',''),(2189069,'1','136','779',334,'Retail Sale Id 1291633',3500.80,0.00,0.00,0.00,317.26,'2021-12-07 07:56:08','',''),(2189070,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-07 07:56:08','',''),(2189083,'1','136','779',334,'Retail Sale Id 1291639',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 07:57:03','',''),(2189084,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 07:57:03','',''),(2189107,'1','136','779',334,'Retail Sale Id 1291651',3200.00,0.00,0.00,0.00,290.00,'2021-12-07 07:58:37','',''),(2189108,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 07:58:37','',''),(2189133,'1','136','779',334,'Retail Sale Id 1291656',998.40,0.00,0.00,0.00,90.48,'2021-12-07 07:59:21','',''),(2189134,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 07:59:21','',''),(2189327,'1','136','779',334,'Retail Sale Id 1291747',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 08:10:01','',''),(2189328,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 08:10:01','',''),(2189377,'1','136','779',334,'Retail Sale Id 1291778',640.00,0.00,0.00,0.00,58.00,'2021-12-07 08:13:43','',''),(2189378,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 08:13:43','',''),(2189418,'1','136','779',334,'Retail Sale Id 1291794',1497.60,0.00,0.00,0.00,135.72,'2021-12-07 08:15:43','',''),(2189419,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 08:15:43','',''),(2189438,'1','136','779',334,'Retail Sale Id 1291805',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 08:16:44','',''),(2189439,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 08:16:44','',''),(2189464,'1','136','779',334,'Return of Retail Sale Id 1291778',0.00,640.00,1.00,0.00,-58.00,'2021-12-07 08:18:17','',''),(2189481,'1','136','779',334,'Retail Sale Id 1291827',7360.00,0.00,0.00,0.00,667.00,'2021-12-07 08:19:16','',''),(2189482,'1','136','779',334,'Retail sales',0.00,0.00,0.00,11.50,0.00,'2021-12-07 08:19:16','',''),(2189495,'1','136','779',334,'Retail Sale Id 1291836',1497.60,0.00,0.00,0.00,135.72,'2021-12-07 08:20:07','',''),(2189496,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 08:20:07','',''),(2189507,'1','136','779',334,'Retail Sale Id 1291841',1497.60,0.00,0.00,0.00,135.72,'2021-12-07 08:20:50','',''),(2189508,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 08:20:50','',''),(2189519,'1','136','779',334,'Retail Sale Id 1291846',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 08:21:35','',''),(2189520,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 08:21:35','',''),(2189583,'1','136','779',334,'Retail Sale Id 1291876',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 08:25:15','',''),(2189584,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 08:25:15','',''),(2189705,'1','136','779',334,'Retail Sale Id 1291941',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 08:34:04','',''),(2189706,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 08:34:04','',''),(2189888,'1','136','779',334,'Retail Sale Id 1292004',6502.40,0.00,0.00,0.00,589.28,'2021-12-07 08:41:54','',''),(2189889,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-07 08:41:54','',''),(2190005,'1','136','779',334,'Retail Sale Id 1292049',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 08:47:06','',''),(2190006,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 08:47:06','',''),(2190094,'1','136','779',334,'Retail Sale Id 1292090',37500.00,0.00,0.00,0.00,1125.00,'2021-12-07 08:51:16','',''),(2190095,'1','136','779',334,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-07 08:51:16','',''),(2190285,'1','136','779',334,'Retail Sale Id 1292185',49800.00,0.00,0.00,0.00,1494.00,'2021-12-07 09:04:08','',''),(2190286,'1','136','779',334,'Retail sales',0.00,0.00,0.00,83.00,0.00,'2021-12-07 09:04:08','',''),(2190351,'1','136','779',334,'Retail Sale Id 1292213',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 09:07:52','',''),(2190352,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 09:07:52','',''),(2190379,'1','136','779',334,'Retail Sale Id 1292227',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 09:08:55','',''),(2190380,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 09:08:55','',''),(2190415,'1','136','779',334,'Retail Sale Id 1292247',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 09:11:01','',''),(2190416,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 09:11:01','',''),(2190439,'1','136','779',334,'Retail Sale Id 1292257',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 09:12:16','',''),(2190440,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 09:12:16','',''),(2190471,'1','136','779',334,'Retail Sale Id 1292276',8000.00,0.00,0.00,0.00,725.00,'2021-12-07 09:13:51','',''),(2190472,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:13:51','',''),(2190489,'1','136','779',334,'Retail Sale Id 1292287',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 09:14:50','',''),(2190490,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 09:14:50','',''),(2190517,'1','136','779',334,'Retail Sale Id 1292303',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 09:16:17','',''),(2190518,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 09:16:17','',''),(2190695,'1','136','779',334,'Retail Sale Id 1292383',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 09:26:00','',''),(2190696,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 09:26:00','',''),(2190723,'1','136','779',334,'Retail Sale Id 1292396',1497.60,0.00,0.00,0.00,135.72,'2021-12-07 09:27:03','',''),(2190724,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 09:27:03','',''),(2190760,'1','136','779',334,'Retail Sale Id 1292411',1600.00,0.00,0.00,0.00,145.00,'2021-12-07 09:28:28','',''),(2190761,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-07 09:28:28','',''),(2190812,'1','136','779',334,'Retail Sale Id 1292437',44400.00,0.00,0.00,0.00,1332.00,'2021-12-07 09:30:18','',''),(2190813,'1','136','779',334,'Retail sales',0.00,0.00,0.00,74.00,0.00,'2021-12-07 09:30:18','',''),(2190928,'1','136','779',334,'Retail Sale Id 1292493',120000.00,0.00,0.00,0.00,3600.00,'2021-12-07 09:36:28','',''),(2190929,'1','136','779',334,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-07 09:36:28','',''),(2190958,'1','136','779',334,'Retail Sale Id 1292511',3200.00,0.00,0.00,0.00,290.00,'2021-12-07 09:38:32','',''),(2190959,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 09:38:32','',''),(2190976,'1','136','779',334,'Retail Sale Id 1292522',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 09:39:43','',''),(2190977,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 09:39:43','',''),(2191004,'1','136','779',334,'Retail Sale Id 1292536',1299.20,0.00,0.00,0.00,117.74,'2021-12-07 09:40:51','',''),(2191005,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-07 09:40:51','',''),(2191026,'1','136','779',334,'Retail Sale Id 1292542',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 09:42:15','',''),(2191027,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 09:42:15','',''),(2191357,'1','136','779',334,'Retail Sale Id 1292721',998.40,0.00,0.00,0.00,90.48,'2021-12-07 10:05:32','',''),(2191358,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 10:05:32','',''),(2191397,'1','136','779',334,'Retail Sale Id 1292737',8000.00,0.00,0.00,0.00,725.00,'2021-12-07 10:08:03','',''),(2191398,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:08:03','',''),(2191453,'1','136','779',334,'Retail Sale Id 1292770',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 10:11:56','',''),(2191454,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 10:11:56','',''),(2191706,'1','136','779',334,'Retail Sale Id 1292900',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 10:30:52','',''),(2191707,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 10:30:52','',''),(2192076,'1','136','779',334,'Retail Sale Id 1293077',3500.80,0.00,0.00,0.00,317.26,'2021-12-07 10:52:02','',''),(2192077,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-07 10:52:02','',''),(2192110,'1','136','779',334,'Retail Sale Id 1293093',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 10:53:55','',''),(2192113,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 10:53:55','',''),(2192280,'1','136','779',334,'Retail Sale Id 1293161',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 11:02:15','',''),(2192281,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 11:02:15','',''),(2192400,'1','136','779',334,'Retail Sale Id 1293225',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 11:08:36','',''),(2192401,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 11:08:36','',''),(2192424,'1','136','779',334,'Retail Sale Id 1293236',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 11:09:41','',''),(2192425,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 11:09:41','',''),(2192526,'1','136','779',334,'Retail Sale Id 1293300',8000.00,0.00,0.00,0.00,725.00,'2021-12-07 11:15:51','',''),(2192527,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 11:15:51','',''),(2192560,'1','136','779',334,'Retail Sale Id 1293318',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 11:18:18','',''),(2192561,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 11:18:18','',''),(2192582,'1','136','779',334,'Retail Sale Id 1293342',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 11:19:36','',''),(2192583,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 11:19:36','',''),(2192797,'1','136','779',334,'Retail Sale Id 1293461',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 11:35:40','',''),(2192798,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 11:35:40','',''),(2192849,'1','136','779',334,'Retail Sale Id 1293489',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 11:39:46','',''),(2192850,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 11:39:46','',''),(2192867,'1','136','779',334,'Retail Sale Id 1293499',8000.00,0.00,0.00,0.00,725.00,'2021-12-07 11:40:46','',''),(2192868,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 11:40:46','',''),(2192909,'1','136','779',334,'Retail Sale Id 1293522',3500.80,0.00,0.00,0.00,317.26,'2021-12-07 11:43:23','',''),(2192910,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-07 11:43:23','',''),(2193101,'1','136','779',334,'Retail Sale Id 1293609',8000.00,0.00,0.00,0.00,725.00,'2021-12-07 11:58:34','',''),(2193102,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 11:58:34','',''),(2193125,'1','136','779',334,'Retail Sale Id 1293624',24000.00,0.00,0.00,0.00,720.00,'2021-12-07 12:00:19','',''),(2193126,'1','136','779',334,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-07 12:00:19','',''),(2193181,'1','136','779',334,'Retail Sale Id 1293662',2502.40,0.00,0.00,0.00,226.78,'2021-12-07 12:06:12','',''),(2193182,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-07 12:06:12','',''),(2193321,'1','136','779',334,'Retail Sale Id 1293734',12000.00,0.00,0.00,0.00,1087.50,'2021-12-07 12:18:11','',''),(2193322,'1','136','779',334,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-07 12:18:11','',''),(2193333,'1','136','779',334,'Retail Sale Id 1293741',1299.20,0.00,0.00,0.00,117.74,'2021-12-07 12:19:01','',''),(2193334,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-07 12:19:01','',''),(2193513,'1','136','779',334,'Retail Sale Id 1293831',25002.00,0.00,0.00,0.00,750.06,'2021-12-07 12:35:24','',''),(2193514,'1','136','779',334,'Retail sales',0.00,0.00,0.00,41.67,0.00,'2021-12-07 12:35:24','',''),(2193644,'1','136','779',334,'Retail Sale Id 1293917',2560.00,0.00,0.00,0.00,232.00,'2021-12-07 12:46:47','',''),(2193645,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 12:46:47','',''),(2193674,'1','136','779',334,'Retail Sale Id 1293936',3200.00,0.00,0.00,0.00,290.00,'2021-12-07 12:48:23','',''),(2193675,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 12:48:23','',''),(2193693,'1','136','779',334,'Retail Sale Id 1293946',3200.00,0.00,0.00,0.00,290.00,'2021-12-07 12:49:29','',''),(2193694,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 12:49:29','',''),(2193710,'1','136','779',334,'Retail Sale Id 1293954',998.40,0.00,0.00,0.00,90.48,'2021-12-07 12:50:46','',''),(2193711,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 12:50:46','',''),(2193739,'1','136','779',334,'Retail Sale Id 1293967',8000.00,0.00,0.00,0.00,725.00,'2021-12-07 12:51:50','',''),(2193740,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 12:51:50','',''),(2193851,'1','136','779',334,'Retail Sale Id 1294018',8000.00,0.00,0.00,0.00,725.00,'2021-12-07 12:59:11','',''),(2193852,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 12:59:11','',''),(2194017,'1','136','779',334,'Retail Sale Id 1294106',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 13:11:05','',''),(2194018,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 13:11:05','',''),(2194069,'1','136','779',334,'Retail Sale Id 1294131',3200.00,0.00,0.00,0.00,290.00,'2021-12-07 13:13:28','',''),(2194070,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 13:13:28','',''),(2194098,'1','136','779',334,'Retail Sale Id 1294150',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 13:15:47','',''),(2194099,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 13:15:47','',''),(2194121,'1','136','779',334,'Retail Sale Id 1294160',1401.60,0.00,0.00,0.00,127.02,'2021-12-07 13:16:39','',''),(2194122,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-07 13:16:39','',''),(2194133,'1','136','779',334,'Retail Sale Id 1294166',3001.60,0.00,0.00,0.00,272.02,'2021-12-07 13:17:42','',''),(2194134,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 13:17:42','',''),(2194153,'1','136','779',334,'Retail Sale Id 1294175',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 13:18:55','',''),(2194154,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 13:18:55','',''),(2194249,'1','136','779',334,'Retail Sale Id 1294285',998.40,0.00,0.00,0.00,90.48,'2021-12-07 13:25:22','',''),(2194250,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 13:25:22','',''),(2194388,'1','136','779',334,'Retail Sale Id 1294353',998.40,0.00,0.00,0.00,90.48,'2021-12-07 13:30:45','',''),(2194389,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 13:30:45','',''),(2194435,'1','136','779',334,'Retail Sale Id 1294371',11200.00,0.00,0.00,0.00,1015.00,'2021-12-07 13:33:26','',''),(2194436,'1','136','779',334,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-07 13:33:26','',''),(2194457,'1','136','779',334,'Retail Sale Id 1294381',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 13:34:43','',''),(2194458,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 13:34:43','',''),(2194508,'1','136','779',334,'Retail Sale Id 1294401',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 13:37:23','',''),(2194509,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 13:37:23','',''),(2194585,'1','136','779',334,'Retail Sale Id 1294436',998.40,0.00,0.00,0.00,90.48,'2021-12-07 13:41:36','',''),(2194586,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 13:41:36','',''),(2194623,'1','136','779',334,'Retail Sale Id 1294456',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 13:44:35','',''),(2194624,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 13:44:35','',''),(2194641,'1','136','779',334,'Retail Sale Id 1294464',4998.40,0.00,0.00,0.00,452.98,'2021-12-07 13:45:49','',''),(2194642,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-07 13:45:49','',''),(2194709,'1','136','779',334,'Retail Sale Id 1294492',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 13:49:40','',''),(2194710,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 13:49:40','',''),(2194737,'1','136','779',334,'Retail Sale Id 1294500',8000.00,0.00,0.00,0.00,725.00,'2021-12-07 13:51:17','',''),(2194738,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:51:17','',''),(2194800,'1','136','779',334,'Retail Sale Id 1294533',26400.00,0.00,0.00,0.00,792.00,'2021-12-07 13:55:15','',''),(2194801,'1','136','779',334,'Retail sales',0.00,0.00,0.00,44.00,0.00,'2021-12-07 13:55:15','',''),(2194831,'1','136','779',334,'Retail Sale Id 1294546',7001.60,0.00,0.00,0.00,634.52,'2021-12-07 13:57:20','',''),(2194832,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-07 13:57:20','',''),(2194841,'1','136','779',334,'Retail Sale Id 1294555',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 13:58:16','',''),(2194842,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 13:58:16','',''),(2194871,'1','136','779',334,'Retail Sale Id 1294569',30000.00,0.00,0.00,0.00,900.00,'2021-12-07 14:00:35','',''),(2194872,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 14:00:35','',''),(2194897,'1','136','779',334,'Retail Sale Id 1294583',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 14:01:45','',''),(2194898,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 14:01:45','',''),(2194971,'1','136','779',334,'Retail Sale Id 1294627',3500.80,0.00,0.00,0.00,317.26,'2021-12-07 14:07:33','',''),(2194972,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-07 14:07:33','',''),(2195107,'1','136','779',334,'Retail Sale Id 1294679',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 14:13:24','',''),(2195108,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 14:13:24','',''),(2195165,'1','136','779',334,'Retail Sale Id 1294695',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 14:16:13','',''),(2195166,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 14:16:13','',''),(2195222,'1','136','779',334,'Retail Sale Id 1294711',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 14:19:27','',''),(2195223,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 14:19:27','',''),(2195340,'1','136','779',334,'Retail Sale Id 1294775',1600.00,0.00,0.00,0.00,145.00,'2021-12-07 14:25:58','',''),(2195341,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-07 14:25:58','',''),(2195356,'1','136','779',334,'Retail Sale Id 1294785',8000.00,0.00,0.00,0.00,725.00,'2021-12-07 14:26:46','',''),(2195357,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:26:46','',''),(2195374,'1','136','779',334,'Retail Sale Id 1294792',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 14:27:43','',''),(2195375,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 14:27:43','',''),(2195469,'1','136','779',334,'Retail Sale Id 1294828',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 14:33:26','',''),(2195470,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 14:33:26','',''),(2195716,'1','136','779',334,'Retail Sale Id 1294972',998.40,0.00,0.00,0.00,90.48,'2021-12-07 14:46:43','',''),(2195717,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 14:46:43','',''),(2195816,'1','136','779',334,'Retail Sale Id 1295025',6400.00,0.00,0.00,0.00,580.00,'2021-12-07 14:51:15','',''),(2195817,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 14:51:15','',''),(2195868,'1','136','779',334,'Retail Sale Id 1295054',8000.00,0.00,0.00,0.00,725.00,'2021-12-07 14:53:51','',''),(2195869,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:53:51','',''),(2196100,'1','136','779',334,'Retail Sale Id 1295164',1497.60,0.00,0.00,0.00,135.72,'2021-12-07 15:08:28','',''),(2196101,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 15:08:28','',''),(2196116,'1','136','779',334,'Retail Sale Id 1295173',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 15:09:16','',''),(2196117,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 15:09:16','',''),(2196136,'1','136','779',334,'Retail Sale Id 1295184',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 15:10:09','',''),(2196137,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 15:10:09','',''),(2196152,'1','136','779',334,'Retail Sale Id 1295192',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 15:11:02','',''),(2196153,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 15:11:02','',''),(2196176,'1','136','779',334,'Retail Sale Id 1295202',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 15:11:54','',''),(2196177,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 15:11:54','',''),(2196190,'1','136','779',334,'Retail Sale Id 1295210',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 15:12:44','',''),(2196191,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 15:12:44','',''),(2196218,'1','136','779',334,'Retail Sale Id 1295223',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 15:13:49','',''),(2196219,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 15:13:49','',''),(2196244,'1','136','779',334,'Retail Sale Id 1295230',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 15:15:14','',''),(2196245,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 15:15:14','',''),(2196258,'1','136','779',334,'Retail Sale Id 1295241',998.40,0.00,0.00,0.00,90.48,'2021-12-07 15:16:00','',''),(2196259,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 15:16:00','',''),(2196292,'1','136','779',334,'Retail Sale Id 1295257',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 15:17:51','',''),(2196293,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 15:17:51','',''),(2196354,'1','136','779',334,'Retail Sale Id 1295289',640.00,0.00,0.00,0.00,58.00,'2021-12-07 15:21:39','',''),(2196355,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 15:21:39','',''),(2196398,'1','136','779',334,'Return of Retail Sale Id 1295289',0.00,640.00,1.00,0.00,-58.00,'2021-12-07 15:24:13','',''),(2196424,'1','136','779',334,'Retail Sale Id 1295329',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 15:25:27','',''),(2196425,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 15:25:27','',''),(2196554,'1','136','779',334,'Retail Sale Id 1295395',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 15:31:23','',''),(2196555,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 15:31:23','',''),(2196580,'1','136','779',334,'Retail Sale Id 1295408',3200.00,0.00,0.00,0.00,290.00,'2021-12-07 15:32:27','',''),(2196581,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 15:32:27','',''),(2196634,'1','136','779',334,'Retail Sale Id 1295431',564512.00,0.00,0.00,0.00,15104.00,'2021-12-07 15:35:18','',''),(2196635,'1','136','779',334,'Retail sales',0.00,0.00,0.00,944.00,0.00,'2021-12-07 15:35:18','',''),(2196724,'1','136','779',334,'Retail Sale Id 1295481',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 15:39:16','',''),(2196725,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 15:39:16','',''),(2196765,'1','136','779',334,'Retail Sale Id 1295494',2598.40,0.00,0.00,0.00,235.48,'2021-12-07 15:40:43','',''),(2196766,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-07 15:40:43','',''),(2196803,'1','136','779',334,'Retail Sale Id 1295510',4499.20,0.00,0.00,0.00,407.74,'2021-12-07 15:43:02','',''),(2196804,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-07 15:43:02','',''),(2196825,'1','136','779',334,'Retail Sale Id 1295522',1299.20,0.00,0.00,0.00,117.74,'2021-12-07 15:44:04','',''),(2196826,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-07 15:44:04','',''),(2196919,'1','136','779',334,'Retail Sale Id 1295572',4998.40,0.00,0.00,0.00,452.98,'2021-12-07 15:48:44','',''),(2196920,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-07 15:48:44','',''),(2197014,'1','136','779',334,'Retail Sale Id 1295621',1100.80,0.00,0.00,0.00,99.76,'2021-12-07 15:52:47','',''),(2197015,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.72,0.00,'2021-12-07 15:52:47','',''),(2197040,'1','136','779',334,'Retail Sale Id 1295635',8000.00,0.00,0.00,0.00,725.00,'2021-12-07 15:53:55','',''),(2197041,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:53:55','',''),(2197066,'1','136','779',334,'Retail Sale Id 1295651',998.40,0.00,0.00,0.00,90.48,'2021-12-07 15:55:06','',''),(2197067,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 15:55:06','',''),(2197086,'1','136','779',334,'Retail Sale Id 1295660',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 15:56:11','',''),(2197087,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 15:56:11','',''),(2197113,'1','136','779',334,'Retail Sale Id 1295672',3200.00,0.00,0.00,0.00,290.00,'2021-12-07 15:57:16','',''),(2197114,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 15:57:16','',''),(2197153,'1','136','779',334,'Retail Sale Id 1295693',3200.00,0.00,0.00,0.00,290.00,'2021-12-07 15:59:22','',''),(2197154,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 15:59:22','',''),(2197364,'1','136','779',334,'Retail Sale Id 1295800',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 16:09:45','',''),(2197365,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 16:09:45','',''),(2197380,'1','136','779',334,'Retail Sale Id 1295807',998.40,0.00,0.00,0.00,90.48,'2021-12-07 16:10:47','',''),(2197381,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 16:10:47','',''),(2197396,'1','136','779',334,'Retail Sale Id 1295820',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 16:11:45','',''),(2197397,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 16:11:45','',''),(2197416,'1','136','779',334,'Retail Sale Id 1295828',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 16:12:33','',''),(2197417,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 16:12:33','',''),(2197643,'1','136','779',334,'Retail Sale Id 1295951',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 16:22:18','',''),(2197644,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 16:22:18','',''),(2197665,'1','136','779',334,'Retail Sale Id 1295965',3001.60,0.00,0.00,0.00,272.02,'2021-12-07 16:23:17','',''),(2197666,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 16:23:17','',''),(2197685,'1','136','779',334,'Retail Sale Id 1295978',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 16:24:45','',''),(2197686,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 16:24:45','',''),(2197707,'1','136','779',334,'Retail Sale Id 1295986',16000.00,0.00,0.00,0.00,1450.00,'2021-12-07 16:25:55','',''),(2197708,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 16:25:55','',''),(2197739,'1','136','779',334,'Retail Sale Id 1296001',3001.60,0.00,0.00,0.00,272.02,'2021-12-07 16:27:14','',''),(2197740,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 16:27:14','',''),(2197765,'1','136','779',334,'Retail Sale Id 1296018',998.40,0.00,0.00,0.00,90.48,'2021-12-07 16:28:25','',''),(2197766,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 16:28:25','',''),(2197799,'1','136','779',334,'Retail Sale Id 1296034',998.40,0.00,0.00,0.00,90.48,'2021-12-07 16:29:58','',''),(2197800,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 16:29:58','',''),(2197936,'1','136','779',334,'Retail Sale Id 1296107',2003.20,0.00,0.00,0.00,181.54,'2021-12-07 16:36:59','',''),(2197937,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 16:36:59','',''),(2197946,'1','136','779',334,'Retail Sale Id 1296111',2502.40,0.00,0.00,0.00,226.78,'2021-12-07 16:37:56','',''),(2197947,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-07 16:37:56','',''),(2198014,'1','136','779',334,'Retail Sale Id 1296146',998.40,0.00,0.00,0.00,90.48,'2021-12-07 16:42:40','',''),(2198015,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 16:42:40','',''),(2198232,'1','136','779',334,'Retail Sale Id 1296260',998.40,0.00,0.00,0.00,90.48,'2021-12-07 16:54:56','',''),(2198233,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 16:54:56','',''),(2198274,'1','136','779',334,'Retail Sale Id 1296280',8000.00,0.00,0.00,0.00,725.00,'2021-12-07 16:56:48','',''),(2198275,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:56:48','',''),(2198335,'1','136','779',334,'Retail Sale Id 1296315',4998.40,0.00,0.00,0.00,452.98,'2021-12-07 16:59:56','',''),(2198336,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-07 16:59:56','',''),(2198367,'1','136','779',334,'Retail Sale Id 1296328',4000.00,0.00,0.00,0.00,362.50,'2021-12-07 17:01:21','',''),(2198368,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 17:01:21','',''),(2200048,'1','136','779',334,'Retail Sale Id 1296922',302280.00,0.00,0.00,0.00,9068.40,'2021-12-08 06:40:01','',''),(2200049,'1','136','779',334,'Retail sales',0.00,0.00,0.00,503.80,0.00,'2021-12-08 06:40:01','',''),(2200062,'1','136','779',334,'Retail Sale Id 1296928',1299.20,0.00,0.00,0.00,117.74,'2021-12-08 06:41:01','',''),(2200063,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-08 06:41:01','',''),(2200091,'1','136','779',334,'Retail Sale Id 1296937',4000.00,0.00,0.00,0.00,362.50,'2021-12-08 06:42:32','',''),(2200092,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 06:42:32','',''),(2200101,'1','136','779',334,'Retail Sale Id 1296941',3200.00,0.00,0.00,0.00,290.00,'2021-12-08 06:43:31','',''),(2200102,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 06:43:31','',''),(2200121,'1','136','779',334,'Retail Sale Id 1296951',6003.20,0.00,0.00,0.00,544.04,'2021-12-08 06:44:25','',''),(2200122,'1','136','779',334,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-08 06:44:25','',''),(2200137,'1','136','779',334,'Retail Sale Id 1296959',2003.20,0.00,0.00,0.00,181.54,'2021-12-08 06:45:14','',''),(2200138,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 06:45:14','',''),(2200165,'1','136','779',334,'Retail Sale Id 1296967',998.40,0.00,0.00,0.00,90.48,'2021-12-08 06:46:10','',''),(2200166,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 06:46:10','',''),(2200409,'1','136','779',334,'Return of Retail Sale Id 1296951',0.00,6003.20,9.38,0.00,-544.04,'2021-12-08 06:58:36','',''),(2201393,'1','136',NULL,334,'Purchased from AA RANO NIGERIA LIMITED',0.00,3232320.00,5460.00,0.00,0.00,'2021-12-08 07:53:20','',''),(2201444,'1','136',NULL,334,'Reception corrector for bridging 126555',0.00,0.00,0.00,5460.00,0.00,'2021-12-08 07:54:39','',''),(2201445,'1','136','779',334,'Received from bridging 126555',0.00,0.00,5460.00,0.00,0.00,'2021-12-08 07:54:39','',''),(2201460,'1','136','779',334,'Retail Sale Id 1297537',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 07:55:19','',''),(2201461,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 07:55:19','',''),(2201569,'1','136','779',334,'Retail Sale Id 1297588',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 08:01:11','',''),(2201570,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 08:01:11','',''),(2201591,'1','136','779',334,'Retail Sale Id 1297601',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 08:02:22','',''),(2201592,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:02:22','',''),(2201671,'1','136','779',334,'Retail Sale Id 1297635',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 08:06:09','',''),(2201672,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:06:09','',''),(2201683,'1','136','779',334,'Retail Sale Id 1297644',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 08:07:01','',''),(2201684,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 08:07:01','',''),(2201772,'1','136','779',334,'Retail Sale Id 1297691',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 08:14:08','',''),(2201773,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 08:14:08','',''),(2201784,'1','136','779',334,'Retail Sale Id 1297698',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 08:14:50','',''),(2201785,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:14:50','',''),(2201807,'1','136','779',334,'Retail Sale Id 1297714',15000.00,0.00,0.00,0.00,200.00,'2021-12-08 08:16:27','',''),(2201808,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 08:16:27','',''),(2201901,'1','136','779',334,'Retail Sale Id 1297759',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 08:21:58','',''),(2201902,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:21:58','',''),(2201947,'1','136','779',334,'Retail Sale Id 1297784',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 08:25:22','',''),(2201948,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 08:25:22','',''),(2201981,'1','136','779',334,'Retail Sale Id 1297800',10560.00,0.00,0.00,0.00,792.00,'2021-12-08 08:27:11','',''),(2201982,'1','136','779',334,'Retail sales',0.00,0.00,0.00,16.50,0.00,'2021-12-08 08:27:11','',''),(2202038,'1','136','779',334,'Retail Sale Id 1297824',78476.80,0.00,0.00,0.00,5885.76,'2021-12-08 08:31:09','',''),(2202039,'1','136','779',334,'Retail sales',0.00,0.00,0.00,122.62,0.00,'2021-12-08 08:31:09','',''),(2202078,'1','136','779',334,'Retail Sale Id 1297837',72000.00,0.00,0.00,0.00,960.00,'2021-12-08 08:33:39','',''),(2202079,'1','136','779',334,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-08 08:33:39','',''),(2202098,'1','136','779',334,'Retail Sale Id 1297850',30000.00,0.00,0.00,0.00,400.00,'2021-12-08 08:35:10','',''),(2202099,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 08:35:10','',''),(2202468,'1','136','779',334,'Retail Sale Id 1297972',60000.00,0.00,0.00,0.00,800.00,'2021-12-08 08:51:12','',''),(2202469,'1','136','779',334,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-08 08:51:12','',''),(2202502,'1','136','779',334,'Retail Sale Id 1297991',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 08:52:51','',''),(2202503,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 08:52:51','',''),(2202520,'1','136','779',334,'Retail Sale Id 1298004',2598.40,0.00,0.00,0.00,194.88,'2021-12-08 08:54:05','',''),(2202521,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-08 08:54:05','',''),(2202548,'1','136','779',334,'Retail Sale Id 1298017',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 08:55:21','',''),(2202549,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:55:21','',''),(2202652,'1','136','779',334,'Retail Sale Id 1298062',2099.20,0.00,0.00,0.00,157.44,'2021-12-08 09:01:52','',''),(2202653,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.28,0.00,'2021-12-08 09:01:52','',''),(2202668,'1','136','779',334,'Retail Sale Id 1298069',800.00,0.00,0.00,0.00,60.00,'2021-12-08 09:03:00','',''),(2202669,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-08 09:03:00','',''),(2202688,'1','136','779',334,'Retail Sale Id 1298080',6400.00,0.00,0.00,0.00,480.00,'2021-12-08 09:04:08','',''),(2202689,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 09:04:08','',''),(2202712,'1','136','779',334,'Retail Sale Id 1298092',998.40,0.00,0.00,0.00,74.88,'2021-12-08 09:05:10','',''),(2202713,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 09:05:10','',''),(2202748,'1','136','779',334,'Retail Sale Id 1298121',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 09:07:24','',''),(2202749,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 09:07:24','',''),(2202803,'1','136','779',334,'Retail Sale Id 1298150',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 09:10:52','',''),(2202804,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 09:10:52','',''),(2203083,'1','136','779',334,'Retail Sale Id 1298277',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 09:30:27','',''),(2203084,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 09:30:27','',''),(2203093,'1','136','779',334,'Retail Sale Id 1298283',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 09:31:29','',''),(2203094,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 09:31:29','',''),(2203229,'1','136','779',334,'Retail Sale Id 1298351',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 09:42:20','',''),(2203230,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 09:42:20','',''),(2203255,'1','136','779',334,'Retail Sale Id 1298364',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 09:44:46','',''),(2203256,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:44:46','',''),(2203267,'1','136','779',334,'Retail Sale Id 1298372',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 09:45:43','',''),(2203268,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 09:45:43','',''),(2203281,'1','136','779',334,'Retail Sale Id 1298379',998.40,0.00,0.00,0.00,74.88,'2021-12-08 09:46:41','',''),(2203282,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 09:46:41','',''),(2203310,'1','136','779',334,'Retail Sale Id 1298393',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 09:48:14','',''),(2203311,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:48:14','',''),(2203376,'1','136','779',334,'Retail Sale Id 1298417',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 09:51:51','',''),(2203377,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:51:51','',''),(2203388,'1','136','779',334,'Retail Sale Id 1298424',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 09:53:51','',''),(2203389,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 09:53:51','',''),(2203400,'1','136','779',334,'Retail Sale Id 1298432',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 09:54:54','',''),(2203401,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 09:54:54','',''),(2203438,'1','136','779',334,'Retail Sale Id 1298445',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 09:57:19','',''),(2203439,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:57:19','',''),(2203457,'1','136','779',334,'Retail Sale Id 1298459',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 09:59:02','',''),(2203458,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:59:02','',''),(2203511,'1','136','779',334,'Retail Sale Id 1298474',15000.00,0.00,0.00,0.00,200.00,'2021-12-08 10:02:18','',''),(2203512,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 10:02:18','',''),(2203542,'1','136','779',334,'Retail Sale Id 1298490',7500.80,0.00,0.00,0.00,562.56,'2021-12-08 10:04:27','',''),(2203543,'1','136','779',334,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-08 10:04:27','',''),(2203557,'1','136','779',334,'Retail Sale Id 1298498',10598.40,0.00,0.00,0.00,794.88,'2021-12-08 10:05:41','',''),(2203558,'1','136','779',334,'Retail sales',0.00,0.00,0.00,16.56,0.00,'2021-12-08 10:05:41','',''),(2203563,'1','136','779',334,'Retail Sale Id 1298506',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 10:06:29','',''),(2203564,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 10:06:29','',''),(2203584,'1','136','779',334,'Retail Sale Id 1298512',1299.20,0.00,0.00,0.00,97.44,'2021-12-08 10:07:53','',''),(2203585,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-08 10:07:53','',''),(2203653,'1','136','779',334,'Retail Sale Id 1298541',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 10:11:58','',''),(2203654,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:11:58','',''),(2203725,'1','136','779',334,'Retail Sale Id 1298580',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 10:15:57','',''),(2203726,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 10:15:57','',''),(2203751,'1','136','779',334,'Retail Sale Id 1298587',28200.00,0.00,0.00,0.00,376.00,'2021-12-08 10:17:03','',''),(2203752,'1','136','779',334,'Retail sales',0.00,0.00,0.00,47.00,0.00,'2021-12-08 10:17:03','',''),(2203761,'1','136','779',334,'Retail Sale Id 1298595',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 10:18:35','',''),(2203762,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 10:18:35','',''),(2203779,'1','136','779',334,'Retail Sale Id 1298599',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 10:19:25','',''),(2203780,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 10:19:25','',''),(2203823,'1','136','779',334,'Retail Sale Id 1298622',43200.00,0.00,0.00,0.00,3240.00,'2021-12-08 10:22:54','',''),(2203824,'1','136','779',334,'Retail sales',0.00,0.00,0.00,67.50,0.00,'2021-12-08 10:22:54','',''),(2203899,'1','136','779',334,'Retail Sale Id 1298664',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 10:26:33','',''),(2203900,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 10:26:33','',''),(2203941,'1','136','779',334,'Retail Sale Id 1298676',4480.00,0.00,0.00,0.00,336.00,'2021-12-08 10:28:57','',''),(2203942,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 10:28:57','',''),(2203981,'1','136','779',334,'Retail Sale Id 1298694',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 10:31:16','',''),(2203982,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 10:31:16','',''),(2204021,'1','136','779',334,'Retail Sale Id 1298712',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 10:33:54','',''),(2204022,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 10:33:55','',''),(2204033,'1','136','779',334,'Retail Sale Id 1298718',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 10:34:23','',''),(2204034,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 10:34:23','',''),(2204051,'1','136','779',334,'Retail Sale Id 1298727',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 10:36:18','',''),(2204052,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 10:36:18','',''),(2204083,'1','136','779',334,'Retail Sale Id 1298747',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 10:39:35','',''),(2204084,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 10:39:35','',''),(2204149,'1','136','779',334,'Retail Sale Id 1298781',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 10:45:09','',''),(2204150,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:45:09','',''),(2204184,'1','136','779',334,'Retail Sale Id 1298797',120000.00,0.00,0.00,0.00,1600.00,'2021-12-08 10:48:42','',''),(2204185,'1','136','779',334,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-08 10:48:42','',''),(2204192,'1','136','779',334,'Retail Sale Id 1298800',998.40,0.00,0.00,0.00,74.88,'2021-12-08 10:49:37','',''),(2204193,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 10:49:37','',''),(2204210,'1','136','779',334,'Retail Sale Id 1298812',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 10:51:07','',''),(2204211,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 10:51:07','',''),(2204224,'1','136','779',334,'Retail Sale Id 1298819',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 10:52:15','',''),(2204225,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 10:52:15','',''),(2204280,'1','136','779',334,'Retail Sale Id 1298845',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 10:56:38','',''),(2204281,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:56:38','',''),(2204398,'1','136','779',334,'Retail Sale Id 1298904',2598.40,0.00,0.00,0.00,194.88,'2021-12-08 11:06:07','',''),(2204399,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-08 11:06:07','',''),(2204484,'1','136','779',334,'Retail Sale Id 1298951',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 11:10:35','',''),(2204485,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 11:10:35','',''),(2204508,'1','136','779',334,'Retail Sale Id 1298964',150000.00,0.00,0.00,0.00,2000.00,'2021-12-08 11:12:25','',''),(2204509,'1','136','779',334,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-08 11:12:25','',''),(2204578,'1','136','779',334,'Retail Sale Id 1299001',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 11:17:57','',''),(2204579,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:17:57','',''),(2204674,'1','136','779',334,'Retail Sale Id 1299046',7040.00,0.00,0.00,0.00,528.00,'2021-12-08 11:24:30','',''),(2204675,'1','136','779',334,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-08 11:24:30','',''),(2204708,'1','136','779',334,'Retail Sale Id 1299068',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 11:27:29','',''),(2204709,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 11:27:29','',''),(2204790,'1','136','779',334,'Retail Sale Id 1299111',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 11:33:43','',''),(2204791,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 11:33:43','',''),(2204863,'1','136','779',334,'Retail Sale Id 1299147',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 11:38:07','',''),(2204865,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:38:07','',''),(2204908,'1','136','779',334,'Retail Sale Id 1299167',9600.00,0.00,0.00,0.00,720.00,'2021-12-08 11:39:27','',''),(2204909,'1','136','779',334,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-08 11:39:27','',''),(2204928,'1','136','779',334,'Retail Sale Id 1299176',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 11:40:40','',''),(2204929,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 11:40:40','',''),(2204942,'1','136','779',334,'Retail Sale Id 1299190',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 11:41:21','',''),(2204943,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 11:41:21','',''),(2205589,'1','136','779',334,'Retail Sale Id 1299490',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 12:31:07','',''),(2205590,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 12:31:07','',''),(2205613,'1','136','779',334,'Retail Sale Id 1299500',127500.00,0.00,0.00,0.00,1700.00,'2021-12-08 12:33:20','',''),(2205614,'1','136','779',334,'Retail sales',0.00,0.00,0.00,212.50,0.00,'2021-12-08 12:33:20','',''),(2205630,'1','136','779',334,'Retail Sale Id 1299506',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 12:34:07','',''),(2205631,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:34:07','',''),(2205638,'1','136','779',334,'Retail Sale Id 1299510',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 12:34:49','',''),(2205639,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 12:34:49','',''),(2205688,'1','136','779',334,'Retail Sale Id 1299536',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 12:38:34','',''),(2205689,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:38:34','',''),(2205706,'1','136','779',334,'Retail Sale Id 1299544',998.40,0.00,0.00,0.00,74.88,'2021-12-08 12:39:33','',''),(2205707,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 12:39:33','',''),(2205790,'1','136','779',334,'Retail Sale Id 1299582',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 12:44:41','',''),(2205791,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 12:44:41','',''),(2205943,'1','136','779',334,'Retail Sale Id 1299640',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 12:51:40','',''),(2205944,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 12:51:40','',''),(2205957,'1','136','779',334,'Return of Retail Sale Id 1298904',0.00,2598.40,4.06,0.00,-194.88,'2021-12-08 12:52:49','',''),(2205995,'1','136','779',334,'Retail Sale Id 1299665',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 12:56:32','',''),(2205996,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:56:32','',''),(2206007,'1','136','779',334,'Retail Sale Id 1299671',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 12:57:19','',''),(2206008,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 12:57:19','',''),(2206056,'1','136','779',334,'Retail Sale Id 1299688',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 13:01:09','',''),(2206057,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 13:01:09','',''),(2206102,'1','136','779',334,'Retail Sale Id 1299710',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 13:04:33','',''),(2206104,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:04:33','',''),(2206205,'1','136','779',334,'Retail Sale Id 1299760',2598.40,0.00,0.00,0.00,194.88,'2021-12-08 13:11:46','',''),(2206206,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-08 13:11:46','',''),(2206221,'1','136','779',334,'Retail Sale Id 1299769',30000.00,0.00,0.00,0.00,400.00,'2021-12-08 13:12:51','',''),(2206222,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 13:12:51','',''),(2206255,'1','136','779',334,'Retail Sale Id 1299783',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 13:14:18','',''),(2206256,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 13:14:18','',''),(2206299,'1','136','779',334,'Retail Sale Id 1299801',2502.40,0.00,0.00,0.00,187.68,'2021-12-08 13:17:12','',''),(2206300,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-08 13:17:12','',''),(2206325,'1','136','779',334,'Retail Sale Id 1299814',2502.40,0.00,0.00,0.00,187.68,'2021-12-08 13:18:47','',''),(2206326,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-08 13:18:47','',''),(2206359,'1','136','779',334,'Retail Sale Id 1299837',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 13:21:58','',''),(2206360,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:21:58','',''),(2206405,'1','136','779',334,'Retail Sale Id 1299860',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 13:25:38','',''),(2206406,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:25:38','',''),(2206455,'1','136','779',334,'Retail Sale Id 1299884',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 13:28:50','',''),(2206456,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:28:50','',''),(2206467,'1','136','779',334,'Retail Sale Id 1299891',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 13:29:39','',''),(2206468,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 13:29:39','',''),(2206656,'1','136','779',334,'Retail Sale Id 1299961',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 13:39:56','',''),(2206657,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 13:39:56','',''),(2206662,'1','136','779',334,'Retail Sale Id 1299965',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 13:40:29','',''),(2206663,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 13:40:29','',''),(2206712,'1','136','779',334,'Retail Sale Id 1299983',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 13:42:22','',''),(2206713,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 13:42:22','',''),(2206724,'1','136','779',334,'Retail Sale Id 1299988',998.40,0.00,0.00,0.00,74.88,'2021-12-08 13:43:02','',''),(2206725,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 13:43:02','',''),(2206781,'1','136','779',334,'Retail Sale Id 1300008',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 13:45:30','',''),(2206782,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 13:45:30','',''),(2206818,'1','136','779',334,'Retail Sale Id 1300019',2598.40,0.00,0.00,0.00,194.88,'2021-12-08 13:47:12','',''),(2206819,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-08 13:47:12','',''),(2206846,'1','136','779',334,'Retail Sale Id 1300027',998.40,0.00,0.00,0.00,74.88,'2021-12-08 13:48:33','',''),(2206847,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 13:48:33','',''),(2206991,'1','136','779',334,'Retail Sale Id 1300090',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 13:57:49','',''),(2206992,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 13:57:49','',''),(2207010,'1','136','779',334,'Retail Sale Id 1300099',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 13:58:49','',''),(2207011,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:58:49','',''),(2207031,'1','136','779',334,'Retail Sale Id 1300104',7500.80,0.00,0.00,0.00,562.56,'2021-12-08 14:00:50','',''),(2207032,'1','136','779',334,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-08 14:00:50','',''),(2207065,'1','136','779',334,'Retail Sale Id 1300124',532220.00,0.00,0.00,0.00,5340.00,'2021-12-08 14:03:05','',''),(2207066,'1','136','779',334,'Retail sales',0.00,0.00,0.00,890.00,0.00,'2021-12-08 14:03:05','',''),(2207123,'1','136','779',334,'Retail Sale Id 1300146',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 14:07:27','',''),(2207124,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 14:07:27','',''),(2207169,'1','136','779',334,'Retail Sale Id 1300164',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 14:09:27','',''),(2207170,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 14:09:27','',''),(2207224,'1','136','779',334,'Retail Sale Id 1300189',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 14:13:37','',''),(2207225,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 14:13:37','',''),(2207235,'1','136','779',334,'Retail Sale Id 1300196',998.40,0.00,0.00,0.00,74.88,'2021-12-08 14:14:29','',''),(2207236,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 14:14:29','',''),(2207269,'1','136','779',334,'Retail Sale Id 1300217',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 14:16:27','',''),(2207270,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 14:16:27','',''),(2207311,'1','136','779',334,'Retail Sale Id 1300237',3500.80,0.00,0.00,0.00,262.56,'2021-12-08 14:18:56','',''),(2207312,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-08 14:18:56','',''),(2207329,'1','136','779',334,'Retail Sale Id 1300250',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 14:20:04','',''),(2207330,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 14:20:04','',''),(2207351,'1','136','779',334,'Retail Sale Id 1300268',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 14:20:56','',''),(2207352,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 14:20:56','',''),(2207381,'1','136','779',334,'Retail Sale Id 1300285',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 14:23:03','',''),(2207382,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 14:23:03','',''),(2207460,'1','136','779',334,'Retail Sale Id 1300318',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 14:26:58','',''),(2207461,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 14:26:58','',''),(2207535,'1','136','779',334,'Retail Sale Id 1300347',1299.20,0.00,0.00,0.00,97.44,'2021-12-08 14:30:07','',''),(2207536,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-08 14:30:07','',''),(2207708,'1','136','779',334,'Retail Sale Id 1300418',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 14:37:28','',''),(2207709,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 14:37:28','',''),(2207730,'1','136','779',334,'Retail Sale Id 1300431',33000.00,0.00,0.00,0.00,440.00,'2021-12-08 14:38:51','',''),(2207731,'1','136','779',334,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-08 14:38:51','',''),(2207744,'1','136','779',334,'Retail Sale Id 1300438',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 14:39:45','',''),(2207745,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 14:39:45','',''),(2208217,'1','136','779',334,'Retail Sale Id 1300666',6400.00,0.00,0.00,0.00,480.00,'2021-12-08 15:10:04','',''),(2208218,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 15:10:04','',''),(2208379,'1','136','779',334,'Retail Sale Id 1300745',19998.00,0.00,0.00,0.00,266.64,'2021-12-08 15:18:39','',''),(2208380,'1','136','779',334,'Retail sales',0.00,0.00,0.00,33.33,0.00,'2021-12-08 15:18:39','',''),(2208586,'1','136','779',334,'Retail Sale Id 1300843',12000.00,0.00,0.00,0.00,160.00,'2021-12-08 15:28:49','',''),(2208587,'1','136','779',334,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-08 15:28:49','',''),(2208617,'1','136','779',334,'Retail Sale Id 1300857',1798.40,0.00,0.00,0.00,134.88,'2021-12-08 15:30:36','',''),(2208618,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-08 15:30:36','',''),(2208765,'1','136','779',334,'Retail Sale Id 1300940',2502.40,0.00,0.00,0.00,187.68,'2021-12-08 15:37:55','',''),(2208766,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-08 15:37:55','',''),(2209508,'1','136','779',334,'Retail Sale Id 1301305',16000.00,0.00,0.00,0.00,1200.00,'2021-12-08 16:14:42','',''),(2209509,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 16:14:42','',''),(2210083,'1','136','779',334,'Retail Sale Id 1301690',7040.00,0.00,0.00,0.00,528.00,'2021-12-08 16:41:40','',''),(2210084,'1','136','779',334,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-08 16:41:40','',''),(2210119,'1','136','779',334,'Retail Sale Id 1301709',5120.00,0.00,0.00,0.00,384.00,'2021-12-08 16:43:22','',''),(2210120,'1','136','779',334,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-08 16:43:22','',''),(2210209,'1','136','779',334,'Retail Sale Id 1301756',14400.00,0.00,0.00,0.00,1080.00,'2021-12-08 16:47:55','',''),(2210210,'1','136','779',334,'Retail sales',0.00,0.00,0.00,22.50,0.00,'2021-12-08 16:47:55','',''),(2210237,'1','136','779',334,'Retail Sale Id 1301769',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 16:49:31','',''),(2210238,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 16:49:31','',''),(2210340,'1','136','779',334,'Retail Sale Id 1301824',3699.20,0.00,0.00,0.00,277.44,'2021-12-08 16:55:10','',''),(2210341,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.78,0.00,'2021-12-08 16:55:10','',''),(2210670,'1','136','779',334,'Retail Sale Id 1302014',113919.00,0.00,0.00,0.00,1143.00,'2021-12-08 17:24:20','',''),(2210671,'1','136','779',334,'Retail sales',0.00,0.00,0.00,190.50,0.00,'2021-12-08 17:24:20','',''),(2211768,'1','136','779',334,'Retail Sale Id 1302267',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 05:37:41','',''),(2211769,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 05:37:41','',''),(2211774,'1','136','779',334,'Retail Sale Id 1302270',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 05:39:44','',''),(2211775,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 05:39:44','',''),(2211794,'1','136','779',334,'Retail Sale Id 1302273',22500.00,0.00,0.00,0.00,300.00,'2021-12-09 05:44:09','',''),(2211795,'1','136','779',334,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-09 05:44:09','',''),(2211802,'1','136','779',334,'Retail Sale Id 1302276',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 05:46:38','',''),(2211803,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 05:46:38','',''),(2211964,'1','136','779',334,'Retail Sale Id 1302355',1299.20,0.00,0.00,0.00,97.44,'2021-12-09 06:07:28','',''),(2211965,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-09 06:07:28','',''),(2212097,'1','136','779',334,'Retail Sale Id 1302418',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 06:18:26','',''),(2212098,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 06:18:26','',''),(2212185,'1','136','779',334,'Retail Sale Id 1302449',2598.40,0.00,0.00,0.00,194.88,'2021-12-09 06:23:14','',''),(2212186,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-09 06:23:14','',''),(2212290,'1','136','779',334,'Retail Sale Id 1302503',2598.40,0.00,0.00,0.00,194.88,'2021-12-09 06:30:16','',''),(2212291,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-09 06:30:16','',''),(2212538,'1','136','779',334,'Retail Sale Id 1302608',16000.00,0.00,0.00,0.00,1200.00,'2021-12-09 06:44:07','',''),(2212539,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-09 06:44:07','',''),(2212728,'1','136','779',334,'Retail Sale Id 1302696',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 06:54:27','',''),(2212729,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 06:54:27','',''),(2212770,'1','136','779',334,'Retail Sale Id 1302713',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 06:56:50','',''),(2212771,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 06:56:50','',''),(2212878,'1','136','779',334,'Retail Sale Id 1302763',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 07:02:21','',''),(2212879,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 07:02:21','',''),(2212886,'1','136','779',334,'Retail Sale Id 1302767',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 07:03:09','',''),(2212887,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:03:09','',''),(2212933,'1','136','779',334,'Retail Sale Id 1302789',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 07:05:55','',''),(2212934,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 07:05:55','',''),(2213095,'1','136','779',334,'Retail Sale Id 1302861',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 07:14:21','',''),(2213096,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 07:14:21','',''),(2213145,'1','136','779',334,'Retail Sale Id 1302884',9600.00,0.00,0.00,0.00,720.00,'2021-12-09 07:16:05','',''),(2213146,'1','136','779',334,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-09 07:16:05','',''),(2213176,'1','136','779',334,'Retail Sale Id 1302896',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 07:17:04','',''),(2213177,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 07:17:04','',''),(2213268,'1','136','779',334,'Retail Sale Id 1302938',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 07:20:49','',''),(2213269,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 07:20:49','',''),(2213304,'1','136','779',334,'Retail Sale Id 1302956',800.00,0.00,0.00,0.00,60.00,'2021-12-09 07:22:01','',''),(2213305,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-09 07:22:01','',''),(2213332,'1','136','779',334,'Retail Sale Id 1302973',998.40,0.00,0.00,0.00,74.88,'2021-12-09 07:23:32','',''),(2213333,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 07:23:32','',''),(2213348,'1','136','779',334,'Retail Sale Id 1302981',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 07:24:19','',''),(2213349,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 07:24:19','',''),(2213362,'1','136','779',334,'Retail Sale Id 1302987',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 07:25:15','',''),(2213363,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 07:25:15','',''),(2213418,'1','136','779',334,'Retail Sale Id 1303015',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 07:27:59','',''),(2213419,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:27:59','',''),(2213618,'1','136','779',334,'Retail Sale Id 1303114',2598.40,0.00,0.00,0.00,194.88,'2021-12-09 07:37:21','',''),(2213619,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-09 07:37:21','',''),(2213880,'1','136','779',334,'Retail Sale Id 1303238',2598.40,0.00,0.00,0.00,194.88,'2021-12-09 07:50:49','',''),(2213881,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-09 07:50:49','',''),(2213978,'1','136','779',334,'Retail Sale Id 1303284',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 07:55:28','',''),(2213979,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:55:28','',''),(2213992,'1','136','779',334,'Retail Sale Id 1303290',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 07:56:10','',''),(2213993,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 07:56:10','',''),(2214036,'1','136','779',334,'Retail Sale Id 1303315',998.40,0.00,0.00,0.00,74.88,'2021-12-09 07:59:23','',''),(2214037,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 07:59:23','',''),(2214064,'1','136','779',334,'Retail Sale Id 1303333',150000.00,0.00,0.00,0.00,2000.00,'2021-12-09 08:01:24','',''),(2214065,'1','136','779',334,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-09 08:01:24','',''),(2214112,'1','136','779',334,'Retail Sale Id 1303358',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 08:04:15','',''),(2214113,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 08:04:15','',''),(2214172,'1','136','779',334,'Retail Sale Id 1303388',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 08:07:17','',''),(2214173,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 08:07:17','',''),(2214284,'1','136','779',334,'Retail Sale Id 1303447',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 08:13:07','',''),(2214285,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 08:13:07','',''),(2214450,'1','136','779',334,'Retail Sale Id 1303527',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 08:21:57','',''),(2214451,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:21:57','',''),(2214539,'1','136','779',334,'Retail Sale Id 1303552',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 08:25:01','',''),(2214540,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 08:25:01','',''),(2214693,'1','136','779',334,'Retail Sale Id 1303613',4499.20,0.00,0.00,0.00,337.44,'2021-12-09 08:31:06','',''),(2214694,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-09 08:31:06','',''),(2214819,'1','136','779',334,'Retail Sale Id 1303681',1299.20,0.00,0.00,0.00,97.44,'2021-12-09 08:38:12','',''),(2214820,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-09 08:38:12','',''),(2214853,'1','136','779',334,'Retail Sale Id 1303695',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 08:39:09','',''),(2214854,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 08:39:09','',''),(2214891,'1','136','779',334,'Retail Sale Id 1303715',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 08:40:39','',''),(2214892,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 08:40:39','',''),(2215042,'1','136','779',334,'Retail Sale Id 1303778',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 08:47:45','',''),(2215043,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 08:47:45','',''),(2215088,'1','136','779',334,'Retail Sale Id 1303803',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 08:51:21','',''),(2215089,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 08:51:21','',''),(2215226,'1','136','779',334,'Retail Sale Id 1303876',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 09:00:23','',''),(2215227,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:00:23','',''),(2215254,'1','136','779',334,'Retail Sale Id 1303891',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 09:01:21','',''),(2215255,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:01:21','',''),(2215281,'1','136','779',334,'Retail Sale Id 1303903',16000.00,0.00,0.00,0.00,1200.00,'2021-12-09 09:02:32','',''),(2215282,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-09 09:02:32','',''),(2215384,'1','136','779',334,'Retail Sale Id 1303956',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 09:09:11','',''),(2215385,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:09:11','',''),(2215460,'1','136','779',334,'Retail Sale Id 1303996',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 09:14:20','',''),(2215461,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 09:14:20','',''),(2215474,'1','136','779',334,'Retail Sale Id 1304003',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 09:15:09','',''),(2215475,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 09:15:09','',''),(2215541,'1','136','779',334,'Retail Sale Id 1304037',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 09:19:31','',''),(2215542,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:19:31','',''),(2215585,'1','136','779',334,'Retail Sale Id 1304059',21760.00,0.00,0.00,0.00,1632.00,'2021-12-09 09:21:28','',''),(2215586,'1','136','779',334,'Retail sales',0.00,0.00,0.00,34.00,0.00,'2021-12-09 09:21:28','',''),(2215601,'1','136','779',334,'Retail Sale Id 1304068',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 09:22:34','',''),(2215602,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 09:22:34','',''),(2215680,'1','136','779',334,'Retail Sale Id 1304106',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 09:26:17','',''),(2215681,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 09:26:17','',''),(2215770,'1','136','779',334,'Retail Sale Id 1304148',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 09:31:42','',''),(2215771,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:31:42','',''),(2215905,'1','136','779',334,'Retail Sale Id 1304206',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 09:36:59','',''),(2215906,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 09:36:59','',''),(2215929,'1','136','779',334,'Retail Sale Id 1304220',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 09:37:52','',''),(2215930,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 09:37:52','',''),(2215939,'1','136','779',334,'Retail Sale Id 1304227',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 09:38:50','',''),(2215940,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 09:38:50','',''),(2215964,'1','136','779',334,'Retail Sale Id 1304237',2598.40,0.00,0.00,0.00,194.88,'2021-12-09 09:40:27','',''),(2215965,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-09 09:40:27','',''),(2215998,'1','136','779',334,'Retail Sale Id 1304244',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 09:41:26','',''),(2215999,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:41:26','',''),(2216354,'1','136','779',334,'Retail Sale Id 1304391',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 09:57:57','',''),(2216355,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 09:57:57','',''),(2216440,'1','136','779',334,'Retail Sale Id 1304426',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 10:02:05','',''),(2216441,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 10:02:05','',''),(2216521,'1','136','779',334,'Retail Sale Id 1304469',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 10:06:53','',''),(2216522,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 10:06:53','',''),(2216549,'1','136','779',334,'Retail Sale Id 1304478',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 10:08:14','',''),(2216550,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 10:08:14','',''),(2216625,'1','136','779',334,'Retail Sale Id 1304524',7040.00,0.00,0.00,0.00,528.00,'2021-12-09 10:14:30','',''),(2216626,'1','136','779',334,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-09 10:14:30','',''),(2216657,'1','136','779',334,'Retail Sale Id 1304542',30000.00,0.00,0.00,0.00,400.00,'2021-12-09 10:16:56','',''),(2216658,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 10:16:56','',''),(2216679,'1','136','779',334,'Retail Sale Id 1304557',998.40,0.00,0.00,0.00,74.88,'2021-12-09 10:18:22','',''),(2216680,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 10:18:22','',''),(2216695,'1','136','779',334,'Retail Sale Id 1304563',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 10:19:18','',''),(2216696,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 10:19:18','',''),(2216709,'1','136','779',334,'Retail Sale Id 1304569',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 10:20:24','',''),(2216710,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 10:20:24','',''),(2216831,'1','136','779',334,'Retail Sale Id 1304637',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 10:27:23','',''),(2216832,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 10:27:23','',''),(2216865,'1','136','779',334,'Retail Sale Id 1304654',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 10:29:56','',''),(2216866,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 10:29:56','',''),(2216891,'1','136','779',334,'Retail Sale Id 1304667',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 10:31:11','',''),(2216892,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:31:11','',''),(2216929,'1','136','779',334,'Retail Sale Id 1304687',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 10:33:52','',''),(2216930,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 10:33:52','',''),(2217020,'1','136','779',334,'Retail Sale Id 1304732',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 10:40:55','',''),(2217021,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 10:40:55','',''),(2217250,'1','136','779',334,'Retail Sale Id 1304852',93600.00,0.00,0.00,0.00,1248.00,'2021-12-09 10:55:30','',''),(2217251,'1','136','779',334,'Retail sales',0.00,0.00,0.00,156.00,0.00,'2021-12-09 10:55:30','',''),(2217289,'1','136','779',334,'Retail Sale Id 1304873',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 10:58:40','',''),(2217290,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 10:58:40','',''),(2217313,'1','136','779',334,'Retail Sale Id 1304888',33000.00,0.00,0.00,0.00,440.00,'2021-12-09 11:00:10','',''),(2217314,'1','136','779',334,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-09 11:00:10','',''),(2217338,'1','136','779',334,'Retail Sale Id 1304897',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 11:01:41','',''),(2217339,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 11:01:41','',''),(2217362,'1','136','779',334,'Retail Sale Id 1304907',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 11:03:01','',''),(2217363,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:03:01','',''),(2217432,'1','136','779',334,'Retail Sale Id 1304937',37200.00,0.00,0.00,0.00,496.00,'2021-12-09 11:07:58','',''),(2217433,'1','136','779',334,'Retail sales',0.00,0.00,0.00,62.00,0.00,'2021-12-09 11:07:58','',''),(2217446,'1','136','779',334,'Retail Sale Id 1304948',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 11:08:46','',''),(2217447,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 11:08:46','',''),(2217463,'1','136','779',334,'Retail Sale Id 1304958',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 11:11:03','',''),(2217464,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 11:11:03','',''),(2217574,'1','136','779',334,'Retail Sale Id 1305016',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 11:19:01','',''),(2217575,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:19:01','',''),(2217616,'1','136','779',334,'Retail Sale Id 1305033',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 11:21:18','',''),(2217617,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:21:18','',''),(2217642,'1','136','779',334,'Retail Sale Id 1305043',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 11:21:58','',''),(2217643,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 11:21:58','',''),(2217743,'1','136','779',334,'Retail Sale Id 1305089',24000.00,0.00,0.00,0.00,320.00,'2021-12-09 11:27:45','',''),(2217744,'1','136','779',334,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-09 11:27:45','',''),(2217776,'1','136','779',334,'Retail Sale Id 1305109',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 11:29:32','',''),(2217777,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 11:29:32','',''),(2217809,'1','136','779',334,'Retail Sale Id 1305124',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 11:30:45','',''),(2217810,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 11:30:45','',''),(2217825,'1','136','779',334,'Retail Sale Id 1305131',6400.00,0.00,0.00,0.00,480.00,'2021-12-09 11:32:01','',''),(2217826,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 11:32:01','',''),(2217905,'1','136','779',334,'Retail Sale Id 1305168',7001.60,0.00,0.00,0.00,525.12,'2021-12-09 11:37:12','',''),(2217906,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-09 11:37:12','',''),(2217917,'1','136','779',334,'Retail Sale Id 1305177',7001.60,0.00,0.00,0.00,525.12,'2021-12-09 11:37:58','',''),(2217918,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-09 11:37:58','',''),(2217959,'1','136','779',334,'Retail Sale Id 1305195',998.40,0.00,0.00,0.00,74.88,'2021-12-09 11:41:24','',''),(2217960,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 11:41:24','',''),(2218080,'1','136','779',334,'Retail Sale Id 1305248',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 11:48:34','',''),(2218081,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 11:48:34','',''),(2218096,'1','136','779',334,'Retail Sale Id 1305257',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 11:49:12','',''),(2218097,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 11:49:12','',''),(2218128,'1','136','779',334,'Retail Sale Id 1305278',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 11:50:56','',''),(2218129,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 11:50:56','',''),(2218226,'1','136','779',334,'Retail Sale Id 1305331',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 11:58:01','',''),(2218227,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 11:58:01','',''),(2218308,'1','136','779',334,'Retail Sale Id 1305374',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 12:02:58','',''),(2218309,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 12:02:58','',''),(2218318,'1','136','779',334,'Retail Sale Id 1305380',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 12:03:54','',''),(2218319,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 12:03:54','',''),(2218407,'1','136','779',334,'Retail Sale Id 1305428',998.40,0.00,0.00,0.00,74.88,'2021-12-09 12:10:27','',''),(2218408,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 12:10:27','',''),(2218507,'1','136','779',334,'Retail Sale Id 1305469',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 12:15:21','',''),(2218508,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 12:15:21','',''),(2218762,'1','136','779',334,'Retail Sale Id 1305616',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 12:33:06','',''),(2218763,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 12:33:06','',''),(2218786,'1','136','779',334,'Retail Sale Id 1305627',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 12:34:27','',''),(2218787,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 12:34:27','',''),(2218850,'1','136','779',334,'Retail Sale Id 1305661',998.40,0.00,0.00,0.00,74.88,'2021-12-09 12:38:19','',''),(2218851,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 12:38:19','',''),(2218870,'1','136','779',334,'Retail Sale Id 1305667',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 12:39:40','',''),(2218871,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 12:39:40','',''),(2218926,'1','136','779',334,'Retail Sale Id 1305694',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 12:41:57','',''),(2218927,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 12:41:57','',''),(2219200,'1','136','779',334,'Retail Sale Id 1305836',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 12:56:54','',''),(2219201,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 12:56:54','',''),(2219339,'1','136','779',334,'Retail Sale Id 1305904',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 13:05:55','',''),(2219340,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 13:05:55','',''),(2219353,'1','136','779',334,'Retail Sale Id 1305918',1702.40,0.00,0.00,0.00,127.68,'2021-12-09 13:07:48','',''),(2219354,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-09 13:07:48','',''),(2219369,'1','136','779',334,'Retail Sale Id 1305925',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 13:08:43','',''),(2219370,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 13:08:43','',''),(2219500,'1','136','779',334,'Retail Sale Id 1305974',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 13:16:08','',''),(2219501,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 13:16:08','',''),(2219589,'1','136','779',334,'Retail Sale Id 1306018',998.40,0.00,0.00,0.00,74.88,'2021-12-09 13:24:05','',''),(2219590,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 13:24:05','',''),(2219603,'1','136','779',334,'Retail Sale Id 1306024',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 13:25:13','',''),(2219604,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 13:25:13','',''),(2219716,'1','136','779',334,'Retail Sale Id 1306063',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 13:30:24','',''),(2219717,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 13:30:24','',''),(2219738,'1','136','779',334,'Retail Sale Id 1306070',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 13:31:06','',''),(2219739,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 13:31:06','',''),(2219816,'1','136','779',334,'Retail Sale Id 1306093',2598.40,0.00,0.00,0.00,194.88,'2021-12-09 13:34:27','',''),(2219817,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-09 13:34:27','',''),(2220187,'1','136','779',334,'Retail Sale Id 1306251',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 13:55:25','',''),(2220188,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 13:55:25','',''),(2220272,'1','136','779',334,'Retail Sale Id 1306291',3897.60,0.00,0.00,0.00,292.32,'2021-12-09 14:02:36','',''),(2220273,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-09 14:02:36','',''),(2220286,'1','136','779',334,'Retail Sale Id 1306294',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 14:04:10','',''),(2220287,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 14:04:10','',''),(2220474,'1','136','779',334,'Retail Sale Id 1306410',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 14:14:27','',''),(2220475,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:14:27','',''),(2220498,'1','136','779',334,'Retail Sale Id 1306424',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 14:15:51','',''),(2220499,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 14:15:51','',''),(2220526,'1','136','779',334,'Retail Sale Id 1306440',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 14:17:44','',''),(2220527,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 14:17:44','',''),(2220640,'1','136','779',334,'Retail Sale Id 1306497',1299.20,0.00,0.00,0.00,97.44,'2021-12-09 14:23:46','',''),(2220641,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-09 14:23:46','',''),(2220751,'1','136','779',334,'Retail Sale Id 1306552',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 14:29:18','',''),(2220752,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 14:29:18','',''),(2220864,'1','136','779',334,'Retail Sale Id 1306597',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 14:34:39','',''),(2220865,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 14:34:39','',''),(2220899,'1','136','779',334,'Retail Sale Id 1306613',2598.40,0.00,0.00,0.00,194.88,'2021-12-09 14:35:44','',''),(2220900,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-09 14:35:44','',''),(2220945,'1','136','779',334,'Retail Sale Id 1306629',2598.40,0.00,0.00,0.00,194.88,'2021-12-09 14:36:59','',''),(2220946,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-09 14:36:59','',''),(2220972,'1','136','779',334,'Retail Sale Id 1306643',1600.00,0.00,0.00,0.00,120.00,'2021-12-09 14:38:09','',''),(2220973,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-09 14:38:09','',''),(2221228,'1','136','779',334,'Retail Sale Id 1306765',7001.60,0.00,0.00,0.00,525.12,'2021-12-09 14:49:39','',''),(2221229,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-09 14:49:39','',''),(2221299,'1','136','779',334,'Retail Sale Id 1306778',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 14:50:53','',''),(2221300,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:50:53','',''),(2221343,'1','136','779',334,'Retail Sale Id 1306791',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 14:52:31','',''),(2221344,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 14:52:31','',''),(2221367,'1','136','779',334,'Retail Sale Id 1306804',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 14:53:57','',''),(2221368,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:53:57','',''),(2221402,'1','136','779',334,'Retail Sale Id 1306810',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 14:54:57','',''),(2221403,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 14:54:57','',''),(2221668,'1','136','779',334,'Retail Sale Id 1306944',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 15:09:05','',''),(2221669,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 15:09:05','',''),(2221691,'1','136','779',334,'Retail Sale Id 1306962',24000.00,0.00,0.00,0.00,1800.00,'2021-12-09 15:10:10','',''),(2221692,'1','136','779',334,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-09 15:10:10','',''),(2221771,'1','136','779',334,'Retail Sale Id 1307002',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 15:14:12','',''),(2221772,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 15:14:12','',''),(2221965,'1','136','779',334,'Retail Sale Id 1307101',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 15:24:19','',''),(2221966,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 15:24:19','',''),(2221983,'1','136','779',334,'Retail Sale Id 1307112',1299.20,0.00,0.00,0.00,97.44,'2021-12-09 15:25:15','',''),(2221984,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-09 15:25:15','',''),(2222009,'1','136','779',334,'Retail Sale Id 1307128',6400.00,0.00,0.00,0.00,480.00,'2021-12-09 15:26:27','',''),(2222010,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 15:26:27','',''),(2222057,'1','136','779',334,'Retail Sale Id 1307153',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 15:28:29','',''),(2222058,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 15:28:29','',''),(2222093,'1','136','779',334,'Retail Sale Id 1307169',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 15:30:20','',''),(2222094,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 15:30:20','',''),(2223629,'1','136','779',334,'Retail Sale Id 1307887',300495.00,0.00,0.00,0.00,3015.00,'2021-12-09 16:52:03','',''),(2223630,'1','136','779',334,'Retail sales',0.00,0.00,0.00,502.50,0.00,'2021-12-09 16:52:03','',''),(2223695,'1','136','779',334,'Retail Sale Id 1307916',14227.20,0.00,0.00,0.00,1067.04,'2021-12-09 16:55:44','',''),(2223696,'1','136','779',334,'Retail sales',0.00,0.00,0.00,22.23,0.00,'2021-12-09 16:55:44','',''),(2225553,'1','136',NULL,334,'Purchased from AA RANO NIGERIA LIMITED',0.00,14544180.00,24990.00,0.00,0.00,'2021-12-10 06:46:05','',''),(2225654,'1','136',NULL,334,'Reception corrector for bridging 126826',0.00,0.00,0.00,24990.00,0.00,'2021-12-10 06:52:11','',''),(2225655,'1','136','779',334,'Received from bridging 126826',0.00,0.00,24990.00,0.00,0.00,'2021-12-10 06:52:11','',''),(2225992,'1','136','779',334,'Retail Sale Id 1308797',998.56,0.00,0.00,0.00,63.20,'2021-12-10 07:15:02','',''),(2225993,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 07:15:02','',''),(2226192,'1','136','779',334,'Retail Sale Id 1308900',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 07:25:41','',''),(2226193,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 07:25:41','',''),(2226240,'1','136','779',334,'Retail Sale Id 1308922',3197.92,0.00,0.00,0.00,202.40,'2021-12-10 07:27:24','',''),(2226241,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 07:27:24','',''),(2226279,'1','136','779',334,'Retail Sale Id 1308938',998.56,0.00,0.00,0.00,63.20,'2021-12-10 07:29:20','',''),(2226280,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 07:29:20','',''),(2226393,'1','136','779',334,'Retail Sale Id 1308979',29400.00,0.00,0.00,0.00,-200.00,'2021-12-10 07:35:50','',''),(2226394,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 07:35:50','',''),(2226429,'1','136','779',334,'Retail Sale Id 1309006',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 07:37:57','',''),(2226430,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 07:37:57','',''),(2226467,'1','136','779',334,'Retail Sale Id 1309022',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 07:40:08','',''),(2226468,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 07:40:08','',''),(2226515,'1','136','779',334,'Retail Sale Id 1309048',998.56,0.00,0.00,0.00,63.20,'2021-12-10 07:42:39','',''),(2226516,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 07:42:39','',''),(2226717,'1','136','779',334,'Retail Sale Id 1309134',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 07:52:49','',''),(2226718,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 07:52:49','',''),(2226759,'1','136','779',334,'Retail Sale Id 1309161',79380.00,0.00,0.00,0.00,-540.00,'2021-12-10 07:55:38','',''),(2226760,'1','136','779',334,'Retail sales',0.00,0.00,0.00,135.00,0.00,'2021-12-10 07:55:38','',''),(2226779,'1','136','779',334,'Retail Sale Id 1309171',998.56,0.00,0.00,0.00,63.20,'2021-12-10 07:57:12','',''),(2226780,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 07:57:12','',''),(2227142,'1','136','779',334,'Retail Sale Id 1309301',39690.00,0.00,0.00,0.00,-270.00,'2021-12-10 08:13:06','',''),(2227143,'1','136','779',334,'Retail sales',0.00,0.00,0.00,67.50,0.00,'2021-12-10 08:13:06','',''),(2227271,'1','136','779',334,'Retail Sale Id 1309338',31600.00,0.00,0.00,0.00,2000.00,'2021-12-10 08:19:36','',''),(2227272,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 08:19:36','',''),(2227299,'1','136','779',334,'Retail Sale Id 1309379',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 08:21:14','',''),(2227300,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 08:21:14','',''),(2227362,'1','136','779',334,'Retail Sale Id 1309402',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 08:23:20','',''),(2227363,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:23:20','',''),(2227433,'1','136','779',334,'Retail Sale Id 1309415',4000.56,0.00,0.00,0.00,253.20,'2021-12-10 08:25:26','',''),(2227434,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-10 08:25:26','',''),(2227459,'1','136','779',334,'Retail Sale Id 1309429',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 08:27:25','',''),(2227460,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:27:25','',''),(2227543,'1','136','779',334,'Retail Sale Id 1309482',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 08:31:41','',''),(2227544,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 08:31:41','',''),(2227595,'1','136','779',334,'Retail Sale Id 1309507',4499.84,0.00,0.00,0.00,284.80,'2021-12-10 08:34:14','',''),(2227596,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.12,0.00,'2021-12-10 08:34:14','',''),(2227772,'1','136','779',334,'Retail Sale Id 1309595',29400.00,0.00,0.00,0.00,-200.00,'2021-12-10 08:44:02','',''),(2227773,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 08:44:02','',''),(2227884,'1','136','779',334,'Retail Sale Id 1309638',26461.84,0.00,0.00,0.00,1674.80,'2021-12-10 08:47:32','',''),(2227885,'1','136','779',334,'Retail sales',0.00,0.00,0.00,41.87,0.00,'2021-12-10 08:47:32','',''),(2227910,'1','136','779',334,'Retail Sale Id 1309651',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 08:48:36','',''),(2227911,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 08:48:36','',''),(2227964,'1','136','779',334,'Retail Sale Id 1309671',58800.00,0.00,0.00,0.00,-400.00,'2021-12-10 08:51:07','',''),(2227965,'1','136','779',334,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 08:51:07','',''),(2228138,'1','136','779',334,'Retail Sale Id 1309766',205100.00,0.00,0.00,0.00,-2100.00,'2021-12-10 08:59:26','',''),(2228139,'1','136','779',334,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-10 08:59:26','',''),(2228219,'1','136','779',334,'Retail Sale Id 1309797',29400.00,0.00,0.00,0.00,-200.00,'2021-12-10 09:01:50','',''),(2228220,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 09:01:50','',''),(2228348,'1','136','779',334,'Retail Sale Id 1309862',3197.92,0.00,0.00,0.00,202.40,'2021-12-10 09:09:18','',''),(2228349,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 09:09:18','',''),(2228479,'1','136','779',334,'Retail Sale Id 1309921',3899.44,0.00,0.00,0.00,246.80,'2021-12-10 09:16:17','',''),(2228480,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 09:16:17','',''),(2229190,'1','136','779',334,'Retail Sale Id 1310263',3899.44,0.00,0.00,0.00,246.80,'2021-12-10 09:58:58','',''),(2229191,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-10 09:58:58','',''),(2229216,'1','136','779',334,'Retail Sale Id 1310280',61740.00,0.00,0.00,0.00,-420.00,'2021-12-10 10:00:53','',''),(2229217,'1','136','779',334,'Retail sales',0.00,0.00,0.00,105.00,0.00,'2021-12-10 10:00:53','',''),(2229259,'1','136','779',334,'Retail Sale Id 1310297',2546.96,0.00,0.00,0.00,161.20,'2021-12-10 10:03:23','',''),(2229260,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-10 10:03:23','',''),(2229397,'1','136','779',334,'Retail Sale Id 1310364',11760.00,0.00,0.00,0.00,-80.00,'2021-12-10 10:10:57','',''),(2229398,'1','136','779',334,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-10 10:10:57','',''),(2229437,'1','136','779',334,'Retail Sale Id 1310382',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 10:12:41','',''),(2229438,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 10:12:41','',''),(2229445,'1','136','779',334,'Retail Sale Id 1310386',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 10:13:25','',''),(2229446,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 10:13:25','',''),(2229519,'1','136','779',334,'Retail Sale Id 1310413',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 10:16:12','',''),(2229520,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 10:16:12','',''),(2229601,'1','136','779',334,'Retail Sale Id 1310454',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 10:21:04','',''),(2229602,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 10:21:04','',''),(2229645,'1','136','779',334,'Retail Sale Id 1310475',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 10:23:18','',''),(2229646,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 10:23:18','',''),(2229767,'1','136','779',334,'Retail Sale Id 1310534',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 10:30:24','',''),(2229768,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 10:30:24','',''),(2229789,'1','136','779',334,'Retail Sale Id 1310547',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 10:32:32','',''),(2229790,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 10:32:32','',''),(2229925,'1','136','779',334,'Retail Sale Id 1310605',1801.20,0.00,0.00,0.00,114.00,'2021-12-10 10:40:09','',''),(2229926,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.85,0.00,'2021-12-10 10:40:09','',''),(2229963,'1','136','779',334,'Retail Sale Id 1310623',58800.00,0.00,0.00,0.00,-400.00,'2021-12-10 10:42:53','',''),(2229964,'1','136','779',334,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 10:42:53','',''),(2230228,'1','136','779',334,'Retail Sale Id 1310732',2502.72,0.00,0.00,0.00,158.40,'2021-12-10 10:56:34','',''),(2230229,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-10 10:56:34','',''),(2230242,'1','136','779',334,'Retail Sale Id 1310747',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 10:57:44','',''),(2230243,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 10:57:44','',''),(2230291,'1','136','779',334,'Retail Sale Id 1310770',998.56,0.00,0.00,0.00,63.20,'2021-12-10 11:00:32','',''),(2230292,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 11:00:32','',''),(2230306,'1','136','779',334,'Retail Sale Id 1310778',3160.00,0.00,0.00,0.00,200.00,'2021-12-10 11:01:29','',''),(2230307,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 11:01:29','',''),(2230463,'1','136','779',334,'Retail Sale Id 1310834',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 11:08:46','',''),(2230464,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 11:08:46','',''),(2230526,'1','136','779',334,'Retail Sale Id 1310862',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 11:13:47','',''),(2230527,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 11:13:47','',''),(2230546,'1','136','779',334,'Retail Sale Id 1310873',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 11:15:03','',''),(2230547,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 11:15:03','',''),(2230590,'1','136','779',334,'Retail Sale Id 1310902',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 11:17:38','',''),(2230591,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 11:17:38','',''),(2230783,'1','136','779',334,'Retail Sale Id 1310967',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 11:29:28','',''),(2230784,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 11:29:28','',''),(2230825,'1','136','779',334,'Retail Sale Id 1310994',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 11:32:33','',''),(2230826,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 11:32:33','',''),(2230995,'1','136','779',334,'Retail Sale Id 1311084',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 11:44:13','',''),(2230996,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 11:44:13','',''),(2231027,'1','136','779',334,'Retail Sale Id 1311103',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 11:47:23','',''),(2231028,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 11:47:23','',''),(2231043,'1','136','779',334,'Retail Sale Id 1311109',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 11:48:27','',''),(2231044,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 11:48:27','',''),(2231087,'1','136','779',334,'Retail Sale Id 1311133',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 11:52:03','',''),(2231088,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 11:52:03','',''),(2231181,'1','136','779',334,'Retail Sale Id 1311177',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 11:57:13','',''),(2231182,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 11:57:13','',''),(2231236,'1','136','779',334,'Retail Sale Id 1311209',998.56,0.00,0.00,0.00,63.20,'2021-12-10 12:02:28','',''),(2231237,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 12:02:28','',''),(2231258,'1','136','779',334,'Retail Sale Id 1311217',15800.00,0.00,0.00,0.00,1000.00,'2021-12-10 12:04:07','',''),(2231259,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 12:04:07','',''),(2231284,'1','136','779',334,'Retail Sale Id 1311232',3160.00,0.00,0.00,0.00,200.00,'2021-12-10 12:06:25','',''),(2231285,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 12:06:25','',''),(2231322,'1','136','779',334,'Return of Retail Sale Id 1311217',0.00,15800.00,25.00,0.00,-1000.00,'2021-12-10 12:08:30','',''),(2231333,'1','136','779',334,'Retail Sale Id 1311253',14498.08,0.00,0.00,0.00,917.60,'2021-12-10 12:08:58','',''),(2231334,'1','136','779',334,'Retail sales',0.00,0.00,0.00,22.94,0.00,'2021-12-10 12:08:58','',''),(2231377,'1','136','779',334,'Retail Sale Id 1311272',3160.00,0.00,0.00,0.00,200.00,'2021-12-10 12:11:27','',''),(2231378,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 12:11:27','',''),(2231608,'1','136','779',334,'Retail Sale Id 1311400',205100.00,0.00,0.00,0.00,-2100.00,'2021-12-10 12:33:49','',''),(2231609,'1','136','779',334,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-10 12:33:49','',''),(2231670,'1','136','779',334,'Retail Sale Id 1311444',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 12:40:21','',''),(2231671,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 12:40:21','',''),(2231680,'1','136','779',334,'Retail Sale Id 1311450',2502.72,0.00,0.00,0.00,158.40,'2021-12-10 12:41:11','',''),(2231681,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-10 12:41:11','',''),(2231793,'1','136','779',334,'Retail Sale Id 1311504',3002.00,0.00,0.00,0.00,190.00,'2021-12-10 12:49:43','',''),(2231794,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 12:49:43','',''),(2231812,'1','136','779',334,'Retail Sale Id 1311512',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 12:50:49','',''),(2231813,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 12:50:49','',''),(2231870,'1','136','779',334,'Retail Sale Id 1311538',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 12:54:42','',''),(2231871,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 12:54:42','',''),(2232123,'1','136','779',334,'Retail Sale Id 1311657',3160.00,0.00,0.00,0.00,200.00,'2021-12-10 13:11:05','',''),(2232124,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 13:11:05','',''),(2232262,'1','136','779',334,'Retail Sale Id 1311709',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 13:18:56','',''),(2232263,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:18:56','',''),(2232375,'1','136','779',334,'Retail Sale Id 1311755',24108.00,0.00,0.00,0.00,-164.00,'2021-12-10 13:24:37','',''),(2232376,'1','136','779',334,'Retail sales',0.00,0.00,0.00,41.00,0.00,'2021-12-10 13:24:37','',''),(2232591,'1','136','779',334,'Retail Sale Id 1311875',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 13:38:10','',''),(2232592,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 13:38:10','',''),(2232613,'1','136','779',334,'Retail Sale Id 1311885',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 13:39:27','',''),(2232614,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 13:39:27','',''),(2232679,'1','136','779',334,'Retail Sale Id 1311912',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 13:42:17','',''),(2232680,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 13:42:17','',''),(2232705,'1','136','779',334,'Retail Sale Id 1311925',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 13:43:39','',''),(2232706,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 13:43:39','',''),(2232751,'1','136','779',334,'Retail Sale Id 1311945',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 13:45:36','',''),(2232752,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 13:45:36','',''),(2232827,'1','136','779',334,'Retail Sale Id 1311975',3160.00,0.00,0.00,0.00,200.00,'2021-12-10 13:48:37','',''),(2232828,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 13:48:37','',''),(2232925,'1','136','779',334,'Retail Sale Id 1312018',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 13:54:04','',''),(2232926,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:54:04','',''),(2233259,'1','136','779',334,'Retail Sale Id 1312144',4000.56,0.00,0.00,0.00,253.20,'2021-12-10 14:08:41','',''),(2233260,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-10 14:08:41','',''),(2233263,'1','136','779',334,'Retail Sale Id 1312147',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 14:09:15','',''),(2233264,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 14:09:15','',''),(2233337,'1','136','779',334,'Retail Sale Id 1312186',2546.96,0.00,0.00,0.00,161.20,'2021-12-10 14:14:14','',''),(2233338,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-10 14:14:14','',''),(2233357,'1','136','779',334,'Retail Sale Id 1312196',4000.56,0.00,0.00,0.00,253.20,'2021-12-10 14:14:59','',''),(2233358,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-10 14:14:59','',''),(2233413,'1','136','779',334,'Retail Sale Id 1312222',6320.00,0.00,0.00,0.00,400.00,'2021-12-10 14:17:43','',''),(2233414,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 14:17:43','',''),(2233483,'1','136','779',334,'Retail Sale Id 1312258',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 14:21:54','',''),(2233484,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 14:21:54','',''),(2233569,'1','136','779',334,'Retail Sale Id 1312285',6952.00,0.00,0.00,0.00,440.00,'2021-12-10 14:24:37','',''),(2233570,'1','136','779',334,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-10 14:24:37','',''),(2233675,'1','136','779',334,'Retail Sale Id 1312325',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 14:28:51','',''),(2233676,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 14:28:51','',''),(2233705,'1','136','779',334,'Retail Sale Id 1312342',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 14:30:02','',''),(2233706,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 14:30:02','',''),(2233811,'1','136','779',334,'Retail Sale Id 1312397',3160.00,0.00,0.00,0.00,200.00,'2021-12-10 14:34:55','',''),(2233812,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 14:34:55','',''),(2233964,'1','136','779',334,'Retail Sale Id 1312451',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 14:41:04','',''),(2233965,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:41:04','',''),(2234063,'1','136','779',334,'Retail Sale Id 1312502',29400.00,0.00,0.00,0.00,-200.00,'2021-12-10 14:45:11','',''),(2234064,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 14:45:11','',''),(2234139,'1','136','779',334,'Retail Sale Id 1312529',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 14:47:44','',''),(2234140,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 14:47:44','',''),(2234268,'1','136','779',334,'Retail Sale Id 1312590',4999.12,0.00,0.00,0.00,316.40,'2021-12-10 14:53:23','',''),(2234269,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-10 14:53:23','',''),(2234306,'1','136','779',334,'Retail Sale Id 1312609',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 14:55:13','',''),(2234307,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 14:55:13','',''),(2234520,'1','136','779',334,'Retail Sale Id 1312716',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 15:07:36','',''),(2234521,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 15:07:36','',''),(2234536,'1','136','779',334,'Retail Sale Id 1312723',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 15:08:24','',''),(2234537,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 15:08:24','',''),(2234621,'1','136','779',334,'Retail Sale Id 1312759',3160.00,0.00,0.00,0.00,200.00,'2021-12-10 15:12:13','',''),(2234622,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 15:12:13','',''),(2234735,'1','136','779',334,'Retail Sale Id 1312822',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 15:16:52','',''),(2234736,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 15:16:52','',''),(2234759,'1','136','779',334,'Retail Sale Id 1312835',998.56,0.00,0.00,0.00,63.20,'2021-12-10 15:18:10','',''),(2234760,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 15:18:10','',''),(2234783,'1','136','779',334,'Retail Sale Id 1312846',998.56,0.00,0.00,0.00,63.20,'2021-12-10 15:19:01','',''),(2234784,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 15:19:01','',''),(2234924,'1','136','779',334,'Retail Sale Id 1312925',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 15:24:23','',''),(2234925,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 15:24:23','',''),(2234952,'1','136','779',334,'Retail Sale Id 1312941',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 15:25:21','',''),(2234953,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 15:25:21','',''),(2234980,'1','136','779',334,'Retail Sale Id 1312952',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 15:26:17','',''),(2234981,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 15:26:17','',''),(2235030,'1','136','779',334,'Retail Sale Id 1312969',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 15:27:42','',''),(2235031,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:27:42','',''),(2235099,'1','136','779',334,'Retail Sale Id 1312989',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 15:29:41','',''),(2235100,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 15:29:41','',''),(2235277,'1','136','779',334,'Retail Sale Id 1313074',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 15:37:35','',''),(2235278,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:37:35','',''),(2235299,'1','136','779',334,'Retail Sale Id 1313085',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 15:38:51','',''),(2235300,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:38:51','',''),(2235345,'1','136','779',334,'Retail Sale Id 1313103',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 15:40:31','',''),(2235346,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:40:31','',''),(2235361,'1','136','779',334,'Retail Sale Id 1313111',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 15:41:20','',''),(2235362,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 15:41:20','',''),(2235383,'1','136','779',334,'Retail Sale Id 1313120',9998.24,0.00,0.00,0.00,632.80,'2021-12-10 15:42:09','',''),(2235384,'1','136','779',334,'Retail sales',0.00,0.00,0.00,15.82,0.00,'2021-12-10 15:42:09','',''),(2235529,'1','136','779',334,'Return of Retail Sale Id 1312952',0.00,1301.92,2.06,0.00,-82.40,'2021-12-10 15:49:06','',''),(2235583,'1','136','779',334,'Retail Sale Id 1313247',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 15:52:07','',''),(2235584,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 15:52:07','',''),(2235674,'1','136','779',334,'Retail Sale Id 1313288',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 15:56:05','',''),(2235675,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 15:56:05','',''),(2236152,'1','136','779',334,'Retail Sale Id 1313527',2502.72,0.00,0.00,0.00,158.40,'2021-12-10 16:18:18','',''),(2236153,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-10 16:18:18','',''),(2236176,'1','136','779',334,'Retail Sale Id 1313539',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 16:19:12','',''),(2236177,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:19:12','',''),(2236375,'1','136','779',334,'Retail Sale Id 1313645',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 16:27:27','',''),(2236376,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:27:27','',''),(2236479,'1','136','779',334,'Retail Sale Id 1313694',2502.72,0.00,0.00,0.00,158.40,'2021-12-10 16:32:08','',''),(2236480,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-10 16:32:08','',''),(2236493,'1','136','779',334,'Retail Sale Id 1313700',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 16:32:51','',''),(2236494,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 16:32:51','',''),(2236553,'1','136','779',334,'Retail Sale Id 1313727',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 16:36:00','',''),(2236554,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 16:36:00','',''),(2236587,'1','136','779',334,'Retail Sale Id 1313739',29400.00,0.00,0.00,0.00,-200.00,'2021-12-10 16:37:44','',''),(2236588,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 16:37:44','',''),(2236610,'1','136','779',334,'Retail Sale Id 1313750',3160.00,0.00,0.00,0.00,200.00,'2021-12-10 16:38:42','',''),(2236611,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 16:38:42','',''),(2236684,'1','136','779',334,'Retail Sale Id 1313778',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 16:42:16','',''),(2236685,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 16:42:16','',''),(2236788,'1','136','779',334,'Retail Sale Id 1313835',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 16:48:32','',''),(2236789,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 16:48:32','',''),(2236804,'1','136','779',334,'Retail Sale Id 1313843',3349.60,0.00,0.00,0.00,212.00,'2021-12-10 16:49:44','',''),(2236805,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.30,0.00,'2021-12-10 16:49:44','',''),(2236816,'1','136','779',334,'Retail Sale Id 1313848',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 16:50:44','',''),(2236817,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 16:50:44','',''),(2236894,'1','136','779',334,'Retail Sale Id 1313880',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 16:54:25','',''),(2236895,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 16:54:25','',''),(2236925,'1','136','779',334,'Retail Sale Id 1313898',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 16:56:53','',''),(2236926,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 16:56:53','',''),(2236951,'1','136','779',334,'Retail Sale Id 1313912',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 16:59:00','',''),(2236952,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 16:59:00','',''),(2237017,'1','136','779',334,'Retail Sale Id 1313952',4499.84,0.00,0.00,0.00,284.80,'2021-12-10 17:02:24','',''),(2237018,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.12,0.00,'2021-12-10 17:02:24','',''),(2237041,'1','136','779',334,'Retail Sale Id 1313959',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 17:03:25','',''),(2237042,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 17:03:25','',''),(2237053,'1','136','779',334,'Retail Sale Id 1313966',998.56,0.00,0.00,0.00,63.20,'2021-12-10 17:04:22','',''),(2237054,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 17:04:22','',''),(2237074,'1','136','779',334,'Retail Sale Id 1313972',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 17:05:35','',''),(2237075,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 17:05:35','',''),(2237078,'1','136','779',334,'Retail Sale Id 1313977',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 17:06:23','',''),(2237079,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 17:06:23','',''),(2237220,'1','136','779',334,'Retail Sale Id 1314050',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 17:19:17','',''),(2237221,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 17:19:17','',''),(2237335,'1','136','779',334,'Retail Sale Id 1314087',27896.48,0.00,0.00,0.00,1765.60,'2021-12-10 17:26:49','',''),(2237336,'1','136','779',334,'Retail sales',0.00,0.00,0.00,44.14,0.00,'2021-12-10 17:26:49','',''),(2238609,'1','136','779',334,'Retail Sale Id 1314490',14536.00,0.00,0.00,0.00,920.00,'2021-12-11 06:18:29','',''),(2238610,'1','136','779',334,'Retail sales',0.00,0.00,0.00,23.00,0.00,'2021-12-11 06:18:29','',''),(2238701,'1','136','779',334,'Retail Sale Id 1314536',19110.00,0.00,0.00,0.00,-130.00,'2021-12-11 06:25:49','',''),(2238702,'1','136','779',334,'Retail sales',0.00,0.00,0.00,32.50,0.00,'2021-12-11 06:25:49','',''),(2238757,'1','136','779',334,'Return of Retail Sale Id 1314536',0.00,19110.00,32.50,0.00,130.00,'2021-12-11 06:29:31','',''),(2238848,'1','136','779',334,'Retail Sale Id 1314582',29400.00,0.00,0.00,0.00,-200.00,'2021-12-11 06:35:02','',''),(2238849,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 06:35:02','',''),(2239286,'1','136','779',334,'Retail Sale Id 1314829',23520.00,0.00,0.00,0.00,-160.00,'2021-12-11 07:04:15','',''),(2239287,'1','136','779',334,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-11 07:04:15','',''),(2239350,'1','136','779',334,'Retail Sale Id 1314860',37632.00,0.00,0.00,0.00,-256.00,'2021-12-11 07:07:52','',''),(2239351,'1','136','779',334,'Retail sales',0.00,0.00,0.00,64.00,0.00,'2021-12-11 07:07:52','',''),(2239370,'1','136','779',334,'Retail Sale Id 1314869',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 07:09:17','',''),(2239371,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:09:17','',''),(2239434,'1','136','779',334,'Retail Sale Id 1314897',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 07:13:48','',''),(2239435,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:13:48','',''),(2239458,'1','136','779',334,'Retail Sale Id 1314916',3002.00,0.00,0.00,0.00,190.00,'2021-12-11 07:14:58','',''),(2239459,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 07:14:58','',''),(2239472,'1','136','779',334,'Retail Sale Id 1314926',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 07:16:10','',''),(2239473,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:16:10','',''),(2239513,'1','136','779',334,'Retail Sale Id 1314946',1997.12,0.00,0.00,0.00,126.40,'2021-12-11 07:18:17','',''),(2239514,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 07:18:17','',''),(2239608,'1','136','779',334,'Retail Sale Id 1315014',3160.00,0.00,0.00,0.00,200.00,'2021-12-11 07:24:23','',''),(2239609,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 07:24:23','',''),(2239690,'1','136','779',334,'Retail Sale Id 1315055',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 07:28:14','',''),(2239691,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:28:14','',''),(2239843,'1','136','779',334,'Retail Sale Id 1315124',3899.44,0.00,0.00,0.00,246.80,'2021-12-11 07:35:45','',''),(2239844,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 07:35:45','',''),(2239874,'1','136','779',334,'Retail Sale Id 1315150',998.56,0.00,0.00,0.00,63.20,'2021-12-11 07:37:44','',''),(2239875,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 07:37:44','',''),(2239933,'1','136','779',334,'Retail Sale Id 1315180',15168.00,0.00,0.00,0.00,960.00,'2021-12-11 07:40:39','',''),(2239934,'1','136','779',334,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-11 07:40:39','',''),(2239991,'1','136','779',334,'Retail Sale Id 1315205',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 07:43:36','',''),(2239992,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:43:36','',''),(2240034,'1','136','779',334,'Retail Sale Id 1315235',3899.44,0.00,0.00,0.00,246.80,'2021-12-11 07:45:37','',''),(2240035,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 07:45:37','',''),(2240108,'1','136','779',334,'Retail Sale Id 1315272',1598.96,0.00,0.00,0.00,101.20,'2021-12-11 07:48:41','',''),(2240109,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.53,0.00,'2021-12-11 07:48:41','',''),(2240160,'1','136','779',334,'Retail Sale Id 1315286',998.56,0.00,0.00,0.00,63.20,'2021-12-11 07:50:05','',''),(2240161,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 07:50:05','',''),(2240206,'1','136','779',334,'Retail Sale Id 1315303',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 07:51:50','',''),(2240207,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:51:50','',''),(2240226,'1','136','779',334,'Retail Sale Id 1315315',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 07:53:12','',''),(2240227,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:53:12','',''),(2240264,'1','136','779',334,'Retail Sale Id 1315332',1497.84,0.00,0.00,0.00,94.80,'2021-12-11 07:54:36','',''),(2240265,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-11 07:54:36','',''),(2240319,'1','136','779',334,'Retail Sale Id 1315359',14498.08,0.00,0.00,0.00,917.60,'2021-12-11 07:56:47','',''),(2240320,'1','136','779',334,'Retail sales',0.00,0.00,0.00,22.94,0.00,'2021-12-11 07:56:47','',''),(2240369,'1','136','779',334,'Retail Sale Id 1315387',7798.88,0.00,0.00,0.00,493.60,'2021-12-11 07:58:53','',''),(2240370,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.34,0.00,'2021-12-11 07:58:53','',''),(2240402,'1','136','779',334,'Retail Sale Id 1315399',3899.44,0.00,0.00,0.00,246.80,'2021-12-11 08:00:16','',''),(2240403,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 08:00:16','',''),(2240422,'1','136','779',334,'Retail Sale Id 1315410',1997.12,0.00,0.00,0.00,126.40,'2021-12-11 08:01:20','',''),(2240423,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 08:01:20','',''),(2240437,'1','136','779',334,'Retail Sale Id 1315420',1997.12,0.00,0.00,0.00,126.40,'2021-12-11 08:02:37','',''),(2240438,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 08:02:37','',''),(2240518,'1','136','779',334,'Retail Sale Id 1315438',4000.56,0.00,0.00,0.00,253.20,'2021-12-11 08:05:04','',''),(2240519,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-11 08:05:04','',''),(2240547,'1','136','779',334,'Retail Sale Id 1315448',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 08:06:27','',''),(2240548,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 08:06:27','',''),(2240574,'1','136','779',334,'Retail Sale Id 1315458',2799.76,0.00,0.00,0.00,177.20,'2021-12-11 08:07:45','',''),(2240575,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.43,0.00,'2021-12-11 08:07:45','',''),(2240632,'1','136','779',334,'Retail Sale Id 1315477',17640.00,0.00,0.00,0.00,-120.00,'2021-12-11 08:09:58','',''),(2240633,'1','136','779',334,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-11 08:09:58','',''),(2240681,'1','136','779',334,'Retail Sale Id 1315499',1497.84,0.00,0.00,0.00,94.80,'2021-12-11 08:12:11','',''),(2240682,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-11 08:12:11','',''),(2240721,'1','136','779',334,'Retail Sale Id 1315517',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 08:14:06','',''),(2240722,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 08:14:06','',''),(2240783,'1','136','779',334,'Retail Sale Id 1315558',1997.12,0.00,0.00,0.00,126.40,'2021-12-11 08:16:51','',''),(2240784,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 08:16:51','',''),(2240828,'1','136','779',334,'Retail Sale Id 1315583',3899.44,0.00,0.00,0.00,246.80,'2021-12-11 08:19:14','',''),(2240829,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 08:19:14','',''),(2240886,'1','136','779',334,'Retail Sale Id 1315612',3899.44,0.00,0.00,0.00,246.80,'2021-12-11 08:21:57','',''),(2240887,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 08:21:57','',''),(2240908,'1','136','779',334,'Retail Sale Id 1315629',3197.92,0.00,0.00,0.00,202.40,'2021-12-11 08:23:16','',''),(2240909,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 08:23:16','',''),(2240969,'1','136','779',334,'Retail Sale Id 1315657',3899.44,0.00,0.00,0.00,246.80,'2021-12-11 08:27:23','',''),(2240970,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 08:27:23','',''),(2241052,'1','136','779',334,'Retail Sale Id 1315697',64002.64,0.00,0.00,0.00,4050.80,'2021-12-11 08:31:08','',''),(2241053,'1','136','779',334,'Retail sales',0.00,0.00,0.00,101.27,0.00,'2021-12-11 08:31:08','',''),(2241132,'1','136','779',334,'Return of Retail Sale Id 1315697',0.00,64002.64,101.27,0.00,-4050.80,'2021-12-11 08:35:03','',''),(2241141,'1','136','779',334,'Retail Sale Id 1315742',6402.16,0.00,0.00,0.00,405.20,'2021-12-11 08:35:42','',''),(2241142,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.13,0.00,'2021-12-11 08:35:42','',''),(2241168,'1','136','779',334,'Retail Sale Id 1315754',1902.32,0.00,0.00,0.00,120.40,'2021-12-11 08:37:00','',''),(2241169,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 08:37:00','',''),(2241200,'1','136','779',334,'Retail Sale Id 1315767',1902.32,0.00,0.00,0.00,120.40,'2021-12-11 08:38:42','',''),(2241201,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 08:38:42','',''),(2241342,'1','136','779',334,'Retail Sale Id 1315823',3899.44,0.00,0.00,0.00,246.80,'2021-12-11 08:44:57','',''),(2241343,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 08:44:57','',''),(2241487,'1','136','779',334,'Retail Sale Id 1315878',205100.00,0.00,0.00,0.00,-2100.00,'2021-12-11 08:52:01','',''),(2241488,'1','136','779',334,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-11 08:52:01','',''),(2241587,'1','136','779',334,'Retail Sale Id 1315932',1902.32,0.00,0.00,0.00,120.40,'2021-12-11 08:56:26','',''),(2241588,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 08:56:26','',''),(2241742,'1','136','779',334,'Retail Sale Id 1315961',6320.00,0.00,0.00,0.00,400.00,'2021-12-11 09:01:59','',''),(2241743,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 09:01:59','',''),(2241768,'1','136','779',334,'Retail Sale Id 1316017',1902.32,0.00,0.00,0.00,120.40,'2021-12-11 09:03:23','',''),(2241769,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 09:03:23','',''),(2241834,'1','136','779',334,'Retail Sale Id 1316050',26460.00,0.00,0.00,0.00,-180.00,'2021-12-11 09:06:27','',''),(2241835,'1','136','779',334,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-11 09:06:27','',''),(2241892,'1','136','779',334,'Retail Sale Id 1316077',18851.28,0.00,0.00,0.00,-128.24,'2021-12-11 09:09:00','',''),(2241893,'1','136','779',334,'Retail sales',0.00,0.00,0.00,32.06,0.00,'2021-12-11 09:09:01','',''),(2241951,'1','136','779',334,'Retail Sale Id 1316107',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 09:11:50','',''),(2241952,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:11:50','',''),(2241996,'1','136','779',334,'Retail Sale Id 1316124',6320.00,0.00,0.00,0.00,400.00,'2021-12-11 09:13:18','',''),(2241997,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 09:13:18','',''),(2242020,'1','136','779',334,'Retail Sale Id 1316138',1997.12,0.00,0.00,0.00,126.40,'2021-12-11 09:14:18','',''),(2242021,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 09:14:18','',''),(2242068,'1','136','779',334,'Retail Sale Id 1316174',6320.00,0.00,0.00,0.00,400.00,'2021-12-11 09:16:45','',''),(2242069,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 09:16:45','',''),(2242100,'1','136','779',334,'Retail Sale Id 1316184',1598.96,0.00,0.00,0.00,101.20,'2021-12-11 09:17:56','',''),(2242101,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.53,0.00,'2021-12-11 09:17:56','',''),(2242131,'1','136','779',334,'Retail Sale Id 1316191',1598.96,0.00,0.00,0.00,101.20,'2021-12-11 09:18:58','',''),(2242132,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.53,0.00,'2021-12-11 09:18:58','',''),(2242181,'1','136','779',334,'Retail Sale Id 1316214',8001.12,0.00,0.00,0.00,506.40,'2021-12-11 09:21:43','',''),(2242182,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.66,0.00,'2021-12-11 09:21:43','',''),(2242217,'1','136','779',334,'Retail Sale Id 1316229',15800.00,0.00,0.00,0.00,1000.00,'2021-12-11 09:23:09','',''),(2242218,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-11 09:23:09','',''),(2242261,'1','136','779',334,'Retail Sale Id 1316249',1598.96,0.00,0.00,0.00,101.20,'2021-12-11 09:25:37','',''),(2242262,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.53,0.00,'2021-12-11 09:25:37','',''),(2242275,'1','136','779',334,'Retail Sale Id 1316255',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 09:26:49','',''),(2242276,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:26:49','',''),(2242317,'1','136','779',334,'Retail Sale Id 1316278',1997.12,0.00,0.00,0.00,126.40,'2021-12-11 09:29:48','',''),(2242318,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 09:29:48','',''),(2242357,'1','136','779',334,'Retail Sale Id 1316298',3299.04,0.00,0.00,0.00,208.80,'2021-12-11 09:31:47','',''),(2242358,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.22,0.00,'2021-12-11 09:31:47','',''),(2242382,'1','136','779',334,'Retail Sale Id 1316314',3197.92,0.00,0.00,0.00,202.40,'2021-12-11 09:32:39','',''),(2242383,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 09:32:39','',''),(2242406,'1','136','779',334,'Retail Sale Id 1316326',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 09:33:48','',''),(2242407,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:33:48','',''),(2242428,'1','136','779',334,'Retail Sale Id 1316336',1301.92,0.00,0.00,0.00,82.40,'2021-12-11 09:35:07','',''),(2242429,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-11 09:35:07','',''),(2242452,'1','136','779',334,'Retail Sale Id 1316349',1497.84,0.00,0.00,0.00,94.80,'2021-12-11 09:36:18','',''),(2242453,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-11 09:36:18','',''),(2242484,'1','136','779',334,'Retail Sale Id 1316367',3899.44,0.00,0.00,0.00,246.80,'2021-12-11 09:37:32','',''),(2242485,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 09:37:32','',''),(2242598,'1','136','779',334,'Retail Sale Id 1316428',3899.44,0.00,0.00,0.00,246.80,'2021-12-11 09:42:45','',''),(2242599,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 09:42:45','',''),(2242704,'1','136','779',334,'Retail Sale Id 1316477',3899.44,0.00,0.00,0.00,246.80,'2021-12-11 09:47:03','',''),(2242705,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 09:47:03','',''),(2242770,'1','136','779',334,'Retail Sale Id 1316511',29400.00,0.00,0.00,0.00,-200.00,'2021-12-11 09:50:17','',''),(2242771,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 09:50:17','',''),(2242824,'1','136','779',334,'Retail Sale Id 1316539',8001.12,0.00,0.00,0.00,506.40,'2021-12-11 09:52:57','',''),(2242825,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.66,0.00,'2021-12-11 09:52:57','',''),(2242852,'1','136','779',334,'Retail Sale Id 1316551',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 09:55:17','',''),(2242853,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:55:17','',''),(2242880,'1','136','779',334,'Retail Sale Id 1316566',3197.92,0.00,0.00,0.00,202.40,'2021-12-11 09:56:54','',''),(2242881,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 09:56:54','',''),(2242935,'1','136','779',334,'Retail Sale Id 1316587',9498.96,0.00,0.00,0.00,601.20,'2021-12-11 09:59:18','',''),(2242936,'1','136','779',334,'Retail sales',0.00,0.00,0.00,15.03,0.00,'2021-12-11 09:59:18','',''),(2243049,'1','136','779',334,'Retail Sale Id 1316646',2559.60,0.00,0.00,0.00,162.00,'2021-12-11 10:05:17','',''),(2243050,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.05,0.00,'2021-12-11 10:05:17','',''),(2243068,'1','136','779',334,'Retail Sale Id 1316653',3197.92,0.00,0.00,0.00,202.40,'2021-12-11 10:06:32','',''),(2243069,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 10:06:32','',''),(2243192,'1','136','779',334,'Retail Sale Id 1316694',1200.80,0.00,0.00,0.00,76.00,'2021-12-11 10:10:51','',''),(2243193,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-11 10:10:51','',''),(2243307,'1','136','779',334,'Retail Sale Id 1316743',3899.44,0.00,0.00,0.00,246.80,'2021-12-11 10:15:53','',''),(2243308,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 10:15:53','',''),(2243371,'1','136','779',334,'Retail Sale Id 1316768',3197.92,0.00,0.00,0.00,202.40,'2021-12-11 10:18:22','',''),(2243372,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 10:18:22','',''),(2243413,'1','136','779',334,'Retail Sale Id 1316789',3899.44,0.00,0.00,0.00,246.80,'2021-12-11 10:20:32','',''),(2243414,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 10:20:32','',''),(2243545,'1','136','779',334,'Retail Sale Id 1316857',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 10:27:32','',''),(2243546,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 10:27:32','',''),(2243569,'1','136','779',334,'Retail Sale Id 1316867',1997.12,0.00,0.00,0.00,126.40,'2021-12-11 10:28:58','',''),(2243570,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 10:28:58','',''),(2243639,'1','136','779',334,'Retail Sale Id 1316898',3899.44,0.00,0.00,0.00,246.80,'2021-12-11 10:32:59','',''),(2243640,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 10:32:59','',''),(2243709,'1','136','779',334,'Retail Sale Id 1316937',8001.12,0.00,0.00,0.00,506.40,'2021-12-11 10:36:55','',''),(2243710,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.66,0.00,'2021-12-11 10:36:55','',''),(2243808,'1','136','779',334,'Retail Sale Id 1316983',2546.96,0.00,0.00,0.00,161.20,'2021-12-11 10:42:10','',''),(2243809,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-11 10:42:10','',''),(2244050,'1','136','779',334,'Retail Sale Id 1317108',1497.84,0.00,0.00,0.00,94.80,'2021-12-11 10:56:02','',''),(2244051,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-11 10:56:02','',''),(2244072,'1','136','779',334,'Retail Sale Id 1317117',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 10:57:10','',''),(2244073,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 10:57:10','',''),(2244138,'1','136','779',334,'Retail Sale Id 1317141',998.56,0.00,0.00,0.00,63.20,'2021-12-11 10:59:50','',''),(2244139,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 10:59:50','',''),(2244241,'1','136','779',334,'Retail Sale Id 1317184',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 11:04:04','',''),(2244242,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:04:04','',''),(2244317,'1','136','779',334,'Retail Sale Id 1317221',1902.32,0.00,0.00,0.00,120.40,'2021-12-11 11:08:02','',''),(2244318,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 11:08:02','',''),(2244339,'1','136','779',334,'Retail Sale Id 1317234',3160.00,0.00,0.00,0.00,200.00,'2021-12-11 11:09:15','',''),(2244340,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 11:09:15','',''),(2244423,'1','136','779',334,'Retail Sale Id 1317277',998.56,0.00,0.00,0.00,63.20,'2021-12-11 11:13:47','',''),(2244424,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 11:13:47','',''),(2244445,'1','136','779',334,'Retail Sale Id 1317284',1902.32,0.00,0.00,0.00,120.40,'2021-12-11 11:14:50','',''),(2244446,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 11:14:50','',''),(2244503,'1','136','779',334,'Retail Sale Id 1317313',205100.00,0.00,0.00,0.00,-2100.00,'2021-12-11 11:17:48','',''),(2244504,'1','136','779',334,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-11 11:17:48','',''),(2244519,'1','136','779',334,'Retail Sale Id 1317323',8848.00,0.00,0.00,0.00,560.00,'2021-12-11 11:19:02','',''),(2244520,'1','136','779',334,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-11 11:19:02','',''),(2244545,'1','136','779',334,'Retail Sale Id 1317333',1997.12,0.00,0.00,0.00,126.40,'2021-12-11 11:20:09','',''),(2244546,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 11:20:09','',''),(2244660,'1','136','779',334,'Retail Sale Id 1317391',1497.84,0.00,0.00,0.00,94.80,'2021-12-11 11:25:18','',''),(2244661,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-11 11:25:18','',''),(2244697,'1','136','779',334,'Retail Sale Id 1317405',3798.32,0.00,0.00,0.00,240.40,'2021-12-11 11:26:21','',''),(2244698,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 11:26:21','',''),(2244710,'1','136','779',334,'Retail Sale Id 1317411',3798.32,0.00,0.00,0.00,240.40,'2021-12-11 11:27:12','',''),(2244711,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 11:27:12','',''),(2244730,'1','136','779',334,'Retail Sale Id 1317421',3798.32,0.00,0.00,0.00,240.40,'2021-12-11 11:28:21','',''),(2244731,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 11:28:21','',''),(2244830,'1','136','779',334,'Retail Sale Id 1317475',22120.00,0.00,0.00,0.00,1400.00,'2021-12-11 11:34:38','',''),(2244831,'1','136','779',334,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-11 11:34:38','',''),(2244872,'1','136','779',334,'Retail Sale Id 1317498',3002.00,0.00,0.00,0.00,190.00,'2021-12-11 11:37:13','',''),(2244873,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 11:37:13','',''),(2244918,'1','136','779',334,'Retail Sale Id 1317523',1801.20,0.00,0.00,0.00,114.00,'2021-12-11 11:39:47','',''),(2244919,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.85,0.00,'2021-12-11 11:39:47','',''),(2244977,'1','136','779',334,'Retail Sale Id 1317559',29400.00,0.00,0.00,0.00,-200.00,'2021-12-11 11:43:20','',''),(2244978,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 11:43:20','',''),(2244999,'1','136','779',334,'Retail Sale Id 1317572',998.56,0.00,0.00,0.00,63.20,'2021-12-11 11:45:43','',''),(2245000,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 11:45:43','',''),(2245015,'1','136','779',334,'Retail Sale Id 1317580',58800.00,0.00,0.00,0.00,-400.00,'2021-12-11 11:46:57','',''),(2245016,'1','136','779',334,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-11 11:46:57','',''),(2245039,'1','136','779',334,'Retail Sale Id 1317592',3798.32,0.00,0.00,0.00,240.40,'2021-12-11 11:48:40','',''),(2245040,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 11:48:40','',''),(2245121,'1','136','779',334,'Retail Sale Id 1317633',3798.32,0.00,0.00,0.00,240.40,'2021-12-11 11:52:50','',''),(2245122,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 11:52:50','',''),(2245149,'1','136','779',334,'Retail Sale Id 1317646',3160.00,0.00,0.00,0.00,200.00,'2021-12-11 11:54:09','',''),(2245150,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 11:54:09','',''),(2245274,'1','136','779',334,'Retail Sale Id 1317706',3899.44,0.00,0.00,0.00,246.80,'2021-12-11 12:01:19','',''),(2245275,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 12:01:19','',''),(2245292,'1','136','779',334,'Retail Sale Id 1317713',1902.32,0.00,0.00,0.00,120.40,'2021-12-11 12:02:49','',''),(2245293,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 12:02:49','',''),(2245306,'1','136','779',334,'Retail Sale Id 1317722',1997.12,0.00,0.00,0.00,126.40,'2021-12-11 12:03:56','',''),(2245307,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 12:03:56','',''),(2245355,'1','136','779',334,'Retail Sale Id 1317768',1902.32,0.00,0.00,0.00,120.40,'2021-12-11 12:08:31','',''),(2245356,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 12:08:31','',''),(2245377,'1','136','779',334,'Retail Sale Id 1317802',1902.32,0.00,0.00,0.00,120.40,'2021-12-11 12:09:45','',''),(2245378,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 12:09:45','',''),(2245487,'1','136','779',334,'Retail Sale Id 1317867',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 12:16:38','',''),(2245488,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 12:16:38','',''),(2245511,'1','136','779',334,'Retail Sale Id 1317882',1902.32,0.00,0.00,0.00,120.40,'2021-12-11 12:17:39','',''),(2245512,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 12:17:39','',''),(2245529,'1','136','779',334,'Retail Sale Id 1317893',3798.32,0.00,0.00,0.00,240.40,'2021-12-11 12:18:33','',''),(2245530,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 12:18:33','',''),(2245545,'1','136','779',334,'Retail Sale Id 1317901',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 12:19:17','',''),(2245546,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 12:19:17','',''),(2245641,'1','136','779',334,'Retail Sale Id 1317935',12348.00,0.00,0.00,0.00,-84.00,'2021-12-11 12:24:28','',''),(2245642,'1','136','779',334,'Retail sales',0.00,0.00,0.00,21.00,0.00,'2021-12-11 12:24:28','',''),(2245660,'1','136','779',334,'Retail Sale Id 1317948',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 12:25:47','',''),(2245661,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 12:25:47','',''),(2245680,'1','136','779',334,'Retail Sale Id 1317959',5997.68,0.00,0.00,0.00,379.60,'2021-12-11 12:27:00','',''),(2245681,'1','136','779',334,'Retail sales',0.00,0.00,0.00,9.49,0.00,'2021-12-11 12:27:00','',''),(2245772,'1','136','779',334,'Retail Sale Id 1317997',998.56,0.00,0.00,0.00,63.20,'2021-12-11 12:32:00','',''),(2245773,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 12:32:00','',''),(2245826,'1','136','779',334,'Retail Sale Id 1318023',15800.00,0.00,0.00,0.00,1000.00,'2021-12-11 12:36:00','',''),(2245827,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-11 12:36:00','',''),(2245850,'1','136','779',334,'Retail Sale Id 1318046',3160.00,0.00,0.00,0.00,200.00,'2021-12-11 12:37:04','',''),(2245851,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 12:37:04','',''),(2245870,'1','136','779',334,'Retail Sale Id 1318054',3002.00,0.00,0.00,0.00,190.00,'2021-12-11 12:38:34','',''),(2245871,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 12:38:34','',''),(2245882,'1','136','779',334,'Retail Sale Id 1318062',1902.32,0.00,0.00,0.00,120.40,'2021-12-11 12:39:22','',''),(2245883,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 12:39:22','',''),(2245939,'1','136','779',334,'Retail Sale Id 1318086',3798.32,0.00,0.00,0.00,240.40,'2021-12-11 12:42:30','',''),(2245940,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 12:42:30','',''),(2246081,'1','136','779',334,'Retail Sale Id 1318161',2502.72,0.00,0.00,0.00,158.40,'2021-12-11 12:53:43','',''),(2246082,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-11 12:53:43','',''),(2246132,'1','136','779',334,'Retail Sale Id 1318185',4999.12,0.00,0.00,0.00,316.40,'2021-12-11 12:57:06','',''),(2246133,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-11 12:57:06','',''),(2246240,'1','136','779',334,'Retail Sale Id 1318247',4000.56,0.00,0.00,0.00,253.20,'2021-12-11 13:04:27','',''),(2246241,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-11 13:04:27','',''),(2246596,'1','136','779',334,'Retail Sale Id 1318415',1497.84,0.00,0.00,0.00,94.80,'2021-12-11 13:29:09','',''),(2246597,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-11 13:29:09','',''),(2246915,'1','136','779',334,'Retail Sale Id 1318546',36750.00,0.00,0.00,0.00,-250.00,'2021-12-11 13:51:16','',''),(2246916,'1','136','779',334,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-11 13:51:16','',''),(2247038,'1','136','779',334,'Retail Sale Id 1318610',88200.00,0.00,0.00,0.00,-600.00,'2021-12-11 13:58:20','',''),(2247039,'1','136','779',334,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-11 13:58:20','',''),(2247158,'1','136','779',334,'Retail Sale Id 1318672',3002.00,0.00,0.00,0.00,190.00,'2021-12-11 14:06:41','',''),(2247159,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 14:06:41','',''),(2247345,'1','136','779',334,'Retail Sale Id 1318761',1997.12,0.00,0.00,0.00,126.40,'2021-12-11 14:16:11','',''),(2247346,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 14:16:11','',''),(2247474,'1','136','779',334,'Retail Sale Id 1318823',36456.00,0.00,0.00,0.00,-248.00,'2021-12-11 14:25:47','',''),(2247475,'1','136','779',334,'Retail sales',0.00,0.00,0.00,62.00,0.00,'2021-12-11 14:25:47','',''),(2247752,'1','136','779',334,'Retail Sale Id 1318975',11760.00,0.00,0.00,0.00,-80.00,'2021-12-11 14:43:45','',''),(2247753,'1','136','779',334,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-11 14:43:45','',''),(2248003,'1','136','779',334,'Retail Sale Id 1319107',1902.32,0.00,0.00,0.00,120.40,'2021-12-11 14:58:02','',''),(2248004,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 14:58:02','',''),(2248292,'1','136','779',334,'Retail Sale Id 1319217',1301.92,0.00,0.00,0.00,82.40,'2021-12-11 15:11:23','',''),(2248293,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-11 15:11:23','',''),(2248494,'1','136','779',334,'Retail Sale Id 1319323',15800.00,0.00,0.00,0.00,1000.00,'2021-12-11 15:22:09','',''),(2248495,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-11 15:22:09','',''),(2248558,'1','136','779',334,'Retail Sale Id 1319355',410200.00,0.00,0.00,0.00,-4200.00,'2021-12-11 15:25:29','',''),(2248559,'1','136','779',334,'Retail sales',0.00,0.00,0.00,700.00,0.00,'2021-12-11 15:25:29','',''),(2248761,'1','136','779',334,'Retail Sale Id 1319471',11698.32,0.00,0.00,0.00,740.40,'2021-12-11 15:36:33','',''),(2248762,'1','136','779',334,'Retail sales',0.00,0.00,0.00,18.51,0.00,'2021-12-11 15:36:33','',''),(2249027,'1','136','779',334,'Retail Sale Id 1319603',29400.00,0.00,0.00,0.00,-200.00,'2021-12-11 15:49:56','',''),(2249028,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 15:49:56','',''),(2249198,'1','136','779',334,'Retail Sale Id 1319670',8216.00,0.00,0.00,0.00,520.00,'2021-12-11 15:55:56','',''),(2249199,'1','136','779',334,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-11 15:55:56','',''),(2249695,'1','136','779',334,'Retail Sale Id 1319953',1598.96,0.00,0.00,0.00,101.20,'2021-12-11 16:19:38','',''),(2249696,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.53,0.00,'2021-12-11 16:19:38','',''),(2249933,'1','136','779',334,'Retail Sale Id 1320059',1902.32,0.00,0.00,0.00,120.40,'2021-12-11 16:33:06','',''),(2249934,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 16:33:06','',''),(2249969,'1','136','779',334,'Retail Sale Id 1320076',58800.00,0.00,0.00,0.00,-400.00,'2021-12-11 16:34:30','',''),(2249970,'1','136','779',334,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-11 16:34:30','',''),(2250115,'1','136','779',334,'Retail Sale Id 1320119',2528.00,0.00,0.00,0.00,160.00,'2021-12-11 16:40:52','',''),(2250116,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 16:40:52','',''),(2250486,'1','136','779',334,'Retail Sale Id 1320277',175800.00,0.00,0.00,0.00,-1800.00,'2021-12-11 17:01:38','',''),(2250487,'1','136','779',334,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-11 17:01:38','',''),(2250508,'1','136','779',334,'Retail Sale Id 1320297',110353.52,0.00,0.00,0.00,6984.40,'2021-12-11 17:03:10','',''),(2250509,'1','136','779',334,'Retail sales',0.00,0.00,0.00,174.61,0.00,'2021-12-11 17:03:10','',''),(2250576,'1','136','779',334,'Retail Sale Id 1320328',3197.92,0.00,0.00,0.00,202.40,'2021-12-11 17:07:24','',''),(2250577,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 17:07:24','',''),(2250686,'1','136','779',334,'Retail Sale Id 1320392',1403.04,0.00,0.00,0.00,88.80,'2021-12-11 17:19:10','',''),(2250687,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.22,0.00,'2021-12-11 17:19:10','',''),(2250782,'1','136','779',334,'Retail Sale Id 1320437',3798.32,0.00,0.00,0.00,240.40,'2021-12-11 17:26:45','',''),(2250783,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 17:26:45','',''),(2250808,'1','136','779',334,'Return of Retail Sale Id 1320437',0.00,3798.32,6.01,0.00,-240.40,'2021-12-11 17:28:23','',''),(2250825,'1','136','779',334,'Retail Sale Id 1320456',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 17:29:22','',''),(2250826,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 17:29:22','',''),(2250846,'1','136','779',334,'Retail Sale Id 1320468',3798.32,0.00,0.00,0.00,240.40,'2021-12-11 17:31:36','',''),(2250847,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 17:31:36','',''),(2250884,'1','136','779',334,'Retail Sale Id 1320488',1497.84,0.00,0.00,0.00,94.80,'2021-12-11 17:34:02','',''),(2250885,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-11 17:34:02','',''),(2250934,'1','136','779',334,'Retail Sale Id 1320507',701.52,0.00,0.00,0.00,44.40,'2021-12-11 17:38:46','',''),(2250935,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-11 17:38:46','',''),(2252178,'1','136','779',334,'Retail Sale Id 1320879',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 06:26:15','',''),(2252179,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 06:26:15','',''),(2252186,'1','136','779',334,'Retail Sale Id 1320884',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 06:27:37','',''),(2252187,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 06:27:37','',''),(2252240,'1','136','779',334,'Retail Sale Id 1320912',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 06:31:47','',''),(2252241,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 06:31:47','',''),(2252266,'1','136','779',334,'Retail Sale Id 1320926',2597.52,0.00,0.00,0.00,164.40,'2021-12-12 06:33:27','',''),(2252267,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.11,0.00,'2021-12-12 06:33:27','',''),(2252293,'1','136','779',334,'Retail Sale Id 1320933',3002.00,0.00,0.00,0.00,190.00,'2021-12-12 06:34:47','',''),(2252294,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 06:34:47','',''),(2252331,'1','136','779',334,'Retail Sale Id 1320945',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 06:36:52','',''),(2252332,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 06:36:52','',''),(2252381,'1','136','779',334,'Retail Sale Id 1320960',1700.08,0.00,0.00,0.00,107.60,'2021-12-12 06:38:15','',''),(2252382,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.69,0.00,'2021-12-12 06:38:15','',''),(2252394,'1','136','779',334,'Retail Sale Id 1320966',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 06:39:07','',''),(2252395,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 06:39:07','',''),(2252426,'1','136','779',334,'Retail Sale Id 1320980',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 06:41:18','',''),(2252427,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 06:41:18','',''),(2252567,'1','136','779',334,'Retail Sale Id 1321031',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 06:49:22','',''),(2252568,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 06:49:22','',''),(2252695,'1','136','779',334,'Retail Sale Id 1321078',2597.52,0.00,0.00,0.00,164.40,'2021-12-12 06:58:02','',''),(2252696,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.11,0.00,'2021-12-12 06:58:02','',''),(2252711,'1','136','779',334,'Retail Sale Id 1321087',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 06:59:20','',''),(2252712,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 06:59:20','',''),(2252719,'1','136','779',334,'Retail Sale Id 1321091',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 07:00:20','',''),(2252720,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 07:00:20','',''),(2252763,'1','136','779',334,'Retail Sale Id 1321116',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 07:04:02','',''),(2252764,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 07:04:02','',''),(2252787,'1','136','779',334,'Retail Sale Id 1321128',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 07:06:04','',''),(2252788,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 07:06:04','',''),(2252845,'1','136','779',334,'Retail Sale Id 1321158',3002.00,0.00,0.00,0.00,190.00,'2021-12-12 07:10:15','',''),(2252846,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 07:10:15','',''),(2252926,'1','136','779',334,'Retail Sale Id 1321201',58800.00,0.00,0.00,0.00,-400.00,'2021-12-12 07:15:59','',''),(2252927,'1','136','779',334,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-12 07:15:59','',''),(2252956,'1','136','779',334,'Retail Sale Id 1321214',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 07:18:22','',''),(2252957,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 07:18:22','',''),(2252970,'1','136','779',334,'Retail Sale Id 1321220',998.56,0.00,0.00,0.00,63.20,'2021-12-12 07:19:20','',''),(2252971,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 07:19:20','',''),(2252984,'1','136','779',334,'Retail Sale Id 1321229',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 07:20:20','',''),(2252985,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 07:20:20','',''),(2253008,'1','136','779',334,'Retail Sale Id 1321241',4000.56,0.00,0.00,0.00,253.20,'2021-12-12 07:21:59','',''),(2253009,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-12 07:21:59','',''),(2253182,'1','136','779',334,'Retail Sale Id 1321326',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 07:31:49','',''),(2253183,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 07:31:49','',''),(2253216,'1','136','779',334,'Retail Sale Id 1321353',2597.52,0.00,0.00,0.00,164.40,'2021-12-12 07:34:42','',''),(2253217,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.11,0.00,'2021-12-12 07:34:42','',''),(2253234,'1','136','779',334,'Retail Sale Id 1321365',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 07:35:51','',''),(2253235,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 07:35:51','',''),(2253254,'1','136','779',334,'Retail Sale Id 1321374',3002.00,0.00,0.00,0.00,190.00,'2021-12-12 07:37:05','',''),(2253255,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 07:37:05','',''),(2253268,'1','136','779',334,'Retail Sale Id 1321382',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 07:37:55','',''),(2253269,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 07:37:55','',''),(2253330,'1','136','779',334,'Retail Sale Id 1321420',9480.00,0.00,0.00,0.00,600.00,'2021-12-12 07:44:06','',''),(2253331,'1','136','779',334,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-12 07:44:06','',''),(2253381,'1','136','779',334,'Retail Sale Id 1321434',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 07:46:12','',''),(2253382,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 07:46:12','',''),(2253450,'1','136','779',334,'Retail Sale Id 1321492',6320.00,0.00,0.00,0.00,400.00,'2021-12-12 07:50:47','',''),(2253451,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-12 07:50:47','',''),(2253484,'1','136','779',334,'Retail Sale Id 1321510',1497.84,0.00,0.00,0.00,94.80,'2021-12-12 07:53:06','',''),(2253485,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 07:53:06','',''),(2253509,'1','136','779',334,'Retail Sale Id 1321520',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 07:54:41','',''),(2253510,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 07:54:41','',''),(2253546,'1','136','779',334,'Retail Sale Id 1321537',998.56,0.00,0.00,0.00,63.20,'2021-12-12 07:56:58','',''),(2253547,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 07:56:58','',''),(2253573,'1','136','779',334,'Retail Sale Id 1321550',3002.00,0.00,0.00,0.00,190.00,'2021-12-12 07:58:29','',''),(2253574,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 07:58:29','',''),(2253595,'1','136','779',334,'Retail Sale Id 1321560',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 07:59:42','',''),(2253596,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 07:59:42','',''),(2253670,'1','136','779',334,'Retail Sale Id 1321602',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 08:05:21','',''),(2253671,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 08:05:21','',''),(2253721,'1','136','779',334,'Retail Sale Id 1321617',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 08:07:23','',''),(2253722,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 08:07:23','',''),(2253762,'1','136','779',334,'Retail Sale Id 1321650',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 08:10:55','',''),(2253763,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 08:10:55','',''),(2253780,'1','136','779',334,'Retail Sale Id 1321659',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 08:12:13','',''),(2253781,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 08:12:13','',''),(2253841,'1','136','779',334,'Retail Sale Id 1321687',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 08:15:47','',''),(2253842,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 08:15:47','',''),(2253863,'1','136','779',334,'Retail Sale Id 1321698',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 08:17:23','',''),(2253864,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 08:17:23','',''),(2253879,'1','136','779',334,'Retail Sale Id 1321705',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 08:18:32','',''),(2253880,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 08:18:32','',''),(2253943,'1','136','779',334,'Retail Sale Id 1321731',26460.00,0.00,0.00,0.00,-180.00,'2021-12-12 08:22:33','',''),(2253944,'1','136','779',334,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-12 08:22:33','',''),(2253965,'1','136','779',334,'Retail Sale Id 1321745',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 08:24:16','',''),(2253966,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 08:24:16','',''),(2253993,'1','136','779',334,'Retail Sale Id 1321757',6320.00,0.00,0.00,0.00,400.00,'2021-12-12 08:25:37','',''),(2253994,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-12 08:25:37','',''),(2254013,'1','136','779',334,'Retail Sale Id 1321770',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 08:27:36','',''),(2254014,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 08:27:36','',''),(2254027,'1','136','779',334,'Retail Sale Id 1321775',1301.92,0.00,0.00,0.00,82.40,'2021-12-12 08:28:48','',''),(2254028,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 08:28:48','',''),(2254053,'1','136','779',334,'Retail Sale Id 1321793',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 08:30:53','',''),(2254054,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 08:30:53','',''),(2254110,'1','136','779',334,'Retail Sale Id 1321815',29400.00,0.00,0.00,0.00,-200.00,'2021-12-12 08:34:37','',''),(2254111,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 08:34:37','',''),(2254150,'1','136','779',334,'Retail Sale Id 1321842',4999.12,0.00,0.00,0.00,316.40,'2021-12-12 08:37:20','',''),(2254151,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-12 08:37:20','',''),(2254218,'1','136','779',334,'Retail Sale Id 1321878',58800.00,0.00,0.00,0.00,-400.00,'2021-12-12 08:40:46','',''),(2254219,'1','136','779',334,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-12 08:40:46','',''),(2254281,'1','136','779',334,'Retail Sale Id 1321903',1497.84,0.00,0.00,0.00,94.80,'2021-12-12 08:44:08','',''),(2254282,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 08:44:08','',''),(2254304,'1','136','779',334,'Retail Sale Id 1321912',6301.04,0.00,0.00,0.00,398.80,'2021-12-12 08:45:14','',''),(2254305,'1','136','779',334,'Retail sales',0.00,0.00,0.00,9.97,0.00,'2021-12-12 08:45:14','',''),(2254334,'1','136','779',334,'Retail Sale Id 1321930',11698.32,0.00,0.00,0.00,740.40,'2021-12-12 08:46:55','',''),(2254335,'1','136','779',334,'Retail sales',0.00,0.00,0.00,18.51,0.00,'2021-12-12 08:46:55','',''),(2254448,'1','136','779',334,'Retail Sale Id 1321978',1497.84,0.00,0.00,0.00,94.80,'2021-12-12 08:53:04','',''),(2254449,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 08:53:04','',''),(2254489,'1','136','779',334,'Retail Sale Id 1321999',2502.72,0.00,0.00,0.00,158.40,'2021-12-12 08:55:58','',''),(2254490,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-12 08:55:58','',''),(2254588,'1','136','779',334,'Retail Sale Id 1322048',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 09:01:36','',''),(2254589,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 09:01:36','',''),(2254614,'1','136','779',334,'Retail Sale Id 1322062',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 09:02:51','',''),(2254615,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 09:02:51','',''),(2254639,'1','136','779',334,'Retail Sale Id 1322072',998.56,0.00,0.00,0.00,63.20,'2021-12-12 09:03:56','',''),(2254640,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 09:03:56','',''),(2254807,'1','136','779',334,'Retail Sale Id 1322157',99960.00,0.00,0.00,0.00,-680.00,'2021-12-12 09:12:40','',''),(2254808,'1','136','779',334,'Retail sales',0.00,0.00,0.00,170.00,0.00,'2021-12-12 09:12:40','',''),(2254851,'1','136','779',334,'Retail Sale Id 1322183',7002.56,0.00,0.00,0.00,443.20,'2021-12-12 09:15:06','',''),(2254852,'1','136','779',334,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-12 09:15:06','',''),(2254877,'1','136','779',334,'Retail Sale Id 1322198',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 09:16:56','',''),(2254878,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 09:16:56','',''),(2254986,'1','136','779',334,'Retail Sale Id 1322253',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 09:23:24','',''),(2254987,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 09:23:24','',''),(2255014,'1','136','779',334,'Retail Sale Id 1322267',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 09:24:59','',''),(2255015,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 09:24:59','',''),(2255042,'1','136','779',334,'Retail Sale Id 1322282',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 09:26:58','',''),(2255043,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:26:58','',''),(2255084,'1','136','779',334,'Retail Sale Id 1322299',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 09:29:48','',''),(2255085,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 09:29:48','',''),(2255106,'1','136','779',334,'Retail Sale Id 1322307',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 09:30:41','',''),(2255107,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:30:41','',''),(2255141,'1','136','779',334,'Retail Sale Id 1322322',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 09:32:23','',''),(2255142,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 09:32:23','',''),(2255245,'1','136','779',334,'Retail Sale Id 1322375',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 09:38:36','',''),(2255246,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 09:38:36','',''),(2255255,'1','136','779',334,'Retail Sale Id 1322384',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 09:39:43','',''),(2255256,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 09:39:43','',''),(2255269,'1','136','779',334,'Retail Sale Id 1322389',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 09:40:52','',''),(2255270,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:40:52','',''),(2255315,'1','136','779',334,'Retail Sale Id 1322403',105840.00,0.00,0.00,0.00,-720.00,'2021-12-12 09:44:23','',''),(2255316,'1','136','779',334,'Retail sales',0.00,0.00,0.00,180.00,0.00,'2021-12-12 09:44:23','',''),(2255343,'1','136','779',334,'Retail Sale Id 1322428',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 09:45:46','',''),(2255344,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 09:45:46','',''),(2255369,'1','136','779',334,'Retail Sale Id 1322439',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 09:46:53','',''),(2255370,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 09:46:53','',''),(2255405,'1','136','779',334,'Retail Sale Id 1322449',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 09:48:32','',''),(2255406,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:48:32','',''),(2255496,'1','136','779',334,'Retail Sale Id 1322494',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 09:53:07','',''),(2255497,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 09:53:07','',''),(2255524,'1','136','779',334,'Retail Sale Id 1322505',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 09:54:03','',''),(2255525,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 09:54:03','',''),(2255620,'1','136','779',334,'Retail Sale Id 1322550',1301.92,0.00,0.00,0.00,82.40,'2021-12-12 09:57:47','',''),(2255621,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 09:57:47','',''),(2255833,'1','136','779',334,'Retail Sale Id 1322652',7798.88,0.00,0.00,0.00,493.60,'2021-12-12 10:07:23','',''),(2255834,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.34,0.00,'2021-12-12 10:07:23','',''),(2255859,'1','136','779',334,'Retail Sale Id 1322666',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 10:08:27','',''),(2255860,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:08:27','',''),(2255867,'1','136','779',334,'Return of Retail Sale Id 1322652',0.00,7798.88,12.34,0.00,-493.60,'2021-12-12 10:09:11','',''),(2255936,'1','136','779',334,'Retail Sale Id 1322702',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 10:12:36','',''),(2255937,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 10:12:36','',''),(2256014,'1','136','779',334,'Retail Sale Id 1322736',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 10:16:20','',''),(2256015,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 10:16:20','',''),(2256053,'1','136','779',334,'Retail Sale Id 1322766',1200.80,0.00,0.00,0.00,76.00,'2021-12-12 10:18:21','',''),(2256054,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-12 10:18:21','',''),(2256119,'1','136','779',334,'Retail Sale Id 1322805',6320.00,0.00,0.00,0.00,400.00,'2021-12-12 10:23:44','',''),(2256120,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-12 10:23:44','',''),(2256149,'1','136','779',334,'Retail Sale Id 1322820',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 10:25:13','',''),(2256150,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 10:25:13','',''),(2256175,'1','136','779',334,'Retail Sale Id 1322832',7002.56,0.00,0.00,0.00,443.20,'2021-12-12 10:26:12','',''),(2256176,'1','136','779',334,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-12 10:26:12','',''),(2256211,'1','136','779',334,'Retail Sale Id 1322852',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 10:28:15','',''),(2256212,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 10:28:15','',''),(2256245,'1','136','779',334,'Retail Sale Id 1322872',998.56,0.00,0.00,0.00,63.20,'2021-12-12 10:30:18','',''),(2256246,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 10:30:18','',''),(2256271,'1','136','779',334,'Retail Sale Id 1322884',998.56,0.00,0.00,0.00,63.20,'2021-12-12 10:31:19','',''),(2256272,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 10:31:19','',''),(2256337,'1','136','779',334,'Retail Sale Id 1322914',69384.00,0.00,0.00,0.00,-472.00,'2021-12-12 10:34:38','',''),(2256338,'1','136','779',334,'Retail sales',0.00,0.00,0.00,118.00,0.00,'2021-12-12 10:34:38','',''),(2256379,'1','136','779',334,'Retail Sale Id 1322945',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 10:36:56','',''),(2256380,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 10:36:56','',''),(2256399,'1','136','779',334,'Retail Sale Id 1322954',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 10:38:02','',''),(2256400,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 10:38:02','',''),(2256417,'1','136','779',334,'Retail Sale Id 1322964',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 10:38:58','',''),(2256418,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 10:38:58','',''),(2256445,'1','136','779',334,'Retail Sale Id 1322979',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 10:40:23','',''),(2256446,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 10:40:23','',''),(2256475,'1','136','779',334,'Retail Sale Id 1322994',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 10:41:45','',''),(2256476,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 10:41:45','',''),(2256520,'1','136','779',334,'Retail Sale Id 1323012',4000.56,0.00,0.00,0.00,253.20,'2021-12-12 10:43:44','',''),(2256521,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-12 10:43:44','',''),(2256560,'1','136','779',334,'Retail Sale Id 1323029',2502.72,0.00,0.00,0.00,158.40,'2021-12-12 10:45:12','',''),(2256561,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-12 10:45:12','',''),(2256582,'1','136','779',334,'Retail Sale Id 1323038',2502.72,0.00,0.00,0.00,158.40,'2021-12-12 10:46:19','',''),(2256583,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-12 10:46:19','',''),(2256604,'1','136','779',334,'Retail Sale Id 1323047',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 10:47:18','',''),(2256605,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 10:47:18','',''),(2256640,'1','136','779',334,'Retail Sale Id 1323073',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 10:49:27','',''),(2256641,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 10:49:27','',''),(2256668,'1','136','779',334,'Retail Sale Id 1323086',15800.00,0.00,0.00,0.00,1000.00,'2021-12-12 10:50:30','',''),(2256669,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-12 10:50:30','',''),(2256689,'1','136','779',334,'Retail Sale Id 1323096',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 10:51:36','',''),(2256690,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 10:51:36','',''),(2256715,'1','136','779',334,'Retail Sale Id 1323112',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 10:52:48','',''),(2256716,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:52:48','',''),(2256779,'1','136','779',334,'Retail Sale Id 1323141',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 10:55:47','',''),(2256780,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:55:47','',''),(2256798,'1','136','779',334,'Retail Sale Id 1323153',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 10:56:31','',''),(2256799,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 10:56:31','',''),(2256830,'1','136','779',334,'Retail Sale Id 1323168',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 10:57:45','',''),(2256831,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:57:45','',''),(2257002,'1','136','779',334,'Retail Sale Id 1323248',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 11:04:31','',''),(2257003,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 11:04:31','',''),(2257040,'1','136','779',334,'Retail Sale Id 1323273',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 11:06:26','',''),(2257041,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 11:06:26','',''),(2257078,'1','136','779',334,'Retail Sale Id 1323292',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 11:07:48','',''),(2257079,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:07:48','',''),(2257108,'1','136','779',334,'Retail Sale Id 1323311',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 11:08:53','',''),(2257109,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 11:08:53','',''),(2257145,'1','136','779',334,'Retail Sale Id 1323327',5997.68,0.00,0.00,0.00,379.60,'2021-12-12 11:09:58','',''),(2257146,'1','136','779',334,'Retail sales',0.00,0.00,0.00,9.49,0.00,'2021-12-12 11:09:58','',''),(2257172,'1','136','779',334,'Retail Sale Id 1323339',11401.28,0.00,0.00,0.00,721.60,'2021-12-12 11:11:37','',''),(2257173,'1','136','779',334,'Retail sales',0.00,0.00,0.00,18.04,0.00,'2021-12-12 11:11:37','',''),(2257203,'1','136','779',334,'Retail Sale Id 1323355',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 11:12:57','',''),(2257204,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:12:57','',''),(2257291,'1','136','779',334,'Retail Sale Id 1323392',3002.00,0.00,0.00,0.00,190.00,'2021-12-12 11:16:11','',''),(2257292,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 11:16:11','',''),(2257359,'1','136','779',334,'Retail Sale Id 1323439',105840.00,0.00,0.00,0.00,-720.00,'2021-12-12 11:19:20','',''),(2257360,'1','136','779',334,'Retail sales',0.00,0.00,0.00,180.00,0.00,'2021-12-12 11:19:20','',''),(2257435,'1','136','779',334,'Retail Sale Id 1323469',998.56,0.00,0.00,0.00,63.20,'2021-12-12 11:21:56','',''),(2257436,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 11:21:56','',''),(2257459,'1','136','779',334,'Retail Sale Id 1323482',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 11:23:18','',''),(2257460,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 11:23:18','',''),(2257672,'1','136','779',334,'Retail Sale Id 1323597',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 11:33:31','',''),(2257673,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 11:33:31','',''),(2257694,'1','136','779',334,'Retail Sale Id 1323611',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 11:34:35','',''),(2257695,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 11:34:35','',''),(2257743,'1','136','779',334,'Retail Sale Id 1323633',998.56,0.00,0.00,0.00,63.20,'2021-12-12 11:37:04','',''),(2257744,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 11:37:04','',''),(2257761,'1','136','779',334,'Retail Sale Id 1323646',15800.00,0.00,0.00,0.00,1000.00,'2021-12-12 11:37:58','',''),(2257762,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-12 11:37:58','',''),(2257798,'1','136','779',334,'Retail Sale Id 1323663',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 11:39:59','',''),(2257799,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:39:59','',''),(2257838,'1','136','779',334,'Retail Sale Id 1323678',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 11:41:10','',''),(2257839,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 11:41:10','',''),(2257869,'1','136','779',334,'Retail Sale Id 1323690',64680.00,0.00,0.00,0.00,-440.00,'2021-12-12 11:42:45','',''),(2257870,'1','136','779',334,'Retail sales',0.00,0.00,0.00,110.00,0.00,'2021-12-12 11:42:45','',''),(2257895,'1','136','779',334,'Retail Sale Id 1323705',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 11:43:56','',''),(2257896,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:43:56','',''),(2257913,'1','136','779',334,'Retail Sale Id 1323715',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 11:44:50','',''),(2257914,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 11:44:50','',''),(2258001,'1','136','779',334,'Retail Sale Id 1323755',25872.00,0.00,0.00,0.00,-176.00,'2021-12-12 11:49:20','',''),(2258002,'1','136','779',334,'Retail sales',0.00,0.00,0.00,44.00,0.00,'2021-12-12 11:49:20','',''),(2258014,'1','136','779',334,'Retail Sale Id 1323764',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 11:50:01','',''),(2258015,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:50:01','',''),(2258046,'1','136','779',334,'Retail Sale Id 1323777',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 11:51:24','',''),(2258047,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 11:51:24','',''),(2258150,'1','136','779',334,'Retail Sale Id 1323826',1580.00,0.00,0.00,0.00,100.00,'2021-12-12 11:55:33','',''),(2258151,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-12 11:55:33','',''),(2258170,'1','136','779',334,'Retail Sale Id 1323835',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 11:56:34','',''),(2258171,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:56:34','',''),(2258194,'1','136','779',334,'Retail Sale Id 1323849',998.56,0.00,0.00,0.00,63.20,'2021-12-12 11:58:01','',''),(2258195,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 11:58:01','',''),(2258368,'1','136','779',334,'Retail Sale Id 1323933',88200.00,0.00,0.00,0.00,-600.00,'2021-12-12 12:08:14','',''),(2258369,'1','136','779',334,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-12 12:08:14','',''),(2258378,'1','136','779',334,'Retail Sale Id 1323938',2502.72,0.00,0.00,0.00,158.40,'2021-12-12 12:08:54','',''),(2258379,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-12 12:08:54','',''),(2258388,'1','136','779',334,'Retail Sale Id 1323943',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 12:09:47','',''),(2258389,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 12:09:47','',''),(2258402,'1','136','779',334,'Retail Sale Id 1323950',3501.28,0.00,0.00,0.00,221.60,'2021-12-12 12:10:33','',''),(2258403,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.54,0.00,'2021-12-12 12:10:33','',''),(2258432,'1','136','779',334,'Retail Sale Id 1323964',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 12:11:55','',''),(2258433,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 12:11:55','',''),(2258468,'1','136','779',334,'Retail Sale Id 1323983',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 12:13:43','',''),(2258469,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 12:13:43','',''),(2258530,'1','136','779',334,'Retail Sale Id 1324008',998.56,0.00,0.00,0.00,63.20,'2021-12-12 12:16:18','',''),(2258531,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 12:16:18','',''),(2258594,'1','136','779',334,'Retail Sale Id 1324040',3002.00,0.00,0.00,0.00,190.00,'2021-12-12 12:19:00','',''),(2258595,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 12:19:00','',''),(2258630,'1','136','779',334,'Retail Sale Id 1324059',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 12:21:05','',''),(2258631,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 12:21:05','',''),(2258668,'1','136','779',334,'Retail Sale Id 1324077',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 12:23:14','',''),(2258669,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 12:23:14','',''),(2258710,'1','136','779',334,'Retail Sale Id 1324100',20580.00,0.00,0.00,0.00,-140.00,'2021-12-12 12:25:28','',''),(2258711,'1','136','779',334,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-12 12:25:28','',''),(2258805,'1','136','779',334,'Retail Sale Id 1324134',998.56,0.00,0.00,0.00,63.20,'2021-12-12 12:28:41','',''),(2258806,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 12:28:41','',''),(2258897,'1','136','779',334,'Retail Sale Id 1324175',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 12:32:23','',''),(2258898,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 12:32:23','',''),(2258962,'1','136','779',334,'Retail Sale Id 1324215',58800.00,0.00,0.00,0.00,-400.00,'2021-12-12 12:35:30','',''),(2258963,'1','136','779',334,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-12 12:35:30','',''),(2259021,'1','136','779',334,'Retail Sale Id 1324242',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 12:38:00','',''),(2259022,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 12:38:00','',''),(2259058,'1','136','779',334,'Retail Sale Id 1324261',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 12:39:31','',''),(2259059,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 12:39:31','',''),(2259121,'1','136','779',334,'Retail Sale Id 1324294',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 12:43:01','',''),(2259122,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 12:43:01','',''),(2259149,'1','136','779',334,'Retail Sale Id 1324309',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 12:44:34','',''),(2259150,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 12:44:34','',''),(2259212,'1','136','779',334,'Retail Sale Id 1324332',4999.12,0.00,0.00,0.00,316.40,'2021-12-12 12:47:04','',''),(2259213,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-12 12:47:04','',''),(2259244,'1','136','779',334,'Retail Sale Id 1324348',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 12:48:15','',''),(2259245,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 12:48:15','',''),(2259308,'1','136','779',334,'Retail Sale Id 1324379',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 12:51:10','',''),(2259309,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 12:51:10','',''),(2259425,'1','136','779',334,'Retail Sale Id 1324436',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 12:56:52','',''),(2259426,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 12:56:52','',''),(2259463,'1','136','779',334,'Retail Sale Id 1324456',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 12:59:05','',''),(2259464,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 12:59:05','',''),(2259503,'1','136','779',334,'Retail Sale Id 1324471',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 13:01:26','',''),(2259504,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 13:01:26','',''),(2259525,'1','136','779',334,'Retail Sale Id 1324483',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 13:03:00','',''),(2259526,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 13:03:00','',''),(2259541,'1','136','779',334,'Retail Sale Id 1324496',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 13:03:50','',''),(2259542,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 13:03:50','',''),(2259637,'1','136','779',334,'Retail Sale Id 1324545',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 13:09:23','',''),(2259638,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 13:09:23','',''),(2259697,'1','136','779',334,'Retail Sale Id 1324580',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 13:13:09','',''),(2259698,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 13:13:09','',''),(2259741,'1','136','779',334,'Retail Sale Id 1324598',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 13:15:28','',''),(2259742,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 13:15:28','',''),(2259774,'1','136','779',334,'Retail Sale Id 1324613',2546.96,0.00,0.00,0.00,161.20,'2021-12-12 13:16:36','',''),(2259775,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-12 13:16:36','',''),(2259792,'1','136','779',334,'Retail Sale Id 1324622',88200.00,0.00,0.00,0.00,-600.00,'2021-12-12 13:17:34','',''),(2259793,'1','136','779',334,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-12 13:17:34','',''),(2259889,'1','136','779',334,'Retail Sale Id 1324664',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 13:22:27','',''),(2259890,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 13:22:27','',''),(2259948,'1','136','779',334,'Retail Sale Id 1324685',29400.00,0.00,0.00,0.00,-200.00,'2021-12-12 13:25:16','',''),(2259949,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 13:25:16','',''),(2259966,'1','136','779',334,'Retail Sale Id 1324695',4449.28,0.00,0.00,0.00,281.60,'2021-12-12 13:26:21','',''),(2259967,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.04,0.00,'2021-12-12 13:26:21','',''),(2260033,'1','136','779',334,'Retail Sale Id 1324718',998.56,0.00,0.00,0.00,63.20,'2021-12-12 13:28:14','',''),(2260034,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 13:28:14','',''),(2260098,'1','136','779',334,'Retail Sale Id 1324743',11760.00,0.00,0.00,0.00,-80.00,'2021-12-12 13:30:51','',''),(2260099,'1','136','779',334,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-12 13:30:51','',''),(2260358,'1','136','779',334,'Retail Sale Id 1324857',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 13:43:35','',''),(2260359,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 13:43:35','',''),(2260368,'1','136','779',334,'Retail Sale Id 1324862',998.56,0.00,0.00,0.00,63.20,'2021-12-12 13:44:36','',''),(2260369,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 13:44:36','',''),(2260392,'1','136','779',334,'Retail Sale Id 1324876',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 13:45:53','',''),(2260393,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 13:45:53','',''),(2260472,'1','136','779',334,'Retail Sale Id 1324914',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 13:50:05','',''),(2260473,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 13:50:05','',''),(2260496,'1','136','779',334,'Retail Sale Id 1324928',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 13:51:11','',''),(2260497,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 13:51:11','',''),(2260546,'1','136','779',334,'Retail Sale Id 1324940',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 13:52:22','',''),(2260547,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 13:52:22','',''),(2260580,'1','136','779',334,'Retail Sale Id 1324958',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 13:54:56','',''),(2260581,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 13:54:56','',''),(2260607,'1','136','779',334,'Retail Sale Id 1324968',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 13:56:10','',''),(2260608,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 13:56:10','',''),(2260719,'1','136','779',334,'Retail Sale Id 1325009',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 14:00:15','',''),(2260720,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 14:00:15','',''),(2260791,'1','136','779',334,'Retail Sale Id 1325027',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 14:02:46','',''),(2260792,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 14:02:46','',''),(2260880,'1','136','779',334,'Retail Sale Id 1325067',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 14:07:11','',''),(2260881,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 14:07:11','',''),(2260910,'1','136','779',334,'Retail Sale Id 1325082',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 14:08:31','',''),(2260911,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 14:08:31','',''),(2260942,'1','136','779',334,'Retail Sale Id 1325095',998.56,0.00,0.00,0.00,63.20,'2021-12-12 14:10:16','',''),(2260943,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 14:10:16','',''),(2261067,'1','136','779',334,'Retail Sale Id 1325150',6402.16,0.00,0.00,0.00,405.20,'2021-12-12 14:17:01','',''),(2261068,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.13,0.00,'2021-12-12 14:17:01','',''),(2261100,'1','136','779',334,'Retail Sale Id 1325160',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 14:18:19','',''),(2261101,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 14:18:19','',''),(2261122,'1','136','779',334,'Retail Sale Id 1325173',998.56,0.00,0.00,0.00,63.20,'2021-12-12 14:20:15','',''),(2261123,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 14:20:15','',''),(2261138,'1','136','779',334,'Retail Sale Id 1325179',2546.96,0.00,0.00,0.00,161.20,'2021-12-12 14:21:18','',''),(2261139,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-12 14:21:18','',''),(2261169,'1','136','779',334,'Retail Sale Id 1325191',1301.92,0.00,0.00,0.00,82.40,'2021-12-12 14:22:40','',''),(2261170,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 14:22:40','',''),(2261212,'1','136','779',334,'Retail Sale Id 1325204',69384.00,0.00,0.00,0.00,-472.00,'2021-12-12 14:24:50','',''),(2261213,'1','136','779',334,'Retail sales',0.00,0.00,0.00,118.00,0.00,'2021-12-12 14:24:50','',''),(2261390,'1','136','779',334,'Retail Sale Id 1325252',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 14:30:09','',''),(2261391,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 14:30:09','',''),(2261433,'1','136','779',334,'Retail Sale Id 1325271',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 14:32:54','',''),(2261434,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 14:32:54','',''),(2261447,'1','136','779',334,'Retail Sale Id 1325279',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 14:34:05','',''),(2261448,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 14:34:05','',''),(2261463,'1','136','779',334,'Retail Sale Id 1325287',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 14:34:38','',''),(2261464,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 14:34:38','',''),(2261469,'1','136','779',334,'Return of Retail Sale Id 1325287',0.00,1997.12,3.16,0.00,-126.40,'2021-12-12 14:35:03','',''),(2261490,'1','136','779',334,'Retail Sale Id 1325301',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 14:35:52','',''),(2261491,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 14:35:52','',''),(2261543,'1','136','779',334,'Retail Sale Id 1325324',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 14:38:37','',''),(2261544,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 14:38:37','',''),(2261693,'1','136','779',334,'Retail Sale Id 1325394',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 14:48:32','',''),(2261694,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 14:48:32','',''),(2261743,'1','136','779',334,'Retail Sale Id 1325411',3160.00,0.00,0.00,0.00,200.00,'2021-12-12 14:49:59','',''),(2261744,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 14:49:59','',''),(2261763,'1','136','779',334,'Retail Sale Id 1325425',998.56,0.00,0.00,0.00,63.20,'2021-12-12 14:51:02','',''),(2261764,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 14:51:02','',''),(2261781,'1','136','779',334,'Retail Sale Id 1325435',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 14:52:13','',''),(2261782,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 14:52:13','',''),(2261825,'1','136','779',334,'Retail Sale Id 1325451',9480.00,0.00,0.00,0.00,600.00,'2021-12-12 14:54:53','',''),(2261826,'1','136','779',334,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-12 14:54:53','',''),(2262383,'1','136','779',334,'Retail Sale Id 1325693',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 15:25:39','',''),(2262384,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 15:25:39','',''),(2262414,'1','136','779',334,'Retail Sale Id 1325708',2502.72,0.00,0.00,0.00,158.40,'2021-12-12 15:27:14','',''),(2262415,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-12 15:27:15','',''),(2263234,'1','136','779',334,'Retail Sale Id 1326103',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 16:18:14','',''),(2263235,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 16:18:14','',''),(2263540,'1','136','779',334,'Retail Sale Id 1326234',3002.00,0.00,0.00,0.00,190.00,'2021-12-12 16:35:18','',''),(2263541,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 16:35:18','',''),(2263634,'1','136','779',334,'Retail Sale Id 1326281',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 16:42:16','',''),(2263635,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 16:42:16','',''),(2264077,'1','136','779',334,'Retail Sale Id 1326476',20580.00,0.00,0.00,0.00,-140.00,'2021-12-12 17:08:47','',''),(2264078,'1','136','779',334,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-12 17:08:47','',''),(2264328,'1','136','779',334,'Retail Sale Id 1326588',2528.00,0.00,0.00,0.00,160.00,'2021-12-12 17:37:49','',''),(2264329,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 17:37:49','',''),(2264337,'1','136','779',334,'Retail Sale Id 1326593',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 17:39:26','',''),(2264338,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 17:39:26','',''),(2264347,'1','136','779',334,'Retail Sale Id 1326597',998.56,0.00,0.00,0.00,63.20,'2021-12-12 17:40:17','',''),(2264348,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 17:40:17','',''),(2264365,'1','136','779',334,'Retail Sale Id 1326601',101556.08,0.00,0.00,0.00,6427.60,'2021-12-12 17:41:55','',''),(2264366,'1','136','779',334,'Retail sales',0.00,0.00,0.00,160.69,0.00,'2021-12-12 17:41:55','',''),(2264452,'1','136','779',334,'Retail Sale Id 1326644',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 17:54:38','',''),(2264453,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 17:54:38','',''),(2267508,'1','136','779',334,'Retail Sale Id 1327801',29400.00,0.00,0.00,0.00,-200.00,'2021-12-13 08:35:26','',''),(2267509,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 08:35:26','',''),(2267653,'1','136','779',334,'Retail Sale Id 1327857',110250.00,0.00,0.00,0.00,-750.00,'2021-12-13 08:41:40','',''),(2267654,'1','136','779',334,'Retail sales',0.00,0.00,0.00,187.50,0.00,'2021-12-13 08:41:40','',''),(2267682,'1','136','779',334,'Retail Sale Id 1327877',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 08:43:38','',''),(2267683,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 08:43:38','',''),(2267696,'1','136','779',334,'Retail Sale Id 1327884',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 08:44:30','',''),(2267697,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 08:44:30','',''),(2267904,'1','136','779',334,'Retail Sale Id 1327948',6402.16,0.00,0.00,0.00,405.20,'2021-12-13 08:55:23','',''),(2267905,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.13,0.00,'2021-12-13 08:55:23','',''),(2267932,'1','136','779',334,'Retail Sale Id 1327962',14700.00,0.00,0.00,0.00,-100.00,'2021-12-13 08:57:11','',''),(2267933,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-13 08:57:11','',''),(2267980,'1','136','779',334,'Retail Sale Id 1327975',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 08:58:47','',''),(2267981,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 08:58:47','',''),(2268033,'1','136','779',334,'Retail Sale Id 1328000',3160.00,0.00,0.00,0.00,200.00,'2021-12-13 09:02:30','',''),(2268034,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 09:02:30','',''),(2268236,'1','136','779',334,'Retail Sale Id 1328089',7900.00,0.00,0.00,0.00,500.00,'2021-12-13 09:12:41','',''),(2268237,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 09:12:41','',''),(2268252,'1','136','779',334,'Retail Sale Id 1328098',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 09:13:24','',''),(2268253,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 09:13:24','',''),(2268274,'1','136','779',334,'Retail Sale Id 1328108',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 09:15:31','',''),(2268275,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 09:15:31','',''),(2268356,'1','136','779',334,'Retail Sale Id 1328150',998.56,0.00,0.00,0.00,63.20,'2021-12-13 09:20:29','',''),(2268357,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 09:20:29','',''),(2268380,'1','136','779',334,'Retail Sale Id 1328161',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 09:21:58','',''),(2268381,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 09:21:58','',''),(2268464,'1','136','779',334,'Retail Sale Id 1328202',42500.64,0.00,0.00,0.00,-289.12,'2021-12-13 09:26:18','',''),(2268465,'1','136','779',334,'Retail sales',0.00,0.00,0.00,72.28,0.00,'2021-12-13 09:26:18','',''),(2268484,'1','136','779',334,'Retail Sale Id 1328213',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 09:27:30','',''),(2268485,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 09:27:30','',''),(2268532,'1','136','779',334,'Retail Sale Id 1328241',4424.00,0.00,0.00,0.00,280.00,'2021-12-13 09:30:38','',''),(2268533,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-13 09:30:38','',''),(2268556,'1','136','779',334,'Retail Sale Id 1328253',64680.00,0.00,0.00,0.00,-440.00,'2021-12-13 09:32:41','',''),(2268557,'1','136','779',334,'Retail sales',0.00,0.00,0.00,110.00,0.00,'2021-12-13 09:32:41','',''),(2268596,'1','136','779',334,'Retail Sale Id 1328274',998.56,0.00,0.00,0.00,63.20,'2021-12-13 09:35:17','',''),(2268597,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 09:35:17','',''),(2268612,'1','136','779',334,'Retail Sale Id 1328281',23520.00,0.00,0.00,0.00,-160.00,'2021-12-13 09:37:02','',''),(2268613,'1','136','779',334,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-13 09:37:02','',''),(2268662,'1','136','779',334,'Retail Sale Id 1328308',1301.92,0.00,0.00,0.00,82.40,'2021-12-13 09:40:39','',''),(2268663,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-13 09:40:39','',''),(2268678,'1','136','779',334,'Retail Sale Id 1328318',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 09:41:39','',''),(2268679,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 09:41:39','',''),(2268724,'1','136','779',334,'Retail Sale Id 1328341',7900.00,0.00,0.00,0.00,500.00,'2021-12-13 09:44:54','',''),(2268725,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 09:44:54','',''),(2268799,'1','136','779',334,'Retail Sale Id 1328378',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 09:48:55','',''),(2268800,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 09:48:55','',''),(2268857,'1','136','779',334,'Retail Sale Id 1328408',15800.00,0.00,0.00,0.00,1000.00,'2021-12-13 09:53:07','',''),(2268858,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-13 09:53:07','',''),(2268937,'1','136','779',334,'Retail Sale Id 1328442',29400.00,0.00,0.00,0.00,-200.00,'2021-12-13 09:57:02','',''),(2268938,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 09:57:02','',''),(2268955,'1','136','779',334,'Retail Sale Id 1328451',3197.92,0.00,0.00,0.00,202.40,'2021-12-13 09:58:17','',''),(2268956,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 09:58:17','',''),(2269067,'1','136','779',334,'Retail Sale Id 1328508',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 10:05:54','',''),(2269068,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 10:05:54','',''),(2269091,'1','136','779',334,'Retail Sale Id 1328523',7900.00,0.00,0.00,0.00,500.00,'2021-12-13 10:07:49','',''),(2269092,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 10:07:49','',''),(2269113,'1','136','779',334,'Retail Sale Id 1328536',4000.56,0.00,0.00,0.00,253.20,'2021-12-13 10:09:15','',''),(2269114,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-13 10:09:15','',''),(2269197,'1','136','779',334,'Retail Sale Id 1328590',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 10:15:54','',''),(2269198,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 10:15:54','',''),(2269309,'1','136','779',334,'Retail Sale Id 1328648',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 10:24:06','',''),(2269310,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 10:24:06','',''),(2269367,'1','136','779',334,'Retail Sale Id 1328677',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 10:29:12','',''),(2269368,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 10:29:12','',''),(2269381,'1','136','779',334,'Retail Sale Id 1328684',7900.00,0.00,0.00,0.00,500.00,'2021-12-13 10:30:04','',''),(2269382,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 10:30:04','',''),(2269403,'1','136','779',334,'Retail Sale Id 1328693',15800.00,0.00,0.00,0.00,1000.00,'2021-12-13 10:30:57','',''),(2269404,'1','136','779',334,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-13 10:30:57','',''),(2269517,'1','136','779',334,'Retail Sale Id 1328739',3950.00,0.00,0.00,0.00,250.00,'2021-12-13 10:36:58','',''),(2269518,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-13 10:36:58','',''),(2269531,'1','136','779',334,'Retail Sale Id 1328746',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 10:37:44','',''),(2269532,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 10:37:44','',''),(2269548,'1','136','779',334,'Retail Sale Id 1328755',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 10:39:06','',''),(2269549,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 10:39:06','',''),(2269644,'1','136','779',334,'Retail Sale Id 1328799',7900.00,0.00,0.00,0.00,500.00,'2021-12-13 10:44:47','',''),(2269645,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 10:44:47','',''),(2269756,'1','136','779',334,'Retail Sale Id 1328863',3160.00,0.00,0.00,0.00,200.00,'2021-12-13 10:50:48','',''),(2269757,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 10:50:48','',''),(2269862,'1','136','779',334,'Retail Sale Id 1328911',998.56,0.00,0.00,0.00,63.20,'2021-12-13 10:57:32','',''),(2269863,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 10:57:32','',''),(2270046,'1','136','779',334,'Retail Sale Id 1328994',4424.00,0.00,0.00,0.00,280.00,'2021-12-13 11:09:14','',''),(2270047,'1','136','779',334,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-13 11:09:14','',''),(2270109,'1','136','779',334,'Retail Sale Id 1329025',5997.68,0.00,0.00,0.00,379.60,'2021-12-13 11:14:49','',''),(2270110,'1','136','779',334,'Retail sales',0.00,0.00,0.00,9.49,0.00,'2021-12-13 11:14:49','',''),(2270439,'1','136','779',334,'Retail Sale Id 1329175',30576.00,0.00,0.00,0.00,-208.00,'2021-12-13 11:39:05','',''),(2270440,'1','136','779',334,'Retail sales',0.00,0.00,0.00,52.00,0.00,'2021-12-13 11:39:05','',''),(2270459,'1','136','779',334,'Retail Sale Id 1329191',58800.00,0.00,0.00,0.00,-400.00,'2021-12-13 11:40:30','',''),(2270460,'1','136','779',334,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-13 11:40:30','',''),(2270492,'1','136','779',334,'Retail Sale Id 1329206',176400.00,0.00,0.00,0.00,-1200.00,'2021-12-13 11:42:49','',''),(2270493,'1','136','779',334,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-13 11:42:49','',''),(2270617,'1','136','779',334,'Retail Sale Id 1329272',3160.00,0.00,0.00,0.00,200.00,'2021-12-13 11:56:16','',''),(2270618,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 11:56:16','',''),(2270689,'1','136','779',334,'Retail Sale Id 1329311',6320.00,0.00,0.00,0.00,400.00,'2021-12-13 12:02:48','',''),(2270690,'1','136','779',334,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-13 12:02:48','',''),(2270785,'1','136','779',334,'Retail Sale Id 1329367',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 12:11:22','',''),(2270786,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 12:11:22','',''),(2270803,'1','136','779',334,'Retail Sale Id 1329374',3160.00,0.00,0.00,0.00,200.00,'2021-12-13 12:12:34','',''),(2270804,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 12:12:34','',''),(2270809,'1','136','779',334,'Retail Sale Id 1329379',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 12:13:17','',''),(2270810,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 12:13:17','',''),(2270823,'1','136','779',334,'Retail Sale Id 1329385',998.56,0.00,0.00,0.00,63.20,'2021-12-13 12:14:20','',''),(2270824,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 12:14:20','',''),(2270837,'1','136','779',334,'Retail Sale Id 1329392',1497.84,0.00,0.00,0.00,94.80,'2021-12-13 12:15:02','',''),(2270838,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 12:15:02','',''),(2270863,'1','136','779',334,'Retail Sale Id 1329407',7900.00,0.00,0.00,0.00,500.00,'2021-12-13 12:16:30','',''),(2270864,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:16:30','',''),(2270883,'1','136','779',334,'Retail Sale Id 1329420',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 12:18:19','',''),(2270884,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 12:18:19','',''),(2271006,'1','136','779',334,'Retail Sale Id 1329483',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 12:27:11','',''),(2271007,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 12:27:11','',''),(2271022,'1','136','779',334,'Retail Sale Id 1329492',3197.92,0.00,0.00,0.00,202.40,'2021-12-13 12:28:30','',''),(2271023,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 12:28:30','',''),(2271052,'1','136','779',334,'Retail Sale Id 1329514',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 12:31:13','',''),(2271053,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 12:31:13','',''),(2271128,'1','136','779',334,'Retail Sale Id 1329561',1497.84,0.00,0.00,0.00,94.80,'2021-12-13 12:36:42','',''),(2271129,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 12:36:42','',''),(2271146,'1','136','779',334,'Retail Sale Id 1329572',3950.00,0.00,0.00,0.00,250.00,'2021-12-13 12:38:01','',''),(2271147,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-13 12:38:01','',''),(2271162,'1','136','779',334,'Retail Sale Id 1329579',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 12:39:19','',''),(2271163,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 12:39:19','',''),(2271261,'1','136','779',334,'Retail Sale Id 1329631',7900.00,0.00,0.00,0.00,500.00,'2021-12-13 12:45:45','',''),(2271262,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:45:45','',''),(2271352,'1','136','779',334,'Retail Sale Id 1329678',12008.00,0.00,0.00,0.00,760.00,'2021-12-13 12:52:05','',''),(2271353,'1','136','779',334,'Retail sales',0.00,0.00,0.00,19.00,0.00,'2021-12-13 12:52:05','',''),(2271469,'1','136','779',334,'Retail Sale Id 1329735',2502.72,0.00,0.00,0.00,158.40,'2021-12-13 12:58:23','',''),(2271470,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-13 12:58:23','',''),(2271545,'1','136','779',334,'Retail Sale Id 1329767',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 13:01:21','',''),(2271546,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 13:01:21','',''),(2271581,'1','136','779',334,'Retail Sale Id 1329782',7900.00,0.00,0.00,0.00,500.00,'2021-12-13 13:03:37','',''),(2271582,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 13:03:37','',''),(2271603,'1','136','779',334,'Retail Sale Id 1329794',29400.00,0.00,0.00,0.00,-200.00,'2021-12-13 13:05:54','',''),(2271604,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 13:05:54','',''),(2271760,'1','136','779',334,'Retail Sale Id 1329870',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 13:16:05','',''),(2271761,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 13:16:05','',''),(2271784,'1','136','779',334,'Retail Sale Id 1329880',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 13:17:14','',''),(2271785,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 13:17:14','',''),(2271852,'1','136','779',334,'Retail Sale Id 1329909',998.56,0.00,0.00,0.00,63.20,'2021-12-13 13:21:30','',''),(2271853,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 13:21:30','',''),(2271982,'1','136','779',334,'Retail Sale Id 1329948',29400.00,0.00,0.00,0.00,-200.00,'2021-12-13 13:26:36','',''),(2271983,'1','136','779',334,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 13:26:36','',''),(2272014,'1','136','779',334,'Retail Sale Id 1329964',998.56,0.00,0.00,0.00,63.20,'2021-12-13 13:28:40','',''),(2272015,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 13:28:40','',''),(2272186,'1','136','779',334,'Retail Sale Id 1330032',3197.92,0.00,0.00,0.00,202.40,'2021-12-13 13:39:03','',''),(2272187,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 13:39:03','',''),(2272262,'1','136','779',334,'Retail Sale Id 1330067',58800.00,0.00,0.00,0.00,-400.00,'2021-12-13 13:44:02','',''),(2272263,'1','136','779',334,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-13 13:44:02','',''),(2272282,'1','136','779',334,'Retail Sale Id 1330079',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 13:45:21','',''),(2272283,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 13:45:21','',''),(2272384,'1','136','779',334,'Retail Sale Id 1330110',1301.92,0.00,0.00,0.00,82.40,'2021-12-13 13:50:06','',''),(2272385,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-13 13:50:06','',''),(2272466,'1','136','779',334,'Retail Sale Id 1330152',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 13:54:21','',''),(2272467,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 13:54:21','',''),(2272523,'1','136','779',334,'Retail Sale Id 1330170',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 13:56:21','',''),(2272524,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 13:56:21','',''),(2272670,'1','136','779',334,'Retail Sale Id 1330245',3002.00,0.00,0.00,0.00,190.00,'2021-12-13 14:06:30','',''),(2272671,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 14:06:30','',''),(2272700,'1','136','779',334,'Retail Sale Id 1330253',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 14:08:23','',''),(2272701,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 14:08:23','',''),(2272736,'1','136','779',334,'Retail Sale Id 1330274',7900.00,0.00,0.00,0.00,500.00,'2021-12-13 14:10:39','',''),(2272737,'1','136','779',334,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 14:10:39','',''),(2272907,'1','136','779',334,'Retail Sale Id 1330426',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 14:19:55','',''),(2272908,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 14:19:55','',''),(2272916,'1','136','779',334,'Retail Sale Id 1330431',1598.96,0.00,0.00,0.00,101.20,'2021-12-13 14:20:25','',''),(2272917,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.53,0.00,'2021-12-13 14:20:25','',''),(2272950,'1','136','779',334,'Retail Sale Id 1330439',2546.96,0.00,0.00,0.00,161.20,'2021-12-13 14:22:00','',''),(2272951,'1','136','779',334,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-13 14:22:00','',''),(2272982,'1','136','779',334,'Retail Sale Id 1330459',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 14:24:27','',''),(2272983,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 14:24:27','',''),(2273098,'1','136','779',334,'Retail Sale Id 1330521',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 14:32:25','',''),(2273099,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 14:32:25','',''),(2273189,'1','136','779',334,'Retail Sale Id 1330545',2502.72,0.00,0.00,0.00,158.40,'2021-12-13 14:35:20','',''),(2273190,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-13 14:35:20','',''),(2273203,'1','136','779',334,'Retail Sale Id 1330556',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 14:36:45','',''),(2273204,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 14:36:45','',''),(2273342,'1','136','779',334,'Retail Sale Id 1330617',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 14:44:36','',''),(2273343,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 14:44:36','',''),(2273375,'1','136','779',334,'Retail Sale Id 1330639',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 14:46:54','',''),(2273376,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 14:46:54','',''),(2273417,'1','136','779',334,'Retail Sale Id 1330658',91728.00,0.00,0.00,0.00,-624.00,'2021-12-13 14:50:39','',''),(2273418,'1','136','779',334,'Retail sales',0.00,0.00,0.00,156.00,0.00,'2021-12-13 14:50:39','',''),(2273451,'1','136','779',334,'Retail Sale Id 1330678',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 14:52:45','',''),(2273452,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 14:52:45','',''),(2273465,'1','136','779',334,'Retail Sale Id 1330685',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 14:53:45','',''),(2273466,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 14:53:45','',''),(2273549,'1','136','779',334,'Retail Sale Id 1330728',3197.92,0.00,0.00,0.00,202.40,'2021-12-13 15:00:00','',''),(2273550,'1','136','779',334,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 15:00:00','',''),(2273557,'1','136','779',334,'Retail Sale Id 1330736',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 15:01:13','',''),(2273558,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 15:01:13','',''),(2273571,'1','136','779',334,'Retail Sale Id 1330749',802.64,0.00,0.00,0.00,50.80,'2021-12-13 15:02:07','',''),(2273572,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.27,0.00,'2021-12-13 15:02:07','',''),(2273581,'1','136','779',334,'Retail Sale Id 1330757',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 15:03:07','',''),(2273582,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 15:03:07','',''),(2273716,'1','136','779',334,'Retail Sale Id 1330826',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 15:10:55','',''),(2273717,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 15:10:55','',''),(2273730,'1','136','779',334,'Retail Sale Id 1330831',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 15:11:42','',''),(2273731,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 15:11:42','',''),(2273814,'1','136','779',334,'Retail Sale Id 1330867',4000.56,0.00,0.00,0.00,253.20,'2021-12-13 15:16:58','',''),(2273815,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-13 15:16:58','',''),(2274021,'1','136','779',334,'Retail Sale Id 1330952',2502.72,0.00,0.00,0.00,158.40,'2021-12-13 15:26:29','',''),(2274022,'1','136','779',334,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-13 15:26:29','',''),(2274079,'1','136','779',334,'Retail Sale Id 1330974',998.56,0.00,0.00,0.00,63.20,'2021-12-13 15:28:12','',''),(2274080,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 15:28:12','',''),(2274135,'1','136','779',334,'Retail Sale Id 1330998',5498.40,0.00,0.00,0.00,348.00,'2021-12-13 15:30:57','',''),(2274136,'1','136','779',334,'Retail sales',0.00,0.00,0.00,8.70,0.00,'2021-12-13 15:30:57','',''),(2274307,'1','136','779',334,'Retail Sale Id 1331074',998.56,0.00,0.00,0.00,63.20,'2021-12-13 15:37:48','',''),(2274308,'1','136','779',334,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 15:37:48','',''),(2274355,'1','136','779',334,'Retail Sale Id 1331097',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 15:39:50','',''),(2274356,'1','136','779',334,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 15:39:50','',''),(2274395,'1','136','779',334,'Retail Sale Id 1331120',1497.84,0.00,0.00,0.00,94.80,'2021-12-13 15:41:47','',''),(2274396,'1','136','779',334,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 15:41