-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_122
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_122`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_122` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_122`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3859 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3743,40055,'',0,'6.1','1','122','CASH','','2021-10-13 10:52:04',5,0.00,0.00,'','178','2021-10-13 10:52:04','178',0,1),(3744,400344,'',0,'24','1','122','PURCHASES','','2021-10-13 10:52:15',5,0.00,0.00,'','178','2021-10-13 10:52:15','178',0,1),(3745,400345,'',0,'24','1','122','SALARIES','','2021-10-13 10:52:37',5,0.00,0.00,'','178','2021-10-13 10:52:37','178',0,1),(3746,20055,'',0,'20','1','122','SALES','','2021-10-13 10:52:54',5,0.00,0.00,'','178','2021-10-13 10:52:54','178',0,1),(3749,400658,'',0,'2','1','122','UBA E-BILLS COLL ACC','','2021-10-14 14:35:19',5,0.00,0.00,'','454','2021-10-14 14:35:19','454',0,1),(3750,400659,'',0,'2','1','122','GTB POS','','2021-10-14 14:36:50',5,0.00,0.00,'','454','2021-10-14 14:36:50','454',0,1),(3852,400684,'',0,'2','1','122','FIDELITY POS','FIDELITY POS','2021-11-11 15:39:05',5,0.00,0.00,'','454','2021-11-11 15:39:05','454',0,0),(3853,1500,'',0,'5','1','122','INVENTORY VALUE ADJUSTMENT','','2022-02-07 16:55:33',5,0.00,0.00,'','454','2022-02-07 16:55:33','454',0,0),(3854,400685,'',0,'2','1','122','ZENITH BANK. 1221620079','','2022-04-01 08:12:41',5,0.00,0.00,'','454','2022-04-01 08:12:41','454',0,0),(3855,400686,'',0,'2','1','122','ECO POS','ECO POS','2022-06-14 14:56:22',5,0.00,0.00,'','454','2022-06-14 14:56:22','454',0,0),(3856,400687,'',0,'2','1','122','KEYSTONE SURPLUS','','2022-07-01 12:28:57',5,0.00,0.00,'','454','2022-07-01 12:28:57','454',0,0),(3857,400688,'',0,'2','1','122','UBA POS','','2022-08-04 12:50:18',5,0.00,0.00,'','454','2022-08-04 12:50:18','454',0,0),(3858,400689,'',0,'2','1','122','MONIE POINT POS ACCOUNT','','2023-03-10 17:15:48',5,0.00,0.00,'','454','2023-03-10 17:15:48','454',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=82327 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (82288,'1','122','0000-00-00','2022-01-18 11:05:45',10,'697','','0000-00-00 00:00:00','454','2022-02-22 13:25:39'),(82289,'1','122','0000-00-00','2022-02-07 17:40:33',10,'697','','0000-00-00 00:00:00','454','2022-02-22 13:26:04'),(82290,'1','122','0000-00-00','2022-02-07 17:44:35',10,'697','','0000-00-00 00:00:00','454','2022-02-22 13:27:34'),(82291,'1','122','0000-00-00','2022-02-07 17:51:56',10,'697','','0000-00-00 00:00:00','454','2022-02-22 13:27:47'),(82292,'1','122','0000-00-00','2022-02-09 10:34:30',10,'697','','0000-00-00 00:00:00','454','2022-02-22 13:28:05'),(82293,'1','122','0000-00-00','2022-02-13 13:01:34',10,'697','','0000-00-00 00:00:00','454','2022-02-22 13:28:17'),(82294,'1','122','0000-00-00','2022-02-15 15:57:38',10,'697','','0000-00-00 00:00:00','454','2022-02-22 13:28:31'),(82295,'1','122','0000-00-00','2022-02-22 14:51:08',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82296,'1','122','0000-00-00','2022-03-18 14:48:03',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82297,'1','122','0000-00-00','2022-03-23 20:00:30',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82298,'1','122','0000-00-00','2022-05-18 12:47:31',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82299,'1','122','0000-00-00','2022-05-18 13:02:43',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82300,'1','122','0000-00-00','2022-06-04 12:36:10',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82301,'1','122','0000-00-00','2022-06-08 23:35:02',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82302,'1','122','0000-00-00','2022-06-12 10:31:18',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82303,'1','122','0000-00-00','2022-06-16 11:29:28',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82304,'1','122','0000-00-00','2022-07-11 22:15:21',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82305,'1','122','0000-00-00','2022-07-18 18:42:37',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82306,'1','122','0000-00-00','2022-07-21 10:48:40',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82307,'1','122','0000-00-00','2022-07-23 11:25:22',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82308,'1','122','0000-00-00','2022-08-18 10:53:36',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82309,'1','122','0000-00-00','2022-09-30 10:42:58',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82310,'1','122','0000-00-00','2022-10-14 15:09:13',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82311,'1','122','0000-00-00','2022-11-06 22:06:28',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82312,'1','122','0000-00-00','2022-11-07 16:53:00',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82313,'1','122','0000-00-00','2022-11-07 17:01:23',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82314,'1','122','0000-00-00','2022-11-10 01:10:46',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82315,'1','122','0000-00-00','2022-11-11 10:11:06',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82316,'1','122','0000-00-00','2022-11-19 16:56:42',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82317,'1','122','0000-00-00','2023-01-18 17:55:21',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82318,'1','122','0000-00-00','2023-01-19 06:57:21',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82319,'1','122','0000-00-00','2023-01-19 13:39:16',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82320,'1','122','0000-00-00','2023-01-21 07:55:25',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82321,'1','122','0000-00-00','2023-01-21 08:27:41',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82322,'1','122','0000-00-00','2023-01-21 09:45:22',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82323,'1','122','0000-00-00','2023-02-03 15:33:05',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82324,'1','122','0000-00-00','2023-03-03 10:04:48',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82325,'1','122','0000-00-00','2023-03-15 09:13:23',5,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82326,'1','122','0000-00-00','2023-03-20 08:06:58',0,'697','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=174731 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (174639,'1','122','82288','307','supplier',142500.00,'INVENTRY ADJUSTMENT OF AGO INCREAMENT FROM 345 TO 350 (DIPPING 28,500) @ 5',0.00,'2022-01-18'),(174640,'1','122','82288','3853','5',0.00,'INVENTORY VALUE ADJUSTEMENT FOR AGO FROM 345 TO 350 @5 (DIPPIND 28,500)NAIRA',142500.00,'2022-01-18'),(174641,'1','122','82289','307','supplier',102000.00,'INVENTRY ADJUSTMENT OF AGO INCREAMENT FROM 350 TO 355 (DIPPING 20,400) @ 5',0.00,'2022-01-21'),(174642,'1','122','82289','3853','5',0.00,'INVENTORY VALUE ADJUSTEMENT FOR AGO FROM 350 TO 355 (DIPPIND 20,400) @5 NAIRA',102000.00,'2022-01-21'),(174643,'1','122','82290','307','supplier',12500.00,'INVENTRY ADJUSTMENT OF AGO INCREAMENT FROM 355 TO 360 (DIPPING 2,500) @ 5',0.00,'2022-01-28'),(174644,'1','122','82290','3853','5',0.00,'INVENTORY VALUE ADJUSTEMENT FOR AGO FROM 355 TO 360 @5 (DIPPIND 2,500)NAIRA',12500.00,'2022-01-28'),(174645,'1','122','82291','307','supplier',508000.00,'INVENTRY ADJUSTMENT OF AGO INCREMENT FROM 360 TO 380 (DIPPING 25,400) @ 20',0.00,'2022-02-05'),(174646,'1','122','82291','3853','5',0.00,'INVENTORY VALUE ADJUSTEMENT FOR AGO FROM 360 TO 380 (DIPPIND 25,400) @20 NAIRA',508000.00,'2022-02-05'),(174647,'1','122','82292','307','supplier',182000.00,'INVENTORY ADJUSTMENT OF AGO INCREAMENT FROM 380 TO 390 (DIPPING 18,200) @ 10',0.00,'2022-02-09'),(174648,'1','122','82292','3853','5',0.00,'INVENTORY VALUE ADJUSTEMENT FOR AGO FROM 380 TO 390 (DIPPING 18,200) @10 NAIRA',182000.00,'2022-02-09'),(174649,'1','122','82293','307','supplier',70000.00,'INVENTORY ADJUSTMENT OF AGO INCREAMENT FROM 390 TO 400 (DIPPING  7000) @10',0.00,'2022-02-13'),(174650,'1','122','82293','3853','5',0.00,'INVENTORY VALUE ADJUSTEMENT FOR AGO FROM 390 TO 400 (DIPPIND 7000) @10 NAIRA',70000.00,'2022-02-13'),(174651,'1','122','82294','307','supplier',481500.00,'INVENTRY ADJUSTMENT OF AGO INCREAMENT FROM 400 TO 410 (DIPPING 48150) @ 10',0.00,'2022-02-15'),(174652,'1','122','82294','3853','5',0.00,'INVENTORY VALUE ADJUSTEMENT FOR AGO FROM 400 TO 410 (DIPPIND 48,150) @10 NAIRA',481500.00,'2022-02-15'),(174653,'1','122','82295','307','supplier',149000.00,'INVENTRY ADJUSTMENT OF AGO INCREAMENT FROM 410 TO 415 (DIPPING 29,800) @ 5 NAIRA.',0.00,'2022-02-22'),(174654,'1','122','82295','3853','5',0.00,'INVENTORY VALUE ADJUSTEMENT FOR AGO FROM 410 TO 415 @5 (DIPPIND 29,800)NAIRA',149000.00,'2022-02-22'),(174655,'1','122','82296','307','supplier',150000.00,'INVENTRY ADJUSTMENT OF AGO INCREAMENT FROM 650 TO 660 (DIPPING 15,000) @ 10',0.00,'2022-03-17'),(174656,'1','122','82296','3853','5',0.00,'INVENTRY ADJUSTMENT OF AGO INCREAMENT FROM 650 TO 660 (DIPPING 15000) @ 10',150000.00,'2022-03-17'),(174660,'1','122','82296','307','supplier',436000.00,'INVENTRY ADJUSTMENT OF AGO INCREAMENT FROM 660 TO 680 (DIPPING 21,800) @ 20',0.00,'2022-03-21'),(174661,'1','122','82296','3853','5',0.00,'INVENTRY ADJUSTMENT OF AGO INCREAMENT FROM 660 TO 680 (DIPPING 21,800) @ 20',436000.00,'2022-03-21'),(174662,'1','122','82297','307','supplier',418000.00,'INVENTRY ADJUSTMENT OF AGO INCREAMENT FROM 680 TO 700 (DIPPING 20,900) @ 20',0.00,'2022-03-23'),(174663,'1','122','82297','3853','5',0.00,'INVENTRY ADJUSTMENT OF AGO INCREAMENT FROM 680 TO 700 (DIPPING 209,00) @ 20',418000.00,'2022-03-23'),(174664,'1','122','82298','3853','5',0.00,'INVENTRY ADJUSTMENT OF AGO INCREAMENT FROM 700 TO 720 (DIPPING 12,00) @ 20',24000.00,'2022-05-18'),(174665,'1','122','82298','307','supplier',24000.00,'INVENTRY ADJUSTMENT OF AGO INCREAMENT FROM 700 TO 720 (DIPPING 12,00) @ 20',0.00,'2022-05-18'),(174666,'1','122','82299','3853','5',0.00,'INVENTRY ADJUSTMENT OF AGO INCREAMENT FROM 700 TO 720 (DIPPING 12,00) @ 20',24000.00,'2022-05-18'),(174667,'1','122','82299','307','supplier',24000.00,'INVENTRY ADJUSTMENT OF AGO INCREAMENT FROM 700 TO 720 (DIPPING 12,00) @ 20',0.00,'2022-05-18'),(174669,'1','122','82300','3853','5',0.00,'INVENTRY ADJUSTMENT OF AGO INCREAMENT FROM 760 TO 770 (DIPPING 27500) @ 10',275000.00,'2022-06-04'),(174670,'1','122','82300','307','supplier',275000.00,'INVENTRY ADJUSTMENT OF AGO INCREAMENT FROM 760 TO 770 (DIPPING 27,500) @ 10',0.00,'2022-06-04'),(174671,'1','122','82301','307','supplier',48000.00,'INVENTRY ADJUSTMENT OF AGO INCREAMENT FROM 770 TO 800 (DIPPING 1,600) @ 30',0.00,'2022-06-08'),(174672,'1','122','82301','3853','5',0.00,'INVENTRY ADJUSTMENT OF AGO INCREAMENT FROM 770 TO 800 (DIPPING 1,600) @ 30',48000.00,'2022-06-08'),(174673,'1','122','82302','307','supplier',284000.00,'INVENTRY ADJUSTMENT OF AGO INCREAMENT FROM 800 TO 820 (DIPPING 14,200) @ 20',0.00,'2022-06-12'),(174674,'1','122','82302','3853','5',0.00,'INVENTRY ADJUSTMENT OF AGO INCREAMENT FROM 800 TO 820 (DIPPING 14,200) @ 20',284000.00,'2022-06-12'),(174675,'1','122','82303','307','supplier',398000.00,'INVENTRY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 820 TO 830 (DIPPING 39,800) @10',0.00,'2022-06-16'),(174676,'1','122','82303','3853','5',0.00,'INVENTRY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 820 TO 830 (DIPPING 39,800) @ 10',398000.00,'2022-06-16'),(174677,'1','122','82304','307','supplier',1221000.00,'INVENTRY ADJUSTMENT OF PMS INCREAMENT FROM 165 TO 185 (DIPPING 61,050) @20',0.00,'2022-07-11'),(174678,'1','122','82304','3853','5',0.00,'INVENTRY ADJUSTMENT OF PMS INCREAMENT FROM 165 TO 185 (DIPPING 61,050) @20',1221000.00,'2022-07-11'),(174679,'1','122','82305','307','supplier',0.00,'INVENTRY VALUE ADJUSTMENT OF PMS DICREAMENT FROM 185 TO 175 (DIPPING 3,1000 @10)',310000.00,'2022-07-18'),(174680,'1','122','82305','3853','5',310000.00,'INVENTRY VALUE ADJUSTMENT OF PMS DICREAMENT FROM 185 TO 175 (DIPPING 3,1000 @10)',0.00,'2022-07-18'),(174681,'1','122','82306','307','supplier',0.00,'INVENTRY VALUE ADJUSTMENT OF AGO DICREAMENT FROM 830 TO 820 (DIPPING 28,300 @10)',283000.00,'2022-07-21'),(174682,'1','122','82306','3853','5',283000.00,'INVENTRY VALUE ADJUSTMENT OF AGO DICREAMENT FROM 830 TO 820 (DIPPING 28,300 @10)	',0.00,'2022-07-21'),(174683,'1','122','82307','307','supplier',0.00,'INVENTRY VALUE ADJUSTMENT OF AGO DICREAMENT FROM 820 TO 810 (DIPPING 23,200 @10)',232000.00,'2022-07-23'),(174684,'1','122','82307','3853','5',232000.00,'INVENTRY VALUE ADJUSTMENT OF AGO DICREAMENT FROM 820 TO 810 (DIPPING 23,200 @10)',0.00,'2022-07-23'),(174685,'1','122','82308','307','supplier',0.00,'INVENTRY ADJUSTMENT OF AGO DICREAMENT FROM 810 TO 800 (DIPPING 6,900) @ 10',69000.00,'2022-08-18'),(174686,'1','122','82308','3853','5',69000.00,'INVENTRY ADJUSTMENT OF AGO DICREAMENT FROM 810 TO 800 (DIPPING 6,900) @ 10',0.00,'2022-08-18'),(174687,'1','122','82309','307','supplier',355500.00,'INVENTRY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 800 TO 815 (DIPPING 23,700)',0.00,'2022-09-30'),(174688,'1','122','82309','3853','5',0.00,'INVENTRY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 800 TO 815 (DIPPING 23,700)',355500.00,'2022-09-30'),(174691,'1','122','82310','307','supplier',234000.00,'INVENTRY VALUE ADJUSTMEN T OF AGO INCREAMENT FROM 815 TO 830 (DIPPING 15,600) @15',0.00,'2022-10-14'),(174692,'1','122','82310','3853','5',0.00,'INVENTRY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 815 TO 830 (DIPPING 15,600) @15',234000.00,'2022-10-14'),(174693,'1','122','82311','307','supplier',116250.00,'INVENTRY ADJUSTMENT OF PMS INCREAMENT FROM 175 TO 180 [23,250] 5NAIRA ',0.00,'2022-11-06'),(174694,'1','122','82311','3853','5',0.00,'INVENTRY ADJUSTMENT OF PMS INCREAMENT FROM 175 TO 180 [23,250] 5NAIRA ',116250.00,'2022-11-06'),(174695,'1','122','82312','307','supplier',0.00,'INVENTRY ADJUSTMENT OF PMS INCREAMENT FROM 180 TO 175 [23,250] 5NAIRA ',116250.00,'2022-11-07'),(174696,'1','122','82312','3853','5',116250.00,'INVENTRY ADJUSTMENT OF PMS INCREAMENT FROM 180 TO 175 [23,250] 5NAIRA ',0.00,'2022-11-07'),(174697,'1','122','82313','307','supplier',116250.00,'INVENTRY ADJUSTMENT OF PMS INCREAMENT FROM 175 TO 180 [23,250] 5NAIRA ',0.00,'2022-11-07'),(174698,'1','122','82313','3853','5',0.00,'INVENTRY ADJUSTMENT OF PMS INCREAMENT FROM 175 TO 180 [23,250] 5NAIRA ',116250.00,'2022-11-07'),(174699,'1','122','82314','307','supplier',116250.00,'INVENTRY ADJUSTMENT OF PMS INCREAMENT FROM 175 TO 180 [23,250] 5NAIRA ',0.00,'2022-11-10'),(174700,'1','122','82314','3853','5',0.00,'INVENTRY ADJUSTMENT OF PMS INCREAMENT FROM 175 TO 180 [23,250] 5NAIRA ',116250.00,'2022-11-10'),(174704,'1','122','82315','307','supplier',102000.00,'INVENTRY ADJUSTMENT OF PMS INCREAMENT FROM 830 TO 860 [3,400] 30NAIRA ',0.00,'2022-11-11'),(174705,'1','122','82315','3853','5',0.00,'INVENTRY ADJUSTMENT OF PMS INCREAMENT FROM 830 TO 860 [3,400] 30NAIRA ',102000.00,'2022-11-11'),(174707,'1','122','82316','3853','5',0.00,'INVENTRY ADJUSTMENT OF PMS INCREAMENT FROM 860 TO 880 [24,000] 20NAIRA ',480000.00,'2022-11-19'),(174708,'1','122','82316','307','supplier',480000.00,'INVENTRY ADJUSTMENT OF PMS INCREAMENT FROM 860 TO 880 [3,400] 20NAIRA ',0.00,'2022-11-19'),(174709,'1','122','82317','307','supplier',0.00,'INVENTRY ADJUSTMENT OF PMS DICREMENT FROM 880 TO 870 [16,600] 10NAIRA',166000.00,'2023-01-18'),(174710,'1','122','82317','3853','5',166000.00,'INVENTRY ADJUSTMENT OF PMS DICREMENT FROM 880 TO 870 [16,600] 10NAIRA',0.00,'2023-01-18'),(174712,'1','122','82318','3853','5',0.00,'INVENTRY ADJUSTMENT OF AGO INCREMENT FROM 870 TO 880 [16,600] 10NAIR',166000.00,'2023-01-19'),(174713,'1','122','82318','307','supplier',166000.00,'INVENTRY ADJUSTMENT OF AGO INCREMENT FROM 870 TO 880 [16,600] 10NAIR',0.00,'2023-01-19'),(174714,'1','122','82319','307','supplier',0.00,'INVENTRY ADJUSTMENT OF PMS DICREMENT FROM 880 TO 870 [14,600] 10NAIRA ',146000.00,'2023-01-19'),(174715,'1','122','82319','3853','5',146000.00,'INVENTRY ADJUSTMENT OF PMS DICREMENT FROM 880 TO 870 [14,600] 10NAIRA ',0.00,'2023-01-19'),(174716,'1','122','82320','307','supplier',116000.00,'INVENTRY ADJUSTMENT OF AGO DICREMENT FROM 870 TO 880 [16,600] 10NAIRA ',0.00,'2023-01-21'),(174717,'1','122','82320','3853','5',0.00,'INVENTRY ADJUSTMENT OF AGO DICREMENT FROM 870 TO 880 [16,600] 10NAIRA ',116000.00,'2023-01-21'),(174718,'1','122','82321','307','supplier',576000.00,'INVENTRY ADJUSTMENT OF PMS INCREAMENT FROM 185 TO 195 [57,600] 10 NAIRA ',0.00,'2023-01-21'),(174719,'1','122','82321','3853','5',0.00,'INVENTRY ADJUSTMENT OF PMS INCREAMENT FROM 185 TO 195 [57,600] 10 NAIRA ',576000.00,'2023-01-21'),(174721,'1','122','82322','307','supplier',0.00,'INVENTRY ADJUSTMENT OF PMS DICREMENT FROM 880 TO 870 [16,600] 10NAIRA',146000.00,'2023-01-21'),(174722,'1','122','82322','3853','5',146000.00,'INVENTRY ADJUSTMENT OF PMS DICREMENT FROM 880 TO 870 [14,600] 10NAIRA',0.00,'2023-01-21'),(174723,'1','122','82323','307','supplier',0.00,'NVENTRY ADJUSTMENT OF AGO DICREMENT FROM 870 TO 850 [10,00] @ 20NAIRA ',2180000.00,'2023-02-03'),(174724,'1','122','82323','3853','5',2180000.00,'NVENTRY ADJUSTMENT OF AGO DICREMENT FROM 870 TO 850 [10,00] @ 20NAIRA ',0.00,'2023-02-03'),(174725,'1','122','82324','307','supplier',0.00,'INVENTRY ADJUSTMENT OF AGO INCREMENT FROM 850 TO 830 [29.900] 20NAIR',598000.00,'2023-03-03'),(174726,'1','122','82324','3853','5',598000.00,'INVENTRY ADJUSTMENT OF AGO DICREMENT FROM 850 TO 830 [29,900] 20NAIRA',0.00,'2023-03-03'),(174727,'1','122','82325','307','supplier',0.00,'INVENTRY ADJUSTMENT OF AGO DICREMENT FROM 830 TO 820 [20,700] 10NAIRA',207000.00,'2023-03-15'),(174728,'1','122','82325','3853','5',207000.00,'INVENTRY ADJUSTMENT OF AGO DICREMENT FROM 830 TO 820 [20,700] 10NAIRA',0.00,'2023-03-15'),(174729,'1','122','82326','3853','5',207000.00,'INVENTRY ADJUSTMENT OF AGO DICREMENT FROM 820 TO 820 [20,700] 10NAIR',0.00,'2023-03-20'),(174730,'1','122','82326','307','supplier',0.00,'INVENTRY ADJUSTMENT OF AGO DICREMENT FROM 820 TO 820 [20,700] 10NAIR',2070000.00,'2023-03-20');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4196 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (3900,'','1','122','BAJAJ BOXER CONFIRM FULL TANK','AA RANO NIG','08035450199','mrmohasul@gmail.com','KANO','Kano','HEAD OFFICE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-29 15:50:10',5,'454','2021-11-29 15:50:10','454'),(4178,'','1','122','Royal  Niger Properties Ltd','07038219126','07034471235','royalnigerproperties@gmail.com','Abuja','Abuja','Mpape ,katampe ii','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-16 15:43:16',5,'454','2022-01-16 15:43:16','454'),(4179,'','1','122','DRIVER SHORTAGE','AA RANO TRANSPORT','08002020202','info@aaranonigeria.com','KANO','KANO','No 7 Maiduguri Road,Opposite NNPC Depot. Kano Nigeria','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-16 11:42:37',5,'454','2022-02-16 11:42:37','454'),(4180,'','1','122','KATLIZ GLOBAL SERVICES LTD','MR. CHIOMA ANICHE','07067954663/09013038951','chiani1977@gmail.com','ABUJA','ABUJA','2 BUBA STREET, ARMY HOUSING ESTATE, KURUDU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-31 15:20:52',5,'454','2022-04-01 12:30:40','454'),(4181,'','1','122','HAJIYA FAUZIYYA RABIU (IRS)','HAJIYA FAUZIYYA','08033949798','rfauziyyah@yahoo.com','ABUJA','ABUJA','NO.8 MAITAMA STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-09 16:18:11',5,'454','2022-04-09 16:18:11','454'),(4182,'','1','122','MASARKI  NIG LTD','YAHAYA SHAMSUDDEN ','08106268407','masarkiniugltd@gmail.com','ABUJA','ABUJA','OFF MASARKI CLOSE PARKING CEMENT WUSE II','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-10 11:05:39',5,'454','2022-05-10 11:05:39','454'),(4183,'','1','122','FUSION SPIC LIMITED','DANIEL NUHU','08067087337','msking009@yahoo.com','ABUJA','ABUJA','AGURU STREET OFF WIKKING SPRING IDANKE STREET NO.5','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-10 11:07:47',5,'454','2022-05-10 11:07:47','454'),(4184,'','1','122','CHINA HARBOR ENGINEERING COMPA','GODWIN TIMOTHY','08063098152','kohen0bg31@gmail.com','ABUJA','ABUJA','PLOT.3140 MURTALA MUHD WAY ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-12 17:15:52',5,'454','2022-05-12 17:15:52','454'),(4185,'','1','122','NIGER REPUBLIC EMBASSY','ALH. JAFARU MUHAMMAD','08135842086','mohammadjaf@gmail.com','ABUJA','ABUJA','PLOT. 305 ZONE A O CENTRAL AREA DISTICT.','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-30 15:47:41',5,'454','2022-05-30 15:47:41','454'),(4186,'','1','122','PRIME STAR STD MODEL SCHOOL ','MR IJEOMA AGWENDI','08160000521','primestarstdmodelschool@gmail.','ABUJA','ABUJA','plot 1091 katampe , mpape','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-17 17:21:15',5,'454','2022-06-17 17:21:15','454'),(4187,'','1','122','FIDELITY BANK','EMMANUEL IDOKO','08117259528','emmanuelidoko@fidelitybank.com','Abuja','Abuja','Abuja','Nigeria',3000000.00,0.00,0.00,'0000-00-00','2022-07-01 12:20:25',5,'454','2022-07-07 14:56:44','454'),(4188,'','1','122','KOL. CAJ OHOW RESAHINO MANI..','09136001097','09035335329','ohowmiagafi@gmail.com','ABUJA','ABUJA','12,mekong cresent maitama-Abuja ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-06 09:30:36',5,'454','2022-07-06 09:30:36','454'),(4189,'','1','122','THE TRAVEL PLACE LIMITED','JULIET NDOWA','09083764056','hradmin@travelplaceng.com','ABUJA','ABUJA','SUSUMA CLOSE MAITAMA , ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-04 12:53:34',5,'454','2022-08-04 12:53:34','454'),(4190,'','1','122','DELICIOUS HOME MEALS & DRINKS','MR WESLEY','08036449141','delicioushomemealdrink@gmail.c','ABUJA','ABUJA','Abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-19 16:27:55',5,'454','2022-08-19 16:27:55','454'),(4191,'','1','122','Golden city enterprices','TIMOTHY BELLO','08066490222','goldencityenterprise2019@gmail','ABUJA','ABUJA','lungi barrack','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-19 16:31:33',5,'454','2022-08-24 15:56:24','454'),(4192,'','1','122','H-MEDIX PHARMACY LTD','EISIE MATTEW','080345363001','infomedixopharmacy@yahoo.com','Abuja','Abuja','No 179 Aminu kano wuse 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-24 16:01:02',5,'454','2022-08-24 16:01:02','454'),(4193,'','1','122','KADUNA STATE GOVERNMENT','USMAN SURAJO','08035947868','shuaibum160@gmail.com','ABUJA','ABUJA','GOVERMENT HOUSE KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-07 18:24:23',5,'454','2023-02-09 12:21:06','454'),(4194,'','1','122','EMBASSY OF REPUBLIC OF MALI','FINIACIAL','09065645679','ambassadennaliaabuja@yahoo.com','ABUJA','ABUJA','PLOT.3257 IBB WAY MAITAMA ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-10 10:35:01',5,'454','2023-02-10 10:35:01','454'),(4195,'','1','122','NYSC STAFF WELFARE BUS COMMITE','MOHAMMED AYSHA T','08034374835','aishat08@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-10 12:14:24',5,'454','2023-03-10 12:14:24','454');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18587 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','122',17075,'1004',12266.75,38900.00,'2021-10-28','','2021-10-28 13:08:35','454','454',2021,'454','2021-10-28 13:08:35',5),('1','122',17076,'1004',38900.00,98900.00,'2021-10-28','','2021-10-28 13:15:50','454','454',2021,'454','2021-10-28 13:15:50',5),('1','122',17077,'1005',106210.45,42000.00,'2021-10-28','','2021-10-28 13:16:15','454','454',2021,'454','2021-10-28 13:16:15',5),('1','122',17078,'1006',46743.72,19600.00,'2021-10-28','','2021-10-28 13:16:33','454','454',2021,'454','2021-10-28 13:16:33',5),('1','122',17079,'1007',23228.30,23800.00,'2021-10-28','','2021-10-28 13:17:00','454','454',2021,'454','2021-10-28 13:17:00',5),('1','122',17394,'1006',1950.77,5900.00,'2021-11-01','','2021-11-01 10:21:34','454','454',2021,'454','2021-11-01 10:21:34',5),('1','122',17437,'1006',481.89,2100.00,'2021-11-02','','2021-11-02 16:03:19','454','454',2021,'454','2021-11-02 16:03:19',5),('1','122',17438,'1006',2100.00,5300.00,'2021-11-02','','2021-11-02 16:36:27','454','454',2021,'454','2021-11-02 16:36:27',5),('1','122',17448,'1006',90.49,5791.00,'2021-10-30','','2021-11-03 11:03:43','454','454',2021,'454','2021-11-03 11:03:43',5),('1','122',17449,'1006',5791.00,14700.00,'2021-11-03','','2021-11-03 11:16:02','454','454',2021,'454','2021-11-03 11:16:02',5),('1','122',17450,'1005',22842.16,1.00,'2021-11-03','','2021-11-03 11:18:14','454','454',2021,'454','2021-11-03 11:18:14',5),('1','122',17453,'1006',935.14,29400.00,'2021-11-03','','2021-11-03 12:55:07','454','454',2021,'454','2021-11-03 12:55:07',5),('1','122',17455,'1006',1407.34,14231.00,'2021-11-03','','2021-11-03 14:08:33','454','454',2021,'454','2021-11-03 14:08:33',5),('1','122',17456,'1006',14231.00,51100.00,'2021-11-02','','2021-11-03 14:41:57','454','454',2021,'454','2021-11-03 14:41:57',5),('1','122',18165,'1004',71865.33,34100.00,'2021-12-23','','2021-12-23 13:30:02','533','533',2021,'533','2021-12-23 13:30:02',5),('1','122',18166,'1006',72261.46,24300.00,'2021-12-23','','2021-12-23 13:30:51','533','533',2021,'533','2021-12-23 13:30:51',5),('1','122',18167,'1007',19648.31,20300.00,'2021-12-23','','2021-12-23 13:32:08','533','533',2021,'533','2021-12-23 13:32:08',5),('1','122',18508,'1004',2684.11,24640.00,'2022-01-20','','2022-01-20 12:47:10','454','454',2022,'454','2022-01-20 12:47:10',5),('1','122',18569,'1006',34830.41,40600.00,'2022-01-27','','2022-01-27 11:35:08','454','454',2022,'454','2022-01-27 11:35:08',5),('1','122',18571,'1006',40600.00,40700.00,'2022-01-27','','2022-01-27 12:40:50','454','454',2022,'454','2022-01-27 12:40:50',5),('1','122',18572,'1006',53031.65,29000.00,'2022-02-08','DIPPING ADJUSTIMENT','2022-02-08 14:09:14','533','533',2022,'533','2022-02-08 14:09:14',5),('1','122',18573,'1004',27288.47,31000.00,'2022-02-23','','2022-02-23 10:24:25','454','454',2022,'454','2022-02-23 10:24:25',5),('1','122',18574,'1004',7415.99,17200.00,'2022-02-28','','2022-02-28 11:50:24','454','454',2022,'454','2022-02-28 11:50:24',5),('1','122',18575,'1004',22358.03,38400.00,'2022-03-04','','2022-03-04 17:09:05','454','454',2022,'454','2022-03-04 17:09:05',5),('1','122',18576,'1004',10733.80,38900.00,'2022-03-08','TO ENABLE THE STATION THEIR SHIFT','2022-03-08 13:06:19','533','533',2022,'533','2022-03-08 13:06:19',5),('1','122',18577,'1007',850.69,5191.00,'2022-03-08','','2022-03-08 20:01:14','454','454',2022,'454','2022-03-08 20:01:14',5),('1','122',18578,'1007',5191.00,6400.00,'2022-03-09','','2022-03-09 13:02:48','454','454',2022,'454','2022-03-09 13:02:48',5),('1','122',18579,'1004',70546.98,29000.00,'2022-06-07','','2022-06-07 13:48:35','454','454',2022,'454','2022-06-07 13:48:35',5),('1','122',18580,'1006',2623.03,3200.00,'2022-06-07','','2022-06-07 13:49:02','454','454',2022,'454','2022-06-07 13:49:02',5),('1','122',18581,'1007',14458.34,13700.00,'2022-06-07','','2022-06-07 13:49:18','454','454',2022,'454','2022-06-07 13:49:18',5),('1','122',18582,'1004',362627.94,12600.00,'2022-09-08','','2022-09-08 14:59:23','454','454',2022,'454','2022-09-08 14:59:23',5),('1','122',18583,'1007',1098.14,4900.00,'2022-10-06','','2022-10-06 08:00:39','454','454',2022,'454','2022-10-06 08:00:39',5),('1','122',18584,'1007',910.40,3400.00,'2022-11-11','','2022-11-11 15:37:05','454','454',2022,'454','2022-11-11 15:37:05',5),('1','122',18585,'1007',1633.54,1684.00,'2023-02-05','','2023-02-05 13:03:26','533','533',2023,'533','2023-02-05 13:03:26',5),('1','122',18586,'1007',2569.04,3100.00,'2023-02-11','','2023-02-11 10:27:10','533','533',2023,'533','2023-02-11 10:27:10',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2989 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','122','1004',2961,'5','PUMP 1',951157.07,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 12:53:14','178'),('1','122','1004',2962,'5','PUMP 2',1851479.76,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 12:53:30','178'),('1','122','1004',2963,'5','PUMP 5',500698.83,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 12:54:49','178'),('1','122','1004',2964,'5','PUMP 6',951189.90,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 12:55:06','178'),('1','122','1004',2965,'5','PUMP 9',1149492.32,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 12:56:13','178'),('1','122','1004',2966,'5','PUMP 10',1472834.01,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 12:56:36','178'),('1','122','1004',2967,'5','PUMP 13',753299.68,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 12:57:57','178'),('1','122','1004',2968,'5','PUMP 14',1468276.25,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 12:58:20','178'),('1','122','1004',2969,'5','PUMP 17',576390.09,'DISPENSING PMS','',NULL,NULL,'',5,'2021-11-13 12:29:57','454'),('1','122','1004',2970,'5','PUMP 18',2018588.24,'DISPENSING PMS','',NULL,NULL,'',5,'2021-11-13 12:30:26','454'),('1','122','1004',2971,'5','PUMP 21',784412.02,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 13:00:34','178'),('1','122','1004',2972,'5','PUMP 22',1293262.24,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 13:00:58','178'),('1','122','1006',2973,'5','PUMP 11',771048.84,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 12:57:05','178'),('1','122','1006',2974,'5','PUMP 12',563486.74,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 12:57:27','178'),('1','122','1006',2975,'5','PUMP 15',412279.93,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 12:58:42','178'),('1','122','1006',2976,'5','PUMP 16',742955.92,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 12:59:02','178'),('1','122','1006',2977,'5','PUMP 3',687136.18,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 12:53:52','178'),('1','122','1006',2978,'5','PUMP 4',1111313.28,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 12:54:21','178'),('1','122','1006',2979,'5','PUMP 7',401397.71,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 12:55:29','178'),('1','122','1006',2980,'5','PUMP 8',648365.95,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 12:55:49','178'),('1','122','1006',2981,'5','PUMP 19',902927.34,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 12:59:32','178'),('1','122','1006',2982,'5','PUMP 20',561385.43,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 13:00:08','178'),('1','122','1006',2983,'5','PUMP 23',78950.66,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 13:01:25','178'),('1','122','1006',2984,'5','PUMP 24',1007570.74,'DISPENSING PMS','',NULL,NULL,'',5,'2021-10-13 13:01:45','178'),('1','122','1007',2985,'5','AGO PUMP 1',992420.23,'DISPENSING AGO','',NULL,NULL,'',5,'2021-10-13 13:02:08','178'),('1','122','1007',2986,'5','AGO PUMP 2',347135.50,'DISPENSING AGO','',NULL,NULL,'',5,'2021-10-27 20:26:56','454'),('1','122','1007',2987,'5','AGO PUMP 3',0.00,'DISPENSING AGO',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','122','1007',2988,'5','AGO PUMP 4',0.00,'DISPENSING AGO',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=337 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (333,'1','122','2973','1006','TANK MANIFOLDING','2021-11-03 11:16:45',0,'454'),(334,'1','122','2974','1006','TANK MANIFOLDING','2021-11-03 11:17:02',0,'454'),(335,'1','122','2975','1006','TANK MANIFOLDING','2021-11-03 11:17:14',0,'454'),(336,'1','122','2976','1006','TANK MANIFOLDING','2021-11-03 11:17:26',0,'454');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258310 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','122',231523,'MORNING & AFTERNOON','2021-09-30','2021-09-30 00:00:00',NULL,'697',1504547.20,1504547.20,'697','2021-10-14 13:49:45','533','2021-10-14 13:59:54',10,0),('1','122',231538,'MORNING & AFTERNOON','2021-10-01','2021-10-01 00:00:00',NULL,'697',1764760.00,1764760.00,'697','2021-10-14 14:25:28','533','2021-10-14 14:28:29',10,0),('1','122',231553,'MORNING & AFTERNOON','2021-10-02','2021-10-02 00:00:00',NULL,'697',1835262.97,1861161.97,'697','2021-10-14 15:21:35','533','2021-10-14 15:26:13',10,0),('1','122',231573,'MORNING & AFTERNOON','2021-10-03','2021-10-03 00:00:00',NULL,'697',1797511.37,1797511.37,'697','2021-10-14 16:23:24','533','2021-10-14 16:26:11',10,0),('1','122',231582,'MORNING & AFTERNOON','2021-10-04','2021-10-04 00:00:00',NULL,'697',2661545.57,2661545.57,'697','2021-10-14 16:35:16','533','2021-10-14 16:41:04',10,0),('1','122',231590,'MORNING & AFTERNOON','2021-10-05','2021-10-05 00:00:00',NULL,'697',4876467.28,4876467.28,'697','2021-10-14 16:49:22','533','2021-10-14 16:50:27',10,0),('1','122',231592,'MORNING & AFTERNOON','2021-10-06','2021-10-06 00:00:00',NULL,'697',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','122',231594,'MORNING & AFTERNOON','2021-10-06','2021-10-06 00:00:00',NULL,'697',3125564.84,3125564.84,'697','2021-10-14 17:00:47','533','2021-10-14 17:02:45',10,0),('1','122',231596,'MORNING & AFTERNOON','2021-10-07','2021-10-07 00:00:00',NULL,'697',3503219.92,3507274.00,'697','2021-10-14 17:18:33','533','2021-10-14 17:23:42',10,0),('1','122',231599,'MORNING & AFTERNOON','2021-10-08','2021-10-08 00:00:00',NULL,'697',4008469.53,4020209.25,'697','2021-10-15 11:22:16','533','2021-10-15 11:23:56',10,0),('1','122',231753,'MORNING & AFTERNOON','2021-10-09','2021-10-09 00:00:00',NULL,'697',3092371.11,3095392.35,'697','2021-10-15 11:29:43','533','2021-10-15 11:30:05',10,0),('1','122',231756,'MORNING & AFTERNOON','2021-10-10','2021-10-10 00:00:00',NULL,'697',3550322.71,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','122',231762,'MORNING & AFTERNOON','2021-10-10','2021-10-10 00:00:00',NULL,'697',3550322.71,3552420.85,'697','2021-10-15 11:42:33','533','2021-10-15 11:44:03',10,0),('1','122',231766,'MORNING & AFTERNOON','2021-10-11','2021-10-11 00:00:00',NULL,'697',3113340.18,3117521.50,'697','2021-10-15 12:01:48','533','2021-10-15 12:06:14',10,0),('1','122',231772,'MORNING & AFTERNOON','2021-10-12','2021-10-12 00:00:00',NULL,'697',4498404.50,4498404.50,'697','2021-10-15 12:15:45','533','2021-10-15 12:16:32',10,0),('1','122',231773,'MORNING & AFTERNOON','2021-10-13','2021-10-13 00:00:00',NULL,'697',3547751.17,3547751.17,'697','2021-10-15 12:32:11','533','2021-10-15 12:33:08',10,0),('1','122',231775,'MORNING & AFTERNOON','2021-10-14','2021-10-14 00:00:00',NULL,'697',3590089.03,3590089.03,'697','2021-10-15 12:39:14','533','2021-10-15 12:39:48',10,0),('1','122',232976,'MORNING & AFTERNOON','2021-10-15','2021-10-15 00:00:00',NULL,'697',4191073.46,4191073.46,'697','2021-10-22 19:03:26','533','2021-10-22 19:06:35',10,0),('1','122',233566,'MORNING & AFTERNOON','2021-10-16','2021-10-16 00:00:00',NULL,'697',3028482.84,3004587.41,'697','2021-10-23 14:49:20','533','2021-10-23 14:55:06',10,0),('1','122',233771,'MORNING & AFTERNOON','2021-10-17','2021-10-17 00:00:00',NULL,'697',2072029.92,2059318.08,'697','2021-10-23 16:32:48','533','2021-10-23 16:42:19',10,0),('1','122',233783,'MORNING & AFTERNOON','2021-10-18','2021-10-18 00:00:00',NULL,'697',1424178.27,1415440.98,'697','2021-10-25 10:35:33','533','2021-10-25 10:38:31',10,0),('1','122',234157,'MORNING& AFTERNOON ','2021-10-19','2021-10-19 00:00:00',NULL,'697',2592119.71,2571162.79,'697','2021-10-25 11:01:40','533','2021-10-25 11:03:39',10,0),('1','122',234172,'MORNING& AFTERNOON','2021-10-20','2021-10-20 00:00:00',NULL,'697',3540902.10,3503883.65,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','122',234418,'MORNING& AFTERNOON','2021-10-20','2021-10-20 00:00:00',NULL,'697',3530862.75,3530862.75,'697','2021-10-26 11:09:15','533','2021-10-26 11:24:21',10,0),('1','122',234431,'MORNING& AFTERNOON','2021-10-21','2021-10-21 00:00:00',NULL,'697',3897095.09,3897095.09,'697','2021-10-27 12:21:43','533','2021-10-27 12:22:45',10,0),('1','122',234714,'MORNING& AFTERNOON','2021-10-22','2021-10-22 00:00:00',NULL,'697',6130112.32,6130112.32,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','122',234729,'MORNING& AFTERNOON','2021-10-22','2021-10-22 00:00:00',NULL,'697',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','122',234753,'MORNING& AFTERNOON','2021-10-22','2021-10-22 00:00:00',NULL,'697',6182209.12,6182209.12,'697','2021-10-27 16:18:53','454','2021-10-27 16:24:17',10,0),('1','122',234759,'MORNING& AFTERNOON','2021-10-23','2021-10-23 00:00:00',NULL,'697',3427660.28,3427660.28,'697','2021-10-27 16:45:13','454','2021-10-27 16:46:53',10,0),('1','122',234760,'MORNING& AFTERNOON','2021-10-24','2021-10-24 00:00:00',NULL,'697',2368203.97,2368203.97,'697','2021-10-27 17:37:38','533','2021-10-27 17:43:12',10,0),('1','122',234771,'MORNING& AFTERNOON','2021-10-25','2021-10-25 00:00:00',NULL,'697',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','122',234789,'MORNING& AFTERNOON','2021-10-25','2021-10-25 00:00:00',NULL,'697',4069005.52,4069005.52,'697','2021-10-27 21:01:28','533','2021-10-27 21:06:46',10,0),('1','122',234791,'MORNING& AFTERNOON','2021-10-26','2021-10-26 00:00:00',NULL,'697',4199866.87,4199866.87,'697','2021-10-28 14:19:31','533','2021-10-28 14:24:27',10,0),('1','122',234978,'MORNING& AFTERNOON','2021-10-27','2021-10-27 00:00:00',NULL,'697',6399316.73,6399316.73,'697','2021-10-28 14:42:55','533','2021-10-28 14:45:29',10,0),('1','122',235017,'MORNING& AFTERNOON','2021-10-28','2021-10-28 00:00:00',NULL,'697',4457406.91,4457406.91,'697','2021-11-01 10:29:41','533','2021-11-01 10:32:46',10,0),('1','122',235865,'MORNING& AFTERNOON','2021-10-29','2021-10-29 00:00:00',NULL,'697',5622227.62,5622227.62,'697','2021-11-02 16:36:43','454','2021-11-02 16:38:29',10,0),('1','122',236350,'MORNING & AFTERNOON','2021-10-30','2021-10-30 00:00:00',NULL,'697',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','122',236364,'MORNING & AFTERNOON','2021-10-30','2021-10-30 00:00:00',NULL,'697',5300917.42,5300917.42,'697','2021-11-03 11:42:19','454','2021-11-03 11:43:29',10,0),('1','122',236370,'MORNING & AFTERNOON','2021-10-31','2021-10-31 00:00:00',NULL,'697',3233587.85,3233587.85,'697','2021-11-03 12:00:35','454','2021-11-03 12:11:04',10,0),('1','122',236384,'MORNING & AFTERNOON','2021-11-01','2021-11-01 00:00:00',NULL,'697',7246270.11,7246270.11,'697','2021-11-03 12:56:45','454','2021-11-03 13:13:45',10,0),('1','122',236395,'MORNING & AFTERNOON','2021-11-02','2021-11-02 00:00:00',NULL,'697',7128738.72,7128738.72,'697','2021-11-03 14:42:00','454','2021-11-03 14:43:14',10,0),('1','122',236419,'MORNING & AFTERNOON','2021-11-03','2021-11-03 00:00:00',NULL,'697',4622075.47,4622075.47,'697','2021-11-04 14:45:38','454','2021-11-04 16:14:23',10,0),('1','122',236682,'MORNING & AFTERNOON','2021-11-03','2021-11-03 00:00:00',NULL,'697',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','122',236685,'MORNING & AFTERNOON','2021-11-04','2021-11-04 00:00:00',NULL,'697',4573195.50,4573195.50,'697','2021-11-05 07:56:58','454','2021-11-05 08:54:43',10,0),('1','122',236994,'MORNING & AFTERNOON','2021-11-05','2021-11-05 00:00:00',NULL,'697',6324961.05,6324961.05,'697','2021-11-06 07:45:44','533','2021-11-06 11:23:32',10,0),('1','122',237211,'MORNING & AFTERNOON','2021-11-06','2021-11-06 00:00:00',NULL,'697',2742664.65,2742664.65,'697','2021-11-07 07:51:06','533','2021-11-07 12:55:46',10,0),('1','122',237311,'MORNING & AFTERNOON','2021-11-07','2021-11-07 00:00:00',NULL,'697',6377461.50,6377461.50,'697','2021-11-08 07:58:28','533','2021-11-08 15:41:01',10,0),('1','122',237657,'MORNING & AFTERNOON','2021-11-08','2021-11-08 00:00:00',NULL,'697',7369193.40,7369193.40,'697','2021-11-09 09:08:49','533','2021-11-09 09:37:11',10,0),('1','122',237917,'MORNING & AFTERNOON','2021-11-09','2021-11-09 00:00:00',NULL,'697',4693375.05,4693375.05,'697','2021-11-10 08:12:34','533','2021-11-10 12:13:00',10,0),('1','122',238072,'MORNING & AFTERNOON','2021-11-10','2021-11-10 00:00:00',NULL,'697',6499543.05,6499543.05,'697','2021-11-11 07:37:39','533','2021-11-11 09:52:45',10,0),('1','122',238411,'MORNING & AFTERNOON','2021-11-11','2021-11-11 00:00:00',NULL,'697',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','122',238722,'MORNING & AFTERNOON','2021-11-11','2021-11-11 00:00:00',NULL,'697',1866447.00,1866447.00,'697','2021-11-13 13:05:23','533','2021-11-13 13:17:02',10,0),('1','122',238737,'MORNING & AFTERNOON','2021-11-12','2021-11-12 00:00:00',NULL,'697',9485167.20,9485167.20,'697','2021-11-13 13:31:59','454','2021-11-13 13:35:21',10,0),('1','122',238941,'MORNING & AFTERNOON','2021-11-13','2021-11-13 00:00:00',NULL,'697',5478752.25,5478752.25,'697','2021-11-14 13:02:57','533','2021-11-14 13:06:05',10,0),('1','122',239123,'MORNING & AFTERNOON','2021-11-14','2021-11-14 00:00:00',NULL,'697',4556541.75,4556541.75,'697','2021-11-15 08:25:49','533','2021-11-15 08:34:08',10,0),('1','122',239338,'MORNING & AFTERNOON','2021-11-15','2021-11-15 00:00:00',NULL,'697',2532759.00,2532759.00,'697','2021-11-16 08:17:09','533','2021-11-16 08:52:25',10,0),('1','122',239571,'MORNING & AFTERNOON','2021-11-16','2021-11-16 00:00:00',NULL,'697',7183059.90,7183059.90,'697','2021-11-17 07:55:20','533','2021-11-17 07:56:01',10,0),('1','122',239820,'MORNING & AFTERNOON','2021-11-17','2021-11-17 00:00:00',NULL,'697',3518027.70,3518027.70,'697','2021-11-18 07:52:36','533','2021-11-18 10:54:55',10,0),('1','122',240042,'MORNING & AFTERNOON','2021-11-18','2021-11-18 00:00:00',NULL,'697',6741409.35,6741409.35,'697','2021-11-19 08:07:30','533','2021-11-19 10:15:08',10,0),('1','122',240259,'MORNING & AFTERNOON','2021-11-19','2021-11-19 00:00:00',NULL,'697',4426697.55,4426697.55,'697','2021-11-20 09:27:56','533','2021-11-20 09:29:00',10,0),('1','122',240522,'MORNING & AFTERNOON','2021-11-20','2021-11-20 00:00:00',NULL,'697',1145790.90,1145790.90,'697','2021-11-21 10:37:04','533','2021-11-21 11:06:27',10,0),('1','122',240748,'MORNING & AFTERNOON','2021-11-21','2021-11-21 00:00:00',NULL,'697',4042383.45,4042383.45,'697','2021-11-22 07:59:30','533','2021-11-22 10:20:15',10,0),('1','122',240786,'MORNING & AFTERNOON','2021-11-22','2021-11-22 00:00:00',NULL,'697',5704624.80,5704624.80,'697','2021-11-23 08:15:39','533','2021-11-23 08:46:46',10,0),('1','122',241293,'MORNING & AFTERNOON','2021-11-23','2021-11-23 00:00:00',NULL,'697',7061817.45,7061817.45,'697','2021-11-24 08:22:03','533','2021-11-24 10:24:01',10,0),('1','122',241429,'MORNING & AFTERNOON','2021-11-24','2021-11-24 00:00:00',NULL,'697',3959026.50,3959026.50,'697','2021-11-25 08:34:16','533','2021-11-25 09:46:03',10,0),('1','122',241694,'MORNING & AFTERNOON','2021-11-25','2021-11-25 00:00:00',NULL,'697',5814207.30,5814207.30,'697','2021-11-26 08:39:39','533','2021-11-26 14:11:42',10,0),('1','122',241929,'MORNING & AFTERNOON','2021-11-26','2021-11-26 00:00:00',NULL,'697',5239462.80,5239462.80,'697','2021-11-27 09:05:48','533','2021-11-27 10:32:15',10,0),('1','122',242297,'MORNING & AFTERNOON','2021-11-27','2021-11-27 00:00:00',NULL,'697',4281910.05,4281910.05,'697','2021-11-28 12:02:23','533','2021-11-29 07:24:45',10,0),('1','122',242506,'MORNING & AFTERNOON','2021-11-28','2021-11-28 00:00:00',NULL,'697',3007936.80,3007936.80,'697','2021-11-29 08:10:15','533','2021-11-29 08:47:18',10,0),('1','122',242742,'MORNING & AFTERNOON','2021-11-29','2021-11-29 00:00:00',NULL,'697',6020597.55,6020597.55,'697','2021-11-30 08:34:43','533','2021-11-30 09:44:15',10,0),('1','122',242991,'MORNING & AFTERNOON','2021-11-30','2021-11-30 00:00:00',NULL,'697',4936969.95,4936969.95,'697','2021-12-01 08:48:01','533','2021-12-01 11:15:43',10,0),('1','122',243201,'MORNING & AFTERNOON','2021-12-01','2021-12-01 00:00:00',NULL,'697',2988110.85,2988110.85,'697','2021-12-02 08:35:54','533','2021-12-02 13:26:33',10,0),('1','122',243313,'MORNING & AFTERNOON','2021-12-02','2021-12-02 00:00:00',NULL,'697',4412061.15,4412061.15,'697','2021-12-03 10:07:49','533','2021-12-03 13:47:20',10,0),('1','122',243677,'MORNING & AFTERNOON','2021-12-03','2021-12-03 00:00:00',NULL,'697',7358218.80,7358218.80,'697','2021-12-04 09:44:21','533','2021-12-04 11:59:33',10,0),('1','122',243907,'MORNING & AFTERNOON','2021-12-04','2021-12-04 00:00:00',NULL,'697',4696708.20,4696708.20,'697','2021-12-05 10:22:25','533','2021-12-05 12:14:44',10,0),('1','122',244123,'MORNING & AFTERNOON','2021-12-05','2021-12-05 00:00:00',NULL,'697',3746150.55,3746150.55,'697','2021-12-06 08:34:28','533','2021-12-06 09:35:58',10,0),('1','122',244354,'MORNING & AFTERNOON','2021-12-06','2021-12-06 00:00:00',NULL,'697',5100473.70,5100473.70,'697','2021-12-07 08:28:34','533','2021-12-07 08:34:06',10,0),('1','122',244387,'MORNING & AFTERNOON','2021-12-07','2021-12-07 00:00:00',NULL,'697',2850064.35,2850064.35,'697','2021-12-08 08:38:32','533','2021-12-08 08:41:31',10,0),('1','122',244792,'MORNING & AFTERNOON','2021-12-08','2021-12-08 00:00:00',NULL,'697',5461907.10,5461907.10,'697','2021-12-09 07:55:39','533','2021-12-09 09:41:15',10,0),('1','122',244878,'MORNING & AFTERNOON','2021-12-09','2021-12-09 00:00:00',NULL,'697',8740613.70,8740613.70,'697','2021-12-10 08:38:42','533','2021-12-10 10:14:07',10,0),('1','122',245069,'MORNING & AFTERNOON','2021-12-10','2021-12-10 00:00:00',NULL,'697',8604146.10,8604146.10,'697','2021-12-11 08:53:12','533','2021-12-11 08:56:57',10,0),('1','122',245391,'MORNING & AFTERNOON','2021-12-11','2021-12-11 00:00:00',NULL,'697',5173019.70,5173019.70,'697','2021-12-12 11:57:44','533','2021-12-12 13:59:44',10,0),('1','122',245602,'MORNING & AFTERNOON','2021-12-12','2021-12-12 00:00:00',NULL,'697',4238258.10,4238258.10,'697','2021-12-13 08:48:34','533','2021-12-13 08:50:44',10,0),('1','122',245798,'MORNING & AFTERNOON','2021-12-13','2021-12-13 00:00:00',NULL,'697',6955966.50,6955966.50,'697','2021-12-14 08:42:32','533','2021-12-14 08:54:37',10,0),('1','122',246255,'MORNING & AFTERNOON','2021-12-14','2021-12-14 00:00:00',NULL,'697',7155631.35,7155631.35,'697','2021-12-15 08:52:12','533','2021-12-15 09:06:02',10,0),('1','122',246537,'MORNING & AFTERNOON','2021-12-15','2021-12-15 00:00:00',NULL,'697',9277179.75,9277179.75,'697','2021-12-16 10:10:28','533','2021-12-16 16:08:50',10,0),('1','122',246663,'MORNING & AFTERNOON','2021-12-16','2021-12-16 00:00:00',NULL,'697',6685172.85,6685172.85,'697','2021-12-17 09:41:48','533','2021-12-17 15:34:06',10,0),('1','122',246869,'MORNING & AFTERNOON','2021-12-17','2021-12-17 00:00:00',NULL,'697',6924678.90,6924678.90,'697','2021-12-18 09:45:56','533','2021-12-18 10:19:31',10,0),('1','122',247261,'MORNING & AFTERNOON','2021-12-18','2021-12-18 00:00:00',NULL,'697',9059245.65,9059245.65,'697','2021-12-19 11:51:07','533','2021-12-19 15:55:36',10,0),('1','122',247468,'MORNING & AFTERNOON','2021-12-19','2021-12-19 00:00:00',NULL,'697',5185996.20,5185996.20,'697','2021-12-20 08:59:28','533','2021-12-20 12:39:05',10,0),('1','122',247717,'MORNING & AFTERNOON','2021-12-20','2021-12-20 00:00:00',NULL,'697',5345996.25,5345996.25,'697','2021-12-21 09:04:07','533','2021-12-21 09:21:41',10,0),('1','122',247867,'MORNING & AFTERNOON','2021-12-21','2021-12-21 00:00:00',NULL,'697',7800258.60,7800258.60,'697','2021-12-22 09:25:23','533','2021-12-22 09:30:09',10,0),('1','122',248084,'MORNING & AFTERNOON','2021-12-22','2021-12-22 00:00:00',NULL,'697',8069650.95,8069650.95,'697','2021-12-23 08:52:38','533','2021-12-23 09:55:04',10,0),('1','122',248480,'MORNING & AFTERNOON','2021-12-23','2021-12-23 00:00:00',NULL,'697',5552981.25,5552981.25,'697','2021-12-24 09:19:07','533','2021-12-24 09:45:05',10,0),('1','122',248695,'MORNING & AFTERNOON','2021-12-24','2021-12-24 00:00:00',NULL,'697',3809579.25,3809579.25,'697','2021-12-25 08:48:11','533','2021-12-25 09:11:55',10,0),('1','122',248961,'MORNING & AFTERNOON','2021-12-25','2021-12-25 00:00:00',NULL,'697',2207428.50,2207428.50,'697','2021-12-26 11:33:05','533','2021-12-27 10:02:14',10,0),('1','122',249204,'MORNING & AFTERNOON','2021-12-26','2021-12-26 00:00:00',NULL,'697',2860476.45,2860476.45,'697','2021-12-27 10:10:08','454','2021-12-27 10:30:01',10,0),('1','122',249445,'MORNING & AFTERNOON','2021-12-27','2021-12-27 00:00:00',NULL,'697',2926707.90,2926707.90,'697','2021-12-28 11:15:13','533','2021-12-28 12:00:09',10,0),('1','122',249699,'MORNING & AFTERNOON','2021-12-28','2021-12-28 00:00:00',NULL,'697',3595158.60,3595158.60,'697','2021-12-29 17:53:46','533','2021-12-30 10:19:50',10,0),('1','122',249944,'MORNING & AFTERNOON','2021-12-29','2021-12-29 00:00:00',NULL,'697',6564261.15,6564261.15,'697','2021-12-30 10:27:25','533','2021-12-30 10:34:07',10,0),('1','122',250234,'MORNING & AFTERNOON','2021-12-30','2021-12-30 00:00:00',NULL,'697',4132614.00,4132614.00,'697','2021-12-31 14:26:21','533','2021-12-31 14:31:07',10,0),('1','122',250501,'MORNING & AFTERNOON','2021-12-31','2021-12-31 00:00:00',NULL,'697',2868093.00,2868093.00,'697','2022-01-01 17:57:21','533','2022-01-02 08:07:40',10,0),('1','122',250720,'MORNING & AFTERNOON','2022-01-01','2022-01-01 00:00:00',NULL,'697',3088556.40,3088556.40,'697','2022-01-02 15:46:02','533','2022-01-03 07:54:41',10,0),('1','122',250910,'MORNING & AFTERNOON','2022-01-02','2022-01-02 00:00:00',NULL,'697',2173029.60,2173029.60,'697','2022-01-03 13:47:16','533','2022-01-03 15:18:19',10,0),('1','122',251154,'MORNING & AFTERNOON','2022-01-03','2022-01-03 00:00:00',NULL,'697',525108.00,525108.00,'697','2022-01-04 13:33:17','533','2022-01-04 13:35:24',10,0),('1','122',251384,'MORNING & AFTERNOON','2022-01-04','2022-01-04 00:00:00',NULL,'697',4889617.05,4889617.05,'697','2022-01-05 13:56:08','533','2022-01-05 14:01:49',10,0),('1','122',251642,'MORNING & AFTERNOON','2022-01-05','2022-01-05 00:00:00',NULL,'697',5519082.90,5519082.90,'697','2022-01-06 13:57:11','533','2022-01-06 14:58:49',10,0),('1','122',251854,'MORNING & AFTERNOON','2022-01-06','2022-01-06 00:00:00',NULL,'697',4125505.95,4125505.95,'697','2022-01-07 14:58:22','533','2022-01-07 15:05:14',10,0),('1','122',251913,'MORNING & AFTERNOON','2022-01-07','2022-01-07 00:00:00',NULL,'697',5197876.80,5197876.80,'697','2022-01-08 15:01:30','533','2022-01-08 15:03:59',10,0),('1','122',252383,'MORNING & AFTERNOON','2022-01-08','2022-01-08 00:00:00',NULL,'697',3444057.30,3444057.30,'697','2022-01-09 17:02:16','533','2022-01-09 17:12:22',10,0),('1','122',252578,'MORNING & AFTERNOON','2022-01-09','2022-01-09 00:00:00',NULL,'697',3183019.35,3183019.35,'697','2022-01-10 12:06:23','533','2022-01-10 12:14:48',10,0),('1','122',252654,'MORNING & AFTERNOON','2022-01-10','2022-01-10 00:00:00',NULL,'697',7332301.95,7332301.95,'697','2022-01-11 11:01:47','533','2022-01-11 11:40:41',10,0),('1','122',252843,'MORNING & AFTERNOON','2022-01-11','2022-01-11 00:00:00',NULL,'697',5118093.90,5118093.90,'697','2022-01-12 10:26:22','533','2022-01-12 11:39:25',10,0),('1','122',253298,'MORNING & AFTERNOON','2022-01-12','2022-01-12 00:00:00',NULL,'697',5369302.05,5369302.05,'697','2022-01-13 10:51:40','533','2022-01-13 12:58:43',10,0),('1','122',253557,'MORNING & AFTERNOON','2022-01-13','2022-01-13 00:00:00',NULL,'697',6984147.90,6984147.90,'697','2022-01-14 11:21:38','533','2022-01-14 15:17:24',10,0),('1','122',253779,'MORNING & AFTERNOON','2022-01-14','2022-01-14 00:00:00',NULL,'697',5033821.50,5033821.50,'697','2022-01-15 13:37:34','533','2022-01-15 15:13:21',10,0),('1','122',254040,'MORNING & AFTERNOON','2022-01-15','2022-01-15 00:00:00',NULL,'697',4816593.45,4816593.45,'697','2022-01-16 15:51:22','533','2022-01-16 18:24:46',10,0),('1','122',254276,'MORNING & AFTERNOON','2022-01-16','2022-01-16 00:00:00',NULL,'697',3415593.15,3415593.15,'697','2022-01-17 10:09:20','533','2022-01-17 10:43:25',10,0),('1','122',254539,'MORNING & AFTERNOON','2022-01-17','2022-01-17 00:00:00',NULL,'697',3043093.50,3043093.50,'697','2022-01-18 10:56:59','533','2022-01-18 15:43:17',10,0),('1','122',254627,'MORNING & AFTERNOON','2022-01-18','2022-01-18 00:00:00',NULL,'697',5153532.35,5153532.35,'697','2022-01-19 10:35:56','533','2022-01-19 10:55:49',10,0),('1','122',255022,'MORNING & AFTERNOON','2022-01-19','2022-01-19 00:00:00',NULL,'697',4563957.60,4563957.60,'697','2022-01-20 14:26:40','533','2022-01-20 14:51:19',10,0),('1','122',255279,'MORNING & AFTERNOON','2022-01-20','2022-01-20 00:00:00',NULL,'697',4436794.00,4436794.00,'697','2022-01-21 11:33:36','533','2022-01-21 16:27:38',10,0),('1','122',255530,'MORNING & AFTERNOON','2022-01-21','2022-01-21 00:00:00',NULL,'697',6364273.05,6364273.05,'697','2022-01-22 11:21:16','533','2022-01-22 11:43:43',10,0),('1','122',255790,'MORNING & AFTERNOON','2022-01-22','2022-01-22 00:00:00',NULL,'697',5690386.15,5690386.15,'697','2022-01-23 11:19:51','533','2022-01-23 14:05:44',10,0),('1','122',256042,'MORNING & AFTERNOON','2022-01-23','2022-01-23 00:00:00',NULL,'697',2215186.40,2215186.40,'697','2022-01-24 10:30:50','533','2022-01-24 11:14:14',10,0),('1','122',256288,'MORNING & AFTERNOON','2022-01-24','2022-01-24 00:00:00',NULL,'697',9562868.70,9562868.70,'697','2022-01-25 10:40:16','533','2022-01-25 13:16:25',10,0),('1','122',256562,'MORNING & AFTERNOON','2022-01-25','2022-01-25 00:00:00',NULL,'697',7401407.55,7401407.55,'697','2022-01-26 10:30:22','533','2022-01-26 11:52:08',10,0),('1','122',256795,'MORNING & AFTERNOON','2022-01-26','2022-01-26 00:00:00',NULL,'697',7860698.85,7860698.85,'697','2022-01-27 12:46:55','533','2022-01-28 07:10:08',10,0),('1','122',257043,'MORNING & AFTERNOON','2022-01-27','2022-01-27 00:00:00',NULL,'697',3829439.95,3829439.95,'697','2022-01-28 10:30:15','533','2022-01-28 12:25:23',10,0),('1','122',257313,'MORNING & AFTERNOON','2022-01-28','2022-01-28 00:00:00',NULL,'697',9678376.80,9678376.80,'697','2022-01-29 11:08:07','533','2022-01-29 16:19:30',10,0),('1','122',257567,'MORNING & AFTERNOON','2022-01-29','2022-01-29 00:00:00',NULL,'697',5318379.90,5318379.90,'697','2022-01-30 11:31:50','533','2022-01-30 12:49:45',10,0),('1','122',257568,'MORNING & AFTERNOON','2022-01-30','2022-01-30 00:00:00',NULL,'697',5009373.60,5009373.60,'697','2022-01-31 09:46:47','533','2022-01-31 11:17:35',10,0),('1','122',257569,'MORNING & AFTERNOON','2022-01-31','2022-01-31 00:00:00',NULL,'697',7112696.25,7112696.25,'697','2022-02-01 10:43:59','533','2022-02-01 22:01:23',10,0),('1','122',257570,'MORNING & AFTERNOON','2022-02-01','2022-02-01 00:00:00',NULL,'697',8921094.60,8921094.60,'697','2022-02-02 11:32:14','533','2022-02-02 14:20:33',10,0),('1','122',257571,'MORNING & AFTERNOON','2022-02-02','2022-02-02 00:00:00',NULL,'697',9748325.40,9748325.40,'697','2022-02-03 10:59:31','454','2022-02-04 15:35:27',10,0),('1','122',257572,'MORNING & AFTERNOON','2022-02-03','2022-02-03 00:00:00',NULL,'697',6264124.65,6264124.65,'697','2022-02-04 16:52:07','533','2022-02-04 18:15:27',10,0),('1','122',257573,'MORNING & AFTERNOON','2022-02-04','2022-02-04 00:00:00',NULL,'697',8884103.25,8884103.25,'697','2022-02-05 12:05:09','533','2022-02-05 12:38:39',10,0),('1','122',257574,'CHANGE OF PRICE 0F AGO','2022-02-05','2022-02-05 00:00:00',NULL,'697',189943.00,189943.00,'697','2022-02-06 11:54:00','533','2022-02-06 12:17:22',10,0),('1','122',257575,'MORNING & AFTERNOON','2022-02-05','2022-02-05 00:00:00',NULL,'697',8727916.30,8727916.30,'697','2022-02-06 13:28:53','533','2022-02-06 14:57:13',10,0),('1','122',257576,'MORNING & AFTERNOON','2022-02-06','2022-02-06 00:00:00',NULL,'697',4336423.40,4336423.40,'697','2022-02-07 11:32:51','533','2022-02-07 19:28:07',10,0),('1','122',257577,'MORNING & AFTERNOON','2022-02-07','2022-02-07 00:00:00',NULL,'697',5418542.55,5418542.55,'697','2022-02-08 10:10:38','533','2022-02-08 11:51:27',10,0),('1','122',257578,'MORNING & AFTERNOON','2022-02-08','2022-02-08 00:00:00',NULL,'697',6065513.05,6065513.05,'697','2022-02-09 10:15:01','533','2022-02-09 17:12:49',10,0),('1','122',257579,'MORNING & AFTERNOON','2022-02-09','2022-02-09 00:00:00',NULL,'697',8291859.90,8291859.90,'697','2022-02-10 11:04:51','533','2022-02-10 12:20:58',10,0),('1','122',257580,'MORNING & AFTERNOON','2022-02-10','2022-02-10 00:00:00',NULL,'697',8412178.65,8412178.65,'697','2022-02-11 09:48:50','454','2022-02-12 11:05:13',10,0),('1','122',257581,'MORNING & AFTERNOON','2022-02-11','2022-02-11 00:00:00',NULL,'697',4185080.55,4185080.55,'697','2022-02-13 12:55:28','533','2022-02-13 15:41:38',10,0),('1','122',257582,'MORNING & AFTERNOON','2022-02-13','2022-02-13 00:00:00',NULL,'697',7765780.90,7765780.90,'697','2022-02-14 10:17:10','533','2022-02-14 16:01:15',10,0),('1','122',257583,'MORNING & AFTERNOON','2022-02-14','2022-02-14 00:00:00',NULL,'697',4549493.50,4549493.50,'697','2022-02-15 10:46:17','533','2022-02-15 15:40:44',10,0),('1','122',257584,'MORNING & AFTERNOON','2022-02-15','2022-02-15 00:00:00',NULL,'697',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','122',257585,'MORNING & AFTERNOON','2022-02-15','2022-02-15 00:00:00',NULL,'697',1592272.00,1592272.00,'697','2022-02-16 11:13:27','533','2022-02-16 11:22:47',10,0),('1','122',257586,'PRICE CHANGE 0F AGO','2022-02-15','2022-02-15 00:00:00',NULL,'697',3964017.10,3964017.10,'697','2022-02-16 11:34:50','533','2022-02-16 11:37:58',10,0),('1','122',257587,'MORNING & AFTERNOON','2022-02-16','2022-02-16 00:00:00',NULL,'697',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','122',257588,'MORNING & AFTERNOON','2022-02-16','2022-02-16 00:00:00',NULL,'697',8887110.15,8887110.15,'697','2022-02-17 09:56:32','533','2022-02-17 11:00:18',10,0),('1','122',257589,'MORNING & AFTERNOON','2022-02-17','2022-02-17 00:00:00',NULL,'697',7628931.75,7628931.75,'697','2022-02-18 10:17:17','454','2022-02-18 11:57:03',10,0),('1','122',257590,'MORNING & AFTERNOON','2022-02-18','2022-02-18 00:00:00',NULL,'697',6079962.90,6079962.90,'697','2022-02-19 10:34:14','533','2022-02-20 18:16:12',10,0),('1','122',257591,'MORNING & AFTERNOON','2022-02-19','2022-02-19 00:00:00',NULL,'697',8273110.05,8273110.05,'697','2022-02-20 18:47:31','533','2022-02-20 20:13:26',10,0),('1','122',257592,'MORNING & AFTERNOON','2022-02-20','2022-02-20 00:00:00',NULL,'697',8282257.55,8282257.55,'697','2022-02-21 10:03:11','533','2022-02-21 11:00:48',10,0),('1','122',257593,'MORNING & AFTERNOON','2022-02-21','2022-02-22 10:17:15','2022-02-23 10:17:15','697',6367608.15,6367608.15,'697','2022-02-22 10:39:54','454','2022-02-22 10:55:51',10,0),('1','122',257594,'MORNING & AFTERNOON','2022-02-22','2022-02-22 14:44:24','2022-02-23 14:44:24','697',375617.40,375617.40,'697','2022-02-22 14:45:57','533','2022-02-23 08:25:19',10,0),('1','122',257595,'PRICE CHANGE 0F AGO','2022-02-22','2022-02-23 09:48:37','2022-02-24 09:48:37','697',5415420.00,5415420.00,'697','2022-02-23 10:30:02','533','2022-02-23 17:35:17',10,0),('1','122',257596,'MORNING & AFTERNOON','2022-02-23','2022-02-24 09:45:07','2022-02-25 09:45:07','697',3428140.70,3428140.70,'697','2022-02-24 10:57:10','454','2022-02-24 12:17:12',10,0),('1','122',257597,'MORNING & AFTERNOON','2022-02-24','2022-02-25 16:31:30','2022-02-26 16:31:30','697',5062845.65,5062845.65,'697','2022-02-25 16:43:14','533','2022-02-25 17:26:03',10,0),('1','122',257598,'MORNING & AFTERNOON','2022-02-25','2022-02-25 18:29:44','2022-02-26 18:29:44','697',1010317.50,1010317.50,'697','2022-02-25 18:32:58','533','2022-02-25 18:45:08',10,0),('1','122',257599,'CHANGE OF PRICE 0F AGO','2022-02-25','2022-02-26 14:08:34','2022-02-27 14:08:34','697',5955482.10,5974249.50,'697','2022-02-26 14:15:30','533','2022-02-26 15:11:18',10,0),('1','122',257600,'MORNING & AFTERNOON','2022-02-26','2022-02-28 10:29:33','2022-03-01 10:29:33','697',4017123.75,4017123.75,'697','2022-02-28 10:34:40','533','2022-02-28 10:53:51',10,0),('1','122',257601,'MORNING & AFTERNOON','2022-02-27','2022-02-28 10:55:02','2022-03-01 10:55:02','697',3282551.25,3282551.25,'697','2022-02-28 12:01:16','533','2022-02-28 12:16:27',10,0),('1','122',257602,'MORNING & AFTERNOON','2022-02-28','2022-03-01 12:38:15','2022-03-02 12:38:15','697',9038555.25,9038555.25,'697','2022-03-01 12:52:40','533','2022-03-01 12:54:30',10,0),('1','122',257603,'MORNING & AFTERNOON','2022-03-01','2022-03-02 11:59:10','2022-03-03 11:59:10','697',6728766.05,6728766.05,'697','2022-03-02 12:08:02','533','2022-03-02 12:34:24',10,0),('1','122',257604,'MORNING & AFTERNOON','2022-03-02','2022-03-02 17:06:20','2022-03-03 17:06:20','697',959376.60,982218.90,'697','2022-03-02 17:24:32','454','2022-03-03 14:57:08',10,0),('1','122',257605,'CHANGE OF PRICE 0F AGO','2022-03-02','2022-03-03 15:01:31','2022-03-04 15:01:31','697',10435250.40,10479526.90,'697','2022-03-03 15:25:48','533','2022-03-03 16:14:14',10,0),('1','122',257606,'MORNING & AFTERNOON','2022-03-03','2022-03-04 15:46:48','2022-03-05 15:46:48','697',11257835.70,11314444.40,'697','2022-03-04 17:09:30','454','2022-03-04 17:11:42',10,0),('1','122',257607,'MORNING & AFTERNOON','2022-03-04','2022-03-04 17:53:39','2022-03-05 17:53:39','697',1266111.00,1296256.50,'697','2022-03-04 17:59:44','533','2022-03-04 18:38:16',10,0),('1','122',257608,'CHANGE OF PRICE 0F AGO','2022-03-04','2022-03-05 20:05:04','2022-03-06 20:05:04','697',8438291.10,8438291.10,'697','2022-03-05 20:09:54','533','2022-03-06 09:37:17',10,0),('1','122',257609,'MORNING & AFTERNOON','2022-03-05','2022-03-06 09:39:09','2022-03-07 09:39:09','697',8940494.65,8940494.65,'697','2022-03-06 09:56:20','533','2022-03-06 10:03:46',10,0),('1','122',257610,'MORNING & AFTERNOON','2022-03-06','2022-03-07 15:00:09','2022-03-08 15:00:09','697',7301048.70,7301048.70,'697','2022-03-07 15:13:49','533','2022-03-07 23:02:49',10,0),('1','122',257611,'MORNING & AFTERNOON','2022-03-07','2022-03-08 11:40:43','2022-03-09 11:40:43','697',8773323.90,8773323.90,'697','2022-03-08 13:06:28','533','2022-03-08 15:47:53',10,0),('1','122',257612,'MORNING & AFTERNOON','2022-03-08','2022-03-08 18:56:08','2022-03-09 18:56:08','697',2595755.00,2595755.00,'697','2022-03-09 13:50:00','533','2022-03-09 14:09:50',10,0),('1','122',257613,'CHANGE OF PRICE 0F AGO','2022-03-08','2022-03-09 14:53:27','2022-03-10 14:53:27','697',8759573.55,8759573.55,'697','2022-03-09 16:02:12','533','2022-03-09 19:34:10',10,0),('1','122',257614,'MORNING & AFTERNOON','2022-03-09','2022-03-10 13:10:40','2022-03-11 13:10:40','697',12521179.80,12521179.80,'697','2022-03-10 13:41:42','533','2022-03-10 14:28:54',10,0),('1','122',257615,'MORNING & AFTERNOON','2022-03-10','2022-03-11 12:43:16','2022-03-12 12:43:16','697',8473830.75,8473830.75,'697','2022-03-11 13:13:33','533','2022-03-11 13:16:10',10,0),('1','122',257616,'MORNING & AFTERNOON','2022-03-11','2022-03-12 16:56:16','2022-03-13 16:56:16','697',15060887.55,15060887.55,'697','2022-03-12 18:11:06','533','2022-03-13 10:37:52',10,0),('1','122',257617,'MORNING & AFTERNOON','2022-03-12','2022-03-13 10:40:51','2022-03-14 10:40:51','697',9997503.90,9997503.90,'697','2022-03-13 11:05:43','533','2022-03-13 11:12:45',10,0),('1','122',257618,'MORNING & AFTERNOON','2022-03-13','2022-03-14 15:03:55','2022-03-15 15:03:55','697',12181011.90,12181011.90,'697','2022-03-14 15:32:58','533','2022-03-14 16:45:25',10,0),('1','122',257619,'MORNING & AFTERNOON','2022-03-14','2022-03-15 10:26:51','2022-03-16 10:26:51','697',8804596.35,8804596.35,'697','2022-03-15 11:42:04','533','2022-03-15 11:45:41',10,0),('1','122',257620,'MORNING & AFTERNOON','2022-03-15','2022-03-16 14:33:29','2022-03-17 14:33:29','697',9931633.85,9931633.85,'697','2022-03-16 14:46:24','533','2022-03-17 10:08:23',10,0),('1','122',257621,'MORNING & AFTERNOON','2022-03-16','2022-03-17 14:36:08','2022-03-18 14:36:08','697',20920158.30,20920158.30,'697','2022-03-17 20:12:21','533','2022-03-17 20:34:03',10,0),('1','122',257622,'CHANGE OF PRICE 0F AGO','2022-03-17','2022-03-18 10:05:46','2022-03-19 10:05:46','697',1014773.50,1014773.50,'697','2022-03-18 10:07:32','454','2022-03-18 11:55:18',10,0),('1','122',257623,'MORNING & AFTERNOON','2022-03-17','2022-03-18 14:52:15','2022-03-19 14:52:15','697',8369029.35,8369029.35,'697','2022-03-18 15:08:49','533','2022-03-18 16:49:30',10,0),('1','122',257624,'MORNING & AFTERNOON','2022-03-18','2022-03-18 17:32:28','2022-03-19 17:32:28','697',15834809.10,15834809.10,'697','2022-03-19 14:07:05','533','2022-03-19 17:51:22',10,0),('1','122',257625,'MORNING & AFTERNOON','2022-03-19','2022-03-19 19:36:15','2022-03-20 19:36:15','697',7715853.75,7715853.75,'697','2022-03-20 10:34:15','533','2022-03-20 14:55:16',10,0),('1','122',257626,'MORNING & AFTERNOON','2022-03-20','2022-03-20 15:31:14','2022-03-21 15:31:14','697',0.00,0.00,'454','2022-03-21 10:13:02','454','2022-03-21 10:13:32',10,0),('1','122',257627,'MORNING & AFTERNOON','2022-03-20','2022-03-21 10:16:28','2022-03-22 10:16:28','697',0.00,0.00,'697','2022-03-21 10:38:53','533','2022-03-21 11:14:06',10,0),('1','122',257628,'MORNING & AFTERNOON','2022-03-20','2022-03-21 11:27:55','2022-03-22 11:27:55','697',7432182.40,7432182.40,'697','2022-03-21 11:37:50','533','2022-03-21 12:42:27',10,0),('1','122',257629,'MORNING & AFTERNOON','2022-03-21','2022-03-21 15:47:53','2022-03-22 15:47:53','697',18091599.35,18091599.35,'697','2022-03-22 21:23:05','533','2022-03-23 10:27:43',10,0),('1','122',257630,'MORNING & AFTERNOON','2022-03-22','2022-03-23 10:58:25','2022-03-24 10:58:25','697',11642529.55,11642529.55,'697','2022-03-23 11:20:47','454','2022-03-23 11:51:40',10,0),('1','122',257631,'MORNING & AFTERNOON','2022-03-23','2022-03-23 13:19:51','2022-03-24 13:19:51','697',0.00,0.00,'697','2022-03-23 15:33:21','533','2022-03-23 15:42:00',10,0),('1','122',257632,'CHANGE OF PRICE 0F AGO','2022-03-23','2022-03-23 15:43:37','2022-03-24 15:43:37','697',1506220.40,1506220.40,'697','2022-03-23 15:45:18','533','2022-03-23 16:25:30',10,0),('1','122',257633,'MORNING & AFTERNOON','2022-03-23','2022-03-24 10:35:17','2022-03-25 10:35:17','697',9209880.20,9209880.20,'697','2022-03-24 10:55:55','533','2022-03-24 15:05:17',10,0),('1','122',257634,'MORNING & AFTERNOON','2022-03-24','2022-03-25 08:30:52','2022-03-26 08:30:52','697',14556779.90,14556779.90,'697','2022-03-25 09:49:04','454','2022-03-25 11:49:49',10,0),('1','122',257635,'MORNING & AFTERNOON','2022-03-25','2022-03-26 10:00:24','2022-03-27 10:00:24','697',11515956.70,11515956.70,'697','2022-03-26 10:19:55','533','2022-03-26 11:15:24',10,0),('1','122',257636,'MORNING & AFTERNOON','2022-03-26','2022-03-27 09:01:56','2022-03-28 09:01:56','697',8127833.85,8127833.85,'697','2022-03-27 10:01:43','533','2022-03-27 17:48:22',10,0),('1','122',257637,'MORNING & AFTERNOON','2022-03-27','2022-03-28 07:58:18','2022-03-29 07:58:18','697',8050457.00,8050457.00,'697','2022-03-28 08:43:42','533','2022-03-28 08:48:40',10,0),('1','122',257638,'MORNING & AFTERNOON','2022-03-28','2022-03-29 08:40:59','2022-03-30 08:40:59','697',13596683.80,13596683.80,'697','2022-03-29 09:20:28','533','2022-03-29 12:18:51',10,0),('1','122',257639,'MORNING & AFTERNOON','2022-03-29','2022-03-30 09:26:43','2022-03-31 09:26:43','697',9965796.75,9965796.75,'697','2022-03-30 09:53:02','533','2022-03-30 17:20:47',10,0),('1','122',257640,'MORNING & AFTERNOON','2022-03-30','2022-03-31 08:56:20','2022-04-01 08:56:20','697',12134657.15,12134657.15,'697','2022-03-31 09:18:10','533','2022-03-31 10:02:12',10,0),('1','122',257641,'MORNING & AFTERNOON','2022-03-31','2022-04-01 08:01:00','2022-04-02 08:01:00','697',9010054.15,9010054.15,'697','2022-04-01 12:43:22','533','2022-04-01 16:17:51',10,0),('1','122',257642,'MORNING & AFTERNOON','2022-04-01','2022-04-02 08:23:12','2022-04-03 08:23:12','697',4630010.65,4630010.65,'697','2022-04-02 08:50:18','533','2022-04-02 11:54:12',10,0),('1','122',257643,'MORNING & AFTERNOON','2022-04-02','2022-04-03 07:58:06','2022-04-04 07:58:06','697',7176974.35,7176974.35,'697','2022-04-03 11:49:15','533','2022-04-03 19:25:13',10,0),('1','122',257644,'MORNING & AFTERNOON','2022-04-03','2022-04-04 08:10:08','2022-04-05 08:10:08','697',7031901.35,7031901.35,'697','2022-04-04 08:25:28','533','2022-04-04 11:05:33',10,0),('1','122',257645,'MORNING & AFTERNOON','2022-04-04','2022-04-05 08:08:00','2022-04-06 08:08:00','697',10510303.35,10510303.35,'697','2022-04-05 09:35:42','533','2022-04-05 10:54:30',10,0),('1','122',257646,'MORNING & AFTERNOON','2022-04-05','2022-04-06 08:04:54','2022-04-07 08:04:54','697',4988574.35,4988574.35,'697','2022-04-06 08:54:15','533','2022-04-06 09:57:59',10,0),('1','122',257647,'MORNING','2022-04-06','2022-04-06 17:04:22','2022-04-07 17:04:22','697',4003166.20,4003166.20,'697','2022-04-06 17:10:41','533','2022-04-07 10:46:10',10,0),('1','122',257648,'AFTERNOON','2022-04-06','2022-04-07 10:51:11','2022-04-08 10:51:11','697',5702814.80,5702814.80,'697','2022-04-07 11:03:10','533','2022-04-07 12:19:26',10,0),('1','122',257649,'MORNING','2022-04-07','2022-04-07 16:24:47','2022-04-08 16:24:47','697',4759663.13,4759663.13,'697','2022-04-07 16:33:11','533','2022-04-08 12:03:56',10,0),('1','122',257650,'AFTERNOON','2022-04-07','2022-04-08 12:12:27','2022-04-09 12:12:27','697',5036144.20,5036144.20,'697','2022-04-08 12:17:48','533','2022-04-08 20:22:50',10,0),('1','122',257651,'MORNING','2022-04-08','2022-04-08 20:26:13','2022-04-09 20:26:13','697',3483298.50,3483298.50,'697','2022-04-08 20:30:01','533','2022-04-09 11:31:39',10,0),('1','122',257652,'AFTERNOON','2022-04-08','2022-04-09 11:37:49','2022-04-10 11:37:49','697',7747314.90,7747314.90,'697','2022-04-09 12:33:30','533','2022-04-09 16:12:24',10,0),('1','122',257653,'MORNING','2022-04-09','2022-04-09 17:32:11','2022-04-10 17:32:11','697',2682264.75,2682264.75,'697','2022-04-09 18:07:41','533','2022-04-10 11:30:51',10,0),('1','122',257654,'AFTERNOON','2022-04-09','2022-04-10 11:39:38','2022-04-11 11:39:38','697',4541859.00,4541859.00,'697','2022-04-10 11:52:51','533','2022-04-10 14:16:28',10,0),('1','122',257655,'MORNING','2022-04-10','2022-04-10 17:27:27','2022-04-11 17:27:27','697',2089437.90,2089437.90,'697','2022-04-10 17:36:26','533','2022-04-10 18:54:13',10,0),('1','122',257656,'AFTERNOON','2022-04-10','2022-04-10 22:03:04','2022-04-11 22:03:04','697',2625478.35,2625478.35,'697','2022-04-11 17:05:04','533','2022-04-11 17:54:06',10,0),('1','122',257657,'MORNING','2022-04-11','2022-04-11 18:03:55','2022-04-12 18:03:55','697',4561730.15,4561730.15,'697','2022-04-11 18:58:44','533','2022-04-12 07:51:36',10,0),('1','122',257658,'AFTERNOON','2022-04-11','2022-04-12 13:54:54','2022-04-13 13:54:54','697',5046180.90,5046180.90,'697','2022-04-12 14:06:42','533','2022-04-12 14:17:12',10,0),('1','122',257659,'MORNING','2022-04-12','2022-04-12 14:56:49','2022-04-13 14:56:49','697',3978376.35,3978376.35,'697','2022-04-13 14:35:08','533','2022-04-13 14:43:01',10,0),('1','122',257660,'AFTERNOON','2022-04-12','2022-04-13 14:44:13','2022-04-14 14:44:13','697',5820041.75,5820041.75,'697','2022-04-13 15:02:59','533','2022-04-13 15:04:33',10,0),('1','122',257661,'MORNING','2022-04-13','2022-04-14 10:09:07','2022-04-15 10:09:07','697',4392238.50,4392238.50,'697','2022-04-14 10:33:59','533','2022-04-14 12:34:24',10,0),('1','122',257662,'AFTERNOON','2022-04-13','2022-04-14 14:20:49','2022-04-15 14:20:49','697',4680666.45,4680666.45,'697','2022-04-14 14:43:30','454','2022-04-14 14:51:19',10,0),('1','122',257663,'MORNING','2022-04-14','2022-04-14 17:54:29','2022-04-15 17:54:29','697',3557039.05,3557039.05,'697','2022-04-14 18:04:22','533','2022-04-15 10:08:30',10,0),('1','122',257664,'AFTERNOON','2022-04-14','2022-04-15 10:17:53','2022-04-16 10:17:53','697',10451672.90,10451672.90,'697','2022-04-15 13:15:21','533','2022-04-15 16:13:50',10,0),('1','122',257665,'MORNING','2022-04-15','2022-04-15 16:43:16','2022-04-16 16:43:16','697',3327748.05,3327748.05,'697','2022-04-15 16:59:05','454','2022-04-16 10:25:02',10,0),('1','122',257666,'AFTERNOON','2022-04-15','2022-04-16 11:25:10','2022-04-17 11:25:10','697',4931475.70,4931475.70,'697','2022-04-16 12:02:14','454','2022-04-16 14:01:57',10,0),('1','122',257667,'MORNING','2022-04-16','2022-04-16 18:07:47','2022-04-17 18:07:47','697',3315407.60,3315407.60,'697','2022-04-16 18:15:38','533','2022-04-17 06:20:31',10,0),('1','122',257668,'AFTERNOON','2022-04-16','2022-04-17 08:28:14','2022-04-18 08:28:14','697',4004931.30,4004931.30,'697','2022-04-17 08:49:36','533','2022-04-17 12:59:35',10,0),('1','122',257669,'MORNING','2022-04-17','2022-04-17 16:34:57','2022-04-18 16:34:57','697',1949425.50,1949425.50,'697','2022-04-17 16:38:24','533','2022-04-18 09:42:41',10,0),('1','122',257670,'AFTERNOON','2022-04-17','2022-04-18 09:59:39','2022-04-19 09:59:39','697',2485133.03,2485133.03,'697','2022-04-18 10:09:38','533','2022-04-18 17:22:45',10,0),('1','122',257671,'MORNING','2022-04-18','2022-04-18 17:30:39','2022-04-19 17:30:39','697',2589895.25,2589895.25,'697','2022-04-18 17:40:23','533','2022-04-19 10:33:14',10,0),('1','122',257672,'AFTERNOON','2022-04-18','2022-04-19 10:39:04','2022-04-20 10:39:04','697',313439.00,313439.00,'697','2022-04-19 10:42:30','533','2022-04-19 11:37:19',10,0),('1','122',257673,'MORNING','2022-04-19','2022-04-19 20:45:42','2022-04-20 20:45:42','697',3056590.10,3056590.10,'697','2022-04-19 21:00:48','533','2022-04-20 11:31:13',10,0),('1','122',257674,'AFTERNOON','2022-04-19','2022-04-20 14:23:15','2022-04-21 14:23:15','697',5440338.60,5440338.60,'697','2022-04-20 14:51:24','533','2022-04-20 19:33:47',10,0),('1','122',257675,'MORNING','2022-04-20','2022-04-20 20:04:38','2022-04-21 20:04:38','697',3704110.05,3704110.05,'697','2022-04-20 20:13:36','533','2022-04-21 08:00:51',10,0),('1','122',257676,'AFTERNOON','2022-04-20','2022-04-21 11:07:38','2022-04-22 11:07:38','697',4136668.95,4136668.95,'697','2022-04-21 12:22:47','533','2022-04-21 14:52:10',10,0),('1','122',257677,'MORNING','2022-04-21','2022-04-21 17:15:53','2022-04-22 17:15:53','697',11291262.54,11291262.54,'697','2022-04-21 17:25:39','533','2022-04-22 12:05:04',10,0),('1','122',257678,'AFTERNOON','2022-04-21','2022-04-22 12:12:32','2022-04-23 12:12:32','697',4454058.10,4454058.10,'697','2022-04-22 13:01:53','533','2022-04-22 18:06:00',10,0),('1','122',257679,'MORNING','2022-04-22','2022-04-22 20:06:25','2022-04-23 20:06:25','697',2678487.20,2678487.20,'697','2022-04-22 20:18:10','533','2022-04-23 12:45:23',10,0),('1','122',257680,'AFTERNOON','2022-04-22','2022-04-23 14:21:08','2022-04-24 14:21:08','697',4674465.85,4674465.85,'697','2022-04-23 14:52:56','533','2022-04-23 17:38:47',10,0),('1','122',257681,'MORNING','2022-04-23','2022-04-23 17:42:37','2022-04-24 17:42:37','697',3996593.55,3996593.55,'697','2022-04-23 17:57:58','533','2022-04-24 12:38:05',10,0),('1','122',257682,'AFTERNOON','2022-04-23','2022-04-24 19:32:38','2022-04-25 19:32:38','697',4020427.45,4020427.45,'697','2022-04-24 19:44:31','533','2022-04-25 10:31:04',10,0),('1','122',257683,'MORNING','2022-04-24','2022-04-25 11:03:23','2022-04-26 11:03:23','697',2982464.10,2982464.10,'697','2022-04-25 20:31:23','533','2022-04-25 20:38:42',10,0),('1','122',257684,'AFTERNOON','2022-04-24','2022-04-25 21:02:33','2022-04-26 21:02:33','697',4012735.75,4012735.75,'697','2022-04-25 21:12:04','533','2022-04-26 06:39:05',10,0),('1','122',257685,'MORNING','2022-04-25','2022-04-26 09:53:40','2022-04-27 09:53:40','697',3101120.00,3101120.00,'697','2022-04-26 10:01:46','533','2022-04-26 13:00:22',10,0),('1','122',257686,'AFTERNOON','2022-04-25','2022-04-26 13:41:01','2022-04-27 13:41:01','697',2888811.80,2888811.80,'697','2022-04-26 20:46:48','533','2022-04-27 08:33:20',10,0),('1','122',257687,'MORNING','2022-04-26','2022-04-27 10:23:14','2022-04-28 10:23:14','697',3403281.70,3403281.70,'697','2022-04-27 11:39:44','533','2022-04-27 13:04:04',10,0),('1','122',257688,'AFTERNOON','2022-04-26','2022-04-27 13:11:54','2022-04-28 13:11:54','697',2025194.45,2025194.45,'697','2022-04-27 13:21:12','533','2022-04-27 15:23:58',10,0),('1','122',257689,'MORNING','2022-04-27','2022-04-28 09:59:20','2022-04-29 09:59:20','697',4488541.85,4488541.85,'697','2022-04-28 10:18:09','533','2022-04-28 10:58:00',10,0),('1','122',257690,'AFTERNOON','2022-04-27','2022-04-28 11:43:43','2022-04-29 11:43:43','697',3675115.10,3675115.10,'697','2022-04-28 12:33:33','533','2022-04-29 10:06:06',10,0),('1','122',257691,'MORNING','2022-04-28','2022-04-29 12:58:35','2022-04-30 12:58:35','697',1736382.45,1736382.45,'697','2022-04-29 15:36:03','533','2022-04-29 16:11:13',10,0),('1','122',257692,'AFTERNOON','2022-04-28','2022-04-29 16:34:33','2022-04-30 16:34:33','697',1760210.10,1760210.10,'697','2022-04-29 16:38:18','533','2022-04-30 08:12:23',10,0),('1','122',257693,'MORNING','2022-04-29','2022-04-30 10:31:01','2022-05-01 10:31:01','697',3008346.00,3008346.00,'697','2022-04-30 10:39:36','533','2022-04-30 14:36:29',10,0),('1','122',257694,'AFTERNOON','2022-04-29','2022-04-30 14:37:16','2022-05-01 14:37:16','697',3411823.80,3411823.80,'697','2022-04-30 14:41:39','533','2022-04-30 19:16:57',10,0),('1','122',257695,'MORNING','2022-04-30','2022-04-30 20:23:02','2022-05-01 20:23:02','697',4173015.00,4173015.00,'697','2022-04-30 20:55:57','533','2022-04-30 21:06:42',10,0),('1','122',257696,'AFTERNOON','2022-04-30','2022-05-01 08:39:39','2022-05-02 08:39:39','697',3357099.90,3357099.90,'697','2022-05-01 11:23:21','533','2022-05-01 12:12:47',10,0),('1','122',257697,'MORNING','2022-05-01','2022-05-01 18:24:57','2022-05-02 18:24:57','697',2601477.45,2601477.45,'697','2022-05-01 19:30:39','533','2022-05-02 13:30:41',10,0),('1','122',257698,'AFTERNOON','2022-05-01','2022-05-03 20:33:51','2022-05-04 20:33:51','697',3527316.30,3527316.30,'697','2022-05-03 20:53:06','533','2022-05-04 08:38:48',10,0),('1','122',257699,'MORNING','2022-05-02','2022-05-04 11:23:47','2022-05-05 11:23:47','697',2319259.20,2319259.20,'697','2022-05-04 11:33:33','533','2022-05-04 11:38:24',10,0),('1','122',257700,'AFTERNOON','2022-05-02','2022-05-04 11:46:42','2022-05-05 11:46:42','697',2381596.60,2381596.60,'697','2022-05-04 11:53:35','533','2022-05-04 12:11:27',10,0),('1','122',257701,'MORNING','2022-05-03','2022-05-04 12:13:44','2022-05-05 12:13:44','697',2483582.30,2483582.30,'697','2022-05-04 13:06:56','533','2022-05-04 13:12:44',10,0),('1','122',257702,'AFTERNOON','2022-05-03','2022-05-04 14:00:50','2022-05-05 14:00:50','697',4232539.30,4232539.30,'697','2022-05-04 14:08:51','533','2022-05-04 17:01:43',10,0),('1','122',257703,'MORNING','2022-05-04','2022-05-04 20:01:27','2022-05-05 20:01:27','697',2103481.50,2103481.50,'697','2022-05-04 20:05:39','533','2022-05-05 12:55:53',10,0),('1','122',257704,'AFTERNOON','2022-05-04','2022-05-05 13:54:17','2022-05-06 13:54:17','697',5015469.70,5015469.70,'697','2022-05-06 09:44:11','533','2022-05-06 18:13:21',10,0),('1','122',257705,'MORNING','2022-05-05','2022-05-07 11:32:01','2022-05-08 11:32:01','697',9276899.35,9276899.35,'697','2022-05-07 11:44:00','533','2022-05-07 12:39:20',10,0),('1','122',257706,'AFTERNOON','2022-05-05','2022-05-07 13:19:02','2022-05-08 13:19:02','697',5005455.50,5005455.50,'697','2022-05-07 13:35:11','533','2022-05-07 13:56:07',10,0),('1','122',257707,'MORNING','2022-05-06','2022-05-07 13:57:09','2022-05-08 13:57:09','697',3353860.40,3353860.40,'697','2022-05-07 14:05:06','533','2022-05-07 18:14:02',10,0),('1','122',257708,'AFTERNOON','2022-05-06','2022-05-07 18:34:31','2022-05-08 18:34:31','697',5405219.50,5405219.50,'697','2022-05-07 18:40:16','533','2022-05-08 07:39:55',10,0),('1','122',257709,'MORNING','2022-05-07','2022-05-08 08:24:13','2022-05-09 08:24:13','697',3920349.10,3920349.10,'697','2022-05-08 08:29:41','533','2022-05-08 09:28:38',10,0),('1','122',257710,'AFTERNOON','2022-05-07','2022-05-08 09:34:17','2022-05-09 09:34:17','697',3262294.35,3262294.35,'697','2022-05-08 09:43:50','533','2022-05-08 20:47:54',10,0),('1','122',257711,'MORNING & AFTERNOON','2022-05-08','2022-05-09 10:35:29','2022-05-10 10:35:29','697',4257215.80,4257215.80,'697','2022-05-09 10:44:54','533','2022-05-09 13:11:11',10,0),('1','122',257712,'MORNING','2022-05-09','2022-05-09 15:58:13','2022-05-10 15:58:13','697',1038273.10,1038273.10,'697','2022-05-09 16:02:17','533','2022-05-10 12:46:15',10,0),('1','122',257713,'AFTERNOON','2022-05-09','2022-05-10 13:23:09','2022-05-11 13:23:09','697',4649351.05,4649351.05,'697','2022-05-10 13:38:01','533','2022-05-10 18:35:35',10,0),('1','122',257714,'MORNING','2022-05-10','2022-05-10 19:23:10','2022-05-11 19:23:10','697',1585692.30,1585692.30,'697','2022-05-10 19:27:58','533','2022-05-11 15:52:33',10,0),('1','122',257715,'AFTERNOON','2022-05-10','2022-05-11 15:57:45','2022-05-12 15:57:45','697',5417402.95,5417402.95,'697','2022-05-11 16:17:42','533','2022-05-11 18:23:22',10,0),('1','122',257716,'MORNING','2022-05-11','2022-05-11 18:34:50','2022-05-12 18:34:50','697',3511660.25,3511660.25,'697','2022-05-11 18:43:41','533','2022-05-12 13:50:53',10,0),('1','122',257717,'AFTERNOON','2022-05-11','2022-05-12 15:36:07','2022-05-13 15:36:07','697',6741121.25,6741121.25,'697','2022-05-12 15:49:26','533','2022-05-12 16:38:35',10,0),('1','122',257718,'MORNING','2022-05-12','2022-05-12 18:00:50','2022-05-13 18:00:50','697',3474006.00,3474006.00,'697','2022-05-13 11:35:18','533','2022-05-14 14:54:27',10,0),('1','122',257719,'AFTERNOON','2022-05-12','2022-05-14 16:23:17','2022-05-15 16:23:17','697',5738344.70,5738344.70,'697','2022-05-14 16:40:43','533','2022-05-14 16:56:15',10,0),('1','122',257720,'MORNING','2022-05-13','2022-05-14 17:03:21','2022-05-15 17:03:21','697',5547827.45,5547827.45,'697','2022-05-14 17:31:45','533','2022-05-15 13:47:37',10,0),('1','122',257721,'AFTERNOON','2022-05-13','2022-05-15 15:04:31','2022-05-16 15:04:31','697',7215367.95,7215367.95,'697','2022-05-15 15:11:14','533','2022-05-15 17:10:29',10,0),('1','122',257722,'MORNING','2022-05-14','2022-05-15 18:05:26','2022-05-16 18:05:26','697',3698122.15,3698122.15,'697','2022-05-15 18:20:43','533','2022-05-15 19:42:24',10,0),('1','122',257723,'AFTERNOON','2022-05-14','2022-05-15 19:50:11','2022-05-16 19:50:11','697',3570268.35,3570268.35,'697','2022-05-15 22:34:37','533','2022-05-16 11:10:01',10,0),('1','122',257724,'MORNING','2022-05-15','2022-05-16 14:00:12','2022-05-17 14:00:12','697',4280128.05,4280128.05,'697','2022-05-16 17:48:18','533','2022-05-16 18:14:47',10,0),('1','122',257725,'AFTERNOON','2022-05-15','2022-05-16 18:24:42','2022-05-17 18:24:42','697',3871911.20,3871911.20,'697','2022-05-16 19:06:45','533','2022-05-17 11:32:02',10,0),('1','122',257726,'MORNING','2022-05-16','2022-05-17 14:11:14','2022-05-18 14:11:14','697',3577077.57,3577077.57,'697','2022-05-17 14:22:07','533','2022-05-17 17:32:41',10,0),('1','122',257727,'AFTERNOON','2022-05-16','2022-05-17 17:34:14','2022-05-18 17:34:14','697',4520816.85,4520816.85,'697','2022-05-17 17:49:39','533','2022-05-17 18:45:54',10,0),('1','122',257728,'MORNING','2022-05-17','2022-05-17 22:19:19','2022-05-18 22:19:19','697',4676979.45,4676979.45,'697','2022-05-17 22:32:26','533','2022-05-18 16:28:11',10,0),('1','122',257729,'AFTERNOON','2022-05-17','2022-05-18 17:12:45','2022-05-19 17:12:45','697',5472076.50,5472076.50,'697','2022-05-18 17:29:31','533','2022-05-19 12:15:32',10,0),('1','122',257730,'MORNING','2022-05-18','2022-05-19 17:56:07','2022-05-20 17:56:07','697',4672958.25,4672958.25,'697','2022-05-19 18:06:09','533','2022-05-20 08:25:30',10,0),('1','122',257731,'AFTERNOON','2022-05-18','2022-05-20 08:29:19','2022-05-21 08:29:19','697',5538658.35,5538658.35,'697','2022-05-20 08:38:18','533','2022-05-20 08:55:38',10,0),('1','122',257732,'MORNING','2022-05-19','2022-05-20 09:06:35','2022-05-21 09:06:35','697',6751971.75,6751971.75,'697','2022-05-20 09:12:38','533','2022-05-20 13:19:30',10,0),('1','122',257733,'AFTERNOON','2022-05-19','2022-05-20 15:09:23','2022-05-21 15:09:23','697',3940482.15,3940482.15,'697','2022-05-20 15:24:56','533','2022-05-20 17:20:17',10,0),('1','122',257734,'MORNING','2022-05-20','2022-05-20 17:29:28','2022-05-21 17:29:28','697',4288896.15,4288896.15,'697','2022-05-20 17:37:53','533','2022-05-20 18:13:52',10,0),('1','122',257735,'AFTERNOON','2022-05-20','2022-05-21 10:51:21','2022-05-22 10:51:21','697',4322950.50,4322950.50,'697','2022-05-21 10:56:53','533','2022-05-21 15:19:24',10,0),('1','122',257736,'MORNING','2022-05-21','2022-05-21 15:59:31','2022-05-22 15:59:31','697',4027777.05,4027777.05,'697','2022-05-21 16:10:06','533','2022-05-21 17:23:53',10,0),('1','122',257737,'AFTERNOON','2022-05-21','2022-05-22 08:07:23','2022-05-23 08:07:23','697',2985260.85,2985260.85,'697','2022-05-22 08:14:57','533','2022-05-22 17:30:11',10,0),('1','122',257738,'MORNING','2022-05-22','2022-05-22 17:33:12','2022-05-23 17:33:12','697',2594085.45,2594085.45,'697','2022-05-22 17:45:41','533','2022-05-23 06:45:50',10,0),('1','122',257739,'AFTERNOON','2022-05-22','2022-05-23 10:49:28','2022-05-24 10:49:28','697',3706033.65,3706033.65,'697','2022-05-23 10:58:35','533','2022-05-23 11:30:36',10,0),('1','122',257740,'MORNING','2022-05-23','2022-05-23 17:30:11','2022-05-24 17:30:11','697',3674616.00,3674616.00,'697','2022-05-23 17:39:06','533','2022-05-24 11:02:11',10,0),('1','122',257741,'AFTERNOON','2022-05-23','2022-05-24 15:03:13','2022-05-25 15:03:13','697',4033723.65,4033723.65,'697','2022-05-24 16:42:41','533','2022-05-24 20:31:42',10,0),('1','122',257742,'MORNING & AFTERNOON','2022-05-24','2022-05-25 10:49:29','2022-05-26 10:49:29','697',5633431.65,5633431.65,'697','2022-05-25 10:59:36','533','2022-05-25 14:17:41',10,0),('1','122',257743,'MORNING','2022-05-25','2022-05-25 17:07:44','2022-05-26 17:07:44','697',4587174.90,4587174.90,'697','2022-05-25 17:14:53','533','2022-05-25 17:15:23',10,0),('1','122',257744,'AFTERNOON','2022-05-25','2022-05-25 23:11:02','2022-05-26 23:11:02','697',2243473.65,2243473.65,'697','2022-05-25 23:15:25','533','2022-05-26 13:42:25',10,0),('1','122',257745,'MORNING & AFTERNOON','2022-05-26','2022-05-26 22:43:24','2022-05-27 22:43:24','697',8402473.20,8402473.20,'697','2022-05-27 20:27:48','533','2022-05-28 11:26:51',10,0),('1','122',257746,'MORNING','2022-05-27','2022-05-28 14:47:27','2022-05-29 14:47:27','697',3960333.30,3960333.30,'697','2022-05-28 15:08:01','533','2022-05-28 17:11:03',10,0),('1','122',257747,'AFTERNOON','2022-05-27','2022-05-28 19:48:21','2022-05-29 19:48:21','697',5503086.60,5503086.60,'697','2022-05-28 20:33:36','533','2022-05-29 18:10:38',10,0),('1','122',257748,'MORNING','2022-05-28','2022-05-29 21:12:41','2022-05-30 21:12:41','697',4034700.45,4034700.45,'697','2022-05-29 21:35:33','533','2022-05-30 08:39:24',10,0),('1','122',257749,'AFTERNOON','2022-05-28','2022-05-30 09:48:48','2022-05-31 09:48:48','697',8339867.00,8339867.00,'697','2022-05-30 09:57:30','454','2022-05-30 10:58:15',10,0),('1','122',257750,'MORNING','2022-05-29','2022-05-30 12:07:43','2022-05-31 12:07:43','697',1543155.65,1543155.65,'697','2022-05-30 14:18:07','533','2022-05-30 15:46:36',10,0),('1','122',257751,'AFTERNOON','2022-05-29','2022-05-30 16:26:14','2022-05-31 16:26:14','697',6009188.00,6009188.00,'697','2022-05-30 17:49:50','533','2022-05-31 14:16:57',10,0),('1','122',257752,'MORNING','2022-05-30','2022-05-31 14:24:09','2022-06-01 14:24:09','697',4537941.00,4537941.00,'697','2022-05-31 14:29:53','533','2022-05-31 20:20:26',10,0),('1','122',257753,'AFTERNOON','2022-05-30','2022-05-31 20:55:59','2022-06-01 20:55:59','697',9284971.05,9284971.05,'697','2022-05-31 21:09:09','454','2022-06-01 16:58:09',10,0),('1','122',257754,'MORNING','2022-05-31','2022-06-01 17:04:20','2022-06-02 17:04:20','697',5996397.50,5996397.50,'697','2022-06-01 17:10:34','533','2022-06-01 17:21:51',10,0),('1','122',257755,'AFTERNOON','2022-05-31','2022-06-01 17:30:12','2022-06-02 17:30:12','697',8811890.60,8811890.60,'697','2022-06-01 17:46:21','533','2022-06-02 06:52:22',10,0),('1','122',257756,'MORNING','2022-06-01','2022-06-02 07:42:04','2022-06-03 07:42:04','697',5461561.56,5461561.56,'697','2022-06-02 07:48:07','533','2022-06-02 14:14:00',10,0),('1','122',257757,'AFTERNOON','2022-06-01','2022-06-02 14:31:46','2022-06-03 14:31:46','697',8048777.20,8048777.20,'697','2022-06-02 14:42:44','533','2022-06-02 22:44:59',10,0),('1','122',257758,'MORNING','2022-06-02','2022-06-03 07:44:59','2022-06-04 07:44:59','697',3649231.65,3649231.65,'697','2022-06-03 07:50:16','533','2022-06-03 15:12:36',10,0),('1','122',257759,'AFTERNOON','2022-06-02','2022-06-03 15:18:38','2022-06-04 15:18:38','697',8461356.65,8461356.65,'697','2022-06-03 15:43:20','533','2022-06-03 18:01:06',10,0),('1','122',257760,'MORNING','2022-06-03','2022-06-03 18:28:33','2022-06-04 18:28:33','697',5570464.60,5570464.60,'697','2022-06-03 18:37:03','533','2022-06-03 21:58:13',10,0),('1','122',257761,'AFTERNOON','2022-06-03','2022-06-04 08:20:56','2022-06-05 08:20:56','697',0.00,0.00,'697','2022-06-04 10:48:33','533','2022-06-04 11:02:47',10,0),('1','122',257762,'AFTERNOON','2022-06-03','2022-06-04 12:40:43','2022-06-05 12:40:43','697',6068481.65,6068481.65,'697','2022-06-04 12:49:39','533','2022-06-04 13:28:19',10,0),('1','122',257763,'MORNING','2022-06-04','2022-06-04 15:50:45','2022-06-05 15:50:45','697',3908164.70,3908164.70,'697','2022-06-04 15:59:12','533','2022-06-04 17:46:28',10,0),('1','122',257764,'AFTERNOON','2022-06-04','2022-06-05 10:45:39','2022-06-06 10:45:39','697',8267570.08,8267570.08,'697','2022-06-05 17:43:11','533','2022-06-06 09:55:39',10,0),('1','122',257765,'MORNING','2022-06-05','2022-06-06 11:04:41','2022-06-07 11:04:41','697',4106152.05,4106152.05,'697','2022-06-06 11:12:23','533','2022-06-06 19:25:38',10,0),('1','122',257766,'AFTERNOON','2022-06-05','2022-06-06 19:31:36','2022-06-07 19:31:36','697',4635726.70,4635726.70,'697','2022-06-06 19:36:13','533','2022-06-06 19:36:48',10,0),('1','122',257767,'MORNING','2022-06-06','2022-06-06 19:38:04','2022-06-07 19:38:04','697',7768824.80,7768824.80,'697','2022-06-06 19:48:52','533','2022-06-06 21:04:36',10,0),('1','122',257768,'AFTERNOON','2022-06-06','2022-06-07 12:04:41','2022-06-08 12:04:41','697',5253040.87,5253040.87,'697','2022-06-07 12:16:10','533','2022-06-07 12:24:42',10,0),('1','122',257769,'MORNING SHIFT','2022-06-07','2022-06-07 13:42:45','2022-06-08 13:42:45','454',12804231.00,12804231.00,'697','2022-06-07 18:17:35','533','2022-06-07 19:21:06',10,0),('1','122',257770,'AFTERNOON','2022-06-07','2022-06-08 07:18:13','2022-06-09 07:18:13','697',2831571.60,2831571.60,'697','2022-06-08 09:20:54','533','2022-06-08 11:05:51',10,0),('1','122',257771,'MORNING & AFTERNOON','2022-06-08','2022-06-09 07:59:18','2022-06-10 07:59:18','697',4629547.55,4629547.55,'697','2022-06-09 08:16:10','533','2022-06-09 10:25:09',10,0),('1','122',257772,'MORNING','2022-06-09','2022-06-09 18:45:29','2022-06-10 18:45:29','697',6698008.90,6698008.90,'697','2022-06-09 19:07:21','533','2022-06-09 20:11:08',10,0),('1','122',257773,'AFTERNOON','2022-06-09','2022-06-10 09:10:35','2022-06-11 09:10:35','697',6590037.75,6590037.75,'697','2022-06-10 09:27:45','533','2022-06-10 11:37:27',10,0),('1','122',257774,'MORNING','2022-06-10','2022-06-10 19:22:07','2022-06-11 19:22:07','697',6836171.75,6836171.75,'697','2022-06-10 19:34:29','533','2022-06-11 09:32:08',10,0),('1','122',257775,'AFTERNOON','2022-06-10','2022-06-11 09:47:31','2022-06-12 09:47:31','697',6752750.50,6752750.50,'697','2022-06-11 14:37:32','533','2022-06-11 14:50:59',10,0),('1','122',257776,'MORNING','2022-06-11','2022-06-11 18:33:30','2022-06-12 18:33:30','697',4565089.65,4565089.65,'697','2022-06-11 18:40:35','533','2022-06-12 15:03:37',10,0),('1','122',257777,'AFTERNOON','2022-06-11','2022-06-12 15:20:39','2022-06-13 15:20:39','697',6148615.64,6148615.64,'697','2022-06-12 15:45:11','533','2022-06-13 06:21:23',10,0),('1','122',257778,'MORNING','2022-06-12','2022-06-13 07:35:59','2022-06-14 07:35:59','697',4061504.20,4061504.20,'697','2022-06-13 07:39:58','533','2022-06-13 10:31:07',10,0),('1','122',257779,'AFTERNOON','2022-06-12','2022-06-13 11:37:33','2022-06-14 11:37:33','697',6554228.10,6554228.10,'697','2022-06-13 11:45:21','533','2022-06-13 11:53:06',10,0),('1','122',257780,'MORNING','2022-06-13','2022-06-13 17:38:44','2022-06-14 17:38:44','697',3463907.15,3463907.15,'697','2022-06-13 17:43:04','533','2022-06-13 19:59:22',10,0),('1','122',257781,'AFTERNOON','2022-06-13','2022-06-14 11:51:03','2022-06-15 11:51:03','697',3816144.95,3816144.95,'697','2022-06-14 12:04:45','454','2022-06-14 15:00:03',10,0),('1','122',257782,'MORNING','2022-06-14','2022-06-14 16:57:48','2022-06-15 16:57:48','697',5126844.75,5126844.75,'697','2022-06-14 17:12:07','533','2022-06-15 07:15:10',10,0),('1','122',257783,'AFTERNOON','2022-06-14','2022-06-15 08:03:59','2022-06-16 08:03:59','697',8702570.40,8702570.40,'697','2022-06-15 08:11:58','533','2022-06-15 14:40:17',10,0),('1','122',257784,'MORNING','2022-06-15','2022-06-15 15:23:30','2022-06-16 15:23:30','697',2123852.40,2123852.40,'697','2022-06-15 15:30:06','533','2022-06-15 19:55:29',10,0),('1','122',257785,'AFTERNOON','2022-06-15','2022-06-16 08:55:19','2022-06-17 08:55:19','697',6408491.30,6408491.30,'697','2022-06-16 09:21:53','533','2022-06-16 09:26:40',10,0),('1','122',257786,'MORNING','2022-06-16','2022-06-16 17:25:55','2022-06-17 17:25:55','697',3331331.65,3331331.65,'697','2022-06-16 17:34:27','533','2022-06-17 09:18:28',10,0),('1','122',257787,'AFTERNOON','2022-06-16','2022-06-17 09:43:22','2022-06-18 09:43:22','697',6659124.10,6659124.10,'697','2022-06-17 09:53:36','454','2022-06-17 11:04:52',10,0),('1','122',257788,'MORNING','2022-06-17','2022-06-17 17:06:13','2022-06-18 17:06:13','697',4565893.45,4565893.45,'697','2022-06-17 17:41:31','533','2022-06-18 09:32:27',10,0),('1','122',257789,'AFTERNOON','2022-06-17','2022-06-18 09:38:52','2022-06-19 09:38:52','697',4935938.50,4935938.50,'697','2022-06-18 10:01:15','533','2022-06-18 17:54:45',10,0),('1','122',257790,'MORNING','2022-06-18','2022-06-18 17:58:00','2022-06-19 17:58:00','697',5244174.30,5244174.30,'697','2022-06-18 18:17:48','533','2022-06-19 09:26:50',10,0),('1','122',257791,'AFTERNOON','2022-06-18','2022-06-19 09:29:24','2022-06-20 09:29:24','697',5618213.30,5618213.30,'697','2022-06-19 09:47:25','533','2022-06-19 13:39:37',10,0),('1','122',257792,'MORNING','2022-06-19','2022-06-19 18:42:00','2022-06-20 18:42:00','697',2832202.55,2832202.55,'697','2022-06-20 09:32:14','533','2022-06-20 09:35:20',10,0),('1','122',257793,'AFTERNOON','2022-06-19','2022-06-20 09:45:07','2022-06-21 09:45:07','697',6163744.15,6163744.15,'697','2022-06-20 13:11:01','454','2022-06-20 15:02:52',10,0),('1','122',257794,'MORNING','2022-06-20','2022-06-20 20:18:59','2022-06-21 20:18:59','697',7687598.70,7687598.70,'697','2022-06-20 20:29:15','533','2022-06-21 10:50:02',10,0),('1','122',257795,'AFTERNOON','2022-06-20','2022-06-21 11:11:05','2022-06-22 11:11:05','697',7161858.90,7161858.90,'697','2022-06-21 15:20:29','533','2022-06-21 19:52:19',10,0),('1','122',257796,'MORNING','2022-06-21','2022-06-21 19:57:24','2022-06-22 19:57:24','697',7959188.50,7959188.50,'697','2022-06-21 20:25:25','533','2022-06-22 12:11:51',10,0),('1','122',257797,'AFTERNOON','2022-06-21','2022-06-22 12:16:08','2022-06-23 12:16:08','697',6234364.35,6234364.35,'697','2022-06-22 12:48:20','533','2022-06-22 14:42:47',10,0),('1','122',257798,'MORNING','2022-06-22','2022-06-22 17:16:11','2022-06-23 17:16:11','697',7623652.05,7623652.05,'697','2022-06-22 17:36:41','533','2022-06-23 09:51:34',10,0),('1','122',257799,'AFTERNOON','2022-06-22','2022-06-23 10:44:44','2022-06-24 10:44:44','697',6679439.40,6679439.40,'697','2022-06-23 11:12:45','454','2022-06-23 11:54:30',10,0),('1','122',257800,'MORNING','2022-06-23','2022-06-23 18:16:33','2022-06-24 18:16:33','697',4921208.75,4921208.75,'697','2022-06-23 19:20:21','533','2022-06-23 21:41:35',10,0),('1','122',257801,'AFTERNOON','2022-06-23','2022-06-24 09:54:44','2022-06-25 09:54:44','697',6099304.55,6099304.55,'697','2022-06-24 10:12:58','533','2022-06-24 12:42:25',10,0),('1','122',257802,'MORNING','2022-06-24','2022-06-24 20:16:17','2022-06-25 20:16:17','697',4199255.60,4199255.60,'697','2022-06-24 20:27:44','533','2022-06-25 08:25:30',10,0),('1','122',257803,'AFTERNOON','2022-06-24','2022-06-25 12:07:57','2022-06-26 12:07:57','697',6095737.30,6095737.30,'697','2022-06-25 12:23:06','533','2022-06-25 18:52:01',10,0),('1','122',257804,'MORNING','2022-06-25','2022-06-25 19:37:49','2022-06-26 19:37:49','697',5589741.40,5589741.40,'697','2022-06-25 19:52:05','533','2022-06-26 11:44:35',10,0),('1','122',257805,'AFTERNOON','2022-06-25','2022-06-26 12:18:04','2022-06-27 12:18:04','697',6479457.60,6479457.60,'697','2022-06-26 13:05:55','533','2022-06-26 18:35:45',10,0),('1','122',257806,'MORNING','2022-06-26','2022-06-26 18:46:39','2022-06-27 18:46:39','697',4094572.20,4094572.20,'697','2022-06-26 18:55:16','533','2022-06-27 08:03:16',10,0),('1','122',257807,'AFTERNOON','2022-06-26','2022-06-27 09:04:03','2022-06-28 09:04:03','697',5764182.55,5764182.55,'697','2022-06-27 09:46:50','533','2022-06-27 20:04:18',10,0),('1','122',257808,'MORNING','2022-06-27','2022-06-27 20:05:46','2022-06-28 20:05:46','697',7410860.15,7410860.15,'697','2022-06-27 20:16:55','533','2022-06-28 09:20:34',10,0),('1','122',257809,'AFTERNOON','2022-06-27','2022-06-28 09:45:39','2022-06-29 09:45:39','697',6262631.20,6262631.20,'697','2022-06-28 09:59:51','533','2022-06-28 11:29:15',10,0),('1','122',257810,'MORNING','2022-06-28','2022-06-28 23:41:05','2022-06-29 23:41:05','697',7754382.46,7754382.46,'697','2022-06-28 23:52:38','533','2022-06-29 12:29:49',10,0),('1','122',257811,'AFTERNOON','2022-06-28','2022-06-29 12:35:20','2022-06-30 12:35:20','697',7364869.70,7364869.70,'697','2022-06-29 13:51:17','533','2022-06-29 15:00:26',10,0),('1','122',257812,'MORNING','2022-06-29','2022-06-29 18:47:27','2022-06-30 18:47:27','697',5565229.00,5565229.00,'697','2022-06-29 18:58:44','533','2022-06-30 10:07:10',10,0),('1','122',257813,'AFTERNOON','2022-06-29','2022-06-30 10:11:12','2022-07-01 10:11:12','697',7079026.10,7079026.10,'697','2022-06-30 10:27:44','533','2022-06-30 11:34:28',10,0),('1','122',257814,'MORNING','2022-06-30','2022-06-30 15:41:21','2022-07-01 15:41:21','697',6712802.50,6712802.50,'697','2022-06-30 15:53:08','533','2022-06-30 21:26:38',10,0),('1','122',257815,'AFTERNOON','2022-06-30','2022-07-01 15:37:34','2022-07-02 15:37:34','697',8002328.50,8002328.50,'697','2022-07-01 16:15:59','533','2022-07-01 21:05:15',10,0),('1','122',257816,'MORNING','2022-07-01','2022-07-01 21:55:29','2022-07-02 21:55:29','697',4124438.35,4124438.35,'697','2022-07-02 13:45:22','533','2022-07-02 18:21:41',10,0),('1','122',257817,'AFTERNOON','2022-07-01','2022-07-02 18:38:33','2022-07-03 18:38:33','697',8123045.00,8123045.00,'697','2022-07-02 18:53:49','533','2022-07-02 19:02:55',10,0),('1','122',257818,'MORNING','2022-07-02','2022-07-02 19:19:51','2022-07-03 19:19:51','697',4111780.45,4111780.45,'697','2022-07-02 19:24:55','533','2022-07-03 14:21:54',10,0),('1','122',257819,'AFTERNOON','2022-07-02','2022-07-03 15:48:02','2022-07-04 15:48:02','697',7483964.55,7483964.55,'697','2022-07-03 16:00:05','533','2022-07-03 20:10:52',10,0),('1','122',257820,'MORNING','2022-07-03','2022-07-03 20:36:32','2022-07-04 20:36:32','697',4448674.80,4448674.80,'697','2022-07-04 09:54:56','533','2022-07-04 16:34:11',10,0),('1','122',257821,'AFTERNOON ','2022-07-03','2022-07-04 16:55:29','2022-07-05 16:55:29','697',6156780.50,6156780.50,'697','2022-07-04 17:13:41','533','2022-07-04 22:23:25',10,0),('1','122',257822,'MORNING','2022-07-04','2022-07-04 23:52:26','2022-07-05 23:52:26','697',4400041.95,4400041.95,'697','2022-07-05 00:06:15','533','2022-07-05 13:53:41',10,0),('1','122',257823,'AFTERNOON','2022-07-04','2022-07-05 14:54:25','2022-07-06 14:54:25','697',4267789.05,4267789.05,'697','2022-07-05 15:08:12','533','2022-07-05 17:11:23',10,0),('1','122',257824,'MORNING','2022-07-05','2022-07-05 22:49:56','2022-07-06 22:49:56','697',6162689.00,6162689.00,'697','2022-07-06 12:02:03','533','2022-07-06 16:30:47',10,0),('1','122',257825,'AFTERNOON','2022-07-05','2022-07-06 16:45:58','2022-07-07 16:45:58','697',7599469.65,7599469.65,'697','2022-07-06 17:16:54','533','2022-07-06 19:37:12',10,0),('1','122',257826,'MORNING','2022-07-06','2022-07-07 13:32:39','2022-07-08 13:32:39','697',7026569.60,7026569.60,'697','2022-07-07 13:42:43','533','2022-07-07 15:37:35',10,0),('1','122',257827,'AFTERNOON ','2022-07-06','2022-07-07 17:46:09','2022-07-08 17:46:09','697',8112179.10,8112179.10,'697','2022-07-07 18:35:30','533','2022-07-07 19:11:00',10,0),('1','122',257828,'MORNING','2022-07-07','2022-07-07 19:37:58','2022-07-08 19:37:58','697',5333723.16,5333723.16,'697','2022-07-07 20:18:04','533','2022-07-08 12:03:37',10,0),('1','122',257829,'AFTERNOON','2022-07-07','2022-07-08 12:49:56','2022-07-09 12:49:56','697',4130090.25,4130090.25,'697','2022-07-08 15:34:01','533','2022-07-09 08:08:17',10,0),('1','122',257830,'MORNING','2022-07-08','2022-07-09 11:02:12','2022-07-10 11:02:12','697',3161075.55,3161075.55,'697','2022-07-09 11:22:15','533','2022-07-09 16:32:49',10,0),('1','122',257831,'AFTERNOON','2022-07-08','2022-07-09 21:18:50','2022-07-10 21:18:50','697',5887199.55,5887199.55,'697','2022-07-09 21:53:05','533','2022-07-10 13:12:21',10,0),('1','122',257832,'MORNING & AFTERNOON','2022-07-09','2022-07-10 14:28:57','2022-07-11 14:28:57','697',5500162.65,5500162.65,'697','2022-07-10 14:52:50','533','2022-07-10 14:59:14',10,0),('1','122',257833,'MORNING','2022-07-10','2022-07-10 19:30:28','2022-07-11 19:30:28','697',5212969.85,5212969.85,'697','2022-07-11 09:59:26','533','2022-07-11 14:57:20',10,0),('1','122',257834,'AFTERNOON','2022-07-10','2022-07-11 17:33:39','2022-07-12 17:33:39','697',5631479.00,5631479.00,'697','2022-07-11 19:24:46','533','2022-07-11 20:15:42',10,0),('1','122',257835,'MORNING','2022-07-11','2022-07-11 22:22:31','2022-07-12 22:22:31','697',3627267.80,3627267.80,'697','2022-07-11 22:32:10','533','2022-07-12 10:46:30',10,0),('1','122',257836,'AFTERNOON','2022-07-11','2022-07-12 13:48:20','2022-07-13 13:48:20','697',5821817.95,5821817.95,'697','2022-07-12 13:59:21','533','2022-07-13 09:28:22',10,0),('1','122',257837,'MORNING','2022-07-12','2022-07-13 09:31:43','2022-07-14 09:31:43','697',4870463.20,4870463.20,'697','2022-07-13 09:35:48','533','2022-07-13 09:59:17',10,0),('1','122',257838,'AFTERNOON','2022-07-12','2022-07-13 10:04:07','2022-07-14 10:04:07','697',4649256.90,4649256.90,'697','2022-07-13 10:17:46','454','2022-07-13 12:44:43',10,0),('1','122',257839,'MORNING','2022-07-13','2022-07-13 16:07:17','2022-07-14 16:07:17','697',4642153.60,4642153.60,'697','2022-07-13 17:17:24','533','2022-07-14 08:32:11',10,0),('1','122',257840,'AFTERNOON','2022-07-13','2022-07-14 16:20:17','2022-07-15 16:20:17','697',5726183.20,5726183.20,'697','2022-07-14 16:32:54','533','2022-07-14 17:40:49',10,0),('1','122',257841,'MORNING','2022-07-14','2022-07-14 17:41:31','2022-07-15 17:41:31','697',7585823.70,7585823.70,'697','2022-07-14 17:46:57','533','2022-07-15 11:42:27',10,0),('1','122',257842,'AFTERNOON','2022-07-14','2022-07-15 14:43:45','2022-07-16 14:43:45','697',3508382.45,3508382.45,'697','2022-07-15 18:40:23','533','2022-07-15 19:06:27',10,0),('1','122',257843,'MORNING','2022-07-15','2022-07-15 19:11:24','2022-07-16 19:11:24','697',4421414.05,4421414.05,'697','2022-07-15 20:04:33','533','2022-07-16 13:06:45',10,0),('1','122',257844,'AFTERNOON','2022-07-15','2022-07-16 13:12:32','2022-07-17 13:12:32','697',6814273.20,6814273.20,'697','2022-07-16 13:27:00','533','2022-07-17 07:38:36',10,0),('1','122',257845,'MORNING','2022-07-16','2022-07-17 08:21:23','2022-07-18 08:21:23','697',3640047.70,3640047.70,'697','2022-07-17 08:26:31','533','2022-07-17 16:31:20',10,0),('1','122',257846,'AFTERNOON','2022-07-16','2022-07-17 17:36:15','2022-07-18 17:36:15','697',6523830.71,6523830.71,'697','2022-07-17 17:46:35','533','2022-07-17 18:08:53',10,0),('1','122',257847,'MORNING','2022-07-17','2022-07-17 19:35:14','2022-07-18 19:35:14','697',3310784.10,3310784.10,'697','2022-07-17 19:53:15','533','2022-07-18 11:19:24',10,0),('1','122',257848,'AFTERNOON','2022-07-17','2022-07-18 11:48:45','2022-07-19 11:48:45','697',3666843.42,3666843.42,'697','2022-07-18 12:07:50','533','2022-07-18 17:39:38',10,0),('1','122',257849,'MORNING','2022-07-18','2022-07-18 19:05:26','2022-07-19 19:05:26','697',5333119.45,5333119.45,'697','2022-07-18 19:12:21','533','2022-07-19 11:18:35',10,0),('1','122',257850,'AFTERNOON ','2022-07-18','2022-07-19 15:08:26','2022-07-20 15:08:26','697',3857948.20,3857948.20,'697','2022-07-19 16:06:17','533','2022-07-19 16:22:31',10,0),('1','122',257851,'MORNING','2022-07-19','2022-07-19 16:32:54','2022-07-20 16:32:54','697',3915465.39,3915465.39,'697','2022-07-19 16:47:24','454','2022-07-20 10:12:54',10,0),('1','122',257852,'AFTERNOON','2022-07-19','2022-07-20 11:45:58','2022-07-21 11:45:58','697',4062397.85,4062397.85,'697','2022-07-20 12:06:13','533','2022-07-20 14:31:59',10,0),('1','122',257853,'MORNING & AFTERNOON','2022-07-20','2022-07-20 22:59:48','2022-07-21 22:59:48','697',5518679.95,5518679.95,'697','2022-07-21 09:30:22','533','2022-07-21 15:15:53',10,0),('1','122',257854,'MORNING','2022-07-21','2022-07-21 20:12:01','2022-07-22 20:12:01','697',7473940.35,7473940.35,'697','2022-07-21 20:29:13','533','2022-07-22 10:03:36',10,0),('1','122',257855,'AFTERNOON','2022-07-21','2022-07-22 10:10:43','2022-07-23 10:10:43','697',3744406.65,3744406.65,'697','2022-07-22 10:18:23','454','2022-07-22 12:13:09',10,0),('1','122',257856,'MORNING','2022-07-22','2022-07-22 17:40:36','2022-07-23 17:40:36','697',2448721.25,2448721.25,'697','2022-07-22 17:45:11','533','2022-07-23 10:41:38',10,0),('1','122',257857,'AFTERNOON','2022-07-22','2022-07-23 10:42:49','2022-07-24 10:42:49','697',4613661.70,4613661.70,'697','2022-07-23 11:03:06','533','2022-07-23 13:21:49',10,0),('1','122',257858,'MORNING','2022-07-23','2022-07-23 16:23:02','2022-07-24 16:23:02','697',5436428.75,5436428.75,'697','2022-07-23 16:36:49','533','2022-07-24 09:38:32',10,0),('1','122',257859,'AFTERNOON','2022-07-23','2022-07-24 10:26:11','2022-07-25 10:26:11','697',6696897.95,6696897.95,'697','2022-07-24 10:54:52','533','2022-07-24 12:34:58',10,0),('1','122',257860,'MORNING & AFTERNOON','2022-07-24','2022-07-25 09:04:54','2022-07-26 09:04:54','697',8725549.40,8725549.40,'697','2022-07-25 16:58:52','533','2022-07-25 17:42:52',10,0),('1','122',257861,'MORNING','2022-07-25','2022-07-25 20:27:48','2022-07-26 20:27:48','697',5106464.75,5106464.75,'697','2022-07-25 20:33:32','533','2022-07-26 09:50:07',10,0),('1','122',257862,'AFTERNOON','2022-07-25','2022-07-26 13:40:13','2022-07-27 13:40:13','697',8690327.50,8690327.50,'697','2022-07-26 13:52:58','533','2022-07-27 11:06:21',10,0),('1','122',257863,'MORNING','2022-07-26','2022-07-27 12:53:30','2022-07-28 12:53:30','697',4655003.20,4655003.20,'697','2022-07-27 15:02:32','533','2022-07-27 15:06:47',10,0),('1','122',257864,'AFTERNOON','2022-07-26','2022-07-27 15:22:02','2022-07-28 15:22:02','697',17614526.75,17614526.75,'697','2022-07-27 20:03:18','533','2022-07-28 11:19:40',10,0),('1','122',257865,'MORNING','2022-07-27','2022-07-28 12:31:14','2022-07-29 12:31:14','697',6573977.70,6573977.70,'697','2022-07-28 16:49:09','533','2022-07-28 16:52:15',10,0),('1','122',257866,'AFTERNOON','2022-07-27','2022-07-28 16:56:24','2022-07-29 16:56:24','697',5937758.55,5937758.55,'697','2022-07-28 18:18:08','533','2022-07-29 08:54:14',10,0),('1','122',257867,'MORNING','2022-07-28','2022-07-29 10:40:36','2022-07-30 10:40:36','697',3081779.60,3081779.60,'697','2022-07-29 11:00:06','533','2022-07-29 14:51:10',10,0),('1','122',257868,'AFTERNOON','2022-07-28','2022-07-29 16:22:04','2022-07-30 16:22:04','697',5116957.15,5116957.15,'697','2022-07-29 16:30:20','533','2022-07-30 11:23:27',10,0),('1','122',257869,'MORNING','2022-07-29','2022-07-30 12:30:25','2022-07-31 12:30:25','697',6292139.10,6292139.10,'697','2022-07-30 12:40:06','533','2022-07-30 12:47:55',10,0),('1','122',257870,'AFTERNOON','2022-07-29','2022-07-31 12:21:25','2022-08-01 12:21:25','697',5293289.65,5293289.65,'697','2022-07-31 12:34:48','533','2022-07-31 15:51:00',10,0),('1','122',257871,'MORNING','2022-07-30','2022-07-31 16:33:04','2022-08-01 16:33:04','697',4248794.60,4248794.60,'697','2022-07-31 16:39:36','533','2022-07-31 19:29:10',10,0),('1','122',257872,'AFTERNOON','2022-07-30','2022-07-31 20:02:01','2022-08-01 20:02:01','697',3649350.20,3649350.20,'697','2022-07-31 20:16:49','533','2022-08-01 09:50:16',10,0),('1','122',257873,'MORNING','2022-07-31','2022-08-01 11:22:02','2022-08-02 11:22:02','697',2441720.85,2441720.85,'697','2022-08-01 11:44:20','533','2022-08-01 12:06:59',10,0),('1','122',257874,'AFTERNOON','2022-07-31','2022-08-01 12:28:37','2022-08-02 12:28:37','697',1968779.70,1968779.70,'697','2022-08-01 12:51:03','533','2022-08-01 20:32:23',10,0),('1','122',257875,'MORNING','2022-08-01','2022-08-01 21:10:34','2022-08-02 21:10:34','697',3772339.10,3772339.10,'697','2022-08-01 21:27:03','533','2022-08-02 12:40:50',10,0),('1','122',257876,'AFTERNOON','2022-08-01','2022-08-02 15:07:38','2022-08-03 15:07:38','697',2691908.25,2691908.25,'697','2022-08-02 20:27:57','533','2022-08-03 12:39:14',10,0),('1','122',257877,'MORNING','2022-08-02','2022-08-03 13:49:42','2022-08-04 13:49:42','697',1304745.85,1304745.85,'697','2022-08-03 14:09:19','533','2022-08-03 16:23:29',10,0),('1','122',257878,'AFTERNOON','2022-08-02','2022-08-03 18:53:36','2022-08-04 18:53:36','697',6885081.80,6885081.80,'697','2022-08-03 20:51:24','533','2022-08-04 10:35:11',10,0),('1','122',257879,'MORNING SHIFT','2022-08-03','2022-08-04 15:09:28','2022-08-05 15:09:28','697',3992935.65,3992935.65,'697','2022-08-04 18:13:18','533','2022-08-04 18:18:03',10,0),('1','122',257880,'AFTERNOON','2022-08-03','2022-08-04 18:51:46','2022-08-05 18:51:46','697',4431468.50,4431468.50,'697','2022-08-04 19:00:48','533','2022-08-05 16:37:06',10,0),('1','122',257881,'MORNING','2022-08-04','2022-08-05 18:03:30','2022-08-06 18:03:30','697',5687328.60,5687328.60,'697','2022-08-05 19:18:36','533','2022-08-05 19:29:39',10,0),('1','122',257882,'AFTERNOON','2022-08-04','2022-08-05 19:31:03','2022-08-06 19:31:03','697',10423047.55,10423047.55,'697','2022-08-05 19:47:27','533','2022-08-05 21:16:12',10,0),('1','122',257883,'MORNING','2022-08-05','2022-08-06 12:48:25','2022-08-07 12:48:25','697',6775739.25,6775739.25,'697','2022-08-06 13:09:31','533','2022-08-06 14:24:28',10,0),('1','122',257884,'AFTERNOON','2022-08-05','2022-08-06 17:22:38','2022-08-07 17:22:38','697',6312314.30,6312314.30,'697','2022-08-06 17:30:58','533','2022-08-07 15:10:46',10,0),('1','122',257885,'MORNING','2022-08-06','2022-08-07 15:24:15','2022-08-08 15:24:15','697',5473713.80,5473713.80,'697','2022-08-07 15:32:01','533','2022-08-07 19:23:01',10,0),('1','122',257886,'AFTERNOON','2022-08-06','2022-08-07 19:23:56','2022-08-08 19:23:56','697',6740615.45,6740615.45,'697','2022-08-07 19:28:19','533','2022-08-08 10:14:20',10,0),('1','122',257887,'MORNING','2022-08-07','2022-08-08 10:26:12','2022-08-09 10:26:12','697',3372635.00,3372635.00,'697','2022-08-08 10:32:58','454','2022-08-08 13:40:19',10,0),('1','122',257888,'AFTERNOON','2022-08-07','2022-08-08 17:11:03','2022-08-09 17:11:03','697',5607259.05,5607259.05,'697','2022-08-08 17:25:34','533','2022-08-08 18:28:07',10,0),('1','122',257889,'MORNING','2022-08-08','2022-08-08 19:34:26','2022-08-09 19:34:26','697',5929509.45,5929509.45,'697','2022-08-08 19:49:17','533','2022-08-09 15:53:24',10,0),('1','122',257890,'AFTERNOON','2022-08-08','2022-08-09 16:33:34','2022-08-10 16:33:34','697',6395311.90,6395311.90,'697','2022-08-09 16:49:39','533','2022-08-09 17:25:36',10,0),('1','122',257891,'MORNING','2022-08-09','2022-08-09 19:33:41','2022-08-10 19:33:41','697',4584775.35,4584775.35,'697','2022-08-09 19:46:52','533','2022-08-10 11:18:09',10,0),('1','122',257892,'AFTERNOON','2022-08-09','2022-08-10 11:23:27','2022-08-11 11:23:27','697',4427502.20,4427502.20,'697','2022-08-10 11:36:12','533','2022-08-10 13:35:16',10,0),('1','122',257893,'MORNING','2022-08-10','2022-08-10 17:21:07','2022-08-11 17:21:07','697',4798474.25,4798474.25,'697','2022-08-10 17:31:30','533','2022-08-11 12:07:08',10,0),('1','122',257894,'AFTERNOON','2022-08-10','2022-08-11 12:24:53','2022-08-12 12:24:53','697',5863788.20,5863788.20,'697','2022-08-11 14:03:02','533','2022-08-11 14:39:59',10,0),('1','122',257895,'MORNING','2022-08-11','2022-08-11 17:59:46','2022-08-12 17:59:46','697',5466123.40,5466123.40,'697','2022-08-11 18:58:08','533','2022-08-12 10:36:56',10,0),('1','122',257896,'AFTERNOON','2022-08-11','2022-08-12 13:04:42','2022-08-13 13:04:42','697',6248874.05,6248874.05,'697','2022-08-12 13:23:15','533','2022-08-12 16:52:08',10,0),('1','122',257897,'MORNING','2022-08-12','2022-08-12 19:27:11','2022-08-13 19:27:11','697',4929574.80,4929574.80,'697','2022-08-12 19:42:28','533','2022-08-12 19:47:56',10,0),('1','122',257898,'AFTERNOON','2022-08-12','2022-08-13 13:35:24','2022-08-14 13:35:24','697',6512514.80,6512514.80,'697','2022-08-13 17:27:53','533','2022-08-13 19:16:14',10,0),('1','122',257899,'MORNING','2022-08-13','2022-08-13 20:07:58','2022-08-14 20:07:58','697',8561897.70,8561897.70,'697','2022-08-13 20:30:37','533','2022-08-14 15:33:28',10,0),('1','122',257900,'AFTERNOON ','2022-08-13','2022-08-14 16:05:03','2022-08-15 16:05:03','697',5873673.30,5873673.30,'697','2022-08-14 18:42:57','454','2022-08-15 12:08:47',10,0),('1','122',257901,'MORNING','2022-08-14','2022-08-15 12:59:32','2022-08-16 12:59:32','697',3000399.85,3000399.85,'697','2022-08-15 13:44:05','533','2022-08-15 15:55:26',10,0),('1','122',257902,'AFTERNOON','2022-08-14','2022-08-15 16:13:36','2022-08-16 16:13:36','697',4601730.15,4601730.15,'697','2022-08-15 16:25:32','533','2022-08-16 13:36:07',10,0),('1','122',257903,'MORNING','2022-08-15','2022-08-16 13:50:27','2022-08-17 13:50:27','697',4050859.20,4050859.20,'697','2022-08-16 14:01:30','533','2022-08-16 15:46:08',10,0),('1','122',257904,'AFTERNOON','2022-08-15','2022-08-16 19:16:19','2022-08-17 19:16:19','697',6469925.70,6469925.70,'697','2022-08-16 19:40:29','533','2022-08-17 09:58:41',10,0),('1','122',257905,'MORNING','2022-08-16','2022-08-17 14:58:58','2022-08-18 14:58:58','697',3108539.50,3108539.50,'697','2022-08-17 15:10:42','533','2022-08-17 15:27:19',10,0),('1','122',257906,'AFTERNOON','2022-08-16','2022-08-17 15:43:39','2022-08-18 15:43:39','697',4337481.10,4337481.10,'697','2022-08-17 15:53:04','533','2022-08-18 09:28:53',10,0),('1','122',257907,'MORNING','2022-08-17','2022-08-18 10:29:07','2022-08-19 10:29:07','697',5318145.05,5318145.05,'697','2022-08-18 10:36:38','533','2022-08-18 19:32:01',10,0),('1','122',257908,'AFTERNOON','2022-08-17','2022-08-18 19:33:15','2022-08-19 19:33:15','697',6394137.75,6394137.75,'697','2022-08-18 19:40:27','533','2022-08-19 08:03:22',10,0),('1','122',257909,'MORNING','2022-08-18','2022-08-19 09:18:53','2022-08-20 09:18:53','697',5660620.50,5660620.50,'697','2022-08-19 09:37:08','533','2022-08-19 15:20:57',10,0),('1','122',257910,'AFTERNOON','2022-08-18','2022-08-19 15:21:54','2022-08-20 15:21:54','697',7077429.75,7077429.75,'697','2022-08-20 13:05:58','533','2022-08-20 13:12:32',10,0),('1','122',257911,'MORNING ','2022-08-19','2022-08-20 13:31:17','2022-08-21 13:31:17','697',4745882.00,4745882.00,'697','2022-08-20 13:45:59','533','2022-08-20 20:20:50',10,0),('1','122',257912,'AFTERNOON','2022-08-19','2022-08-20 23:30:10','2022-08-21 23:30:10','697',14338426.75,14338426.75,'697','2022-08-20 23:35:00','533','2022-08-21 10:06:09',10,0),('1','122',257913,'MORNING','2022-08-20','2022-08-21 11:51:55','2022-08-22 11:51:55','697',4150756.50,4150756.50,'697','2022-08-21 12:03:26','533','2022-08-21 12:39:43',10,0),('1','122',257914,'AFTERNOON','2022-08-20','2022-08-21 12:56:10','2022-08-22 12:56:10','697',5366015.75,5366015.75,'697','2022-08-21 13:15:54','533','2022-08-21 13:20:01',10,0),('1','122',257915,'MORNING ','2022-08-21','2022-08-21 15:46:32','2022-08-22 15:46:32','697',3053824.75,3053824.75,'697','2022-08-21 15:53:07','533','2022-08-21 16:11:07',10,0),('1','122',257916,'AFTERNOON','2022-08-21','2022-08-22 13:46:00','2022-08-23 13:46:00','697',5731311.50,5731311.50,'697','2022-08-22 13:53:05','533','2022-08-22 20:28:01',10,0),('1','122',257917,'MORNING','2022-08-22','2022-08-23 11:16:37','2022-08-24 11:16:37','697',4409082.75,4409082.75,'697','2022-08-23 11:29:50','533','2022-08-23 18:28:35',10,0),('1','122',257918,'AFTERNOON','2022-08-22','2022-08-23 18:38:03','2022-08-24 18:38:03','697',6055582.75,6055582.75,'697','2022-08-23 18:47:21','533','2022-08-23 19:45:41',10,0),('1','122',257919,'MORNING','2022-08-23','2022-08-23 20:50:41','2022-08-24 20:50:41','697',3285783.25,3285783.25,'697','2022-08-23 20:56:17','533','2022-08-24 13:43:08',10,0),('1','122',257920,'AFTERNOON','2022-08-23','2022-08-24 14:14:52','2022-08-25 14:14:52','697',5873753.25,5873753.25,'697','2022-08-24 14:23:31','533','2022-08-25 09:21:50',10,0),('1','122',257921,'MORNING','2022-08-24','2022-08-25 09:33:40','2022-08-26 09:33:40','697',3994830.00,3994830.00,'697','2022-08-25 10:00:39','533','2022-08-25 12:38:32',10,0),('1','122',257922,'AFTERNOON','2022-08-24','2022-08-25 12:39:32','2022-08-26 12:39:32','697',4407203.50,4407203.50,'697','2022-08-25 12:47:56','533','2022-08-25 16:52:44',10,0),('1','122',257923,'MORNING','2022-08-25','2022-08-25 17:58:22','2022-08-26 17:58:22','697',3462989.25,3462989.25,'697','2022-08-25 18:12:22','533','2022-08-26 06:34:54',10,0),('1','122',257924,'AFTERNOON','2022-08-25','2022-08-26 14:07:48','2022-08-27 14:07:48','697',4949045.75,4949045.75,'697','2022-08-26 14:16:02','533','2022-08-26 16:15:06',10,0),('1','122',257925,'MORNING','2022-08-26','2022-08-26 16:55:59','2022-08-27 16:55:59','697',4168850.95,4168850.95,'697','2022-08-26 17:05:17','533','2022-08-27 11:24:46',10,0),('1','122',257926,'AFTERNOON','2022-08-26','2022-08-27 12:12:59','2022-08-28 12:12:59','697',4604512.25,4604512.25,'697','2022-08-27 12:19:56','533','2022-08-27 15:08:31',10,0),('1','122',257927,'MORNING','2022-08-27','2022-08-27 17:50:28','2022-08-28 17:50:28','697',3070337.25,3070337.25,'697','2022-08-27 17:55:51','533','2022-08-28 10:37:10',10,0),('1','122',257928,'AFTERNOON','2022-08-27','2022-08-28 15:45:21','2022-08-29 15:45:21','697',4113032.50,4113032.50,'697','2022-08-28 15:55:53','533','2022-08-28 16:39:41',10,0),('1','122',257929,'MORNING','2022-08-28','2022-08-29 08:38:52','2022-08-30 08:38:52','697',2424985.00,2424985.00,'697','2022-08-29 08:45:19','454','2022-08-29 11:55:48',10,0),('1','122',257930,'AFTERNOON','2022-08-28','2022-08-29 14:08:41','2022-08-30 14:08:41','697',4003214.75,4003214.75,'697','2022-08-29 21:10:29','533','2022-08-30 15:13:16',10,0),('1','122',257931,'MORNING ','2022-08-29','2022-08-30 15:25:44','2022-08-31 15:25:44','697',3258834.50,3258834.50,'697','2022-08-30 15:37:32','533','2022-08-30 16:04:23',10,0),('1','122',257932,'AFTERNOON','2022-08-29','2022-08-30 16:09:07','2022-08-31 16:09:07','697',6381911.75,6381911.75,'697','2022-08-30 16:18:22','533','2022-08-30 20:16:49',10,0),('1','122',257933,'MORNING','2022-08-30','2022-08-30 20:51:41','2022-08-31 20:51:41','697',2690635.00,2690635.00,'697','2022-08-30 20:57:43','533','2022-08-31 09:06:56',10,0),('1','122',257934,'AFTERNOON','2022-08-30','2022-08-31 14:06:34','2022-09-01 14:06:34','697',5696957.00,5696957.00,'697','2022-08-31 14:48:25','533','2022-08-31 18:29:08',10,0),('1','122',257935,'MORNING','2022-08-31','2022-08-31 21:48:41','2022-09-01 21:48:41','697',5499121.50,5499121.50,'697','2022-08-31 22:03:11','533','2022-09-01 12:08:16',10,0),('1','122',257936,'AFTERNOON ','2022-08-31','2022-09-01 13:16:30','2022-09-02 13:16:30','697',4615365.00,4615365.00,'697','2022-09-01 13:34:49','533','2022-09-01 19:59:25',10,0),('1','122',257937,'MORNING ','2022-09-01','2022-09-01 20:09:52','2022-09-02 20:09:52','697',3155220.75,3155220.75,'697','2022-09-01 20:51:19','533','2022-09-02 10:34:18',10,0),('1','122',257938,'AFTERNOON','2022-09-01','2022-09-02 14:47:29','2022-09-03 14:47:29','697',5255551.75,5255551.75,'697','2022-09-02 15:01:00','533','2022-09-02 19:36:32',10,0),('1','122',257939,'MORNING','2022-09-02','2022-09-02 20:38:48','2022-09-03 20:38:48','697',3568692.75,3568692.75,'697','2022-09-02 21:02:04','533','2022-09-03 15:49:21',10,0),('1','122',257940,'AFTERNOON','2022-09-02','2022-09-03 17:31:09','2022-09-04 17:31:09','697',4217581.00,4217581.00,'697','2022-09-03 17:44:58','533','2022-09-04 10:22:03',10,0),('1','122',257941,'MORNING ','2022-09-03','2022-09-04 11:30:44','2022-09-05 11:30:44','697',2940784.25,2940784.25,'697','2022-09-04 11:48:55','533','2022-09-04 16:15:16',10,0),('1','122',257942,'AFTERNOON ','2022-09-03','2022-09-04 17:25:27','2022-09-05 17:25:27','697',5347010.25,5347010.25,'697','2022-09-04 19:22:37','533','2022-09-04 21:26:34',10,0),('1','122',257943,'MORNING','2022-09-04','2022-09-04 21:28:45','2022-09-05 21:28:45','697',1914396.75,1914396.75,'697','2022-09-04 21:33:32','533','2022-09-05 12:44:32',10,0),('1','122',257944,'AFTERNOON','2022-09-04','2022-09-05 13:41:10','2022-09-06 13:41:10','697',3878300.00,3878300.00,'697','2022-09-05 14:01:52','533','2022-09-05 19:58:43',10,0),('1','122',257945,'MORNING ','2022-09-05','2022-09-05 21:47:40','2022-09-06 21:47:40','697',3531220.25,3531220.25,'697','2022-09-05 21:56:55','533','2022-09-06 10:24:24',10,0),('1','122',257946,'AFTERNOON','2022-09-05','2022-09-06 12:54:34','2022-09-07 12:54:34','697',3469781.25,3469781.25,'697','2022-09-06 13:18:45','533','2022-09-06 13:49:50',10,0),('1','122',257947,'MORNING','2022-09-06','2022-09-06 21:59:22','2022-09-07 21:59:22','697',5648983.75,5648983.75,'697','2022-09-06 22:17:45','533','2022-09-07 11:03:47',10,0),('1','122',257948,'AFTERNOON','2022-09-06','2022-09-07 14:18:45','2022-09-08 14:18:45','697',4548919.75,4548919.75,'697','2022-09-07 14:46:17','533','2022-09-07 20:12:00',10,0),('1','122',257949,'MORNING','2022-09-07','2022-09-07 20:17:16','2022-09-08 20:17:16','697',4647421.00,4647421.00,'697','2022-09-07 21:30:47','533','2022-09-08 14:29:29',10,0),('1','122',257950,'AFTERNOON','2022-09-07','2022-09-08 14:31:30','2022-09-09 14:31:30','697',5914617.25,5914617.25,'697','2022-09-08 14:39:59','533','2022-09-08 16:21:52',10,0),('1','122',257951,'MORNING','2022-09-08','2022-09-08 19:54:12','2022-09-09 19:54:12','697',3418296.75,3418296.75,'697','2022-09-08 20:00:06','533','2022-09-09 11:10:24',10,0),('1','122',257952,'AFTERNOON','2022-09-08','2022-09-09 14:16:08','2022-09-10 14:16:08','697',4982677.75,4982677.75,'697','2022-09-09 14:24:07','533','2022-09-09 14:27:34',10,0),('1','122',257953,'MORNING','2022-09-09','2022-09-09 16:59:03','2022-09-10 16:59:03','697',3223490.75,3223490.75,'697','2022-09-09 17:05:25','533','2022-09-10 13:14:42',10,0),('1','122',257954,'AFTERNOON','2022-09-09','2022-09-10 13:23:40','2022-09-11 13:23:40','697',6181286.00,6181286.00,'697','2022-09-10 13:32:16','533','2022-09-10 19:51:04',10,0),('1','122',257955,'MORNING','2022-09-10','2022-09-10 20:31:35','2022-09-11 20:31:35','697',3146112.00,3146112.00,'697','2022-09-10 20:38:19','533','2022-09-11 10:25:04',10,0),('1','122',257956,'AFTERNOON','2022-09-10','2022-09-11 13:32:22','2022-09-12 13:32:22','697',2948063.00,2948063.00,'697','2022-09-11 13:45:42','533','2022-09-11 13:58:37',10,0),('1','122',257957,'MORNING & AFTERNOON','2022-09-11','2022-09-12 09:34:44','2022-09-13 09:34:44','697',5737329.00,5737329.00,'697','2022-09-12 11:51:55','533','2022-09-12 14:03:48',10,0),('1','122',257958,'MORNING ','2022-09-12','2022-09-12 15:16:13','2022-09-13 15:16:13','697',4071143.50,4071143.50,'697','2022-09-12 15:38:34','533','2022-09-13 08:16:22',10,0),('1','122',257959,'AFTERNOON','2022-09-12','2022-09-13 12:25:05','2022-09-14 12:25:05','697',13777604.25,13777604.25,'697','2022-09-13 12:34:29','533','2022-09-13 13:00:33',10,0),('1','122',257960,'MORNING','2022-09-13','2022-09-13 18:52:12','2022-09-14 18:52:12','697',3401245.75,3401245.75,'697','2022-09-13 19:25:28','533','2022-09-14 10:32:33',10,0),('1','122',257961,'AFTERNOON','2022-09-13','2022-09-14 13:44:46','2022-09-15 13:44:46','697',5067520.00,5067520.00,'697','2022-09-14 13:56:24','533','2022-09-14 16:05:53',10,0),('1','122',257962,'MORNING','2022-09-14','2022-09-14 19:31:30','2022-09-15 19:31:30','697',3434848.00,3434848.00,'697','2022-09-14 19:47:57','533','2022-09-15 07:14:12',10,0),('1','122',257963,'AFTERNOON','2022-09-14','2022-09-15 12:39:43','2022-09-16 12:39:43','697',5960922.25,5960922.25,'697','2022-09-15 12:54:30','533','2022-09-15 14:39:42',10,0),('1','122',257964,'MORNING','2022-09-15','2022-09-15 20:17:41','2022-09-16 20:17:41','697',3380501.00,3380501.00,'697','2022-09-15 20:37:26','533','2022-09-16 11:58:47',10,0),('1','122',257965,'AFTERNOON','2022-09-15','2022-09-16 14:32:24','2022-09-17 14:32:24','697',5540959.50,5540959.50,'697','2022-09-16 15:18:13','454','2022-09-16 15:32:10',10,0),('1','122',257966,'MORNING','2022-09-16','2022-09-16 20:32:02','2022-09-17 20:32:02','697',3246046.00,3246046.00,'697','2022-09-16 20:38:31','533','2022-09-17 12:07:26',10,0),('1','122',257967,'AFTERNOON','2022-09-16','2022-09-17 14:25:44','2022-09-18 14:25:44','697',5783809.50,5783809.50,'697','2022-09-17 14:37:14','533','2022-09-17 19:48:59',10,0),('1','122',257968,'MORNING','2022-09-17','2022-09-17 20:58:46','2022-09-18 20:58:46','697',3048288.50,3048288.50,'697','2022-09-17 21:07:38','533','2022-09-18 09:56:13',10,0),('1','122',257969,'AFTERNOON','2022-09-17','2022-09-18 12:15:19','2022-09-19 12:15:19','697',5547320.25,5547320.25,'697','2022-09-18 12:46:47','533','2022-09-18 19:04:54',10,0),('1','122',257970,'MORNING','2022-09-18','2022-09-18 19:10:59','2022-09-19 19:10:59','697',1856810.25,1856810.25,'697','2022-09-18 19:24:44','533','2022-09-18 19:55:49',10,0),('1','122',257971,'AFTERNOON','2022-09-18','2022-09-19 13:33:57','2022-09-20 13:33:57','697',3291038.75,3291038.75,'697','2022-09-19 14:12:34','533','2022-09-19 15:11:37',10,0),('1','122',257972,'MORNING','2022-09-19','2022-09-19 15:35:47','2022-09-20 15:35:47','697',2518108.50,2518108.50,'697','2022-09-19 16:19:10','533','2022-09-20 07:18:53',10,0),('1','122',257973,'AFTERNOON','2022-09-19','2022-09-20 13:45:14','2022-09-21 13:45:14','697',6434761.25,6434761.25,'697','2022-09-20 14:09:19','533','2022-09-20 15:06:47',10,0),('1','122',257974,'MORNING','2022-09-20','2022-09-20 18:52:21','2022-09-21 18:52:21','697',3382169.75,3382169.75,'697','2022-09-20 20:50:49','533','2022-09-21 10:02:22',10,0),('1','122',257975,'AFTERNOON','2022-09-20','2022-09-21 12:53:21','2022-09-22 12:53:21','697',6359869.75,6359869.75,'697','2022-09-21 14:15:30','533','2022-09-21 20:36:49',10,0),('1','122',257976,'MORNING','2022-09-21','2022-09-21 20:43:24','2022-09-22 20:43:24','697',2590987.75,2590987.75,'697','2022-09-21 20:54:01','533','2022-09-22 12:36:56',10,0),('1','122',257977,'AFTERNOON ','2022-09-21','2022-09-22 12:49:43','2022-09-23 12:49:43','697',6609818.75,6609818.75,'697','2022-09-22 13:13:50','533','2022-09-22 15:40:52',10,0),('1','122',257978,'MORNING ','2022-09-22','2022-09-22 17:31:42','2022-09-23 17:31:42','697',4778026.00,4778026.00,'697','2022-09-22 17:47:16','533','2022-09-23 08:16:31',10,0),('1','122',257979,'AFTERNOON','2022-09-22','2022-09-23 15:11:02','2022-09-24 15:11:02','697',6115231.00,6115231.00,'697','2022-09-23 15:18:33','533','2022-09-23 16:05:04',10,0),('1','122',257980,'MORNING','2022-09-23','2022-09-23 21:02:41','2022-09-24 21:02:41','697',8124817.50,8124817.50,'697','2022-09-23 21:14:54','533','2022-09-24 11:07:48',10,0),('1','122',257981,'AFTERNOON ','2022-09-23','2022-09-24 12:18:27','2022-09-25 12:18:27','697',7913638.50,7913638.50,'697','2022-09-24 12:38:43','533','2022-09-24 15:15:35',10,0),('1','122',257982,'MORNING ','2022-09-24','2022-09-24 17:21:23','2022-09-25 17:21:23','697',3527998.25,3527998.25,'697','2022-09-24 17:33:51','533','2022-09-25 14:09:58',10,0),('1','122',257983,'AFTERNOON','2022-09-24','2022-09-25 14:30:19','2022-09-26 14:30:19','697',5255783.00,5255783.00,'697','2022-09-25 14:45:09','533','2022-09-25 17:29:37',10,0),('1','122',257984,'MORNING','2022-09-25','2022-09-25 17:37:06','2022-09-26 17:37:06','697',2259192.00,2259192.00,'697','2022-09-25 17:45:13','533','2022-09-25 19:37:50',10,0),('1','122',257985,'AFTERNOON','2022-09-25','2022-09-26 13:06:10','2022-09-27 13:06:10','697',4531045.25,4531045.25,'697','2022-09-26 16:17:09','533','2022-09-27 10:31:22',10,0),('1','122',257986,'MORNING ','2022-09-26','2022-09-27 11:49:21','2022-09-28 11:49:21','697',2990450.00,2990450.00,'697','2022-09-27 12:10:09','533','2022-09-27 12:17:27',10,0),('1','122',257987,'AFTERNOON ','2022-09-26','2022-09-27 12:33:13','2022-09-28 12:33:13','697',7816402.00,7816402.00,'697','2022-09-27 12:42:01','533','2022-09-27 19:19:34',10,0),('1','122',257988,'MORNING ','2022-09-27','2022-09-27 19:37:55','2022-09-28 19:37:55','697',3969540.50,3969540.50,'697','2022-09-27 19:51:27','533','2022-09-28 13:36:18',10,0),('1','122',257989,'AFTERNOON ','2022-09-27','2022-09-28 13:49:49','2022-09-29 13:49:49','697',5734102.50,5734102.50,'697','2022-09-28 14:03:09','533','2022-09-28 15:47:32',10,0),('1','122',257990,'MORNING','2022-09-28','2022-09-28 16:13:32','2022-09-29 16:13:32','697',8616355.25,8616355.25,'697','2022-09-28 16:35:38','533','2022-09-28 18:18:47',10,0),('1','122',257991,'AFTERNOON','2022-09-28','2022-09-29 12:51:35','2022-09-30 12:51:35','697',6262463.00,6262463.00,'697','2022-09-29 13:45:44','533','2022-09-30 10:19:49',10,0),('1','122',257992,'MORNING','2022-09-29','2022-09-30 10:22:30','2022-10-01 10:22:30','697',3083209.50,3083209.50,'697','2022-09-30 10:30:59','533','2022-09-30 10:33:37',10,0),('1','122',257993,'AFTERNOON','2022-09-29','2022-09-30 10:47:30','2022-10-01 10:47:30','697',12328190.50,12328190.50,'697','2022-09-30 14:19:23','533','2022-09-30 16:12:04',10,0),('1','122',257994,'MORNING','2022-09-30','2022-09-30 16:15:43','2022-10-01 16:15:43','697',2432539.95,2432539.95,'697','2022-09-30 16:40:30','533','2022-09-30 21:43:55',10,0),('1','122',257995,'AFTERNOON','2022-09-30','2022-10-01 08:42:21','2022-10-02 08:42:21','697',4327447.10,4327447.10,'697','2022-10-01 11:55:41','533','2022-10-02 13:28:08',10,0),('1','122',257996,'MORNING','2022-10-01','2022-10-02 13:38:04','2022-10-03 13:38:04','697',3668577.45,3668577.45,'697','2022-10-02 13:43:39','533','2022-10-02 15:24:50',10,0),('1','122',257997,'AFTERNOON','2022-10-01','2022-10-02 15:27:39','2022-10-03 15:27:39','697',4462397.00,4462397.00,'697','2022-10-02 15:39:43','533','2022-10-02 17:13:12',10,0),('1','122',257998,'MORNING ','2022-10-02','2022-10-03 09:01:33','2022-10-04 09:01:33','697',2999928.25,2999928.25,'697','2022-10-03 09:31:40','533','2022-10-03 10:22:12',10,0),('1','122',257999,'AFTERNOON','2022-10-02','2022-10-03 11:47:05','2022-10-04 11:47:05','697',2584758.90,2584758.90,'697','2022-10-03 12:19:07','533','2022-10-03 14:00:46',10,0),('1','122',258000,'MORNING ','2022-10-03','2022-10-03 19:32:35','2022-10-04 19:32:35','697',3305748.25,3305748.25,'697','2022-10-03 19:44:14','533','2022-10-04 15:01:25',10,0),('1','122',258001,'AFTERNOON','2022-10-03','2022-10-04 15:43:42','2022-10-05 15:43:42','697',0.00,0.00,'697','2022-10-05 15:50:38','533','2022-10-05 17:23:22',10,0),('1','122',258002,'AFTERNOON ','2022-10-03','2022-10-05 17:24:20','2022-10-06 17:24:20','697',3863790.60,3863790.60,'697','2022-10-06 08:05:46','454','2022-10-06 08:07:51',10,0),('1','122',258003,'MORNING','2022-10-04','2022-10-06 08:19:21','2022-10-07 08:19:21','697',4961372.60,4961372.60,'697','2022-10-06 08:44:09','533','2022-10-06 09:00:10',10,0),('1','122',258004,'AFTERNOON','2022-10-04','2022-10-06 09:06:44','2022-10-07 09:06:44','697',5136556.10,5136556.10,'697','2022-10-06 09:17:35','533','2022-10-06 09:27:11',10,0),('1','122',258005,'MORNING','2022-10-05','2022-10-06 09:43:22','2022-10-07 09:43:22','697',4723502.18,4723502.18,'697','2022-10-06 09:53:10','533','2022-10-06 09:57:33',10,0),('1','122',258006,'AFTERNOON','2022-10-05','2022-10-06 14:27:26','2022-10-07 14:27:26','697',5610987.38,5610987.38,'697','2022-10-06 14:40:07','533','2022-10-06 15:51:33',10,0),('1','122',258007,'MORNING ','2022-10-06','2022-10-06 17:38:34','2022-10-07 17:38:34','697',2301897.50,2301897.50,'697','2022-10-06 17:44:25','454','2022-10-07 11:17:25',10,0),('1','122',258008,'AFTERNOON','2022-10-06','2022-10-07 15:54:12','2022-10-08 15:54:12','697',329912.30,329912.30,'697','2022-10-07 15:57:42','533','2022-10-07 16:03:21',10,0),('1','122',258009,'MORNING & AFTERNOON','2022-10-07','2022-10-08 14:52:59','2022-10-09 14:52:59','697',5523578.80,5523578.80,'697','2022-10-08 15:04:23','533','2022-10-09 14:22:13',10,0),('1','122',258010,'MORNING & AFTERNOON','2022-10-08','2022-10-09 14:39:57','2022-10-10 14:39:57','697',3241000.50,3241000.50,'697','2022-10-09 14:46:51','533','2022-10-10 08:44:39',10,0),('1','122',258011,'MORNING ','2022-10-09','2022-10-10 10:58:23','2022-10-11 10:58:23','697',2076791.00,2076791.00,'697','2022-10-10 11:06:00','533','2022-10-10 14:54:53',10,0),('1','122',258012,'AFTERNOON','2022-10-09','2022-10-10 17:12:58','2022-10-11 17:12:58','697',1645688.50,1645688.50,'697','2022-10-10 17:19:03','533','2022-10-10 21:21:52',10,0),('1','122',258013,'AFTERNOON','2022-10-10','2022-10-11 07:56:16','2022-10-12 07:56:16','697',0.00,0.00,'697','2022-10-11 11:57:29','533','2022-10-11 12:05:02',10,0),('1','122',258014,'MORNING','2022-10-11','2022-10-11 12:05:45','2022-10-12 12:05:45','697',0.00,0.00,'697','2022-10-11 12:06:35','533','2022-10-11 12:19:09',10,0),('1','122',258015,'MORNING','2022-10-10','2022-10-11 12:22:57','2022-10-12 12:22:57','697',1442983.15,1442983.15,'697','2022-10-11 12:26:56','533','2022-10-11 12:31:01',10,0),('1','122',258016,'AFTERNOON','2022-10-10','2022-10-11 12:34:02','2022-10-12 12:34:02','697',1557088.75,1557088.75,'697','2022-10-11 12:43:32','533','2022-10-11 12:56:57',10,0),('1','122',258017,'MORNING & AFTERNOON','2022-10-11','2022-10-12 13:51:43','2022-10-13 13:51:43','697',8457408.75,8457408.75,'697','2022-10-12 14:11:35','533','2022-10-12 17:24:17',10,0),('1','122',258018,'MORNING','2022-10-12','2022-10-12 22:48:54','2022-10-13 22:48:54','697',4886380.70,4886380.70,'697','2022-10-12 22:58:15','533','2022-10-14 12:29:49',10,0),('1','122',258019,'AFTERNOON','2022-10-12','2022-10-14 13:19:02','2022-10-15 13:19:02','697',8947843.10,8947843.10,'697','2022-10-14 13:27:17','533','2022-10-14 14:18:06',10,0),('1','122',258020,'CHANGE OF PRICE 0F AGO','2022-10-12','2022-10-14 15:14:32','2022-10-15 15:14:32','697',747000.00,747000.00,'697','2022-10-14 15:16:20','533','2022-10-14 20:35:21',10,0),('1','122',258021,'MORNING','2022-10-13','2022-10-15 07:39:44','2022-10-16 07:39:44','697',8985647.30,8985647.30,'697','2022-10-15 07:51:13','533','2022-10-15 08:20:19',10,0),('1','122',258022,'AFTERNOON','2022-10-13','2022-10-15 09:22:21','2022-10-16 09:22:21','697',8619423.90,8619423.90,'697','2022-10-15 10:22:30','533','2022-10-15 15:32:43',10,0),('1','122',258023,'MORNING','2022-10-14','2022-10-15 17:13:03','2022-10-16 17:13:03','697',5552503.25,5552503.25,'697','2022-10-15 17:25:48','533','2022-10-15 18:49:48',10,0),('1','122',258024,'AFTERNOON','2022-10-14','2022-10-15 21:45:10','2022-10-16 21:45:10','697',3669740.10,3669740.10,'697','2022-10-15 21:54:58','533','2022-10-16 12:02:43',10,0),('1','122',258025,'MORNING','2022-10-15','2022-10-16 12:34:13','2022-10-17 12:34:13','697',5886338.05,5886338.05,'697','2022-10-16 12:42:05','533','2022-10-17 09:48:13',10,0),('1','122',258026,'AFTERNOON','2022-10-15','2022-10-17 10:03:09','2022-10-18 10:03:09','697',3680225.45,3680225.45,'697','2022-10-17 10:32:05','533','2022-10-17 11:22:17',10,0),('1','122',258027,'AFTERNOON','2022-10-16','2022-10-17 11:45:06','2022-10-18 11:45:06','697',7275383.55,7275383.55,'697','2022-10-17 12:05:40','533','2022-10-18 12:50:30',10,0),('1','122',258028,'AFTERNOON','2022-10-16','2022-10-18 12:57:17','2022-10-19 12:57:17','697',2974347.10,2974347.10,'697','2022-10-18 13:11:33','533','2022-10-18 18:34:36',10,0),('1','122',258029,'MORNING','2022-10-17','2022-10-18 19:00:37','2022-10-19 19:00:37','697',4619762.60,4619762.60,'697','2022-10-18 19:19:10','533','2022-10-19 10:30:02',10,0),('1','122',258030,'AFTERNOON','2022-10-17','2022-10-19 12:27:39','2022-10-20 12:27:39','697',4248435.60,4248435.60,'697','2022-10-19 12:36:52','533','2022-10-20 11:13:05',10,0),('1','122',258031,'MORNING','2022-10-18','2022-10-20 11:29:43','2022-10-21 11:29:43','697',2781492.15,2781492.15,'697','2022-10-20 11:37:00','533','2022-10-20 14:43:48',10,0),('1','122',258032,'AFTERNOON ','2022-10-18','2022-10-20 15:03:04','2022-10-21 15:03:04','697',3783475.15,3783475.15,'697','2022-10-20 15:11:11','533','2022-10-20 15:20:56',10,0),('1','122',258033,'MORNING','2022-10-19','2022-10-20 16:17:22','2022-10-21 16:17:22','697',3998189.70,3998189.70,'697','2022-10-20 16:25:54','533','2022-10-20 16:32:19',10,0),('1','122',258034,'AFTERNOON','2022-10-19','2022-10-20 16:37:35','2022-10-21 16:37:35','697',11334903.15,11334903.15,'697','2022-10-20 16:51:46','533','2022-10-20 16:53:14',10,0),('1','122',258035,'MORNING','2022-10-20','2022-10-20 17:02:29','2022-10-21 17:02:29','697',7470865.30,7470865.30,'697','2022-10-20 17:14:31','533','2022-10-21 14:06:31',10,0),('1','122',258036,'AFTERNOON','2022-10-20','2022-10-21 17:46:17','2022-10-22 17:46:17','697',6026539.30,6026539.30,'697','2022-10-21 18:09:28','533','2022-10-21 18:19:42',10,0),('1','122',258037,'MORNING','2022-10-21','2022-10-21 18:36:17','2022-10-22 18:36:17','697',5494046.30,5494046.30,'697','2022-10-21 18:58:57','533','2022-10-22 10:45:34',10,0),('1','122',258038,'AFTERNOON','2022-10-21','2022-10-22 19:19:24','2022-10-23 19:19:24','697',5527863.48,5527863.48,'697','2022-10-22 19:30:56','533','2022-10-22 20:01:52',10,0),('1','122',258039,'MORNING','2022-10-22','2022-10-22 20:08:19','2022-10-23 20:08:19','697',4982523.70,4982523.70,'697','2022-10-22 20:19:39','533','2022-10-23 11:17:07',10,0),('1','122',258040,'AFTERNOON','2022-10-22','2022-10-23 16:23:06','2022-10-24 16:23:06','697',5580872.25,5580872.25,'697','2022-10-23 16:42:56','533','2022-10-23 16:46:04',10,0),('1','122',258041,'MORNING ','2022-10-23','2022-10-23 16:58:06','2022-10-24 16:58:06','697',5880400.30,5880400.30,'697','2022-10-23 18:14:22','533','2022-10-24 09:00:03',10,0),('1','122',258042,'AFTERNOON','2022-10-23','2022-10-24 16:57:54','2022-10-25 16:57:54','697',8513136.15,8513136.15,'697','2022-10-24 17:37:03','533','2022-10-25 14:10:31',10,0),('1','122',258043,'MORNING & AFTERNOON','2022-10-24','2022-10-25 14:47:57','2022-10-26 14:47:57','697',8106832.45,8106832.45,'697','2022-10-25 15:02:52','533','2022-10-25 15:54:56',10,0),('1','122',258044,'MORNING','2022-10-25','2022-10-26 07:43:41','2022-10-27 07:43:41','697',4362700.30,4362700.30,'697','2022-10-26 07:59:37','533','2022-10-26 11:00:50',10,0),('1','122',258045,'AFTERNOON','2022-10-25','2022-10-26 16:46:26','2022-10-27 16:46:26','697',8664070.40,8664070.40,'697','2022-10-26 17:00:28','533','2022-10-26 18:18:51',10,0),('1','122',258046,'MORNING','2022-10-26','2022-10-26 18:50:12','2022-10-27 18:50:12','697',9547621.20,9547621.20,'697','2022-10-26 21:50:50','533','2022-10-27 14:28:12',10,0),('1','122',258047,'AFTERNOON ','2022-10-06','2022-10-27 16:34:49','2022-10-28 16:34:49','697',0.00,0.00,'697','2022-10-27 16:35:26','533','2022-10-27 16:38:57',10,0),('1','122',258048,'AFTERNOON','2022-10-26','2022-10-27 16:41:36','2022-10-28 16:41:36','697',3785538.15,3785538.15,'697','2022-10-27 17:08:39','533','2022-10-27 17:11:38',10,0),('1','122',258049,'MORNING','2022-10-27','2022-10-27 18:16:51','2022-10-28 18:16:51','697',4852629.20,4852629.20,'697','2022-10-27 18:27:48','533','2022-10-28 13:19:04',10,0),('1','122',258050,'AFTERNOON','2022-10-27','2022-10-28 15:19:26','2022-10-29 15:19:26','697',4348150.80,4348150.80,'697','2022-10-28 16:43:10','533','2022-10-28 17:41:56',10,0),('1','122',258051,'MORNING','2022-10-28','2022-10-28 17:54:12','2022-10-29 17:54:12','697',3401799.75,3401799.75,'697','2022-10-28 18:03:46','533','2022-10-28 21:28:08',10,0),('1','122',258052,'AFTERNOON','2022-10-28','2022-10-29 12:23:16','2022-10-30 12:23:16','697',6331046.10,6331046.10,'697','2022-10-29 12:36:19','533','2022-10-29 18:13:49',10,0),('1','122',258053,'MORNING','2022-10-29','2022-10-29 18:15:18','2022-10-30 18:15:18','697',5101387.45,5101387.45,'697','2022-10-29 18:21:38','533','2022-10-30 12:17:52',10,0),('1','122',258054,'AFTERNOON','2022-10-29','2022-10-30 13:01:04','2022-10-31 13:01:04','697',4335291.10,4335291.10,'697','2022-10-30 13:32:06','533','2022-10-30 18:12:16',10,0),('1','122',258055,'MORNING','2022-10-30','2022-10-30 18:16:56','2022-10-31 18:16:56','697',3491511.45,3491511.45,'697','2022-10-30 18:21:57','533','2022-10-30 18:57:36',10,0),('1','122',258056,'AFTERNOON','2022-10-30','2022-10-31 09:04:29','2022-11-01 09:04:29','697',5001090.50,5001090.50,'697','2022-10-31 09:10:25','454','2022-10-31 14:11:48',10,0),('1','122',258057,'MORNING','2022-10-31','2022-10-31 17:02:35','2022-11-01 17:02:35','697',7995256.65,7995256.65,'697','2022-10-31 18:16:49','533','2022-11-01 08:06:03',10,0),('1','122',258058,'AFTERNOON ','2022-10-31','2022-11-01 08:30:30','2022-11-02 08:30:30','697',5313411.60,5313411.60,'697','2022-11-01 08:48:35','533','2022-11-01 18:13:15',10,0),('1','122',258059,'MORNING ','2022-11-01','2022-11-01 19:01:52','2022-11-02 19:01:52','697',4337001.45,4337001.45,'697','2022-11-01 19:09:06','533','2022-11-02 08:51:01',10,0),('1','122',258060,'AFTERNOON','2022-11-01','2022-11-02 13:11:20','2022-11-03 13:11:20','697',6754243.70,6754243.70,'697','2022-11-02 13:27:59','533','2022-11-02 18:29:23',10,0),('1','122',258061,'MORNING','2022-11-02','2022-11-02 18:46:21','2022-11-03 18:46:21','697',11666459.70,11666459.70,'697','2022-11-02 18:56:04','533','2022-11-03 11:19:28',10,0),('1','122',258062,'AFTERNOON ','2022-11-02','2022-11-03 15:20:42','2022-11-04 15:20:42','697',5892249.75,5892249.75,'697','2022-11-03 15:25:45','533','2022-11-03 17:49:28',10,0),('1','122',258063,'MORNING','2022-11-03','2022-11-03 17:52:12','2022-11-04 17:52:12','697',6123507.25,6123507.25,'697','2022-11-03 22:02:26','533','2022-11-04 11:26:27',10,0),('1','122',258064,'AFTERNOON ','2022-11-03','2022-11-04 17:49:40','2022-11-05 17:49:40','697',5763953.75,5763953.75,'697','2022-11-04 17:57:47','533','2022-11-04 19:14:30',10,0),('1','122',258065,'MORNING ','2022-11-04','2022-11-04 19:23:28','2022-11-05 19:23:28','697',7610471.80,7610471.80,'697','2022-11-04 19:39:13','533','2022-11-04 20:31:30',10,0),('1','122',258066,'AFTERNOON ','2022-11-04','2022-11-05 16:34:26','2022-11-06 16:34:26','697',4979284.70,4979284.70,'697','2022-11-05 16:46:13','533','2022-11-05 16:49:24',10,0),('1','122',258067,'MORNING ','2022-11-05','2022-11-05 17:27:36','2022-11-06 17:27:36','697',8110801.70,8110801.70,'697','2022-11-05 17:41:42','533','2022-11-06 11:28:39',10,0),('1','122',258068,'AFTERNOON ','2022-11-05','2022-11-06 17:20:39','2022-11-07 17:20:39','697',5675212.20,5675212.20,'697','2022-11-06 18:46:58','533','2022-11-06 20:19:44',10,0),('1','122',258069,'CHAGE OF PRICE OF PMS ','2022-11-06','2022-11-06 20:32:13','2022-11-07 20:32:13','697',2078577.70,2078577.70,'697','2022-11-06 20:46:39','533','2022-11-06 20:55:09',10,0),('1','122',258070,'MORNING','2022-11-06','2022-11-06 22:09:03','2022-11-07 22:09:03','697',3694534.20,3694534.20,'697','2022-11-06 22:16:50','533','2022-11-07 14:36:45',10,0),('1','122',258071,'AFTERNOON','2022-11-06','2022-11-07 17:06:33','2022-11-08 17:06:33','697',3066703.60,3066703.60,'697','2022-11-07 17:19:06','533','2022-11-07 17:50:59',10,0),('1','122',258072,'MORNING','2022-11-07','2022-11-07 17:52:02','2022-11-08 17:52:02','697',3475617.95,3540356.80,'697','2022-11-07 17:56:11','533','2022-11-08 11:52:40',10,0),('1','122',258073,'AFTERNOON','2022-11-07','2022-11-08 17:18:06','2022-11-09 17:18:06','697',2255504.65,2295065.90,'697','2022-11-08 17:25:53','533','2022-11-08 17:37:28',10,0),('1','122',258074,'MORNING','2022-11-08','2022-11-08 17:50:32','2022-11-09 17:50:32','697',7450711.00,7619296.10,'697','2022-11-08 18:41:10','454','2022-11-09 10:41:05',10,0),('1','122',258075,'AFTERNOON ','2022-11-08','2022-11-09 18:49:30','2022-11-10 18:49:30','697',5176058.60,5218312.60,'697','2022-11-09 18:59:43','533','2022-11-10 18:38:02',10,0),('1','122',258076,'MORNING','2022-11-09','2022-11-10 18:42:37','2022-11-11 18:42:37','697',7086869.90,7086869.90,'697','2022-11-10 19:14:24','533','2022-11-10 19:49:22',10,0),('1','122',258077,'AFTERNOON ','2022-11-09','2022-11-10 20:38:13','2022-11-11 20:38:13','697',3491023.00,3491023.00,'697','2022-11-10 22:10:40','533','2022-11-10 22:30:01',10,0),('1','122',258078,'MORNING','2022-11-10','2022-11-10 22:52:16','2022-11-11 22:52:16','697',5515026.30,5515026.30,'697','2022-11-11 08:18:10','533','2022-11-11 09:49:49',10,0),('1','122',258079,'AFTERNOON','2022-11-10','2022-11-11 11:06:46','2022-11-12 11:06:46','697',5181915.80,5181915.80,'697','2022-11-11 15:58:04','533','2022-11-12 07:27:34',10,0),('1','122',258080,'MORNING ','2022-11-11','2022-11-12 16:39:03','2022-11-13 16:39:03','697',6267420.00,6267420.00,'697','2022-11-12 16:55:26','533','2022-11-12 17:08:18',10,0),('1','122',258081,'AFTERNOON','2022-11-11','2022-11-12 17:10:21','2022-11-13 17:10:21','697',6295887.00,6295887.00,'697','2022-11-12 17:18:11','533','2022-11-12 17:22:29',10,0),('1','122',258082,'MORNING','2022-11-12','2022-11-12 17:44:53','2022-11-13 17:44:53','697',5163399.00,5163399.00,'697','2022-11-12 17:48:28','533','2022-11-13 13:05:07',10,0),('1','122',258083,'AFTERNOON','2022-11-12','2022-11-13 14:10:19','2022-11-14 14:10:19','697',4508677.80,4508677.80,'697','2022-11-13 14:19:31','533','2022-11-13 16:19:05',10,0),('1','122',258084,'MORNING ','2022-11-13','2022-11-13 17:47:32','2022-11-14 17:47:32','697',4972240.80,4972240.80,'697','2022-11-13 17:54:11','533','2022-11-14 08:42:02',10,0),('1','122',258085,'AFTERNOON','2022-11-13','2022-11-14 08:43:49','2022-11-15 08:43:49','697',4293106.20,4293106.20,'697','2022-11-14 08:52:33','533','2022-11-14 19:44:06',10,0),('1','122',258086,'MORNING','2022-11-14','2022-11-14 19:56:32','2022-11-15 19:56:32','697',4753990.80,4753990.80,'697','2022-11-14 20:04:59','533','2022-11-15 14:30:48',10,0),('1','122',258087,'AFTERNOON','2022-11-14','2022-11-15 14:33:56','2022-11-16 14:33:56','697',5574776.80,5574776.80,'697','2022-11-15 14:53:29','533','2022-11-15 16:16:50',10,0),('1','122',258088,'MORNING','2022-11-15','2022-11-15 16:27:49','2022-11-16 16:27:49','697',4180886.20,4180886.20,'697','2022-11-15 16:42:05','533','2022-11-16 10:01:32',10,0),('1','122',258089,'AFTERNOON','2022-11-15','2022-11-16 11:16:50','2022-11-17 11:16:50','697',7664696.60,7664696.60,'697','2022-11-16 11:23:21','533','2022-11-16 14:59:59',10,0),('1','122',258090,'MORNING ','2022-11-16','2022-11-16 16:17:04','2022-11-17 16:17:04','697',4575936.80,4575936.80,'697','2022-11-16 16:20:21','533','2022-11-17 14:29:07',10,0),('1','122',258091,'AFTERNOON','2022-11-16','2022-11-17 16:39:48','2022-11-18 16:39:48','697',5924372.60,5924372.60,'697','2022-11-17 16:48:39','533','2022-11-17 19:00:00',10,0),('1','122',258092,'MORNING ','2022-11-17','2022-11-17 22:27:52','2022-11-18 22:27:52','697',4126868.00,4126868.00,'697','2022-11-17 22:38:56','533','2022-11-18 12:59:55',10,0),('1','122',258093,'AFTERNOON','2022-11-17','2022-11-18 14:27:07','2022-11-19 14:27:07','697',4870427.20,4870427.20,'697','2022-11-18 14:31:30','533','2022-11-18 14:52:59',10,0),('1','122',258094,'MORNING','2022-11-18','2022-11-19 09:58:36','2022-11-20 09:58:36','697',15463845.80,15463845.80,'697','2022-11-19 10:07:57','533','2022-11-19 10:24:13',10,0),('1','122',258095,'AFTERNOON','2022-11-18','2022-11-19 10:41:14','2022-11-20 10:41:14','697',6909623.80,6909623.80,'697','2022-11-19 12:48:31','533','2022-11-19 17:06:02',10,0),('1','122',258096,'MORNING','2022-11-19','2022-11-19 17:28:02','2022-11-20 17:28:02','697',4725504.20,4725504.20,'697','2022-11-19 17:35:26','533','2022-11-20 11:29:40',10,0),('1','122',258097,'AFTERNOON ','2022-11-19','2022-11-20 15:44:03','2022-11-21 15:44:03','697',5651516.40,5651516.40,'697','2022-11-20 15:47:19','533','2022-11-20 16:01:07',10,0),('1','122',258098,'MORNING','2022-11-20','2022-11-21 07:13:20','2022-11-22 07:13:20','697',3089418.60,3089418.60,'697','2022-11-21 07:38:35','533','2022-11-21 12:39:02',10,0),('1','122',258099,'AFTERNOON','2022-11-20','2022-11-21 16:48:20','2022-11-22 16:48:20','697',6102354.40,6102354.40,'697','2022-11-21 16:56:33','533','2022-11-21 17:41:52',10,0),('1','122',258100,'MORNING','2022-11-21','2022-11-21 17:55:00','2022-11-22 17:55:00','697',4474430.20,4474430.20,'697','2022-11-21 18:07:00','533','2022-11-22 10:33:55',10,0),('1','122',258101,'AFTERNOON','2022-11-21','2022-11-22 13:38:49','2022-11-23 13:38:49','697',7740677.80,7740677.80,'697','2022-11-22 17:24:32','533','2022-11-22 17:38:05',10,0),('1','122',258102,'MORNING','2022-11-22','2022-11-22 17:51:05','2022-11-23 17:51:05','697',5258150.80,5258150.80,'697','2022-11-22 18:05:16','533','2022-11-23 11:15:41',10,0),('1','122',258103,'AFTERNOON','2022-11-22','2022-11-23 16:39:11','2022-11-24 16:39:11','697',5107122.40,5107122.40,'697','2022-11-23 16:51:54','533','2022-11-23 17:33:13',10,0),('1','122',258104,'MORNING','2022-11-23','2022-11-23 17:41:49','2022-11-24 17:41:49','697',5228532.60,5228532.60,'697','2022-11-23 17:50:00','533','2022-11-24 13:03:40',10,0),('1','122',258105,'AFTERNOON','2022-11-23','2022-11-24 17:20:18','2022-11-25 17:20:18','697',6828892.40,6828892.40,'697','2022-11-24 17:57:11','533','2022-11-25 10:15:30',10,0),('1','122',258106,'MORNING','2022-11-24','2022-11-25 10:19:27','2022-11-26 10:19:27','697',6632215.60,6632215.60,'697','2022-11-25 10:26:18','533','2022-11-25 18:42:34',10,0),('1','122',258107,'AFTERNOON','2022-11-24','2022-11-25 21:02:10','2022-11-26 21:02:10','697',6079392.60,6079392.60,'697','2022-11-25 21:11:42','533','2022-11-26 11:24:13',10,0),('1','122',258108,'MORNING','2022-11-25','2022-11-26 11:53:00','2022-11-27 11:53:00','697',4882665.00,4882665.00,'697','2022-11-26 12:51:17','533','2022-11-26 16:35:43',10,0),('1','122',258109,'AFTERNOON','2022-11-25','2022-11-26 17:36:39','2022-11-27 17:36:39','697',7465258.40,7465258.40,'697','2022-11-26 18:15:15','533','2022-11-27 15:05:36',10,0),('1','122',258110,'MORNING','2022-11-26','2022-11-27 15:08:43','2022-11-28 15:08:43','697',4929644.00,4929644.00,'697','2022-11-27 15:32:21','533','2022-11-27 17:35:54',10,0),('1','122',258111,'AFTERNOON','2022-11-26','2022-11-27 17:38:27','2022-11-28 17:38:27','697',7734986.00,7734986.00,'697','2022-11-27 17:47:22','533','2022-11-27 20:41:20',10,0),('1','122',258112,'MORNING','2022-11-27','2022-11-28 12:14:55','2022-11-29 12:14:55','697',4111363.40,4111363.40,'697','2022-11-28 12:20:47','454','2022-11-28 15:31:11',10,0),('1','122',258113,'AFTERNOON','2022-11-27','2022-11-28 15:35:37','2022-11-29 15:35:37','697',6410231.40,6410231.40,'697','2022-11-28 16:25:33','533','2022-11-29 10:55:57',10,0),('1','122',258114,'MORNING','2022-11-28','2022-11-29 12:30:30','2022-11-30 12:30:30','697',4362187.00,4362187.00,'697','2022-11-29 13:01:37','533','2022-11-29 21:36:52',10,0),('1','122',258115,'AFTERNOON','2022-11-28','2022-11-29 22:37:32','2022-11-30 22:37:32','697',1476469.80,1476469.80,'697','2022-11-29 22:50:07','533','2022-11-30 13:09:39',10,0),('1','122',258116,'MORNING & AFTERNOON','2022-11-29','2022-11-30 13:38:42','2022-12-01 13:38:42','697',7169427.00,7169427.00,'697','2022-11-30 13:45:37','533','2022-11-30 13:49:20',10,0),('1','122',258117,'MORNING','2022-11-30','2022-11-30 21:44:05','2022-12-01 21:44:05','697',4338833.60,4338833.60,'697','2022-11-30 22:27:03','533','2022-11-30 22:38:06',10,0),('1','122',258118,'AFTERNOON','2022-11-30','2022-11-30 22:40:35','2022-12-01 22:40:35','697',4513137.40,4513137.40,'697','2022-11-30 22:47:30','533','2022-12-01 11:56:07',10,0),('1','122',258119,'MORNING & AFTERNOON','2022-12-01','2022-12-05 22:10:33','2022-12-06 22:10:33','697',3088936.60,3088936.60,'697','2022-12-05 22:17:33','533','2022-12-07 11:24:17',10,0),('1','122',258120,'MORNING & AFTERNOON','2022-12-09','2022-12-10 12:49:10','2022-12-11 12:49:10','697',5329863.00,5329863.00,'697','2022-12-10 12:58:06','533','2022-12-11 11:39:24',10,0),('1','122',258121,'MORNING & AFTERNOON ','2022-12-10','2022-12-11 11:41:34','2022-12-12 11:41:34','697',4247314.00,4247314.00,'697','2022-12-11 11:55:13','533','2022-12-12 09:33:35',10,0),('1','122',258122,'MORNING','2022-12-11','2022-12-12 10:16:59','2022-12-13 10:16:59','697',6185533.00,6185533.00,'697','2022-12-12 10:25:30','533','2022-12-12 19:22:13',10,0),('1','122',258123,'AFTERNOON','2022-12-11','2022-12-12 19:56:12','2022-12-13 19:56:12','697',5920993.20,5920993.20,'697','2022-12-12 20:32:49','533','2022-12-12 21:47:35',10,0),('1','122',258124,'MORNING','2022-12-12','2022-12-12 22:12:38','2022-12-13 22:12:38','697',6469651.60,6469651.60,'697','2022-12-12 22:23:59','533','2022-12-13 10:21:25',10,0),('1','122',258125,'AFTERNOON','2022-12-12','2022-12-13 11:45:43','2022-12-14 11:45:43','697',5642782.40,5642782.40,'697','2022-12-13 12:57:11','533','2022-12-13 14:42:48',10,0),('1','122',258126,'MORNING','2022-12-13','2022-12-13 17:13:06','2022-12-14 17:13:06','697',6311174.40,6311174.40,'697','2022-12-13 18:24:27','533','2022-12-14 11:41:07',10,0),('1','122',258127,'AFTERNOON ','2022-12-13','2022-12-14 11:46:58','2022-12-15 11:46:58','697',7788936.40,7788936.40,'697','2022-12-14 12:16:27','533','2022-12-14 18:26:57',10,0),('1','122',258128,'AFTERNOON','2022-12-14','2022-12-14 18:50:30','2022-12-15 18:50:30','697',3980466.80,3980466.80,'697','2022-12-14 19:07:09','533','2022-12-15 12:42:57',10,0),('1','122',258129,'AFTERNOON ','2022-12-14','2022-12-15 13:25:54','2022-12-16 13:25:54','697',6357906.00,6357906.00,'697','2022-12-15 14:04:12','533','2022-12-15 17:02:44',10,0),('1','122',258130,'MORNING','2022-12-15','2022-12-15 17:16:02','2022-12-16 17:16:02','697',5492331.20,5492331.20,'697','2022-12-15 17:23:30','533','2022-12-16 12:58:54',10,0),('1','122',258131,'AFTERNOON','2022-12-15','2022-12-16 14:20:26','2022-12-17 14:20:26','697',7839211.60,7839211.60,'697','2022-12-16 15:01:51','533','2022-12-16 21:00:58',10,0),('1','122',258132,'MORNING','2022-12-16','2022-12-16 22:30:34','2022-12-17 22:30:34','697',6048709.80,6048709.80,'697','2022-12-17 12:26:43','533','2022-12-17 13:02:01',10,0),('1','122',258133,'AFTERNOON','2022-12-16','2022-12-17 15:15:43','2022-12-18 15:15:43','697',4534523.60,4534523.60,'697','2022-12-17 15:45:05','533','2022-12-17 18:43:02',10,0),('1','122',258134,'MORNING','2022-12-17','2022-12-17 18:46:39','2022-12-18 18:46:39','697',8060736.80,8060736.80,'697','2022-12-17 19:49:57','533','2022-12-18 08:10:27',10,0),('1','122',258135,'AFTERNOON','2022-12-17','2022-12-18 12:35:35','2022-12-19 12:35:35','697',4753723.00,4753723.00,'697','2022-12-18 12:46:07','533','2022-12-18 17:08:44',10,0),('1','122',258136,'MORNING','2022-12-18','2022-12-18 17:09:36','2022-12-19 17:09:36','697',8022631.20,8022631.20,'697','2022-12-18 17:28:42','533','2022-12-18 23:34:47',10,0),('1','122',258137,'AFTERNOON','2022-12-18','2022-12-19 11:05:33','2022-12-20 11:05:33','697',4141228.00,4141228.00,'697','2022-12-19 11:15:23','533','2022-12-19 15:02:14',10,0),('1','122',258138,'MORNING & AFTERNOON','2022-12-20','2022-12-20 08:53:02','2022-12-21 08:53:02','697',0.00,0.00,'697','2022-12-20 09:40:29','533','2022-12-20 11:08:08',10,0),('1','122',258139,'MORNING & AFTERNOON','2022-12-19','2022-12-20 12:02:11','2022-12-21 12:02:11','697',2293169.40,2293169.40,'697','2022-12-20 12:07:00','533','2022-12-20 17:01:46',10,0),('1','122',258140,'MORNING','2022-12-20','2022-12-20 17:15:32','2022-12-21 17:15:32','697',8462356.40,8462356.40,'697','2022-12-20 17:25:30','533','2022-12-21 10:15:47',10,0),('1','122',258141,'AFTERNOON','2022-12-20','2022-12-21 11:46:58','2022-12-22 11:46:58','697',8681280.00,8681280.00,'697','2022-12-21 11:59:12','533','2022-12-21 19:28:31',10,0),('1','122',258142,'MORNING','2022-12-21','2022-12-21 20:49:24','2022-12-22 20:49:24','697',5883164.40,5883164.40,'697','2022-12-21 22:15:14','533','2022-12-22 09:04:23',10,0),('1','122',258143,'AFTERNOON','2022-12-21','2022-12-22 13:47:30','2022-12-23 13:47:30','697',9471964.20,9471964.20,'697','2022-12-22 14:07:21','533','2022-12-22 15:07:00',10,0),('1','122',258144,'MORNING','2022-12-22','2022-12-22 20:17:14','2022-12-23 20:17:14','697',6256539.20,6256539.20,'697','2022-12-22 20:34:37','533','2022-12-23 09:23:25',10,0),('1','122',258145,'AFTERNOON','2022-12-22','2022-12-23 12:45:49','2022-12-24 12:45:49','697',8492453.00,8492453.00,'697','2022-12-23 12:54:57','533','2022-12-23 19:46:04',10,0),('1','122',258146,'MORNING','2022-12-23','2022-12-23 19:49:27','2022-12-24 19:49:27','697',6753111.60,6753111.60,'697','2022-12-23 20:43:09','533','2022-12-24 13:56:30',10,0),('1','122',258147,'AFTERNOON','2022-12-23','2022-12-24 14:13:08','2022-12-25 14:13:08','697',8030128.00,8030128.00,'697','2022-12-24 14:26:02','533','2022-12-26 10:46:41',10,0),('1','122',258148,'MORNING','2022-12-24','2022-12-26 18:01:40','2022-12-27 18:01:40','697',6552419.60,6552419.60,'697','2022-12-26 18:20:11','533','2022-12-27 07:50:39',10,0),('1','122',258149,'AFTERNOON','2022-12-24','2022-12-27 07:52:17','2022-12-28 07:52:17','697',6436762.80,6436762.80,'697','2022-12-27 07:57:40','533','2022-12-27 08:00:39',10,0),('1','122',258150,'MORNING & AFTERNOON','2022-12-25','2022-12-27 08:08:01','2022-12-28 08:08:01','697',11624869.60,11624869.60,'697','2022-12-27 08:25:16','533','2022-12-27 17:09:09',10,0),('1','122',258151,'MORNING & AFTERNOON ','2022-12-26','2022-12-27 17:11:08','2022-12-28 17:11:08','697',11586325.00,11586325.00,'697','2022-12-27 17:24:38','533','2022-12-28 10:38:36',10,0),('1','122',258152,'MORNING & AFTERNOON','2022-12-27','2022-12-28 13:01:36','2022-12-29 13:01:36','697',10271190.00,10271190.00,'697','2022-12-28 13:10:00','533','2022-12-28 14:05:49',10,0),('1','122',258153,'MORNING & AFTERNOON','2022-12-28','2022-12-29 12:15:06','2022-12-30 12:15:06','697',13305471.80,13305471.80,'697','2022-12-29 12:43:02','533','2022-12-30 10:08:25',10,0),('1','122',258154,'MORNING & AFTERNOON','2022-12-29','2022-12-31 15:56:15','2023-01-01 15:56:15','697',9211373.20,9211373.20,'697','2022-12-31 16:03:07','533','2022-12-31 16:23:01',10,0),('1','122',258155,'MORNING & AFTERNOON','2022-12-30','2022-12-31 17:12:11','2023-01-01 17:12:11','697',10066280.80,10066280.80,'697','2022-12-31 18:43:31','533','2022-12-31 19:03:55',10,0),('1','122',258156,'MORNING & AFTERNOON','2022-12-31','2022-12-31 19:46:11','2023-01-01 19:46:11','697',10254326.00,10254326.00,'697','2022-12-31 22:20:55','533','2023-01-01 08:04:25',10,0),('1','122',258157,'MORNING & AFTERNOON','2023-01-01','2023-01-02 14:03:08','2023-01-03 14:03:08','697',7080249.40,7080249.40,'697','2023-01-02 14:19:18','533','2023-01-02 14:23:45',10,0),('1','122',258158,'MORNING','2023-01-02','2023-01-02 14:58:20','2023-01-03 14:58:20','697',2864589.00,2864589.00,'697','2023-01-02 15:06:18','533','2023-01-03 10:19:13',10,0),('1','122',258159,'AFTERNOON','2023-01-02','2023-01-03 11:30:56','2023-01-04 11:30:56','697',4833048.20,4833048.20,'697','2023-01-03 11:37:02','533','2023-01-03 15:01:04',10,0),('1','122',258160,'MORNING','2023-01-03','2023-01-03 15:05:36','2023-01-04 15:05:36','697',4328310.80,4328310.80,'697','2023-01-03 15:11:37','533','2023-01-04 10:28:49',10,0),('1','122',258161,'AFTERNOON','2023-01-03','2023-01-04 11:35:15','2023-01-05 11:35:15','697',7140239.80,7140239.80,'697','2023-01-04 12:21:55','533','2023-01-04 15:33:21',10,0),('1','122',258162,'MORNING','2023-01-04','2023-01-04 15:41:39','2023-01-05 15:41:39','697',4934999.60,4934999.60,'697','2023-01-04 15:47:09','533','2023-01-05 11:40:24',10,0),('1','122',258163,'AFTERNOON','2023-01-04','2023-01-05 11:42:36','2023-01-06 11:42:36','697',7356306.24,7356306.24,'697','2023-01-05 11:49:21','533','2023-01-05 17:27:36',10,0),('1','122',258164,'MORNING','2023-01-05','2023-01-05 17:56:35','2023-01-06 17:56:35','697',5127746.00,5127746.00,'697','2023-01-05 18:04:31','533','2023-01-06 12:45:25',10,0),('1','122',258165,'AFTERNOON','2023-01-05','2023-01-06 12:48:23','2023-01-07 12:48:23','697',7402701.60,7402701.60,'697','2023-01-06 12:55:54','533','2023-01-06 17:23:30',10,0),('1','122',258166,'MORNING','2023-01-06','2023-01-06 18:53:58','2023-01-07 18:53:58','697',5559645.80,5559645.80,'697','2023-01-06 19:06:15','533','2023-01-07 09:57:17',10,0),('1','122',258167,'AFTERNOON','2023-01-06','2023-01-07 14:24:13','2023-01-08 14:24:13','697',8535116.40,8535116.40,'697','2023-01-07 14:46:29','533','2023-01-07 17:36:19',10,0),('1','122',258168,'MORNING','2023-01-07','2023-01-07 17:41:19','2023-01-08 17:41:19','697',4702047.60,4702047.60,'697','2023-01-07 18:00:44','533','2023-01-08 11:33:53',10,0),('1','122',258169,'AFTERNOON','2023-01-07','2023-01-08 14:03:17','2023-01-09 14:03:17','697',7159462.60,7159462.60,'697','2023-01-08 14:17:36','533','2023-01-08 16:13:01',10,0),('1','122',258170,'MORNING ','2023-01-08','2023-01-08 16:13:55','2023-01-09 16:13:55','697',4409891.80,4409891.80,'697','2023-01-08 16:21:36','533','2023-01-08 18:31:11',10,0),('1','122',258171,'AFTERNOON','2023-01-08','2023-01-09 13:23:07','2023-01-10 13:23:07','697',5476652.40,5476652.40,'697','2023-01-09 13:32:03','533','2023-01-09 14:08:57',10,0),('1','122',258172,'MORNING','2023-01-09','2023-01-09 14:27:38','2023-01-10 14:27:38','697',4606041.20,4606041.20,'697','2023-01-09 17:21:08','533','2023-01-10 14:21:06',10,0),('1','122',258173,'AFTERNOON','2023-01-09','2023-01-10 17:02:44','2023-01-11 17:02:44','697',4196731.60,4196731.60,'697','2023-01-10 17:20:08','533','2023-01-10 22:41:49',10,0),('1','122',258174,'MORNING','2023-01-10','2023-01-11 05:55:06','2023-01-12 05:55:06','697',6194764.80,6194764.80,'697','2023-01-11 06:06:41','533','2023-01-11 12:42:11',10,0),('1','122',258175,'AFTERNOON ','2023-01-10','2023-01-11 12:43:00','2023-01-12 12:43:00','697',8544118.80,8544118.80,'697','2023-01-11 12:57:33','533','2023-01-11 16:01:27',10,0),('1','122',258176,'MORNING','2023-01-11','2023-01-11 19:50:48','2023-01-12 19:50:48','697',5262953.40,5262953.40,'697','2023-01-11 20:02:47','533','2023-01-12 17:15:41',10,0),('1','122',258177,'AFTERNOON','2023-01-11','2023-01-12 17:49:50','2023-01-13 17:49:50','697',8627192.60,8627192.60,'697','2023-01-12 18:03:39','533','2023-01-12 18:25:32',10,0),('1','122',258178,'MORNING','2023-01-12','2023-01-12 19:34:10','2023-01-13 19:34:10','697',4562786.24,4562786.24,'697','2023-01-12 19:42:15','533','2023-01-13 08:22:48',10,0),('1','122',258179,'AFTERNOON','2023-01-12','2023-01-13 11:04:04','2023-01-14 11:04:04','697',7417054.20,7417054.20,'697','2023-01-13 11:28:16','533','2023-01-13 16:59:50',10,0),('1','122',258180,'MORNING','2023-01-13','2023-01-13 17:26:22','2023-01-14 17:26:22','697',7354788.40,7354788.40,'697','2023-01-13 18:03:37','533','2023-01-14 08:59:02',10,0),('1','122',258181,'AFTERNOON ','2023-01-13','2023-01-14 17:54:27','2023-01-15 17:54:27','697',7063277.20,7063277.20,'697','2023-01-14 18:30:23','533','2023-01-14 18:33:36',10,0),('1','122',258182,'MORNING','2023-01-14','2023-01-14 19:17:51','2023-01-15 19:17:51','697',6404241.80,6404241.80,'697','2023-01-14 19:40:28','533','2023-01-15 08:57:01',10,0),('1','122',258183,'MORNING','2023-01-14','2023-01-15 10:13:39','2023-01-16 10:13:39','697',7609815.80,7609815.80,'697','2023-01-15 10:29:16','533','2023-01-15 10:38:05',10,0),('1','122',258184,'MORNING','2023-01-15','2023-01-15 16:40:52','2023-01-16 16:40:52','697',4462215.40,4462215.40,'697','2023-01-15 16:45:49','533','2023-01-16 11:32:14',10,0),('1','122',258185,'AFTERNOON','2023-01-15','2023-01-16 19:34:37','2023-01-17 19:34:37','697',6046285.40,6046285.40,'697','2023-01-16 19:57:35','533','2023-01-16 20:13:45',10,0),('1','122',258186,'MORNING','2023-01-16','2023-01-16 20:45:28','2023-01-17 20:45:28','697',8277316.60,8277316.60,'697','2023-01-16 21:20:07','533','2023-01-17 11:14:39',10,0),('1','122',258187,'AFTERNOON','2023-01-16','2023-01-17 11:28:28','2023-01-18 11:28:28','697',5963177.20,5963177.20,'697','2023-01-17 12:18:27','533','2023-01-17 18:16:24',10,0),('1','122',258188,'MORNING','2023-01-17','2023-01-17 18:16:55','2023-01-18 18:16:55','697',6593722.40,6593722.40,'697','2023-01-17 18:31:50','533','2023-01-18 09:56:55',10,0),('1','122',258189,'AFTERNOON','2023-01-17','2023-01-18 09:57:53','2023-01-19 09:57:53','697',3454061.00,3454061.00,'697','2023-01-18 10:59:55','533','2023-01-19 07:57:02',10,0),('1','122',258190,'MORNING','2023-01-18','2023-01-19 07:59:02','2023-01-20 07:59:02','697',6524788.60,6524788.60,'697','2023-01-19 08:18:56','533','2023-01-19 13:43:18',10,0),('1','122',258191,'AFTERNOON ','2023-01-18','2023-01-19 13:53:53','2023-01-20 13:53:53','697',3301027.50,3301027.50,'697','2023-01-19 14:05:12','454','2023-01-20 12:50:50',10,0),('1','122',258192,'MORNING ','2023-01-19','2023-01-20 14:48:08','2023-01-21 14:48:08','697',5664286.50,5664286.50,'697','2023-01-20 15:14:45','454','2023-01-20 15:15:16',10,0),('1','122',258193,'AFTERNOON','2023-01-19','2023-01-20 15:27:08','2023-01-21 15:27:08','697',2247700.20,2247700.20,'697','2023-01-20 15:46:53','533','2023-01-20 20:20:59',10,0),('1','122',258194,'MORNING','2023-01-20','2023-01-21 09:50:25','2023-01-22 09:50:25','697',7495865.70,7495865.70,'697','2023-01-21 10:03:11','533','2023-01-21 17:54:55',10,0),('1','122',258195,'AFTERNOON ','2023-01-20','2023-01-21 21:01:40','2023-01-22 21:01:40','697',10104469.75,10040198.85,'697','2023-01-21 21:11:08','533','2023-01-22 15:28:00',10,0),('1','122',258196,'MORNING','2023-01-21','2023-01-22 15:40:48','2023-01-23 15:40:48','697',7152334.35,7143022.95,'697','2023-01-22 16:30:48','533','2023-01-23 07:18:24',10,0),('1','122',258197,'AFTERNOON','2023-01-21','2023-01-23 07:20:25','2023-01-24 07:20:25','697',7321936.90,7299274.50,'697','2023-01-23 07:30:22','533','2023-01-23 07:34:13',10,0),('1','122',258198,'MORNING','2023-01-22','2023-01-23 07:44:48','2023-01-24 07:44:48','697',6936888.00,6933807.30,'697','2023-01-23 07:50:06','533','2023-01-23 07:51:32',10,0),('1','122',258199,'AFTERNOON','2023-01-22','2023-01-23 12:36:38','2023-01-24 12:36:38','697',5055732.30,5038734.30,'697','2023-01-23 12:45:51','533','2023-01-23 16:19:45',10,0),('1','122',258200,'AFTERNOON','2023-01-22','2023-01-23 16:23:14','2023-01-24 16:23:14','697',0.00,0.00,'697','2023-01-23 16:25:54','533','2023-01-23 17:19:37',10,0),('1','122',258201,'MORNING','2023-01-23','2023-01-23 17:27:01','2023-01-24 17:27:01','697',6624020.80,6617197.80,'697','2023-01-23 17:36:16','533','2023-01-23 19:34:43',10,0),('1','122',258202,'AFTERNOON','2023-01-23','2023-01-24 11:54:47','2023-01-25 11:54:47','697',5574675.65,5556977.25,'697','2023-01-24 12:13:19','533','2023-01-24 16:21:04',10,0),('1','122',258203,'MORNING','2023-01-24','2023-01-24 16:23:55','2023-01-25 16:23:55','697',5244811.10,5236705.20,'697','2023-01-24 16:30:22','533','2023-01-25 09:14:41',10,0),('1','122',258204,'AFTERNOON','2023-01-24','2023-01-25 09:15:43','2023-01-26 09:15:43','697',4268009.40,4253230.20,'697','2023-01-25 10:20:49','533','2023-01-25 10:52:45',10,0),('1','122',258205,'MORNING','2023-01-25','2023-01-25 16:43:10','2023-01-26 16:43:10','697',6037352.60,6034913.10,'697','2023-01-25 16:48:04','533','2023-01-25 21:17:20',10,0),('1','122',258206,'AFTERNOON','2023-01-25','2023-01-26 15:24:39','2023-01-27 15:24:39','697',7833728.60,7782406.80,'697','2023-01-26 15:33:54','533','2023-01-26 16:20:26',10,0),('1','122',258207,'MORNING','2023-01-26','2023-01-26 17:35:20','2023-01-27 17:35:20','697',6726984.95,6717001.95,'697','2023-01-26 17:48:37','533','2023-01-26 23:19:11',10,0),('1','122',258208,'AFTERNOON','2023-01-26','2023-01-27 11:36:17','2023-01-28 11:36:17','697',5554011.65,5533691.85,'697','2023-01-27 12:19:23','533','2023-01-27 12:24:58',10,0),('1','122',258209,'MORNING','2023-01-27','2023-01-27 16:50:45','2023-01-28 16:50:45','697',5615654.05,5608223.85,'697','2023-01-27 17:00:39','533','2023-01-27 20:55:58',10,0),('1','122',258210,'AFTERNOON','2023-01-27','2023-01-28 11:49:16','2023-01-29 11:49:16','697',6470016.20,6446179.20,'697','2023-01-28 12:03:47','533','2023-01-28 16:14:17',10,0),('1','122',258211,'MORNING','2023-01-28','2023-01-28 16:15:53','2023-01-29 16:15:53','697',5343829.95,5342370.45,'697','2023-01-28 16:40:04','533','2023-01-29 10:28:27',10,0),('1','122',258212,'AFTERNOON','2023-01-28','2023-01-29 10:29:36','2023-01-30 10:29:36','697',5619532.00,5599000.20,'697','2023-01-29 10:50:29','533','2023-01-30 09:04:05',10,0),('1','122',258213,'MORNING','2023-01-29','2023-01-30 12:04:47','2023-01-31 12:04:47','697',5817657.05,5814397.65,'697','2023-01-30 12:10:04','533','2023-01-30 12:40:12',10,0),('1','122',258214,'AFTERNOON','2023-01-29','2023-01-30 12:44:27','2023-01-31 12:44:27','697',3934450.50,3923882.10,'697','2023-01-30 12:58:50','533','2023-01-30 13:50:18',10,0),('1','122',258215,'MORNING','2023-01-30','2023-01-30 16:26:31','2023-01-31 16:26:31','697',5650167.75,5645944.65,'697','2023-01-30 16:45:28','533','2023-01-31 13:41:50',10,0),('1','122',258216,'AFTERNOON','2023-01-30','2023-01-31 13:42:59','2023-02-01 13:42:59','697',11031732.70,10955044.50,'697','2023-01-31 13:55:08','533','2023-01-31 16:52:39',10,0),('1','122',258217,'MORNING','2023-01-31','2023-01-31 17:01:48','2023-02-01 17:01:48','697',7166549.85,7151606.85,'697','2023-01-31 17:46:51','533','2023-01-31 18:38:49',10,0),('1','122',258218,'AFTERNOON','2023-01-31','2023-02-01 12:30:55','2023-02-02 12:30:55','697',8167239.15,8146929.75,'697','2023-02-01 12:38:15','533','2023-02-01 13:35:07',10,0),('1','122',258219,'MORNING','2023-02-01','2023-02-02 11:58:17','2023-02-03 11:58:17','697',6441240.90,6423539.10,'697','2023-02-02 12:09:48','533','2023-02-03 11:28:48',10,0),('1','122',258220,'AFTERNOON','2023-02-01','2023-02-03 14:35:59','2023-02-04 14:35:59','697',6030333.35,6022941.75,'697','2023-02-03 14:50:07','533','2023-02-03 14:56:24',10,0),('1','122',258221,'MORNING','2023-02-03','2023-02-03 14:58:08','2023-02-04 14:58:08','697',0.00,0.00,'697','2023-02-03 14:58:31','533','2023-02-03 15:03:17',10,0),('1','122',258222,'MORNING','2023-02-02','2023-02-03 15:05:19','2023-02-04 15:05:19','697',0.00,0.00,'697','2023-02-03 15:22:58','533','2023-02-03 15:37:24',10,0),('1','122',258223,'MORNING','2023-02-02','2023-02-03 15:44:21','2023-02-04 15:44:21','697',5578067.20,5578067.20,'697','2023-02-03 15:48:44','533','2023-02-03 17:10:26',10,0),('1','122',258224,'AFTERNOON','2023-02-02','2023-02-03 18:18:33','2023-02-04 18:18:33','697',6196476.00,6196476.00,'697','2023-02-03 18:22:43','533','2023-02-03 20:30:17',10,0),('1','122',258225,'MORNING','2023-02-03','2023-02-04 07:25:40','2023-02-05 07:25:40','697',6715730.60,6715730.60,'697','2023-02-04 07:36:37','533','2023-02-04 18:15:55',10,0),('1','122',258226,'AFTERNOON','2023-02-03','2023-02-05 12:18:17','2023-02-06 12:18:17','697',4712014.25,4712014.25,'697','2023-02-05 13:04:43','533','2023-02-05 13:06:59',10,0),('1','122',258227,'MORNING','2023-02-04','2023-02-05 13:47:13','2023-02-06 13:47:13','697',4749345.90,4749345.90,'697','2023-02-05 14:03:11','533','2023-02-06 11:54:19',10,0),('1','122',258228,'AFTERNOON','2023-02-04','2023-02-06 12:35:57','2023-02-07 12:35:57','697',4394804.70,4394804.70,'697','2023-02-06 13:09:02','533','2023-02-06 16:08:30',10,0),('1','122',258229,'MORNING','2023-02-05','2023-02-06 16:17:36','2023-02-07 16:17:36','697',4402793.10,4402793.10,'697','2023-02-06 16:22:09','533','2023-02-06 16:54:27',10,0),('1','122',258230,'AFTERNOON','2023-02-05','2023-02-06 17:01:48','2023-02-07 17:01:48','697',7315075.10,7315075.10,'697','2023-02-06 17:08:37','533','2023-02-06 19:16:04',10,0),('1','122',258231,'MORNING','2023-02-06','2023-02-06 19:41:21','2023-02-07 19:41:21','697',6069398.10,6069398.10,'697','2023-02-06 19:49:17','533','2023-02-07 11:00:08',10,0),('1','122',258232,'AFTERNOON','2023-02-06','2023-02-07 13:15:18','2023-02-08 13:15:18','697',5501418.00,5501418.00,'697','2023-02-07 13:24:22','533','2023-02-07 19:37:53',10,0),('1','122',258233,'AFTERNOON ','2023-02-07','2023-02-07 19:38:47','2023-02-08 19:38:47','697',7263899.10,7263899.10,'697','2023-02-07 19:53:33','533','2023-02-07 19:57:29',10,0),('1','122',258234,'AFTERNOON','2023-02-07','2023-02-08 12:12:18','2023-02-09 12:12:18','697',8367389.60,8367389.60,'697','2023-02-08 12:19:37','533','2023-02-08 18:32:38',10,0),('1','122',258235,'MORNING ','2023-02-08','2023-02-09 09:16:29','2023-02-10 09:16:29','697',7056683.90,7056683.90,'697','2023-02-09 09:49:36','533','2023-02-09 17:18:22',10,0),('1','122',258236,'AFTERNOON','2023-02-08','2023-02-09 17:25:53','2023-02-10 17:25:53','697',8594624.95,8594624.95,'697','2023-02-09 17:34:14','533','2023-02-10 14:59:23',10,0),('1','122',258237,'MORNING','2023-02-09','2023-02-10 19:07:58','2023-02-11 19:07:58','697',3768642.80,3768642.80,'697','2023-02-10 19:12:51','533','2023-02-10 19:29:43',10,0),('1','122',258238,'AFTERNOON','2023-02-09','2023-02-10 19:36:25','2023-02-11 19:36:25','697',10397953.45,10397953.45,'697','2023-02-10 19:43:51','533','2023-02-10 20:14:41',10,0),('1','122',258239,'MORNING','2023-02-10','2023-02-10 20:29:27','2023-02-11 20:29:27','697',6457192.20,6457192.20,'697','2023-02-11 10:28:07','533','2023-02-11 11:41:40',10,0),('1','122',258240,'AFTERNOON','2023-02-10','2023-02-11 14:29:15','2023-02-12 14:29:15','697',7957481.60,7957481.60,'697','2023-02-11 14:41:52','533','2023-02-11 17:51:53',10,0),('1','122',258241,'MORNING','2023-02-11','2023-02-11 17:58:34','2023-02-12 17:58:34','697',4870734.30,4870734.30,'697','2023-02-11 18:23:34','533','2023-02-12 09:33:46',10,0),('1','122',258242,'AFTERNOON','2023-02-11','2023-02-12 11:53:52','2023-02-13 11:53:52','697',8386797.65,8386797.65,'697','2023-02-12 17:50:07','533','2023-02-12 17:52:29',10,0),('1','122',258243,'MORNING','2023-02-12','2023-02-12 18:28:57','2023-02-13 18:28:57','697',5079978.40,5079978.40,'697','2023-02-12 18:35:03','533','2023-02-13 12:42:00',10,0),('1','122',258244,'AFTERNOON','2023-02-12','2023-02-13 12:51:15','2023-02-14 12:51:15','697',8690030.95,8690030.95,'697','2023-02-13 12:58:13','533','2023-02-13 16:03:20',10,0),('1','122',258245,'MORNING ','2023-02-13','2023-02-13 16:13:50','2023-02-14 16:13:50','697',7258568.25,7258568.25,'697','2023-02-13 17:32:54','533','2023-02-14 11:30:27',10,0),('1','122',258246,'AFTERNOON','2023-02-13','2023-02-14 11:38:47','2023-02-15 11:38:47','697',7665527.25,7665527.25,'697','2023-02-14 12:50:00','533','2023-02-14 19:25:34',10,0),('1','122',258247,'MORNING','2023-02-14','2023-02-14 20:00:54','2023-02-15 20:00:54','697',8025312.85,8025312.85,'697','2023-02-14 20:16:23','533','2023-02-15 12:42:29',10,0),('1','122',258248,'AFTERNOON','2023-02-14','2023-02-15 12:50:14','2023-02-16 12:50:14','697',9200464.65,9200464.65,'697','2023-02-15 13:36:22','533','2023-02-15 18:20:31',10,0),('1','122',258249,'MORNING','2023-02-15','2023-02-15 18:25:19','2023-02-16 18:25:19','697',7478659.55,7478659.55,'697','2023-02-15 18:33:35','533','2023-02-16 10:01:47',10,0),('1','122',258250,'AFTERNOON','2023-02-15','2023-02-16 16:43:53','2023-02-17 16:43:53','697',6641522.65,6641522.65,'697','2023-02-16 16:59:15','533','2023-02-16 20:48:42',10,0),('1','122',258251,'MORNING','2023-02-16','2023-02-17 11:07:30','2023-02-18 11:07:30','697',7162394.70,7162394.70,'697','2023-02-17 11:41:41','533','2023-02-17 15:27:37',10,0),('1','122',258252,'AFTERNOON','2023-02-16','2023-02-17 15:31:53','2023-02-18 15:31:53','697',6692808.95,6692808.95,'697','2023-02-17 16:14:04','533','2023-02-18 10:37:05',10,0),('1','122',258253,'MORNING','2023-02-17','2023-02-18 10:46:50','2023-02-19 10:46:50','697',7854511.20,7854511.20,'697','2023-02-18 11:06:53','533','2023-02-18 14:04:47',10,0),('1','122',258254,'AFTERNOON','2023-02-17','2023-02-18 16:32:44','2023-02-19 16:32:44','697',4230201.00,4230201.00,'697','2023-02-18 16:54:50','533','2023-02-18 17:22:46',10,0),('1','122',258255,'MORNING','2023-02-18','2023-02-18 19:11:33','2023-02-19 19:11:33','697',3497803.50,3497803.50,'697','2023-02-18 19:19:05','533','2023-02-19 17:38:00',10,0),('1','122',258256,'AFTERNOON','2023-02-18','2023-02-19 17:42:40','2023-02-20 17:42:40','697',4067480.60,4067480.60,'697','2023-02-19 17:51:36','533','2023-02-19 18:51:10',10,0),('1','122',258257,'MORNING','2023-02-19','2023-02-19 19:44:22','2023-02-20 19:44:22','697',6972599.50,6972599.50,'697','2023-02-19 19:59:46','533','2023-02-20 09:22:02',10,0),('1','122',258258,'AFTERNOON','2023-02-19','2023-02-20 13:05:03','2023-02-21 13:05:03','697',5559977.70,5559977.70,'697','2023-02-20 14:21:55','533','2023-02-20 18:29:08',10,0),('1','122',258259,'MORNING','2023-02-20','2023-02-20 18:30:33','2023-02-21 18:30:33','697',5295160.00,5295160.00,'697','2023-02-20 18:42:26','533','2023-02-21 13:04:46',10,0),('1','122',258260,'AFTERNOON','2023-02-20','2023-02-21 13:06:37','2023-02-22 13:06:37','697',5514506.95,5514506.95,'697','2023-02-21 13:21:19','533','2023-02-22 09:20:07',10,0),('1','122',258261,'MORNING','2023-02-21','2023-02-22 09:27:35','2023-02-23 09:27:35','697',6712841.75,6712841.75,'697','2023-02-22 12:32:27','533','2023-02-22 18:21:25',10,0),('1','122',258262,'AFTERNOON','2023-02-21','2023-02-22 18:44:36','2023-02-23 18:44:36','697',6354775.25,6354775.25,'697','2023-02-22 20:59:42','533','2023-02-23 09:12:38',10,0),('1','122',258263,'MORNING','2023-02-22','2023-02-23 09:21:02','2023-02-24 09:21:02','697',7032336.95,7032336.95,'697','2023-02-23 10:05:43','533','2023-02-23 18:30:38',10,0),('1','122',258264,'AFTERNOON','2023-02-22','2023-02-23 18:31:23','2023-02-24 18:31:23','697',5187063.10,5187063.10,'697','2023-02-23 18:42:53','533','2023-02-24 09:31:10',10,0),('1','122',258265,'MORNING','2023-02-23','2023-02-24 09:50:50','2023-02-25 09:50:50','697',7467064.50,7467064.50,'697','2023-02-24 10:02:38','533','2023-02-24 11:54:11',10,0),('1','122',258266,'AFTERNOON','2023-02-23','2023-02-24 12:10:53','2023-02-25 12:10:53','697',3967342.40,3967342.40,'697','2023-02-24 12:17:26','533','2023-02-24 16:59:58',10,0),('1','122',258267,'MORNING','2023-02-24','2023-02-24 17:01:36','2023-02-25 17:01:36','697',6523758.75,6523758.75,'697','2023-02-24 17:28:26','533','2023-02-26 11:21:22',10,0),('1','122',258268,'AFTERNOON','2023-02-24','2023-02-26 11:22:56','2023-02-27 11:22:56','697',6349547.15,6349547.15,'697','2023-02-26 11:37:08','533','2023-02-26 17:28:25',10,0),('1','122',258269,'MORNING','2023-02-26','2023-02-26 17:40:20','2023-02-27 17:40:20','697',3741889.20,3741889.20,'697','2023-02-26 17:47:07','533','2023-02-27 09:51:34',10,0),('1','122',258270,'AFTERNOON','2023-02-26','2023-02-27 10:10:01','2023-02-28 10:10:01','697',5759144.15,5759144.15,'697','2023-02-27 12:20:59','533','2023-02-27 22:12:36',10,0),('1','122',258271,'MORNING','2023-02-27','2023-02-28 07:07:48','2023-03-01 07:07:48','697',4849666.90,4849666.90,'697','2023-02-28 09:31:34','533','2023-02-28 11:49:33',10,0),('1','122',258272,'AFTERNOON','2023-02-27','2023-02-28 11:50:33','2023-03-01 11:50:33','697',7498890.95,7498890.95,'697','2023-02-28 12:03:31','533','2023-02-28 13:08:22',10,0),('1','122',258273,'MORNING','2023-02-28','2023-02-28 18:31:29','2023-03-01 18:31:29','697',7974222.60,7974222.60,'697','2023-02-28 19:12:06','533','2023-03-01 09:15:09',10,0),('1','122',258274,'AFTERNOON ','2023-02-28','2023-03-01 09:52:14','2023-03-02 09:52:14','697',5589390.95,5589390.95,'697','2023-03-01 12:00:40','533','2023-03-01 20:49:40',10,0),('1','122',258275,'MORNING ','2023-03-01','2023-03-01 21:58:54','2023-03-02 21:58:54','697',5840824.35,5840824.35,'697','2023-03-01 23:06:33','533','2023-03-02 10:44:11',10,0),('1','122',258276,'AFTERNOON','2023-03-01','2023-03-02 13:11:35','2023-03-03 13:11:35','697',7075849.40,7075849.40,'697','2023-03-02 13:33:36','533','2023-03-03 09:42:42',10,0),('1','122',258277,'MORNING','2023-03-02','2023-03-03 10:07:15','2023-03-04 10:07:15','697',7776696.10,7776696.10,'697','2023-03-03 10:21:23','533','2023-03-03 15:06:08',10,0),('1','122',258278,'AFTERNOON','2023-03-02','2023-03-03 15:09:39','2023-03-04 15:09:39','697',6031946.45,6031946.45,'697','2023-03-03 15:59:19','533','2023-03-03 16:15:00',10,0),('1','122',258279,'MORNING','2023-03-03','2023-03-03 16:36:32','2023-03-04 16:36:32','697',6859088.15,6859088.15,'697','2023-03-03 17:35:04','533','2023-03-03 17:42:33',10,0),('1','122',258280,'AFTERNOON ','2023-03-03','2023-03-04 09:08:55','2023-03-05 09:08:55','697',2754955.75,2754955.75,'697','2023-03-04 13:39:56','533','2023-03-05 12:09:11',10,0),('1','122',258281,'AFTERNOON','2023-03-05','2023-03-05 14:12:10','2023-03-06 14:12:10','697',1946541.30,1946541.30,'697','2023-03-05 16:26:09','533','2023-03-05 16:35:23',10,0),('1','122',258282,'MORNING','2023-03-05','2023-03-05 19:12:43','2023-03-06 19:12:43','697',6628821.05,6628821.05,'697','2023-03-05 19:36:49','533','2023-03-06 09:54:24',10,0),('1','122',258283,'AFTERNOON','2023-03-05','2023-03-06 12:06:46','2023-03-07 12:06:46','697',8772200.95,8772200.95,'697','2023-03-06 12:22:09','533','2023-03-06 12:59:45',10,0),('1','122',258284,'MORNING','2023-03-06','2023-03-06 13:06:02','2023-03-07 13:06:02','697',5170579.00,5170579.00,'697','2023-03-06 18:14:39','533','2023-03-07 16:00:50',10,0),('1','122',258285,'AFTERNOON','2023-03-06','2023-03-07 16:12:01','2023-03-08 16:12:01','697',3878477.05,3878477.05,'697','2023-03-07 16:23:42','533','2023-03-07 21:23:47',10,0),('1','122',258286,'MORNING','2023-03-07','2023-03-08 06:40:21','2023-03-09 06:40:21','697',5411752.45,5411752.45,'697','2023-03-08 06:46:19','533','2023-03-08 08:29:32',10,0),('1','122',258287,'AFTERNOON','2023-03-07','2023-03-08 10:19:38','2023-03-09 10:19:38','697',5497727.50,5497727.50,'697','2023-03-08 14:00:26','533','2023-03-09 06:17:49',10,0),('1','122',258288,'MORNING ','2023-03-08','2023-03-09 11:42:42','2023-03-10 11:42:42','697',6929560.55,6929560.55,'697','2023-03-09 15:36:06','533','2023-03-09 15:41:11',10,0),('1','122',258289,'AFTERNOON ','2023-03-08','2023-03-09 22:19:53','2023-03-10 22:19:53','697',7629406.30,7629406.30,'697','2023-03-10 21:16:17','533','2023-03-12 07:42:18',10,0),('1','122',258290,'MORNING','2023-03-09','2023-03-12 14:38:37','2023-03-13 14:38:37','697',6865980.05,6865980.05,'697','2023-03-12 14:52:47','533','2023-03-12 15:02:16',10,0),('1','122',258291,'AFTERNOON','2023-03-09','2023-03-12 15:02:50','2023-03-13 15:02:50','697',4937990.90,4937990.90,'697','2023-03-12 15:49:32','533','2023-03-12 20:16:58',10,0),('1','122',258292,'MORNING','2023-03-10','2023-03-12 20:18:22','2023-03-13 20:18:22','697',11283414.25,11283414.25,'697','2023-03-13 10:47:22','533','2023-03-13 11:15:07',10,0),('1','122',258293,'AFTERNOON','2023-03-10','2023-03-13 11:18:23','2023-03-14 11:18:23','697',8395343.85,8395343.85,'697','2023-03-13 12:52:00','533','2023-03-13 14:34:15',10,0),('1','122',258294,'MORNING ','2023-03-11','2023-03-13 17:57:46','2023-03-14 17:57:46','697',5795815.25,5795815.25,'697','2023-03-13 18:33:59','533','2023-03-14 10:26:28',10,0),('1','122',258295,'AFTERNOON','2023-03-11','2023-03-14 10:31:16','2023-03-15 10:31:16','697',4966830.50,4966830.50,'697','2023-03-14 11:22:55','533','2023-03-14 11:37:38',10,0),('1','122',258296,'MORNING','2023-03-12','2023-03-14 15:07:21','2023-03-15 15:07:21','697',7076608.25,7076608.25,'697','2023-03-14 15:37:59','533','2023-03-14 15:40:08',10,0),('1','122',258297,'AFTERNOON','2023-03-12','2023-03-14 15:52:14','2023-03-15 15:52:14','697',2782108.75,2782108.75,'697','2023-03-14 16:01:03','533','2023-03-14 16:42:17',10,0),('1','122',258298,'MORNING','2023-03-13','2023-03-15 18:38:11','2023-03-16 18:38:11','697',4644432.90,4640116.20,'697','2023-03-15 22:45:48','533','2023-03-16 09:36:28',10,0),('1','122',258299,'AFTERNOON ','2023-03-13','2023-03-16 11:30:42','2023-03-17 11:30:42','697',6015562.60,5999316.80,'697','2023-03-16 11:55:26','533','2023-03-16 12:10:00',10,0),('1','122',258300,'MORNING','2023-03-14','2023-03-16 19:58:22','2023-03-17 19:58:22','697',7057547.40,7052468.40,'697','2023-03-16 20:14:08','533','2023-03-16 20:28:20',10,0),('1','122',258301,'AFTERNOON','2023-03-14','2023-03-16 20:35:17','2023-03-17 20:35:17','697',4778082.75,4775086.05,'697','2023-03-16 20:53:03','533','2023-03-16 21:06:33',10,0),('1','122',258302,'MORNING ','2023-03-15','2023-03-17 10:35:35','2023-03-18 10:35:35','697',6074853.15,6064720.05,'697','2023-03-17 10:56:13','533','2023-03-17 11:27:35',10,0),('1','122',258303,'MORNING','2023-03-15','2023-03-17 11:52:10','2023-03-18 11:52:10','697',4417204.35,4395340.95,'697','2023-03-17 11:58:08','533','2023-03-17 19:44:23',10,0),('1','122',258304,'MORNING','2023-03-16','2023-03-17 20:35:58','2023-03-18 20:35:58','697',6048745.30,6043934.00,'697','2023-03-17 21:02:36','533','2023-03-17 21:45:01',10,0),('1','122',258305,'MORNING','2023-03-16','2023-03-18 07:31:58','2023-03-19 07:31:58','697',4631519.30,4626303.40,'697','2023-03-18 07:40:37','533','2023-03-18 20:48:08',10,0),('1','122',258306,'MORNING ','2023-03-17','2023-03-18 20:57:13','2023-03-19 20:57:13','697',8633721.00,8618367.00,'697','2023-03-19 14:58:00','533','2023-03-19 15:03:31',10,0),('1','122',258307,'AFTERNOON','2023-03-17','2023-03-19 15:09:13','2023-03-20 15:09:13','697',6500203.85,6478603.75,'697','2023-03-19 17:37:57','533','2023-03-20 08:16:33',10,0),('1','122',258308,'MORNING ','2023-03-18','2023-03-20 15:00:40','2023-03-21 15:00:40','697',4401226.35,4401226.35,'697','2023-03-20 15:06:36','533','2023-03-20 15:51:10',10,0),('1','122',258309,'AFTERNOON ','2023-03-18','2023-03-20 16:59:03','2023-03-21 16:59:03','697',4509224.65,4509224.65,'697','2023-03-20 17:27:47','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4925453 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','122','1004','231523',4454316,'2961','454',643.33,2020.14,1376.81,220289.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231523',4454317,'2962','454',630.93,631.11,0.18,28.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231523',4454318,'2963','454',482.61,482.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231523',4454319,'2964','454',576.83,1796.95,1220.12,195219.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231523',4454320,'2965','454',570.84,570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231523',4454321,'2966','454',700.73,1862.13,1161.40,185824.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231523',4454322,'2967','454',694.42,694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231523',4454323,'2968','454',610.61,1134.18,523.57,83771.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231523',4454324,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231523',4454325,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231523',4454326,'2971','454',586.26,1683.31,1097.05,175528.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231523',4454327,'2972','454',833.40,833.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231523',4454328,'2973','454',637.04,637.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231523',4454329,'2974','454',745.87,1323.64,577.77,92443.20,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231523',4454330,'2975','454',744.06,744.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231523',4454331,'2976','454',722.81,1112.85,390.04,62406.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231523',4454332,'2977','454',544.93,544.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231523',4454333,'2978','454',765.57,2653.34,1887.77,302043.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231523',4454334,'2979','454',781.87,781.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231523',4454335,'2980','454',957.01,1533.37,576.36,92217.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231523',4454336,'2981','454',597.76,597.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231523',4454337,'2982','454',721.80,928.05,206.25,33000.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231523',4454338,'2983','454',683.28,683.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231523',4454339,'2984','454',786.49,1172.59,386.10,61776.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231523',4454340,'2985','455',454.01,454.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231523',4454341,'2986','455',602.28,602.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231523',4454342,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231523',4454343,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231538',4454643,'2961','454',2020.14,4064.54,2042.40,326784.00,0.00,0.00,2.00,0.00,0.00),('1','122','1004','231538',4454644,'2962','454',631.11,631.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231538',4454645,'2963','454',482.61,482.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231538',4454646,'2964','454',1796.95,3198.77,1401.82,224291.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231538',4454647,'2965','454',570.84,570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231538',4454648,'2966','454',1862.13,2661.04,798.91,127825.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231538',4454649,'2967','454',694.42,694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231538',4454650,'2968','454',1134.18,1706.65,570.47,91275.20,0.00,0.00,2.00,0.00,0.00),('1','122','1004','231538',4454651,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231538',4454652,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231538',4454653,'2971','454',1683.31,2329.75,646.44,103430.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231538',4454654,'2972','454',833.40,833.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231538',4454655,'2973','454',637.04,637.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231538',4454656,'2974','454',1323.64,1661.14,337.50,54000.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231538',4454657,'2975','454',744.06,744.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231538',4454658,'2976','454',1112.85,1444.75,331.90,53104.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231538',4454659,'2977','454',544.93,1447.33,902.40,144384.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231538',4454660,'2978','454',2653.34,3697.80,1044.46,167113.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231538',4454661,'2979','454',781.87,835.00,53.13,8500.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231538',4454662,'2980','454',1533.37,3354.22,1820.85,291336.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231538',4454663,'2981','454',597.76,597.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231538',4454664,'2982','454',928.05,1202.63,274.58,43932.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231538',4454665,'2983','454',683.28,683.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231538',4454666,'2984','454',1172.59,1977.48,804.89,128782.40,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231538',4454667,'2985','455',454.01,454.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231538',4454668,'2986','455',602.28,602.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231538',4454669,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231538',4454670,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231553',4454987,'2961','454',4064.54,6009.97,1945.43,311268.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231553',4454988,'2962','454',631.11,631.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231553',4454989,'2963','454',482.61,482.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231553',4454990,'2964','454',3198.77,5669.10,2470.33,395252.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231553',4454991,'2965','454',570.84,570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231553',4454992,'2966','454',2661.04,4008.42,1347.38,215580.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231553',4454993,'2967','454',694.42,694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231553',4454994,'2968','454',1706.65,2183.31,476.66,76265.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231553',4454995,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231553',4454996,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231553',4454997,'2971','454',2329.75,2873.38,543.63,86980.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231553',4454998,'2972','454',833.40,833.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231553',4454999,'2973','454',637.04,637.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231553',4455000,'2974','454',1661.14,1884.71,223.57,35771.20,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231553',4455001,'2975','454',744.06,744.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231553',4455002,'2976','454',1444.75,1493.53,48.78,7804.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231553',4455003,'2977','454',1447.33,2633.76,1186.43,189828.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231553',4455004,'2978','454',3697.80,4434.46,736.66,117865.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231553',4455005,'2979','454',835.00,1250.80,415.80,66528.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231553',4455006,'2980','454',3354.22,3882.91,528.69,84590.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231553',4455007,'2981','454',597.76,597.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231553',4455008,'2982','454',1202.63,1546.90,344.27,55083.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231553',4455009,'2983','454',683.28,1110.01,426.73,68276.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231553',4455010,'2984','454',1977.48,2424.92,447.44,71590.40,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231553',4455011,'2985','455',454.01,713.00,258.99,78473.97,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231553',4455012,'2986','455',602.28,602.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231553',4455013,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231553',4455014,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231573',4455328,'2961','454',6009.97,8352.08,2342.11,374737.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231573',4455329,'2962','454',631.11,631.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231573',4455330,'2963','454',482.61,1232.46,749.85,119976.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231573',4455331,'2964','454',5669.10,6722.53,1053.43,168548.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231573',4455332,'2965','454',570.84,570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231573',4455333,'2966','454',4008.42,5121.30,1112.88,178060.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231573',4455334,'2967','454',694.42,694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231573',4455335,'2968','454',2183.31,2716.48,533.17,85307.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231573',4455336,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231573',4455337,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231573',4455338,'2971','454',2873.38,3514.69,641.31,102609.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231573',4455339,'2972','454',833.40,833.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231573',4455340,'2973','454',637.04,637.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231573',4455341,'2974','454',1884.71,2435.30,550.59,88094.40,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231573',4455342,'2975','454',744.06,744.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231573',4455343,'2976','454',1493.53,1653.30,159.77,25563.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231573',4455344,'2977','454',2633.76,3090.42,456.66,73065.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231573',4455345,'2978','454',4434.46,5502.65,1068.19,170910.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231573',4455346,'2979','454',1250.80,1250.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231573',4455347,'2980','454',3882.91,4758.85,875.94,140150.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231573',4455348,'2981','454',597.76,598.53,0.77,123.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231573',4455349,'2982','454',1546.90,1674.12,127.22,20355.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231573',4455350,'2983','454',1110.01,1110.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231573',4455351,'2984','454',2424.92,2910.33,485.41,77665.60,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231573',4455352,'2985','455',713.00,713.08,0.08,24.24,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231573',4455353,'2986','455',602.28,1170.99,568.71,172319.13,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231573',4455354,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231573',4455355,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231582',4455544,'2961','454',8352.08,11373.27,3011.19,481790.40,0.00,0.00,10.00,0.00,0.00),('1','122','1004','231582',4455545,'2962','454',631.11,657.89,26.78,4284.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231582',4455546,'2963','454',1232.46,1232.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231582',4455547,'2964','454',6722.53,7145.33,422.80,67648.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231582',4455548,'2965','454',570.84,570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231582',4455549,'2966','454',5121.30,6742.18,1620.88,259340.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231582',4455550,'2967','454',694.42,694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231582',4455551,'2968','454',2716.48,4502.63,1786.15,285784.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231582',4455552,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231582',4455553,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231582',4455554,'2971','454',3514.69,3848.37,333.68,53388.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231582',4455555,'2972','454',833.40,833.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231582',4455556,'2973','454',637.04,637.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231582',4455557,'2974','454',2435.30,5047.69,2612.39,417982.40,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231582',4455558,'2975','454',744.06,744.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231582',4455559,'2976','454',1653.30,1653.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231582',4455560,'2977','454',3090.42,3090.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231582',4455561,'2978','454',5502.65,7722.13,2209.48,353516.80,0.00,0.00,10.00,0.00,0.00),('1','122','1006','231582',4455562,'2979','454',1250.80,1250.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231582',4455563,'2980','454',4758.85,7126.19,2367.34,378774.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231582',4455564,'2981','454',598.53,598.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231582',4455565,'2982','454',1674.12,3566.25,1892.13,302740.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231582',4455566,'2983','454',1110.01,1110.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231582',4455567,'2984','454',2910.33,2910.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231582',4455568,'2985','455',713.08,919.05,185.79,56294.37,0.00,0.00,20.18,0.00,0.00),('1','122','1007','231582',4455569,'2986','455',1170.99,1170.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231582',4455570,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231582',4455571,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231590',4455661,'2961','454',11373.27,12048.88,675.61,108097.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231590',4455662,'2962','454',657.89,657.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231590',4455663,'2963','454',1232.46,1232.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231590',4455664,'2964','454',7145.33,10002.92,2857.59,457214.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231590',4455665,'2965','454',570.84,570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231590',4455666,'2966','454',6742.18,9181.74,2439.56,390329.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231590',4455667,'2967','454',694.42,694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231590',4455668,'2968','454',4502.63,7217.34,2714.71,434353.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231590',4455669,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231590',4455670,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231590',4455671,'2971','454',3848.37,5738.19,1889.82,302371.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231590',4455672,'2972','454',833.40,833.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231590',4455673,'2973','454',637.04,637.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231590',4455674,'2974','454',5047.69,7485.01,2437.32,389971.20,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231590',4455675,'2975','454',744.06,744.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231590',4455676,'2976','454',1653.30,1653.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231590',4455677,'2977','454',3090.42,3090.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231590',4455678,'2978','454',7722.13,8175.95,453.82,72611.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231590',4455679,'2979','454',1250.80,1250.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231590',4455680,'2980','454',7126.19,9524.92,2398.73,383796.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231590',4455681,'2981','454',598.53,3412.29,2813.76,450201.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231590',4455682,'2982','454',3566.25,5066.25,1500.00,240000.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231590',4455683,'2983','454',1110.01,1110.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231590',4455684,'2984','454',2910.33,2910.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231590',4455685,'2985','455',919.05,2856.41,1937.36,587020.08,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231590',4455686,'2986','455',1170.99,4670.99,3500.00,1060500.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231590',4455687,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231590',4455688,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231592',4455719,'2961','454',12048.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231592',4455720,'2962','454',657.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231592',4455721,'2963','454',1232.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231592',4455722,'2964','454',10002.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231592',4455723,'2965','454',570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231592',4455724,'2966','454',9181.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231592',4455725,'2967','454',694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231592',4455726,'2968','454',7217.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231592',4455727,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231592',4455728,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231592',4455729,'2971','454',5738.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231592',4455730,'2972','454',833.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231592',4455731,'2973','454',637.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231592',4455732,'2974','454',7485.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231592',4455733,'2975','454',744.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231592',4455734,'2976','454',1653.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231592',4455735,'2977','454',3090.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231592',4455736,'2978','454',8175.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231592',4455737,'2979','454',1250.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231592',4455738,'2980','454',9524.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231592',4455739,'2981','454',3412.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231592',4455740,'2982','454',5066.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231592',4455741,'2983','454',1110.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231592',4455742,'2984','454',2910.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231592',4455743,'2985','455',2856.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231592',4455744,'2986','455',4670.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231592',4455745,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231592',4455746,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231594',4455765,'2961','454',12048.88,14797.82,2748.94,439830.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231594',4455766,'2962','454',657.89,657.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231594',4455767,'2963','454',1232.46,1232.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231594',4455768,'2964','454',10002.92,10002.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231594',4455769,'2965','454',570.84,570.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231594',4455770,'2966','454',9181.74,12488.18,3306.44,529030.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231594',4455771,'2967','454',694.42,694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231594',4455772,'2968','454',7217.34,7217.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231594',4455773,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231594',4455774,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231594',4455775,'2971','454',5738.19,7573.22,1835.03,293604.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231594',4455776,'2972','454',833.40,833.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231594',4455777,'2973','454',637.04,637.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231594',4455778,'2974','454',7485.01,10775.18,3290.17,526427.20,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231594',4455779,'2975','454',744.06,744.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231594',4455780,'2976','454',1653.30,1653.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231594',4455781,'2977','454',3090.42,5116.53,2026.11,324177.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231594',4455782,'2978','454',8175.95,10757.68,2581.73,413076.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231594',4455783,'2979','454',1250.80,1250.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231594',4455784,'2980','454',9524.92,10514.14,989.22,158275.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231594',4455785,'2981','454',3412.29,5238.35,1826.06,292169.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231594',4455786,'2982','454',5066.25,5066.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231594',4455787,'2983','454',1110.01,1110.54,0.53,84.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231594',4455788,'2984','454',2910.33,2952.56,42.23,6756.80,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231594',4455789,'2985','455',2856.41,3084.66,228.25,69159.75,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231594',4455790,'2986','455',4670.99,4911.82,240.83,72971.49,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231594',4455791,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231594',4455792,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231596',4455817,'2961','454',14797.82,18440.87,3643.05,582888.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231596',4455818,'2962','454',657.89,725.70,67.81,10849.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231596',4455819,'2963','454',1232.46,1243.87,11.41,1825.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231596',4455820,'2964','454',10002.92,10013.80,10.88,1740.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231596',4455821,'2965','454',570.84,571.08,0.24,38.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231596',4455822,'2966','454',12488.18,15273.54,2785.36,445657.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231596',4455823,'2967','454',694.42,695.36,0.94,150.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231596',4455824,'2968','454',7217.34,9765.62,2548.28,407724.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231596',4455825,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231596',4455826,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231596',4455827,'2971','454',7573.22,9839.59,2266.37,362619.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231596',4455828,'2972','454',833.40,840.18,6.78,1084.80,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231596',4455829,'2973','454',637.04,637.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231596',4455830,'2974','454',10775.18,13699.66,2924.48,467916.80,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231596',4455831,'2975','454',744.06,756.66,12.60,2016.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231596',4455832,'2976','454',1653.30,1665.56,12.26,1961.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231596',4455833,'2977','454',5116.53,10093.10,4976.57,796251.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231596',4455834,'2978','454',10757.68,10804.37,46.69,7470.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231596',4455835,'2979','454',1250.80,1250.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231596',4455836,'2980','454',10514.14,10538.49,24.35,3896.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231596',4455837,'2981','454',5238.35,7154.34,1915.99,306558.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231596',4455838,'2982','454',5066.25,5066.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231596',4455839,'2983','454',1110.54,1111.82,1.28,204.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231596',4455840,'2984','454',2952.56,2952.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231596',4455841,'2985','455',3084.66,3234.11,149.45,47076.75,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231596',4455842,'2986','455',4911.82,5100.21,188.39,59342.85,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231596',4455843,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231596',4455844,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231599',4455880,'2961','454',18440.87,24403.87,5963.00,954080.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231599',4455881,'2962','454',725.70,725.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231599',4455882,'2963','454',1243.87,1243.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231599',4455883,'2964','454',10013.80,10013.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231599',4455884,'2965','454',571.08,571.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231599',4455885,'2966','454',15273.54,18322.40,3048.86,487817.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231599',4455886,'2967','454',695.36,695.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231599',4455887,'2968','454',9765.62,12317.58,2551.96,408313.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231599',4455888,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231599',4455889,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231599',4455890,'2971','454',9839.59,11600.92,1761.33,281812.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231599',4455891,'2972','454',840.18,840.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231599',4455892,'2973','454',637.04,637.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231599',4455893,'2974','454',13699.66,16299.58,2599.92,415987.20,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231599',4455894,'2975','454',756.66,756.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231599',4455895,'2976','454',1665.56,1665.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231599',4455896,'2977','454',10093.10,10093.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231599',4455897,'2978','454',10804.37,13694.89,2890.52,462483.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231599',4455898,'2979','454',1250.80,2599.93,1349.13,215860.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231599',4455899,'2980','454',10538.49,10862.49,324.00,51840.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231599',4455900,'2981','454',7154.34,7154.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231599',4455901,'2982','454',5066.25,7381.94,2315.69,370510.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231599',4455902,'2983','454',1111.82,1111.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231599',4455903,'2984','454',2952.56,3348.41,395.85,63336.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231599',4455904,'2985','455',3234.11,4024.81,790.70,249070.50,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231599',4455905,'2986','455',5100.21,5287.82,187.61,59097.15,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231599',4455906,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231599',4455907,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231753',4458527,'2961','454',24403.87,27584.74,3180.87,508939.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231753',4458528,'2962','454',725.70,760.06,34.36,5497.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231753',4458529,'2963','454',1243.87,1243.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231753',4458530,'2964','454',10013.80,10013.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231753',4458531,'2965','454',571.08,571.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231753',4458532,'2966','454',18322.40,21817.27,3494.87,559179.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231753',4458533,'2967','454',695.36,695.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231753',4458534,'2968','454',12317.58,14705.69,2388.11,382097.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231753',4458535,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231753',4458536,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231753',4458537,'2971','454',11600.92,13348.62,1747.70,279632.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231753',4458538,'2972','454',840.18,840.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231753',4458539,'2973','454',637.04,637.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231753',4458540,'2974','454',16299.58,18355.49,2055.91,328945.60,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231753',4458541,'2975','454',756.66,756.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231753',4458542,'2976','454',1665.56,3046.92,1381.36,221017.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231753',4458543,'2977','454',10093.10,10093.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231753',4458544,'2978','454',13694.89,17450.13,3755.24,600838.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231753',4458545,'2979','454',2599.93,2599.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231753',4458546,'2980','454',10862.49,10862.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231753',4458547,'2981','454',7154.34,7154.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231753',4458548,'2982','454',7381.94,7381.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231753',4458549,'2983','454',1111.82,1111.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231753',4458550,'2984','454',3348.41,4160.52,812.11,129937.60,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231753',4458551,'2985','455',4024.81,4276.58,251.77,79307.55,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231753',4458552,'2986','455',5287.82,5287.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231753',4458553,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231753',4458554,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231756',4458571,'2961','454',27584.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231756',4458572,'2962','454',760.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231756',4458573,'2963','454',1243.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231756',4458574,'2964','454',10013.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231756',4458575,'2965','454',571.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231756',4458576,'2966','454',21817.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231756',4458577,'2967','454',695.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231756',4458578,'2968','454',14705.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231756',4458579,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231756',4458580,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231756',4458581,'2971','454',13348.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231756',4458582,'2972','454',840.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231756',4458583,'2973','454',637.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231756',4458584,'2974','454',18355.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231756',4458585,'2975','454',756.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231756',4458586,'2976','454',3046.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231756',4458587,'2977','454',10093.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231756',4458588,'2978','454',17450.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231756',4458589,'2979','454',2599.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231756',4458590,'2980','454',10862.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231756',4458591,'2981','454',7154.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231756',4458592,'2982','454',7381.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231756',4458593,'2983','454',1111.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231756',4458594,'2984','454',4160.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231756',4458595,'2985','455',4276.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231756',4458596,'2986','455',5287.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231756',4458597,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231756',4458598,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231762',4458715,'2961','454',27584.74,30842.75,3258.01,521281.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231762',4458716,'2962','454',760.06,760.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231762',4458717,'2963','454',1243.87,1243.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231762',4458718,'2964','454',10013.80,10013.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231762',4458719,'2965','454',571.08,571.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231762',4458720,'2966','454',21817.27,24506.30,2689.03,430244.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231762',4458721,'2967','454',695.36,695.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231762',4458722,'2968','454',14705.69,16949.66,2243.97,359035.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231762',4458723,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231762',4458724,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231762',4458725,'2971','454',13348.62,13751.79,403.17,64507.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231762',4458726,'2972','454',840.18,840.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231762',4458727,'2973','454',637.04,637.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231762',4458728,'2974','454',18355.49,20453.03,2097.54,335606.40,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231762',4458729,'2975','454',756.66,756.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231762',4458730,'2976','454',3046.92,5332.23,2285.31,365649.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231762',4458731,'2977','454',10093.10,10093.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231762',4458732,'2978','454',17450.13,22573.17,5123.04,819686.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231762',4458733,'2979','454',2599.93,2599.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231762',4458734,'2980','454',10862.49,10862.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231762',4458735,'2981','454',7154.34,7154.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231762',4458736,'2982','454',7381.94,9533.09,2151.15,344184.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231762',4458737,'2983','454',1111.82,1111.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231762',4458738,'2984','454',4160.52,5918.21,1757.69,281230.40,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231762',4458739,'2985','455',4276.58,4371.95,95.37,30995.25,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231762',4458740,'2986','455',5287.82,5287.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231762',4458741,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231762',4458742,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231766',4458772,'2961','454',30842.75,32072.26,1229.51,196721.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231766',4458773,'2962','454',760.06,770.22,0.16,25.60,0.00,0.00,10.00,0.00,0.00),('1','122','1004','231766',4458774,'2963','454',1243.87,1243.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231766',4458775,'2964','454',10013.80,10013.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231766',4458776,'2965','454',571.08,571.63,0.00,0.00,0.00,0.00,0.55,0.00,0.00),('1','122','1004','231766',4458777,'2966','454',24506.30,25941.82,1435.52,229683.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231766',4458778,'2967','454',695.36,698.69,3.33,532.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231766',4458779,'2968','454',16949.66,17888.69,939.03,150244.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231766',4458780,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231766',4458781,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231766',4458782,'2971','454',13751.79,13764.29,12.50,2000.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231766',4458783,'2972','454',840.18,840.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231766',4458784,'2973','454',637.04,637.43,0.00,0.00,0.00,0.00,0.39,0.00,0.00),('1','122','1005','231766',4458785,'2974','454',20453.03,23775.32,3322.29,531566.40,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231766',4458786,'2975','454',756.66,756.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231766',4458787,'2976','454',5332.23,9489.52,4137.29,661966.40,0.00,0.00,20.00,0.00,0.00),('1','122','1006','231766',4458788,'2977','454',10093.10,10124.54,31.44,5030.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231766',4458789,'2978','454',22573.17,25018.83,2425.66,388105.60,0.00,0.00,20.00,0.00,0.00),('1','122','1006','231766',4458790,'2979','454',2599.93,2599.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231766',4458791,'2980','454',10862.49,13185.01,2322.52,371603.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231766',4458792,'2981','454',7154.34,7154.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231766',4458793,'2982','454',9533.09,12556.25,3023.16,483705.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231766',4458794,'2983','454',1111.82,1311.47,199.65,31944.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231766',4458795,'2984','454',5918.21,5934.60,16.39,2622.40,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231766',4458796,'2985','455',4371.95,4562.01,190.06,61769.50,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231766',4458797,'2986','455',5287.82,5287.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231766',4458798,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231766',4458799,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231772',4458897,'2961','454',32072.26,32095.40,23.14,3702.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231772',4458898,'2962','454',770.22,770.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231772',4458899,'2963','454',1243.87,1244.56,0.69,110.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231772',4458900,'2964','454',10013.80,10013.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231772',4458901,'2965','454',571.63,571.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231772',4458902,'2966','454',25941.82,25947.61,5.79,926.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231772',4458903,'2967','454',698.69,698.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231772',4458904,'2968','454',17888.69,17901.23,12.54,2006.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231772',4458905,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231772',4458906,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231772',4458907,'2971','454',13764.29,13764.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231772',4458908,'2972','454',840.18,840.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231772',4458909,'2973','454',637.43,638.92,1.49,238.40,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231772',4458910,'2974','454',23775.32,27400.48,3625.16,580025.60,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231772',4458911,'2975','454',756.66,756.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231772',4458912,'2976','454',9489.52,11888.77,2399.25,383880.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231772',4458913,'2977','454',10124.54,10124.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231772',4458914,'2978','454',25018.83,28346.87,3328.04,532486.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231772',4458915,'2979','454',2599.93,2599.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231772',4458916,'2980','454',13185.01,17465.78,4280.77,684923.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231772',4458917,'2981','454',7154.34,8952.93,1798.59,287774.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231772',4458918,'2982','454',12556.25,12556.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231772',4458919,'2983','454',1311.47,1311.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231772',4458920,'2984','454',5934.60,8039.74,2105.14,336822.40,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231772',4458921,'2985','455',4562.01,7248.19,2686.18,873008.50,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231772',4458922,'2986','455',5287.82,7787.82,2500.00,812500.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231772',4458923,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231772',4458924,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231773',4458925,'2961','454',32095.40,37241.47,5146.07,833663.34,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231773',4458926,'2962','454',770.22,770.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231773',4458927,'2963','454',1244.56,1244.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231773',4458928,'2964','454',10013.80,13636.36,3622.56,586854.72,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231773',4458929,'2965','454',571.63,571.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231773',4458930,'2966','454',25947.61,29322.53,3374.92,546737.04,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231773',4458931,'2967','454',698.69,698.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231773',4458932,'2968','454',17901.23,17901.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231773',4458933,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231773',4458934,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231773',4458935,'2971','454',13764.29,16201.88,2437.59,394889.58,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231773',4458936,'2972','454',840.18,840.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231773',4458937,'2973','454',638.92,638.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231773',4458938,'2974','454',27400.48,27401.10,0.62,100.44,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231773',4458939,'2975','454',756.66,756.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231773',4458940,'2976','454',11888.77,11888.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231773',4458941,'2977','454',10124.54,13929.75,3805.21,616444.02,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231773',4458942,'2978','454',28346.87,28346.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231773',4458943,'2979','454',2599.93,2599.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231773',4458944,'2980','454',17465.78,17465.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231773',4458945,'2981','454',8952.93,8952.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231773',4458946,'2982','454',12556.25,12556.48,0.23,37.26,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231773',4458947,'2983','454',1311.47,1311.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231773',4458948,'2984','454',8039.74,10710.95,2671.21,432736.02,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231773',4458949,'2985','455',7248.19,7248.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231773',4458950,'2986','455',7787.82,8207.17,419.35,136288.75,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231773',4458951,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231773',4458952,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231775',4458969,'2961','454',37241.47,41227.69,3986.22,645767.64,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231775',4458970,'2962','454',770.22,782.58,12.36,2002.32,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231775',4458971,'2963','454',1244.56,1244.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231775',4458972,'2964','454',13636.36,15628.54,1992.18,322733.16,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231775',4458973,'2965','454',571.63,571.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231775',4458974,'2966','454',29322.53,33495.76,4173.23,676063.26,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231775',4458975,'2967','454',698.69,698.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231775',4458976,'2968','454',17901.23,20075.67,2174.44,352259.28,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231775',4458977,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231775',4458978,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231775',4458979,'2971','454',16201.88,18067.07,1865.19,302160.78,0.00,0.00,0.00,0.00,0.00),('1','122','1004','231775',4458980,'2972','454',840.18,840.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231775',4458981,'2973','454',638.92,638.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231775',4458982,'2974','454',27401.10,28565.32,1164.22,188603.64,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231775',4458983,'2975','454',756.66,756.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','231775',4458984,'2976','454',11888.77,13239.21,1350.44,218771.28,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231775',4458985,'2977','454',13929.75,13979.13,49.38,7999.56,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231775',4458986,'2978','454',28346.87,30523.56,2176.69,352623.78,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231775',4458987,'2979','454',2599.93,2599.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231775',4458988,'2980','454',17465.78,19872.12,2406.34,389827.08,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231775',4458989,'2981','454',8952.93,8952.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231775',4458990,'2982','454',12556.48,12556.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231775',4458991,'2983','454',1311.47,1311.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','231775',4458992,'2984','454',10710.95,10710.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231775',4458993,'2985','455',7248.19,7652.12,403.93,131277.25,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231775',4458994,'2986','455',8207.17,8207.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231775',4458995,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','231775',4458996,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','232976',4480605,'2961','454',41227.69,46185.01,4957.32,803085.84,0.00,0.00,0.00,0.00,0.00),('1','122','1004','232976',4480606,'2962','454',782.58,1876.29,1093.71,177181.02,0.00,0.00,0.00,0.00,0.00),('1','122','1004','232976',4480607,'2963','454',1244.56,1244.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','232976',4480608,'2964','454',15628.54,18385.81,2757.27,446677.74,0.00,0.00,0.00,0.00,0.00),('1','122','1004','232976',4480609,'2965','454',571.63,571.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','232976',4480610,'2966','454',33495.76,36622.83,3127.07,506585.34,0.00,0.00,0.00,0.00,0.00),('1','122','1004','232976',4480611,'2967','454',698.69,2681.41,1982.72,321200.64,0.00,0.00,0.00,0.00,0.00),('1','122','1004','232976',4480612,'2968','454',20075.67,22477.18,2401.51,389044.62,0.00,0.00,0.00,0.00,0.00),('1','122','1004','232976',4480613,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','232976',4480614,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','232976',4480615,'2971','454',18067.07,21460.50,3393.43,549735.66,0.00,0.00,0.00,0.00,0.00),('1','122','1004','232976',4480616,'2972','454',840.18,840.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','232976',4480617,'2973','454',638.92,638.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','232976',4480618,'2974','454',28565.32,29611.97,1046.65,169557.30,0.00,0.00,0.00,0.00,0.00),('1','122','1005','232976',4480619,'2975','454',756.66,756.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','232976',4480620,'2976','454',13239.21,13239.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','232976',4480621,'2977','454',13979.13,15631.15,1652.02,267627.24,0.00,0.00,0.00,0.00,0.00),('1','122','1006','232976',4480622,'2978','454',30523.56,30523.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','232976',4480623,'2979','454',2599.93,2599.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','232976',4480624,'2980','454',19872.12,20926.34,1054.22,170783.64,0.00,0.00,0.00,0.00,0.00),('1','122','1006','232976',4480625,'2981','454',8952.93,8952.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','232976',4480626,'2982','454',12556.48,13191.89,635.41,102936.42,0.00,0.00,0.00,0.00,0.00),('1','122','1006','232976',4480627,'2983','454',1311.47,1898.16,586.69,95043.78,0.00,0.00,0.00,0.00,0.00),('1','122','1006','232976',4480628,'2984','454',10710.95,11317.26,606.31,98222.22,0.00,0.00,0.00,0.00,0.00),('1','122','1007','232976',4480629,'2985','455',7652.12,7939.48,287.36,93392.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','232976',4480630,'2986','455',8207.17,8207.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','232976',4480631,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','232976',4480632,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233566',4491445,'2961','454',46185.01,48748.81,2563.80,415335.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233566',4491446,'2962','454',1876.29,3674.79,1798.50,291357.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233566',4491447,'2963','454',1244.56,4161.39,2916.83,472526.46,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233566',4491448,'2964','454',18385.81,20535.11,2149.30,348186.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233566',4491449,'2965','454',571.63,878.18,306.55,49661.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233566',4491450,'2966','454',36622.83,38470.74,1847.91,299361.42,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233566',4491451,'2967','454',2681.41,2817.94,136.53,22117.86,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233566',4491452,'2968','454',22477.18,26530.23,4053.05,656594.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233566',4491453,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233566',4491454,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233566',4491455,'2971','454',21460.50,23768.21,2307.71,373849.02,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233566',4491456,'2972','454',840.18,840.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','233566',4491457,'2973','454',638.92,638.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','233566',4491458,'2974','454',29611.97,29611.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','233566',4491459,'2975','454',756.66,756.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','233566',4491460,'2976','454',13239.21,13239.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233566',4491461,'2977','454',15631.15,15631.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233566',4491462,'2978','454',30523.56,30523.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233566',4491463,'2979','454',2599.93,2599.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233566',4491464,'2980','454',20926.34,20926.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233566',4491465,'2981','454',8952.93,8952.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233566',4491466,'2982','454',13191.89,13191.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233566',4491467,'2983','454',1898.16,1898.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233566',4491468,'2984','454',11317.26,11317.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','233566',4491469,'2985','455',7939.48,8172.09,232.61,75598.25,0.00,0.00,0.00,0.00,0.00),('1','122','1007','233566',4491470,'2986','455',8207.17,8207.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','233566',4491471,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','233566',4491472,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233771',4495003,'2961','454',48748.81,52090.74,3341.93,541392.66,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233771',4495004,'2962','454',3674.79,3674.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233771',4495005,'2963','454',4161.39,4161.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233771',4495006,'2964','454',20535.11,22670.80,2135.69,345981.78,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233771',4495007,'2965','454',878.18,878.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233771',4495008,'2966','454',38470.74,41217.13,2746.39,444915.18,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233771',4495009,'2967','454',2817.94,3874.33,1056.39,171135.18,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233771',4495010,'2968','454',26530.23,27960.11,1429.88,231640.56,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233771',4495011,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233771',4495012,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233771',4495013,'2971','454',23768.21,25419.75,1651.54,267549.48,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233771',4495014,'2972','454',840.18,840.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','233771',4495015,'2973','454',638.92,638.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','233771',4495016,'2974','454',29611.97,29612.50,0.53,85.86,0.00,0.00,0.00,0.00,0.00),('1','122','1005','233771',4495017,'2975','454',756.66,758.34,1.68,272.16,0.00,0.00,0.00,0.00,0.00),('1','122','1005','233771',4495018,'2976','454',13239.21,13362.81,123.60,20023.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233771',4495019,'2977','454',15631.15,15631.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233771',4495020,'2978','454',30523.56,30524.93,1.37,221.94,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233771',4495021,'2979','454',2599.93,2599.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233771',4495022,'2980','454',20926.34,20930.58,4.24,686.88,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233771',4495023,'2981','454',8952.93,8952.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233771',4495024,'2982','454',13191.89,13407.53,215.64,34933.68,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233771',4495025,'2983','454',1898.16,1898.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233771',4495026,'2984','454',11317.26,11320.22,2.96,479.52,0.00,0.00,0.00,0.00,0.00),('1','122','1007','233771',4495027,'2985','455',8172.09,8172.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','233771',4495028,'2986','455',8207.17,8207.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','233771',4495029,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','233771',4495030,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233783',4495245,'2961','454',52090.74,53086.84,996.10,161368.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233783',4495246,'2962','454',3674.79,5119.04,1444.25,233968.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233783',4495247,'2963','454',4161.39,5355.55,1194.16,193453.92,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233783',4495248,'2964','454',22670.80,23838.46,1167.66,189160.92,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233783',4495249,'2965','454',878.18,878.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233783',4495250,'2966','454',41217.13,42241.38,1024.25,165928.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233783',4495251,'2967','454',3874.33,3874.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233783',4495252,'2968','454',27960.11,29621.69,1661.58,269175.96,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233783',4495253,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233783',4495254,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233783',4495255,'2971','454',25419.75,26268.26,848.51,137458.62,0.00,0.00,0.00,0.00,0.00),('1','122','1004','233783',4495256,'2972','454',840.18,1240.42,400.24,64838.88,0.00,0.00,0.00,0.00,0.00),('1','122','1005','233783',4495257,'2973','454',638.92,638.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','233783',4495258,'2974','454',29612.50,29612.61,0.11,17.82,0.00,0.00,0.00,0.00,0.00),('1','122','1005','233783',4495259,'2975','454',758.34,758.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','233783',4495260,'2976','454',13362.81,13362.92,0.11,17.82,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233783',4495261,'2977','454',15631.15,15631.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233783',4495262,'2978','454',30524.93,30525.04,0.11,17.82,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233783',4495263,'2979','454',2599.93,2599.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233783',4495264,'2980','454',20930.58,20930.79,0.21,34.02,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233783',4495265,'2981','454',8952.93,8952.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233783',4495266,'2982','454',13407.53,13407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233783',4495267,'2983','454',1898.16,1898.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','233783',4495268,'2984','454',11320.22,11320.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','233783',4495269,'2985','455',8172.09,8172.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','233783',4495270,'2986','455',8207.17,8207.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','233783',4495271,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','233783',4495272,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234157',4501965,'2961','454',53086.84,53086.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234157',4501966,'2962','454',5119.04,8356.87,3237.83,524528.46,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234157',4501967,'2963','454',5355.55,7607.95,2252.40,364888.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234157',4501968,'2964','454',23838.46,26347.57,2509.11,406475.82,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234157',4501969,'2965','454',878.18,878.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234157',4501970,'2966','454',42241.38,44878.54,2637.16,427219.92,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234157',4501971,'2967','454',3874.33,4939.13,1064.80,172497.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234157',4501972,'2968','454',29621.69,31341.68,1719.99,278638.38,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234157',4501973,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234157',4501974,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234157',4501975,'2971','454',26268.26,27309.68,1041.42,168710.04,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234157',4501976,'2972','454',1240.42,2205.38,964.96,156323.52,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234157',4501977,'2973','454',638.92,638.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234157',4501978,'2974','454',29612.61,29612.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234157',4501979,'2975','454',758.34,758.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234157',4501980,'2976','454',13362.92,13362.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234157',4501981,'2977','454',15631.15,15631.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234157',4501982,'2978','454',30525.04,30525.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234157',4501983,'2979','454',2599.93,2599.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234157',4501984,'2980','454',20930.79,20930.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234157',4501985,'2981','454',8952.93,8952.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234157',4501986,'2982','454',13407.53,13407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234157',4501987,'2983','454',1898.16,1898.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234157',4501988,'2984','454',11320.22,11320.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234157',4501989,'2985','455',8172.09,8393.26,221.17,71880.25,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234157',4501990,'2986','455',8207.17,8207.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234157',4501991,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234157',4501992,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234172',4502301,'2961','454',53086.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234172',4502302,'2962','454',8356.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234172',4502303,'2963','454',7607.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234172',4502304,'2964','454',26347.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234172',4502305,'2965','454',878.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234172',4502306,'2966','454',44878.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234172',4502307,'2967','454',4939.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234172',4502308,'2968','454',31341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234172',4502309,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234172',4502310,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234172',4502311,'2971','454',27309.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234172',4502312,'2972','454',2205.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234172',4502313,'2973','454',638.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234172',4502314,'2974','454',29612.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234172',4502315,'2975','454',758.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234172',4502316,'2976','454',13362.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234172',4502317,'2977','454',15631.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234172',4502318,'2978','454',30525.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234172',4502319,'2979','454',2599.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234172',4502320,'2980','454',20930.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234172',4502321,'2981','454',8952.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234172',4502322,'2982','454',13407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234172',4502323,'2983','454',1898.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234172',4502324,'2984','454',11320.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234172',4502325,'2985','455',8393.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234172',4502326,'2986','455',8207.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234172',4502327,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234172',4502328,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234418',4506632,'2961','454',53086.84,53086.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234418',4506633,'2962','454',8356.87,14614.87,6258.00,1020054.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234418',4506634,'2963','454',7607.95,10025.53,2417.58,394065.54,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234418',4506635,'2964','454',26347.57,29086.66,2739.09,446471.67,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234418',4506636,'2965','454',878.18,2687.02,1808.84,294840.92,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234418',4506637,'2966','454',44878.54,47291.88,2413.34,393374.42,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234418',4506638,'2967','454',4939.13,4941.21,2.08,339.04,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234418',4506639,'2968','454',31341.68,33496.84,2155.16,351291.08,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234418',4506640,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234418',4506641,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234418',4506642,'2971','454',27309.68,29663.60,2353.92,383688.96,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234418',4506643,'2972','454',2205.38,2343.00,137.62,22432.06,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234418',4506644,'2973','454',638.92,638.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234418',4506645,'2974','454',29612.61,29613.18,0.57,92.91,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234418',4506646,'2975','454',758.34,758.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234418',4506647,'2976','454',13362.92,13362.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234418',4506648,'2977','454',15631.15,15631.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234418',4506649,'2978','454',30525.04,30525.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234418',4506650,'2979','454',2599.93,2599.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234418',4506651,'2980','454',20930.79,20930.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234418',4506652,'2981','454',8952.93,8952.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234418',4506653,'2982','454',13407.53,13407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234418',4506654,'2983','454',1898.16,1898.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234418',4506655,'2984','454',11320.22,11320.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234418',4506656,'2985','455',8393.26,9062.55,669.29,224212.15,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234418',4506657,'2986','455',8207.17,8207.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234418',4506658,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234418',4506659,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234431',4507005,'2961','454',53086.84,53086.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234431',4507006,'2962','454',14614.87,17381.45,2766.58,450952.54,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234431',4507007,'2963','454',10025.53,13231.87,3206.34,522633.42,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234431',4507008,'2964','454',29086.66,31909.72,2807.06,457550.78,0.00,0.00,16.00,0.00,0.00),('1','122','1004','234431',4507009,'2965','454',2687.02,2687.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234431',4507010,'2966','454',47291.88,49561.92,2270.04,370016.52,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234431',4507011,'2967','454',4941.21,4941.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234431',4507012,'2968','454',33496.84,35701.97,2205.13,359436.19,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234431',4507013,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234431',4507014,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234431',4507015,'2971','454',29663.60,30667.58,1003.98,163648.74,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234431',4507016,'2972','454',2343.00,2343.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234431',4507017,'2973','454',638.92,638.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234431',4507018,'2974','454',29613.18,29613.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234431',4507019,'2975','454',758.34,758.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234431',4507020,'2976','454',13362.92,13362.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234431',4507021,'2977','454',15631.15,18861.25,3230.10,526506.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234431',4507022,'2978','454',30525.04,30525.18,0.14,22.82,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234431',4507023,'2979','454',2599.93,2599.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234431',4507024,'2980','454',20930.79,23374.55,2443.76,398332.88,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234431',4507025,'2981','454',8952.93,8952.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234431',4507026,'2982','454',13407.53,15062.39,1654.86,269742.18,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234431',4507027,'2983','454',1898.16,1898.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234431',4507028,'2984','454',11320.22,12936.96,1616.74,263528.62,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234431',4507029,'2985','455',9062.55,9405.01,342.46,114724.10,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234431',4507030,'2986','455',8207.17,8207.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234431',4507031,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234431',4507032,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234714',4511815,'2961','454',53086.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234714',4511816,'2962','454',17381.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234714',4511817,'2963','454',13231.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234714',4511818,'2964','454',31909.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234714',4511819,'2965','454',2687.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234714',4511820,'2966','454',49561.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234714',4511821,'2967','454',4941.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234714',4511822,'2968','454',35701.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234714',4511823,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234714',4511824,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234714',4511825,'2971','454',30667.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234714',4511826,'2972','454',2343.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234714',4511827,'2973','454',638.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234714',4511828,'2974','454',29613.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234714',4511829,'2975','454',758.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234714',4511830,'2976','454',13362.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234714',4511831,'2977','454',18861.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234714',4511832,'2978','454',30525.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234714',4511833,'2979','454',2599.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234714',4511834,'2980','454',23374.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234714',4511835,'2981','454',8952.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234714',4511836,'2982','454',15062.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234714',4511837,'2983','454',1898.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234714',4511838,'2984','454',12936.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234714',4511839,'2985','455',9405.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234714',4511840,'2986','455',8207.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234714',4511841,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234714',4511842,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234729',4512106,'2961','454',53086.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234729',4512107,'2962','454',17381.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234729',4512108,'2963','454',13231.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234729',4512109,'2964','454',31909.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234729',4512110,'2965','454',2687.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234729',4512111,'2966','454',49561.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234729',4512112,'2967','454',4941.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234729',4512113,'2968','454',35701.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234729',4512114,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234729',4512115,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234729',4512116,'2971','454',30667.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234729',4512117,'2972','454',2343.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234729',4512118,'2973','454',638.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234729',4512119,'2974','454',29613.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234729',4512120,'2975','454',758.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234729',4512121,'2976','454',13362.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234729',4512122,'2977','454',18861.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234729',4512123,'2978','454',30525.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234729',4512124,'2979','454',2599.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234729',4512125,'2980','454',23374.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234729',4512126,'2981','454',8952.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234729',4512127,'2982','454',15062.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234729',4512128,'2983','454',1898.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234729',4512129,'2984','454',12936.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234729',4512130,'2985','455',9405.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234729',4512131,'2986','455',8207.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234729',4512132,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234729',4512133,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234753',4512553,'2961','454',53086.84,53086.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234753',4512554,'2962','454',17381.45,20230.25,2848.80,464354.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234753',4512555,'2963','454',13231.87,13231.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234753',4512556,'2964','454',31909.72,37050.62,5140.90,837966.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234753',4512557,'2965','454',2687.02,2687.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234753',4512558,'2966','454',49561.92,52525.57,2963.65,483074.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234753',4512559,'2967','454',4941.21,4941.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234753',4512560,'2968','454',35701.97,38645.99,2944.02,479875.26,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234753',4512561,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234753',4512562,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234753',4512563,'2971','454',30667.58,33338.78,2671.20,435405.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234753',4512564,'2972','454',2343.00,2343.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234753',4512565,'2973','454',638.92,638.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234753',4512566,'2974','454',29613.18,29613.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234753',4512567,'2975','454',758.34,758.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234753',4512568,'2976','454',13362.92,13362.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234753',4512569,'2977','454',18861.25,20224.99,1363.74,222289.62,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234753',4512570,'2978','454',30525.18,31681.57,1156.39,188491.57,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234753',4512571,'2979','454',2599.93,2599.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234753',4512572,'2980','454',23374.55,26904.75,3530.20,575422.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234753',4512573,'2981','454',8952.93,8952.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234753',4512574,'2982','454',15062.39,17043.47,1981.08,322916.04,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234753',4512575,'2983','454',1898.16,1898.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234753',4512576,'2984','454',12936.96,15238.02,2301.06,375072.78,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234753',4512577,'2985','455',9405.01,14614.69,5209.68,1797339.60,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234753',4512578,'2986','455',8207.17,8207.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234753',4512579,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234753',4512580,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234759',4512698,'2961','454',53086.84,53086.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234759',4512699,'2962','454',20230.25,20230.41,0.16,26.08,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234759',4512700,'2963','454',13231.87,13231.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234759',4512701,'2964','454',37050.62,41294.72,4244.10,691788.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234759',4512702,'2965','454',2687.02,2687.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234759',4512703,'2966','454',52525.57,54806.33,2280.76,371763.88,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234759',4512704,'2967','454',4941.21,4941.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234759',4512705,'2968','454',38645.99,41189.43,2543.44,414580.72,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234759',4512706,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234759',4512707,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234759',4512708,'2971','454',33338.78,35240.10,1901.32,309915.16,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234759',4512709,'2972','454',2343.00,2343.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234759',4512710,'2973','454',638.92,639.90,0.98,159.74,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234759',4512711,'2974','454',29613.18,29614.85,1.67,272.21,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234759',4512712,'2975','454',758.34,758.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234759',4512713,'2976','454',13362.92,13363.02,0.10,16.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234759',4512714,'2977','454',20224.99,20224.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234759',4512715,'2978','454',31681.57,35629.67,3948.10,643540.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234759',4512716,'2979','454',2599.93,2599.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234759',4512717,'2980','454',26904.75,30412.12,3507.37,571701.31,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234759',4512718,'2981','454',8952.93,8952.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234759',4512719,'2982','454',17043.47,18602.33,1558.86,254094.18,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234759',4512720,'2983','454',1898.16,1898.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234759',4512721,'2984','454',15238.02,15238.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234759',4512722,'2985','455',14614.69,15106.87,492.18,169802.10,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234759',4512723,'2986','455',8207.17,8207.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234759',4512724,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234759',4512725,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234760',4512726,'2961','454',53086.84,56168.94,3072.10,500752.30,0.00,0.00,10.00,0.00,0.00),('1','122','1004','234760',4512727,'2962','454',20230.41,20257.58,17.17,2798.71,0.00,0.00,10.00,0.00,0.00),('1','122','1004','234760',4512728,'2963','454',13231.87,13241.87,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','122','1004','234760',4512729,'2964','454',41294.72,41305.72,0.00,0.00,0.00,0.00,11.00,0.00,0.00),('1','122','1004','234760',4512730,'2965','454',2687.02,2697.02,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','122','1004','234760',4512731,'2966','454',54806.33,56741.17,1924.84,313748.92,0.00,0.00,10.00,0.00,0.00),('1','122','1004','234760',4512732,'2967','454',4941.21,4941.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234760',4512733,'2968','454',41189.43,42372.79,1173.36,191257.68,0.00,0.00,10.00,0.00,0.00),('1','122','1004','234760',4512734,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234760',4512735,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234760',4512736,'2971','454',35240.10,35560.67,310.57,50622.91,0.00,0.00,10.00,0.00,0.00),('1','122','1004','234760',4512737,'2972','454',2343.00,2343.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234760',4512738,'2973','454',639.90,667.90,0.00,0.00,0.00,0.00,28.00,0.00,0.00),('1','122','1005','234760',4512739,'2974','454',29614.85,29649.45,0.00,0.00,0.00,0.00,34.60,0.00,0.00),('1','122','1005','234760',4512740,'2975','454',758.34,1348.76,573.42,93467.46,0.00,0.00,17.00,0.00,0.00),('1','122','1005','234760',4512741,'2976','454',13363.02,13390.65,0.00,0.00,0.00,0.00,27.63,0.00,0.00),('1','122','1006','234760',4512742,'2977','454',20224.99,20234.99,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','122','1006','234760',4512743,'2978','454',35629.67,38406.81,2767.14,451043.82,0.00,0.00,10.00,0.00,0.00),('1','122','1006','234760',4512744,'2979','454',2599.93,2610.22,0.00,0.00,0.00,0.00,10.29,0.00,0.00),('1','122','1006','234760',4512745,'2980','454',30412.12,32308.97,1886.85,307556.55,0.00,0.00,10.00,0.00,0.00),('1','122','1006','234760',4512746,'2981','454',8952.93,8964.93,0.00,0.00,0.00,0.00,12.00,0.00,0.00),('1','122','1006','234760',4512747,'2982','454',18602.33,19531.06,918.73,149752.99,0.00,0.00,10.00,0.00,0.00),('1','122','1006','234760',4512748,'2983','454',1898.16,1910.17,0.00,0.00,0.00,0.00,12.01,0.00,0.00),('1','122','1006','234760',4512749,'2984','454',15238.02,15456.93,208.91,34052.33,0.00,0.00,10.00,0.00,0.00),('1','122','1007','234760',4512750,'2985','455',15106.87,15928.61,791.74,273150.30,0.00,0.00,30.00,0.00,0.00),('1','122','1007','234760',4512751,'2986','455',8207.17,8207.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234760',4512752,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234760',4512753,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234771',4512946,'2961','454',56168.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234771',4512947,'2962','454',20257.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234771',4512948,'2963','454',13241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234771',4512949,'2964','454',41305.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234771',4512950,'2965','454',2697.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234771',4512951,'2966','454',56741.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234771',4512952,'2967','454',4941.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234771',4512953,'2968','454',42372.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234771',4512954,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234771',4512955,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234771',4512956,'2971','454',35560.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234771',4512957,'2972','454',2343.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234771',4512958,'2973','454',667.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234771',4512959,'2974','454',29649.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234771',4512960,'2975','454',1348.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234771',4512961,'2976','454',13390.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234771',4512962,'2977','454',20234.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234771',4512963,'2978','454',38406.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234771',4512964,'2979','454',2610.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234771',4512965,'2980','454',32308.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234771',4512966,'2981','454',8964.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234771',4512967,'2982','454',19531.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234771',4512968,'2983','454',1910.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234771',4512969,'2984','454',15456.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234771',4512970,'2985','455',15928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234771',4512971,'2986','455',8207.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234771',4512972,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234771',4512973,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234789',4513312,'2961','454',56168.94,59389.58,3220.64,524964.32,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234789',4513313,'2962','454',20257.58,20257.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234789',4513314,'2963','454',13241.87,17139.82,3897.95,635365.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234789',4513315,'2964','454',41305.72,41305.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234789',4513316,'2965','454',2697.02,2697.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234789',4513317,'2966','454',56741.17,59658.49,2917.32,475523.16,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234789',4513318,'2967','454',4941.21,5505.56,564.35,91989.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234789',4513319,'2968','454',42372.79,45327.32,2954.53,481588.39,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234789',4513320,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234789',4513321,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234789',4513322,'2971','454',35560.67,35560.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234789',4513323,'2972','454',2343.00,2343.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234789',4513324,'2973','454',667.90,1426.68,758.78,123681.14,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234789',4513325,'2974','454',29649.45,29649.57,0.12,19.56,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234789',4513326,'2975','454',1348.76,1700.05,351.29,57260.27,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234789',4513327,'2976','454',13390.65,13390.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234789',4513328,'2977','454',20234.99,20234.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234789',4513329,'2978','454',38406.81,42352.13,3945.32,643087.16,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234789',4513330,'2979','454',2610.22,6002.64,3392.42,552964.46,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234789',4513331,'2980','454',32308.97,32308.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234789',4513332,'2981','454',8964.93,11412.29,2447.36,398919.68,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234789',4513333,'2982','454',19531.06,19531.17,0.11,17.93,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234789',4513334,'2983','454',1910.17,1910.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234789',4513335,'2984','454',15456.93,15456.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234789',4513336,'2985','455',15928.61,15928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234789',4513337,'2986','455',8172.09,8414.48,242.39,83624.55,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234789',4513338,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234789',4513339,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234791',4513368,'2961','454',59389.58,63079.13,3689.55,601396.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234791',4513369,'2962','454',20257.58,20257.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234791',4513370,'2963','454',17139.82,17139.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234791',4513371,'2964','454',41305.72,46609.17,5303.45,864462.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234791',4513372,'2965','454',2697.02,2697.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234791',4513373,'2966','454',59658.49,62137.72,2479.23,404114.49,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234791',4513374,'2967','454',5505.56,5505.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234791',4513375,'2968','454',45327.32,47736.30,2408.98,392663.74,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234791',4513376,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234791',4513377,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234791',4513378,'2971','454',35560.67,35560.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234791',4513379,'2972','454',2343.00,2343.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234791',4513380,'2973','454',1426.68,1426.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234791',4513381,'2974','454',29649.57,31089.20,1439.63,234659.69,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234791',4513382,'2975','454',1700.05,2482.78,782.73,127584.99,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234791',4513383,'2976','454',13390.65,15112.38,1721.73,280641.99,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234791',4513384,'2977','454',20234.99,20234.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234791',4513385,'2978','454',42352.13,45688.48,3336.35,543825.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234791',4513386,'2979','454',6002.64,8690.34,2687.70,438095.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234791',4513387,'2980','454',32308.97,32308.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234791',4513388,'2981','454',11412.29,11412.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234791',4513389,'2982','454',19531.17,20773.41,1242.24,202485.12,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234791',4513390,'2983','454',1910.17,1910.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234791',4513391,'2984','454',15456.93,15456.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234791',4513392,'2985','455',15928.61,15928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234791',4513393,'2986','455',8414.48,8733.14,318.66,109937.70,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234791',4513394,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234791',4513395,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234978',4516660,'2961','454',63079.13,66076.63,2997.50,488592.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234978',4516661,'2962','454',20257.58,20257.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234978',4516662,'2963','454',17139.82,21512.08,4372.26,712678.38,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234978',4516663,'2964','454',46609.17,46609.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234978',4516664,'2965','454',2697.02,4197.02,1500.00,244500.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234978',4516665,'2966','454',62137.72,63699.07,1561.35,254500.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234978',4516666,'2967','454',5505.56,5505.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234978',4516667,'2968','454',47736.30,51662.44,3926.14,639960.82,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234978',4516668,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234978',4516669,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234978',4516670,'2971','454',35560.67,35560.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','234978',4516671,'2972','454',2343.00,2343.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234978',4516672,'2973','454',1426.68,4049.95,2623.27,427593.01,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234978',4516673,'2974','454',31089.20,31089.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234978',4516674,'2975','454',2482.78,2482.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','234978',4516675,'2976','454',15112.38,15709.93,597.55,97400.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234978',4516676,'2977','454',20234.99,20234.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234978',4516677,'2978','454',45688.48,50544.91,4856.43,791598.09,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234978',4516678,'2979','454',8690.34,11689.03,2998.69,488786.47,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234978',4516679,'2980','454',32308.97,32308.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234978',4516680,'2981','454',11412.29,11412.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234978',4516681,'2982','454',20773.41,23301.23,2527.82,412034.66,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234978',4516682,'2983','454',1910.17,1910.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','234978',4516683,'2984','454',15456.93,15456.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234978',4516684,'2985','455',15928.61,18766.79,2838.18,979172.10,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234978',4516685,'2986','455',8733.14,11233.14,2500.00,862500.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234978',4516686,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','234978',4516687,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','235017',4517397,'2961','454',66076.63,70954.33,4877.70,795065.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','235017',4517398,'2962','454',20257.58,20257.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','235017',4517399,'2963','454',21512.08,21512.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','235017',4517400,'2964','454',46609.17,51654.62,5045.45,822408.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','235017',4517401,'2965','454',4197.02,4197.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','235017',4517402,'2966','454',63699.07,66704.94,3005.87,489956.81,0.00,0.00,0.00,0.00,0.00),('1','122','1004','235017',4517403,'2967','454',5505.56,5505.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','235017',4517404,'2968','454',51662.44,54456.60,2794.16,455448.08,0.00,0.00,0.00,0.00,0.00),('1','122','1004','235017',4517405,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','235017',4517406,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','235017',4517407,'2971','454',35560.67,35560.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','235017',4517408,'2972','454',2343.00,2343.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','235017',4517409,'2973','454',4049.95,4049.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','235017',4517410,'2974','454',31089.20,34081.91,2992.71,487811.73,0.00,0.00,0.00,0.00,0.00),('1','122','1005','235017',4517411,'2975','454',2482.78,2482.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','235017',4517412,'2976','454',15709.93,18414.75,2704.82,440885.66,0.00,0.00,0.00,0.00,0.00),('1','122','1006','235017',4517413,'2977','454',20234.99,20234.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','235017',4517414,'2978','454',50544.91,54237.15,3692.24,601835.12,0.00,0.00,0.00,0.00,0.00),('1','122','1006','235017',4517415,'2979','454',11689.03,11689.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','235017',4517416,'2980','454',32308.97,33469.60,1160.63,189182.69,0.00,0.00,0.00,0.00,0.00),('1','122','1006','235017',4517417,'2981','454',11412.29,11412.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','235017',4517418,'2982','454',23301.23,23866.47,565.24,92134.12,0.00,0.00,0.00,0.00,0.00),('1','122','1006','235017',4517419,'2983','454',1910.17,1910.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','235017',4517420,'2984','454',15456.93,15456.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','235017',4517421,'2985','455',18766.79,18766.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','235017',4517422,'2986','455',11233.14,11472.79,239.65,82679.25,0.00,0.00,0.00,0.00,0.00),('1','122','1007','235017',4517423,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','235017',4517424,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','235865',4532092,'2961','454',70954.33,75886.78,4882.45,795839.35,0.00,0.00,50.00,0.00,0.00),('1','122','1004','235865',4532093,'2962','454',20257.58,20277.58,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','122','1004','235865',4532094,'2963','454',21512.08,25666.31,4154.23,677139.49,0.00,0.00,0.00,0.00,0.00),('1','122','1004','235865',4532095,'2964','454',51654.62,55840.30,4185.68,682265.84,0.00,0.00,0.00,0.00,0.00),('1','122','1004','235865',4532096,'2965','454',4197.02,4197.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','235865',4532097,'2966','454',66704.94,70633.78,3898.84,635510.92,0.00,0.00,30.00,0.00,0.00),('1','122','1004','235865',4532098,'2967','454',5505.56,6536.81,1031.25,168093.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','235865',4532099,'2968','454',54456.60,57855.98,3399.38,554098.94,0.00,0.00,0.00,0.00,0.00),('1','122','1004','235865',4532100,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','235865',4532101,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','235865',4532102,'2971','454',35560.67,35560.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','235865',4532103,'2972','454',2343.00,2343.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','235865',4532104,'2973','454',4049.95,4049.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','235865',4532105,'2974','454',34081.91,37463.58,3381.67,551212.21,0.00,0.00,0.00,0.00,0.00),('1','122','1005','235865',4532106,'2975','454',2482.78,2482.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','235865',4532107,'2976','454',18414.75,21328.48,2913.73,474937.99,0.00,0.00,0.00,0.00,0.00),('1','122','1006','235865',4532108,'2977','454',20234.99,20265.66,30.67,4999.21,0.00,0.00,0.00,0.00,0.00),('1','122','1006','235865',4532109,'2978','454',54237.15,54273.89,36.74,5988.62,0.00,0.00,0.00,0.00,0.00),('1','122','1006','235865',4532110,'2979','454',11689.03,11689.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','235865',4532111,'2980','454',33469.60,38641.70,5142.10,838162.30,0.00,0.00,30.00,0.00,0.00),('1','122','1006','235865',4532112,'2981','454',11412.29,11412.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','235865',4532113,'2982','454',23866.47,23866.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','235865',4532114,'2983','454',1910.17,1910.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','235865',4532115,'2984','454',15456.93,15456.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','235865',4532116,'2985','455',18766.79,18926.33,79.54,27441.30,0.00,0.00,80.00,0.00,0.00),('1','122','1007','235865',4532117,'2986','455',11472.79,12131.45,598.66,206537.70,0.00,0.00,60.00,0.00,0.00),('1','122','1007','235865',4532118,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','235865',4532119,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236350',4540702,'2961','454',75886.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236350',4540703,'2962','454',20277.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236350',4540704,'2963','454',25666.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236350',4540705,'2964','454',55840.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236350',4540706,'2965','454',4197.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236350',4540707,'2966','454',70633.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236350',4540708,'2967','454',6536.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236350',4540709,'2968','454',57855.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236350',4540710,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236350',4540711,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236350',4540712,'2971','454',35560.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236350',4540713,'2972','454',2343.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','236350',4540714,'2973','454',4049.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','236350',4540715,'2974','454',37463.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','236350',4540716,'2975','454',2482.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1005','236350',4540717,'2976','454',21328.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236350',4540718,'2977','454',20265.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236350',4540719,'2978','454',54273.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236350',4540720,'2979','454',11689.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236350',4540721,'2980','454',38641.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236350',4540722,'2981','454',11412.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236350',4540723,'2982','454',23866.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236350',4540724,'2983','454',1910.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236350',4540725,'2984','454',15456.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236350',4540726,'2985','455',18926.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236350',4540727,'2986','455',12131.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236350',4540728,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236350',4540729,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236364',4540922,'2961','454',75886.78,77183.23,1296.45,211321.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236364',4540923,'2962','454',20277.58,21880.29,1602.71,261241.73,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236364',4540924,'2963','454',25666.31,26955.51,1289.20,210139.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236364',4540925,'2964','454',55840.30,60099.76,4259.46,694291.98,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236364',4540926,'2965','454',4197.02,5731.59,1534.57,250134.91,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236364',4540927,'2966','454',70633.78,74128.33,3494.55,569611.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236364',4540928,'2967','454',6536.81,8171.57,1634.76,266465.88,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236364',4540929,'2968','454',57855.98,61624.52,3768.54,614272.02,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236364',4540930,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236364',4540931,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236364',4540932,'2971','454',35560.67,35560.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236364',4540933,'2972','454',2343.00,2343.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236364',4540934,'2973','454',4049.95,4051.05,1.10,179.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236364',4540935,'2974','454',37463.58,40295.02,2831.44,461524.72,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236364',4540936,'2975','454',2482.78,2737.03,254.25,41442.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236364',4540937,'2976','454',21328.48,23746.78,2418.30,394182.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236364',4540938,'2977','454',20265.66,20265.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236364',4540939,'2978','454',54273.89,57374.41,3100.52,505384.76,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236364',4540940,'2979','454',11689.03,11689.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236364',4540941,'2980','454',38641.70,40579.53,1937.83,315866.29,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236364',4540942,'2981','454',11412.29,11412.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236364',4540943,'2982','454',23866.47,24619.83,753.36,122797.68,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236364',4540944,'2983','454',1910.17,1910.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236364',4540945,'2984','454',15456.93,15456.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236364',4540946,'2985','455',18926.33,20033.75,1107.42,382059.90,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236364',4540947,'2986','455',12131.45,12131.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236364',4540948,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236364',4540949,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236370',4541019,'2961','454',77183.23,77183.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236370',4541020,'2962','454',21880.29,25519.74,3639.45,593230.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236370',4541021,'2963','454',26955.51,28374.97,1419.46,231371.98,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236370',4541022,'2964','454',60099.76,63704.72,3604.96,587608.48,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236370',4541023,'2965','454',5731.59,8449.27,2717.68,442981.84,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236370',4541024,'2966','454',74128.33,75767.81,1639.48,267235.24,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236370',4541025,'2967','454',8171.57,8171.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236370',4541026,'2968','454',61624.52,64333.33,2708.81,441536.03,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236370',4541027,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236370',4541028,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236370',4541029,'2971','454',35560.67,35560.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236370',4541030,'2972','454',2343.00,2343.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236370',4541031,'2973','454',4051.05,4051.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236370',4541032,'2974','454',40295.02,40399.65,104.63,17054.69,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236370',4541033,'2975','454',2737.03,2737.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236370',4541034,'2976','454',23746.78,23746.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236370',4541035,'2977','454',20265.66,20265.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236370',4541036,'2978','454',57374.41,58324.19,949.78,154814.14,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236370',4541037,'2979','454',11689.03,11792.08,103.05,16797.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236370',4541038,'2980','454',40579.53,41308.00,728.47,118740.61,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236370',4541039,'2981','454',11412.29,11412.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236370',4541040,'2982','454',24619.83,25201.96,582.13,94887.19,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236370',4541041,'2983','454',1910.17,1910.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236370',4541042,'2984','454',15456.93,15456.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236370',4541043,'2985','455',20033.75,20033.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236370',4541044,'2986','455',12131.45,12906.32,774.87,267330.15,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236370',4541045,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236370',4541046,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236384',4541268,'2961','454',77183.23,80528.94,3345.71,545350.73,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236384',4541269,'2962','454',25519.74,25519.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236384',4541270,'2963','454',28374.97,29704.14,1329.17,216654.71,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236384',4541271,'2964','454',63704.72,66211.24,2506.52,408562.76,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236384',4541272,'2965','454',8449.27,8449.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236384',4541273,'2966','454',75767.81,78368.74,2600.93,423951.59,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236384',4541274,'2967','454',8171.57,8171.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236384',4541275,'2968','454',64333.33,65997.96,1664.63,271334.69,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236384',4541276,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236384',4541277,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236384',4541278,'2971','454',35560.67,35560.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236384',4541279,'2972','454',2343.00,2343.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236384',4541280,'2973','454',4051.05,5755.93,1704.88,277895.44,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236384',4541281,'2974','454',40399.65,42921.36,2521.71,411038.73,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236384',4541282,'2975','454',2737.03,4439.08,1702.05,277434.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236384',4541283,'2976','454',23746.78,25542.03,1795.25,292625.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236384',4541284,'2977','454',20265.66,22568.42,2302.76,375349.88,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236384',4541285,'2978','454',58324.19,65581.28,7257.09,1182905.67,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236384',4541286,'2979','454',11792.08,11792.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236384',4541287,'2980','454',41308.00,46492.71,5184.71,845107.73,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236384',4541288,'2981','454',11412.29,12748.88,1336.59,217864.17,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236384',4541289,'2982','454',25201.96,29389.58,4187.62,682582.06,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236384',4541290,'2983','454',1910.17,1910.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236384',4541291,'2984','454',15456.93,15456.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236384',4541292,'2985','455',20033.75,22403.64,2369.89,817612.05,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236384',4541293,'2986','455',12906.32,12906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236384',4541294,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236384',4541295,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236395',4541509,'2961','454',80528.94,86482.00,5943.06,968718.78,0.00,0.00,10.00,0.00,0.00),('1','122','1004','236395',4541510,'2962','454',25519.74,27631.56,2101.82,342596.66,0.00,0.00,10.00,0.00,0.00),('1','122','1004','236395',4541511,'2963','454',29704.14,35422.09,5707.95,930395.85,0.00,0.00,10.00,0.00,0.00),('1','122','1004','236395',4541512,'2964','454',66211.24,68251.58,2030.34,330945.42,0.00,0.00,10.00,0.00,0.00),('1','122','1004','236395',4541513,'2965','454',8449.27,13182.96,4723.69,769961.47,0.00,0.00,10.00,0.00,0.00),('1','122','1004','236395',4541514,'2966','454',78368.74,80203.22,1824.48,297390.24,0.00,0.00,10.00,0.00,0.00),('1','122','1004','236395',4541515,'2967','454',8171.57,8559.89,378.32,61666.16,0.00,0.00,10.00,0.00,0.00),('1','122','1004','236395',4541516,'2968','454',65997.96,71868.36,5860.40,955245.20,0.00,0.00,10.00,0.00,0.00),('1','122','1004','236395',4541517,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236395',4541518,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236395',4541519,'2971','454',35560.67,35560.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236395',4541520,'2972','454',2343.00,2343.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236395',4541521,'2973','454',5755.93,6522.14,736.21,120002.23,0.00,0.00,30.00,0.00,0.00),('1','122','1006','236395',4541522,'2974','454',42921.36,45101.02,2129.66,347134.58,0.00,0.00,50.00,0.00,0.00),('1','122','1006','236395',4541523,'2975','454',4439.08,4439.28,0.20,32.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236395',4541524,'2976','454',25542.03,25542.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236395',4541525,'2977','454',22568.42,24935.83,2327.41,379367.83,0.00,0.00,40.00,0.00,0.00),('1','122','1006','236395',4541526,'2978','454',65581.28,68615.45,2954.17,481529.71,0.00,0.00,80.00,0.00,0.00),('1','122','1006','236395',4541527,'2979','454',11792.08,12179.45,377.37,61511.31,0.00,0.00,10.00,0.00,0.00),('1','122','1006','236395',4541528,'2980','454',46492.71,49433.20,2930.49,477669.87,0.00,0.00,10.00,0.00,0.00),('1','122','1006','236395',4541529,'2981','454',12748.88,12945.20,176.32,28740.16,0.00,0.00,20.00,0.00,0.00),('1','122','1006','236395',4541530,'2982','454',29389.58,32028.18,2598.60,423571.80,0.00,0.00,40.00,0.00,0.00),('1','122','1006','236395',4541531,'2983','454',1910.17,1910.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236395',4541532,'2984','454',15456.93,15456.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236395',4541533,'2985','455',22403.64,22844.97,441.33,152258.85,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236395',4541534,'2986','455',12906.32,12906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236395',4541535,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236395',4541536,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236419',4541951,'2961','454',86482.00,90360.72,3878.72,632231.36,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236419',4541952,'2962','454',27631.56,27631.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236419',4541953,'2963','454',35422.09,40239.74,4817.65,785276.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236419',4541954,'2964','454',68251.58,68251.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236419',4541955,'2965','454',13182.96,13182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236419',4541956,'2966','454',80203.22,81021.69,818.47,133410.61,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236419',4541957,'2967','454',8559.89,8559.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236419',4541958,'2968','454',71868.36,73584.35,1715.99,279706.37,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236419',4541959,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236419',4541960,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236419',4541961,'2971','454',35560.67,35560.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236419',4541962,'2972','454',2343.00,2343.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236419',4541963,'2973','454',6522.14,6936.76,414.62,67583.06,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236419',4541964,'2974','454',45101.02,47519.16,2418.14,394156.82,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236419',4541965,'2975','454',4439.28,4439.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236419',4541966,'2976','454',25542.03,26710.96,1168.93,190535.59,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236419',4541967,'2977','454',24935.83,26444.87,1509.04,245973.52,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236419',4541968,'2978','454',68615.45,72621.10,4005.65,652920.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236419',4541969,'2979','454',12179.45,13073.19,893.74,145679.62,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236419',4541970,'2980','454',49433.20,52645.83,3212.63,523658.69,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236419',4541971,'2981','454',12945.20,12945.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236419',4541972,'2982','454',32028.18,34724.84,2696.66,439555.58,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236419',4541973,'2983','454',1910.17,1910.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236419',4541974,'2984','454',15456.93,15456.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236419',4541975,'2985','455',22844.97,23225.80,380.83,131386.35,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236419',4541976,'2986','455',12906.32,12906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236419',4541977,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236419',4541978,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236682',4546350,'2961','454',90360.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236682',4546351,'2962','454',27631.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236682',4546352,'2963','454',40239.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236682',4546353,'2964','454',68251.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236682',4546354,'2965','454',13182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236682',4546355,'2966','454',81021.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236682',4546356,'2967','454',8559.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236682',4546357,'2968','454',73584.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236682',4546358,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236682',4546359,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236682',4546360,'2971','454',35560.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236682',4546361,'2972','454',2343.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236682',4546362,'2973','454',6936.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236682',4546363,'2974','454',47519.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236682',4546364,'2975','454',4439.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236682',4546365,'2976','454',26710.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236682',4546366,'2977','454',26444.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236682',4546367,'2978','454',72621.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236682',4546368,'2979','454',13073.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236682',4546369,'2980','454',52645.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236682',4546370,'2981','454',12945.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236682',4546371,'2982','454',34724.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236682',4546372,'2983','454',1910.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236682',4546373,'2984','454',15456.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236682',4546374,'2985','455',23225.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236682',4546375,'2986','455',12906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236682',4546376,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236682',4546377,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236685',4546399,'2961','454',90360.72,90360.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236685',4546400,'2962','454',27631.56,27631.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236685',4546401,'2963','454',40239.74,40239.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236685',4546402,'2964','454',68251.58,68251.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236685',4546403,'2965','454',13182.96,13182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236685',4546404,'2966','454',81021.69,81021.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236685',4546405,'2967','454',8559.89,8559.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236685',4546406,'2968','454',73584.35,73584.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236685',4546407,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236685',4546408,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236685',4546409,'2971','454',35560.67,35560.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236685',4546410,'2972','454',2343.00,2343.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236685',4546411,'2973','454',6936.76,6938.40,1.64,270.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236685',4546412,'2974','454',47519.16,48369.55,850.39,140314.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236685',4546413,'2975','454',4439.28,4875.19,435.91,71925.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236685',4546414,'2976','454',26710.96,30915.53,4204.57,693754.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236685',4546415,'2977','454',26444.87,30876.66,4431.79,731245.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236685',4546416,'2978','454',72621.10,75977.17,3356.07,553751.55,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236685',4546417,'2979','454',13073.19,16008.56,2935.37,484336.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236685',4546418,'2980','454',52645.83,56212.27,3566.44,588462.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236685',4546419,'2981','454',12945.20,15455.19,2509.99,414148.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236685',4546420,'2982','454',34724.84,38011.93,3287.09,542369.85,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236685',4546421,'2983','454',1910.17,1910.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236685',4546422,'2984','454',15456.93,15456.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236685',4546423,'2985','455',23225.80,24247.88,1022.08,352617.60,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236685',4546424,'2986','455',12906.32,12906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236685',4546425,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236685',4546426,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236994',4551722,'2961','454',90360.72,94440.81,4080.09,673214.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236994',4551723,'2962','454',27631.56,30966.89,3335.33,550329.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236994',4551724,'2963','454',40239.74,44475.64,4235.90,698923.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236994',4551725,'2964','454',68251.58,71596.30,3314.72,546928.80,0.00,0.00,30.00,0.00,0.00),('1','122','1004','236994',4551726,'2965','454',13182.96,13265.30,82.34,13586.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236994',4551727,'2966','454',81021.69,86556.62,5534.93,913263.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236994',4551728,'2967','454',8559.89,11857.63,3287.74,542477.10,0.00,0.00,10.00,0.00,0.00),('1','122','1004','236994',4551729,'2968','454',73584.35,80290.83,6706.48,1106569.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236994',4551730,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236994',4551731,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','236994',4551732,'2971','454',35560.67,35560.67,-48.98,-8081.70,0.00,0.00,48.98,0.00,0.00),('1','122','1004','236994',4551733,'2972','454',2343.00,2343.00,-40.00,-6600.00,0.00,0.00,40.00,0.00,0.00),('1','122','1006','236994',4551734,'2973','454',6938.40,6938.50,0.10,16.50,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236994',4551735,'2974','454',48369.55,48642.54,272.99,45043.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236994',4551736,'2975','454',4875.19,4875.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236994',4551737,'2976','454',30915.53,31730.59,815.06,134484.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236994',4551738,'2977','454',30876.66,30876.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236994',4551739,'2978','454',75977.17,77415.42,1438.25,237311.25,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236994',4551740,'2979','454',16008.56,16008.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236994',4551741,'2980','454',56212.27,57351.61,1139.34,187991.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236994',4551742,'2981','454',15455.19,15455.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236994',4551743,'2982','454',38011.93,38011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236994',4551744,'2983','454',1910.17,1910.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','236994',4551745,'2984','454',15456.93,15456.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236994',4551746,'2985','455',24247.88,25496.44,1248.56,430753.20,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236994',4551747,'2986','455',12906.32,13656.32,750.00,258750.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236994',4551748,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','236994',4551749,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237211',4555558,'2961','454',94440.81,96953.23,2512.42,414549.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237211',4555559,'2962','454',30966.89,30966.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237211',4555560,'2963','454',44475.64,44475.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237211',4555561,'2964','454',71596.30,73135.93,1539.63,254038.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237211',4555562,'2965','454',13265.30,14822.27,1556.97,256900.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237211',4555563,'2966','454',86556.62,88354.11,1797.49,296585.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237211',4555564,'2967','454',11857.63,11857.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237211',4555565,'2968','454',80290.83,82357.10,2066.27,340934.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237211',4555566,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237211',4555567,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237211',4555568,'2971','454',35560.67,39761.04,4200.37,693061.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237211',4555569,'2972','454',2343.00,2343.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237211',4555570,'2973','454',6938.50,6938.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237211',4555571,'2974','454',48642.54,48642.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237211',4555572,'2975','454',4875.19,4875.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237211',4555573,'2976','454',31730.59,31730.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237211',4555574,'2977','454',30876.66,30876.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237211',4555575,'2978','454',77415.42,77415.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237211',4555576,'2979','454',16008.56,16008.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237211',4555577,'2980','454',57351.61,57351.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237211',4555578,'2981','454',15455.19,15455.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237211',4555579,'2982','454',38011.93,38011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237211',4555580,'2983','454',1910.17,1910.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237211',4555581,'2984','454',15456.93,15456.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','237211',4555582,'2985','455',25496.44,26906.86,1410.42,486594.90,0.00,0.00,0.00,0.00,0.00),('1','122','1007','237211',4555583,'2986','455',13656.32,13656.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','237211',4555584,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','237211',4555585,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237311',4557598,'2961','454',96953.23,103028.83,6075.60,1002474.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237311',4557599,'2962','454',30966.89,36475.35,5508.46,908895.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237311',4557600,'2963','454',44475.64,44475.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237311',4557601,'2964','454',73135.93,73135.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237311',4557602,'2965','454',14822.27,17879.09,3056.82,504375.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237311',4557603,'2966','454',88354.11,97769.15,9415.04,1553481.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237311',4557604,'2967','454',11857.63,11857.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237311',4557605,'2968','454',82357.10,82357.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237311',4557606,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237311',4557607,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237311',4557608,'2971','454',39761.04,44037.81,4276.77,705667.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237311',4557609,'2972','454',2343.00,8751.09,6408.09,1057334.85,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237311',4557610,'2973','454',6938.50,6938.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237311',4557611,'2974','454',48642.54,48642.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237311',4557612,'2975','454',4875.19,4875.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237311',4557613,'2976','454',31730.59,31730.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237311',4557614,'2977','454',30876.66,30876.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237311',4557615,'2978','454',77415.42,77415.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237311',4557616,'2979','454',16008.56,16008.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237311',4557617,'2980','454',57351.61,57351.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237311',4557618,'2981','454',15455.19,15455.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237311',4557619,'2982','454',38011.93,38011.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237311',4557620,'2983','454',1910.17,1910.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237311',4557621,'2984','454',15456.93,15456.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','237311',4557622,'2985','455',26906.86,28777.10,1870.24,645232.80,0.00,0.00,0.00,0.00,0.00),('1','122','1007','237311',4557623,'2986','455',13656.32,13656.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','237311',4557624,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','237311',4557625,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237657',4563473,'2961','454',103028.83,108982.03,5953.20,982278.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237657',4563474,'2962','454',36475.35,37722.11,1246.76,205715.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237657',4563475,'2963','454',44475.64,45190.67,715.03,117979.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237657',4563476,'2964','454',73135.93,73674.55,538.62,88872.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237657',4563477,'2965','454',17879.09,18220.02,340.93,56253.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237657',4563478,'2966','454',97769.15,103027.16,5258.01,867571.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237657',4563479,'2967','454',11857.63,11857.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237657',4563480,'2968','454',82357.10,86881.04,4523.94,746450.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237657',4563481,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237657',4563482,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237657',4563483,'2971','454',44037.81,47738.05,3700.24,610539.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237657',4563484,'2972','454',8751.09,9938.29,1177.20,194238.00,0.00,0.00,10.00,0.00,0.00),('1','122','1006','237657',4563485,'2973','454',6938.50,6938.74,0.24,39.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237657',4563486,'2974','454',48642.54,52979.05,4336.51,715524.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237657',4563487,'2975','454',4875.19,8986.38,4111.19,678346.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237657',4563488,'2976','454',31730.59,31730.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237657',4563489,'2977','454',30876.66,30876.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237657',4563490,'2978','454',77415.42,81052.90,3637.48,600184.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237657',4563491,'2979','454',16008.56,16008.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237657',4563492,'2980','454',57351.61,57351.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237657',4563493,'2981','454',15455.19,15455.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237657',4563494,'2982','454',38011.93,38012.09,0.16,26.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237657',4563495,'2983','454',1910.17,2325.67,405.50,66907.50,0.00,0.00,10.00,0.00,0.00),('1','122','1006','237657',4563496,'2984','454',15456.93,17841.03,2374.10,391726.50,0.00,0.00,10.00,0.00,0.00),('1','122','1007','237657',4563497,'2985','455',28777.10,31810.55,3033.45,1046540.25,0.00,0.00,0.00,0.00,0.00),('1','122','1007','237657',4563498,'2986','455',13656.32,13656.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','237657',4563499,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','237657',4563500,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237917',4567787,'2961','454',108982.03,112169.36,3187.33,525909.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237917',4567788,'2962','454',37722.11,39234.01,1511.90,249463.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237917',4567789,'2963','454',45190.67,51701.89,6511.22,1074351.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237917',4567790,'2964','454',73674.55,75115.28,1440.73,237720.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237917',4567791,'2965','454',18220.02,18220.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237917',4567792,'2966','454',103027.16,106985.19,3958.03,653074.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237917',4567793,'2967','454',11857.63,14911.21,3053.58,503840.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237917',4567794,'2968','454',86881.04,91741.48,4860.44,801972.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237917',4567795,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237917',4567796,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237917',4567797,'2971','454',47738.05,50593.34,2855.29,471122.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','237917',4567798,'2972','454',9938.29,10206.89,268.60,44319.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237917',4567799,'2973','454',6938.74,6938.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237917',4567800,'2974','454',52979.05,52979.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237917',4567801,'2975','454',8986.38,8986.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237917',4567802,'2976','454',31730.59,31730.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237917',4567803,'2977','454',30876.66,30876.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237917',4567804,'2978','454',81052.90,81052.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237917',4567805,'2979','454',16008.56,16008.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237917',4567806,'2980','454',57351.61,57351.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237917',4567807,'2981','454',15455.19,15455.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237917',4567808,'2982','454',38012.09,38012.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237917',4567809,'2983','454',2325.67,2325.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','237917',4567810,'2984','454',17841.03,17841.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','237917',4567811,'2985','455',31810.55,32192.00,381.45,131600.25,0.00,0.00,0.00,0.00,0.00),('1','122','1007','237917',4567812,'2986','455',13656.32,13656.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','237917',4567813,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','237917',4567814,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238072',4570449,'2961','454',112169.36,116592.95,4423.59,729892.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238072',4570450,'2962','454',39234.01,44536.83,5302.82,874965.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238072',4570451,'2963','454',51701.89,56913.33,5211.44,859887.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238072',4570452,'2964','454',75115.28,76049.66,934.38,154172.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238072',4570453,'2965','454',18220.02,21565.24,3345.22,551961.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238072',4570454,'2966','454',106985.19,111769.53,4784.34,789416.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238072',4570455,'2967','454',14911.21,18559.60,3648.39,601984.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238072',4570456,'2968','454',91741.48,94074.08,2332.60,384879.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238072',4570457,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238072',4570458,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238072',4570459,'2971','454',50593.34,57456.50,6863.16,1132421.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238072',4570460,'2972','454',10206.89,12752.12,2545.23,419962.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238072',4570461,'2973','454',6938.74,6938.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238072',4570462,'2974','454',52979.05,52979.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238072',4570463,'2975','454',8986.38,8986.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238072',4570464,'2976','454',31730.59,31730.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238072',4570465,'2977','454',30876.66,30876.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238072',4570466,'2978','454',81052.90,81052.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238072',4570467,'2979','454',16008.56,16008.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238072',4570468,'2980','454',57351.61,57351.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238072',4570469,'2981','454',15455.19,15455.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238072',4570470,'2982','454',38012.09,38012.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238072',4570471,'2983','454',2325.67,2325.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238072',4570472,'2984','454',17841.03,17841.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','238072',4570473,'2985','455',32192.00,32192.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','238072',4570474,'2986','455',13656.32,13656.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','238072',4570475,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','238072',4570476,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238411',4576221,'2961','454',116592.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238411',4576222,'2962','454',44536.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238411',4576223,'2963','454',56913.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238411',4576224,'2964','454',76049.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238411',4576225,'2965','454',21565.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238411',4576226,'2966','454',111769.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238411',4576227,'2967','454',18559.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238411',4576228,'2968','454',94074.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238411',4576229,'2969','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238411',4576230,'2970','454',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238411',4576231,'2971','454',57456.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238411',4576232,'2972','454',12752.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238411',4576233,'2973','454',6938.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238411',4576234,'2974','454',52979.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238411',4576235,'2975','454',8986.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238411',4576236,'2976','454',31730.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238411',4576237,'2977','454',30876.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238411',4576238,'2978','454',81052.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238411',4576239,'2979','454',16008.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238411',4576240,'2980','454',57351.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238411',4576241,'2981','454',15455.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238411',4576242,'2982','454',38012.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238411',4576243,'2983','454',2325.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238411',4576244,'2984','454',17841.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','238411',4576245,'2985','455',32192.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','238411',4576246,'2986','455',13656.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','238411',4576247,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','238411',4576248,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238722',4581441,'2961','454',116592.95,118235.43,1642.48,271009.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238722',4581442,'2962','454',44536.83,44536.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238722',4581443,'2963','454',56913.33,56913.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238722',4581444,'2964','454',76049.66,78074.70,2025.04,334131.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238722',4581445,'2965','454',21565.24,21565.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238722',4581446,'2966','454',111769.53,113292.62,1523.09,251309.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238722',4581447,'2967','454',18559.60,19488.34,928.74,153242.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238722',4581448,'2968','454',94074.08,95572.62,1498.54,247259.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238722',4581449,'2969','454',607.87,660.37,52.50,8662.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238722',4581450,'2970','454',785.53,1338.59,553.06,91254.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238722',4581451,'2971','454',57456.50,59237.53,1781.03,293869.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238722',4581452,'2972','454',12752.12,12752.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238722',4581453,'2973','454',6938.74,6938.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238722',4581454,'2974','454',52979.05,52979.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238722',4581455,'2975','454',8986.38,8986.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238722',4581456,'2976','454',31730.59,31730.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238722',4581457,'2977','454',30876.66,30876.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238722',4581458,'2978','454',81052.90,81052.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238722',4581459,'2979','454',16008.56,16008.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238722',4581460,'2980','454',57351.61,57351.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238722',4581461,'2981','454',15455.19,15455.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238722',4581462,'2982','454',38012.09,38012.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238722',4581463,'2983','454',2325.67,2325.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238722',4581464,'2984','454',17841.03,17841.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','238722',4581465,'2985','455',32192.00,32898.44,625.24,215707.80,0.00,0.00,81.20,0.00,0.00),('1','122','1007','238722',4581466,'2986','455',13656.32,13656.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','238722',4581467,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','238722',4581468,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238737',4581671,'2961','454',118235.43,126830.62,8595.19,1418206.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238737',4581672,'2962','454',44536.83,44536.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238737',4581673,'2963','454',56913.33,56913.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238737',4581674,'2964','454',78074.70,78074.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238737',4581675,'2965','454',21565.24,21565.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238737',4581676,'2966','454',113292.62,117960.80,4668.18,770249.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238737',4581677,'2967','454',19488.34,19841.10,352.76,58205.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238737',4581678,'2968','454',95572.62,102378.46,6805.84,1122963.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238737',4581679,'2969','454',660.37,660.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238737',4581680,'2970','454',1338.59,1338.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238737',4581681,'2971','454',59237.53,63991.73,4754.20,784443.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238737',4581682,'2972','454',12752.12,15793.66,3041.54,501854.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238737',4581683,'2973','454',6938.74,6938.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238737',4581684,'2974','454',52979.05,56830.97,3851.92,635566.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238737',4581685,'2975','454',8986.38,8986.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238737',4581686,'2976','454',31730.59,31730.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238737',4581687,'2977','454',30876.66,30877.07,0.41,67.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238737',4581688,'2978','454',81052.90,87069.71,6016.81,992773.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238737',4581689,'2979','454',16008.56,23144.97,7136.41,1177507.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238737',4581690,'2980','454',57351.61,57351.72,0.11,18.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238737',4581691,'2981','454',15455.19,15746.00,290.81,47983.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238737',4581692,'2982','454',38012.09,39892.32,1880.23,310237.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238737',4581693,'2983','454',2325.67,2325.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238737',4581694,'2984','454',17841.03,24226.45,6385.42,1053594.30,0.00,0.00,0.00,0.00,0.00),('1','122','1007','238737',4581695,'2985','455',32898.44,34059.85,1161.41,400686.45,0.00,0.00,0.00,0.00,0.00),('1','122','1007','238737',4581696,'2986','455',13656.32,14267.36,611.04,210808.80,0.00,0.00,0.00,0.00,0.00),('1','122','1007','238737',4581697,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','238737',4581698,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238941',4585404,'2961','454',126830.62,131228.28,4397.66,725613.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238941',4585405,'2962','454',44536.83,44536.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238941',4585406,'2963','454',56913.33,59579.76,2666.43,439960.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238941',4585407,'2964','454',78074.70,78074.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238941',4585408,'2965','454',21565.24,21565.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238941',4585409,'2966','454',117960.80,124273.00,6312.20,1041513.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238941',4585410,'2967','454',19841.10,19841.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238941',4585411,'2968','454',102378.46,102378.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238941',4585412,'2969','454',660.37,660.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238941',4585413,'2970','454',1338.59,1338.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238941',4585414,'2971','454',63991.73,67065.00,3073.27,507089.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','238941',4585415,'2972','454',15793.66,15793.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238941',4585416,'2973','454',6938.74,7659.33,720.59,118897.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238941',4585417,'2974','454',56830.97,56830.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238941',4585418,'2975','454',8986.38,8986.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238941',4585419,'2976','454',31730.59,36676.50,4945.91,816075.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238941',4585420,'2977','454',30877.07,35518.45,4641.38,765827.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238941',4585421,'2978','454',87069.71,87069.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238941',4585422,'2979','454',23144.97,23424.43,279.46,46110.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238941',4585423,'2980','454',57351.72,58003.92,652.20,107613.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238941',4585424,'2981','454',15746.00,16756.88,1010.88,166795.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238941',4585425,'2982','454',39892.32,39892.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238941',4585426,'2983','454',2325.67,5973.75,3648.08,601933.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','238941',4585427,'2984','454',24226.45,24226.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','238941',4585428,'2985','455',34059.85,34469.48,409.63,141322.35,0.00,0.00,0.00,0.00,0.00),('1','122','1007','238941',4585429,'2986','455',14267.36,14267.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','238941',4585430,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','238941',4585431,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239123',4588608,'2961','454',131228.28,133289.62,2061.34,340121.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239123',4588609,'2962','454',44536.83,44536.94,0.11,18.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239123',4588610,'2963','454',59579.76,62033.97,2454.21,404944.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239123',4588611,'2964','454',78074.70,80455.23,2380.53,392787.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239123',4588612,'2965','454',21565.24,24106.23,2540.99,419263.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239123',4588613,'2966','454',124273.00,124273.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239123',4588614,'2967','454',19841.10,21631.30,1790.20,295383.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239123',4588615,'2968','454',102378.46,104744.28,2365.82,390360.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239123',4588616,'2969','454',660.37,660.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239123',4588617,'2970','454',1338.59,1338.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239123',4588618,'2971','454',67065.00,69569.60,2504.60,413259.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239123',4588619,'2972','454',15793.66,17084.05,1290.39,212914.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239123',4588620,'2973','454',7659.33,8671.74,1012.41,167047.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239123',4588621,'2974','454',56830.97,58081.40,1250.43,206320.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239123',4588622,'2975','454',8986.38,10189.39,1203.01,198496.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239123',4588623,'2976','454',36676.50,37670.40,993.90,163993.50,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239123',4588624,'2977','454',35518.45,36466.11,947.66,156363.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239123',4588625,'2978','454',87069.71,87069.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239123',4588626,'2979','454',23424.43,23424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239123',4588627,'2980','454',58003.92,58003.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239123',4588628,'2981','454',16756.88,16756.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239123',4588629,'2982','454',39892.32,41591.62,1699.30,280384.50,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239123',4588630,'2983','454',5973.75,7215.94,1242.19,204961.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239123',4588631,'2984','454',24226.45,24348.38,121.93,20118.45,0.00,0.00,0.00,0.00,0.00),('1','122','1007','239123',4588632,'2985','455',34469.48,35222.53,753.05,259802.25,0.00,0.00,0.00,0.00,0.00),('1','122','1007','239123',4588633,'2986','455',14267.36,14354.32,86.96,30001.20,0.00,0.00,0.00,0.00,0.00),('1','122','1007','239123',4588634,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','239123',4588635,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239338',4592274,'2961','454',133289.62,134126.51,836.89,138086.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239338',4592275,'2962','454',44536.94,45783.32,1246.38,205652.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239338',4592276,'2963','454',62033.97,62947.94,913.97,150805.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239338',4592277,'2964','454',80455.23,81138.92,683.69,112808.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239338',4592278,'2965','454',24106.23,25377.57,1271.34,209771.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239338',4592279,'2966','454',124273.00,125230.93,957.93,158058.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239338',4592280,'2967','454',21631.30,21819.58,188.28,31066.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239338',4592281,'2968','454',104744.28,105941.09,1196.81,197473.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239338',4592282,'2969','454',660.37,660.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239338',4592283,'2970','454',1338.59,1338.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239338',4592284,'2971','454',69569.60,70545.02,975.42,160944.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239338',4592285,'2972','454',17084.05,17680.97,596.92,98491.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239338',4592286,'2973','454',8671.74,8671.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239338',4592287,'2974','454',58081.40,58081.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239338',4592288,'2975','454',10189.39,10189.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239338',4592289,'2976','454',37670.40,37670.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239338',4592290,'2977','454',36466.11,36466.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239338',4592291,'2978','454',87069.71,87069.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239338',4592292,'2979','454',23424.43,23424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239338',4592293,'2980','454',58003.92,58003.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239338',4592294,'2981','454',16756.88,16756.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239338',4592295,'2982','454',41591.62,41591.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239338',4592296,'2983','454',7215.94,7215.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239338',4592297,'2984','454',24348.38,24348.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','239338',4592298,'2985','455',35222.53,36822.82,1600.29,552100.05,0.00,0.00,0.00,0.00,0.00),('1','122','1007','239338',4592299,'2986','455',14354.32,15854.32,1500.00,517500.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','239338',4592300,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','239338',4592301,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239571',4596165,'2961','454',134126.51,134126.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239571',4596166,'2962','454',45783.32,45783.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239571',4596167,'2963','454',62947.94,62947.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239571',4596168,'2964','454',81138.92,85817.38,4678.46,771945.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239571',4596169,'2965','454',25377.57,30836.16,5458.59,900667.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239571',4596170,'2966','454',125230.93,131971.05,6720.12,1108819.80,0.00,0.00,20.00,0.00,0.00),('1','122','1004','239571',4596171,'2967','454',21819.58,21819.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239571',4596172,'2968','454',105941.09,105941.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239571',4596173,'2969','454',660.37,7949.06,7288.69,1202633.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239571',4596174,'2970','454',1338.59,8579.02,7220.43,1191370.95,0.00,0.00,20.00,0.00,0.00),('1','122','1004','239571',4596175,'2971','454',70545.02,78990.06,8445.04,1393431.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239571',4596176,'2972','454',17680.97,20862.69,3181.72,524983.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239571',4596177,'2973','454',8671.74,8671.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239571',4596178,'2974','454',58081.40,58081.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239571',4596179,'2975','454',10189.39,10189.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239571',4596180,'2976','454',37670.40,37670.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239571',4596181,'2977','454',36466.11,36466.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239571',4596182,'2978','454',87069.71,87069.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239571',4596183,'2979','454',23424.43,23424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239571',4596184,'2980','454',58003.92,58003.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239571',4596185,'2981','454',16756.88,16756.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239571',4596186,'2982','454',41591.62,41591.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239571',4596187,'2983','454',7215.94,7215.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239571',4596188,'2984','454',24348.38,24348.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','239571',4596189,'2985','455',36822.82,37033.55,210.73,72701.85,0.00,0.00,0.00,0.00,0.00),('1','122','1007','239571',4596190,'2986','455',15854.32,15902.16,47.84,16504.80,0.00,0.00,0.00,0.00,0.00),('1','122','1007','239571',4596191,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','239571',4596192,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239820',4600572,'2961','454',134126.51,134126.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239820',4600573,'2962','454',45783.32,45783.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239820',4600574,'2963','454',62947.94,67340.06,4392.12,724699.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239820',4600575,'2964','454',85817.38,85817.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239820',4600576,'2965','454',30836.16,30836.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239820',4600577,'2966','454',131971.05,131971.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239820',4600578,'2967','454',21819.58,24399.26,2579.68,425647.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239820',4600579,'2968','454',105941.09,109680.55,3739.46,617010.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239820',4600580,'2969','454',7949.06,11338.51,3389.45,559259.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239820',4600581,'2970','454',8579.02,10759.88,2180.86,359841.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239820',4600582,'2971','454',78990.06,81495.63,2505.57,413419.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','239820',4600583,'2972','454',20862.69,22098.35,1235.66,203883.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239820',4600584,'2973','454',8671.74,8671.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239820',4600585,'2974','454',58081.40,58081.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239820',4600586,'2975','454',10189.39,10189.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239820',4600587,'2976','454',37670.40,37670.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239820',4600588,'2977','454',36466.11,36466.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239820',4600589,'2978','454',87069.71,87069.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239820',4600590,'2979','454',23424.43,23424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239820',4600591,'2980','454',58003.92,58003.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239820',4600592,'2981','454',16756.88,16756.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239820',4600593,'2982','454',41591.62,41591.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239820',4600594,'2983','454',7215.94,7215.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','239820',4600595,'2984','454',24348.38,24348.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','239820',4600596,'2985','455',37033.55,37654.61,621.06,214265.70,0.00,0.00,0.00,0.00,0.00),('1','122','1007','239820',4600597,'2986','455',15902.16,15902.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','239820',4600598,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','239820',4600599,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240042',4604401,'2961','454',134126.51,138388.25,4211.74,694937.10,0.00,0.00,50.00,0.00,0.00),('1','122','1004','240042',4604402,'2962','454',45783.32,51252.93,5449.61,899185.65,0.00,0.00,20.00,0.00,0.00),('1','122','1004','240042',4604403,'2963','454',67340.06,67340.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240042',4604404,'2964','454',85817.38,85817.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240042',4604405,'2965','454',30836.16,35271.37,4405.21,726859.65,0.00,0.00,30.00,0.00,0.00),('1','122','1004','240042',4604406,'2966','454',131971.05,137523.27,5552.22,916116.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240042',4604407,'2967','454',24399.26,24399.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240042',4604408,'2968','454',109680.55,109680.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240042',4604409,'2969','454',11338.51,14475.59,3137.08,517618.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240042',4604410,'2970','454',10759.88,15832.51,5072.63,836983.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240042',4604411,'2971','454',81495.63,81867.07,371.44,61287.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240042',4604412,'2972','454',22098.35,22395.47,297.12,49024.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240042',4604413,'2973','454',8671.74,8671.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240042',4604414,'2974','454',58081.40,58081.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240042',4604415,'2975','454',10189.39,10189.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240042',4604416,'2976','454',37670.40,37670.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240042',4604417,'2977','454',36466.11,36466.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240042',4604418,'2978','454',87069.71,87069.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240042',4604419,'2979','454',23424.43,23424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240042',4604420,'2980','454',58003.92,58003.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240042',4604421,'2981','454',16756.88,16757.20,0.32,52.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240042',4604422,'2982','454',41591.62,41591.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240042',4604423,'2983','454',7215.94,7215.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240042',4604424,'2984','454',24348.38,24348.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','240042',4604425,'2985','455',37654.61,41116.84,3432.23,1184119.35,0.00,0.00,30.00,0.00,0.00),('1','122','1007','240042',4604426,'2986','455',15902.16,18401.07,2478.91,855223.95,0.00,0.00,20.00,0.00,0.00),('1','122','1007','240042',4604427,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','240042',4604428,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240259',4608255,'2961','454',138388.25,138388.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240259',4608256,'2962','454',51252.93,51252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240259',4608257,'2963','454',67340.06,67340.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240259',4608258,'2964','454',85817.38,85817.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240259',4608259,'2965','454',35271.37,35271.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240259',4608260,'2966','454',137523.27,137523.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240259',4608261,'2967','454',24399.26,24399.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240259',4608262,'2968','454',109680.55,109680.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240259',4608263,'2969','454',14475.59,14475.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240259',4608264,'2970','454',15832.51,15832.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240259',4608265,'2971','454',81867.07,81867.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240259',4608266,'2972','454',22395.47,22395.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240259',4608267,'2973','454',8671.74,11520.79,2849.05,470093.25,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240259',4608268,'2974','454',58081.40,60629.79,2548.39,420484.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240259',4608269,'2975','454',10189.39,11541.32,1351.93,223068.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240259',4608270,'2976','454',37670.40,43531.71,5861.31,967116.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240259',4608271,'2977','454',36466.11,36466.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240259',4608272,'2978','454',87069.71,87069.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240259',4608273,'2979','454',23424.43,26290.23,2865.80,472857.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240259',4608274,'2980','454',58003.92,62274.94,4271.02,704718.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240259',4608275,'2981','454',16757.20,16757.33,0.13,21.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240259',4608276,'2982','454',41591.62,41591.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240259',4608277,'2983','454',7215.94,9919.55,2703.61,446095.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240259',4608278,'2984','454',24348.38,27427.03,3078.65,507977.25,0.00,0.00,0.00,0.00,0.00),('1','122','1007','240259',4608279,'2985','455',41116.84,41737.90,621.06,214265.70,0.00,0.00,0.00,0.00,0.00),('1','122','1007','240259',4608280,'2986','455',18401.07,18401.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','240259',4608281,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','240259',4608282,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240522',4612456,'2961','454',138388.25,138388.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240522',4612457,'2962','454',51252.93,51252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240522',4612458,'2963','454',67340.06,67881.66,541.60,89364.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240522',4612459,'2964','454',85817.38,87087.80,1270.42,209619.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240522',4612460,'2965','454',35271.37,35271.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240522',4612461,'2966','454',137523.27,137523.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240522',4612462,'2967','454',24399.26,25682.00,1282.74,211652.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240522',4612463,'2968','454',109680.55,109680.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240522',4612464,'2969','454',14475.59,14723.66,248.07,40931.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240522',4612465,'2970','454',15832.51,16705.74,873.23,144082.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240522',4612466,'2971','454',81867.07,82408.50,541.43,89335.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240522',4612467,'2972','454',22395.47,22852.99,457.52,75490.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240522',4612468,'2973','454',11520.79,11731.38,210.59,34747.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240522',4612469,'2974','454',60629.79,60949.59,304.80,50292.00,0.00,0.00,15.00,0.00,0.00),('1','122','1006','240522',4612470,'2975','454',11541.32,11716.64,175.32,28927.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240522',4612471,'2976','454',43531.71,43659.04,127.33,21009.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240522',4612472,'2977','454',36466.11,36623.48,157.37,25966.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240522',4612473,'2978','454',87069.71,87069.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240522',4612474,'2979','454',26290.23,26290.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240522',4612475,'2980','454',62274.94,62274.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240522',4612476,'2981','454',16757.33,16778.54,21.21,3499.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240522',4612477,'2982','454',41591.62,41757.06,165.44,27297.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240522',4612478,'2983','454',9919.55,9919.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240522',4612479,'2984','454',27427.03,27427.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','240522',4612480,'2985','455',41737.90,42009.13,271.23,93574.35,0.00,0.00,0.00,0.00,0.00),('1','122','1007','240522',4612481,'2986','455',18401.07,18401.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','240522',4612482,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','240522',4612483,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240748',4615865,'2961','454',138388.25,143616.97,5228.72,862738.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240748',4615866,'2962','454',51252.93,51252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240748',4615867,'2963','454',67881.66,67881.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240748',4615868,'2964','454',87087.80,87087.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240748',4615869,'2965','454',35271.37,35271.48,0.11,18.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240748',4615870,'2966','454',137523.27,144949.10,7425.83,1225261.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240748',4615871,'2967','454',25682.00,29227.18,3545.18,584954.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240748',4615872,'2968','454',109680.55,113272.49,3591.94,592670.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240748',4615873,'2969','454',14723.66,14723.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240748',4615874,'2970','454',16705.74,20178.99,3473.25,573086.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240748',4615875,'2971','454',82408.50,82408.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240748',4615876,'2972','454',22852.99,22852.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240748',4615877,'2973','454',11731.38,11731.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240748',4615878,'2974','454',60949.59,60949.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240748',4615879,'2975','454',11716.64,11716.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240748',4615880,'2976','454',43659.04,43659.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240748',4615881,'2977','454',36623.48,36623.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240748',4615882,'2978','454',87069.71,87069.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240748',4615883,'2979','454',26290.23,26290.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240748',4615884,'2980','454',62274.94,62274.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240748',4615885,'2981','454',16778.54,16778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240748',4615886,'2982','454',41757.06,41757.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240748',4615887,'2983','454',9919.55,9919.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240748',4615888,'2984','454',27427.03,27427.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','240748',4615889,'2985','455',42009.13,42599.43,590.30,203653.50,0.00,0.00,0.00,0.00,0.00),('1','122','1007','240748',4615890,'2986','455',18401.07,18401.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','240748',4615891,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','240748',4615892,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240786',4616573,'2961','454',143616.97,143616.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240786',4616574,'2962','454',51252.93,51252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240786',4616575,'2963','454',67881.66,72615.31,4733.65,781052.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240786',4616576,'2964','454',87087.80,91423.46,4335.66,715383.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240786',4616577,'2965','454',35271.48,39431.29,4159.81,686368.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240786',4616578,'2966','454',144949.10,148013.89,3064.79,505690.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240786',4616579,'2967','454',29227.18,29227.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240786',4616580,'2968','454',113272.49,113272.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240786',4616581,'2969','454',14723.66,19590.98,4843.08,799108.20,0.00,0.00,24.24,0.00,0.00),('1','122','1004','240786',4616582,'2970','454',20178.99,24267.28,4088.29,674567.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240786',4616583,'2971','454',82408.50,86244.62,3836.12,632959.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','240786',4616584,'2972','454',22852.99,26708.99,3856.00,636240.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240786',4616585,'2973','454',11731.38,11731.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240786',4616586,'2974','454',60949.59,60949.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240786',4616587,'2975','454',11716.64,11716.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240786',4616588,'2976','454',43659.04,43659.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240786',4616589,'2977','454',36623.48,36623.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240786',4616590,'2978','454',87069.71,87069.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240786',4616591,'2979','454',26290.23,26290.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240786',4616592,'2980','454',62274.94,62274.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240786',4616593,'2981','454',16778.54,16778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240786',4616594,'2982','454',41757.06,41757.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240786',4616595,'2983','454',9919.55,9919.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','240786',4616596,'2984','454',27427.03,27427.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','240786',4616597,'2985','455',42599.43,43391.47,792.04,273253.80,0.00,0.00,0.00,0.00,0.00),('1','122','1007','240786',4616598,'2986','455',18401.07,18401.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','240786',4616599,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','240786',4616600,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241293',4625647,'2961','454',143616.97,153600.52,9983.55,1647285.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241293',4625648,'2962','454',51252.93,51252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241293',4625649,'2963','454',72615.31,72615.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241293',4625650,'2964','454',91423.46,91423.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241293',4625651,'2965','454',39431.29,39431.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241293',4625652,'2966','454',148013.89,156129.38,8115.49,1339055.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241293',4625653,'2967','454',29227.18,29227.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241293',4625654,'2968','454',113272.49,113272.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241293',4625655,'2969','454',19590.98,19590.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241293',4625656,'2970','454',24267.28,24267.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241293',4625657,'2971','454',86244.62,86244.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241293',4625658,'2972','454',26708.99,26708.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241293',4625659,'2973','454',11731.38,12907.52,1176.14,194063.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241293',4625660,'2974','454',60949.59,61521.60,572.01,94381.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241293',4625661,'2975','454',11716.64,17245.27,5528.63,912223.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241293',4625662,'2976','454',43659.04,50950.25,7291.21,1203049.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241293',4625663,'2977','454',36623.48,36623.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241293',4625664,'2978','454',87069.71,87069.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241293',4625665,'2979','454',26290.23,26290.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241293',4625666,'2980','454',62274.94,62274.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241293',4625667,'2981','454',16778.54,16778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241293',4625668,'2982','454',41757.06,41757.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241293',4625669,'2983','454',9919.55,15102.74,5183.19,855226.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241293',4625670,'2984','454',27427.03,32197.37,4770.34,787106.10,0.00,0.00,0.00,0.00,0.00),('1','122','1007','241293',4625671,'2985','455',43391.47,43476.76,85.29,29425.05,0.00,0.00,0.00,0.00,0.00),('1','122','1007','241293',4625672,'2986','455',18401.07,18401.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','241293',4625673,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','241293',4625674,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241429',4628112,'2961','454',153600.52,153600.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241429',4628113,'2962','454',51252.93,51252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241429',4628114,'2963','454',72615.31,76234.27,3618.96,597128.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241429',4628115,'2964','454',91423.46,95297.89,3874.43,639280.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241429',4628116,'2965','454',39431.29,39431.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241429',4628117,'2966','454',156129.38,156129.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241429',4628118,'2967','454',29227.18,32694.41,3467.23,572092.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241429',4628119,'2968','454',113272.49,116578.49,3306.00,545490.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241429',4628120,'2969','454',19590.98,21595.42,2004.44,330732.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241429',4628121,'2970','454',24267.28,28233.55,3966.27,654434.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241429',4628122,'2971','454',86244.62,86244.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241429',4628123,'2972','454',26708.99,26708.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241429',4628124,'2973','454',12907.52,16652.17,3744.65,617867.25,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241429',4628125,'2974','454',61521.60,61553.72,12.12,1999.80,0.00,0.00,20.00,0.00,0.00),('1','122','1006','241429',4628126,'2975','454',17245.27,17245.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241429',4628127,'2976','454',50950.25,50950.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241429',4628128,'2977','454',36623.48,36623.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241429',4628129,'2978','454',87069.71,87069.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241429',4628130,'2979','454',26290.23,26290.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241429',4628131,'2980','454',62274.94,62274.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241429',4628132,'2981','454',16778.54,16778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241429',4628133,'2982','454',41757.06,41757.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241429',4628134,'2983','454',15102.74,15102.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241429',4628135,'2984','454',32197.37,32197.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','241429',4628136,'2985','455',43476.76,43476.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','241429',4628137,'2986','455',18401.07,18401.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','241429',4628138,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','241429',4628139,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241694',4632692,'2961','454',153600.52,157869.46,4268.94,704375.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241694',4632693,'2962','454',51252.93,55593.00,4340.07,716111.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241694',4632694,'2963','454',76234.27,76234.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241694',4632695,'2964','454',95297.89,95297.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241694',4632696,'2965','454',39431.29,42818.57,3387.28,558901.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241694',4632697,'2966','454',156129.38,161365.93,5236.55,864030.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241694',4632698,'2967','454',32694.41,35751.38,3056.97,504400.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241694',4632699,'2968','454',116578.49,120547.45,3968.96,654878.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241694',4632700,'2969','454',21595.42,25965.17,4369.75,721008.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241694',4632701,'2970','454',28233.55,28233.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241694',4632702,'2971','454',86244.62,92853.60,6608.98,1090481.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241694',4632703,'2972','454',26708.99,26709.11,0.12,19.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241694',4632704,'2973','454',16652.17,16652.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241694',4632705,'2974','454',61553.72,61553.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241694',4632706,'2975','454',17245.27,17245.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241694',4632707,'2976','454',50950.25,50950.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241694',4632708,'2977','454',36623.48,36623.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241694',4632709,'2978','454',87069.71,87069.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241694',4632710,'2979','454',26290.23,26290.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241694',4632711,'2980','454',62274.94,62274.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241694',4632712,'2981','454',16778.54,16778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241694',4632713,'2982','454',41757.06,41757.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241694',4632714,'2983','454',15102.74,15102.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241694',4632715,'2984','454',32197.37,32197.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','241694',4632716,'2985','455',43476.76,43476.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','241694',4632717,'2986','455',18401.07,18401.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','241694',4632718,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','241694',4632719,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241929',4636766,'2961','454',157869.46,157869.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241929',4636767,'2962','454',55593.00,55593.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241929',4636768,'2963','454',76234.27,76234.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241929',4636769,'2964','454',95297.89,102493.78,7185.89,1185671.85,0.00,0.00,10.00,0.00,0.00),('1','122','1004','241929',4636770,'2965','454',42818.57,42818.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241929',4636771,'2966','454',161365.93,161365.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241929',4636772,'2967','454',35751.38,40534.76,4773.38,787607.70,0.00,0.00,10.00,0.00,0.00),('1','122','1004','241929',4636773,'2968','454',120547.45,120979.67,432.22,71316.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241929',4636774,'2969','454',25965.17,26490.25,525.08,86638.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241929',4636775,'2970','454',28233.55,29487.61,1253.05,206753.25,0.00,0.00,1.01,0.00,0.00),('1','122','1004','241929',4636776,'2971','454',92853.60,92853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','241929',4636777,'2972','454',26709.11,26709.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241929',4636778,'2973','454',16652.17,16652.17,-0.60,-99.00,0.00,0.00,0.60,0.00,0.00),('1','122','1006','241929',4636779,'2974','454',61553.72,63910.22,2346.50,387172.50,0.00,0.00,10.00,0.00,0.00),('1','122','1006','241929',4636780,'2975','454',17245.27,17245.27,-0.21,-34.65,0.00,0.00,0.21,0.00,0.00),('1','122','1006','241929',4636781,'2976','454',50950.25,57125.06,6164.81,1017193.65,0.00,0.00,10.00,0.00,0.00),('1','122','1006','241929',4636782,'2977','454',36623.48,40770.28,4135.80,682407.00,0.00,0.00,11.00,0.00,0.00),('1','122','1006','241929',4636783,'2978','454',87069.71,87069.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','241929',4636784,'2979','454',26290.23,26290.23,-2.34,-386.10,0.00,0.00,2.34,0.00,0.00),('1','122','1006','241929',4636785,'2980','454',62274.94,62274.94,-0.28,-46.20,0.00,0.00,0.28,0.00,0.00),('1','122','1006','241929',4636786,'2981','454',16778.54,16778.54,-0.18,-29.70,0.00,0.00,0.18,0.00,0.00),('1','122','1006','241929',4636787,'2982','454',41757.06,41757.06,-3.10,-511.50,0.00,0.00,3.10,0.00,0.00),('1','122','1006','241929',4636788,'2983','454',15102.74,19168.03,4055.29,669122.85,0.00,0.00,10.00,0.00,0.00),('1','122','1006','241929',4636789,'2984','454',32197.37,33086.38,889.01,146686.65,0.00,0.00,0.00,0.00,0.00),('1','122','1007','241929',4636790,'2985','455',43476.76,43476.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','241929',4636791,'2986','455',18401.07,18401.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','241929',4636792,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','241929',4636793,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242297',4643077,'2961','454',157869.46,162439.98,4555.52,751660.80,0.00,0.00,15.00,0.00,0.00),('1','122','1004','242297',4643078,'2962','454',55593.00,55593.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242297',4643079,'2963','454',76234.27,76234.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242297',4643080,'2964','454',102493.78,102493.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242297',4643081,'2965','454',42818.57,42818.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242297',4643082,'2966','454',161365.93,165421.76,4055.83,669211.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242297',4643083,'2967','454',40534.76,40534.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242297',4643084,'2968','454',120979.67,120979.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242297',4643085,'2969','454',26490.25,26490.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242297',4643086,'2970','454',29487.61,32930.42,3442.81,568063.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242297',4643087,'2971','454',92853.60,92854.47,0.87,143.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242297',4643088,'2972','454',26709.11,28335.42,1626.31,268341.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242297',4643089,'2973','454',16652.17,16652.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242297',4643090,'2974','454',63910.22,63910.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242297',4643091,'2975','454',17245.27,17245.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242297',4643092,'2976','454',57125.06,60646.57,3521.51,581049.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242297',4643093,'2977','454',40770.28,40770.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242297',4643094,'2978','454',87069.71,87069.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242297',4643095,'2979','454',26290.23,26290.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242297',4643096,'2980','454',62274.94,68937.42,6637.48,1095184.20,0.00,0.00,25.00,0.00,0.00),('1','122','1006','242297',4643097,'2981','454',16778.54,16778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242297',4643098,'2982','454',41757.06,41757.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242297',4643099,'2983','454',19168.03,19168.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242297',4643100,'2984','454',33086.38,35197.02,2110.64,348255.60,0.00,0.00,0.00,0.00,0.00),('1','122','1007','242297',4643101,'2985','455',43476.76,43476.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','242297',4643102,'2986','455',18401.07,18401.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','242297',4643103,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','242297',4643104,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242506',4646711,'2961','454',162439.98,166071.09,3631.11,599133.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242506',4646712,'2962','454',55593.00,56778.65,1185.65,195632.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242506',4646713,'2963','454',76234.27,76234.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242506',4646714,'2964','454',102493.78,102493.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242506',4646715,'2965','454',42818.57,42818.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242506',4646716,'2966','454',165421.76,169758.32,4336.56,715532.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242506',4646717,'2967','454',40534.76,40534.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242506',4646718,'2968','454',120979.67,125064.36,4084.69,673973.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242506',4646719,'2969','454',26490.25,26490.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242506',4646720,'2970','454',32930.42,36380.05,3449.63,569188.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242506',4646721,'2971','454',92854.47,93049.84,195.37,32236.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242506',4646722,'2972','454',28335.42,28335.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242506',4646723,'2973','454',16652.17,16652.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242506',4646724,'2974','454',63910.22,63910.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242506',4646725,'2975','454',17245.27,17245.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242506',4646726,'2976','454',60646.57,60646.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242506',4646727,'2977','454',40770.28,40770.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242506',4646728,'2978','454',87069.71,87069.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242506',4646729,'2979','454',26290.23,26290.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242506',4646730,'2980','454',68937.42,69922.45,985.03,162529.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242506',4646731,'2981','454',16778.54,16778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242506',4646732,'2982','454',41757.06,41757.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242506',4646733,'2983','454',19168.03,19529.91,361.88,59710.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242506',4646734,'2984','454',35197.02,35197.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','242506',4646735,'2985','455',43476.76,43476.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','242506',4646736,'2986','455',18401.07,18401.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','242506',4646737,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','242506',4646738,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242742',4650891,'2961','454',166071.09,173041.10,6970.01,1150051.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242742',4650892,'2962','454',56778.65,56778.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242742',4650893,'2963','454',76234.27,76234.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242742',4650894,'2964','454',102493.78,108559.75,6065.97,1000885.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242742',4650895,'2965','454',42818.57,42818.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242742',4650896,'2966','454',169758.32,176006.96,6248.64,1031025.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242742',4650897,'2967','454',40534.76,40534.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242742',4650898,'2968','454',125064.36,131309.55,6245.19,1030456.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242742',4650899,'2969','454',26490.25,29972.33,3482.08,574543.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242742',4650900,'2970','454',36380.05,39796.69,3416.64,563745.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242742',4650901,'2971','454',93049.84,97109.78,4059.94,669890.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242742',4650902,'2972','454',28335.42,28335.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242742',4650903,'2973','454',16652.17,16652.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242742',4650904,'2974','454',63910.22,63910.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242742',4650905,'2975','454',17245.27,17245.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242742',4650906,'2976','454',60646.57,60646.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242742',4650907,'2977','454',40770.28,40770.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242742',4650908,'2978','454',87069.71,87069.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242742',4650909,'2979','454',26290.23,26290.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242742',4650910,'2980','454',69922.45,69922.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242742',4650911,'2981','454',16778.54,16778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242742',4650912,'2982','454',41757.06,41757.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242742',4650913,'2983','454',19529.91,19529.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242742',4650914,'2984','454',35197.02,35197.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','242742',4650915,'2985','455',43476.76,43476.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','242742',4650916,'2986','455',18401.07,18401.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','242742',4650917,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','242742',4650918,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242991',4655101,'2961','454',173041.10,173041.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242991',4655102,'2962','454',56778.65,56778.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242991',4655103,'2963','454',76234.27,76234.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242991',4655104,'2964','454',108559.75,108559.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242991',4655105,'2965','454',42818.57,44546.80,1728.23,285157.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242991',4655106,'2966','454',176006.96,176006.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242991',4655107,'2967','454',40534.76,40534.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242991',4655108,'2968','454',131309.55,131309.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242991',4655109,'2969','454',29972.33,29972.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242991',4655110,'2970','454',39796.69,39796.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242991',4655111,'2971','454',97109.78,97109.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','242991',4655112,'2972','454',28335.42,28335.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242991',4655113,'2973','454',16652.17,16652.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242991',4655114,'2974','454',63910.22,68886.69,4976.47,821117.55,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242991',4655115,'2975','454',17245.27,23589.59,6344.32,1046812.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242991',4655116,'2976','454',60646.57,60646.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242991',4655117,'2977','454',40770.28,47931.68,7161.40,1181631.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242991',4655118,'2978','454',87069.71,87069.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242991',4655119,'2979','454',26290.23,30055.14,3764.91,621210.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242991',4655120,'2980','454',69922.45,69922.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242991',4655121,'2981','454',16778.54,16778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242991',4655122,'2982','454',41757.06,47702.76,5945.70,981040.50,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242991',4655123,'2983','454',19529.91,19529.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','242991',4655124,'2984','454',35197.02,35197.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','242991',4655125,'2985','455',43476.76,43476.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','242991',4655126,'2986','455',18401.07,18401.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','242991',4655127,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','242991',4655128,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243201',4658773,'2961','454',173041.10,175141.01,2099.91,346485.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243201',4658774,'2962','454',56778.65,57369.06,590.41,97417.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243201',4658775,'2963','454',76234.27,78591.09,2356.82,388875.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243201',4658776,'2964','454',108559.75,108942.50,382.75,63153.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243201',4658777,'2965','454',44546.80,46084.03,1537.23,253642.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243201',4658778,'2966','454',176006.96,177531.21,1524.25,251501.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243201',4658779,'2967','454',40534.76,41836.34,1301.58,214760.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243201',4658780,'2968','454',131309.55,133279.38,1969.83,325021.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243201',4658781,'2969','454',29972.33,31289.51,1317.18,217334.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243201',4658782,'2970','454',39796.69,41179.87,1383.18,228224.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243201',4658783,'2971','454',97109.78,98521.39,1411.61,232915.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243201',4658784,'2972','454',28335.42,29198.19,862.77,142357.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243201',4658785,'2973','454',16652.17,16652.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243201',4658786,'2974','454',68886.69,68886.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243201',4658787,'2975','454',23589.59,23589.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243201',4658788,'2976','454',60646.57,60646.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243201',4658789,'2977','454',47931.68,47931.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243201',4658790,'2978','454',87069.71,87069.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243201',4658791,'2979','454',30055.14,30055.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243201',4658792,'2980','454',69922.45,69922.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243201',4658793,'2981','454',16778.54,16778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243201',4658794,'2982','454',47702.76,47702.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243201',4658795,'2983','454',19529.91,19529.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243201',4658796,'2984','454',35197.02,35197.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','243201',4658797,'2985','455',43476.76,44133.05,656.29,226420.05,0.00,0.00,0.00,0.00,0.00),('1','122','1007','243201',4658798,'2986','455',18401.07,18401.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','243201',4658799,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','243201',4658800,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243313',4660959,'2961','454',175141.01,177978.43,2837.42,468174.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243313',4660960,'2962','454',57369.06,57369.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243313',4660961,'2963','454',78591.09,78591.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243313',4660962,'2964','454',108942.50,111214.04,2271.54,374804.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243313',4660963,'2965','454',46084.03,46084.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243313',4660964,'2966','454',177531.21,179581.23,2050.02,338253.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243313',4660965,'2967','454',41836.34,41836.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243313',4660966,'2968','454',133279.38,135368.62,2089.24,344724.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243313',4660967,'2969','454',31289.51,31289.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243313',4660968,'2970','454',41179.87,43416.17,2236.30,368989.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243313',4660969,'2971','454',98521.39,100584.90,2063.51,340479.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243313',4660970,'2972','454',29198.19,29198.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243313',4660971,'2973','454',16652.17,17929.26,1277.09,210719.85,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243313',4660972,'2974','454',68886.69,68886.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243313',4660973,'2975','454',23589.59,25370.19,1780.60,293799.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243313',4660974,'2976','454',60646.57,60646.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243313',4660975,'2977','454',47931.68,49792.85,1861.17,307093.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243313',4660976,'2978','454',87069.71,87069.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243313',4660977,'2979','454',30055.14,31896.51,1841.37,303826.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243313',4660978,'2980','454',69922.45,69922.58,0.13,21.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243313',4660979,'2981','454',16778.54,18862.77,2084.23,343897.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243313',4660980,'2982','454',47702.76,47702.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243313',4660981,'2983','454',19529.91,21578.10,2048.19,337951.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243313',4660982,'2984','454',35197.02,35197.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','243313',4660983,'2985','455',44133.05,44872.27,699.22,241230.90,0.00,0.00,40.00,0.00,0.00),('1','122','1007','243313',4660984,'2986','455',18401.07,18801.35,400.28,138096.60,0.00,0.00,0.00,0.00,0.00),('1','122','1007','243313',4660985,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','243313',4660986,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243677',4667018,'2961','454',177978.43,178149.93,171.50,28297.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243677',4667019,'2962','454',57369.06,62248.30,4879.24,805074.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243677',4667020,'2963','454',78591.09,79022.52,431.43,71185.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243677',4667021,'2964','454',111214.04,116742.33,5528.29,912167.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243677',4667022,'2965','454',46084.03,46841.49,757.46,124980.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243677',4667023,'2966','454',179581.23,182600.83,3019.60,498234.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243677',4667024,'2967','454',41836.34,42529.04,692.70,114295.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243677',4667025,'2968','454',135368.62,135368.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243677',4667026,'2969','454',31289.51,31289.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243677',4667027,'2970','454',43416.17,48305.18,4889.01,806686.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243677',4667028,'2971','454',100584.90,101220.35,635.45,104849.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243677',4667029,'2972','454',29198.19,29198.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243677',4667030,'2973','454',17929.26,17929.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243677',4667031,'2974','454',68886.69,73840.46,4953.77,817372.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243677',4667032,'2975','454',25370.19,28835.41,3465.22,571761.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243677',4667033,'2976','454',60646.57,60646.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243677',4667034,'2977','454',49792.85,49792.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243677',4667035,'2978','454',87069.71,91430.93,4361.22,719601.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243677',4667036,'2979','454',31896.51,31896.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243677',4667037,'2980','454',69922.58,73600.01,3677.43,606775.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243677',4667038,'2981','454',18862.77,18862.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243677',4667039,'2982','454',47702.76,47702.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243677',4667040,'2983','454',21578.10,21578.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243677',4667041,'2984','454',35197.02,37895.21,2698.19,445201.35,0.00,0.00,0.00,0.00,0.00),('1','122','1007','243677',4667042,'2985','455',44872.27,46993.24,2120.97,731734.65,0.00,0.00,0.00,0.00,0.00),('1','122','1007','243677',4667043,'2986','455',18801.35,18801.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','243677',4667044,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','243677',4667045,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243907',4671115,'2961','454',178149.93,178149.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243907',4671116,'2962','454',62248.30,62248.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243907',4671117,'2963','454',79022.52,79840.01,817.49,134885.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243907',4671118,'2964','454',116742.33,117880.46,1138.13,187791.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243907',4671119,'2965','454',46841.49,47483.59,642.10,105946.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243907',4671120,'2966','454',182600.83,183712.73,1111.90,183463.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243907',4671121,'2967','454',42529.04,43529.04,1000.00,165000.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243907',4671122,'2968','454',135368.62,138021.01,2652.39,437644.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243907',4671123,'2969','454',31289.51,31289.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243907',4671124,'2970','454',48305.18,49357.46,1052.28,173626.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243907',4671125,'2971','454',101220.35,101220.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','243907',4671126,'2972','454',29198.19,29198.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243907',4671127,'2973','454',17929.26,19651.51,1722.25,284171.25,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243907',4671128,'2974','454',73840.46,73858.64,18.18,2999.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243907',4671129,'2975','454',28835.41,28835.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243907',4671130,'2976','454',60646.57,62829.74,2183.17,360223.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243907',4671131,'2977','454',49792.85,51650.48,1857.63,306508.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243907',4671132,'2978','454',91430.93,91430.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243907',4671133,'2979','454',31896.51,33386.74,1490.23,245887.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243907',4671134,'2980','454',73600.01,73600.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243907',4671135,'2981','454',18862.77,20514.10,1651.33,272469.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243907',4671136,'2982','454',47702.76,47702.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243907',4671137,'2983','454',21578.10,21578.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','243907',4671138,'2984','454',37895.21,37895.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','243907',4671139,'2985','455',46993.24,49815.13,2821.89,973552.05,0.00,0.00,0.00,0.00,0.00),('1','122','1007','243907',4671140,'2986','455',18801.35,21301.46,2500.11,862537.95,0.00,0.00,0.00,0.00,0.00),('1','122','1007','243907',4671141,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','243907',4671142,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244123',4674862,'2961','454',178149.93,181103.75,2953.82,487380.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244123',4674863,'2962','454',62248.30,62248.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244123',4674864,'2963','454',79840.01,79840.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244123',4674865,'2964','454',117880.46,121594.96,3714.50,612892.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244123',4674866,'2965','454',47483.59,47483.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244123',4674867,'2966','454',183712.73,187755.67,4042.94,667085.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244123',4674868,'2967','454',43529.04,45319.32,1790.28,295396.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244123',4674869,'2968','454',138021.01,138021.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244123',4674870,'2969','454',31289.51,31289.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244123',4674871,'2970','454',49357.46,49357.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244123',4674872,'2971','454',101220.35,103912.58,2692.23,444217.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244123',4674873,'2972','454',29198.19,29198.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244123',4674874,'2973','454',19651.51,19651.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244123',4674875,'2974','454',73858.64,76181.46,2322.82,383265.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244123',4674876,'2975','454',28835.41,28835.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244123',4674877,'2976','454',62829.74,62829.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244123',4674878,'2977','454',51650.48,51650.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244123',4674879,'2978','454',91430.93,93598.62,2167.69,357668.85,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244123',4674880,'2979','454',33386.74,33386.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244123',4674881,'2980','454',73600.01,73600.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244123',4674882,'2981','454',20514.10,20514.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244123',4674883,'2982','454',47702.76,49773.15,2070.39,341614.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244123',4674884,'2983','454',21578.10,21578.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244123',4674885,'2984','454',37895.21,37895.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','244123',4674886,'2985','455',49815.13,50259.13,444.00,153180.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','244123',4674887,'2986','455',21301.46,21311.46,10.00,3450.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','244123',4674888,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','244123',4674889,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244354',4678771,'2961','454',181103.75,181103.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244354',4678772,'2962','454',62248.30,62248.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244354',4678773,'2963','454',79840.01,86977.02,7117.01,1174306.65,0.00,0.00,20.00,0.00,0.00),('1','122','1004','244354',4678774,'2964','454',121594.96,125086.49,3481.53,574452.45,0.00,0.00,10.00,0.00,0.00),('1','122','1004','244354',4678775,'2965','454',47483.59,47483.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244354',4678776,'2966','454',187755.67,187762.94,7.27,1199.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244354',4678777,'2967','454',45319.32,47173.25,1833.93,302598.45,0.00,0.00,20.00,0.00,0.00),('1','122','1004','244354',4678778,'2968','454',138021.01,139576.62,1545.61,255025.65,0.00,0.00,10.00,0.00,0.00),('1','122','1004','244354',4678779,'2969','454',31289.51,31299.17,9.66,1593.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244354',4678780,'2970','454',49357.46,50010.78,653.32,107797.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244354',4678781,'2971','454',103912.58,103912.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244354',4678782,'2972','454',29198.19,29750.91,552.72,91198.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244354',4678783,'2973','454',19651.51,19651.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244354',4678784,'2974','454',76181.46,76181.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244354',4678785,'2975','454',28835.41,33861.57,5016.16,827666.40,0.00,0.00,10.00,0.00,0.00),('1','122','1006','244354',4678786,'2976','454',62829.74,62829.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244354',4678787,'2977','454',51650.48,51650.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244354',4678788,'2978','454',93598.62,93598.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244354',4678789,'2979','454',33386.74,36315.35,2918.61,481570.65,0.00,0.00,10.00,0.00,0.00),('1','122','1006','244354',4678790,'2980','454',73600.01,77921.32,4311.31,711366.15,0.00,0.00,10.00,0.00,0.00),('1','122','1006','244354',4678791,'2981','454',20514.10,20514.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244354',4678792,'2982','454',49773.15,49773.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244354',4678793,'2983','454',21578.10,23342.04,1763.94,291050.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244354',4678794,'2984','454',37895.21,37895.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','244354',4678795,'2985','455',50259.13,51092.60,813.47,280647.15,0.00,0.00,20.00,0.00,0.00),('1','122','1007','244354',4678796,'2986','455',21311.46,21311.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','244354',4678797,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','244354',4678798,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244387',4679459,'2961','454',181103.75,184904.19,3800.44,627072.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244387',4679460,'2962','454',62248.30,66836.40,4588.10,757036.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244387',4679461,'2963','454',86977.02,86977.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244387',4679462,'2964','454',125086.49,125086.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244387',4679463,'2965','454',47483.59,47483.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244387',4679464,'2966','454',187762.94,187762.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244387',4679465,'2967','454',47173.25,47336.89,163.64,27000.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244387',4679466,'2968','454',139576.62,139576.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244387',4679467,'2969','454',31299.17,31299.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244387',4679468,'2970','454',50010.78,50010.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244387',4679469,'2971','454',103912.58,107585.80,3673.22,606081.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244387',4679470,'2972','454',29750.91,33391.32,3640.41,600667.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244387',4679471,'2973','454',19651.51,19651.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244387',4679472,'2974','454',76181.46,76181.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244387',4679473,'2975','454',33861.57,33861.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244387',4679474,'2976','454',62829.74,62829.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244387',4679475,'2977','454',51650.48,51650.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244387',4679476,'2978','454',93598.62,93598.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244387',4679477,'2979','454',36315.35,36315.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244387',4679478,'2980','454',77921.32,77921.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244387',4679479,'2981','454',20514.10,20514.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244387',4679480,'2982','454',49773.15,49773.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244387',4679481,'2983','454',23342.04,23342.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244387',4679482,'2984','454',37895.21,37895.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','244387',4679483,'2985','455',51092.60,51795.66,673.06,232205.70,0.00,0.00,30.00,0.00,0.00),('1','122','1007','244387',4679484,'2986','455',21311.46,21336.93,0.00,0.00,0.00,0.00,25.47,0.00,0.00),('1','122','1007','244387',4679485,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','244387',4679486,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244792',4686224,'2961','454',184904.19,190527.89,5623.70,927910.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244792',4686225,'2962','454',66836.40,66836.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244792',4686226,'2963','454',86977.02,87763.59,786.57,129784.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244792',4686227,'2964','454',125086.49,130628.49,5542.00,914430.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244792',4686228,'2965','454',47483.59,47483.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244792',4686229,'2966','454',187762.94,187762.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244792',4686230,'2967','454',47336.89,52834.70,5497.81,907138.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244792',4686231,'2968','454',139576.62,144918.60,5341.98,881426.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244792',4686232,'2969','454',31299.17,31299.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244792',4686233,'2970','454',50010.78,50010.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244792',4686234,'2971','454',107585.80,111408.38,3822.58,630725.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244792',4686235,'2972','454',33391.32,38594.89,5203.57,858589.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244792',4686236,'2973','454',19651.51,19651.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244792',4686237,'2974','454',76181.46,76181.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244792',4686238,'2975','454',33861.57,33861.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244792',4686239,'2976','454',62829.74,62829.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244792',4686240,'2977','454',51650.48,51650.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244792',4686241,'2978','454',93598.62,93598.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244792',4686242,'2979','454',36315.35,36315.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244792',4686243,'2980','454',77921.32,77921.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244792',4686244,'2981','454',20514.10,20514.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244792',4686245,'2982','454',49773.15,49773.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244792',4686246,'2983','454',23342.04,23342.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244792',4686247,'2984','454',37895.21,37895.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','244792',4686248,'2985','455',51795.66,52409.87,614.21,211902.45,0.00,0.00,0.00,0.00,0.00),('1','122','1007','244792',4686249,'2986','455',21336.93,21336.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','244792',4686250,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','244792',4686251,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244878',4687977,'2961','454',190527.89,195278.22,4750.33,783804.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244878',4687978,'2962','454',66836.40,66836.60,0.20,33.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244878',4687979,'2963','454',87763.59,87763.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244878',4687980,'2964','454',130628.49,137479.06,6850.57,1130344.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244878',4687981,'2965','454',47483.59,47483.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244878',4687982,'2966','454',187762.94,187762.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244878',4687983,'2967','454',52834.70,52834.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244878',4687984,'2968','454',144918.60,149802.46,4883.86,805836.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244878',4687985,'2969','454',31299.17,31299.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244878',4687986,'2970','454',50010.78,50010.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244878',4687987,'2971','454',111408.38,114954.66,3546.28,585136.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','244878',4687988,'2972','454',38594.89,38594.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244878',4687989,'2973','454',19651.51,19651.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244878',4687990,'2974','454',76181.46,83170.98,6989.52,1153270.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244878',4687991,'2975','454',33861.57,39542.34,5680.77,937327.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244878',4687992,'2976','454',62829.74,62829.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244878',4687993,'2977','454',51650.48,58294.42,6643.94,1096250.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244878',4687994,'2978','454',93598.62,93598.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244878',4687995,'2979','454',36315.35,36315.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244878',4687996,'2980','454',77921.32,78058.89,137.57,22699.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244878',4687997,'2981','454',20514.10,26134.90,5620.80,927432.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244878',4687998,'2982','454',49773.15,49773.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244878',4687999,'2983','454',23342.04,23342.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','244878',4688000,'2984','454',37895.21,44548.40,6653.19,1097776.35,0.00,0.00,0.00,0.00,0.00),('1','122','1007','244878',4688001,'2985','455',52409.87,52991.62,581.75,200703.75,0.00,0.00,0.00,0.00,0.00),('1','122','1007','244878',4688002,'2986','455',21336.93,21336.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','244878',4688003,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','244878',4688004,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245069',4691259,'2961','454',195278.22,195278.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245069',4691260,'2962','454',66836.60,66836.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245069',4691261,'2963','454',87763.59,96182.61,8419.02,1389138.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245069',4691262,'2964','454',137479.06,137479.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245069',4691263,'2965','454',47483.59,47483.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245069',4691264,'2966','454',187762.94,193514.66,5751.72,949033.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245069',4691265,'2967','454',52834.70,60459.31,7624.61,1258060.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245069',4691266,'2968','454',149802.46,149802.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245069',4691267,'2969','454',31299.17,31299.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245069',4691268,'2970','454',50010.78,50010.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245069',4691269,'2971','454',114954.66,122013.81,7059.15,1164759.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245069',4691270,'2972','454',38594.89,39594.89,1000.00,165000.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245069',4691271,'2973','454',19651.51,20433.58,782.07,129041.55,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245069',4691272,'2974','454',83170.98,84440.82,1269.84,209523.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245069',4691273,'2975','454',39542.34,39542.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245069',4691274,'2976','454',62829.74,62829.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245069',4691275,'2977','454',58294.42,58294.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245069',4691276,'2978','454',93598.62,94525.35,926.73,152910.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245069',4691277,'2979','454',36315.35,40991.10,4675.75,771498.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245069',4691278,'2980','454',78058.89,78058.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245069',4691279,'2981','454',26134.90,26134.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245069',4691280,'2982','454',49773.15,49773.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245069',4691281,'2983','454',23342.04,26248.44,2906.40,479556.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245069',4691282,'2984','454',44548.40,45031.99,483.59,79792.35,0.00,0.00,0.00,0.00,0.00),('1','122','1007','245069',4691283,'2985','455',52991.62,55870.52,2878.90,993220.50,0.00,0.00,0.00,0.00,0.00),('1','122','1007','245069',4691284,'2986','455',21336.93,23837.25,2500.32,862610.40,0.00,0.00,0.00,0.00,0.00),('1','122','1007','245069',4691285,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','245069',4691286,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245391',4697026,'2961','454',195278.22,195278.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245391',4697027,'2962','454',66836.60,66836.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245391',4697028,'2963','454',96182.61,96182.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245391',4697029,'2964','454',137479.06,137479.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245391',4697030,'2965','454',47483.59,47483.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245391',4697031,'2966','454',193514.66,193514.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245391',4697032,'2967','454',60459.31,60459.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245391',4697033,'2968','454',149802.46,149802.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245391',4697034,'2969','454',31299.17,31299.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245391',4697035,'2970','454',50010.78,50010.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245391',4697036,'2971','454',122013.81,122013.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245391',4697037,'2972','454',39594.89,39594.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245391',4697038,'2973','454',20433.58,20433.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245391',4697039,'2974','454',84440.82,89088.40,4647.58,766850.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245391',4697040,'2975','454',39542.34,46139.22,6596.88,1088485.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245391',4697041,'2976','454',62829.74,62829.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245391',4697042,'2977','454',58294.42,63753.00,5458.58,900665.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245391',4697043,'2978','454',94525.35,94525.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245391',4697044,'2979','454',40991.10,40991.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245391',4697045,'2980','454',78058.89,83703.91,5645.02,931428.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245391',4697046,'2981','454',26134.90,29985.21,3850.31,635301.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245391',4697047,'2982','454',49773.15,49773.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245391',4697048,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245391',4697049,'2984','454',45031.99,49587.38,4555.39,751639.35,0.00,0.00,0.00,0.00,0.00),('1','122','1007','245391',4697050,'2985','455',55870.52,56156.46,285.94,98649.30,0.00,0.00,0.00,0.00,0.00),('1','122','1007','245391',4697051,'2986','455',23837.25,23837.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','245391',4697052,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','245391',4697053,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245602',4700733,'2961','454',195278.22,202045.26,6742.04,1112436.60,0.00,0.00,25.00,0.00,0.00),('1','122','1004','245602',4700734,'2962','454',66836.60,66836.60,-30.10,-4966.50,0.00,0.00,30.10,0.00,0.00),('1','122','1004','245602',4700735,'2963','454',96182.61,96182.61,-10.00,-1650.00,0.00,0.00,10.00,0.00,0.00),('1','122','1004','245602',4700736,'2964','454',137479.06,137479.06,-10.00,-1650.00,0.00,0.00,10.00,0.00,0.00),('1','122','1004','245602',4700737,'2965','454',47483.59,47483.59,-30.09,-4964.85,0.00,0.00,30.09,0.00,0.00),('1','122','1004','245602',4700738,'2966','454',193514.66,199401.55,5856.89,966386.85,0.00,0.00,30.00,0.00,0.00),('1','122','1004','245602',4700739,'2967','454',60459.31,60459.31,-10.00,-1650.00,0.00,0.00,10.00,0.00,0.00),('1','122','1004','245602',4700740,'2968','454',149802.46,149802.46,-20.00,-3300.00,0.00,0.00,20.00,0.00,0.00),('1','122','1004','245602',4700741,'2969','454',31299.17,31299.17,-50.09,-8264.85,0.00,0.00,50.09,0.00,0.00),('1','122','1004','245602',4700742,'2970','454',50010.78,50010.78,-50.55,-8340.75,0.00,0.00,50.55,0.00,0.00),('1','122','1004','245602',4700743,'2971','454',122013.81,123075.59,1041.78,171893.70,0.00,0.00,20.00,0.00,0.00),('1','122','1004','245602',4700744,'2972','454',39594.89,39594.89,-20.00,-3300.00,0.00,0.00,20.00,0.00,0.00),('1','122','1006','245602',4700745,'2973','454',20433.58,20433.58,-20.00,-3300.00,0.00,0.00,20.00,0.00,0.00),('1','122','1006','245602',4700746,'2974','454',89088.40,94547.81,5439.41,897502.65,0.00,0.00,20.00,0.00,0.00),('1','122','1006','245602',4700747,'2975','454',46139.22,46139.22,-10.00,-1650.00,0.00,0.00,10.00,0.00,0.00),('1','122','1006','245602',4700748,'2976','454',62829.74,62829.74,-20.15,-3324.75,0.00,0.00,20.15,0.00,0.00),('1','122','1006','245602',4700749,'2977','454',63753.00,63753.00,-10.00,-1650.00,0.00,0.00,10.00,0.00,0.00),('1','122','1006','245602',4700750,'2978','454',94525.35,94525.35,-30.00,-4950.00,0.00,0.00,30.00,0.00,0.00),('1','122','1006','245602',4700751,'2979','454',40991.10,40991.10,-20.00,-3300.00,0.00,0.00,20.00,0.00,0.00),('1','122','1006','245602',4700752,'2980','454',83703.91,83703.91,-10.00,-1650.00,0.00,0.00,10.00,0.00,0.00),('1','122','1006','245602',4700753,'2981','454',29985.21,29985.21,-10.00,-1650.00,0.00,0.00,10.00,0.00,0.00),('1','122','1006','245602',4700754,'2982','454',49773.15,54454.72,4641.57,765859.05,0.00,0.00,40.00,0.00,0.00),('1','122','1006','245602',4700755,'2983','454',26248.44,26248.44,-76.03,-12544.95,0.00,0.00,76.03,0.00,0.00),('1','122','1006','245602',4700756,'2984','454',49587.38,49587.38,-20.00,-3300.00,0.00,0.00,20.00,0.00,0.00),('1','122','1007','245602',4700757,'2985','455',56156.46,57359.82,1178.36,406534.20,0.00,0.00,25.00,0.00,0.00),('1','122','1007','245602',4700758,'2986','455',23837.25,23837.25,-20.14,-6948.30,0.00,0.00,20.14,0.00,0.00),('1','122','1007','245602',4700759,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','245602',4700760,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245798',4703915,'2961','454',202045.26,206497.76,4452.50,734662.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245798',4703916,'2962','454',66836.60,66836.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245798',4703917,'2963','454',96182.61,96182.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245798',4703918,'2964','454',137479.06,143442.22,5963.16,983921.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245798',4703919,'2965','454',47483.59,47483.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245798',4703920,'2966','454',199401.55,205673.16,6271.61,1034815.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245798',4703921,'2967','454',60459.31,65021.65,4562.34,752786.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245798',4703922,'2968','454',149802.46,154680.68,4878.22,804906.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245798',4703923,'2969','454',31299.17,31299.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245798',4703924,'2970','454',50010.78,55057.08,5046.30,832639.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245798',4703925,'2971','454',123075.59,124843.76,1768.17,291748.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','245798',4703926,'2972','454',39594.89,42722.37,3127.48,516034.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245798',4703927,'2973','454',20433.58,20433.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245798',4703928,'2974','454',94547.81,94547.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245798',4703929,'2975','454',46139.22,46139.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245798',4703930,'2976','454',62829.74,64588.94,1759.20,290268.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245798',4703931,'2977','454',63753.00,63753.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245798',4703932,'2978','454',94525.35,94525.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245798',4703933,'2979','454',40991.10,40991.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245798',4703934,'2980','454',83703.91,85342.16,1638.25,270311.25,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245798',4703935,'2981','454',29985.21,29985.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245798',4703936,'2982','454',54454.72,54454.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245798',4703937,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','245798',4703938,'2984','454',49587.38,49587.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','245798',4703939,'2985','455',57359.82,58626.27,1266.45,436925.25,0.00,0.00,0.00,0.00,0.00),('1','122','1007','245798',4703940,'2986','455',23837.25,23857.39,20.14,6948.30,0.00,0.00,0.00,0.00,0.00),('1','122','1007','245798',4703941,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','245798',4703942,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246255',4711178,'2961','454',206497.76,206497.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246255',4711179,'2962','454',66836.60,66836.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246255',4711180,'2963','454',96182.61,96514.78,332.17,54808.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246255',4711181,'2964','454',143442.22,143442.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246255',4711182,'2965','454',47483.59,47483.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246255',4711183,'2966','454',205673.16,216305.79,10632.63,1754383.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246255',4711184,'2967','454',65021.65,65021.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246255',4711185,'2968','454',154680.68,154690.68,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','122','1004','246255',4711186,'2969','454',31299.17,31299.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246255',4711187,'2970','454',55057.08,65970.14,10913.06,1800654.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246255',4711188,'2971','454',124843.76,124843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246255',4711189,'2972','454',42722.37,42722.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246255',4711190,'2973','454',20433.58,20433.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246255',4711191,'2974','454',94547.81,94548.15,0.34,56.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246255',4711192,'2975','454',46139.22,46139.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246255',4711193,'2976','454',64588.94,76209.76,11620.82,1917435.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246255',4711194,'2977','454',63753.00,63753.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246255',4711195,'2978','454',94525.35,94525.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246255',4711196,'2979','454',40991.10,48619.22,7628.12,1258639.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246255',4711197,'2980','454',85342.16,85342.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246255',4711198,'2981','454',29985.21,29985.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246255',4711199,'2982','454',54454.72,54454.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246255',4711200,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246255',4711201,'2984','454',49587.38,50454.54,867.16,143081.40,0.00,0.00,0.00,0.00,0.00),('1','122','1007','246255',4711202,'2985','455',58626.27,59283.00,656.73,226571.85,0.00,0.00,0.00,0.00,0.00),('1','122','1007','246255',4711203,'2986','455',23857.39,23857.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','246255',4711204,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','246255',4711205,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246537',4715932,'2961','454',206497.76,206497.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246537',4715933,'2962','454',66836.60,66836.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246537',4715934,'2963','454',96514.78,96514.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246537',4715935,'2964','454',143442.22,153654.18,10211.96,1684973.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246537',4715936,'2965','454',47483.59,47483.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246537',4715937,'2966','454',216305.79,216305.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246537',4715938,'2967','454',65021.65,65021.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246537',4715939,'2968','454',154690.68,163169.31,8478.63,1398973.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246537',4715940,'2969','454',31299.17,31299.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246537',4715941,'2970','454',65970.14,66633.04,622.90,102778.50,0.00,0.00,40.00,0.00,0.00),('1','122','1004','246537',4715942,'2971','454',124843.76,126375.72,1531.96,252773.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246537',4715943,'2972','454',42722.37,49691.23,6968.86,1149861.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246537',4715944,'2973','454',20433.58,22747.04,2313.46,381720.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246537',4715945,'2974','454',94548.15,94548.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246537',4715946,'2975','454',46139.22,51545.17,5405.95,891981.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246537',4715947,'2976','454',76209.76,76209.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246537',4715948,'2977','454',63753.00,65946.89,2183.89,360341.85,0.00,0.00,10.00,0.00,0.00),('1','122','1006','246537',4715949,'2978','454',94525.35,94525.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246537',4715950,'2979','454',48619.22,48619.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246537',4715951,'2980','454',85342.16,93965.09,8622.93,1422783.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246537',4715952,'2981','454',29985.21,32497.10,2511.89,414461.85,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246537',4715953,'2982','454',54454.72,54454.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246537',4715954,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246537',4715955,'2984','454',50454.54,56594.37,6139.83,1013071.95,0.00,0.00,0.00,0.00,0.00),('1','122','1007','246537',4715956,'2985','455',59283.00,59606.06,323.06,111455.70,0.00,0.00,0.00,0.00,0.00),('1','122','1007','246537',4715957,'2986','455',23857.39,24124.06,266.67,92001.15,0.00,0.00,0.00,0.00,0.00),('1','122','1007','246537',4715958,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','246537',4715959,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246663',4718310,'2961','454',206497.76,206498.06,0.30,49.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246663',4718311,'2962','454',66836.60,66836.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246663',4718312,'2963','454',96514.78,96543.31,28.53,4707.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246663',4718313,'2964','454',153654.18,154470.14,815.96,134633.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246663',4718314,'2965','454',47483.59,47483.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246663',4718315,'2966','454',216305.79,221498.18,5192.39,856744.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246663',4718316,'2967','454',65021.65,65999.44,977.79,161335.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246663',4718317,'2968','454',163169.31,164726.19,1556.88,256885.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246663',4718318,'2969','454',31299.17,31299.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246663',4718319,'2970','454',66633.04,70628.52,3995.48,659254.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246663',4718320,'2971','454',126375.72,127709.14,1333.42,220014.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246663',4718321,'2972','454',49691.23,49691.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246663',4718322,'2973','454',22747.04,22747.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246663',4718323,'2974','454',94548.15,94548.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246663',4718324,'2975','454',51545.17,51545.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246663',4718325,'2976','454',76209.76,80329.69,4119.93,679788.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246663',4718326,'2977','454',65946.89,71127.49,5180.60,854799.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246663',4718327,'2978','454',94525.35,94525.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246663',4718328,'2979','454',48619.22,48619.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246663',4718329,'2980','454',93965.09,98793.14,4828.05,796628.25,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246663',4718330,'2981','454',32497.10,32497.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246663',4718331,'2982','454',54454.72,58700.38,4245.66,700533.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246663',4718332,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246663',4718333,'2984','454',56594.37,61231.04,4636.67,765050.55,0.00,0.00,0.00,0.00,0.00),('1','122','1007','246663',4718334,'2985','455',59606.06,61254.60,1648.54,568746.30,0.00,0.00,0.00,0.00,0.00),('1','122','1007','246663',4718335,'2986','455',24124.06,24199.43,75.37,26002.65,0.00,0.00,0.00,0.00,0.00),('1','122','1007','246663',4718336,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','246663',4718337,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246869',4721907,'2961','454',206498.06,211178.29,4680.23,772237.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246869',4721908,'2962','454',66836.60,66836.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246869',4721909,'2963','454',96543.31,99941.20,3397.89,560651.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246869',4721910,'2964','454',154470.14,154470.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246869',4721911,'2965','454',47483.59,47483.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246869',4721912,'2966','454',221498.18,229496.05,7997.87,1319648.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246869',4721913,'2967','454',65999.44,65999.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246869',4721914,'2968','454',164726.19,171854.02,7127.83,1176091.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246869',4721915,'2969','454',31299.17,32849.39,1550.22,255786.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246869',4721916,'2970','454',70628.52,72185.41,1556.89,256886.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246869',4721917,'2971','454',127709.14,131704.60,3995.46,659250.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','246869',4721918,'2972','454',49691.23,53769.47,4078.24,672909.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246869',4721919,'2973','454',22747.04,22747.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246869',4721920,'2974','454',94548.15,94548.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246869',4721921,'2975','454',51545.17,51545.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246869',4721922,'2976','454',80329.69,80329.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246869',4721923,'2977','454',71127.49,71127.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246869',4721924,'2978','454',94525.35,94525.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246869',4721925,'2979','454',48619.22,48619.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246869',4721926,'2980','454',98793.14,98793.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246869',4721927,'2981','454',32497.10,32497.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246869',4721928,'2982','454',58700.38,58700.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246869',4721929,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','246869',4721930,'2984','454',61231.04,61231.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','246869',4721931,'2985','455',61254.60,62881.31,1626.71,561214.95,0.00,0.00,0.00,0.00,0.00),('1','122','1007','246869',4721932,'2986','455',24199.43,26199.43,2000.00,690000.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','246869',4721933,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','246869',4721934,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247261',4728578,'2961','454',211178.29,211178.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247261',4728579,'2962','454',66836.60,66836.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247261',4728580,'2963','454',99941.20,99941.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247261',4728581,'2964','454',154470.14,157088.95,2618.81,432103.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247261',4728582,'2965','454',47483.59,47483.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247261',4728583,'2966','454',229496.05,229496.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247261',4728584,'2967','454',65999.44,70938.73,4939.29,814982.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247261',4728585,'2968','454',171854.02,171854.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247261',4728586,'2969','454',32849.39,32849.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247261',4728587,'2970','454',72185.41,72185.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247261',4728588,'2971','454',131704.60,136269.07,4564.47,753137.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247261',4728589,'2972','454',53769.47,53769.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247261',4728590,'2973','454',22747.04,22747.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247261',4728591,'2974','454',94548.15,95958.78,1410.63,232753.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247261',4728592,'2975','454',51545.17,51545.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247261',4728593,'2976','454',80329.69,87243.68,6913.99,1140808.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247261',4728594,'2977','454',71127.49,71127.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247261',4728595,'2978','454',94525.35,94525.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247261',4728596,'2979','454',48619.22,48619.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247261',4728597,'2980','454',98793.14,106243.94,7450.80,1229382.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247261',4728598,'2981','454',32497.10,32497.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247261',4728599,'2982','454',58700.38,58700.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247261',4728600,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247261',4728601,'2984','454',61231.04,66555.95,5324.91,878610.15,0.00,0.00,0.00,0.00,0.00),('1','122','1007','247261',4728602,'2985','455',62881.31,68411.10,5529.79,1907777.55,0.00,0.00,0.00,0.00,0.00),('1','122','1007','247261',4728603,'2986','455',26199.43,31039.11,4839.68,1669689.60,0.00,0.00,0.00,0.00,0.00),('1','122','1007','247261',4728604,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','247261',4728605,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247468',4732176,'2961','454',211178.29,216809.51,5631.22,929151.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247468',4732177,'2962','454',66836.60,66836.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247468',4732178,'2963','454',99941.20,99941.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247468',4732179,'2964','454',157088.95,157088.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247468',4732180,'2965','454',47483.59,47483.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247468',4732181,'2966','454',229496.05,234999.00,5502.95,907986.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247468',4732182,'2967','454',70938.73,70938.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247468',4732183,'2968','454',171854.02,175770.20,3916.18,646169.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247468',4732184,'2969','454',32849.39,32849.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247468',4732185,'2970','454',72185.41,76696.35,4510.94,744305.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247468',4732186,'2971','454',136269.07,136269.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247468',4732187,'2972','454',53769.47,53769.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247468',4732188,'2973','454',22747.04,22747.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247468',4732189,'2974','454',95958.78,99537.26,3578.48,590449.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247468',4732190,'2975','454',51545.17,53423.69,1878.52,309955.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247468',4732191,'2976','454',87243.68,87243.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247468',4732192,'2977','454',71127.49,71127.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247468',4732193,'2978','454',94525.35,98117.37,3592.02,592683.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247468',4732194,'2979','454',48619.22,48619.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247468',4732195,'2980','454',106243.94,106243.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247468',4732196,'2981','454',32497.10,34215.14,1718.04,283476.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247468',4732197,'2982','454',58700.38,58700.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247468',4732198,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247468',4732199,'2984','454',66555.95,66555.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','247468',4732200,'2985','455',68411.10,68411.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','247468',4732201,'2986','455',31039.11,31566.12,527.01,181818.45,0.00,0.00,0.00,0.00,0.00),('1','122','1007','247468',4732202,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','247468',4732203,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247717',4736318,'2961','454',216809.51,216809.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247717',4736319,'2962','454',66836.60,66836.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247717',4736320,'2963','454',99941.20,99941.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247717',4736321,'2964','454',157088.95,158380.56,1291.61,213115.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247717',4736322,'2965','454',47483.59,47513.96,30.37,5011.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247717',4736323,'2966','454',234999.00,234999.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247717',4736324,'2967','454',70938.73,71732.83,794.10,131026.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247717',4736325,'2968','454',175770.20,175770.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247717',4736326,'2969','454',32849.39,32849.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247717',4736327,'2970','454',76696.35,80616.75,3920.40,646866.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247717',4736328,'2971','454',136269.07,139450.92,3181.85,525005.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247717',4736329,'2972','454',53769.47,55169.46,1399.99,230998.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247717',4736330,'2973','454',22747.04,22747.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247717',4736331,'2974','454',99537.26,99537.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247717',4736332,'2975','454',53423.69,53423.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247717',4736333,'2976','454',87243.68,87243.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247717',4736334,'2977','454',71127.49,71127.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247717',4736335,'2978','454',98117.37,98117.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247717',4736336,'2979','454',48619.22,48635.22,16.00,2640.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247717',4736337,'2980','454',106243.94,106305.94,62.00,10230.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247717',4736338,'2981','454',34215.14,34215.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247717',4736339,'2982','454',58700.38,58700.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247717',4736340,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247717',4736341,'2984','454',66555.95,66555.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','247717',4736342,'2985','455',68411.10,73746.19,5335.09,1840606.05,0.00,0.00,0.00,0.00,0.00),('1','122','1007','247717',4736343,'2986','455',31566.12,36640.04,5044.92,1740497.40,0.00,0.00,29.00,0.00,0.00),('1','122','1007','247717',4736344,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','247717',4736345,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247867',4739032,'2961','454',216809.51,225779.65,8970.14,1480073.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247867',4739033,'2962','454',66836.60,66836.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247867',4739034,'2963','454',99941.20,106352.88,6411.68,1057927.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247867',4739035,'2964','454',158380.56,158380.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247867',4739036,'2965','454',47513.96,51122.15,3608.19,595351.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247867',4739037,'2966','454',234999.00,238842.13,3843.13,634116.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247867',4739038,'2967','454',71732.83,75893.79,4160.96,686558.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247867',4739039,'2968','454',175770.20,179669.51,3899.31,643386.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247867',4739040,'2969','454',32849.39,36233.40,3384.01,558361.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247867',4739041,'2970','454',80616.75,84615.51,3998.76,659795.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247867',4739042,'2971','454',139450.92,145984.94,6534.02,1078113.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','247867',4739043,'2972','454',55169.46,55169.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247867',4739044,'2973','454',22747.04,22747.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247867',4739045,'2974','454',99537.26,99537.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247867',4739046,'2975','454',53423.69,53423.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247867',4739047,'2976','454',87243.68,87243.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247867',4739048,'2977','454',71127.49,71127.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247867',4739049,'2978','454',98117.37,98117.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247867',4739050,'2979','454',48635.22,48635.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247867',4739051,'2980','454',106305.94,106305.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247867',4739052,'2981','454',34215.14,34215.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247867',4739053,'2982','454',58700.38,58700.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247867',4739054,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','247867',4739055,'2984','454',66555.95,66555.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','247867',4739056,'2985','455',73746.19,74656.62,910.43,314098.35,0.00,0.00,0.00,0.00,0.00),('1','122','1007','247867',4739057,'2986','455',36640.04,36908.09,268.05,92477.25,0.00,0.00,0.00,0.00,0.00),('1','122','1007','247867',4739058,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','247867',4739059,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248084',4742643,'2961','454',225779.65,227618.38,1838.73,303390.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248084',4742644,'2962','454',66836.60,66836.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248084',4742645,'2963','454',106352.88,106352.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248084',4742646,'2964','454',158380.56,159762.00,1381.44,227937.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248084',4742647,'2965','454',51122.15,51122.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248084',4742648,'2966','454',238842.13,240028.18,1186.05,195698.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248084',4742649,'2967','454',75893.79,75893.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248084',4742650,'2968','454',179669.51,181073.47,1403.96,231653.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248084',4742651,'2969','454',36233.40,36258.00,24.60,4059.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248084',4742652,'2970','454',84615.51,86420.27,1804.76,297785.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248084',4742653,'2971','454',145984.94,147212.71,1227.77,202582.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248084',4742654,'2972','454',55169.46,55169.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248084',4742655,'2973','454',22747.04,22747.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248084',4742656,'2974','454',99537.26,103714.65,4177.39,689269.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248084',4742657,'2975','454',53423.69,58049.51,4625.82,763260.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248084',4742658,'2976','454',87243.68,87243.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248084',4742659,'2977','454',71127.49,71917.01,789.52,130270.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248084',4742660,'2978','454',98117.37,103748.33,5630.96,929108.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248084',4742661,'2979','454',48635.22,52764.56,4129.34,681341.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248084',4742662,'2980','454',106305.94,108640.93,2334.99,385273.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248084',4742663,'2981','454',34215.14,38264.31,4049.17,668113.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248084',4742664,'2982','454',58700.38,58700.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248084',4742665,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248084',4742666,'2984','454',66555.95,70632.04,4076.09,672554.85,0.00,0.00,0.00,0.00,0.00),('1','122','1007','248084',4742667,'2985','455',74656.62,79475.59,4818.97,1662544.65,0.00,0.00,0.00,0.00,0.00),('1','122','1007','248084',4742668,'2986','455',36908.09,36980.00,71.91,24808.95,0.00,0.00,0.00,0.00,0.00),('1','122','1007','248084',4742669,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','248084',4742670,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248480',4749211,'2961','454',227618.38,231767.43,4149.05,684593.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248480',4749212,'2962','454',66836.60,66836.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248480',4749213,'2963','454',106352.88,106352.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248480',4749214,'2964','454',159762.00,162539.36,2777.36,458264.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248480',4749215,'2965','454',51122.15,51122.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248480',4749216,'2966','454',240028.18,241673.37,1645.19,271456.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248480',4749217,'2967','454',75893.79,75893.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248480',4749218,'2968','454',181073.47,182977.91,1904.44,314232.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248480',4749219,'2969','454',36258.00,36258.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248480',4749220,'2970','454',86420.27,86586.95,166.68,27502.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248480',4749221,'2971','454',147212.71,148517.84,1305.13,215346.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248480',4749222,'2972','454',55169.46,55169.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248480',4749223,'2973','454',22747.04,22747.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248480',4749224,'2974','454',103714.65,107478.52,3763.87,621038.55,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248480',4749225,'2975','454',58049.51,61613.92,3564.41,588127.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248480',4749226,'2976','454',87243.68,87243.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248480',4749227,'2977','454',71917.01,71917.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248480',4749228,'2978','454',103748.33,108960.53,5212.20,860013.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248480',4749229,'2979','454',52764.56,52764.56,-10.00,-1650.00,0.00,0.00,10.00,0.00,0.00),('1','122','1006','248480',4749230,'2980','454',108640.93,113259.17,4598.24,758709.60,0.00,0.00,20.00,0.00,0.00),('1','122','1006','248480',4749231,'2981','454',38264.31,38264.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248480',4749232,'2982','454',58700.38,61548.14,2847.76,469880.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248480',4749233,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248480',4749234,'2984','454',70632.04,70632.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','248480',4749235,'2985','455',79475.59,80303.03,827.44,285466.80,0.00,0.00,0.00,0.00,0.00),('1','122','1007','248480',4749236,'2986','455',36980.00,36980.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','248480',4749237,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','248480',4749238,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248695',4752743,'2961','454',231767.43,234637.22,2869.79,473515.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248695',4752744,'2962','454',66836.60,66836.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248695',4752745,'2963','454',106352.88,106352.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248695',4752746,'2964','454',162539.36,165417.15,2877.79,474835.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248695',4752747,'2965','454',51122.15,51122.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248695',4752748,'2966','454',241673.37,245619.06,3945.69,651038.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248695',4752749,'2967','454',75893.79,75893.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248695',4752750,'2968','454',182977.91,188100.76,5122.85,845270.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248695',4752751,'2969','454',36258.00,36258.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248695',4752752,'2970','454',86586.95,88539.49,1952.54,322169.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248695',4752753,'2971','454',148517.84,150935.15,2417.31,398856.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248695',4752754,'2972','454',55169.46,55169.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248695',4752755,'2973','454',22747.04,22747.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248695',4752756,'2974','454',107478.52,107478.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248695',4752757,'2975','454',61613.92,61613.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248695',4752758,'2976','454',87243.68,87243.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248695',4752759,'2977','454',71917.01,71917.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248695',4752760,'2978','454',108960.53,108960.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248695',4752761,'2979','454',52764.56,52764.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248695',4752762,'2980','454',113259.17,113259.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248695',4752763,'2981','454',38264.31,38264.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248695',4752764,'2982','454',61548.14,61548.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248695',4752765,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248695',4752766,'2984','454',70632.04,70632.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','248695',4752767,'2985','455',80303.03,82016.33,1713.30,591088.50,0.00,0.00,0.00,0.00,0.00),('1','122','1007','248695',4752768,'2986','455',36980.00,37133.06,153.06,52805.70,0.00,0.00,0.00,0.00,0.00),('1','122','1007','248695',4752769,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','248695',4752770,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248961',4757263,'2961','454',234637.22,236801.54,2164.32,357112.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248961',4757264,'2962','454',66836.60,66836.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248961',4757265,'2963','454',106352.88,106352.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248961',4757266,'2964','454',165417.15,169670.26,4253.11,701763.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248961',4757267,'2965','454',51122.15,52772.02,1649.87,272228.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248961',4757268,'2966','454',245619.06,245619.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248961',4757269,'2967','454',75893.79,75893.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248961',4757270,'2968','454',188100.76,190895.84,2795.08,461188.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248961',4757271,'2969','454',36258.00,36258.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248961',4757272,'2970','454',88539.49,90049.11,1509.62,249087.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248961',4757273,'2971','454',150935.15,150935.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','248961',4757274,'2972','454',55169.46,55169.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248961',4757275,'2973','454',22747.04,22747.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248961',4757276,'2974','454',107478.52,107478.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248961',4757277,'2975','454',61613.92,61613.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248961',4757278,'2976','454',87243.68,87243.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248961',4757279,'2977','454',71917.01,71917.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248961',4757280,'2978','454',108960.53,108960.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248961',4757281,'2979','454',52764.56,52764.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248961',4757282,'2980','454',113259.17,113259.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248961',4757283,'2981','454',38264.31,38264.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248961',4757284,'2982','454',61548.14,61548.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248961',4757285,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','248961',4757286,'2984','454',70632.04,70632.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','248961',4757287,'2985','455',82016.33,82497.63,481.30,166048.50,0.00,0.00,0.00,0.00,0.00),('1','122','1007','248961',4757288,'2986','455',37133.06,37133.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','248961',4757289,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','248961',4757290,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249204',4761333,'2961','454',236801.54,240614.07,3802.53,627417.45,0.00,0.00,10.00,0.00,0.00),('1','122','1004','249204',4761334,'2962','454',66836.60,66836.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249204',4761335,'2963','454',106352.88,106352.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249204',4761336,'2964','454',169670.26,173584.77,3914.51,645894.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249204',4761337,'2965','454',52772.02,52772.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249204',4761338,'2966','454',245619.06,249566.20,3947.14,651278.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249204',4761339,'2967','454',75893.79,80555.19,4661.40,769131.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249204',4761340,'2968','454',190895.84,190895.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249204',4761341,'2969','454',36258.00,36258.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249204',4761342,'2970','454',90049.11,90049.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249204',4761343,'2971','454',150935.15,150935.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249204',4761344,'2972','454',55169.46,55169.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249204',4761345,'2973','454',22747.04,22747.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249204',4761346,'2974','454',107478.52,107478.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249204',4761347,'2975','454',61613.92,61613.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249204',4761348,'2976','454',87243.68,87243.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249204',4761349,'2977','454',71917.01,71917.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249204',4761350,'2978','454',108960.53,108960.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249204',4761351,'2979','454',52764.56,52764.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249204',4761352,'2980','454',113259.17,113259.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249204',4761353,'2981','454',38264.31,38264.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249204',4761354,'2982','454',61548.14,61548.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249204',4761355,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249204',4761356,'2984','454',70632.04,70632.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','249204',4761357,'2985','455',82497.63,82980.98,483.35,166755.75,0.00,0.00,0.00,0.00,0.00),('1','122','1007','249204',4761358,'2986','455',37133.06,37133.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','249204',4761359,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','249204',4761360,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249445',4765527,'2961','454',240614.07,240614.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249445',4765528,'2962','454',66836.60,68770.50,1933.90,319093.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249445',4765529,'2963','454',106352.88,106352.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249445',4765530,'2964','454',173584.77,176307.17,2722.40,449196.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249445',4765531,'2965','454',52772.02,56704.34,3932.32,648832.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249445',4765532,'2966','454',249566.20,249566.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249445',4765533,'2967','454',80555.19,80555.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249445',4765534,'2968','454',190895.84,193898.08,2982.24,492069.60,0.00,0.00,20.00,0.00,0.00),('1','122','1004','249445',4765535,'2969','454',36258.00,36258.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249445',4765536,'2970','454',90049.11,92702.04,2652.93,437733.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249445',4765537,'2971','454',150935.15,153163.20,2228.05,367628.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249445',4765538,'2972','454',55169.46,55169.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249445',4765539,'2973','454',22747.04,22747.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249445',4765540,'2974','454',107478.52,107478.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249445',4765541,'2975','454',61613.92,61613.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249445',4765542,'2976','454',87243.68,87243.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249445',4765543,'2977','454',71917.01,71917.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249445',4765544,'2978','454',108960.53,108960.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249445',4765545,'2979','454',52764.56,52764.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249445',4765546,'2980','454',113259.17,113259.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249445',4765547,'2981','454',38264.31,38264.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249445',4765548,'2982','454',61548.14,61548.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249445',4765549,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249445',4765550,'2984','454',70632.04,70632.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','249445',4765551,'2985','455',82980.98,83595.92,614.94,212154.30,0.00,0.00,0.00,0.00,0.00),('1','122','1007','249445',4765552,'2986','455',37133.06,37133.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','249445',4765553,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','249445',4765554,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249699',4769696,'2961','454',240614.07,240614.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249699',4769697,'2962','454',68770.50,68770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249699',4769698,'2963','454',106352.88,106352.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249699',4769699,'2964','454',176307.17,176307.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249699',4769700,'2965','454',56704.34,56704.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249699',4769701,'2966','454',249566.20,249566.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249699',4769702,'2967','454',80555.19,80555.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249699',4769703,'2968','454',193898.08,193898.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249699',4769704,'2969','454',36258.00,36258.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249699',4769705,'2970','454',92702.04,92702.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249699',4769706,'2971','454',153163.20,153163.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249699',4769707,'2972','454',55169.46,55169.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249699',4769708,'2973','454',22747.04,22747.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249699',4769709,'2974','454',107478.52,109156.52,1678.00,276870.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249699',4769710,'2975','454',61613.92,61613.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249699',4769711,'2976','454',87243.68,87243.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249699',4769712,'2977','454',71917.01,71917.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249699',4769713,'2978','454',108960.53,112780.11,3819.58,630230.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249699',4769714,'2979','454',52764.56,52764.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249699',4769715,'2980','454',113259.17,117593.01,4333.84,715083.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249699',4769716,'2981','454',38264.31,38264.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249699',4769717,'2982','454',61548.14,65755.41,4207.27,694199.55,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249699',4769718,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249699',4769719,'2984','454',70632.04,74267.95,3635.91,599925.15,0.00,0.00,0.00,0.00,0.00),('1','122','1007','249699',4769720,'2985','455',83595.92,85511.42,1915.50,660847.50,0.00,0.00,0.00,0.00,0.00),('1','122','1007','249699',4769721,'2986','455',37133.06,37185.24,52.18,18002.10,0.00,0.00,0.00,0.00,0.00),('1','122','1007','249699',4769722,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','249699',4769723,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249944',4774016,'2961','454',240614.07,240614.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249944',4774017,'2962','454',68770.50,68770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249944',4774018,'2963','454',106352.88,106352.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249944',4774019,'2964','454',176307.17,179110.52,2803.35,462552.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249944',4774020,'2965','454',56704.34,56704.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249944',4774021,'2966','454',249566.20,249566.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249944',4774022,'2967','454',80555.19,80555.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249944',4774023,'2968','454',193898.08,199507.85,5609.77,925612.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249944',4774024,'2969','454',36258.00,37758.35,1500.35,247557.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249944',4774025,'2970','454',92702.04,94202.04,1500.00,247500.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249944',4774026,'2971','454',153163.20,157201.87,4038.67,666380.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','249944',4774027,'2972','454',55169.46,55169.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249944',4774028,'2973','454',22747.04,22747.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249944',4774029,'2974','454',109156.52,109156.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249944',4774030,'2975','454',61613.92,61613.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249944',4774031,'2976','454',87243.68,93336.61,6092.93,1005333.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249944',4774032,'2977','454',71917.01,71917.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249944',4774033,'2978','454',112780.11,112780.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249944',4774034,'2979','454',52764.56,56898.56,4134.00,682110.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249944',4774035,'2980','454',117593.01,117593.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249944',4774036,'2981','454',38264.31,38264.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249944',4774037,'2982','454',65755.41,65755.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249944',4774038,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','249944',4774039,'2984','454',74267.95,76797.97,2530.02,417453.30,0.00,0.00,0.00,0.00,0.00),('1','122','1007','249944',4774040,'2985','455',85511.42,89007.05,3495.63,1205992.35,0.00,0.00,0.00,0.00,0.00),('1','122','1007','249944',4774041,'2986','455',37185.24,39225.15,2039.91,703768.95,0.00,0.00,0.00,0.00,0.00),('1','122','1007','249944',4774042,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','249944',4774043,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250234',4778931,'2961','454',240614.07,245165.92,4551.85,751055.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250234',4778932,'2962','454',68770.50,68770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250234',4778933,'2963','454',106352.88,107854.57,1501.69,247778.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250234',4778934,'2964','454',179110.52,179110.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250234',4778935,'2965','454',56704.34,60580.86,3876.52,639625.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250234',4778936,'2966','454',249566.20,249566.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250234',4778937,'2967','454',80555.19,81878.19,1323.00,218295.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250234',4778938,'2968','454',199507.85,199507.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250234',4778939,'2969','454',37758.35,37758.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250234',4778940,'2970','454',94202.04,96631.84,2429.80,400917.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250234',4778941,'2971','454',157201.87,157956.68,754.81,124543.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250234',4778942,'2972','454',55169.46,55169.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250234',4778943,'2973','454',22747.04,25693.30,2946.26,486132.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250234',4778944,'2974','454',109156.52,109156.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250234',4778945,'2975','454',61613.92,61613.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250234',4778946,'2976','454',93336.61,93336.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250234',4778947,'2977','454',71917.01,75229.01,3312.00,546480.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250234',4778948,'2978','454',112780.11,112780.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250234',4778949,'2979','454',56898.56,56898.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250234',4778950,'2980','454',117593.01,117593.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250234',4778951,'2981','454',38264.31,41547.43,3283.12,541714.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250234',4778952,'2982','454',65755.41,65755.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250234',4778953,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250234',4778954,'2984','454',76797.97,76797.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','250234',4778955,'2985','455',89007.05,89517.40,510.35,176070.75,0.00,0.00,0.00,0.00,0.00),('1','122','1007','250234',4778956,'2986','455',39225.15,39225.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','250234',4778957,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','250234',4778958,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250501',4783242,'2961','454',245165.92,248160.75,2994.83,494146.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250501',4783243,'2962','454',68770.50,68770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250501',4783244,'2963','454',107854.57,107854.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250501',4783245,'2964','454',179110.52,181343.09,2232.57,368374.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250501',4783246,'2965','454',60580.86,60580.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250501',4783247,'2966','454',249566.20,252245.44,2679.24,442074.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250501',4783248,'2967','454',81878.19,81878.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250501',4783249,'2968','454',199507.85,203839.35,4331.50,714697.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250501',4783250,'2969','454',37758.35,37758.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250501',4783251,'2970','454',96631.84,101159.41,4527.57,747049.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250501',4783252,'2971','454',157956.68,157956.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250501',4783253,'2972','454',55169.46,55169.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250501',4783254,'2973','454',25693.30,25693.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250501',4783255,'2974','454',109156.52,109156.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250501',4783256,'2975','454',61613.92,61613.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250501',4783257,'2976','454',93336.61,93336.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250501',4783258,'2977','454',75229.01,75229.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250501',4783259,'2978','454',112780.11,112780.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250501',4783260,'2979','454',56898.56,56898.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250501',4783261,'2980','454',117593.01,117593.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250501',4783262,'2981','454',41547.43,41547.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250501',4783263,'2982','454',65755.41,65755.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250501',4783264,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250501',4783265,'2984','454',76797.97,76797.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','250501',4783266,'2985','455',89517.40,89812.33,294.93,101750.85,0.00,0.00,0.00,0.00,0.00),('1','122','1007','250501',4783267,'2986','455',39225.15,39225.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','250501',4783268,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','250501',4783269,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250720',4787038,'2961','454',248160.75,248160.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250720',4787039,'2962','454',68770.50,68770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250720',4787040,'2963','454',107854.57,107854.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250720',4787041,'2964','454',181343.09,181343.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250720',4787042,'2965','454',60580.86,60580.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250720',4787043,'2966','454',252245.44,252245.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250720',4787044,'2967','454',81878.19,81878.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250720',4787045,'2968','454',203839.35,203839.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250720',4787046,'2969','454',37758.35,37758.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250720',4787047,'2970','454',101159.41,101159.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250720',4787048,'2971','454',157956.68,157956.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250720',4787049,'2972','454',55169.46,55169.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250720',4787050,'2973','454',25693.30,25693.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250720',4787051,'2974','454',109156.52,109156.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250720',4787052,'2975','454',61613.92,61613.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250720',4787053,'2976','454',93336.61,95082.26,1745.65,288032.25,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250720',4787054,'2977','454',75229.01,75229.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250720',4787055,'2978','454',112780.11,116664.74,3884.63,640963.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250720',4787056,'2979','454',56898.56,56898.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250720',4787057,'2980','454',117593.01,123597.38,6004.37,990721.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250720',4787058,'2981','454',41547.43,41547.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250720',4787059,'2982','454',65755.41,68407.32,2651.91,437565.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250720',4787060,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250720',4787061,'2984','454',76797.97,80547.21,3749.24,618624.60,0.00,0.00,0.00,0.00,0.00),('1','122','1007','250720',4787062,'2985','455',89812.33,90138.85,326.52,112649.40,0.00,0.00,0.00,0.00,0.00),('1','122','1007','250720',4787063,'2986','455',39225.15,39225.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','250720',4787064,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','250720',4787065,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250910',4790450,'2961','454',248160.75,248160.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250910',4790451,'2962','454',68770.50,68770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250910',4790452,'2963','454',107854.57,107854.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250910',4790453,'2964','454',181343.09,181343.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250910',4790454,'2965','454',60580.86,60580.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250910',4790455,'2966','454',252245.44,252245.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250910',4790456,'2967','454',81878.19,81878.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250910',4790457,'2968','454',203839.35,203839.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250910',4790458,'2969','454',37758.35,37758.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250910',4790459,'2970','454',101159.41,101159.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250910',4790460,'2971','454',157956.68,157956.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','250910',4790461,'2972','454',55169.46,55169.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250910',4790462,'2973','454',25693.30,30033.68,4340.38,716162.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250910',4790463,'2974','454',109156.52,109156.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250910',4790464,'2975','454',61613.92,62854.65,1240.73,204720.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250910',4790465,'2976','454',95082.26,95082.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250910',4790466,'2977','454',75229.01,78679.44,3450.43,569320.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250910',4790467,'2978','454',116664.74,116664.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250910',4790468,'2979','454',56898.56,56898.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250910',4790469,'2980','454',123597.38,123597.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250910',4790470,'2981','454',41547.43,41547.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250910',4790471,'2982','454',68407.32,71084.09,2676.77,441667.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250910',4790472,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','250910',4790473,'2984','454',80547.21,80547.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','250910',4790474,'2985','455',90138.85,90837.86,699.01,241158.45,0.00,0.00,0.00,0.00,0.00),('1','122','1007','250910',4790475,'2986','455',39225.15,39225.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','250910',4790476,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','250910',4790477,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251154',4794756,'2961','454',248160.75,248795.13,634.38,104672.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251154',4794757,'2962','454',68770.50,68770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251154',4794758,'2963','454',107854.57,108383.56,528.99,87283.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251154',4794759,'2964','454',181343.09,181343.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251154',4794760,'2965','454',60580.86,61107.72,526.86,86931.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251154',4794761,'2966','454',252245.44,252245.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251154',4794762,'2967','454',81878.19,82231.12,352.93,58233.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251154',4794763,'2968','454',203839.35,203839.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251154',4794764,'2969','454',37758.35,37758.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251154',4794765,'2970','454',101159.41,101587.72,428.31,70671.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251154',4794766,'2971','454',157956.68,158160.34,203.66,33603.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251154',4794767,'2972','454',55169.46,55372.22,202.76,33455.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251154',4794768,'2973','454',30033.68,30033.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251154',4794769,'2974','454',109156.52,109156.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251154',4794770,'2975','454',62854.65,62854.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251154',4794771,'2976','454',95082.26,95082.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251154',4794772,'2977','454',78679.44,78679.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251154',4794773,'2978','454',116664.74,116664.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251154',4794774,'2979','454',56898.56,56898.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251154',4794775,'2980','454',123597.38,123597.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251154',4794776,'2981','454',41547.43,41547.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251154',4794777,'2982','454',71084.09,71084.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251154',4794778,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251154',4794779,'2984','454',80547.21,80547.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','251154',4794780,'2985','455',90837.86,90837.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','251154',4794781,'2986','455',39225.15,39370.82,145.67,50256.15,0.00,0.00,0.00,0.00,0.00),('1','122','1007','251154',4794782,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','251154',4794783,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251384',4798605,'2961','454',248795.13,248795.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251384',4798606,'2962','454',68770.50,68770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251384',4798607,'2963','454',108383.56,108383.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251384',4798608,'2964','454',181343.09,186453.58,5110.49,843230.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251384',4798609,'2965','454',61107.72,64593.77,3486.05,575198.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251384',4798610,'2966','454',252245.44,252245.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251384',4798611,'2967','454',82231.12,86251.79,4020.67,663410.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251384',4798612,'2968','454',203839.35,203839.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251384',4798613,'2969','454',37758.35,37758.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251384',4798614,'2970','454',101587.72,104815.64,3227.92,532606.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251384',4798615,'2971','454',158160.34,158160.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251384',4798616,'2972','454',55372.22,55372.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251384',4798617,'2973','454',30033.68,30033.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251384',4798618,'2974','454',109156.52,109156.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251384',4798619,'2975','454',62854.65,65776.91,2922.26,482172.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251384',4798620,'2976','454',95082.26,95082.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251384',4798621,'2977','454',78679.44,78679.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251384',4798622,'2978','454',116664.74,116664.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251384',4798623,'2979','454',56898.56,61011.18,4112.62,678582.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251384',4798624,'2980','454',123597.38,123597.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251384',4798625,'2981','454',41547.43,41547.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251384',4798626,'2982','454',71084.09,73787.03,2702.94,445985.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251384',4798627,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251384',4798628,'2984','454',80547.21,84186.77,3639.56,600527.40,0.00,0.00,0.00,0.00,0.00),('1','122','1007','251384',4798629,'2985','455',90837.86,90847.86,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','122','1007','251384',4798630,'2986','455',39370.82,39577.64,196.82,67902.90,0.00,0.00,10.00,0.00,0.00),('1','122','1007','251384',4798631,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','251384',4798632,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251642',4803146,'2961','454',248795.13,253304.77,4509.64,744090.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251642',4803147,'2962','454',68770.50,68770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251642',4803148,'2963','454',108383.56,108383.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251642',4803149,'2964','454',186453.58,186453.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251642',4803150,'2965','454',64593.77,64593.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251642',4803151,'2966','454',252245.44,252245.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251642',4803152,'2967','454',86251.79,86251.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251642',4803153,'2968','454',203839.35,203839.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251642',4803154,'2969','454',37758.35,37758.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251642',4803155,'2970','454',104815.64,111616.94,6801.30,1122214.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251642',4803156,'2971','454',158160.34,158160.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251642',4803157,'2972','454',55372.22,55372.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251642',4803158,'2973','454',30033.68,30033.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251642',4803159,'2974','454',109156.52,115021.64,5865.12,967744.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251642',4803160,'2975','454',65776.91,65776.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251642',4803161,'2976','454',95082.26,95082.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251642',4803162,'2977','454',78679.44,84800.66,6121.22,1010001.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251642',4803163,'2978','454',116664.74,116664.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251642',4803164,'2979','454',61011.18,61011.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251642',4803165,'2980','454',123597.38,123597.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251642',4803166,'2981','454',41547.43,43047.58,1500.15,247524.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251642',4803167,'2982','454',73787.03,75287.03,1500.00,247500.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251642',4803168,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251642',4803169,'2984','454',84186.77,84186.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','251642',4803170,'2985','455',90847.86,92169.34,1281.48,442110.60,0.00,0.00,40.00,0.00,0.00),('1','122','1007','251642',4803171,'2986','455',39577.64,41766.47,2138.83,737896.35,0.00,0.00,50.00,0.00,0.00),('1','122','1007','251642',4803172,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','251642',4803173,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251854',4806781,'2961','454',253304.77,259642.73,6337.96,1045763.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251854',4806782,'2962','454',68770.50,68770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251854',4806783,'2963','454',108383.56,108383.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251854',4806784,'2964','454',186453.58,186453.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251854',4806785,'2965','454',64593.77,65825.75,1231.98,203276.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251854',4806786,'2966','454',252245.44,252245.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251854',4806787,'2967','454',86251.79,86251.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251854',4806788,'2968','454',203839.35,203839.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251854',4806789,'2969','454',37758.35,37758.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251854',4806790,'2970','454',111616.94,118408.75,6791.81,1120648.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251854',4806791,'2971','454',158160.34,158160.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251854',4806792,'2972','454',55372.22,55372.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251854',4806793,'2973','454',30033.68,30033.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251854',4806794,'2974','454',115021.64,115021.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251854',4806795,'2975','454',65776.91,65776.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251854',4806796,'2976','454',95082.26,99487.68,4405.42,726894.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251854',4806797,'2977','454',84800.66,84800.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251854',4806798,'2978','454',116664.74,116664.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251854',4806799,'2979','454',61011.18,66166.39,5155.21,850609.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251854',4806800,'2980','454',123597.38,123597.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251854',4806801,'2981','454',43047.58,43047.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251854',4806802,'2982','454',75287.03,75287.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251854',4806803,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251854',4806804,'2984','454',84186.77,84186.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','251854',4806805,'2985','455',92169.34,92169.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','251854',4806806,'2986','455',41766.47,42283.32,516.85,178313.25,0.00,0.00,0.00,0.00,0.00),('1','122','1007','251854',4806807,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','251854',4806808,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251913',4807980,'2961','454',259642.73,259642.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251913',4807981,'2962','454',68770.50,72474.55,3704.05,611168.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251913',4807982,'2963','454',108383.56,108383.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251913',4807983,'2964','454',186453.58,186453.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251913',4807984,'2965','454',65825.75,65825.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251913',4807985,'2966','454',252245.44,257294.29,5048.85,833060.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251913',4807986,'2967','454',86251.79,86251.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251913',4807987,'2968','454',203839.35,203839.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251913',4807988,'2969','454',37758.35,42641.38,4883.03,805699.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251913',4807989,'2970','454',118408.75,118408.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251913',4807990,'2971','454',158160.34,158160.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','251913',4807991,'2972','454',55372.22,55372.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251913',4807992,'2973','454',30033.68,30033.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251913',4807993,'2974','454',115021.64,120792.64,5771.00,952215.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251913',4807994,'2975','454',65776.91,65776.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251913',4807995,'2976','454',99487.68,99487.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251913',4807996,'2977','454',84800.66,84800.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251913',4807997,'2978','454',116664.74,121053.37,4388.63,724123.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251913',4807998,'2979','454',66166.39,66166.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251913',4807999,'2980','454',123597.38,123597.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251913',4808000,'2981','454',43047.58,47293.64,4246.06,700599.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251913',4808001,'2982','454',75287.03,75287.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251913',4808002,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','251913',4808003,'2984','454',84186.77,84186.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','251913',4808004,'2985','455',92169.34,93824.44,1655.10,571009.50,0.00,0.00,0.00,0.00,0.00),('1','122','1007','251913',4808005,'2986','455',42283.32,42283.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','251913',4808006,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','251913',4808007,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252383',4816191,'2961','454',259642.73,259642.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252383',4816192,'2962','454',72474.55,72955.07,480.52,79285.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252383',4816193,'2963','454',108383.56,108433.87,50.31,8301.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252383',4816194,'2964','454',186453.58,190857.42,4403.84,726633.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252383',4816195,'2965','454',65825.75,66192.47,366.72,60508.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252383',4816196,'2966','454',257294.29,257294.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252383',4816197,'2967','454',86251.79,88420.94,2169.15,357909.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252383',4816198,'2968','454',203839.35,203872.33,32.98,5441.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252383',4816199,'2969','454',42641.38,42641.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252383',4816200,'2970','454',118408.75,118912.01,503.26,83037.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252383',4816201,'2971','454',158160.34,159181.22,1020.88,168445.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252383',4816202,'2972','454',55372.22,55372.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252383',4816203,'2973','454',30033.68,30033.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252383',4816204,'2974','454',120792.64,120792.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252383',4816205,'2975','454',65776.91,69120.64,3343.73,551715.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252383',4816206,'2976','454',99487.68,99487.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252383',4816207,'2977','454',84800.66,84800.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252383',4816208,'2978','454',121053.37,121053.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252383',4816209,'2979','454',66166.39,66166.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252383',4816210,'2980','454',123597.38,126211.90,2594.52,428095.80,0.00,0.00,20.00,0.00,0.00),('1','122','1006','252383',4816211,'2981','454',47293.64,47293.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252383',4816212,'2982','454',75287.03,75287.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252383',4816213,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252383',4816214,'2984','454',84186.77,85501.42,1314.65,216917.25,0.00,0.00,0.00,0.00,0.00),('1','122','1007','252383',4816215,'2985','455',93824.44,96060.86,2196.42,757764.90,0.00,0.00,40.00,0.00,0.00),('1','122','1007','252383',4816216,'2986','455',42283.32,42293.32,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','122','1007','252383',4816217,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','252383',4816218,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252578',4819640,'2961','454',259642.73,259642.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252578',4819641,'2962','454',72955.07,72955.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252578',4819642,'2963','454',108433.87,113514.04,5060.17,834928.05,0.00,0.00,20.00,0.00,0.00),('1','122','1004','252578',4819643,'2964','454',190857.42,190857.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252578',4819644,'2965','454',66192.47,66192.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252578',4819645,'2966','454',257294.29,260037.53,2743.24,452634.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252578',4819646,'2967','454',88420.94,92461.08,4040.14,666623.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252578',4819647,'2968','454',203872.33,203872.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252578',4819648,'2969','454',42641.38,42641.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252578',4819649,'2970','454',118912.01,122667.41,3735.40,616341.00,0.00,0.00,20.00,0.00,0.00),('1','122','1004','252578',4819650,'2971','454',159181.22,159181.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252578',4819651,'2972','454',55372.22,55577.32,205.10,33841.50,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252578',4819652,'2973','454',30033.68,30033.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252578',4819653,'2974','454',120792.64,120792.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252578',4819654,'2975','454',69120.64,69120.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252578',4819655,'2976','454',99487.68,102562.22,3064.54,505649.10,0.00,0.00,10.00,0.00,0.00),('1','122','1006','252578',4819656,'2977','454',84800.66,84800.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252578',4819657,'2978','454',121053.37,121053.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252578',4819658,'2979','454',66166.39,66166.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252578',4819659,'2980','454',126211.90,126211.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252578',4819660,'2981','454',47293.64,47293.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252578',4819661,'2982','454',75287.03,75287.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252578',4819662,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252578',4819663,'2984','454',85501.42,85501.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','252578',4819664,'2985','455',96060.86,96272.46,211.60,73002.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','252578',4819665,'2986','455',42293.32,42293.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','252578',4819666,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','252578',4819667,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252654',4820995,'2961','454',259642.73,259642.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252654',4820996,'2962','454',72955.07,78574.36,5619.29,927182.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252654',4820997,'2963','454',113514.04,113514.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252654',4820998,'2964','454',190857.42,190857.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252654',4820999,'2965','454',66192.47,66192.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252654',4821000,'2966','454',260037.53,264391.92,4354.39,718474.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252654',4821001,'2967','454',92461.08,92461.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252654',4821002,'2968','454',203872.33,209944.57,6072.24,1001919.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252654',4821003,'2969','454',42641.38,42641.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252654',4821004,'2970','454',122667.41,125536.72,2869.31,473436.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252654',4821005,'2971','454',159181.22,162975.60,3794.38,626072.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252654',4821006,'2972','454',55577.32,55577.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252654',4821007,'2973','454',30033.68,30033.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252654',4821008,'2974','454',120792.64,126965.15,6172.51,1018464.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252654',4821009,'2975','454',69120.64,71713.47,2592.83,427816.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252654',4821010,'2976','454',102562.22,102562.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252654',4821011,'2977','454',84800.66,85455.83,655.17,108103.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252654',4821012,'2978','454',121053.37,123724.02,2670.65,440657.25,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252654',4821013,'2979','454',66166.39,66166.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252654',4821014,'2980','454',126211.90,126211.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252654',4821015,'2981','454',47293.64,47293.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252654',4821016,'2982','454',75287.03,79502.31,4215.28,695521.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252654',4821017,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252654',4821018,'2984','454',85501.42,89906.88,4405.46,726900.90,0.00,0.00,0.00,0.00,0.00),('1','122','1007','252654',4821019,'2985','455',96272.46,96808.70,486.24,167752.80,0.00,0.00,50.00,0.00,0.00),('1','122','1007','252654',4821020,'2986','455',42293.32,42323.32,0.00,0.00,0.00,0.00,30.00,0.00,0.00),('1','122','1007','252654',4821021,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','252654',4821022,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252843',4823995,'2961','454',259642.73,259642.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252843',4823996,'2962','454',78574.36,78574.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252843',4823997,'2963','454',113514.04,113514.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252843',4823998,'2964','454',190857.42,198352.86,7495.44,1236747.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252843',4823999,'2965','454',66192.47,66192.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252843',4824000,'2966','454',264391.92,264391.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252843',4824001,'2967','454',92461.08,94032.43,1571.35,259272.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252843',4824002,'2968','454',209944.57,216539.30,6594.73,1088130.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252843',4824003,'2969','454',42641.38,42641.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252843',4824004,'2970','454',125536.72,125536.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252843',4824005,'2971','454',162975.60,162975.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','252843',4824006,'2972','454',55577.32,62127.57,6550.25,1080791.25,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252843',4824007,'2973','454',30033.68,31080.66,1046.98,172751.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252843',4824008,'2974','454',126965.15,126965.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252843',4824009,'2975','454',71713.47,71713.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252843',4824010,'2976','454',102562.22,104634.52,2072.30,341929.50,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252843',4824011,'2977','454',85455.83,85455.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252843',4824012,'2978','454',123724.02,123724.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252843',4824013,'2979','454',66166.39,68278.47,2112.08,348493.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252843',4824014,'2980','454',126211.90,126211.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252843',4824015,'2981','454',47293.64,48216.65,923.01,152296.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252843',4824016,'2982','454',79502.31,79502.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252843',4824017,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','252843',4824018,'2984','454',89906.88,89906.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','252843',4824019,'2985','455',96808.70,98077.34,1268.64,437680.80,0.00,0.00,0.00,0.00,0.00),('1','122','1007','252843',4824020,'2986','455',42323.32,42323.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','252843',4824021,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','252843',4824022,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253298',4831644,'2961','454',259642.73,259642.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253298',4831645,'2962','454',78574.36,82743.38,4169.02,687888.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253298',4831646,'2963','454',113514.04,118573.67,5059.63,834838.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253298',4831647,'2964','454',198352.86,198352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253298',4831648,'2965','454',66192.47,68868.95,2676.48,441619.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253298',4831649,'2966','454',264391.92,269169.98,4778.06,788379.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253298',4831650,'2967','454',94032.43,94032.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253298',4831651,'2968','454',216539.30,220327.21,3787.91,625005.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253298',4831652,'2969','454',42641.38,45452.13,2810.75,463773.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253298',4831653,'2970','454',125536.72,129720.30,4183.58,690290.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253298',4831654,'2971','454',162975.60,165387.43,2411.83,397951.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253298',4831655,'2972','454',62127.57,62127.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253298',4831656,'2973','454',31080.66,31080.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253298',4831657,'2974','454',126965.15,126965.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253298',4831658,'2975','454',71713.47,71713.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253298',4831659,'2976','454',104634.52,104634.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253298',4831660,'2977','454',85455.83,85455.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253298',4831661,'2978','454',123724.02,123724.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253298',4831662,'2979','454',68278.47,68278.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253298',4831663,'2980','454',126211.90,126211.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253298',4831664,'2981','454',48216.65,48216.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253298',4831665,'2982','454',79502.31,79502.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253298',4831666,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253298',4831667,'2984','454',89906.88,89906.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','253298',4831668,'2985','455',98077.34,99351.41,1274.07,439554.15,0.00,0.00,0.00,0.00,0.00),('1','122','1007','253298',4831669,'2986','455',42323.32,42323.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','253298',4831670,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','253298',4831671,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253557',4836048,'2961','454',259642.73,259642.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253557',4836049,'2962','454',82743.38,82743.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253557',4836050,'2963','454',118573.67,118573.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253557',4836051,'2964','454',198352.86,198352.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253557',4836052,'2965','454',68868.95,68868.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253557',4836053,'2966','454',269169.98,269169.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253557',4836054,'2967','454',94032.43,94032.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253557',4836055,'2968','454',220327.21,220327.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253557',4836056,'2969','454',45452.13,45452.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253557',4836057,'2970','454',129720.30,129720.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253557',4836058,'2971','454',165387.43,165387.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253557',4836059,'2972','454',62127.57,62127.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253557',4836060,'2973','454',31080.66,35848.46,4767.80,786687.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253557',4836061,'2974','454',126965.15,127414.28,449.13,74106.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253557',4836062,'2975','454',71713.47,76427.98,4714.51,777894.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253557',4836063,'2976','454',104634.52,104634.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253557',4836064,'2977','454',85455.83,91035.81,5579.98,920696.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253557',4836065,'2978','454',123724.02,123724.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253557',4836066,'2979','454',68278.47,68278.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253557',4836067,'2980','454',126211.90,131230.13,5018.23,828007.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253557',4836068,'2981','454',48216.65,48216.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253557',4836069,'2982','454',79502.31,84663.17,5160.86,851541.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253557',4836070,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253557',4836071,'2984','454',89906.88,94469.10,4562.22,752766.30,0.00,0.00,0.00,0.00,0.00),('1','122','1007','253557',4836072,'2985','455',99351.41,102626.62,3275.21,1129947.45,0.00,0.00,0.00,0.00,0.00),('1','122','1007','253557',4836073,'2986','455',42323.32,44823.32,2500.00,862500.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','253557',4836074,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','253557',4836075,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253779',4839830,'2961','454',259642.73,259642.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253779',4839831,'2962','454',82743.38,86733.48,3990.10,658366.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253779',4839832,'2963','454',118573.67,118573.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253779',4839833,'2964','454',198352.86,202815.90,4463.04,736401.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253779',4839834,'2965','454',68868.95,72954.50,4085.55,674115.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253779',4839835,'2966','454',269169.98,269169.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253779',4839836,'2967','454',94032.43,94032.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253779',4839837,'2968','454',220327.21,226534.00,6206.79,1024120.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253779',4839838,'2969','454',45452.13,45452.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253779',4839839,'2970','454',129720.30,130990.71,1270.41,209617.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253779',4839840,'2971','454',165387.43,165387.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','253779',4839841,'2972','454',62127.57,62127.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253779',4839842,'2973','454',35848.46,35848.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253779',4839843,'2974','454',127414.28,127414.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253779',4839844,'2975','454',76427.98,76427.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253779',4839845,'2976','454',104634.52,108167.14,3532.62,582882.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253779',4839846,'2977','454',91035.81,91035.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253779',4839847,'2978','454',123724.02,123724.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253779',4839848,'2979','454',68278.47,72166.01,3887.54,641444.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253779',4839849,'2980','454',131230.13,131230.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253779',4839850,'2981','454',48216.65,50428.66,2212.01,364981.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253779',4839851,'2982','454',84663.17,84663.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253779',4839852,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','253779',4839853,'2984','454',94469.10,94469.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','253779',4839854,'2985','455',102626.62,103037.90,411.28,141891.60,0.00,0.00,0.00,0.00,0.00),('1','122','1007','253779',4839855,'2986','455',44823.32,44823.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','253779',4839856,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','253779',4839857,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254040',4844491,'2961','454',259642.73,259642.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254040',4844492,'2962','454',86733.48,90168.31,3414.83,563446.95,0.00,0.00,20.00,0.00,0.00),('1','122','1004','254040',4844493,'2963','454',118573.67,122561.24,3987.57,657949.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254040',4844494,'2964','454',202815.90,202815.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254040',4844495,'2965','454',72954.50,72954.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254040',4844496,'2966','454',269169.98,273747.10,4577.12,755224.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254040',4844497,'2967','454',94032.43,99251.95,5219.52,861220.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254040',4844498,'2968','454',226534.00,226534.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254040',4844499,'2969','454',45452.13,50262.11,4809.98,793646.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254040',4844500,'2970','454',130990.71,130990.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254040',4844501,'2971','454',165387.43,169189.91,3802.48,627409.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254040',4844502,'2972','454',62127.57,62127.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254040',4844503,'2973','454',35848.46,35848.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254040',4844504,'2974','454',127414.28,127414.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254040',4844505,'2975','454',76427.98,76427.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254040',4844506,'2976','454',108167.14,108167.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254040',4844507,'2977','454',91035.81,91035.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254040',4844508,'2978','454',123724.02,123724.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254040',4844509,'2979','454',72166.01,72166.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254040',4844510,'2980','454',131230.13,131230.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254040',4844511,'2981','454',50428.66,50428.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254040',4844512,'2982','454',84663.17,84663.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254040',4844513,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254040',4844514,'2984','454',94469.10,94469.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','254040',4844515,'2985','455',103037.90,104679.41,1616.51,557695.95,0.00,0.00,25.00,0.00,0.00),('1','122','1007','254040',4844516,'2986','455',44823.32,44823.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','254040',4844517,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','254040',4844518,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254276',4848666,'2961','454',259642.73,259642.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254276',4848667,'2962','454',90168.31,90168.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254276',4848668,'2963','454',122561.24,122561.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254276',4848669,'2964','454',202815.90,207148.06,4332.16,714806.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254276',4848670,'2965','454',72954.50,72954.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254276',4848671,'2966','454',273747.10,273747.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254276',4848672,'2967','454',99251.95,99251.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254276',4848673,'2968','454',226534.00,226534.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254276',4848674,'2969','454',50262.11,50262.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254276',4848675,'2970','454',130990.71,130990.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254276',4848676,'2971','454',169189.91,169189.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254276',4848677,'2972','454',62127.57,62127.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254276',4848678,'2973','454',35848.46,35848.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254276',4848679,'2974','454',127414.28,134473.87,7059.59,1164832.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254276',4848680,'2975','454',76427.98,76427.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254276',4848681,'2976','454',108167.14,108167.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254276',4848682,'2977','454',91035.81,91035.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254276',4848683,'2978','454',123724.02,127655.23,3926.70,647905.50,0.00,0.00,4.51,0.00,0.00),('1','122','1006','254276',4848684,'2979','454',72166.01,72166.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254276',4848685,'2980','454',131230.13,131230.13,-6.00,-990.00,0.00,0.00,6.00,0.00,0.00),('1','122','1006','254276',4848686,'2981','454',50428.66,50428.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254276',4848687,'2982','454',84663.17,88479.82,3816.65,629747.25,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254276',4848688,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254276',4848689,'2984','454',94469.10,94469.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','254276',4848690,'2985','455',104679.41,105430.98,751.57,259291.65,0.00,0.00,0.00,0.00,0.00),('1','122','1007','254276',4848691,'2986','455',44823.32,44823.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','254276',4848692,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','254276',4848693,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254539',4853266,'2961','454',259642.73,259642.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254539',4853267,'2962','454',90168.31,90168.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254539',4853268,'2963','454',122561.24,122561.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254539',4853269,'2964','454',207148.06,207148.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254539',4853270,'2965','454',72954.50,72954.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254539',4853271,'2966','454',273747.10,273747.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254539',4853272,'2967','454',99251.95,99251.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254539',4853273,'2968','454',226534.00,226534.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254539',4853274,'2969','454',50262.11,50262.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254539',4853275,'2970','454',130990.71,130990.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254539',4853276,'2971','454',169189.91,169189.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254539',4853277,'2972','454',62127.57,62127.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254539',4853278,'2973','454',35848.46,37235.16,1386.70,228805.50,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254539',4853279,'2974','454',134473.87,134473.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254539',4853280,'2975','454',76427.98,76427.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254539',4853281,'2976','454',108167.14,108167.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254539',4853282,'2977','454',91035.81,91035.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254539',4853283,'2978','454',127655.23,127655.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254539',4853284,'2979','454',72166.01,72166.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254539',4853285,'2980','454',131230.13,138013.68,6783.55,1119285.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254539',4853286,'2981','454',50428.66,57492.65,7063.99,1165558.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254539',4853287,'2982','454',88479.82,88479.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254539',4853288,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254539',4853289,'2984','454',94469.10,94469.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','254539',4853290,'2985','455',105430.98,106965.60,1534.62,529443.90,0.00,0.00,0.00,0.00,0.00),('1','122','1007','254539',4853291,'2986','455',44823.32,44823.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','254539',4853292,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','254539',4853293,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254627',4854947,'2961','454',259642.73,259642.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254627',4854948,'2962','454',90168.31,90168.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254627',4854949,'2963','454',122561.24,124897.64,2336.40,385506.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254627',4854950,'2964','454',207148.06,215638.05,8489.99,1400848.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254627',4854951,'2965','454',72954.50,72954.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254627',4854952,'2966','454',273747.10,273747.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254627',4854953,'2967','454',99251.95,100877.00,1625.05,268133.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254627',4854954,'2968','454',226534.00,226534.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254627',4854955,'2969','454',50262.11,53157.73,2895.62,477777.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254627',4854956,'2970','454',130990.71,136485.95,5495.24,906714.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254627',4854957,'2971','454',169189.91,170712.81,1522.90,251278.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','254627',4854958,'2972','454',62127.57,65137.96,3010.39,496714.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254627',4854959,'2973','454',37235.16,37235.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254627',4854960,'2974','454',134473.87,134473.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254627',4854961,'2975','454',76427.98,76427.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254627',4854962,'2976','454',108167.14,108167.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254627',4854963,'2977','454',91035.81,91035.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254627',4854964,'2978','454',127655.23,127655.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254627',4854965,'2979','454',72166.01,72166.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254627',4854966,'2980','454',138013.68,138013.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254627',4854967,'2981','454',57492.65,57492.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254627',4854968,'2982','454',88479.82,88479.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254627',4854969,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','254627',4854970,'2984','454',94469.10,94469.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','254627',4854971,'2985','455',106965.60,109727.20,2761.60,966560.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','254627',4854972,'2986','455',44823.32,44823.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','254627',4854973,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','254627',4854974,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255022',4861445,'2961','454',259642.73,259642.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255022',4861446,'2962','454',90168.31,95677.35,5509.04,908991.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255022',4861447,'2963','454',124897.64,124897.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255022',4861448,'2964','454',215638.05,216324.78,686.73,113310.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255022',4861449,'2965','454',72954.50,73930.75,976.25,161081.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255022',4861450,'2966','454',273747.10,278961.63,5214.53,860397.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255022',4861451,'2967','454',100877.00,100877.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255022',4861452,'2968','454',226534.00,232049.33,5515.33,910029.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255022',4861453,'2969','454',53157.73,53157.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255022',4861454,'2970','454',136485.95,136485.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255022',4861455,'2971','454',170712.81,177451.67,6738.86,1111911.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255022',4861456,'2972','454',65137.96,65137.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255022',4861457,'2973','454',37235.16,37235.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255022',4861458,'2974','454',134473.87,134473.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255022',4861459,'2975','454',76427.98,76427.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255022',4861460,'2976','454',108167.14,108167.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255022',4861461,'2977','454',91035.81,91035.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255022',4861462,'2978','454',127655.23,127655.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255022',4861463,'2979','454',72166.01,72166.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255022',4861464,'2980','454',138013.68,138013.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255022',4861465,'2981','454',57492.65,57492.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255022',4861466,'2982','454',88479.82,88479.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255022',4861467,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255022',4861468,'2984','454',94469.10,94469.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','255022',4861469,'2985','455',109727.20,111150.73,1423.53,498235.50,0.00,0.00,0.00,0.00,0.00),('1','122','1007','255022',4861470,'2986','455',44823.32,44823.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','255022',4861471,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','255022',4861472,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255279',4866120,'2961','454',259642.73,259642.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255279',4866121,'2962','454',95677.35,95677.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255279',4866122,'2963','454',124897.64,130426.90,5529.26,912327.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255279',4866123,'2964','454',216324.78,216324.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255279',4866124,'2965','454',73930.75,77642.02,3711.27,612359.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255279',4866125,'2966','454',278961.63,278961.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255279',4866126,'2967','454',100877.00,100877.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255279',4866127,'2968','454',232049.33,232049.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255279',4866128,'2969','454',53157.73,53157.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255279',4866129,'2970','454',136485.95,142291.00,5805.05,957833.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255279',4866130,'2971','454',177451.67,177451.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255279',4866131,'2972','454',65137.96,65137.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255279',4866132,'2973','454',37235.16,37235.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255279',4866133,'2974','454',134473.87,134473.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255279',4866134,'2975','454',76427.98,76427.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255279',4866135,'2976','454',108167.14,108167.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255279',4866136,'2977','454',91035.81,92069.16,1033.35,170502.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255279',4866137,'2978','454',127655.23,127910.95,255.72,42193.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255279',4866138,'2979','454',72166.01,72166.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255279',4866139,'2980','454',138013.68,138013.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255279',4866140,'2981','454',57492.65,57492.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255279',4866141,'2982','454',88479.82,88479.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255279',4866142,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255279',4866143,'2984','454',94469.10,94469.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','255279',4866144,'2985','455',111150.73,114499.30,3348.57,1188742.35,0.00,0.00,0.00,0.00,0.00),('1','122','1007','255279',4866145,'2986','455',44823.32,46380.60,1557.28,552834.40,0.00,0.00,0.00,0.00,0.00),('1','122','1007','255279',4866146,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','255279',4866147,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255530',4870012,'2961','454',259642.73,259642.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255530',4870013,'2962','454',95677.35,105637.25,9959.90,1643383.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255530',4870014,'2963','454',130426.90,130426.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255530',4870015,'2964','454',216324.78,216324.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255530',4870016,'2965','454',77642.02,77642.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255530',4870017,'2966','454',278961.63,278961.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255530',4870018,'2967','454',100877.00,112709.27,11832.27,1952324.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255530',4870019,'2968','454',232049.33,232049.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255530',4870020,'2969','454',53157.73,53157.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255530',4870021,'2970','454',142291.00,142291.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255530',4870022,'2971','454',177451.67,177451.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255530',4870023,'2972','454',65137.96,75370.49,10232.53,1688367.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255530',4870024,'2973','454',37235.16,37235.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255530',4870025,'2974','454',134473.87,134473.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255530',4870026,'2975','454',76427.98,76427.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255530',4870027,'2976','454',108167.14,108167.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255530',4870028,'2977','454',92069.16,92069.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255530',4870029,'2978','454',127910.95,127910.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255530',4870030,'2979','454',72166.01,72166.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255530',4870031,'2980','454',138013.68,138013.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255530',4870032,'2981','454',57492.65,57492.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255530',4870033,'2982','454',88479.82,88479.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255530',4870034,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255530',4870035,'2984','454',94469.10,94469.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','255530',4870036,'2985','455',114499.30,117384.36,2885.06,1024196.30,0.00,0.00,0.00,0.00,0.00),('1','122','1007','255530',4870037,'2986','455',46380.60,46538.35,157.75,56001.25,0.00,0.00,0.00,0.00,0.00),('1','122','1007','255530',4870038,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','255530',4870039,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255790',4874367,'2961','454',259642.73,259642.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255790',4874368,'2962','454',105637.25,112811.38,7174.13,1183731.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255790',4874369,'2963','454',130426.90,130426.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255790',4874370,'2964','454',216324.78,216324.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255790',4874371,'2965','454',77642.02,86311.09,8669.07,1430396.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255790',4874372,'2966','454',278961.63,278961.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255790',4874373,'2967','454',112709.27,112709.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255790',4874374,'2968','454',232049.33,232049.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255790',4874375,'2969','454',53157.73,53157.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255790',4874376,'2970','454',142291.00,152496.94,10205.94,1683980.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255790',4874377,'2971','454',177451.67,177451.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','255790',4874378,'2972','454',75370.49,75370.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255790',4874379,'2973','454',37235.16,37235.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255790',4874380,'2974','454',134473.87,134473.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255790',4874381,'2975','454',76427.98,76427.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255790',4874382,'2976','454',108167.14,108167.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255790',4874383,'2977','454',92069.16,92069.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255790',4874384,'2978','454',127910.95,127910.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255790',4874385,'2979','454',72166.01,72166.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255790',4874386,'2980','454',138013.68,138013.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255790',4874387,'2981','454',57492.65,57492.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255790',4874388,'2982','454',88479.82,88479.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255790',4874389,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','255790',4874390,'2984','454',94469.10,94469.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','255790',4874391,'2985','455',117384.36,120128.27,2733.91,970538.05,0.00,0.00,10.00,0.00,0.00),('1','122','1007','255790',4874392,'2986','455',46538.35,47738.35,1188.00,421740.00,0.00,0.00,12.00,0.00,0.00),('1','122','1007','255790',4874393,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','255790',4874394,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256042',4878703,'2961','454',259642.73,259642.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256042',4878704,'2962','454',112811.38,112811.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256042',4878705,'2963','454',130426.90,133848.44,3401.54,561254.10,0.00,0.00,20.00,0.00,0.00),('1','122','1004','256042',4878706,'2964','454',216324.78,216324.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256042',4878707,'2965','454',86311.09,86311.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256042',4878708,'2966','454',278961.63,278961.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256042',4878709,'2967','454',112709.27,112709.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256042',4878710,'2968','454',232049.33,235994.64,3930.31,648501.15,0.00,0.00,15.00,0.00,0.00),('1','122','1004','256042',4878711,'2969','454',53157.73,53157.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256042',4878712,'2970','454',152496.94,152496.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256042',4878713,'2971','454',177451.67,181465.49,4003.82,660630.30,0.00,0.00,10.00,0.00,0.00),('1','122','1004','256042',4878714,'2972','454',75370.49,75370.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256042',4878715,'2973','454',37235.16,37235.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256042',4878716,'2974','454',134473.87,134473.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256042',4878717,'2975','454',76427.98,76427.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256042',4878718,'2976','454',108167.14,108167.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256042',4878719,'2977','454',92069.16,92069.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256042',4878720,'2978','454',127910.95,127910.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256042',4878721,'2979','454',72166.01,72166.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256042',4878722,'2980','454',138013.68,138013.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256042',4878723,'2981','454',57492.65,57492.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256042',4878724,'2982','454',88479.82,88479.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256042',4878725,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256042',4878726,'2984','454',94469.10,94469.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','256042',4878727,'2985','455',120128.27,120793.32,665.05,236092.75,0.00,0.00,0.00,0.00,0.00),('1','122','1007','256042',4878728,'2986','455',47738.35,48044.57,306.22,108708.10,0.00,0.00,0.00,0.00,0.00),('1','122','1007','256042',4878729,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','256042',4878730,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256288',4882407,'2961','454',259642.73,267095.07,7452.34,1229636.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256288',4882408,'2962','454',112811.38,113380.13,568.75,93843.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256288',4882409,'2963','454',133848.44,133848.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256288',4882410,'2964','454',216324.78,216324.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256288',4882411,'2965','454',86311.09,86311.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256288',4882412,'2966','454',278961.63,288942.81,9981.18,1646894.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256288',4882413,'2967','454',112709.27,112709.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256288',4882414,'2968','454',235994.64,235994.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256288',4882415,'2969','454',53157.73,64629.00,11471.27,1892759.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256288',4882416,'2970','454',152496.94,152496.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256288',4882417,'2971','454',181465.49,181465.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256288',4882418,'2972','454',75370.49,75370.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256288',4882419,'2973','454',37235.16,37235.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256288',4882420,'2974','454',134473.87,134473.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256288',4882421,'2975','454',76427.98,76427.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256288',4882422,'2976','454',108167.14,108167.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256288',4882423,'2977','454',92069.16,92069.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256288',4882424,'2978','454',127910.95,127985.09,21.14,3488.10,0.00,0.00,53.00,0.00,0.00),('1','122','1006','256288',4882425,'2979','454',72166.01,81042.87,8876.86,1464681.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256288',4882426,'2980','454',138013.68,138013.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256288',4882427,'2981','454',57492.65,68626.76,11134.11,1837128.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256288',4882428,'2982','454',88479.82,88479.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256288',4882429,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256288',4882430,'2984','454',94469.10,94469.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','256288',4882431,'2985','455',120793.32,123606.81,2813.49,998788.95,0.00,0.00,0.00,0.00,0.00),('1','122','1007','256288',4882432,'2986','455',48044.57,49159.07,1114.50,395647.50,0.00,0.00,0.00,0.00,0.00),('1','122','1007','256288',4882433,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','256288',4882434,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256562',4887204,'2961','454',267095.07,267095.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256562',4887205,'2962','454',113380.13,114477.48,1097.35,181062.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256562',4887206,'2963','454',133848.44,133848.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256562',4887207,'2964','454',216324.78,219186.68,2861.90,472213.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256562',4887208,'2965','454',86311.09,86311.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256562',4887209,'2966','454',288942.81,288942.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256562',4887210,'2967','454',112709.27,124664.57,11955.30,1972624.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256562',4887211,'2968','454',235994.64,235994.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256562',4887212,'2969','454',64629.00,64629.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256562',4887213,'2970','454',152496.94,152496.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256562',4887214,'2971','454',181465.49,181465.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256562',4887215,'2972','454',75370.49,75370.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256562',4887216,'2973','454',37235.16,46517.86,9282.70,1531645.50,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256562',4887217,'2974','454',134473.87,134473.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256562',4887218,'2975','454',76427.98,76427.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256562',4887219,'2976','454',108167.14,108167.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256562',4887220,'2977','454',92069.16,100014.97,7945.81,1311058.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256562',4887221,'2978','454',127985.09,127985.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256562',4887222,'2979','454',81042.87,81042.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256562',4887223,'2980','454',138013.68,138013.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256562',4887224,'2981','454',68626.76,68626.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256562',4887225,'2982','454',88479.82,88479.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256562',4887226,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256562',4887227,'2984','454',94469.10,101765.50,7296.40,1203906.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','256562',4887228,'2985','455',123606.81,125589.62,1982.81,703897.55,0.00,0.00,0.00,0.00,0.00),('1','122','1007','256562',4887229,'2986','455',49159.07,49229.49,70.42,24999.10,0.00,0.00,0.00,0.00,0.00),('1','122','1007','256562',4887230,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','256562',4887231,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256795',4891055,'2961','454',267095.07,267095.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256795',4891056,'2962','454',114477.48,114477.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256795',4891057,'2963','454',133848.44,133848.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256795',4891058,'2964','454',219186.68,219186.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256795',4891059,'2965','454',86311.09,86311.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256795',4891060,'2966','454',288942.81,288942.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256795',4891061,'2967','454',124664.57,124664.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256795',4891062,'2968','454',235994.64,235994.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256795',4891063,'2969','454',64629.00,64629.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256795',4891064,'2970','454',152496.94,152496.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256795',4891065,'2971','454',181465.49,181465.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','256795',4891066,'2972','454',75370.49,75370.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256795',4891067,'2973','454',46517.86,46517.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256795',4891068,'2974','454',134473.87,134473.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256795',4891069,'2975','454',76427.98,88337.56,11909.58,1965080.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256795',4891070,'2976','454',108167.14,108167.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256795',4891071,'2977','454',100014.97,100014.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256795',4891072,'2978','454',127985.09,132809.26,4824.17,795988.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256795',4891073,'2979','454',81042.87,81042.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256795',4891074,'2980','454',138013.68,149072.74,11049.06,1823094.90,0.00,0.00,10.00,0.00,0.00),('1','122','1006','256795',4891075,'2981','454',68626.76,80288.58,11651.82,1922550.30,0.00,0.00,10.00,0.00,0.00),('1','122','1006','256795',4891076,'2982','454',88479.82,88500.12,0.00,0.00,0.00,0.00,20.30,0.00,0.00),('1','122','1006','256795',4891077,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','256795',4891078,'2984','454',101765.50,102932.46,1156.96,190898.40,0.00,0.00,10.00,0.00,0.00),('1','122','1007','256795',4891079,'2985','455',125589.62,127365.92,1776.30,630586.50,0.00,0.00,0.00,0.00,0.00),('1','122','1007','256795',4891080,'2986','455',49229.49,50729.49,1500.00,532500.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','256795',4891081,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','256795',4891082,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257043',4895455,'2961','454',267095.07,267095.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257043',4895456,'2962','454',114477.48,118997.32,4519.84,745773.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257043',4895457,'2963','454',133848.44,133848.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257043',4895458,'2964','454',219186.68,223621.78,4435.10,731791.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257043',4895459,'2965','454',86311.09,86311.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257043',4895460,'2966','454',288942.81,288942.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257043',4895461,'2967','454',124664.57,128835.42,4170.85,688190.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257043',4895462,'2968','454',235994.64,235994.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257043',4895463,'2969','454',64629.00,64629.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257043',4895464,'2970','454',152496.94,156792.49,4295.55,708765.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257043',4895465,'2971','454',181465.49,185499.99,4034.50,665692.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257043',4895466,'2972','454',75370.49,75370.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257043',4895467,'2973','454',46517.86,46517.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257043',4895468,'2974','454',134473.87,134473.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257043',4895469,'2975','454',88337.56,88337.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257043',4895470,'2976','454',108167.14,108167.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257043',4895471,'2977','454',100014.97,100014.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257043',4895472,'2978','454',132809.26,132809.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257043',4895473,'2979','454',81042.87,81161.38,118.51,19554.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257043',4895474,'2980','454',149072.74,149072.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257043',4895475,'2981','454',80288.58,80288.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257043',4895476,'2982','454',88500.12,88500.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257043',4895477,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257043',4895478,'2984','454',102932.46,102932.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257043',4895479,'2985','455',127365.92,127935.76,569.84,202293.20,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257043',4895480,'2986','455',50729.49,50919.29,189.80,67379.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257043',4895481,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257043',4895482,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257313',4900321,'2961','454',267095.07,267111.92,0.00,0.00,0.00,0.00,16.85,0.00,0.00),('1','122','1004','257313',4900322,'2962','454',118997.32,123899.26,4861.94,802220.10,0.00,0.00,40.00,0.00,0.00),('1','122','1004','257313',4900323,'2963','454',133848.44,133848.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257313',4900324,'2964','454',223621.78,223621.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257313',4900325,'2965','454',86311.09,86341.09,0.00,0.00,0.00,0.00,30.00,0.00,0.00),('1','122','1004','257313',4900326,'2966','454',288942.81,298296.01,9343.20,1541628.00,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257313',4900327,'2967','454',128835.42,128835.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257313',4900328,'2968','454',235994.64,235994.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257313',4900329,'2969','454',64629.00,64629.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257313',4900330,'2970','454',156792.49,166683.51,9851.02,1625418.30,0.00,0.00,40.00,0.00,0.00),('1','122','1004','257313',4900331,'2971','454',185499.99,185499.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257313',4900332,'2972','454',75370.49,75370.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257313',4900333,'2973','454',46517.86,46517.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257313',4900334,'2974','454',134473.87,134473.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257313',4900335,'2975','454',88337.56,100530.12,12192.56,2011772.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257313',4900336,'2976','454',108167.14,108167.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257313',4900337,'2977','454',100014.97,100014.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257313',4900338,'2978','454',132809.26,144637.68,11808.42,1948389.30,0.00,0.00,20.00,0.00,0.00),('1','122','1006','257313',4900339,'2979','454',81161.38,81161.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257313',4900340,'2980','454',149072.74,149072.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257313',4900341,'2981','454',80288.58,80288.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257313',4900342,'2982','454',88500.12,97762.18,9262.06,1528239.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257313',4900343,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257313',4900344,'2984','454',102932.46,102932.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257313',4900345,'2985','455',127935.76,128548.84,613.08,220708.80,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257313',4900346,'2986','455',50919.29,50919.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257313',4900347,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257313',4900348,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257567',4904649,'2961','454',267111.92,267111.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257567',4904650,'2962','454',123899.26,128484.77,4565.51,753309.15,0.00,0.00,20.00,0.00,0.00),('1','122','1004','257567',4904651,'2963','454',133848.44,133848.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257567',4904652,'2964','454',223621.78,225770.46,2148.68,354532.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257567',4904653,'2965','454',86341.09,87816.80,1475.71,243492.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257567',4904654,'2966','454',298296.01,302645.42,4349.41,717652.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257567',4904655,'2967','454',128835.42,128835.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257567',4904656,'2968','454',235994.64,239806.42,3811.78,628943.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257567',4904657,'2969','454',64629.00,64629.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257567',4904658,'2970','454',166683.51,172029.22,5345.71,882042.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257567',4904659,'2971','454',185499.99,185499.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257567',4904660,'2972','454',75370.49,79180.26,3809.77,628612.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257567',4904661,'2973','454',46517.86,46517.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257567',4904662,'2974','454',134473.87,135787.60,1313.73,216765.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257567',4904663,'2975','454',100530.12,101827.85,1297.73,214125.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257567',4904664,'2976','454',108167.14,108167.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257567',4904665,'2977','454',100014.97,101294.01,1279.04,211041.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257567',4904666,'2978','454',144637.68,144731.63,93.95,15501.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257567',4904667,'2979','454',81161.38,81161.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257567',4904668,'2980','454',149072.74,149072.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257567',4904669,'2981','454',80288.58,80288.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257567',4904670,'2982','454',97762.18,98965.95,1203.77,198622.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257567',4904671,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257567',4904672,'2984','454',102932.46,104439.97,1507.51,248739.15,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257567',4904673,'2985','455',128548.84,128562.73,13.89,5000.40,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257567',4904674,'2986','455',50919.29,50919.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257567',4904675,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257567',4904676,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257568',4904677,'2961','454',267111.92,267111.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257568',4904678,'2962','454',128484.77,128484.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257568',4904679,'2963','454',133848.44,142616.30,8767.86,1446696.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257568',4904680,'2964','454',225770.46,225770.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257568',4904681,'2965','454',87816.80,87816.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257568',4904682,'2966','454',302645.42,302645.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257568',4904683,'2967','454',128835.42,139003.85,10168.43,1677790.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257568',4904684,'2968','454',239806.42,239806.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257568',4904685,'2969','454',64629.00,64629.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257568',4904686,'2970','454',172029.22,172029.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257568',4904687,'2971','454',185499.99,185499.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257568',4904688,'2972','454',79180.26,90603.81,11423.55,1884885.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257568',4904689,'2973','454',46517.86,46517.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257568',4904690,'2974','454',135787.60,135787.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257568',4904691,'2975','454',101827.85,101827.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257568',4904692,'2976','454',108167.14,108167.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257568',4904693,'2977','454',101294.01,101294.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257568',4904694,'2978','454',144731.63,144731.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257568',4904695,'2979','454',81161.38,81161.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257568',4904696,'2980','454',149072.74,149072.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257568',4904697,'2981','454',80288.58,80288.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257568',4904698,'2982','454',98965.95,98965.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257568',4904699,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257568',4904700,'2984','454',104439.97,104439.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257568',4904701,'2985','455',128562.73,128562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257568',4904702,'2986','455',50919.29,50919.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257568',4904703,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257568',4904704,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257569',4904705,'2961','454',267111.92,267135.49,-0.01,-1.65,0.00,0.00,23.58,0.00,0.00),('1','122','1004','257569',4904706,'2962','454',128484.77,140488.59,11973.82,1975680.30,0.00,0.00,30.00,0.00,0.00),('1','122','1004','257569',4904707,'2963','454',142616.30,142616.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257569',4904708,'2964','454',225770.46,227136.34,1345.88,222070.20,0.00,0.00,20.00,0.00,0.00),('1','122','1004','257569',4904709,'2965','454',87816.80,96417.60,8580.80,1415832.00,0.00,0.00,20.00,0.00,0.00),('1','122','1004','257569',4904710,'2966','454',302645.42,306539.99,3884.57,640954.05,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257569',4904711,'2967','454',139003.85,147726.92,8683.07,1432706.55,0.00,0.00,40.00,0.00,0.00),('1','122','1004','257569',4904712,'2968','454',239806.42,242755.64,2919.22,481671.30,0.00,0.00,30.00,0.00,0.00),('1','122','1004','257569',4904713,'2969','454',64629.00,69358.64,4719.64,778740.60,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257569',4904714,'2970','454',172029.22,172029.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257569',4904715,'2971','454',185499.99,186020.25,500.26,82542.90,0.00,0.00,20.00,0.00,0.00),('1','122','1004','257569',4904716,'2972','454',90603.81,91113.81,500.00,82500.00,0.00,0.00,10.00,0.00,0.00),('1','122','1006','257569',4904717,'2973','454',46517.86,46517.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257569',4904718,'2974','454',135787.60,135787.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257569',4904719,'2975','454',101827.85,101827.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257569',4904720,'2976','454',108167.14,108167.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257569',4904721,'2977','454',101294.01,101294.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257569',4904722,'2978','454',144731.63,144731.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257569',4904723,'2979','454',81161.38,81161.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257569',4904724,'2980','454',149072.74,149072.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257569',4904725,'2981','454',80288.58,80288.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257569',4904726,'2982','454',98965.95,98965.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257569',4904727,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257569',4904728,'2984','454',104439.97,104439.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257569',4904729,'2985','455',128562.73,128562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257569',4904730,'2986','455',50919.29,50919.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257569',4904731,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257569',4904732,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257570',4904733,'2961','454',267135.49,277897.43,10761.94,1775720.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257570',4904734,'2962','454',140488.59,140488.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257570',4904735,'2963','454',142616.30,142616.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257570',4904736,'2964','454',227136.34,227136.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257570',4904737,'2965','454',96417.60,104758.67,8341.07,1376276.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257570',4904738,'2966','454',306539.99,306539.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257570',4904739,'2967','454',147726.92,155640.27,7893.35,1302402.75,0.00,0.00,20.00,0.00,0.00),('1','122','1004','257570',4904740,'2968','454',242755.64,242755.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257570',4904741,'2969','454',69358.64,79388.05,10029.41,1654852.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257570',4904742,'2970','454',172029.22,172029.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257570',4904743,'2971','454',186020.25,190204.43,4184.18,690389.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257570',4904744,'2972','454',91113.81,96551.19,5437.38,897167.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257570',4904745,'2973','454',46517.86,46517.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257570',4904746,'2974','454',135787.60,139668.51,3880.91,640350.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257570',4904747,'2975','454',101827.85,101827.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257570',4904748,'2976','454',108167.14,108167.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257570',4904749,'2977','454',101294.01,101294.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257570',4904750,'2978','454',144731.63,144731.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257570',4904751,'2979','454',81161.38,81161.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257570',4904752,'2980','454',149072.74,149072.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257570',4904753,'2981','454',80288.58,80288.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257570',4904754,'2982','454',98965.95,98965.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257570',4904755,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257570',4904756,'2984','454',104439.97,107978.97,3539.00,583935.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257570',4904757,'2985','455',128562.73,128562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257570',4904758,'2986','455',50919.29,50919.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257570',4904759,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257570',4904760,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257571',4904761,'2961','454',277897.43,277897.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257571',4904762,'2962','454',140488.59,140488.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257571',4904763,'2963','454',142616.30,142616.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257571',4904764,'2964','454',227136.34,236506.93,9370.59,1546147.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257571',4904765,'2965','454',104758.67,104758.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257571',4904766,'2966','454',306539.99,306539.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257571',4904767,'2967','454',155640.27,163752.76,8112.49,1338560.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257571',4904768,'2968','454',242755.64,242755.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257571',4904769,'2969','454',79388.05,79388.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257571',4904770,'2970','454',172029.22,172029.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257571',4904771,'2971','454',190204.43,195822.87,5618.44,927042.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257571',4904772,'2972','454',96551.19,99249.52,2698.33,445224.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257571',4904773,'2973','454',46517.86,46517.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257571',4904774,'2974','454',139668.51,150591.95,10923.44,1802367.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257571',4904775,'2975','454',101827.85,101827.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257571',4904776,'2976','454',108167.14,108167.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257571',4904777,'2977','454',101294.01,111727.59,10433.58,1721540.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257571',4904778,'2978','454',144731.63,144731.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257571',4904779,'2979','454',81161.38,81161.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257571',4904780,'2980','454',149072.74,149072.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257571',4904781,'2981','454',80288.58,88656.87,8368.29,1380767.85,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257571',4904782,'2982','454',98965.95,98965.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257571',4904783,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257571',4904784,'2984','454',107978.97,107978.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257571',4904785,'2985','455',128562.73,130192.38,1629.65,586674.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257571',4904786,'2986','455',50919.29,50919.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257571',4904787,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257571',4904788,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257572',4904789,'2961','454',277897.43,282598.82,4681.39,772429.35,0.00,0.00,20.00,0.00,0.00),('1','122','1004','257572',4904790,'2962','454',140488.59,142840.19,2351.60,388014.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257572',4904791,'2963','454',142616.30,142616.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257572',4904792,'2964','454',236506.93,236506.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257572',4904793,'2965','454',104758.67,110127.99,5369.32,885937.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257572',4904794,'2966','454',306539.99,306539.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257572',4904795,'2967','454',163752.76,163752.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257572',4904796,'2968','454',242755.64,242755.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257572',4904797,'2969','454',79388.05,82922.15,3519.10,580651.50,0.00,0.00,15.00,0.00,0.00),('1','122','1004','257572',4904798,'2970','454',172029.22,173831.20,1801.98,297326.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257572',4904799,'2971','454',195822.87,195822.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257572',4904800,'2972','454',99249.52,103104.72,3825.20,631158.00,0.00,0.00,30.00,0.00,0.00),('1','122','1006','257572',4904801,'2973','454',46517.86,51958.56,5440.70,897715.50,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257572',4904802,'2974','454',150591.95,150591.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257572',4904803,'2975','454',101827.85,101827.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257572',4904804,'2976','454',108167.14,109098.84,931.70,153730.50,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257572',4904805,'2977','454',111727.59,112491.80,764.21,126094.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257572',4904806,'2978','454',144731.63,144731.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257572',4904807,'2979','454',81161.38,81161.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257572',4904808,'2980','454',149072.74,149072.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257572',4904809,'2981','454',88656.87,88656.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257572',4904810,'2982','454',98965.95,104264.96,5299.01,874336.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257572',4904811,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257572',4904812,'2984','454',107978.97,107978.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257572',4904813,'2985','455',130192.38,132016.63,1824.25,656730.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257572',4904814,'2986','455',50919.29,50919.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257572',4904815,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257572',4904816,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257573',4904817,'2961','454',282598.82,282598.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257573',4904818,'2962','454',142840.19,150728.77,7888.58,1301615.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257573',4904819,'2963','454',142616.30,142616.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257573',4904820,'2964','454',236506.93,245273.92,8766.99,1446553.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257573',4904821,'2965','454',110127.99,120650.18,10522.19,1736161.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257573',4904822,'2966','454',306539.99,306539.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257573',4904823,'2967','454',163752.76,163752.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257573',4904824,'2968','454',242755.64,242755.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257573',4904825,'2969','454',82922.15,82922.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257573',4904826,'2970','454',173831.20,179151.84,5320.64,877905.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257573',4904827,'2971','454',195822.87,200482.39,4659.52,768820.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257573',4904828,'2972','454',103104.72,108455.56,5350.84,882888.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257573',4904829,'2973','454',51958.56,51958.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257573',4904830,'2974','454',150591.95,152258.77,1666.82,275025.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257573',4904831,'2975','454',101827.85,101827.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257573',4904832,'2976','454',109098.84,109098.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257573',4904833,'2977','454',112491.80,112491.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257573',4904834,'2978','454',144731.63,144731.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257573',4904835,'2979','454',81161.38,81161.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257573',4904836,'2980','454',149072.74,150465.95,1393.21,229879.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257573',4904837,'2981','454',88656.87,88656.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257573',4904838,'2982','454',104264.96,105570.34,1305.38,215387.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257573',4904839,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257573',4904840,'2984','454',107978.97,107978.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257573',4904841,'2985','455',132016.63,135210.70,3194.07,1149865.20,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257573',4904842,'2986','455',50919.29,50919.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257573',4904843,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257573',4904844,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257574',4904845,'2961','454',282598.82,282598.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257574',4904846,'2962','454',150728.77,150728.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257574',4904847,'2963','454',142616.30,142616.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257574',4904848,'2964','454',245273.92,245273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257574',4904849,'2965','454',120650.18,120650.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257574',4904850,'2966','454',306539.99,306539.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257574',4904851,'2967','454',163752.76,163752.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257574',4904852,'2968','454',242755.64,242755.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257574',4904853,'2969','454',82922.15,82922.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257574',4904854,'2970','454',179151.84,179151.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257574',4904855,'2971','454',200482.39,200482.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257574',4904856,'2972','454',108455.56,108455.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257574',4904857,'2973','454',51958.56,51958.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257574',4904858,'2974','454',152258.77,152258.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257574',4904859,'2975','454',101827.85,101827.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257574',4904860,'2976','454',109098.84,109098.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257574',4904861,'2977','454',112491.80,112491.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257574',4904862,'2978','454',144731.63,144731.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257574',4904863,'2979','454',81161.38,81161.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257574',4904864,'2980','454',150465.95,150465.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257574',4904865,'2981','454',88656.87,88656.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257574',4904866,'2982','454',105570.34,105570.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257574',4904867,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257574',4904868,'2984','454',107978.97,107978.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257574',4904869,'2985','455',135210.70,135710.55,499.85,189943.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257574',4904870,'2986','455',50919.29,50919.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257574',4904871,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257574',4904872,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257575',4904873,'2961','454',282598.82,282598.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257575',4904874,'2962','454',150728.77,152428.04,1699.27,280379.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257575',4904875,'2963','454',142616.30,144173.73,1557.43,256975.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257575',4904876,'2964','454',245273.92,245273.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257575',4904877,'2965','454',120650.18,122694.78,2034.60,335709.00,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257575',4904878,'2966','454',306539.99,306539.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257575',4904879,'2967','454',163752.76,163752.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257575',4904880,'2968','454',242755.64,242755.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257575',4904881,'2969','454',82922.15,83964.61,1042.46,172005.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257575',4904882,'2970','454',179151.84,179151.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257575',4904883,'2971','454',200482.39,201924.02,1441.63,237868.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257575',4904884,'2972','454',108455.56,108455.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257575',4904885,'2973','454',51958.56,51958.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257575',4904886,'2974','454',152258.77,152258.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257575',4904887,'2975','454',101827.85,101827.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257575',4904888,'2976','454',109098.84,118134.84,9036.00,1490940.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257575',4904889,'2977','454',112491.80,118816.31,6324.51,1043544.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257575',4904890,'2978','454',144731.63,144731.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257575',4904891,'2979','454',81161.38,88477.90,7316.52,1207225.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257575',4904892,'2980','454',150465.95,150465.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257575',4904893,'2981','454',88656.87,88656.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257575',4904894,'2982','454',105570.34,114683.13,9112.79,1503610.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257575',4904895,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257575',4904896,'2984','454',107978.97,116772.70,8793.73,1450965.45,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257575',4904897,'2985','455',135710.55,137680.79,1970.24,748691.20,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257575',4904898,'2986','455',50919.29,50919.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257575',4904899,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257575',4904900,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257576',4904901,'2961','454',282598.82,282608.82,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257576',4904902,'2962','454',152428.04,152428.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257576',4904903,'2963','454',144173.73,147556.20,3372.47,556457.55,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257576',4904904,'2964','454',245273.92,249794.83,4510.91,744300.15,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257576',4904905,'2965','454',122694.78,122714.78,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','122','1004','257576',4904906,'2966','454',306539.99,306540.12,0.13,21.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257576',4904907,'2967','454',163752.76,167256.58,3493.82,576480.30,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257576',4904908,'2968','454',242755.64,248441.68,5676.04,936546.60,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257576',4904909,'2969','454',83964.61,83974.61,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257576',4904910,'2970','454',179151.84,179161.84,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257576',4904911,'2971','454',201924.02,201934.02,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257576',4904912,'2972','454',108455.56,117253.67,8778.11,1448388.15,0.00,0.00,20.00,0.00,0.00),('1','122','1006','257576',4904913,'2973','454',51958.56,51958.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257576',4904914,'2974','454',152258.77,152258.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257576',4904915,'2975','454',101827.85,101827.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257576',4904916,'2976','454',118134.84,118134.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257576',4904917,'2977','454',118816.31,118816.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257576',4904918,'2978','454',144731.63,144731.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257576',4904919,'2979','454',88477.90,88477.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257576',4904920,'2980','454',150465.95,150465.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257576',4904921,'2981','454',88656.87,88656.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257576',4904922,'2982','454',114683.13,114683.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257576',4904923,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257576',4904924,'2984','454',116772.70,116772.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257576',4904925,'2985','455',137680.79,137876.13,195.34,74229.20,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257576',4904926,'2986','455',50919.29,50919.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257576',4904927,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257576',4904928,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257577',4904929,'2961','454',282608.82,292486.97,9878.15,1629894.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257577',4904930,'2962','454',152428.04,152428.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257577',4904931,'2963','454',147556.20,147556.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257577',4904932,'2964','454',249794.83,249794.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257577',4904933,'2965','454',122714.78,130792.76,8057.98,1329566.70,0.00,0.00,20.00,0.00,0.00),('1','122','1004','257577',4904934,'2966','454',306540.12,306540.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257577',4904935,'2967','454',167256.58,167256.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257577',4904936,'2968','454',248441.68,248441.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257577',4904937,'2969','454',83974.61,83974.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257577',4904938,'2970','454',179161.84,187505.50,8343.66,1376703.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257577',4904939,'2971','454',201934.02,201934.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257577',4904940,'2972','454',117253.67,117253.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257577',4904941,'2973','454',51958.56,51958.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257577',4904942,'2974','454',152258.77,152258.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257577',4904943,'2975','454',101827.85,101827.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257577',4904944,'2976','454',118134.84,119447.27,1302.43,214900.95,0.00,0.00,10.00,0.00,0.00),('1','122','1006','257577',4904945,'2977','454',118816.31,118816.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257577',4904946,'2978','454',144731.63,144731.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257577',4904947,'2979','454',88477.90,88477.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257577',4904948,'2980','454',150465.95,151643.20,1167.25,192596.25,0.00,0.00,10.00,0.00,0.00),('1','122','1006','257577',4904949,'2981','454',88656.87,88656.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257577',4904950,'2982','454',114683.13,114683.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257577',4904951,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257577',4904952,'2984','454',116772.70,116772.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257577',4904953,'2985','455',137876.13,139652.13,1776.00,674880.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257577',4904954,'2986','455',50919.29,50919.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257577',4904955,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257577',4904956,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257578',4904957,'2961','454',292486.97,292486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257578',4904958,'2962','454',152428.04,152428.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257578',4904959,'2963','454',147556.20,147556.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257578',4904960,'2964','454',249794.83,249794.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257578',4904961,'2965','454',130792.76,130792.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257578',4904962,'2966','454',306540.12,306540.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257578',4904963,'2967','454',167256.58,167256.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257578',4904964,'2968','454',248441.68,248441.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257578',4904965,'2969','454',83974.61,83974.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257578',4904966,'2970','454',187505.50,187505.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257578',4904967,'2971','454',201934.02,201934.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257578',4904968,'2972','454',117253.67,119649.55,2382.88,393175.20,0.00,0.00,13.00,0.00,0.00),('1','122','1006','257578',4904969,'2973','454',51958.56,51958.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257578',4904970,'2974','454',152258.77,152258.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257578',4904971,'2975','454',101827.85,101827.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257578',4904972,'2976','454',119447.27,119447.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257578',4904973,'2977','454',118816.31,118816.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257578',4904974,'2978','454',144731.63,144731.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257578',4904975,'2979','454',88477.90,100715.00,12237.10,2019121.50,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257578',4904976,'2980','454',151643.20,151643.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257578',4904977,'2981','454',88656.87,88656.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257578',4904978,'2982','454',114683.13,128538.52,13855.39,2286139.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257578',4904979,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257578',4904980,'2984','454',116772.70,117790.02,1017.32,167857.80,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257578',4904981,'2985','455',139652.13,142807.97,3155.84,1199219.20,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257578',4904982,'2986','455',50919.29,50919.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257578',4904983,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257578',4904984,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257579',4904985,'2961','454',292486.97,292486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257579',4904986,'2962','454',152428.04,158274.16,5824.12,960979.80,0.00,0.00,22.00,0.00,0.00),('1','122','1004','257579',4904987,'2963','454',147556.20,147556.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257579',4904988,'2964','454',249794.83,259639.09,9822.26,1620672.90,0.00,0.00,22.00,0.00,0.00),('1','122','1004','257579',4904989,'2965','454',130792.76,130792.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257579',4904990,'2966','454',306540.12,310975.66,4412.54,728069.10,0.00,0.00,23.00,0.00,0.00),('1','122','1004','257579',4904991,'2967','454',167256.58,167256.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257579',4904992,'2968','454',248441.68,257922.25,9467.57,1562149.05,0.00,0.00,13.00,0.00,0.00),('1','122','1004','257579',4904993,'2969','454',83974.61,83974.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257579',4904994,'2970','454',187505.50,187505.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257579',4904995,'2971','454',201934.02,210384.36,8450.34,1394306.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257579',4904996,'2972','454',119649.55,125032.16,5382.61,888130.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257579',4904997,'2973','454',51958.56,51958.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257579',4904998,'2974','454',152258.77,152258.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257579',4904999,'2975','454',101827.85,101827.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257579',4905000,'2976','454',119447.27,119447.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257579',4905001,'2977','454',118816.31,118816.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257579',4905002,'2978','454',144731.63,144754.63,0.00,0.00,0.00,0.00,23.00,0.00,0.00),('1','122','1006','257579',4905003,'2979','454',100715.00,100715.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257579',4905004,'2980','454',151643.20,151676.20,10.00,1650.00,0.00,0.00,23.00,0.00,0.00),('1','122','1006','257579',4905005,'2981','454',88656.87,88656.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257579',4905006,'2982','454',128538.52,128538.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257579',4905007,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257579',4905008,'2984','454',117790.02,117790.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257579',4905009,'2985','455',142807.97,145720.54,2912.57,1135902.30,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257579',4905010,'2986','455',50919.29,50919.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257579',4905011,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257579',4905012,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257580',4905013,'2961','454',292486.97,292486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257580',4905014,'2962','454',158274.16,158274.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257580',4905015,'2963','454',147556.20,147556.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257580',4905016,'2964','454',259639.09,259639.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257580',4905017,'2965','454',130792.76,130792.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257580',4905018,'2966','454',310975.66,310975.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257580',4905019,'2967','454',167256.58,174932.06,7675.48,1266454.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257580',4905020,'2968','454',257922.25,257922.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257580',4905021,'2969','454',83974.61,83974.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257580',4905022,'2970','454',187505.50,187505.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257580',4905023,'2971','454',210384.36,210384.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257580',4905024,'2972','454',125032.16,125032.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257580',4905025,'2973','454',51958.56,51958.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257580',4905026,'2974','454',152258.77,152258.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257580',4905027,'2975','454',101827.85,111936.06,10108.21,1667854.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257580',4905028,'2976','454',119447.27,119447.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257580',4905029,'2977','454',118816.31,118816.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257580',4905030,'2978','454',144754.63,144754.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257580',4905031,'2979','454',100715.00,100715.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257580',4905032,'2980','454',151676.20,162799.46,11123.26,1835337.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257580',4905033,'2981','454',88656.87,88656.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257580',4905034,'2982','454',128538.52,129700.16,1131.64,186720.60,0.00,0.00,30.00,0.00,0.00),('1','122','1006','257580',4905035,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257580',4905036,'2984','454',117790.02,123348.24,5558.22,917106.30,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257580',4905037,'2985','455',145720.54,150730.04,5009.50,1953705.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257580',4905038,'2986','455',50919.29,52419.29,1500.00,585000.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257580',4905039,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257580',4905040,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257581',4905041,'2961','454',292486.97,292486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257581',4905042,'2962','454',158274.16,158274.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257581',4905043,'2963','454',147556.20,147556.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257581',4905044,'2964','454',259639.09,259639.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257581',4905045,'2965','454',130792.76,130792.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257581',4905046,'2966','454',310975.66,310975.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257581',4905047,'2967','454',174932.06,174932.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257581',4905048,'2968','454',257922.25,257922.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257581',4905049,'2969','454',83974.61,83974.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257581',4905050,'2970','454',187505.50,190784.31,3278.81,541003.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257581',4905051,'2971','454',210384.36,210618.01,233.65,38552.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257581',4905052,'2972','454',125032.16,125032.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257581',4905053,'2973','454',51958.56,52919.33,960.77,158527.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257581',4905054,'2974','454',152258.77,152258.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257581',4905055,'2975','454',111936.06,111936.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257581',4905056,'2976','454',119447.27,119447.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257581',4905057,'2977','454',118816.31,119030.55,214.24,35349.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257581',4905058,'2978','454',144754.63,151484.16,6729.53,1110372.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257581',4905059,'2979','454',100715.00,100715.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257581',4905060,'2980','454',162799.46,162799.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257581',4905061,'2981','454',88656.87,97516.89,8860.02,1461903.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257581',4905062,'2982','454',129700.16,129763.18,63.02,10398.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257581',4905063,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257581',4905064,'2984','454',123348.24,123830.55,482.31,79581.15,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257581',4905065,'2985','455',150730.04,152651.56,1921.52,749392.80,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257581',4905066,'2986','455',52419.29,52419.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257581',4905067,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257581',4905068,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257582',4905069,'2961','454',292486.97,292486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257582',4905070,'2962','454',158274.16,161091.25,2817.09,464819.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257582',4905071,'2963','454',147556.20,147556.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257582',4905072,'2964','454',259639.09,260041.94,402.85,66470.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257582',4905073,'2965','454',130792.76,130792.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257582',4905074,'2966','454',310975.66,313600.02,2624.36,433019.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257582',4905075,'2967','454',174932.06,175356.30,424.24,69999.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257582',4905076,'2968','454',257922.25,257922.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257582',4905077,'2969','454',83974.61,83974.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257582',4905078,'2970','454',190784.31,193209.16,2424.85,400100.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257582',4905079,'2971','454',210618.01,213426.69,2808.68,463432.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257582',4905080,'2972','454',125032.16,126210.02,1177.86,194346.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257582',4905081,'2973','454',52919.33,57717.68,4798.35,791727.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257582',4905082,'2974','454',152258.77,155968.93,3710.16,612176.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257582',4905083,'2975','454',111936.06,111936.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257582',4905084,'2976','454',119447.27,119447.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257582',4905085,'2977','454',119030.55,127225.87,8195.32,1352227.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257582',4905086,'2978','454',151484.16,151484.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257582',4905087,'2979','454',100715.00,100715.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257582',4905088,'2980','454',162799.46,162799.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257582',4905089,'2981','454',97516.89,105506.28,7989.39,1318249.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257582',4905090,'2982','454',129763.18,129763.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257582',4905091,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257582',4905092,'2984','454',123830.55,128902.06,5071.51,836799.15,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257582',4905093,'2985','455',152651.56,153461.53,784.97,313988.00,0.00,0.00,25.00,0.00,0.00),('1','122','1007','257582',4905094,'2986','455',52419.29,53560.35,1121.06,448424.00,0.00,0.00,20.00,0.00,0.00),('1','122','1007','257582',4905095,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257582',4905096,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257583',4905097,'2961','454',292486.97,292486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257583',4905098,'2962','454',161091.25,171213.54,10122.29,1670177.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257583',4905099,'2963','454',147556.20,147556.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257583',4905100,'2964','454',260041.94,260041.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257583',4905101,'2965','454',130792.76,130792.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257583',4905102,'2966','454',313600.02,315145.05,1545.03,254929.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257583',4905103,'2967','454',175356.30,175356.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257583',4905104,'2968','454',257922.25,257922.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257583',4905105,'2969','454',83974.61,93056.56,9081.95,1498521.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257583',4905106,'2970','454',193209.16,193209.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257583',4905107,'2971','454',213426.69,213707.32,280.63,46303.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257583',4905108,'2972','454',126210.02,126210.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257583',4905109,'2973','454',57717.68,57717.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257583',4905110,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257583',4905111,'2975','454',111936.06,111936.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257583',4905112,'2976','454',119447.27,119447.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257583',4905113,'2977','454',127225.87,127225.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257583',4905114,'2978','454',151484.16,151484.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257583',4905115,'2979','454',100715.00,100715.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257583',4905116,'2980','454',162799.46,162799.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257583',4905117,'2981','454',105506.28,105506.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257583',4905118,'2982','454',129763.18,129763.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257583',4905119,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257583',4905120,'2984','454',128902.06,128902.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257583',4905121,'2985','455',153461.53,156160.43,2698.90,1079560.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257583',4905122,'2986','455',53560.35,53560.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257583',4905123,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257583',4905124,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257584',4905125,'2961','454',292486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257584',4905126,'2962','454',171213.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257584',4905127,'2963','454',147556.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257584',4905128,'2964','454',260041.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257584',4905129,'2965','454',130792.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257584',4905130,'2966','454',315145.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257584',4905131,'2967','454',175356.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257584',4905132,'2968','454',257922.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257584',4905133,'2969','454',93056.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257584',4905134,'2970','454',193209.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257584',4905135,'2971','454',213707.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257584',4905136,'2972','454',126210.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257584',4905137,'2973','454',57717.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257584',4905138,'2974','454',155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257584',4905139,'2975','454',111936.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257584',4905140,'2976','454',119447.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257584',4905141,'2977','454',127225.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257584',4905142,'2978','454',151484.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257584',4905143,'2979','454',100715.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257584',4905144,'2980','454',162799.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257584',4905145,'2981','454',105506.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257584',4905146,'2982','454',129763.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257584',4905147,'2983','454',26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257584',4905148,'2984','454',128902.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257584',4905149,'2985','455',156160.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257584',4905150,'2986','455',53560.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257584',4905151,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257584',4905152,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257585',4905153,'2961','454',292486.97,292486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257585',4905154,'2962','454',171213.54,171213.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257585',4905155,'2963','454',147556.20,147556.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257585',4905156,'2964','454',260041.94,260041.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257585',4905157,'2965','454',130792.76,130792.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257585',4905158,'2966','454',315145.05,315145.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257585',4905159,'2967','454',175356.30,175356.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257585',4905160,'2968','454',257922.25,257922.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257585',4905161,'2969','454',93056.56,93056.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257585',4905162,'2970','454',193209.16,193209.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257585',4905163,'2971','454',213707.32,213707.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257585',4905164,'2972','454',126210.02,126210.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257585',4905165,'2973','454',57717.68,57717.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257585',4905166,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257585',4905167,'2975','454',111936.06,111936.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257585',4905168,'2976','454',119447.27,119447.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257585',4905169,'2977','454',127225.87,127225.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257585',4905170,'2978','454',151484.16,151484.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257585',4905171,'2979','454',100715.00,100715.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257585',4905172,'2980','454',162799.46,162799.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257585',4905173,'2981','454',105506.28,105506.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257585',4905174,'2982','454',129763.18,129763.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257585',4905175,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257585',4905176,'2984','454',128902.06,128902.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257585',4905177,'2985','455',156160.43,158905.39,2744.96,1097984.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257585',4905178,'2986','455',53560.35,54796.07,1235.72,494288.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257585',4905179,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257585',4905180,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257586',4905181,'2961','454',292486.97,292486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257586',4905182,'2962','454',171213.54,171213.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257586',4905183,'2963','454',147556.20,147556.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257586',4905184,'2964','454',260041.94,260041.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257586',4905185,'2965','454',130792.76,130792.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257586',4905186,'2966','454',315145.05,315145.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257586',4905187,'2967','454',175356.30,175356.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257586',4905188,'2968','454',257922.25,257922.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257586',4905189,'2969','454',93056.56,93056.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257586',4905190,'2970','454',193209.16,193209.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257586',4905191,'2971','454',213707.32,213707.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257586',4905192,'2972','454',126210.02,126210.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257586',4905193,'2973','454',57717.68,62533.23,4815.55,794565.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257586',4905194,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257586',4905195,'2975','454',111936.06,116845.64,4879.58,805130.70,0.00,0.00,30.00,0.00,0.00),('1','122','1006','257586',4905196,'2976','454',119447.27,119447.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257586',4905197,'2977','454',127225.87,127422.00,126.13,20811.45,0.00,0.00,70.00,0.00,0.00),('1','122','1006','257586',4905198,'2978','454',151484.16,156157.21,4673.05,771053.25,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257586',4905199,'2979','454',100715.00,100715.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257586',4905200,'2980','454',162799.46,162799.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257586',4905201,'2981','454',105506.28,106697.42,1191.14,196538.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257586',4905202,'2982','454',129763.18,129763.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257586',4905203,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257586',4905204,'2984','454',128902.06,134226.31,5304.25,875201.25,0.00,0.00,20.00,0.00,0.00),('1','122','1007','257586',4905205,'2985','455',158905.39,160126.65,1221.26,500716.60,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257586',4905206,'2986','455',54796.07,54796.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257586',4905207,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257586',4905208,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257587',4905209,'2961','454',292486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257587',4905210,'2962','454',171213.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257587',4905211,'2963','454',147556.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257587',4905212,'2964','454',260041.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257587',4905213,'2965','454',130792.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257587',4905214,'2966','454',315145.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257587',4905215,'2967','454',175356.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257587',4905216,'2968','454',257922.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257587',4905217,'2969','454',93056.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257587',4905218,'2970','454',193209.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257587',4905219,'2971','454',213707.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257587',4905220,'2972','454',126210.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257587',4905221,'2973','454',62533.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257587',4905222,'2974','454',155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257587',4905223,'2975','454',116845.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257587',4905224,'2976','454',119447.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257587',4905225,'2977','454',127422.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257587',4905226,'2978','454',156157.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257587',4905227,'2979','454',100715.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257587',4905228,'2980','454',162799.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257587',4905229,'2981','454',106697.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257587',4905230,'2982','454',129763.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257587',4905231,'2983','454',26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257587',4905232,'2984','454',134226.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257587',4905233,'2985','455',160126.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257587',4905234,'2986','455',54796.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257587',4905235,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257587',4905236,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257588',4905237,'2961','454',292486.97,292486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257588',4905238,'2962','454',171213.54,180720.69,9492.15,1566204.75,0.00,0.00,15.00,0.00,0.00),('1','122','1004','257588',4905239,'2963','454',147556.20,147556.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257588',4905240,'2964','454',260041.94,260041.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257588',4905241,'2965','454',130792.76,130792.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257588',4905242,'2966','454',315145.05,322307.53,7162.48,1181809.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257588',4905243,'2967','454',175356.30,181090.10,5693.80,939477.00,0.00,0.00,40.00,0.00,0.00),('1','122','1004','257588',4905244,'2968','454',257922.25,257922.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257588',4905245,'2969','454',93056.56,93056.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257588',4905246,'2970','454',193209.16,202920.52,9676.36,1596599.40,0.00,0.00,35.00,0.00,0.00),('1','122','1004','257588',4905247,'2971','454',213707.32,225013.45,11256.13,1857261.45,0.00,0.00,50.00,0.00,0.00),('1','122','1004','257588',4905248,'2972','454',126210.02,130350.77,4105.75,677448.75,0.00,0.00,35.00,0.00,0.00),('1','122','1006','257588',4905249,'2973','454',62533.23,62533.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257588',4905250,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257588',4905251,'2975','454',116845.64,116845.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257588',4905252,'2976','454',119447.27,119447.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257588',4905253,'2977','454',127422.00,127422.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257588',4905254,'2978','454',156157.21,156157.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257588',4905255,'2979','454',100715.00,102801.73,2047.73,337875.45,0.00,0.00,39.00,0.00,0.00),('1','122','1006','257588',4905256,'2980','454',162799.46,162799.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257588',4905257,'2981','454',106697.42,106697.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257588',4905258,'2982','454',129763.18,130273.51,510.33,84204.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257588',4905259,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257588',4905260,'2984','454',134226.31,134226.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257588',4905261,'2985','455',160126.65,161729.82,1576.17,646229.70,0.00,0.00,27.00,0.00,0.00),('1','122','1007','257588',4905262,'2986','455',54796.07,54796.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257588',4905263,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257588',4905264,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257589',4905265,'2961','454',292486.97,292486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257589',4905266,'2962','454',180720.69,180720.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257589',4905267,'2963','454',147556.20,147556.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257589',4905268,'2964','454',260041.94,270892.60,10825.66,1786233.90,0.00,0.00,25.00,0.00,0.00),('1','122','1004','257589',4905269,'2965','454',130792.76,130792.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257589',4905270,'2966','454',322307.53,322307.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257589',4905271,'2967','454',181090.10,181090.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257589',4905272,'2968','454',257922.25,257922.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257589',4905273,'2969','454',93056.56,102800.68,9744.12,1607779.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257589',4905274,'2970','454',202920.52,202920.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257589',4905275,'2971','454',225013.45,225013.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257589',4905276,'2972','454',130350.77,130350.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257589',4905277,'2973','454',62533.23,62533.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257589',4905278,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257589',4905279,'2975','454',116845.64,116845.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257589',4905280,'2976','454',119447.27,128350.50,8903.23,1469032.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257589',4905281,'2977','454',127422.00,127422.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257589',4905282,'2978','454',156157.21,167563.46,11406.25,1882031.25,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257589',4905283,'2979','454',102801.73,102801.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257589',4905284,'2980','454',162799.46,162799.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257589',4905285,'2981','454',106697.42,106697.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257589',4905286,'2982','454',130273.51,130273.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257589',4905287,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257589',4905288,'2984','454',134226.31,135386.80,1125.49,185705.85,0.00,0.00,35.00,0.00,0.00),('1','122','1007','257589',4905289,'2985','455',161729.82,163432.62,1702.80,698148.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257589',4905290,'2986','455',54796.07,54796.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257589',4905291,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257589',4905292,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257590',4905293,'2961','454',292486.97,292486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257590',4905294,'2962','454',180720.69,192198.23,11447.54,1888844.10,0.00,0.00,30.00,0.00,0.00),('1','122','1004','257590',4905295,'2963','454',147556.20,147556.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257590',4905296,'2964','454',270892.60,270892.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257590',4905297,'2965','454',130792.76,130792.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257590',4905298,'2966','454',322307.53,322307.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257590',4905299,'2967','454',181090.10,181090.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257590',4905300,'2968','454',257922.25,268921.02,10998.77,1814797.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257590',4905301,'2969','454',102800.68,102800.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257590',4905302,'2970','454',202920.52,202920.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257590',4905303,'2971','454',225013.45,226331.17,1317.72,217423.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257590',4905304,'2972','454',130350.77,132165.74,1814.97,299470.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257590',4905305,'2973','454',62533.23,62533.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257590',4905306,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257590',4905307,'2975','454',116845.64,116845.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257590',4905308,'2976','454',128350.50,128350.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257590',4905309,'2977','454',127422.00,127422.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257590',4905310,'2978','454',167563.46,167563.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257590',4905311,'2979','454',102801.73,102801.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257590',4905312,'2980','454',162799.46,162799.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257590',4905313,'2981','454',106697.42,106697.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257590',4905314,'2982','454',130273.51,130273.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257590',4905315,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257590',4905316,'2984','454',135386.80,135386.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257590',4905317,'2985','455',163432.62,165800.67,2348.05,962700.50,0.00,0.00,20.00,0.00,0.00),('1','122','1007','257590',4905318,'2986','455',54796.07,57009.31,2187.14,896727.40,0.00,0.00,26.10,0.00,0.00),('1','122','1007','257590',4905319,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257590',4905320,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257591',4905321,'2961','454',292486.97,292486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257591',4905322,'2962','454',192198.23,192198.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257591',4905323,'2963','454',147556.20,157915.65,10359.45,1709309.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257591',4905324,'2964','454',270892.60,271059.90,167.30,27604.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257591',4905325,'2965','454',130792.76,130792.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257591',4905326,'2966','454',322307.53,322307.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257591',4905327,'2967','454',181090.10,181090.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257591',4905328,'2968','454',268921.02,268921.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257591',4905329,'2969','454',102800.68,102800.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257591',4905330,'2970','454',202920.52,202920.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257591',4905331,'2971','454',226331.17,238460.11,12128.94,2001275.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257591',4905332,'2972','454',132165.74,132165.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257591',4905333,'2973','454',62533.23,62533.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257591',4905334,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257591',4905335,'2975','454',116845.64,116845.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257591',4905336,'2976','454',128350.50,128350.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257591',4905337,'2977','454',127422.00,127422.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257591',4905338,'2978','454',167563.46,167563.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257591',4905339,'2979','454',102801.73,102801.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257591',4905340,'2980','454',162799.46,173144.08,10344.62,1706862.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257591',4905341,'2981','454',106697.42,106697.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257591',4905342,'2982','454',130273.51,140339.27,10065.76,1660850.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257591',4905343,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257591',4905344,'2984','454',135386.80,135386.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257591',4905345,'2985','455',165800.67,168647.52,2846.85,1167208.50,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257591',4905346,'2986','455',57009.31,57009.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257591',4905347,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257591',4905348,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257592',4905349,'2961','454',292486.97,292486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257592',4905350,'2962','454',192198.23,192198.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257592',4905351,'2963','454',157915.65,157915.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257592',4905352,'2964','454',271059.90,271059.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257592',4905353,'2965','454',130792.76,141620.39,10827.63,1786558.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257592',4905354,'2966','454',322307.53,322307.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257592',4905355,'2967','454',181090.10,181090.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257592',4905356,'2968','454',268921.02,268921.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257592',4905357,'2969','454',102800.68,102800.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257592',4905358,'2970','454',202920.52,213979.65,11059.13,1824756.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257592',4905359,'2971','454',238460.11,238460.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257592',4905360,'2972','454',132165.74,132165.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257592',4905361,'2973','454',62533.23,74229.71,11696.48,1929919.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257592',4905362,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257592',4905363,'2975','454',116845.64,116845.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257592',4905364,'2976','454',128350.50,128350.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257592',4905365,'2977','454',127422.00,127422.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257592',4905366,'2978','454',167563.46,167563.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257592',4905367,'2979','454',102801.73,102801.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257592',4905368,'2980','454',173144.08,173144.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257592',4905369,'2981','454',106697.42,106697.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257592',4905370,'2982','454',140339.27,140339.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257592',4905371,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257592',4905372,'2984','454',135386.80,143929.49,8542.69,1409543.85,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257592',4905373,'2985','455',168647.52,170245.04,1597.52,654983.20,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257592',4905374,'2986','455',57009.31,58659.30,1649.99,676495.90,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257592',4905375,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257592',4905376,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257593',4905377,'2961','454',292486.97,292486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257593',4905378,'2962','454',192198.23,202104.83,9906.60,1634589.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257593',4905379,'2963','454',157915.65,157915.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257593',4905380,'2964','454',271059.90,271059.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257593',4905381,'2965','454',141620.39,141620.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257593',4905382,'2966','454',322307.53,330454.53,8147.00,1344255.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257593',4905383,'2967','454',181090.10,181090.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257593',4905384,'2968','454',268921.02,268921.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257593',4905385,'2969','454',102800.68,102800.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257593',4905386,'2970','454',213979.65,213979.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257593',4905387,'2971','454',238460.11,248129.28,9669.17,1595413.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257593',4905388,'2972','454',132165.74,132165.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257593',4905389,'2973','454',74229.71,74229.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257593',4905390,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257593',4905391,'2975','454',116845.64,118776.17,1930.53,318537.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257593',4905392,'2976','454',128350.50,128350.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257593',4905393,'2977','454',127422.00,129933.03,2511.03,414319.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257593',4905394,'2978','454',167563.46,167563.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257593',4905395,'2979','454',102801.73,102801.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257593',4905396,'2980','454',173144.08,173144.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257593',4905397,'2981','454',106697.42,106697.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257593',4905398,'2982','454',140339.27,140339.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257593',4905399,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257593',4905400,'2984','454',143929.49,143929.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257593',4905401,'2985','455',170245.04,170918.02,672.98,275921.80,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257593',4905402,'2986','455',58659.30,60572.89,1913.59,784571.90,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257593',4905403,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257593',4905404,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257594',4905405,'2961','454',292486.97,292486.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257594',4905406,'2962','454',202104.83,202104.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257594',4905407,'2963','454',157915.65,157915.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257594',4905408,'2964','454',271059.90,271059.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257594',4905409,'2965','454',141620.39,141620.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257594',4905410,'2966','454',330454.53,330454.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257594',4905411,'2967','454',181090.10,181090.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257594',4905412,'2968','454',268921.02,268921.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257594',4905413,'2969','454',102800.68,102800.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257594',4905414,'2970','454',213979.65,213979.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257594',4905415,'2971','454',248129.28,248129.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257594',4905416,'2972','454',132165.74,132165.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257594',4905417,'2973','454',74229.71,74229.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257594',4905418,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257594',4905419,'2975','454',118776.17,118776.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257594',4905420,'2976','454',128350.50,128350.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257594',4905421,'2977','454',129933.03,129933.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257594',4905422,'2978','454',167563.46,167563.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257594',4905423,'2979','454',102801.73,102801.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257594',4905424,'2980','454',173144.08,173144.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257594',4905425,'2981','454',106697.42,106697.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257594',4905426,'2982','454',140339.27,140339.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257594',4905427,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257594',4905428,'2984','454',143929.49,143929.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257594',4905429,'2985','455',170918.02,171595.16,667.14,273527.40,0.00,0.00,10.00,0.00,0.00),('1','122','1007','257594',4905430,'2986','455',60572.89,60831.89,249.00,102090.00,0.00,0.00,10.00,0.00,0.00),('1','122','1007','257594',4905431,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257594',4905432,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257595',4905433,'2961','454',292486.97,303526.61,11019.64,1818240.60,0.00,0.00,20.00,0.00,0.00),('1','122','1004','257595',4905434,'2962','454',202104.83,202104.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257595',4905435,'2963','454',157915.65,157915.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257595',4905436,'2964','454',271059.90,271059.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257595',4905437,'2965','454',141620.39,151729.54,10109.15,1668009.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257595',4905438,'2966','454',330454.53,330454.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257595',4905439,'2967','454',181090.10,181090.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257595',4905440,'2968','454',268921.02,268921.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257595',4905441,'2969','454',102800.68,112488.72,9663.04,1594401.60,0.00,0.00,25.00,0.00,0.00),('1','122','1004','257595',4905442,'2970','454',213979.65,213979.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257595',4905443,'2971','454',248129.28,248129.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257595',4905444,'2972','454',132165.74,132165.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257595',4905445,'2973','454',74229.71,74229.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257595',4905446,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257595',4905447,'2975','454',118776.17,118776.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257595',4905448,'2976','454',128350.50,128350.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257595',4905449,'2977','454',129933.03,129933.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257595',4905450,'2978','454',167563.46,167563.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257595',4905451,'2979','454',102801.73,102801.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257595',4905452,'2980','454',173144.08,173144.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257595',4905453,'2981','454',106697.42,106697.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257595',4905454,'2982','454',140339.27,140339.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257595',4905455,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257595',4905456,'2984','454',143929.49,143929.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257595',4905457,'2985','455',171595.16,172284.18,689.02,285943.30,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257595',4905458,'2986','455',60831.89,60949.54,117.65,48824.75,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257595',4905459,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257595',4905460,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257596',4905461,'2961','454',303526.61,303526.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257596',4905462,'2962','454',202104.83,202104.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257596',4905463,'2963','454',157915.65,160844.61,2928.96,483278.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257596',4905464,'2964','454',271059.90,274720.42,3660.52,603985.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257596',4905465,'2965','454',151729.54,151729.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257596',4905466,'2966','454',330454.53,330454.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257596',4905467,'2967','454',181090.10,185414.91,4324.81,713593.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257596',4905468,'2968','454',268921.02,271762.64,2841.62,468867.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257596',4905469,'2969','454',112488.72,112488.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257596',4905470,'2970','454',213979.65,213979.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257596',4905471,'2971','454',248129.28,251173.03,3043.75,502218.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257596',4905472,'2972','454',132165.74,132363.21,197.47,32582.55,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257596',4905473,'2973','454',74229.71,74229.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257596',4905474,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257596',4905475,'2975','454',118776.17,118776.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257596',4905476,'2976','454',128350.50,128350.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257596',4905477,'2977','454',129933.03,129933.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257596',4905478,'2978','454',167563.46,167634.45,70.99,11713.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257596',4905479,'2979','454',102801.73,102801.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257596',4905480,'2980','454',173144.08,173144.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257596',4905481,'2981','454',106697.42,106697.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257596',4905482,'2982','454',140339.27,140339.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257596',4905483,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257596',4905484,'2984','454',143929.49,143929.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257596',4905485,'2985','455',172284.18,172920.69,636.51,264151.65,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257596',4905486,'2986','455',60949.54,61787.49,837.95,347749.25,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257596',4905487,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257596',4905488,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257597',4905489,'2961','454',303526.61,303526.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257597',4905490,'2962','454',202104.83,208470.22,6365.39,1050289.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257597',4905491,'2963','454',160844.61,160844.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257597',4905492,'2964','454',274720.42,275843.33,1122.91,185280.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257597',4905493,'2965','454',151729.54,151729.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257597',4905494,'2966','454',330454.53,331415.27,960.74,158522.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257597',4905495,'2967','454',185414.91,185414.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257597',4905496,'2968','454',271762.64,272089.38,326.74,53912.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257597',4905497,'2969','454',112488.72,113561.82,1073.10,177061.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257597',4905498,'2970','454',213979.65,219884.41,5904.76,974285.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257597',4905499,'2971','454',251173.03,252175.03,1002.00,165330.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257597',4905500,'2972','454',132363.21,134788.01,2424.80,400092.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257597',4905501,'2973','454',74229.71,74229.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257597',4905502,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257597',4905503,'2975','454',118776.17,118776.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257597',4905504,'2976','454',128350.50,128350.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257597',4905505,'2977','454',129933.03,129933.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257597',4905506,'2978','454',167634.45,167634.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257597',4905507,'2979','454',102801.73,102801.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257597',4905508,'2980','454',173144.08,173144.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257597',4905509,'2981','454',106697.42,106697.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257597',4905510,'2982','454',140339.27,140339.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257597',4905511,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257597',4905512,'2984','454',143929.49,143929.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257597',4905513,'2985','455',172920.69,175904.22,2983.53,1238164.95,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257597',4905514,'2986','455',61787.49,63377.63,1590.14,659908.10,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257597',4905515,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257597',4905516,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257598',4905517,'2961','454',303526.61,303526.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257598',4905518,'2962','454',208470.22,208470.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257598',4905519,'2963','454',160844.61,160844.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257598',4905520,'2964','454',275843.33,275843.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257598',4905521,'2965','454',151729.54,151729.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257598',4905522,'2966','454',331415.27,331415.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257598',4905523,'2967','454',185414.91,185414.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257598',4905524,'2968','454',272089.38,272089.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257598',4905525,'2969','454',113561.82,113561.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257598',4905526,'2970','454',219884.41,219884.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257598',4905527,'2971','454',252175.03,252175.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257598',4905528,'2972','454',134788.01,134788.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257598',4905529,'2973','454',74229.71,74229.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257598',4905530,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257598',4905531,'2975','454',118776.17,118776.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257598',4905532,'2976','454',128350.50,128350.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257598',4905533,'2977','454',129933.03,129933.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257598',4905534,'2978','454',167634.45,167634.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257598',4905535,'2979','454',102801.73,102801.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257598',4905536,'2980','454',173144.08,173144.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257598',4905537,'2981','454',106697.42,106697.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257598',4905538,'2982','454',140339.27,140339.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257598',4905539,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257598',4905540,'2984','454',143929.49,143929.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257598',4905541,'2985','455',175904.22,177991.43,2087.21,866192.15,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257598',4905542,'2986','455',63377.63,63724.92,347.29,144125.35,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257598',4905543,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257598',4905544,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257599',4905545,'2961','454',303526.61,303526.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257599',4905546,'2962','454',208470.22,208470.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257599',4905547,'2963','454',160844.61,171682.80,10838.19,1788301.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257599',4905548,'2964','454',275843.33,275843.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257599',4905549,'2965','454',151729.54,151729.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257599',4905550,'2966','454',331415.27,331415.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257599',4905551,'2967','454',185414.91,185414.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257599',4905552,'2968','454',272089.38,283060.23,10970.85,1810190.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257599',4905553,'2969','454',113561.82,113561.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257599',4905554,'2970','454',219884.41,219884.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257599',4905555,'2971','454',252175.03,257019.25,4844.22,799296.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257599',4905556,'2972','454',134788.01,134788.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257599',4905557,'2973','454',74229.71,74229.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257599',4905558,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257599',4905559,'2975','454',118776.17,118776.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257599',4905560,'2976','454',128350.50,128350.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257599',4905561,'2977','454',129933.03,129933.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257599',4905562,'2978','454',167634.45,167634.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257599',4905563,'2979','454',102801.73,102801.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257599',4905564,'2980','454',173144.08,173144.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257599',4905565,'2981','454',106697.42,106697.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257599',4905566,'2982','454',140339.27,140339.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257599',4905567,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257599',4905568,'2984','454',143929.49,143929.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257599',4905569,'2985','455',177991.43,181144.91,3153.48,1324461.60,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257599',4905570,'2986','455',63724.92,64324.92,600.00,252000.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257599',4905571,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257599',4905572,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257600',4905573,'2961','454',303526.61,303526.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257600',4905574,'2962','454',208470.22,217347.06,8876.84,1464678.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257600',4905575,'2963','454',171682.80,171682.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257600',4905576,'2964','454',275843.33,275843.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257600',4905577,'2965','454',151729.54,151729.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257600',4905578,'2966','454',331415.27,331415.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257600',4905579,'2967','454',185414.91,185414.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257600',4905580,'2968','454',283060.23,283060.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257600',4905581,'2969','454',113561.82,113561.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257600',4905582,'2970','454',219884.41,228735.14,8850.73,1460370.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257600',4905583,'2971','454',257019.25,257019.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257600',4905584,'2972','454',134788.01,135821.79,1033.78,170573.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257600',4905585,'2973','454',74229.71,74229.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257600',4905586,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257600',4905587,'2975','454',118776.17,118776.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257600',4905588,'2976','454',128350.50,128350.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257600',4905589,'2977','454',129933.03,129933.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257600',4905590,'2978','454',167634.45,167634.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257600',4905591,'2979','454',102801.73,102801.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257600',4905592,'2980','454',173144.08,173144.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257600',4905593,'2981','454',106697.42,106697.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257600',4905594,'2982','454',140339.27,140339.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257600',4905595,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257600',4905596,'2984','454',143929.49,143929.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257600',4905597,'2985','455',181144.91,182763.96,1619.05,680001.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257600',4905598,'2986','455',64324.92,64899.92,575.00,241500.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257600',4905599,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257600',4905600,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257601',4905601,'2961','454',303526.61,303526.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257601',4905602,'2962','454',217347.06,217347.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257601',4905603,'2963','454',171682.80,171682.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257601',4905604,'2964','454',275843.33,275853.33,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257601',4905605,'2965','454',151729.54,152305.64,566.10,93406.50,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257601',4905606,'2966','454',331415.27,339081.07,7625.80,1258257.00,0.00,0.00,40.00,0.00,0.00),('1','122','1004','257601',4905607,'2967','454',185414.91,185414.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257601',4905608,'2968','454',283060.23,283060.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257601',4905609,'2969','454',113561.82,113561.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257601',4905610,'2970','454',228735.14,228747.14,0.00,0.00,0.00,0.00,12.00,0.00,0.00),('1','122','1004','257601',4905611,'2971','454',257019.25,265651.28,8589.03,1417189.95,0.00,0.00,43.00,0.00,0.00),('1','122','1004','257601',4905612,'2972','454',135821.79,135821.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257601',4905613,'2973','454',74229.71,74229.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257601',4905614,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257601',4905615,'2975','454',118776.17,118776.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257601',4905616,'2976','454',128350.50,128350.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257601',4905617,'2977','454',129933.03,129933.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257601',4905618,'2978','454',167634.45,167634.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257601',4905619,'2979','454',102801.73,102801.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257601',4905620,'2980','454',173144.08,173144.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257601',4905621,'2981','454',106697.42,106697.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257601',4905622,'2982','454',140339.27,140339.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257601',4905623,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257601',4905624,'2984','454',143929.49,143929.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257601',4905625,'2985','455',182763.96,182930.63,166.67,70001.40,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257601',4905626,'2986','455',64899.92,65956.34,1056.42,443696.40,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257601',4905627,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257601',4905628,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257602',4905629,'2961','454',303526.61,303526.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257602',4905630,'2962','454',217347.06,217663.81,291.75,48138.75,0.00,0.00,25.00,0.00,0.00),('1','122','1004','257602',4905631,'2963','454',171682.80,171682.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257602',4905632,'2964','454',275853.33,284849.88,8996.55,1484430.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257602',4905633,'2965','454',152305.64,152305.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257602',4905634,'2966','454',339081.07,339081.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257602',4905635,'2967','454',185414.91,185414.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257602',4905636,'2968','454',283060.23,292043.44,8983.21,1482229.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257602',4905637,'2969','454',113561.82,113561.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257602',4905638,'2970','454',228747.14,228747.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257602',4905639,'2971','454',265651.28,275672.70,10021.42,1653534.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257602',4905640,'2972','454',135821.79,135821.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257602',4905641,'2973','454',74229.71,74229.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257602',4905642,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257602',4905643,'2975','454',118776.17,118776.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257602',4905644,'2976','454',128350.50,128350.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257602',4905645,'2977','454',129933.03,129933.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257602',4905646,'2978','454',167634.45,167634.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257602',4905647,'2979','454',102801.73,102801.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257602',4905648,'2980','454',173144.08,173144.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257602',4905649,'2981','454',106697.42,106697.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257602',4905650,'2982','454',140339.27,140339.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257602',4905651,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257602',4905652,'2984','454',143929.49,143929.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257602',4905653,'2985','455',182930.63,188632.84,5682.21,2386528.20,0.00,0.00,20.00,0.00,0.00),('1','122','1007','257602',4905654,'2986','455',65956.34,70714.42,4723.08,1983693.60,0.00,0.00,35.00,0.00,0.00),('1','122','1007','257602',4905655,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257602',4905656,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257603',4905657,'2961','454',303526.61,303526.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257603',4905658,'2962','454',217663.81,217663.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257603',4905659,'2963','454',171682.80,171682.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257603',4905660,'2964','454',284849.88,284849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257603',4905661,'2965','454',152305.64,152305.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257603',4905662,'2966','454',339081.07,339081.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257603',4905663,'2967','454',185414.91,185414.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257603',4905664,'2968','454',292043.44,292043.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257603',4905665,'2969','454',113561.82,113561.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257603',4905666,'2970','454',228747.14,228747.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257603',4905667,'2971','454',275672.70,275672.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257603',4905668,'2972','454',135821.79,135821.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257603',4905669,'2973','454',74229.71,83778.82,9539.11,1573953.15,0.00,0.00,10.00,0.00,0.00),('1','122','1006','257603',4905670,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257603',4905671,'2975','454',118776.17,118776.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257603',4905672,'2976','454',128350.50,128350.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257603',4905673,'2977','454',129933.03,129933.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257603',4905674,'2978','454',167634.45,179747.71,12103.26,1997037.90,0.00,0.00,10.00,0.00,0.00),('1','122','1006','257603',4905675,'2979','454',102801.73,102801.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257603',4905676,'2980','454',173144.08,173144.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257603',4905677,'2981','454',106697.42,121661.03,14963.61,2468995.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257603',4905678,'2982','454',140339.27,142839.27,2500.00,412500.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257603',4905679,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257603',4905680,'2984','454',143929.49,144561.46,631.97,104275.05,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257603',4905681,'2985','455',188632.84,189032.85,400.01,172004.30,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257603',4905682,'2986','455',70714.42,70714.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257603',4905683,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257603',4905684,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257604',4905685,'2961','454',303526.61,303526.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257604',4905686,'2962','454',217663.81,217663.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257604',4905687,'2963','454',171682.80,171682.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257604',4905688,'2964','454',284849.88,284849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257604',4905689,'2965','454',152305.64,152305.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257604',4905690,'2966','454',339081.07,339081.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257604',4905691,'2967','454',185414.91,185414.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257604',4905692,'2968','454',292043.44,292043.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257604',4905693,'2969','454',113561.82,113561.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257604',4905694,'2970','454',228747.14,228747.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257604',4905695,'2971','454',275672.70,275672.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257604',4905696,'2972','454',135821.79,135821.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257604',4905697,'2973','454',83778.82,83778.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257604',4905698,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257604',4905699,'2975','454',118776.17,118776.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257604',4905700,'2976','454',128350.50,128350.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257604',4905701,'2977','454',129933.03,129933.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257604',4905702,'2978','454',179747.71,179747.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257604',4905703,'2979','454',102801.73,102801.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257604',4905704,'2980','454',173144.08,173144.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257604',4905705,'2981','454',121661.03,121661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257604',4905706,'2982','454',142839.27,142839.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257604',4905707,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257604',4905708,'2984','454',144561.46,144561.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257604',4905709,'2985','455',189032.85,190625.49,1592.64,684835.20,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257604',4905710,'2986','455',70714.42,71406.01,691.59,297383.70,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257604',4905711,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257604',4905712,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257605',4905713,'2961','454',303526.61,303526.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257605',4905714,'2962','454',217663.81,227417.03,9753.22,1609281.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257605',4905715,'2963','454',171682.80,171682.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257605',4905716,'2964','454',284849.88,287620.02,2770.14,457073.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257605',4905717,'2965','454',152305.64,152305.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257605',4905718,'2966','454',339081.07,339081.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257605',4905719,'2967','454',185414.91,194495.37,9080.46,1498275.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257605',4905720,'2968','454',292043.44,292043.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257605',4905721,'2969','454',113561.82,113561.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257605',4905722,'2970','454',228747.14,236454.66,7707.52,1271740.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257605',4905723,'2971','454',275672.70,275672.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257605',4905724,'2972','454',135821.79,136278.56,456.77,75367.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257605',4905725,'2973','454',83778.82,86905.74,3126.92,515941.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257605',4905726,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257605',4905727,'2975','454',118776.17,121788.59,2977.42,491274.30,0.00,0.00,35.00,0.00,0.00),('1','122','1006','257605',4905728,'2976','454',128350.50,128350.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257605',4905729,'2977','454',129933.03,129933.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257605',4905730,'2978','454',179747.71,183847.32,4099.61,676435.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257605',4905731,'2979','454',102801.73,110240.90,7424.17,1224988.05,0.00,0.00,15.00,0.00,0.00),('1','122','1006','257605',4905732,'2980','454',173144.08,173387.69,243.61,40195.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257605',4905733,'2981','454',121661.03,121661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257605',4905734,'2982','454',142839.27,142839.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257605',4905735,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257605',4905736,'2984','454',144561.46,148895.18,4333.72,715063.80,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257605',4905737,'2985','455',190625.49,192358.20,1705.71,733455.30,0.00,0.00,27.00,0.00,0.00),('1','122','1007','257605',4905738,'2986','455',71406.01,74154.95,2721.94,1170434.20,0.00,0.00,27.00,0.00,0.00),('1','122','1007','257605',4905739,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257605',4905740,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257606',4905741,'2961','454',303526.61,303526.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257606',4905742,'2962','454',227417.03,227417.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257606',4905743,'2963','454',171682.80,171682.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257606',4905744,'2964','454',287620.02,296285.50,8665.48,1429804.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257606',4905745,'2965','454',152305.64,158742.47,6396.83,1055476.95,0.00,0.00,40.00,0.00,0.00),('1','122','1004','257606',4905746,'2966','454',339081.07,339081.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257606',4905747,'2967','454',194495.37,194495.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257606',4905748,'2968','454',292043.44,292043.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257606',4905749,'2969','454',113561.82,113561.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257606',4905750,'2970','454',236454.66,236454.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257606',4905751,'2971','454',275672.70,284597.87,8905.17,1469353.05,0.00,0.00,20.00,0.00,0.00),('1','122','1004','257606',4905752,'2972','454',136278.56,136278.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257606',4905753,'2973','454',86905.74,86905.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257606',4905754,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257606',4905755,'2975','454',121788.59,121788.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257606',4905756,'2976','454',128350.50,136671.98,8321.48,1373044.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257606',4905757,'2977','454',129933.03,135724.21,5788.23,955057.95,0.00,0.00,2.95,0.00,0.00),('1','122','1006','257606',4905758,'2978','454',183847.32,183847.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257606',4905759,'2979','454',110240.90,110240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257606',4905760,'2980','454',173387.69,181084.28,7696.59,1269937.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257606',4905761,'2981','454',121661.03,128461.53,6800.50,1122082.50,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257606',4905762,'2982','454',142839.27,142839.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257606',4905763,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257606',4905764,'2984','454',148895.18,150140.72,1245.54,205514.10,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257606',4905765,'2985','455',192358.20,194533.60,2175.40,935422.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257606',4905766,'2986','455',74154.95,77640.42,3485.47,1498752.10,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257606',4905767,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257606',4905768,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257607',4905769,'2961','454',303526.61,303526.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257607',4905770,'2962','454',227417.03,227417.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257607',4905771,'2963','454',171682.80,171682.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257607',4905772,'2964','454',296285.50,296285.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257607',4905773,'2965','454',158742.47,158742.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257607',4905774,'2966','454',339081.07,339081.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257607',4905775,'2967','454',194495.37,194495.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257607',4905776,'2968','454',292043.44,292043.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257607',4905777,'2969','454',113561.82,113561.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257607',4905778,'2970','454',236454.66,236454.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257607',4905779,'2971','454',284597.87,284597.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257607',4905780,'2972','454',136278.56,136278.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257607',4905781,'2973','454',86905.74,86905.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257607',4905782,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257607',4905783,'2975','454',121788.59,121788.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257607',4905784,'2976','454',136671.98,136671.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257607',4905785,'2977','454',135724.21,135724.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257607',4905786,'2978','454',183847.32,183847.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257607',4905787,'2979','454',110240.90,110240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257607',4905788,'2980','454',181084.28,181084.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257607',4905789,'2981','454',128461.53,128461.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257607',4905790,'2982','454',142839.27,142839.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257607',4905791,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257607',4905792,'2984','454',150140.72,150140.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257607',4905793,'2985','455',194533.60,196048.15,1514.55,651256.50,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257607',4905794,'2986','455',77640.42,79140.42,1500.00,645000.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257607',4905795,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257607',4905796,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257608',4905797,'2961','454',303526.61,303526.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257608',4905798,'2962','454',227417.03,241498.31,14071.28,2321761.20,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257608',4905799,'2963','454',171682.80,171682.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257608',4905800,'2964','454',296285.50,296285.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257608',4905801,'2965','454',158742.47,158742.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257608',4905802,'2966','454',339081.07,339081.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257608',4905803,'2967','454',194495.37,208700.52,14195.15,2342199.75,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257608',4905804,'2968','454',292043.44,292043.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257608',4905805,'2969','454',113561.82,113561.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257608',4905806,'2970','454',236454.66,242271.60,5816.94,959795.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257608',4905807,'2971','454',284597.87,284597.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257608',4905808,'2972','454',136278.56,152411.21,16122.65,2660237.25,0.00,0.00,10.00,0.00,0.00),('1','122','1006','257608',4905809,'2973','454',86905.74,86905.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257608',4905810,'2974','454',155968.93,155968.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257608',4905811,'2975','454',121788.59,121788.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257608',4905812,'2976','454',136671.98,136671.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257608',4905813,'2977','454',135724.21,135724.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257608',4905814,'2978','454',183847.32,183847.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257608',4905815,'2979','454',110240.90,110240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257608',4905816,'2980','454',181084.28,181084.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257608',4905817,'2981','454',128461.53,128461.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257608',4905818,'2982','454',142839.27,142839.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257608',4905819,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257608',4905820,'2984','454',150140.72,150140.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257608',4905821,'2985','455',196048.15,196383.58,335.43,154297.80,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257608',4905822,'2986','455',79140.42,79140.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257608',4905823,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257608',4905824,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257609',4905825,'2961','454',303526.61,303526.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257609',4905826,'2962','454',241498.31,245845.63,4347.32,717307.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257609',4905827,'2963','454',171682.80,171682.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257609',4905828,'2964','454',296285.50,296285.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257609',4905829,'2965','454',158742.47,168892.62,10150.15,1674774.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257609',4905830,'2966','454',339081.07,339081.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257609',4905831,'2967','454',208700.52,208700.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257609',4905832,'2968','454',292043.44,292043.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257609',4905833,'2969','454',113561.82,124608.08,11046.26,1822632.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257609',4905834,'2970','454',242271.60,242271.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257609',4905835,'2971','454',284597.87,288261.96,3664.09,604574.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257609',4905836,'2972','454',152411.21,152411.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257609',4905837,'2973','454',86905.74,86905.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257609',4905838,'2974','454',155968.93,158824.62,2855.69,471188.85,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257609',4905839,'2975','454',121788.59,121788.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257609',4905840,'2976','454',136671.98,138896.62,2224.64,367065.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257609',4905841,'2977','454',135724.21,135724.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257609',4905842,'2978','454',183847.32,183847.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257609',4905843,'2979','454',110240.90,117435.45,7194.55,1187100.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257609',4905844,'2980','454',181084.28,182963.05,1878.77,309997.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257609',4905845,'2981','454',128461.53,136390.91,7929.38,1308347.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257609',4905846,'2982','454',142839.27,142839.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257609',4905847,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257609',4905848,'2984','454',150140.72,152714.08,2573.36,424604.40,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257609',4905849,'2985','455',196383.58,196498.58,115.00,52900.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257609',4905850,'2986','455',79140.42,79140.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257609',4905851,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257609',4905852,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257610',4905853,'2961','454',303526.61,303526.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257610',4905854,'2962','454',245845.63,245845.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257610',4905855,'2963','454',171682.80,171682.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257610',4905856,'2964','454',296285.50,298341.61,2056.11,339258.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257610',4905857,'2965','454',168892.62,171020.42,2127.80,351087.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257610',4905858,'2966','454',339081.07,339081.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257610',4905859,'2967','454',208700.52,208700.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257610',4905860,'2968','454',292043.44,294873.91,2830.47,467027.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257610',4905861,'2969','454',124608.08,124608.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257610',4905862,'2970','454',242271.60,242271.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257610',4905863,'2971','454',288261.96,290532.46,2270.50,374632.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257610',4905864,'2972','454',152411.21,152411.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257610',4905865,'2973','454',86905.74,98067.54,11161.80,1841697.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257610',4905866,'2974','454',158824.62,158824.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257610',4905867,'2975','454',121788.59,121788.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257610',4905868,'2976','454',138896.62,138896.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257610',4905869,'2977','454',135724.21,135724.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257610',4905870,'2978','454',183847.32,195134.83,11287.51,1862439.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257610',4905871,'2979','454',117435.45,117435.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257610',4905872,'2980','454',182963.05,182963.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257610',4905873,'2981','454',136390.91,148905.50,12514.59,2064907.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257610',4905874,'2982','454',142839.27,142839.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257610',4905875,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257610',4905876,'2984','454',152714.08,152714.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257610',4905877,'2985','455',196498.58,196498.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257610',4905878,'2986','455',79140.42,79140.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257610',4905879,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257610',4905880,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257611',4905881,'2961','454',303526.61,303526.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257611',4905882,'2962','454',245845.63,253759.57,7913.94,1305800.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257611',4905883,'2963','454',171682.80,171682.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257611',4905884,'2964','454',298341.61,298341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257611',4905885,'2965','454',171020.42,178861.79,7841.37,1293826.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257611',4905886,'2966','454',339081.07,339081.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257611',4905887,'2967','454',208700.52,208700.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257611',4905888,'2968','454',294873.91,294873.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257611',4905889,'2969','454',124608.08,124608.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257611',4905890,'2970','454',242271.60,251316.44,9044.84,1492398.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257611',4905891,'2971','454',290532.46,290532.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257611',4905892,'2972','454',152411.21,161967.07,9555.86,1576716.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257611',4905893,'2973','454',98067.54,102375.14,4307.60,710754.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257611',4905894,'2974','454',158824.62,158824.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257611',4905895,'2975','454',121788.59,121788.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257611',4905896,'2976','454',138896.62,138896.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257611',4905897,'2977','454',135724.21,140085.85,4361.64,719670.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257611',4905898,'2978','454',195134.83,195134.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257611',4905899,'2979','454',117435.45,117435.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257611',4905900,'2980','454',182963.05,182963.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257611',4905901,'2981','454',148905.50,148905.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257611',4905902,'2982','454',142839.27,147731.51,4892.24,807219.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257611',4905903,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257611',4905904,'2984','454',152714.08,157968.25,5254.17,866938.05,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257611',4905905,'2985','455',196498.58,196498.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257611',4905906,'2986','455',79140.42,79140.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257611',4905907,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257611',4905908,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257612',4905909,'2961','454',303526.61,303526.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257612',4905910,'2962','454',253759.57,253759.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257612',4905911,'2963','454',171682.80,171682.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257612',4905912,'2964','454',298341.61,298341.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257612',4905913,'2965','454',178861.79,178861.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257612',4905914,'2966','454',339081.07,339081.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257612',4905915,'2967','454',208700.52,208700.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257612',4905916,'2968','454',294873.91,294873.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257612',4905917,'2969','454',124608.08,124608.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257612',4905918,'2970','454',251316.44,251316.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257612',4905919,'2971','454',290532.46,290532.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257612',4905920,'2972','454',161967.07,161967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257612',4905921,'2973','454',102375.14,102375.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257612',4905922,'2974','454',158824.62,158824.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257612',4905923,'2975','454',121788.59,121788.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257612',4905924,'2976','454',138896.62,138896.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257612',4905925,'2977','454',140085.85,140085.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257612',4905926,'2978','454',195134.83,195134.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257612',4905927,'2979','454',117435.45,117435.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257612',4905928,'2980','454',182963.05,182963.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257612',4905929,'2981','454',148905.50,148905.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257612',4905930,'2982','454',147731.51,147731.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257612',4905931,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257612',4905932,'2984','454',157968.25,157968.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257612',4905933,'2985','455',196498.58,199104.64,2606.06,1303030.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257612',4905934,'2986','455',79140.42,81725.87,2585.45,1292725.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257612',4905935,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257612',4905936,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257613',4905937,'2961','454',303526.61,303526.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257613',4905938,'2962','454',253759.57,253759.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257613',4905939,'2963','454',171682.80,171682.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257613',4905940,'2964','454',298341.61,304169.84,5828.23,961657.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257613',4905941,'2965','454',178861.79,178861.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257613',4905942,'2966','454',339081.07,339081.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257613',4905943,'2967','454',208700.52,213993.95,5268.43,869290.95,0.00,0.00,25.00,0.00,0.00),('1','122','1004','257613',4905944,'2968','454',294873.91,294873.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257613',4905945,'2969','454',124608.08,124608.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257613',4905946,'2970','454',251316.44,251316.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257613',4905947,'2971','454',290532.46,295669.12,5136.66,847548.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257613',4905948,'2972','454',161967.07,161967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257613',4905949,'2973','454',102375.14,102375.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257613',4905950,'2974','454',158824.62,165447.12,6612.50,1091062.50,0.00,0.00,10.00,0.00,0.00),('1','122','1006','257613',4905951,'2975','454',121788.59,121788.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257613',4905952,'2976','454',138896.62,138896.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257613',4905953,'2977','454',140085.85,140085.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257613',4905954,'2978','454',195134.83,201994.84,6850.01,1130251.65,0.00,0.00,10.00,0.00,0.00),('1','122','1006','257613',4905955,'2979','454',117435.45,117435.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257613',4905956,'2980','454',182963.05,182963.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257613',4905957,'2981','454',148905.50,148905.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257613',4905958,'2982','454',147731.51,155237.67,7506.16,1238516.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257613',4905959,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257613',4905960,'2984','454',157968.25,160544.73,2576.48,425119.20,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257613',4905961,'2985','455',199104.64,201271.13,2136.49,1281894.00,0.00,0.00,30.00,0.00,0.00),('1','122','1007','257613',4905962,'2986','455',81725.87,83269.59,1523.72,914232.00,0.00,0.00,20.00,0.00,0.00),('1','122','1007','257613',4905963,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257613',4905964,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257614',4905965,'2961','454',303526.61,303526.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257614',4905966,'2962','454',253759.57,266375.65,12616.08,2081653.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257614',4905967,'2963','454',171682.80,171682.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257614',4905968,'2964','454',304169.84,304169.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257614',4905969,'2965','454',178861.79,189469.99,10608.20,1750353.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257614',4905970,'2966','454',339081.07,339081.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257614',4905971,'2967','454',213993.95,213993.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257614',4905972,'2968','454',294873.91,294873.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257614',4905973,'2969','454',124608.08,124608.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257614',4905974,'2970','454',251316.44,262949.79,11613.35,1916202.75,0.00,0.00,20.00,0.00,0.00),('1','122','1004','257614',4905975,'2971','454',295669.12,295669.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257614',4905976,'2972','454',161967.07,161967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257614',4905977,'2973','454',102375.14,102375.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257614',4905978,'2974','454',165447.12,173818.74,8371.62,1381317.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257614',4905979,'2975','454',121788.59,121788.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257614',4905980,'2976','454',138896.62,138896.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257614',4905981,'2977','454',140085.85,140085.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257614',4905982,'2978','454',201994.84,201994.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257614',4905983,'2979','454',117435.45,126438.89,9003.44,1485567.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257614',4905984,'2980','454',182963.05,182963.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257614',4905985,'2981','454',148905.50,148905.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257614',4905986,'2982','454',155237.67,166558.50,11285.83,1862161.95,0.00,0.00,35.00,0.00,0.00),('1','122','1006','257614',4905987,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257614',4905988,'2984','454',160544.73,160544.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257614',4905989,'2985','455',201271.13,202028.46,757.33,454398.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257614',4905990,'2986','455',83269.59,85918.80,2649.21,1589526.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257614',4905991,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257614',4905992,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257615',4905993,'2961','454',303526.61,311699.00,8172.39,1348444.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257615',4905994,'2962','454',266375.65,266375.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257615',4905995,'2963','454',171682.80,180415.33,8732.53,1440867.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257615',4905996,'2964','454',304169.84,304169.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257615',4905997,'2965','454',189469.99,189469.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257615',4905998,'2966','454',339081.07,344419.53,5338.46,880845.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257615',4905999,'2967','454',213993.95,213993.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257615',4906000,'2968','454',294873.91,294873.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257615',4906001,'2969','454',124608.08,130925.44,6317.36,1042364.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257615',4906002,'2970','454',262949.79,262949.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257615',4906003,'2971','454',295669.12,295669.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257615',4906004,'2972','454',161967.07,167661.37,5694.30,939559.50,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257615',4906005,'2973','454',102375.14,102375.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257615',4906006,'2974','454',173818.74,173818.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257615',4906007,'2975','454',121788.59,121788.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257615',4906008,'2976','454',138896.62,138896.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257615',4906009,'2977','454',140085.85,140085.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257615',4906010,'2978','454',201994.84,202380.98,386.14,63713.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257615',4906011,'2979','454',126438.89,126438.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257615',4906012,'2980','454',182963.05,187423.42,4460.37,735961.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257615',4906013,'2981','454',148905.50,148905.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257615',4906014,'2982','454',166558.50,166558.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257615',4906015,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257615',4906016,'2984','454',160544.73,165199.73,4655.00,768075.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257615',4906017,'2985','455',202028.46,203357.62,1309.16,785496.00,0.00,0.00,20.00,0.00,0.00),('1','122','1007','257615',4906018,'2986','455',85918.80,86709.64,780.84,468504.00,0.00,0.00,10.00,0.00,0.00),('1','122','1007','257615',4906019,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257615',4906020,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257616',4906021,'2961','454',311699.00,311699.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257616',4906022,'2962','454',266375.65,266375.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257616',4906023,'2963','454',180415.33,180415.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257616',4906024,'2964','454',304169.84,309514.58,5344.74,881882.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257616',4906025,'2965','454',189469.99,189469.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257616',4906026,'2966','454',344419.53,344419.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257616',4906027,'2967','454',213993.95,221109.90,7115.95,1174131.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257616',4906028,'2968','454',294873.91,294873.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257616',4906029,'2969','454',130925.44,130925.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257616',4906030,'2970','454',262949.79,266013.46,3063.67,505505.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257616',4906031,'2971','454',295669.12,302812.87,7143.75,1178718.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257616',4906032,'2972','454',167661.37,167661.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257616',4906033,'2973','454',102375.14,102375.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257616',4906034,'2974','454',173818.74,179567.97,5735.23,946312.95,0.00,0.00,14.00,0.00,0.00),('1','122','1006','257616',4906035,'2975','454',121788.59,121788.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257616',4906036,'2976','454',138896.62,143084.87,4188.25,691061.25,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257616',4906037,'2977','454',140085.85,144863.39,4777.54,788294.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257616',4906038,'2978','454',202380.98,202380.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257616',4906039,'2979','454',126438.89,130043.49,3604.60,594759.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257616',4906040,'2980','454',187423.42,187423.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257616',4906041,'2981','454',148905.50,154569.08,5653.58,932840.70,0.00,0.00,10.00,0.00,0.00),('1','122','1006','257616',4906042,'2982','454',166558.50,166558.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257616',4906043,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257616',4906044,'2984','454',165199.73,168808.89,3599.16,593861.40,0.00,0.00,10.00,0.00,0.00),('1','122','1007','257616',4906045,'2985','455',203357.62,209894.70,6537.08,3922248.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257616',4906046,'2986','455',86709.64,91461.76,4752.12,2851272.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257616',4906047,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257616',4906048,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257617',4906049,'2961','454',311699.00,311699.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257617',4906050,'2962','454',266375.65,279661.64,13285.99,2192188.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257617',4906051,'2963','454',180415.33,180415.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257617',4906052,'2964','454',309514.58,309514.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257617',4906053,'2965','454',189469.99,189469.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257617',4906054,'2966','454',344419.53,344419.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257617',4906055,'2967','454',221109.90,221109.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257617',4906056,'2968','454',294873.91,295144.22,270.31,44601.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257617',4906057,'2969','454',130925.44,141380.30,10454.86,1725051.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257617',4906058,'2970','454',266013.46,266013.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257617',4906059,'2971','454',302812.87,302812.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257617',4906060,'2972','454',167661.37,167661.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257617',4906061,'2973','454',102375.14,102375.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257617',4906062,'2974','454',179567.97,179567.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257617',4906063,'2975','454',121788.59,121788.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257617',4906064,'2976','454',143084.87,143084.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257617',4906065,'2977','454',144863.39,144863.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257617',4906066,'2978','454',202380.98,212317.62,9936.64,1639545.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257617',4906067,'2979','454',130043.49,130043.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257617',4906068,'2980','454',187423.42,187423.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257617',4906069,'2981','454',154569.08,154569.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257617',4906070,'2982','454',166558.50,179878.82,13320.32,2197852.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257617',4906071,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257617',4906072,'2984','454',168808.89,168996.43,187.54,30944.10,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257617',4906073,'2985','455',209894.70,213220.10,3325.40,1995240.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257617',4906074,'2986','455',91461.76,91748.56,286.80,172080.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257617',4906075,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257617',4906076,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257618',4906077,'2961','454',311699.00,311699.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257618',4906078,'2962','454',279661.64,279661.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257618',4906079,'2963','454',180415.33,180415.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257618',4906080,'2964','454',309514.58,324223.88,14709.30,2427034.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257618',4906081,'2965','454',189469.99,194117.06,4647.07,766766.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257618',4906082,'2966','454',344419.53,344419.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257618',4906083,'2967','454',221109.90,221109.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257618',4906084,'2968','454',295144.22,295144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257618',4906085,'2969','454',141380.30,141380.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257618',4906086,'2970','454',266013.46,284969.75,18956.29,3127787.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257618',4906087,'2971','454',302812.87,303151.14,338.27,55814.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257618',4906088,'2972','454',167661.37,172985.95,5324.58,878555.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257618',4906089,'2973','454',102375.14,102375.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257618',4906090,'2974','454',179567.97,179567.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257618',4906091,'2975','454',121788.59,121788.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257618',4906092,'2976','454',143084.87,143084.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257618',4906093,'2977','454',144863.39,144863.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257618',4906094,'2978','454',212317.62,212317.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257618',4906095,'2979','454',130043.49,139042.09,8998.60,1484769.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257618',4906096,'2980','454',187423.42,187423.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257618',4906097,'2981','454',154569.08,163724.23,9155.15,1510599.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257618',4906098,'2982','454',179878.82,179878.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257618',4906099,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257618',4906100,'2984','454',168996.43,168996.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257618',4906101,'2985','455',213220.10,214982.32,1732.22,1039332.00,0.00,0.00,30.00,0.00,0.00),('1','122','1007','257618',4906102,'2986','455',91748.56,93232.48,1483.92,890352.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257618',4906103,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257618',4906104,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257619',4906105,'2961','454',311699.00,311699.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257619',4906106,'2962','454',279661.64,291919.10,12257.46,2022480.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257619',4906107,'2963','454',180415.33,180415.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257619',4906108,'2964','454',324223.88,324223.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257619',4906109,'2965','454',194117.06,194117.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257619',4906110,'2966','454',344419.53,353959.00,9539.47,1574012.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257619',4906111,'2967','454',221109.90,221109.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257619',4906112,'2968','454',295144.22,295144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257619',4906113,'2969','454',141380.30,154233.65,12838.35,2118327.75,0.00,0.00,15.00,0.00,0.00),('1','122','1004','257619',4906114,'2970','454',284969.75,284969.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257619',4906115,'2971','454',303151.14,303151.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257619',4906116,'2972','454',172985.95,173789.67,773.72,127663.80,0.00,0.00,30.00,0.00,0.00),('1','122','1006','257619',4906117,'2973','454',102375.14,102375.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257619',4906118,'2974','454',179567.97,179567.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257619',4906119,'2975','454',121788.59,130551.38,8762.79,1445860.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257619',4906120,'2976','454',143084.87,143084.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257619',4906121,'2977','454',144863.39,144863.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257619',4906122,'2978','454',212317.62,212317.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257619',4906123,'2979','454',139042.09,143477.67,4435.58,731870.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257619',4906124,'2980','454',187423.42,187423.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257619',4906125,'2981','454',163724.23,163724.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257619',4906126,'2982','454',179878.82,179878.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257619',4906127,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257619',4906128,'2984','454',168996.43,173750.25,4753.82,784380.30,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257619',4906129,'2985','455',214982.32,214982.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257619',4906130,'2986','455',93232.48,93232.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257619',4906131,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257619',4906132,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257620',4906133,'2961','454',311699.00,314794.59,3095.59,510772.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257620',4906134,'2962','454',291919.10,303225.59,11306.49,1865570.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257620',4906135,'2963','454',180415.33,180415.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257620',4906136,'2964','454',324223.88,324223.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257620',4906137,'2965','454',194117.06,194117.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257620',4906138,'2966','454',353959.00,363805.96,9846.96,1624748.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257620',4906139,'2967','454',221109.90,221109.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257620',4906140,'2968','454',295144.22,295144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257620',4906141,'2969','454',154233.65,154233.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257620',4906142,'2970','454',284969.75,288056.96,3087.21,509389.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257620',4906143,'2971','454',303151.14,304801.52,1650.38,272312.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257620',4906144,'2972','454',173789.67,184407.33,10617.66,1751913.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257620',4906145,'2973','454',102375.14,102375.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257620',4906146,'2974','454',179567.97,179567.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257620',4906147,'2975','454',130551.38,130551.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257620',4906148,'2976','454',143084.87,143084.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257620',4906149,'2977','454',144863.39,144863.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257620',4906150,'2978','454',212317.62,212317.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257620',4906151,'2979','454',143477.67,143477.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257620',4906152,'2980','454',187423.42,187423.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257620',4906153,'2981','454',163724.23,163724.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257620',4906154,'2982','454',179878.82,179878.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257620',4906155,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257620',4906156,'2984','454',173750.25,173750.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257620',4906157,'2985','455',214982.32,219004.31,3986.99,2591543.50,0.00,0.00,35.00,0.00,0.00),('1','122','1007','257620',4906158,'2986','455',93232.48,94471.53,1239.05,805382.50,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257620',4906159,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257620',4906160,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257621',4906161,'2961','454',314794.59,318789.28,3994.69,659123.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257621',4906162,'2962','454',303225.59,309550.16,6324.57,1043554.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257621',4906163,'2963','454',180415.33,180415.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257621',4906164,'2964','454',324223.88,332104.20,7870.32,1298602.80,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257621',4906165,'2965','454',194117.06,197828.84,3711.78,612443.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257621',4906166,'2966','454',363805.96,370748.94,6942.98,1145591.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257621',4906167,'2967','454',221109.90,221109.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257621',4906168,'2968','454',295144.22,295144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257621',4906169,'2969','454',154233.65,156793.66,2560.01,422401.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257621',4906170,'2970','454',288056.96,290627.86,2570.90,424198.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257621',4906171,'2971','454',304801.52,313597.53,8781.01,1448866.65,0.00,0.00,15.00,0.00,0.00),('1','122','1004','257621',4906172,'2972','454',184407.33,189125.80,4718.47,778547.55,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257621',4906173,'2973','454',102375.14,105317.29,2942.15,485454.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257621',4906174,'2974','454',179567.97,179567.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257621',4906175,'2975','454',130551.38,130551.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257621',4906176,'2976','454',143084.87,143084.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257621',4906177,'2977','454',144863.39,144863.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257621',4906178,'2978','454',212317.62,215211.38,2893.76,477470.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257621',4906179,'2979','454',143477.67,143477.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257621',4906180,'2980','454',187423.42,187423.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257621',4906181,'2981','454',163724.23,166985.44,3261.21,538099.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257621',4906182,'2982','454',179878.82,179878.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257621',4906183,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257621',4906184,'2984','454',173750.25,175066.42,1266.17,208918.05,0.00,0.00,50.00,0.00,0.00),('1','122','1007','257621',4906185,'2985','455',219004.31,227299.25,8294.94,5391711.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257621',4906186,'2986','455',94471.53,103679.49,9207.96,5985174.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257621',4906187,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257621',4906188,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257622',4906189,'2961','454',318789.28,318789.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257622',4906190,'2962','454',309550.16,309550.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257622',4906191,'2963','454',180415.33,180415.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257622',4906192,'2964','454',332104.20,332104.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257622',4906193,'2965','454',197828.84,197828.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257622',4906194,'2966','454',370748.94,370748.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257622',4906195,'2967','454',221109.90,221109.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257622',4906196,'2968','454',295144.22,295144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257622',4906197,'2969','454',156793.66,156793.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257622',4906198,'2970','454',290627.86,290627.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257622',4906199,'2971','454',313597.53,313597.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257622',4906200,'2972','454',189125.80,189125.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257622',4906201,'2973','454',105317.29,105317.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257622',4906202,'2974','454',179567.97,179567.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257622',4906203,'2975','454',130551.38,130551.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257622',4906204,'2976','454',143084.87,143084.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257622',4906205,'2977','454',144863.39,144863.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257622',4906206,'2978','454',215211.38,215211.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257622',4906207,'2979','454',143477.67,143477.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257622',4906208,'2980','454',187423.42,187423.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257622',4906209,'2981','454',166985.44,166985.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257622',4906210,'2982','454',179878.82,179878.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257622',4906211,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257622',4906212,'2984','454',175066.42,175066.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257622',4906213,'2985','455',227299.25,228291.67,992.42,645073.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257622',4906214,'2986','455',103679.49,104248.26,568.77,369700.50,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257622',4906215,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257622',4906216,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257623',4906217,'2961','454',318789.28,318789.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257623',4906218,'2962','454',309550.16,309550.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257623',4906219,'2963','454',180415.33,180415.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257623',4906220,'2964','454',332104.20,332104.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257623',4906221,'2965','454',197828.84,197828.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257623',4906222,'2966','454',370748.94,370748.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257623',4906223,'2967','454',221109.90,221109.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257623',4906224,'2968','454',295144.22,295144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257623',4906225,'2969','454',156793.66,156793.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257623',4906226,'2970','454',290627.86,290627.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257623',4906227,'2971','454',313597.53,313597.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257623',4906228,'2972','454',189125.80,189125.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257623',4906229,'2973','454',105317.29,105317.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257623',4906230,'2974','454',179567.97,186599.58,7031.61,1160215.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257623',4906231,'2975','454',130551.38,130551.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257623',4906232,'2976','454',143084.87,149569.57,6484.70,1069975.50,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257623',4906233,'2977','454',144863.39,144863.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257623',4906234,'2978','454',215211.38,223927.01,8715.63,1438078.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257623',4906235,'2979','454',143477.67,148989.61,5511.94,909470.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257623',4906236,'2980','454',187423.42,187423.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257623',4906237,'2981','454',166985.44,176365.78,9380.34,1547756.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257623',4906238,'2982','454',179878.82,179878.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257623',4906239,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257623',4906240,'2984','454',175066.42,182028.11,6939.69,1145048.85,0.00,0.00,22.00,0.00,0.00),('1','122','1007','257623',4906241,'2985','455',228291.67,228975.74,684.07,451486.20,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257623',4906242,'2986','455',104248.26,105228.56,980.30,646998.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257623',4906243,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257623',4906244,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257624',4906245,'2961','454',318789.28,318789.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257624',4906246,'2962','454',309550.16,323383.05,13832.89,2282426.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257624',4906247,'2963','454',180415.33,180415.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257624',4906248,'2964','454',332104.20,332104.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257624',4906249,'2965','454',197828.84,209907.71,12078.87,1993013.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257624',4906250,'2966','454',370748.94,370748.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257624',4906251,'2967','454',221109.90,221109.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257624',4906252,'2968','454',295144.22,295144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257624',4906253,'2969','454',156793.66,156793.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257624',4906254,'2970','454',290627.86,296268.49,5640.63,930703.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257624',4906255,'2971','454',313597.53,313597.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257624',4906256,'2972','454',189125.80,189125.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257624',4906257,'2973','454',105317.29,105317.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257624',4906258,'2974','454',186599.58,186599.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257624',4906259,'2975','454',130551.38,130551.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257624',4906260,'2976','454',149569.57,152013.52,2443.95,403251.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257624',4906261,'2977','454',144863.39,145523.40,660.01,108901.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257624',4906262,'2978','454',223927.01,226354.18,2427.17,400483.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257624',4906263,'2979','454',148989.61,148989.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257624',4906264,'2980','454',187423.42,187423.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257624',4906265,'2981','454',176365.78,176365.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257624',4906266,'2982','454',179878.82,189144.36,9265.54,1528814.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257624',4906267,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257624',4906268,'2984','454',182028.11,186024.23,3996.12,659359.80,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257624',4906269,'2985','455',228975.74,237678.84,8693.10,5737446.00,0.00,0.00,10.00,0.00,0.00),('1','122','1007','257624',4906270,'2986','455',105228.56,107941.30,2712.74,1790408.40,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257624',4906271,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257624',4906272,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257625',4906273,'2961','454',318789.28,318789.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257625',4906274,'2962','454',323383.05,333181.27,9798.22,1616706.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257625',4906275,'2963','454',180415.33,180415.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257625',4906276,'2964','454',332104.20,332104.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257625',4906277,'2965','454',209907.71,209907.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257625',4906278,'2966','454',370748.94,379751.16,9002.22,1485366.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257625',4906279,'2967','454',221109.90,221109.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257625',4906280,'2968','454',295144.22,295144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257625',4906281,'2969','454',156793.66,166677.22,9883.56,1630787.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257625',4906282,'2970','454',296268.49,296268.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257625',4906283,'2971','454',313597.53,314679.41,1081.88,178510.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257625',4906284,'2972','454',189125.80,189125.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257625',4906285,'2973','454',105317.29,105317.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257625',4906286,'2974','454',186599.58,186599.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257625',4906287,'2975','454',130551.38,135008.00,4456.62,735342.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257625',4906288,'2976','454',152013.52,152013.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257625',4906289,'2977','454',145523.40,145523.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257625',4906290,'2978','454',226354.18,230721.23,4367.05,720563.25,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257625',4906291,'2979','454',148989.61,150816.80,1827.19,301486.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257625',4906292,'2980','454',187423.42,187423.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257625',4906293,'2981','454',176365.78,176365.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257625',4906294,'2982','454',189144.36,189144.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257625',4906295,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257625',4906296,'2984','454',186024.23,190690.40,4666.17,769918.05,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257625',4906297,'2985','455',237678.84,237975.00,296.16,195465.60,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257625',4906298,'2986','455',107941.30,108065.10,123.80,81708.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257625',4906299,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257625',4906300,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257626',4906301,'2961','454',318789.28,318789.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257626',4906302,'2962','454',333181.27,333181.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257626',4906303,'2963','454',180415.33,180415.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257626',4906304,'2964','454',332104.20,332104.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257626',4906305,'2965','454',209907.71,209907.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257626',4906306,'2966','454',379751.16,379751.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257626',4906307,'2967','454',221109.90,221109.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257626',4906308,'2968','454',295144.22,295144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257626',4906309,'2969','454',166677.22,166677.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257626',4906310,'2970','454',296268.49,296268.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257626',4906311,'2971','454',314679.41,314679.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257626',4906312,'2972','454',189125.80,189125.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257626',4906313,'2973','454',105317.29,105317.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257626',4906314,'2974','454',186599.58,186599.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257626',4906315,'2975','454',135008.00,135008.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257626',4906316,'2976','454',152013.52,152013.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257626',4906317,'2977','454',145523.40,145523.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257626',4906318,'2978','454',230721.23,230721.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257626',4906319,'2979','454',150816.80,150816.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257626',4906320,'2980','454',187423.42,187423.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257626',4906321,'2981','454',176365.78,176365.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257626',4906322,'2982','454',189144.36,189144.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257626',4906323,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257626',4906324,'2984','454',190690.40,190690.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257626',4906325,'2985','455',237975.00,237975.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257626',4906326,'2986','455',108065.10,108065.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257626',4906327,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257626',4906328,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257627',4906329,'2961','454',318789.28,318789.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257627',4906330,'2962','454',333181.27,333181.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257627',4906331,'2963','454',180415.33,180415.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257627',4906332,'2964','454',332104.20,332104.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257627',4906333,'2965','454',209907.71,209907.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257627',4906334,'2966','454',379751.16,379751.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257627',4906335,'2967','454',221109.90,221109.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257627',4906336,'2968','454',295144.22,295144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257627',4906337,'2969','454',166677.22,166677.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257627',4906338,'2970','454',296268.49,296268.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257627',4906339,'2971','454',314679.41,314679.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257627',4906340,'2972','454',189125.80,189125.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257627',4906341,'2973','454',105317.29,105317.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257627',4906342,'2974','454',186599.58,186599.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257627',4906343,'2975','454',135008.00,135008.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257627',4906344,'2976','454',152013.52,152013.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257627',4906345,'2977','454',145523.40,145523.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257627',4906346,'2978','454',230721.23,230721.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257627',4906347,'2979','454',150816.80,150816.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257627',4906348,'2980','454',187423.42,187423.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257627',4906349,'2981','454',176365.78,176365.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257627',4906350,'2982','454',189144.36,189144.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257627',4906351,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257627',4906352,'2984','454',190690.40,190690.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257627',4906353,'2985','455',237975.00,237975.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257627',4906354,'2986','455',108065.10,108065.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257627',4906355,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257627',4906356,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257628',4906357,'2961','454',318789.28,318789.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257628',4906358,'2962','454',333181.27,333181.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257628',4906359,'2963','454',180415.33,180415.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257628',4906360,'2964','454',332104.20,332104.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257628',4906361,'2965','454',209907.71,209907.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257628',4906362,'2966','454',379751.16,379751.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257628',4906363,'2967','454',221109.90,221109.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257628',4906364,'2968','454',295144.22,295144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257628',4906365,'2969','454',166677.22,166677.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257628',4906366,'2970','454',296268.49,296268.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257628',4906367,'2971','454',314679.41,314679.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257628',4906368,'2972','454',189125.80,189125.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257628',4906369,'2973','454',105317.29,105317.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257628',4906370,'2974','454',186599.58,197567.82,10968.24,1809759.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257628',4906371,'2975','454',135008.00,135008.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257628',4906372,'2976','454',152013.52,152013.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257628',4906373,'2977','454',145523.40,157253.21,11729.81,1935418.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257628',4906374,'2978','454',230721.23,230721.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257628',4906375,'2979','454',150816.80,150816.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257628',4906376,'2980','454',187423.42,187423.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257628',4906377,'2981','454',176365.78,176365.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257628',4906378,'2982','454',189144.36,201369.22,12224.86,2017101.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257628',4906379,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257628',4906380,'2984','454',190690.40,192200.53,1510.13,249171.45,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257628',4906381,'2985','455',237975.00,239698.37,1723.37,1171891.60,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257628',4906382,'2986','455',108065.10,108431.04,365.94,248839.20,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257628',4906383,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257628',4906384,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257629',4906385,'2961','454',318789.28,318789.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257629',4906386,'2962','454',333181.27,333181.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257629',4906387,'2963','454',180415.33,180415.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257629',4906388,'2964','454',332104.20,332104.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257629',4906389,'2965','454',209907.71,209907.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257629',4906390,'2966','454',379751.16,379751.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257629',4906391,'2967','454',221109.90,221109.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257629',4906392,'2968','454',295144.22,295144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257629',4906393,'2969','454',166677.22,166677.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257629',4906394,'2970','454',296268.49,296268.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257629',4906395,'2971','454',314679.41,314679.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257629',4906396,'2972','454',189125.80,189125.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257629',4906397,'2973','454',105317.29,105317.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257629',4906398,'2974','454',197567.82,200106.98,2539.16,418961.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257629',4906399,'2975','454',135008.00,135008.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257629',4906400,'2976','454',152013.52,161017.94,9004.42,1485729.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257629',4906401,'2977','454',157253.21,157253.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257629',4906402,'2978','454',230721.23,240156.54,9435.31,1556826.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257629',4906403,'2979','454',150816.80,150816.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257629',4906404,'2980','454',187423.42,193469.66,6046.24,997629.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257629',4906405,'2981','454',176365.78,190864.36,14498.58,2392265.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257629',4906406,'2982','454',201369.22,201369.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257629',4906407,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257629',4906408,'2984','454',192200.53,192768.05,567.52,93640.80,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257629',4906409,'2985','455',239698.37,249485.51,9787.14,6655255.20,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257629',4906410,'2986','455',108431.04,115035.88,6604.84,4491291.20,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257629',4906411,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257629',4906412,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257630',4906413,'2961','454',318789.28,318789.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257630',4906414,'2962','454',333181.27,349268.18,16056.91,2649390.15,0.00,0.00,30.00,0.00,0.00),('1','122','1004','257630',4906415,'2963','454',180415.33,180415.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257630',4906416,'2964','454',332104.20,344037.37,11933.17,1968973.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257630',4906417,'2965','454',209907.71,209907.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257630',4906418,'2966','454',379751.16,384748.46,4997.30,824554.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257630',4906419,'2967','454',221109.90,221109.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257630',4906420,'2968','454',295144.22,295144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257630',4906421,'2969','454',166677.22,166677.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257630',4906422,'2970','454',296268.49,311422.45,15153.96,2500403.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257630',4906423,'2971','454',314679.41,314679.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257630',4906424,'2972','454',189125.80,198247.47,9121.67,1505075.55,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257630',4906425,'2973','454',105317.29,105317.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257630',4906426,'2974','454',200106.98,200106.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257630',4906427,'2975','454',135008.00,135008.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257630',4906428,'2976','454',161017.94,161017.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257630',4906429,'2977','454',157253.21,157253.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257630',4906430,'2978','454',240156.54,240156.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257630',4906431,'2979','454',150816.80,155619.31,4802.51,792414.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257630',4906432,'2980','454',193469.66,193469.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257630',4906433,'2981','454',190864.36,190864.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257630',4906434,'2982','454',201369.22,201369.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257630',4906435,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257630',4906436,'2984','454',192768.05,198742.04,5973.99,985708.35,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257630',4906437,'2985','455',249485.51,250097.29,611.78,416010.40,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257630',4906438,'2986','455',115035.88,115035.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257630',4906439,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257630',4906440,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257631',4906441,'2961','454',318789.28,318789.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257631',4906442,'2962','454',349268.18,349268.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257631',4906443,'2963','454',180415.33,180415.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257631',4906444,'2964','454',344037.37,344037.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257631',4906445,'2965','454',209907.71,209907.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257631',4906446,'2966','454',384748.46,384748.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257631',4906447,'2967','454',221109.90,221109.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257631',4906448,'2968','454',295144.22,295144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257631',4906449,'2969','454',166677.22,166677.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257631',4906450,'2970','454',311422.45,311422.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257631',4906451,'2971','454',314679.41,314679.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257631',4906452,'2972','454',198247.47,198247.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257631',4906453,'2973','454',105317.29,105317.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257631',4906454,'2974','454',200106.98,200106.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257631',4906455,'2975','454',135008.00,135008.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257631',4906456,'2976','454',161017.94,161017.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257631',4906457,'2977','454',157253.21,157253.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257631',4906458,'2978','454',240156.54,240156.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257631',4906459,'2979','454',155619.31,155619.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257631',4906460,'2980','454',193469.66,193469.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257631',4906461,'2981','454',190864.36,190864.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257631',4906462,'2982','454',201369.22,201369.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257631',4906463,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257631',4906464,'2984','454',198742.04,198742.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257631',4906465,'2985','455',250097.29,250097.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257631',4906466,'2986','455',115035.88,115035.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257631',4906467,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257631',4906468,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257632',4906469,'2961','454',318789.28,318789.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257632',4906470,'2962','454',349268.18,349268.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257632',4906471,'2963','454',180415.33,180415.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257632',4906472,'2964','454',344037.37,344037.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257632',4906473,'2965','454',209907.71,209907.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257632',4906474,'2966','454',384748.46,384748.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257632',4906475,'2967','454',221109.90,221109.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257632',4906476,'2968','454',295144.22,295144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257632',4906477,'2969','454',166677.22,166677.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257632',4906478,'2970','454',311422.45,311422.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257632',4906479,'2971','454',314679.41,314679.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257632',4906480,'2972','454',198247.47,198247.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257632',4906481,'2973','454',105317.29,105317.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257632',4906482,'2974','454',200106.98,200106.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257632',4906483,'2975','454',135008.00,135008.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257632',4906484,'2976','454',161017.94,161017.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257632',4906485,'2977','454',157253.21,157253.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257632',4906486,'2978','454',240156.54,240156.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257632',4906487,'2979','454',155619.31,155619.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257632',4906488,'2980','454',193469.66,193469.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257632',4906489,'2981','454',190864.36,190864.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257632',4906490,'2982','454',201369.22,201369.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257632',4906491,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257632',4906492,'2984','454',198742.04,198742.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257632',4906493,'2985','455',250097.29,252089.36,1992.07,1354607.60,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257632',4906494,'2986','455',115035.88,115258.84,222.96,151612.80,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257632',4906495,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257632',4906496,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257633',4906497,'2961','454',318789.28,318789.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257633',4906498,'2962','454',349268.18,359085.00,9816.82,1619775.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257633',4906499,'2963','454',180415.33,186181.71,5766.38,951452.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257633',4906500,'2964','454',344037.37,344037.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257633',4906501,'2965','454',209907.71,210481.97,574.26,94752.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257633',4906502,'2966','454',384748.46,393706.14,8957.68,1478017.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257633',4906503,'2967','454',221109.90,221109.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257633',4906504,'2968','454',295144.22,295144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257633',4906505,'2969','454',166677.22,178759.31,12082.09,1993544.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257633',4906506,'2970','454',311422.45,311422.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257633',4906507,'2971','454',314679.41,314679.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257633',4906508,'2972','454',198247.47,204241.52,5994.05,989018.25,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257633',4906509,'2973','454',105317.29,105317.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257633',4906510,'2974','454',200106.98,200106.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257633',4906511,'2975','454',135008.00,135008.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257633',4906512,'2976','454',161017.94,161017.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257633',4906513,'2977','454',157253.21,157253.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257633',4906514,'2978','454',240156.54,240156.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257633',4906515,'2979','454',155619.31,155619.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257633',4906516,'2980','454',193469.66,193469.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257633',4906517,'2981','454',190864.36,190864.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257633',4906518,'2982','454',201369.22,201369.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257633',4906519,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257633',4906520,'2984','454',198742.04,198742.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257633',4906521,'2985','455',252089.36,254656.95,2567.59,1797313.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257633',4906522,'2986','455',115258.84,115667.42,408.58,286006.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257633',4906523,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257633',4906524,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257634',4906525,'2961','454',318789.28,318789.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257634',4906526,'2962','454',359085.00,359085.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257634',4906527,'2963','454',186181.71,186181.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257634',4906528,'2964','454',344037.37,352054.10,8016.73,1322760.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257634',4906529,'2965','454',210481.97,210481.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257634',4906530,'2966','454',393706.14,399625.12,5918.98,976631.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257634',4906531,'2967','454',221109.90,221109.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257634',4906532,'2968','454',295144.22,295144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257634',4906533,'2969','454',178759.31,178759.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257634',4906534,'2970','454',311422.45,318742.82,7320.37,1207861.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257634',4906535,'2971','454',314679.41,314679.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257634',4906536,'2972','454',204241.52,208911.15,4669.63,770488.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257634',4906537,'2973','454',105317.29,105317.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257634',4906538,'2974','454',200106.98,200106.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257634',4906539,'2975','454',135008.00,135008.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257634',4906540,'2976','454',161017.94,161017.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257634',4906541,'2977','454',157253.21,157253.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257634',4906542,'2978','454',240156.54,240156.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257634',4906543,'2979','454',155619.31,155619.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257634',4906544,'2980','454',193469.66,208316.70,14807.04,2443161.60,0.00,0.00,40.00,0.00,0.00),('1','122','1006','257634',4906545,'2981','454',190864.36,204981.87,14117.51,2329389.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257634',4906546,'2982','454',201369.22,201369.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257634',4906547,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257634',4906548,'2984','454',198742.04,198742.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257634',4906549,'2985','455',254656.95,258632.77,3965.82,2776074.00,0.00,0.00,10.00,0.00,0.00),('1','122','1007','257634',4906550,'2986','455',115667.42,119581.01,3900.59,2730413.00,0.00,0.00,13.00,0.00,0.00),('1','122','1007','257634',4906551,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257634',4906552,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257635',4906553,'2961','454',318789.28,318789.87,0.59,97.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257635',4906554,'2962','454',359085.00,374534.55,15358.65,2534177.25,0.00,0.00,90.90,0.00,0.00),('1','122','1004','257635',4906555,'2963','454',186181.71,186181.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257635',4906556,'2964','454',352054.10,353697.19,1643.09,271109.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257635',4906557,'2965','454',210481.97,210481.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257635',4906558,'2966','454',399625.12,399625.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257635',4906559,'2967','454',221109.90,221109.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257635',4906560,'2968','454',295144.22,295144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257635',4906561,'2969','454',178759.31,191351.19,12591.88,2077660.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257635',4906562,'2970','454',318742.82,320568.81,1825.99,301288.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257635',4906563,'2971','454',314679.41,314679.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257635',4906564,'2972','454',208911.15,208911.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257635',4906565,'2973','454',105317.29,105317.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257635',4906566,'2974','454',200106.98,200106.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257635',4906567,'2975','454',135008.00,139465.69,4447.69,733868.85,0.00,0.00,10.00,0.00,0.00),('1','122','1006','257635',4906568,'2976','454',161017.94,161017.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257635',4906569,'2977','454',157253.21,157253.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257635',4906570,'2978','454',240156.54,248662.23,8505.69,1403438.85,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257635',4906571,'2979','454',155619.31,155619.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257635',4906572,'2980','454',208316.70,208316.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257635',4906573,'2981','454',204981.87,204981.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257635',4906574,'2982','454',201369.22,201369.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257635',4906575,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257635',4906576,'2984','454',198742.04,198742.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257635',4906577,'2985','455',258632.77,262043.22,3385.45,2369815.00,0.00,0.00,25.00,0.00,0.00),('1','122','1007','257635',4906578,'2986','455',119581.01,122207.44,2606.43,1824501.00,0.00,0.00,20.00,0.00,0.00),('1','122','1007','257635',4906579,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257635',4906580,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257636',4906581,'2961','454',318789.87,318789.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257636',4906582,'2962','454',374534.55,374534.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257636',4906583,'2963','454',186181.71,198250.00,12068.29,1991267.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257636',4906584,'2964','454',353697.19,353697.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257636',4906585,'2965','454',210481.97,210481.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257636',4906586,'2966','454',399625.12,399625.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257636',4906587,'2967','454',221109.90,221109.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257636',4906588,'2968','454',295144.22,295144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257636',4906589,'2969','454',191351.19,205442.74,14091.55,2325105.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257636',4906590,'2970','454',320568.81,320568.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257636',4906591,'2971','454',314679.41,314900.79,221.38,36527.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257636',4906592,'2972','454',208911.15,208911.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257636',4906593,'2973','454',105317.29,105317.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257636',4906594,'2974','454',200106.98,200106.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257636',4906595,'2975','454',139465.69,139465.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257636',4906596,'2976','454',161017.94,161017.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257636',4906597,'2977','454',157253.21,157253.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257636',4906598,'2978','454',248662.23,250698.17,2035.94,335930.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257636',4906599,'2979','454',155619.31,155619.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257636',4906600,'2980','454',208316.70,215172.00,6855.30,1131124.50,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257636',4906601,'2981','454',204981.87,218226.50,13244.63,2185363.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257636',4906602,'2982','454',201369.22,201369.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257636',4906603,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257636',4906604,'2984','454',198742.04,198742.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257636',4906605,'2985','455',262043.22,262218.24,175.02,122514.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257636',4906606,'2986','455',122207.44,122207.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257636',4906607,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257636',4906608,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257637',4906609,'2961','454',318789.87,318789.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257637',4906610,'2962','454',374534.55,374534.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257637',4906611,'2963','454',198250.00,198250.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257637',4906612,'2964','454',353697.19,353697.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257637',4906613,'2965','454',210481.97,210481.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257637',4906614,'2966','454',399625.12,411819.26,12194.14,2012033.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257637',4906615,'2967','454',221109.90,221109.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257637',4906616,'2968','454',295144.22,295144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257637',4906617,'2969','454',205442.74,205442.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257637',4906618,'2970','454',320568.81,320568.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257637',4906619,'2971','454',314900.79,329018.62,14117.83,2329441.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257637',4906620,'2972','454',208911.15,208911.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257637',4906621,'2973','454',105317.29,107458.26,2140.97,353260.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257637',4906622,'2974','454',200106.98,200106.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257637',4906623,'2975','454',139465.69,139465.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257637',4906624,'2976','454',161017.94,170276.44,9258.50,1527652.50,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257637',4906625,'2977','454',157253.21,163938.35,6685.14,1103048.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257637',4906626,'2978','454',250698.17,250698.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257637',4906627,'2979','454',155619.31,155619.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257637',4906628,'2980','454',215172.00,215172.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257637',4906629,'2981','454',218226.50,218226.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257637',4906630,'2982','454',201369.22,201369.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257637',4906631,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257637',4906632,'2984','454',198742.04,202075.46,3333.42,550014.30,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257637',4906633,'2985','455',262218.24,262468.25,250.01,175007.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257637',4906634,'2986','455',122207.44,122207.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257637',4906635,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257637',4906636,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257638',4906637,'2961','454',318789.87,318789.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257638',4906638,'2962','454',374534.55,380593.72,6059.17,999763.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257638',4906639,'2963','454',198250.00,198250.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257638',4906640,'2964','454',353697.19,362850.00,9152.81,1510213.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257638',4906641,'2965','454',210481.97,210481.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257638',4906642,'2966','454',411819.26,411819.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257638',4906643,'2967','454',221109.90,223454.56,2344.66,386868.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257638',4906644,'2968','454',295144.22,295144.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257638',4906645,'2969','454',205442.74,205442.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257638',4906646,'2970','454',320568.81,320568.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257638',4906647,'2971','454',329018.62,329018.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257638',4906648,'2972','454',208911.15,215694.96,6783.81,1119328.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257638',4906649,'2973','454',107458.26,107458.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257638',4906650,'2974','454',200106.98,200106.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257638',4906651,'2975','454',139465.69,139465.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257638',4906652,'2976','454',170276.44,170276.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257638',4906653,'2977','454',163938.35,163938.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257638',4906654,'2978','454',250698.17,255838.19,5140.02,848103.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257638',4906655,'2979','454',155619.31,164694.35,9075.04,1497381.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257638',4906656,'2980','454',215172.00,215172.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257638',4906657,'2981','454',218226.50,218226.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257638',4906658,'2982','454',201369.22,209865.14,8495.92,1401826.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257638',4906659,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257638',4906660,'2984','454',202075.46,208335.75,6260.29,1032947.85,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257638',4906661,'2985','455',262468.25,267075.71,4607.46,3225222.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257638',4906662,'2986','455',122207.44,124457.48,2250.04,1575028.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257638',4906663,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257638',4906664,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257639',4906665,'2961','454',318789.87,320175.68,1385.81,228658.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257639',4906666,'2962','454',380593.72,380593.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257639',4906667,'2963','454',198250.00,198250.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257639',4906668,'2964','454',362850.00,365876.77,3026.77,499417.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257639',4906669,'2965','454',210481.97,210481.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257639',4906670,'2966','454',411819.26,411819.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257639',4906671,'2967','454',223454.56,223454.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257639',4906672,'2968','454',295144.22,304329.85,9185.63,1515628.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257639',4906673,'2969','454',205442.74,205442.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257639',4906674,'2970','454',320568.81,325960.34,5391.53,889602.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257639',4906675,'2971','454',329018.62,329018.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257639',4906676,'2972','454',215694.96,215694.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257639',4906677,'2973','454',107458.26,107458.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257639',4906678,'2974','454',200106.98,200106.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257639',4906679,'2975','454',139465.69,147559.84,8094.15,1335534.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257639',4906680,'2976','454',170276.44,173455.13,3178.69,524483.85,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257639',4906681,'2977','454',163938.35,163938.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257639',4906682,'2978','454',255838.19,260824.16,4985.97,822685.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257639',4906683,'2979','454',164694.35,164694.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257639',4906684,'2980','454',215172.00,215172.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257639',4906685,'2981','454',218226.50,218226.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257639',4906686,'2982','454',209865.14,209865.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257639',4906687,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257639',4906688,'2984','454',208335.75,208490.75,155.00,25575.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257639',4906689,'2985','455',267075.71,272222.02,5146.31,3602417.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257639',4906690,'2986','455',124457.48,125202.90,745.42,521794.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257639',4906691,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257639',4906692,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257640',4906693,'2961','454',320175.68,320175.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257640',4906694,'2962','454',380593.72,387180.40,6586.68,1086802.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257640',4906695,'2963','454',198250.00,198250.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257640',4906696,'2964','454',365876.77,370079.45,4202.68,693442.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257640',4906697,'2965','454',210481.97,211626.23,1144.26,188802.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257640',4906698,'2966','454',411819.26,411819.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257640',4906699,'2967','454',223454.56,223454.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257640',4906700,'2968','454',304329.85,308442.64,4112.79,678610.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257640',4906701,'2969','454',205442.74,205442.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257640',4906702,'2970','454',325960.34,334352.89,8392.55,1384770.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257640',4906703,'2971','454',329018.62,333539.99,4521.37,746026.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257640',4906704,'2972','454',215694.96,215694.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257640',4906705,'2973','454',107458.26,108660.46,1202.20,198363.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257640',4906706,'2974','454',200106.98,200106.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257640',4906707,'2975','454',147559.84,147559.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257640',4906708,'2976','454',173455.13,173455.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257640',4906709,'2977','454',163938.35,163938.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257640',4906710,'2978','454',260824.16,260824.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257640',4906711,'2979','454',164694.35,172697.87,8003.52,1320580.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257640',4906712,'2980','454',215172.00,215290.24,118.24,19509.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257640',4906713,'2981','454',218226.50,226313.92,8087.42,1334424.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257640',4906714,'2982','454',209865.14,209865.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257640',4906715,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257640',4906716,'2984','454',208490.75,208490.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257640',4906717,'2985','455',272222.02,276941.92,4709.90,3296930.00,0.00,0.00,10.00,0.00,0.00),('1','122','1007','257640',4906718,'2986','455',125202.90,126907.75,1694.85,1186395.00,0.00,0.00,10.00,0.00,0.00),('1','122','1007','257640',4906719,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257640',4906720,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257641',4906721,'2961','454',320175.68,320175.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257641',4906722,'2962','454',387180.40,395402.12,8221.72,1356583.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257641',4906723,'2963','454',198250.00,198250.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257641',4906724,'2964','454',370079.45,373502.65,3423.20,564828.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257641',4906725,'2965','454',211626.23,211626.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257641',4906726,'2966','454',411819.26,411819.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257641',4906727,'2967','454',223454.56,230530.58,7076.02,1167543.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257641',4906728,'2968','454',308442.64,308442.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257641',4906729,'2969','454',205442.74,205442.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257641',4906730,'2970','454',334352.89,338176.65,3823.76,630920.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257641',4906731,'2971','454',333539.99,333539.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257641',4906732,'2972','454',215694.96,220717.20,5022.24,828669.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257641',4906733,'2973','454',108660.46,108660.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257641',4906734,'2974','454',200106.98,200106.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257641',4906735,'2975','454',147559.84,147559.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257641',4906736,'2976','454',173455.13,181480.58,8025.45,1324199.25,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257641',4906737,'2977','454',163938.35,163938.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257641',4906738,'2978','454',260824.16,267978.92,7154.76,1180535.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257641',4906739,'2979','454',172697.87,172864.84,166.97,27550.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257641',4906740,'2980','454',215290.24,215290.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257641',4906741,'2981','454',226313.92,230523.91,4209.99,694648.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257641',4906742,'2982','454',209865.14,209865.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257641',4906743,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257641',4906744,'2984','454',208490.75,208490.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257641',4906745,'2985','455',276941.92,278705.60,1763.68,1234576.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257641',4906746,'2986','455',126907.75,126907.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257641',4906747,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257641',4906748,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257642',4906749,'2961','454',320175.68,320175.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257642',4906750,'2962','454',395402.12,398331.09,2928.97,483280.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257642',4906751,'2963','454',198250.00,198250.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257642',4906752,'2964','454',373502.65,375506.04,2003.39,330559.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257642',4906753,'2965','454',211626.23,211626.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257642',4906754,'2966','454',411819.26,419539.48,7720.22,1273836.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257642',4906755,'2967','454',230530.58,230530.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257642',4906756,'2968','454',308442.64,310680.01,2237.37,369166.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257642',4906757,'2969','454',205442.74,205442.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257642',4906758,'2970','454',338176.65,346339.90,8163.25,1346936.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257642',4906759,'2971','454',333539.99,333539.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257642',4906760,'2972','454',220717.20,222539.17,1801.97,297325.05,0.00,0.00,20.00,0.00,0.00),('1','122','1006','257642',4906761,'2973','454',108660.46,108660.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257642',4906762,'2974','454',200106.98,200106.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257642',4906763,'2975','454',147559.84,148098.01,538.17,88798.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257642',4906764,'2976','454',181480.58,182389.58,909.00,149985.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257642',4906765,'2977','454',163938.35,163938.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257642',4906766,'2978','454',267978.92,267978.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257642',4906767,'2979','454',172864.84,172864.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257642',4906768,'2980','454',215290.24,216721.31,1431.07,236126.55,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257642',4906769,'2981','454',230523.91,230523.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257642',4906770,'2982','454',209865.14,209865.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257642',4906771,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257642',4906772,'2984','454',208490.75,208490.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257642',4906773,'2985','455',278705.60,278782.74,77.14,53998.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257642',4906774,'2986','455',126907.75,126907.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257642',4906775,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257642',4906776,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257643',4906777,'2961','454',320175.68,320175.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257643',4906778,'2962','454',398331.09,398331.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257643',4906779,'2963','454',198250.00,198250.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257643',4906780,'2964','454',375506.04,375506.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257643',4906781,'2965','454',211626.23,211626.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257643',4906782,'2966','454',419539.48,422679.09,3139.61,518035.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257643',4906783,'2967','454',230530.58,230530.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257643',4906784,'2968','454',310680.01,310680.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257643',4906785,'2969','454',205442.74,205442.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257643',4906786,'2970','454',346339.90,349353.22,3013.32,497197.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257643',4906787,'2971','454',333539.99,333539.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257643',4906788,'2972','454',222539.17,222539.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257643',4906789,'2973','454',108660.46,108660.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257643',4906790,'2974','454',200106.98,200106.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257643',4906791,'2975','454',148098.01,153080.54,4982.53,822117.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257643',4906792,'2976','454',182389.58,182389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257643',4906793,'2977','454',163938.35,163938.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257643',4906794,'2978','454',267978.92,267978.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257643',4906795,'2979','454',172864.84,181417.57,8552.73,1411200.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257643',4906796,'2980','454',216721.31,216721.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257643',4906797,'2981','454',230523.91,230523.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257643',4906798,'2982','454',209865.14,216092.14,6227.00,1027455.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257643',4906799,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257643',4906800,'2984','454',208490.75,208490.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257643',4906801,'2985','455',278782.74,280026.98,1244.24,870968.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257643',4906802,'2986','455',126907.75,129807.75,2900.00,2030000.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257643',4906803,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257643',4906804,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257644',4906805,'2961','454',320175.68,320175.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257644',4906806,'2962','454',398331.09,400270.23,1939.14,319958.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257644',4906807,'2963','454',198250.00,198250.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257644',4906808,'2964','454',375506.04,384465.71,8959.67,1478345.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257644',4906809,'2965','454',211626.23,211626.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257644',4906810,'2966','454',422679.09,422679.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257644',4906811,'2967','454',230530.58,230530.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257644',4906812,'2968','454',310680.01,310680.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257644',4906813,'2969','454',205442.74,205442.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257644',4906814,'2970','454',349353.22,353377.37,4024.15,663984.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257644',4906815,'2971','454',333539.99,333539.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257644',4906816,'2972','454',222539.17,226235.98,3696.81,609973.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257644',4906817,'2973','454',108660.46,108660.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257644',4906818,'2974','454',200106.98,200106.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257644',4906819,'2975','454',153080.54,153080.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257644',4906820,'2976','454',182389.58,190285.40,7895.82,1302810.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257644',4906821,'2977','454',163938.35,163938.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257644',4906822,'2978','454',267978.92,268486.96,508.04,83826.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257644',4906823,'2979','454',181417.57,181417.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257644',4906824,'2980','454',216721.31,216721.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257644',4906825,'2981','454',230523.91,230523.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257644',4906826,'2982','454',216092.14,216092.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257644',4906827,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257644',4906828,'2984','454',208490.75,209683.71,1192.96,196838.40,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257644',4906829,'2985','455',280026.98,282721.61,2694.63,1886241.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257644',4906830,'2986','455',129807.75,130507.64,699.89,489923.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257644',4906831,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257644',4906832,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257645',4906833,'2961','454',320175.68,322429.04,2253.36,371804.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257645',4906834,'2962','454',400270.23,400270.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257645',4906835,'2963','454',198250.00,198250.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257645',4906836,'2964','454',384465.71,384465.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257645',4906837,'2965','454',211626.23,211626.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257645',4906838,'2966','454',422679.09,422679.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257645',4906839,'2967','454',230530.58,230530.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257645',4906840,'2968','454',310680.01,321632.65,10952.64,1807185.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257645',4906841,'2969','454',205442.74,205442.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257645',4906842,'2970','454',353377.37,355929.04,2551.67,421025.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257645',4906843,'2971','454',333539.99,333539.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257645',4906844,'2972','454',226235.98,226235.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257645',4906845,'2973','454',108660.46,108660.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257645',4906846,'2974','454',200106.98,200106.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257645',4906847,'2975','454',153080.54,155965.37,2884.83,475996.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257645',4906848,'2976','454',190285.40,190285.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257645',4906849,'2977','454',163938.35,165607.06,1668.71,275337.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257645',4906850,'2978','454',268486.96,268486.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257645',4906851,'2979','454',181417.57,181417.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257645',4906852,'2980','454',216721.31,227321.95,10600.64,1749105.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257645',4906853,'2981','454',230523.91,230523.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257645',4906854,'2982','454',216092.14,224698.68,8606.54,1420079.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257645',4906855,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257645',4906856,'2984','454',209683.71,209683.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257645',4906857,'2985','455',282721.61,285733.28,3011.67,2108169.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257645',4906858,'2986','455',130507.64,133207.64,2688.00,1881600.00,0.00,0.00,12.00,0.00,0.00),('1','122','1007','257645',4906859,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257645',4906860,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257646',4906861,'2961','454',322429.04,322429.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257646',4906862,'2962','454',400270.23,402271.27,2001.04,330171.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257646',4906863,'2963','454',198250.00,198999.22,749.22,123621.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257646',4906864,'2964','454',384465.71,385777.58,1311.87,216458.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257646',4906865,'2965','454',211626.23,213106.82,1480.59,244297.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257646',4906866,'2966','454',422679.09,422679.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257646',4906867,'2967','454',230530.58,230530.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257646',4906868,'2968','454',321632.65,324602.43,2969.78,490013.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257646',4906869,'2969','454',205442.74,211477.75,6035.01,995776.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257646',4906870,'2970','454',355929.04,355929.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257646',4906871,'2971','454',333539.99,334948.27,1408.28,232366.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257646',4906872,'2972','454',226235.98,226235.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257646',4906873,'2973','454',108660.46,108660.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257646',4906874,'2974','454',200106.98,208637.74,8530.76,1407575.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257646',4906875,'2975','454',155965.37,155965.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257646',4906876,'2976','454',190285.40,190285.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257646',4906877,'2977','454',165607.06,165607.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257646',4906878,'2978','454',268486.96,268486.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257646',4906879,'2979','454',181417.57,182605.22,1187.65,195962.25,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257646',4906880,'2980','454',227321.95,227321.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257646',4906881,'2981','454',230523.91,230523.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257646',4906882,'2982','454',224698.68,225830.47,1131.79,186745.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257646',4906883,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257646',4906884,'2984','454',209683.71,209683.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257646',4906885,'2985','455',285733.28,286556.26,807.98,565586.00,0.00,0.00,15.00,0.00,0.00),('1','122','1007','257646',4906886,'2986','455',133207.64,133207.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257646',4906887,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257646',4906888,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257647',4906889,'2961','454',322429.04,322429.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257647',4906890,'2962','454',402271.27,402271.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257647',4906891,'2963','454',198999.22,198999.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257647',4906892,'2964','454',385777.58,385777.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257647',4906893,'2965','454',213106.82,213106.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257647',4906894,'2966','454',422679.09,422679.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257647',4906895,'2967','454',230530.58,236284.87,5754.29,949457.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257647',4906896,'2968','454',324602.43,324602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257647',4906897,'2969','454',211477.75,211477.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257647',4906898,'2970','454',355929.04,355929.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257647',4906899,'2971','454',334948.27,334948.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257647',4906900,'2972','454',226235.98,226235.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257647',4906901,'2973','454',108660.46,108660.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257647',4906902,'2974','454',208637.74,208637.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257647',4906903,'2975','454',155965.37,155965.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257647',4906904,'2976','454',190285.40,190285.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257647',4906905,'2977','454',165607.06,165607.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257647',4906906,'2978','454',268486.96,268486.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257647',4906907,'2979','454',182605.22,182605.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257647',4906908,'2980','454',227321.95,232309.94,4987.99,823018.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257647',4906909,'2981','454',230523.91,230523.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257647',4906910,'2982','454',225830.47,225830.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257647',4906911,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257647',4906912,'2984','454',209683.71,209683.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257647',4906913,'2985','455',286556.26,287528.83,972.57,680799.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257647',4906914,'2986','455',133207.64,135421.77,2214.13,1549891.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257647',4906915,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257647',4906916,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257648',4906917,'2961','454',322429.04,322429.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257648',4906918,'2962','454',402271.27,402271.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257648',4906919,'2963','454',198999.22,198999.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257648',4906920,'2964','454',385777.58,390032.12,4254.54,701999.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257648',4906921,'2965','454',213106.82,213106.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257648',4906922,'2966','454',422679.09,423914.03,1234.94,203765.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257648',4906923,'2967','454',236284.87,236284.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257648',4906924,'2968','454',324602.43,324602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257648',4906925,'2969','454',211477.75,211477.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257648',4906926,'2970','454',355929.04,359615.27,3686.23,608227.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257648',4906927,'2971','454',334948.27,334948.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257648',4906928,'2972','454',226235.98,227366.56,1130.58,186545.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257648',4906929,'2973','454',108660.46,108660.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257648',4906930,'2974','454',208637.74,208637.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257648',4906931,'2975','454',155965.37,155965.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257648',4906932,'2976','454',190285.40,190285.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257648',4906933,'2977','454',165607.06,165607.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257648',4906934,'2978','454',268486.96,269812.10,1325.14,218648.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257648',4906935,'2979','454',182605.22,182605.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257648',4906936,'2980','454',232309.94,232309.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257648',4906937,'2981','454',230523.91,236079.00,5555.09,916589.85,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257648',4906938,'2982','454',225830.47,225830.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257648',4906939,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257648',4906940,'2984','454',209683.71,209683.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257648',4906941,'2985','455',287528.83,290798.69,3269.86,2288902.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257648',4906942,'2986','455',135421.77,136247.68,825.91,578137.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257648',4906943,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257648',4906944,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257649',4906945,'2961','454',322429.04,322429.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257649',4906946,'2962','454',402271.27,407148.66,4877.39,804769.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257649',4906947,'2963','454',198999.22,198999.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257649',4906948,'2964','454',390032.12,390032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257649',4906949,'2965','454',213106.82,213106.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257649',4906950,'2966','454',423914.03,423914.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257649',4906951,'2967','454',236284.87,236284.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257649',4906952,'2968','454',324602.43,329573.28,4970.85,820190.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257649',4906953,'2969','454',211477.75,211477.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257649',4906954,'2970','454',359615.27,359615.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257649',4906955,'2971','454',334948.27,334948.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257649',4906956,'2972','454',227366.56,227366.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257649',4906957,'2973','454',108660.46,108660.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257649',4906958,'2974','454',208637.74,208637.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257649',4906959,'2975','454',155965.37,155965.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257649',4906960,'2976','454',190285.40,194990.95,4705.55,776414.93,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257649',4906961,'2977','454',165607.06,168931.10,3324.04,548466.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257649',4906962,'2978','454',269812.10,269812.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257649',4906963,'2979','454',182605.22,182605.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257649',4906964,'2980','454',232309.94,232309.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257649',4906965,'2981','454',236079.00,236079.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257649',4906966,'2982','454',225830.47,225830.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257649',4906967,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257649',4906968,'2984','454',209683.71,209683.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257649',4906969,'2985','455',290798.69,292547.00,1748.31,1223817.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257649',4906970,'2986','455',136247.68,137084.83,837.15,586005.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257649',4906971,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257649',4906972,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257650',4906973,'2961','454',322429.04,322429.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257650',4906974,'2962','454',407148.66,407148.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257650',4906975,'2963','454',198999.22,206084.35,7085.13,1169046.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257650',4906976,'2964','454',390032.12,390032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257650',4906977,'2965','454',213106.82,213106.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257650',4906978,'2966','454',423914.03,423914.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257650',4906979,'2967','454',236284.87,236284.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257650',4906980,'2968','454',329573.28,329573.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257650',4906981,'2969','454',211477.75,211477.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257650',4906982,'2970','454',359615.27,363117.90,3502.63,577933.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257650',4906983,'2971','454',334948.27,334948.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257650',4906984,'2972','454',227366.56,227366.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257650',4906985,'2973','454',108660.46,108660.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257650',4906986,'2974','454',208637.74,208637.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257650',4906987,'2975','454',155965.37,155965.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257650',4906988,'2976','454',194990.95,194990.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257650',4906989,'2977','454',168931.10,168931.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257650',4906990,'2978','454',269812.10,269812.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257650',4906991,'2979','454',182605.22,182605.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257650',4906992,'2980','454',232309.94,237185.71,4875.77,804502.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257650',4906993,'2981','454',236079.00,240797.75,4718.75,778593.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257650',4906994,'2982','454',225830.47,225830.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257650',4906995,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257650',4906996,'2984','454',209683.71,209683.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257650',4906997,'2985','455',292547.00,294984.24,2437.24,1706068.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257650',4906998,'2986','455',137084.83,137084.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257650',4906999,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257650',4907000,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257651',4907001,'2961','454',322429.04,322429.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257651',4907002,'2962','454',407148.66,409959.28,2810.62,463752.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257651',4907003,'2963','454',206084.35,206084.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257651',4907004,'2964','454',390032.12,390032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257651',4907005,'2965','454',213106.82,213106.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257651',4907006,'2966','454',423914.03,428946.94,5032.91,830430.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257651',4907007,'2967','454',236284.87,236284.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257651',4907008,'2968','454',329573.28,329573.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257651',4907009,'2969','454',211477.75,211477.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257651',4907010,'2970','454',363117.90,363117.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257651',4907011,'2971','454',334948.27,340418.23,5469.96,902543.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257651',4907012,'2972','454',227366.56,227366.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257651',4907013,'2973','454',108660.46,112228.57,3568.11,588738.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257651',4907014,'2974','454',208637.74,208637.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257651',4907015,'2975','454',155965.37,155965.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257651',4907016,'2976','454',194990.95,194990.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257651',4907017,'2977','454',168931.10,168931.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257651',4907018,'2978','454',269812.10,269812.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257651',4907019,'2979','454',182605.22,182605.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257651',4907020,'2980','454',237185.71,237185.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257651',4907021,'2981','454',240797.75,240797.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257651',4907022,'2982','454',225830.47,225830.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257651',4907023,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257651',4907024,'2984','454',209683.71,213913.01,4229.30,697834.50,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257651',4907025,'2985','455',294984.24,294984.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257651',4907026,'2986','455',137084.83,137084.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257651',4907027,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257651',4907028,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257652',4907029,'2961','454',322429.04,322429.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257652',4907030,'2962','454',409959.28,415257.19,5297.91,874155.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257652',4907031,'2963','454',206084.35,206084.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257652',4907032,'2964','454',390032.12,390032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257652',4907033,'2965','454',213106.82,213106.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257652',4907034,'2966','454',428946.94,432236.78,3289.84,542823.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257652',4907035,'2967','454',236284.87,236284.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257652',4907036,'2968','454',329573.28,329573.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257652',4907037,'2969','454',211477.75,211477.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257652',4907038,'2970','454',363117.90,369464.28,6346.38,1047152.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257652',4907039,'2971','454',340418.23,340418.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257652',4907040,'2972','454',227366.56,227366.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257652',4907041,'2973','454',112228.57,112228.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257652',4907042,'2974','454',208637.74,208637.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257652',4907043,'2975','454',155965.37,155965.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257652',4907044,'2976','454',194990.95,198894.06,3903.11,644013.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257652',4907045,'2977','454',168931.10,168931.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257652',4907046,'2978','454',269812.10,274919.61,5107.51,842739.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257652',4907047,'2979','454',182605.22,182605.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257652',4907048,'2980','454',237185.71,237234.19,48.48,7999.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257652',4907049,'2981','454',240797.75,240797.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257652',4907050,'2982','454',225830.47,228012.50,2182.03,360034.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257652',4907051,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257652',4907052,'2984','454',213913.01,213913.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257652',4907053,'2985','455',294984.24,297381.12,2386.88,1670816.00,0.00,0.00,10.00,0.00,0.00),('1','122','1007','257652',4907054,'2986','455',137084.83,139595.66,2510.83,1757581.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257652',4907055,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257652',4907056,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257653',4907057,'2961','454',322429.04,322429.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257653',4907058,'2962','454',415257.19,419366.01,4108.82,677955.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257653',4907059,'2963','454',206084.35,206084.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257653',4907060,'2964','454',390032.12,390032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257653',4907061,'2965','454',213106.82,213106.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257653',4907062,'2966','454',432236.78,432236.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257653',4907063,'2967','454',236284.87,236284.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257653',4907064,'2968','454',329573.28,329573.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257653',4907065,'2969','454',211477.75,211477.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257653',4907066,'2970','454',369464.28,373995.62,4531.34,747671.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257653',4907067,'2971','454',340418.23,340418.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257653',4907068,'2972','454',227366.56,227366.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257653',4907069,'2973','454',112228.57,112228.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257653',4907070,'2974','454',208637.74,212276.44,3638.70,600385.50,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257653',4907071,'2975','454',155965.37,155965.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257653',4907072,'2976','454',198894.06,198894.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257653',4907073,'2977','454',168931.10,168931.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257653',4907074,'2978','454',274919.61,274919.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257653',4907075,'2979','454',182605.22,182605.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257653',4907076,'2980','454',237234.19,237234.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257653',4907077,'2981','454',240797.75,240797.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257653',4907078,'2982','454',228012.50,231989.79,3977.29,656252.85,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257653',4907079,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257653',4907080,'2984','454',213913.01,213913.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257653',4907081,'2985','455',297381.12,297381.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257653',4907082,'2986','455',139595.66,139595.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257653',4907083,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257653',4907084,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257654',4907085,'2961','454',322429.04,322429.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257654',4907086,'2962','454',419366.01,423950.50,4584.49,756440.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257654',4907087,'2963','454',206084.35,206084.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257654',4907088,'2964','454',390032.12,390032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257654',4907089,'2965','454',213106.82,213106.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257654',4907090,'2966','454',432236.78,437292.24,5055.46,834150.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257654',4907091,'2967','454',236284.87,236284.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257654',4907092,'2968','454',329573.28,329573.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257654',4907093,'2969','454',211477.75,211477.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257654',4907094,'2970','454',373995.62,373995.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257654',4907095,'2971','454',340418.23,340418.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257654',4907096,'2972','454',227366.56,229817.42,2450.86,404391.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257654',4907097,'2973','454',112228.57,112228.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257654',4907098,'2974','454',212276.44,212276.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257654',4907099,'2975','454',155965.37,161777.74,5812.37,959041.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257654',4907100,'2976','454',198894.06,198894.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257654',4907101,'2977','454',168931.10,168931.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257654',4907102,'2978','454',274919.61,274919.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257654',4907103,'2979','454',182605.22,182605.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257654',4907104,'2980','454',237234.19,242445.01,5210.82,859785.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257654',4907105,'2981','454',240797.75,240797.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257654',4907106,'2982','454',231989.79,231989.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257654',4907107,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257654',4907108,'2984','454',213913.01,213913.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257654',4907109,'2985','455',297381.12,298207.61,811.49,568043.00,0.00,0.00,15.00,0.00,0.00),('1','122','1007','257654',4907110,'2986','455',139595.66,139824.24,228.58,160006.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257654',4907111,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257654',4907112,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257655',4907113,'2961','454',322429.04,322429.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257655',4907114,'2962','454',423950.50,429079.82,5129.32,846337.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257655',4907115,'2963','454',206084.35,206084.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257655',4907116,'2964','454',390032.12,390032.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257655',4907117,'2965','454',213106.82,216110.38,3003.56,495587.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257655',4907118,'2966','454',437292.24,437292.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257655',4907119,'2967','454',236284.87,236284.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257655',4907120,'2968','454',329573.28,329573.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257655',4907121,'2969','454',211477.75,211477.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257655',4907122,'2970','454',373995.62,373995.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257655',4907123,'2971','454',340418.23,340418.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257655',4907124,'2972','454',229817.42,234312.65,4495.23,741712.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257655',4907125,'2973','454',112228.57,112228.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257655',4907126,'2974','454',212276.44,212276.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257655',4907127,'2975','454',161777.74,161777.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257655',4907128,'2976','454',198894.06,198894.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257655',4907129,'2977','454',168931.10,168931.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257655',4907130,'2978','454',274919.61,274954.76,35.15,5799.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257655',4907131,'2979','454',182605.22,182605.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257655',4907132,'2980','454',242445.01,242445.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257655',4907133,'2981','454',240797.75,240797.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257655',4907134,'2982','454',231989.79,231989.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257655',4907135,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257655',4907136,'2984','454',213913.01,213913.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257655',4907137,'2985','455',298207.61,298207.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257655',4907138,'2986','455',139824.24,139824.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257655',4907139,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257655',4907140,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257656',4907141,'2961','454',322429.04,327273.12,4844.08,799273.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257656',4907142,'2962','454',429079.82,429079.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257656',4907143,'2963','454',206084.35,206084.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257656',4907144,'2964','454',390032.12,394825.44,4793.32,790897.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257656',4907145,'2965','454',216110.38,216110.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257656',4907146,'2966','454',437292.24,437292.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257656',4907147,'2967','454',236284.87,238480.20,2195.33,362229.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257656',4907148,'2968','454',329573.28,329573.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257656',4907149,'2969','454',211477.75,211477.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257656',4907150,'2970','454',373995.62,378010.07,4014.45,662384.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257656',4907151,'2971','454',340418.23,340418.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257656',4907152,'2972','454',234312.65,234377.46,64.81,10693.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257656',4907153,'2973','454',112228.57,112228.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257656',4907154,'2974','454',212276.44,212276.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257656',4907155,'2975','454',161777.74,161777.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257656',4907156,'2976','454',198894.06,198894.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257656',4907157,'2977','454',168931.10,168931.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257656',4907158,'2978','454',274954.76,274954.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257656',4907159,'2979','454',182605.22,182605.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257656',4907160,'2980','454',242445.01,242445.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257656',4907161,'2981','454',240797.75,240797.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257656',4907162,'2982','454',231989.79,231989.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257656',4907163,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257656',4907164,'2984','454',213913.01,213913.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257656',4907165,'2985','455',298207.61,298207.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257656',4907166,'2986','455',139824.24,139824.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257656',4907167,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257656',4907168,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257657',4907169,'2961','454',327273.12,327273.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257657',4907170,'2962','454',429079.82,429079.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257657',4907171,'2963','454',206084.35,206084.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257657',4907172,'2964','454',394825.44,394825.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257657',4907173,'2965','454',216110.38,216110.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257657',4907174,'2966','454',437292.24,437292.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257657',4907175,'2967','454',238480.20,238480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257657',4907176,'2968','454',329573.28,329573.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257657',4907177,'2969','454',211477.75,211477.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257657',4907178,'2970','454',378010.07,378010.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257657',4907179,'2971','454',340418.23,340418.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257657',4907180,'2972','454',234377.46,234377.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257657',4907181,'2973','454',112228.57,112228.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257657',4907182,'2974','454',212276.44,216395.18,4118.74,679592.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257657',4907183,'2975','454',161777.74,161777.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257657',4907184,'2976','454',198894.06,198894.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257657',4907185,'2977','454',168931.10,168931.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257657',4907186,'2978','454',274954.76,279750.48,4795.72,791293.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257657',4907187,'2979','454',182605.22,182605.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257657',4907188,'2980','454',242445.01,246369.35,3924.34,647516.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257657',4907189,'2981','454',240797.75,240797.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257657',4907190,'2982','454',231989.79,238164.51,6174.72,1018828.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257657',4907191,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257657',4907192,'2984','454',213913.01,218199.00,4285.99,707188.35,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257657',4907193,'2985','455',298207.61,298771.19,563.58,394506.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257657',4907194,'2986','455',139824.24,140285.39,461.15,322805.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257657',4907195,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257657',4907196,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257658',4907197,'2961','454',327273.12,327273.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257658',4907198,'2962','454',429079.82,429079.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257658',4907199,'2963','454',206084.35,206084.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257658',4907200,'2964','454',394825.44,394825.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257658',4907201,'2965','454',216110.38,216110.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257658',4907202,'2966','454',437292.24,437292.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257658',4907203,'2967','454',238480.20,238480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257658',4907204,'2968','454',329573.28,329573.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257658',4907205,'2969','454',211477.75,211477.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257658',4907206,'2970','454',378010.07,378010.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257658',4907207,'2971','454',340418.23,340418.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257658',4907208,'2972','454',234377.46,234377.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257658',4907209,'2973','454',112228.57,112420.65,192.08,31693.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257658',4907210,'2974','454',216395.18,216395.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257658',4907211,'2975','454',161777.74,163997.76,2220.02,366303.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257658',4907212,'2976','454',198894.06,201679.88,2785.82,459660.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257658',4907213,'2977','454',168931.10,170567.68,1636.58,270035.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257658',4907214,'2978','454',279750.48,281295.42,1544.94,254915.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257658',4907215,'2979','454',182605.22,184244.03,1638.81,270403.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257658',4907216,'2980','454',246369.35,249547.04,3177.69,524318.85,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257658',4907217,'2981','454',240797.75,240797.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257658',4907218,'2982','454',238164.51,238164.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257658',4907219,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257658',4907220,'2984','454',218199.00,221811.12,3612.12,595999.80,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257658',4907221,'2985','455',298771.19,302018.12,3246.93,2272851.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257658',4907222,'2986','455',140285.39,140285.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257658',4907223,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257658',4907224,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257659',4907225,'2961','454',327273.12,327273.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257659',4907226,'2962','454',429079.82,433132.64,4052.82,668715.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257659',4907227,'2963','454',206084.35,206084.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257659',4907228,'2964','454',394825.44,399311.17,4485.73,740145.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257659',4907229,'2965','454',216110.38,216110.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257659',4907230,'2966','454',437292.24,437292.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257659',4907231,'2967','454',238480.20,238480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257659',4907232,'2968','454',329573.28,329573.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257659',4907233,'2969','454',211477.75,211477.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257659',4907234,'2970','454',378010.07,382214.14,4204.07,693671.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257659',4907235,'2971','454',340418.23,340418.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257659',4907236,'2972','454',234377.46,234377.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257659',4907237,'2973','454',112420.65,112420.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257659',4907238,'2974','454',216395.18,220653.42,4258.24,702609.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257659',4907239,'2975','454',163997.76,163997.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257659',4907240,'2976','454',201679.88,201679.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257659',4907241,'2977','454',170567.68,170567.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257659',4907242,'2978','454',281295.42,281295.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257659',4907243,'2979','454',184244.03,184244.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257659',4907244,'2980','454',249547.04,249547.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257659',4907245,'2981','454',240797.75,244981.88,4184.13,690381.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257659',4907246,'2982','454',238164.51,238164.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257659',4907247,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257659',4907248,'2984','454',221811.12,221811.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257659',4907249,'2985','455',302018.12,302707.91,689.79,482853.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257659',4907250,'2986','455',140285.39,140285.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257659',4907251,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257659',4907252,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257660',4907253,'2961','454',327273.12,333307.70,6034.58,995705.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257660',4907254,'2962','454',433132.64,433132.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257660',4907255,'2963','454',206084.35,207503.75,1419.40,234201.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257660',4907256,'2964','454',399311.17,399311.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257660',4907257,'2965','454',216110.38,216110.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257660',4907258,'2966','454',437292.24,442569.28,5277.04,870711.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257660',4907259,'2967','454',238480.20,238480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257660',4907260,'2968','454',329573.28,333931.70,4358.42,719139.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257660',4907261,'2969','454',211477.75,211477.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257660',4907262,'2970','454',382214.14,382214.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257660',4907263,'2971','454',340418.23,346009.10,5590.87,922493.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257660',4907264,'2972','454',234377.46,234377.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257660',4907265,'2973','454',112420.65,112420.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257660',4907266,'2974','454',220653.42,220653.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257660',4907267,'2975','454',163997.76,164731.20,733.44,121017.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257660',4907268,'2976','454',201679.88,201679.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257660',4907269,'2977','454',170567.68,170567.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257660',4907270,'2978','454',281295.42,281295.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257660',4907271,'2979','454',184244.03,184244.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257660',4907272,'2980','454',249547.04,249547.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257660',4907273,'2981','454',244981.88,244981.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257660',4907274,'2982','454',238164.51,238164.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257660',4907275,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257660',4907276,'2984','454',221811.12,221811.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257660',4907277,'2985','455',302707.91,305161.75,2453.84,1717688.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257660',4907278,'2986','455',140285.39,140626.94,341.55,239085.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257660',4907279,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257660',4907280,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257661',4907281,'2961','454',333307.70,333307.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257661',4907282,'2962','454',433132.64,433132.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257661',4907283,'2963','454',207503.75,207503.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257661',4907284,'2964','454',399311.17,399311.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257661',4907285,'2965','454',216110.38,216110.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257661',4907286,'2966','454',442569.28,445132.68,2563.40,422961.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257661',4907287,'2967','454',238480.20,238480.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257661',4907288,'2968','454',333931.70,333931.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257661',4907289,'2969','454',211477.75,213385.62,1907.87,314798.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257661',4907290,'2970','454',382214.14,382214.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257661',4907291,'2971','454',346009.10,346009.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257661',4907292,'2972','454',234377.46,234377.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257661',4907293,'2973','454',112420.65,113473.49,1052.84,173718.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257661',4907294,'2974','454',220653.42,220653.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257661',4907295,'2975','454',164731.20,164731.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257661',4907296,'2976','454',201679.88,205479.54,3799.66,626943.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257661',4907297,'2977','454',170567.68,170567.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257661',4907298,'2978','454',281295.42,284051.17,2755.75,454698.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257661',4907299,'2979','454',184244.03,184244.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257661',4907300,'2980','454',249547.04,252696.10,3149.06,519594.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257661',4907301,'2981','454',244981.88,245709.80,727.92,120106.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257661',4907302,'2982','454',238164.51,238164.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257661',4907303,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257661',4907304,'2984','454',221811.12,225118.52,3307.40,545721.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257661',4907305,'2985','455',305161.75,306617.75,1456.00,1019200.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257661',4907306,'2986','455',140626.94,140904.79,277.85,194495.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257661',4907307,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257661',4907308,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257662',4907309,'2961','454',333307.70,333307.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257662',4907310,'2962','454',433132.64,435029.90,1897.26,313047.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257662',4907311,'2963','454',207503.75,207503.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257662',4907312,'2964','454',399311.17,399311.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257662',4907313,'2965','454',216110.38,216110.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257662',4907314,'2966','454',445132.68,446979.98,1847.30,304804.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257662',4907315,'2967','454',238480.20,241062.07,2581.87,426008.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257662',4907316,'2968','454',333931.70,333931.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257662',4907317,'2969','454',213385.62,213385.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257662',4907318,'2970','454',382214.14,382214.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257662',4907319,'2971','454',346009.10,346009.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257662',4907320,'2972','454',234377.46,236237.42,1859.96,306893.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257662',4907321,'2973','454',113473.49,113473.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257662',4907322,'2974','454',220653.42,222480.85,1827.43,301525.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257662',4907323,'2975','454',164731.20,168294.61,3563.41,587962.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257662',4907324,'2976','454',205479.54,205479.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257662',4907325,'2977','454',170567.68,173850.07,3282.39,541594.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257662',4907326,'2978','454',284051.17,284051.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257662',4907327,'2979','454',184244.03,187397.94,3138.91,517920.15,0.00,0.00,15.00,0.00,0.00),('1','122','1006','257662',4907328,'2980','454',252696.10,252696.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257662',4907329,'2981','454',245709.80,245709.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257662',4907330,'2982','454',238164.51,241558.31,3393.80,559977.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257662',4907331,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257662',4907332,'2984','454',225118.52,225118.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257662',4907333,'2985','455',306617.75,307790.51,1172.76,820932.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257662',4907334,'2986','455',140904.79,140904.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257662',4907335,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257662',4907336,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257663',4907337,'2961','454',333307.70,333307.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257663',4907338,'2962','454',435029.90,439896.99,4867.09,803069.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257663',4907339,'2963','454',207503.75,207503.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257663',4907340,'2964','454',399311.17,399311.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257663',4907341,'2965','454',216110.38,219683.43,3573.05,589553.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257663',4907342,'2966','454',446979.98,446979.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257663',4907343,'2967','454',241062.07,244630.81,3568.74,588842.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257663',4907344,'2968','454',333931.70,333931.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257663',4907345,'2969','454',213385.62,213385.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257663',4907346,'2970','454',382214.14,385085.55,2871.41,473782.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257663',4907347,'2971','454',346009.10,350669.18,4660.08,768913.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257663',4907348,'2972','454',236237.42,236237.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257663',4907349,'2973','454',113473.49,113473.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257663',4907350,'2974','454',222480.85,222480.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257663',4907351,'2975','454',168294.61,168294.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257663',4907352,'2976','454',205479.54,205479.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257663',4907353,'2977','454',173850.07,173850.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257663',4907354,'2978','454',284051.17,284051.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257663',4907355,'2979','454',187397.94,187397.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257663',4907356,'2980','454',252696.10,252696.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257663',4907357,'2981','454',245709.80,245709.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257663',4907358,'2982','454',241558.31,241558.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257663',4907359,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257663',4907360,'2984','454',225118.52,225118.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257663',4907361,'2985','455',307790.51,308266.05,475.54,332878.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257663',4907362,'2986','455',140904.79,140904.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257663',4907363,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257663',4907364,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257664',4907365,'2961','454',333307.70,333307.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257664',4907366,'2962','454',439896.99,442726.00,2829.01,466786.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257664',4907367,'2963','454',207503.75,207503.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257664',4907368,'2964','454',399311.17,401684.28,2373.11,391563.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257664',4907369,'2965','454',219683.43,221376.84,1673.41,276112.65,0.00,0.00,20.00,0.00,0.00),('1','122','1004','257664',4907370,'2966','454',446979.98,448661.46,1681.48,277444.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257664',4907371,'2967','454',244630.81,244630.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257664',4907372,'2968','454',333931.70,336213.44,2281.74,376487.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257664',4907373,'2969','454',213385.62,214291.43,905.81,149458.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257664',4907374,'2970','454',385085.55,386786.13,1700.58,280595.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257664',4907375,'2971','454',350669.18,353458.46,2789.28,460231.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257664',4907376,'2972','454',236237.42,236237.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257664',4907377,'2973','454',113473.49,113473.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257664',4907378,'2974','454',222480.85,224886.60,2405.75,396948.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257664',4907379,'2975','454',168294.61,168294.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257664',4907380,'2976','454',205479.54,207318.38,1838.84,303408.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257664',4907381,'2977','454',173850.07,173850.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257664',4907382,'2978','454',284051.17,286490.59,2439.42,402504.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257664',4907383,'2979','454',187397.94,187397.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257664',4907384,'2980','454',252696.10,253732.54,1036.44,171012.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257664',4907385,'2981','454',245709.80,245709.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257664',4907386,'2982','454',241558.31,243210.97,1652.66,272688.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257664',4907387,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257664',4907388,'2984','454',225118.52,228239.25,3120.73,514920.45,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257664',4907389,'2985','455',308266.05,313333.35,5067.30,3547110.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257664',4907390,'2986','455',140904.79,143996.79,3092.00,2164400.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257664',4907391,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257664',4907392,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257665',4907393,'2961','454',333307.70,333307.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257665',4907394,'2962','454',442726.00,445178.21,2442.21,402964.65,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257665',4907395,'2963','454',207503.75,207503.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257665',4907396,'2964','454',401684.28,401684.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257665',4907397,'2965','454',221376.84,221376.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257665',4907398,'2966','454',448661.46,451797.14,3105.68,512437.20,0.00,0.00,30.00,0.00,0.00),('1','122','1004','257665',4907399,'2967','454',244630.81,244630.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257665',4907400,'2968','454',336213.44,336213.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257665',4907401,'2969','454',214291.43,214291.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257665',4907402,'2970','454',386786.13,390307.20,3511.07,579326.55,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257665',4907403,'2971','454',353458.46,353458.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257665',4907404,'2972','454',236237.42,236237.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257665',4907405,'2973','454',113473.49,113473.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257665',4907406,'2974','454',224886.60,224886.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257665',4907407,'2975','454',168294.61,168294.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257665',4907408,'2976','454',207318.38,209869.24,2530.86,417591.90,0.00,0.00,20.00,0.00,0.00),('1','122','1006','257665',4907409,'2977','454',173850.07,173850.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257665',4907410,'2978','454',286490.59,288184.41,1693.82,279480.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257665',4907411,'2979','454',187397.94,187397.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257665',4907412,'2980','454',253732.54,256201.00,2448.46,403995.90,0.00,0.00,20.00,0.00,0.00),('1','122','1006','257665',4907413,'2981','454',245709.80,247433.78,1723.98,284456.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257665',4907414,'2982','454',243210.97,243210.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257665',4907415,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257665',4907416,'2984','454',228239.25,230951.34,2712.09,447494.85,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257665',4907417,'2985','455',313333.35,313333.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257665',4907418,'2986','455',143996.79,143996.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257665',4907419,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257665',4907420,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257666',4907421,'2961','454',333307.70,335369.63,2061.93,340218.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257666',4907422,'2962','454',445178.21,447468.48,2290.27,377894.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257666',4907423,'2963','454',207503.75,207503.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257666',4907424,'2964','454',401684.28,404756.60,3072.32,506932.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257666',4907425,'2965','454',221376.84,221376.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257666',4907426,'2966','454',451797.14,453959.28,2162.14,356753.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257666',4907427,'2967','454',244630.81,244630.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257666',4907428,'2968','454',336213.44,337098.87,885.43,146095.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257666',4907429,'2969','454',214291.43,217324.24,3032.81,500413.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257666',4907430,'2970','454',390307.20,391854.53,1527.33,252009.45,0.00,0.00,20.00,0.00,0.00),('1','122','1004','257666',4907431,'2971','454',353458.46,354920.89,1462.43,241300.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257666',4907432,'2972','454',236237.42,238352.65,2115.23,349012.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257666',4907433,'2973','454',113473.49,113473.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257666',4907434,'2974','454',224886.60,226059.60,1173.00,193545.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257666',4907435,'2975','454',168294.61,170152.40,1857.79,306535.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257666',4907436,'2976','454',209869.24,209869.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257666',4907437,'2977','454',173850.07,175652.90,1802.83,297466.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257666',4907438,'2978','454',288184.41,288184.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257666',4907439,'2979','454',187397.94,188783.51,1385.57,228619.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257666',4907440,'2980','454',256201.00,256201.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257666',4907441,'2981','454',247433.78,247433.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257666',4907442,'2982','454',243210.97,243210.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257666',4907443,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257666',4907444,'2984','454',230951.34,231042.24,90.90,14998.50,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257666',4907445,'2985','455',313333.35,314031.60,685.25,479675.00,0.00,0.00,13.00,0.00,0.00),('1','122','1007','257666',4907446,'2986','455',143996.79,144482.51,485.72,340004.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257666',4907447,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257666',4907448,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257667',4907449,'2961','454',335369.63,338529.75,3160.12,521419.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257667',4907450,'2962','454',447468.48,447468.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257667',4907451,'2963','454',207503.75,210567.43,3063.68,505507.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257667',4907452,'2964','454',404756.60,404756.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257667',4907453,'2965','454',221376.84,221376.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257667',4907454,'2966','454',453959.28,457096.96,3137.68,517716.54,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257667',4907455,'2967','454',244630.81,247610.03,2979.22,491571.96,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257667',4907456,'2968','454',337098.87,337098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257667',4907457,'2969','454',217324.24,217324.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257667',4907458,'2970','454',391854.53,394742.35,2887.82,476490.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257667',4907459,'2971','454',354920.89,357061.01,2140.12,353119.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257667',4907460,'2972','454',238352.65,238352.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257667',4907461,'2973','454',113473.49,113473.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257667',4907462,'2974','454',226059.60,226059.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257667',4907463,'2975','454',170152.40,170152.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257667',4907464,'2976','454',209869.24,209869.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257667',4907465,'2977','454',175652.90,175652.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257667',4907466,'2978','454',288184.41,288184.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257667',4907467,'2979','454',188783.51,188783.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257667',4907468,'2980','454',256201.00,256201.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257667',4907469,'2981','454',247433.78,247433.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257667',4907470,'2982','454',243210.97,243210.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257667',4907471,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257667',4907472,'2984','454',231042.24,231042.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257667',4907473,'2985','455',314031.60,314673.86,642.26,449582.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257667',4907474,'2986','455',144482.51,144482.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257667',4907475,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257667',4907476,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257668',4907477,'2961','454',338529.75,338529.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257668',4907478,'2962','454',447468.48,448503.68,1035.20,170808.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257668',4907479,'2963','454',210567.43,210567.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257668',4907480,'2964','454',404756.60,407784.40,3027.80,499587.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257668',4907481,'2965','454',221376.84,224107.63,2720.79,448930.35,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257668',4907482,'2966','454',457096.96,457716.99,620.03,102304.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257668',4907483,'2967','454',247610.03,250053.15,2443.12,403114.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257668',4907484,'2968','454',337098.87,340431.41,3332.54,549869.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257668',4907485,'2969','454',217324.24,219436.52,2112.28,348526.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257668',4907486,'2970','454',394742.35,396018.02,1275.67,210485.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257668',4907487,'2971','454',357061.01,358106.79,1045.78,172553.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257668',4907488,'2972','454',238352.65,240558.86,2206.21,364024.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257668',4907489,'2973','454',113473.49,113473.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257668',4907490,'2974','454',226059.60,226059.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257668',4907491,'2975','454',170152.40,170152.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257668',4907492,'2976','454',209869.24,209869.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257668',4907493,'2977','454',175652.90,175652.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257668',4907494,'2978','454',288184.41,288184.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257668',4907495,'2979','454',188783.51,188783.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257668',4907496,'2980','454',256201.00,256201.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257668',4907497,'2981','454',247433.78,247433.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257668',4907498,'2982','454',243210.97,243210.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257668',4907499,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257668',4907500,'2984','454',231042.24,231042.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257668',4907501,'2985','455',314673.86,315236.89,537.03,375921.00,0.00,0.00,26.00,0.00,0.00),('1','122','1007','257668',4907502,'2986','455',144482.51,144995.09,512.58,358806.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257668',4907503,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257668',4907504,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257669',4907505,'2961','454',338529.75,338529.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257669',4907506,'2962','454',448503.68,451930.68,3427.00,565455.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257669',4907507,'2963','454',210567.43,210567.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257669',4907508,'2964','454',407784.40,407784.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257669',4907509,'2965','454',224107.63,227909.05,3781.42,623934.30,0.00,0.00,20.00,0.00,0.00),('1','122','1004','257669',4907510,'2966','454',457716.99,457716.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257669',4907511,'2967','454',250053.15,250053.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257669',4907512,'2968','454',340431.41,340431.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257669',4907513,'2969','454',219436.52,219436.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257669',4907514,'2970','454',396018.02,396018.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257669',4907515,'2971','454',358106.79,358106.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257669',4907516,'2972','454',240558.86,245165.14,4606.28,760036.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257669',4907517,'2973','454',113473.49,113473.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257669',4907518,'2974','454',226059.60,226059.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257669',4907519,'2975','454',170152.40,170152.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257669',4907520,'2976','454',209869.24,209869.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257669',4907521,'2977','454',175652.90,175652.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257669',4907522,'2978','454',288184.41,288184.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257669',4907523,'2979','454',188783.51,188783.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257669',4907524,'2980','454',256201.00,256201.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257669',4907525,'2981','454',247433.78,247433.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257669',4907526,'2982','454',243210.97,243210.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257669',4907527,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257669',4907528,'2984','454',231042.24,231042.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257669',4907529,'2985','455',315236.89,315236.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257669',4907530,'2986','455',144995.09,144995.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257669',4907531,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257669',4907532,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257670',4907533,'2961','454',338529.75,342758.15,4228.40,697685.18,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257670',4907534,'2962','454',451930.68,451930.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257670',4907535,'2963','454',210567.43,210567.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257670',4907536,'2964','454',407784.40,408042.54,258.14,42593.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257670',4907537,'2965','454',227909.05,227909.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257670',4907538,'2966','454',457716.99,461677.47,3947.48,651334.20,0.00,0.00,13.00,0.00,0.00),('1','122','1004','257670',4907539,'2967','454',250053.15,250053.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257670',4907540,'2968','454',340431.41,340431.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257670',4907541,'2969','454',219436.52,219436.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257670',4907542,'2970','454',396018.02,396018.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257670',4907543,'2971','454',358106.79,363058.86,4922.07,812141.55,0.00,0.00,30.00,0.00,0.00),('1','122','1004','257670',4907544,'2972','454',245165.14,245165.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257670',4907545,'2973','454',113473.49,113473.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257670',4907546,'2974','454',226059.60,226059.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257670',4907547,'2975','454',170152.40,170152.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257670',4907548,'2976','454',209869.24,209869.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257670',4907549,'2977','454',175652.90,175652.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257670',4907550,'2978','454',288184.41,288184.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257670',4907551,'2979','454',188783.51,188783.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257670',4907552,'2980','454',256201.00,256201.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257670',4907553,'2981','454',247433.78,247433.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257670',4907554,'2982','454',243210.97,243210.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257670',4907555,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257670',4907556,'2984','454',231042.24,231042.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257670',4907557,'2985','455',315236.89,315638.86,401.97,281379.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257670',4907558,'2986','455',144995.09,144995.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257670',4907559,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257670',4907560,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257671',4907561,'2961','454',342758.15,342758.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257671',4907562,'2962','454',451930.68,455432.07,3501.39,577729.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257671',4907563,'2963','454',210567.43,210567.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257671',4907564,'2964','454',408042.54,410673.11,2630.57,434044.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257671',4907565,'2965','454',227909.05,230351.01,2441.96,402923.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257671',4907566,'2966','454',461677.47,461677.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257671',4907567,'2967','454',250053.15,250053.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257671',4907568,'2968','454',340431.41,342090.35,1658.94,273725.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257671',4907569,'2969','454',219436.52,219436.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257671',4907570,'2970','454',396018.02,398516.34,2498.32,412222.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257671',4907571,'2971','454',363058.86,363058.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257671',4907572,'2972','454',245165.14,247633.21,2468.07,407231.55,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257671',4907573,'2973','454',113473.49,113473.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257671',4907574,'2974','454',226059.60,226059.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257671',4907575,'2975','454',170152.40,170152.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257671',4907576,'2976','454',209869.24,209869.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257671',4907577,'2977','454',175652.90,175652.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257671',4907578,'2978','454',288184.41,288184.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257671',4907579,'2979','454',188783.51,188783.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257671',4907580,'2980','454',256201.00,256201.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257671',4907581,'2981','454',247433.78,247433.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257671',4907582,'2982','454',243210.97,243210.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257671',4907583,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257671',4907584,'2984','454',231042.24,231042.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257671',4907585,'2985','455',315638.86,315651.72,5.86,4102.00,0.00,0.00,7.00,0.00,0.00),('1','122','1007','257671',4907586,'2986','455',144995.09,145106.40,111.31,77917.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257671',4907587,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257671',4907588,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257672',4907589,'2961','454',342758.15,342758.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257672',4907590,'2962','454',455432.07,455432.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257672',4907591,'2963','454',210567.43,210567.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257672',4907592,'2964','454',410673.11,410673.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257672',4907593,'2965','454',230351.01,230351.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257672',4907594,'2966','454',461677.47,461677.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257672',4907595,'2967','454',250053.15,250053.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257672',4907596,'2968','454',342090.35,342090.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257672',4907597,'2969','454',219436.52,219436.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257672',4907598,'2970','454',398516.34,398516.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257672',4907599,'2971','454',363058.86,363058.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257672',4907600,'2972','454',247633.21,247633.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257672',4907601,'2973','454',113473.49,113473.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257672',4907602,'2974','454',226059.60,226059.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257672',4907603,'2975','454',170152.40,170152.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257672',4907604,'2976','454',209869.24,209869.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257672',4907605,'2977','454',175652.90,175652.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257672',4907606,'2978','454',288184.41,288184.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257672',4907607,'2979','454',188783.51,188783.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257672',4907608,'2980','454',256201.00,256201.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257672',4907609,'2981','454',247433.78,247433.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257672',4907610,'2982','454',243210.97,243210.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257672',4907611,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257672',4907612,'2984','454',231042.24,231042.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257672',4907613,'2985','455',315651.72,316099.49,447.77,313439.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257672',4907614,'2986','455',145106.40,145106.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257672',4907615,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257672',4907616,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257673',4907617,'2961','454',342758.15,342758.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257673',4907618,'2962','454',455432.07,455432.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257673',4907619,'2963','454',210567.43,210567.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257673',4907620,'2964','454',410673.11,410673.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257673',4907621,'2965','454',230351.01,230351.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257673',4907622,'2966','454',461677.47,461677.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257673',4907623,'2967','454',250053.15,250053.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257673',4907624,'2968','454',342090.35,342090.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257673',4907625,'2969','454',219436.52,219436.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257673',4907626,'2970','454',398516.34,398516.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257673',4907627,'2971','454',363058.86,363058.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257673',4907628,'2972','454',247633.21,247633.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257673',4907629,'2973','454',113473.49,113473.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257673',4907630,'2974','454',226059.60,228886.52,2826.92,466441.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257673',4907631,'2975','454',170152.40,170152.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257673',4907632,'2976','454',209869.24,213076.81,3207.57,529249.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257673',4907633,'2977','454',175652.90,177615.07,1962.17,323758.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257673',4907634,'2978','454',288184.41,290804.41,2620.00,432300.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257673',4907635,'2979','454',188783.51,188783.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257673',4907636,'2980','454',256201.00,258873.79,2642.79,436060.35,0.00,0.00,30.00,0.00,0.00),('1','122','1006','257673',4907637,'2981','454',247433.78,247433.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257673',4907638,'2982','454',243210.97,245528.70,2317.73,382425.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257673',4907639,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257673',4907640,'2984','454',231042.24,233195.20,2152.96,355238.40,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257673',4907641,'2985','455',316099.49,316297.00,187.31,131117.00,0.00,0.00,10.20,0.00,0.00),('1','122','1007','257673',4907642,'2986','455',145106.40,145119.40,0.00,0.00,0.00,0.00,13.00,0.00,0.00),('1','122','1007','257673',4907643,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257673',4907644,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257674',4907645,'2961','454',342758.15,342758.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257674',4907646,'2962','454',455432.07,455432.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257674',4907647,'2963','454',210567.43,210567.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257674',4907648,'2964','454',410673.11,410673.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257674',4907649,'2965','454',230351.01,230351.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257674',4907650,'2966','454',461677.47,461677.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257674',4907651,'2967','454',250053.15,250053.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257674',4907652,'2968','454',342090.35,342090.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257674',4907653,'2969','454',219436.52,219436.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257674',4907654,'2970','454',398516.34,398516.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257674',4907655,'2971','454',363058.86,363058.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257674',4907656,'2972','454',247633.21,247633.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257674',4907657,'2973','454',113473.49,117726.93,4253.44,701817.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257674',4907658,'2974','454',228886.52,228886.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257674',4907659,'2975','454',170152.40,173882.92,3730.52,615535.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257674',4907660,'2976','454',213076.81,213076.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257674',4907661,'2977','454',177615.07,181539.60,3924.53,647547.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257674',4907662,'2978','454',290804.41,294627.81,3823.40,630861.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257674',4907663,'2979','454',188783.51,193125.04,4341.53,716352.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257674',4907664,'2980','454',258873.79,258873.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257674',4907665,'2981','454',247433.78,252231.68,4797.90,791653.50,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257674',4907666,'2982','454',245528.70,245528.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257674',4907667,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257674',4907668,'2984','454',233195.20,238130.12,4914.92,810961.80,0.00,0.00,20.00,0.00,0.00),('1','122','1007','257674',4907669,'2985','455',316297.00,317047.87,750.87,525609.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257674',4907670,'2986','455',145119.40,145119.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257674',4907671,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257674',4907672,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257675',4907673,'2961','454',342758.15,346767.60,4009.45,661559.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257675',4907674,'2962','454',455432.07,455432.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257675',4907675,'2963','454',210567.43,210567.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257675',4907676,'2964','454',410673.11,413152.55,2479.44,409107.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257675',4907677,'2965','454',230351.01,234185.65,3834.64,632715.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257675',4907678,'2966','454',461677.47,461677.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257675',4907679,'2967','454',250053.15,250677.19,624.04,102966.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257675',4907680,'2968','454',342090.35,343177.95,1087.60,179454.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257675',4907681,'2969','454',219436.52,219436.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257675',4907682,'2970','454',398516.34,401357.60,2841.26,468807.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257675',4907683,'2971','454',363058.86,363058.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257675',4907684,'2972','454',247633.21,250114.08,2480.87,409343.55,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257675',4907685,'2973','454',117726.93,117726.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257675',4907686,'2974','454',228886.52,228886.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257675',4907687,'2975','454',173882.92,173882.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257675',4907688,'2976','454',213076.81,214222.24,1145.43,188995.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257675',4907689,'2977','454',181539.60,181539.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257675',4907690,'2978','454',294627.81,296388.45,1760.64,290505.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257675',4907691,'2979','454',193125.04,193125.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257675',4907692,'2980','454',258873.79,258873.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257675',4907693,'2981','454',252231.68,252231.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257675',4907694,'2982','454',245528.70,245528.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257675',4907695,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257675',4907696,'2984','454',238130.12,238130.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257675',4907697,'2985','455',317047.87,317440.09,392.22,274554.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257675',4907698,'2986','455',145119.40,145242.40,123.00,86100.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257675',4907699,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257675',4907700,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257676',4907701,'2961','454',346767.60,346767.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257676',4907702,'2962','454',455432.07,458281.39,2849.32,470137.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257676',4907703,'2963','454',210567.43,212934.65,2367.22,390591.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257676',4907704,'2964','454',413152.55,413152.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257676',4907705,'2965','454',234185.65,234185.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257676',4907706,'2966','454',461677.47,462993.08,1281.61,211465.65,0.00,0.00,34.00,0.00,0.00),('1','122','1004','257676',4907707,'2967','454',250677.19,253668.09,2990.90,493498.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257676',4907708,'2968','454',343177.95,343177.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257676',4907709,'2969','454',219436.52,219436.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257676',4907710,'2970','454',401357.60,401357.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257676',4907711,'2971','454',363058.86,366014.32,2955.46,487650.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257676',4907712,'2972','454',250114.08,250114.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257676',4907713,'2973','454',117726.93,117726.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257676',4907714,'2974','454',228886.52,228886.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257676',4907715,'2975','454',173882.92,173882.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257676',4907716,'2976','454',214222.24,215184.07,961.83,158701.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257676',4907717,'2977','454',181539.60,181539.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257676',4907718,'2978','454',296388.45,297448.66,1060.21,174934.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257676',4907719,'2979','454',193125.04,193125.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257676',4907720,'2980','454',258873.79,260023.40,1149.61,189685.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257676',4907721,'2981','454',252231.68,252231.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257676',4907722,'2982','454',245528.70,245528.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257676',4907723,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257676',4907724,'2984','454',238130.12,239123.59,993.47,163922.55,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257676',4907725,'2985','455',317440.09,318411.49,931.40,651980.00,0.00,0.00,40.00,0.00,0.00),('1','122','1007','257676',4907726,'2986','455',145242.40,146305.40,1063.00,744100.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257676',4907727,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257676',4907728,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257677',4907729,'2961','454',346767.60,346767.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257677',4907730,'2962','454',458281.39,458281.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257677',4907731,'2963','454',212934.65,212934.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257677',4907732,'2964','454',413152.55,413152.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257677',4907733,'2965','454',234185.65,234185.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257677',4907734,'2966','454',462993.08,462993.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257677',4907735,'2967','454',253668.09,253668.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257677',4907736,'2968','454',343177.95,343177.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257677',4907737,'2969','454',219436.52,219436.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257677',4907738,'2970','454',401357.60,401357.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257677',4907739,'2971','454',366014.32,366014.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257677',4907740,'2972','454',250114.08,250114.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257677',4907741,'2973','454',117726.93,120491.79,2764.86,456201.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257677',4907742,'2974','454',228886.52,231140.02,2253.50,371827.50,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257677',4907743,'2975','454',173882.92,176892.88,3009.96,496643.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257677',4907744,'2976','454',215184.07,215184.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257677',4907745,'2977','454',181539.60,185463.36,3923.76,647419.74,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257677',4907746,'2978','454',297448.66,297448.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257677',4907747,'2979','454',193125.04,196903.51,3778.47,623447.55,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257677',4907748,'2980','454',260023.40,260023.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257677',4907749,'2981','454',252231.68,252231.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257677',4907750,'2982','454',245528.70,248742.84,3204.14,528683.10,0.00,0.00,10.00,0.00,0.00),('1','122','1006','257677',4907751,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257677',4907752,'2984','454',239123.59,243492.18,4368.59,720817.35,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257677',4907753,'2985','455',318411.49,327052.46,8640.97,6048679.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257677',4907754,'2986','455',146305.40,148301.89,1996.49,1397543.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257677',4907755,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257677',4907756,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257678',4907757,'2961','454',346767.60,346767.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257678',4907758,'2962','454',458281.39,458281.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257678',4907759,'2963','454',212934.65,214404.02,1469.37,242446.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257678',4907760,'2964','454',413152.55,413152.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257678',4907761,'2965','454',234185.65,234185.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257678',4907762,'2966','454',462993.08,462993.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257678',4907763,'2967','454',253668.09,253668.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257678',4907764,'2968','454',343177.95,344703.50,1525.55,251715.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257678',4907765,'2969','454',219436.52,219436.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257678',4907766,'2970','454',401357.60,401357.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257678',4907767,'2971','454',366014.32,367551.07,1536.75,253563.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257678',4907768,'2972','454',250114.08,250114.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257678',4907769,'2973','454',120491.79,120491.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257678',4907770,'2974','454',231140.02,233731.99,2591.97,427675.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257678',4907771,'2975','454',176892.88,177257.79,364.91,60210.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257678',4907772,'2976','454',215184.07,217677.69,2493.62,411447.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257678',4907773,'2977','454',185463.36,187139.21,1675.85,276515.25,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257678',4907774,'2978','454',297448.66,297833.22,384.56,63452.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257678',4907775,'2979','454',196903.51,196903.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257678',4907776,'2980','454',260023.40,262694.28,2670.88,440695.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257678',4907777,'2981','454',252231.68,252542.01,310.33,51204.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257678',4907778,'2982','454',248742.84,251389.79,2646.95,436746.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257678',4907779,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257678',4907780,'2984','454',243492.18,243806.78,312.60,51579.00,0.00,0.00,2.00,0.00,0.00),('1','122','1007','257678',4907781,'2985','455',327052.46,328687.46,1635.00,1144500.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257678',4907782,'2986','455',148301.89,148790.90,489.01,342307.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257678',4907783,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257678',4907784,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257679',4907785,'2961','454',346767.60,346767.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257679',4907786,'2962','454',458281.39,458505.09,223.70,36910.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257679',4907787,'2963','454',214404.02,214404.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257679',4907788,'2964','454',413152.55,413152.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257679',4907789,'2965','454',234185.65,234756.93,571.28,94261.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257679',4907790,'2966','454',462993.08,462993.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257679',4907791,'2967','454',253668.09,253668.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257679',4907792,'2968','454',344703.50,344703.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257679',4907793,'2969','454',219436.52,219436.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257679',4907794,'2970','454',401357.60,401357.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257679',4907795,'2971','454',367551.07,367887.87,336.80,55572.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257679',4907796,'2972','454',250114.08,250114.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257679',4907797,'2973','454',120491.79,120491.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257679',4907798,'2974','454',233731.99,235123.48,1391.49,229595.85,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257679',4907799,'2975','454',177257.79,178587.96,1330.17,219478.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257679',4907800,'2976','454',217677.69,218114.90,437.21,72139.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257679',4907801,'2977','454',187139.21,188678.09,1538.88,253915.20,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257679',4907802,'2978','454',297833.22,297833.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257679',4907803,'2979','454',196903.51,196903.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257679',4907804,'2980','454',262694.28,264071.60,1377.32,227257.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257679',4907805,'2981','454',252542.01,253695.22,1153.21,190279.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257679',4907806,'2982','454',251389.79,251389.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257679',4907807,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257679',4907808,'2984','454',243806.78,245162.00,1355.22,223611.30,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257679',4907809,'2985','455',328687.46,330223.84,1536.38,1075466.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257679',4907810,'2986','455',148790.90,148790.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257679',4907811,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257679',4907812,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257680',4907813,'2961','454',346767.60,349832.56,3064.96,505718.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257680',4907814,'2962','454',458505.09,458505.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257680',4907815,'2963','454',214404.02,216965.12,2561.10,422581.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257680',4907816,'2964','454',413152.55,413152.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257680',4907817,'2965','454',234756.93,237325.55,2548.62,420522.30,0.00,0.00,20.00,0.00,0.00),('1','122','1004','257680',4907818,'2966','454',462993.08,462993.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257680',4907819,'2967','454',253668.09,256091.81,2423.72,399913.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257680',4907820,'2968','454',344703.50,347362.77,2659.27,438779.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257680',4907821,'2969','454',219436.52,220063.45,606.93,100143.45,0.00,0.00,20.00,0.00,0.00),('1','122','1004','257680',4907822,'2970','454',401357.60,403347.07,1989.47,328262.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257680',4907823,'2971','454',367887.87,371088.09,3200.22,528036.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257680',4907824,'2972','454',250114.08,250114.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257680',4907825,'2973','454',120491.79,120491.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257680',4907826,'2974','454',235123.48,235123.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257680',4907827,'2975','454',178587.96,178587.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257680',4907828,'2976','454',218114.90,218114.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257680',4907829,'2977','454',188678.09,188678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257680',4907830,'2978','454',297833.22,297833.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257680',4907831,'2979','454',196903.51,196903.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257680',4907832,'2980','454',264071.60,264071.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257680',4907833,'2981','454',253695.22,253695.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257680',4907834,'2982','454',251389.79,251389.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257680',4907835,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257680',4907836,'2984','454',245162.00,245162.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257680',4907837,'2985','455',330223.84,332159.50,1925.66,1347962.00,0.00,0.00,10.00,0.00,0.00),('1','122','1007','257680',4907838,'2986','455',148790.90,149051.68,260.78,182546.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257680',4907839,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257680',4907840,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257681',4907841,'2961','454',349832.56,349832.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257681',4907842,'2962','454',458505.09,461678.65,3163.56,521987.40,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257681',4907843,'2963','454',216965.12,216965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257681',4907844,'2964','454',413152.55,415263.71,2111.16,348341.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257681',4907845,'2965','454',237325.55,239355.03,2029.48,334864.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257681',4907846,'2966','454',462993.08,462993.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257681',4907847,'2967','454',256091.81,256091.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257681',4907848,'2968','454',347362.77,350024.90,2662.13,439251.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257681',4907849,'2969','454',220063.45,220063.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257681',4907850,'2970','454',403347.07,406212.57,2865.50,472807.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257681',4907851,'2971','454',371088.09,371088.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257681',4907852,'2972','454',250114.08,252484.15,2370.07,391061.55,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257681',4907853,'2973','454',120491.79,120491.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257681',4907854,'2974','454',235123.48,236099.06,975.58,160970.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257681',4907855,'2975','454',178587.96,178587.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257681',4907856,'2976','454',218114.90,219259.42,1144.52,188845.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257681',4907857,'2977','454',188678.09,188678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257681',4907858,'2978','454',297833.22,299087.69,1254.47,206987.55,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257681',4907859,'2979','454',196903.51,196903.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257681',4907860,'2980','454',264071.60,265235.31,1163.71,192012.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257681',4907861,'2981','454',253695.22,253695.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257681',4907862,'2982','454',251389.79,252312.51,922.72,152248.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257681',4907863,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257681',4907864,'2984','454',245162.00,246264.77,1102.77,181957.05,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257681',4907865,'2985','455',332159.50,332738.44,578.94,405258.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257681',4907866,'2986','455',149051.68,149051.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257681',4907867,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257681',4907868,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257682',4907869,'2961','454',349832.56,349832.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257682',4907870,'2962','454',461678.65,463047.15,1368.50,225802.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257682',4907871,'2963','454',216965.12,216965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257682',4907872,'2964','454',415263.71,416431.07,1167.36,192614.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257682',4907873,'2965','454',239355.03,239355.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257682',4907874,'2966','454',462993.08,464070.84,1077.76,177830.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257682',4907875,'2967','454',256091.81,256091.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257682',4907876,'2968','454',350024.90,351953.81,1928.91,318270.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257682',4907877,'2969','454',220063.45,220063.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257682',4907878,'2970','454',406212.57,406856.99,644.42,106329.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257682',4907879,'2971','454',371088.09,371088.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257682',4907880,'2972','454',252484.15,253585.34,1101.19,181696.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257682',4907881,'2973','454',120491.79,122891.50,2399.71,395952.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257682',4907882,'2974','454',236099.06,236099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257682',4907883,'2975','454',178587.96,180972.53,2384.57,393454.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257682',4907884,'2976','454',219259.42,219259.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257682',4907885,'2977','454',188678.09,191206.63,2528.54,417209.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257682',4907886,'2978','454',299087.69,299087.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257682',4907887,'2979','454',196903.51,198664.83,1761.32,290617.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257682',4907888,'2980','454',265235.31,266833.82,1598.51,263754.15,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257682',4907889,'2981','454',253695.22,255507.96,1812.74,299102.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257682',4907890,'2982','454',252312.51,252312.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257682',4907891,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257682',4907892,'2984','454',246264.77,248720.77,2456.00,405240.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257682',4907893,'2985','455',332738.44,332738.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257682',4907894,'2986','455',149051.68,149555.33,503.65,352555.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257682',4907895,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257682',4907896,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257683',4907897,'2961','454',349832.56,349832.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257683',4907898,'2962','454',463047.15,466077.33,3030.18,499979.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257683',4907899,'2963','454',216965.12,216965.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257683',4907900,'2964','454',416431.07,419491.23,3060.16,504926.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257683',4907901,'2965','454',239355.03,239355.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257683',4907902,'2966','454',464070.84,467306.17,3235.33,533829.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257683',4907903,'2967','454',256091.81,256091.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257683',4907904,'2968','454',351953.81,354454.17,2500.36,412559.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257683',4907905,'2969','454',220063.45,221437.92,1374.47,226787.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257683',4907906,'2970','454',406856.99,408421.21,1564.22,258096.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257683',4907907,'2971','454',371088.09,371088.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257683',4907908,'2972','454',253585.34,255605.36,2020.02,333303.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257683',4907909,'2973','454',122891.50,122891.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257683',4907910,'2974','454',236099.06,236099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257683',4907911,'2975','454',180972.53,180972.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257683',4907912,'2976','454',219259.42,219259.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257683',4907913,'2977','454',191206.63,191206.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257683',4907914,'2978','454',299087.69,299087.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257683',4907915,'2979','454',198664.83,198664.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257683',4907916,'2980','454',266833.82,266833.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257683',4907917,'2981','454',255507.96,255507.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257683',4907918,'2982','454',252312.51,252312.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257683',4907919,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257683',4907920,'2984','454',248720.77,248720.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257683',4907921,'2985','455',332738.44,332738.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257683',4907922,'2986','455',149555.33,149859.59,304.26,212982.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257683',4907923,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257683',4907924,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257684',4907925,'2961','454',349832.56,350487.99,655.43,108145.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257684',4907926,'2962','454',466077.33,468347.30,2269.97,374545.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257684',4907927,'2963','454',216965.12,219110.90,2145.78,354053.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257684',4907928,'2964','454',419491.23,419491.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257684',4907929,'2965','454',239355.03,241607.80,2252.77,371707.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257684',4907930,'2966','454',467306.17,467306.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257684',4907931,'2967','454',256091.81,258457.75,2345.94,387080.10,0.00,0.00,20.00,0.00,0.00),('1','122','1004','257684',4907932,'2968','454',354454.17,354975.45,521.28,86011.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257684',4907933,'2969','454',221437.92,221437.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257684',4907934,'2970','454',408421.21,410518.03,2096.82,345975.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257684',4907935,'2971','454',371088.09,373261.25,2173.16,358571.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257684',4907936,'2972','454',255605.36,255605.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257684',4907937,'2973','454',122891.50,122891.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257684',4907938,'2974','454',236099.06,236099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257684',4907939,'2975','454',180972.53,180972.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257684',4907940,'2976','454',219259.42,219259.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257684',4907941,'2977','454',191206.63,191206.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257684',4907942,'2978','454',299087.69,299087.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257684',4907943,'2979','454',198664.83,198664.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257684',4907944,'2980','454',266833.82,266833.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257684',4907945,'2981','454',255507.96,255507.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257684',4907946,'2982','454',252312.51,252312.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257684',4907947,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257684',4907948,'2984','454',248720.77,248720.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257684',4907949,'2985','455',332738.44,334121.71,1383.27,968289.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257684',4907950,'2986','455',149859.59,150800.10,940.51,658357.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257684',4907951,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257684',4907952,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257685',4907953,'2961','454',350487.99,350487.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257685',4907954,'2962','454',468347.30,470111.13,1763.83,291031.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257685',4907955,'2963','454',219110.90,220982.67,1871.77,308842.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257685',4907956,'2964','454',419491.23,419491.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257685',4907957,'2965','454',241607.80,241607.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257685',4907958,'2966','454',467306.17,469276.62,1970.45,325124.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257685',4907959,'2967','454',258457.75,258457.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257685',4907960,'2968','454',354975.45,356599.52,1624.07,267971.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257685',4907961,'2969','454',221437.92,222672.25,1234.33,203664.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257685',4907962,'2970','454',410518.03,412148.96,1630.93,269103.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257685',4907963,'2971','454',373261.25,373261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257685',4907964,'2972','454',255605.36,257379.78,1774.42,292779.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257685',4907965,'2973','454',122891.50,122891.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257685',4907966,'2974','454',236099.06,236099.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257685',4907967,'2975','454',180972.53,180972.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257685',4907968,'2976','454',219259.42,219259.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257685',4907969,'2977','454',191206.63,191206.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257685',4907970,'2978','454',299087.69,299087.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257685',4907971,'2979','454',198664.83,198664.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257685',4907972,'2980','454',266833.82,266833.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257685',4907973,'2981','454',255507.96,255507.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257685',4907974,'2982','454',252312.51,252312.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257685',4907975,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257685',4907976,'2984','454',248720.77,248720.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257685',4907977,'2985','455',334121.71,335754.00,1632.29,1142603.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257685',4907978,'2986','455',150800.10,150800.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257685',4907979,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257685',4907980,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257686',4907981,'2961','454',350487.99,350487.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257686',4907982,'2962','454',470111.13,470111.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257686',4907983,'2963','454',220982.67,220982.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257686',4907984,'2964','454',419491.23,419491.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257686',4907985,'2965','454',241607.80,244235.20,2627.40,433521.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257686',4907986,'2966','454',469276.62,469276.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257686',4907987,'2967','454',258457.75,258457.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257686',4907988,'2968','454',356599.52,357390.72,791.20,130548.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257686',4907989,'2969','454',222672.25,222672.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257686',4907990,'2970','454',412148.96,413639.66,1490.70,245965.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257686',4907991,'2971','454',373261.25,373261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257686',4907992,'2972','454',257379.78,258166.75,786.97,129850.05,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257686',4907993,'2973','454',122891.50,122891.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257686',4907994,'2974','454',236099.06,238095.55,1996.49,329420.85,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257686',4907995,'2975','454',180972.53,180972.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257686',4907996,'2976','454',219259.42,219259.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257686',4907997,'2977','454',191206.63,191206.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257686',4907998,'2978','454',299087.69,301494.00,2396.31,395391.15,0.00,0.00,10.00,0.00,0.00),('1','122','1006','257686',4907999,'2979','454',198664.83,198664.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257686',4908000,'2980','454',266833.82,266833.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257686',4908001,'2981','454',255507.96,255507.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257686',4908002,'2982','454',252312.51,254211.90,1899.39,313399.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257686',4908003,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257686',4908004,'2984','454',248720.77,250974.23,2253.46,371820.90,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257686',4908005,'2985','455',335754.00,335754.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257686',4908006,'2986','455',150800.10,151577.95,769.85,538895.00,0.00,0.00,8.00,0.00,0.00),('1','122','1007','257686',4908007,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257686',4908008,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257687',4908009,'2961','454',350487.99,352861.69,2373.70,391660.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257687',4908010,'2962','454',470111.13,470245.59,134.46,22185.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257687',4908011,'2963','454',220982.67,220982.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257687',4908012,'2964','454',419491.23,422992.65,3501.42,577734.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257687',4908013,'2965','454',244235.20,244235.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257687',4908014,'2966','454',469276.62,472670.92,3374.30,556759.50,0.00,0.00,20.00,0.00,0.00),('1','122','1004','257687',4908015,'2967','454',258457.75,258457.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257687',4908016,'2968','454',357390.72,360015.53,2624.81,433093.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257687',4908017,'2969','454',222672.25,222672.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257687',4908018,'2970','454',413639.66,416764.94,3125.28,515671.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257687',4908019,'2971','454',373261.25,373261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257687',4908020,'2972','454',258166.75,261005.96,2819.21,465169.65,0.00,0.00,20.00,0.00,0.00),('1','122','1006','257687',4908021,'2973','454',122891.50,122891.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257687',4908022,'2974','454',238095.55,238095.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257687',4908023,'2975','454',180972.53,180972.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257687',4908024,'2976','454',219259.42,219259.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257687',4908025,'2977','454',191206.63,191206.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257687',4908026,'2978','454',301494.00,301494.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257687',4908027,'2979','454',198664.83,198664.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257687',4908028,'2980','454',266833.82,266833.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257687',4908029,'2981','454',255507.96,255507.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257687',4908030,'2982','454',254211.90,254211.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257687',4908031,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257687',4908032,'2984','454',250974.23,250974.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257687',4908033,'2985','455',335754.00,336384.01,630.01,441007.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257687',4908034,'2986','455',151577.95,151577.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257687',4908035,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257687',4908036,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257688',4908037,'2961','454',352861.69,352861.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257688',4908038,'2962','454',470245.59,471297.22,1051.63,173518.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257688',4908039,'2963','454',220982.67,220982.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257688',4908040,'2964','454',422992.65,423949.29,956.64,157845.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257688',4908041,'2965','454',244235.20,244235.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257688',4908042,'2966','454',472670.92,473796.92,1126.00,185790.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257688',4908043,'2967','454',258457.75,258457.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257688',4908044,'2968','454',360015.53,360931.95,916.42,151209.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257688',4908045,'2969','454',222672.25,222672.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257688',4908046,'2970','454',416764.94,416764.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257688',4908047,'2971','454',373261.25,374066.29,805.04,132831.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257688',4908048,'2972','454',261005.96,261005.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257688',4908049,'2973','454',122891.50,122891.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257688',4908050,'2974','454',238095.55,238095.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257688',4908051,'2975','454',180972.53,180972.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257688',4908052,'2976','454',219259.42,219259.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257688',4908053,'2977','454',191206.63,191206.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257688',4908054,'2978','454',301494.00,301494.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257688',4908055,'2979','454',198664.83,198664.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257688',4908056,'2980','454',266833.82,266833.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257688',4908057,'2981','454',255507.96,255507.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257688',4908058,'2982','454',254211.90,254211.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257688',4908059,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257688',4908060,'2984','454',250974.23,250974.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257688',4908061,'2985','455',336384.01,338132.58,1748.57,1223999.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257688',4908062,'2986','455',151577.95,151577.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257688',4908063,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257688',4908064,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257689',4908065,'2961','454',352861.69,352861.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257689',4908066,'2962','454',471297.22,475173.75,3876.53,639627.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257689',4908067,'2963','454',220982.67,226085.54,5102.87,841973.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257689',4908068,'2964','454',423949.29,423949.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257689',4908069,'2965','454',244235.20,244235.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257689',4908070,'2966','454',473796.92,473796.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257689',4908071,'2967','454',258457.75,263005.81,4548.06,750429.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257689',4908072,'2968','454',360931.95,360931.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257689',4908073,'2969','454',222672.25,222672.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257689',4908074,'2970','454',416764.94,416764.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257689',4908075,'2971','454',374066.29,374066.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257689',4908076,'2972','454',261005.96,265572.99,4557.03,751909.95,0.00,0.00,10.00,0.00,0.00),('1','122','1006','257689',4908077,'2973','454',122891.50,122891.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257689',4908078,'2974','454',238095.55,238095.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257689',4908079,'2975','454',180972.53,180972.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257689',4908080,'2976','454',219259.42,219259.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257689',4908081,'2977','454',191206.63,191206.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257689',4908082,'2978','454',301494.00,301494.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257689',4908083,'2979','454',198664.83,198664.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257689',4908084,'2980','454',266833.82,266833.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257689',4908085,'2981','454',255507.96,255507.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257689',4908086,'2982','454',254211.90,254211.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257689',4908087,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257689',4908088,'2984','454',250974.23,250974.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257689',4908089,'2985','455',338132.58,340282.01,2149.43,1504601.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257689',4908090,'2986','455',151577.95,151577.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257689',4908091,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257689',4908092,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257690',4908093,'2961','454',352861.69,354335.68,1453.99,239908.35,0.00,0.00,20.00,0.00,0.00),('1','122','1004','257690',4908094,'2962','454',475173.75,477408.91,2235.16,368801.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257690',4908095,'2963','454',226085.54,226085.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257690',4908096,'2964','454',423949.29,427818.99,3869.70,638500.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257690',4908097,'2965','454',244235.20,244235.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257690',4908098,'2966','454',473796.92,476029.12,2232.20,368313.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257690',4908099,'2967','454',263005.81,263005.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257690',4908100,'2968','454',360931.95,363964.08,3032.13,500301.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257690',4908101,'2969','454',222672.25,222672.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257690',4908102,'2970','454',416764.94,418833.99,2069.05,341393.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257690',4908103,'2971','454',374066.29,375279.65,1213.36,200204.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257690',4908104,'2972','454',265572.99,267528.14,1955.15,322599.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257690',4908105,'2973','454',122891.50,122891.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257690',4908106,'2974','454',238095.55,238095.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257690',4908107,'2975','454',180972.53,180972.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257690',4908108,'2976','454',219259.42,219259.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257690',4908109,'2977','454',191206.63,191206.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257690',4908110,'2978','454',301494.00,301494.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257690',4908111,'2979','454',198664.83,198664.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257690',4908112,'2980','454',266833.82,266833.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257690',4908113,'2981','454',255507.96,255507.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257690',4908114,'2982','454',254211.90,254211.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257690',4908115,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257690',4908116,'2984','454',250974.23,250974.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257690',4908117,'2985','455',340282.01,341280.00,992.99,695093.00,0.00,0.00,5.00,0.00,0.00),('1','122','1007','257690',4908118,'2986','455',151577.95,151577.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257690',4908119,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257690',4908120,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257691',4908121,'2961','454',354335.68,354335.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257691',4908122,'2962','454',477408.91,481118.39,3699.48,610414.20,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257691',4908123,'2963','454',226085.54,226085.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257691',4908124,'2964','454',427818.99,427818.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257691',4908125,'2965','454',244235.20,244235.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257691',4908126,'2966','454',476029.12,479318.02,3288.90,542668.50,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257691',4908127,'2967','454',263005.81,263005.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257691',4908128,'2968','454',363964.08,363964.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257691',4908129,'2969','454',222672.25,222672.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257691',4908130,'2970','454',418833.99,418833.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257691',4908131,'2971','454',375279.65,375279.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257691',4908132,'2972','454',267528.14,271063.29,3535.15,583299.75,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257691',4908133,'2973','454',122891.50,122891.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257691',4908134,'2974','454',238095.55,238095.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257691',4908135,'2975','454',180972.53,180972.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257691',4908136,'2976','454',219259.42,219259.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257691',4908137,'2977','454',191206.63,191206.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257691',4908138,'2978','454',301494.00,301494.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257691',4908139,'2979','454',198664.83,198664.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257691',4908140,'2980','454',266833.82,266833.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257691',4908141,'2981','454',255507.96,255507.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257691',4908142,'2982','454',254211.90,254211.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257691',4908143,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257691',4908144,'2984','454',250974.23,250974.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257691',4908145,'2985','455',341280.00,341280.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257691',4908146,'2986','455',151577.95,151577.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257691',4908147,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257691',4908148,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257692',4908149,'2961','454',354335.68,356959.66,2623.98,432956.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257692',4908150,'2962','454',481118.39,481118.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257692',4908151,'2963','454',226085.54,226085.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257692',4908152,'2964','454',427818.99,430524.97,2705.98,446486.70,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257692',4908153,'2965','454',244235.20,244235.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257692',4908154,'2966','454',479318.02,479318.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257692',4908155,'2967','454',263005.81,263005.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257692',4908156,'2968','454',363964.08,366648.53,2684.45,442934.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257692',4908157,'2969','454',222672.25,222672.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257692',4908158,'2970','454',418833.99,421487.52,2653.53,437832.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257692',4908159,'2971','454',375279.65,375279.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257692',4908160,'2972','454',271063.29,271063.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257692',4908161,'2973','454',122891.50,122891.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257692',4908162,'2974','454',238095.55,238095.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257692',4908163,'2975','454',180972.53,180972.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257692',4908164,'2976','454',219259.42,219259.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257692',4908165,'2977','454',191206.63,191206.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257692',4908166,'2978','454',301494.00,301494.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257692',4908167,'2979','454',198664.83,198664.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257692',4908168,'2980','454',266833.82,266833.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257692',4908169,'2981','454',255507.96,255507.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257692',4908170,'2982','454',254211.90,254211.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257692',4908171,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257692',4908172,'2984','454',250974.23,250974.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257692',4908173,'2985','455',341280.00,341280.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257692',4908174,'2986','455',151577.95,151577.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257692',4908175,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257692',4908176,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257693',4908177,'2961','454',356959.66,356959.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257693',4908178,'2962','454',481118.39,484450.91,3332.52,549865.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257693',4908179,'2963','454',226085.54,226085.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257693',4908180,'2964','454',430524.97,430524.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257693',4908181,'2965','454',244235.20,244235.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257693',4908182,'2966','454',479318.02,484262.24,4944.22,815796.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257693',4908183,'2967','454',263005.81,263005.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257693',4908184,'2968','454',366648.53,371591.86,4943.33,815649.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257693',4908185,'2969','454',222672.25,222672.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257693',4908186,'2970','454',421487.52,421487.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257693',4908187,'2971','454',375279.65,375279.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257693',4908188,'2972','454',271063.29,276075.62,5012.33,827034.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257693',4908189,'2973','454',122891.50,122891.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257693',4908190,'2974','454',238095.55,238095.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257693',4908191,'2975','454',180972.53,180972.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257693',4908192,'2976','454',219259.42,219259.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257693',4908193,'2977','454',191206.63,191206.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257693',4908194,'2978','454',301494.00,301494.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257693',4908195,'2979','454',198664.83,198664.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257693',4908196,'2980','454',266833.82,266833.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257693',4908197,'2981','454',255507.96,255507.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257693',4908198,'2982','454',254211.90,254211.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257693',4908199,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257693',4908200,'2984','454',250974.23,250974.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257693',4908201,'2985','455',341280.00,341280.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257693',4908202,'2986','455',151577.95,151577.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257693',4908203,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257693',4908204,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257694',4908205,'2961','454',356959.66,360799.59,3839.93,633588.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257694',4908206,'2962','454',484450.91,484450.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257694',4908207,'2963','454',226085.54,229411.67,3326.13,548811.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257694',4908208,'2964','454',430524.97,430926.61,401.64,66270.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257694',4908209,'2965','454',244235.20,247666.63,3431.43,566185.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257694',4908210,'2966','454',484262.24,484262.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257694',4908211,'2967','454',263005.81,263005.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257694',4908212,'2968','454',371591.86,373651.29,2059.43,339805.95,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257694',4908213,'2969','454',222672.25,222672.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257694',4908214,'2970','454',421487.52,425051.63,3564.11,588078.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257694',4908215,'2971','454',375279.65,379334.70,4055.05,669083.25,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257694',4908216,'2972','454',276075.62,276075.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257694',4908217,'2973','454',122891.50,122891.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257694',4908218,'2974','454',238095.55,238095.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257694',4908219,'2975','454',180972.53,180972.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257694',4908220,'2976','454',219259.42,219259.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257694',4908221,'2977','454',191206.63,191206.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257694',4908222,'2978','454',301494.00,301494.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257694',4908223,'2979','454',198664.83,198664.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257694',4908224,'2980','454',266833.82,266833.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257694',4908225,'2981','454',255507.96,255507.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257694',4908226,'2982','454',254211.90,254211.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257694',4908227,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257694',4908228,'2984','454',250974.23,250974.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257694',4908229,'2985','455',341280.00,341280.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257694',4908230,'2986','455',151577.95,151577.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257694',4908231,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257694',4908232,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257695',4908233,'2961','454',360799.59,360799.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257695',4908234,'2962','454',484450.91,486546.00,2095.09,345689.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257695',4908235,'2963','454',229411.67,229411.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257695',4908236,'2964','454',430926.61,433626.48,2699.87,445478.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257695',4908237,'2965','454',247666.63,249483.18,1816.55,299730.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257695',4908238,'2966','454',484262.24,484262.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257695',4908239,'2967','454',263005.81,263005.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257695',4908240,'2968','454',373651.29,375340.33,1689.04,278691.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257695',4908241,'2969','454',222672.25,222672.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257695',4908242,'2970','454',425051.63,427313.69,2242.06,369939.90,0.00,0.00,20.00,0.00,0.00),('1','122','1004','257695',4908243,'2971','454',379334.70,379334.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257695',4908244,'2972','454',276075.62,277907.40,1831.78,302243.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257695',4908245,'2973','454',122891.50,122891.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257695',4908246,'2974','454',238095.55,241238.93,3143.38,518657.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257695',4908247,'2975','454',180972.53,180972.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257695',4908248,'2976','454',219259.42,222453.94,3194.52,527095.80,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257695',4908249,'2977','454',191206.63,191206.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257695',4908250,'2978','454',301494.00,303723.96,2229.96,367943.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257695',4908251,'2979','454',198664.83,198664.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257695',4908252,'2980','454',266833.82,269911.32,3052.50,503662.50,0.00,0.00,25.00,0.00,0.00),('1','122','1006','257695',4908253,'2981','454',255507.96,255507.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257695',4908254,'2982','454',254211.90,255508.15,1296.25,213881.25,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257695',4908255,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257695',4908256,'2984','454',250974.23,250974.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257695',4908257,'2985','455',341280.00,341280.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257695',4908258,'2986','455',151577.95,151577.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257695',4908259,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257695',4908260,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257696',4908261,'2961','454',360799.59,360799.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257696',4908262,'2962','454',486546.00,486546.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257696',4908263,'2963','454',229411.67,230605.27,1193.60,196944.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257696',4908264,'2964','454',433626.48,433626.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257696',4908265,'2965','454',249483.18,249483.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257696',4908266,'2966','454',484262.24,484262.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257696',4908267,'2967','454',263005.81,263005.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257696',4908268,'2968','454',375340.33,376533.63,1183.30,195244.50,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257696',4908269,'2969','454',222672.25,222672.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257696',4908270,'2970','454',427313.69,427313.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257696',4908271,'2971','454',379334.70,379334.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257696',4908272,'2972','454',277907.40,278867.86,960.46,158475.90,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257696',4908273,'2973','454',122891.50,123954.97,1033.47,170522.55,0.00,0.00,30.00,0.00,0.00),('1','122','1006','257696',4908274,'2974','454',241238.93,241238.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257696',4908275,'2975','454',180972.53,184004.98,3032.45,500354.25,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257696',4908276,'2976','454',222453.94,222453.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257696',4908277,'2977','454',191206.63,194139.79,2933.16,483971.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257696',4908278,'2978','454',303723.96,303723.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257696',4908279,'2979','454',198664.83,199979.57,1314.74,216932.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257696',4908280,'2980','454',269911.32,269911.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257696',4908281,'2981','454',255507.96,258559.50,3051.54,503504.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257696',4908282,'2982','454',255508.15,255508.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257696',4908283,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257696',4908284,'2984','454',250974.23,256617.57,5643.34,931151.10,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257696',4908285,'2985','455',341280.00,341280.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257696',4908286,'2986','455',151577.95,151577.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257696',4908287,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257696',4908288,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257697',4908289,'2961','454',360799.59,360799.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257697',4908290,'2962','454',486546.00,490381.51,3835.51,632859.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257697',4908291,'2963','454',230605.27,230605.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257697',4908292,'2964','454',433626.48,433626.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257697',4908293,'2965','454',249483.18,249483.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257697',4908294,'2966','454',484262.24,486266.48,2004.24,330699.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257697',4908295,'2967','454',263005.81,263005.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257697',4908296,'2968','454',376533.63,376533.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257697',4908297,'2969','454',222672.25,222672.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257697',4908298,'2970','454',427313.69,427313.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257697',4908299,'2971','454',379334.70,379334.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257697',4908300,'2972','454',278867.86,281831.40,2963.54,488984.10,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257697',4908301,'2973','454',123954.97,123954.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257697',4908302,'2974','454',241238.93,241238.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257697',4908303,'2975','454',184004.98,186433.82,2428.84,400758.60,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257697',4908304,'2976','454',222453.94,222453.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257697',4908305,'2977','454',194139.79,194139.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257697',4908306,'2978','454',303723.96,305567.29,1843.33,304149.45,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257697',4908307,'2979','454',199979.57,199979.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257697',4908308,'2980','454',269911.32,269911.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257697',4908309,'2981','454',258559.50,258559.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257697',4908310,'2982','454',255508.15,255508.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257697',4908311,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257697',4908312,'2984','454',256617.57,259308.64,2691.07,444026.55,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257697',4908313,'2985','455',341280.00,341280.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257697',4908314,'2986','455',151577.95,151577.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257697',4908315,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257697',4908316,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257698',4908317,'2961','454',360799.59,360799.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257698',4908318,'2962','454',490381.51,490381.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257698',4908319,'2963','454',230605.27,235617.86,5012.59,827077.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257698',4908320,'2964','454',433626.48,433626.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257698',4908321,'2965','454',249483.18,249483.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257698',4908322,'2966','454',486266.48,486266.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257698',4908323,'2967','454',263005.81,263005.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257698',4908324,'2968','454',376533.63,380553.16,4019.53,663222.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257698',4908325,'2969','454',222672.25,222672.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257698',4908326,'2970','454',427313.69,427313.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257698',4908327,'2971','454',379334.70,379334.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257698',4908328,'2972','454',281831.40,281831.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257698',4908329,'2973','454',123954.97,123954.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257698',4908330,'2974','454',241238.93,241238.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257698',4908331,'2975','454',186433.82,186433.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257698',4908332,'2976','454',222453.94,222453.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257698',4908333,'2977','454',194139.79,194139.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257698',4908334,'2978','454',305567.29,305567.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257698',4908335,'2979','454',199979.57,203397.95,3418.38,564032.70,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257698',4908336,'2980','454',269911.32,269911.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257698',4908337,'2981','454',258559.50,258559.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257698',4908338,'2982','454',255508.15,255508.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257698',4908339,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257698',4908340,'2984','454',259308.64,263318.76,4010.12,661669.80,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257698',4908341,'2985','455',341280.00,342374.74,1094.74,766318.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257698',4908342,'2986','455',151577.95,151642.23,64.28,44996.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257698',4908343,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257698',4908344,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257699',4908345,'2961','454',360799.59,360799.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257699',4908346,'2962','454',490381.51,494013.25,3631.74,599237.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257699',4908347,'2963','454',235617.86,235617.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257699',4908348,'2964','454',433626.48,433626.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257699',4908349,'2965','454',249483.18,249483.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257699',4908350,'2966','454',486266.48,489143.96,2877.48,474784.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257699',4908351,'2967','454',263005.81,263005.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257699',4908352,'2968','454',380553.16,380553.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257699',4908353,'2969','454',222672.25,222672.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257699',4908354,'2970','454',427313.69,429959.63,2645.94,436580.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257699',4908355,'2971','454',379334.70,379334.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257699',4908356,'2972','454',281831.40,281831.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257699',4908357,'2973','454',123954.97,123954.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257699',4908358,'2974','454',241238.93,242024.43,785.50,129607.50,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257699',4908359,'2975','454',186433.82,186433.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257699',4908360,'2976','454',222453.94,222453.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257699',4908361,'2977','454',194139.79,194139.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257699',4908362,'2978','454',305567.29,306427.31,860.02,141903.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257699',4908363,'2979','454',203397.95,203397.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257699',4908364,'2980','454',269911.32,269911.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257699',4908365,'2981','454',258559.50,258559.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257699',4908366,'2982','454',255508.15,256592.95,1084.80,178992.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257699',4908367,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257699',4908368,'2984','454',263318.76,263318.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257699',4908369,'2985','455',342374.74,342886.39,511.65,358155.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257699',4908370,'2986','455',151642.23,151642.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257699',4908371,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257699',4908372,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257700',4908373,'2961','454',360799.59,360953.67,154.08,25423.20,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257700',4908374,'2962','454',494013.25,494013.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257700',4908375,'2963','454',235617.86,235617.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257700',4908376,'2964','454',433626.48,433626.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257700',4908377,'2965','454',249483.18,249669.39,186.21,30724.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257700',4908378,'2966','454',489143.96,489143.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257700',4908379,'2967','454',263005.81,263005.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257700',4908380,'2968','454',380553.16,380553.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257700',4908381,'2969','454',222672.25,222672.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257700',4908382,'2970','454',429959.63,429959.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257700',4908383,'2971','454',379334.70,379334.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257700',4908384,'2972','454',281831.40,281831.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257700',4908385,'2973','454',123954.97,127048.40,3093.43,510415.95,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257700',4908386,'2974','454',242024.43,242024.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257700',4908387,'2975','454',186433.82,186433.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257700',4908388,'2976','454',222453.94,225495.30,3041.36,501824.40,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257700',4908389,'2977','454',194139.79,197506.41,3366.62,555492.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257700',4908390,'2978','454',306427.31,306427.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257700',4908391,'2979','454',203397.95,203397.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257700',4908392,'2980','454',269911.32,269911.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257700',4908393,'2981','454',258559.50,258559.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257700',4908394,'2982','454',256592.95,256592.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257700',4908395,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257700',4908396,'2984','454',263318.76,266966.70,3647.94,601910.10,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257700',4908397,'2985','455',342886.39,342886.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257700',4908398,'2986','455',151642.23,151884.81,222.58,155806.00,0.00,0.00,20.00,0.00,0.00),('1','122','1007','257700',4908399,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257700',4908400,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257701',4908401,'2961','454',360953.67,364539.47,3585.80,591657.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257701',4908402,'2962','454',494013.25,494013.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257701',4908403,'2963','454',235617.86,235617.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257701',4908404,'2964','454',433626.48,433626.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257701',4908405,'2965','454',249669.39,253031.18,3361.79,554695.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257701',4908406,'2966','454',489143.96,489143.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257701',4908407,'2967','454',263005.81,263005.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257701',4908408,'2968','454',380553.16,380553.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257701',4908409,'2969','454',222672.25,222672.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257701',4908410,'2970','454',429959.63,432913.87,2954.24,487449.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257701',4908411,'2971','454',379334.70,379334.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257701',4908412,'2972','454',281831.40,285876.39,4044.99,667423.35,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257701',4908413,'2973','454',127048.40,127048.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257701',4908414,'2974','454',242024.43,242024.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257701',4908415,'2975','454',186433.82,186433.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257701',4908416,'2976','454',225495.30,225495.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257701',4908417,'2977','454',197506.41,197506.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257701',4908418,'2978','454',306427.31,306427.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257701',4908419,'2979','454',203397.95,203397.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257701',4908420,'2980','454',269911.32,269911.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257701',4908421,'2981','454',258559.50,258559.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257701',4908422,'2982','454',256592.95,256592.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257701',4908423,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257701',4908424,'2984','454',266966.70,266966.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257701',4908425,'2985','455',342886.39,343146.90,260.51,182357.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257701',4908426,'2986','455',151884.81,151884.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257701',4908427,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257701',4908428,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257702',4908429,'2961','454',364539.47,369150.94,4611.47,760892.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257702',4908430,'2962','454',494013.25,494013.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257702',4908431,'2963','454',235617.86,237950.86,2333.00,384945.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257702',4908432,'2964','454',433626.48,433626.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257702',4908433,'2965','454',253031.18,253031.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257702',4908434,'2966','454',489143.96,493173.77,4029.81,664918.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257702',4908435,'2967','454',263005.81,267838.20,4832.39,797344.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257702',4908436,'2968','454',380553.16,380553.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257702',4908437,'2969','454',222672.25,226850.12,4165.75,687348.75,0.00,0.00,12.12,0.00,0.00),('1','122','1004','257702',4908438,'2970','454',432913.87,432913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257702',4908439,'2971','454',379334.70,379334.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257702',4908440,'2972','454',285876.39,285876.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257702',4908441,'2973','454',127048.40,127048.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257702',4908442,'2974','454',242024.43,242024.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257702',4908443,'2975','454',186433.82,186433.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257702',4908444,'2976','454',225495.30,225495.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257702',4908445,'2977','454',197506.41,197506.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257702',4908446,'2978','454',306427.31,306427.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257702',4908447,'2979','454',203397.95,203397.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257702',4908448,'2980','454',269911.32,269911.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257702',4908449,'2981','454',258559.50,258559.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257702',4908450,'2982','454',256592.95,256592.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257702',4908451,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257702',4908452,'2984','454',266966.70,266966.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257702',4908453,'2985','455',343146.90,344485.60,1338.70,937090.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257702',4908454,'2986','455',151884.81,151884.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257702',4908455,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257702',4908456,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257703',4908457,'2961','454',369150.94,369150.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257703',4908458,'2962','454',494013.25,496237.64,2224.39,367024.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257703',4908459,'2963','454',237950.86,237950.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257703',4908460,'2964','454',433626.48,433626.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257703',4908461,'2965','454',253031.18,253031.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257703',4908462,'2966','454',493173.77,495210.91,2037.14,336128.10,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257703',4908463,'2967','454',267838.20,267838.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257703',4908464,'2968','454',380553.16,383869.58,3316.42,547209.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257703',4908465,'2969','454',226850.12,226850.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257703',4908466,'2970','454',432913.87,432913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257703',4908467,'2971','454',379334.70,382286.25,2951.55,487005.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257703',4908468,'2972','454',285876.39,285876.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257703',4908469,'2973','454',127048.40,127048.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257703',4908470,'2974','454',242024.43,242024.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257703',4908471,'2975','454',186433.82,186433.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257703',4908472,'2976','454',225495.30,225495.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257703',4908473,'2977','454',197506.41,197506.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257703',4908474,'2978','454',306427.31,306427.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257703',4908475,'2979','454',203397.95,203397.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257703',4908476,'2980','454',269911.32,269911.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257703',4908477,'2981','454',258559.50,258559.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257703',4908478,'2982','454',256592.95,256592.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257703',4908479,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257703',4908480,'2984','454',266966.70,266966.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257703',4908481,'2985','455',344485.60,345008.62,523.02,366114.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257703',4908482,'2986','455',151884.81,151884.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257703',4908483,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257703',4908484,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257704',4908485,'2961','454',369150.94,374486.05,5335.11,880293.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257704',4908486,'2962','454',496237.64,496237.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257704',4908487,'2963','454',237950.86,242396.75,4445.89,733571.85,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257704',4908488,'2964','454',433626.48,433626.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257704',4908489,'2965','454',253031.18,253031.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257704',4908490,'2966','454',495210.91,495210.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257704',4908491,'2967','454',267838.20,267850.75,12.55,2070.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257704',4908492,'2968','454',383869.58,389425.40,5555.82,916710.30,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257704',4908493,'2969','454',226850.12,226850.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257704',4908494,'2970','454',432913.87,432913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257704',4908495,'2971','454',382286.25,382286.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257704',4908496,'2972','454',285876.39,291369.40,5493.01,906346.65,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257704',4908497,'2973','454',127048.40,127048.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257704',4908498,'2974','454',242024.43,242024.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257704',4908499,'2975','454',186433.82,186433.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257704',4908500,'2976','454',225495.30,225495.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257704',4908501,'2977','454',197506.41,197506.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257704',4908502,'2978','454',306427.31,306427.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257704',4908503,'2979','454',203397.95,203397.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257704',4908504,'2980','454',269911.32,269911.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257704',4908505,'2981','454',258559.50,258559.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257704',4908506,'2982','454',256592.95,256592.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257704',4908507,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257704',4908508,'2984','454',266966.70,266966.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257704',4908509,'2985','455',345008.62,345008.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257704',4908510,'2986','455',151884.81,154136.92,2252.11,1576477.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257704',4908511,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257704',4908512,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257705',4908513,'2961','454',374486.05,374486.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257705',4908514,'2962','454',496237.64,499128.76,2891.12,477034.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257705',4908515,'2963','454',242396.75,242396.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257705',4908516,'2964','454',433626.48,433626.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257705',4908517,'2965','454',253031.18,257541.75,4510.57,744244.05,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257705',4908518,'2966','454',495210.91,495210.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257705',4908519,'2967','454',267850.75,267850.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257705',4908520,'2968','454',389425.40,389425.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257705',4908521,'2969','454',226850.12,229162.96,2312.84,381618.60,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257705',4908522,'2970','454',432913.87,432913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257705',4908523,'2971','454',382286.25,385444.51,3148.26,519462.90,0.00,0.00,10.00,0.00,0.00),('1','122','1004','257705',4908524,'2972','454',291369.40,291369.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257705',4908525,'2973','454',127048.40,127048.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257705',4908526,'2974','454',242024.43,242024.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257705',4908527,'2975','454',186433.82,186433.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257705',4908528,'2976','454',225495.30,225495.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257705',4908529,'2977','454',197506.41,197506.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257705',4908530,'2978','454',306427.31,306427.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257705',4908531,'2979','454',203397.95,203397.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257705',4908532,'2980','454',269911.32,269911.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257705',4908533,'2981','454',258559.50,258559.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257705',4908534,'2982','454',256592.95,256592.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257705',4908535,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257705',4908536,'2984','454',266966.70,266966.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257705',4908537,'2985','455',345008.62,351668.68,6660.06,4662042.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257705',4908538,'2986','455',154136.92,157697.63,3560.71,2492497.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257705',4908539,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257705',4908540,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257706',4908541,'2961','454',374486.05,378302.91,3816.86,629781.90,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257706',4908542,'2962','454',499128.76,500273.31,1144.55,188850.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257706',4908543,'2963','454',242396.75,242396.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257706',4908544,'2964','454',433626.48,437525.04,3898.56,643262.40,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257706',4908545,'2965','454',257541.75,257541.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257706',4908546,'2966','454',495210.91,499093.06,3882.15,640554.75,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257706',4908547,'2967','454',267850.75,271051.26,3200.51,528084.15,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257706',4908548,'2968','454',389425.40,392296.52,2871.12,473734.80,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257706',4908549,'2969','454',229162.96,229162.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257706',4908550,'2970','454',432913.87,436795.60,3881.73,640485.45,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257706',4908551,'2971','454',385444.51,385444.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257706',4908552,'2972','454',291369.40,295200.02,3830.62,632052.30,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257706',4908553,'2973','454',127048.40,127048.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257706',4908554,'2974','454',242024.43,242024.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257706',4908555,'2975','454',186433.82,186433.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257706',4908556,'2976','454',225495.30,225495.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257706',4908557,'2977','454',197506.41,197506.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257706',4908558,'2978','454',306427.31,306427.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257706',4908559,'2979','454',203397.95,203397.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257706',4908560,'2980','454',269911.32,269911.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257706',4908561,'2981','454',258559.50,258559.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257706',4908562,'2982','454',256592.95,256592.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257706',4908563,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257706',4908564,'2984','454',266966.70,266966.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257706',4908565,'2985','455',351668.68,351808.69,140.01,98007.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257706',4908566,'2986','455',157697.63,158467.69,758.06,530642.00,0.00,0.00,12.00,0.00,0.00),('1','122','1007','257706',4908567,'2987','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257706',4908568,'2988','455',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257707',4908569,'2961','454',378302.91,383387.71,5084.80,838992.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257707',4908570,'2962','454',500273.31,500273.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257707',4908571,'2963','454',242396.75,242396.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257707',4908572,'2964','454',437525.04,440464.23,2939.19,484966.35,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257707',4908573,'2965','454',257541.75,260094.56,2552.81,421213.65,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257707',4908574,'2966','454',499093.06,499093.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257707',4908575,'2967','454',271051.26,275041.53,3990.27,658394.55,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257707',4908576,'2968','454',392296.52,392296.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257707',4908577,'2969','454',229162.96,229162.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257707',4908578,'2970','454',436795.60,436795.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257707',4908579,'2971','454',385444.51,385444.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1004','257707',4908580,'2972','454',295200.02,298640.51,3440.49,567680.85,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257707',4908581,'2973','454',127048.40,127048.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257707',4908582,'2974','454',242024.43,242024.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257707',4908583,'2975','454',186433.82,186433.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257707',4908584,'2976','454',225495.30,225495.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257707',4908585,'2977','454',197506.41,197506.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257707',4908586,'2978','454',306427.31,306427.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257707',4908587,'2979','454',203397.95,203397.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257707',4908588,'2980','454',269911.32,269911.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257707',4908589,'2981','454',258559.50,258559.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257707',4908590,'2982','454',256592.95,256592.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257707',4908591,'2983','454',26248.44,26248.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1006','257707',4908592,'2984','454',266966.70,266966.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','122','1007','257707',4908593,'2985','455',351808.69,352026.28,196.59,137613.00,0.00,0.00,21.00,0.00,0.00),('1','122','1007','257707',4908594,'2986','455',158467.69,158817.69,350.00,245000.00,0.00,0.00,0.00,0.00,0.00),('1','122','