-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_116
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_116`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_116` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_116`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3935 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2072,400075,'',0,'2','1','116','IBTC 0033324512','','2019-10-09 16:34:58',5,0.00,0.00,'','454','2019-10-09 16:34:58','454',0,1),(2073,400076,'',0,'2','1','116','ZENITH POS','','2019-10-09 16:38:15',5,0.00,0.00,'','454','2019-10-09 16:38:15','454',0,1),(2074,400077,'',0,'2','1','116','FIDELITY POS','','2019-10-09 16:38:30',5,0.00,0.00,'','454','2019-10-09 16:38:30','454',0,1),(2075,40003,'',0,'6.1','1','116','CASH','','2019-10-09 16:50:19',5,0.00,0.00,'','454','2019-10-09 16:50:19','454',0,1),(2076,400019,'',0,'24','1','116','PURCHASES','','2019-10-09 16:50:50',5,0.00,0.00,'','454','2019-10-09 16:50:50','454',0,1),(2077,4025,'',0,'5','1','116','INVENTORY VALUE ADJUSTMENT','','2019-10-09 16:51:12',5,0.00,0.00,'','454','2019-10-09 16:51:12','454',0,1),(2078,40001,'',0,'6','1','116','CASH IMPREST','','2019-10-09 16:51:32',5,0.00,0.00,'','454','2019-10-09 16:51:32','454',0,1),(2079,20004,'',0,'20','1','116','SALES','','2019-10-09 16:51:54',5,0.00,0.00,'','454','2019-10-09 16:51:54','454',0,1),(2080,400020,'',0,'24','1','116','GENERATOR AGO CONSUMPTION','','2019-10-09 16:52:14',5,0.00,0.00,'','454','2019-10-09 16:52:14','454',0,1),(2081,400021,'',0,'24','1','116','SALARY & WAGES','','2019-10-09 16:52:38',5,0.00,0.00,'','454','2019-10-09 16:52:38','454',0,1),(2082,400022,'',0,'24','1','116','DONATION','','2019-10-09 16:53:00',5,0.00,0.00,'','454','2019-10-09 16:53:00','454',0,1),(2083,400023,'',0,'24','1','116','CLEANING & SANITARY ITEMS','','2019-10-09 16:53:20',5,0.00,0.00,'','454','2019-10-09 16:53:20','454',0,1),(2084,400024,'',0,'24','1','116','FEES, FINES & DUES','','2019-10-09 16:53:44',5,0.00,0.00,'','454','2019-10-09 16:53:44','454',0,1),(2085,400025,'',0,'24','1','116','COMPUTER REPAIRS & INTERNET SU','','2019-10-09 16:56:40',5,0.00,0.00,'','454','2019-10-09 16:56:40','454',0,1),(2086,400026,'',0,'24','1','116','DISCOUNT ALLOWED','','2019-10-09 16:57:27',5,0.00,0.00,'','454','2019-10-09 16:57:27','454',0,1),(2087,400027,'',0,'24','1','116','OTHER OPERATING EXPENSES','','2019-10-09 16:57:41',5,0.00,0.00,'','454','2019-10-09 16:57:41','454',0,1),(2088,400028,'',0,'24','1','116','MEDICAL EXPENSES','','2019-10-09 16:58:14',5,0.00,0.00,'','454','2019-10-09 16:58:14','454',0,1),(2089,400029,'',0,'24','1','116','STAFF RENT','','2019-10-09 16:58:29',5,0.00,0.00,'','454','2019-10-09 16:58:29','454',0,1),(2090,400030,'',0,'24','1','116','TRANSPORT FARE','','2019-10-09 16:58:38',5,0.00,0.00,'','454','2019-10-09 16:58:38','454',0,1),(2091,400031,'',0,'24','1','116','PUBLIC RELATIONS','','2019-10-09 16:58:49',5,0.00,0.00,'','454','2019-10-09 16:58:49','454',0,1),(2092,400032,'',0,'24','1','116','STATION REPAIRS & MAINTENANCE','','2019-10-09 16:59:02',5,0.00,0.00,'','454','2019-10-09 16:59:02','454',0,1),(2093,400033,'',0,'24','1','116','PRINTING & STATIONARIES','','2019-10-09 16:59:12',5,0.00,0.00,'','454','2019-10-09 16:59:12','454',0,1),(2094,400034,'',0,'24','1','116','FUELING & REPAIRS OF OFFICIAL ','','2019-10-09 16:59:35',5,0.00,0.00,'','454','2019-10-09 16:59:35','454',0,1),(2095,400035,'',0,'24','1','116','PUMP & GENERATOR MAINTENANCE','','2019-10-09 17:00:02',5,0.00,0.00,'','454','2019-10-09 17:00:02','454',0,1),(2096,400036,'',0,'24','1','116','ELECTRICITY & WATER BILL','','2019-10-09 17:00:24',5,0.00,0.00,'','454','2019-10-09 17:00:24','454',0,1),(2097,400037,'',0,'24','1','116','WEIGHT & MEASURE','','2019-10-09 17:00:34',5,0.00,0.00,'','454','2019-10-09 17:00:34','454',0,1),(2450,400171,'',0,'2','1','116','IBAL PETROLEUM','','2020-04-20 13:34:32',5,0.00,0.00,'','454','2020-04-20 13:34:32','454',0,1),(3002,400376,'',0,'2','1','116','ZENITH BANK  1017823659','','2020-12-09 09:10:16',5,0.00,0.00,'','454','2020-12-09 09:10:16','454',0,1),(3428,400619,'',0,'2','1','116','CASH IMPRESS','','2021-06-25 12:38:15',5,0.00,0.00,'','454','2021-06-25 12:38:15','454',0,1),(3932,40032,'',0,'14','1','116','CASH IMPRESS','','2021-11-30 10:56:48',5,0.00,0.00,'','454','2021-11-30 10:56:48','454',0,0),(3933,400620,'',0,'2','1','116','KEYSTONE SURPLUS ACCOUNT','','2022-02-03 11:29:49',5,0.00,0.00,'','454','2022-02-03 11:29:49','454',0,0),(3934,400621,'',0,'2','1','116','MONIE POINT POS ACCOUNT','','2023-03-10 10:10:19',5,0.00,0.00,'','761','2023-03-10 10:10:19','761',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=80875 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (79220,'1','116','0000-00-00','2021-03-23 15:16:41',10,'454','','0000-00-00 00:00:00','454','2021-03-23 15:17:07'),(80181,'1','116','0000-00-00','2021-09-17 14:11:54',10,'461','','0000-00-00 00:00:00','454','2021-11-01 11:17:23'),(80199,'1','116','0000-00-00','2021-09-21 14:21:40',10,'461','','0000-00-00 00:00:00','454','2021-11-01 11:17:46'),(80651,'1','116','0000-00-00','2021-10-24 07:24:22',10,'461','','0000-00-00 00:00:00','454','2021-11-01 11:18:17'),(80682,'1','116','0000-00-00','2021-10-26 08:33:03',10,'461','','0000-00-00 00:00:00','454','2021-11-01 11:18:44'),(80838,'1','116','0000-00-00','2021-11-02 06:14:47',10,'461','','0000-00-00 00:00:00','454','2021-11-02 10:18:50'),(80839,'1','116','0000-00-00','2022-02-08 17:52:44',10,'461','','0000-00-00 00:00:00','454','2022-02-16 21:02:14'),(80840,'1','116','0000-00-00','2022-02-16 13:16:41',10,'461','','0000-00-00 00:00:00','454','2022-02-16 21:07:01'),(80841,'1','116','0000-00-00','2022-02-16 13:18:05',10,'461','','0000-00-00 00:00:00','454','2022-02-16 21:07:27'),(80842,'1','116','0000-00-00','2022-02-16 13:19:49',10,'461','','0000-00-00 00:00:00','454','2022-02-16 21:08:03'),(80843,'1','116','0000-00-00','2022-02-24 12:21:34',10,'461','','0000-00-00 00:00:00','454','2022-02-26 17:08:41'),(80844,'1','116','0000-00-00','2022-02-26 17:12:25',10,'461','','0000-00-00 00:00:00','761','2022-03-08 15:20:18'),(80845,'1','116','0000-00-00','2022-03-04 06:43:36',10,'461','','0000-00-00 00:00:00','761','2022-03-08 15:20:28'),(80846,'1','116','0000-00-00','2022-03-06 12:01:20',10,'461','','0000-00-00 00:00:00','761','2022-03-08 15:20:38'),(80847,'1','116','0000-00-00','2022-03-07 10:58:42',10,'461','','0000-00-00 00:00:00','761','2022-03-08 15:20:04'),(80848,'1','116','0000-00-00','2022-03-08 18:09:34',10,'461','','0000-00-00 00:00:00','761','2022-04-19 07:51:21'),(80849,'1','116','0000-00-00','2022-03-16 15:03:02',10,'461','','0000-00-00 00:00:00','761','2022-04-19 07:51:29'),(80850,'1','116','0000-00-00','2022-03-17 19:56:31',10,'461','','0000-00-00 00:00:00','761','2022-04-19 07:51:36'),(80851,'1','116','0000-00-00','2022-03-23 15:31:21',10,'461','','0000-00-00 00:00:00','761','2022-04-19 07:51:45'),(80852,'1','116','0000-00-00','2022-04-26 13:28:56',10,'461','','0000-00-00 00:00:00','761','2022-06-09 15:11:45'),(80853,'1','116','0000-00-00','2022-06-07 13:50:54',10,'461','','0000-00-00 00:00:00','761','2022-06-09 15:12:26'),(80854,'1','116','0000-00-00','2022-06-11 12:27:20',10,'461','','0000-00-00 00:00:00','761','2022-08-27 13:47:37'),(80855,'1','116','0000-00-00','2022-06-16 13:40:33',10,'461','','0000-00-00 00:00:00','761','2022-08-27 13:48:17'),(80856,'1','116','0000-00-00','2022-07-08 10:18:31',10,'461','','0000-00-00 00:00:00','761','2022-08-27 13:49:17'),(80857,'1','116','0000-00-00','2022-07-08 18:50:28',10,'461','','0000-00-00 00:00:00','761','2022-08-27 13:49:58'),(80858,'1','116','0000-00-00','2022-07-10 13:54:42',10,'461','','0000-00-00 00:00:00','761','2022-09-23 15:10:17'),(80859,'1','116','0000-00-00','2022-07-21 18:29:18',10,'461','','0000-00-00 00:00:00','761','2022-09-23 15:12:07'),(80860,'1','116','0000-00-00','2022-07-24 11:32:51',10,'461','','0000-00-00 00:00:00','761','2022-09-23 15:12:23'),(80861,'1','116','0000-00-00','2022-08-17 20:13:03',10,'461','','0000-00-00 00:00:00','761','2022-09-23 15:07:31'),(80862,'1','116','0000-00-00','2022-09-30 11:43:04',10,'461','','0000-00-00 00:00:00','761','2022-10-13 14:55:00'),(80863,'1','116','0000-00-00','2022-10-09 12:10:58',10,'461','','0000-00-00 00:00:00','761','2022-10-13 14:54:47'),(80864,'1','116','0000-00-00','2022-10-13 13:31:25',10,'461','','0000-00-00 00:00:00','761','2022-10-13 14:54:36'),(80865,'1','116','0000-00-00','2022-10-31 09:42:43',5,'461','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(80866,'1','116','0000-00-00','2022-11-10 13:10:37',5,'461','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(80867,'1','116','0000-00-00','2022-11-19 16:27:17',5,'461','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(80868,'1','116','0000-00-00','2022-11-30 06:55:47',5,'461','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(80869,'1','116','0000-00-00','2022-12-10 07:37:43',5,'461','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(80870,'1','116','0000-00-00','2022-12-24 21:54:26',5,'461','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(80871,'1','116','0000-00-00','2023-01-17 17:11:43',5,'461','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(80872,'1','116','0000-00-00','2023-01-29 18:54:46',5,'461','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(80873,'1','116','0000-00-00','2023-02-04 12:38:17',5,'461','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(80874,'1','116','0000-00-00','2023-02-11 20:32:57',5,'461','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=170639 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (166660,'1','116','79220','1473','customer',231583.18,'Being a reconciliable balance as at 22/03/2021',0.00,'2020-03-22'),(166661,'1','116','79220','2079','20',0.00,'Being a reconciliable balance as at 22/03/2021',231583.18,'2020-03-22'),(168814,'1','116','80181','2077','5',0.00,'AGO PRICE CHANGE FROM 290 TO 295 DIPPING 3,150',15750.00,'2021-09-16'),(168816,'1','116','80181','120','supplier',15750.00,'AGO PRICE CHANGE FROM 290 TO 295 DIPPING 3,150',0.00,'2021-09-16'),(168862,'1','116','80199','120','supplier',4250.00,'AGO PRICE CHANGE FROM 295 TO 300 DIPPING 850',0.00,'2021-09-21'),(168866,'1','116','80199','2077','5',0.00,'AGO PRICE CHANGE FROM 295 TO 300 DIPPING 850',4250.00,'2021-09-21'),(170055,'1','116','80651','2077','5',310500.00,'AGO PRICE CHANGE FROM 350 TO 335 DIPPING 20,700',0.00,'2021-10-24'),(170056,'1','116','80651','120','supplier',0.00,'AGO PRICE CHANGE FROM 350 TO 335 DIPPING 20,700',310500.00,'2021-10-24'),(170168,'1','116','80682','120','supplier',106500.00,'AGO PRICE CHANGE FROM 335 TO 345 DIPPING 10,650',0.00,'2021-10-26'),(170169,'1','116','80682','2077','5',0.00,'AGO PRICE CHANGE FROM 335 TO 345 DIPPING 10,650',106500.00,'2021-10-26'),(170558,'1','116','80838','120','supplier',53600.00,'PMS PRICE CHANGE FROM 163 TO 165 DIPPING 26,800',0.00,'2021-11-01'),(170559,'1','116','80838','2077','5',0.00,'PMS PRICE CHANGE FROM 163 TO 165 DIPPING 26,800',53600.00,'2021-11-01'),(170562,'1','116','80839','120','supplier',4000.00,'AGO PRICE CHANGE FROM 360 TO 380 DIPPING 200',0.00,'2022-02-04'),(170563,'1','116','80839','2077','5',0.00,'AGO PRICE CHANGE FROM 360 TO 380 DIPPING 200',4000.00,'2022-02-04'),(170564,'1','116','80840','2077','5',0.00,'AGO PRICE CHANGE FROM 380 TO 390 DIPPING 200',2000.00,'2022-02-08'),(170565,'1','116','80840','120','supplier',2000.00,'AGO PRICE CHANGE FROM 380 TO 390 DIPPING 200',0.00,'2022-02-16'),(170566,'1','116','80841','2077','5',0.00,'AGO PRICE CHANGE FROM 390 TO 400 DIPPING 200',2000.00,'2022-02-16'),(170567,'1','116','80841','120','supplier',2000.00,'AGO PRICE CHANGE FROM 390 TO 400 DIPPING 200',0.00,'2022-02-16'),(170568,'1','116','80842','2077','5',0.00,'AGO PRICE CHANGE FROM 400 TO 410 DIPPING 200',2000.00,'2022-02-15'),(170569,'1','116','80842','120','supplier',2000.00,'AGO PRICE CHANGE FROM 400 TO 410 DIPPING 200',0.00,'2022-02-15'),(170570,'1','116','80843','120','supplier',68500.00,'AGO PRICE CHANGE FROM 410 TO 415 DIPPING 13,700',0.00,'2022-02-22'),(170571,'1','116','80843','2077','5',0.00,'AGO PRICE CHANGE FROM 410 TO 415 DIPPING 13,700',68500.00,'2022-02-22'),(170573,'1','116','80844','2077','5',0.00,'AGO PRICE CHANGE FROM 415 TO 420 DIPPING 11,750',58750.00,'2022-02-26'),(170574,'1','116','80844','120','supplier',58750.00,'AGO PRICE CHANGE FROM 415 TO 420 DIPPING 11,750',0.00,'2022-02-26'),(170575,'1','116','80845','120','supplier',91000.00,'AGO INCREMENT FROM 420-430 DIPPING 9,100',0.00,'2022-03-03'),(170576,'1','116','80845','2077','5',0.00,'AGO INCREMENT FROM 420-430 DIPPING 9,100',91000.00,'2022-03-03'),(170577,'1','116','80846','120','supplier',210000.00,'AGO INCREMENT FROM 430-460 DIPPING 7,000',0.00,'2022-03-04'),(170578,'1','116','80846','2077','5',0.00,'AGO INCREMENT FROM 430-460 DIPPING 7,000',210000.00,'2022-03-04'),(170579,'1','116','80847','120','supplier',144000.00,'AGO PRICE CHANGE FROM 460 TO 500 DIPPING 3,600',0.00,'2022-03-05'),(170580,'1','116','80847','2077','5',0.00,'AGO PRICE CHANGE FROM 460 TO 500 DIPPING 3,600',144000.00,'2022-03-05'),(170583,'1','116','80848','120','supplier',25000.00,'AGO PRICE CHANGE FROM 500 TO 600 DIPPING 250',0.00,'2022-03-08'),(170584,'1','116','80848','2077','5',0.00,'AGO PRICE CHANGE FROM 500 TO 600 DIPPING 250',25000.00,'2022-03-08'),(170585,'1','116','80849','120','supplier',12500.00,'AGO PRICE CHANGE FROM 600 TO 650 DIPPING 250',0.00,'2022-03-14'),(170586,'1','116','80849','2077','5',0.00,'AGO PRICE CHANGE FROM 600 TO 650 DIPPING 250',12500.00,'2022-03-14'),(170587,'1','116','80850','120','supplier',2500.00,'AGO PRICE CHANGE FROM 650 TO 660 DIPPING 250',0.00,'2022-03-17'),(170588,'1','116','80850','2077','5',0.00,'AGO PRICE CHANGE FROM 650 TO 660 DIPPING 250',2500.00,'2022-03-17'),(170590,'1','116','80851','120','supplier',5000.00,'AGO PRICE CHANGE FROM 680 TO 700 DIPPING 250',0.00,'2022-03-23'),(170591,'1','116','80851','2077','5',0.00,'AGO PRICE CHANGE FROM 680 TO 700 DIPPING 250',5000.00,'2022-03-23'),(170592,'1','116','80852','2077','5',604000.00,'AGO PRICE CHANGE FROM 700 TO 660 DIPPING 15,100',0.00,'2022-04-19'),(170593,'1','116','80852','120','supplier',0.00,'AGO PRICE CHANGE FROM 700 TO 660 DIPPING 15,100',604000.00,'2022-04-19'),(170594,'1','116','80853','2077','5',0.00,'AGO PRICE CHANGE FROM 770 TO 800 DIPPING 19,000',570000.00,'2022-06-07'),(170595,'1','116','80853','120','supplier',570000.00,'AGO PRICE CHANGE FROM 770 TO 800 DIPPING 19,000',0.00,'2022-06-07'),(170596,'1','116','80854','120','supplier',356000.00,'AGO PRICE CHANGE FROM 800 TO 820 DIPPING 17,800',0.00,'2022-06-11'),(170597,'1','116','80854','2077','5',0.00,'AGO PRICE CHANGE FROM 800 TO 820 DIPPING 17,800',356000.00,'2022-06-11'),(170598,'1','116','80855','120','supplier',147000.00,'AGO PRICE CHANGE FROM 820 TO 830 DIPPING 14,700',0.00,'2022-06-15'),(170599,'1','116','80855','2077','5',0.00,'AGO PRICE CHANGE FROM 820 TO 830 DIPPING 14,700',147000.00,'2022-06-15'),(170600,'1','116','80856','120','supplier',336000.00,'PMS PRICE CHANGE FROM 165 TO 185 DIPPING 16,800',0.00,'2022-07-08'),(170601,'1','116','80856','2077','5',0.00,'PMS PRICE CHANGE FROM 165 TO 185 DIPPING 16,800',336000.00,'2022-07-08'),(170602,'1','116','80857','2077','5',336000.00,'PMS PRICE CHANGE FROM 185 TO 165 DIPPING 16,800',0.00,'2022-07-08'),(170603,'1','116','80857','120','supplier',0.00,'PMS PRICE CHANGE FROM 185 TO 165 DIPPING 16,800',336000.00,'2022-07-08'),(170604,'1','116','80858','2077','5',0.00,'PMS PRICE CHANGE FROM 165 TO 185 DIPPING 11,400',228000.00,'2022-07-09'),(170605,'1','116','80858','120','supplier',228000.00,'PMS PRICE CHANGE FROM 165 TO 185 DIPPING 11,400',0.00,'2022-07-09'),(170606,'1','116','80859','120','supplier',0.00,'AGO PRICE CHANGE FROM 830 TO 820 DIPPING 5,600',56000.00,'2022-07-20'),(170607,'1','116','80859','2077','5',56000.00,'AGO PRICE CHANGE FROM 830 TO 820 DIPPING 5,600',0.00,'2022-07-20'),(170608,'1','116','80860','2077','5',17000.00,'AGO PRICE CHANGE FROM 820 TO 810 DIPPING 1,700',0.00,'2022-07-22'),(170609,'1','116','80860','120','supplier',0.00,'AGO PRICE CHANGE FROM 820 TO 810 DIPPING 1,700',17000.00,'2022-07-22'),(170610,'1','116','80861','120','supplier',0.00,'AGO PRICE CHANGE FROM 810 TO 800 DIPPING 17,950',179500.00,'2022-08-17'),(170611,'1','116','80861','2077','5',179500.00,'AGO PRICE CHANGE FROM 810 TO 800 DIPPING 17,950',0.00,'2022-08-17'),(170613,'1','116','80862','2077','5',0.00,'AGO PRICE CHANGE FROM 800 TO 810 DIPPING 14,700',147000.00,'2022-09-29'),(170614,'1','116','80862','120','supplier',147000.00,'AGO PRICE CHANGE FROM 800 TO 810 DIPPING 14,700',0.00,'2022-09-29'),(170615,'1','116','80863','120','supplier',108000.00,'AGO PRICE CHANGE FROM 810 TO 820 DIPPING 10,800',0.00,'2022-10-09'),(170616,'1','116','80863','2077','5',0.00,'AGO PRICE CHANGE FROM 810 TO 820 DIPPING 10,800',108000.00,'2022-10-09'),(170617,'1','116','80864','120','supplier',98500.00,'AGO PRICE CHANGE FROM 820 TO 830 DIPPING 9,850',0.00,'2022-10-12'),(170618,'1','116','80864','2077','5',0.00,'AGO PRICE CHANGE FROM 820 TO 830 DIPPING 9,850',98500.00,'2022-10-12'),(170619,'1','116','80865','120','supplier',38000.00,'PMS PRICE CHANGE FROM 185 TO 195 DIPPING 3,800',0.00,'2022-10-30'),(170620,'1','116','80865','2077','5',0.00,'PMS PRICE CHANGE FROM 185 TO 195 DIPPING 3,800',38000.00,'2022-10-30'),(170621,'1','116','80866','2077','5',0.00,'AGO PRICE INCREAMENT FROM 830-860 DIPPING  700',21000.00,'2022-11-10'),(170622,'1','116','80866','120','supplier',21000.00,'AGO PRICE INCREAMENT FROM 830-860 DIPPING  700',0.00,'2022-11-10'),(170623,'1','116','80867','120','supplier',14000.00,'AGO PRICE CHANGE FROM 860 TO 880 DIPPING 700',0.00,'2022-11-18'),(170624,'1','116','80867','2077','5',0.00,'AGO PRICE CHANGE FROM 860 TO 880 DIPPING 700',14000.00,'2022-11-18'),(170625,'1','116','80868','120','supplier',7000.00,'AGO PRICE INCREAMENT FROM 880-890 DIPPING  700',0.00,'2022-11-29'),(170626,'1','116','80868','2077','5',0.00,'AGO PRICE INCREAMENT FROM 880-890 DIPPING  700',7000.00,'2022-11-29'),(170627,'1','116','80869','120','supplier',49500.00,'PMS PRICE INCREAMENT FROM 195-210 DIPPING  3300',0.00,'2022-12-09'),(170628,'1','116','80869','2077','5',0.00,'PMS PRICE INCREAMENT FROM 195-210 DIPPING  3300',49500.00,'2022-12-09'),(170629,'1','116','80870','2077','5',0.00,'PMS PRICE INCREAMENT FROM 210-220 DIPPING  4300',43000.00,'2022-12-23'),(170630,'1','116','80870','120','supplier',43000.00,'PMS PRICE INCREAMENT FROM 210-220 DIPPING  4300',0.00,'2022-12-24'),(170631,'1','116','80871','120','supplier',8000.00,'AGO PRICE CHANGE FROM 880 TO 870 DIPPING 800',0.00,'2023-01-17'),(170632,'1','116','80871','2077','5',0.00,'AGO PRICE CHANGE FROM 880 TO 870 DIPPING 800',8000.00,'2023-01-17'),(170633,'1','116','80872','120','supplier',0.00,'AGO PRICE CHANGE FROM 870 TO 850 DIPPING 10,600',212000.00,'2023-01-29'),(170634,'1','116','80872','2077','5',212000.00,'AGO PRICE CHANGE FROM 870 TO 850 DIPPING 10,600',0.00,'2023-01-29'),(170635,'1','116','80873','2077','5',632000.00,'PMS PRICE CHANGE FROM 220 TO 200 DIPPING 31,600',0.00,'2023-02-03'),(170636,'1','116','80873','120','supplier',0.00,'PMS PRICE CHANGE FROM 220 TO 200 DIPPING 31,600',632000.00,'2023-02-03'),(170637,'1','116','80874','120','supplier',194000.00,'PMS PRICE CHANGE FROM 200 TO 210 DIPPING 19,400',0.00,'2023-02-10'),(170638,'1','116','80874','2077','5',0.00,'PMS PRICE CHANGE FROM 200 TO 210 DIPPING 19,400',194000.00,'2023-02-11');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3911 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1473,'','1','116','INDUSTRIAL TRAINING SKILL CENT','HAJIYA SAFIYA U. IBRAHIM','08134541137','safiyauibrahim@gmail.com','LOKOJA','KOGI','ZONE 8 CLOSE TO STATE SECRETERIATE ','Nigeria',200000.00,0.00,199147.00,'0000-00-00','2019-10-09 17:06:22',5,'454','2021-03-25 10:30:57','454'),(2325,'','1','116','DPR LOKOJA','SAMUEL PAUL','08033558734','sam567762@gmail.com','Lokoja','Lokoja','2. IMAM CLOSE, OFF ENIOLA ST, MOUNT PATT ROAD, LOKOJA','Nigeria',400000.00,0.00,0.00,'0000-00-00','2021-03-14 19:12:25',5,'454','2021-03-25 10:30:34','454'),(2386,'','1','116','S D EXPRESS','HAMZA IBRAHIM NUHU','08051034943','sd@gmail.com','Kano','Kano','SANI ABACHA WAY KANO.','Nigeria',0.00,0.00,4888462.20,'0000-00-00','2021-03-23 13:11:30',5,'454','2021-04-02 12:35:16','454'),(3907,'','1','116','Bajaj boxer confirm full tank','AA RANO NIG LTD','08130303535','mrmohasul@gmail.com','Kano','Kano','HEAD OFFICE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-29 16:10:46',5,'454','2021-11-29 16:10:46','454'),(3908,'','1','116','COMMAND ARMY RECORDS LOKOJA','MAJOR MOHAMMED','08063316084','garba6437@gmail.com','LOKOJA ','KOGI','CHARI MAIGUMERI, LOKOJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-01 12:21:53',5,'761','2022-07-01 12:21:53','761'),(3909,'','1','116','STANDART ORGANIZATION OF NIGER','ENGR OLUWA','08037437698','standartorg.ng@gmail.com','LOKOJA ','KOGI','NO 1 ALFA IMAM CLOSE BY JUCKET HOTEL','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-17 14:22:08',5,'761','2022-10-17 14:22:08','761'),(3910,'','1','116','NIGERIA POLICE FORCE(ELECTION)','CP YUSUF C. USMAN','08071785115','dopstransport@gmail.com','FCT','ABUJA','NPF HEADQURTER ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 11:12:27',5,'761','2023-02-21 11:12:27','761');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18330 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','116',10280,'717',0.00,34100.00,'2019-09-30','','2019-10-16 00:27:17','454','454',2019,'454','2019-10-16 00:27:17',5),('1','116',10281,'718',0.00,14300.00,'2019-09-30','','2019-10-16 00:27:54','454','454',2019,'454','2019-10-16 00:27:54',5),('1','116',10282,'718',14300.00,14300.00,'2019-09-30','','2019-10-16 00:27:55','454','454',2019,'454','2019-10-16 00:27:55',5),('1','116',10283,'719',0.00,35700.00,'2019-09-30','','2019-10-16 00:28:48','454','454',2019,'454','2019-10-16 00:28:48',5),('1','116',10284,'720',0.00,39100.00,'2019-09-30','','2019-10-16 00:29:22','454','454',2019,'454','2019-10-16 00:29:22',5),('1','116',10288,'717',34100.00,48400.00,'2019-09-30','','2019-10-16 10:07:28','454','454',2019,'454','2019-10-16 10:07:28',5),('1','116',10317,'717',1662.00,40000.00,'2019-10-02','','2019-10-18 23:16:56','461','461',2019,'461','2019-10-18 23:16:56',5),('1','116',10318,'720',705.00,20000.00,'2019-10-02','','2019-10-18 23:18:15','461','461',2019,'461','2019-10-18 23:18:15',5),('1','116',10319,'717',4910.00,55000.00,'2019-10-04','','2019-10-19 00:22:04','461','461',2019,'461','2019-10-19 00:22:04',5),('1','116',10320,'717',55000.00,32000.00,'2019-10-05','','2019-10-19 00:23:29','461','461',2019,'461','2019-10-19 00:23:29',5),('1','116',10321,'720',4963.00,18000.00,'2019-10-05','','2019-10-19 00:24:45','461','461',2019,'461','2019-10-19 00:24:45',5),('1','116',10322,'717',32000.00,45000.00,'2019-10-08','','2019-10-19 00:27:43','461','461',2019,'461','2019-10-19 00:27:43',5),('1','116',10323,'720',18000.00,15000.00,'2019-10-08','','2019-10-19 00:28:23','461','461',2019,'461','2019-10-19 00:28:23',5),('1','116',10324,'717',45000.00,50000.00,'2019-10-09','','2019-10-19 00:29:45','461','461',2019,'461','2019-10-19 00:29:45',5),('1','116',10325,'717',50000.00,49000.00,'2019-10-10','NSR 173 YW','2019-10-19 00:31:35','461','461',2019,'461','2019-10-19 00:31:35',5),('1','116',10326,'720',15000.00,45000.00,'2019-10-11','RAN 681 XA','2019-10-19 00:33:53','461','461',2019,'461','2019-10-19 00:33:53',5),('1','116',10327,'717',49000.00,60000.00,'2019-10-14','ABS 339 XA','2019-10-19 00:36:27','461','461',2019,'461','2019-10-19 00:36:27',5),('1','116',10328,'720',45000.00,45000.00,'2019-10-16','RAN 825 XA','2019-10-19 00:39:18','461','461',2019,'461','2019-10-19 00:39:18',5),('1','116',10329,'720',45000.00,45000.00,'2019-10-16','RAN 825 XA','2019-10-19 00:39:58','461','461',2019,'461','2019-10-19 00:39:58',5),('1','116',10330,'720',45000.00,45000.00,'2019-10-16','RAN 825 X','2019-10-19 00:40:23','461','461',2019,'461','2019-10-19 00:40:23',5),('1','116',10331,'720',45000.00,45000.00,'2019-10-16','RAN 825','2019-10-19 00:40:59','461','461',2019,'461','2019-10-19 00:40:59',5),('1','116',10332,'720',45000.00,45000.00,'2019-10-16','RAN 825 XA','2019-10-19 00:42:36','461','461',2019,'461','2019-10-19 00:42:36',5),('1','116',10333,'720',45000.00,45000.00,'2019-10-16','','2019-10-19 00:42:50','461','461',2019,'461','2019-10-19 00:42:50',5),('1','116',10334,'717',60000.00,60000.00,'2019-10-17','RAN 605 XA','2019-10-19 00:49:56','461','461',2019,'461','2019-10-19 00:49:56',5),('1','116',10335,'717',60000.00,60000.00,'2019-10-17','RAN 605 XA','2019-10-19 00:51:30','461','461',2019,'461','2019-10-19 00:51:30',5),('1','116',10336,'717',60000.00,60000.00,'2019-10-17','RAN 605 XA','2019-10-19 00:51:54','461','461',2019,'461','2019-10-19 00:51:54',5),('1','116',10360,'719',1789.00,200.00,'2019-10-20','','2019-10-20 17:05:05','461','461',2019,'461','2019-10-20 17:05:05',5),('1','116',10361,'719',200.00,1900.00,'2019-10-20','','2019-10-20 17:07:54','461','461',2019,'461','2019-10-20 17:07:54',5),('1','116',11671,'719',55.00,2000.00,'2020-03-05','no approval','2020-03-05 20:28:35','461','461',2020,'461','2020-03-05 20:28:35',5),('1','116',11672,'720',3460.00,3200.00,'2020-03-05','','2020-03-05 20:59:53','461','461',2020,'461','2020-03-05 20:59:53',5),('1','116',11673,'717',8734.00,9000.00,'2020-03-05','','2020-03-05 21:05:52','461','461',2020,'461','2020-03-05 21:05:52',5),('1','116',11794,'719',642.00,1500.00,'2020-03-22','','2020-03-22 09:29:35','461','461',2020,'461','2020-03-22 09:29:35',5),('1','116',11796,'719',53.00,1550.00,'2020-03-22','','2020-03-22 12:50:53','461','461',2020,'461','2020-03-22 12:50:53',5),('1','116',12323,'719',653.00,300.00,'2020-07-06','','2020-07-06 08:39:22','461','461',2020,'461','2020-07-06 08:39:22',5),('1','116',12405,'719',444.00,2500.00,'2020-07-23','','2020-07-23 19:48:19','461','461',2020,'461','2020-07-23 19:48:19',5),('1','116',12833,'719',2098.00,800.00,'2020-10-06','','2020-10-06 16:35:26','461','461',2020,'461','2020-10-06 16:35:26',5),('1','116',13295,'719',1538.00,1000.00,'2020-12-14','','2020-12-14 13:35:51','461','461',2020,'461','2020-12-14 13:35:51',5),('1','116',13567,'719',388.00,500.00,'2021-02-01','','2021-02-01 17:27:34','461','461',2021,'461','2021-02-01 17:27:34',5),('1','116',13758,'720',554.00,3500.00,'2021-02-23','','2021-02-23 10:06:45','461','461',2021,'461','2021-02-23 10:06:45',5),('1','116',13759,'720',3500.00,500.00,'2021-02-23','','2021-02-23 10:18:06','461','461',2021,'461','2021-02-23 10:18:06',5),('1','116',13760,'720',500.00,4000.00,'2021-02-23','','2021-02-23 10:20:14','461','461',2021,'461','2021-02-23 10:20:14',5),('1','116',13765,'720',796.00,2750.00,'2021-02-25','','2021-02-25 15:41:46','461','461',2021,'461','2021-02-25 15:41:46',5),('1','116',13770,'720',2.00,4000.00,'2021-02-26','','2021-02-26 16:23:38','461','461',2021,'461','2021-02-26 16:23:38',5),('1','116',13802,'720',518.00,2000.00,'2021-02-28','','2021-02-28 13:58:12','461','461',2021,'461','2021-02-28 13:58:12',5),('1','116',14636,'717',118083.00,6150.00,'2021-04-28','','2021-04-29 10:14:08','461','461',2021,'461','2021-04-29 10:14:08',5),('1','116',14637,'719',33834.00,34650.00,'2021-04-28','','2021-04-29 10:14:59','461','461',2021,'461','2021-04-29 10:14:59',5),('1','116',14638,'720',17791.00,600.00,'2021-04-28','','2021-04-29 10:15:41','461','461',2021,'461','2021-04-29 10:15:41',5),('1','116',15549,'719',786.23,200.00,'2021-06-30','','2021-06-30 15:05:12','461','461',2021,'461','2021-06-30 15:05:12',5),('1','116',15550,'719',200.00,800.00,'2021-06-30','','2021-06-30 15:07:47','461','461',2021,'461','2021-06-30 15:07:47',5),('1','116',17010,'717',50699.36,25200.00,'2021-10-27','','2021-10-27 13:05:26','454','454',2021,'454','2021-10-27 13:05:26',5),('1','116',17011,'719',10261.63,7800.00,'2021-10-27','','2021-10-27 13:05:57','454','454',2021,'454','2021-10-27 13:05:57',5),('1','116',18310,'719',15935.57,16400.00,'2022-01-01','RECONCILLING THE MANUEL AND SYTEM DIPPING(500LTS DIFF)','2022-01-02 12:20:19','533','533',2022,'533','2022-01-02 12:20:19',5),('1','116',18311,'719',2330.96,2850.00,'2022-03-08','','2022-03-08 18:22:54','761','761',2022,'761','2022-03-08 18:22:54',5),('1','116',18312,'717',10789.73,17300.00,'2022-06-08','TANK RECONCILIATION\r\n','2022-06-08 13:08:57','761','761',2022,'761','2022-06-08 13:08:57',5),('1','116',18313,'720',600.00,600.00,'2022-06-08','TANK RECONCILIATION','2022-06-08 13:09:25','761','761',2022,'761','2022-06-08 13:09:25',5),('1','116',18314,'719',18773.18,18850.00,'2022-06-08','TANK RECONCILIATION','2022-06-08 13:09:55','761','761',2022,'761','2022-06-08 13:09:55',5),('1','116',18315,'717',3098.58,6200.00,'2022-08-30','','2022-08-30 10:04:33','761','761',2022,'761','2022-08-30 10:04:33',5),('1','116',18316,'717',8554.95,14600.00,'2022-09-16','','2022-09-16 16:18:46','761','761',2022,'761','2022-09-16 16:18:46',5),('1','116',18317,'717',1030.54,2550.00,'2022-12-04','','2022-12-04 09:55:38','913','913',2022,'913','2022-12-04 09:55:38',5),('1','116',18318,'717',176.81,250.00,'2022-12-08','','2022-12-08 16:26:13','913','913',2022,'913','2022-12-08 16:26:13',5),('1','116',18319,'717',22564.59,23200.00,'2022-12-11','','2022-12-11 09:42:42','913','913',2022,'913','2022-12-11 09:42:42',5),('1','116',18320,'717',1028.40,1200.00,'2022-12-16','','2022-12-16 18:42:56','913','913',2022,'913','2022-12-16 18:42:56',5),('1','116',18321,'717',27822.12,28150.00,'2022-12-21','','2022-12-21 09:37:33','913','913',2022,'913','2022-12-21 09:37:33',5),('1','116',18322,'717',14097.16,14400.00,'2022-12-22','','2022-12-22 09:01:21','913','913',2022,'913','2022-12-22 09:01:21',5),('1','116',18323,'717',20184.49,20250.00,'2023-01-17','','2023-01-17 11:05:07','913','913',2023,'913','2023-01-17 11:05:07',5),('1','116',18324,'717',28059.36,28350.00,'2023-01-24','','2023-01-24 09:47:19','913','913',2023,'913','2023-01-24 09:47:19',5),('1','116',18325,'717',367.62,550.00,'2023-01-25','','2023-01-25 08:09:13','913','913',2023,'913','2023-01-25 08:09:13',5),('1','116',18326,'717',30271.37,31100.00,'2023-01-29','','2023-01-29 17:43:39','913','913',2023,'913','2023-01-29 17:43:39',5),('1','116',18327,'717',13004.82,13100.00,'2023-01-31','','2023-01-31 10:38:40','913','913',2023,'913','2023-01-31 10:38:40',5),('1','116',18328,'717',12824.70,14100.00,'2023-02-06','','2023-02-06 09:32:29','913','913',2023,'913','2023-02-06 09:32:29',5),('1','116',18329,'717',231.23,1275.00,'2023-02-26','','2023-02-26 13:45:23','913','913',2023,'913','2023-02-26 13:45:23',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1973 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','116','717',1950,'5','PMS PUMP 1',2047325.27,'',NULL,NULL,NULL,NULL,5,'2020-01-21 15:33:13','454'),('1','116','717',1951,'5','PMS PUMP 2',3554423.76,'',NULL,NULL,NULL,NULL,5,'2020-01-21 15:33:59','454'),('1','116','717',1952,'5','PMS PUMP 3',2210684.86,'',NULL,NULL,NULL,NULL,5,'2019-10-16 10:21:26','454'),('1','116','717',1953,'5','PMS PUMP 4',2402324.26,'',NULL,NULL,NULL,NULL,5,'2019-10-16 10:23:23','454'),('1','116','717',1954,'5','PMS PUMP 5',1526817.53,'',NULL,NULL,NULL,NULL,5,'2019-10-16 10:24:02','454'),('1','116','717',1955,'5','PMS PUMP 6',3150524.72,'',NULL,NULL,NULL,NULL,5,'2019-10-16 10:25:18','454'),('1','116','717',1956,'5','PMS PUMP 7',1949589.94,'',NULL,NULL,NULL,NULL,5,'2019-10-16 10:26:06','454'),('1','116','717',1957,'5','PMS PUMP 8',2513600.54,'',NULL,NULL,NULL,NULL,5,'2019-10-16 10:27:26','454'),('1','116','719',1966,'5','AGO PUMP 1',1314721.23,'',NULL,NULL,NULL,NULL,0,'2019-10-16 10:31:14','454'),('1','116','717',1967,'5','PMS PUMP 9',312080.54,'',NULL,NULL,NULL,NULL,5,'2019-10-16 10:30:05','454'),('1','116','717',1968,'5','PMS PUMP 10',2983565.91,'',NULL,NULL,NULL,NULL,5,'2019-10-16 10:31:54','454'),('1','116','717',1969,'5','PMS PUMP 11',1644943.12,'',NULL,NULL,NULL,NULL,5,'2019-10-16 10:32:23','454'),('1','116','717',1970,'5','PMS PUMP 12',857066.95,'',NULL,NULL,NULL,NULL,5,'2019-10-16 10:33:01','454'),('1','116','719',1971,'5','AGO PUMP  1',220819.25,'','',NULL,NULL,'',5,'2021-10-25 09:44:47','454'),('1','116','719',1972,'5','AGO PUMP 2',81165.77,'','',NULL,NULL,'',5,'2021-10-25 09:46:31','454');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
INSERT INTO `depots_nozzles_status` VALUES (17,'1','116','1966',0,'INACTIVE','2021-10-25 09:48:12');
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=293 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (145,'1','116','1967','717','TANK SWAP','2021-04-26 08:20:33',0,'178'),(146,'1','116','1968','717','TANK SWAP','2021-04-26 08:20:57',0,'178'),(147,'1','116','1969','717','TANK SWAP','2021-04-26 08:21:25',0,'178'),(148,'1','116','1970','717','TANK SWAP','2021-04-26 08:21:57',0,'178'),(149,'1','116','1971','717','TANK SWAP','2021-04-26 08:22:21',0,'178'),(150,'1','116','1972','717','TANK SWAP','2021-04-26 08:22:42',0,'178'),(291,'1','116','1971','719','PUMP SWAP','2021-10-25 09:45:21',0,'454'),(292,'1','116','1972','719','PUMP SWAP','2021-10-25 09:47:05',0,'454');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258114 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','116',110349,'MORNING SHIFT','2019-09-30','2019-09-30 00:00:00',NULL,'461',2310530.28,2310530.28,'461','2019-10-18 18:56:41','461','2019-10-18 19:10:50',10,0),('1','116',110355,'AFTERNOON','2019-09-30','2019-09-30 00:00:00',NULL,'461',3332074.60,3332074.60,'461','2019-10-18 19:21:40','461','2019-10-18 19:28:59',10,0),('1','116',110356,'MORNING ','2019-10-01','2019-10-01 00:00:00',NULL,'461',1870629.21,1870629.21,'461','2019-10-18 19:45:34','461','2019-10-18 19:50:15',10,0),('1','116',110357,'AFTERNOON','2019-10-01','2019-10-01 00:00:00',NULL,'461',2560879.92,2560879.92,'461','2019-10-18 20:02:33','461','2019-10-18 20:06:13',10,0),('1','116',110359,'MORNING SHIFT','2019-10-02','2019-10-02 00:00:00',NULL,'461',1969263.94,1969263.94,'461','2019-10-18 22:33:55','461','2019-10-18 22:35:34',10,0),('1','116',110360,'AFTERNOON','2019-10-02','2019-10-02 00:00:00',NULL,'461',1187354.96,1187354.96,'461','2019-10-18 22:45:57','461','2019-10-18 22:47:27',10,0),('1','116',110361,'MORNING SHIFT','2019-10-03','2019-10-03 00:00:00',NULL,'461',2045349.97,2045349.97,'461','2019-10-18 23:24:38','461','2019-10-18 23:26:04',10,0),('1','116',110362,'AFTERNOON','2019-10-03','2019-10-03 00:00:00',NULL,'461',3234864.28,3234864.28,'461','2019-10-18 23:33:36','461','2019-10-18 23:35:05',10,0),('1','116',110363,'MORNING SHIFT','2019-10-04','2019-10-04 00:00:00',NULL,'461',2356513.81,2356513.81,'461','2019-10-18 23:43:12','461','2019-10-18 23:44:20',10,0),('1','116',110364,'MORNING SHIFT','2019-10-05','2019-10-05 00:00:00',NULL,'461',2364607.66,2364607.66,'461','2019-10-19 01:13:18','461','2019-10-19 01:14:41',10,0),('1','116',110365,'AFTERNOON','2019-10-05','2019-10-05 00:00:00',NULL,'461',2802859.99,2802859.99,'461','2019-10-19 01:30:30','461','2019-10-19 01:32:04',10,0),('1','116',110366,'MORNING SHIFT','2019-10-06','2019-10-06 00:00:00',NULL,'461',1595841.72,1595841.72,'461','2019-10-19 02:10:16','461','2019-10-19 02:11:13',10,0),('1','116',110458,'AFTERNOON','2019-10-06','2019-10-06 00:00:00',NULL,'461',2281265.99,2281265.99,'461','2019-10-19 14:59:57','461','2019-10-19 15:03:51',10,0),('1','116',110462,'MORNING SHIFT','2019-10-07','2019-10-07 00:00:00',NULL,'461',1965310.83,1965310.83,'461','2019-10-19 15:33:45','461','2019-10-19 15:42:07',10,0),('1','116',110471,'AFTERNOON','2019-10-07','2019-10-07 00:00:00',NULL,'461',3140933.98,3140933.98,'461','2019-10-19 17:50:49','461','2019-10-19 17:53:47',10,0),('1','116',110495,'MORNING SHIFT','2019-10-08','2019-10-08 00:00:00',NULL,'461',2119052.18,2119052.18,'461','2019-10-19 18:10:48','461','2019-10-19 18:15:18',10,0),('1','116',110497,'AFTERNOON','2019-10-08','2019-10-08 00:00:00',NULL,'461',2857637.75,2857637.75,'461','2019-10-19 18:40:22','461','2019-10-19 18:43:30',10,0),('1','116',110504,'MORNING SHIFT','2019-10-09','2019-10-09 00:00:00',NULL,'461',1935911.63,1935911.63,'461','2019-10-19 19:30:01','461','2019-10-19 19:35:09',10,0),('1','116',110509,'AFTERNOON','2019-10-09','2019-10-09 00:00:00',NULL,'461',2514782.29,2514782.29,'461','2019-10-19 20:15:36','461','2019-10-19 20:20:28',10,0),('1','116',110510,'MORNING SHIFT','2019-10-10','2019-10-10 00:00:00',NULL,'461',1969044.54,1969044.54,'461','2019-10-19 20:28:06','461','2019-10-19 20:29:40',10,0),('1','116',110511,'AFTERNOON','2019-10-10','2019-10-10 00:00:00',NULL,'461',2943690.23,2943690.23,'461','2019-10-19 20:47:39','461','2019-10-19 20:48:41',10,0),('1','116',110528,'MORNING SHIFT','2019-10-11','2019-10-11 00:00:00',NULL,'461',2589651.16,2589651.16,'461','2019-10-20 09:27:24','461','2019-10-20 09:30:05',10,0),('1','116',110530,'AFTERNOON','2019-10-11','2019-10-11 00:00:00',NULL,'461',3289048.13,3289048.13,'461','2019-10-20 10:14:31','461','2019-10-20 10:26:10',10,0),('1','116',110542,'MORNING SHIFT','2019-10-12','2019-10-12 00:00:00',NULL,'461',2673595.55,2673595.55,'461','2019-10-20 10:39:26','461','2019-10-20 10:49:02',10,0),('1','116',110544,'AFTERNOON','2019-10-12','2019-10-12 00:00:00',NULL,'461',2733000.13,2733000.13,'461','2019-10-20 11:17:19','461','2019-10-20 11:22:00',10,0),('1','116',110553,'MORNING SHIFT','2019-10-13','2019-10-13 00:00:00',NULL,'461',2218307.78,2218307.78,'461','2019-10-20 11:51:04','461','2019-10-20 11:55:06',10,0),('1','116',110556,'AFTERNOON','2019-10-13','2019-10-13 00:00:00',NULL,'461',1967089.33,1967089.33,'461','2019-10-20 12:01:38','461','2019-10-20 12:04:07',10,0),('1','116',110557,'MORNING SHIFT','2019-10-14','2019-10-14 00:00:00',NULL,'461',1648867.50,1648867.50,'461','2019-10-20 12:12:58','461','2019-10-20 12:15:05',10,0),('1','116',110558,'AFTERNOON','2019-10-14','2019-10-14 00:00:00',NULL,'461',2355540.10,2355540.10,'461','2019-10-20 13:07:42','461','2019-10-20 13:11:34',10,0),('1','116',110571,'MORNING SHIFT','2019-10-15','2019-10-15 00:00:00',NULL,'461',1981086.47,1981086.47,'461','2019-10-20 13:31:07','461','2019-10-20 13:48:31',10,0),('1','116',110584,'AFTERNOON','2019-10-15','2019-10-15 00:00:00',NULL,'461',2948027.46,2948027.46,'461','2019-10-20 13:59:14','461','2019-10-20 14:04:27',10,0),('1','116',110585,'MORNING SHIFT','2019-10-16','2019-10-16 00:00:00',NULL,'461',1885902.15,1885902.15,'461','2019-10-20 14:13:00','461','2019-10-20 14:14:33',10,0),('1','116',110586,'AFTERNOON','2019-10-16','2019-10-16 00:00:00',NULL,'461',3284699.81,3284699.81,'461','2019-10-20 14:33:59','461','2019-10-20 14:37:13',10,0),('1','116',110593,'MORNING SHIFT','2019-10-17','2019-10-17 00:00:00',NULL,'461',2199308.95,2199308.95,'461','2019-10-20 16:06:04','461','2019-10-20 16:10:41',10,0),('1','116',110608,'AFTERNOON','2019-10-17','2019-10-17 00:00:00',NULL,'461',2428183.43,2428183.43,'461','2019-10-20 17:13:26','461','2019-10-20 17:15:36',10,0),('1','116',110610,'MORNING SHIFT','2019-10-18','2019-10-18 00:00:00',NULL,'461',2180394.39,2180394.39,'461','2019-10-20 17:24:35','461','2019-10-20 17:27:19',10,0),('1','116',110611,'AFTERNOON','2019-10-18','2019-10-18 00:00:00',NULL,'461',2669007.33,2669007.33,'461','2019-10-20 17:32:04','461','2019-10-20 17:33:00',10,0),('1','116',110616,'MORNING SHIFT','2019-10-19','2019-10-19 00:00:00',NULL,'461',2133423.06,2133423.06,'461','2019-10-20 18:35:47','461','2019-10-20 18:37:19',10,0),('1','116',110617,'AFTERNOON','2019-10-19','2019-10-19 00:00:00',NULL,'461',2100108.99,2100108.99,'461','2019-10-20 18:50:55','461','2019-10-20 18:52:18',10,0),('1','116',110619,'MORNING SHIFT','2019-10-20','2019-10-20 00:00:00',NULL,'461',1466318.22,1466318.22,'461','2019-10-20 19:57:47','461','2019-10-20 20:00:40',10,0),('1','116',110620,'AFTERNOON','2019-10-20','2019-10-20 00:00:00',NULL,'461',1931079.60,1931079.60,'461','2019-10-20 20:30:50','461','2019-10-21 12:24:55',10,0),('1','116',110685,'MORNING SHIFT','2019-10-21','2019-10-21 00:00:00',NULL,'461',1989863.91,1989863.91,'461','2019-10-21 21:21:56','461','2019-10-21 21:25:45',10,0),('1','116',110780,'AFTERNOON','2019-10-21','2019-10-21 00:00:00',NULL,'461',2717958.30,2717958.30,'461','2019-10-22 10:40:22','461','2019-10-22 12:24:45',10,0),('1','116',111046,'AFTERNOON','2019-10-22','2019-10-22 00:00:00',NULL,'461',1417606.95,1417606.95,'461','2019-10-24 11:05:17','461','2019-10-24 11:22:57',10,0),('1','116',111054,'MORNING ','2019-10-23','2019-10-23 00:00:00',NULL,'461',1904537.76,1904537.76,'461','2019-10-24 11:55:46','461','2019-10-24 11:58:48',10,0),('1','116',111063,'AFTERNOON','2019-10-23','2019-10-23 00:00:00',NULL,'461',3317924.18,3317924.18,'461','2019-10-24 15:56:42','461','2019-10-24 15:59:10',10,0),('1','116',111122,'MORNING ','2019-10-24','2019-10-24 00:00:00',NULL,'461',1910604.22,1910604.22,'461','2019-10-24 16:19:31','461','2019-10-24 16:21:58',10,0),('1','116',111177,'AFTERNOON','2019-10-24','2019-10-24 00:00:00',NULL,'461',3383998.15,3383998.15,'461','2019-10-25 11:26:29','461','2019-10-25 12:02:44',10,0),('1','116',111193,'MORNING ','2019-10-25','2019-10-25 00:00:00',NULL,'461',2447319.70,2447319.70,'461','2019-10-25 16:49:26','461','2019-10-25 16:51:33',10,0),('1','116',111327,'AFTERNOON','2019-10-25','2019-10-25 00:00:00',NULL,'461',3175242.53,3175242.53,'461','2019-10-26 15:22:56','461','2019-10-26 15:30:53',10,0),('1','116',111337,'MORNING ','2019-10-26','2019-10-26 00:00:00',NULL,'461',2628596.33,2628596.33,'461','2019-10-26 16:17:13','461','2019-10-26 16:35:54',10,0),('1','116',111400,'AFTERNOON','2019-10-26','2019-10-26 00:00:00',NULL,'461',2772225.42,2772225.42,'461','2019-10-27 13:16:02','461','2019-10-27 13:33:45',10,0),('1','116',111404,'MORNING ','2019-10-27','2019-10-27 00:00:00',NULL,'461',1812312.31,1812312.31,'461','2019-10-27 13:38:59','461','2019-10-27 15:00:22',10,0),('1','116',111684,'AFTERNOON','2019-10-27','2019-10-27 00:00:00',NULL,'461',2141186.27,2141186.27,'461','2019-10-29 13:35:11','461','2019-10-29 13:36:21',10,0),('1','116',111687,'MORNING ','2019-10-28','2019-10-28 00:00:00',NULL,'461',2133968.09,2133968.09,'461','2019-10-29 13:51:49','461','2019-10-29 13:59:19',10,0),('1','116',111689,'AFTERNOON','2019-10-28','2019-10-28 00:00:00',NULL,'461',3155661.68,3155661.68,'461','2019-10-29 14:21:23','461','2019-10-29 14:23:51',10,0),('1','116',111700,'MORNING ','2019-10-29','2019-10-29 00:00:00',NULL,'461',2542457.53,2542457.53,'461','2019-10-29 15:30:15','461','2019-10-29 15:33:24',10,0),('1','116',111837,'AFTERNOON','2019-10-29','2019-10-29 00:00:00',NULL,'461',2745831.35,2745831.35,'461','2019-10-30 15:08:14','461','2019-10-30 15:09:47',10,0),('1','116',111838,'MORNING ','2019-10-30','2019-10-30 00:00:00',NULL,'461',2028970.77,2028970.77,'461','2019-10-30 15:19:47','461','2019-10-30 15:22:40',10,0),('1','116',111962,'AFTERNOON','2019-10-30','2019-10-30 00:00:00',NULL,'461',3231701.38,3231701.38,'461','2019-10-31 15:36:52','461','2019-10-31 15:38:46',10,0),('1','116',111963,'MORNING ','2019-10-31','2019-10-31 00:00:00',NULL,'461',2367354.23,2367354.23,'461','2019-10-31 16:10:37','461','2019-10-31 16:13:58',10,0),('1','116',112018,'AFTERNOON','2019-10-31','2019-10-31 00:00:00',NULL,'461',695108.12,695108.12,'461','2019-11-01 11:49:41','461','2019-11-01 11:57:18',10,0),('1','116',112021,'MORNING ','2019-11-01','2019-11-01 00:00:00',NULL,'461',2374532.47,2374532.47,'461','2019-11-01 18:02:08','461','2019-11-01 18:04:15',10,0),('1','116',112138,'AFTERNOON','2019-11-01','2019-11-01 00:00:00',NULL,'461',3348085.80,3348085.80,'461','2019-11-02 10:38:00','461','2019-11-02 13:25:31',10,0),('1','116',112176,'MORNING ','2019-11-02','2019-11-02 00:00:00',NULL,'461',2020744.54,2020744.54,'461','2019-11-04 14:22:03','461','2019-11-04 14:26:49',10,0),('1','116',112424,'AFTERNOON','2019-11-02','2019-11-02 00:00:00',NULL,'461',2925050.13,2925050.13,'461','2019-11-04 14:44:23','461','2019-11-04 14:45:39',10,0),('1','116',112426,'MORNING ','2019-11-03','2019-11-03 00:00:00',NULL,'461',1788757.66,1788757.66,'461','2019-11-04 14:53:05','461','2019-11-04 14:54:08',10,0),('1','116',112428,'AFTERNOON','2019-11-03','2019-11-03 00:00:00',NULL,'461',2280302.60,2280302.60,'461','2019-11-04 14:58:25','461','2019-11-04 14:59:14',10,0),('1','116',112431,'MORNING ','2019-11-04','2019-11-04 00:00:00',NULL,'461',2178510.11,2178510.11,'461','2019-11-04 15:04:29','461','2019-11-04 15:20:23',10,0),('1','116',112473,'AFTERNOON','2019-11-04','2019-11-04 00:00:00',NULL,'461',2951175.19,2951175.19,'461','2019-11-05 08:10:24','461','2019-11-05 08:44:54',10,0),('1','116',112478,'MORNING ','2019-11-05','2019-11-05 00:00:00',NULL,'461',2496427.94,2496427.94,'461','2019-11-05 13:02:24','461','2019-11-05 18:33:40',10,0),('1','116',112640,'AFTERNOON','2019-11-05','2019-11-05 00:00:00',NULL,'461',2733353.62,2733353.62,'461','2019-11-06 13:28:22','461','2019-11-06 13:32:02',10,0),('1','116',112642,'MORNING ','2019-11-06','2019-11-06 00:00:00',NULL,'461',2504521.17,2504521.17,'461','2019-11-06 15:23:10','461','2019-11-06 15:27:29',10,0),('1','116',112720,'AFTERNOON','2019-11-06','2019-11-06 00:00:00',NULL,'461',2775086.85,2775086.85,'461','2019-11-07 12:42:44','461','2019-11-07 12:45:33',10,0),('1','116',112734,'MORNING ','2019-11-07','2019-11-07 00:00:00',NULL,'461',2526068.81,2526068.81,'461','2019-11-07 14:59:44','461','2019-11-07 15:03:17',10,0),('1','116',112854,'AFTERNOON','2019-11-07','2019-11-07 00:00:00',NULL,'461',2964124.59,2964124.59,'461','2019-11-08 13:45:55','461','2019-11-08 13:48:07',10,0),('1','116',112867,'MORNING ','2019-11-08','2019-11-08 00:00:00',NULL,'461',2411966.98,2411966.98,'461','2019-11-08 14:08:23','461','2019-11-09 12:25:48',10,0),('1','116',112984,'AFTERNOON','2019-11-08','2019-11-08 00:00:00',NULL,'461',3708295.50,3708295.50,'461','2019-11-09 12:32:29','461','2019-11-09 12:33:45',10,0),('1','116',112986,'MORNING ','2019-11-09','2019-11-09 00:00:00',NULL,'461',2450317.74,2450317.74,'461','2019-11-09 13:03:01','461','2019-11-10 13:00:11',10,0),('1','116',113080,'AFTERNOON','2019-11-09','2019-11-09 00:00:00',NULL,'461',2802534.63,2802534.63,'461','2019-11-11 15:22:17','461','2019-11-11 15:23:12',10,0),('1','116',113265,'MORNING ','2019-11-10','2019-11-10 00:00:00',NULL,'461',1763252.94,1763252.94,'461','2019-11-11 16:13:42','461','2019-11-11 16:14:41',10,0),('1','116',113275,'AFTERNOON','2019-11-10','2019-11-10 00:00:00',NULL,'461',1919160.87,1919160.87,'461','2019-11-11 16:25:41','461','2019-11-11 16:30:59',10,0),('1','116',113276,'MORNING ','2019-11-11','2019-11-11 00:00:00',NULL,'461',2185427.20,2185427.20,'461','2019-11-11 16:48:51','461','2019-11-11 16:50:27',10,0),('1','116',113322,'AFTERNOON','2019-11-11','2019-11-11 00:00:00',NULL,'461',2591232.05,2591232.05,'461','2019-11-12 10:27:41','461','2019-11-12 10:33:01',10,0),('1','116',113325,'MORNING ','2019-11-12','2019-11-12 00:00:00',NULL,'461',2159481.31,2159481.31,'461','2019-11-12 19:47:05','461','2019-11-12 20:08:58',10,0),('1','116',113432,'AFTERNOON','2019-11-12','2019-11-12 00:00:00',NULL,'461',3023691.42,3023691.42,'461','2019-11-13 10:41:22','461','2019-11-13 10:42:09',10,0),('1','116',113456,'MORNING ','2019-11-13','2019-11-13 00:00:00',NULL,'461',2329364.03,2329364.03,'461','2019-11-13 13:16:13','461','2019-11-20 16:29:53',10,0),('1','116',114366,'AFTERNOON','2019-11-13','2019-11-13 00:00:00',NULL,'461',2135824.77,2135824.77,'461','2019-11-20 16:38:47','461','2019-11-20 16:39:59',10,0),('1','116',114372,'MORNING ','2019-11-14','2019-11-14 00:00:00',NULL,'461',2737443.01,2737443.01,'461','2019-11-20 17:25:12','461','2019-11-20 17:26:16',10,0),('1','116',114373,'AFTERNOON','2019-11-14','2019-11-14 00:00:00',NULL,'461',2885467.38,2885467.38,'461','2019-11-20 19:43:35','461','2019-11-20 19:47:13',10,0),('1','116',114383,'MORNING ','2019-11-15','2019-11-15 00:00:00',NULL,'461',3920252.38,3920252.38,'461','2019-11-20 19:55:32','461','2019-11-20 19:58:24',10,0),('1','116',114384,'AFTERNOON','2019-11-15','2019-11-15 00:00:00',NULL,'461',4244824.56,4244824.56,'461','2019-11-20 20:08:20','461','2019-11-20 20:10:16',10,0),('1','116',114385,'MORNING ','2019-11-16','2019-11-16 00:00:00',NULL,'461',495280.20,495280.20,'461','2019-11-20 20:14:14','461','2019-11-20 20:19:08',10,0),('1','116',114386,'AFTERNOON','2019-11-16','2019-11-16 00:00:00',NULL,'461',159901.49,159901.49,'461','2019-11-20 20:22:05','461','2019-11-20 20:23:32',10,0),('1','116',114387,'MORNING ','2019-11-17','2019-11-17 00:00:00',NULL,'461',185486.63,185486.63,'461','2019-11-20 20:27:02','461','2019-11-20 20:36:25',10,0),('1','116',114388,'MORNING ','2019-11-18','2019-11-18 00:00:00',NULL,'461',1565099.92,1565099.92,'461','2019-11-20 20:40:15','461','2019-11-20 20:41:24',10,0),('1','116',114389,'AFTERNOON','2019-11-18','2019-11-18 00:00:00',NULL,'461',2008736.83,2008736.83,'461','2019-11-20 20:47:32','461','2019-11-20 20:50:18',10,0),('1','116',114390,'MORNING ','2019-11-19','2019-11-19 00:00:00',NULL,'461',2583527.38,2583527.38,'461','2019-11-20 20:54:41','461','2019-11-20 20:55:52',10,0),('1','116',114391,'AFTERNOON','2019-11-19','2019-11-19 00:00:00',NULL,'461',2986306.86,2986306.86,'461','2019-11-20 21:13:09','461','2019-11-20 21:15:35',10,0),('1','116',114392,'MORNING ','2019-11-20','2019-11-20 00:00:00',NULL,'461',2777480.09,2777480.09,'461','2019-11-20 21:26:11','461','2019-11-20 21:30:53',10,0),('1','116',114393,'AFTERNOON','2019-11-20','2019-11-20 00:00:00',NULL,'461',2852592.88,2852592.88,'461','2019-11-20 21:41:57','461','2019-11-21 14:01:58',10,0),('1','116',114464,'MORNING ','2019-11-21','2019-11-21 00:00:00',NULL,'461',2056854.42,2056854.42,'461','2019-11-21 14:10:00','461','2019-11-21 14:11:11',10,0),('1','116',114560,'AFTERNOON','2019-11-21','2019-11-21 00:00:00',NULL,'461',2991951.32,2991951.32,'461','2019-11-23 12:32:51','461','2019-11-23 12:34:54',10,0),('1','116',114669,'MORNING ','2019-11-22','2019-11-22 00:00:00',NULL,'461',2136515.12,2136515.12,'461','2019-11-23 12:50:23','461','2019-11-23 12:52:01',10,0),('1','116',114672,'AFTERNOON','2019-11-22','2019-11-22 00:00:00',NULL,'461',2643992.57,2643992.57,'461','2019-11-23 12:59:24','461','2019-11-23 13:00:05',10,0),('1','116',114674,'MORNING ','2019-11-23','2019-11-23 00:00:00',NULL,'461',1496661.38,1496661.38,'461','2019-11-23 13:04:50','461','2019-11-23 13:06:10',10,0),('1','116',114777,'AFTERNOON','2019-11-23','2019-11-23 00:00:00',NULL,'461',1137335.11,1137335.11,'461','2019-11-24 14:58:11','461','2019-11-24 14:59:20',10,0),('1','116',114824,'MORNING ','2019-11-24','2019-11-24 00:00:00',NULL,'461',1404369.38,1404369.38,'461','2019-11-24 15:03:46','461','2019-11-24 15:04:37',10,0),('1','116',114838,'AFTERNOON','2019-11-24','2019-11-24 00:00:00',NULL,'461',2565165.52,2565165.52,'461','2019-11-25 09:53:38','461','2019-11-25 10:06:27',10,0),('1','116',114905,'MORNING ','2019-11-25','2019-11-25 00:00:00',NULL,'461',1993868.57,1993868.57,'461','2019-11-25 14:56:02','461','2019-11-25 14:58:02',10,0),('1','116',115161,'AFTERNOON','2019-11-25','2019-11-25 00:00:00',NULL,'461',3522289.40,3522289.40,'461','2019-11-26 12:22:43','461','2019-11-26 12:42:07',10,0),('1','116',115175,'MORNING ','2019-11-26','2019-11-26 00:00:00',NULL,'461',1940931.61,1940931.61,'461','2019-11-26 12:58:33','461','2019-11-26 13:08:14',10,0),('1','116',115185,'AFTERNOON','2019-11-26','2019-11-26 00:00:00',NULL,'461',3126060.83,3126060.83,'461','2019-11-27 10:47:00','461','2019-11-27 10:50:07',10,0),('1','116',115274,'MORNING ','2019-11-27','2019-11-27 00:00:00',NULL,'461',2046721.31,2046721.31,'461','2019-11-27 14:31:03','461','2019-11-27 14:34:08',10,0),('1','116',115350,'AFTERNOON','2019-11-27','2019-11-27 00:00:00',NULL,'461',2913785.32,2913785.32,'461','2019-11-28 12:19:56','461','2019-11-28 12:21:11',10,0),('1','116',115475,'MORNING ','2019-11-28','2019-11-28 00:00:00',NULL,'461',2380853.89,2380853.89,'461','2019-11-28 19:29:29','461','2019-11-28 19:30:43',10,0),('1','116',115544,'AFTERNOON','2019-11-28','2019-11-28 00:00:00',NULL,'461',3280440.81,3280440.81,'461','2019-11-29 12:07:04','461','2019-11-29 12:08:04',10,0),('1','116',115597,'MORNING ','2019-11-29','2019-11-29 00:00:00',NULL,'461',2877077.00,2877077.00,'461','2019-11-30 08:53:12','461','2019-11-30 08:54:28',10,0),('1','116',115676,'AFTERNOON','2019-11-29','2019-11-29 00:00:00',NULL,'461',4152422.86,4152422.86,'461','2019-11-30 09:29:02','461','2019-11-30 11:52:19',10,0),('1','116',115694,'MORNING ','2019-11-30','2019-11-30 00:00:00',NULL,'461',2371561.86,2371561.86,'461','2019-12-05 09:44:21','461','2019-12-05 09:46:56',10,0),('1','116',116250,'AFTERNOON','2019-11-30','2019-11-30 00:00:00',NULL,'461',2150242.18,2150242.18,'461','2019-12-05 10:38:54','461','2019-12-05 10:50:36',10,0),('1','116',116258,'MORNING ','2019-12-01','2019-12-01 00:00:00',NULL,'461',1543852.33,1543852.33,'461','2019-12-05 11:10:04','461','2019-12-05 11:10:58',10,0),('1','116',116260,'AFTERNOON','2019-12-01','2019-12-01 00:00:00',NULL,'461',1958843.90,1958843.90,'461','2019-12-05 11:21:40','461','2019-12-05 11:24:25',10,0),('1','116',116267,'MORNING ','2019-12-02','2019-12-02 00:00:00',NULL,'461',1543637.27,1543637.27,'461','2019-12-05 11:35:24','461','2019-12-05 11:38:03',10,0),('1','116',116269,'AFTERNOON','2019-12-02','2019-12-02 00:00:00',NULL,'461',2801847.63,2801847.63,'461','2019-12-05 11:46:44','461','2019-12-05 11:47:48',10,0),('1','116',116270,'MORNING ','2019-12-03','2019-12-03 00:00:00',NULL,'461',2030831.85,2030831.85,'461','2019-12-05 12:41:31','461','2019-12-05 12:47:30',10,0),('1','116',116290,'AFTERNOON','2019-12-03','2019-12-03 00:00:00',NULL,'461',2587530.01,2587530.01,'461','2019-12-05 12:52:54','461','2019-12-05 12:53:49',10,0),('1','116',116292,'MORNING ','2019-12-04','2019-12-04 00:00:00',NULL,'461',2172691.81,2172691.81,'461','2019-12-05 13:06:31','461','2019-12-05 13:09:35',10,0),('1','116',116295,'AFTERNOON','2019-12-04','2019-12-04 00:00:00',NULL,'461',2898239.12,2898239.12,'461','2019-12-05 13:14:32','461','2019-12-05 13:16:02',10,0),('1','116',116300,'MORNING ','2019-12-05','2019-12-05 00:00:00',NULL,'461',2149831.62,2149831.62,'461','2019-12-05 13:24:22','461','2019-12-06 13:29:25',10,0),('1','116',116401,'AFTERNOON','2019-12-05','2019-12-05 00:00:00',NULL,'461',3069929.54,3069929.54,'461','2019-12-06 14:14:18','461','2019-12-06 14:15:18',10,0),('1','116',116447,'MORNING ','2019-12-06','2019-12-06 00:00:00',NULL,'461',2108984.36,2108984.36,'461','2019-12-06 19:20:26','461','2019-12-06 19:23:44',10,0),('1','116',116462,'AFTERNOON','2019-12-06','2019-12-06 00:00:00',NULL,'461',3292555.78,3292555.78,'461','2019-12-07 11:54:46','461','2019-12-07 11:56:02',10,0),('1','116',116502,'MORNING ','2019-12-07','2019-12-07 00:00:00',NULL,'461',2311036.75,2311036.75,'461','2019-12-07 12:32:59','461','2019-12-09 05:10:15',10,0),('1','116',116739,'AFTERNOON','2019-12-09','2019-12-09 00:00:00',NULL,'461',2277983.64,2277983.64,'461','2019-12-09 14:41:25','461','2019-12-09 14:42:14',10,0),('1','116',116743,'MORNING ','2019-12-09','2019-12-09 00:00:00',NULL,'461',1479619.27,1479619.27,'461','2019-12-09 14:47:09','461','2019-12-09 14:48:02',10,0),('1','116',116746,'AFTERNOON','2019-12-09','2019-12-09 00:00:00',NULL,'461',1624398.26,1624398.26,'461','2019-12-09 15:06:37','461','2019-12-09 15:08:12',10,0),('1','116',116788,'MORNING ','2019-12-09','2019-12-09 00:00:00',NULL,'461',2060248.65,2060248.65,'461','2019-12-09 17:00:10','461','2019-12-09 17:03:42',10,0),('1','116',116791,'AFTERNOON','2019-12-09','2019-12-09 00:00:00',NULL,'461',2260508.38,2260508.38,'461','2019-12-10 15:02:43','461','2019-12-10 15:03:29',10,0),('1','116',116916,'AFTERNOON','2019-12-10','2019-12-10 00:00:00',NULL,'461',1610294.69,1610294.69,'461','2019-12-11 15:55:22','461','2019-12-11 15:56:28',10,0),('1','116',117073,'MORNING ','2019-12-11','2019-12-11 00:00:00',NULL,'461',1995758.02,1995758.02,'461','2019-12-11 16:01:34','461','2019-12-11 16:02:38',10,0),('1','116',117076,'AFTERNOON','2019-12-11','2019-12-11 00:00:00',NULL,'461',3142662.21,3142662.21,'461','2019-12-12 08:57:52','461','2019-12-12 08:59:18',10,0),('1','116',117117,'MORNING','2019-12-12','2019-12-12 00:00:00',NULL,'461',2233902.59,2233902.59,'461','2019-12-12 14:30:19','461','2019-12-12 14:33:02',10,0),('1','116',117186,'AFTERNOON','2019-12-12','2019-12-12 00:00:00',NULL,'461',3117221.04,3117221.04,'461','2019-12-13 18:16:16','461','2019-12-13 18:19:14',10,0),('1','116',117373,'MORNING ','2019-12-13','2019-12-13 00:00:00',NULL,'461',2120811.93,2120811.93,'461','2019-12-13 18:24:49','461','2019-12-13 18:26:16',10,0),('1','116',117391,'AFTERNOON','2019-12-13','2019-12-13 00:00:00',NULL,'461',2977446.00,2977446.00,'461','2019-12-14 11:01:23','461','2019-12-14 11:19:34',10,0),('1','116',117421,'MORNING ','2019-12-14','2019-12-14 00:00:00',NULL,'461',1853458.75,1853458.75,'461','2019-12-14 17:14:36','461','2019-12-14 17:15:41',10,0),('1','116',117496,'AFTERNOON','2019-12-14','2019-12-14 00:00:00',NULL,'461',2362470.77,2362470.77,'461','2019-12-15 13:01:43','461','2019-12-15 13:03:04',10,0),('1','116',117552,'MORNING','2019-12-15','2019-12-15 00:00:00',NULL,'461',1450209.86,1450209.86,'461','2019-12-15 13:06:40','461','2019-12-15 13:07:39',10,0),('1','116',117555,'AFTERNOON','2019-12-15','2019-12-15 00:00:00',NULL,'461',1808494.82,1808494.82,'461','2019-12-16 10:22:17','461','2019-12-16 10:23:31',10,0),('1','116',117653,'MORNING ','2019-12-16','2019-12-16 00:00:00',NULL,'461',1939732.19,1939732.19,'461','2019-12-16 18:57:06','461','2019-12-16 18:58:55',10,0),('1','116',117737,'AFTERNOON','2019-12-16','2019-12-16 00:00:00',NULL,'461',729317.16,729317.16,'461','2019-12-16 19:05:01','461','2019-12-16 19:05:57',10,0),('1','116',117741,'AFTERNOON','2019-12-16','2019-12-16 00:00:00',NULL,'461',1730464.18,1730464.18,'461','2019-12-17 09:35:23','461','2019-12-17 09:36:40',10,0),('1','116',117772,'MORNING','2019-12-17','2019-12-17 00:00:00',NULL,'461',1949273.84,1949273.84,'461','2019-12-17 12:51:33','461','2019-12-17 14:43:06',10,0),('1','116',117854,'AFTERNOON','2019-12-17','2019-12-17 00:00:00',NULL,'461',2624434.66,2624434.66,'461','2019-12-18 11:38:03','461','2019-12-18 11:39:37',10,0),('1','116',117946,'MORNING','2019-12-18','2019-12-18 00:00:00',NULL,'461',1754867.45,1754867.45,'461','2019-12-18 12:57:30','461','2019-12-18 12:59:06',10,0),('1','116',117958,'AFTERNOON','2019-12-18','2019-12-18 00:00:00',NULL,'461',2578656.07,2578656.07,'461','2019-12-19 11:58:14','461','2019-12-19 11:59:03',10,0),('1','116',118073,'MORNING ','2019-12-19','2019-12-19 00:00:00',NULL,'461',2163072.91,2163072.91,'461','2019-12-19 14:47:09','461','2019-12-19 14:48:02',10,0),('1','116',118119,'AFTERNOON','2019-12-19','2019-12-19 00:00:00',NULL,'461',3196427.10,3196427.10,'461','2019-12-20 10:40:55','461','2019-12-20 10:44:44',10,0),('1','116',118224,'MORNING','2019-12-20','2019-12-20 00:00:00',NULL,'461',2340932.19,2340932.19,'461','2019-12-20 13:15:21','461','2019-12-20 13:16:34',10,0),('1','116',118252,'AFTERNOON','2019-12-20','2019-12-20 00:00:00',NULL,'461',3310401.85,3310401.85,'461','2019-12-21 13:33:23','461','2019-12-21 13:34:14',10,0),('1','116',118360,'MORNING','2019-12-21','2019-12-21 00:00:00',NULL,'461',2643169.99,2643169.99,'461','2019-12-21 13:42:46','461','2019-12-21 22:36:41',10,0),('1','116',118414,'AFTERNOON','2019-12-21','2019-12-21 00:00:00',NULL,'461',2809777.30,2809777.30,'461','2019-12-22 10:57:06','461','2019-12-22 10:57:47',10,0),('1','116',118439,'MORNING','2019-12-22','2019-12-22 00:00:00',NULL,'461',1862264.83,1862264.83,'461','2019-12-22 18:18:50','461','2019-12-22 18:20:47',10,0),('1','116',118526,'AFTERNOON','2019-12-22','2019-12-22 00:00:00',NULL,'461',2033270.76,2033270.76,'461','2019-12-23 14:56:51','461','2019-12-23 14:57:20',10,0),('1','116',118612,'MORNING','2019-12-23','2019-12-23 00:00:00',NULL,'461',2229078.87,2229078.87,'461','2019-12-23 15:02:19','461','2019-12-23 15:10:06',10,0),('1','116',118615,'AFTERNOON','2019-12-23','2019-12-23 00:00:00',NULL,'461',3547382.64,3547382.64,'461','2019-12-24 22:39:52','461','2019-12-24 22:42:08',10,0),('1','116',118763,'MORNING ','2019-12-24','2019-12-24 00:00:00',NULL,'461',2753530.74,2753530.74,'461','2019-12-24 22:45:19','461','2019-12-24 22:46:12',10,0),('1','116',118764,'AFTERNOON','2019-12-24','2019-12-24 00:00:00',NULL,'461',3259474.30,3259474.30,'461','2019-12-25 16:23:51','461','2019-12-25 16:32:45',10,0),('1','116',118815,'MORNING','2019-12-25','2019-12-25 00:00:00',NULL,'461',1960257.64,1960257.64,'461','2019-12-25 16:40:59','461','2019-12-25 16:56:19',10,0),('1','116',118821,'AFTERNOON','2019-12-25','2019-12-25 00:00:00',NULL,'461',2632515.76,2632515.76,'461','2019-12-26 12:29:56','461','2019-12-26 12:32:23',10,0),('1','116',118870,'MORNING','2019-12-26','2019-12-26 00:00:00',NULL,'461',2056442.67,2056442.67,'461','2019-12-26 12:37:35','461','2019-12-26 13:46:13',10,0),('1','116',118881,'AFTERNOON','2019-12-26','2019-12-26 00:00:00',NULL,'461',2270932.49,2270932.49,'461','2019-12-27 12:07:31','461','2019-12-27 12:08:23',10,0),('1','116',118969,'MORNING','2019-12-27','2019-12-27 00:00:00',NULL,'461',1980643.92,1980643.92,'461','2019-12-27 12:19:09','461','2019-12-27 13:08:29',10,0),('1','116',118974,'AFTERNOON','2019-12-27','2019-12-27 00:00:00',NULL,'461',2813335.12,2813335.12,'461','2019-12-28 19:32:28','461','2019-12-28 19:33:15',10,0),('1','116',119106,'MORNING','2019-12-28','2019-12-28 00:00:00',NULL,'461',2004314.95,2004314.95,'461','2019-12-28 19:38:22','461','2019-12-28 19:39:09',10,0),('1','116',119108,'AFTERNOON','2019-12-28','2019-12-28 00:00:00',NULL,'461',1900903.09,1900903.09,'461','2019-12-30 15:40:46','461','2019-12-30 15:41:40',10,0),('1','116',119271,'MORNING ','2019-12-30','2019-12-30 00:00:00',NULL,'461',1497446.34,1497446.34,'461','2019-12-30 15:51:44','461','2019-12-30 15:52:46',10,0),('1','116',119274,'AFTERNOON','2019-12-30','2019-12-30 00:00:00',NULL,'461',1583764.27,1583764.27,'461','2019-12-30 15:59:56','461','2019-12-30 16:01:34',10,0),('1','116',119276,'MORNING','2019-12-30','2019-12-30 00:00:00',NULL,'461',1607383.71,1607383.71,'461','2019-12-30 16:09:10','461','2019-12-30 16:10:04',10,0),('1','116',119277,'AFTERNOON','2019-12-30','2019-12-30 00:00:00',NULL,'461',2090973.52,2090973.52,'461','2019-12-31 16:43:42','461','2019-12-31 16:44:37',10,0),('1','116',119365,'MORNING ','2019-12-31','2019-12-31 00:00:00',NULL,'461',1586195.41,1586195.41,'461','2019-12-31 16:49:40','461','2019-12-31 16:50:39',10,0),('1','116',119366,'AFTERNOON','2019-12-31','2019-12-31 00:00:00',NULL,'461',2933228.41,2933228.41,'461','2020-01-01 05:36:38','461','2020-01-01 05:41:17',10,0),('1','116',119376,'MORNING ','2020-01-01','2020-01-01 00:00:00',NULL,'461',1157754.81,1157754.81,'461','2020-01-01 21:11:17','461','2020-01-01 21:11:50',10,0),('1','116',119446,'AFTERNOON','2020-01-01','2020-01-01 00:00:00',NULL,'461',1332738.02,1332738.02,'461','2020-01-02 04:43:58','461','2020-01-02 05:11:46',10,0),('1','116',119447,'MORNING','2020-01-02','2020-01-02 00:00:00',NULL,'461',1396031.71,1396031.71,'461','2020-01-02 14:55:46','461','2020-01-02 14:57:15',10,0),('1','116',119510,'AFTERNOON','2020-01-02','2020-01-02 00:00:00',NULL,'461',1942206.17,1942206.17,'461','2020-01-03 11:58:50','461','2020-01-03 12:05:30',10,0),('1','116',119601,'MORNING ','2020-01-03','2020-01-03 00:00:00',NULL,'461',1466436.31,1466436.31,'461','2020-01-03 14:27:05','461','2020-01-03 14:31:18',10,0),('1','116',119614,'AFTERNOON','2020-01-03','2020-01-03 00:00:00',NULL,'461',2144185.48,2144185.48,'461','2020-01-04 18:53:44','461','2020-01-04 18:55:25',10,0),('1','116',119746,'MORNING','2020-01-04','2020-01-04 00:00:00',NULL,'461',1463936.60,1463936.60,'461','2020-01-04 18:59:04','461','2020-01-04 19:00:10',10,0),('1','116',119747,'AFTERNOON','2020-01-04','2020-01-04 00:00:00',NULL,'461',2322832.51,2322832.51,'461','2020-01-05 16:44:53','461','2020-01-05 16:45:31',10,0),('1','116',119817,'MORNING ','2020-01-05','2020-01-05 00:00:00',NULL,'461',1386979.46,1386979.46,'461','2020-01-05 16:50:05','461','2020-01-05 16:51:08',10,0),('1','116',119820,'AFTERNOON','2020-01-05','2020-01-05 00:00:00',NULL,'461',1928169.60,1928169.60,'461','2020-01-06 19:07:06','461','2020-01-06 19:08:40',10,0),('1','116',119934,'MORNING','2020-01-06','2020-01-06 00:00:00',NULL,'461',1668405.53,1668405.53,'461','2020-01-06 19:33:52','461','2020-01-06 19:36:31',10,0),('1','116',119937,'AFTERNOON','2020-01-06','2020-01-06 00:00:00',NULL,'461',2443132.18,2443132.18,'461','2020-01-07 13:31:13','461','2020-01-07 13:33:36',10,0),('1','116',119996,'MORNING','2020-01-07','2020-01-07 00:00:00',NULL,'461',1483890.61,1483890.61,'461','2020-01-07 13:46:43','461','2020-01-07 13:49:09',10,0),('1','116',120000,'AFTERNOON','2020-01-07','2020-01-07 00:00:00',NULL,'461',1990922.37,1990922.37,'461','2020-01-08 13:17:13','461','2020-01-08 13:18:20',10,0),('1','116',120101,'MORNING ','2020-01-08','2020-01-08 00:00:00',NULL,'461',1490933.52,1490933.52,'461','2020-01-08 13:23:42','461','2020-01-08 13:24:34',10,0),('1','116',120104,'AFTERNOON','2020-01-08','2020-01-08 00:00:00',NULL,'461',2540323.77,2540323.77,'461','2020-01-09 11:18:08','461','2020-01-09 11:19:11',10,0),('1','116',120340,'MORNING ','2020-01-09','2020-01-09 00:00:00',NULL,'461',1560930.16,1560930.16,'461','2020-01-09 12:37:53','461','2020-01-09 12:39:48',10,0),('1','116',120364,'AFTERNOON','2020-01-09','2020-01-09 00:00:00',NULL,'461',2342321.31,2342321.31,'461','2020-01-10 14:18:12','461','2020-01-10 14:18:51',10,0),('1','116',120615,'Morning ','2020-01-10','2020-01-10 00:00:00',NULL,'461',1728447.76,1728447.76,'461','2020-01-10 14:24:38','461','2020-01-10 14:25:04',10,0),('1','116',120619,'AFTERNOON ','2020-01-10','2020-01-10 00:00:00',NULL,'461',2644768.50,2644768.50,'461','2020-01-11 13:11:47','461','2020-01-11 13:12:28',10,0),('1','116',120780,'MORNING','2020-01-11','2020-01-11 00:00:00',NULL,'461',1639702.97,1639702.97,'461','2020-01-11 13:17:00','461','2020-01-11 13:17:43',10,0),('1','116',120782,'AFTERNOON ','2020-01-11','2020-01-11 00:00:00',NULL,'461',2235095.92,2235095.92,'461','2020-01-12 13:50:51','461','2020-01-12 13:51:20',10,0),('1','116',120904,'MORNING','2020-01-12','2020-01-12 00:00:00',NULL,'461',1430784.31,1430784.31,'461','2020-01-12 13:56:22','461','2020-01-12 13:56:54',10,0),('1','116',120906,'AFTERNOON ','2020-01-12','2020-01-12 00:00:00',NULL,'461',1613476.26,1613476.26,'461','2020-01-13 11:41:42','461','2020-01-13 11:42:20',10,0),('1','116',121011,'MORNING','2020-01-13','2020-01-13 00:00:00',NULL,'461',1776456.04,1776456.04,'461','2020-01-13 13:51:43','461','2020-01-13 13:53:12',10,0),('1','116',121051,'AFTERNOON','2020-01-13','2020-01-13 00:00:00',NULL,'461',2518274.41,2518274.41,'461','2020-01-14 13:06:03','461','2020-01-14 13:07:49',10,0),('1','116',121186,'MORNING SHIFT','2020-01-14','2020-01-14 00:00:00',NULL,'461',1734085.56,1734085.56,'461','2020-01-14 13:11:03','461','2020-01-14 13:11:37',10,0),('1','116',121187,'AFTERNOON','2020-01-14','2020-01-14 00:00:00',NULL,'461',2416211.77,2416211.77,'461','2020-01-15 18:59:46','461','2020-01-15 19:00:38',10,0),('1','116',121380,'MORNING SHIFT','2020-01-15','2020-01-15 00:00:00',NULL,'461',1601813.87,1601813.87,'461','2020-01-15 19:14:08','461','2020-01-15 19:17:19',10,0),('1','116',121381,'AFTERNOON','2020-01-15','2020-01-15 00:00:00',NULL,'461',2478959.99,2478959.99,'461','2020-01-16 14:58:55','461','2020-01-16 14:59:48',10,0),('1','116',121484,'MORNING SHIFT','2020-01-16','2020-01-16 00:00:00',NULL,'461',1808743.74,1808743.74,'461','2020-01-16 15:07:47','461','2020-01-16 15:08:38',10,0),('1','116',121485,'AFTERNOON','2020-01-16','2020-01-16 00:00:00',NULL,'461',2249121.73,2249121.73,'461','2020-01-17 13:25:31','461','2020-01-17 13:26:21',10,0),('1','116',121579,'MORNING SHIFT','2020-01-17','2020-01-17 00:00:00',NULL,'461',1938061.70,1938061.70,'461','2020-01-17 13:29:16','461','2020-01-17 13:29:41',10,0),('1','116',121581,'AFTERNOON','2020-01-17','2020-01-17 00:00:00',NULL,'461',2386403.42,2386403.42,'461','2020-01-18 15:59:44','461','2020-01-18 16:00:26',10,0),('1','116',121740,'MORNING SHIFT','2020-01-18','2020-01-18 00:00:00',NULL,'461',1346877.88,1346877.88,'461','2020-01-18 16:04:13','461','2020-01-18 16:04:40',10,0),('1','116',121741,'AFTERNOON','2020-01-18','2020-01-18 00:00:00',NULL,'461',2189895.57,2189895.57,'461','2020-01-20 14:00:40','461','2020-01-20 14:03:17',10,0),('1','116',121948,'MORNING SHIFT','2020-01-19','2020-01-19 00:00:00',NULL,'461',1271050.51,1271050.51,'461','2020-01-20 14:08:59','461','2020-01-20 14:10:49',10,0),('1','116',121953,'AFTERNOON','2020-01-19','2020-01-19 00:00:00',NULL,'461',1544822.32,1544822.32,'461','2020-01-20 15:16:31','461','2020-01-20 15:22:35',10,0),('1','116',121972,'MORNING SHIFT','2020-01-20','2020-01-20 00:00:00',NULL,'461',1644887.45,1644887.45,'461','2020-01-20 15:35:42','461','2020-01-20 15:53:31',10,0),('1','116',121985,'AFTERNOON','2020-01-20','2020-01-20 00:00:00',NULL,'461',2301979.06,2301979.06,'461','2020-01-21 08:39:13','461','2020-01-21 09:08:01',10,0),('1','116',122135,'MORNING SHIFT','2020-01-21','2020-01-21 00:00:00',NULL,'461',1582007.56,1582007.56,'461','2020-01-21 16:07:24','461','2020-01-21 16:08:20',10,0),('1','116',122138,'AFTERNOON','2020-01-21','2020-01-21 00:00:00',NULL,'461',2047953.35,2047953.35,'461','2020-01-22 14:05:32','461','2020-01-22 14:33:33',10,0),('1','116',122256,'MORNING SHIFT','2020-01-22','2020-01-22 00:00:00',NULL,'461',1527309.18,1527309.18,'461','2020-01-22 14:43:22','461','2020-01-22 14:45:50',10,0),('1','116',122258,'AFTERNOON','2020-01-22','2020-01-22 00:00:00',NULL,'461',2108649.36,2108649.36,'461','2020-01-23 11:35:25','461','2020-01-23 11:40:56',10,0),('1','116',122332,'MORNING SHIFT','2020-01-23','2020-01-23 00:00:00',NULL,'461',1497489.09,1497489.09,'461','2020-01-23 15:30:39','461','2020-01-23 15:35:19',10,0),('1','116',122378,'AFTERNOON','2020-01-23','2020-01-23 00:00:00',NULL,'461',2193054.68,2193054.68,'461','2020-01-24 18:50:23','461','2020-01-24 18:50:59',10,0),('1','116',122523,'MORNING SHIFT','2020-01-24','2020-01-24 00:00:00',NULL,'461',1568502.33,1568502.33,'461','2020-01-24 19:07:10','461','2020-01-24 19:08:34',10,0),('1','116',122529,'AFTERNOON','2020-01-24','2020-01-24 00:00:00',NULL,'461',2822610.50,2822610.50,'461','2020-01-25 19:56:56','461','2020-01-25 20:08:47',10,0),('1','116',122625,'AFTERNOON','2020-01-25','2020-01-25 00:00:00',NULL,'461',1583598.26,1583598.26,'461','2020-01-25 20:21:02','461','2020-01-25 20:22:01',10,0),('1','116',122627,'AFTERNOON','2020-01-25','2020-01-25 00:00:00',NULL,'461',1997307.61,1997307.61,'461','2020-01-26 13:03:41','461','2020-01-26 13:05:11',10,0),('1','116',122683,'MORNING SHIFT','2020-01-26','2020-01-26 00:00:00',NULL,'461',1272627.55,1272627.55,'461','2020-01-26 13:12:57','461','2020-01-26 13:15:12',10,0),('1','116',122684,'AFTERNOON','2020-01-26','2020-01-26 00:00:00',NULL,'461',1712504.45,1712504.45,'461','2020-01-27 17:25:40','461','2020-01-27 17:26:13',10,0),('1','116',122867,'MORNING SHIFT','2020-01-27','2020-01-27 00:00:00',NULL,'461',1583396.99,1583396.99,'461','2020-01-27 17:35:56','461','2020-01-27 17:36:33',10,0),('1','116',122869,'AFTERNOON','2020-01-27','2020-01-27 00:00:00',NULL,'461',2587416.56,2587416.56,'461','2020-01-28 11:23:25','461','2020-01-28 11:23:52',10,0),('1','116',122926,'MORNING SHIFT','2020-01-28','2020-01-28 00:00:00',NULL,'461',1345191.16,1345191.16,'461','2020-01-28 13:25:37','461','2020-01-28 13:26:03',10,0),('1','116',122945,'AFTERNOON','2020-01-28','2020-01-28 00:00:00',NULL,'461',2552630.60,2552630.60,'461','2020-01-29 13:23:57','461','2020-01-29 13:24:29',10,0),('1','116',123080,'MORNING SHIFT','2020-01-29','2020-01-29 00:00:00',NULL,'461',1758510.91,1758510.91,'461','2020-01-29 13:30:41','461','2020-01-29 13:38:09',10,0),('1','116',123083,'AFTERNOON','2020-01-29','2020-01-29 00:00:00',NULL,'461',2469029.47,2469029.47,'461','2020-01-30 14:05:39','461','2020-01-30 14:06:13',10,0),('1','116',123206,'MORNING SHIFT','2020-01-30','2020-01-30 00:00:00',NULL,'461',1752677.10,1752677.10,'461','2020-02-02 16:45:18','461','2020-02-02 16:46:56',10,0),('1','116',123463,'AFTERNOON','2020-01-30','2020-01-30 00:00:00',NULL,'461',2357341.64,2357341.64,'461','2020-02-02 16:52:44','461','2020-02-02 16:54:11',10,0),('1','116',123464,'MORNING SHIFT','2020-01-31','2020-01-31 00:00:00',NULL,'461',1767338.10,1767338.10,'461','2020-02-02 17:00:10','461','2020-02-02 17:01:34',10,0),('1','116',123466,'AFTERNOON','2020-01-31','2020-01-31 00:00:00',NULL,'461',3024262.30,3024262.30,'461','2020-02-02 17:10:07','461','2020-02-02 17:15:35',10,0),('1','116',123472,'MORNING SHIFT','2020-02-01','2020-02-01 00:00:00',NULL,'461',1586169.63,1586169.63,'461','2020-02-02 17:21:04','461','2020-02-02 17:22:09',10,0),('1','116',123473,'AFTERNOON','2020-02-01','2020-02-01 00:00:00',NULL,'461',2041388.73,2041388.73,'461','2020-02-02 17:35:20','461','2020-02-02 17:38:08',10,0),('1','116',123476,'MORNING SHIFT','2020-02-02','2020-02-02 00:00:00',NULL,'461',1359592.23,1359592.23,'461','2020-02-02 17:46:08','461','2020-02-02 17:47:24',10,0),('1','116',123478,'AFTERNOON','2020-02-02','2020-02-02 00:00:00',NULL,'461',1912361.50,1912361.50,'461','2020-02-03 09:42:46','461','2020-02-03 09:45:42',10,0),('1','116',123539,'MORNING SHIFT','2020-02-03','2020-02-03 00:00:00',NULL,'461',1445502.21,1445502.21,'461','2020-02-03 14:43:35','461','2020-02-03 14:44:31',10,0),('1','116',123606,'AFTERNOON','2020-02-03','2020-02-03 00:00:00',NULL,'461',2162820.15,2162820.15,'461','2020-02-04 10:37:03','461','2020-02-04 10:40:31',10,0),('1','116',123694,'MORNING SHIFT','2020-02-04','2020-02-04 00:00:00',NULL,'461',1524401.02,1524401.02,'461','2020-02-04 12:45:34','461','2020-02-04 13:21:49',10,0),('1','116',123731,'AFTERNOON','2020-02-04','2020-02-04 00:00:00',NULL,'461',2618407.36,2618407.36,'461','2020-02-05 10:11:41','461','2020-02-05 14:31:37',10,0),('1','116',123898,'MORNING SHIFT','2020-02-05','2020-02-05 00:00:00',NULL,'461',1740414.01,1740414.01,'461','2020-02-05 14:37:18','461','2020-02-05 14:37:47',10,0),('1','116',123900,'AFTERNOON','2020-02-05','2020-02-05 00:00:00',NULL,'461',2742549.46,2742549.46,'461','2020-02-06 11:10:50','461','2020-02-06 14:18:04',10,0),('1','116',124049,'MORNING SHIFT','2020-02-06','2020-02-06 00:00:00',NULL,'461',1573311.71,1573311.71,'461','2020-02-06 14:29:24','461','2020-02-06 14:31:06',10,0),('1','116',124056,'AFTERNOON','2020-02-06','2020-02-06 00:00:00',NULL,'461',2361623.14,2361623.14,'461','2020-02-07 06:16:35','461','2020-02-07 14:08:55',10,0),('1','116',124200,'MORNING SHIFT','2020-02-07','2020-02-07 00:00:00',NULL,'461',1768688.02,1768688.02,'461','2020-02-07 20:33:18','461','2020-02-07 20:34:02',10,0),('1','116',124244,'AFTERNOON','2020-02-07','2020-02-07 00:00:00',NULL,'461',2874926.40,2874926.40,'461','2020-02-08 11:23:25','461','2020-02-08 11:32:37',10,0),('1','116',124283,'MORNING SHIFT','2020-02-08','2020-02-08 00:00:00',NULL,'461',1675672.55,1675672.55,'461','2020-02-08 12:51:58','461','2020-02-08 15:20:56',10,0),('1','116',124321,'AFTERNOON','2020-02-08','2020-02-08 00:00:00',NULL,'461',1986868.24,1986868.24,'461','2020-02-09 16:02:10','461','2020-02-09 16:14:37',10,0),('1','116',124468,'MORNING SHIFT','2020-02-09','2020-02-09 00:00:00',NULL,'461',1374317.34,1374317.34,'461','2020-02-09 16:20:34','461','2020-02-09 16:21:06',10,0),('1','116',124469,'AFTERNOON','2020-02-09','2020-02-09 00:00:00',NULL,'461',1841926.71,1841926.71,'461','2020-02-10 11:49:48','461','2020-02-10 11:50:16',10,0),('1','116',124534,'MORNING SHIFT','2020-02-10','2020-02-10 00:00:00',NULL,'461',1464283.92,1464283.92,'461','2020-02-10 13:38:20','461','2020-02-10 13:38:53',10,0),('1','116',124551,'AFTERNOON','2020-02-10','2020-02-10 00:00:00',NULL,'461',2432942.79,2432942.79,'461','2020-02-11 10:18:47','461','2020-02-11 10:27:37',10,0),('1','116',124648,'MORNING SHIFT','2020-02-11','2020-02-11 00:00:00',NULL,'461',1552754.03,1552754.03,'461','2020-02-11 14:16:31','461','2020-02-11 14:17:10',10,0),('1','116',124701,'AFTERNOON','2020-02-11','2020-02-11 00:00:00',NULL,'461',2414879.95,2414879.95,'461','2020-02-12 10:41:47','461','2020-02-12 10:42:18',10,0),('1','116',124781,'MORNING SHIFT','2020-02-12','2020-02-12 00:00:00',NULL,'461',1703288.40,1703288.40,'461','2020-02-12 13:31:20','461','2020-02-12 13:31:56',10,0),('1','116',124812,'AFTERNOON','2020-02-12','2020-02-12 00:00:00',NULL,'461',2169115.76,2169115.76,'461','2020-02-13 14:35:54','461','2020-02-13 14:37:24',10,0),('1','116',124981,'MORNING SHIFT','2020-02-13','2020-02-13 00:00:00',NULL,'461',1987218.62,1987218.62,'461','2020-02-15 19:29:31','461','2020-02-15 19:30:08',10,0),('1','116',125299,'AFTERNOON','2020-02-13','2020-02-13 00:00:00',NULL,'461',2655537.03,2655537.03,'461','2020-02-15 20:30:36','461','2020-02-15 20:31:02',10,0),('1','116',125302,'MORNING SHIFT','2020-02-14','2020-02-14 00:00:00',NULL,'461',1717901.64,1717901.64,'461','2020-02-16 11:56:31','461','2020-02-16 12:07:12',10,0),('1','116',125349,'AFTERNOON','2020-02-14','2020-02-14 00:00:00',NULL,'461',3115228.85,3115228.85,'461','2020-02-16 12:13:29','461','2020-02-16 12:19:02',10,0),('1','116',125350,'MORNING SHIFT','2020-02-15','2020-02-15 00:00:00',NULL,'461',1538737.80,1538737.80,'461','2020-02-16 12:27:57','461','2020-02-16 12:28:31',10,0),('1','116',125351,'AFTERNOON','2020-02-15','2020-02-15 00:00:00',NULL,'461',2031302.01,2031302.01,'461','2020-02-16 12:36:50','461','2020-02-16 12:45:11',10,0),('1','116',125353,'MORNING SHIFT','2020-02-16','2020-02-16 00:00:00',NULL,'461',1160824.80,1160824.80,'461','2020-02-16 13:01:55','461','2020-02-16 13:06:13',10,0),('1','116',125356,'AFTERNOON','2020-02-16','2020-02-16 00:00:00',NULL,'461',1696008.59,1696008.59,'461','2020-02-17 11:58:24','461','2020-02-17 11:59:25',10,0),('1','116',125493,'MORNING','2020-02-17','2020-02-17 00:00:00',NULL,'461',1545148.68,1545148.68,'461','2020-02-17 12:29:41','461','2020-02-18 12:22:24',10,0),('1','116',125645,'AFTERNOON','2020-02-17','2020-02-17 00:00:00',NULL,'461',2418813.08,2418813.08,'461','2020-02-18 12:54:21','461','2020-02-18 12:57:37',10,0),('1','116',125648,'MORNING SHIFT','2020-02-18','2020-02-18 00:00:00',NULL,'461',1522154.98,1522154.98,'461','2020-02-18 13:04:44','461','2020-02-18 13:46:52',10,0),('1','116',125656,'AFTERNOON','2020-02-18','2020-02-18 00:00:00',NULL,'461',2518726.58,2518726.58,'461','2020-02-19 14:48:17','461','2020-02-19 14:50:18',10,0),('1','116',125811,'MORNING SHIFT','2020-02-19','2020-02-19 00:00:00',NULL,'461',1903131.81,1903131.81,'461','2020-02-19 15:05:21','461','2020-02-19 15:16:01',10,0),('1','116',125819,'AFTERNOON','2020-02-19','2020-02-19 00:00:00',NULL,'461',2410731.39,2410731.39,'461','2020-02-20 12:52:43','461','2020-02-20 12:53:36',10,0),('1','116',125912,'MORNING SHIFT','2020-02-20','2020-02-20 00:00:00',NULL,'461',1982078.70,1982078.70,'461','2020-02-20 13:04:49','461','2020-02-20 13:16:56',10,0),('1','116',125917,'AFTERNOON','2020-02-20','2020-02-20 00:00:00',NULL,'461',2544311.23,2544311.23,'461','2020-02-21 14:46:23','461','2020-02-21 14:49:09',10,0),('1','116',126044,'MORNING SHIFT','2020-02-21','2020-02-21 00:00:00',NULL,'461',1734298.47,1734298.47,'461','2020-02-21 15:21:43','461','2020-02-21 15:38:13',10,0),('1','116',126059,'AFTERNOON','2020-02-21','2020-02-21 00:00:00',NULL,'461',2706122.68,2706122.68,'461','2020-02-22 19:31:38','461','2020-02-22 19:32:19',10,0),('1','116',126181,'MORNING SHIFT','2020-02-22','2020-02-22 00:00:00',NULL,'461',1646335.42,1646335.42,'461','2020-02-22 19:40:09','461','2020-02-22 19:40:37',10,0),('1','116',126182,'AFTERNOON','2020-02-22','2020-02-22 00:00:00',NULL,'461',1968737.76,1968737.76,'461','2020-02-23 15:07:10','461','2020-02-23 15:08:45',10,0),('1','116',126259,'MORNING SHIFT','2020-02-23','2020-02-23 00:00:00',NULL,'461',1234572.15,1234572.15,'461','2020-02-23 15:14:12','461','2020-02-23 15:15:40',10,0),('1','116',126260,'AFTERNOON','2020-02-23','2020-02-23 00:00:00',NULL,'461',1651621.53,1651621.53,'461','2020-02-24 13:07:07','461','2020-02-24 13:07:42',10,0),('1','116',126375,'MORNING SHIFT','2020-02-24','2020-02-24 00:00:00',NULL,'461',1660022.22,1660022.22,'461','2020-02-24 13:47:20','461','2020-02-24 13:58:01',10,0),('1','116',126388,'AFTERNOON','2020-02-24','2020-02-24 00:00:00',NULL,'461',2451620.52,2451620.52,'461','2020-02-25 15:10:26','461','2020-02-25 15:10:57',10,0),('1','116',126568,'MORNING SHIFT','2020-02-25','2020-02-25 00:00:00',NULL,'461',1614537.17,1614537.17,'461','2020-02-25 15:29:26','461','2020-02-25 15:48:46',10,0),('1','116',126576,'AFTERNOON','2020-02-25','2020-02-25 00:00:00',NULL,'461',2299546.33,2299546.33,'461','2020-02-26 17:02:04','461','2020-02-26 17:02:37',10,0),('1','116',126699,'MORNING SHIFT','2020-02-26','2020-02-26 00:00:00',NULL,'461',1625626.26,1625626.26,'461','2020-02-26 17:10:53','461','2020-02-26 17:11:24',10,0),('1','116',126700,'AFTERNOON','2020-02-26','2020-02-26 00:00:00',NULL,'461',2404943.16,2404943.16,'461','2020-02-27 19:15:33','461','2020-02-27 19:20:57',10,0),('1','116',126843,'MORNING SHIFT','2020-02-27','2020-02-27 00:00:00',NULL,'461',1272790.50,1272790.50,'461','2020-02-27 19:29:21','461','2020-02-27 19:33:48',10,0),('1','116',126844,'AFTERNOON','2020-02-27','2020-02-27 00:00:00',NULL,'461',2241647.47,2241647.47,'461','2020-02-28 15:19:26','461','2020-02-28 15:22:26',10,0),('1','116',126951,'MORNING SHIFT','2020-02-28','2020-02-28 00:00:00',NULL,'461',1693587.36,1693587.36,'461','2020-02-28 15:30:02','461','2020-02-28 15:30:48',10,0),('1','116',126953,'AFTERNOON','2020-02-28','2020-02-28 00:00:00',NULL,'461',2742597.46,2742597.46,'461','2020-02-29 18:36:21','461','2020-02-29 18:37:16',10,0),('1','116',127120,'MORNING SHIFT','2020-02-29','2020-02-29 00:00:00',NULL,'461',1988948.70,1988948.70,'461','2020-02-29 18:41:09','461','2020-02-29 18:41:45',10,0),('1','116',127121,'AFTERNOON','2020-02-29','2020-02-29 00:00:00',NULL,'461',2221134.31,2221134.31,'461','2020-03-01 19:45:16','461','2020-03-01 19:46:35',10,0),('1','116',127231,'MORNING SHIFT','2020-03-01','2020-03-01 00:00:00',NULL,'461',1418921.10,1418921.10,'461','2020-03-01 19:53:41','461','2020-03-01 19:54:10',10,0),('1','116',127233,'AFTERNOON','2020-03-01','2020-03-01 00:00:00',NULL,'461',1776598.48,1776598.48,'461','2020-03-02 14:44:27','461','2020-03-02 14:45:13',10,0),('1','116',127325,'MORNING SHIFT','2020-03-02','2020-03-02 00:00:00',NULL,'461',2378026.68,2378026.68,'461','2020-03-02 15:00:16','461','2020-03-02 15:00:59',10,0),('1','116',127334,'AFTERNOON','2020-03-02','2020-03-02 00:00:00',NULL,'461',2365485.62,2365485.62,'461','2020-03-03 10:44:48','461','2020-03-03 10:45:24',10,0),('1','116',127420,'MORNING SHIFT','2020-03-03','2020-03-03 00:00:00',NULL,'461',1606761.39,1606761.39,'461','2020-03-03 13:51:52','461','2020-03-03 13:57:18',10,0),('1','116',127452,'AFTERNOON','2020-03-03','2020-03-03 00:00:00',NULL,'461',2400251.69,2400251.69,'461','2020-03-04 17:00:54','461','2020-03-04 17:01:29',10,0),('1','116',127613,'MORNING SHIFT','2020-03-04','2020-03-04 00:00:00',NULL,'461',2109586.41,2109586.41,'461','2020-03-04 17:08:09','461','2020-03-04 17:08:54',10,0),('1','116',127616,'AFTERNOON','2020-03-04','2020-03-04 00:00:00',NULL,'461',2756647.13,2756647.13,'461','2020-03-05 20:36:26','461','2020-03-05 20:39:52',10,0),('1','116',127723,'MORNING SHIFT','2020-03-05','2020-03-05 00:00:00',NULL,'461',1882955.74,1882955.74,'461','2020-03-07 19:04:43','461','2020-03-07 19:10:30',10,0),('1','116',127939,'AFTERNOON','2020-03-05','2020-03-05 00:00:00',NULL,'461',2656704.88,2656704.88,'461','2020-03-07 19:16:18','461','2020-03-07 19:19:36',10,0),('1','116',127940,'MORNING SHIFT','2020-03-06','2020-03-06 00:00:00',NULL,'461',2104797.91,2104797.91,'461','2020-03-07 19:33:50','461','2020-03-07 19:36:11',10,0),('1','116',127942,'AFTERNOON','2020-03-06','2020-03-06 00:00:00',NULL,'461',2781968.06,2781968.06,'461','2020-03-07 19:57:59','461','2020-03-07 20:00:23',10,0),('1','116',127943,'MORNING SHIFT','2020-03-07','2020-03-07 00:00:00',NULL,'461',1764618.34,1764618.34,'461','2020-03-07 20:05:24','461','2020-03-07 20:28:34',10,0),('1','116',127944,'AFTERNOON','2020-03-07','2020-03-07 00:00:00',NULL,'461',2240980.48,2240980.48,'461','2020-03-08 19:47:28','461','2020-03-08 19:48:31',10,0),('1','116',128042,'MORNING SHIFT','2020-03-08','2020-03-08 00:00:00',NULL,'461',1110593.98,1110593.98,'461','2020-03-08 19:59:38','461','2020-03-08 20:01:08',10,0),('1','116',128043,'AFTERNOON','2020-03-08','2020-03-08 00:00:00',NULL,'461',1781443.97,1781443.97,'461','2020-03-09 18:08:49','461','2020-03-09 18:10:59',10,0),('1','116',128157,'MORNING SHIFT','2020-03-09','2020-03-09 00:00:00',NULL,'461',2087604.27,2087604.27,'461','2020-03-09 18:28:37','461','2020-03-09 18:31:23',10,0),('1','116',128158,'AFTERNOON','2020-03-09','2020-03-09 00:00:00',NULL,'461',2593793.06,2593793.06,'461','2020-03-11 11:06:57','461','2020-03-11 11:09:24',10,0),('1','116',128339,'MORNING SHIFT','2020-03-10','2020-03-10 00:00:00',NULL,'461',1823646.76,1823646.76,'461','2020-03-11 11:16:03','461','2020-03-11 11:16:58',10,0),('1','116',128341,'AFTERNOON','2020-03-10','2020-03-10 00:00:00',NULL,'461',2473844.07,2473844.07,'461','2020-03-11 11:22:26','461','2020-03-11 11:22:57',10,0),('1','116',128346,'MORNING SHIFT','2020-03-11','2020-03-11 00:00:00',NULL,'461',1550940.80,1550940.80,'461','2020-03-11 14:02:15','461','2020-03-11 14:03:10',10,0),('1','116',128379,'AFTERNOON','2020-03-11','2020-03-11 00:00:00',NULL,'461',2694205.20,2694205.20,'461','2020-03-12 19:41:40','461','2020-03-12 19:42:09',10,0),('1','116',128546,'MORNING SHIFT','2020-03-12','2020-03-12 00:00:00',NULL,'461',2087429.47,2087429.47,'461','2020-03-12 19:51:08','461','2020-03-12 19:51:39',10,0),('1','116',128547,'AFTERNOON','2020-03-12','2020-03-12 00:00:00',NULL,'461',2545511.74,2545511.74,'461','2020-03-13 15:33:18','461','2020-03-13 15:35:49',10,0),('1','116',128670,'MORNING SHIFT','2020-03-13','2020-03-13 00:00:00',NULL,'461',2035910.45,2035910.45,'461','2020-03-13 15:47:01','461','2020-03-13 15:48:59',10,0),('1','116',129358,'AFTERNOON SHIFT','2020-03-13','2020-03-13 00:00:00',NULL,'461',3632071.91,3632071.91,'461','2020-03-18 19:22:59','461','2020-03-18 19:30:44',10,0),('1','116',129361,'MORNING SHIFT','2020-03-14','2020-03-14 00:00:00',NULL,'461',1825489.73,1825489.73,'461','2020-03-18 20:07:16','461','2020-03-19 09:20:30',10,0),('1','116',129383,'AFTERNOON','2020-03-14','2020-03-14 00:00:00',NULL,'461',2271527.01,2271527.01,'461','2020-03-19 09:29:27','461','2020-03-19 09:38:52',10,0),('1','116',129391,'MORNING SHIFT','2020-03-15','2020-03-15 00:00:00',NULL,'461',1400664.27,1400664.27,'461','2020-03-19 09:51:31','461','2020-03-19 09:52:39',10,0),('1','116',129393,'AFTERNOON','2020-03-15','2020-03-15 00:00:00',NULL,'461',1767596.46,1767596.46,'461','2020-03-19 09:57:32','461','2020-03-19 09:58:37',10,0),('1','116',129395,'MORNING SHIFT','2020-03-16','2020-03-16 00:00:00',NULL,'461',1769430.48,1769430.48,'461','2020-03-19 10:07:09','461','2020-03-19 10:09:39',10,0),('1','116',129402,'AFTERNOON','2020-03-16','2020-03-16 00:00:00',NULL,'461',2570552.43,2570552.43,'461','2020-03-19 10:37:08','461','2020-03-19 10:37:58',10,0),('1','116',129407,'MORNING SHIFT','2020-03-17','2020-03-17 00:00:00',NULL,'461',1727789.61,1727789.61,'461','2020-03-19 10:44:38','461','2020-03-19 10:46:09',10,0),('1','116',129409,'AFTERNOON','2020-03-17','2020-03-17 00:00:00',NULL,'461',2207996.55,2207996.55,'461','2020-03-19 11:00:45','461','2020-03-19 11:01:31',10,0),('1','116',129413,'MORNING SHIFT','2020-03-18','2020-03-18 00:00:00',NULL,'461',1663129.68,1663129.68,'461','2020-03-19 14:03:08','461','2020-03-19 14:13:19',10,0),('1','116',129463,'AFTERNOON','2020-03-18','2020-03-18 00:00:00',NULL,'461',2267694.54,2267694.54,'461','2020-03-19 17:11:05','461','2020-03-19 17:11:49',10,0),('1','116',129495,'MORNING SHIFT','2020-03-19','2020-03-19 00:00:00',NULL,'461',389040.15,389040.15,'461','2020-03-19 17:21:01','461','2020-03-19 17:21:47',10,0),('1','116',129499,'MORNING SHIFT','2020-03-19','2020-03-19 00:00:00',NULL,'461',1163546.25,1163546.25,'461','2020-03-19 17:59:31','461','2020-03-19 18:01:44',10,0),('1','116',129506,'AFTERNOON','2020-03-19','2020-03-19 00:00:00',NULL,'461',2518520.00,2518520.00,'461','2020-03-20 12:59:00','461','2020-03-20 14:24:59',10,0),('1','116',129594,'MORNING SHIFT','2020-03-20','2020-03-20 00:00:00',NULL,'461',2036877.50,2036877.50,'461','2020-03-20 14:30:56','461','2020-03-20 14:33:43',10,0),('1','116',129596,'AFTERNOON','2020-03-20','2020-03-20 00:00:00',NULL,'461',3134150.00,3134150.00,'461','2020-03-21 14:28:48','461','2020-03-21 14:30:44',10,0),('1','116',129725,'MORNING SHIFT','2020-03-21','2020-03-21 00:00:00',NULL,'461',1803011.25,1803011.25,'461','2020-03-21 14:46:29','461','2020-03-21 15:17:37',10,0),('1','116',129733,'AFTERNOON','2020-03-21','2020-03-21 00:00:00',NULL,'461',1050965.55,1050965.55,'461','2020-03-22 09:34:52','461','2020-03-22 12:48:12',10,0),('1','116',129820,'MORNING SHIFT','2020-03-22','2020-03-22 00:00:00',NULL,'461',2282584.95,2282584.95,'461','2020-03-22 13:08:17','461','2020-03-22 16:17:37',10,0),('1','116',129855,'AFTERNOON','2020-03-22','2020-03-22 00:00:00',NULL,'461',2208969.50,2208969.50,'461','2020-03-27 08:26:14','461','2020-03-27 08:27:04',10,0),('1','116',130413,'MORNING SHIFT','2020-03-23','2020-03-23 00:00:00',NULL,'461',1638135.20,1638135.20,'461','2020-03-27 08:32:44','461','2020-03-27 08:33:18',10,0),('1','116',130466,'MORNING SHIFT','2020-03-27','2020-03-27 00:00:00',NULL,'461',664978.95,664978.95,'461','2020-03-27 13:30:31','461','2020-03-27 13:53:13',10,0),('1','116',130468,'AFTERNOON','2020-03-27','2020-03-27 00:00:00',NULL,'461',2661519.50,2661519.50,'461','2020-03-28 20:10:48','461','2020-03-28 20:11:38',10,0),('1','116',130622,'MORNING SHIFT','2020-03-28','2020-03-28 00:00:00',NULL,'461',655722.20,655722.20,'461','2020-03-28 20:17:35','461','2020-03-28 20:18:06',10,0),('1','116',130623,'AFTERNOON','2020-03-28','2020-03-28 00:00:00',NULL,'461',2218216.80,2218216.80,'461','2020-03-29 18:37:15','461','2020-03-29 18:39:56',10,0),('1','116',130702,'MORNING SHIFT','2020-03-29','2020-03-29 00:00:00',NULL,'461',1149286.60,1149286.60,'461','2020-03-29 18:42:59','461','2020-03-29 18:43:24',10,0),('1','116',130703,'AFTERNOON','2020-03-29','2020-03-29 00:00:00',NULL,'461',1373682.20,1373682.20,'461','2020-04-01 18:11:49','461','2020-04-01 18:12:17',10,0),('1','116',131044,'MORNING SHIFT','2020-03-30','2020-03-30 00:00:00',NULL,'461',1482895.70,1482895.70,'461','2020-04-01 18:15:41','461','2020-04-01 18:16:07',10,0),('1','116',131045,'AFTERNOON','2020-03-30','2020-03-30 00:00:00',NULL,'461',2493197.35,2493197.35,'461','2020-04-01 18:20:05','461','2020-04-01 18:20:33',10,0),('1','116',131046,'MORNING SHIFT','2020-03-31','2020-03-31 00:00:00',NULL,'461',1250957.50,1250957.50,'461','2020-04-01 18:26:08','461','2020-04-01 18:27:07',10,0),('1','116',131047,'AFTERNOON','2020-03-31','2020-03-31 00:00:00',NULL,'461',1468393.75,1468393.75,'461','2020-04-01 18:31:14','461','2020-04-01 18:31:44',10,0),('1','116',131048,'MORNING SHIFT','2020-04-01','2020-04-01 00:00:00',NULL,'461',1538145.70,1538145.70,'461','2020-04-01 18:35:40','461','2020-04-01 18:36:13',10,0),('1','116',131049,'AFTERNOON','2020-04-01','2020-04-01 00:00:00',NULL,'461',2857284.55,2857284.55,'461','2020-04-02 15:30:12','461','2020-04-02 15:30:47',10,0),('1','116',131143,'MORNING SHIFT','2020-04-02','2020-04-02 00:00:00',NULL,'461',1655158.80,1655158.80,'461','2020-04-02 15:35:18','461','2020-04-02 15:35:43',10,0),('1','116',131145,'AFTERNOON','2020-04-02','2020-04-02 00:00:00',NULL,'461',2526173.50,2526173.50,'461','2020-04-03 18:07:52','461','2020-04-03 18:08:44',10,0),('1','116',131296,'MORNING SHIFT','2020-04-03','2020-04-03 00:00:00',NULL,'461',1445758.90,1445758.90,'461','2020-04-03 18:12:57','461','2020-04-03 18:13:30',10,0),('1','116',131297,'AFTERNOON','2020-04-03','2020-04-03 00:00:00',NULL,'461',2546676.70,2546676.70,'461','2020-04-04 19:47:05','461','2020-04-04 19:47:41',10,0),('1','116',131393,'MORNING SHIFT','2020-04-04','2020-04-04 00:00:00',NULL,'461',1420110.60,1420110.60,'461','2020-04-04 19:51:17','461','2020-04-04 20:05:09',10,0),('1','116',131394,'AFTERNOON','2020-04-04','2020-04-04 00:00:00',NULL,'461',2076742.20,2076742.20,'461','2020-04-05 20:15:02','461','2020-04-05 20:17:40',10,0),('1','116',131500,'MORNING SHIFT','2020-04-05','2020-04-05 00:00:00',NULL,'461',1215921.65,1215921.65,'461','2020-04-05 20:23:06','461','2020-04-05 20:24:46',10,0),('1','116',131501,'AFTERNOON','2020-04-05','2020-04-05 00:00:00',NULL,'461',1454412.60,1454412.60,'461','2020-04-06 19:20:21','461','2020-04-06 19:21:26',10,0),('1','116',131604,'MORNING SHIFT','2020-04-06','2020-04-06 00:00:00',NULL,'461',1061563.05,1061563.05,'461','2020-04-06 19:24:24','461','2020-04-06 19:24:55',10,0),('1','116',131605,'AFTERNOON','2020-04-06','2020-04-06 00:00:00',NULL,'461',1951575.65,1951575.65,'461','2020-04-07 19:47:36','461','2020-04-07 19:49:04',10,0),('1','116',131761,'MORNING SHIFT','2020-04-07','2020-04-07 00:00:00',NULL,'461',1451480.75,1451480.75,'461','2020-04-07 19:55:21','461','2020-04-07 19:55:48',10,0),('1','116',131762,'AFTERNOON','2020-04-07','2020-04-07 00:00:00',NULL,'461',1961173.90,1961173.90,'461','2020-04-09 10:40:38','461','2020-04-09 10:40:59',10,0),('1','116',131939,'MORNING SHIFT','2020-04-08','2020-04-08 00:00:00',NULL,'461',1284577.00,1284577.00,'461','2020-04-09 10:46:47','461','2020-04-09 10:47:19',10,0),('1','116',131942,'AFTERNOON','2020-04-08','2020-04-08 00:00:00',NULL,'461',1403207.10,1403207.10,'461','2020-04-09 10:50:35','461','2020-04-09 10:50:57',10,0),('1','116',131943,'MORNING SHIFT','2020-04-09','2020-04-09 00:00:00',NULL,'461',1343900.50,1343900.50,'461','2020-04-09 18:00:01','461','2020-04-09 18:00:34',10,0),('1','116',132007,'AFTERNOON','2020-04-09','2020-04-09 00:00:00',NULL,'461',1353272.15,1353272.15,'461','2020-04-10 15:06:27','461','2020-04-10 15:08:25',10,0),('1','116',132089,'MORNING SHIFT','2020-04-10','2020-04-10 00:00:00',NULL,'461',1214119.65,1214119.65,'461','2020-04-10 15:13:16','461','2020-04-10 15:14:50',10,0),('1','116',132092,'AFTERNOON','2020-04-10','2020-04-10 00:00:00',NULL,'461',4589197.70,4589197.70,'461','2020-04-14 18:45:37','461','2020-04-14 18:47:21',10,0),('1','116',132398,'MORNING SHIFT','2020-04-11','2020-04-11 00:00:00',NULL,'461',1382909.45,1382909.45,'461','2020-04-14 19:02:23','461','2020-04-14 19:03:07',10,0),('1','116',132402,'AFTERNOON','2020-04-11','2020-04-11 00:00:00',NULL,'461',1786576.35,1786576.35,'461','2020-04-14 19:09:30','461','2020-04-14 19:12:05',10,0),('1','116',132404,'MORNING SHIFT','2020-04-12','2020-04-12 00:00:00',NULL,'461',1007268.25,1007268.25,'461','2020-04-14 19:21:34','461','2020-04-14 19:23:32',10,0),('1','116',132406,'AFTERNOON','2020-04-12','2020-04-12 00:00:00',NULL,'461',1376951.25,1376951.25,'461','2020-04-18 16:09:51','461','2020-04-18 16:10:34',10,0),('1','116',132891,'MORNING SHIFT','2020-04-13','2020-04-13 00:00:00',NULL,'461',1066820.00,1066820.00,'461','2020-04-18 16:16:46','461','2020-04-18 16:17:57',10,0),('1','116',132899,'AFTERNOON','2020-04-13','2020-04-13 00:00:00',NULL,'461',1499622.50,1499622.50,'461','2020-04-18 17:07:30','461','2020-04-18 17:09:09',10,0),('1','116',132904,'MORNING SHIFT','2020-04-15','2020-04-15 00:00:00',NULL,'461',1850376.25,1850376.25,'461','2020-04-18 17:21:29','461','2020-04-18 17:22:08',10,0),('1','116',132906,'AFTERNOON','2020-04-15','2020-04-15 00:00:00',NULL,'461',1695783.75,1695783.75,'461','2020-04-18 17:29:49','461','2020-04-18 17:35:25',10,0),('1','116',132909,'MORNING SHIFT','2020-04-16','2020-04-16 00:00:00',NULL,'461',1395524.20,1395524.20,'461','2020-04-18 17:43:17','461','2020-04-18 17:44:29',10,0),('1','116',132910,'AFTERNOON','2020-04-16','2020-04-16 00:00:00',NULL,'461',2005342.80,2005342.80,'461','2020-04-18 18:08:59','461','2020-04-18 18:09:36',10,0),('1','116',132912,'MORNING SHIFT','2020-04-17','2020-04-17 00:00:00',NULL,'461',1561001.15,1561001.15,'461','2020-04-18 18:17:41','461','2020-04-18 18:18:52',10,0),('1','116',132913,'AFTERNOON','2020-04-17','2020-04-17 00:00:00',NULL,'461',2315492.95,2315492.95,'461','2020-04-18 18:30:54','461','2020-04-18 18:31:34',10,0),('1','116',132914,'MORNING SHIFT','2020-04-18','2020-04-18 00:00:00',NULL,'461',1381743.50,1381743.50,'461','2020-04-18 18:36:42','461','2020-04-21 19:46:54',10,0),('1','116',133195,'AFTERNOON','2020-04-18','2020-04-18 00:00:00',NULL,'461',1648386.90,1648386.90,'461','2020-04-21 19:50:09','461','2020-04-21 19:50:48',10,0),('1','116',133198,'MORNING SHIFT','2020-04-19','2020-04-19 00:00:00',NULL,'461',1347176.90,1347176.90,'461','2020-04-21 19:57:28','461','2020-04-21 19:58:06',10,0),('1','116',133199,'AFTERNOON','2020-04-19','2020-04-19 00:00:00',NULL,'461',1261856.05,1261856.05,'461','2020-04-21 20:03:20','461','2020-04-21 20:04:08',10,0),('1','116',133200,'MORNING SHIFT','2020-04-20','2020-04-20 00:00:00',NULL,'461',1212139.70,1212139.70,'461','2020-04-21 20:07:33','461','2020-04-21 20:08:51',10,0),('1','116',133201,'AFTERNOON','2020-04-20','2020-04-20 00:00:00',NULL,'461',1939165.25,1939165.25,'461','2020-04-21 20:14:49','461','2020-04-21 20:15:37',10,0),('1','116',133202,'MORNING SHIFT','2020-04-21','2020-04-21 00:00:00',NULL,'461',1528816.45,1528816.45,'461','2020-04-21 20:20:33','461','2020-04-21 20:21:34',10,0),('1','116',133204,'AFTERNOON','2020-04-21','2020-04-21 00:00:00',NULL,'461',1894531.35,1894531.35,'461','2020-04-22 14:23:08','461','2020-04-22 14:25:25',10,0),('1','116',133282,'MORNING SHIFT','2020-04-22','2020-04-22 00:00:00',NULL,'461',1282170.80,1282170.80,'461','2020-04-22 14:30:37','461','2020-04-22 14:31:35',10,0),('1','116',133285,'AFTERNOON','2020-04-22','2020-04-22 00:00:00',NULL,'461',1766726.30,1766726.30,'461','2020-04-25 13:57:59','461','2020-04-25 13:58:26',10,0),('1','116',133627,'MORNING SHIFT','2020-04-23','2020-04-23 00:00:00',NULL,'461',1315455.05,1315455.05,'461','2020-04-25 14:13:42','461','2020-04-25 14:14:40',10,0),('1','116',133630,'AFTERNOON','2020-04-23','2020-04-23 00:00:00',NULL,'461',1882286.85,1882286.85,'461','2020-04-27 14:24:10','461','2020-04-27 14:24:51',10,0),('1','116',133832,'MORNING SHIFT','2020-04-24','2020-04-24 00:00:00',NULL,'461',1330833.60,1330833.60,'461','2020-04-27 14:31:17','461','2020-04-27 14:31:42',10,0),('1','116',133833,'AFTERNOON','2020-04-24','2020-04-24 00:00:00',NULL,'461',1899564.05,1899564.05,'461','2020-04-27 14:35:43','461','2020-04-27 14:36:23',10,0),('1','116',133835,'MORNING SHIFT','2020-04-26','2020-04-26 00:00:00',NULL,'461',1436070.15,1436070.15,'461','2020-04-27 14:39:49','461','2020-04-27 14:40:42',10,0),('1','116',133837,'AFTERNOON','2020-04-26','2020-04-26 00:00:00',NULL,'461',1264246.20,1264246.20,'461','2020-04-27 14:43:35','461','2020-04-27 14:44:04',10,0),('1','116',133838,'MORNING SHIFT','2020-04-27','2020-04-27 00:00:00',NULL,'461',1035179.95,1035179.95,'461','2020-04-27 14:47:09','461','2020-04-27 14:50:44',10,0),('1','116',133840,'AFTERNOON','2020-04-27','2020-04-27 00:00:00',NULL,'461',1939899.65,1939899.65,'461','2020-04-30 14:23:35','461','2020-04-30 14:24:13',10,0),('1','116',134203,'MORNING SHIFT','2020-04-28','2020-04-28 00:00:00',NULL,'461',1199673.80,1199673.80,'461','2020-04-30 14:30:31','461','2020-04-30 14:31:02',10,0),('1','116',134204,'AFTERNOON','2020-04-28','2020-04-28 00:00:00',NULL,'461',2015366.85,2015366.85,'461','2020-04-30 14:34:07','461','2020-04-30 14:34:39',10,0),('1','116',134205,'MORNING SHIFT','2020-04-29','2020-04-29 00:00:00',NULL,'461',1336075.60,1336075.60,'461','2020-04-30 14:39:02','461','2020-04-30 14:39:24',10,0),('1','116',134206,'AFTERNOON','2020-04-29','2020-04-29 00:00:00',NULL,'461',2096161.75,2096161.75,'461','2020-04-30 14:42:16','461','2020-04-30 14:43:03',10,0),('1','116',134207,'MORNING SHIFT','2020-04-30','2020-04-30 00:00:00',NULL,'461',1211308.70,1211308.70,'461','2020-04-30 14:45:12','461','2020-04-30 14:45:51',10,0),('1','116',134208,'AFTERNOON','2020-04-30','2020-04-30 00:00:00',NULL,'461',2071960.35,2071960.35,'461','2020-05-10 23:05:25','461','2020-05-10 23:11:56',10,0),('1','116',135290,'MORNING SHIFT','2020-05-01','2020-05-01 00:00:00',NULL,'461',1334234.60,1334234.60,'461','2020-05-10 23:18:47','461','2020-05-10 23:19:47',10,0),('1','116',135291,'AFTERNOON','2020-05-01','2020-05-01 00:00:00',NULL,'461',1909065.70,1909065.70,'461','2020-05-10 23:25:19','461','2020-05-10 23:26:26',10,0),('1','116',135292,'MORNING SHIFT','2020-05-02','2020-05-02 00:00:00',NULL,'461',1116721.25,1116721.25,'461','2020-05-10 23:31:43','461','2020-05-10 23:35:29',10,0),('1','116',135293,'AFTERNOON','2020-05-02','2020-05-02 00:00:00',NULL,'461',1813590.05,1813590.05,'461','2020-05-10 23:51:55','461','2020-05-10 23:52:54',10,0),('1','116',135294,'MORNING SHIFT','2020-05-03','2020-05-03 00:00:00',NULL,'461',995631.50,995631.50,'461','2020-05-10 23:59:21','461','2020-05-11 00:01:12',10,0),('1','116',135295,'AFTERNOON','2020-05-03','2020-05-03 00:00:00',NULL,'461',1315887.80,1315887.80,'461','2020-05-11 00:08:34','461','2020-05-11 00:09:40',10,0),('1','116',135296,'MORNING SHIFT','2020-05-04','2020-05-04 00:00:00',NULL,'461',871817.20,871817.20,'461','2020-05-11 00:16:18','461','2020-05-11 00:17:58',10,0),('1','116',135297,'AFTERNOON','2020-05-04','2020-05-04 00:00:00',NULL,'461',1847888.45,1847888.45,'461','2020-05-11 00:25:10','461','2020-05-11 00:25:59',10,0),('1','116',135298,'MORNING SHIFT','2020-05-05','2020-05-05 00:00:00',NULL,'461',1389455.80,1389455.80,'461','2020-05-11 00:36:58','461','2020-05-11 00:38:40',10,0),('1','116',135299,'AFTERNOON','2020-05-05','2020-05-05 00:00:00',NULL,'461',1612318.60,1612318.60,'461','2020-05-11 00:45:10','461','2020-05-11 00:46:03',10,0),('1','116',135300,'MORNING SHIFT','2020-05-06','2020-05-06 00:00:00',NULL,'461',1109278.75,1109278.75,'461','2020-05-11 00:53:39','461','2020-05-11 00:54:57',10,0),('1','116',135301,'AFTERNOON','2020-05-06','2020-05-06 00:00:00',NULL,'461',1917397.50,1917397.50,'461','2020-05-11 01:02:24','461','2020-05-11 01:04:12',10,0),('1','116',135302,'MORNING SHIFT','2020-05-07','2020-05-07 00:00:00',NULL,'461',1267289.15,1267289.15,'461','2020-05-11 01:09:27','461','2020-05-11 01:10:05',10,0),('1','116',135303,'AFTERNOON','2020-05-07','2020-05-07 00:00:00',NULL,'461',1930855.30,1930855.30,'461','2020-05-16 13:20:38','461','2020-05-16 13:24:01',10,0),('1','116',135930,'MORNING SHIFT','2020-05-08','2020-05-08 00:00:00',NULL,'461',1728416.30,1728416.30,'461','2020-05-16 14:48:31','461','2020-05-16 14:49:39',10,0),('1','116',135948,'AFTERNOON','2020-05-08','2020-05-08 00:00:00',NULL,'461',2142650.05,2142650.05,'461','2020-05-16 14:54:01','461','2020-05-16 14:54:33',10,0),('1','116',135950,'MORNING SHIFT','2020-05-09','2020-05-09 00:00:00',NULL,'461',1362566.05,1362566.05,'461','2020-05-16 14:58:09','461','2020-05-16 14:58:50',10,0),('1','116',135952,'AFTERNOON','2020-05-09','2020-05-09 00:00:00',NULL,'461',1799980.00,1799980.00,'461','2020-05-16 15:02:11','461','2020-05-16 15:02:53',10,0),('1','116',135953,'MORNING SHIFT','2020-05-10','2020-05-10 00:00:00',NULL,'461',1263861.80,1263861.80,'461','2020-05-16 15:11:11','461','2020-05-16 15:11:57',10,0),('1','116',135959,'AFTERNOON','2020-05-10','2020-05-10 00:00:00',NULL,'461',1253313.15,1253313.15,'461','2020-05-16 15:15:52','461','2020-05-16 15:16:20',10,0),('1','116',135962,'MORNING SHIFT','2020-05-11','2020-05-11 00:00:00',NULL,'461',1335049.05,1335049.05,'461','2020-05-16 15:30:37','461','2020-05-16 15:31:17',10,0),('1','116',135965,'AFTERNOON','2020-05-11','2020-05-11 00:00:00',NULL,'461',1904871.90,1904871.90,'461','2020-05-16 15:37:12','461','2020-05-16 15:37:48',10,0),('1','116',135967,'MORNING SHIFT','2020-05-12','2020-05-12 00:00:00',NULL,'461',1482056.65,1482056.65,'461','2020-05-21 17:10:43','461','2020-05-21 17:11:07',10,0),('1','116',136528,'AFTERNOON','2020-05-12','2020-05-12 00:00:00',NULL,'461',2206776.65,2206776.65,'461','2020-05-21 17:16:55','461','2020-05-21 17:18:48',10,0),('1','116',136531,'MORNING SHIFT','2020-05-13','2020-05-13 00:00:00',NULL,'461',1252436.70,1252436.70,'461','2020-05-21 17:23:57','461','2020-05-21 17:24:40',10,0),('1','116',136532,'AFTERNOON','2020-05-13','2020-05-13 00:00:00',NULL,'461',2102727.65,2102727.65,'461','2020-05-21 17:28:09','461','2020-05-21 17:28:39',10,0),('1','116',136533,'MORNING SHIFT','2020-05-14','2020-05-14 00:00:00',NULL,'461',1330283.70,1330283.70,'461','2020-05-21 17:33:17','461','2020-05-21 17:33:49',10,0),('1','116',136534,'AFTERNOON','2020-05-14','2020-05-14 00:00:00',NULL,'461',2040775.00,2040775.00,'461','2020-05-21 17:38:38','461','2020-05-21 17:39:28',10,0),('1','116',136535,'MORNING SHIFT','2020-05-15','2020-05-15 00:00:00',NULL,'461',1198383.15,1198383.15,'461','2020-05-21 17:44:08','461','2020-05-21 17:44:54',10,0),('1','116',136536,'AFTERNOON','2020-05-15','2020-05-15 00:00:00',NULL,'461',2017575.50,2017575.50,'461','2020-05-21 21:51:21','461','2020-05-21 21:52:49',10,0),('1','116',136540,'MORNING SHIFT','2020-05-16','2020-05-16 00:00:00',NULL,'461',1227843.60,1227843.60,'461','2020-05-21 21:58:25','461','2020-05-21 21:59:10',10,0),('1','116',136542,'AFTERNOON','2020-05-16','2020-05-16 00:00:00',NULL,'461',1539429.20,1539429.20,'461','2020-05-21 22:06:19','461','2020-05-21 22:07:13',10,0),('1','116',136545,'MORNING SHIFT','2020-05-17','2020-05-17 00:00:00',NULL,'461',1178448.35,1178448.35,'461','2020-05-21 22:27:08','461','2020-05-21 22:29:29',10,0),('1','116',136546,'AFTERNOON','2020-05-17','2020-05-17 00:00:00',NULL,'461',1121921.00,1121921.00,'461','2020-05-21 22:43:46','461','2020-05-21 22:44:13',10,0),('1','116',136547,'MORNING SHIFT','2020-05-18','2020-05-18 00:00:00',NULL,'461',1320585.75,1320585.75,'461','2020-05-21 22:48:52','461','2020-05-21 22:52:33',10,0),('1','116',136548,'AFTERNOON','2020-05-18','2020-05-18 00:00:00',NULL,'461',1919617.00,1919617.00,'461','2020-05-21 23:00:40','461','2020-05-21 23:10:27',10,0),('1','116',136549,'MORNING SHIFT','2020-05-19','2020-05-19 00:00:00',NULL,'461',1520635.55,1520635.55,'461','2020-05-21 23:17:25','461','2020-05-21 23:20:39',10,0),('1','116',136550,'AFTERNOON','2020-05-19','2020-05-19 00:00:00',NULL,'461',1918506.10,1918506.10,'461','2020-05-21 23:28:44','461','2020-05-21 23:29:25',10,0),('1','116',136551,'MORNING SHIFT','2020-05-20','2020-05-20 00:00:00',NULL,'461',1370177.45,1370177.45,'461','2020-05-21 23:37:02','461','2020-05-21 23:38:11',10,0),('1','116',136552,'AFTERNOON','2020-05-20','2020-05-20 00:00:00',NULL,'461',1762785.00,1762785.00,'461','2020-05-21 23:46:47','461','2020-05-21 23:47:50',10,0),('1','116',136553,'MORNING SHIFT','2020-05-21','2020-05-21 00:00:00',NULL,'461',1516200.00,1516200.00,'461','2020-05-22 15:57:59','461','2020-05-22 15:58:25',10,0),('1','116',136676,'AFTERNOON','2020-05-21','2020-05-21 00:00:00',NULL,'461',1902288.25,1902288.25,'461','2020-05-22 16:02:38','461','2020-05-22 16:03:11',10,0),('1','116',136680,'MORNING SHIFT','2020-05-22','2020-05-22 00:00:00',NULL,'461',1516414.55,1516414.55,'461','2020-05-22 16:10:39','461','2020-05-22 16:11:12',10,0),('1','116',136682,'AFTERNOON','2020-05-22','2020-05-22 00:00:00',NULL,'461',2434023.10,2434023.10,'461','2020-05-26 07:27:38','461','2020-05-26 07:28:16',10,0),('1','116',136999,'MORNING SHIFT','2020-05-23','2020-05-23 00:00:00',NULL,'461',1196277.30,1196277.30,'461','2020-05-26 07:32:57','461','2020-05-26 07:37:33',10,0),('1','116',137001,'AFTERNOON','2020-05-23','2020-05-23 00:00:00',NULL,'461',1668087.10,1668087.10,'461','2020-05-26 07:41:27','461','2020-05-26 07:41:55',10,0),('1','116',137004,'MORNING SHIFT','2020-05-24','2020-05-24 00:00:00',NULL,'461',990084.70,990084.70,'461','2020-05-29 11:07:05','461','2020-05-29 11:08:17',10,0),('1','116',137438,'AFTERNOON','2020-05-24','2020-05-24 00:00:00',NULL,'461',1174447.20,1174447.20,'461','2020-05-29 11:14:14','461','2020-05-29 11:14:54',10,0),('1','116',137439,'MORNING SHIFT','2020-05-25','2020-05-25 00:00:00',NULL,'461',1018435.40,1018435.40,'461','2020-05-29 11:19:42','461','2020-05-29 11:20:22',10,0),('1','116',137440,'AFTERNOON','2020-05-25','2020-05-25 00:00:00',NULL,'461',1328018.40,1328018.40,'461','2020-05-29 11:37:50','461','2020-05-29 11:38:21',10,0),('1','116',137442,'MORNING SHIFT','2020-05-26','2020-05-26 00:00:00',NULL,'461',1107989.05,1107989.05,'461','2020-05-29 11:41:33','461','2020-05-29 11:42:22',10,0),('1','116',137443,'AFTERNOON','2020-05-26','2020-05-26 00:00:00',NULL,'461',1501443.35,1501443.35,'461','2020-05-29 11:46:14','461','2020-05-29 11:47:36',10,0),('1','116',137445,'MORNING SHIFT','2020-05-27','2020-05-27 00:00:00',NULL,'461',1191453.70,1191453.70,'461','2020-05-29 16:13:55','461','2020-05-29 16:15:16',10,0),('1','116',137482,'AFTERNOON','2020-05-27','2020-05-27 00:00:00',NULL,'461',1871527.45,1871527.45,'461','2020-05-29 16:19:23','461','2020-05-29 16:20:20',10,0),('1','116',137484,'MORNING SHIFT','2020-05-28','2020-05-28 00:00:00',NULL,'461',1173380.75,1173380.75,'461','2020-05-29 16:26:18','461','2020-05-29 16:26:54',10,0),('1','116',137488,'AFTERNOON','2020-05-28','2020-05-28 00:00:00',NULL,'461',1636641.25,1636641.25,'461','2020-05-29 16:36:27','461','2020-05-29 16:37:11',10,0),('1','116',137489,'MORNING SHIFT','2020-05-29','2020-05-29 00:00:00',NULL,'461',1080673.20,1080673.20,'461','2020-05-29 16:40:29','461','2020-05-29 16:42:28',10,0),('1','116',137605,'AFTERNOON','2020-05-29','2020-05-29 00:00:00',NULL,'461',422372.10,422372.10,'461','2020-05-30 19:40:27','461','2020-05-30 19:40:59',10,0),('1','116',137611,'MORNING SHIFT','2020-05-30','2020-05-30 00:00:00',NULL,'461',1276515.70,1276515.70,'461','2020-05-30 19:48:51','461','2020-05-30 19:49:23',10,0),('1','116',137612,'AFTERNOON','2020-05-30','2020-05-30 00:00:00',NULL,'461',1760693.95,1760693.95,'461','2020-06-02 16:16:53','461','2020-06-02 16:18:32',10,0),('1','116',137940,'MORNING SHIFT','2020-05-31','2020-05-31 00:00:00',NULL,'461',1049067.20,1049067.20,'461','2020-06-02 16:23:02','461','2020-06-02 16:27:26',10,0),('1','116',137943,'AFTERNOON','2020-05-31','2020-05-31 00:00:00',NULL,'461',1355896.95,1355896.95,'461','2020-06-02 16:37:17','461','2020-06-02 16:37:43',10,0),('1','116',137944,'MORNING SHIFT','2020-06-01','2020-06-01 00:00:00',NULL,'461',412196.25,412196.25,'461','2020-06-02 16:44:14','461','2020-06-02 16:45:23',10,0),('1','116',137988,'MORNING SHIFT','2020-06-01','2020-06-01 00:00:00',NULL,'461',894637.03,894637.03,'461','2020-06-03 09:36:22','461','2020-06-03 09:37:14',10,0),('1','116',137989,'AFTERNOON','2020-06-01','2020-06-01 00:00:00',NULL,'461',1937986.45,1937986.45,'461','2020-06-03 09:42:25','461','2020-06-03 09:43:07',10,0),('1','116',137990,'MORNING SHIFT','2020-06-02','2020-06-02 00:00:00',NULL,'461',1191708.75,1191708.75,'461','2020-06-04 18:27:19','461','2020-06-04 18:30:18',10,0),('1','116',138235,'AFTERNOON','2020-06-02','2020-06-02 00:00:00',NULL,'461',2017990.13,2017990.13,'461','2020-06-04 18:35:22','461','2020-06-04 18:36:01',10,0),('1','116',138236,'MORNING SHIFT','2020-06-03','2020-06-03 00:00:00',NULL,'461',1451359.50,1451359.50,'461','2020-06-04 18:39:54','461','2020-06-04 18:40:40',10,0),('1','116',138237,'AFTERNOON','2020-06-03','2020-06-03 00:00:00',NULL,'461',1986953.10,1986953.10,'461','2020-06-04 18:46:26','461','2020-06-04 18:47:58',10,0),('1','116',138238,'MORNING SHIFT','2020-06-04','2020-06-04 00:00:00',NULL,'461',1582390.18,1582390.18,'461','2020-06-04 18:51:19','461','2020-06-04 18:51:50',10,0),('1','116',138239,'AFTERNOON','2020-06-04','2020-06-04 00:00:00',NULL,'461',1958794.08,1958794.08,'461','2020-06-06 13:57:10','461','2020-06-06 13:57:38',10,0),('1','116',138394,'MORNING SHIFT','2020-06-05','2020-06-05 00:00:00',NULL,'461',1354660.48,1354660.48,'461','2020-06-06 14:01:37','461','2020-06-06 14:02:06',10,0),('1','116',138397,'AFTERNOON','2020-06-05','2020-06-05 00:00:00',NULL,'461',2205554.23,2205554.23,'461','2020-06-06 14:05:32','461','2020-06-06 14:07:04',10,0),('1','116',138399,'MORNING SHIFT','2020-06-06','2020-06-06 00:00:00',NULL,'461',1515502.93,1515502.93,'461','2020-06-06 14:14:40','461','2020-06-06 14:15:14',10,0),('1','116',138401,'AFTERNOON','2020-06-06','2020-06-06 00:00:00',NULL,'461',1519386.08,1519386.08,'461','2020-06-11 14:14:42','461','2020-06-11 14:15:14',10,0),('1','116',139063,'MORNING SHIFT','2020-06-07','2020-06-07 00:00:00',NULL,'461',1084802.23,1084802.23,'461','2020-06-11 14:25:02','461','2020-06-11 14:25:32',10,0),('1','116',139070,'AFTERNOON','2020-06-07','2020-06-07 00:00:00',NULL,'461',1300047.53,1300047.53,'461','2020-06-11 14:28:39','461','2020-06-11 14:29:14',10,0),('1','116',139072,'MORNING SHIFT','2020-06-08','2020-06-08 00:00:00',NULL,'461',1306384.10,1306384.10,'461','2020-06-11 14:32:38','461','2020-06-11 14:33:17',10,0),('1','116',139075,'AFTERNOON','2020-06-08','2020-06-08 00:00:00',NULL,'461',2046078.60,2046078.60,'461','2020-06-11 14:35:43','461','2020-06-11 14:36:09',10,0),('1','116',139078,'MORNING SHIFT','2020-06-09','2020-06-09 00:00:00',NULL,'461',1169639.98,1169639.98,'461','2020-06-11 14:38:13','461','2020-06-11 14:39:10',10,0),('1','116',139080,'AFTERNOON','2020-06-09','2020-06-09 00:00:00',NULL,'461',1933315.00,1933315.00,'461','2020-06-11 14:41:40','461','2020-06-11 14:42:07',10,0),('1','116',139082,'MORNING SHIFT','2020-06-10','2020-06-10 00:00:00',NULL,'461',1147606.73,1147606.73,'461','2020-06-11 14:45:35','461','2020-06-11 14:46:01',10,0),('1','116',139084,'AFTERNOON','2020-06-10','2020-06-10 00:00:00',NULL,'461',1871730.75,1871730.75,'461','2020-06-11 14:48:42','461','2020-06-11 14:49:11',10,0),('1','116',139086,'MORNING SHIFT','2020-06-11','2020-06-11 00:00:00',NULL,'461',1180279.98,1180279.98,'461','2020-06-11 14:52:25','461','2020-06-11 14:52:52',10,0),('1','116',139088,'AFTERNOON','2020-06-11','2020-06-11 00:00:00',NULL,'461',1740507.00,1740507.00,'461','2020-06-15 13:43:08','461','2020-06-15 13:43:32',10,0),('1','116',139521,'MORNING SHIFT','2020-06-12','2020-06-12 00:00:00',NULL,'461',1343155.25,1343155.25,'461','2020-06-15 13:56:34','461','2020-06-15 13:58:06',10,0),('1','116',139524,'AFTERNOON','2020-06-12','2020-06-12 00:00:00',NULL,'461',1702698.83,1702698.83,'461','2020-06-15 14:14:44','461','2020-06-15 14:15:27',10,0),('1','116',139526,'MORNING SHIFT','2020-06-13','2020-06-13 00:00:00',NULL,'461',1087041.15,1087041.15,'461','2020-06-15 15:05:35','461','2020-06-15 15:06:10',10,0),('1','116',139541,'AFTERNOON','2020-06-13','2020-06-13 00:00:00',NULL,'461',1337789.48,1337789.48,'461','2020-06-15 15:25:08','461','2020-06-15 15:25:58',10,0),('1','116',139544,'MORNING SHIFT','2020-06-14','2020-06-14 00:00:00',NULL,'461',1142183.98,1142183.98,'461','2020-06-15 15:31:04','461','2020-06-15 15:32:39',10,0),('1','116',139546,'AFTERNOON','2020-06-14','2020-06-14 00:00:00',NULL,'461',1272224.48,1272224.48,'461','2020-06-15 15:36:11','461','2020-06-15 15:37:06',10,0),('1','116',139547,'MORNING SHIFT','2020-06-15','2020-06-15 00:00:00',NULL,'461',1424359.45,1424359.45,'461','2020-06-15 15:50:11','461','2020-06-17 16:31:16',10,0),('1','116',139826,'AFTERNOON','2020-06-15','2020-06-15 00:00:00',NULL,'461',2028578.35,2028578.35,'461','2020-06-17 16:39:58','461','2020-06-17 16:40:59',10,0),('1','116',139830,'MORNING SHIFT','2020-06-16','2020-06-16 00:00:00',NULL,'461',1212272.80,1212272.80,'461','2020-06-17 16:44:46','461','2020-06-17 16:45:28',10,0),('1','116',139831,'AFTERNOON','2020-06-16','2020-06-16 00:00:00',NULL,'461',1801232.73,1801232.73,'461','2020-06-17 16:50:07','461','2020-06-17 16:50:36',10,0),('1','116',139832,'MORNING SHIFT','2020-06-17','2020-06-17 00:00:00',NULL,'461',1384389.70,1384389.70,'461','2020-06-18 12:46:42','461','2020-06-18 12:47:16',10,0),('1','116',139921,'AFTERNOON','2020-06-17','2020-06-17 00:00:00',NULL,'461',1702566.40,1702566.40,'461','2020-06-18 12:50:44','461','2020-06-18 12:53:57',10,0),('1','116',139923,'MORNING SHIFT','2020-06-18','2020-06-18 00:00:00',NULL,'461',1089080.23,1089080.23,'461','2020-06-18 12:58:39','461','2020-06-19 10:20:34',10,0),('1','116',140008,'AFTERNOON','2020-06-18','2020-06-18 00:00:00',NULL,'461',1857209.53,1857209.53,'461','2020-06-19 10:28:31','461','2020-06-19 13:45:41',10,0),('1','116',140040,'MORNING SHIFT','2020-06-19','2020-06-19 00:00:00',NULL,'461',1257008.68,1257008.68,'461','2020-06-19 13:49:51','461','2020-06-19 13:50:20',10,0),('1','116',140041,'AFTERNOON','2020-06-19','2020-06-19 00:00:00',NULL,'461',2124531.30,2124531.30,'461','2020-06-20 20:30:47','461','2020-06-20 20:31:18',10,0),('1','116',140196,'MORNING SHIFT','2020-06-20','2020-06-20 00:00:00',NULL,'461',1145750.48,1145750.48,'461','2020-06-20 20:35:22','461','2020-06-20 20:36:53',10,0),('1','116',140197,'AFTERNOON','2020-06-20','2020-06-20 00:00:00',NULL,'461',1699183.98,1699183.98,'461','2020-06-21 15:39:38','461','2020-06-21 15:40:01',10,0),('1','116',140289,'MORNING SHIFT','2020-06-21','2020-06-21 00:00:00',NULL,'461',819293.28,819293.28,'461','2020-06-21 15:42:51','461','2020-06-21 15:46:46',10,0),('1','116',140290,'AFTERNOON','2020-06-21','2020-06-21 00:00:00',NULL,'461',1383870.10,1383870.10,'461','2020-06-22 13:38:48','461','2020-06-22 13:39:20',10,0),('1','116',140388,'MORNING SHIFT','2020-06-22','2020-06-22 00:00:00',NULL,'461',1093463.85,1093463.85,'461','2020-06-22 13:44:54','461','2020-06-22 13:45:51',10,0),('1','116',140391,'AFTERNOON','2020-06-22','2020-06-22 00:00:00',NULL,'461',1715599.78,1715599.78,'461','2020-06-23 10:03:54','461','2020-06-23 12:38:45',10,0),('1','116',140503,'MORNING SHIFT','2020-06-23','2020-06-23 00:00:00',NULL,'461',1263054.80,1263054.80,'461','2020-06-23 12:42:32','461','2020-06-24 09:59:29',10,0),('1','116',140602,'AFTERNOON','2020-06-23','2020-06-23 00:00:00',NULL,'461',1908694.05,1908694.05,'461','2020-06-24 14:35:17','461','2020-06-24 14:35:56',10,0),('1','116',140665,'MORNING SHIFT','2020-06-24','2020-06-24 00:00:00',NULL,'461',1177443.63,1177443.63,'461','2020-06-24 14:41:07','461','2020-06-24 14:41:53',10,0),('1','116',140669,'AFTERNOON','2020-06-24','2020-06-24 00:00:00',NULL,'461',2118467.83,2118467.83,'461','2020-06-25 11:40:47','461','2020-06-25 11:41:28',10,0),('1','116',140776,'MORNING SHIFT','2020-06-25','2020-06-25 00:00:00',NULL,'461',1230321.93,1230321.93,'461','2020-06-25 14:43:15','461','2020-06-25 14:43:48',10,0),('1','116',140822,'AFTERNOON','2020-06-25','2020-06-25 00:00:00',NULL,'461',2007302.93,2007302.93,'461','2020-06-26 10:34:49','461','2020-06-26 10:35:13',10,0),('1','116',140879,'MORNING SHIFT','2020-06-26','2020-06-26 00:00:00',NULL,'461',1335960.35,1335960.35,'461','2020-06-26 14:12:01','461','2020-06-26 14:12:33',10,0),('1','116',140913,'AFTERNOON','2020-06-26','2020-06-26 00:00:00',NULL,'461',2198653.65,2198653.65,'461','2020-06-29 14:13:20','461','2020-06-29 14:13:42',10,0),('1','116',141249,'MORNING SHIFT','2020-06-27','2020-06-27 00:00:00',NULL,'461',1567281.18,1567281.18,'461','2020-06-29 14:21:57','461','2020-06-29 14:22:22',10,0),('1','116',141251,'AFTERNOON','2020-06-27','2020-06-27 00:00:00',NULL,'461',1877604.61,1877604.61,'461','2020-06-29 14:25:09','461','2020-06-29 14:25:38',10,0),('1','116',141253,'MORNING SHIFT','2020-06-28','2020-06-28 00:00:00',NULL,'461',1146153.63,1146153.63,'461','2020-06-29 14:28:49','461','2020-06-29 14:29:25',10,0),('1','116',141256,'AFTERNOON','2020-06-28','2020-06-28 00:00:00',NULL,'461',1571083.99,1571083.99,'461','2020-06-29 14:32:34','461','2020-06-29 14:33:01',10,0),('1','116',141258,'MORNING SHIFT','2020-06-29','2020-06-29 00:00:00',NULL,'461',1331517.12,1331517.12,'461','2020-06-29 14:36:45','461','2020-06-29 14:37:26',10,0),('1','116',141262,'AFTERNOON','2020-06-29','2020-06-29 00:00:00',NULL,'461',2112001.71,2112001.71,'461','2020-06-30 13:48:26','461','2020-06-30 13:48:57',10,0),('1','116',141395,'MORNING SHIFT','2020-06-30','2020-06-30 00:00:00',NULL,'461',1393997.50,1393997.50,'461','2020-06-30 13:57:57','461','2020-06-30 13:58:30',10,0),('1','116',141397,'AFTERNOON','2020-06-30','2020-06-30 00:00:00',NULL,'461',2077672.75,2077672.75,'461','2020-07-01 15:12:26','461','2020-07-01 15:25:23',10,0),('1','116',141562,'MORNING SHIFT','2020-07-01','2020-07-01 00:00:00',NULL,'461',1669470.96,1669470.96,'461','2020-07-01 15:31:44','461','2020-07-01 15:33:25',10,0),('1','116',141563,'AFTERNOON','2020-07-01','2020-07-01 00:00:00',NULL,'461',2243656.08,2243656.08,'461','2020-07-02 17:38:12','461','2020-07-02 17:39:35',10,0),('1','116',141708,'MORNING SHIFT','2020-07-02','2020-07-02 00:00:00',NULL,'461',315415.45,315415.45,'461','2020-07-02 17:46:18','461','2020-07-02 17:47:31',10,0),('1','116',141710,'MORNING SHIFT','2020-07-02','2020-07-02 00:00:00',NULL,'461',242287.18,242287.18,'461','2020-07-02 18:13:24','461','2020-07-02 18:13:55',10,0),('1','116',141712,'MORNING SHIFT','2020-07-02','2020-07-02 00:00:00',NULL,'461',1225402.38,1225402.38,'461','2020-07-02 18:24:53','461','2020-07-02 18:25:36',10,0),('1','116',141713,'AFTERNOON','2020-07-02','2020-07-02 00:00:00',NULL,'461',2647063.39,2647063.39,'461','2020-07-04 15:48:05','461','2020-07-04 15:49:15',10,0),('1','116',141928,'MORNING SHIFT','2020-07-03','2020-07-03 00:00:00',NULL,'461',1480608.17,1690854.12,'461','2020-07-04 15:55:16','461','2020-07-04 15:56:07',10,0),('1','116',141929,'AFTERNOON','2020-07-03','2020-07-03 00:00:00',NULL,'461',1820867.90,2097387.48,'461','2020-07-04 16:01:14','461','2020-07-04 16:01:39',10,0),('1','116',141930,'MORNING SHIFT','2020-07-04','2020-07-04 00:00:00',NULL,'461',1150232.98,1334503.99,'461','2020-07-04 16:07:02','461','2020-07-04 16:07:53',10,0),('1','116',141931,'AFTERNOON','2020-07-04','2020-07-04 00:00:00',NULL,'461',1773543.68,2018548.81,'461','2020-07-05 14:32:30','461','2020-07-05 14:33:45',10,0),('1','116',142033,'MORNING SHIFT','2020-07-05','2020-07-05 00:00:00',NULL,'461',1073740.41,1227949.81,'461','2020-07-06 14:49:55','461','2020-07-06 14:50:26',10,0),('1','116',142155,'AFTERNOON','2020-07-05','2020-07-05 00:00:00',NULL,'461',1599078.61,1599078.61,'461','2020-07-06 14:55:19','461','2020-07-06 14:55:54',10,0),('1','116',142158,'MORNING SHIFT','2020-07-06','2020-07-06 00:00:00',NULL,'461',1342037.29,1342037.29,'461','2020-07-06 14:59:00','461','2020-07-07 10:41:49',10,0),('1','116',142229,'AFTERNOON','2020-07-06','2020-07-06 00:00:00',NULL,'461',2117999.39,2117999.39,'461','2020-07-07 10:45:31','461','2020-07-07 10:49:19',10,0),('1','116',142274,'MORNING SHIFT','2020-07-07','2020-07-07 00:00:00',NULL,'461',1460481.98,1460481.98,'461','2020-07-07 14:09:38','461','2020-07-07 14:10:01',10,0),('1','116',142275,'AFTERNOON','2020-07-07','2020-07-07 00:00:00',NULL,'461',2027162.12,2027162.12,'461','2020-07-08 13:52:32','461','2020-07-08 13:52:52',10,0),('1','116',142408,'MORNING SHIFT','2020-07-08','2020-07-08 00:00:00',NULL,'461',1323154.26,1323154.26,'461','2020-07-08 14:00:28','461','2020-07-09 09:20:09',10,0),('1','116',142491,'AFTERNOON','2020-07-08','2020-07-08 00:00:00',NULL,'461',2166715.59,2166715.59,'461','2020-07-09 18:22:12','461','2020-07-09 18:23:03',10,0),('1','116',142582,'MORNING SHIFT','2020-07-09','2020-07-09 00:00:00',NULL,'461',1445094.51,1445094.51,'461','2020-07-09 18:32:24','461','2020-07-10 19:02:16',10,0),('1','116',142704,'AFTERNOON','2020-07-09','2020-07-09 00:00:00',NULL,'461',2095325.18,2095325.18,'461','2020-07-10 19:05:55','461','2020-07-10 19:06:17',10,0),('1','116',142705,'MORNING SHIFT','2020-07-10','2020-07-10 00:00:00',NULL,'461',1289206.73,1289206.73,'461','2020-07-10 19:13:35','461','2020-07-10 19:14:28',10,0),('1','116',142707,'AFTERNOON','2020-07-10','2020-07-10 00:00:00',NULL,'461',2247327.34,2247327.34,'461','2020-07-11 12:04:20','461','2020-07-11 12:04:55',10,0),('1','116',142762,'MORNING SHIFT','2020-07-11','2020-07-11 00:00:00',NULL,'461',1494665.45,1494665.45,'461','2020-07-11 13:30:41','461','2020-07-11 13:32:28',10,0),('1','116',142795,'AFTERNOON','2020-07-11','2020-07-11 00:00:00',NULL,'461',1672897.38,1672897.38,'461','2020-07-12 16:09:00','461','2020-07-12 16:09:24',10,0),('1','116',142939,'MORNING SHIFT','2020-07-12','2020-07-12 00:00:00',NULL,'461',1134737.26,1134737.26,'461','2020-07-12 16:12:44','461','2020-07-12 16:13:14',10,0),('1','116',142941,'AFTERNOON','2020-07-12','2020-07-12 00:00:00',NULL,'461',1207541.13,1207541.13,'461','2020-07-13 10:24:54','461','2020-07-13 10:25:22',10,0),('1','116',142997,'MORNING SHIFT','2020-07-13','2020-07-13 00:00:00',NULL,'461',1465391.91,1465391.91,'461','2020-07-14 13:32:26','461','2020-07-14 13:33:05',10,0),('1','116',143152,'AFTERNOON','2020-07-13','2020-07-13 00:00:00',NULL,'461',1997122.96,1997122.96,'461','2020-07-14 13:40:33','461','2020-07-14 13:43:29',10,0),('1','116',143165,'MORNING SHIFT','2020-07-14','2020-07-14 00:00:00',NULL,'461',1396553.14,1396553.14,'461','2020-07-14 14:10:07','461','2020-07-14 14:11:19',10,0),('1','116',143167,'AFTERNOON','2020-07-14','2020-07-14 00:00:00',NULL,'461',2011309.23,2011309.23,'461','2020-07-15 13:40:39','461','2020-07-15 13:41:05',10,0),('1','116',143280,'MORNING SHIFT','2020-07-15','2020-07-15 00:00:00',NULL,'461',1267084.36,1267084.36,'461','2020-07-15 13:54:52','461','2020-07-15 13:56:47',10,0),('1','116',143282,'AFTERNOON','2020-07-15','2020-07-15 00:00:00',NULL,'461',2339827.27,2339827.27,'461','2020-07-16 14:26:31','461','2020-07-16 14:31:10',10,0),('1','116',143434,'MORNING SHIFT','2020-07-16','2020-07-16 00:00:00',NULL,'461',1313855.03,1313855.03,'461','2020-07-16 14:41:52','461','2020-07-16 14:43:21',10,0),('1','116',143436,'AFTERNOON','2020-07-16','2020-07-16 00:00:00',NULL,'461',2060679.42,2060679.42,'461','2020-07-17 15:18:14','461','2020-07-17 15:20:04',10,0),('1','116',143564,'MORNING SHIFT','2020-07-17','2020-07-17 00:00:00',NULL,'461',1315360.44,1315360.44,'461','2020-07-17 15:24:16','461','2020-07-17 15:24:41',10,0),('1','116',143565,'AFTERNOON','2020-07-17','2020-07-17 00:00:00',NULL,'461',2250738.69,2250738.69,'461','2020-07-18 19:11:36','461','2020-07-18 19:23:33',10,0),('1','116',143741,'MORNING SHIFT','2020-07-18','2020-07-18 00:00:00',NULL,'461',1182720.81,1182720.81,'461','2020-07-18 19:39:39','461','2020-07-18 19:40:28',10,0),('1','116',143743,'AFTERNOON','2020-07-18','2020-07-18 00:00:00',NULL,'461',1739595.69,1739595.69,'461','2020-07-19 19:18:35','461','2020-07-19 19:20:46',10,0),('1','116',143888,'MORNING SHIFT','2020-07-19','2020-07-19 00:00:00',NULL,'461',1300658.87,1300658.87,'461','2020-07-19 19:32:50','461','2020-07-19 19:33:22',10,0),('1','116',143891,'AFTERNOON','2020-07-19','2020-07-19 00:00:00',NULL,'461',1472127.74,1472127.74,'461','2020-07-20 13:11:30','461','2020-07-20 13:11:52',10,0),('1','116',143972,'MORNING SHIFT','2020-07-20','2020-07-20 00:00:00',NULL,'461',1530038.20,1530038.20,'461','2020-07-23 16:42:34','461','2020-07-23 16:52:09',10,0),('1','116',144422,'AFTERNOON','2020-07-20','2020-07-20 00:00:00',NULL,'461',2045521.78,2045521.78,'461','2020-07-23 17:11:26','461','2020-07-23 17:12:10',10,0),('1','116',144429,'MORNING SHIFT','2020-07-21','2020-07-21 00:00:00',NULL,'461',1130821.38,1130821.38,'461','2020-07-23 17:16:58','461','2020-07-23 17:17:26',10,0),('1','116',144432,'AFTERNOON','2020-07-21','2020-07-21 00:00:00',NULL,'461',1567262.36,1567262.36,'461','2020-07-23 17:24:09','461','2020-07-23 17:25:03',10,0),('1','116',144434,'MORNING SHIFT','2020-07-22','2020-07-22 00:00:00',NULL,'461',1224955.66,1224955.66,'461','2020-07-23 19:51:16','461','2020-07-23 19:51:57',10,0),('1','116',144450,'AFTERNOON','2020-07-22','2020-07-22 00:00:00',NULL,'461',2178024.70,2178024.70,'461','2020-07-23 19:55:46','461','2020-07-23 19:56:24',10,0),('1','116',144451,'MORNING SHIFT','2020-07-23','2020-07-23 00:00:00',NULL,'461',1497798.61,1497798.61,'461','2020-07-24 17:48:25','461','2020-07-24 17:51:04',10,0),('1','116',144576,'AFTERNOON','2020-07-23','2020-07-23 00:00:00',NULL,'461',2079330.85,2079330.85,'461','2020-07-24 17:56:40','461','2020-07-24 17:57:33',10,0),('1','116',144578,'MORNING SHIFT','2020-07-24','2020-07-24 00:00:00',NULL,'461',1482811.54,1482811.54,'461','2020-07-24 18:04:21','461','2020-07-24 18:04:55',10,0),('1','116',144581,'AFTERNOON','2020-07-24','2020-07-24 00:00:00',NULL,'461',2187249.38,2187249.38,'461','2020-07-26 12:06:40','461','2020-07-26 12:07:49',10,0),('1','116',144766,'MORNING SHIFT','2020-07-25','2020-07-25 00:00:00',NULL,'461',1142946.42,1142946.42,'461','2020-07-26 12:11:49','461','2020-07-26 12:12:20',10,0),('1','116',144767,'AFTERNOON','2020-07-25','2020-07-25 00:00:00',NULL,'461',2237572.09,2237572.09,'461','2020-07-26 12:18:24','461','2020-07-26 12:18:50',10,0),('1','116',144769,'MORNING SHIFT','2020-07-26','2020-07-26 00:00:00',NULL,'461',1025576.27,1025576.27,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',145920,'MORNING SHIFT','2020-07-26','2020-07-26 00:00:00',NULL,'461',1019856.27,1019856.27,'461','2020-08-05 05:45:21','461','2020-08-05 05:46:10',10,0),('1','116',145921,'AFTERNOON','2020-07-26','2020-07-26 00:00:00',NULL,'461',1417609.65,1417609.65,'461','2020-08-05 05:50:58','461','2020-08-05 05:51:48',10,0),('1','116',145922,'MORNING SHIFT','2020-07-27','2020-07-27 00:00:00',NULL,'461',1270506.12,1270506.12,'461','2020-08-05 05:58:10','461','2020-08-05 05:58:48',10,0),('1','116',145923,'AFTERNOON','2020-07-27','2020-07-27 00:00:00',NULL,'461',2394956.53,2394956.53,'461','2020-08-05 06:04:47','461','2020-08-05 06:05:18',10,0),('1','116',145925,'MORNING SHIFT','2020-07-28','2020-07-28 00:00:00',NULL,'461',1088084.36,1088084.36,'461','2020-08-05 06:10:01','461','2020-08-05 06:10:49',10,0),('1','116',145927,'AFTERNOON','2020-07-28','2020-07-28 00:00:00',NULL,'461',2393614.57,2393614.57,'461','2020-08-05 06:19:01','461','2020-08-05 06:19:44',10,0),('1','116',145929,'MORNING SHIFT','2020-07-29','2020-07-29 00:00:00',NULL,'461',1525348.29,1525348.29,'461','2020-08-05 06:24:24','461','2020-08-05 06:24:55',10,0),('1','116',145931,'AFTERNOON','2020-07-29','2020-07-29 00:00:00',NULL,'461',2963208.65,2963208.65,'461','2020-08-05 06:30:53','461','2020-08-05 06:31:30',10,0),('1','116',145932,'MORNING SHIFT','2020-07-30','2020-07-30 00:00:00',NULL,'461',0.00,0.00,'461','2020-08-05 06:33:44','461','2020-08-05 06:35:56',10,0),('1','116',145933,'MORNING SHIFT','2020-07-30','2020-07-30 00:00:00',NULL,'461',1292355.14,1292355.14,'461','2020-08-05 06:40:08','461','2020-08-05 06:40:49',10,0),('1','116',145935,'AFTERNOON','2020-07-30','2020-07-30 00:00:00',NULL,'461',3267899.99,3267899.99,'461','2020-08-05 06:46:31','461','2020-08-05 06:47:22',10,0),('1','116',145937,'MORNING SHIFT','2020-07-31','2020-07-31 00:00:00',NULL,'461',1003246.11,1003246.11,'461','2020-08-05 06:52:38','461','2020-08-05 06:53:02',10,0),('1','116',145938,'AFTERNOON','2020-07-31','2020-07-31 00:00:00',NULL,'461',1751091.06,1751091.06,'461','2020-08-05 06:56:50','461','2020-08-05 06:57:15',10,0),('1','116',145940,'MORNING SHIFT','2020-08-01','2020-08-01 00:00:00',NULL,'461',966982.07,966982.07,'461','2020-08-05 07:01:39','461','2020-08-05 07:02:10',10,0),('1','116',145943,'AFTERNOON','2020-08-01','2020-08-01 00:00:00',NULL,'461',1910594.96,1910594.96,'461','2020-08-05 07:12:25','461','2020-08-05 07:13:06',10,0),('1','116',145945,'MORNING SHIFT','2020-08-02','2020-08-02 00:00:00',NULL,'461',879748.39,879748.39,'461','2020-08-05 07:23:16','461','2020-08-05 07:23:43',10,0),('1','116',145949,'MORNING SHIFT','2020-08-02','2020-08-02 00:00:00',NULL,'461',1438795.87,1438795.87,'461','2020-08-05 07:28:23','461','2020-08-05 07:33:26',10,0),('1','116',145951,'MORNING SHIFT','2020-08-03','2020-08-03 00:00:00',NULL,'461',1179479.06,1179479.06,'461','2020-08-05 07:41:05','461','2020-08-05 07:41:37',10,0),('1','116',145952,'AFTERNOON','2020-08-03','2020-08-03 00:00:00',NULL,'461',2241490.83,2241490.83,'461','2020-08-13 07:24:56','461','2020-08-13 07:26:47',10,0),('1','116',147127,'MORNING SHIFT','2020-08-04','2020-08-04 00:00:00',NULL,'461',997198.95,997198.95,'461','2020-08-13 07:37:05','461','2020-08-13 07:37:41',10,0),('1','116',147129,'AFTERNOON','2020-08-04','2020-08-04 00:00:00',NULL,'461',1872803.02,1872803.02,'461','2020-08-13 07:50:15','461','2020-08-13 07:51:30',10,0),('1','116',147133,'MORNING SHIFT','2020-08-05','2020-08-05 00:00:00',NULL,'461',711976.87,711976.87,'461','2020-08-13 07:58:25','461','2020-08-13 07:59:32',10,0),('1','116',147135,'AFTERNOON','2020-08-06','2020-08-06 00:00:00',NULL,'461',2287720.41,2287720.41,'461','2020-08-13 08:07:41','461','2020-08-13 08:08:27',10,0),('1','116',147136,'MORNING SHIFT','2020-08-07','2020-08-07 00:00:00',NULL,'461',1548397.64,1548397.64,'461','2020-08-13 08:24:13','461','2020-08-13 08:27:21',10,0),('1','116',147140,'AFTERNOON','2020-08-07','2020-08-07 00:00:00',NULL,'461',2275637.81,2275637.81,'461','2020-08-13 08:33:08','461','2020-08-13 08:33:47',10,0),('1','116',147141,'MORNING SHIFT','2020-08-08','2020-08-08 00:00:00',NULL,'461',1525628.26,1525628.26,'461','2020-08-13 08:38:50','461','2020-08-13 08:40:00',10,0),('1','116',147145,'AFTERNOON','2020-08-08','2020-08-08 00:00:00',NULL,'461',1966709.03,1966709.03,'461','2020-08-13 08:46:18','461','2020-08-13 08:46:56',10,0),('1','116',147146,'MORNING SHIFT','2020-08-09','2020-08-09 00:00:00',NULL,'461',1152910.33,1152910.33,'461','2020-08-13 08:50:35','461','2020-08-13 08:51:33',10,0),('1','116',147147,'AFTERNOON','2020-08-09','2020-08-09 00:00:00',NULL,'461',884836.81,884836.81,'461','2020-08-13 08:56:07','461','2020-08-13 08:56:32',10,0),('1','116',147148,'AFTERNOON','2020-08-09','2020-08-09 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',147150,'AFTERNOON','2020-08-09','2020-08-09 00:00:00',NULL,'461',647855.20,647855.20,'461','2020-08-13 10:34:14','461','2020-08-13 10:34:40',10,0),('1','116',147184,'MORNING SHIFT','2020-08-10','2020-08-10 00:00:00',NULL,'461',1316558.50,1316558.50,'461','2020-08-13 10:43:26','461','2020-08-13 10:43:51',10,0),('1','116',147186,'AFTERNOON','2020-08-10','2020-08-10 00:00:00',NULL,'461',2290802.18,2290802.18,'461','2020-08-13 10:57:54','461','2020-08-13 11:09:30',10,0),('1','116',147196,'MORNING SHIFT','2020-08-11','2020-08-11 00:00:00',NULL,'461',1344815.66,1344815.66,'461','2020-08-13 11:23:19','461','2020-08-13 11:23:55',10,0),('1','116',147199,'AFTERNOON','2020-08-11','2020-08-11 00:00:00',NULL,'461',2041853.20,2041853.20,'461','2020-08-13 11:33:56','461','2020-08-13 11:35:26',10,0),('1','116',147203,'MORNING SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'461',1663181.00,1663181.00,'461','2020-08-13 11:43:07','461','2020-08-13 11:52:32',10,0),('1','116',147210,'AFTERNOON','2020-08-12','2020-08-12 00:00:00',NULL,'461',2012424.38,2012424.38,'461','2020-08-13 13:51:46','461','2020-08-13 13:52:28',10,0),('1','116',147252,'MORNING SHIFT','2020-08-13','2020-08-13 00:00:00',NULL,'461',1198075.72,1198075.72,'461','2020-08-13 13:59:31','461','2020-08-13 14:00:09',10,0),('1','116',147256,'AFTERNOON','2020-08-13','2020-08-13 00:00:00',NULL,'461',2026886.78,2026886.78,'461','2020-08-16 17:56:17','461','2020-08-16 17:57:06',10,0),('1','116',147669,'MORNING SHIFT','2020-08-14','2020-08-14 00:00:00',NULL,'461',1366714.00,1366714.00,'461','2020-08-16 18:01:11','461','2020-08-16 18:02:07',10,0),('1','116',147670,'AFTERNOON','2020-08-14','2020-08-14 00:00:00',NULL,'461',2119505.64,2119505.64,'461','2020-08-16 18:08:58','461','2020-08-16 18:09:34',10,0),('1','116',147672,'MORNING SHIFT','2020-08-15','2020-08-15 00:00:00',NULL,'461',1260426.56,1260426.56,'461','2020-08-16 18:14:13','461','2020-08-16 18:14:38',10,0),('1','116',147673,'AFTERNOON','2020-08-15','2020-08-15 00:00:00',NULL,'461',2071380.62,2071380.62,'461','2020-08-16 18:20:16','461','2020-08-16 18:20:43',10,0),('1','116',147675,'MORNING SHIFT','2020-08-16','2020-08-16 00:00:00',NULL,'461',965212.88,965212.88,'461','2020-08-16 18:26:22','461','2020-08-16 18:26:51',10,0),('1','116',147677,'AFTERNOON','2020-08-16','2020-08-16 00:00:00',NULL,'461',1350112.96,1350112.96,'461','2020-08-18 12:57:15','461','2020-08-18 12:57:37',10,0),('1','116',147926,'MORNING SHIFT','2020-08-17','2020-08-17 00:00:00',NULL,'461',1456401.78,1456401.78,'461','2020-08-18 13:01:01','461','2020-08-18 13:01:21',10,0),('1','116',147928,'AFTERNOON','2020-08-17','2020-08-17 00:00:00',NULL,'461',2342776.52,2342776.52,'461','2020-08-18 13:04:16','461','2020-08-18 13:04:36',10,0),('1','116',147929,'MORNING SHIFT','2020-08-18','2020-08-18 00:00:00',NULL,'461',1352423.12,1352423.12,'461','2020-08-18 13:07:48','461','2020-08-18 13:08:46',10,0),('1','116',147932,'AFTERNOON','2020-08-18','2020-08-18 00:00:00',NULL,'461',1757776.18,1757776.18,'461','2020-08-19 18:08:15','461','2020-08-19 18:08:38',10,0),('1','116',148113,'MORNING SHIFT','2020-08-19','2020-08-19 00:00:00',NULL,'461',1302867.74,1302867.74,'461','2020-08-19 18:12:33','461','2020-08-19 18:13:23',10,0),('1','116',148114,'AFTERNOON','2020-08-19','2020-08-19 00:00:00',NULL,'461',2076311.22,2076311.22,'461','2020-08-20 16:53:47','461','2020-08-20 16:54:13',10,0),('1','116',148258,'MORNING SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'461',1642030.16,1642030.16,'461','2020-08-20 17:03:37','461','2020-08-20 17:04:24',10,0),('1','116',148259,'AFTERNOON','2020-08-20','2020-08-20 00:00:00',NULL,'461',2267946.34,2267946.34,'461','2020-08-21 15:31:47','461','2020-08-21 15:32:16',10,0),('1','116',148372,'MORNING SHIFT','2020-08-21','2020-08-21 00:00:00',NULL,'461',1329641.96,1329641.96,'461','2020-08-21 15:36:50','461','2020-08-21 15:37:15',10,0),('1','116',148374,'AFTERNOON','2020-08-21','2020-08-21 00:00:00',NULL,'461',2205368.64,2205368.64,'461','2020-08-23 17:59:04','461','2020-08-23 18:00:30',10,0),('1','116',148654,'MORNING SHIFT','2020-08-22','2020-08-22 00:00:00',NULL,'461',1151023.60,1151023.60,'461','2020-08-23 18:09:52','461','2020-08-23 18:11:07',10,0),('1','116',148656,'AFTERNOON','2020-08-22','2020-08-22 00:00:00',NULL,'461',1808512.20,1808512.20,'461','2020-08-23 18:18:15','461','2020-08-23 18:18:38',10,0),('1','116',148657,'MORNING SHIFT','2020-08-23','2020-08-23 00:00:00',NULL,'461',1034373.04,1034373.04,'461','2020-08-23 18:24:10','461','2020-08-23 18:24:36',10,0),('1','116',148658,'AFTERNOON','2020-08-23','2020-08-23 00:00:00',NULL,'461',1551351.00,1551351.00,'461','2020-08-24 18:34:06','461','2020-08-24 18:34:46',10,0),('1','116',148805,'MORNING SHIFT','2020-08-24','2020-08-24 00:00:00',NULL,'461',1448576.32,1448576.32,'461','2020-08-24 18:38:52','461','2020-08-24 18:39:26',10,0),('1','116',148807,'AFTERNOON','2020-08-24','2020-08-24 00:00:00',NULL,'461',2106684.80,2106684.80,'461','2020-08-31 18:33:17','461','2020-08-31 18:33:39',10,0),('1','116',149837,'MORNING SHIFT','2020-08-25','2020-08-25 00:00:00',NULL,'461',1249310.70,1249310.70,'461','2020-08-31 18:36:35','461','2020-08-31 18:37:11',10,0),('1','116',149838,'AFTERNOON','2020-08-25','2020-08-25 00:00:00',NULL,'461',2023200.14,2023200.14,'461','2020-08-31 18:51:35','461','2020-08-31 18:52:29',10,0),('1','116',149840,'MORNING SHIFT','2020-08-26','2020-08-26 00:00:00',NULL,'461',1256822.02,1256822.02,'461','2020-08-31 18:59:19','461','2020-08-31 18:59:50',10,0),('1','116',149841,'AFTERNOON','2020-08-26','2020-08-26 00:00:00',NULL,'461',2287658.46,2287658.46,'461','2020-08-31 19:09:40','461','2020-08-31 19:11:00',10,0),('1','116',149844,'MORNING SHIFT','2020-08-27','2020-08-27 00:00:00',NULL,'461',1550762.12,1550762.12,'461','2020-08-31 19:19:41','461','2020-08-31 19:20:09',10,0),('1','116',149845,'AFTERNOON','2020-08-27','2020-08-27 00:00:00',NULL,'461',2450920.44,2450920.44,'461','2020-08-31 19:22:52','461','2020-08-31 19:23:17',10,0),('1','116',149846,'MORNING SHIFT','2020-08-28','2020-08-28 00:00:00',NULL,'461',1784664.62,1784664.62,'461','2020-08-31 19:28:01','461','2020-08-31 19:28:21',10,0),('1','116',149847,'AFTERNOON','2020-08-28','2020-08-28 00:00:00',NULL,'461',2518996.86,2518996.86,'461','2020-08-31 19:31:09','461','2020-08-31 19:31:31',10,0),('1','116',149848,'MORNING SHIFT','2020-08-29','2020-08-29 00:00:00',NULL,'461',1725920.26,1725920.26,'461','2020-08-31 19:36:44','461','2020-08-31 19:37:07',10,0),('1','116',149850,'AFTERNOON','2020-08-29','2020-08-29 00:00:00',NULL,'461',2463032.24,2463032.24,'461','2020-08-31 19:40:11','461','2020-08-31 19:40:33',10,0),('1','116',149852,'MORNING SHIFT','2020-08-30','2020-08-30 00:00:00',NULL,'461',1187605.66,1187605.66,'461','2020-08-31 19:43:46','461','2020-08-31 19:44:08',10,0),('1','116',149854,'AFTERNOON','2020-08-30','2020-08-30 00:00:00',NULL,'461',1551327.94,1551327.94,'461','2020-08-31 19:47:38','461','2020-08-31 19:47:56',10,0),('1','116',149855,'MORNING SHIFT','2020-08-31','2020-08-31 00:00:00',NULL,'461',1365414.60,1365414.60,'461','2020-08-31 19:51:57','461','2020-08-31 19:52:43',10,0),('1','116',149856,'AFTERNOON','2020-08-31','2020-08-31 00:00:00',NULL,'461',2360755.30,2360755.30,'461','2020-09-02 11:09:34','461','2020-09-02 11:09:58',10,0),('1','116',150052,'MORNING SHIFT','2020-09-01','2020-09-01 00:00:00',NULL,'461',1415732.40,1415732.40,'461','2020-09-02 11:21:42','461','2020-09-02 11:22:15',10,0),('1','116',150056,'AFTERNOON','2020-09-01','2020-09-01 00:00:00',NULL,'461',2514308.64,2514308.64,'461','2020-09-02 11:40:17','461','2020-09-02 11:40:52',10,0),('1','116',150063,'MORNING SHIFT','2020-09-02','2020-09-02 00:00:00',NULL,'461',1369283.72,1369283.72,'461','2020-09-03 18:37:27','461','2020-09-03 18:37:46',10,0),('1','116',150375,'AFTERNOON','2020-09-02','2020-09-02 00:00:00',NULL,'461',2812095.80,2812095.80,'461','2020-09-03 18:47:37','461','2020-09-03 18:48:09',10,0),('1','116',150377,'MORNING SHIFT','2020-09-03','2020-09-03 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',150378,'MORNING SHIFT','2020-09-03','2020-09-03 00:00:00',NULL,'461',1708925.56,1708925.56,'461','2020-09-03 18:55:24','461','2020-09-03 18:56:34',10,0),('1','116',150381,'AFTERNOON','2020-09-03','2020-09-03 00:00:00',NULL,'461',2291599.74,2291599.74,'461','2020-09-04 16:59:15','461','2020-09-04 17:02:10',10,0),('1','116',150524,'MORNING SHIFT','2020-09-04','2020-09-04 00:00:00',NULL,'461',1658578.20,1658578.20,'461','2020-09-04 17:05:37','461','2020-09-04 17:06:01',10,0),('1','116',150527,'AFTERNOON','2020-09-04','2020-09-04 00:00:00',NULL,'461',2507015.44,2507015.44,'461','2020-09-06 16:19:51','461','2020-09-06 16:20:14',10,0),('1','116',150812,'MORNING SHIFT','2020-09-05','2020-09-05 00:00:00',NULL,'461',1446333.26,1446333.26,'461','2020-09-06 16:38:48','461','2020-09-06 16:39:32',10,0),('1','116',150816,'AFTERNOON','2020-09-05','2020-09-05 00:00:00',NULL,'461',2060467.68,2060467.68,'461','2020-09-06 17:09:25','461','2020-09-06 17:09:51',10,0),('1','116',150822,'MORNING SHIFT','2020-09-06','2020-09-06 00:00:00',NULL,'461',1148237.66,1148237.66,'461','2020-09-06 17:23:06','461','2020-09-06 17:23:27',10,0),('1','116',150824,'AFTERNOON','2020-09-06','2020-09-06 00:00:00',NULL,'461',2025555.56,2025555.56,'461','2020-09-09 17:45:20','461','2020-09-09 17:45:45',10,0),('1','116',151253,'MORNING SHIFT','2020-09-07','2020-09-07 00:00:00',NULL,'461',1362334.78,1362334.78,'461','2020-09-09 17:49:05','461','2020-09-09 17:49:32',10,0),('1','116',151254,'AFTERNOON','2020-09-07','2020-09-07 00:00:00',NULL,'461',2035728.18,2035728.18,'461','2020-09-09 17:53:48','461','2020-09-09 17:54:23',10,0),('1','116',151256,'AFTERNOON','2020-09-08','2020-09-08 00:00:00',NULL,'461',2309497.92,2309497.92,'461','2020-09-09 17:57:41','461','2020-09-09 17:58:08',10,0),('1','116',151258,'MORNING SHIFT','2020-09-09','2020-09-09 00:00:00',NULL,'461',1442438.66,1442438.66,'461','2020-09-09 18:01:28','461','2020-09-09 18:02:06',10,0),('1','116',151261,'AFTERNOON','2020-09-09','2020-09-09 00:00:00',NULL,'461',2182500.98,2182500.98,'461','2020-09-11 17:08:43','461','2020-09-11 17:09:24',10,0),('1','116',151569,'MORNING SHIFT','2020-09-10','2020-09-10 00:00:00',NULL,'461',1486544.34,1486544.34,'461','2020-09-11 17:21:34','461','2020-09-11 17:23:18',10,0),('1','116',151571,'AFTERNOON','2020-09-10','2020-09-10 00:00:00',NULL,'461',1896990.82,1896990.82,'461','2020-09-11 17:38:55','461','2020-09-11 17:39:51',10,0),('1','116',151575,'MORNING SHIFT','2020-09-11','2020-09-11 00:00:00',NULL,'461',1576658.62,1576658.62,'461','2020-09-11 17:46:22','461','2020-09-11 17:47:26',10,0),('1','116',151578,'AFTERNOON','2020-09-11','2020-09-11 00:00:00',NULL,'461',2407983.66,2407983.66,'461','2020-09-14 10:35:27','461','2020-09-14 10:36:30',10,0),('1','116',151864,'MORNING SHIFT','2020-09-12','2020-09-12 00:00:00',NULL,'461',1475718.32,1475718.32,'461','2020-09-14 10:48:03','461','2020-09-14 10:48:56',10,0),('1','116',151866,'AFTERNOON','2020-09-12','2020-09-12 00:00:00',NULL,'461',2104600.98,2104600.98,'461','2020-09-14 10:58:36','461','2020-09-14 10:59:05',10,0),('1','116',151871,'MORNING SHIFT','2020-09-13','2020-09-13 00:00:00',NULL,'461',1325498.12,1325498.12,'461','2020-09-14 11:13:55','461','2020-09-14 11:14:45',10,0),('1','116',151876,'AFTERNOON','2020-09-13','2020-09-13 00:00:00',NULL,'461',1527608.04,1527608.04,'461','2020-09-14 11:27:22','461','2020-09-14 11:27:52',10,0),('1','116',151883,'MORNING SHIFT','2020-09-14','2020-09-14 00:00:00',NULL,'461',1423761.54,1423761.54,'461','2020-09-15 16:14:46','461','2020-09-15 16:15:15',10,0),('1','116',152135,'AFTERNOON','2020-09-14','2020-09-14 00:00:00',NULL,'461',2346185.46,2346185.46,'461','2020-09-15 16:22:59','461','2020-09-15 16:23:30',10,0),('1','116',152139,'MORNING SHIFT','2020-09-15','2020-09-15 00:00:00',NULL,'461',1348358.86,1348358.86,'461','2020-09-15 16:28:41','461','2020-09-15 16:29:22',10,0),('1','116',152141,'AFTERNOON','2020-09-15','2020-09-15 00:00:00',NULL,'461',1875859.20,1875859.20,'461','2020-09-16 15:29:13','461','2020-09-16 15:29:50',10,0),('1','116',152292,'MORNING SHIFT','2020-09-16','2020-09-16 00:00:00',NULL,'461',1262422.40,1262422.40,'461','2020-09-16 15:37:23','461','2020-09-16 15:37:58',10,0),('1','116',152295,'AFTERNOON','2020-09-16','2020-09-16 00:00:00',NULL,'461',2034566.40,2034566.40,'461','2020-09-17 16:16:09','461','2020-09-17 16:17:13',10,0),('1','116',152439,'MORNING SHIFT','2020-09-17','2020-09-17 00:00:00',NULL,'461',1314700.80,1314700.80,'461','2020-09-17 16:25:20','461','2020-09-17 16:25:54',10,0),('1','116',152441,'AFTERNOON','2020-09-17','2020-09-17 00:00:00',NULL,'461',1988444.80,1988444.80,'461','2020-09-18 18:30:12','461','2020-09-18 18:31:31',10,0),('1','116',152604,'MORNING SHIFT','2020-09-18','2020-09-18 00:00:00',NULL,'461',1314998.40,1314998.40,'461','2020-09-18 18:37:21','461','2020-09-18 18:37:41',10,0),('1','116',152607,'AFTERNOON','2020-09-18','2020-09-18 00:00:00',NULL,'461',2071080.00,2071080.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',153077,'AFTERNOON','2020-09-18','2020-09-18 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',153317,'AFTERNOON','2020-09-18','2020-09-18 00:00:00',NULL,'461',0.00,0.00,'461','2020-09-23 10:04:29','461','2020-09-23 10:06:55',10,0),('1','116',153319,'AFTERNOON','2020-09-18','2020-09-18 00:00:00',NULL,'461',2045191.50,2045191.50,'461','2020-09-23 10:31:18','461','2020-09-23 10:39:40',10,0),('1','116',153335,'MORNING SHIFT','2020-09-19','2020-09-19 00:00:00',NULL,'461',1148884.36,1148884.36,'461','2020-09-23 11:00:05','461','2020-09-23 11:00:53',10,0),('1','116',153344,'AFTERNOON','2020-09-19','2020-09-19 00:00:00',NULL,'461',1882965.36,1882965.36,'461','2020-09-23 11:06:11','461','2020-09-23 11:06:48',10,0),('1','116',153348,'MORNING SHIFT','2020-09-20','2020-09-20 00:00:00',NULL,'461',1030259.54,1030259.54,'461','2020-09-23 11:10:46','461','2020-09-23 11:11:15',10,0),('1','116',153351,'AFTERNOON','2020-09-20','2020-09-20 00:00:00',NULL,'461',1863349.90,1863349.90,'461','2020-09-23 11:14:48','461','2020-09-23 11:15:13',10,0),('1','116',153356,'MORNING SHIFT','2020-09-21','2020-09-21 00:00:00',NULL,'461',1636870.74,1636870.74,'461','2020-09-23 11:24:15','461','2020-09-23 11:24:49',10,0),('1','116',153358,'AFTERNOON','2020-09-21','2020-09-21 00:00:00',NULL,'461',2127119.40,2127119.40,'461','2020-09-23 11:28:34','461','2020-09-23 11:28:58',10,0),('1','116',153361,'MORNING SHIFT','2020-09-22','2020-09-22 00:00:00',NULL,'461',1516817.68,1516817.68,'461','2020-09-23 11:40:36','461','2020-09-23 11:41:10',10,0),('1','116',153365,'AFTERNOON','2020-09-22','2020-09-22 00:00:00',NULL,'461',2502524.96,2502524.96,'461','2020-09-23 11:53:53','461','2020-09-23 11:54:20',10,0),('1','116',153369,'MORNING SHIFT','2020-09-23','2020-09-23 00:00:00',NULL,'461',2013657.18,2013657.18,'461','2020-09-24 09:33:34','461','2020-09-24 09:34:07',10,0),('1','116',153526,'AFTERNOON','2020-09-23','2020-09-23 00:00:00',NULL,'461',2316973.38,2316973.38,'461','2020-09-24 09:52:23','461','2020-09-24 09:52:51',10,0),('1','116',153529,'MORNING SHIFT','2020-09-24','2020-09-24 00:00:00',NULL,'461',1779260.76,1779260.76,'461','2020-09-25 11:15:57','461','2020-09-25 11:16:21',10,0),('1','116',153704,'AFTERNOON','2020-09-24','2020-09-24 00:00:00',NULL,'461',2407321.40,2407321.40,'461','2020-09-25 11:33:20','461','2020-09-25 11:34:40',10,0),('1','116',153709,'MORNING SHIFT','2020-09-25','2020-09-25 00:00:00',NULL,'461',1384547.68,1384547.68,'461','2020-09-25 14:22:58','461','2020-09-25 14:23:24',10,0),('1','116',153748,'AFTERNOON','2020-09-25','2020-09-25 00:00:00',NULL,'461',2381686.98,2381686.98,'461','2020-09-27 16:09:11','461','2020-09-27 16:09:54',10,0),('1','116',154029,'MORNING SHIFT','2020-09-26','2020-09-26 00:00:00',NULL,'461',1237915.78,1237915.78,'461','2020-09-27 16:24:43','461','2020-09-27 16:25:09',10,0),('1','116',154033,'AFTERNOON','2020-09-26','2020-09-26 00:00:00',NULL,'461',2228937.40,2228937.40,'461','2020-09-27 16:31:25','461','2020-09-27 16:32:04',10,0),('1','116',154035,'MORNING SHIFT','2020-09-27','2020-09-27 00:00:00',NULL,'461',1063317.88,1063317.88,'461','2020-09-27 17:01:19','461','2020-09-27 17:02:12',10,0),('1','116',154042,'AFTERNOON','2020-09-27','2020-09-27 00:00:00',NULL,'461',1920676.44,1920676.44,'461','2020-09-28 17:54:02','461','2020-09-28 17:54:29',10,0),('1','116',154232,'MORNING SHIFT','2020-09-28','2020-09-28 00:00:00',NULL,'461',1374952.34,1374952.34,'461','2020-09-28 17:59:46','461','2020-09-28 18:00:13',10,0),('1','116',154233,'AFTERNOON','2020-09-28','2020-09-28 00:00:00',NULL,'461',2337593.84,2337593.84,'461','2020-10-02 13:45:44','461','2020-10-02 13:46:10',10,0),('1','116',154811,'MORNING SHIFT','2020-09-29','2020-09-29 00:00:00',NULL,'461',1298410.82,1298410.82,'461','2020-10-02 13:54:04','461','2020-10-02 13:54:28',10,0),('1','116',154812,'AFTERNOON','2020-09-29','2020-09-29 00:00:00',NULL,'461',1976777.22,1976777.22,'461','2020-10-02 13:59:33','461','2020-10-02 14:00:43',10,0),('1','116',154815,'MORNING SHIFT','2020-09-30','2020-09-30 00:00:00',NULL,'461',1205561.84,1205561.84,'461','2020-10-02 14:21:25','461','2020-10-02 14:22:44',10,0),('1','116',154820,'AFTERNOON','2020-09-30','2020-09-30 00:00:00',NULL,'461',2439036.52,2439036.52,'461','2020-10-02 14:29:08','461','2020-10-02 14:29:31',10,0),('1','116',154822,'MORNING SHIFT','2020-10-01','2020-10-01 00:00:00',NULL,'461',1419885.68,1419885.68,'461','2020-10-02 14:38:30','461','2020-10-02 14:39:08',10,0),('1','116',154824,'AFTERNOON','2020-10-01','2020-10-01 00:00:00',NULL,'461',2179050.68,2179050.68,'461','2020-10-02 14:42:51','461','2020-10-02 14:43:32',10,0),('1','116',154826,'MORNING SHIFT','2020-10-02','2020-10-02 00:00:00',NULL,'461',1472299.30,1472299.30,'461','2020-10-02 14:47:56','461','2020-10-02 14:48:23',10,0),('1','116',154829,'AFTERNOON','2020-10-02','2020-10-02 00:00:00',NULL,'461',2741573.34,2741573.34,'461','2020-10-03 14:03:14','461','2020-10-03 14:04:02',10,0),('1','116',154973,'MORNING SHIFT','2020-10-03','2020-10-03 00:00:00',NULL,'461',1406847.80,1406847.80,'461','2020-10-03 14:14:08','461','2020-10-03 14:14:39',10,0),('1','116',154976,'AFTERNOON','2020-10-03','2020-10-03 00:00:00',NULL,'461',2208542.58,2208542.58,'461','2020-10-04 18:07:14','461','2020-10-04 18:08:08',10,0),('1','116',155123,'MORNING SHIFT','2020-10-04','2020-10-04 00:00:00',NULL,'461',1220679.56,1220679.56,'461','2020-10-04 18:12:22','461','2020-10-04 18:12:43',10,0),('1','116',155124,'AFTERNOON','2020-10-04','2020-10-04 00:00:00',NULL,'461',1767618.68,1767618.68,'461','2020-10-05 16:43:02','461','2020-10-05 16:43:28',10,0),('1','116',155272,'MORNING SHIFT','2020-10-05','2020-10-05 00:00:00',NULL,'461',1485691.90,1485691.90,'461','2020-10-05 17:29:50','461','2020-10-05 17:30:13',10,0),('1','116',155283,'AFTERNOON','2020-10-05','2020-10-05 00:00:00',NULL,'461',931642.26,931642.26,'461','2020-10-06 16:32:19','461','2020-10-06 16:32:40',10,0),('1','116',155435,'MORNING SHIFT','2020-10-06','2020-10-06 00:00:00',NULL,'461',1881025.42,1881025.42,'461','2020-10-07 19:16:32','461','2020-10-07 19:16:52',10,0),('1','116',155632,'AFTERNOON','2020-10-06','2020-10-06 00:00:00',NULL,'461',2149479.04,2149479.04,'461','2020-10-07 19:23:43','461','2020-10-07 19:26:05',10,0),('1','116',155636,'MORNING SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'461',1719343.06,1719343.06,'461','2020-10-07 19:31:12','461','2020-10-07 19:31:36',10,0),('1','116',155637,'AFTERNOON','2020-10-07','2020-10-07 00:00:00',NULL,'461',2403495.48,2403495.48,'461','2020-10-09 04:56:52','461','2020-10-09 04:57:19',10,0),('1','116',155789,'MORNING SHIFT','2020-10-08','2020-10-08 00:00:00',NULL,'461',1622919.48,1622919.48,'461','2020-10-09 05:02:30','461','2020-10-09 05:03:02',10,0),('1','116',155790,'AFTERNOON','2020-10-08','2020-10-08 00:00:00',NULL,'461',2385600.22,2385600.22,'461','2020-10-09 17:02:33','461','2020-10-09 17:03:28',10,0),('1','116',155908,'MORNING SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'461',1710282.28,1710282.28,'461','2020-10-09 17:09:31','461','2020-10-09 17:10:50',10,0),('1','116',155911,'AFTERNOON','2020-10-09','2020-10-09 00:00:00',NULL,'461',2429201.64,2429201.64,'461','2020-10-12 06:33:35','461','2020-10-12 06:33:55',10,0),('1','116',156218,'MORNING SHIFT','2020-10-10','2020-10-10 00:00:00',NULL,'461',1436055.54,1436055.54,'461','2020-10-12 06:38:12','461','2020-10-12 06:38:35',10,0),('1','116',156219,'AFTERNOON','2020-10-10','2020-10-10 00:00:00',NULL,'461',1977384.16,1977384.16,'461','2020-10-12 06:44:16','461','2020-10-12 06:44:54',10,0),('1','116',156220,'MORNING SHIFT','2020-10-11','2020-10-11 00:00:00',NULL,'461',1327628.60,1327628.60,'461','2020-10-12 06:51:36','461','2020-10-12 06:53:19',10,0),('1','116',156221,'AFTERNOON','2020-10-11','2020-10-11 00:00:00',NULL,'461',2032769.84,2032769.84,'461','2020-10-13 07:50:15','461','2020-10-13 07:50:36',10,0),('1','116',156434,'MORNING SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'461',1513474.84,1513474.84,'461','2020-10-13 07:58:10','461','2020-10-13 08:05:42',10,0),('1','116',156437,'AFTERNOON','2020-10-12','2020-10-12 00:00:00',NULL,'461',2278906.14,2278906.14,'461','2020-10-14 09:04:06','461','2020-10-14 09:04:25',10,0),('1','116',156601,'MORNING SHIFT','2020-10-13','2020-10-13 00:00:00',NULL,'461',1365108.80,1365108.80,'461','2020-10-14 09:07:20','461','2020-10-14 09:07:49',10,0),('1','116',156602,'AFTERNOON','2020-10-13','2020-10-13 00:00:00',NULL,'461',2655679.74,2655679.74,'461','2020-10-14 09:11:19','461','2020-10-15 05:57:41',10,0),('1','116',156744,'MORNING SHIFT','2020-10-14','2020-10-14 00:00:00',NULL,'461',1335445.72,1335445.72,'461','2020-10-15 06:01:55','461','2020-10-15 06:02:25',10,0),('1','116',156745,'AFTERNOON','2020-10-14','2020-10-14 00:00:00',NULL,'461',2444679.64,2444679.64,'461','2020-10-16 11:45:24','461','2020-10-16 11:45:55',10,0),('1','116',156982,'MORNING SHIFT','2020-10-15','2020-10-15 00:00:00',NULL,'461',1402209.62,1402209.62,'461','2020-10-16 11:57:15','461','2020-10-16 11:59:10',10,0),('1','116',156987,'AFTERNOON','2020-10-15','2020-10-15 00:00:00',NULL,'461',2530123.84,2530123.84,'461','2020-10-16 12:03:41','461','2020-10-16 12:04:13',10,0),('1','116',156990,'MORNING SHIFT','2020-10-16','2020-10-16 00:00:00',NULL,'461',1469571.46,1469571.46,'461','2020-10-18 10:10:55','461','2020-10-18 10:11:18',10,0),('1','116',157337,'AFTERNOON','2020-10-16','2020-10-16 00:00:00',NULL,'461',2246385.72,2246385.72,'461','2020-10-18 10:16:34','461','2020-10-18 10:17:02',10,0),('1','116',157341,'MORNING SHIFT','2020-10-17','2020-10-17 00:00:00',NULL,'461',608027.78,608027.78,'461','2020-10-18 10:23:17','461','2020-10-18 10:23:57',10,0),('1','116',157345,'MORNING SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'461',823979.52,823979.52,'461','2020-10-20 08:16:47','461','2020-10-20 08:17:12',10,0),('1','116',157680,'AFTERNOON','2020-10-18','2020-10-18 00:00:00',NULL,'461',1619664.48,1619664.48,'461','2020-10-20 08:28:29','461','2020-10-20 08:29:12',10,0),('1','116',157686,'MORNING SHIFT','2020-10-19','2020-10-19 00:00:00',NULL,'461',1356358.08,1356358.08,'461','2020-10-20 08:36:05','461','2020-10-20 08:36:46',10,0),('1','116',157688,'AFTERNOON','2020-10-19','2020-10-19 00:00:00',NULL,'461',1551508.76,1551508.76,'461','2020-10-20 09:22:31','461','2020-10-20 09:23:42',10,0),('1','116',158057,'AFTERNOON','2020-10-21','2020-10-21 00:00:00',NULL,'461',2450465.82,2450465.82,'461','2020-10-22 16:12:40','461','2020-10-22 16:13:01',10,0),('1','116',158058,'MORNING SHIFT','2020-10-22','2020-10-22 00:00:00',NULL,'461',1669053.82,1669053.82,'461','2020-10-22 16:18:01','461','2020-10-22 16:18:38',10,0),('1','116',158063,'AFTERNOON','2020-10-22','2020-10-22 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',158065,'AFTERNOON','2020-10-22','2020-10-22 00:00:00',NULL,'461',1999459.84,1999459.84,'461','2020-10-23 17:36:16','461','2020-10-23 17:36:45',10,0),('1','116',158246,'MORNING SHIFT','2020-10-23','2020-10-23 00:00:00',NULL,'461',1591496.38,1591496.38,'461','2020-10-23 17:48:39','461','2020-10-23 17:52:41',10,0),('1','116',158420,'AFTERNOON','2020-10-23','2020-10-23 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',158421,'AFTERNOON','2020-10-23','2020-10-23 00:00:00',NULL,'461',1219057.50,1219057.50,'461','2020-10-24 19:43:41','461','2020-10-24 19:44:11',10,0),('1','116',158422,'MORNING SHIFT','2020-10-24','2020-10-24 00:00:00',NULL,'461',757100.10,757100.10,'461','2020-10-24 19:53:38','461','2020-10-24 19:54:08',10,0),('1','116',158423,'AFTERNOON','2020-10-24','2020-10-24 00:00:00',NULL,'461',2046203.50,2046203.50,'461','2020-10-25 17:57:19','461','2020-10-25 17:58:59',10,0),('1','116',158565,'MORNING SHIFT','2020-10-25','2020-10-25 00:00:00',NULL,'461',1232852.00,1232852.00,'461','2020-10-25 18:17:47','461','2020-10-25 18:18:56',10,0),('1','116',158850,'AFTERNOON','2020-10-25','2020-10-25 00:00:00',NULL,'461',1764345.40,1764345.40,'461','2020-10-27 12:02:55','461','2020-10-27 12:03:42',10,0),('1','116',158851,'MORNING SHIFT','2020-10-26','2020-10-26 00:00:00',NULL,'461',958704.30,958704.30,'461','2020-10-27 12:12:26','461','2020-10-27 12:20:35',10,0),('1','116',158853,'MORNING SHIFT','2020-10-27','2020-10-27 00:00:00',NULL,'461',1635446.40,1635446.40,'461','2020-10-28 17:28:40','461','2020-10-28 17:29:15',10,0),('1','116',159099,'AFTERNOON','2020-10-27','2020-10-27 00:00:00',NULL,'461',2714730.20,2714730.20,'461','2020-10-28 17:34:50','461','2020-10-28 17:35:48',10,0),('1','116',159101,'MORNING SHIFT','2020-10-28','2020-10-28 00:00:00',NULL,'461',1894270.60,1894270.60,'461','2020-10-28 17:45:23','461','2020-10-28 17:45:46',10,0),('1','116',159117,'AFTERNOON','2020-10-28','2020-10-28 00:00:00',NULL,'461',1473839.40,1473839.40,'461','2020-10-29 13:59:35','461','2020-10-29 13:59:59',10,0),('1','116',159216,'MORNING SHIFT','2020-10-29','2020-10-29 00:00:00',NULL,'461',1330120.00,1330120.00,'461','2020-10-29 14:02:24','461','2020-10-29 14:03:31',10,0),('1','116',159218,'AFTERNOON','2020-10-29','2020-10-29 00:00:00',NULL,'461',1841569.60,1841569.60,'461','2020-10-31 17:30:44','461','2020-10-31 17:31:10',10,0),('1','116',159616,'AFTERNOON','2020-10-30','2020-10-30 00:00:00',NULL,'461',2471288.20,2471288.20,'461','2020-10-31 17:35:48','461','2020-10-31 17:37:33',10,0),('1','116',159618,'MORNING SHIFT','2020-10-31','2020-10-31 00:00:00',NULL,'461',1226825.60,1226825.60,'461','2020-10-31 17:42:39','461','2020-10-31 17:43:21',10,0),('1','116',159620,'AFTERNOON','2020-10-31','2020-10-31 00:00:00',NULL,'461',2026921.60,2026921.60,'461','2020-11-01 18:02:36','461','2020-11-01 18:03:45',10,0),('1','116',159727,'MORNING SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',159728,'MORNING SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'461',958267.20,958267.20,'461','2020-11-01 18:14:49','461','2020-11-01 18:15:57',10,0),('1','116',159731,'AFTERNOON','2020-11-01','2020-11-01 00:00:00',NULL,'461',1792459.10,1792459.10,'461','2020-11-02 18:32:45','461','2020-11-02 18:33:11',10,0),('1','116',159937,'MORNING SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'461',1331058.55,1331058.55,'461','2020-11-02 18:38:55','461','2020-11-02 18:39:21',10,0),('1','116',159939,'AFTERNOON','2020-11-02','2020-11-02 00:00:00',NULL,'461',2748056.80,2748056.80,'461','2020-11-04 07:58:37','461','2020-11-04 07:59:47',10,0),('1','116',160151,'MORNING SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',160152,'MORNING SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'461',1328181.12,1328181.12,'461','2020-11-04 08:22:46','461','2020-11-04 08:23:41',10,0),('1','116',160157,'AFTERNOON','2020-11-03','2020-11-03 00:00:00',NULL,'461',2002688.24,2002688.24,'461','2020-11-05 00:43:35','461','2020-11-05 00:44:29',10,0),('1','116',160311,'MORNING SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'461',1174937.73,1174937.73,'461','2020-11-05 00:49:20','461','2020-11-05 00:49:49',10,0),('1','116',160312,'AFTERNOON','2020-11-04','2020-11-04 00:00:00',NULL,'461',2128017.61,2128017.61,'461','2020-11-06 09:33:46','461','2020-11-06 09:34:25',10,0),('1','116',160487,'MORNING SHIFT','2020-11-05','2020-11-05 00:00:00',NULL,'461',1101477.81,1101477.81,'461','2020-11-06 09:44:26','461','2020-11-06 09:44:51',10,0),('1','116',160493,'AFTERNOON','2020-11-05','2020-11-05 00:00:00',NULL,'461',2257790.24,2257790.24,'461','2020-11-06 10:58:22','461','2020-11-06 10:59:24',10,0),('1','116',160517,'MORNING SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'461',1311110.48,1311110.48,'461','2020-11-07 12:35:37','461','2020-11-07 12:36:27',10,0),('1','116',160687,'AFTERNOON','2020-11-06','2020-11-06 00:00:00',NULL,'461',2228014.89,2228014.89,'461','2020-11-07 12:42:11','461','2020-11-07 12:47:15',10,0),('1','116',160691,'MORNING SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'461',1435429.83,1435429.83,'461','2020-11-07 21:06:48','461','2020-11-07 21:07:36',10,0),('1','116',160757,'AFTERNOON','2020-11-07','2020-11-07 00:00:00',NULL,'461',1606049.69,1606049.69,'461','2020-11-09 09:34:44','461','2020-11-09 09:35:12',10,0),('1','116',160971,'MORNING SHIFT','2020-11-08','2020-11-08 00:00:00',NULL,'461',858922.32,858922.32,'461','2020-11-09 09:44:36','461','2020-11-09 09:45:01',10,0),('1','116',160974,'AFTERNOON','2020-11-08','2020-11-08 00:00:00',NULL,'461',1346400.13,1346400.13,'461','2020-11-09 09:50:26','461','2020-11-09 09:51:36',10,0),('1','116',160978,'MORNING SHIFT','2020-11-09','2020-11-09 00:00:00',NULL,'461',1241646.33,1241646.33,'461','2020-11-11 18:38:33','461','2020-11-11 18:39:18',10,0),('1','116',161463,'AFTERNOON','2020-11-09','2020-11-09 00:00:00',NULL,'461',2283965.30,2283965.30,'461','2020-11-11 18:43:01','461','2020-11-11 18:44:03',10,0),('1','116',161464,'MORNING SHIFT','2020-11-10','2020-11-10 00:00:00',NULL,'461',1544302.61,1544302.61,'461','2020-11-11 19:45:06','461','2020-11-11 19:45:27',10,0),('1','116',161474,'AFTERNOON','2020-11-10','2020-11-10 00:00:00',NULL,'461',2149324.13,2149324.13,'461','2020-11-11 19:52:33','461','2020-11-11 19:52:54',10,0),('1','116',161476,'MORNING SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'461',1357486.56,1357486.56,'461','2020-11-11 20:08:38','461','2020-11-11 20:10:19',10,0),('1','116',161478,'AFTERNOON','2020-11-11','2020-11-11 00:00:00',NULL,'461',2066570.25,2066570.25,'461','2020-11-12 13:41:32','461','2020-11-12 13:44:39',10,0),('1','116',161597,'MORNING SHIFT','2020-11-12','2020-11-12 00:00:00',NULL,'461',1511896.29,1511896.29,'461','2020-11-12 14:00:33','461','2020-11-12 14:01:27',10,0),('1','116',161602,'AFTERNOON','2020-11-12','2020-11-12 00:00:00',NULL,'461',1932069.33,1932069.33,'461','2020-11-13 15:37:17','461','2020-11-13 15:40:44',10,0),('1','116',161821,'MORNING SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'461',1755507.94,1755507.94,'461','2020-11-13 15:47:24','461','2020-11-13 15:47:57',10,0),('1','116',161824,'AFTERNOON','2020-11-13','2020-11-13 00:00:00',NULL,'461',3224385.32,3224385.32,'461','2020-11-14 14:54:36','461','2020-11-14 14:55:29',10,0),('1','116',162008,'MORNING SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',162013,'MORNING SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'461',1463254.80,1463254.80,'461','2020-11-14 15:26:36','461','2020-11-14 15:27:36',10,0),('1','116',162044,'AFTERNOON','2020-11-14','2020-11-14 00:00:00',NULL,'461',1861117.44,1861117.44,'461','2020-11-16 13:30:44','461','2020-11-16 13:31:06',10,0),('1','116',162374,'MORNING SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'461',646690.80,646690.80,'461','2020-11-16 13:54:50','461','2020-11-16 13:56:27',10,0),('1','116',162390,'MORNING SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',162392,'MORNING SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'461',718144.22,718144.22,'461','2020-11-16 14:54:27','461','2020-11-16 14:55:55',10,0),('1','116',162406,'AFTERNOON','2020-11-15','2020-11-15 00:00:00',NULL,'461',1922296.33,1922296.33,'461','2020-11-16 15:08:12','461','2020-11-16 15:08:39',10,0),('1','116',162566,'MORNING SHIFT','2020-11-16','2020-11-16 00:00:00',NULL,'461',1715004.77,1715004.77,'461','2020-11-17 12:10:08','461','2020-11-17 12:12:51',10,0),('1','116',162570,'AFTERNOON','2020-11-16','2020-11-16 00:00:00',NULL,'461',1429701.48,1429701.48,'461','2020-11-17 12:20:04','461','2020-11-17 12:21:14',10,0),('1','116',162571,'MORNING SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'461',1752704.79,1752704.79,'461','2020-11-17 12:57:29','461','2020-11-17 15:48:01',10,0),('1','116',162684,'AFTERNOON','2020-11-17','2020-11-17 00:00:00',NULL,'461',2210739.66,2210739.66,'461','2020-11-18 09:20:11','461','2020-11-18 09:22:24',10,0),('1','116',162691,'MORNING SHIFT','2020-11-18','2020-11-18 00:00:00',NULL,'461',1548735.61,1548735.61,'461','2020-11-18 14:06:36','461','2020-11-18 14:10:30',10,0),('1','116',162754,'AFTERNOON','2020-11-18','2020-11-18 00:00:00',NULL,'461',2036927.76,2036927.76,'461','2020-11-19 10:56:18','461','2020-11-19 10:57:15',10,0),('1','116',163061,'AFTERNOON','2020-11-19','2020-11-19 00:00:00',NULL,'461',1568817.01,1568817.01,'461','2020-11-20 09:53:54','461','2020-11-20 09:57:25',10,0),('1','116',163071,'MORNING SHIFT','2020-11-20','2020-11-20 00:00:00',NULL,'461',1909812.01,1909812.01,'461','2020-11-20 18:30:25','461','2020-11-20 18:32:33',10,0),('1','116',163205,'AFTERNOON','2020-11-20','2020-11-20 00:00:00',NULL,'461',2454944.66,2454944.66,'461','2020-11-22 10:52:19','461','2020-11-22 10:58:32',10,0),('1','116',163437,'MORNING SHIFT','2020-11-21','2020-11-21 00:00:00',NULL,'461',1910849.39,1910849.39,'461','2020-11-22 11:08:45','461','2020-11-22 11:11:34',10,0),('1','116',163442,'AFTERNOON','2020-11-21','2020-11-21 00:00:00',NULL,'461',2051920.45,2051920.45,'461','2020-11-22 11:34:19','461','2020-11-22 11:36:44',10,0),('1','116',163450,'MORNING SHIFT','2020-11-22','2020-11-22 00:00:00',NULL,'461',1326686.64,1326686.64,'461','2020-11-22 14:08:18','461','2020-11-23 11:22:46',10,0),('1','116',163640,'AFTERNOON','2020-11-22','2020-11-22 00:00:00',NULL,'461',2665985.82,2665985.82,'461','2020-11-23 11:31:50','461','2020-11-23 11:35:16',10,0),('1','116',163643,'MORNING SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'461',1764592.56,1764592.56,'461','2020-11-23 19:11:48','461','2020-11-23 19:12:15',10,0),('1','116',163784,'AFTERNOON','2020-11-23','2020-11-23 00:00:00',NULL,'461',2511801.25,2511801.25,'461','2020-11-24 10:03:37','461','2020-11-24 10:30:15',10,0),('1','116',163796,'MORNING SHIFT','2020-11-24','2020-11-24 00:00:00',NULL,'461',1429591.75,1429591.75,'461','2020-11-24 17:58:21','461','2020-11-24 18:14:09',10,0),('1','116',163966,'AFTERNOON','2020-11-24','2020-11-24 00:00:00',NULL,'461',2274009.08,2274009.08,'461','2020-11-25 11:17:40','461','2020-11-25 11:18:07',10,0),('1','116',163968,'MORNING SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'461',1751022.61,1751022.61,'461','2020-11-26 10:27:38','461','2020-11-26 10:28:25',10,0),('1','116',164139,'AFTERNOON','2020-11-25','2020-11-25 00:00:00',NULL,'461',2239576.19,2239576.19,'461','2020-11-26 11:12:13','461','2020-11-26 13:11:34',10,0),('1','116',164176,'MORNING SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'461',1604711.12,1604711.12,'461','2020-11-26 13:19:25','461','2020-11-26 19:40:47',10,0),('1','116',164507,'AFTERNOON','2020-11-26','2020-11-26 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',164508,'AFTERNOON','2020-11-26','2020-11-26 00:00:00',NULL,'461',2221056.02,2221056.02,'461','2020-11-28 13:20:08','461','2020-11-28 13:20:55',10,0),('1','116',164533,'MORNING SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'461',2029034.28,2029034.28,'461','2020-11-28 13:27:26','461','2020-11-28 13:28:22',10,0),('1','116',164537,'AFTERNOON','2020-11-27','2020-11-27 00:00:00',NULL,'461',3086682.22,3086682.22,'461','2020-11-28 14:25:31','461','2020-11-28 14:27:18',10,0),('1','116',164558,'MORNING SHIFT','2020-11-28','2020-11-28 00:00:00',NULL,'461',1566720.72,1566720.72,'461','2020-11-28 14:33:40','461','2020-11-28 18:00:15',10,0),('1','116',164735,'AFTERNOON','2020-11-28','2020-11-28 00:00:00',NULL,'461',1785034.98,1785034.98,'461','2020-11-29 17:25:58','461','2020-11-29 17:26:56',10,0),('1','116',164737,'MORNING SHIFT','2020-11-29','2020-11-29 00:00:00',NULL,'461',1870046.66,1870046.66,'461','2020-11-29 17:31:10','461','2020-11-29 17:31:49',10,0),('1','116',164739,'AFTERNOON','2020-11-29','2020-11-29 00:00:00',NULL,'461',1691664.94,1691664.94,'461','2020-11-30 13:50:49','461','2020-11-30 13:51:20',10,0),('1','116',164881,'MORNING SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'461',1741095.58,1741095.58,'461','2020-11-30 13:58:10','461','2020-11-30 18:14:18',10,0),('1','116',165269,'AFTERNOON','2020-11-30','2020-11-30 00:00:00',NULL,'461',2466388.58,2466388.58,'461','2020-12-02 16:52:40','461','2020-12-02 16:53:14',10,0),('1','116',165271,'MORNING SHIFT','2020-12-01','2020-12-01 00:00:00',NULL,'461',1480879.52,1480879.52,'461','2020-12-02 16:57:39','461','2020-12-02 16:58:40',10,0),('1','116',165276,'AFTERNOON','2020-12-01','2020-12-01 00:00:00',NULL,'461',400860.10,400860.10,'461','2020-12-02 17:00:27','461','2020-12-02 17:01:04',10,0),('1','116',165277,'MORNING SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'461',2149636.02,2149636.02,'461','2020-12-02 17:04:46','461','2020-12-02 17:05:22',10,0),('1','116',165490,'AFTERNOON','2020-12-02','2020-12-02 00:00:00',NULL,'461',2559058.82,2559058.82,'461','2020-12-04 08:39:41','461','2020-12-04 08:40:01',10,0),('1','116',165493,'MORNING SHIFT','2020-12-03','2020-12-03 00:00:00',NULL,'461',1865300.56,1865300.56,'461','2020-12-04 08:42:58','461','2020-12-04 08:43:23',10,0),('1','116',165495,'AFTERNOON','2020-12-03','2020-12-03 00:00:00',NULL,'461',2622985.26,2622985.26,'461','2020-12-04 08:56:27','461','2020-12-05 10:38:33',10,0),('1','116',165689,'MORNING SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'461',2367432.56,2367432.56,'461','2020-12-05 10:52:14','461','2020-12-05 10:58:27',10,0),('1','116',165702,'MORNING SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',165704,'AFTERNOON','2020-12-04','2020-12-04 00:00:00',NULL,'461',2556382.60,2556382.60,'461','2020-12-05 17:05:45','461','2020-12-05 17:06:28',10,0),('1','116',165776,'MORNING SHIFT','2020-12-05','2020-12-05 00:00:00',NULL,'461',1675873.50,1675873.50,'461','2020-12-05 17:15:59','461','2020-12-05 17:16:33',10,0),('1','116',165781,'AFTERNOON','2020-12-05','2020-12-05 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',165782,'AFTERNOON','2020-12-05','2020-12-05 00:00:00',NULL,'461',2072620.32,2072620.32,'461','2020-12-06 14:29:20','461','2020-12-06 14:30:38',10,0),('1','116',165889,'MORNING SHIFT','2020-12-06','2020-12-06 00:00:00',NULL,'461',1507968.48,1507968.48,'461','2020-12-06 14:34:40','461','2020-12-06 14:35:03',10,0),('1','116',165891,'AFTERNOON','2020-12-06','2020-12-06 00:00:00',NULL,'461',1676681.86,1676681.86,'461','2020-12-07 13:45:25','461','2020-12-07 13:46:44',10,0),('1','116',166068,'MORNING SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'461',1960910.00,1960910.00,'461','2020-12-07 13:53:37','461','2020-12-07 13:53:58',10,0),('1','116',166069,'AFTERNOON','2020-12-07','2020-12-07 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',166071,'AFTERNOON','2020-12-07','2020-12-07 00:00:00',NULL,'461',2129177.83,2129177.83,'461','2020-12-08 17:36:14','461','2020-12-08 17:36:53',10,0),('1','116',166307,'MORNING SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'461',1197654.47,1197654.47,'461','2020-12-08 17:45:07','461','2020-12-08 17:45:41',10,0),('1','116',166383,'AFTERNOON','2020-12-08','2020-12-08 00:00:00',NULL,'461',2307575.12,2307575.12,'461','2020-12-09 11:26:49','461','2020-12-09 12:43:37',10,0),('1','116',166395,'MORNING SHIFT','2020-12-09','2020-12-09 00:00:00',NULL,'461',1679615.62,1679615.62,'461','2020-12-09 13:23:18','461','2020-12-09 15:02:48',10,0),('1','116',166559,'AFTERNOON','2020-12-09','2020-12-09 00:00:00',NULL,'461',2548912.24,2548912.24,'461','2020-12-10 10:12:39','461','2020-12-10 14:13:01',10,0),('1','116',166632,'MORNING SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'461',1868582.09,1868582.09,'461','2020-12-10 14:17:34','461','2020-12-10 14:18:09',10,0),('1','116',166752,'AFTERNOON','2020-12-10','2020-12-10 00:00:00',NULL,'461',2267843.78,2267843.78,'461','2020-12-11 09:05:48','461','2020-12-11 14:04:44',10,0),('1','116',166828,'MORNING SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'461',1849735.73,1849735.73,'461','2020-12-11 20:27:54','461','2020-12-12 17:59:55',10,0),('1','116',167029,'AFTERNOON','2020-12-11','2020-12-11 00:00:00',NULL,'461',2750156.43,2750156.43,'461','2020-12-12 18:03:34','461','2020-12-12 18:04:09',10,0),('1','116',167031,'MORNING SHIFT','2020-12-12','2020-12-12 00:00:00',NULL,'461',1033652.12,1033652.12,'461','2020-12-12 18:08:41','461','2020-12-12 18:13:27',10,0),('1','116',167291,'AFTERNOON','2020-12-12','2020-12-12 00:00:00',NULL,'461',1415138.55,1415138.55,'461','2020-12-14 13:16:03','461','2020-12-14 13:17:37',10,0),('1','116',167295,'MORNING SHIFT','2020-12-13','2020-12-13 00:00:00',NULL,'461',1333280.46,1333280.46,'461','2020-12-14 13:24:51','461','2020-12-14 13:25:43',10,0),('1','116',167298,'AFTERNOON','2020-12-13','2020-12-13 00:00:00',NULL,'461',1995861.48,1995861.48,'461','2020-12-16 17:26:00','461','2020-12-16 17:26:29',10,0),('1','116',167716,'MORNING SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'461',1925398.03,1925398.03,'461','2020-12-16 17:32:14','461','2020-12-16 17:32:47',10,0),('1','116',167718,'AFTERNOON','2020-12-14','2020-12-14 00:00:00',NULL,'461',2352018.65,2352018.65,'461','2020-12-16 17:36:21','461','2020-12-16 17:40:14',10,0),('1','116',167720,'MORNING SHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'461',1971869.14,1971869.14,'461','2020-12-16 17:48:46','461','2020-12-16 17:49:16',10,0),('1','116',167722,'AFTERNOON','2020-12-15','2020-12-15 00:00:00',NULL,'461',2589535.07,2589535.07,'461','2020-12-16 17:52:49','461','2020-12-16 17:53:26',10,0),('1','116',167726,'MORNING SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'461',1757099.21,1757099.21,'461','2020-12-16 17:59:10','461','2020-12-16 17:59:33',10,0),('1','116',167874,'AFTERNOON','2020-12-16','2020-12-16 00:00:00',NULL,'461',2685990.32,2685990.32,'461','2020-12-17 15:43:13','461','2020-12-17 15:45:54',10,0),('1','116',167879,'MORNING SHIFT','2020-12-17','2020-12-17 00:00:00',NULL,'461',2034110.57,2034110.57,'461','2020-12-17 15:50:16','461','2020-12-17 15:50:39',10,0),('1','116',168038,'AFTERNOON','2020-12-17','2020-12-17 00:00:00',NULL,'461',2549311.90,2549311.90,'461','2020-12-18 14:30:15','461','2020-12-18 14:41:07',10,0),('1','116',168181,'AFTERNOON','2020-12-18','2020-12-18 00:00:00',NULL,'461',2592227.90,2592227.90,'461','2020-12-19 11:35:12','461','2020-12-19 11:36:00',10,0),('1','116',168184,'MORNING SHIFT','2020-12-19','2020-12-19 00:00:00',NULL,'461',1752084.24,1752084.24,'461','2020-12-19 12:38:04','461','2020-12-19 15:12:23',10,0),('1','116',168359,'AFTERNOON','2020-12-19','2020-12-19 00:00:00',NULL,'461',1863379.46,1863379.46,'461','2020-12-20 13:41:40','461','2020-12-20 13:42:20',10,0),('1','116',168362,'MORNING SHIFT','2020-12-20','2020-12-20 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',168363,'MORNING SHIFT','2020-12-20','2020-12-20 00:00:00',NULL,'461',1548947.72,1548947.72,'461','2020-12-20 13:53:21','461','2020-12-20 14:07:59',10,0),('1','116',168584,'AFTERNOON','2020-12-20','2020-12-20 00:00:00',NULL,'461',1907126.02,1907126.02,'461','2020-12-21 16:26:42','461','2020-12-21 16:27:07',10,0),('1','116',168585,'MORNING SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'461',1747698.72,1747698.72,'461','2020-12-21 16:31:30','461','2020-12-21 16:32:03',10,0),('1','116',168707,'AFTERNOON','2020-12-21','2020-12-21 00:00:00',NULL,'461',2933415.97,2933415.97,'461','2020-12-22 13:29:19','461','2020-12-22 13:29:44',10,0),('1','116',168709,'MORNING SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'461',2064114.23,2064114.23,'461','2020-12-22 13:52:07','461','2020-12-22 13:52:52',10,0),('1','116',168896,'AFTERNOON','2020-12-22','2020-12-22 00:00:00',NULL,'461',2779389.98,2779389.98,'461','2020-12-23 15:09:04','461','2020-12-23 15:09:52',10,0),('1','116',168897,'MORNING SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'461',2184214.22,2184214.22,'461','2020-12-23 15:15:18','461','2020-12-23 15:15:38',10,0),('1','116',169068,'AFTERNOON','2020-12-23','2020-12-23 00:00:00',NULL,'461',3073192.93,3073192.93,'461','2020-12-24 15:51:43','461','2020-12-24 15:52:28',10,0),('1','116',169069,'MORNING SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'461',2598473.73,2598473.73,'461','2020-12-24 15:57:23','461','2020-12-24 16:11:18',10,0),('1','116',169214,'MORNING SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'461',1594754.16,1594754.16,'461','2020-12-25 16:47:10','461','2020-12-26 17:35:36',10,0),('1','116',169427,'AFTERNOON','2020-12-26','2020-12-26 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',169428,'AFTERNOON','2020-12-26','2020-12-26 00:00:00',NULL,'461',2802099.57,2802099.57,'461','2020-12-28 13:34:33','461','2020-12-28 13:35:18',10,0),('1','116',169713,'MORNING SHIFT','2020-12-27','2020-12-27 00:00:00',NULL,'461',1623699.21,1623699.21,'461','2020-12-28 13:43:19','461','2020-12-28 13:46:30',10,0),('1','116',169719,'AFTERNOON','2020-12-27','2020-12-27 00:00:00',NULL,'461',1184960.35,1184960.35,'461','2020-12-28 13:53:28','461','2020-12-28 13:54:20',10,0),('1','116',170130,'MORNING SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'461',2063352.22,2063352.22,'461','2020-12-30 18:29:32','461','2020-12-30 18:29:58',10,0),('1','116',170134,'AFTERNOON','2020-12-30','2020-12-30 00:00:00',NULL,'461',2080680.18,2080680.18,'461','2020-12-31 12:51:35','461','2020-12-31 12:52:14',10,0),('1','116',170247,'MORNING SHIFT','2020-12-31','2020-12-31 00:00:00',NULL,'461',1497832.71,1497832.71,'461','2020-12-31 13:13:53','461','2020-12-31 13:33:12',10,0),('1','116',170468,'AFTERNOON','2020-12-31','2020-12-31 00:00:00',NULL,'461',990554.86,990554.86,'461','2021-01-01 17:51:23','461','2021-01-01 17:51:43',10,0),('1','116',170478,'MORNING SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'461',1144477.34,1144477.34,'461','2021-01-02 14:54:49','461','2021-01-02 14:55:13',10,0),('1','116',170598,'AFTERNOON','2021-01-01','2021-01-01 00:00:00',NULL,'461',1277361.05,1277361.05,'461','2021-01-02 14:59:34','461','2021-01-02 15:01:06',10,0),('1','116',170600,'MORNING SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'461',1343724.82,1343724.82,'461','2021-01-02 15:58:45','461','2021-01-02 15:59:45',10,0),('1','116',170621,'AFTERNOON','2021-01-02','2021-01-02 00:00:00',NULL,'461',1608463.78,1608463.78,'461','2021-01-03 12:56:49','461','2021-01-03 12:57:21',10,0),('1','116',170742,'MORNING SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'461',1127396.75,1127396.75,'461','2021-01-03 13:01:07','461','2021-01-03 17:02:28',10,0),('1','116',170799,'AFTERNOON','2021-01-03','2021-01-03 00:00:00',NULL,'461',1609812.77,1609812.77,'461','2021-01-05 11:14:42','461','2021-01-05 11:28:03',10,0),('1','116',171096,'MORNING SHIFT','2021-01-04','2021-01-04 00:00:00',NULL,'461',1382655.88,1382655.88,'461','2021-01-05 11:46:14','461','2021-01-05 11:59:44',10,0),('1','116',171108,'AFTERNOON','2021-01-04','2021-01-04 00:00:00',NULL,'461',1849205.94,1849205.94,'461','2021-01-05 12:04:13','461','2021-01-05 12:04:54',10,0),('1','116',171112,'MORNING SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'461',1508363.33,1508363.33,'461','2021-01-05 19:32:28','461','2021-01-05 19:33:13',10,0),('1','116',171213,'AFTERNOON','2021-01-05','2021-01-05 00:00:00',NULL,'461',2264074.15,2264074.15,'461','2021-01-06 17:00:20','461','2021-01-06 17:01:30',10,0),('1','116',171348,'MORNING SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'461',1311307.45,1311307.45,'461','2021-01-06 17:14:04','461','2021-01-06 17:14:36',10,0),('1','116',171577,'AFTERNOON','2021-01-06','2021-01-06 00:00:00',NULL,'461',1761292.80,1761292.80,'461','2021-01-07 19:51:48','461','2021-01-07 19:52:53',10,0),('1','116',171580,'MORNING SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'461',1303282.68,1303282.68,'461','2021-01-07 19:57:56','461','2021-01-07 19:58:19',10,0),('1','116',171743,'AFTERNOON','2021-01-07','2021-01-07 00:00:00',NULL,'461',1762078.70,1762078.70,'461','2021-01-08 17:01:32','461','2021-01-08 17:02:04',10,0),('1','116',171747,'MORNING SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'461',1427908.67,1427908.67,'461','2021-01-08 17:10:04','461','2021-01-08 17:11:28',10,0),('1','116',171750,'AFTERNOON','2021-01-08','2021-01-08 00:00:00',NULL,'461',2194616.30,2194616.30,'461','2021-01-09 13:24:38','461','2021-01-09 13:27:07',10,0),('1','116',171882,'MORNING SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'461',1209568.54,1209568.54,'461','2021-01-09 13:36:55','461','2021-01-09 14:53:56',10,0),('1','116',172030,'AFTERNOON','2021-01-09','2021-01-09 00:00:00',NULL,'461',1687009.44,1687009.44,'461','2021-01-10 14:30:01','461','2021-01-10 14:36:50',10,0),('1','116',172033,'MORNING SHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'461',1420553.32,1420553.32,'461','2021-01-10 14:43:14','461','2021-01-10 14:43:45',10,0),('1','116',172258,'AFTERNOON','2021-01-10','2021-01-10 00:00:00',NULL,'461',1423787.88,1423787.88,'461','2021-01-11 17:23:55','461','2021-01-11 17:24:27',10,0),('1','116',172261,'MORNING SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'461',1344623.46,1344623.46,'461','2021-01-11 17:32:38','461','2021-01-11 17:33:04',10,0),('1','116',172418,'AFTERNOON','2021-01-11','2021-01-11 00:00:00',NULL,'461',2014430.09,2014430.09,'461','2021-01-12 14:40:52','461','2021-01-12 14:41:36',10,0),('1','116',172421,'MORNING SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'461',1279099.12,1279099.12,'461','2021-01-12 14:47:16','461','2021-01-12 14:47:43',10,0),('1','116',172427,'AFTERNOON','2021-01-12','2021-01-12 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',172428,'AFTERNOON','2021-01-12','2021-01-12 00:00:00',NULL,'461',1789521.59,1789521.59,'461','2021-01-13 15:44:58','461','2021-01-13 15:45:26',10,0),('1','116',172663,'MORNING SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'461',1201095.45,1201095.45,'461','2021-01-13 15:49:56','461','2021-01-13 15:50:27',10,0),('1','116',172825,'AFTERNOON','2021-01-13','2021-01-13 00:00:00',NULL,'461',1943808.48,1943808.48,'461','2021-01-14 14:47:27','461','2021-01-14 14:48:57',10,0),('1','116',172826,'MORNING SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'461',1549446.54,1549446.54,'461','2021-01-14 14:53:52','461','2021-01-14 14:54:18',10,0),('1','116',172835,'AFTERNOON','2021-01-14','2021-01-14 00:00:00',NULL,'461',1940560.78,1940560.78,'461','2021-01-15 14:10:42','461','2021-01-15 14:11:07',10,0),('1','116',172991,'MORNING SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'461',1504748.36,1504748.36,'461','2021-01-15 14:27:31','461','2021-01-15 14:27:54',10,0),('1','116',173002,'AFTERNOON','2021-01-15','2021-01-15 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',173003,'AFTERNOON','2021-01-15','2021-01-15 00:00:00',NULL,'461',2211596.05,2211596.05,'461','2021-01-16 12:30:31','461','2021-01-16 12:31:34',10,0),('1','116',173133,'MORNING SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'461',1380252.38,1380252.38,'461','2021-01-16 12:42:12','461','2021-01-17 15:23:19',10,0),('1','116',173322,'AFTERNOON','2021-01-16','2021-01-16 00:00:00',NULL,'461',2068463.42,2068463.42,'461','2021-01-17 15:48:25','461','2021-01-17 15:49:35',10,0),('1','116',173326,'MORNING SHIFT','2021-01-17','2021-01-17 00:00:00',NULL,'461',1298449.18,1298449.18,'461','2021-01-17 15:54:48','461','2021-01-17 15:56:48',10,0),('1','116',173449,'AFTERNOON','2021-01-17','2021-01-17 00:00:00',NULL,'461',1644332.12,1644332.12,'461','2021-01-18 10:33:23','461','2021-01-18 10:33:43',10,0),('1','116',173462,'MORNING SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'461',1410269.99,1410269.99,'461','2021-01-19 11:32:48','461','2021-01-19 11:33:53',10,0),('1','116',173673,'AFTERNOON','2021-01-18','2021-01-18 00:00:00',NULL,'461',2074053.21,2074053.21,'461','2021-01-19 11:37:54','461','2021-01-19 11:38:25',10,0),('1','116',173675,'MORNING SHIFT','2021-01-19','2021-01-19 00:00:00',NULL,'461',1223088.05,1223088.05,'461','2021-01-19 12:23:05','461','2021-01-19 17:06:44',10,0),('1','116',173746,'AFTERNOON','2021-01-19','2021-01-19 00:00:00',NULL,'461',1876482.31,1876482.31,'461','2021-01-20 15:11:39','461','2021-01-20 15:16:01',10,0),('1','116',173906,'MORNING SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'461',1202283.56,1202283.56,'461','2021-01-20 15:20:42','461','2021-01-20 15:21:26',10,0),('1','116',173908,'AFTERNOON','2021-01-20','2021-01-20 00:00:00',NULL,'461',1951331.78,1951331.78,'461','2021-01-21 13:48:23','461','2021-01-21 13:52:52',10,0),('1','116',174073,'MORNING SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'461',1363604.82,1363604.82,'461','2021-01-21 13:59:47','461','2021-01-21 14:23:16',10,0),('1','116',174246,'AFTERNOON','2021-01-21','2021-01-21 00:00:00',NULL,'461',482664.19,482664.19,'461','2021-01-22 14:37:29','461','2021-01-22 14:38:13',10,0),('1','116',174253,'AFTERNOON','2021-01-21','2021-01-21 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',174255,'AFTERNOON','2021-01-21','2021-01-21 00:00:00',NULL,'461',1233513.94,1233513.94,'461','2021-01-22 14:49:10','461','2021-01-22 14:50:02',10,0),('1','116',174258,'MORNING SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'461',1423016.82,1423016.82,'461','2021-01-22 14:59:19','461','2021-01-22 15:00:03',10,0),('1','116',174264,'AFTERNOON','2021-01-22','2021-01-22 00:00:00',NULL,'461',1707267.28,1707267.28,'461','2021-01-23 19:48:30','461','2021-01-23 20:06:22',10,0),('1','116',174572,'AFTERNOON','2021-01-23','2021-01-23 00:00:00',NULL,'461',2574407.36,2574407.36,'461','2021-01-24 14:13:14','461','2021-01-24 14:16:48',10,0),('1','116',174576,'MORNING SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'461',923410.44,923410.44,'461','2021-01-24 14:23:49','461','2021-01-24 14:25:31',10,0),('1','116',174789,'AFTERNOON','2021-01-24','2021-01-24 00:00:00',NULL,'461',1284248.98,1284248.98,'461','2021-01-25 14:52:19','461','2021-01-25 14:54:22',10,0),('1','116',174794,'MORNING SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'461',1332310.80,1332310.80,'461','2021-01-25 14:57:49','461','2021-01-25 14:58:36',10,0),('1','116',175111,'AFTERNOON','2021-01-25','2021-01-25 00:00:00',NULL,'461',2048403.02,2048403.02,'461','2021-01-27 10:13:15','461','2021-01-27 10:13:58',10,0),('1','116',175116,'MORNING SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'461',1277744.54,1277744.54,'461','2021-01-27 10:21:22','461','2021-01-27 10:22:13',10,0),('1','116',175120,'AFTERNOON','2021-01-26','2021-01-26 00:00:00',NULL,'461',2203106.92,2203106.92,'461','2021-01-27 10:28:26','461','2021-01-27 10:29:12',10,0),('1','116',175121,'MORNING SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'461',1474167.58,1474167.58,'461','2021-01-27 13:59:59','461','2021-01-27 14:02:06',10,0),('1','116',175367,'AFTERNOON','2021-01-27','2021-01-27 00:00:00',NULL,'461',2069283.54,2069283.54,'461','2021-01-28 15:53:34','461','2021-01-28 15:54:22',10,0),('1','116',175379,'MORNING SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'461',1391331.24,1391331.24,'461','2021-01-28 16:00:44','461','2021-01-28 16:01:26',10,0),('1','116',175592,'AFTERNOON','2021-01-28','2021-01-28 00:00:00',NULL,'461',2605188.50,2605188.50,'461','2021-01-29 20:03:16','461','2021-01-29 20:03:46',10,0),('1','116',175593,'MORNING SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'461',1501068.20,1501068.20,'461','2021-01-29 20:18:12','461','2021-01-29 20:46:55',10,0),('1','116',175721,'AFTERNOON','2021-01-29','2021-01-29 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',175725,'AFTERNOON','2021-01-29','2021-01-29 00:00:00',NULL,'461',2472525.09,2472525.09,'461','2021-01-30 16:26:57','461','2021-01-30 16:34:45',10,0),('1','116',175730,'MORNING SHIFT','2021-01-30','2021-01-30 00:00:00',NULL,'461',1407361.86,1407361.86,'461','2021-01-30 16:58:08','461','2021-01-30 16:58:30',10,0),('1','116',175895,'AFTERNOON','2021-01-30','2021-01-30 00:00:00',NULL,'461',1927663.65,1927663.65,'461','2021-01-31 16:49:19','461','2021-01-31 16:49:44',10,0),('1','116',175896,'MORNING SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'461',1153297.08,1153297.08,'461','2021-01-31 16:52:31','461','2021-02-01 10:00:24',10,0),('1','116',175973,'AFTERNOON','2021-01-31','2021-01-31 00:00:00',NULL,'461',1751639.67,1751639.67,'461','2021-02-01 10:06:12','461','2021-02-01 17:09:46',10,0),('1','116',176122,'MORNING SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'461',1456640.82,1456640.82,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',176312,'MORNING SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'461',1452852.72,1456640.82,'461','2021-02-02 18:53:08','461','2021-02-02 18:53:33',10,0),('1','116',176313,'AFTERNOON','2021-02-01','2021-02-01 00:00:00',NULL,'461',2418169.82,2421644.22,'461','2021-02-02 19:16:45','461','2021-02-02 19:19:48',10,0),('1','116',176318,'MORNING SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'461',1410181.36,1410592.41,'461','2021-02-02 19:22:49','461','2021-02-02 19:23:15',10,0),('1','116',176469,'AFTERNOON','2021-02-02','2021-02-02 00:00:00',NULL,'461',2167699.50,2170273.50,'461','2021-02-03 14:20:56','461','2021-02-03 14:22:00',10,0),('1','116',176474,'MORNING SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'461',1422328.22,1424885.22,'461','2021-02-03 14:30:02','461','2021-02-03 14:30:41',10,0),('1','116',176814,'AFTERNOON','2021-02-03','2021-02-03 00:00:00',NULL,'461',2783248.44,2790519.39,'461','2021-02-05 09:29:04','461','2021-02-05 09:30:24',10,0),('1','116',176816,'MORNING SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'461',1542320.52,1545952.77,'461','2021-02-05 09:37:34','461','2021-02-05 09:38:36',10,0),('1','116',176818,'AFTERNOON','2021-02-04','2021-02-04 00:00:00',NULL,'461',2152800.08,2155210.38,'461','2021-02-05 10:45:45','461','2021-02-05 10:47:09',10,0),('1','116',177156,'MORNING SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'461',212377.00,217203.75,'461','2021-02-06 15:50:24','461','2021-02-06 15:50:45',10,0),('1','116',177158,'AFTERNOON','2021-02-05','2021-02-05 00:00:00',NULL,'461',1589364.78,1597631.58,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',177164,'AFTERNOON','2021-02-05','2021-02-05 00:00:00',NULL,'461',1605898.38,1605898.38,'461','2021-02-06 16:05:38','461','2021-02-06 16:06:29',10,0),('1','116',177169,'MORNING SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'461',1272171.20,1272171.20,'461','2021-02-06 16:12:59','461','2021-02-06 16:13:43',10,0),('1','116',177342,'AFTERNOON','2021-02-06','2021-02-06 00:00:00',NULL,'461',1919341.92,1919341.92,'461','2021-02-07 14:25:32','461','2021-02-07 14:25:57',10,0),('1','116',177347,'MORNING SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'461',1153621.94,1153621.94,'461','2021-02-07 14:36:49','461','2021-02-07 14:38:40',10,0),('1','116',177595,'AFTERNOON','2021-02-07','2021-02-07 00:00:00',NULL,'461',1676006.40,1676006.40,'461','2021-02-08 17:29:28','461','2021-02-08 17:30:36',10,0),('1','116',177839,'MORNING SHIFT ','2021-02-08','2021-02-08 00:00:00',NULL,'461',452122.50,452122.50,'461','2021-02-09 17:07:01','461','2021-02-09 17:08:07',10,0),('1','116',177841,'MORNING SHIFT ','2021-02-09','2021-02-09 00:00:00',NULL,'461',2052011.26,2052011.26,'461','2021-02-09 17:12:18','461','2021-02-09 17:12:46',10,0),('1','116',177970,'AFTERNOON','2021-02-09','2021-02-09 00:00:00',NULL,'461',1163953.86,1163953.86,'461','2021-02-10 11:56:56','461','2021-02-10 11:57:52',10,0),('1','116',177973,'MORNING SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'461',1622878.56,1622878.56,'461','2021-02-10 13:28:29','461','2021-02-10 13:30:13',10,0),('1','116',178240,'AFTERNOON','2021-02-10','2021-02-10 00:00:00',NULL,'461',2308250.20,2308250.20,'461','2021-02-11 16:14:02','461','2021-02-11 16:15:16',10,0),('1','116',178243,'MORNING SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'461',2084804.76,2084804.76,'461','2021-02-11 16:25:01','461','2021-02-11 16:26:00',10,0),('1','116',178397,'AFTERNOON','2021-02-11','2021-02-11 00:00:00',NULL,'461',2712461.42,2712461.42,'461','2021-02-12 14:21:43','461','2021-02-12 14:22:47',10,0),('1','116',178399,'MORNING SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',178404,'MORNING SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'461',1461244.76,1461244.76,'461','2021-02-12 14:33:12','461','2021-02-12 14:33:53',10,0),('1','116',178812,'AFTERNOON','2021-02-12','2021-02-12 00:00:00',NULL,'461',1725560.82,1736212.43,'461','2021-02-14 13:50:07','461','2021-02-14 13:54:26',10,0),('1','116',178818,'MORNING SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'461',1358225.82,1366609.93,'461','2021-02-14 14:14:22','461','2021-02-14 14:15:00',10,0),('1','116',178827,'AFTERNOON','2021-02-13','2021-02-13 00:00:00',NULL,'461',2136273.28,2148623.32,'461','2021-02-14 14:22:12','461','2021-02-14 14:50:47',10,0),('1','116',178838,'MORNING SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'461',1141259.22,1148304.03,'461','2021-02-14 14:54:20','461','2021-02-14 14:57:22',10,0),('1','116',178841,'AFTERNOON','2021-02-14','2021-02-14 00:00:00',NULL,'461',1631380.50,1641450.75,'461','2021-02-16 09:38:12','461','2021-02-16 09:40:07',10,0),('1','116',179187,'MORNING SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'461',1312738.72,1312738.72,'461','2021-02-16 09:57:10','461','2021-02-16 09:57:39',10,0),('1','116',179198,'AFTERNOON','2021-02-15','2021-02-15 00:00:00',NULL,'461',1830923.58,1830923.58,'461','2021-02-16 10:47:41','461','2021-02-16 10:48:13',10,0),('1','116',179231,'MORNING SHIFT ','2021-02-16','2021-02-16 00:00:00',NULL,'461',1264236.31,1264236.31,'461','2021-02-16 13:47:03','461','2021-02-16 13:47:57',10,0),('1','116',179277,'AFTERNOON','2021-02-16','2021-02-16 00:00:00',NULL,'461',263007.30,263007.30,'461','2021-02-17 14:52:02','461','2021-02-17 14:52:46',10,0),('1','116',179496,'AFTERNOON','2021-02-16','2021-02-16 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',179498,'AFTERNOON','2021-02-16','2021-02-16 00:00:00',NULL,'461',2182530.07,2182530.07,'461','2021-02-17 15:11:27','461','2021-02-17 15:13:56',10,0),('1','116',179501,'MORNING SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'461',1551892.03,1551892.03,'461','2021-02-17 15:26:35','461','2021-02-17 15:27:42',10,0),('1','116',179505,'AFTERNOON','2021-02-17','2021-02-17 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',179508,'AFTERNOON','2021-02-17','2021-02-17 00:00:00',NULL,'461',2230781.64,2230781.64,'461','2021-02-18 17:06:51','461','2021-02-18 17:08:27',10,0),('1','116',179741,'MORNING SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'461',1364601.34,1364601.34,'461','2021-02-18 17:18:19','461','2021-02-18 17:19:07',10,0),('1','116',179915,'MORNING SHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'461',1996427.16,1996427.16,'461','2021-02-19 14:45:36','461','2021-02-19 14:48:34',10,0),('1','116',180063,'AFTERNOON','2021-02-19','2021-02-19 00:00:00',NULL,'461',3332748.20,3332748.20,'461','2021-02-20 11:55:32','461','2021-02-20 11:58:41',10,0),('1','116',180068,'MORNING SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'461',2137099.64,2137099.64,'461','2021-02-20 15:09:54','461','2021-02-20 15:12:11',10,0),('1','116',180331,'AFTERNOON','2021-02-21','2021-02-21 00:00:00',NULL,'461',573544.86,573544.86,'461','2021-02-21 20:27:19','461','2021-02-21 20:27:57',10,0),('1','116',180593,'MORNING SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'461',1686442.01,1686442.01,'461','2021-02-23 10:21:28','461','2021-02-23 10:25:05',10,0),('1','116',180615,'AFTERNOON','2021-02-22','2021-02-22 00:00:00',NULL,'461',2431193.76,2431193.76,'461','2021-02-23 16:27:04','461','2021-02-23 16:27:55',10,0),('1','116',180692,'MORNING SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'461',1949298.69,1949298.69,'461','2021-02-23 16:31:43','461','2021-02-23 16:32:37',10,0),('1','116',180695,'AFTERNOON','2021-02-23','2021-02-23 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',180698,'AFTERNOON','2021-02-23','2021-02-23 00:00:00',NULL,'461',804249.15,804249.15,'461','2021-02-24 17:48:12','461','2021-02-24 17:50:47',10,0),('1','116',180937,'MORNING SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'461',1970638.55,1970638.55,'461','2021-02-24 17:55:47','461','2021-02-24 17:56:42',10,0),('1','116',181040,'AFTERNOON','2021-02-24','2021-02-24 00:00:00',NULL,'461',2172775.36,2172775.36,'461','2021-02-25 12:58:16','461','2021-02-25 12:59:12',10,0),('1','116',181045,'MORNING SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'461',1440499.64,1440499.64,'461','2021-02-25 15:42:34','461','2021-02-25 15:43:11',10,0),('1','116',181203,'AFTERNOON','2021-02-25','2021-02-25 00:00:00',NULL,'461',1733646.33,1733646.33,'461','2021-02-26 16:35:55','461','2021-02-26 16:36:23',10,0),('1','116',181298,'AFTERNOON','2021-02-26','2021-02-26 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',181302,'AFTERNOON','2021-02-26','2021-02-26 00:00:00',NULL,'461',141974.55,141974.55,'461','2021-02-28 11:54:36','461','2021-02-28 12:56:10',10,0),('1','116',181607,'MORNING SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'461',1483788.09,1483788.09,'461','2021-02-28 14:04:00','461','2021-02-28 16:53:25',10,0),('1','116',181675,'AFTERNOON','2021-02-28','2021-02-28 00:00:00',NULL,'461',2079189.51,2079189.51,'461','2021-03-01 13:50:09','461','2021-03-01 13:53:12',10,0),('1','116',181806,'MORNING SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'461',1639238.14,1639238.14,'461','2021-03-01 14:10:39','461','2021-03-01 14:12:23',10,0),('1','116',182043,'MORNING SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'461',3177439.06,3177439.06,'461','2021-03-02 15:09:13','461','2021-03-02 15:09:51',10,0),('1','116',182088,'AFTERNOON','2021-03-02','2021-03-02 00:00:00',NULL,'461',3326522.82,3326522.82,'461','2021-03-03 16:30:42','461','2021-03-03 16:32:04',10,0),('1','116',182264,'MORNING SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'461',756440.27,756440.27,'461','2021-03-03 16:39:24','461','2021-03-03 16:40:09',10,0),('1','116',182403,'AFTERNOON','2021-03-03','2021-03-03 00:00:00',NULL,'461',1763980.84,1763980.84,'461','2021-03-04 11:51:31','461','2021-03-04 11:52:19',10,0),('1','116',182426,'MORNING SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'461',2834574.32,2834574.32,'461','2021-03-04 14:39:49','461','2021-03-04 14:44:12',10,0),('1','116',182585,'AFTERNOON','2021-03-04','2021-03-04 00:00:00',NULL,'461',1216370.51,1216370.51,'461','2021-03-05 13:38:39','461','2021-03-05 13:39:32',10,0),('1','116',182594,'MORNING SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'461',158998.16,158998.16,'461','2021-03-05 13:58:19','461','2021-03-05 13:59:06',10,0),('1','116',182917,'AFTERNOON','2021-03-06','2021-03-06 00:00:00',NULL,'461',1727846.68,1727846.68,'461','2021-03-07 14:18:38','461','2021-03-07 14:19:38',10,0),('1','116',182925,'MORNING SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'461',2182766.21,2182766.21,'461','2021-03-07 14:26:19','461','2021-03-07 14:27:14',10,0),('1','116',183126,'AFTERNOON','2021-03-07','2021-03-07 00:00:00',NULL,'461',2996844.50,2996844.50,'461','2021-03-08 14:32:29','461','2021-03-08 14:33:39',10,0),('1','116',183129,'MORNING SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'461',2535591.00,2535591.00,'461','2021-03-08 14:43:23','461','2021-03-08 14:46:01',10,0),('1','116',183354,'AFTERNOON','2021-03-08','2021-03-08 00:00:00',NULL,'461',1918251.71,1918251.71,'461','2021-03-09 14:58:19','461','2021-03-09 14:59:15',10,0),('1','116',183363,'MORNING SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'461',2150357.27,2150357.27,'461','2021-03-09 15:05:54','461','2021-03-09 15:06:36',10,0),('1','116',183571,'AFTERNOON','2021-03-09','2021-03-09 00:00:00',NULL,'461',3029146.49,3029146.49,'461','2021-03-10 15:43:20','461','2021-03-10 15:45:04',10,0),('1','116',183575,'MORNING SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'461',915741.82,915741.82,'461','2021-03-10 16:03:02','461','2021-03-10 16:05:34',10,0),('1','116',183673,'AFTERNOON','2021-03-10','2021-03-10 00:00:00',NULL,'461',3995329.17,3995329.17,'461','2021-03-11 14:26:43','461','2021-03-11 14:27:20',10,0),('1','116',183939,'AFTERNOON','2021-03-11','2021-03-11 00:00:00',NULL,'461',307907.06,307907.06,'461','2021-03-14 19:32:18','461','2021-03-14 19:32:55',10,0),('1','116',184437,'AFTERNOON','2021-03-12','2021-03-12 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',184438,'AFTERNOON','2021-03-12','2021-03-12 00:00:00',NULL,'461',212039.75,212039.75,'461','2021-03-14 19:43:07','461','2021-03-14 19:43:38',10,0),('1','116',184440,'AFTERNOON','2021-03-13','2021-03-13 00:00:00',NULL,'461',183549.60,183549.60,'461','2021-03-14 19:49:50','461','2021-03-14 19:50:38',10,0),('1','116',184441,'AFTERNOON','2021-03-13','2021-03-13 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',184442,'MORNING SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',184602,'MORNING SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'461',1003952.30,1003952.30,'461','2021-03-15 14:13:45','461','2021-03-15 14:21:11',10,0),('1','116',184605,'AFTERNOON','2021-03-14','2021-03-14 00:00:00',NULL,'461',1824273.85,1824273.85,'461','2021-03-15 14:24:21','461','2021-03-15 14:24:59',10,0),('1','116',184608,'MORNING SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'461',2287679.20,2287679.20,'461','2021-03-15 14:32:02','461','2021-03-15 14:32:51',10,0),('1','116',184615,'AFTERNOON','2021-03-15','2021-03-15 00:00:00',NULL,'461',2273279.05,2273279.05,'461','2021-03-15 19:37:13','461','2021-03-15 19:49:01',10,0),('1','116',184663,'AFTERNOON','2021-03-15','2021-03-15 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',185014,'MORNING SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'461',2619763.25,2619763.25,'461','2021-03-17 14:03:11','461','2021-03-17 14:07:53',10,0),('1','116',185187,'AFTERNOON','2021-03-17','2021-03-17 00:00:00',NULL,'461',3188376.45,3188376.45,'461','2021-03-18 19:29:15','533','2021-03-19 13:13:22',10,0),('1','116',185385,'MORNING SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'461',2011373.10,2011373.10,'461','2021-03-19 16:02:21','533','2021-03-19 16:08:42',10,0),('1','116',185405,'AFTERNOON','2021-03-18','2021-03-18 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',185406,'AFTERNOON','2021-03-18','2021-03-18 00:00:00',NULL,'461',2446497.97,2446497.97,'461','2021-03-19 17:01:57','533','2021-03-19 18:09:47',10,0),('1','116',185429,'MORNING SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'461',1976634.17,1976634.17,'461','2021-03-19 18:25:51','533','2021-03-19 19:05:28',10,0),('1','116',185447,'AFTERNOON','2021-03-19','2021-03-19 00:00:00',NULL,'461',2898065.71,2898065.71,'461','2021-03-20 09:10:32','533','2021-03-20 09:36:36',10,0),('1','116',185513,'MORNING SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'461',1976412.49,1976412.49,'461','2021-03-20 13:54:23','533','2021-03-20 16:23:45',10,0),('1','116',185612,'AFTERNOON','2021-03-20','2021-03-20 00:00:00',NULL,'461',1377074.53,1377074.53,'461','2021-03-21 08:01:20','533','2021-03-21 08:50:14',10,0),('1','116',185717,'MORNING SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'461',1731068.15,1731068.15,'461','2021-03-21 13:24:04','533','2021-03-21 14:11:33',10,0),('1','116',185804,'AFTERNOON','2021-03-21','2021-03-21 00:00:00',NULL,'461',2300182.65,2300182.65,'461','2021-03-22 09:41:31','533','2021-03-22 11:25:00',10,0),('1','116',185971,'MORNING SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'461',2101319.39,2101319.39,'461','2021-03-22 13:53:53','533','2021-03-22 14:33:21',10,0),('1','116',186002,'AFTERNOON','2021-03-22','2021-03-22 00:00:00',NULL,'461',2649564.37,2649564.37,'461','2021-03-23 09:49:19','533','2021-03-23 14:56:20',10,0),('1','116',186240,'MORNING SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'461',2296267.39,2296267.39,'461','2021-03-23 15:04:18','533','2021-03-24 09:02:07',10,0),('1','116',186371,'AFTERNOON','2021-03-23','2021-03-23 00:00:00',NULL,'461',1031819.34,1031819.34,'461','2021-03-24 14:07:28','533','2021-03-24 15:07:11',10,0),('1','116',186582,'MORNING SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'461',2285504.50,2285504.50,'461','2021-03-25 13:57:39','533','2021-03-25 14:36:12',10,0),('1','116',186694,'AFTERNOON','2021-03-25','2021-03-25 00:00:00',NULL,'461',2825119.26,2825119.26,'461','2021-03-26 08:44:53','533','2021-03-26 15:49:20',10,0),('1','116',186911,'MORNING SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'461',2444209.45,2444209.45,'461','2021-03-26 16:09:49','533','2021-03-26 18:40:37',10,0),('1','116',186944,'AFTERNOON','2021-03-26','2021-03-26 00:00:00',NULL,'461',3264829.69,3264829.69,'461','2021-03-27 10:04:20','533','2021-03-27 12:30:50',10,0),('1','116',187054,'MORNING SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'461',2311181.89,2311181.89,'461','2021-03-27 13:49:12','533','2021-03-27 14:10:43',10,0),('1','116',187100,'AFTERNOON','2021-03-27','2021-03-27 00:00:00',NULL,'461',2717179.03,2717179.03,'461','2021-03-28 11:05:37','533','2021-03-28 12:23:33',10,0),('1','116',187257,'MORNING SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'461',1673936.65,1673936.65,'461','2021-03-28 13:16:47','533','2021-03-28 13:44:28',10,0),('1','116',187311,'AFTERNOON','2021-03-28','2021-03-28 00:00:00',NULL,'461',2022743.61,2022743.61,'461','2021-03-29 09:20:30','533','2021-03-29 15:47:46',10,0),('1','116',187519,'MORNING SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'461',2119299.92,2119299.92,'461','2021-03-29 16:12:31','533','2021-03-29 17:06:46',10,0),('1','116',187551,'AFTERNOON','2021-03-29','2021-03-29 00:00:00',NULL,'461',3116274.75,3116274.75,'461','2021-03-30 08:56:30','533','2021-03-30 12:53:35',10,0),('1','116',187711,'MORNING SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'461',2016724.02,2016724.02,'461','2021-03-30 13:33:50','533','2021-03-30 15:36:17',10,0),('1','116',187746,'AFTERNOON','2021-03-30','2021-03-30 00:00:00',NULL,'461',2856780.38,2856780.38,'461','2021-03-31 08:47:18','533','2021-03-31 11:12:50',10,0),('1','116',187893,'MORNING SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'461',2224394.17,2224394.17,'461','2021-03-31 13:50:16','533','2021-03-31 16:18:02',10,0),('1','116',187992,'AFTERNOON','2021-03-31','2021-03-31 00:00:00',NULL,'461',2714714.47,2714714.47,'461','2021-04-01 08:37:33','533','2021-04-01 11:12:36',10,0),('1','116',188115,'MORNING SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'461',2650477.80,2650477.80,'461','2021-04-01 13:53:15','533','2021-04-01 16:02:16',10,0),('1','116',188182,'AFTERNOON','2021-04-01','2021-04-01 00:00:00',NULL,'461',3411847.54,3411847.54,'461','2021-04-02 09:24:41','533','2021-04-02 15:32:02',10,0),('1','116',188354,'MORNING SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'461',2820690.55,2820690.55,'461','2021-04-02 16:12:50','533','2021-04-02 20:26:58',10,0),('1','116',188398,'AFTERNOON ','2021-04-02','2021-04-02 00:00:00',NULL,'461',2168923.64,2168923.64,'461','2021-04-03 09:14:08','533','2021-04-03 15:31:42',10,0),('1','116',188550,'MORNING SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'461',2835481.17,2835481.17,'461','2021-04-03 16:06:00','533','2021-04-03 20:30:04',10,0),('1','116',188592,'AFTERNOON ','2021-04-03','2021-04-03 00:00:00',NULL,'461',2579584.21,2579584.21,'461','2021-04-04 10:27:36','533','2021-04-04 15:36:29',10,0),('1','116',188852,'MORNING SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'461',2122545.25,2122545.25,'461','2021-04-05 09:43:31','533','2021-04-05 14:49:42',10,0),('1','116',188938,'AFTERNOON','2021-04-04','2021-04-04 00:00:00',NULL,'461',2372422.62,2372422.62,'461','2021-04-05 15:30:40','533','2021-04-05 17:17:33',10,0),('1','116',188956,'MORNING SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'461',2476222.65,2476222.65,'461','2021-04-05 19:12:42','533','2021-04-06 10:36:14',10,0),('1','116',189082,'AFTERNOON','2021-04-05','2021-04-05 00:00:00',NULL,'461',1771827.93,1771827.93,'461','2021-04-06 15:19:25','533','2021-04-06 16:09:25',10,0),('1','116',189152,'AFTERNOON','2021-04-06','2021-04-06 00:00:00',NULL,'461',3018121.09,3018121.09,'461','2021-04-07 11:07:05','533','2021-04-07 17:49:04',10,0),('1','116',189384,'MORNING SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'461',2838152.81,2838152.81,'461','2021-04-07 20:09:05','533','2021-04-08 08:40:30',10,0),('1','116',189496,'AFTERNOON','2021-04-07','2021-04-07 00:00:00',NULL,'461',3442462.47,3442462.47,'461','2021-04-08 10:59:37','533','2021-04-08 20:36:46',10,0),('1','116',189597,'Morning ','2021-04-08','2021-04-08 00:00:00',NULL,'461',2664741.43,2664741.43,'461','2021-04-08 21:32:29','533','2021-04-09 10:02:56',10,0),('1','116',189745,'AFTERNOON','2021-04-08','2021-04-08 00:00:00',NULL,'461',3148681.09,3148681.09,'461','2021-04-09 14:52:32','533','2021-04-09 16:04:30',10,0),('1','116',189760,'MORNING SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'461',2200041.04,2200041.04,'461','2021-04-09 20:16:10','533','2021-04-10 13:47:09',10,0),('1','116',190084,'AFTERNOON','2021-04-10','2021-04-10 00:00:00',NULL,'461',2638776.34,2638776.34,'461','2021-04-11 11:19:22','533','2021-04-11 12:51:34',10,0),('1','116',190134,'MORNING SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'461',1983438.41,1983438.41,'461','2021-04-11 14:17:29','533','2021-04-11 14:51:39',10,0),('1','116',190192,'AFTERNOON ','2021-04-11','2021-04-11 00:00:00',NULL,'461',2133746.08,2133746.08,'461','2021-04-12 10:05:55','533','2021-04-12 13:06:28',10,0),('1','116',190582,'AFTERNOON','2021-04-12','2021-04-12 00:00:00',NULL,'461',344042.49,344042.49,'461','2021-04-13 14:54:33','533','2021-04-13 16:20:27',10,0),('1','116',190827,'MORNING SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',190829,'MORNING SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'461',1350026.85,1350026.85,'461','2021-04-14 15:18:05','533','2021-04-14 18:25:49',10,0),('1','116',190947,'AFTERNOON','2021-04-14','2021-04-14 00:00:00',NULL,'461',2595445.30,2595445.30,'461','2021-04-15 10:14:47','533','2021-04-15 14:53:10',10,0),('1','116',191069,'MORNING SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'461',829230.40,829230.40,'461','2021-04-16 05:21:52','533','2021-04-16 08:01:36',10,0),('1','116',191121,'AFTERNOON','2021-04-15','2021-04-15 00:00:00',NULL,'461',2515709.55,2515709.55,'461','2021-04-16 09:09:06','533','2021-04-16 14:45:33',10,0),('1','116',191225,'MORNING SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'461',1541846.90,1541846.90,'461','2021-04-16 15:12:38','533','2021-04-16 16:21:10',10,0),('1','116',191699,'AFTERNOON','2021-04-18','2021-04-18 00:00:00',NULL,'461',2037144.75,2037144.75,'461','2021-04-19 08:20:25','533','2021-04-19 18:50:48',10,0),('1','116',191915,'MORNING SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'461',1794177.80,1794177.80,'461','2021-04-19 20:13:02','533','2021-04-20 13:10:14',10,0),('1','116',192104,'AFTERNOON','2021-04-19','2021-04-19 00:00:00',NULL,'461',2562181.15,2562181.15,'461','2021-04-20 17:21:27','533','2021-04-20 18:44:00',10,0),('1','116',192165,'MORNING SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'461',1026271.95,1026271.95,'461','2021-04-21 09:03:29','533','2021-04-21 09:14:52',10,0),('1','116',192177,'MORNING SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'461',61925.20,61925.20,'461','2021-04-21 09:18:47','533','2021-04-21 10:16:24',10,0),('1','116',192307,'MORNING SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'461',2361173.55,2361173.55,'461','2021-04-21 19:25:27','533','2021-04-21 19:34:06',10,0),('1','116',192312,'AFTERNOON','2021-04-21','2021-04-21 00:00:00',NULL,'461',2289915.55,2289915.55,'461','2021-04-21 20:54:12','533','2021-04-22 10:29:05',10,0),('1','116',192532,'MORNING SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'461',2607118.05,2607118.05,'461','2021-04-22 17:21:23','533','2021-04-23 13:53:48',10,0),('1','116',193582,'MORNING SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'461',1855524.95,1855524.95,'461','2021-04-27 16:52:37','533','2021-04-27 19:02:35',10,0),('1','116',193790,'AFTERNOON','2021-04-27','2021-04-27 00:00:00',NULL,'461',2119323.30,2119323.30,'461','2021-04-28 15:48:51','533','2021-04-28 16:00:41',10,0),('1','116',193806,'MORNING SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'461',1780820.45,1780820.45,'461','2021-04-28 16:42:24','533','2021-04-28 19:39:10',10,0),('1','116',193910,'AFTERNOON','2021-04-28','2021-04-28 00:00:00',NULL,'461',2025518.95,2025518.95,'461','2021-04-29 09:31:28','533','2021-04-29 10:02:19',10,0),('1','116',193926,'AFTERNOON','2021-04-29','2021-04-29 00:00:00',NULL,'461',2882050.45,2882050.45,'461','2021-04-30 11:23:12','533','2021-04-30 11:53:57',10,0),('1','116',194198,'MORNING SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'461',2137950.50,2137950.50,'461','2021-04-30 14:00:41','533','2021-05-01 11:53:32',10,0),('1','116',194390,'MORNING SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'461',2389838.10,2389838.10,'461','2021-05-01 15:59:46','533','2021-05-02 15:10:39',10,0),('1','116',194626,'MORNING SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'461',1634744.60,1634744.60,'461','2021-05-02 16:51:47','533','2021-05-02 17:06:13',10,0),('1','116',194631,'AFTERNOON','2021-05-01','2021-05-01 00:00:00',NULL,'461',2062925.85,2062925.85,'461','2021-05-02 17:20:04','533','2021-05-02 17:32:47',10,0),('1','116',194635,'MORNING SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'461',1297290.90,1297290.90,'461','2021-05-02 17:42:19','533','2021-05-02 19:09:07',10,0),('1','116',194646,'AFTERNOON','2021-05-02','2021-05-02 00:00:00',NULL,'461',975388.80,975388.80,'461','2021-05-02 19:38:12','533','2021-05-03 02:49:48',10,0),('1','116',194987,'AFTERNOON ','2021-05-04','2021-05-04 00:00:00',NULL,'461',248920.35,248920.35,'461','2021-05-04 18:52:58','533','2021-05-05 07:35:10',10,0),('1','116',195250,'AFTERNOON ','2021-05-05','2021-05-05 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',195492,'AFTERNOON','2021-05-06','2021-05-06 00:00:00',NULL,'461',2270464.85,2270464.85,'461','2021-05-06 20:26:23','533','2021-05-07 08:26:40',10,0),('1','116',195664,'MORNING SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'461',1576938.35,1576938.35,'461','2021-05-07 13:17:23','533','2021-05-07 15:53:51',10,0),('1','116',195754,'AFTERNOON','2021-05-07','2021-05-07 00:00:00',NULL,'461',1887759.55,1887759.55,'461','2021-05-07 20:03:47','533','2021-05-08 07:53:42',10,0),('1','116',195911,'MORNING SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'461',1194365.90,1194365.90,'461','2021-05-08 13:50:40','533','2021-05-08 16:41:13',10,0),('1','116',195951,'AFTERNOON','2021-05-08','2021-05-08 00:00:00',NULL,'461',1165827.35,1165827.35,'461','2021-05-09 11:02:45','533','2021-05-09 12:00:57',10,0),('1','116',196197,'AFTERNOON','2021-05-09','2021-05-09 00:00:00',NULL,'461',1592546.75,1592546.75,'461','2021-05-10 11:01:16','533','2021-05-10 12:44:27',10,0),('1','116',196357,'MORNING SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'461',1231995.85,1231995.85,'461','2021-05-10 13:23:50','533','2021-05-10 15:05:10',10,0),('1','116',196418,'AFTERNOON','2021-05-10','2021-05-10 00:00:00',NULL,'461',2233864.70,2233864.70,'461','2021-05-10 20:14:51','533','2021-05-11 02:42:06',10,0),('1','116',196499,'MORNING SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'461',2208806.05,2208806.05,'461','2021-05-11 14:21:06','533','2021-05-11 15:03:38',10,0),('1','116',196620,'AFTERNOON','2021-05-11','2021-05-11 00:00:00',NULL,'461',2457380.40,2457380.40,'461','2021-05-12 12:33:22','533','2021-05-12 15:33:23',10,0),('1','116',196824,'MORNING SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'461',1306432.85,1306432.85,'461','2021-05-12 16:53:02','533','2021-05-13 16:00:40',10,0),('1','116',196977,'AFTERNOON','2021-05-12','2021-05-12 00:00:00',NULL,'461',1919091.45,1919091.45,'461','2021-05-13 17:29:07','533','2021-05-13 17:43:21',10,0),('1','116',196983,'MORNING SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'461',1261439.45,1261439.45,'461','2021-05-13 18:00:50','533','2021-05-14 09:54:27',10,0),('1','116',197128,'AFTERNOON','2021-05-13','2021-05-13 00:00:00',NULL,'461',1464637.10,1464637.10,'461','2021-05-14 13:11:48','533','2021-05-14 19:37:48',10,0),('1','116',197201,'MORNING SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'461',1504423.00,1504423.00,'461','2021-05-14 19:53:32','533','2021-05-15 13:55:26',10,0),('1','116',197225,'AFTERNOON ','2021-05-14','2021-05-14 00:00:00',NULL,'461',1844639.50,1844639.50,'461','2021-05-15 14:37:26','533','2021-05-15 14:40:53',10,0),('1','116',197239,'MORNING SHIFT','2021-05-15','2021-05-15 00:00:00',NULL,'461',1317175.60,1317175.60,'461','2021-05-15 18:26:50','533','2021-05-16 11:31:14',10,0),('1','116',197415,'AFTERNOON ','2021-05-15','2021-05-15 00:00:00',NULL,'461',1570272.55,1570272.55,'461','2021-05-16 13:44:17','533','2021-05-16 19:19:13',10,0),('1','116',197478,'MORNING SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'461',1625941.60,1625941.60,'461','2021-05-16 19:47:14','533','2021-05-16 20:18:02',10,0),('1','116',197509,'AFTERNOON ','2021-05-16','2021-05-16 00:00:00',NULL,'461',1512041.05,1512041.05,'461','2021-05-17 07:22:44','533','2021-05-17 10:39:23',10,0),('1','116',197699,'MORNING SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'461',1817792.10,1817792.10,'461','2021-05-17 13:09:30','533','2021-05-17 13:24:39',10,0),('1','116',197915,'AFTERNOON ','2021-05-17','2021-05-17 00:00:00',NULL,'461',2205398.90,2205398.90,'461','2021-05-18 09:18:21','533','2021-05-18 11:37:13',10,0),('1','116',198001,'MORNING SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'461',1547460.25,1547460.25,'461','2021-05-18 13:26:10','533','2021-05-19 08:04:25',10,0),('1','116',198217,'AFTERNOON ','2021-05-18','2021-05-18 00:00:00',NULL,'461',2370345.80,2370345.80,'461','2021-05-19 11:29:04','533','2021-05-19 15:20:54',10,0),('1','116',198285,'MORNING SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'461',1297972.50,1297972.50,'461','2021-05-19 15:46:47','533','2021-05-19 17:47:57',10,0),('1','116',198457,'AFTERNOON ','2021-05-19','2021-05-19 00:00:00',NULL,'461',2415597.60,2415597.60,'461','2021-05-20 13:10:11','533','2021-05-20 13:27:29',10,0),('1','116',198465,'MORNING SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'461',1616579.50,1616579.50,'461','2021-05-20 13:36:02','533','2021-05-20 15:45:21',10,0),('1','116',198533,'AFTERNOON ','2021-05-20','2021-05-20 00:00:00',NULL,'461',1998080.45,1998080.45,'461','2021-05-21 11:02:15','533','2021-05-21 14:40:39',10,0),('1','116',198700,'MORNING SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'461',1775318.25,1775318.25,'461','2021-05-21 15:13:03','533','2021-05-22 04:39:35',10,0),('1','116',198881,'MORNING SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'461',1399076.80,1399076.80,'461','2021-05-22 13:14:00','533','2021-05-22 15:48:59',10,0),('1','116',199115,'AFTERNOON ','2021-05-22','2021-05-22 00:00:00',NULL,'461',2107762.00,2107762.00,'461','2021-05-23 14:12:40','533','2021-05-23 17:42:18',10,0),('1','116',199153,'MORNING','2021-05-23','2021-05-23 00:00:00',NULL,'461',1093061.35,1093061.35,'461','2021-05-23 17:48:10','533','2021-05-24 04:40:20',10,0),('1','116',199311,'AFTERNOON SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'461',1500640.60,1500640.60,'461','2021-05-24 12:38:47','533','2021-05-24 13:00:37',10,0),('1','116',199354,'MORNING SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'461',1501695.25,1501695.25,'461','2021-05-24 13:39:06','533','2021-05-25 12:28:57',10,0),('1','116',199559,'AFTERNOON ','2021-05-24','2021-05-24 00:00:00',NULL,'461',2158440.50,2158440.50,'461','2021-05-25 13:09:19','533','2021-05-26 07:37:05',10,0),('1','116',199784,'AFTERNOON ','2021-05-25','2021-05-25 00:00:00',NULL,'461',481944.40,481944.40,'461','2021-05-26 13:00:03','533','2021-05-26 20:31:51',10,0),('1','116',199846,'MORNING SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'461',2239597.25,2239597.25,'461','2021-05-26 20:54:00','533','2021-05-27 11:30:20',10,0),('1','116',199995,'AFTERNOON ','2021-05-26','2021-05-26 00:00:00',NULL,'461',2446374.70,2446374.70,'461','2021-05-27 12:59:17','533','2021-05-28 10:40:05',10,0),('1','116',200190,'MORNING SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'461',1169599.50,1169599.50,'461','2021-05-28 11:35:24','533','2021-05-28 16:41:43',10,0),('1','116',200260,'MORNING SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'461',1745155.95,1745155.95,'461','2021-05-28 17:12:29','533','2021-05-28 17:15:06',10,0),('1','116',200361,'AFTERNOON ','2021-05-28','2021-05-28 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',200363,'AFTERNOON ','2021-05-28','2021-05-28 00:00:00',NULL,'461',2146504.80,2146504.80,'461','2021-05-29 13:11:57','533','2021-05-30 07:48:23',10,0),('1','116',200516,'MORNING SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'461',1392709.95,1392709.95,'461','2021-05-30 08:15:39','533','2021-05-30 11:08:12',10,0),('1','116',200582,'AFTERNOON SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'461',1695097.80,1695097.80,'461','2021-05-30 12:10:58','533','2021-05-30 13:43:53',10,0),('1','116',200610,'MORNING SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'461',1207303.35,1207303.35,'461','2021-05-30 13:54:07','533','2021-05-31 16:09:38',10,0),('1','116',200868,'AFTERNOON ','2021-05-30','2021-05-30 00:00:00',NULL,'461',1652758.80,1652758.80,'461','2021-05-31 16:38:22','533','2021-05-31 18:51:21',10,0),('1','116',200885,'MORNING SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'461',1242505.50,1242505.50,'461','2021-05-31 19:31:41','533','2021-06-01 12:19:43',10,0),('1','116',201026,'AFTERNOON ','2021-05-31','2021-05-31 00:00:00',NULL,'461',2221891.05,2221891.05,'461','2021-06-01 13:11:46','533','2021-06-02 09:36:50',10,0),('1','116',201184,'MORNING SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'461',1483974.60,1483974.60,'461','2021-06-02 10:21:44','533','2021-06-02 18:52:39',10,0),('1','116',201282,'AFTERNOON SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'461',2041136.85,2041136.85,'461','2021-06-02 19:44:42','533','2021-06-03 09:02:55',10,0),('1','116',201373,'MORNING SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'461',1627396.05,1627396.05,'461','2021-06-03 09:31:21','454','2021-06-03 15:26:33',10,0),('1','116',201442,'AFTERNOON SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'461',2609032.05,2609032.05,'461','2021-06-03 15:33:12','454','2021-06-03 15:51:08',10,0),('1','116',201449,'MORNING SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'461',2251454.25,2251454.25,'461','2021-06-03 16:03:56','533','2021-06-03 19:37:40',10,0),('1','116',201603,'AFTERNOON SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'461',2005537.65,2005537.65,'461','2021-06-04 10:53:50','533','2021-06-04 13:28:02',10,0),('1','116',201631,'MORNING SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',201632,'MORNING SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'461',1464711.95,1464711.95,'461','2021-06-04 14:44:46','533','2021-06-04 17:29:41',10,0),('1','116',201726,'AFTERNOON SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'461',1925199.75,1925199.75,'461','2021-06-05 12:52:25','533','2021-06-05 19:31:47',10,0),('1','116',202003,'MORNING SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'461',1416113.40,1416113.40,'461','2021-06-05 21:05:19','533','2021-06-06 08:58:16',10,0),('1','116',202074,'AFTERNOON SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'461',2025074.10,2025074.10,'461','2021-06-06 09:17:22','533','2021-06-08 11:32:19',10,0),('1','116',202535,'MORNING SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'461',990577.50,990577.50,'461','2021-06-08 13:33:21','454','2021-06-08 13:41:32',10,0),('1','116',202545,'AFTERNOON SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'461',1616469.30,1616469.30,'461','2021-06-08 14:13:43','454','2021-06-08 14:27:00',10,0),('1','116',202563,'MORNING SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'461',1399896.30,1399896.30,'461','2021-06-08 14:35:34','454','2021-06-08 14:40:07',10,0),('1','116',202568,'AFTERNOON SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'461',2033468.75,2033468.75,'461','2021-06-08 14:46:35','533','2021-06-08 15:15:06',10,0),('1','116',202597,'MORNING SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'461',1548690.35,1548690.35,'461','2021-06-08 17:21:19','533','2021-06-09 08:43:23',10,0),('1','116',202731,'AFTERNOON SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'461',1875401.00,1875401.00,'461','2021-06-09 10:43:31','533','2021-06-09 20:47:38',10,0),('1','116',202829,'MORNING SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'461',1189676.75,1189676.75,'461','2021-06-09 21:48:31','533','2021-06-10 13:14:46',10,0),('1','116',203008,'AFTERNOON SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'461',1980071.40,1980071.40,'461','2021-06-11 09:30:22','533','2021-06-11 11:16:38',10,0),('1','116',203205,'MORNING SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'461',1565549.25,1565549.25,'461','2021-06-11 11:53:09','533','2021-06-11 15:58:45',10,0),('1','116',203268,'AFTERNOON SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'461',1993564.45,1993564.45,'461','2021-06-11 20:58:54','533','2021-06-12 14:28:10',10,0),('1','116',203458,'MORNING SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'461',1466374.25,1466374.25,'461','2021-06-12 20:12:28','533','2021-06-13 06:37:42',10,0),('1','116',203568,'AFTERNOON SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'461',1264433.65,1264433.65,'461','2021-06-13 08:42:49','533','2021-06-13 09:14:49',10,0),('1','116',203654,'MORNING SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'461',1802517.95,1802517.95,'461','2021-06-13 14:49:45','533','2021-06-13 20:37:42',10,0),('1','116',203704,'AFTERNOON SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'461',1360257.35,1360257.35,'461','2021-06-14 10:06:32','533','2021-06-14 12:34:19',10,0),('1','116',203850,'MORNING SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'461',1199525.70,1199525.70,'461','2021-06-14 13:11:40','533','2021-06-14 13:16:32',10,0),('1','116',203882,'AFTERNOON SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'461',1760949.40,1760949.40,'461','2021-06-15 07:41:33','533','2021-06-15 13:29:33',10,0),('1','116',204099,'MORNING SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'461',1756612.30,1756612.30,'461','2021-06-15 14:10:30','533','2021-06-15 17:08:13',10,0),('1','116',204144,'AFTERNOON SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'461',2377725.60,2377725.60,'461','2021-06-16 08:40:23','533','2021-06-16 09:18:27',10,0),('1','116',204253,'MORNING SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'461',1302505.85,1302505.85,'461','2021-06-16 14:38:27','533','2021-06-16 20:22:30',10,0),('1','116',204370,'AFTERNOON SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'461',1487085.15,1487085.15,'461','2021-06-17 08:14:51','533','2021-06-17 09:27:17',10,0),('1','116',204477,'MORNING SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'461',1325652.50,1325652.50,'461','2021-06-17 14:06:27','533','2021-06-17 16:36:52',10,0),('1','116',204595,'AFTERNOON SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'461',1956131.90,1956131.90,'461','2021-06-18 09:29:38','533','2021-06-18 11:03:47',10,0),('1','116',204713,'MORNING SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'461',1680367.75,1680367.75,'461','2021-06-18 14:00:52','533','2021-06-18 18:59:18',10,0),('1','116',204805,'AFTERNOON SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'461',1872524.30,1872524.30,'461','2021-06-19 09:48:06','533','2021-06-19 11:07:02',10,0),('1','116',204937,'MORNING SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'461',1620692.85,1620692.85,'461','2021-06-19 13:35:55','533','2021-06-20 06:07:10',10,0),('1','116',205059,'AFTERNOON SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'461',1128267.60,1128267.60,'461','2021-06-20 11:05:57','533','2021-06-20 12:43:07',10,0),('1','116',205156,'MORNING SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'461',1230295.55,1230295.55,'461','2021-06-20 15:18:16','533','2021-06-21 11:52:58',10,0),('1','116',205338,'AFTERNOON SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'461',1276767.90,1276767.90,'461','2021-06-21 12:25:26','533','2021-06-21 13:47:46',10,0),('1','116',205365,'MORNING SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'461',1409244.10,1409244.10,'461','2021-06-21 14:32:14','533','2021-06-21 15:42:46',10,0),('1','116',205437,'AFTERNOON SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',205439,'AFTERNOON SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'461',1891732.65,1891732.65,'461','2021-06-22 08:35:51','533','2021-06-22 13:38:40',10,0),('1','116',205629,'MORNING SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'461',1259842.95,1259842.95,'461','2021-06-22 14:05:29','533','2021-06-22 15:25:19',10,0),('1','116',205690,'AFTERNOON ','2021-06-22','2021-06-22 00:00:00',NULL,'461',1143472.50,1143472.50,'461','2021-06-22 19:20:34','533','2021-06-22 22:34:11',10,0),('1','116',205909,'MORNING SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'461',116450.25,116450.25,'461','2021-06-23 17:48:23','533','2021-06-23 19:54:47',10,0),('1','116',206018,'AFTERNOON ','2021-06-23','2021-06-23 00:00:00',NULL,'461',1400725.65,1400725.65,'461','2021-06-24 10:21:42','533','2021-06-24 12:55:32',10,0),('1','116',206057,'MORNING SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'461',1897193.40,1897193.40,'461','2021-06-24 13:50:08','533','2021-06-24 14:34:18',10,0),('1','116',206211,'AFTERNOON ','2021-06-24','2021-06-24 00:00:00',NULL,'461',1868003.70,1868003.70,'461','2021-06-25 11:18:49','533','2021-06-25 14:19:33',10,0),('1','116',206284,'MORNING SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'461',1254435.60,1254435.60,'461','2021-06-25 14:27:38','533','2021-06-25 20:15:26',10,0),('1','116',206349,'AFTERNOON SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'461',1096606.50,1096606.50,'461','2021-06-26 06:19:02','533','2021-06-26 11:56:02',10,0),('1','116',206715,'MORNING SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'461',570914.85,570914.85,'461','2021-06-27 15:05:17','533','2021-06-27 16:03:45',10,0),('1','116',206755,'AFTERNOON SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'461',1248586.35,1248586.35,'461','2021-06-28 08:50:46','533','2021-06-28 10:33:24',10,0),('1','116',206912,'MORNING SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'461',1224945.90,1224945.90,'461','2021-06-28 13:39:49','533','2021-06-28 14:08:37',10,0),('1','116',206956,'AFTERNOON ','2021-06-28','2021-06-28 00:00:00',NULL,'461',1645003.80,1645003.80,'461','2021-06-29 08:38:54','533','2021-06-29 12:42:36',10,0),('1','116',207200,'MORNING SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'461',703132.65,703132.65,'461','2021-06-29 16:06:13','533','2021-06-29 20:27:21',10,0),('1','116',207288,'AFTERNOON ','2021-06-29','2021-06-29 00:00:00',NULL,'461',562676.85,562676.85,'461','2021-06-30 10:46:57','533','2021-06-30 11:01:20',10,0),('1','116',207359,'AFTERNOON ','2021-06-29','2021-06-29 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',207361,'AFTERNOON ','2021-06-29','2021-06-29 00:00:00',NULL,'461',1060223.72,1060223.72,'461','2021-06-30 11:40:13','533','2021-06-30 12:05:01',10,0),('1','116',207416,'MORNING SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'461',1353011.31,1353011.31,'461','2021-06-30 15:11:40','533','2021-06-30 21:39:05',10,0),('1','116',207541,'AFTERNOON ','2021-06-30','2021-06-30 00:00:00',NULL,'461',1704530.12,1704530.12,'461','2021-07-01 10:31:59','533','2021-07-02 04:42:47',10,0),('1','116',207716,'MORNING SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'461',1273468.47,1273468.47,'461','2021-07-02 07:23:57','533','2021-07-02 13:57:16',10,0),('1','116',207830,'AFTERNOON ','2021-07-01','2021-07-01 00:00:00',NULL,'461',1933095.24,1933095.24,'461','2021-07-02 14:14:04','533','2021-07-03 11:45:40',10,0),('1','116',208016,'MORNING SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'461',1429772.43,1429772.43,'461','2021-07-03 13:07:54','533','2021-07-03 14:30:13',10,0),('1','116',208054,'AFTERNOON SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'461',2049020.84,2049020.84,'461','2021-07-03 18:44:08','533','2021-07-05 08:50:41',10,0),('1','116',208403,'MORNING SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'461',1144985.35,1144985.35,'461','2021-07-05 09:38:18','533','2021-07-05 14:57:33',10,0),('1','116',208510,'AFTERNOON SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'461',1725521.26,1725521.26,'461','2021-07-05 16:51:07','533','2021-07-05 16:56:02',10,0),('1','116',208512,'MORNING SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'461',493075.00,493075.00,'461','2021-07-05 17:05:18','533','2021-07-05 19:42:45',10,0),('1','116',208658,'MORNING SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'461',1170054.75,1170054.75,'461','2021-07-06 14:45:30','533','2021-07-06 19:20:04',10,0),('1','116',208736,'AFTERNOON SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'461',1939236.97,1939236.97,'461','2021-07-07 09:21:10','533','2021-07-07 12:16:37',10,0),('1','116',208892,'MORNING SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'461',1069263.70,1069263.70,'461','2021-07-07 13:09:26','533','2021-07-07 14:04:08',10,0),('1','116',209037,'AFTERNOON SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'461',1791523.51,1791523.51,'461','2021-07-08 14:26:21','533','2021-07-08 15:33:16',10,0),('1','116',209159,'MORNING SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'461',1203645.09,1203645.09,'461','2021-07-08 17:53:15','533','2021-07-09 07:59:39',10,0),('1','116',209249,'AFTERNOON SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'461',2510213.98,2510213.98,'461','2021-07-09 09:08:47','454','2021-07-09 10:49:42',10,0),('1','116',209325,'MORNING SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',209328,'MORNING SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'461',1429512.15,1429512.15,'461','2021-07-09 14:02:37','533','2021-07-09 15:08:12',10,0),('1','116',209411,'AFTERNOON SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'461',2923413.86,2923413.86,'461','2021-07-10 09:47:05','533','2021-07-10 19:22:59',10,0),('1','116',209622,'MORNING SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'461',1067532.87,1067532.87,'461','2021-07-10 22:25:27','533','2021-07-11 13:47:55',10,0),('1','116',209787,'AFTERNOON SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'461',2347212.05,2347212.05,'461','2021-07-11 15:35:21','533','2021-07-11 18:23:10',10,0),('1','116',209842,'MORNING SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'461',903242.43,903242.43,'461','2021-07-11 21:00:28','454','2021-07-12 09:40:00',10,0),('1','116',209936,'AFTERNOON SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'461',1160858.85,1160858.85,'461','2021-07-12 10:15:44','533','2021-07-12 12:46:47',10,0),('1','116',209994,'MORNING SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'461',1188443.08,1188443.08,'461','2021-07-12 13:55:43','533','2021-07-12 15:36:56',10,0),('1','116',210056,'AFTERNOON SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'461',1760395.28,1760395.28,'461','2021-07-13 08:52:36','533','2021-07-13 13:39:35',10,0),('1','116',210225,'MORNING SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'461',1076521.13,1076521.13,'461','2021-07-13 14:01:21','533','2021-07-13 15:15:19',10,0),('1','116',210260,'AFTERNOON SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'461',1676666.34,1676666.34,'461','2021-07-14 08:14:41','533','2021-07-14 08:44:56',10,0),('1','116',210365,'MORNING SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'461',1189420.73,1189420.73,'461','2021-07-14 13:35:38','533','2021-07-14 17:50:09',10,0),('1','116',210481,'AFTERNOON SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'461',1939440.41,1939440.41,'461','2021-07-15 09:31:23','533','2021-07-15 10:15:16',10,0),('1','116',210712,'MORNING SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'461',382551.22,382551.22,'461','2021-07-15 23:32:20','454','2021-07-16 16:46:56',10,0),('1','116',210899,'MORNING SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'461',1425255.91,1425255.91,'461','2021-07-16 17:16:38','533','2021-07-16 18:25:32',10,0),('1','116',210930,'AFTERNOON SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'461',1978412.62,1978412.62,'461','2021-07-17 10:10:14','533','2021-07-17 12:48:14',10,0),('1','116',211080,'MORNING SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'461',1272832.60,1272832.60,'461','2021-07-17 14:34:55','454','2021-07-17 14:47:49',10,0),('1','116',211090,'AFTERNOON SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'461',1734557.98,1734557.98,'461','2021-07-18 12:24:54','533','2021-07-18 13:05:32',10,0),('1','116',211283,'MORNING SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'461',1167574.31,1167574.31,'461','2021-07-18 13:47:35','454','2021-07-19 09:44:51',10,0),('1','116',211452,'AFTERNOON SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'461',1357196.68,1357196.68,'461','2021-07-19 09:58:21','533','2021-07-19 10:58:01',10,0),('1','116',211481,'MORNING SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'461',1632804.13,1632804.13,'461','2021-07-19 13:29:06','533','2021-07-19 21:35:13',10,0),('1','116',211583,'AFTERNOON SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'461',2726239.80,2726239.80,'461','2021-07-20 12:13:28','454','2021-07-20 13:06:24',10,0),('1','116',211675,'MORNING SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'461',926058.86,926058.86,'461','2021-07-20 22:30:18','533','2021-07-21 11:16:07',10,0),('1','116',211875,'AFTERNOON SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'461',1176897.46,1176897.46,'461','2021-07-21 12:34:23','454','2021-07-21 20:55:34',10,0),('1','116',211970,'MORNING SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'461',915702.72,915702.72,'461','2021-07-21 22:30:49','454','2021-07-22 10:56:11',10,0),('1','116',212074,'AFTERNOON SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'461',1422304.06,1422304.06,'461','2021-07-22 11:30:56','454','2021-07-23 15:38:31',10,0),('1','116',212394,'MORNING SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'461',1342309.32,1342309.32,'461','2021-07-23 16:52:02','454','2021-07-23 16:54:50',10,0),('1','116',212409,'AFTERNOON SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'461',1472671.40,1472671.40,'461','2021-07-23 17:00:53','454','2021-07-23 17:02:21',10,0),('1','116',212411,'MORNING SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'461',1664881.47,1664881.47,'461','2021-07-24 06:15:59','454','2021-07-24 13:51:21',10,0),('1','116',212591,'AFTERNOON SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'461',1845277.20,1845277.20,'461','2021-07-24 14:18:48','533','2021-07-24 15:40:26',10,0),('1','116',212625,'MORNING SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'461',1557388.78,1557388.78,'461','2021-07-24 21:58:26','533','2021-07-25 10:49:56',10,0),('1','116',212737,'AFTERNOON SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'461',1617523.13,1617523.13,'461','2021-07-25 11:14:25','533','2021-07-26 09:01:10',10,0),('1','116',212953,'MORNING SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'461',1122419.33,1122419.33,'461','2021-07-26 10:05:30','454','2021-07-26 10:40:02',10,0),('1','116',212974,'AFTERNOON SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'461',1381959.98,1381959.98,'461','2021-07-26 11:31:24','454','2021-07-26 12:57:47',10,0),('1','116',212996,'MORNING SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'461',1880102.42,1880102.42,'461','2021-07-26 21:01:09','454','2021-07-27 13:03:21',10,0),('1','116',213288,'AFTERNOON SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'461',2149985.65,2149985.65,'461','2021-07-27 13:39:21','454','2021-07-27 14:20:55',10,0),('1','116',213304,'MORNING SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'461',1473483.02,1473483.02,'461','2021-07-27 14:28:18','533','2021-07-27 14:59:59',10,0),('1','116',213321,'AFTERNOON SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'461',2302979.46,2302979.46,'461','2021-07-28 13:01:55','533','2021-07-28 19:04:23',10,0),('1','116',213603,'MORNING SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'461',1238102.36,1238102.36,'461','2021-07-29 08:23:38','533','2021-07-29 11:47:31',10,0),('1','116',213749,'AFTERNOON SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'461',2154957.21,2154957.21,'461','2021-07-29 13:22:10','533','2021-07-29 18:13:47',10,0),('1','116',213858,'MORNING SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'461',1274974.59,1274974.59,'461','2021-07-29 21:01:45','454','2021-07-30 11:12:38',10,0),('1','116',213980,'AFTERNOON SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'461',2048448.22,2048448.22,'461','2021-07-30 14:38:33','454','2021-07-30 14:43:05',10,0),('1','116',214026,'MORNING SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'461',1482540.94,1482540.94,'461','2021-07-30 14:55:16','533','2021-07-30 17:58:29',10,0),('1','116',214064,'AFTERNOON SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'461',2258768.60,2258768.60,'461','2021-07-31 18:04:21','533','2021-07-31 18:10:56',10,0),('1','116',214287,'MORNING SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'461',1064745.34,1064745.34,'461','2021-07-31 21:54:01','533','2021-08-01 10:47:21',10,0),('1','116',214413,'AFTERNOON SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'461',1860065.82,1860065.82,'461','2021-08-01 11:54:40','533','2021-08-01 12:19:56',10,0),('1','116',214426,'MORNING SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'461',1322509.92,1322509.92,'461','2021-08-01 13:53:06','533','2021-08-01 22:14:57',10,0),('1','116',214506,'AFTERNOON SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'461',1266698.22,1266698.22,'461','2021-08-02 08:28:46','454','2021-08-02 09:12:42',10,0),('1','116',214613,'MORNING SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'461',1063931.97,1063931.97,'461','2021-08-02 15:48:41','533','2021-08-03 08:06:48',10,0),('1','116',214840,'AFTERNOON SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'461',1890464.22,1890464.22,'461','2021-08-03 10:13:23','533','2021-08-03 15:30:43',10,0),('1','116',215064,'MORNING SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'461',1609810.78,1609810.78,'461','2021-08-04 09:28:56','533','2021-08-04 20:43:24',10,0),('1','116',215206,'AFTERNOON SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'461',1842688.92,1842688.92,'461','2021-08-04 21:19:34','454','2021-08-05 12:30:42',10,0),('1','116',215335,'MORNING SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'461',1150960.99,1150960.99,'461','2021-08-05 14:01:56','454','2021-08-06 10:11:25',10,0),('1','116',215530,'AFTERNOON SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'461',1836364.28,1836364.28,'461','2021-08-06 10:22:56','454','2021-08-06 10:26:35',10,0),('1','116',215532,'AFTERNOON SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'461',3164394.24,3164394.24,'461','2021-08-07 13:00:33','454','2021-08-07 13:15:53',10,0),('1','116',215795,'MORNING SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'461',1246668.63,1246668.63,'461','2021-08-07 13:37:09','454','2021-08-07 14:19:59',10,0),('1','116',215809,'AFTERNOON SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'461',1952064.18,1952064.18,'461','2021-08-07 14:23:31','454','2021-08-07 14:26:22',10,0),('1','116',215811,'MORNING SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'461',1079473.32,1079473.32,'461','2021-08-07 14:32:31','454','2021-08-07 15:53:15',10,0),('1','116',215833,'AFTERNOON SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'461',1667361.06,1667361.06,'461','2021-08-08 10:16:55','454','2021-08-09 09:50:00',10,0),('1','116',216180,'MORNING SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'461',931676.94,931676.94,'461','2021-08-09 11:00:22','533','2021-08-09 19:56:30',10,0),('1','116',216303,'AFTERNOON SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'461',1346889.97,1346889.97,'461','2021-08-10 10:02:18','454','2021-08-10 12:23:56',10,0),('1','116',216443,'MORNING SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'461',1109412.23,1109412.23,'461','2021-08-10 12:57:46','454','2021-08-10 13:26:35',10,0),('1','116',216466,'AFTERNOON SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'461',2320104.74,2320104.74,'461','2021-08-10 13:49:15','454','2021-08-10 13:51:26',10,0),('1','116',216473,'MORNING SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'461',1232561.57,1232561.57,'461','2021-08-10 14:19:27','454','2021-08-10 14:26:10',10,0),('1','116',216479,'AFTERNOON SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'461',1626202.37,1626202.37,'461','2021-08-11 10:56:41','533','2021-08-11 11:07:45',10,0),('1','116',216649,'MORNING SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'461',1086869.33,1086869.33,'461','2021-08-11 13:49:46','454','2021-08-12 09:33:34',10,0),('1','116',216875,'AFTERNOON SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'461',2083751.85,2083751.85,'461','2021-08-12 11:39:45','454','2021-08-12 12:39:27',10,0),('1','116',216896,'MORNING SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'461',1062686.65,1062686.65,'461','2021-08-12 13:32:57','454','2021-08-12 15:38:09',10,0),('1','116',216981,'AFTERNOON SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'461',1576226.20,1576226.20,'461','2021-08-13 08:57:20','454','2021-08-13 13:57:31',10,0),('1','116',217180,'MORNING SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'461',1309921.40,1309921.40,'461','2021-08-13 14:32:51','454','2021-08-13 15:30:30',10,0),('1','116',217222,'AFTERNOON SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'461',1777577.40,1777577.40,'461','2021-08-14 11:31:14','454','2021-08-14 16:38:01',10,0),('1','116',217477,'MORNING SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'461',1129335.61,1129335.61,'461','2021-08-14 21:13:43','533','2021-08-15 16:02:38',10,0),('1','116',217663,'AFTERNOON SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'461',1760885.60,1760885.60,'461','2021-08-15 20:47:45','533','2021-08-15 21:07:14',10,0),('1','116',217681,'MORNING SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'461',1225566.51,1225566.51,'461','2021-08-16 11:32:40','454','2021-08-16 14:04:35',10,0),('1','116',217904,'AFTERNOON ','2021-08-15','2021-08-15 00:00:00',NULL,'461',1355423.10,1355423.10,'461','2021-08-16 15:22:57','454','2021-08-16 15:32:12',10,0),('1','116',217915,'MORNING SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'461',1170891.74,1170891.74,'461','2021-08-16 16:11:13','454','2021-08-16 16:20:51',10,0),('1','116',217929,'AFTERNOON SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',217951,'AFTERNOON ','2021-08-16','2021-08-16 00:00:00',NULL,'461',1492393.77,1492393.77,'461','2021-08-17 09:30:09','454','2021-08-17 09:43:58',10,0),('1','116',218084,'MORNING SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'461',1031525.94,1031525.94,'461','2021-08-17 13:33:55','533','2021-08-17 14:10:05',10,0),('1','116',218133,'AFTERNOON SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'461',1906585.76,1906585.76,'461','2021-08-18 11:01:15','454','2021-08-18 15:34:47',10,0),('1','116',218389,'MORNING SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'461',1114640.05,1114640.05,'461','2021-08-18 15:37:02','454','2021-08-18 15:38:18',10,0),('1','116',218390,'AFTERNOON SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'461',1648741.87,1648741.87,'461','2021-08-19 09:49:09','454','2021-08-19 13:54:14',10,0),('1','116',218583,'MORNING SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'461',2239366.41,2239366.41,'461','2021-08-19 14:38:33','533','2021-08-19 15:27:42',10,0),('1','116',218638,'AFTERNOON SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'461',1853068.97,1853068.97,'461','2021-08-20 09:35:37','533','2021-08-20 10:58:42',10,0),('1','116',218803,'MORNING SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'461',1195375.13,1195375.13,'461','2021-08-20 14:29:20','454','2021-08-21 07:28:20',10,0),('1','116',218925,'AFTERNOON SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'461',1544272.56,1544272.56,'461','2021-08-21 08:30:56','533','2021-08-21 11:09:14',10,0),('1','116',218980,'MORNING SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'461',1186793.24,1186793.24,'461','2021-08-21 13:05:11','533','2021-08-21 18:20:43',10,0),('1','116',219238,'AFTERNOON SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'461',1397595.27,1397595.27,'461','2021-08-22 13:43:22','533','2021-08-22 15:08:22',10,0),('1','116',219280,'MORNING SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'461',964153.15,964153.15,'461','2021-08-22 16:01:59','533','2021-08-22 18:33:41',10,0),('1','116',219424,'AFTERNOON SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'461',970443.32,970443.32,'461','2021-08-23 09:45:51','533','2021-08-23 10:30:40',10,0),('1','116',219498,'MORNING SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'461',990784.09,990784.09,'461','2021-08-23 13:49:21','533','2021-08-23 14:39:28',10,0),('1','116',219672,'AFTERNOON SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'461',1607152.29,1607152.29,'461','2021-08-24 09:52:12','533','2021-08-24 15:17:29',10,0),('1','116',219761,'MORNING SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'461',596805.61,596805.61,'461','2021-08-24 16:24:51','533','2021-08-25 08:54:34',10,0),('1','116',219903,'AFTERNOON SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'461',1905385.81,1905385.81,'461','2021-08-25 10:24:13','533','2021-08-25 13:23:29',10,0),('1','116',220001,'MORNING SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'461',1085485.54,1085485.54,'461','2021-08-25 18:33:33','533','2021-08-26 08:06:42',10,0),('1','116',220108,'AFTERNOON SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'461',1753221.53,1753221.53,'461','2021-08-26 09:38:51','533','2021-08-26 14:08:38',10,0),('1','116',220204,'MORNING SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'461',1237005.45,1237005.45,'461','2021-08-26 18:19:14','533','2021-08-26 19:49:55',10,0),('1','116',220304,'AFTERNOON SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'461',1616554.78,1616554.78,'461','2021-08-27 09:00:21','533','2021-08-27 11:42:09',10,0),('1','116',220383,'MORNING SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'461',1587104.85,1587104.85,'461','2021-08-27 14:04:52','454','2021-08-28 11:36:56',10,0),('1','116',220560,'AFTERNOON SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'461',1658585.98,1658585.98,'461','2021-08-28 11:57:37','454','2021-08-28 12:57:08',10,0),('1','116',220577,'MORNING SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'461',1159269.46,1159269.46,'461','2021-08-28 13:18:36','454','2021-08-28 13:34:57',10,0),('1','116',220752,'AFTERNOON SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'461',1373709.76,1373709.76,'461','2021-08-29 10:46:46','454','2021-08-29 12:04:44',10,0),('1','116',220809,'MORNING SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'461',1270441.67,1270441.67,'461','2021-08-29 14:04:46','533','2021-08-29 15:34:10',10,0),('1','116',220969,'AFTERNOON SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'461',1255653.59,1255653.59,'461','2021-08-30 09:19:58','454','2021-08-30 12:26:53',10,0),('1','116',221072,'MORNING SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'461',1500580.95,1500580.95,'461','2021-08-30 14:41:51','533','2021-08-30 19:36:43',10,0),('1','116',221206,'AFTERNOON SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'461',1981535.78,1981535.78,'461','2021-08-31 08:49:00','533','2021-08-31 09:36:10',10,0),('1','116',221309,'MORNING SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'461',1093059.44,1093059.44,'461','2021-08-31 14:39:51','533','2021-09-01 08:17:36',10,0),('1','116',221461,'AFTERNOON SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'461',2638086.62,2638086.62,'461','2021-09-01 10:15:40','533','2021-09-01 12:50:13',10,0),('1','116',221521,'MORNING SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'461',1208202.31,1208202.31,'461','2021-09-01 14:00:57','533','2021-09-01 16:48:46',10,0),('1','116',221687,'AFTERNOON SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'461',593593.21,593593.21,'461','2021-09-02 09:57:21','533','2021-09-02 11:41:17',10,0),('1','116',221747,'MORNING SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'461',1529938.62,1529938.62,'461','2021-09-02 14:02:24','454','2021-09-03 09:54:27',10,0),('1','116',221897,'AFTERNOON SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'461',1897632.38,1897632.38,'461','2021-09-03 10:05:37','533','2021-09-03 10:54:36',10,0),('1','116',221952,'MORNING SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'461',1344406.76,1344406.76,'461','2021-09-03 13:33:11','533','2021-09-03 13:47:09',10,0),('1','116',222125,'AFTERNOON SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'461',1951529.88,1951529.88,'461','2021-09-04 10:27:31','454','2021-09-04 14:12:59',10,0),('1','116',222199,'MORNING SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'461',1385964.73,1385964.73,'461','2021-09-04 15:10:31','533','2021-09-04 15:23:29',10,0),('1','116',222354,'AFTERNOON SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'461',1799395.19,1799395.19,'461','2021-09-05 11:13:57','533','2021-09-05 11:36:16',10,0),('1','116',222418,'MORNING SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'461',1215047.26,1215047.26,'461','2021-09-05 15:02:41','454','2021-09-06 09:49:39',10,0),('1','116',222568,'AFTERNOON SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'461',1184449.79,1184449.79,'461','2021-09-06 10:01:17','454','2021-09-06 10:38:39',10,0),('1','116',222648,'MORNING SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'461',1168058.06,1168058.06,'461','2021-09-06 14:46:43','533','2021-09-06 14:48:14',10,0),('1','116',222762,'AFTERNOON SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'461',2087248.90,2087248.90,'461','2021-09-07 08:51:14','533','2021-09-07 12:02:04',10,0),('1','116',222848,'MORNING SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'461',1223492.69,1223492.69,'461','2021-09-07 13:26:50','533','2021-09-07 15:24:33',10,0),('1','116',223015,'AFTERNOON SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'461',1774339.41,1774339.41,'461','2021-09-08 10:13:20','533','2021-09-08 12:48:31',10,0),('1','116',223071,'MORNING SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'461',1184931.39,1184931.39,'461','2021-09-08 13:49:14','533','2021-09-08 16:07:31',10,0),('1','116',223233,'AFTERNOON SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'461',1682460.54,1682460.54,'461','2021-09-09 09:24:26','533','2021-09-09 09:37:35',10,0),('1','116',223306,'MORNING SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'461',1382994.19,1382994.19,'461','2021-09-09 13:19:01','533','2021-09-09 15:38:15',10,0),('1','116',223477,'AFTERNOON SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'461',1904509.62,1904509.62,'461','2021-09-10 10:06:29','533','2021-09-10 10:24:29',10,0),('1','116',223586,'MORNING SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'461',1516065.96,1516065.96,'461','2021-09-10 16:06:37','533','2021-09-10 17:15:47',10,0),('1','116',223720,'AFTERNOON SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'461',1943734.91,1943734.91,'461','2021-09-11 10:28:24','533','2021-09-11 10:52:38',10,0),('1','116',223838,'MORNING SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'461',1237644.23,1237644.23,'461','2021-09-11 18:34:53','533','2021-09-12 06:23:09',10,0),('1','116',223926,'AFTERNOON SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'461',1915379.74,1915379.74,'461','2021-09-12 10:39:56','533','2021-09-12 10:52:29',10,0),('1','116',223998,'MORNING SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'461',1004849.92,1004849.92,'461','2021-09-12 20:05:03','454','2021-09-13 09:11:56',10,0),('1','116',224142,'AFTERNOON SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'461',1255594.92,1255594.92,'461','2021-09-13 09:22:15','533','2021-09-13 09:48:24',10,0),('1','116',224222,'MORNING SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'461',1318808.63,1318808.63,'461','2021-09-13 13:11:57','533','2021-09-13 17:35:22',10,0),('1','116',224356,'AFTERNOON SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'461',1777441.99,1777441.99,'461','2021-09-14 08:56:13','533','2021-09-14 10:15:36',10,0),('1','116',224425,'MORNING SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'461',1594651.37,1594651.37,'461','2021-09-14 13:15:35','533','2021-09-14 13:51:15',10,0),('1','116',224539,'AFTERNOON SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'461',1731417.45,1731417.45,'461','2021-09-15 07:43:12','533','2021-09-15 09:25:49',10,0),('1','116',224683,'MORNING SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'461',1923779.96,1923779.96,'461','2021-09-15 13:38:02','533','2021-09-15 14:11:39',10,0),('1','116',224851,'AFTERNOON SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'461',1728744.90,1728744.90,'461','2021-09-16 10:35:15','533','2021-09-16 10:42:41',10,0),('1','116',224871,'MORNING SHIFT 1','2021-09-16','2021-09-16 00:00:00',NULL,'461',204974.90,204974.90,'461','2021-09-16 12:30:30','533','2021-09-16 13:01:20',10,0),('1','116',224923,'MORNING SHIFT 2','2021-09-16','2021-09-16 00:00:00',NULL,'461',1287475.00,1287475.00,'461','2021-09-16 13:26:59','533','2021-09-17 09:57:54',10,0),('1','116',225103,'AFTERNOON SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'461',1703375.92,1703375.92,'461','2021-09-17 10:09:30','533','2021-09-17 12:24:07',10,0),('1','116',225152,'MORNING SHIFT ','2021-09-17','2021-09-17 00:00:00',NULL,'461',1170980.49,1170980.49,'461','2021-09-17 13:52:53','533','2021-09-17 14:15:13',10,0),('1','116',225340,'AFTERNOON SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'461',1766530.61,1766530.61,'461','2021-09-18 10:24:25','533','2021-09-18 14:26:08',10,0),('1','116',225413,'MORNING SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'461',1127121.59,1127121.59,'461','2021-09-18 14:43:07','533','2021-09-18 19:50:40',10,0),('1','116',225561,'AFTERNOON SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'461',1789563.21,1789563.21,'461','2021-09-19 11:08:19','533','2021-09-19 13:20:39',10,0),('1','116',225608,'MORNING SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'461',935546.65,935546.65,'461','2021-09-19 14:20:06','533','2021-09-20 10:09:55',10,0),('1','116',225802,'AFTERNOON SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'461',1275305.48,1275305.48,'461','2021-09-20 10:27:16','454','2021-09-20 11:35:53',10,0),('1','116',225847,'MORNING SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'461',1083870.13,1083870.13,'461','2021-09-20 13:43:18','533','2021-09-21 08:34:23',10,0),('1','116',226055,'AFTERNOON SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'461',1858741.29,1858741.29,'461','2021-09-21 10:03:14','454','2021-09-21 14:07:03',10,0),('1','116',226138,'MORNING SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'461',1192640.29,1192640.29,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',226141,'MORNING SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'461',1193140.29,1193140.29,'461','2021-09-21 14:27:43','533','2021-09-21 16:53:09',10,0),('1','116',226282,'AFTERNOON SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'461',1739304.63,1739304.63,'461','2021-09-22 09:46:17','533','2021-09-22 10:12:35',10,0),('1','116',226372,'MORNING SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'461',1194314.04,1194314.04,'461','2021-09-22 13:24:35','533','2021-09-22 16:19:38',10,0),('1','116',226554,'AFTERNOON SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'461',1561374.38,1561374.38,'461','2021-09-23 10:12:55','533','2021-09-23 11:38:07',10,0),('1','116',226627,'MORNING SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'461',1089896.24,1089896.24,'461','2021-09-23 13:35:13','533','2021-09-23 14:09:17',10,0),('1','116',226814,'AFTERNOON SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'461',1717940.13,1717940.13,'461','2021-09-24 09:55:46','533','2021-09-24 10:14:06',10,0),('1','116',226881,'MORNING SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'461',1210307.60,1210307.60,'461','2021-09-24 14:24:24','454','2021-09-24 21:13:08',10,0),('1','116',227051,'AFTERNOON SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'461',1801456.44,1801456.44,'461','2021-09-25 11:37:21','533','2021-09-25 13:41:07',10,0),('1','116',227141,'MORNING SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'461',993512.71,993512.71,'461','2021-09-25 16:43:14','533','2021-09-26 10:58:35',10,0),('1','116',227261,'AFTERNOON SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'461',1609910.25,1609910.25,'461','2021-09-26 11:37:10','533','2021-09-26 15:00:35',10,0),('1','116',227313,'MORNING SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'461',1063068.07,1063068.07,'461','2021-09-26 15:09:57','533','2021-09-26 16:11:21',10,0),('1','116',227465,'AFTERNOON SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'461',1213005.25,1213005.25,'461','2021-09-27 10:11:27','533','2021-09-27 11:45:49',10,0),('1','116',227497,'MORNING SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'461',1068963.78,1068963.78,'461','2021-09-27 13:36:14','454','2021-09-27 13:54:44',10,0),('1','116',227634,'AFTERNOON SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'461',606583.31,606583.31,'461','2021-09-28 07:46:50','533','2021-09-28 13:24:05',10,0),('1','116',228243,'MORNING SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'461',481123.84,481123.84,'461','2021-09-30 13:43:49','533','2021-10-01 10:20:06',10,0),('1','116',228620,'MORNING SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'461',486628.35,486628.35,'461','2021-10-02 13:27:17','533','2021-10-03 12:22:28',10,0),('1','116',228835,'AFTERNOON SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'461',1481280.43,1481280.43,'461','2021-10-03 12:31:29','533','2021-10-03 12:44:36',10,0),('1','116',228841,'MORNING SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'461',1070349.28,1070349.28,'461','2021-10-03 13:20:18','533','2021-10-03 18:27:57',10,0),('1','116',228989,'AFTERNOON SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'461',1341198.74,1341198.74,'461','2021-10-04 09:01:28','533','2021-10-04 09:54:22',10,0),('1','116',229073,'MORNING SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'461',1190410.61,1190410.61,'461','2021-10-04 14:26:50','533','2021-10-04 19:07:36',10,0),('1','116',229233,'AFTERNOON SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'461',1889012.49,1889012.49,'461','2021-10-05 10:03:47','454','2021-10-05 13:20:40',10,0),('1','116',229298,'MORNING SHIFT ','2021-10-05','2021-10-05 00:00:00',NULL,'461',1566183.26,1566183.26,'461','2021-10-05 13:46:58','533','2021-10-05 18:17:16',10,0),('1','116',229500,'AFTERNOON SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'461',1833427.26,1833427.26,'461','2021-10-06 10:35:52','533','2021-10-06 13:42:49',10,0),('1','116',229584,'MORNING SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'461',1585401.56,1585401.56,'461','2021-10-06 14:14:52','454','2021-10-07 09:16:47',10,0),('1','116',229714,'AFTERNOON SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'461',1848837.86,1848837.86,'461','2021-10-07 09:33:49','454','2021-10-07 10:21:26',10,0),('1','116',229773,'MORNING SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'461',1359587.97,1359587.97,'461','2021-10-07 13:20:50','533','2021-10-07 14:05:15',10,0),('1','116',229954,'AFTERNOON SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'461',2341101.75,2341101.75,'461','2021-10-08 10:33:55','533','2021-10-08 13:34:13',10,0),('1','116',229996,'AFTERNOON SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'461',1456632.73,1456632.73,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',230002,'MORNING SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'461',1456632.73,1456632.73,'461','2021-10-08 13:58:08','533','2021-10-09 09:46:56',10,0),('1','116',230160,'AFTERNOON SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'461',2102410.49,2102410.49,'461','2021-10-09 10:43:00','533','2021-10-09 13:09:28',10,0),('1','116',230208,'MORNING SHIFT ','2021-10-09','2021-10-09 00:00:00',NULL,'461',1237982.94,1237982.94,'461','2021-10-09 13:17:16','533','2021-10-10 08:01:30',10,0),('1','116',230386,'AFTERNOON SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'461',1722927.91,1722927.91,'461','2021-10-10 11:50:15','533','2021-10-10 14:12:23',10,0),('1','116',230442,'MORNING SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'461',1040535.12,1040535.12,'461','2021-10-10 14:29:56','533','2021-10-11 09:08:24',10,0),('1','116',230580,'AFTERNOON SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'461',1530111.34,1530111.34,'461','2021-10-11 09:35:01','533','2021-10-11 12:21:16',10,0),('1','116',230656,'MORNING SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'461',1187283.19,1187283.19,'461','2021-10-11 13:48:12','533','2021-10-11 14:35:55',10,0),('1','116',230746,'AFTERNOON SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'461',1305462.97,1305462.97,'461','2021-10-11 19:59:00','533','2021-10-12 10:54:18',10,0),('1','116',231013,'MORNING SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'461',1072081.76,1072081.76,'461','2021-10-12 16:12:50','533','2021-10-13 09:21:06',10,0),('1','116',231136,'AFTERNOON SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'461',1086335.35,1086335.35,'461','2021-10-13 09:59:36','533','2021-10-13 10:56:50',10,0),('1','116',231557,'MORNING SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'461',1551291.78,1551291.78,'461','2021-10-14 15:00:58','533','2021-10-14 16:15:32',10,0),('1','116',231712,'AFTERNOON SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'461',1710981.53,1710981.53,'461','2021-10-15 09:59:05','533','2021-10-15 10:00:13',10,0),('1','116',231789,'MORNING SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'461',1290259.36,1290259.36,'461','2021-10-15 13:43:15','454','2021-10-15 14:39:38',10,0),('1','116',231980,'AFTERNOON SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'461',1884425.03,1884425.03,'461','2021-10-16 11:48:10','533','2021-10-16 12:17:41',10,0),('1','116',232001,'MORNING SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'461',1217531.03,1217531.03,'461','2021-10-16 13:19:45','533','2021-10-16 13:58:39',10,0),('1','116',232182,'AFTERNOON SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'461',1907359.00,1907359.00,'461','2021-10-17 10:59:01','533','2021-10-17 11:12:49',10,0),('1','116',232216,'MORNING SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'461',903000.43,903000.43,'461','2021-10-17 13:15:23','533','2021-10-17 21:13:00',10,0),('1','116',232389,'AFTERNOON SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'461',1227682.97,1227682.97,'461','2021-10-18 09:14:19','454','2021-10-18 09:21:45',10,0),('1','116',232469,'MORNING SHIFT ','2021-10-18','2021-10-18 00:00:00',NULL,'461',991667.03,991667.03,'461','2021-10-18 13:20:07','533','2021-10-18 13:42:07',10,0),('1','116',232685,'AFTERNOON SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'461',1708973.82,1708973.82,'461','2021-10-19 10:45:12','454','2021-10-19 13:57:22',10,0),('1','116',232732,'MORNING SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'461',1013016.15,1013016.15,'461','2021-10-19 14:10:49','533','2021-10-19 14:58:26',10,0),('1','116',232942,'AFTERNOON SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'461',1409065.29,1409065.29,'461','2021-10-20 10:17:22','533','2021-10-20 10:19:45',10,0),('1','116',232959,'MORNING SHIFT ','2021-10-20','2021-10-20 00:00:00',NULL,'461',1099428.48,1099428.48,'461','2021-10-20 13:38:14','533','2021-10-20 15:22:40',10,0),('1','116',233158,'AFTERNOON SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'461',1687196.70,1687196.70,'461','2021-10-21 08:29:23','533','2021-10-21 08:34:27',10,0),('1','116',233253,'MORNING SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'461',1047855.28,1047855.28,'461','2021-10-21 13:06:35','533','2021-10-21 14:09:50',10,0),('1','116',233385,'AFTERNOON SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'461',1630893.24,1630893.24,'461','2021-10-22 08:42:40','533','2021-10-22 10:08:43',10,0),('1','116',233504,'MORNING SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'461',1127440.03,1127440.03,'461','2021-10-22 14:08:18','533','2021-10-22 17:45:12',10,0),('1','116',233628,'AFTERNOON SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'461',1560664.69,1560664.69,'461','2021-10-23 07:15:52','533','2021-10-23 07:25:08',10,0),('1','116',233638,'MORNING SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'461',1025519.39,1025519.39,'461','2021-10-23 13:27:13','533','2021-10-23 14:33:39',10,0),('1','116',233869,'AFTERNOON SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'461',1386621.11,1386621.11,'461','2021-10-24 07:29:41','533','2021-10-24 09:04:57',10,0),('1','116',233916,'MORNING SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'461',903352.52,903352.52,'461','2021-10-24 13:21:07','533','2021-10-24 13:40:14',10,0),('1','116',234107,'AFTERNOON SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'461',1063027.32,1063027.32,'461','2021-10-25 08:20:13','454','2021-10-25 08:47:58',10,0),('1','116',234175,'MORNING SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'461',4512056.58,4512056.58,'461','2021-10-25 13:21:34','533','2021-10-25 14:53:33',10,0),('1','116',234370,'AFTERNOON SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'461',2535344.02,2535344.02,'461','2021-10-26 10:18:39','533','2021-10-26 13:13:37',10,0),('1','116',234463,'MORNING SHIFT ','2021-10-26','2021-10-26 00:00:00',NULL,'461',1133149.92,1133149.92,'461','2021-10-26 13:21:08','533','2021-10-26 14:36:04',10,0),('1','116',234654,'AFTERNOON SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'461',1580331.69,1580331.69,'461','2021-10-27 09:54:05','533','2021-10-27 10:49:25',10,0),('1','116',234725,'MORNING SHIFT ','2021-10-27','2021-10-27 00:00:00',NULL,'461',993308.96,993308.96,'461','2021-10-27 13:44:40','533','2021-10-27 15:53:28',10,0),('1','116',234777,'AFTERNOON SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'461',1533104.65,1533104.65,'461','2021-10-27 20:09:06','533','2021-10-28 06:21:16',10,0),('1','116',234955,'MORNING SHIFT ','2021-10-28','2021-10-28 00:00:00',NULL,'461',559547.13,559547.13,'461','2021-10-28 12:29:28','533','2021-10-28 14:23:38',10,0),('1','116',235159,'MORNING SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'461',1401577.14,1401577.14,'461','2021-10-29 14:11:11','533','2021-10-29 15:22:11',10,0),('1','116',235329,'AFTERNOON SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'461',1930876.81,1930876.81,'461','2021-10-30 07:25:56','533','2021-10-30 07:56:33',10,0),('1','116',235409,'MORNING SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'461',1173930.89,1173930.89,'461','2021-10-30 13:04:20','533','2021-10-30 14:54:04',10,0),('1','116',235562,'AFTERNOON SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'461',1349476.50,1349476.50,'461','2021-10-31 07:30:10','533','2021-10-31 13:36:20',10,0),('1','116',235655,'MORNING SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'461',1078178.17,1078178.17,'461','2021-10-31 13:55:03','533','2021-10-31 14:44:22',10,0),('1','116',235768,'AFTERNOON SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'461',1264728.90,1264728.90,'461','2021-11-01 06:47:21','533','2021-11-01 07:01:08',10,0),('1','116',235821,'MORNING SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'461',1140916.87,1140916.87,'461','2021-11-01 13:02:11','533','2021-11-01 16:06:02',10,0),('1','116',236034,'AFTERNOON SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'461',1678896.45,1678896.45,'461','2021-11-02 06:28:11','533','2021-11-02 07:53:12',10,0),('1','116',236122,'MORNING SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'461',1257614.25,1257614.25,'461','2021-11-02 13:21:18','533','2021-11-02 14:38:41',10,0),('1','116',236197,'AFTERNOON SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'461',263480.25,263480.25,'461','2021-11-02 19:03:17','533','2021-11-03 09:29:10',10,0),('1','116',236329,'MORNING SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'461',1385743.65,1385743.65,'461','2021-11-03 13:33:50','533','2021-11-03 17:21:45',10,0),('1','116',236527,'AFTERNOON SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'461',3505125.15,3505125.15,'461','2021-11-04 06:46:28','533','2021-11-04 07:27:03',10,0),('1','116',236652,'MORNING SHIFT ','2021-11-04','2021-11-04 00:00:00',NULL,'461',1439099.70,1439099.70,'461','2021-11-04 13:57:57','533','2021-11-04 14:36:48',10,0),('1','116',236692,'AFTERNOON SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'461',1620733.95,1620733.95,'461','2021-11-04 19:10:55','533','2021-11-05 08:18:16',10,0),('1','116',236839,'AFTERNOON SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'461',390155.70,390155.70,'461','2021-11-05 11:34:36','533','2021-11-05 15:57:31',10,0),('1','116',236901,'MORNING SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'461',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','116',237351,'AFTERNOON SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'461',1382362.80,1382362.80,'461','2021-11-07 21:40:32','533','2021-11-07 21:44:14',10,0),('1','116',237441,'MORNING SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'461',1817176.35,1817176.35,'461','2021-11-08 13:19:52','533','2021-11-08 15:40:29',10,0),('1','116',237553,'AFTERNOON SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'461',1906672.35,1906672.35,'461','2021-11-08 18:34:42','533','2021-11-08 18:42:28',10,0),('1','116',237745,'MORNING SHIFT ','2021-11-09','2021-11-09 00:00:00',NULL,'461',2284152.30,2284152.30,'461','2021-11-09 13:43:08','533','2021-11-09 14:52:44',10,0),('1','116',237794,'AFTERNOON SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'461',1444249.95,1444249.95,'461','2021-11-09 17:16:40','533','2021-11-10 07:50:46',10,0),('1','116',237977,'MORNING SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'461',648961.50,648961.50,'461','2021-11-10 13:20:41','533','2021-11-10 17:29:46',10,0),('1','116',238060,'AFTERNOON SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'461',1397818.95,1397818.95,'461','2021-11-10 17:39:11','533','2021-11-11 06:29:46',10,0),('1','116',238221,'MORNING SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'461',632141.10,632141.10,'461','2021-11-11 12:50:25','533','2021-11-11 13:59:36',10,0),('1','116',238296,'AFTERNOON SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'461',1059295.05,1059295.05,'461','2021-11-11 17:31:20','454','2021-11-11 22:29:48',10,0),('1','116',238497,'MORNING SHIFT ','2021-11-12','2021-11-12 00:00:00',NULL,'461',1285977.00,1285977.00,'461','2021-11-12 13:43:47','533','2021-11-12 15:42:11',10,0),('1','116',238558,'AFTERNOON SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'461',2617635.15,2617635.15,'461','2021-11-12 20:42:10','533','2021-11-13 08:16:35',10,0),('1','116',238720,'MORNING SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'461',1923517.80,1923517.80,'461','2021-11-13 13:08:53','533','2021-11-13 13:16:13',10,0),('1','116',238740,'AFTERNOON SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'461',1468392.75,1468392.75,'461','2021-11-13 18:23:07','533','2021-11-13 18:25:52',10,0),('1','116',238942,'MORNING SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'461',1710274.50,1710274.50,'461','2021-11-14 13:41:59','533','2021-11-14 17:56:54',10,0),('1','116',238990,'AFTERNOON SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'461',497475.00,497475.00,'461','2021-11-14 18:00:07','533','2021-11-14 18:02:51',10,0),('1','116',239185,'MORNING SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'461',426162.00,426162.00,'461','2021-11-15 12:53:58','533','2021-11-15 14:20:40',10,0),('1','116',239318,'AFTERNOON SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'461',1408989.45,1408989.45,'461','2021-11-16 07:13:50','533','2021-11-16 08:51:52',10,0),('1','116',239403,'MORNING SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'461',1309862.40,1309862.40,'461','2021-11-16 13:34:13','533','2021-11-16 14:17:26',10,0),('1','116',239546,'AFTERNOON SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'461',1379437.95,1379437.95,'461','2021-11-17 06:52:56','533','2021-11-17 07:23:52',10,0),('1','116',239653,'MORNING SHIFT ','2021-11-17','2021-11-17 00:00:00',NULL,'461',1139247.45,1139247.45,'461','2021-11-17 13:09:45','533','2021-11-17 14:01:35',10,0),('1','116',239790,'AFTERNOON SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'461',1631680.05,1631680.05,'461','2021-11-18 06:39:34','454','2021-11-18 09:01:03',10,0),('1','116',239891,'MORNING SHIFT ','2021-11-18','2021-11-18 00:00:00',NULL,'461',1134691.80,1134691.80,'461','2021-11-18 13:12:22','533','2021-11-18 14:05:56',10,0),('1','116',240001,'AFTERNOON SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'461',1717749.00,1717749.00,'461','2021-11-19 06:38:38','533','2021-11-19 07:55:20',10,0),('1','116',240096,'MORNING SHIFT ','2021-11-19','2021-11-19 00:00:00',NULL,'461',1644233.25,1644233.25,'461','2021-11-19 13:25:05','533','2021-11-19 15:36:41',10,0),('1','116',240217,'AFTERNOON SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'461',1729178.55,1729178.55,'461','2021-11-20 07:04:21','533','2021-11-20 08:59:08',10,0),('1','116',240300,'MORNING SHIFT ','2021-11-20','2021-11-20 00:00:00',NULL,'461',1139498.25,1139498.25,'461','2021-11-20 12:54:53','533','2021-11-20 14:00:43',10,0),('1','116',240418,'AFTERNOON SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'461',1407832.80,1407832.80,'461','2021-11-20 21:07:31','533','2021-11-21 08:54:28',10,0),('1','116',240563,'MORNING SHIFT ','2021-11-21','2021-11-21 00:00:00',NULL,'461',1208032.65,1208032.65,'461','2021-11-21 13:21:08','533','2021-11-21 14:42:54',10,0),('1','116',240619,'AFTERNOON SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'461',1079799.60,1079799.60,'461','2021-11-21 20:00:31','533','2021-11-21 20:27:40',10,0),('1','116',240809,'MORNING SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'461',1476192.30,1476192.30,'461','2021-11-22 13:18:35','533','2021-11-22 14:34:07',10,0),('1','116',240892,'AFTERNOON SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'461',974775.45,974775.45,'461','2021-11-22 17:57:13','533','2021-11-22 20:09:30',10,0),('1','116',241116,'MORNING SHIFT ','2021-11-23','2021-11-23 00:00:00',NULL,'461',1430625.90,1430625.90,'461','2021-11-23 13:27:29','533','2021-11-23 13:49:42',10,0),('1','116',241139,'AFTERNOON SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'461',1746465.60,1746465.60,'461','2021-11-23 21:20:41','533','2021-11-24 10:23:11',10,0),('1','116',241349,'MORNING SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'461',1455088.80,1455088.80,'461','2021-11-24 13:16:22','533','2021-11-24 13:21:06',10,0),('1','116',241447,'AFTERNOON SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'461',1909668.75,1909668.75,'461','2021-11-24 21:14:06','533','2021-11-25 09:45:37',10,0),('1','116',241614,'MORNING SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'461',1631759.25,1631759.25,'461','2021-11-25 13:25:01','533','2021-11-25 15:12:07',10,0),('1','116',241665,'AFTERNOON SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'461',874546.20,874546.20,'461','2021-11-25 17:34:16','533','2021-11-26 08:27:48',10,0),('1','116',241851,'MORNING SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'461',1719512.85,1719512.85,'461','2021-11-26 13:08:27','533','2021-11-26 14:10:39',10,0),('1','116',241910,'AFTERNOON SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'461',474564.75,474564.75,'461','2021-11-26 19:10:58','533','2021-11-27 08:03:11',10,0),('1','116',242063,'MORNING SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'461',1585057.65,1585057.65,'461','2021-11-27 13:05:45','533','2021-11-27 16:27:30',10,0),('1','116',242166,'AFTERNOON SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'461',1831891.05,1831891.05,'461','2021-11-27 20:58:49','533','2021-11-28 10:48:39',10,0),('1','116',242289,'MORNING SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'461',1322663.10,1322663.10,'461','2021-11-28 13:22:43','533','2021-11-28 19:59:43',10,0),('1','116',242378,'AFTERNOON SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'461',1366998.60,1366998.60,'461','2021-11-28 20:27:04','533','2021-11-29 07:24:05',10,0),('1','116',242562,'MORNING SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'461',978626.55,978626.55,'461','2021-11-29 12:58:44','533','2021-11-29 14:36:12',10,0),('1','116',242869,'AFTERNOON SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'461',1048127.85,1048127.85,'461','2021-11-30 21:27:17','533','2021-12-01 07:20:01',10,0),('1','116',243035,'MORNING SHIFT ','2021-12-01','2021-12-01 00:00:00',NULL,'461',1929122.55,1929122.55,'461','2021-12-01 13:31:21','533','2021-12-01 14:50:07',10,0),('1','116',243099,'AFTERNOON SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'461',2605094.40,2605094.40,'461','2021-12-01 21:07:40','533','2021-12-02 08:38:19',10,0),('1','116',243261,'MORNING SHIFT ','2021-12-02','2021-12-02 00:00:00',NULL,'461',2074953.45,2074953.45,'461','2021-12-02 13:22:16','533','2021-12-02 13:26:00',10,0),('1','116',243319,'AFTERNOON SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'461',2313883.05,2313883.05,'461','2021-12-02 20:09:11','533','2021-12-03 07:49:47',10,0),('1','116',243462,'MORNING SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'461',2321614.20,2321614.20,'461','2021-12-03 13:08:52','533','2021-12-03 14:02:34',10,0),('1','116',243538,'AFTERNOON SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'461',845422.95,845422.95,'461','2021-12-03 18:08:35','533','2021-12-04 11:58:40',10,0),('1','116',243708,'MORNING SHIFT ','2021-12-04','2021-12-04 00:00:00',NULL,'461',781194.15,781194.15,'461','2021-12-04 13:30:01','533','2021-12-04 17:39:20',10,0),('1','116',243795,'AFTERNOON SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'461',3737902.20,3737902.20,'461','2021-12-04 21:09:00','533','2021-12-05 09:44:00',10,0),('1','116',243922,'MORNING SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'461',978341.10,978341.10,'461','2021-12-05 13:03:20','533','2021-12-05 14:15:31',10,0),('1','116',244674,'AFTERNOON SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'461',1807212.75,1807212.75,'461','2021-12-08 21:22:22','533','2021-12-09 09:40:32',10,0),('1','116',244857,'MORNING SHIFT ','2021-12-09','2021-12-09 00:00:00',NULL,'461',1812758.85,1812758.85,'461','2021-12-09 13:19:46','533','2021-12-09 14:48:58',10,0),('1','116',245030,'AFTERNOON','2021-12-09','2021-12-09 00:00:00',NULL,'461',2168778.30,2168778.30,'461','2021-12-10 08:25:41','454','2021-12-10 09:49:26',10,0),('1','116',245234,'MORNING SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'461',1415044.20,1415044.20,'461','2021-12-11 07:43:37','533','2021-12-11 07:59:34',10,0),('1','116',245274,'AFTERNOON SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'461',2038201.50,2038201.50,'461','2021-12-11 09:17:54','533','2021-12-11 10:08:50',10,0),('1','116',245336,'MORNING SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'461',1416366.75,1416366.75,'461','2021-12-11 14:03:57','533','2021-12-11 15:06:45',10,0),('1','116',245395,'AFTERNOON SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'461',1569604.80,1569604.80,'461','2021-12-12 07:00:19','533','2021-12-12 12:44:40',10,0),('1','116',245549,'MORNING SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'461',1041846.75,1041846.75,'461','2021-12-12 13:31:56','533','2021-12-12 14:54:41',10,0),('1','116',245647,'AFTERNOON SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'461',1461328.65,1461328.65,'461','2021-12-12 21:20:44','533','2021-12-13 00:08:06',10,0),('1','116',245792,'MORNING SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'461',1347637.80,1347637.80,'461','2021-12-13 13:05:27','533','2021-12-13 15:18:31',10,0),('1','116',245903,'AFTERNOON SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'461',2057998.35,2057998.35,'461','2021-12-13 21:17:36','533','2021-12-14 08:53:39',10,0),('1','116',246063,'MORNING SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'461',1328895.90,1328895.90,'461','2021-12-14 13:18:27','533','2021-12-14 15:35:31',10,0),('1','116',246159,'AFTERNOON SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'461',2084960.25,2084960.25,'461','2021-12-14 21:15:02','533','2021-12-15 13:12:11',10,0),('1','116',246338,'MORNING SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'461',1456871.10,1456871.10,'461','2021-12-15 13:20:46','533','2021-12-15 14:57:15',10,0),('1','116',246399,'AFTERNOON SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'461',1841545.95,1841545.95,'461','2021-12-15 18:59:44','533','2021-12-16 08:34:37',10,0),('1','116',246569,'MORNING SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'461',753025.35,753025.35,'461','2021-12-16 13:08:33','533','2021-12-16 16:08:06',10,0),('1','116',246809,'MORNING SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'461',2061968.70,2061968.70,'461','2021-12-17 13:37:30','533','2021-12-17 14:44:45',10,0),('1','116',246900,'AFTERNOON SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'461',3938522.10,3938522.10,'461','2021-12-17 21:17:01','533','2021-12-18 08:07:31',10,0),('1','116',247068,'MORNING SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'461',2021230.95,2021230.95,'461','2021-12-18 13:40:49','533','2021-12-18 15:45:30',10,0),('1','116',247121,'AFTERNOON SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'461',1858001.40,1858001.40,'461','2021-12-18 19:15:43','533','2021-12-19 09:08:02',10,0),('1','116',247289,'MORNING SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'461',1676574.90,1676574.90,'461','2021-12-19 13:17:49','533','2021-12-19 15:53:55',10,0),('1','116',247348,'AFTERNOON SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'461',1924748.55,1924748.55,'461','2021-12-19 19:05:36','533','2021-12-20 12:38:37',10,0),('1','116',247544,'MORNING SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'461',1757673.60,1757673.60,'461','2021-12-20 13:26:23','533','2021-12-20 16:27:32',10,0),('1','116',247590,'AFTERNOON SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'461',937602.30,937602.30,'461','2021-12-20 16:30:35','533','2021-12-20 17:54:22',10,0),('1','116',247796,'MORNING SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'461',829462.50,829462.50,'461','2021-12-21 13:41:50','533','2021-12-21 15:33:16',10,0),('1','116',248042,'MORNING SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'461',513033.60,513033.60,'461','2021-12-22 13:34:12','533','2021-12-22 15:14:48',10,0),('1','116',248113,'AFTERNOON SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'461',2747245.35,2747245.35,'461','2021-12-22 21:05:57','533','2021-12-23 07:15:27',10,0),('1','116',248288,'MORNING SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'461',2156954.10,2156954.10,'461','2021-12-23 14:03:17','533','2021-12-23 18:54:05',10,0),('1','116',248353,'AFTERNOON SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'461',2164483.50,2164483.50,'461','2021-12-23 19:40:12','533','2021-12-24 09:43:50',10,0),('1','116',248495,'MORNING SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'461',1999855.65,1999855.65,'461','2021-12-24 13:46:18','533','2021-12-24 14:51:37',10,0),('1','116',248561,'AFTERNOON SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'461',1190988.15,1190988.15,'461','2021-12-24 17:18:30','533','2021-12-25 09:11:27',10,0),('1','116',249758,'MORNING SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'461',1660284.00,1660284.00,'461','2021-12-29 14:38:35','533','2021-12-29 15:07:23',10,0),('1','116',249814,'AFTERNOON SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'461',1868889.00,1868889.00,'461','2021-12-29 21:00:43','533','2021-12-30 10:48:46',10,0),('1','116',249951,'MORNING SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'461',633515.85,633515.85,'461','2021-12-30 12:54:45','533','2021-12-30 13:21:42',10,0),('1','116',250068,'AFTERNOON SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'461',1034858.55,1034858.55,'461','2021-12-30 21:23:59','533','2021-12-31 07:24:10',10,0),('1','116',250214,'MORNING SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'461',1427248.35,1427248.35,'461','2021-12-31 12:25:58','533','2021-12-31 17:51:19',10,0),('1','116',250310,'AFTERNOON SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'461',3398934.30,3398934.30,'461','2021-12-31 22:20:44','454','2022-01-01 10:19:48',10,0),('1','116',250487,'MORNING SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'461',1014819.30,1014819.30,'461','2022-01-01 14:51:19','533','2022-01-01 16:28:27',10,0),('1','116',250535,'AFTERNOON SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'461',1222448.85,1222448.85,'461','2022-01-01 21:15:32','533','2022-01-02 08:07:15',10,0),('1','116',250733,'MORNING SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'461',1002272.70,1002272.70,'461','2022-01-02 16:42:19','533','2022-01-03 07:53:29',10,0),('1','116',250882,'AFTERNOON SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'461',659397.45,659397.45,'461','2022-01-03 11:55:16','533','2022-01-03 15:17:25',10,0),('1','116',251168,'MORNING SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'461',1253155.35,1253155.35,'461','2022-01-04 14:15:19','533','2022-01-05 10:52:37',10,0),('1','116',251367,'AFTERNOON SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'461',1833487.80,1833487.80,'461','2022-01-05 11:58:30','533','2022-01-05 14:03:06',10,0),('1','116',251402,'MORNING SHIFT ','2022-01-05','2022-01-05 00:00:00',NULL,'461',1214082.90,1214082.90,'461','2022-01-05 14:41:43','533','2022-01-05 15:17:23',10,0),('1','116',251421,'AFTERNOON SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'461',1983571.35,1983571.35,'461','2022-01-05 22:42:18','533','2022-01-06 10:18:39',10,0),('1','116',251650,'MORNING SHIFT ','2022-01-06','2022-01-06 00:00:00',NULL,'461',1190404.05,1190404.05,'461','2022-01-06 14:26:37','533','2022-01-06 14:59:25',10,0),('1','116',251730,'AFTERNOON SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'461',1941803.10,1941803.10,'461','2022-01-06 22:25:03','454','2022-01-07 10:27:23',10,0),('1','116',251884,'MORNING SHIFT ','2022-01-07','2022-01-07 00:00:00',NULL,'461',1035591.15,1035591.15,'461','2022-01-07 15:44:12','533','2022-01-07 17:26:08',10,0),('1','116',251943,'AFTERNOON SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'461',1472248.20,1472248.20,'461','2022-01-07 20:53:34','533','2022-01-08 08:56:36',10,0),('1','116',252168,'MORNING SHIFT ','2022-01-08','2022-01-08 00:00:00',NULL,'461',1301562.00,1301562.00,'461','2022-01-08 17:40:39','533','2022-01-09 10:44:24',10,0),('1','116',252407,'AFTERNOON SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'461',1257533.85,1257533.85,'461','2022-01-09 19:06:50','533','2022-01-09 19:18:23',10,0),('1','116',252410,'MORNING SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'461',1073794.05,1073794.05,'461','2022-01-09 19:22:35','533','2022-01-09 21:14:08',10,0),('1','116',252444,'AFTERNOON SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'461',1401299.85,1401299.85,'461','2022-01-09 22:10:54','533','2022-01-10 12:13:20',10,0),('1','116',252612,'MORNING SHIFT ','2022-01-10','2022-01-10 00:00:00',NULL,'461',1170764.70,1170764.70,'461','2022-01-10 14:23:48','533','2022-01-10 16:40:53',10,0),('1','116',252679,'AFTERNOON SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'461',1648447.20,1648447.20,'461','2022-01-10 22:11:31','533','2022-01-11 11:40:15',10,0),('1','116',252846,'MORNING SHIFT ','2022-01-11','2022-01-11 00:00:00',NULL,'461',1256303.40,1256303.40,'461','2022-01-11 14:33:19','533','2022-01-11 18:17:25',10,0),('1','116',252943,'AFTERNOON SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'461',1997442.15,1997442.15,'461','2022-01-11 22:39:08','533','2022-01-12 11:38:53',10,0),('1','116',253099,'MORNING SHIFT ','2022-01-12','2022-01-12 00:00:00',NULL,'461',1401467.25,1401467.25,'461','2022-01-12 15:20:04','533','2022-01-12 16:20:05',10,0),('1','116',253171,'AFTERNOON SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'461',1604792.10,1604792.10,'461','2022-01-12 21:35:47','454','2022-01-13 11:37:37',10,0),('1','116',253366,'MORNING SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'461',681864.90,681864.90,'461','2022-01-13 15:28:47','533','2022-01-13 16:13:22',10,0),('1','116',253584,'MORNING SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'461',560280.60,560280.60,'461','2022-01-14 15:11:44','533','2022-01-14 20:07:01',10,0),('1','116',253683,'AFTERNOON SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'461',1785852.60,1785852.60,'461','2022-01-14 22:17:19','533','2022-01-15 13:15:32',10,0),('1','116',253831,'MORNING SHIFT ','2022-01-15','2022-01-15 00:00:00',NULL,'461',1029807.45,1029807.45,'461','2022-01-15 14:06:58','533','2022-01-15 15:05:45',10,0),('1','116',253894,'AFTERNOON SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'461',710173.50,710173.50,'461','2022-01-15 19:37:15','533','2022-01-16 10:08:46',10,0),('1','116',255083,'MORNING SHIFT ','2022-01-20','2022-01-20 00:00:00',NULL,'461',201573.05,201573.05,'461','2022-01-20 14:18:59','454','2022-01-20 15:28:16',10,0),('1','116',255128,'AFTERNOON SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'461',67048.80,67048.80,'461','2022-01-20 18:56:25','533','2022-01-20 20:13:41',10,0),('1','116',255603,'MORNING SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'461',1187661.00,1187661.00,'461','2022-01-22 14:57:42','533','2022-01-23 08:05:28',10,0),('1','116',255750,'AFTERNOON SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'461',1744797.40,1744797.40,'461','2022-01-23 09:36:16','533','2022-01-23 14:05:08',10,0),('1','116',255836,'MORNING SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'461',955942.90,955942.90,'461','2022-01-23 14:38:20','533','2022-01-24 09:28:00',10,0),('1','116',256027,'AFTERNOON SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'461',1157582.60,1157582.60,'461','2022-01-24 10:38:00','533','2022-01-24 11:13:49',10,0),('1','116',256090,'MORNING SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'461',348197.85,348197.85,'461','2022-01-24 14:28:49','533','2022-01-24 18:36:54',10,0),('1','116',256133,'AFTERNOON SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'461',587431.95,587431.95,'461','2022-01-24 19:19:48','454','2022-01-25 13:11:34',10,0),('1','116',256655,'AFTERNOON SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'461',43779.45,43779.45,'461','2022-01-26 18:35:37','533','2022-01-26 19:08:33',10,0),('1','116',256860,'MORNING SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'461',703125.10,703125.10,'461','2022-01-27 14:55:37','533','2022-01-28 07:09:17',10,0),('1','116',257019,'AFTERNOON SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'461',1748284.30,1748284.30,'461','2022-01-28 09:33:17','533','2022-01-28 12:24:53',10,0),('1','116',257119,'MORNING SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'461',1303264.20,1303264.20,'461','2022-01-28 15:20:52','533','2022-01-28 17:42:57',10,0),('1','116',257211,'AFTERNOON SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'461',2087594.85,2087594.85,'461','2022-01-28 22:31:40','533','2022-01-29 11:03:15',10,0),('1','116',257362,'MORNING SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'461',1238638.50,1238638.50,'461','2022-01-29 14:58:49','533','2022-01-29 15:09:28',10,0),('1','116',257519,'AFTERNOON SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'461',2389932.00,2389932.00,'461','2022-01-30 08:40:19','533','2022-01-30 12:46:42',10,0),('1','116',257612,'MORNING SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'461',793940.40,793940.40,'461','2022-01-30 14:01:24','533','2022-01-30 15:30:45',10,0),('1','116',257613,'AFTERNOON SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'461',1241193.00,1241193.00,'461','2022-01-31 09:47:39','533','2022-01-31 11:16:44',10,0),('1','116',257614,'MORNING SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'461',1024680.60,1024680.60,'461','2022-01-31 14:08:18','454','2022-02-01 10:38:16',10,0),('1','116',257615,'AFTERNOON SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'461',1703298.30,1703298.30,'461','2022-02-01 11:00:02','454','2022-02-01 14:15:20',10,0),('1','116',257616,'MORNING SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'461',1236501.00,1236501.00,'461','2022-02-01 14:52:25','533','2022-02-01 21:59:17',10,0),('1','116',257617,'AFTERNOON SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'461',1638595.20,1638595.20,'461','2022-02-02 08:21:57','533','2022-02-02 14:13:44',10,0),('1','116',257618,'MORNING SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'461',1063644.75,1063644.75,'461','2022-02-02 14:24:04','533','2022-02-02 15:53:42',10,0),('1','116',257619,'AFTERNOON SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'461',1350764.25,1350764.25,'461','2022-02-03 09:15:25','533','2022-02-03 10:34:49',10,0),('1','116',257620,'MORNING SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'461',1264465.95,1264465.95,'461','2022-02-03 14:21:11','533','2022-02-04 09:30:28',10,0),('1','116',257621,'AFTERNOON SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'461',394218.00,394218.00,'461','2022-02-04 09:58:20','533','2022-02-04 12:09:32',10,0),('1','116',257622,'MORNING SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'461',1048835.70,1048835.70,'461','2022-02-04 15:52:14','533','2022-02-04 18:14:17',10,0),('1','116',257623,'AFTERNOON SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'461',1556235.45,1556235.45,'461','2022-02-05 09:12:04','533','2022-02-05 12:32:36',10,0),('1','116',257624,'MORNING SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'461',947895.30,947895.30,'461','2022-02-05 14:13:04','533','2022-02-05 16:50:29',10,0),('1','116',257625,'AFTERNOON SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'461',1356432.00,1356432.00,'461','2022-02-06 08:45:12','533','2022-02-06 12:15:22',10,0),('1','116',257626,'MORNING SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'461',900200.40,900200.40,'461','2022-02-06 14:34:54','533','2022-02-06 14:55:56',10,0),('1','116',257627,'AFTERNOON SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'461',964738.50,964738.50,'461','2022-02-07 08:16:09','533','2022-02-07 11:14:11',10,0),('1','116',257628,'MORNING SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'461',1100766.15,1100766.15,'461','2022-02-07 14:02:42','533','2022-02-07 21:43:30',10,0),('1','116',257629,'AFTERNOON SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'461',243180.30,243180.30,'461','2022-02-08 11:16:22','533','2022-02-08 11:44:27',10,0),('1','116',257630,'MORNING SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'461',2284816.05,2284816.05,'461','2022-02-13 15:29:42','533','2022-02-13 15:31:23',10,0),('1','116',257631,'MORNING SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'461',992788.50,992788.50,'461','2022-02-14 14:34:09','533','2022-02-15 10:41:53',10,0),('1','116',257632,'MORNING SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'461',932784.60,932784.60,'461','2022-02-15 14:44:53','533','2022-02-16 07:19:01',10,0),('1','116',257633,'AFTERNOON SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'461',1652503.05,1652503.05,'461','2022-02-16 11:09:50','454','2022-02-16 11:19:50',10,0),('1','116',257634,'MORNING SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'461',1729186.00,1729186.00,'461','2022-02-16 15:37:42','533','2022-02-16 20:35:36',10,0),('1','116',257635,'AFTERNOON SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'461',1004105.35,1004105.35,'461','2022-02-17 10:27:30','533','2022-02-17 10:59:21',10,0),('1','116',257636,'MORNING SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'461',1471477.10,1471477.10,'461','2022-02-17 15:15:34','533','2022-02-17 17:00:40',10,0),('1','116',257637,'AFTERNOON SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'461',389101.90,389101.90,'461','2022-02-18 09:29:46','454','2022-02-18 10:34:34',10,0),('1','116',257638,'MORNING SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'461',687777.10,687777.10,'461','2022-02-18 17:07:16','533','2022-02-18 21:46:25',10,0),('1','116',257639,'AFTERNOON SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'461',1353973.70,1353973.70,'461','2022-02-19 10:30:52','454','2022-02-19 14:56:33',10,0),('1','116',257640,'MORNING SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'461',1700127.80,1700127.80,'461','2022-02-19 16:46:28','454','2022-02-20 12:39:56',10,0),('1','116',257641,'AFTERNOON SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'461',828859.75,828859.75,'461','2022-02-20 13:26:02','533','2022-02-20 20:11:54',10,0),('1','116',257642,'MORNING SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'461',1186474.10,1186474.10,'461','2022-02-20 22:17:54','533','2022-02-21 06:54:05',10,0),('1','116',257643,'AFTERNOON SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'461',1276255.20,1276255.20,'461','2022-02-21 10:41:30','454','2022-02-21 12:11:12',10,0),('1','116',257644,'MORNING SHIFT','2022-02-23','2022-02-23 14:52:48','2022-02-24 14:52:48','461',200889.95,200889.95,'461','2022-02-23 14:57:53','533','2022-02-23 17:32:37',10,0),('1','116',257645,'MORNING SHIFT','2022-02-25','2022-02-25 12:46:10','2022-02-26 12:46:10','461',550871.00,550871.00,'461','2022-02-25 12:49:14','533','2022-02-25 14:55:21',10,0),('1','116',257646,'MORNING SHIFT','2022-02-26','2022-02-26 13:02:16','2022-02-27 13:02:16','461',254934.50,254934.50,'461','2022-02-26 13:11:57','454','2022-02-26 14:34:52',10,0),('1','116',257647,'MORNING SHIFT','2022-03-01','2022-03-01 15:15:03','2022-03-02 15:15:03','461',2035798.50,2035798.50,'461','2022-03-01 15:51:06','761','2022-03-02 09:56:39',10,0),('1','116',257648,'AFTERNOON SHIFT','2022-03-01','2022-03-02 10:14:49','2022-03-03 10:14:49','461',616891.65,616891.65,'461','2022-03-02 10:26:33','533','2022-03-02 13:41:36',10,0),('1','116',257649,'MORNING SHIFT','2022-03-02','2022-03-02 14:34:34','2022-03-03 14:34:34','461',980921.40,980921.40,'461','2022-03-02 14:39:08','761','2022-03-02 16:28:52',10,0),('1','116',257650,'AFTERNOON SHIFT','2022-03-02','2022-03-03 12:42:33','2022-03-04 12:42:33','461',619344.90,619344.90,'461','2022-03-03 12:54:09','533','2022-03-03 14:55:02',10,0),('1','116',257651,'MORNING SHIFT','2022-03-03','2022-03-03 15:03:39','2022-03-04 15:03:39','461',860652.85,860652.85,'461','2022-03-03 15:15:32','761','2022-03-03 16:22:35',10,0),('1','116',257652,'AFTERNOON SHIFT','2022-03-03','2022-03-04 11:45:29','2022-03-05 11:45:29','461',832504.20,832504.20,'461','2022-03-04 11:59:09','533','2022-03-05 13:44:37',10,0),('1','116',257653,'AFTERNOON SHIFT','2022-03-04','2022-03-05 14:08:45','2022-03-06 14:08:45','461',1116164.05,1116164.05,'461','2022-03-05 14:17:18','533','2022-03-05 16:50:53',10,0),('1','116',257654,'MORNING SHIFT','2022-03-05','2022-03-05 16:55:28','2022-03-06 16:55:28','461',338150.05,338150.05,'461','2022-03-05 17:01:28','533','2022-03-06 10:05:04',10,0),('1','116',257655,'AFTERNOON SHIFT','2022-03-05','2022-03-06 12:05:15','2022-03-07 12:05:15','461',2523616.40,2523616.40,'461','2022-03-06 13:51:35','533','2022-03-06 14:45:55',10,0),('1','116',257656,'MORNING SHIFT','2022-03-06','2022-03-06 14:47:47','2022-03-07 14:47:47','461',952650.35,952650.35,'461','2022-03-06 14:52:38','533','2022-03-07 09:04:22',10,0),('1','116',257657,'AFTERNOON SHIFT','2022-03-06','2022-03-07 11:02:38','2022-03-08 11:02:38','461',1208455.15,1208455.15,'461','2022-03-07 11:18:30','761','2022-03-07 16:54:25',10,0),('1','116',257658,'MORNING SHIFT','2022-03-07','2022-03-07 18:49:24','2022-03-08 18:49:24','461',967670.80,967670.80,'461','2022-03-07 18:54:19','533','2022-03-07 23:00:39',10,0),('1','116',257659,'AFTERNOON SHIFT','2022-03-07','2022-03-08 11:36:38','2022-03-09 11:36:38','461',1335012.75,1335012.75,'461','2022-03-08 11:44:34','533','2022-03-08 12:10:53',10,0),('1','116',257660,'MORNING SHIFT','2022-03-08','2022-03-08 17:51:25','2022-03-09 17:51:25','461',2157188.25,2157188.25,'461','2022-03-08 18:26:08','533','2022-03-09 06:20:04',10,0),('1','116',257661,'AFTERNOON SHIFT','2022-03-08','2022-03-09 11:04:21','2022-03-10 11:04:21','461',1499879.70,1499879.70,'461','2022-03-09 11:15:58','533','2022-03-09 16:00:18',10,0),('1','116',257662,'MORNING SHIFT','2022-03-09','2022-03-09 17:46:07','2022-03-10 17:46:07','461',1370634.00,1370634.00,'461','2022-03-09 18:10:02','533','2022-03-10 07:35:21',10,0),('1','116',257663,'AFTERNOON SHIFT','2022-03-09','2022-03-10 09:46:33','2022-03-11 09:46:33','461',2199702.45,2199702.45,'461','2022-03-10 10:20:26','533','2022-03-10 14:33:19',10,0),('1','116',257664,'MORNING SHIFT','2022-03-10','2022-03-10 15:37:08','2022-03-11 15:37:08','461',1777757.85,1777757.85,'461','2022-03-10 15:43:45','761','2022-03-10 18:24:36',10,0),('1','116',257665,'AFTERNOON SHIFT','2022-03-10','2022-03-11 09:52:16','2022-03-12 09:52:16','461',2470309.05,2470309.05,'461','2022-03-11 10:18:44','761','2022-03-11 11:17:47',10,0),('1','116',257666,'MORNING SHIFT','2022-03-11','2022-03-11 16:07:48','2022-03-12 16:07:48','461',1425453.15,1425453.15,'461','2022-03-11 16:14:23','533','2022-03-11 17:18:03',10,0),('1','116',257667,'AFTERNOON SHIFT','2022-03-11','2022-03-12 12:24:03','2022-03-13 12:24:03','461',725076.00,725076.00,'461','2022-03-12 12:30:56','533','2022-03-12 16:40:56',10,0),('1','116',257668,'AFTERNOON SHIFT','2022-03-12','2022-03-13 11:53:55','2022-03-14 11:53:55','461',2594072.25,2594072.25,'461','2022-03-13 12:02:04','533','2022-03-13 14:40:34',10,0),('1','116',257669,'MORNING SHIFT','2022-03-13','2022-03-13 14:46:59','2022-03-14 14:46:59','461',1291611.75,1291611.75,'461','2022-03-13 14:53:12','533','2022-03-14 12:59:03',10,0),('1','116',257670,'AFTERNOON SHIFT','2022-03-13','2022-03-14 14:30:53','2022-03-15 14:30:53','461',1716080.85,1716080.85,'461','2022-03-14 14:58:06','761','2022-03-14 15:07:27',10,0),('1','116',257671,'MORNING SHIFT','2022-03-14','2022-03-14 15:21:58','2022-03-15 15:21:58','461',1080339.15,1080339.15,'461','2022-03-14 15:27:12','533','2022-03-14 16:44:21',10,0),('1','116',257672,'AFTERNOON SHIFT','2022-03-14','2022-03-15 10:12:36','2022-03-16 10:12:36','461',239093.25,239093.25,'461','2022-03-15 10:15:03','533','2022-03-15 11:44:19',10,0),('1','116',257673,'MORNING SHIFT','2022-03-16','2022-03-16 14:32:06','2022-03-17 14:32:06','461',184034.40,184034.40,'461','2022-03-16 14:39:16','533','2022-03-17 10:04:59',10,0),('1','116',257674,'AFTERNOON SHIFT','2022-03-16','2022-03-17 10:37:45','2022-03-18 10:37:45','461',1060474.80,1060474.80,'461','2022-03-17 11:04:29','533','2022-03-17 13:02:56',10,0),('1','116',257675,'MORNING SHIFT','2022-03-17','2022-03-17 14:53:28','2022-03-18 14:53:28','461',1513216.65,1513216.65,'461','2022-03-17 14:58:46','533','2022-03-17 20:31:42',10,0),('1','116',257676,'AFTERNOON SHIFT','2022-03-17','2022-03-18 09:08:29','2022-03-19 09:08:29','461',1295271.45,1295271.45,'461','2022-03-18 09:13:50','533','2022-03-18 12:44:20',10,0),('1','116',257677,'MORNING SHIFT','2022-03-18','2022-03-18 19:37:19','2022-03-19 19:37:19','461',1908510.45,1908510.45,'461','2022-03-18 19:40:05','533','2022-03-19 09:35:14',10,0),('1','116',257678,'AFTERNOON SHIFT','2022-03-18','2022-03-19 10:27:55','2022-03-20 10:27:55','461',1475385.45,1475385.45,'461','2022-03-19 10:34:41','533','2022-03-19 15:24:20',10,0),('1','116',257679,'MORNING SHIFT','2022-03-19','2022-03-19 15:27:26','2022-03-20 15:27:26','461',1123848.00,1123848.00,'461','2022-03-19 15:33:44','533','2022-03-19 17:49:30',10,0),('1','116',257680,'AFTERNOON SHIFT','2022-03-19','2022-03-20 09:43:27','2022-03-21 09:43:27','461',0.00,0.00,'461','2022-03-21 12:35:31','533','2022-03-21 12:38:06',10,0),('1','116',257681,'MORNING SHIFT','2022-03-21','2022-03-21 13:26:27','2022-03-28 13:26:27','461',995723.85,995723.85,'461','2022-03-21 14:34:30','533','2022-03-22 07:55:43',10,0),('1','116',257682,'MORNING SHIFT','2022-03-23','2022-03-23 15:22:59','2022-03-30 15:22:59','461',1640654.40,1640654.40,'461','2022-03-23 15:27:10','533','2022-03-23 16:35:43',10,0),('1','116',257683,'AFTERNOON SHIFT','2022-03-23','2022-03-24 10:45:51','2022-03-25 10:45:51','461',1867182.90,1867182.90,'461','2022-03-24 11:04:58','533','2022-03-24 15:03:21',10,0),('1','116',257684,'MORNING SHIFT','2022-03-24','2022-03-24 15:21:11','2022-03-25 15:21:11','461',2472805.50,2472805.50,'461','2022-03-24 15:26:34','533','2022-03-25 08:55:53',10,0),('1','116',257685,'AFTERNOON SHIFT','2022-03-24','2022-03-25 10:28:41','2022-03-26 10:28:41','461',1481805.60,1481805.60,'461','2022-03-25 10:41:12','533','2022-03-25 15:45:27',10,0),('1','116',257686,'MORNING SHIFT','2022-03-25','2022-03-25 17:26:35','2022-03-26 17:26:35','461',1038915.90,1038915.90,'461','2022-03-25 17:32:27','533','2022-03-26 11:13:43',10,0),('1','116',257687,'AFTERNOON SHIFT','2022-03-25','2022-03-26 12:25:12','2022-03-27 12:25:12','461',1215027.00,1215027.00,'461','2022-03-26 12:33:37','533','2022-03-26 17:34:44',10,0),('1','116',257688,'MORNING SHIFT','2022-03-26','2022-03-26 18:11:49','2022-03-27 18:11:49','461',1397751.30,1397751.30,'461','2022-03-26 18:18:09','533','2022-03-26 20:27:16',10,0),('1','116',257689,'MORNING SHIFT','2022-03-28','2022-03-28 15:35:53','2022-03-29 15:35:53','461',1205915.70,1205915.70,'461','2022-03-28 15:40:01','533','2022-03-29 04:32:00',10,0),('1','116',257690,'AFTERNOON SHIFT','2022-03-28','2022-03-29 12:01:10','2022-03-30 12:01:10','461',1652742.30,1652742.30,'461','2022-03-29 12:10:39','533','2022-03-29 12:17:14',10,0),('1','116',257691,'MORNING SHIFT','2022-03-29','2022-03-29 15:00:31','2022-03-30 15:00:31','461',2244892.65,2244892.65,'461','2022-03-29 15:10:40','533','2022-03-29 15:46:10',10,0),('1','116',257692,'AFTERNOON SHIFT','2022-03-29','2022-03-30 10:07:17','2022-03-31 10:07:17','461',2528068.95,2528068.95,'461','2022-03-30 10:14:52','533','2022-03-30 14:52:53',10,0),('1','116',257693,'MORNING SHIFT','2022-03-30','2022-03-30 14:56:06','2022-03-31 14:56:06','461',1969898.70,1969898.70,'461','2022-03-30 14:59:49','533','2022-03-30 17:18:49',10,0),('1','116',257694,'AFTERNOON SHIFT','2022-03-30','2022-03-31 09:27:26','2022-04-01 09:27:26','461',2416073.55,2416073.55,'461','2022-03-31 09:33:40','533','2022-03-31 10:00:06',10,0),('1','116',257695,'MORNING SHIFT','2022-03-31','2022-03-31 15:22:39','2022-04-01 15:22:39','461',2360775.45,2360775.45,'461','2022-03-31 15:26:55','533','2022-04-01 10:13:49',10,0),('1','116',257696,'AFTERNOON SHIFT','2022-03-31','2022-04-01 10:32:58','2022-04-02 10:32:58','461',1704707.40,1704707.40,'461','2022-04-01 11:00:07','533','2022-04-01 16:15:55',10,0),('1','116',257697,'MORNING SHIFT','2022-04-01','2022-04-01 17:49:53','2022-04-08 17:49:53','461',2240693.40,2240693.40,'461','2022-04-01 17:52:36','533','2022-04-02 11:51:52',10,0),('1','116',257698,'AFTERNOON SHIFT','2022-04-01','2022-04-02 12:32:19','2022-04-03 12:32:19','461',2249524.20,2249524.20,'461','2022-04-02 12:43:13','533','2022-04-02 12:48:02',10,0),('1','116',257699,'MORNING SHIFT','2022-04-02','2022-04-02 12:59:17','2022-04-03 12:59:17','461',2286706.95,2286706.95,'461','2022-04-02 15:10:15','533','2022-04-03 11:34:51',10,0),('1','116',257700,'AFTERNOON SHIFT','2022-04-02','2022-04-03 12:14:29','2022-04-04 12:14:29','461',2741630.10,2741630.10,'461','2022-04-03 12:20:40','533','2022-04-03 16:08:22',10,0),('1','116',257701,'MORNING SHIFT','2022-04-03','2022-04-03 16:11:00','2022-04-04 16:11:00','461',1228545.45,1228545.45,'461','2022-04-03 16:14:41','533','2022-04-03 19:23:58',10,0),('1','116',257702,'AFTERNOON SHIFT','2022-04-03','2022-04-04 10:38:49','2022-04-05 10:38:49','461',1836032.55,1836032.55,'461','2022-04-04 10:48:29','533','2022-04-04 11:03:51',10,0),('1','116',257703,'MORNING SHIFT','2022-04-04','2022-04-04 15:11:24','2022-04-05 15:11:24','461',2349194.10,2349194.10,'461','2022-04-04 15:17:15','533','2022-04-04 18:08:44',10,0),('1','116',257704,'AFTERNOON SHIFT','2022-04-04','2022-04-05 09:53:44','2022-04-06 09:53:44','461',2894434.95,2894434.95,'461','2022-04-05 10:13:11','533','2022-04-05 10:52:26',10,0),('1','116',257705,'MORNING SHIFT','2022-04-05','2022-04-05 14:58:49','2022-04-06 14:58:49','461',2755234.35,2755234.35,'461','2022-04-05 15:11:04','533','2022-04-06 09:52:58',10,0),('1','116',257706,'AFTERNOON SHIFT','2022-04-05','2022-04-06 11:26:47','2022-04-07 11:26:47','461',2442999.90,2442999.90,'461','2022-04-06 11:34:23','533','2022-04-06 13:51:22',10,0),('1','116',257707,'MORNING SHIFT','2022-04-08','2022-04-08 15:14:59','2022-04-09 15:14:59','461',2982210.00,2982210.00,'461','2022-04-08 15:26:20','533','2022-04-09 11:30:23',10,0),('1','116',257708,'AFTERNOON SHIFT','2022-04-08','2022-04-09 11:34:21','2022-04-10 11:34:21','461',2643149.85,2643149.85,'461','2022-04-09 11:41:58','761','2022-04-09 12:22:55',10,0),('1','116',257709,'MORNING SHIFT','2022-04-09','2022-04-09 15:57:50','2022-04-10 15:57:50','461',704162.25,704162.25,'461','2022-04-09 15:59:51','533','2022-04-09 16:11:00',10,0),('1','116',257710,'AFTERNOON SHIFT','2022-04-11','2022-04-12 11:14:49','2022-04-13 11:14:49','461',1918402.20,1918402.20,'461','2022-04-12 11:26:38','533','2022-04-12 14:04:10',10,0),('1','116',257711,'MORNING SHIFT','2022-04-12','2022-04-12 14:58:19','2022-04-13 14:58:19','461',1857672.30,1857672.30,'461','2022-04-12 15:04:02','533','2022-04-12 18:47:00',10,0),('1','116',257712,'AFTERNOON SHIFT','2022-04-12','2022-04-13 09:32:15','2022-04-14 09:32:15','461',1838954.70,1838954.70,'461','2022-04-13 09:40:08','533','2022-04-13 09:57:25',10,0),('1','116',257713,'MORNING SHIFT','2022-04-13','2022-04-13 15:01:30','2022-04-14 15:01:30','461',1222313.40,1222313.40,'461','2022-04-13 15:05:13','533','2022-04-13 17:29:12',10,0),('1','116',257714,'MORNING SHIFT','2022-04-14','2022-04-14 14:27:54','2022-04-15 14:27:54','461',687820.65,687820.65,'461','2022-04-14 14:31:55','533','2022-04-15 10:06:32',10,0),('1','116',257715,'AFTERNOON SHIFT','2022-04-14','2022-04-15 10:37:07','2022-04-16 10:37:07','461',2498915.10,2498915.10,'461','2022-04-15 10:44:15','533','2022-04-15 16:01:42',10,0),('1','116',257716,'MORNING SHIFT','2022-04-15','2022-04-15 16:03:10','2022-04-16 16:03:10','461',2512854.30,2512854.30,'461','2022-04-15 16:17:07','761','2022-04-15 17:13:15',10,0),('1','116',257717,'AFTERNOON SHIFT','2022-04-15','2022-04-16 13:30:26','2022-04-17 13:30:26','461',2263950.15,2263950.15,'461','2022-04-16 13:43:17','533','2022-04-16 17:05:41',10,0),('1','116',257718,'MORNING SHIFT','2022-04-16','2022-04-17 06:44:51','2022-04-18 06:44:51','461',2071314.30,2071314.30,'461','2022-04-17 06:48:15','761','2022-04-17 11:58:29',10,0),('1','116',257719,'AFTERNOON SHIFT','2022-04-16','2022-04-17 13:21:30','2022-04-18 13:21:30','461',1152863.25,1152863.25,'461','2022-04-17 13:23:39','533','2022-04-17 16:15:21',10,0),('1','116',257720,'AFTERNOON SHIFT','2022-04-19','2022-04-19 17:33:19','2022-04-20 17:33:19','461',139083.00,139083.00,'461','2022-04-19 17:34:41','533','2022-04-20 11:30:19',10,0),('1','116',257721,'MORNING SHIFT','2022-04-22','2022-04-22 15:08:02','2022-04-23 15:08:02','461',1988736.75,1988736.75,'461','2022-04-22 15:27:55','533','2022-04-22 18:04:47',10,0),('1','116',257722,'AFTERNOON SHIFT','2022-04-22','2022-04-23 12:43:12','2022-04-24 12:43:12','461',1575243.45,1575243.45,'461','2022-04-23 12:46:01','533','2022-04-23 12:46:57',10,0),('1','116',257723,'MORNING SHIFT','2022-04-23','2022-04-23 14:39:18','2022-04-24 14:39:18','461',2108048.25,2108048.25,'461','2022-04-23 14:43:11','533','2022-04-24 12:36:51',10,0),('1','116',257724,'AFTERNOON SHIFT','2022-04-23','2022-04-24 13:10:44','2022-04-25 13:10:44','461',872640.45,872640.45,'461','2022-04-24 13:14:19','533','2022-04-24 13:38:48',10,0),('1','116',257725,'MORNING SHIFT','2022-04-25','2022-04-25 13:59:28','2022-04-26 13:59:28','461',479534.55,479534.55,'461','2022-04-25 14:02:02','533','2022-04-25 14:21:45',10,0),('1','116',257726,'AFTERNOON SHIFT','2022-04-28','2022-04-29 15:00:10','2022-04-30 15:00:10','461',495871.20,495871.20,'461','2022-04-29 15:04:03','533','2022-04-29 16:10:05',10,0),('1','116',257727,'MORNING SHIFT','2022-05-01','2022-05-01 14:57:24','2022-05-02 14:57:24','461',766012.50,766012.50,'461','2022-05-01 15:00:36','533','2022-05-02 13:26:51',10,0),('1','116',257728,'AFTERNOON SHIFT','2022-05-01','2022-05-02 13:27:27','2022-05-03 13:27:27','461',4364335.80,4364335.80,'461','2022-05-02 13:37:13','533','2022-05-02 14:48:28',10,0),('1','116',257729,'MORNING SHIFT','2022-05-02','2022-05-02 16:35:03','2022-05-03 16:35:03','461',1405715.85,1405715.85,'461','2022-05-02 16:39:13','533','2022-05-03 07:54:24',10,0),('1','116',257730,'AFTERNOON SHIFT','2022-05-02','2022-05-03 08:59:20','2022-05-04 08:59:20','461',889501.80,889501.80,'461','2022-05-03 09:03:22','533','2022-05-03 15:43:49',10,0),('1','116',257731,'MORNING SHIFT','2022-05-03','2022-05-03 15:44:56','2022-05-04 15:44:56','461',1293568.65,1293568.65,'461','2022-05-03 15:47:05','533','2022-05-03 19:44:01',10,0),('1','116',257732,'AFTERNOON SHIFT','2022-05-03','2022-05-04 13:52:43','2022-05-05 13:52:43','461',585738.45,585738.45,'461','2022-05-04 13:55:31','533','2022-05-04 16:56:28',10,0),('1','116',257733,'MORNING SHIFT','2022-05-04','2022-05-04 18:11:28','2022-05-05 18:11:28','461',645357.90,645357.90,'461','2022-05-04 18:15:48','533','2022-05-05 12:54:42',10,0),('1','116',257734,'AFTERNOON SHIFT','2022-05-04','2022-05-05 14:07:00','2022-05-06 14:07:00','461',1072752.45,1072752.45,'461','2022-05-05 14:12:25','533','2022-05-06 07:16:47',10,0),('1','116',257735,'AFTERNOON SHIFT','2022-05-05','2022-05-06 13:42:45','2022-05-07 13:42:45','461',1695794.10,1695794.10,'461','2022-05-06 13:48:32','533','2022-05-07 08:12:10',10,0),('1','116',257736,'MORNING SHIFT','2022-05-08','2022-05-08 14:58:47','2022-05-09 14:58:47','461',734217.00,734217.00,'461','2022-05-08 15:06:34','533','2022-05-08 20:45:39',10,0),('1','116',257737,'MORNING SHIFT','2022-05-10','2022-05-10 13:52:50','2022-05-11 13:52:50','461',690681.75,690681.75,'461','2022-05-10 14:05:48','533','2022-05-10 18:34:45',10,0),('1','116',257738,'AFTERNOON SHIFT','2022-05-11','2022-05-12 10:20:12','2022-05-13 10:20:12','461',1134116.65,1134116.65,'461','2022-05-12 10:26:19','533','2022-05-12 13:49:40',10,0),('1','116',257739,'MORNING SHIFT','2022-05-12','2022-05-12 16:43:09','2022-05-13 16:43:09','461',1253896.05,1253896.05,'461','2022-05-12 16:46:22','533','2022-05-13 08:54:00',10,0),('1','116',257740,'AFTERNOON SHIFT','2022-05-12','2022-05-13 08:54:50','2022-05-14 08:54:50','461',1623620.00,1623620.00,'461','2022-05-13 09:08:21','761','2022-05-13 12:17:00',10,0),('1','116',257741,'MORNING SHIFT','2022-05-13','2022-05-13 13:21:26','2022-05-14 13:21:26','461',1081612.95,1081612.95,'461','2022-05-13 13:25:36','761','2022-05-13 15:21:28',10,0),('1','116',257742,'AFTERNOON SHIFT','2022-05-13','2022-05-14 10:45:31','2022-05-15 10:45:31','461',972874.65,972874.65,'461','2022-05-14 10:48:36','533','2022-05-14 16:55:00',10,0),('1','116',257743,'MORNING SHIFT','2022-05-14','2022-05-14 17:08:07','2022-05-15 17:08:07','461',487274.70,487274.70,'461','2022-05-14 17:09:48','533','2022-05-15 17:05:55',10,0),('1','116',257744,'AFTERNOON SHIFT','2022-05-15','2022-05-16 08:01:04','2022-05-17 08:01:04','461',624998.55,624998.55,'461','2022-05-16 08:04:05','761','2022-05-16 10:32:36',10,0),('1','116',257745,'MORNING SHIFT','2022-05-16','2022-05-16 14:34:47','2022-05-17 14:34:47','461',1571529.30,1571529.30,'461','2022-05-16 14:38:21','533','2022-05-16 18:17:33',10,0),('1','116',257746,'AFTERNOON SHIFT','2022-05-16','2022-05-17 08:05:10','2022-05-18 08:05:10','461',1906352.25,1906352.25,'461','2022-05-17 08:18:52','533','2022-05-17 11:31:20',10,0),('1','116',257747,'MORNING SHIFT','2022-05-17','2022-05-17 14:09:17','2022-05-18 14:09:17','461',1232470.80,1232470.80,'461','2022-05-17 14:12:18','761','2022-05-17 17:18:24',10,0),('1','116',257748,'AFTERNOON SHIFT','2022-05-17','2022-05-18 12:45:42','2022-05-19 12:45:42','461',1704407.10,1704407.10,'461','2022-05-18 13:03:58','761','2022-05-18 15:36:09',10,0),('1','116',257749,'MORNING SHIFT','2022-05-19','2022-05-19 14:44:18','2022-05-20 14:44:18','461',1888378.80,1888378.80,'461','2022-05-19 14:50:13','533','2022-05-19 15:38:18',10,0),('1','116',257750,'AFTERNOON SHIFT','2022-05-19','2022-05-20 10:53:01','2022-05-21 10:53:01','461',2059082.85,2059082.85,'461','2022-05-20 11:17:47','533','2022-05-20 13:18:28',10,0),('1','116',257751,'MORNING SHIFT','2022-05-20','2022-05-20 16:12:31','2022-05-21 16:12:31','461',2077048.05,2077048.05,'461','2022-05-20 17:35:03','533','2022-05-20 18:09:16',10,0),('1','116',257752,'AFTERNOON SHIFT','2022-05-20','2022-05-21 12:42:20','2022-05-22 12:42:20','461',2168962.95,2168962.95,'461','2022-05-21 13:39:11','533','2022-05-21 15:18:24',10,0),('1','116',257753,'MORNING SHIFT','2022-05-21','2022-05-21 17:46:56','2022-05-22 17:46:56','461',456446.10,456446.10,'461','2022-05-21 17:50:23','761','2022-05-22 14:25:07',10,0),('1','116',257754,'AFTERNOON SHIFT','2022-05-21','2022-05-22 14:38:32','2022-05-23 14:38:32','461',435369.00,435369.00,'461','2022-05-22 14:43:26','533','2022-05-22 17:29:01',10,0),('1','116',257755,'AFTERNOON SHIFT','2022-05-22','2022-05-23 07:33:23','2022-05-24 07:33:23','461',882759.90,882759.90,'461','2022-05-23 07:42:33','761','2022-05-23 08:34:36',10,0),('1','116',257756,'MORNING SHIFT','2022-05-23','2022-05-23 14:19:04','2022-05-24 14:19:04','461',1235635.50,1235635.50,'461','2022-05-23 14:22:55','761','2022-05-23 16:40:09',10,0),('1','116',257757,'AFTERNOON SHIFT','2022-05-23','2022-05-24 08:53:27','2022-05-25 08:53:27','461',1364439.45,1364439.45,'461','2022-05-24 09:05:52','533','2022-05-24 11:00:55',10,0),('1','116',257758,'MORNING SHIFT','2022-05-24','2022-05-24 14:03:44','2022-05-25 14:03:44','461',1196073.45,1196073.45,'461','2022-05-24 14:07:20','761','2022-05-24 16:20:11',10,0),('1','116',257759,'AFTERNOON SHIFT','2022-05-29','2022-05-30 10:14:32','2022-05-31 10:14:32','461',214137.00,214137.00,'461','2022-05-30 10:21:22','761','2022-05-30 11:06:38',10,0),('1','116',257760,'MORNING SHIFT','2022-05-30','2022-05-30 16:47:02','2022-05-31 16:47:02','461',1239788.55,1239788.55,'461','2022-05-30 16:53:40','761','2022-05-31 08:44:16',10,0),('1','116',257761,'AFTERNOON SHIFT','2022-05-30','2022-05-31 09:30:55','2022-06-01 09:30:55','461',2212027.95,2212027.95,'461','2022-05-31 09:38:08','761','2022-05-31 10:11:19',10,0),('1','116',257762,'MORNING SHIFT','2022-05-31','2022-05-31 14:19:28','2022-06-01 14:19:28','461',1553280.30,1553280.30,'461','2022-05-31 14:21:18','533','2022-05-31 20:25:39',10,0),('1','116',257763,'AFTERNOON SHIFT','2022-05-31','2022-06-01 08:37:33','2022-06-02 08:37:33','461',2203556.85,2203556.85,'461','2022-06-01 08:49:11','761','2022-06-01 12:01:47',10,0),('1','116',257764,'MORNING SHIFT','2022-06-01','2022-06-01 15:11:37','2022-06-02 15:11:37','461',1550985.15,1550985.15,'461','2022-06-01 15:15:04','533','2022-06-01 17:27:30',10,0),('1','116',257765,'AFTERNOON SHIFT','2022-06-02','2022-06-03 08:47:51','2022-06-04 08:47:51','461',1248736.50,1248736.50,'461','2022-06-03 08:51:28','761','2022-06-03 09:33:19',10,0),('1','116',257766,'MORNING SHIFT','2022-06-03','2022-06-03 16:38:08','2022-06-04 16:38:08','461',1495246.50,1495246.50,'461','2022-06-03 16:42:01','533','2022-06-03 18:00:10',10,0),('1','116',257767,'AFTERNOON SHIFT','2022-06-03','2022-06-03 19:26:04','2022-06-04 19:26:04','461',1578754.65,1578754.65,'461','2022-06-03 19:40:50','533','2022-06-03 21:55:33',10,0),('1','116',257768,'MORNING SHIFT','2022-06-04','2022-06-04 13:37:20','2022-06-05 13:37:20','461',1167927.75,1167927.75,'461','2022-06-04 13:39:31','533','2022-06-04 17:45:43',10,0),('1','116',257769,'AFTERNOON SHIFT','2022-06-04','2022-06-04 19:21:03','2022-06-05 19:21:03','461',1331591.25,1331591.25,'461','2022-06-04 19:23:27','761','2022-06-05 11:44:19',10,0),('1','116',257770,'AFTERNOON SHIFT','2022-06-05','2022-06-05 20:01:18','2022-06-06 20:01:18','461',1075690.00,1075690.00,'461','2022-06-06 12:47:15','761','2022-06-06 14:19:59',10,0),('1','116',257771,'MORNING SHIFT','2022-06-07','2022-06-07 15:43:28','2022-06-08 15:43:28','461',1632483.60,1632483.60,'461','2022-06-07 15:49:43','761','2022-06-07 17:00:27',10,0),('1','116',257772,'AFTERNOON SHIFT','2022-06-07','2022-06-08 08:37:51','2022-06-09 08:37:51','461',1675990.20,1675990.20,'461','2022-06-08 08:41:04','533','2022-06-08 11:08:47',10,0),('1','116',257773,'MORNING SHIFT','2022-06-08','2022-06-08 11:49:38','2022-06-09 11:49:38','461',1348570.40,1348570.40,'461','2022-06-08 13:48:41','761','2022-06-08 16:58:11',10,0),('1','116',257774,'AFTERNOON SHIFT','2022-06-08','2022-06-09 09:52:14','2022-06-10 09:52:14','461',882979.75,882979.75,'461','2022-06-09 10:34:54','761','2022-06-09 15:08:23',10,0),('1','116',257775,'MORNING SHIFT','2022-06-10','2022-06-10 13:39:02','2022-06-11 13:39:02','461',1516898.25,1516898.25,'461','2022-06-10 13:43:15','533','2022-06-10 15:09:16',10,0),('1','116',257776,'AFTERNOON SHIFT','2022-06-10','2022-06-11 08:12:05','2022-06-12 08:12:05','461',2262941.35,2262941.35,'461','2022-06-11 08:21:33','533','2022-06-11 09:31:07',10,0),('1','116',257777,'MORNING SHIFT','2022-06-11','2022-06-11 12:33:14','2022-06-12 12:33:14','461',1419085.30,1419085.30,'461','2022-06-11 13:44:35','533','2022-06-11 14:26:58',10,0),('1','116',257778,'AFTERNOON SHIFT','2022-06-12','2022-06-12 10:56:42','2022-06-13 10:56:42','461',1070100.90,1070100.90,'461','2022-06-12 11:03:59','533','2022-06-12 15:01:52',10,0),('1','116',257779,'MORNING SHIFT','2022-06-12','2022-06-12 17:35:49','2022-06-13 17:35:49','461',1643043.95,1643043.95,'461','2022-06-12 17:40:01','533','2022-06-13 06:20:19',10,0),('1','116',257780,'AFTERNOON SHIFT','2022-06-12','2022-06-13 09:26:58','2022-06-14 09:26:58','461',1373571.00,1373571.00,'461','2022-06-13 09:36:06','533','2022-06-13 10:27:48',10,0),('1','116',257781,'MORNING SHIFT','2022-06-13','2022-06-13 13:32:28','2022-06-14 13:32:28','461',1024577.35,1024577.35,'461','2022-06-13 13:35:48','533','2022-06-13 19:58:17',10,0),('1','116',257782,'AFTERNOON SHIFT','2022-06-13','2022-06-14 09:31:24','2022-06-15 09:31:24','461',1215763.65,1215763.65,'461','2022-06-14 09:40:14','761','2022-06-14 10:58:36',10,0),('1','116',257783,'MORNING SHIFT','2022-06-14','2022-06-14 13:37:13','2022-06-15 13:37:13','461',790762.55,790762.55,'461','2022-06-14 13:45:04','533','2022-06-14 16:31:56',10,0),('1','116',257784,'MORNING SHIFT','2022-06-15','2022-06-15 13:37:40','2022-06-16 13:37:40','461',895822.05,895822.05,'461','2022-06-15 13:41:03','533','2022-06-15 14:39:37',10,0),('1','116',257785,'MORNING SHIFT','2022-06-16','2022-06-16 14:40:03','2022-06-17 14:40:03','461',2012330.75,2012330.75,'461','2022-06-16 14:46:30','533','2022-06-17 09:21:45',10,0),('1','116',257786,'AFTERNOON SHIFT','2022-06-16','2022-06-17 11:59:10','2022-06-18 11:59:10','461',2343030.10,2343030.10,'461','2022-06-17 12:00:54','761','2022-06-17 14:22:21',10,0),('1','116',257787,'MORNING SHIFT','2022-06-17','2022-06-17 14:39:01','2022-06-18 14:39:01','461',2028750.35,2028750.35,'461','2022-06-17 14:43:55','761','2022-06-17 22:33:18',10,0),('1','116',257788,'AFTERNOON SHIFT','2022-06-17','2022-06-18 11:30:22','2022-06-19 11:30:22','461',836950.95,836950.95,'461','2022-06-18 11:37:42','533','2022-06-18 17:58:30',10,0),('1','116',257789,'MORNING SHIFT','2022-06-21','2022-06-21 14:53:15','2022-06-22 14:53:15','461',2634906.25,2634906.25,'461','2022-06-21 15:00:00','533','2022-06-21 19:51:25',10,0),('1','116',257790,'AFTERNOON SHIFT','2022-06-21','2022-06-22 08:26:39','2022-06-23 08:26:39','461',1783009.50,1783009.50,'461','2022-06-22 08:39:59','761','2022-06-22 13:36:11',10,0),('1','116',257791,'MORNING SHIFT','2022-06-22','2022-06-22 13:58:32','2022-06-23 13:58:32','461',998812.65,998812.65,'461','2022-06-22 14:01:34','533','2022-06-22 14:41:16',10,0),('1','116',257792,'MORNING SHIFT','2022-06-23','2022-06-23 15:23:22','2022-06-24 15:23:22','461',789192.40,789192.40,'461','2022-06-23 15:32:28','533','2022-06-23 21:40:36',10,0),('1','116',257793,'MORNING SHIFT','2022-06-25','2022-06-25 14:20:43','2022-06-26 14:20:43','461',1451188.20,1451188.20,'461','2022-06-25 14:24:29','533','2022-06-25 18:51:01',10,0),('1','116',257794,'AFTERNOON SHIFT','2022-06-25','2022-06-26 08:56:51','2022-06-27 08:56:51','461',765860.70,765860.70,'461','2022-06-26 09:02:04','533','2022-06-26 11:43:31',10,0),('1','116',257795,'AFTERNOON SHIFT','2022-06-26','2022-06-27 08:32:35','2022-06-28 08:32:35','461',1559520.60,1559520.60,'461','2022-06-27 08:39:04','761','2022-06-27 09:35:33',10,0),('1','116',257796,'MORNING SHIFT','2022-06-27','2022-06-27 15:32:26','2022-06-28 15:32:26','461',1416459.00,1416459.00,'461','2022-06-27 15:36:11','761','2022-06-27 20:57:43',10,0),('1','116',257797,'AFTERNOON SHIFT','2022-06-27','2022-06-28 09:02:39','2022-06-29 09:02:39','461',846558.90,846558.90,'461','2022-06-28 09:10:04','533','2022-06-28 09:19:28',10,0),('1','116',257798,'MORNING SHIFT','2022-06-28','2022-06-28 14:51:27','2022-06-29 14:51:27','461',1223829.75,1223829.75,'461','2022-06-28 14:54:31','533','2022-06-28 23:00:51',10,0),('1','116',257799,'AFTERNOON SHIFT','2022-06-30','2022-06-30 19:10:01','2022-07-01 19:10:01','461',597928.05,597928.05,'461','2022-06-30 19:34:14','533','2022-06-30 21:25:12',10,0),('1','116',257800,'AFTERNOON SHIFT','2022-07-01','2022-07-02 10:27:18','2022-07-03 10:27:18','461',1683309.25,1683309.25,'461','2022-07-02 10:39:30','533','2022-07-02 12:04:34',10,0),('1','116',257801,'MORNING SHIFT','2022-07-05','2022-07-05 15:42:13','2022-07-06 15:42:13','461',2056504.00,2056504.00,'461','2022-07-05 15:48:43','533','2022-07-05 17:10:01',10,0),('1','116',257802,'AFTERNOON SHIFT','2022-07-05','2022-07-06 09:07:31','2022-07-07 09:07:31','461',917309.15,917309.15,'461','2022-07-06 09:22:30','533','2022-07-06 14:30:44',10,0),('1','116',257803,'MORNING SHIFT','2022-07-06','2022-07-06 14:50:21','2022-07-07 14:50:21','461',568890.70,568890.70,'461','2022-07-06 14:55:54','533','2022-07-06 19:42:09',10,0),('1','116',257804,'AFTERNOON SHIFT','2022-07-06','2022-07-07 09:52:29','2022-07-08 09:52:29','461',830375.70,830375.70,'461','2022-07-07 09:55:33','533','2022-07-07 12:34:18',10,0),('1','116',257805,'AFTERNOON SHIFT','2022-07-07','2022-07-08 09:45:29','2022-07-08 10:45:29','461',137694.15,137694.15,'461','2022-07-08 09:52:25','533','2022-07-08 12:02:54',10,0),('1','116',257806,'AFTERNOON SHIFT','2022-07-08','2022-07-08 20:05:20','2022-07-09 20:05:20','461',1535147.65,1535147.65,'461','2022-07-08 21:15:39','533','2022-07-08 21:17:46',10,0),('1','116',257807,'MORNING SHIFT','2022-07-11','2022-07-11 19:19:46','2022-07-12 19:19:46','461',461608.10,461608.10,'461','2022-07-11 19:22:17','533','2022-07-12 10:41:14',10,0),('1','116',257808,'AFTERNOON SHIFT','2022-07-13','2022-07-13 18:10:16','2022-07-13 19:10:16','461',832663.45,832663.45,'461','2022-07-13 18:47:02','533','2022-07-14 08:31:32',10,0),('1','116',257809,'MORNING SHIFT','2022-07-15','2022-07-15 13:47:26','2022-07-16 13:47:26','461',382225.60,382225.60,'461','2022-07-15 13:52:48','533','2022-07-17 07:37:48',10,0),('1','116',257810,'MORNING SHIFT','2022-07-19','2022-07-19 13:47:02','2022-07-20 13:47:02','461',827434.50,827434.50,'461','2022-07-19 13:55:26','913','2022-07-19 16:19:54',10,0),('1','116',257811,'AFTERNOON SHIFT','2022-07-21','2022-07-21 18:28:01','2022-07-21 20:28:01','461',3103257.20,3103257.20,'461','2022-07-21 19:41:22','913','2022-07-21 21:32:53',10,0),('1','116',257812,'MORNING SHIFT','2022-07-25','2022-07-25 15:08:16','2022-07-26 15:08:16','461',1119708.80,1119708.80,'461','2022-07-25 15:13:53','913','2022-07-25 17:37:46',10,0),('1','116',257813,'AFTERNOON SHIFT','2022-07-25','2022-07-26 08:42:43','2022-07-27 08:42:43','461',1711399.85,1711399.85,'461','2022-07-26 08:50:19','761','2022-07-26 11:22:53',10,0),('1','116',257814,'MORNING SHIFT','2022-07-26','2022-07-26 14:51:07','2022-07-27 14:51:07','461',2233899.05,2233899.05,'461','2022-07-26 14:54:14','913','2022-07-26 15:17:34',10,0),('1','116',257815,'AFTERNOON SHIFT','2022-07-26','2022-07-27 09:01:13','2022-07-28 09:01:13','461',2351200.15,2351200.15,'461','2022-07-27 09:09:40','913','2022-07-27 10:02:54',10,0),('1','116',257816,'MORNING SHIFT','2022-07-27','2022-07-27 14:39:29','2022-07-28 14:39:29','461',3350774.05,3350774.05,'461','2022-07-27 14:52:07','913','2022-07-27 17:16:20',10,0),('1','116',257817,'AFTERNOON SHIFT','2022-07-27','2022-07-28 08:51:49','2022-07-29 08:51:49','461',1503483.90,1503483.90,'461','2022-07-28 08:58:41','913','2022-07-28 10:10:41',10,0),('1','116',257818,'MORNING SHIFT','2022-07-28','2022-07-28 13:46:51','2022-07-29 13:46:51','461',1189870.05,1189870.05,'461','2022-07-28 13:49:37','913','2022-07-28 15:51:51',10,0),('1','116',257819,'AFTERNOON SHIFT','2022-07-28','2022-07-28 18:07:06','2022-07-29 18:07:06','461',710881.00,710881.00,'461','2022-07-28 18:14:10','913','2022-07-28 20:03:08',10,0),('1','116',257820,'MORNING SHIFT','2022-08-01','2022-08-01 14:48:34','2022-08-02 14:48:34','461',1816428.05,1816428.05,'461','2022-08-01 14:54:35','913','2022-08-01 18:19:13',10,0),('1','116',257821,'AFTERNOON SHIFT','2022-08-01','2022-08-02 09:10:34','2022-08-03 09:10:34','461',1329397.85,1329397.85,'461','2022-08-02 09:19:35','913','2022-08-02 12:40:08',10,0),('1','116',257822,'MORNING SHIFT','2022-08-02','2022-08-02 13:54:12','2022-08-03 13:54:12','461',1046986.35,1046986.35,'461','2022-08-02 13:58:41','913','2022-08-02 16:09:31',10,0),('1','116',257823,'AFTERNOON SHIFT','2022-08-02','2022-08-03 08:54:13','2022-08-04 08:54:13','461',1788884.30,1788884.30,'461','2022-08-03 09:04:24','761','2022-08-03 11:43:29',10,0),('1','116',257824,'MORNING SHIFT','2022-08-03','2022-08-03 15:28:08','2022-08-04 15:28:08','461',2041221.15,2041221.15,'461','2022-08-03 15:31:57','913','2022-08-03 18:15:02',10,0),('1','116',257825,'AFTERNOON SHIFT','2022-08-03','2022-08-04 09:36:45','2022-08-05 09:36:45','461',3220097.05,3220097.05,'461','2022-08-04 09:44:47','913','2022-08-04 13:04:48',10,0),('1','116',257826,'MORNING SHIFT','2022-08-04','2022-08-04 15:44:55','2022-08-05 15:44:55','461',2344410.65,2344410.65,'461','2022-08-04 15:51:58','913','2022-08-04 18:25:07',10,0),('1','116',257827,'AFTERNOON SHIFT','2022-08-04','2022-08-05 09:13:08','2022-08-06 09:13:08','461',2653582.45,2653582.45,'461','2022-08-05 09:27:17','913','2022-08-05 11:12:30',10,0),('1','116',257828,'MORNING SHIFT','2022-08-05','2022-08-05 18:28:29','2022-08-06 18:28:29','461',1839477.20,1839477.20,'461','2022-08-05 18:31:15','913','2022-08-05 23:26:14',10,0),('1','116',257829,'AFTERNOON SHIFT','2022-08-05','2022-08-06 11:32:29','2022-08-07 11:32:29','461',3900978.40,3900978.40,'461','2022-08-06 11:49:18','913','2022-08-06 14:20:57',10,0),('1','116',257830,'MORNING SHIFT','2022-08-06','2022-08-06 15:14:35','2022-08-07 15:14:35','461',2470412.30,2470412.30,'461','2022-08-06 15:26:27','913','2022-08-06 16:28:40',10,0),('1','116',257831,'AFTERNOON SHIFT','2022-08-06','2022-08-07 12:50:11','2022-08-08 12:50:11','461',3502591.25,3502591.25,'461','2022-08-07 13:37:47','913','2022-08-07 13:38:14',10,0),('1','116',257832,'MORNING SHIFT','2022-08-07','2022-08-07 18:14:26','2022-08-08 18:14:26','461',1111078.00,1111078.00,'461','2022-08-07 18:18:14','913','2022-08-07 23:06:56',10,0),('1','116',257833,'AFTERNOON SHIFT','2022-08-07','2022-08-08 09:29:32','2022-08-09 09:29:32','461',2167837.80,2167837.80,'461','2022-08-08 09:36:36','913','2022-08-08 10:28:54',10,0),('1','116',257834,'MORNING SHIFT','2022-08-08','2022-08-08 15:55:18','2022-08-09 15:55:18','461',2730706.70,2730706.70,'461','2022-08-08 16:00:43','913','2022-08-08 16:32:01',10,0),('1','116',257835,'AFTERNOON SHIFT','2022-08-10','2022-08-11 09:11:31','2022-08-12 09:11:31','461',2748365.00,2748365.00,'461','2022-08-11 10:26:54','913','2022-08-11 11:17:25',10,0),('1','116',257836,'MORNING SHIFT','2022-08-11','2022-08-11 14:22:15','2022-08-12 14:22:15','461',1955672.00,1955672.00,'461','2022-08-11 14:26:22','913','2022-08-11 14:57:09',10,0),('1','116',257837,'AFTERNOON SHIFT','2022-08-11','2022-08-11 20:46:42','2022-08-12 20:46:42','461',3382760.25,3382760.25,'461','2022-08-11 20:49:28','913','2022-08-11 20:59:09',10,0),('1','116',257838,'MORNING SHIFT','2022-08-12','2022-08-12 17:37:00','2022-08-13 17:37:00','461',1769377.90,1769377.90,'461','2022-08-12 17:46:12','913','2022-08-12 20:44:24',10,0),('1','116',257839,'AFTERNOON SHIFT','2022-08-12','2022-08-13 16:11:20','2022-08-14 16:11:20','461',2501597.00,2501597.00,'461','2022-08-13 16:15:25','913','2022-08-13 20:19:55',10,0),('1','116',257840,'AFTERNOON SHIFT','2022-08-16','2022-08-17 09:41:14','2022-08-18 09:41:14','461',695654.10,695654.10,'461','2022-08-17 09:45:42','913','2022-08-17 12:27:09',10,0),('1','116',257841,'AFTERNOON SHIFT','2022-08-17','2022-08-17 20:18:03','2022-08-18 20:18:03','461',38853.70,38853.70,'461','2022-08-17 20:20:26','913','2022-08-17 22:43:31',10,0),('1','116',257842,'MORNING SHIFT','2022-08-18','2022-08-18 15:18:02','2022-08-19 15:18:02','461',2674159.00,2674159.00,'461','2022-08-18 15:23:31','913','2022-08-18 16:40:37',10,0),('1','116',257843,'AFTERNOON SHIFT','2022-08-18','2022-08-19 09:30:45','2022-08-20 09:30:45','461',2684363.35,2684363.35,'461','2022-08-19 10:02:22','913','2022-08-19 10:09:43',10,0),('1','116',257844,'MORNING SHIFT','2022-08-19','2022-08-19 14:42:50','2022-08-20 14:42:50','461',1764731.65,1764731.65,'461','2022-08-19 14:53:53','913','2022-08-19 16:21:01',10,0),('1','116',257845,'AFTERNOON SHIFT','2022-08-19','2022-08-20 09:01:47','2022-08-21 09:01:47','461',2233092.45,2233092.45,'461','2022-08-20 09:11:14','913','2022-08-20 11:00:01',10,0),('1','116',257846,'MORNING SHIFT','2022-08-20','2022-08-20 15:08:41','2022-08-21 15:08:41','461',2530485.25,2530485.25,'461','2022-08-20 15:14:22','913','2022-08-20 15:41:32',10,0),('1','116',257847,'AFTERNOON SHIFT','2022-08-20','2022-08-21 09:24:20','2022-08-22 09:24:20','461',2077878.90,2077878.90,'461','2022-08-21 09:35:00','913','2022-08-21 12:36:17',10,0),('1','116',257848,'MORNING SHIFT','2022-08-21','2022-08-21 14:31:52','2022-08-22 14:31:52','461',1382181.70,1382181.70,'461','2022-08-21 14:36:12','913','2022-08-21 16:49:32',10,0),('1','116',257849,'AFTERNOON SHIFT','2022-08-21','2022-08-22 08:31:53','2022-08-23 08:31:53','461',1943149.75,1943149.75,'461','2022-08-22 08:52:22','913','2022-08-22 09:13:02',10,0),('1','116',257850,'MORNING SHIFT','2022-08-22','2022-08-22 14:41:31','2022-08-23 14:41:31','461',1576066.05,1576066.05,'461','2022-08-22 14:46:23','913','2022-08-22 15:17:33',10,0),('1','116',257851,'AFTERNOON SHIFT','2022-08-22','2022-08-23 11:44:07','2022-08-24 11:44:07','461',756944.15,756944.15,'461','2022-08-23 11:49:51','913','2022-08-23 11:53:24',10,0),('1','116',257852,'AFTERNOON SHIFT','2022-08-23','2022-08-24 06:38:12','2022-08-25 06:38:12','461',1566767.55,1566767.55,'461','2022-08-24 06:49:42','913','2022-08-24 09:11:14',10,0),('1','116',257853,'AFTERNOON SHIFT','2022-08-24','2022-08-25 06:14:55','2022-08-26 06:14:55','461',1947358.10,1947358.10,'461','2022-08-25 06:26:44','761','2022-08-25 11:13:16',10,0),('1','116',257854,'MORNING SHIFT','2022-08-25','2022-08-25 14:06:56','2022-08-26 14:06:56','461',1600147.05,1600147.05,'461','2022-08-25 14:09:56','913','2022-08-25 14:28:52',10,0),('1','116',257855,'AFTERNOON SHIFT','2022-08-25','2022-08-26 07:08:27','2022-08-27 07:08:27','461',2003782.95,2003782.95,'461','2022-08-26 07:13:40','913','2022-08-26 11:03:27',10,0),('1','116',257856,'MORNING SHIFT','2022-08-26','2022-08-26 14:34:59','2022-08-27 14:34:59','461',1521425.20,1521425.20,'461','2022-08-26 14:38:18','913','2022-08-26 15:37:27',10,0),('1','116',257857,'AFTERNOON SHIFT','2022-08-26','2022-08-27 06:59:44','2022-08-28 06:59:44','461',515685.65,515685.65,'461','2022-08-27 07:05:39','913','2022-08-27 08:15:00',10,0),('1','116',257858,'AFTERNOON SHIFT','2022-08-28','2022-08-29 06:30:47','2022-08-30 06:30:47','461',802892.60,802892.60,'461','2022-08-29 06:38:18','761','2022-08-29 09:27:36',10,0),('1','116',257859,'MORNING SHIFT','2022-08-29','2022-08-29 13:36:49','2022-08-30 13:36:49','461',1408329.15,1408329.15,'461','2022-08-29 13:39:20','913','2022-08-29 16:58:30',10,0),('1','116',257860,'AFTERNOON SHIFT','2022-08-29','2022-08-29 19:24:42','2022-08-30 19:24:42','461',672674.80,672674.80,'461','2022-08-30 10:53:03','761','2022-08-30 11:04:59',10,0),('1','116',257861,'MORNING SHIFT','2022-08-31','2022-08-31 14:53:19','2022-09-01 14:53:19','461',2250874.65,2250874.65,'461','2022-08-31 14:58:03','913','2022-08-31 15:59:32',10,0),('1','116',257862,'AFTERNOON SHIFT','2022-08-31','2022-08-31 21:25:49','2022-09-01 21:25:49','461',2386509.25,2386509.25,'461','2022-08-31 21:28:03','913','2022-09-01 00:13:08',10,0),('1','116',257863,'MORNING SHIFT','2022-09-01','2022-09-01 15:25:53','2022-09-02 15:25:53','461',4131906.00,4131906.00,'461','2022-09-01 15:35:50','913','2022-09-01 17:32:24',10,0),('1','116',257864,'AFTERNOON SHIFT','2022-09-01','2022-09-02 09:15:45','2022-09-03 09:15:45','461',2278422.90,2278422.90,'461','2022-09-02 09:30:36','913','2022-09-02 10:38:55',10,0),('1','116',257865,'MORNING SHIFT','2022-09-02','2022-09-02 15:04:07','2022-09-03 15:04:07','461',2249043.15,2249043.15,'461','2022-09-02 15:20:46','913','2022-09-02 15:30:34',10,0),('1','116',257866,'AFTERNOON SHIFT','2022-09-02','2022-09-03 08:30:12','2022-09-04 08:30:12','461',2934946.30,2934946.30,'461','2022-09-03 08:43:54','913','2022-09-03 12:40:25',10,0),('1','116',257867,'MORNING SHIFT','2022-09-03','2022-09-03 14:51:56','2022-09-04 14:51:56','461',2197734.95,2197734.95,'461','2022-09-03 14:57:46','913','2022-09-03 18:09:24',10,0),('1','116',257868,'AFTERNOON SHIFT','2022-09-03','2022-09-04 11:39:00','2022-09-05 11:39:00','461',762760.85,762760.85,'461','2022-09-04 11:41:41','913','2022-09-04 12:07:15',10,0),('1','116',257869,'MORNING SHIFT','2022-09-05','2022-09-05 14:42:21','2022-09-06 14:42:21','461',1762313.65,1762313.65,'461','2022-09-05 14:47:58','913','2022-09-05 14:54:44',10,0),('1','116',257870,'AFTERNOON SHIFT','2022-09-05','2022-09-05 21:47:10','2022-09-06 21:47:10','461',2703242.45,2703242.45,'461','2022-09-05 21:59:05','913','2022-09-05 23:23:26',10,0),('1','116',257871,'MORNING SHIFT','2022-09-06','2022-09-06 14:24:26','2022-09-07 14:24:26','461',1775895.70,1775895.70,'461','2022-09-06 14:36:44','913','2022-09-06 14:40:49',10,0),('1','116',257872,'AFTERNOON SHIFT','2022-09-06','2022-09-06 21:30:50','2022-09-07 21:30:50','461',2419301.25,2419301.25,'461','2022-09-06 21:34:11','913','2022-09-07 11:39:39',10,0),('1','116',257873,'MORNING SHIFT','2022-09-07','2022-09-07 15:06:12','2022-09-08 15:06:12','461',2773399.10,2773399.10,'461','2022-09-07 15:12:49','913','2022-09-07 18:05:43',10,0),('1','116',257874,'AFTERNOON','2022-09-07','2022-09-07 18:44:35','2022-09-08 18:44:35','461',2000040.50,2000040.50,'461','2022-09-07 21:43:59','913','2022-09-07 22:25:09',10,0),('1','116',257875,'MORNING SHIFT','2022-09-08','2022-09-08 14:54:19','2022-09-09 14:54:19','461',1675238.25,1675238.25,'461','2022-09-08 15:40:20','913','2022-09-08 15:58:34',10,0),('1','116',257876,'AFTERNOON SHIFT','2022-09-08','2022-09-08 21:50:11','2022-09-09 21:50:11','461',2318579.10,2318579.10,'461','2022-09-08 21:57:38','913','2022-09-08 22:22:45',10,0),('1','116',257877,'MORNING SHIFT','2022-09-09','2022-09-09 15:28:20','2022-09-10 15:28:20','461',1751504.15,1751504.15,'461','2022-09-09 15:31:45','913','2022-09-09 15:55:06',10,0),('1','116',257878,'AFTERNOON SHIFT','2022-09-09','2022-09-10 06:31:29','2022-09-11 06:31:29','461',1818844.15,1818844.15,'461','2022-09-10 06:38:56','913','2022-09-10 10:52:09',10,0),('1','116',257879,'MORNING SHIFT','2022-09-10','2022-09-10 14:23:49','2022-09-11 14:23:49','461',2726910.70,2726910.70,'461','2022-09-10 15:16:39','913','2022-09-10 15:45:16',10,0),('1','116',257880,'AFTERNOON SHIFT','2022-09-10','2022-09-11 06:23:46','2022-09-12 06:23:46','461',2111299.35,2111299.35,'461','2022-09-11 06:31:31','913','2022-09-11 08:47:35',10,0),('1','116',257881,'MORNING SHIFT','2022-09-11','2022-09-11 14:01:55','2022-09-12 14:01:55','461',1268106.55,1268106.55,'461','2022-09-11 14:06:47','913','2022-09-11 14:43:56',10,0),('1','116',257882,'MORNING SHIFT','2022-09-12','2022-09-12 15:25:52','2022-09-13 15:25:52','461',848607.10,848607.10,'461','2022-09-12 15:39:53','913','2022-09-12 16:27:36',10,0),('1','116',257883,'AFTERNOON SHIFT','2022-09-12','2022-09-12 21:26:13','2022-09-13 21:26:13','461',2042838.20,2042838.20,'461','2022-09-12 21:40:51','913','2022-09-12 21:41:24',10,0),('1','116',257884,'MORNING SHIFT','2022-09-13','2022-09-13 14:32:41','2022-09-14 14:32:41','461',1752583.65,1752583.65,'461','2022-09-13 14:39:24','913','2022-09-13 15:34:37',10,0),('1','116',257885,'AFTERNOON SHIFT','2022-09-13','2022-09-13 21:38:49','2022-09-14 21:38:49','461',1929558.25,1929558.25,'461','2022-09-13 21:42:38','913','2022-09-13 22:00:20',10,0),('1','116',257886,'MORNING SHIFT','2022-09-14','2022-09-14 14:40:22','2022-09-15 14:40:22','461',1780865.00,1780865.00,'461','2022-09-14 14:46:32','913','2022-09-14 15:22:48',10,0),('1','116',257887,'AFTERNOON SHIFT','2022-09-14','2022-09-15 11:30:23','2022-09-16 11:30:23','461',1753912.60,1753912.60,'461','2022-09-15 11:35:34','913','2022-09-15 11:37:04',10,0),('1','116',257888,'MORNING SHIFT','2022-09-15','2022-09-15 14:23:48','2022-09-16 14:23:48','461',1662345.25,1662345.25,'461','2022-09-15 14:28:21','913','2022-09-15 16:02:34',10,0),('1','116',257889,'AFTERNOON SHIFT','2022-09-15','2022-09-16 07:12:17','2022-09-17 07:12:17','461',3373044.45,3373044.45,'461','2022-09-16 07:34:10','913','2022-09-16 10:14:57',10,0),('1','116',257890,'MORNING SHIFT','2022-09-16','2022-09-16 15:52:00','2022-09-17 15:52:00','461',0.00,0.00,'461','2022-09-16 16:21:57','913','2022-09-16 16:22:47',10,0),('1','116',257891,'MORNING SHIFT','2022-09-16','2022-09-16 16:23:41','2022-09-17 16:23:41','461',1773552.65,1773552.65,'461','2022-09-16 16:28:53','761','2022-09-16 21:03:12',10,0),('1','116',257892,'AFTERNOON SHIFT','2022-09-16','2022-09-17 12:08:57','2022-09-18 12:08:57','461',394227.60,394227.60,'461','2022-09-17 12:15:05','913','2022-09-17 17:18:13',10,0),('1','116',257893,'MORNING SHIFT','2022-09-22','2022-09-22 14:35:08','2022-09-23 14:35:08','461',1054162.15,1054162.15,'461','2022-09-22 14:40:40','913','2022-09-22 15:17:51',10,0),('1','116',257894,'AFTERNOON SHIFT','2022-09-22','2022-09-23 06:08:47','2022-09-24 06:08:47','461',1743351.20,1743351.20,'461','2022-09-23 06:23:20','761','2022-09-23 10:10:00',10,0),('1','116',257895,'MORNING SHIFT','2022-09-23','2022-09-23 14:42:18','2022-09-24 14:42:18','461',1387135.55,1387135.55,'461','2022-09-23 14:47:55','913','2022-09-23 15:34:34',10,0),('1','116',257896,'AFTERNOON SHIFT','2022-09-23','2022-09-24 06:02:27','2022-09-25 06:02:27','461',2186107.95,2186107.95,'461','2022-09-24 06:28:00','913','2022-09-24 08:34:51',10,0),('1','116',257897,'MORNING SHIFT','2022-09-24','2022-09-24 13:53:35','2022-09-25 13:53:35','461',1443186.85,1443186.85,'461','2022-09-24 14:01:00','913','2022-09-24 16:35:59',10,0),('1','116',257898,'AFTERNOON SHIFT','2022-09-24','2022-09-25 07:58:35','2022-09-26 07:58:35','461',983419.30,983419.30,'461','2022-09-25 08:18:12','913','2022-09-25 11:37:25',10,0),('1','116',257899,'MORNING SHIFT','2022-09-26','2022-09-26 14:17:33','2022-09-27 14:17:33','461',1545554.75,1545554.75,'461','2022-09-26 14:23:07','913','2022-09-26 15:35:31',10,0),('1','116',257900,'AFTERNOON SHIFT','2022-09-26','2022-09-27 06:48:31','2022-09-28 06:48:31','461',1789133.55,1789133.55,'461','2022-09-27 08:22:03','913','2022-09-27 11:24:08',10,0),('1','116',257901,'MORNING SHIFT','2022-09-27','2022-09-27 15:00:21','2022-09-28 15:00:21','461',1686458.15,1686458.15,'461','2022-09-27 15:07:34','913','2022-09-27 15:42:43',10,0),('1','116',257902,'AFTERNOON SHIFT','2022-09-29','2022-09-30 08:03:54','2022-10-01 08:03:54','461',1322728.00,1322728.00,'461','2022-09-30 08:06:35','913','2022-09-30 09:36:38',10,0),('1','116',257903,'AFTERNOON SHIFT','2022-10-04','2022-10-05 08:10:16','2022-10-06 08:10:16','461',2236465.20,2236465.20,'461','2022-10-05 08:53:05','913','2022-10-05 08:55:54',10,0),('1','116',257904,'AFTERNOON SHIFT','2022-10-07','2022-10-08 11:17:56','2022-10-09 11:17:56','461',923030.75,923030.75,'461','2022-10-08 11:26:39','913','2022-10-08 12:58:05',10,0),('1','116',257905,'AFTERNOON SHIFT','2022-10-08','2022-10-09 08:19:47','2022-10-10 08:19:47','461',452652.30,452652.30,'461','2022-10-09 08:23:33','913','2022-10-09 08:41:44',10,0),('1','116',257906,'AFTERNOON SHIFT','2022-10-11','2022-10-11 18:35:32','2022-10-12 18:35:32','461',755982.60,755982.60,'461','2022-10-11 18:38:50','913','2022-10-11 18:41:46',10,0),('1','116',257907,'MORNING SHIFT','2022-10-12','2022-10-12 18:28:13','2022-10-13 18:28:13','461',38802.40,38802.40,'461','2022-10-12 18:30:49','913','2022-10-12 23:49:08',10,0),('1','116',257908,'AFTERNOON SHIFT','2022-10-14','2022-10-15 07:38:42','2022-10-16 07:38:42','461',408965.90,408965.90,'461','2022-10-15 07:46:17','913','2022-10-15 10:09:27',10,0),('1','116',257909,'MORNING SHIFT','2022-10-16','2022-10-16 15:19:13','2022-10-17 15:19:13','461',3030962.90,3030962.90,'461','2022-10-16 15:44:26','913','2022-10-16 17:37:00',10,0),('1','116',257910,'AFTERNOON SHIFT','2022-10-16','2022-10-16 18:55:46','2022-10-17 18:55:46','461',1626922.80,1626922.80,'461','2022-10-16 19:04:03','913','2022-10-16 21:49:34',10,0),('1','116',257911,'MORNING SHIFT','2022-10-17','2022-10-17 15:27:00','2022-10-18 15:27:00','461',1599798.65,1599798.65,'461','2022-10-17 15:33:14','913','2022-10-17 15:42:07',10,0),('1','116',257912,'AFTERNOON SHIFT','2022-10-18','2022-10-18 19:16:28','2022-10-19 19:16:28','461',1581416.75,1581416.75,'461','2022-10-18 19:22:57','913','2022-10-18 20:11:14',10,0),('1','116',257913,'AFTERNOON SHIFT','2022-10-19','2022-10-19 19:17:23','2022-10-20 19:17:23','461',188347.25,188347.25,'461','2022-10-19 19:19:27','913','2022-10-19 19:48:49',10,0),('1','116',257914,'MORNING SHIFT','2022-10-20','2022-10-20 14:30:05','2022-10-21 14:30:05','461',2351781.60,2351781.60,'461','2022-10-20 14:34:01','913','2022-10-20 15:14:27',10,0),('1','116',257915,'AFTERNOON SHIFT','2022-10-20','2022-10-20 19:49:41','2022-10-21 19:49:41','461',1431188.20,1431188.20,'461','2022-10-21 08:47:01','913','2022-10-21 09:47:06',10,0),('1','116',257916,'MORNING SHIFT','2022-10-21','2022-10-21 14:36:49','2022-10-22 14:36:49','461',743102.45,743102.45,'461','2022-10-21 14:41:14','913','2022-10-21 15:39:32',10,0),('1','116',257917,'AFTERNOON SHIFT','2022-10-21','2022-10-21 19:56:31','2022-10-22 19:56:31','461',1436423.50,1436423.50,'461','2022-10-22 09:37:02','913','2022-10-22 11:05:55',10,0),('1','116',257918,'MORNING SHIFT','2022-10-22','2022-10-22 15:19:01','2022-10-23 15:19:01','461',1223529.15,1223529.15,'461','2022-10-22 15:24:44','913','2022-10-22 16:07:11',10,0),('1','116',257919,'AFTERNOON SHIFT','2022-10-22','2022-10-23 10:23:29','2022-10-24 10:23:29','461',302116.10,302116.10,'461','2022-10-23 10:33:31','913','2022-10-23 12:41:55',10,0),('1','116',257920,'MORNING SHIFT','2022-10-23','2022-10-23 16:09:26','2022-10-24 16:09:26','461',731462.25,731462.25,'461','2022-10-23 16:45:43','913','2022-10-23 21:26:18',10,0),('1','116',257921,'AFTERNOON SHIFT','2022-10-23','2022-10-24 09:53:16','2022-10-25 09:53:16','461',2270738.80,2270738.80,'461','2022-10-24 10:00:15','913','2022-10-24 10:25:14',10,0),('1','116',257922,'MORNING SHIFT','2022-10-24','2022-10-24 14:15:58','2022-10-25 14:15:58','461',1085883.40,1085883.40,'461','2022-10-24 14:21:40','913','2022-10-24 15:19:33',10,0),('1','116',257923,'AFTERNOON SHIFT','2022-10-24','2022-10-25 09:48:59','2022-10-26 09:48:59','461',807665.60,807665.60,'461','2022-10-25 09:53:51','913','2022-10-25 09:57:54',10,0),('1','116',257924,'MORNING SHIFT','2022-10-25','2022-10-25 14:28:09','2022-10-26 14:28:09','461',830361.40,830361.40,'461','2022-10-25 14:32:42','913','2022-10-25 15:25:08',10,0),('1','116',257925,'AFTERNOON SHIFT','2022-10-25','2022-10-26 08:54:07','2022-10-27 08:54:07','461',3167594.75,3167594.75,'461','2022-10-26 09:02:25','913','2022-10-26 09:24:32',10,0),('1','116',257926,'AFTERNOON SHIFT','2022-10-27','2022-10-28 07:55:04','2022-10-29 07:55:04','461',1699049.40,1699049.40,'461','2022-10-28 08:01:13','913','2022-10-28 10:16:36',10,0),('1','116',257927,'MORNING SHIFT','2022-10-28','2022-10-28 14:38:33','2022-10-29 14:38:33','461',1336669.40,1336669.40,'461','2022-10-28 14:44:29','913','2022-10-28 16:27:45',10,0),('1','116',257928,'AFTERNOON SHIFT','2022-10-28','2022-10-29 08:44:30','2022-10-30 08:44:30','461',1408395.75,1408395.75,'461','2022-10-29 08:52:02','913','2022-10-29 09:38:10',10,0),('1','116',257929,'MORNING SHIFT','2022-10-29','2022-10-29 15:28:16','2022-10-30 15:28:16','461',1435122.70,1435122.70,'461','2022-10-29 15:34:19','913','2022-10-29 16:29:01',10,0),('1','116',257930,'AFTERNOON SHIFT','2022-10-30','2022-10-31 09:02:17','2022-11-01 09:02:17','461',1734125.25,1734125.25,'461','2022-10-31 09:07:28','913','2022-10-31 11:09:58',10,0),('1','116',257931,'AFTERNOON SHIFT','2022-10-31','2022-11-01 09:19:46','2022-11-02 09:19:46','461',899208.10,899208.10,'461','2022-11-01 09:26:51','913','2022-11-01 09:50:33',10,0),('1','116',257932,'MORNING SHIFT','2022-11-01','2022-11-01 15:52:59','2022-11-02 15:52:59','461',4303839.90,4303839.90,'461','2022-11-01 16:01:54','913','2022-11-01 16:28:04',10,0),('1','116',257933,'AFTERNOON SHIFT','2022-11-01','2022-11-02 10:17:13','2022-11-03 10:17:13','461',3069543.75,3069543.75,'461','2022-11-02 10:30:14','913','2022-11-02 12:44:53',10,0),('1','116',257934,'MORNING SHIFT','2022-11-02','2022-11-02 14:17:23','2022-11-03 14:17:23','461',2093161.20,2093161.20,'461','2022-11-02 14:24:40','913','2022-11-02 17:04:43',10,0),('1','116',257935,'AFTERNOON SHIFT','2022-11-02','2022-11-03 08:24:28','2022-11-04 08:24:28','461',2711260.50,2711260.50,'461','2022-11-03 08:35:29','913','2022-11-03 10:52:55',10,0),('1','116',257936,'MORNING SHIFT','2022-11-03','2022-11-03 13:47:46','2022-11-04 13:47:46','461',2239194.75,2239194.75,'461','2022-11-03 13:53:40','913','2022-11-03 15:39:51',10,0),('1','116',257937,'MORNING SHIFT','2022-11-05','2022-11-05 13:10:33','2022-11-06 13:10:33','461',807128.40,807128.40,'461','2022-11-05 13:15:00','913','2022-11-05 14:17:25',10,0),('1','116',257938,'MORNING SHIFT','2022-11-07','2022-11-07 14:32:05','2022-11-08 14:32:05','461',1929051.15,1929051.15,'461','2022-11-07 14:37:29','913','2022-11-07 17:41:13',10,0),('1','116',257939,'AFTERNOON SHIFT','2022-11-07','2022-11-08 09:24:59','2022-11-09 09:24:59','461',3464656.65,3464656.65,'461','2022-11-08 09:31:03','913','2022-11-08 10:05:19',10,0),('1','116',257940,'MORNING SHIFT','2022-11-08','2022-11-08 13:33:09','2022-11-09 13:33:09','461',1544113.35,1544113.35,'461','2022-11-08 13:39:23','913','2022-11-08 14:40:27',10,0),('1','116',257941,'MORNING SHIFT ','2022-11-11','2022-11-11 15:25:20','2022-11-12 15:25:20','461',2241497.70,2241497.70,'461','2022-11-11 15:38:48','913','2022-11-11 16:25:08',10,0),('1','116',257942,'AFTERNOON SHIFT','2022-11-11','2022-11-12 08:58:39','2022-11-13 08:58:39','461',3177051.15,3177051.15,'461','2022-11-12 09:09:01','913','2022-11-12 10:39:21',10,0),('1','116',257943,'MORNING SHIFT','2022-11-12','2022-11-12 12:23:50','2022-11-13 12:23:50','461',1158048.45,1158048.45,'461','2022-11-12 12:30:05','913','2022-11-12 16:49:35',10,0),('1','116',257944,'AFTERNOON SHIFT','2022-11-12','2022-11-13 10:22:30','2022-11-14 10:22:30','461',796602.30,796602.30,'461','2022-11-13 10:25:19','913','2022-11-13 11:52:06',10,0),('1','116',257945,'MORNING SHIFT','2022-11-13','2022-11-13 12:37:52','2022-11-14 12:37:52','461',1595963.85,1595963.85,'461','2022-11-13 13:25:55','913','2022-11-13 14:17:19',10,0),('1','116',257946,'AFTERNOON SHIFT','2022-11-13','2022-11-14 08:43:12','2022-11-15 08:43:12','461',3597305.40,3597305.40,'461','2022-11-14 08:50:09','913','2022-11-14 10:43:40',10,0),('1','116',257947,'MORNING SHIFT','2022-11-14','2022-11-14 12:48:15','2022-11-15 12:48:15','461',1629386.85,1629386.85,'461','2022-11-14 12:56:23','913','2022-11-14 14:40:22',10,0),('1','116',257948,'AFTERNOON SHIFT','2022-11-14','2022-11-15 08:52:04','2022-11-16 08:52:04','461',4751403.15,4751403.15,'461','2022-11-15 09:37:32','761','2022-11-15 10:28:29',10,0),('1','116',257949,'MORNING SHIFT ','2022-11-15','2022-11-15 13:55:56','2022-11-16 13:55:56','461',3309682.35,3309682.35,'461','2022-11-15 14:05:52','913','2022-11-15 16:50:29',10,0),('1','116',257950,'AFTERNOON SHIFT','2022-11-15','2022-11-16 09:10:49','2022-11-17 09:10:49','461',3193251.75,3193251.75,'461','2022-11-16 09:18:46','913','2022-11-16 10:46:07',10,0),('1','116',257951,'MORNING SHIFT','2022-11-19','2022-11-19 17:41:15','2022-11-20 17:41:15','461',1605561.75,1605561.75,'461','2022-11-19 17:56:01','913','2022-11-20 00:14:04',10,0),('1','116',257952,'MORNING SHIFT','2022-11-20','2022-11-20 13:14:40','2022-11-21 13:14:40','461',1333394.40,1333394.40,'461','2022-11-20 13:20:40','913','2022-11-20 14:58:42',10,0),('1','116',257953,'AFTERNOON SHIFT','2022-11-20','2022-11-21 08:02:29','2022-11-22 08:02:29','461',3482345.10,3482345.10,'461','2022-11-21 08:08:50','913','2022-11-21 08:56:59',10,0),('1','116',257954,'MORNING SHIFT','2022-11-21','2022-11-21 14:56:42','2022-11-22 14:56:42','461',4278994.20,4278994.20,'461','2022-11-21 15:01:44','913','2022-11-21 15:33:36',10,0),('1','116',257955,'AFTERNOON SHIFT','2022-11-21','2022-11-22 08:08:35','2022-11-23 08:08:35','461',4042876.50,4042876.50,'461','2022-11-22 08:20:45','913','2022-11-22 10:23:59',10,0),('1','116',257956,'MORNING SHIFT','2022-11-24','2022-11-24 13:48:28','2022-11-25 13:48:28','461',1582545.90,1582545.90,'461','2022-11-24 13:56:24','913','2022-11-24 15:09:34',10,0),('1','116',257957,'AFTERNOON SHIFT','2022-11-24','2022-11-25 08:36:31','2022-11-26 08:36:31','461',3411472.35,3411472.35,'461','2022-11-25 08:43:54','913','2022-11-25 11:07:02',10,0),('1','116',257958,'MORNING SHIFT','2022-11-25','2022-11-25 13:41:56','2022-11-26 13:41:56','461',2856307.35,2856307.35,'461','2022-11-25 13:44:20','913','2022-11-25 14:48:03',10,0),('1','116',257959,'AFTERNOON SHIFT','2022-11-25','2022-11-26 08:41:31','2022-11-27 08:41:31','461',2449211.70,2449211.70,'461','2022-11-26 08:47:11','913','2022-11-26 12:31:29',10,0),('1','116',257960,'MORNING SHIFT','2022-11-26','2022-11-26 13:23:53','2022-11-27 13:23:53','461',1402707.15,1402707.15,'461','2022-11-26 13:39:23','913','2022-11-26 16:58:35',10,0),('1','116',257961,'AFTERNOON SHIFT','2022-12-03','2022-12-03 19:19:38','2022-12-04 19:19:38','461',462772.05,462772.05,'461','2022-12-04 10:12:31','913','2022-12-04 10:36:42',10,0),('1','116',257962,'MORNING SHIFT','2022-12-08','2022-12-08 14:15:07','2022-12-09 14:15:07','461',46039.50,46039.50,'461','2022-12-08 16:53:32','913','2022-12-08 17:24:23',10,0),('1','116',257963,'MORNING SHIFT','2022-12-10','2022-12-10 14:37:22','2022-12-11 14:37:22','461',4714355.10,4714355.10,'461','2022-12-10 14:46:21','913','2022-12-10 14:49:36',10,0),('1','116',257964,'AFTERNOON SHIFT','2022-12-10','2022-12-11 09:27:03','2022-12-12 09:27:03','461',4870779.90,4870779.90,'461','2022-12-11 09:44:44','913','2022-12-11 09:57:56',10,0),('1','116',257965,'MORNING SHIFT','2022-12-11','2022-12-11 13:26:18','2022-12-12 13:26:18','461',562281.30,562281.30,'461','2022-12-11 13:30:20','913','2022-12-11 13:34:29',10,0),('1','116',257966,'AFTERNOON SHIFT','2022-12-11','2022-12-11 18:55:40','2022-12-12 18:55:40','461',1886936.10,1886936.10,'461','2022-12-11 19:11:34','913','2022-12-11 20:55:36',10,0),('1','116',257967,'MORNING SHIFT','2022-12-13','2022-12-13 13:33:06','2022-12-14 13:33:06','461',1019043.90,1019043.90,'461','2022-12-13 13:36:16','913','2022-12-13 14:29:43',10,0),('1','116',257968,'AFTERNOON SHIFT','2022-12-13','2022-12-14 08:55:30','2022-12-15 08:55:30','461',4048892.40,4048892.40,'461','2022-12-14 09:04:56','913','2022-12-14 10:13:39',10,0),('1','116',257969,'MORNING SHIFT','2022-12-14','2022-12-14 14:44:56','2022-12-15 14:44:56','461',1101601.20,1101601.20,'461','2022-12-14 14:50:31','913','2022-12-14 16:13:02',10,0),('1','116',257970,'AFTERNOON SHIFT','2022-12-14','2022-12-15 08:31:55','2022-12-16 08:31:55','461',1036501.20,1036501.20,'461','2022-12-15 08:39:18','913','2022-12-15 11:31:02',10,0),('1','116',257971,'AFTERNOON SHIFT','2022-12-16','2022-12-16 18:17:40','2022-12-17 18:17:40','461',248673.60,248673.60,'461','2022-12-16 18:52:16','913','2022-12-16 19:36:19',10,0),('1','116',257972,'MORNING SHIFT','2022-12-17','2022-12-17 16:01:44','2022-12-18 16:01:44','461',4380843.60,4380843.60,'461','2022-12-17 16:07:30','913','2022-12-17 17:51:41',10,0),('1','116',257973,'AFTERNOON SHIFT','2022-12-17','2022-12-17 18:11:49','2022-12-18 18:11:49','461',1721374.20,1721374.20,'461','2022-12-17 18:25:41','913','2022-12-18 03:56:38',10,0),('1','116',257974,'AFTERNOON SHIFT','2022-12-18','2022-12-19 10:24:45','2022-12-20 10:24:45','461',181437.90,181437.90,'461','2022-12-19 10:42:43','913','2022-12-19 16:17:32',10,0),('1','116',257975,'AFTERNOON SHIFT','2022-12-19','2022-12-19 18:15:33','2022-12-20 18:15:33','461',78966.30,78966.30,'461','2022-12-19 18:17:07','913','2022-12-19 18:21:33',10,0),('1','116',257976,'MORNING SHIFT','2022-12-20','2022-12-20 13:44:54','2022-12-21 13:44:54','461',3128059.20,3128059.20,'461','2022-12-20 13:49:51','913','2022-12-20 14:43:55',10,0),('1','116',257977,'AFTERNOON SHIFT','2022-12-20','2022-12-21 09:21:54','2022-12-22 09:21:54','461',5909220.50,5909220.50,'461','2022-12-21 09:39:40','913','2022-12-21 10:42:25',10,0),('1','116',257978,'MORNING SHIFT','2022-12-21','2022-12-21 12:50:41','2022-12-22 12:50:41','461',3372001.50,3372001.50,'461','2022-12-21 13:06:08','913','2022-12-21 15:31:17',10,0),('1','116',257979,'AFTERNOON SHIFT','2022-12-21','2022-12-22 08:50:42','2022-12-23 08:50:42','461',4660513.30,4660513.30,'461','2022-12-22 09:03:17','913','2022-12-22 09:22:45',10,0),('1','116',257980,'MORNING SHIFT','2022-12-22','2022-12-22 16:14:39','2022-12-23 16:14:39','461',6555161.20,6555161.20,'461','2022-12-22 16:19:28','913','2022-12-22 16:35:56',10,0),('1','116',257981,'AFTERNOON SHIFT','2022-12-22','2022-12-23 08:49:44','2022-12-24 08:49:44','461',4732825.50,4732825.50,'461','2022-12-23 09:03:22','913','2022-12-23 09:19:42',10,0),('1','116',257982,'AFTERNOON SHIFT','2022-12-23','2022-12-24 11:06:59','2022-12-25 11:06:59','461',1626854.80,1626854.80,'461','2022-12-24 11:14:33','913','2022-12-24 12:21:50',10,0),('1','116',257983,'AFTERNOON SHIFT','2022-12-24','2022-12-25 11:16:20','2022-12-26 11:16:20','461',138047.80,138047.80,'461','2022-12-25 11:18:10','913','2022-12-25 15:26:12',10,0),('1','116',257984,'MORNING SHIFT','2022-12-25','2022-12-25 15:38:35','2022-12-26 15:38:35','461',5505363.60,5505363.60,'461','2022-12-25 16:05:28','913','2022-12-25 22:41:25',10,0),('1','116',257985,'AFTERNOON SHIFT','2022-12-25','2022-12-26 08:50:29','2022-12-27 08:50:29','461',7709851.60,7709851.60,'461','2022-12-26 08:55:37','913','2022-12-26 11:00:54',10,0),('1','116',257986,'MORNING SHIFT','2022-12-27','2022-12-27 14:59:32','2022-12-28 14:59:32','461',5311270.80,5311270.80,'461','2022-12-27 15:08:46','913','2022-12-27 16:04:43',10,0),('1','116',257987,'AFTERNOON SHIFT','2022-12-27','2022-12-28 09:57:14','2022-12-29 09:57:14','461',3855284.40,3855284.40,'461','2022-12-28 10:20:50','913','2022-12-28 11:13:39',10,0),('1','116',257988,'MORNING SHIFT','2022-12-28','2022-12-28 15:40:08','2022-12-29 15:40:08','461',5680125.00,5680125.00,'461','2022-12-28 16:12:20','913','2022-12-28 16:28:46',10,0),('1','116',257989,'AFTERNOON SHIFT','2022-12-28','2022-12-29 11:07:36','2022-12-30 11:07:36','461',2995462.80,2995462.80,'461','2022-12-29 11:34:09','913','2022-12-29 11:41:41',10,0),('1','116',257990,'MORNING SHIFT','2022-12-29','2022-12-29 15:14:08','2022-12-30 15:14:08','461',4360074.40,4360074.40,'461','2022-12-29 15:29:02','913','2022-12-29 16:30:34',10,0),('1','116',257991,'AFTERNOON SHIFT','2022-12-29','2022-12-30 09:09:59','2022-12-31 09:09:59','461',3593279.80,3593279.80,'461','2022-12-30 09:18:12','913','2022-12-30 10:40:27',10,0),('1','116',257992,'MORNING SHIFT','2022-12-30','2022-12-30 13:15:10','2022-12-31 13:15:10','461',4175820.00,4175820.00,'461','2022-12-30 14:36:19','913','2022-12-30 15:25:01',10,0),('1','116',257993,'AFTERNOON SHIFT','2022-12-30','2022-12-31 10:13:37','2023-01-01 10:13:37','461',4448556.20,4448556.20,'461','2022-12-31 10:23:00','913','2022-12-31 11:59:58',10,0),('1','116',257994,'MORNING SHIFT','2022-12-31','2022-12-31 14:21:34','2023-01-01 14:21:34','461',3853872.00,3853872.00,'461','2022-12-31 14:26:28','913','2022-12-31 15:23:58',10,0),('1','116',257995,'AFTERNOON SHIFT','2022-12-31','2022-12-31 16:16:11','2023-01-01 16:16:11','461',5019773.00,5019773.00,'461','2022-12-31 21:11:59','913','2022-12-31 21:24:42',10,0),('1','116',257996,'MORNING SHIFT','2023-01-01','2023-01-01 14:33:39','2023-01-02 14:33:39','461',3589293.40,3589293.40,'461','2023-01-01 14:38:41','913','2023-01-01 16:42:12',10,0),('1','116',257997,'AFTERNOON SHIFT','2023-01-01','2023-01-02 10:14:39','2023-01-03 10:14:39','461',3196274.40,3196274.40,'461','2023-01-02 10:42:48','913','2023-01-02 12:58:27',10,0),('1','116',257998,'MORNING SHIFT','2023-01-02','2023-01-02 14:44:47','2023-01-03 14:44:47','461',4257572.00,4257572.00,'461','2023-01-02 14:57:38','913','2023-01-02 16:23:37',10,0),('1','116',257999,'AFTERNOON SHIFT','2023-01-02','2023-01-02 16:24:22','2023-01-03 16:24:22','461',5379211.20,5379211.20,'461','2023-01-03 08:53:49','913','2023-01-03 12:05:32',10,0),('1','116',258000,'MORNING SHIFT','2023-01-03','2023-01-03 17:07:06','2023-01-04 17:07:06','461',4524260.40,4524260.40,'461','2023-01-03 17:19:14','913','2023-01-03 19:04:19',10,0),('1','116',258001,'AFTERNOON SHIFT','2023-01-03','2023-01-04 09:25:33','2023-01-05 09:25:33','461',3326272.40,3326272.40,'461','2023-01-04 09:34:49','913','2023-01-04 10:45:50',10,0),('1','116',258002,'MORNING SHIFT','2023-01-04','2023-01-04 13:52:57','2023-01-05 13:52:57','461',4423751.20,4423751.20,'461','2023-01-04 13:55:41','913','2023-01-04 15:30:52',10,0),('1','116',258003,'AFTERNOON SHIFT','2023-01-04','2023-01-05 09:04:36','2023-01-06 09:04:36','461',6415281.40,6415281.40,'461','2023-01-05 09:20:34','913','2023-01-05 10:37:54',10,0),('1','116',258004,'AFTERNOON SHIFT','2023-01-05','2023-01-05 12:48:05','2023-01-06 12:48:05','461',5956612.20,5956612.20,'461','2023-01-06 11:12:24','913','2023-01-06 11:15:30',10,0),('1','116',258005,'MORNING SHIFT','2023-01-06','2023-01-06 15:50:10','2023-01-07 15:50:10','461',4903021.20,4903021.20,'461','2023-01-06 15:57:43','913','2023-01-06 16:08:24',10,0),('1','116',258006,'AFTERNOON SHIFT','2023-01-06','2023-01-07 10:28:34','2023-01-08 10:28:34','461',4770161.00,4770161.00,'461','2023-01-07 10:37:00','913','2023-01-07 11:46:35',10,0),('1','116',258007,'MORNING SHIFT','2023-01-07','2023-01-07 14:37:12','2023-01-08 14:37:12','461',4424213.20,4424213.20,'461','2023-01-07 14:57:40','913','2023-01-07 16:10:05',10,0),('1','116',258008,'AFTERNOON SHIFT','2023-01-07','2023-01-08 10:51:32','2023-01-09 10:51:32','461',5805901.20,5805901.20,'461','2023-01-08 10:58:59','913','2023-01-08 12:20:19',10,0),('1','116',258009,'MORNING SHIFT','2023-01-08','2023-01-08 15:06:48','2023-01-09 15:06:48','461',3455304.60,3455304.60,'461','2023-01-08 15:21:23','913','2023-01-08 15:32:04',10,0),('1','116',258010,'AFTERNOON SHIFT','2023-01-08','2023-01-09 09:42:03','2023-01-10 09:42:03','461',5136588.60,5136588.60,'461','2023-01-09 09:52:33','913','2023-01-09 12:04:52',10,0),('1','116',258011,'MORNING SHIFT','2023-01-11','2023-01-11 14:04:38','2023-01-12 14:04:38','461',2596026.40,2596026.40,'461','2023-01-11 14:10:08','913','2023-01-11 15:17:37',10,0),('1','116',258012,'AFTERNOON SHIFT','2023-01-11','2023-01-12 08:37:44','2023-01-13 08:37:44','461',5228968.80,5228968.80,'461','2023-01-12 08:43:35','913','2023-01-12 11:38:23',10,0),('1','116',258013,'MORNING SHIFT','2023-01-12','2023-01-12 14:13:51','2023-01-13 14:13:51','461',2917039.40,2917039.40,'461','2023-01-12 14:19:59','913','2023-01-12 15:13:46',10,0),('1','116',258014,'MORNING SHIFT','2023-01-14','2023-01-14 13:27:22','2023-01-15 13:27:22','461',2540225.60,2540225.60,'461','2023-01-14 13:31:08','913','2023-01-14 15:55:37',10,0),('1','116',258015,'AFTERNOON SHIFT','2023-01-14','2023-01-15 10:18:25','2023-01-16 10:18:25','461',4155023.40,4155023.40,'461','2023-01-15 10:23:22','913','2023-01-15 11:09:57',10,0),('1','116',258016,'MORNING SHIFT','2023-01-16','2023-01-16 14:15:31','2023-01-17 14:15:31','461',6943305.60,6943305.60,'461','2023-01-16 14:31:11','913','2023-01-16 16:26:16',10,0),('1','116',258017,'AFTERNOON SHIFT','2023-01-17','2023-01-17 10:57:11','2023-01-18 10:57:11','461',0.00,0.00,'461','2023-01-17 10:57:57','913','2023-01-17 11:04:34',10,0),('1','116',258018,'AFTERNOON SHIFT','2023-01-16','2023-01-17 11:05:57','2023-01-18 11:05:57','461',4447940.20,4447940.20,'461','2023-01-17 11:10:49','913','2023-01-17 11:16:40',10,0),('1','116',258019,'MORNING SHIFT','2023-01-22','2023-01-22 15:14:43','2023-01-23 15:14:43','461',2292426.70,2292426.70,'461','2023-01-22 15:26:16','913','2023-01-22 15:32:44',10,0),('1','116',258020,'AFTERNOON SHIFT','2023-01-22','2023-01-23 10:50:10','2023-01-24 10:50:10','461',3053671.40,3053671.40,'461','2023-01-23 10:56:45','913','2023-01-23 11:30:45',10,0),('1','116',258021,'MORNING SHIFT','2023-01-23','2023-01-23 14:55:23','2023-01-24 14:55:23','461',1443051.30,1443051.30,'461','2023-01-23 15:08:50','913','2023-01-23 15:46:41',10,0),('1','116',258022,'AFTERNOON SHIFT','2023-01-23','2023-01-24 09:31:56','2023-01-25 09:31:56','461',7751308.50,7751308.50,'461','2023-01-24 09:47:54','761','2023-01-24 11:53:59',10,0),('1','116',258023,'MORNING SHIFT','2023-01-24','2023-01-24 15:25:55','2023-01-25 15:25:55','461',7196267.40,7196267.40,'461','2023-01-24 15:32:24','913','2023-01-24 17:26:24',10,0),('1','116',258024,'AFTERNOON SHIFT','2023-01-24','2023-01-25 08:04:07','2023-01-26 08:04:07','461',120879.60,120879.60,'461','2023-01-25 08:13:36','913','2023-01-25 08:17:12',10,0),('1','116',258025,'MORNING SHIFT','2023-01-25','2023-01-25 16:35:23','2023-01-26 16:35:23','461',2449605.40,2449605.40,'461','2023-01-25 16:39:12','913','2023-01-25 16:42:54',10,0),('1','116',258026,'AFTERNOON SHIFT','2023-01-25','2023-01-26 08:54:49','2023-01-27 08:54:49','461',6719046.80,6719046.80,'461','2023-01-26 09:03:54','761','2023-01-26 11:48:18',10,0),('1','116',258027,'MORNING SHIFT','2023-01-26','2023-01-26 16:27:33','2023-01-27 16:27:33','461',8485147.70,8485147.70,'461','2023-01-26 16:47:33','913','2023-01-26 20:06:07',10,0),('1','116',258028,'AFTERNOON SHIFT','2023-01-26','2023-01-27 09:34:12','2023-01-28 09:34:12','461',168412.60,168412.60,'461','2023-01-27 09:36:29','913','2023-01-27 10:32:44',10,0),('1','116',258029,'MORNING SHIFT','2023-01-28','2023-01-28 14:21:40','2023-01-29 14:21:40','461',60521.10,60521.10,'461','2023-01-28 14:23:33','761','2023-01-28 14:55:08',10,0),('1','116',258030,'MORNING SHIFT','2023-01-29','2023-01-29 17:57:45','2023-01-30 17:57:45','461',6821071.30,6821071.30,'461','2023-01-29 18:11:19','913','2023-01-29 18:34:55',10,0),('1','116',258031,'MORNING SHIFT','2023-01-30','2023-01-30 14:13:11','2023-01-31 14:13:11','461',6954323.70,6954323.70,'461','2023-01-30 14:22:29','913','2023-01-30 16:53:35',10,0),('1','116',258032,'AFTERNOON SHIFT','2023-01-30','2023-01-31 10:22:39','2023-02-01 10:22:39','461',3043800.20,3043800.20,'461','2023-01-31 10:39:19','913','2023-01-31 10:52:51',10,0),('1','116',258033,'MORNING SHIFT','2023-01-31','2023-01-31 15:21:10','2023-02-01 15:21:10','461',2451684.60,2451684.60,'461','2023-01-31 15:30:54','913','2023-01-31 16:29:44',10,0),('1','116',258034,'AFTERNOON SHIFT','2023-01-31','2023-01-31 22:39:55','2023-02-01 22:39:55','461',4962938.80,4962938.80,'461','2023-01-31 22:44:29','913','2023-02-01 01:37:27',10,0),('1','116',258035,'MORNING SHIFT','2023-02-01','2023-02-01 16:30:25','2023-02-02 16:30:25','461',2076643.60,2076643.60,'461','2023-02-01 16:42:10','913','2023-02-01 18:17:17',10,0),('1','116',258036,'AFTERNOON SHIFT','2023-02-01','2023-02-02 10:20:35','2023-02-03 10:20:35','461',2891818.80,2891818.80,'461','2023-02-02 10:36:47','913','2023-02-02 12:13:13',10,0),('1','116',258037,'MORNING SHIFT','2023-02-02','2023-02-02 17:59:33','2023-02-03 17:59:33','461',5341477.90,5341477.90,'461','2023-02-02 18:06:30','913','2023-02-02 19:29:36',10,0),('1','116',258038,'AFTERNOON SHIFT','2023-02-02','2023-02-03 11:01:50','2023-02-04 11:01:50','461',3779727.00,3779727.00,'461','2023-02-03 11:09:11','761','2023-02-03 12:33:28',10,0),('1','116',258039,'MORNING SHIFT','2023-02-03','2023-02-03 17:39:35','2023-02-04 17:39:35','461',4762692.20,4762692.20,'461','2023-02-03 17:47:17','913','2023-02-03 22:55:06',10,0),('1','116',258040,'AFTERNOON SHIFT','2023-02-03','2023-02-04 09:57:37','2023-02-05 09:57:37','461',0.00,0.00,'461','2023-02-04 10:15:02','913','2023-02-04 10:38:55',10,0),('1','116',258041,'AFTERNOON SHIFT','2023-02-03','2023-02-04 10:39:50','2023-02-05 10:39:50','461',6160694.20,5675972.00,'461','2023-02-04 10:51:49','913','2023-02-04 10:53:46',10,0),('1','116',258042,'MORNING SHIFT','2023-02-04','2023-02-04 16:05:40','2023-02-05 16:05:40','461',4667141.50,4667141.50,'461','2023-02-04 16:13:41','913','2023-02-04 16:58:42',10,0),('1','116',258043,'AFTERNOON SHIFT','2023-02-04','2023-02-05 10:00:04','2023-02-06 10:00:04','461',4659602.00,4659602.00,'461','2023-02-05 10:08:40','913','2023-02-05 11:36:22',10,0),('1','116',258044,'MORNING SHIFT','2023-02-05','2023-02-06 09:15:33','2023-02-07 09:15:33','461',2807698.00,2807698.00,'461','2023-02-06 09:42:11','913','2023-02-06 10:10:10',10,0),('1','116',258045,'MORNING SHIFT','2023-02-06','2023-02-06 20:38:11','2023-02-07 20:38:11','461',3782462.50,3782462.50,'461','2023-02-06 21:45:16','913','2023-02-06 22:06:23',10,0),('1','116',258046,'AFTERNOON SHIFT','2023-02-06','2023-02-07 10:18:39','2023-02-08 10:18:39','461',4043874.00,4043874.00,'461','2023-02-07 10:30:55','913','2023-02-07 12:49:37',10,0),('1','116',258047,'AFTERNOON SHIFT','2023-02-07','2023-02-08 11:41:27','2023-02-09 11:41:27','461',0.00,0.00,'461','2023-02-08 11:46:54','913','2023-02-08 11:49:06',10,0),('1','116',258048,'MORNING SHIFT','2023-02-07','2023-02-08 11:53:11','2023-02-09 11:53:11','461',5144812.00,5144812.00,'461','2023-02-08 11:58:40','913','2023-02-08 11:59:40',10,0),('1','116',258049,'AFTERNOON SHIFT','2023-02-07','2023-02-08 12:49:37','2023-02-09 12:49:37','461',2804290.00,2804290.00,'461','2023-02-08 12:54:25','913','2023-02-08 14:01:56',10,0),('1','116',258050,'MORNING SHIFT','2023-02-08','2023-02-08 16:32:37','2023-02-09 16:32:37','461',3839228.00,3839228.00,'461','2023-02-08 16:39:33','913','2023-02-08 19:53:32',10,0),('1','116',258051,'AFTERNOON SHIFT','2023-02-09','2023-02-09 11:12:30','2023-02-10 11:12:30','461',0.00,0.00,'461','2023-02-09 11:14:34','913','2023-02-09 11:18:08',10,0),('1','116',258052,'AFTERNOON SHIFT','2023-02-08','2023-02-09 11:24:44','2023-02-10 11:24:44','461',4217004.00,4217004.00,'461','2023-02-09 11:29:01','913','2023-02-09 12:02:41',10,0),('1','116',258053,'MORNING SHIFT','2023-02-09','2023-02-10 07:37:45','2023-02-11 07:37:45','461',3510668.00,3510668.00,'461','2023-02-10 09:25:15','913','2023-02-10 09:27:22',10,0),('1','116',258054,'AFTERNOON SHIFT','2023-02-09','2023-02-10 13:39:12','2023-02-11 13:39:12','461',2710740.00,2710740.00,'461','2023-02-10 13:50:30','913','2023-02-10 16:24:41',10,0),('1','116',258055,'MORNING SHIFT','2023-02-10','2023-02-11 11:54:46','2023-02-12 11:54:46','461',4587464.00,4587464.00,'461','2023-02-11 12:06:37','913','2023-02-11 13:37:55',10,0),('1','116',258056,'AFTERNOON SHIFT','2023-02-10','2023-02-11 14:00:14','2023-02-12 14:00:14','461',2244004.00,2244004.00,'461','2023-02-11 14:47:14','913','2023-02-11 14:54:19',10,0),('1','116',258057,'MORNING SHIFT','2023-02-11','2023-02-11 16:17:34','2023-02-12 16:17:34','461',2799360.90,2799360.90,'461','2023-02-11 18:01:07','913','2023-02-11 19:42:17',10,0),('1','116',258058,'AFTERNOON SHIFT','2023-02-11','2023-02-12 12:26:49','2023-02-13 12:26:49','461',4391165.10,4391165.10,'461','2023-02-12 12:31:38','913','2023-02-12 15:24:16',10,0),('1','116',258059,'MORNING SHIFT','2023-02-12','2023-02-12 16:40:01','2023-02-13 16:40:01','461',1697564.40,1697564.40,'461','2023-02-12 16:45:24','913','2023-02-12 23:28:35',10,0),('1','116',258060,'MORNING SHIFT','2023-02-13','2023-02-14 10:00:53','2023-02-15 10:00:53','461',840346.60,840346.60,'461','2023-02-14 10:06:13','913','2023-02-14 12:08:57',10,0),('1','116',258061,'AFTERNOON SHIFT','2023-02-13','2023-02-14 12:20:26','2023-02-15 12:20:26','461',2936116.00,2936116.00,'461','2023-02-14 12:25:27','913','2023-02-14 19:55:45',10,0),('1','116',258062,'MORNING SHIFT','2023-02-14','2023-02-15 09:07:06','2023-02-16 09:07:06','461',3044449.80,3044449.80,'461','2023-02-15 09:15:07','913','2023-02-15 12:55:54',10,0),('1','116',258063,'AFTERNOON SHIFT','2023-02-14','2023-02-15 13:07:30','2023-02-16 13:07:30','461',981302.90,981302.90,'461','2023-02-15 13:31:36','913','2023-02-15 17:03:33',10,0),('1','116',258064,'MORNING SHIFT','2023-02-15','2023-02-15 17:24:09','2023-02-16 17:24:09','461',4339426.00,4339426.00,'461','2023-02-15 17:32:17','913','2023-02-16 01:16:02',10,0),('1','116',258065,'AFTERNOON SHIFT','2023-02-15','2023-02-16 11:50:10','2023-02-17 11:50:10','461',4025211.60,4025211.60,'461','2023-02-16 12:00:37','761','2023-02-16 13:51:25',10,0),('1','116',258066,'MORNING SHIFT','2023-02-16','2023-02-17 11:07:19','2023-02-18 11:07:19','461',4575656.70,4575656.70,'461','2023-02-17 11:21:56','913','2023-02-17 11:43:58',10,0),('1','116',258067,'AFTERNOON SHIFT','2023-02-16','2023-02-17 11:45:05','2023-02-18 11:45:05','461',3419213.20,3419213.20,'461','2023-02-17 11:55:25','913','2023-02-17 16:45:49',10,0),('1','116',258068,'MORNING SHIFT','2023-02-17','2023-02-17 18:11:22','2023-02-18 18:11:22','461',2786639.10,2786639.10,'461','2023-02-17 18:19:59','913','2023-02-18 01:50:21',10,0),('1','116',258069,'AFTERNOON SHIFT','2023-02-17','2023-02-18 13:49:40','2023-02-19 13:49:40','461',3020066.70,3020066.70,'461','2023-02-18 13:54:31','913','2023-02-18 14:09:47',10,0),('1','116',258070,'MORNING SHIFT','2023-02-18','2023-02-18 15:02:02','2023-02-19 15:02:02','461',4845711.60,4845711.60,'461','2023-02-18 19:34:10','913','2023-02-19 07:52:18',10,0),('1','116',258071,'AFTERNOON SHIFT','2023-02-18','2023-02-19 18:04:21','2023-02-20 18:04:21','461',2639746.20,2639746.20,'461','2023-02-19 18:10:29','913','2023-02-20 06:00:46',10,0),('1','116',258072,'MORNING SHIFT','2023-02-19','2023-02-20 10:57:48','2023-02-21 10:57:48','461',2577514.80,2577514.80,'461','2023-02-20 11:05:16','913','2023-02-20 11:27:36',10,0),('1','116',258073,'AFTERNOON SHIFT','2023-02-19','2023-02-20 11:43:28','2023-02-21 11:43:28','461',3009163.00,3009163.00,'461','2023-02-20 12:14:23','913','2023-02-20 12:31:40',10,0),('1','116',258074,'MORNING SHIFT','2023-02-20','2023-02-20 18:10:23','2023-02-21 18:10:23','461',3371485.40,3371485.40,'461','2023-02-20 18:37:22','913','2023-02-21 01:26:52',10,0),('1','116',258075,'AFTERNOON SHIFT','2023-02-20','2023-02-21 11:00:07','2023-02-22 11:00:07','461',4087525.10,4087525.10,'461','2023-02-21 11:06:42','913','2023-02-21 11:34:48',10,0),('1','116',258076,'MORNING SHIFT','2023-02-21','2023-02-22 11:13:22','2023-02-23 11:13:22','461',4188562.20,4188562.20,'461','2023-02-22 11:23:47','913','2023-02-22 13:33:41',10,0),('1','116',258077,'AFTERNOON SHIFT','2023-02-21','2023-02-22 14:10:12','2023-02-23 14:10:12','461',4707637.00,4707637.00,'461','2023-02-22 15:04:45','913','2023-02-22 15:14:37',10,0),('1','116',258078,'MORNING SHIFT','2023-02-22','2023-02-23 08:43:11','2023-02-24 08:43:11','461',3458096.90,3458096.90,'461','2023-02-23 08:57:06','913','2023-02-23 09:49:50',10,0),('1','116',258079,'AFTERNOON SHIFT','2023-02-22','2023-02-23 12:48:30','2023-02-24 12:48:30','461',5746865.40,5746865.40,'461','2023-02-23 12:56:42','913','2023-02-23 13:14:12',10,0),('1','116',258080,'MORNING SHIFT','2023-02-23','2023-02-24 11:39:40','2023-02-25 11:39:40','461',5186818.80,5186818.80,'461','2023-02-24 12:04:00','913','2023-02-24 12:20:25',10,0),('1','116',258081,'AFTERNOON SHIFT','2023-02-23','2023-02-24 12:25:46','2023-02-25 12:25:46','461',4258652.00,4258652.00,'461','2023-02-24 12:32:08','913','2023-02-24 12:46:32',10,0),('1','116',258082,'MORNING SHIFT','2023-02-24','2023-02-24 20:40:29','2023-02-25 20:40:29','461',4185532.10,4185532.10,'461','2023-02-24 20:47:08','913','2023-02-24 23:05:29',10,0),('1','116',258083,'AFTERNOON SHIFT','2023-02-24','2023-02-26 13:33:02','2023-02-27 13:33:02','461',266700.00,266700.00,'461','2023-02-26 13:48:01','913','2023-02-26 13:52:14',10,0),('1','116',258084,'AFTERNOON SHIFT','2023-02-27','2023-02-28 09:17:55','2023-03-01 09:17:55','461',214181.50,214181.50,'461','2023-02-28 09:22:45','913','2023-02-28 15:27:31',10,0),('1','116',258085,'MORNING SHIFT','2023-02-28','2023-02-28 19:40:43','2023-03-01 19:40:43','461',4478898.60,4478898.60,'461','2023-02-28 19:49:15','913','2023-02-28 19:57:11',10,0),('1','116',258086,'AFTERNOON SHIFT','2023-02-28','2023-02-28 20:37:28','2023-03-01 20:37:28','461',2176299.30,2176299.30,'461','2023-02-28 20:42:27','913','2023-03-01 00:49:47',10,0),('1','116',258087,'AFTERNOON SHIFT','2023-03-02','2023-03-02 20:02:07','2023-03-03 20:02:07','461',663095.30,663095.30,'461','2023-03-02 20:17:02','913','2023-03-03 00:56:48',10,0),('1','116',258088,'MORNING SHIFT','2023-03-03','2023-03-04 12:58:30','2023-03-05 12:58:30','461',4220710.80,4220710.80,'461','2023-03-04 13:16:21','913','2023-03-04 14:02:36',10,0),('1','116',258089,'MORNING SHIFT','2023-03-03','2023-03-04 14:48:42','2023-03-05 14:48:42','461',3529401.30,3529401.30,'461','2023-03-04 15:35:12','913','2023-03-05 06:32:04',10,0),('1','116',258090,'MORNING SHIFT','2023-03-04','2023-03-05 10:23:40','2023-03-06 10:23:40','461',291049.20,291049.20,'461','2023-03-05 10:27:19','913','2023-03-05 11:30:46',10,0),('1','116',258091,'AFTERNOON SHIFT','2023-03-06','2023-03-06 19:38:03','2023-03-07 19:38:03','461',376612.80,376612.80,'461','2023-03-07 12:51:05','913','2023-03-07 14:34:31',10,0),('1','116',258092,'MORNING SHIFT','2023-03-07','2023-03-08 12:27:21','2023-03-09 12:27:21','461',4144576.40,4144576.40,'461','2023-03-08 12:32:19','913','2023-03-08 13:32:17',10,0),('1','116',258093,'AFTERNOON SHIFT','2023-03-07','2023-03-08 13:37:09','2023-03-09 13:37:09','461',2109032.10,2109032.10,'461','2023-03-08 13:44:06','913','2023-03-08 18:52:46',10,0),('1','116',258094,'MORNING SHIFT','2023-03-08','2023-03-10 17:14:47','2023-03-11 17:14:47','461',5997370.40,5997370.40,'461','2023-03-10 17:40:22','913','2023-03-10 17:49:29',10,0),('1','116',258095,'AFTERNOON SHIFT','2023-03-08','2023-03-10 17:53:29','2023-03-11 17:53:29','461',3095542.80,3095542.80,'461','2023-03-10 17:57:48','913','2023-03-10 18:17:00',10,0),('1','116',258096,'MORNING SHIFT','2023-03-10','2023-03-11 12:17:40','2023-03-12 12:17:40','461',1062411.30,1062411.30,'461','2023-03-11 17:53:17','913','2023-03-11 18:12:16',10,0),('1','116',258097,'MORNING SHIFT','2023-03-11','2023-03-12 10:40:55','2023-03-13 10:40:55','461',4315499.80,4315499.80,'461','2023-03-12 10:50:04','913','2023-03-12 11:20:00',10,0),('1','116',258098,'AFTERNOON SHIFT','2023-03-11','2023-03-12 11:27:19','2023-03-13 11:27:19','461',2449849.50,2449849.50,'461','2023-03-12 11:34:35','913','2023-03-12 14:05:46',10,0),('1','116',258099,'MORNING SHIFT','2023-03-12','2023-03-13 10:38:10','2023-03-14 10:38:10','461',4024782.10,4024782.10,'461','2023-03-13 10:51:54','913','2023-03-13 12:23:23',10,0),('1','116',258100,'AFTERNOON SHIFT','2023-03-12','2023-03-13 12:32:01','2023-03-14 12:32:01','461',2772971.20,2772971.20,'461','2023-03-13 12:39:32','913','2023-03-13 13:17:52',10,0),('1','116',258101,'MORNING SHIFT','2023-03-13','2023-03-14 11:40:05','2023-03-15 11:40:05','461',3442531.40,3442531.40,'461','2023-03-14 11:46:16','913','2023-03-14 14:53:51',10,0),('1','116',258102,'AFTERNOON SHIFT','2023-03-13','2023-03-14 15:14:48','2023-03-15 15:14:48','461',1845062.10,1845062.10,'461','2023-03-14 15:18:56','913','2023-03-14 23:02:47',10,0),('1','116',258103,'MORNING SHIFT','2023-03-14','2023-03-15 11:16:38','2023-03-16 11:16:38','461',4435104.60,4435104.60,'461','2023-03-15 11:23:12','913','2023-03-15 14:12:53',10,0),('1','116',258104,'AFTERNOON SHIFT','2023-03-14','2023-03-15 16:44:47','2023-03-16 16:44:47','461',4208827.20,4208827.20,'461','2023-03-15 16:54:39','761','2023-03-15 17:11:27',10,0),('1','116',258105,'MORNING SHIFT','2023-03-15','2023-03-15 17:35:28','2023-03-16 17:35:28','461',4591927.90,4591927.90,'461','2023-03-15 17:51:05','913','2023-03-15 19:34:35',10,0),('1','116',258106,'AFTERNOON SHIFT','2023-03-15','2023-03-16 13:26:25','2023-03-17 13:26:25','461',2243502.80,2243502.80,'461','2023-03-16 14:01:24','913','2023-03-16 16:00:45',10,0),('1','116',258107,'MORNING SHIFT','2023-03-16','2023-03-16 19:30:47','2023-03-17 19:30:47','461',4953126.30,4953126.30,'461','2023-03-16 19:36:11','913','2023-03-16 22:54:43',10,0),('1','116',258108,'AFTERNOON SHIFT','2023-03-16','2023-03-17 11:19:01','2023-03-18 11:19:01','461',2627527.40,2627527.40,'461','2023-03-17 12:47:44','913','2023-03-17 13:01:27',10,0),('1','116',258109,'MORNING SHIFT','2023-03-17','2023-03-17 23:37:25','2023-03-18 23:37:25','461',2042932.50,2042932.50,'461','2023-03-17 23:40:46','913','2023-03-18 05:25:14',10,0),('1','116',258110,'AFTERNOON SHIFT','2023-03-17','2023-03-19 10:35:40','2023-03-20 10:35:40','461',4397399.50,4397399.50,'461','2023-03-19 10:43:57','913','2023-03-19 13:06:36',10,0),('1','116',258111,'MORNING SHIFT ','2023-03-19','2023-03-19 19:29:32','2023-03-20 19:29:32','461',3417198.70,3417198.70,'461','2023-03-19 19:46:12','913','2023-03-20 00:14:36',10,0),('1','116',258112,'AFTERNOON SHIFT','2023-03-19','2023-03-20 11:18:40','2023-03-21 11:18:40','461',4060176.80,4060176.80,'461','2023-03-20 13:43:10','913','2023-03-20 13:51:29',10,0),('1','116',258113,'MORNING SHIFT','2023-03-20','2023-03-20 21:38:23','2023-03-21 21:38:23','461',6121983.50,6121983.50,'461','2023-03-20 21:44:28','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4913301 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','116','717','110349',2188974,'1950','297',220223.76,222901.37,2677.61,377543.01,0.00,0.00,0.00,0.00,0.00),('1','116','717','110349',2188975,'1951','297',447892.27,447892.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110349',2188976,'1952','297',405944.04,408582.61,2638.57,372038.37,0.00,0.00,0.00,0.00,0.00),('1','116','717','110349',2188977,'1953','297',368360.10,368360.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110349',2188978,'1954','297',243747.35,246091.87,2344.52,330577.32,0.00,0.00,0.00,0.00,0.00),('1','116','717','110349',2188979,'1955','297',232376.24,232376.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110349',2188980,'1956','297',318476.16,320503.73,2027.57,285887.37,0.00,0.00,0.00,0.00,0.00),('1','116','717','110349',2188981,'1957','297',427927.33,427927.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','110349',2188982,'1966','298',199936.81,201117.97,1181.16,253949.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','110349',2188983,'1967','297',28834.86,28834.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110349',2188984,'1968','297',282800.88,285368.54,2567.66,362040.06,0.00,0.00,0.00,0.00,0.00),('1','116','720','110349',2188985,'1969','297',219267.41,219267.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110349',2188986,'1970','297',179261.60,181591.35,2329.75,328494.75,0.00,0.00,0.00,0.00,0.00),('1','116','720','110349',2188987,'1971','297',31921.88,31921.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110349',2188988,'1972','297',21798.01,21798.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110355',2189061,'1950','297',222901.37,223017.23,115.86,16336.26,0.00,0.00,0.00,0.00,0.00),('1','116','717','110355',2189062,'1951','297',447892.27,451426.79,3534.52,498367.32,0.00,0.00,0.00,0.00,0.00),('1','116','717','110355',2189063,'1952','297',408582.61,412253.50,3670.89,517595.49,0.00,0.00,0.00,0.00,0.00),('1','116','717','110355',2189064,'1953','297',368360.10,368451.25,91.15,12852.15,0.00,0.00,0.00,0.00,0.00),('1','116','717','110355',2189065,'1954','297',246091.87,246120.24,28.37,4000.17,0.00,0.00,0.00,0.00,0.00),('1','116','717','110355',2189066,'1955','297',232376.24,235298.13,2921.89,411986.49,0.00,0.00,0.00,0.00,0.00),('1','116','717','110355',2189067,'1956','297',320503.73,323967.80,3464.07,488433.87,0.00,0.00,0.00,0.00,0.00),('1','116','717','110355',2189068,'1957','297',427927.33,427927.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','110355',2189069,'1966','298',201117.97,201971.01,853.04,183403.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','110355',2189070,'1967','297',28834.86,28834.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110355',2189071,'1968','297',285368.54,288208.09,2839.55,400376.55,0.00,0.00,0.00,0.00,0.00),('1','116','720','110355',2189072,'1969','297',219267.41,219267.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110355',2189073,'1970','297',181591.35,185192.23,3600.88,507724.08,0.00,0.00,0.00,0.00,0.00),('1','116','720','110355',2189074,'1971','297',31921.88,32871.88,950.00,133950.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110355',2189075,'1972','297',21798.01,22911.83,1113.82,157048.62,0.00,0.00,0.00,0.00,0.00),('1','116','717','110356',2189076,'1950','297',223017.23,223017.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110356',2189077,'1951','297',451426.79,452945.61,1518.82,214153.62,0.00,0.00,0.00,0.00,0.00),('1','116','717','110356',2189078,'1952','297',412253.50,414653.98,2400.48,338467.68,0.00,0.00,0.00,0.00,0.00),('1','116','717','110356',2189079,'1953','297',368451.25,368451.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110356',2189080,'1954','297',246120.24,247536.56,1416.32,199701.12,0.00,0.00,0.00,0.00,0.00),('1','116','717','110356',2189081,'1955','297',235298.13,236298.63,1000.50,141070.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','110356',2189082,'1956','297',323967.80,323967.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110356',2189083,'1957','297',427927.33,430329.62,2402.29,338722.89,0.00,0.00,0.00,0.00,0.00),('1','116','719','110356',2189084,'1966','298',201971.01,202531.74,560.73,120556.95,0.00,0.00,0.00,0.00,0.00),('1','116','720','110356',2189085,'1967','297',28834.86,28834.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110356',2189086,'1968','297',288208.09,289944.62,1736.53,244850.73,0.00,0.00,0.00,0.00,0.00),('1','116','720','110356',2189087,'1969','297',219267.41,221204.33,1936.92,273105.72,0.00,0.00,0.00,0.00,0.00),('1','116','720','110356',2189088,'1970','297',185192.23,185192.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110356',2189089,'1971','297',32871.88,32871.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110356',2189090,'1972','297',22911.83,22911.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110357',2189091,'1950','297',223017.23,223017.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110357',2189092,'1951','297',452945.61,454750.80,1805.19,254531.79,0.00,0.00,0.00,0.00,0.00),('1','116','717','110357',2189093,'1952','297',414653.98,417476.74,2822.76,398009.16,0.00,0.00,0.00,0.00,0.00),('1','116','717','110357',2189094,'1953','297',368451.25,368451.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110357',2189095,'1954','297',247536.56,247536.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110357',2189096,'1955','297',236298.63,238600.53,2301.90,324567.90,0.00,0.00,0.00,0.00,0.00),('1','116','717','110357',2189097,'1956','297',323967.80,326582.56,2614.76,368681.16,0.00,0.00,0.00,0.00,0.00),('1','116','717','110357',2189098,'1957','297',430329.62,430329.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','110357',2189099,'1966','298',202531.74,203369.64,837.90,180148.50,0.00,0.00,0.00,0.00,0.00),('1','116','720','110357',2189100,'1967','297',28834.86,31172.08,2337.22,329548.02,0.00,0.00,0.00,0.00,0.00),('1','116','720','110357',2189101,'1968','297',289944.62,290155.11,210.49,29679.09,0.00,0.00,0.00,0.00,0.00),('1','116','720','110357',2189102,'1969','297',221204.33,221831.27,626.94,88398.54,0.00,0.00,0.00,0.00,0.00),('1','116','720','110357',2189103,'1970','297',185192.23,187180.58,1988.35,280357.35,0.00,0.00,0.00,0.00,0.00),('1','116','720','110357',2189104,'1971','297',32871.88,33922.94,1051.06,148199.46,0.00,0.00,0.00,0.00,0.00),('1','116','720','110357',2189105,'1972','297',22911.83,24037.78,1125.95,158758.95,0.00,0.00,0.00,0.00,0.00),('1','116','717','110359',2189119,'1950','297',223017.23,223017.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110359',2189120,'1951','297',454750.80,454750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110359',2189121,'1952','297',417476.74,417476.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110359',2189122,'1953','297',368451.25,368451.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110359',2189123,'1954','297',247536.56,247536.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110359',2189124,'1955','297',238600.53,238600.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110359',2189125,'1956','297',326582.56,326582.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110359',2189126,'1957','297',430329.62,430329.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','110359',2189127,'1966','298',203369.64,204103.28,733.64,157732.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','110359',2189128,'1967','297',31172.08,33643.62,2471.54,348487.14,0.00,0.00,0.00,0.00,0.00),('1','116','720','110359',2189129,'1968','297',290155.11,293150.11,2995.00,422295.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110359',2189130,'1969','297',221831.27,224511.18,2679.91,377867.31,0.00,0.00,0.00,0.00,0.00),('1','116','720','110359',2189131,'1970','297',187180.58,189651.75,2471.17,348434.97,0.00,0.00,0.00,0.00,0.00),('1','116','720','110359',2189132,'1971','297',33922.94,34669.63,746.69,105283.29,0.00,0.00,0.00,0.00,0.00),('1','116','720','110359',2189133,'1972','297',24037.78,25521.21,1483.43,209163.63,0.00,0.00,0.00,0.00,0.00),('1','116','717','110360',2189134,'1950','297',223017.23,223017.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110360',2189135,'1951','297',454750.80,455462.97,712.17,100415.97,0.00,0.00,0.00,0.00,0.00),('1','116','717','110360',2189136,'1952','297',417476.74,418119.02,642.28,90561.48,0.00,0.00,0.00,0.00,0.00),('1','116','717','110360',2189137,'1953','297',368451.25,368574.00,122.75,17307.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','110360',2189138,'1954','297',247536.56,248095.60,559.04,78824.64,0.00,0.00,0.00,0.00,0.00),('1','116','717','110360',2189139,'1955','297',238600.53,238600.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110360',2189140,'1956','297',326582.56,328110.12,1527.56,215385.96,0.00,0.00,0.00,0.00,0.00),('1','116','717','110360',2189141,'1957','297',430329.62,431704.75,1375.13,193893.33,0.00,0.00,0.00,0.00,0.00),('1','116','719','110360',2189142,'1966','298',204103.28,205644.90,1541.62,331448.30,0.00,0.00,0.00,0.00,0.00),('1','116','720','110360',2189143,'1967','297',33643.62,33643.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110360',2189144,'1968','297',293150.11,293534.55,384.44,54206.04,0.00,0.00,0.00,0.00,0.00),('1','116','720','110360',2189145,'1969','297',224511.18,224758.27,247.09,34839.69,0.00,0.00,0.00,0.00,0.00),('1','116','720','110360',2189146,'1970','297',189651.75,190048.98,397.23,56009.43,0.00,0.00,0.00,0.00,0.00),('1','116','720','110360',2189147,'1971','297',34669.63,34724.26,54.63,7702.83,0.00,0.00,0.00,0.00,0.00),('1','116','720','110360',2189148,'1972','297',25521.21,25569.15,47.94,6759.54,0.00,0.00,0.00,0.00,0.00),('1','116','717','110361',2189149,'1950','297',223017.23,223017.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110361',2189150,'1951','297',455462.97,457805.26,2342.29,330262.89,0.00,0.00,0.00,0.00,0.00),('1','116','717','110361',2189151,'1952','297',418119.02,418229.15,110.13,15528.33,0.00,0.00,0.00,0.00,0.00),('1','116','717','110361',2189152,'1953','297',368574.00,371349.55,2775.55,391352.55,0.00,0.00,0.00,0.00,0.00),('1','116','717','110361',2189153,'1954','297',248095.60,248095.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110361',2189154,'1955','297',238600.53,240602.20,2001.67,282235.47,0.00,0.00,0.00,0.00,0.00),('1','116','717','110361',2189155,'1956','297',328110.12,330231.48,2121.36,299111.76,0.00,0.00,0.00,0.00,0.00),('1','116','717','110361',2189156,'1957','297',431704.75,431704.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','110361',2189157,'1966','298',205644.90,206623.97,979.07,210500.05,0.00,0.00,0.00,0.00,0.00),('1','116','720','110361',2189158,'1967','297',33643.62,33643.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110361',2189159,'1968','297',293534.55,295065.52,1530.97,215866.77,0.00,0.00,0.00,0.00,0.00),('1','116','720','110361',2189160,'1969','297',224758.27,224758.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110361',2189161,'1970','297',190048.98,192180.13,2131.15,300492.15,0.00,0.00,0.00,0.00,0.00),('1','116','720','110361',2189162,'1971','297',34724.26,34724.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110361',2189163,'1972','297',25569.15,25569.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110362',2189164,'1950','297',223017.23,226869.32,3852.09,543144.69,0.00,0.00,0.00,0.00,0.00),('1','116','717','110362',2189165,'1951','297',457805.26,458964.40,1159.14,163438.74,0.00,0.00,0.00,0.00,0.00),('1','116','717','110362',2189166,'1952','297',418229.15,419543.59,1314.44,185336.04,0.00,0.00,0.00,0.00,0.00),('1','116','717','110362',2189167,'1953','297',371349.55,374406.15,3056.60,430980.60,0.00,0.00,0.00,0.00,0.00),('1','116','717','110362',2189168,'1954','297',248095.60,250922.19,2826.59,398549.19,0.00,0.00,0.00,0.00,0.00),('1','116','717','110362',2189169,'1955','297',240602.20,241612.04,1009.84,142387.44,0.00,0.00,0.00,0.00,0.00),('1','116','717','110362',2189170,'1956','297',330231.48,332523.87,2292.39,323226.99,0.00,0.00,0.00,0.00,0.00),('1','116','717','110362',2189171,'1957','297',431704.75,431704.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','110362',2189172,'1966','298',206623.97,207582.16,958.19,206010.85,0.00,0.00,0.00,0.00,0.00),('1','116','720','110362',2189173,'1967','297',33643.62,33643.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110362',2189174,'1968','297',295065.52,296773.59,1708.07,240837.87,0.00,0.00,0.00,0.00,0.00),('1','116','720','110362',2189175,'1969','297',224758.27,228585.18,3826.91,539594.31,0.00,0.00,0.00,0.00,0.00),('1','116','720','110362',2189176,'1970','297',192180.13,192180.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110362',2189177,'1971','297',34724.26,34724.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110362',2189178,'1972','297',25569.15,26004.31,435.16,61357.56,0.00,0.00,0.00,0.00,0.00),('1','116','717','110363',2189179,'1950','297',226869.32,226869.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110363',2189180,'1951','297',458964.40,461688.20,2723.80,384055.80,0.00,0.00,0.00,0.00,0.00),('1','116','717','110363',2189181,'1952','297',419543.59,420105.31,561.72,79202.52,0.00,0.00,0.00,0.00,0.00),('1','116','717','110363',2189182,'1953','297',374406.15,376651.42,2245.27,316583.07,0.00,0.00,0.00,0.00,0.00),('1','116','717','110363',2189183,'1954','297',250922.19,252621.23,1699.04,239564.64,0.00,0.00,0.00,0.00,0.00),('1','116','717','110363',2189184,'1955','297',241612.04,242085.43,473.39,66747.99,0.00,0.00,0.00,0.00,0.00),('1','116','717','110363',2189185,'1956','297',332523.87,332828.05,304.18,42889.38,0.00,0.00,0.00,0.00,0.00),('1','116','717','110363',2189186,'1957','297',431704.75,433925.49,2220.74,313124.34,0.00,0.00,0.00,0.00,0.00),('1','116','719','110363',2189187,'1966','298',207582.16,208290.54,708.38,152301.70,0.00,0.00,0.00,0.00,0.00),('1','116','720','110363',2189188,'1967','297',33643.62,33928.23,284.61,40130.01,0.00,0.00,0.00,0.00,0.00),('1','116','720','110363',2189189,'1968','297',296773.59,299214.59,2441.00,344181.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110363',2189190,'1969','297',228585.18,230262.41,1677.23,236489.43,0.00,0.00,0.00,0.00,0.00),('1','116','720','110363',2189191,'1970','297',192180.13,192886.18,706.05,99553.05,0.00,0.00,0.00,0.00,0.00),('1','116','720','110363',2189192,'1971','297',34724.26,34764.33,40.07,5649.87,0.00,0.00,0.00,0.00,0.00),('1','116','720','110363',2189193,'1972','297',26004.31,26259.92,255.61,36041.01,0.00,0.00,0.00,0.00,0.00),('1','116','717','110364',2189194,'1950','297',226869.32,226869.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110364',2189195,'1951','297',461688.20,464321.47,2633.27,371291.07,0.00,0.00,0.00,0.00,0.00),('1','116','717','110364',2189196,'1952','297',420105.31,422789.44,2684.13,378462.33,0.00,0.00,0.00,0.00,0.00),('1','116','717','110364',2189197,'1953','297',376651.42,377140.01,488.59,68891.19,0.00,0.00,0.00,0.00,0.00),('1','116','717','110364',2189198,'1954','297',252621.23,252621.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110364',2189199,'1955','297',242085.43,243940.28,1854.85,261533.85,0.00,0.00,0.00,0.00,0.00),('1','116','717','110364',2189200,'1956','297',332828.05,332828.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110364',2189201,'1957','297',433925.49,436709.47,2783.98,392541.18,0.00,0.00,0.00,0.00,0.00),('1','116','719','110364',2189202,'1966','298',208290.54,210131.48,1840.94,395802.10,0.00,0.00,0.00,0.00,0.00),('1','116','720','110364',2189203,'1967','297',33928.23,35626.78,1698.55,239495.55,0.00,0.00,0.00,0.00,0.00),('1','116','720','110364',2189204,'1968','297',299214.59,299214.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110364',2189205,'1969','297',230262.41,230262.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110364',2189206,'1970','297',192886.18,194705.97,1819.79,256590.39,0.00,0.00,0.00,0.00,0.00),('1','116','720','110364',2189207,'1971','297',34764.33,34764.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110364',2189208,'1972','297',26259.92,26259.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110365',2189209,'1950','297',226869.32,227562.45,693.13,97731.33,0.00,0.00,0.00,0.00,0.00),('1','116','717','110365',2189210,'1951','297',464321.47,467530.71,3209.24,452502.84,0.00,0.00,0.00,0.00,0.00),('1','116','717','110365',2189211,'1952','297',422789.44,425753.11,2963.67,417877.47,0.00,0.00,0.00,0.00,0.00),('1','116','717','110365',2189212,'1953','297',377140.01,377140.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110365',2189213,'1954','297',252621.23,254396.00,1774.77,250242.57,0.00,0.00,0.00,0.00,0.00),('1','116','717','110365',2189214,'1955','297',243940.28,245114.78,1174.50,165604.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','110365',2189215,'1956','297',332828.05,336118.94,3290.89,464015.49,0.00,0.00,0.00,0.00,0.00),('1','116','717','110365',2189216,'1957','297',436709.47,439575.37,2865.90,404091.90,0.00,0.00,0.00,0.00,0.00),('1','116','719','110365',2189217,'1966','298',210131.48,211423.63,1292.15,277812.25,0.00,0.00,0.00,0.00,0.00),('1','116','720','110365',2189218,'1967','297',35626.78,35654.51,27.73,3909.93,0.00,0.00,0.00,0.00,0.00),('1','116','720','110365',2189219,'1968','297',299214.59,299813.94,599.35,84508.35,0.00,0.00,0.00,0.00,0.00),('1','116','720','110365',2189220,'1969','297',230262.41,230262.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110365',2189221,'1970','297',194705.97,195942.07,1236.10,174290.10,0.00,0.00,0.00,0.00,0.00),('1','116','720','110365',2189222,'1971','297',34764.33,34788.51,24.18,3409.38,0.00,0.00,0.00,0.00,0.00),('1','116','720','110365',2189223,'1972','297',26259.92,26308.60,48.68,6863.88,0.00,0.00,0.00,0.00,0.00),('1','116','717','110366',2189224,'1950','297',227562.45,227562.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110366',2189225,'1951','297',467530.71,469439.29,1908.58,269109.78,0.00,0.00,0.00,0.00,0.00),('1','116','717','110366',2189226,'1952','297',425753.11,427794.21,2041.10,287795.10,0.00,0.00,0.00,0.00,0.00),('1','116','717','110366',2189227,'1953','297',377140.01,377175.47,35.46,4999.86,0.00,0.00,0.00,0.00,0.00),('1','116','717','110366',2189228,'1954','297',254396.00,254396.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110366',2189229,'1955','297',245114.78,246456.32,1341.54,189157.14,0.00,0.00,0.00,0.00,0.00),('1','116','717','110366',2189230,'1956','297',336118.94,337596.06,1477.12,208273.92,0.00,0.00,0.00,0.00,0.00),('1','116','717','110366',2189231,'1957','297',439575.37,439942.69,367.32,51792.12,0.00,0.00,0.00,0.00,0.00),('1','116','719','110366',2189232,'1966','298',211423.63,212091.22,667.59,143531.85,0.00,0.00,0.00,0.00,0.00),('1','116','720','110366',2189233,'1967','297',35654.51,35654.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110366',2189234,'1968','297',299813.94,301633.48,1819.54,256555.14,0.00,0.00,0.00,0.00,0.00),('1','116','720','110366',2189235,'1969','297',230262.41,230262.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110366',2189236,'1970','297',195942.07,197251.48,1309.41,184626.81,0.00,0.00,0.00,0.00,0.00),('1','116','720','110366',2189237,'1971','297',34788.51,34788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110366',2189238,'1972','297',26308.60,26308.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110458',2190858,'1950','297',227562.45,229616.37,2053.92,289602.72,0.00,0.00,0.00,0.00,0.00),('1','116','717','110458',2190859,'1951','297',469439.29,472335.11,2895.82,408310.62,0.00,0.00,0.00,0.00,0.00),('1','116','717','110458',2190860,'1952','297',427794.21,430211.82,2417.61,340883.01,0.00,0.00,0.00,0.00,0.00),('1','116','717','110458',2190861,'1953','297',377175.47,377175.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110458',2190862,'1954','297',254396.00,256145.26,1749.26,246645.66,0.00,0.00,0.00,0.00,0.00),('1','116','717','110458',2190863,'1955','297',246456.32,246456.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110458',2190864,'1956','297',337596.06,337596.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110458',2190865,'1957','297',439942.69,442496.48,2553.79,360084.39,0.00,0.00,0.00,0.00,0.00),('1','116','719','110458',2190866,'1966','298',212091.22,212920.76,829.54,178351.10,0.00,0.00,0.00,0.00,0.00),('1','116','720','110458',2190867,'1967','297',35654.51,35654.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110458',2190868,'1968','297',301633.48,303001.79,1368.31,192931.71,0.00,0.00,0.00,0.00,0.00),('1','116','720','110458',2190869,'1969','297',230262.41,232137.99,1875.58,264456.78,0.00,0.00,0.00,0.00,0.00),('1','116','720','110458',2190870,'1970','297',197251.48,197251.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110458',2190871,'1971','297',34788.51,34788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110458',2190872,'1972','297',26308.60,26308.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110462',2190914,'1950','297',229616.37,231480.02,1863.65,262774.65,0.00,0.00,0.00,0.00,0.00),('1','116','717','110462',2190915,'1951','297',472335.11,472342.20,7.09,999.69,0.00,0.00,0.00,0.00,0.00),('1','116','717','110462',2190916,'1952','297',430211.82,430211.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110462',2190917,'1953','297',377175.47,379298.46,2122.99,299341.59,0.00,0.00,0.00,0.00,0.00),('1','116','717','110462',2190918,'1954','297',256145.26,256145.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110462',2190919,'1955','297',246456.32,248403.75,1947.43,274587.63,0.00,0.00,0.00,0.00,0.00),('1','116','717','110462',2190920,'1956','297',337596.06,337596.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110462',2190921,'1957','297',442496.48,444781.32,2284.84,322162.44,0.00,0.00,0.00,0.00,0.00),('1','116','719','110462',2190922,'1966','298',212920.76,213679.73,758.97,163178.55,0.00,0.00,0.00,0.00,0.00),('1','116','720','110462',2190923,'1967','297',35654.51,35654.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110462',2190924,'1968','297',303001.79,304580.56,1578.77,222606.57,0.00,0.00,0.00,0.00,0.00),('1','116','720','110462',2190925,'1969','297',232137.99,233690.01,1552.02,218834.82,0.00,0.00,0.00,0.00,0.00),('1','116','720','110462',2190926,'1970','297',197251.48,198675.77,1424.29,200824.89,0.00,0.00,0.00,0.00,0.00),('1','116','720','110462',2190927,'1971','297',34788.51,34788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110462',2190928,'1972','297',26308.60,26308.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110471',2191162,'1950','297',231480.02,233959.02,2479.00,349539.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110471',2191163,'1951','297',472342.20,474240.65,1898.45,267681.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','110471',2191164,'1952','297',430211.82,432001.87,1790.05,252397.05,0.00,0.00,0.00,0.00,0.00),('1','116','717','110471',2191165,'1953','297',379298.46,382218.94,2920.48,411787.68,0.00,0.00,0.00,0.00,0.00),('1','116','717','110471',2191166,'1954','297',256145.26,256826.32,681.06,96029.46,0.00,0.00,0.00,0.00,0.00),('1','116','717','110471',2191167,'1955','297',248403.75,248403.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110471',2191168,'1956','297',337596.06,338944.37,1348.31,190111.71,0.00,0.00,0.00,0.00,0.00),('1','116','717','110471',2191169,'1957','297',444781.32,446821.70,2040.38,287693.58,0.00,0.00,0.00,0.00,0.00),('1','116','719','110471',2191170,'1966','298',213679.73,214804.81,1125.08,241892.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','110471',2191171,'1967','297',35654.51,35668.75,14.24,2007.84,0.00,0.00,0.00,0.00,0.00),('1','116','720','110471',2191172,'1968','297',304580.56,306915.68,2335.12,329251.92,0.00,0.00,0.00,0.00,0.00),('1','116','720','110471',2191173,'1969','297',233690.01,236311.20,2621.19,369587.79,0.00,0.00,0.00,0.00,0.00),('1','116','720','110471',2191174,'1970','297',198675.77,200747.65,2071.88,292135.08,0.00,0.00,0.00,0.00,0.00),('1','116','720','110471',2191175,'1971','297',34788.51,34788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110471',2191176,'1972','297',26308.60,26669.02,360.42,50819.22,0.00,0.00,0.00,0.00,0.00),('1','116','717','110495',2191630,'1950','297',233959.02,233959.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110495',2191631,'1951','297',474240.65,476462.20,2221.55,313238.55,0.00,0.00,0.00,0.00,0.00),('1','116','717','110495',2191632,'1952','297',432001.87,434282.54,2280.67,321574.47,0.00,0.00,0.00,0.00,0.00),('1','116','717','110495',2191633,'1953','297',382218.94,382218.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110495',2191634,'1954','297',256826.32,258390.66,1564.34,220571.94,0.00,0.00,0.00,0.00,0.00),('1','116','717','110495',2191635,'1955','297',248403.75,248403.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110495',2191636,'1956','297',338944.37,340500.06,1555.69,219352.29,0.00,0.00,0.00,0.00,0.00),('1','116','717','110495',2191637,'1957','297',446821.70,447833.16,1011.46,142615.86,0.00,0.00,0.00,0.00,0.00),('1','116','719','110495',2191638,'1966','298',214804.81,216812.00,2007.19,431545.85,0.00,0.00,0.00,0.00,0.00),('1','116','720','110495',2191639,'1967','297',35668.75,35668.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110495',2191640,'1968','297',306915.68,308311.80,1396.12,196852.92,0.00,0.00,0.00,0.00,0.00),('1','116','720','110495',2191641,'1969','297',236311.20,236311.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110495',2191642,'1970','297',200747.65,202685.95,1938.30,273300.30,0.00,0.00,0.00,0.00,0.00),('1','116','720','110495',2191643,'1971','297',34788.51,34788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110495',2191644,'1972','297',26669.02,26669.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110497',2191659,'1950','297',233959.02,233959.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110497',2191660,'1951','297',476462.20,479719.08,3256.88,459220.08,0.00,0.00,0.00,0.00,0.00),('1','116','717','110497',2191661,'1952','297',434282.54,437156.36,2873.82,405208.62,0.00,0.00,0.00,0.00,0.00),('1','116','717','110497',2191662,'1953','297',382218.94,382218.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110497',2191663,'1954','297',258390.66,258390.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110497',2191664,'1955','297',248403.75,251126.16,2722.41,383859.81,0.00,0.00,0.00,0.00,0.00),('1','116','717','110497',2191665,'1956','297',340500.06,342807.10,2307.04,325292.64,0.00,0.00,0.00,0.00,0.00),('1','116','717','110497',2191666,'1957','297',447833.16,450491.94,2658.78,374887.98,0.00,0.00,0.00,0.00,0.00),('1','116','719','110497',2191667,'1966','298',216812.00,217579.62,767.62,165038.30,0.00,0.00,0.00,0.00,0.00),('1','116','720','110497',2191668,'1967','297',35668.75,37311.21,1642.46,231586.86,0.00,0.00,0.00,0.00,0.00),('1','116','720','110497',2191669,'1968','297',308311.80,308894.18,582.38,82115.58,0.00,0.00,0.00,0.00,0.00),('1','116','720','110497',2191670,'1969','297',236311.20,239072.32,2761.12,389317.92,0.00,0.00,0.00,0.00,0.00),('1','116','720','110497',2191671,'1970','297',202685.95,202685.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110497',2191672,'1971','297',34788.51,34788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110497',2191673,'1972','297',26669.02,26960.58,291.56,41109.96,0.00,0.00,0.00,0.00,0.00),('1','116','717','110504',2191786,'1950','297',233959.02,233959.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110504',2191787,'1951','297',479719.08,481805.73,2086.65,294217.65,0.00,0.00,0.00,0.00,0.00),('1','116','717','110504',2191788,'1952','297',437156.36,439355.88,2199.52,310132.32,0.00,0.00,0.00,0.00,0.00),('1','116','717','110504',2191789,'1953','297',382218.94,382218.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110504',2191790,'1954','297',258390.66,260407.30,2016.64,284346.24,0.00,0.00,0.00,0.00,0.00),('1','116','717','110504',2191791,'1955','297',251126.16,251126.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110504',2191792,'1956','297',342807.10,342807.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110504',2191793,'1957','297',450491.94,452418.74,1926.80,271678.80,0.00,0.00,0.00,0.00,0.00),('1','116','719','110504',2191794,'1966','298',217579.62,218170.60,590.98,127060.70,0.00,0.00,0.00,0.00,0.00),('1','116','720','110504',2191795,'1967','297',37311.21,37311.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110504',2191796,'1968','297',308894.18,310802.32,1908.14,269047.74,0.00,0.00,0.00,0.00,0.00),('1','116','720','110504',2191797,'1969','297',239072.32,239937.89,865.57,122045.37,0.00,0.00,0.00,0.00,0.00),('1','116','720','110504',2191798,'1970','297',202685.95,204511.36,1825.41,257382.81,0.00,0.00,0.00,0.00,0.00),('1','116','720','110504',2191799,'1971','297',34788.51,34788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110504',2191800,'1972','297',26960.58,26960.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110509',2191881,'1950','297',233959.02,234527.44,568.42,80147.22,0.00,0.00,0.00,0.00,0.00),('1','116','717','110509',2191882,'1951','297',481805.73,484381.22,2575.49,363144.09,0.00,0.00,0.00,0.00,0.00),('1','116','717','110509',2191883,'1952','297',439355.88,441492.57,2136.69,301273.29,0.00,0.00,0.00,0.00,0.00),('1','116','717','110509',2191884,'1953','297',382218.94,384443.20,2224.26,313620.66,0.00,0.00,0.00,0.00,0.00),('1','116','717','110509',2191885,'1954','297',260407.30,261293.20,885.90,124911.90,0.00,0.00,0.00,0.00,0.00),('1','116','717','110509',2191886,'1955','297',251126.16,253621.46,2495.30,351837.30,0.00,0.00,0.00,0.00,0.00),('1','116','717','110509',2191887,'1956','297',342807.10,344983.15,2176.05,306823.05,0.00,0.00,0.00,0.00,0.00),('1','116','717','110509',2191888,'1957','297',452418.74,453314.87,896.13,126354.33,0.00,0.00,0.00,0.00,0.00),('1','116','719','110509',2191889,'1966','298',218170.60,219355.62,1185.02,254779.30,0.00,0.00,0.00,0.00,0.00),('1','116','720','110509',2191890,'1967','297',37311.21,37311.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110509',2191891,'1968','297',310802.32,311490.54,688.22,97039.02,0.00,0.00,0.00,0.00,0.00),('1','116','720','110509',2191892,'1969','297',239937.89,239937.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110509',2191893,'1970','297',204511.36,205893.29,1381.93,194852.13,0.00,0.00,0.00,0.00,0.00),('1','116','720','110509',2191894,'1971','297',34788.51,34788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110509',2191895,'1972','297',26960.58,26960.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110510',2191896,'1950','297',234527.44,236477.58,1950.14,274969.74,0.00,0.00,0.00,0.00,0.00),('1','116','717','110510',2191897,'1951','297',484381.22,484431.99,50.77,7158.57,0.00,0.00,0.00,0.00,0.00),('1','116','717','110510',2191898,'1952','297',441492.57,443750.57,2258.00,318378.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110510',2191899,'1953','297',384443.20,385447.10,1003.90,141549.90,0.00,0.00,0.00,0.00,0.00),('1','116','717','110510',2191900,'1954','297',261293.20,263045.14,1751.94,247023.54,0.00,0.00,0.00,0.00,0.00),('1','116','717','110510',2191901,'1955','297',253621.46,255109.22,1487.76,209774.16,0.00,0.00,0.00,0.00,0.00),('1','116','717','110510',2191902,'1956','297',344983.15,346387.91,1404.76,198071.02,0.00,0.00,0.00,0.00,0.00),('1','116','717','110510',2191903,'1957','297',453314.87,455784.78,2469.91,348257.31,0.00,0.00,0.00,0.00,0.00),('1','116','719','110510',2191904,'1966','298',219355.62,220396.84,1041.22,223862.30,0.00,0.00,0.00,0.00,0.00),('1','116','720','110510',2191905,'1967','297',37311.21,37311.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110510',2191906,'1968','297',311490.54,311490.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110510',2191907,'1969','297',239937.89,239937.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110510',2191908,'1970','297',205893.29,205893.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110510',2191909,'1971','297',34788.51,34788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110510',2191910,'1972','297',26960.58,26960.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110511',2191911,'1950','297',236477.58,238406.66,1929.08,272000.28,0.00,0.00,0.00,0.00,0.00),('1','116','717','110511',2191912,'1951','297',484431.99,486629.00,2197.01,309778.41,0.00,0.00,0.00,0.00,0.00),('1','116','717','110511',2191913,'1952','297',443750.57,445987.65,2237.08,315428.28,0.00,0.00,0.00,0.00,0.00),('1','116','717','110511',2191914,'1953','297',385447.10,388686.08,3238.98,456696.18,0.00,0.00,0.00,0.00,0.00),('1','116','717','110511',2191915,'1954','297',263045.14,265274.26,2229.12,314305.92,0.00,0.00,0.00,0.00,0.00),('1','116','717','110511',2191916,'1955','297',255109.22,257103.61,1994.39,281208.99,0.00,0.00,0.00,0.00,0.00),('1','116','717','110511',2191917,'1956','297',346387.91,348899.27,2511.36,354101.76,0.00,0.00,0.00,0.00,0.00),('1','116','717','110511',2191918,'1957','297',455784.78,457909.89,2125.11,299640.51,0.00,0.00,0.00,0.00,0.00),('1','116','719','110511',2191919,'1966','298',220396.84,221980.70,1583.86,340529.90,0.00,0.00,0.00,0.00,0.00),('1','116','720','110511',2191920,'1967','297',37311.21,37311.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110511',2191921,'1968','297',311490.54,311490.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110511',2191922,'1969','297',239937.89,239937.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110511',2191923,'1970','297',205893.29,205893.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110511',2191924,'1971','297',34788.51,34788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110511',2191925,'1972','297',26960.58,26960.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110528',2192238,'1950','297',238406.66,238406.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110528',2192239,'1951','297',486629.00,491594.14,4965.14,700084.74,0.00,0.00,0.00,0.00,0.00),('1','116','717','110528',2192240,'1952','297',445987.65,447696.32,1708.67,240922.47,0.00,0.00,0.00,0.00,0.00),('1','116','717','110528',2192241,'1953','297',388686.08,391151.12,2465.04,347570.64,0.00,0.00,0.00,0.00,0.00),('1','116','717','110528',2192242,'1954','297',265274.26,265274.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110528',2192243,'1955','297',257103.61,259249.44,2145.83,302562.03,0.00,0.00,0.00,0.00,0.00),('1','116','717','110528',2192244,'1956','297',348899.27,348899.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110528',2192245,'1957','297',457909.89,460069.64,2159.75,304524.75,0.00,0.00,0.00,0.00,0.00),('1','116','719','110528',2192246,'1966','298',221980.70,222372.49,391.79,84234.85,0.00,0.00,0.00,0.00,0.00),('1','116','720','110528',2192247,'1967','297',37311.21,37311.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110528',2192248,'1968','297',311490.54,313503.88,2013.34,283880.94,0.00,0.00,0.00,0.00,0.00),('1','116','720','110528',2192249,'1969','297',239937.89,239937.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110528',2192250,'1970','297',205893.29,208204.43,2311.14,325870.74,0.00,0.00,0.00,0.00,0.00),('1','116','720','110528',2192251,'1971','297',34788.51,34788.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110528',2192252,'1972','297',26960.58,26960.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110530',2192281,'1950','297',238406.66,238758.11,331.45,46734.45,0.00,0.00,20.00,0.00,0.00),('1','116','717','110530',2192282,'1951','297',491594.14,494572.11,2967.97,418483.77,0.00,0.00,10.00,0.00,0.00),('1','116','717','110530',2192283,'1952','297',447696.32,448278.90,562.58,79323.78,0.00,0.00,20.00,0.00,0.00),('1','116','717','110530',2192284,'1953','297',391151.12,393831.40,2660.28,375099.48,0.00,0.00,20.00,0.00,0.00),('1','116','717','110530',2192285,'1954','297',265274.26,268346.70,3062.44,431804.04,0.00,0.00,10.00,0.00,0.00),('1','116','717','110530',2192286,'1955','297',259249.44,261527.92,2258.48,318445.68,0.00,0.00,20.00,0.00,0.00),('1','116','717','110530',2192287,'1956','297',348899.27,349235.50,316.23,44588.43,0.00,0.00,20.00,0.00,0.00),('1','116','717','110530',2192288,'1957','297',460069.64,464044.99,3945.35,556294.35,0.00,0.00,30.00,0.00,0.00),('1','116','719','110530',2192289,'1966','298',222372.49,224047.93,1655.44,355919.60,0.00,0.00,20.00,0.00,0.00),('1','116','720','110530',2192290,'1967','297',37311.21,37924.37,613.16,86455.56,0.00,0.00,0.00,0.00,0.00),('1','116','720','110530',2192291,'1968','297',313503.88,315568.39,2064.51,291095.91,0.00,0.00,0.00,0.00,0.00),('1','116','720','110530',2192292,'1969','297',239937.89,241563.96,1626.07,229275.87,0.00,0.00,0.00,0.00,0.00),('1','116','720','110530',2192293,'1970','297',208204.43,208283.94,79.51,11210.91,0.00,0.00,0.00,0.00,0.00),('1','116','720','110530',2192294,'1971','297',34788.51,34837.78,49.27,6947.07,0.00,0.00,0.00,0.00,0.00),('1','116','720','110530',2192295,'1972','297',26960.58,27225.61,265.03,37369.23,0.00,0.00,0.00,0.00,0.00),('1','116','717','110542',2192508,'1950','297',238758.11,238758.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110542',2192509,'1951','297',494572.11,497695.34,3123.23,440375.43,0.00,0.00,0.00,0.00,0.00),('1','116','717','110542',2192510,'1952','297',448278.90,448278.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110542',2192511,'1953','297',393831.40,395757.42,1926.02,271568.82,0.00,0.00,0.00,0.00,0.00),('1','116','717','110542',2192512,'1954','297',268346.70,268346.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110542',2192513,'1955','297',261527.92,263264.39,1736.47,244842.27,0.00,0.00,0.00,0.00,0.00),('1','116','717','110542',2192514,'1956','297',349235.50,349269.19,33.69,4750.29,0.00,0.00,0.00,0.00,0.00),('1','116','717','110542',2192515,'1957','297',464044.99,467763.00,3718.01,524239.41,0.00,0.00,0.00,0.00,0.00),('1','116','719','110542',2192516,'1966','298',224047.93,225261.56,1213.63,260930.45,0.00,0.00,0.00,0.00,0.00),('1','116','720','110542',2192517,'1967','297',37924.37,37924.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110542',2192518,'1968','297',315568.39,317744.18,2155.79,303966.39,0.00,0.00,20.00,0.00,0.00),('1','116','720','110542',2192519,'1969','297',241563.96,241563.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110542',2192520,'1970','297',208283.94,210491.55,2177.61,307043.01,0.00,0.00,30.00,0.00,0.00),('1','116','720','110542',2192521,'1971','297',34837.78,35837.78,980.00,138180.00,0.00,0.00,20.00,0.00,0.00),('1','116','720','110542',2192522,'1972','297',27225.61,28505.89,1260.28,177699.48,0.00,0.00,20.00,0.00,0.00),('1','116','717','110544',2192557,'1950','297',238758.11,238758.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110544',2192558,'1951','297',497695.34,501449.45,3754.11,529329.51,0.00,0.00,0.00,0.00,0.00),('1','116','717','110544',2192559,'1952','297',448278.90,448278.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110544',2192560,'1953','297',395757.42,399069.12,3311.70,466949.70,0.00,0.00,0.00,0.00,0.00),('1','116','717','110544',2192561,'1954','297',268346.70,268346.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110544',2192562,'1955','297',263264.39,266395.21,3130.82,441445.62,0.00,0.00,0.00,0.00,0.00),('1','116','717','110544',2192563,'1956','297',349269.19,352279.14,3009.95,424402.95,0.00,0.00,0.00,0.00,0.00),('1','116','717','110544',2192564,'1957','297',467763.00,467763.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','110544',2192565,'1966','298',225261.56,225879.73,618.17,132906.55,0.00,0.00,0.00,0.00,0.00),('1','116','720','110544',2192566,'1967','297',37924.37,38061.31,126.94,17898.54,0.00,0.00,10.00,0.00,0.00),('1','116','720','110544',2192567,'1968','297',317744.18,319908.27,2164.09,305136.69,0.00,0.00,0.00,0.00,0.00),('1','116','720','110544',2192568,'1969','297',241563.96,241819.01,235.05,33142.05,0.00,0.00,20.00,0.00,0.00),('1','116','720','110544',2192569,'1970','297',210491.55,213199.27,2707.72,381788.52,0.00,0.00,0.00,0.00,0.00),('1','116','720','110544',2192570,'1971','297',35837.78,35837.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110544',2192571,'1972','297',28505.89,28505.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110553',2192757,'1950','297',238758.11,238758.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110553',2192758,'1951','297',501449.45,503829.87,2380.42,335639.22,0.00,0.00,0.00,0.00,0.00),('1','116','717','110553',2192759,'1952','297',448278.90,449107.24,828.34,116795.94,0.00,0.00,0.00,0.00,0.00),('1','116','717','110553',2192760,'1953','297',399069.12,400494.75,1425.63,201013.83,0.00,0.00,0.00,0.00,0.00),('1','116','717','110553',2192761,'1954','297',268346.70,268346.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110553',2192762,'1955','297',266395.21,268004.25,1609.04,226874.64,0.00,0.00,0.00,0.00,0.00),('1','116','717','110553',2192763,'1956','297',352279.14,353979.14,1700.00,239700.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110553',2192764,'1957','297',467763.00,470611.55,2848.55,401645.55,0.00,0.00,0.00,0.00,0.00),('1','116','719','110553',2192765,'1966','298',225879.73,226728.32,848.59,182446.85,0.00,0.00,0.00,0.00,0.00),('1','116','720','110553',2192766,'1967','297',38061.31,38061.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110553',2192767,'1968','297',319908.27,321860.37,1952.10,275246.10,0.00,0.00,0.00,0.00,0.00),('1','116','720','110553',2192768,'1969','297',241819.01,241819.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110553',2192769,'1970','297',213199.27,214893.92,1694.65,238945.65,0.00,0.00,0.00,0.00,0.00),('1','116','720','110553',2192770,'1971','297',35837.78,35837.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110553',2192771,'1972','297',28505.89,28505.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110556',2192811,'1950','297',238758.11,240142.52,1384.41,195201.81,0.00,0.00,0.00,0.00,0.00),('1','116','717','110556',2192812,'1951','297',503829.87,505391.65,1561.78,220210.98,0.00,0.00,0.00,0.00,0.00),('1','116','717','110556',2192813,'1952','297',449107.24,449107.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110556',2192814,'1953','297',400494.75,403160.43,2665.68,375860.88,0.00,0.00,0.00,0.00,0.00),('1','116','717','110556',2192815,'1954','297',268346.70,268346.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110556',2192816,'1955','297',268004.25,269850.22,1845.97,260281.77,0.00,0.00,0.00,0.00,0.00),('1','116','717','110556',2192817,'1956','297',353979.14,356670.21,2691.07,379440.87,0.00,0.00,0.00,0.00,0.00),('1','116','717','110556',2192818,'1957','297',470611.55,470611.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','110556',2192819,'1966','298',226728.32,227125.06,396.74,85299.10,0.00,0.00,0.00,0.00,0.00),('1','116','720','110556',2192820,'1967','297',38061.31,38061.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110556',2192821,'1968','297',321860.37,323420.67,1560.30,220002.30,0.00,0.00,0.00,0.00,0.00),('1','116','720','110556',2192822,'1969','297',241819.01,243455.83,1636.82,230791.62,0.00,0.00,0.00,0.00,0.00),('1','116','720','110556',2192823,'1970','297',214893.92,214893.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110556',2192824,'1971','297',35837.78,35837.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110556',2192825,'1972','297',28505.89,28505.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110557',2192826,'1950','297',240142.52,240713.08,570.56,80448.96,0.00,0.00,0.00,0.00,0.00),('1','116','717','110557',2192827,'1951','297',505391.65,506720.65,1329.00,187389.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110557',2192828,'1952','297',449107.24,449107.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110557',2192829,'1953','297',403160.43,405255.99,2095.56,295473.96,0.00,0.00,0.00,0.00,0.00),('1','116','717','110557',2192830,'1954','297',268346.70,269925.85,1579.15,222660.15,0.00,0.00,0.00,0.00,0.00),('1','116','717','110557',2192831,'1955','297',269850.22,269850.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110557',2192832,'1956','297',356670.21,356670.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110557',2192833,'1957','297',470611.55,472440.03,1828.48,257815.68,0.00,0.00,0.00,0.00,0.00),('1','116','719','110557',2192834,'1966','298',227125.06,227617.18,492.12,105805.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','110557',2192835,'1967','297',38061.31,38061.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110557',2192836,'1968','297',323420.67,324930.47,1509.80,212881.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','110557',2192837,'1969','297',243455.83,245486.98,2031.15,286392.15,0.00,0.00,0.00,0.00,0.00),('1','116','720','110557',2192838,'1970','297',214893.92,214893.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110557',2192839,'1971','297',35837.78,35837.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110557',2192840,'1972','297',28505.89,28505.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110558',2192841,'1950','297',240713.08,240713.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110558',2192842,'1951','297',506720.65,509135.56,2414.91,340502.31,0.00,0.00,0.00,0.00,0.00),('1','116','717','110558',2192843,'1952','297',449107.24,449107.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110558',2192844,'1953','297',405255.99,408388.52,3132.53,441686.73,0.00,0.00,0.00,0.00,0.00),('1','116','717','110558',2192845,'1954','297',269925.85,271068.91,1143.06,161171.46,0.00,0.00,0.00,0.00,0.00),('1','116','717','110558',2192846,'1955','297',269850.22,271478.13,1627.91,229535.31,0.00,0.00,0.00,0.00,0.00),('1','116','717','110558',2192847,'1956','297',356670.21,356670.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110558',2192848,'1957','297',472440.03,475187.42,2747.39,387381.99,0.00,0.00,0.00,0.00,0.00),('1','116','719','110558',2192849,'1966','298',227617.18,229201.14,1583.96,340551.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','110558',2192850,'1967','297',38061.31,38061.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110558',2192851,'1968','297',324930.47,327158.07,2227.60,314091.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','110558',2192852,'1969','297',245486.98,245996.85,509.87,71891.67,0.00,0.00,0.00,0.00,0.00),('1','116','720','110558',2192853,'1970','297',214893.92,215381.35,487.43,68727.63,0.00,0.00,0.00,0.00,0.00),('1','116','720','110558',2192854,'1971','297',35837.78,35837.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110558',2192855,'1972','297',28505.89,28505.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110571',2193122,'1950','297',240713.08,242185.39,1462.31,206185.71,0.00,0.00,10.00,0.00,0.00),('1','116','717','110571',2193123,'1951','297',509135.56,510399.56,1254.00,176814.00,0.00,0.00,10.00,0.00,0.00),('1','116','717','110571',2193124,'1952','297',449107.24,449117.36,0.12,16.92,0.00,0.00,10.00,0.00,0.00),('1','116','717','110571',2193125,'1953','297',408388.52,411262.39,2863.87,403805.67,0.00,0.00,10.00,0.00,0.00),('1','116','717','110571',2193126,'1954','297',271068.91,272344.89,1265.98,178503.18,0.00,0.00,10.00,0.00,0.00),('1','116','717','110571',2193127,'1955','297',271478.13,272386.43,898.30,126660.30,0.00,0.00,10.00,0.00,0.00),('1','116','717','110571',2193128,'1956','297',356670.21,356680.21,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','116','717','110571',2193129,'1957','297',475187.42,477176.83,1979.41,279096.81,0.00,0.00,10.00,0.00,0.00),('1','116','719','110571',2193130,'1966','298',229201.14,229493.69,282.55,60748.25,0.00,0.00,10.00,0.00,0.00),('1','116','720','110571',2193131,'1967','297',38061.31,39110.65,1009.34,142316.94,0.00,0.00,40.00,0.00,0.00),('1','116','720','110571',2193132,'1968','297',327158.07,328057.62,889.55,125426.55,0.00,0.00,10.00,0.00,0.00),('1','116','720','110571',2193133,'1969','297',245996.85,246006.90,0.05,7.05,0.00,0.00,10.00,0.00,0.00),('1','116','720','110571',2193134,'1970','297',215381.35,217387.84,1996.49,281505.09,0.00,0.00,10.00,0.00,0.00),('1','116','720','110571',2193135,'1971','297',35837.78,35837.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110571',2193136,'1972','297',28505.89,28505.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110584',2193341,'1950','297',242185.39,242185.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110584',2193342,'1951','297',510399.56,513670.33,3270.77,461178.57,0.00,0.00,0.00,0.00,0.00),('1','116','717','110584',2193343,'1952','297',449117.36,449117.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110584',2193344,'1953','297',411262.39,415124.07,3861.68,544496.88,0.00,0.00,0.00,0.00,0.00),('1','116','717','110584',2193345,'1954','297',272344.89,272548.83,203.94,28755.54,0.00,0.00,0.00,0.00,0.00),('1','116','717','110584',2193346,'1955','297',272386.43,273669.32,1282.89,180887.49,0.00,0.00,0.00,0.00,0.00),('1','116','717','110584',2193347,'1956','297',356680.21,357234.48,554.27,78152.07,0.00,0.00,0.00,0.00,0.00),('1','116','717','110584',2193348,'1957','297',477176.83,481324.57,4147.74,584831.34,0.00,0.00,0.00,0.00,0.00),('1','116','719','110584',2193349,'1966','298',229493.69,230213.24,719.55,154703.25,0.00,0.00,0.00,0.00,0.00),('1','116','720','110584',2193350,'1967','297',39110.65,40810.65,1700.00,239700.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110584',2193351,'1968','297',328057.62,330578.85,2521.23,355493.43,0.00,0.00,0.00,0.00,0.00),('1','116','720','110584',2193352,'1969','297',246006.90,246006.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110584',2193353,'1970','297',217387.84,219656.13,2268.29,319828.89,0.00,0.00,0.00,0.00,0.00),('1','116','720','110584',2193354,'1971','297',35837.78,35837.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110584',2193355,'1972','297',28505.89,28505.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110585',2193356,'1950','297',242185.39,242185.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110585',2193357,'1951','297',513670.33,515928.87,2258.54,318454.14,0.00,0.00,0.00,0.00,0.00),('1','116','717','110585',2193358,'1952','297',449117.36,449117.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110585',2193359,'1953','297',415124.07,417423.51,2299.44,324221.04,0.00,0.00,0.00,0.00,0.00),('1','116','717','110585',2193360,'1954','297',272548.83,273395.83,847.00,119427.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110585',2193361,'1955','297',273669.32,274608.58,939.26,132435.66,0.00,0.00,0.00,0.00,0.00),('1','116','717','110585',2193362,'1956','297',357234.48,357234.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110585',2193363,'1957','297',481324.57,483225.99,1901.42,268100.22,0.00,0.00,0.00,0.00,0.00),('1','116','719','110585',2193364,'1966','298',230213.24,231173.15,959.91,206380.65,0.00,0.00,0.00,0.00,0.00),('1','116','720','110585',2193365,'1967','297',40810.65,41762.65,952.00,134232.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110585',2193366,'1968','297',330578.85,331887.12,1308.27,184466.07,0.00,0.00,0.00,0.00,0.00),('1','116','720','110585',2193367,'1969','297',246006.90,247412.47,1405.57,198185.37,0.00,0.00,0.00,0.00,0.00),('1','116','720','110585',2193368,'1970','297',219656.13,219656.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110585',2193369,'1971','297',35837.78,35837.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110585',2193370,'1972','297',28505.89,28505.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110586',2193371,'1950','297',242185.39,242185.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110586',2193372,'1951','297',515928.87,519109.44,3180.57,448460.37,0.00,0.00,0.00,0.00,0.00),('1','116','717','110586',2193373,'1952','297',449117.36,449117.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110586',2193374,'1953','297',417423.51,420483.50,3059.99,431458.59,0.00,0.00,0.00,0.00,0.00),('1','116','717','110586',2193375,'1954','297',273395.83,275820.56,2424.73,341886.93,0.00,0.00,0.00,0.00,0.00),('1','116','717','110586',2193376,'1955','297',274608.58,276610.34,2001.76,282248.16,0.00,0.00,0.00,0.00,0.00),('1','116','717','110586',2193377,'1956','297',357234.48,357234.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110586',2193378,'1957','297',483225.99,486766.02,3540.03,499144.23,0.00,0.00,0.00,0.00,0.00),('1','116','719','110586',2193379,'1966','298',231173.15,232498.08,1324.93,284859.95,0.00,0.00,0.00,0.00,0.00),('1','116','720','110586',2193380,'1967','297',41762.65,41762.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110586',2193381,'1968','297',331887.12,333744.24,1857.12,261853.92,0.00,0.00,0.00,0.00,0.00),('1','116','720','110586',2193382,'1969','297',247412.47,249112.47,1700.00,239700.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110586',2193383,'1970','297',219656.13,223167.39,3511.26,495087.66,0.00,0.00,0.00,0.00,0.00),('1','116','720','110586',2193384,'1971','297',35837.78,35837.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110586',2193385,'1972','297',28505.89,28505.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110593',2193551,'1950','297',242185.39,242185.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110593',2193552,'1951','297',519109.44,521724.70,2615.26,368751.66,0.00,0.00,0.00,0.00,0.00),('1','116','717','110593',2193553,'1952','297',449117.36,449117.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110593',2193554,'1953','297',420483.50,422188.33,1704.83,240381.03,0.00,0.00,0.00,0.00,0.00),('1','116','717','110593',2193555,'1954','297',275820.56,278012.01,2191.45,308994.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','110593',2193556,'1955','297',276610.34,276610.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110593',2193557,'1956','297',357234.48,357234.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110593',2193558,'1957','297',486766.02,488721.33,1955.31,275698.71,0.00,0.00,0.00,0.00,0.00),('1','116','719','110593',2193559,'1966','298',232498.08,233875.28,1377.20,296098.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110593',2193560,'1967','297',41762.65,41762.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110593',2193561,'1968','297',333744.24,335550.36,1806.12,254662.92,0.00,0.00,0.00,0.00,0.00),('1','116','720','110593',2193562,'1969','297',249112.47,250465.92,1353.45,190836.45,0.00,0.00,0.00,0.00,0.00),('1','116','720','110593',2193563,'1970','297',223167.39,225038.92,1871.53,263885.73,0.00,0.00,0.00,0.00,0.00),('1','116','720','110593',2193564,'1971','297',35837.78,35837.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110593',2193565,'1972','297',28505.89,28505.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110608',2193878,'1950','297',242185.39,242723.17,537.78,75826.98,0.00,0.00,0.00,0.00,0.00),('1','116','717','110608',2193879,'1951','297',521724.70,521724.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110608',2193880,'1952','297',449117.36,449117.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110608',2193881,'1953','297',422188.33,422515.09,326.76,46073.16,0.00,0.00,0.00,0.00,0.00),('1','116','717','110608',2193882,'1954','297',278012.01,278012.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110608',2193883,'1955','297',276610.34,277208.94,598.60,84402.60,0.00,0.00,0.00,0.00,0.00),('1','116','717','110608',2193884,'1956','297',357234.48,357234.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110608',2193885,'1957','297',488721.33,489328.96,607.63,85675.83,0.00,0.00,0.00,0.00,0.00),('1','116','719','110608',2193886,'1966','298',233875.28,235666.95,1791.67,385209.05,0.00,0.00,0.00,0.00,0.00),('1','116','720','110608',2193887,'1967','297',41762.65,44125.15,2362.50,333112.50,0.00,0.00,0.00,0.00,0.00),('1','116','720','110608',2193888,'1968','297',335550.36,338273.69,2723.33,383989.53,0.00,0.00,0.00,0.00,0.00),('1','116','720','110608',2193889,'1969','297',250465.92,253371.15,2905.23,409637.43,0.00,0.00,0.00,0.00,0.00),('1','116','720','110608',2193890,'1970','297',225038.92,228378.35,3339.43,470859.63,0.00,0.00,0.00,0.00,0.00),('1','116','720','110608',2193891,'1971','297',35837.78,35842.75,4.97,700.77,0.00,0.00,0.00,0.00,0.00),('1','116','720','110608',2193892,'1972','297',28505.89,29588.84,1082.95,152695.95,0.00,0.00,0.00,0.00,0.00),('1','116','717','110610',2193910,'1950','297',242723.17,242723.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110610',2193911,'1951','297',521724.70,523914.13,2189.43,308709.63,0.00,0.00,0.00,0.00,0.00),('1','116','717','110610',2193912,'1952','297',449117.36,449117.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110610',2193913,'1953','297',422515.09,425106.21,2591.12,365347.92,0.00,0.00,0.00,0.00,0.00),('1','116','717','110610',2193914,'1954','297',278012.01,278801.75,789.74,111353.34,0.00,0.00,0.00,0.00,0.00),('1','116','717','110610',2193915,'1955','297',277208.94,279441.65,2232.71,314812.11,0.00,0.00,0.00,0.00,0.00),('1','116','717','110610',2193916,'1956','297',357234.48,357234.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110610',2193917,'1957','297',489328.96,491983.26,2654.30,374256.30,0.00,0.00,0.00,0.00,0.00),('1','116','719','110610',2193918,'1966','298',235666.95,235666.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110610',2193919,'1967','297',44125.15,44708.05,582.90,82188.90,0.00,0.00,0.00,0.00,0.00),('1','116','720','110610',2193920,'1968','297',338273.69,340133.87,1860.18,262285.38,0.00,0.00,0.00,0.00,0.00),('1','116','720','110610',2193921,'1969','297',253371.15,253371.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110610',2193922,'1970','297',228378.35,230941.76,2563.41,361440.81,0.00,0.00,0.00,0.00,0.00),('1','116','720','110610',2193923,'1971','297',35842.75,35842.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110610',2193924,'1972','297',29588.84,29588.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110611',2193925,'1950','297',242723.17,244114.87,1391.70,196229.70,0.00,0.00,0.00,0.00,0.00),('1','116','717','110611',2193926,'1951','297',523914.13,526731.23,2817.10,397211.10,0.00,0.00,0.00,0.00,0.00),('1','116','717','110611',2193927,'1952','297',449117.36,449117.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110611',2193928,'1953','297',425106.21,427365.90,2259.69,318616.29,0.00,0.00,0.00,0.00,0.00),('1','116','717','110611',2193929,'1954','297',278801.75,280575.21,1773.46,250057.86,0.00,0.00,0.00,0.00,0.00),('1','116','717','110611',2193930,'1955','297',279441.65,281024.90,1583.25,223238.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','110611',2193931,'1956','297',357234.48,360300.94,3066.46,432370.86,0.00,0.00,0.00,0.00,0.00),('1','116','717','110611',2193932,'1957','297',491983.26,491983.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','110611',2193933,'1966','298',235666.95,235666.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110611',2193934,'1967','297',44708.05,45879.05,1171.00,165111.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110611',2193935,'1968','297',340133.87,342202.29,2068.42,291647.22,0.00,0.00,0.00,0.00,0.00),('1','116','720','110611',2193936,'1969','297',253371.15,253371.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110611',2193937,'1970','297',230941.76,233651.44,2709.68,382064.88,0.00,0.00,0.00,0.00,0.00),('1','116','720','110611',2193938,'1971','297',35842.75,35860.48,17.73,2499.93,0.00,0.00,0.00,0.00,0.00),('1','116','720','110611',2193939,'1972','297',29588.84,29659.48,70.64,9960.24,0.00,0.00,0.00,0.00,0.00),('1','116','717','110616',2194026,'1950','297',244114.87,244114.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110616',2194027,'1951','297',526731.23,529828.76,3097.53,436751.73,0.00,0.00,0.00,0.00,0.00),('1','116','717','110616',2194028,'1952','297',449117.36,449117.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110616',2194029,'1953','297',427365.90,430006.37,2640.47,372306.27,0.00,0.00,0.00,0.00,0.00),('1','116','717','110616',2194030,'1954','297',280575.21,280575.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110616',2194031,'1955','297',281024.90,282996.65,1971.75,278016.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','110616',2194032,'1956','297',360300.94,360300.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110616',2194033,'1957','297',491983.26,494647.26,2664.00,375624.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','110616',2194034,'1966','298',235666.95,235666.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110616',2194035,'1967','297',45879.05,45879.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110616',2194036,'1968','297',342202.29,344566.37,2364.08,333335.28,0.00,0.00,0.00,0.00,0.00),('1','116','720','110616',2194037,'1969','297',253371.15,253371.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110616',2194038,'1970','297',233651.44,236044.27,2392.83,337389.03,0.00,0.00,0.00,0.00,0.00),('1','116','720','110616',2194039,'1971','297',35860.48,35860.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110616',2194040,'1972','297',29659.48,29659.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110617',2194041,'1950','297',244114.87,244237.78,122.91,17330.31,0.00,0.00,0.00,0.00,0.00),('1','116','717','110617',2194042,'1951','297',529828.76,533393.97,3565.21,502694.61,0.00,0.00,0.00,0.00,0.00),('1','116','717','110617',2194043,'1952','297',449117.36,449117.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110617',2194044,'1953','297',430006.37,433407.00,3400.63,479488.83,0.00,0.00,0.00,0.00,0.00),('1','116','717','110617',2194045,'1954','297',280575.21,280575.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110617',2194046,'1955','297',282996.65,285548.99,2552.34,359879.94,0.00,0.00,0.00,0.00,0.00),('1','116','717','110617',2194047,'1956','297',360300.94,362463.94,2163.00,304983.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110617',2194048,'1957','297',494647.26,496973.19,2325.93,327956.13,0.00,0.00,0.00,0.00,0.00),('1','116','719','110617',2194049,'1966','298',235666.95,235666.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110617',2194050,'1967','297',45879.05,45879.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110617',2194051,'1968','297',344566.37,344786.62,220.25,31055.25,0.00,0.00,0.00,0.00,0.00),('1','116','720','110617',2194052,'1969','297',253371.15,253605.30,234.15,33015.15,0.00,0.00,0.00,0.00,0.00),('1','116','720','110617',2194053,'1970','297',236044.27,236354.24,309.97,43705.77,0.00,0.00,0.00,0.00,0.00),('1','116','720','110617',2194054,'1971','297',35860.48,35860.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110617',2194055,'1972','297',29659.48,29659.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110619',2194087,'1950','297',244237.78,245371.08,1133.30,159795.30,0.00,0.00,0.00,0.00,0.00),('1','116','717','110619',2194088,'1951','297',533393.97,535227.05,1833.08,258464.28,0.00,0.00,0.00,0.00,0.00),('1','116','717','110619',2194089,'1952','297',449117.36,449117.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110619',2194090,'1953','297',433407.00,435719.85,2312.85,326111.85,0.00,0.00,0.00,0.00,0.00),('1','116','717','110619',2194091,'1954','297',280575.21,281092.23,517.02,72899.82,0.00,0.00,0.00,0.00,0.00),('1','116','717','110619',2194092,'1955','297',285548.99,287174.91,1625.92,229254.72,0.00,0.00,0.00,0.00,0.00),('1','116','717','110619',2194093,'1956','297',362463.94,363969.07,1505.13,212223.33,0.00,0.00,0.00,0.00,0.00),('1','116','717','110619',2194094,'1957','297',496973.19,498445.31,1472.12,207568.92,0.00,0.00,0.00,0.00,0.00),('1','116','719','110619',2194095,'1966','298',235666.95,235666.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110619',2194096,'1967','297',45879.05,45879.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110619',2194097,'1968','297',344786.62,344786.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110619',2194098,'1969','297',253605.30,253605.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110619',2194099,'1970','297',236354.24,236354.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110619',2194100,'1971','297',35860.48,35860.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110619',2194101,'1972','297',29659.48,29659.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110620',2194102,'1950','297',245371.08,247274.22,1903.14,268342.74,0.00,0.00,0.00,0.00,0.00),('1','116','717','110620',2194103,'1951','297',535227.05,537163.61,1936.56,273054.96,0.00,0.00,0.00,0.00,0.00),('1','116','717','110620',2194104,'1952','297',449117.36,449117.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110620',2194105,'1953','297',435719.85,438717.16,2997.31,422620.71,0.00,0.00,0.00,0.00,0.00),('1','116','717','110620',2194106,'1954','297',281092.23,281092.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110620',2194107,'1955','297',287174.91,289661.37,2486.46,350590.86,0.00,0.00,0.00,0.00,0.00),('1','116','717','110620',2194108,'1956','297',363969.07,366138.78,2169.71,305929.11,0.00,0.00,0.00,0.00,0.00),('1','116','717','110620',2194109,'1957','297',498445.31,500647.73,2202.42,310541.22,0.00,0.00,0.00,0.00,0.00),('1','116','719','110620',2194110,'1966','298',235666.95,235666.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110620',2194111,'1967','297',45879.05,45879.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110620',2194112,'1968','297',344786.62,344786.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110620',2194113,'1969','297',253605.30,253605.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110620',2194114,'1970','297',236354.24,236354.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110620',2194115,'1971','297',35860.48,35860.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110620',2194116,'1972','297',29659.48,29659.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110685',2195337,'1950','297',247274.22,249595.81,2321.59,327344.19,0.00,0.00,0.00,0.00,0.00),('1','116','717','110685',2195338,'1951','297',537163.61,539325.82,2162.21,304871.61,0.00,0.00,0.00,0.00,0.00),('1','116','717','110685',2195339,'1952','297',449117.36,449117.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110685',2195340,'1953','297',438717.16,441576.68,2859.52,403192.32,0.00,0.00,0.00,0.00,0.00),('1','116','717','110685',2195341,'1954','297',281092.23,282456.45,1364.22,192355.02,0.00,0.00,0.00,0.00,0.00),('1','116','717','110685',2195342,'1955','297',289661.37,291239.25,1577.88,222481.08,0.00,0.00,0.00,0.00,0.00),('1','116','717','110685',2195343,'1956','297',366138.78,367593.16,1454.38,205067.58,0.00,0.00,0.00,0.00,0.00),('1','116','717','110685',2195344,'1957','297',500647.73,503020.44,2372.71,334552.11,0.00,0.00,0.00,0.00,0.00),('1','116','719','110685',2195345,'1966','298',235666.95,235666.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110685',2195346,'1967','297',45879.05,45879.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110685',2195347,'1968','297',344786.62,344786.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110685',2195348,'1969','297',253605.30,253605.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110685',2195349,'1970','297',236354.24,236354.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110685',2195350,'1971','297',35860.48,35860.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110685',2195351,'1972','297',29659.48,29659.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','110780',2197389,'1950','297',249595.81,251867.37,2271.56,320289.96,0.00,0.00,0.00,0.00,0.00),('1','116','717','110780',2197390,'1951','297',539325.82,541881.12,2555.30,360297.30,0.00,0.00,0.00,0.00,0.00),('1','116','717','110780',2197391,'1952','297',449117.36,449226.06,78.70,11096.70,0.00,0.00,30.00,0.00,0.00),('1','116','717','110780',2197392,'1953','297',441576.68,445415.67,3838.99,541297.59,0.00,0.00,0.00,0.00,0.00),('1','116','717','110780',2197393,'1954','297',282456.45,285422.02,2965.57,418145.37,0.00,0.00,0.00,0.00,0.00),('1','116','717','110780',2197394,'1955','297',291239.25,293047.16,1807.91,254915.31,0.00,0.00,0.00,0.00,0.00),('1','116','717','110780',2197395,'1956','297',367593.16,370246.33,2653.17,374096.97,0.00,0.00,0.00,0.00,0.00),('1','116','717','110780',2197396,'1957','297',503020.44,506125.54,3105.10,437819.10,0.00,0.00,0.00,0.00,0.00),('1','116','719','110780',2197397,'1966','298',235666.95,235666.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110780',2197398,'1967','297',45879.05,45879.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110780',2197399,'1968','297',344786.62,344786.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110780',2197400,'1969','297',253605.30,253605.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110780',2197401,'1970','297',236354.24,236354.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110780',2197402,'1971','297',35860.48,35860.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','110780',2197403,'1972','297',29659.48,29659.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111046',2202666,'1950','297',251867.37,253259.53,1392.16,196294.56,0.00,0.00,0.00,0.00,0.00),('1','116','717','111046',2202667,'1951','297',541881.12,543322.72,1441.60,203265.60,0.00,0.00,0.00,0.00,0.00),('1','116','717','111046',2202668,'1952','297',449226.06,449247.33,21.27,2999.07,0.00,0.00,0.00,0.00,0.00),('1','116','717','111046',2202669,'1953','297',445415.67,447596.29,2180.62,307467.42,0.00,0.00,0.00,0.00,0.00),('1','116','717','111046',2202670,'1954','297',285422.02,286560.47,1138.45,160521.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','111046',2202671,'1955','297',293047.16,294123.10,1075.94,151707.54,0.00,0.00,0.00,0.00,0.00),('1','116','717','111046',2202672,'1956','297',370246.33,371495.37,1249.04,176114.64,0.00,0.00,0.00,0.00,0.00),('1','116','717','111046',2202673,'1957','297',506125.54,507680.41,1554.87,219236.67,0.00,0.00,0.00,0.00,0.00),('1','116','719','111046',2202674,'1966','298',235666.95,235666.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111046',2202675,'1967','297',45879.05,45879.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111046',2202676,'1968','297',344786.62,344786.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111046',2202677,'1969','297',253605.30,253605.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111046',2202678,'1970','297',236354.24,236354.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111046',2202679,'1971','297',35860.48,35860.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111046',2202680,'1972','297',29659.48,29659.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111054',2202813,'1950','297',253259.53,253259.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111054',2202814,'1951','297',543322.72,546818.34,3495.62,492882.42,0.00,0.00,0.00,0.00,0.00),('1','116','717','111054',2202815,'1952','297',449247.33,449247.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111054',2202816,'1953','297',447596.29,450621.59,3025.30,426567.30,0.00,0.00,0.00,0.00,0.00),('1','116','717','111054',2202817,'1954','297',286560.47,286560.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111054',2202818,'1955','297',294123.10,296317.50,2194.40,309410.40,0.00,0.00,0.00,0.00,0.00),('1','116','717','111054',2202819,'1956','297',371495.37,373640.16,2144.79,302415.39,0.00,0.00,0.00,0.00,0.00),('1','116','717','111054',2202820,'1957','297',507680.41,510327.66,2647.25,373262.25,0.00,0.00,0.00,0.00,0.00),('1','116','719','111054',2202821,'1966','298',235666.95,235666.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111054',2202822,'1967','297',45879.05,45879.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111054',2202823,'1968','297',344786.62,344786.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111054',2202824,'1969','297',253605.30,253605.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111054',2202825,'1970','297',236354.24,236354.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111054',2202826,'1971','297',35860.48,35860.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111054',2202827,'1972','297',29659.48,29659.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111063',2202962,'1950','297',253259.53,253259.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111063',2202963,'1951','297',546818.34,549083.19,2264.85,319343.85,0.00,0.00,0.00,0.00,0.00),('1','116','717','111063',2202964,'1952','297',449247.33,449247.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111063',2202965,'1953','297',450621.59,452524.45,1902.86,268303.26,0.00,0.00,0.00,0.00,0.00),('1','116','717','111063',2202966,'1954','297',286560.47,288015.22,1454.75,205119.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','111063',2202967,'1955','297',296317.50,298245.06,1927.56,271785.96,0.00,0.00,0.00,0.00,0.00),('1','116','717','111063',2202968,'1956','297',373640.16,375416.81,1776.65,250507.65,0.00,0.00,0.00,0.00,0.00),('1','116','717','111063',2202969,'1957','297',510327.66,512449.25,2121.59,299144.19,0.00,0.00,0.00,0.00,0.00),('1','116','719','111063',2202970,'1966','298',235666.95,238954.15,3287.20,706748.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111063',2202971,'1967','297',45879.05,46595.47,716.42,101015.22,0.00,0.00,0.00,0.00,0.00),('1','116','720','111063',2202972,'1968','297',344786.62,347175.82,2389.20,336877.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','111063',2202973,'1969','297',253605.30,255550.17,1944.87,274226.67,0.00,0.00,0.00,0.00,0.00),('1','116','720','111063',2202974,'1970','297',236354.24,237684.68,1330.44,187592.04,0.00,0.00,0.00,0.00,0.00),('1','116','720','111063',2202975,'1971','297',35860.48,35890.27,29.79,4200.39,0.00,0.00,0.00,0.00,0.00),('1','116','720','111063',2202976,'1972','297',29659.48,30319.48,660.00,93060.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111122',2204147,'1950','297',253259.53,253259.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111122',2204148,'1951','297',549083.19,551280.63,2197.44,309839.04,0.00,0.00,0.00,0.00,0.00),('1','116','717','111122',2204149,'1952','297',449247.33,449247.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111122',2204150,'1953','297',452524.45,455541.58,3017.13,425415.33,0.00,0.00,0.00,0.00,0.00),('1','116','717','111122',2204151,'1954','297',288015.22,289809.72,1794.50,253024.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','111122',2204152,'1955','297',298245.06,298245.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111122',2204153,'1956','297',375416.81,375416.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111122',2204154,'1957','297',512449.25,515126.63,2677.38,377510.58,0.00,0.00,0.00,0.00,0.00),('1','116','719','111122',2204155,'1966','298',238954.15,238997.64,43.49,9350.35,0.00,0.00,0.00,0.00,0.00),('1','116','720','111122',2204156,'1967','297',46595.47,48511.25,1915.78,270124.98,0.00,0.00,0.00,0.00,0.00),('1','116','720','111122',2204157,'1968','297',347175.82,347175.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111122',2204158,'1969','297',255550.17,256590.41,1040.24,146673.84,0.00,0.00,0.00,0.00,0.00),('1','116','720','111122',2204159,'1970','297',237684.68,238526.28,841.60,118665.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','111122',2204160,'1971','297',35890.27,35890.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111122',2204161,'1972','297',30319.48,30319.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111177',2205358,'1950','297',253259.53,253259.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111177',2205359,'1951','297',551280.63,554354.65,3074.02,433436.82,0.00,0.00,0.00,0.00,0.00),('1','116','717','111177',2205360,'1952','297',449247.33,449247.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111177',2205361,'1953','297',455541.58,459011.03,3469.45,489192.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','111177',2205362,'1954','297',289809.72,292597.74,2788.02,393110.82,0.00,0.00,0.00,0.00,0.00),('1','116','717','111177',2205363,'1955','297',298245.06,298245.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111177',2205364,'1956','297',375416.81,375416.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111177',2205365,'1957','297',515126.63,518173.73,3047.10,429641.10,0.00,0.00,0.00,0.00,0.00),('1','116','719','111177',2205366,'1966','298',238997.64,242403.47,3405.83,732253.45,0.00,0.00,0.00,0.00,0.00),('1','116','720','111177',2205367,'1967','297',48511.25,48511.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111177',2205368,'1968','297',347175.82,349489.42,2313.60,326217.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','111177',2205369,'1969','297',256590.41,258264.96,1674.55,236111.55,0.00,0.00,0.00,0.00,0.00),('1','116','720','111177',2205370,'1970','297',238526.28,240966.24,2439.96,344034.36,0.00,0.00,0.00,0.00,0.00),('1','116','720','111177',2205371,'1971','297',35890.27,35890.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111177',2205372,'1972','297',30319.48,30319.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111193',2205619,'1950','297',253259.53,253259.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111193',2205620,'1951','297',554354.65,556524.98,2170.33,306016.53,0.00,0.00,0.00,0.00,0.00),('1','116','717','111193',2205621,'1952','297',449247.33,452213.44,2966.11,418221.51,0.00,0.00,0.00,0.00,0.00),('1','116','717','111193',2205622,'1953','297',459011.03,459011.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111193',2205623,'1954','297',292597.74,294725.26,2127.52,299980.32,0.00,0.00,0.00,0.00,0.00),('1','116','717','111193',2205624,'1955','297',298245.06,298245.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111193',2205625,'1956','297',375416.81,375416.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111193',2205626,'1957','297',518173.73,521289.57,3115.84,439333.44,0.00,0.00,0.00,0.00,0.00),('1','116','719','111193',2205627,'1966','298',242403.47,243400.03,996.56,214260.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','111193',2205628,'1967','297',48511.25,48511.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111193',2205629,'1968','297',349489.42,352048.08,2558.66,360771.06,0.00,0.00,0.00,0.00,0.00),('1','116','720','111193',2205630,'1969','297',258264.96,258264.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111193',2205631,'1970','297',240966.24,243865.08,2898.84,408736.44,0.00,0.00,0.00,0.00,0.00),('1','116','720','111193',2205632,'1971','297',35890.27,35890.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111193',2205633,'1972','297',30319.48,30319.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111327',2208314,'1950','297',253259.53,255178.92,1919.39,270633.99,0.00,0.00,0.00,0.00,0.00),('1','116','717','111327',2208315,'1951','297',556524.98,558689.46,2164.48,305191.68,0.00,0.00,0.00,0.00,0.00),('1','116','717','111327',2208316,'1952','297',452213.44,455028.64,2815.20,396943.20,0.00,0.00,0.00,0.00,0.00),('1','116','717','111327',2208317,'1953','297',459011.03,460183.64,1172.61,165338.01,0.00,0.00,0.00,0.00,0.00),('1','116','717','111327',2208318,'1954','297',294725.26,296811.61,2086.35,294175.35,0.00,0.00,0.00,0.00,0.00),('1','116','717','111327',2208319,'1955','297',298245.06,298749.13,504.07,71073.87,0.00,0.00,0.00,0.00,0.00),('1','116','717','111327',2208320,'1956','297',375416.81,375416.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111327',2208321,'1957','297',521289.57,524371.55,3081.98,434559.18,0.00,0.00,0.00,0.00,0.00),('1','116','719','111327',2208322,'1966','298',243400.03,244516.37,1116.34,240013.10,0.00,0.00,0.00,0.00,0.00),('1','116','720','111327',2208323,'1967','297',48511.25,50343.95,1832.70,258410.70,0.00,0.00,0.00,0.00,0.00),('1','116','720','111327',2208324,'1968','297',352048.08,354623.16,2575.08,363086.28,0.00,0.00,0.00,0.00,0.00),('1','116','720','111327',2208325,'1969','297',258264.96,260714.73,2449.77,345417.57,0.00,0.00,0.00,0.00,0.00),('1','116','720','111327',2208326,'1970','297',243865.08,244080.68,215.60,30399.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','111327',2208327,'1971','297',35890.27,35890.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111327',2208328,'1972','297',30319.48,30319.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111337',2208453,'1950','297',255178.92,255782.37,603.45,85086.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','111337',2208454,'1951','297',558689.46,559565.55,876.09,123528.69,0.00,0.00,0.00,0.00,0.00),('1','116','717','111337',2208455,'1952','297',455028.64,456385.38,1356.74,191300.34,0.00,0.00,0.00,0.00,0.00),('1','116','717','111337',2208456,'1953','297',460183.64,460643.19,459.55,64796.55,0.00,0.00,0.00,0.00,0.00),('1','116','717','111337',2208457,'1954','297',296811.61,297460.28,648.67,91462.47,0.00,0.00,0.00,0.00,0.00),('1','116','717','111337',2208458,'1955','297',298749.13,299372.22,623.09,87855.69,0.00,0.00,0.00,0.00,0.00),('1','116','717','111337',2208459,'1956','297',375416.81,375884.16,467.35,65896.35,0.00,0.00,0.00,0.00,0.00),('1','116','717','111337',2208460,'1957','297',524371.55,525320.89,949.34,133856.94,0.00,0.00,0.00,0.00,0.00),('1','116','719','111337',2208461,'1966','298',244516.37,245995.95,1479.58,318109.70,0.00,0.00,0.00,0.00,0.00),('1','116','720','111337',2208462,'1967','297',50343.95,52784.38,2430.43,342690.63,0.00,0.00,10.00,0.00,0.00),('1','116','720','111337',2208463,'1968','297',354623.16,357205.36,2572.20,362680.20,0.00,0.00,10.00,0.00,0.00),('1','116','720','111337',2208464,'1969','297',260714.73,262971.01,2246.28,316725.48,0.00,0.00,10.00,0.00,0.00),('1','116','720','111337',2208465,'1970','297',244080.68,247069.03,2978.35,419947.35,0.00,0.00,10.00,0.00,0.00),('1','116','720','111337',2208466,'1971','297',35890.27,36017.31,127.04,17912.64,0.00,0.00,0.00,0.00,0.00),('1','116','720','111337',2208467,'1972','297',30319.48,30367.33,47.85,6746.85,0.00,0.00,0.00,0.00,0.00),('1','116','717','111400',2209743,'1950','297',255782.37,257762.63,1970.26,277806.66,0.00,0.00,10.00,0.00,0.00),('1','116','717','111400',2209744,'1951','297',559565.55,561929.82,2354.27,331952.07,0.00,0.00,10.00,0.00,0.00),('1','116','717','111400',2209745,'1952','297',456385.38,456439.49,23.33,3289.53,0.00,0.00,30.78,0.00,0.00),('1','116','717','111400',2209746,'1953','297',460643.19,464082.20,3429.01,483490.41,0.00,0.00,10.00,0.00,0.00),('1','116','717','111400',2209747,'1954','297',297460.28,299588.33,2108.05,297235.05,0.00,0.00,20.00,0.00,0.00),('1','116','717','111400',2209748,'1955','297',299372.22,301347.72,1965.50,277135.50,0.00,0.00,10.00,0.00,0.00),('1','116','717','111400',2209749,'1956','297',375884.16,377959.03,2064.87,291146.67,0.00,0.00,10.00,0.00,0.00),('1','116','717','111400',2209750,'1957','297',525320.89,528418.87,3087.98,435405.18,0.00,0.00,10.00,0.00,0.00),('1','116','719','111400',2209751,'1966','298',245995.95,247759.04,1743.09,374764.35,0.00,0.00,20.00,0.00,0.00),('1','116','720','111400',2209752,'1967','297',52784.38,52784.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111400',2209753,'1968','297',357205.36,357205.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111400',2209754,'1969','297',262971.01,262971.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111400',2209755,'1970','297',247069.03,247069.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111400',2209756,'1971','297',36017.31,36017.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111400',2209757,'1972','297',30367.33,30367.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111404',2209840,'1950','297',257762.63,258827.14,1064.51,150095.91,0.00,0.00,0.00,0.00,0.00),('1','116','717','111404',2209841,'1951','297',561929.82,563483.65,1553.83,219090.03,0.00,0.00,0.00,0.00,0.00),('1','116','717','111404',2209842,'1952','297',456439.49,458078.23,1638.74,231062.34,0.00,0.00,0.00,0.00,0.00),('1','116','717','111404',2209843,'1953','297',464082.20,465901.44,1819.24,256512.84,0.00,0.00,0.00,0.00,0.00),('1','116','717','111404',2209844,'1954','297',299588.33,300629.28,1040.95,146773.95,0.00,0.00,0.00,0.00,0.00),('1','116','717','111404',2209845,'1955','297',301347.72,302244.03,896.31,126379.71,0.00,0.00,0.00,0.00,0.00),('1','116','717','111404',2209846,'1956','297',377959.03,379463.12,1504.09,212076.69,0.00,0.00,0.00,0.00,0.00),('1','116','717','111404',2209847,'1957','297',528418.87,529682.26,1263.39,178137.99,0.00,0.00,0.00,0.00,0.00),('1','116','719','111404',2209848,'1966','298',247759.04,249118.03,1358.99,292182.85,0.00,0.00,0.00,0.00,0.00),('1','116','720','111404',2209849,'1967','297',52784.38,52784.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111404',2209850,'1968','297',357205.36,357205.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111404',2209851,'1969','297',262971.01,262971.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111404',2209852,'1970','297',247069.03,247069.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111404',2209853,'1971','297',36017.31,36017.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111404',2209854,'1972','297',30367.33,30367.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111684',2215358,'1950','297',258827.14,260489.59,1662.45,234405.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','111684',2215359,'1951','297',563483.65,564784.55,1300.90,183426.90,0.00,0.00,0.00,0.00,0.00),('1','116','717','111684',2215360,'1952','297',458078.23,460574.25,2496.02,351938.82,0.00,0.00,0.00,0.00,0.00),('1','116','717','111684',2215361,'1953','297',465901.44,465901.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111684',2215362,'1954','297',300629.28,300629.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111684',2215363,'1955','297',302244.03,304222.30,1978.27,278936.07,0.00,0.00,0.00,0.00,0.00),('1','116','717','111684',2215364,'1956','297',379463.12,379463.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111684',2215365,'1957','297',529682.26,532338.92,2656.66,374589.06,0.00,0.00,0.00,0.00,0.00),('1','116','719','111684',2215366,'1966','298',249118.03,249837.26,719.23,154634.45,0.00,0.00,0.00,0.00,0.00),('1','116','720','111684',2215367,'1967','297',52784.38,52804.38,20.00,2820.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111684',2215368,'1968','297',357205.36,359178.07,1972.71,278152.11,0.00,0.00,0.00,0.00,0.00),('1','116','720','111684',2215369,'1969','297',262971.01,262986.50,15.49,2184.09,0.00,0.00,0.00,0.00,0.00),('1','116','720','111684',2215370,'1970','297',247069.03,249055.55,1986.52,280099.32,0.00,0.00,0.00,0.00,0.00),('1','116','720','111684',2215371,'1971','297',36017.31,36017.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111684',2215372,'1972','297',30367.33,30367.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111687',2215431,'1950','297',260489.59,262445.49,1955.90,275781.90,0.00,0.00,0.00,0.00,0.00),('1','116','717','111687',2215432,'1951','297',564784.55,564784.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111687',2215433,'1952','297',460574.25,463338.56,2764.31,389767.71,0.00,0.00,0.00,0.00,0.00),('1','116','717','111687',2215434,'1953','297',465901.44,465901.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111687',2215435,'1954','297',300629.28,301844.51,1215.23,171347.43,0.00,0.00,0.00,0.00,0.00),('1','116','717','111687',2215436,'1955','297',304222.30,304222.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111687',2215437,'1956','297',379463.12,379463.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111687',2215438,'1957','297',532338.92,534929.66,2590.74,365294.34,0.00,0.00,0.00,0.00,0.00),('1','116','719','111687',2215439,'1966','298',249837.26,250868.19,1030.93,221649.95,0.00,0.00,0.00,0.00,0.00),('1','116','720','111687',2215440,'1967','297',52804.38,52804.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111687',2215441,'1968','297',359178.07,361641.26,2463.19,347309.79,0.00,0.00,0.00,0.00,0.00),('1','116','720','111687',2215442,'1969','297',262986.50,262986.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111687',2215443,'1970','297',249055.55,251628.72,2573.17,362816.97,0.00,0.00,0.00,0.00,0.00),('1','116','720','111687',2215444,'1971','297',36017.31,36017.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111687',2215445,'1972','297',30367.33,30367.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111689',2215475,'1950','297',262445.49,265224.58,2779.09,391851.69,0.00,0.00,0.00,0.00,0.00),('1','116','717','111689',2215476,'1951','297',564784.55,564858.31,73.76,10400.16,0.00,0.00,0.00,0.00,0.00),('1','116','717','111689',2215477,'1952','297',463338.56,466198.82,2860.26,403296.66,0.00,0.00,0.00,0.00,0.00),('1','116','717','111689',2215478,'1953','297',465901.44,468151.55,2250.11,317265.51,0.00,0.00,0.00,0.00,0.00),('1','116','717','111689',2215479,'1954','297',301844.51,301844.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111689',2215480,'1955','297',304222.30,306845.28,2622.98,369840.18,0.00,0.00,0.00,0.00,0.00),('1','116','717','111689',2215481,'1956','297',379463.12,381320.49,1857.37,261889.17,0.00,0.00,0.00,0.00,0.00),('1','116','717','111689',2215482,'1957','297',534929.66,536641.71,1712.05,241399.05,0.00,0.00,0.00,0.00,0.00),('1','116','719','111689',2215483,'1966','298',250868.19,252371.02,1502.83,323108.45,0.00,0.00,0.00,0.00,0.00),('1','116','720','111689',2215484,'1967','297',52804.38,55199.78,2395.40,337751.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','111689',2215485,'1968','297',361641.26,361641.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111689',2215486,'1969','297',262986.50,262986.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111689',2215487,'1970','297',251628.72,255166.73,3538.01,498859.41,0.00,0.00,0.00,0.00,0.00),('1','116','720','111689',2215488,'1971','297',36017.31,36017.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111689',2215489,'1972','297',30367.33,30367.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111700',2215632,'1950','297',265224.58,267426.99,2202.41,310539.81,0.00,0.00,0.00,0.00,0.00),('1','116','717','111700',2215633,'1951','297',564858.31,564858.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111700',2215634,'1952','297',466198.82,469424.02,3225.20,454753.20,0.00,0.00,0.00,0.00,0.00),('1','116','717','111700',2215635,'1953','297',468151.55,468318.93,167.38,23600.58,0.00,0.00,0.00,0.00,0.00),('1','116','717','111700',2215636,'1954','297',301844.51,302970.59,1126.08,158777.28,0.00,0.00,0.00,0.00,0.00),('1','116','717','111700',2215637,'1955','297',306845.28,308686.21,1840.93,259571.13,0.00,0.00,0.00,0.00,0.00),('1','116','717','111700',2215638,'1956','297',381320.49,381320.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111700',2215639,'1957','297',536641.71,539325.42,2683.71,378403.11,0.00,0.00,0.00,0.00,0.00),('1','116','719','111700',2215640,'1966','298',252371.02,253292.10,921.08,198032.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','111700',2215641,'1967','297',55199.78,55199.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111700',2215642,'1968','297',361641.26,364124.00,2482.74,350066.34,0.00,0.00,0.00,0.00,0.00),('1','116','720','111700',2215643,'1969','297',262986.50,262986.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111700',2215644,'1970','297',255166.73,258065.41,2898.68,408713.88,0.00,0.00,0.00,0.00,0.00),('1','116','720','111700',2215645,'1971','297',36017.31,36017.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111700',2215646,'1972','297',30367.33,30367.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111837',2218391,'1950','297',267426.99,269082.83,1655.84,233473.44,0.00,0.00,0.00,0.00,0.00),('1','116','717','111837',2218392,'1951','297',564858.31,564858.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111837',2218393,'1952','297',469424.02,470968.28,1544.26,217740.66,0.00,0.00,0.00,0.00,0.00),('1','116','717','111837',2218394,'1953','297',468318.93,470548.77,2229.84,314407.44,0.00,0.00,0.00,0.00,0.00),('1','116','717','111837',2218395,'1954','297',302970.59,304387.23,1416.64,199746.24,0.00,0.00,0.00,0.00,0.00),('1','116','717','111837',2218396,'1955','297',308686.21,310112.01,1425.80,201037.80,0.00,0.00,0.00,0.00,0.00),('1','116','717','111837',2218397,'1956','297',381320.49,383178.10,1857.61,261923.01,0.00,0.00,0.00,0.00,0.00),('1','116','717','111837',2218398,'1957','297',539325.42,539325.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','111837',2218399,'1966','298',253292.10,254091.82,799.72,171939.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','111837',2218400,'1967','297',55199.78,57444.53,2244.75,316509.75,0.00,0.00,0.00,0.00,0.00),('1','116','720','111837',2218401,'1968','297',364124.00,365053.20,929.20,131017.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','111837',2218402,'1969','297',262986.50,263824.34,837.84,118135.44,0.00,0.00,0.00,0.00,0.00),('1','116','720','111837',2218403,'1970','297',258065.41,261494.12,3428.71,483448.11,0.00,0.00,0.00,0.00,0.00),('1','116','720','111837',2218404,'1971','297',36017.31,36018.80,1.49,210.09,0.00,0.00,0.00,0.00,0.00),('1','116','720','111837',2218405,'1972','297',30367.33,31049.90,682.57,96242.37,0.00,0.00,0.00,0.00,0.00),('1','116','717','111838',2218406,'1950','297',269082.83,271139.25,2056.42,289955.22,0.00,0.00,0.00,0.00,0.00),('1','116','717','111838',2218407,'1951','297',564858.31,564858.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111838',2218408,'1952','297',470968.28,472952.00,1983.72,279704.52,0.00,0.00,0.00,0.00,0.00),('1','116','717','111838',2218409,'1953','297',470548.77,471971.32,1422.55,200579.55,0.00,0.00,0.00,0.00,0.00),('1','116','717','111838',2218410,'1954','297',304387.23,305310.31,923.08,130154.28,0.00,0.00,0.00,0.00,0.00),('1','116','717','111838',2218411,'1955','297',310112.01,311985.01,1873.00,264093.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111838',2218412,'1956','297',383178.10,384598.02,1419.92,200208.72,0.00,0.00,0.00,0.00,0.00),('1','116','717','111838',2218413,'1957','297',539325.42,541252.07,1926.65,271657.65,0.00,0.00,0.00,0.00,0.00),('1','116','719','111838',2218414,'1966','298',254091.82,254906.14,814.32,175078.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','111838',2218415,'1967','297',57444.53,57444.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111838',2218416,'1968','297',365053.20,365711.46,658.26,92814.66,0.00,0.00,0.00,0.00,0.00),('1','116','720','111838',2218417,'1969','297',263824.34,263824.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111838',2218418,'1970','297',261494.12,262378.69,884.57,124724.37,0.00,0.00,0.00,0.00,0.00),('1','116','720','111838',2218419,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111838',2218420,'1972','297',31049.90,31049.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111962',2220934,'1950','297',271139.25,275059.32,3920.07,552729.87,0.00,0.00,0.00,0.00,0.00),('1','116','717','111962',2220935,'1951','297',564858.31,564858.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111962',2220936,'1952','297',472952.00,475593.50,2641.50,372451.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','111962',2220937,'1953','297',471971.32,474662.81,2691.49,379500.09,0.00,0.00,0.00,0.00,0.00),('1','116','717','111962',2220938,'1954','297',305310.31,307614.44,2304.13,324882.33,0.00,0.00,0.00,0.00,0.00),('1','116','717','111962',2220939,'1955','297',311985.01,314716.35,2731.34,385118.94,0.00,0.00,0.00,0.00,0.00),('1','116','717','111962',2220940,'1956','297',384598.02,387317.38,2719.36,383429.76,0.00,0.00,0.00,0.00,0.00),('1','116','717','111962',2220941,'1957','297',541252.07,544789.96,3537.89,498842.49,0.00,0.00,0.00,0.00,0.00),('1','116','719','111962',2220942,'1966','298',254906.14,256463.10,1556.96,334746.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','111962',2220943,'1967','297',57444.53,57444.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111962',2220944,'1968','297',365711.46,365711.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111962',2220945,'1969','297',263824.34,263824.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111962',2220946,'1970','297',262378.69,262378.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111962',2220947,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111962',2220948,'1972','297',31049.90,31049.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111963',2220949,'1950','297',275059.32,276913.56,1854.24,261447.84,0.00,0.00,0.00,0.00,0.00),('1','116','717','111963',2220950,'1951','297',564858.31,564858.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','111963',2220951,'1952','297',475593.50,477732.74,2139.24,301632.84,0.00,0.00,0.00,0.00,0.00),('1','116','717','111963',2220952,'1953','297',474662.81,477008.27,2345.46,330709.86,0.00,0.00,0.00,0.00,0.00),('1','116','717','111963',2220953,'1954','297',307614.44,309675.21,2060.77,290568.57,0.00,0.00,0.00,0.00,0.00),('1','116','717','111963',2220954,'1955','297',314716.35,316168.10,1451.75,204696.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','111963',2220955,'1956','297',387317.38,389007.09,1689.71,238249.11,0.00,0.00,0.00,0.00,0.00),('1','116','717','111963',2220956,'1957','297',544789.96,547605.27,2815.31,396958.71,0.00,0.00,0.00,0.00,0.00),('1','116','719','111963',2220957,'1966','298',256463.10,258058.87,1595.77,343090.55,0.00,0.00,0.00,0.00,0.00),('1','116','720','111963',2220958,'1967','297',57444.53,57444.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111963',2220959,'1968','297',365711.46,365711.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111963',2220960,'1969','297',263824.34,263824.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111963',2220961,'1970','297',262378.69,262378.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111963',2220962,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','111963',2220963,'1972','297',31049.90,31049.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112018',2222154,'1950','297',276913.56,276913.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112018',2222155,'1951','297',564858.31,564858.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112018',2222156,'1952','297',477732.74,477732.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112018',2222157,'1953','297',477008.27,477008.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112018',2222158,'1954','297',309675.21,309675.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112018',2222159,'1955','297',316168.10,316168.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112018',2222160,'1956','297',389007.09,389007.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112018',2222161,'1957','297',547605.27,547605.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','112018',2222162,'1966','298',258058.87,259395.14,1336.27,287298.05,0.00,0.00,0.00,0.00,0.00),('1','116','720','112018',2222163,'1967','297',57444.53,57934.50,489.97,69085.77,0.00,0.00,0.00,0.00,0.00),('1','116','720','112018',2222164,'1968','297',365711.46,366206.98,495.52,69868.32,0.00,0.00,0.00,0.00,0.00),('1','116','720','112018',2222165,'1969','297',263824.34,264596.63,772.29,108892.89,0.00,0.00,0.00,0.00,0.00),('1','116','720','112018',2222166,'1970','297',262378.69,263020.31,641.62,90468.42,0.00,0.00,0.00,0.00,0.00),('1','116','720','112018',2222167,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112018',2222168,'1972','297',31049.90,31542.77,492.87,69494.67,0.00,0.00,0.00,0.00,0.00),('1','116','717','112021',2222209,'1950','297',276913.56,278935.76,2022.20,285130.20,0.00,0.00,0.00,0.00,0.00),('1','116','717','112021',2222210,'1951','297',564858.31,564858.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112021',2222211,'1952','297',477732.74,477732.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112021',2222212,'1953','297',477008.27,480297.38,3289.11,463764.51,0.00,0.00,0.00,0.00,0.00),('1','116','717','112021',2222213,'1954','297',309675.21,310826.53,1151.32,162336.12,0.00,0.00,0.00,0.00,0.00),('1','116','717','112021',2222214,'1955','297',316168.10,318267.01,2098.91,295946.31,0.00,0.00,0.00,0.00,0.00),('1','116','717','112021',2222215,'1956','297',389007.09,391610.32,2603.23,367055.43,0.00,0.00,0.00,0.00,0.00),('1','116','717','112021',2222216,'1957','297',547605.27,547605.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','112021',2222217,'1966','298',259395.14,259594.99,199.85,42967.75,0.00,0.00,0.00,0.00,0.00),('1','116','720','112021',2222218,'1967','297',57934.50,57934.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112021',2222219,'1968','297',366206.98,368845.73,2638.75,372063.75,0.00,0.00,0.00,0.00,0.00),('1','116','720','112021',2222220,'1969','297',264596.63,264596.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112021',2222221,'1970','297',263020.31,265752.71,2732.40,385268.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','112021',2222222,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112021',2222223,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112138',2224548,'1950','297',278935.76,282255.87,3320.11,468135.51,0.00,0.00,0.00,0.00,0.00),('1','116','717','112138',2224549,'1951','297',564858.31,564858.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112138',2224550,'1952','297',477732.74,481681.61,3948.87,556790.67,0.00,0.00,0.00,0.00,0.00),('1','116','717','112138',2224551,'1953','297',480297.38,480297.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112138',2224552,'1954','297',310826.53,313991.61,3165.08,446276.28,0.00,0.00,0.00,0.00,0.00),('1','116','717','112138',2224553,'1955','297',318267.01,319708.77,1441.76,203288.16,0.00,0.00,0.00,0.00,0.00),('1','116','717','112138',2224554,'1956','297',391610.32,395220.77,3610.45,509073.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','112138',2224555,'1957','297',547605.27,547605.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','112138',2224556,'1966','298',259594.99,260534.83,939.84,202065.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','112138',2224557,'1967','297',57934.50,60817.32,2882.82,406477.62,0.00,0.00,0.00,0.00,0.00),('1','116','720','112138',2224558,'1968','297',368845.73,368845.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112138',2224559,'1969','297',264596.63,264596.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112138',2224560,'1970','297',265752.71,269695.82,3943.11,555978.51,0.00,0.00,0.00,0.00,0.00),('1','116','720','112138',2224561,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112138',2224562,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112176',2225251,'1950','297',282255.87,282426.26,170.39,24024.99,0.00,0.00,0.00,0.00,0.00),('1','116','717','112176',2225252,'1951','297',564858.31,565263.42,405.11,57120.51,0.00,0.00,0.00,0.00,0.00),('1','116','717','112176',2225253,'1952','297',481681.61,484361.01,2679.40,377795.40,0.00,0.00,0.00,0.00,0.00),('1','116','717','112176',2225254,'1953','297',480297.38,480695.90,398.52,56191.32,0.00,0.00,0.00,0.00,0.00),('1','116','717','112176',2225255,'1954','297',313991.61,316929.28,2937.67,414211.47,0.00,0.00,0.00,0.00,0.00),('1','116','717','112176',2225256,'1955','297',319708.77,319708.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112176',2225257,'1956','297',395220.77,397726.24,2505.47,353271.27,0.00,0.00,0.00,0.00,0.00),('1','116','717','112176',2225258,'1957','297',547605.27,547605.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','112176',2225259,'1966','298',260534.83,260888.40,353.57,76017.55,0.00,0.00,0.00,0.00,0.00),('1','116','720','112176',2225260,'1967','297',60817.32,60817.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112176',2225261,'1968','297',368845.73,371165.63,2319.90,327105.90,0.00,0.00,0.00,0.00,0.00),('1','116','720','112176',2225262,'1969','297',264596.63,264596.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112176',2225263,'1970','297',269695.82,272071.75,2375.93,335006.13,0.00,0.00,0.00,0.00,0.00),('1','116','720','112176',2225264,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112176',2225265,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112424',2230357,'1950','297',282426.26,285123.80,2697.54,380353.14,0.00,0.00,0.00,0.00,0.00),('1','116','717','112424',2230358,'1951','297',565263.42,565263.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112424',2230359,'1952','297',484361.01,487878.38,3517.37,495949.17,0.00,0.00,0.00,0.00,0.00),('1','116','717','112424',2230360,'1953','297',480695.90,484405.70,3709.80,523081.80,0.00,0.00,0.00,0.00,0.00),('1','116','717','112424',2230361,'1954','297',316929.28,318862.55,1933.27,272591.07,0.00,0.00,0.00,0.00,0.00),('1','116','717','112424',2230362,'1955','297',319708.77,321921.73,2212.96,312027.36,0.00,0.00,0.00,0.00,0.00),('1','116','717','112424',2230363,'1956','297',397726.24,400512.68,2786.44,392888.04,0.00,0.00,0.00,0.00,0.00),('1','116','717','112424',2230364,'1957','297',547605.27,550066.47,2461.20,347029.20,0.00,0.00,0.00,0.00,0.00),('1','116','719','112424',2230365,'1966','298',260888.40,261823.89,935.49,201130.35,0.00,0.00,0.00,0.00,0.00),('1','116','720','112424',2230366,'1967','297',60817.32,60817.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112424',2230367,'1968','297',371165.63,371165.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112424',2230368,'1969','297',264596.63,264596.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112424',2230369,'1970','297',272071.75,272071.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112424',2230370,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112424',2230371,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112426',2230388,'1950','297',285123.80,287526.83,2403.03,338827.23,0.00,0.00,0.00,0.00,0.00),('1','116','717','112426',2230389,'1951','297',565263.42,565263.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112426',2230390,'1952','297',487878.38,490289.83,2411.45,340014.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','112426',2230391,'1953','297',484405.70,484405.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112426',2230392,'1954','297',318862.55,321372.03,2509.48,353836.68,0.00,0.00,0.00,0.00,0.00),('1','116','717','112426',2230393,'1955','297',321921.73,322428.40,506.67,71440.47,0.00,0.00,0.00,0.00,0.00),('1','116','717','112426',2230394,'1956','297',400512.68,402329.42,1816.74,256160.34,0.00,0.00,0.00,0.00,0.00),('1','116','717','112426',2230395,'1957','297',550066.47,552181.16,2114.69,298171.29,0.00,0.00,0.00,0.00,0.00),('1','116','719','112426',2230396,'1966','298',261823.89,262429.97,606.08,130307.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','112426',2230397,'1967','297',60817.32,60817.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112426',2230398,'1968','297',371165.63,371165.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112426',2230399,'1969','297',264596.63,264596.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112426',2230400,'1970','297',272071.75,272071.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112426',2230401,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112426',2230402,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112428',2230425,'1950','297',287526.83,289472.63,1945.80,274357.80,0.00,0.00,0.00,0.00,0.00),('1','116','717','112428',2230426,'1951','297',565263.42,565263.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112428',2230427,'1952','297',490289.83,493356.80,3066.97,432442.77,0.00,0.00,0.00,0.00,0.00),('1','116','717','112428',2230428,'1953','297',484405.70,484906.27,500.57,70580.37,0.00,0.00,0.00,0.00,0.00),('1','116','717','112428',2230429,'1954','297',321372.03,322921.76,1549.73,218511.93,0.00,0.00,0.00,0.00,0.00),('1','116','717','112428',2230430,'1955','297',322428.40,324349.71,1921.31,270904.71,0.00,0.00,0.00,0.00,0.00),('1','116','717','112428',2230431,'1956','297',402329.42,404556.78,2227.36,314057.76,0.00,0.00,0.00,0.00,0.00),('1','116','717','112428',2230432,'1957','297',552181.16,554730.47,2549.31,359452.71,0.00,0.00,0.00,0.00,0.00),('1','116','719','112428',2230433,'1966','298',262429.97,264011.34,1581.37,339994.55,0.00,0.00,0.00,0.00,0.00),('1','116','720','112428',2230434,'1967','297',60817.32,60817.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112428',2230435,'1968','297',371165.63,371165.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112428',2230436,'1969','297',264596.63,264596.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112428',2230437,'1970','297',272071.75,272071.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112428',2230438,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112428',2230439,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112431',2230499,'1950','297',289472.63,291595.59,2122.96,299337.36,0.00,0.00,0.00,0.00,0.00),('1','116','717','112431',2230500,'1951','297',565263.42,565263.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112431',2230501,'1952','297',493356.80,495747.73,2390.93,337121.13,0.00,0.00,0.00,0.00,0.00),('1','116','717','112431',2230502,'1953','297',484906.27,486972.41,2066.14,291325.74,0.00,0.00,0.00,0.00,0.00),('1','116','717','112431',2230503,'1954','297',322921.76,324828.15,1896.39,267390.99,0.00,0.00,10.00,0.00,0.00),('1','116','717','112431',2230504,'1955','297',324349.71,325581.08,1211.37,170803.17,0.00,0.00,20.00,0.00,0.00),('1','116','717','112431',2230505,'1956','297',404556.78,406661.68,2084.90,293970.90,0.00,0.00,20.00,0.00,0.00),('1','116','717','112431',2230506,'1957','297',554730.47,556539.64,1799.17,253682.97,0.00,0.00,10.00,0.00,0.00),('1','116','719','112431',2230507,'1966','298',264011.34,265243.33,1231.99,264877.85,0.00,0.00,0.00,0.00,0.00),('1','116','720','112431',2230508,'1967','297',60817.32,60817.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112431',2230509,'1968','297',371165.63,371165.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112431',2230510,'1969','297',264596.63,264596.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112431',2230511,'1970','297',272071.75,272071.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112431',2230512,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112431',2230513,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112473',2231611,'1950','297',291595.59,294668.05,3062.46,431806.86,0.00,0.00,10.00,0.00,0.00),('1','116','717','112473',2231612,'1951','297',565263.42,565263.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112473',2231613,'1952','297',495747.73,498845.65,3087.92,435396.72,0.00,0.00,10.00,0.00,0.00),('1','116','717','112473',2231614,'1953','297',486972.41,490154.59,3172.18,447277.38,0.00,0.00,10.00,0.00,0.00),('1','116','717','112473',2231615,'1954','297',324828.15,327112.55,2284.40,322100.40,0.00,0.00,0.00,0.00,0.00),('1','116','717','112473',2231616,'1955','297',325581.08,328057.56,2476.48,349183.68,0.00,0.00,0.00,0.00,0.00),('1','116','717','112473',2231617,'1956','297',406661.68,409275.20,2613.52,368506.32,0.00,0.00,0.00,0.00,0.00),('1','116','717','112473',2231618,'1957','297',556539.64,559321.72,2782.08,392273.28,0.00,0.00,0.00,0.00,0.00),('1','116','719','112473',2231619,'1966','298',265243.33,266195.10,951.77,204630.55,0.00,0.00,0.00,0.00,0.00),('1','116','720','112473',2231620,'1967','297',60817.32,60817.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112473',2231621,'1968','297',371165.63,371165.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112473',2231622,'1969','297',264596.63,264596.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112473',2231623,'1970','297',272071.75,272071.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112473',2231624,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112473',2231625,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112478',2231703,'1950','297',294668.05,297128.82,2460.77,346968.57,0.00,0.00,0.00,0.00,0.00),('1','116','717','112478',2231704,'1951','297',565263.42,565263.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112478',2231705,'1952','297',498845.65,500855.54,2009.89,283394.49,0.00,0.00,0.00,0.00,0.00),('1','116','717','112478',2231706,'1953','297',490154.59,492148.78,1994.19,281180.79,0.00,0.00,0.00,0.00,0.00),('1','116','717','112478',2231707,'1954','297',327112.55,328472.04,1359.49,191688.09,0.00,0.00,0.00,0.00,0.00),('1','116','717','112478',2231708,'1955','297',328057.56,330308.26,2250.70,317348.70,0.00,0.00,0.00,0.00,0.00),('1','116','717','112478',2231709,'1956','297',409275.20,411353.82,2078.62,293085.42,0.00,0.00,0.00,0.00,0.00),('1','116','717','112478',2231710,'1957','297',559321.72,561301.60,1979.88,279163.08,0.00,0.00,0.00,0.00,0.00),('1','116','719','112478',2231711,'1966','298',266195.10,268537.42,2342.32,503598.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','112478',2231712,'1967','297',60817.32,60817.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112478',2231713,'1968','297',371165.63,371165.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112478',2231714,'1969','297',264596.63,264596.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112478',2231715,'1970','297',272071.75,272071.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112478',2231716,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112478',2231717,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112640',2234946,'1950','297',297128.82,300545.88,3417.06,481805.46,0.00,0.00,0.00,0.00,0.00),('1','116','717','112640',2234947,'1951','297',565263.42,565263.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112640',2234948,'1952','297',500855.54,504575.52,3719.98,524517.18,0.00,0.00,0.00,0.00,0.00),('1','116','717','112640',2234949,'1953','297',492148.78,492148.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112640',2234950,'1954','297',328472.04,331916.68,3444.64,485694.24,0.00,0.00,0.00,0.00,0.00),('1','116','717','112640',2234951,'1955','297',330308.26,332773.49,2465.23,347597.43,0.00,0.00,0.00,0.00,0.00),('1','116','717','112640',2234952,'1956','297',411353.82,414193.26,2839.44,400361.04,0.00,0.00,0.00,0.00,0.00),('1','116','717','112640',2234953,'1957','297',561301.60,564213.07,2911.47,410517.27,0.00,0.00,0.00,0.00,0.00),('1','116','719','112640',2234954,'1966','298',268537.42,268922.82,385.40,82861.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112640',2234955,'1967','297',60817.32,60817.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112640',2234956,'1968','297',371165.63,371165.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112640',2234957,'1969','297',264596.63,264596.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112640',2234958,'1970','297',272071.75,272071.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112640',2234959,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112640',2234960,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112642',2235015,'1950','297',300545.88,302659.06,2113.18,297958.38,0.00,0.00,0.00,0.00,0.00),('1','116','717','112642',2235016,'1951','297',565263.42,565263.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112642',2235017,'1952','297',504575.52,506705.50,2109.42,297428.22,0.00,0.00,20.56,0.00,0.00),('1','116','717','112642',2235018,'1953','297',492148.78,494460.43,2311.65,325942.65,0.00,0.00,0.00,0.00,0.00),('1','116','717','112642',2235019,'1954','297',331916.68,333496.73,1559.49,219888.09,0.00,0.00,20.56,0.00,0.00),('1','116','717','112642',2235020,'1955','297',332773.49,334979.76,2206.27,311084.07,0.00,0.00,0.00,0.00,0.00),('1','116','717','112642',2235021,'1956','297',414193.26,416550.24,2336.98,329514.18,0.00,0.00,20.00,0.00,0.00),('1','116','717','112642',2235022,'1957','297',564213.07,566961.86,2728.23,384680.43,0.00,0.00,20.56,0.00,0.00),('1','116','719','112642',2235023,'1966','298',268922.82,270515.03,1572.21,338025.15,0.00,0.00,20.00,0.00,0.00),('1','116','720','112642',2235024,'1967','297',60817.32,60817.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112642',2235025,'1968','297',371165.63,371165.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112642',2235026,'1969','297',264596.63,264596.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112642',2235027,'1970','297',272071.75,272071.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112642',2235028,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112642',2235029,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112720',2236518,'1950','297',302659.06,306061.26,3402.20,479710.20,0.00,0.00,0.00,0.00,0.00),('1','116','717','112720',2236519,'1951','297',565263.42,565263.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112720',2236520,'1952','297',506705.50,511008.49,4292.66,605265.06,0.00,0.00,10.33,0.00,0.00),('1','116','717','112720',2236521,'1953','297',494460.43,494460.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112720',2236522,'1954','297',333496.73,333496.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112720',2236523,'1955','297',334979.76,338889.21,3909.45,551232.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','112720',2236524,'1956','297',416550.24,419507.98,2957.74,417041.34,0.00,0.00,0.00,0.00,0.00),('1','116','717','112720',2236525,'1957','297',566961.86,570486.16,3524.30,496926.30,0.00,0.00,0.00,0.00,0.00),('1','116','719','112720',2236526,'1966','298',270515.03,271561.13,1046.10,224911.50,0.00,0.00,0.00,0.00,0.00),('1','116','720','112720',2236527,'1967','297',60817.32,60817.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112720',2236528,'1968','297',371165.63,371165.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112720',2236529,'1969','297',264596.63,264596.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112720',2236530,'1970','297',272071.75,272071.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112720',2236531,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112720',2236532,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112734',2236836,'1950','297',306061.26,308660.43,2599.17,366482.97,0.00,0.00,0.00,0.00,0.00),('1','116','717','112734',2236837,'1951','297',565263.42,565263.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112734',2236838,'1952','297',511008.49,512746.97,1738.48,245125.68,0.00,0.00,0.00,0.00,0.00),('1','116','717','112734',2236839,'1953','297',494460.43,496805.81,2345.38,330698.58,0.00,0.00,0.00,0.00,0.00),('1','116','717','112734',2236840,'1954','297',333496.73,335456.37,1959.64,276309.24,0.00,0.00,0.00,0.00,0.00),('1','116','717','112734',2236841,'1955','297',338889.21,340872.53,1983.32,279648.12,0.00,0.00,0.00,0.00,0.00),('1','116','717','112734',2236842,'1956','297',419507.98,421930.97,2422.99,341641.59,0.00,0.00,0.00,0.00,0.00),('1','116','717','112734',2236843,'1957','297',570486.16,572780.14,2293.98,323451.18,0.00,0.00,0.00,0.00,0.00),('1','116','719','112734',2236844,'1966','298',271561.13,273248.16,1687.03,362711.45,0.00,0.00,0.00,0.00,0.00),('1','116','720','112734',2236845,'1967','297',60817.32,60817.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112734',2236846,'1968','297',371165.63,371165.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112734',2236847,'1969','297',264596.63,264596.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112734',2236848,'1970','297',272071.75,272071.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112734',2236849,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112734',2236850,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112854',2239498,'1950','297',308660.43,311723.73,3063.30,431925.30,0.00,0.00,0.00,0.00,0.00),('1','116','717','112854',2239499,'1951','297',565263.42,566921.65,1658.23,233810.43,0.00,0.00,0.00,0.00,0.00),('1','116','717','112854',2239500,'1952','297',512746.97,517113.54,4366.57,615686.37,0.00,0.00,0.00,0.00,0.00),('1','116','717','112854',2239501,'1953','297',496805.81,496805.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112854',2239502,'1954','297',335456.37,335456.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112854',2239503,'1955','297',340872.53,344529.88,3657.35,515686.35,0.00,0.00,0.00,0.00,0.00),('1','116','717','112854',2239504,'1956','297',421930.97,424192.54,2261.57,318881.37,0.00,0.00,0.00,0.00,0.00),('1','116','717','112854',2239505,'1957','297',572780.14,576500.91,3720.77,524628.57,0.00,0.00,0.00,0.00,0.00),('1','116','719','112854',2239506,'1966','298',273248.16,274752.84,1504.68,323506.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','112854',2239507,'1967','297',60817.32,60817.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112854',2239508,'1968','297',371165.63,371165.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112854',2239509,'1969','297',264596.63,264596.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112854',2239510,'1970','297',272071.75,272071.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112854',2239511,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112854',2239512,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112867',2239733,'1950','297',311723.73,314216.16,2492.43,351432.63,0.00,0.00,0.00,0.00,0.00),('1','116','717','112867',2239734,'1951','297',566921.65,566921.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112867',2239735,'1952','297',517113.54,517113.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112867',2239736,'1953','297',496805.81,499864.55,3058.74,431282.34,0.00,0.00,0.00,0.00,0.00),('1','116','717','112867',2239737,'1954','297',335456.37,336031.53,575.16,81097.56,0.00,0.00,0.00,0.00,0.00),('1','116','717','112867',2239738,'1955','297',344529.88,346583.07,2053.19,289499.79,0.00,0.00,0.00,0.00,0.00),('1','116','717','112867',2239739,'1956','297',424192.54,424694.24,501.70,70739.70,0.00,0.00,0.00,0.00,0.00),('1','116','717','112867',2239740,'1957','297',576500.91,579681.70,3180.79,448491.39,0.00,0.00,0.00,0.00,0.00),('1','116','719','112867',2239741,'1966','298',274752.84,275601.41,848.57,182442.55,0.00,0.00,0.00,0.00,0.00),('1','116','720','112867',2239742,'1967','297',60817.32,62211.71,1394.39,196608.99,0.00,0.00,0.00,0.00,0.00),('1','116','720','112867',2239743,'1968','297',371165.63,372135.83,970.20,136798.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','112867',2239744,'1969','297',264596.63,264596.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112867',2239745,'1970','297',272071.75,273657.38,1585.63,223573.83,0.00,0.00,0.00,0.00,0.00),('1','116','720','112867',2239746,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112867',2239747,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112984',2242186,'1950','297',314216.16,315000.93,784.77,110652.57,0.00,0.00,0.00,0.00,0.00),('1','116','717','112984',2242187,'1951','297',566921.65,570982.04,4060.39,572514.99,0.00,0.00,0.00,0.00,0.00),('1','116','717','112984',2242188,'1952','297',517113.54,519538.96,2425.42,341984.22,0.00,0.00,0.00,0.00,0.00),('1','116','717','112984',2242189,'1953','297',499864.55,500000.76,136.21,19205.61,0.00,0.00,0.00,0.00,0.00),('1','116','717','112984',2242190,'1954','297',336031.53,338476.05,2444.52,344677.32,0.00,0.00,0.00,0.00,0.00),('1','116','717','112984',2242191,'1955','297',346583.07,348861.25,2278.18,321223.38,0.00,0.00,0.00,0.00,0.00),('1','116','717','112984',2242192,'1956','297',424694.24,424694.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112984',2242193,'1957','297',579681.70,583288.64,3606.94,508578.54,0.00,0.00,0.00,0.00,0.00),('1','116','719','112984',2242194,'1966','298',275601.41,277730.03,2128.62,457653.30,0.00,0.00,0.00,0.00,0.00),('1','116','720','112984',2242195,'1967','297',62211.71,62211.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112984',2242196,'1968','297',372135.83,375654.88,3519.05,496186.05,0.00,0.00,0.00,0.00,0.00),('1','116','720','112984',2242197,'1969','297',264596.63,264596.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112984',2242198,'1970','297',273657.38,277456.10,3798.72,535619.52,0.00,0.00,0.00,0.00,0.00),('1','116','720','112984',2242199,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112984',2242200,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112986',2242230,'1950','297',315000.93,318405.38,3404.45,480027.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','112986',2242231,'1951','297',570982.04,570982.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112986',2242232,'1952','297',519538.96,519538.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112986',2242233,'1953','297',500000.76,502918.57,2917.81,411411.21,0.00,0.00,0.00,0.00,0.00),('1','116','717','112986',2242234,'1954','297',338476.05,338476.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112986',2242235,'1955','297',348861.25,351633.86,2772.61,390938.01,0.00,0.00,0.00,0.00,0.00),('1','116','717','112986',2242236,'1956','297',424694.24,424694.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','112986',2242237,'1957','297',583288.64,586535.28,3246.64,457776.24,0.00,0.00,0.00,0.00,0.00),('1','116','719','112986',2242238,'1966','298',277730.03,277730.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112986',2242239,'1967','297',62211.71,62211.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112986',2242240,'1968','297',375654.88,378324.07,2669.19,376355.79,0.00,0.00,0.00,0.00,0.00),('1','116','720','112986',2242241,'1969','297',264596.63,264596.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112986',2242242,'1970','297',277456.10,279823.54,2367.44,333809.04,0.00,0.00,0.00,0.00,0.00),('1','116','720','112986',2242243,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','112986',2242244,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113080',2244069,'1950','297',318405.38,318405.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113080',2244070,'1951','297',570982.04,574360.95,3378.91,476426.31,0.00,0.00,0.00,0.00,0.00),('1','116','717','113080',2244071,'1952','297',519538.96,522707.77,3168.81,446802.21,0.00,0.00,0.00,0.00,0.00),('1','116','717','113080',2244072,'1953','297',502918.57,503123.48,204.91,28892.31,0.00,0.00,0.00,0.00,0.00),('1','116','717','113080',2244073,'1954','297',338476.05,339286.52,810.47,114276.27,0.00,0.00,0.00,0.00,0.00),('1','116','717','113080',2244074,'1955','297',351633.86,354113.87,2480.01,349681.41,0.00,0.00,0.00,0.00,0.00),('1','116','717','113080',2244075,'1956','297',424694.24,425462.29,768.05,108295.05,0.00,0.00,0.00,0.00,0.00),('1','116','717','113080',2244076,'1957','297',586535.28,590046.66,3511.38,495104.58,0.00,0.00,0.00,0.00,0.00),('1','116','719','113080',2244077,'1966','298',277730.03,278985.88,1235.85,265707.75,0.00,0.00,20.00,0.00,0.00),('1','116','720','113080',2244078,'1967','297',62211.71,62211.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113080',2244079,'1968','297',378324.07,380026.16,1702.09,239994.69,0.00,0.00,0.00,0.00,0.00),('1','116','720','113080',2244080,'1969','297',264596.63,264596.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113080',2244081,'1970','297',279823.54,281790.59,1967.05,277354.05,0.00,0.00,0.00,0.00,0.00),('1','116','720','113080',2244082,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113080',2244083,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113265',2247671,'1950','297',318405.38,318405.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113265',2247672,'1951','297',574360.95,574360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113265',2247673,'1952','297',522707.77,522707.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113265',2247674,'1953','297',503123.48,506262.00,3138.52,442531.32,0.00,0.00,0.00,0.00,0.00),('1','116','717','113265',2247675,'1954','297',339286.52,339286.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113265',2247676,'1955','297',354113.87,356237.09,2123.22,299374.02,0.00,0.00,0.00,0.00,0.00),('1','116','717','113265',2247677,'1956','297',425462.29,425462.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113265',2247678,'1957','297',590046.66,592999.86,2953.20,416401.20,0.00,0.00,0.00,0.00,0.00),('1','116','719','113265',2247679,'1966','298',278985.88,278985.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113265',2247680,'1967','297',62211.71,62211.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113265',2247681,'1968','297',380026.16,381965.08,1938.92,273387.72,0.00,0.00,0.00,0.00,0.00),('1','116','720','113265',2247682,'1969','297',264596.63,264596.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113265',2247683,'1970','297',281790.59,284142.07,2351.48,331558.68,0.00,0.00,0.00,0.00,0.00),('1','116','720','113265',2247684,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113265',2247685,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113275',2247849,'1950','297',318405.38,320716.39,2311.01,325852.41,0.00,0.00,0.00,0.00,0.00),('1','116','717','113275',2247850,'1951','297',574360.95,575091.79,730.84,103048.44,0.00,0.00,0.00,0.00,0.00),('1','116','717','113275',2247851,'1952','297',522707.77,522707.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113275',2247852,'1953','297',506262.00,509147.97,2885.97,406921.77,0.00,0.00,0.00,0.00,0.00),('1','116','717','113275',2247853,'1954','297',339286.52,339286.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113275',2247854,'1955','297',356237.09,357283.20,1046.11,147501.51,0.00,0.00,0.00,0.00,0.00),('1','116','717','113275',2247855,'1956','297',425462.29,425462.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113275',2247856,'1957','297',592999.86,595772.47,2772.61,390938.01,0.00,0.00,0.00,0.00,0.00),('1','116','719','113275',2247857,'1966','298',278985.88,278985.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113275',2247858,'1967','297',62211.71,62211.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113275',2247859,'1968','297',381965.08,382609.83,644.75,90909.75,0.00,0.00,0.00,0.00,0.00),('1','116','720','113275',2247860,'1969','297',264596.63,267816.41,3219.78,453988.98,0.00,0.00,0.00,0.00,0.00),('1','116','720','113275',2247861,'1970','297',284142.07,284142.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113275',2247862,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113275',2247863,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113276',2247864,'1950','297',320716.39,322646.54,1930.15,272151.15,0.00,0.00,0.00,0.00,0.00),('1','116','717','113276',2247865,'1951','297',575091.79,575091.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113276',2247866,'1952','297',522707.77,522707.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113276',2247867,'1953','297',509147.97,511633.73,2485.76,350492.16,0.00,0.00,0.00,0.00,0.00),('1','116','717','113276',2247868,'1954','297',339286.52,340580.80,1294.28,182493.48,0.00,0.00,0.00,0.00,0.00),('1','116','717','113276',2247869,'1955','297',357283.20,359052.68,1769.48,249496.68,0.00,0.00,0.00,0.00,0.00),('1','116','717','113276',2247870,'1956','297',425462.29,425462.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113276',2247871,'1957','297',595772.47,598635.67,2863.20,403711.20,0.00,0.00,0.00,0.00,0.00),('1','116','719','113276',2247872,'1966','298',278985.88,278997.51,11.63,2500.45,0.00,0.00,0.00,0.00,0.00),('1','116','720','113276',2247873,'1967','297',62211.71,63245.88,1034.17,145817.97,0.00,0.00,0.00,0.00,0.00),('1','116','720','113276',2247874,'1968','297',382609.83,384304.67,1694.84,238972.44,0.00,0.00,0.00,0.00,0.00),('1','116','720','113276',2247875,'1969','297',267816.41,267816.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113276',2247876,'1970','297',284142.07,286551.94,2409.87,339791.67,0.00,0.00,0.00,0.00,0.00),('1','116','720','113276',2247877,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113276',2247878,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113322',2248887,'1950','297',322646.54,325791.37,3144.83,443421.03,0.00,0.00,0.00,0.00,0.00),('1','116','717','113322',2248888,'1951','297',575091.79,575091.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113322',2248889,'1952','297',522707.77,522707.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113322',2248890,'1953','297',511633.73,514906.83,3273.10,461507.10,0.00,0.00,0.00,0.00,0.00),('1','116','717','113322',2248891,'1954','297',340580.80,340580.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113322',2248892,'1955','297',359052.68,361873.72,2821.04,397766.64,0.00,0.00,0.00,0.00,0.00),('1','116','717','113322',2248893,'1956','297',425462.29,427832.33,2370.04,334175.64,0.00,0.00,0.00,0.00,0.00),('1','116','717','113322',2248894,'1957','297',598635.67,599996.93,1361.26,191937.66,0.00,0.00,0.00,0.00,0.00),('1','116','719','113322',2248895,'1966','298',278997.51,279097.51,100.00,21500.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113322',2248896,'1967','297',63245.88,63245.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113322',2248897,'1968','297',384304.67,387399.91,3095.24,436428.84,0.00,0.00,0.00,0.00,0.00),('1','116','720','113322',2248898,'1969','297',267816.41,267816.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113322',2248899,'1970','297',286551.94,288711.48,2159.54,304495.14,0.00,0.00,0.00,0.00,0.00),('1','116','720','113322',2248900,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113322',2248901,'1972','297',31542.77,31542.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113325',2248946,'1950','297',325791.37,327339.61,1528.24,215481.84,0.00,0.00,20.00,0.00,0.00),('1','116','717','113325',2248947,'1951','297',575091.79,575091.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113325',2248948,'1952','297',522707.77,522707.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113325',2248949,'1953','297',514906.83,516461.54,1534.71,216394.11,0.00,0.00,20.00,0.00,0.00),('1','116','717','113325',2248950,'1954','297',340580.80,341311.01,720.21,101549.61,0.00,0.00,10.00,0.00,0.00),('1','116','717','113325',2248951,'1955','297',361873.72,362598.15,704.43,99324.63,0.00,0.00,20.00,0.00,0.00),('1','116','717','113325',2248952,'1956','297',427832.33,427832.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113325',2248953,'1957','297',599996.93,601515.17,1498.24,211251.84,0.00,0.00,20.00,0.00,0.00),('1','116','719','113325',2248954,'1966','298',279097.51,279789.63,692.12,148805.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','113325',2248955,'1967','297',63245.88,64799.33,1533.45,216216.45,0.00,0.00,20.00,0.00,0.00),('1','116','720','113325',2248956,'1968','297',387399.91,389329.40,1919.49,270648.09,0.00,0.00,10.00,0.00,0.00),('1','116','720','113325',2248957,'1969','297',267816.41,269003.99,1167.58,164628.78,0.00,0.00,20.00,0.00,0.00),('1','116','720','113325',2248958,'1970','297',288711.48,291876.38,3144.90,443430.90,0.00,0.00,20.00,0.00,0.00),('1','116','720','113325',2248959,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113325',2248960,'1972','297',31542.77,32071.63,508.86,71749.26,0.00,0.00,20.00,0.00,0.00),('1','116','717','113432',2251363,'1950','297',327339.61,330397.36,3057.75,431142.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','113432',2251364,'1951','297',575091.79,575091.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113432',2251365,'1952','297',522707.77,526975.84,4268.07,601797.87,0.00,0.00,0.00,0.00,0.00),('1','116','717','113432',2251366,'1953','297',516461.54,516461.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113432',2251367,'1954','297',341311.01,341311.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113432',2251368,'1955','297',362598.15,365379.14,2780.99,392119.59,0.00,0.00,0.00,0.00,0.00),('1','116','717','113432',2251369,'1956','297',427832.33,430006.03,2173.70,306491.70,0.00,0.00,0.00,0.00,0.00),('1','116','717','113432',2251370,'1957','297',601515.17,604492.90,2977.73,419859.93,0.00,0.00,0.00,0.00,0.00),('1','116','719','113432',2251371,'1966','298',279789.63,279789.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113432',2251372,'1967','297',64799.33,64799.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113432',2251373,'1968','297',389329.40,391872.50,2543.10,358577.10,0.00,0.00,0.00,0.00,0.00),('1','116','720','113432',2251374,'1969','297',269003.99,269003.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113432',2251375,'1970','297',291876.38,295519.66,3643.28,513702.48,0.00,0.00,0.00,0.00,0.00),('1','116','720','113432',2251376,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113432',2251377,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113456',2251853,'1950','297',330397.36,332497.17,2099.81,296073.21,0.00,0.00,0.00,0.00,0.00),('1','116','717','113456',2251854,'1951','297',575091.79,575091.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113456',2251855,'1952','297',526975.84,526975.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113456',2251856,'1953','297',516461.54,519501.04,3039.50,428569.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','113456',2251857,'1954','297',341311.01,341311.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113456',2251858,'1955','297',365379.14,367865.55,2486.41,350583.81,0.00,0.00,0.00,0.00,0.00),('1','116','717','113456',2251859,'1956','297',430006.03,430006.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','113456',2251860,'1957','297',604492.90,607544.75,3051.85,430310.85,0.00,0.00,0.00,0.00,0.00),('1','116','719','113456',2251861,'1966','298',279789.63,279889.63,100.00,21500.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113456',2251862,'1967','297',64799.33,64799.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113456',2251863,'1968','297',391872.50,394329.26,2456.76,346403.16,0.00,0.00,0.00,0.00,0.00),('1','116','720','113456',2251864,'1969','297',269003.99,272237.49,3233.50,455923.50,0.00,0.00,0.00,0.00,0.00),('1','116','720','113456',2251865,'1970','297',295519.66,295519.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113456',2251866,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','113456',2251867,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114366',2269943,'1950','297',332497.17,334254.61,1757.44,247799.04,0.00,0.00,0.00,0.00,0.00),('1','116','717','114366',2269944,'1951','297',575091.79,576374.13,1282.34,180809.94,0.00,0.00,0.00,0.00,0.00),('1','116','717','114366',2269945,'1952','297',526975.84,528318.00,1342.16,189244.56,0.00,0.00,0.00,0.00,0.00),('1','116','717','114366',2269946,'1953','297',519501.04,522035.91,2534.87,357416.67,0.00,0.00,0.00,0.00,0.00),('1','116','717','114366',2269947,'1954','297',341311.01,343163.08,1852.07,261141.87,0.00,0.00,0.00,0.00,0.00),('1','116','717','114366',2269948,'1955','297',367865.55,368822.20,956.65,134887.65,0.00,0.00,0.00,0.00,0.00),('1','116','717','114366',2269949,'1956','297',430006.03,432060.82,2054.79,289725.39,0.00,0.00,0.00,0.00,0.00),('1','116','717','114366',2269950,'1957','297',607544.75,609818.94,2274.19,320660.79,0.00,0.00,0.00,0.00,0.00),('1','116','719','114366',2269951,'1966','298',279889.63,280039.63,150.00,32250.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114366',2269952,'1967','297',64799.33,65164.95,365.62,51552.42,0.00,0.00,0.00,0.00,0.00),('1','116','720','114366',2269953,'1968','297',394329.26,394331.39,2.13,300.33,0.00,0.00,0.00,0.00,0.00),('1','116','720','114366',2269954,'1969','297',272237.49,272237.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114366',2269955,'1970','297',295519.66,296016.37,496.71,70036.11,0.00,0.00,0.00,0.00,0.00),('1','116','720','114366',2269956,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114366',2269957,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114372',2270082,'1950','297',334254.61,336861.26,2606.65,367537.65,0.00,0.00,0.00,0.00,0.00),('1','116','717','114372',2270083,'1951','297',576374.13,576374.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114372',2270084,'1952','297',528318.00,528318.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114372',2270085,'1953','297',522035.91,525350.46,3314.55,467351.55,0.00,0.00,0.00,0.00,0.00),('1','116','717','114372',2270086,'1954','297',343163.08,343597.67,434.59,61277.19,0.00,0.00,0.00,0.00,0.00),('1','116','717','114372',2270087,'1955','297',368822.20,371735.81,2913.61,410819.01,0.00,0.00,0.00,0.00,0.00),('1','116','717','114372',2270088,'1956','297',432060.82,433970.94,1910.12,269326.92,0.00,0.00,0.00,0.00,0.00),('1','116','717','114372',2270089,'1957','297',609818.94,611866.36,2047.42,288686.22,0.00,0.00,0.00,0.00,0.00),('1','116','719','114372',2270090,'1966','298',280039.63,280629.83,590.20,129844.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114372',2270091,'1967','297',65164.95,66573.87,1408.92,198657.72,0.00,0.00,0.00,0.00,0.00),('1','116','720','114372',2270092,'1968','297',394331.39,396473.38,2141.99,302020.59,0.00,0.00,0.00,0.00,0.00),('1','116','720','114372',2270093,'1969','297',272237.49,272237.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114372',2270094,'1970','297',296016.37,297732.13,1715.76,241922.16,0.00,0.00,0.00,0.00,0.00),('1','116','720','114372',2270095,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114372',2270096,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114373',2270097,'1950','297',336861.26,340122.99,3261.73,459903.93,0.00,0.00,0.00,0.00,0.00),('1','116','717','114373',2270098,'1951','297',576374.13,576374.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114373',2270099,'1952','297',528318.00,528318.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114373',2270100,'1953','297',525350.46,528888.80,3538.34,498905.94,0.00,0.00,0.00,0.00,0.00),('1','116','717','114373',2270101,'1954','297',343597.67,343597.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114373',2270102,'1955','297',371735.81,374206.76,2470.95,348403.95,0.00,0.00,0.00,0.00,0.00),('1','116','717','114373',2270103,'1956','297',433970.94,433970.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114373',2270104,'1957','297',611866.36,615504.44,3638.08,512969.28,0.00,0.00,0.00,0.00,0.00),('1','116','719','114373',2270105,'1966','298',280629.83,280936.01,306.18,67359.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','114373',2270106,'1967','297',66573.87,69514.22,2940.35,414589.35,0.00,0.00,0.00,0.00,0.00),('1','116','720','114373',2270107,'1968','297',396473.38,398337.98,1864.60,262908.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','114373',2270108,'1969','297',272237.49,272237.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114373',2270109,'1970','297',297732.13,300004.66,2272.53,320426.73,0.00,0.00,0.00,0.00,0.00),('1','116','720','114373',2270110,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114373',2270111,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114383',2270239,'1950','297',340122.99,343200.67,3057.68,431132.88,0.00,0.00,20.00,0.00,0.00),('1','116','717','114383',2270240,'1951','297',576374.13,576728.16,324.03,45688.23,0.00,0.00,30.00,0.00,0.00),('1','116','717','114383',2270241,'1952','297',528318.00,529716.53,1378.53,194372.73,0.00,0.00,20.00,0.00,0.00),('1','116','717','114383',2270242,'1953','297',528888.80,532437.36,3538.56,498936.96,0.00,0.00,10.00,0.00,0.00),('1','116','717','114383',2270243,'1954','297',343597.67,348029.96,4412.29,622132.89,0.00,0.00,20.00,0.00,0.00),('1','116','717','114383',2270244,'1955','297',374206.76,374770.12,543.36,76613.76,0.00,0.00,20.00,0.00,0.00),('1','116','717','114383',2270245,'1956','297',433970.94,434704.63,723.69,102040.29,0.00,0.00,10.00,0.00,0.00),('1','116','717','114383',2270246,'1957','297',615504.44,618089.98,2575.54,363151.14,0.00,0.00,10.00,0.00,0.00),('1','116','719','114383',2270247,'1966','298',280936.01,286353.12,5417.11,1191764.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','114383',2270248,'1967','297',69514.22,70085.24,571.02,80513.82,0.00,0.00,0.00,0.00,0.00),('1','116','720','114383',2270249,'1968','297',398337.98,399316.62,978.64,137988.24,0.00,0.00,0.00,0.00,0.00),('1','116','720','114383',2270250,'1969','297',272237.49,272237.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114383',2270251,'1970','297',300004.66,301252.30,1247.64,175917.24,0.00,0.00,0.00,0.00,0.00),('1','116','720','114383',2270252,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114383',2270253,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114384',2270254,'1950','297',343200.67,347091.14,3890.47,548556.27,0.00,0.00,0.00,0.00,0.00),('1','116','717','114384',2270255,'1951','297',576728.16,578918.91,2190.75,308895.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','114384',2270256,'1952','297',529716.53,533820.65,4104.12,578680.92,0.00,0.00,0.00,0.00,0.00),('1','116','717','114384',2270257,'1953','297',532437.36,536659.13,4221.77,595269.57,0.00,0.00,0.00,0.00,0.00),('1','116','717','114384',2270258,'1954','297',348029.96,354402.94,6372.98,898590.18,0.00,0.00,0.00,0.00,0.00),('1','116','717','114384',2270259,'1955','297',374770.12,376229.17,1459.05,205726.05,0.00,0.00,0.00,0.00,0.00),('1','116','717','114384',2270260,'1956','297',434704.63,435378.49,673.86,95014.26,0.00,0.00,0.00,0.00,0.00),('1','116','717','114384',2270261,'1957','297',618089.98,622693.14,4603.16,649045.56,0.00,0.00,0.00,0.00,0.00),('1','116','719','114384',2270262,'1966','298',286353.12,288012.42,1659.30,365046.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114384',2270263,'1967','297',70085.24,70085.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114384',2270264,'1968','297',399316.62,399316.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114384',2270265,'1969','297',272237.49,272237.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114384',2270266,'1970','297',301252.30,301252.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114384',2270267,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114384',2270268,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114385',2270269,'1950','297',347091.14,348230.92,1139.78,160708.98,0.00,0.00,0.00,0.00,0.00),('1','116','717','114385',2270270,'1951','297',578918.91,579049.77,130.86,18451.26,0.00,0.00,0.00,0.00,0.00),('1','116','717','114385',2270271,'1952','297',533820.65,533820.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114385',2270272,'1953','297',536659.13,536659.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114385',2270273,'1954','297',354402.94,354402.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114385',2270274,'1955','297',376229.17,378330.73,2101.56,296319.96,0.00,0.00,0.00,0.00,0.00),('1','116','717','114385',2270275,'1956','297',435378.49,435378.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114385',2270276,'1957','297',622693.14,622693.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','114385',2270277,'1966','298',288012.42,288102.42,90.00,19800.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114385',2270278,'1967','297',70085.24,70085.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114385',2270279,'1968','297',399316.62,399316.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114385',2270280,'1969','297',272237.49,272237.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114385',2270281,'1970','297',301252.30,301252.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114385',2270282,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114385',2270283,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114386',2270284,'1950','297',348230.92,348230.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114386',2270285,'1951','297',579049.77,579049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114386',2270286,'1952','297',533820.65,533820.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114386',2270287,'1953','297',536659.13,536659.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114386',2270288,'1954','297',354402.94,355519.83,1116.89,157481.49,0.00,0.00,0.00,0.00,0.00),('1','116','717','114386',2270289,'1955','297',378330.73,378330.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114386',2270290,'1956','297',435378.49,435378.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114386',2270291,'1957','297',622693.14,622693.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','114386',2270292,'1966','298',288102.42,288113.42,11.00,2420.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114386',2270293,'1967','297',70085.24,70085.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114386',2270294,'1968','297',399316.62,399316.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114386',2270295,'1969','297',272237.49,272237.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114386',2270296,'1970','297',301252.30,301252.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114386',2270297,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114386',2270298,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114387',2270299,'1950','297',348230.92,348230.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114387',2270300,'1951','297',579049.77,579049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114387',2270301,'1952','297',533820.65,533820.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114387',2270302,'1953','297',536659.13,536659.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114387',2270303,'1954','297',355519.83,356014.66,494.83,69771.03,0.00,0.00,0.00,0.00,0.00),('1','116','717','114387',2270304,'1955','297',378330.73,378330.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114387',2270305,'1956','297',435378.49,435378.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114387',2270306,'1957','297',622693.14,622693.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','114387',2270307,'1966','298',288113.42,288639.40,525.98,115715.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','114387',2270308,'1967','297',70085.24,70085.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114387',2270309,'1968','297',399316.62,399316.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114387',2270310,'1969','297',272237.49,272237.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114387',2270311,'1970','297',301252.30,301252.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114387',2270312,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114387',2270313,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114388',2270314,'1950','297',348230.92,348919.19,688.27,97046.07,0.00,0.00,0.00,0.00,0.00),('1','116','717','114388',2270315,'1951','297',579049.77,579049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114388',2270316,'1952','297',533820.65,533820.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114388',2270317,'1953','297',536659.13,537643.70,984.57,138824.37,0.00,0.00,0.00,0.00,0.00),('1','116','717','114388',2270318,'1954','297',356014.66,356018.92,4.26,600.66,0.00,0.00,0.00,0.00,0.00),('1','116','717','114388',2270319,'1955','297',378330.73,382694.76,4364.03,615328.23,0.00,0.00,0.00,0.00,0.00),('1','116','717','114388',2270320,'1956','297',435378.49,435910.89,532.40,75068.40,0.00,0.00,0.00,0.00,0.00),('1','116','717','114388',2270321,'1957','297',622693.14,623531.13,837.99,118156.59,0.00,0.00,0.00,0.00,0.00),('1','116','719','114388',2270322,'1966','298',288639.40,291003.38,2363.98,520075.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','114388',2270323,'1967','297',70085.24,70085.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114388',2270324,'1968','297',399316.62,399316.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114388',2270325,'1969','297',272237.49,272237.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114388',2270326,'1970','297',301252.30,301252.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114388',2270327,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114388',2270328,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114389',2270329,'1950','297',348919.19,350071.00,1131.81,159585.21,0.00,0.00,20.00,0.00,0.00),('1','116','717','114389',2270330,'1951','297',579049.77,579111.79,42.02,5924.82,0.00,0.00,20.00,0.00,0.00),('1','116','717','114389',2270331,'1952','297',533820.65,534922.64,1081.99,152560.59,0.00,0.00,20.00,0.00,0.00),('1','116','717','114389',2270332,'1953','297',537643.70,538350.70,697.00,98277.00,0.00,0.00,10.00,0.00,0.00),('1','116','717','114389',2270333,'1954','297',356018.92,356082.47,43.55,6140.55,0.00,0.00,20.00,0.00,0.00),('1','116','717','114389',2270334,'1955','297',382694.76,388257.76,5543.00,781563.00,0.00,0.00,20.00,0.00,0.00),('1','116','717','114389',2270335,'1956','297',435910.89,435941.83,10.94,1542.54,0.00,0.00,20.00,0.00,0.00),('1','116','717','114389',2270336,'1957','297',623531.13,625099.65,1548.52,218341.32,0.00,0.00,20.00,0.00,0.00),('1','116','719','114389',2270337,'1966','298',291003.38,293661.57,2658.19,584801.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','114389',2270338,'1967','297',70085.24,70085.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114389',2270339,'1968','297',399316.62,399316.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114389',2270340,'1969','297',272237.49,272237.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114389',2270341,'1970','297',301252.30,301252.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114389',2270342,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114389',2270343,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114390',2270344,'1950','297',350071.00,351792.23,1721.23,242693.43,0.00,0.00,0.00,0.00,0.00),('1','116','717','114390',2270345,'1951','297',579111.79,579111.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114390',2270346,'1952','297',534922.64,536189.43,1266.79,178617.39,0.00,0.00,0.00,0.00,0.00),('1','116','717','114390',2270347,'1953','297',538350.70,540373.60,2022.90,285228.90,0.00,0.00,0.00,0.00,0.00),('1','116','717','114390',2270348,'1954','297',356082.47,358641.30,2558.83,360795.03,0.00,0.00,0.00,0.00,0.00),('1','116','717','114390',2270349,'1955','297',388257.76,388950.37,692.61,97658.01,0.00,0.00,0.00,0.00,0.00),('1','116','717','114390',2270350,'1956','297',435941.83,436810.03,868.20,122416.20,0.00,0.00,0.00,0.00,0.00),('1','116','717','114390',2270351,'1957','297',625099.65,626756.87,1657.22,233668.02,0.00,0.00,0.00,0.00,0.00),('1','116','719','114390',2270352,'1966','298',293661.57,298490.89,4829.32,1062450.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','114390',2270353,'1967','297',70085.24,70085.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114390',2270354,'1968','297',399316.62,399316.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114390',2270355,'1969','297',272237.49,272237.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114390',2270356,'1970','297',301252.30,301252.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114390',2270357,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114390',2270358,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114391',2270359,'1950','297',351792.23,351792.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114391',2270360,'1951','297',579111.79,581085.18,1973.39,278247.99,0.00,0.00,0.00,0.00,0.00),('1','116','717','114391',2270361,'1952','297',536189.43,536189.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114391',2270362,'1953','297',540373.60,543070.99,2697.39,380331.99,0.00,0.00,0.00,0.00,0.00),('1','116','717','114391',2270363,'1954','297',358641.30,358641.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114391',2270364,'1955','297',388950.37,390656.75,1706.38,240599.58,0.00,0.00,0.00,0.00,0.00),('1','116','717','114391',2270365,'1956','297',436810.03,436810.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114391',2270366,'1957','297',626756.87,628894.45,2137.58,301398.78,0.00,0.00,0.00,0.00,0.00),('1','116','719','114391',2270367,'1966','298',298490.89,301236.56,2735.67,601847.40,0.00,0.00,10.00,0.00,0.00),('1','116','720','114391',2270368,'1967','297',70085.24,70960.29,875.05,123382.05,0.00,0.00,0.00,0.00,0.00),('1','116','720','114391',2270369,'1968','297',399316.62,403046.92,3730.30,525972.30,0.00,0.00,0.00,0.00,0.00),('1','116','720','114391',2270370,'1969','297',272237.49,275165.00,2927.51,412778.91,0.00,0.00,0.00,0.00,0.00),('1','116','720','114391',2270371,'1970','297',301252.30,302125.76,863.46,121747.86,0.00,0.00,10.00,0.00,0.00),('1','116','720','114391',2270372,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114391',2270373,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114392',2270374,'1950','297',351792.23,353633.91,1841.68,259676.88,0.00,0.00,0.00,0.00,0.00),('1','116','717','114392',2270375,'1951','297',581085.18,581085.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114392',2270376,'1952','297',536189.43,536189.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114392',2270377,'1953','297',543070.99,545287.42,2216.43,312516.63,0.00,0.00,0.00,0.00,0.00),('1','116','717','114392',2270378,'1954','297',358641.30,358641.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114392',2270379,'1955','297',390656.75,392519.71,1862.96,262677.36,0.00,0.00,0.00,0.00,0.00),('1','116','717','114392',2270380,'1956','297',436810.03,438029.08,1219.05,171886.05,0.00,0.00,0.00,0.00,0.00),('1','116','717','114392',2270381,'1957','297',628894.45,630522.27,1627.82,229522.62,0.00,0.00,0.00,0.00,0.00),('1','116','719','114392',2270382,'1966','298',301236.56,305470.63,4234.07,931495.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','114392',2270383,'1967','297',70960.29,72818.91,1858.62,262065.42,0.00,0.00,0.00,0.00,0.00),('1','116','720','114392',2270384,'1968','297',403046.92,404208.84,1161.92,163830.72,0.00,0.00,0.00,0.00,0.00),('1','116','720','114392',2270385,'1969','297',275165.00,275165.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114392',2270386,'1970','297',302125.76,303429.37,1303.61,183809.01,0.00,0.00,0.00,0.00,0.00),('1','116','720','114392',2270387,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114392',2270388,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114393',2270389,'1950','297',353633.91,356314.15,2680.24,377913.84,0.00,0.00,0.00,0.00,0.00),('1','116','717','114393',2270390,'1951','297',581085.18,581085.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114393',2270391,'1952','297',536189.43,538944.04,2754.61,388400.01,0.00,0.00,0.00,0.00,0.00),('1','116','717','114393',2270392,'1953','297',545287.42,546725.93,1438.51,202829.91,0.00,0.00,0.00,0.00,0.00),('1','116','717','114393',2270393,'1954','297',358641.30,361468.19,2826.89,398591.49,0.00,0.00,0.00,0.00,0.00),('1','116','717','114393',2270394,'1955','297',392519.71,396193.73,3674.02,518036.82,0.00,0.00,0.00,0.00,0.00),('1','116','717','114393',2270395,'1956','297',438029.08,440516.28,2487.20,350695.20,0.00,0.00,0.00,0.00,0.00),('1','116','717','114393',2270396,'1957','297',630522.27,632658.91,2136.64,301266.24,0.00,0.00,0.00,0.00,0.00),('1','116','719','114393',2270397,'1966','298',305470.63,305500.16,29.53,6496.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','114393',2270398,'1967','297',72818.91,72818.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114393',2270399,'1968','297',404208.84,405419.27,1210.43,170670.63,0.00,0.00,0.00,0.00,0.00),('1','116','720','114393',2270400,'1969','297',275165.00,275165.03,0.03,4.23,0.00,0.00,0.00,0.00,0.00),('1','116','720','114393',2270401,'1970','297',303429.37,304405.88,976.51,137687.91,0.00,0.00,0.00,0.00,0.00),('1','116','720','114393',2270402,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114393',2270403,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114464',2271774,'1950','297',356314.15,358785.27,2471.12,348427.92,0.00,0.00,0.00,0.00,0.00),('1','116','717','114464',2271775,'1951','297',581085.18,581085.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114464',2271776,'1952','297',538944.04,539571.21,627.17,88430.97,0.00,0.00,0.00,0.00,0.00),('1','116','717','114464',2271777,'1953','297',546725.93,549269.33,2543.40,358619.40,0.00,0.00,0.00,0.00,0.00),('1','116','717','114464',2271778,'1954','297',361468.19,361468.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114464',2271779,'1955','297',396193.73,397588.98,1395.25,196730.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','114464',2271780,'1956','297',440516.28,441692.72,1176.44,165878.04,0.00,0.00,0.00,0.00,0.00),('1','116','717','114464',2271781,'1957','297',632658.91,634865.20,2206.29,311086.89,0.00,0.00,0.00,0.00,0.00),('1','116','719','114464',2271782,'1966','298',305500.16,305500.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114464',2271783,'1967','297',72818.91,73504.35,685.44,96647.04,0.00,0.00,0.00,0.00,0.00),('1','116','720','114464',2271784,'1968','297',405419.27,406585.40,1166.13,164424.33,0.00,0.00,0.00,0.00,0.00),('1','116','720','114464',2271785,'1969','297',275165.03,275165.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114464',2271786,'1970','297',304405.88,306722.26,2316.38,326609.58,0.00,0.00,0.00,0.00,0.00),('1','116','720','114464',2271787,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114464',2271788,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114560',2273839,'1950','297',358785.27,361448.04,2662.77,375450.57,0.00,0.00,0.00,0.00,0.00),('1','116','717','114560',2273840,'1951','297',581085.18,581085.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114560',2273841,'1952','297',539571.21,539571.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114560',2273842,'1953','297',549269.33,552536.70,3267.37,460699.17,0.00,0.00,0.00,0.00,0.00),('1','116','717','114560',2273843,'1954','297',361468.19,363869.95,2401.76,338648.16,0.00,0.00,0.00,0.00,0.00),('1','116','717','114560',2273844,'1955','297',397588.98,397588.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114560',2273845,'1956','297',441692.72,442524.30,831.58,117252.78,0.00,0.00,0.00,0.00,0.00),('1','116','717','114560',2273846,'1957','297',634865.20,638109.63,3244.43,457464.63,0.00,0.00,0.00,0.00,0.00),('1','116','719','114560',2273847,'1966','298',305500.16,308017.52,2507.36,551619.20,0.00,0.00,10.00,0.00,0.00),('1','116','720','114560',2273848,'1967','297',73504.35,73504.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114560',2273849,'1968','297',406585.40,408669.28,2083.88,293827.08,0.00,0.00,0.00,0.00,0.00),('1','116','720','114560',2273850,'1969','297',275165.03,277980.56,2815.53,396989.73,0.00,0.00,0.00,0.00,0.00),('1','116','720','114560',2273851,'1970','297',306722.26,306722.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114560',2273852,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114560',2273853,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114669',2276057,'1950','297',361448.04,363949.63,2491.59,351314.19,0.00,0.00,10.00,0.00,0.00),('1','116','717','114669',2276058,'1951','297',581085.18,581085.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114669',2276059,'1952','297',539571.21,539581.21,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','116','717','114669',2276060,'1953','297',552536.70,555387.18,2840.48,400507.68,0.00,0.00,10.00,0.00,0.00),('1','116','717','114669',2276061,'1954','297',363869.95,363869.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114669',2276062,'1955','297',397588.98,399545.93,1956.95,275929.95,0.00,0.00,0.00,0.00,0.00),('1','116','717','114669',2276063,'1956','297',442524.30,442524.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114669',2276064,'1957','297',638109.63,640967.17,2847.54,401503.14,0.00,0.00,10.00,0.00,0.00),('1','116','719','114669',2276065,'1966','298',308017.52,308644.76,617.24,135792.80,0.00,0.00,10.00,0.00,0.00),('1','116','720','114669',2276066,'1967','297',73504.35,74314.47,810.12,114226.92,0.00,0.00,0.00,0.00,0.00),('1','116','720','114669',2276067,'1968','297',408669.28,409949.74,1280.46,180544.86,0.00,0.00,0.00,0.00,0.00),('1','116','720','114669',2276068,'1969','297',277980.56,277980.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114669',2276069,'1970','297',306722.26,308684.64,1962.38,276695.58,0.00,0.00,0.00,0.00,0.00),('1','116','720','114669',2276070,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114669',2276071,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114672',2276130,'1950','297',363949.63,366731.63,2782.00,392262.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114672',2276131,'1951','297',581085.18,581085.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114672',2276132,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114672',2276133,'1953','297',555387.18,558829.67,3442.49,485391.09,0.00,0.00,0.00,0.00,0.00),('1','116','717','114672',2276134,'1954','297',363869.95,366406.12,2536.17,357599.97,0.00,0.00,0.00,0.00,0.00),('1','116','717','114672',2276135,'1955','297',399545.93,402299.56,2753.63,388261.83,0.00,0.00,0.00,0.00,0.00),('1','116','717','114672',2276136,'1956','297',442524.30,445289.63,2765.33,389911.53,0.00,0.00,0.00,0.00,0.00),('1','116','717','114672',2276137,'1957','297',640967.17,644084.32,3117.15,439518.15,0.00,0.00,0.00,0.00,0.00),('1','116','719','114672',2276138,'1966','298',308644.76,309513.16,868.40,191048.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114672',2276139,'1967','297',74314.47,74314.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114672',2276140,'1968','297',409949.74,409949.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114672',2276141,'1969','297',277980.56,277980.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114672',2276142,'1970','297',308684.64,308684.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114672',2276143,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114672',2276144,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114674',2276161,'1950','297',366731.63,368307.54,1575.91,222203.31,0.00,0.00,0.00,0.00,0.00),('1','116','717','114674',2276162,'1951','297',581085.18,581085.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114674',2276163,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114674',2276164,'1953','297',558829.67,561153.44,2323.77,327651.57,0.00,0.00,0.00,0.00,0.00),('1','116','717','114674',2276165,'1954','297',366406.12,367676.02,1269.90,179055.90,0.00,0.00,0.00,0.00,0.00),('1','116','717','114674',2276166,'1955','297',402299.56,403901.84,1602.28,225921.48,0.00,0.00,0.00,0.00,0.00),('1','116','717','114674',2276167,'1956','297',445289.63,446887.96,1598.33,225364.53,0.00,0.00,0.00,0.00,0.00),('1','116','717','114674',2276168,'1957','297',644084.32,644796.91,712.59,100475.19,0.00,0.00,0.00,0.00,0.00),('1','116','719','114674',2276169,'1966','298',309513.16,310494.93,981.77,215989.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','114674',2276170,'1967','297',74314.47,74314.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114674',2276171,'1968','297',409949.74,409949.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114674',2276172,'1969','297',277980.56,277980.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114674',2276173,'1970','297',308684.64,308684.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114674',2276174,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114674',2276175,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114777',2278553,'1950','297',368307.54,369349.71,1042.17,146945.97,0.00,0.00,0.00,0.00,0.00),('1','116','717','114777',2278554,'1951','297',581085.18,581085.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114777',2278555,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114777',2278556,'1953','297',561153.44,562272.23,1118.79,157749.39,0.00,0.00,0.00,0.00,0.00),('1','116','717','114777',2278557,'1954','297',367676.02,368549.00,872.98,123090.18,0.00,0.00,0.00,0.00,0.00),('1','116','717','114777',2278558,'1955','297',403901.84,404881.73,979.89,138164.49,0.00,0.00,0.00,0.00,0.00),('1','116','717','114777',2278559,'1956','297',446887.96,447647.92,759.96,107154.36,0.00,0.00,0.00,0.00,0.00),('1','116','717','114777',2278560,'1957','297',644796.91,646003.43,1206.52,170119.32,0.00,0.00,0.00,0.00,0.00),('1','116','719','114777',2278561,'1966','298',310494.93,311831.80,1336.87,294111.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','114777',2278562,'1967','297',74314.47,74314.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114777',2278563,'1968','297',409949.74,409949.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114777',2278564,'1969','297',277980.56,277980.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114777',2278565,'1970','297',308684.64,308684.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114777',2278566,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114777',2278567,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114824',2279410,'1950','297',369349.71,371555.63,2205.92,311034.72,0.00,0.00,0.00,0.00,0.00),('1','116','717','114824',2279411,'1951','297',581085.18,581085.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114824',2279412,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114824',2279413,'1953','297',562272.23,564937.10,2664.87,375746.67,0.00,0.00,0.00,0.00,0.00),('1','116','717','114824',2279414,'1954','297',368549.00,370379.30,1830.30,258072.30,0.00,0.00,0.00,0.00,0.00),('1','116','717','114824',2279415,'1955','297',404881.73,404881.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114824',2279416,'1956','297',447647.92,447647.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114824',2279417,'1957','297',646003.43,649024.12,3020.69,425917.29,0.00,0.00,0.00,0.00,0.00),('1','116','719','114824',2279418,'1966','298',311831.80,311984.52,152.72,33598.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','114824',2279419,'1967','297',74314.47,74314.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114824',2279420,'1968','297',409949.74,409949.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114824',2279421,'1969','297',277980.56,277980.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114824',2279422,'1970','297',308684.64,308684.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114824',2279423,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114824',2279424,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114838',2279681,'1950','297',371555.63,373782.36,2226.73,313968.93,0.00,0.00,0.00,0.00,0.00),('1','116','717','114838',2279682,'1951','297',581085.18,581085.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114838',2279683,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114838',2279684,'1953','297',564937.10,567867.70,2930.60,413214.60,0.00,0.00,0.00,0.00,0.00),('1','116','717','114838',2279685,'1954','297',370379.30,372943.27,2563.97,361519.77,0.00,0.00,0.00,0.00,0.00),('1','116','717','114838',2279686,'1955','297',404881.73,407910.51,3028.78,427057.98,0.00,0.00,0.00,0.00,0.00),('1','116','717','114838',2279687,'1956','297',447647.92,448831.94,1184.02,166946.82,0.00,0.00,0.00,0.00,0.00),('1','116','717','114838',2279688,'1957','297',649024.12,651549.78,2525.66,356118.06,0.00,0.00,0.00,0.00,0.00),('1','116','719','114838',2279689,'1966','298',311984.52,313307.32,1322.80,291016.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114838',2279690,'1967','297',74314.47,75983.43,1668.96,235323.36,0.00,0.00,0.00,0.00,0.00),('1','116','720','114838',2279691,'1968','297',409949.74,409949.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114838',2279692,'1969','297',277980.56,277987.90,0.00,0.00,0.00,0.00,7.34,0.00,0.00),('1','116','720','114838',2279693,'1970','297',308684.64,308690.97,0.00,0.00,0.00,0.00,6.33,0.00,0.00),('1','116','720','114838',2279694,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114838',2279695,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114905',2281113,'1950','297',373782.36,376419.54,2637.18,371842.38,0.00,0.00,0.00,0.00,0.00),('1','116','717','114905',2281114,'1951','297',581085.18,581085.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114905',2281115,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','114905',2281116,'1953','297',567867.70,570518.21,2650.51,373721.91,0.00,0.00,0.00,0.00,0.00),('1','116','717','114905',2281117,'1954','297',372943.27,374527.91,1584.64,223434.24,0.00,0.00,0.00,0.00,0.00),('1','116','717','114905',2281118,'1955','297',407910.51,409752.83,1842.32,259767.12,0.00,0.00,0.00,0.00,0.00),('1','116','717','114905',2281119,'1956','297',448831.94,449916.28,1084.34,152891.94,0.00,0.00,0.00,0.00,0.00),('1','116','717','114905',2281120,'1957','297',651549.78,653547.77,1997.99,281716.59,0.00,0.00,0.00,0.00,0.00),('1','116','719','114905',2281121,'1966','298',313307.32,313832.70,525.38,115583.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','114905',2281122,'1967','297',75983.43,76672.65,689.22,97180.02,0.00,0.00,0.00,0.00,0.00),('1','116','720','114905',2281123,'1968','297',409949.74,410784.71,834.97,117730.77,0.00,0.00,0.00,0.00,0.00),('1','116','720','114905',2281124,'1969','297',277987.90,277987.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114905',2281125,'1970','297',308690.97,308690.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114905',2281126,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','114905',2281127,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115161',2284986,'1950','297',376419.54,379183.11,2743.57,386843.37,0.00,0.00,20.00,0.00,0.00),('1','116','717','115161',2284987,'1951','297',581085.18,582914.09,1818.91,256466.31,0.00,0.00,10.00,0.00,0.00),('1','116','717','115161',2284988,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115161',2284989,'1953','297',570518.21,574382.84,3844.63,542092.83,0.00,0.00,20.00,0.00,0.00),('1','116','717','115161',2284990,'1954','297',374527.91,378721.74,4173.83,588510.03,0.00,0.00,20.00,0.00,0.00),('1','116','717','115161',2284991,'1955','297',409752.83,413199.36,3436.53,484550.73,0.00,0.00,10.00,0.00,0.00),('1','116','717','115161',2284992,'1956','297',449916.28,452226.16,2289.88,322873.08,0.00,0.00,20.00,0.00,0.00),('1','116','717','115161',2284993,'1957','297',653547.77,656504.42,2946.65,415477.65,0.00,0.00,10.00,0.00,0.00),('1','116','719','115161',2284994,'1966','298',313832.70,315940.51,2087.81,459318.20,0.00,0.00,20.00,0.00,0.00),('1','116','720','115161',2284995,'1967','297',76672.65,76672.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115161',2284996,'1968','297',410784.71,411141.35,336.64,47466.24,0.00,0.00,20.00,0.00,0.00),('1','116','720','115161',2284997,'1969','297',277987.90,278091.68,73.78,10402.98,0.00,0.00,30.00,0.00,0.00),('1','116','720','115161',2284998,'1970','297',308690.97,308779.75,58.78,8287.98,0.00,0.00,30.00,0.00,0.00),('1','116','720','115161',2284999,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115161',2285000,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115175',2285275,'1950','297',379183.11,380893.78,1710.67,241204.47,0.00,0.00,0.00,0.00,0.00),('1','116','717','115175',2285276,'1951','297',582914.09,582914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115175',2285277,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115175',2285278,'1953','297',574382.84,576739.19,2356.35,332245.35,0.00,0.00,0.00,0.00,0.00),('1','116','717','115175',2285279,'1954','297',378721.74,379736.03,1014.29,143014.89,0.00,0.00,0.00,0.00,0.00),('1','116','717','115175',2285280,'1955','297',413199.36,415014.37,1815.01,255916.41,0.00,0.00,0.00,0.00,0.00),('1','116','717','115175',2285281,'1956','297',452226.16,452226.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115175',2285282,'1957','297',656504.42,658728.23,2223.81,313557.21,0.00,0.00,0.00,0.00,0.00),('1','116','719','115175',2285283,'1966','298',315940.51,316362.14,421.63,92758.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','115175',2285284,'1967','297',76672.65,76672.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115175',2285285,'1968','297',411141.35,413017.05,1875.70,264473.70,0.00,0.00,0.00,0.00,0.00),('1','116','720','115175',2285286,'1969','297',278091.68,278091.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115175',2285287,'1970','297',308779.75,310891.53,2111.78,297760.98,0.00,0.00,0.00,0.00,0.00),('1','116','720','115175',2285288,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115175',2285289,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115185',2285481,'1950','297',380893.78,380893.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115185',2285482,'1951','297',582914.09,586109.38,3195.29,450535.89,0.00,0.00,0.00,0.00,0.00),('1','116','717','115185',2285483,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115185',2285484,'1953','297',576739.19,579329.65,2590.46,365254.86,0.00,0.00,0.00,0.00,0.00),('1','116','717','115185',2285485,'1954','297',379736.03,383664.02,3927.99,553846.59,0.00,0.00,0.00,0.00,0.00),('1','116','717','115185',2285486,'1955','297',415014.37,417840.91,2826.54,398542.14,0.00,0.00,0.00,0.00,0.00),('1','116','717','115185',2285487,'1956','297',452226.16,452226.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115185',2285488,'1957','297',658728.23,661884.65,3156.42,445055.22,0.00,0.00,0.00,0.00,0.00),('1','116','719','115185',2285489,'1966','298',316362.14,317266.60,904.46,198981.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','115185',2285490,'1967','297',76672.65,76672.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115185',2285491,'1968','297',413017.05,415101.51,2084.46,293908.86,0.00,0.00,0.00,0.00,0.00),('1','116','720','115185',2285492,'1969','297',278091.68,278091.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115185',2285493,'1970','297',310891.53,313869.80,2978.27,419936.07,0.00,0.00,0.00,0.00,0.00),('1','116','720','115185',2285494,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115185',2285495,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115274',2287315,'1950','297',380893.78,382831.10,1937.32,273162.12,0.00,0.00,0.00,0.00,0.00),('1','116','717','115274',2287316,'1951','297',586109.38,586109.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115274',2287317,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115274',2287318,'1953','297',579329.65,581374.51,2044.86,288325.26,0.00,0.00,0.00,0.00,0.00),('1','116','717','115274',2287319,'1954','297',383664.02,384789.94,1125.92,158754.72,0.00,0.00,0.00,0.00,0.00),('1','116','717','115274',2287320,'1955','297',417840.91,419040.19,1199.28,169098.48,0.00,0.00,0.00,0.00,0.00),('1','116','717','115274',2287321,'1956','297',452226.16,453495.94,1269.78,179038.98,0.00,0.00,0.00,0.00,0.00),('1','116','717','115274',2287322,'1957','297',661884.65,663724.27,1839.62,259386.42,0.00,0.00,0.00,0.00,0.00),('1','116','719','115274',2287323,'1966','298',317266.60,318096.99,830.39,182685.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','115274',2287324,'1967','297',76672.65,76672.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115274',2287325,'1968','297',415101.51,417040.02,1938.51,273329.91,0.00,0.00,0.00,0.00,0.00),('1','116','720','115274',2287326,'1969','297',278091.68,278091.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115274',2287327,'1970','297',313869.80,315734.62,1864.82,262939.62,0.00,0.00,0.00,0.00,0.00),('1','116','720','115274',2287328,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115274',2287329,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115350',2288929,'1950','297',382831.10,386043.23,3212.13,452910.33,0.00,0.00,0.00,0.00,0.00),('1','116','717','115350',2288930,'1951','297',586109.38,586109.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115350',2288931,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115350',2288932,'1953','297',581374.51,585139.59,3765.08,530876.28,0.00,0.00,0.00,0.00,0.00),('1','116','717','115350',2288933,'1954','297',384789.94,384789.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115350',2288934,'1955','297',419040.19,421576.52,2536.33,357622.53,0.00,0.00,0.00,0.00,0.00),('1','116','717','115350',2288935,'1956','297',453495.94,455767.59,2271.65,320302.65,0.00,0.00,0.00,0.00,0.00),('1','116','717','115350',2288936,'1957','297',663724.27,666288.51,2564.24,361557.84,0.00,0.00,0.00,0.00,0.00),('1','116','719','115350',2288937,'1966','298',318096.99,318853.15,756.16,166355.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','115350',2288938,'1967','297',76672.65,76672.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115350',2288939,'1968','297',417040.02,419564.07,2524.05,355891.05,0.00,0.00,0.00,0.00,0.00),('1','116','720','115350',2288940,'1969','297',278091.68,278091.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115350',2288941,'1970','297',315734.62,318346.46,2611.84,368269.44,0.00,0.00,0.00,0.00,0.00),('1','116','720','115350',2288942,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115350',2288943,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115475',2292025,'1950','297',386043.23,388277.51,2234.28,315033.48,0.00,0.00,0.00,0.00,0.00),('1','116','717','115475',2292026,'1951','297',586109.38,586109.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115475',2292027,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115475',2292028,'1953','297',585139.59,587425.61,2286.02,322328.82,0.00,0.00,0.00,0.00,0.00),('1','116','717','115475',2292029,'1954','297',384789.94,386683.19,1893.25,266948.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','115475',2292030,'1955','297',421576.52,422786.66,1210.14,170629.74,0.00,0.00,0.00,0.00,0.00),('1','116','717','115475',2292031,'1956','297',455767.59,457612.54,1844.95,260137.95,0.00,0.00,0.00,0.00,0.00),('1','116','717','115475',2292032,'1957','297',666288.51,668172.37,1883.86,265624.26,0.00,0.00,0.00,0.00,0.00),('1','116','719','115475',2292033,'1966','298',318853.15,320300.45,1447.30,318406.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115475',2292034,'1967','297',76672.65,76672.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115475',2292035,'1968','297',419564.07,421107.19,1543.12,217579.92,0.00,0.00,0.00,0.00,0.00),('1','116','720','115475',2292036,'1969','297',278091.68,278091.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115475',2292037,'1970','297',318346.46,320078.13,1731.67,244165.47,0.00,0.00,0.00,0.00,0.00),('1','116','720','115475',2292038,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115475',2292039,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115544',2293489,'1950','297',388277.51,394806.64,6529.13,920607.33,0.00,0.00,0.00,0.00,0.00),('1','116','717','115544',2293490,'1951','297',586109.38,586559.33,449.95,63442.95,0.00,0.00,0.00,0.00,0.00),('1','116','717','115544',2293491,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115544',2293492,'1953','297',587425.61,591362.22,3936.61,555062.01,0.00,0.00,0.00,0.00,0.00),('1','116','717','115544',2293493,'1954','297',386683.19,388902.67,2219.48,312946.68,0.00,0.00,0.00,0.00,0.00),('1','116','717','115544',2293494,'1955','297',422786.66,425196.88,2410.22,339841.02,0.00,0.00,0.00,0.00,0.00),('1','116','717','115544',2293495,'1956','297',457612.54,460599.01,2986.47,421092.27,0.00,0.00,0.00,0.00,0.00),('1','116','717','115544',2293496,'1957','297',668172.37,671484.52,3312.15,467013.15,0.00,0.00,0.00,0.00,0.00),('1','116','719','115544',2293497,'1966','298',320300.45,321211.52,911.07,200435.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','115544',2293498,'1967','297',76672.65,76672.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115544',2293499,'1968','297',421107.19,421107.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115544',2293500,'1969','297',278091.68,278091.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115544',2293501,'1970','297',320078.13,320078.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115544',2293502,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115544',2293503,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115597',2294533,'1950','297',394806.64,397599.58,2792.94,393804.54,0.00,0.00,0.00,0.00,0.00),('1','116','717','115597',2294534,'1951','297',586559.33,586732.44,173.11,24408.51,0.00,0.00,0.00,0.00,0.00),('1','116','717','115597',2294535,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115597',2294536,'1953','297',591362.22,594356.66,2994.44,422216.04,0.00,0.00,0.00,0.00,0.00),('1','116','717','115597',2294537,'1954','297',388902.67,390557.48,1654.81,233328.21,0.00,0.00,0.00,0.00,0.00),('1','116','717','115597',2294538,'1955','297',425196.88,428464.03,3267.15,460668.15,0.00,0.00,0.00,0.00,0.00),('1','116','717','115597',2294539,'1956','297',460599.01,463042.09,2443.08,344474.28,0.00,0.00,0.00,0.00,0.00),('1','116','717','115597',2294540,'1957','297',671484.52,674173.59,2689.07,379158.87,0.00,0.00,0.00,0.00,0.00),('1','116','719','115597',2294541,'1966','298',321211.52,324025.24,2813.72,619018.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','115597',2294542,'1967','297',76672.65,76672.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115597',2294543,'1968','297',421107.19,421107.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115597',2294544,'1969','297',278091.68,278091.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115597',2294545,'1970','297',320078.13,320078.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115597',2294546,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115597',2294547,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115676',2296325,'1950','297',397599.58,403125.04,5525.46,779089.86,0.00,0.00,0.00,0.00,0.00),('1','116','717','115676',2296326,'1951','297',586732.44,586780.70,48.26,6804.66,0.00,0.00,0.00,0.00,0.00),('1','116','717','115676',2296327,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115676',2296328,'1953','297',594356.66,598417.64,4060.98,572598.18,0.00,0.00,0.00,0.00,0.00),('1','116','717','115676',2296329,'1954','297',390557.48,395196.55,4639.07,654108.87,0.00,0.00,0.00,0.00,0.00),('1','116','717','115676',2296330,'1955','297',428464.03,433483.48,5019.45,707742.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','115676',2296331,'1956','297',463042.09,466142.75,3100.66,437193.06,0.00,0.00,0.00,0.00,0.00),('1','116','717','115676',2296332,'1957','297',674173.59,677404.17,3230.58,455511.78,0.00,0.00,0.00,0.00,0.00),('1','116','719','115676',2296333,'1966','298',324025.24,326476.94,2451.70,539374.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115676',2296334,'1967','297',76672.65,76672.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115676',2296335,'1968','297',421107.19,421107.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115676',2296336,'1969','297',278091.68,278091.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115676',2296337,'1970','297',320078.13,320078.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115676',2296338,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115676',2296339,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115694',2296673,'1950','297',403125.04,405867.24,2742.20,386650.20,0.00,0.00,0.00,0.00,0.00),('1','116','717','115694',2296674,'1951','297',586780.70,586780.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115694',2296675,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','115694',2296676,'1953','297',598417.64,601306.89,2889.25,407384.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','115694',2296677,'1954','297',395196.55,398782.93,3586.38,505679.58,0.00,0.00,0.00,0.00,0.00),('1','116','717','115694',2296678,'1955','297',433483.48,435925.68,2442.20,344350.20,0.00,0.00,0.00,0.00,0.00),('1','116','717','115694',2296679,'1956','297',466142.75,468322.05,2179.30,307281.30,0.00,0.00,0.00,0.00,0.00),('1','116','717','115694',2296680,'1957','297',677404.17,679299.50,1895.33,267241.53,0.00,0.00,0.00,0.00,0.00),('1','116','719','115694',2296681,'1966','298',326476.94,327172.28,695.34,152974.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','115694',2296682,'1967','297',76672.65,76672.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115694',2296683,'1968','297',421107.19,421107.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115694',2296684,'1969','297',278091.68,278091.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115694',2296685,'1970','297',320078.13,320078.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115694',2296686,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','115694',2296687,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116250',2308181,'1950','297',405867.24,408876.01,3008.77,424236.57,0.00,0.00,0.00,0.00,0.00),('1','116','717','116250',2308182,'1951','297',586780.70,586780.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116250',2308183,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116250',2308184,'1953','297',601306.89,604231.15,2924.26,412320.66,0.00,0.00,0.00,0.00,0.00),('1','116','717','116250',2308185,'1954','297',398782.93,400213.90,1430.97,201766.77,0.00,0.00,0.00,0.00,0.00),('1','116','717','116250',2308186,'1955','297',435925.68,438460.40,2534.72,357395.52,0.00,0.00,0.00,0.00,0.00),('1','116','717','116250',2308187,'1956','297',468322.05,470351.55,2029.50,286159.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','116250',2308188,'1957','297',679299.50,681865.86,2566.36,361856.76,0.00,0.00,0.00,0.00,0.00),('1','116','719','116250',2308189,'1966','298',327172.28,327656.40,484.12,106506.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','116250',2308190,'1967','297',76672.65,76672.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116250',2308191,'1968','297',421107.19,421107.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116250',2308192,'1969','297',278091.68,278091.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116250',2308193,'1970','297',320078.13,320078.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116250',2308194,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116250',2308195,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116258',2308323,'1950','297',408876.01,410659.57,1783.56,251481.96,0.00,0.00,0.00,0.00,0.00),('1','116','717','116258',2308324,'1951','297',586780.70,586780.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116258',2308325,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116258',2308326,'1953','297',604231.15,606666.48,2435.33,343381.53,0.00,0.00,0.00,0.00,0.00),('1','116','717','116258',2308327,'1954','297',400213.90,401317.83,1103.93,155654.13,0.00,0.00,0.00,0.00,0.00),('1','116','717','116258',2308328,'1955','297',438460.40,439411.78,951.38,134144.58,0.00,0.00,0.00,0.00,0.00),('1','116','717','116258',2308329,'1956','297',470351.55,470407.66,56.11,7911.51,0.00,0.00,0.00,0.00,0.00),('1','116','717','116258',2308330,'1957','297',681865.86,683742.28,1876.42,264575.22,0.00,0.00,0.00,0.00,0.00),('1','116','719','116258',2308331,'1966','298',327656.40,328020.55,364.15,80113.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116258',2308332,'1967','297',76672.65,76672.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116258',2308333,'1968','297',421107.19,422225.30,1118.11,157653.51,0.00,0.00,0.00,0.00,0.00),('1','116','720','116258',2308334,'1969','297',278091.68,278091.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116258',2308335,'1970','297',320078.13,321134.42,1056.29,148936.89,0.00,0.00,0.00,0.00,0.00),('1','116','720','116258',2308336,'1971','297',36018.80,36018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116258',2308337,'1972','297',32071.63,32071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116260',2308352,'1950','297',410659.57,411136.18,466.61,65792.01,0.00,0.00,10.00,0.00,0.00),('1','116','717','116260',2308353,'1951','297',586780.70,586780.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116260',2308354,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116260',2308355,'1953','297',606666.48,607514.55,828.07,116757.87,0.00,0.00,20.00,0.00,0.00),('1','116','717','116260',2308356,'1954','297',401317.83,402036.63,708.80,99940.80,0.00,0.00,10.00,0.00,0.00),('1','116','717','116260',2308357,'1955','297',439411.78,439411.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116260',2308358,'1956','297',470407.66,471208.23,790.57,111470.37,0.00,0.00,10.00,0.00,0.00),('1','116','717','116260',2308359,'1957','297',683742.28,683742.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','116260',2308360,'1966','298',328020.55,329018.71,988.16,217395.20,0.00,0.00,10.00,0.00,0.00),('1','116','720','116260',2308361,'1967','297',76672.65,78403.42,1710.77,241218.57,0.00,0.00,20.00,0.00,0.00),('1','116','720','116260',2308362,'1968','297',422225.30,424263.95,2018.65,284629.65,0.00,0.00,20.00,0.00,0.00),('1','116','720','116260',2308363,'1969','297',278091.68,279787.76,1686.08,237737.28,0.00,0.00,10.00,0.00,0.00),('1','116','720','116260',2308364,'1970','297',321134.42,323658.70,2514.28,354513.48,0.00,0.00,10.00,0.00,0.00),('1','116','720','116260',2308365,'1971','297',36018.80,37018.80,990.00,139590.00,0.00,0.00,10.00,0.00,0.00),('1','116','720','116260',2308366,'1972','297',32071.63,32728.50,636.87,89798.67,0.00,0.00,20.00,0.00,0.00),('1','116','717','116267',2308503,'1950','297',411136.18,411136.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116267',2308504,'1951','297',586780.70,586780.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116267',2308505,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116267',2308506,'1953','297',607514.55,607514.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116267',2308507,'1954','297',402036.63,402036.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116267',2308508,'1955','297',439411.78,439411.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116267',2308509,'1956','297',471208.23,471208.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116267',2308510,'1957','297',683742.28,683742.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','116267',2308511,'1966','298',329018.71,330175.11,1156.40,254408.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116267',2308512,'1967','297',78403.42,78750.40,346.98,48924.18,0.00,0.00,0.00,0.00,0.00),('1','116','720','116267',2308513,'1968','297',424263.95,428303.52,4039.57,569579.37,0.00,0.00,0.00,0.00,0.00),('1','116','720','116267',2308514,'1969','297',279787.76,280098.04,310.28,43749.48,0.00,0.00,0.00,0.00,0.00),('1','116','720','116267',2308515,'1970','297',323658.70,328105.34,4446.64,626976.24,0.00,0.00,0.00,0.00,0.00),('1','116','720','116267',2308516,'1971','297',37018.80,37018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116267',2308517,'1972','297',32728.50,32728.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116269',2308548,'1950','297',411136.18,412638.48,1502.30,211824.30,0.00,0.00,0.00,0.00,0.00),('1','116','717','116269',2308549,'1951','297',586780.70,586780.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116269',2308550,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116269',2308551,'1953','297',607514.55,609355.87,1841.32,259626.12,0.00,0.00,0.00,0.00,0.00),('1','116','717','116269',2308552,'1954','297',402036.63,403581.95,1545.32,217890.12,0.00,0.00,0.00,0.00,0.00),('1','116','717','116269',2308553,'1955','297',439411.78,440679.61,1267.83,178764.03,0.00,0.00,0.00,0.00,0.00),('1','116','717','116269',2308554,'1956','297',471208.23,472839.71,1631.48,230038.68,0.00,0.00,0.00,0.00,0.00),('1','116','717','116269',2308555,'1957','297',683742.28,685077.69,1335.41,188292.81,0.00,0.00,0.00,0.00,0.00),('1','116','719','116269',2308556,'1966','298',330175.11,331914.30,1739.19,382621.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','116269',2308557,'1967','297',78750.40,80648.07,1897.67,267571.47,0.00,0.00,0.00,0.00,0.00),('1','116','720','116269',2308558,'1968','297',428303.52,429702.61,1399.09,197271.69,0.00,0.00,0.00,0.00,0.00),('1','116','720','116269',2308559,'1969','297',280098.04,281588.30,1490.26,210126.66,0.00,0.00,0.00,0.00,0.00),('1','116','720','116269',2308560,'1970','297',328105.34,330134.54,2029.20,286117.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','116269',2308561,'1971','297',37018.80,37051.43,32.63,4600.83,0.00,0.00,0.00,0.00,0.00),('1','116','720','116269',2308562,'1972','297',32728.50,33913.62,1185.12,167101.92,0.00,0.00,0.00,0.00,0.00),('1','116','717','116270',2308563,'1950','297',412638.48,414789.49,2151.01,303292.41,0.00,0.00,0.00,0.00,0.00),('1','116','717','116270',2308564,'1951','297',586780.70,586780.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116270',2308565,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116270',2308566,'1953','297',609355.87,612510.26,3154.39,444768.99,0.00,0.00,0.00,0.00,0.00),('1','116','717','116270',2308567,'1954','297',403581.95,405308.51,1705.99,240544.59,0.00,0.00,20.57,0.00,0.00),('1','116','717','116270',2308568,'1955','297',440679.61,442037.62,1337.50,188587.50,0.00,0.00,20.51,0.00,0.00),('1','116','717','116270',2308569,'1956','297',472839.71,474932.44,2092.73,295074.93,0.00,0.00,0.00,0.00,0.00),('1','116','717','116270',2308570,'1957','297',685077.69,687169.32,2091.63,294919.83,0.00,0.00,0.00,0.00,0.00),('1','116','719','116270',2308571,'1966','298',331914.30,333112.68,1198.38,263643.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','116270',2308572,'1967','297',80648.07,80648.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116270',2308573,'1968','297',429702.61,429702.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116270',2308574,'1969','297',281588.30,281588.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116270',2308575,'1970','297',330134.54,330134.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116270',2308576,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116270',2308577,'1972','297',33913.62,33913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116290',2309116,'1950','297',414789.49,417864.66,3075.17,433598.97,0.00,0.00,0.00,0.00,0.00),('1','116','717','116290',2309117,'1951','297',586780.70,586780.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116290',2309118,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116290',2309119,'1953','297',612510.26,615620.83,3110.57,438590.37,0.00,0.00,0.00,0.00,0.00),('1','116','717','116290',2309120,'1954','297',405308.51,407480.86,2172.35,306301.35,0.00,0.00,0.00,0.00,0.00),('1','116','717','116290',2309121,'1955','297',442037.62,444645.57,2607.95,367720.95,0.00,0.00,0.00,0.00,0.00),('1','116','717','116290',2309122,'1956','297',474932.44,477598.63,2666.19,375932.79,0.00,0.00,0.00,0.00,0.00),('1','116','717','116290',2309123,'1957','297',687169.32,690439.30,3269.98,461067.18,0.00,0.00,0.00,0.00,0.00),('1','116','719','116290',2309124,'1966','298',333112.68,334041.40,928.72,204318.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','116290',2309125,'1967','297',80648.07,80648.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116290',2309126,'1968','297',429702.61,429702.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116290',2309127,'1969','297',281588.30,281588.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116290',2309128,'1970','297',330134.54,330134.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116290',2309129,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116290',2309130,'1972','297',33913.62,33913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116292',2309169,'1950','297',417864.66,420027.65,2162.99,304981.59,0.00,0.00,0.00,0.00,0.00),('1','116','717','116292',2309170,'1951','297',586780.70,586780.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116292',2309171,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116292',2309172,'1953','297',615620.83,617863.49,2242.66,316215.06,0.00,0.00,0.00,0.00,0.00),('1','116','717','116292',2309173,'1954','297',407480.86,409190.00,1709.14,240988.74,0.00,0.00,0.00,0.00,0.00),('1','116','717','116292',2309174,'1955','297',444645.57,446255.49,1609.92,226998.72,0.00,0.00,0.00,0.00,0.00),('1','116','717','116292',2309175,'1956','297',477598.63,477598.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116292',2309176,'1957','297',690439.30,693358.37,2919.07,411588.87,0.00,0.00,0.00,0.00,0.00),('1','116','719','116292',2309177,'1966','298',334041.40,335883.47,1842.07,405255.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','116292',2309178,'1967','297',80648.07,80648.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116292',2309179,'1968','297',429702.61,430429.49,726.88,102490.08,0.00,0.00,0.00,0.00,0.00),('1','116','720','116292',2309180,'1969','297',281588.30,281588.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116292',2309181,'1970','297',330134.54,331298.89,1164.35,164173.35,0.00,0.00,0.00,0.00,0.00),('1','116','720','116292',2309182,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116292',2309183,'1972','297',33913.62,33913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116295',2309239,'1950','297',420027.65,422538.62,2510.97,354046.77,0.00,0.00,0.00,0.00,0.00),('1','116','717','116295',2309240,'1951','297',586780.70,586780.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116295',2309241,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116295',2309242,'1953','297',617863.49,620994.93,3131.44,441533.04,0.00,0.00,0.00,0.00,0.00),('1','116','717','116295',2309243,'1954','297',409190.00,411711.28,2521.28,355500.48,0.00,0.00,0.00,0.00,0.00),('1','116','717','116295',2309244,'1955','297',446255.49,446255.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116295',2309245,'1956','297',477598.63,477598.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116295',2309246,'1957','297',693358.37,696308.62,2950.25,415985.25,0.00,0.00,0.00,0.00,0.00),('1','116','719','116295',2309247,'1966','298',335883.47,338127.40,2243.93,493664.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','116295',2309248,'1967','297',80648.07,82018.18,1370.11,193185.51,0.00,0.00,0.00,0.00,0.00),('1','116','720','116295',2309249,'1968','297',430429.49,431598.30,1168.81,164802.21,0.00,0.00,0.00,0.00,0.00),('1','116','720','116295',2309250,'1969','297',281588.30,283470.84,1882.54,265438.14,0.00,0.00,0.00,0.00,0.00),('1','116','720','116295',2309251,'1970','297',331298.89,332817.21,1518.32,214083.12,0.00,0.00,0.00,0.00,0.00),('1','116','720','116295',2309252,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116295',2309253,'1972','297',33913.62,33913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116300',2309384,'1950','297',422538.62,425221.66,2683.04,378308.64,0.00,0.00,0.00,0.00,0.00),('1','116','717','116300',2309385,'1951','297',586780.70,586780.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116300',2309386,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116300',2309387,'1953','297',620994.93,623401.26,2406.33,339292.53,0.00,0.00,0.00,0.00,0.00),('1','116','717','116300',2309388,'1954','297',411711.28,413353.69,1642.41,231579.81,0.00,0.00,0.00,0.00,0.00),('1','116','717','116300',2309389,'1955','297',446255.49,446255.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116300',2309390,'1956','297',477598.63,477598.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116300',2309391,'1957','297',696308.62,699128.60,2819.98,397617.18,0.00,0.00,0.00,0.00,0.00),('1','116','719','116300',2309392,'1966','298',338127.40,338863.30,735.90,161898.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116300',2309393,'1967','297',82018.18,82018.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116300',2309394,'1968','297',431598.30,433844.92,2246.62,316773.42,0.00,0.00,0.00,0.00,0.00),('1','116','720','116300',2309395,'1969','297',283470.84,285707.28,2236.44,315338.04,0.00,0.00,0.00,0.00,0.00),('1','116','720','116300',2309396,'1970','297',332817.21,332881.21,64.00,9024.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116300',2309397,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116300',2309398,'1972','297',33913.62,33913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116401',2311447,'1950','297',425221.66,428428.94,3207.28,452226.48,0.00,0.00,0.00,0.00,0.00),('1','116','717','116401',2311448,'1951','297',586780.70,586780.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116401',2311449,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116401',2311450,'1953','297',623401.26,626489.63,3088.37,435460.17,0.00,0.00,0.00,0.00,0.00),('1','116','717','116401',2311451,'1954','297',413353.69,415447.86,2094.17,295277.97,0.00,0.00,0.00,0.00,0.00),('1','116','717','116401',2311452,'1955','297',446255.49,447844.34,1588.85,224027.85,0.00,0.00,0.00,0.00,0.00),('1','116','717','116401',2311453,'1956','297',477598.63,477598.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116401',2311454,'1957','297',699128.60,702256.38,3127.78,441016.98,0.00,0.00,0.00,0.00,0.00),('1','116','719','116401',2311455,'1966','298',338863.30,340704.51,1841.21,405066.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','116401',2311456,'1967','297',82018.18,83236.12,1217.94,171729.54,0.00,0.00,0.00,0.00,0.00),('1','116','720','116401',2311457,'1968','297',433844.92,435154.00,1309.08,184580.28,0.00,0.00,0.00,0.00,0.00),('1','116','720','116401',2311458,'1969','297',285707.28,287649.16,1941.88,273805.08,0.00,0.00,0.00,0.00,0.00),('1','116','720','116401',2311459,'1970','297',332881.21,334205.60,1324.39,186738.99,0.00,0.00,0.00,0.00,0.00),('1','116','720','116401',2311460,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116401',2311461,'1972','297',33913.62,33913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116447',2312439,'1950','297',428428.94,430328.18,1899.24,267792.84,0.00,0.00,0.00,0.00,0.00),('1','116','717','116447',2312440,'1951','297',586780.70,586780.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116447',2312441,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116447',2312442,'1953','297',626489.63,629293.08,2803.45,395286.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','116447',2312443,'1954','297',415447.86,415447.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116447',2312444,'1955','297',447844.34,449511.80,1667.46,235111.86,0.00,0.00,0.00,0.00,0.00),('1','116','717','116447',2312445,'1956','297',477598.63,479090.78,1492.15,210393.15,0.00,0.00,0.00,0.00,0.00),('1','116','717','116447',2312446,'1957','297',702256.38,704389.33,2132.95,300745.95,0.00,0.00,0.00,0.00,0.00),('1','116','719','116447',2312447,'1966','298',340704.51,341218.76,514.25,113135.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116447',2312448,'1967','297',83236.12,83236.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116447',2312449,'1968','297',435154.00,437273.68,2119.68,298874.88,0.00,0.00,0.00,0.00,0.00),('1','116','720','116447',2312450,'1969','297',287649.16,287649.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116447',2312451,'1970','297',334205.60,336245.63,2040.03,287644.23,0.00,0.00,0.00,0.00,0.00),('1','116','720','116447',2312452,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116447',2312453,'1972','297',33913.62,33913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116462',2312783,'1950','297',430328.18,433182.43,2844.25,401039.25,0.00,0.00,10.00,0.00,0.00),('1','116','717','116462',2312784,'1951','297',586780.70,586780.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116462',2312785,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116462',2312786,'1953','297',629293.08,632905.00,3601.92,507870.72,0.00,0.00,10.00,0.00,0.00),('1','116','717','116462',2312787,'1954','297',415447.86,418696.90,3239.04,456704.64,0.00,0.00,10.00,0.00,0.00),('1','116','717','116462',2312788,'1955','297',449511.80,449511.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116462',2312789,'1956','297',479090.78,479090.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116462',2312790,'1957','297',704389.33,708059.54,3660.21,516089.61,0.00,0.00,10.00,0.00,0.00),('1','116','719','116462',2312791,'1966','298',341218.76,343141.54,1912.78,420811.60,0.00,0.00,10.00,0.00,0.00),('1','116','720','116462',2312792,'1967','297',83236.12,85260.97,2014.85,284093.85,0.00,0.00,10.00,0.00,0.00),('1','116','720','116462',2312793,'1968','297',437273.68,439275.91,1992.23,280904.43,0.00,0.00,10.00,0.00,0.00),('1','116','720','116462',2312794,'1969','297',287649.16,287649.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116462',2312795,'1970','297',336245.63,339270.11,3014.48,425041.68,0.00,0.00,10.00,0.00,0.00),('1','116','720','116462',2312796,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116462',2312797,'1972','297',33913.62,33913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116502',2313581,'1950','297',433182.43,436162.09,2979.66,420132.06,0.00,0.00,0.00,0.00,0.00),('1','116','717','116502',2313582,'1951','297',586780.70,586780.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116502',2313583,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116502',2313584,'1953','297',632905.00,634945.70,2040.70,287738.70,0.00,0.00,0.00,0.00,0.00),('1','116','717','116502',2313585,'1954','297',418696.90,418696.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116502',2313586,'1955','297',449511.80,451942.43,2430.63,342718.83,0.00,0.00,0.00,0.00,0.00),('1','116','717','116502',2313587,'1956','297',479090.78,479090.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116502',2313588,'1957','297',708059.54,710628.55,2569.01,362230.41,0.00,0.00,0.00,0.00,0.00),('1','116','719','116502',2313589,'1966','298',343141.54,343876.01,734.47,161583.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','116502',2313590,'1967','297',85260.97,86728.54,1467.57,206927.37,0.00,0.00,0.00,0.00,0.00),('1','116','720','116502',2313591,'1968','297',439275.91,440860.78,1584.87,223466.67,0.00,0.00,0.00,0.00,0.00),('1','116','720','116502',2313592,'1969','297',287649.16,287649.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116502',2313593,'1970','297',339270.11,341442.02,2171.91,306239.31,0.00,0.00,0.00,0.00,0.00),('1','116','720','116502',2313594,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116502',2313595,'1972','297',33913.62,33913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116739',2318448,'1950','297',436162.09,439132.37,2970.28,418809.48,0.00,0.00,0.00,0.00,0.00),('1','116','717','116739',2318449,'1951','297',586780.70,586780.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116739',2318450,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116739',2318451,'1953','297',634945.70,638365.98,3420.28,482259.48,0.00,0.00,0.00,0.00,0.00),('1','116','717','116739',2318452,'1954','297',418696.90,420773.62,2076.72,292817.52,0.00,0.00,0.00,0.00,0.00),('1','116','717','116739',2318453,'1955','297',451942.43,453702.88,1760.45,248223.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','116739',2318454,'1956','297',479090.78,481227.15,2136.37,301228.17,0.00,0.00,0.00,0.00,0.00),('1','116','717','116739',2318455,'1957','297',710628.55,713389.74,2761.19,389327.79,0.00,0.00,0.00,0.00,0.00),('1','116','719','116739',2318456,'1966','298',343876.01,344335.46,459.45,101079.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116739',2318457,'1967','297',86728.54,86728.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116739',2318458,'1968','297',440860.78,441028.75,167.97,23683.77,0.00,0.00,0.00,0.00,0.00),('1','116','720','116739',2318459,'1969','297',287649.16,287649.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116739',2318460,'1970','297',341442.02,341587.80,145.78,20554.98,0.00,0.00,0.00,0.00,0.00),('1','116','720','116739',2318461,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116739',2318462,'1972','297',33913.62,33913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116743',2318515,'1950','297',439132.37,441319.87,2187.50,308437.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','116743',2318516,'1951','297',586780.70,586780.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116743',2318517,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116743',2318518,'1953','297',638365.98,640609.64,2243.66,316356.06,0.00,0.00,0.00,0.00,0.00),('1','116','717','116743',2318519,'1954','297',420773.62,420773.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116743',2318520,'1955','297',453702.88,456447.41,2744.53,386978.73,0.00,0.00,0.00,0.00,0.00),('1','116','717','116743',2318521,'1956','297',481227.15,481227.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116743',2318522,'1957','297',713389.74,716515.92,3126.18,440791.38,0.00,0.00,0.00,0.00,0.00),('1','116','719','116743',2318523,'1966','298',344335.46,344458.44,122.98,27055.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','116743',2318524,'1967','297',86728.54,86728.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116743',2318525,'1968','297',441028.75,441028.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116743',2318526,'1969','297',287649.16,287649.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116743',2318527,'1970','297',341587.80,341587.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116743',2318528,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116743',2318529,'1972','297',33913.62,33913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116746',2318583,'1950','297',441319.87,443859.72,2539.85,358118.85,0.00,0.00,0.00,0.00,0.00),('1','116','717','116746',2318584,'1951','297',586780.70,586780.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116746',2318585,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116746',2318586,'1953','297',640609.64,642774.90,2165.26,305301.66,0.00,0.00,0.00,0.00,0.00),('1','116','717','116746',2318587,'1954','297',420773.62,422040.59,1266.97,178642.77,0.00,0.00,0.00,0.00,0.00),('1','116','717','116746',2318588,'1955','297',456447.41,457747.12,1299.71,183259.11,0.00,0.00,0.00,0.00,0.00),('1','116','717','116746',2318589,'1956','297',481227.15,483071.11,1843.96,259998.36,0.00,0.00,0.00,0.00,0.00),('1','116','717','116746',2318590,'1957','297',716515.92,718624.63,2108.71,297328.11,0.00,0.00,0.00,0.00,0.00),('1','116','719','116746',2318591,'1966','298',344458.44,344648.21,189.77,41749.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','116746',2318592,'1967','297',86728.54,86728.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116746',2318593,'1968','297',441028.75,441028.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116746',2318594,'1969','297',287649.16,287649.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116746',2318595,'1970','297',341587.80,341587.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116746',2318596,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116746',2318597,'1972','297',33913.62,33913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116788',2319507,'1950','297',443859.72,446559.21,2679.49,377808.09,0.00,0.00,20.00,0.00,0.00),('1','116','717','116788',2319508,'1951','297',586780.70,586780.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116788',2319509,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116788',2319510,'1953','297',642774.90,645612.90,2828.00,398748.00,0.00,0.00,10.00,0.00,0.00),('1','116','717','116788',2319511,'1954','297',422040.59,424073.72,2013.13,283851.33,0.00,0.00,20.00,0.00,0.00),('1','116','717','116788',2319512,'1955','297',457747.12,459394.56,1627.44,229469.04,0.00,0.00,20.00,0.00,0.00),('1','116','717','116788',2319513,'1956','297',483071.11,484932.10,1850.99,260989.59,0.00,0.00,10.00,0.00,0.00),('1','116','717','116788',2319514,'1957','297',718624.63,720802.93,2168.30,305730.30,0.00,0.00,10.00,0.00,0.00),('1','116','719','116788',2319515,'1966','298',344648.21,345605.43,947.22,203652.30,0.00,0.00,10.00,0.00,0.00),('1','116','720','116788',2319516,'1967','297',86728.54,86728.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116788',2319517,'1968','297',441028.75,441028.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116788',2319518,'1969','297',287649.16,287649.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116788',2319519,'1970','297',341587.80,341587.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116788',2319520,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116788',2319521,'1972','297',33913.62,33913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116791',2319562,'1950','297',446559.21,449411.38,2852.17,402155.97,0.00,0.00,0.00,0.00,0.00),('1','116','717','116791',2319563,'1951','297',586780.70,587990.71,1210.01,170611.41,0.00,0.00,0.00,0.00,0.00),('1','116','717','116791',2319564,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116791',2319565,'1953','297',645612.90,649488.52,3875.62,546462.42,0.00,0.00,0.00,0.00,0.00),('1','116','717','116791',2319566,'1954','297',424073.72,427838.91,3765.19,530891.79,0.00,0.00,0.00,0.00,0.00),('1','116','717','116791',2319567,'1955','297',459394.56,459394.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116791',2319568,'1956','297',484932.10,484932.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116791',2319569,'1957','297',720802.93,724588.62,3785.69,533782.29,0.00,0.00,0.00,0.00,0.00),('1','116','719','116791',2319570,'1966','298',345605.43,345961.73,356.30,76604.50,0.00,0.00,0.00,0.00,0.00),('1','116','720','116791',2319571,'1967','297',86728.54,86728.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116791',2319572,'1968','297',441028.75,441028.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116791',2319573,'1969','297',287649.16,287649.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116791',2319574,'1970','297',341587.80,341587.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116791',2319575,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116791',2319576,'1972','297',33913.62,33913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116916',2322335,'1950','297',449411.38,451251.86,1840.48,259507.68,0.00,0.00,0.00,0.00,0.00),('1','116','717','116916',2322336,'1951','297',587990.71,589255.68,1264.97,178360.77,0.00,0.00,0.00,0.00,0.00),('1','116','717','116916',2322337,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','116916',2322338,'1953','297',649488.52,651355.25,1866.73,263208.93,0.00,0.00,0.00,0.00,0.00),('1','116','717','116916',2322339,'1954','297',427838.91,428623.20,784.29,110584.89,0.00,0.00,0.00,0.00,0.00),('1','116','717','116916',2322340,'1955','297',459394.56,460245.05,850.49,119919.09,0.00,0.00,0.00,0.00,0.00),('1','116','717','116916',2322341,'1956','297',484932.10,485455.90,523.80,73855.80,0.00,0.00,0.00,0.00,0.00),('1','116','717','116916',2322342,'1957','297',724588.62,726360.45,1771.83,249828.03,0.00,0.00,0.00,0.00,0.00),('1','116','719','116916',2322343,'1966','298',345961.73,347613.03,1651.30,355029.50,0.00,0.00,0.00,0.00,0.00),('1','116','720','116916',2322344,'1967','297',86728.54,86728.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116916',2322345,'1968','297',441028.75,441028.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116916',2322346,'1969','297',287649.16,287649.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116916',2322347,'1970','297',341587.80,341587.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116916',2322348,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','116916',2322349,'1972','297',33913.62,33913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117073',2325647,'1950','297',451251.86,453367.83,2115.97,298351.77,0.00,0.00,0.00,0.00,0.00),('1','116','717','117073',2325648,'1951','297',589255.68,589255.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117073',2325649,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117073',2325650,'1953','297',651355.25,653793.80,2438.55,343835.55,0.00,0.00,0.00,0.00,0.00),('1','116','717','117073',2325651,'1954','297',428623.20,428623.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117073',2325652,'1955','297',460245.05,462636.53,2391.48,337198.68,0.00,0.00,0.00,0.00,0.00),('1','116','717','117073',2325653,'1956','297',485455.90,485455.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117073',2325654,'1957','297',726360.45,728359.78,1999.33,281905.53,0.00,0.00,0.00,0.00,0.00),('1','116','719','117073',2325655,'1966','298',347613.03,348656.72,1043.69,224393.35,0.00,0.00,0.00,0.00,0.00),('1','116','720','117073',2325656,'1967','297',86728.54,86728.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117073',2325657,'1968','297',441028.75,442531.53,1502.78,211891.98,0.00,0.00,0.00,0.00,0.00),('1','116','720','117073',2325658,'1969','297',287649.16,287649.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117073',2325659,'1970','297',341587.80,343702.56,2114.76,298181.16,0.00,0.00,0.00,0.00,0.00),('1','116','720','117073',2325660,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117073',2325661,'1972','297',33913.62,33913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117076',2325722,'1950','297',453367.83,455934.64,2566.81,361920.21,0.00,0.00,0.00,0.00,0.00),('1','116','717','117076',2325723,'1951','297',589255.68,589255.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117076',2325724,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117076',2325725,'1953','297',653793.80,657102.54,3308.74,466532.34,0.00,0.00,0.00,0.00,0.00),('1','116','717','117076',2325726,'1954','297',428623.20,428623.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117076',2325727,'1955','297',462636.53,466351.36,3714.83,523791.03,0.00,0.00,0.00,0.00,0.00),('1','116','717','117076',2325728,'1956','297',485455.90,485455.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117076',2325729,'1957','297',728359.78,731424.82,3065.04,432170.64,0.00,0.00,0.00,0.00,0.00),('1','116','719','117076',2325730,'1966','298',348656.72,350413.76,1757.04,377763.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','117076',2325731,'1967','297',86728.54,86728.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117076',2325732,'1968','297',442531.53,445871.84,3340.31,470983.71,0.00,0.00,0.00,0.00,0.00),('1','116','720','117076',2325733,'1969','297',287649.16,287649.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117076',2325734,'1970','297',343702.56,347316.04,3613.48,509500.68,0.00,0.00,0.00,0.00,0.00),('1','116','720','117076',2325735,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117076',2325736,'1972','297',33913.62,33913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117117',2326548,'1950','297',455934.64,458221.16,2286.52,322399.32,0.00,0.00,0.00,0.00,0.00),('1','116','717','117117',2326549,'1951','297',589255.68,589255.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117117',2326550,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117117',2326551,'1953','297',657102.54,659479.34,2376.80,335128.80,0.00,0.00,0.00,0.00,0.00),('1','116','717','117117',2326552,'1954','297',428623.20,430718.16,2094.96,295389.36,0.00,0.00,0.00,0.00,0.00),('1','116','717','117117',2326553,'1955','297',466351.36,466351.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117117',2326554,'1956','297',485455.90,487931.31,2475.41,349032.81,0.00,0.00,0.00,0.00,0.00),('1','116','717','117117',2326555,'1957','297',731424.82,732490.27,1065.45,150228.45,0.00,0.00,0.00,0.00,0.00),('1','116','719','117117',2326556,'1966','298',350413.76,351440.07,1026.31,220656.65,0.00,0.00,0.00,0.00,0.00),('1','116','720','117117',2326557,'1967','297',86728.54,86728.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117117',2326558,'1968','297',445871.84,447386.80,1514.96,213609.36,0.00,0.00,0.00,0.00,0.00),('1','116','720','117117',2326559,'1969','297',287649.16,287649.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117117',2326560,'1970','297',347316.04,349780.28,2464.24,347457.84,0.00,0.00,0.00,0.00,0.00),('1','116','720','117117',2326561,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117117',2326562,'1972','297',33913.62,33913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117186',2327931,'1950','297',458221.16,460693.15,2471.99,348550.59,0.00,0.00,0.00,0.00,0.00),('1','116','717','117186',2327932,'1951','297',589255.68,591072.73,1817.05,256204.05,0.00,0.00,0.00,0.00,0.00),('1','116','717','117186',2327933,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117186',2327934,'1953','297',659479.34,663238.21,3758.87,530000.67,0.00,0.00,0.00,0.00,0.00),('1','116','717','117186',2327935,'1954','297',430718.16,434107.09,3388.93,477839.13,0.00,0.00,0.00,0.00,0.00),('1','116','717','117186',2327936,'1955','297',466351.36,466351.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117186',2327937,'1956','297',487931.31,487931.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117186',2327938,'1957','297',732490.27,735970.49,3480.22,490711.02,0.00,0.00,0.00,0.00,0.00),('1','116','719','117186',2327939,'1966','298',351440.07,352527.81,1087.74,233864.10,0.00,0.00,0.00,0.00,0.00),('1','116','720','117186',2327940,'1967','297',86728.54,86728.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117186',2327941,'1968','297',447386.80,450295.90,2909.10,410183.10,0.00,0.00,0.00,0.00,0.00),('1','116','720','117186',2327942,'1969','297',287649.16,287649.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117186',2327943,'1970','297',349780.28,352403.46,2623.18,369868.38,0.00,0.00,0.00,0.00,0.00),('1','116','720','117186',2327944,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117186',2327945,'1972','297',33913.62,33913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117373',2331890,'1950','297',460693.15,464012.34,3299.19,465185.79,0.00,0.00,20.00,0.00,0.00),('1','116','717','117373',2331891,'1951','297',591072.73,591072.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117373',2331892,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117373',2331893,'1953','297',663238.21,666082.06,2833.85,399572.85,0.00,0.00,10.00,0.00,0.00),('1','116','717','117373',2331894,'1954','297',434107.09,437200.08,3082.99,434701.59,0.00,0.00,10.00,0.00,0.00),('1','116','717','117373',2331895,'1955','297',466351.36,466351.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117373',2331896,'1956','297',487931.31,490511.85,2560.54,361036.14,0.00,0.00,20.00,0.00,0.00),('1','116','717','117373',2331897,'1957','297',735970.49,738233.45,2252.96,317667.36,0.00,0.00,10.00,0.00,0.00),('1','116','719','117373',2331898,'1966','298',352527.81,353191.29,663.48,142648.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','117373',2331899,'1967','297',86728.54,86728.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117373',2331900,'1968','297',450295.90,450295.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117373',2331901,'1969','297',287649.16,287649.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117373',2331902,'1970','297',352403.46,352403.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117373',2331903,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117373',2331904,'1972','297',33913.62,33913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117391',2332275,'1950','297',464012.34,465881.05,1868.71,267225.53,0.00,0.00,0.00,0.00,0.00),('1','116','717','117391',2332276,'1951','297',591072.73,591072.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117391',2332277,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117391',2332278,'1953','297',666082.06,669652.07,3570.01,510511.43,0.00,0.00,0.00,0.00,0.00),('1','116','717','117391',2332279,'1954','297',437200.08,439319.61,2119.53,303092.79,0.00,0.00,0.00,0.00,0.00),('1','116','717','117391',2332280,'1955','297',466351.36,467930.08,1568.72,224326.96,0.00,0.00,10.00,0.00,0.00),('1','116','717','117391',2332281,'1956','297',490511.85,492622.69,2110.84,301850.12,0.00,0.00,0.00,0.00,0.00),('1','116','717','117391',2332282,'1957','297',738233.45,739285.71,1052.26,150473.18,0.00,0.00,0.00,0.00,0.00),('1','116','719','117391',2332283,'1966','298',353191.29,355575.29,2374.00,510410.00,0.00,0.00,10.00,0.00,0.00),('1','116','720','117391',2332284,'1967','297',86728.54,87137.94,389.40,55684.20,0.00,0.00,20.00,0.00,0.00),('1','116','720','117391',2332285,'1968','297',450295.90,452901.34,2595.44,371147.92,0.00,0.00,10.00,0.00,0.00),('1','116','720','117391',2332286,'1969','297',287649.16,287649.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117391',2332287,'1970','297',352403.46,354304.21,1890.75,270377.25,0.00,0.00,10.00,0.00,0.00),('1','116','720','117391',2332288,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117391',2332289,'1972','297',33913.62,34009.96,86.34,12346.62,0.00,0.00,10.00,0.00,0.00),('1','116','717','117421',2332784,'1950','297',465881.05,467944.62,2063.57,295090.51,0.00,0.00,0.00,0.00,0.00),('1','116','717','117421',2332785,'1951','297',591072.73,591072.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117421',2332786,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117421',2332787,'1953','297',669652.07,671926.30,2274.23,325214.89,0.00,0.00,0.00,0.00,0.00),('1','116','717','117421',2332788,'1954','297',439319.61,441239.36,1919.75,274524.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','117421',2332789,'1955','297',467930.08,467930.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117421',2332790,'1956','297',492622.69,492622.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117421',2332791,'1957','297',739285.71,741672.73,2387.02,341343.86,0.00,0.00,0.00,0.00,0.00),('1','116','719','117421',2332792,'1966','298',355575.29,355874.81,299.52,65894.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','117421',2332793,'1967','297',87137.94,87137.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117421',2332794,'1968','297',452901.34,454688.92,1787.58,255623.94,0.00,0.00,0.00,0.00,0.00),('1','116','720','117421',2332795,'1969','297',287649.16,287649.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117421',2332796,'1970','297',354304.21,356372.51,2068.30,295766.90,0.00,0.00,0.00,0.00,0.00),('1','116','720','117421',2332797,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117421',2332798,'1972','297',34009.96,34009.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117496',2334423,'1950','297',467944.62,469567.79,1623.17,232113.31,0.00,0.00,0.00,0.00,0.00),('1','116','717','117496',2334424,'1951','297',591072.73,591072.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117496',2334425,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117496',2334426,'1953','297',671926.30,675107.36,3181.06,454891.58,0.00,0.00,0.00,0.00,0.00),('1','116','717','117496',2334427,'1954','297',441239.36,443831.80,2592.44,370718.92,0.00,0.00,0.00,0.00,0.00),('1','116','717','117496',2334428,'1955','297',467930.08,467930.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117496',2334429,'1956','297',492622.69,492622.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117496',2334430,'1957','297',741672.73,744318.31,2645.58,378317.94,0.00,0.00,0.00,0.00,0.00),('1','116','719','117496',2334431,'1966','298',355874.81,356697.18,822.37,180921.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','117496',2334432,'1967','297',87137.94,87137.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117496',2334433,'1968','297',454688.92,457521.85,2832.93,405108.99,0.00,0.00,0.00,0.00,0.00),('1','116','720','117496',2334434,'1969','297',287649.16,287649.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117496',2334435,'1970','297',356372.51,358752.92,2380.41,340398.63,0.00,0.00,0.00,0.00,0.00),('1','116','720','117496',2334436,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117496',2334437,'1972','297',34009.96,34009.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117552',2335559,'1950','297',469567.79,471990.18,2422.39,346401.77,0.00,0.00,0.00,0.00,0.00),('1','116','717','117552',2335560,'1951','297',591072.73,591072.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117552',2335561,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117552',2335562,'1953','297',675107.36,675639.07,531.71,76034.53,0.00,0.00,0.00,0.00,0.00),('1','116','717','117552',2335563,'1954','297',443831.80,443831.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117552',2335564,'1955','297',467930.08,469731.61,1801.53,257618.79,0.00,0.00,0.00,0.00,0.00),('1','116','717','117552',2335565,'1956','297',492622.69,492622.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117552',2335566,'1957','297',744318.31,746125.75,1807.44,258463.92,0.00,0.00,0.00,0.00,0.00),('1','116','719','117552',2335567,'1966','298',356697.18,356874.18,177.00,38940.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117552',2335568,'1967','297',87137.94,88884.60,1746.66,249772.38,0.00,0.00,0.00,0.00,0.00),('1','116','720','117552',2335569,'1968','297',457521.85,457521.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117552',2335570,'1969','297',287649.16,287649.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117552',2335571,'1970','297',358752.92,360312.21,1559.29,222978.47,0.00,0.00,0.00,0.00,0.00),('1','116','720','117552',2335572,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117552',2335573,'1972','297',34009.96,34009.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117555',2335597,'1950','297',471990.18,472956.98,966.80,138252.40,0.00,0.00,0.00,0.00,0.00),('1','116','717','117555',2335598,'1951','297',591072.73,591072.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117555',2335599,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117555',2335600,'1953','297',675639.07,678795.61,3156.54,451385.22,0.00,0.00,0.00,0.00,0.00),('1','116','717','117555',2335601,'1954','297',443831.80,443831.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117555',2335602,'1955','297',469731.61,471445.13,1713.52,245033.36,0.00,0.00,0.00,0.00,0.00),('1','116','717','117555',2335603,'1956','297',492622.69,495212.49,2589.80,370341.40,0.00,0.00,0.00,0.00,0.00),('1','116','717','117555',2335604,'1957','297',746125.75,746125.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','117555',2335605,'1966','298',356874.18,357172.19,298.01,65562.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','117555',2335606,'1967','297',88884.60,88884.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117555',2335607,'1968','297',457521.85,459560.86,2039.01,291578.43,0.00,0.00,0.00,0.00,0.00),('1','116','720','117555',2335608,'1969','297',287649.16,287649.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117555',2335609,'1970','297',360312.21,362034.88,1722.67,246341.81,0.00,0.00,0.00,0.00,0.00),('1','116','720','117555',2335610,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117555',2335611,'1972','297',34009.96,34009.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117653',2337530,'1950','297',472956.98,474727.12,1770.14,253130.02,0.00,0.00,0.00,0.00,0.00),('1','116','717','117653',2337531,'1951','297',591072.73,591072.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117653',2337532,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117653',2337533,'1953','297',678795.61,681032.19,2236.58,319830.94,0.00,0.00,0.00,0.00,0.00),('1','116','717','117653',2337534,'1954','297',443831.80,444900.15,1068.35,152774.05,0.00,0.00,0.00,0.00,0.00),('1','116','717','117653',2337535,'1955','297',471445.13,472818.39,1373.26,196376.18,0.00,0.00,0.00,0.00,0.00),('1','116','717','117653',2337536,'1956','297',495212.49,496391.85,1179.36,168648.48,0.00,0.00,0.00,0.00,0.00),('1','116','717','117653',2337537,'1957','297',746125.75,747490.01,1364.26,195089.18,0.00,0.00,0.00,0.00,0.00),('1','116','719','117653',2337538,'1966','298',357172.19,358096.77,924.58,203407.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','117653',2337539,'1967','297',88884.60,88884.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117653',2337540,'1968','297',459560.86,461256.05,1695.19,242412.17,0.00,0.00,0.00,0.00,0.00),('1','116','720','117653',2337541,'1969','297',287649.16,287649.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117653',2337542,'1970','297',362034.88,363489.87,1454.99,208063.57,0.00,0.00,0.00,0.00,0.00),('1','116','720','117653',2337543,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117653',2337544,'1972','297',34009.96,34009.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117737',2339428,'1950','297',474727.12,475707.91,980.79,140252.97,0.00,0.00,0.00,0.00,0.00),('1','116','717','117737',2339429,'1951','297',591072.73,591072.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117737',2339430,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117737',2339431,'1953','297',681032.19,682013.26,981.07,140293.01,0.00,0.00,0.00,0.00,0.00),('1','116','717','117737',2339432,'1954','297',444900.15,445674.28,774.13,110700.59,0.00,0.00,0.00,0.00,0.00),('1','116','717','117737',2339433,'1955','297',472818.39,472818.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117737',2339434,'1956','297',496391.85,497313.12,921.27,131741.61,0.00,0.00,0.00,0.00,0.00),('1','116','717','117737',2339435,'1957','297',747490.01,747490.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','117737',2339436,'1966','298',358096.77,358096.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117737',2339437,'1967','297',88884.60,88884.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117737',2339438,'1968','297',461256.05,461942.85,686.80,98212.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','117737',2339439,'1969','297',287649.16,288405.22,756.06,108116.58,0.00,0.00,0.00,0.00,0.00),('1','116','720','117737',2339440,'1970','297',363489.87,363489.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117737',2339441,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117737',2339442,'1972','297',34009.96,34009.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117741',2339502,'1950','297',475707.91,477663.52,1955.61,275741.01,0.00,0.00,0.00,0.00,0.00),('1','116','717','117741',2339503,'1951','297',591072.73,591072.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117741',2339504,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117741',2339505,'1953','297',682013.26,684059.18,2045.92,288474.72,0.00,0.00,0.00,0.00,0.00),('1','116','717','117741',2339506,'1954','297',445674.28,447385.52,1711.24,241284.84,0.00,0.00,0.00,0.00,0.00),('1','116','717','117741',2339507,'1955','297',472818.39,472818.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117741',2339508,'1956','297',497313.12,499304.47,1991.35,280780.35,0.00,0.00,0.00,0.00,0.00),('1','116','717','117741',2339509,'1957','297',747490.01,747490.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','117741',2339510,'1966','298',358096.77,358505.68,408.91,89960.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','117741',2339511,'1967','297',88884.60,89104.81,220.21,31049.61,0.00,0.00,0.00,0.00,0.00),('1','116','720','117741',2339512,'1968','297',461942.85,463817.40,1874.55,264311.55,0.00,0.00,0.00,0.00,0.00),('1','116','720','117741',2339513,'1969','297',288405.22,289176.97,771.75,108816.75,0.00,0.00,0.00,0.00,0.00),('1','116','720','117741',2339514,'1970','297',363489.87,364554.02,1064.15,150045.15,0.00,0.00,0.00,0.00,0.00),('1','116','720','117741',2339515,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117741',2339516,'1972','297',34009.96,34009.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117772',2340233,'1950','297',477663.52,480092.57,2429.05,342496.05,0.00,0.00,0.00,0.00,0.00),('1','116','717','117772',2340234,'1951','297',591072.73,591072.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117772',2340235,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117772',2340236,'1953','297',684059.18,686784.44,2725.26,384261.66,0.00,0.00,0.00,0.00,0.00),('1','116','717','117772',2340237,'1954','297',447385.52,448958.09,1572.57,221732.37,0.00,0.00,0.00,0.00,0.00),('1','116','717','117772',2340238,'1955','297',472818.39,472818.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117772',2340239,'1956','297',499304.47,500970.73,1666.26,234942.66,0.00,0.00,0.00,0.00,0.00),('1','116','717','117772',2340240,'1957','297',747490.01,749345.39,1855.38,261608.58,0.00,0.00,0.00,0.00,0.00),('1','116','719','117772',2340241,'1966','298',358505.68,359248.62,742.94,163446.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','117772',2340242,'1967','297',89104.81,89104.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117772',2340243,'1968','297',463817.40,464789.38,971.98,137049.18,0.00,0.00,0.00,0.00,0.00),('1','116','720','117772',2340244,'1969','297',289176.97,289808.96,631.99,89110.59,0.00,0.00,0.00,0.00,0.00),('1','116','720','117772',2340245,'1970','297',364554.02,365366.97,812.95,114625.95,0.00,0.00,0.00,0.00,0.00),('1','116','720','117772',2340246,'1971','297',37051.43,37051.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117772',2340247,'1972','297',34009.96,34009.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117854',2341854,'1950','297',480092.57,482418.04,2325.47,327891.27,0.00,0.00,0.00,0.00,0.00),('1','116','717','117854',2341855,'1951','297',591072.73,591072.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117854',2341856,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117854',2341857,'1953','297',686784.44,689139.21,2354.77,332022.57,0.00,0.00,0.00,0.00,0.00),('1','116','717','117854',2341858,'1954','297',448958.09,450744.97,1786.88,251950.08,0.00,0.00,0.00,0.00,0.00),('1','116','717','117854',2341859,'1955','297',472818.39,472818.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117854',2341860,'1956','297',500970.73,502429.96,1459.23,205751.43,0.00,0.00,0.00,0.00,0.00),('1','116','717','117854',2341861,'1957','297',749345.39,751505.68,2160.29,304600.89,0.00,0.00,0.00,0.00,0.00),('1','116','719','117854',2341862,'1966','298',359248.62,361981.81,2733.19,601301.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','117854',2341863,'1967','297',89104.81,89883.51,778.70,109796.70,0.00,0.00,0.00,0.00,0.00),('1','116','720','117854',2341864,'1968','297',464789.38,465996.79,1207.41,170244.81,0.00,0.00,0.00,0.00,0.00),('1','116','720','117854',2341865,'1969','297',289808.96,289816.27,7.31,1030.71,0.00,0.00,0.00,0.00,0.00),('1','116','720','117854',2341866,'1970','297',365366.97,366985.44,1618.47,228204.27,0.00,0.00,0.00,0.00,0.00),('1','116','720','117854',2341867,'1971','297',37051.43,37079.50,28.07,3957.87,0.00,0.00,0.00,0.00,0.00),('1','116','720','117854',2341868,'1972','297',34009.96,34631.82,621.86,87682.26,0.00,0.00,0.00,0.00,0.00),('1','116','717','117946',2343819,'1950','297',482418.04,484476.23,2058.19,290204.79,0.00,0.00,0.00,0.00,0.00),('1','116','717','117946',2343820,'1951','297',591072.73,591072.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117946',2343821,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117946',2343822,'1953','297',689139.21,691004.33,1865.12,262981.92,0.00,0.00,0.00,0.00,0.00),('1','116','717','117946',2343823,'1954','297',450744.97,452065.34,1320.37,186172.17,0.00,0.00,0.00,0.00,0.00),('1','116','717','117946',2343824,'1955','297',472818.39,472818.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117946',2343825,'1956','297',502429.96,503830.90,1400.94,197532.54,0.00,0.00,0.00,0.00,0.00),('1','116','717','117946',2343826,'1957','297',751505.68,753069.62,1563.94,220515.54,0.00,0.00,0.00,0.00,0.00),('1','116','719','117946',2343827,'1966','298',361981.81,362591.07,609.26,134037.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','117946',2343828,'1967','297',89883.51,90643.96,760.45,107223.45,0.00,0.00,0.00,0.00,0.00),('1','116','720','117946',2343829,'1968','297',465996.79,467231.81,1235.02,174137.82,0.00,0.00,0.00,0.00,0.00),('1','116','720','117946',2343830,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117946',2343831,'1970','297',366985.44,368276.66,1291.22,182062.02,0.00,0.00,0.00,0.00,0.00),('1','116','720','117946',2343832,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117946',2343833,'1972','297',34631.82,34631.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117958',2344054,'1950','297',484476.23,486980.08,2503.85,353042.85,0.00,0.00,0.00,0.00,0.00),('1','116','717','117958',2344055,'1951','297',591072.73,592584.21,1511.48,213118.68,0.00,0.00,0.00,0.00,0.00),('1','116','717','117958',2344056,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117958',2344057,'1953','297',691004.33,692883.59,1879.26,264975.66,0.00,0.00,0.00,0.00,0.00),('1','116','717','117958',2344058,'1954','297',452065.34,454568.60,2503.26,352959.66,0.00,0.00,0.00,0.00,0.00),('1','116','717','117958',2344059,'1955','297',472818.39,472818.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117958',2344060,'1956','297',503830.90,503830.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','117958',2344061,'1957','297',753069.62,755884.98,2815.36,396965.76,0.00,0.00,0.00,0.00,0.00),('1','116','719','117958',2344062,'1966','298',362591.07,363320.47,729.40,160468.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117958',2344063,'1967','297',90643.96,90643.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117958',2344064,'1968','297',467231.81,470301.99,3070.18,432895.38,0.00,0.00,0.00,0.00,0.00),('1','116','720','117958',2344065,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117958',2344066,'1970','297',368276.66,371143.54,2866.88,404230.08,0.00,0.00,0.00,0.00,0.00),('1','116','720','117958',2344067,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','117958',2344068,'1972','297',34631.82,34631.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118073',2346385,'1950','297',486980.08,489254.77,2274.69,320731.29,0.00,0.00,0.00,0.00,0.00),('1','116','717','118073',2346386,'1951','297',592584.21,592584.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118073',2346387,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118073',2346388,'1953','297',692883.59,695133.10,2249.51,317180.91,0.00,0.00,0.00,0.00,0.00),('1','116','717','118073',2346389,'1954','297',454568.60,456148.81,1580.21,222809.61,0.00,0.00,0.00,0.00,0.00),('1','116','717','118073',2346390,'1955','297',472818.39,472818.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118073',2346391,'1956','297',503830.90,505300.51,1469.61,207215.01,0.00,0.00,0.00,0.00,0.00),('1','116','717','118073',2346392,'1957','297',755884.98,758348.37,2463.39,347337.99,0.00,0.00,0.00,0.00,0.00),('1','116','719','118073',2346393,'1966','298',363320.47,364295.57,975.10,214522.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118073',2346394,'1967','297',90643.96,90643.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118073',2346395,'1968','297',470301.99,472118.76,1816.77,256164.57,0.00,0.00,0.00,0.00,0.00),('1','116','720','118073',2346396,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118073',2346397,'1970','297',371143.54,373108.87,1965.33,277111.53,0.00,0.00,0.00,0.00,0.00),('1','116','720','118073',2346398,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118073',2346399,'1972','297',34631.82,34631.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118119',2347352,'1950','297',489254.77,491986.06,2721.29,383701.89,0.00,0.00,10.00,0.00,0.00),('1','116','717','118119',2347353,'1951','297',592584.21,593707.20,1112.99,156931.59,0.00,0.00,10.00,0.00,0.00),('1','116','717','118119',2347354,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118119',2347355,'1953','297',695133.10,698663.35,3510.25,494945.25,0.00,0.00,20.00,0.00,0.00),('1','116','717','118119',2347356,'1954','297',456148.81,459791.86,3633.05,512260.05,0.00,0.00,10.00,0.00,0.00),('1','116','717','118119',2347357,'1955','297',472818.39,472818.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118119',2347358,'1956','297',505300.51,505300.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118119',2347359,'1957','297',758348.37,761970.84,3612.47,509358.27,0.00,0.00,10.00,0.00,0.00),('1','116','719','118119',2347360,'1966','298',364295.57,365319.74,1024.17,225317.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','118119',2347361,'1967','297',90643.96,90950.93,286.97,40462.77,0.00,0.00,20.00,0.00,0.00),('1','116','720','118119',2347362,'1968','297',472118.76,474802.12,2673.36,376943.76,0.00,0.00,10.00,0.00,0.00),('1','116','720','118119',2347363,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118119',2347364,'1970','297',373108.87,376640.19,3521.32,496506.12,0.00,0.00,10.00,0.00,0.00),('1','116','720','118119',2347365,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118119',2347366,'1972','297',34631.82,34631.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118224',2349346,'1950','297',491986.06,494323.93,2337.87,329639.67,0.00,0.00,0.00,0.00,0.00),('1','116','717','118224',2349347,'1951','297',593707.20,594420.09,712.89,100517.49,0.00,0.00,0.00,0.00,0.00),('1','116','717','118224',2349348,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118224',2349349,'1953','297',698663.35,701289.84,2626.49,370335.09,0.00,0.00,0.00,0.00,0.00),('1','116','717','118224',2349350,'1954','297',459791.86,462122.54,2330.68,328625.88,0.00,0.00,0.00,0.00,0.00),('1','116','717','118224',2349351,'1955','297',472818.39,472818.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118224',2349352,'1956','297',505300.51,505300.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118224',2349353,'1957','297',761970.84,764778.18,2807.34,395834.94,0.00,0.00,0.00,0.00,0.00),('1','116','719','118224',2349354,'1966','298',365319.74,365961.14,641.40,141108.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118224',2349355,'1967','297',90950.93,90950.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118224',2349356,'1968','297',474802.12,477064.58,2262.46,319006.86,0.00,0.00,0.00,0.00,0.00),('1','116','720','118224',2349357,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118224',2349358,'1970','297',376640.19,379164.05,2523.86,355864.26,0.00,0.00,0.00,0.00,0.00),('1','116','720','118224',2349359,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118224',2349360,'1972','297',34631.82,34631.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118252',2349888,'1950','297',494323.93,497025.10,2701.17,380864.97,0.00,0.00,0.00,0.00,0.00),('1','116','717','118252',2349889,'1951','297',594420.09,596855.26,2435.17,343358.97,0.00,0.00,0.00,0.00,0.00),('1','116','717','118252',2349890,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118252',2349891,'1953','297',701289.84,704913.41,3623.57,510923.37,0.00,0.00,0.00,0.00,0.00),('1','116','717','118252',2349892,'1954','297',462122.54,465079.19,2956.65,416887.65,0.00,0.00,0.00,0.00,0.00),('1','116','717','118252',2349893,'1955','297',472818.39,472818.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118252',2349894,'1956','297',505300.51,505300.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118252',2349895,'1957','297',764778.18,768761.35,3983.17,561626.97,0.00,0.00,0.00,0.00,0.00),('1','116','719','118252',2349896,'1966','298',365961.14,366938.64,977.50,215050.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118252',2349897,'1967','297',90950.93,90950.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118252',2349898,'1968','297',477064.58,479580.35,2515.77,354723.57,0.00,0.00,0.00,0.00,0.00),('1','116','720','118252',2349899,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118252',2349900,'1970','297',379164.05,382688.55,3524.50,496954.50,0.00,0.00,0.00,0.00,0.00),('1','116','720','118252',2349901,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118252',2349902,'1972','297',34631.82,34844.67,212.85,30011.85,0.00,0.00,0.00,0.00,0.00),('1','116','717','118360',2352112,'1950','297',497025.10,500115.54,3090.44,435752.04,0.00,0.00,0.00,0.00,0.00),('1','116','717','118360',2352113,'1951','297',596855.26,596855.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118360',2352114,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118360',2352115,'1953','297',704913.41,708433.38,3519.97,496315.77,0.00,0.00,0.00,0.00,0.00),('1','116','717','118360',2352116,'1954','297',465079.19,467467.01,2387.82,336682.62,0.00,0.00,0.00,0.00,0.00),('1','116','717','118360',2352117,'1955','297',472818.39,472818.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118360',2352118,'1956','297',505300.51,507320.97,2020.46,284884.86,0.00,0.00,0.00,0.00,0.00),('1','116','717','118360',2352119,'1957','297',768761.35,771664.67,2903.32,409368.12,0.00,0.00,0.00,0.00,0.00),('1','116','719','118360',2352120,'1966','298',366938.64,369311.86,2373.22,522108.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','118360',2352121,'1967','297',90950.93,90950.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118360',2352122,'1968','297',479580.35,480075.64,495.29,69835.89,0.00,0.00,0.00,0.00,0.00),('1','116','720','118360',2352123,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118360',2352124,'1970','297',382688.55,383314.24,625.69,88222.29,0.00,0.00,0.00,0.00,0.00),('1','116','720','118360',2352125,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118360',2352126,'1972','297',34844.67,34844.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118414',2353344,'1950','297',500115.54,502524.44,2408.90,339654.90,0.00,0.00,0.00,0.00,0.00),('1','116','717','118414',2353345,'1951','297',596855.26,599092.99,2237.73,315519.93,0.00,0.00,0.00,0.00,0.00),('1','116','717','118414',2353346,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118414',2353347,'1953','297',708433.38,711238.54,2805.16,395527.56,0.00,0.00,0.00,0.00,0.00),('1','116','717','118414',2353348,'1954','297',467467.01,469399.47,1932.46,272476.86,0.00,0.00,0.00,0.00,0.00),('1','116','717','118414',2353349,'1955','297',472818.39,472818.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118414',2353350,'1956','297',507320.97,507547.58,226.61,31952.01,0.00,0.00,0.00,0.00,0.00),('1','116','717','118414',2353351,'1957','297',771664.67,775276.30,3611.63,509239.83,0.00,0.00,0.00,0.00,0.00),('1','116','719','118414',2353352,'1966','298',369311.86,370413.71,1101.85,242407.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118414',2353353,'1967','297',90950.93,90950.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118414',2353354,'1968','297',480075.64,481745.35,1669.71,235429.11,0.00,0.00,0.00,0.00,0.00),('1','116','720','118414',2353355,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118414',2353356,'1970','297',383314.24,386547.01,3232.77,455820.57,0.00,0.00,0.00,0.00,0.00),('1','116','720','118414',2353357,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118414',2353358,'1972','297',34844.67,34928.00,83.33,11749.53,0.00,0.00,0.00,0.00,0.00),('1','116','717','118439',2353881,'1950','297',502524.44,503945.66,1421.22,200392.02,0.00,0.00,0.00,0.00,0.00),('1','116','717','118439',2353882,'1951','297',599092.99,599092.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118439',2353883,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118439',2353884,'1953','297',711238.54,713843.39,2604.85,367283.85,0.00,0.00,0.00,0.00,0.00),('1','116','717','118439',2353885,'1954','297',469399.47,470749.58,1350.11,190365.51,0.00,0.00,0.00,0.00,0.00),('1','116','717','118439',2353886,'1955','297',472818.39,472818.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118439',2353887,'1956','297',507547.58,509070.73,1523.15,214764.15,0.00,0.00,0.00,0.00,0.00),('1','116','717','118439',2353888,'1957','297',775276.30,777251.40,1975.10,278489.10,0.00,0.00,0.00,0.00,0.00),('1','116','719','118439',2353889,'1966','298',370413.71,370623.75,210.04,46208.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','118439',2353890,'1967','297',90950.93,91367.53,416.60,58740.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','118439',2353891,'1968','297',481745.35,483337.48,1592.13,224490.33,0.00,0.00,0.00,0.00,0.00),('1','116','720','118439',2353892,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118439',2353893,'1970','297',386547.01,388543.68,1996.67,281530.47,0.00,0.00,0.00,0.00,0.00),('1','116','720','118439',2353894,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118439',2353895,'1972','297',34928.00,34928.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118526',2355546,'1950','297',503945.66,506315.49,2369.83,334146.03,0.00,0.00,0.00,0.00,0.00),('1','116','717','118526',2355547,'1951','297',599092.99,599092.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118526',2355548,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118526',2355549,'1953','297',713843.39,716193.78,2350.39,331404.99,0.00,0.00,0.00,0.00,0.00),('1','116','717','118526',2355550,'1954','297',470749.58,473460.50,2710.92,382239.72,0.00,0.00,0.00,0.00,0.00),('1','116','717','118526',2355551,'1955','297',472818.39,472818.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118526',2355552,'1956','297',509070.73,509070.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118526',2355553,'1957','297',777251.40,779833.38,2581.98,364059.18,0.00,0.00,0.00,0.00,0.00),('1','116','719','118526',2355554,'1966','298',370623.75,370623.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118526',2355555,'1967','297',91367.53,91367.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118526',2355556,'1968','297',483337.48,485822.80,2485.32,350430.12,0.00,0.00,0.00,0.00,0.00),('1','116','720','118526',2355557,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118526',2355558,'1970','297',388543.68,390465.60,1921.92,270990.72,0.00,0.00,0.00,0.00,0.00),('1','116','720','118526',2355559,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118526',2355560,'1972','297',34928.00,34928.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118612',2357222,'1950','297',506315.49,508665.79,2350.30,331392.30,0.00,0.00,0.00,0.00,0.00),('1','116','717','118612',2357223,'1951','297',599092.99,599092.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118612',2357224,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118612',2357225,'1953','297',716193.78,719038.64,2844.86,401125.26,0.00,0.00,0.00,0.00,0.00),('1','116','717','118612',2357226,'1954','297',473460.50,475329.26,1868.76,263495.16,0.00,0.00,0.00,0.00,0.00),('1','116','717','118612',2357227,'1955','297',472818.39,472818.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118612',2357228,'1956','297',509070.73,510492.41,1421.68,200456.88,0.00,0.00,0.00,0.00,0.00),('1','116','717','118612',2357229,'1957','297',779833.38,782049.31,2215.93,312446.13,0.00,0.00,0.00,0.00,0.00),('1','116','719','118612',2357230,'1966','298',370623.75,370623.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118612',2357231,'1967','297',91367.53,93942.21,2574.68,363029.88,0.00,0.00,0.00,0.00,0.00),('1','116','720','118612',2357232,'1968','297',485822.80,485822.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118612',2357233,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118612',2357234,'1970','297',390465.60,392998.46,2532.86,357133.26,0.00,0.00,0.00,0.00,0.00),('1','116','720','118612',2357235,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118612',2357236,'1972','297',34928.00,34928.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118615',2357279,'1950','297',508665.79,512292.61,3616.22,509887.02,0.00,0.00,10.60,0.00,0.00),('1','116','717','118615',2357280,'1951','297',599092.99,601734.56,2641.57,372461.37,0.00,0.00,0.00,0.00,0.00),('1','116','717','118615',2357281,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118615',2357282,'1953','297',719038.64,723026.00,3987.36,562217.76,0.00,0.00,0.00,0.00,0.00),('1','116','717','118615',2357283,'1954','297',475329.26,478337.60,2998.11,422733.51,0.00,0.00,10.23,0.00,0.00),('1','116','717','118615',2357284,'1955','297',472818.39,475383.92,2565.53,361739.73,0.00,0.00,0.00,0.00,0.00),('1','116','717','118615',2357285,'1956','297',510492.41,513779.09,3276.47,461982.27,0.00,0.00,10.21,0.00,0.00),('1','116','717','118615',2357286,'1957','297',782049.31,785419.07,3369.76,475136.16,0.00,0.00,0.00,0.00,0.00),('1','116','719','118615',2357287,'1966','298',370623.75,372355.68,1731.93,381024.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','118615',2357288,'1967','297',93942.21,93942.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118615',2357289,'1968','297',485822.80,485824.22,1.42,200.22,0.00,0.00,0.00,0.00,0.00),('1','116','720','118615',2357290,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118615',2357291,'1970','297',392998.46,392998.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118615',2357292,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118615',2357293,'1972','297',34928.00,34928.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118763',2360785,'1950','297',512292.61,514859.75,2567.14,361966.74,0.00,0.00,0.00,0.00,0.00),('1','116','717','118763',2360786,'1951','297',601734.56,604095.11,2360.55,332837.55,0.00,0.00,0.00,0.00,0.00),('1','116','717','118763',2360787,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118763',2360788,'1953','297',723026.00,726388.46,3362.46,474106.86,0.00,0.00,0.00,0.00,0.00),('1','116','717','118763',2360789,'1954','297',478337.60,480898.81,2561.21,361130.61,0.00,0.00,0.00,0.00,0.00),('1','116','717','118763',2360790,'1955','297',475383.92,477984.06,2600.14,366619.74,0.00,0.00,0.00,0.00,0.00),('1','116','717','118763',2360791,'1956','297',513779.09,513779.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118763',2360792,'1957','297',785419.07,788779.11,3360.04,473765.64,0.00,0.00,0.00,0.00,0.00),('1','116','719','118763',2360793,'1966','298',372355.68,374097.06,1741.38,383103.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','118763',2360794,'1967','297',93942.21,93942.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118763',2360795,'1968','297',485824.22,485824.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118763',2360796,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118763',2360797,'1970','297',392998.46,392998.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118763',2360798,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118763',2360799,'1972','297',34928.00,34928.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118764',2360800,'1950','297',514859.75,517262.39,2402.64,338772.24,0.00,0.00,0.00,0.00,0.00),('1','116','717','118764',2360801,'1951','297',604095.11,607132.26,3037.15,428238.15,0.00,0.00,0.00,0.00,0.00),('1','116','717','118764',2360802,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118764',2360803,'1953','297',726388.46,730373.63,3985.17,561908.97,0.00,0.00,0.00,0.00,0.00),('1','116','717','118764',2360804,'1954','297',480898.81,484344.01,3445.20,485773.20,0.00,0.00,0.00,0.00,0.00),('1','116','717','118764',2360805,'1955','297',477984.06,480708.78,2724.72,384185.52,0.00,0.00,0.00,0.00,0.00),('1','116','717','118764',2360806,'1956','297',513779.09,517848.67,4069.58,573810.78,0.00,0.00,0.00,0.00,0.00),('1','116','717','118764',2360807,'1957','297',788779.11,791845.35,3066.24,432339.84,0.00,0.00,0.00,0.00,0.00),('1','116','719','118764',2360808,'1966','298',374097.06,374344.54,247.48,54445.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','118764',2360809,'1967','297',93942.21,93942.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118764',2360810,'1968','297',485824.22,485824.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118764',2360811,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118764',2360812,'1970','297',392998.46,392998.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118764',2360813,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118764',2360814,'1972','297',34928.00,34928.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118815',2361895,'1950','297',517262.39,520017.42,2755.03,388459.23,0.00,0.00,0.00,0.00,0.00),('1','116','717','118815',2361896,'1951','297',607132.26,607132.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118815',2361897,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118815',2361898,'1953','297',730373.63,733149.40,2775.77,391383.57,0.00,0.00,0.00,0.00,0.00),('1','116','717','118815',2361899,'1954','297',484344.01,485849.47,1505.46,212269.86,0.00,0.00,0.00,0.00,0.00),('1','116','717','118815',2361900,'1955','297',480708.78,483173.37,2464.59,347507.19,0.00,0.00,0.00,0.00,0.00),('1','116','717','118815',2361901,'1956','297',517848.67,519738.52,1889.85,266468.85,0.00,0.00,0.00,0.00,0.00),('1','116','717','118815',2361902,'1957','297',791845.35,794262.29,2416.94,340788.54,0.00,0.00,0.00,0.00,0.00),('1','116','719','118815',2361903,'1966','298',374344.54,374405.36,60.82,13380.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','118815',2361904,'1967','297',93942.21,93942.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118815',2361905,'1968','297',485824.22,485824.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118815',2361906,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118815',2361907,'1970','297',392998.46,392998.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118815',2361908,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118815',2361909,'1972','297',34928.00,34928.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118821',2361988,'1950','297',520017.42,522953.30,2935.88,413959.08,0.00,0.00,0.00,0.00,0.00),('1','116','717','118821',2361989,'1951','297',607132.26,607132.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118821',2361990,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118821',2361991,'1953','297',733149.40,735832.09,2682.69,378259.29,0.00,0.00,0.00,0.00,0.00),('1','116','717','118821',2361992,'1954','297',485849.47,485849.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118821',2361993,'1955','297',483173.37,485447.46,2274.09,320646.69,0.00,0.00,0.00,0.00,0.00),('1','116','717','118821',2361994,'1956','297',519738.52,519738.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118821',2361995,'1957','297',794262.29,797500.32,3238.03,456562.23,0.00,0.00,0.00,0.00,0.00),('1','116','719','118821',2361996,'1966','298',374405.36,375834.18,1428.82,314340.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','118821',2361997,'1967','297',93942.21,93942.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118821',2361998,'1968','297',485824.22,488144.23,2320.01,327121.41,0.00,0.00,0.00,0.00,0.00),('1','116','720','118821',2361999,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118821',2362000,'1970','297',392998.46,395988.72,2990.26,421626.66,0.00,0.00,0.00,0.00,0.00),('1','116','720','118821',2362001,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118821',2362002,'1972','297',34928.00,34928.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118870',2362928,'1950','297',522953.30,525051.45,2098.15,295839.15,0.00,0.00,0.00,0.00,0.00),('1','116','717','118870',2362929,'1951','297',607132.26,607132.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118870',2362930,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118870',2362931,'1953','297',735832.09,738355.10,2523.01,355744.41,0.00,0.00,0.00,0.00,0.00),('1','116','717','118870',2362932,'1954','297',485849.47,487528.09,1678.62,236685.42,0.00,0.00,0.00,0.00,0.00),('1','116','717','118870',2362933,'1955','297',485447.46,485447.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118870',2362934,'1956','297',519738.52,521580.76,1842.24,259755.84,0.00,0.00,0.00,0.00,0.00),('1','116','717','118870',2362935,'1957','297',797500.32,799708.81,2208.49,311397.09,0.00,0.00,0.00,0.00,0.00),('1','116','719','118870',2362936,'1966','298',375834.18,375878.55,44.37,9761.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','118870',2362937,'1967','297',93942.21,93942.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118870',2362938,'1968','297',488144.23,489864.26,1720.03,242524.23,0.00,0.00,0.00,0.00,0.00),('1','116','720','118870',2362939,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118870',2362940,'1970','297',395988.72,398433.65,2444.93,344735.13,0.00,0.00,0.00,0.00,0.00),('1','116','720','118870',2362941,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118870',2362942,'1972','297',34928.00,34928.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118881',2363119,'1950','297',525051.45,527682.19,2630.74,370934.34,0.00,0.00,0.00,0.00,0.00),('1','116','717','118881',2363120,'1951','297',607132.26,607132.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118881',2363121,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118881',2363122,'1953','297',738355.10,741221.53,2866.43,404166.63,0.00,0.00,0.00,0.00,0.00),('1','116','717','118881',2363123,'1954','297',487528.09,487528.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118881',2363124,'1955','297',485447.46,487249.92,1802.46,254146.86,0.00,0.00,0.00,0.00,0.00),('1','116','717','118881',2363125,'1956','297',521580.76,523980.67,2399.91,338387.31,0.00,0.00,0.00,0.00,0.00),('1','116','717','118881',2363126,'1957','297',799708.81,801745.50,2036.69,287173.29,0.00,0.00,0.00,0.00,0.00),('1','116','719','118881',2363127,'1966','298',375878.55,376123.13,244.58,53807.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','118881',2363128,'1967','297',93942.21,93942.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118881',2363129,'1968','297',489864.26,491705.07,1840.81,259554.21,0.00,0.00,0.00,0.00,0.00),('1','116','720','118881',2363130,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118881',2363131,'1970','297',398433.65,400580.90,2147.25,302762.25,0.00,0.00,0.00,0.00,0.00),('1','116','720','118881',2363132,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118881',2363133,'1972','297',34928.00,34928.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118969',2365090,'1950','297',527682.19,529659.72,1977.53,278831.73,0.00,0.00,0.00,0.00,0.00),('1','116','717','118969',2365091,'1951','297',607132.26,607132.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118969',2365092,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118969',2365093,'1953','297',741221.53,743773.15,2551.62,359778.42,0.00,0.00,0.00,0.00,0.00),('1','116','717','118969',2365094,'1954','297',487528.09,487678.33,150.24,21183.84,0.00,0.00,0.00,0.00,0.00),('1','116','717','118969',2365095,'1955','297',487249.92,489168.99,1919.07,270588.87,0.00,0.00,0.00,0.00,0.00),('1','116','717','118969',2365096,'1956','297',523980.67,525803.98,1823.31,257086.71,0.00,0.00,0.00,0.00,0.00),('1','116','717','118969',2365097,'1957','297',801745.50,804273.15,2527.65,356398.65,0.00,0.00,0.00,0.00,0.00),('1','116','719','118969',2365098,'1966','298',376123.13,376123.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118969',2365099,'1967','297',93942.21,93942.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118969',2365100,'1968','297',491705.07,493166.75,1461.68,206096.88,0.00,0.00,0.00,0.00,0.00),('1','116','720','118969',2365101,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118969',2365102,'1970','297',400580.90,402216.92,1636.02,230678.82,0.00,0.00,0.00,0.00,0.00),('1','116','720','118969',2365103,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118969',2365104,'1972','297',34928.00,34928.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118974',2365181,'1950','297',529659.72,532777.01,3117.29,439537.89,0.00,0.00,0.00,0.00,0.00),('1','116','717','118974',2365182,'1951','297',607132.26,608371.44,1239.18,174724.38,0.00,0.00,0.00,0.00,0.00),('1','116','717','118974',2365183,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118974',2365184,'1953','297',743773.15,746265.87,2492.72,351473.52,0.00,0.00,0.00,0.00,0.00),('1','116','717','118974',2365185,'1954','297',487678.33,490163.26,2484.93,350375.13,0.00,0.00,0.00,0.00,0.00),('1','116','717','118974',2365186,'1955','297',489168.99,489168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','118974',2365187,'1956','297',525803.98,527913.42,2109.44,297431.04,0.00,0.00,0.00,0.00,0.00),('1','116','717','118974',2365188,'1957','297',804273.15,805191.70,918.55,129515.55,0.00,0.00,0.00,0.00,0.00),('1','116','719','118974',2365189,'1966','298',376123.13,377544.93,1421.80,312796.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118974',2365190,'1967','297',93942.21,93942.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118974',2365191,'1968','297',493166.75,496351.68,3184.93,449075.13,0.00,0.00,0.00,0.00,0.00),('1','116','720','118974',2365192,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118974',2365193,'1970','297',402216.92,404404.20,2187.28,308406.48,0.00,0.00,0.00,0.00,0.00),('1','116','720','118974',2365194,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','118974',2365195,'1972','297',34928.00,34928.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119106',2368053,'1950','297',532777.01,532777.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119106',2368054,'1951','297',608371.44,608371.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119106',2368055,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119106',2368056,'1953','297',746265.87,749230.52,2964.65,418015.65,0.00,0.00,0.00,0.00,0.00),('1','116','717','119106',2368057,'1954','297',490163.26,490163.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119106',2368058,'1955','297',489168.99,491313.27,2144.28,302343.48,0.00,0.00,0.00,0.00,0.00),('1','116','717','119106',2368059,'1956','297',527913.42,527913.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119106',2368060,'1957','297',805191.70,808216.96,3025.26,426561.66,0.00,0.00,0.00,0.00,0.00),('1','116','719','119106',2368061,'1966','298',377544.93,378646.30,1101.37,242301.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','119106',2368062,'1967','297',93942.21,93942.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119106',2368063,'1968','297',496351.68,498950.79,2599.11,366474.51,0.00,0.00,0.00,0.00,0.00),('1','116','720','119106',2368064,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119106',2368065,'1970','297',404404.20,406167.45,1763.25,248618.25,0.00,0.00,0.00,0.00,0.00),('1','116','720','119106',2368066,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119106',2368067,'1972','297',34928.00,34928.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119108',2368084,'1950','297',532777.01,535347.38,2570.37,362422.17,0.00,0.00,0.00,0.00,0.00),('1','116','717','119108',2368085,'1951','297',608371.44,608371.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119108',2368086,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119108',2368087,'1953','297',749230.52,750807.99,1577.47,222423.27,0.00,0.00,0.00,0.00,0.00),('1','116','717','119108',2368088,'1954','297',490163.26,490958.36,795.10,112109.10,0.00,0.00,0.00,0.00,0.00),('1','116','717','119108',2368089,'1955','297',491313.27,493924.81,2611.54,368227.14,0.00,0.00,0.00,0.00,0.00),('1','116','717','119108',2368090,'1956','297',527913.42,527913.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119108',2368091,'1957','297',808216.96,810935.36,2718.40,383294.40,0.00,0.00,0.00,0.00,0.00),('1','116','719','119108',2368092,'1966','298',378646.30,378971.30,325.00,71500.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119108',2368093,'1967','297',93942.21,94652.16,709.95,100102.95,0.00,0.00,0.00,0.00,0.00),('1','116','720','119108',2368094,'1968','297',498950.79,499753.08,802.29,113122.89,0.00,0.00,0.00,0.00,0.00),('1','116','720','119108',2368095,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119108',2368096,'1970','297',406167.45,407356.82,1189.37,167701.17,0.00,0.00,0.00,0.00,0.00),('1','116','720','119108',2368097,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119108',2368098,'1972','297',34928.00,34928.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119271',2371639,'1950','297',535347.38,538031.73,2684.35,378493.35,0.00,0.00,0.00,0.00,0.00),('1','116','717','119271',2371640,'1951','297',608371.44,608371.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119271',2371641,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119271',2371642,'1953','297',750807.99,752617.77,1809.78,255178.98,0.00,0.00,0.00,0.00,0.00),('1','116','717','119271',2371643,'1954','297',490958.36,491000.91,42.55,5999.55,0.00,0.00,0.00,0.00,0.00),('1','116','717','119271',2371644,'1955','297',493924.81,495907.84,1983.03,279607.23,0.00,0.00,0.00,0.00,0.00),('1','116','717','119271',2371645,'1956','297',527913.42,527913.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119271',2371646,'1957','297',810935.36,813048.85,2113.49,298002.09,0.00,0.00,0.00,0.00,0.00),('1','116','719','119271',2371647,'1966','298',378971.30,379552.25,580.95,127809.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119271',2371648,'1967','297',94652.16,95044.04,391.88,55255.08,0.00,0.00,0.00,0.00,0.00),('1','116','720','119271',2371649,'1968','297',499753.08,499753.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119271',2371650,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119271',2371651,'1970','297',407356.82,408045.48,688.66,97101.06,0.00,0.00,0.00,0.00,0.00),('1','116','720','119271',2371652,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119271',2371653,'1972','297',34928.00,34928.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119274',2371706,'1950','297',538031.73,540032.21,2000.48,282067.68,0.00,0.00,0.00,0.00,0.00),('1','116','717','119274',2371707,'1951','297',608371.44,608371.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119274',2371708,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119274',2371709,'1953','297',752617.77,754992.78,2375.01,334876.41,0.00,0.00,0.00,0.00,0.00),('1','116','717','119274',2371710,'1954','297',491000.91,492173.40,1172.49,165321.09,0.00,0.00,0.00,0.00,0.00),('1','116','717','119274',2371711,'1955','297',495907.84,496505.95,598.11,84333.51,0.00,0.00,0.00,0.00,0.00),('1','116','717','119274',2371712,'1956','297',527913.42,529822.26,1908.84,269146.44,0.00,0.00,0.00,0.00,0.00),('1','116','717','119274',2371713,'1957','297',813048.85,814308.39,1259.54,177595.14,0.00,0.00,0.00,0.00,0.00),('1','116','719','119274',2371714,'1966','298',379552.25,380781.45,1229.20,270424.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119274',2371715,'1967','297',95044.04,95044.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119274',2371716,'1968','297',499753.08,499753.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119274',2371717,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119274',2371718,'1970','297',408045.48,408045.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119274',2371719,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119274',2371720,'1972','297',34928.00,34928.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119276',2371771,'1950','297',540032.21,542061.72,2029.51,286160.91,0.00,0.00,0.00,0.00,0.00),('1','116','717','119276',2371772,'1951','297',608371.44,608371.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119276',2371773,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119276',2371774,'1953','297',754992.78,757277.15,2284.37,322096.17,0.00,0.00,0.00,0.00,0.00),('1','116','717','119276',2371775,'1954','297',492173.40,493587.73,1414.33,199420.53,0.00,0.00,0.00,0.00,0.00),('1','116','717','119276',2371776,'1955','297',496505.95,498192.92,1686.97,237862.77,0.00,0.00,0.00,0.00,0.00),('1','116','717','119276',2371777,'1956','297',529822.26,531580.95,1758.69,247975.29,0.00,0.00,0.00,0.00,0.00),('1','116','717','119276',2371778,'1957','297',814308.39,816261.23,1952.84,275350.44,0.00,0.00,0.00,0.00,0.00),('1','116','719','119276',2371779,'1966','298',380781.45,380956.53,175.08,38517.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','119276',2371780,'1967','297',95044.04,95044.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119276',2371781,'1968','297',499753.08,499753.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119276',2371782,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119276',2371783,'1970','297',408045.48,408045.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119276',2371784,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119276',2371785,'1972','297',34928.00,34928.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119277',2371786,'1950','297',542061.72,544584.34,2522.62,355689.42,0.00,0.00,0.00,0.00,0.00),('1','116','717','119277',2371787,'1951','297',608371.44,608371.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119277',2371788,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119277',2371789,'1953','297',757277.15,760756.14,3478.99,490537.59,0.00,0.00,0.00,0.00,0.00),('1','116','717','119277',2371790,'1954','297',493587.73,495782.98,2195.25,309530.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','119277',2371791,'1955','297',498192.92,499874.51,1681.59,237104.19,0.00,0.00,0.00,0.00,0.00),('1','116','717','119277',2371792,'1956','297',531580.95,533650.91,2069.96,291864.36,0.00,0.00,0.00,0.00,0.00),('1','116','717','119277',2371793,'1957','297',816261.23,818773.74,2512.51,354263.91,0.00,0.00,0.00,0.00,0.00),('1','116','719','119277',2371794,'1966','298',380956.53,381192.82,236.29,51983.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','119277',2371795,'1967','297',95044.04,95044.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119277',2371796,'1968','297',499753.08,499753.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119277',2371797,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119277',2371798,'1970','297',408045.48,408045.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119277',2371799,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119277',2371800,'1972','297',34928.00,34928.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119365',2373606,'1950','297',544584.34,546830.30,2245.96,316680.36,0.00,0.00,0.00,0.00,0.00),('1','116','717','119365',2373607,'1951','297',608371.44,608371.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119365',2373608,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119365',2373609,'1953','297',760756.14,762654.05,1897.91,267605.31,0.00,0.00,0.00,0.00,0.00),('1','116','717','119365',2373610,'1954','297',495782.98,497215.64,1432.66,202005.06,0.00,0.00,0.00,0.00,0.00),('1','116','717','119365',2373611,'1955','297',499874.51,501666.13,1791.62,252618.42,0.00,0.00,0.00,0.00,0.00),('1','116','717','119365',2373612,'1956','297',533650.91,535645.50,1994.59,281237.19,0.00,0.00,0.00,0.00,0.00),('1','116','717','119365',2373613,'1957','297',818773.74,820321.61,1547.87,218249.67,0.00,0.00,0.00,0.00,0.00),('1','116','719','119365',2373614,'1966','298',381192.82,381410.09,217.27,47799.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','119365',2373615,'1967','297',95044.04,95044.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119365',2373616,'1968','297',499753.08,499753.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119365',2373617,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119365',2373618,'1970','297',408045.48,408045.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119365',2373619,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119365',2373620,'1972','297',34928.00,34928.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119366',2373621,'1950','297',546830.30,549443.13,2612.83,368409.03,0.00,0.00,0.00,0.00,0.00),('1','116','717','119366',2373622,'1951','297',608371.44,610412.78,2041.34,287828.94,0.00,0.00,0.00,0.00,0.00),('1','116','717','119366',2373623,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119366',2373624,'1953','297',762654.05,765726.57,3072.52,433225.32,0.00,0.00,0.00,0.00,0.00),('1','116','717','119366',2373625,'1954','297',497215.64,498353.70,1138.06,160466.46,0.00,0.00,0.00,0.00,0.00),('1','116','717','119366',2373626,'1955','297',501666.13,504274.62,2608.49,367797.09,0.00,0.00,0.00,0.00,0.00),('1','116','717','119366',2373627,'1956','297',535645.50,538174.04,2528.54,356524.14,0.00,0.00,0.00,0.00,0.00),('1','116','717','119366',2373628,'1957','297',820321.61,822559.24,2237.63,315505.83,0.00,0.00,0.00,0.00,0.00),('1','116','719','119366',2373629,'1966','298',381410.09,382997.64,1587.55,349261.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119366',2373630,'1967','297',95044.04,95044.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119366',2373631,'1968','297',499753.08,501234.44,1481.36,208871.76,0.00,0.00,0.00,0.00,0.00),('1','116','720','119366',2373632,'1969','297',289816.27,289816.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119366',2373633,'1970','297',408045.48,408574.29,528.81,74562.21,0.00,0.00,0.00,0.00,0.00),('1','116','720','119366',2373634,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119366',2373635,'1972','297',34928.00,35004.43,76.43,10776.63,0.00,0.00,0.00,0.00,0.00),('1','116','717','119376',2373811,'1950','297',549443.13,551413.35,1970.22,277801.02,0.00,0.00,0.00,0.00,0.00),('1','116','717','119376',2373812,'1951','297',610412.78,610412.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119376',2373813,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119376',2373814,'1953','297',765726.57,766374.21,647.64,91317.24,0.00,0.00,0.00,0.00,0.00),('1','116','717','119376',2373815,'1954','297',498353.70,499922.23,1568.53,221162.73,0.00,0.00,0.00,0.00,0.00),('1','116','717','119376',2373816,'1955','297',504274.62,504274.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119376',2373817,'1956','297',538174.04,539298.13,1124.09,158496.69,0.00,0.00,0.00,0.00,0.00),('1','116','717','119376',2373818,'1957','297',822559.24,824273.71,1714.47,241740.27,0.00,0.00,0.00,0.00,0.00),('1','116','719','119376',2373819,'1966','298',382997.64,383353.74,356.10,78342.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119376',2373820,'1967','297',95044.04,95044.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119376',2373821,'1968','297',501234.44,501243.66,9.22,1300.02,0.00,0.00,0.00,0.00,0.00),('1','116','720','119376',2373822,'1969','297',289816.27,289819.02,2.75,387.75,0.00,0.00,0.00,0.00,0.00),('1','116','720','119376',2373823,'1970','297',408574.29,409192.78,618.49,87207.09,0.00,0.00,0.00,0.00,0.00),('1','116','720','119376',2373824,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119376',2373825,'1972','297',35004.43,35004.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119446',2375371,'1950','297',551413.35,553199.99,1786.64,251916.24,0.00,0.00,0.00,0.00,0.00),('1','116','717','119446',2375372,'1951','297',610412.78,610414.36,1.58,222.78,0.00,0.00,0.00,0.00,0.00),('1','116','717','119446',2375373,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119446',2375374,'1953','297',766374.21,768517.49,2143.28,302202.48,0.00,0.00,0.00,0.00,0.00),('1','116','717','119446',2375375,'1954','297',499922.23,499922.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119446',2375376,'1955','297',504274.62,505375.60,1100.98,155238.18,0.00,0.00,0.00,0.00,0.00),('1','116','717','119446',2375377,'1956','297',539298.13,539298.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119446',2375378,'1957','297',824273.71,825840.02,1566.31,220849.71,0.00,0.00,0.00,0.00,0.00),('1','116','719','119446',2375379,'1966','298',383353.74,383655.11,301.37,66301.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','119446',2375380,'1967','297',95044.04,95044.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119446',2375381,'1968','297',501243.66,502493.77,1250.11,176265.51,0.00,0.00,0.00,0.00,0.00),('1','116','720','119446',2375382,'1969','297',289819.02,289819.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119446',2375383,'1970','297',409192.78,410325.70,1132.92,159741.72,0.00,0.00,0.00,0.00,0.00),('1','116','720','119446',2375384,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119446',2375385,'1972','297',35004.43,35004.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119447',2375386,'1950','297',553199.99,555296.40,2086.41,294183.81,0.00,0.00,10.00,0.00,0.00),('1','116','717','119447',2375387,'1951','297',610414.36,610414.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119447',2375388,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119447',2375389,'1953','297',768517.49,771047.31,2519.82,355294.62,0.00,0.00,10.00,0.00,0.00),('1','116','717','119447',2375390,'1954','297',499922.23,501482.68,1550.45,218613.45,0.00,0.00,10.00,0.00,0.00),('1','116','717','119447',2375391,'1955','297',505375.60,507041.45,1645.85,232064.85,0.00,0.00,20.00,0.00,0.00),('1','116','717','119447',2375392,'1956','297',539298.13,539298.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119447',2375393,'1957','297',825840.02,827727.80,1877.78,264766.98,0.00,0.00,10.00,0.00,0.00),('1','116','719','119447',2375394,'1966','298',383655.11,383796.51,141.40,31108.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119447',2375395,'1967','297',95044.04,95044.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119447',2375396,'1968','297',502493.77,502493.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119447',2375397,'1969','297',289819.02,289819.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119447',2375398,'1970','297',410325.70,410325.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119447',2375399,'1971','297',37079.50,37079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119447',2375400,'1972','297',35004.43,35004.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119510',2376927,'1950','297',555296.40,556960.48,1664.08,234635.28,0.00,0.00,0.00,0.00,0.00),('1','116','717','119510',2376928,'1951','297',610414.36,610414.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119510',2376929,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119510',2376930,'1953','297',771047.31,774066.34,3019.03,425683.23,0.00,0.00,0.00,0.00,0.00),('1','116','717','119510',2376931,'1954','297',501482.68,502634.03,1151.35,162340.35,0.00,0.00,0.00,0.00,0.00),('1','116','717','119510',2376932,'1955','297',507041.45,507041.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119510',2376933,'1956','297',539298.13,539298.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119510',2376934,'1957','297',827727.80,830500.38,2772.58,390933.78,0.00,0.00,0.00,0.00,0.00),('1','116','719','119510',2376935,'1966','298',383796.51,384278.18,481.67,105967.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','119510',2376936,'1967','297',95044.04,95044.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119510',2376937,'1968','297',502493.77,504980.71,2486.94,350658.54,0.00,0.00,0.00,0.00,0.00),('1','116','720','119510',2376938,'1969','297',289819.02,289819.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119510',2376939,'1970','297',410325.70,412203.01,1877.31,264700.71,0.00,0.00,0.00,0.00,0.00),('1','116','720','119510',2376940,'1971','297',37079.50,37119.04,39.54,5575.14,0.00,0.00,0.00,0.00,0.00),('1','116','720','119510',2376941,'1972','297',35004.43,35016.57,12.14,1711.74,0.00,0.00,0.00,0.00,0.00),('1','116','717','119601',2378903,'1950','297',556960.48,558136.55,1176.07,165825.87,0.00,0.00,0.00,0.00,0.00),('1','116','717','119601',2378904,'1951','297',610414.36,610414.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119601',2378905,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119601',2378906,'1953','297',774066.34,775966.22,1899.88,267883.08,0.00,0.00,0.00,0.00,0.00),('1','116','717','119601',2378907,'1954','297',502634.03,504393.17,1759.14,248038.74,0.00,0.00,0.00,0.00,0.00),('1','116','717','119601',2378908,'1955','297',507041.45,507041.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119601',2378909,'1956','297',539298.13,539298.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119601',2378910,'1957','297',830500.38,831951.55,1451.17,204614.97,0.00,0.00,0.00,0.00,0.00),('1','116','719','119601',2378911,'1966','298',384278.18,385071.72,793.54,174578.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','119601',2378912,'1967','297',95044.04,95044.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119601',2378913,'1968','297',504980.71,506380.88,1400.17,197423.97,0.00,0.00,0.00,0.00,0.00),('1','116','720','119601',2378914,'1969','297',289819.02,289819.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119601',2378915,'1970','297',412203.01,413678.69,1475.68,208070.88,0.00,0.00,0.00,0.00,0.00),('1','116','720','119601',2378916,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119601',2378917,'1972','297',35016.57,35016.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119614',2379279,'1950','297',558136.55,560462.28,2325.73,327927.93,0.00,0.00,0.00,0.00,0.00),('1','116','717','119614',2379280,'1951','297',610414.36,611444.15,1029.79,145200.39,0.00,0.00,0.00,0.00,0.00),('1','116','717','119614',2379281,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119614',2379282,'1953','297',775966.22,778528.48,2562.26,361278.66,0.00,0.00,0.00,0.00,0.00),('1','116','717','119614',2379283,'1954','297',504393.17,506778.82,2385.65,336376.65,0.00,0.00,0.00,0.00,0.00),('1','116','717','119614',2379284,'1955','297',507041.45,507041.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119614',2379285,'1956','297',539298.13,539330.10,31.97,4507.77,0.00,0.00,0.00,0.00,0.00),('1','116','717','119614',2379286,'1957','297',831951.55,834286.01,2324.46,327748.86,0.00,0.00,10.00,0.00,0.00),('1','116','719','119614',2379287,'1966','298',385071.72,385409.04,317.32,69810.40,0.00,0.00,20.00,0.00,0.00),('1','116','720','119614',2379288,'1967','297',95044.04,95044.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119614',2379289,'1968','297',506380.88,508153.31,1762.43,248502.63,0.00,0.00,10.00,0.00,0.00),('1','116','720','119614',2379290,'1969','297',289819.02,289819.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119614',2379291,'1970','297',413678.69,415984.07,2285.38,322238.58,0.00,0.00,20.00,0.00,0.00),('1','116','720','119614',2379292,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119614',2379293,'1972','297',35016.57,35030.78,4.21,593.61,0.00,0.00,10.00,0.00,0.00),('1','116','717','119746',2382210,'1950','297',560462.28,562603.71,2141.43,301941.63,0.00,0.00,0.00,0.00,0.00),('1','116','717','119746',2382211,'1951','297',611444.15,611444.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119746',2382212,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119746',2382213,'1953','297',778528.48,781049.51,2521.03,355465.23,0.00,0.00,0.00,0.00,0.00),('1','116','717','119746',2382214,'1954','297',506778.82,506778.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119746',2382215,'1955','297',507041.45,507242.01,200.56,28278.96,0.00,0.00,0.00,0.00,0.00),('1','116','717','119746',2382216,'1956','297',539330.10,539330.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119746',2382217,'1957','297',834286.01,835682.87,1396.86,196957.26,0.00,0.00,0.00,0.00,0.00),('1','116','719','119746',2382218,'1966','298',385409.04,385718.81,309.77,68149.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','119746',2382219,'1967','297',95044.04,95044.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119746',2382220,'1968','297',508153.31,510155.91,2002.60,282366.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','119746',2382221,'1969','297',289819.02,289819.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119746',2382222,'1970','297',415984.07,417620.79,1636.72,230777.52,0.00,0.00,0.00,0.00,0.00),('1','116','720','119746',2382223,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119746',2382224,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119747',2382225,'1950','297',562603.71,565753.55,3149.84,444127.44,0.00,0.00,0.00,0.00,0.00),('1','116','717','119747',2382226,'1951','297',611444.15,611444.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119747',2382227,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119747',2382228,'1953','297',781049.51,782837.56,1788.05,252115.05,0.00,0.00,0.00,0.00,0.00),('1','116','717','119747',2382229,'1954','297',506778.82,506778.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119747',2382230,'1955','297',507242.01,509996.01,2754.00,388314.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119747',2382231,'1956','297',539330.10,540227.81,897.71,126577.11,0.00,0.00,0.00,0.00,0.00),('1','116','717','119747',2382232,'1957','297',835682.87,838370.80,2687.93,378998.13,0.00,0.00,0.00,0.00,0.00),('1','116','719','119747',2382233,'1966','298',385718.81,387011.19,1292.38,284323.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','119747',2382234,'1967','297',95044.04,95044.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119747',2382235,'1968','297',510155.91,511723.48,1567.57,221027.37,0.00,0.00,0.00,0.00,0.00),('1','116','720','119747',2382236,'1969','297',289819.02,289819.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119747',2382237,'1970','297',417620.79,419233.20,1612.41,227349.81,0.00,0.00,0.00,0.00,0.00),('1','116','720','119747',2382238,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119747',2382239,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119817',2383676,'1950','297',565753.55,567449.19,1695.64,239085.24,0.00,0.00,0.00,0.00,0.00),('1','116','717','119817',2383677,'1951','297',611444.15,611444.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119817',2383678,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119817',2383679,'1953','297',782837.56,784521.07,1683.51,237374.91,0.00,0.00,0.00,0.00,0.00),('1','116','717','119817',2383680,'1954','297',506778.82,507793.51,1014.69,143071.29,0.00,0.00,0.00,0.00,0.00),('1','116','717','119817',2383681,'1955','297',509996.01,509996.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119817',2383682,'1956','297',540227.81,541358.22,1130.41,159387.81,0.00,0.00,0.00,0.00,0.00),('1','116','717','119817',2383683,'1957','297',838370.80,839276.58,905.78,127714.98,0.00,0.00,0.00,0.00,0.00),('1','116','719','119817',2383684,'1966','298',387011.19,387430.52,419.33,92252.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','119817',2383685,'1967','297',95044.04,95044.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119817',2383686,'1968','297',511723.48,512851.91,1128.43,159108.63,0.00,0.00,0.00,0.00,0.00),('1','116','720','119817',2383687,'1969','297',289819.02,289819.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119817',2383688,'1970','297',419233.20,420857.20,1624.00,228984.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119817',2383689,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119817',2383690,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119820',2383742,'1950','297',567449.19,569930.39,2481.20,349849.20,0.00,0.00,0.00,0.00,0.00),('1','116','717','119820',2383743,'1951','297',611444.15,611444.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119820',2383744,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119820',2383745,'1953','297',784521.07,786809.74,2288.67,322702.47,0.00,0.00,0.00,0.00,0.00),('1','116','717','119820',2383746,'1954','297',507793.51,507793.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119820',2383747,'1955','297',509996.01,511698.23,1702.22,240013.02,0.00,0.00,0.00,0.00,0.00),('1','116','717','119820',2383748,'1956','297',541358.22,541358.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119820',2383749,'1957','297',839276.58,841486.69,2210.11,311625.51,0.00,0.00,0.00,0.00,0.00),('1','116','719','119820',2383750,'1966','298',387430.52,388609.64,1179.12,259406.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','119820',2383751,'1967','297',95044.04,95044.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119820',2383752,'1968','297',512851.91,514328.20,1476.29,208156.89,0.00,0.00,0.00,0.00,0.00),('1','116','720','119820',2383753,'1969','297',289819.02,289819.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119820',2383754,'1970','297',420857.20,422533.91,1676.71,236416.11,0.00,0.00,0.00,0.00,0.00),('1','116','720','119820',2383755,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119820',2383756,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119934',2386147,'1950','297',569930.39,571603.30,1672.91,235880.31,0.00,0.00,0.00,0.00,0.00),('1','116','717','119934',2386148,'1951','297',611444.15,612766.33,1322.18,186427.38,0.00,0.00,0.00,0.00,0.00),('1','116','717','119934',2386149,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119934',2386150,'1953','297',786809.74,788709.00,1899.26,267795.66,0.00,0.00,0.00,0.00,0.00),('1','116','717','119934',2386151,'1954','297',507793.51,507793.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119934',2386152,'1955','297',511698.23,512971.04,1272.81,179466.21,0.00,0.00,0.00,0.00,0.00),('1','116','717','119934',2386153,'1956','297',541358.22,542231.94,863.72,121784.52,0.00,0.00,10.00,0.00,0.00),('1','116','717','119934',2386154,'1957','297',841486.69,843236.71,1740.02,245342.82,0.00,0.00,10.00,0.00,0.00),('1','116','719','119934',2386155,'1966','298',388609.64,388779.31,169.67,37327.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','119934',2386156,'1967','297',95044.04,95610.01,565.97,79801.77,0.00,0.00,0.00,0.00,0.00),('1','116','720','119934',2386157,'1968','297',514328.20,515102.75,774.55,109211.55,0.00,0.00,0.00,0.00,0.00),('1','116','720','119934',2386158,'1969','297',289819.02,289819.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119934',2386159,'1970','297',422533.91,423990.42,1456.51,205367.91,0.00,0.00,0.00,0.00,0.00),('1','116','720','119934',2386160,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119934',2386161,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119937',2386208,'1950','297',571603.30,574281.51,2678.21,377627.61,0.00,0.00,0.00,0.00,0.00),('1','116','717','119937',2386209,'1951','297',612766.33,612766.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119937',2386210,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119937',2386211,'1953','297',788709.00,791730.05,3021.05,425968.05,0.00,0.00,0.00,0.00,0.00),('1','116','717','119937',2386212,'1954','297',507793.51,507793.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119937',2386213,'1955','297',512971.04,515681.14,2710.10,382124.10,0.00,0.00,0.00,0.00,0.00),('1','116','717','119937',2386214,'1956','297',542231.94,543409.99,1178.05,166105.05,0.00,0.00,0.00,0.00,0.00),('1','116','717','119937',2386215,'1957','297',843236.71,844889.71,1632.41,230169.81,0.00,0.00,20.59,0.00,0.00),('1','116','719','119937',2386216,'1966','298',388779.31,389728.88,949.57,208905.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','119937',2386217,'1967','297',95610.01,97212.31,1602.30,225924.30,0.00,0.00,0.00,0.00,0.00),('1','116','720','119937',2386218,'1968','297',515102.75,515102.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119937',2386219,'1969','297',289819.02,292722.61,2903.59,409406.19,0.00,0.00,0.00,0.00,0.00),('1','116','720','119937',2386220,'1970','297',423990.42,424130.78,119.87,16901.67,0.00,0.00,20.49,0.00,0.00),('1','116','720','119937',2386221,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119937',2386222,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119996',2387470,'1950','297',574281.51,574281.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119996',2387471,'1951','297',612766.33,614841.92,2065.39,291219.99,0.00,0.00,10.20,0.00,0.00),('1','116','717','119996',2387472,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','119996',2387473,'1953','297',791730.05,793813.01,2082.96,293697.36,0.00,0.00,0.00,0.00,0.00),('1','116','717','119996',2387474,'1954','297',507793.51,508801.66,1008.15,142149.15,0.00,0.00,0.00,0.00,0.00),('1','116','717','119996',2387475,'1955','297',515681.14,515691.34,0.00,0.00,0.00,0.00,10.20,0.00,0.00),('1','116','717','119996',2387476,'1956','297',543409.99,544315.85,905.86,127726.26,0.00,0.00,0.00,0.00,0.00),('1','116','717','119996',2387477,'1957','297',844889.71,846404.85,1515.14,213634.74,0.00,0.00,0.00,0.00,0.00),('1','116','719','119996',2387478,'1966','298',389728.88,389985.78,256.90,56518.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119996',2387479,'1967','297',97212.31,98026.85,804.35,113413.35,0.00,0.00,10.19,0.00,0.00),('1','116','720','119996',2387480,'1968','297',515102.75,515564.21,461.46,65065.86,0.00,0.00,0.00,0.00,0.00),('1','116','720','119996',2387481,'1969','297',292722.61,292722.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119996',2387482,'1970','297',424130.78,425420.68,1279.90,180465.90,0.00,0.00,10.00,0.00,0.00),('1','116','720','119996',2387483,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','119996',2387484,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120000',2387540,'1950','297',574281.51,574281.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120000',2387541,'1951','297',614841.92,617425.24,2583.32,364248.12,0.00,0.00,0.00,0.00,0.00),('1','116','717','120000',2387542,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120000',2387543,'1953','297',793813.01,796381.81,2568.80,362200.80,0.00,0.00,0.00,0.00,0.00),('1','116','717','120000',2387544,'1954','297',508801.66,508801.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120000',2387545,'1955','297',515691.34,517900.27,2208.93,311459.13,0.00,0.00,0.00,0.00,0.00),('1','116','717','120000',2387546,'1956','297',544315.85,544315.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120000',2387547,'1957','297',846404.85,848612.42,2207.57,311267.37,0.00,0.00,0.00,0.00,0.00),('1','116','719','120000',2387548,'1966','298',389985.78,390219.87,234.09,51499.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','120000',2387549,'1967','297',98026.85,98026.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120000',2387550,'1968','297',515564.21,517774.40,2210.19,311636.79,0.00,0.00,0.00,0.00,0.00),('1','116','720','120000',2387551,'1969','297',292722.61,292722.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120000',2387552,'1970','297',425420.68,427396.64,1975.96,278610.36,0.00,0.00,0.00,0.00,0.00),('1','116','720','120000',2387553,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120000',2387554,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120101',2389524,'1950','297',574281.51,576217.51,1936.00,272976.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120101',2389525,'1951','297',617425.24,617425.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120101',2389526,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120101',2389527,'1953','297',796381.81,798408.14,2026.33,285712.53,0.00,0.00,0.00,0.00,0.00),('1','116','717','120101',2389528,'1954','297',508801.66,508801.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120101',2389529,'1955','297',517900.27,518923.21,1022.94,144234.54,0.00,0.00,0.00,0.00,0.00),('1','116','717','120101',2389530,'1956','297',544315.85,546247.83,1931.98,272409.18,0.00,0.00,0.00,0.00,0.00),('1','116','717','120101',2389531,'1957','297',848612.42,848612.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','120101',2389532,'1966','298',390219.87,390440.52,220.65,48543.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120101',2389533,'1967','297',98026.85,98026.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120101',2389534,'1968','297',517774.40,519565.12,1790.72,252491.52,0.00,0.00,0.00,0.00,0.00),('1','116','720','120101',2389535,'1969','297',292722.61,292722.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120101',2389536,'1970','297',427396.64,428918.39,1521.75,214566.75,0.00,0.00,0.00,0.00,0.00),('1','116','720','120101',2389537,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120101',2389538,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120104',2389566,'1950','297',576217.51,578806.72,2589.21,365078.61,0.00,0.00,0.00,0.00,0.00),('1','116','717','120104',2389567,'1951','297',617425.24,617425.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120104',2389568,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120104',2389569,'1953','297',798408.14,801720.91,3312.77,467100.57,0.00,0.00,0.00,0.00,0.00),('1','116','717','120104',2389570,'1954','297',508801.66,509517.01,715.35,100864.35,0.00,0.00,0.00,0.00,0.00),('1','116','717','120104',2389571,'1955','297',518923.21,521552.50,2629.29,370729.89,0.00,0.00,0.00,0.00,0.00),('1','116','717','120104',2389572,'1956','297',546247.83,547250.54,1002.71,141382.11,0.00,0.00,0.00,0.00,0.00),('1','116','717','120104',2389573,'1957','297',848612.42,851360.33,2747.91,387455.31,0.00,0.00,0.00,0.00,0.00),('1','116','719','120104',2389574,'1966','298',390440.52,391725.87,1285.35,282777.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120104',2389575,'1967','297',98026.85,98026.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120104',2389576,'1968','297',519565.12,520860.68,1295.56,182673.96,0.00,0.00,0.00,0.00,0.00),('1','116','720','120104',2389577,'1969','297',292722.61,294440.78,1718.17,242261.97,0.00,0.00,0.00,0.00,0.00),('1','116','720','120104',2389578,'1970','297',428918.39,428918.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120104',2389579,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120104',2389580,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120340',2394671,'1950','297',578806.72,578806.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120340',2394672,'1951','297',617425.24,619156.09,1720.67,242614.47,0.00,0.00,10.18,0.00,0.00),('1','116','717','120340',2394673,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120340',2394674,'1953','297',801720.91,803678.93,1958.02,276080.82,0.00,0.00,0.00,0.00,0.00),('1','116','717','120340',2394675,'1954','297',509517.01,510810.07,1293.06,182321.46,0.00,0.00,0.00,0.00,0.00),('1','116','717','120340',2394676,'1955','297',521552.50,521552.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120340',2394677,'1956','297',547250.54,547923.38,672.84,94870.44,0.00,0.00,0.00,0.00,0.00),('1','116','717','120340',2394678,'1957','297',851360.33,852936.65,1576.32,222261.12,0.00,0.00,0.00,0.00,0.00),('1','116','719','120340',2394679,'1966','298',391725.87,392278.12,552.25,121495.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120340',2394680,'1967','297',98026.85,98374.02,347.17,48950.97,0.00,0.00,0.00,0.00,0.00),('1','116','720','120340',2394681,'1968','297',520860.68,521961.10,1090.42,153749.22,0.00,0.00,10.00,0.00,0.00),('1','116','720','120340',2394682,'1969','297',294440.78,294440.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120340',2394683,'1970','297',428918.39,430468.65,1550.26,218586.66,0.00,0.00,0.00,0.00,0.00),('1','116','720','120340',2394684,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120340',2394685,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120364',2395091,'1950','297',578806.72,581463.95,2657.23,374669.43,0.00,0.00,0.00,0.00,0.00),('1','116','717','120364',2395092,'1951','297',619156.09,619156.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120364',2395093,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120364',2395094,'1953','297',803678.93,806266.31,2587.38,364820.58,0.00,0.00,0.00,0.00,0.00),('1','116','717','120364',2395095,'1954','297',510810.07,512792.25,1982.18,279487.38,0.00,0.00,0.00,0.00,0.00),('1','116','717','120364',2395096,'1955','297',521552.50,521552.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120364',2395097,'1956','297',547923.38,547923.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120364',2395098,'1957','297',852936.65,855956.74,3020.09,425832.69,0.00,0.00,0.00,0.00,0.00),('1','116','719','120364',2395099,'1966','298',392278.12,392909.35,631.23,138870.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','120364',2395100,'1967','297',98374.02,98374.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120364',2395101,'1968','297',521961.10,524505.51,2544.41,358761.81,0.00,0.00,0.00,0.00,0.00),('1','116','720','120364',2395102,'1969','297',294440.78,294440.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120364',2395103,'1970','297',430468.65,433304.67,2836.02,399878.82,0.00,0.00,0.00,0.00,0.00),('1','116','720','120364',2395104,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120364',2395105,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120615',2399994,'1950','297',581463.95,583183.35,1719.40,242435.40,0.00,0.00,0.00,0.00,0.00),('1','116','717','120615',2399995,'1951','297',619156.09,619156.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120615',2399996,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120615',2399997,'1953','297',806266.31,808716.36,2450.05,345457.05,0.00,0.00,0.00,0.00,0.00),('1','116','717','120615',2399998,'1954','297',512792.25,514600.81,1808.56,255006.96,0.00,0.00,0.00,0.00,0.00),('1','116','717','120615',2399999,'1955','297',521552.50,521552.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120615',2400000,'1956','297',547923.38,547923.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120615',2400001,'1957','297',855956.74,857696.83,1740.09,245352.69,0.00,0.00,0.00,0.00,0.00),('1','116','719','120615',2400002,'1966','298',392909.35,393246.17,336.82,74100.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','120615',2400003,'1967','297',98374.02,98823.02,449.00,63309.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120615',2400004,'1968','297',524505.51,526173.90,1668.39,235242.99,0.00,0.00,0.00,0.00,0.00),('1','116','720','120615',2400005,'1969','297',294440.78,294440.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120615',2400006,'1970','297',433304.67,435202.14,1897.47,267543.27,0.00,0.00,0.00,0.00,0.00),('1','116','720','120615',2400007,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120615',2400008,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120619',2400059,'1950','297',583183.35,585206.52,2023.17,285266.97,0.00,0.00,0.00,0.00,0.00),('1','116','717','120619',2400060,'1951','297',619156.09,620415.42,1259.33,177565.53,0.00,0.00,0.00,0.00,0.00),('1','116','717','120619',2400061,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120619',2400062,'1953','297',808716.36,811373.87,2657.51,374708.91,0.00,0.00,0.00,0.00,0.00),('1','116','717','120619',2400063,'1954','297',514600.81,516728.29,2127.48,299974.68,0.00,0.00,0.00,0.00,0.00),('1','116','717','120619',2400064,'1955','297',521552.50,523290.40,1737.90,245043.90,0.00,0.00,0.00,0.00,0.00),('1','116','717','120619',2400065,'1956','297',547923.38,549070.42,1147.04,161732.64,0.00,0.00,0.00,0.00,0.00),('1','116','717','120619',2400066,'1957','297',857696.83,860130.71,2433.88,343177.08,0.00,0.00,0.00,0.00,0.00),('1','116','719','120619',2400067,'1966','298',393246.17,395003.75,1757.58,386667.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','120619',2400068,'1967','297',98823.02,98823.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120619',2400069,'1968','297',526173.90,527338.67,1164.77,164232.57,0.00,0.00,0.00,0.00,0.00),('1','116','720','120619',2400070,'1969','297',294440.78,294440.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120619',2400071,'1970','297',435202.14,436665.96,1463.82,206398.62,0.00,0.00,0.00,0.00,0.00),('1','116','720','120619',2400072,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120619',2400073,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120780',2403385,'1950','297',585206.52,586753.05,1546.53,218060.73,0.00,0.00,0.00,0.00,0.00),('1','116','717','120780',2403386,'1951','297',620415.42,621885.13,1469.71,207229.11,0.00,0.00,0.00,0.00,0.00),('1','116','717','120780',2403387,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120780',2403388,'1953','297',811373.87,813664.81,2290.94,323022.54,0.00,0.00,0.00,0.00,0.00),('1','116','717','120780',2403389,'1954','297',516728.29,517595.78,867.49,122316.09,0.00,0.00,0.00,0.00,0.00),('1','116','717','120780',2403390,'1955','297',523290.40,524892.26,1601.86,225862.26,0.00,0.00,0.00,0.00,0.00),('1','116','717','120780',2403391,'1956','297',549070.42,550481.01,1410.59,198893.19,0.00,0.00,0.00,0.00,0.00),('1','116','717','120780',2403392,'1957','297',860130.71,861539.36,1408.65,198619.65,0.00,0.00,0.00,0.00,0.00),('1','116','719','120780',2403393,'1966','298',395003.75,395666.02,662.27,145699.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','120780',2403394,'1967','297',98823.02,98823.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120780',2403395,'1968','297',527338.67,527338.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120780',2403396,'1969','297',294440.78,294440.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120780',2403397,'1970','297',436665.96,436665.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120780',2403398,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120780',2403399,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120782',2403428,'1950','297',586753.05,589320.84,2567.79,362058.39,0.00,0.00,0.00,0.00,0.00),('1','116','717','120782',2403429,'1951','297',621885.13,621885.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120782',2403430,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120782',2403431,'1953','297',813664.81,816738.07,3073.26,433329.66,0.00,0.00,0.00,0.00,0.00),('1','116','717','120782',2403432,'1954','297',517595.78,519935.83,2340.05,329947.05,0.00,0.00,0.00,0.00,0.00),('1','116','717','120782',2403433,'1955','297',524892.26,526524.46,1632.20,230140.20,0.00,0.00,0.00,0.00,0.00),('1','116','717','120782',2403434,'1956','297',550481.01,552844.89,2363.88,333307.08,0.00,0.00,0.00,0.00,0.00),('1','116','717','120782',2403435,'1957','297',861539.36,864181.30,2641.94,372513.54,0.00,0.00,0.00,0.00,0.00),('1','116','719','120782',2403436,'1966','298',395666.02,396456.02,790.00,173800.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120782',2403437,'1967','297',98823.02,98823.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120782',2403438,'1968','297',527338.67,527338.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120782',2403439,'1969','297',294440.78,294440.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120782',2403440,'1970','297',436665.96,436665.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120782',2403441,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120782',2403442,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120904',2406065,'1950','297',589320.84,590967.17,1646.33,232132.53,0.00,0.00,0.00,0.00,0.00),('1','116','717','120904',2406066,'1951','297',621885.13,622476.80,591.67,83425.47,0.00,0.00,0.00,0.00,0.00),('1','116','717','120904',2406067,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120904',2406068,'1953','297',816738.07,818683.74,1945.67,274339.47,0.00,0.00,0.00,0.00,0.00),('1','116','717','120904',2406069,'1954','297',519935.83,520921.81,985.98,139023.18,0.00,0.00,0.00,0.00,0.00),('1','116','717','120904',2406070,'1955','297',526524.46,527573.56,1049.10,147923.10,0.00,0.00,0.00,0.00,0.00),('1','116','717','120904',2406071,'1956','297',552844.89,554597.53,1752.64,247122.24,0.00,0.00,0.00,0.00,0.00),('1','116','717','120904',2406072,'1957','297',864181.30,865822.42,1641.12,231397.92,0.00,0.00,0.00,0.00,0.00),('1','116','719','120904',2406073,'1966','298',396456.02,396798.84,342.82,75420.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','120904',2406074,'1967','297',98823.02,98823.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120904',2406075,'1968','297',527338.67,527338.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120904',2406076,'1969','297',294440.78,294440.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120904',2406077,'1970','297',436665.96,436665.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120904',2406078,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120904',2406079,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120906',2406111,'1950','297',590967.17,592519.63,1552.46,218896.86,0.00,0.00,0.00,0.00,0.00),('1','116','717','120906',2406112,'1951','297',622476.80,623879.46,1402.66,197775.06,0.00,0.00,0.00,0.00,0.00),('1','116','717','120906',2406113,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','120906',2406114,'1953','297',818683.74,821234.64,2550.90,359676.90,0.00,0.00,0.00,0.00,0.00),('1','116','717','120906',2406115,'1954','297',520921.81,521918.48,996.67,140530.47,0.00,0.00,0.00,0.00,0.00),('1','116','717','120906',2406116,'1955','297',527573.56,528786.41,1212.85,171011.85,0.00,0.00,0.00,0.00,0.00),('1','116','717','120906',2406117,'1956','297',554597.53,556200.42,1602.89,226007.49,0.00,0.00,0.00,0.00,0.00),('1','116','717','120906',2406118,'1957','297',865822.42,867594.85,1772.43,249912.63,0.00,0.00,0.00,0.00,0.00),('1','116','719','120906',2406119,'1966','298',396798.84,397024.59,225.75,49665.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120906',2406120,'1967','297',98823.02,98823.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120906',2406121,'1968','297',527338.67,527338.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120906',2406122,'1969','297',294440.78,294440.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120906',2406123,'1970','297',436665.96,436665.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120906',2406124,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','120906',2406125,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121011',2408302,'1950','297',592519.63,594278.86,1759.23,248051.43,0.00,0.00,0.00,0.00,0.00),('1','116','717','121011',2408303,'1951','297',623879.46,623879.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121011',2408304,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121011',2408305,'1953','297',821234.64,824150.36,2915.72,411116.52,0.00,0.00,0.00,0.00,0.00),('1','116','717','121011',2408306,'1954','297',521918.48,524067.64,2149.16,303031.56,0.00,0.00,0.00,0.00,0.00),('1','116','717','121011',2408307,'1955','297',528786.41,530399.20,1612.79,227403.39,0.00,0.00,0.00,0.00,0.00),('1','116','717','121011',2408308,'1956','297',556200.42,558058.01,1857.59,261920.19,0.00,0.00,0.00,0.00,0.00),('1','116','717','121011',2408309,'1957','297',867594.85,869332.80,1737.95,245050.95,0.00,0.00,0.00,0.00,0.00),('1','116','719','121011',2408310,'1966','298',397024.59,397387.69,363.10,79882.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121011',2408311,'1967','297',98823.02,98823.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121011',2408312,'1968','297',527338.67,527338.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121011',2408313,'1969','297',294440.78,294440.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121011',2408314,'1970','297',436665.96,436665.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121011',2408315,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121011',2408316,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121051',2408973,'1950','297',594278.86,597323.31,3024.45,426447.45,0.00,0.00,20.00,0.00,0.00),('1','116','717','121051',2408974,'1951','297',623879.46,624119.75,230.29,32470.89,0.00,0.00,10.00,0.00,0.00),('1','116','717','121051',2408975,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121051',2408976,'1953','297',824150.36,827319.26,3148.90,443994.90,0.00,0.00,20.00,0.00,0.00),('1','116','717','121051',2408977,'1954','297',524067.64,526202.65,2115.01,298216.41,0.00,0.00,20.00,0.00,0.00),('1','116','717','121051',2408978,'1955','297',530399.20,532453.00,2043.80,288175.80,0.00,0.00,10.00,0.00,0.00),('1','116','717','121051',2408979,'1956','297',558058.01,560154.70,2076.69,292813.29,0.00,0.00,20.00,0.00,0.00),('1','116','717','121051',2408980,'1957','297',869332.80,872458.47,3105.67,437899.47,0.00,0.00,20.00,0.00,0.00),('1','116','719','121051',2408981,'1966','298',397387.69,398763.40,1355.71,298256.20,0.00,0.00,20.00,0.00,0.00),('1','116','720','121051',2408982,'1967','297',98823.02,98823.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121051',2408983,'1968','297',527338.67,527338.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121051',2408984,'1969','297',294440.78,294440.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121051',2408985,'1970','297',436665.96,436665.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121051',2408986,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121051',2408987,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121186',2411743,'1950','297',597323.31,598946.01,1622.70,228800.70,0.00,0.00,0.00,0.00,0.00),('1','116','717','121186',2411744,'1951','297',624119.75,624119.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121186',2411745,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121186',2411746,'1953','297',827319.26,829324.17,2004.91,282692.31,0.00,0.00,0.00,0.00,0.00),('1','116','717','121186',2411747,'1954','297',526202.65,527931.03,1728.38,243701.58,0.00,0.00,0.00,0.00,0.00),('1','116','717','121186',2411748,'1955','297',532453.00,532453.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121186',2411749,'1956','297',560154.70,560154.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121186',2411750,'1957','297',872458.47,874535.92,2077.45,292920.45,0.00,0.00,0.00,0.00,0.00),('1','116','719','121186',2411751,'1966','298',398763.40,399659.98,896.58,197247.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','121186',2411752,'1967','297',98823.02,98823.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121186',2411753,'1968','297',527338.67,529084.80,1746.13,246204.33,0.00,0.00,0.00,0.00,0.00),('1','116','720','121186',2411754,'1969','297',294440.78,294440.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121186',2411755,'1970','297',436665.96,438385.95,1719.99,242518.59,0.00,0.00,0.00,0.00,0.00),('1','116','720','121186',2411756,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121186',2411757,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121187',2411758,'1950','297',598946.01,601832.87,2886.86,407047.26,0.00,0.00,0.00,0.00,0.00),('1','116','717','121187',2411759,'1951','297',624119.75,624119.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121187',2411760,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121187',2411761,'1953','297',829324.17,832056.99,2732.82,385327.62,0.00,0.00,0.00,0.00,0.00),('1','116','717','121187',2411762,'1954','297',527931.03,529993.52,2062.49,290811.09,0.00,0.00,0.00,0.00,0.00),('1','116','717','121187',2411763,'1955','297',532453.00,533412.06,959.06,135227.46,0.00,0.00,0.00,0.00,0.00),('1','116','717','121187',2411764,'1956','297',560154.70,562507.02,2352.32,331677.12,0.00,0.00,0.00,0.00,0.00),('1','116','717','121187',2411765,'1957','297',874535.92,874778.60,242.68,34217.88,0.00,0.00,0.00,0.00,0.00),('1','116','719','121187',2411766,'1966','298',399659.98,401098.49,1438.51,316472.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','121187',2411767,'1967','297',98823.02,100638.04,1815.02,255917.82,0.00,0.00,0.00,0.00,0.00),('1','116','720','121187',2411768,'1968','297',529084.80,529084.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121187',2411769,'1969','297',294440.78,294440.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121187',2411770,'1970','297',438385.95,440226.47,1840.52,259513.32,0.00,0.00,0.00,0.00,0.00),('1','116','720','121187',2411771,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121187',2411772,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121380',2415651,'1950','297',601832.87,601832.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121380',2415652,'1951','297',624119.75,624119.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121380',2415653,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121380',2415654,'1953','297',832056.99,834314.77,2257.78,318346.98,0.00,0.00,0.00,0.00,0.00),('1','116','717','121380',2415655,'1954','297',529993.52,532163.38,2169.86,305950.26,0.00,0.00,0.00,0.00,0.00),('1','116','717','121380',2415656,'1955','297',533412.06,533423.76,11.70,1649.70,0.00,0.00,0.00,0.00,0.00),('1','116','717','121380',2415657,'1956','297',562507.02,562507.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121380',2415658,'1957','297',874778.60,877120.00,2341.40,330137.40,0.00,0.00,0.00,0.00,0.00),('1','116','719','121380',2415659,'1966','298',401098.49,401541.43,442.94,97446.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','121380',2415660,'1967','297',100638.04,100638.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121380',2415661,'1968','297',529084.80,530833.52,1748.72,246569.52,0.00,0.00,0.00,0.00,0.00),('1','116','720','121380',2415662,'1969','297',294440.78,294440.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121380',2415663,'1970','297',440226.47,442366.28,2139.81,301713.21,0.00,0.00,0.00,0.00,0.00),('1','116','720','121380',2415664,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121380',2415665,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121381',2415666,'1950','297',601832.87,604224.16,2391.29,337171.89,0.00,0.00,0.00,0.00,0.00),('1','116','717','121381',2415667,'1951','297',624119.75,624119.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121381',2415668,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121381',2415669,'1953','297',834314.77,836496.07,2181.30,307563.30,0.00,0.00,0.00,0.00,0.00),('1','116','717','121381',2415670,'1954','297',532163.38,534017.42,1854.04,261419.64,0.00,0.00,0.00,0.00,0.00),('1','116','717','121381',2415671,'1955','297',533423.76,534914.27,1490.51,210161.91,0.00,0.00,0.00,0.00,0.00),('1','116','717','121381',2415672,'1956','297',562507.02,564578.75,2071.73,292113.93,0.00,0.00,0.00,0.00,0.00),('1','116','717','121381',2415673,'1957','297',877120.00,879179.99,2059.99,290458.59,0.00,0.00,0.00,0.00,0.00),('1','116','719','121381',2415674,'1966','298',401541.43,402191.88,650.45,143099.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121381',2415675,'1967','297',100638.04,100638.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121381',2415676,'1968','297',530833.52,533052.58,2219.06,312887.46,0.00,0.00,0.00,0.00,0.00),('1','116','720','121381',2415677,'1969','297',294440.78,294440.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121381',2415678,'1970','297',442366.28,444664.75,2298.47,324084.27,0.00,0.00,0.00,0.00,0.00),('1','116','720','121381',2415679,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121381',2415680,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121484',2417873,'1950','297',604224.16,606443.78,2219.62,312966.42,0.00,0.00,0.00,0.00,0.00),('1','116','717','121484',2417874,'1951','297',624119.75,624119.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121484',2417875,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121484',2417876,'1953','297',836496.07,838508.80,2012.73,283794.93,0.00,0.00,0.00,0.00,0.00),('1','116','717','121484',2417877,'1954','297',534017.42,535832.99,1815.57,255995.37,0.00,0.00,0.00,0.00,0.00),('1','116','717','121484',2417878,'1955','297',534914.27,534914.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121484',2417879,'1956','297',564578.75,564578.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121484',2417880,'1957','297',879179.99,880938.27,1758.28,247917.48,0.00,0.00,0.00,0.00,0.00),('1','116','719','121484',2417881,'1966','298',402191.88,403257.09,1065.21,234346.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','121484',2417882,'1967','297',100638.04,100638.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121484',2417883,'1968','297',533052.58,534681.41,1628.83,229665.03,0.00,0.00,0.00,0.00,0.00),('1','116','720','121484',2417884,'1969','297',294440.78,294440.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121484',2417885,'1970','297',444664.75,446395.66,1730.91,244058.31,0.00,0.00,0.00,0.00,0.00),('1','116','720','121484',2417886,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121484',2417887,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121485',2417888,'1950','297',606443.78,608537.94,2094.16,295276.56,0.00,0.00,0.00,0.00,0.00),('1','116','717','121485',2417889,'1951','297',624119.75,624119.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121485',2417890,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121485',2417891,'1953','297',838508.80,841141.84,2633.04,371258.64,0.00,0.00,0.00,0.00,0.00),('1','116','717','121485',2417892,'1954','297',535832.99,537301.91,1468.92,207117.72,0.00,0.00,0.00,0.00,0.00),('1','116','717','121485',2417893,'1955','297',534914.27,536673.62,1759.35,248068.35,0.00,0.00,0.00,0.00,0.00),('1','116','717','121485',2417894,'1956','297',564578.75,566352.26,1773.51,250064.91,0.00,0.00,0.00,0.00,0.00),('1','116','717','121485',2417895,'1957','297',880938.27,882717.46,1779.19,250865.79,0.00,0.00,0.00,0.00,0.00),('1','116','719','121485',2417896,'1966','298',403257.09,403592.47,335.38,73783.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','121485',2417897,'1967','297',100638.04,102415.72,1777.68,250652.88,0.00,0.00,0.00,0.00,0.00),('1','116','720','121485',2417898,'1968','297',534681.41,534770.78,89.37,12601.17,0.00,0.00,0.00,0.00,0.00),('1','116','720','121485',2417899,'1969','297',294440.78,294440.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121485',2417900,'1970','297',446395.66,448448.37,2052.71,289432.11,0.00,0.00,0.00,0.00,0.00),('1','116','720','121485',2417901,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121485',2417902,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121579',2419927,'1950','297',608537.94,610317.05,1779.11,250854.51,0.00,0.00,0.00,0.00,0.00),('1','116','717','121579',2419928,'1951','297',624119.75,624119.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121579',2419929,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121579',2419930,'1953','297',841141.84,843215.95,2074.11,292449.51,0.00,0.00,0.00,0.00,0.00),('1','116','717','121579',2419931,'1954','297',537301.91,539268.38,1966.47,277272.27,0.00,0.00,0.00,0.00,0.00),('1','116','717','121579',2419932,'1955','297',536673.62,536673.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121579',2419933,'1956','297',566352.26,566352.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121579',2419934,'1957','297',882717.46,884456.67,1739.21,245228.61,0.00,0.00,0.00,0.00,0.00),('1','116','719','121579',2419935,'1966','298',403592.47,405758.37,2165.90,476498.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121579',2419936,'1967','297',102415.72,102415.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121579',2419937,'1968','297',534770.78,536332.91,1562.13,220260.33,0.00,0.00,0.00,0.00,0.00),('1','116','720','121579',2419938,'1969','297',294440.78,294440.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121579',2419939,'1970','297',448448.37,449693.04,1244.67,175498.47,0.00,0.00,0.00,0.00,0.00),('1','116','720','121579',2419940,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121579',2419941,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121581',2419953,'1950','297',610317.05,612716.10,2399.05,338266.05,0.00,0.00,0.00,0.00,0.00),('1','116','717','121581',2419954,'1951','297',624119.75,624119.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121581',2419955,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121581',2419956,'1953','297',843215.95,846565.04,3349.09,472221.69,0.00,0.00,0.00,0.00,0.00),('1','116','717','121581',2419957,'1954','297',539268.38,539268.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121581',2419958,'1955','297',536673.62,538807.37,2133.75,300858.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','121581',2419959,'1956','297',566352.26,568343.75,1991.49,280800.09,0.00,0.00,0.00,0.00,0.00),('1','116','717','121581',2419960,'1957','297',884456.67,886249.29,1792.62,252759.42,0.00,0.00,0.00,0.00,0.00),('1','116','719','121581',2419961,'1966','298',405758.37,406279.19,520.82,114580.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','121581',2419962,'1967','297',102415.72,102954.89,539.17,76022.97,0.00,0.00,0.00,0.00,0.00),('1','116','720','121581',2419963,'1968','297',536332.91,537725.90,1392.99,196411.59,0.00,0.00,0.00,0.00,0.00),('1','116','720','121581',2419964,'1969','297',294440.78,295199.43,758.65,106969.65,0.00,0.00,0.00,0.00,0.00),('1','116','720','121581',2419965,'1970','297',449693.04,451448.45,1755.41,247512.81,0.00,0.00,0.00,0.00,0.00),('1','116','720','121581',2419966,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121581',2419967,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121740',2423103,'1950','297',612716.10,614742.45,2026.35,285715.35,0.00,0.00,0.00,0.00,0.00),('1','116','717','121740',2423104,'1951','297',624119.75,624139.66,19.91,2807.31,0.00,0.00,0.00,0.00,0.00),('1','116','717','121740',2423105,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121740',2423106,'1953','297',846565.04,847749.93,1184.89,167069.49,0.00,0.00,0.00,0.00,0.00),('1','116','717','121740',2423107,'1954','297',539268.38,540236.81,968.43,136548.63,0.00,0.00,0.00,0.00,0.00),('1','116','717','121740',2423108,'1955','297',538807.37,540379.62,1572.25,221687.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','121740',2423109,'1956','297',568343.75,569694.38,1350.63,190438.83,0.00,0.00,0.00,0.00,0.00),('1','116','717','121740',2423110,'1957','297',886249.29,888128.11,1878.82,264913.62,0.00,0.00,0.00,0.00,0.00),('1','116','719','121740',2423111,'1966','298',406279.19,406632.36,353.17,77697.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','121740',2423112,'1967','297',102954.89,102954.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121740',2423113,'1968','297',537725.90,537725.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121740',2423114,'1969','297',295199.43,295199.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121740',2423115,'1970','297',451448.45,451448.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121740',2423116,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121740',2423117,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121741',2423118,'1950','297',614742.45,617236.54,2484.02,350246.82,0.00,0.00,10.07,0.00,0.00),('1','116','717','121741',2423119,'1951','297',624139.66,624369.23,219.57,30959.37,0.00,0.00,10.00,0.00,0.00),('1','116','717','121741',2423120,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121741',2423121,'1953','297',847749.93,850440.27,2680.14,377899.74,0.00,0.00,10.20,0.00,0.00),('1','116','717','121741',2423122,'1954','297',540236.81,542302.74,2045.83,288462.03,0.00,0.00,20.10,0.00,0.00),('1','116','717','121741',2423123,'1955','297',540379.62,542204.75,1825.13,257343.33,0.00,0.00,0.00,0.00,0.00),('1','116','717','121741',2423124,'1956','297',569694.38,572048.01,2351.63,331579.83,0.00,0.00,2.00,0.00,0.00),('1','116','717','121741',2423125,'1957','297',888128.11,890176.31,2038.05,287365.05,0.00,0.00,10.15,0.00,0.00),('1','116','719','121741',2423126,'1966','298',406632.36,407841.63,1209.27,266039.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','121741',2423127,'1967','297',102954.89,102954.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121741',2423128,'1968','297',537725.90,537725.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121741',2423129,'1969','297',295199.43,295199.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121741',2423130,'1970','297',451448.45,451448.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121741',2423131,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121741',2423132,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121948',2427729,'1950','297',617236.54,618708.24,1471.70,207509.70,0.00,0.00,0.00,0.00,0.00),('1','116','717','121948',2427730,'1951','297',624369.23,624369.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121948',2427731,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121948',2427732,'1953','297',850440.27,852471.29,2031.02,286373.82,0.00,0.00,0.00,0.00,0.00),('1','116','717','121948',2427733,'1954','297',542302.74,544161.57,1858.83,262095.03,0.00,0.00,0.00,0.00,0.00),('1','116','717','121948',2427734,'1955','297',542204.75,542204.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121948',2427735,'1956','297',572048.01,573274.52,1226.51,172937.91,0.00,0.00,0.00,0.00,0.00),('1','116','717','121948',2427736,'1957','297',890176.31,891843.66,1667.35,235096.35,0.00,0.00,0.00,0.00,0.00),('1','116','719','121948',2427737,'1966','298',407841.63,408328.17,486.54,107037.70,0.00,0.00,0.00,0.00,0.00),('1','116','720','121948',2427738,'1967','297',102954.89,102954.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121948',2427739,'1968','297',537725.90,537725.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121948',2427740,'1969','297',295199.43,295199.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121948',2427741,'1970','297',451448.45,451448.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121948',2427742,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121948',2427743,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121953',2427834,'1950','297',618708.24,619860.36,1152.12,162448.92,0.00,0.00,0.00,0.00,0.00),('1','116','717','121953',2427835,'1951','297',624369.23,624369.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121953',2427836,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121953',2427837,'1953','297',852471.29,854738.93,2267.64,319737.24,0.00,0.00,0.00,0.00,0.00),('1','116','717','121953',2427838,'1954','297',544161.57,545814.91,1653.34,233120.94,0.00,0.00,0.00,0.00,0.00),('1','116','717','121953',2427839,'1955','297',542204.75,544215.88,2011.13,283569.33,0.00,0.00,0.00,0.00,0.00),('1','116','717','121953',2427840,'1956','297',573274.52,575291.74,2017.22,284428.02,0.00,0.00,0.00,0.00,0.00),('1','116','717','121953',2427841,'1957','297',891843.66,893226.13,1382.47,194928.27,0.00,0.00,0.00,0.00,0.00),('1','116','719','121953',2427842,'1966','298',408328.17,408630.85,302.68,66589.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','121953',2427843,'1967','297',102954.89,102954.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121953',2427844,'1968','297',537725.90,537725.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121953',2427845,'1969','297',295199.43,295199.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121953',2427846,'1970','297',451448.45,451448.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121953',2427847,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121953',2427848,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121972',2428237,'1950','297',619860.36,621906.48,2046.12,288502.92,0.00,0.00,0.00,0.00,0.00),('1','116','717','121972',2428238,'1951','297',624369.23,624411.78,42.55,5999.55,0.00,0.00,0.00,0.00,0.00),('1','116','717','121972',2428239,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121972',2428240,'1953','297',854738.93,857301.17,2562.24,361275.84,0.00,0.00,0.00,0.00,0.00),('1','116','717','121972',2428241,'1954','297',545814.91,547528.50,1713.59,241616.19,0.00,0.00,0.00,0.00,0.00),('1','116','717','121972',2428242,'1955','297',544215.88,545386.73,1170.85,165089.85,0.00,0.00,0.00,0.00,0.00),('1','116','717','121972',2428243,'1956','297',575291.74,576628.40,1336.66,188469.06,0.00,0.00,0.00,0.00,0.00),('1','116','717','121972',2428244,'1957','297',893226.13,895408.17,2182.04,307667.64,0.00,0.00,0.00,0.00,0.00),('1','116','719','121972',2428245,'1966','298',408630.85,409022.97,392.12,86266.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','121972',2428246,'1967','297',102954.89,102954.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121972',2428247,'1968','297',537725.90,537725.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121972',2428248,'1969','297',295199.43,295199.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121972',2428249,'1970','297',451448.45,451448.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121972',2428250,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121972',2428251,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121985',2428562,'1950','297',621906.48,625150.95,3244.47,457470.27,0.00,0.00,0.00,0.00,0.00),('1','116','717','121985',2428563,'1951','297',624411.78,625258.11,846.33,119332.53,0.00,0.00,0.00,0.00,0.00),('1','116','717','121985',2428564,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121985',2428565,'1953','297',857301.17,860691.12,3389.95,477982.95,0.00,0.00,0.00,0.00,0.00),('1','116','717','121985',2428566,'1954','297',547528.50,550619.30,3090.80,435802.80,0.00,0.00,0.00,0.00,0.00),('1','116','717','121985',2428567,'1955','297',545386.73,546635.59,1248.86,176089.26,0.00,0.00,0.00,0.00,0.00),('1','116','717','121985',2428568,'1956','297',576628.40,576628.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','121985',2428569,'1957','297',895408.17,899188.82,3780.65,533071.65,0.00,0.00,0.00,0.00,0.00),('1','116','719','121985',2428570,'1966','298',409022.97,409487.65,464.68,102229.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','121985',2428571,'1967','297',102954.89,102954.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121985',2428572,'1968','297',537725.90,537725.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121985',2428573,'1969','297',295199.43,295199.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121985',2428574,'1970','297',451448.45,451448.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121985',2428575,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','121985',2428576,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122135',2431591,'1950','297',625258.11,627287.37,2029.26,286125.66,0.00,0.00,0.00,0.00,0.00),('1','116','717','122135',2431592,'1951','297',624411.78,624532.04,120.26,16956.66,0.00,0.00,0.00,0.00,0.00),('1','116','717','122135',2431593,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122135',2431594,'1953','297',860691.12,862696.13,2005.01,282706.41,0.00,0.00,0.00,0.00,0.00),('1','116','717','122135',2431595,'1954','297',550619.30,552191.69,1572.39,221706.99,0.00,0.00,0.00,0.00,0.00),('1','116','717','122135',2431596,'1955','297',546635.59,548155.95,1520.36,214370.76,0.00,0.00,0.00,0.00,0.00),('1','116','717','122135',2431597,'1956','297',576628.40,578320.45,1692.05,238579.05,0.00,0.00,0.00,0.00,0.00),('1','116','717','122135',2431598,'1957','297',899188.82,900896.45,1707.63,240775.83,0.00,0.00,0.00,0.00,0.00),('1','116','719','122135',2431599,'1966','298',409487.65,409854.86,367.21,80786.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','122135',2431600,'1967','297',102954.89,102954.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122135',2431601,'1968','297',537725.90,537725.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122135',2431602,'1969','297',295199.43,295199.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122135',2431603,'1970','297',451448.45,451448.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122135',2431604,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122135',2431605,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122138',2431639,'1950','297',627287.37,629594.01,2306.64,325236.24,0.00,0.00,0.00,0.00,0.00),('1','116','717','122138',2431640,'1951','297',624532.04,624622.82,90.78,12799.98,0.00,0.00,0.00,0.00,0.00),('1','116','717','122138',2431641,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122138',2431642,'1953','297',862696.13,865828.57,3132.44,441674.04,0.00,0.00,0.00,0.00,0.00),('1','116','717','122138',2431643,'1954','297',552191.69,554997.41,2805.72,395606.52,0.00,0.00,0.00,0.00,0.00),('1','116','717','122138',2431644,'1955','297',548155.95,550347.28,2191.33,308977.53,0.00,0.00,0.00,0.00,0.00),('1','116','717','122138',2431645,'1956','297',578320.45,578320.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122138',2431646,'1957','297',900896.45,904113.89,3217.44,453659.04,0.00,0.00,0.00,0.00,0.00),('1','116','719','122138',2431647,'1966','298',409854.86,410354.86,500.00,110000.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122138',2431648,'1967','297',102954.89,102954.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122138',2431649,'1968','297',537725.90,537725.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122138',2431650,'1969','297',295199.43,295199.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122138',2431651,'1970','297',451448.45,451448.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122138',2431652,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122138',2431653,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122256',2434152,'1950','297',629594.01,631469.19,1875.18,264400.38,0.00,0.00,0.00,0.00,0.00),('1','116','717','122256',2434153,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122256',2434154,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122256',2434155,'1953','297',865828.57,867936.39,2107.82,297202.62,0.00,0.00,0.00,0.00,0.00),('1','116','717','122256',2434156,'1954','297',554997.41,555892.91,895.50,126265.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','122256',2434157,'1955','297',550347.28,551500.46,1153.18,162598.38,0.00,0.00,0.00,0.00,0.00),('1','116','717','122256',2434158,'1956','297',578320.45,578320.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122256',2434159,'1957','297',904113.89,906023.97,1910.08,269321.28,0.00,0.00,0.00,0.00,0.00),('1','116','719','122256',2434160,'1966','298',410354.86,410354.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122256',2434161,'1967','297',102954.89,102954.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122256',2434162,'1968','297',537725.90,539241.33,1515.43,213675.63,0.00,0.00,0.00,0.00,0.00),('1','116','720','122256',2434163,'1969','297',295199.43,295199.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122256',2434164,'1970','297',451448.45,452823.24,1374.79,193845.39,0.00,0.00,0.00,0.00,0.00),('1','116','720','122256',2434165,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122256',2434166,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122258',2434186,'1950','297',631469.19,633776.04,2306.85,325265.85,0.00,0.00,0.00,0.00,0.00),('1','116','717','122258',2434187,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122258',2434188,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122258',2434189,'1953','297',867936.39,870846.64,2910.25,410345.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','122258',2434190,'1954','297',555892.91,555892.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122258',2434191,'1955','297',551500.46,553595.10,2094.64,295344.24,0.00,0.00,0.00,0.00,0.00),('1','116','717','122258',2434192,'1956','297',578320.45,578320.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122258',2434193,'1957','297',906023.97,908773.69,2749.72,387710.52,0.00,0.00,0.00,0.00,0.00),('1','116','719','122258',2434194,'1966','298',410354.86,410354.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122258',2434195,'1967','297',102954.89,102954.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122258',2434196,'1968','297',539241.33,541753.07,2511.74,354155.34,0.00,0.00,0.00,0.00,0.00),('1','116','720','122258',2434197,'1969','297',295199.43,295199.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122258',2434198,'1970','297',452823.24,455205.00,2381.76,335828.16,0.00,0.00,0.00,0.00,0.00),('1','116','720','122258',2434199,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122258',2434200,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122332',2435785,'1950','297',633776.04,635459.07,1673.03,235897.23,0.00,0.00,10.00,0.00,0.00),('1','116','717','122332',2435786,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122332',2435787,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122332',2435788,'1953','297',870846.64,872593.02,1726.38,243419.58,0.00,0.00,20.00,0.00,0.00),('1','116','717','122332',2435789,'1954','297',555892.91,556705.47,802.56,113160.96,0.00,0.00,10.00,0.00,0.00),('1','116','717','122332',2435790,'1955','297',553595.10,554618.66,1013.56,142911.96,0.00,0.00,10.00,0.00,0.00),('1','116','717','122332',2435791,'1956','297',578320.45,579515.89,1185.44,167147.04,0.00,0.00,10.00,0.00,0.00),('1','116','717','122332',2435792,'1957','297',908773.69,910054.49,1260.80,177772.80,0.00,0.00,20.00,0.00,0.00),('1','116','719','122332',2435793,'1966','298',410354.86,410354.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122332',2435794,'1967','297',102954.89,103411.67,446.78,62995.98,0.00,0.00,10.00,0.00,0.00),('1','116','720','122332',2435795,'1968','297',541753.07,542719.04,955.97,134791.77,0.00,0.00,10.00,0.00,0.00),('1','116','720','122332',2435796,'1969','297',295199.43,295199.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122332',2435797,'1970','297',455205.00,456770.97,1555.97,219391.77,0.00,0.00,10.00,0.00,0.00),('1','116','720','122332',2435798,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122332',2435799,'1972','297',35030.78,35030.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122378',2436666,'1950','297',635459.07,635655.23,196.16,27658.56,0.00,0.00,0.00,0.00,0.00),('1','116','717','122378',2436667,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122378',2436668,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122378',2436669,'1953','297',872593.02,875356.00,2762.98,389580.18,0.00,0.00,0.00,0.00,0.00),('1','116','717','122378',2436670,'1954','297',556705.47,559801.41,3095.94,436527.54,0.00,0.00,0.00,0.00,0.00),('1','116','717','122378',2436671,'1955','297',554618.66,554618.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122378',2436672,'1956','297',579515.89,579515.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122378',2436673,'1957','297',910054.49,913134.54,3080.05,434287.05,0.00,0.00,0.00,0.00,0.00),('1','116','719','122378',2436674,'1966','298',410354.86,410704.86,350.00,77000.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122378',2436675,'1967','297',103411.67,103411.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122378',2436676,'1968','297',542719.04,545570.46,2851.42,402050.22,0.00,0.00,0.00,0.00,0.00),('1','116','720','122378',2436677,'1969','297',295199.43,295199.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122378',2436678,'1970','297',456770.97,459762.88,2991.91,421859.31,0.00,0.00,0.00,0.00,0.00),('1','116','720','122378',2436679,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122378',2436680,'1972','297',35030.78,35059.80,29.02,4091.82,0.00,0.00,0.00,0.00,0.00),('1','116','717','122523',2439952,'1950','297',635655.23,636785.39,1130.16,159352.56,0.00,0.00,0.00,0.00,0.00),('1','116','717','122523',2439953,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122523',2439954,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122523',2439955,'1953','297',875356.00,877403.53,2047.53,288701.73,0.00,0.00,0.00,0.00,0.00),('1','116','717','122523',2439956,'1954','297',559801.41,561018.24,1216.83,171573.03,0.00,0.00,0.00,0.00,0.00),('1','116','717','122523',2439957,'1955','297',554618.66,555359.90,741.24,104514.84,0.00,0.00,0.00,0.00,0.00),('1','116','717','122523',2439958,'1956','297',579515.89,580635.83,1119.94,157911.54,0.00,0.00,0.00,0.00,0.00),('1','116','717','122523',2439959,'1957','297',913134.54,914141.38,1006.84,141964.44,0.00,0.00,0.00,0.00,0.00),('1','116','719','122523',2439960,'1966','298',410704.86,410704.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122523',2439961,'1967','297',103411.67,104094.34,682.67,96256.47,0.00,0.00,0.00,0.00,0.00),('1','116','720','122523',2439962,'1968','297',545570.46,546658.43,1087.97,153403.77,0.00,0.00,0.00,0.00,0.00),('1','116','720','122523',2439963,'1969','297',295199.43,296180.02,980.59,138263.19,0.00,0.00,0.00,0.00,0.00),('1','116','720','122523',2439964,'1970','297',459762.88,460873.24,1110.36,156560.76,0.00,0.00,0.00,0.00,0.00),('1','116','720','122523',2439965,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122523',2439966,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122529',2440085,'1950','297',636785.39,637045.47,260.08,36671.28,0.00,0.00,0.00,0.00,0.00),('1','116','717','122529',2440086,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122529',2440087,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122529',2440088,'1953','297',877403.53,881009.65,3606.12,508462.92,0.00,0.00,0.00,0.00,0.00),('1','116','717','122529',2440089,'1954','297',561018.24,564164.67,3146.43,443646.63,0.00,0.00,0.00,0.00,0.00),('1','116','717','122529',2440090,'1955','297',555359.90,555639.36,279.46,39403.86,0.00,0.00,0.00,0.00,0.00),('1','116','717','122529',2440091,'1956','297',580635.83,580635.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122529',2440092,'1957','297',914141.38,917482.51,3341.13,471099.33,0.00,0.00,0.00,0.00,0.00),('1','116','719','122529',2440093,'1966','298',410704.86,413077.13,2372.27,521899.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','122529',2440094,'1967','297',104094.34,106231.83,2137.49,301386.09,0.00,0.00,0.00,0.00,0.00),('1','116','720','122529',2440095,'1968','297',546658.43,546658.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122529',2440096,'1969','297',296180.02,299726.41,3546.39,500040.99,0.00,0.00,0.00,0.00,0.00),('1','116','720','122529',2440097,'1970','297',460873.24,460873.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122529',2440098,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122529',2440099,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122625',2441988,'1950','297',637045.47,638500.34,1454.87,205136.67,0.00,0.00,0.00,0.00,0.00),('1','116','717','122625',2441989,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122625',2441990,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122625',2441991,'1953','297',881009.65,882511.39,1501.74,211745.34,0.00,0.00,0.00,0.00,0.00),('1','116','717','122625',2441992,'1954','297',564164.67,564883.07,718.40,101294.40,0.00,0.00,0.00,0.00,0.00),('1','116','717','122625',2441993,'1955','297',555639.36,556593.92,954.56,134592.96,0.00,0.00,0.00,0.00,0.00),('1','116','717','122625',2441994,'1956','297',580635.83,581489.17,853.34,120320.94,0.00,0.00,0.00,0.00,0.00),('1','116','717','122625',2441995,'1957','297',917482.51,918431.57,949.06,133817.46,0.00,0.00,0.00,0.00,0.00),('1','116','719','122625',2441996,'1966','298',413077.13,414459.40,1382.27,304099.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','122625',2441997,'1967','297',106231.83,106662.74,430.91,60758.31,0.00,0.00,0.00,0.00,0.00),('1','116','720','122625',2441998,'1968','297',546658.43,547503.67,845.24,119178.84,0.00,0.00,0.00,0.00,0.00),('1','116','720','122625',2441999,'1969','297',299726.41,299726.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122625',2442000,'1970','297',460873.24,462239.58,1366.34,192653.94,0.00,0.00,0.00,0.00,0.00),('1','116','720','122625',2442001,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122625',2442002,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122627',2442017,'1950','297',638500.34,640424.17,1923.83,271260.03,0.00,0.00,0.00,0.00,0.00),('1','116','717','122627',2442018,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122627',2442019,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122627',2442020,'1953','297',882511.39,885675.96,3164.57,446204.37,0.00,0.00,0.00,0.00,0.00),('1','116','717','122627',2442021,'1954','297',564883.07,566621.86,1738.79,245169.39,0.00,0.00,0.00,0.00,0.00),('1','116','717','122627',2442022,'1955','297',556593.92,557975.59,1381.67,194815.47,0.00,0.00,0.00,0.00,0.00),('1','116','717','122627',2442023,'1956','297',581489.17,582967.94,1478.77,208506.57,0.00,0.00,0.00,0.00,0.00),('1','116','717','122627',2442024,'1957','297',918431.57,921048.13,2616.56,368934.96,0.00,0.00,0.00,0.00,0.00),('1','116','719','122627',2442025,'1966','298',414459.40,414847.85,388.45,85459.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122627',2442026,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122627',2442027,'1968','297',547503.67,548184.63,680.96,96015.36,0.00,0.00,0.00,0.00,0.00),('1','116','720','122627',2442028,'1969','297',299726.41,300300.47,574.06,80942.46,0.00,0.00,0.00,0.00,0.00),('1','116','720','122627',2442029,'1970','297',462239.58,462239.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122627',2442030,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122627',2442031,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122683',2443080,'1950','297',640424.17,642004.57,1580.40,222836.40,0.00,0.00,0.00,0.00,0.00),('1','116','717','122683',2443081,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122683',2443082,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122683',2443083,'1953','297',885675.96,887619.62,1943.66,274056.06,0.00,0.00,0.00,0.00,0.00),('1','116','717','122683',2443084,'1954','297',566621.86,567760.42,1138.56,160536.96,0.00,0.00,0.00,0.00,0.00),('1','116','717','122683',2443085,'1955','297',557975.59,559038.85,1063.26,149919.66,0.00,0.00,0.00,0.00,0.00),('1','116','717','122683',2443086,'1956','297',582967.94,584232.52,1264.58,178305.78,0.00,0.00,0.00,0.00,0.00),('1','116','717','122683',2443087,'1957','297',921048.13,922341.42,1293.29,182353.89,0.00,0.00,0.00,0.00,0.00),('1','116','719','122683',2443088,'1966','298',414847.85,415323.39,475.54,104618.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','122683',2443089,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122683',2443090,'1968','297',548184.63,548184.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122683',2443091,'1969','297',300300.47,300300.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122683',2443092,'1970','297',462239.58,462239.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122683',2443093,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122683',2443094,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122684',2443095,'1950','297',642004.57,644256.39,2251.82,317506.62,0.00,0.00,0.00,0.00,0.00),('1','116','717','122684',2443096,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122684',2443097,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122684',2443098,'1953','297',887619.62,890160.81,2541.19,358307.79,0.00,0.00,0.00,0.00,0.00),('1','116','717','122684',2443099,'1954','297',567760.42,569198.47,1438.05,202765.05,0.00,0.00,0.00,0.00,0.00),('1','116','717','122684',2443100,'1955','297',559038.85,560712.12,1673.27,235931.07,0.00,0.00,0.00,0.00,0.00),('1','116','717','122684',2443101,'1956','297',584232.52,586172.04,1939.52,273472.32,0.00,0.00,0.00,0.00,0.00),('1','116','717','122684',2443102,'1957','297',922341.42,924086.22,1744.80,246016.80,0.00,0.00,0.00,0.00,0.00),('1','116','719','122684',2443103,'1966','298',415323.39,415680.23,356.84,78504.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','122684',2443104,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122684',2443105,'1968','297',548184.63,548184.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122684',2443106,'1969','297',300300.47,300300.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122684',2443107,'1970','297',462239.58,462239.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122684',2443108,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122684',2443109,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122867',2446901,'1950','297',644256.39,646729.54,2473.15,348714.15,0.00,0.00,0.00,0.00,0.00),('1','116','717','122867',2446902,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122867',2446903,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122867',2446904,'1953','297',890160.81,892829.60,2668.79,376299.39,0.00,0.00,0.00,0.00,0.00),('1','116','717','122867',2446905,'1954','297',569198.47,571263.36,2064.89,291149.49,0.00,0.00,0.00,0.00,0.00),('1','116','717','122867',2446906,'1955','297',560712.12,560712.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122867',2446907,'1956','297',586172.04,586982.35,810.31,114253.71,0.00,0.00,0.00,0.00,0.00),('1','116','717','122867',2446908,'1957','297',924086.22,926652.67,2566.45,361869.45,0.00,0.00,0.00,0.00,0.00),('1','116','719','122867',2446909,'1966','298',415680.23,416094.37,414.14,91110.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','122867',2446910,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122867',2446911,'1968','297',548184.63,548184.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122867',2446912,'1969','297',300300.47,300300.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122867',2446913,'1970','297',462239.58,462239.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122867',2446914,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122867',2446915,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122869',2446944,'1950','297',646729.54,650152.01,3422.47,482568.27,0.00,0.00,0.00,0.00,0.00),('1','116','717','122869',2446945,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122869',2446946,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122869',2446947,'1953','297',892829.60,895991.01,3161.41,445758.81,0.00,0.00,0.00,0.00,0.00),('1','116','717','122869',2446948,'1954','297',571263.36,573093.73,1830.37,258082.17,0.00,0.00,0.00,0.00,0.00),('1','116','717','122869',2446949,'1955','297',560712.12,563225.58,2513.46,354397.86,0.00,0.00,0.00,0.00,0.00),('1','116','717','122869',2446950,'1956','297',586982.35,589213.42,2231.07,314580.87,0.00,0.00,0.00,0.00,0.00),('1','116','717','122869',2446951,'1957','297',926652.67,929815.65,3162.98,445980.18,0.00,0.00,0.00,0.00,0.00),('1','116','719','122869',2446952,'1966','298',416094.37,417394.59,1300.22,286048.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','122869',2446953,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122869',2446954,'1968','297',548184.63,548184.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122869',2446955,'1969','297',300300.47,300300.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122869',2446956,'1970','297',462239.58,462239.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122869',2446957,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122869',2446958,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122926',2448208,'1950','297',650152.01,652096.70,1944.69,274201.29,0.00,0.00,0.00,0.00,0.00),('1','116','717','122926',2448209,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122926',2448210,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122926',2448211,'1953','297',895991.01,898346.69,2355.68,332150.88,0.00,0.00,0.00,0.00,0.00),('1','116','717','122926',2448212,'1954','297',573093.73,575012.37,1918.64,270528.24,0.00,0.00,0.00,0.00,0.00),('1','116','717','122926',2448213,'1955','297',563225.58,563225.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122926',2448214,'1956','297',589213.42,589213.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122926',2448215,'1957','297',929815.65,931431.28,1615.63,227803.83,0.00,0.00,0.00,0.00,0.00),('1','116','719','122926',2448216,'1966','298',417394.59,417542.77,148.18,32599.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','122926',2448217,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122926',2448218,'1968','297',548184.63,549659.15,1474.52,207907.32,0.00,0.00,0.00,0.00,0.00),('1','116','720','122926',2448219,'1969','297',300300.47,300300.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122926',2448220,'1970','297',462239.58,462239.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122926',2448221,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122926',2448222,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122945',2448589,'1950','297',652096.70,654868.05,2771.35,390760.35,0.00,0.00,0.00,0.00,0.00),('1','116','717','122945',2448590,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122945',2448591,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','122945',2448592,'1953','297',898346.69,901511.33,3164.64,446214.24,0.00,0.00,0.00,0.00,0.00),('1','116','717','122945',2448593,'1954','297',575012.37,576973.66,1961.29,276541.89,0.00,0.00,0.00,0.00,0.00),('1','116','717','122945',2448594,'1955','297',563225.58,564591.26,1365.68,192560.88,0.00,0.00,0.00,0.00,0.00),('1','116','717','122945',2448595,'1956','297',589213.42,590062.22,848.80,119680.80,0.00,0.00,0.00,0.00,0.00),('1','116','717','122945',2448596,'1957','297',931431.28,933741.14,2309.86,325690.26,0.00,0.00,0.00,0.00,0.00),('1','116','719','122945',2448597,'1966','298',417542.77,417722.97,180.20,39644.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122945',2448598,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122945',2448599,'1968','297',549659.15,552592.83,2933.68,413648.88,0.00,0.00,0.00,0.00,0.00),('1','116','720','122945',2448600,'1969','297',300300.47,302767.77,2467.30,347889.30,0.00,0.00,0.00,0.00,0.00),('1','116','720','122945',2448601,'1970','297',462239.58,462239.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122945',2448602,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','122945',2448603,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123080',2451624,'1950','297',654868.05,657177.53,2309.48,325636.68,0.00,0.00,0.00,0.00,0.00),('1','116','717','123080',2451625,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123080',2451626,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123080',2451627,'1953','297',901511.33,903903.86,2392.53,337346.73,0.00,0.00,0.00,0.00,0.00),('1','116','717','123080',2451628,'1954','297',576973.66,576973.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123080',2451629,'1955','297',564591.26,565565.07,973.81,137307.21,0.00,0.00,0.00,0.00,0.00),('1','116','717','123080',2451630,'1956','297',590062.22,590062.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123080',2451631,'1957','297',933741.14,935819.22,2078.08,293009.28,0.00,0.00,0.00,0.00,0.00),('1','116','719','123080',2451632,'1966','298',417722.97,418422.97,700.00,154000.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123080',2451633,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123080',2451634,'1968','297',552592.83,554083.20,1490.37,210142.17,0.00,0.00,0.00,0.00,0.00),('1','116','720','123080',2451635,'1969','297',302767.77,304903.01,2135.24,301068.84,0.00,0.00,0.00,0.00,0.00),('1','116','720','123080',2451636,'1970','297',462239.58,462239.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123080',2451637,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123080',2451638,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123083',2451674,'1950','297',657177.53,657923.04,745.51,105116.91,0.00,0.00,0.00,0.00,0.00),('1','116','717','123083',2451675,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123083',2451676,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123083',2451677,'1953','297',903903.86,907003.33,3099.47,437025.27,0.00,0.00,0.00,0.00,0.00),('1','116','717','123083',2451678,'1954','297',576973.66,578356.98,1383.32,195048.12,0.00,0.00,0.00,0.00,0.00),('1','116','717','123083',2451679,'1955','297',565565.07,567671.88,2106.81,297060.21,0.00,0.00,0.00,0.00,0.00),('1','116','717','123083',2451680,'1956','297',590062.22,591460.28,1398.06,197126.46,0.00,0.00,0.00,0.00,0.00),('1','116','717','123083',2451681,'1957','297',935819.22,937093.01,1273.79,179604.39,0.00,0.00,0.00,0.00,0.00),('1','116','719','123083',2451682,'1966','298',418422.97,419827.70,1404.73,309040.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','123083',2451683,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123083',2451684,'1968','297',554083.20,556508.02,2424.82,341899.62,0.00,0.00,0.00,0.00,0.00),('1','116','720','123083',2451685,'1969','297',304903.01,307790.30,2887.29,407107.89,0.00,0.00,0.00,0.00,0.00),('1','116','720','123083',2451686,'1970','297',462239.58,462239.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123083',2451687,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123083',2451688,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123206',2454214,'1950','297',657923.04,660169.46,2236.42,315335.22,0.00,0.00,10.00,0.00,0.00),('1','116','717','123206',2454215,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123206',2454216,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123206',2454217,'1953','297',907003.33,909130.19,2106.86,297067.26,0.00,0.00,20.00,0.00,0.00),('1','116','717','123206',2454218,'1954','297',578356.98,580222.37,1845.39,260199.99,0.00,0.00,20.00,0.00,0.00),('1','116','717','123206',2454219,'1955','297',567671.88,568628.85,946.97,133522.77,0.00,0.00,10.00,0.00,0.00),('1','116','717','123206',2454220,'1956','297',591460.28,591556.96,86.68,12221.88,0.00,0.00,10.00,0.00,0.00),('1','116','717','123206',2454221,'1957','297',937093.01,939188.58,2075.57,292655.37,0.00,0.00,20.00,0.00,0.00),('1','116','719','123206',2454222,'1966','298',419827.70,420517.60,669.90,147378.00,0.00,0.00,20.00,0.00,0.00),('1','116','720','123206',2454223,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123206',2454224,'1968','297',556508.02,557725.06,1197.04,168782.64,0.00,0.00,20.00,0.00,0.00),('1','116','720','123206',2454225,'1969','297',307790.30,308700.47,890.17,125513.97,0.00,0.00,20.00,0.00,0.00),('1','116','720','123206',2454226,'1970','297',462239.58,462239.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123206',2454227,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123206',2454228,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123463',2459571,'1950','297',660169.46,663299.51,3130.05,441337.05,0.00,0.00,0.00,0.00,0.00),('1','116','717','123463',2459572,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123463',2459573,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123463',2459574,'1953','297',909130.19,912624.87,3494.68,492749.88,0.00,0.00,0.00,0.00,0.00),('1','116','717','123463',2459575,'1954','297',580222.37,582498.89,2276.52,320989.32,0.00,0.00,0.00,0.00,0.00),('1','116','717','123463',2459576,'1955','297',568628.85,571329.27,2700.42,380759.22,0.00,0.00,0.00,0.00,0.00),('1','116','717','123463',2459577,'1956','297',591556.96,593787.33,2230.37,314482.17,0.00,0.00,0.00,0.00,0.00),('1','116','717','123463',2459578,'1957','297',939188.58,941732.98,2544.40,358760.40,0.00,0.00,0.00,0.00,0.00),('1','116','719','123463',2459579,'1966','298',420517.60,420736.98,219.38,48263.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','123463',2459580,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123463',2459581,'1968','297',557725.06,557725.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123463',2459582,'1969','297',308700.47,308700.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123463',2459583,'1970','297',462239.58,462239.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123463',2459584,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123463',2459585,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123464',2459586,'1950','297',663299.51,665720.68,2421.17,341384.97,0.00,0.00,0.00,0.00,0.00),('1','116','717','123464',2459587,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123464',2459588,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123464',2459589,'1953','297',912624.87,914905.73,2280.86,321601.26,0.00,0.00,0.00,0.00,0.00),('1','116','717','123464',2459590,'1954','297',582498.89,584622.19,2123.30,299385.30,0.00,0.00,0.00,0.00,0.00),('1','116','717','123464',2459591,'1955','297',571329.27,573069.17,1739.90,245325.90,0.00,0.00,0.00,0.00,0.00),('1','116','717','123464',2459592,'1956','297',593787.33,593872.25,84.92,11973.72,0.00,0.00,0.00,0.00,0.00),('1','116','717','123464',2459593,'1957','297',941732.98,944708.73,2975.75,419580.75,0.00,0.00,0.00,0.00,0.00),('1','116','719','123464',2459594,'1966','298',420736.98,421319.19,582.21,128086.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','123464',2459595,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123464',2459596,'1968','297',557725.06,557725.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123464',2459597,'1969','297',308700.47,308700.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123464',2459598,'1970','297',462239.58,462239.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123464',2459599,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123464',2459600,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123466',2459639,'1950','297',665720.68,668933.57,3192.62,450159.42,0.00,0.00,20.27,0.00,0.00),('1','116','717','123466',2459640,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123466',2459641,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123466',2459642,'1953','297',914905.73,918308.40,3382.42,476921.22,0.00,0.00,20.25,0.00,0.00),('1','116','717','123466',2459643,'1954','297',584622.19,587136.16,2503.79,353034.39,0.00,0.00,10.18,0.00,0.00),('1','116','717','123466',2459644,'1955','297',573069.17,575590.40,2511.00,354051.00,0.00,0.00,10.23,0.00,0.00),('1','116','717','123466',2459645,'1956','297',593872.25,597100.42,3222.92,454431.72,0.00,0.00,5.25,0.00,0.00),('1','116','717','123466',2459646,'1957','297',944708.73,947150.68,2441.95,344314.95,0.00,0.00,0.00,0.00,0.00),('1','116','719','123466',2459647,'1966','298',421319.19,422619.19,1300.00,286000.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123466',2459648,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123466',2459649,'1968','297',557725.06,557725.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123466',2459650,'1969','297',308700.47,308700.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123466',2459651,'1970','297',462239.58,464405.18,2165.60,305349.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','123466',2459652,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123466',2459653,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123472',2459767,'1950','297',668933.57,671470.81,2537.24,357750.84,0.00,0.00,0.00,0.00,0.00),('1','116','717','123472',2459768,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123472',2459769,'1952','297',539581.21,539581.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123472',2459770,'1953','297',918308.40,921144.50,2836.10,399890.10,0.00,0.00,0.00,0.00,0.00),('1','116','717','123472',2459771,'1954','297',587136.16,587136.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123472',2459772,'1955','297',575590.40,577999.90,2409.50,339739.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','123472',2459773,'1956','297',597100.42,598579.66,1479.24,208572.84,0.00,0.00,0.00,0.00,0.00),('1','116','717','123472',2459774,'1957','297',947150.68,949138.03,1987.35,280216.35,0.00,0.00,0.00,0.00,0.00),('1','116','719','123472',2459775,'1966','298',422619.19,422619.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123472',2459776,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123472',2459777,'1968','297',557725.06,557725.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123472',2459778,'1969','297',308700.47,308700.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123472',2459779,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123472',2459780,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123472',2459781,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123473',2459782,'1950','297',671470.81,674562.91,3092.10,435986.10,0.00,0.00,0.00,0.00,0.00),('1','116','717','123473',2459783,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123473',2459784,'1952','297',539581.21,539664.44,73.23,10325.43,0.00,0.00,10.00,0.00,0.00),('1','116','717','123473',2459785,'1953','297',921144.50,923738.40,2593.90,365739.90,0.00,0.00,0.00,0.00,0.00),('1','116','717','123473',2459786,'1954','297',587136.16,588923.20,1787.04,251972.64,0.00,0.00,0.00,0.00,0.00),('1','116','717','123473',2459787,'1955','297',577999.90,577999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123473',2459788,'1956','297',598579.66,598579.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123473',2459789,'1957','297',949138.03,951730.36,2592.33,365518.53,0.00,0.00,0.00,0.00,0.00),('1','116','719','123473',2459790,'1966','298',422619.19,422761.09,141.90,31218.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123473',2459791,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123473',2459792,'1968','297',557725.06,559528.07,1803.01,254224.41,0.00,0.00,0.00,0.00,0.00),('1','116','720','123473',2459793,'1969','297',308700.47,311015.39,2314.92,326403.72,0.00,0.00,0.00,0.00,0.00),('1','116','720','123473',2459794,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123473',2459795,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123473',2459796,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123476',2459869,'1950','297',674562.91,674562.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123476',2459870,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123476',2459871,'1952','297',539664.44,539664.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123476',2459872,'1953','297',923738.40,925828.20,2089.80,294661.80,0.00,0.00,0.00,0.00,0.00),('1','116','717','123476',2459873,'1954','297',588923.20,588923.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123476',2459874,'1955','297',577999.90,578507.15,507.25,71522.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','123476',2459875,'1956','297',598579.66,598579.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123476',2459876,'1957','297',951730.36,954484.48,2754.12,388330.92,0.00,0.00,0.00,0.00,0.00),('1','116','719','123476',2459877,'1966','298',422761.09,423041.98,280.89,61795.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','123476',2459878,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123476',2459879,'1968','297',559528.07,561098.84,1570.77,221478.57,0.00,0.00,0.00,0.00,0.00),('1','116','720','123476',2459880,'1969','297',311015.39,313297.68,2282.29,321802.89,0.00,0.00,0.00,0.00,0.00),('1','116','720','123476',2459881,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123476',2459882,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123476',2459883,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123478',2459900,'1950','297',674562.91,677371.07,2808.16,395950.56,0.00,0.00,0.00,0.00,0.00),('1','116','717','123478',2459901,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123478',2459902,'1952','297',539664.44,539664.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123478',2459903,'1953','297',925828.20,925898.48,70.28,9909.48,0.00,0.00,0.00,0.00,0.00),('1','116','717','123478',2459904,'1954','297',588923.20,590452.38,1529.18,215614.38,0.00,0.00,0.00,0.00,0.00),('1','116','717','123478',2459905,'1955','297',578507.15,578735.97,228.82,32263.62,0.00,0.00,0.00,0.00,0.00),('1','116','717','123478',2459906,'1956','297',598579.66,600044.65,1464.99,206563.59,0.00,0.00,0.00,0.00,0.00),('1','116','717','123478',2459907,'1957','297',954484.48,956506.67,2022.19,285128.79,0.00,0.00,0.00,0.00,0.00),('1','116','719','123478',2459908,'1966','298',423041.98,424226.09,1184.11,260504.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','123478',2459909,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123478',2459910,'1968','297',561098.84,562209.29,1110.45,156573.45,0.00,0.00,0.00,0.00,0.00),('1','116','720','123478',2459911,'1969','297',313297.68,315778.91,2481.23,349853.43,0.00,0.00,0.00,0.00,0.00),('1','116','720','123478',2459912,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123478',2459913,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123478',2459914,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123539',2461139,'1950','297',677371.07,679384.32,2013.25,283868.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','123539',2461140,'1951','297',624622.82,624622.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123539',2461141,'1952','297',539664.44,539664.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123539',2461142,'1953','297',925898.48,928206.89,2308.41,325485.81,0.00,0.00,0.00,0.00,0.00),('1','116','717','123539',2461143,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123539',2461144,'1955','297',578735.97,578735.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123539',2461145,'1956','297',600044.65,600242.78,198.13,27936.33,0.00,0.00,0.00,0.00,0.00),('1','116','717','123539',2461146,'1957','297',956506.67,958735.36,2228.69,314245.29,0.00,0.00,0.00,0.00,0.00),('1','116','719','123539',2461147,'1966','298',424226.09,424681.25,455.16,100135.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','123539',2461148,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123539',2461149,'1968','297',562209.29,563360.70,1151.41,162348.81,0.00,0.00,0.00,0.00,0.00),('1','116','720','123539',2461150,'1969','297',315778.91,317420.63,1641.72,231482.52,0.00,0.00,0.00,0.00,0.00),('1','116','720','123539',2461151,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123539',2461152,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123539',2461153,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123606',2462447,'1950','297',679384.32,683052.77,3668.45,517251.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','123606',2462448,'1951','297',624622.82,624772.48,149.66,21102.06,0.00,0.00,0.00,0.00,0.00),('1','116','717','123606',2462449,'1952','297',539664.44,539664.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123606',2462450,'1953','297',928206.89,931931.03,3724.14,525103.74,0.00,0.00,0.00,0.00,0.00),('1','116','717','123606',2462451,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123606',2462452,'1955','297',578735.97,582139.14,3403.17,479846.97,0.00,0.00,0.00,0.00,0.00),('1','116','717','123606',2462453,'1956','297',600242.78,601295.00,1052.22,148363.02,0.00,0.00,0.00,0.00,0.00),('1','116','717','123606',2462454,'1957','297',958735.36,961762.27,3026.91,426794.31,0.00,0.00,0.00,0.00,0.00),('1','116','719','123606',2462455,'1966','298',424681.25,424882.88,201.63,44358.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','123606',2462456,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123606',2462457,'1968','297',563360.70,563360.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123606',2462458,'1969','297',317420.63,317420.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123606',2462459,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123606',2462460,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123606',2462461,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123694',2464491,'1950','297',683052.77,684828.66,1775.89,250400.49,0.00,0.00,0.00,0.00,0.00),('1','116','717','123694',2464492,'1951','297',624772.48,625357.42,584.94,82476.54,0.00,0.00,0.00,0.00,0.00),('1','116','717','123694',2464493,'1952','297',539664.44,540189.45,525.01,74026.41,0.00,0.00,0.00,0.00,0.00),('1','116','717','123694',2464494,'1953','297',931931.03,933832.06,1901.03,268045.23,0.00,0.00,0.00,0.00,0.00),('1','116','717','123694',2464495,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123694',2464496,'1955','297',582139.14,584275.80,2136.66,301269.06,0.00,0.00,0.00,0.00,0.00),('1','116','717','123694',2464497,'1956','297',601295.00,603049.28,1754.28,247353.48,0.00,0.00,0.00,0.00,0.00),('1','116','717','123694',2464498,'1957','297',961762.27,963231.68,1469.41,207186.81,0.00,0.00,0.00,0.00,0.00),('1','116','719','123694',2464499,'1966','298',424882.88,425308.53,425.65,93643.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123694',2464500,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123694',2464501,'1968','297',563360.70,563360.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123694',2464502,'1969','297',317420.63,317420.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123694',2464503,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123694',2464504,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123694',2464505,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123731',2465207,'1950','297',684828.66,684922.31,93.65,13204.65,0.00,0.00,0.00,0.00,0.00),('1','116','717','123731',2465208,'1951','297',625357.42,628317.45,2960.03,417364.23,0.00,0.00,0.00,0.00,0.00),('1','116','717','123731',2465209,'1952','297',540189.45,543638.75,3449.30,486351.30,0.00,0.00,0.00,0.00,0.00),('1','116','717','123731',2465210,'1953','297',933832.06,934900.12,1047.56,147705.96,0.00,0.00,20.50,0.00,0.00),('1','116','717','123731',2465211,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123731',2465212,'1955','297',584275.80,587879.32,3603.52,508096.32,0.00,0.00,0.00,0.00,0.00),('1','116','717','123731',2465213,'1956','297',603049.28,603094.67,45.39,6399.99,0.00,0.00,0.00,0.00,0.00),('1','116','717','123731',2465214,'1957','297',963231.68,966738.39,3506.71,494446.11,0.00,0.00,0.00,0.00,0.00),('1','116','719','123731',2465215,'1966','298',425308.53,427785.07,2476.54,544838.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','123731',2465216,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123731',2465217,'1968','297',563360.70,563360.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123731',2465218,'1969','297',317420.63,317420.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123731',2465219,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123731',2465220,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123731',2465221,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123898',2468535,'1950','297',684922.31,686875.36,1953.05,275380.05,0.00,0.00,0.00,0.00,0.00),('1','116','717','123898',2468536,'1951','297',628317.45,628317.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123898',2468537,'1952','297',543638.75,543638.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123898',2468538,'1953','297',934900.12,937197.63,2297.51,323948.91,0.00,0.00,0.00,0.00,0.00),('1','116','717','123898',2468539,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123898',2468540,'1955','297',587879.32,589572.20,1692.88,238696.08,0.00,0.00,0.00,0.00,0.00),('1','116','717','123898',2468541,'1956','297',603094.67,603094.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123898',2468542,'1957','297',966738.39,968607.24,1868.85,263507.85,0.00,0.00,0.00,0.00,0.00),('1','116','719','123898',2468543,'1966','298',427785.07,429039.17,1254.10,275902.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123898',2468544,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123898',2468545,'1968','297',563360.70,564438.06,1077.36,151907.76,0.00,0.00,0.00,0.00,0.00),('1','116','720','123898',2468546,'1969','297',317420.63,318917.59,1496.96,211071.36,0.00,0.00,0.00,0.00,0.00),('1','116','720','123898',2468547,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123898',2468548,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123898',2468549,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123900',2468574,'1950','297',686875.36,687715.14,839.78,118408.98,0.00,0.00,0.00,0.00,0.00),('1','116','717','123900',2468575,'1951','297',628317.45,630738.85,2421.40,341417.40,0.00,0.00,0.00,0.00,0.00),('1','116','717','123900',2468576,'1952','297',543638.75,547254.39,3615.64,509805.24,0.00,0.00,0.00,0.00,0.00),('1','116','717','123900',2468577,'1953','297',937197.63,937403.16,205.53,28979.73,0.00,0.00,0.00,0.00,0.00),('1','116','717','123900',2468578,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','123900',2468579,'1955','297',589572.20,592714.44,3142.24,443055.84,0.00,0.00,0.00,0.00,0.00),('1','116','717','123900',2468580,'1956','297',603094.67,605150.80,2056.13,289914.33,0.00,0.00,0.00,0.00,0.00),('1','116','717','123900',2468581,'1957','297',968607.24,968607.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','123900',2468582,'1966','298',429039.17,429978.90,939.73,206740.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','123900',2468583,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123900',2468584,'1968','297',564438.06,566856.68,2418.62,341025.42,0.00,0.00,0.00,0.00,0.00),('1','116','720','123900',2468585,'1969','297',318917.59,322202.71,3285.12,463201.92,0.00,0.00,0.00,0.00,0.00),('1','116','720','123900',2468586,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123900',2468587,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','123900',2468588,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124049',2471478,'1950','297',687715.14,689932.82,2217.68,312692.88,0.00,0.00,0.00,0.00,0.00),('1','116','717','124049',2471479,'1951','297',630738.85,630738.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124049',2471480,'1952','297',547254.39,549280.50,2026.11,285681.51,0.00,0.00,0.00,0.00,0.00),('1','116','717','124049',2471481,'1953','297',937403.16,937459.90,56.74,8000.34,0.00,0.00,0.00,0.00,0.00),('1','116','717','124049',2471482,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124049',2471483,'1955','297',592714.44,594171.13,1456.69,205393.29,0.00,0.00,0.00,0.00,0.00),('1','116','717','124049',2471484,'1956','297',605150.80,605150.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124049',2471485,'1957','297',968607.24,970327.16,1719.92,242508.72,0.00,0.00,0.00,0.00,0.00),('1','116','719','124049',2471486,'1966','298',429978.90,430512.86,533.96,117471.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','124049',2471487,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124049',2471488,'1968','297',566856.68,568132.74,1276.06,179924.46,0.00,0.00,0.00,0.00,0.00),('1','116','720','124049',2471489,'1969','297',322202.71,323784.62,1571.91,221639.31,0.00,0.00,10.00,0.00,0.00),('1','116','720','124049',2471490,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124049',2471491,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124049',2471492,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124056',2471590,'1950','297',689932.82,693008.78,3065.96,432300.36,0.00,0.00,10.00,0.00,0.00),('1','116','717','124056',2471591,'1951','297',630738.85,630738.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124056',2471592,'1952','297',549280.50,553079.52,3779.02,532841.82,0.00,0.00,20.00,0.00,0.00),('1','116','717','124056',2471593,'1953','297',937459.90,937575.85,115.95,16348.95,0.00,0.00,0.00,0.00,0.00),('1','116','717','124056',2471594,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124056',2471595,'1955','297',594171.13,596532.36,2351.23,331523.43,0.00,0.00,10.00,0.00,0.00),('1','116','717','124056',2471596,'1956','297',605150.80,608478.29,3307.49,466356.09,0.00,0.00,20.00,0.00,0.00),('1','116','717','124056',2471597,'1957','297',970327.16,970328.58,1.42,200.22,0.00,0.00,0.00,0.00,0.00),('1','116','719','124056',2471598,'1966','298',430512.86,430762.02,249.16,54815.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','124056',2471599,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124056',2471600,'1968','297',568132.74,568476.03,343.29,48403.89,0.00,0.00,0.00,0.00,0.00),('1','116','720','124056',2471601,'1969','297',323784.62,327190.60,3395.98,478833.18,0.00,0.00,10.00,0.00,0.00),('1','116','720','124056',2471602,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124056',2471603,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124056',2471604,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124200',2474960,'1950','297',693008.78,693008.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124200',2474961,'1951','297',630738.85,632880.14,2141.29,301921.89,0.00,0.00,0.00,0.00,0.00),('1','116','717','124200',2474962,'1952','297',553079.52,553079.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124200',2474963,'1953','297',937575.85,937575.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124200',2474964,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124200',2474965,'1955','297',596532.36,599137.08,2604.72,367265.52,0.00,0.00,0.00,0.00,0.00),('1','116','717','124200',2474966,'1956','297',608478.29,611002.33,2524.04,355889.64,0.00,0.00,0.00,0.00,0.00),('1','116','717','124200',2474967,'1957','297',970328.58,970328.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','124200',2474968,'1966','298',430762.02,431125.33,363.31,79928.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','124200',2474969,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124200',2474970,'1968','297',568476.03,571014.69,2538.66,357951.06,0.00,0.00,0.00,0.00,0.00),('1','116','720','124200',2474971,'1969','297',327190.60,329358.91,2168.31,305731.71,0.00,0.00,0.00,0.00,0.00),('1','116','720','124200',2474972,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124200',2474973,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124200',2474974,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124244',2475880,'1950','297',693008.78,696085.55,3076.77,433824.57,0.00,0.00,0.00,0.00,0.00),('1','116','717','124244',2475881,'1951','297',632880.14,635304.11,2423.97,341779.77,0.00,0.00,0.00,0.00,0.00),('1','116','717','124244',2475882,'1952','297',553079.52,556968.69,3889.17,548372.97,0.00,0.00,0.00,0.00,0.00),('1','116','717','124244',2475883,'1953','297',937575.85,937654.38,78.53,11072.73,0.00,0.00,0.00,0.00,0.00),('1','116','717','124244',2475884,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124244',2475885,'1955','297',599137.08,602363.03,3225.95,454858.95,0.00,0.00,0.00,0.00,0.00),('1','116','717','124244',2475886,'1956','297',611002.33,613930.06,2927.73,412809.93,0.00,0.00,0.00,0.00,0.00),('1','116','717','124244',2475887,'1957','297',970328.58,972110.38,1781.80,251233.80,0.00,0.00,0.00,0.00,0.00),('1','116','719','124244',2475888,'1966','298',431125.33,432668.35,1543.02,339464.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','124244',2475889,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124244',2475890,'1968','297',571014.69,571259.87,245.18,34570.38,0.00,0.00,0.00,0.00,0.00),('1','116','720','124244',2475891,'1969','297',329358.91,329691.81,332.90,46938.90,0.00,0.00,0.00,0.00,0.00),('1','116','720','124244',2475892,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124244',2475893,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124244',2475894,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124283',2476665,'1950','297',696085.55,698229.82,2144.27,302342.07,0.00,0.00,0.00,0.00,0.00),('1','116','717','124283',2476666,'1951','297',635304.11,635304.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124283',2476667,'1952','297',556968.69,558831.15,1862.46,262606.86,0.00,0.00,0.00,0.00,0.00),('1','116','717','124283',2476668,'1953','297',937654.38,939621.74,1967.36,277397.76,0.00,0.00,0.00,0.00,0.00),('1','116','717','124283',2476669,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124283',2476670,'1955','297',602363.03,604407.60,2044.57,288284.37,0.00,0.00,0.00,0.00,0.00),('1','116','717','124283',2476671,'1956','297',613930.06,615450.65,1520.59,214403.19,0.00,0.00,0.00,0.00,0.00),('1','116','717','124283',2476672,'1957','297',972110.38,973885.08,1774.70,250232.70,0.00,0.00,0.00,0.00,0.00),('1','116','719','124283',2476673,'1966','298',432668.35,433033.83,365.48,80405.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','124283',2476674,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124283',2476675,'1968','297',571259.87,571259.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124283',2476676,'1969','297',329691.81,329691.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124283',2476677,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124283',2476678,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124283',2476679,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124321',2477390,'1950','297',698229.82,698803.16,573.34,80840.94,0.00,0.00,0.00,0.00,0.00),('1','116','717','124321',2477391,'1951','297',635304.11,637358.12,2054.01,289615.41,0.00,0.00,0.00,0.00,0.00),('1','116','717','124321',2477392,'1952','297',558831.15,561040.22,2209.07,311478.87,0.00,0.00,0.00,0.00,0.00),('1','116','717','124321',2477393,'1953','297',939621.74,941262.75,1641.01,231382.41,0.00,0.00,0.00,0.00,0.00),('1','116','717','124321',2477394,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124321',2477395,'1955','297',604407.60,606467.76,2060.16,290482.56,0.00,0.00,0.00,0.00,0.00),('1','116','717','124321',2477396,'1956','297',615450.65,617753.50,2302.85,324701.85,0.00,0.00,0.00,0.00,0.00),('1','116','717','124321',2477397,'1957','297',973885.08,976290.48,2405.40,339161.40,0.00,0.00,0.00,0.00,0.00),('1','116','719','124321',2477398,'1966','298',433033.83,433575.67,541.84,119204.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','124321',2477399,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124321',2477400,'1968','297',571259.87,571259.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124321',2477401,'1969','297',329691.81,329691.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124321',2477402,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124321',2477403,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124321',2477404,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124468',2480436,'1950','297',698803.16,700527.11,1723.95,243076.95,0.00,0.00,0.00,0.00,0.00),('1','116','717','124468',2480437,'1951','297',637358.12,638952.27,1594.15,224775.15,0.00,0.00,0.00,0.00,0.00),('1','116','717','124468',2480438,'1952','297',561040.22,561040.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124468',2480439,'1953','297',941262.75,943035.24,1772.49,249921.09,0.00,0.00,0.00,0.00,0.00),('1','116','717','124468',2480440,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124468',2480441,'1955','297',606467.76,607811.64,1343.88,189487.08,0.00,0.00,0.00,0.00,0.00),('1','116','717','124468',2480442,'1956','297',617753.50,619237.60,1484.10,209258.10,0.00,0.00,0.00,0.00,0.00),('1','116','717','124468',2480443,'1957','297',976290.48,977699.25,1408.77,198636.57,0.00,0.00,0.00,0.00,0.00),('1','116','719','124468',2480444,'1966','298',433575.67,433844.59,268.92,59162.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','124468',2480445,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124468',2480446,'1968','297',571259.87,571259.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124468',2480447,'1969','297',329691.81,329691.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124468',2480448,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124468',2480449,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124468',2480450,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124469',2480451,'1950','297',700527.11,701690.15,1163.04,163988.64,0.00,0.00,0.00,0.00,0.00),('1','116','717','124469',2480452,'1951','297',638952.27,640618.28,1666.01,234907.41,0.00,0.00,0.00,0.00,0.00),('1','116','717','124469',2480453,'1952','297',561040.22,563515.07,2474.85,348953.85,0.00,0.00,0.00,0.00,0.00),('1','116','717','124469',2480454,'1953','297',943035.24,943035.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124469',2480455,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124469',2480456,'1955','297',607811.64,611901.57,4089.93,576680.13,0.00,0.00,0.00,0.00,0.00),('1','116','717','124469',2480457,'1956','297',619237.60,619620.72,383.12,54019.92,0.00,0.00,0.00,0.00,0.00),('1','116','717','124469',2480458,'1957','297',977699.25,980314.61,2615.36,368765.76,0.00,0.00,0.00,0.00,0.00),('1','116','719','124469',2480459,'1966','298',433844.59,434274.64,430.05,94611.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124469',2480460,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124469',2480461,'1968','297',571259.87,571259.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124469',2480462,'1969','297',329691.81,329691.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124469',2480463,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124469',2480464,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124469',2480465,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124534',2481857,'1950','297',701690.15,701690.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124534',2481858,'1951','297',640618.28,643331.75,2713.47,382599.27,0.00,0.00,0.00,0.00,0.00),('1','116','717','124534',2481859,'1952','297',563515.07,565662.88,2147.81,302841.21,0.00,0.00,0.00,0.00,0.00),('1','116','717','124534',2481860,'1953','297',943035.24,943035.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124534',2481861,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124534',2481862,'1955','297',611901.57,613860.84,1959.27,276257.07,0.00,0.00,0.00,0.00,0.00),('1','116','717','124534',2481863,'1956','297',619620.72,621188.32,1567.60,221031.60,0.00,0.00,0.00,0.00,0.00),('1','116','717','124534',2481864,'1957','297',980314.61,981913.58,1598.97,225454.77,0.00,0.00,0.00,0.00,0.00),('1','116','719','124534',2481865,'1966','298',434274.64,434529.64,255.00,56100.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124534',2481866,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124534',2481867,'1968','297',571259.87,571259.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124534',2481868,'1969','297',329691.81,329691.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124534',2481869,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124534',2481870,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124534',2481871,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124551',2482137,'1950','297',701690.15,703249.50,1559.35,219868.35,0.00,0.00,0.00,0.00,0.00),('1','116','717','124551',2482138,'1951','297',643331.75,645723.86,2392.11,337287.51,0.00,0.00,0.00,0.00,0.00),('1','116','717','124551',2482139,'1952','297',565662.88,568560.94,2898.06,408626.46,0.00,0.00,0.00,0.00,0.00),('1','116','717','124551',2482140,'1953','297',943035.24,944225.67,1190.43,167850.63,0.00,0.00,0.00,0.00,0.00),('1','116','717','124551',2482141,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124551',2482142,'1955','297',613860.84,615633.74,1772.90,249978.90,0.00,0.00,0.00,0.00,0.00),('1','116','717','124551',2482143,'1956','297',621188.32,623302.56,2114.24,298107.84,0.00,0.00,0.00,0.00,0.00),('1','116','717','124551',2482144,'1957','297',981913.58,983011.42,1097.84,154795.44,0.00,0.00,0.00,0.00,0.00),('1','116','719','124551',2482145,'1966','298',434529.64,436198.39,1668.75,367125.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124551',2482146,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124551',2482147,'1968','297',571259.87,571740.55,480.68,67775.88,0.00,0.00,0.00,0.00,0.00),('1','116','720','124551',2482148,'1969','297',329691.81,330837.39,1145.58,161526.78,0.00,0.00,0.00,0.00,0.00),('1','116','720','124551',2482149,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124551',2482150,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124551',2482151,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124648',2484179,'1950','297',703249.50,703249.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124648',2484180,'1951','297',645723.86,647294.37,1570.51,221441.91,0.00,0.00,0.00,0.00,0.00),('1','116','717','124648',2484181,'1952','297',568560.94,571307.48,2746.54,387262.14,0.00,0.00,0.00,0.00,0.00),('1','116','717','124648',2484182,'1953','297',944225.67,944225.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124648',2484183,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124648',2484184,'1955','297',615633.74,617709.69,2075.95,292708.95,0.00,0.00,0.00,0.00,0.00),('1','116','717','124648',2484185,'1956','297',623302.56,623357.17,54.61,7700.01,0.00,0.00,0.00,0.00,0.00),('1','116','717','124648',2484186,'1957','297',983011.42,985304.17,2292.75,323277.75,0.00,0.00,0.00,0.00,0.00),('1','116','719','124648',2484187,'1966','298',436198.39,436488.60,290.21,63846.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','124648',2484188,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124648',2484189,'1968','297',571740.55,573559.82,1819.27,256517.07,0.00,0.00,0.00,0.00,0.00),('1','116','720','124648',2484190,'1969','297',330837.39,330837.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124648',2484191,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124648',2484192,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124648',2484193,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124701',2485188,'1950','297',703249.50,703249.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124701',2485189,'1951','297',647294.37,649906.96,2612.59,368375.19,0.00,0.00,0.00,0.00,0.00),('1','116','717','124701',2485190,'1952','297',571307.48,573207.81,1900.33,267946.53,0.00,0.00,0.00,0.00,0.00),('1','116','717','124701',2485191,'1953','297',944225.67,946313.44,2087.77,294375.57,0.00,0.00,0.00,0.00,0.00),('1','116','717','124701',2485192,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124701',2485193,'1955','297',617709.69,620092.97,2383.28,336042.48,0.00,0.00,0.00,0.00,0.00),('1','116','717','124701',2485194,'1956','297',623357.17,623357.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124701',2485195,'1957','297',985304.17,988321.05,3016.88,425380.08,0.00,0.00,0.00,0.00,0.00),('1','116','719','124701',2485196,'1966','298',436488.60,436864.21,375.61,82634.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','124701',2485197,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124701',2485198,'1968','297',573559.82,576007.25,2447.43,345087.63,0.00,0.00,0.00,0.00,0.00),('1','116','720','124701',2485199,'1969','297',330837.39,332929.86,2092.47,295038.27,0.00,0.00,0.00,0.00,0.00),('1','116','720','124701',2485200,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124701',2485201,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124701',2485202,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124781',2486734,'1950','297',703249.50,703249.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124781',2486735,'1951','297',649906.96,650129.79,222.83,31419.03,0.00,0.00,0.00,0.00,0.00),('1','116','717','124781',2486736,'1952','297',573207.81,575403.13,2195.32,309540.12,0.00,0.00,0.00,0.00,0.00),('1','116','717','124781',2486737,'1953','297',946313.44,946775.04,461.60,65085.60,0.00,0.00,0.00,0.00,0.00),('1','116','717','124781',2486738,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124781',2486739,'1955','297',620092.97,621548.74,1455.77,205263.57,0.00,0.00,0.00,0.00,0.00),('1','116','717','124781',2486740,'1956','297',623357.17,623357.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124781',2486741,'1957','297',988321.05,990445.09,2124.04,299489.64,0.00,0.00,0.00,0.00,0.00),('1','116','719','124781',2486742,'1966','298',436864.21,438331.93,1467.72,322898.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','124781',2486743,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124781',2486744,'1968','297',576007.25,577724.10,1716.85,242075.85,0.00,0.00,0.00,0.00,0.00),('1','116','720','124781',2486745,'1969','297',332929.86,334543.45,1613.59,227516.19,0.00,0.00,0.00,0.00,0.00),('1','116','720','124781',2486746,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124781',2486747,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124781',2486748,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124812',2487376,'1950','297',703249.50,704313.69,1064.19,150050.79,0.00,0.00,0.00,0.00,0.00),('1','116','717','124812',2487377,'1951','297',650129.79,652543.98,2414.19,340400.79,0.00,0.00,0.00,0.00,0.00),('1','116','717','124812',2487378,'1952','297',575403.13,578470.16,3067.03,432451.23,0.00,0.00,0.00,0.00,0.00),('1','116','717','124812',2487379,'1953','297',946775.04,946775.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124812',2487380,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124812',2487381,'1955','297',621548.74,623705.51,2156.77,304104.57,0.00,0.00,0.00,0.00,0.00),('1','116','717','124812',2487382,'1956','297',623357.17,625178.26,1821.09,256773.69,0.00,0.00,0.00,0.00,0.00),('1','116','717','124812',2487383,'1957','297',990445.09,991412.87,967.78,136456.98,0.00,0.00,0.00,0.00,0.00),('1','116','719','124812',2487384,'1966','298',438331.93,438596.01,264.08,58097.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','124812',2487385,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124812',2487386,'1968','297',577724.10,579488.31,1764.21,248753.61,0.00,0.00,0.00,0.00,0.00),('1','116','720','124812',2487387,'1969','297',334543.45,336259.95,1716.50,242026.50,0.00,0.00,0.00,0.00,0.00),('1','116','720','124812',2487388,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124812',2487389,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124812',2487390,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124981',2490543,'1950','297',704313.69,704656.87,343.18,48388.38,0.00,0.00,0.00,0.00,0.00),('1','116','717','124981',2490544,'1951','297',652543.98,655177.58,2633.60,371337.60,0.00,0.00,0.00,0.00,0.00),('1','116','717','124981',2490545,'1952','297',578470.16,578470.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124981',2490546,'1953','297',946775.04,948997.10,2222.06,313310.46,0.00,0.00,0.00,0.00,0.00),('1','116','717','124981',2490547,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','124981',2490548,'1955','297',623705.51,625931.96,2226.45,313929.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','124981',2490549,'1956','297',625178.26,626594.86,1416.60,199740.60,0.00,0.00,0.00,0.00,0.00),('1','116','717','124981',2490550,'1957','297',991412.87,993586.60,2173.73,306495.93,0.00,0.00,0.00,0.00,0.00),('1','116','719','124981',2490551,'1966','298',438596.01,440614.69,2018.68,434016.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','124981',2490552,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124981',2490553,'1968','297',579488.31,579488.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124981',2490554,'1969','297',336259.95,336259.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124981',2490555,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124981',2490556,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','124981',2490557,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125299',2496781,'1950','297',704656.87,704656.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125299',2496782,'1951','297',655177.58,657968.45,2790.87,393512.67,0.00,0.00,0.00,0.00,0.00),('1','116','717','125299',2496783,'1952','297',578470.16,581345.65,2875.49,405444.09,0.00,0.00,0.00,0.00,0.00),('1','116','717','125299',2496784,'1953','297',948997.10,948997.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125299',2496785,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125299',2496786,'1955','297',625931.96,627716.69,1784.73,251646.93,0.00,0.00,0.00,0.00,0.00),('1','116','717','125299',2496787,'1956','297',626594.86,626594.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125299',2496788,'1957','297',993586.60,996545.56,2958.96,417213.36,0.00,0.00,0.00,0.00,0.00),('1','116','719','125299',2496789,'1966','298',440614.69,440911.03,296.34,63713.10,0.00,0.00,0.00,0.00,0.00),('1','116','720','125299',2496790,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125299',2496791,'1968','297',579488.31,584179.04,4690.73,661392.93,0.00,0.00,0.00,0.00,0.00),('1','116','720','125299',2496792,'1969','297',336259.95,339540.90,3280.95,462613.95,0.00,0.00,0.00,0.00,0.00),('1','116','720','125299',2496793,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125299',2496794,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125299',2496795,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125302',2496852,'1950','297',704656.87,704656.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125302',2496853,'1951','297',657968.45,658688.72,720.27,101558.07,0.00,0.00,0.00,0.00,0.00),('1','116','717','125302',2496854,'1952','297',581345.65,583396.88,2051.23,289223.43,0.00,0.00,0.00,0.00,0.00),('1','116','717','125302',2496855,'1953','297',948997.10,949093.85,96.75,13641.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','125302',2496856,'1954','297',590452.38,590452.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125302',2496857,'1955','297',627716.69,629797.43,2080.74,293384.34,0.00,0.00,0.00,0.00,0.00),('1','116','717','125302',2496858,'1956','297',626594.86,628938.22,2343.36,330413.76,0.00,0.00,0.00,0.00,0.00),('1','116','717','125302',2496859,'1957','297',996545.56,996545.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','125302',2496860,'1966','298',440911.03,441329.38,418.35,89945.25,0.00,0.00,0.00,0.00,0.00),('1','116','720','125302',2496861,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125302',2496862,'1968','297',584179.04,586306.80,2127.76,300014.16,0.00,0.00,0.00,0.00,0.00),('1','116','720','125302',2496863,'1969','297',339540.90,341666.58,2125.68,299720.88,0.00,0.00,0.00,0.00,0.00),('1','116','720','125302',2496864,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125302',2496865,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125302',2496866,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125349',2497874,'1950','297',704656.87,707745.23,3068.36,432638.76,0.00,0.00,20.00,0.00,0.00),('1','116','717','125349',2497875,'1951','297',658688.72,658953.20,254.48,35881.68,0.00,0.00,10.00,0.00,0.00),('1','116','717','125349',2497876,'1952','297',583396.88,583396.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125349',2497877,'1953','297',949093.85,953447.82,4343.97,612499.77,0.00,0.00,10.00,0.00,0.00),('1','116','717','125349',2497878,'1954','297',590452.38,592850.07,2377.69,335254.29,0.00,0.00,20.00,0.00,0.00),('1','116','717','125349',2497879,'1955','297',629797.43,633384.62,3577.19,504383.79,0.00,0.00,10.00,0.00,0.00),('1','116','717','125349',2497880,'1956','297',628938.22,628938.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125349',2497881,'1957','297',996545.56,999522.15,2956.59,416879.19,0.00,0.00,20.00,0.00,0.00),('1','116','719','125349',2497882,'1966','298',441329.38,441878.67,539.29,115947.35,0.00,0.00,10.00,0.00,0.00),('1','116','720','125349',2497883,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125349',2497884,'1968','297',586306.80,586939.49,622.69,87799.29,0.00,0.00,10.00,0.00,0.00),('1','116','720','125349',2497885,'1969','297',341666.58,345757.11,4070.53,573944.73,0.00,0.00,20.00,0.00,0.00),('1','116','720','125349',2497886,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125349',2497887,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125349',2497888,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125350',2497889,'1950','297',707745.23,710445.74,2700.51,380771.91,0.00,0.00,0.00,0.00,0.00),('1','116','717','125350',2497890,'1951','297',658953.20,658953.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125350',2497891,'1952','297',583396.88,583396.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125350',2497892,'1953','297',953447.82,953476.19,28.37,4000.17,0.00,0.00,0.00,0.00,0.00),('1','116','717','125350',2497893,'1954','297',592850.07,592850.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125350',2497894,'1955','297',633384.62,635058.72,1674.10,236048.10,0.00,0.00,0.00,0.00,0.00),('1','116','717','125350',2497895,'1956','297',628938.22,631440.79,2502.57,352862.37,0.00,0.00,0.00,0.00,0.00),('1','116','717','125350',2497896,'1957','297',999522.15,999522.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','125350',2497897,'1966','298',441878.67,442314.12,435.45,93621.75,0.00,0.00,0.00,0.00,0.00),('1','116','720','125350',2497898,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125350',2497899,'1968','297',586939.49,588550.31,1610.82,227125.62,0.00,0.00,0.00,0.00,0.00),('1','116','720','125350',2497900,'1969','297',345757.11,347489.79,1732.68,244307.88,0.00,0.00,0.00,0.00,0.00),('1','116','720','125350',2497901,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125350',2497902,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125350',2497903,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125351',2497904,'1950','297',710445.74,710708.87,263.13,37101.33,0.00,0.00,0.00,0.00,0.00),('1','116','717','125351',2497905,'1951','297',658953.20,661340.28,2387.08,336578.28,0.00,0.00,0.00,0.00,0.00),('1','116','717','125351',2497906,'1952','297',583396.88,583406.89,10.01,1411.41,0.00,0.00,0.00,0.00,0.00),('1','116','717','125351',2497907,'1953','297',953476.19,955893.44,2417.25,340832.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','125351',2497908,'1954','297',592850.07,592850.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125351',2497909,'1955','297',635058.72,637894.37,2835.65,399826.65,0.00,0.00,0.00,0.00,0.00),('1','116','717','125351',2497910,'1956','297',631440.79,633688.87,2248.08,316979.28,0.00,0.00,0.00,0.00,0.00),('1','116','717','125351',2497911,'1957','297',999522.15,1001937.56,2415.41,340572.81,0.00,0.00,0.00,0.00,0.00),('1','116','719','125351',2497912,'1966','298',442314.12,443514.12,1200.00,258000.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125351',2497913,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125351',2497914,'1968','297',588550.31,588550.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125351',2497915,'1969','297',347489.79,347489.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125351',2497916,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125351',2497917,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125351',2497918,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125353',2497938,'1950','297',710708.87,712236.35,1527.48,215374.68,0.00,0.00,0.00,0.00,0.00),('1','116','717','125353',2497939,'1951','297',661340.28,661340.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125353',2497940,'1952','297',583406.89,583406.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125353',2497941,'1953','297',955893.44,957844.20,1950.76,275057.16,0.00,0.00,0.00,0.00,0.00),('1','116','717','125353',2497942,'1954','297',592850.07,592850.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125353',2497943,'1955','297',637894.37,637894.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125353',2497944,'1956','297',633688.87,633696.02,7.15,1008.15,0.00,0.00,0.00,0.00,0.00),('1','116','717','125353',2497945,'1957','297',1001937.56,1003974.70,2037.14,287236.74,0.00,0.00,0.00,0.00,0.00),('1','116','719','125353',2497946,'1966','298',443514.12,443514.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125353',2497947,'1967','297',106662.74,106662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125353',2497948,'1968','297',588550.31,589706.90,1156.59,163079.19,0.00,0.00,0.00,0.00,0.00),('1','116','720','125353',2497949,'1969','297',347489.79,349043.47,1553.68,219068.88,0.00,0.00,0.00,0.00,0.00),('1','116','720','125353',2497950,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125353',2497951,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125353',2497952,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125356',2497981,'1950','297',712236.35,714336.99,2100.64,296190.24,0.00,0.00,0.00,0.00,0.00),('1','116','717','125356',2497982,'1951','297',661340.28,661340.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125356',2497983,'1952','297',583406.89,585899.70,2492.81,351486.21,0.00,0.00,0.00,0.00,0.00),('1','116','717','125356',2497984,'1953','297',957844.20,957844.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125356',2497985,'1954','297',592850.07,592850.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125356',2497986,'1955','297',637894.37,639966.08,2071.71,292111.11,0.00,0.00,0.00,0.00,0.00),('1','116','717','125356',2497987,'1956','297',633696.02,633696.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125356',2497988,'1957','297',1003974.70,1006710.73,2736.03,385780.23,0.00,0.00,0.00,0.00,0.00),('1','116','719','125356',2497989,'1966','298',443514.12,443801.95,287.83,61883.45,0.00,0.00,0.00,0.00,0.00),('1','116','720','125356',2497990,'1967','297',106662.74,107250.98,588.24,82941.84,0.00,0.00,0.00,0.00,0.00),('1','116','720','125356',2497991,'1968','297',589706.90,589734.54,27.64,3897.24,0.00,0.00,0.00,0.00,0.00),('1','116','720','125356',2497992,'1969','297',349043.47,350615.94,1572.47,221718.27,0.00,0.00,0.00,0.00,0.00),('1','116','720','125356',2497993,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125356',2497994,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125356',2497995,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125493',2500405,'1950','297',714336.99,715858.05,1521.06,214469.46,0.00,0.00,0.00,0.00,0.00),('1','116','717','125493',2500406,'1951','297',661340.28,662911.12,1570.84,221488.44,0.00,0.00,0.00,0.00,0.00),('1','116','717','125493',2500407,'1952','297',585899.70,585899.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125493',2500408,'1953','297',957844.20,959374.15,1529.95,215722.95,0.00,0.00,0.00,0.00,0.00),('1','116','717','125493',2500409,'1954','297',592850.07,594224.60,1374.53,193808.73,0.00,0.00,0.00,0.00,0.00),('1','116','717','125493',2500410,'1955','297',639966.08,639966.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125493',2500411,'1956','297',633696.02,633696.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125493',2500412,'1957','297',1006710.73,1008266.39,1555.66,219348.06,0.00,0.00,0.00,0.00,0.00),('1','116','719','125493',2500413,'1966','298',443801.95,444085.21,283.26,60900.90,0.00,0.00,0.00,0.00,0.00),('1','116','720','125493',2500414,'1967','297',107250.98,107250.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125493',2500415,'1968','297',589734.54,591142.89,1408.35,198577.35,0.00,0.00,0.00,0.00,0.00),('1','116','720','125493',2500416,'1969','297',350615.94,352182.13,1566.19,220832.79,0.00,0.00,0.00,0.00,0.00),('1','116','720','125493',2500417,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125493',2500418,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125493',2500419,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125645',2503266,'1950','297',715858.05,718671.46,2813.41,396690.81,0.00,0.00,0.00,0.00,0.00),('1','116','717','125645',2503267,'1951','297',662911.12,663179.20,268.08,37799.28,0.00,0.00,0.00,0.00,0.00),('1','116','717','125645',2503268,'1952','297',585899.70,585899.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125645',2503269,'1953','297',959374.15,962071.13,2696.98,380274.18,0.00,0.00,0.00,0.00,0.00),('1','116','717','125645',2503270,'1954','297',594224.60,594600.30,375.70,52973.70,0.00,0.00,0.00,0.00,0.00),('1','116','717','125645',2503271,'1955','297',639966.08,642417.70,2451.62,345678.42,0.00,0.00,0.00,0.00,0.00),('1','116','717','125645',2503272,'1956','297',633696.02,636468.40,2772.38,390905.58,0.00,0.00,0.00,0.00,0.00),('1','116','717','125645',2503273,'1957','297',1008266.39,1008524.90,258.51,36449.91,0.00,0.00,0.00,0.00,0.00),('1','116','719','125645',2503274,'1966','298',444085.21,444766.55,681.34,146488.10,0.00,0.00,0.00,0.00,0.00),('1','116','720','125645',2503275,'1967','297',107250.98,107250.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125645',2503276,'1968','297',591142.89,593006.73,1863.84,262801.44,0.00,0.00,0.00,0.00,0.00),('1','116','720','125645',2503277,'1969','297',352182.13,354797.39,2615.26,368751.66,0.00,0.00,0.00,0.00,0.00),('1','116','720','125645',2503278,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125645',2503279,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125645',2503280,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125648',2503310,'1950','297',718671.46,718671.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125648',2503311,'1951','297',663179.20,665405.95,2226.75,313971.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','125648',2503312,'1952','297',585899.70,588003.98,2104.28,296703.48,0.00,0.00,0.00,0.00,0.00),('1','116','717','125648',2503313,'1953','297',962071.13,962071.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125648',2503314,'1954','297',594600.30,596401.73,1791.26,252567.66,0.00,0.00,10.17,0.00,0.00),('1','116','717','125648',2503315,'1955','297',642417.70,642417.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125648',2503316,'1956','297',636468.40,638342.55,1874.15,264255.15,0.00,0.00,0.00,0.00,0.00),('1','116','717','125648',2503317,'1957','297',1008524.90,1008524.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','125648',2503318,'1966','298',444766.55,445106.98,340.43,73192.45,0.00,0.00,0.00,0.00,0.00),('1','116','720','125648',2503319,'1967','297',107250.98,108420.47,1169.49,164898.09,0.00,0.00,0.00,0.00,0.00),('1','116','720','125648',2503320,'1968','297',593006.73,593006.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125648',2503321,'1969','297',354797.39,355917.98,1110.40,156566.40,0.00,0.00,10.19,0.00,0.00),('1','116','720','125648',2503322,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125648',2503323,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125648',2503324,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125656',2503465,'1950','297',718671.46,719098.88,427.42,60266.22,0.00,0.00,0.00,0.00,0.00),('1','116','717','125656',2503466,'1951','297',665405.95,667817.40,2411.45,340014.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','125656',2503467,'1952','297',588003.98,591639.29,3635.31,512578.71,0.00,0.00,0.00,0.00,0.00),('1','116','717','125656',2503468,'1953','297',962071.13,962071.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125656',2503469,'1954','297',596401.73,596869.25,467.52,65920.32,0.00,0.00,0.00,0.00,0.00),('1','116','717','125656',2503470,'1955','297',642417.70,644954.15,2536.45,357639.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','125656',2503471,'1956','297',638342.55,641052.62,2710.07,382119.87,0.00,0.00,0.00,0.00,0.00),('1','116','717','125656',2503472,'1957','297',1008524.90,1009635.51,1110.61,156596.01,0.00,0.00,0.00,0.00,0.00),('1','116','719','125656',2503473,'1966','298',445106.98,446756.24,1649.26,354590.90,0.00,0.00,0.00,0.00,0.00),('1','116','720','125656',2503474,'1967','297',108420.47,108420.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125656',2503475,'1968','297',593006.73,593442.77,436.04,61481.64,0.00,0.00,0.00,0.00,0.00),('1','116','720','125656',2503476,'1969','297',355917.98,357531.59,1613.61,227519.01,0.00,0.00,0.00,0.00,0.00),('1','116','720','125656',2503477,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125656',2503478,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125656',2503479,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125811',2506951,'1950','297',719098.88,719246.00,147.12,20743.92,0.00,0.00,0.00,0.00,0.00),('1','116','717','125811',2506952,'1951','297',667817.40,668188.04,370.64,52260.24,0.00,0.00,0.00,0.00,0.00),('1','116','717','125811',2506953,'1952','297',591639.29,592827.31,1188.02,167510.82,0.00,0.00,0.00,0.00,0.00),('1','116','717','125811',2506954,'1953','297',962071.13,964109.24,2038.11,287373.51,0.00,0.00,0.00,0.00,0.00),('1','116','717','125811',2506955,'1954','297',596869.25,598519.63,1650.38,232703.58,0.00,0.00,0.00,0.00,0.00),('1','116','717','125811',2506956,'1955','297',644954.15,644954.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125811',2506957,'1956','297',641052.62,641052.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125811',2506958,'1957','297',1009635.51,1011874.72,2239.21,315728.61,0.00,0.00,0.00,0.00,0.00),('1','116','719','125811',2506959,'1966','298',446756.24,448397.63,1641.39,352898.85,0.00,0.00,0.00,0.00,0.00),('1','116','720','125811',2506960,'1967','297',108420.47,108420.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125811',2506961,'1968','297',593442.77,595036.62,1593.85,224732.85,0.00,0.00,0.00,0.00,0.00),('1','116','720','125811',2506962,'1969','297',357531.59,359298.82,1767.23,249179.43,0.00,0.00,0.00,0.00,0.00),('1','116','720','125811',2506963,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125811',2506964,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125811',2506965,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125819',2507066,'1950','297',719246.00,722076.65,2830.65,399121.65,0.00,0.00,0.00,0.00,0.00),('1','116','717','125819',2507067,'1951','297',668188.04,668188.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125819',2507068,'1952','297',592827.31,595607.49,2780.18,392005.38,0.00,0.00,0.00,0.00,0.00),('1','116','717','125819',2507069,'1953','297',964109.24,964109.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125819',2507070,'1954','297',598519.63,598519.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125819',2507071,'1955','297',644954.15,647104.39,2150.24,303183.84,0.00,0.00,0.00,0.00,0.00),('1','116','717','125819',2507072,'1956','297',641052.62,643372.98,2320.36,327170.76,0.00,0.00,0.00,0.00,0.00),('1','116','717','125819',2507073,'1957','297',1011874.72,1012190.06,315.34,44462.94,0.00,0.00,0.00,0.00,0.00),('1','116','719','125819',2507074,'1966','298',448397.63,449659.61,1261.98,271325.70,0.00,0.00,0.00,0.00,0.00),('1','116','720','125819',2507075,'1967','297',108420.47,108420.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125819',2507076,'1968','297',595036.62,597808.90,2772.28,390891.48,0.00,0.00,0.00,0.00,0.00),('1','116','720','125819',2507077,'1969','297',359298.82,361302.86,2004.04,282569.64,0.00,0.00,0.00,0.00,0.00),('1','116','720','125819',2507078,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125819',2507079,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125819',2507080,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125912',2508873,'1950','297',722076.65,722076.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125912',2508874,'1951','297',668188.04,670154.56,1966.52,277279.32,0.00,0.00,0.00,0.00,0.00),('1','116','717','125912',2508875,'1952','297',595607.49,595607.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125912',2508876,'1953','297',964109.24,966734.47,2625.23,370157.43,0.00,0.00,0.00,0.00,0.00),('1','116','717','125912',2508877,'1954','297',598519.63,598519.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125912',2508878,'1955','297',647104.39,649059.56,1955.17,275678.97,0.00,0.00,0.00,0.00,0.00),('1','116','717','125912',2508879,'1956','297',643372.98,643372.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125912',2508880,'1957','297',1012190.06,1014566.84,2376.78,335125.98,0.00,0.00,0.00,0.00,0.00),('1','116','719','125912',2508881,'1966','298',449659.61,451742.21,2082.60,447759.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125912',2508882,'1967','297',108420.47,108420.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125912',2508883,'1968','297',597808.90,598871.96,1063.06,149891.46,0.00,0.00,0.00,0.00,0.00),('1','116','720','125912',2508884,'1969','297',361302.86,362197.80,894.94,126186.54,0.00,0.00,0.00,0.00,0.00),('1','116','720','125912',2508885,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125912',2508886,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125912',2508887,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125917',2508951,'1950','297',722076.65,722242.39,165.74,23369.34,0.00,0.00,0.00,0.00,0.00),('1','116','717','125917',2508952,'1951','297',670154.56,673120.01,2965.45,418128.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','125917',2508953,'1952','297',595607.49,598484.69,2867.20,404275.20,0.00,0.00,10.00,0.00,0.00),('1','116','717','125917',2508954,'1953','297',966734.47,966734.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125917',2508955,'1954','297',598519.63,599091.76,572.13,80670.33,0.00,0.00,0.00,0.00,0.00),('1','116','717','125917',2508956,'1955','297',649059.56,651145.56,2086.00,294126.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','125917',2508957,'1956','297',643372.98,646238.19,2855.21,402584.61,0.00,0.00,10.00,0.00,0.00),('1','116','717','125917',2508958,'1957','297',1014566.84,1014566.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','125917',2508959,'1966','298',451742.21,453407.44,1665.23,358024.45,0.00,0.00,0.00,0.00,0.00),('1','116','720','125917',2508960,'1967','297',108420.47,108674.82,244.35,34453.35,0.00,0.00,10.00,0.00,0.00),('1','116','720','125917',2508961,'1968','297',598871.96,600583.33,1701.37,239893.17,0.00,0.00,10.00,0.00,0.00),('1','116','720','125917',2508962,'1969','297',362197.80,364255.93,2048.13,288786.33,0.00,0.00,10.00,0.00,0.00),('1','116','720','125917',2508963,'1970','297',464405.18,464405.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125917',2508964,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','125917',2508965,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126044',2511678,'1950','297',722242.39,722242.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126044',2511679,'1951','297',673120.01,674406.47,1286.46,181390.86,0.00,0.00,0.00,0.00,0.00),('1','116','717','126044',2511680,'1952','297',598484.69,598484.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126044',2511681,'1953','297',966734.47,966734.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126044',2511682,'1954','297',599091.76,601703.20,2611.44,368213.04,0.00,0.00,0.00,0.00,0.00),('1','116','717','126044',2511683,'1955','297',651145.56,651145.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126044',2511684,'1956','297',646238.19,648526.26,2288.07,322617.87,0.00,0.00,0.00,0.00,0.00),('1','116','717','126044',2511685,'1957','297',1014566.84,1014566.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','126044',2511686,'1966','298',453407.44,454173.64,766.20,164733.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126044',2511687,'1967','297',108674.82,111221.36,2546.54,359062.14,0.00,0.00,0.00,0.00,0.00),('1','116','720','126044',2511688,'1968','297',600583.33,600583.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126044',2511689,'1969','297',364255.93,364255.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126044',2511690,'1970','297',464405.18,466804.34,2399.16,338281.56,0.00,0.00,0.00,0.00,0.00),('1','116','720','126044',2511691,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126044',2511692,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126059',2511969,'1950','297',722242.39,725325.10,3082.71,434662.11,0.00,0.00,0.00,0.00,0.00),('1','116','717','126059',2511970,'1951','297',674406.47,674406.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126059',2511971,'1952','297',598484.69,601708.96,3224.27,454622.07,0.00,0.00,0.00,0.00,0.00),('1','116','717','126059',2511972,'1953','297',966734.47,966734.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126059',2511973,'1954','297',601703.20,603607.05,1903.85,268442.85,0.00,0.00,0.00,0.00,0.00),('1','116','717','126059',2511974,'1955','297',651145.56,651706.21,560.65,79051.65,0.00,0.00,0.00,0.00,0.00),('1','116','717','126059',2511975,'1956','297',648526.26,651010.20,2483.94,350235.54,0.00,0.00,0.00,0.00,0.00),('1','116','717','126059',2511976,'1957','297',1014566.84,1014566.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','126059',2511977,'1966','298',454173.64,456320.04,2146.40,461476.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126059',2511978,'1967','297',111221.36,111221.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126059',2511979,'1968','297',600583.33,602600.03,2016.70,284354.70,0.00,0.00,0.00,0.00,0.00),('1','116','720','126059',2511980,'1969','297',364255.93,366903.29,2647.36,373277.76,0.00,0.00,0.00,0.00,0.00),('1','116','720','126059',2511981,'1970','297',466804.34,466804.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126059',2511982,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126059',2511983,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126181',2514682,'1950','297',725325.10,725325.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126181',2514683,'1951','297',674406.47,676015.46,1608.99,226867.59,0.00,0.00,0.00,0.00,0.00),('1','116','717','126181',2514684,'1952','297',601708.96,603474.14,1765.18,248890.38,0.00,0.00,0.00,0.00,0.00),('1','116','717','126181',2514685,'1953','297',966734.47,966734.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126181',2514686,'1954','297',603607.05,603607.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126181',2514687,'1955','297',651706.21,653018.68,1312.47,185058.27,0.00,0.00,0.00,0.00,0.00),('1','116','717','126181',2514688,'1956','297',651010.20,651854.20,844.00,119004.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126181',2514689,'1957','297',1014566.84,1016401.30,1834.46,258658.86,0.00,0.00,0.00,0.00,0.00),('1','116','719','126181',2514690,'1966','298',456320.04,457164.74,844.70,181610.50,0.00,0.00,0.00,0.00,0.00),('1','116','720','126181',2514691,'1967','297',111221.36,111221.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126181',2514692,'1968','297',602600.03,603910.25,1310.22,184741.02,0.00,0.00,0.00,0.00,0.00),('1','116','720','126181',2514693,'1969','297',366903.29,368616.09,1712.80,241504.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','126181',2514694,'1970','297',466804.34,466804.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126181',2514695,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126181',2514696,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126182',2514697,'1950','297',725325.10,725494.20,169.10,23843.10,0.00,0.00,0.00,0.00,0.00),('1','116','717','126182',2514698,'1951','297',676015.46,678500.86,2485.40,350441.40,0.00,0.00,0.00,0.00,0.00),('1','116','717','126182',2514699,'1952','297',603474.14,606515.37,3041.23,428813.43,0.00,0.00,0.00,0.00,0.00),('1','116','717','126182',2514700,'1953','297',966734.47,966734.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126182',2514701,'1954','297',603607.05,605765.35,2158.30,304320.30,0.00,0.00,0.00,0.00,0.00),('1','116','717','126182',2514702,'1955','297',653018.68,653018.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126182',2514703,'1956','297',651854.20,654901.46,3047.26,429663.66,0.00,0.00,0.00,0.00,0.00),('1','116','717','126182',2514704,'1957','297',1016401.30,1016401.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','126182',2514705,'1966','298',457164.74,457626.38,461.64,99252.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','126182',2514706,'1967','297',111221.36,111221.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126182',2514707,'1968','297',603910.25,606267.72,2357.47,332403.27,0.00,0.00,0.00,0.00,0.00),('1','116','720','126182',2514708,'1969','297',368616.09,368616.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126182',2514709,'1970','297',466804.34,466804.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126182',2514710,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126182',2514711,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126259',2516082,'1950','297',725494.20,727103.79,1609.59,226952.19,0.00,0.00,0.00,0.00,0.00),('1','116','717','126259',2516083,'1951','297',678500.86,678500.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126259',2516084,'1952','297',606515.37,607816.02,1300.65,183391.65,0.00,0.00,0.00,0.00,0.00),('1','116','717','126259',2516085,'1953','297',966734.47,966734.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126259',2516086,'1954','297',605765.35,605765.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126259',2516087,'1955','297',653018.68,654312.13,1293.45,182376.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','126259',2516088,'1956','297',654901.46,656140.63,1239.17,174722.97,0.00,0.00,0.00,0.00,0.00),('1','116','717','126259',2516089,'1957','297',1016401.30,1017626.90,1225.60,172809.60,0.00,0.00,0.00,0.00,0.00),('1','116','719','126259',2516090,'1966','298',457626.38,457927.55,301.17,64751.55,0.00,0.00,0.00,0.00,0.00),('1','116','720','126259',2516091,'1967','297',111221.36,111734.20,512.84,72310.44,0.00,0.00,0.00,0.00,0.00),('1','116','720','126259',2516092,'1968','297',606267.72,606267.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126259',2516093,'1969','297',368616.09,369731.39,1115.30,157257.30,0.00,0.00,0.00,0.00,0.00),('1','116','720','126259',2516094,'1970','297',466804.34,466804.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126259',2516095,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126259',2516096,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126260',2516097,'1950','297',727103.79,727103.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126260',2516098,'1951','297',678500.86,680513.31,2012.45,283755.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','126260',2516099,'1952','297',607816.02,610276.20,2460.18,346885.38,0.00,0.00,0.00,0.00,0.00),('1','116','717','126260',2516100,'1953','297',966734.47,966734.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126260',2516101,'1954','297',605765.35,607917.70,2152.35,303481.35,0.00,0.00,0.00,0.00,0.00),('1','116','717','126260',2516102,'1955','297',654312.13,654636.27,324.14,45703.74,0.00,0.00,0.00,0.00,0.00),('1','116','717','126260',2516103,'1956','297',656140.63,656140.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126260',2516104,'1957','297',1017626.90,1019616.32,1989.42,280508.22,0.00,0.00,0.00,0.00,0.00),('1','116','719','126260',2516105,'1966','298',457927.55,458485.22,557.67,119899.05,0.00,0.00,0.00,0.00,0.00),('1','116','720','126260',2516106,'1967','297',111734.20,111734.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126260',2516107,'1968','297',606267.72,607041.11,773.39,109047.99,0.00,0.00,0.00,0.00,0.00),('1','116','720','126260',2516108,'1969','297',369731.39,370882.74,1151.35,162340.35,0.00,0.00,0.00,0.00,0.00),('1','116','720','126260',2516109,'1970','297',466804.34,466804.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126260',2516110,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126260',2516111,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126375',2518205,'1950','297',727103.79,728443.05,1319.26,186015.66,0.00,0.00,20.00,0.00,0.00),('1','116','717','126375',2518206,'1951','297',680513.31,681346.71,823.40,116099.40,0.00,0.00,10.00,0.00,0.00),('1','116','717','126375',2518207,'1952','297',610276.20,612557.61,2261.41,318858.81,0.00,0.00,20.00,0.00,0.00),('1','116','717','126375',2518208,'1953','297',966734.47,966866.99,122.52,17275.32,0.00,0.00,10.00,0.00,0.00),('1','116','717','126375',2518209,'1954','297',607917.70,608327.62,399.92,56388.72,0.00,0.00,10.00,0.00,0.00),('1','116','717','126375',2518210,'1955','297',654636.27,655987.50,1331.23,187703.43,0.00,0.00,20.00,0.00,0.00),('1','116','717','126375',2518211,'1956','297',656140.63,656477.95,327.32,46152.12,0.00,0.00,10.00,0.00,0.00),('1','116','717','126375',2518212,'1957','297',1019616.32,1021207.79,1571.47,221577.27,0.00,0.00,20.00,0.00,0.00),('1','116','719','126375',2518213,'1966','298',458485.22,459204.54,709.32,152503.80,0.00,0.00,10.00,0.00,0.00),('1','116','720','126375',2518214,'1967','297',111734.20,111829.32,85.12,12001.92,0.00,0.00,10.00,0.00,0.00),('1','116','720','126375',2518215,'1968','297',607041.11,608223.32,1172.21,165281.61,0.00,0.00,10.00,0.00,0.00),('1','116','720','126375',2518216,'1969','297',370882.74,372155.86,1253.12,176689.92,0.00,0.00,20.00,0.00,0.00),('1','116','720','126375',2518217,'1970','297',466804.34,466838.98,24.64,3474.24,0.00,0.00,10.00,0.00,0.00),('1','116','720','126375',2518218,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126375',2518219,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126388',2518471,'1950','297',728443.05,728684.92,241.87,34103.67,0.00,0.00,0.00,0.00,0.00),('1','116','717','126388',2518472,'1951','297',681346.71,684216.33,2869.62,404616.42,0.00,0.00,0.00,0.00,0.00),('1','116','717','126388',2518473,'1952','297',612557.61,615135.02,2577.41,363414.81,0.00,0.00,0.00,0.00,0.00),('1','116','717','126388',2518474,'1953','297',966866.99,969207.65,2340.66,330033.06,0.00,0.00,0.00,0.00,0.00),('1','116','717','126388',2518475,'1954','297',608327.62,608691.72,364.10,51338.10,0.00,0.00,0.00,0.00,0.00),('1','116','717','126388',2518476,'1955','297',655987.50,658493.04,2505.54,353281.14,0.00,0.00,0.00,0.00,0.00),('1','116','717','126388',2518477,'1956','297',656477.95,658480.40,2002.45,282345.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','126388',2518478,'1957','297',1021207.79,1023819.36,2611.57,368231.37,0.00,0.00,0.00,0.00,0.00),('1','116','719','126388',2518479,'1966','298',459204.54,460433.64,1229.10,264256.50,0.00,0.00,0.00,0.00,0.00),('1','116','720','126388',2518480,'1967','297',111829.32,111829.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126388',2518481,'1968','297',608223.32,608223.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126388',2518482,'1969','297',372155.86,372155.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126388',2518483,'1970','297',466838.98,466838.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126388',2518484,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126388',2518485,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126568',2521746,'1950','297',728684.92,730905.32,2220.40,313076.40,0.00,0.00,0.00,0.00,0.00),('1','116','717','126568',2521747,'1951','297',684216.33,684216.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126568',2521748,'1952','297',615135.02,617953.14,2818.12,397354.92,0.00,0.00,0.00,0.00,0.00),('1','116','717','126568',2521749,'1953','297',969207.65,969207.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126568',2521750,'1954','297',608691.72,609029.76,338.04,47663.64,0.00,0.00,0.00,0.00,0.00),('1','116','717','126568',2521751,'1955','297',658493.04,661501.85,3008.81,424242.21,0.00,0.00,0.00,0.00,0.00),('1','116','717','126568',2521752,'1956','297',658480.40,658764.85,284.45,40107.45,0.00,0.00,0.00,0.00,0.00),('1','116','717','126568',2521753,'1957','297',1023819.36,1025795.86,1976.50,278686.50,0.00,0.00,0.00,0.00,0.00),('1','116','719','126568',2521754,'1966','298',460433.64,460961.11,527.47,113406.05,0.00,0.00,0.00,0.00,0.00),('1','116','720','126568',2521755,'1967','297',111829.32,111829.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126568',2521756,'1968','297',608223.32,608223.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126568',2521757,'1969','297',372155.86,372155.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126568',2521758,'1970','297',466838.98,466838.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126568',2521759,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126568',2521760,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126576',2521921,'1950','297',730905.32,733851.27,2945.95,415378.95,0.00,0.00,0.00,0.00,0.00),('1','116','717','126576',2521922,'1951','297',684216.33,684411.24,194.91,27482.31,0.00,0.00,0.00,0.00,0.00),('1','116','717','126576',2521923,'1952','297',617953.14,620670.65,2717.51,383168.91,0.00,0.00,0.00,0.00,0.00),('1','116','717','126576',2521924,'1953','297',969207.65,971148.12,1940.47,273606.27,0.00,0.00,0.00,0.00,0.00),('1','116','717','126576',2521925,'1954','297',609029.76,609115.60,85.84,12103.44,0.00,0.00,0.00,0.00,0.00),('1','116','717','126576',2521926,'1955','297',661501.85,664289.04,2787.19,392993.79,0.00,0.00,0.00,0.00,0.00),('1','116','717','126576',2521927,'1956','297',658764.85,660811.14,2046.29,288526.89,0.00,0.00,0.00,0.00,0.00),('1','116','717','126576',2521928,'1957','297',1025795.86,1028311.28,2515.42,354674.22,0.00,0.00,0.00,0.00,0.00),('1','116','719','126576',2521929,'1966','298',460961.11,461666.28,705.17,151611.55,0.00,0.00,0.00,0.00,0.00),('1','116','720','126576',2521930,'1967','297',111829.32,111829.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126576',2521931,'1968','297',608223.32,608223.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126576',2521932,'1969','297',372155.86,372155.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126576',2521933,'1970','297',466838.98,466838.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126576',2521934,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126576',2521935,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126699',2524482,'1950','297',733851.27,735987.09,2135.82,301150.62,0.00,0.00,0.00,0.00,0.00),('1','116','717','126699',2524483,'1951','297',684411.24,684527.93,116.69,16453.29,0.00,0.00,0.00,0.00,0.00),('1','116','717','126699',2524484,'1952','297',620670.65,620670.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126699',2524485,'1953','297',971148.12,974045.07,2896.95,408469.95,0.00,0.00,0.00,0.00,0.00),('1','116','717','126699',2524486,'1954','297',609115.60,609115.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126699',2524487,'1955','297',664289.04,666389.53,2100.49,296169.09,0.00,0.00,0.00,0.00,0.00),('1','116','717','126699',2524488,'1956','297',660811.14,662505.50,1694.36,238904.76,0.00,0.00,0.00,0.00,0.00),('1','116','717','126699',2524489,'1957','297',1028311.28,1030169.58,1858.30,262020.30,0.00,0.00,0.00,0.00,0.00),('1','116','719','126699',2524490,'1966','298',461666.28,462142.83,476.55,102458.25,0.00,0.00,0.00,0.00,0.00),('1','116','720','126699',2524491,'1967','297',111829.32,111829.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126699',2524492,'1968','297',608223.32,608223.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126699',2524493,'1969','297',372155.86,372155.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126699',2524494,'1970','297',466838.98,466838.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126699',2524495,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126699',2524496,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126700',2524497,'1950','297',735987.09,738419.06,2431.97,342907.77,0.00,0.00,0.00,0.00,0.00),('1','116','717','126700',2524498,'1951','297',684527.93,685158.60,630.67,88924.47,0.00,0.00,0.00,0.00,0.00),('1','116','717','126700',2524499,'1952','297',620670.65,623515.46,2844.81,401118.21,0.00,0.00,0.00,0.00,0.00),('1','116','717','126700',2524500,'1953','297',974045.07,974045.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126700',2524501,'1954','297',609115.60,611007.59,1891.99,266770.59,0.00,0.00,0.00,0.00,0.00),('1','116','717','126700',2524502,'1955','297',666389.53,667540.24,1150.71,162250.11,0.00,0.00,0.00,0.00,0.00),('1','116','717','126700',2524503,'1956','297',662505.50,665326.19,2820.69,397717.29,0.00,0.00,0.00,0.00,0.00),('1','116','717','126700',2524504,'1957','297',1030169.58,1030364.27,194.69,27451.29,0.00,0.00,0.00,0.00,0.00),('1','116','719','126700',2524505,'1966','298',462142.83,463413.42,1270.59,273176.85,0.00,0.00,0.00,0.00,0.00),('1','116','720','126700',2524506,'1967','297',111829.32,111829.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126700',2524507,'1968','297',608223.32,609690.76,1467.44,206909.04,0.00,0.00,0.00,0.00,0.00),('1','116','720','126700',2524508,'1969','297',372155.86,372155.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126700',2524509,'1970','297',466838.98,468524.92,1685.94,237717.54,0.00,0.00,0.00,0.00,0.00),('1','116','720','126700',2524510,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126700',2524511,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126843',2527504,'1950','297',738419.06,740607.06,2188.00,308508.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126843',2527505,'1951','297',685158.60,685158.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126843',2527506,'1952','297',623515.46,623793.62,278.16,39220.56,0.00,0.00,0.00,0.00,0.00),('1','116','717','126843',2527507,'1953','297',974045.07,974045.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126843',2527508,'1954','297',611007.59,611007.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126843',2527509,'1955','297',667540.24,668898.74,1358.50,191548.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','126843',2527510,'1956','297',665326.19,665326.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126843',2527511,'1957','297',1030364.27,1032269.36,1905.09,268617.69,0.00,0.00,0.00,0.00,0.00),('1','116','719','126843',2527512,'1966','298',463413.42,463940.88,527.46,113403.90,0.00,0.00,0.00,0.00,0.00),('1','116','720','126843',2527513,'1967','297',111829.32,111965.33,136.01,19177.41,0.00,0.00,0.00,0.00,0.00),('1','116','720','126843',2527514,'1968','297',609690.76,611129.78,1439.02,202901.82,0.00,0.00,0.00,0.00,0.00),('1','116','720','126843',2527515,'1969','297',372155.86,372155.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126843',2527516,'1970','297',468524.92,469442.74,917.82,129412.62,0.00,0.00,0.00,0.00,0.00),('1','116','720','126843',2527517,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126843',2527518,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126844',2527519,'1950','297',740607.06,740607.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126844',2527520,'1951','297',685158.60,685559.07,400.47,56466.27,0.00,0.00,0.00,0.00,0.00),('1','116','717','126844',2527521,'1952','297',623793.62,627315.13,3521.51,496532.91,0.00,0.00,0.00,0.00,0.00),('1','116','717','126844',2527522,'1953','297',974045.07,974045.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126844',2527523,'1954','297',611007.59,611007.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126844',2527524,'1955','297',668898.74,671296.47,2397.73,338079.93,0.00,0.00,0.00,0.00,0.00),('1','116','717','126844',2527525,'1956','297',665326.19,665326.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126844',2527526,'1957','297',1032269.36,1035294.68,3025.32,426570.12,0.00,0.00,0.00,0.00,0.00),('1','116','719','126844',2527527,'1966','298',463940.88,464858.75,917.87,197342.05,0.00,0.00,0.00,0.00,0.00),('1','116','720','126844',2527528,'1967','297',111965.33,111965.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126844',2527529,'1968','297',611129.78,613316.97,2187.19,308393.79,0.00,0.00,0.00,0.00,0.00),('1','116','720','126844',2527530,'1969','297',372155.86,372155.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126844',2527531,'1970','297',469442.74,472409.14,2966.40,418262.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','126844',2527532,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126844',2527533,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126951',2529347,'1950','297',740607.06,742249.96,1642.90,231648.90,0.00,0.00,0.00,0.00,0.00),('1','116','717','126951',2529348,'1951','297',685559.07,685559.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126951',2529349,'1952','297',627315.13,629871.02,2555.89,360380.49,0.00,0.00,0.00,0.00,0.00),('1','116','717','126951',2529350,'1953','297',974045.07,974407.41,362.34,51089.94,0.00,0.00,0.00,0.00,0.00),('1','116','717','126951',2529351,'1954','297',611007.59,611867.59,860.00,121260.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126951',2529352,'1955','297',671296.47,671806.08,509.61,71855.01,0.00,0.00,0.00,0.00,0.00),('1','116','717','126951',2529353,'1956','297',665326.19,665326.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126951',2529354,'1957','297',1035294.68,1037696.10,2401.42,338600.22,0.00,0.00,0.00,0.00,0.00),('1','116','719','126951',2529355,'1966','298',464858.75,465405.14,546.39,117473.85,0.00,0.00,0.00,0.00,0.00),('1','116','720','126951',2529356,'1967','297',111965.33,111965.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126951',2529357,'1968','297',613316.97,614846.33,1529.36,215639.76,0.00,0.00,0.00,0.00,0.00),('1','116','720','126951',2529358,'1969','297',372155.86,373472.45,1316.59,185639.19,0.00,0.00,0.00,0.00,0.00),('1','116','720','126951',2529359,'1970','297',472409.14,472409.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126951',2529360,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126951',2529361,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126953',2529385,'1950','297',742249.96,745118.93,2868.97,404524.77,0.00,0.00,0.00,0.00,0.00),('1','116','717','126953',2529386,'1951','297',685559.07,685574.72,15.65,2206.65,0.00,0.00,0.00,0.00,0.00),('1','116','717','126953',2529387,'1952','297',629871.02,633459.05,3588.03,505912.23,0.00,0.00,0.00,0.00,0.00),('1','116','717','126953',2529388,'1953','297',974407.41,974407.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','126953',2529389,'1954','297',611867.59,612449.72,582.13,82080.33,0.00,0.00,0.00,0.00,0.00),('1','116','717','126953',2529390,'1955','297',671806.08,673998.74,2192.66,309165.06,0.00,0.00,0.00,0.00,0.00),('1','116','717','126953',2529391,'1956','297',665326.19,667284.38,1958.19,276104.79,0.00,0.00,0.00,0.00,0.00),('1','116','717','126953',2529392,'1957','297',1037696.10,1039479.23,1783.13,251421.33,0.00,0.00,0.00,0.00,0.00),('1','116','719','126953',2529393,'1966','298',465405.14,466305.76,900.62,193633.30,0.00,0.00,0.00,0.00,0.00),('1','116','720','126953',2529394,'1967','297',111965.33,111965.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126953',2529395,'1968','297',614846.33,616280.77,1434.44,202256.04,0.00,0.00,0.00,0.00,0.00),('1','116','720','126953',2529396,'1969','297',373472.45,373472.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126953',2529397,'1970','297',472409.14,476063.70,3654.56,515292.96,0.00,0.00,0.00,0.00,0.00),('1','116','720','126953',2529398,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','126953',2529399,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127120',2532262,'1950','297',745118.93,745789.88,670.95,94603.95,0.00,0.00,0.00,0.00,0.00),('1','116','717','127120',2532263,'1951','297',685574.72,685574.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127120',2532264,'1952','297',633459.05,633459.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127120',2532265,'1953','297',974407.41,977632.06,3224.65,454675.65,0.00,0.00,0.00,0.00,0.00),('1','116','717','127120',2532266,'1954','297',612449.72,614123.54,1673.82,236008.62,0.00,0.00,0.00,0.00,0.00),('1','116','717','127120',2532267,'1955','297',673998.74,673998.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127120',2532268,'1956','297',667284.38,667284.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127120',2532269,'1957','297',1039479.23,1042299.84,2820.61,397706.01,0.00,0.00,0.00,0.00,0.00),('1','116','719','127120',2532270,'1966','298',466305.76,468046.27,1740.51,374209.65,0.00,0.00,0.00,0.00,0.00),('1','116','720','127120',2532271,'1967','297',111965.33,111965.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127120',2532272,'1968','297',616280.77,617601.68,1320.91,186248.31,0.00,0.00,0.00,0.00,0.00),('1','116','720','127120',2532273,'1969','297',373472.45,375213.56,1741.11,245496.51,0.00,0.00,0.00,0.00,0.00),('1','116','720','127120',2532274,'1970','297',476063.70,476063.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127120',2532275,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127120',2532276,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127121',2532277,'1950','297',745789.88,745789.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127121',2532278,'1951','297',685574.72,688220.50,2645.78,373054.98,0.00,0.00,0.00,0.00,0.00),('1','116','717','127121',2532279,'1952','297',633459.05,636625.06,3166.01,446407.41,0.00,0.00,0.00,0.00,0.00),('1','116','717','127121',2532280,'1953','297',977632.06,977632.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127121',2532281,'1954','297',614123.54,616371.08,2247.54,316903.14,0.00,0.00,0.00,0.00,0.00),('1','116','717','127121',2532282,'1955','297',673998.74,673998.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127121',2532283,'1956','297',667284.38,669986.32,2701.94,380973.54,0.00,0.00,0.00,0.00,0.00),('1','116','717','127121',2532284,'1957','297',1042299.84,1042331.75,31.91,4499.31,0.00,0.00,0.00,0.00,0.00),('1','116','719','127121',2532285,'1966','298',468046.27,468692.88,646.61,139021.15,0.00,0.00,0.00,0.00,0.00),('1','116','720','127121',2532286,'1967','297',111965.33,111965.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127121',2532287,'1968','297',617601.68,619963.17,2361.49,332970.09,0.00,0.00,0.00,0.00,0.00),('1','116','720','127121',2532288,'1969','297',375213.56,376825.65,1612.09,227304.69,0.00,0.00,0.00,0.00,0.00),('1','116','720','127121',2532289,'1970','297',476063.70,476063.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127121',2532290,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127121',2532291,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127231',2534186,'1950','297',745789.88,747747.71,1957.83,276054.03,0.00,0.00,0.00,0.00,0.00),('1','116','717','127231',2534187,'1951','297',688220.50,688220.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127231',2534188,'1952','297',636625.06,636625.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127231',2534189,'1953','297',977632.06,979907.93,2275.87,320897.67,0.00,0.00,0.00,0.00,0.00),('1','116','717','127231',2534190,'1954','297',616371.08,617504.30,1133.22,159784.02,0.00,0.00,0.00,0.00,0.00),('1','116','717','127231',2534191,'1955','297',673998.74,673998.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127231',2534192,'1956','297',669986.32,671436.02,1449.70,204407.70,0.00,0.00,0.00,0.00,0.00),('1','116','717','127231',2534193,'1957','297',1042331.75,1042331.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','127231',2534194,'1966','298',468692.88,468776.28,83.40,17931.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127231',2534195,'1967','297',111965.33,111965.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127231',2534196,'1968','297',619963.17,621464.92,1501.75,211746.75,0.00,0.00,0.00,0.00,0.00),('1','116','720','127231',2534197,'1969','297',376825.65,378443.38,1617.73,228099.93,0.00,0.00,0.00,0.00,0.00),('1','116','720','127231',2534198,'1970','297',476063.70,476063.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127231',2534199,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127231',2534200,'1972','297',35059.80,35059.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127233',2534229,'1950','297',747747.71,750103.92,2356.21,332225.61,0.00,0.00,0.00,0.00,0.00),('1','116','717','127233',2534230,'1951','297',688220.50,688220.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127233',2534231,'1952','297',636625.06,639328.63,2703.57,381203.37,0.00,0.00,0.00,0.00,0.00),('1','116','717','127233',2534232,'1953','297',979907.93,979907.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127233',2534233,'1954','297',617504.30,617920.62,416.32,58701.12,0.00,0.00,0.00,0.00,0.00),('1','116','717','127233',2534234,'1955','297',673998.74,673998.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127233',2534235,'1956','297',671436.02,671436.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127233',2534236,'1957','297',1042331.75,1044721.30,2389.55,336926.55,0.00,0.00,0.00,0.00,0.00),('1','116','719','127233',2534237,'1966','298',468776.28,469261.49,485.21,104320.15,0.00,0.00,0.00,0.00,0.00),('1','116','720','127233',2534238,'1967','297',111965.33,111965.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127233',2534239,'1968','297',621464.92,623605.45,2140.53,301814.73,0.00,0.00,0.00,0.00,0.00),('1','116','720','127233',2534240,'1969','297',378443.38,378443.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127233',2534241,'1970','297',476063.70,477895.55,1831.85,258290.85,0.00,0.00,0.00,0.00,0.00),('1','116','720','127233',2534242,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127233',2534243,'1972','297',35059.80,35081.90,22.10,3116.10,0.00,0.00,0.00,0.00,0.00),('1','116','717','127325',2535933,'1950','297',750103.92,752418.74,2314.82,326389.62,0.00,0.00,0.00,0.00,0.00),('1','116','717','127325',2535934,'1951','297',688220.50,688220.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127325',2535935,'1952','297',639328.63,641832.16,2503.53,352997.73,0.00,0.00,0.00,0.00,0.00),('1','116','717','127325',2535936,'1953','297',979907.93,979907.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127325',2535937,'1954','297',617920.62,618228.11,307.49,43356.09,0.00,0.00,0.00,0.00,0.00),('1','116','717','127325',2535938,'1955','297',673998.74,675478.54,1479.80,208651.80,0.00,0.00,0.00,0.00,0.00),('1','116','717','127325',2535939,'1956','297',671436.02,671436.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127325',2535940,'1957','297',1044721.30,1047056.16,2334.86,329215.26,0.00,0.00,0.00,0.00,0.00),('1','116','719','127325',2535941,'1966','298',469261.49,472761.41,3499.92,752482.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','127325',2535942,'1967','297',111965.33,111965.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127325',2535943,'1968','297',623605.45,624586.87,981.42,138380.22,0.00,0.00,0.00,0.00,0.00),('1','116','720','127325',2535944,'1969','297',378443.38,380050.14,1606.76,226553.16,0.00,0.00,0.00,0.00,0.00),('1','116','720','127325',2535945,'1970','297',477895.55,477895.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127325',2535946,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127325',2535947,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127334',2536116,'1950','297',752418.74,754436.29,2017.55,284474.55,0.00,0.00,0.00,0.00,0.00),('1','116','717','127334',2536117,'1951','297',688220.50,688510.42,289.92,40878.72,0.00,0.00,0.00,0.00,0.00),('1','116','717','127334',2536118,'1952','297',641832.16,641832.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127334',2536119,'1953','297',979907.93,982959.32,3051.39,430245.99,0.00,0.00,0.00,0.00,0.00),('1','116','717','127334',2536120,'1954','297',618228.11,620041.38,1813.27,255671.07,0.00,0.00,0.00,0.00,0.00),('1','116','717','127334',2536121,'1955','297',675478.54,675478.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127334',2536122,'1956','297',671436.02,672735.12,1299.10,183173.10,0.00,0.00,0.00,0.00,0.00),('1','116','717','127334',2536123,'1957','297',1047056.16,1049694.39,2638.23,371990.43,0.00,0.00,0.00,0.00,0.00),('1','116','719','127334',2536124,'1966','298',472761.41,473459.31,697.90,150048.50,0.00,0.00,0.00,0.00,0.00),('1','116','720','127334',2536125,'1967','297',111965.33,111965.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127334',2536126,'1968','297',624586.87,626443.81,1856.94,261828.54,0.00,0.00,0.00,0.00,0.00),('1','116','720','127334',2536127,'1969','297',380050.14,382796.06,2745.92,387174.72,0.00,0.00,0.00,0.00,0.00),('1','116','720','127334',2536128,'1970','297',477895.55,477895.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127334',2536129,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127334',2536130,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127420',2538016,'1950','297',754436.29,754749.81,303.52,42796.32,0.00,0.00,10.00,0.00,0.00),('1','116','717','127420',2538017,'1951','297',688510.42,690152.11,1621.69,228658.29,0.00,0.00,20.00,0.00,0.00),('1','116','717','127420',2538018,'1952','297',641832.16,643085.50,1233.34,173900.94,0.00,0.00,20.00,0.00,0.00),('1','116','717','127420',2538019,'1953','297',982959.32,983783.31,813.99,114772.59,0.00,0.00,10.00,0.00,0.00),('1','116','717','127420',2538020,'1954','297',620041.38,620360.19,308.81,43542.21,0.00,0.00,10.00,0.00,0.00),('1','116','717','127420',2538021,'1955','297',675478.54,676313.15,824.61,116270.01,0.00,0.00,10.00,0.00,0.00),('1','116','717','127420',2538022,'1956','297',672735.12,674413.51,1668.39,235242.99,0.00,0.00,10.00,0.00,0.00),('1','116','717','127420',2538023,'1957','297',1049694.39,1050858.12,1153.73,162675.93,0.00,0.00,10.00,0.00,0.00),('1','116','719','127420',2538024,'1966','298',473459.31,473972.11,502.80,108102.00,0.00,0.00,10.00,0.00,0.00),('1','116','720','127420',2538025,'1967','297',111965.33,112368.40,383.07,54012.87,0.00,0.00,20.00,0.00,0.00),('1','116','720','127420',2538026,'1968','297',626443.81,627441.96,978.15,137919.15,0.00,0.00,20.00,0.00,0.00),('1','116','720','127420',2538027,'1969','297',382796.06,383733.95,927.89,130832.49,0.00,0.00,10.00,0.00,0.00),('1','116','720','127420',2538028,'1970','297',477895.55,478327.15,411.60,58035.60,0.00,0.00,20.00,0.00,0.00),('1','116','720','127420',2538029,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127420',2538030,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127452',2538612,'1950','297',754749.81,758081.80,3331.99,469810.59,0.00,0.00,0.00,0.00,0.00),('1','116','717','127452',2538613,'1951','297',690152.11,690186.86,34.75,4899.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','127452',2538614,'1952','297',643085.50,646905.54,3820.04,538625.64,0.00,0.00,0.00,0.00,0.00),('1','116','717','127452',2538615,'1953','297',983783.31,983783.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127452',2538616,'1954','297',620360.19,620360.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127452',2538617,'1955','297',676313.15,679731.31,3418.16,481960.56,0.00,0.00,0.00,0.00,0.00),('1','116','717','127452',2538618,'1956','297',674413.51,674834.33,420.82,59335.62,0.00,0.00,0.00,0.00,0.00),('1','116','717','127452',2538619,'1957','297',1050858.12,1050858.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','127452',2538620,'1966','298',473972.11,474509.99,537.88,115644.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','127452',2538621,'1967','297',112368.40,112368.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127452',2538622,'1968','297',627441.96,630314.77,2872.81,405066.21,0.00,0.00,0.00,0.00,0.00),('1','116','720','127452',2538623,'1969','297',383733.95,386038.27,2304.32,324909.12,0.00,0.00,0.00,0.00,0.00),('1','116','720','127452',2538624,'1970','297',478327.15,478327.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127452',2538625,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127452',2538626,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127613',2541958,'1950','297',758081.80,758081.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127613',2541959,'1951','297',690186.86,692126.84,1939.98,273537.18,0.00,0.00,0.00,0.00,0.00),('1','116','717','127613',2541960,'1952','297',646905.54,646933.21,27.67,3901.47,0.00,0.00,0.00,0.00,0.00),('1','116','717','127613',2541961,'1953','297',983783.31,986372.07,2588.76,365015.16,0.00,0.00,0.00,0.00,0.00),('1','116','717','127613',2541962,'1954','297',620360.19,622363.47,2003.28,282462.48,0.00,0.00,0.00,0.00,0.00),('1','116','717','127613',2541963,'1955','297',679731.31,679731.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127613',2541964,'1956','297',674834.33,674834.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127613',2541965,'1957','297',1050858.12,1053001.72,2143.60,302247.60,0.00,0.00,0.00,0.00,0.00),('1','116','719','127613',2541966,'1966','298',474509.99,476368.40,1858.41,399558.15,0.00,0.00,0.00,0.00,0.00),('1','116','720','127613',2541967,'1967','297',112368.40,112368.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127613',2541968,'1968','297',630314.77,632789.56,2474.79,348945.39,0.00,0.00,0.00,0.00,0.00),('1','116','720','127613',2541969,'1969','297',386038.27,386988.05,949.78,133918.98,0.00,0.00,0.00,0.00,0.00),('1','116','720','127613',2541970,'1970','297',478327.15,478327.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127613',2541971,'1971','297',37119.04,37119.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127613',2541972,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127616',2542044,'1950','297',758081.80,761801.76,3719.96,524514.36,0.00,0.00,0.00,0.00,0.00),('1','116','717','127616',2542045,'1951','297',692126.84,692126.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127616',2542046,'1952','297',646933.21,650528.48,3595.27,506933.07,0.00,0.00,0.00,0.00,0.00),('1','116','717','127616',2542047,'1953','297',986372.07,986372.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127616',2542048,'1954','297',622363.47,622363.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127616',2542049,'1955','297',679731.31,682461.07,2729.76,384896.16,0.00,0.00,0.00,0.00,0.00),('1','116','717','127616',2542050,'1956','297',674834.33,678183.72,3349.39,472263.99,0.00,0.00,0.00,0.00,0.00),('1','116','717','127616',2542051,'1957','297',1053001.72,1053001.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','127616',2542052,'1966','298',476368.40,477000.84,632.44,135974.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','127616',2542053,'1967','297',112368.40,112368.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127616',2542054,'1968','297',632789.56,635138.42,2328.39,328302.99,0.00,0.00,20.47,0.00,0.00),('1','116','720','127616',2542055,'1969','297',386988.05,389492.44,2483.90,350229.90,0.00,0.00,20.49,0.00,0.00),('1','116','720','127616',2542056,'1970','297',478327.15,478701.72,374.57,52814.37,0.00,0.00,0.00,0.00,0.00),('1','116','720','127616',2542057,'1971','297',37119.04,37124.13,5.09,717.69,0.00,0.00,0.00,0.00,0.00),('1','116','720','127616',2542058,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127723',2544466,'1950','297',761801.76,763872.75,2070.99,292009.59,0.00,0.00,0.00,0.00,0.00),('1','116','717','127723',2544467,'1951','297',692126.84,692126.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127723',2544468,'1952','297',650528.48,650528.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127723',2544469,'1953','297',986372.07,989104.59,2732.52,385285.32,0.00,0.00,0.00,0.00,0.00),('1','116','717','127723',2544470,'1954','297',622363.47,625001.42,2637.95,371950.95,0.00,0.00,0.00,0.00,0.00),('1','116','717','127723',2544471,'1955','297',682461.07,682461.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127723',2544472,'1956','297',678183.72,678183.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127723',2544473,'1957','297',1053001.72,1055209.73,2208.01,311329.41,0.00,0.00,0.00,0.00,0.00),('1','116','719','127723',2544474,'1966','298',477000.84,477432.14,431.30,92729.50,0.00,0.00,0.00,0.00,0.00),('1','116','720','127723',2544475,'1967','297',112368.40,112368.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127723',2544476,'1968','297',635138.42,636150.41,1011.99,142690.59,0.00,0.00,0.00,0.00,0.00),('1','116','720','127723',2544477,'1969','297',389492.44,391527.62,2035.18,286960.38,0.00,0.00,0.00,0.00,0.00),('1','116','720','127723',2544478,'1970','297',478701.72,478701.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127723',2544479,'1971','297',37124.13,37124.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127723',2544480,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127939',2548843,'1950','297',763872.75,764575.57,702.82,99097.62,0.00,0.00,0.00,0.00,0.00),('1','116','717','127939',2548844,'1951','297',692126.84,694641.05,2514.21,354503.61,0.00,0.00,0.00,0.00,0.00),('1','116','717','127939',2548845,'1952','297',650528.48,653068.55,2540.07,358149.87,0.00,0.00,0.00,0.00,0.00),('1','116','717','127939',2548846,'1953','297',989104.59,989104.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127939',2548847,'1954','297',625001.42,627864.50,2863.08,403694.28,0.00,0.00,0.00,0.00,0.00),('1','116','717','127939',2548848,'1955','297',682461.07,682461.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127939',2548849,'1956','297',678183.72,681491.71,3307.99,466426.59,0.00,0.00,0.00,0.00,0.00),('1','116','717','127939',2548850,'1957','297',1055209.73,1055209.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','127939',2548851,'1966','298',477432.14,478319.98,887.84,190885.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','127939',2548852,'1967','297',112368.40,112368.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127939',2548853,'1968','297',636150.41,639544.01,3393.60,478497.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','127939',2548854,'1969','297',391527.62,393186.36,1658.74,233882.34,0.00,0.00,0.00,0.00,0.00),('1','116','720','127939',2548855,'1970','297',478701.72,479209.29,507.57,71567.37,0.00,0.00,0.00,0.00,0.00),('1','116','720','127939',2548856,'1971','297',37124.13,37124.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127939',2548857,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127940',2548858,'1950','297',764575.57,767205.29,2629.72,370790.52,0.00,0.00,0.00,0.00,0.00),('1','116','717','127940',2548859,'1951','297',694641.05,694641.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127940',2548860,'1952','297',653068.55,653068.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127940',2548861,'1953','297',989104.59,989523.67,419.08,59090.28,0.00,0.00,0.00,0.00,0.00),('1','116','717','127940',2548862,'1954','297',627864.50,630311.77,2447.27,345065.07,0.00,0.00,0.00,0.00,0.00),('1','116','717','127940',2548863,'1955','297',682461.07,682463.20,2.13,300.33,0.00,0.00,0.00,0.00,0.00),('1','116','717','127940',2548864,'1956','297',681491.71,684559.04,3067.33,432493.53,0.00,0.00,0.00,0.00,0.00),('1','116','717','127940',2548865,'1957','297',1055209.73,1055209.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','127940',2548866,'1966','298',478319.98,479247.75,927.77,199470.55,0.00,0.00,0.00,0.00,0.00),('1','116','720','127940',2548867,'1967','297',112368.40,112368.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127940',2548868,'1968','297',639544.01,642210.79,2666.78,376015.98,0.00,0.00,0.00,0.00,0.00),('1','116','720','127940',2548869,'1969','297',393186.36,393186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127940',2548870,'1970','297',479209.29,481489.94,2280.65,321571.65,0.00,0.00,0.00,0.00,0.00),('1','116','720','127940',2548871,'1971','297',37124.13,37124.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127940',2548872,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127942',2548888,'1950','297',767205.29,767305.31,100.02,14102.82,0.00,0.00,0.00,0.00,0.00),('1','116','717','127942',2548889,'1951','297',694641.05,697227.99,2586.94,364758.54,0.00,0.00,0.00,0.00,0.00),('1','116','717','127942',2548890,'1952','297',653068.55,657319.72,4251.17,599414.97,0.00,0.00,0.00,0.00,0.00),('1','116','717','127942',2548891,'1953','297',989523.67,989523.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127942',2548892,'1954','297',630311.77,633668.88,3357.11,473352.51,0.00,0.00,0.00,0.00,0.00),('1','116','717','127942',2548893,'1955','297',682463.20,682793.60,330.40,46586.40,0.00,0.00,0.00,0.00,0.00),('1','116','717','127942',2548894,'1956','297',684559.04,687500.01,2940.97,414676.77,0.00,0.00,0.00,0.00,0.00),('1','116','717','127942',2548895,'1957','297',1055209.73,1056227.08,1017.35,143446.35,0.00,0.00,0.00,0.00,0.00),('1','116','719','127942',2548896,'1966','298',479247.75,480841.45,1593.70,342645.50,0.00,0.00,0.00,0.00,0.00),('1','116','720','127942',2548897,'1967','297',112368.40,112368.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127942',2548898,'1968','297',642210.79,642794.18,583.39,82257.99,0.00,0.00,0.00,0.00,0.00),('1','116','720','127942',2548899,'1969','297',393186.36,395319.17,2132.81,300726.21,0.00,0.00,0.00,0.00,0.00),('1','116','720','127942',2548900,'1970','297',481489.94,481489.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127942',2548901,'1971','297',37124.13,37124.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127942',2548902,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127943',2548903,'1950','297',767305.31,767305.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127943',2548904,'1951','297',697227.99,699198.29,1970.30,277812.30,0.00,0.00,0.00,0.00,0.00),('1','116','717','127943',2548905,'1952','297',657319.72,657338.88,19.16,2701.56,0.00,0.00,0.00,0.00,0.00),('1','116','717','127943',2548906,'1953','297',989523.67,991985.08,2461.41,347058.81,0.00,0.00,0.00,0.00,0.00),('1','116','717','127943',2548907,'1954','297',633668.88,633668.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127943',2548908,'1955','297',682793.60,684889.27,2095.67,295489.47,0.00,0.00,0.00,0.00,0.00),('1','116','717','127943',2548909,'1956','297',687500.01,690480.39,2980.38,420233.58,0.00,0.00,0.00,0.00,0.00),('1','116','717','127943',2548910,'1957','297',1056227.08,1056227.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','127943',2548911,'1966','298',480841.45,481402.98,561.53,120728.95,0.00,0.00,0.00,0.00,0.00),('1','116','720','127943',2548912,'1967','297',112368.40,112368.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127943',2548913,'1968','297',642794.18,643089.96,295.78,41704.98,0.00,0.00,0.00,0.00,0.00),('1','116','720','127943',2548914,'1969','297',395319.17,397155.26,1836.09,258888.69,0.00,0.00,0.00,0.00,0.00),('1','116','720','127943',2548915,'1970','297',481489.94,481489.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127943',2548916,'1971','297',37124.13,37124.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127943',2548917,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127944',2548918,'1950','297',767305.31,767596.81,291.50,41101.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','127944',2548919,'1951','297',699198.29,701383.51,2185.22,308116.02,0.00,0.00,0.00,0.00,0.00),('1','116','717','127944',2548920,'1952','297',657338.88,660544.84,3205.96,452040.36,0.00,0.00,0.00,0.00,0.00),('1','116','717','127944',2548921,'1953','297',991985.08,991985.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','127944',2548922,'1954','297',633668.88,634516.51,847.63,119515.83,0.00,0.00,0.00,0.00,0.00),('1','116','717','127944',2548923,'1955','297',684889.27,687229.25,2339.98,329937.18,0.00,0.00,0.00,0.00,0.00),('1','116','717','127944',2548924,'1956','297',690480.39,693130.14,2649.75,373614.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','127944',2548925,'1957','297',1056227.08,1056227.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','127944',2548926,'1966','298',481402.98,481900.25,497.27,106913.05,0.00,0.00,0.00,0.00,0.00),('1','116','720','127944',2548927,'1967','297',112368.40,112368.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127944',2548928,'1968','297',643089.96,645312.55,2222.59,313385.19,0.00,0.00,0.00,0.00,0.00),('1','116','720','127944',2548929,'1969','297',397155.26,398547.86,1392.60,196356.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','127944',2548930,'1970','297',481489.94,481489.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127944',2548931,'1971','297',37124.13,37124.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','127944',2548932,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128042',2550880,'1950','297',767596.81,768503.10,906.29,127786.89,0.00,0.00,0.00,0.00,0.00),('1','116','717','128042',2550881,'1951','297',701383.51,702144.50,760.99,107299.59,0.00,0.00,0.00,0.00,0.00),('1','116','717','128042',2550882,'1952','297',660544.84,661669.03,1124.19,158510.79,0.00,0.00,0.00,0.00,0.00),('1','116','717','128042',2550883,'1953','297',991985.08,991985.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128042',2550884,'1954','297',634516.51,634516.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128042',2550885,'1955','297',687229.25,688282.17,1052.92,148461.72,0.00,0.00,0.00,0.00,0.00),('1','116','717','128042',2550886,'1956','297',693130.14,694794.04,1663.90,234609.90,0.00,0.00,0.00,0.00,0.00),('1','116','717','128042',2550887,'1957','297',1056227.08,1056230.63,3.55,500.55,0.00,0.00,0.00,0.00,0.00),('1','116','719','128042',2550888,'1966','298',481900.25,482039.56,139.31,29951.65,0.00,0.00,0.00,0.00,0.00),('1','116','720','128042',2550889,'1967','297',112368.40,113195.70,827.30,116649.30,0.00,0.00,0.00,0.00,0.00),('1','116','720','128042',2550890,'1968','297',645312.55,645312.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128042',2550891,'1969','297',398547.86,399872.85,1324.99,186823.59,0.00,0.00,0.00,0.00,0.00),('1','116','720','128042',2550892,'1970','297',481489.94,481489.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128042',2550893,'1971','297',37124.13,37124.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128042',2550894,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128043',2550895,'1950','297',768503.10,768758.82,255.72,36056.52,0.00,0.00,0.00,0.00,0.00),('1','116','717','128043',2550896,'1951','297',702144.50,703968.82,1824.32,257229.12,0.00,0.00,0.00,0.00,0.00),('1','116','717','128043',2550897,'1952','297',661669.03,663480.61,1811.58,255432.78,0.00,0.00,0.00,0.00,0.00),('1','116','717','128043',2550898,'1953','297',991985.08,991985.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128043',2550899,'1954','297',634516.51,635041.00,524.49,73953.09,0.00,0.00,0.00,0.00,0.00),('1','116','717','128043',2550900,'1955','297',688282.17,689502.32,1220.15,172041.15,0.00,0.00,0.00,0.00,0.00),('1','116','717','128043',2550901,'1956','297',694794.04,697513.33,2719.29,383419.89,0.00,0.00,0.00,0.00,0.00),('1','116','717','128043',2550902,'1957','297',1056230.63,1056230.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','128043',2550903,'1966','298',482039.56,482528.00,488.44,105014.60,0.00,0.00,0.00,0.00,0.00),('1','116','720','128043',2550904,'1967','297',113195.70,113195.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128043',2550905,'1968','297',645312.55,647260.18,1947.63,274615.83,0.00,0.00,0.00,0.00,0.00),('1','116','720','128043',2550906,'1969','297',399872.85,401459.24,1586.39,223680.99,0.00,0.00,0.00,0.00,0.00),('1','116','720','128043',2550907,'1970','297',481489.94,481489.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128043',2550908,'1971','297',37124.13,37124.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128043',2550909,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128157',2553288,'1950','297',768758.82,770906.29,2147.47,302793.27,0.00,0.00,0.00,0.00,0.00),('1','116','717','128157',2553289,'1951','297',703968.82,703968.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128157',2553290,'1952','297',663480.61,665589.62,2109.01,297370.41,0.00,0.00,0.00,0.00,0.00),('1','116','717','128157',2553291,'1953','297',991985.08,991985.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128157',2553292,'1954','297',635041.00,637104.40,2063.40,290939.40,0.00,0.00,0.00,0.00,0.00),('1','116','717','128157',2553293,'1955','297',689502.32,690532.48,1030.16,145252.56,0.00,0.00,0.00,0.00,0.00),('1','116','717','128157',2553294,'1956','297',697513.33,699383.17,1869.84,263647.44,0.00,0.00,0.00,0.00,0.00),('1','116','717','128157',2553295,'1957','297',1056230.63,1056230.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','128157',2553296,'1966','298',482528.00,484189.99,1661.99,357327.85,0.00,0.00,0.00,0.00,0.00),('1','116','720','128157',2553297,'1967','297',113195.70,113195.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128157',2553298,'1968','297',647260.18,648586.34,1326.16,186988.56,0.00,0.00,0.00,0.00,0.00),('1','116','720','128157',2553299,'1969','297',401459.24,403184.66,1725.42,243284.78,0.00,0.00,0.00,0.00,0.00),('1','116','720','128157',2553300,'1970','297',481489.94,481489.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128157',2553301,'1971','297',37124.13,37124.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128157',2553302,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128158',2553303,'1950','297',770906.29,770906.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128158',2553304,'1951','297',703968.82,706570.89,2602.07,366891.87,0.00,0.00,0.00,0.00,0.00),('1','116','717','128158',2553305,'1952','297',665589.62,668076.15,2486.53,350600.73,0.00,0.00,0.00,0.00,0.00),('1','116','717','128158',2553306,'1953','297',991985.08,993619.29,1634.21,230423.61,0.00,0.00,0.00,0.00,0.00),('1','116','717','128158',2553307,'1954','297',637104.40,637104.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128158',2553308,'1955','297',690532.48,692274.02,1741.54,245557.14,0.00,0.00,0.00,0.00,0.00),('1','116','717','128158',2553309,'1956','297',699383.17,699383.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128158',2553310,'1957','297',1056230.63,1059271.06,3040.43,428700.63,0.00,0.00,0.00,0.00,0.00),('1','116','719','128158',2553311,'1966','298',484189.99,484671.02,481.03,103421.45,0.00,0.00,0.00,0.00,0.00),('1','116','720','128158',2553312,'1967','297',113195.70,113195.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128158',2553313,'1968','297',648586.34,650549.79,1963.45,276846.45,0.00,0.00,0.00,0.00,0.00),('1','116','720','128158',2553314,'1969','297',403184.66,404722.33,1537.67,216811.47,0.00,0.00,0.00,0.00,0.00),('1','116','720','128158',2553315,'1970','297',481489.94,484103.39,2613.45,368496.45,0.00,0.00,0.00,0.00,0.00),('1','116','720','128158',2553316,'1971','297',37124.13,37166.99,42.86,6043.26,0.00,0.00,0.00,0.00,0.00),('1','116','720','128158',2553317,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128339',2556934,'1950','297',770906.29,770906.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128339',2556935,'1951','297',706570.89,708132.66,1561.77,220209.57,0.00,0.00,0.00,0.00,0.00),('1','116','717','128339',2556936,'1952','297',668076.15,669876.66,1800.51,253871.91,0.00,0.00,0.00,0.00,0.00),('1','116','717','128339',2556937,'1953','297',993619.29,993619.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128339',2556938,'1954','297',637104.40,637104.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128339',2556939,'1955','297',692274.02,694214.61,1940.59,273623.19,0.00,0.00,0.00,0.00,0.00),('1','116','717','128339',2556940,'1956','297',699383.17,700791.76,1408.59,198611.19,0.00,0.00,0.00,0.00,0.00),('1','116','717','128339',2556941,'1957','297',1059271.06,1059945.77,674.71,95134.11,0.00,0.00,0.00,0.00,0.00),('1','116','719','128339',2556942,'1966','298',484671.02,486071.35,1400.33,301070.95,0.00,0.00,0.00,0.00,0.00),('1','116','720','128339',2556943,'1967','297',113195.70,113198.54,2.84,400.44,0.00,0.00,0.00,0.00,0.00),('1','116','720','128339',2556944,'1968','297',650549.79,652344.80,1795.01,253096.41,0.00,0.00,0.00,0.00,0.00),('1','116','720','128339',2556945,'1969','297',404722.33,406336.72,1614.39,227628.99,0.00,0.00,0.00,0.00,0.00),('1','116','720','128339',2556946,'1970','297',484103.39,484103.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128339',2556947,'1971','297',37166.99,37166.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128339',2556948,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128341',2556965,'1950','297',770906.29,773769.17,2862.88,403666.08,0.00,0.00,0.00,0.00,0.00),('1','116','717','128341',2556966,'1951','297',708132.66,708132.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128341',2556967,'1952','297',669876.66,672980.05,3103.39,437577.99,0.00,0.00,0.00,0.00,0.00),('1','116','717','128341',2556968,'1953','297',993619.29,993619.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128341',2556969,'1954','297',637104.40,637104.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128341',2556970,'1955','297',694214.61,696566.71,2352.10,331646.10,0.00,0.00,0.00,0.00,0.00),('1','116','717','128341',2556971,'1956','297',700791.76,700791.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128341',2556972,'1957','297',1059945.77,1062319.84,2374.07,334743.87,0.00,0.00,0.00,0.00,0.00),('1','116','719','128341',2556973,'1966','298',486071.35,487174.51,1103.16,237179.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','128341',2556974,'1967','297',113198.54,115764.46,2565.92,361794.72,0.00,0.00,0.00,0.00,0.00),('1','116','720','128341',2556975,'1968','297',652344.80,652344.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128341',2556976,'1969','297',406336.72,408941.23,2604.51,367235.91,0.00,0.00,0.00,0.00,0.00),('1','116','720','128341',2556977,'1970','297',484103.39,484103.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128341',2556978,'1971','297',37166.99,37166.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128341',2556979,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128346',2557054,'1950','297',773769.17,773769.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128346',2557055,'1951','297',708132.66,708132.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128346',2557056,'1952','297',672980.05,672980.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128346',2557057,'1953','297',993619.29,996747.77,3128.48,441115.68,0.00,0.00,0.00,0.00,0.00),('1','116','717','128346',2557058,'1954','297',637104.40,639106.07,2001.67,282235.47,0.00,0.00,0.00,0.00,0.00),('1','116','717','128346',2557059,'1955','297',696566.71,696566.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128346',2557060,'1956','297',700791.76,700791.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128346',2557061,'1957','297',1062319.84,1064935.07,2615.23,368747.43,0.00,0.00,0.00,0.00,0.00),('1','116','719','128346',2557062,'1966','298',487174.51,487575.56,401.05,86225.75,0.00,0.00,0.00,0.00,0.00),('1','116','720','128346',2557063,'1967','297',115764.46,115764.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128346',2557064,'1968','297',652344.80,652781.28,436.48,61543.68,0.00,0.00,0.00,0.00,0.00),('1','116','720','128346',2557065,'1969','297',408941.23,411147.42,2206.19,311072.79,0.00,0.00,0.00,0.00,0.00),('1','116','720','128346',2557066,'1970','297',484103.39,484103.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128346',2557067,'1971','297',37166.99,37166.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128346',2557068,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128379',2557679,'1950','297',773769.17,774463.38,694.21,97883.61,0.00,0.00,0.00,0.00,0.00),('1','116','717','128379',2557680,'1951','297',708132.66,710628.30,2495.64,351885.24,0.00,0.00,0.00,0.00,0.00),('1','116','717','128379',2557681,'1952','297',672980.05,676801.15,3821.10,538775.10,0.00,0.00,0.00,0.00,0.00),('1','116','717','128379',2557682,'1953','297',996747.77,996747.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128379',2557683,'1954','297',639106.07,639127.34,21.27,2999.07,0.00,0.00,0.00,0.00,0.00),('1','116','717','128379',2557684,'1955','297',696566.71,699870.80,3304.09,465876.69,0.00,0.00,0.00,0.00,0.00),('1','116','717','128379',2557685,'1956','297',700791.76,701492.44,700.68,98795.88,0.00,0.00,0.00,0.00,0.00),('1','116','717','128379',2557686,'1957','297',1064935.07,1064935.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','128379',2557687,'1966','298',487575.56,489043.10,1467.54,315521.10,0.00,0.00,0.00,0.00,0.00),('1','116','720','128379',2557688,'1967','297',115764.46,115764.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128379',2557689,'1968','297',652781.28,655949.66,3168.38,446741.58,0.00,0.00,0.00,0.00,0.00),('1','116','720','128379',2557690,'1969','297',411147.42,413808.45,2661.03,375205.23,0.00,0.00,0.00,0.00,0.00),('1','116','720','128379',2557691,'1970','297',484103.39,484103.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128379',2557692,'1971','297',37166.99,37170.69,3.70,521.70,0.00,0.00,0.00,0.00,0.00),('1','116','720','128379',2557693,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128546',2560991,'1950','297',774463.38,775862.59,1399.21,197288.61,0.00,0.00,0.00,0.00,0.00),('1','116','717','128546',2560992,'1951','297',710628.30,711674.06,1045.76,147452.16,0.00,0.00,0.00,0.00,0.00),('1','116','717','128546',2560993,'1952','297',676801.15,678020.24,1219.09,171891.69,0.00,0.00,0.00,0.00,0.00),('1','116','717','128546',2560994,'1953','297',996747.77,997553.97,806.20,113674.20,0.00,0.00,0.00,0.00,0.00),('1','116','717','128546',2560995,'1954','297',639127.34,640232.34,1105.00,155805.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128546',2560996,'1955','297',699870.80,701047.81,1177.01,165958.41,0.00,0.00,0.00,0.00,0.00),('1','116','717','128546',2560997,'1956','297',701492.44,702682.38,1189.94,167781.54,0.00,0.00,0.00,0.00,0.00),('1','116','717','128546',2560998,'1957','297',1064935.07,1065802.55,867.48,122314.68,0.00,0.00,0.00,0.00,0.00),('1','116','719','128546',2560999,'1966','298',489043.10,491043.46,2000.36,430077.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','128546',2561000,'1967','297',115764.46,116433.21,668.75,94293.75,0.00,0.00,0.00,0.00,0.00),('1','116','720','128546',2561001,'1968','297',655949.66,656339.62,389.96,54984.36,0.00,0.00,0.00,0.00,0.00),('1','116','720','128546',2561002,'1969','297',413808.45,414819.26,1010.81,142524.21,0.00,0.00,0.00,0.00,0.00),('1','116','720','128546',2561003,'1970','297',484103.39,484978.45,875.06,123383.46,0.00,0.00,0.00,0.00,0.00),('1','116','720','128546',2561004,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128546',2561005,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128547',2561006,'1950','297',775862.59,775862.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128547',2561007,'1951','297',711674.06,714181.27,2507.21,353516.61,0.00,0.00,0.00,0.00,0.00),('1','116','717','128547',2561008,'1952','297',678020.24,679835.53,1815.29,255955.89,0.00,0.00,0.00,0.00,0.00),('1','116','717','128547',2561009,'1953','297',997553.97,999929.66,2375.69,334972.29,0.00,0.00,0.00,0.00,0.00),('1','116','717','128547',2561010,'1954','297',640232.34,640232.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128547',2561011,'1955','297',701047.81,703714.88,2667.07,376056.87,0.00,0.00,0.00,0.00,0.00),('1','116','717','128547',2561012,'1956','297',702682.38,705624.94,2942.56,414900.96,0.00,0.00,0.00,0.00,0.00),('1','116','717','128547',2561013,'1957','297',1065802.55,1065802.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','128547',2561014,'1966','298',491043.46,491469.27,425.81,91549.15,0.00,0.00,0.00,0.00,0.00),('1','116','720','128547',2561015,'1967','297',116433.21,116433.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128547',2561016,'1968','297',656339.62,659325.96,2986.34,421073.94,0.00,0.00,0.00,0.00,0.00),('1','116','720','128547',2561017,'1969','297',414819.26,416929.09,2109.83,297486.03,0.00,0.00,0.00,0.00,0.00),('1','116','720','128547',2561018,'1970','297',484978.45,484978.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128547',2561019,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128547',2561020,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128670',2564392,'1950','297',775862.59,778670.72,2808.13,395946.33,0.00,0.00,0.00,0.00,0.00),('1','116','717','128670',2564393,'1951','297',714181.27,714181.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128670',2564394,'1952','297',679835.53,680177.57,342.04,48227.64,0.00,0.00,0.00,0.00,0.00),('1','116','717','128670',2564395,'1953','297',999929.66,1000402.32,472.66,66645.06,0.00,0.00,0.00,0.00,0.00),('1','116','717','128670',2564396,'1954','297',640232.34,640232.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','128670',2564397,'1955','297',703714.88,706514.89,2800.01,394801.41,0.00,0.00,0.00,0.00,0.00),('1','116','717','128670',2564398,'1956','297',705624.94,708981.07,3356.13,473214.33,0.00,0.00,0.00,0.00,0.00),('1','116','717','128670',2564399,'1957','297',1065802.55,1065802.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','128670',2564400,'1966','298',491469.27,492070.18,600.91,129195.65,0.00,0.00,0.00,0.00,0.00),('1','116','720','128670',2564401,'1967','297',116433.21,116433.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128670',2564402,'1968','297',659325.96,661177.97,1852.01,261133.41,0.00,0.00,0.00,0.00,0.00),('1','116','720','128670',2564403,'1969','297',416929.09,418820.91,1891.82,266746.62,0.00,0.00,0.00,0.00,0.00),('1','116','720','128670',2564404,'1970','297',484978.45,484978.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128670',2564405,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','128670',2564406,'1972','297',35081.90,35081.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129358',2578002,'1950','297',778670.72,782047.71,3376.99,476155.59,0.00,0.00,0.00,0.00,0.00),('1','116','717','129358',2578003,'1951','297',714181.27,714505.37,324.10,45698.10,0.00,0.00,0.00,0.00,0.00),('1','116','717','129358',2578004,'1952','297',680177.57,684096.55,3918.98,552576.18,0.00,0.00,0.00,0.00,0.00),('1','116','717','129358',2578005,'1953','297',1000402.32,1000402.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129358',2578006,'1954','297',640232.34,640615.58,383.24,54036.84,0.00,0.00,0.00,0.00,0.00),('1','116','717','129358',2578007,'1955','297',706514.89,709927.12,3412.23,481124.43,0.00,0.00,0.00,0.00,0.00),('1','116','717','129358',2578008,'1956','297',708981.07,711621.68,2640.61,372326.01,0.00,0.00,0.00,0.00,0.00),('1','116','717','129358',2578009,'1957','297',1065802.55,1068393.80,2591.25,365366.25,0.00,0.00,0.00,0.00,0.00),('1','116','719','129358',2578010,'1966','298',492070.18,493451.99,1381.81,297089.15,0.00,0.00,0.00,0.00,0.00),('1','116','720','129358',2578011,'1967','297',116433.21,116433.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129358',2578012,'1968','297',661177.97,662141.35,963.38,135836.58,0.00,0.00,0.00,0.00,0.00),('1','116','720','129358',2578013,'1969','297',418820.91,419837.77,1016.86,143377.26,0.00,0.00,0.00,0.00,0.00),('1','116','720','129358',2578014,'1970','297',484978.45,484978.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129358',2578015,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129358',2578016,'1972','297',35081.90,40106.62,5024.72,708485.52,0.00,0.00,0.00,0.00,0.00),('1','116','717','129361',2578043,'1950','297',782047.71,784211.00,2163.29,305023.89,0.00,0.00,0.00,0.00,0.00),('1','116','717','129361',2578044,'1951','297',714505.37,714505.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129361',2578045,'1952','297',684096.55,684096.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129361',2578046,'1953','297',1000402.32,1002891.98,2489.66,351042.06,0.00,0.00,0.00,0.00,0.00),('1','116','717','129361',2578047,'1954','297',640615.58,640615.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129361',2578048,'1955','297',709927.12,710021.29,94.17,13277.97,0.00,0.00,0.00,0.00,0.00),('1','116','717','129361',2578049,'1956','297',711621.68,714057.65,2435.97,343471.77,0.00,0.00,0.00,0.00,0.00),('1','116','717','129361',2578050,'1957','297',1068393.80,1068393.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','129361',2578051,'1966','298',493451.99,494256.12,804.13,172887.95,0.00,0.00,0.00,0.00,0.00),('1','116','720','129361',2578052,'1967','297',116433.21,116433.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129361',2578053,'1968','297',662141.35,664345.55,2204.20,310792.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','129361',2578054,'1969','297',419837.77,421991.74,2153.97,303709.77,0.00,0.00,0.00,0.00,0.00),('1','116','720','129361',2578055,'1970','297',484978.45,485157.77,179.32,25284.12,0.00,0.00,0.00,0.00,0.00),('1','116','720','129361',2578056,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129361',2578057,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129383',2578505,'1950','297',784211.00,787197.85,2986.85,421145.85,0.00,0.00,0.00,0.00,0.00),('1','116','717','129383',2578506,'1951','297',714505.37,714505.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129383',2578507,'1952','297',684096.55,684096.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129383',2578508,'1953','297',1002891.98,1005305.68,2413.70,340331.70,0.00,0.00,0.00,0.00,0.00),('1','116','717','129383',2578509,'1954','297',640615.58,642188.50,1572.92,221781.72,0.00,0.00,0.00,0.00,0.00),('1','116','717','129383',2578510,'1955','297',710021.29,710077.68,56.39,7950.99,0.00,0.00,0.00,0.00,0.00),('1','116','717','129383',2578511,'1956','297',714057.65,715189.86,1132.21,159641.61,0.00,0.00,0.00,0.00,0.00),('1','116','717','129383',2578512,'1957','297',1068393.80,1070270.34,1876.54,264592.14,0.00,0.00,0.00,0.00,0.00),('1','116','719','129383',2578513,'1966','298',494256.12,495406.62,1150.50,241605.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129383',2578514,'1967','297',116433.21,116433.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129383',2578515,'1968','297',664345.55,666330.00,1984.45,279807.45,0.00,0.00,0.00,0.00,0.00),('1','116','720','129383',2578516,'1969','297',421991.74,424365.29,2373.55,334670.55,0.00,0.00,0.00,0.00,0.00),('1','116','720','129383',2578517,'1970','297',485157.77,485157.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129383',2578518,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129383',2578519,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129391',2578634,'1950','297',787197.85,787197.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129391',2578635,'1951','297',714505.37,716099.37,1594.00,224754.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129391',2578636,'1952','297',684096.55,684096.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129391',2578637,'1953','297',1005305.68,1007552.89,2247.21,316856.61,0.00,0.00,0.00,0.00,0.00),('1','116','717','129391',2578638,'1954','297',642188.50,642993.69,805.19,113531.79,0.00,0.00,0.00,0.00,0.00),('1','116','717','129391',2578639,'1955','297',710077.68,710804.87,727.19,102533.79,0.00,0.00,0.00,0.00,0.00),('1','116','717','129391',2578640,'1956','297',715189.86,715189.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129391',2578641,'1957','297',1070270.34,1071741.65,1471.31,207454.71,0.00,0.00,0.00,0.00,0.00),('1','116','719','129391',2578642,'1966','298',495406.62,495593.76,187.14,39299.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','129391',2578643,'1967','297',116433.21,116433.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129391',2578644,'1968','297',666330.00,667468.61,1138.61,160544.01,0.00,0.00,0.00,0.00,0.00),('1','116','720','129391',2578645,'1969','297',424365.29,424496.87,131.58,18552.78,0.00,0.00,0.00,0.00,0.00),('1','116','720','129391',2578646,'1970','297',485157.77,486697.75,1539.98,217137.18,0.00,0.00,0.00,0.00,0.00),('1','116','720','129391',2578647,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129391',2578648,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129393',2578661,'1950','297',787197.85,788844.69,1646.84,232204.44,0.00,0.00,0.00,0.00,0.00),('1','116','717','129393',2578662,'1951','297',716099.37,717659.41,1560.04,219965.64,0.00,0.00,0.00,0.00,0.00),('1','116','717','129393',2578663,'1952','297',684096.55,686464.67,2368.12,333904.92,0.00,0.00,0.00,0.00,0.00),('1','116','717','129393',2578664,'1953','297',1007552.89,1007724.57,171.68,24206.88,0.00,0.00,0.00,0.00,0.00),('1','116','717','129393',2578665,'1954','297',642993.69,644077.45,1083.76,152810.16,0.00,0.00,0.00,0.00,0.00),('1','116','717','129393',2578666,'1955','297',710804.87,712834.83,2029.96,286224.36,0.00,0.00,0.00,0.00,0.00),('1','116','717','129393',2578667,'1956','297',715189.86,716451.24,1261.38,177854.58,0.00,0.00,0.00,0.00,0.00),('1','116','717','129393',2578668,'1957','297',1071741.65,1073861.51,2119.86,298900.26,0.00,0.00,0.00,0.00,0.00),('1','116','719','129393',2578669,'1966','298',495593.76,495773.76,180.00,37800.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129393',2578670,'1967','297',116433.21,116433.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129393',2578671,'1968','297',667468.61,667474.45,5.84,823.44,0.00,0.00,0.00,0.00,0.00),('1','116','720','129393',2578672,'1969','297',424496.87,424517.45,20.58,2901.78,0.00,0.00,0.00,0.00,0.00),('1','116','720','129393',2578673,'1970','297',486697.75,486697.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129393',2578674,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129393',2578675,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129395',2578704,'1950','297',788844.69,788844.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129395',2578705,'1951','297',717659.41,719706.91,2047.50,288697.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','129395',2578706,'1952','297',686464.67,688475.24,2010.57,283490.37,0.00,0.00,0.00,0.00,0.00),('1','116','717','129395',2578707,'1953','297',1007724.57,1007724.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129395',2578708,'1954','297',644077.45,644077.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129395',2578709,'1955','297',712834.83,714928.13,2093.30,295155.30,0.00,0.00,0.00,0.00,0.00),('1','116','717','129395',2578710,'1956','297',716451.24,716451.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129395',2578711,'1957','297',1073861.51,1076442.91,2581.40,363977.40,0.00,0.00,0.00,0.00,0.00),('1','116','719','129395',2578712,'1966','298',495773.76,495973.76,200.00,42000.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129395',2578713,'1967','297',116433.21,116433.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129395',2578714,'1968','297',667474.45,668993.41,1518.96,214173.36,0.00,0.00,0.00,0.00,0.00),('1','116','720','129395',2578715,'1969','297',424517.45,426517.00,1999.55,281936.55,0.00,0.00,0.00,0.00,0.00),('1','116','720','129395',2578716,'1970','297',486697.75,486697.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129395',2578717,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129395',2578718,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129402',2578821,'1950','297',788844.69,791753.88,2909.19,410195.79,0.00,0.00,0.00,0.00,0.00),('1','116','717','129402',2578822,'1951','297',719706.91,720640.90,933.99,131692.59,0.00,0.00,0.00,0.00,0.00),('1','116','717','129402',2578823,'1952','297',688475.24,688542.64,67.40,9503.40,0.00,0.00,0.00,0.00,0.00),('1','116','717','129402',2578824,'1953','297',1007724.57,1010588.11,2863.54,403759.14,0.00,0.00,0.00,0.00,0.00),('1','116','717','129402',2578825,'1954','297',644077.45,645597.23,1519.78,214288.98,0.00,0.00,0.00,0.00,0.00),('1','116','717','129402',2578826,'1955','297',714928.13,717357.86,2429.73,342591.93,0.00,0.00,0.00,0.00,0.00),('1','116','717','129402',2578827,'1956','297',716451.24,718836.67,2385.43,336345.63,0.00,0.00,0.00,0.00,0.00),('1','116','717','129402',2578828,'1957','297',1076442.91,1079164.66,2721.75,383766.75,0.00,0.00,0.00,0.00,0.00),('1','116','719','129402',2578829,'1966','298',495973.76,497349.14,1375.38,288829.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','129402',2578830,'1967','297',116433.21,116433.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129402',2578831,'1968','297',668993.41,669175.80,182.39,25716.99,0.00,0.00,0.00,0.00,0.00),('1','116','720','129402',2578832,'1969','297',426517.00,426517.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129402',2578833,'1970','297',486697.75,486866.98,169.23,23861.43,0.00,0.00,0.00,0.00,0.00),('1','116','720','129402',2578834,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129402',2578835,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129407',2578912,'1950','297',791753.88,794142.92,2389.04,336854.64,0.00,0.00,0.00,0.00,0.00),('1','116','717','129407',2578913,'1951','297',720640.90,720640.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129407',2578914,'1952','297',688542.64,691576.96,3034.32,427839.12,0.00,0.00,0.00,0.00,0.00),('1','116','717','129407',2578915,'1953','297',1010588.11,1010642.03,53.92,7602.72,0.00,0.00,0.00,0.00,0.00),('1','116','717','129407',2578916,'1954','297',645597.23,645698.25,101.02,14243.82,0.00,0.00,0.00,0.00,0.00),('1','116','717','129407',2578917,'1955','297',717357.86,719548.66,2190.80,308902.80,0.00,0.00,0.00,0.00,0.00),('1','116','717','129407',2578918,'1956','297',718836.67,718925.33,88.66,12501.06,0.00,0.00,0.00,0.00,0.00),('1','116','717','129407',2578919,'1957','297',1079164.66,1081512.52,2347.86,331048.26,0.00,0.00,0.00,0.00,0.00),('1','116','719','129407',2578920,'1966','298',497349.14,497417.57,68.43,14370.30,0.00,0.00,0.00,0.00,0.00),('1','116','720','129407',2578921,'1967','297',116433.21,116433.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129407',2578922,'1968','297',669175.80,670115.94,940.14,132559.74,0.00,0.00,0.00,0.00,0.00),('1','116','720','129407',2578923,'1969','297',426517.00,427523.15,1006.15,141867.15,0.00,0.00,0.00,0.00,0.00),('1','116','720','129407',2578924,'1970','297',486866.98,486866.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129407',2578925,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129407',2578926,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129409',2578943,'1950','297',794142.92,796993.99,2841.07,400590.87,0.00,0.00,10.00,0.00,0.00),('1','116','717','129409',2578944,'1951','297',720640.90,720640.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129409',2578945,'1952','297',691576.96,693356.29,1769.33,249475.53,0.00,0.00,10.00,0.00,0.00),('1','116','717','129409',2578946,'1953','297',1010642.03,1011159.66,517.63,72985.83,0.00,0.00,0.00,0.00,0.00),('1','116','717','129409',2578947,'1954','297',645698.25,645698.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129409',2578948,'1955','297',719548.66,722655.03,3096.37,436588.17,0.00,0.00,10.00,0.00,0.00),('1','116','717','129409',2578949,'1956','297',718925.33,719325.53,380.20,53608.20,0.00,0.00,20.00,0.00,0.00),('1','116','717','129409',2578950,'1957','297',1081512.52,1083074.01,1531.49,215940.09,0.00,0.00,30.00,0.00,0.00),('1','116','719','129409',2578951,'1966','298',497417.57,497417.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129409',2578952,'1967','297',116433.21,116433.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129409',2578953,'1968','297',670115.94,672834.90,2698.96,380553.36,0.00,0.00,20.00,0.00,0.00),('1','116','720','129409',2578954,'1969','297',427523.15,430357.65,2824.50,398254.50,0.00,0.00,10.00,0.00,0.00),('1','116','720','129409',2578955,'1970','297',486866.98,486866.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129409',2578956,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129409',2578957,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129413',2579014,'1950','297',796993.99,799617.12,2623.13,369861.33,0.00,0.00,0.00,0.00,0.00),('1','116','717','129413',2579015,'1951','297',720640.90,720728.31,87.41,12324.81,0.00,0.00,0.00,0.00,0.00),('1','116','717','129413',2579016,'1952','297',693356.29,693356.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129413',2579017,'1953','297',1011159.66,1011159.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129413',2579018,'1954','297',645698.25,648657.33,2959.08,417230.28,0.00,0.00,0.00,0.00,0.00),('1','116','717','129413',2579019,'1955','297',722655.03,722748.31,93.28,13152.48,0.00,0.00,0.00,0.00,0.00),('1','116','717','129413',2579020,'1956','297',719325.53,719325.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129413',2579021,'1957','297',1083074.01,1085758.16,2684.15,378465.15,0.00,0.00,0.00,0.00,0.00),('1','116','719','129413',2579022,'1966','298',497417.57,497627.57,210.00,44100.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129413',2579023,'1967','297',116433.21,116433.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129413',2579024,'1968','297',672834.90,672834.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129413',2579025,'1969','297',430357.65,433393.08,3035.43,427995.63,0.00,0.00,0.00,0.00,0.00),('1','116','720','129413',2579026,'1970','297',486866.98,486866.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129413',2579027,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129413',2579028,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129463',2580088,'1950','297',799617.12,800076.36,459.24,64752.84,0.00,0.00,0.00,0.00,0.00),('1','116','717','129463',2580089,'1951','297',720728.31,723138.96,2410.65,339901.65,0.00,0.00,0.00,0.00,0.00),('1','116','717','129463',2580090,'1952','297',693356.29,696004.41,2648.12,373384.92,0.00,0.00,0.00,0.00,0.00),('1','116','717','129463',2580091,'1953','297',1011159.66,1011417.12,257.46,36301.86,0.00,0.00,0.00,0.00,0.00),('1','116','717','129463',2580092,'1954','297',648657.33,651462.28,2804.95,395497.95,0.00,0.00,0.00,0.00,0.00),('1','116','717','129463',2580093,'1955','297',722748.31,722748.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129463',2580094,'1956','297',719325.53,719325.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129463',2580095,'1957','297',1085758.16,1088646.27,2888.11,407223.51,0.00,0.00,0.00,0.00,0.00),('1','116','719','129463',2580096,'1966','298',497627.57,497627.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129463',2580097,'1967','297',116433.21,116433.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129463',2580098,'1968','297',672834.90,675585.41,2750.51,387821.91,0.00,0.00,0.00,0.00,0.00),('1','116','720','129463',2580099,'1969','297',433393.08,435256.98,1863.90,262809.90,0.00,0.00,0.00,0.00,0.00),('1','116','720','129463',2580100,'1970','297',486866.98,486866.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129463',2580101,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129463',2580102,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129495',2580711,'1950','297',800076.36,800076.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129495',2580712,'1951','297',723138.96,723582.18,443.22,62494.02,0.00,0.00,0.00,0.00,0.00),('1','116','717','129495',2580713,'1952','297',696004.41,696757.43,753.02,106175.82,0.00,0.00,0.00,0.00,0.00),('1','116','717','129495',2580714,'1953','297',1011417.12,1011417.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129495',2580715,'1954','297',651462.28,651462.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129495',2580716,'1955','297',722748.31,723381.91,633.60,89337.60,0.00,0.00,0.00,0.00,0.00),('1','116','717','129495',2580717,'1956','297',719325.53,720071.14,745.61,105131.01,0.00,0.00,0.00,0.00,0.00),('1','116','717','129495',2580718,'1957','297',1088646.27,1088829.97,183.70,25901.70,0.00,0.00,0.00,0.00,0.00),('1','116','719','129495',2580719,'1966','298',497627.57,497627.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129495',2580720,'1967','297',116433.21,116433.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129495',2580721,'1968','297',675585.41,675585.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129495',2580722,'1969','297',435256.98,435256.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129495',2580723,'1970','297',486866.98,486866.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129495',2580724,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129495',2580725,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129499',2580785,'1950','297',800076.36,800076.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129499',2580786,'1951','297',723582.18,725741.39,2159.21,269901.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','129499',2580787,'1952','297',696757.43,699044.67,2287.24,285905.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129499',2580788,'1953','297',1011417.12,1011417.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129499',2580789,'1954','297',651462.28,651546.28,84.00,10500.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129499',2580790,'1955','297',723381.91,725857.23,2475.32,309415.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129499',2580791,'1956','297',720071.14,722373.74,2302.60,287825.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129499',2580792,'1957','297',1088829.97,1088829.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','129499',2580793,'1966','298',497627.57,497627.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129499',2580794,'1967','297',116433.21,116433.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129499',2580795,'1968','297',675585.41,675585.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129499',2580796,'1969','297',435256.98,435256.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129499',2580797,'1970','297',486866.98,486866.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129499',2580798,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129499',2580799,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129506',2580909,'1950','297',800076.36,803826.85,3750.49,468811.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','129506',2580910,'1951','297',725741.39,725741.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129506',2580911,'1952','297',699044.67,703156.09,4111.42,513927.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','129506',2580912,'1953','297',1011417.12,1011417.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129506',2580913,'1954','297',651546.28,652317.07,770.79,96348.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','129506',2580914,'1955','297',725857.23,728698.47,2841.24,355155.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129506',2580915,'1956','297',722373.74,726334.33,3960.59,495073.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','129506',2580916,'1957','297',1088829.97,1089391.97,562.00,70250.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','129506',2580917,'1966','298',497627.57,497627.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129506',2580918,'1967','297',116433.21,116633.47,200.26,25032.50,0.00,0.00,0.00,0.00,0.00),('1','116','720','129506',2580919,'1968','297',675585.41,677056.22,1470.81,183851.25,0.00,0.00,0.00,0.00,0.00),('1','116','720','129506',2580920,'1969','297',435256.98,437676.74,2419.76,302470.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129506',2580921,'1970','297',486866.98,486927.78,60.80,7600.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129506',2580922,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129506',2580923,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129594',2582662,'1950','297',803826.85,803826.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129594',2582663,'1951','297',725741.39,728315.43,2574.04,321755.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129594',2582664,'1952','297',703156.09,706806.90,3650.81,456351.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','129594',2582665,'1953','297',1011417.12,1011417.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129594',2582666,'1954','297',652317.07,655906.02,3588.95,448618.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','129594',2582667,'1955','297',728698.47,728698.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129594',2582668,'1956','297',726334.33,729989.88,3655.55,456943.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','129594',2582669,'1957','297',1089391.97,1089391.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','129594',2582670,'1966','298',497627.57,497727.57,100.00,21000.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129594',2582671,'1967','297',116633.47,116633.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129594',2582672,'1968','297',677056.22,677056.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129594',2582673,'1969','297',437676.74,440334.41,2657.67,332208.75,0.00,0.00,0.00,0.00,0.00),('1','116','720','129594',2582674,'1970','297',486927.78,486927.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129594',2582675,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129594',2582676,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129596',2582706,'1950','297',803826.85,808405.50,4578.65,572331.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','129596',2582707,'1951','297',728315.43,728315.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129596',2582708,'1952','297',706806.90,711500.46,4693.56,586695.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129596',2582709,'1953','297',1011417.12,1011637.92,220.80,27600.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129596',2582710,'1954','297',655906.02,658314.89,2408.87,301108.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','129596',2582711,'1955','297',728698.47,728698.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129596',2582712,'1956','297',729989.88,734092.38,4102.50,512812.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','129596',2582713,'1957','297',1089391.97,1089391.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','129596',2582714,'1966','298',497727.57,497727.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129596',2582715,'1967','297',116633.47,117094.25,460.78,57597.50,0.00,0.00,0.00,0.00,0.00),('1','116','720','129596',2582716,'1968','297',677056.22,680464.73,3408.51,426063.75,0.00,0.00,0.00,0.00,0.00),('1','116','720','129596',2582717,'1969','297',440334.41,445533.94,5199.53,649941.25,0.00,0.00,0.00,0.00,0.00),('1','116','720','129596',2582718,'1970','297',486927.78,486927.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129596',2582719,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129596',2582720,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129725',2585220,'1950','297',808405.50,808405.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129725',2585221,'1951','297',728315.43,731394.12,3078.69,384836.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','129725',2585222,'1952','297',711500.46,714724.10,3223.64,402955.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129725',2585223,'1953','297',1011637.92,1011637.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129725',2585224,'1954','297',658314.89,658314.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129725',2585225,'1955','297',728698.47,732531.13,3832.66,479082.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','129725',2585226,'1956','297',734092.38,734092.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129725',2585227,'1957','297',1089391.97,1093681.07,4289.10,536137.50,0.00,0.00,0.00,0.00,0.00),('1','116','719','129725',2585228,'1966','298',497727.57,497727.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129725',2585229,'1967','297',117094.25,117094.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129725',2585230,'1968','297',680464.73,680464.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129725',2585231,'1969','297',445533.94,445533.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129725',2585232,'1970','297',486927.78,486927.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129725',2585233,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129725',2585234,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129733',2585405,'1950','297',808405.50,808836.68,431.18,53897.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','129733',2585406,'1951','297',731394.12,732048.02,653.90,81737.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','129733',2585407,'1952','297',714724.10,715262.98,538.88,67360.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129733',2585408,'1953','297',1011637.92,1012127.35,489.43,61178.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','129733',2585409,'1954','297',658314.89,659178.80,863.91,107988.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','129733',2585410,'1955','297',732531.13,732531.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129733',2585411,'1956','297',734092.38,734116.38,24.00,3000.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129733',2585412,'1957','297',1093681.07,1094616.16,935.09,116886.25,0.00,0.00,0.00,0.00,0.00),('1','116','719','129733',2585413,'1966','298',497727.57,499174.90,1447.33,303939.30,0.00,0.00,0.00,0.00,0.00),('1','116','720','129733',2585414,'1967','297',117094.25,117094.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129733',2585415,'1968','297',680464.73,681331.47,866.74,108342.50,0.00,0.00,0.00,0.00,0.00),('1','116','720','129733',2585416,'1969','297',445533.94,446707.02,1173.08,146635.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129733',2585417,'1970','297',486927.78,486927.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129733',2585418,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129733',2585419,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129820',2587155,'1950','297',808836.68,810440.40,1593.72,199215.00,0.00,0.00,10.00,0.00,0.00),('1','116','717','129820',2587156,'1951','297',732048.02,733519.01,1460.99,182623.75,0.00,0.00,10.00,0.00,0.00),('1','116','717','129820',2587157,'1952','297',715262.98,717844.94,2561.96,320245.00,0.00,0.00,20.00,0.00,0.00),('1','116','717','129820',2587158,'1953','297',1012127.35,1014334.19,2196.84,274605.00,0.00,0.00,10.00,0.00,0.00),('1','116','717','129820',2587159,'1954','297',659178.80,661098.09,1899.29,237411.25,0.00,0.00,20.00,0.00,0.00),('1','116','717','129820',2587160,'1955','297',732531.13,734171.67,1630.54,203817.50,0.00,0.00,10.00,0.00,0.00),('1','116','717','129820',2587161,'1956','297',734116.38,735740.50,1604.12,200515.00,0.00,0.00,20.00,0.00,0.00),('1','116','717','129820',2587162,'1957','297',1094616.16,1095122.67,496.51,62063.75,0.00,0.00,10.00,0.00,0.00),('1','116','719','129820',2587163,'1966','298',499174.90,500723.37,1528.47,320978.70,0.00,0.00,20.00,0.00,0.00),('1','116','720','129820',2587164,'1967','297',117094.25,118172.44,1068.19,133523.75,0.00,0.00,10.00,0.00,0.00),('1','116','720','129820',2587165,'1968','297',681331.47,681331.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129820',2587166,'1969','297',446707.02,446707.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129820',2587167,'1970','297',486927.78,488128.47,1180.69,147586.25,0.00,0.00,20.00,0.00,0.00),('1','116','720','129820',2587168,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129820',2587169,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129855',2587937,'1950','297',810440.40,812864.69,2424.29,303036.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','129855',2587938,'1951','297',733519.01,735485.50,1966.49,245811.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','129855',2587939,'1952','297',717844.94,722008.85,4163.91,520488.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','129855',2587940,'1953','297',1014334.19,1014334.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129855',2587941,'1954','297',661098.09,663413.72,2315.63,289453.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','129855',2587942,'1955','297',734171.67,735447.07,1275.40,159425.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','129855',2587943,'1956','297',735740.50,738019.12,2278.62,284827.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','129855',2587944,'1957','297',1095122.67,1098035.43,2912.76,364095.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','129855',2587945,'1966','298',500723.37,500922.57,199.20,41832.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129855',2587946,'1967','297',118172.44,118172.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129855',2587947,'1968','297',681331.47,681331.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129855',2587948,'1969','297',446707.02,446707.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129855',2587949,'1970','297',488128.47,488128.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129855',2587950,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','129855',2587951,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130413',2600069,'1950','297',812864.69,814864.00,1999.31,249913.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','130413',2600070,'1951','297',735485.50,737292.95,1807.45,225931.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','130413',2600071,'1952','297',722008.85,724585.61,2576.76,322095.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130413',2600072,'1953','297',1014334.19,1014334.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130413',2600073,'1954','297',663413.72,663413.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130413',2600074,'1955','297',735447.07,737502.58,2055.51,256938.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','130413',2600075,'1956','297',738019.12,740130.40,2111.28,263910.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130413',2600076,'1957','297',1098035.43,1099788.22,1752.79,219098.75,0.00,0.00,0.00,0.00,0.00),('1','116','719','130413',2600077,'1966','298',500922.57,501399.94,477.37,100247.70,0.00,0.00,0.00,0.00,0.00),('1','116','720','130413',2600078,'1967','297',118172.44,118172.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130413',2600079,'1968','297',681331.47,681331.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130413',2600080,'1969','297',446707.02,446707.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130413',2600081,'1970','297',488128.47,488128.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130413',2600082,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130413',2600083,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130466',2601151,'1950','297',814864.00,815529.48,665.48,83185.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130466',2601152,'1951','297',737292.95,737632.26,339.31,42413.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','130466',2601153,'1952','297',724585.61,725410.23,824.62,103077.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','130466',2601154,'1953','297',1014334.19,1014334.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130466',2601155,'1954','297',663413.72,663413.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130466',2601156,'1955','297',737502.58,738153.69,651.11,81388.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','130466',2601157,'1956','297',740130.40,740589.69,459.29,57411.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','130466',2601158,'1957','297',1099788.22,1100701.40,913.18,114147.50,0.00,0.00,0.00,0.00,0.00),('1','116','719','130466',2601159,'1966','298',501399.94,502273.06,873.12,183355.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','130466',2601160,'1967','297',118172.44,118172.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130466',2601161,'1968','297',681331.47,681331.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130466',2601162,'1969','297',446707.02,446707.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130466',2601163,'1970','297',488128.47,488128.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130466',2601164,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130466',2601165,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130468',2601188,'1950','297',815529.48,815529.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130468',2601189,'1951','297',737632.26,741222.64,3590.38,448797.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','130468',2601190,'1952','297',725410.23,729078.77,3668.54,458567.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','130468',2601191,'1953','297',1014334.19,1015206.57,872.38,109047.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','130468',2601192,'1954','297',663413.72,665866.22,2452.50,306562.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','130468',2601193,'1955','297',738153.69,741283.25,3129.56,391195.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130468',2601194,'1956','297',740589.69,743575.34,2985.65,373206.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','130468',2601195,'1957','297',1100701.40,1103313.91,2612.51,326563.75,0.00,0.00,0.00,0.00,0.00),('1','116','719','130468',2601196,'1966','298',502273.06,503452.01,1178.95,247579.50,0.00,0.00,0.00,0.00,0.00),('1','116','720','130468',2601197,'1967','297',118172.44,118172.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130468',2601198,'1968','297',681331.47,681331.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130468',2601199,'1969','297',446707.02,446707.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130468',2601200,'1970','297',488128.47,488128.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130468',2601201,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130468',2601202,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130622',2604536,'1950','297',815529.48,817033.02,1503.54,187942.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','130622',2604537,'1951','297',741222.64,741222.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130622',2604538,'1952','297',729078.77,730471.69,1392.92,174115.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130622',2604539,'1953','297',1015206.57,1015206.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130622',2604540,'1954','297',665866.22,665866.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130622',2604541,'1955','297',741283.25,742415.17,1131.92,141490.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130622',2604542,'1956','297',743575.34,744769.94,1194.60,149325.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130622',2604543,'1957','297',1103313.91,1103313.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','130622',2604544,'1966','298',503452.01,503465.58,13.57,2849.70,0.00,0.00,0.00,0.00,0.00),('1','116','720','130622',2604545,'1967','297',118172.44,118172.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130622',2604546,'1968','297',681331.47,681331.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130622',2604547,'1969','297',446707.02,446707.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130622',2604548,'1970','297',488128.47,488128.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130622',2604549,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130622',2604550,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130623',2604551,'1950','297',817033.02,819563.60,2530.58,316322.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','130623',2604552,'1951','297',741222.64,743166.83,1944.19,243023.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','130623',2604553,'1952','297',730471.69,732480.53,2008.84,251105.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130623',2604554,'1953','297',1015206.57,1016257.83,1051.26,131407.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','130623',2604555,'1954','297',665866.22,668758.52,2892.30,361537.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','130623',2604556,'1955','297',742415.17,743739.94,1324.77,165596.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','130623',2604557,'1956','297',744769.94,747480.94,2711.00,338875.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130623',2604558,'1957','297',1103313.91,1104474.31,1160.40,145050.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','130623',2604559,'1966','298',503465.58,504728.91,1263.33,265299.30,0.00,0.00,0.00,0.00,0.00),('1','116','720','130623',2604560,'1967','297',118172.44,118172.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130623',2604561,'1968','297',681331.47,681331.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130623',2604562,'1969','297',446707.02,446707.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130623',2604563,'1970','297',488128.47,488128.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130623',2604564,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130623',2604565,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130702',2606300,'1950','297',819563.60,820576.64,1013.04,126630.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130702',2606301,'1951','297',743166.83,744704.61,1537.78,192222.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','130702',2606302,'1952','297',732480.53,733530.67,1050.14,131267.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','130702',2606303,'1953','297',1016257.83,1017617.30,1359.47,169933.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','130702',2606304,'1954','297',668758.52,669502.77,744.25,93031.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','130702',2606305,'1955','297',743739.94,744563.00,823.06,102882.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','130702',2606306,'1956','297',747480.94,748340.33,859.39,107423.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','130702',2606307,'1957','297',1104474.31,1105716.64,1242.33,155291.25,0.00,0.00,0.00,0.00,0.00),('1','116','719','130702',2606308,'1966','298',504728.91,505065.12,336.21,70604.10,0.00,0.00,0.00,0.00,0.00),('1','116','720','130702',2606309,'1967','297',118172.44,118172.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130702',2606310,'1968','297',681331.47,681331.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130702',2606311,'1969','297',446707.02,446707.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130702',2606312,'1970','297',488128.47,488128.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130702',2606313,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130702',2606314,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130703',2606315,'1950','297',820576.64,822459.08,1882.44,235305.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130703',2606316,'1951','297',744704.61,746434.40,1729.79,216223.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','130703',2606317,'1952','297',733530.67,735967.18,2436.51,304563.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','130703',2606318,'1953','297',1017617.30,1017617.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130703',2606319,'1954','297',669502.77,670313.15,810.38,101297.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','130703',2606320,'1955','297',744563.00,744563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','130703',2606321,'1956','297',748340.33,749946.94,1606.61,200826.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','130703',2606322,'1957','297',1105716.64,1107724.49,2007.85,250981.25,0.00,0.00,0.00,0.00,0.00),('1','116','719','130703',2606323,'1966','298',505065.12,505372.19,307.07,64484.70,0.00,0.00,0.00,0.00,0.00),('1','116','720','130703',2606324,'1967','297',118172.44,118172.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130703',2606325,'1968','297',681331.47,681331.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130703',2606326,'1969','297',446707.02,446707.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130703',2606327,'1970','297',488128.47,488128.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130703',2606328,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','130703',2606329,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131044',2613342,'1950','297',822459.08,823263.42,804.34,100542.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','131044',2613343,'1951','297',746434.40,748501.37,2066.97,258371.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','131044',2613344,'1952','297',735967.18,738647.61,2680.43,335053.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','131044',2613345,'1953','297',1017617.30,1017617.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131044',2613346,'1954','297',670313.15,671792.57,1479.42,184927.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','131044',2613347,'1955','297',744563.00,744563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131044',2613348,'1956','297',749946.94,751876.09,1929.15,241143.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','131044',2613349,'1957','297',1107724.49,1109365.38,1640.89,205111.25,0.00,0.00,0.00,0.00,0.00),('1','116','719','131044',2613350,'1966','298',505372.19,506123.36,751.17,157745.70,0.00,0.00,0.00,0.00,0.00),('1','116','720','131044',2613351,'1967','297',118172.44,118172.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131044',2613352,'1968','297',681331.47,681331.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131044',2613353,'1969','297',446707.02,446707.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131044',2613354,'1970','297',488128.47,488128.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131044',2613355,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131044',2613356,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131045',2613357,'1950','297',823263.42,825906.14,2642.72,330340.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131045',2613358,'1951','297',748501.37,750505.63,2004.26,250532.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','131045',2613359,'1952','297',738647.61,742289.14,3641.53,455191.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','131045',2613360,'1953','297',1017617.30,1020255.26,2637.96,329745.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131045',2613361,'1954','297',671792.57,674807.59,3015.02,376877.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','131045',2613362,'1955','297',744563.00,744563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131045',2613363,'1956','297',751876.09,754967.69,3091.60,386450.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131045',2613364,'1957','297',1109365.38,1111399.38,2034.00,254250.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','131045',2613365,'1966','298',506123.36,506646.27,522.91,109811.10,0.00,0.00,0.00,0.00,0.00),('1','116','720','131045',2613366,'1967','297',118172.44,118172.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131045',2613367,'1968','297',681331.47,681331.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131045',2613368,'1969','297',446707.02,446707.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131045',2613369,'1970','297',488128.47,488128.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131045',2613370,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131045',2613371,'1972','297',40106.62,40106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131046',2613372,'1950','297',825906.14,825906.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131046',2613373,'1951','297',750505.63,750505.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131046',2613374,'1952','297',742289.14,742289.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131046',2613375,'1953','297',1020255.26,1020255.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131046',2613376,'1954','297',674807.59,675552.74,735.15,91893.75,0.00,0.00,10.00,0.00,0.00),('1','116','717','131046',2613377,'1955','297',744563.00,744563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131046',2613378,'1956','297',754967.69,754967.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131046',2613379,'1957','297',1111399.38,1112462.50,1043.12,130390.00,0.00,0.00,20.00,0.00,0.00),('1','116','719','131046',2613380,'1966','298',506646.27,506646.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131046',2613381,'1967','297',118172.44,119050.32,867.88,108485.00,0.00,0.00,10.00,0.00,0.00),('1','116','720','131046',2613382,'1968','297',681331.47,683826.20,2474.73,309341.25,0.00,0.00,20.00,0.00,0.00),('1','116','720','131046',2613383,'1969','297',446707.02,448835.00,2107.98,263497.50,0.00,0.00,20.00,0.00,0.00),('1','116','720','131046',2613384,'1970','297',488128.47,490141.75,2003.28,250410.00,0.00,0.00,10.00,0.00,0.00),('1','116','720','131046',2613385,'1971','297',37170.69,37170.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131046',2613386,'1972','297',40106.62,40892.14,775.52,96940.00,0.00,0.00,10.00,0.00,0.00),('1','116','717','131047',2613387,'1950','297',825906.14,825906.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131047',2613388,'1951','297',750505.63,750505.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131047',2613389,'1952','297',742289.14,742289.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131047',2613390,'1953','297',1020255.26,1020255.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131047',2613391,'1954','297',675552.74,675552.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131047',2613392,'1955','297',744563.00,744563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131047',2613393,'1956','297',754967.69,754967.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131047',2613394,'1957','297',1112462.50,1112462.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','131047',2613395,'1966','298',506646.27,507501.27,855.00,179550.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131047',2613396,'1967','297',119050.32,121286.42,2236.10,279512.50,0.00,0.00,0.00,0.00,0.00),('1','116','720','131047',2613397,'1968','297',683826.20,685537.54,1711.34,213917.50,0.00,0.00,0.00,0.00,0.00),('1','116','720','131047',2613398,'1969','297',448835.00,451013.06,2178.06,272257.50,0.00,0.00,0.00,0.00,0.00),('1','116','720','131047',2613399,'1970','297',490141.75,492289.28,2147.53,268441.25,0.00,0.00,0.00,0.00,0.00),('1','116','720','131047',2613400,'1971','297',37170.69,37793.33,622.64,77830.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131047',2613401,'1972','297',40892.14,42307.22,1415.08,176885.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131048',2613402,'1950','297',825906.14,827365.54,1459.40,182425.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131048',2613403,'1951','297',750505.63,750505.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131048',2613404,'1952','297',742289.14,743632.97,1343.83,167978.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','131048',2613405,'1953','297',1020255.26,1020255.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131048',2613406,'1954','297',675552.74,677074.05,1521.31,190163.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','131048',2613407,'1955','297',744563.00,744563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131048',2613408,'1956','297',754967.69,756075.32,1107.63,138453.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','131048',2613409,'1957','297',1112462.50,1113411.13,948.63,118578.75,0.00,0.00,0.00,0.00,0.00),('1','116','719','131048',2613410,'1966','298',507501.27,509873.19,2371.92,498103.20,0.00,0.00,0.00,0.00,0.00),('1','116','720','131048',2613411,'1967','297',121286.42,121286.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131048',2613412,'1968','297',685537.54,685537.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131048',2613413,'1969','297',451013.06,451013.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131048',2613414,'1970','297',492289.28,492289.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131048',2613415,'1971','297',37793.33,38593.33,800.00,100000.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131048',2613416,'1972','297',42307.22,43446.76,1139.54,142442.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','131049',2613417,'1950','297',827365.54,830643.49,3277.95,409743.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','131049',2613418,'1951','297',750505.63,753316.36,2810.73,351341.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','131049',2613419,'1952','297',743632.97,747653.52,4020.55,502568.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','131049',2613420,'1953','297',1020255.26,1020255.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131049',2613421,'1954','297',677074.05,681186.47,4112.42,514052.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','131049',2613422,'1955','297',744563.00,744563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131049',2613423,'1956','297',756075.32,760012.23,3936.91,492113.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','131049',2613424,'1957','297',1113411.13,1116388.04,2976.91,372113.75,0.00,0.00,0.00,0.00,0.00),('1','116','719','131049',2613425,'1966','298',509873.19,510898.67,1025.48,215350.80,0.00,0.00,0.00,0.00,0.00),('1','116','720','131049',2613426,'1967','297',121286.42,121286.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131049',2613427,'1968','297',685537.54,685537.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131049',2613428,'1969','297',451013.06,451013.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131049',2613429,'1970','297',492289.28,492289.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131049',2613430,'1971','297',38593.33,38593.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131049',2613431,'1972','297',43446.76,43446.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131143',2615533,'1950','297',830643.49,832656.16,2012.67,251583.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','131143',2615534,'1951','297',753316.36,755221.28,1904.92,238115.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131143',2615535,'1952','297',747653.52,750055.64,2402.12,300265.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131143',2615536,'1953','297',1020255.26,1020255.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131143',2615537,'1954','297',681186.47,683482.56,2296.09,287011.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','131143',2615538,'1955','297',744563.00,744563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131143',2615539,'1956','297',760012.23,761890.44,1878.21,234776.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','131143',2615540,'1957','297',1116388.04,1117939.09,1551.05,193881.25,0.00,0.00,0.00,0.00,0.00),('1','116','719','131143',2615541,'1966','298',510898.67,511610.70,712.03,149526.30,0.00,0.00,0.00,0.00,0.00),('1','116','720','131143',2615542,'1967','297',121286.42,121286.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131143',2615543,'1968','297',685537.54,685537.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131143',2615544,'1969','297',451013.06,451013.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131143',2615545,'1970','297',492289.28,492289.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131143',2615546,'1971','297',38593.33,38593.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131143',2615547,'1972','297',43446.76,43446.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131145',2615572,'1950','297',832656.16,832656.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131145',2615573,'1951','297',755221.28,758576.37,3355.09,419386.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','131145',2615574,'1952','297',750055.64,753110.25,3054.61,381826.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','131145',2615575,'1953','297',1020255.26,1023249.45,2994.19,374273.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','131145',2615576,'1954','297',683482.56,686392.95,2910.39,363798.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','131145',2615577,'1955','297',744563.00,744563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131145',2615578,'1956','297',761890.44,764535.02,2644.58,330572.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','131145',2615579,'1957','297',1117939.09,1121244.43,3305.34,413167.50,0.00,0.00,0.00,0.00,0.00),('1','116','719','131145',2615580,'1966','298',511610.70,512768.55,1157.85,243148.50,0.00,0.00,0.00,0.00,0.00),('1','116','720','131145',2615581,'1967','297',121286.42,121286.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131145',2615582,'1968','297',685537.54,685537.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131145',2615583,'1969','297',451013.06,451013.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131145',2615584,'1970','297',492289.28,492289.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131145',2615585,'1971','297',38593.33,38593.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131145',2615586,'1972','297',43446.76,43446.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131296',2618838,'1950','297',832656.16,834159.62,1503.46,187932.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','131296',2618839,'1951','297',758576.37,760314.94,1738.57,217321.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','131296',2618840,'1952','297',753110.25,755511.31,2401.06,300132.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','131296',2618841,'1953','297',1023249.45,1023249.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131296',2618842,'1954','297',686392.95,688160.22,1767.27,220908.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','131296',2618843,'1955','297',744563.00,744563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131296',2618844,'1956','297',764535.02,766219.77,1684.75,210593.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','131296',2618845,'1957','297',1121244.43,1123181.84,1937.41,242176.25,0.00,0.00,0.00,0.00,0.00),('1','116','719','131296',2618846,'1966','298',512768.55,513086.14,317.59,66693.90,0.00,0.00,0.00,0.00,0.00),('1','116','720','131296',2618847,'1967','297',121286.42,121286.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131296',2618848,'1968','297',685537.54,685537.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131296',2618849,'1969','297',451013.06,451013.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131296',2618850,'1970','297',492289.28,492289.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131296',2618851,'1971','297',38593.33,38593.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131296',2618852,'1972','297',43446.76,43446.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131297',2618853,'1950','297',834159.62,836031.33,1871.71,233963.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','131297',2618854,'1951','297',760314.94,763324.08,3009.14,376142.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','131297',2618855,'1952','297',755511.31,758261.65,2750.34,343792.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','131297',2618856,'1953','297',1023249.45,1025656.14,2406.69,300836.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','131297',2618857,'1954','297',688160.22,690967.57,2807.35,350918.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','131297',2618858,'1955','297',744563.00,744563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131297',2618859,'1956','297',766219.77,768443.06,2223.29,277911.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','131297',2618860,'1957','297',1123181.84,1125751.24,2569.40,321175.00,0.00,0.00,0.00,0.00,0.00),('1','116','719','131297',2618861,'1966','298',513086.14,514714.41,1628.27,341936.70,0.00,0.00,0.00,0.00,0.00),('1','116','720','131297',2618862,'1967','297',121286.42,121286.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131297',2618863,'1968','297',685537.54,685537.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131297',2618864,'1969','297',451013.06,451013.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131297',2618865,'1970','297',492289.28,492289.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131297',2618866,'1971','297',38593.33,38593.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131297',2618867,'1972','297',43446.76,43446.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131393',2620870,'1950','297',836031.33,837227.65,1196.32,149540.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131393',2620871,'1951','297',763324.08,764880.12,1556.04,194505.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131393',2620872,'1952','297',758261.65,759964.02,1702.37,212796.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','131393',2620873,'1953','297',1025656.14,1027503.85,1847.71,230963.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','131393',2620874,'1954','297',690967.57,691877.55,909.98,113747.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','131393',2620875,'1955','297',744563.00,744563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131393',2620876,'1956','297',768443.06,769896.09,1453.03,181628.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','131393',2620877,'1957','297',1125751.24,1127363.73,1612.49,201561.25,0.00,0.00,0.00,0.00,0.00),('1','116','719','131393',2620878,'1966','298',514714.41,515359.02,644.61,135368.10,0.00,0.00,0.00,0.00,0.00),('1','116','720','131393',2620879,'1967','297',121286.42,121286.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131393',2620880,'1968','297',685537.54,685537.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131393',2620881,'1969','297',451013.06,451013.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131393',2620882,'1970','297',492289.28,492289.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131393',2620883,'1971','297',38593.33,38593.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131393',2620884,'1972','297',43446.76,43446.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131394',2620885,'1950','297',837227.65,839242.27,1994.32,249290.00,0.00,0.00,20.30,0.00,0.00),('1','116','717','131394',2620886,'1951','297',764880.12,766541.48,1640.96,205120.00,0.00,0.00,20.40,0.00,0.00),('1','116','717','131394',2620887,'1952','297',759964.02,763014.98,3040.66,380082.50,0.00,0.00,10.30,0.00,0.00),('1','116','717','131394',2620888,'1953','297',1027503.85,1027513.85,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','116','717','131394',2620889,'1954','297',691877.55,694352.32,2454.77,306846.25,0.00,0.00,20.00,0.00,0.00),('1','116','717','131394',2620890,'1955','297',744563.00,744563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131394',2620891,'1956','297',769896.09,772133.89,2217.80,277225.00,0.00,0.00,20.00,0.00,0.00),('1','116','717','131394',2620892,'1957','297',1127363.73,1129576.40,2202.67,275333.75,0.00,0.00,10.00,0.00,0.00),('1','116','719','131394',2620893,'1966','298',515359.02,517182.09,1823.07,382844.70,0.00,0.00,0.00,0.00,0.00),('1','116','720','131394',2620894,'1967','297',121286.42,121286.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131394',2620895,'1968','297',685537.54,685537.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131394',2620896,'1969','297',451013.06,451013.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131394',2620897,'1970','297',492289.28,492289.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131394',2620898,'1971','297',38593.33,38593.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131394',2620899,'1972','297',43446.76,43446.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131500',2623224,'1950','297',839242.27,840270.73,1028.46,128557.50,0.00,0.00,0.00,0.00,0.00),('1','116','717','131500',2623225,'1951','297',766541.48,767585.61,1044.13,130516.25,0.00,0.00,0.00,0.00,0.00),('1','116','717','131500',2623226,'1952','297',763014.98,764673.37,1658.39,207298.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','131500',2623227,'1953','297',1027513.85,1027513.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131500',2623228,'1954','297',694352.32,696427.43,2075.11,259388.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','131500',2623229,'1955','297',744563.00,744563.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131500',2623230,'1956','297',772133.89,773432.84,1298.95,162368.75,0.00,0.00,0.00,0.00,0.00),('1','116','717','131500',2623231,'1957','297',1129576.40,1130992.93,1416.53,177066.25,0.00,0.00,0.00,0.00,0.00),('1','116','719','131500',2623232,'1966','298',517182.09,517899.83,717.74,150725.40,0.00,0.00,0.00,0.00,0.00),('1','116','720','131500',2623233,'1967','297',121286.42,121286.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131500',2623234,'1968','297',685537.54,685537.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131500',2623235,'1969','297',451013.06,451013.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131500',2623236,'1970','297',492289.28,492289.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131500',2623237,'1971','297',38593.33,38593.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','720','131500',2623238,'1972','297',43446.76,43446.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131501',2623239,'1950','297',840270.73,840270.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','116','717','131501',2623240,'1951','297',767585.61,769582.4