-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_113
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_113`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_113` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_113`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3440 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2773,40030,'',0,'6.1','1','113','CASH','','2020-09-05 15:57:11',5,0.00,0.00,'','178','2020-09-05 15:57:11','178',0,1),(2774,20030,'',0,'20','1','113','SALES','','2020-09-05 15:57:20',5,0.00,0.00,'','178','2020-09-05 15:57:20','178',0,1),(2775,400175,'',0,'24','1','113','SALARIES ','','2020-09-05 15:57:26',5,0.00,0.00,'','178','2020-09-05 15:57:26','178',0,1),(2776,400176,'',0,'24','1','113','PURCHASES','','2020-09-05 15:57:37',5,0.00,0.00,'','178','2020-09-05 15:57:37','178',0,1),(2777,400177,'',0,'24','1','113','PUMP & GENERATOR REPAIRS','','2020-09-05 15:57:47',5,0.00,0.00,'','178','2020-09-05 15:57:47','178',0,1),(2778,400178,'',0,'24','1','113','STATION REPAIRS & MAINTAINANCE','','2020-09-05 15:58:02',5,0.00,0.00,'','178','2020-09-05 15:58:02','178',0,1),(2779,400179,'',0,'24','1','113','PRINTING & STATIONARY','','2020-09-05 15:58:12',5,0.00,0.00,'','178','2020-09-05 15:58:12','178',0,1),(2780,4031,'',0,'5','1','113','INVENTORY VALUE ADJUSTMENT','','2020-09-05 15:58:20',5,0.00,0.00,'','178','2020-09-05 15:58:20','178',0,1),(2781,40008,'',0,'6','1','113','CASH IMPREST','','2020-09-05 15:58:30',5,0.00,0.00,'','178','2020-09-05 15:58:30','178',0,1),(2782,400180,'',0,'24','1','113','ELECTRICITY & WATER BILLS','','2020-09-05 15:58:40',5,0.00,0.00,'','178','2020-09-05 15:58:40','178',0,1),(2783,400181,'',0,'24','1','113','TRANSPORT FARE','','2020-09-05 15:58:47',5,0.00,0.00,'','178','2020-09-05 15:58:47','178',0,1),(2784,400182,'',0,'24','1','113','COMPUTER & INTERNET SUBSCRIPTI','','2020-09-05 15:58:55',5,0.00,0.00,'','178','2020-09-05 15:58:55','178',0,1),(2785,400183,'',0,'24','1','113','MEDICAL EXPENSES','','2020-09-05 15:59:01',5,0.00,0.00,'','178','2020-09-05 15:59:01','178',0,1),(2786,400184,'',0,'24','1','113','OTHER OPERATING EXPENSES','','2020-09-05 15:59:08',5,0.00,0.00,'','178','2020-09-05 15:59:08','178',0,1),(2869,400293,'',0,'2','1','113','E-BILL COLLECTION ACCOUNT','','2020-10-16 14:10:34',5,0.00,0.00,'','426','2020-10-16 14:10:34','426',0,1),(2871,400294,'',0,'2','1','113','UBA BANK 1113100149','','2020-10-16 14:11:00',5,0.00,0.00,'','426','2020-10-16 14:11:00','426',0,1),(2877,400299,'',0,'2','1','113','POS UBA BANK','','2020-10-19 09:31:02',5,0.00,0.00,'','426','2020-10-19 09:31:02','426',0,1),(2878,400300,'',0,'2','1','113','POS FIDELITY BANK','','2020-10-19 09:31:15',5,0.00,0.00,'','426','2020-10-19 09:31:15','426',0,1),(2879,400301,'',0,'2','1','113','UBA BANK 1022237740','','2020-10-19 10:45:52',5,0.00,0.00,'','426','2020-10-19 10:45:52','426',0,1),(2996,400370,'',0,'2','1','113','KEYSTONE SANI LIMAN','','2020-12-04 10:20:57',5,0.00,0.00,'','426','2020-12-04 10:20:57','426',0,1),(3054,400420,'',0,'2','1','113','TRSP ACCT 1017823305','','2020-12-15 09:43:21',5,0.00,0.00,'','426','2020-12-15 09:43:21','426',0,1),(3437,400331,'',0,'24','1','113','AGO CONSUMPTION','','2021-07-06 14:55:59',5,0.00,0.00,'','426','2021-07-06 14:55:59','426',0,1),(3439,400422,'',0,'2','1','113','ECO POS','','2022-07-15 08:51:25',5,0.00,0.00,'','426','2022-07-15 08:51:25','426',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=81005 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (81004,'1','113','0000-00-00','2021-11-12 10:38:53',10,'426','','0000-00-00 00:00:00','426','2021-11-12 10:39:48');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=170940 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (170938,'1','113','81004','2905','customer',0.00,'	Sales Id 311020 for 300.00 litters of Petrol - PMS @ N162.00',48400.00,'2021-10-13'),(170939,'1','113','81004','179','supplier',48400.00,'	Sales Id 311020 for 300.00 litters of Petrol - PMS @ N162.00',0.00,'2021-11-12');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=47390 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
INSERT INTO `accounts_vouchers` VALUES (45178,'1','113','2021-07-04','208178','2773',0.00,'2021-07-08 13:28:36',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(45205,'1','113','2021-07-10','209559','2773',0.00,'2021-07-11 10:52:51',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(45212,'1','113','2021-07-11','209709','2773',0.00,'2021-07-12 10:06:42',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(45296,'1','113','2021-07-18','','2773',0.00,'2021-07-26 08:00:13',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(45297,'1','113','2021-07-25','212751','2773',0.00,'2021-07-26 08:11:58',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(45413,'1','113','2021-08-01','214433','2773',0.00,'2021-08-03 08:03:01',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(45543,'1','113','2021-08-08','216007','2773',0.00,'2021-08-09 10:12:34',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(45572,'1','113','2021-08-15','217684','2773',0.00,'2021-08-16 08:53:25',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(45659,'1','113','2021-08-22','219263','2773',0.00,'2021-08-23 14:49:26',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(45705,'1','113','2021-08-29','220942','2773',0.00,'2021-08-30 09:23:53',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(45818,'1','113','2021-09-05','222390','2773',0.00,'2021-09-06 11:12:57',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(45851,'1','113','2021-09-12','223980','2773',0.00,'2021-09-14 08:34:17',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(45878,'1','113','2021-09-19','225677','2773',0.00,'2021-09-21 08:26:19',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(45910,'1','113','2021-09-26','227294','2773',0.00,'2021-09-27 14:01:55',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(45983,'1','113','2021-10-03','228949','2773',0.00,'2021-10-04 11:14:42',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(46033,'1','113','2021-10-12','230420','2773',0.00,'2021-10-12 07:30:49',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(46034,'1','113','2021-10-12','230420','2773',0.00,'2021-10-12 07:30:50',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(46084,'1','113','2021-10-17','232272','2773',0.00,'2021-10-20 07:15:34',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(46129,'1','113','2021-10-24','233925','2773',0.00,'2021-10-26 09:14:09',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(46243,'1','113','2021-10-31','235860','2773',0.00,'2021-11-01 11:13:23',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(46304,'1','113','2021-11-07','237194','2773',0.00,'2021-11-07 13:20:20',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(46507,'1','113','2021-11-14','238902','2773',0.00,'2021-11-16 09:12:30',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(46557,'1','113','2021-11-21','240550','2773',0.00,'2021-11-22 08:43:09',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(46633,'1','113','2021-11-28','242444','2773',0.00,'2021-11-29 11:09:21',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(46634,'1','113','2021-11-28','242444','2773',0.00,'2021-11-29 11:09:22',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(46811,'1','113','2021-12-05','243937','2773',0.00,'2021-12-07 09:20:14',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(46949,'1','113','2021-12-13','245824','2773',0.00,'2021-12-15 16:35:45',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47020,'1','113','2021-12-19','247311','2773',0.00,'2021-12-23 06:15:49',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47136,'1','113','2021-12-27','','2773',0.00,'2022-01-03 09:22:00',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47137,'1','113','2022-01-02','','2773',0.00,'2022-01-03 09:23:39',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47193,'1','113','2022-01-09','252341','2773',0.00,'2022-01-10 14:50:55',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47282,'1','113','2022-01-16','254072','2773',0.00,'2022-01-18 09:54:33',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47351,'1','113','2022-01-23','255839','2773',0.00,'2022-01-24 15:11:27',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47352,'1','113','2022-01-30','257619','2773',0.00,'2022-02-07 12:59:12',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47353,'1','113','2022-02-06','257636','2773',0.00,'2022-02-07 13:00:17',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47354,'1','113','2022-02-13','257653','2773',0.00,'2022-02-14 11:40:55',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47361,'1','113','2022-02-20','257668','2773',0.00,'2022-02-22 13:08:12',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47362,'1','113','2022-02-27','257685','2773',0.00,'2022-03-07 07:58:44',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47363,'1','113','2022-03-05','257698','2773',0.00,'2022-03-15 10:47:05',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47364,'1','113','2022-03-13','257710','2773',0.00,'2022-03-15 10:48:33',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47365,'1','113','2022-03-24','257727','2773',0.00,'2022-03-25 16:27:08',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47366,'1','113','2022-03-24','257739','2773',0.00,'2022-03-25 16:33:07',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47367,'1','113','2022-04-01','257755','2773',0.00,'2022-04-03 12:19:17',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47368,'1','113','2022-05-05','257825','2773',0.00,'2022-05-28 12:45:48',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47369,'1','113','2022-05-25','257869','2773',0.00,'2022-06-27 15:21:11',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47370,'1','113','2022-05-26','257870','2773',0.00,'2022-06-27 15:24:29',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47371,'1','113','2022-05-27','257872','2773',0.00,'2022-06-27 15:26:45',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47372,'1','113','2022-05-29','257876','2773',0.00,'2022-06-27 15:29:12',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47373,'1','113','2022-06-01','287882','2773',0.00,'2022-06-27 15:31:55',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47374,'1','113','2022-06-26','257934','2773',0.00,'2022-06-27 15:36:09',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47375,'1','113','2022-07-02','257945','2773',0.00,'2022-08-02 16:44:46',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47377,'1','113','2022-07-28','258000','2773',0.00,'2022-08-02 16:46:16',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47378,'1','113','2022-07-29','258002/258003','2773',0.00,'2022-08-02 16:47:47',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47379,'1','113','2022-07-31','258006','2773',0.00,'2022-08-02 16:49:38',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47380,'1','113','2022-08-01','258010','2773',0.00,'2022-08-02 16:58:56',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47381,'1','113','2022-08-26','258064','2773',0.00,'2022-09-20 10:48:12',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47382,'1','113','2022-09-01','258077','2773',0.00,'2022-09-20 10:50:14',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47383,'1','113','2022-09-25','00000','2773',0.00,'2022-11-28 13:02:39',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47384,'1','113','2022-09-30','','2773',0.00,'2022-11-28 13:03:34',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47385,'1','113','2022-10-02','0000','2773',0.00,'2022-11-28 13:05:52',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47386,'1','113','2022-11-01','258211','2773',0.00,'2022-11-28 13:08:51',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47387,'1','113','2022-11-23','258253','2773',0.00,'2022-11-28 13:11:57',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47388,'1','113','2022-12-01','258270','2773',0.00,'2022-12-26 14:22:20',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47389,'1','113','2022-12-25','258324','2773',0.00,'2022-12-26 14:23:25',0,'530','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=87104 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
INSERT INTO `accounts_vouchers_items` VALUES (82122,'1','113',45178,3437,'AGO CONSUMPTION  280L FOR 7 DAYS',79800.00),(82152,'1','113',45205,3437,'AGO CONSUMPTION  50L FOR 1 DAY 50L AT 295  = 14,750',14750.00),(82159,'1','113',45212,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 330L AT 295 = 97,350',97350.00),(82245,'1','113',45296,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 330L AT 295 = 97,350',97350.00),(82246,'1','113',45297,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 330L AT 290 = 95,700',95700.00),(82386,'1','113',45413,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 330L AT 290 = 95,700',95700.00),(82518,'1','113',45543,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 330L AT 290 = 95,700',95700.00),(82551,'1','113',45572,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 330L AT 290 = 95,700',95700.00),(82645,'1','113',45659,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 330L AT 285 = 94,050',94050.00),(82698,'1','113',45705,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 330L AT 285 = 94,050',94050.00),(82837,'1','113',45818,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 330L AT 285 = 94,050',94050.00),(82872,'1','113',45851,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 330L AT 285 = 94,050',94050.00),(82903,'1','113',45878,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 330L AT 290 = 95,700',95700.00),(82937,'1','113',45910,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 330L AT 295 = 97350 ',97350.00),(83026,'1','113',45983,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 330L AT 300 = 99,000',99000.00),(83089,'1','113',46033,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 330L AT 320 = 105,600',105600.00),(83090,'1','113',46034,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 330L AT 320 = 105,600',105600.00),(83190,'1','113',46084,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 330L AT 320 = 105,600',105600.00),(83378,'1','113',46129,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 330L AT 340 = 112,200',112200.00),(83599,'1','113',46243,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 330L AT 340 =112,200',112200.00),(83723,'1','113',46304,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 330L AT 335= 110,550',110550.00),(84619,'1','113',46507,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 330L AT 335= 110,550',110550.00),(84742,'1','113',46557,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 330L AT 335= 110,550',110550.00),(85058,'1','113',46633,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 280L AT 335 = 93,800',93800.00),(85059,'1','113',46634,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 280L AT 335 = 93,800',93800.00),(85644,'1','113',46811,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 280L AT 335 = 93,800',93800.00),(86063,'1','113',46949,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 280L AT 335 = 93,800',93800.00),(86248,'1','113',47020,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 280L AT 335 = 93,800',93800.00),(86459,'1','113',47136,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 280L AT 335 = 93,800',93800.00),(86460,'1','113',47137,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 280L AT 330 = 92,400',92400.00),(86625,'1','113',47193,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 280L AT 330 = 92,400',92400.00),(86884,'1','113',47282,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 280L AT 330 = 92,400',92400.00),(87072,'1','113',47351,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 280L AT 350 = 98,000',98000.00),(87073,'1','113',47352,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 280L AT 360 = 100,800',100800.00),(87074,'1','113',47353,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 280L AT 380 = 106,400',106400.00),(87075,'1','113',47354,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 280L AT 400 = 112,000',112000.00),(87076,'1','113',47361,3437,'AGO CONSUMPTION  270L FOR 7 DAYS  AT 405 = 109,350',109350.00),(87077,'1','113',47362,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 270L AT 415 = 112,050',112050.00),(87078,'1','113',47363,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 200L AT 460 = 92,000',92000.00),(87079,'1','113',47364,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 200L AT  650 = 130,000',130000.00),(87080,'1','113',47365,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 350L AT 670 = 234,500',234500.00),(87081,'1','113',47366,3437,'AGO CONSUMPTION  330L FOR 7 DAYS 250L AT 285 = 167,500',167500.00),(87082,'1','113',47367,3437,'AGO CONSUMPTION 1200L FOR ONE MONTH  1200L AT 670 = 804,000',804000.00),(87083,'1','113',47368,3437,'AGO CONSUMPTION  1200L FOR 1 MONTH AT 650 = 780,000',780000.00),(87084,'1','113',47369,3437,'AGO CONSUMPTION  100L FOR 2 DAYS  AT 730 = 73,000',73000.00),(87085,'1','113',47370,3437,'AGO CONSUMPTION  40L FOR 1 DAY 40L AT 730 = 29,200',29200.00),(87086,'1','113',47371,3437,'AGO CONSUMPTION  100L FOR 2 DAYS 100L AT 730 = 73,000',73000.00),(87087,'1','113',47372,3437,'AGO CONSUMPTION  40L FOR 1 DAY 40L AT 730 = 29,200',29200.00),(87088,'1','113',47373,3437,'AGO CONSUMPTION  1,200L FOR 25 DAYS 1,200L AT 730 = 876,000',876000.00),(87089,'1','113',47374,3437,'AGO CONSUMPTION  200L FOR 4 DAYS 200L AT 780 = 156,000',156000.00),(87090,'1','113',47375,3437,'AGO CONSUMPTION  1200L FOR 24 DAYS 780L AT 770 = 936,000',936000.00),(87091,'1','113',47377,3437,'30LTS',23100.00),(87092,'1','113',47378,3437,'AGO CONSUMPTION 150L FOR 2 DAYS 115,500',115500.00),(87093,'1','113',47379,3437,'AGO CONSUMPTION 60LTS  ',46200.00),(87094,'1','113',47380,3437,'AGO CONSUMPTION  1200L FOR 25 DAYS AT 770 = 924,000',924000.00),(87095,'1','113',47381,3437,'AGO CONSUMPTION  200L FOR 4 DAYS  AT 760 = 152,000',152000.00),(87096,'1','113',47382,3437,'AGO CONSUMPTION  1200L FOR 25 DAYS L AT 760 = 912,000',912000.00),(87097,'1','113',47383,3437,'AGO CONSUMPTION  250 AT 770 = 192,500',192500.00),(87098,'1','113',47384,3437,'AGO CONSUMPTION  40LTS AT 800 = 32,000',32000.00),(87099,'1','113',47385,3437,'AGO CONSUMPTION  1,200LTS  AT 780 =936,000',936000.00),(87100,'1','113',47386,3437,'AGO CONSUMPTION  1,200LTS AT 800 = 760,000',760000.00),(87101,'1','113',47387,3437,'AGO CONSUMPTION  300LTS AT 840 = 252,000',252000.00),(87102,'1','113',47388,3437,'AGO CONSUMPTION  950LTS AT 840 = 798,000',798000.00),(87103,'1','113',47389,3437,'AGO CONSUMPTION  150LTS 820 =  123,000',123000.00);
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3319 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (2905,'','1','113','DRIVER SHORT','DRIVER','080********','driver@gmail.com','SHAGAMU','SHAGAMU','SHAGAMU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-06 14:55:22',5,'426','2021-07-06 14:55:22','426'),(3316,'','1','113','BISWALL','MAHMUD FETIH','09087990010','biswaing@gmail.com','LAGOS','LAGOS','LAGOS','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-18 14:21:46',5,'426','2021-09-18 14:21:46','426'),(3317,'','1','113','FORTUNE HIEGHTS FARM','UCHI','08034520775','fortunehfarm@gmail.com','SHAGAMU','SHAGAMU','SHAGAMU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-21 13:22:21',5,'426','2022-06-21 13:22:21','426'),(3318,'','1','113','NIGERIA POLICE FORCE (ELECTION','SP FAWI OLUMIDE','08035680521','dopstransport@gmail.com','SHAGAMU','OGUN STATE','SHAGAMU, ','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 17:26:05',5,'975','2023-02-21 17:26:05','975');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
INSERT INTO `customers_status` VALUES (1,'1','113','3317',0,'N/A','2022-06-28 16:51:44'),(2,'1','113','3317',5,'active','2022-08-01 10:45:02');
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=17733 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','113',12889,'824',0.00,20950.00,'2020-10-15','','2020-10-15 14:41:07','426','426',2020,'426','2020-10-15 14:41:07',5),('1','113',12974,'823',4726.00,18000.00,'2020-10-24','PMS','2020-10-25 10:39:19','530','530',2020,'530','2020-10-25 10:39:19',5),('1','113',13003,'823',4511.00,30000.00,'2020-10-25','','2020-10-26 12:46:06','530','530',2020,'530','2020-10-26 12:46:06',5),('1','113',13004,'823',30000.00,30000.00,'2020-10-25','','2020-10-26 12:46:07','530','530',2020,'530','2020-10-26 12:46:07',5),('1','113',13005,'823',30000.00,30000.00,'2020-10-25','pms','2020-10-26 12:46:35','530','530',2020,'530','2020-10-26 12:46:35',5),('1','113',13006,'823',30000.00,30000.00,'2020-10-25','','2020-10-26 12:47:49','530','530',2020,'530','2020-10-26 12:47:49',5),('1','113',13269,'824',2816.00,3120.00,'2020-12-07','','2020-12-08 07:40:06','530','530',2020,'530','2020-12-08 07:40:06',5),('1','113',13280,'824',1791.00,2500.00,'2020-12-11','','2020-12-11 12:37:03','530','530',2020,'530','2020-12-11 12:37:03',5),('1','113',13304,'824',3357.00,5000.00,'2020-12-15','','2020-12-16 10:10:42','530','530',2020,'530','2020-12-16 10:10:42',5),('1','113',13426,'824',1138.00,1.00,'2021-01-04','','2021-01-04 13:21:43','530','530',2021,'530','2021-01-04 13:21:43',5),('1','113',13427,'824',1.00,1.00,'2021-01-04','','2021-01-04 13:22:12','530','530',2021,'530','2021-01-04 13:22:12',5),('1','113',13485,'824',5577.00,5600.00,'2021-01-16','','2021-01-17 11:13:10','530','530',2021,'530','2021-01-17 11:13:10',5),('1','113',13616,'824',8206.00,8320.00,'2021-02-05','','2021-02-06 06:21:52','530','530',2021,'530','2021-02-06 06:21:52',5),('1','113',13693,'823',10082.00,11500.00,'2021-02-15','','2021-02-16 09:22:57','530','530',2021,'530','2021-02-16 09:22:57',5),('1','113',13753,'824',12056.00,200.00,'2021-02-20','','2021-02-22 13:16:50','530','530',2021,'530','2021-02-22 13:16:50',5),('1','113',13773,'824',1149.00,1.00,'2021-02-24','','2021-02-27 07:56:23','530','530',2021,'530','2021-02-27 07:56:23',5),('1','113',14078,'824',3800.00,5850.00,'2021-03-19','','2021-03-19 07:57:37','530','530',2021,'530','2021-03-19 07:57:37',5),('1','113',14257,'824',4919.00,2.00,'2021-03-30','','2021-03-30 13:53:38','530','530',2021,'530','2021-03-30 13:53:38',5),('1','113',14395,'824',6851.00,750.00,'2021-04-07','','2021-04-07 13:30:13','530','530',2021,'530','2021-04-07 13:30:13',5),('1','113',14396,'824',750.00,7150.00,'2021-04-07','','2021-04-07 13:31:00','530','530',2021,'530','2021-04-07 13:31:00',5),('1','113',14397,'824',7150.00,7150.00,'2021-04-07','','2021-04-07 13:31:01','530','530',2021,'530','2021-04-07 13:31:01',5),('1','113',14398,'824',7150.00,7150.00,'2021-04-07','','2021-04-07 13:31:04','530','530',2021,'530','2021-04-07 13:31:04',5),('1','113',14399,'824',7150.00,7150.00,'2021-04-07','','2021-04-07 13:31:14','530','530',2021,'530','2021-04-07 13:31:14',5),('1','113',14454,'824',5178.00,6000.00,'2021-04-10','','2021-04-11 16:23:22','530','530',2021,'530','2021-04-11 16:23:22',5),('1','113',14530,'824',194.00,4800.00,'2021-04-20','','2021-04-20 19:27:29','530','530',2021,'530','2021-04-20 19:27:29',5),('1','113',14532,'824',607.00,1120.00,'2021-04-21','','2021-04-21 05:42:30','530','530',2021,'530','2021-04-21 05:42:30',5),('1','113',14929,'824',1006.00,2500.00,'2021-05-12','','2021-05-12 13:29:50','530','530',2021,'530','2021-05-12 13:29:50',5),('1','113',15047,'824',3720.00,3950.00,'2021-05-22','','2021-05-23 09:06:06','530','530',2021,'530','2021-05-23 09:06:06',5),('1','113',15100,'824',1273.00,1600.00,'2021-05-27','','2021-05-27 13:17:12','530','530',2021,'530','2021-05-27 13:17:12',5),('1','113',15237,'824',2098.00,2500.00,'2021-06-11','','2021-06-12 07:24:00','530','530',2021,'530','2021-06-12 07:24:00',5),('1','113',15238,'823',51356.00,46900.00,'2021-06-11','','2021-06-12 11:33:36','530','530',2021,'530','2021-06-12 11:33:36',5),('1','113',15302,'824',2918.00,3500.00,'2021-06-17','','2021-06-17 10:40:09','530','530',2021,'530','2021-06-17 10:40:09',5),('1','113',15321,'824',3500.00,4650.00,'2021-06-17','','2021-06-17 13:05:37','530','530',2021,'530','2021-06-17 13:05:37',5),('1','113',17315,'823',113952.05,56150.00,'2021-10-31','','2021-10-31 05:36:23','426','426',2021,'426','2021-10-31 05:36:23',5),('1','113',17316,'824',24856.51,7900.00,'2021-10-31','','2021-10-31 05:37:12','426','426',2021,'426','2021-10-31 05:37:12',5),('1','113',17317,'825',0.00,450.00,'2021-10-31','','2021-10-31 05:37:36','426','426',2021,'426','2021-10-31 05:37:36',5),('1','113',17352,'823',44690.25,56150.00,'2021-10-31','','2021-10-31 08:36:22','426','426',2021,'426','2021-10-31 08:36:22',5),('1','113',17353,'824',4165.85,7900.00,'2021-10-31','','2021-10-31 08:36:39','426','426',2021,'426','2021-10-31 08:36:39',5),('1','113',17658,'823',102117.18,116000.00,'2021-11-16','','2021-11-16 14:32:17','426','426',2021,'426','2021-11-16 14:32:17',5),('1','113',17659,'824',38053.11,41300.00,'2021-11-16','','2021-11-16 14:32:43','426','426',2021,'426','2021-11-16 14:32:43',5),('1','113',17687,'823',76313.14,58300.00,'2021-11-18','','2021-11-18 13:23:08','426','426',2021,'426','2021-11-18 13:23:08',5),('1','113',17688,'824',27973.02,24300.00,'2021-11-18','','2021-11-18 13:23:40','426','426',2021,'426','2021-11-18 13:23:40',5),('1','113',17689,'824',302.00,1500.00,'2022-02-21','','2022-02-21 10:11:13','426','426',2022,'426','2022-02-21 10:11:13',5),('1','113',17690,'824',3047.83,3693.00,'2022-04-20','','2022-04-20 16:42:18','614','614',2022,'614','2022-04-20 16:42:18',5),('1','113',17691,'824',3693.00,4383.00,'2022-04-20','','2022-04-20 17:14:12','614','614',2022,'614','2022-04-20 17:14:12',5),('1','113',17692,'824',1529.65,3250.00,'2022-04-30','','2022-05-01 08:51:32','614','614',2022,'614','2022-05-01 08:51:32',5),('1','113',17693,'823',5021.65,5935.00,'2022-05-02','','2022-05-02 16:51:29','614','614',2022,'614','2022-05-02 16:51:29',5),('1','113',17694,'823',11710.79,11900.00,'2022-05-10','','2022-05-10 22:07:24','614','614',2022,'614','2022-05-10 22:07:24',5),('1','113',17695,'823',14732.55,15110.00,'2022-05-14','','2022-05-14 21:41:38','614','614',2022,'614','2022-05-14 21:41:38',5),('1','113',17696,'823',3403.21,4445.00,'2022-05-24','','2022-05-24 16:41:59','614','614',2022,'614','2022-05-24 16:41:59',5),('1','113',17697,'823',15558.97,22150.00,'2022-06-09','','2022-06-09 10:31:19','426','426',2022,'426','2022-06-09 10:31:19',5),('1','113',17698,'824',70.84,1600.00,'2022-06-09','','2022-06-09 10:31:37','426','426',2022,'426','2022-06-09 10:31:37',5),('1','113',17699,'824',4016.00,4600.00,'2022-06-29','','2022-06-29 22:10:47','614','614',2022,'614','2022-06-29 22:10:47',5),('1','113',17700,'824',2.06,46000.00,'2022-06-30','','2022-06-30 14:54:51','426','426',2022,'426','2022-06-30 14:54:51',5),('1','113',17701,'824',46000.00,100.00,'2022-06-30','','2022-06-30 14:56:32','426','426',2022,'426','2022-06-30 14:56:32',5),('1','113',17702,'824',100.00,46100.00,'2022-06-30','','2022-06-30 15:07:32','426','426',2022,'426','2022-06-30 15:07:32',5),('1','113',17703,'824',46100.00,50.00,'2022-06-30','','2022-06-30 15:09:28','426','426',2022,'426','2022-06-30 15:09:28',5),('1','113',17704,'824',1831.02,2120.00,'2022-07-06','','2022-07-06 19:22:32','614','614',2022,'614','2022-07-06 19:22:32',5),('1','113',17705,'824',1467.58,2400.00,'2022-08-01','','2022-08-01 21:42:18','614','614',2022,'614','2022-08-01 21:42:18',5),('1','113',17706,'824',8222.43,8600.00,'2022-08-17','','2022-08-17 22:46:44','614','614',2022,'614','2022-08-17 22:46:44',5),('1','113',17707,'824',3190.71,3900.00,'2022-09-16','','2022-09-16 22:02:08','614','614',2022,'614','2022-09-16 22:02:08',5),('1','113',17708,'823',7628.59,11000.00,'2022-09-20','','2022-09-20 14:49:53','614','614',2022,'614','2022-09-20 14:49:53',5),('1','113',17709,'824',3.80,350.00,'2022-09-28','','2022-09-28 23:11:32','614','614',2022,'614','2022-09-28 23:11:32',5),('1','113',17710,'823',12009.83,12776.00,'2022-10-05','','2022-10-05 22:36:56','614','614',2022,'614','2022-10-05 22:36:56',5),('1','113',17711,'824',50.35,300.00,'2022-10-16','','2022-10-16 22:51:53','614','614',2022,'614','2022-10-16 22:51:53',5),('1','113',17712,'824',300.00,300.00,'2022-10-16','','2022-10-16 22:52:08','614','614',2022,'614','2022-10-16 22:52:08',5),('1','113',17713,'824',300.00,300.00,'2022-10-16','','2022-10-16 22:52:09','614','614',2022,'614','2022-10-16 22:52:09',5),('1','113',17714,'823',13068.43,13500.00,'2022-10-22','','2022-10-22 22:15:12','614','614',2022,'614','2022-10-22 22:15:12',5),('1','113',17715,'823',156.51,310.00,'2022-10-24','','2022-10-24 15:02:48','614','614',2022,'614','2022-10-24 15:02:48',5),('1','113',17716,'824',1313.69,1560.00,'2022-10-25','','2022-10-25 21:50:59','614','614',2022,'614','2022-10-25 21:50:59',5),('1','113',17717,'823',6128.01,6500.00,'2022-10-27','','2022-10-27 15:03:23','614','614',2022,'614','2022-10-27 15:03:23',5),('1','113',17718,'823',89.13,700.00,'2022-11-01','','2022-11-01 21:27:18','614','614',2022,'614','2022-11-01 21:27:18',5),('1','113',17719,'823',383.41,960.00,'2022-11-07','','2022-11-07 17:30:04','614','614',2022,'614','2022-11-07 17:30:04',5),('1','113',17720,'824',7499.91,7900.00,'2022-11-09','','2022-11-09 17:40:57','614','614',2022,'614','2022-11-09 17:40:57',5),('1','113',17721,'824',2423.82,3090.00,'2022-11-18','','2022-11-18 21:38:12','614','614',2022,'614','2022-11-18 21:38:12',5),('1','113',17722,'823',1000.24,1130.00,'2022-11-24','','2022-11-24 15:19:16','614','614',2022,'614','2022-11-24 15:19:16',5),('1','113',17723,'824',209.14,270.00,'2022-12-04','','2022-12-04 10:39:06','975','975',2022,'975','2022-12-04 10:39:06',5),('1','113',17724,'823',3260.36,3500.00,'2022-12-07','','2022-12-07 15:42:55','975','975',2022,'975','2022-12-07 15:42:55',5),('1','113',17725,'824',3855.75,4550.00,'2022-12-16','','2022-12-16 11:02:57','975','975',2022,'975','2022-12-16 11:02:57',5),('1','113',17726,'824',1677.99,1900.00,'2022-12-20','','2022-12-20 18:29:33','975','975',2022,'975','2022-12-20 18:29:33',5),('1','113',17727,'824',2090.24,3500.00,'2023-01-03','','2023-01-03 15:05:19','975','975',2023,'975','2023-01-03 15:05:19',5),('1','113',17728,'823',7404.52,11500.00,'2023-01-07','','2023-01-07 11:26:44','975','975',2023,'975','2023-01-07 11:26:44',5),('1','113',17729,'824',2541.25,3000.00,'2023-01-22','','2023-01-22 22:29:14','734','734',2023,'734','2023-01-22 22:29:14',5),('1','113',17730,'824',5595.80,6300.00,'2023-02-02','','2023-02-02 14:19:05','734','734',2023,'734','2023-02-02 14:19:05',5),('1','113',17731,'824',4655.28,5500.00,'2023-02-07','','2023-02-07 10:15:12','734','734',2023,'734','2023-02-07 10:15:12',5),('1','113',17732,'824',8484.14,9100.00,'2023-02-11','','2023-02-11 10:05:39','734','734',2023,'734','2023-02-11 10:05:39',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2342 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','113','823',2326,'5','PUMP 1',1875233.01,'DISPENSING PMS','',NULL,NULL,'',5,'2020-10-15 12:57:08','178'),('1','113','823',2327,'5','PUMP 2',512471.06,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-16 11:02:53','178'),('1','113','823',2328,'5','PUMP 3',2483283.79,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-16 11:01:23','178'),('1','113','823',2329,'5','PUMP 4',1309942.82,'DISPENSING PMS','',NULL,NULL,'',5,'2020-10-15 12:58:55','178'),('1','113','823',2330,'5','PUMP 5',909827.46,'DISPENSING PMS','',NULL,NULL,'',5,'2021-04-21 11:04:11','426'),('1','113','823',2331,'5','PUMP 6',2190045.21,'DISPENSING PMS','',NULL,NULL,'',5,'2020-10-15 13:00:38','178'),('1','113','823',2332,'5','PUMP 7',15447.59,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-16 11:01:58','178'),('1','113','823',2333,'5','PUMP 8',3714187.67,'DISPENSING PMS','',NULL,NULL,'',5,'2020-10-15 13:02:58','178'),('1','113','823',2334,'5','PUMP 9',608925.60,'DISPENSING PMS','',NULL,NULL,'',5,'2020-11-16 11:02:25','178'),('1','113','823',2335,'5','PUMP 10',2212757.53,'DISPENSING PMS','',NULL,NULL,'',5,'2021-01-25 16:07:14','178'),('1','113','823',2336,'5','PUMP 11',2333179.58,'DISPENSING PMS','',NULL,NULL,'',5,'2020-10-15 13:06:22','178'),('1','113','823',2337,'5','PUMP 12',869935.17,'DISPENSING PMS','',NULL,NULL,'',5,'2020-10-15 13:08:20','178'),('1','113','824',2338,'5','AGO PUMP 13',318363.84,'DISPENSING AGO','',NULL,NULL,'',5,'2022-12-28 16:38:00','975'),('1','113','824',2339,'5','AGO PUMP 14',827726.95,'DISPENSING AGO','',NULL,NULL,'',5,'2022-04-25 12:08:49','426'),('1','113','825',2340,'5','DPK PUMP 15',1949996.31,'DISPENSING DPK','',NULL,NULL,'',5,'2020-10-15 13:10:11','178'),('1','113','825',2341,'5','DPK PUMP 16',0.00,'DISPENSING DPK',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258506 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','113',156839,'MORNING SHIFT','2020-10-01','2020-10-01 00:00:00',NULL,'530',1121509.28,0.00,'530','2020-10-15 14:59:53','530','2020-10-15 15:05:44',10,0),('1','113',156845,'MORNING SHIFT','2020-10-01','2020-10-01 00:00:00',NULL,'530',1614677.84,2309323.04,'530','2020-10-16 10:43:15','530','2020-10-16 10:45:26',10,0),('1','113',156961,'MORNING SHIFT','2020-10-02','2020-10-02 00:00:00',NULL,'530',2077391.08,2077391.08,'530','2020-10-16 10:58:29','530','2020-10-16 10:59:33',10,0),('1','113',156967,'AFTERNOON SHIFT','2020-10-02','2020-10-02 00:00:00',NULL,'530',2089241.20,2089241.20,'530','2020-10-16 11:06:09','530','2020-10-16 11:07:38',10,0),('1','113',156971,'MORNING SHIFT','2020-10-03','2020-10-03 00:00:00',NULL,'530',2024614.12,2024614.12,'530','2020-10-16 11:15:10','530','2020-10-16 11:18:04',10,0),('1','113',157108,'AFTERNOON SHIFT','2020-10-03','2020-10-03 00:00:00',NULL,'530',2360013.96,2360013.96,'530','2020-10-17 08:22:10','530','2020-10-17 08:23:27',10,0),('1','113',157117,'MORNING SHIFT','2020-10-04','2020-10-04 00:00:00',NULL,'530',1694083.50,1694083.50,'530','2020-10-17 08:44:58','530','2020-10-17 08:45:57',10,0),('1','113',157119,'AFTERNOON SHIFT','2020-10-04','2020-10-04 00:00:00',NULL,'530',2071512.40,2071512.40,'530','2020-10-17 08:57:03','530','2020-10-17 08:57:38',10,0),('1','113',157124,'MORNING SHIFT','2020-10-05','2020-10-05 00:00:00',NULL,'530',1605950.86,1605950.86,'530','2020-10-17 09:07:31','530','2020-10-17 09:09:07',10,0),('1','113',157127,'AFTERNOON SHIFT','2020-10-05','2020-10-05 00:00:00',NULL,'530',1891263.58,1891263.58,'530','2020-10-17 09:19:34','530','2020-10-17 09:20:48',10,0),('1','113',157183,'MORNING SHIFT','2020-10-06','2020-10-06 00:00:00',NULL,'530',1246680.76,1246680.76,'530','2020-10-17 13:35:24','530','2020-10-17 13:36:18',10,0),('1','113',157296,'AFTERNOON SHIFT','2020-10-06','2020-10-06 00:00:00',NULL,'530',2759943.18,2759943.18,'530','2020-10-18 07:30:17','530','2020-10-18 07:36:51',10,0),('1','113',157299,'MORNING SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'530',1831896.60,1831896.60,'530','2020-10-18 07:50:27','530','2020-10-18 07:51:25',10,0),('1','113',157302,'AFTERNOON SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'530',2480500.94,2480500.94,'530','2020-10-18 07:56:44','530','2020-10-18 08:00:30',10,0),('1','113',157305,'MORNING SHIFT','2020-10-08','2020-10-08 00:00:00',NULL,'530',1749788.64,1749788.64,'530','2020-10-18 08:26:57','530','2020-10-18 08:27:44',10,0),('1','113',157309,'AFTERNOON SHIFT','2020-10-08','2020-10-08 00:00:00',NULL,'530',2447174.26,2447174.26,'530','2020-10-19 10:22:56','530','2020-10-19 10:23:28',10,0),('1','113',157514,'MORNING SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'530',1613493.44,1613493.44,'530','2020-10-19 10:45:13','530','2020-10-19 10:47:09',10,0),('1','113',157517,'MORNING SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',157519,'MORNING SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',157520,'AFTERNOON SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'530',2234731.12,2234731.12,'530','2020-10-19 11:10:27','530','2020-10-19 11:11:09',10,0),('1','113',157526,'MORNING SHIFT','2020-10-10','2020-10-10 00:00:00',NULL,'530',1434119.60,1434119.60,'530','2020-10-19 11:33:20','530','2020-10-19 11:34:03',10,0),('1','113',157528,'AFTERNOON SHIFT','2020-10-10','2020-10-10 00:00:00',NULL,'530',2082575.58,2082575.58,'530','2020-10-19 11:39:31','530','2020-10-19 11:40:07',10,0),('1','113',157559,'MORNING SHIFT','2020-10-11','2020-10-11 00:00:00',NULL,'530',1962801.90,1962801.90,'530','2020-10-19 13:54:23','530','2020-10-19 13:55:37',10,0),('1','113',157565,'AFTERNOON SHIFT','2020-10-11','2020-10-11 00:00:00',NULL,'530',1927435.98,1927435.98,'530','2020-10-19 16:39:31','530','2020-10-19 16:40:22',10,0),('1','113',157627,'MORNING SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'530',1834562.87,1834562.87,'530','2020-10-19 16:44:38','530','2020-10-19 16:45:19',10,0),('1','113',157628,'AFTERNOON SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'530',2434011.34,2434011.34,'530','2020-10-19 16:50:34','530','2020-10-19 16:51:46',10,0),('1','113',157632,'MORNING SHIFT','2020-10-13','2020-10-13 00:00:00',NULL,'530',2639218.14,2639218.14,'530','2020-10-19 17:09:56','530','2020-10-19 17:10:52',10,0),('1','113',157634,'AFTERNOON SHIFT','2020-10-13','2020-10-13 00:00:00',NULL,'530',2491011.48,2491011.48,'530','2020-10-19 17:18:16','530','2020-10-19 17:18:40',10,0),('1','113',157681,'MORNING SHIFT','2020-10-14','2020-10-14 00:00:00',NULL,'530',1783844.89,1783844.89,'530','2020-10-20 08:31:18','530','2020-10-20 08:32:13',10,0),('1','113',157687,'AFTERNOON SHIFT','2020-10-14','2020-10-14 00:00:00',NULL,'530',2376048.52,2376048.52,'530','2020-10-20 08:45:34','530','2020-10-20 08:46:14',10,0),('1','113',157693,'MORNING SHIFT','2020-10-15','2020-10-15 00:00:00',NULL,'530',2553066.97,2553066.97,'530','2020-10-20 08:51:33','530','2020-10-20 08:55:02',10,0),('1','113',157695,'AFTERNOON SHIFT','2020-10-15','2020-10-15 00:00:00',NULL,'530',2103184.35,2103184.35,'530','2020-10-20 09:20:02','530','2020-10-20 09:22:13',10,0),('1','113',157703,'MORNING SHIFT','2020-10-16','2020-10-16 00:00:00',NULL,'530',1664970.90,1664970.90,'530','2020-10-20 09:30:09','530','2020-10-20 09:32:13',10,0),('1','113',157751,'AFTERNOON SHIFT','2020-10-16','2020-10-16 00:00:00',NULL,'530',2226410.23,2226410.23,'530','2020-10-20 13:26:44','530','2020-10-20 14:14:27',10,0),('1','113',157765,'MORNING SHIFT','2020-10-17','2020-10-17 00:00:00',NULL,'530',1880295.96,1880295.96,'530','2020-10-20 14:25:33','530','2020-10-20 14:26:28',10,0),('1','113',157855,'AFTERNOON SHIFT','2020-10-17','2020-10-17 00:00:00',NULL,'530',2438644.50,2438644.50,'530','2020-10-21 09:46:59','530','2020-10-21 09:47:20',10,0),('1','113',157857,'MORNING SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'530',1378246.42,1378246.42,'530','2020-10-21 10:02:04','530','2020-10-21 10:03:52',10,0),('1','113',157864,'AFTERNOON SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'530',1876876.48,1876876.48,'530','2020-10-21 10:13:21','530','2020-10-21 10:14:42',10,0),('1','113',157867,'MORNING SHIFT','2020-10-19','2020-10-19 00:00:00',NULL,'530',1857999.98,1857999.98,'530','2020-10-21 10:36:05','530','2020-10-21 10:36:33',10,0),('1','113',157874,'AFTERNOON SHIFT','2020-10-19','2020-10-19 00:00:00',NULL,'530',1856484.43,1856484.43,'530','2020-10-21 10:43:47','530','2020-10-21 10:44:27',10,0),('1','113',157877,'MORNING SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'530',1736212.49,1736212.49,'530','2020-10-21 10:55:51','530','2020-10-21 10:56:22',10,0),('1','113',157880,'AFTERNOON SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'530',1915455.82,1915455.82,'530','2020-10-21 11:03:39','530','2020-10-21 11:03:55',10,0),('1','113',158023,'MORNING SHIFT','2020-10-21','2020-10-21 00:00:00',NULL,'530',1291089.81,1291089.81,'530','2020-10-22 13:11:13','530','2020-10-22 13:11:42',10,0),('1','113',158026,'AFTERNOON SHIFT','2020-10-21','2020-10-21 00:00:00',NULL,'530',1370966.25,1370966.25,'530','2020-10-22 13:15:36','530','2020-10-22 13:16:02',10,0),('1','113',158027,'MORNING SHIFT','2020-10-22','2020-10-22 00:00:00',NULL,'530',1159165.92,1159165.92,'530','2020-10-22 13:21:36','530','2020-10-22 13:22:10',10,0),('1','113',158141,'AFTERNOON SHIFT','2020-10-22','2020-10-22 00:00:00',NULL,'530',1350243.27,1350243.27,'530','2020-10-23 10:53:33','530','2020-10-23 10:54:15',10,0),('1','113',158232,'MORNING SHIFT','2020-10-23','2020-10-23 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',158234,'MORNING SHIFT','2020-10-23','2020-10-23 00:00:00',NULL,'530',1191963.49,1191963.49,'530','2020-10-24 07:03:53','530','2020-10-24 07:08:12',10,0),('1','113',158268,'AFTERNOON SHIFT','2020-10-23','2020-10-23 00:00:00',NULL,'530',1696479.43,1696479.43,'530','2020-10-25 09:42:36','530','2020-10-25 09:43:42',10,0),('1','113',158444,'MORNING SHIFT','2020-10-24','2020-10-24 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',158446,'MORNING SHIFT','2020-10-24','2020-10-24 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',158448,'MORNING SHIFT','2020-10-24','2020-10-24 00:00:00',NULL,'530',1363412.30,1363412.30,'530','2020-10-25 10:07:31','530','2020-10-25 10:08:02',10,0),('1','113',158449,'AFTERNOON SHIFT','2020-10-24','2020-10-24 00:00:00',NULL,'530',1720597.50,1720597.50,'530','2020-10-25 15:23:21','530','2020-10-25 15:24:16',10,0),('1','113',158539,'MORNING SHIFT','2020-10-25','2020-10-25 00:00:00',NULL,'530',1257964.20,1257964.20,'530','2020-10-26 12:21:44','530','2020-10-26 12:22:23',10,0),('1','113',158666,'AFTERNOON SHIFT','2020-10-25','2020-10-25 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',158667,'AFTERNOON SHIFT','2020-10-25','2020-10-25 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',158669,'AFTERNOON SHIFT','2020-10-25','2020-10-25 00:00:00',NULL,'530',1442005.76,1442005.76,'530','2020-10-27 08:53:29','530','2020-10-27 08:54:00',10,0),('1','113',158793,'MORNING SHIFT','2020-10-26','2020-10-26 00:00:00',NULL,'530',1769540.50,1769540.50,'530','2020-10-27 08:57:38','530','2020-10-27 08:58:04',10,0),('1','113',158795,'AFTERNOON SHIFT','2020-10-26','2020-10-26 00:00:00',NULL,'530',1954778.40,1954778.40,'530','2020-10-27 09:04:15','530','2020-10-27 09:04:46',10,0),('1','113',158857,'MORNING SHIFT','2020-10-27','2020-10-27 00:00:00',NULL,'530',1961695.43,1961695.43,'530','2020-10-27 12:45:26','530','2020-10-27 12:46:03',10,0),('1','113',158984,'AFTERNOON SHIFT','2020-10-27','2020-10-27 00:00:00',NULL,'530',2363619.43,2363619.43,'530','2020-10-28 10:54:18','530','2020-10-28 10:54:53',10,0),('1','113',159020,'MORNING SHIFT','2020-10-28','2020-10-28 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',159023,'MORNING SHIFT','2020-10-28','2020-10-28 00:00:00',NULL,'530',2072765.03,2072765.03,'530','2020-10-28 13:07:33','530','2020-10-28 13:09:34',10,0),('1','113',159029,'AFTERNOON SHIFT','2020-10-28','2020-10-28 00:00:00',NULL,'530',2519032.33,2519032.33,'530','2020-10-29 08:14:49','530','2020-10-29 08:15:34',10,0),('1','113',159142,'MORNING SHIFT','2020-10-29','2020-10-29 00:00:00',NULL,'530',2267048.10,2267048.10,'530','2020-10-29 12:57:02','530','2020-10-29 12:58:17',10,0),('1','113',159201,'AFTERNOON SHIFT','2020-10-29','2020-10-29 00:00:00',NULL,'530',1740173.91,1740173.91,'530','2020-10-30 08:36:11','530','2020-10-30 08:37:52',10,0),('1','113',159416,'MORNING SHIFT','2020-10-30','2020-10-30 00:00:00',NULL,'530',1855058.99,1855058.99,'530','2020-10-30 15:42:24','530','2020-10-30 15:43:07',10,0),('1','113',159418,'AFTERNOON SHIFT','2020-10-30','2020-10-30 00:00:00',NULL,'530',1960195.38,1960195.38,'530','2020-10-31 07:14:27','530','2020-10-31 07:15:03',10,0),('1','113',159538,'MORNING SHIFT','2020-10-31','2020-10-31 00:00:00',NULL,'530',1275114.01,1275114.01,'530','2020-10-31 13:08:38','530','2020-10-31 13:09:16',10,0),('1','113',159540,'AFTERNOON SHIFT','2020-10-31','2020-10-31 00:00:00',NULL,'530',2540242.83,2540242.83,'530','2020-11-01 13:44:44','530','2020-11-01 13:45:08',10,0),('1','113',159684,'MORNING SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'530',0.00,0.00,'530','2020-11-01 13:46:52','530','2020-11-01 13:48:37',10,0),('1','113',159685,'MORNING SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'530',1399976.63,1399976.63,'530','2020-11-01 13:53:56','530','2020-11-01 13:54:37',10,0),('1','113',159752,'AFTERNOON SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'530',2052565.92,2052565.92,'530','2020-11-02 07:33:21','530','2020-11-02 07:33:49',10,0),('1','113',159969,'MORNING SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'530',2025494.71,2025494.71,'530','2020-11-03 07:57:00','530','2020-11-03 07:57:56',10,0),('1','113',159971,'AFTERNOON SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'530',2513052.28,2513052.28,'530','2020-11-03 08:17:13','530','2020-11-03 08:22:11',10,0),('1','113',160056,'MORNING SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'530',1151820.44,1151820.44,'530','2020-11-03 13:36:12','530','2020-11-03 13:36:42',10,0),('1','113',160059,'AFTERNOON SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'530',2302406.78,2302406.78,'530','2020-11-04 14:29:07','530','2020-11-04 14:31:46',10,0),('1','113',160264,'MORNING SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'530',2029166.74,2029166.74,'530','2020-11-04 14:36:57','530','2020-11-04 14:37:26',10,0),('1','113',160266,'AFTERNOON SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'530',3101459.43,3101459.43,'530','2020-11-05 08:30:22','530','2020-11-05 08:30:51',10,0),('1','113',160422,'MORNING SHIFT','2020-11-05','2020-11-05 00:00:00',NULL,'530',1662559.78,1662559.78,'530','2020-11-06 10:00:50','530','2020-11-06 10:01:13',10,0),('1','113',160497,'AFTERNOON SHIFT','2020-11-05','2020-11-05 00:00:00',NULL,'530',2622464.18,2622464.18,'530','2020-11-06 10:05:54','530','2020-11-06 10:06:39',10,0),('1','113',160500,'MORNING SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'530',1954151.86,1954151.86,'530','2020-11-06 13:42:06','530','2020-11-06 13:42:37',10,0),('1','113',160544,'AFTERNOON SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'530',2664633.92,2664633.92,'530','2020-11-07 13:27:07','530','2020-11-07 13:27:43',10,0),('1','113',160699,'MORNING SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'530',1714289.22,1714289.22,'530','2020-11-07 13:31:54','530','2020-11-07 13:32:25',10,0),('1','113',160703,'AFTERNOON SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'530',2033756.16,2033756.16,'530','2020-11-08 13:38:24','530','2020-11-08 13:38:48',10,0),('1','113',160834,'MORNING SHIFT','2020-11-08','2020-11-08 00:00:00',NULL,'530',1569026.47,1569026.47,'530','2020-11-08 13:46:03','530','2020-11-08 13:46:41',10,0),('1','113',160836,'AFTERNOON SHIFT','2020-11-08','2020-11-08 00:00:00',NULL,'530',1794046.97,1794046.97,'530','2020-11-09 13:28:29','530','2020-11-09 13:29:01',10,0),('1','113',161028,'AFTERNOON SHIFT','2020-11-09','2020-11-09 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',161030,'MORNING SHIFT','2020-11-09','2020-11-09 00:00:00',NULL,'530',1414761.13,1414761.13,'530','2020-11-09 13:49:21','530','2020-11-09 13:49:49',10,0),('1','113',161040,'AFTERNOON SHIFT','2020-11-09','2020-11-09 00:00:00',NULL,'530',2054467.99,2054467.99,'530','2020-11-10 14:45:13','530','2020-11-10 14:45:46',10,0),('1','113',161208,'MORNING SHIFT','2020-11-10','2020-11-10 00:00:00',NULL,'530',2204744.73,2204744.73,'530','2020-11-10 14:52:19','530','2020-11-10 14:54:02',10,0),('1','113',161213,'AFTERNOON SHIFT','2020-11-10','2020-11-10 00:00:00',NULL,'530',2534142.96,2534142.96,'530','2020-11-11 09:59:50','530','2020-11-11 10:00:24',10,0),('1','113',161399,'MORNING SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'530',1499541.56,1499541.56,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',161502,'MORNING SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'530',1490290.06,1490290.06,'530','2020-11-12 08:00:56','530','2020-11-12 08:01:30',10,0),('1','113',161503,'AFTERNOON SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'530',2353865.02,2353865.02,'530','2020-11-12 08:14:20','530','2020-11-12 08:15:34',10,0),('1','113',161579,'MORNING SHIFT','2020-11-12','2020-11-12 00:00:00',NULL,'530',2162477.64,2149360.80,'530','2020-11-12 12:59:53','530','2020-11-12 13:00:22',10,0),('1','113',161585,'AFTERNOON SHIFT','2020-11-12','2020-11-12 00:00:00',NULL,'530',2463696.52,2446231.78,'530','2020-11-13 08:10:50','530','2020-11-13 08:13:09',10,0),('1','113',161911,'MORNING SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'530',1196119.01,1185949.61,'530','2020-11-14 09:06:23','530','2020-11-14 09:06:51',10,0),('1','113',161913,'AFTERNOON SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',161922,'AFTERNOON SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',161930,'AFTERNOON SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'530',2631776.48,2631776.48,'530','2020-11-14 10:02:27','530','2020-11-14 10:02:57',10,0),('1','113',162014,'MORNING SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'530',2019538.84,2019538.84,'530','2020-11-14 15:19:53','530','2020-11-14 15:23:35',10,0),('1','113',162016,'AFTERNOON SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',162203,'AFTERNOON SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'530',2756443.34,2756443.34,'530','2020-11-15 16:22:03','530','2020-11-15 16:22:26',10,0),('1','113',162273,'MORNING SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'530',1366047.21,1366047.21,'530','2020-11-16 08:41:23','530','2020-11-16 08:42:03',10,0),('1','113',162276,'AFTERNOON SHIFT','2020-11-16','2020-11-16 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',162278,'AFTERNOON SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',162342,'AFTERNOON SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'530',2136272.11,2136272.11,'530','2020-11-16 11:44:33','530','2020-11-16 11:45:51',10,0),('1','113',162397,'MORNING SHIFT','2020-11-16','2020-11-16 00:00:00',NULL,'530',1703625.19,1703625.19,'530','2020-11-16 14:28:12','530','2020-11-16 14:28:59',10,0),('1','113',162528,'AFTERNOON SHIFT','2020-11-16','2020-11-16 00:00:00',NULL,'530',2622010.55,2622010.55,'530','2020-11-17 10:25:35','530','2020-11-17 10:27:29',10,0),('1','113',162578,'MORNING SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'530',1605906.49,1605906.49,'530','2020-11-17 13:16:13','530','2020-11-17 13:22:18',10,0),('1','113',162671,'AFTERNOON SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'530',3475098.64,3475098.64,'530','2020-11-18 08:27:09','530','2020-11-18 08:27:44',10,0),('1','113',162726,'MORNING SHIFT','2020-11-18','2020-11-18 00:00:00',NULL,'530',1697286.23,1697286.23,'530','2020-11-18 13:09:30','530','2020-11-18 13:12:00',10,0),('1','113',162849,'AFTERNOON SHIFT','2020-11-18','2020-11-18 00:00:00',NULL,'530',2166123.91,2166123.91,'530','2020-11-19 07:49:55','530','2020-11-19 07:51:01',10,0),('1','113',162960,'MORNING SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'530',2045781.95,2045781.95,'530','2020-11-19 16:37:43','530','2020-11-19 16:38:52',10,0),('1','113',163050,'AFTERNOON SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'530',2397035.81,2397035.81,'530','2020-11-20 10:56:40','530','2020-11-20 10:57:41',10,0),('1','113',163139,'MORNING SHIFT','2020-11-20','2020-11-20 00:00:00',NULL,'530',2483198.02,2483198.02,'530','2020-11-20 14:22:20','530','2020-11-20 14:24:38',10,0),('1','113',163243,'AFTERNOON SHIFT','2020-11-20','2020-11-20 00:00:00',NULL,'530',2425092.91,2425092.91,'530','2020-11-21 08:34:17','530','2020-11-21 08:35:37',10,0),('1','113',163408,'MORNING SHIFT','2020-11-21','2020-11-21 00:00:00',NULL,'530',2481484.39,2481484.39,'530','2020-11-22 08:52:23','530','2020-11-22 08:52:44',10,0),('1','113',163412,'AFTERNOON SHIFT','2020-11-21','2020-11-21 00:00:00',NULL,'530',2395301.56,2395301.56,'530','2020-11-22 08:55:59','530','2020-11-22 08:56:22',10,0),('1','113',163580,'MORNING SHIFT','2020-11-22','2020-11-22 00:00:00',NULL,'530',1588330.67,1588330.67,'530','2020-11-23 08:34:45','530','2020-11-23 08:35:27',10,0),('1','113',163584,'AFTERNOON SHIFT','2020-11-22','2020-11-22 00:00:00',NULL,'530',2780774.74,2780774.74,'530','2020-11-23 08:38:56','530','2020-11-23 08:39:28',10,0),('1','113',163667,'MORNING SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'530',1254526.98,1254526.98,'530','2020-11-23 13:06:07','530','2020-11-23 13:06:38',10,0),('1','113',163670,'AFTERNOON SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',163671,'AFTERNOON SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'530',2858488.93,2858488.93,'530','2020-11-24 14:09:29','530','2020-11-24 14:10:59',10,0),('1','113',163852,'MORNING SHIFT','2020-11-24','2020-11-24 00:00:00',NULL,'530',2017060.80,2017060.80,'530','2020-11-24 14:27:13','530','2020-11-24 14:27:55',10,0),('1','113',163958,'AFTERNOON SHIFT','2020-11-24','2020-11-24 00:00:00',NULL,'530',2196726.91,2196726.91,'530','2020-11-25 10:16:17','530','2020-11-25 10:18:35',10,0),('1','113',164083,'MORNING SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'530',2038453.53,2038453.53,'530','2020-11-25 20:52:29','530','2020-11-25 20:52:49',10,0),('1','113',164085,'AFTERNOON SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',164086,'AFTERNOON SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'530',2472510.94,2472510.94,'530','2020-11-26 10:18:40','530','2020-11-26 10:20:38',10,0),('1','113',164278,'MORNING SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'530',1630802.60,1630802.60,'530','2020-11-27 08:04:18','530','2020-11-27 08:04:58',10,0),('1','113',164299,'AFTERNOON SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',164300,'AFTERNOON SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'530',2814038.78,2814038.78,'530','2020-11-27 08:12:10','530','2020-11-27 08:12:32',10,0),('1','113',164422,'MORNING SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'530',1733158.59,1733158.59,'530','2020-11-27 16:24:16','530','2020-11-27 16:24:44',10,0),('1','113',164460,'AFTERNOON SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'530',2338123.78,2338123.78,'530','2020-11-28 08:08:51','530','2020-11-28 08:09:27',10,0),('1','113',164556,'MORNING SHIFT','2020-11-28','2020-11-28 00:00:00',NULL,'530',2064586.65,2064586.65,'530','2020-11-28 14:23:19','530','2020-11-28 14:23:40',10,0),('1','113',164794,'AFTERNOON SHIFT','2020-11-28','2020-11-28 00:00:00',NULL,'530',2904275.30,2904275.30,'530','2020-11-30 08:37:29','530','2020-11-30 08:37:58',10,0),('1','113',164796,'MORNING SHIFT','2020-11-29','2020-11-29 00:00:00',NULL,'530',1736183.53,1736183.53,'530','2020-11-30 08:52:14','530','2020-11-30 08:53:26',10,0),('1','113',164799,'AFTERNOON SHIFT','2020-11-29','2020-11-29 00:00:00',NULL,'530',1675337.11,1675337.11,'530','2020-11-30 08:58:21','530','2020-11-30 08:59:08',10,0),('1','113',164869,'MORNING SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'530',2218140.71,2218140.71,'530','2020-11-30 13:21:35','530','2020-11-30 13:22:15',10,0),('1','113',165015,'AFTERNOON SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'530',2673826.00,2673826.00,'530','2020-12-01 10:24:26','530','2020-12-01 10:24:49',10,0),('1','113',165154,'MORNING SHIFT','2020-12-01','2020-12-01 00:00:00',NULL,'530',1856887.98,1856887.98,'530','2020-12-02 08:14:42','530','2020-12-02 08:15:54',10,0),('1','113',165155,'AFTERNOON SHIFT','2020-12-01','2020-12-01 00:00:00',NULL,'530',2164539.92,2164539.92,'530','2020-12-02 08:28:46','530','2020-12-02 08:29:08',10,0),('1','113',165220,'MORNING SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'530',3136250.95,3136250.95,'530','2020-12-02 14:27:58','530','2020-12-02 14:28:31',10,0),('1','113',165327,'AFTERNOON SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',165335,'AFTERNOON SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'530',3026794.54,3026794.54,'530','2020-12-03 08:37:18','530','2020-12-03 08:37:45',10,0),('1','113',165468,'MORNING SHIFT','2020-12-03','2020-12-03 00:00:00',NULL,'530',2170298.88,2170298.88,'530','2020-12-04 07:41:08','530','2020-12-04 07:41:32',10,0),('1','113',165469,'AFTERNOON SHIFT','2020-12-03','2020-12-03 00:00:00',NULL,'530',2224202.95,2224202.95,'530','2020-12-04 07:44:45','530','2020-12-04 07:45:08',10,0),('1','113',165627,'MORNING SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'530',2756278.38,2756278.38,'530','2020-12-04 23:03:17','530','2020-12-04 23:04:56',10,0),('1','113',165653,'AFTERNOON SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',165655,'AFTERNOON SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'530',3000657.85,3000657.85,'530','2020-12-05 08:21:40','530','2020-12-05 08:22:17',10,0),('1','113',165973,'MORNING SHIFT','2020-12-05','2020-12-05 00:00:00',NULL,'530',1822331.24,1822331.24,'530','2020-12-07 08:28:32','530','2020-12-07 08:28:54',10,0),('1','113',165977,'AFTERNOON SHIFT','2020-12-05','2020-12-05 00:00:00',NULL,'530',2764656.54,2764656.54,'530','2020-12-07 08:33:58','530','2020-12-07 08:34:25',10,0),('1','113',165979,'MORNING SHIFT','2020-12-06','2020-12-06 00:00:00',NULL,'530',2060434.47,2060434.47,'530','2020-12-07 08:38:33','530','2020-12-07 08:39:07',10,0),('1','113',165983,'AFTERNOON SHIFT','2020-12-06','2020-12-06 00:00:00',NULL,'530',2142562.51,2142562.51,'530','2020-12-07 08:54:23','530','2020-12-07 08:56:45',10,0),('1','113',166162,'MORNING SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'530',1867217.85,1867217.85,'530','2020-12-08 07:44:22','530','2020-12-08 07:44:40',10,0),('1','113',166165,'AFTERNOON SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',166167,'AFTERNOON SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'530',2957375.69,2957375.69,'530','2020-12-08 12:06:27','530','2020-12-08 12:06:49',10,0),('1','113',166244,'MORNING SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'530',2209788.92,2232842.47,'530','2020-12-08 12:43:40','530','2020-12-08 12:44:14',10,0),('1','113',166350,'AFTERNOON SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'530',2679181.68,2701826.83,'530','2020-12-09 08:51:07','530','2020-12-09 08:51:27',10,0),('1','113',166414,'MORNING SHIFT','2020-12-09','2020-12-09 00:00:00',NULL,'530',2204661.94,2221841.94,'530','2020-12-09 13:39:06','530','2020-12-09 13:39:26',10,0),('1','113',166531,'AFTERNOON SHIFT','2020-12-09','2020-12-09 00:00:00',NULL,'530',4090432.14,4145123.34,'530','2020-12-10 08:34:47','530','2020-12-10 08:35:15',10,0),('1','113',166602,'MORNING SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'530',2285572.85,2305176.90,'530','2020-12-10 13:05:15','530','2020-12-10 13:07:14',10,0),('1','113',166735,'AFTERNOON SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'530',2657022.89,2678731.59,'530','2020-12-11 07:59:58','530','2020-12-11 08:00:32',10,0),('1','113',166811,'MORNING SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'530',1748711.30,1758710.45,'530','2020-12-11 12:40:16','530','2020-12-11 12:40:48',10,0),('1','113',166999,'AFTERNOON SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'530',2891361.35,2891361.35,'530','2020-12-12 15:43:13','530','2020-12-12 15:45:06',10,0),('1','113',167001,'MORNING SHIFT','2020-12-12','2020-12-12 00:00:00',NULL,'530',3247613.32,3247613.32,'530','2020-12-12 15:53:04','530','2020-12-12 15:53:38',10,0),('1','113',167150,'AFTERNOON SHIFT','2020-12-12','2020-12-12 00:00:00',NULL,'530',3553898.45,3553898.45,'530','2020-12-13 16:07:19','530','2020-12-13 16:08:21',10,0),('1','113',167154,'MORNING SHIFT','2020-12-13','2020-12-13 00:00:00',NULL,'530',2071282.41,2071282.41,'530','2020-12-13 16:21:54','530','2020-12-13 16:24:44',10,0),('1','113',167214,'AFTERNOON SHIFT','2020-12-13','2020-12-13 00:00:00',NULL,'530',1984535.06,1984535.06,'530','2020-12-14 08:54:54','530','2020-12-14 08:55:21',10,0),('1','113',167425,'MORNING SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'530',1690219.86,1690219.86,'530','2020-12-15 09:37:16','530','2020-12-15 09:37:37',10,0),('1','113',167429,'AFTERNOON SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'530',2995740.43,2995740.43,'530','2020-12-15 09:42:55','530','2020-12-15 09:44:33',10,0),('1','113',167433,'MORNING SHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',167603,'MORNING SHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'530',2147930.31,2147930.31,'530','2020-12-16 09:14:15','530','2020-12-16 09:14:36',10,0),('1','113',167605,'AFTERNOON SHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'530',2591280.98,2591280.98,'530','2020-12-16 10:15:17','530','2020-12-16 10:15:50',10,0),('1','113',167856,'MORNING SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'530',1651995.74,1651995.74,'530','2020-12-17 14:48:35','530','2020-12-17 14:49:09',10,0),('1','113',167859,'AFTERNOON SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'530',2295192.93,2295192.93,'530','2020-12-17 14:55:44','530','2020-12-17 14:56:18',10,0),('1','113',167864,'MORNING SHIFT','2020-12-17','2020-12-17 00:00:00',NULL,'530',1969839.63,1969839.63,'530','2020-12-18 09:49:06','530','2020-12-18 09:49:35',10,0),('1','113',167959,'AFTERNOON SHIFT','2020-12-17','2020-12-17 00:00:00',NULL,'530',2576836.32,2576836.32,'530','2020-12-18 09:54:25','530','2020-12-18 09:54:46',10,0),('1','113',168045,'MORNING SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'530',1997346.00,1997346.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',168229,'MORNING SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'530',1997346.00,1997346.00,'530','2020-12-19 14:22:28','530','2020-12-19 14:23:12',10,0),('1','113',168239,'AFTERNOON SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'530',3013649.02,3013649.02,'530','2020-12-20 06:58:28','530','2020-12-20 06:59:01',10,0),('1','113',168298,'MORNING SHIFT','2020-12-19','2020-12-19 00:00:00',NULL,'530',2326919.04,2326919.04,'530','2020-12-20 07:04:22','530','2020-12-20 07:04:49',10,0),('1','113',168300,'AFTERNOON SHIFT','2020-12-19','2020-12-19 00:00:00',NULL,'530',2404732.44,2404732.44,'530','2020-12-20 07:14:23','530','2020-12-20 07:19:36',10,0),('1','113',168427,'MORNING SHIFT','2020-12-20','2020-12-20 00:00:00',NULL,'530',1878619.43,1878619.43,'530','2020-12-21 06:40:41','530','2020-12-21 06:41:08',10,0),('1','113',168428,'AFTERNOON SHIFT','2020-12-20','2020-12-20 00:00:00',NULL,'530',2402578.06,2402578.06,'530','2020-12-21 06:45:34','530','2020-12-21 06:46:36',10,0),('1','113',168432,'MORNING SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',168628,'MORNING SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'530',1862868.67,1862868.67,'530','2020-12-22 06:44:11','530','2020-12-22 06:44:30',10,0),('1','113',168629,'AFTERNOON SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'530',2957352.82,2957352.82,'530','2020-12-22 06:48:24','530','2020-12-22 06:48:43',10,0),('1','113',168804,'MORNING SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'530',2184014.58,2184014.58,'530','2020-12-23 08:09:34','530','2020-12-23 08:10:00',10,0),('1','113',168806,'AFTERNOON SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'530',3688568.33,3688568.33,'530','2020-12-23 09:33:56','530','2020-12-23 09:34:34',10,0),('1','113',168955,'MORNING SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'530',3732938.03,3732938.03,'530','2020-12-24 08:16:06','530','2020-12-24 08:16:23',10,0),('1','113',168957,'AFTERNOON SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'530',3696940.52,3696940.52,'530','2020-12-24 08:24:18','530','2020-12-24 08:24:51',10,0),('1','113',169135,'MORNING SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'530',1917747.48,1917747.48,'530','2020-12-25 08:45:23','530','2020-12-25 08:45:56',10,0),('1','113',169137,'AFTERNOON SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'530',3769217.05,3769217.05,'530','2020-12-25 08:55:55','530','2020-12-25 08:56:23',10,0),('1','113',169300,'MORNING SHIFT','2020-12-25','2020-12-25 00:00:00',NULL,'530',1979078.08,1979078.08,'530','2020-12-26 08:34:21','530','2020-12-26 08:36:30',10,0),('1','113',169301,'AFTERNOON SHIFT','2020-12-25','2020-12-25 00:00:00',NULL,'530',2150027.21,2150027.21,'530','2020-12-26 08:43:52','530','2020-12-26 08:44:23',10,0),('1','113',169678,'MORNING SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'530',1538471.38,1538471.38,'530','2020-12-28 11:51:28','530','2020-12-28 11:51:54',10,0),('1','113',169682,'AFTERNOON SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'530',1715968.39,1715968.39,'530','2020-12-28 12:09:30','530','2020-12-28 12:10:18',10,0),('1','113',169693,'MORNING SHIFT','2020-12-27','2020-12-27 00:00:00',NULL,'530',1559805.20,1559805.20,'530','2020-12-28 12:51:45','530','2020-12-28 13:08:19',10,0),('1','113',169709,'AFTERNOON SHIFT','2020-12-27','2020-12-27 00:00:00',NULL,'530',1881191.07,1881191.07,'530','2020-12-28 13:47:51','530','2020-12-28 13:48:16',10,0),('1','113',169722,'MORNING SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'530',1305986.51,1305986.51,'530','2020-12-28 13:53:11','530','2020-12-28 13:53:46',10,0),('1','113',169797,'AFTERNOON SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'530',1878305.12,1878305.12,'530','2020-12-29 08:24:14','530','2020-12-29 08:24:40',10,0),('1','113',169996,'MORNING SHIFT','2020-12-29','2020-12-29 00:00:00',NULL,'530',1416375.78,1416375.78,'530','2020-12-30 10:47:15','530','2020-12-30 10:50:42',10,0),('1','113',169998,'AFTERNOON SHIFT','2020-12-29','2020-12-29 00:00:00',NULL,'530',2362810.53,2362810.53,'530','2020-12-30 11:04:14','530','2020-12-30 11:04:42',10,0),('1','113',170191,'MORNING SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'530',1756463.20,1761734.16,'530','2020-12-31 09:46:11','530','2020-12-31 09:46:34',10,0),('1','113',170195,'AFTERNOON SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'530',2406852.19,2413232.25,'530','2020-12-31 09:52:25','530','2020-12-31 09:52:48',10,0),('1','113',170383,'MORNING SHIFT','2020-12-31','2020-12-31 00:00:00',NULL,'530',1742689.29,1746155.29,'530','2021-01-01 10:37:00','530','2021-01-01 10:37:28',10,0),('1','113',170388,'AFTERNOON SHIFT','2020-12-31','2020-12-31 00:00:00',NULL,'530',3288729.90,3299552.44,'530','2021-01-01 10:43:50','530','2021-01-01 10:44:21',10,0),('1','113',170415,'MORNING SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'530',1572337.42,1576771.02,'530','2021-01-01 12:42:00','530','2021-01-01 12:42:49',10,0),('1','113',170529,'AFTERNOON SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'530',1590808.17,1592534.23,'530','2021-01-02 08:58:52','530','2021-01-02 08:59:28',10,0),('1','113',170856,'MORNING SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'530',1940770.97,1949786.17,'530','2021-01-04 09:53:09','530','2021-01-04 09:53:47',10,0),('1','113',170859,'AFTERNOON SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'530',2032622.52,2038953.08,'530','2021-01-04 10:01:23','530','2021-01-04 10:06:53',10,0),('1','113',170864,'MORNING SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'530',1364479.06,1367321.06,'530','2021-01-04 10:15:32','530','2021-01-04 10:15:56',10,0),('1','113',170867,'AFTERNOON SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'530',1931759.51,1937457.05,'530','2021-01-04 10:19:32','530','2021-01-04 10:20:16',10,0),('1','113',170914,'MORNING SHIFT','2021-01-04','2021-01-04 00:00:00',NULL,'530',1481109.85,1481109.85,'530','2021-01-04 13:36:49','530','2021-01-04 13:37:12',10,0),('1','113',171072,'MORNING SHIFT','2021-01-04','2021-01-04 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',171074,'AFTERNOON SHIFT','2021-01-04','2021-01-04 00:00:00',NULL,'530',2294489.91,2294489.91,'530','2021-01-05 10:37:40','530','2021-01-05 10:39:00',10,0),('1','113',171169,'MORNING SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'530',1589990.80,1589990.80,'530','2021-01-05 15:11:19','530','2021-01-05 15:12:23',10,0),('1','113',171256,'AFTERNOON SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'530',2872109.41,2872109.41,'530','2021-01-06 10:16:00','530','2021-01-06 10:16:56',10,0),('1','113',171430,'MORNING SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'530',2146591.40,2146591.40,'530','2021-01-07 10:08:09','530','2021-01-07 10:08:39',10,0),('1','113',171431,'AFTERNOON SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'530',4001498.00,4001498.00,'530','2021-01-07 10:18:38','530','2021-01-07 10:19:44',10,0),('1','113',171655,'MORNING SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'530',2182495.04,2182495.04,'530','2021-01-08 11:16:58','530','2021-01-08 11:17:28',10,0),('1','113',171658,'AFTERNOON SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'530',4091218.57,4091218.57,'530','2021-01-08 11:21:59','530','2021-01-08 11:22:28',10,0),('1','113',171806,'MORNING SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'530',2861477.94,2861477.94,'530','2021-01-09 09:00:19','530','2021-01-09 09:00:39',10,0),('1','113',171809,'AFTERNOON SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'530',3808624.43,3808624.43,'530','2021-01-09 09:03:47','530','2021-01-09 09:06:30',10,0),('1','113',171881,'MORNING SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'530',2249443.87,2249443.87,'530','2021-01-09 13:52:38','530','2021-01-09 13:53:59',10,0),('1','113',172107,'AFTERNOON SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'530',3100435.18,3100435.18,'530','2021-01-11 07:58:28','530','2021-01-11 07:59:51',10,0),('1','113',172108,'MORNING SHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'530',1801150.14,1801150.14,'530','2021-01-11 08:03:00','530','2021-01-11 08:04:47',10,0),('1','113',172110,'AFTERNOON SHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'530',2661179.72,2661179.72,'530','2021-01-11 08:12:28','530','2021-01-11 08:12:46',10,0),('1','113',172336,'MORNING SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'530',1754586.84,1754586.84,'530','2021-01-12 10:30:38','530','2021-01-12 10:30:58',10,0),('1','113',172338,'AFTERNOON SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'530',2995938.66,2995938.66,'530','2021-01-12 10:34:21','530','2021-01-12 10:34:46',10,0),('1','113',172387,'MORNING SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'530',1530138.02,1530138.02,'530','2021-01-12 13:22:06','530','2021-01-12 13:22:30',10,0),('1','113',172540,'AFTERNOON SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',172568,'AFTERNOON SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'530',5071754.09,5071754.09,'530','2021-01-13 10:03:02','530','2021-01-13 10:03:29',10,0),('1','113',172712,'MORNING SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'530',2300767.66,2300767.66,'530','2021-01-14 07:53:26','530','2021-01-14 07:56:47',10,0),('1','113',172713,'AFTERNOON SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'530',2731021.22,2731021.22,'530','2021-01-14 08:01:02','530','2021-01-14 08:01:32',10,0),('1','113',172798,'MORNING SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'530',3119509.18,3119509.18,'530','2021-01-14 13:27:14','530','2021-01-14 13:27:56',10,0),('1','113',172920,'AFTERNOON SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'530',2824175.42,2824175.42,'530','2021-01-15 10:18:02','530','2021-01-15 10:19:16',10,0),('1','113',173119,'MORNING SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'530',2270698.53,2270698.53,'530','2021-01-16 11:47:17','530','2021-01-16 11:49:17',10,0),('1','113',173121,'AFTERNOON SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',173125,'AFTERNOON SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'530',2975311.64,2975311.64,'530','2021-01-16 12:06:16','530','2021-01-16 12:06:43',10,0),('1','113',173272,'MORNING SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'530',2423702.47,2423702.47,'530','2021-01-17 11:07:36','530','2021-01-17 11:08:08',10,0),('1','113',173274,'AFTERNOON SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'530',2914575.72,2914575.72,'530','2021-01-17 11:15:11','530','2021-01-17 11:15:35',10,0),('1','113',173419,'MORNING SHIFT','2021-01-17','2021-01-17 00:00:00',NULL,'530',2715376.30,2715376.30,'530','2021-01-18 08:25:58','530','2021-01-18 08:26:26',10,0),('1','113',173423,'AFTERNOON SHIFT','2021-01-17','2021-01-17 00:00:00',NULL,'530',3193678.39,3193678.39,'530','2021-01-18 08:34:41','530','2021-01-18 08:35:12',10,0),('1','113',173622,'MORNING SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'530',2171278.69,2171278.69,'530','2021-01-19 08:40:45','530','2021-01-19 08:41:18',10,0),('1','113',173631,'AFTERNOON SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'530',3786689.90,3786689.90,'530','2021-01-19 08:58:26','530','2021-01-19 08:58:53',10,0),('1','113',173798,'MORNING SHIFT','2021-01-19','2021-01-19 00:00:00',NULL,'530',1979075.07,1979075.07,'530','2021-01-20 09:22:00','530','2021-01-20 09:22:25',10,0),('1','113',173800,'AFTERNOON SHIFT','2021-01-19','2021-01-19 00:00:00',NULL,'530',3493112.35,3493112.35,'530','2021-01-20 09:27:46','530','2021-01-20 09:28:32',10,0),('1','113',173974,'MORNING SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'530',1879998.26,1879998.26,'530','2021-01-21 09:04:28','530','2021-01-21 09:04:52',10,0),('1','113',174027,'AFTERNOON SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'530',3621249.38,3630061.89,'530','2021-01-21 11:50:34','530','2021-01-21 11:52:28',10,0),('1','113',174250,'MORNING SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'530',2652093.77,2658260.01,'530','2021-01-22 14:43:21','530','2021-01-22 14:43:54',10,0),('1','113',174256,'AFTERNOON SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'530',3484926.88,3492405.56,'530','2021-01-22 14:51:13','530','2021-01-22 14:51:34',10,0),('1','113',174260,'MORNING SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'530',2318618.34,2322879.93,'530','2021-01-22 15:00:14','530','2021-01-22 15:00:52',10,0),('1','113',174342,'AFTERNOON SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'530',3118496.42,3124319.80,'530','2021-01-23 07:57:23','530','2021-01-23 07:58:04',10,0),('1','113',174343,'MORNING SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',174652,'MORNING SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'530',2752266.14,2759526.20,'530','2021-01-25 06:40:17','530','2021-01-25 06:40:51',10,0),('1','113',174728,'AFTERNOON SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'530',3058035.10,3058035.10,'530','2021-01-25 11:31:30','530','2021-01-25 11:31:51',10,0),('1','113',174731,'MORNING SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'530',2175556.00,2175556.00,'530','2021-01-25 11:51:25','530','2021-01-25 11:52:33',10,0),('1','113',174739,'AFTERNOON SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',174820,'AFTERNOON SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'530',2444928.10,2444928.10,'530','2021-01-25 17:20:34','530','2021-01-25 17:21:17',10,0),('1','113',174825,'MORNING SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'530',2118915.20,2118915.20,'530','2021-01-25 17:25:15','530','2021-01-25 17:26:03',10,0),('1','113',174852,'AFTERNOON SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'530',3176653.10,3176653.10,'530','2021-01-26 06:48:41','530','2021-01-26 06:49:05',10,0),('1','113',175082,'MORNING SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'530',2016980.70,2016980.70,'530','2021-01-27 08:41:23','530','2021-01-27 08:41:49',10,0),('1','113',175084,'AFTERNOON SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',175088,'AFTERNOON SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'530',2867317.90,2867317.90,'530','2021-01-27 09:02:54','530','2021-01-27 09:03:49',10,0),('1','113',175230,'MORNING SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'530',2240249.15,2240249.15,'530','2021-01-27 18:59:56','530','2021-01-27 19:00:43',10,0),('1','113',175275,'AFTERNOON SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'530',3272155.55,3272155.55,'530','2021-01-28 09:01:12','530','2021-01-28 09:02:10',10,0),('1','113',175441,'MORNING SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'530',2195744.40,2195744.40,'530','2021-01-29 08:37:53','530','2021-01-29 08:38:14',10,0),('1','113',175446,'AFTERNOON SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'530',2333230.55,2333230.55,'530','2021-01-29 08:44:06','530','2021-01-29 08:44:36',10,0),('1','113',175612,'MORNING SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'530',1458696.00,1458696.00,'530','2021-01-30 08:47:18','530','2021-01-30 08:47:38',10,0),('1','113',175613,'AFTERNOON SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'530',2189267.20,2189267.20,'530','2021-01-30 08:50:59','530','2021-01-30 08:51:24',10,0),('1','113',175827,'MORNING SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'530',1323249.60,1323249.60,'530','2021-01-31 11:45:43','530','2021-01-31 11:46:11',10,0),('1','113',176022,'AFTERNOON SHIFT','2021-01-30','2021-01-30 00:00:00',NULL,'530',3009704.25,3009704.25,'530','2021-02-01 11:38:17','530','2021-02-01 11:38:39',10,0),('1','113',176026,'MORNING SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'530',1665439.15,1665439.15,'530','2021-02-01 11:42:53','530','2021-02-01 11:43:30',10,0),('1','113',176031,'AFTERNOON SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'530',2121852.60,2121852.60,'530','2021-02-01 11:49:38','530','2021-02-01 11:50:07',10,0),('1','113',176174,'MORNING SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'530',2286727.30,2286727.30,'530','2021-02-02 08:58:43','530','2021-02-02 08:59:14',10,0),('1','113',176337,'AFTERNOON SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'530',2946377.45,2946377.45,'530','2021-02-03 05:50:03','530','2021-02-03 05:50:52',10,0),('1','113',176338,'MORNING SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'530',1723633.45,1723633.45,'530','2021-02-03 05:56:48','530','2021-02-03 05:57:10',10,0),('1','113',176340,'AFTERNOON SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'530',2702821.20,2702821.20,'530','2021-02-03 06:00:50','530','2021-02-03 06:01:21',10,0),('1','113',176342,'MORNING SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'530',1764980.65,1764980.65,'530','2021-02-04 06:11:20','530','2021-02-04 06:11:47',10,0),('1','113',176560,'AFTERNOON SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'530',3630439.85,3630439.85,'530','2021-02-04 06:15:28','530','2021-02-04 06:15:56',10,0),('1','113',176937,'MORNING SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'530',2661918.60,2661918.60,'530','2021-02-05 17:02:54','530','2021-02-05 17:03:16',10,0),('1','113',176940,'AFTERNOON SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'530',2771610.10,2771610.10,'530','2021-02-05 17:06:34','530','2021-02-05 17:07:22',10,0),('1','113',176992,'MORNING SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',176993,'MORNING SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'530',3155891.40,3155891.40,'530','2021-02-06 06:15:02','530','2021-02-06 06:15:26',10,0),('1','113',176994,'AFTERNOON SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'530',3778811.60,3778811.60,'530','2021-02-06 06:24:55','530','2021-02-06 06:25:33',10,0),('1','113',177624,'MORNING SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'530',2189234.80,2189234.80,'530','2021-02-08 22:12:37','530','2021-02-08 22:13:08',10,0),('1','113',177625,'AFTERNOON SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'530',2926620.40,2926620.40,'530','2021-02-08 22:18:44','530','2021-02-08 22:19:27',10,0),('1','113',177626,'MORNING SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'530',2158715.40,2158715.40,'530','2021-02-08 22:26:47','530','2021-02-08 22:27:33',10,0),('1','113',177627,'AFTERNOON SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'530',2387229.20,2387229.20,'530','2021-02-08 22:31:59','530','2021-02-08 22:32:44',10,0),('1','113',177628,'MORNING SHIFT','2021-02-08','2021-02-08 00:00:00',NULL,'530',2246927.20,2246927.20,'530','2021-02-08 22:37:57','530','2021-02-08 22:39:05',10,0),('1','113',177629,'AFTERNOON SHIFT','2021-02-08','2021-02-08 00:00:00',NULL,'530',1910393.60,1910393.60,'530','2021-02-08 22:44:17','530','2021-02-08 22:44:49',10,0),('1','113',177915,'MORNING SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'530',3148943.60,3148943.60,'530','2021-02-10 09:25:19','530','2021-02-10 09:26:36',10,0),('1','113',177918,'AFTERNOON SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',177920,'AFTERNOON SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'530',3387033.78,3387033.78,'530','2021-02-10 09:36:43','530','2021-02-10 09:37:31',10,0),('1','113',178068,'MORNING SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'530',3161104.00,3188634.64,'530','2021-02-10 19:43:12','530','2021-02-10 19:43:39',10,0),('1','113',178310,'AFTERNOON SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'530',3160432.00,3196830.34,'530','2021-02-12 08:19:01','530','2021-02-12 08:19:48',10,0),('1','113',178312,'MORNING SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'530',2053670.20,2079112.27,'530','2021-02-12 08:32:14','530','2021-02-12 08:41:10',10,0),('1','113',178354,'AFTERNOON SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'530',3186983.29,3186983.29,'530','2021-02-12 11:01:25','530','2021-02-12 11:02:47',10,0),('1','113',178372,'MORNING SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',178373,'MORNING SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'530',2116073.37,2116073.37,'530','2021-02-12 12:52:22','530','2021-02-12 12:52:57',10,0),('1','113',178554,'AFTERNOON SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'530',2732656.82,2732656.82,'530','2021-02-13 10:06:02','530','2021-02-13 10:32:00',10,0),('1','113',178613,'MORNING SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'530',2137997.39,2137997.39,'530','2021-02-13 13:41:32','530','2021-02-13 13:42:16',10,0),('1','113',178774,'AFTERNOON SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'530',3072228.90,3072228.90,'530','2021-02-14 10:33:35','530','2021-02-14 10:34:44',10,0),('1','113',178816,'MORNING SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'530',2443969.12,2443969.12,'530','2021-02-14 13:53:01','530','2021-02-14 13:53:34',10,0),('1','113',178955,'AFTERNOON SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'530',2764047.96,2764047.96,'530','2021-02-15 09:25:33','530','2021-02-15 09:26:22',10,0),('1','113',179177,'MORNING SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'530',2569080.37,2569080.37,'530','2021-02-16 09:21:26','530','2021-02-16 09:21:54',10,0),('1','113',179183,'AFTERNOON SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',179188,'AFTERNOON SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'530',2430079.61,2430079.61,'530','2021-02-16 09:52:38','530','2021-02-16 09:55:38',10,0),('1','113',179385,'MORNING SHIFT','2021-02-16','2021-02-16 00:00:00',NULL,'530',2121071.67,2121071.67,'530','2021-02-17 08:08:41','530','2021-02-17 08:09:14',10,0),('1','113',179386,'AFTERNOON SHIFT','2021-02-16','2021-02-16 00:00:00',NULL,'530',2980061.99,2980061.99,'530','2021-02-17 08:12:36','530','2021-02-17 08:12:57',10,0),('1','113',179745,'MORNING SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'530',3332628.38,3332628.38,'530','2021-02-18 17:45:50','530','2021-02-18 17:46:59',10,0),('1','113',179746,'AFTERNOON SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'530',3369571.20,3369571.20,'530','2021-02-18 17:51:22','530','2021-02-18 17:52:11',10,0),('1','113',179749,'MORNING SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',179750,'MORNING SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'530',1953502.84,1953502.84,'530','2021-02-18 18:14:47','530','2021-02-18 18:15:29',10,0),('1','113',179782,'AFTERNOON SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'530',2953050.81,2953050.81,'530','2021-02-19 07:31:18','530','2021-02-19 07:31:46',10,0),('1','113',180011,'MORNING SHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'530',2202149.69,2202149.69,'530','2021-02-20 08:44:27','530','2021-02-20 08:44:51',10,0),('1','113',180013,'AFTERNOON SHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'530',3633645.82,3633645.82,'530','2021-02-20 09:28:32','530','2021-02-20 09:28:58',10,0),('1','113',180219,'MORNING SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'530',2450343.11,2450343.11,'530','2021-02-21 11:18:28','530','2021-02-21 11:18:54',10,0),('1','113',180238,'AFTERNOON SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'530',3402623.79,3402623.79,'530','2021-02-22 13:37:03','530','2021-02-22 13:37:29',10,0),('1','113',180471,'MORNING SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'530',3255978.47,3255978.47,'530','2021-02-22 13:40:20','530','2021-02-22 13:41:37',10,0),('1','113',180472,'AFTERNOON SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'530',3105098.10,3105098.10,'530','2021-02-22 13:46:06','530','2021-02-22 13:46:45',10,0),('1','113',180480,'MORNING SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'530',2600983.43,2600983.43,'530','2021-02-22 14:17:54','530','2021-02-22 14:19:02',10,0),('1','113',180608,'AFTERNOON SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'530',3894240.30,3894240.30,'530','2021-02-23 10:15:58','530','2021-02-23 10:16:27',10,0),('1','113',180801,'MORNING SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'530',2682850.78,2682850.78,'530','2021-02-24 10:26:46','530','2021-02-24 10:27:12',10,0),('1','113',180805,'AFTERNOON SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',180809,'AFTERNOON SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'530',3849390.43,3849390.43,'530','2021-02-24 10:50:26','530','2021-02-24 11:01:44',10,0),('1','113',181355,'MORNING SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'530',2285728.49,2285728.49,'530','2021-02-27 08:43:36','530','2021-02-27 08:44:28',10,0),('1','113',181358,'AFTERNOON SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'530',4044720.56,4044720.56,'530','2021-02-27 09:18:25','530','2021-02-27 09:19:17',10,0),('1','113',181370,'MORNING SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'530',2794240.77,2794240.77,'530','2021-02-27 09:23:10','530','2021-02-27 09:23:34',10,0),('1','113',181371,'AFTERNOON SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'530',1560807.68,1560807.68,'530','2021-02-27 09:27:10','530','2021-02-27 09:27:34',10,0),('1','113',181374,'MORNING SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',181375,'MORNING SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'530',2136242.43,2136242.43,'530','2021-02-27 09:40:46','530','2021-02-27 09:41:12',10,0),('1','113',181378,'AFTERNOON SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'530',3861633.00,3861633.00,'530','2021-02-27 09:46:38','530','2021-02-27 09:47:21',10,0),('1','113',181537,'MORNING SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'530',1949406.41,1949406.41,'530','2021-02-28 08:02:06','530','2021-02-28 08:04:44',10,0),('1','113',181539,'AFTERNOON SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'530',3327191.05,3327191.05,'530','2021-02-28 08:11:46','530','2021-02-28 08:12:26',10,0),('1','113',181798,'MORNING SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'530',1681284.17,1681284.17,'530','2021-03-01 13:36:29','530','2021-03-01 13:37:07',10,0),('1','113',181801,'AFTERNOON SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'530',2976247.87,2976247.87,'530','2021-03-01 13:52:46','530','2021-03-01 13:53:17',10,0),('1','113',181985,'MORNING SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'530',2525117.75,2525117.75,'530','2021-03-02 10:55:55','530','2021-03-02 10:56:20',10,0),('1','113',181988,'AFTERNOON SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'530',3642725.80,3642725.80,'530','2021-03-02 11:20:38','530','2021-03-02 11:21:51',10,0),('1','113',182091,'MORNING SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'530',2545680.07,2545680.07,'530','2021-03-02 18:58:51','530','2021-03-02 18:59:20',10,0),('1','113',182348,'AFTERNOON SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'530',4172180.94,4172180.94,'530','2021-03-04 09:46:31','530','2021-03-04 09:47:04',10,0),('1','113',182356,'MORNING SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'530',2609927.74,2609927.74,'530','2021-03-04 09:55:30','530','2021-03-04 09:57:37',10,0),('1','113',182361,'AFTERNOON SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'530',4053570.64,4053570.64,'530','2021-03-04 10:14:15','530','2021-03-04 10:14:58',10,0),('1','113',182527,'MORNING SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'530',2364331.17,2364331.17,'530','2021-03-05 08:51:34','530','2021-03-05 08:52:20',10,0),('1','113',182536,'AFTERNOON SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'530',3877813.52,3877813.52,'530','2021-03-05 09:37:26','530','2021-03-05 09:37:57',10,0),('1','113',182860,'MORNING SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'530',2702582.79,2702582.79,'530','2021-03-07 08:35:06','530','2021-03-07 08:36:27',10,0),('1','113',182861,'AFTERNOON SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'530',3070867.42,3070867.42,'530','2021-03-07 08:41:39','530','2021-03-07 08:42:06',10,0),('1','113',182862,'MORNING SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'530',2647601.00,2647601.00,'530','2021-03-07 08:49:18','530','2021-03-07 08:50:08',10,0),('1','113',182996,'AFTERNOON SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'530',4711823.04,4711823.04,'530','2021-03-08 07:53:00','530','2021-03-08 08:08:17',10,0),('1','113',183002,'MORNING SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'530',2468925.49,2468925.49,'530','2021-03-08 08:14:24','530','2021-03-08 08:15:00',10,0),('1','113',183006,'AFTERNOON SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'530',3063902.60,3063902.60,'530','2021-03-08 08:19:52','530','2021-03-08 08:20:44',10,0),('1','113',183246,'MORNING SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'530',2723087.47,2723087.47,'530','2021-03-09 09:10:43','530','2021-03-09 09:11:11',10,0),('1','113',183425,'AFTERNOON SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'530',4974436.87,4974436.87,'530','2021-03-10 06:33:14','530','2021-03-10 06:34:51',10,0),('1','113',183429,'MORNING SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'530',3081376.54,3081376.54,'530','2021-03-10 06:40:13','530','2021-03-10 06:41:26',10,0),('1','113',183641,'AFTERNOON SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',183645,'AFTERNOON SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'530',4881272.48,4881272.48,'530','2021-03-11 06:34:57','530','2021-03-11 06:35:31',10,0),('1','113',183646,'MORNING SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'530',3281484.09,3281484.09,'530','2021-03-11 06:42:41','530','2021-03-11 06:43:22',10,0),('1','113',183648,'AFTERNOON SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'530',5131689.93,5131689.93,'530','2021-03-11 06:57:51','530','2021-03-11 06:58:40',10,0),('1','113',183776,'MORNING SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'530',2592599.11,2592599.11,'530','2021-03-11 22:06:56','530','2021-03-11 22:07:21',10,0),('1','113',183860,'AFTERNOON SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'530',3933827.93,3933827.93,'530','2021-03-12 06:21:37','530','2021-03-12 06:30:09',10,0),('1','113',183882,'MORNING SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',184169,'MORNING SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'530',3000775.00,3000775.00,'530','2021-03-13 14:51:42','530','2021-03-13 14:52:03',10,0),('1','113',184172,'AFTERNOON SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'530',4726491.78,4726491.78,'530','2021-03-13 14:55:44','530','2021-03-13 14:56:07',10,0),('1','113',184174,'MORNING SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'530',1774132.36,1774132.36,'530','2021-03-13 15:01:36','530','2021-03-13 15:02:06',10,0),('1','113',184481,'AFTERNOON SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',184482,'AFTERNOON SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'530',4478186.80,4478186.80,'530','2021-03-15 07:13:14','530','2021-03-15 07:13:41',10,0),('1','113',184483,'MORNING SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'530',2051369.55,2051369.55,'530','2021-03-15 07:19:31','530','2021-03-15 07:19:55',10,0),('1','113',184487,'AFTERNOON SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'530',2742132.65,2742132.65,'530','2021-03-15 07:23:11','530','2021-03-15 07:23:35',10,0),('1','113',184489,'MORNING SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'530',2394675.10,2394675.10,'530','2021-03-16 08:32:28','530','2021-03-16 08:32:48',10,0),('1','113',184728,'AFTERNOON SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'530',3012724.00,3012724.00,'530','2021-03-16 08:36:15','530','2021-03-16 08:36:37',10,0),('1','113',184732,'MORNING SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'530',2365596.35,2365596.35,'530','2021-03-17 07:35:14','530','2021-03-17 07:35:54',10,0),('1','113',184907,'AFTERNOON SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'530',3330243.70,3330243.70,'530','2021-03-17 07:46:21','530','2021-03-17 07:47:07',10,0),('1','113',184911,'MORNING SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'530',2296026.00,2296026.00,'530','2021-03-18 08:49:19','530','2021-03-18 08:50:35',10,0),('1','113',185143,'AFTERNOON SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'530',3996469.75,3996469.75,'530','2021-03-18 08:54:06','530','2021-03-18 08:54:38',10,0),('1','113',185147,'MORNING SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'530',2431584.35,2431584.35,'530','2021-03-18 22:05:24','614','2021-03-18 22:12:10',10,0),('1','113',185272,'AFTERNOON SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'530',3629315.35,3629315.35,'530','2021-03-19 08:00:26','614','2021-03-19 08:43:36',10,0),('1','113',185305,'MORNING SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'530',2866885.45,2866885.45,'530','2021-03-19 14:21:52','614','2021-03-19 14:32:21',10,0),('1','113',185485,'AFTERNOON SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'530',3302922.10,3302922.10,'530','2021-03-20 08:03:55','614','2021-03-20 12:24:51',10,0),('1','113',185558,'MORNING SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'530',1676560.80,1676560.80,'530','2021-03-20 13:28:50','614','2021-03-20 16:42:43',10,0),('1','113',185636,'AFTERNOON SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',185637,'AFTERNOON SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'530',4636402.12,4636402.12,'530','2021-03-21 08:31:55','614','2021-03-21 09:01:25',10,0),('1','113',185765,'MORNING SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'530',1567442.58,1567442.58,'530','2021-03-21 13:23:33','614','2021-03-21 15:07:01',10,0),('1','113',185888,'AFTERNOON SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'530',2810169.46,2810169.46,'530','2021-03-22 13:02:10','614','2021-03-22 13:34:16',10,0),('1','113',185977,'MORNING SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'530',2044224.32,2044224.32,'530','2021-03-22 13:55:09','614','2021-03-22 21:26:10',10,0),('1','113',186121,'AFTERNOON SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'530',3091911.34,3091911.34,'530','2021-03-23 08:31:40','614','2021-03-23 08:50:48',10,0),('1','113',186239,'MORNING SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'530',1866157.16,1866157.16,'530','2021-03-23 15:15:08','614','2021-03-23 19:54:58',10,0),('1','113',186365,'AFTERNOON SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'530',3901995.16,3901995.16,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',186392,'AFTERNOON SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'530',3825000.86,3825000.86,'530','2021-03-24 10:29:30','614','2021-03-24 17:35:09',10,0),('1','113',186495,'MORNING SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'530',2499218.32,2499218.32,'530','2021-03-24 22:04:03','614','2021-03-25 12:14:03',10,0),('1','113',186636,'AFTERNOON SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'530',4025732.84,4025732.84,'530','2021-03-25 13:11:27','614','2021-03-25 13:19:32',10,0),('1','113',186653,'MORNING SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'530',2337615.36,2337615.36,'530','2021-03-25 13:45:07','614','2021-03-25 18:52:06',10,0),('1','113',186784,'AFTERNOON SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'530',3204574.06,3204574.06,'530','2021-03-26 08:24:33','614','2021-03-26 10:17:53',10,0),('1','113',186821,'MORNING SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'530',2978312.04,2978312.04,'530','2021-03-26 14:02:42','614','2021-03-26 15:48:27',10,0),('1','113',186916,'AFTERNOON SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',186919,'AFTERNOON SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'530',3413451.89,3413451.89,'530','2021-03-27 08:01:57','614','2021-03-27 12:21:41',10,0),('1','113',187055,'MORNING SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'530',2037112.05,2037112.05,'530','2021-03-27 12:54:31','614','2021-03-27 13:42:20',10,0),('1','113',187162,'AFTERNOON SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'530',3618975.67,3618975.67,'530','2021-03-28 07:16:14','614','2021-03-28 08:58:44',10,0),('1','113',187260,'MORNING SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'530',2915344.89,2915344.89,'530','2021-03-28 13:15:34','614','2021-03-28 14:26:32',10,0),('1','113',187355,'AFTERNOON SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'530',2632906.89,2632906.89,'530','2021-03-29 06:55:11','614','2021-03-29 12:41:37',10,0),('1','113',187459,'MORNING SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'530',3177361.46,3177361.46,'530','2021-03-29 13:01:40','614','2021-03-29 13:51:33',10,0),('1','113',187591,'AFTERNOON SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'530',4161866.20,4161866.20,'530','2021-03-30 07:13:43','614','2021-03-30 10:30:27',10,0),('1','113',187671,'MORNING SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'530',2723065.85,2723065.85,'530','2021-03-30 13:22:34','614','2021-03-30 22:29:50',10,0),('1','113',187805,'AFTERNOON SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'530',2970315.98,2970315.98,'530','2021-03-31 06:54:40','614','2021-03-31 11:28:40',10,0),('1','113',187932,'MORNING SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'530',1553843.05,1553843.05,'530','2021-03-31 14:01:49','614','2021-04-01 07:45:47',10,0),('1','113',188075,'AFTERNOON SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'530',1447705.00,1447705.00,'530','2021-04-01 11:00:06','614','2021-04-01 14:32:30',10,0),('1','113',188157,'MORNING SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'530',1418797.50,1418797.50,'530','2021-04-01 16:06:49','614','2021-04-01 16:57:29',10,0),('1','113',188286,'AFTERNOON SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'530',3045259.58,3045259.58,'530','2021-04-02 10:45:56','614','2021-04-02 14:33:16',10,0),('1','113',188342,'MORNING SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'530',2736410.93,2736410.93,'530','2021-04-02 15:12:17','614','2021-04-02 15:18:06',10,0),('1','113',188396,'AFTERNOON SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'530',3577549.19,3577549.19,'530','2021-04-03 07:12:08','614','2021-04-03 08:07:19',10,0),('1','113',188545,'MORNING SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'530',3236144.66,3236144.66,'530','2021-04-03 15:40:54','614','2021-04-03 17:17:01',10,0),('1','113',188701,'AFTERNOON SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'530',4016730.33,4016730.33,'530','2021-04-04 14:05:39','614','2021-04-04 16:11:41',10,0),('1','113',188758,'MORNING SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'530',2304974.49,2304974.49,'530','2021-04-05 09:19:33','614','2021-04-05 09:22:47',10,0),('1','113',188856,'AFTERNOON SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'530',3672155.58,3672155.58,'530','2021-04-05 09:38:40','614','2021-04-05 10:37:01',10,0),('1','113',188910,'MORNING SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'530',3152569.38,3152569.38,'530','2021-04-05 13:57:36','614','2021-04-05 14:39:35',10,0),('1','113',189026,'AFTERNOON SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'530',4449261.38,4449261.38,'530','2021-04-06 07:32:45','614','2021-04-06 09:50:21',10,0),('1','113',189095,'MORNING SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'530',2918127.86,2918127.86,'530','2021-04-06 12:36:45','614','2021-04-06 13:49:30',10,0),('1','113',189226,'AFTERNOON SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'530',4270275.55,4270275.55,'530','2021-04-07 07:43:03','614','2021-04-07 08:29:15',10,0),('1','113',189318,'MORNING SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'530',3348558.93,3348558.93,'530','2021-04-07 13:41:28','614','2021-04-07 17:16:16',10,0),('1','113',189481,'AFTERNOON SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'530',4654893.79,4654893.79,'530','2021-04-08 10:16:00','614','2021-04-08 10:34:59',10,0),('1','113',189594,'MORNING SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'530',3994698.03,3994698.03,'530','2021-04-08 21:55:47','614','2021-04-09 07:10:01',10,0),('1','113',189633,'AFTERNOON SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'530',3599872.87,3599872.87,'530','2021-04-09 07:31:48','614','2021-04-09 13:40:36',10,0),('1','113',189749,'MORNING SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'530',2561002.83,2561002.83,'530','2021-04-09 18:02:19','614','2021-04-09 22:06:30',10,0),('1','113',189826,'AFTERNOON SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'530',3960167.67,3960167.67,'530','2021-04-10 07:19:40','614','2021-04-10 11:24:39',10,0),('1','113',190017,'MORNING SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'530',3110392.98,3110392.98,'530','2021-04-10 23:01:21','614','2021-04-11 15:40:47',10,0),('1','113',190152,'AFTERNOON SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'530',3527656.13,3527656.13,'530','2021-04-11 17:23:42','614','2021-04-11 21:06:56',10,0),('1','113',190266,'MORNING SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'530',2269358.72,2269358.72,'530','2021-04-12 10:05:12','614','2021-04-12 10:47:30',10,0),('1','113',190298,'AFTERNOON SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'530',3390834.90,3390834.90,'530','2021-04-12 11:55:58','614','2021-04-12 14:49:02',10,0),('1','113',190377,'MORNING SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'530',2969856.80,2969856.80,'530','2021-04-12 17:20:55','614','2021-04-12 21:22:58',10,0),('1','113',190463,'AFTERNOON SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'530',5550896.38,5550896.38,'530','2021-04-13 08:23:48','614','2021-04-13 10:05:10',10,0),('1','113',190501,'MORNING SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',190556,'MORNING SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'530',2745375.25,2745375.25,'530','2021-04-13 12:58:40','614','2021-04-13 16:43:29',10,0),('1','113',190717,'AFTERNOON SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'530',3650114.77,3678050.35,'530','2021-04-14 10:18:37','614','2021-04-14 12:04:48',10,0),('1','113',190809,'MORNING SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'530',2925386.35,2943399.25,'530','2021-04-14 14:18:56','614','2021-04-14 18:57:23',10,0),('1','113',190934,'AFTERNOON SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'530',3190510.96,3214991.80,'530','2021-04-15 09:09:55','614','2021-04-15 09:17:27',10,0),('1','113',191009,'MORNING SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'530',3120086.38,3136747.90,'530','2021-04-15 19:11:23','614','2021-04-16 09:14:45',10,0),('1','113',191176,'AFTERNOON SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'530',3092004.00,3092004.00,'530','2021-04-16 11:36:24','614','2021-04-16 14:21:59',10,0),('1','113',191214,'MORNING SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'530',2735739.75,2735739.75,'530','2021-04-16 14:53:09','614','2021-04-16 20:52:11',10,0),('1','113',191308,'AFTERNOON SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'530',3548730.80,3548730.80,'530','2021-04-17 07:41:50','614','2021-04-17 09:37:36',10,0),('1','113',191352,'MORNING SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'530',2611952.10,2611952.10,'530','2021-04-18 04:40:50','614','2021-04-18 08:32:13',10,0),('1','113',191527,'AFTERNOON SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'530',3911372.70,3911372.70,'530','2021-04-18 08:47:23','614','2021-04-18 09:26:59',10,0),('1','113',191584,'MORNING SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'530',2282567.80,2282567.80,'530','2021-04-18 14:14:44','614','2021-04-18 16:54:12',10,0),('1','113',191696,'AFTERNOON SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'530',2961279.20,2961279.20,'530','2021-04-19 06:48:46','614','2021-04-19 10:06:45',10,0),('1','113',191849,'MORNING SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'530',2075152.75,2075152.75,'530','2021-04-19 13:20:23','614','2021-04-19 21:22:25',10,0),('1','113',191958,'AFTERNOON SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'530',3723731.85,3723731.85,'530','2021-04-20 08:49:56','614','2021-04-20 09:27:17',10,0),('1','113',192109,'MORNING SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'530',2238099.85,2238099.85,'530','2021-04-20 19:32:27','614','2021-04-20 20:49:44',10,0),('1','113',192122,'AFTERNOON SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'530',7191800.40,2141300.40,'530','2021-04-21 06:25:32','614','2021-04-21 10:00:18',10,0),('1','113',192255,'MORNING SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'530',1221001.65,1221001.65,'530','2021-04-21 13:40:51','614','2021-04-21 15:04:15',10,0),('1','113',192334,'AFTERNOON SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'530',1896237.75,1896237.75,'530','2021-04-22 09:54:06','614','2021-04-22 12:28:44',10,0),('1','113',192465,'MORNING SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'530',994809.75,994809.75,'530','2021-04-22 13:08:03','614','2021-04-22 16:59:19',10,0),('1','113',192597,'AFTERNOON SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'530',2103849.00,2103849.00,'530','2021-04-23 08:22:46','614','2021-04-23 09:00:23',10,0),('1','113',192658,'MORNING SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'530',1235696.55,1235696.55,'530','2021-04-23 13:09:35','614','2021-04-23 13:37:43',10,0),('1','113',192766,'AFTERNOON SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'530',2151448.20,2151448.20,'530','2021-04-24 07:38:08','614','2021-04-24 10:52:14',10,0),('1','113',192853,'MORNING SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'530',1340026.05,1340026.05,'530','2021-04-24 13:01:11','614','2021-04-24 20:27:08',10,0),('1','113',192996,'AFTERNOON SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'530',2279099.80,2279099.80,'530','2021-04-25 09:50:43','614','2021-04-25 11:17:41',10,0),('1','113',193064,'MORNING SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'530',3708179.55,3708179.55,'530','2021-04-25 13:43:25','614','2021-04-25 21:11:25',10,0),('1','113',193191,'AFTERNOON SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'530',2847126.90,2847126.90,'530','2021-04-26 07:32:20','614','2021-04-26 11:51:53',10,0),('1','113',193313,'MORNING SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'530',2382442.95,2382442.95,'530','2021-04-26 14:03:30','614','2021-04-26 14:11:26',10,0),('1','113',193431,'AFTERNOON SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'530',3854136.80,3854136.80,'530','2021-04-27 07:48:48','614','2021-04-27 11:32:06',10,0),('1','113',193527,'MORNING SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'530',2260496.80,2260496.80,'530','2021-04-27 13:30:27','614','2021-04-27 13:57:11',10,0),('1','113',193608,'AFTERNOON SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'530',3641164.90,3641164.90,'530','2021-04-27 22:05:50','614','2021-04-28 10:00:57',10,0),('1','113',193734,'MORNING SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'530',1191620.10,1191620.10,'530','2021-04-28 13:22:14','614','2021-04-28 14:09:34',10,0),('1','113',193765,'MORNING SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'530',779432.50,779432.50,'530','2021-04-28 14:14:56','614','2021-04-28 14:45:08',10,0),('1','113',193873,'AFTERNOON SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'530',3082930.05,3082930.05,'530','2021-04-29 07:53:39','614','2021-04-29 09:43:10',10,0),('1','113',193989,'MORNING SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'530',2520953.55,2520953.55,'530','2021-04-29 13:06:42','614','2021-04-29 13:33:18',10,0),('1','113',194074,'AFTERNOON SHIFT 1','2021-04-29','2021-04-29 00:00:00',NULL,'530',621571.50,621571.50,'530','2021-04-30 05:29:23','614','2021-04-30 12:29:42',10,0),('1','113',194213,'AFTERNOON SHIFT 2','2021-04-29','2021-04-29 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',194217,'AFTERNOON SHIFT 2','2021-04-29','2021-04-29 00:00:00',NULL,'530',2740459.37,2740459.37,'530','2021-04-30 15:10:20','614','2021-04-30 15:19:50',10,0),('1','113',194307,'MORNING SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'530',2889759.38,2889759.38,'530','2021-05-01 08:10:04','614','2021-05-01 13:56:37',10,0),('1','113',194413,'AFTERNOON SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'530',3240781.65,3240781.65,'530','2021-05-01 14:35:17','614','2021-05-01 15:28:13',10,0),('1','113',194436,'MORNING SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'530',1955979.04,1955979.04,'530','2021-05-01 15:59:42','614','2021-05-01 16:16:21',10,0),('1','113',194504,'AFTERNOON SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'530',3621697.52,3621697.52,'530','2021-05-02 07:35:27','614','2021-05-02 12:47:29',10,0),('1','113',194587,'MORNING SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'530',2049172.46,2049172.46,'530','2021-05-02 14:29:10','614','2021-05-02 15:57:43',10,0),('1','113',194700,'AFTERNOON SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'530',2350633.08,2350633.08,'530','2021-05-03 07:51:19','614','2021-05-03 08:33:37',10,0),('1','113',194771,'MORNING SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'530',1826290.75,1826290.75,'530','2021-05-03 13:00:50','614','2021-05-03 16:19:51',10,0),('1','113',194874,'AFTERNOON SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'530',3716641.35,3716641.35,'530','2021-05-04 07:39:31','614','2021-05-04 12:25:23',10,0),('1','113',194948,'MORNING SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'530',2485237.81,2485237.81,'530','2021-05-04 13:09:59','614','2021-05-04 16:39:38',10,0),('1','113',195089,'AFTERNOON SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'530',3256880.92,3256880.92,'530','2021-05-05 07:02:53','614','2021-05-05 09:49:24',10,0),('1','113',195209,'MORNING SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'530',2203864.86,2203864.86,'530','2021-05-05 13:05:44','614','2021-05-05 21:06:48',10,0),('1','113',195358,'AFTERNOON SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'530',3014702.67,3014702.67,'530','2021-05-06 09:17:56','426','2021-05-06 10:47:05',10,0),('1','113',195441,'MORNING SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'530',3088181.32,3088181.32,'530','2021-05-07 11:45:40','614','2021-05-07 11:47:07',10,0),('1','113',195653,'AFTERNOON SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'530',5351700.00,4342437.36,'530','2021-05-07 11:57:04','614','2021-05-07 11:59:55',10,0),('1','113',195655,'MORNING SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'530',3462542.50,2741135.02,'530','2021-05-07 12:33:09','614','2021-05-07 14:35:46',10,0),('1','113',195831,'AFTERNOON SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'530',4251605.00,3234728.99,'530','2021-05-08 08:50:37','614','2021-05-08 09:19:10',10,0),('1','113',195855,'MORNING SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'530',3099020.00,2403114.83,'530','2021-05-08 13:12:58','614','2021-05-08 16:05:47',10,0),('1','113',195981,'AFTERNOON SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'530',4818300.00,3700465.71,'530','2021-05-08 21:38:22','614','2021-05-09 05:32:42',10,0),('1','113',196037,'MORNING SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'530',2619072.50,1936831.55,'530','2021-05-09 13:03:44','614','2021-05-09 13:31:43',10,0),('1','113',196246,'AFTERNOON SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'530',4004100.00,2970393.84,'530','2021-05-10 07:09:53','426','2021-05-10 07:47:10',10,0),('1','113',196353,'MORNING SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'530',3307610.00,2506995.98,'530','2021-05-10 13:18:05','614','2021-05-10 13:28:31',10,0),('1','113',196428,'AFTERNOON SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'530',7821345.00,6539004.15,'530','2021-05-10 22:10:41','614','2021-05-11 03:47:28',10,0),('1','113',196531,'MORNING SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'530',1889243.48,1889243.48,'530','2021-05-11 13:07:33','614','2021-05-11 15:04:31',10,0),('1','113',196641,'AFTERNOON SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'530',3479546.91,3479546.91,'530','2021-05-11 22:11:09','614','2021-05-12 09:31:00',10,0),('1','113',196739,'MORNING SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'530',1750054.20,1750054.20,'530','2021-05-12 13:33:21','614','2021-05-12 15:32:44',10,0),('1','113',197000,'AFTERNOON SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'530',2085536.10,2085536.10,'530','2021-05-13 20:04:42','614','2021-05-14 07:24:11',10,0),('1','113',197058,'MORNING SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'530',1996954.40,1996954.40,'530','2021-05-14 07:59:26','614','2021-05-14 08:02:14',10,0),('1','113',197068,'AFTERNOON SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'530',2300183.95,2300183.95,'530','2021-05-14 08:16:07','614','2021-05-14 08:52:25',10,0),('1','113',197129,'MORNING SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'530',2139652.56,2139652.56,'530','2021-05-14 13:03:01','614','2021-05-14 14:27:09',10,0),('1','113',197211,'AFTERNOON SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'530',4029413.70,4029413.70,'530','2021-05-14 22:02:19','426','2021-05-16 12:47:39',10,0),('1','113',197437,'MORNING SHIFT','2021-05-15','2021-05-15 00:00:00',NULL,'530',2695134.81,2695134.81,'530','2021-05-16 22:06:55','614','2021-05-17 05:37:51',10,0),('1','113',197515,'AFTERNOON SHIFT','2021-05-15','2021-05-15 00:00:00',NULL,'530',2969356.01,2969356.01,'530','2021-05-17 06:36:35','614','2021-05-17 06:42:41',10,0),('1','113',197530,'MORNING SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'530',1942583.07,1942583.07,'530','2021-05-17 07:14:37','614','2021-05-17 10:33:32',10,0),('1','113',197633,'AFTERNOON SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'530',3003794.44,3003794.44,'530','2021-05-17 11:02:00','614','2021-05-17 13:27:18',10,0),('1','113',197818,'MORNING SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'530',2864843.20,2864843.20,'530','2021-05-17 18:06:06','614','2021-05-17 18:27:35',10,0),('1','113',197847,'AFTERNOON SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'530',3460521.81,3460521.81,'530','2021-05-17 21:36:16','614','2021-05-17 22:30:15',10,0),('1','113',197932,'MORNING SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'530',2078331.24,2078331.24,'530','2021-05-18 13:03:27','614','2021-05-18 13:11:33',10,0),('1','113',198110,'AFTERNOON SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',198112,'MORNING SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'530',4249871.82,4249871.82,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',198172,'AFTERNOON SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'530',4203850.07,4249871.82,'530','2021-05-19 09:34:54','614','2021-05-19 10:12:31',10,0),('1','113',198224,'MORNING SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'530',2318871.34,2343458.34,'530','2021-05-19 13:14:00','614','2021-05-19 14:44:02',10,0),('1','113',198360,'AFTERNOON SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'530',3416011.99,3446559.49,'530','2021-05-20 06:54:14','614','2021-05-20 12:22:09',10,0),('1','113',198472,'MORNING SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'530',3293192.91,3336324.56,'530','2021-05-20 13:55:43','614','2021-05-21 06:36:39',10,0),('1','113',198578,'AFTERNOON SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'530',3678385.43,3716296.53,'530','2021-05-21 07:03:24','614','2021-05-21 08:22:33',10,0),('1','113',198620,'MORNING SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'530',2263611.30,2284873.30,'530','2021-05-21 12:38:57','614','2021-05-21 14:22:20',10,0),('1','113',198793,'AFTERNOON SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'530',3758720.35,3794727.65,'530','2021-05-22 07:08:28','614','2021-05-22 09:12:28',10,0),('1','113',198893,'MORNING SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'530',1321912.73,1328840.83,'530','2021-05-22 12:58:27','614','2021-05-23 08:03:04',10,0),('1','113',199025,'AFTERNOON SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'530',3063657.11,3083319.71,'530','2021-05-23 09:08:38','614','2021-05-23 13:16:27',10,0),('1','113',199129,'MORNING SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'530',2356085.74,2383311.74,'530','2021-05-23 14:32:17','614','2021-05-23 15:03:40',10,0),('1','113',199203,'AFTERNOON SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',199204,'AFTERNOON SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'530',2473748.46,2473748.46,'530','2021-05-24 05:57:55','614','2021-05-24 10:30:12',10,0),('1','113',199329,'MORNING SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'530',2282858.61,2282858.61,'530','2021-05-24 12:59:52','614','2021-05-24 13:43:08',10,0),('1','113',199422,'AFTERNOON SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'530',4517704.65,4517704.65,'530','2021-05-25 05:20:37','614','2021-05-25 06:32:29',10,0),('1','113',199482,'MORNING SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'530',2220819.54,2220819.54,'530','2021-05-25 12:54:46','614','2021-05-25 13:14:45',10,0),('1','113',199616,'AFTERNOON SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'530',4116912.04,4116912.04,'530','2021-05-26 06:36:11','614','2021-05-26 08:37:26',10,0),('1','113',199787,'MORNING SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'530',2214771.60,2214771.60,'530','2021-05-26 13:00:57','614','2021-05-26 14:15:05',10,0),('1','113',199884,'AFTERNOON SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'530',3371235.86,3371235.86,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',199952,'AFTERNOON SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'530',3371235.86,3371235.86,'530','2021-05-27 10:28:55','614','2021-05-27 10:50:54',10,0),('1','113',200000,'MORNING SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'530',1810299.16,1810299.16,'530','2021-05-27 13:24:43','614','2021-05-27 14:02:44',10,0),('1','113',200252,'AFTERNOON SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',200253,'AFTERNOON SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'530',420554.73,420554.73,'530','2021-05-29 08:42:07','614','2021-05-29 09:50:05',10,0),('1','113',200350,'AFTERNOON SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'530',4099205.08,4099205.08,'530','2021-05-29 10:31:17','614','2021-05-29 12:11:05',10,0),('1','113',200391,'MORNING SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'530',2629955.31,2629955.31,'530','2021-05-29 13:09:14','614','2021-05-29 14:32:03',10,0),('1','113',200509,'AFTERNOON SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'530',3123614.80,3123614.80,'530','2021-05-30 07:47:47','614','2021-05-30 09:33:25',10,0),('1','113',200587,'MORNING SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'530',2428949.81,2428949.81,'530','2021-05-30 12:37:12','614','2021-05-30 13:54:25',10,0),('1','113',200676,'AFTERNOON SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'530',2635741.77,2635741.77,'530','2021-05-31 05:17:15','614','2021-05-31 05:21:56',10,0),('1','113',200761,'MORNING SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'530',2001090.41,2001090.41,'530','2021-05-31 13:02:35','614','2021-05-31 13:42:17',10,0),('1','113',200891,'AFTERNOON SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'530',3724656.29,3724656.29,'530','2021-05-31 22:03:19','614','2021-06-01 05:19:24',10,0),('1','113',200968,'MORNING SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'530',2940826.69,2940826.69,'530','2021-06-01 12:57:42','614','2021-06-01 15:18:37',10,0),('1','113',201107,'AFTERNOON SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'530',4727011.24,4727011.24,'530','2021-06-02 05:58:14','614','2021-06-02 11:19:44',10,0),('1','113',201252,'MORNING SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'530',2378903.88,2378903.88,'530','2021-06-02 21:40:55','614','2021-06-03 07:09:46',10,0),('1','113',201336,'AFTERNOON SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'530',3542426.92,3542426.92,'530','2021-06-03 07:28:03','614','2021-06-03 12:31:46',10,0),('1','113',201425,'MORNING SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'530',2734531.87,2734531.87,'530','2021-06-03 14:28:34','614','2021-06-03 18:48:06',10,0),('1','113',201537,'AFTERNOON SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'530',3748230.53,3748230.53,'530','2021-06-04 08:47:07','614','2021-06-04 09:19:12',10,0),('1','113',201567,'MORNING SHIFT 1','2021-06-04','2021-06-04 00:00:00',NULL,'530',1101480.45,1101480.45,'530','2021-06-04 09:38:17','614','2021-06-04 09:50:15',10,0),('1','113',201625,'MORNING SHIFT 2','2021-06-04','2021-06-04 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',201647,'MORNING SHIFT 2','2021-06-04','2021-06-04 00:00:00',NULL,'530',2156260.06,2156260.06,'530','2021-06-04 14:37:04','614','2021-06-04 15:57:39',10,0),('1','113',201755,'AFTERNOON SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'530',3590717.98,3590717.98,'530','2021-06-05 09:14:15','614','2021-06-05 09:16:38',10,0),('1','113',201888,'MORNING SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'530',2483189.03,2483189.03,'530','2021-06-05 13:07:20','614','2021-06-05 14:47:05',10,0),('1','113',202037,'AFTERNOON SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'530',3331916.22,3331916.22,'530','2021-06-06 06:48:06','614','2021-06-06 07:10:48',10,0),('1','113',202092,'MORNING SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'530',1770802.35,1770802.35,'530','2021-06-06 12:57:52','614','2021-06-06 13:16:15',10,0),('1','113',202232,'AFTERNOON SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'530',2836180.16,2836180.16,'530','2021-06-07 06:57:40','614','2021-06-07 11:50:40',10,0),('1','113',202336,'MORNING SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'530',2464148.99,2464148.99,'530','2021-06-07 15:39:27','614','2021-06-08 05:19:30',10,0),('1','113',202437,'MORNING SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'530',2619501.59,2619501.59,'530','2021-06-08 06:41:05','614','2021-06-08 10:29:22',10,0),('1','113',202539,'MORNING SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'530',3090046.63,3090046.63,'530','2021-06-08 13:55:05','614','2021-06-08 15:55:04',10,0),('1','113',202620,'AFTERNOON SHIFT ','2021-06-08','2021-06-08 00:00:00',NULL,'530',3639290.83,3639290.83,'530','2021-06-09 05:21:31','614','2021-06-09 12:25:33',10,0),('1','113',202762,'MORNING SHIFT ','2021-06-09','2021-06-09 00:00:00',NULL,'530',2494899.66,2494899.66,'530','2021-06-09 13:21:10','614','2021-06-09 18:01:22',10,0),('1','113',202831,'AFTERNOON SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'530',2931705.08,2931705.08,'530','2021-06-10 05:40:31','614','2021-06-10 06:42:34',10,0),('1','113',202942,'MORNING SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'530',2452763.97,2452763.97,'530','2021-06-10 13:38:55','614','2021-06-10 14:18:28',10,0),('1','113',203089,'AFTERNOON SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'530',3618448.16,3618448.16,'530','2021-06-11 06:54:54','614','2021-06-11 10:19:49',10,0),('1','113',203209,'MORNING SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'530',2897880.96,2897880.96,'530','2021-06-11 12:36:04','614','2021-06-11 12:56:45',10,0),('1','113',203332,'AFTERNOON SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'530',3381531.42,3381531.42,'530','2021-06-12 07:27:52','614','2021-06-12 08:54:00',10,0),('1','113',203395,'MORNING SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'530',2159755.27,2159755.27,'530','2021-06-12 13:39:24','614','2021-06-12 17:56:48',10,0),('1','113',203540,'AFTERNOON SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'530',1672282.23,1672282.23,'530','2021-06-13 07:32:50','614','2021-06-13 12:44:34',10,0),('1','113',203639,'MORNING SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'530',1852867.08,1852867.08,'530','2021-06-13 13:54:07','614','2021-06-13 14:04:04',10,0),('1','113',203742,'AFTERNOON SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'530',2644688.68,2644688.68,'530','2021-06-14 06:49:30','614','2021-06-14 08:21:47',10,0),('1','113',203852,'MORNING SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'530',2637263.52,2637263.52,'530','2021-06-14 13:26:03','614','2021-06-14 14:21:57',10,0),('1','113',203943,'AFTERNOON SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'530',3267439.76,3267439.76,'530','2021-06-15 08:24:00','614','2021-06-15 11:16:15',10,0),('1','113',204061,'MORNING SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'530',2594337.29,2594337.29,'530','2021-06-15 12:56:12','614','2021-06-15 14:57:53',10,0),('1','113',204168,'AFTERNOON SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'530',3738488.32,3738488.32,'530','2021-06-15 22:18:31','614','2021-06-16 08:48:24',10,0),('1','113',204309,'MORNING SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'530',2070593.33,2070593.33,'530','2021-06-16 13:27:19','614','2021-06-16 15:33:29',10,0),('1','113',204379,'AFTERNOON SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'530',4884751.41,4884751.41,'530','2021-06-17 06:58:22','614','2021-06-17 07:56:20',10,0),('1','113',204490,'MORNING SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'530',2275247.18,2275247.18,'530','2021-06-17 13:08:52','614','2021-06-17 13:58:09',10,0),('1','113',204646,'AFTERNOON SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'530',2525924.68,2525924.68,'530','2021-06-18 07:30:29','614','2021-06-18 10:42:17',10,0),('1','113',204724,'MORNING SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'530',2871106.12,2871106.12,'530','2021-06-18 13:00:38','614','2021-06-18 13:29:47',10,0),('1','113',204848,'AFTERNOON SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'530',3562087.41,3562087.41,'530','2021-06-19 07:10:07','614','2021-06-19 09:51:58',10,0),('1','113',204940,'MORNING SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'530',2659731.49,2659731.49,'530','2021-06-19 12:50:47','614','2021-06-19 12:59:10',10,0),('1','113',205054,'AFTERNOON SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'530',1750222.87,1750222.87,'530','2021-06-20 09:37:46','614','2021-06-20 10:38:43',10,0),('1','113',205142,'MORNING SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'530',2219911.58,2219911.58,'530','2021-06-20 13:20:26','614','2021-06-20 14:22:15',10,0),('1','113',205206,'AFTERNOON SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'530',2641845.80,2641845.80,'530','2021-06-21 06:38:55','614','2021-06-21 07:21:40',10,0),('1','113',205281,'MORNING SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'530',2511011.97,2511011.97,'530','2021-06-21 12:52:02','426','2021-06-21 14:20:27',10,0),('1','113',205394,'AFTERNOON SHIFT 1','2021-06-21','2021-06-21 00:00:00',NULL,'530',484812.00,484812.00,'530','2021-06-21 16:45:44','614','2021-06-21 16:47:36',10,0),('1','113',205450,'AFTERNOON SHIFT 2','2021-06-21','2021-06-21 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',205451,'AFTERNOON SHIFT 2','2021-06-21','2021-06-21 00:00:00',NULL,'530',3400567.05,3400567.05,'530','2021-06-22 06:59:49','614','2021-06-22 10:04:15',10,0),('1','113',205596,'MORNING SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'530',3159313.95,3159313.95,'530','2021-06-22 12:59:18','614','2021-06-22 14:33:39',10,0),('1','113',205714,'AFTERNOON SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'530',2562125.87,2562125.87,'530','2021-06-23 05:31:14','614','2021-06-23 08:01:58',10,0),('1','113',205804,'MORNING SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'530',1225880.62,1225880.62,'530','2021-06-23 12:47:05','614','2021-06-23 14:10:19',10,0),('1','113',205931,'AFTERNOON SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'530',1607506.00,1607506.00,'530','2021-06-24 05:11:13','614','2021-06-24 13:53:50',10,0),('1','113',206064,'MORNING SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'530',1256350.21,1256350.21,'530','2021-06-24 14:04:36','614','2021-06-24 14:31:52',10,0),('1','113',206112,'AFTERNOON SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'530',1781109.15,1781109.15,'530','2021-06-25 06:14:52','614','2021-06-25 09:28:17',10,0),('1','113',206221,'MORNING SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'530',1268863.72,1268863.72,'530','2021-06-25 13:16:07','614','2021-06-25 13:32:54',10,0),('1','113',206341,'AFTERNOON SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'530',1783989.36,1783989.36,'530','2021-06-26 07:50:34','614','2021-06-26 08:54:00',10,0),('1','113',206475,'MORNING SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'530',1001207.94,1001207.94,'530','2021-06-26 12:57:17','614','2021-06-26 13:54:18',10,0),('1','113',206546,'AFTERNOON SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'530',1869070.47,1869070.47,'530','2021-06-27 06:18:39','614','2021-06-27 07:35:22',10,0),('1','113',206675,'MORNING SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'530',1145268.97,1145268.97,'530','2021-06-27 13:25:32','614','2021-06-27 15:07:47',10,0),('1','113',206767,'AFTERNOON SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'530',2682710.34,2682710.34,'530','2021-06-28 06:01:17','614','2021-06-28 09:30:24',10,0),('1','113',206924,'MORNING SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'530',2286876.43,2286876.43,'530','2021-06-28 13:06:20','614','2021-06-28 13:29:04',10,0),('1','113',207026,'AFTERNOON SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'530',2478998.28,2478998.28,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',207130,'AFTERNOON SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'530',2478998.28,2478998.28,'530','2021-06-29 11:58:50','614','2021-06-29 12:58:50',10,0),('1','113',207144,'MORNING SHIFT ','2021-06-29','2021-06-29 00:00:00',NULL,'530',2311454.16,2311454.16,'530','2021-06-29 13:18:46','614','2021-06-29 13:22:55',10,0),('1','113',207196,'AFTERNOON SHIFT 1','2021-06-29','2021-06-29 00:00:00',NULL,'530',177472.40,177472.40,'530','2021-06-29 15:41:28','614','2021-06-29 19:24:12',10,0),('1','113',207222,'AFTERNOON SHIFT 2','2021-06-29','2021-06-29 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',207236,'AFTERNOON SHIFT 2','2021-06-29','2021-06-29 00:00:00',NULL,'530',2546614.40,2546614.40,'530','2021-06-30 07:17:34','614','2021-06-30 07:52:38',10,0),('1','113',207376,'MORNING SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'530',2041355.74,2041355.74,'530','2021-06-30 13:10:01','614','2021-06-30 13:47:49',10,0),('1','113',207461,'AFTERNOON SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'530',3192818.23,3192818.23,'530','2021-07-01 05:07:12','614','2021-07-01 08:51:51',10,0),('1','113',207593,'MORNING SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'530',1622663.32,1622663.32,'530','2021-07-01 13:12:33','614','2021-07-01 14:13:00',10,0),('1','113',207683,'AFTERNOON SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'530',2635917.10,2635917.10,'530','2021-07-02 06:16:55','614','2021-07-02 08:54:19',10,0),('1','113',207783,'MORNING SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'530',2398953.54,2398953.54,'530','2021-07-02 12:59:04','614','2021-07-02 19:50:17',10,0),('1','113',207919,'AFTERNOON SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'530',2814700.42,2814700.42,'530','2021-07-03 07:10:57','614','2021-07-03 09:08:18',10,0),('1','113',208019,'MORNING SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'530',2601493.39,2601493.39,'530','2021-07-03 13:14:54','614','2021-07-03 13:43:12',10,0),('1','113',208112,'AFTERNOON SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'530',2989369.32,2989369.32,'530','2021-07-04 06:47:02','614','2021-07-04 07:12:08',10,0),('1','113',208178,'MORNING SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'530',2204881.56,2204881.56,'530','2021-07-04 13:14:03','614','2021-07-04 13:17:41',10,0),('1','113',208350,'AFTERNOON SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'530',1691934.25,1691934.25,'530','2021-07-05 07:20:59','614','2021-07-05 07:35:16',10,0),('1','113',208431,'MORNING SHIFT ','2021-07-05','2021-07-05 00:00:00',NULL,'530',1244728.31,1244728.31,'530','2021-07-05 12:56:07','614','2021-07-05 13:40:00',10,0),('1','113',208548,'AFTERNOON SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'530',1669941.52,1669941.52,'530','2021-07-06 07:09:26','614','2021-07-06 10:32:12',10,0),('1','113',208647,'MORNING SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'530',1229218.86,1229218.86,'530','2021-07-06 13:16:33','614','2021-07-06 20:53:14',10,0),('1','113',208782,'AFTERNOON SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',208783,'AFTERNOON SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'530',1487787.39,1487787.39,'530','2021-07-07 07:47:23','614','2021-07-07 13:29:31',10,0),('1','113',208919,'MORNING SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'530',1158142.71,1158142.71,'530','2021-07-07 14:22:32','614','2021-07-07 14:27:15',10,0),('1','113',208969,'AFTERNOON SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'530',1686917.97,1686917.97,'530','2021-07-08 07:05:06','614','2021-07-08 07:20:26',10,0),('1','113',209076,'MORNING SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'530',1249571.04,1249571.04,'530','2021-07-08 13:19:04','614','2021-07-08 14:45:34',10,0),('1','113',209197,'AFTERNOON SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'530',1653111.77,1653111.77,'530','2021-07-09 07:48:24','614','2021-07-09 10:47:30',10,0),('1','113',209324,'MORNING SHIFT ','2021-07-09','2021-07-09 00:00:00',NULL,'530',998621.13,998621.13,'530','2021-07-09 12:49:36','614','2021-07-09 15:04:59',10,0),('1','113',209456,'AFTERNOON SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'530',1578995.67,1578995.67,'530','2021-07-10 07:22:38','426','2021-07-10 13:19:29',10,0),('1','113',209557,'MORNING SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',209559,'MORNING SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'530',1846272.59,1846272.59,'530','2021-07-10 15:19:45','614','2021-07-10 16:51:37',10,0),('1','113',209626,'AFTERNOON SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'530',2407125.53,2407125.53,'530','2021-07-11 07:11:53','614','2021-07-11 10:23:51',10,0),('1','113',209709,'MORNING SHIFT ','2021-07-11','2021-07-11 00:00:00',NULL,'530',1350904.32,1350904.32,'530','2021-07-11 12:56:51','614','2021-07-11 14:18:36',10,0),('1','113',209843,'AFTERNOON SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'530',2425497.31,2425497.31,'530','2021-07-12 06:29:35','426','2021-07-12 09:12:25',10,0),('1','113',209930,'MORNING SHIFT ','2021-07-12','2021-07-12 00:00:00',NULL,'530',1640795.04,1640795.04,'530','2021-07-12 12:30:50','614','2021-07-12 14:11:09',10,0),('1','113',210081,'AFTERNOON SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'530',2633549.64,2633549.64,'530','2021-07-13 06:43:33','614','2021-07-13 08:41:58',10,0),('1','113',210174,'MORNING SHIFT ','2021-07-13','2021-07-13 00:00:00',NULL,'530',1697515.11,1697515.11,'530','2021-07-13 12:54:12','614','2021-07-13 14:44:03',10,0),('1','113',210304,'AFTERNOON SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'530',3569865.33,3569865.33,'530','2021-07-14 06:08:24','614','2021-07-14 06:52:44',10,0),('1','113',210358,'MORNING SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'530',2451956.67,2451956.67,'530','2021-07-14 12:51:30','614','2021-07-14 13:10:49',10,0),('1','113',210505,'AFTERNOON SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'530',2553197.60,2553197.60,'530','2021-07-15 05:34:58','614','2021-07-15 09:24:47',10,0),('1','113',210592,'MORNING SHIFT ','2021-07-15','2021-07-15 00:00:00',NULL,'530',1715230.82,1715230.82,'530','2021-07-15 12:49:38','614','2021-07-15 15:39:32',10,0),('1','113',210710,'AFTERNOON SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'530',2589793.15,2589793.15,'530','2021-07-16 05:49:16','614','2021-07-16 06:13:05',10,0),('1','113',210785,'MORNING SHIFT ','2021-07-16','2021-07-16 00:00:00',NULL,'530',1786803.65,1786803.65,'530','2021-07-16 13:11:04','614','2021-07-16 17:26:26',10,0),('1','113',210932,'AFTERNOON SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'530',2479529.00,2479529.00,'530','2021-07-17 07:12:35','426','2021-07-17 13:31:25',10,0),('1','113',211058,'MORNING SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'530',1372538.38,1372538.38,'530','2021-07-17 13:41:26','614','2021-07-17 17:30:52',10,0),('1','113',211155,'AFTERNOON SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'530',3502812.53,3502812.53,'530','2021-07-17 22:12:23','614','2021-07-18 05:05:14',10,0),('1','113',211272,'MORNING SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'530',1770797.88,1770797.88,'530','2021-07-18 14:50:39','614','2021-07-18 20:43:42',10,0),('1','113',211358,'AFTERNOON SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'530',2362150.55,2362150.55,'530','2021-07-19 04:38:43','614','2021-07-19 08:12:14',10,0),('1','113',211545,'MORNING SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'530',1572375.48,1572375.48,'530','2021-07-19 17:16:33','614','2021-07-20 10:22:38',10,0),('1','113',211649,'AFTERNOON SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'530',2700654.97,2700654.97,'530','2021-07-20 11:37:48','614','2021-07-20 12:19:55',10,0),('1','113',211666,'MORNING SHIFT ','2021-07-20','2021-07-20 00:00:00',NULL,'530',1301794.39,1301794.39,'530','2021-07-20 13:11:42','614','2021-07-20 13:46:14',10,0),('1','113',211752,'AFTERNOON SHIFT ','2021-07-20','2021-07-20 00:00:00',NULL,'530',1492339.09,1492339.09,'530','2021-07-20 21:15:29','614','2021-07-21 12:18:11',10,0),('1','113',211874,'MORNING SHIFT ','2021-07-21','2021-07-21 00:00:00',NULL,'530',1903395.59,1903395.59,'530','2021-07-21 12:47:21','614','2021-07-21 13:13:07',10,0),('1','113',212013,'MORNING SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'530',2558468.99,2558468.99,'530','2021-07-22 07:37:17','614','2021-07-22 07:45:56',10,0),('1','113',212090,'MORNING SHIFT ','2021-07-22','2021-07-22 00:00:00',NULL,'530',1556097.16,1556097.16,'530','2021-07-22 12:35:53','614','2021-07-22 16:32:30',10,0),('1','113',212239,'AFTERNOON SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'530',2460048.31,2460048.31,'530','2021-07-23 07:02:15','614','2021-07-23 07:17:48',10,0),('1','113',212288,'MORNING SHIFT ','2021-07-23','2021-07-23 00:00:00',NULL,'530',2008340.82,2008340.82,'530','2021-07-23 12:45:37','614','2021-07-23 13:15:37',10,0),('1','113',212544,'AFTERNOON SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'530',2798210.04,2798210.04,'530','2021-07-24 11:36:15','614','2021-07-24 12:48:48',10,0),('1','113',212650,'AFTERNOON SHIFT ','2021-07-24','2021-07-24 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',212651,'AFTERNOON SHIFT ','2021-07-24','2021-07-24 00:00:00',NULL,'530',3112129.63,3112129.63,'530','2021-07-25 10:09:49','614','2021-07-25 10:32:27',10,0),('1','113',212751,'MORNING SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'530',1932344.54,1932344.54,'530','2021-07-25 12:42:51','614','2021-07-25 18:53:20',10,0),('1','113',212904,'AFTERNOON SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'530',1971609.37,1971609.37,'530','2021-07-26 08:08:32','614','2021-07-26 10:13:36',10,0),('1','113',212994,'MORNING SHIFT ','2021-07-26','2021-07-26 00:00:00',NULL,'530',1539433.43,1539433.43,'530','2021-07-26 14:27:08','614','2021-07-26 15:44:24',10,0),('1','113',213107,'AFTERNOON SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'530',2757424.45,2757424.45,'530','2021-07-27 07:48:26','614','2021-07-27 09:42:02',10,0),('1','113',213213,'MORNING SHIFT ','2021-07-27','2021-07-27 00:00:00',NULL,'530',1449517.34,1449517.34,'530','2021-07-27 12:45:18','614','2021-07-27 15:24:55',10,0),('1','113',213400,'AFTERNOON SHIFT ','2021-07-27','2021-07-27 00:00:00',NULL,'530',2727365.40,2727365.40,'530','2021-07-28 06:57:36','614','2021-07-28 14:40:11',10,0),('1','113',213552,'MORNING SHIFT ','2021-07-28','2021-07-28 00:00:00',NULL,'530',2032199.47,2032199.47,'530','2021-07-28 15:06:22','614','2021-07-28 16:19:48',10,0),('1','113',213650,'AFTERNOON SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'530',2819539.85,2819539.85,'530','2021-07-29 07:28:13','614','2021-07-29 07:47:01',10,0),('1','113',213743,'MORNING SHIFT ','2021-07-29','2021-07-29 00:00:00',NULL,'530',1691160.97,1691160.97,'530','2021-07-29 12:38:08','614','2021-07-29 16:20:38',10,0),('1','113',213898,'AFTERNOON SHIFT ','2021-07-29','2021-07-29 00:00:00',NULL,'530',3068615.98,3068615.98,'530','2021-07-30 07:02:58','614','2021-07-30 09:56:33',10,0),('1','113',213978,'MORNING SHIFT ','2021-07-30','2021-07-30 00:00:00',NULL,'530',1856083.42,1856083.42,'530','2021-07-30 12:46:24','614','2021-07-30 16:15:42',10,0),('1','113',214068,'AFTERNOON SHIFT ','2021-07-30','2021-07-30 00:00:00',NULL,'530',2300130.45,2300130.45,'530','2021-07-31 07:18:48','614','2021-07-31 11:52:48',10,0),('1','113',214201,'MORNING SHIFT ','2021-07-31','2021-07-31 00:00:00',NULL,'530',2723932.18,2723932.18,'530','2021-07-31 12:37:44','614','2021-07-31 17:07:16',10,0),('1','113',214364,'AFTERNOON SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'530',2803978.63,2803978.63,'530','2021-08-01 08:24:24','614','2021-08-01 11:20:06',10,0),('1','113',214433,'MORNING SHIFT ','2021-08-01','2021-08-01 00:00:00',NULL,'530',1449715.54,1449715.54,'530','2021-08-01 12:50:10','614','2021-08-01 12:58:28',10,0),('1','113',214533,'AFTERNOON SHIFT ','2021-08-01','2021-08-01 00:00:00',NULL,'530',2087996.10,2087996.10,'530','2021-08-02 07:42:19','614','2021-08-02 10:53:45',10,0),('1','113',214650,'MORNING SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'530',0.00,0.00,'530','2021-08-02 15:07:11','614','2021-08-02 15:34:43',10,0),('1','113',214718,'MORNING SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'530',1401281.17,1401281.17,'530','2021-08-02 15:51:01','614','2021-08-03 08:12:28',10,0),('1','113',214816,'AFTERNOON SHIFT ','2021-08-02','2021-08-02 00:00:00',NULL,'530',2641907.02,2641907.02,'530','2021-08-03 08:48:21','614','2021-08-03 21:37:43',10,0),('1','113',214980,'MORNING SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'530',2006045.35,2006045.35,'530','2021-08-03 22:13:10','614','2021-08-04 05:54:32',10,0),('1','113',215023,'AFTERNOON SHIFT ','2021-08-03','2021-08-03 00:00:00',NULL,'530',2262929.82,2262929.82,'530','2021-08-04 07:33:25','614','2021-08-04 08:33:25',10,0),('1','113',215109,'MORNING SHIFT ','2021-08-04','2021-08-04 00:00:00',NULL,'530',0.00,0.00,'530','2021-08-04 12:56:23','614','2021-08-04 12:58:00',10,0),('1','113',215122,'MORNING SHIFT ','2021-08-04','2021-08-04 00:00:00',NULL,'530',1897191.47,1897191.47,'530','2021-08-04 13:30:27','614','2021-08-04 13:36:13',10,0),('1','113',215134,'AFTERNOON SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'530',3620689.11,3620689.11,'530','2021-08-05 07:49:50','614','2021-08-05 10:37:00',10,0),('1','113',215336,'MORNING SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'530',1379374.82,1379374.82,'530','2021-08-05 12:52:36','614','2021-08-05 15:04:12',10,0),('1','113',215415,'AFTERNOON SHIFT ','2021-08-05','2021-08-05 00:00:00',NULL,'530',2528937.51,2528937.51,'530','2021-08-06 07:29:36','614','2021-08-06 10:26:45',10,0),('1','113',215592,'MORNING SHIFT ','2021-08-06','2021-08-06 00:00:00',NULL,'530',1982383.34,1982383.34,'530','2021-08-06 14:48:32','614','2021-08-07 07:36:27',10,0),('1','113',215697,'AFTERNOON SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'530',3894679.09,3894679.09,'530','2021-08-07 07:53:25','614','2021-08-07 14:48:59',10,0),('1','113',215827,'MORNING SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'530',1644933.58,1644933.58,'530','2021-08-07 15:42:04','614','2021-08-07 16:34:29',10,0),('1','113',215929,'AFTERNOON SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'530',2536915.79,2536915.79,'530','2021-08-08 08:13:49','614','2021-08-08 13:35:07',10,0),('1','113',216007,'MORNING SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'530',1694233.13,1694233.13,'530','2021-08-08 13:51:08','614','2021-08-08 14:54:49',10,0),('1','113',216108,'AFTERNOON SHIFT ','2021-08-08','2021-08-08 00:00:00',NULL,'530',2973722.43,2973722.43,'530','2021-08-09 07:31:52','614','2021-08-09 08:44:04',10,0),('1','113',216182,'MORNING SHIFT ','2021-08-09','2021-08-09 00:00:00',NULL,'530',0.00,0.00,'530','2021-08-09 12:51:34','614','2021-08-09 12:55:21',10,0),('1','113',216232,'MORNING SHIFT ','2021-08-09','2021-08-09 00:00:00',NULL,'530',1990082.60,1990082.60,'530','2021-08-09 13:13:23','614','2021-08-09 16:59:55',10,0),('1','113',216347,'AFTERNOON SHIFT ','2021-08-09','2021-08-09 00:00:00',NULL,'530',2398746.36,2398746.36,'530','2021-08-10 07:41:51','614','2021-08-10 09:50:29',10,0),('1','113',216455,'MORNING SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'530',1957917.00,1957917.00,'530','2021-08-10 13:04:54','614','2021-08-10 16:59:45',10,0),('1','113',216572,'AFTERNOON SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'530',2931530.60,2931530.60,'530','2021-08-11 07:24:40','614','2021-08-11 12:29:20',10,0),('1','113',216675,'MORNING SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'530',1580063.15,1580063.15,'530','2021-08-11 13:11:50','614','2021-08-11 15:10:58',10,0),('1','113',216793,'AFTERNOON SHIFT ','2021-08-11','2021-08-11 00:00:00',NULL,'530',0.00,0.00,'530','2021-08-12 08:31:18','614','2021-08-12 09:44:58',10,0),('1','113',216864,'AFTERNOON SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'530',2358546.54,2358546.54,'530','2021-08-12 09:58:56','614','2021-08-12 14:58:16',10,0),('1','113',216952,'MORNING SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'530',1486619.71,1486619.71,'530','2021-08-12 15:47:10','614','2021-08-13 08:49:19',10,0),('1','113',217070,'AFTERNOON SHIFT ','2021-08-12','2021-08-12 00:00:00',NULL,'530',2682357.23,2682357.23,'530','2021-08-13 08:59:05','614','2021-08-13 16:03:11',10,0),('1','113',217233,'MORNING SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'530',1834007.30,1834007.30,'530','2021-08-13 17:21:12','614','2021-08-14 06:05:59',10,0),('1','113',217273,'AFTERNOON SHIFT ','2021-08-13','2021-08-13 00:00:00',NULL,'530',2735610.55,2735610.55,'530','2021-08-14 07:31:20','614','2021-08-14 18:27:07',10,0),('1','113',217468,'MORNING SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'530',2070840.66,2070840.66,'530','2021-08-14 18:44:24','614','2021-08-14 20:39:34',10,0),('1','113',217508,'AFTERNOON SHIFT ','2021-08-14','2021-08-14 00:00:00',NULL,'530',3703306.57,3703306.57,'530','2021-08-15 06:42:34','614','2021-08-15 14:58:28',10,0),('1','113',217684,'MORNING SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'530',1657632.87,1657632.87,'530','2021-08-15 21:41:36','614','2021-08-15 21:45:17',10,0),('1','113',217687,'AFTERNOON SHIFT ','2021-08-15','2021-08-15 00:00:00',NULL,'530',2022069.64,2022069.64,'530','2021-08-15 21:59:14','614','2021-08-15 22:01:25',10,0),('1','113',217759,'MORNING SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'530',2129128.64,2129128.64,'530','2021-08-16 12:52:33','614','2021-08-16 15:05:40',10,0),('1','113',217941,'AFTERNOON SHIFT ','2021-08-16','2021-08-16 00:00:00',NULL,'530',2987356.69,2987356.69,'530','2021-08-17 07:52:17','614','2021-08-17 13:23:53',10,0),('1','113',218137,'MORNING SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',218140,'MORNING SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'530',2285619.71,2285619.71,'530','2021-08-17 14:39:43','614','2021-08-17 17:46:01',10,0),('1','113',218197,'AFTERNOON SHIFT 1','2021-08-17','2021-08-17 00:00:00',NULL,'530',658075.01,658075.01,'530','2021-08-17 21:26:07','614','2021-08-17 22:26:29',10,0),('1','113',218220,'AFTERNOON SHIFT 2','2021-08-17','2021-08-17 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',218222,'AFTERNOON SHIFT 2','2021-08-17','2021-08-17 00:00:00',NULL,'530',2192156.91,2192156.91,'530','2021-08-18 06:36:32','614','2021-08-18 13:23:20',10,0),('1','113',218372,'MORNING SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'530',1572262.56,1572262.56,'530','2021-08-18 14:19:39','614','2021-08-18 14:49:26',10,0),('1','113',218484,'AFTERNOON SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'530',2892916.50,2892916.50,'530','2021-08-19 08:07:07','614','2021-08-19 08:54:49',10,0),('1','113',218564,'MORNING SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'530',1639734.90,1639734.90,'530','2021-08-19 12:51:00','614','2021-08-19 23:03:23',10,0),('1','113',218679,'AFTERNOON SHIFT ','2021-08-19','2021-08-19 00:00:00',NULL,'530',3622978.50,3622978.50,'530','2021-08-20 06:17:54','614','2021-08-20 13:31:28',10,0),('1','113',218830,'MORNING SHIFT ','2021-08-20','2021-08-20 00:00:00',NULL,'530',2323866.60,2323866.60,'530','2021-08-20 14:37:18','614','2021-08-20 15:00:15',10,0),('1','113',218887,'AFTERNOON SHIFT ','2021-08-20','2021-08-20 00:00:00',NULL,'530',3021995.01,3021995.01,'530','2021-08-21 06:56:25','614','2021-08-21 10:51:23',10,0),('1','113',219020,'MORNING SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'530',1494519.87,1494519.87,'530','2021-08-21 13:15:55','614','2021-08-21 13:45:24',10,0),('1','113',219099,'AFTERNOON SHIFT ','2021-08-21','2021-08-21 00:00:00',NULL,'530',2373700.08,2373700.08,'530','2021-08-22 09:17:05','614','2021-08-22 13:04:58',10,0),('1','113',219263,'MORNING SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'530',2020084.32,2020084.32,'530','2021-08-22 15:10:39','614','2021-08-22 17:22:30',10,0),('1','113',219345,'AFTERNOON SHIFT ','2021-08-22','2021-08-22 00:00:00',NULL,'530',1970050.08,1970050.08,'530','2021-08-23 06:43:59','614','2021-08-23 08:23:19',10,0),('1','113',219487,'MORNING SHIFT ','2021-08-23','2021-08-23 00:00:00',NULL,'530',1957426.65,1957426.65,'530','2021-08-23 13:19:31','614','2021-08-23 15:40:54',10,0),('1','113',219623,'AFTERNOON SHIFT ','2021-08-23','2021-08-23 00:00:00',NULL,'530',3466811.19,3466811.19,'530','2021-08-24 07:27:38','614','2021-08-24 14:07:30',10,0),('1','113',219783,'MORNING SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'530',2005407.63,2005407.63,'530','2021-08-24 19:49:25','614','2021-08-25 05:51:34',10,0),('1','113',219824,'AFTERNOON SHIFT ','2021-08-24','2021-08-24 00:00:00',NULL,'530',3285505.32,3285505.32,'530','2021-08-25 07:14:20','614','2021-08-25 07:25:27',10,0),('1','113',219894,'MORNING SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'530',1759046.97,1759046.97,'530','2021-08-25 21:30:11','614','2021-08-26 09:06:08',10,0),('1','113',220103,'AFTERNOON SHIFT ','2021-08-25','2021-08-25 00:00:00',NULL,'530',2794883.97,2794883.97,'530','2021-08-26 09:20:32','614','2021-08-26 09:22:17',10,0),('1','113',220121,'MORNING SHIFT ','2021-08-26','2021-08-26 00:00:00',NULL,'530',2345890.95,2345890.95,'530','2021-08-26 13:09:36','614','2021-08-26 15:11:25',10,0),('1','113',220222,'AFTERNOON SHIFT ','2021-08-26','2021-08-26 00:00:00',NULL,'530',0.00,0.00,'530','2021-08-26 22:17:06','614','2021-08-26 22:21:23',10,0),('1','113',220229,'AFTERNOON SHIFT ','2021-08-26','2021-08-26 00:00:00',NULL,'530',3249199.38,3249199.38,'530','2021-08-27 05:14:11','614','2021-08-27 08:02:40',10,0),('1','113',220364,'MORNING SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'530',2574242.34,2574242.34,'530','2021-08-27 12:57:03','614','2021-08-27 16:58:49',10,0),('1','113',220479,'AFTERNOON SHIFT ','2021-08-27','2021-08-27 00:00:00',NULL,'530',2940376.95,2940376.95,'530','2021-08-28 07:16:29','614','2021-08-28 12:34:13',10,0),('1','113',220589,'MORNING SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'530',1724622.36,1724622.36,'530','2021-08-28 13:27:08','614','2021-08-28 14:20:46',10,0),('1','113',220662,'AFTERNOON SHIFT ','2021-08-28','2021-08-28 00:00:00',NULL,'530',0.00,0.00,'530','2021-08-29 07:14:41','614','2021-08-29 09:54:51',10,0),('1','113',220769,'AFTERNOON SHIFT ','2021-08-28','2021-08-28 00:00:00',NULL,'530',2409124.32,2409124.32,'530','2021-08-29 12:29:50','614','2021-08-29 14:11:54',10,0),('1','113',220856,'MORNING SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'530',1846103.22,1846103.22,'530','2021-08-29 17:29:23','614','2021-08-29 23:38:34',10,0),('1','113',220942,'AFTERNOON SHIFT ','2021-08-29','2021-08-29 00:00:00',NULL,'530',2583124.77,2583124.77,'530','2021-08-30 07:48:50','614','2021-08-30 09:24:26',10,0),('1','113',221063,'MORNING SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'530',1637172.42,1637172.42,'530','2021-08-30 14:02:40','614','2021-08-31 05:36:41',10,0),('1','113',221171,'AFTERNOON SHIFT ','2021-08-30','2021-08-30 00:00:00',NULL,'530',3012185.70,3012185.70,'530','2021-08-31 07:51:01','614','2021-08-31 12:02:46',10,0),('1','113',221357,'MORNING SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'530',1036559.97,1036559.97,'530','2021-08-31 20:07:33','614','2021-08-31 23:01:48',10,0),('1','113',221381,'AFTERNOON SHIFT ','2021-08-31','2021-08-31 00:00:00',NULL,'530',1514284.80,1514284.80,'530','2021-09-01 05:56:00','614','2021-09-01 13:32:47',10,0),('1','113',221559,'MORNING SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'530',1908213.87,1908213.87,'530','2021-09-01 16:42:44','614','2021-09-02 06:06:34',10,0),('1','113',221648,'AFTERNOON SHIFT ','2021-09-01','2021-09-01 00:00:00',NULL,'530',3298706.91,3298706.91,'530','2021-09-02 07:50:11','614','2021-09-02 13:27:33',10,0),('1','113',221751,'MORNING SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'530',2263745.79,2263745.79,'530','2021-09-02 14:23:08','614','2021-09-02 19:41:50',10,0),('1','113',221832,'AFTERNOON SHIFT ','2021-09-02','2021-09-02 00:00:00',NULL,'530',3371023.53,3371023.53,'530','2021-09-03 09:27:04','614','2021-09-03 14:28:56',10,0),('1','113',221999,'MORNING SHIFT ','2021-09-03','2021-09-03 00:00:00',NULL,'530',3071713.80,3071713.80,'530','2021-09-03 15:56:55','614','2021-09-03 20:37:23',10,0),('1','113',222068,'AFTERNOON SHIFT ','2021-09-03','2021-09-03 00:00:00',NULL,'530',2847732.75,2847732.75,'530','2021-09-04 07:26:46','614','2021-09-04 08:45:53',10,0),('1','113',222124,'MORNING SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'530',2104167.30,2104167.30,'530','2021-09-04 12:40:17','614','2021-09-04 14:55:13',10,0),('1','113',222229,'AFTERNOON SHIFT ','2021-09-04','2021-09-04 00:00:00',NULL,'530',0.00,0.00,'530','2021-09-04 17:22:48','614','2021-09-05 06:17:08',10,0),('1','113',222269,'AFTERNOON SHIFT ','2021-09-04','2021-09-04 00:00:00',NULL,'530',3409974.12,3409974.12,'530','2021-09-05 06:37:42','614','2021-09-05 06:57:42',10,0),('1','113',222390,'MORNING SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'530',1893106.26,1893106.26,'530','2021-09-05 13:34:22','614','2021-09-05 14:15:27',10,0),('1','113',222481,'AFTERNOON SHIFT ','2021-09-06','2021-09-06 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',222490,'AFTERNOON SHIFT ','2021-09-05','2021-09-05 00:00:00',NULL,'530',2370396.78,2370396.78,'530','2021-09-06 06:28:31','614','2021-09-06 06:47:27',10,0),('1','113',222633,'MORNING SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'530',2266786.05,2266786.05,'530','2021-09-06 14:02:18','614','2021-09-06 14:53:54',10,0),('1','113',222682,'AFTERNOON SHIFT ','2021-09-06','2021-09-06 00:00:00',NULL,'530',0.00,0.00,'530','2021-09-06 16:42:57','614','2021-09-07 06:56:09',10,0),('1','113',222733,'AFTERNOON SHIFT ','2021-09-06','2021-09-06 00:00:00',NULL,'530',3195922.14,3195922.14,'530','2021-09-07 07:13:51','614','2021-09-07 08:43:57',10,0),('1','113',222854,'MORNING SHIFT ','2021-09-07','2021-09-07 00:00:00',NULL,'530',1778502.27,1778502.27,'530','2021-09-07 13:46:09','614','2021-09-07 15:09:34',10,0),('1','113',222942,'AFTERNOON SHIFT ','2021-09-08','2021-09-08 00:00:00',NULL,'530',3204064.20,3204064.20,'530','2021-09-08 06:45:16','614','2021-09-08 09:58:42',10,0),('1','113',223067,'MORNING SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'530',2574119.49,2574119.49,'530','2021-09-08 13:40:46','614','2021-09-08 14:12:14',10,0),('1','113',223158,'AFTERNOON SHIFT ','2021-09-08','2021-09-08 00:00:00',NULL,'530',3482656.08,3482656.08,'530','2021-09-09 06:06:43','614','2021-09-09 07:55:39',10,0),('1','113',223291,'MORNING SHIFT ','2021-09-09','2021-09-09 00:00:00',NULL,'530',2766742.53,2766742.53,'530','2021-09-09 14:53:36','614','2021-09-09 18:34:26',10,0),('1','113',223401,'AFTERNOON SHIFT ','2021-09-09','2021-09-09 00:00:00',NULL,'530',3540475.47,3540475.47,'530','2021-09-10 13:07:28','614','2021-09-11 06:34:51',10,0),('1','113',223656,'MORNING SHIFT ','2021-09-10','2021-09-10 00:00:00',NULL,'530',2384792.73,2384792.73,'530','2021-09-11 07:27:44','614','2021-09-11 07:31:17',10,0),('1','113',223660,'AFTERNOON SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'530',2366858.34,2366858.34,'530','2021-09-11 07:45:01','614','2021-09-11 07:48:49',10,0),('1','113',223705,'MORNING SHIFT ','2021-09-11','2021-09-11 00:00:00',NULL,'530',2221070.52,2221070.52,'530','2021-09-11 14:47:04','614','2021-09-11 22:20:49',10,0),('1','113',223927,'AFTERNOON SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'530',3839543.10,3839543.10,'530','2021-09-12 09:55:53','614','2021-09-12 10:45:18',10,0),('1','113',223980,'MORNING SHIFT ','2021-09-12','2021-09-12 00:00:00',NULL,'530',1897978.20,1897978.20,'530','2021-09-12 13:08:30','614','2021-09-12 15:46:14',10,0),('1','113',224131,'AFTERNOON SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'530',3038839.74,3038839.74,'530','2021-09-13 09:12:15','614','2021-09-13 10:17:07',10,0),('1','113',224240,'AFTERNOON SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'530',2092444.00,2092444.00,'530','2021-09-13 14:08:24','614','2021-09-13 22:40:23',10,0),('1','113',224324,'AFTERNOON SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'530',2476603.89,2476603.89,'530','2021-09-14 07:18:45','614','2021-09-14 08:04:14',10,0),('1','113',224448,'MORNING SHIFT ','2021-09-14','2021-09-14 00:00:00',NULL,'530',1875348.30,1875348.30,'530','2021-09-14 13:59:12','614','2021-09-14 14:49:44',10,0),('1','113',224512,'AFTERNOON SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'530',2265745.53,2265745.53,'530','2021-09-15 07:34:59','614','2021-09-15 08:51:45',10,0),('1','113',224687,'MORNING SHIFT ','2021-09-15','2021-09-15 00:00:00',NULL,'530',1210162.98,1210162.98,'530','2021-09-15 13:45:07','614','2021-09-15 16:20:07',10,0),('1','113',224813,'AFTERNOON SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'530',3208428.60,3208428.60,'530','2021-09-16 08:58:56','614','2021-09-16 10:11:00',10,0),('1','113',224942,'MORNING SHIFT ','2021-09-16','2021-09-16 00:00:00',NULL,'530',2218134.06,2218134.06,'530','2021-09-16 14:27:11','614','2021-09-16 14:56:49',10,0),('1','113',225079,'AFTERNOON SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'530',3170978.01,3170978.01,'530','2021-09-17 09:19:41','614','2021-09-17 10:05:38',10,0),('1','113',225168,'MORNING SHIFT ','2021-09-17','2021-09-17 00:00:00',NULL,'530',3318404.76,3318404.76,'530','2021-09-17 14:23:15','614','2021-09-17 14:32:23',10,0),('1','113',225301,'AFTERNOON SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'530',354426.00,354426.00,'530','2021-09-18 08:12:51','614','2021-09-18 08:19:33',10,0),('1','113',225307,'MORNING SHIFT 2','2021-09-17','2021-09-17 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',225309,'AFTERNOON SHIFT 1','2021-09-17','2021-09-17 00:00:00',NULL,'530',3929971.26,3929971.26,'530','2021-09-18 08:58:01','614','2021-09-18 09:17:58',10,0),('1','113',225327,'MORNING SHIFT ','2021-09-18','2021-09-18 00:00:00',NULL,'530',0.00,0.00,'530','2021-09-18 10:33:41','614','2021-09-18 10:59:39',10,0),('1','113',225398,'MORNING SHIFT ','2021-09-18','2021-09-18 00:00:00',NULL,'530',2636418.18,2636418.18,'530','2021-09-18 15:54:10','614','2021-09-18 16:40:45',10,0),('1','113',225532,'AFTERNOON SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',225546,'AFTERNOON SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'530',3733979.96,3733979.96,'530','2021-09-19 10:22:27','614','2021-09-19 12:35:19',10,0),('1','113',225624,'MORNING SHIFT ','2021-09-19','2021-09-19 00:00:00',NULL,'530',1756310.02,1756310.02,'530','2021-09-19 15:15:19','614','2021-09-19 15:27:56',10,0),('1','113',225677,'AFTERNOON SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'530',2563023.28,2563023.28,'530','2021-09-19 22:09:11','614','2021-09-20 09:13:03',10,0),('1','113',225863,'MORNING SHIFT ','2021-09-20','2021-09-20 00:00:00',NULL,'530',2196148.44,2196148.44,'530','2021-09-20 14:29:32','614','2021-09-20 15:36:35',10,0),('1','113',226005,'AFTERNOON SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'530',3451491.06,3451491.06,'530','2021-09-21 07:55:06','614','2021-09-21 08:00:32',10,0),('1','113',226048,'MORNING SHIFT 1','2021-09-21','2021-09-21 00:00:00',NULL,'530',451692.40,451692.40,'530','2021-09-21 09:38:39','614','2021-09-21 10:37:12',10,0),('1','113',226116,'MORNING SHIFT 2','2021-09-21','2021-09-21 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',226125,'MORNING SHIFT 2','2021-09-21','2021-09-21 00:00:00',NULL,'530',1507389.77,1507389.77,'530','2021-09-21 13:19:33','614','2021-09-21 13:27:24',10,0),('1','113',226242,'AFTERNOON SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'530',2849946.36,2849946.36,'530','2021-09-22 08:39:53','614','2021-09-22 08:45:26',10,0),('1','113',226364,'MORNING SHIFT ','2021-09-22','2021-09-22 00:00:00',NULL,'530',2937213.69,2937213.69,'530','2021-09-22 13:07:33','614','2021-09-22 14:49:52',10,0),('1','113',226514,'AFTERNOON SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'530',2824384.97,2824384.97,'530','2021-09-23 08:20:07','614','2021-09-23 15:35:07',10,0),('1','113',226714,'MORNING SHIFT ','2021-09-23','2021-09-23 00:00:00',NULL,'530',2060106.88,2060106.88,'530','2021-09-23 23:09:05','614','2021-09-23 23:15:13',10,0),('1','113',226739,'AFTERNOON SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'530',2959298.10,2959298.10,'530','2021-09-24 06:41:02','614','2021-09-24 10:22:17',10,0),('1','113',226851,'MORNING SHIFT ','2021-09-24','2021-09-24 00:00:00',NULL,'530',2183431.55,2183431.55,'530','2021-09-24 12:58:02','614','2021-09-24 14:18:47',10,0),('1','113',226938,'AFTERNOON SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'530',3610971.95,3610971.95,'530','2021-09-25 08:25:01','614','2021-09-25 14:09:24',10,0),('1','113',227105,'MORNING SHIFT ','2021-09-25','2021-09-25 00:00:00',NULL,'530',2119480.08,2119480.08,'530','2021-09-25 14:26:36','614','2021-09-25 15:37:42',10,0),('1','113',227180,'AFTERNOON SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'530',3118763.95,3118763.95,'530','2021-09-26 06:14:47','614','2021-09-26 06:39:00',10,0),('1','113',227294,'MORNING SHIFT ','2021-09-26','2021-09-26 00:00:00',NULL,'530',1669017.03,1669017.03,'530','2021-09-26 14:04:35','614','2021-09-26 18:07:53',10,0),('1','113',227397,'AFTERNOON SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'530',2158576.18,2158576.18,'530','2021-09-27 07:24:24','614','2021-09-27 09:48:34',10,0),('1','113',227502,'MORNING SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'530',2262858.94,2262858.94,'530','2021-09-27 13:38:02','614','2021-09-27 14:07:55',10,0),('1','113',227582,'AFTERNOON SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'530',2960294.67,2960294.67,'530','2021-09-28 07:36:08','614','2021-09-28 11:35:39',10,0),('1','113',227763,'MORNING SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'530',1884172.78,1884172.78,'530','2021-09-28 13:51:07','614','2021-09-28 13:53:50',10,0),('1','113',227795,'AFTERNOON SHIFT 1','2021-09-28','2021-09-28 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',227798,'AFTERNOON SHIFT 1','2021-09-28','2021-09-28 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',227799,'AFTERNOON SHIFT 1','2021-09-28','2021-09-28 00:00:00',NULL,'530',491357.90,491357.90,'530','2021-09-28 16:23:45','614','2021-09-28 17:11:20',10,0),('1','113',227898,'AFTERNOON SHIFT 2','2021-09-28','2021-09-28 00:00:00',NULL,'530',3863279.04,3863279.04,'530','2021-09-29 08:34:39','614','2021-09-29 10:34:34',10,0),('1','113',227990,'MORNING SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'530',2628832.02,2628832.02,'530','2021-09-29 13:26:25','614','2021-09-29 18:05:29',10,0),('1','113',228105,'AFTERNOON SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'530',3756194.46,3756194.46,'530','2021-09-30 05:18:43','614','2021-09-30 05:22:26',10,0),('1','113',228242,'MORNING SHIFT ','2021-09-30','2021-09-30 00:00:00',NULL,'530',2560661.76,2560661.76,'530','2021-09-30 13:42:59','614','2021-09-30 15:09:25',10,0),('1','113',228366,'AFTERNOON SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'530',3917725.02,3917725.02,'530','2021-10-01 07:26:37','614','2021-10-01 09:47:39',10,0),('1','113',228464,'MORNING SHIFT ','2021-10-01','2021-10-01 00:00:00',NULL,'530',2067285.84,2067285.84,'530','2021-10-01 14:38:25','614','2021-10-01 20:53:18',10,0),('1','113',228535,'AFTERNOON SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'530',2869916.58,2869916.58,'530','2021-10-02 06:48:26','614','2021-10-02 08:44:59',10,0),('1','113',228640,'MORNING SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'530',2997606.42,2997606.42,'530','2021-10-02 14:10:37','614','2021-10-02 18:57:16',10,0),('1','113',228742,'AFTERNOON SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'530',3361485.00,3361485.00,'530','2021-10-03 05:35:46','614','2021-10-03 12:02:07',10,0),('1','113',228878,'MORNING SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'530',1980975.60,1980975.60,'530','2021-10-03 14:23:26','614','2021-10-03 15:57:01',10,0),('1','113',228949,'AFTERNOON SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'530',2649889.20,2649889.20,'530','2021-10-04 06:42:19','614','2021-10-04 07:33:55',10,0),('1','113',229056,'MORNING SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'530',2591580.36,2591580.36,'530','2021-10-04 13:28:42','614','2021-10-04 18:17:24',10,0),('1','113',229204,'AFTERNOON SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'530',4157067.78,4157067.78,'530','2021-10-05 08:14:17','614','2021-10-05 09:09:49',10,0),('1','113',229362,'MORNING SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'530',1766063.22,1766063.22,'530','2021-10-05 16:17:46','614','2021-10-05 19:43:03',10,0),('1','113',229453,'AFTERNOON SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'530',3314154.26,3314154.26,'530','2021-10-06 08:31:33','614','2021-10-06 09:34:33',10,0),('1','113',229523,'MORNING SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'530',2565834.50,2565834.50,'530','2021-10-06 13:30:50','614','2021-10-06 14:05:44',10,0),('1','113',229669,'AFTERNOON SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'530',3968109.68,3968109.68,'530','2021-10-07 06:53:33','614','2021-10-07 08:41:54',10,0),('1','113',229791,'MORNING SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'530',3242311.84,3242311.84,'530','2021-10-07 17:30:48','614','2021-10-08 09:21:29',10,0),('1','113',229939,'AFTERNOON SHIFT ','2021-10-07','2021-10-07 00:00:00',NULL,'530',4451548.04,4451548.04,'530','2021-10-08 09:24:17','614','2021-10-08 09:50:20',10,0),('1','113',230025,'MORNING SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'530',3973067.86,3973067.86,'530','2021-10-08 15:27:29','614','2021-10-08 15:48:43',10,0),('1','113',230101,'AFTERNOON SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'530',3762660.70,3762660.70,'530','2021-10-09 07:14:25','614','2021-10-09 16:07:24',10,0),('1','113',230269,'MORNING SHIFT ','2021-10-09','2021-10-09 00:00:00',NULL,'530',2980329.26,2980329.26,'530','2021-10-09 21:44:02','614','2021-10-09 22:04:31',10,0),('1','113',230316,'AFTERNOON SHIFT ','2021-10-09','2021-10-09 00:00:00',NULL,'530',3256627.88,3256627.88,'530','2021-10-10 09:41:00','614','2021-10-10 09:51:09',10,0),('1','113',230412,'MORNING SHIFT ','2021-10-10','2021-10-10 00:00:00',NULL,'530',2660582.38,2660582.38,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',230420,'MORNING SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'530',2697262.88,2697262.88,'530','2021-10-10 13:54:56','614','2021-10-10 14:16:23',10,0),('1','113',230500,'AFTERNOON SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'530',2952715.94,2952715.94,'530','2021-10-11 07:49:44','614','2021-10-11 10:43:32',10,0),('1','113',230651,'MORNING SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'530',2653553.70,2653553.70,'530','2021-10-11 13:29:05','614','2021-10-11 14:07:02',10,0),('1','113',230764,'AFTERNOON SHIFT ','2021-10-11','2021-10-11 00:00:00',NULL,'530',3488941.24,3488941.24,'530','2021-10-11 21:28:52','614','2021-10-12 08:29:49',10,0),('1','113',230826,'MORNING SHIFT ','2021-10-12','2021-10-12 00:00:00',NULL,'530',0.00,0.00,'530','2021-10-12 08:48:17','614','2021-10-12 13:40:33',10,0),('1','113',230952,'MORNING SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'530',2067792.96,2067792.96,'530','2021-10-12 13:48:25','614','2021-10-12 15:38:23',10,0),('1','113',231040,'AFTERNOON SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'530',2993236.88,2993236.88,'530','2021-10-12 21:16:21','614','2021-10-12 21:38:58',10,0),('1','113',231204,'MORNING SHIFT ','2021-10-13','2021-10-13 00:00:00',NULL,'530',2825259.72,2825259.72,'530','2021-10-13 13:19:35','614','2021-10-13 14:19:55',10,0),('1','113',231255,'AFTERNOON SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'530',2768319.00,2768319.00,'530','2021-10-13 21:36:22','614','2021-10-13 22:45:03',10,0),('1','113',231652,'AFTERNOON SHIFT ','2021-10-14','2021-10-14 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',231654,'MORNING SHIFT ','2021-10-14','2021-10-14 00:00:00',NULL,'530',2557228.96,2557228.96,'530','2021-10-15 07:36:53','614','2021-10-15 13:09:57',10,0),('1','113',231797,'AFTERNOON SHIFT ','2021-10-14','2021-10-14 00:00:00',NULL,'530',3152485.76,3152485.76,'530','2021-10-15 13:57:49','614','2021-10-15 14:20:04',10,0),('1','113',231859,'MORNING SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'530',2430552.96,2430552.96,'530','2021-10-15 21:38:14','614','2021-10-15 21:42:04',10,0),('1','113',231887,'AFTERNOON SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'530',3964847.14,3964847.14,'530','2021-10-16 06:12:44','614','2021-10-16 07:15:39',10,0),('1','113',231978,'MORNING SHIFT ','2021-10-16','2021-10-16 00:00:00',NULL,'530',2385433.68,2385433.68,'530','2021-10-16 14:15:51','614','2021-10-16 22:30:47',10,0),('1','113',232153,'AFTERNOON SHIFT ','2021-10-16','2021-10-16 00:00:00',NULL,'530',2913481.12,2913481.12,'530','2021-10-17 09:34:24','614','2021-10-17 16:53:39',10,0),('1','113',232272,'MORNING SHIFT ','2021-10-17','2021-10-17 00:00:00',NULL,'530',1662570.62,1662570.62,'530','2021-10-17 17:32:10','614','2021-10-18 11:53:11',10,0),('1','113',232517,'AFTERNOON SHIFT ','2021-10-17','2021-10-17 00:00:00',NULL,'530',2569416.92,2569416.92,'530','2021-10-18 15:46:11','614','2021-10-18 15:53:48',10,0),('1','113',232563,'MORNING SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'530',1928610.56,1928610.56,'530','2021-10-18 21:31:14','614','2021-10-19 11:50:47',10,0),('1','113',232705,'AFTERNOON SHIFT ','2021-10-18','2021-10-18 00:00:00',NULL,'530',2568628.36,2568628.36,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',232730,'AFTERNOON SHIFT ','2021-10-18','2021-10-18 00:00:00',NULL,'530',2621224.14,2621224.14,'530','2021-10-19 13:51:46','614','2021-10-19 13:54:07',10,0),('1','113',232731,'MORNING SHIFT ','2021-10-19','2021-10-19 00:00:00',NULL,'530',1958270.78,1958270.78,'530','2021-10-19 14:05:30','614','2021-10-19 17:33:58',10,0),('1','113',232948,'AFTERNOON SHIFT ','2021-10-19','2021-10-19 00:00:00',NULL,'530',3297830.94,3297830.94,'530','2021-10-20 10:09:41','614','2021-10-20 10:56:55',10,0),('1','113',233005,'MORNING SHIFT ','2021-10-20','2021-10-20 00:00:00',NULL,'530',2646985.24,2646985.24,'530','2021-10-20 13:39:12','614','2021-10-20 14:04:49',10,0),('1','113',233156,'AFTERNOON SHIFT ','2021-10-20','2021-10-20 00:00:00',NULL,'530',1617770.13,1617770.13,'530','2021-10-21 08:25:22','614','2021-10-21 08:41:41',10,0),('1','113',233181,'MORNING SHIFT ','2021-10-21','2021-10-21 00:00:00',NULL,'530',0.00,0.00,'530','2021-10-21 09:30:59','614','2021-10-21 11:04:40',10,0),('1','113',233282,'MORNING SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'530',1989124.20,1989124.20,'530','2021-10-21 14:44:31','614','2021-10-21 14:53:40',10,0),('1','113',233314,'AFTERNOON SHIFT ','2021-10-21','2021-10-21 00:00:00',NULL,'530',2918453.43,2918453.43,'530','2021-10-22 08:21:36','614','2021-10-22 12:29:41',10,0),('1','113',233547,'MORNING SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'530',1718853.65,1718853.65,'530','2021-10-22 15:50:27','614','2021-10-22 16:06:53',10,0),('1','113',233656,'AFTERNOON SHIFT ','2021-10-22','2021-10-22 00:00:00',NULL,'530',3149680.17,3149680.17,'530','2021-10-23 08:16:06','614','2021-10-23 10:17:45',10,0),('1','113',233695,'MORNING SHIFT ','2021-10-23','2021-10-23 00:00:00',NULL,'530',3196274.43,3196274.43,'530','2021-10-23 13:37:32','614','2021-10-23 14:56:34',10,0),('1','113',233859,'AFTERNOON SHIFT ','2021-10-23','2021-10-23 00:00:00',NULL,'530',2147007.07,2147007.07,'530','2021-10-24 07:04:27','614','2021-10-24 07:15:04',10,0),('1','113',233925,'MORNING SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'530',1385439.65,1385439.65,'530','2021-10-24 12:40:54','614','2021-10-24 16:15:48',10,0),('1','113',234079,'AFTERNOON SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'530',2416219.95,2416219.95,'530','2021-10-25 07:45:35','614','2021-10-25 08:22:31',10,0),('1','113',234196,'MORNING SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'530',1632606.05,1632606.05,'530','2021-10-25 12:58:13','614','2021-10-25 19:25:44',10,0),('1','113',234362,'MORNING SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'530',2600718.91,2600718.91,'530','2021-10-26 08:19:22','614','2021-10-26 10:35:40',10,0),('1','113',234483,'MORNING SHIFT ','2021-10-26','2021-10-26 00:00:00',NULL,'530',1638383.04,1638383.04,'530','2021-10-26 14:24:05','614','2021-10-26 16:59:08',10,0),('1','113',234539,'AFTERNOON SHIFT ','2021-10-26','2021-10-26 00:00:00',NULL,'530',2613804.47,2613804.47,'530','2021-10-27 06:43:20','614','2021-10-27 11:39:06',10,0),('1','113',234718,'MORNING SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'530',2505306.99,2505306.99,'530','2021-10-27 13:21:44','614','2021-10-27 20:30:24',10,0),('1','113',234838,'AFTERNOON SHIFT ','2021-10-27','2021-10-27 00:00:00',NULL,'530',2757661.21,2757661.21,'530','2021-10-28 06:27:03','614','2021-10-28 06:48:31',10,0),('1','113',234928,'MORNING SHIFT ','2021-10-28','2021-10-28 00:00:00',NULL,'530',0.00,0.00,'530','2021-10-28 10:01:08','614','2021-10-28 12:03:16',10,0),('1','113',234969,'MORNING SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'530',1807102.58,1807102.58,'530','2021-10-28 13:43:33','614','2021-10-28 15:10:11',10,0),('1','113',235138,'AFTERNOON SHIFT ','2021-10-28','2021-10-28 00:00:00',NULL,'530',2877070.75,2877070.75,'530','2021-10-29 08:35:35','614','2021-10-29 11:31:33',10,0),('1','113',235223,'MORNING SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'530',2299555.29,2299555.29,'530','2021-10-29 14:52:46','614','2021-10-29 16:27:57',10,0),('1','113',235353,'AFTERNOON SHIFT ','2021-10-29','2021-10-29 00:00:00',NULL,'530',2713359.13,2713359.13,'530','2021-10-30 08:11:52','614','2021-10-30 11:48:32',10,0),('1','113',235437,'MORNING','2021-10-30','2021-10-30 00:00:00',NULL,'426',1953713.25,1953713.25,'530','2021-10-30 13:58:17','614','2021-10-30 14:14:24',10,0),('1','113',235538,'AFTERNOON SHIFT ','2021-10-30','2021-10-30 00:00:00',NULL,'530',3137550.25,3137550.25,'530','2021-10-31 06:26:37','614','2021-10-31 06:28:05',10,0),('1','113',235628,'MORNING SHIFT 1','2021-10-31','2021-10-31 00:00:00',NULL,'530',746352.55,746352.55,'530','2021-10-31 12:07:17','614','2021-10-31 14:11:38',10,0),('1','113',235727,'MORNING SHIFT 2','2021-10-31','2021-10-31 00:00:00',NULL,'530',711878.55,711878.55,'530','2021-10-31 22:00:26','614','2021-11-01 09:47:35',10,0),('1','113',235860,'AFTERNOON SHIFT ','2021-10-31','2021-10-31 00:00:00',NULL,'530',2407234.55,2407234.55,'530','2021-11-01 10:13:49','614','2021-11-01 20:40:17',10,0),('1','113',236018,'MORNING SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'530',1662700.90,1662700.90,'530','2021-11-02 06:04:23','614','2021-11-02 06:10:11',10,0),('1','113',236029,'AFTERNOON SHIFT ','2021-11-01','2021-11-01 00:00:00',NULL,'530',3011834.20,3011834.20,'530','2021-11-02 06:17:55','614','2021-11-02 06:24:32',10,0),('1','113',236139,'MORNING SHIFT ','2021-11-02','2021-11-02 00:00:00',NULL,'530',1643504.50,1643504.50,'530','2021-11-02 13:28:36','614','2021-11-02 20:04:46',10,0),('1','113',236306,'AFTERNOON SHIFT 1','2021-11-02','2021-11-02 00:00:00',NULL,'530',24595.60,24595.60,'530','2021-11-03 08:52:30','614','2021-11-03 08:54:37',10,0),('1','113',236313,'AFTERNOON SHIFT 2','2021-11-02','2021-11-02 00:00:00',NULL,'530',2874280.15,2874280.15,'530','2021-11-03 09:07:08','614','2021-11-03 09:41:59',10,0),('1','113',236398,'MORNING SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'530',2379212.15,2379212.15,'530','2021-11-03 13:26:43','614','2021-11-03 16:17:11',10,0),('1','113',236599,'AFTERNOON SHIFT ','2021-11-03','2021-11-03 00:00:00',NULL,'530',3233502.00,3233502.00,'530','2021-11-04 10:01:59','614','2021-11-04 10:40:11',10,0),('1','113',236634,'MORNING SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'530',1905257.95,1905257.95,'530','2021-11-04 13:24:56','614','2021-11-04 18:51:13',10,0),('1','113',236728,'AFTERNOON SHIFT ','2021-11-04','2021-11-04 00:00:00',NULL,'530',2796985.45,2796985.45,'530','2021-11-05 05:25:51','614','2021-11-05 09:02:43',10,0),('1','113',236840,'MORNING SHIFT ','2021-11-05','2021-11-05 00:00:00',NULL,'530',0.00,0.00,'530','2021-11-05 11:40:34','614','2021-11-05 11:42:23',10,0),('1','113',236852,'MORNING SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'530',1907705.00,1907705.00,'530','2021-11-05 13:35:44','614','2021-11-05 15:49:09',10,0),('1','113',236890,'AFTERNOON SHIFT ','2021-11-05','2021-11-05 00:00:00',NULL,'530',2451247.35,2451247.35,'530','2021-11-06 05:10:03','614','2021-11-06 09:21:20',10,0),('1','113',237033,'MORNING SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'530',1748733.95,1748733.95,'530','2021-11-06 13:17:39','614','2021-11-06 13:56:57',10,0),('1','113',237095,'AFTERNOON SHIFT ','2021-11-06','2021-11-06 00:00:00',NULL,'530',3405303.10,3405303.10,'530','2021-11-07 06:04:44','614','2021-11-07 06:37:16',10,0),('1','113',237194,'MORNING SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'530',1596637.20,1596637.20,'530','2021-11-07 13:18:07','614','2021-11-07 15:32:40',10,0),('1','113',237415,'AFTERNOON SHIFT ','2021-11-07','2021-11-07 00:00:00',NULL,'530',2165300.15,2165300.15,'530','2021-11-08 07:19:48','614','2021-11-08 21:29:03',10,0),('1','113',237592,'MORNING SHIFT ','2021-11-08','2021-11-08 00:00:00',NULL,'530',2261592.20,2261592.20,'530','2021-11-09 04:59:56','614','2021-11-09 05:38:05',10,0),('1','113',237627,'AFTERNOON SHIFT ','2021-11-08','2021-11-08 00:00:00',NULL,'530',3335149.60,3335149.60,'530','2021-11-09 06:50:37','614','2021-11-09 07:16:47',10,0),('1','113',237705,'MORNING SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'530',0.00,0.00,'530','2021-11-09 11:32:16','614','2021-11-09 15:23:40',10,0),('1','113',237793,'MORNING SHIFT ','2021-11-09','2021-11-09 00:00:00',NULL,'530',1621431.45,1621431.45,'530','2021-11-09 16:49:04','614','2021-11-09 17:08:57',10,0),('1','113',237914,'AFTERNOON SHIFT ','2021-11-09','2021-11-09 00:00:00',NULL,'530',3333987.50,3333987.50,'530','2021-11-10 07:34:02','614','2021-11-10 10:07:34',10,0),('1','113',237993,'MORNING SHIFT ','2021-11-10','2021-11-10 00:00:00',NULL,'530',1539120.65,1539120.65,'530','2021-11-10 13:22:25','614','2021-11-10 13:31:56',10,0),('1','113',238085,'AFTERNOON SHIFT ','2021-11-10','2021-11-10 00:00:00',NULL,'530',2861135.50,2861135.50,'530','2021-11-11 08:01:15','614','2021-11-11 08:36:00',10,0),('1','113',238227,'MORNING SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'530',2125450.60,2125450.60,'530','2021-11-11 13:03:57','614','2021-11-11 13:22:15',10,0),('1','113',238324,'AFTERNOON SHIFT ','2021-11-11','2021-11-11 00:00:00',NULL,'530',2783852.55,2783852.55,'530','2021-11-12 07:57:32','614','2021-11-12 09:38:23',10,0),('1','113',238536,'MORNING SHIFT ','2021-11-12','2021-11-12 00:00:00',NULL,'530',1467842.60,1467842.60,'530','2021-11-12 15:59:14','614','2021-11-12 16:07:44',10,0),('1','113',238619,'AFTERNOON SHIFT ','2021-11-12','2021-11-12 00:00:00',NULL,'530',2478783.55,2478783.55,'530','2021-11-13 06:45:25','614','2021-11-13 09:18:01',10,0),('1','113',238726,'MORNING SHIFT ','2021-11-13','2021-11-13 00:00:00',NULL,'530',1872045.05,1872045.05,'530','2021-11-13 13:31:04','614','2021-11-13 18:06:56',10,0),('1','113',238805,'AFTERNOON SHIFT ','2021-11-13','2021-11-13 00:00:00',NULL,'530',2567428.15,2567428.15,'530','2021-11-14 06:34:31','614','2021-11-14 08:13:04',10,0),('1','113',238902,'MORNING SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'530',1593134.50,1593134.50,'530','2021-11-14 14:09:52','614','2021-11-14 14:13:15',10,0),('1','113',239029,'AFTERNOON SHIFT ','2021-11-14','2021-11-14 00:00:00',NULL,'530',3131582.85,3131582.85,'530','2021-11-15 05:53:30','614','2021-11-15 07:06:32',10,0),('1','113',239151,'MORNING SHIFT ','2021-11-15','2021-11-15 00:00:00',NULL,'530',1518160.75,1518160.75,'530','2021-11-15 13:16:20','614','2021-11-15 13:47:58',10,0),('1','113',239285,'AFTERNOON SHIFT ','2021-11-15','2021-11-15 00:00:00',NULL,'530',2778435.35,2778435.35,'530','2021-11-16 06:19:10','614','2021-11-16 13:28:23',10,0),('1','113',239444,'MORNING SHIFT ','2021-11-16','2021-11-16 00:00:00',NULL,'530',3101783.85,3101783.85,'530','2021-11-16 16:05:48','614','2021-11-16 17:11:34',10,0),('1','113',239468,'AFTERNOON SHIFT ','2021-11-16','2021-11-16 00:00:00',NULL,'530',3265354.05,3265354.05,'530','2021-11-17 06:50:13','614','2021-11-17 07:05:08',10,0),('1','113',239614,'MORNING SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'530',1810771.80,1810771.80,'530','2021-11-17 13:38:45','614','2021-11-17 13:45:54',10,0),('1','113',239726,'AFTERNOON SHIFT ','2021-11-17','2021-11-17 00:00:00',NULL,'530',2834960.50,2834960.50,'530','2021-11-17 21:36:45','614','2021-11-17 21:52:40',10,0),('1','113',239834,'MORNING SHIFT ','2021-11-18','2021-11-18 00:00:00',NULL,'530',1587054.25,1587054.25,'530','2021-11-18 13:32:54','614','2021-11-18 13:45:13',10,0),('1','113',240005,'AFTERNOON SHIFT ','2021-11-18','2021-11-18 00:00:00',NULL,'530',3408892.70,3408892.70,'530','2021-11-19 06:34:17','614','2021-11-19 06:40:23',10,0),('1','113',240118,'MORNING SHIFT ','2021-11-19','2021-11-19 00:00:00',NULL,'530',2049497.40,2049497.40,'530','2021-11-19 14:22:45','614','2021-11-19 19:14:41',10,0),('1','113',240235,'AFTERNOON SHIFT ','2021-11-19','2021-11-19 00:00:00',NULL,'530',3426086.20,3426086.20,'530','2021-11-20 07:40:06','614','2021-11-20 10:38:28',10,0),('1','113',240312,'MORNING SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'530',1908258.90,1908258.90,'530','2021-11-20 13:28:38','614','2021-11-20 13:48:50',10,0),('1','113',240477,'AFTERNOON SHIFT ','2021-11-20','2021-11-20 00:00:00',NULL,'530',3091720.90,3091720.90,'530','2021-11-21 07:14:51','614','2021-11-21 07:52:36',10,0),('1','113',240550,'MORNING SHIFT ','2021-11-21','2021-11-21 00:00:00',NULL,'530',3058073.30,3058073.30,'530','2021-11-21 13:02:50','614','2021-11-21 14:27:23',10,0),('1','113',240630,'AFTERNOON SHIFT ','2021-11-21','2021-11-21 00:00:00',NULL,'530',2458669.65,2458669.65,'530','2021-11-22 07:19:05','614','2021-11-22 09:59:10',10,0),('1','113',240790,'MORNING SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'530',2143069.70,2143069.70,'530','2021-11-22 13:30:58','614','2021-11-22 14:20:52',10,0),('1','113',240976,'AFTERNOON SHIFT ','2021-11-22','2021-11-22 00:00:00',NULL,'530',2534880.50,2534880.50,'530','2021-11-23 06:21:05','614','2021-11-23 08:08:34',10,0),('1','113',241059,'MORNING SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'530',0.00,0.00,'530','2021-11-23 09:37:54','614','2021-11-23 14:49:57',10,0),('1','113',241144,'MORNING SHIFT ','2021-11-23','2021-11-23 00:00:00',NULL,'530',1906412.90,1906412.90,'530','2021-11-23 15:25:10','614','2021-11-23 20:34:27',10,0),('1','113',241254,'AFTERNOON SHIFT ','2021-11-23','2021-11-23 00:00:00',NULL,'530',2631027.65,2631027.65,'530','2021-11-24 07:16:30','614','2021-11-24 08:49:05',10,0),('1','113',241338,'MORNING SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'530',2247691.75,2247691.75,'530','2021-11-24 13:28:30','614','2021-11-24 16:05:52',10,0),('1','113',241500,'AFTERNOON SHIFT ','2021-11-24','2021-11-24 00:00:00',NULL,'530',3807002.35,3807002.35,'530','2021-11-25 06:35:51','614','2021-11-25 09:00:29',10,0),('1','113',241632,'MORNING SHIFT ','2021-11-25','2021-11-25 00:00:00',NULL,'530',2133977.75,2133977.75,'530','2021-11-25 13:43:43','614','2021-11-25 14:18:37',10,0),('1','113',241758,'AFTERNOON SHIFT ','2021-11-25','2021-11-25 00:00:00',NULL,'530',4375292.85,4375292.85,'530','2021-11-26 10:40:51','614','2021-11-26 12:00:40',10,0),('1','113',241878,'MORNING SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'530',1267928.60,1267928.60,'530','2021-11-26 14:02:41','614','2021-11-26 14:30:09',10,0),('1','113',241941,'AFTERNOON SHIFT ','2021-11-26','2021-11-26 00:00:00',NULL,'530',2036505.90,2036505.90,'530','2021-11-26 21:39:31','614','2021-11-27 07:07:33',10,0),('1','113',242077,'MORNING SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'530',1753499.15,1753499.15,'530','2021-11-27 12:49:32','614','2021-11-27 17:03:07',10,0),('1','113',242171,'AFTERNOON SHIFT ','2021-11-27','2021-11-27 00:00:00',NULL,'530',4284779.35,4284779.35,'530','2021-11-27 22:11:18','614','2021-11-28 06:03:01',10,0),('1','113',242313,'MORNING SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'530',2040880.70,2040880.70,'530','2021-11-28 13:35:27','614','2021-11-28 16:58:07',10,0),('1','113',242365,'AFTERNOON SHIFT ','2021-11-28','2021-11-28 00:00:00',NULL,'530',0.00,0.00,'530','2021-11-28 18:16:11','614','2021-11-29 06:19:28',10,0),('1','113',242444,'AFTERNOON SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'530',2409913.25,2409913.25,'530','2021-11-29 06:41:04','614','2021-11-29 07:18:10',10,0),('1','113',242546,'MORNING SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'530',1918399.90,1918399.90,'530','2021-11-29 12:45:51','614','2021-11-29 13:20:38',10,0),('1','113',242643,'AFTERNOON SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'530',4461029.95,4461029.95,'530','2021-11-29 21:54:31','614','2021-11-30 14:25:55',10,0),('1','113',242826,'MORNING SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'530',3001017.65,3001017.65,'530','2021-11-30 14:45:37','614','2021-11-30 21:17:04',10,0),('1','113',242889,'AFTERNOON SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'530',1858486.20,1858486.20,'530','2021-11-30 21:44:17','614','2021-11-30 21:56:57',10,0),('1','113',242968,'MORNING SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'530',0.00,0.00,'530','2021-12-01 07:53:00','614','2021-12-01 15:42:33',10,0),('1','113',243087,'MORNING SHIFT ','2021-12-01','2021-12-01 00:00:00',NULL,'530',2646026.75,2646026.75,'530','2021-12-01 19:17:43','614','2021-12-02 06:17:51',10,0),('1','113',243156,'AFTERNOON SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'530',4553877.95,4553877.95,'530','2021-12-02 06:57:02','614','2021-12-02 08:37:50',10,0),('1','113',243274,'MORNING SHIFT ','2021-12-02','2021-12-02 00:00:00',NULL,'530',2373303.20,2373303.20,'530','2021-12-02 14:17:21','614','2021-12-03 06:10:01',10,0),('1','113',243395,'AFTERNOON SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'530',3787510.65,3787510.65,'530','2021-12-03 07:20:16','614','2021-12-03 08:36:33',10,0),('1','113',243508,'MORNING SHIFT ','2021-12-03','2021-12-03 00:00:00',NULL,'530',2253293.95,2253293.95,'530','2021-12-03 14:05:22','614','2021-12-03 14:17:16',10,0),('1','113',243614,'AFTERNOON SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'530',2909724.05,2909724.05,'530','2021-12-04 06:51:25','614','2021-12-04 07:01:42',10,0),('1','113',243682,'MORNING SHIFT ','2021-12-04','2021-12-04 00:00:00',NULL,'530',2664529.15,2664529.15,'530','2021-12-04 14:18:18','614','2021-12-04 14:42:05',10,0),('1','113',243777,'AFTERNOON SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'530',3439364.80,3439364.80,'530','2021-12-05 07:27:04','614','2021-12-05 12:24:19',10,0),('1','113',243937,'MORNING SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'530',1845606.75,1845606.75,'530','2021-12-05 13:02:13','614','2021-12-05 14:30:04',10,0),('1','113',244117,'AFTERNOON SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'530',3300833.40,3300833.40,'530','2021-12-06 08:10:39','614','2021-12-06 13:31:50',10,0),('1','113',244184,'MORNING SHIFT ','2021-12-06','2021-12-06 00:00:00',NULL,'530',1799873.65,1799873.65,'530','2021-12-06 13:54:36','614','2021-12-06 15:39:13',10,0),('1','113',244297,'AFTERNOON SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'530',3174170.10,3174170.10,'530','2021-12-07 06:56:28','614','2021-12-07 10:44:27',10,0),('1','113',244431,'MORNING SHIFT ','2021-12-07','2021-12-07 00:00:00',NULL,'530',1854517.40,1854517.40,'530','2021-12-07 13:58:27','426','2021-12-07 15:39:54',10,0),('1','113',244539,'AFTERNOON SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'530',3364029.75,3364029.75,'530','2021-12-08 07:07:02','614','2021-12-08 13:38:13',10,0),('1','113',244643,'MORNING SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'530',3564891.35,3564891.35,'530','2021-12-08 13:46:04','614','2021-12-08 13:48:02',10,0),('1','113',244648,'AFTERNOON SHIFT ','2021-12-08','2021-12-08 00:00:00',NULL,'530',0.00,0.00,'530','2021-12-08 14:14:15','614','2021-12-08 15:52:11',10,0),('1','113',244772,'AFTERNOON SHIFT ','2021-12-08','2021-12-08 00:00:00',NULL,'530',3090979.65,3090979.65,'530','2021-12-09 06:57:31','614','2021-12-09 13:31:48',10,0),('1','113',244876,'MORNING SHIFT ','2021-12-09','2021-12-09 00:00:00',NULL,'530',1774577.20,1774577.20,'530','2021-12-09 14:06:28','614','2021-12-09 14:26:38',10,0),('1','113',245004,'AFTERNOON SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'530',2955571.85,2955571.85,'530','2021-12-10 07:00:11','614','2021-12-10 11:18:07',10,0),('1','113',245126,'MORNING SHIFT ','2021-12-10','2021-12-10 00:00:00',NULL,'530',1466275.45,1466275.45,'530','2021-12-10 15:04:56','614','2021-12-11 06:05:46',10,0),('1','113',245489,'MORNING SHIFT ','2021-12-11','2021-12-11 00:00:00',NULL,'530',1735755.60,1735755.60,'530','2021-12-12 08:06:57','614','2021-12-12 10:58:04',10,0),('1','113',245824,'MORNING SHIFT ','2021-12-13','2021-12-13 00:00:00',NULL,'530',1379707.55,1379707.55,'530','2021-12-13 14:36:23','614','2021-12-13 14:45:36',10,0),('1','113',245999,'AFTERNOON SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'530',1621252.60,1621252.60,'530','2021-12-14 08:16:01','614','2021-12-14 08:37:50',10,0),('1','113',246098,'MORNING SHIFT ','2021-12-14','2021-12-14 00:00:00',NULL,'530',518167.95,518167.95,'530','2021-12-14 14:57:10','614','2021-12-14 15:26:16',10,0),('1','113',246250,'AFTERNOON SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'530',1391677.10,1391677.10,'530','2021-12-15 08:28:20','614','2021-12-15 11:03:03',10,0),('1','113',246358,'MORNING SHIFT ','2021-12-15','2021-12-15 00:00:00',NULL,'530',871886.15,871886.15,'530','2021-12-15 14:26:31','614','2021-12-15 15:19:18',10,0),('1','113',246486,'AFTERNOON SHIFT ','2021-12-15','2021-12-15 00:00:00',NULL,'530',2774705.00,2774705.00,'530','2021-12-16 07:24:38','614','2021-12-16 07:40:57',10,0),('1','113',246593,'MORNING SHIFT ','2021-12-16','2021-12-16 00:00:00',NULL,'530',1470772.50,1470772.50,'530','2021-12-16 13:51:51','614','2021-12-16 14:42:46',10,0),('1','113',246738,'AFTERNOON SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'530',3384949.70,3384949.70,'530','2021-12-17 07:39:47','614','2021-12-17 08:19:20',10,0),('1','113',246796,'MORNING SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'530',2280225.90,2280225.90,'530','2021-12-17 13:50:18','614','2021-12-17 17:15:17',10,0),('1','113',246915,'AFTERNOON SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'530',2233837.25,2233837.25,'530','2021-12-18 05:30:01','614','2021-12-18 13:22:39',10,0),('1','113',247090,'MORNING SHIFT ','2021-12-18','2021-12-18 00:00:00',NULL,'530',1855517.70,1855517.70,'530','2021-12-18 15:32:09','614','2021-12-18 15:55:21',10,0),('1','113',247148,'AFTERNOON SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'530',2630177.60,2630177.60,'530','2021-12-19 07:10:33','614','2021-12-19 09:17:21',10,0),('1','113',247311,'MORNING SHIFT ','2021-12-19','2021-12-19 00:00:00',NULL,'530',1478499.30,1478499.30,'530','2021-12-19 14:15:33','614','2021-12-19 14:36:33',10,0),('1','113',247427,'AFTERNOON SHIFT ','2021-12-19','2021-12-19 00:00:00',NULL,'530',2459550.85,2459550.85,'530','2021-12-20 07:04:13','614','2021-12-20 09:56:35',10,0),('1','113',247532,'MORNING SHIFT ','2021-12-20','2021-12-20 00:00:00',NULL,'530',1459165.40,1459165.40,'530','2021-12-20 13:17:38','614','2021-12-20 13:38:27',10,0),('1','113',247688,'AFTERNOON SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'530',2778316.95,2778316.95,'530','2021-12-21 07:01:15','614','2021-12-21 07:05:33',10,0),('1','113',247807,'MORNING SHIFT ','2021-12-21','2021-12-21 00:00:00',NULL,'530',1329659.15,1329659.15,'530','2021-12-21 14:14:01','614','2021-12-21 14:17:57',10,0),('1','113',247924,'AFTERNOON SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'530',3314132.80,3314132.80,'530','2021-12-22 06:34:38','614','2021-12-22 06:52:04',10,0),('1','113',248045,'MORNING SHIFT ','2021-12-22','2021-12-22 00:00:00',NULL,'530',1996454.80,1996454.80,'530','2021-12-22 13:39:53','614','2021-12-22 14:00:37',10,0),('1','113',248179,'AFTERNOON SHIFT ','2021-12-22','2021-12-22 00:00:00',NULL,'530',3559231.70,3559231.70,'530','2021-12-23 06:49:15','614','2021-12-23 07:21:56',10,0),('1','113',248206,'MORNING SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'530',2036830.80,2036830.80,'530','2021-12-23 13:08:48','614','2021-12-23 14:17:17',10,0),('1','113',248321,'AFTERNOON SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'530',0.00,0.00,'530','2021-12-24 06:32:39','614','2021-12-24 13:39:26',10,0),('1','113',248521,'AFTERNOON SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'530',2974539.80,2974539.80,'530','2021-12-24 13:51:49','614','2021-12-24 13:52:12',10,0),('1','113',248523,'MORNING SHIFT ','2021-12-24','2021-12-24 00:00:00',NULL,'530',2508391.60,2508391.60,'530','2021-12-24 14:01:21','614','2021-12-25 05:49:03',10,0),('1','113',248643,'AFTERNOON SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'530',2896158.90,2896158.90,'530','2021-12-25 06:13:52','614','2021-12-25 06:20:35',10,0),('1','113',248707,'MORNING SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'530',1535167.10,1535167.10,'530','2021-12-25 12:48:50','614','2021-12-25 13:46:14',10,0),('1','113',248870,'AFTERNOON SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'530',1764941.25,1764941.25,'530','2021-12-26 06:25:37','614','2021-12-26 06:40:14',10,0),('1','113',248997,'MORNING SHIFT ','2021-12-26','2021-12-26 00:00:00',NULL,'530',200500.85,200500.85,'530','2021-12-26 13:36:16','614','2021-12-26 13:59:50',10,0),('1','113',249075,'AFTERNOON SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'530',292203.75,292203.75,'530','2021-12-26 21:20:44','614','2021-12-26 21:41:05',10,0),('1','113',249111,'MORNING SHIFT ','2021-12-27','2021-12-27 00:00:00',NULL,'530',432880.30,432880.30,'530','2021-12-27 13:42:36','614','2021-12-27 14:02:48',10,0),('1','113',249351,'AFTERNOON SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'530',2757359.70,2757359.70,'530','2021-12-28 06:58:33','614','2021-12-28 15:57:33',10,0),('1','113',249518,'MORNING SHIFT ','2021-12-28','2021-12-28 00:00:00',NULL,'530',1343422.35,1343422.35,'530','2021-12-28 16:11:59','614','2021-12-28 23:46:32',10,0),('1','113',249584,'AFTERNOON SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'530',2410694.60,2410694.60,'530','2021-12-29 05:59:32','614','2021-12-29 08:40:35',10,0),('1','113',249677,'MORNING SHIFT ','2021-12-29','2021-12-29 00:00:00',NULL,'530',1427518.50,1427518.50,'530','2021-12-29 13:01:43','614','2021-12-29 15:26:38',10,0),('1','113',249820,'AFTERNOON SHIFT ','2021-12-29','2021-12-29 00:00:00',NULL,'530',2673282.25,2673282.25,'530','2021-12-29 21:23:06','614','2021-12-29 22:38:59',10,0),('1','113',249949,'MORNING SHIFT ','2021-12-30','2021-12-30 00:00:00',NULL,'530',1579569.75,1579569.75,'530','2021-12-30 13:04:01','614','2021-12-30 13:41:36',10,0),('1','113',250062,'AFTERNOON SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'530',2710402.20,2710402.20,'530','2021-12-30 20:44:34','614','2021-12-30 20:52:19',10,0),('1','113',250151,'MORNING SHIFT ','2021-12-31','2021-12-31 00:00:00',NULL,'530',0.00,0.00,'530','2021-12-31 09:28:15','614','2021-12-31 15:28:31',10,0),('1','113',250258,'MORNING SHIFT ','2021-12-31','2021-12-31 00:00:00',NULL,'530',242097.90,242097.90,'530','2021-12-31 15:58:42','614','2021-12-31 18:28:08',10,0),('1','113',250306,'AFTERNOON SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'530',1066046.85,1066046.85,'530','2021-12-31 21:33:17','614','2022-01-01 01:44:32',10,0),('1','113',250423,'MORNING SHIFT ','2022-01-01','2022-01-01 00:00:00',NULL,'530',905262.60,905262.60,'530','2022-01-01 14:39:59','614','2022-01-01 20:17:36',10,0),('1','113',250538,'AFTERNOON SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'530',1474268.40,1474268.40,'530','2022-01-01 21:40:53','614','2022-01-02 06:42:02',10,0),('1','113',250674,'MORNING SHIFT ','2022-01-02','2022-01-02 00:00:00',NULL,'530',805130.70,805130.70,'530','2022-01-02 13:12:05','614','2022-01-02 18:57:35',10,0),('1','113',250770,'AFTERNOON SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'530',1466968.80,1466968.80,'530','2022-01-02 21:35:36','614','2022-01-03 06:13:30',10,0),('1','113',250918,'MORNING SHIFT ','2022-01-03','2022-01-03 00:00:00',NULL,'530',851322.45,851322.45,'530','2022-01-03 14:00:02','614','2022-01-03 14:42:30',10,0),('1','113',250994,'AFTERNOON SHIFT ','2022-01-03','2022-01-03 00:00:00',NULL,'530',1562281.05,1562281.05,'530','2022-01-03 21:48:23','614','2022-01-04 01:13:34',10,0),('1','113',251138,'MORNING SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'530',817546.95,817546.95,'530','2022-01-04 13:03:13','614','2022-01-04 15:00:41',10,0),('1','113',251251,'AFTERNOON SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'530',3493558.20,3493558.20,'530','2022-01-04 23:16:27','614','2022-01-05 06:11:39',10,0),('1','113',251350,'MORNING SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'530',2285225.25,2285225.25,'530','2022-01-05 14:54:32','614','2022-01-05 17:37:07',10,0),('1','113',251493,'AFTERNOON SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'530',2696293.05,2696293.05,'530','2022-01-05 22:33:50','614','2022-01-05 23:04:17',10,0),('1','113',251626,'MORNING SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'530',1711059.90,1711059.90,'530','2022-01-06 14:28:26','614','2022-01-06 14:50:24',10,0),('1','113',251732,'AFTERNOON SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'530',2578593.60,2578593.60,'530','2022-01-06 22:25:46','614','2022-01-06 23:53:28',10,0),('1','113',251756,'MORNING SHIFT ','2022-01-07','2022-01-07 00:00:00',NULL,'530',2371978.95,2371978.95,'530','2022-01-07 14:19:32','614','2022-01-07 19:52:39',10,0),('1','113',251937,'AFTERNOON SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'530',0.00,0.00,'530','2022-01-07 20:48:35','614','2022-01-07 22:22:57',10,0),('1','113',251965,'AFTERNOON SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'530',2550546.90,2550546.90,'530','2022-01-07 22:35:13','614','2022-01-07 22:47:18',10,0),('1','113',252049,'MORNING SHIFT ','2022-01-08','2022-01-08 00:00:00',NULL,'530',0.00,0.00,'530','2022-01-08 13:08:56','614','2022-01-08 13:36:20',10,0),('1','113',252114,'MORNING SHIFT ','2022-01-08','2022-01-08 00:00:00',NULL,'530',1337838.15,1337838.15,'530','2022-01-08 13:48:06','614','2022-01-08 13:59:32',10,0),('1','113',252206,'AFTERNOON SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'530',4127093.85,4127093.85,'530','2022-01-08 22:42:20','614','2022-01-08 23:40:33',10,0),('1','113',252341,'MORNING SHIFT ','2022-01-09','2022-01-09 00:00:00',NULL,'530',2313649.80,2313649.80,'530','2022-01-09 14:34:39','614','2022-01-09 14:45:59',10,0),('1','113',252445,'AFTERNOON SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'530',2588097.60,2588097.60,'530','2022-01-09 22:36:29','614','2022-01-09 22:50:04',10,0),('1','113',252583,'MORNING SHIFT ','2022-01-10','2022-01-10 00:00:00',NULL,'530',1789961.25,1789961.25,'530','2022-01-10 14:00:17','614','2022-01-10 16:52:28',10,0),('1','113',252684,'AFTERNOON SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'530',4308183.00,4308183.00,'530','2022-01-10 22:34:36','614','2022-01-10 22:51:03',10,0),('1','113',252848,'MORNING SHIFT ','2022-01-11','2022-01-11 00:00:00',NULL,'530',2116852.65,2116852.65,'530','2022-01-11 14:29:24','614','2022-01-11 14:54:15',10,0),('1','113',252945,'AFTERNOON SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'530',3838198.65,3838198.65,'530','2022-01-11 23:02:03','614','2022-01-11 23:56:18',10,0),('1','113',253102,'MORNING SHIFT ','2022-01-12','2022-01-12 00:00:00',NULL,'530',2354495.55,2354495.55,'530','2022-01-12 14:51:08','614','2022-01-12 19:32:07',10,0),('1','113',253183,'AFTERNOON SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'530',3318765.45,3318765.45,'530','2022-01-12 22:32:01','614','2022-01-12 23:27:05',10,0),('1','113',253377,'MORNING SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'530',997505.85,997505.85,'530','2022-01-13 14:55:27','614','2022-01-13 15:18:28',10,0),('1','113',253452,'AFTERNOON SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'530',4003027.05,4003027.05,'530','2022-01-14 15:45:39','614','2022-01-14 15:46:58',10,0),('1','113',253629,'MORNING SHIFT ','2022-01-14','2022-01-14 00:00:00',NULL,'530',2599324.20,2599324.20,'530','2022-01-14 16:12:26','614','2022-01-14 16:18:37',10,0),('1','113',253690,'AFTERNOON SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'530',4721022.90,4721022.90,'530','2022-01-14 23:19:50','614','2022-01-15 07:10:56',10,0),('1','113',253752,'MORNING SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'530',2515627.95,2515627.95,'530','2022-01-15 14:52:14','614','2022-01-15 15:01:49',10,0),('1','113',253929,'AFTERNOON SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'530',3630140.25,3630140.25,'530','2022-01-15 22:59:28','614','2022-01-16 08:17:54',10,0),('1','113',254072,'MORNING SHIFT ','2022-01-16','2022-01-16 00:00:00',NULL,'530',1139143.50,1139143.50,'530','2022-01-16 14:56:24','614','2022-01-16 15:11:24',10,0),('1','113',254167,'AFTERNOON SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'530',5997269.85,5997269.85,'530','2022-01-16 23:00:12','614','2022-01-17 10:07:53',10,0),('1','113',254325,'MORNING SHIFT ','2022-01-17','2022-01-17 00:00:00',NULL,'530',2059264.35,2059264.35,'530','2022-01-17 13:51:46','614','2022-01-17 15:09:02',10,0),('1','113',254421,'AFTERNOON SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'530',2026434.30,2026434.30,'530','2022-01-17 22:34:39','614','2022-01-18 09:59:06',10,0),('1','113',254575,'MORNING SHIFT ','2022-01-18','2022-01-18 00:00:00',NULL,'530',2184557.10,2184557.10,'530','2022-01-18 14:20:21','614','2022-01-18 15:52:31',10,0),('1','113',254700,'AFTERNOON SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'530',2145384.00,2145384.00,'530','2022-01-19 07:13:36','614','2022-01-19 08:06:13',10,0),('1','113',254792,'MORNING SHIFT ','2022-01-19','2022-01-19 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',254796,'MORNING SHIFT ','2022-01-19','2022-01-19 00:00:00',NULL,'530',0.00,0.00,'530','2022-01-19 13:11:26','614','2022-01-19 13:31:40',10,0),('1','113',254835,'MORNING SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'530',1590138.90,1590138.90,'530','2022-01-19 14:01:41','614','2022-01-19 15:39:55',10,0),('1','113',254922,'AFTERNOON SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'530',2507023.05,2507023.05,'530','2022-01-19 23:09:38','614','2022-01-20 10:32:22',10,0),('1','113',255064,'MORNING SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'530',3662880.75,3662880.75,'530','2022-01-20 13:28:56','614','2022-01-20 16:39:08',10,0),('1','113',255165,'AFTERNOON SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'530',3487021.35,3487021.35,'530','2022-01-20 22:38:30','614','2022-01-20 23:02:52',10,0),('1','113',255330,'MORNING SHIFT ','2022-01-21','2022-01-21 00:00:00',NULL,'530',1382414.10,1382414.10,'530','2022-01-21 14:57:52','614','2022-01-21 15:08:49',10,0),('1','113',255437,'AFTERNOON SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'530',2978161.55,2978161.55,'530','2022-01-21 22:33:45','614','2022-01-22 00:44:01',10,0),('1','113',255605,'MORNING SHIFT ','2022-01-22','2022-01-22 00:00:00',NULL,'530',1180004.90,1180004.90,'530','2022-01-22 15:05:27','614','2022-01-22 23:57:57',10,0),('1','113',255723,'AFTERNOON SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'530',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','113',255724,'AFTERNOON SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'530',4162857.75,4162857.75,'530','2022-01-23 07:57:35','614','2022-01-23 09:05:23',10,0),('1','113',255767,'MORNING SHIFT ','2022-01-23','2022-01-23 00:00:00',NULL,'530',0.00,0.00,'530','2022-01-23 09:50:55','614','2022-01-23 09:51:48',10,0),('1','113',255839,'MORNING SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'530',1496132.30,1496132.30,'530','2022-01-23 14:42:52','614','2022-01-23 15:53:11',10,0),('1','113',255949,'AFTERNOON SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'530',2568082.65,2568082.65,'530','2022-01-24 07:25:10','614','2022-01-24 09:59:50',10,0),('1','113',256100,'MORNING SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'530',2310906.00,2310906.00,'530','2022-01-24 14:38:35','614','2022-01-24 17:59:32',10,0),('1','113',256255,'AFTERNOON SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'530',2424859.25,2424859.25,'530','2022-01-25 08:58:35','614','2022-01-25 09:19:00',10,0),('1','113',256294,'MORNING SHIFT 1','2022-01-25','2022-01-25 00:00:00',NULL,'530',368298.00,368298.00,'530','2022-01-25 10:42:15','614','2022-01-25 10:48:36',10,0),('1','113',256363,'MORNING SHIFT 2','2022-01-25','2022-01-25 00:00:00',NULL,'530',1235729.40,1235729.40,'530','2022-01-25 14:34:53','614','2022-01-25 15:39:30',10,0),('1','113',256466,'AFTERNOON SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'530',3995224.05,3995224.05,'530','2022-01-25 23:59:11','614','2022-01-26 07:19:10',10,0),('1','113',256640,'MORNING SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'530',2029942.80,2029942.80,'530','2022-01-26 16:19:02','614','2022-01-26 23:32:11',10,0),('1','113',256713,'AFTERNOON SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'530',9422278.90,9422278.90,'530','2022-01-27 06:34:50','614','2022-01-27 10:02:28',10,0),('1','113',256862,'MORNING SHIFT ','2022-01-27','2022-01-27 00:00:00',NULL,'530',1517772.45,1517772.45,'530','2022-01-27 14:59:47','614','2022-01-27 17:31:32',10,0),('1','113',256938,'AFTERNOON SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'530',2873720.10,2873720.10,'530','2022-01-27 23:13:34','614','2022-01-28 08:08:12',10,0),('1','113',257067,'MORNING SHIFT 1','2022-01-28','2022-01-28 00:00:00',NULL,'530',283872.20,283872.20,'530','2022-01-28 11:53:38','614','2022-01-28 11:55:29',10,0),('1','113',257099,'MORNING SHIFT  2','2022-01-28','2022-01-28 00:00:00',NULL,'530',1713396.90,1713396.90,'530','2022-01-28 14:26:21','614','2022-01-28 17:56:49',10,0),('1','113',257191,'AFTERNOON SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'530',0.00,0.00,'530','2022-01-28 20:26:58','614','2022-01-29 00:35:33',10,0),('1','113',257240,'AFTERNOON SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'530',2571411.30,2571411.30,'530','2022-01-29 07:14:55','614','2022-01-29 08:50:34',10,0),('1','113',257291,'MORNING SHIFT ','2022-01-29','2022-01-29 00:00:00',NULL,'530',1571661.15,1571661.15,'530','2022-01-29 14:06:33','614','2022-01-29 16:44:23',10,0),('1','113',257501,'AFTERNOON SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'530',2593121.85,2593121.85,'530','2022-01-30 07:35:41','614','2022-01-30 07:39:38',10,0),('1','113',257619,'MORNING SHIFT ','2022-01-30','2022-01-30 00:00:00',NULL,'530',1064880.90,1064880.90,'530','2022-01-30 14:15:35','614','2022-01-30 15:35:02',10,0),('1','113',257620,'AFTERNOON SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'530',2669042.10,2669042.10,'530','2022-01-31 07:28:09','614','2022-01-31 10:16:31',10,0),('1','113',257621,'MORNING SHIFT ','2022-01-30','2022-01-30 00:00:00',NULL,'530',0.00,0.00,'530','2022-01-31 12:19:21','614','2022-01-31 12:37:21',10,0),('1','113',257622,'MORNING SHIFT ','2022-01-31','2022-01-31 00:00:00',NULL,'530',2542470.75,2542470.75,'530','2022-01-31 15:52:20','614','2022-01-31 18:22:51',10,0),('1','113',257623,'AFTERNOON SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'530',2699197.80,2699197.80,'530','2022-01-31 22:41:44','614','2022-01-31 23:01:29',10,0),('1','113',257624,'MORNING SHIFT ','2022-02-01','2022-02-01 00:00:00',NULL,'530',1490991.30,1490991.30,'530','2022-02-01 14:54:10','614','2022-02-01 15:58:03',10,0),('1','113',257625,'AFTERNOON SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'530',3698591.85,3698591.85,'530','2022-02-01 22:40:36','614','2022-02-02 05:37:40',10,0),('1','113',257626,'MORNING SHIFT ','2022-02-02','2022-02-02 00:00:00',NULL,'530',2278384.05,2278384.05,'530','2022-02-02 13:51:55','614','2022-02-02 16:28:37',10,0),('1','113',257627,'AFTERNOON SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'530',3528714.30,3528714.30,'530','2022-02-02 22:58:17','614','2022-02-03 07:10:55',10,0),('1','113',257628,'MORNING SHIFT ','2022-02-03','2022-02-03 00:00:00',NULL,'530',3095841.75,3095841.75,'530','2022-02-03 14:35:59','614','2022-02-03 15:09:39',10,0),('1','113',257629,'AFTERNOON SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'530',3341664.15,3341664.15,'530','2022-02-03 22:57:13','614','2022-02-03 23:12:43',10,0),('1','113',257630,'MORNING SHIFT ','2022-02-04','2022-02-04 00:00:00',NULL,'530',0.00,0.00,'530','2022-02-04 07:57:36','614','2022-02-04 19:19:33',10,0),('1','113',257631,'MORNING SHIFT ','2022-02-04','2022-02-04 00:00:00',NULL,'530',1880019.60,1880019.60,'530','2022-02-04 19:26:10','614','2022-02-04 19:27:15',10,0),('1','113',257632,'AFTERNOON SHIFT 1','2022-02-04','2022-02-04 00:00:00',NULL,'530',402901.20,402901.20,'530','2022-02-04 19:33:23','614','2022-02-04 19:34:38',10,0),('1','113',257633,'AFTERNOON SHIFT 2','2022-02-04','2022-02-04 00:00:00',NULL,'530',3171774.45,3171774.45,'530','2022-02-05 07:55:56','614','2022-02-05 08:12:40',10,0),('1','113',257634,'MORNING SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'530',1847133.60,1847133.60,'530','2022-02-05 13:53:10','614','2022-02-05 15:40:30',10,0),('1','113',257635,'AFTERNOON SHIFT ','2022-02-06','2022-02-06 00:00:00',NULL,'530',2979914.60,2979914.60,'530','2022-02-06 06:38:17','614','2022-02-06 11:02:02',10,0),('1','113',257636,'MORNING SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'530',1496302.05,1496302.05,'530','2022-02-06 14:55:17','614','2022-02-06 15:40:08',10,0),('1','113',257637,'AFTERNOON SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'530',2252893.85,2252893.85,'530','2022-02-07 08:25:01','614','2022-02-07 14:57:40',10,0),('1','113',257638,'MORNING SHIFT ','2022-02-07','2022-02-07 00:00:00',NULL,'530',1831286.40,1831286.40,'530','2022-02-07 15:09:07','614','2022-02-07 15:49:56',10,0),('1','113',257639,'AFTERNOON SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'530',3943156.80,3943156.80,'530','2022-02-08 07:54:27','614','2022-02-08 09:17:09',10,0),('1','113',257640,'MORNING SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'530',2683893.10,2683893.10,'530','2022-02-08 13:45:12','614','2022-02-08 14:40:18',10,0),('1','113',257641,'AFTERNOON SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'530',3951386.20,3951386.20,'530','2022-02-08 22:45:45','614','2022-02-08 22:50:52',10,0),('1','113',257642,'MORNING SHIFT ','2022-02-09','2022-02-09 00:00:00',NULL,'530',1616591.90,1616591.90,'530','2022-02-09 14:58:33','614','2022-02-09 16:41:04',10,0),('1','113',257643,'MORNING SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'530',0.00,0.00,'530','2022-02-09 17:06:40','614','2022-02-09 23:41:10',10,0),('1','113',257644,'AFTERNOON SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'530',6223546.45,6223546.45,'530','2022-02-10 07:54:09','614','2022-02-10 10:09:51',10,0),('1','113',257645,'MORNING SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'530',2765241.05,2765241.05,'530','2022-02-10 15:00:49','614','2022-02-10 15:16:16',10,0),('1','113',257646,'AFTERNOON SHIFT ','2022-02-10','2022-02-10 00:00:00',NULL,'530',5899891.25,5899891.25,'530','2022-02-10 23:37:33','614','2022-02-11 08:14:10',10,0),('1','113',257647,'MORNING SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'530',3800096.30,3800096.30,'530','2022-02-11 13:55:28','614','2022-02-11 15:39:03',10,0),('1','113',257648,'AFTERNOON SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'530',7006737.10,7006737.10,'530','2022-02-11 23:40:14','614','2022-02-12 00:20:07',10,0),('1','113',257649,'MORNING SHIFT ','2022-02-12','2022-02-12 00:00:00',NULL,'530',3277983.50,3277983.50,'530','2022-02-12 14:15:06','614','2022-02-12 17:43:38',10,0),('1','113',257650,'AFTERNOON SHIFT 1','2022-02-12','2022-02-12 00:00:00',NULL,'530',916754.30,916754.30,'530','2022-02-12 20:11:50','614','2022-02-12 21:12:17',10,0),('1','113',257651,'AFTERNOON SHIFT 2','2022-02-12','2022-02-12 00:00:00',NULL,'530',5062675.35,5062675.35,'530','2022-02-12 22:15:10','614','2022-02-12 22:46:45',10,0),('1','113',257652,'MORNING SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'530',0.00,0.00,'530','2022-02-13 14:13:44','614','2022-02-13 14:15:31',10,0),('1','113',257653,'MORNING SHIFT ','2022-02-13','2022-02-13 00:00:00',NULL,'530',4727019.85,4727019.85,'530','2022-02-13 14:59:12','614','2022-02-13 15:13:03',10,0),('1','113',257654,'AFTERNOON SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'530',6245239.10,6245239.10,'530','2022-02-13 22:02:22','614','2022-02-13 22:05:18',10,0),('1','113',257655,'MORNING SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'530',4309650.40,4309650.40,'530','2022-02-14 14:49:01','614','2022-02-14 17:19:11',10,0),('1','113',257656,'AFTERNOON SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'530',3274415.10,3274415.10,'530','2022-02-14 21:50:56','614','2022-02-14 23:19:27',10,0),('1','113',257657,'MORNING SHIFT ','2022-02-15','2022-02-15 00:00:00',NULL,'530',5281048.65,5281048.65,'530','2022-02-15 14:39:49','614','2022-02-15 19:16:56',10,0),('1','113',257658,'AFTERNOON SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'530',6403965.85,6403965.85,'530','2022-02-15 23:05:40','614','2022-02-16 06:22:57',10,0),('1','113',257659,'MORNING SHIFT ','2022-02-16','2022-02-16 00:00:00',NULL,'530',5390422.40,5390422.40,'530','2022-02-16 15:14:10','614','2022-02-16 19:34:11',10,0),('1','113',257660,'AFTERNOON SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'530',4238636.30,4238636.30,'530','2022-02-16 23:44:39','614','2022-02-17 10:38:43',10,0),('1','113',257661,'MORNING SHIFT ','2022-02-17','2022-02-17 00:00:00',NULL,'530',9335619.40,9335619.40,'530','2022-02-17 18:32:54','614','2022-02-17 19:22:32',10,0),('1','113',257662,'AFTERNOON SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'530',3844836.90,3844836.90,'530','2022-02-17 22:24:54','614','2022-02-17 23:10:08',10,0),('1','113',257663,'MORNING SHIFT ','2022-02-18','2022-02-18 00:00:00',NULL,'530',0.00,0.00,'530','2022-02-18 09:52:56','614','2022-02-18 11:14:24',10,0),('1','113',257664,'MORNING SHIFT ','2022-02-18','2022-02-18 00:00:00',NULL,'530',9183667.20,9183667.20,'530','2022-02-18 15:44:31','614','2022-02-18 15:45:09',10,0),('1','113',257665,'AFTERNOON SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'530',5840247.15,5840247.15,'530','2022-02-19 08:21:32','614','2022-02-19 09:10:36',10,0),('1','113',257666,'MORNING SHIFT ','2022-02-19','2022-02-19 00:00:00',NULL,'530',1364056.20,1364056.20,'530','2022-02-19 15:05:37','614','2022-02-19 17:52:16',10,0),('1','113',257667,'AFTERNOON SHIFT ','2022-02-19','2022-02-19 00:00:00',NULL,'530',2441736.90,2441736.90,'530','2022-02-20 07:58:11','614','2022-02-20 10:30:08',10,0),('1','113',257668,'MORNING SHIFT ','2022-02-20','2022-02-20 00:00:00',NULL,'530',4213987.50,4213987.50,'530','2022-02-20 15:57:04','614','2022-02-20 17:41:31',10,0),('1','113',257669,'AFTERNOON SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'530',1924128.30,1924128.30,'530','2022-02-21 10:18:02','614','2022-02-21 11:40:20',10,0),('1','113',257670,'MORNING SHIFT ','2022-02-21','2022-02-21 00:00:00',NULL,'530',6949592.10,6949592.10,'530','2022-02-21 14:48:48','614','2022-02-21 19:46:40',10,0),('1','113',257671,'AFTERNOON SHIFT','2022-02-21','2022-02-22 07:55:19','2022-02-23 07:55:19','530',1846995.15,1846995.15,'530','2022-02-22 07:59:54','614','2022-02-22 08:20:12',10,0),('1','113',257672,'MORNING SHIFT ','2022-02-22','2022-02-22 10:16:06','2022-02-23 10:16:06','530',0.00,0.00,'530','2022-02-22 10:24:54','614','2022-02-22 20:51:32',10,0),('1','113',257673,'MORNING SHIFT ','2022-02-22','2022-02-22 21:12:42','2022-02-23 21:12:42','530',1291032.30,1291032.30,'530','2022-02-22 21:15:52','614','2022-02-22 21:17:06',10,0),('1','113',257674,'AFTERNOON SHIFT 1','2022-02-22','2022-02-22 21:19:22','2022-02-23 21:19:22','530',106506.90,106506.90,'530','2022-02-22 21:32:41','614','2022-02-22 21:47:41',10,0),('1','113',257675,'AFTERNOON SHIFT 2','2022-02-22','2022-02-23 08:41:35','2022-02-24 08:41:35','530',2604782.25,2604782.25,'530','2022-02-23 08:45:52','614','2022-02-23 09:58:30',10,0),('1','113',257676,'MORNING SHIFT ','2022-02-23','2022-02-23 14:55:59','2022-02-24 14:55:59','530',4723247.10,4723247.10,'530','2022-02-23 15:03:36','614','2022-02-23 16:40:01',10,0),('1','113',257677,'AFTERNOON SHIFT','2022-02-23','2022-02-23 21:49:19','2022-02-24 21:49:19','530',6177640.55,6177640.55,'530','2022-02-24 08:39:09','614','2022-02-24 16:11:53',10,0),('1','113',257678,'MORNING SHIFT ','2022-02-24','2022-02-24 18:03:50','2022-02-25 18:03:50','530',5515288.75,5515288.75,'530','2022-02-24 18:14:48','614','2022-02-24 23:39:22',10,0),('1','113',257679,'AFTERNOON SHIFT','2022-02-24','2022-02-25 07:31:08','2022-02-26 07:31:08','530',5049891.65,5049891.65,'530','2022-02-25 07:48:41','614','2022-02-25 10:26:54',10,0),('1','113',257680,'MORNING SHIFT','2022-02-25','2022-02-25 11:04:05','2022-02-26 11:04:05','530',5300906.85,5300906.85,'530','2022-02-25 16:01:39','614','2022-02-25 18:44:51',10,0),('1','113',257681,'AFTERNOON SHIFT 1','2022-02-25','2022-02-25 21:31:19','2022-02-26 21:31:19','530',1995867.70,1995867.70,'530','2022-02-25 21:32:42','614','2022-02-26 11:11:02',10,0),('1','113',257682,'AFTERNOON SHIFT 2','2022-02-25','2022-02-26 13:43:39','2022-02-27 13:43:39','530',3921817.15,3921817.15,'530','2022-02-26 13:54:23','614','2022-02-26 19:15:23',10,0),('1','113',257683,'MORNING SHIFT ','2022-02-26','2022-02-26 19:29:54','2022-02-27 19:29:54','530',4233574.25,4233574.25,'530','2022-02-26 19:58:22','614','2022-02-26 20:09:23',10,0),('1','113',257684,'AFTERNOON SHIFT','2022-02-26','2022-02-26 23:40:57','2022-02-27 23:40:57','530',3966125.15,3966125.15,'530','2022-02-27 08:05:01','614','2022-02-27 08:47:00',10,0),('1','113',257685,'MORNING SHIFT ','2022-02-27','2022-02-27 14:51:41','2022-02-28 14:51:41','530',582473.25,582473.25,'530','2022-02-27 16:47:34','614','2022-02-27 16:48:52',10,0),('1','113',257686,'MORNING SHIFT ','2022-02-28','2022-02-28 14:29:59','2022-03-01 14:29:59','530',529357.40,529357.40,'530','2022-02-28 14:32:58','614','2022-02-28 16:08:18',10,0),('1','113',257687,'AFTERNOON SHIFT','2022-02-28','2022-02-28 21:37:16','2022-03-01 21:37:16','530',370574.25,370574.25,'530','2022-02-28 23:23:15','614','2022-03-01 00:30:51',10,0),('1','113',257688,'AFTERNOON SHIFT','2022-02-28','2022-03-01 12:39:47','2022-03-02 12:39:47','530',0.00,0.00,'530','2022-03-01 12:49:34','614','2022-03-01 14:30:47',10,0),('1','113',257689,'AFTERNOON SHIFT','2022-02-28','2022-03-01 20:49:23','2022-03-02 20:49:23','530',0.00,0.00,'530','2022-03-01 20:56:51','614','2022-03-01 23:58:56',10,0),('1','113',257690,'AFTERNOON SHIFT','2022-03-02','2022-03-02 06:57:07','2022-03-03 06:57:07','530',592852.40,599995.20,'530','2022-03-02 08:24:15','614','2022-03-02 09:57:06',10,0),('1','113',257691,'MORNING SHIFT 1','2022-03-02','2022-03-02 12:01:45','2022-03-03 12:01:45','530',1558507.60,1577284.80,'530','2022-03-02 12:06:35','614','2022-03-02 12:12:26',10,0),('1','113',257692,'MORNING SHIFT  2','2022-03-02','2022-03-02 14:48:18','2022-03-03 14:48:18','530',303631.60,303631.60,'530','2022-03-02 15:04:29','614','2022-03-02 17:17:21',10,0),('1','113',257693,'AFTERNOON SHIFT','2022-03-02','2022-03-02 23:04:27','2022-03-03 23:04:27','530',2311000.60,2311000.60,'530','2022-03-02 23:25:49','614','2022-03-02 23:27:16',10,0),('1','113',257694,'MORNING SHIFT ','2022-03-03','2022-03-03 14:56:53','2022-03-04 14:56:53','530',960323.30,960323.30,'530','2022-03-03 14:59:41','614','2022-03-03 15:02:38',10,0),('1','113',257695,'AFTERNOON SHIFT','2022-03-03','2022-03-03 22:26:58','2022-03-04 22:26:58','530',7444056.80,7444056.80,'530','2022-03-03 22:29:26','614','2022-03-04 13:10:21',10,0),('1','113',257696,'MORNING SHIFT ','2022-03-04','2022-03-04 14:45:28','2022-03-05 14:45:28','530',2743077.50,2743077.50,'530','2022-03-04 14:48:44','614','2022-03-04 14:57:04',10,0),('1','113',257697,'AFTERNOON SHIFT','2022-03-04','2022-03-04 21:27:05','2022-03-05 21:27:05','530',3081982.00,3081982.00,'530','2022-03-04 21:33:29','614','2022-03-05 12:00:48',10,0),('1','113',257698,'MORNING SHIFT ','2022-03-05','2022-03-05 14:27:13','2022-03-06 14:27:13','530',2530734.90,2530734.90,'530','2022-03-05 16:08:36','614','2022-03-05 17:59:17',10,0),('1','113',257699,'MORNING SHIFT ','2022-03-07','2022-03-07 15:08:12','2022-03-08 15:08:12','530',3281840.10,3281840.10,'530','2022-03-07 16:29:40','614','2022-03-07 18:37:48',10,0),('1','113',257700,'AFTERNOON SHIFT','2022-03-07','2022-03-08 07:25:35','2022-03-09 07:25:35','530',2097575.70,2097575.70,'530','2022-03-08 07:40:04','614','2022-03-08 07:42:04',10,0),('1','113',257701,'MORNING SHIFT','2022-03-08','2022-03-08 14:57:08','2022-03-09 14:57:08','530',2319461.10,2319461.10,'530','2022-03-08 15:07:53','614','2022-03-08 15:23:29',10,0),('1','113',257702,'AFTERNOON SHIFT','2022-03-08','2022-03-08 17:43:19','2022-03-09 17:43:19','530',2619196.80,2619196.80,'530','2022-03-09 06:58:28','614','2022-03-09 12:06:46',10,0),('1','113',257703,'MORNING SHIFT ','2022-03-09','2022-03-09 13:35:48','2022-03-10 13:35:48','530',2626605.30,2626605.30,'530','2022-03-09 13:48:13','614','2022-03-09 16:09:57',10,0),('1','113',257704,'AFTERNOON SHIFT ','2022-03-09','2022-03-09 22:06:21','2022-03-10 22:06:21','530',3094058.55,3094058.55,'530','2022-03-09 22:11:36','614','2022-03-09 22:16:28',10,0),('1','113',257705,'MORNING SHIFT','2022-03-10','2022-03-10 13:46:51','2022-03-11 13:46:51','530',3101625.45,3101625.45,'530','2022-03-10 14:01:26','614','2022-03-10 14:58:27',10,0),('1','113',257706,'AFTERNOON SHIFT','2022-03-10','2022-03-10 19:28:29','2022-03-11 19:28:29','530',2087710.35,2087710.35,'530','2022-03-10 19:32:03','614','2022-03-10 22:31:24',10,0),('1','113',257707,'MORNING SHIFT','2022-03-11','2022-03-11 13:58:10','2022-03-12 13:58:10','530',821061.45,821061.45,'530','2022-03-11 13:59:42','614','2022-03-11 17:39:54',10,0),('1','113',257708,'MORNING SHIFT','2022-03-12','2022-03-12 13:41:16','2022-03-13 13:41:16','530',418060.50,418060.50,'530','2022-03-12 13:44:23','614','2022-03-12 15:59:08',10,0),('1','113',257709,'AFTERNOON SHIFT ','2022-03-12','2022-03-12 19:49:51','2022-03-13 19:49:51','530',2330925.30,2330925.30,'530','2022-03-12 19:54:08','614','2022-03-12 20:59:30',10,0),('1','113',257710,'AFTERNOON SHIFT ','2022-03-12','2022-03-13 13:50:24','2022-03-14 13:50:24','530',3579066.15,3579066.15,'530','2022-03-13 15:22:12','614','2022-03-13 21:28:13',10,0),('1','113',257711,'AFTERNOON SHIFT','2022-03-13','2022-03-14 09:26:58','2022-03-15 09:26:58','530',1900362.75,1900362.75,'530','2022-03-14 09:28:47','614','2022-03-14 10:59:56',10,0),('1','113',257712,'MORNING SHIFT','2022-03-14','2022-03-14 13:51:51','2022-03-15 13:51:51','530',533230.50,533230.50,'530','2022-03-14 14:04:56','614','2022-03-14 19:42:31',10,0),('1','113',257713,'AFTERNOON SHIFT','2022-03-14','2022-03-14 20:40:57','2022-03-15 20:40:57','530',0.00,0.00,'530','2022-03-14 20:43:05','614','2022-03-14 20:45:16',10,0),('1','113',257714,'AFTERNOON SHIFT','2022-03-14','2022-03-14 20:54:02','2022-03-15 20:54:02','530',2339081.25,2339081.25,'530','2022-03-14 21:05:56','614','2022-03-14 22:28:33',10,0),('1','113',257715,'MORNING SHIFT','2022-03-15','2022-03-15 14:19:56','2022-03-16 14:19:56','530',3570882.15,3570882.15,'530','2022-03-15 14:31:11','614','2022-03-15 23:36:39',10,0),('1','113',257716,'AFTERNOON SHIFT','2022-03-15','2022-03-16 07:21:55','2022-03-17 07:21:55','530',2600678.85,2600678.85,'530','2022-03-16 07:25:00','614','2022-03-16 17:17:08',10,0),('1','113',257717,'MORNING SHIFT ','2022-03-16','2022-03-16 17:18:39','2022-03-17 17:18:39','530',3064768.05,3064768.05,'530','2022-03-16 17:24:02','614','2022-03-16 17:25:13',10,0),('1','113',257718,'AFTERNOON SHIFT','2022-03-16','2022-03-16 18:47:39','2022-03-17 18:47:39','530',6336684.65,6336684.65,'530','2022-03-16 21:19:36','614','2022-03-16 21:48:16',10,0),('1','113',257719,'MORNING SHIFT ','2022-03-17','2022-03-17 07:24:42','2022-03-18 07:24:42','530',4673370.85,4673370.85,'530','2022-03-17 14:37:04','614','2022-03-17 15:49:29',10,0),('1','113',257720,'AFTERNOON SHIFT','2022-03-17','2022-03-17 21:09:46','2022-03-18 21:09:46','530',5191815.30,5191815.30,'530','2022-03-17 21:13:15','614','2022-03-17 22:47:02',10,0),('1','113',257721,'MORNING SHIFT','2022-03-18','2022-03-18 13:29:19','2022-03-19 13:29:19','530',377117.00,377117.00,'530','2022-03-18 13:35:38','614','2022-03-18 15:11:24',10,0),('1','113',257722,'AFTERNOON SHIFT','2022-03-18','2022-03-18 22:26:53','2022-03-19 22:26:53','530',6053933.10,6053933.10,'530','2022-03-18 22:31:24','614','2022-03-18 23:15:46',10,0),('1','113',257723,'MORNING SHIFT 1','2022-03-19','2022-03-19 07:55:09','2022-03-20 07:55:09','530',871253.50,871253.50,'530','2022-03-19 07:56:20','614','2022-03-19 08:01:35',10,0),('1','113',257724,'MORNING SHIFT','2022-03-19','2022-03-19 10:26:21','2022-03-20 10:26:21','530',0.00,0.00,'530','2022-03-19 10:28:57','614','2022-03-19 10:31:08',10,0),('1','113',257725,'MORNING SHIFT  2','2022-03-19','2022-03-19 14:53:49','2022-03-20 14:53:49','530',2984655.10,2984655.10,'530','2022-03-19 15:04:52','614','2022-03-19 15:06:05',10,0),('1','113',257726,'AFTERNOON SHIFT','2022-03-19','2022-03-19 21:53:18','2022-03-20 21:53:18','530',5906973.75,5906973.75,'530','2022-03-19 21:58:34','614','2022-03-19 22:17:03',10,0),('1','113',257727,'MORNING SHIFT ','2022-03-20','2022-03-20 15:12:48','2022-03-21 15:12:48','530',3034865.25,3034865.25,'530','2022-03-20 15:16:20','614','2022-03-20 15:45:27',10,0),('1','113',257728,'AFTERNOON SHIFT','2022-03-20','2022-03-20 21:57:25','2022-03-21 21:57:25','530',4204823.00,4204823.00,'530','2022-03-20 22:03:14','614','2022-03-20 23:41:49',10,0),('1','113',257729,'MORNING SHIFT','2022-03-21','2022-03-21 11:09:35','2022-03-22 11:09:35','530',0.00,0.00,'530','2022-03-21 11:12:45','614','2022-03-21 12:10:51',10,0),('1','113',257730,'MORNING SHIFT ','2022-03-21','2022-03-21 14:05:05','2022-03-22 14:05:05','530',4064189.35,4064189.35,'530','2022-03-21 14:15:28','614','2022-03-21 14:19:57',10,0),('1','113',257731,'AFTERNOON SHIFT','2022-03-21','2022-03-21 21:53:50','2022-03-22 21:53:50','530',5689409.45,5689409.45,'530','2022-03-21 21:57:45','614','2022-03-22 06:14:20',10,0),('1','113',257732,'MORNING SHIFT ','2022-03-22','2022-03-22 10:23:27','2022-03-23 10:23:27','530',0.00,0.00,'530','2022-03-22 10:26:15','614','2022-03-22 12:15:53',10,0),('1','113',257733,'MORNING SHIFT ','2022-03-22','2022-03-22 14:27:14','2022-03-23 14:27:14','530',3591999.60,3591999.60,'530','2022-03-22 14:35:06','614','2022-03-22 15:19:33',10,0),('1','113',257734,'AFTERNOON SHIFT','2022-03-22','2022-03-22 22:08:06','2022-03-23 22:08:06','530',5213354.95,5213354.95,'530','2022-03-22 22:10:40','614','2022-03-22 22:34:04',10,0),('1','113',257735,'MORNING SHIFT','2022-03-23','2022-03-23 12:33:37','2022-03-24 12:33:37','530',0.00,0.00,'530','2022-03-23 12:39:28','614','2022-03-23 18:55:15',10,0),('1','113',257736,'MORNING SHIFT ','2022-03-23','2022-03-23 20:04:29','2022-03-24 20:04:29','530',3573924.50,3573924.50,'530','2022-03-23 20:14:13','614','2022-03-23 20:31:38',10,0),('1','113',257737,'AFTERNOON SHIFT','2022-03-23','2022-03-23 21:55:03','2022-03-24 21:55:03','530',4454279.05,4454279.05,'530','2022-03-23 21:58:17','614','2022-03-23 22:04:10',10,0),('1','113',257738,'MORNING SHIFT ','2022-03-24','2022-03-24 00:06:02','2022-03-25 00:06:02','530',3510546.95,3510546.95,'530','2022-03-24 14:58:53','614','2022-03-24 15:04:11',10,0),('1','113',257739,'AFTERNOON SHIFT','2022-03-24','2022-03-24 22:59:32','2022-03-25 22:59:32','530',5302148.75,5302148.75,'530','2022-03-24 23:06:57','614','2022-03-25 07:25:52',10,0),('1','113',257740,'MORNING SHIFT ','2022-03-25','2022-03-25 14:02:48','2022-03-26 14:02:48','530',4292830.95,4292830.95,'530','2022-03-25 14:55:25','614','2022-03-25 17:17:16',10,0),('1','113',257741,'AFTERNOON SHIFT','2022-03-25','2022-03-25 22:15:13','2022-03-26 22:15:13','530',3685005.75,3685005.75,'530','2022-03-25 22:18:56','614','2022-03-25 23:44:51',10,0),('1','113',257742,'MORNING SHIFT ','2022-03-26','2022-03-26 14:54:23','2022-03-27 14:54:23','530',1219178.90,1219178.90,'530','2022-03-26 14:55:32','614','2022-03-26 15:02:51',10,0),('1','113',257743,'AFTERNOON SHIFT','2022-03-26','2022-03-26 23:17:53','2022-03-27 23:17:53','530',1776967.30,1776967.30,'530','2022-03-26 23:19:02','614','2022-03-26 23:38:37',10,0),('1','113',257744,'MORNING SHIFT ','2022-03-27','2022-03-27 07:09:50','2022-03-28 07:09:50','530',3474848.25,3474848.25,'530','2022-03-27 15:00:50','614','2022-03-27 16:10:08',10,0),('1','113',257745,'AFTERNOON SHIFT','2022-03-27','2022-03-27 23:58:42','2022-03-28 23:58:42','530',4028700.95,4028700.95,'530','2022-03-28 00:03:48','614','2022-03-28 09:04:20',10,0),('1','113',257746,'MORNING SHIFT ','2022-03-28','2022-03-28 13:58:39','2022-03-29 13:58:39','530',3961235.25,3961235.25,'530','2022-03-28 14:03:54','614','2022-03-28 14:41:25',10,0),('1','113',257747,'AFTERNOON SHIFT','2022-03-28','2022-03-28 23:08:50','2022-03-29 23:08:50','530',2672616.80,2672616.80,'530','2022-03-29 08:23:41','614','2022-03-29 09:47:10',10,0),('1','113',257748,'MORNING SHIFT ','2022-03-29','2022-03-29 13:42:40','2022-03-30 13:42:40','530',6690837.30,6690837.30,'530','2022-03-29 14:03:00','614','2022-03-29 17:17:35',10,0),('1','113',257749,'AFTERNOON SHIFT','2022-03-29','2022-03-30 07:43:59','2022-03-31 07:43:59','530',6358093.35,6358093.35,'530','2022-03-30 07:48:03','614','2022-03-30 11:21:05',10,0),('1','113',257750,'MORNING SHIFT ','2022-03-30','2022-03-30 15:07:49','2022-03-31 15:07:49','530',6627222.55,6627222.55,'530','2022-03-30 15:11:58','614','2022-03-30 15:13:45',10,0),('1','113',257751,'AFTERNOON SHIFT','2022-03-30','2022-03-31 07:53:21','2022-04-01 07:53:21','530',4156961.40,4156961.40,'530','2022-03-31 07:54:24','614','2022-03-31 09:30:57',10,0),('1','113',257752,'MORNING SHIFT ','2022-03-31','2022-03-31 11:02:10','2022-04-01 11:02:10','530',0.00,0.00,'530','2022-03-31 12:24:57','614','2022-03-31 12:26:18',10,0),('1','113',257753,'MORNING SHIFT','2022-03-31','2022-03-31 12:27:16','2022-04-01 12:27:16','530',3588397.80,3588397.80,'530','2022-03-31 15:14:14','614','2022-03-31 16:54:33',10,0),('1','113',257754,'AFTERNOON SHIFT','2022-03-31','2022-03-31 22:33:22','2022-04-01 22:33:22','530',10197450.50,10197450.50,'530','2022-03-31 22:37:44','614','2022-04-01 00:03:34',10,0),('1','113',257755,'MORNING SHIFT ','2022-04-01','2022-04-01 14:57:33','2022-04-02 14:57:33','530',5098511.75,5098511.75,'530','2022-04-01 14:59:34','614','2022-04-01 17:33:12',10,0),('1','113',257756,'AFTERNOON SHIFT','2022-04-01','2022-04-02 07:22:35','2022-04-03 07:22:35','530',6888750.25,6888750.25,'530','2022-04-02 07:27:33','614','2022-04-02 11:40:59',10,0),('1','113',257757,'MORNING SHIFT ','2022-04-02','2022-04-02 14:49:24','2022-04-03 14:49:24','530',3320627.45,3320627.45,'530','2022-04-02 21:07:30','614','2022-04-02 21:18:36',10,0),('1','113',257758,'AFTERNOON SHIFT','2022-04-02','2022-04-02 22:20:22','2022-04-03 22:20:22','530',4457865.90,4457865.90,'530','2022-04-02 22:29:06','614','2022-04-02 22:37:25',10,0),('1','113',257759,'MORNING SHIFT ','2022-04-03','2022-04-03 13:45:26','2022-04-04 13:45:26','530',2920007.20,2920007.20,'530','2022-04-03 13:52:17','614','2022-04-03 15:01:55',10,0),('1','113',257760,'AFTERNOON SHIFT','2022-04-03','2022-04-03 21:47:26','2022-04-04 21:47:26','530',2011876.00,2011876.00,'530','2022-04-03 21:48:44','614','2022-04-03 23:22:16',10,0),('1','113',257761,'MORNING SHIFT ','2022-04-04','2022-04-04 13:50:09','2022-04-05 13:50:09','530',3086084.55,3086084.55,'530','2022-04-04 13:57:16','614','2022-04-04 16:47:01',10,0),('1','113',257762,'AFTERNOON SHIFT','2022-04-04','2022-04-04 23:15:31','2022-04-05 23:15:31','530',6072233.25,6072233.25,'530','2022-04-04 23:19:19','614','2022-04-05 13:55:00',10,0),('1','113',257763,'MORNING SHIFT ','2022-04-05','2022-04-05 15:17:10','2022-04-06 15:17:10','530',3530477.55,3530477.55,'530','2022-04-05 15:28:37','614','2022-04-05 16:23:57',10,0),('1','113',257764,'AFTERNOON SHIFT','2022-04-05','2022-04-05 21:00:40','2022-04-06 21:00:40','530',3763806.45,3763806.45,'530','2022-04-05 21:04:29','614','2022-04-05 23:53:32',10,0),('1','113',257765,'MORNING SHIFT ','2022-04-06','2022-04-06 15:05:40','2022-04-07 15:05:40','530',2142974.15,2142974.15,'530','2022-04-06 15:09:12','614','2022-04-06 15:14:44',10,0),('1','113',257766,'AFTERNOON SHIFT','2022-04-06','2022-04-06 22:02:26','2022-04-07 22:02:26','530',4810506.00,4810506.00,'530','2022-04-06 22:09:19','614','2022-04-06 23:31:10',10,0),('1','113',257767,'MORNING SHIFT ','2022-04-07','2022-04-07 14:20:37','2022-04-08 14:20:37','530',3741645.10,3741645.10,'530','2022-04-07 14:26:19','614','2022-04-07 17:52:21',10,0),('1','113',257768,'AFTERNOON SHIFT','2022-04-07','2022-04-07 23:25:18','2022-04-08 23:25:18','530',4967439.75,4967439.75,'530','2022-04-07 23:32:17','614','2022-04-08 10:17:33',10,0),('1','113',257769,'MORNING SHIFT ','2022-04-08','2022-04-08 14:01:32','2022-04-09 14:01:32','530',4487124.95,4487124.95,'530','2022-04-08 14:46:41','614','2022-04-08 17:16:51',10,0),('1','113',257770,'AFTERNOON SHIFT','2022-04-08','2022-04-08 23:51:19','2022-04-09 23:51:19','530',4073864.85,4073864.85,'530','2022-04-08 23:54:48','614','2022-04-09 14:07:51',10,0),('1','113',257771,'MORNING SHIFT','2022-04-09','2022-04-09 14:21:51','2022-04-10 14:21:51','530',2725443.30,2725443.30,'530','2022-04-09 14:28:24','614','2022-04-09 15:21:23',10,0),('1','113',257772,'AFTERNOON SHIFT ','2022-04-09','2022-04-09 19:51:28','2022-04-10 19:51:28','530',0.00,0.00,'530','2022-04-09 19:55:45','614','2022-04-09 22:03:03',10,0),('1','113',257773,'AFTERNOON SHIFT','2022-04-09','2022-04-09 22:15:24','2022-04-10 22:15:24','530',5347950.20,5347950.20,'530','2022-04-09 22:19:48','614','2022-04-10 12:08:42',10,0),('1','113',257774,'MORNING SHIFT ','2022-04-10','2022-04-10 15:02:08','2022-04-11 15:02:08','530',3728734.95,3728734.95,'530','2022-04-10 15:06:25','614','2022-04-10 16:29:57',10,0),('1','113',257775,'AFTERNOON SHIFT','2022-04-10','2022-04-11 08:59:59','2022-04-12 08:59:59','530',4084542.75,4084542.75,'530','2022-04-11 09:02:59','614','2022-04-11 15:08:41',10,0),('1','113',257776,'MORNING SHIFT ','2022-04-11','2022-04-11 15:47:07','2022-04-12 15:47:07','530',2909644.90,2909644.90,'530','2022-04-11 15:50:10','614','2022-04-11 17:45:21',10,0),('1','113',257777,'AFTERNOON SHIFT','2022-04-11','2022-04-11 22:03:08','2022-04-12 22:03:08','530',5480719.60,5480719.60,'530','2022-04-11 22:40:49','614','2022-04-11 23:10:42',10,0),('1','113',257778,'MORNING SHIFT ','2022-04-12','2022-04-12 08:47:51','2022-04-13 08:47:51','530',1242642.30,1242642.30,'530','2022-04-12 13:26:37','614','2022-04-12 16:42:18',10,0),('1','113',257779,'AFTERNOON SHIFT','2022-04-12','2022-04-12 22:26:49','2022-04-13 22:26:49','530',428069.70,428069.70,'530','2022-04-12 22:28:12','614','2022-04-13 12:52:20',10,0),('1','113',257780,'MORNING SHIFT ','2022-04-13','2022-04-13 13:09:38','2022-04-14 13:09:38','530',2418330.95,2418330.95,'530','2022-04-13 14:06:44','614','2022-04-13 15:32:06',10,0),('1','113',257781,'AFTERNOON SHIFT','2022-04-13','2022-04-13 22:41:15','2022-04-14 22:41:15','530',5078245.50,5078245.50,'530','2022-04-13 22:45:42','614','2022-04-14 11:46:44',10,0),('1','113',257782,'MORNING SHIFT ','2022-04-14','2022-04-14 14:32:24','2022-04-15 14:32:24','530',3233058.75,3233058.75,'530','2022-04-14 14:46:20','614','2022-04-14 14:50:46',10,0),('1','113',257783,'AFTERNOON SHIFT','2022-04-14','2022-04-14 21:17:52','2022-04-15 21:17:52','530',4522593.70,4522593.70,'530','2022-04-14 21:25:37','614','2022-04-14 21:45:29',10,0),('1','113',257784,'MORNING SHIFT ','2022-04-15','2022-04-15 14:52:23','2022-04-16 14:52:23','530',1685674.60,1685674.60,'530','2022-04-15 14:58:16','614','2022-04-15 15:05:33',10,0),('1','113',257785,'AFTERNOON SHIFT','2022-04-15','2022-04-15 21:28:21','2022-04-16 21:28:21','530',4392280.05,4392280.05,'530','2022-04-15 21:34:48','614','2022-04-15 22:10:02',10,0),('1','113',257786,'MORNING SHIFT ','2022-04-16','2022-04-16 14:22:26','2022-04-17 14:22:26','530',3894716.95,3894716.95,'530','2022-04-16 14:26:10','614','2022-04-16 15:03:34',10,0),('1','113',257787,'AFTERNOON SHIFT','2022-04-16','2022-04-16 22:21:01','2022-04-17 22:21:01','530',4583266.30,4583266.30,'530','2022-04-16 22:24:30','614','2022-04-17 05:44:22',10,0),('1','113',257788,'MORNING SHIFT ','2022-04-17','2022-04-17 13:55:08','2022-04-18 13:55:08','530',1921289.30,1921289.30,'530','2022-04-17 13:59:32','614','2022-04-17 17:10:38',10,0),('1','113',257789,'AFTERNOON SHIFT','2022-04-17','2022-04-17 19:38:46','2022-04-18 19:38:46','530',631997.60,631997.60,'530','2022-04-17 19:41:44','614','2022-04-17 21:48:09',10,0),('1','113',257790,'MORNING SHIFT ','2022-04-18','2022-04-18 14:38:24','2022-04-19 14:38:24','530',537855.90,537855.90,'530','2022-04-18 14:40:39','614','2022-04-18 14:51:48',10,0),('1','113',257791,'AFTERNOON SHIFT','2022-04-18','2022-04-18 21:21:38','2022-04-19 21:21:38','530',540649.80,540649.80,'530','2022-04-18 21:23:52','614','2022-04-18 22:29:36',10,0),('1','113',257792,'MORNING SHIFT ','2022-04-19','2022-04-19 14:22:20','2022-04-20 14:22:20','530',721904.90,721904.90,'530','2022-04-19 14:24:57','614','2022-04-19 15:24:50',10,0),('1','113',257793,'AFTERNOON SHIFT','2022-04-19','2022-04-19 20:53:25','2022-04-20 20:53:25','530',1170463.20,1170463.20,'530','2022-04-19 20:54:53','614','2022-04-19 22:30:34',10,0),('1','113',257794,'MORNING SHIFT ','2022-04-20','2022-04-20 10:41:32','2022-04-21 10:41:32','530',0.00,0.00,'530','2022-04-20 12:45:56','614','2022-04-20 14:38:31',10,0),('1','113',257795,'MORNING SHIFT ','2022-04-20','2022-04-20 15:08:40','2022-04-21 15:08:40','530',3393220.20,3393220.20,'530','2022-04-20 17:14:23','614','2022-04-20 22:16:20',10,0),('1','113',257796,'AFTERNOON SHIFT','2022-04-20','2022-04-20 22:29:20','2022-04-21 22:29:20','530',5463085.05,5463085.05,'530','2022-04-20 22:32:43','614','2022-04-20 22:34:49',10,0),('1','113',257797,'MORNING SHIFT ','2022-04-21','2022-04-21 14:48:55','2022-04-22 14:48:55','530',3703741.15,3703741.15,'530','2022-04-21 15:00:15','614','2022-04-21 16:53:54',10,0),('1','113',257798,'AFTERNOON SHIFT','2022-04-21','2022-04-21 21:55:50','2022-04-22 21:55:50','530',4033532.15,4033532.15,'530','2022-04-21 22:05:53','614','2022-04-21 22:11:59',10,0),('1','113',257799,'MORNING SHIFT ','2022-04-22','2022-04-22 14:42:11','2022-04-23 14:42:11','530',3997924.35,3997924.35,'530','2022-04-22 14:49:54','614','2022-04-22 15:10:46',10,0),('1','113',257800,'AFTERNOON SHIFT','2022-04-22','2022-04-23 04:58:45','2022-04-24 04:58:45','530',11549315.75,11549315.75,'530','2022-04-23 05:04:18','614','2022-04-23 09:52:42',10,0),('1','113',257801,'MORNING SHIFT ','2022-04-23','2022-04-23 14:02:39','2022-04-24 14:02:39','530',7598712.75,7598712.75,'530','2022-04-23 15:02:38','614','2022-04-23 15:10:54',10,0),('1','113',257802,'AFTERNOON SHIFT','2022-04-23','2022-04-23 22:36:03','2022-04-24 22:36:03','530',4858081.35,4858081.35,'530','2022-04-23 22:44:20','614','2022-04-23 23:35:05',10,0),('1','113',257803,'MORNING SHIFT','2022-04-24','2022-04-24 14:05:57','2022-04-25 14:05:57','530',1418778.95,1418778.95,'530','2022-04-24 14:11:28','614','2022-04-24 15:31:07',10,0),('1','113',257804,'AFTERNOON SHIFT','2022-04-24','2022-04-24 15:43:34','2022-04-25 15:43:34','530',3154615.25,3154615.25,'530','2022-04-24 22:11:53','614','2022-04-24 23:21:24',10,0),('1','113',257805,'MORNING SHIFT ','2022-04-25','2022-04-25 13:18:13','2022-04-26 13:18:13','530',5578757.45,5578757.45,'530','2022-04-25 15:36:04','614','2022-04-25 16:19:30',10,0),('1','113',257806,'AFTERNOON SHIFT','2022-04-25','2022-04-25 22:10:40','2022-04-26 22:10:40','530',6430987.60,6430987.60,'530','2022-04-25 22:14:43','614','2022-04-25 23:48:02',10,0),('1','113',257807,'MORNING SHIFT ','2022-04-26','2022-04-26 14:59:05','2022-04-27 14:59:05','530',3136705.10,3136705.10,'530','2022-04-26 15:02:24','614','2022-04-26 21:11:59',10,0),('1','113',257808,'AFTERNOON SHIFT','2022-04-26','2022-04-26 23:34:26','2022-04-27 23:34:26','530',5925532.20,5925532.20,'530','2022-04-26 23:45:06','614','2022-04-27 04:29:21',10,0),('1','113',257809,'MORNING SHIFT ','2022-04-27','2022-04-27 14:39:05','2022-04-28 14:39:05','530',4277382.25,4277382.25,'530','2022-04-27 14:43:54','614','2022-04-27 16:12:18',10,0),('1','113',257810,'AFTERNOON SHIFT','2022-04-27','2022-04-27 23:10:39','2022-04-28 23:10:39','530',5734485.60,5734485.60,'530','2022-04-27 23:15:20','614','2022-04-28 10:38:40',10,0),('1','113',257811,'MORNING SHIFT ','2022-04-28','2022-04-28 14:00:01','2022-04-29 14:00:01','530',3470495.80,3470495.80,'530','2022-04-28 14:05:40','614','2022-04-28 14:38:29',10,0),('1','113',257812,'AFTERNOON SHIFT','2022-04-28','2022-04-28 22:51:37','2022-04-29 22:51:37','530',5575332.45,5575332.45,'530','2022-04-28 23:04:13','614','2022-04-29 00:12:38',10,0),('1','113',257813,'MORNING SHIFT ','2022-04-29','2022-04-29 14:25:20','2022-04-30 14:25:20','530',3259876.40,3259876.40,'530','2022-04-29 14:37:08','614','2022-04-29 14:59:06',10,0),('1','113',257814,'AFTERNOON SHIFT','2022-04-29','2022-04-30 06:53:00','2022-05-01 06:53:00','530',4981884.70,4981884.70,'530','2022-04-30 07:01:24','614','2022-04-30 14:21:54',10,0),('1','113',257815,'MORNING SHIFT ','2022-04-30','2022-04-30 15:18:05','2022-05-01 15:18:05','530',4004761.50,4004761.50,'530','2022-04-30 15:42:04','614','2022-04-30 18:25:23',10,0),('1','113',257816,'AFTERNOON SHIFT ','2022-04-30','2022-05-01 06:14:58','2022-05-02 06:14:58','530',4164975.25,4164975.25,'530','2022-05-01 08:58:43','614','2022-05-01 09:54:18',10,0),('1','113',257817,'MORNING SHIFT','2022-05-01','2022-05-01 13:34:00','2022-05-02 13:34:00','530',2407657.80,2407657.80,'530','2022-05-01 14:19:44','614','2022-05-01 15:09:37',10,0),('1','113',257818,'AFTERNOON SHIFT','2022-05-01','2022-05-01 23:14:43','2022-05-02 23:14:43','530',2184326.10,2184326.10,'530','2022-05-01 23:20:52','614','2022-05-02 00:28:36',10,0),('1','113',257819,'MORNING SHIFT','2022-05-02','2022-05-02 15:46:21','2022-05-03 15:46:21','530',979248.60,979248.60,'530','2022-05-02 17:05:32','614','2022-05-02 17:08:33',10,0),('1','113',257820,'AFTERNOON SHIFT','2022-05-02','2022-05-03 07:21:34','2022-05-04 07:21:34','530',2180665.50,2180665.50,'530','2022-05-03 07:25:13','614','2022-05-03 10:15:40',10,0),('1','113',257821,'MORNING SHIFT','2022-05-03','2022-05-03 14:41:50','2022-05-04 14:41:50','530',2273634.05,2273634.05,'530','2022-05-03 14:46:00','614','2022-05-03 15:33:46',10,0),('1','113',257822,'AFTERNOON SHIFT','2022-05-03','2022-05-03 21:50:53','2022-05-04 21:50:53','530',3967165.80,3967165.80,'530','2022-05-03 21:54:52','614','2022-05-03 23:47:12',10,0),('1','113',257823,'MORNING SHIFT ','2022-05-04','2022-05-04 14:05:14','2022-05-05 14:05:14','530',2611069.20,2611069.20,'530','2022-05-04 14:08:32','614','2022-05-04 15:57:05',10,0),('1','113',257824,'AFTERNOON SHIFT','2022-05-04','2022-05-04 20:55:48','2022-05-05 20:55:48','530',3487292.90,3487292.90,'530','2022-05-04 20:58:58','614','2022-05-04 22:48:38',10,0),('1','113',257825,'MORNING SHIFT ','2022-05-05','2022-05-05 14:23:19','2022-05-06 14:23:19','530',3555170.40,3555170.40,'530','2022-05-05 14:27:42','614','2022-05-05 20:01:25',10,0),('1','113',257826,'AFTERNOON SHIFT','2022-05-05','2022-05-06 09:02:44','2022-05-07 09:02:44','530',4205664.15,4205664.15,'530','2022-05-06 09:07:14','614','2022-05-06 09:27:03',10,0),('1','113',257827,'MORNING SHIFT ','2022-05-06','2022-05-06 14:53:13','2022-05-07 14:53:13','530',3439308.80,3439308.80,'530','2022-05-06 14:57:47','614','2022-05-06 15:11:00',10,0),('1','113',257828,'AFTERNOON SHIFT','2022-05-06','2022-05-07 06:26:28','2022-05-08 06:26:28','530',4645964.40,4645964.40,'530','2022-05-07 06:31:34','614','2022-05-07 06:41:07',10,0),('1','113',257829,'MORNING SHIFT ','2022-05-07','2022-05-07 13:45:13','2022-05-08 13:45:13','530',3634493.10,3634493.10,'530','2022-05-07 14:51:19','614','2022-05-07 18:10:38',10,0),('1','113',257830,'AFTERNOON SHIFT','2022-05-07','2022-05-07 22:11:56','2022-05-08 22:11:56','530',1940028.90,1940028.90,'530','2022-05-07 22:21:01','614','2022-05-07 23:29:59',10,0),('1','113',257831,'MORNING SHIFT ','2022-05-08','2022-05-08 15:48:33','2022-05-09 15:48:33','530',552246.50,552246.50,'530','2022-05-08 15:50:20','614','2022-05-08 16:00:47',10,0),('1','113',257832,'AFTERNOON SHIFT','2022-05-08','2022-05-08 22:34:57','2022-05-09 22:34:57','530',1194297.00,1194297.00,'530','2022-05-08 22:35:58','614','2022-05-08 23:26:18',10,0),('1','113',257833,'MORNING SHIFT','2022-05-09','2022-05-09 10:34:56','2022-05-10 10:34:56','530',0.00,0.00,'530','2022-05-09 10:42:20','426','2022-05-09 12:39:37',10,0),('1','113',257834,'MORNING SHIFT ','2022-05-09','2022-05-09 14:22:40','2022-05-10 14:22:40','530',3184585.95,3184585.95,'530','2022-05-09 14:26:17','614','2022-05-09 22:08:36',10,0),('1','113',257835,'AFTERNOON SHIFT','2022-05-09','2022-05-09 22:12:29','2022-05-10 22:12:29','530',4998035.65,4998035.65,'530','2022-05-09 22:16:16','614','2022-05-09 23:37:05',10,0),('1','113',257836,'MORNING SHIFT ','2022-05-10','2022-05-10 07:10:53','2022-05-11 07:10:53','530',4587933.25,4587933.25,'530','2022-05-10 13:31:53','614','2022-05-10 15:57:43',10,0),('1','113',257837,'AFTERNOON SHIFT 1','2022-05-10','2022-05-10 17:38:14','2022-05-11 17:38:14','530',1121893.50,1121893.50,'530','2022-05-10 17:39:05','614','2022-05-10 21:32:58',10,0),('1','113',257838,'AFTERNOON SHIFT 2','2022-05-10','2022-05-10 21:54:27','2022-05-11 21:54:27','530',3944336.55,3944336.55,'530','2022-05-10 22:13:22','614','2022-05-10 22:41:52',10,0),('1','113',257839,'MORNING SHIFT ','2022-05-11','2022-05-11 11:12:20','2022-05-12 11:12:20','530',0.00,0.00,'530','2022-05-11 11:13:52','614','2022-05-11 15:35:10',10,0),('1','113',257840,'MORNING SHIFT ','2022-05-11','2022-05-11 16:28:20','2022-05-12 16:28:20','530',1949017.95,1949017.95,'530','2022-05-11 16:36:44','614','2022-05-11 17:17:29',10,0),('1','113',257841,'AFTERNOON SHIFT','2022-05-11','2022-05-11 22:05:53','2022-05-12 22:05:53','530',3806678.70,3806678.70,'530','2022-05-11 22:19:43','614','2022-05-12 02:07:37',10,0),('1','113',257842,'MORNING SHIFT ','2022-05-12','2022-05-12 13:42:26','2022-05-13 13:42:26','530',3700100.25,3700100.25,'530','2022-05-12 13:47:38','614','2022-05-12 14:20:52',10,0),('1','113',257843,'AFTERNOON SHIFT','2022-05-12','2022-05-12 22:50:32','2022-05-13 22:50:32','530',4754697.75,4754697.75,'530','2022-05-12 23:06:31','614','2022-05-12 23:48:54',10,0),('1','113',257844,'MORNING SHIFT ','2022-05-13','2022-05-13 13:48:42','2022-05-14 13:48:42','530',2786046.45,2786046.45,'530','2022-05-13 13:52:41','614','2022-05-13 15:53:59',10,0),('1','113',257845,'AFTERNOON SHIFT','2022-05-13','2022-05-13 22:08:29','2022-05-14 22:08:29','530',3004339.80,3004339.80,'530','2022-05-13 22:15:24','614','2022-05-13 22:55:56',10,0),('1','113',257846,'MORNING SHIFT ','2022-05-14','2022-05-14 13:17:50','2022-05-15 13:17:50','530',1722204.00,1722204.00,'530','2022-05-14 13:21:23','614','2022-05-14 13:35:26',10,0),('1','113',257847,'AFTERNOON SHIFT','2022-05-14','2022-05-14 21:50:15','2022-05-15 21:50:15','530',2491745.85,2491745.85,'530','2022-05-14 21:56:57','614','2022-05-14 23:41:13',10,0),('1','113',257848,'MORNING SHIFT ','2022-05-15','2022-05-15 11:47:07','2022-05-16 11:47:07','530',2170591.50,2170591.50,'530','2022-05-16 05:49:25','614','2022-05-16 08:18:07',10,0),('1','113',257849,'MORNING SHIFT ','2022-05-16','2022-05-16 15:36:48','2022-05-17 15:36:48','530',1623230.40,1623230.40,'530','2022-05-16 15:43:43','614','2022-05-16 21:46:09',10,0),('1','113',257850,'AFTERNOON SHIFT','2022-05-16','2022-05-16 22:15:18','2022-05-17 22:15:18','530',3126313.80,3126313.80,'530','2022-05-16 22:22:11','614','2022-05-16 23:30:37',10,0),('1','113',257851,'MORNING SHIFT ','2022-05-17','2022-05-17 13:27:21','2022-05-18 13:27:21','530',2882785.95,2882785.95,'530','2022-05-17 13:50:44','614','2022-05-17 15:33:53',10,0),('1','113',257852,'AFTERNOON SHIFT','2022-05-17','2022-05-17 21:57:01','2022-05-18 21:57:01','530',4742172.00,4742172.00,'530','2022-05-17 22:09:58','614','2022-05-17 23:31:55',10,0),('1','113',257853,'MORNING SHIFT ','2022-05-18','2022-05-18 13:54:36','2022-05-19 13:54:36','530',2580963.15,2580963.15,'530','2022-05-18 14:04:32','614','2022-05-18 18:48:38',10,0),('1','113',257854,'AFTERNOON SHIFT','2022-05-18','2022-05-18 23:01:26','2022-05-19 23:01:26','530',4794047.25,4794047.25,'530','2022-05-18 23:08:57','614','2022-05-18 23:32:59',10,0),('1','113',257855,'MORNING SHIFT ','2022-05-19','2022-05-19 14:15:54','2022-05-20 14:15:54','530',3336161.10,3336161.10,'530','2022-05-19 14:48:53','614','2022-05-19 14:55:10',10,0),('1','113',257856,'AFTERNOON SHIFT','2022-05-19','2022-05-19 21:59:17','2022-05-20 21:59:17','530',1386020.70,1386020.70,'530','2022-05-19 22:19:10','614','2022-05-19 23:00:35',10,0),('1','113',257857,'MORNING SHIFT ','2022-05-20','2022-05-20 13:20:36','2022-05-21 13:20:36','530',3075296.85,3075296.85,'530','2022-05-20 13:25:58','614','2022-05-20 17:29:23',10,0),('1','113',257858,'AFTERNOON SHIFT','2022-05-20','2022-05-20 22:19:17','2022-05-21 22:19:17','530',3547164.75,3547164.75,'530','2022-05-20 22:27:54','614','2022-05-20 22:44:08',10,0),('1','113',257859,'MORNING SHIFT ','2022-05-21','2022-05-21 14:10:04','2022-05-22 14:10:04','530',3082648.80,3082648.80,'530','2022-05-21 14:13:48','614','2022-05-21 14:57:24',10,0),('1','113',257860,'AFTERNOON SHIFT','2022-05-21','2022-05-21 22:25:40','2022-05-22 22:25:40','530',4064664.90,4064664.90,'530','2022-05-21 22:30:45','614','2022-05-22 15:13:01',10,0),('1','113',257861,'MORNING SHIFT ','2022-05-22','2022-05-22 17:04:59','2022-05-23 17:04:59','530',1625766.00,1625766.00,'530','2022-05-22 17:09:25','614','2022-05-22 23:42:19',10,0),('1','113',257862,'AFTERNOON SHIFT','2022-05-22','2022-05-23 06:50:26','2022-05-24 06:50:26','530',3161278.50,3161278.50,'530','2022-05-23 06:57:21','614','2022-05-23 08:34:02',10,0),('1','113',257863,'MORNING SHIFT ','2022-05-23','2022-05-23 13:59:37','2022-05-24 13:59:37','530',2645469.45,2645469.45,'530','2022-05-23 14:04:16','614','2022-05-23 15:38:05',10,0),('1','113',257864,'AFTERNOON SHIFT','2022-05-23','2022-05-23 19:50:38','2022-05-24 19:50:38','530',5622699.60,5622699.60,'530','2022-05-23 21:28:20','614','2022-05-23 21:49:28',10,0),('1','113',257865,'MORNING SHIFT ','2022-05-24','2022-05-24 13:53:32','2022-05-25 13:53:32','530',3018614.40,3018614.40,'530','2022-05-24 16:54:34','614','2022-05-24 22:25:34',10,0),('1','113',257866,'AFTERNOON SHIFT','2022-05-24','2022-05-25 06:30:16','2022-05-26 06:30:16','530',998568.00,998568.00,'530','2022-05-25 06:44:01','614','2022-05-25 10:16:47',10,0),('1','113',257867,'MORNING SHIFT ','2022-05-25','2022-05-25 14:16:03','2022-05-26 14:16:03','530',1803889.50,1803889.50,'530','2022-05-25 14:25:08','614','2022-05-25 15:44:57',10,0),('1','113',257868,'AFTERNOON SHIFT 1','2022-05-25','2022-05-25 16:29:26','2022-05-26 16:29:26','530',39844.80,39844.80,'530','2022-05-25 16:30:07','614','2022-05-25 22:00:18',10,0),('1','113',257869,'AFTERNOON SHIFT 2','2022-05-25','2022-05-25 22:10:40','2022-05-26 22:10:40','530',2986872.05,2986872.05,'530','2022-05-25 22:14:55','614','2022-05-26 14:38:53',10,0),('1','113',257870,'MORNING SHIFT ','2022-05-26','2022-05-26 15:14:20','2022-05-27 15:14:20','530',4038640.50,4038640.50,'530','2022-05-26 15:17:13','614','2022-05-26 21:01:15',10,0),('1','113',257871,'AFTERNOON SHIFT','2022-05-26','2022-05-26 22:25:36','2022-05-27 22:25:36','530',3438375.85,3438375.85,'530','2022-05-26 22:30:22','614','2022-05-26 22:54:58',10,0),('1','113',257872,'MORNING SHIFT ','2022-05-27','2022-05-27 14:52:05','2022-05-28 14:52:05','530',1997890.90,1997890.90,'530','2022-05-27 14:57:04','614','2022-05-27 15:06:03',10,0),('1','113',257873,'AFTERNOON SHIFT','2022-05-27','2022-05-28 05:48:36','2022-05-29 05:48:36','530',4110703.35,4110703.35,'530','2022-05-28 05:53:25','614','2022-05-28 06:38:24',10,0),('1','113',257874,'MORNING SHIFT ','2022-05-28','2022-05-28 13:19:32','2022-05-29 13:19:32','530',2287472.15,2287472.15,'530','2022-05-28 13:22:40','614','2022-05-28 15:26:50',10,0),('1','113',257875,'AFTERNOON SHIFT','2022-05-28','2022-05-29 09:18:41','2022-05-30 09:18:41','530',3038433.45,3038433.45,'530','2022-05-29 09:23:10','614','2022-05-29 12:12:37',10,0),('1','113',257876,'MORNING SHIFT','2022-05-29','2022-05-29 13:14:50','2022-05-30 13:14:50','530',2242314.00,2242314.00,'530','2022-05-29 14:18:14','614','2022-05-29 15:56:44',10,0),('1','113',257877,'AFTERNOON SHIFT','2022-05-29','2022-05-29 21:53:03','2022-05-30 21:53:03','530',2287817.80,2287817.80,'530','2022-05-29 21:59:15','614','2022-05-30 10:27:15',10,0),('1','113',257878,'MORNING SHIFT ','2022-05-30','2022-05-30 12:45:24','2022-05-31 12:45:24','530',3355922.90,3355922.90,'530','2022-05-30 14:32:28','614','2022-05-30 15:32:58',10,0),('1','113',257879,'AFTERNOON SHIFT','2022-05-30','2022-05-30 22:44:23','2022-05-31 22:44:23','530',5147174.50,5147174.50,'530','2022-05-30 22:55:52','614','2022-05-31 14:48:53',10,0),('1','113',257880,'MORNING SHIFT ','2022-05-31','2022-05-31 15:02:58','2022-06-01 15:02:58','530',2082101.25,2082101.25,'530','2022-05-31 15:05:42','614','2022-05-31 20:51:35',10,0),('1','113',257881,'AFTERNOON SHIFT','2022-05-31','2022-05-31 22:35:24','2022-06-01 22:35:24','530',4125400.25,4125400.25,'530','2022-05-31 22:38:28','614','2022-05-31 22:39:30',10,0),('1','113',257882,'MORNING SHIFT ','2022-06-01','2022-06-01 14:30:07','2022-06-02 14:30:07','530',3388285.70,3388285.70,'530','2022-06-01 14:34:14','614','2022-06-01 19:56:27',10,0),('1','113',257883,'AFTERNOON SHIFT','2022-06-01','2022-06-01 23:01:12','2022-06-02 23:01:12','530',4977539.25,4977539.25,'530','2022-06-01 23:05:28','614','2022-06-01 23:54:35',10,0),('1','113',257884,'MORNING SHIFT ','2022-06-02','2022-06-02 07:11:39','2022-06-03 07:11:39','530',3808248.30,3808248.30,'530','2022-06-02 14:07:48','614','2022-06-02 18:27:45',10,0),('1','113',257885,'AFTERNOON SHIFT','2022-06-02','2022-06-02 22:36:08','2022-06-03 22:36:08','530',6373257.45,6373257.45,'530','2022-06-02 23:21:07','614','2022-06-03 06:38:58',10,0),('1','113',257886,'MORNING SHIFT ','2022-06-03','2022-06-03 14:43:50','2022-06-04 14:43:50','530',3921517.50,3921517.50,'530','2022-06-03 14:56:06','614','2022-06-03 15:21:20',10,0),('1','113',257887,'MORNING SHIFT 2','2022-06-03','2022-06-03 15:21:42','2022-06-04 15:21:42','530',69861.00,69861.00,'530','2022-06-03 15:23:09','614','2022-06-03 17:42:13',10,0),('1','113',257888,'AFTERNOON SHIFT ','2022-06-03','2022-06-03 20:04:13','2022-06-04 20:04:13','530',3558185.00,3558185.00,'530','2022-06-03 20:11:14','614','2022-06-03 22:28:08',10,0),('1','113',257889,'MORNING SHIFT','2022-06-04','2022-06-04 13:15:25','2022-06-05 13:15:25','530',757264.20,757264.20,'530','2022-06-04 13:16:50','614','2022-06-04 15:22:11',10,0),('1','113',257890,'AFTERNOON SHIFT ','2022-06-04','2022-06-04 19:40:19','2022-06-05 19:40:19','530',1417610.60,1417610.60,'530','2022-06-04 19:41:37','614','2022-06-04 21:57:25',10,0),('1','113',257891,'MORNING SHIFT','2022-06-05','2022-06-05 13:38:55','2022-06-06 13:38:55','530',1083685.60,1083685.60,'530','2022-06-05 13:40:47','614','2022-06-05 13:57:30',10,0),('1','113',257892,'AFTERNOON SHIFT ','2022-06-05','2022-06-05 19:33:00','2022-06-06 19:33:00','530',1488702.40,1488702.40,'530','2022-06-05 19:34:22','614','2022-06-05 20:53:52',10,0),('1','113',257893,'MORNING SHIFT ','2022-06-06','2022-06-06 15:05:33','2022-06-07 15:05:33','530',1171997.20,1171997.20,'530','2022-06-06 15:06:21','614','2022-06-06 22:46:06',10,0),('1','113',257894,'AFTERNOON SHIFT','2022-06-06','2022-06-06 23:16:51','2022-06-07 23:16:51','530',4001505.60,4001505.60,'530','2022-06-06 23:18:32','614','2022-06-06 23:28:00',10,0),('1','113',257895,'MORNING SHIFT ','2022-06-07','2022-06-07 14:49:45','2022-06-08 14:49:45','530',6075011.60,6075011.60,'530','2022-06-07 14:58:37','614','2022-06-07 16:08:47',10,0),('1','113',257896,'AFTERNOON SHIFT','2022-06-07','2022-06-08 06:06:00','2022-06-09 06:06:00','530',6405094.05,6405094.05,'530','2022-06-08 06:12:46','614','2022-06-08 14:42:13',10,0),('1','113',257897,'MORNING SHIFT ','2022-06-08','2022-06-08 14:52:57','2022-06-09 14:52:57','530',5038133.85,5038133.85,'530','2022-06-08 14:58:23','614','2022-06-08 14:58:53',10,0),('1','113',257898,'AFTERNOON SHIFT','2022-06-08','2022-06-08 22:34:22','2022-06-09 22:34:22','530',6216751.38,6216751.38,'530','2022-06-08 22:50:07','614','2022-06-08 23:41:05',10,0),('1','113',257899,'MORNING SHIFT','2022-06-09','2022-06-09 10:32:25','2022-06-10 10:32:25','426',1990452.55,1990452.55,'530','2022-06-09 14:35:40','614','2022-06-09 15:11:14',10,0),('1','113',257900,'AFTERNOON SHIFT','2022-06-09','2022-06-09 22:28:59','2022-06-10 22:28:59','530',2505831.90,2505831.90,'530','2022-06-09 22:32:38','614','2022-06-09 22:45:49',10,0),('1','113',257901,'MORNING SHIFT ','2022-06-10','2022-06-10 11:20:06','2022-06-11 11:20:06','530',1564521.75,1564521.75,'530','2022-06-10 14:16:36','614','2022-06-10 15:01:43',10,0),('1','113',257902,'AFTERNOON SHIFT','2022-06-10','2022-06-11 00:04:48','2022-06-12 00:04:48','530',2467802.70,2467802.70,'530','2022-06-11 00:08:14','614','2022-06-11 11:40:54',10,0),('1','113',257903,'MORNING SHIFT ','2022-06-11','2022-06-11 13:02:48','2022-06-12 13:02:48','530',1517298.75,1517298.75,'530','2022-06-11 13:25:54','614','2022-06-11 14:45:28',10,0),('1','113',257904,'AFTERNOON SHIFT','2022-06-11','2022-06-11 21:21:50','2022-06-12 21:21:50','530',2569772.70,2569772.70,'530','2022-06-11 21:25:30','614','2022-06-11 21:50:36',10,0),('1','113',257905,'MORNING SHIFT ','2022-06-12','2022-06-12 14:43:58','2022-06-13 14:43:58','530',2386097.40,2386097.40,'530','2022-06-12 14:50:46','614','2022-06-12 16:27:06',10,0),('1','113',257906,'AFTERNOON SHIFT','2022-06-12','2022-06-12 22:12:53','2022-06-13 22:12:53','530',3355850.70,3355850.70,'530','2022-06-12 22:19:40','614','2022-06-12 23:15:16',10,0),('1','113',257907,'MORNING SHIFT ','2022-06-13','2022-06-13 06:19:32','2022-06-14 06:19:32','530',3237390.30,3237390.30,'530','2022-06-13 15:08:22','614','2022-06-13 15:12:38',10,0),('1','113',257908,'AFTERNOON SHIFT','2022-06-13','2022-06-13 22:06:49','2022-06-14 22:06:49','530',7483747.65,7483747.65,'530','2022-06-13 22:12:21','614','2022-06-13 23:38:58',10,0),('1','113',257909,'MORNING SHIFT ','2022-06-14','2022-06-14 06:15:29','2022-06-15 06:15:29','530',7736704.35,7736704.35,'530','2022-06-14 13:42:43','614','2022-06-14 14:50:47',10,0),('1','113',257910,'AFTERNOON SHIFT','2022-06-14','2022-06-14 22:22:29','2022-06-15 22:22:29','530',6853529.25,6853529.25,'530','2022-06-14 22:27:38','614','2022-06-14 22:40:11',10,0),('1','113',257911,'AFTERNOON SHIFT','2022-06-14','2022-06-14 22:53:14','2022-06-15 22:53:14','530',0.00,0.00,'530','2022-06-14 22:54:31','614','2022-06-14 23:10:03',10,0),('1','113',257912,'MORNING SHIFT ','2022-06-15','2022-06-15 07:18:45','2022-06-16 07:18:45','530',3406795.05,3406795.05,'530','2022-06-15 13:58:10','614','2022-06-15 15:11:37',10,0),('1','113',257913,'AFTERNOON SHIFT ','2022-06-15','2022-06-15 21:00:21','2022-06-16 21:00:21','530',6588316.20,6588316.20,'530','2022-06-15 21:03:35','614','2022-06-15 23:34:04',10,0),('1','113',257914,'MORNING SHIFT','2022-06-16','2022-06-16 10:13:05','2022-06-17 10:13:05','530',5658081.45,5658081.45,'530','2022-06-16 13:30:42','614','2022-06-16 15:56:09',10,0),('1','113',257915,'AFTERNOON SHIFT','2022-06-16','2022-06-16 19:03:49','2022-06-17 19:03:49','530',2574232.65,2574232.65,'530','2022-06-16 19:05:40','614','2022-06-16 22:34:17',10,0),('1','113',257916,'MORNING SHIFT','2022-06-17','2022-06-17 10:27:30','2022-06-18 10:27:30','530',2913061.80,2913061.80,'530','2022-06-17 14:51:45','614','2022-06-17 14:53:15',10,0),('1','113',257917,'AFTERNOON SHIFT','2022-06-17','2022-06-17 17:55:15','2022-06-18 17:55:15','530',1250076.30,1250076.30,'530','2022-06-17 17:57:08','614','2022-06-18 12:39:22',10,0),('1','113',257918,'MORNING SHIFT','2022-06-19','2022-06-19 13:35:04','2022-06-20 13:35:04','530',2453550.00,2453550.00,'530','2022-06-19 13:38:44','614','2022-06-19 15:57:57',10,0),('1','113',257919,'AFTERNOON SHIFT','2022-06-19','2022-06-20 09:10:34','2022-06-21 09:10:34','530',5113039.65,5113039.65,'530','2022-06-20 09:13:59','614','2022-06-20 11:08:03',10,0),('1','113',257920,'MORNING SHIFT ','2022-06-20','2022-06-20 14:32:32','2022-06-21 14:32:32','530',6368373.15,6368373.15,'530','2022-06-20 14:48:51','614','2022-06-20 14:57:18',10,0),('1','113',257921,'Afternoon  shift ','2022-06-20','2022-06-20 22:27:14','2022-06-21 22:27:14','530',2549760.60,2549760.60,'530','2022-06-20 22:32:00','614','2022-06-20 23:10:16',10,0),('1','113',257922,'Morning shift ','2022-06-21','2022-06-21 13:31:18','2022-06-22 13:31:18','530',0.00,0.00,'530','2022-06-21 13:33:38','614','2022-06-21 19:03:51',10,0),('1','113',257923,'Morning shift ','2022-06-21','2022-06-21 20:03:39','2022-06-22 20:03:39','530',5057637.45,5057637.45,'530','2022-06-21 20:07:19','614','2022-06-22 06:57:36',10,0),('1','113',257924,'Afternoon  shift ','2022-06-21','2022-06-22 09:45:33','2022-06-23 09:45:33','530',3741560.55,3741560.55,'530','2022-06-22 10:15:09','614','2022-06-22 19:01:14',10,0),('1','113',257925,'MORNING SHIFT ','2022-06-22','2022-06-22 19:12:34','2022-06-23 19:12:34','530',3154796.55,3154796.55,'530','2022-06-22 19:15:49','614','2022-06-22 23:53:49',10,0),('1','113',257926,'AFTERNOON SHIFT','2022-06-22','2022-06-23 06:54:18','2022-06-24 06:54:18','530',10312951.05,10312951.05,'530','2022-06-23 06:59:17','614','2022-06-23 14:56:11',10,0),('1','113',257927,'Morning shift ','2022-06-23','2022-06-23 19:41:49','2022-06-24 19:41:49','530',6012230.70,6012230.70,'530','2022-06-23 19:55:29','614','2022-06-23 21:11:44',10,0),('1','113',257928,'AFTERNOON SHIFT','2022-06-23','2022-06-24 07:35:36','2022-06-25 07:35:36','530',2537405.40,2537405.40,'530','2022-06-24 07:44:57','614','2022-06-24 15:20:10',10,0),('1','113',257929,'MORNING SHIFT ','2022-06-24','2022-06-24 17:56:57','2022-06-25 17:56:57','530',4092800.40,4092800.40,'530','2022-06-24 18:04:55','614','2022-06-24 23:38:44',10,0),('1','113',257930,'AFTERNOON SHIFT ','2022-06-24','2022-06-25 08:30:47','2022-06-26 08:30:47','530',2437804.20,2437804.20,'530','2022-06-25 10:06:07','614','2022-06-25 14:43:23',10,0),('1','113',257931,'MORNING SHIFT ','2022-06-25','2022-06-25 17:47:58','2022-06-26 17:47:58','530',3675570.60,3675570.60,'530','2022-06-25 17:49:10','614','2022-06-26 12:01:35',10,0),('1','113',257932,'AFTERNOON ','2022-06-25','2022-06-26 13:19:44','2022-06-27 13:19:44','530',6185251.80,6185251.80,'530','2022-06-26 13:23:51','614','2022-06-26 15:26:05',10,0),('1','113',257933,'MORNING SHIFT ','2022-06-26','2022-06-26 16:13:20','2022-06-27 16:13:20','530',2689494.60,2689494.60,'530','2022-06-26 16:16:27','614','2022-06-26 16:18:10',10,0),('1','113',257934,'AFTERNOON SHIFT','2022-06-26','2022-06-26 21:17:20','2022-06-27 21:17:20','530',1043164.20,1043164.20,'530','2022-06-26 21:18:33','614','2022-06-27 05:23:40',10,0),('1','113',257935,'MORNING SHIFT ','2022-06-27','2022-06-27 14:36:18','2022-06-28 14:36:18','530',2942760.60,2942760.60,'530','2022-06-27 14:38:03','614','2022-06-27 19:57:34',10,0),('1','113',257936,'AFTERNOON SHIFT','2022-06-27','2022-06-27 21:12:33','2022-06-28 21:12:33','530',3562782.60,3562782.60,'530','2022-06-27 21:13:54','614','2022-06-27 23:58:11',10,0),('1','113',257937,'MORNING SHIFT ','2022-06-28','2022-06-28 15:50:48','2022-06-29 15:50:48','530',4486296.00,4486296.00,'530','2022-06-28 15:56:26','614','2022-06-28 16:51:29',10,0),('1','113',257938,'AFTERNOON SHIFT','2022-06-28','2022-06-28 22:39:41','2022-06-29 22:39:41','530',7055548.80,7055548.80,'530','2022-06-28 22:52:45','614','2022-06-29 09:40:37',10,0),('1','113',257939,'MORNING SHIFT ','2022-06-29','2022-06-29 13:56:15','2022-06-30 13:56:15','530',5420345.10,5420345.10,'530','2022-06-29 14:02:24','614','2022-06-29 14:54:12',10,0),('1','113',257940,'AFTERNOON SHIFT','2022-06-29','2022-06-29 22:03:35','2022-06-30 22:03:35','530',6035948.55,6035948.55,'530','2022-06-29 22:11:10','614','2022-06-29 22:18:51',10,0),('1','113',257941,'MORNING SHIFT ','2022-06-30','2022-06-30 13:35:47','2022-07-01 13:35:47','530',7217590.65,7217590.65,'530','2022-06-30 18:06:18','614','2022-06-30 18:26:43',10,0),('1','113',257942,'AFTERNOON SHIFT','2022-06-30','2022-06-30 19:02:54','2022-07-01 19:02:54','530',3494182.35,3494182.35,'530','2022-06-30 20:42:04','614','2022-06-30 23:14:50',10,0),('1','113',257943,'MORNING SHIFT ','2022-07-01','2022-07-01 13:40:40','2022-07-02 13:40:40','530',3743926.50,3743926.50,'530','2022-07-01 13:46:29','614','2022-07-01 20:25:23',10,0),('1','113',257944,'AFTERNOON SHIFT','2022-07-01','2022-07-01 22:04:05','2022-07-02 22:04:05','530',4818557.85,4818557.85,'530','2022-07-01 22:07:01','614','2022-07-01 22:22:44',10,0),('1','113',257945,'MORNING SHIFT ','2022-07-02','2022-07-02 14:28:54','2022-07-03 14:28:54','530',2858376.15,2858376.15,'530','2022-07-02 14:32:13','614','2022-07-02 15:35:54',10,0),('1','113',257946,'AFTERNOON SHIFT','2022-07-02','2022-07-02 22:34:04','2022-07-03 22:34:04','530',2125180.20,2125180.20,'530','2022-07-02 22:38:09','614','2022-07-02 22:52:58',10,0),('1','113',257947,'MORNING SHIFT ','2022-07-03','2022-07-03 14:38:57','2022-07-04 14:38:57','530',4714713.15,4714713.15,'530','2022-07-03 14:49:37','614','2022-07-03 15:06:56',10,0),('1','113',257948,'MORNING SHIFT ','2022-07-03','2022-07-03 22:43:18','2022-07-04 22:43:18','530',9318310.35,9318310.35,'530','2022-07-03 22:48:34','614','2022-07-04 14:18:55',10,0),('1','113',257949,'MORNING SHIFT','2022-07-04','2022-07-04 14:19:43','2022-07-05 14:19:43','530',3779533.20,3779533.20,'530','2022-07-04 14:22:44','614','2022-07-04 14:24:59',10,0),('1','113',257950,'AFTERNOON SHIFT','2022-07-04','2022-07-05 08:05:15','2022-07-06 08:05:15','530',3314120.10,3314120.10,'530','2022-07-05 08:08:10','614','2022-07-05 19:20:40',10,0),('1','113',257951,'MORNING SHIFT ','2022-07-05','2022-07-05 21:30:57','2022-07-06 21:30:57','530',3514212.45,3514212.45,'530','2022-07-05 21:43:17','614','2022-07-06 02:20:28',10,0),('1','113',257952,'AFTERNOON SHIFT','2022-07-06','2022-07-06 09:54:41','2022-07-07 09:54:41','530',6556212.75,6556212.75,'530','2022-07-06 09:58:30','614','2022-07-06 10:06:28',10,0),('1','113',257953,'MORNING SHIFT ','2022-07-06','2022-07-06 14:36:31','2022-07-07 14:36:31','530',4513108.20,4513108.20,'530','2022-07-06 19:31:45','614','2022-07-06 21:26:47',10,0),('1','113',257954,'AFTERNOON SHIFT','2022-07-06','2022-07-06 23:54:02','2022-07-07 23:54:02','530',897619.80,897619.80,'530','2022-07-06 23:57:45','614','2022-07-07 08:19:05',10,0),('1','113',257955,'MORNING SHIFT ','2022-07-07','2022-07-07 14:42:50','2022-07-08 14:42:50','530',2803277.40,2803277.40,'530','2022-07-07 14:45:59','614','2022-07-07 16:37:47',10,0),('1','113',257956,'MORNING SHIFT ','2022-07-08','2022-07-08 08:15:14','2022-07-09 08:15:14','530',1185498.60,1185498.60,'530','2022-07-08 08:36:05','614','2022-07-08 10:26:08',10,0),('1','113',257957,'MORNING SHIFT  2','2022-07-08','2022-07-08 10:42:43','2022-07-09 10:42:43','530',1694982.95,1694982.95,'530','2022-07-08 10:47:44','614','2022-07-08 11:13:29',10,0),('1','113',257958,'MORNING SHIFT ','2022-07-09','2022-07-09 15:45:31','2022-07-10 15:45:31','530',1667758.75,1667758.75,'530','2022-07-09 15:49:19','614','2022-07-09 17:22:40',10,0),('1','113',257959,'AFTERNOON SHIFT','2022-07-09','2022-07-10 08:03:49','2022-07-11 08:03:49','530',2442321.00,2442321.00,'530','2022-07-10 08:07:25','614','2022-07-10 08:43:09',10,0),('1','113',257960,'MORNING SHIFT ','2022-07-10','2022-07-10 14:30:34','2022-07-11 14:30:34','530',4551540.95,4551540.95,'530','2022-07-10 14:34:45','614','2022-07-10 17:23:40',10,0),('1','113',257961,'AFTERNOON SHIFT','2022-07-10','2022-07-10 19:44:35','2022-07-11 19:44:35','530',2779662.60,2779662.60,'530','2022-07-10 19:46:49','614','2022-07-10 23:35:23',10,0),('1','113',257962,'MORNING SHIFT ','2022-07-11','2022-07-11 14:11:13','2022-07-12 14:11:13','530',0.00,0.00,'530','2022-07-11 15:03:09','614','2022-07-11 15:18:07',10,0),('1','113',257963,'MORNING SHIFT ','2022-07-11','2022-07-11 15:58:38','2022-07-12 15:58:38','530',2317858.70,2317858.70,'530','2022-07-11 16:23:01','614','2022-07-11 17:27:15',10,0),('1','113',257964,'AFTERNOON SHIFT','2022-07-11','2022-07-11 23:43:26','2022-07-12 23:43:26','530',3866768.35,3866768.35,'530','2022-07-12 08:47:25','614','2022-07-12 10:11:20',10,0),('1','113',257965,'MORNING SHIFT ','2022-07-12','2022-07-12 15:02:27','2022-07-13 15:02:27','530',6018078.35,6018078.35,'530','2022-07-12 15:10:53','614','2022-07-13 00:00:28',10,0),('1','113',257966,'AFTERNOON SHIFT','2022-07-12','2022-07-13 08:12:37','2022-07-14 08:12:37','530',2687032.70,2687032.70,'530','2022-07-13 09:20:51','614','2022-07-13 15:24:21',10,0),('1','113',257967,'MORNING SHIFT ','2022-07-13','2022-07-13 18:23:07','2022-07-14 18:23:07','530',5740933.60,5740933.60,'530','2022-07-13 18:26:10','614','2022-07-13 23:45:21',10,0),('1','113',257968,'AFTERNOON SHIFT','2022-07-13','2022-07-14 07:40:30','2022-07-15 07:40:30','530',4962601.05,4962601.05,'530','2022-07-14 07:45:34','614','2022-07-14 19:57:50',10,0),('1','113',257969,'MORNING SHIFT ','2022-07-14','2022-07-14 20:50:05','2022-07-15 20:50:05','530',5456241.05,5456241.05,'530','2022-07-14 20:55:40','614','2022-07-14 21:10:21',10,0),('1','113',257970,'AFTERNOON SHIFT8','2022-07-14','2022-07-14 21:43:34','2022-07-15 21:43:34','530',4846494.60,4846494.60,'530','2022-07-15 07:26:02','614','2022-07-15 10:20:35',10,0),('1','113',257971,'MORNING SHIFT ','2022-07-15','2022-07-15 15:20:52','2022-07-16 15:20:52','530',3409268.00,3409268.00,'530','2022-07-15 15:40:36','614','2022-07-15 21:56:10',10,0),('1','113',257972,'AFTERNOON SHIFT','2022-07-15','2022-07-15 22:53:43','2022-07-16 22:53:43','530',5933907.35,5933907.35,'530','2022-07-15 22:58:18','614','2022-07-16 07:20:56',10,0),('1','113',257973,'MORNING SHIFT ','2022-07-16','2022-07-16 09:01:06','2022-07-17 09:01:06','530',0.00,0.00,'530','2022-07-16 09:03:50','614','2022-07-16 16:18:36',10,0),('1','113',257974,'MORNING SHIFT','2022-07-16','2022-07-16 17:09:36','2022-07-17 17:09:36','530',4133495.40,4133495.40,'530','2022-07-16 17:14:05','614','2022-07-16 23:48:53',10,0),('1','113',257975,'AFTERNOON SHIFT','2022-07-16','2022-07-17 06:24:50','2022-07-18 06:24:50','530',6469795.20,6469795.20,'530','2022-07-17 07:16:14','614','2022-07-17 12:29:44',10,0),('1','113',257976,'MORNING SHIFT ','2022-07-17','2022-07-17 13:35:58','2022-07-18 13:35:58','530',3550845.70,3550845.70,'530','2022-07-17 15:12:41','614','2022-07-17 18:40:34',10,0),('1','113',257977,'AFTERNOON SHIFT','2022-07-17','2022-07-17 22:03:20','2022-07-18 22:03:20','530',4077173.35,4077173.35,'530','2022-07-17 22:07:41','614','2022-07-17 23:04:44',10,0),('1','113',257978,'MORNING SHIFT ','2022-07-18','2022-07-18 07:09:32','2022-07-19 07:09:32','530',1404343.20,1404343.20,'530','2022-07-18 14:48:43','614','2022-07-18 15:14:28',10,0),('1','113',257979,'AFTERNOON SHIFT ','2022-07-18','2022-07-19 10:03:05','2022-07-20 10:03:05','530',3184100.40,3184100.40,'530','2022-07-19 10:05:19','614','2022-07-19 14:46:44',10,0),('1','113',257980,'MORNING SHIFT ','2022-07-19','2022-07-19 15:09:35','2022-07-20 15:09:35','530',2334750.60,2334750.60,'530','2022-07-19 15:17:26','614','2022-07-19 15:37:27',10,0),('1','113',257981,'AFTERNOON SHIFT','2022-07-19','2022-07-19 22:07:08','2022-07-20 22:07:08','530',3768008.40,3768008.40,'530','2022-07-19 22:08:46','614','2022-07-19 22:32:34',10,0),('1','113',257982,'MORNING SHIFT ','2022-07-20','2022-07-20 10:42:03','2022-07-21 10:42:03','530',2736918.60,2736918.60,'530','2022-07-20 13:42:42','614','2022-07-20 14:53:06',10,0),('1','113',257983,'AFTERNOON SHIFT','2022-07-20','2022-07-21 07:47:16','2022-07-22 07:47:16','530',3822553.80,3822553.80,'530','2022-07-21 07:54:45','614','2022-07-21 13:24:20',10,0),('1','113',257984,'MORNING SHIFT','2022-07-21','2022-07-21 14:37:41','2022-07-22 14:37:41','530',3882512.40,3882512.40,'530','2022-07-21 14:39:08','614','2022-07-21 14:57:52',10,0),('1','113',257985,'AFTERNOON SHIFT ','2022-07-21','2022-07-21 19:56:01','2022-07-22 19:56:01','530',4391868.00,4391868.00,'530','2022-07-21 19:57:11','614','2022-07-21 22:58:52',10,0),('1','113',257986,'MORNING SHIFT ','2022-07-22','2022-07-22 14:46:36','2022-07-23 14:46:36','530',3579061.20,3579061.20,'530','2022-07-22 14:47:21','614','2022-07-22 15:32:32',10,0),('1','113',257987,'AFTERNOON SHIFT','2022-07-22','2022-07-22 16:03:56','2022-07-23 16:03:56','530',787332.00,787332.00,'530','2022-07-22 16:26:15','614','2022-07-22 18:59:57',10,0),('1','113',257988,'AFTERNOON SHIFT 2','2022-07-22','2022-07-22 20:28:45','2022-07-23 20:28:45','530',3859879.10,3859879.10,'530','2022-07-22 21:29:39','614','2022-07-22 23:08:13',10,0),('1','113',257989,'MORNING SHIFT ','2022-07-23','2022-07-23 14:00:52','2022-07-24 14:00:52','530',3732914.50,3732914.50,'530','2022-07-23 14:09:50','614','2022-07-23 14:56:58',10,0),('1','113',257990,'AFTERNOON SHIFT','2022-07-23','2022-07-23 21:47:56','2022-07-24 21:47:56','530',4559967.65,4559967.65,'530','2022-07-23 21:51:23','614','2022-07-24 20:18:38',10,0),('1','113',257991,'MORNING SHIFT ','2022-07-24','2022-07-24 21:22:22','2022-07-25 21:22:22','530',2825583.60,2825583.60,'530','2022-07-24 22:48:52','614','2022-07-24 22:51:24',10,0),('1','113',257992,'AFTERNOON SHIFT','2022-07-24','2022-07-24 22:58:49','2022-07-25 22:58:49','530',5395005.35,5395005.35,'530','2022-07-24 23:13:47','614','2022-07-24 23:20:30',10,0),('1','113',257993,'MORNING SHIFT ','2022-07-25','2022-07-25 10:11:45','2022-07-26 10:11:45','530',3083431.05,3083431.05,'530','2022-07-25 14:37:17','614','2022-07-25 15:47:36',10,0),('1','113',257994,'AFTERNOON SHIFT','2022-07-25','2022-07-25 20:56:56','2022-07-26 20:56:56','530',7644301.00,7644301.00,'530','2022-07-25 20:59:26','614','2022-07-26 08:01:45',10,0),('1','113',257995,'MORNING SHIFT ','2022-07-26','2022-07-26 09:41:29','2022-07-27 09:41:29','530',6219138.10,6219138.10,'530','2022-07-26 14:59:27','614','2022-07-26 17:08:14',10,0),('1','113',257996,'MORNING SHIFT ','2022-07-26','2022-07-26 19:52:59','2022-07-27 19:52:59','530',6654844.35,6654844.35,'530','2022-07-26 21:09:38','614','2022-07-26 22:22:20',10,0),('1','113',257997,'MORNING SHIFT 1','2022-07-27','2022-07-27 10:18:23','2022-07-28 10:18:23','530',1066324.00,1066324.00,'530','2022-07-27 10:30:15','614','2022-07-27 10:43:29',10,0),('1','113',257998,'MORNING SHIFT  2','2022-07-27','2022-07-27 14:34:37','2022-07-28 14:34:37','530',3141626.40,3141626.40,'530','2022-07-27 14:47:34','614','2022-07-27 15:27:11',10,0),('1','113',257999,'AFTERNOON SHIFT822','2022-07-27','2022-07-27 18:31:03','2022-07-28 18:31:03','530',6321042.40,6321042.40,'530','2022-07-27 21:48:15','614','2022-07-27 21:52:02',10,0),('1','113',258000,'MORNING SHIFT ','2022-07-28','2022-07-28 10:40:58','2022-07-29 10:40:58','530',5615939.10,5615939.10,'530','2022-07-28 15:02:38','614','2022-07-28 15:11:24',10,0),('1','113',258001,'AFTERNOON SHIFT','2022-07-29','2022-07-29 07:29:15','2022-07-30 07:29:15','530',6473870.70,6473870.70,'530','2022-07-29 07:33:49','614','2022-07-29 17:18:31',10,0),('1','113',258002,'MORNING SHIFT ','2022-07-29','2022-07-29 17:59:34','2022-07-30 17:59:34','530',5039394.40,5039394.40,'530','2022-07-29 18:03:35','614','2022-07-29 18:22:25',10,0),('1','113',258003,'AFTERNOON SHIFT','2022-07-29','2022-07-30 07:13:41','2022-07-31 07:13:41','530',6125949.60,6125949.60,'530','2022-07-30 07:18:06','614','2022-07-30 15:18:12',10,0),('1','113',258004,'MORNING SHIFT ','2022-07-30','2022-07-30 15:23:26','2022-07-31 15:23:26','530',7587858.40,7587858.40,'530','2022-07-30 15:29:57','614','2022-07-30 16:16:46',10,0),('1','113',258005,'AFTERNOON SHIFT','2022-07-30','2022-07-30 16:49:25','2022-07-31 16:49:25','530',6054150.80,6054150.80,'530','2022-07-30 22:44:25','614','2022-07-30 23:25:44',10,0),('1','113',258006,'MORNING SHIFT ','2022-07-31','2022-07-31 14:27:40','2022-08-01 14:27:40','530',3292124.70,3292124.70,'530','2022-07-31 15:00:19','614','2022-07-31 15:01:21',10,0),('1','113',258007,'AFTERNOON SHIFT','2022-07-31','2022-07-31 22:02:38','2022-08-01 22:02:38','530',6001513.80,6001513.80,'530','2022-07-31 22:10:23','614','2022-07-31 22:12:39',10,0),('1','113',258008,'MORNING SHIFT','2022-08-01','2022-08-01 10:37:12','2022-08-02 10:37:12','530',0.00,0.00,'426','2022-08-01 10:38:14','426','2022-08-01 10:38:39',10,0),('1','113',258009,'AFTERNOON SHIFT  2','2022-07-31','2022-08-01 10:39:49','2022-08-02 10:39:49','530',0.00,0.00,'530','2022-08-01 10:48:22','426','2022-08-01 10:50:02',10,0),('1','113',258010,'MORNING SHIFT ','2022-08-01','2022-08-01 13:20:32','2022-08-02 13:20:32','530',5141927.10,5141927.10,'530','2022-08-01 14:50:57','614','2022-08-01 18:09:03',10,0),('1','113',258011,'AFTERNOON SHIFT','2022-08-01','2022-08-01 21:35:36','2022-08-02 21:35:36','530',4728998.40,4728998.40,'530','2022-08-01 21:42:41','614','2022-08-01 22:03:03',10,0),('1','113',258012,'MORNING SHIFT ','2022-08-02','2022-08-02 14:51:48','2022-08-03 14:51:48','530',2082115.80,2082115.80,'530','2022-08-02 14:56:45','614','2022-08-02 20:43:47',10,0),('1','113',258013,'AFTERNOON SHIFT','2022-08-02','2022-08-02 22:26:13','2022-08-03 22:26:13','530',2909012.40,2909012.40,'530','2022-08-02 22:28:31','614','2022-08-02 22:32:13',10,0),('1','113',258014,'MORNING SHIFT ','2022-08-03','2022-08-03 14:46:24','2022-08-04 14:46:24','530',2260323.00,2260323.00,'530','2022-08-03 14:51:22','614','2022-08-03 15:04:52',10,0),('1','113',258015,'AFTERNOON SHIFT','2022-08-03','2022-08-03 21:47:08','2022-08-04 21:47:08','530',3099402.00,3099402.00,'530','2022-08-03 21:49:20','614','2022-08-03 22:18:08',10,0),('1','113',258016,'MORNING SHIFT ','2022-08-04','2022-08-04 14:52:27','2022-08-05 14:52:27','530',1856134.80,1856134.80,'530','2022-08-04 14:55:52','614','2022-08-04 16:09:17',10,0),('1','113',258017,'AFTERNOON SHIFT','2022-08-04','2022-08-04 21:49:02','2022-08-05 21:49:02','530',2821248.00,2821248.00,'530','2022-08-04 21:50:55','614','2022-08-04 22:20:46',10,0),('1','113',258018,'MORNING SHIFT ','2022-08-05','2022-08-05 14:55:03','2022-08-06 14:55:03','530',1945368.00,1945368.00,'530','2022-08-05 14:57:56','614','2022-08-05 15:44:08',10,0),('1','113',258019,'AFTERNOON SHIFT','2022-08-05','2022-08-05 21:50:07','2022-08-06 21:50:07','530',2632156.20,2632156.20,'530','2022-08-05 22:15:43','614','2022-08-05 22:40:17',10,0),('1','113',258020,'MORNING SHIFT ','2022-08-06','2022-08-06 14:40:34','2022-08-07 14:40:34','530',1646596.80,1646596.80,'530','2022-08-06 14:43:30','614','2022-08-06 14:44:46',10,0),('1','113',258021,'AFTERNOON SHIFT','2022-08-06','2022-08-06 22:18:58','2022-08-07 22:18:58','530',2469722.40,2469722.40,'530','2022-08-06 22:21:51','614','2022-08-06 22:24:40',10,0),('1','113',258022,'MORNING SHIFT ','2022-08-07','2022-08-07 12:24:10','2022-08-08 12:24:10','530',0.00,0.00,'530','2022-08-07 12:25:42','614','2022-08-07 12:35:55',10,0),('1','113',258023,'MORNING SHIFT ','2022-08-07','2022-08-07 14:47:32','2022-08-08 14:47:32','530',1540283.40,1540283.40,'530','2022-08-07 14:49:29','614','2022-08-07 14:51:34',10,0),('1','113',258024,'AFTERNOON SHIFT','2022-08-07','2022-08-07 15:18:07','2022-08-08 15:18:07','530',1932174.00,1932174.00,'530','2022-08-07 21:12:35','614','2022-08-07 23:16:20',10,0),('1','113',258025,'MORNING SHIFT ','2022-08-08','2022-08-08 08:55:30','2022-08-09 08:55:30','530',1909418.40,1909418.40,'530','2022-08-08 14:28:35','614','2022-08-08 14:39:24',10,0),('1','113',258026,'AFTERNOON SHIFT','2022-08-08','2022-08-08 21:47:28','2022-08-09 21:47:28','530',2579045.40,2579045.40,'530','2022-08-08 21:53:33','614','2022-08-08 22:49:07',10,0),('1','113',258027,'MORNING SHIFT ','2022-08-09','2022-08-09 14:56:20','2022-08-10 14:56:20','530',1852761.60,1852761.60,'530','2022-08-09 14:57:56','614','2022-08-09 14:59:44',10,0),('1','113',258028,'AFTERNOON SHIFT','2022-08-09','2022-08-09 21:40:15','2022-08-10 21:40:15','530',7372476.10,7372476.10,'530','2022-08-09 21:43:31','614','2022-08-10 09:45:09',10,0),('1','113',258029,'MORNING SHIFT ','2022-08-10','2022-08-10 14:55:11','2022-08-11 14:55:11','530',4075001.90,4075001.90,'530','2022-08-10 14:58:29','614','2022-08-10 16:11:24',10,0),('1','113',258030,'AFTERNOON SHIFT','2022-08-10','2022-08-10 22:10:33','2022-08-11 22:10:33','530',6482513.80,6482513.80,'530','2022-08-11 00:49:28','614','2022-08-11 07:34:14',10,0),('1','113',258031,'MORNING SHIFT ','2022-08-11','2022-08-11 08:59:55','2022-08-12 08:59:55','530',0.00,0.00,'530','2022-08-11 10:39:17','614','2022-08-11 10:42:10',10,0),('1','113',258032,'MORNING SHIFT','2022-08-11','2022-08-11 14:01:25','2022-08-12 14:01:25','530',3667147.50,3667147.50,'530','2022-08-11 14:13:32','614','2022-08-11 15:13:30',10,0),('1','113',258033,'AFTERNOON SHIFT','2022-08-11','2022-08-11 22:16:29','2022-08-12 22:16:29','530',5276320.50,5276320.50,'530','2022-08-11 22:20:56','614','2022-08-11 22:30:17',10,0),('1','113',258034,'MORNING SHIFT ','2022-08-12','2022-08-12 14:55:58','2022-08-13 14:55:58','530',6504590.60,6504590.60,'530','2022-08-12 15:00:48','614','2022-08-12 19:16:20',10,0),('1','113',258035,'AFTERNOON SHIFT','2022-08-12','2022-08-12 22:22:59','2022-08-13 22:22:59','530',5829081.20,5829081.20,'530','2022-08-13 07:28:52','614','2022-08-13 09:41:01',10,0),('1','113',258036,'MORNING SHIFT ','2022-08-13','2022-08-13 14:24:44','2022-08-14 14:24:44','530',3578345.00,3578345.00,'530','2022-08-13 14:53:13','614','2022-08-13 18:03:41',10,0),('1','113',258037,'AFTERNOON SHIFT','2022-08-13','2022-08-13 23:34:58','2022-08-14 23:34:58','530',7494872.10,7494872.10,'530','2022-08-13 23:39:20','614','2022-08-13 23:52:37',10,0),('1','113',258038,'MORNING SHIFT ','2022-08-14','2022-08-14 14:50:23','2022-08-15 14:50:23','530',3412324.10,3412324.10,'530','2022-08-14 15:00:11','614','2022-08-14 20:33:24',10,0),('1','113',258039,'AFTERNOON SHIFT','2022-08-14','2022-08-14 21:49:50','2022-08-15 21:49:50','530',2316119.80,2316119.80,'530','2022-08-14 21:52:27','614','2022-08-14 22:52:41',10,0),('1','113',258040,'MORNING SHIFT ','2022-08-15','2022-08-15 14:31:21','2022-08-16 14:31:21','530',3136794.20,3136794.20,'530','2022-08-15 14:42:28','614','2022-08-15 15:00:50',10,0),('1','113',258041,'AFTERNOON SHIFT','2022-08-15','2022-08-15 22:41:45','2022-08-16 22:41:45','530',2801754.60,2801754.60,'530','2022-08-15 22:44:57','614','2022-08-16 09:07:15',10,0),('1','113',258042,'MORNING SHIFT ','2022-08-16','2022-08-16 09:13:05','2022-08-17 09:13:05','530',0.00,0.00,'530','2022-08-16 09:19:11','614','2022-08-16 09:21:00',10,0),('1','113',258043,'MORNING SHIFT ','2022-08-16','2022-08-16 09:23:22','2022-08-17 09:23:22','530',0.00,0.00,'530','2022-08-16 13:59:23','614','2022-08-16 15:56:11',10,0),('1','113',258044,'MORNING SHIFT ','2022-08-16','2022-08-16 16:07:00','2022-08-17 16:07:00','530',4679752.90,4679752.90,'530','2022-08-16 19:01:41','614','2022-08-16 21:58:17',10,0),('1','113',258045,'AFTERNOON SHIFT','2022-08-16','2022-08-16 22:21:18','2022-08-17 22:21:18','530',5391229.90,5391229.90,'530','2022-08-16 22:30:36','614','2022-08-16 22:31:11',10,0),('1','113',258046,'MORNING SHIFT ','2022-08-17','2022-08-17 11:19:33','2022-08-18 11:19:33','530',4824574.10,4824574.10,'530','2022-08-17 14:34:54','614','2022-08-17 20:06:41',10,0),('1','113',258047,'AFTERNOON SHIFT','2022-08-17','2022-08-17 22:26:28','2022-08-18 22:26:28','530',8983379.90,8983379.90,'530','2022-08-17 22:47:27','614','2022-08-17 23:04:06',10,0),('1','113',258048,'MORNING SHIFT ','2022-08-18','2022-08-18 14:09:03','2022-08-19 14:09:03','530',1720582.20,1720582.20,'530','2022-08-18 14:25:33','614','2022-08-18 17:32:21',10,0),('1','113',258049,'AFTERNOON SHIFT','2022-08-18','2022-08-18 21:30:07','2022-08-19 21:30:07','530',2507346.00,2507346.00,'530','2022-08-18 21:32:50','614','2022-08-19 00:04:58',10,0),('1','113',258050,'MORNING SHIFT ','2022-08-19','2022-08-19 14:55:00','2022-08-20 14:55:00','530',1691451.00,1691451.00,'530','2022-08-19 14:58:18','614','2022-08-19 22:02:32',10,0),('1','113',258051,'AFTERNOON SHIFT','2022-08-19','2022-08-19 22:17:04','2022-08-20 22:17:04','530',2266252.20,2266252.20,'530','2022-08-19 22:19:37','614','2022-08-19 22:20:59',10,0),('1','113',258052,'MORNING SHIFT ','2022-08-20','2022-08-20 14:59:19','2022-08-21 14:59:19','530',1509744.60,1509744.60,'530','2022-08-20 15:05:13','614','2022-08-20 15:05:55',10,0),('1','113',258053,'AFTERNOON SHIFT','2022-08-20','2022-08-21 09:26:39','2022-08-22 09:26:39','530',13256627.20,13256627.20,'530','2022-08-21 09:29:21','614','2022-08-21 12:50:43',10,0),('1','113',258054,'MORNING SHIFT ','2022-08-21','2022-08-21 14:44:30','2022-08-22 14:44:30','530',972496.00,972496.00,'530','2022-08-21 14:46:00','614','2022-08-21 18:48:36',10,0),('1','113',258055,'AFTERNOON SHIFT','2022-08-21','2022-08-21 23:47:42','2022-08-22 23:47:42','530',1996383.20,1996383.20,'530','2022-08-22 06:52:55','614','2022-08-22 07:15:59',10,0),('1','113',258056,'MORNING SHIFT ','2022-08-22','2022-08-22 14:38:39','2022-08-23 14:38:39','530',931630.80,931630.80,'530','2022-08-22 14:41:14','614','2022-08-22 16:20:02',10,0),('1','113',258057,'AFTERNOON SHIFT','2022-08-22','2022-08-22 23:30:01','2022-08-23 23:30:01','530',2548432.00,2548432.00,'530','2022-08-22 23:30:58','614','2022-08-23 07:15:58',10,0),('1','113',258058,'MORNING SHIFT ','2022-08-23','2022-08-23 13:43:19','2022-08-24 13:43:19','530',975308.00,975308.00,'530','2022-08-23 13:45:09','614','2022-08-23 14:42:19',10,0),('1','113',258059,'AFTERNOON SHIFT','2022-08-23','2022-08-23 22:55:31','2022-08-24 22:55:31','530',3923310.40,3923310.40,'530','2022-08-23 23:02:16','614','2022-08-23 23:53:52',10,0),('1','113',258060,'MORNING SHIFT','2022-08-24','2022-08-24 15:08:41','2022-08-25 15:08:41','530',2542587.60,2542587.60,'530','2022-08-24 15:11:02','614','2022-08-24 19:06:53',10,0),('1','113',258061,'AFTERNOON SHIFT','2022-08-24','2022-08-24 23:26:15','2022-08-25 23:26:15','530',2594784.40,2594784.40,'530','2022-08-24 23:28:02','614','2022-08-25 08:25:59',10,0),('1','113',258062,'MORNING SHIFT ','2022-08-25','2022-08-25 14:30:11','2022-08-26 14:30:11','530',2836918.60,2836918.60,'530','2022-08-25 14:36:43','614','2022-08-25 15:26:18',10,0),('1','113',258063,'AFTERNOON SHIFT','2022-08-25','2022-08-26 07:44:06','2022-08-27 07:44:06','530',3204120.20,3204120.20,'530','2022-08-26 07:46:58','614','2022-08-26 20:09:40',10,0),('1','113',258064,'MORNING SHIFT ','2022-08-26','2022-08-26 21:22:26','2022-08-27 21:22:26','530',2520375.20,2520375.20,'530','2022-08-26 21:25:15','614','2022-08-26 22:19:35',10,0),('1','113',258065,'AFTERNOON SHIFT','2022-08-26','2022-08-26 23:07:48','2022-08-27 23:07:48','530',5200489.40,5200489.40,'530','2022-08-26 23:12:32','614','2022-08-27 19:17:03',10,0),('1','113',258066,'MORNING SHIFT ','2022-08-27','2022-08-27 21:19:58','2022-08-28 21:19:58','530',0.00,0.00,'530','2022-08-27 21:31:09','614','2022-08-27 21:35:38',10,0),('1','113',258067,'MORNING SHIFT ','2022-08-27','2022-08-27 21:36:28','2022-08-28 21:36:28','530',3846250.80,3846250.80,'530','2022-08-27 21:38:23','614','2022-08-27 21:39:16',10,0),('1','113',258068,'AFTERNOON SHIFT','2022-08-27','2022-08-27 21:39:44','2022-08-28 21:39:44','530',5445598.80,5445598.80,'530','2022-08-27 21:55:11','614','2022-08-27 22:11:58',10,0),('1','113',258069,'MORNING SHIFT ','2022-08-28','2022-08-28 14:27:27','2022-08-29 14:27:27','530',2695881.40,2695881.40,'530','2022-08-28 14:36:12','614','2022-08-28 15:02:12',10,0),('1','113',258070,'AFTERNOON SHIFT','2022-08-28','2022-08-28 21:19:14','2022-08-29 21:19:14','530',4817622.40,4817622.40,'530','2022-08-28 21:26:01','614','2022-08-29 07:29:52',10,0),('1','113',258071,'MORNING SHIFT ','2022-08-29','2022-08-29 14:53:24','2022-08-30 14:53:24','530',3673974.20,3673974.20,'530','2022-08-29 15:01:56','614','2022-08-29 15:40:50',10,0),('1','113',258072,'AFTERNOON SHIFT','2022-08-29','2022-08-29 23:04:00','2022-08-30 23:04:00','530',5136705.80,5136705.80,'530','2022-08-29 23:08:43','614','2022-08-30 08:42:34',10,0),('1','113',258073,'MORNING SHIFT ','2022-08-30','2022-08-30 14:20:24','2022-08-31 14:20:24','530',2040060.00,2040060.00,'530','2022-08-30 14:24:51','614','2022-08-30 14:29:45',10,0),('1','113',258074,'AFTERNOON SHIFT','2022-08-30','2022-08-30 23:19:08','2022-08-31 23:19:08','530',4317889.20,4317889.20,'530','2022-08-30 23:27:38','614','2022-08-30 23:44:00',10,0),('1','113',258075,'MORNING SHIFT','2022-08-31','2022-08-31 13:21:42','2022-09-01 13:21:42','530',1862794.60,1862794.60,'530','2022-08-31 13:25:44','614','2022-08-31 14:41:44',10,0),('1','113',258076,'AFTERNOON SHIFT','2022-08-31','2022-08-31 23:03:12','2022-09-01 23:03:12','530',3101439.00,3101439.00,'530','2022-08-31 23:07:53','614','2022-08-31 23:37:49',10,0),('1','113',258077,'MORNING SHIFT','2022-09-01','2022-09-01 14:33:53','2022-09-02 14:33:53','530',5477371.60,5477371.60,'530','2022-09-01 14:42:10','614','2022-09-01 15:19:03',10,0),('1','113',258078,'AFTERNOON SHIFT','2022-09-01','2022-09-01 22:47:57','2022-09-02 22:47:57','530',5671732.40,5671732.40,'530','2022-09-01 22:53:02','614','2022-09-02 11:06:35',10,0),('1','113',258079,'MORNING SHIFT ','2022-09-02','2022-09-02 15:26:01','2022-09-03 15:26:01','530',3719784.80,3719784.80,'530','2022-09-02 15:27:54','614','2022-09-02 21:10:34',10,0),('1','113',258080,'AFTERNOON SHIFT','2022-09-02','2022-09-02 22:16:30','2022-09-03 22:16:30','530',6934150.00,6934150.00,'530','2022-09-02 22:19:39','614','2022-09-02 22:20:03',10,0),('1','113',258081,'MORNING SHIFT ','2022-09-03','2022-09-03 11:48:23','2022-09-04 11:48:23','530',0.00,0.00,'530','2022-09-03 11:51:16','614','2022-09-03 20:52:16',10,0),('1','113',258082,'MORNING SHIFT ','2022-09-03','2022-09-03 20:55:17','2022-09-04 20:55:17','530',6127884.80,6127884.80,'530','2022-09-03 21:00:14','614','2022-09-03 21:02:02',10,0),('1','113',258083,'AFTERNOON SHIFT','2022-09-03','2022-09-03 21:43:14','2022-09-04 21:43:14','530',5991621.20,5991621.20,'530','2022-09-03 21:47:18','614','2022-09-04 00:10:44',10,0),('1','113',258084,'MORNING SHIFT ','2022-09-04','2022-09-04 13:19:31','2022-09-05 13:19:31','530',4049454.20,4049454.20,'530','2022-09-04 13:34:25','614','2022-09-04 14:40:08',10,0),('1','113',258085,'AFTERNOON SHIFT','2022-09-04','2022-09-04 22:38:47','2022-09-05 22:38:47','530',3390951.80,3390951.80,'530','2022-09-04 22:42:56','614','2022-09-04 22:43:28',10,0),('1','113',258086,'MORNING SHIFT ','2022-09-05','2022-09-05 14:22:15','2022-09-06 14:22:15','530',4971542.00,4971542.00,'530','2022-09-05 14:26:05','614','2022-09-05 14:48:40',10,0),('1','113',258087,'AFTERNOON SHIFT ','2022-09-05','2022-09-05 17:05:42','2022-09-06 17:05:42','530',0.00,0.00,'530','2022-09-05 17:07:56','614','2022-09-05 17:14:57',10,0),('1','113',258088,'AFTERNOON SHIFT ','2022-09-05','2022-09-05 17:19:52','2022-09-06 17:19:52','530',4486753.40,4486753.40,'530','2022-09-05 22:23:17','614','2022-09-05 23:23:02',10,0),('1','113',258089,'MORNING SHIFT','2022-09-06','2022-09-06 15:05:59','2022-09-07 15:05:59','530',6183643.20,6183643.20,'530','2022-09-06 15:24:46','614','2022-09-06 15:37:43',10,0),('1','113',258090,'AFTERNOON SHIFT','2022-09-06','2022-09-06 23:03:47','2022-09-07 23:03:47','530',4101750.00,4101750.00,'530','2022-09-06 23:07:36','614','2022-09-07 08:09:15',10,0),('1','113',258091,'MORNING SHIFT ','2022-09-07','2022-09-07 13:50:49','2022-09-08 13:50:49','530',4414848.00,4414848.00,'530','2022-09-07 13:55:42','614','2022-09-07 16:29:46',10,0),('1','113',258092,'AFTERNOON SHIFT','2022-09-07','2022-09-07 21:55:12','2022-09-08 21:55:12','530',3905241.00,3905241.00,'530','2022-09-07 21:57:57','614','2022-09-07 23:34:17',10,0),('1','113',258093,'MORNING SHIFT ','2022-09-08','2022-09-08 14:49:47','2022-09-09 14:49:47','530',3641693.20,3641693.20,'530','2022-09-08 14:55:04','614','2022-09-08 18:00:58',10,0),('1','113',258094,'AFTERNOON SHIFT','2022-09-08','2022-09-08 21:46:02','2022-09-09 21:46:02','530',4536102.00,4536102.00,'530','2022-09-08 21:50:05','614','2022-09-08 23:12:02',10,0),('1','113',258095,'MORNING SHIFT','2022-09-09','2022-09-09 09:03:50','2022-09-10 09:03:50','530',5512456.40,5512456.40,'530','2022-09-09 13:45:28','614','2022-09-09 16:04:53',10,0),('1','113',258096,'AFTERNOON SHIFT','2022-09-09','2022-09-09 19:22:17','2022-09-10 19:22:17','530',6647757.20,6647757.20,'530','2022-09-09 22:26:05','614','2022-09-10 08:46:53',10,0),('1','113',258097,'MORNING SHIFT','2022-09-10','2022-09-10 14:55:47','2022-09-11 14:55:47','530',6665183.80,6665183.80,'530','2022-09-10 15:02:49','614','2022-09-10 15:27:19',10,0),('1','113',258098,'AFTERNOON SHIFT','2022-09-10','2022-09-10 22:03:14','2022-09-11 22:03:14','530',5461969.60,5461969.60,'530','2022-09-10 22:06:53','614','2022-09-11 00:04:44',10,0),('1','113',258099,'MORNING SHIFT ','2022-09-11','2022-09-11 14:30:53','2022-09-12 14:30:53','530',3113975.80,3113975.80,'530','2022-09-11 15:00:09','614','2022-09-11 17:11:30',10,0),('1','113',258100,'AFTERNOON SHIFT','2022-09-11','2022-09-11 21:39:41','2022-09-12 21:39:41','530',3572811.20,3572811.20,'530','2022-09-12 07:49:59','614','2022-09-12 09:48:09',10,0),('1','113',258101,'MORNING SHIFT','2022-09-12','2022-09-12 10:34:44','2022-09-13 10:34:44','530',0.00,0.00,'530','2022-09-12 10:36:36','614','2022-09-12 17:38:29',10,0),('1','113',258102,'MORNING SHIFT ','2022-09-12','2022-09-12 17:39:59','2022-09-13 17:39:59','530',3238535.20,3238535.20,'530','2022-09-12 17:42:54','614','2022-09-12 20:24:48',10,0),('1','113',258103,'AFTERNOON SHIFT','2022-09-12','2022-09-12 21:31:53','2022-09-13 21:31:53','530',3655512.80,3655512.80,'530','2022-09-12 21:37:10','614','2022-09-12 22:45:45',10,0),('1','113',258104,'MORNING SHIFT ','2022-09-13','2022-09-13 13:24:19','2022-09-14 13:24:19','530',3653664.80,3653664.80,'530','2022-09-13 13:28:35','614','2022-09-13 13:35:25',10,0),('1','113',258105,'AFTERNOON SHIFT','2022-09-13','2022-09-13 22:49:50','2022-09-14 22:49:50','530',5082743.80,5082743.80,'530','2022-09-13 22:53:43','614','2022-09-14 07:47:25',10,0),('1','113',258106,'MORNING SHIFT ','2022-09-14','2022-09-14 11:05:18','2022-09-15 11:05:18','530',0.00,0.00,'530','2022-09-14 11:56:09','614','2022-09-14 12:09:28',10,0),('1','113',258107,'MORNING SHIFT ','2022-09-14','2022-09-14 13:49:59','2022-09-15 13:49:59','530',4368824.40,4368824.40,'530','2022-09-14 13:54:19','614','2022-09-14 15:58:37',10,0),('1','113',258108,'AFTERNOON SHIFT','2022-09-14','2022-09-14 21:31:39','2022-09-15 21:31:39','530',5261100.20,5261100.20,'530','2022-09-14 21:38:34','614','2022-09-15 07:06:44',10,0),('1','113',258109,'MORNING SHIFT ','2022-09-15','2022-09-15 09:32:31','2022-09-16 09:32:31','530',3169869.20,3169869.20,'530','2022-09-15 13:52:19','614','2022-09-15 15:08:42',10,0),('1','113',258110,'AFTERNOON SHIFT','2022-09-15','2022-09-15 23:05:16','2022-09-16 23:05:16','530',5131244.00,5131244.00,'530','2022-09-15 23:07:54','614','2022-09-15 23:27:49',10,0),('1','113',258111,'MORNING SHIFT','2022-09-16','2022-09-16 11:05:46','2022-09-17 11:05:46','530',5988491.40,5988491.40,'530','2022-09-16 15:11:41','614','2022-09-16 15:50:27',10,0),('1','113',258112,'AFTERNOON SHIFT','2022-09-16','2022-09-16 21:47:56','2022-09-17 21:47:56','530',5674254.40,5674254.40,'530','2022-09-16 22:07:28','614','2022-09-16 22:28:04',10,0),('1','113',258113,'MORNING SHIFT ','2022-09-17','2022-09-17 14:35:56','2022-09-18 14:35:56','530',1837427.40,1837427.40,'530','2022-09-17 14:38:12','614','2022-09-17 18:39:51',10,0),('1','113',258114,'AFTERNOON SHIFT','2022-09-17','2022-09-17 22:46:57','2022-09-18 22:46:57','530',2940733.80,2940733.80,'530','2022-09-17 22:49:46','614','2022-09-17 23:09:22',10,0),('1','113',258115,'MORNING SHIFT','2022-09-18','2022-09-18 13:34:03','2022-09-19 13:34:03','530',1834884.00,1834884.00,'530','2022-09-18 13:37:57','614','2022-09-18 15:11:19',10,0),('1','113',258116,'AFTERNOON SHIFT','2022-09-18','2022-09-18 21:17:05','2022-09-19 21:17:05','530',2393749.80,2393749.80,'530','2022-09-18 21:21:26','614','2022-09-18 23:28:01',10,0),('1','113',258117,'MORNING SHIFT ','2022-09-19','2022-09-19 14:41:42','2022-09-20 14:41:42','530',1675902.60,1675902.60,'530','2022-09-19 14:44:28','614','2022-09-19 20:19:45',10,0),('1','113',258118,'AFTERNOON SHIFT','2022-09-19','2022-09-19 22:20:52','2022-09-20 22:20:52','530',2201261.40,2201261.40,'530','2022-09-19 22:22:49','614','2022-09-20 07:50:29',10,0),('1','113',258119,'MORNING SHIFT ','2022-09-20','2022-09-20 14:41:51','2022-09-21 14:41:51','530',1802905.20,1802905.20,'530','2022-09-20 14:52:45','614','2022-09-20 16:03:25',10,0),('1','113',258120,'MORNING SHIFT ','2022-09-21','2022-09-21 14:20:31','2022-09-22 14:20:31','530',0.00,0.00,'426','2022-09-22 18:06:05','426','2022-09-22 18:10:22',10,0),('1','113',258121,'MORNING SHIFT ','2022-09-21','2022-09-23 07:11:43','2022-09-24 07:11:43','530',3673088.80,3673088.80,'530','2022-09-23 07:15:49','614','2022-09-23 08:04:06',10,0),('1','113',258122,'AFTERNOON SHIFT 1','2022-09-21','2022-09-23 08:48:15','2022-09-24 08:48:15','530',1654976.00,1654976.00,'530','2022-09-23 08:49:55','614','2022-09-23 08:53:02',10,0),('1','113',258123,'AFTERNOON SHIFT 2','2022-09-21','2022-09-23 09:22:06','2022-09-24 09:22:06','530',2593230.40,2593230.40,'530','2022-09-23 09:29:48','614','2022-09-23 09:51:58',10,0),('1','113',258124,'MORNING SHIFT ','2022-09-22','2022-09-23 10:00:04','2022-09-24 10:00:04','530',3417970.60,3417970.60,'530','2022-09-23 10:19:36','614','2022-09-23 10:24:30',10,0),('1','113',258125,'AFTERNOON SHIFT','2022-09-22','2022-09-23 10:58:17','2022-09-24 10:58:17','530',8315099.10,8315099.10,'530','2022-09-23 11:01:35','614','2022-09-23 12:40:21',10,0),('1','113',258126,'MORNING SHIFT ','2022-09-23','2022-09-23 14:51:10','2022-09-24 14:51:10','530',6455134.90,6455134.90,'530','2022-09-23 14:53:06','614','2022-09-23 15:03:57',10,0),('1','113',258127,'AFTERNOON SHIFT','2022-09-23','2022-09-23 20:54:37','2022-09-24 20:54:37','530',3421171.60,3421171.60,'530','2022-09-24 06:36:31','614','2022-09-24 07:12:03',10,0),('1','113',258128,'MORNING SHIFT','2022-09-24','2022-09-24 13:38:03','2022-09-25 13:38:03','530',5660208.60,5660208.60,'530','2022-09-24 13:40:54','614','2022-09-24 14:56:20',10,0),('1','113',258129,'AFTERNOON SHIFT','2022-09-24','2022-09-24 21:06:02','2022-09-25 21:06:02','530',3353619.50,3353619.50,'530','2022-09-24 21:07:51','614','2022-09-24 22:06:38',10,0),('1','113',258130,'MORNING SHIFT ','2022-09-25','2022-09-25 13:19:06','2022-09-26 13:19:06','530',1050256.90,1050256.90,'530','2022-09-25 13:22:50','614','2022-09-25 14:12:43',10,0),('1','113',258131,'AFTERNOON SHIFT','2022-09-25','2022-09-25 19:55:15','2022-09-26 19:55:15','530',732665.30,732665.30,'530','2022-09-25 19:57:33','614','2022-09-25 21:04:01',10,0),('1','113',258132,'MORNING SHIFT ','2022-09-26','2022-09-26 13:19:48','2022-09-27 13:19:48','530',1813641.40,1813641.40,'530','2022-09-26 14:20:30','614','2022-09-26 16:21:26',10,0),('1','113',258133,'AFTERNOON SHIFT','2022-09-26','2022-09-26 21:53:03','2022-09-27 21:53:03','530',4533351.10,4533351.10,'530','2022-09-26 22:00:11','614','2022-09-27 07:02:17',10,0),('1','113',258134,'MORNING SHIFT ','2022-09-27','2022-09-27 13:28:24','2022-09-28 13:28:24','530',2011220.50,2011220.50,'530','2022-09-27 13:34:35','614','2022-09-27 14:00:34',10,0),('1','113',258135,'AFTERNOON SHIFT','2022-09-27','2022-09-27 21:24:24','2022-09-28 21:24:24','530',4183399.90,4183399.90,'530','2022-09-27 21:28:04','614','2022-09-27 22:10:34',10,0),('1','113',258136,'MORNING SHIFT ','2022-09-28','2022-09-28 14:18:01','2022-09-29 14:18:01','530',3086150.10,3086150.10,'530','2022-09-28 14:36:18','614','2022-09-28 14:47:33',10,0),('1','113',258137,'AFTERNOON SHIFT','2022-09-28','2022-09-29 07:45:58','2022-09-30 07:45:58','530',2562196.00,2562196.00,'530','2022-09-29 07:49:51','614','2022-09-29 09:28:03',10,0),('1','113',258138,'MORNING SHIFT ','2022-09-29','2022-09-29 14:52:26','2022-09-30 14:52:26','530',1516820.40,1516820.40,'530','2022-09-29 14:55:40','614','2022-09-29 15:01:43',10,0),('1','113',258139,'AFTERNOON SHIFT','2022-09-29','2022-09-29 20:06:47','2022-09-30 20:06:47','530',0.00,0.00,'530','2022-09-29 20:09:46','614','2022-09-29 21:35:39',10,0),('1','113',258140,'AFTERNOON SHIFT','2022-09-29','2022-09-29 22:16:41','2022-09-30 22:16:41','530',1991014.20,1991014.20,'530','2022-09-29 22:19:26','614','2022-09-30 12:35:30',10,0),('1','113',258141,'MORNING SHIFT ','2022-09-30','2022-09-30 15:19:04','2022-10-01 15:19:04','530',1638565.20,1638565.20,'530','2022-09-30 15:40:38','614','2022-09-30 15:43:31',10,0),('1','113',258142,'AFTERNOON SHIFT','2022-09-30','2022-10-01 09:01:28','2022-10-02 09:01:28','530',2254735.80,2254735.80,'530','2022-10-01 09:06:39','614','2022-10-01 10:42:35',10,0),('1','113',258143,'MORNING SHIFT ','2022-10-01','2022-10-01 14:20:33','2022-10-02 14:20:33','530',3961275.50,3961275.50,'530','2022-10-01 14:25:16','614','2022-10-01 15:50:03',10,0),('1','113',258144,'AFTERNOON SHIFT 1','2022-10-01','2022-10-01 17:57:05','2022-10-02 17:57:05','530',1061545.10,1061545.10,'530','2022-10-01 17:57:49','614','2022-10-01 21:27:15',10,0),('1','113',258145,'AFTERNOON SHIFT 2','2022-10-01','2022-10-02 05:58:52','2022-10-03 05:58:52','530',4324197.00,4324197.00,'530','2022-10-02 06:04:20','614','2022-10-02 06:58:53',10,0),('1','113',258146,'MORNING SHIFT ','2022-10-02','2022-10-02 13:27:03','2022-10-03 13:27:03','530',6531034.80,6531034.80,'530','2022-10-02 13:30:46','614','2022-10-02 18:35:41',10,0),('1','113',258147,'AFTERNOON SHIFT','2022-10-02','2022-10-02 19:18:38','2022-10-03 19:18:38','530',0.00,0.00,'530','2022-10-02 19:20:28','614','2022-10-02 22:13:34',10,0),('1','113',258148,'AFTERNOON SHIFT','2022-10-02','2022-10-02 22:19:16','2022-10-03 22:19:16','530',2585905.80,2585905.80,'530','2022-10-02 22:22:55','614','2022-10-02 23:22:13',10,0),('1','113',258149,'MORNING SHIFT ','2022-10-03','2022-10-03 13:51:28','2022-10-04 13:51:28','530',3562145.40,3562145.40,'530','2022-10-03 13:58:32','614','2022-10-03 15:04:28',10,0),('1','113',258150,'AFTERNOON SHIFT','2022-10-03','2022-10-03 22:04:34','2022-10-04 22:04:34','530',3493706.40,3493706.40,'530','2022-10-03 22:07:35','614','2022-10-03 22:43:08',10,0),('1','113',258151,'MORNING SHIFT ','2022-10-04','2022-10-04 14:25:03','2022-10-05 14:25:03','530',2780587.80,2780587.80,'530','2022-10-04 14:27:51','614','2022-10-04 23:12:50',10,0),('1','113',258152,'AFTERNOON SHIFT','2022-10-04','2022-10-04 23:17:01','2022-10-05 23:17:01','530',3847686.60,3847686.60,'530','2022-10-04 23:20:48','614','2022-10-05 08:04:08',10,0),('1','113',258153,'MORNING SHIFT ','2022-10-05','2022-10-05 17:41:35','2022-10-06 17:41:35','530',2977793.40,2977793.40,'530','2022-10-05 17:45:42','614','2022-10-05 18:12:44',10,0),('1','113',258154,'AFTERNOON SHIFT','2022-10-05','2022-10-05 22:39:33','2022-10-06 22:39:33','530',3958962.00,3958962.00,'530','2022-10-05 22:45:11','614','2022-10-05 22:59:33',10,0),('1','113',258155,'MORNING SHIFT ','2022-10-06','2022-10-06 15:10:42','2022-10-07 15:10:42','530',2464690.80,2464690.80,'530','2022-10-06 15:12:46','614','2022-10-06 16:54:16',10,0),('1','113',258156,'AFTERNOON SHIFT','2022-10-06','2022-10-06 21:31:20','2022-10-07 21:31:20','530',2161614.00,2161614.00,'530','2022-10-06 21:32:45','614','2022-10-06 22:48:50',10,0),('1','113',258157,'MORNING SHIFT ','2022-10-07','2022-10-07 14:58:30','2022-10-08 14:58:30','530',1125960.50,1128855.00,'530','2022-10-07 14:59:27','614','2022-10-07 16:04:11',10,0),('1','113',258158,'AFTERNOON SHIFT','2022-10-07','2022-10-07 21:53:27','2022-10-08 21:53:27','530',3032465.06,3040260.60,'530','2022-10-07 21:54:24','614','2022-10-07 22:55:08',10,0),('1','113',258159,'MORNING SHIFT ','2022-10-08','2022-10-08 16:07:56','2022-10-09 16:07:56','530',1917641.92,1921803.00,'530','2022-10-08 16:12:40','614','2022-10-08 18:00:00',10,0),('1','113',258160,'AFTERNOON SHIFT','2022-10-08','2022-10-08 22:21:32','2022-10-09 22:21:32','530',4349979.84,4353921.00,'530','2022-10-08 22:26:31','614','2022-10-08 23:56:05',10,0),('1','113',258161,'MORNING SHIFT ','2022-10-09','2022-10-09 08:54:55','2022-10-10 08:54:55','530',1839697.60,1841159.40,'530','2022-10-09 13:50:08','614','2022-10-09 14:09:30',10,0),('1','113',258162,'AFTERNOON SHIFT','2022-10-09','2022-10-09 18:39:18','2022-10-10 18:39:18','530',0.00,0.00,'530','2022-10-09 18:41:42','614','2022-10-09 22:17:57',10,0),('1','113',258163,'AFTERNOON SHIFT','2022-10-09','2022-10-09 22:19:49','2022-10-10 22:19:49','530',4886479.20,4886479.20,'530','2022-10-09 22:31:06','614','2022-10-09 23:07:16',10,0),('1','113',258164,'MORNING SHIFT ','2022-10-10','2022-10-10 14:12:44','2022-10-11 14:12:44','530',3454557.60,3454557.60,'530','2022-10-10 14:30:17','614','2022-10-10 14:53:54',10,0),('1','113',258165,'AFTERNOON SHIFT','2022-10-10','2022-10-10 22:18:39','2022-10-11 22:18:39','530',1663123.80,1663123.80,'530','2022-10-10 22:23:56','614','2022-10-11 16:17:31',10,0),('1','113',258166,'MORNING SHIFT ','2022-10-11','2022-10-11 21:14:55','2022-10-12 21:14:55','530',3945444.60,3945444.60,'530','2022-10-11 21:40:55','614','2022-10-11 21:48:26',10,0),('1','113',258167,'AFTERNOON SHIFT','2022-10-11','2022-10-11 21:52:08','2022-10-12 21:52:08','530',4729620.60,4729620.60,'530','2022-10-11 21:54:41','614','2022-10-11 21:55:53',10,0),('1','113',258168,'AFTERNOON SHIFT','2022-10-11','2022-10-11 22:00:05','2022-10-12 22:00:05','530',0.00,0.00,'530','2022-10-11 22:01:26','614','2022-10-11 22:10:38',10,0),('1','113',258169,'MORNING SHIFT ','2022-10-12','2022-10-12 14:48:44','2022-10-13 14:48:44','530',2686185.00,2686185.00,'530','2022-10-12 14:53:10','614','2022-10-12 17:09:14',10,0),('1','113',258170,'AFTERNOON SHIFT 1','2022-10-12','2022-10-12 18:32:56','2022-10-13 18:32:56','530',1225777.80,1225777.80,'530','2022-10-12 19:37:27','614','2022-10-12 20:30:20',10,0),('1','113',258171,'AFTERNOON SHIFT 2','2022-10-12','2022-10-12 21:25:54','2022-10-13 21:25:54','530',4092913.20,4092913.20,'530','2022-10-12 21:29:10','614','2022-10-12 22:39:02',10,0),('1','113',258172,'MORNING SHIFT ','2022-10-13','2022-10-13 14:37:49','2022-10-14 14:37:49','530',1959104.00,1959104.00,'530','2022-10-13 14:39:41','614','2022-10-13 21:59:38',10,0),('1','113',258173,'AFTERNOON SHIFT','2022-10-13','2022-10-13 22:01:14','2022-10-14 22:01:14','530',2331280.00,2331280.00,'530','2022-10-13 22:02:45','614','2022-10-14 05:11:02',10,0),('1','113',258174,'MORNING SHIFT ','2022-10-14','2022-10-14 15:49:38','2022-10-15 15:49:38','530',3180324.40,3180324.40,'530','2022-10-14 15:55:04','614','2022-10-14 16:05:32',10,0),('1','113',258175,'AFTERNOON SHIFT','2022-10-14','2022-10-14 22:01:52','2022-10-15 22:01:52','530',4993826.20,4993826.20,'530','2022-10-14 22:05:58','614','2022-10-14 22:38:17',10,0),('1','113',258176,'MORNING SHIFT','2022-10-15','2022-10-15 14:25:59','2022-10-16 14:25:59','530',3389799.00,3389799.00,'530','2022-10-15 14:29:45','614','2022-10-15 16:39:59',10,0),('1','113',258177,'AFTERNOON SHIFT','2022-10-15','2022-10-15 21:28:18','2022-10-16 21:28:18','530',1764263.00,1764263.00,'530','2022-10-15 21:36:11','614','2022-10-15 22:50:14',10,0),('1','113',258178,'MORNING SHIFT','2022-10-16','2022-10-16 15:00:21','2022-10-17 15:00:21','530',1050248.00,1050248.00,'530','2022-10-16 15:02:25','614','2022-10-16 16:57:33',10,0),('1','113',258179,'AFTERNOON SHIFT','2022-10-16','2022-10-16 21:45:12','2022-10-17 21:45:12','530',307977.80,307977.80,'530','2022-10-17 06:04:09','614','2022-10-17 06:49:41',10,0),('1','113',258180,'MORNING SHIFT ','2022-10-17','2022-10-17 17:30:58','2022-10-18 17:30:58','530',1242680.20,1242680.20,'530','2022-10-17 17:32:41','614','2022-10-18 04:58:12',10,0),('1','113',258181,'AFTERNOON SHIFT','2022-10-18','2022-10-18 07:50:32','2022-10-19 07:50:32','530',0.00,0.00,'426','2022-10-18 09:46:27','426','2022-10-18 09:46:47',10,0),('1','113',258182,'AFTERNOON SHIFT','2022-10-17','2022-10-18 09:47:15','2022-10-19 09:47:15','530',776240.00,776240.00,'530','2022-10-18 09:49:18','614','2022-10-18 15:40:13',10,0),('1','113',258183,'MORNING SHIFT ','2022-10-18','2022-10-18 16:27:28','2022-10-19 16:27:28','530',959640.40,959640.40,'530','2022-10-18 16:29:53','614','2022-10-18 23:47:45',10,0),('1','113',258184,'AFTERNOON SHIFT','2022-10-18','2022-10-19 06:29:25','2022-10-20 06:29:25','530',3032751.40,3032751.40,'530','2022-10-19 06:37:20','614','2022-10-19 08:58:04',10,0),('1','113',258185,'MORNING SHIFT ','2022-10-19','2022-10-19 09:04:28','2022-10-20 09:04:28','530',2349517.60,2349517.60,'530','2022-10-19 14:33:59','614','2022-10-19 14:39:58',10,0),('1','113',258186,'AFTERNOON SHIFT','2022-10-19','2022-10-19 21:43:29','2022-10-20 21:43:29','530',5639879.00,5639879.00,'530','2022-10-19 21:46:27','614','2022-10-19 22:01:53',10,0),('1','113',258187,'MORNING SHIFT','2022-10-20','2022-10-20 12:06:43','2022-10-21 12:06:43','530',0.00,0.00,'530','2022-10-20 12:08:38','614','2022-10-20 16:03:07',10,0),('1','113',258188,'MORNING SHIFT ','2022-10-20','2022-10-20 17:49:13','2022-10-21 17:49:13','530',4095257.80,4095257.80,'530','2022-10-20 19:08:49','614','2022-10-20 19:54:54',10,0),('1','113',258189,'AFTERNOON SHIFT','2022-10-20','2022-10-20 20:01:53','2022-10-21 20:01:53','530',2706617.00,2706617.00,'530','2022-10-20 22:33:33','614','2022-10-20 22:48:44',10,0),('1','113',258190,'MORNING SHIFT ','2022-10-21','2022-10-21 09:01:42','2022-10-22 09:01:42','530',0.00,0.00,'530','2022-10-21 09:03:41','614','2022-10-21 09:49:07',10,0),('1','113',258191,'MORNING SHIFT','2022-10-21','2022-10-21 13:47:28','2022-10-22 13:47:28','530',3604476.80,3604476.80,'530','2022-10-21 13:52:04','614','2022-10-21 14:31:34',10,0),('1','113',258192,'AFTERNOON SHIFT','2022-10-21','2022-10-21 20:16:22','2022-10-22 20:16:22','530',6196952.40,6196952.40,'530','2022-10-21 22:44:59','614','2022-10-21 23:31:26',10,0),('1','113',258193,'MORNING SHIFT ','2022-10-22','2022-10-22 13:35:37','2022-10-23 13:35:37','530',4675077.00,4675077.00,'530','2022-10-22 13:42:31','614','2022-10-22 14:40:23',10,0),('1','113',258194,'AFTERNOON SHIFT','2022-10-22','2022-10-22 22:26:01','2022-10-23 22:26:01','530',3363844.20,3363844.20,'530','2022-10-22 22:30:31','614','2022-10-22 22:33:08',10,0),('1','113',258195,'MORNING SHIFT','2022-10-23','2022-10-23 14:34:16','2022-10-24 14:34:16','530',1219184.00,1219184.00,'530','2022-10-23 14:35:47','614','2022-10-23 14:36:22',10,0),('1','113',258196,'AFTERNOON ','2022-10-23','2022-10-23 21:27:16','2022-10-24 21:27:16','530',3275576.00,3275576.00,'530','2022-10-23 21:30:19','614','2022-10-23 21:49:00',10,0),('1','113',258197,'MORNING SHIFT ','2022-10-24','2022-10-24 14:55:47','2022-10-25 14:55:47','530',2255942.00,2255942.00,'530','2022-10-24 15:02:54','614','2022-10-24 15:09:38',10,0),('1','113',258198,'AFTERNOON SHIFT','2022-10-24','2022-10-24 22:14:36','2022-10-25 22:14:36','530',2410320.00,2410320.00,'530','2022-10-24 22:15:48','614','2022-10-24 22:26:08',10,0),('1','113',258199,'MORNING SHIFT','2022-10-25','2022-10-25 14:44:48','2022-10-26 14:44:48','530',6344629.40,6344629.40,'530','2022-10-25 14:48:10','614','2022-10-25 14:53:26',10,0),('1','113',258200,'AFTERNOON SHIFT','2022-10-25','2022-10-25 21:30:53','2022-10-26 21:30:53','530',3562846.40,3562846.40,'530','2022-10-25 21:51:12','614','2022-10-26 06:26:29',10,0),('1','113',258201,'AFTERNOON SHIFT','2022-10-26','2022-10-26 15:09:46','2022-10-27 15:09:46','530',1968548.40,1968548.40,'530','2022-10-26 15:13:10','614','2022-10-26 15:46:03',10,0),('1','113',258202,'MORNING SHIFT ','2022-10-27','2022-10-27 14:38:10','2022-10-28 14:38:10','530',1111149.00,1111149.00,'530','2022-10-27 15:03:32','614','2022-10-27 15:09:36',10,0),('1','113',258203,'AFTERNOON SHIFT','2022-10-27','2022-10-27 20:12:52','2022-10-28 20:12:52','530',1628044.20,1628044.20,'530','2022-10-27 20:15:30','614','2022-10-27 22:07:09',10,0),('1','113',258204,'MORNING SHIFT ','2022-10-28','2022-10-28 13:23:08','2022-10-29 13:23:08','530',2421073.80,2421073.80,'530','2022-10-28 13:26:05','614','2022-10-28 16:57:09',10,0),('1','113',258205,'AFTERNOON SHIFT','2022-10-28','2022-10-28 21:01:14','2022-10-29 21:01:14','530',1758587.40,1758587.40,'530','2022-10-28 21:03:49','614','2022-10-28 21:48:32',10,0),('1','113',258206,'MORNING SHIFT ','2022-10-29','2022-10-29 14:38:49','2022-10-30 14:38:49','530',2118646.80,2118646.80,'530','2022-10-29 14:41:30','614','2022-10-29 14:53:48',10,0),('1','113',258207,'MORNING SHIFT','2022-10-30','2022-10-30 14:52:17','2022-10-31 14:52:17','530',7857727.60,7857727.60,'530','2022-10-30 14:57:43','614','2022-10-30 17:42:40',10,0),('1','113',258208,'AFTERNOON SHIFT','2022-10-30','2022-10-30 20:31:02','2022-10-31 20:31:02','530',4336169.20,4336169.20,'530','2022-10-30 20:35:22','614','2022-10-30 21:13:56',10,0),('1','113',258209,'MORNING SHIFT ','2022-10-31','2022-10-31 14:49:00','2022-11-01 14:49:00','530',4523439.00,4523439.00,'530','2022-10-31 15:12:51','614','2022-10-31 15:14:46',10,0),('1','113',258210,'AFTERNOON SHIFT','2022-10-31','2022-10-31 20:47:23','2022-11-01 20:47:23','530',2975617.60,2975617.60,'530','2022-10-31 20:49:58','614','2022-10-31 22:39:37',10,0),('1','113',258211,'MORNING SHIFT ','2022-11-01','2022-11-01 16:36:53','2022-11-02 16:36:53','530',3130358.00,3130358.00,'530','2022-11-01 16:38:00','614','2022-11-01 17:55:10',10,0),('1','113',258212,'AFTERNOON SHIFT','2022-11-01','2022-11-01 21:14:20','2022-11-02 21:14:20','530',2145762.20,2145762.20,'530','2022-11-01 21:57:29','614','2022-11-01 23:09:51',10,0),('1','113',258213,'MORNING SHIFT ','2022-11-02','2022-11-02 15:00:57','2022-11-03 15:00:57','530',3358512.00,3358512.00,'530','2022-11-02 15:01:49','614','2022-11-02 15:26:17',10,0),('1','113',258214,'AFTERNOON SHIFT','2022-11-02','2022-11-02 21:01:06','2022-11-03 21:01:06','530',4352360.00,4352360.00,'530','2022-11-02 21:02:37','614','2022-11-03 07:14:32',10,0),('1','113',258215,'MORNING SHIFT ','2022-11-03','2022-11-03 14:20:18','2022-11-04 14:20:18','530',2392920.00,2392920.00,'530','2022-11-03 14:20:59','614','2022-11-03 15:33:32',10,0),('1','113',258216,'AFTERNOON SHIFT','2022-11-03','2022-11-03 20:18:54','2022-11-04 20:18:54','530',2471424.00,2471424.00,'530','2022-11-03 20:20:39','614','2022-11-04 01:30:01',10,0),('1','113',258217,'MORNING SHIFT ','2022-11-04','2022-11-04 14:03:10','2022-11-05 14:03:10','530',1177520.00,1177520.00,'530','2022-11-04 14:03:53','614','2022-11-04 17:02:58',10,0),('1','113',258218,'AFTERNOON SHIFT','2022-11-04','2022-11-04 20:24:19','2022-11-05 20:24:19','530',1325312.00,1325312.00,'530','2022-11-04 20:25:47','614','2022-11-05 00:17:18',10,0),('1','113',258219,'MORNING SHIFT ','2022-11-05','2022-11-05 15:09:04','2022-11-06 15:09:04','530',4639664.00,4639664.00,'530','2022-11-05 15:09:45','614','2022-11-05 15:35:47',10,0),('1','113',258220,'AFTERNOON SHIFT','2022-11-05','2022-11-05 20:29:21','2022-11-06 20:29:21','530',3746736.00,3746736.00,'530','2022-11-05 20:31:01','614','2022-11-05 23:29:44',10,0),('1','113',258221,'MORNING SHIFT','2022-11-06','2022-11-06 15:09:44','2022-11-07 15:09:44','530',2653128.00,2653128.00,'530','2022-11-06 15:10:27','614','2022-11-06 17:33:00',10,0),('1','113',258222,'AFTERNOON SHIFT','2022-11-06','2022-11-06 17:35:17','2022-11-07 17:35:17','530',2728328.00,2728328.00,'530','2022-11-06 21:53:57','614','2022-11-06 23:55:36',10,0),('1','113',258223,'MORNING SHIFT ','2022-11-07','2022-11-07 13:59:52','2022-11-08 13:59:52','530',2112264.40,2112264.40,'530','2022-11-07 19:17:54','614','2022-11-07 23:15:49',10,0),('1','113',258224,'AFTERNOON SHIFT','2022-11-07','2022-11-07 23:25:59','2022-11-08 23:25:59','530',3037112.00,3037112.00,'530','2022-11-07 23:27:15','614','2022-11-08 00:01:09',10,0),('1','113',258225,'MORNING SHIFT ','2022-11-08','2022-11-08 14:35:53','2022-11-09 14:35:53','530',4244881.60,4244881.60,'530','2022-11-08 14:38:23','614','2022-11-08 16:31:35',10,0),('1','113',258226,'AFTERNOON SHIFT ','2022-11-08','2022-11-09 15:10:26','2022-11-10 15:10:26','530',9573337.00,9573337.00,'530','2022-11-09 15:12:33','975','2022-11-09 16:08:14',10,0),('1','113',258227,'MORNING SHIFT ','2022-11-09','2022-11-09 17:15:10','2022-11-10 17:15:10','530',7807158.20,7807158.20,'530','2022-11-09 17:44:52','614','2022-11-09 17:56:50',10,0),('1','113',258228,'AFTERNOON SHIFT','2022-11-09','2022-11-09 22:51:50','2022-11-10 22:51:50','530',8203040.35,8203040.35,'530','2022-11-09 22:54:25','614','2022-11-09 23:29:26',10,0),('1','113',258229,'MORNING SHIFT','2022-11-10','2022-11-10 14:53:49','2022-11-11 14:53:49','530',7312335.20,7312335.20,'530','2022-11-10 14:56:26','614','2022-11-10 15:17:13',10,0),('1','113',258230,'AFTERNOON SHIFT','2022-11-10','2022-11-10 20:42:17','2022-11-11 20:42:17','530',0.00,0.00,'975','2022-11-11 07:09:43','975','2022-11-11 07:10:11',10,0),('1','113',258231,'AFTERNOON SHIFT','2022-11-10','2022-11-11 07:16:41','2022-11-12 07:16:41','530',6626498.50,6626498.50,'530','2022-11-11 09:01:36','614','2022-11-11 09:22:04',10,0),('1','113',258232,'MORNING SHIFT','2022-11-11','2022-11-11 15:08:18','2022-11-12 15:08:18','530',5147421.10,5147421.10,'530','2022-11-11 15:12:20','614','2022-11-11 16:50:42',10,0),('1','113',258233,'AFTERNOON SHIFT','2022-11-11','2022-11-11 21:00:05','2022-11-12 21:00:05','530',5119774.50,5119774.50,'530','2022-11-11 21:03:13','614','2022-11-11 23:55:41',10,0),('1','113',258234,'MORNING SHIFT ','2022-11-12','2022-11-12 14:55:02','2022-11-13 14:55:02','530',4355761.25,4355761.25,'530','2022-11-12 14:57:06','614','2022-11-13 07:52:18',10,0),('1','113',258235,'AFTERNOON SHIFT','2022-11-12','2022-11-13 09:16:47','2022-11-14 09:16:47','530',3895130.10,3895130.10,'530','2022-11-13 09:20:59','614','2022-11-13 15:06:33',10,0),('1','113',258236,'MORNING SHIFT ','2022-11-13','2022-11-13 15:19:01','2022-11-14 15:19:01','530',2986920.40,2986920.40,'530','2022-11-13 15:21:03','614','2022-11-14 00:10:21',10,0),('1','113',258237,'AFTERNOON SHIFT','2022-11-13','2022-11-14 05:19:01','2022-11-15 05:19:01','530',3814433.05,3814433.05,'530','2022-11-14 05:23:43','614','2022-11-14 08:11:18',10,0),('1','113',258238,'MORNING SHIFT','2022-11-14','2022-11-14 14:26:46','2022-11-15 14:26:46','530',3391473.30,3391473.30,'530','2022-11-14 14:29:26','614','2022-11-14 14:52:10',10,0),('1','113',258239,'AFTERNOON SHIFT','2022-11-14','2022-11-15 08:27:37','2022-11-16 08:27:37','530',3756454.40,3756454.40,'530','2022-11-15 08:29:45','614','2022-11-15 10:46:49',10,0),('1','113',258240,'MORNING SHIFT ','2022-11-15','2022-11-15 15:02:24','2022-11-16 15:02:24','530',1433099.30,1433099.30,'530','2022-11-15 15:04:59','614','2022-11-15 19:00:03',10,0),('1','113',258241,'AFTERNOON SHIFT','2022-11-15','2022-11-15 21:45:24','2022-11-16 21:45:24','530',4353086.70,4353086.70,'530','2022-11-15 21:50:55','614','2022-11-15 22:26:05',10,0),('1','113',258242,'MORNING SHIFT','2022-11-16','2022-11-16 14:17:08','2022-11-17 14:17:08','530',0.00,0.00,'975','2022-11-16 14:31:16','975','2022-11-16 14:31:54',10,0),('1','113',258243,'MORNING SHIFT ','2022-11-16','2022-11-16 14:50:28','2022-11-17 14:50:28','530',2499043.15,2499043.15,'530','2022-11-16 14:59:05','614','2022-11-16 17:09:39',10,0),('1','113',258244,'AFTERNOON SHIFT','2022-11-16','2022-11-16 20:30:53','2022-11-17 20:30:53','530',2939059.75,2939059.75,'530','2022-11-16 20:32:47','614','2022-11-16 20:36:03',10,0),('1','113',258245,'MORNING SHIFT ','2022-11-17','2022-11-17 14:45:31','2022-11-18 14:45:31','530',3018757.65,3018757.65,'530','2022-11-17 14:49:10','975','2022-11-17 17:26:37',10,0),('1','113',258246,'AFTERNOON SHIFT','2022-11-17','2022-11-17 19:52:14','2022-11-18 19:52:14','530',4257608.75,4257608.75,'530','2022-11-17 19:55:31','614','2022-11-17 20:47:14',10,0),('1','113',258247,'MORNING SHIFT ','2022-11-18','2022-11-18 13:24:24','2022-11-19 13:24:24','530',3819293.00,3819293.00,'530','2022-11-18 15:30:35','614','2022-11-18 15:52:25',10,0),('1','113',258248,'AFTERNOON SHIFT','2022-11-18','2022-11-18 21:19:15','2022-11-19 21:19:15','530',3830894.35,3830894.35,'530','2022-11-18 21:38:31','614','2022-11-18 23:08:31',10,0),('1','113',258249,'MORNING SHIFT ','2022-11-19','2022-11-19 13:26:36','2022-11-20 13:26:36','530',1277395.40,1277395.40,'530','2022-11-19 13:29:04','975','2022-11-19 13:29:49',10,0),('1','113',258250,'AFTERNOON SHIFT','2022-11-19','2022-11-19 21:25:47','2022-11-20 21:25:47','530',679012.90,679012.90,'530','2022-11-19 21:27:26','614','2022-11-19 23:45:05',10,0),('1','113',258251,'AFTERNOON SHIFT','2022-11-20','2022-11-21 10:01:50','2022-11-22 10:01:50','530',932120.65,932120.65,'530','2022-11-21 10:03:43','614','2022-11-21 11:21:52',10,0),('1','113',258252,'AFTERNOON SHIFT','2022-11-22','2022-11-23 08:20:18','2022-11-24 08:20:18','530',1140283.20,1140283.20,'530','2022-11-23 08:21:45','975','2022-11-23 12:31:43',10,0),('1','113',258253,'MORNING SHIFT ','2022-11-23','2022-11-23 14:52:20','2022-11-24 14:52:20','530',2646899.30,2646899.30,'530','2022-11-23 14:55:08','614','2022-11-23 23:37:32',10,0),('1','113',258254,'AFTERNOON SHIFT ','2022-11-23','2022-11-24 14:34:40','2022-11-25 14:34:40','530',2558127.60,2558127.60,'530','2022-11-24 14:35:38','614','2022-11-24 14:38:24',10,0),('1','113',258255,'MORNING SHIFT','2022-11-24','2022-11-24 15:07:20','2022-11-25 15:07:20','530',735257.35,735257.35,'530','2022-11-24 15:19:55','614','2022-11-24 17:27:43',10,0),('1','113',258256,'AFTERNOON SHIFT','2022-11-24','2022-11-24 20:21:30','2022-11-25 20:21:30','530',1611320.50,1611320.50,'530','2022-11-24 20:22:43','614','2022-11-24 23:30:03',10,0),('1','113',258257,'MORNING SHIFT ','2022-11-25','2022-11-25 15:02:11','2022-11-26 15:02:11','530',1328531.20,1328531.20,'530','2022-11-25 15:04:37','614','2022-11-25 15:10:35',10,0),('1','113',258258,'AFTERNOON SHIFT','2022-11-25','2022-11-25 20:17:41','2022-11-26 20:17:41','530',1883792.90,1883792.90,'530','2022-11-26 11:20:06','614','2022-11-26 16:33:04',10,0),('1','113',258259,'MORNING SHIFT ','2022-11-26','2022-11-26 21:05:58','2022-11-27 21:05:58','530',2309267.50,2309267.50,'530','2022-11-26 21:07:14','614','2022-11-27 13:32:01',10,0),('1','113',258260,'AFTERNOON SHIFT','2022-11-26','2022-11-27 13:44:40','2022-11-28 13:44:40','530',868263.00,868263.00,'530','2022-11-27 13:48:55','614','2022-11-27 14:16:37',10,0),('1','113',258261,'MORNING SHIFT ','2022-11-27','2022-11-27 14:23:21','2022-11-28 14:23:21','530',2338541.60,2338541.60,'530','2022-11-27 14:24:29','614','2022-11-27 21:58:55',10,0),('1','113',258262,'AFTERNOON SHIFT','2022-11-27','2022-11-28 06:37:50','2022-11-29 06:37:50','530',578061.80,578061.80,'530','2022-11-28 06:39:46','614','2022-11-28 07:08:15',10,0),('1','113',258263,'MORNING SHIFT','2022-11-28','2022-11-28 13:27:38','2022-11-29 13:27:38','530',1275220.30,1275220.30,'530','2022-11-28 13:34:43','614','2022-11-28 18:03:01',10,0),('1','113',258264,'AFTERNOON SHIFT','2022-11-28','2022-11-28 20:54:59','2022-11-29 20:54:59','530',4047569.70,4047569.70,'530','2022-11-28 21:00:53','614','2022-11-29 12:19:52',10,0),('1','113',258265,'MORNING SHIFT 1','2022-11-29','2022-11-29 14:58:27','2022-11-30 14:58:27','530',1024344.50,1024344.50,'530','2022-11-29 14:59:16','614','2022-11-29 16:35:27',10,0),('1','113',258266,'MORNING SHIFT  2','2022-11-29','2022-11-29 17:13:46','2022-11-30 17:13:46','530',499010.40,499010.40,'530','2022-11-29 23:02:14','975','2022-11-30 11:30:47',10,0),('1','113',258267,'AFTERNOON SHIFT','2022-11-29','2022-11-30 11:36:42','2022-12-01 11:36:42','530',1209003.60,1209003.60,'530','2022-11-30 11:43:23','614','2022-11-30 12:44:35',10,0),('1','113',258268,'MORNING SHIFT ','2022-11-30','2022-11-30 15:00:48','2022-12-01 15:00:48','530',3469626.30,3469626.30,'530','2022-11-30 15:07:03','614','2022-11-30 15:38:45',10,0),('1','113',258269,'AFTERNOON SHIFT','2022-11-30','2022-12-01 08:37:39','2022-12-02 08:37:39','530',2494184.70,2494184.70,'530','2022-12-01 08:40:19','975','2022-12-01 13:46:59',10,0),('1','113',258270,'MORNING SHIFT','2022-12-01','2022-12-01 15:40:15','2022-12-02 15:40:15','530',5893719.30,5893719.30,'530','2022-12-01 15:42:50','975','2022-12-02 10:41:28',10,0),('1','113',258271,'AFTERNOON SHIFT','2022-12-01','2022-12-02 11:25:25','2022-12-03 11:25:25','530',1431901.80,1431901.80,'530','2022-12-02 11:34:00','975','2022-12-02 15:40:38',10,0),('1','113',258272,'MORNING SHIFT','2022-12-02','2022-12-02 16:59:24','2022-12-03 16:59:24','530',3384490.20,3384490.20,'530','2022-12-02 17:03:42','975','2022-12-03 13:46:31',10,0),('1','113',258273,'MORNING SHIFT','2022-12-03','2022-12-03 14:20:58','2022-12-04 14:20:58','530',3257257.50,3257257.50,'530','2022-12-03 14:24:31','975','2022-12-03 14:38:34',10,0),('1','113',258274,'AFTERNOON SHIFT','2022-12-03','2022-12-03 20:51:50','2022-12-04 20:51:50','530',221020.80,221020.80,'530','2022-12-04 10:41:24','975','2022-12-04 12:27:57',10,0),('1','113',258275,'MORNING SHIFT','2022-12-04','2022-12-04 15:30:36','2022-12-05 15:30:36','530',2604306.30,2604306.30,'530','2022-12-04 18:50:15','975','2022-12-05 05:56:02',10,0),('1','113',258276,'AFTERNOON SHIFT ','2022-12-04','2022-12-05 18:02:08','2022-12-06 18:02:08','530',1112047.20,1112047.20,'530','2022-12-05 18:03:35','975','2022-12-06 08:28:20',10,0),('1','113',258277,'MORNING SHIFT ','2022-12-05','2022-12-06 08:28:41','2022-12-07 08:28:41','530',505128.80,505128.80,'530','2022-12-06 08:32:55','975','2022-12-06 08:34:43',10,0),('1','113',258278,'AFTERNOON SHIFT','2022-12-06','2022-12-06 08:37:25','2022-12-07 08:37:25','530',956964.80,956964.80,'530','2022-12-06 08:38:35','975','2022-12-06 08:41:21',10,0),('1','113',258279,'MORNING SHIFT ','2022-12-06','2022-12-06 14:43:06','2022-12-07 14:43:06','530',1065829.60,1065829.60,'530','2022-12-06 14:44:24','975','2022-12-06 15:24:08',10,0),('1','113',258280,'AFTERNOON SHIFT','2022-12-06','2022-12-06 23:00:38','2022-12-07 23:00:38','530',67724.80,67724.80,'530','2022-12-06 23:03:29','975','2022-12-07 11:13:17',10,0),('1','113',258281,'AFTERNOON SHIFT 2','2022-12-07','2022-12-07 12:16:45','2022-12-08 12:16:45','530',0.00,0.00,'975','2022-12-07 14:02:57','975','2022-12-07 14:03:11',10,0),('1','113',258282,'AFTERNOON SHIFT 2','2022-12-06','2022-12-07 14:03:33','2022-12-08 14:03:33','530',2932431.60,2932431.60,'530','2022-12-07 14:04:45','975','2022-12-07 14:06:45',10,0),('1','113',258283,'MORNING SHIFT','2022-12-07','2022-12-07 15:43:35','2022-12-08 15:43:35','530',1825509.00,1825509.00,'530','2022-12-07 15:46:14','975','2022-12-08 10:26:17',10,0),('1','113',258284,'AFTERNOON SHIFT','2022-12-07','2022-12-08 10:48:13','2022-12-09 10:48:13','530',1866110.40,1866110.40,'530','2022-12-08 10:53:43','975','2022-12-08 15:31:26',10,0),('1','113',258285,'MORNING SHIFT ','2022-12-08','2022-12-08 20:16:19','2022-12-09 20:16:19','530',4962900.80,4962900.80,'530','2022-12-08 20:19:01','975','2022-12-09 09:07:08',10,0),('1','113',258286,'AFTERNOON SHIFT','2022-12-08','2022-12-09 09:23:15','2022-12-10 09:23:15','530',1390922.00,1390922.00,'530','2022-12-09 09:25:09','975','2022-12-09 18:04:19',10,0),('1','113',258287,'MORNING SHIFT ','2022-12-09','2022-12-09 19:16:37','2022-12-10 19:16:37','530',4134509.40,4134509.40,'530','2022-12-10 11:41:37','975','2022-12-10 11:44:57',10,0),('1','113',258288,'AFTERNOON SHIFT','2022-12-09','2022-12-10 11:46:52','2022-12-11 11:46:52','530',1640377.20,1640377.20,'530','2022-12-10 11:47:37','975','2022-12-10 14:08:14',10,0),('1','113',258289,'MORNING SHIFT ','2022-12-10','2022-12-10 15:03:43','2022-12-11 15:03:43','530',5222861.00,5222861.00,'530','2022-12-10 15:06:05','975','2022-12-11 07:54:40',10,0),('1','113',258290,'AFTERNOON SHIFT','2022-12-10','2022-12-11 08:47:11','2022-12-12 08:47:11','530',1194354.00,1194354.00,'530','2022-12-11 08:48:11','975','2022-12-11 08:52:33',10,0),('1','113',258291,'MORNING SHIFT ','2022-12-11','2022-12-11 13:16:50','2022-12-12 13:16:50','530',1791804.00,1791804.00,'530','2022-12-11 13:19:35','975','2022-12-11 15:42:26',10,0),('1','113',258292,'AFTERNOON SHIFT','2022-12-11','2022-12-11 20:50:56','2022-12-12 20:50:56','530',332220.00,332220.00,'530','2022-12-11 20:52:27','975','2022-12-12 08:35:43',10,0),('1','113',258293,'MORNING SHIFT ','2022-12-12','2022-12-12 13:55:59','2022-12-13 13:55:59','530',1124711.20,1124711.20,'530','2022-12-12 14:11:10','975','2022-12-12 20:27:38',10,0),('1','113',258294,'AFTERNOON SHIFT','2022-12-12','2022-12-13 08:19:14','2022-12-14 08:19:14','530',558583.20,558583.20,'530','2022-12-13 08:20:28','975','2022-12-13 10:25:18',10,0),('1','113',258295,'MORNING SHIFT','2022-12-13','2022-12-13 15:13:35','2022-12-14 15:13:35','530',2485854.00,2485854.00,'530','2022-12-13 15:14:24','975','2022-12-13 15:36:48',10,0),('1','113',258296,'AFTERNOON SHIFT','2022-12-13','2022-12-13 20:57:08','2022-12-14 20:57:08','530',1904609.20,1904609.20,'530','2022-12-13 20:59:45','975','2022-12-14 12:50:40',10,0),('1','113',258297,'MORNING SHIFT ','2022-12-14','2022-12-14 15:00:56','2022-12-15 15:00:56','530',2209762.80,2209762.80,'530','2022-12-14 15:02:49','975','2022-12-14 16:39:12',10,0),('1','113',258298,'MORNING SHIFT  2','2022-12-14','2022-12-14 20:54:25','2022-12-15 20:54:25','530',454608.00,454608.00,'530','2022-12-15 07:19:02','975','2022-12-15 11:01:12',10,0),('1','113',258299,'AFTERNOON SHIFT ','2022-12-14','2022-12-15 11:09:48','2022-12-16 11:09:48','530',2227799.60,2227799.60,'530','2022-12-15 11:17:45','975','2022-12-15 17:31:12',10,0),('1','113',258300,'MORNING SHIFT ','2022-12-15','2022-12-15 17:42:49','2022-12-16 17:42:49','530',12178105.40,12178105.40,'530','2022-12-15 17:45:18','975','2022-12-15 17:54:44',10,0),('1','113',258301,'AFTERNOON SHIFT','2022-12-15','2022-12-15 23:01:44','2022-12-16 23:01:44','530',4271751.60,4271751.60,'530','2022-12-16 11:35:13','975','2022-12-16 14:10:39',10,0),('1','113',258302,'MORNING SHIFT ','2022-12-16','2022-12-16 16:08:48','2022-12-17 16:08:48','530',2303353.80,2303353.80,'530','2022-12-16 16:11:17','975','2022-12-16 20:23:33',10,0),('1','113',258303,'AFTERNOON SHIFT','2022-12-16','2022-12-16 20:47:15','2022-12-17 20:47:15','530',50989.40,50989.40,'530','2022-12-16 20:48:36','975','2022-12-17 12:54:24',10,0),('1','113',258304,'MORNING SHIFT ','2022-12-17','2022-12-17 15:46:39','2022-12-18 15:46:39','530',4459908.60,4459908.60,'530','2022-12-17 16:03:03','975','2022-12-17 19:19:06',10,0),('1','113',258305,'AFTERNOON SHIFT','2022-12-17','2022-12-17 22:17:35','2022-12-18 22:17:35','530',6629691.80,6629691.80,'530','2022-12-17 22:19:11','975','2022-12-19 07:29:34',10,0),('1','113',258306,'MORNING SHIFT ','2022-12-19','2022-12-19 07:40:56','2022-12-20 07:40:56','530',0.00,0.00,'975','2022-12-19 07:44:13','975','2022-12-19 07:44:32',10,0),('1','113',258307,'MORNING SHIFT','2022-12-18','2022-12-19 07:45:37','2022-12-20 07:45:37','530',6362566.80,6362566.80,'530','2022-12-19 07:47:27','975','2022-12-19 07:48:39',10,0),('1','113',258308,'AFTERNOON SHIFT','2022-12-18','2022-12-19 07:50:16','2022-12-20 07:50:16','530',3087660.80,3087660.80,'530','2022-12-19 07:51:27','975','2022-12-19 07:52:34',10,0),('1','113',258309,'MORNING SHIFT ','2022-12-19','2022-12-19 14:48:07','2022-12-20 14:48:07','530',5884247.60,5884247.60,'530','2022-12-19 14:50:52','975','2022-12-19 18:34:27',10,0),('1','113',258310,'AFTERNOON SHIFT','2022-12-19','2022-12-19 20:18:37','2022-12-20 20:18:37','530',4987918.20,4987918.20,'530','2022-12-19 20:23:27','975','2022-12-20 11:03:27',10,0),('1','113',258311,'MORNING SHIFT ','2022-12-20','2022-12-20 13:02:42','2022-12-21 13:02:42','530',0.00,0.00,'530','2022-12-20 13:04:42','975','2022-12-20 17:30:32',10,0),('1','113',258312,'MORNING SHIFT ','2022-12-20','2022-12-20 18:12:42','2022-12-21 18:12:42','530',3636568.20,3636568.20,'530','2022-12-20 18:31:30','975','2022-12-21 06:18:17',10,0),('1','113',258313,'AFTERNOON SHIFT','2022-12-20','2022-12-21 09:15:08','2022-12-22 09:15:08','530',780788.80,780788.80,'530','2022-12-21 09:17:17','975','2022-12-21 10:23:43',10,0),('1','113',258314,'AFTERNOON SHIFT','2022-12-20','2022-12-21 10:29:30','2022-12-22 10:29:30','530',0.00,0.00,'530','2022-12-21 10:31:33','975','2022-12-21 10:32:47',10,0),('1','113',258315,'MORNING SHIFT','2022-12-21','2022-12-21 14:48:30','2022-12-22 14:48:30','530',2260867.80,2260867.80,'530','2022-12-21 14:51:24','975','2022-12-21 19:11:21',10,0),('1','113',258316,'AFTERNOON SHIFT','2022-12-21','2022-12-21 22:51:35','2022-12-22 22:51:35','530',5403093.00,5403093.00,'530','2022-12-21 22:55:32','975','2022-12-22 15:25:05',10,0),('1','113',258317,'MORNING SHIFT ','2022-12-22','2022-12-22 15:39:13','2022-12-23 15:39:13','530',8180017.40,8180017.40,'530','2022-12-22 15:42:12','975','2022-12-22 19:54:41',10,0),('1','113',258318,'AFTERNOON SHIFT','2022-12-22','2022-12-22 20:46:16','2022-12-23 20:46:16','530',7107449.50,7107449.50,'530','2022-12-22 20:48:43','975','2022-12-23 11:54:55',10,0),('1','113',258319,'MORNING SHIFT ','2022-12-23','2022-12-23 15:07:24','2022-12-24 15:07:24','530',5783260.10,5783260.10,'530','2022-12-23 15:11:19','975','2022-12-24 09:58:48',10,0),('1','113',258320,'AFTERNOON SHIFT','2022-12-23','2022-12-24 10:31:30','2022-12-25 10:31:30','530',11730629.30,11730629.30,'530','2022-12-24 10:34:31','975','2022-12-24 13:09:52',10,0),('1','113',258321,'MORNING SHIFT','2022-12-24','2022-12-24 16:42:27','2022-12-25 16:42:27','530',5922648.55,5922648.55,'530','2022-12-24 16:45:07','975','2022-12-25 07:04:16',10,0),('1','113',258322,'AFTERNOON SHIFT','2022-12-24','2022-12-25 10:13:44','2022-12-26 10:13:44','530',4386246.20,4386246.20,'530','2022-12-25 10:28:42','975','2022-12-26 08:15:43',10,0),('1','113',258323,'MORNING SHIFT ','2022-12-25','2022-12-26 08:29:40','2022-12-27 08:29:40','530',5087346.85,5087346.85,'530','2022-12-26 08:34:02','975','2022-12-26 08:46:35',10,0),('1','113',258324,'AFTERNOON SHIFT ','2022-12-25','2022-12-26 10:54:01','2022-12-27 10:54:01','530',3899269.35,3899269.35,'530','2022-12-26 10:58:45','975','2022-12-26 18:47:45',10,0),('1','113',258325,'MORNING SHIFT ','2022-12-26','2022-12-26 19:43:44','2022-12-27 19:43:44','530',2591439.00,2591439.00,'530','2022-12-26 19:45:42','975','2022-12-27 10:08:13',10,0),('1','113',258326,'AFTERNOON SHIFT ','2022-12-26','2022-12-27 10:16:26','2022-12-28 10:16:26','530',4572565.60,4572565.60,'530','2022-12-27 10:18:28','975','2022-12-27 10:20:39',10,0),('1','113',258327,'AFTERNOON SHIFT ','2022-12-26','2022-12-27 10:27:43','2022-12-28 10:27:43','530',0.00,0.00,'530','2022-12-27 10:45:48','975','2022-12-27 13:11:45',10,0),('1','113',258328,'MORNING SHIFT','2022-12-27','2022-12-27 13:40:56','2022-12-28 13:40:56','530',7023438.70,7023438.70,'530','2022-12-27 13:43:54','975','2022-12-27 14:01:49',10,0),('1','113',258329,'AFTERNOON SHIFT','2022-12-27','2022-12-28 06:47:02','2022-12-29 06:47:02','530',4994086.65,4994086.65,'530','2022-12-28 06:55:12','975','2022-12-28 11:36:31',10,0),('1','113',258330,'MORNING SHIFT','2022-12-28','2022-12-28 13:28:27','2022-12-29 13:28:27','530',4430533.45,4430533.45,'530','2022-12-28 13:57:05','975','2022-12-28 15:47:03',10,0),('1','113',258331,'AFTERNOON SHIFT','2022-12-28','2022-12-28 23:56:28','2022-12-29 23:56:28','530',1259967.50,1259967.50,'530','2022-12-28 23:58:04','975','2022-12-29 12:31:31',10,0),('1','113',258332,'MORNING SHIFT ','2022-12-29','2022-12-29 14:53:26','2022-12-30 14:53:26','530',5817417.95,5817417.95,'530','2022-12-29 14:56:15','975','2022-12-29 16:50:55',10,0),('1','113',258333,'AFTERNOON SHIFT','2022-12-29','2022-12-29 22:43:29','2022-12-30 22:43:29','530',3047820.45,3047820.45,'530','2022-12-29 22:45:09','975','2022-12-30 11:45:40',10,0),('1','113',258334,'MORNING SHIFT ','2022-12-30','2022-12-30 15:48:02','2022-12-31 15:48:02','530',6122219.00,6122219.00,'530','2022-12-30 15:50:50','975','2022-12-30 19:37:52',10,0),('1','113',258335,'AFTERNOON SHIFT','2022-12-30','2022-12-30 22:50:06','2022-12-31 22:50:06','530',3424888.90,3424888.90,'530','2022-12-30 22:51:52','975','2022-12-31 10:50:13',10,0),('1','113',258336,'MORNING SHIFT ','2022-12-31','2022-12-31 15:02:56','2023-01-01 15:02:56','530',5216164.60,5216164.60,'530','2022-12-31 15:05:23','975','2022-12-31 16:58:55',10,0),('1','113',258337,'AFTERNOON SHIFT','2022-12-31','2022-12-31 20:34:17','2023-01-01 20:34:17','530',5073855.65,5073855.65,'530','2022-12-31 20:35:28','975','2023-01-01 12:36:24',10,0),('1','113',258338,'MORNING SHIFT','2023-01-01','2023-01-01 15:30:00','2023-01-02 15:30:00','530',2576318.75,2576318.75,'530','2023-01-01 15:32:28','975','2023-01-02 10:51:33',10,0),('1','113',258339,'AFTERNOON SHIFT','2023-01-01','2023-01-02 11:50:54','2023-01-03 11:50:54','530',4818475.35,4818475.35,'530','2023-01-02 11:59:37','975','2023-01-02 13:01:14',10,0),('1','113',258340,'MORNING SHIFT','2023-01-02','2023-01-02 15:03:35','2023-01-03 15:03:35','530',3187195.05,3187195.05,'530','2023-01-02 15:05:40','975','2023-01-02 16:39:04',10,0),('1','113',258341,'AFTERNOON SHIFT','2023-01-02','2023-01-02 20:33:33','2023-01-03 20:33:33','530',5812142.85,5812142.85,'530','2023-01-02 20:36:18','975','2023-01-03 13:21:12',10,0),('1','113',258342,'MORNING SHIFT','2023-01-03','2023-01-03 14:59:01','2023-01-04 14:59:01','530',3972915.85,3972915.85,'530','2023-01-03 15:08:15','975','2023-01-04 10:35:01',10,0),('1','113',258343,'AFTERNOON SHIFT','2023-01-03','2023-01-04 10:59:39','2023-01-05 10:59:39','530',486405.35,486405.35,'530','2023-01-04 11:01:22','975','2023-01-04 11:04:20',10,0),('1','113',258344,'MORNING SHIFT','2023-01-04','2023-01-04 13:37:52','2023-01-05 13:37:52','530',2628249.30,2628249.30,'530','2023-01-05 08:35:29','975','2023-01-05 08:36:46',10,0),('1','113',258345,'AFTERNOON SHIFT','2023-01-04','2023-01-05 08:37:27','2023-01-06 08:37:27','530',8911512.60,8911512.60,'530','2023-01-05 08:40:35','975','2023-01-05 09:05:54',10,0),('1','113',258346,'MORNING SHIFT','2023-01-05','2023-01-05 14:50:05','2023-01-06 14:50:05','530',6390776.65,6390776.65,'530','2023-01-05 14:52:18','975','2023-01-05 17:01:45',10,0),('1','113',258347,'AFTERNOON SHIFT','2023-01-05','2023-01-05 23:21:51','2023-01-06 23:21:51','530',5939928.00,5939928.00,'530','2023-01-05 23:24:51','975','2023-01-06 10:40:14',10,0),('1','113',258348,'MORNING SHIFT ','2023-01-06','2023-01-06 15:53:27','2023-01-07 15:53:27','530',5336558.05,5336558.05,'530','2023-01-06 15:54:52','975','2023-01-07 10:32:59',10,0),('1','113',258349,'AFTERNOON SHIFT','2023-01-06','2023-01-07 11:20:04','2023-01-08 11:20:04','530',6189603.80,6189603.80,'530','2023-01-07 11:29:45','975','2023-01-07 12:07:18',10,0),('1','113',258350,'MORNING SHIFT','2023-01-07','2023-01-07 14:49:26','2023-01-08 14:49:26','530',3704587.80,3704587.80,'530','2023-01-07 14:50:21','975','2023-01-08 10:05:05',10,0),('1','113',258351,'AFTERNOON SHIFT','2023-01-07','2023-01-08 11:22:12','2023-01-09 11:22:12','530',5616681.50,5616681.50,'530','2023-01-08 11:24:02','975','2023-01-09 09:34:57',10,0),('1','113',258352,'MORNING SHIFT ','2023-01-08','2023-01-09 09:35:34','2023-01-10 09:35:34','530',3508110.45,3508110.45,'530','2023-01-09 09:39:41','975','2023-01-09 09:40:25',10,0),('1','113',258353,'AFTERNOON SHIFT','2023-01-08','2023-01-09 09:40:57','2023-01-10 09:40:57','530',1293781.85,1293781.85,'530','2023-01-09 09:42:17','975','2023-01-09 09:44:17',10,0),('1','113',258354,'MORNING SHIFT ','2023-01-09','2023-01-09 14:28:43','2023-01-10 14:28:43','530',3754780.00,3754780.00,'530','2023-01-09 14:31:51','975','2023-01-09 17:08:07',10,0),('1','113',258355,'AFTERNOON SHIFT','2023-01-10','2023-01-10 23:03:18','2023-01-11 23:03:18','530',5348761.45,5348761.45,'530','2023-01-10 23:08:29','975','2023-01-11 10:11:19',10,0),('1','113',258356,'MORNING SHIFT ','2023-01-11','2023-01-11 16:46:05','2023-01-12 16:46:05','530',6284029.65,6284029.65,'530','2023-01-11 16:48:07','975','2023-01-11 18:30:05',10,0),('1','113',258357,'AFTERNOON SHIFT','2023-01-11','2023-01-11 22:22:38','2023-01-12 22:22:38','530',8002350.25,8002350.25,'530','2023-01-11 22:27:44','975','2023-01-12 12:27:59',10,0),('1','113',258358,'MORNING SHIFT','2023-01-12','2023-01-12 13:22:39','2023-01-13 13:22:39','530',7345728.85,7345728.85,'530','2023-01-12 13:27:19','975','2023-01-12 15:23:04',10,0),('1','113',258359,'AFTERNOON SHIFT','2023-01-13','2023-01-13 12:11:34','2023-01-14 12:11:34','530',0.00,0.00,'530','2023-01-13 20:52:30','975','2023-01-13 23:07:19',10,0),('1','113',258360,'AFTERNOON SHIFT','2023-01-12','2023-01-13 23:15:31','2023-01-14 23:15:31','530',2353661.70,2353661.70,'530','2023-01-14 07:28:41','975','2023-01-14 07:51:40',10,0),('1','113',258361,'MORNING SHIFT ','2023-01-13','2023-01-14 07:53:15','2023-01-15 07:53:15','530',7208073.10,7208073.10,'530','2023-01-14 07:55:13','975','2023-01-14 07:55:31',10,0),('1','113',258362,'AFTERNOON SHIFT','2023-01-13','2023-01-14 07:56:11','2023-01-15 07:56:11','530',7876552.25,7876552.25,'530','2023-01-14 08:00:27','975','2023-01-14 10:58:48',10,0),('1','113',258363,'MORNING SHIFT ','2023-01-14','2023-01-14 13:30:52','2023-01-15 13:30:52','530',8201341.85,8201341.85,'530','2023-01-14 13:33:40','975','2023-01-14 13:38:59',10,0),('1','113',258364,'AFTERNOON SHIFT','2023-01-14','2023-01-14 17:02:47','2023-01-15 17:02:47','530',5225871.60,5225871.60,'530','2023-01-14 21:21:52','975','2023-01-15 12:36:03',10,0),('1','113',258365,'MORNING SHIFT ','2023-01-15','2023-01-15 15:42:35','2023-01-16 15:42:35','530',7200531.65,7200531.65,'530','2023-01-15 15:44:13','975','2023-01-16 09:23:59',10,0),('1','113',258366,'AFTERNOON SHIFT ','2023-01-15','2023-01-16 09:27:21','2023-01-17 09:27:21','530',3649166.85,3649166.85,'530','2023-01-16 09:29:13','734','2023-01-16 12:58:33',10,0),('1','113',258367,'MORNING SHIFT ','2023-01-16','2023-01-16 15:59:45','2023-01-17 15:59:45','530',3008514.40,3008514.40,'530','2023-01-16 16:01:37','734','2023-01-16 16:08:47',10,0),('1','113',258368,'AFTERNOON SHIFT','2023-01-16','2023-01-16 22:25:39','2023-01-17 22:25:39','530',1421019.00,1421019.00,'530','2023-01-16 22:26:40','734','2023-01-16 23:53:46',10,0),('1','113',258369,'MORNING SHIFT ','2023-01-17','2023-01-17 14:05:49','2023-01-18 14:05:49','530',3922929.20,3922929.20,'530','2023-01-17 14:08:11','734','2023-01-17 14:49:51',10,0),('1','113',258370,'AFTERNOON SHIFT 1','2023-01-17','2023-01-17 18:34:59','2023-01-18 18:34:59','530',1634333.80,1634333.80,'530','2023-01-17 18:36:08','734','2023-01-17 20:01:28',10,0),('1','113',258371,'MORNING SHIFT 1','2023-01-18','2023-01-18 13:58:36','2023-01-19 13:58:36','530',3785522.10,3785522.10,'530','2023-01-18 14:05:48','734','2023-01-18 14:22:06',10,0),('1','113',258372,'AFTERNOON SHIFT ','2023-01-18','2023-01-19 14:43:54','2023-01-20 14:43:54','530',3494300.00,3494300.00,'530','2023-01-19 14:44:51','734','2023-01-19 14:52:55',10,0),('1','113',258373,'MORNING SHIFT ','2023-01-19','2023-01-19 15:04:35','2023-01-20 15:04:35','530',3857391.80,3857391.80,'530','2023-01-19 15:06:28','734','2023-01-19 15:18:24',10,0),('1','113',258374,'AFTERNOON SHIFT','2023-01-19','2023-01-19 18:40:29','2023-01-20 18:40:29','530',0.00,0.00,'530','2023-01-19 18:42:25','975','2023-01-19 18:43:13',10,0),('1','113',258375,'AFTERNOON SHIFT ','2023-01-19','2023-01-20 09:59:54','2023-01-21 09:59:54','530',2958687.00,2958687.00,'530','2023-01-20 10:01:11','734','2023-01-20 14:04:38',10,0),('1','113',258376,'MORNING SHIFT','2023-01-20','2023-01-20 16:04:55','2023-01-21 16:04:55','530',3727029.55,3727029.55,'530','2023-01-20 16:07:02','734','2023-01-20 18:22:51',10,0),('1','113',258377,'AFTERNOON SHIFT ','2023-01-20','2023-01-21 12:26:18','2023-01-22 12:26:18','530',3902252.60,3902252.60,'530','2023-01-21 12:28:10','734','2023-01-21 16:45:36',10,0),('1','113',258378,'MORNING SHIFT ','2023-01-21','2023-01-22 09:28:58','2023-01-23 09:28:58','530',8574522.40,8574522.40,'530','2023-01-23 09:35:59','734','2023-01-23 09:42:07',10,0),('1','113',258379,'AFTERNOON SHIFT ','2023-01-21','2023-01-23 09:47:04','2023-01-24 09:47:04','530',3028769.30,3028769.30,'530','2023-01-23 09:52:53','734','2023-01-23 10:03:57',10,0),('1','113',258380,'MORNING SHIFT','2023-01-22','2023-01-23 10:17:09','2023-01-24 10:17:09','530',2577418.90,2577418.90,'530','2023-01-23 10:18:34','734','2023-01-23 10:31:20',10,0),('1','113',258381,'AFTERNOON SHIFT','2023-01-22','2023-01-23 19:44:26','2023-01-24 19:44:26','530',0.00,0.00,'975','2023-01-23 20:29:03','975','2023-01-23 20:29:22',10,0),('1','113',258382,'MORNING SHIFT','2023-01-23','2023-01-23 20:30:35','2023-01-24 20:30:35','530',0.00,0.00,'975','2023-01-23 20:32:15','975','2023-01-23 20:32:28',10,0),('1','113',258383,'MORNING SHIFT','2023-01-23','2023-01-23 20:33:55','2023-01-24 20:33:55','530',2650410.40,2650410.40,'530','2023-01-23 20:36:22','734','2023-01-23 22:20:15',10,0),('1','113',258384,'MORNING SHIFT ','2023-01-24','2023-01-24 17:23:50','2023-01-25 17:23:50','530',2807246.20,2807246.20,'530','2023-01-24 17:25:47','734','2023-01-24 21:44:28',10,0),('1','113',258385,'AFTERNOON SHIFT','2023-01-24','2023-01-25 06:19:51','2023-01-26 06:19:51','530',1431742.40,1431742.40,'530','2023-01-25 06:25:53','734','2023-01-25 12:10:31',10,0),('1','113',258386,'MORNING SHIFT ','2023-01-25','2023-01-25 14:36:17','2023-01-26 14:36:17','530',2684710.60,2684710.60,'530','2023-01-25 15:15:42','734','2023-01-25 16:21:25',10,0),('1','113',258387,'AFTERNOON SHIFT ','2023-01-25','2023-01-26 14:29:17','2023-01-27 14:29:17','530',1705154.00,1705154.00,'530','2023-01-26 14:31:32','734','2023-01-26 15:51:50',10,0),('1','113',258388,'MORNING SHIFT','2023-01-27','2023-01-27 07:54:12','2023-01-28 07:54:12','530',0.00,0.00,'530','2023-01-27 07:54:33','734','2023-01-27 07:55:35',10,0),('1','113',258389,'MORNING SHIFT','2023-01-26','2023-01-27 07:56:42','2023-01-28 07:56:42','530',2011805.40,2011805.40,'530','2023-01-27 07:57:43','734','2023-01-27 07:59:48',10,0),('1','113',258390,'AFTERNOON SHIFT','2023-01-26','2023-01-27 08:01:09','2023-01-28 08:01:09','530',942658.20,942658.20,'530','2023-01-27 08:02:13','734','2023-01-27 08:03:27',10,0),('1','113',258391,'MORNING SHIFT','2023-01-27','2023-01-27 15:06:19','2023-01-28 15:06:19','530',3851727.00,3851727.00,'530','2023-01-27 15:08:48','734','2023-01-27 19:30:27',10,0),('1','113',258392,'AFTERNOON SHIFT','2023-01-27','2023-01-28 08:28:56','2023-01-29 08:28:56','530',9338348.30,9338348.30,'530','2023-01-28 08:39:27','734','2023-01-28 09:07:11',10,0),('1','113',258393,'AFTERNOON SHIFT','2023-01-27','2023-01-28 09:10:13','2023-01-29 09:10:13','530',0.00,0.00,'530','2023-01-28 09:11:57','734','2023-01-28 09:18:28',10,0),('1','113',258394,'MORNING SHIFT','2023-01-28','2023-01-28 15:11:08','2023-01-29 15:11:08','530',6366868.80,6366868.80,'530','2023-01-28 15:13:30','734','2023-01-28 15:48:35',10,0),('1','113',258395,'AFTERNOON SHIFT','2023-01-28','2023-01-28 20:20:31','2023-01-29 20:20:31','530',4017856.10,4017856.10,'530','2023-01-28 20:24:33','734','2023-01-28 21:03:38',10,0),('1','113',258396,'MORNING SHIFT','2023-01-29','2023-01-29 14:35:01','2023-01-30 14:35:01','530',9232699.50,9232699.50,'530','2023-01-29 14:37:10','734','2023-01-29 15:31:36',10,0),('1','113',258397,'AFTERNOON SHIFT','2023-01-29','2023-01-30 08:30:03','2023-01-31 08:30:03','530',4433236.90,4433236.90,'530','2023-01-30 08:48:58','734','2023-01-30 10:58:29',10,0),('1','113',258398,'MORNING SHIFT ','2023-01-30','2023-01-30 15:15:04','2023-01-31 15:15:04','530',6169166.30,6169166.30,'530','2023-01-30 15:18:32','734','2023-01-30 15:29:01',10,0),('1','113',258399,'AFTERNOON SHIFT','2023-01-30','2023-01-31 08:54:04','2023-02-01 08:54:04','530',2782856.50,2782856.50,'530','2023-01-31 08:56:26','734','2023-01-31 16:06:23',10,0),('1','113',258400,'MORNING SHIFT','2023-01-31','2023-01-31 16:52:16','2023-02-01 16:52:16','530',5529775.30,5529775.30,'530','2023-01-31 16:55:19','734','2023-01-31 22:34:04',10,0),('1','113',258401,'MORNING SHIFT','2023-01-31','2023-01-31 23:01:08','2023-02-01 23:01:08','530',1518880.20,1518880.20,'530','2023-01-31 23:03:55','734','2023-01-31 23:19:18',10,0),('1','113',258402,'MORNING SHIFT','2023-01-31','2023-02-01 15:19:33','2023-02-02 15:19:33','530',0.00,0.00,'530','2023-02-01 15:21:00','734','2023-02-01 15:23:02',10,0),('1','113',258403,'MORNING SHIFT','2023-02-01','2023-02-01 15:55:48','2023-02-02 15:55:48','530',4915856.40,4915856.40,'530','2023-02-01 15:57:37','734','2023-02-01 19:34:20',10,0),('1','113',258404,'AFTERNOON SHIFT','2023-02-01','2023-02-02 07:05:33','2023-02-03 07:05:33','530',4951325.00,4951325.00,'530','2023-02-02 07:06:45','734','2023-02-02 09:16:05',10,0),('1','113',258405,'MORNING SHIFT','2023-02-02','2023-02-02 14:14:10','2023-02-03 14:14:10','530',4963712.20,4963712.20,'530','2023-02-02 14:22:38','734','2023-02-02 15:12:05',10,0),('1','113',258406,'AFTERNOON SHIFT','2023-02-02','2023-02-03 13:14:03','2023-02-04 13:14:03','530',6580652.60,6580652.60,'530','2023-02-03 13:16:22','734','2023-02-03 14:25:06',10,0),('1','113',258407,'MORNING SHIFT','2023-02-03','2023-02-03 15:22:03','2023-02-04 15:22:03','530',3341320.80,3341320.80,'530','2023-02-03 15:23:03','734','2023-02-03 17:12:07',10,0),('1','113',258408,'AFTERNOON SHIFT ','2023-02-03','2023-02-04 10:16:36','2023-02-05 10:16:36','530',4104832.10,4104832.10,'530','2023-02-04 10:19:21','734','2023-02-04 13:55:45',10,0),('1','113',258409,'MORNING SHIFT','2023-02-04','2023-02-04 20:45:54','2023-02-05 20:45:54','530',7053372.30,7053372.30,'530','2023-02-04 20:52:56','734','2023-02-04 21:34:16',10,0),('1','113',258410,'AFTERNOON SHIFT','2023-02-04','2023-02-04 23:07:26','2023-02-05 23:07:26','530',6370209.10,6370209.10,'530','2023-02-04 23:13:33','734','2023-02-05 06:55:03',10,0),('1','113',258411,'MORNING SHIFT  ','2023-02-05','2023-02-05 14:22:57','2023-02-06 14:22:57','530',5438188.30,5438188.30,'530','2023-02-05 14:27:17','734','2023-02-05 16:35:01',10,0),('1','113',258412,'MORNING SHIFT  2','2023-02-05','2023-02-05 21:14:42','2023-02-06 21:14:42','530',294400.00,294400.00,'530','2023-02-06 08:08:56','734','2023-02-06 09:15:23',10,0),('1','113',258413,'AFTERNOON SHIFT ','2023-02-05','2023-02-06 12:51:16','2023-02-07 12:51:16','530',5440450.00,5440450.00,'530','2023-02-06 12:53:21','734','2023-02-06 15:24:09',10,0),('1','113',258414,'MORNING SHIFT','2023-02-06','2023-02-06 16:41:39','2023-02-07 16:41:39','530',9293752.00,9293752.00,'530','2023-02-06 17:05:15','734','2023-02-06 18:46:10',10,0),('1','113',258415,'AFTERNOON SHIFT','2023-02-06','2023-02-07 09:53:30','2023-02-08 09:53:30','530',5374874.00,5374874.00,'530','2023-02-07 10:15:56','734','2023-02-07 14:18:20',10,0),('1','113',258416,'MORNING SHIFT ','2023-02-07','2023-02-07 20:50:18','2023-02-08 20:50:18','530',6119730.00,6119730.00,'530','2023-02-07 20:56:28','734','2023-02-07 21:12:34',10,0),('1','113',258417,'AFTERNOON SHIFT','2023-02-07','2023-02-08 06:07:08','2023-02-09 06:07:08','530',8739948.00,8739948.00,'530','2023-02-08 06:10:32','734','2023-02-08 07:14:28',10,0),('1','113',258418,'MORNING SHIFT ','2023-02-08','2023-02-08 14:31:48','2023-02-09 14:31:48','530',6037636.00,6037636.00,'530','2023-02-08 14:37:38','734','2023-02-08 17:18:23',10,0),('1','113',258419,'MORNING SHIFT','2023-02-08','2023-02-08 21:01:46','2023-02-09 21:01:46','530',0.00,0.00,'530','2023-02-08 21:04:18','734','2023-02-08 21:06:38',10,0),('1','113',258420,'AFTERNOON SHIFT','2023-02-08','2023-02-09 08:52:50','2023-02-10 08:52:50','530',9421362.00,9421362.00,'530','2023-02-09 09:04:05','734','2023-02-09 14:08:40',10,0),('1','113',258421,'MORNING SHIFT ','2023-02-09','2023-02-09 15:22:20','2023-02-10 15:22:20','530',5802822.00,5802822.00,'530','2023-02-09 15:27:37','734','2023-02-09 18:16:44',10,0),('1','113',258422,'AFTERNOON SHIFT ','2023-02-09','2023-02-10 10:56:33','2023-02-11 10:56:33','530',4551142.00,4551142.00,'530','2023-02-10 11:07:56','734','2023-02-10 12:04:38',10,0),('1','113',258423,'MORNING SHIFT ','2023-02-10','2023-02-10 15:24:56','2023-02-11 15:24:56','530',5937448.00,5937448.00,'530','2023-02-10 15:27:33','734','2023-02-10 20:21:18',10,0),('1','113',258424,'AFTERNOON SHIFT','2023-02-10','2023-02-11 09:58:32','2023-02-12 09:58:32','530',8387534.00,8387534.00,'530','2023-02-11 10:20:37','734','2023-02-11 13:55:40',10,0),('1','113',258425,'MORNING SHIFT','2023-02-11','2023-02-11 20:43:31','2023-02-12 20:43:31','530',1601816.00,1601816.00,'530','2023-02-11 20:48:58','734','2023-02-11 21:39:49',10,0),('1','113',258426,'AFTERNOON SHIFT','2023-02-11','2023-02-11 23:49:02','2023-02-12 23:49:02','530',7168420.00,7168420.00,'530','2023-02-11 23:51:40','734','2023-02-12 08:14:34',10,0),('1','113',258427,'MORNING SHIFT ','2023-02-12','2023-02-12 16:30:37','2023-02-13 16:30:37','530',3612780.00,3612780.00,'530','2023-02-12 16:31:59','734','2023-02-12 16:36:11',10,0),('1','113',258428,'AFTERNOON SHIFT ','2023-02-12','2023-02-13 10:50:43','2023-02-14 10:50:43','530',4522528.00,4522528.00,'530','2023-02-13 10:53:52','734','2023-02-13 14:47:35',10,0),('1','113',258429,'MORNING SHIFT','2023-02-13','2023-02-13 21:29:08','2023-02-14 21:29:08','530',3677318.00,3677318.00,'530','2023-02-13 21:30:46','734','2023-02-13 23:19:37',10,0),('1','113',258430,'AFTERNOON SHIFT','2023-02-13','2023-02-13 23:42:26','2023-02-14 23:42:26','530',8356858.00,8356858.00,'530','2023-02-13 23:48:54','734','2023-02-13 23:50:57',10,0),('1','113',258431,'MORNING SHIFT ','2023-02-14','2023-02-14 18:55:28','2023-02-15 18:55:28','530',3766858.00,3766858.00,'530','2023-02-14 18:57:20','734','2023-02-14 19:00:08',10,0),('1','113',258432,'MORNING SHIFT ','2023-02-14','2023-02-14 19:04:55','2023-02-15 19:04:55','530',0.00,0.00,'530','2023-02-14 19:22:22','734','2023-02-14 21:12:28',10,0),('1','113',258433,'AFTERNOON SHIFT','2023-02-14','2023-02-14 22:38:59','2023-02-15 22:38:59','530',9026108.00,9026108.00,'530','2023-02-15 07:19:51','734','2023-02-15 09:33:01',10,0),('1','113',258434,'MORNING SHIFT','2023-02-15','2023-02-15 14:28:32','2023-02-16 14:28:32','530',4939818.00,4939818.00,'530','2023-02-15 14:30:29','734','2023-02-15 14:42:21',10,0),('1','113',258435,'AFTERNOON SHIFT','2023-02-15','2023-02-15 21:18:01','2023-02-16 21:18:01','530',4545322.00,4545322.00,'530','2023-02-15 21:19:56','734','2023-02-15 22:24:09',10,0),('1','113',258436,'MORNING SHIFT','2023-02-16','2023-02-16 15:13:58','2023-02-17 15:13:58','530',4870396.00,4870396.00,'530','2023-02-16 15:15:47','734','2023-02-16 15:27:28',10,0),('1','113',258437,'AFTERNOON SHIFT','2023-02-16','2023-02-17 08:14:30','2023-02-18 08:14:30','530',3993488.00,3993488.00,'530','2023-02-17 08:17:47','734','2023-02-17 08:22:35',10,0),('1','113',258438,'MORNING SHIFT','2023-02-17','2023-02-17 17:02:43','2023-02-18 17:02:43','530',3564122.00,3564122.00,'530','2023-02-17 17:05:11','734','2023-02-17 17:26:32',10,0),('1','113',258439,'AFTERNOON SHIFT','2023-02-17','2023-02-18 07:45:43','2023-02-19 07:45:43','530',4642700.00,4642700.00,'530','2023-02-18 07:48:32','734','2023-02-18 09:04:46',10,0),('1','113',258440,'MORNING SHIFT ','2023-02-18','2023-02-18 10:58:31','2023-02-19 10:58:31','530',0.00,0.00,'530','2023-02-18 11:00:50','734','2023-02-18 14:37:18',10,0),('1','113',258441,'MORNING SHIFT ','2023-02-18','2023-02-18 17:25:21','2023-02-19 17:25:21','530',3752844.00,3752844.00,'530','2023-02-18 17:28:44','734','2023-02-18 19:07:55',10,0),('1','113',258442,'AFTERNOON SHIFT','2023-02-18','2023-02-19 13:01:57','2023-02-20 13:01:57','530',5740790.00,5740790.00,'530','2023-02-19 13:09:24','734','2023-02-19 15:24:48',10,0),('1','113',258443,'MORNING SHIFT ','2023-02-19','2023-02-19 16:17:00','2023-02-20 16:17:00','530',3860870.00,3860870.00,'530','2023-02-19 16:20:59','734','2023-02-19 17:32:11',10,0),('1','113',258444,'AFTERNOON SHIFT','2023-02-19','2023-02-19 20:45:35','2023-02-20 20:45:35','530',3698084.00,3698084.00,'530','2023-02-19 20:47:35','734','2023-02-19 21:31:16',10,0),('1','113',258445,'MORNING SHIFT ','2023-02-20','2023-02-21 14:18:22','2023-02-22 14:18:22','530',453426.00,453426.00,'530','2023-02-21 14:25:15','734','2023-02-21 14:42:22',10,0),('1','113',258446,'MORNING SHIFT ','2023-02-21','2023-02-21 15:09:29','2023-02-22 15:09:29','530',5412108.00,5412108.00,'530','2023-02-21 18:52:07','734','2023-02-21 21:12:41',10,0),('1','113',258447,'AFTERNOON SHIFT','2023-02-21','2023-02-22 07:41:26','2023-02-23 07:41:26','530',2971242.00,2971242.00,'530','2023-02-22 07:47:41','734','2023-02-22 09:59:35',10,0),('1','113',258448,'MORNING SHIFT','2023-02-22','2023-02-22 22:37:27','2023-02-23 22:37:27','530',3818454.00,3818454.00,'530','2023-02-22 22:43:31','734','2023-02-22 23:41:31',10,0),('1','113',258449,'AFTERNOON SHIFT','2023-02-22','2023-02-23 08:13:22','2023-02-24 08:13:22','530',2073630.00,2073630.00,'530','2023-02-23 08:16:31','734','2023-02-23 16:17:00',10,0),('1','113',258450,'AFTERNOON SHIFT','2023-02-23','2023-02-24 08:47:19','2023-02-25 08:47:19','530',5211174.00,5211174.00,'530','2023-02-24 08:50:52','734','2023-02-24 09:44:27',10,0),('1','113',258451,'AFTERNOON SHIFT','2023-02-23','2023-02-24 10:33:52','2023-02-25 10:33:52','530',1887430.00,1887430.00,'530','2023-02-24 10:36:54','734','2023-02-24 15:39:14',10,0),('1','113',258452,'MORNING SHIFT','2023-02-24','2023-02-24 21:00:58','2023-02-25 21:00:58','530',12051378.00,12051378.00,'530','2023-02-24 22:34:53','734','2023-02-24 22:39:25',10,0),('1','113',258453,'AFTERNOON SHIFT','2023-02-24','2023-02-24 22:43:31','2023-02-25 22:43:31','530',1775216.00,1775216.00,'530','2023-02-24 22:54:12','734','2023-02-24 23:31:27',10,0),('1','113',258454,'AFTERNOON SHIFT','2023-02-24','2023-02-25 08:24:02','2023-02-26 08:24:02','530',0.00,0.00,'530','2023-02-25 08:27:03','734','2023-02-25 10:02:13',10,0),('1','113',258455,'MORNING SHIFT','2023-02-26','2023-02-26 15:47:57','2023-02-27 15:47:57','530',2290278.00,2290278.00,'530','2023-02-26 15:54:20','734','2023-02-26 17:28:17',10,0),('1','113',258456,'AFTERNOON SHIFT','2023-02-26','2023-02-27 08:07:03','2023-02-28 08:07:03','530',3320218.00,3320218.00,'530','2023-02-27 08:12:56','734','2023-02-27 10:55:42',10,0),('1','113',258457,'AFTERNOON SHIFT','2023-02-26','2023-02-27 13:44:16','2023-02-28 13:44:16','530',0.00,0.00,'530','2023-02-27 14:15:34','734','2023-02-27 14:33:27',10,0),('1','113',258458,'MORNING SHIFT','2023-02-27','2023-02-27 19:53:32','2023-02-28 19:53:32','530',5396300.00,5396300.00,'530','2023-02-27 20:04:09','734','2023-02-27 20:06:45',10,0),('1','113',258459,'AFTERNOON SHIFT','2023-02-27','2023-02-27 20:16:38','2023-02-28 20:16:38','530',936658.00,936658.00,'530','2023-02-27 20:41:16','734','2023-02-27 21:04:35',10,0),('1','113',258460,'AFTERNOON SHIFT 2','2023-02-27','2023-02-28 09:58:16','2023-03-01 09:58:16','530',2104211.95,2104211.95,'530','2023-02-28 10:02:50','734','2023-02-28 14:14:01',10,0),('1','113',258461,'MORNING SHIFT','2023-02-28','2023-02-28 14:28:16','2023-03-01 14:28:16','530',3624548.85,3624548.85,'530','2023-02-28 14:32:04','734','2023-02-28 15:14:03',10,0),('1','113',258462,'MORNING SHIFT ','2023-02-28','2023-02-28 15:46:54','2023-03-01 15:46:54','530',0.00,0.00,'530','2023-02-28 15:49:47','734','2023-03-01 14:53:01',10,0),('1','113',258463,'AFTERNOON SHIFT','2023-02-28','2023-03-01 15:21:11','2023-03-02 15:21:11','530',1623342.55,1623342.55,'530','2023-03-01 15:25:14','734','2023-03-01 15:55:04',10,0),('1','113',258464,'MORNING SHIFT ','2023-03-01','2023-03-01 16:13:56','2023-03-02 16:13:56','530',2911489.95,2911489.95,'530','2023-03-01 16:16:52','734','2023-03-01 19:20:41',10,0),('1','113',258465,'AFTERNOON SHIFT','2023-03-01','2023-03-01 21:00:08','2023-03-02 21:00:08','530',5033428.35,5033428.35,'530','2023-03-02 10:05:40','734','2023-03-02 14:28:22',10,0),('1','113',258466,'MORNING SHIFT ','2023-03-02','2023-03-02 15:53:39','2023-03-03 15:53:39','530',3181361.80,3181361.80,'530','2023-03-02 15:58:05','734','2023-03-02 21:01:39',10,0),('1','113',258467,'AFTERNOON SHIFT','2023-03-02','2023-03-03 07:01:03','2023-03-04 07:01:03','530',2496853.95,2496853.95,'530','2023-03-03 07:09:56','734','2023-03-03 07:13:14',10,0),('1','113',258468,'MORNING SHIFT ','2023-03-03','2023-03-03 14:41:59','2023-03-04 14:41:59','530',2578416.80,2578416.80,'530','2023-03-04 10:56:11','734','2023-03-04 13:10:07',10,0),('1','113',258469,'AFTERNOON SHIFT ','2023-03-03','2023-03-04 13:12:44','2023-03-05 13:12:44','530',2504656.00,2504656.00,'530','2023-03-04 13:14:38','734','2023-03-04 13:15:10',10,0),('1','113',258470,'MORNING SHIFT ','2023-03-04','2023-03-04 13:44:32','2023-03-05 13:44:32','530',1693184.00,1693184.00,'530','2023-03-04 13:46:00','734','2023-03-04 14:11:27',10,0),('1','113',258471,'MORNING SHIFT','2023-03-04','2023-03-04 14:29:09','2023-03-05 14:29:09','530',0.00,0.00,'530','2023-03-04 14:31:21','734','2023-03-04 15:05:00',10,0),('1','113',258472,'AFTERNOON SHIFT','2023-03-04','2023-03-05 16:16:54','2023-03-06 16:16:54','530',3306330.40,3306330.40,'530','2023-03-05 16:20:58','734','2023-03-05 16:22:21',10,0),('1','113',258473,'MORNING SHIFT ','2023-03-05','2023-03-05 16:41:22','2023-03-06 16:41:22','530',4214888.30,4214888.30,'530','2023-03-05 16:48:12','734','2023-03-05 17:35:18',10,0),('1','113',258474,'AFTERNOON SHIFT','2023-03-05','2023-03-05 22:51:55','2023-03-06 22:51:55','530',4217089.10,4217089.10,'530','2023-03-05 22:57:22','734','2023-03-06 08:54:59',10,0),('1','113',258475,'MORNING SHIFT','2023-03-06','2023-03-06 15:12:59','2023-03-07 15:12:59','530',0.00,0.00,'530','2023-03-06 15:15:15','734','2023-03-06 15:27:21',10,0),('1','113',258476,'MORNING SHIFT ','2023-03-06','2023-03-06 15:48:33','2023-03-07 15:48:33','530',2966245.05,2966245.05,'530','2023-03-06 15:51:53','734','2023-03-06 21:15:13',10,0),('1','113',258477,'AFTERNOON SHIFT','2023-03-06','2023-03-07 00:14:28','2023-03-08 00:14:28','530',4330741.40,4330741.40,'530','2023-03-07 00:18:37','734','2023-03-07 06:35:11',10,0),('1','113',258478,'MORNING SHIFT','2023-03-07','2023-03-07 21:17:50','2023-03-08 21:17:50','530',4577140.50,4577140.50,'530','2023-03-07 21:20:20','734','2023-03-07 21:41:02',10,0),('1','113',258479,'AFTERNOON SHIFT','2023-03-07','2023-03-07 22:07:47','2023-03-08 22:07:47','530',5190094.95,5190094.95,'530','2023-03-07 22:12:15','734','2023-03-08 08:39:52',10,0),('1','113',258480,'MORNING SHIFT','2023-03-08','2023-03-08 16:38:46','2023-03-09 16:38:46','530',3668364.85,3668364.85,'530','2023-03-08 19:14:03','734','2023-03-09 02:14:53',10,0),('1','113',258481,'AFTERNOON SHIFT','2023-03-08','2023-03-09 07:39:24','2023-03-10 07:39:24','530',2830897.70,2830897.70,'530','2023-03-09 07:43:18','734','2023-03-09 08:02:38',10,0),('1','113',258482,'MORNING SHIFT ','2023-03-09','2023-03-09 15:17:55','2023-03-10 15:17:55','530',6214219.60,6214219.60,'530','2023-03-09 15:25:55','734','2023-03-09 16:02:59',10,0),('1','113',258483,'AFTERNOON SHIFT','2023-03-09','2023-03-10 11:05:19','2023-03-11 11:05:19','530',2526457.65,2526457.65,'530','2023-03-10 11:09:29','734','2023-03-10 14:12:16',10,0),('1','113',258484,'MORNING SHIFT ','2023-03-10','2023-03-10 15:10:09','2023-03-11 15:10:09','530',3188857.55,3188857.55,'530','2023-03-10 15:19:08','734','2023-03-10 18:53:27',10,0),('1','113',258485,'AFTERNOON SHIFT','2023-03-10','2023-03-11 13:28:19','2023-03-12 13:28:19','530',3964036.85,3964036.85,'530','2023-03-11 13:33:56','734','2023-03-11 14:48:24',10,0),('1','113',258486,'MORNING SHIFT','2023-03-11','2023-03-11 16:23:58','2023-03-12 16:23:58','530',3978300.90,3978300.90,'530','2023-03-11 17:31:05','734','2023-03-11 17:47:51',10,0),('1','113',258487,'AFTERNOON SHIFT','2023-03-11','2023-03-12 08:36:12','2023-03-13 08:36:12','530',5048537.55,5048537.55,'530','2023-03-12 08:39:26','734','2023-03-12 11:14:06',10,0),('1','113',258488,'MORNING SHIFT ','2023-03-12','2023-03-12 15:02:08','2023-03-13 15:02:08','530',4244580.75,4244580.75,'530','2023-03-12 15:39:15','734','2023-03-12 18:38:04',10,0),('1','113',258489,'AFTERNOON SHIFT','2023-03-12','2023-03-12 23:22:21','2023-03-13 23:22:21','530',3805127.45,3805127.45,'530','2023-03-12 23:27:36','734','2023-03-12 23:35:09',10,0),('1','113',258490,'AFTERNOON SHIFT','2023-03-12','2023-03-13 13:08:26','2023-03-14 13:08:26','530',0.00,0.00,'530','2023-03-13 13:14:01','734','2023-03-13 14:01:23',10,0),('1','113',258491,'MORNING SHIFT ','2023-03-13','2023-03-13 14:59:11','2023-03-14 14:59:11','530',4880912.50,4880912.50,'530','2023-03-13 15:02:10','734','2023-03-13 15:59:48',10,0),('1','113',258492,'AFTERNOON SHIFT','2023-03-13','2023-03-13 21:52:55','2023-03-14 21:52:55','530',5810260.70,5810260.70,'530','2023-03-14 07:52:22','734','2023-03-14 11:52:13',10,0),('1','113',258493,'MORNING SHIFT ','2023-03-14','2023-03-14 15:10:34','2023-03-15 15:10:34','530',4053754.65,4053754.65,'530','2023-03-14 15:29:30','734','2023-03-14 15:44:23',10,0),('1','113',258494,'AFTERNOON SHIFT','2023-03-14','2023-03-15 09:41:53','2023-03-16 09:41:53','530',6480704.30,6480704.30,'530','2023-03-15 09:44:52','734','2023-03-15 10:06:40',10,0),('1','113',258495,'MORNING SHIFT ','2023-03-15','2023-03-15 16:14:40','2023-03-16 16:14:40','530',3343589.85,3343589.85,'530','2023-03-15 16:18:02','734','2023-03-15 16:31:14',10,0),('1','113',258496,'AFTERNOON SHIFT','2023-03-15','2023-03-16 09:49:52','2023-03-17 09:49:52','530',3736280.95,3736280.95,'530','2023-03-16 09:52:33','734','2023-03-16 14:58:07',10,0),('1','113',258497,'MORNING SHIFT ','2023-03-16','2023-03-16 15:00:19','2023-03-17 15:00:19','530',0.00,0.00,'530','2023-03-16 15:03:24','734','2023-03-16 15:06:14',10,0),('1','113',258498,'MORNING SHIFT ','2023-03-16','2023-03-16 15:19:38','2023-03-17 15:19:38','530',3328734.95,3328734.95,'530','2023-03-16 16:17:57','734','2023-03-16 17:07:08',10,0),('1','113',258499,'AFTERNOON SHIFT','2023-03-16','2023-03-17 08:44:56','2023-03-18 08:44:56','530',5692140.10,5692140.10,'530','2023-03-17 08:48:45','734','2023-03-17 13:00:01',10,0),('1','113',258500,'MORNING SHIFT ','2023-03-17','2023-03-17 15:07:11','2023-03-18 15:07:11','530',5046682.45,5046682.45,'530','2023-03-17 15:12:22','734','2023-03-17 15:21:39',10,0),('1','113',258501,'AFTERNOON SHIFT','2023-03-17','2023-03-18 16:30:43','2023-03-19 16:30:43','530',5070032.85,5070032.85,'530','2023-03-18 16:35:32','734','2023-03-18 19:22:50',10,0),('1','113',258502,'AFTERNOON SHIFT','2023-03-17','2023-03-18 22:03:41','2023-03-19 22:03:41','530',0.00,0.00,'530','2023-03-18 22:21:01','734','2023-03-19 08:36:43',10,0),('1','113',258503,'MORNING SHIFT ','2023-03-19','2023-03-19 14:33:59','2023-03-20 14:33:59','530',6153623.95,6153623.95,'530','2023-03-19 14:40:17','734','2023-03-19 18:22:39',10,0),('1','113',258504,'AFTERNOON SHIFT','2023-03-19','2023-03-20 09:46:20','2023-03-21 09:46:20','530',3161873.90,3161873.90,'530','2023-03-20 09:49:49','734','2023-03-20 12:33:47',10,0),('1','113',258505,'MORNING SHIFT ','2023-03-20','2023-03-20 13:43:51','2023-03-21 13:43:51','530',4099827.60,4099827.60,'530','2023-03-20 13:58:06','734','2023-03-20 15:20:26',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4920087 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','113','823','156839',3117355,'2326','356',832751.18,834336.40,1585.22,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156839',3117356,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156839',3117357,'2328','356',863751.78,865206.33,1454.55,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156839',3117358,'2329','356',386310.82,386310.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156839',3117359,'2330','356',712656.58,712656.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156839',3117360,'2331','356',311670.52,312805.71,1135.19,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156839',3117361,'2332','356',146387.17,147513.74,1126.57,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156839',3117362,'2333','356',778477.38,778482.11,4.73,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156839',3117363,'2334','356',262741.47,263795.99,1054.52,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156839',3117364,'2335','356',557964.80,557964.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156839',3117365,'2336','356',203759.95,204497.33,737.38,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156839',3117366,'2337','356',393991.71,393991.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','156839',3117367,'2338','357',651484.32,652227.65,743.33,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','156839',3117368,'2339','357',1655552.55,1657629.64,2077.09,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','156839',3117369,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','156839',3117370,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156845',3117474,'2326','356',834336.40,836398.62,2062.22,325830.76,0.00,0.00,0.00,0.00,0.00),('1','113','823','156845',3117475,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156845',3117476,'2328','356',865206.33,867257.75,2051.42,324124.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','156845',3117477,'2329','356',386310.82,386310.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156845',3117478,'2330','356',712656.58,714432.41,1775.83,280581.14,0.00,0.00,0.00,0.00,0.00),('1','113','823','156845',3117479,'2331','356',312805.71,312805.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156845',3117480,'2332','356',147513.74,148274.35,760.61,120176.38,0.00,0.00,0.00,0.00,0.00),('1','113','823','156845',3117481,'2333','356',778482.11,780138.66,1656.55,261734.90,0.00,0.00,0.00,0.00,0.00),('1','113','823','156845',3117482,'2334','356',263795.99,264627.71,831.72,131411.76,0.00,0.00,0.00,0.00,0.00),('1','113','823','156845',3117483,'2335','356',557964.80,557964.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156845',3117484,'2336','356',204497.33,204497.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156845',3117485,'2337','356',393991.71,395072.84,1081.13,170818.54,0.00,0.00,0.00,0.00,0.00),('1','113','824','156845',3117486,'2338','357',652227.65,653372.66,1145.01,206101.80,0.00,0.00,0.00,0.00,0.00),('1','113','824','156845',3117487,'2339','357',1657629.64,1660343.77,2714.13,488543.40,0.00,0.00,0.00,0.00,0.00),('1','113','825','156845',3117488,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','156845',3117489,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156961',3119538,'2326','356',836398.62,838197.26,1798.64,284185.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','156961',3119539,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156961',3119540,'2328','356',867257.75,868773.38,1515.63,239469.54,0.00,0.00,0.00,0.00,0.00),('1','113','823','156961',3119541,'2329','356',386310.82,386310.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156961',3119542,'2330','356',714432.41,714432.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156961',3119543,'2331','356',312805.71,314158.21,1352.50,213695.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156961',3119544,'2332','356',148274.35,149642.22,1367.87,216123.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','156961',3119545,'2333','356',780138.66,780138.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156961',3119546,'2334','356',264627.71,264627.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156961',3119547,'2335','356',557964.80,559185.90,1221.10,192933.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','156961',3119548,'2336','356',204497.33,205284.55,787.22,124380.76,0.00,0.00,0.00,0.00,0.00),('1','113','823','156961',3119549,'2337','356',395072.84,395072.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','156961',3119550,'2338','357',653372.66,653916.89,544.23,97961.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','156961',3119551,'2339','357',1660343.77,1664280.67,3936.90,708642.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','156961',3119552,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','156961',3119553,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156967',3119657,'2326','356',838197.26,840121.24,1903.98,300828.84,0.00,0.00,20.00,0.00,0.00),('1','113','823','156967',3119658,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156967',3119659,'2328','356',868773.38,868773.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156967',3119660,'2329','356',386310.82,388173.34,1862.52,294278.16,0.00,0.00,0.00,0.00,0.00),('1','113','823','156967',3119661,'2330','356',714432.41,715677.67,1245.26,196751.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','156967',3119662,'2331','356',314158.21,314158.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156967',3119663,'2332','356',149642.22,149642.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156967',3119664,'2333','356',780138.66,782006.45,1867.79,295110.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','156967',3119665,'2334','356',264627.71,266439.07,1811.36,286194.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','156967',3119666,'2335','356',559185.90,559185.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156967',3119667,'2336','356',205284.55,206735.94,1451.39,229319.62,0.00,0.00,0.00,0.00,0.00),('1','113','823','156967',3119668,'2337','356',395072.84,395072.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','156967',3119669,'2338','357',653916.89,654900.80,973.91,175303.80,0.00,0.00,10.00,0.00,0.00),('1','113','824','156967',3119670,'2339','357',1664280.67,1666010.97,1730.30,311454.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','156967',3119671,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','156967',3119672,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156971',3119721,'2326','356',840121.24,841752.03,1630.79,257664.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','156971',3119722,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156971',3119723,'2328','356',868773.38,870445.34,1671.96,264169.68,0.00,0.00,0.00,0.00,0.00),('1','113','823','156971',3119724,'2329','356',388173.34,388173.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156971',3119725,'2330','356',715677.67,715677.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156971',3119726,'2331','356',314158.21,315719.35,1561.14,246660.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','156971',3119727,'2332','356',149642.22,150711.03,1068.81,168871.98,0.00,0.00,0.00,0.00,0.00),('1','113','823','156971',3119728,'2333','356',782006.45,782006.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156971',3119729,'2334','356',266439.07,266439.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','156971',3119730,'2335','356',559185.90,560251.77,1065.87,168407.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','156971',3119731,'2336','356',206735.94,207447.21,711.27,112380.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','156971',3119732,'2337','356',395072.84,395072.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','156971',3119733,'2338','357',654900.80,655517.89,617.09,111076.20,0.00,0.00,0.00,0.00,0.00),('1','113','824','156971',3119734,'2339','357',1666010.97,1669874.21,3863.24,695383.20,0.00,0.00,0.00,0.00,0.00),('1','113','825','156971',3119735,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','156971',3119736,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157108',3122106,'2326','356',841752.03,843780.70,2028.67,320529.86,0.00,0.00,0.00,0.00,0.00),('1','113','823','157108',3122107,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157108',3122108,'2328','356',870445.34,870445.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157108',3122109,'2329','356',388173.34,389999.48,1826.14,288530.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','157108',3122110,'2330','356',715677.67,717067.79,1390.12,219638.96,0.00,0.00,0.00,0.00,0.00),('1','113','823','157108',3122111,'2331','356',315719.35,316752.72,1033.37,163272.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','157108',3122112,'2332','356',150711.03,150711.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157108',3122113,'2333','356',782006.45,783678.10,1671.65,264120.70,0.00,0.00,0.00,0.00,0.00),('1','113','823','157108',3122114,'2334','356',266439.07,266439.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157108',3122115,'2335','356',560251.77,561860.45,1608.68,254171.44,0.00,0.00,0.00,0.00,0.00),('1','113','823','157108',3122116,'2336','356',207447.21,208806.00,1358.79,214688.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','157108',3122117,'2337','356',395072.84,395072.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157108',3122118,'2338','357',655517.89,656905.14,1387.25,249705.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157108',3122119,'2339','357',1669874.21,1672015.08,2140.87,385356.60,0.00,0.00,0.00,0.00,0.00),('1','113','825','157108',3122120,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157108',3122121,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157117',3122253,'2326','356',843780.70,845547.47,1766.77,279149.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','157117',3122254,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157117',3122255,'2328','356',870445.34,871886.39,1441.05,227685.90,0.00,0.00,0.00,0.00,0.00),('1','113','823','157117',3122256,'2329','356',389999.48,389999.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157117',3122257,'2330','356',717067.79,717067.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157117',3122258,'2331','356',316752.72,317775.58,1022.86,161611.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','157117',3122259,'2332','356',150711.03,151988.00,1276.97,201761.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','157117',3122260,'2333','356',783678.10,783678.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157117',3122261,'2334','356',266439.07,266439.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157117',3122262,'2335','356',561860.45,562893.94,1033.49,163291.42,0.00,0.00,0.00,0.00,0.00),('1','113','823','157117',3122263,'2336','356',208806.00,209550.81,744.81,117679.98,0.00,0.00,0.00,0.00,0.00),('1','113','823','157117',3122264,'2337','356',395072.84,395072.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157117',3122265,'2338','357',656905.14,657055.14,150.00,27000.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157117',3122266,'2339','357',1672015.08,1674881.21,2866.13,515903.40,0.00,0.00,0.00,0.00,0.00),('1','113','825','157117',3122267,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157117',3122268,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157119',3122289,'2326','356',845547.47,847774.32,2226.85,351842.30,0.00,0.00,0.00,0.00,0.00),('1','113','823','157119',3122290,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157119',3122291,'2328','356',871886.39,871886.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157119',3122292,'2329','356',389999.48,391827.58,1828.10,288839.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','157119',3122293,'2330','356',717067.79,719189.68,2121.89,335258.62,0.00,0.00,0.00,0.00,0.00),('1','113','823','157119',3122294,'2331','356',317775.58,317775.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157119',3122295,'2332','356',151988.00,151988.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157119',3122296,'2333','356',783678.10,784932.24,1254.14,198154.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','157119',3122297,'2334','356',266439.07,267972.00,1512.93,239042.94,0.00,0.00,20.00,0.00,0.00),('1','113','823','157119',3122298,'2335','356',562893.94,562893.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157119',3122299,'2336','356',209550.81,209550.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157119',3122300,'2337','356',395072.84,396308.73,1235.89,195270.62,0.00,0.00,0.00,0.00,0.00),('1','113','824','157119',3122301,'2338','357',657055.14,657236.26,181.12,32601.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','157119',3122302,'2339','357',1674881.21,1677272.89,2391.68,430502.40,0.00,0.00,0.00,0.00,0.00),('1','113','825','157119',3122303,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157119',3122304,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157124',3122344,'2326','356',847774.32,849482.70,1708.38,269924.04,0.00,0.00,0.00,0.00,0.00),('1','113','823','157124',3122345,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157124',3122346,'2328','356',871886.39,871886.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157124',3122347,'2329','356',391827.58,393408.82,1581.24,249835.92,0.00,0.00,0.00,0.00,0.00),('1','113','823','157124',3122348,'2330','356',719189.68,720614.79,1425.11,225167.38,0.00,0.00,0.00,0.00,0.00),('1','113','823','157124',3122349,'2331','356',317775.58,317775.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157124',3122350,'2332','356',151988.00,152605.05,617.05,97493.90,0.00,0.00,0.00,0.00,0.00),('1','113','823','157124',3122351,'2333','356',784932.24,785354.60,422.36,66732.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','157124',3122352,'2334','356',267972.00,268349.83,377.83,59697.14,0.00,0.00,0.00,0.00,0.00),('1','113','823','157124',3122353,'2335','356',562893.94,563709.70,815.76,128890.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','157124',3122354,'2336','356',209550.81,210323.45,772.64,122077.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','157124',3122355,'2337','356',396308.73,396308.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157124',3122356,'2338','357',657236.26,657749.04,512.78,92300.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','157124',3122357,'2339','357',1677272.89,1678905.29,1632.40,293832.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157124',3122358,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157124',3122359,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157127',3122420,'2326','356',849482.70,851378.98,1896.28,299612.24,0.00,0.00,0.00,0.00,0.00),('1','113','823','157127',3122421,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157127',3122422,'2328','356',871886.39,874335.55,2449.16,386967.28,0.00,0.00,0.00,0.00,0.00),('1','113','823','157127',3122423,'2329','356',393408.82,393408.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157127',3122424,'2330','356',720614.79,720614.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157127',3122425,'2331','356',317775.58,319734.47,1958.89,309504.62,0.00,0.00,0.00,0.00,0.00),('1','113','823','157127',3122426,'2332','356',152605.05,154372.97,1767.92,279331.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','157127',3122427,'2333','356',785354.60,785354.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157127',3122428,'2334','356',268349.83,270110.93,1761.10,278253.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','157127',3122429,'2335','356',563709.70,563709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157127',3122430,'2336','356',210323.45,210326.61,3.16,499.28,0.00,0.00,0.00,0.00,0.00),('1','113','823','157127',3122431,'2337','356',396308.73,396308.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157127',3122432,'2338','357',657749.04,657912.95,163.91,29503.80,0.00,0.00,0.00,0.00,0.00),('1','113','824','157127',3122433,'2339','357',1678905.29,1680624.13,1708.84,307591.20,0.00,0.00,10.00,0.00,0.00),('1','113','825','157127',3122434,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157127',3122435,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157183',3123478,'2326','356',851378.98,852308.02,929.04,146788.32,0.00,0.00,0.00,0.00,0.00),('1','113','823','157183',3123479,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157183',3123480,'2328','356',874335.55,875603.42,1267.87,200323.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','157183',3123481,'2329','356',393408.82,393408.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157183',3123482,'2330','356',720614.79,721282.42,667.63,105485.54,0.00,0.00,0.00,0.00,0.00),('1','113','823','157183',3123483,'2331','356',319734.47,319734.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157183',3123484,'2332','356',154372.97,155261.09,888.12,140322.96,0.00,0.00,0.00,0.00,0.00),('1','113','823','157183',3123485,'2333','356',785354.60,785354.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157183',3123486,'2334','356',270110.93,270110.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157183',3123487,'2335','356',563709.70,564432.27,722.57,114166.06,0.00,0.00,0.00,0.00,0.00),('1','113','823','157183',3123488,'2336','356',210326.61,210734.50,407.89,64446.62,0.00,0.00,0.00,0.00,0.00),('1','113','823','157183',3123489,'2337','356',396308.73,396308.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157183',3123490,'2338','357',657912.95,658140.76,227.81,41005.80,0.00,0.00,0.00,0.00,0.00),('1','113','824','157183',3123491,'2339','357',1680624.13,1683036.03,2411.90,434142.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157183',3123492,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157183',3123493,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157296',3125518,'2326','356',852308.02,854345.92,2037.90,321988.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','157296',3125519,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157296',3125520,'2328','356',875603.42,875603.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157296',3125521,'2329','356',393408.82,395303.61,1894.79,299376.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','157296',3125522,'2330','356',721282.42,721282.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157296',3125523,'2331','356',319734.47,322107.95,2373.48,375009.84,0.00,0.00,0.00,0.00,0.00),('1','113','823','157296',3125524,'2332','356',155261.09,157245.82,1984.73,313587.34,0.00,0.00,0.00,0.00,0.00),('1','113','823','157296',3125525,'2333','356',785354.60,785354.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157296',3125526,'2334','356',270110.93,270110.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157296',3125527,'2335','356',564432.27,565419.54,987.27,155988.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','157296',3125528,'2336','356',210734.50,210734.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157296',3125529,'2337','356',396308.73,397275.77,967.04,152792.32,0.00,0.00,0.00,0.00,0.00),('1','113','824','157296',3125530,'2338','357',658140.76,659808.78,1668.02,300243.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','157296',3125531,'2339','357',1683036.03,1687708.01,4671.98,840956.40,0.00,0.00,0.00,0.00,0.00),('1','113','825','157296',3125532,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157296',3125533,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157299',3125538,'2326','356',854345.92,855631.62,1285.70,203140.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','157299',3125539,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157299',3125540,'2328','356',875603.42,877657.38,2053.96,324525.68,0.00,0.00,0.00,0.00,0.00),('1','113','823','157299',3125541,'2329','356',395303.61,395303.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157299',3125542,'2330','356',721282.42,721282.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157299',3125543,'2331','356',322107.95,324252.02,2144.07,338763.06,0.00,0.00,0.00,0.00,0.00),('1','113','823','157299',3125544,'2332','356',157245.82,157245.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157299',3125545,'2333','356',785354.60,787047.54,1692.94,267484.52,0.00,0.00,0.00,0.00,0.00),('1','113','823','157299',3125546,'2334','356',270110.93,270110.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157299',3125547,'2335','356',565419.54,565419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157299',3125548,'2336','356',210734.50,212181.93,1447.43,228693.94,0.00,0.00,0.00,0.00,0.00),('1','113','823','157299',3125549,'2337','356',397275.77,397275.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157299',3125550,'2338','357',659808.78,660669.78,861.00,154980.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157299',3125551,'2339','357',1687708.01,1689454.17,1746.16,314308.80,0.00,0.00,0.00,0.00,0.00),('1','113','825','157299',3125552,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157299',3125553,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157302',3125568,'2326','356',855631.62,857732.14,2100.52,331882.16,0.00,0.00,0.00,0.00,0.00),('1','113','823','157302',3125569,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157302',3125570,'2328','356',877657.38,877657.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157302',3125571,'2329','356',395303.61,397335.37,2031.76,321018.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','157302',3125572,'2330','356',721282.42,721282.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157302',3125573,'2331','356',324252.02,325891.67,1639.65,259064.70,0.00,0.00,0.00,0.00,0.00),('1','113','823','157302',3125574,'2332','356',157245.82,159301.81,2055.99,324846.42,0.00,0.00,0.00,0.00,0.00),('1','113','823','157302',3125575,'2333','356',787047.54,787047.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157302',3125576,'2334','356',270110.93,270110.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157302',3125577,'2335','356',565419.54,567048.62,1629.08,257394.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','157302',3125578,'2336','356',212181.93,213448.26,1266.33,200080.14,0.00,0.00,0.00,0.00,0.00),('1','113','823','157302',3125579,'2337','356',397275.77,397275.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157302',3125580,'2338','357',660669.78,661557.57,887.79,159802.20,0.00,0.00,0.00,0.00,0.00),('1','113','824','157302',3125581,'2339','357',1689454.17,1692934.24,3480.07,626412.60,0.00,0.00,0.00,0.00,0.00),('1','113','825','157302',3125582,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157302',3125583,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157305',3125605,'2326','356',857732.14,860095.56,2363.42,373420.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','157305',3125606,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157305',3125607,'2328','356',877657.38,877814.97,157.59,24899.22,0.00,0.00,0.00,0.00,0.00),('1','113','823','157305',3125608,'2329','356',397335.37,397695.63,360.26,56921.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','157305',3125609,'2330','356',721282.42,721445.19,162.77,25717.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','157305',3125610,'2331','356',325891.67,328334.94,2443.27,386036.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','157305',3125611,'2332','356',159301.81,159509.78,207.97,32859.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','157305',3125612,'2333','356',787047.54,787047.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157305',3125613,'2334','356',270110.93,270110.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157305',3125614,'2335','356',567048.62,567048.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157305',3125615,'2336','356',213448.26,215423.19,1964.93,310458.94,0.00,0.00,10.00,0.00,0.00),('1','113','823','157305',3125616,'2337','356',397275.77,397396.44,100.67,15905.86,0.00,0.00,20.00,0.00,0.00),('1','113','824','157305',3125617,'2338','357',661557.57,662030.14,472.57,85062.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','157305',3125618,'2339','357',1692934.24,1695380.39,2436.15,438507.00,0.00,0.00,10.00,0.00,0.00),('1','113','825','157305',3125619,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157305',3125620,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157309',3125667,'2326','356',860095.56,862427.04,2331.48,368373.84,0.00,0.00,0.00,0.00,0.00),('1','113','823','157309',3125668,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157309',3125669,'2328','356',877814.97,879651.06,1836.09,290102.22,0.00,0.00,0.00,0.00,0.00),('1','113','823','157309',3125670,'2329','356',397695.63,397695.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157309',3125671,'2330','356',721445.19,721445.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157309',3125672,'2331','356',328334.94,330138.45,1803.51,284954.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','157309',3125673,'2332','356',159509.78,159509.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157309',3125674,'2333','356',787047.54,788681.82,1634.28,258216.24,0.00,0.00,0.00,0.00,0.00),('1','113','823','157309',3125675,'2334','356',270110.93,271835.58,1724.65,272494.70,0.00,0.00,0.00,0.00,0.00),('1','113','823','157309',3125676,'2335','356',567048.62,567048.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157309',3125677,'2336','356',215423.19,216847.75,1424.56,225080.48,0.00,0.00,0.00,0.00,0.00),('1','113','823','157309',3125678,'2337','356',397396.44,397396.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157309',3125679,'2338','357',662030.14,662240.38,210.24,37843.20,0.00,0.00,0.00,0.00,0.00),('1','113','824','157309',3125680,'2339','357',1695380.39,1699325.44,3945.05,710109.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157309',3125681,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157309',3125682,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157514',3128993,'2326','356',862427.04,864241.87,1814.83,286743.14,0.00,0.00,0.00,0.00,0.00),('1','113','823','157514',3128994,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157514',3128995,'2328','356',879651.06,879870.88,219.82,34731.56,0.00,0.00,0.00,0.00,0.00),('1','113','823','157514',3128996,'2329','356',397695.63,397709.24,13.61,2150.38,0.00,0.00,0.00,0.00,0.00),('1','113','823','157514',3128997,'2330','356',721445.19,723441.33,1996.14,315390.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','157514',3128998,'2331','356',330138.45,330138.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157514',3128999,'2332','356',159509.78,159509.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157514',3129000,'2333','356',788681.82,790301.27,1619.45,255873.10,0.00,0.00,0.00,0.00,0.00),('1','113','823','157514',3129001,'2334','356',271835.58,272661.78,826.20,130539.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','157514',3129002,'2335','356',567048.62,567048.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157514',3129003,'2336','356',216847.75,216847.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157514',3129004,'2337','356',397396.44,398807.47,1411.03,222942.74,0.00,0.00,0.00,0.00,0.00),('1','113','824','157514',3129005,'2338','357',662240.38,662795.40,555.02,99903.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','157514',3129006,'2339','357',1699325.44,1700798.88,1473.44,265219.20,0.00,0.00,0.00,0.00,0.00),('1','113','825','157514',3129007,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157514',3129008,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157517',3129040,'2326','356',864241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157517',3129041,'2327','356',468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157517',3129042,'2328','356',879870.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157517',3129043,'2329','356',397709.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157517',3129044,'2330','356',723441.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157517',3129045,'2331','356',330138.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157517',3129046,'2332','356',159509.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157517',3129047,'2333','356',790301.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157517',3129048,'2334','356',272661.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157517',3129049,'2335','356',567048.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157517',3129050,'2336','356',216847.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157517',3129051,'2337','356',398807.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157517',3129052,'2338','357',662795.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157517',3129053,'2339','357',1700798.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157517',3129054,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157517',3129055,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157519',3129078,'2326','356',864241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157519',3129079,'2327','356',468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157519',3129080,'2328','356',879870.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157519',3129081,'2329','356',397709.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157519',3129082,'2330','356',723441.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157519',3129083,'2331','356',330138.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157519',3129084,'2332','356',159509.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157519',3129085,'2333','356',790301.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157519',3129086,'2334','356',272661.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157519',3129087,'2335','356',567048.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157519',3129088,'2336','356',216847.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157519',3129089,'2337','356',398807.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157519',3129090,'2338','357',662795.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157519',3129091,'2339','357',1700798.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157519',3129092,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157519',3129093,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157520',3129094,'2326','356',864241.87,866478.78,2236.91,353431.78,0.00,0.00,0.00,0.00,0.00),('1','113','823','157520',3129095,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157520',3129096,'2328','356',879870.88,881795.04,1924.16,304017.28,0.00,0.00,0.00,0.00,0.00),('1','113','823','157520',3129097,'2329','356',397709.24,397709.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157520',3129098,'2330','356',723441.33,723441.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157520',3129099,'2331','356',330138.45,331639.30,1500.85,237134.30,0.00,0.00,0.00,0.00,0.00),('1','113','823','157520',3129100,'2332','356',159509.78,161599.30,2089.52,330144.16,0.00,0.00,0.00,0.00,0.00),('1','113','823','157520',3129101,'2333','356',790301.27,790301.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157520',3129102,'2334','356',272661.78,272661.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157520',3129103,'2335','356',567048.62,568038.65,990.03,156424.74,0.00,0.00,0.00,0.00,0.00),('1','113','823','157520',3129104,'2336','356',216847.75,218597.22,1749.47,276416.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','157520',3129105,'2337','356',398807.47,398807.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157520',3129106,'2338','357',662795.40,664197.97,1402.57,242644.61,0.00,0.00,0.00,0.00,0.00),('1','113','824','157520',3129107,'2339','357',1700798.88,1702732.51,1933.63,334517.99,0.00,0.00,0.00,0.00,0.00),('1','113','825','157520',3129108,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157520',3129109,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157526',3129201,'2326','356',866478.78,867695.73,1216.95,192278.10,0.00,0.00,0.00,0.00,0.00),('1','113','823','157526',3129202,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157526',3129203,'2328','356',881795.04,881795.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157526',3129204,'2329','356',397709.24,399306.94,1597.70,252436.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','157526',3129205,'2330','356',723441.33,723441.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157526',3129206,'2331','356',331639.30,333137.61,1498.31,236732.98,0.00,0.00,0.00,0.00,0.00),('1','113','823','157526',3129207,'2332','356',161599.30,163025.94,1426.64,225409.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','157526',3129208,'2333','356',790301.27,790301.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157526',3129209,'2334','356',272661.78,272661.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157526',3129210,'2335','356',568038.65,569444.86,1406.21,222181.18,0.00,0.00,0.00,0.00,0.00),('1','113','823','157526',3129211,'2336','356',218597.22,218597.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157526',3129212,'2337','356',398807.47,399309.89,502.42,79382.36,0.00,0.00,0.00,0.00,0.00),('1','113','824','157526',3129213,'2338','357',664197.97,665057.32,859.35,148667.55,0.00,0.00,0.00,0.00,0.00),('1','113','824','157526',3129214,'2339','357',1702732.51,1703177.78,445.27,77031.71,0.00,0.00,0.00,0.00,0.00),('1','113','825','157526',3129215,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157526',3129216,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157528',3129239,'2326','356',867695.73,869865.16,2169.43,342769.94,0.00,0.00,0.00,0.00,0.00),('1','113','823','157528',3129240,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157528',3129241,'2328','356',881795.04,883685.24,1890.20,298651.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','157528',3129242,'2329','356',399306.94,399306.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157528',3129243,'2330','356',723441.33,723441.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157528',3129244,'2331','356',333137.61,335227.53,2089.92,330207.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','157528',3129245,'2332','356',163025.94,164160.60,1134.66,179276.28,0.00,0.00,0.00,0.00,0.00),('1','113','823','157528',3129246,'2333','356',790301.27,790301.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157528',3129247,'2334','356',272661.78,272661.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157528',3129248,'2335','356',569444.86,571357.34,1912.48,302171.84,0.00,0.00,0.00,0.00,0.00),('1','113','823','157528',3129249,'2336','356',218597.22,218597.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157528',3129250,'2337','356',399309.89,399309.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157528',3129251,'2338','357',665057.32,665488.15,430.83,74533.59,0.00,0.00,0.00,0.00,0.00),('1','113','824','157528',3129252,'2339','357',1703177.78,1706385.67,3207.89,554964.97,0.00,0.00,0.00,0.00,0.00),('1','113','825','157528',3129253,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157528',3129254,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157559',3129889,'2326','356',869865.16,871969.02,2103.86,332409.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','157559',3129890,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157559',3129891,'2328','356',883685.24,883685.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157559',3129892,'2329','356',399306.94,399306.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157559',3129893,'2330','356',723441.33,723441.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157559',3129894,'2331','356',335227.53,335227.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157559',3129895,'2332','356',164160.60,165825.38,1664.78,263035.24,0.00,0.00,0.00,0.00,0.00),('1','113','823','157559',3129896,'2333','356',790301.27,790302.85,1.58,249.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','157559',3129897,'2334','356',272661.78,272661.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157559',3129898,'2335','356',571357.34,572919.68,1562.34,246849.72,0.00,0.00,0.00,0.00,0.00),('1','113','823','157559',3129899,'2336','356',218597.22,220371.78,1774.56,280380.48,0.00,0.00,0.00,0.00,0.00),('1','113','823','157559',3129900,'2337','356',399309.89,399309.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157559',3129901,'2338','357',665488.15,667367.97,1879.82,325208.86,0.00,0.00,0.00,0.00,0.00),('1','113','824','157559',3129902,'2339','357',1706385.67,1709360.63,2974.96,514668.08,0.00,0.00,0.00,0.00,0.00),('1','113','825','157559',3129903,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157559',3129904,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157565',3130006,'2326','356',871969.02,874365.58,2396.56,378656.48,0.00,0.00,0.00,0.00,0.00),('1','113','823','157565',3130007,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157565',3130008,'2328','356',883685.24,886006.32,2321.08,366730.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','157565',3130009,'2329','356',399306.94,399306.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157565',3130010,'2330','356',723441.33,723441.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157565',3130011,'2331','356',335227.53,337163.40,1935.87,305867.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','157565',3130012,'2332','356',165825.38,165845.38,20.00,3160.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157565',3130013,'2333','356',790302.85,790302.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157565',3130014,'2334','356',272661.78,272661.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157565',3130015,'2335','356',572919.68,574506.00,1586.32,250638.56,0.00,0.00,0.00,0.00,0.00),('1','113','823','157565',3130016,'2336','356',220371.78,221828.34,1456.56,230136.48,0.00,0.00,0.00,0.00,0.00),('1','113','823','157565',3130017,'2337','356',399309.89,399309.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157565',3130018,'2338','357',667367.97,667370.29,2.32,401.36,0.00,0.00,0.00,0.00,0.00),('1','113','824','157565',3130019,'2339','357',1709360.63,1711625.63,2265.00,391845.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157565',3130020,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157565',3130021,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157627',3131351,'2326','356',874365.58,876049.36,1683.78,266037.24,0.00,0.00,0.00,0.00,0.00),('1','113','823','157627',3131352,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157627',3131353,'2328','356',886006.32,887827.25,1820.93,287706.94,0.00,0.00,0.00,0.00,0.00),('1','113','823','157627',3131354,'2329','356',399306.94,399306.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157627',3131355,'2330','356',723441.33,723441.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157627',3131356,'2331','356',337163.40,338534.61,1371.21,216651.18,0.00,0.00,0.00,0.00,0.00),('1','113','823','157627',3131357,'2332','356',165845.38,167084.43,1239.05,195769.90,0.00,0.00,0.00,0.00,0.00),('1','113','823','157627',3131358,'2333','356',790302.85,790302.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157627',3131359,'2334','356',272661.78,272661.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157627',3131360,'2335','356',574506.00,575866.15,1360.15,214903.70,0.00,0.00,0.00,0.00,0.00),('1','113','823','157627',3131361,'2336','356',221828.34,222749.26,920.92,145505.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','157627',3131362,'2337','356',399309.89,399309.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157627',3131363,'2338','357',667370.29,668381.25,1010.96,174896.08,0.00,0.00,0.00,0.00,0.00),('1','113','824','157627',3131364,'2339','357',1711625.63,1713551.02,1925.39,333092.47,0.00,0.00,0.00,0.00,0.00),('1','113','825','157627',3131365,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157627',3131366,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157628',3131367,'2326','356',876049.36,878007.43,1958.07,309375.06,0.00,0.00,0.00,0.00,0.00),('1','113','823','157628',3131368,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157628',3131369,'2328','356',887827.25,888002.43,175.18,27678.44,0.00,0.00,0.00,0.00,0.00),('1','113','823','157628',3131370,'2329','356',399306.94,400985.83,1678.89,265264.62,0.00,0.00,0.00,0.00,0.00),('1','113','823','157628',3131371,'2330','356',723441.33,725174.19,1732.86,273791.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','157628',3131372,'2331','356',338534.61,338534.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157628',3131373,'2332','356',167084.43,167084.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157628',3131374,'2333','356',790302.85,791607.82,1304.97,206185.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','157628',3131375,'2334','356',272661.78,272661.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157628',3131376,'2335','356',575866.15,577243.92,1377.77,217687.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','157628',3131377,'2336','356',222749.26,222749.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157628',3131378,'2337','356',399309.89,400620.22,1310.33,207032.14,0.00,0.00,0.00,0.00,0.00),('1','113','824','157628',3131379,'2338','357',668381.25,669393.02,1011.77,175036.21,0.00,0.00,0.00,0.00,0.00),('1','113','824','157628',3131380,'2339','357',1713551.02,1717897.61,4346.59,751960.07,0.00,0.00,0.00,0.00,0.00),('1','113','825','157628',3131381,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157628',3131382,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157632',3131419,'2326','356',878007.43,879560.41,1552.98,245370.84,0.00,0.00,0.00,0.00,0.00),('1','113','823','157632',3131420,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157632',3131421,'2328','356',888002.43,889564.30,1561.87,246775.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','157632',3131422,'2329','356',400985.83,400985.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157632',3131423,'2330','356',725174.19,726906.70,1732.51,273736.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','157632',3131424,'2331','356',338534.61,338534.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157632',3131425,'2332','356',167084.43,168268.94,1184.51,187152.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','157632',3131426,'2333','356',791607.82,791607.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157632',3131427,'2334','356',272661.78,272661.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157632',3131428,'2335','356',577243.92,578312.85,1058.93,167310.94,0.00,0.00,10.00,0.00,0.00),('1','113','823','157632',3131429,'2336','356',222749.26,223381.57,632.31,99904.98,0.00,0.00,0.00,0.00,0.00),('1','113','823','157632',3131430,'2337','356',400620.22,400620.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157632',3131431,'2338','357',669393.02,673591.84,4188.82,724665.86,0.00,0.00,10.00,0.00,0.00),('1','113','824','157632',3131432,'2339','357',1717897.61,1721910.91,4013.30,694300.90,0.00,0.00,0.00,0.00,0.00),('1','113','825','157632',3131433,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157632',3131434,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157634',3131457,'2326','356',879560.41,881746.21,2185.80,345356.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','157634',3131458,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157634',3131459,'2328','356',889564.30,889564.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157634',3131460,'2329','356',400985.83,402582.75,1596.92,252313.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','157634',3131461,'2330','356',726906.70,728468.56,1561.86,246773.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','157634',3131462,'2331','356',338534.61,338534.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157634',3131463,'2332','356',168268.94,169600.56,1331.62,210395.96,0.00,0.00,0.00,0.00,0.00),('1','113','823','157634',3131464,'2333','356',791607.82,791607.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157634',3131465,'2334','356',272661.78,273735.20,1073.42,169600.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','157634',3131466,'2335','356',578312.85,578489.21,176.36,27864.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','157634',3131467,'2336','356',223381.57,224509.55,1127.98,178220.84,0.00,0.00,0.00,0.00,0.00),('1','113','823','157634',3131468,'2337','356',400620.22,400698.35,78.13,12344.54,0.00,0.00,0.00,0.00,0.00),('1','113','824','157634',3131469,'2338','357',673591.84,675148.03,1556.19,269220.87,0.00,0.00,0.00,0.00,0.00),('1','113','824','157634',3131470,'2339','357',1721910.91,1726413.34,4502.43,778920.39,0.00,0.00,0.00,0.00,0.00),('1','113','825','157634',3131471,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157634',3131472,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157681',3132158,'2326','356',881746.21,883365.13,1618.92,255789.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','157681',3132159,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157681',3132160,'2328','356',889564.30,891316.49,1752.19,276846.02,0.00,0.00,0.00,0.00,0.00),('1','113','823','157681',3132161,'2329','356',402582.75,402582.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157681',3132162,'2330','356',728468.56,728468.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157681',3132163,'2331','356',338534.61,339775.56,1240.95,196070.10,0.00,0.00,0.00,0.00,0.00),('1','113','823','157681',3132164,'2332','356',169600.56,170958.16,1357.60,214500.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','157681',3132165,'2333','356',791607.82,791607.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157681',3132166,'2334','356',273735.20,273735.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157681',3132167,'2335','356',578489.21,579442.52,953.31,150622.98,0.00,0.00,0.00,0.00,0.00),('1','113','823','157681',3132168,'2336','356',224509.55,225286.67,777.12,122784.96,0.00,0.00,0.00,0.00,0.00),('1','113','823','157681',3132169,'2337','356',400698.35,400698.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157681',3132170,'2338','357',675148.03,676178.33,1030.30,178241.90,0.00,0.00,0.00,0.00,0.00),('1','113','824','157681',3132171,'2339','357',1726413.34,1728661.83,2248.49,388988.77,0.00,0.00,0.00,0.00,0.00),('1','113','825','157681',3132172,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157681',3132173,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157687',3132258,'2326','356',883365.13,885766.42,2401.29,379403.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','157687',3132259,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157687',3132260,'2328','356',891316.49,891316.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157687',3132261,'2329','356',402582.75,404329.33,1746.58,275959.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','157687',3132262,'2330','356',728468.56,730314.67,1846.11,291685.38,0.00,0.00,0.00,0.00,0.00),('1','113','823','157687',3132263,'2331','356',339775.56,339775.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157687',3132264,'2332','356',170958.16,170958.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157687',3132265,'2333','356',791607.82,793252.29,1644.47,259826.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','157687',3132266,'2334','356',273735.20,275248.73,1513.53,239137.74,0.00,0.00,0.00,0.00,0.00),('1','113','823','157687',3132267,'2335','356',579442.52,579442.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157687',3132268,'2336','356',225286.67,225293.95,7.28,1150.24,0.00,0.00,0.00,0.00,0.00),('1','113','823','157687',3132269,'2337','356',400698.35,400709.62,0.00,0.00,0.00,0.00,11.27,0.00,0.00),('1','113','824','157687',3132270,'2338','357',676178.33,678729.72,2551.39,441390.47,0.00,0.00,0.00,0.00,0.00),('1','113','824','157687',3132271,'2339','357',1728661.83,1731479.72,2817.89,487494.97,0.00,0.00,0.00,0.00,0.00),('1','113','825','157687',3132272,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157687',3132273,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157693',3132370,'2326','356',885766.42,887460.85,1694.43,267719.94,0.00,0.00,0.00,0.00,0.00),('1','113','823','157693',3132371,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157693',3132372,'2328','356',891316.49,892671.64,1355.15,214113.70,0.00,0.00,0.00,0.00,0.00),('1','113','823','157693',3132373,'2329','356',404329.33,404446.05,116.72,18441.76,0.00,0.00,0.00,0.00,0.00),('1','113','823','157693',3132374,'2330','356',730314.67,730314.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157693',3132375,'2331','356',339775.56,340899.70,1124.14,177614.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','157693',3132376,'2332','356',170958.16,172503.02,1544.86,244087.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','157693',3132377,'2333','356',793252.29,793252.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157693',3132378,'2334','356',275248.73,276503.28,1254.55,198218.90,0.00,0.00,0.00,0.00,0.00),('1','113','823','157693',3132379,'2335','356',579442.52,579442.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157693',3132380,'2336','356',225293.95,225907.53,613.58,96945.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','157693',3132381,'2337','356',400709.62,400709.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157693',3132382,'2338','357',678729.72,681425.82,2696.10,466425.30,0.00,0.00,0.00,0.00,0.00),('1','113','824','157693',3132383,'2339','357',1731479.72,1736505.73,5026.01,869499.73,0.00,0.00,0.00,0.00,0.00),('1','113','825','157693',3132384,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157693',3132385,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157695',3132398,'2326','356',887460.85,889959.06,2498.21,394717.18,0.00,0.00,0.00,0.00,0.00),('1','113','823','157695',3132399,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157695',3132400,'2328','356',892671.64,895272.34,2600.70,410910.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','157695',3132401,'2329','356',404446.05,404446.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157695',3132402,'2330','356',730314.67,732661.03,2346.36,370724.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','157695',3132403,'2331','356',340899.70,340899.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157695',3132404,'2332','356',172503.02,172503.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157695',3132405,'2333','356',793252.29,793252.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157695',3132406,'2334','356',276503.28,276934.19,430.91,68083.78,0.00,0.00,0.00,0.00,0.00),('1','113','823','157695',3132407,'2335','356',579442.52,579526.08,83.56,13202.48,0.00,0.00,0.00,0.00,0.00),('1','113','823','157695',3132408,'2336','356',225907.53,225907.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157695',3132409,'2337','356',400709.62,402493.99,1784.37,281930.46,0.00,0.00,0.00,0.00,0.00),('1','113','824','157695',3132410,'2338','357',681425.82,682354.39,928.57,160642.61,0.00,0.00,0.00,0.00,0.00),('1','113','824','157695',3132411,'2339','357',1736505.73,1738835.05,2329.32,402972.36,0.00,0.00,0.00,0.00,0.00),('1','113','825','157695',3132412,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157695',3132413,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157703',3132514,'2326','356',889959.06,891939.96,1980.90,312982.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','157703',3132515,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157703',3132516,'2328','356',895272.34,896791.60,1519.26,240043.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','157703',3132517,'2329','356',404446.05,404446.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157703',3132518,'2330','356',732661.03,732661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157703',3132519,'2331','356',340899.70,340899.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157703',3132520,'2332','356',172503.02,173976.81,1473.79,232858.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','157703',3132521,'2333','356',793252.29,793252.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157703',3132522,'2334','356',276934.19,276934.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157703',3132523,'2335','356',579526.08,581034.61,1508.53,238347.74,0.00,0.00,0.00,0.00,0.00),('1','113','823','157703',3132524,'2336','356',225907.53,227016.76,1109.23,175258.34,0.00,0.00,0.00,0.00,0.00),('1','113','823','157703',3132525,'2337','356',402493.99,402493.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157703',3132526,'2338','357',682354.39,683045.97,691.58,119643.34,0.00,0.00,0.00,0.00,0.00),('1','113','824','157703',3132527,'2339','357',1738835.05,1740834.11,1999.06,345837.38,0.00,0.00,0.00,0.00,0.00),('1','113','825','157703',3132528,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157703',3132529,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157751',3133524,'2326','356',891939.96,891939.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157751',3133525,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157751',3133526,'2328','356',896791.60,896791.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157751',3133527,'2329','356',404446.05,406764.93,2318.88,366383.04,0.00,0.00,0.00,0.00,0.00),('1','113','823','157751',3133528,'2330','356',732661.03,732661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157751',3133529,'2331','356',340899.70,343208.40,2308.70,364774.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','157751',3133530,'2332','356',173976.81,173976.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157751',3133531,'2333','356',793252.29,795151.75,1899.46,300114.68,0.00,0.00,0.00,0.00,0.00),('1','113','823','157751',3133532,'2334','356',276934.19,276934.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157751',3133533,'2335','356',581034.61,582548.60,1493.32,235944.56,0.00,0.00,20.67,0.00,0.00),('1','113','823','157751',3133534,'2336','356',227016.76,227016.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157751',3133535,'2337','356',402493.99,403617.59,1102.93,174262.94,0.00,0.00,20.67,0.00,0.00),('1','113','824','157751',3133536,'2338','357',683045.97,684742.51,1696.54,293501.42,0.00,0.00,0.00,0.00,0.00),('1','113','824','157751',3133537,'2339','357',1740834.11,1743674.74,2840.63,491428.99,0.00,0.00,0.00,0.00,0.00),('1','113','825','157751',3133538,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157751',3133539,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157765',3133801,'2326','356',891939.96,893842.91,1902.95,300666.10,0.00,0.00,0.00,0.00,0.00),('1','113','823','157765',3133802,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157765',3133803,'2328','356',896791.60,898782.63,1991.03,314582.74,0.00,0.00,0.00,0.00,0.00),('1','113','823','157765',3133804,'2329','356',406764.93,406764.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157765',3133805,'2330','356',732661.03,732661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157765',3133806,'2331','356',343208.40,343208.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157765',3133807,'2332','356',173976.81,175487.46,1510.65,238682.70,0.00,0.00,0.00,0.00,0.00),('1','113','823','157765',3133808,'2333','356',795151.75,795151.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157765',3133809,'2334','356',276934.19,276934.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157765',3133810,'2335','356',582548.60,583695.39,1146.79,181192.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','157765',3133811,'2336','356',227016.76,227892.89,876.13,138428.54,0.00,0.00,0.00,0.00,0.00),('1','113','823','157765',3133812,'2337','356',403617.59,403617.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157765',3133813,'2338','357',684742.51,685781.62,1039.11,179766.03,0.00,0.00,0.00,0.00,0.00),('1','113','824','157765',3133814,'2339','357',1743674.74,1746720.85,3046.11,526977.03,0.00,0.00,0.00,0.00,0.00),('1','113','825','157765',3133815,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157765',3133816,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157855',3135298,'2326','356',893842.91,895067.66,1224.75,193510.50,0.00,0.00,0.00,0.00,0.00),('1','113','823','157855',3135299,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157855',3135300,'2328','356',898782.63,898782.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157855',3135301,'2329','356',406764.93,407682.01,917.08,144898.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','157855',3135302,'2330','356',732661.03,732661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157855',3135303,'2331','356',343208.40,345025.31,1816.91,287071.78,0.00,0.00,0.00,0.00,0.00),('1','113','823','157855',3135304,'2332','356',175487.46,175487.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157855',3135305,'2333','356',795151.75,797085.52,1933.77,305535.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','157855',3135306,'2334','356',276934.19,278619.52,1685.33,266282.14,0.00,0.00,0.00,0.00,0.00),('1','113','823','157855',3135307,'2335','356',583695.39,583695.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157855',3135308,'2336','356',227892.89,227892.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157855',3135309,'2337','356',403617.59,405028.44,1404.77,221953.66,0.00,0.00,6.08,0.00,0.00),('1','113','824','157855',3135310,'2338','357',685781.62,687891.49,2109.87,365007.51,0.00,0.00,0.00,0.00,0.00),('1','113','824','157855',3135311,'2339','357',1746720.85,1750503.42,3782.57,654384.61,0.00,0.00,0.00,0.00,0.00),('1','113','825','157855',3135312,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157855',3135313,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157857',3135336,'2326','356',895067.66,896565.64,1497.98,236680.84,0.00,0.00,0.00,0.00,0.00),('1','113','823','157857',3135337,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157857',3135338,'2328','356',898782.63,900178.75,1396.12,220586.96,0.00,0.00,0.00,0.00,0.00),('1','113','823','157857',3135339,'2329','356',407682.01,407682.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157857',3135340,'2330','356',732661.03,732661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157857',3135341,'2331','356',345025.31,346038.57,1013.26,160095.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','157857',3135342,'2332','356',175487.46,176542.64,1055.18,166718.44,0.00,0.00,0.00,0.00,0.00),('1','113','823','157857',3135343,'2333','356',797085.52,797085.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157857',3135344,'2334','356',278619.52,278620.78,1.26,199.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','157857',3135345,'2335','356',583695.39,584373.03,677.64,107067.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','157857',3135346,'2336','356',227892.89,228329.49,436.60,68982.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','157857',3135347,'2337','356',405028.44,405028.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157857',3135348,'2338','357',687891.49,687966.75,75.26,13019.98,0.00,0.00,0.00,0.00,0.00),('1','113','824','157857',3135349,'2339','357',1750503.42,1752843.86,2340.44,404896.12,0.00,0.00,0.00,0.00,0.00),('1','113','825','157857',3135350,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157857',3135351,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157864',3135482,'2326','356',896565.64,898681.11,2115.47,334244.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','157864',3135483,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157864',3135484,'2328','356',900178.75,900178.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157864',3135485,'2329','356',407682.01,407682.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157864',3135486,'2330','356',732661.03,734483.27,1822.24,287913.92,0.00,0.00,0.00,0.00,0.00),('1','113','823','157864',3135487,'2331','356',346038.57,346038.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157864',3135488,'2332','356',176542.64,176542.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157864',3135489,'2333','356',797085.52,798689.78,1604.26,253473.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','157864',3135490,'2334','356',278620.78,278620.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157864',3135491,'2335','356',584373.03,585859.89,1486.86,234923.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','157864',3135492,'2336','356',228329.49,229262.27,932.78,147379.24,0.00,0.00,0.00,0.00,0.00),('1','113','823','157864',3135493,'2337','356',405028.44,405028.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157864',3135494,'2338','357',687966.75,688452.37,485.62,84012.26,0.00,0.00,0.00,0.00,0.00),('1','113','824','157864',3135495,'2339','357',1752843.86,1755935.94,3092.08,534929.84,0.00,0.00,0.00,0.00,0.00),('1','113','825','157864',3135496,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157864',3135497,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157867',3135582,'2326','356',898681.11,898681.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157867',3135583,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157867',3135584,'2328','356',900178.75,900178.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157867',3135585,'2329','356',407682.01,409810.96,2128.95,336374.10,0.00,0.00,0.00,0.00,0.00),('1','113','823','157867',3135586,'2330','356',734483.27,734486.42,3.15,497.70,0.00,0.00,0.00,0.00,0.00),('1','113','823','157867',3135587,'2331','356',346038.57,346038.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157867',3135588,'2332','356',176542.64,178503.53,1960.89,309820.62,0.00,0.00,0.00,0.00,0.00),('1','113','823','157867',3135589,'2333','356',798689.78,798689.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157867',3135590,'2334','356',278620.78,278620.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157867',3135591,'2335','356',585859.89,587338.90,1479.01,233683.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','157867',3135592,'2336','356',229262.27,230897.17,1634.90,258314.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','157867',3135593,'2337','356',405028.44,405028.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157867',3135594,'2338','357',688452.37,690382.87,1930.50,333976.50,0.00,0.00,0.00,0.00,0.00),('1','113','824','157867',3135595,'2339','357',1755935.94,1758163.30,2227.36,385333.28,0.00,0.00,0.00,0.00,0.00),('1','113','825','157867',3135596,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157867',3135597,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157874',3135800,'2326','356',898681.11,900436.62,1755.51,277370.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','157874',3135801,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157874',3135802,'2328','356',900178.75,901619.85,1441.10,227693.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','157874',3135803,'2329','356',409810.96,410603.55,792.59,125229.22,0.00,0.00,0.00,0.00,0.00),('1','113','823','157874',3135804,'2330','356',734486.42,734486.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157874',3135805,'2331','356',346038.57,347611.52,1572.95,248526.10,0.00,0.00,0.00,0.00,0.00),('1','113','823','157874',3135806,'2332','356',178503.53,178503.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157874',3135807,'2333','356',798689.78,799908.02,1218.24,192481.92,0.00,0.00,0.00,0.00,0.00),('1','113','823','157874',3135808,'2334','356',278620.78,278620.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157874',3135809,'2335','356',587338.90,588346.73,1007.83,159237.14,0.00,0.00,0.00,0.00,0.00),('1','113','823','157874',3135810,'2336','356',230897.17,230897.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157874',3135811,'2337','356',405028.44,405497.35,468.91,74087.78,0.00,0.00,0.00,0.00,0.00),('1','113','824','157874',3135812,'2338','357',690382.87,691403.68,1020.81,176600.13,0.00,0.00,0.00,0.00,0.00),('1','113','824','157874',3135813,'2339','357',1758163.30,1760332.42,2169.12,375257.76,0.00,0.00,0.00,0.00,0.00),('1','113','825','157874',3135814,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157874',3135815,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157877',3135856,'2326','356',900436.62,902760.55,2323.93,367180.94,0.00,0.00,0.00,0.00,0.00),('1','113','823','157877',3135857,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157877',3135858,'2328','356',901619.85,901619.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157877',3135859,'2329','356',410603.55,410603.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157877',3135860,'2330','356',734486.42,736190.93,1704.51,269312.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','157877',3135861,'2331','356',347611.52,347611.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157877',3135862,'2332','356',178503.53,180145.36,1641.83,259409.14,0.00,0.00,0.00,0.00,0.00),('1','113','823','157877',3135863,'2333','356',799908.02,799908.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157877',3135864,'2334','356',278620.78,278620.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157877',3135865,'2335','356',588346.73,589755.15,1408.42,222530.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','157877',3135866,'2336','356',230897.17,231284.81,387.64,61247.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','157877',3135867,'2337','356',405497.35,405497.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157877',3135868,'2338','357',691403.68,691887.24,483.56,83655.88,0.00,0.00,0.00,0.00,0.00),('1','113','824','157877',3135869,'2339','357',1760332.42,1763065.81,2733.39,472876.47,0.00,0.00,0.00,0.00,0.00),('1','113','825','157877',3135870,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157877',3135871,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157880',3135932,'2326','356',902760.55,904510.36,1749.81,276469.98,0.00,0.00,0.00,0.00,0.00),('1','113','823','157880',3135933,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157880',3135934,'2328','356',901619.85,903457.45,1837.60,290340.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','157880',3135935,'2329','356',410603.55,410603.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157880',3135936,'2330','356',736190.93,737986.63,1795.70,283720.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','157880',3135937,'2331','356',347611.52,348387.49,775.97,122603.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','157880',3135938,'2332','356',180145.36,181293.14,1147.78,181349.24,0.00,0.00,0.00,0.00,0.00),('1','113','823','157880',3135939,'2333','356',799908.02,799908.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','157880',3135940,'2334','356',278620.78,278620.91,0.13,20.54,0.00,0.00,0.00,0.00,0.00),('1','113','823','157880',3135941,'2335','356',589755.15,590663.70,908.55,143550.90,0.00,0.00,0.00,0.00,0.00),('1','113','823','157880',3135942,'2336','356',231284.81,231988.47,703.66,111178.28,0.00,0.00,0.00,0.00,0.00),('1','113','823','157880',3135943,'2337','356',405497.35,405497.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','157880',3135944,'2338','357',691887.24,692623.97,736.73,127454.29,0.00,0.00,0.00,0.00,0.00),('1','113','824','157880',3135945,'2339','357',1763065.81,1765255.22,2189.41,378767.93,0.00,0.00,0.00,0.00,0.00),('1','113','825','157880',3135946,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','157880',3135947,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158023',3138638,'2326','356',904510.36,905835.69,1325.33,209402.14,0.00,0.00,0.00,0.00,0.00),('1','113','823','158023',3138639,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158023',3138640,'2328','356',903457.45,904742.75,1285.30,203077.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','158023',3138641,'2329','356',410603.55,410603.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158023',3138642,'2330','356',737986.63,737986.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158023',3138643,'2331','356',348387.49,348387.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158023',3138644,'2332','356',181293.14,181293.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158023',3138645,'2333','356',799908.02,800787.09,879.07,138893.06,0.00,0.00,0.00,0.00,0.00),('1','113','823','158023',3138646,'2334','356',278620.91,278620.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158023',3138647,'2335','356',590663.70,591471.27,807.57,127596.06,0.00,0.00,0.00,0.00,0.00),('1','113','823','158023',3138648,'2336','356',231988.47,232547.00,558.53,88247.74,0.00,0.00,0.00,0.00,0.00),('1','113','823','158023',3138649,'2337','356',405497.35,405497.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158023',3138650,'2338','357',692623.97,693979.44,1355.47,234496.31,0.00,0.00,0.00,0.00,0.00),('1','113','824','158023',3138651,'2339','357',1765255.22,1766927.92,1672.70,289377.10,0.00,0.00,0.00,0.00,0.00),('1','113','825','158023',3138652,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158023',3138653,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158026',3138685,'2326','356',905835.69,907287.62,1451.93,229404.94,0.00,0.00,0.00,0.00,0.00),('1','113','823','158026',3138686,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158026',3138687,'2328','356',904742.75,906195.60,1452.85,229550.30,0.00,0.00,0.00,0.00,0.00),('1','113','823','158026',3138688,'2329','356',410603.55,411474.92,871.37,137676.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','158026',3138689,'2330','356',737986.63,737986.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158026',3138690,'2331','356',348387.49,349373.06,985.57,155720.06,0.00,0.00,0.00,0.00,0.00),('1','113','823','158026',3138691,'2332','356',181293.14,182560.99,1267.85,200320.30,0.00,0.00,0.00,0.00,0.00),('1','113','823','158026',3138692,'2333','356',800787.09,800787.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158026',3138693,'2334','356',278620.91,278620.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158026',3138694,'2335','356',591471.27,592597.94,1126.67,178013.86,0.00,0.00,0.00,0.00,0.00),('1','113','823','158026',3138695,'2336','356',232547.00,232555.24,8.24,1301.92,0.00,0.00,0.00,0.00,0.00),('1','113','823','158026',3138696,'2337','356',405497.35,406245.77,748.42,118250.36,0.00,0.00,0.00,0.00,0.00),('1','113','824','158026',3138697,'2338','357',693979.44,693979.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158026',3138698,'2339','357',1766927.92,1767625.77,697.85,120728.05,0.00,0.00,0.00,0.00,0.00),('1','113','825','158026',3138699,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158026',3138700,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158027',3138701,'2326','356',907287.62,908694.09,1406.47,222222.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','158027',3138702,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158027',3138703,'2328','356',906195.60,907508.28,1312.68,207403.44,0.00,0.00,0.00,0.00,0.00),('1','113','823','158027',3138704,'2329','356',411474.92,411474.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158027',3138705,'2330','356',737986.63,738989.07,1002.44,158385.52,0.00,0.00,0.00,0.00,0.00),('1','113','823','158027',3138706,'2331','356',349373.06,349373.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158027',3138707,'2332','356',182560.99,183601.51,1040.52,164402.16,0.00,0.00,0.00,0.00,0.00),('1','113','823','158027',3138708,'2333','356',800787.09,800787.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158027',3138709,'2334','356',278620.91,279509.65,888.74,140420.92,0.00,0.00,0.00,0.00,0.00),('1','113','823','158027',3138710,'2335','356',592597.94,592597.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158027',3138711,'2336','356',232555.24,233236.87,681.63,107697.54,0.00,0.00,0.00,0.00,0.00),('1','113','823','158027',3138712,'2337','356',406245.77,406245.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158027',3138713,'2338','357',693979.44,694429.44,450.00,77850.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158027',3138714,'2339','357',1767625.77,1768092.73,466.96,80784.08,0.00,0.00,0.00,0.00,0.00),('1','113','825','158027',3138715,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158027',3138716,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158141',3140647,'2326','356',908694.09,910344.17,1650.08,260712.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','158141',3140648,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158141',3140649,'2328','356',907508.28,909016.91,1508.63,238363.54,0.00,0.00,0.00,0.00,0.00),('1','113','823','158141',3140650,'2329','356',411474.92,411759.27,284.35,44927.30,0.00,0.00,0.00,0.00,0.00),('1','113','823','158141',3140651,'2330','356',738989.07,739553.39,564.32,89162.56,0.00,0.00,0.00,0.00,0.00),('1','113','823','158141',3140652,'2331','356',349373.06,350438.61,1065.55,168356.90,0.00,0.00,0.00,0.00,0.00),('1','113','823','158141',3140653,'2332','356',183601.51,183601.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158141',3140654,'2333','356',800787.09,801807.67,1020.58,161251.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','158141',3140655,'2334','356',279509.65,280449.13,939.48,148437.84,0.00,0.00,0.00,0.00,0.00),('1','113','823','158141',3140656,'2335','356',592597.94,592597.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158141',3140657,'2336','356',233236.87,233764.16,527.29,83311.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','158141',3140658,'2337','356',406245.77,406245.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158141',3140659,'2338','357',694429.44,694468.35,38.91,6731.43,0.00,0.00,0.00,0.00,0.00),('1','113','824','158141',3140660,'2339','357',1768092.73,1768953.93,861.20,148987.60,0.00,0.00,0.00,0.00,0.00),('1','113','825','158141',3140661,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158141',3140662,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158232',3142612,'2326','356',910344.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158232',3142613,'2327','356',468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158232',3142614,'2328','356',909016.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158232',3142615,'2329','356',411759.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158232',3142616,'2330','356',739553.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158232',3142617,'2331','356',350438.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158232',3142618,'2332','356',183601.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158232',3142619,'2333','356',801807.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158232',3142620,'2334','356',280449.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158232',3142621,'2335','356',592597.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158232',3142622,'2336','356',233764.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158232',3142623,'2337','356',406245.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158232',3142624,'2338','357',694468.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158232',3142625,'2339','357',1768953.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158232',3142626,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158232',3142627,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158234',3142649,'2326','356',910344.17,911761.90,1417.73,226836.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','158234',3142650,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158234',3142651,'2328','356',909016.91,910121.65,1104.74,176758.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','158234',3142652,'2329','356',411759.27,411759.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158234',3142653,'2330','356',739553.39,740681.55,1128.16,180505.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','158234',3142654,'2331','356',350438.61,350438.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158234',3142655,'2332','356',183601.51,183601.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158234',3142656,'2333','356',801807.67,802700.12,892.45,142792.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158234',3142657,'2334','356',280449.13,280449.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158234',3142658,'2335','356',592597.94,593702.48,1104.54,176726.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','158234',3142659,'2336','356',233764.16,233764.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158234',3142660,'2337','356',406245.77,406245.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158234',3142661,'2338','357',694468.35,694980.19,511.84,88548.32,0.00,0.00,0.00,0.00,0.00),('1','113','824','158234',3142662,'2339','357',1768953.93,1770108.82,1154.89,199795.97,0.00,0.00,0.00,0.00,0.00),('1','113','825','158234',3142663,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158234',3142664,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158268',3143110,'2326','356',911761.90,913690.90,1929.00,308640.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158268',3143111,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158268',3143112,'2328','356',910121.65,911961.13,1829.48,292716.80,0.00,0.00,10.00,0.00,0.00),('1','113','823','158268',3143113,'2329','356',411759.27,411759.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158268',3143114,'2330','356',740681.55,740681.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158268',3143115,'2331','356',350438.61,352182.13,1733.52,277363.20,0.00,0.00,10.00,0.00,0.00),('1','113','823','158268',3143116,'2332','356',183601.51,184635.68,1004.17,160667.20,0.00,0.00,30.00,0.00,0.00),('1','113','823','158268',3143117,'2333','356',802700.12,803051.54,341.42,54627.20,0.00,0.00,10.00,0.00,0.00),('1','113','823','158268',3143118,'2334','356',280449.13,280449.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158268',3143119,'2335','356',593702.48,594772.08,1059.60,169536.00,0.00,0.00,10.00,0.00,0.00),('1','113','823','158268',3143120,'2336','356',233764.16,234768.55,974.39,155902.40,0.00,0.00,30.00,0.00,0.00),('1','113','823','158268',3143121,'2337','356',406245.77,406245.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158268',3143122,'2338','357',694980.19,695398.61,348.42,60276.66,0.00,0.00,70.00,0.00,0.00),('1','113','824','158268',3143123,'2339','357',1770108.82,1771431.71,1252.89,216749.97,0.00,0.00,70.00,0.00,0.00),('1','113','825','158268',3143124,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158268',3143125,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158444',3146430,'2326','356',913690.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158444',3146431,'2327','356',468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158444',3146432,'2328','356',911961.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158444',3146433,'2329','356',411759.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158444',3146434,'2330','356',740681.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158444',3146435,'2331','356',352182.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158444',3146436,'2332','356',184635.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158444',3146437,'2333','356',803051.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158444',3146438,'2334','356',280449.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158444',3146439,'2335','356',594772.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158444',3146440,'2336','356',234768.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158444',3146441,'2337','356',406245.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158444',3146442,'2338','357',695398.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158444',3146443,'2339','357',1771431.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158444',3146444,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158444',3146445,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158446',3146469,'2326','356',913690.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158446',3146470,'2327','356',468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158446',3146471,'2328','356',911961.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158446',3146472,'2329','356',411759.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158446',3146473,'2330','356',740681.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158446',3146474,'2331','356',352182.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158446',3146475,'2332','356',184635.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158446',3146476,'2333','356',803051.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158446',3146477,'2334','356',280449.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158446',3146478,'2335','356',594772.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158446',3146479,'2336','356',234768.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158446',3146480,'2337','356',406245.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158446',3146481,'2338','357',695398.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158446',3146482,'2339','357',1771431.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158446',3146483,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158446',3146484,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158448',3146503,'2326','356',913690.90,915541.48,1850.58,296092.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','158448',3146504,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158448',3146505,'2328','356',911961.13,911961.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158448',3146506,'2329','356',411759.27,411759.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158448',3146507,'2330','356',740681.55,740681.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158448',3146508,'2331','356',352182.13,353869.13,1687.00,269920.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158448',3146509,'2332','356',184635.68,184635.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158448',3146510,'2333','356',803051.54,803051.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158448',3146511,'2334','356',280449.13,280449.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158448',3146512,'2335','356',594772.08,595965.84,1193.76,191001.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','158448',3146513,'2336','356',234768.55,235806.66,1038.11,166097.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','158448',3146514,'2337','356',406245.77,406245.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158448',3146515,'2338','357',695398.61,696095.72,697.11,132450.90,0.00,0.00,0.00,0.00,0.00),('1','113','824','158448',3146516,'2339','357',1771431.71,1773051.97,1620.26,307849.40,0.00,0.00,0.00,0.00,0.00),('1','113','825','158448',3146517,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158448',3146518,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158449',3146519,'2326','356',915541.48,916681.26,1139.78,182364.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','158449',3146520,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158449',3146521,'2328','356',911961.13,914096.97,2135.84,341734.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','158449',3146522,'2329','356',411759.27,411759.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158449',3146523,'2330','356',740681.55,740681.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158449',3146524,'2331','356',353869.13,354484.86,615.73,98516.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','158449',3146525,'2332','356',184635.68,186329.30,1683.62,269379.20,0.00,0.00,10.00,0.00,0.00),('1','113','823','158449',3146526,'2333','356',803051.54,803051.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158449',3146527,'2334','356',280449.13,280449.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158449',3146528,'2335','356',595965.84,596591.42,625.58,100092.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','158449',3146529,'2336','356',235806.66,237099.48,1292.82,206851.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','158449',3146530,'2337','356',406245.77,406245.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158449',3146531,'2338','357',696095.72,697550.18,1454.46,276347.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','158449',3146532,'2339','357',1773051.97,1774343.08,1291.11,245310.90,0.00,0.00,0.00,0.00,0.00),('1','113','825','158449',3146533,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158449',3146534,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158539',3148251,'2326','356',916681.26,917299.15,617.89,98862.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','158539',3148252,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158539',3148253,'2328','356',914096.97,915918.06,1821.09,291374.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','158539',3148254,'2329','356',411759.27,411759.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158539',3148255,'2330','356',740681.55,740681.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158539',3148256,'2331','356',354484.86,356109.66,1624.80,259968.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158539',3148257,'2332','356',186329.30,186329.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158539',3148258,'2333','356',803051.54,803051.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158539',3148259,'2334','356',280449.13,280449.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158539',3148260,'2335','356',596591.42,597725.80,1134.38,181500.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','158539',3148261,'2336','356',237099.48,237895.35,795.87,127339.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','158539',3148262,'2337','356',406245.77,406245.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158539',3148263,'2338','357',697550.18,697687.54,137.36,26098.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','158539',3148264,'2339','357',1774343.08,1775778.98,1435.90,272821.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158539',3148265,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158539',3148266,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158666',3150491,'2326','356',917299.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158666',3150492,'2327','356',468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158666',3150493,'2328','356',915918.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158666',3150494,'2329','356',411759.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158666',3150495,'2330','356',740681.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158666',3150496,'2331','356',356109.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158666',3150497,'2332','356',186329.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158666',3150498,'2333','356',803051.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158666',3150499,'2334','356',280449.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158666',3150500,'2335','356',597725.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158666',3150501,'2336','356',237895.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158666',3150502,'2337','356',406245.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158666',3150503,'2338','357',697687.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158666',3150504,'2339','357',1775778.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158666',3150505,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158666',3150506,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158667',3150507,'2326','356',917299.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158667',3150508,'2327','356',468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158667',3150509,'2328','356',915918.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158667',3150510,'2329','356',411759.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158667',3150511,'2330','356',740681.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158667',3150512,'2331','356',356109.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158667',3150513,'2332','356',186329.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158667',3150514,'2333','356',803051.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158667',3150515,'2334','356',280449.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158667',3150516,'2335','356',597725.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158667',3150517,'2336','356',237895.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158667',3150518,'2337','356',406245.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158667',3150519,'2338','357',697687.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158667',3150520,'2339','357',1775778.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158667',3150521,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158667',3150522,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158669',3150539,'2326','356',917299.15,918477.47,1178.32,186174.56,0.00,0.00,0.00,0.00,0.00),('1','113','823','158669',3150540,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158669',3150541,'2328','356',915918.06,917458.77,1540.71,243432.18,0.00,0.00,0.00,0.00,0.00),('1','113','823','158669',3150542,'2329','356',411759.27,412326.25,566.98,89582.84,0.00,0.00,0.00,0.00,0.00),('1','113','823','158669',3150543,'2330','356',740681.55,740681.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158669',3150544,'2331','356',356109.66,356898.70,789.04,124668.32,0.00,0.00,0.00,0.00,0.00),('1','113','823','158669',3150545,'2332','356',186329.30,187440.92,1111.62,175635.96,0.00,0.00,0.00,0.00,0.00),('1','113','823','158669',3150546,'2333','356',803051.54,803051.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158669',3150547,'2334','356',280449.13,280449.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158669',3150548,'2335','356',597725.80,598691.48,965.68,152577.44,0.00,0.00,0.00,0.00,0.00),('1','113','823','158669',3150549,'2336','356',237895.35,239053.71,1158.36,183020.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','158669',3150550,'2337','356',406245.77,406245.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158669',3150551,'2338','357',697687.54,698393.63,706.09,122153.57,0.00,0.00,0.00,0.00,0.00),('1','113','824','158669',3150552,'2339','357',1775778.98,1776731.35,952.37,164760.01,0.00,0.00,0.00,0.00,0.00),('1','113','825','158669',3150553,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158669',3150554,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158793',3152625,'2326','356',918477.47,920253.88,1776.41,280672.78,0.00,0.00,0.00,0.00,0.00),('1','113','823','158793',3152626,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158793',3152627,'2328','356',917458.77,919439.64,1980.87,312977.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','158793',3152628,'2329','356',412326.25,412326.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158793',3152629,'2330','356',740681.55,740681.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158793',3152630,'2331','356',356898.70,358688.85,1790.15,282843.70,0.00,0.00,0.00,0.00,0.00),('1','113','823','158793',3152631,'2332','356',187440.92,189339.32,1898.40,299947.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','158793',3152632,'2333','356',803051.54,803051.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158793',3152633,'2334','356',280449.13,280449.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158793',3152634,'2335','356',598691.48,598691.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158793',3152635,'2336','356',239053.71,239053.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158793',3152636,'2337','356',406245.77,406245.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158793',3152637,'2338','357',698393.63,699274.53,880.90,152395.70,0.00,0.00,0.00,0.00,0.00),('1','113','824','158793',3152638,'2339','357',1776731.35,1779278.77,2547.42,440703.66,0.00,0.00,0.00,0.00,0.00),('1','113','825','158793',3152639,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158793',3152640,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158795',3152643,'2326','356',920253.88,922730.73,2476.85,391342.30,0.00,0.00,0.00,0.00,0.00),('1','113','823','158795',3152644,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158795',3152645,'2328','356',919439.64,919439.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158795',3152646,'2329','356',412326.25,413550.75,1224.50,193471.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158795',3152647,'2330','356',740681.55,742085.61,1404.06,221841.48,0.00,0.00,0.00,0.00,0.00),('1','113','823','158795',3152648,'2331','356',358688.85,358688.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158795',3152649,'2332','356',189339.32,190864.24,1524.92,240937.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','158795',3152650,'2333','356',803051.54,803051.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158795',3152651,'2334','356',280449.13,280449.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158795',3152652,'2335','356',598691.48,599994.64,1303.16,205899.28,0.00,0.00,0.00,0.00,0.00),('1','113','823','158795',3152653,'2336','356',239053.71,240144.51,1090.80,172346.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','158795',3152654,'2337','356',406245.77,406245.90,0.00,0.00,0.00,0.00,0.13,0.00,0.00),('1','113','824','158795',3152655,'2338','357',699274.53,699895.64,621.11,107452.03,0.00,0.00,0.00,0.00,0.00),('1','113','824','158795',3152656,'2339','357',1779278.77,1781715.12,2436.35,421488.55,0.00,0.00,0.00,0.00,0.00),('1','113','825','158795',3152657,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158795',3152658,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158857',3153671,'2326','356',922730.73,924135.32,1404.59,221925.22,0.00,0.00,0.00,0.00,0.00),('1','113','823','158857',3153672,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158857',3153673,'2328','356',919439.64,921157.24,1717.60,271380.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','158857',3153674,'2329','356',413550.75,413550.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158857',3153675,'2330','356',742085.61,743575.03,1489.42,235328.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','158857',3153676,'2331','356',358688.85,358688.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158857',3153677,'2332','356',190864.24,191884.30,1020.06,161169.48,0.00,0.00,0.00,0.00,0.00),('1','113','823','158857',3153678,'2333','356',803051.54,803078.74,27.20,4297.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','158857',3153679,'2334','356',280449.13,280449.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158857',3153680,'2335','356',599994.64,600900.66,906.02,143151.16,0.00,0.00,0.00,0.00,0.00),('1','113','823','158857',3153681,'2336','356',240144.51,240812.52,668.01,105545.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','158857',3153682,'2337','356',406245.90,406245.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','158857',3153683,'2338','357',699895.64,701649.15,1753.51,303357.23,0.00,0.00,0.00,0.00,0.00),('1','113','824','158857',3153684,'2339','357',1781715.12,1784695.12,2980.00,515540.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158857',3153685,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158857',3153686,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158984',3155992,'2326','356',924135.32,926014.90,1879.58,296973.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','158984',3155993,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158984',3155994,'2328','356',921157.24,922534.77,1377.53,217649.74,0.00,0.00,0.00,0.00,0.00),('1','113','823','158984',3155995,'2329','356',413550.75,414281.81,731.06,115507.48,0.00,0.00,0.00,0.00,0.00),('1','113','823','158984',3155996,'2330','356',743575.03,744968.39,1393.36,220150.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','158984',3155997,'2331','356',358688.85,358688.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158984',3155998,'2332','356',191884.30,193303.37,1419.07,224213.06,0.00,0.00,0.00,0.00,0.00),('1','113','823','158984',3155999,'2333','356',803078.74,803078.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158984',3156000,'2334','356',280449.13,281757.21,1308.08,206676.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','158984',3156001,'2335','356',600900.66,600900.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158984',3156002,'2336','356',240812.52,240812.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','158984',3156003,'2337','356',406245.90,407328.94,1083.04,171120.32,0.00,0.00,0.00,0.00,0.00),('1','113','824','158984',3156004,'2338','357',701649.15,703662.64,2013.49,348333.77,0.00,0.00,0.00,0.00,0.00),('1','113','824','158984',3156005,'2339','357',1784695.12,1787949.42,3254.30,562993.90,0.00,0.00,0.00,0.00,0.00),('1','113','825','158984',3156006,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','158984',3156007,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159020',3156689,'2326','356',926014.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159020',3156690,'2327','356',468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159020',3156691,'2328','356',922534.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159020',3156692,'2329','356',414281.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159020',3156693,'2330','356',744968.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159020',3156694,'2331','356',358688.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159020',3156695,'2332','356',193303.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159020',3156696,'2333','356',803078.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159020',3156697,'2334','356',281757.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159020',3156698,'2335','356',600900.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159020',3156699,'2336','356',240812.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159020',3156700,'2337','356',407328.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','159020',3156701,'2338','357',703662.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','159020',3156702,'2339','357',1787949.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','159020',3156703,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','159020',3156704,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159023',3156746,'2326','356',926014.90,927410.82,1395.92,223347.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','159023',3156747,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159023',3156748,'2328','356',922534.77,924121.38,1586.61,253857.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','159023',3156749,'2329','356',414281.81,414281.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159023',3156750,'2330','356',744968.39,744968.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159023',3156751,'2331','356',358688.85,359983.78,1294.93,207188.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','159023',3156752,'2332','356',193303.37,194589.75,1286.38,205820.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','159023',3156753,'2333','356',803078.74,803078.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159023',3156754,'2334','356',281757.21,282923.35,1166.14,186582.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','159023',3156755,'2335','356',600900.66,600994.79,94.13,15060.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','159023',3156756,'2336','356',240812.52,240821.90,9.38,1500.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','159023',3156757,'2337','356',407328.94,407328.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','159023',3156758,'2338','357',703662.64,705714.61,2051.97,354990.81,0.00,0.00,0.00,0.00,0.00),('1','113','824','159023',3156759,'2339','357',1787949.42,1791558.76,3609.34,624415.82,0.00,0.00,0.00,0.00,0.00),('1','113','825','159023',3156760,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','159023',3156761,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159029',3156841,'2326','356',927410.82,929083.57,1672.75,267640.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159029',3156842,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159029',3156843,'2328','356',924121.38,924121.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159029',3156844,'2329','356',414281.81,416104.33,1822.52,291603.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','159029',3156845,'2330','356',744968.39,744968.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159029',3156846,'2331','356',359983.78,361822.81,1839.03,294244.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','159029',3156847,'2332','356',194589.75,195168.50,578.75,92600.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159029',3156848,'2333','356',803078.74,803777.64,698.90,111824.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159029',3156849,'2334','356',282923.35,284239.14,1315.79,210526.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','159029',3156850,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159029',3156851,'2336','356',240821.90,241957.49,1135.59,181694.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','159029',3156852,'2337','356',407328.94,407328.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','159029',3156853,'2338','357',705714.61,708477.35,2762.74,477954.02,0.00,0.00,0.00,0.00,0.00),('1','113','824','159029',3156854,'2339','357',1791558.76,1794974.63,3415.87,590945.51,0.00,0.00,0.00,0.00,0.00),('1','113','825','159029',3156855,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','159029',3156856,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159142',3158801,'2326','356',929083.57,930628.04,1544.47,247115.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','159142',3158802,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159142',3158803,'2328','356',924121.38,925628.31,1506.93,241108.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','159142',3158804,'2329','356',416104.33,416104.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159142',3158805,'2330','356',744968.39,744968.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159142',3158806,'2331','356',361822.81,363024.78,1201.97,192315.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','159142',3158807,'2332','356',195168.50,196295.63,1127.13,180340.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','159142',3158808,'2333','356',803777.64,803777.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159142',3158809,'2334','356',284239.14,285316.54,1077.40,172384.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159142',3158810,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159142',3158811,'2336','356',241957.49,241957.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159142',3158812,'2337','356',407328.94,407328.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','159142',3158813,'2338','357',708477.35,712525.68,4048.33,700361.09,0.00,0.00,0.00,0.00,0.00),('1','113','824','159142',3158814,'2339','357',1794974.63,1798058.00,3083.37,533423.01,0.00,0.00,0.00,0.00,0.00),('1','113','825','159142',3158815,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','159142',3158816,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159201',3160046,'2326','356',930628.04,932405.38,1767.34,282774.40,0.00,0.00,10.00,0.00,0.00),('1','113','823','159201',3160047,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159201',3160048,'2328','356',925628.31,925628.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159201',3160049,'2329','356',416104.33,417920.06,1815.73,290516.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','159201',3160050,'2330','356',744968.39,746477.39,1509.00,241440.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159201',3160051,'2331','356',363024.78,363024.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159201',3160052,'2332','356',196295.63,196295.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159201',3160053,'2333','356',803777.64,805193.30,1415.66,226505.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','159201',3160054,'2334','356',285316.54,286059.47,742.93,118868.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','159201',3160055,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159201',3160056,'2336','356',241957.49,242837.98,880.49,140878.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','159201',3160057,'2337','356',407328.94,407328.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','159201',3160058,'2338','357',712525.68,713614.04,1088.36,188286.28,0.00,0.00,0.00,0.00,0.00),('1','113','824','159201',3160059,'2339','357',1798058.00,1799508.31,1450.31,250903.63,0.00,0.00,0.00,0.00,0.00),('1','113','825','159201',3160060,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','159201',3160061,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159416',3163657,'2326','356',932405.38,934058.75,1653.37,264539.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','159416',3163658,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159416',3163659,'2328','356',925628.31,926940.63,1312.32,209971.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','159416',3163660,'2329','356',417920.06,417920.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159416',3163661,'2330','356',746477.39,746477.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159416',3163662,'2331','356',363024.78,364104.73,1079.95,172792.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159416',3163663,'2332','356',196295.63,197546.06,1250.43,200068.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','159416',3163664,'2333','356',805193.30,805193.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159416',3163665,'2334','356',286059.47,287105.00,1045.53,167284.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','159416',3163666,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159416',3163667,'2336','356',242837.98,243571.49,733.51,117361.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','159416',3163668,'2337','356',407328.94,407328.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','159416',3163669,'2338','357',713614.04,715474.49,1860.45,321857.85,0.00,0.00,0.00,0.00,0.00),('1','113','824','159416',3163670,'2339','357',1799508.31,1801827.29,2318.98,401183.54,0.00,0.00,0.00,0.00,0.00),('1','113','825','159416',3163671,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','159416',3163672,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159418',3163702,'2326','356',934058.75,934420.17,361.42,57827.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','159418',3163703,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159418',3163704,'2328','356',926940.63,928661.23,1720.60,275296.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159418',3163705,'2329','356',417920.06,417920.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159418',3163706,'2330','356',746477.39,748223.57,1746.18,279388.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','159418',3163707,'2331','356',364104.73,364104.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159418',3163708,'2332','356',197546.06,198187.98,641.92,102707.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','159418',3163709,'2333','356',805193.30,806354.36,1161.06,185769.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','159418',3163710,'2334','356',287105.00,288482.11,1377.11,220337.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','159418',3163711,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159418',3163712,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159418',3163713,'2337','356',407328.94,408073.59,744.65,119144.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','159418',3163714,'2338','357',715474.49,717258.84,1784.35,308692.55,0.00,0.00,0.00,0.00,0.00),('1','113','824','159418',3163715,'2339','357',1801827.29,1804203.20,2375.91,411032.43,0.00,0.00,0.00,0.00,0.00),('1','113','825','159418',3163716,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','159418',3163717,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159538',3165656,'2326','356',934420.17,934571.05,150.88,24140.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','159538',3165657,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159538',3165658,'2328','356',928661.23,930053.74,1392.51,222801.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','159538',3165659,'2329','356',417920.06,417920.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159538',3165660,'2330','356',748223.57,748223.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159538',3165661,'2331','356',364104.73,365359.58,1254.85,200776.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159538',3165662,'2332','356',198187.98,198187.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159538',3165663,'2333','356',806354.36,806354.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159538',3165664,'2334','356',288482.11,289611.69,1129.58,180732.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','159538',3165665,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159538',3165666,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159538',3165667,'2337','356',408073.59,408746.09,672.50,107600.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','159538',3165668,'2338','357',717258.84,719002.16,1743.32,301594.36,0.00,0.00,0.00,0.00,0.00),('1','113','824','159538',3165669,'2339','357',1804203.20,1805575.85,1372.65,237468.45,0.00,0.00,0.00,0.00,0.00),('1','113','825','159538',3165670,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','159538',3165671,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159540',3165689,'2326','356',934571.05,936186.69,1615.64,258502.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','159540',3165690,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159540',3165691,'2328','356',930053.74,930781.67,707.93,113268.80,0.00,0.00,20.00,0.00,0.00),('1','113','823','159540',3165692,'2329','356',417920.06,419300.34,1380.28,220844.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','159540',3165693,'2330','356',748223.57,749466.45,1242.88,198860.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','159540',3165694,'2331','356',365359.58,365359.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159540',3165695,'2332','356',198187.98,199860.86,1672.88,267660.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','159540',3165696,'2333','356',806354.36,806354.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159540',3165697,'2334','356',289611.69,290831.11,1219.42,195107.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','159540',3165698,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159540',3165699,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159540',3165700,'2337','356',408746.09,409449.34,703.25,112520.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','159540',3165701,'2338','357',719002.16,722020.41,3018.25,522157.25,0.00,0.00,0.00,0.00,0.00),('1','113','824','159540',3165702,'2339','357',1805575.85,1809340.71,3764.86,651320.78,0.00,0.00,0.00,0.00,0.00),('1','113','825','159540',3165703,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','159540',3165704,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159684',3168150,'2326','356',936186.69,936186.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159684',3168151,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159684',3168152,'2328','356',930781.67,930781.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159684',3168153,'2329','356',419300.34,419300.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159684',3168154,'2330','356',749466.45,749466.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159684',3168155,'2331','356',365359.58,365359.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159684',3168156,'2332','356',199860.86,199860.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159684',3168157,'2333','356',806354.36,806354.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159684',3168158,'2334','356',290831.11,290831.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159684',3168159,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159684',3168160,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159684',3168161,'2337','356',409449.34,409449.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','159684',3168162,'2338','357',722020.41,722020.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','159684',3168163,'2339','357',1809340.71,1809340.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','159684',3168164,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','159684',3168165,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159685',3168166,'2326','356',936186.69,937652.27,1465.58,234492.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','159685',3168167,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159685',3168168,'2328','356',930781.67,932069.53,1287.86,206057.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','159685',3168169,'2329','356',419300.34,419300.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159685',3168170,'2330','356',749466.45,749466.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159685',3168171,'2331','356',365359.58,366448.08,1088.50,174160.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159685',3168172,'2332','356',199860.86,200947.16,1086.30,173808.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159685',3168173,'2333','356',806354.36,806354.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159685',3168174,'2334','356',290831.11,291681.84,850.73,136116.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','159685',3168175,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159685',3168176,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159685',3168177,'2337','356',409449.34,410210.03,760.69,121710.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','159685',3168178,'2338','357',722020.41,722550.63,520.22,89998.06,0.00,0.00,10.00,0.00,0.00),('1','113','824','159685',3168179,'2339','357',1809340.71,1810874.60,1523.89,263632.97,0.00,0.00,10.00,0.00,0.00),('1','113','825','159685',3168180,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','159685',3168181,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159752',3169235,'2326','356',937652.27,937652.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159752',3169236,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159752',3169237,'2328','356',932069.53,933457.85,1388.32,222131.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','159752',3169238,'2329','356',419300.34,420724.08,1423.74,227798.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','159752',3169239,'2330','356',749466.45,751188.72,1702.27,272363.20,0.00,0.00,20.00,0.00,0.00),('1','113','823','159752',3169240,'2331','356',366448.08,366448.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159752',3169241,'2332','356',200947.16,200947.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159752',3169242,'2333','356',806354.36,807287.91,933.55,149368.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159752',3169243,'2334','356',291681.84,293147.60,1465.76,234521.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','159752',3169244,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159752',3169245,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159752',3169246,'2337','356',410210.03,411414.31,1204.28,192684.80,0.00,0.00,0.00,0.00,0.00),('1','113','824','159752',3169247,'2338','357',722550.63,724021.74,1471.11,254502.03,0.00,0.00,0.00,0.00,0.00),('1','113','824','159752',3169248,'2339','357',1810874.60,1813760.13,2885.53,499196.69,0.00,0.00,0.00,0.00,0.00),('1','113','825','159752',3169249,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','159752',3169250,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159969',3173073,'2326','356',937652.27,939405.59,1753.32,280531.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','159969',3173074,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159969',3173075,'2328','356',933457.85,933457.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159969',3173076,'2329','356',420724.08,422135.19,1411.11,225777.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','159969',3173077,'2330','356',751188.72,751191.85,3.13,500.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','159969',3173078,'2331','356',366448.08,367713.34,1265.26,202441.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','159969',3173079,'2332','356',200947.16,201700.15,752.99,120478.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','159969',3173080,'2333','356',807287.91,807287.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159969',3173081,'2334','356',293147.60,293817.03,669.43,107108.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','159969',3173082,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159969',3173083,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159969',3173084,'2337','356',411414.31,412455.49,1041.18,166588.80,0.00,0.00,0.00,0.00,0.00),('1','113','824','159969',3173085,'2338','357',724021.74,726609.99,2588.25,447767.25,0.00,0.00,0.00,0.00,0.00),('1','113','824','159969',3173086,'2339','357',1813760.13,1816501.75,2741.62,474300.26,0.00,0.00,0.00,0.00,0.00),('1','113','825','159969',3173087,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','159969',3173088,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159971',3173104,'2326','356',939405.59,941372.28,1956.69,313070.40,0.00,0.00,10.00,0.00,0.00),('1','113','823','159971',3173105,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159971',3173106,'2328','356',933457.85,934922.90,1455.05,232808.00,0.00,0.00,10.00,0.00,0.00),('1','113','823','159971',3173107,'2329','356',422135.19,422135.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159971',3173108,'2330','356',751191.85,751191.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159971',3173109,'2331','356',367713.34,369734.13,2010.79,321726.40,0.00,0.00,10.00,0.00,0.00),('1','113','823','159971',3173110,'2332','356',201700.15,202559.57,859.42,137507.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','159971',3173111,'2333','356',807287.91,808407.74,1109.83,177572.80,0.00,0.00,10.00,0.00,0.00),('1','113','823','159971',3173112,'2334','356',293817.03,295289.36,1462.33,233972.80,0.00,0.00,10.00,0.00,0.00),('1','113','823','159971',3173113,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159971',3173114,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','159971',3173115,'2337','356',412455.49,413143.63,678.14,108502.40,0.00,0.00,10.00,0.00,0.00),('1','113','824','159971',3173116,'2338','357',726609.99,729833.75,3213.76,555980.48,0.00,0.00,10.00,0.00,0.00),('1','113','824','159971',3173117,'2339','357',1816501.75,1819008.35,2496.60,431911.80,0.00,0.00,10.00,0.00,0.00),('1','113','825','159971',3173118,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','159971',3173119,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160056',3174800,'2326','356',941372.28,941866.68,494.40,79104.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160056',3174801,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160056',3174802,'2328','356',934922.90,935571.08,648.18,103708.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','160056',3174803,'2329','356',422135.19,422135.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160056',3174804,'2330','356',751191.85,751191.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160056',3174805,'2331','356',369734.13,369734.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160056',3174806,'2332','356',202559.57,203015.71,456.14,72982.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','160056',3174807,'2333','356',808407.74,808407.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160056',3174808,'2334','356',295289.36,295914.54,625.18,100028.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','160056',3174809,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160056',3174810,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160056',3174811,'2337','356',413143.63,413347.83,204.20,32672.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','160056',3174812,'2338','357',729833.75,731068.90,1235.15,213680.95,0.00,0.00,0.00,0.00,0.00),('1','113','824','160056',3174813,'2339','357',1819008.35,1822185.48,3177.13,549643.49,0.00,0.00,0.00,0.00,0.00),('1','113','825','160056',3174814,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','160056',3174815,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160059',3174855,'2326','356',941866.68,943677.11,1810.43,289668.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','160059',3174856,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160059',3174857,'2328','356',935571.08,937448.93,1877.85,300456.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160059',3174858,'2329','356',422135.19,422135.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160059',3174859,'2330','356',751191.85,752697.91,1506.06,240969.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','160059',3174860,'2331','356',369734.13,369734.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160059',3174861,'2332','356',203015.71,204709.48,1693.77,271003.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','160059',3174862,'2333','356',808407.74,808407.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160059',3174863,'2334','356',295914.54,297241.79,1327.25,212360.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160059',3174864,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160059',3174865,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160059',3174866,'2337','356',413347.83,414383.05,1035.22,165635.20,0.00,0.00,0.00,0.00,0.00),('1','113','824','160059',3174867,'2338','357',731068.90,732819.80,1750.90,302905.70,0.00,0.00,0.00,0.00,0.00),('1','113','824','160059',3174868,'2339','357',1822185.48,1825187.84,3002.36,519408.28,0.00,0.00,0.00,0.00,0.00),('1','113','825','160059',3174869,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','160059',3174870,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160264',3178555,'2326','356',943677.11,945384.52,1707.41,273185.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','160264',3178556,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160264',3178557,'2328','356',937448.93,939146.16,1697.23,271556.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','160264',3178558,'2329','356',422135.19,422135.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160264',3178559,'2330','356',752697.91,752697.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160264',3178560,'2331','356',369734.13,371155.63,1421.50,227440.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160264',3178561,'2332','356',204709.48,204709.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160264',3178562,'2333','356',808407.74,809459.44,1051.70,168272.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160264',3178563,'2334','356',297241.79,297266.83,25.04,4006.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','160264',3178564,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160264',3178565,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160264',3178566,'2337','356',414383.05,415322.22,939.17,150267.20,0.00,0.00,0.00,0.00,0.00),('1','113','824','160264',3178567,'2338','357',732819.80,734266.42,1446.62,250265.26,0.00,0.00,0.00,0.00,0.00),('1','113','824','160264',3178568,'2339','357',1825187.84,1829142.60,3954.76,684173.48,0.00,0.00,0.00,0.00,0.00),('1','113','825','160264',3178569,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','160264',3178570,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160266',3178580,'2326','356',945384.52,947180.60,1796.08,287372.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','160266',3178581,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160266',3178582,'2328','356',939146.16,940840.39,1694.23,271076.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','160266',3178583,'2329','356',422135.19,422135.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160266',3178584,'2330','356',752697.91,754325.67,1627.76,260441.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','160266',3178585,'2331','356',371155.63,371155.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160266',3178586,'2332','356',204709.48,206344.06,1634.58,261532.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','160266',3178587,'2333','356',809459.44,809530.56,71.12,11379.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','160266',3178588,'2334','356',297266.83,298496.35,1229.52,196723.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','160266',3178589,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160266',3178590,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160266',3178591,'2337','356',415322.22,416604.66,1282.44,205190.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','160266',3178592,'2338','357',734266.42,737509.64,3243.22,561077.06,0.00,0.00,0.00,0.00,0.00),('1','113','824','160266',3178593,'2339','357',1829142.60,1835192.69,6050.09,1046665.57,0.00,0.00,0.00,0.00,0.00),('1','113','825','160266',3178594,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','160266',3178595,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160422',3181626,'2326','356',947180.60,947180.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160422',3181627,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160422',3181628,'2328','356',940840.39,942719.33,1878.94,300630.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','160422',3181629,'2329','356',422135.19,422135.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160422',3181630,'2330','356',754325.67,754325.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160422',3181631,'2331','356',371155.63,372534.09,1378.46,220553.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','160422',3181632,'2332','356',206344.06,207725.88,1381.82,221091.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','160422',3181633,'2333','356',809530.56,809530.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160422',3181634,'2334','356',298496.35,299671.48,1175.13,188020.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','160422',3181635,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160422',3181636,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160422',3181637,'2337','356',416604.66,417391.03,786.37,125819.20,0.00,0.00,0.00,0.00,0.00),('1','113','824','160422',3181638,'2338','357',737509.64,738795.90,1286.26,222522.98,0.00,0.00,0.00,0.00,0.00),('1','113','824','160422',3181639,'2339','357',1835192.69,1837411.89,2219.20,383921.60,0.00,0.00,0.00,0.00,0.00),('1','113','825','160422',3181640,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','160422',3181641,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160497',3182757,'2326','356',947180.60,949281.71,2101.11,336177.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','160497',3182758,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160497',3182759,'2328','356',942719.33,944536.61,1817.28,290764.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','160497',3182760,'2329','356',422135.19,422135.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160497',3182761,'2330','356',754325.67,754325.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160497',3182762,'2331','356',372534.09,374509.99,1975.90,316144.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160497',3182763,'2332','356',207725.88,207725.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160497',3182764,'2333','356',809530.56,810940.49,1409.93,225588.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','160497',3182765,'2334','356',299671.48,301801.73,2130.25,340840.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160497',3182766,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160497',3182767,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160497',3182768,'2337','356',417391.03,417482.04,91.01,14561.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','160497',3182769,'2338','357',738795.90,742963.97,4168.07,721076.11,0.00,0.00,0.00,0.00,0.00),('1','113','824','160497',3182770,'2339','357',1837411.89,1839592.88,2180.99,377311.27,0.00,0.00,0.00,0.00,0.00),('1','113','825','160497',3182771,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','160497',3182772,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160500',3182836,'2326','356',949281.71,950599.15,1317.44,210790.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','160500',3182837,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160500',3182838,'2328','356',944536.61,945730.93,1194.32,191091.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','160500',3182839,'2329','356',422135.19,422135.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160500',3182840,'2330','356',754325.67,755597.54,1271.87,203499.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','160500',3182841,'2331','356',374509.99,374509.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160500',3182842,'2332','356',207725.88,207725.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160500',3182843,'2333','356',810940.49,812439.28,1498.79,239806.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','160500',3182844,'2334','356',301801.73,302862.60,1050.87,168139.20,0.00,0.00,10.00,0.00,0.00),('1','113','823','160500',3182845,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160500',3182846,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160500',3182847,'2337','356',417482.04,418117.25,635.21,101633.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','160500',3182848,'2338','357',742963.97,745192.58,2228.61,385549.53,0.00,0.00,0.00,0.00,0.00),('1','113','824','160500',3182849,'2339','357',1839592.88,1842215.09,2622.21,453642.33,0.00,0.00,0.00,0.00,0.00),('1','113','825','160500',3182850,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','160500',3182851,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160544',3183735,'2326','356',950599.15,952749.21,2150.06,344009.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','160544',3183736,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160544',3183737,'2328','356',945730.93,947432.60,1701.67,272267.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','160544',3183738,'2329','356',422135.19,422135.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160544',3183739,'2330','356',755597.54,755597.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160544',3183740,'2331','356',374509.99,375861.80,1351.81,216289.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','160544',3183741,'2332','356',207725.88,209318.18,1592.30,254768.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160544',3183742,'2333','356',812439.28,812439.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160544',3183743,'2334','356',302862.60,304395.15,1532.55,245208.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160544',3183744,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160544',3183745,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160544',3183746,'2337','356',418117.25,419565.00,1437.75,230040.00,0.00,0.00,10.00,0.00,0.00),('1','113','824','160544',3183747,'2338','357',745192.58,747578.20,2385.62,412712.26,0.00,0.00,0.00,0.00,0.00),('1','113','824','160544',3183748,'2339','357',1842215.09,1846199.71,3984.62,689339.26,0.00,0.00,0.00,0.00,0.00),('1','113','825','160544',3183749,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','160544',3183750,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160699',3186323,'2326','356',952749.21,954028.46,1279.25,204680.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160699',3186324,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160699',3186325,'2328','356',947432.60,949202.91,1770.31,283249.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','160699',3186326,'2329','356',422135.19,422135.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160699',3186327,'2330','356',755597.54,755597.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160699',3186328,'2331','356',375861.80,376904.57,1042.77,166843.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','160699',3186329,'2332','356',209318.18,209318.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160699',3186330,'2333','356',812439.28,814017.87,1578.59,252574.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','160699',3186331,'2334','356',304395.15,305618.33,1223.18,195708.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','160699',3186332,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160699',3186333,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160699',3186334,'2337','356',419565.00,419565.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','160699',3186335,'2338','357',747578.20,749605.65,2027.45,350748.85,0.00,0.00,0.00,0.00,0.00),('1','113','824','160699',3186336,'2339','357',1846199.71,1847705.40,1505.69,260484.37,0.00,0.00,0.00,0.00,0.00),('1','113','825','160699',3186337,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','160699',3186338,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160703',3186401,'2326','356',954028.46,956052.71,2024.25,323880.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160703',3186402,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160703',3186403,'2328','356',949202.91,951110.92,1908.01,305281.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','160703',3186404,'2329','356',422135.19,422135.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160703',3186405,'2330','356',755597.54,755660.04,62.50,10000.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160703',3186406,'2331','356',376904.57,378236.67,1332.10,213136.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160703',3186407,'2332','356',209318.18,210841.89,1523.71,243793.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','160703',3186408,'2333','356',814017.87,814735.33,717.46,114793.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','160703',3186409,'2334','356',305618.33,306875.70,1257.37,201179.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','160703',3186410,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160703',3186411,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160703',3186412,'2337','356',419565.00,420412.35,847.35,135576.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','160703',3186413,'2338','357',749605.65,751078.15,1472.50,254742.50,0.00,0.00,0.00,0.00,0.00),('1','113','824','160703',3186414,'2339','357',1847705.40,1849042.82,1337.42,231373.66,0.00,0.00,0.00,0.00,0.00),('1','113','825','160703',3186415,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','160703',3186416,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160834',3188630,'2326','356',956052.71,957546.14,1493.43,238948.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','160834',3188631,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160834',3188632,'2328','356',951110.92,952365.71,1254.79,200766.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','160834',3188633,'2329','356',422135.19,422135.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160834',3188634,'2330','356',755660.04,756686.22,1026.18,164188.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','160834',3188635,'2331','356',378236.67,378236.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160834',3188636,'2332','356',210841.89,211729.64,887.75,142040.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160834',3188637,'2333','356',814735.33,814735.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160834',3188638,'2334','356',306875.70,307754.19,878.49,140558.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','160834',3188639,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160834',3188640,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160834',3188641,'2337','356',420412.35,420998.21,585.86,93737.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','160834',3188642,'2338','357',751078.15,751378.40,300.25,51943.25,0.00,0.00,0.00,0.00,0.00),('1','113','824','160834',3188643,'2339','357',1849042.82,1852145.96,3103.14,536843.22,0.00,0.00,0.00,0.00,0.00),('1','113','825','160834',3188644,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','160834',3188645,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160836',3188669,'2326','356',957546.14,959095.11,1548.97,247835.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','160836',3188670,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160836',3188671,'2328','356',952365.71,953741.99,1376.28,220204.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','160836',3188672,'2329','356',422135.19,422135.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160836',3188673,'2330','356',756686.22,758184.00,1497.78,239644.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','160836',3188674,'2331','356',378236.67,379154.08,917.41,146785.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','160836',3188675,'2332','356',211729.64,212579.78,850.14,136022.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','160836',3188676,'2333','356',814735.33,814735.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160836',3188677,'2334','356',307754.19,308796.57,1042.38,166780.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','160836',3188678,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160836',3188679,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','160836',3188680,'2337','356',420998.21,421697.65,699.44,111910.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','160836',3188681,'2338','357',751378.40,753043.57,1665.17,288074.41,0.00,0.00,0.00,0.00,0.00),('1','113','824','160836',3188682,'2339','357',1852145.96,1853514.68,1368.72,236788.56,0.00,0.00,0.00,0.00,0.00),('1','113','825','160836',3188683,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','160836',3188684,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161028',3192169,'2326','356',959095.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161028',3192170,'2327','356',468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161028',3192171,'2328','356',953741.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161028',3192172,'2329','356',422135.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161028',3192173,'2330','356',758184.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161028',3192174,'2331','356',379154.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161028',3192175,'2332','356',212579.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161028',3192176,'2333','356',814735.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161028',3192177,'2334','356',308796.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161028',3192178,'2335','356',600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161028',3192179,'2336','356',243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161028',3192180,'2337','356',421697.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','161028',3192181,'2338','357',753043.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','161028',3192182,'2339','357',1853514.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','161028',3192183,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','161028',3192184,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161030',3192198,'2326','356',959095.11,960599.56,1504.45,240712.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161030',3192199,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161030',3192200,'2328','356',953741.99,954787.83,1045.84,167334.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','161030',3192201,'2329','356',422135.19,422135.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161030',3192202,'2330','356',758184.00,758908.70,724.70,115952.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161030',3192203,'2331','356',379154.08,380154.96,1000.88,160140.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','161030',3192204,'2332','356',212579.78,213730.63,1150.85,184136.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161030',3192205,'2333','356',814735.33,814735.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161030',3192206,'2334','356',308796.57,309551.51,754.94,120790.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','161030',3192207,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161030',3192208,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161030',3192209,'2337','356',421697.65,422166.11,468.46,74953.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','161030',3192210,'2338','357',753043.57,754209.95,1166.38,201783.74,0.00,0.00,0.00,0.00,0.00),('1','113','824','161030',3192211,'2339','357',1853514.68,1854375.71,861.03,148958.19,0.00,0.00,0.00,0.00,0.00),('1','113','825','161030',3192212,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','161030',3192213,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161040',3192363,'2326','356',960599.56,962828.92,2229.36,356697.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','161040',3192364,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161040',3192365,'2328','356',954787.83,954787.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161040',3192366,'2329','356',422135.19,424050.28,1915.09,306414.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','161040',3192367,'2330','356',758908.70,758908.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161040',3192368,'2331','356',380154.96,380154.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161040',3192369,'2332','356',213730.63,213730.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161040',3192370,'2333','356',814735.33,816200.34,1465.01,234401.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','161040',3192371,'2334','356',309551.51,311135.36,1583.85,253416.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161040',3192372,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161040',3192373,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161040',3192374,'2337','356',422166.11,423501.60,1335.49,213678.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','161040',3192375,'2338','357',754209.95,756384.00,2174.05,376110.65,0.00,0.00,0.00,0.00,0.00),('1','113','824','161040',3192376,'2339','357',1854375.71,1856189.29,1813.58,313749.34,0.00,0.00,0.00,0.00,0.00),('1','113','825','161040',3192377,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','161040',3192378,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161208',3195490,'2326','356',962828.92,964397.48,1518.56,242969.60,0.00,0.00,50.00,0.00,0.00),('1','113','823','161208',3195491,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161208',3195492,'2328','356',954787.83,956447.25,1609.42,257507.20,0.00,0.00,50.00,0.00,0.00),('1','113','823','161208',3195493,'2329','356',424050.28,424080.28,0.00,0.00,0.00,0.00,30.00,0.00,0.00),('1','113','823','161208',3195494,'2330','356',758908.70,760535.85,1577.15,252344.00,0.00,0.00,50.00,0.00,0.00),('1','113','823','161208',3195495,'2331','356',380154.96,380194.96,0.00,0.00,0.00,0.00,40.00,0.00,0.00),('1','113','823','161208',3195496,'2332','356',213730.63,214822.72,1042.09,166734.40,0.00,0.00,50.00,0.00,0.00),('1','113','823','161208',3195497,'2333','356',816200.34,816230.34,0.00,0.00,0.00,0.00,30.00,0.00,0.00),('1','113','823','161208',3195498,'2334','356',311135.36,312082.06,896.70,143472.00,0.00,0.00,50.00,0.00,0.00),('1','113','823','161208',3195499,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161208',3195500,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161208',3195501,'2337','356',423501.60,423924.97,373.37,59739.20,0.00,0.00,50.00,0.00,0.00),('1','113','824','161208',3195502,'2338','357',756384.00,758837.22,2403.22,415757.06,0.00,0.00,50.00,0.00,0.00),('1','113','824','161208',3195503,'2339','357',1856189.29,1860090.28,3850.99,666221.27,0.00,0.00,50.00,0.00,0.00),('1','113','825','161208',3195504,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','161208',3195505,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161213',3195576,'2326','356',964397.48,966276.57,1879.09,300654.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','161213',3195577,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161213',3195578,'2328','356',956447.25,958571.00,2123.75,339800.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161213',3195579,'2329','356',424080.28,424080.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161213',3195580,'2330','356',760535.85,761257.76,721.91,115505.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','161213',3195581,'2331','356',380194.96,381235.83,1040.87,166539.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','161213',3195582,'2332','356',214822.72,216590.03,1767.31,282769.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','161213',3195583,'2333','356',816230.34,816230.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161213',3195584,'2334','356',312082.06,313302.54,1220.48,195276.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','161213',3195585,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161213',3195586,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161213',3195587,'2337','356',423924.97,424706.51,751.54,120246.40,0.00,0.00,30.00,0.00,0.00),('1','113','824','161213',3195588,'2338','357',758837.22,762310.46,3473.24,600870.52,0.00,0.00,0.00,0.00,0.00),('1','113','824','161213',3195589,'2339','357',1860090.28,1862474.56,2384.28,412480.44,0.00,0.00,0.00,0.00,0.00),('1','113','825','161213',3195590,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','161213',3195591,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161399',3198592,'2326','356',966276.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161399',3198593,'2327','356',468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161399',3198594,'2328','356',958571.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161399',3198595,'2329','356',424080.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161399',3198596,'2330','356',761257.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161399',3198597,'2331','356',381235.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161399',3198598,'2332','356',216590.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161399',3198599,'2333','356',816230.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161399',3198600,'2334','356',313302.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161399',3198601,'2335','356',600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161399',3198602,'2336','356',243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161399',3198603,'2337','356',424706.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','161399',3198604,'2338','357',762310.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','161399',3198605,'2339','357',1862474.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','161399',3198606,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','161399',3198607,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161502',3200039,'2326','356',966276.57,967310.11,1033.54,163299.32,0.00,0.00,0.00,0.00,0.00),('1','113','823','161502',3200040,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161502',3200041,'2328','356',958571.00,959321.59,750.59,118593.22,0.00,0.00,0.00,0.00,0.00),('1','113','823','161502',3200042,'2329','356',424080.28,424080.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161502',3200043,'2330','356',761257.76,761257.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161502',3200044,'2331','356',381235.83,381944.66,708.83,111995.14,0.00,0.00,0.00,0.00,0.00),('1','113','823','161502',3200045,'2332','356',216590.03,217596.54,1006.51,159028.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','161502',3200046,'2333','356',816230.34,816230.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161502',3200047,'2334','356',313302.54,313922.63,620.09,97974.22,0.00,0.00,0.00,0.00,0.00),('1','113','823','161502',3200048,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161502',3200049,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161502',3200050,'2337','356',424706.51,425212.70,506.19,79978.02,0.00,0.00,0.00,0.00,0.00),('1','113','824','161502',3200051,'2338','357',762310.46,764230.74,1920.28,332208.44,0.00,0.00,0.00,0.00,0.00),('1','113','824','161502',3200052,'2339','357',1862474.56,1864944.00,2469.44,427213.12,0.00,0.00,0.00,0.00,0.00),('1','113','825','161502',3200053,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','161502',3200054,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161503',3200055,'2326','356',967310.11,968991.80,1681.69,265707.02,0.00,0.00,0.00,0.00,0.00),('1','113','823','161503',3200056,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161503',3200057,'2328','356',959321.59,960311.16,989.57,156352.06,0.00,0.00,0.00,0.00,0.00),('1','113','823','161503',3200058,'2329','356',424080.28,425174.97,1094.69,172961.02,0.00,0.00,0.00,0.00,0.00),('1','113','823','161503',3200059,'2330','356',761257.76,762406.84,1149.08,181554.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','161503',3200060,'2331','356',381944.66,381944.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161503',3200061,'2332','356',217596.54,217596.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161503',3200062,'2333','356',816230.34,817243.47,1013.13,160074.54,0.00,0.00,0.00,0.00,0.00),('1','113','823','161503',3200063,'2334','356',313922.63,315183.47,1260.84,199212.72,0.00,0.00,0.00,0.00,0.00),('1','113','823','161503',3200064,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161503',3200065,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161503',3200066,'2337','356',425212.70,426008.04,795.34,125663.72,0.00,0.00,0.00,0.00,0.00),('1','113','824','161503',3200067,'2338','357',764230.74,766219.41,1988.67,344039.91,0.00,0.00,0.00,0.00,0.00),('1','113','824','161503',3200068,'2339','357',1864944.00,1869269.43,4325.43,748299.39,0.00,0.00,0.00,0.00,0.00),('1','113','825','161503',3200069,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','161503',3200070,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161579',3201493,'2326','356',968991.80,970578.93,1587.13,250766.54,0.00,0.00,0.00,0.00,0.00),('1','113','823','161579',3201494,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161579',3201495,'2328','356',960311.16,961872.24,1561.08,246650.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','161579',3201496,'2329','356',425174.97,425174.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161579',3201497,'2330','356',762406.84,762406.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161579',3201498,'2331','356',381944.66,383105.04,1160.38,183340.04,0.00,0.00,0.00,0.00,0.00),('1','113','823','161579',3201499,'2332','356',217596.54,218473.62,877.08,138578.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','161579',3201500,'2333','356',817243.47,817243.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161579',3201501,'2334','356',315183.47,316149.07,965.60,152564.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','161579',3201502,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161579',3201503,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161579',3201504,'2337','356',426008.04,426415.19,407.15,64329.70,0.00,0.00,0.00,0.00,0.00),('1','113','824','161579',3201505,'2338','357',766219.41,769159.62,2940.21,508656.33,0.00,0.00,0.00,0.00,0.00),('1','113','824','161579',3201506,'2339','357',1869269.43,1872763.50,3494.07,604474.11,0.00,0.00,0.00,0.00,0.00),('1','113','825','161579',3201507,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','161579',3201508,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161585',3201643,'2326','356',970578.93,972232.78,1653.85,261308.30,0.00,0.00,0.00,0.00,0.00),('1','113','823','161585',3201644,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161585',3201645,'2328','356',961872.24,963577.32,1705.08,269402.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','161585',3201646,'2329','356',425174.97,425174.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161585',3201647,'2330','356',762406.84,763440.07,1033.23,163250.34,0.00,0.00,0.00,0.00,0.00),('1','113','823','161585',3201648,'2331','356',383105.04,384049.17,944.13,149172.54,0.00,0.00,0.00,0.00,0.00),('1','113','823','161585',3201649,'2332','356',218473.62,218473.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161585',3201650,'2333','356',817243.47,818510.32,1266.85,200162.30,0.00,0.00,0.00,0.00,0.00),('1','113','823','161585',3201651,'2334','356',316149.07,317129.59,980.52,154922.16,0.00,0.00,0.00,0.00,0.00),('1','113','823','161585',3201652,'2335','356',600994.79,600994.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161585',3201653,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161585',3201654,'2337','356',426415.19,427563.90,1148.71,181496.18,0.00,0.00,0.00,0.00,0.00),('1','113','824','161585',3201655,'2338','357',769159.62,772290.38,3130.76,541621.48,0.00,0.00,0.00,0.00,0.00),('1','113','824','161585',3201656,'2339','357',1872763.50,1875797.58,3034.08,524895.84,0.00,0.00,0.00,0.00,0.00),('1','113','825','161585',3201657,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','161585',3201658,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161911',3207147,'2326','356',972232.78,973572.18,1339.40,211625.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','161911',3207148,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161911',3207149,'2328','356',963577.32,964633.12,1055.80,166816.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','161911',3207150,'2329','356',425174.97,425174.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161911',3207151,'2330','356',763440.07,763440.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161911',3207152,'2331','356',384049.17,384912.81,863.64,136455.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','161911',3207153,'2332','356',218473.62,219086.25,612.63,96795.54,0.00,0.00,0.00,0.00,0.00),('1','113','823','161911',3207154,'2333','356',818510.32,818510.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161911',3207155,'2334','356',317129.59,317822.43,692.84,109468.72,0.00,0.00,0.00,0.00,0.00),('1','113','823','161911',3207156,'2335','356',600994.79,600995.51,0.72,113.76,0.00,0.00,0.00,0.00,0.00),('1','113','823','161911',3207157,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161911',3207158,'2337','356',427563.90,428083.57,519.67,82107.86,0.00,0.00,0.00,0.00,0.00),('1','113','824','161911',3207159,'2338','357',772290.38,772782.25,491.87,85093.51,0.00,0.00,0.00,0.00,0.00),('1','113','824','161911',3207160,'2339','357',1875797.58,1877517.08,1719.50,297473.50,0.00,0.00,0.00,0.00,0.00),('1','113','825','161911',3207161,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','161911',3207162,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161913',3207180,'2326','356',973572.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161913',3207181,'2327','356',468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161913',3207182,'2328','356',964633.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161913',3207183,'2329','356',425174.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161913',3207184,'2330','356',763440.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161913',3207185,'2331','356',384912.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161913',3207186,'2332','356',219086.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161913',3207187,'2333','356',818510.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161913',3207188,'2334','356',317822.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161913',3207189,'2335','356',600995.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161913',3207190,'2336','356',243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161913',3207191,'2337','356',428083.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','161913',3207192,'2338','357',772782.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','161913',3207193,'2339','357',1877517.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','161913',3207194,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','161913',3207195,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161922',3207388,'2326','356',973572.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161922',3207389,'2327','356',468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161922',3207390,'2328','356',964633.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161922',3207391,'2329','356',425174.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161922',3207392,'2330','356',763440.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161922',3207393,'2331','356',384912.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161922',3207394,'2332','356',219086.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161922',3207395,'2333','356',818510.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161922',3207396,'2334','356',317822.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161922',3207397,'2335','356',600995.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161922',3207398,'2336','356',243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161922',3207399,'2337','356',428083.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','161922',3207400,'2338','357',772782.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','161922',3207401,'2339','357',1877517.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','161922',3207402,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','161922',3207403,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161930',3207571,'2326','356',973572.18,976247.64,2655.46,424873.60,0.00,0.00,20.00,0.00,0.00),('1','113','823','161930',3207572,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161930',3207573,'2328','356',964633.12,966459.33,1826.21,292193.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','161930',3207574,'2329','356',425174.97,426505.15,1330.18,212828.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','161930',3207575,'2330','356',763440.07,765430.11,1990.04,318406.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','161930',3207576,'2331','356',384912.81,385295.92,383.11,61297.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','161930',3207577,'2332','356',219086.25,219086.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161930',3207578,'2333','356',818510.32,820366.45,1856.13,296980.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','161930',3207579,'2334','356',317822.43,317822.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161930',3207580,'2335','356',600995.51,602784.85,1789.34,286294.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','161930',3207581,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','161930',3207582,'2337','356',428083.57,429191.36,1107.79,177246.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','161930',3207583,'2338','357',772782.25,774074.21,1291.96,223509.08,0.00,0.00,0.00,0.00,0.00),('1','113','824','161930',3207584,'2339','357',1877517.08,1879471.68,1954.60,338145.80,0.00,0.00,0.00,0.00,0.00),('1','113','825','161930',3207585,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','161930',3207586,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162014',3209374,'2326','356',976247.64,977658.88,1411.24,225798.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','162014',3209375,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162014',3209376,'2328','356',966459.33,967694.21,1234.88,197580.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','162014',3209377,'2329','356',426505.15,426505.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162014',3209378,'2330','356',765430.11,765430.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162014',3209379,'2331','356',385295.92,386301.33,1005.41,160865.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','162014',3209380,'2332','356',219086.25,219086.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162014',3209381,'2333','356',820366.45,821180.46,814.01,130241.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','162014',3209382,'2334','356',317822.43,317822.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162014',3209383,'2335','356',602784.85,603549.20,764.35,122296.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162014',3209384,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162014',3209385,'2337','356',429191.36,429745.46,554.10,88656.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','162014',3209386,'2338','357',774074.21,776347.83,2273.62,393336.26,0.00,0.00,0.00,0.00,0.00),('1','113','824','162014',3209387,'2339','357',1879471.68,1883522.34,4050.66,700764.18,0.00,0.00,0.00,0.00,0.00),('1','113','825','162014',3209388,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','162014',3209389,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162016',3209398,'2326','356',977658.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162016',3209399,'2327','356',468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162016',3209400,'2328','356',967694.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162016',3209401,'2329','356',426505.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162016',3209402,'2330','356',765430.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162016',3209403,'2331','356',386301.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162016',3209404,'2332','356',219086.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162016',3209405,'2333','356',821180.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162016',3209406,'2334','356',317822.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162016',3209407,'2335','356',603549.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162016',3209408,'2336','356',243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162016',3209409,'2337','356',429745.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','162016',3209410,'2338','357',776347.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','162016',3209411,'2339','357',1883522.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','162016',3209412,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','162016',3209413,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162203',3212572,'2326','356',977658.88,979582.26,1923.38,323127.84,0.00,0.00,0.00,0.00,0.00),('1','113','823','162203',3212573,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162203',3212574,'2328','356',967694.21,969630.94,1936.73,325370.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','162203',3212575,'2329','356',426505.15,426505.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162203',3212576,'2330','356',765430.11,766926.23,1496.12,251348.16,0.00,0.00,0.00,0.00,0.00),('1','113','823','162203',3212577,'2331','356',386301.33,386301.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162203',3212578,'2332','356',219086.25,219086.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162203',3212579,'2333','356',821180.46,822805.79,1625.33,273055.44,0.00,0.00,0.00,0.00,0.00),('1','113','823','162203',3212580,'2334','356',317822.43,317822.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162203',3212581,'2335','356',603549.20,604574.59,1005.39,168905.52,0.00,0.00,20.00,0.00,0.00),('1','113','823','162203',3212582,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162203',3212583,'2337','356',429745.46,430762.52,1017.06,170866.08,0.00,0.00,0.00,0.00,0.00),('1','113','824','162203',3212584,'2338','357',776347.83,778973.32,2625.49,454209.77,0.00,0.00,0.00,0.00,0.00),('1','113','824','162203',3212585,'2339','357',1883522.34,1888086.27,4563.93,789559.89,0.00,0.00,0.00,0.00,0.00),('1','113','825','162203',3212586,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','162203',3212587,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162273',3213615,'2326','356',979582.26,980488.59,906.33,152263.44,0.00,0.00,0.00,0.00,0.00),('1','113','823','162273',3213616,'2327','356',468130.50,468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162273',3213617,'2328','356',969630.94,970233.40,602.46,101213.28,0.00,0.00,0.00,0.00,0.00),('1','113','823','162273',3213618,'2329','356',426505.15,426505.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162273',3213619,'2330','356',766926.23,766926.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162273',3213620,'2331','356',386301.33,386898.07,596.74,100252.32,0.00,0.00,0.00,0.00,0.00),('1','113','823','162273',3213621,'2332','356',219086.25,219086.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162273',3213622,'2333','356',822805.79,823175.52,369.73,62114.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','162273',3213623,'2334','356',317822.43,317822.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162273',3213624,'2335','356',604574.59,604996.13,421.54,70818.72,0.00,0.00,0.00,0.00,0.00),('1','113','823','162273',3213625,'2336','356',243571.49,243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162273',3213626,'2337','356',430762.52,431017.55,255.03,42845.04,0.00,0.00,0.00,0.00,0.00),('1','113','824','162273',3213627,'2338','357',778973.32,781259.29,2285.97,395472.81,0.00,0.00,0.00,0.00,0.00),('1','113','824','162273',3213628,'2339','357',1888086.27,1890635.79,2549.52,441066.96,0.00,0.00,0.00,0.00,0.00),('1','113','825','162273',3213629,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','162273',3213630,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162276',3213668,'2326','356',980488.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162276',3213669,'2327','356',468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162276',3213670,'2328','356',970233.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162276',3213671,'2329','356',426505.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162276',3213672,'2330','356',766926.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162276',3213673,'2331','356',386898.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162276',3213674,'2332','356',219086.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162276',3213675,'2333','356',823175.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162276',3213676,'2334','356',317822.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162276',3213677,'2335','356',604996.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162276',3213678,'2336','356',243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162276',3213679,'2337','356',431017.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','162276',3213680,'2338','357',781259.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','162276',3213681,'2339','357',1890635.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','162276',3213682,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','162276',3213683,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162278',3213707,'2326','356',980488.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162278',3213708,'2327','356',468130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162278',3213709,'2328','356',970233.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162278',3213710,'2329','356',426505.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162278',3213711,'2330','356',766926.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162278',3213712,'2331','356',386898.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162278',3213713,'2332','356',219086.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162278',3213714,'2333','356',823175.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162278',3213715,'2334','356',317822.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162278',3213716,'2335','356',604996.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162278',3213717,'2336','356',243571.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162278',3213718,'2337','356',431017.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','162278',3213719,'2338','357',781259.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','162278',3213720,'2339','357',1890635.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','162278',3213721,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','162278',3213722,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162342',3214741,'2326','356',980488.59,982330.45,1841.86,305748.76,0.00,0.00,0.00,0.00,0.00),('1','113','823','162342',3214742,'2327','356',470820.91,470820.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162342',3214743,'2328','356',0.00,1122.67,1122.67,186363.22,0.00,0.00,0.00,0.00,0.00),('1','113','823','162342',3214744,'2329','356',426505.15,427962.89,1457.74,241984.84,0.00,0.00,0.00,0.00,0.00),('1','113','823','162342',3214745,'2330','356',766926.23,768355.94,1429.71,237331.86,0.00,0.00,0.00,0.00,0.00),('1','113','823','162342',3214746,'2331','356',386898.07,387534.76,636.69,105690.54,0.00,0.00,0.00,0.00,0.00),('1','113','823','162342',3214747,'2332','356',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162342',3214748,'2333','356',823175.52,824566.38,1390.86,230882.76,0.00,0.00,0.00,0.00,0.00),('1','113','823','162342',3214749,'2334','356',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162342',3214750,'2335','356',604996.13,606314.61,1318.48,218867.68,0.00,0.00,0.00,0.00,0.00),('1','113','823','162342',3214751,'2336','356',243571.49,244318.06,706.57,117290.62,0.00,0.00,40.00,0.00,0.00),('1','113','823','162342',3214752,'2337','356',431017.55,431222.01,204.46,33940.36,0.00,0.00,0.00,0.00,0.00),('1','113','824','162342',3214753,'2338','357',781259.29,783681.33,2422.04,419012.92,0.00,0.00,0.00,0.00,0.00),('1','113','824','162342',3214754,'2339','357',1890635.79,1890862.14,226.35,39158.55,0.00,0.00,0.00,0.00,0.00),('1','113','825','162342',3214755,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','162342',3214756,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162397',3215687,'2326','356',982330.45,982330.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162397',3215688,'2327','356',470820.91,472456.20,1635.29,271458.14,0.00,0.00,0.00,0.00,0.00),('1','113','823','162397',3215689,'2328','356',1122.67,2068.77,946.10,157052.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','162397',3215690,'2329','356',427962.89,428750.88,787.99,130806.34,0.00,0.00,0.00,0.00,0.00),('1','113','823','162397',3215691,'2330','356',768355.94,768355.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162397',3215692,'2331','356',387534.76,388843.42,1308.66,217237.56,0.00,0.00,0.00,0.00,0.00),('1','113','823','162397',3215693,'2332','356',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162397',3215694,'2333','356',824566.38,825476.73,910.35,151118.10,0.00,0.00,0.00,0.00,0.00),('1','113','823','162397',3215695,'2334','356',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162397',3215696,'2335','356',606314.61,607248.12,933.51,154962.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','162397',3215697,'2336','356',244318.06,244965.17,647.11,107420.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','162397',3215698,'2337','356',431222.01,431222.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','162397',3215699,'2338','357',783681.33,784918.42,1237.09,214016.57,0.00,0.00,0.00,0.00,0.00),('1','113','824','162397',3215700,'2339','357',1890862.14,1892593.66,1731.52,299552.96,0.00,0.00,0.00,0.00,0.00),('1','113','825','162397',3215701,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','162397',3215702,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162528',3217759,'2326','356',982330.45,984166.48,1836.03,304780.98,0.00,0.00,0.00,0.00,0.00),('1','113','823','162528',3217760,'2327','356',472456.20,472456.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162528',3217761,'2328','356',2068.77,2068.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162528',3217762,'2329','356',428750.88,430481.05,1730.17,287208.22,0.00,0.00,0.00,0.00,0.00),('1','113','823','162528',3217763,'2330','356',768355.94,768355.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162528',3217764,'2331','356',388843.42,390472.87,1629.45,270488.70,0.00,0.00,0.00,0.00,0.00),('1','113','823','162528',3217765,'2332','356',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162528',3217766,'2333','356',825476.73,826932.67,1455.94,241686.04,0.00,0.00,0.00,0.00,0.00),('1','113','823','162528',3217767,'2334','356',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162528',3217768,'2335','356',607248.12,608680.29,1432.17,237740.22,0.00,0.00,0.00,0.00,0.00),('1','113','823','162528',3217769,'2336','356',244965.17,244965.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162528',3217770,'2337','356',431222.01,432021.05,799.04,132640.64,0.00,0.00,0.00,0.00,0.00),('1','113','824','162528',3217771,'2338','357',784918.42,788154.01,3235.59,559757.07,0.00,0.00,0.00,0.00,0.00),('1','113','824','162528',3217772,'2339','357',1892593.66,1895990.82,3397.16,587708.68,0.00,0.00,0.00,0.00,0.00),('1','113','825','162528',3217773,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','162528',3217774,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162578',3218514,'2326','356',984166.48,985078.35,911.87,151370.42,0.00,0.00,0.00,0.00,0.00),('1','113','823','162578',3218515,'2327','356',472456.20,473385.45,929.25,154255.50,0.00,0.00,0.00,0.00,0.00),('1','113','823','162578',3218516,'2328','356',2068.77,3160.83,1092.06,181281.96,0.00,0.00,0.00,0.00,0.00),('1','113','823','162578',3218517,'2329','356',430481.05,430481.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162578',3218518,'2330','356',768355.94,769629.61,1253.67,208109.22,0.00,0.00,20.00,0.00,0.00),('1','113','823','162578',3218519,'2331','356',390472.87,390472.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162578',3218520,'2332','356',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162578',3218521,'2333','356',826932.67,827790.37,857.70,142378.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','162578',3218522,'2334','356',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162578',3218523,'2335','356',608680.29,609301.62,600.88,99746.08,0.00,0.00,20.45,0.00,0.00),('1','113','823','162578',3218524,'2336','356',244965.17,245367.66,402.49,66813.34,0.00,0.00,0.00,0.00,0.00),('1','113','823','162578',3218525,'2337','356',432021.05,432021.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','162578',3218526,'2338','357',788154.01,789359.02,1205.01,208466.73,0.00,0.00,0.00,0.00,0.00),('1','113','824','162578',3218527,'2339','357',1895990.82,1898265.30,2274.48,393485.04,0.00,0.00,0.00,0.00,0.00),('1','113','825','162578',3218528,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','162578',3218529,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162671',3220105,'2326','356',985078.35,986528.15,1449.80,240666.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','162671',3220106,'2327','356',473385.45,473385.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162671',3220107,'2328','356',3160.83,3160.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162671',3220108,'2329','356',430481.05,431998.58,1517.53,251909.98,0.00,0.00,0.00,0.00,0.00),('1','113','823','162671',3220109,'2330','356',769629.61,771487.00,1857.39,308326.74,0.00,0.00,0.00,0.00,0.00),('1','113','823','162671',3220110,'2331','356',390472.87,390472.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162671',3220111,'2332','356',0.00,1227.27,1227.27,203726.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','162671',3220112,'2333','356',827790.37,827811.46,21.09,3500.94,0.00,0.00,0.00,0.00,0.00),('1','113','823','162671',3220113,'2334','356',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162671',3220114,'2335','356',609301.62,610432.11,1130.49,187661.34,0.00,0.00,0.00,0.00,0.00),('1','113','823','162671',3220115,'2336','356',245367.66,246185.72,818.06,135797.96,0.00,0.00,0.00,0.00,0.00),('1','113','823','162671',3220116,'2337','356',432021.05,432021.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','162671',3220117,'2338','357',789359.02,795150.54,5791.52,1001932.96,0.00,0.00,0.00,0.00,0.00),('1','113','824','162671',3220118,'2339','357',1898265.30,1904864.00,6598.70,1141575.10,0.00,0.00,0.00,0.00,0.00),('1','113','825','162671',3220119,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','162671',3220120,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162726',3221160,'2326','356',986528.15,987959.22,1431.07,237557.62,0.00,0.00,0.00,0.00,0.00),('1','113','823','162726',3221161,'2327','356',473385.45,473385.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162726',3221162,'2328','356',3160.83,3517.39,356.56,59188.96,0.00,0.00,0.00,0.00,0.00),('1','113','823','162726',3221163,'2329','356',431998.58,432945.27,946.69,157150.54,0.00,0.00,0.00,0.00,0.00),('1','113','823','162726',3221164,'2330','356',771487.00,771487.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162726',3221165,'2331','356',390472.87,391633.16,1160.29,192608.14,0.00,0.00,0.00,0.00,0.00),('1','113','823','162726',3221166,'2332','356',1227.27,1227.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162726',3221167,'2333','356',827811.46,828636.48,825.02,136953.32,0.00,0.00,0.00,0.00,0.00),('1','113','823','162726',3221168,'2334','356',0.00,916.34,916.34,152112.44,0.00,0.00,0.00,0.00,0.00),('1','113','823','162726',3221169,'2335','356',610432.11,610630.90,198.79,32999.14,0.00,0.00,0.00,0.00,0.00),('1','113','823','162726',3221170,'2336','356',246185.72,246185.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162726',3221171,'2337','356',432021.05,432342.79,321.74,53408.84,0.00,0.00,0.00,0.00,0.00),('1','113','824','162726',3221172,'2338','357',795150.54,797120.63,1970.09,340825.57,0.00,0.00,0.00,0.00,0.00),('1','113','824','162726',3221173,'2339','357',1904864.00,1906797.42,1933.42,334481.66,0.00,0.00,0.00,0.00,0.00),('1','113','825','162726',3221174,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','162726',3221175,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162849',3223356,'2326','356',987959.22,989722.60,1763.38,292721.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','162849',3223357,'2327','356',473385.45,473385.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162849',3223358,'2328','356',3517.39,5109.14,1591.75,264230.50,0.00,0.00,0.00,0.00,0.00),('1','113','823','162849',3223359,'2329','356',432945.27,432945.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162849',3223360,'2330','356',771487.00,771487.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162849',3223361,'2331','356',391633.16,392943.77,1310.61,217561.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','162849',3223362,'2332','356',1227.27,1227.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162849',3223363,'2333','356',828636.48,830559.79,1923.31,319269.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','162849',3223364,'2334','356',916.34,2115.52,1199.18,199063.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','162849',3223365,'2335','356',610630.90,610630.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162849',3223366,'2336','356',246185.72,247225.99,1040.27,172684.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','162849',3223367,'2337','356',432342.79,432342.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','162849',3223368,'2338','357',797120.63,799392.80,2272.17,393085.41,0.00,0.00,0.00,0.00,0.00),('1','113','824','162849',3223369,'2339','357',1906797.42,1908574.92,1777.50,307507.50,0.00,0.00,0.00,0.00,0.00),('1','113','825','162849',3223370,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','162849',3223371,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162960',3225431,'2326','356',989722.60,989722.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162960',3225432,'2327','356',473385.45,475088.32,1702.87,282676.42,0.00,0.00,0.00,0.00,0.00),('1','113','823','162960',3225433,'2328','356',5109.14,6717.28,1608.14,266951.24,0.00,0.00,0.00,0.00,0.00),('1','113','823','162960',3225434,'2329','356',432945.27,432945.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162960',3225435,'2330','356',771487.00,771487.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162960',3225436,'2331','356',392943.77,394128.42,1184.65,196651.90,0.00,0.00,0.00,0.00,0.00),('1','113','823','162960',3225437,'2332','356',1227.27,2124.26,896.99,148900.34,0.00,0.00,0.00,0.00,0.00),('1','113','823','162960',3225438,'2333','356',830559.79,830559.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162960',3225439,'2334','356',2115.52,3084.05,968.53,160775.98,0.00,0.00,0.00,0.00,0.00),('1','113','823','162960',3225440,'2335','356',610630.90,610630.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162960',3225441,'2336','356',247225.99,247225.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','162960',3225442,'2337','356',432342.79,433081.55,738.76,122634.16,0.00,0.00,0.00,0.00,0.00),('1','113','824','162960',3225443,'2338','357',799392.80,801158.21,1765.41,305415.93,0.00,0.00,0.00,0.00,0.00),('1','113','824','162960',3225444,'2339','357',1908574.92,1911822.18,3247.26,561775.98,0.00,0.00,0.00,0.00,0.00),('1','113','825','162960',3225445,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','162960',3225446,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163050',3226863,'2326','356',989722.60,991767.42,2044.82,339440.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','163050',3226864,'2327','356',475088.32,475088.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163050',3226865,'2328','356',6717.28,8244.63,1527.35,253540.10,0.00,0.00,0.00,0.00,0.00),('1','113','823','163050',3226866,'2329','356',432945.27,432945.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163050',3226867,'2330','356',771487.00,771487.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163050',3226868,'2331','356',394128.42,395882.39,1753.97,291159.02,0.00,0.00,0.00,0.00,0.00),('1','113','823','163050',3226869,'2332','356',2124.26,3633.83,1509.57,250588.62,0.00,0.00,0.00,0.00,0.00),('1','113','823','163050',3226870,'2333','356',830559.79,830559.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163050',3226871,'2334','356',3084.05,3796.41,712.36,118251.76,0.00,0.00,0.00,0.00,0.00),('1','113','823','163050',3226872,'2335','356',610630.90,610630.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163050',3226873,'2336','356',247225.99,248375.66,1149.67,190845.22,0.00,0.00,0.00,0.00,0.00),('1','113','823','163050',3226874,'2337','356',433081.55,433081.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','163050',3226875,'2338','357',801158.21,804450.12,3291.91,569500.43,0.00,0.00,0.00,0.00,0.00),('1','113','824','163050',3226876,'2339','357',1911822.18,1914040.16,2217.98,383710.54,0.00,0.00,0.00,0.00,0.00),('1','113','825','163050',3226877,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','163050',3226878,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163139',3228624,'2326','356',991767.42,993500.82,1733.40,287744.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','163139',3228625,'2327','356',475088.32,475088.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163139',3228626,'2328','356',8244.63,8697.76,453.13,75219.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','163139',3228627,'2329','356',432945.27,432945.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163139',3228628,'2330','356',771487.00,773349.82,1862.82,309228.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','163139',3228629,'2331','356',395882.39,395882.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163139',3228630,'2332','356',3633.83,3633.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163139',3228631,'2333','356',830559.79,832307.20,1737.41,288410.06,0.00,0.00,10.00,0.00,0.00),('1','113','823','163139',3228632,'2334','356',3796.41,3796.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163139',3228633,'2335','356',610630.90,611995.57,1364.67,226535.22,0.00,0.00,0.00,0.00,0.00),('1','113','823','163139',3228634,'2336','356',248375.66,248375.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163139',3228635,'2337','356',433081.55,433081.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','163139',3228636,'2338','357',804450.12,808059.58,3609.46,624436.58,0.00,0.00,0.00,0.00,0.00),('1','113','824','163139',3228637,'2339','357',1914040.16,1917922.38,3882.22,671624.06,0.00,0.00,0.00,0.00,0.00),('1','113','825','163139',3228638,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','163139',3228639,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163243',3230379,'2326','356',993500.82,995615.41,2114.59,351021.94,0.00,0.00,0.00,0.00,0.00),('1','113','823','163243',3230380,'2327','356',475088.32,475088.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163243',3230381,'2328','356',8697.76,10656.31,1958.55,325119.30,0.00,0.00,0.00,0.00,0.00),('1','113','823','163243',3230382,'2329','356',432945.27,432945.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163243',3230383,'2330','356',773349.82,773349.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163243',3230384,'2331','356',395882.39,397175.18,1292.79,214603.14,0.00,0.00,0.00,0.00,0.00),('1','113','823','163243',3230385,'2332','356',3633.83,5403.89,1770.06,293829.96,0.00,0.00,0.00,0.00,0.00),('1','113','823','163243',3230386,'2333','356',832307.20,832307.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163243',3230387,'2334','356',3796.41,3796.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163243',3230388,'2335','356',611995.57,613591.79,1596.22,264972.52,0.00,0.00,0.00,0.00,0.00),('1','113','823','163243',3230389,'2336','356',248375.66,248375.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163243',3230390,'2337','356',433081.55,433109.86,28.31,4699.46,0.00,0.00,0.00,0.00,0.00),('1','113','824','163243',3230391,'2338','357',808059.58,810033.23,1973.65,341441.45,0.00,0.00,0.00,0.00,0.00),('1','113','824','163243',3230392,'2339','357',1917922.38,1921560.56,3638.18,629405.14,0.00,0.00,0.00,0.00,0.00),('1','113','825','163243',3230393,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','163243',3230394,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163408',3233310,'2326','356',995615.41,996541.71,926.30,153765.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','163408',3233311,'2327','356',475088.32,475088.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163408',3233312,'2328','356',10656.31,12326.23,1669.92,277206.72,0.00,0.00,0.00,0.00,0.00),('1','113','823','163408',3233313,'2329','356',432945.27,432945.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163408',3233314,'2330','356',773349.82,773349.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163408',3233315,'2331','356',397175.18,398241.42,1066.24,176995.84,0.00,0.00,0.00,0.00,0.00),('1','113','823','163408',3233316,'2332','356',5403.89,5403.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163408',3233317,'2333','356',832307.20,832307.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163408',3233318,'2334','356',3796.41,3796.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163408',3233319,'2335','356',613591.79,615134.14,1542.35,256030.10,0.00,0.00,0.00,0.00,0.00),('1','113','823','163408',3233320,'2336','356',248375.66,249493.99,1118.33,185642.78,0.00,0.00,0.00,0.00,0.00),('1','113','823','163408',3233321,'2337','356',433109.86,433109.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','163408',3233322,'2338','357',810033.23,813580.99,3547.76,613762.48,0.00,0.00,0.00,0.00,0.00),('1','113','824','163408',3233323,'2339','357',1921560.56,1926289.35,4728.79,818080.67,0.00,0.00,0.00,0.00,0.00),('1','113','825','163408',3233324,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','163408',3233325,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163412',3233381,'2326','356',996541.71,999035.79,2494.08,414017.28,0.00,0.00,0.00,0.00,0.00),('1','113','823','163412',3233382,'2327','356',475088.32,475088.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163412',3233383,'2328','356',12326.23,12326.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163412',3233384,'2329','356',432945.27,432945.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163412',3233385,'2330','356',773349.82,773349.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163412',3233386,'2331','356',398241.42,400029.62,1788.20,296841.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','163412',3233387,'2332','356',5403.89,7248.35,1844.46,306180.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','163412',3233388,'2333','356',832307.20,832307.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163412',3233389,'2334','356',3796.41,3796.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163412',3233390,'2335','356',615134.14,616514.83,1380.69,229194.54,0.00,0.00,0.00,0.00,0.00),('1','113','823','163412',3233391,'2336','356',249493.99,250295.41,801.42,133035.72,0.00,0.00,0.00,0.00,0.00),('1','113','823','163412',3233392,'2337','356',433109.86,433109.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','163412',3233393,'2338','357',813580.99,816137.81,2556.82,442329.86,0.00,0.00,0.00,0.00,0.00),('1','113','824','163412',3233394,'2339','357',1926289.35,1929605.55,3316.20,573702.60,0.00,0.00,0.00,0.00,0.00),('1','113','825','163412',3233395,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','163412',3233396,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163580',3236479,'2326','356',999035.79,1000841.77,1805.98,299792.68,0.00,0.00,0.00,0.00,0.00),('1','113','823','163580',3236480,'2327','356',475088.32,475088.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163580',3236481,'2328','356',12326.23,12346.23,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','113','823','163580',3236482,'2329','356',432945.27,432945.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163580',3236483,'2330','356',773349.82,775037.36,1687.54,280131.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','163580',3236484,'2331','356',400029.62,400032.63,3.01,499.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','163580',3236485,'2332','356',7248.35,7248.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163580',3236486,'2333','356',832307.20,832307.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163580',3236487,'2334','356',3796.41,4924.97,1128.56,187340.96,0.00,0.00,0.00,0.00,0.00),('1','113','823','163580',3236488,'2335','356',616514.83,616514.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163580',3236489,'2336','356',250295.41,250295.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163580',3236490,'2337','356',433109.86,434049.88,940.02,156043.32,0.00,0.00,0.00,0.00,0.00),('1','113','824','163580',3236491,'2338','357',816137.81,816987.97,840.16,145347.68,0.00,0.00,10.00,0.00,0.00),('1','113','824','163580',3236492,'2339','357',1929605.55,1932616.56,3001.01,519174.73,0.00,0.00,10.00,0.00,0.00),('1','113','825','163580',3236493,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','163580',3236494,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163584',3236520,'2326','356',1000841.77,1000841.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163584',3236521,'2327','356',475088.32,475088.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163584',3236522,'2328','356',12346.23,14413.11,2066.88,343102.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','163584',3236523,'2329','356',432945.27,432945.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163584',3236524,'2330','356',775037.36,775037.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163584',3236525,'2331','356',400032.63,401877.50,1844.87,306248.42,0.00,0.00,0.00,0.00,0.00),('1','113','823','163584',3236526,'2332','356',7248.35,8893.33,1644.98,273066.68,0.00,0.00,0.00,0.00,0.00),('1','113','823','163584',3236527,'2333','356',832307.20,832307.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163584',3236528,'2334','356',4924.97,4924.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163584',3236529,'2335','356',616514.83,617550.54,1035.71,171927.86,0.00,0.00,0.00,0.00,0.00),('1','113','823','163584',3236530,'2336','356',250295.41,251698.97,1403.56,232990.96,0.00,0.00,0.00,0.00,0.00),('1','113','823','163584',3236531,'2337','356',434049.88,434049.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','163584',3236532,'2338','357',816987.97,821168.72,4180.75,723269.75,0.00,0.00,0.00,0.00,0.00),('1','113','824','163584',3236533,'2339','357',1932616.56,1936837.19,4220.63,730168.99,0.00,0.00,0.00,0.00,0.00),('1','113','825','163584',3236534,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','163584',3236535,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163667',3238053,'2326','356',1000841.77,1001502.25,660.48,109639.68,0.00,0.00,0.00,0.00,0.00),('1','113','823','163667',3238054,'2327','356',475088.32,475088.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163667',3238055,'2328','356',14413.11,15095.54,682.43,113283.38,0.00,0.00,0.00,0.00,0.00),('1','113','823','163667',3238056,'2329','356',432945.27,432945.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163667',3238057,'2330','356',775037.36,775037.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163667',3238058,'2331','356',401877.50,402704.53,827.03,137286.98,0.00,0.00,0.00,0.00,0.00),('1','113','823','163667',3238059,'2332','356',8893.33,9511.63,618.30,102637.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','163667',3238060,'2333','356',832307.20,832307.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163667',3238061,'2334','356',4924.97,4924.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163667',3238062,'2335','356',617550.54,617550.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163667',3238063,'2336','356',251698.97,251698.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163667',3238064,'2337','356',434049.88,434049.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','163667',3238065,'2338','357',821168.72,822858.06,1689.34,292255.82,0.00,0.00,0.00,0.00,0.00),('1','113','824','163667',3238066,'2339','357',1936837.19,1939724.03,2886.84,499423.32,0.00,0.00,0.00,0.00,0.00),('1','113','825','163667',3238067,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','163667',3238068,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163670',3238089,'2326','356',1001502.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163670',3238090,'2327','356',475088.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163670',3238091,'2328','356',15095.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163670',3238092,'2329','356',432945.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163670',3238093,'2330','356',775037.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163670',3238094,'2331','356',402704.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163670',3238095,'2332','356',9511.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163670',3238096,'2333','356',832307.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163670',3238097,'2334','356',4924.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163670',3238098,'2335','356',617550.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163670',3238099,'2336','356',251698.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163670',3238100,'2337','356',434049.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','163670',3238101,'2338','357',822858.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','163670',3238102,'2339','357',1939724.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','163670',3238103,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','163670',3238104,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163671',3238105,'2326','356',1001502.25,1002355.25,853.00,139039.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163671',3238106,'2327','356',475088.32,477037.71,1949.39,317750.57,0.00,0.00,0.00,0.00,0.00),('1','113','823','163671',3238107,'2328','356',15095.54,17041.89,1946.35,317255.05,0.00,0.00,0.00,0.00,0.00),('1','113','823','163671',3238108,'2329','356',432945.27,433882.56,937.29,152778.27,0.00,0.00,0.00,0.00,0.00),('1','113','823','163671',3238109,'2330','356',775037.36,775037.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163671',3238110,'2331','356',402704.53,405010.16,2305.63,375817.69,0.00,0.00,0.00,0.00,0.00),('1','113','823','163671',3238111,'2332','356',9511.63,10386.30,874.67,142571.21,0.00,0.00,0.00,0.00,0.00),('1','113','823','163671',3238112,'2333','356',832307.20,833403.58,1096.38,178709.94,0.00,0.00,0.00,0.00,0.00),('1','113','823','163671',3238113,'2334','356',4924.97,4924.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163671',3238114,'2335','356',617550.54,618918.06,1367.52,222905.76,0.00,0.00,0.00,0.00,0.00),('1','113','823','163671',3238115,'2336','356',251698.97,253192.41,1493.44,243430.72,0.00,0.00,0.00,0.00,0.00),('1','113','823','163671',3238116,'2337','356',434049.88,434049.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','163671',3238117,'2338','357',822858.06,825586.73,2728.67,472059.91,0.00,0.00,0.00,0.00,0.00),('1','113','824','163671',3238118,'2339','357',1939724.03,1941436.00,1711.97,296170.81,0.00,0.00,0.00,0.00,0.00),('1','113','825','163671',3238119,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','163671',3238120,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163852',3241302,'2326','356',1002355.25,1003626.99,1271.74,207293.62,0.00,0.00,0.00,0.00,0.00),('1','113','823','163852',3241303,'2327','356',477037.71,477037.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163852',3241304,'2328','356',17041.89,18619.28,1577.39,257114.57,0.00,0.00,0.00,0.00,0.00),('1','113','823','163852',3241305,'2329','356',433882.56,433885.63,0.00,0.00,0.00,0.00,3.07,0.00,0.00),('1','113','823','163852',3241306,'2330','356',775037.36,775037.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163852',3241307,'2331','356',405010.16,406326.00,1315.84,214481.92,0.00,0.00,0.00,0.00,0.00),('1','113','823','163852',3241308,'2332','356',10386.30,11732.27,1345.97,219393.11,0.00,0.00,0.00,0.00,0.00),('1','113','823','163852',3241309,'2333','356',833403.58,833403.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163852',3241310,'2334','356',4924.97,4924.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163852',3241311,'2335','356',618918.06,618918.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163852',3241312,'2336','356',253192.41,254165.32,972.91,158584.33,0.00,0.00,0.00,0.00,0.00),('1','113','823','163852',3241313,'2337','356',434049.88,434049.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','163852',3241314,'2338','357',825586.73,829420.85,3834.12,663302.76,0.00,0.00,0.00,0.00,0.00),('1','113','824','163852',3241315,'2339','357',1941436.00,1943152.13,1716.13,296890.49,0.00,0.00,0.00,0.00,0.00),('1','113','825','163852',3241316,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','163852',3241317,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163958',3243254,'2326','356',1003626.99,1003626.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163958',3243255,'2327','356',477037.71,478589.45,1551.74,252933.62,0.00,0.00,0.00,0.00,0.00),('1','113','823','163958',3243256,'2328','356',18619.28,20003.70,1384.42,225660.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','163958',3243257,'2329','356',433885.63,433885.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163958',3243258,'2330','356',775037.36,776068.65,1031.29,168100.27,0.00,0.00,0.00,0.00,0.00),('1','113','823','163958',3243259,'2331','356',406326.00,406908.47,582.47,94942.61,0.00,0.00,0.00,0.00,0.00),('1','113','823','163958',3243260,'2332','356',11732.27,11732.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163958',3243261,'2333','356',833403.58,834310.00,906.42,147746.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','163958',3243262,'2334','356',4924.97,5754.40,829.43,135197.09,0.00,0.00,0.00,0.00,0.00),('1','113','823','163958',3243263,'2335','356',618918.06,618918.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','163958',3243264,'2336','356',254165.32,255211.63,1046.31,170548.53,0.00,0.00,0.00,0.00,0.00),('1','113','823','163958',3243265,'2337','356',434049.88,434050.00,0.12,19.56,0.00,0.00,0.00,0.00,0.00),('1','113','824','163958',3243266,'2338','357',829420.85,832491.87,3071.02,531286.46,0.00,0.00,0.00,0.00,0.00),('1','113','824','163958',3243267,'2339','357',1943152.13,1945870.58,2718.45,470291.85,0.00,0.00,0.00,0.00,0.00),('1','113','825','163958',3243268,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','163958',3243269,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164083',3245532,'2326','356',1003626.99,1005113.07,1486.08,242231.04,0.00,0.00,0.00,0.00,0.00),('1','113','823','164083',3245533,'2327','356',478589.45,478589.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164083',3245534,'2328','356',20003.70,21235.11,1231.41,200719.83,0.00,0.00,0.00,0.00,0.00),('1','113','823','164083',3245535,'2329','356',433885.63,433885.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164083',3245536,'2330','356',776068.65,776068.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164083',3245537,'2331','356',406908.47,408212.15,1303.68,212499.84,0.00,0.00,0.00,0.00,0.00),('1','113','823','164083',3245538,'2332','356',11732.27,12701.46,969.19,157977.97,0.00,0.00,0.00,0.00,0.00),('1','113','823','164083',3245539,'2333','356',834310.00,834310.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164083',3245540,'2334','356',5754.40,5754.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164083',3245541,'2335','356',618918.06,619640.51,722.45,117759.35,0.00,0.00,0.00,0.00,0.00),('1','113','823','164083',3245542,'2336','356',255211.63,255748.30,536.67,87477.21,0.00,0.00,0.00,0.00,0.00),('1','113','823','164083',3245543,'2337','356',434050.00,434050.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','164083',3245544,'2338','357',832491.87,833996.97,1505.10,260382.30,0.00,0.00,0.00,0.00,0.00),('1','113','824','164083',3245545,'2339','357',1945870.58,1950260.21,4389.63,759405.99,0.00,0.00,0.00,0.00,0.00),('1','113','825','164083',3245546,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','164083',3245547,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164085',3245566,'2326','356',1005113.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164085',3245567,'2327','356',478589.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164085',3245568,'2328','356',21235.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164085',3245569,'2329','356',433885.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164085',3245570,'2330','356',776068.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164085',3245571,'2331','356',408212.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164085',3245572,'2332','356',12701.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164085',3245573,'2333','356',834310.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164085',3245574,'2334','356',5754.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164085',3245575,'2335','356',619640.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164085',3245576,'2336','356',255748.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164085',3245577,'2337','356',434050.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','164085',3245578,'2338','357',833996.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','164085',3245579,'2339','357',1950260.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','164085',3245580,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','164085',3245581,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164086',3245582,'2326','356',1005113.07,1007158.28,2035.21,331739.23,0.00,0.00,10.00,0.00,0.00),('1','113','823','164086',3245583,'2327','356',478589.45,478589.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164086',3245584,'2328','356',21235.11,21235.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164086',3245585,'2329','356',433885.63,435411.90,1526.27,248782.01,0.00,0.00,0.00,0.00,0.00),('1','113','823','164086',3245586,'2330','356',776068.65,776068.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164086',3245587,'2331','356',408212.15,409818.12,1605.97,261773.11,0.00,0.00,0.00,0.00,0.00),('1','113','823','164086',3245588,'2332','356',12701.46,12701.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164086',3245589,'2333','356',834310.00,835487.34,1177.34,191906.42,0.00,0.00,0.00,0.00,0.00),('1','113','823','164086',3245590,'2334','356',5754.40,5754.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164086',3245591,'2335','356',619640.51,620939.82,1299.31,211787.53,0.00,0.00,0.00,0.00,0.00),('1','113','823','164086',3245592,'2336','356',255748.30,255748.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164086',3245593,'2337','356',434050.00,434983.88,923.88,150592.44,0.00,0.00,10.00,0.00,0.00),('1','113','824','164086',3245594,'2338','357',833996.97,838388.18,4391.21,790417.80,0.00,0.00,0.00,0.00,0.00),('1','113','824','164086',3245595,'2339','357',1950260.21,1951846.39,1586.18,285512.40,0.00,0.00,0.00,0.00,0.00),('1','113','825','164086',3245596,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','164086',3245597,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164278',3249081,'2326','356',1007158.28,1008745.25,1586.97,258676.11,0.00,0.00,0.00,0.00,0.00),('1','113','823','164278',3249082,'2327','356',478589.45,478589.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164278',3249083,'2328','356',21235.11,22608.44,1373.33,223852.79,0.00,0.00,0.00,0.00,0.00),('1','113','823','164278',3249084,'2329','356',435411.90,435411.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164278',3249085,'2330','356',776068.65,777372.04,1303.39,212452.57,0.00,0.00,0.00,0.00,0.00),('1','113','823','164278',3249086,'2331','356',409818.12,409818.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164278',3249087,'2332','356',12701.46,13829.90,1128.44,183935.72,0.00,0.00,0.00,0.00,0.00),('1','113','823','164278',3249088,'2333','356',835487.34,835487.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164278',3249089,'2334','356',5754.40,5754.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164278',3249090,'2335','356',620939.82,621720.04,780.22,127175.86,0.00,0.00,0.00,0.00,0.00),('1','113','823','164278',3249091,'2336','356',255748.30,256281.75,533.45,86952.35,0.00,0.00,0.00,0.00,0.00),('1','113','823','164278',3249092,'2337','356',434983.88,434983.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','164278',3249093,'2338','357',838388.18,839462.25,1074.07,193332.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','164278',3249094,'2339','357',1951846.39,1953759.86,1913.47,344424.60,0.00,0.00,0.00,0.00,0.00),('1','113','825','164278',3249095,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','164278',3249096,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164299',3249385,'2326','356',1008745.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164299',3249386,'2327','356',478589.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164299',3249387,'2328','356',22608.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164299',3249388,'2329','356',435411.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164299',3249389,'2330','356',777372.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164299',3249390,'2331','356',409818.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164299',3249391,'2332','356',13829.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164299',3249392,'2333','356',835487.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164299',3249393,'2334','356',5754.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164299',3249394,'2335','356',621720.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164299',3249395,'2336','356',256281.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164299',3249396,'2337','356',434983.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','164299',3249397,'2338','357',839462.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','164299',3249398,'2339','357',1953759.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','164299',3249399,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','164299',3249400,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164300',3249401,'2326','356',1008745.25,1010549.16,1803.91,294037.33,0.00,0.00,0.00,0.00,0.00),('1','113','823','164300',3249402,'2327','356',478589.45,478589.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164300',3249403,'2328','356',22608.44,22608.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164300',3249404,'2329','356',435411.90,437265.75,1853.85,302177.55,0.00,0.00,0.00,0.00,0.00),('1','113','823','164300',3249405,'2330','356',777372.04,777372.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164300',3249406,'2331','356',409818.12,411300.15,1482.03,241570.89,0.00,0.00,0.00,0.00,0.00),('1','113','823','164300',3249407,'2332','356',13829.90,13829.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164300',3249408,'2333','356',835487.34,836837.13,1349.79,220015.77,0.00,0.00,0.00,0.00,0.00),('1','113','823','164300',3249409,'2334','356',5754.40,6574.50,820.10,133676.30,0.00,0.00,0.00,0.00,0.00),('1','113','823','164300',3249410,'2335','356',621720.04,621720.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164300',3249411,'2336','356',256281.75,257279.06,997.31,162561.53,0.00,0.00,0.00,0.00,0.00),('1','113','823','164300',3249412,'2337','356',434983.88,435145.85,161.97,26401.11,0.00,0.00,0.00,0.00,0.00),('1','113','824','164300',3249413,'2338','357',839462.25,842862.59,3400.34,629062.90,0.00,0.00,0.00,0.00,0.00),('1','113','824','164300',3249414,'2339','357',1953759.86,1958108.70,4348.84,804535.40,0.00,0.00,0.00,0.00,0.00),('1','113','825','164300',3249415,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','164300',3249416,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164422',3251970,'2326','356',1010549.16,1012288.04,1738.88,283437.44,0.00,0.00,0.00,0.00,0.00),('1','113','823','164422',3251971,'2327','356',478589.45,478589.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164422',3251972,'2328','356',22608.44,23999.56,1391.12,226752.56,0.00,0.00,0.00,0.00,0.00),('1','113','823','164422',3251973,'2329','356',437265.75,437265.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164422',3251974,'2330','356',777372.04,777372.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164422',3251975,'2331','356',411300.15,412699.33,1399.18,228066.34,0.00,0.00,0.00,0.00,0.00),('1','113','823','164422',3251976,'2332','356',13829.90,15051.36,1221.46,199097.98,0.00,0.00,0.00,0.00,0.00),('1','113','823','164422',3251977,'2333','356',836837.13,836837.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164422',3251978,'2334','356',6574.50,6574.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164422',3251979,'2335','356',621720.04,622897.78,1177.74,191971.62,0.00,0.00,0.00,0.00,0.00),('1','113','823','164422',3251980,'2336','356',257279.06,257649.31,370.25,60350.75,0.00,0.00,0.00,0.00,0.00),('1','113','823','164422',3251981,'2337','356',435145.85,435145.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','164422',3251982,'2338','357',842862.59,843743.83,861.24,159329.40,0.00,0.00,20.00,0.00,0.00),('1','113','824','164422',3251983,'2339','357',1958108.70,1960185.20,2076.50,384152.50,0.00,0.00,0.00,0.00,0.00),('1','113','825','164422',3251984,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','164422',3251985,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164460',3252423,'2326','356',1012288.04,1014404.84,2116.80,345038.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','164460',3252424,'2327','356',478589.45,478589.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164460',3252425,'2328','356',23999.56,26093.72,2094.16,341348.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','164460',3252426,'2329','356',437265.75,437265.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164460',3252427,'2330','356',777372.04,779220.93,1848.89,301369.07,0.00,0.00,0.00,0.00,0.00),('1','113','823','164460',3252428,'2331','356',412699.33,412699.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164460',3252429,'2332','356',15051.36,15051.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164460',3252430,'2333','356',836837.13,838281.62,1444.49,235451.87,0.00,0.00,0.00,0.00,0.00),('1','113','823','164460',3252431,'2334','356',6574.50,7892.19,1307.69,213153.47,0.00,0.00,10.00,0.00,0.00),('1','113','823','164460',3252432,'2335','356',622897.78,622897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164460',3252433,'2336','356',257649.31,257649.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164460',3252434,'2337','356',435145.85,435822.58,676.73,110306.99,0.00,0.00,0.00,0.00,0.00),('1','113','824','164460',3252435,'2338','357',843743.83,844617.81,873.98,161686.30,0.00,0.00,0.00,0.00,0.00),('1','113','824','164460',3252436,'2339','357',1960185.20,1963589.36,3404.16,629769.60,0.00,0.00,0.00,0.00,0.00),('1','113','825','164460',3252437,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','164460',3252438,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164556',3254200,'2326','356',1014404.84,1015909.96,1505.12,245334.56,0.00,0.00,0.00,0.00,0.00),('1','113','823','164556',3254201,'2327','356',478589.45,478589.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164556',3254202,'2328','356',26093.72,27521.84,1428.12,232783.56,0.00,0.00,0.00,0.00,0.00),('1','113','823','164556',3254203,'2329','356',437265.75,437265.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164556',3254204,'2330','356',779220.93,779220.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164556',3254205,'2331','356',412699.33,413821.75,1122.42,182954.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','164556',3254206,'2332','356',15051.36,15430.28,378.92,61763.96,0.00,0.00,0.00,0.00,0.00),('1','113','823','164556',3254207,'2333','356',838281.62,839048.22,766.60,124955.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','164556',3254208,'2334','356',7892.19,7892.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164556',3254209,'2335','356',622897.78,623548.31,650.53,106036.39,0.00,0.00,0.00,0.00,0.00),('1','113','823','164556',3254210,'2336','356',257649.31,258555.50,906.19,147708.97,0.00,0.00,0.00,0.00,0.00),('1','113','823','164556',3254211,'2337','356',435822.58,435822.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','164556',3254212,'2338','357',844617.81,847019.82,2402.01,444371.85,0.00,0.00,0.00,0.00,0.00),('1','113','824','164556',3254213,'2339','357',1963589.36,1966393.02,2803.66,518677.10,0.00,0.00,0.00,0.00,0.00),('1','113','825','164556',3254214,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','164556',3254215,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164794',3258487,'2326','356',1015909.96,1018161.67,2251.71,367028.73,0.00,0.00,0.00,0.00,0.00),('1','113','823','164794',3258488,'2327','356',478589.45,478742.20,152.75,24898.25,0.00,0.00,0.00,0.00,0.00),('1','113','823','164794',3258489,'2328','356',27521.84,27831.73,309.89,50512.07,0.00,0.00,0.00,0.00,0.00),('1','113','823','164794',3258490,'2329','356',437265.75,437265.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164794',3258491,'2330','356',779220.93,779246.69,25.76,4198.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','164794',3258492,'2331','356',413821.75,415624.32,1802.57,293818.91,0.00,0.00,0.00,0.00,0.00),('1','113','823','164794',3258493,'2332','356',15430.28,15430.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164794',3258494,'2333','356',839048.22,841125.98,2077.76,338674.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','164794',3258495,'2334','356',7892.19,7892.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164794',3258496,'2335','356',623548.31,625197.74,1649.43,268857.09,0.00,0.00,0.00,0.00,0.00),('1','113','823','164794',3258497,'2336','356',258555.50,259949.48,1393.98,227218.74,0.00,0.00,0.00,0.00,0.00),('1','113','823','164794',3258498,'2337','356',435822.58,435822.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','164794',3258499,'2338','357',847019.82,850726.95,3707.13,685819.05,0.00,0.00,0.00,0.00,0.00),('1','113','824','164794',3258500,'2339','357',1966393.02,1969870.04,3477.02,643248.70,0.00,0.00,0.00,0.00,0.00),('1','113','825','164794',3258501,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','164794',3258502,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164796',3258504,'2326','356',1018161.67,1019696.11,1524.44,248483.72,0.00,0.00,10.00,0.00,0.00),('1','113','823','164796',3258505,'2327','356',478742.20,478762.20,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','113','823','164796',3258506,'2328','356',27831.73,29241.02,1389.29,226454.27,0.00,0.00,20.00,0.00,0.00),('1','113','823','164796',3258507,'2329','356',437265.75,437265.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164796',3258508,'2330','356',779246.69,779256.69,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','113','823','164796',3258509,'2331','356',415624.32,416986.22,1351.90,220359.70,0.00,0.00,10.00,0.00,0.00),('1','113','823','164796',3258510,'2332','356',15430.28,15444.57,0.00,0.00,0.00,0.00,14.29,0.00,0.00),('1','113','823','164796',3258511,'2333','356',841125.98,842065.28,929.30,151475.90,0.00,0.00,10.00,0.00,0.00),('1','113','823','164796',3258512,'2334','356',7892.19,7912.19,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','113','823','164796',3258513,'2335','356',625197.74,625908.47,690.73,112588.99,0.00,0.00,20.00,0.00,0.00),('1','113','823','164796',3258514,'2336','356',259949.48,260644.13,684.65,111597.95,0.00,0.00,10.00,0.00,0.00),('1','113','823','164796',3258515,'2337','356',435822.58,435834.58,0.00,0.00,0.00,0.00,12.00,0.00,0.00),('1','113','824','164796',3258516,'2338','357',850726.95,852689.77,1952.82,361271.70,0.00,0.00,10.00,0.00,0.00),('1','113','824','164796',3258517,'2339','357',1969870.04,1971523.02,1642.98,303951.30,0.00,0.00,10.00,0.00,0.00),('1','113','825','164796',3258518,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','164796',3258519,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164799',3258538,'2326','356',1019696.11,1020989.85,1293.74,210879.62,0.00,0.00,0.00,0.00,0.00),('1','113','823','164799',3258539,'2327','356',478762.20,478762.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164799',3258540,'2328','356',29241.02,30865.26,1624.24,264751.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','164799',3258541,'2329','356',437265.75,437265.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164799',3258542,'2330','356',779256.69,780894.66,1637.97,266989.11,0.00,0.00,0.00,0.00,0.00),('1','113','823','164799',3258543,'2331','356',416986.22,416986.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164799',3258544,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164799',3258545,'2333','356',842065.28,843429.51,1364.23,222369.49,0.00,0.00,0.00,0.00,0.00),('1','113','823','164799',3258546,'2334','356',7912.19,8973.97,1061.78,173070.14,0.00,0.00,0.00,0.00,0.00),('1','113','823','164799',3258547,'2335','356',625908.47,625908.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164799',3258548,'2336','356',260644.13,260644.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164799',3258549,'2337','356',435834.58,436551.09,716.51,116791.13,0.00,0.00,0.00,0.00,0.00),('1','113','824','164799',3258550,'2338','357',852689.77,853529.22,839.45,155298.25,0.00,0.00,0.00,0.00,0.00),('1','113','824','164799',3258551,'2339','357',1971523.02,1972956.47,1433.45,265188.25,0.00,0.00,0.00,0.00,0.00),('1','113','825','164799',3258552,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','164799',3258553,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164869',3259866,'2326','356',1020989.85,1020989.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164869',3259867,'2327','356',478762.20,480592.97,1830.77,298415.51,0.00,0.00,0.00,0.00,0.00),('1','113','823','164869',3259868,'2328','356',30865.26,30865.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164869',3259869,'2329','356',437265.75,438524.40,1258.65,205159.95,0.00,0.00,0.00,0.00,0.00),('1','113','823','164869',3259870,'2330','356',780894.66,780894.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164869',3259871,'2331','356',416986.22,418546.74,1560.52,254364.76,0.00,0.00,0.00,0.00,0.00),('1','113','823','164869',3259872,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164869',3259873,'2333','356',843429.51,844171.46,741.95,120937.85,0.00,0.00,0.00,0.00,0.00),('1','113','823','164869',3259874,'2334','356',8973.97,8973.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','164869',3259875,'2335','356',625908.47,626816.18,907.71,147956.73,0.00,0.00,0.00,0.00,0.00),('1','113','823','164869',3259876,'2336','356',260644.13,261590.05,935.92,152554.96,0.00,0.00,10.00,0.00,0.00),('1','113','823','164869',3259877,'2337','356',436551.09,436551.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','164869',3259878,'2338','357',853529.22,856641.73,3102.51,573964.35,0.00,0.00,10.00,0.00,0.00),('1','113','824','164869',3259879,'2339','357',1972956.47,1975478.83,2512.36,464786.60,0.00,0.00,10.00,0.00,0.00),('1','113','825','164869',3259880,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','164869',3259881,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165015',3262247,'2326','356',1020989.85,1023088.96,2099.11,342154.93,0.00,0.00,0.00,0.00,0.00),('1','113','823','165015',3262248,'2327','356',480592.97,480594.20,1.23,200.49,0.00,0.00,0.00,0.00,0.00),('1','113','823','165015',3262249,'2328','356',30865.26,32602.77,1737.51,283214.13,0.00,0.00,0.00,0.00,0.00),('1','113','823','165015',3262250,'2329','356',438524.40,438524.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165015',3262251,'2330','356',780894.66,782274.62,1379.96,224933.48,0.00,0.00,0.00,0.00,0.00),('1','113','823','165015',3262252,'2331','356',418546.74,418546.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165015',3262253,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165015',3262254,'2333','356',844171.46,845808.61,1637.15,266855.45,0.00,0.00,0.00,0.00,0.00),('1','113','823','165015',3262255,'2334','356',8973.97,8973.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165015',3262256,'2335','356',626816.18,628170.91,1354.73,220820.99,0.00,0.00,0.00,0.00,0.00),('1','113','823','165015',3262257,'2336','356',261590.05,261590.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165015',3262258,'2337','356',436551.09,437309.75,758.66,123661.58,0.00,0.00,0.00,0.00,0.00),('1','113','824','165015',3262259,'2338','357',856641.73,859671.31,3029.58,560472.30,0.00,0.00,0.00,0.00,0.00),('1','113','824','165015',3262260,'2339','357',1975478.83,1979000.52,3521.69,651512.65,0.00,0.00,0.00,0.00,0.00),('1','113','825','165015',3262261,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','165015',3262262,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165154',3264827,'2326','356',1023088.96,1023088.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165154',3264828,'2327','356',480594.20,480594.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165154',3264829,'2328','356',32602.77,35052.73,2449.96,399343.48,0.00,0.00,0.00,0.00,0.00),('1','113','823','165154',3264830,'2329','356',438524.40,438524.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165154',3264831,'2330','356',782274.62,784326.99,2052.37,334536.31,0.00,0.00,0.00,0.00,0.00),('1','113','823','165154',3264832,'2331','356',418546.74,418546.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165154',3264833,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165154',3264834,'2333','356',845808.61,845808.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165154',3264835,'2334','356',8973.97,10663.05,1689.08,275320.04,0.00,0.00,0.00,0.00,0.00),('1','113','823','165154',3264836,'2335','356',628170.91,628170.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165154',3264837,'2336','356',261590.05,262622.45,1032.40,168281.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','165154',3264838,'2337','356',437309.75,437309.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','165154',3264839,'2338','357',859671.31,862196.87,2525.56,467228.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','165154',3264840,'2339','357',1979000.52,1980147.43,1146.91,212178.35,0.00,0.00,0.00,0.00,0.00),('1','113','825','165154',3264841,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','165154',3264842,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165155',3264843,'2326','356',1023088.96,1024894.84,1795.88,292728.44,0.00,0.00,10.00,0.00,0.00),('1','113','823','165155',3264844,'2327','356',480594.20,480594.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165155',3264845,'2328','356',35052.73,37105.73,2043.00,333009.00,0.00,0.00,10.00,0.00,0.00),('1','113','823','165155',3264846,'2329','356',438524.40,438524.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165155',3264847,'2330','356',784326.99,785981.13,1644.14,267994.82,0.00,0.00,10.00,0.00,0.00),('1','113','823','165155',3264848,'2331','356',418546.74,418546.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165155',3264849,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165155',3264850,'2333','356',845808.61,847269.16,1450.55,236439.65,0.00,0.00,10.00,0.00,0.00),('1','113','823','165155',3264851,'2334','356',10663.05,10663.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165155',3264852,'2335','356',628170.91,629239.56,1058.65,172559.95,0.00,0.00,10.00,0.00,0.00),('1','113','823','165155',3264853,'2336','356',262622.45,263539.26,906.81,147810.03,0.00,0.00,10.00,0.00,0.00),('1','113','823','165155',3264854,'2337','356',437309.75,437314.35,0.01,1.63,0.00,0.00,4.59,0.00,0.00),('1','113','824','165155',3264855,'2338','357',862196.87,864479.09,2272.22,420360.70,0.00,0.00,10.00,0.00,0.00),('1','113','824','165155',3264856,'2339','357',1980147.43,1981744.65,1587.22,293635.70,0.00,0.00,10.00,0.00,0.00),('1','113','825','165155',3264857,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','165155',3264858,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165220',3266091,'2326','356',1024894.84,1026721.42,1826.58,297732.54,0.00,0.00,0.00,0.00,0.00),('1','113','823','165220',3266092,'2327','356',480594.20,480594.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165220',3266093,'2328','356',37105.73,37105.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165220',3266094,'2329','356',438524.40,440056.19,1531.79,249681.77,0.00,0.00,0.00,0.00,0.00),('1','113','823','165220',3266095,'2330','356',785981.13,785981.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165220',3266096,'2331','356',418546.74,420217.56,1670.82,272343.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','165220',3266097,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165220',3266098,'2333','356',847269.16,848162.08,882.92,143915.96,0.00,0.00,10.00,0.00,0.00),('1','113','823','165220',3266099,'2334','356',10663.05,10663.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165220',3266100,'2335','356',629239.56,629239.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165220',3266101,'2336','356',263539.26,264766.78,1227.52,200085.76,0.00,0.00,0.00,0.00,0.00),('1','113','823','165220',3266102,'2337','356',437314.35,437317.42,3.07,500.41,0.00,0.00,0.00,0.00,0.00),('1','113','824','165220',3266103,'2338','357',864479.09,869177.28,4698.19,869165.15,0.00,0.00,0.00,0.00,0.00),('1','113','824','165220',3266104,'2339','357',1981744.65,1987705.87,5961.22,1102825.70,0.00,0.00,0.00,0.00,0.00),('1','113','825','165220',3266105,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','165220',3266106,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165327',3267818,'2326','356',1026721.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165327',3267819,'2327','356',480594.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165327',3267820,'2328','356',37105.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165327',3267821,'2329','356',440056.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165327',3267822,'2330','356',785981.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165327',3267823,'2331','356',420217.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165327',3267824,'2332','356',15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165327',3267825,'2333','356',848162.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165327',3267826,'2334','356',10663.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165327',3267827,'2335','356',629239.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165327',3267828,'2336','356',264766.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165327',3267829,'2337','356',437317.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','165327',3267830,'2338','357',869177.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','165327',3267831,'2339','357',1987705.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','165327',3267832,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','165327',3267833,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165335',3267915,'2326','356',1026721.42,1026721.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165335',3267916,'2327','356',480594.20,482260.35,1666.15,271582.45,0.00,0.00,0.00,0.00,0.00),('1','113','823','165335',3267917,'2328','356',37105.73,38939.83,1834.10,298958.30,0.00,0.00,0.00,0.00,0.00),('1','113','823','165335',3267918,'2329','356',440056.19,440056.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165335',3267919,'2330','356',785981.13,787721.72,1740.59,283716.17,0.00,0.00,0.00,0.00,0.00),('1','113','823','165335',3267920,'2331','356',420217.56,420217.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165335',3267921,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165335',3267922,'2333','356',848162.08,849481.13,1319.05,215005.15,0.00,0.00,0.00,0.00,0.00),('1','113','823','165335',3267923,'2334','356',10663.05,10663.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165335',3267924,'2335','356',629239.56,630215.84,976.28,159133.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','165335',3267925,'2336','356',264766.78,265623.29,856.51,139611.13,0.00,0.00,0.00,0.00,0.00),('1','113','823','165335',3267926,'2337','356',437317.42,437317.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','165335',3267927,'2338','357',869177.28,872608.17,3430.89,634714.65,0.00,0.00,0.00,0.00,0.00),('1','113','824','165335',3267928,'2339','357',1987705.87,1993241.40,5535.53,1024073.05,0.00,0.00,0.00,0.00,0.00),('1','113','825','165335',3267929,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','165335',3267930,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165468',3270248,'2326','356',1026721.42,1026721.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165468',3270249,'2327','356',482260.35,483778.92,1518.57,247526.91,0.00,0.00,0.00,0.00,0.00),('1','113','823','165468',3270250,'2328','356',38939.83,40525.45,1585.62,258456.06,0.00,0.00,0.00,0.00,0.00),('1','113','823','165468',3270251,'2329','356',440056.19,440056.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165468',3270252,'2330','356',787721.72,787721.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165468',3270253,'2331','356',420217.56,421609.30,1391.74,226853.62,0.00,0.00,0.00,0.00,0.00),('1','113','823','165468',3270254,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165468',3270255,'2333','356',849481.13,850586.43,1095.30,178533.90,0.00,0.00,10.00,0.00,0.00),('1','113','823','165468',3270256,'2334','356',10663.05,11791.48,1128.43,183934.09,0.00,0.00,0.00,0.00,0.00),('1','113','823','165468',3270257,'2335','356',630215.84,630215.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165468',3270258,'2336','356',265623.29,265623.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165468',3270259,'2337','356',437317.42,437317.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','165468',3270260,'2338','357',872608.17,875378.63,2770.46,512535.10,0.00,0.00,0.00,0.00,0.00),('1','113','824','165468',3270261,'2339','357',1993241.40,1996281.72,3040.32,562459.20,0.00,0.00,0.00,0.00,0.00),('1','113','825','165468',3270262,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','165468',3270263,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165469',3270264,'2326','356',1026721.42,1028861.71,2140.29,348867.27,0.00,0.00,0.00,0.00,0.00),('1','113','823','165469',3270265,'2327','356',483778.92,483778.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165469',3270266,'2328','356',40525.45,42185.73,1660.28,270625.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','165469',3270267,'2329','356',440056.19,440056.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165469',3270268,'2330','356',787721.72,787721.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165469',3270269,'2331','356',421609.30,423206.86,1597.56,260402.28,0.00,0.00,0.00,0.00,0.00),('1','113','823','165469',3270270,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165469',3270271,'2333','356',850586.43,852154.63,1568.20,255616.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','165469',3270272,'2334','356',11791.48,11791.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165469',3270273,'2335','356',630215.84,631281.97,1066.13,173779.19,0.00,0.00,0.00,0.00,0.00),('1','113','823','165469',3270274,'2336','356',265623.29,266160.63,537.34,87586.42,0.00,0.00,0.00,0.00,0.00),('1','113','823','165469',3270275,'2337','356',437317.42,437317.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','165469',3270276,'2338','357',875378.63,877763.51,2384.88,441202.80,0.00,0.00,0.00,0.00,0.00),('1','113','824','165469',3270277,'2339','357',1996281.72,1998368.87,2087.15,386122.75,0.00,0.00,0.00,0.00,0.00),('1','113','825','165469',3270278,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','165469',3270279,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165627',3273086,'2326','356',1028861.71,1030601.08,1739.37,283517.31,0.00,0.00,0.00,0.00,0.00),('1','113','823','165627',3273087,'2327','356',483778.92,483778.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165627',3273088,'2328','356',42185.73,43647.89,1462.16,238332.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','165627',3273089,'2329','356',440056.19,440056.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165627',3273090,'2330','356',787721.72,789351.84,1630.12,265709.56,0.00,0.00,0.00,0.00,0.00),('1','113','823','165627',3273091,'2331','356',423206.86,423206.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165627',3273092,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165627',3273093,'2333','356',852154.63,853389.37,1234.74,201262.62,0.00,0.00,0.00,0.00,0.00),('1','113','823','165627',3273094,'2334','356',11791.48,11791.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165627',3273095,'2335','356',631281.97,632482.59,1200.62,195701.06,0.00,0.00,0.00,0.00,0.00),('1','113','823','165627',3273096,'2336','356',266160.63,266160.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165627',3273097,'2337','356',437317.42,438205.27,877.85,143089.55,0.00,0.00,10.00,0.00,0.00),('1','113','824','165627',3273098,'2338','357',877763.51,880754.94,2991.43,553414.55,0.00,0.00,0.00,0.00,0.00),('1','113','824','165627',3273099,'2339','357',1998368.87,2003099.96,4731.09,875251.65,0.00,0.00,0.00,0.00,0.00),('1','113','825','165627',3273100,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','165627',3273101,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165653',3273559,'2326','356',1030601.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165653',3273560,'2327','356',483778.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165653',3273561,'2328','356',43647.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165653',3273562,'2329','356',440056.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165653',3273563,'2330','356',789351.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165653',3273564,'2331','356',423206.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165653',3273565,'2332','356',15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165653',3273566,'2333','356',853389.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165653',3273567,'2334','356',11791.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165653',3273568,'2335','356',632482.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165653',3273569,'2336','356',266160.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165653',3273570,'2337','356',438205.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','165653',3273571,'2338','357',880754.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','165653',3273572,'2339','357',2003099.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','165653',3273573,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','165653',3273574,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165655',3273577,'2326','356',1030601.08,1032583.90,1982.82,323199.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','165655',3273578,'2327','356',483778.92,483778.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165655',3273579,'2328','356',43647.89,45647.58,1999.69,325949.47,0.00,0.00,0.00,0.00,0.00),('1','113','823','165655',3273580,'2329','356',440056.19,440056.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165655',3273581,'2330','356',789351.84,789351.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165655',3273582,'2331','356',423206.86,424780.12,1573.26,256441.38,0.00,0.00,0.00,0.00,0.00),('1','113','823','165655',3273583,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165655',3273584,'2333','356',853389.37,855412.18,2022.81,329718.03,0.00,0.00,0.00,0.00,0.00),('1','113','823','165655',3273585,'2334','356',11791.48,11791.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165655',3273586,'2335','356',632482.59,634408.33,1925.74,313895.62,0.00,0.00,0.00,0.00,0.00),('1','113','823','165655',3273587,'2336','356',266160.63,267526.66,1366.03,222662.89,0.00,0.00,0.00,0.00,0.00),('1','113','823','165655',3273588,'2337','356',438205.27,438205.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','165655',3273589,'2338','357',880754.94,883760.89,3005.95,571130.50,0.00,0.00,0.00,0.00,0.00),('1','113','824','165655',3273590,'2339','357',2003099.96,2006561.33,3461.37,657660.30,0.00,0.00,0.00,0.00,0.00),('1','113','825','165655',3273591,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','165655',3273592,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165973',3279313,'2326','356',1032583.90,1034193.76,1609.86,262407.18,0.00,0.00,0.00,0.00,0.00),('1','113','823','165973',3279314,'2327','356',483778.92,483778.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165973',3279315,'2328','356',45647.58,47287.82,1640.24,267359.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','165973',3279316,'2329','356',440056.19,440056.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165973',3279317,'2330','356',789351.84,789351.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165973',3279318,'2331','356',424780.12,426278.61,1498.49,244253.87,0.00,0.00,0.00,0.00,0.00),('1','113','823','165973',3279319,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165973',3279320,'2333','356',855412.18,855456.35,44.17,7199.71,0.00,0.00,0.00,0.00,0.00),('1','113','823','165973',3279321,'2334','356',11791.48,11791.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165973',3279322,'2335','356',634408.33,635825.55,1417.22,231006.86,0.00,0.00,0.00,0.00,0.00),('1','113','823','165973',3279323,'2336','356',267526.66,268591.66,1065.00,173595.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165973',3279324,'2337','356',438205.27,438205.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','165973',3279325,'2338','357',883760.89,885420.64,1659.75,315352.50,0.00,0.00,0.00,0.00,0.00),('1','113','824','165973',3279326,'2339','357',2006561.33,2008251.63,1690.30,321157.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','165973',3279327,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','165973',3279328,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165977',3279384,'2326','356',1034193.76,1035809.16,1615.40,263310.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','165977',3279385,'2327','356',483778.92,483778.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165977',3279386,'2328','356',47287.82,49305.35,2017.53,328857.39,0.00,0.00,0.00,0.00,0.00),('1','113','823','165977',3279387,'2329','356',440056.19,440056.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165977',3279388,'2330','356',789351.84,789351.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165977',3279389,'2331','356',426278.61,428291.59,2012.98,328115.74,0.00,0.00,0.00,0.00,0.00),('1','113','823','165977',3279390,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165977',3279391,'2333','356',855456.35,856835.69,1369.34,223202.42,0.00,0.00,10.00,0.00,0.00),('1','113','823','165977',3279392,'2334','356',11791.48,11791.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165977',3279393,'2335','356',635825.55,637129.24,1303.69,212501.47,0.00,0.00,0.00,0.00,0.00),('1','113','823','165977',3279394,'2336','356',268591.66,269878.60,1286.94,209771.22,0.00,0.00,0.00,0.00,0.00),('1','113','823','165977',3279395,'2337','356',438205.27,438205.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','165977',3279396,'2338','357',885420.64,888044.55,2623.91,498542.90,0.00,0.00,0.00,0.00,0.00),('1','113','824','165977',3279397,'2339','357',2008251.63,2011937.71,3686.08,700355.20,0.00,0.00,0.00,0.00,0.00),('1','113','825','165977',3279398,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','165977',3279399,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165979',3279402,'2326','356',1035809.16,1037411.99,1602.83,261261.29,0.00,0.00,0.00,0.00,0.00),('1','113','823','165979',3279403,'2327','356',483778.92,483778.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165979',3279404,'2328','356',49305.35,50994.47,1689.12,275326.56,0.00,0.00,0.00,0.00,0.00),('1','113','823','165979',3279405,'2329','356',440056.19,440056.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165979',3279406,'2330','356',789351.84,790846.26,1494.42,243590.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','165979',3279407,'2331','356',428291.59,428291.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165979',3279408,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165979',3279409,'2333','356',856835.69,856835.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165979',3279410,'2334','356',11791.48,11791.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165979',3279411,'2335','356',637129.24,638374.95,1245.71,203050.73,0.00,0.00,0.00,0.00,0.00),('1','113','823','165979',3279412,'2336','356',269878.60,269878.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165979',3279413,'2337','356',438205.27,439053.78,848.51,138307.13,0.00,0.00,0.00,0.00,0.00),('1','113','824','165979',3279414,'2338','357',888044.55,890032.46,1987.91,377702.90,0.00,0.00,0.00,0.00,0.00),('1','113','824','165979',3279415,'2339','357',2011937.71,2014891.37,2953.66,561195.40,0.00,0.00,0.00,0.00,0.00),('1','113','825','165979',3279416,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','165979',3279417,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165983',3279440,'2326','356',1037411.99,1039441.13,2009.14,327489.82,0.00,0.00,20.00,0.00,0.00),('1','113','823','165983',3279441,'2327','356',483778.92,483778.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165983',3279442,'2328','356',50994.47,52488.24,1473.77,240224.51,0.00,0.00,20.00,0.00,0.00),('1','113','823','165983',3279443,'2329','356',440056.19,440056.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165983',3279444,'2330','356',790846.26,790846.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165983',3279445,'2331','356',428291.59,429975.28,1663.69,271181.47,0.00,0.00,20.00,0.00,0.00),('1','113','823','165983',3279446,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165983',3279447,'2333','356',856835.69,858223.85,1388.16,226270.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','165983',3279448,'2334','356',11791.48,13181.94,1360.46,221754.98,0.00,0.00,30.00,0.00,0.00),('1','113','823','165983',3279449,'2335','356',638374.95,638374.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','165983',3279450,'2336','356',269878.60,270484.44,585.84,95491.92,0.00,0.00,20.00,0.00,0.00),('1','113','823','165983',3279451,'2337','356',439053.78,439433.09,379.31,61827.53,0.00,0.00,0.00,0.00,0.00),('1','113','824','165983',3279452,'2338','357',890032.46,891446.06,1413.60,268584.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','165983',3279453,'2339','357',2014891.37,2017153.15,2261.78,429738.20,0.00,0.00,0.00,0.00,0.00),('1','113','825','165983',3279454,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','165983',3279455,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166162',3282705,'2326','356',1039441.13,1040413.49,972.36,158494.68,0.00,0.00,0.00,0.00,0.00),('1','113','823','166162',3282706,'2327','356',483778.92,484529.29,750.37,122310.31,0.00,0.00,0.00,0.00,0.00),('1','113','823','166162',3282707,'2328','356',52488.24,54043.39,1555.15,253489.45,0.00,0.00,0.00,0.00,0.00),('1','113','823','166162',3282708,'2329','356',440056.19,440056.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166162',3282709,'2330','356',790846.26,790846.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166162',3282710,'2331','356',429975.28,431176.55,1201.27,195807.01,0.00,0.00,0.00,0.00,0.00),('1','113','823','166162',3282711,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166162',3282712,'2333','356',858223.85,859425.27,1201.42,195831.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','166162',3282713,'2334','356',13181.94,13734.96,553.02,90142.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','166162',3282714,'2335','356',638374.95,638793.34,418.39,68197.57,0.00,0.00,0.00,0.00,0.00),('1','113','823','166162',3282715,'2336','356',270484.44,271106.46,622.02,101389.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','166162',3282716,'2337','356',439433.09,439980.74,547.65,89266.95,0.00,0.00,0.00,0.00,0.00),('1','113','824','166162',3282717,'2338','357',891446.06,893079.74,1633.68,310399.20,0.00,0.00,0.00,0.00,0.00),('1','113','824','166162',3282718,'2339','357',2017153.15,2018636.78,1483.63,281889.70,0.00,0.00,0.00,0.00,0.00),('1','113','825','166162',3282719,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','166162',3282720,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166165',3282751,'2326','356',1040413.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166165',3282752,'2327','356',484529.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166165',3282753,'2328','356',54043.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166165',3282754,'2329','356',440056.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166165',3282755,'2330','356',790846.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166165',3282756,'2331','356',431176.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166165',3282757,'2332','356',15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166165',3282758,'2333','356',859425.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166165',3282759,'2334','356',13734.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166165',3282760,'2335','356',638793.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166165',3282761,'2336','356',271106.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166165',3282762,'2337','356',439980.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','166165',3282763,'2338','357',893079.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','166165',3282764,'2339','357',2018636.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','166165',3282765,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','166165',3282766,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166167',3282768,'2326','356',1040413.49,1040442.93,29.44,4798.72,0.00,0.00,0.00,0.00,0.00),('1','113','823','166167',3282769,'2327','356',484529.29,486861.29,2332.00,380116.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166167',3282770,'2328','356',54043.39,54043.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166167',3282771,'2329','356',440056.19,442001.09,1944.90,317018.70,0.00,0.00,0.00,0.00,0.00),('1','113','823','166167',3282772,'2330','356',790846.26,790846.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166167',3282773,'2331','356',431176.55,433560.38,2383.83,388564.29,0.00,0.00,0.00,0.00,0.00),('1','113','823','166167',3282774,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166167',3282775,'2333','356',859425.27,861180.76,1755.49,286144.87,0.00,0.00,0.00,0.00,0.00),('1','113','823','166167',3282776,'2334','356',13734.96,13734.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166167',3282777,'2335','356',638793.34,640794.81,2001.47,326239.61,0.00,0.00,0.00,0.00,0.00),('1','113','823','166167',3282778,'2336','356',271106.46,271106.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166167',3282779,'2337','356',439980.74,439980.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','166167',3282780,'2338','357',893079.74,895857.45,2777.71,541653.45,0.00,0.00,0.00,0.00,0.00),('1','113','824','166167',3282781,'2339','357',2018636.78,2022292.37,3655.59,712840.05,0.00,0.00,0.00,0.00,0.00),('1','113','825','166167',3282782,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','166167',3282783,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166244',3284100,'2326','356',1040442.93,1042232.78,1789.85,291745.55,0.00,0.00,0.00,0.00,0.00),('1','113','823','166244',3284101,'2327','356',486861.29,486861.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166244',3284102,'2328','356',54043.39,55743.53,1700.14,277122.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','166244',3284103,'2329','356',442001.09,442001.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166244',3284104,'2330','356',790846.26,792164.56,1318.30,214882.90,0.00,0.00,0.00,0.00,0.00),('1','113','823','166244',3284105,'2331','356',433560.38,433560.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166244',3284106,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166244',3284107,'2333','356',861180.76,862638.07,1457.31,237541.53,0.00,0.00,0.00,0.00,0.00),('1','113','823','166244',3284108,'2334','356',13734.96,13734.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166244',3284109,'2335','356',640794.81,641875.25,1080.44,176111.72,0.00,0.00,0.00,0.00,0.00),('1','113','823','166244',3284110,'2336','356',271106.46,271752.37,635.91,103653.33,0.00,0.00,10.00,0.00,0.00),('1','113','823','166244',3284111,'2337','356',439980.74,440181.33,200.59,32696.17,0.00,0.00,0.00,0.00,0.00),('1','113','824','166244',3284112,'2338','357',895857.45,898212.18,2354.73,459172.35,0.00,0.00,0.00,0.00,0.00),('1','113','824','166244',3284113,'2339','357',2022292.37,2024548.35,2255.98,439916.10,0.00,0.00,0.00,0.00,0.00),('1','113','825','166244',3284114,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','166244',3284115,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166350',3286158,'2326','356',1042232.78,1044861.72,2628.94,428517.22,0.00,0.00,0.00,0.00,0.00),('1','113','823','166350',3286159,'2327','356',486861.29,486861.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166350',3286160,'2328','356',55743.53,56057.50,313.97,51177.11,0.00,0.00,0.00,0.00,0.00),('1','113','823','166350',3286161,'2329','356',442001.09,442515.50,514.41,83848.83,0.00,0.00,0.00,0.00,0.00),('1','113','823','166350',3286162,'2330','356',792164.56,794556.32,2391.76,389856.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','166350',3286163,'2331','356',433560.38,433560.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166350',3286164,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166350',3286165,'2333','356',862638.07,864804.88,2166.81,353190.03,0.00,0.00,0.00,0.00,0.00),('1','113','823','166350',3286166,'2334','356',13734.96,16034.68,2299.72,374854.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','166350',3286167,'2335','356',641875.25,641875.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166350',3286168,'2336','356',271752.37,272594.22,841.85,137221.55,0.00,0.00,0.00,0.00,0.00),('1','113','823','166350',3286169,'2337','356',440181.33,440181.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','166350',3286170,'2338','357',898212.18,901129.27,2917.09,568832.55,0.00,0.00,0.00,0.00,0.00),('1','113','824','166350',3286171,'2339','357',2024548.35,2026160.29,1611.94,314328.30,0.00,0.00,0.00,0.00,0.00),('1','113','825','166350',3286172,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','166350',3286173,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166414',3287403,'2326','356',1044861.72,1044861.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166414',3287404,'2327','356',486861.29,489005.80,2144.51,349555.13,0.00,0.00,0.00,0.00,0.00),('1','113','823','166414',3287405,'2328','356',56057.50,58110.91,2053.41,334705.83,0.00,0.00,0.00,0.00,0.00),('1','113','823','166414',3287406,'2329','356',442515.50,442515.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166414',3287407,'2330','356',794556.32,794556.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166414',3287408,'2331','356',433560.38,435296.69,1736.31,283018.53,0.00,0.00,0.00,0.00,0.00),('1','113','823','166414',3287409,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166414',3287410,'2333','356',864804.88,866082.22,1277.34,208206.42,0.00,0.00,0.00,0.00,0.00),('1','113','823','166414',3287411,'2334','356',16034.68,16034.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166414',3287412,'2335','356',641875.25,643054.54,1179.29,192224.27,0.00,0.00,0.00,0.00,0.00),('1','113','823','166414',3287413,'2336','356',272594.22,273723.74,1129.52,184111.76,0.00,0.00,0.00,0.00,0.00),('1','113','823','166414',3287414,'2337','356',440181.33,440181.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','166414',3287415,'2338','357',901129.27,902113.79,984.52,191981.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','166414',3287416,'2339','357',2026160.29,2028611.77,2451.48,478038.60,0.00,0.00,0.00,0.00,0.00),('1','113','825','166414',3287417,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','166414',3287418,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166531',3289388,'2326','356',1044861.72,1045835.39,973.67,158708.21,0.00,0.00,0.00,0.00,0.00),('1','113','823','166531',3289389,'2327','356',489005.80,489005.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166531',3289390,'2328','356',58110.91,58110.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166531',3289391,'2329','356',442515.50,444994.31,2478.81,404046.03,0.00,0.00,0.00,0.00,0.00),('1','113','823','166531',3289392,'2330','356',794556.32,797271.11,2714.79,442510.77,0.00,0.00,0.00,0.00,0.00),('1','113','823','166531',3289393,'2331','356',435296.69,435296.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166531',3289394,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166531',3289395,'2333','356',866082.22,868286.91,2204.69,359364.47,0.00,0.00,0.00,0.00,0.00),('1','113','823','166531',3289396,'2334','356',16034.68,18413.89,2379.21,387811.23,0.00,0.00,0.00,0.00,0.00),('1','113','823','166531',3289397,'2335','356',643054.54,643054.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166531',3289398,'2336','356',273723.74,273723.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166531',3289399,'2337','356',440181.33,441774.74,1593.41,259725.83,0.00,0.00,0.00,0.00,0.00),('1','113','824','166531',3289400,'2338','357',902113.79,907175.63,5061.84,987058.80,0.00,0.00,0.00,0.00,0.00),('1','113','824','166531',3289401,'2339','357',2028611.77,2034488.17,5876.40,1145898.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','166531',3289402,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','166531',3289403,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166602',3290749,'2326','356',1045835.39,1045835.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166602',3290750,'2327','356',489005.80,490955.08,1949.28,317732.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','166602',3290751,'2328','356',58110.91,59844.33,1733.42,282547.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','166602',3290752,'2329','356',444994.31,444994.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166602',3290753,'2330','356',797271.11,797271.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166602',3290754,'2331','356',435296.69,437084.66,1787.97,291439.11,0.00,0.00,0.00,0.00,0.00),('1','113','823','166602',3290755,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166602',3290756,'2333','356',868286.91,869813.26,1526.35,248795.05,0.00,0.00,0.00,0.00,0.00),('1','113','823','166602',3290757,'2334','356',18413.89,18413.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166602',3290758,'2335','356',643054.54,644320.55,1266.01,206359.63,0.00,0.00,0.00,0.00,0.00),('1','113','823','166602',3290759,'2336','356',273723.74,274922.36,1188.62,193745.06,0.00,0.00,10.00,0.00,0.00),('1','113','823','166602',3290760,'2337','356',441774.74,441774.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','166602',3290761,'2338','357',907175.63,909165.27,1989.64,387979.80,0.00,0.00,0.00,0.00,0.00),('1','113','824','166602',3290762,'2339','357',2034488.17,2036419.34,1931.17,376578.15,0.00,0.00,0.00,0.00,0.00),('1','113','825','166602',3290763,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','166602',3290764,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166735',3292923,'2326','356',1045835.39,1048300.57,2465.18,401824.34,0.00,0.00,0.00,0.00,0.00),('1','113','823','166735',3292924,'2327','356',490955.08,490955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166735',3292925,'2328','356',59844.33,59844.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166735',3292926,'2329','356',444994.31,444994.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166735',3292927,'2330','356',797271.11,797271.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166735',3292928,'2331','356',437084.66,439463.59,2378.93,387765.59,0.00,0.00,0.00,0.00,0.00),('1','113','823','166735',3292929,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166735',3292930,'2333','356',869813.26,872228.76,2415.50,393726.50,0.00,0.00,0.00,0.00,0.00),('1','113','823','166735',3292931,'2334','356',18413.89,20303.55,1889.66,308014.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','166735',3292932,'2335','356',644320.55,644320.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166735',3292933,'2336','356',274922.36,277012.92,2090.56,340761.28,0.00,0.00,0.00,0.00,0.00),('1','113','823','166735',3292934,'2337','356',441774.74,441774.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','166735',3292935,'2338','357',909165.27,910978.86,1813.59,353650.05,0.00,0.00,0.00,0.00,0.00),('1','113','824','166735',3292936,'2339','357',2036419.34,2038947.49,2528.15,492989.25,0.00,0.00,0.00,0.00,0.00),('1','113','825','166735',3292937,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','166735',3292938,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166811',3294356,'2326','356',1048300.57,1050438.90,2138.33,348547.79,0.00,0.00,0.00,0.00,0.00),('1','113','823','166811',3294357,'2327','356',490955.08,490955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166811',3294358,'2328','356',59844.33,61571.32,1726.99,281499.37,0.00,0.00,0.00,0.00,0.00),('1','113','823','166811',3294359,'2329','356',444994.31,444994.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166811',3294360,'2330','356',797271.11,797271.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166811',3294361,'2331','356',439463.59,439463.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166811',3294362,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166811',3294363,'2333','356',872228.76,873912.64,1683.88,274472.44,0.00,0.00,0.00,0.00,0.00),('1','113','823','166811',3294364,'2334','356',20303.55,20303.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166811',3294365,'2335','356',644320.55,645881.63,1561.08,254456.04,0.00,0.00,0.00,0.00,0.00),('1','113','823','166811',3294366,'2336','356',277012.92,278299.84,1286.92,209767.96,0.00,0.00,0.00,0.00,0.00),('1','113','823','166811',3294367,'2337','356',441774.74,441774.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','166811',3294368,'2338','357',910978.86,912278.61,1299.75,253451.25,0.00,0.00,0.00,0.00,0.00),('1','113','824','166811',3294369,'2339','357',2038947.49,2039647.57,700.08,136515.60,0.00,0.00,0.00,0.00,0.00),('1','113','825','166811',3294370,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','166811',3294371,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166999',3297644,'2326','356',1050438.90,1053112.53,2673.63,435801.69,0.00,0.00,0.00,0.00,0.00),('1','113','823','166999',3297645,'2327','356',490955.08,490955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166999',3297646,'2328','356',61571.32,64096.15,2524.83,411547.29,0.00,0.00,0.00,0.00,0.00),('1','113','823','166999',3297647,'2329','356',444994.31,444994.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166999',3297648,'2330','356',797271.11,797271.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166999',3297649,'2331','356',439463.59,439715.39,251.80,41043.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','166999',3297650,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166999',3297651,'2333','356',873912.64,876674.55,2761.91,450191.33,0.00,0.00,0.00,0.00,0.00),('1','113','823','166999',3297652,'2334','356',20303.55,20303.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166999',3297653,'2335','356',645881.63,648087.58,2205.95,359569.85,0.00,0.00,0.00,0.00,0.00),('1','113','823','166999',3297654,'2336','356',278299.84,278299.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','166999',3297655,'2337','356',441774.74,443511.92,1737.18,283160.34,0.00,0.00,0.00,0.00,0.00),('1','113','824','166999',3297656,'2338','357',912278.61,914405.89,2127.28,414819.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','166999',3297657,'2339','357',2039647.57,2042187.20,2539.63,495227.85,0.00,0.00,0.00,0.00,0.00),('1','113','825','166999',3297658,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','166999',3297659,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167001',3297677,'2326','356',1053112.53,1055339.97,2227.44,363072.72,0.00,0.00,0.00,0.00,0.00),('1','113','823','167001',3297678,'2327','356',490955.08,490955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167001',3297679,'2328','356',64096.15,65667.30,1571.15,256097.45,0.00,0.00,0.00,0.00,0.00),('1','113','823','167001',3297680,'2329','356',444994.31,444994.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167001',3297681,'2330','356',797271.11,797271.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167001',3297682,'2331','356',439715.39,441168.19,1452.80,236806.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','167001',3297683,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167001',3297684,'2333','356',876674.55,877899.15,1224.60,199609.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','167001',3297685,'2334','356',20303.55,20303.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167001',3297686,'2335','356',648087.58,649036.27,948.69,154636.47,0.00,0.00,0.00,0.00,0.00),('1','113','823','167001',3297687,'2336','356',278299.84,279218.80,918.96,149790.48,0.00,0.00,0.00,0.00,0.00),('1','113','823','167001',3297688,'2337','356',443511.92,443511.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','167001',3297689,'2338','357',914405.89,918881.51,4475.62,872745.90,0.00,0.00,0.00,0.00,0.00),('1','113','824','167001',3297690,'2339','357',2042187.20,2047391.58,5204.38,1014854.10,0.00,0.00,0.00,0.00,0.00),('1','113','825','167001',3297691,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','167001',3297692,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167150',3300444,'2326','356',1055339.97,1056685.31,1345.34,219290.42,0.00,0.00,0.00,0.00,0.00),('1','113','823','167150',3300445,'2327','356',490955.08,491371.57,416.49,67887.87,0.00,0.00,0.00,0.00,0.00),('1','113','823','167150',3300446,'2328','356',65667.30,67828.52,2161.22,352278.86,0.00,0.00,0.00,0.00,0.00),('1','113','823','167150',3300447,'2329','356',444994.31,444994.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167150',3300448,'2330','356',797271.11,797271.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167150',3300449,'2331','356',441168.19,443271.52,2103.33,342842.79,0.00,0.00,0.00,0.00,0.00),('1','113','823','167150',3300450,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167150',3300451,'2333','356',877899.15,878168.90,269.75,43969.25,0.00,0.00,0.00,0.00,0.00),('1','113','823','167150',3300452,'2334','356',20303.55,20303.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167150',3300453,'2335','356',649036.27,650753.43,1717.16,279897.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','167150',3300454,'2336','356',279218.80,280713.16,1494.36,243580.68,0.00,0.00,0.00,0.00,0.00),('1','113','823','167150',3300455,'2337','356',443511.92,443511.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','167150',3300456,'2338','357',918881.51,924061.28,5179.77,1010055.15,0.00,0.00,0.00,0.00,0.00),('1','113','824','167150',3300457,'2339','357',2047391.58,2052489.51,5097.93,994096.35,0.00,0.00,0.00,0.00,0.00),('1','113','825','167150',3300458,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','167150',3300459,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167154',3300518,'2326','356',1056685.31,1056685.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167154',3300519,'2327','356',491371.57,493043.22,1671.65,272478.95,0.00,0.00,0.00,0.00,0.00),('1','113','823','167154',3300520,'2328','356',67828.52,69087.43,1258.91,205202.33,0.00,0.00,0.00,0.00,0.00),('1','113','823','167154',3300521,'2329','356',444994.31,444994.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167154',3300522,'2330','356',797271.11,797271.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167154',3300523,'2331','356',443271.52,445152.25,1880.73,306558.99,0.00,0.00,0.00,0.00,0.00),('1','113','823','167154',3300524,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167154',3300525,'2333','356',878168.90,879278.90,1110.00,180930.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167154',3300526,'2334','356',20303.55,20837.58,534.03,87046.89,0.00,0.00,0.00,0.00,0.00),('1','113','823','167154',3300527,'2335','356',650753.43,651362.89,609.46,99341.98,0.00,0.00,0.00,0.00,0.00),('1','113','823','167154',3300528,'2336','356',280713.16,281465.18,752.02,122579.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','167154',3300529,'2337','356',443511.92,443511.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','167154',3300530,'2338','357',924061.28,925717.68,1656.40,322997.61,0.00,0.00,0.00,0.00,0.00),('1','113','824','167154',3300531,'2339','357',2052489.51,2054921.03,2431.52,474146.40,0.00,0.00,0.00,0.00,0.00),('1','113','825','167154',3300532,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','167154',3300533,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167214',3301323,'2326','356',1056685.31,1058948.39,2263.08,368882.04,0.00,0.00,0.00,0.00,0.00),('1','113','823','167214',3301324,'2327','356',493043.22,493043.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167214',3301325,'2328','356',69087.43,71284.57,2197.14,358133.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','167214',3301326,'2329','356',444994.31,444994.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167214',3301327,'2330','356',797271.11,799716.63,2445.52,398619.76,0.00,0.00,0.00,0.00,0.00),('1','113','823','167214',3301328,'2331','356',445152.25,445152.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167214',3301329,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167214',3301330,'2333','356',879278.90,879377.95,99.05,16145.15,0.00,0.00,0.00,0.00,0.00),('1','113','823','167214',3301331,'2334','356',20837.58,20837.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167214',3301332,'2335','356',651362.89,651599.06,236.17,38495.71,0.00,0.00,0.00,0.00,0.00),('1','113','823','167214',3301333,'2336','356',281465.18,281465.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167214',3301334,'2337','356',443511.92,445268.73,1756.81,286360.03,0.00,0.00,0.00,0.00,0.00),('1','113','824','167214',3301335,'2338','357',925717.68,926870.41,1152.73,224782.35,0.00,0.00,0.00,0.00,0.00),('1','113','824','167214',3301336,'2339','357',2054921.03,2056424.19,1503.16,293116.20,0.00,0.00,0.00,0.00,0.00),('1','113','825','167214',3301337,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','167214',3301338,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167425',3305023,'2326','356',1058948.39,1060818.34,1869.95,304801.85,0.00,0.00,0.00,0.00,0.00),('1','113','823','167425',3305024,'2327','356',493043.22,493043.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167425',3305025,'2328','356',71284.57,71284.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167425',3305026,'2329','356',444994.31,446655.08,1660.77,270705.51,0.00,0.00,0.00,0.00,0.00),('1','113','823','167425',3305027,'2330','356',799716.63,799716.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167425',3305028,'2331','356',445152.25,446513.24,1360.99,221841.37,0.00,0.00,0.00,0.00,0.00),('1','113','823','167425',3305029,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167425',3305030,'2333','356',879377.95,880565.81,1187.86,193621.18,0.00,0.00,0.00,0.00,0.00),('1','113','823','167425',3305031,'2334','356',20837.58,20837.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167425',3305032,'2335','356',651599.06,652448.20,839.14,136779.82,0.00,0.00,10.00,0.00,0.00),('1','113','823','167425',3305033,'2336','356',281465.18,282231.09,765.91,124843.33,0.00,0.00,0.00,0.00,0.00),('1','113','823','167425',3305034,'2337','356',445268.73,445268.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','167425',3305035,'2338','357',926870.41,927825.68,955.27,186277.65,0.00,0.00,0.00,0.00,0.00),('1','113','824','167425',3305036,'2339','357',2056424.19,2057713.16,1288.97,251349.15,0.00,0.00,0.00,0.00,0.00),('1','113','825','167425',3305037,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','167425',3305038,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167429',3305072,'2326','356',1060818.34,1063198.56,2380.22,387975.86,0.00,0.00,0.00,0.00,0.00),('1','113','823','167429',3305073,'2327','356',493043.22,493043.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167429',3305074,'2328','356',71284.57,73292.72,2008.15,327328.45,0.00,0.00,0.00,0.00,0.00),('1','113','823','167429',3305075,'2329','356',446655.08,446655.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167429',3305076,'2330','356',799716.63,799716.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167429',3305077,'2331','356',446513.24,448495.90,1982.66,323173.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','167429',3305078,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167429',3305079,'2333','356',880565.81,882338.02,1772.21,288870.23,0.00,0.00,0.00,0.00,0.00),('1','113','823','167429',3305080,'2334','356',20837.58,20837.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167429',3305081,'2335','356',652448.20,654089.30,1641.10,267499.30,0.00,0.00,0.00,0.00,0.00),('1','113','823','167429',3305082,'2336','356',282231.09,282307.16,76.07,12399.41,0.00,0.00,0.00,0.00,0.00),('1','113','823','167429',3305083,'2337','356',445268.73,445268.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','167429',3305084,'2338','357',927825.68,930361.56,2535.88,494496.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','167429',3305085,'2339','357',2057713.16,2062297.76,4584.60,893997.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','167429',3305086,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','167429',3305087,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167433',3305138,'2326','356',1063198.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167433',3305139,'2327','356',493043.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167433',3305140,'2328','356',73292.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167433',3305141,'2329','356',446655.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167433',3305142,'2330','356',799716.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167433',3305143,'2331','356',448495.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167433',3305144,'2332','356',15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167433',3305145,'2333','356',882338.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167433',3305146,'2334','356',20837.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167433',3305147,'2335','356',654089.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167433',3305148,'2336','356',282307.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167433',3305149,'2337','356',445268.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','167433',3305150,'2338','357',930361.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','167433',3305151,'2339','357',2062297.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','167433',3305152,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','167433',3305153,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167603',3308350,'2326','356',1063198.56,1064801.95,1603.39,261352.57,0.00,0.00,0.00,0.00,0.00),('1','113','823','167603',3308351,'2327','356',493043.22,493043.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167603',3308352,'2328','356',73292.72,74862.41,1569.69,255859.47,0.00,0.00,0.00,0.00,0.00),('1','113','823','167603',3308353,'2329','356',446655.08,446655.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167603',3308354,'2330','356',799716.63,800808.29,1091.66,177940.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','167603',3308355,'2331','356',448495.90,448495.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167603',3308356,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167603',3308357,'2333','356',882338.02,883850.16,1512.14,246478.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','167603',3308358,'2334','356',20837.58,21910.90,1073.32,174951.16,0.00,0.00,0.00,0.00,0.00),('1','113','823','167603',3308359,'2335','356',654089.30,654089.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167603',3308360,'2336','356',282307.16,283225.33,918.17,149661.71,0.00,0.00,0.00,0.00,0.00),('1','113','823','167603',3308361,'2337','356',445268.73,445268.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','167603',3308362,'2338','357',930361.56,932219.42,1857.86,371572.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','167603',3308363,'2339','357',2062297.76,2064848.33,2550.57,510114.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','167603',3308364,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','167603',3308365,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167605',3308382,'2326','356',1064801.95,1066948.91,2146.96,349954.48,0.00,0.00,0.00,0.00,0.00),('1','113','823','167605',3308383,'2327','356',493043.22,493172.66,129.44,21098.72,0.00,0.00,0.00,0.00,0.00),('1','113','823','167605',3308384,'2328','356',74862.41,76035.98,1173.57,191291.91,0.00,0.00,0.00,0.00,0.00),('1','113','823','167605',3308385,'2329','356',446655.08,448215.84,1560.76,254403.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','167605',3308386,'2330','356',800808.29,800808.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167605',3308387,'2331','356',448495.90,450541.28,2045.38,333396.94,0.00,0.00,0.00,0.00,0.00),('1','113','823','167605',3308388,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167605',3308389,'2333','356',883850.16,885384.94,1514.40,246847.20,0.00,0.00,20.38,0.00,0.00),('1','113','823','167605',3308390,'2334','356',21910.90,21910.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167605',3308391,'2335','356',654089.30,654089.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167605',3308392,'2336','356',283225.33,283225.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167605',3308393,'2337','356',445268.73,446704.68,1425.95,232429.85,0.00,0.00,10.00,0.00,0.00),('1','113','824','167605',3308394,'2338','357',932219.42,934132.96,1903.54,380708.00,0.00,0.00,10.00,0.00,0.00),('1','113','824','167605',3308395,'2339','357',2064848.33,2067754.08,2905.75,581150.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','167605',3308396,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','167605',3308397,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167856',3312832,'2326','356',1066948.91,1068721.18,1772.27,288880.01,0.00,0.00,0.00,0.00,0.00),('1','113','823','167856',3312833,'2327','356',493172.66,493172.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167856',3312834,'2328','356',76035.98,76035.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167856',3312835,'2329','356',448215.84,449537.35,1321.51,215406.13,0.00,0.00,0.00,0.00,0.00),('1','113','823','167856',3312836,'2330','356',800808.29,801706.64,898.35,146431.05,0.00,0.00,0.00,0.00,0.00),('1','113','823','167856',3312837,'2331','356',450541.28,451386.25,844.97,137730.11,0.00,0.00,0.00,0.00,0.00),('1','113','823','167856',3312838,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167856',3312839,'2333','356',885384.94,886427.46,1042.52,169930.76,0.00,0.00,0.00,0.00,0.00),('1','113','823','167856',3312840,'2334','356',21910.90,21910.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167856',3312841,'2335','356',654089.30,655264.90,1175.60,191622.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','167856',3312842,'2336','356',283225.33,283225.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167856',3312843,'2337','356',446704.68,447372.44,667.76,108844.88,0.00,0.00,0.00,0.00,0.00),('1','113','824','167856',3312844,'2338','357',934132.96,935215.21,1082.25,216450.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','167856',3312845,'2339','357',2067754.08,2068637.58,883.50,176700.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','167856',3312846,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','167856',3312847,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167859',3312896,'2326','356',1068721.18,1071030.96,2309.78,376494.14,0.00,0.00,0.00,0.00,0.00),('1','113','823','167859',3312897,'2327','356',493172.66,493172.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167859',3312898,'2328','356',76035.98,77824.83,1788.85,291582.55,0.00,0.00,0.00,0.00,0.00),('1','113','823','167859',3312899,'2329','356',449537.35,450577.16,1039.81,169489.03,0.00,0.00,0.00,0.00,0.00),('1','113','823','167859',3312900,'2330','356',801706.64,801706.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167859',3312901,'2331','356',451386.25,453246.73,1860.48,303258.24,0.00,0.00,0.00,0.00,0.00),('1','113','823','167859',3312902,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167859',3312903,'2333','356',886427.46,887949.54,1522.08,248099.04,0.00,0.00,0.00,0.00,0.00),('1','113','823','167859',3312904,'2334','356',21910.90,21910.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167859',3312905,'2335','356',655264.90,655264.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167859',3312906,'2336','356',283225.33,284743.44,1518.11,247451.93,0.00,0.00,0.00,0.00,0.00),('1','113','823','167859',3312907,'2337','356',447372.44,447372.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','167859',3312908,'2338','357',935215.21,937100.15,1884.94,376988.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','167859',3312909,'2339','357',2068637.58,2070046.73,1409.15,281830.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','167859',3312910,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','167859',3312911,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167864',3312998,'2326','356',1071030.96,1071030.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167864',3312999,'2327','356',493172.66,494881.72,1709.06,278576.78,0.00,0.00,0.00,0.00,0.00),('1','113','823','167864',3313000,'2328','356',77824.83,79656.72,1831.89,298598.07,0.00,0.00,0.00,0.00,0.00),('1','113','823','167864',3313001,'2329','356',450577.16,450577.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167864',3313002,'2330','356',801706.64,802438.26,721.62,117624.06,0.00,0.00,10.00,0.00,0.00),('1','113','823','167864',3313003,'2331','356',453246.73,454252.75,1006.02,163981.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','167864',3313004,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167864',3313005,'2333','356',887949.54,889084.64,1135.10,185021.30,0.00,0.00,0.00,0.00,0.00),('1','113','823','167864',3313006,'2334','356',21910.90,22892.77,981.87,160044.81,0.00,0.00,0.00,0.00,0.00),('1','113','823','167864',3313007,'2335','356',655264.90,655264.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167864',3313008,'2336','356',284743.44,285535.89,792.45,129169.35,0.00,0.00,0.00,0.00,0.00),('1','113','823','167864',3313009,'2337','356',447372.44,447372.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','167864',3313010,'2338','357',937100.15,938410.77,1310.62,262124.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','167864',3313011,'2339','357',2070046.73,2071920.23,1873.50,374700.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','167864',3313012,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','167864',3313013,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167959',3314613,'2326','356',1071030.96,1072309.50,1278.54,208402.02,0.00,0.00,0.00,0.00,0.00),('1','113','823','167959',3314614,'2327','356',494881.72,494881.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167959',3314615,'2328','356',79656.72,81757.13,2100.41,342366.83,0.00,0.00,0.00,0.00,0.00),('1','113','823','167959',3314616,'2329','356',450577.16,450577.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167959',3314617,'2330','356',802438.26,802438.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167959',3314618,'2331','356',454252.75,456355.59,2102.84,342762.92,0.00,0.00,0.00,0.00,0.00),('1','113','823','167959',3314619,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167959',3314620,'2333','356',889084.64,890877.35,1792.71,292211.73,0.00,0.00,0.00,0.00,0.00),('1','113','823','167959',3314621,'2334','356',22892.77,22892.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','167959',3314622,'2335','356',655264.90,657056.33,1791.43,292003.09,0.00,0.00,0.00,0.00,0.00),('1','113','823','167959',3314623,'2336','356',285535.89,286638.60,1102.71,179741.73,0.00,0.00,0.00,0.00,0.00),('1','113','823','167959',3314624,'2337','356',447372.44,447372.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','167959',3314625,'2338','357',938410.77,941202.27,2791.50,558300.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','167959',3314626,'2339','357',2071920.23,2073725.47,1805.24,361048.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','167959',3314627,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','167959',3314628,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168045',3316353,'2326','356',1072309.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168045',3316354,'2327','356',494881.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168045',3316355,'2328','356',81757.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168045',3316356,'2329','356',450577.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168045',3316357,'2330','356',802438.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168045',3316358,'2331','356',456355.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168045',3316359,'2332','356',15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168045',3316360,'2333','356',890877.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168045',3316361,'2334','356',22892.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168045',3316362,'2335','356',657056.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168045',3316363,'2336','356',286638.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168045',3316364,'2337','356',447372.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168045',3316365,'2338','357',941202.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168045',3316366,'2339','357',2073725.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168045',3316367,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168045',3316368,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168229',3319848,'2326','356',1072309.50,1074221.18,1911.68,311603.84,0.00,0.00,0.00,0.00,0.00),('1','113','823','168229',3319849,'2327','356',494881.72,494881.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168229',3319850,'2328','356',81757.13,82567.72,810.59,132126.17,0.00,0.00,0.00,0.00,0.00),('1','113','823','168229',3319851,'2329','356',450577.16,451744.30,1167.14,190243.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','168229',3319852,'2330','356',802438.26,804034.08,1595.82,260118.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','168229',3319853,'2331','356',456355.59,456355.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168229',3319854,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168229',3319855,'2333','356',890877.35,892137.47,1260.12,205399.56,0.00,0.00,0.00,0.00,0.00),('1','113','823','168229',3319856,'2334','356',22892.77,22892.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168229',3319857,'2335','356',657056.33,658262.40,1206.07,196589.41,0.00,0.00,0.00,0.00,0.00),('1','113','823','168229',3319858,'2336','356',286638.60,286638.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168229',3319859,'2337','356',447372.44,448199.02,826.58,134732.54,0.00,0.00,0.00,0.00,0.00),('1','113','824','168229',3319860,'2338','357',941202.27,941853.10,650.83,130166.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168229',3319861,'2339','357',2073725.47,2075907.30,2181.83,436366.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168229',3319862,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168229',3319863,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168239',3320066,'2326','356',1074221.18,1076636.06,2404.88,391995.44,0.00,0.00,10.00,0.00,0.00),('1','113','823','168239',3320067,'2327','356',494881.72,494881.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168239',3320068,'2328','356',82567.72,84392.15,1814.43,295752.09,0.00,0.00,10.00,0.00,0.00),('1','113','823','168239',3320069,'2329','356',451744.30,451744.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168239',3320070,'2330','356',804034.08,804034.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168239',3320071,'2331','356',456355.59,458726.83,2361.24,384882.12,0.00,0.00,10.00,0.00,0.00),('1','113','823','168239',3320072,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168239',3320073,'2333','356',892137.47,894300.86,2153.39,351002.57,0.00,0.00,10.00,0.00,0.00),('1','113','823','168239',3320074,'2334','356',22892.77,22892.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168239',3320075,'2335','356',658262.40,660363.38,2090.98,340829.74,0.00,0.00,10.00,0.00,0.00),('1','113','823','168239',3320076,'2336','356',286638.60,287475.22,836.62,136369.06,0.00,0.00,0.00,0.00,0.00),('1','113','823','168239',3320077,'2337','356',448199.02,448199.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168239',3320078,'2338','357',941853.10,944074.28,2221.18,444236.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168239',3320079,'2339','357',2075907.30,2079250.21,3342.91,668582.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168239',3320080,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168239',3320081,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168298',3321044,'2326','356',1076636.06,1078539.74,1903.68,310299.84,0.00,0.00,0.00,0.00,0.00),('1','113','823','168298',3321045,'2327','356',494881.72,494881.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168298',3321046,'2328','356',84392.15,85802.61,1410.46,229904.98,0.00,0.00,0.00,0.00,0.00),('1','113','823','168298',3321047,'2329','356',451744.30,451744.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168298',3321048,'2330','356',804034.08,805379.43,1345.35,219292.05,0.00,0.00,0.00,0.00,0.00),('1','113','823','168298',3321049,'2331','356',458726.83,458726.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168298',3321050,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168298',3321051,'2333','356',894300.86,895771.57,1470.71,239725.73,0.00,0.00,0.00,0.00,0.00),('1','113','823','168298',3321052,'2334','356',22892.77,22892.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168298',3321053,'2335','356',660363.38,661348.59,985.21,160589.23,0.00,0.00,0.00,0.00,0.00),('1','113','823','168298',3321054,'2336','356',287475.22,288283.89,808.67,131813.21,0.00,0.00,0.00,0.00,0.00),('1','113','823','168298',3321055,'2337','356',448199.02,448199.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168298',3321056,'2338','357',944074.28,946110.25,2035.97,407194.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168298',3321057,'2339','357',2079250.21,2082390.71,3140.50,628100.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168298',3321058,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168298',3321059,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168300',3321069,'2326','356',1078539.74,1080541.25,2001.51,326246.13,0.00,0.00,0.00,0.00,0.00),('1','113','823','168300',3321070,'2327','356',494881.72,494881.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168300',3321071,'2328','356',85802.61,88174.53,2371.92,386622.96,0.00,0.00,0.00,0.00,0.00),('1','113','823','168300',3321072,'2329','356',451744.30,451744.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168300',3321073,'2330','356',805379.43,805379.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168300',3321074,'2331','356',458726.83,460647.49,1920.66,313067.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','168300',3321075,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168300',3321076,'2333','356',895771.57,895771.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168300',3321077,'2334','356',22892.77,22892.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168300',3321078,'2335','356',661348.59,663244.28,1895.69,308997.47,0.00,0.00,0.00,0.00,0.00),('1','113','823','168300',3321079,'2336','356',288283.89,289919.99,1636.10,266684.30,0.00,0.00,0.00,0.00,0.00),('1','113','823','168300',3321080,'2337','356',448199.02,448199.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168300',3321081,'2338','357',946110.25,947708.77,1598.52,319704.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168300',3321082,'2339','357',2082390.71,2084807.76,2417.05,483410.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168300',3321083,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168300',3321084,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168427',3323399,'2326','356',1080541.25,1081642.07,1100.82,179433.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','168427',3323400,'2327','356',494881.72,494881.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168427',3323401,'2328','356',88174.53,89619.45,1444.92,235521.96,0.00,0.00,0.00,0.00,0.00),('1','113','823','168427',3323402,'2329','356',451744.30,452549.03,804.73,131170.99,0.00,0.00,0.00,0.00,0.00),('1','113','823','168427',3323403,'2330','356',805379.43,806771.48,1392.05,226904.15,0.00,0.00,0.00,0.00,0.00),('1','113','823','168427',3323404,'2331','356',460647.49,460647.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168427',3323405,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168427',3323406,'2333','356',895771.57,897100.18,1328.61,216563.43,0.00,0.00,0.00,0.00,0.00),('1','113','823','168427',3323407,'2334','356',22892.77,22892.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168427',3323408,'2335','356',663244.28,664503.45,1259.17,205244.71,0.00,0.00,0.00,0.00,0.00),('1','113','823','168427',3323409,'2336','356',289919.99,289919.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168427',3323410,'2337','356',448199.02,448759.33,560.31,91330.53,0.00,0.00,0.00,0.00,0.00),('1','113','824','168427',3323411,'2338','357',947708.77,948765.77,1047.00,209400.00,0.00,0.00,10.00,0.00,0.00),('1','113','824','168427',3323412,'2339','357',2084807.76,2086733.01,1915.25,383050.00,0.00,0.00,10.00,0.00,0.00),('1','113','825','168427',3323413,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168427',3323414,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168428',3323415,'2326','356',1081642.07,1083738.69,2096.62,341749.06,0.00,0.00,0.00,0.00,0.00),('1','113','823','168428',3323416,'2327','356',494881.72,494881.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168428',3323417,'2328','356',89619.45,91392.66,1773.21,289033.23,0.00,0.00,0.00,0.00,0.00),('1','113','823','168428',3323418,'2329','356',452549.03,452549.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168428',3323419,'2330','356',806771.48,806771.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168428',3323420,'2331','356',460647.49,462525.85,1878.36,306172.68,0.00,0.00,0.00,0.00,0.00),('1','113','823','168428',3323421,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168428',3323422,'2333','356',897100.18,898637.58,1537.40,250596.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','168428',3323423,'2334','356',22892.77,22892.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168428',3323424,'2335','356',664503.45,664503.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168428',3323425,'2336','356',289919.99,291224.02,1304.03,212556.89,0.00,0.00,0.00,0.00,0.00),('1','113','823','168428',3323426,'2337','356',448759.33,448759.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168428',3323427,'2338','357',948765.77,950933.99,2168.22,433644.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168428',3323428,'2339','357',2086733.01,2089577.14,2844.13,568826.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168428',3323429,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168428',3323430,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168432',3323483,'2326','356',1083738.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168432',3323484,'2327','356',494881.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168432',3323485,'2328','356',91392.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168432',3323486,'2329','356',452549.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168432',3323487,'2330','356',806771.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168432',3323488,'2331','356',462525.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168432',3323489,'2332','356',15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168432',3323490,'2333','356',898637.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168432',3323491,'2334','356',22892.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168432',3323492,'2335','356',664503.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168432',3323493,'2336','356',291224.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168432',3323494,'2337','356',448759.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168432',3323495,'2338','357',950933.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168432',3323496,'2339','357',2089577.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168432',3323497,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168432',3323498,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168628',3326978,'2326','356',1083738.69,1085372.69,1634.00,263074.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168628',3326979,'2327','356',494881.72,494881.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168628',3326980,'2328','356',91392.66,93102.35,1709.69,275260.09,0.00,0.00,0.00,0.00,0.00),('1','113','823','168628',3326981,'2329','356',452549.03,452642.35,93.32,15024.52,0.00,0.00,0.00,0.00,0.00),('1','113','823','168628',3326982,'2330','356',806771.48,806771.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168628',3326983,'2331','356',462525.85,464308.13,1782.28,286947.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','168628',3326984,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168628',3326985,'2333','356',898637.58,900467.71,1830.13,294650.93,0.00,0.00,0.00,0.00,0.00),('1','113','823','168628',3326986,'2334','356',22892.77,22892.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168628',3326987,'2335','356',664503.45,664503.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168628',3326988,'2336','356',291224.02,291656.07,432.05,69560.05,0.00,0.00,0.00,0.00,0.00),('1','113','823','168628',3326989,'2337','356',448759.33,448759.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168628',3326990,'2338','357',950933.99,952012.74,1078.75,215750.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168628',3326991,'2339','357',2089577.14,2091790.15,2213.01,442602.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168628',3326992,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168628',3326993,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168629',3326994,'2326','356',1085372.69,1087673.00,2300.31,370349.91,0.00,0.00,0.00,0.00,0.00),('1','113','823','168629',3326995,'2327','356',494881.72,494881.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168629',3326996,'2328','356',93102.35,94172.21,1069.86,172247.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','168629',3326997,'2329','356',452642.35,454084.52,1442.17,232189.37,0.00,0.00,0.00,0.00,0.00),('1','113','823','168629',3326998,'2330','356',806771.48,806771.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168629',3326999,'2331','356',464308.13,466223.74,1915.61,308413.21,0.00,0.00,0.00,0.00,0.00),('1','113','823','168629',3327000,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168629',3327001,'2333','356',900467.71,901542.28,1074.57,173005.77,0.00,0.00,0.00,0.00,0.00),('1','113','823','168629',3327002,'2334','356',22892.77,22892.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168629',3327003,'2335','356',664503.45,666004.89,1501.44,241731.84,0.00,0.00,0.00,0.00,0.00),('1','113','823','168629',3327004,'2336','356',291656.07,292887.73,1231.66,198297.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','168629',3327005,'2337','356',448759.33,448759.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168629',3327006,'2338','357',952012.74,955703.28,3670.54,734108.00,0.00,0.00,20.00,0.00,0.00),('1','113','824','168629',3327007,'2339','357',2091790.15,2094425.20,2635.05,527010.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168629',3327008,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168629',3327009,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168804',3330150,'2326','356',1087673.00,1089293.04,1610.04,259216.44,0.00,0.00,10.00,0.00,0.00),('1','113','823','168804',3330151,'2327','356',494881.72,494881.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168804',3330152,'2328','356',94172.21,94685.66,513.45,82665.45,0.00,0.00,0.00,0.00,0.00),('1','113','823','168804',3330153,'2329','356',454084.52,454084.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168804',3330154,'2330','356',806771.48,808708.94,1937.46,311931.06,0.00,0.00,0.00,0.00,0.00),('1','113','823','168804',3330155,'2331','356',466223.74,466223.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168804',3330156,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168804',3330157,'2333','356',901542.28,903558.51,2016.23,324613.03,0.00,0.00,0.00,0.00,0.00),('1','113','823','168804',3330158,'2334','356',22892.77,22892.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168804',3330159,'2335','356',666004.89,668010.92,1996.03,321360.83,0.00,0.00,10.00,0.00,0.00),('1','113','823','168804',3330160,'2336','356',292887.73,292898.30,10.57,1701.77,0.00,0.00,0.00,0.00,0.00),('1','113','823','168804',3330161,'2337','356',448759.33,448759.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168804',3330162,'2338','357',955703.28,957118.41,1415.13,283026.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168804',3330163,'2339','357',2094425.20,2097422.70,2997.50,599500.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168804',3330164,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168804',3330165,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168806',3330189,'2326','356',1089293.04,1089293.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168806',3330190,'2327','356',494881.72,497262.96,2361.24,380159.64,0.00,0.00,20.00,0.00,0.00),('1','113','823','168806',3330191,'2328','356',94685.66,96541.45,1855.79,298782.19,0.00,0.00,0.00,0.00,0.00),('1','113','823','168806',3330192,'2329','356',454084.52,454084.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168806',3330193,'2330','356',808708.94,810182.96,1464.02,235707.22,0.00,0.00,10.00,0.00,0.00),('1','113','823','168806',3330194,'2331','356',466223.74,466223.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168806',3330195,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168806',3330196,'2333','356',903558.51,905869.66,2301.15,370485.15,0.00,0.00,10.00,0.00,0.00),('1','113','823','168806',3330197,'2334','356',22892.77,24409.19,1506.42,242533.62,0.00,0.00,10.00,0.00,0.00),('1','113','823','168806',3330198,'2335','356',668010.92,668010.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168806',3330199,'2336','356',292898.30,294619.21,1700.91,273846.51,0.00,0.00,20.00,0.00,0.00),('1','113','823','168806',3330200,'2337','356',448759.33,448759.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168806',3330201,'2338','357',957118.41,961951.57,4833.16,966632.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168806',3330202,'2339','357',2097422.70,2102024.81,4602.11,920422.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168806',3330203,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168806',3330204,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168955',3332778,'2326','356',1089293.04,1091436.41,2143.37,345082.57,0.00,0.00,0.00,0.00,0.00),('1','113','823','168955',3332779,'2327','356',497262.96,497262.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168955',3332780,'2328','356',96541.45,97079.31,537.86,86595.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','168955',3332781,'2329','356',454084.52,454084.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168955',3332782,'2330','356',810182.96,810182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168955',3332783,'2331','356',466223.74,467920.93,1687.19,271637.59,0.00,0.00,10.00,0.00,0.00),('1','113','823','168955',3332784,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168955',3332785,'2333','356',905869.66,907025.86,1156.20,186148.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','168955',3332786,'2334','356',24409.19,24409.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168955',3332787,'2335','356',668010.92,669253.35,1242.43,200031.23,0.00,0.00,0.00,0.00,0.00),('1','113','823','168955',3332788,'2336','356',294619.21,295747.39,1128.18,181636.98,0.00,0.00,0.00,0.00,0.00),('1','113','823','168955',3332789,'2337','356',448759.33,448759.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168955',3332790,'2338','357',961951.57,966774.58,4823.01,964602.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168955',3332791,'2339','357',2102024.81,2109510.83,7486.02,1497204.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168955',3332792,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168955',3332793,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168957',3332819,'2326','356',1091436.41,1091984.88,548.47,88303.67,0.00,0.00,0.00,0.00,0.00),('1','113','823','168957',3332820,'2327','356',497262.96,499352.23,2089.27,336372.47,0.00,0.00,0.00,0.00,0.00),('1','113','823','168957',3332821,'2328','356',97079.31,97079.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168957',3332822,'2329','356',454084.52,455847.46,1762.94,283833.34,0.00,0.00,0.00,0.00,0.00),('1','113','823','168957',3332823,'2330','356',810182.96,812144.75,1957.79,315204.19,0.00,0.00,4.00,0.00,0.00),('1','113','823','168957',3332824,'2331','356',467920.93,467920.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168957',3332825,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168957',3332826,'2333','356',907025.86,908643.22,1617.36,260394.96,0.00,0.00,0.00,0.00,0.00),('1','113','823','168957',3332827,'2334','356',24409.19,26023.41,1614.22,259889.42,0.00,0.00,0.00,0.00,0.00),('1','113','823','168957',3332828,'2335','356',669253.35,669253.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','168957',3332829,'2336','356',295747.39,296798.66,1051.27,169254.47,0.00,0.00,0.00,0.00,0.00),('1','113','823','168957',3332830,'2337','356',448759.33,448759.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168957',3332831,'2338','357',966774.58,971552.59,4778.01,955602.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','168957',3332832,'2339','357',2109510.83,2114651.26,5140.43,1028086.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168957',3332833,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','168957',3332834,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169135',3335942,'2326','356',1091984.88,1091984.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169135',3335943,'2327','356',499352.23,501452.35,2100.12,338119.32,0.00,0.00,0.00,0.00,0.00),('1','113','823','169135',3335944,'2328','356',97079.31,98854.68,1775.37,285834.57,0.00,0.00,0.00,0.00,0.00),('1','113','823','169135',3335945,'2329','356',455847.46,455847.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169135',3335946,'2330','356',812144.75,812144.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169135',3335947,'2331','356',467920.93,469520.56,1599.63,257540.43,0.00,0.00,0.00,0.00,0.00),('1','113','823','169135',3335948,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169135',3335949,'2333','356',908643.22,908643.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169135',3335950,'2334','356',26023.41,26023.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169135',3335951,'2335','356',669253.35,670714.33,1460.98,235217.78,0.00,0.00,0.00,0.00,0.00),('1','113','823','169135',3335952,'2336','356',296798.66,297811.24,1012.58,163025.38,0.00,0.00,0.00,0.00,0.00),('1','113','823','169135',3335953,'2337','356',448759.33,448759.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','169135',3335954,'2338','357',971552.59,973619.22,2066.63,413326.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','169135',3335955,'2339','357',2114651.26,2115774.68,1123.42,224684.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169135',3335956,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169135',3335957,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169137',3335970,'2326','356',1091984.88,1093938.07,1953.19,314463.59,0.00,0.00,0.00,0.00,0.00),('1','113','823','169137',3335971,'2327','356',501452.35,502870.62,1418.27,228341.47,0.00,0.00,0.00,0.00,0.00),('1','113','823','169137',3335972,'2328','356',98854.68,98854.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169137',3335973,'2329','356',455847.46,458394.79,2547.33,410120.13,0.00,0.00,0.00,0.00,0.00),('1','113','823','169137',3335974,'2330','356',812144.75,814575.24,2430.49,391308.89,0.00,0.00,0.00,0.00,0.00),('1','113','823','169137',3335975,'2331','356',469520.56,469520.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169137',3335976,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169137',3335977,'2333','356',908643.22,910470.64,1827.42,294214.62,0.00,0.00,0.00,0.00,0.00),('1','113','823','169137',3335978,'2334','356',26023.41,27558.07,1534.66,247080.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','169137',3335979,'2335','356',670714.33,670714.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169137',3335980,'2336','356',297811.24,297811.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169137',3335981,'2337','356',448759.33,450445.02,1685.69,271396.09,0.00,0.00,0.00,0.00,0.00),('1','113','824','169137',3335982,'2338','357',973619.22,978754.94,5135.72,1027144.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','169137',3335983,'2339','357',2115774.68,2118700.42,2925.74,585148.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169137',3335984,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169137',3335985,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169300',3339015,'2326','356',1093938.07,1095675.30,1737.23,279694.03,0.00,0.00,0.00,0.00,0.00),('1','113','823','169300',3339016,'2327','356',502870.62,502870.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169300',3339017,'2328','356',98854.68,99804.78,950.10,152966.10,0.00,0.00,0.00,0.00,0.00),('1','113','823','169300',3339018,'2329','356',458394.79,459401.26,1006.47,162041.67,0.00,0.00,0.00,0.00,0.00),('1','113','823','169300',3339019,'2330','356',814575.24,816000.21,1424.97,229420.17,0.00,0.00,0.00,0.00,0.00),('1','113','823','169300',3339020,'2331','356',469520.56,469520.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169300',3339021,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169300',3339022,'2333','356',910470.64,911570.63,1099.99,177098.39,0.00,0.00,0.00,0.00,0.00),('1','113','823','169300',3339023,'2334','356',27558.07,27558.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169300',3339024,'2335','356',670714.33,671663.06,948.73,152745.53,0.00,0.00,0.00,0.00,0.00),('1','113','823','169300',3339025,'2336','356',297811.24,298797.03,985.79,158712.19,0.00,0.00,0.00,0.00,0.00),('1','113','823','169300',3339026,'2337','356',450445.02,450445.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','169300',3339027,'2338','357',978754.94,980671.94,1917.00,383400.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','169300',3339028,'2339','357',2118700.42,2120115.42,1415.00,283000.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169300',3339029,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169300',3339030,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169301',3339031,'2326','356',1095675.30,1096538.81,863.51,139025.11,0.00,0.00,0.00,0.00,0.00),('1','113','823','169301',3339032,'2327','356',502870.62,504246.99,1376.37,221595.57,0.00,0.00,0.00,0.00,0.00),('1','113','823','169301',3339033,'2328','356',99804.78,101638.26,1833.48,295190.28,0.00,0.00,0.00,0.00,0.00),('1','113','823','169301',3339034,'2329','356',459401.26,459401.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169301',3339035,'2330','356',816000.21,817824.54,1824.33,293717.13,0.00,0.00,0.00,0.00,0.00),('1','113','823','169301',3339036,'2331','356',469520.56,469520.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169301',3339037,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169301',3339038,'2333','356',911570.63,912946.60,1375.97,221531.17,0.00,0.00,0.00,0.00,0.00),('1','113','823','169301',3339039,'2334','356',27558.07,27558.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169301',3339040,'2335','356',671663.06,672725.09,1062.03,170986.83,0.00,0.00,0.00,0.00,0.00),('1','113','823','169301',3339041,'2336','356',298797.03,298797.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169301',3339042,'2337','356',450445.02,451022.94,577.92,93045.12,0.00,0.00,0.00,0.00,0.00),('1','113','824','169301',3339043,'2338','357',980671.94,981065.41,393.47,78694.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','169301',3339044,'2339','357',2120115.42,2123296.63,3181.21,636242.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169301',3339045,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169301',3339046,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169678',3346602,'2326','356',1096538.81,1098348.96,1810.15,291434.15,0.00,0.00,0.00,0.00,0.00),('1','113','823','169678',3346603,'2327','356',504246.99,504246.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169678',3346604,'2328','356',101638.26,103121.03,1482.77,238725.97,0.00,0.00,0.00,0.00,0.00),('1','113','823','169678',3346605,'2329','356',459401.26,459401.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169678',3346606,'2330','356',817824.54,818892.15,1067.61,171885.21,0.00,0.00,0.00,0.00,0.00),('1','113','823','169678',3346607,'2331','356',469520.56,470267.36,746.80,120234.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','169678',3346608,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169678',3346609,'2333','356',912946.60,913740.20,793.60,127769.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','169678',3346610,'2334','356',27558.07,27558.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169678',3346611,'2335','356',672725.09,673245.97,520.88,83861.68,0.00,0.00,0.00,0.00,0.00),('1','113','823','169678',3346612,'2336','356',298797.03,299205.80,408.77,65811.97,0.00,0.00,0.00,0.00,0.00),('1','113','823','169678',3346613,'2337','356',451022.94,451022.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','169678',3346614,'2338','357',981065.41,981736.58,671.17,134234.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','169678',3346615,'2339','357',2123296.63,2124819.20,1522.57,304514.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169678',3346616,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169678',3346617,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169682',3346690,'2326','356',1098348.96,1100645.93,2296.97,369812.17,0.00,0.00,0.00,0.00,0.00),('1','113','823','169682',3346691,'2327','356',504246.99,504246.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169682',3346692,'2328','356',103121.03,103121.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169682',3346693,'2329','356',459401.26,461242.15,1840.89,296383.29,0.00,0.00,0.00,0.00,0.00),('1','113','823','169682',3346694,'2330','356',818892.15,818892.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169682',3346695,'2331','356',470267.36,471581.27,1313.91,211539.51,0.00,0.00,0.00,0.00,0.00),('1','113','823','169682',3346696,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169682',3346697,'2333','356',913740.20,915395.46,1635.26,263276.86,0.00,0.00,20.00,0.00,0.00),('1','113','823','169682',3346698,'2334','356',27558.07,27824.49,266.42,42893.62,0.00,0.00,0.00,0.00,0.00),('1','113','823','169682',3346699,'2335','356',673245.97,674317.68,1071.71,172545.31,0.00,0.00,0.00,0.00,0.00),('1','113','823','169682',3346700,'2336','356',299205.80,299917.52,711.72,114586.92,0.00,0.00,0.00,0.00,0.00),('1','113','823','169682',3346701,'2337','356',451022.94,451026.05,3.11,500.71,0.00,0.00,0.00,0.00,0.00),('1','113','824','169682',3346702,'2338','357',981736.58,982028.23,291.65,58330.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','169682',3346703,'2339','357',2124819.20,2125749.70,930.50,186100.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169682',3346704,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169682',3346705,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169693',3346865,'2326','356',1100645.93,1102111.37,1465.44,235935.84,0.00,0.00,0.00,0.00,0.00),('1','113','823','169693',3346866,'2327','356',504246.99,504246.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169693',3346867,'2328','356',103121.03,104694.11,1573.08,253265.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','169693',3346868,'2329','356',461242.15,461242.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169693',3346869,'2330','356',818892.15,818892.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169693',3346870,'2331','356',471581.27,472734.47,1153.20,185665.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','169693',3346871,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169693',3346872,'2333','356',915395.46,916485.65,1090.19,175520.59,0.00,0.00,0.00,0.00,0.00),('1','113','823','169693',3346873,'2334','356',27824.49,29044.67,1220.18,196448.98,0.00,0.00,0.00,0.00,0.00),('1','113','823','169693',3346874,'2335','356',674317.68,674317.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169693',3346875,'2336','356',299917.52,299917.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169693',3346876,'2337','356',451026.05,451663.16,637.11,102574.71,0.00,0.00,0.00,0.00,0.00),('1','113','824','169693',3346877,'2338','357',982028.23,982150.22,121.99,24398.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','169693',3346878,'2339','357',2125749.70,2127679.68,1929.98,385996.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169693',3346879,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169693',3346880,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169709',3347117,'2326','356',1102111.37,1103373.03,1261.66,203127.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','169709',3347118,'2327','356',504246.99,504246.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169709',3347119,'2328','356',104694.11,105027.99,333.88,53754.68,0.00,0.00,0.00,0.00,0.00),('1','113','823','169709',3347120,'2329','356',461242.15,462423.60,1161.45,186993.45,0.00,0.00,20.00,0.00,0.00),('1','113','823','169709',3347121,'2330','356',818892.15,820022.21,1120.06,180329.66,0.00,0.00,10.00,0.00,0.00),('1','113','823','169709',3347122,'2331','356',472734.47,472734.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169709',3347123,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169709',3347124,'2333','356',916485.65,917854.10,1368.45,220320.45,0.00,0.00,0.00,0.00,0.00),('1','113','823','169709',3347125,'2334','356',29044.67,29044.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169709',3347126,'2335','356',674317.68,674731.72,414.04,66660.44,0.00,0.00,0.00,0.00,0.00),('1','113','823','169709',3347127,'2336','356',299917.52,301025.85,1108.33,178441.13,0.00,0.00,0.00,0.00,0.00),('1','113','823','169709',3347128,'2337','356',451663.16,451663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','169709',3347129,'2338','357',982150.22,983906.54,1756.32,351264.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','169709',3347130,'2339','357',2127679.68,2129881.18,2201.50,440300.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169709',3347131,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169709',3347132,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169722',3347392,'2326','356',1103373.03,1104853.63,1480.60,238376.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','169722',3347393,'2327','356',504246.99,504246.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169722',3347394,'2328','356',105027.99,105027.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169722',3347395,'2329','356',462423.60,463714.88,1291.28,207896.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','169722',3347396,'2330','356',820022.21,820022.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169722',3347397,'2331','356',472734.47,474060.31,1325.84,213460.24,0.00,0.00,0.00,0.00,0.00),('1','113','823','169722',3347398,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169722',3347399,'2333','356',917854.10,918699.71,845.61,136143.21,0.00,0.00,0.00,0.00,0.00),('1','113','823','169722',3347400,'2334','356',29044.67,29044.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169722',3347401,'2335','356',674731.72,675752.50,1020.78,164345.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','169722',3347402,'2336','356',301025.85,301570.65,544.80,87712.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','169722',3347403,'2337','356',451663.16,451663.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','169722',3347404,'2338','357',983906.54,984648.55,742.01,148402.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','169722',3347405,'2339','357',2129881.18,2130429.43,548.25,109650.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169722',3347406,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169722',3347407,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169797',3348534,'2326','356',1104853.63,1106950.91,2097.28,337662.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','169797',3348535,'2327','356',504246.99,504246.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169797',3348536,'2328','356',105027.99,106924.64,1896.65,305360.65,0.00,0.00,0.00,0.00,0.00),('1','113','823','169797',3348537,'2329','356',463714.88,463714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169797',3348538,'2330','356',820022.21,820022.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169797',3348539,'2331','356',474060.31,475519.11,1458.80,234866.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','169797',3348540,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169797',3348541,'2333','356',918699.71,920438.76,1739.05,279987.05,0.00,0.00,0.00,0.00,0.00),('1','113','823','169797',3348542,'2334','356',29044.67,29244.53,199.86,32177.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','169797',3348543,'2335','356',675752.50,676656.56,904.06,145553.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','169797',3348544,'2336','356',301570.65,301570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169797',3348545,'2337','356',451663.16,452667.38,1004.22,161679.42,0.00,0.00,0.00,0.00,0.00),('1','113','824','169797',3348546,'2338','357',984648.55,985753.54,1104.99,220998.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','169797',3348547,'2339','357',2130429.43,2131229.53,800.10,160020.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169797',3348548,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169797',3348549,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169996',3352409,'2326','356',1106950.91,1106950.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169996',3352410,'2327','356',504246.99,505620.03,1373.04,221059.44,0.00,0.00,0.00,0.00,0.00),('1','113','823','169996',3352411,'2328','356',106924.64,108421.61,1496.97,241012.17,0.00,0.00,0.00,0.00,0.00),('1','113','823','169996',3352412,'2329','356',463714.88,463714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169996',3352413,'2330','356',820022.21,820353.35,331.14,53313.54,0.00,0.00,0.00,0.00,0.00),('1','113','823','169996',3352414,'2331','356',475519.11,476546.57,1027.46,165421.06,0.00,0.00,0.00,0.00,0.00),('1','113','823','169996',3352415,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169996',3352416,'2333','356',920438.76,921375.59,936.83,150829.63,0.00,0.00,0.00,0.00,0.00),('1','113','823','169996',3352417,'2334','356',29244.53,30405.62,1161.09,186935.49,0.00,0.00,0.00,0.00,0.00),('1','113','823','169996',3352418,'2335','356',676656.56,676656.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169996',3352419,'2336','356',301570.65,301965.10,394.45,63506.45,0.00,0.00,0.00,0.00,0.00),('1','113','823','169996',3352420,'2337','356',452667.38,452667.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','169996',3352421,'2338','357',985753.54,986585.77,832.23,166446.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','169996',3352422,'2339','357',2131229.53,2132068.79,839.26,167852.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169996',3352423,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169996',3352424,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169998',3352441,'2326','356',1106950.91,1108909.84,1958.93,315387.73,0.00,0.00,0.00,0.00,0.00),('1','113','823','169998',3352442,'2327','356',505620.03,505620.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169998',3352443,'2328','356',108421.61,110579.08,2157.47,347352.67,0.00,0.00,0.00,0.00,0.00),('1','113','823','169998',3352444,'2329','356',463714.88,463714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169998',3352445,'2330','356',820353.35,822162.65,1809.30,291297.30,0.00,0.00,0.00,0.00,0.00),('1','113','823','169998',3352446,'2331','356',476546.57,476546.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169998',3352447,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169998',3352448,'2333','356',921375.59,922915.95,1540.36,247997.96,0.00,0.00,0.00,0.00,0.00),('1','113','823','169998',3352449,'2334','356',30405.62,31126.14,720.52,116003.72,0.00,0.00,0.00,0.00,0.00),('1','113','823','169998',3352450,'2335','356',676656.56,676656.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','169998',3352451,'2336','356',301965.10,302068.96,83.86,13501.46,0.00,0.00,20.00,0.00,0.00),('1','113','823','169998',3352452,'2337','356',452667.38,453692.67,1025.29,165071.69,0.00,0.00,0.00,0.00,0.00),('1','113','824','169998',3352453,'2338','357',986585.77,988597.76,2011.99,402398.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','169998',3352454,'2339','357',2132068.79,2134387.79,2319.00,463800.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169998',3352455,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','169998',3352456,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170191',3355714,'2326','356',1108909.84,1110475.51,1565.67,252072.87,0.00,0.00,0.00,0.00,0.00),('1','113','823','170191',3355715,'2327','356',505620.03,505620.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170191',3355716,'2328','356',110579.08,112073.27,1494.19,240564.59,0.00,0.00,0.00,0.00,0.00),('1','113','823','170191',3355717,'2329','356',463714.88,463714.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170191',3355718,'2330','356',822162.65,822951.53,788.88,127009.68,0.00,0.00,0.00,0.00,0.00),('1','113','823','170191',3355719,'2331','356',476546.57,477250.89,704.32,113395.52,0.00,0.00,0.00,0.00,0.00),('1','113','823','170191',3355720,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170191',3355721,'2333','356',922915.95,923937.04,1021.09,164395.49,0.00,0.00,0.00,0.00,0.00),('1','113','823','170191',3355722,'2334','356',31126.14,31126.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170191',3355723,'2335','356',676656.56,677977.71,1321.15,212705.15,0.00,0.00,0.00,0.00,0.00),('1','113','823','170191',3355724,'2336','356',302068.96,302842.22,773.26,124494.86,0.00,0.00,0.00,0.00,0.00),('1','113','823','170191',3355725,'2337','356',453692.67,453692.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','170191',3355726,'2338','357',988597.76,989758.74,1160.98,232196.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','170191',3355727,'2339','357',2134387.79,2135862.29,1474.50,294900.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170191',3355728,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170191',3355729,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170195',3355776,'2326','356',1110475.51,1112361.89,1886.38,303707.18,0.00,0.00,0.00,0.00,0.00),('1','113','823','170195',3355777,'2327','356',505620.03,505620.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170195',3355778,'2328','356',112073.27,114497.23,2423.96,390257.56,0.00,0.00,0.00,0.00,0.00),('1','113','823','170195',3355779,'2329','356',463714.88,463715.01,0.00,0.00,0.00,0.00,0.13,0.00,0.00),('1','113','823','170195',3355780,'2330','356',822951.53,822951.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170195',3355781,'2331','356',477250.89,478735.55,1484.66,239030.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','170195',3355782,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170195',3355783,'2333','356',923937.04,925997.07,2050.03,330054.83,0.00,0.00,10.00,0.00,0.00),('1','113','823','170195',3355784,'2334','356',31126.14,31126.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170195',3355785,'2335','356',677977.71,679813.17,1835.46,295509.06,0.00,0.00,0.00,0.00,0.00),('1','113','823','170195',3355786,'2336','356',302842.22,303631.39,789.17,127056.37,0.00,0.00,0.00,0.00,0.00),('1','113','823','170195',3355787,'2337','356',453692.67,454249.26,556.59,89610.99,0.00,0.00,0.00,0.00,0.00),('1','113','824','170195',3355788,'2338','357',989758.74,990620.24,861.50,172300.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','170195',3355789,'2339','357',2135862.29,2138190.82,2328.53,465706.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170195',3355790,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170195',3355791,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170383',3359008,'2326','356',1112361.89,1112361.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170383',3359009,'2327','356',505620.03,507316.13,1696.10,273072.10,0.00,0.00,0.00,0.00,0.00),('1','113','823','170383',3359010,'2328','356',114497.23,116230.63,1733.40,279077.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','170383',3359011,'2329','356',463715.01,463715.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170383',3359012,'2330','356',822951.53,824549.47,1597.94,257268.34,0.00,0.00,0.00,0.00,0.00),('1','113','823','170383',3359013,'2331','356',478735.55,478735.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170383',3359014,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170383',3359015,'2333','356',925997.07,927173.11,1176.04,189342.44,0.00,0.00,0.00,0.00,0.00),('1','113','823','170383',3359016,'2334','356',31126.14,32231.35,1105.21,177938.81,0.00,0.00,0.00,0.00,0.00),('1','113','823','170383',3359017,'2335','356',679813.17,679813.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170383',3359018,'2336','356',303631.39,305015.59,1384.20,222856.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','170383',3359019,'2337','356',454249.26,454249.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','170383',3359020,'2338','357',990620.24,991359.24,739.00,147800.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','170383',3359021,'2339','357',2138190.82,2139184.82,994.00,198800.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170383',3359022,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170383',3359023,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170388',3359117,'2326','356',1112361.89,1114972.96,2611.07,420382.27,0.00,0.00,0.00,0.00,0.00),('1','113','823','170388',3359118,'2327','356',507316.13,507316.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170388',3359119,'2328','356',116230.63,117774.27,1543.64,248526.04,0.00,0.00,0.00,0.00,0.00),('1','113','823','170388',3359120,'2329','356',463715.01,463715.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170388',3359121,'2330','356',824549.47,824549.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170388',3359122,'2331','356',478735.55,481144.24,2408.69,387799.09,0.00,0.00,0.00,0.00,0.00),('1','113','823','170388',3359123,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170388',3359124,'2333','356',927173.11,929677.52,2504.41,403210.01,0.00,0.00,0.00,0.00,0.00),('1','113','823','170388',3359125,'2334','356',32231.35,32231.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170388',3359126,'2335','356',679813.17,682323.54,2510.37,404169.57,0.00,0.00,0.00,0.00,0.00),('1','113','823','170388',3359127,'2336','356',305015.59,307209.45,2193.86,353211.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','170388',3359128,'2337','356',454249.26,454249.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','170388',3359129,'2338','357',991359.24,994953.00,3593.76,718752.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','170388',3359130,'2339','357',2139184.82,2141002.33,1817.51,363502.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170388',3359131,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170388',3359132,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170415',3359669,'2326','356',1114972.96,1116560.57,1587.61,255605.21,0.00,0.00,0.00,0.00,0.00),('1','113','823','170415',3359670,'2327','356',507316.13,507316.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170415',3359671,'2328','356',117774.27,119161.09,1386.82,223278.02,0.00,0.00,0.00,0.00,0.00),('1','113','823','170415',3359672,'2329','356',463715.01,463715.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170415',3359673,'2330','356',824549.47,825907.06,1357.59,218571.99,0.00,0.00,0.00,0.00,0.00),('1','113','823','170415',3359674,'2331','356',481144.24,481144.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170415',3359675,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170415',3359676,'2333','356',929677.52,930908.37,1230.85,198166.85,0.00,0.00,0.00,0.00,0.00),('1','113','823','170415',3359677,'2334','356',32231.35,32231.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170415',3359678,'2335','356',682323.54,683285.87,962.33,154935.13,0.00,0.00,0.00,0.00,0.00),('1','113','823','170415',3359679,'2336','356',307209.45,307209.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170415',3359680,'2337','356',454249.26,454763.88,514.62,82853.82,0.00,0.00,0.00,0.00,0.00),('1','113','824','170415',3359681,'2338','357',994953.00,995154.80,201.80,40360.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','170415',3359682,'2339','357',2141002.33,2143017.33,2015.00,403000.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170415',3359683,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170415',3359684,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170529',3361582,'2326','356',1116560.57,1116560.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170529',3361583,'2327','356',507316.13,507316.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170529',3361584,'2328','356',119161.09,121840.90,2679.81,431449.41,0.00,0.00,0.00,0.00,0.00),('1','113','823','170529',3361585,'2329','356',463715.01,463715.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170529',3361586,'2330','356',825907.06,827988.05,2080.99,335039.39,0.00,0.00,0.00,0.00,0.00),('1','113','823','170529',3361587,'2331','356',481144.24,481144.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170529',3361588,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170529',3361589,'2333','356',930908.37,932417.91,1499.54,241425.94,0.00,0.00,10.00,0.00,0.00),('1','113','823','170529',3361590,'2334','356',32231.35,32231.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170529',3361591,'2335','356',683285.87,684833.66,1547.79,249194.19,0.00,0.00,0.00,0.00,0.00),('1','113','823','170529',3361592,'2336','356',307209.45,308220.75,1011.30,162819.30,0.00,0.00,0.00,0.00,0.00),('1','113','823','170529',3361593,'2337','356',454763.88,454763.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','170529',3361594,'2338','357',995154.80,995293.30,138.50,27700.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','170529',3361595,'2339','357',2143017.33,2143741.86,724.53,144906.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170529',3361596,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170529',3361597,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170856',3367374,'2326','356',1116560.57,1118493.19,1932.62,311151.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','170856',3367375,'2327','356',507316.13,507316.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170856',3367376,'2328','356',121840.90,121840.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170856',3367377,'2329','356',463715.01,463715.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170856',3367378,'2330','356',827988.05,827988.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170856',3367379,'2331','356',481144.24,482272.20,1127.96,181601.56,0.00,0.00,0.00,0.00,0.00),('1','113','823','170856',3367380,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170856',3367381,'2333','356',932417.91,933759.17,1341.26,215942.86,0.00,0.00,0.00,0.00,0.00),('1','113','823','170856',3367382,'2334','356',32231.35,32231.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170856',3367383,'2335','356',684833.66,685937.97,1104.31,177793.91,0.00,0.00,0.00,0.00,0.00),('1','113','823','170856',3367384,'2336','356',308220.75,309225.57,1004.82,161776.02,0.00,0.00,0.00,0.00,0.00),('1','113','823','170856',3367385,'2337','356',454763.88,454763.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','170856',3367386,'2338','357',995293.30,997557.30,2264.00,452800.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','170856',3367387,'2339','357',2143741.86,2145985.46,2243.60,448720.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170856',3367388,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170856',3367389,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170859',3367431,'2326','356',1118493.19,1120484.00,1990.81,320520.41,0.00,0.00,0.00,0.00,0.00),('1','113','823','170859',3367432,'2327','356',507316.13,507316.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170859',3367433,'2328','356',121840.90,123695.59,1854.69,298605.09,0.00,0.00,0.00,0.00,0.00),('1','113','823','170859',3367434,'2329','356',463715.01,463715.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170859',3367435,'2330','356',827988.05,829285.30,1297.25,208857.25,0.00,0.00,0.00,0.00,0.00),('1','113','823','170859',3367436,'2331','356',482272.20,482272.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170859',3367437,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170859',3367438,'2333','356',933759.17,935066.97,1307.80,210555.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','170859',3367439,'2334','356',32231.35,32231.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170859',3367440,'2335','356',685937.97,687347.75,1409.78,226974.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','170859',3367441,'2336','356',309225.57,310097.52,871.95,140383.95,0.00,0.00,0.00,0.00,0.00),('1','113','823','170859',3367442,'2337','356',454763.88,454763.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','170859',3367443,'2338','357',997557.30,998843.34,1286.04,257208.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','170859',3367444,'2339','357',2145985.46,2147864.70,1879.24,375848.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170859',3367445,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170859',3367446,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170864',3367515,'2326','356',1120484.00,1122225.46,1741.46,280375.06,0.00,0.00,0.00,0.00,0.00),('1','113','823','170864',3367516,'2327','356',507316.13,507316.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170864',3367517,'2328','356',123695.59,125117.35,1421.76,228903.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','170864',3367518,'2329','356',463715.01,463715.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170864',3367519,'2330','356',829285.30,829285.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170864',3367520,'2331','356',482272.20,482272.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170864',3367521,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170864',3367522,'2333','356',935066.97,936374.67,1307.70,210539.70,0.00,0.00,0.00,0.00,0.00),('1','113','823','170864',3367523,'2334','356',32231.35,32231.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170864',3367524,'2335','356',687347.75,688593.68,1245.93,200594.73,0.00,0.00,0.00,0.00,0.00),('1','113','823','170864',3367525,'2336','356',310097.52,311108.13,1010.61,162708.21,0.00,0.00,0.00,0.00,0.00),('1','113','823','170864',3367526,'2337','356',454763.88,454763.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','170864',3367527,'2338','357',998843.34,999074.34,231.00,46200.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','170864',3367528,'2339','357',2147864.70,2149054.70,1190.00,238000.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170864',3367529,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170864',3367530,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170867',3367590,'2326','356',1122225.46,1124212.16,1986.70,319858.70,0.00,0.00,0.00,0.00,0.00),('1','113','823','170867',3367591,'2327','356',507316.13,507316.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170867',3367592,'2328','356',125117.35,126764.47,1647.12,265186.32,0.00,0.00,0.00,0.00,0.00),('1','113','823','170867',3367593,'2329','356',463715.01,463715.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170867',3367594,'2330','356',829285.30,829285.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170867',3367595,'2331','356',482272.20,483674.63,1402.43,225791.23,0.00,0.00,0.00,0.00,0.00),('1','113','823','170867',3367596,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170867',3367597,'2333','356',936374.67,937457.60,1082.93,174351.73,0.00,0.00,0.00,0.00,0.00),('1','113','823','170867',3367598,'2334','356',32231.35,33572.51,1341.16,215926.76,0.00,0.00,0.00,0.00,0.00),('1','113','823','170867',3367599,'2335','356',688593.68,688593.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170867',3367600,'2336','356',311108.13,312142.84,1034.71,166588.31,0.00,0.00,0.00,0.00,0.00),('1','113','823','170867',3367601,'2337','356',454763.88,454763.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','170867',3367602,'2338','357',999074.34,1000952.34,1878.00,375600.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','170867',3367603,'2339','357',2149054.70,2150025.47,970.77,194154.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170867',3367604,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170867',3367605,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170914',3368397,'2326','356',1124212.16,1125670.43,1458.27,234781.47,0.00,0.00,0.00,0.00,0.00),('1','113','823','170914',3368398,'2327','356',507316.13,507316.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170914',3368399,'2328','356',126764.47,128298.16,1533.69,246924.09,0.00,0.00,0.00,0.00,0.00),('1','113','823','170914',3368400,'2329','356',463715.01,463715.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170914',3368401,'2330','356',829285.30,829285.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170914',3368402,'2331','356',483674.63,484965.09,1290.46,207764.06,0.00,0.00,0.00,0.00,0.00),('1','113','823','170914',3368403,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','170914',3368404,'2333','356',937457.60,938460.85,1003.25,161523.25,0.00,0.00,0.00,0.00,0.00),('1','113','823','170914',3368405,'2334','356',33572.51,33824.96,252.45,40644.45,0.00,0.00,0.00,0.00,0.00),('1','113','823','170914',3368406,'2335','356',688593.68,689322.27,728.59,117302.99,0.00,0.00,0.00,0.00,0.00),('1','113','823','170914',3368407,'2336','356',312142.84,312173.90,31.06,5000.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','170914',3368408,'2337','356',454763.88,455477.96,714.08,114966.88,0.00,0.00,0.00,0.00,0.00),('1','113','824','170914',3368409,'2338','357',1000952.34,1001651.84,699.50,139900.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','170914',3368410,'2339','357',2150025.47,2151086.98,1061.51,212302.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170914',3368411,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','170914',3368412,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171072',3371362,'2326','356',1125670.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171072',3371363,'2327','356',507316.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171072',3371364,'2328','356',128298.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171072',3371365,'2329','356',463715.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171072',3371366,'2330','356',829285.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171072',3371367,'2331','356',484965.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171072',3371368,'2332','356',15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171072',3371369,'2333','356',938460.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171072',3371370,'2334','356',33824.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171072',3371371,'2335','356',689322.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171072',3371372,'2336','356',312173.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171072',3371373,'2337','356',455477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','171072',3371374,'2338','357',1001651.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','171072',3371375,'2339','357',2151086.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171072',3371376,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171072',3371377,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171074',3371394,'2326','356',1125670.43,1126427.92,757.49,121955.89,0.00,0.00,0.00,0.00,0.00),('1','113','823','171074',3371395,'2327','356',507316.13,508380.77,1064.64,171407.04,0.00,0.00,0.00,0.00,0.00),('1','113','823','171074',3371396,'2328','356',128298.16,128759.34,461.18,74249.98,0.00,0.00,0.00,0.00,0.00),('1','113','823','171074',3371397,'2329','356',463715.01,465063.15,1348.14,217050.54,0.00,0.00,0.00,0.00,0.00),('1','113','823','171074',3371398,'2330','356',829285.30,831395.68,2110.38,339771.18,0.00,0.00,0.00,0.00,0.00),('1','113','823','171074',3371399,'2331','356',484965.09,485383.74,418.65,67402.65,0.00,0.00,0.00,0.00,0.00),('1','113','823','171074',3371400,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171074',3371401,'2333','356',938460.85,939916.30,1455.45,234327.45,0.00,0.00,0.00,0.00,0.00),('1','113','823','171074',3371402,'2334','356',33824.96,33824.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171074',3371403,'2335','356',689322.27,690559.60,1237.33,199210.13,0.00,0.00,0.00,0.00,0.00),('1','113','823','171074',3371404,'2336','356',312173.90,313168.95,995.05,160203.05,0.00,0.00,0.00,0.00,0.00),('1','113','823','171074',3371405,'2337','356',455477.96,455477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','171074',3371406,'2338','357',1001651.84,1002455.23,803.39,160678.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','171074',3371407,'2339','357',2151086.98,2153828.15,2741.17,548234.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171074',3371408,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171074',3371409,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171169',3373317,'2326','356',1126427.92,1128096.18,1668.26,268589.86,0.00,0.00,0.00,0.00,0.00),('1','113','823','171169',3373318,'2327','356',508380.77,508380.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171169',3373319,'2328','356',128759.34,130284.86,1525.52,245608.72,0.00,0.00,0.00,0.00,0.00),('1','113','823','171169',3373320,'2329','356',465063.15,465063.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171169',3373321,'2330','356',831395.68,832940.36,1544.68,248693.48,0.00,0.00,0.00,0.00,0.00),('1','113','823','171169',3373322,'2331','356',485383.74,485383.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171169',3373323,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171169',3373324,'2333','356',939916.30,941121.81,1205.51,194087.11,0.00,0.00,0.00,0.00,0.00),('1','113','823','171169',3373325,'2334','356',33824.96,33824.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171169',3373326,'2335','356',690559.60,691461.59,901.99,145220.39,0.00,0.00,0.00,0.00,0.00),('1','113','823','171169',3373327,'2336','356',313168.95,313767.79,598.84,96413.24,0.00,0.00,0.00,0.00,0.00),('1','113','823','171169',3373328,'2337','356',455477.96,455477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','171169',3373329,'2338','357',1002455.23,1003355.59,900.36,180072.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','171169',3373330,'2339','357',2153828.15,2154884.68,1056.53,211306.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171169',3373331,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171169',3373332,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171256',3374814,'2326','356',1128096.18,1130746.52,2650.34,426704.74,0.00,0.00,0.00,0.00,0.00),('1','113','823','171256',3374815,'2327','356',508380.77,508380.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171256',3374816,'2328','356',130284.86,132728.26,2443.40,393387.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','171256',3374817,'2329','356',465063.15,465063.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171256',3374818,'2330','356',832940.36,832940.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171256',3374819,'2331','356',485383.74,487292.95,1899.21,305772.81,0.00,0.00,10.00,0.00,0.00),('1','113','823','171256',3374820,'2332','356',15444.57,15444.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171256',3374821,'2333','356',941121.81,943430.10,2308.29,371634.69,0.00,0.00,0.00,0.00,0.00),('1','113','823','171256',3374822,'2334','356',33824.96,34238.60,413.64,66596.04,0.00,0.00,0.00,0.00,0.00),('1','113','823','171256',3374823,'2335','356',691461.59,691461.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171256',3374824,'2336','356',313767.79,315710.72,1942.93,312811.73,0.00,0.00,0.00,0.00,0.00),('1','113','823','171256',3374825,'2337','356',455477.96,455477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','171256',3374826,'2338','357',1003355.59,1005941.10,2585.51,517102.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','171256',3374827,'2339','357',2154884.68,2157275.18,2390.50,478100.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171256',3374828,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171256',3374829,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171430',3377964,'2326','356',1130746.52,1132990.44,2243.92,361271.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','171430',3377965,'2327','356',508380.77,508380.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171430',3377966,'2328','356',132728.26,134268.94,1540.68,248049.48,0.00,0.00,0.00,0.00,0.00),('1','113','823','171430',3377967,'2329','356',465063.15,465063.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171430',3377968,'2330','356',832940.36,832940.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171430',3377969,'2331','356',487292.95,488624.61,1331.66,214397.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','171430',3377970,'2332','356',15444.57,15445.47,0.90,144.90,0.00,0.00,0.00,0.00,0.00),('1','113','823','171430',3377971,'2333','356',943430.10,944606.10,1176.00,189336.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171430',3377972,'2334','356',34238.60,34238.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171430',3377973,'2335','356',691461.59,691461.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171430',3377974,'2336','356',315710.72,316735.85,1025.13,165045.93,0.00,0.00,0.00,0.00,0.00),('1','113','823','171430',3377975,'2337','356',455477.96,455481.07,3.11,500.71,0.00,0.00,0.00,0.00,0.00),('1','113','824','171430',3377976,'2338','357',1005941.10,1008231.93,2290.83,458166.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','171430',3377977,'2339','357',2157275.18,2159823.58,2548.40,509680.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171430',3377978,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171430',3377979,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171431',3377980,'2326','356',1132990.44,1136031.68,3031.24,488029.64,0.00,0.00,10.00,0.00,0.00),('1','113','823','171431',3377981,'2327','356',508380.77,508380.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171431',3377982,'2328','356',134268.94,136171.40,1892.46,304686.06,0.00,0.00,10.00,0.00,0.00),('1','113','823','171431',3377983,'2329','356',465063.15,465063.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171431',3377984,'2330','356',832940.36,835412.35,2461.99,396380.39,0.00,0.00,10.00,0.00,0.00),('1','113','823','171431',3377985,'2331','356',488624.61,488624.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171431',3377986,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171431',3377987,'2333','356',944606.10,946594.11,1978.01,318459.61,0.00,0.00,10.00,0.00,0.00),('1','113','823','171431',3377988,'2334','356',34238.60,34238.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171431',3377989,'2335','356',691461.59,694425.92,2944.33,474037.13,0.00,0.00,20.00,0.00,0.00),('1','113','823','171431',3377990,'2336','356',316735.85,316745.82,-0.03,-4.83,0.00,0.00,10.00,0.00,0.00),('1','113','823','171431',3377991,'2337','356',455481.07,455481.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','171431',3377992,'2338','357',1008231.93,1014052.65,5810.72,1162144.00,0.00,0.00,10.00,0.00,0.00),('1','113','824','171431',3377993,'2339','357',2159823.58,2164112.41,4288.83,857766.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171431',3377994,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171431',3377995,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171655',3382126,'2326','356',1136031.68,1136031.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171655',3382127,'2327','356',508380.77,509835.40,1454.63,234195.43,0.00,0.00,0.00,0.00,0.00),('1','113','823','171655',3382128,'2328','356',136171.40,137729.54,1558.14,250860.54,0.00,0.00,0.00,0.00,0.00),('1','113','823','171655',3382129,'2329','356',465063.15,465063.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171655',3382130,'2330','356',835412.35,836908.08,1495.73,240812.53,0.00,0.00,0.00,0.00,0.00),('1','113','823','171655',3382131,'2331','356',488624.61,488624.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171655',3382132,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171655',3382133,'2333','356',946594.11,947825.37,1231.26,198232.86,0.00,0.00,0.00,0.00,0.00),('1','113','823','171655',3382134,'2334','356',34238.60,34238.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171655',3382135,'2335','356',694425.92,695586.48,1160.56,186850.16,0.00,0.00,0.00,0.00,0.00),('1','113','823','171655',3382136,'2336','356',316745.82,317650.14,904.32,145595.52,0.00,0.00,0.00,0.00,0.00),('1','113','823','171655',3382137,'2337','356',455481.07,455481.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','171655',3382138,'2338','357',1014052.65,1016221.88,2169.23,433846.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','171655',3382139,'2339','357',2164112.41,2166572.92,2460.51,492102.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171655',3382140,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171655',3382141,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171658',3382159,'2326','356',1136031.68,1138972.10,2940.42,473407.62,0.00,0.00,0.00,0.00,0.00),('1','113','823','171658',3382160,'2327','356',509835.40,509835.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171658',3382161,'2328','356',137729.54,137729.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171658',3382162,'2329','356',465063.15,465063.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171658',3382163,'2330','356',836908.08,836908.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171658',3382164,'2331','356',488624.61,491782.02,3157.41,508343.01,0.00,0.00,0.00,0.00,0.00),('1','113','823','171658',3382165,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171658',3382166,'2333','356',947825.37,950559.84,2734.47,440249.67,0.00,0.00,0.00,0.00,0.00),('1','113','823','171658',3382167,'2334','356',34238.60,36042.61,1804.01,290445.61,0.00,0.00,0.00,0.00,0.00),('1','113','823','171658',3382168,'2335','356',695586.48,695586.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171658',3382169,'2336','356',317650.14,318827.20,1177.06,189506.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','171658',3382170,'2337','356',455481.07,455481.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','171658',3382171,'2338','357',1016221.88,1021247.92,5026.04,1005208.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','171658',3382172,'2339','357',2166572.92,2172493.21,5920.29,1184058.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171658',3382173,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171658',3382174,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171806',3384672,'2326','356',1138972.10,1140445.45,1473.35,237209.35,0.00,0.00,0.00,0.00,0.00),('1','113','823','171806',3384673,'2327','356',509835.40,509835.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171806',3384674,'2328','356',137729.54,139057.58,1328.04,213814.44,0.00,0.00,0.00,0.00,0.00),('1','113','823','171806',3384675,'2329','356',465063.15,465063.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171806',3384676,'2330','356',836908.08,836908.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171806',3384677,'2331','356',491782.02,492992.47,1210.45,194882.45,0.00,0.00,0.00,0.00,0.00),('1','113','823','171806',3384678,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171806',3384679,'2333','356',950559.84,952056.25,1496.41,240922.01,0.00,0.00,0.00,0.00,0.00),('1','113','823','171806',3384680,'2334','356',36042.61,36042.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171806',3384681,'2335','356',695586.48,696577.34,990.86,159528.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','171806',3384682,'2336','356',318827.20,319765.63,938.43,151087.23,0.00,0.00,0.00,0.00,0.00),('1','113','823','171806',3384683,'2337','356',455481.07,455481.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','171806',3384684,'2338','357',1021247.92,1025290.11,4042.19,808438.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','171806',3384685,'2339','357',2172493.21,2176771.19,4277.98,855596.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171806',3384686,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171806',3384687,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171809',3384736,'2326','356',1140445.45,1142948.16,2502.71,402936.31,0.00,0.00,0.00,0.00,0.00),('1','113','823','171809',3384737,'2327','356',509835.40,509835.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171809',3384738,'2328','356',139057.58,141265.69,2208.11,355505.71,0.00,0.00,0.00,0.00,0.00),('1','113','823','171809',3384739,'2329','356',465063.15,465063.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171809',3384740,'2330','356',836908.08,839956.47,3048.39,490790.79,0.00,0.00,0.00,0.00,0.00),('1','113','823','171809',3384741,'2331','356',492992.47,492992.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171809',3384742,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171809',3384743,'2333','356',952056.25,952056.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171809',3384744,'2334','356',36042.61,36042.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171809',3384745,'2335','356',696577.34,698662.20,2084.86,335662.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','171809',3384746,'2336','356',319765.63,319765.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171809',3384747,'2337','356',455481.07,456858.63,1377.56,221787.16,0.00,0.00,0.00,0.00,0.00),('1','113','824','171809',3384748,'2338','357',1025290.11,1028641.86,3351.75,670350.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','171809',3384749,'2339','357',2176771.19,2183429.15,6657.96,1331592.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171809',3384750,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171809',3384751,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171881',3386148,'2326','356',1142948.16,1144705.94,1757.78,283002.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','171881',3386149,'2327','356',509835.40,509835.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171881',3386150,'2328','356',141265.69,141265.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171881',3386151,'2329','356',465063.15,466786.27,1723.12,277422.32,0.00,0.00,0.00,0.00,0.00),('1','113','823','171881',3386152,'2330','356',839956.47,839956.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171881',3386153,'2331','356',492992.47,494328.02,1335.55,215023.55,0.00,0.00,0.00,0.00,0.00),('1','113','823','171881',3386154,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171881',3386155,'2333','356',952056.25,953289.37,1223.12,196922.32,0.00,0.00,10.00,0.00,0.00),('1','113','823','171881',3386156,'2334','356',36042.61,36042.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171881',3386157,'2335','356',698662.20,699699.30,1037.10,166973.10,0.00,0.00,0.00,0.00,0.00),('1','113','823','171881',3386158,'2336','356',319765.63,319765.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','171881',3386159,'2337','356',456858.63,456858.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','171881',3386160,'2338','357',1028641.86,1030938.36,2296.50,459300.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','171881',3386161,'2339','357',2183429.15,2186683.15,3254.00,650800.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171881',3386162,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','171881',3386163,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172107',3390077,'2326','356',1144705.94,1147285.45,2579.51,415301.11,0.00,0.00,0.00,0.00,0.00),('1','113','823','172107',3390078,'2327','356',509835.40,509959.02,123.62,19902.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','172107',3390079,'2328','356',141265.69,142493.76,1228.07,197719.27,0.00,0.00,0.00,0.00,0.00),('1','113','823','172107',3390080,'2329','356',466786.27,466786.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172107',3390081,'2330','356',839956.47,839956.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172107',3390082,'2331','356',494328.02,496563.07,2235.05,359843.05,0.00,0.00,0.00,0.00,0.00),('1','113','823','172107',3390083,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172107',3390084,'2333','356',953289.37,955340.13,2050.76,330172.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','172107',3390085,'2334','356',36042.61,36042.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172107',3390086,'2335','356',699699.30,699699.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172107',3390087,'2336','356',319765.63,321523.00,1757.37,282936.57,0.00,0.00,0.00,0.00,0.00),('1','113','823','172107',3390088,'2337','356',456858.63,456858.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','172107',3390089,'2338','357',1030938.36,1035098.99,4160.63,832126.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','172107',3390090,'2339','357',2186683.15,2189995.32,3312.17,662434.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','172107',3390091,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','172107',3390092,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172108',3390093,'2326','356',1147285.45,1147285.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172108',3390094,'2327','356',509959.02,511625.80,1666.78,268351.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','172108',3390095,'2328','356',142493.76,144246.46,1752.70,282184.70,0.00,0.00,0.00,0.00,0.00),('1','113','823','172108',3390096,'2329','356',466786.27,466786.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172108',3390097,'2330','356',839956.47,839956.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172108',3390098,'2331','356',496563.07,498170.42,1607.35,258783.35,0.00,0.00,0.00,0.00,0.00),('1','113','823','172108',3390099,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172108',3390100,'2333','356',955340.13,956365.34,1025.21,165058.81,0.00,0.00,0.00,0.00,0.00),('1','113','823','172108',3390101,'2334','356',36042.61,37189.55,1146.94,184657.34,0.00,0.00,0.00,0.00,0.00),('1','113','823','172108',3390102,'2335','356',699699.30,699699.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172108',3390103,'2336','356',321523.00,322257.76,734.76,118296.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','172108',3390104,'2337','356',456858.63,456858.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','172108',3390105,'2338','357',1035098.99,1036171.16,1072.17,214434.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','172108',3390106,'2339','357',2189995.32,2191542.24,1546.92,309384.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','172108',3390107,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','172108',3390108,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172110',3390159,'2326','356',1147285.45,1149578.41,2292.96,369166.56,0.00,0.00,0.00,0.00,0.00),('1','113','823','172110',3390160,'2327','356',511625.80,511625.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172110',3390161,'2328','356',144246.46,146455.71,2209.25,355689.25,0.00,0.00,0.00,0.00,0.00),('1','113','823','172110',3390162,'2329','356',466786.27,466786.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172110',3390163,'2330','356',839956.47,841184.06,1227.59,197641.99,0.00,0.00,0.00,0.00,0.00),('1','113','823','172110',3390164,'2331','356',498170.42,498170.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172110',3390165,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172110',3390166,'2333','356',956365.34,959108.49,2743.15,441647.15,0.00,0.00,0.00,0.00,0.00),('1','113','823','172110',3390167,'2334','356',37189.55,37189.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172110',3390168,'2335','356',699699.30,702088.83,2389.53,384714.33,0.00,0.00,0.00,0.00,0.00),('1','113','823','172110',3390169,'2336','356',322257.76,322329.80,72.04,11598.44,0.00,0.00,0.00,0.00,0.00),('1','113','823','172110',3390170,'2337','356',456858.63,456858.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','172110',3390171,'2338','357',1036171.16,1037314.75,1143.59,228718.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','172110',3390172,'2339','357',2191542.24,2194902.26,3360.02,672004.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','172110',3390173,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','172110',3390174,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172336',3394334,'2326','356',1149578.41,1150565.48,987.07,158918.27,0.00,0.00,0.00,0.00,0.00),('1','113','823','172336',3394335,'2327','356',511625.80,511625.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172336',3394336,'2328','356',146455.71,146455.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172336',3394337,'2329','356',466786.27,468491.82,1705.55,274593.55,0.00,0.00,0.00,0.00,0.00),('1','113','823','172336',3394338,'2330','356',841184.06,841184.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172336',3394339,'2331','356',498170.42,499928.73,1758.31,283087.91,0.00,0.00,0.00,0.00,0.00),('1','113','823','172336',3394340,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172336',3394341,'2333','356',959108.49,960383.19,1274.70,205226.70,0.00,0.00,0.00,0.00,0.00),('1','113','823','172336',3394342,'2334','356',37189.55,37189.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172336',3394343,'2335','356',702088.83,703042.88,954.05,153602.05,0.00,0.00,0.00,0.00,0.00),('1','113','823','172336',3394344,'2336','356',322329.80,323262.56,932.76,150174.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','172336',3394345,'2337','356',456858.63,456858.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','172336',3394346,'2338','357',1037314.75,1039192.67,1877.92,375584.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','172336',3394347,'2339','357',2194902.26,2195669.26,767.00,153400.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','172336',3394348,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','172336',3394349,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172338',3394393,'2326','356',1150565.48,1153276.28,2710.80,436438.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','172338',3394394,'2327','356',511625.80,511625.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172338',3394395,'2328','356',146455.71,148723.25,2267.54,365073.94,0.00,0.00,0.00,0.00,0.00),('1','113','823','172338',3394396,'2329','356',468491.82,468491.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172338',3394397,'2330','356',841184.06,841184.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172338',3394398,'2331','356',499928.73,502468.80,2540.07,408951.27,0.00,0.00,0.00,0.00,0.00),('1','113','823','172338',3394399,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172338',3394400,'2333','356',960383.19,962845.47,2462.28,396427.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','172338',3394401,'2334','356',37189.55,37189.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172338',3394402,'2335','356',703042.88,705351.64,2308.76,371710.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','172338',3394403,'2336','356',323262.56,323286.17,23.61,3801.21,0.00,0.00,0.00,0.00,0.00),('1','113','823','172338',3394404,'2337','356',456858.63,456858.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','172338',3394405,'2338','357',1039192.67,1042567.89,3375.22,675044.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','172338',3394406,'2339','357',2195669.26,2197361.72,1692.46,338492.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','172338',3394407,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','172338',3394408,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172387',3395168,'2326','356',1153276.28,1155200.63,1924.35,309820.35,0.00,0.00,0.00,0.00,0.00),('1','113','823','172387',3395169,'2327','356',511625.80,511625.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172387',3395170,'2328','356',148723.25,150503.69,1780.44,286650.84,0.00,0.00,0.00,0.00,0.00),('1','113','823','172387',3395171,'2329','356',468491.82,468491.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172387',3395172,'2330','356',841184.06,842790.00,1605.94,258556.34,0.00,0.00,0.00,0.00,0.00),('1','113','823','172387',3395173,'2331','356',502468.80,502468.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172387',3395174,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172387',3395175,'2333','356',962845.47,964047.39,1201.92,193509.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','172387',3395176,'2334','356',37189.55,37189.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172387',3395177,'2335','356',705351.64,706514.34,1162.70,187194.70,0.00,0.00,0.00,0.00,0.00),('1','113','823','172387',3395178,'2336','356',323286.17,323593.64,307.47,49502.67,0.00,0.00,0.00,0.00,0.00),('1','113','823','172387',3395179,'2337','356',456858.63,456858.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','172387',3395180,'2338','357',1042567.89,1043609.91,1042.02,208404.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','172387',3395181,'2339','357',2197361.72,2197544.22,182.50,36500.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','172387',3395182,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','172387',3395183,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172540',3398114,'2326','356',1155200.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172540',3398115,'2327','356',511625.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172540',3398116,'2328','356',150503.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172540',3398117,'2329','356',468491.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172540',3398118,'2330','356',842790.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172540',3398119,'2331','356',502468.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172540',3398120,'2332','356',15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172540',3398121,'2333','356',964047.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172540',3398122,'2334','356',37189.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172540',3398123,'2335','356',706514.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172540',3398124,'2336','356',323593.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172540',3398125,'2337','356',456858.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','172540',3398126,'2338','357',1043609.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','172540',3398127,'2339','357',2197544.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','172540',3398128,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','172540',3398129,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172568',3398567,'2326','356',1155200.63,1157344.80,2144.17,345211.37,0.00,0.00,0.00,0.00,0.00),('1','113','823','172568',3398568,'2327','356',511625.80,511625.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172568',3398569,'2328','356',150503.69,152547.46,2043.77,329046.97,0.00,0.00,0.00,0.00,0.00),('1','113','823','172568',3398570,'2329','356',468491.82,468491.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172568',3398571,'2330','356',842790.00,844278.24,1488.24,239606.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','172568',3398572,'2331','356',502468.80,504169.42,1700.62,273799.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','172568',3398573,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172568',3398574,'2333','356',964047.39,965882.66,1835.27,295478.47,0.00,0.00,0.00,0.00,0.00),('1','113','823','172568',3398575,'2334','356',37189.55,37189.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172568',3398576,'2335','356',706514.34,707835.24,1320.90,212664.90,0.00,0.00,0.00,0.00,0.00),('1','113','823','172568',3398577,'2336','356',323593.64,324785.86,1192.22,191947.42,0.00,0.00,0.00,0.00,0.00),('1','113','823','172568',3398578,'2337','356',456858.63,456858.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','172568',3398579,'2338','357',1043609.91,1051117.23,7497.32,1536950.60,0.00,0.00,10.00,0.00,0.00),('1','113','824','172568',3398580,'2339','357',2197544.22,2205588.60,8034.38,1647047.90,0.00,0.00,10.00,0.00,0.00),('1','113','825','172568',3398581,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','172568',3398582,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172712',3401141,'2326','356',1157344.80,1159138.54,1793.74,288792.14,0.00,0.00,0.00,0.00,0.00),('1','113','823','172712',3401142,'2327','356',511625.80,511625.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172712',3401143,'2328','356',152547.46,154199.86,1652.40,266036.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','172712',3401144,'2329','356',468491.82,468491.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172712',3401145,'2330','356',844278.24,844278.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172712',3401146,'2331','356',504169.42,505925.16,1735.74,279454.14,0.00,0.00,20.00,0.00,0.00),('1','113','823','172712',3401147,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172712',3401148,'2333','356',965882.66,967235.54,1352.88,217813.68,0.00,0.00,0.00,0.00,0.00),('1','113','823','172712',3401149,'2334','356',37189.55,37189.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172712',3401150,'2335','356',707835.24,709076.89,1241.65,199905.65,0.00,0.00,0.00,0.00,0.00),('1','113','823','172712',3401151,'2336','356',324785.86,324785.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172712',3401152,'2337','356',456858.63,456858.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','172712',3401153,'2338','357',1051117.23,1053467.31,2350.08,481766.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','172712',3401154,'2339','357',2205588.60,2208354.45,2765.85,566999.25,0.00,0.00,0.00,0.00,0.00),('1','113','825','172712',3401155,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','172712',3401156,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172713',3401157,'2326','356',1159138.54,1161008.95,1870.41,301136.01,0.00,0.00,0.00,0.00,0.00),('1','113','823','172713',3401158,'2327','356',511625.80,511625.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172713',3401159,'2328','356',154199.86,155862.74,1662.88,267723.68,0.00,0.00,0.00,0.00,0.00),('1','113','823','172713',3401160,'2329','356',468491.82,470007.19,1515.37,243974.57,0.00,0.00,0.00,0.00,0.00),('1','113','823','172713',3401161,'2330','356',844278.24,844278.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172713',3401162,'2331','356',505925.16,508073.33,2148.17,345855.37,0.00,0.00,0.00,0.00,0.00),('1','113','823','172713',3401163,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172713',3401164,'2333','356',967235.54,968768.67,1533.13,246833.93,0.00,0.00,0.00,0.00,0.00),('1','113','823','172713',3401165,'2334','356',37189.55,37189.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172713',3401166,'2335','356',709076.89,710639.61,1562.72,251597.92,0.00,0.00,0.00,0.00,0.00),('1','113','823','172713',3401167,'2336','356',324785.86,325978.05,1192.19,191942.59,0.00,0.00,0.00,0.00,0.00),('1','113','823','172713',3401168,'2337','356',456858.63,456858.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','172713',3401169,'2338','357',1053467.31,1054772.34,1305.03,267531.15,0.00,0.00,0.00,0.00,0.00),('1','113','824','172713',3401170,'2339','357',2208354.45,2211351.65,2997.20,614426.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','172713',3401171,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','172713',3401172,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172798',3402760,'2326','356',1161008.95,1162618.16,1609.21,259082.81,0.00,0.00,0.00,0.00,0.00),('1','113','823','172798',3402761,'2327','356',511625.80,511625.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172798',3402762,'2328','356',155862.74,157385.43,1522.69,245153.09,0.00,0.00,0.00,0.00,0.00),('1','113','823','172798',3402763,'2329','356',470007.19,470007.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172798',3402764,'2330','356',844278.24,845900.31,1622.07,261153.27,0.00,0.00,0.00,0.00,0.00),('1','113','823','172798',3402765,'2331','356',508073.33,508073.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172798',3402766,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172798',3402767,'2333','356',968768.67,970041.76,1273.09,204967.49,0.00,0.00,0.00,0.00,0.00),('1','113','823','172798',3402768,'2334','356',37189.55,38078.00,888.45,143040.45,0.00,0.00,0.00,0.00,0.00),('1','113','823','172798',3402769,'2335','356',710639.61,710639.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172798',3402770,'2336','356',325978.05,327067.52,1089.47,175404.67,0.00,0.00,0.00,0.00,0.00),('1','113','823','172798',3402771,'2337','356',456858.63,456858.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','172798',3402772,'2338','357',1054772.34,1060593.35,5821.01,1193307.05,0.00,0.00,0.00,0.00,0.00),('1','113','824','172798',3402773,'2339','357',2211351.65,2214460.92,3109.27,637400.35,0.00,0.00,0.00,0.00,0.00),('1','113','825','172798',3402774,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','172798',3402775,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172920',3404957,'2326','356',1162618.16,1164877.92,2259.76,363821.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','172920',3404958,'2327','356',511625.80,511625.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172920',3404959,'2328','356',157385.43,159558.26,2172.83,349825.63,0.00,0.00,0.00,0.00,0.00),('1','113','823','172920',3404960,'2329','356',470007.19,470007.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172920',3404961,'2330','356',845900.31,845900.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172920',3404962,'2331','356',508073.33,510275.51,2202.18,354550.98,0.00,0.00,0.00,0.00,0.00),('1','113','823','172920',3404963,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172920',3404964,'2333','356',970041.76,971883.62,1841.86,296539.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','172920',3404965,'2334','356',38078.00,38078.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','172920',3404966,'2335','356',710639.61,712656.66,2017.05,324745.05,0.00,0.00,0.00,0.00,0.00),('1','113','823','172920',3404967,'2336','356',327067.52,328394.86,1327.34,213701.74,0.00,0.00,0.00,0.00,0.00),('1','113','823','172920',3404968,'2337','356',456858.63,456858.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','172920',3404969,'2338','357',1060593.35,1063042.99,2449.64,502176.20,0.00,0.00,0.00,0.00,0.00),('1','113','824','172920',3404970,'2339','357',2214460.92,2216503.92,2043.00,418815.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','172920',3404971,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','172920',3404972,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173119',3408933,'2326','356',1164877.92,1166871.43,1993.51,320955.11,0.00,0.00,0.00,0.00,0.00),('1','113','823','173119',3408934,'2327','356',511625.80,511625.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173119',3408935,'2328','356',159558.26,161230.22,1671.96,269185.56,0.00,0.00,0.00,0.00,0.00),('1','113','823','173119',3408936,'2329','356',470007.19,470007.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173119',3408937,'2330','356',845900.31,845900.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173119',3408938,'2331','356',510275.51,511678.79,1403.28,225928.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','173119',3408939,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173119',3408940,'2333','356',971883.62,973087.14,1203.52,193766.72,0.00,0.00,0.00,0.00,0.00),('1','113','823','173119',3408941,'2334','356',38078.00,38078.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173119',3408942,'2335','356',712656.66,713748.61,1091.95,175803.95,0.00,0.00,0.00,0.00,0.00),('1','113','823','173119',3408943,'2336','356',328394.86,328394.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173119',3408944,'2337','356',456858.63,457650.39,791.76,127473.36,0.00,0.00,0.00,0.00,0.00),('1','113','824','173119',3408945,'2338','357',1063042.99,1064280.93,1237.94,253777.70,0.00,0.00,0.00,0.00,0.00),('1','113','824','173119',3408946,'2339','357',2216503.92,2219937.13,3433.21,703808.05,0.00,0.00,0.00,0.00,0.00),('1','113','825','173119',3408947,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','173119',3408948,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173121',3408961,'2326','356',1166871.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173121',3408962,'2327','356',511625.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173121',3408963,'2328','356',161230.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173121',3408964,'2329','356',470007.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173121',3408965,'2330','356',845900.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173121',3408966,'2331','356',511678.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173121',3408967,'2332','356',15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173121',3408968,'2333','356',973087.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173121',3408969,'2334','356',38078.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173121',3408970,'2335','356',713748.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173121',3408971,'2336','356',328394.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173121',3408972,'2337','356',457650.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','173121',3408973,'2338','357',1064280.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','173121',3408974,'2339','357',2219937.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','173121',3408975,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','173121',3408976,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173125',3409073,'2326','356',1166871.43,1168218.03,1346.60,216802.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','173125',3409074,'2327','356',511625.80,512461.96,836.16,134621.76,0.00,0.00,0.00,0.00,0.00),('1','113','823','173125',3409075,'2328','356',161230.22,161230.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173125',3409076,'2329','356',470007.19,472418.08,2410.89,388153.29,0.00,0.00,0.00,0.00,0.00),('1','113','823','173125',3409077,'2330','356',845900.31,847956.87,2056.56,331106.16,0.00,0.00,0.00,0.00,0.00),('1','113','823','173125',3409078,'2331','356',511678.79,511678.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173125',3409079,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173125',3409080,'2333','356',973087.14,974905.82,1818.68,292807.48,0.00,0.00,0.00,0.00,0.00),('1','113','823','173125',3409081,'2334','356',38078.00,39680.06,1602.06,257931.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','173125',3409082,'2335','356',713748.61,713748.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173125',3409083,'2336','356',328394.86,329696.35,1301.49,209539.89,0.00,0.00,0.00,0.00,0.00),('1','113','823','173125',3409084,'2337','356',457650.39,457650.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','173125',3409085,'2338','357',1064280.93,1067975.32,3694.39,775821.90,0.00,0.00,0.00,0.00,0.00),('1','113','824','173125',3409086,'2339','357',2219937.13,2221692.02,1754.89,368526.90,0.00,0.00,0.00,0.00,0.00),('1','113','825','173125',3409087,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','173125',3409088,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173272',3411804,'2326','356',1168218.03,1170266.70,2048.67,329835.87,0.00,0.00,0.00,0.00,0.00),('1','113','823','173272',3411805,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173272',3411806,'2328','356',161230.22,161230.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173272',3411807,'2329','356',472418.08,472418.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173272',3411808,'2330','356',847956.87,847956.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173272',3411809,'2331','356',511678.79,513149.76,1470.97,236826.17,0.00,0.00,0.00,0.00,0.00),('1','113','823','173272',3411810,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173272',3411811,'2333','356',974905.82,976357.69,1451.87,233751.07,0.00,0.00,0.00,0.00,0.00),('1','113','823','173272',3411812,'2334','356',39680.06,41165.25,1485.19,239115.59,0.00,0.00,0.00,0.00,0.00),('1','113','823','173272',3411813,'2335','356',713748.61,713748.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173272',3411814,'2336','356',329696.35,330774.92,1078.57,173649.77,0.00,0.00,0.00,0.00,0.00),('1','113','823','173272',3411815,'2337','356',457650.39,457650.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','173272',3411816,'2338','357',1067975.32,1070347.89,2372.57,498239.70,0.00,0.00,0.00,0.00,0.00),('1','113','824','173272',3411817,'2339','357',2221692.02,2225083.85,3391.83,712284.30,0.00,0.00,0.00,0.00,0.00),('1','113','825','173272',3411818,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','173272',3411819,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173274',3411842,'2326','356',1170266.70,1172699.04,2432.34,391606.74,0.00,0.00,0.00,0.00,0.00),('1','113','823','173274',3411843,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173274',3411844,'2328','356',161230.22,163709.72,2479.50,399199.50,0.00,0.00,0.00,0.00,0.00),('1','113','823','173274',3411845,'2329','356',472418.08,472418.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173274',3411846,'2330','356',847956.87,847956.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173274',3411847,'2331','356',513149.76,515331.39,2181.63,351242.43,0.00,0.00,0.00,0.00,0.00),('1','113','823','173274',3411848,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173274',3411849,'2333','356',976357.69,978121.38,1763.69,283954.09,0.00,0.00,0.00,0.00,0.00),('1','113','823','173274',3411850,'2334','356',41165.25,41165.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173274',3411851,'2335','356',713748.61,715717.97,1969.36,317066.96,0.00,0.00,0.00,0.00,0.00),('1','113','823','173274',3411852,'2336','356',330774.92,330774.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173274',3411853,'2337','356',457650.39,457650.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','173274',3411854,'2338','357',1070347.89,1071436.23,1088.34,228551.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','173274',3411855,'2339','357',2225083.85,2229574.11,4490.26,942954.60,0.00,0.00,0.00,0.00,0.00),('1','113','825','173274',3411856,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','173274',3411857,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173419',3414392,'2326','356',1172699.04,1174653.73,1954.69,314705.09,0.00,0.00,0.00,0.00,0.00),('1','113','823','173419',3414393,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173419',3414394,'2328','356',163709.72,163709.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173419',3414395,'2329','356',472418.08,472485.82,67.74,10906.14,0.00,0.00,0.00,0.00,0.00),('1','113','823','173419',3414396,'2330','356',847956.87,849842.86,1885.99,303644.39,0.00,0.00,0.00,0.00,0.00),('1','113','823','173419',3414397,'2331','356',515331.39,515331.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173419',3414398,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173419',3414399,'2333','356',978121.38,979818.14,1696.76,273178.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','173419',3414400,'2334','356',41165.25,41165.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173419',3414401,'2335','356',715717.97,717306.69,1588.72,255783.92,0.00,0.00,0.00,0.00,0.00),('1','113','823','173419',3414402,'2336','356',330774.92,330774.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173419',3414403,'2337','356',457650.39,457650.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','173419',3414404,'2338','357',1071436.23,1074437.87,3001.64,630344.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','173419',3414405,'2339','357',2229574.11,2233987.51,4413.40,926814.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','173419',3414406,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','173419',3414407,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173423',3414475,'2326','356',1174653.73,1176666.01,2012.28,323977.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','173423',3414476,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173423',3414477,'2328','356',163709.72,165964.21,2254.49,362972.89,0.00,0.00,0.00,0.00,0.00),('1','113','823','173423',3414478,'2329','356',472485.82,472485.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173423',3414479,'2330','356',849842.86,849842.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173423',3414480,'2331','356',515331.39,517577.01,2245.62,361544.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','173423',3414481,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173423',3414482,'2333','356',979818.14,981351.51,1533.37,246872.57,0.00,0.00,0.00,0.00,0.00),('1','113','823','173423',3414483,'2334','356',41165.25,41165.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173423',3414484,'2335','356',717306.69,718908.53,1601.84,257896.24,0.00,0.00,0.00,0.00,0.00),('1','113','823','173423',3414485,'2336','356',330774.92,331891.01,1116.09,179690.49,0.00,0.00,0.00,0.00,0.00),('1','113','823','173423',3414486,'2337','356',457650.39,457650.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','173423',3414487,'2338','357',1074437.87,1076905.84,2467.97,518273.70,0.00,0.00,0.00,0.00,0.00),('1','113','824','173423',3414488,'2339','357',2233987.51,2238475.37,4487.86,942450.60,0.00,0.00,0.00,0.00,0.00),('1','113','825','173423',3414489,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','173423',3414490,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173622',3418109,'2326','356',1176666.01,1178124.34,1458.33,234791.13,0.00,0.00,0.00,0.00,0.00),('1','113','823','173622',3418110,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173622',3418111,'2328','356',165964.21,167714.36,1750.15,281774.15,0.00,0.00,0.00,0.00,0.00),('1','113','823','173622',3418112,'2329','356',472485.82,472485.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173622',3418113,'2330','356',849842.86,849842.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173622',3418114,'2331','356',517577.01,519276.26,1699.25,273579.25,0.00,0.00,0.00,0.00,0.00),('1','113','823','173622',3418115,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173622',3418116,'2333','356',981351.51,982849.83,1498.32,241229.52,0.00,0.00,0.00,0.00,0.00),('1','113','823','173622',3418117,'2334','356',41165.25,41165.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173622',3418118,'2335','356',718908.53,718908.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173622',3418119,'2336','356',331891.01,331891.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173622',3418120,'2337','356',457650.39,458738.33,1087.94,175158.34,0.00,0.00,0.00,0.00,0.00),('1','113','824','173622',3418121,'2338','357',1076905.84,1078614.19,1708.35,358753.50,0.00,0.00,0.00,0.00,0.00),('1','113','824','173622',3418122,'2339','357',2238475.37,2241361.05,2885.68,605992.80,0.00,0.00,0.00,0.00,0.00),('1','113','825','173622',3418123,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','173622',3418124,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173631',3418259,'2326','356',1178124.34,1180452.07,2327.73,374764.53,0.00,0.00,0.00,0.00,0.00),('1','113','823','173631',3418260,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173631',3418261,'2328','356',167714.36,167714.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173631',3418262,'2329','356',472485.82,474627.36,2141.54,344787.94,0.00,0.00,0.00,0.00,0.00),('1','113','823','173631',3418263,'2330','356',849842.86,852099.48,2256.62,363315.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','173631',3418264,'2331','356',519276.26,519276.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173631',3418265,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173631',3418266,'2333','356',982849.83,985085.43,2235.60,359931.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','173631',3418267,'2334','356',41165.25,41165.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173631',3418268,'2335','356',718908.53,719037.73,129.20,20801.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','173631',3418269,'2336','356',331891.01,334223.66,2312.11,372249.71,0.00,0.00,20.54,0.00,0.00),('1','113','823','173631',3418270,'2337','356',458738.33,458738.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','173631',3418271,'2338','357',1078614.19,1084468.55,5854.36,1229415.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','173631',3418272,'2339','357',2241361.05,2244816.40,3435.35,721423.50,0.00,0.00,20.00,0.00,0.00),('1','113','825','173631',3418273,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','173631',3418274,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173798',3421356,'2326','356',1180452.07,1182276.90,1824.83,293797.63,0.00,0.00,0.00,0.00,0.00),('1','113','823','173798',3421357,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173798',3421358,'2328','356',167714.36,169261.23,1546.87,249046.07,0.00,0.00,0.00,0.00,0.00),('1','113','823','173798',3421359,'2329','356',474627.36,474627.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173798',3421360,'2330','356',852099.48,853671.13,1571.65,253035.65,0.00,0.00,0.00,0.00,0.00),('1','113','823','173798',3421361,'2331','356',519276.26,519276.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173798',3421362,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173798',3421363,'2333','356',985085.43,986695.00,1609.57,259140.77,0.00,0.00,0.00,0.00,0.00),('1','113','823','173798',3421364,'2334','356',41165.25,42462.38,1297.13,208837.93,0.00,0.00,0.00,0.00,0.00),('1','113','823','173798',3421365,'2335','356',719037.73,719080.59,42.86,6900.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','173798',3421366,'2336','356',334223.66,335014.82,791.16,127376.76,0.00,0.00,0.00,0.00,0.00),('1','113','823','173798',3421367,'2337','356',458738.33,458738.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','173798',3421368,'2338','357',1084468.55,1085144.41,675.86,141930.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','173798',3421369,'2339','357',2244816.40,2246906.92,2090.52,439009.20,0.00,0.00,0.00,0.00,0.00),('1','113','825','173798',3421370,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','173798',3421371,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173800',3421388,'2326','356',1182276.90,1184417.82,2140.92,344688.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','173800',3421389,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173800',3421390,'2328','356',169261.23,171031.56,1770.33,285023.13,0.00,0.00,0.00,0.00,0.00),('1','113','823','173800',3421391,'2329','356',474627.36,475647.40,1000.04,161006.44,0.00,0.00,20.00,0.00,0.00),('1','113','823','173800',3421392,'2330','356',853671.13,855580.70,1909.57,307440.77,0.00,0.00,0.00,0.00,0.00),('1','113','823','173800',3421393,'2331','356',519276.26,519683.40,407.14,65549.54,0.00,0.00,0.00,0.00,0.00),('1','113','823','173800',3421394,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173800',3421395,'2333','356',986695.00,988452.63,1757.63,282978.43,0.00,0.00,0.00,0.00,0.00),('1','113','823','173800',3421396,'2334','356',42462.38,44852.51,2390.13,384810.93,0.00,0.00,0.00,0.00,0.00),('1','113','823','173800',3421397,'2335','356',719080.59,719080.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173800',3421398,'2336','356',335014.82,335241.01,226.19,36416.59,0.00,0.00,0.00,0.00,0.00),('1','113','823','173800',3421399,'2337','356',458738.33,458738.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','173800',3421400,'2338','357',1085144.41,1088833.23,3678.82,772552.20,0.00,0.00,10.00,0.00,0.00),('1','113','824','173800',3421401,'2339','357',2246906.92,2250977.14,4060.22,852646.20,0.00,0.00,10.00,0.00,0.00),('1','113','825','173800',3421402,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','173800',3421403,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173974',3424615,'2326','356',1184417.82,1185950.90,1533.08,246825.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','173974',3424616,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173974',3424617,'2328','356',171031.56,172527.39,1495.83,240828.63,0.00,0.00,0.00,0.00,0.00),('1','113','823','173974',3424618,'2329','356',475647.40,475647.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173974',3424619,'2330','356',855580.70,855580.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173974',3424620,'2331','356',519683.40,521271.12,1587.72,255622.92,0.00,0.00,0.00,0.00,0.00),('1','113','823','173974',3424621,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173974',3424622,'2333','356',988452.63,989903.22,1450.59,233544.99,0.00,0.00,0.00,0.00,0.00),('1','113','823','173974',3424623,'2334','356',44852.51,44852.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','173974',3424624,'2335','356',719080.59,720246.79,1166.20,187758.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','173974',3424625,'2336','356',335241.01,336128.75,887.74,142926.14,0.00,0.00,0.00,0.00,0.00),('1','113','823','173974',3424626,'2337','356',458738.33,458738.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','173974',3424627,'2338','357',1088833.23,1089234.17,400.94,84197.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','173974',3424628,'2339','357',2250977.14,2253302.35,2325.21,488294.10,0.00,0.00,0.00,0.00,0.00),('1','113','825','173974',3424629,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','173974',3424630,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174027',3425499,'2326','356',1185950.90,1188220.46,2269.56,365399.16,0.00,0.00,0.00,0.00,0.00),('1','113','823','174027',3425500,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174027',3425501,'2328','356',172527.39,172527.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174027',3425502,'2329','356',475647.40,477655.70,2008.30,323336.30,0.00,0.00,0.00,0.00,0.00),('1','113','823','174027',3425503,'2330','356',855580.70,855580.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174027',3425504,'2331','356',521271.12,523056.74,1785.62,287484.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','174027',3425505,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174027',3425506,'2333','356',989903.22,991559.16,1655.94,266606.34,0.00,0.00,0.00,0.00,0.00),('1','113','823','174027',3425507,'2334','356',44852.51,44852.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174027',3425508,'2335','356',720246.79,721869.89,1623.10,261319.10,0.00,0.00,0.00,0.00,0.00),('1','113','823','174027',3425509,'2336','356',336128.75,336128.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174027',3425510,'2337','356',458738.33,460448.20,1709.87,275289.07,0.00,0.00,0.00,0.00,0.00),('1','113','824','174027',3425511,'2338','357',1089234.17,1093542.34,4308.17,904715.70,0.00,0.00,0.00,0.00,0.00),('1','113','824','174027',3425512,'2339','357',2253302.35,2257806.69,4504.34,945911.40,0.00,0.00,0.00,0.00,0.00),('1','113','825','174027',3425513,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','174027',3425514,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174250',3429654,'2326','356',1188220.46,1189966.86,1726.40,277950.40,0.00,0.00,20.00,0.00,0.00),('1','113','823','174250',3429655,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174250',3429656,'2328','356',172527.39,173957.67,1430.28,230275.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','174250',3429657,'2329','356',477655.70,477655.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174250',3429658,'2330','356',855580.70,855580.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174250',3429659,'2331','356',523056.74,524705.61,1648.87,265468.07,0.00,0.00,0.00,0.00,0.00),('1','113','823','174250',3429660,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174250',3429661,'2333','356',991559.16,992939.40,1380.24,222218.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','174250',3429662,'2334','356',44852.51,44852.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174250',3429663,'2335','356',721869.89,723041.22,1171.33,188584.13,0.00,0.00,0.00,0.00,0.00),('1','113','823','174250',3429664,'2336','356',336128.75,337239.64,1110.89,178853.29,0.00,0.00,0.00,0.00,0.00),('1','113','823','174250',3429665,'2337','356',460448.20,460448.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','174250',3429666,'2338','357',1093542.34,1097216.39,3674.05,771550.50,0.00,0.00,0.00,0.00,0.00),('1','113','824','174250',3429667,'2339','357',2257806.69,2260298.88,2492.19,523359.90,0.00,0.00,0.00,0.00,0.00),('1','113','825','174250',3429668,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','174250',3429669,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174256',3429749,'2326','356',1189966.86,1192554.10,2587.24,416545.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','174256',3429750,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174256',3429751,'2328','356',173957.67,176292.78,2335.11,375952.71,0.00,0.00,0.00,0.00,0.00),('1','113','823','174256',3429752,'2329','356',477655.70,477655.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174256',3429753,'2330','356',855580.70,855580.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174256',3429754,'2331','356',524705.61,526860.75,2155.14,346977.54,0.00,0.00,0.00,0.00,0.00),('1','113','823','174256',3429755,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174256',3429756,'2333','356',992939.40,995043.89,2104.49,338822.89,0.00,0.00,0.00,0.00,0.00),('1','113','823','174256',3429757,'2334','356',44852.51,46180.20,1327.69,213758.09,0.00,0.00,0.00,0.00,0.00),('1','113','823','174256',3429758,'2335','356',723041.22,723041.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174256',3429759,'2336','356',337239.64,337239.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174256',3429760,'2337','356',460448.20,461875.69,1427.49,229825.89,0.00,0.00,0.00,0.00,0.00),('1','113','824','174256',3429761,'2338','357',1097216.39,1100556.81,3340.42,701488.20,0.00,0.00,0.00,0.00,0.00),('1','113','824','174256',3429762,'2339','357',2260298.88,2264437.14,4138.26,869034.60,0.00,0.00,0.00,0.00,0.00),('1','113','825','174256',3429763,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','174256',3429764,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174260',3429801,'2326','356',1192554.10,1194510.37,1956.27,314959.47,0.00,0.00,0.00,0.00,0.00),('1','113','823','174260',3429802,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174260',3429803,'2328','356',176292.78,178027.93,1735.15,279359.15,0.00,0.00,0.00,0.00,0.00),('1','113','823','174260',3429804,'2329','356',477655.70,477655.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174260',3429805,'2330','356',855580.70,857022.61,1441.91,232147.51,0.00,0.00,0.00,0.00,0.00),('1','113','823','174260',3429806,'2331','356',526860.75,526860.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174260',3429807,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174260',3429808,'2333','356',995043.89,996380.12,1336.23,215133.03,0.00,0.00,0.00,0.00,0.00),('1','113','823','174260',3429809,'2334','356',46180.20,46180.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174260',3429810,'2335','356',723041.22,724522.71,1481.49,238519.89,0.00,0.00,0.00,0.00,0.00),('1','113','823','174260',3429811,'2336','356',337239.64,338157.82,918.18,147826.98,0.00,0.00,0.00,0.00,0.00),('1','113','823','174260',3429812,'2337','356',461875.69,461875.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','174260',3429813,'2338','357',1100556.81,1101424.44,867.63,182202.30,0.00,0.00,0.00,0.00,0.00),('1','113','824','174260',3429814,'2339','357',2264437.14,2267831.10,3393.96,712731.60,0.00,0.00,0.00,0.00,0.00),('1','113','825','174260',3429815,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','174260',3429816,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174342',3431164,'2326','356',1194510.37,1196949.86,2439.49,392757.89,0.00,0.00,0.00,0.00,0.00),('1','113','823','174342',3431165,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174342',3431166,'2328','356',178027.93,178027.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174342',3431167,'2329','356',477655.70,480196.79,2521.09,405895.49,0.00,0.00,20.00,0.00,0.00),('1','113','823','174342',3431168,'2330','356',857022.61,857022.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174342',3431169,'2331','356',526860.75,529313.53,2452.78,394897.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','174342',3431170,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174342',3431171,'2333','356',996380.12,998163.60,1783.48,287140.28,0.00,0.00,0.00,0.00,0.00),('1','113','823','174342',3431172,'2334','356',46180.20,48127.64,1947.44,313537.84,0.00,0.00,0.00,0.00,0.00),('1','113','823','174342',3431173,'2335','356',724522.71,724522.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174342',3431174,'2336','356',338157.82,338157.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174342',3431175,'2337','356',461875.69,462541.41,665.72,107180.92,0.00,0.00,0.00,0.00,0.00),('1','113','824','174342',3431176,'2338','357',1101424.44,1104046.85,2622.41,550706.10,0.00,0.00,0.00,0.00,0.00),('1','113','824','174342',3431177,'2339','357',2267831.10,2271032.07,3200.97,672203.70,0.00,0.00,0.00,0.00,0.00),('1','113','825','174342',3431178,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','174342',3431179,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174343',3431180,'2326','356',1196949.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174343',3431181,'2327','356',512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174343',3431182,'2328','356',178027.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174343',3431183,'2329','356',480196.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174343',3431184,'2330','356',857022.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174343',3431185,'2331','356',529313.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174343',3431186,'2332','356',15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174343',3431187,'2333','356',998163.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174343',3431188,'2334','356',48127.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174343',3431189,'2335','356',724522.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174343',3431190,'2336','356',338157.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174343',3431191,'2337','356',462541.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','174343',3431192,'2338','357',1104046.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','174343',3431193,'2339','357',2271032.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','174343',3431194,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','174343',3431195,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174652',3436536,'2326','356',1196949.86,1198927.58,1977.72,316435.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','174652',3436537,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174652',3436538,'2328','356',178027.93,179423.72,1395.79,223326.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','174652',3436539,'2329','356',480196.79,480196.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174652',3436540,'2330','356',857022.61,857022.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174652',3436541,'2331','356',529313.53,530794.87,1481.34,237014.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','174652',3436542,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174652',3436543,'2333','356',998163.60,999327.24,1163.64,186182.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','174652',3436544,'2334','356',48127.64,49061.61,933.97,149435.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','174652',3436545,'2335','356',724522.71,724522.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174652',3436546,'2336','356',338157.82,338923.57,765.75,122520.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174652',3436547,'2337','356',462541.41,462541.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','174652',3436548,'2338','357',1104046.85,1107655.93,3609.08,757906.80,0.00,0.00,0.00,0.00,0.00),('1','113','824','174652',3436549,'2339','357',2271032.07,2274683.05,3650.98,766705.80,0.00,0.00,0.00,0.00,0.00),('1','113','825','174652',3436550,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','174652',3436551,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174728',3437842,'2326','356',1198927.58,1201660.44,2732.86,437257.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','174728',3437843,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174728',3437844,'2328','356',179423.72,179423.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174728',3437845,'2329','356',480196.79,482412.17,2215.38,354460.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','174728',3437846,'2330','356',857022.61,859405.89,2383.28,381324.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','174728',3437847,'2331','356',530794.87,530794.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174728',3437848,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174728',3437849,'2333','356',999327.24,1001154.11,1826.87,292299.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','174728',3437850,'2334','356',49061.61,50828.07,1766.46,282633.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','174728',3437851,'2335','356',724522.71,724522.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174728',3437852,'2336','356',338923.57,338923.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174728',3437853,'2337','356',462541.41,464037.59,1496.18,239388.80,0.00,0.00,0.00,0.00,0.00),('1','113','824','174728',3437854,'2338','357',1107655.93,1109975.09,2319.16,487023.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','174728',3437855,'2339','357',2274683.05,2277462.32,2779.27,583646.70,0.00,0.00,0.00,0.00,0.00),('1','113','825','174728',3437856,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','174728',3437857,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174731',3437918,'2326','356',1201660.44,1203107.07,1446.63,231460.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','174731',3437919,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174731',3437920,'2328','356',179423.72,181115.98,1692.26,270761.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','174731',3437921,'2329','356',482412.17,482412.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174731',3437922,'2330','356',859405.89,859405.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174731',3437923,'2331','356',530794.87,532193.95,1399.08,223852.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','174731',3437924,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174731',3437925,'2333','356',1001154.11,1002178.27,1024.16,163865.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','174731',3437926,'2334','356',50828.07,51638.30,810.23,129636.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','174731',3437927,'2335','356',724522.71,724522.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174731',3437928,'2336','356',338923.57,339741.86,818.29,130926.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','174731',3437929,'2337','356',464037.59,464037.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','174731',3437930,'2338','357',1109975.09,1111344.14,1369.05,287500.50,0.00,0.00,0.00,0.00,0.00),('1','113','824','174731',3437931,'2339','357',2277462.32,2280974.47,3512.15,737551.50,0.00,0.00,0.00,0.00,0.00),('1','113','825','174731',3437932,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','174731',3437933,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174739',3438102,'2326','356',1203107.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174739',3438103,'2327','356',512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174739',3438104,'2328','356',181115.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174739',3438105,'2329','356',482412.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174739',3438106,'2330','356',859405.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174739',3438107,'2331','356',532193.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174739',3438108,'2332','356',15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174739',3438109,'2333','356',1002178.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174739',3438110,'2334','356',51638.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174739',3438111,'2335','356',724522.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174739',3438112,'2336','356',339741.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174739',3438113,'2337','356',464037.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','174739',3438114,'2338','357',1111344.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','174739',3438115,'2339','357',2280974.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','174739',3438116,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','174739',3438117,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174820',3439737,'2326','356',1203107.07,1204920.40,1813.33,290132.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','174820',3439738,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174820',3439739,'2328','356',181115.98,181115.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174820',3439740,'2329','356',482412.17,484207.17,1795.00,287200.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174820',3439741,'2330','356',859405.89,861390.27,1984.38,317500.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','174820',3439742,'2331','356',532193.95,532193.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174820',3439743,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174820',3439744,'2333','356',1002178.27,1003460.58,1282.31,205169.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','174820',3439745,'2334','356',51638.30,51638.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174820',3439746,'2335','356',0.00,1305.73,1305.73,208916.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','174820',3439747,'2336','356',339741.86,339741.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174820',3439748,'2337','356',464037.59,465247.18,1209.59,193534.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','174820',3439749,'2338','357',1111344.14,1111838.82,494.68,103882.80,0.00,0.00,0.00,0.00,0.00),('1','113','824','174820',3439750,'2339','357',2280974.47,2284967.76,3993.29,838590.90,0.00,0.00,0.00,0.00,0.00),('1','113','825','174820',3439751,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','174820',3439752,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174825',3439848,'2326','356',1204920.40,1207189.81,2269.41,363105.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','174825',3439849,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174825',3439850,'2328','356',181115.98,181115.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174825',3439851,'2329','356',484207.17,485876.74,1669.57,267131.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','174825',3439852,'2330','356',861390.27,861390.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174825',3439853,'2331','356',532193.95,532412.82,218.87,35019.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','174825',3439854,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174825',3439855,'2333','356',1003460.58,1004498.69,1038.11,166097.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','174825',3439856,'2334','356',51638.30,51638.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174825',3439857,'2335','356',1305.73,3053.61,1747.88,279660.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','174825',3439858,'2336','356',339741.86,339741.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174825',3439859,'2337','356',465247.18,466818.62,1571.44,251430.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','174825',3439860,'2338','357',1111838.82,1114256.36,2417.54,507683.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','174825',3439861,'2339','357',2284967.76,2286152.46,1184.70,248787.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','174825',3439862,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','174825',3439863,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174852',3440275,'2326','356',1207189.81,1209100.82,1911.01,305761.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','174852',3440276,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174852',3440277,'2328','356',181115.98,183006.48,1890.50,302480.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174852',3440278,'2329','356',485876.74,485876.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174852',3440279,'2330','356',861390.27,861390.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174852',3440280,'2331','356',532412.82,534385.88,1973.06,315689.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','174852',3440281,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174852',3440282,'2333','356',1004498.69,1006318.78,1820.09,291214.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','174852',3440283,'2334','356',51638.30,51638.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174852',3440284,'2335','356',3053.61,4626.26,1572.65,251624.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174852',3440285,'2336','356',339741.86,339741.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','174852',3440286,'2337','356',466818.62,468317.38,1498.76,239801.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','174852',3440287,'2338','357',1114256.36,1117519.27,3262.91,685211.10,0.00,0.00,0.00,0.00,0.00),('1','113','824','174852',3440288,'2339','357',2286152.46,2289889.94,3737.48,784870.80,0.00,0.00,0.00,0.00,0.00),('1','113','825','174852',3440289,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','174852',3440290,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175082',3444521,'2326','356',1209100.82,1211337.16,2236.34,357814.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','175082',3444522,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175082',3444523,'2328','356',183006.48,184845.55,1839.07,294251.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','175082',3444524,'2329','356',485876.74,485876.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175082',3444525,'2330','356',861390.27,862816.91,1426.64,228262.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','175082',3444526,'2331','356',534385.88,534385.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175082',3444527,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175082',3444528,'2333','356',1006318.78,1006318.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175082',3444529,'2334','356',51638.30,51638.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175082',3444530,'2335','356',4626.26,6159.24,1532.98,245276.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','175082',3444531,'2336','356',339741.86,340919.30,1177.44,188390.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','175082',3444532,'2337','356',468317.38,468317.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','175082',3444533,'2338','357',1117519.27,1118336.77,817.50,171675.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','175082',3444534,'2339','357',2289889.94,2292419.99,2530.05,531310.50,0.00,0.00,0.00,0.00,0.00),('1','113','825','175082',3444535,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','175082',3444536,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175084',3444560,'2326','356',1211337.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175084',3444561,'2327','356',512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175084',3444562,'2328','356',184845.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175084',3444563,'2329','356',485876.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175084',3444564,'2330','356',862816.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175084',3444565,'2331','356',534385.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175084',3444566,'2332','356',15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175084',3444567,'2333','356',1006318.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175084',3444568,'2334','356',51638.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175084',3444569,'2335','356',6159.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175084',3444570,'2336','356',340919.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175084',3444571,'2337','356',468317.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','175084',3444572,'2338','357',1118336.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','175084',3444573,'2339','357',2292419.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','175084',3444574,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','175084',3444575,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175088',3444649,'2326','356',1211337.16,1213341.29,2004.13,320660.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','175088',3444650,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175088',3444651,'2328','356',184845.55,186803.89,1958.34,313334.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','175088',3444652,'2329','356',485876.74,485876.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175088',3444653,'2330','356',862816.91,862816.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175088',3444654,'2331','356',534385.88,536377.96,1992.08,318732.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','175088',3444655,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175088',3444656,'2333','356',1006318.78,1008082.44,1763.66,282185.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','175088',3444657,'2334','356',51638.30,51638.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175088',3444658,'2335','356',6159.24,7690.51,1531.27,245003.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','175088',3444659,'2336','356',340919.30,341931.37,1012.07,161931.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','175088',3444660,'2337','356',468317.38,468317.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','175088',3444661,'2338','357',1118336.77,1121442.31,3105.54,667691.10,0.00,0.00,0.00,0.00,0.00),('1','113','824','175088',3444662,'2339','357',2292419.99,2295014.31,2594.32,557778.80,0.00,0.00,0.00,0.00,0.00),('1','113','825','175088',3444663,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','175088',3444664,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175230',3447391,'2326','356',1213341.29,1215473.79,2132.50,341200.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175230',3447392,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175230',3447393,'2328','356',186803.89,186803.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175230',3447394,'2329','356',485876.74,487652.20,1775.46,284073.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','175230',3447395,'2330','356',862816.91,862816.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175230',3447396,'2331','356',536377.96,538143.60,1765.64,282502.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','175230',3447397,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175230',3447398,'2333','356',1008082.44,1009282.19,1199.75,191960.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175230',3447399,'2334','356',51638.30,53262.87,1624.57,259931.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','175230',3447400,'2335','356',7690.51,7690.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175230',3447401,'2336','356',341931.37,341931.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175230',3447402,'2337','356',468317.38,468317.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','175230',3447403,'2338','357',1121442.31,1122788.37,1346.06,289402.90,0.00,0.00,0.00,0.00,0.00),('1','113','824','175230',3447404,'2339','357',2295014.31,2297763.98,2749.67,591179.05,0.00,0.00,0.00,0.00,0.00),('1','113','825','175230',3447405,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','175230',3447406,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175275',3448033,'2326','356',1215473.79,1217421.38,1947.59,311614.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','175275',3448034,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175275',3448035,'2328','356',186803.89,188883.23,2079.34,332694.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','175275',3448036,'2329','356',487652.20,487652.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175275',3448037,'2330','356',862816.91,862816.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175275',3448038,'2331','356',538143.60,540327.16,2183.56,349369.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','175275',3448039,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175275',3448040,'2333','356',1009282.19,1011381.57,2099.38,335900.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','175275',3448041,'2334','356',53262.87,53262.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175275',3448042,'2335','356',7690.51,9586.11,1895.60,303296.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175275',3448043,'2336','356',341931.37,343207.65,1276.28,204204.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','175275',3448044,'2337','356',468317.38,468317.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','175275',3448045,'2338','357',1122788.37,1125762.62,2974.25,639463.75,0.00,0.00,0.00,0.00,0.00),('1','113','824','175275',3448046,'2339','357',2297763.98,2301464.50,3700.52,795611.80,0.00,0.00,0.00,0.00,0.00),('1','113','825','175275',3448047,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','175275',3448048,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175441',3451111,'2326','356',1217421.38,1219045.13,1623.75,259800.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175441',3451112,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175441',3451113,'2328','356',188883.23,190722.22,1838.99,294238.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','175441',3451114,'2329','356',487652.20,487652.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175441',3451115,'2330','356',862816.91,862816.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175441',3451116,'2331','356',540327.16,541893.76,1566.60,250656.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175441',3451117,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175441',3451118,'2333','356',1011381.57,1012690.50,1308.93,209428.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','175441',3451119,'2334','356',53262.87,54295.70,1032.83,165252.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','175441',3451120,'2335','356',9586.11,9586.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175441',3451121,'2336','356',343207.65,343207.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175441',3451122,'2337','356',468317.38,469292.21,974.83,155972.80,0.00,0.00,0.00,0.00,0.00),('1','113','824','175441',3451123,'2338','357',1125762.62,1127635.15,1872.53,402593.95,0.00,0.00,0.00,0.00,0.00),('1','113','824','175441',3451124,'2339','357',2301464.50,2303593.81,2129.31,457801.65,0.00,0.00,0.00,0.00,0.00),('1','113','825','175441',3451125,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','175441',3451126,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175446',3451203,'2326','356',1219045.13,1221181.28,2136.15,341784.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175446',3451204,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175446',3451205,'2328','356',190722.22,192674.16,1951.94,312310.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','175446',3451206,'2329','356',487652.20,487652.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175446',3451207,'2330','356',862816.91,862816.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175446',3451208,'2331','356',541893.76,544079.25,2185.49,349678.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','175446',3451209,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175446',3451210,'2333','356',1012690.50,1013480.31,789.81,126369.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','175446',3451211,'2334','356',54295.70,54295.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175446',3451212,'2335','356',9586.11,11481.84,1895.73,303316.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','175446',3451213,'2336','356',343207.65,345051.83,1844.18,295068.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','175446',3451214,'2337','356',469292.21,469292.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','175446',3451215,'2338','357',1127635.15,1128263.87,618.72,133024.80,0.00,0.00,10.00,0.00,0.00),('1','113','824','175446',3451216,'2339','357',2303593.81,2305797.66,2193.85,471677.75,0.00,0.00,10.00,0.00,0.00),('1','113','825','175446',3451217,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','175446',3451218,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175612',3454198,'2326','356',1221181.28,1223097.09,1905.81,304929.60,0.00,0.00,10.00,0.00,0.00),('1','113','823','175612',3454199,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175612',3454200,'2328','356',192674.16,194066.80,1392.64,222822.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','175612',3454201,'2329','356',487652.20,488974.50,1322.30,211568.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175612',3454202,'2330','356',862816.91,862816.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175612',3454203,'2331','356',544079.25,545399.56,1320.31,211249.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','175612',3454204,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175612',3454205,'2333','356',1013480.31,1014826.87,1346.56,215449.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','175612',3454206,'2334','356',54295.70,54295.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175612',3454207,'2335','356',11481.84,12538.63,1056.79,169086.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','175612',3454208,'2336','356',345051.83,345051.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175612',3454209,'2337','356',469292.21,470064.65,772.44,123590.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','175612',3454210,'2338','357',1128263.87,1128263.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','175612',3454211,'2339','357',2305797.66,2305797.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','175612',3454212,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','175612',3454213,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175613',3454214,'2326','356',1223097.09,1225831.03,2733.94,437430.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','175613',3454215,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175613',3454216,'2328','356',194066.80,195577.31,1510.51,241681.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','175613',3454217,'2329','356',488974.50,489818.82,844.32,135091.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','175613',3454218,'2330','356',862816.91,865428.59,2611.68,417868.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','175613',3454219,'2331','356',545399.56,545399.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175613',3454220,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175613',3454221,'2333','356',1014826.87,1017115.73,2288.86,366217.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','175613',3454222,'2334','356',54295.70,54295.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175613',3454223,'2335','356',12538.63,14417.76,1879.13,300660.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','175613',3454224,'2336','356',345051.83,346866.31,1814.48,290316.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','175613',3454225,'2337','356',470064.65,470064.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','175613',3454226,'2338','357',1128263.87,1128263.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','175613',3454227,'2339','357',2305797.66,2305797.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','175613',3454228,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','175613',3454229,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175827',3458140,'2326','356',1225831.03,1227744.37,1913.34,306134.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','175827',3458141,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175827',3458142,'2328','356',195577.31,197295.98,1718.67,274987.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','175827',3458143,'2329','356',489818.82,489818.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175827',3458144,'2330','356',865428.59,865428.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175827',3458145,'2331','356',545399.56,547020.72,1621.16,259385.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','175827',3458146,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175827',3458147,'2333','356',1017115.73,1018626.40,1510.67,241707.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','175827',3458148,'2334','356',54295.70,54295.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175827',3458149,'2335','356',14417.76,15644.66,1226.90,196304.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','175827',3458150,'2336','356',346866.31,347140.25,273.94,43830.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','175827',3458151,'2337','356',470064.65,470070.28,5.63,900.80,0.00,0.00,0.00,0.00,0.00),('1','113','824','175827',3458152,'2338','357',1128263.87,1128263.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','175827',3458153,'2339','357',2305797.66,2305797.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','175827',3458154,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','175827',3458155,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176022',3461663,'2326','356',1227744.37,1230760.45,3016.08,482572.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','176022',3461664,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176022',3461665,'2328','356',197295.98,199781.69,2485.71,397713.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','176022',3461666,'2329','356',489818.82,489818.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176022',3461667,'2330','356',865428.59,865428.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176022',3461668,'2331','356',547020.72,547524.64,483.92,77427.20,0.00,0.00,20.00,0.00,0.00),('1','113','823','176022',3461669,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176022',3461670,'2333','356',1018626.40,1020764.93,2138.53,342164.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','176022',3461671,'2334','356',54295.70,54295.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176022',3461672,'2335','356',15644.66,17602.05,1957.39,313182.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','176022',3461673,'2336','356',347140.25,349087.97,1947.72,311635.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','176022',3461674,'2337','356',470070.28,470070.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','176022',3461675,'2338','357',1128263.87,1130828.33,2564.46,551358.90,0.00,0.00,0.00,0.00,0.00),('1','113','824','176022',3461676,'2339','357',2305797.66,2308279.75,2482.09,533649.35,0.00,0.00,0.00,0.00,0.00),('1','113','825','176022',3461677,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','176022',3461678,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176026',3461747,'2326','356',1230760.45,1232368.18,1607.73,257236.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','176026',3461748,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176026',3461749,'2328','356',199781.69,201887.28,2105.59,336894.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','176026',3461750,'2329','356',489818.82,489818.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176026',3461751,'2330','356',865428.59,866641.24,1212.65,194024.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176026',3461752,'2331','356',547524.64,547524.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176026',3461753,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176026',3461754,'2333','356',1020764.93,1021959.20,1194.27,191083.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','176026',3461755,'2334','356',54295.70,54295.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176026',3461756,'2335','356',17602.05,18667.65,1065.60,170496.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176026',3461757,'2336','356',349087.97,349087.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176026',3461758,'2337','356',470070.28,470935.57,865.29,138446.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','176026',3461759,'2338','357',1130828.33,1130966.47,138.14,29700.10,0.00,0.00,0.00,0.00,0.00),('1','113','824','176026',3461760,'2339','357',2308279.75,2309896.30,1616.55,347558.25,0.00,0.00,0.00,0.00,0.00),('1','113','825','176026',3461761,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','176026',3461762,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176031',3461840,'2326','356',1232368.18,1232368.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176031',3461841,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176031',3461842,'2328','356',201887.28,204434.54,2547.26,407561.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','176031',3461843,'2329','356',489818.82,489818.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176031',3461844,'2330','356',866641.24,866641.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176031',3461845,'2331','356',547524.64,549945.42,2420.78,387324.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','176031',3461846,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176031',3461847,'2333','356',1021959.20,1023872.02,1912.82,306051.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','176031',3461848,'2334','356',54295.70,55887.66,1591.96,254713.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','176031',3461849,'2335','356',18667.65,18667.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176031',3461850,'2336','356',349087.97,350828.73,1730.76,276921.60,0.00,0.00,10.00,0.00,0.00),('1','113','823','176031',3461851,'2337','356',470935.57,470935.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','176031',3461852,'2338','357',1130966.47,1132578.70,1612.23,346629.45,0.00,0.00,0.00,0.00,0.00),('1','113','824','176031',3461853,'2339','357',2309896.30,2310559.79,663.49,142650.35,0.00,0.00,0.00,0.00,0.00),('1','113','825','176031',3461854,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','176031',3461855,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176174',3464275,'2326','356',1232368.18,1233996.02,1627.84,260454.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','176174',3464276,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176174',3464277,'2328','356',204434.54,204434.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176174',3464278,'2329','356',489818.82,490796.89,978.07,156491.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','176174',3464279,'2330','356',866641.24,866641.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176174',3464280,'2331','356',549945.42,551601.39,1655.97,264955.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','176174',3464281,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176174',3464282,'2333','356',1023872.02,1025684.93,1802.91,288465.60,0.00,0.00,10.00,0.00,0.00),('1','113','823','176174',3464283,'2334','356',55887.66,55887.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176174',3464284,'2335','356',18667.65,19834.63,1166.98,186716.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','176174',3464285,'2336','356',350828.73,350828.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176174',3464286,'2337','356',470935.57,472086.49,1150.92,184147.20,0.00,0.00,0.00,0.00,0.00),('1','113','824','176174',3464287,'2338','357',1132578.70,1134424.19,1845.49,396780.35,0.00,0.00,0.00,0.00,0.00),('1','113','824','176174',3464288,'2339','357',2310559.79,2313111.96,2552.17,548716.55,0.00,0.00,0.00,0.00,0.00),('1','113','825','176174',3464289,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','176174',3464290,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176337',3467421,'2326','356',1233996.02,1236434.11,2438.09,390094.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','176337',3467422,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176337',3467423,'2328','356',204434.54,206032.69,1598.15,255704.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176337',3467424,'2329','356',490796.89,490796.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176337',3467425,'2330','356',866641.24,868793.86,2152.62,344419.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','176337',3467426,'2331','356',551601.39,551601.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176337',3467427,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176337',3467428,'2333','356',1025684.93,1028026.24,2341.31,374609.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','176337',3467429,'2334','356',55887.66,55887.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176337',3467430,'2335','356',19834.63,21870.59,2035.96,325753.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','176337',3467431,'2336','356',350828.73,352661.45,1832.72,293235.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','176337',3467432,'2337','356',472086.49,472086.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','176337',3467433,'2338','357',1134424.19,1136961.29,2537.10,545476.50,0.00,0.00,0.00,0.00,0.00),('1','113','824','176337',3467434,'2339','357',2313111.96,2315051.89,1939.93,417084.95,0.00,0.00,0.00,0.00,0.00),('1','113','825','176337',3467435,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','176337',3467436,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176338',3467437,'2326','356',1236434.11,1238417.23,1983.12,317299.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','176338',3467438,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176338',3467439,'2328','356',206032.69,208355.34,2322.65,371624.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176338',3467440,'2329','356',490796.89,490796.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176338',3467441,'2330','356',868793.86,870740.11,1946.25,311400.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176338',3467442,'2331','356',551601.39,551601.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176338',3467443,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176338',3467444,'2333','356',1028026.24,1028026.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176338',3467445,'2334','356',55887.66,56949.63,1061.97,169915.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','176338',3467446,'2335','356',21870.59,21870.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176338',3467447,'2336','356',352661.45,353627.58,966.13,154580.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','176338',3467448,'2337','356',472086.49,472086.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','176338',3467449,'2338','357',1136961.29,1137856.83,895.54,192541.10,0.00,0.00,0.00,0.00,0.00),('1','113','824','176338',3467450,'2339','357',2315051.89,2316011.30,959.41,206273.15,0.00,0.00,0.00,0.00,0.00),('1','113','825','176338',3467451,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','176338',3467452,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176340',3467476,'2326','356',1238417.23,1240844.62,2427.39,388382.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','176340',3467477,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176340',3467478,'2328','356',208355.34,210491.47,2136.13,341780.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','176340',3467479,'2329','356',490796.89,490796.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176340',3467480,'2330','356',870740.11,870740.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176340',3467481,'2331','356',551601.39,552491.07,889.68,142348.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','176340',3467482,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176340',3467483,'2333','356',1028026.24,1030092.22,2065.98,330556.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','176340',3467484,'2334','356',56949.63,58870.59,1920.96,307353.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','176340',3467485,'2335','356',21870.59,21870.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176340',3467486,'2336','356',353627.58,355343.55,1715.97,274555.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','176340',3467487,'2337','356',472086.49,472086.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','176340',3467488,'2338','357',1137856.83,1140570.74,2713.91,583490.65,0.00,0.00,0.00,0.00,0.00),('1','113','824','176340',3467489,'2339','357',2316011.30,2317566.43,1555.13,334352.95,0.00,0.00,0.00,0.00,0.00),('1','113','825','176340',3467490,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','176340',3467491,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176342',3467514,'2326','356',1240844.62,1242407.82,1563.20,250112.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176342',3467515,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176342',3467516,'2328','356',210491.47,212311.47,1820.00,291200.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176342',3467517,'2329','356',490796.89,490796.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176342',3467518,'2330','356',870740.11,871762.81,1022.70,163632.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176342',3467519,'2331','356',552491.07,552491.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176342',3467520,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176342',3467521,'2333','356',1030092.22,1031838.73,1746.51,279441.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','176342',3467522,'2334','356',58870.59,58870.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176342',3467523,'2335','356',21870.59,21870.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176342',3467524,'2336','356',355343.55,356879.14,1535.59,245694.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','176342',3467525,'2337','356',472086.49,472086.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','176342',3467526,'2338','357',1140570.74,1141666.10,1095.36,235502.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','176342',3467527,'2339','357',2317566.43,2318958.98,1392.55,299398.25,0.00,0.00,0.00,0.00,0.00),('1','113','825','176342',3467528,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','176342',3467529,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176560',3471661,'2326','356',1242407.82,1244833.72,2425.90,388144.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176560',3471662,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176560',3471663,'2328','356',212311.47,212923.16,611.69,97870.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','176560',3471664,'2329','356',490796.89,492589.18,1792.29,286766.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','176560',3471665,'2330','356',871762.81,873718.28,1955.47,312875.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','176560',3471666,'2331','356',552491.07,552491.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176560',3471667,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176560',3471668,'2333','356',1031838.73,1033201.63,1362.90,218064.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176560',3471669,'2334','356',58870.59,58870.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176560',3471670,'2335','356',21870.59,23402.67,1532.08,245132.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','176560',3471671,'2336','356',356879.14,358548.36,1669.22,267075.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','176560',3471672,'2337','356',472086.49,472086.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','176560',3471673,'2338','357',1141666.10,1144726.00,3059.90,657878.50,0.00,0.00,0.00,0.00,0.00),('1','113','824','176560',3471674,'2339','357',2318958.98,2324338.67,5379.69,1156633.35,0.00,0.00,0.00,0.00,0.00),('1','113','825','176560',3471675,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','176560',3471676,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176937',3478721,'2326','356',1244833.72,1246982.17,2148.45,343752.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176937',3478722,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176937',3478723,'2328','356',212923.16,214738.33,1805.17,288827.20,0.00,0.00,10.00,0.00,0.00),('1','113','823','176937',3478724,'2329','356',492589.18,492589.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176937',3478725,'2330','356',873718.28,873718.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176937',3478726,'2331','356',552491.07,554714.68,2223.61,355777.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','176937',3478727,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176937',3478728,'2333','356',1033201.63,1033201.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176937',3478729,'2334','356',58870.59,58870.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176937',3478730,'2335','356',23402.67,25147.04,1744.37,279099.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','176937',3478731,'2336','356',358548.36,359439.31,890.95,142552.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176937',3478732,'2337','356',472086.49,472086.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','176937',3478733,'2338','357',1144726.00,1147976.04,3250.04,698758.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','176937',3478734,'2339','357',2324338.67,2326911.47,2572.80,553152.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','176937',3478735,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','176937',3478736,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176940',3478780,'2326','356',1246982.17,1249432.93,2450.76,392121.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','176940',3478781,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176940',3478782,'2328','356',214738.33,217269.40,2531.07,404971.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','176940',3478783,'2329','356',492589.18,492589.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176940',3478784,'2330','356',873718.28,874359.16,640.88,102540.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','176940',3478785,'2331','356',554714.68,556465.88,1751.20,280192.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176940',3478786,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176940',3478787,'2333','356',1033201.63,1034854.48,1652.85,264456.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176940',3478788,'2334','356',58870.59,60068.19,1197.60,191616.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176940',3478789,'2335','356',25147.04,25147.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176940',3478790,'2336','356',359439.31,359439.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176940',3478791,'2337','356',472086.49,473610.20,1523.71,243793.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','176940',3478792,'2338','357',1147976.04,1149687.03,1710.99,367862.85,0.00,0.00,0.00,0.00,0.00),('1','113','824','176940',3478793,'2339','357',2326911.47,2329348.94,2437.47,524056.05,0.00,0.00,0.00,0.00,0.00),('1','113','825','176940',3478794,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','176940',3478795,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176992',3479451,'2326','356',1249432.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176992',3479452,'2327','356',512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176992',3479453,'2328','356',217269.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176992',3479454,'2329','356',492589.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176992',3479455,'2330','356',874359.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176992',3479456,'2331','356',556465.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176992',3479457,'2332','356',15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176992',3479458,'2333','356',1034854.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176992',3479459,'2334','356',60068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176992',3479460,'2335','356',25147.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176992',3479461,'2336','356',359439.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176992',3479462,'2337','356',473610.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','176992',3479463,'2338','357',1149687.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','176992',3479464,'2339','357',2329348.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','176992',3479465,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','176992',3479466,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176993',3479467,'2326','356',1249432.93,1251334.17,1901.24,304198.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','176993',3479468,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176993',3479469,'2328','356',217269.40,218622.93,1353.53,216564.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','176993',3479470,'2329','356',492589.18,492589.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176993',3479471,'2330','356',874359.16,876227.24,1868.08,298892.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','176993',3479472,'2331','356',556465.88,556465.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176993',3479473,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176993',3479474,'2333','356',1034854.48,1036471.10,1616.62,258659.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','176993',3479475,'2334','356',60068.19,60068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176993',3479476,'2335','356',25147.04,26646.64,1499.60,239936.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176993',3479477,'2336','356',359439.31,359439.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176993',3479478,'2337','356',473610.20,473610.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','176993',3479479,'2338','357',1149687.03,1154510.71,4823.68,1061209.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','176993',3479480,'2339','357',2329348.94,2332878.17,3529.23,776430.60,0.00,0.00,0.00,0.00,0.00),('1','113','825','176993',3479481,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','176993',3479482,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176994',3479483,'2326','356',1251334.17,1253946.89,2612.72,418035.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','176994',3479484,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176994',3479485,'2328','356',218622.93,220320.28,1697.35,271576.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176994',3479486,'2329','356',492589.18,493060.55,471.37,75419.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','176994',3479487,'2330','356',876227.24,876227.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176994',3479488,'2331','356',556465.88,559087.06,2621.18,419388.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','176994',3479489,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176994',3479490,'2333','356',1036471.10,1038593.95,2122.85,339656.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176994',3479491,'2334','356',60068.19,60068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176994',3479492,'2335','356',26646.64,28148.95,1502.31,240369.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','176994',3479493,'2336','356',359439.31,359439.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','176994',3479494,'2337','356',473610.20,474766.73,1156.53,185044.80,0.00,0.00,0.00,0.00,0.00),('1','113','824','176994',3479495,'2338','357',1154510.71,1158455.36,3944.65,867823.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','176994',3479496,'2339','357',2332878.17,2337248.62,4370.45,961499.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','176994',3479497,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','176994',3479498,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177624',3492284,'2326','356',1253946.89,1256328.40,2381.51,381041.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','177624',3492285,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177624',3492286,'2328','356',220320.28,222632.69,2312.41,369985.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','177624',3492287,'2329','356',493060.55,493060.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177624',3492288,'2330','356',876227.24,876227.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177624',3492289,'2331','356',559087.06,561298.33,2211.27,353803.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','177624',3492290,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177624',3492291,'2333','356',1038593.95,1039964.84,1370.89,219342.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','177624',3492292,'2334','356',60068.19,60068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177624',3492293,'2335','356',28148.95,28148.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177624',3492294,'2336','356',359439.31,359439.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177624',3492295,'2337','356',474766.73,474766.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','177624',3492296,'2338','357',1158455.36,1159087.93,622.57,136965.40,0.00,0.00,10.00,0.00,0.00),('1','113','824','177624',3492297,'2339','357',2337248.62,2340568.15,3309.53,728096.60,0.00,0.00,10.00,0.00,0.00),('1','113','825','177624',3492298,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','177624',3492299,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177625',3492300,'2326','356',1256328.40,1258910.40,2582.00,413120.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177625',3492301,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177625',3492302,'2328','356',222632.69,225209.55,2566.86,410697.60,0.00,0.00,10.00,0.00,0.00),('1','113','823','177625',3492303,'2329','356',493060.55,493060.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177625',3492304,'2330','356',876227.24,878202.86,1965.62,314499.20,0.00,0.00,10.00,0.00,0.00),('1','113','823','177625',3492305,'2331','356',561298.33,561950.45,652.12,104339.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','177625',3492306,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177625',3492307,'2333','356',1039964.84,1042089.37,2124.53,339924.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','177625',3492308,'2334','356',60068.19,60068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177625',3492309,'2335','356',28148.95,29763.67,1614.72,258355.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','177625',3492310,'2336','356',359439.31,359439.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177625',3492311,'2337','356',474766.73,475931.01,1164.28,186284.80,0.00,0.00,0.00,0.00,0.00),('1','113','824','177625',3492312,'2338','357',1159087.93,1161074.89,1986.96,437131.20,0.00,0.00,0.00,0.00,0.00),('1','113','824','177625',3492313,'2339','357',2340568.15,2342669.37,2101.22,462268.40,0.00,0.00,0.00,0.00,0.00),('1','113','825','177625',3492314,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','177625',3492315,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177626',3492316,'2326','356',1258910.40,1260992.94,2072.54,331606.40,0.00,0.00,10.00,0.00,0.00),('1','113','823','177626',3492317,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177626',3492318,'2328','356',225209.55,227676.37,2456.82,393091.20,0.00,0.00,10.00,0.00,0.00),('1','113','823','177626',3492319,'2329','356',493060.55,493060.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177626',3492320,'2330','356',878202.86,880738.11,2525.25,404040.00,0.00,0.00,10.00,0.00,0.00),('1','113','823','177626',3492321,'2331','356',561950.45,561950.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177626',3492322,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177626',3492323,'2333','356',1042089.37,1044089.39,1990.02,318403.20,0.00,0.00,10.00,0.00,0.00),('1','113','823','177626',3492324,'2334','356',60068.19,60068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177626',3492325,'2335','356',29763.67,29763.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177626',3492326,'2336','356',359439.31,359439.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177626',3492327,'2337','356',475931.01,475931.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','177626',3492328,'2338','357',1161074.89,1162556.10,1471.21,323666.20,0.00,0.00,10.00,0.00,0.00),('1','113','824','177626',3492329,'2339','357',2342669.37,2344442.59,1763.22,387908.40,0.00,0.00,10.00,0.00,0.00),('1','113','825','177626',3492330,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','177626',3492331,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177627',3492332,'2326','356',1260992.94,1263337.65,2344.71,375153.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','177627',3492333,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177627',3492334,'2328','356',227676.37,230010.57,2334.20,373472.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177627',3492335,'2329','356',493060.55,493060.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177627',3492336,'2330','356',880738.11,882845.09,2106.98,337116.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','177627',3492337,'2331','356',561950.45,561950.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177627',3492338,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177627',3492339,'2333','356',1044089.39,1045524.33,1434.94,229590.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','177627',3492340,'2334','356',60068.19,60068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177627',3492341,'2335','356',29763.67,31324.35,1560.68,249708.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','177627',3492342,'2336','356',359439.31,359439.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177627',3492343,'2337','356',475931.01,476960.77,1029.76,164761.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','177627',3492344,'2338','357',1162556.10,1163162.56,606.46,133421.20,0.00,0.00,0.00,0.00,0.00),('1','113','824','177627',3492345,'2339','357',2344442.59,2346824.43,2381.84,524004.80,0.00,0.00,0.00,0.00,0.00),('1','113','825','177627',3492346,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','177627',3492347,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177628',3492348,'2326','356',1263337.65,1265492.43,2154.78,344764.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','177628',3492349,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177628',3492350,'2328','356',230010.57,230010.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177628',3492351,'2329','356',493060.55,495029.36,1968.81,315009.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','177628',3492352,'2330','356',882845.09,882845.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177628',3492353,'2331','356',561950.45,561950.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177628',3492354,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177628',3492355,'2333','356',1045524.33,1047511.58,1987.25,317960.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177628',3492356,'2334','356',60068.19,60068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177628',3492357,'2335','356',31324.35,32791.89,1467.54,234806.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','177628',3492358,'2336','356',359439.31,361177.25,1737.94,278070.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','177628',3492359,'2337','356',476960.77,476960.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','177628',3492360,'2338','357',1163162.56,1164395.36,1232.80,271216.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','177628',3492361,'2339','357',2346824.43,2349029.43,2205.00,485100.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','177628',3492362,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','177628',3492363,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177629',3492364,'2326','356',1265492.43,1267376.39,1883.96,301433.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','177629',3492365,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177629',3492366,'2328','356',230010.57,231462.16,1451.59,232254.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','177629',3492367,'2329','356',495029.36,495029.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177629',3492368,'2330','356',882845.09,882845.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177629',3492369,'2331','356',561950.45,563063.48,1113.03,178084.80,0.00,0.00,0.00,0.00,0.00),('1','113','823','177629',3492370,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177629',3492371,'2333','356',1047511.58,1047511.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177629',3492372,'2334','356',60068.19,60068.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177629',3492373,'2335','356',32791.89,33093.80,301.91,48305.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','177629',3492374,'2336','356',361177.25,361177.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177629',3492375,'2337','356',476960.77,478203.31,1242.54,198806.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','177629',3492376,'2338','357',1164395.36,1165650.27,1254.91,276080.20,0.00,0.00,0.00,0.00,0.00),('1','113','824','177629',3492377,'2339','357',2349029.43,2352099.56,3070.13,675428.60,0.00,0.00,0.00,0.00,0.00),('1','113','825','177629',3492378,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','177629',3492379,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177915',3497377,'2326','356',1267376.39,1270734.48,3358.09,537294.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','177915',3497378,'2327','356',512461.96,512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177915',3497379,'2328','356',231462.16,232914.46,1452.30,232368.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177915',3497380,'2329','356',495029.36,496874.96,1845.60,295296.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177915',3497381,'2330','356',882845.09,884628.04,1782.95,285272.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177915',3497382,'2331','356',563063.48,564644.57,1581.09,252974.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','177915',3497383,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177915',3497384,'2333','356',1047511.58,1048093.73,582.15,93144.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177915',3497385,'2334','356',60068.19,61714.36,1646.17,263387.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','177915',3497386,'2335','356',33093.80,33881.30,787.50,126000.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177915',3497387,'2336','356',361177.25,362417.22,1239.97,198395.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','177915',3497388,'2337','356',478203.31,479304.83,1101.52,176243.20,0.00,0.00,0.00,0.00,0.00),('1','113','824','177915',3497389,'2338','357',1165650.27,1166416.64,766.37,168601.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','177915',3497390,'2339','357',2352099.56,2354463.05,2363.49,519967.80,0.00,0.00,0.00,0.00,0.00),('1','113','825','177915',3497391,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','177915',3497392,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177918',3497448,'2326','356',1270734.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177918',3497449,'2327','356',512461.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177918',3497450,'2328','356',232914.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177918',3497451,'2329','356',496874.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177918',3497452,'2330','356',884628.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177918',3497453,'2331','356',564644.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177918',3497454,'2332','356',15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177918',3497455,'2333','356',1048093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177918',3497456,'2334','356',61714.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177918',3497457,'2335','356',33881.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177918',3497458,'2336','356',362417.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177918',3497459,'2337','356',479304.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','177918',3497460,'2338','357',1166416.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','177918',3497461,'2339','357',2354463.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','177918',3497462,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','177918',3497463,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177920',3497480,'2326','356',1270734.48,1274106.00,3371.52,549557.76,0.00,0.00,0.00,0.00,0.00),('1','113','823','177920',3497481,'2327','356',512461.96,512466.86,4.90,798.70,0.00,0.00,0.00,0.00,0.00),('1','113','823','177920',3497482,'2328','356',232914.46,233286.42,371.96,60629.48,0.00,0.00,0.00,0.00,0.00),('1','113','823','177920',3497483,'2329','356',496874.96,497625.35,750.39,122313.57,0.00,0.00,0.00,0.00,0.00),('1','113','823','177920',3497484,'2330','356',884628.04,887014.03,2385.99,388916.37,0.00,0.00,0.00,0.00,0.00),('1','113','823','177920',3497485,'2331','356',564644.57,564919.90,275.33,44878.79,0.00,0.00,0.00,0.00,0.00),('1','113','823','177920',3497486,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177920',3497487,'2333','356',1048093.73,1050758.41,2664.68,434342.84,0.00,0.00,0.00,0.00,0.00),('1','113','823','177920',3497488,'2334','356',61714.36,62174.83,460.47,75056.61,0.00,0.00,0.00,0.00,0.00),('1','113','823','177920',3497489,'2335','356',33881.30,33881.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','177920',3497490,'2336','356',362417.22,365067.64,2650.42,432018.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','177920',3497491,'2337','356',479304.83,479304.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','177920',3497492,'2338','357',1166416.64,1168999.20,2582.56,568163.20,0.00,0.00,0.00,0.00,0.00),('1','113','824','177920',3497493,'2339','357',2354463.05,2357691.95,3228.90,710358.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','177920',3497494,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','177920',3497495,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178068',3500619,'2326','356',1274106.00,1276250.77,2144.77,349597.51,0.00,0.00,0.00,0.00,0.00),('1','113','823','178068',3500620,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178068',3500621,'2328','356',233286.42,233286.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178068',3500622,'2329','356',497625.35,499189.45,1564.10,254948.30,0.00,0.00,0.00,0.00,0.00),('1','113','823','178068',3500623,'2330','356',887014.03,888351.29,1337.26,217973.38,0.00,0.00,0.00,0.00,0.00),('1','113','823','178068',3500624,'2331','356',564919.90,564919.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178068',3500625,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178068',3500626,'2333','356',1050758.41,1052268.41,1510.00,246130.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178068',3500627,'2334','356',62174.83,63625.72,1450.89,236495.07,0.00,0.00,0.00,0.00,0.00),('1','113','823','178068',3500628,'2335','356',33881.30,33881.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178068',3500629,'2336','356',365067.64,366237.50,1169.86,190687.18,0.00,0.00,0.00,0.00,0.00),('1','113','823','178068',3500630,'2337','356',479304.83,479304.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','178068',3500631,'2338','357',1168999.20,1172033.78,3034.58,667607.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','178068',3500632,'2339','357',2357691.95,2362351.93,4659.98,1025195.60,0.00,0.00,0.00,0.00,0.00),('1','113','825','178068',3500633,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','178068',3500634,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178310',3504864,'2326','356',1276250.77,1278664.88,2404.11,391869.93,0.00,0.00,10.00,0.00,0.00),('1','113','823','178310',3504865,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178310',3504866,'2328','356',233286.42,235534.65,2248.23,366461.49,0.00,0.00,0.00,0.00,0.00),('1','113','823','178310',3504867,'2329','356',499189.45,499189.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178310',3504868,'2330','356',888351.29,891080.95,2729.66,444934.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','178310',3504869,'2331','356',564919.90,564919.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178310',3504870,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178310',3504871,'2333','356',1052268.41,1053096.09,827.68,134911.84,0.00,0.00,0.00,0.00,0.00),('1','113','823','178310',3504872,'2334','356',63625.72,63625.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178310',3504873,'2335','356',33881.30,35931.47,2050.17,334177.71,0.00,0.00,0.00,0.00,0.00),('1','113','823','178310',3504874,'2336','356',366237.50,368110.43,1872.93,305287.59,0.00,0.00,0.00,0.00,0.00),('1','113','823','178310',3504875,'2337','356',479304.83,479304.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','178310',3504876,'2338','357',1172033.78,1173828.33,1794.55,394801.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','178310',3504877,'2339','357',2362351.93,2366099.14,3747.21,824386.20,0.00,0.00,0.00,0.00,0.00),('1','113','825','178310',3504878,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','178310',3504879,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178312',3504896,'2326','356',1278664.88,1280317.97,1653.09,269453.67,0.00,0.00,0.00,0.00,0.00),('1','113','823','178312',3504897,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178312',3504898,'2328','356',235534.65,237480.89,1946.24,317237.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','178312',3504899,'2329','356',499189.45,499189.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178312',3504900,'2330','356',891080.95,891080.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178312',3504901,'2331','356',564919.90,566440.27,1520.37,247820.31,0.00,0.00,0.00,0.00,0.00),('1','113','823','178312',3504902,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178312',3504903,'2333','356',1053096.09,1054505.26,1409.17,229694.71,0.00,0.00,0.00,0.00,0.00),('1','113','823','178312',3504904,'2334','356',63625.72,64766.75,1141.03,185987.89,0.00,0.00,0.00,0.00,0.00),('1','113','823','178312',3504905,'2335','356',35931.47,35931.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178312',3504906,'2336','356',368110.43,368110.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178312',3504907,'2337','356',479304.83,480115.62,810.79,132158.77,0.00,0.00,0.00,0.00,0.00),('1','113','824','178312',3504908,'2338','357',1173828.33,1175591.56,1763.23,387910.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','178312',3504909,'2339','357',2366099.14,2367503.00,1403.86,308849.20,0.00,0.00,0.00,0.00,0.00),('1','113','825','178312',3504910,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','178312',3504911,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178354',3505756,'2326','356',1280317.97,1281967.97,1650.00,268950.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178354',3505757,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178354',3505758,'2328','356',237480.89,239750.11,2269.22,369882.86,0.00,0.00,0.00,0.00,0.00),('1','113','823','178354',3505759,'2329','356',499189.45,499189.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178354',3505760,'2330','356',891080.95,891080.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178354',3505761,'2331','356',566440.27,568990.11,2549.84,415623.92,0.00,0.00,0.00,0.00,0.00),('1','113','823','178354',3505762,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178354',3505763,'2333','356',1054505.26,1055850.17,1344.91,219220.33,0.00,0.00,0.00,0.00,0.00),('1','113','823','178354',3505764,'2334','356',64766.75,64766.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178354',3505765,'2335','356',35931.47,37842.32,1910.85,311468.55,0.00,0.00,0.00,0.00,0.00),('1','113','823','178354',3505766,'2336','356',368110.43,370053.84,1943.41,316775.83,0.00,0.00,0.00,0.00,0.00),('1','113','823','178354',3505767,'2337','356',480115.62,480115.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','178354',3505768,'2338','357',1175591.56,1179549.77,3958.21,870806.20,0.00,0.00,0.00,0.00,0.00),('1','113','824','178354',3505769,'2339','357',2367503.00,2369385.98,1882.98,414255.60,0.00,0.00,0.00,0.00,0.00),('1','113','825','178354',3505770,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','178354',3505771,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178372',3506203,'2326','356',1281967.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178372',3506204,'2327','356',512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178372',3506205,'2328','356',239750.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178372',3506206,'2329','356',499189.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178372',3506207,'2330','356',891080.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178372',3506208,'2331','356',568990.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178372',3506209,'2332','356',15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178372',3506210,'2333','356',1055850.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178372',3506211,'2334','356',64766.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178372',3506212,'2335','356',37842.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178372',3506213,'2336','356',370053.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178372',3506214,'2337','356',480115.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','178372',3506215,'2338','357',1179549.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','178372',3506216,'2339','357',2369385.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','178372',3506217,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','178372',3506218,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178373',3506219,'2326','356',1281967.97,1283694.79,1726.82,281471.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','178373',3506220,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178373',3506221,'2328','356',239750.11,241546.96,1796.85,292886.55,0.00,0.00,0.00,0.00,0.00),('1','113','823','178373',3506222,'2329','356',499189.45,499189.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178373',3506223,'2330','356',891080.95,892750.23,1669.28,272092.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','178373',3506224,'2331','356',568990.11,568990.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178373',3506225,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178373',3506226,'2333','356',1055850.17,1057354.65,1504.48,245230.24,0.00,0.00,0.00,0.00,0.00),('1','113','823','178373',3506227,'2334','356',64766.75,64766.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178373',3506228,'2335','356',37842.32,39007.12,1164.80,189862.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','178373',3506229,'2336','356',370053.84,371020.10,966.26,157500.38,0.00,0.00,0.00,0.00,0.00),('1','113','823','178373',3506230,'2337','356',480115.62,480115.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','178373',3506231,'2338','357',1179549.77,1180720.44,1170.67,263400.75,0.00,0.00,0.00,0.00,0.00),('1','113','824','178373',3506232,'2339','357',2369385.98,2371224.33,1838.35,413628.75,0.00,0.00,0.00,0.00,0.00),('1','113','825','178373',3506233,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','178373',3506234,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178554',3509511,'2326','356',1283694.79,1286210.03,2515.24,409984.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','178554',3509512,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178554',3509513,'2328','356',241546.96,243995.26,2448.30,399072.90,0.00,0.00,0.00,0.00,0.00),('1','113','823','178554',3509514,'2329','356',499189.45,499189.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178554',3509515,'2330','356',892750.23,892750.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178554',3509516,'2331','356',568990.11,571677.05,2686.94,437971.22,0.00,0.00,0.00,0.00,0.00),('1','113','823','178554',3509517,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178554',3509518,'2333','356',1057354.65,1059364.35,2009.70,327581.10,0.00,0.00,0.00,0.00,0.00),('1','113','823','178554',3509519,'2334','356',64766.75,64766.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178554',3509520,'2335','356',39007.12,39934.29,927.17,151128.71,0.00,0.00,0.00,0.00,0.00),('1','113','823','178554',3509521,'2336','356',371020.10,371020.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178554',3509522,'2337','356',480115.62,481410.66,1295.04,211091.52,0.00,0.00,0.00,0.00,0.00),('1','113','824','178554',3509523,'2338','357',1180720.44,1182021.92,1301.48,292833.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','178554',3509524,'2339','357',2371224.33,2373459.86,2235.53,502994.25,0.00,0.00,0.00,0.00,0.00),('1','113','825','178554',3509525,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','178554',3509526,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178613',3510663,'2326','356',1286210.03,1287740.85,1530.82,249523.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','178613',3510664,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178613',3510665,'2328','356',243995.26,245595.93,1600.67,260909.21,0.00,0.00,0.00,0.00,0.00),('1','113','823','178613',3510666,'2329','356',499189.45,499189.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178613',3510667,'2330','356',892750.23,892750.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178613',3510668,'2331','356',571677.05,573357.87,1680.82,273973.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','178613',3510669,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178613',3510670,'2333','356',1059364.35,1060944.19,1579.84,257513.92,0.00,0.00,0.00,0.00,0.00),('1','113','823','178613',3510671,'2334','356',64766.75,64766.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178613',3510672,'2335','356',39934.29,40862.42,928.13,151285.19,0.00,0.00,0.00,0.00,0.00),('1','113','823','178613',3510673,'2336','356',371020.10,371020.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178613',3510674,'2337','356',481410.66,482329.66,919.00,149797.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','178613',3510675,'2338','357',1182021.92,1183995.91,1973.99,444147.75,0.00,0.00,0.00,0.00,0.00),('1','113','824','178613',3510676,'2339','357',2373459.86,2375019.18,1559.32,350847.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','178613',3510677,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','178613',3510678,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178774',3513398,'2326','356',1287740.85,1290419.82,2678.97,436672.11,0.00,0.00,0.00,0.00,0.00),('1','113','823','178774',3513399,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178774',3513400,'2328','356',245595.93,248012.49,2416.56,393899.28,0.00,0.00,0.00,0.00,0.00),('1','113','823','178774',3513401,'2329','356',499189.45,499189.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178774',3513402,'2330','356',892750.23,892750.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178774',3513403,'2331','356',573357.87,575496.22,2138.35,348551.05,0.00,0.00,0.00,0.00,0.00),('1','113','823','178774',3513404,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178774',3513405,'2333','356',1060944.19,1062839.99,1895.80,309015.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','178774',3513406,'2334','356',64766.75,64766.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178774',3513407,'2335','356',40862.42,42715.80,1853.38,302100.94,0.00,0.00,0.00,0.00,0.00),('1','113','823','178774',3513408,'2336','356',371020.10,371742.59,722.49,117765.87,0.00,0.00,0.00,0.00,0.00),('1','113','823','178774',3513409,'2337','356',482329.66,482329.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','178774',3513410,'2338','357',1183995.91,1186507.47,2511.56,565101.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','178774',3513411,'2339','357',2375019.18,2377681.95,2662.77,599123.25,0.00,0.00,0.00,0.00,0.00),('1','113','825','178774',3513412,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','178774',3513413,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178816',3514274,'2326','356',1290419.82,1292194.92,1775.10,289341.30,0.00,0.00,0.00,0.00,0.00),('1','113','823','178816',3514275,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178816',3514276,'2328','356',248012.49,249541.98,1529.49,249306.87,0.00,0.00,0.00,0.00,0.00),('1','113','823','178816',3514277,'2329','356',499189.45,499189.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178816',3514278,'2330','356',892750.23,894319.90,1569.67,255856.21,0.00,0.00,0.00,0.00,0.00),('1','113','823','178816',3514279,'2331','356',575496.22,575496.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178816',3514280,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178816',3514281,'2333','356',1062839.99,1064505.13,1665.14,271417.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','178816',3514282,'2334','356',64766.75,64766.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178816',3514283,'2335','356',42715.80,44265.64,1549.84,252623.92,0.00,0.00,0.00,0.00,0.00),('1','113','823','178816',3514284,'2336','356',371742.59,371742.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178816',3514285,'2337','356',482329.66,482329.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','178816',3514286,'2338','357',1186507.47,1187177.22,669.75,150693.75,0.00,0.00,0.00,0.00,0.00),('1','113','824','178816',3514287,'2339','357',2377681.95,2382014.08,4332.13,974729.25,0.00,0.00,0.00,0.00,0.00),('1','113','825','178816',3514288,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','178816',3514289,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178955',3516723,'2326','356',1292194.92,1294260.65,2065.73,336713.99,0.00,0.00,0.00,0.00,0.00),('1','113','823','178955',3516724,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178955',3516725,'2328','356',249541.98,251948.85,2406.87,392319.81,0.00,0.00,0.00,0.00,0.00),('1','113','823','178955',3516726,'2329','356',499189.45,499189.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178955',3516727,'2330','356',894319.90,894319.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178955',3516728,'2331','356',575496.22,577378.33,1882.11,306783.93,0.00,0.00,0.00,0.00,0.00),('1','113','823','178955',3516729,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178955',3516730,'2333','356',1064505.13,1065537.51,1032.38,168277.94,0.00,0.00,0.00,0.00,0.00),('1','113','823','178955',3516731,'2334','356',64766.75,64766.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','178955',3516732,'2335','356',44265.64,46035.52,1769.88,288490.44,0.00,0.00,0.00,0.00,0.00),('1','113','823','178955',3516733,'2336','356',371742.59,373017.79,1275.20,207857.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','178955',3516734,'2337','356',482329.66,482329.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','178955',3516735,'2338','357',1187177.22,1189901.79,2724.57,613028.25,0.00,0.00,0.00,0.00,0.00),('1','113','824','178955',3516736,'2339','357',2382014.08,2384016.64,2002.56,450576.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','178955',3516737,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','178955',3516738,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179177',3520782,'2326','356',1294260.65,1296251.01,1990.36,324428.68,0.00,0.00,0.00,0.00,0.00),('1','113','823','179177',3520783,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179177',3520784,'2328','356',251948.85,253578.85,1630.00,265690.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179177',3520785,'2329','356',499189.45,499189.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179177',3520786,'2330','356',894319.90,894319.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179177',3520787,'2331','356',577378.33,579078.54,1700.21,277134.23,0.00,0.00,0.00,0.00,0.00),('1','113','823','179177',3520788,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179177',3520789,'2333','356',1065537.51,1066986.61,1449.10,236203.30,0.00,0.00,0.00,0.00,0.00),('1','113','823','179177',3520790,'2334','356',64766.75,64766.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179177',3520791,'2335','356',46035.52,47503.08,1467.56,239212.28,0.00,0.00,0.00,0.00,0.00),('1','113','823','179177',3520792,'2336','356',373017.79,373895.80,878.01,143115.63,0.00,0.00,0.00,0.00,0.00),('1','113','823','179177',3520793,'2337','356',482329.66,482329.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','179177',3520794,'2338','357',1189901.79,1191783.13,1881.34,423301.50,0.00,0.00,0.00,0.00,0.00),('1','113','824','179177',3520795,'2339','357',2384016.64,2386949.95,2933.31,659994.75,0.00,0.00,0.00,0.00,0.00),('1','113','825','179177',3520796,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','179177',3520797,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179183',3520899,'2326','356',1296251.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179183',3520900,'2327','356',512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179183',3520901,'2328','356',253578.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179183',3520902,'2329','356',499189.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179183',3520903,'2330','356',894319.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179183',3520904,'2331','356',579078.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179183',3520905,'2332','356',15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179183',3520906,'2333','356',1066986.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179183',3520907,'2334','356',64766.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179183',3520908,'2335','356',47503.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179183',3520909,'2336','356',373895.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179183',3520910,'2337','356',482329.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','179183',3520911,'2338','357',1191783.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','179183',3520912,'2339','357',2386949.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','179183',3520913,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','179183',3520914,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179188',3520977,'2326','356',1296251.01,1298083.08,1832.07,298627.41,0.00,0.00,0.00,0.00,0.00),('1','113','823','179188',3520978,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179188',3520979,'2328','356',253578.85,254282.44,703.59,114685.17,0.00,0.00,0.00,0.00,0.00),('1','113','823','179188',3520980,'2329','356',499189.45,500924.79,1735.34,282860.42,0.00,0.00,0.00,0.00,0.00),('1','113','823','179188',3520981,'2330','356',894319.90,896328.84,2008.94,327457.22,0.00,0.00,0.00,0.00,0.00),('1','113','823','179188',3520982,'2331','356',579078.54,579078.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179188',3520983,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179188',3520984,'2333','356',1066986.61,1069016.34,2029.73,330845.99,0.00,0.00,0.00,0.00,0.00),('1','113','823','179188',3520985,'2334','356',64766.75,64766.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179188',3520986,'2335','356',47503.08,49288.63,1775.55,289414.65,0.00,0.00,10.00,0.00,0.00),('1','113','823','179188',3520987,'2336','356',373895.80,375252.45,1356.65,221133.95,0.00,0.00,0.00,0.00,0.00),('1','113','823','179188',3520988,'2337','356',482329.66,482329.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','179188',3520989,'2338','357',1191783.13,1193068.78,1285.65,295699.50,0.00,0.00,0.00,0.00,0.00),('1','113','824','179188',3520990,'2339','357',2386949.95,2388141.06,1171.11,269355.30,0.00,0.00,20.00,0.00,0.00),('1','113','825','179188',3520991,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','179188',3520992,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179385',3524848,'2326','356',1298083.08,1299686.92,1603.84,261425.92,0.00,0.00,0.00,0.00,0.00),('1','113','823','179385',3524849,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179385',3524850,'2328','356',254282.44,255832.01,1549.57,252579.91,0.00,0.00,0.00,0.00,0.00),('1','113','823','179385',3524851,'2329','356',500924.79,500924.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179385',3524852,'2330','356',896328.84,897662.92,1334.08,217455.04,0.00,0.00,0.00,0.00,0.00),('1','113','823','179385',3524853,'2331','356',579078.54,579078.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179385',3524854,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179385',3524855,'2333','356',1069016.34,1070444.24,1427.90,232747.70,0.00,0.00,0.00,0.00,0.00),('1','113','823','179385',3524856,'2334','356',64766.75,65691.81,925.06,150784.78,0.00,0.00,0.00,0.00,0.00),('1','113','823','179385',3524857,'2335','356',49288.63,49288.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179385',3524858,'2336','356',375252.45,375972.99,720.54,117448.02,0.00,0.00,0.00,0.00,0.00),('1','113','823','179385',3524859,'2337','356',482329.66,482329.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','179385',3524860,'2338','357',1193068.78,1194654.14,1585.36,364632.80,0.00,0.00,0.00,0.00,0.00),('1','113','824','179385',3524861,'2339','357',2388141.06,2390419.31,2278.25,523997.50,0.00,0.00,0.00,0.00,0.00),('1','113','825','179385',3524862,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','179385',3524863,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179386',3524864,'2326','356',1299686.92,1301866.61,2179.69,355289.47,0.00,0.00,0.00,0.00,0.00),('1','113','823','179386',3524865,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179386',3524866,'2328','356',255832.01,256749.06,917.05,149479.15,0.00,0.00,0.00,0.00,0.00),('1','113','823','179386',3524867,'2329','356',500924.79,502477.43,1552.64,253080.32,0.00,0.00,0.00,0.00,0.00),('1','113','823','179386',3524868,'2330','356',897662.92,899357.98,1695.06,276294.78,0.00,0.00,0.00,0.00,0.00),('1','113','823','179386',3524869,'2331','356',579078.54,579078.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179386',3524870,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179386',3524871,'2333','356',1070444.24,1072169.62,1725.38,281236.94,0.00,0.00,0.00,0.00,0.00),('1','113','823','179386',3524872,'2334','356',65691.81,67275.36,1583.55,258118.65,0.00,0.00,0.00,0.00,0.00),('1','113','823','179386',3524873,'2335','356',49288.63,49288.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179386',3524874,'2336','356',375972.99,377217.05,1244.06,202781.78,0.00,0.00,0.00,0.00,0.00),('1','113','823','179386',3524875,'2337','356',482329.66,482329.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','179386',3524876,'2338','357',1194654.14,1196785.38,2131.24,490185.20,0.00,0.00,0.00,0.00,0.00),('1','113','824','179386',3524877,'2339','357',2390419.31,2393521.90,3102.59,713595.70,0.00,0.00,0.00,0.00,0.00),('1','113','825','179386',3524878,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','179386',3524879,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179745',3532046,'2326','356',1301866.61,1303733.60,1866.99,304319.37,0.00,0.00,0.00,0.00,0.00),('1','113','823','179745',3532047,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179745',3532048,'2328','356',256749.06,258499.62,1750.56,285341.28,0.00,0.00,0.00,0.00,0.00),('1','113','823','179745',3532049,'2329','356',502477.43,502477.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179745',3532050,'2330','356',899357.98,899357.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179745',3532051,'2331','356',579078.54,580656.77,1578.23,257251.49,0.00,0.00,0.00,0.00,0.00),('1','113','823','179745',3532052,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179745',3532053,'2333','356',1072169.62,1073335.38,1165.76,190018.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','179745',3532054,'2334','356',67275.36,67275.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179745',3532055,'2335','356',49288.63,50580.88,1292.25,210636.75,0.00,0.00,0.00,0.00,0.00),('1','113','823','179745',3532056,'2336','356',377217.05,378110.82,893.77,145684.51,0.00,0.00,0.00,0.00,0.00),('1','113','823','179745',3532057,'2337','356',482329.66,482329.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','179745',3532058,'2338','357',1196785.38,1199882.95,3097.57,712441.10,0.00,0.00,0.00,0.00,0.00),('1','113','824','179745',3532059,'2339','357',2393521.90,2398856.40,5334.50,1226935.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','179745',3532060,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','179745',3532061,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179746',3532062,'2326','356',1303733.60,1307015.59,3281.99,534964.37,0.00,0.00,0.00,0.00,0.00),('1','113','823','179746',3532063,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179746',3532064,'2328','356',258499.62,259369.39,869.77,141772.51,0.00,0.00,0.00,0.00,0.00),('1','113','823','179746',3532065,'2329','356',502477.43,504441.38,1963.95,320123.85,0.00,0.00,0.00,0.00,0.00),('1','113','823','179746',3532066,'2330','356',899357.98,901371.08,2013.10,328135.30,0.00,0.00,0.00,0.00,0.00),('1','113','823','179746',3532067,'2331','356',580656.77,581434.74,777.97,126809.11,0.00,0.00,0.00,0.00,0.00),('1','113','823','179746',3532068,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179746',3532069,'2333','356',1073335.38,1075375.26,2039.88,332500.44,0.00,0.00,0.00,0.00,0.00),('1','113','823','179746',3532070,'2334','356',67275.36,69377.71,2102.35,342683.05,0.00,0.00,0.00,0.00,0.00),('1','113','823','179746',3532071,'2335','356',50580.88,50580.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179746',3532072,'2336','356',378110.82,379756.06,1645.24,268174.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','179746',3532073,'2337','356',482329.66,482381.81,52.15,8500.45,0.00,0.00,0.00,0.00,0.00),('1','113','824','179746',3532074,'2338','357',1199882.95,1201035.12,1152.17,264999.10,0.00,0.00,0.00,0.00,0.00),('1','113','824','179746',3532075,'2339','357',2398856.40,2401903.83,3047.43,700908.90,0.00,0.00,0.00,0.00,0.00),('1','113','825','179746',3532076,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','179746',3532077,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179749',3532138,'2326','356',1307015.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179749',3532139,'2327','356',512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179749',3532140,'2328','356',259369.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179749',3532141,'2329','356',504441.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179749',3532142,'2330','356',901371.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179749',3532143,'2331','356',581434.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179749',3532144,'2332','356',15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179749',3532145,'2333','356',1075375.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179749',3532146,'2334','356',69377.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179749',3532147,'2335','356',50580.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179749',3532148,'2336','356',379756.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179749',3532149,'2337','356',482381.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','179749',3532150,'2338','357',1201035.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','179749',3532151,'2339','357',2401903.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','179749',3532152,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','179749',3532153,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179750',3532154,'2326','356',1307015.59,1308754.53,1738.94,283447.22,0.00,0.00,0.00,0.00,0.00),('1','113','823','179750',3532155,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179750',3532156,'2328','356',259369.39,259387.79,-2.05,-334.15,0.00,0.00,20.45,0.00,0.00),('1','113','823','179750',3532157,'2329','356',504441.38,506283.34,1841.96,300239.48,0.00,0.00,0.00,0.00,0.00),('1','113','823','179750',3532158,'2330','356',901371.08,902409.21,1028.13,167585.19,0.00,0.00,10.00,0.00,0.00),('1','113','823','179750',3532159,'2331','356',581434.74,582877.48,1442.74,235166.62,0.00,0.00,0.00,0.00,0.00),('1','113','823','179750',3532160,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179750',3532161,'2333','356',1075375.26,1076681.89,1306.63,212980.69,0.00,0.00,0.00,0.00,0.00),('1','113','823','179750',3532162,'2334','356',69377.71,69377.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179750',3532163,'2335','356',50580.88,51896.12,1315.24,214384.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','179750',3532164,'2336','356',379756.06,380714.45,958.39,156217.57,0.00,0.00,0.00,0.00,0.00),('1','113','823','179750',3532165,'2337','356',482381.81,482381.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','179750',3532166,'2338','357',1201035.12,1202197.28,1141.64,268285.40,0.00,0.00,20.52,0.00,0.00),('1','113','824','179750',3532167,'2339','357',2401903.83,2402395.45,491.62,115530.70,0.00,0.00,0.00,0.00,0.00),('1','113','825','179750',3532168,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','179750',3532169,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179782',3532510,'2326','356',1308754.53,1311021.33,2266.80,369488.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','179782',3532511,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179782',3532512,'2328','356',259387.79,261552.21,2164.42,352800.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','179782',3532513,'2329','356',506283.34,507022.39,739.05,120465.15,0.00,0.00,0.00,0.00,0.00),('1','113','823','179782',3532514,'2330','356',902409.21,902423.93,14.72,2399.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','179782',3532515,'2331','356',582877.48,585340.46,2462.98,401465.74,0.00,0.00,0.00,0.00,0.00),('1','113','823','179782',3532516,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179782',3532517,'2333','356',1076681.89,1078448.05,1766.16,287884.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','179782',3532518,'2334','356',69377.71,70863.89,1486.18,242247.34,0.00,0.00,0.00,0.00,0.00),('1','113','823','179782',3532519,'2335','356',51896.12,51896.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179782',3532520,'2336','356',380714.45,380714.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','179782',3532521,'2337','356',482381.81,484003.92,1622.11,264403.93,0.00,0.00,0.00,0.00,0.00),('1','113','824','179782',3532522,'2338','357',1202197.28,1204556.02,2358.74,554303.90,0.00,0.00,0.00,0.00,0.00),('1','113','824','179782',3532523,'2339','357',2402395.45,2403917.12,1521.67,357592.45,0.00,0.00,0.00,0.00,0.00),('1','113','825','179782',3532524,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','179782',3532525,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180011',3536639,'2326','356',1311021.33,1312995.95,1974.62,321863.06,0.00,0.00,0.00,0.00,0.00),('1','113','823','180011',3536640,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180011',3536641,'2328','356',261552.21,263032.92,1480.71,241355.73,0.00,0.00,0.00,0.00,0.00),('1','113','823','180011',3536642,'2329','356',507022.39,507112.24,89.85,14645.55,0.00,0.00,0.00,0.00,0.00),('1','113','823','180011',3536643,'2330','356',902423.93,903668.30,1244.37,202832.31,0.00,0.00,0.00,0.00,0.00),('1','113','823','180011',3536644,'2331','356',585340.46,586034.96,694.50,113203.50,0.00,0.00,0.00,0.00,0.00),('1','113','823','180011',3536645,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180011',3536646,'2333','356',1078448.05,1079364.01,915.96,149301.48,0.00,0.00,0.00,0.00,0.00),('1','113','823','180011',3536647,'2334','356',70863.89,70863.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180011',3536648,'2335','356',51896.12,53277.96,1381.84,225239.92,0.00,0.00,0.00,0.00,0.00),('1','113','823','180011',3536649,'2336','356',380714.45,380886.81,172.36,28094.68,0.00,0.00,0.00,0.00,0.00),('1','113','823','180011',3536650,'2337','356',484003.92,484545.94,542.02,88349.26,0.00,0.00,0.00,0.00,0.00),('1','113','824','180011',3536651,'2338','357',1204556.02,1206427.93,1871.91,439898.85,0.00,0.00,0.00,0.00,0.00),('1','113','824','180011',3536652,'2339','357',2403917.12,2405522.93,1605.81,377365.35,0.00,0.00,0.00,0.00,0.00),('1','113','825','180011',3536653,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','180011',3536654,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180013',3536681,'2326','356',1312995.95,1315833.15,2837.20,462463.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','180013',3536682,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180013',3536683,'2328','356',263032.92,265584.76,2551.84,415949.92,0.00,0.00,0.00,0.00,0.00),('1','113','823','180013',3536684,'2329','356',507112.24,507112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180013',3536685,'2330','356',903668.30,904582.45,914.15,149006.45,0.00,0.00,0.00,0.00,0.00),('1','113','823','180013',3536686,'2331','356',586034.96,588322.87,2267.91,369669.33,0.00,0.00,20.00,0.00,0.00),('1','113','823','180013',3536687,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180013',3536688,'2333','356',1079364.01,1080415.03,1051.02,171316.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','180013',3536689,'2334','356',70863.89,70863.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180013',3536690,'2335','356',53277.96,55223.24,1945.28,317080.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','180013',3536691,'2336','356',380886.81,380886.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180013',3536692,'2337','356',484545.94,485866.78,1320.84,215296.92,0.00,0.00,0.00,0.00,0.00),('1','113','824','180013',3536693,'2338','357',1206427.93,1209036.87,2608.94,613100.90,0.00,0.00,0.00,0.00,0.00),('1','113','824','180013',3536694,'2339','357',2405522.93,2409456.81,3913.88,919761.80,0.00,0.00,20.00,0.00,0.00),('1','113','825','180013',3536695,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','180013',3536696,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180219',3540644,'2326','356',1315833.15,1317665.24,1832.09,298630.67,0.00,0.00,0.00,0.00,0.00),('1','113','823','180219',3540645,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180219',3540646,'2328','356',265584.76,267224.21,1639.45,267230.35,0.00,0.00,0.00,0.00,0.00),('1','113','823','180219',3540647,'2329','356',507112.24,507112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180219',3540648,'2330','356',904582.45,904582.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180219',3540649,'2331','356',588322.87,589628.98,1306.11,212895.93,0.00,0.00,0.00,0.00,0.00),('1','113','823','180219',3540650,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180219',3540651,'2333','356',1080415.03,1081390.96,975.93,159076.59,0.00,0.00,0.00,0.00,0.00),('1','113','823','180219',3540652,'2334','356',70863.89,70863.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180219',3540653,'2335','356',55223.24,56202.38,979.14,159599.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','180219',3540654,'2336','356',380886.81,381608.61,721.80,117653.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','180219',3540655,'2337','356',485866.78,485866.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','180219',3540656,'2338','357',1209036.87,1211315.66,2278.79,535515.65,0.00,0.00,0.00,0.00,0.00),('1','113','824','180219',3540657,'2339','357',2409456.81,2412434.43,2977.62,699740.70,0.00,0.00,0.00,0.00,0.00),('1','113','825','180219',3540658,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','180219',3540659,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180238',3541001,'2326','356',1317665.24,1320097.29,2432.05,396424.15,0.00,0.00,0.00,0.00,0.00),('1','113','823','180238',3541002,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180238',3541003,'2328','356',267224.21,269406.14,2181.93,355654.59,0.00,0.00,0.00,0.00,0.00),('1','113','823','180238',3541004,'2329','356',507112.24,507112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180238',3541005,'2330','356',904582.45,904582.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180238',3541006,'2331','356',589628.98,591888.10,2259.12,368236.56,0.00,0.00,0.00,0.00,0.00),('1','113','823','180238',3541007,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180238',3541008,'2333','356',1081390.96,1083655.09,2264.13,369053.19,0.00,0.00,0.00,0.00,0.00),('1','113','823','180238',3541009,'2334','356',70863.89,70863.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180238',3541010,'2335','356',56202.38,57852.42,1650.04,268956.52,0.00,0.00,0.00,0.00,0.00),('1','113','823','180238',3541011,'2336','356',381608.61,381608.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180238',3541012,'2337','356',485866.78,486972.99,1106.21,180312.23,0.00,0.00,0.00,0.00,0.00),('1','113','824','180238',3541013,'2338','357',1211315.66,1214490.01,3174.35,745972.25,0.00,0.00,0.00,0.00,0.00),('1','113','824','180238',3541014,'2339','357',2412434.43,2415489.81,3055.38,718014.30,0.00,0.00,0.00,0.00,0.00),('1','113','825','180238',3541015,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','180238',3541016,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180471',3545307,'2326','356',1320097.29,1321586.66,1489.37,242767.31,0.00,0.00,0.00,0.00,0.00),('1','113','823','180471',3545308,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180471',3545309,'2328','356',269406.14,270903.47,1497.33,244064.79,0.00,0.00,0.00,0.00,0.00),('1','113','823','180471',3545310,'2329','356',507112.24,507112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180471',3545311,'2330','356',904582.45,905748.67,1166.22,190093.86,0.00,0.00,0.00,0.00,0.00),('1','113','823','180471',3545312,'2331','356',591888.10,592798.11,910.01,148331.63,0.00,0.00,0.00,0.00,0.00),('1','113','823','180471',3545313,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180471',3545314,'2333','356',1083655.09,1084707.15,1052.06,171485.78,0.00,0.00,0.00,0.00,0.00),('1','113','823','180471',3545315,'2334','356',70863.89,71922.97,1059.08,172630.04,0.00,0.00,0.00,0.00,0.00),('1','113','823','180471',3545316,'2335','356',57852.42,57852.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180471',3545317,'2336','356',381608.61,382172.38,563.77,91894.51,0.00,0.00,0.00,0.00,0.00),('1','113','823','180471',3545318,'2337','356',486972.99,486972.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','180471',3545319,'2338','357',1214490.01,1218333.29,3843.28,903170.80,0.00,0.00,0.00,0.00,0.00),('1','113','824','180471',3545320,'2339','357',2415489.81,2420134.66,4644.85,1091539.75,0.00,0.00,0.00,0.00,0.00),('1','113','825','180471',3545321,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','180471',3545322,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180472',3545323,'2326','356',1321586.66,1323306.25,1719.59,280293.17,0.00,0.00,0.00,0.00,0.00),('1','113','823','180472',3545324,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180472',3545325,'2328','356',270903.47,273176.38,2272.91,370484.33,0.00,0.00,0.00,0.00,0.00),('1','113','823','180472',3545326,'2329','356',507112.24,507112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180472',3545327,'2330','356',905748.67,907529.91,1781.24,290342.12,0.00,0.00,0.00,0.00,0.00),('1','113','823','180472',3545328,'2331','356',592798.11,592798.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180472',3545329,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180472',3545330,'2333','356',1084707.15,1086284.97,1577.82,257184.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','180472',3545331,'2334','356',71922.97,71922.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180472',3545332,'2335','356',57852.42,59570.31,1717.89,280016.07,0.00,0.00,0.00,0.00,0.00),('1','113','823','180472',3545333,'2336','356',382172.38,382172.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180472',3545334,'2337','356',486972.99,488121.59,1148.60,187221.80,0.00,0.00,0.00,0.00,0.00),('1','113','824','180472',3545335,'2338','357',1218333.29,1220647.23,2313.94,543775.90,0.00,0.00,0.00,0.00,0.00),('1','113','824','180472',3545336,'2339','357',2420134.66,2423946.49,3811.83,895780.05,0.00,0.00,0.00,0.00,0.00),('1','113','825','180472',3545337,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','180472',3545338,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180480',3545443,'2326','356',1323306.25,1324951.65,1645.40,268200.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','180480',3545444,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180480',3545445,'2328','356',273176.38,274487.58,1311.20,213725.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','180480',3545446,'2329','356',507112.24,507490.20,377.96,61607.48,0.00,0.00,0.00,0.00,0.00),('1','113','823','180480',3545447,'2330','356',907529.91,908520.77,990.86,161510.18,0.00,0.00,0.00,0.00,0.00),('1','113','823','180480',3545448,'2331','356',592798.11,593629.60,831.49,135532.87,0.00,0.00,0.00,0.00,0.00),('1','113','823','180480',3545449,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180480',3545450,'2333','356',1086284.97,1087323.58,1038.61,169293.43,0.00,0.00,0.00,0.00,0.00),('1','113','823','180480',3545451,'2334','356',71922.97,71922.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180480',3545452,'2335','356',59570.31,60720.04,1149.73,187405.99,0.00,0.00,0.00,0.00,0.00),('1','113','823','180480',3545453,'2336','356',382172.38,382801.84,629.46,102601.98,0.00,0.00,0.00,0.00,0.00),('1','113','823','180480',3545454,'2337','356',488121.59,488121.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','180480',3545455,'2338','357',1220647.23,1222840.84,2193.61,515498.35,0.00,0.00,0.00,0.00,0.00),('1','113','824','180480',3545456,'2339','357',2423946.49,2427289.50,3343.01,785607.35,0.00,0.00,0.00,0.00,0.00),('1','113','825','180480',3545457,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','180480',3545458,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180608',3547652,'2326','356',1324951.65,1327237.07,2285.42,372523.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','180608',3547653,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180608',3547654,'2328','356',274487.58,276710.52,2222.94,362339.22,0.00,0.00,0.00,0.00,0.00),('1','113','823','180608',3547655,'2329','356',507490.20,507490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180608',3547656,'2330','356',908520.77,908520.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180608',3547657,'2331','356',593629.60,595900.89,2271.29,370220.27,0.00,0.00,0.00,0.00,0.00),('1','113','823','180608',3547658,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180608',3547659,'2333','356',1087323.58,1089178.51,1854.93,302353.59,0.00,0.00,0.00,0.00,0.00),('1','113','823','180608',3547660,'2334','356',71922.97,71922.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180608',3547661,'2335','356',60720.04,62652.07,1932.03,314920.89,0.00,0.00,0.00,0.00,0.00),('1','113','823','180608',3547662,'2336','356',382801.84,382801.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180608',3547663,'2337','356',488121.59,489532.88,1411.29,230040.27,0.00,0.00,0.00,0.00,0.00),('1','113','824','180608',3547664,'2338','357',1222840.84,1226278.47,3437.63,807843.05,0.00,0.00,0.00,0.00,0.00),('1','113','824','180608',3547665,'2339','357',2427289.50,2432115.03,4825.53,1133999.55,0.00,0.00,0.00,0.00,0.00),('1','113','825','180608',3547666,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','180608',3547667,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180801',3551220,'2326','356',1327237.07,1328922.38,1685.31,274705.53,0.00,0.00,0.00,0.00,0.00),('1','113','823','180801',3551221,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180801',3551222,'2328','356',276710.52,276710.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180801',3551223,'2329','356',507490.20,509206.73,1716.53,279794.39,0.00,0.00,0.00,0.00,0.00),('1','113','823','180801',3551224,'2330','356',908520.77,910049.68,1528.91,249212.33,0.00,0.00,0.00,0.00,0.00),('1','113','823','180801',3551225,'2331','356',595900.89,595900.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180801',3551226,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180801',3551227,'2333','356',1089178.51,1090050.26,871.75,142095.25,0.00,0.00,0.00,0.00,0.00),('1','113','823','180801',3551228,'2334','356',71922.97,73112.66,1189.69,193919.47,0.00,0.00,0.00,0.00,0.00),('1','113','823','180801',3551229,'2335','356',62652.07,62652.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180801',3551230,'2336','356',382801.84,383773.91,972.07,158447.41,0.00,0.00,0.00,0.00,0.00),('1','113','823','180801',3551231,'2337','356',489532.88,489532.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','180801',3551232,'2338','357',1226278.47,1229483.13,3204.66,753095.10,0.00,0.00,0.00,0.00,0.00),('1','113','824','180801',3551233,'2339','357',2432115.03,2434802.61,2687.58,631581.30,0.00,0.00,0.00,0.00,0.00),('1','113','825','180801',3551234,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','180801',3551235,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180805',3551303,'2326','356',1328922.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180805',3551304,'2327','356',512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180805',3551305,'2328','356',276710.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180805',3551306,'2329','356',509206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180805',3551307,'2330','356',910049.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180805',3551308,'2331','356',595900.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180805',3551309,'2332','356',15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180805',3551310,'2333','356',1090050.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180805',3551311,'2334','356',73112.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180805',3551312,'2335','356',62652.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180805',3551313,'2336','356',383773.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180805',3551314,'2337','356',489532.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','180805',3551315,'2338','357',1229483.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','180805',3551316,'2339','357',2434802.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','180805',3551317,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','180805',3551318,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180809',3551373,'2326','356',1328922.38,1330854.77,1932.39,314979.57,0.00,0.00,0.00,0.00,0.00),('1','113','823','180809',3551374,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180809',3551375,'2328','356',276710.52,278349.72,1639.20,267189.60,0.00,0.00,0.00,0.00,0.00),('1','113','823','180809',3551376,'2329','356',509206.73,509825.05,618.32,100786.16,0.00,0.00,0.00,0.00,0.00),('1','113','823','180809',3551377,'2330','356',910049.68,911602.49,1552.81,253108.03,0.00,0.00,0.00,0.00,0.00),('1','113','823','180809',3551378,'2331','356',595900.89,596627.24,726.35,118395.05,0.00,0.00,0.00,0.00,0.00),('1','113','823','180809',3551379,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180809',3551380,'2333','356',1090050.26,1091686.43,1636.17,266695.71,0.00,0.00,0.00,0.00,0.00),('1','113','823','180809',3551381,'2334','356',73112.66,73977.17,864.51,140915.13,0.00,0.00,0.00,0.00,0.00),('1','113','823','180809',3551382,'2335','356',62652.07,63801.13,1149.06,187296.78,0.00,0.00,0.00,0.00,0.00),('1','113','823','180809',3551383,'2336','356',383773.91,384735.91,962.00,156806.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','180809',3551384,'2337','356',489532.88,489532.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','180809',3551385,'2338','357',1229483.13,1234214.69,4731.56,1135574.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','180809',3551386,'2339','357',2434802.61,2438584.46,3781.85,907644.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','180809',3551387,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','180809',3551388,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181355',3561964,'2326','356',1330854.77,1331221.71,366.94,59811.22,0.00,0.00,0.00,0.00,0.00),('1','113','823','181355',3561965,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181355',3561966,'2328','356',278349.72,278349.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181355',3561967,'2329','356',509825.05,512125.88,2300.83,375035.29,0.00,0.00,0.00,0.00,0.00),('1','113','823','181355',3561968,'2330','356',911602.49,913729.40,2126.91,346686.33,0.00,0.00,0.00,0.00,0.00),('1','113','823','181355',3561969,'2331','356',596627.24,596627.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181355',3561970,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181355',3561971,'2333','356',1091686.43,1093369.23,1682.80,274296.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','181355',3561972,'2334','356',73977.17,75201.12,1223.95,199503.85,0.00,0.00,0.00,0.00,0.00),('1','113','823','181355',3561973,'2335','356',63801.13,63801.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181355',3561974,'2336','356',384735.91,385263.71,527.80,86031.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','181355',3561975,'2337','356',489532.88,489532.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','181355',3561976,'2338','357',1234214.69,1236622.88,2408.19,577965.60,0.00,0.00,0.00,0.00,0.00),('1','113','824','181355',3561977,'2339','357',2438584.46,2440111.12,1526.66,366398.40,0.00,0.00,0.00,0.00,0.00),('1','113','825','181355',3561978,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','181355',3561979,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181358',3562010,'2326','356',1331221.71,1333428.46,2206.75,359700.25,0.00,0.00,0.00,0.00,0.00),('1','113','823','181358',3562011,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181358',3562012,'2328','356',278349.72,279768.17,1418.45,231207.35,0.00,0.00,0.00,0.00,0.00),('1','113','823','181358',3562013,'2329','356',512125.88,513560.68,1434.80,233872.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','181358',3562014,'2330','356',913729.40,913729.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181358',3562015,'2331','356',596627.24,598494.42,1867.18,304350.34,0.00,0.00,0.00,0.00,0.00),('1','113','823','181358',3562016,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181358',3562017,'2333','356',1093369.23,1094851.39,1482.16,241592.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','181358',3562018,'2334','356',75201.12,75201.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181358',3562019,'2335','356',63801.13,65851.42,2050.29,334197.27,0.00,0.00,0.00,0.00,0.00),('1','113','823','181358',3562020,'2336','356',385263.71,386733.60,1469.89,239592.07,0.00,0.00,0.00,0.00,0.00),('1','113','823','181358',3562021,'2337','356',489532.88,489532.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','181358',3562022,'2338','357',1236622.88,1239638.21,3005.33,721279.20,0.00,0.00,10.00,0.00,0.00),('1','113','824','181358',3562023,'2339','357',2440111.12,2445866.66,5745.54,1378929.60,0.00,0.00,10.00,0.00,0.00),('1','113','825','181358',3562024,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','181358',3562025,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181370',3562163,'2326','356',1333428.46,1335619.91,2191.45,357206.35,0.00,0.00,0.00,0.00,0.00),('1','113','823','181370',3562164,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181370',3562165,'2328','356',279768.17,279768.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181370',3562166,'2329','356',513560.68,513698.06,137.38,22392.94,0.00,0.00,0.00,0.00,0.00),('1','113','823','181370',3562167,'2330','356',913729.40,915387.10,1657.70,270205.10,0.00,0.00,0.00,0.00,0.00),('1','113','823','181370',3562168,'2331','356',598494.42,598494.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181370',3562169,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181370',3562170,'2333','356',1094851.39,1096935.46,2084.07,339703.41,0.00,0.00,0.00,0.00,0.00),('1','113','823','181370',3562171,'2334','356',75201.12,77020.91,1819.79,296625.77,0.00,0.00,0.00,0.00,0.00),('1','113','823','181370',3562172,'2335','356',65851.42,65851.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181370',3562173,'2336','356',386733.60,386733.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181370',3562174,'2337','356',489532.88,489532.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','181370',3562175,'2338','357',1239638.21,1242142.07,2503.86,600926.40,0.00,0.00,0.00,0.00,0.00),('1','113','824','181370',3562176,'2339','357',2445866.66,2449646.58,3779.92,907180.80,0.00,0.00,0.00,0.00,0.00),('1','113','825','181370',3562177,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','181370',3562178,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181371',3562179,'2326','356',1335619.91,1335672.05,52.14,8498.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','181371',3562180,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181371',3562181,'2328','356',279768.17,279798.25,30.08,4903.04,0.00,0.00,0.00,0.00,0.00),('1','113','823','181371',3562182,'2329','356',513698.06,513699.29,1.23,200.49,0.00,0.00,0.00,0.00,0.00),('1','113','823','181371',3562183,'2330','356',915387.10,915387.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181371',3562184,'2331','356',598494.42,598533.06,38.64,6298.32,0.00,0.00,0.00,0.00,0.00),('1','113','823','181371',3562185,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181371',3562186,'2333','356',1096935.46,1096984.54,49.08,8000.04,0.00,0.00,0.00,0.00,0.00),('1','113','823','181371',3562187,'2334','356',77020.91,77020.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181371',3562188,'2335','356',65851.42,65869.21,17.79,2899.77,0.00,0.00,0.00,0.00,0.00),('1','113','823','181371',3562189,'2336','356',386733.60,386733.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181371',3562190,'2337','356',489532.88,489532.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','181371',3562191,'2338','357',1242142.07,1245394.59,3252.52,780604.80,0.00,0.00,0.00,0.00,0.00),('1','113','824','181371',3562192,'2339','357',2449646.58,2452769.09,3122.51,749402.40,0.00,0.00,0.00,0.00,0.00),('1','113','825','181371',3562193,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','181371',3562194,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181374',3562227,'2326','356',1335672.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181374',3562228,'2327','356',512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181374',3562229,'2328','356',279798.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181374',3562230,'2329','356',513699.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181374',3562231,'2330','356',915387.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181374',3562232,'2331','356',598533.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181374',3562233,'2332','356',15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181374',3562234,'2333','356',1096984.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181374',3562235,'2334','356',77020.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181374',3562236,'2335','356',65869.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181374',3562237,'2336','356',386733.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181374',3562238,'2337','356',489532.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','181374',3562239,'2338','357',1245394.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','181374',3562240,'2339','357',2452769.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','181374',3562241,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','181374',3562242,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181375',3562243,'2326','356',1335672.05,1337447.90,1775.85,289463.55,0.00,0.00,0.00,0.00,0.00),('1','113','823','181375',3562244,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181375',3562245,'2328','356',279798.25,281660.46,1862.21,303540.23,0.00,0.00,0.00,0.00,0.00),('1','113','823','181375',3562246,'2329','356',513699.29,513699.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181375',3562247,'2330','356',915387.10,915387.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181375',3562248,'2331','356',598533.06,598533.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181375',3562249,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181375',3562250,'2333','356',1096984.54,1098729.98,1745.44,284506.72,0.00,0.00,0.00,0.00,0.00),('1','113','823','181375',3562251,'2334','356',77020.91,77020.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181375',3562252,'2335','356',65869.21,67331.50,1462.29,238353.27,0.00,0.00,0.00,0.00,0.00),('1','113','823','181375',3562253,'2336','356',386733.60,386733.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181375',3562254,'2337','356',489532.88,490924.25,1371.37,223533.31,0.00,0.00,20.00,0.00,0.00),('1','113','824','181375',3562255,'2338','357',1245394.59,1247106.92,1712.33,419520.85,0.00,0.00,0.00,0.00,0.00),('1','113','824','181375',3562256,'2339','357',2452769.09,2454309.19,1540.10,377324.50,0.00,0.00,0.00,0.00,0.00),('1','113','825','181375',3562257,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','181375',3562258,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181378',3562288,'2326','356',1337447.90,1339735.01,2287.11,372798.93,0.00,0.00,0.00,0.00,0.00),('1','113','823','181378',3562289,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181378',3562290,'2328','356',281660.46,281660.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181378',3562291,'2329','356',513699.29,516145.58,2446.29,398745.27,0.00,0.00,0.00,0.00,0.00),('1','113','823','181378',3562292,'2330','356',915387.10,916823.43,1436.33,234121.79,0.00,0.00,0.00,0.00,0.00),('1','113','823','181378',3562293,'2331','356',598533.06,600168.05,1634.99,266503.37,0.00,0.00,0.00,0.00,0.00),('1','113','823','181378',3562294,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181378',3562295,'2333','356',1098729.98,1100493.95,1763.97,287527.11,0.00,0.00,0.00,0.00,0.00),('1','113','823','181378',3562296,'2334','356',77020.91,77020.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181378',3562297,'2335','356',67331.50,68686.27,1354.77,220827.51,0.00,0.00,0.00,0.00,0.00),('1','113','823','181378',3562298,'2336','356',386733.60,388069.44,1335.84,217741.92,0.00,0.00,0.00,0.00,0.00),('1','113','823','181378',3562299,'2337','356',490924.25,490924.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','181378',3562300,'2338','357',1247106.92,1250110.02,3003.10,735759.50,0.00,0.00,0.00,0.00,0.00),('1','113','824','181378',3562301,'2339','357',2454309.19,2458911.67,4602.48,1127607.60,0.00,0.00,0.00,0.00,0.00),('1','113','825','181378',3562302,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','181378',3562303,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181537',3565196,'2326','356',1339735.01,1341506.60,1771.59,288769.17,0.00,0.00,0.00,0.00,0.00),('1','113','823','181537',3565197,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181537',3565198,'2328','356',281660.46,283454.33,1793.87,292400.81,0.00,0.00,0.00,0.00,0.00),('1','113','823','181537',3565199,'2329','356',516145.58,516145.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181537',3565200,'2330','356',916823.43,916823.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181537',3565201,'2331','356',600168.05,602001.83,1833.78,298906.14,0.00,0.00,0.00,0.00,0.00),('1','113','823','181537',3565202,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181537',3565203,'2333','356',1100493.95,1100493.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181537',3565204,'2334','356',77020.91,77020.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181537',3565205,'2335','356',68686.27,69844.43,1158.16,188780.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','181537',3565206,'2336','356',388069.44,388069.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181537',3565207,'2337','356',490924.25,491880.37,956.12,155847.56,0.00,0.00,0.00,0.00,0.00),('1','113','824','181537',3565208,'2338','357',1250110.02,1251505.73,1395.71,341948.95,0.00,0.00,0.00,0.00,0.00),('1','113','824','181537',3565209,'2339','357',2458911.67,2460473.93,1562.26,382753.70,0.00,0.00,0.00,0.00,0.00),('1','113','825','181537',3565210,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','181537',3565211,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181539',3565214,'2326','356',1341506.60,1343905.32,2398.72,390991.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','181539',3565215,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181539',3565216,'2328','356',283454.33,285370.02,1915.69,312257.47,0.00,0.00,0.00,0.00,0.00),('1','113','823','181539',3565217,'2329','356',516145.58,517462.56,1316.98,214667.74,0.00,0.00,0.00,0.00,0.00),('1','113','823','181539',3565218,'2330','356',916823.43,916823.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181539',3565219,'2331','356',602001.83,604118.00,2116.17,344935.71,0.00,0.00,0.00,0.00,0.00),('1','113','823','181539',3565220,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181539',3565221,'2333','356',1100493.95,1101864.91,1370.96,223466.48,0.00,0.00,0.00,0.00,0.00),('1','113','823','181539',3565222,'2334','356',77020.91,77020.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181539',3565223,'2335','356',69844.43,71543.01,1698.58,276868.54,0.00,0.00,0.00,0.00,0.00),('1','113','823','181539',3565224,'2336','356',388069.44,389322.49,1243.05,202617.15,0.00,0.00,10.00,0.00,0.00),('1','113','823','181539',3565225,'2337','356',491880.37,491880.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','181539',3565226,'2338','357',1251505.73,1253711.36,2205.63,540379.35,0.00,0.00,0.00,0.00,0.00),('1','113','824','181539',3565227,'2339','357',2460473.93,2463824.98,3351.05,821007.25,0.00,0.00,0.00,0.00,0.00),('1','113','825','181539',3565228,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','181539',3565229,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181798',3569760,'2326','356',1343905.32,1345775.62,1860.30,303228.90,0.00,0.00,10.00,0.00,0.00),('1','113','823','181798',3569761,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181798',3569762,'2328','356',285370.02,287067.97,1677.95,273505.85,0.00,0.00,20.00,0.00,0.00),('1','113','823','181798',3569763,'2329','356',517462.56,517462.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181798',3569764,'2330','356',916823.43,916823.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181798',3569765,'2331','356',604118.00,605547.39,1419.39,231360.57,0.00,0.00,10.00,0.00,0.00),('1','113','823','181798',3569766,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181798',3569767,'2333','356',1101864.91,1103401.22,1526.31,248788.53,0.00,0.00,10.00,0.00,0.00),('1','113','823','181798',3569768,'2334','356',77020.91,77020.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181798',3569769,'2335','356',71543.01,71543.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181798',3569770,'2336','356',389322.49,389322.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181798',3569771,'2337','356',491880.37,492995.76,1105.39,180178.57,0.00,0.00,10.00,0.00,0.00),('1','113','824','181798',3569772,'2338','357',1253711.36,1254209.40,498.04,122019.80,0.00,0.00,0.00,0.00,0.00),('1','113','824','181798',3569773,'2339','357',2463824.98,2465140.09,1315.11,322201.95,0.00,0.00,0.00,0.00,0.00),('1','113','825','181798',3569774,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','181798',3569775,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181801',3569815,'2326','356',1345775.62,1347962.38,2186.76,356441.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','181801',3569816,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181801',3569817,'2328','356',287067.97,287266.79,198.82,32407.66,0.00,0.00,0.00,0.00,0.00),('1','113','823','181801',3569818,'2329','356',517462.56,519891.38,2418.82,394267.66,0.00,0.00,10.00,0.00,0.00),('1','113','823','181801',3569819,'2330','356',916823.43,918791.07,1957.64,319095.32,0.00,0.00,10.00,0.00,0.00),('1','113','823','181801',3569820,'2331','356',605547.39,605619.13,71.74,11693.62,0.00,0.00,0.00,0.00,0.00),('1','113','823','181801',3569821,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181801',3569822,'2333','356',1103401.22,1105319.81,1918.59,312730.17,0.00,0.00,0.00,0.00,0.00),('1','113','823','181801',3569823,'2334','356',77020.91,77020.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181801',3569824,'2335','356',71543.01,73457.06,1904.05,310360.15,0.00,0.00,10.00,0.00,0.00),('1','113','823','181801',3569825,'2336','356',389322.49,391114.76,1762.27,287250.01,0.00,0.00,30.00,0.00,0.00),('1','113','823','181801',3569826,'2337','356',492995.76,492995.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','181801',3569827,'2338','357',1254209.40,1255622.71,1413.31,346260.95,0.00,0.00,0.00,0.00,0.00),('1','113','824','181801',3569828,'2339','357',2465140.09,2467612.50,2472.41,605740.45,0.00,0.00,0.00,0.00,0.00),('1','113','825','181801',3569829,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','181801',3569830,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181985',3573012,'2326','356',1347962.38,1349613.95,1651.57,269205.91,0.00,0.00,0.00,0.00,0.00),('1','113','823','181985',3573013,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181985',3573014,'2328','356',287266.79,289144.48,1877.69,306063.47,0.00,0.00,0.00,0.00,0.00),('1','113','823','181985',3573015,'2329','356',519891.38,519891.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181985',3573016,'2330','356',918791.07,918791.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181985',3573017,'2331','356',605619.13,607383.86,1764.73,287650.99,0.00,0.00,0.00,0.00,0.00),('1','113','823','181985',3573018,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181985',3573019,'2333','356',1105319.81,1106902.73,1582.92,258015.96,0.00,0.00,0.00,0.00,0.00),('1','113','823','181985',3573020,'2334','356',77020.91,77020.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181985',3573021,'2335','356',73457.06,74842.08,1385.02,225758.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','181985',3573022,'2336','356',391114.76,391114.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181985',3573023,'2337','356',492995.76,493879.88,884.12,144111.56,0.00,0.00,0.00,0.00,0.00),('1','113','824','181985',3573024,'2338','357',1255622.71,1257782.88,2160.17,529241.65,0.00,0.00,0.00,0.00,0.00),('1','113','824','181985',3573025,'2339','357',2467612.50,2469674.01,2061.51,505069.95,0.00,0.00,0.00,0.00,0.00),('1','113','825','181985',3573026,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','181985',3573027,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181988',3573052,'2326','356',1349613.95,1352530.53,2906.58,473772.54,0.00,0.00,10.00,0.00,0.00),('1','113','823','181988',3573053,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181988',3573054,'2328','356',289144.48,289144.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181988',3573055,'2329','356',519891.38,522678.50,2777.12,452670.56,0.00,0.00,10.00,0.00,0.00),('1','113','823','181988',3573056,'2330','356',918791.07,921515.56,2714.49,442461.87,0.00,0.00,10.00,0.00,0.00),('1','113','823','181988',3573057,'2331','356',607383.86,607383.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181988',3573058,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181988',3573059,'2333','356',1106902.73,1109324.46,2411.73,393111.99,0.00,0.00,10.00,0.00,0.00),('1','113','823','181988',3573060,'2334','356',77020.91,79525.85,2494.94,406675.22,0.00,0.00,10.00,0.00,0.00),('1','113','823','181988',3573061,'2335','356',74842.08,74842.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','181988',3573062,'2336','356',391114.76,393444.60,2319.84,378133.92,0.00,0.00,10.00,0.00,0.00),('1','113','823','181988',3573063,'2337','356',493879.88,493879.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','181988',3573064,'2338','357',1257782.88,1260323.32,2530.44,619957.80,0.00,0.00,10.00,0.00,0.00),('1','113','824','181988',3573065,'2339','357',2469674.01,2471626.63,1942.62,475941.90,0.00,0.00,10.00,0.00,0.00),('1','113','825','181988',3573066,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','181988',3573067,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182091',3575306,'2326','356',1352530.53,1354404.42,1873.89,305444.07,0.00,0.00,0.00,0.00,0.00),('1','113','823','182091',3575307,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182091',3575308,'2328','356',289144.48,291479.01,2334.53,380528.39,0.00,0.00,0.00,0.00,0.00),('1','113','823','182091',3575309,'2329','356',522678.50,522678.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182091',3575310,'2330','356',921515.56,924513.86,2998.30,488722.90,0.00,0.00,0.00,0.00,0.00),('1','113','823','182091',3575311,'2331','356',607383.86,607383.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182091',3575312,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182091',3575313,'2333','356',1109324.46,1109324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182091',3575314,'2334','356',79525.85,79525.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182091',3575315,'2335','356',74842.08,76972.05,2129.97,347185.11,0.00,0.00,0.00,0.00,0.00),('1','113','823','182091',3575316,'2336','356',393444.60,393444.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182091',3575317,'2337','356',493879.88,496113.88,2234.00,364142.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','182091',3575318,'2338','357',1260323.32,1261741.94,1418.62,347561.90,0.00,0.00,0.00,0.00,0.00),('1','113','824','182091',3575319,'2339','357',2471626.63,2472900.49,1273.86,312095.70,0.00,0.00,0.00,0.00,0.00),('1','113','825','182091',3575320,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','182091',3575321,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182348',3579398,'2326','356',1354404.42,1358466.21,4061.79,662071.77,0.00,0.00,0.00,0.00,0.00),('1','113','823','182348',3579399,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182348',3579400,'2328','356',291479.01,291479.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182348',3579401,'2329','356',522678.50,525264.43,2585.93,421506.59,0.00,0.00,0.00,0.00,0.00),('1','113','823','182348',3579402,'2330','356',924513.86,924513.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182348',3579403,'2331','356',607383.86,610685.53,3301.67,538172.21,0.00,0.00,0.00,0.00,0.00),('1','113','823','182348',3579404,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182348',3579405,'2333','356',1109324.46,1110349.74,1025.28,167120.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','182348',3579406,'2334','356',79525.85,82591.34,3065.49,499674.87,0.00,0.00,0.00,0.00,0.00),('1','113','823','182348',3579407,'2335','356',76972.05,76972.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182348',3579408,'2336','356',393444.60,395733.72,2289.12,373126.56,0.00,0.00,0.00,0.00,0.00),('1','113','823','182348',3579409,'2337','356',496113.88,496113.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','182348',3579410,'2338','357',1261741.94,1264881.12,3139.18,769099.10,0.00,0.00,0.00,0.00,0.00),('1','113','824','182348',3579411,'2339','357',2472900.49,2475926.65,3026.16,741409.20,0.00,0.00,0.00,0.00,0.00),('1','113','825','182348',3579412,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','182348',3579413,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182356',3579542,'2326','356',1358466.21,1360549.55,2083.34,339584.42,0.00,0.00,0.00,0.00,0.00),('1','113','823','182356',3579543,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182356',3579544,'2328','356',291479.01,292977.44,1498.43,244244.09,0.00,0.00,0.00,0.00,0.00),('1','113','823','182356',3579545,'2329','356',525264.43,525264.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182356',3579546,'2330','356',924513.86,924513.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182356',3579547,'2331','356',610685.53,612719.20,2033.67,331488.21,0.00,0.00,0.00,0.00,0.00),('1','113','823','182356',3579548,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182356',3579549,'2333','356',1110349.74,1112291.37,1941.63,316485.69,0.00,0.00,0.00,0.00,0.00),('1','113','823','182356',3579550,'2334','356',82591.34,82591.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182356',3579551,'2335','356',76972.05,78752.21,1780.16,290166.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','182356',3579552,'2336','356',395733.72,395733.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182356',3579553,'2337','356',496113.88,496113.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','182356',3579554,'2338','357',1264881.12,1266629.01,1747.89,428233.05,0.00,0.00,0.00,0.00,0.00),('1','113','824','182356',3579555,'2339','357',2475926.65,2478619.41,2692.76,659726.20,0.00,0.00,0.00,0.00,0.00),('1','113','825','182356',3579556,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','182356',3579557,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182361',3579676,'2326','356',1360549.55,1364128.84,3579.29,583424.27,0.00,0.00,0.00,0.00,0.00),('1','113','823','182361',3579677,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182361',3579678,'2328','356',292977.44,295589.77,2612.33,425809.79,0.00,0.00,0.00,0.00,0.00),('1','113','823','182361',3579679,'2329','356',525264.43,525607.97,343.54,55997.02,0.00,0.00,0.00,0.00,0.00),('1','113','823','182361',3579680,'2330','356',924513.86,927605.12,3091.26,503875.38,0.00,0.00,0.00,0.00,0.00),('1','113','823','182361',3579681,'2331','356',612719.20,612719.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182361',3579682,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182361',3579683,'2333','356',1112291.37,1115032.63,2741.26,446825.38,0.00,0.00,0.00,0.00,0.00),('1','113','823','182361',3579684,'2334','356',82591.34,82781.76,190.42,31038.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','182361',3579685,'2335','356',78752.21,78965.97,213.76,34842.88,0.00,0.00,0.00,0.00,0.00),('1','113','823','182361',3579686,'2336','356',395733.72,396878.14,1144.42,186540.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','182361',3579687,'2337','356',496113.88,496113.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','182361',3579688,'2338','357',1266629.01,1269584.36,2955.35,724060.75,0.00,0.00,0.00,0.00,0.00),('1','113','824','182361',3579689,'2339','357',2478619.41,2482950.66,4331.25,1061156.25,0.00,0.00,0.00,0.00,0.00),('1','113','825','182361',3579690,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','182361',3579691,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182527',3582750,'2326','356',1364128.84,1366015.58,1886.74,307538.62,0.00,0.00,0.00,0.00,0.00),('1','113','823','182527',3582751,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182527',3582752,'2328','356',295589.77,295809.05,219.28,35742.64,0.00,0.00,0.00,0.00,0.00),('1','113','823','182527',3582753,'2329','356',525607.97,525607.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182527',3582754,'2330','356',927605.12,927605.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182527',3582755,'2331','356',612719.20,614017.79,1298.59,211670.17,0.00,0.00,0.00,0.00,0.00),('1','113','823','182527',3582756,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182527',3582757,'2333','356',1115032.63,1117315.56,2282.93,372117.59,0.00,0.00,0.00,0.00,0.00),('1','113','823','182527',3582758,'2334','356',82781.76,82781.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182527',3582759,'2335','356',78965.97,81160.89,2194.92,357771.96,0.00,0.00,0.00,0.00,0.00),('1','113','823','182527',3582760,'2336','356',396878.14,398934.37,2056.23,335165.49,0.00,0.00,0.00,0.00,0.00),('1','113','823','182527',3582761,'2337','356',496113.88,496113.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','182527',3582762,'2338','357',1269584.36,1271013.33,1428.97,350097.65,0.00,0.00,0.00,0.00,0.00),('1','113','824','182527',3582763,'2339','357',2482950.66,2484559.75,1609.09,394227.05,0.00,0.00,0.00,0.00,0.00),('1','113','825','182527',3582764,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','182527',3582765,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182536',3582898,'2326','356',1366015.58,1368873.49,2857.91,465839.33,0.00,0.00,0.00,0.00,0.00),('1','113','823','182536',3582899,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182536',3582900,'2328','356',295809.05,299177.34,3368.29,549031.27,0.00,0.00,0.00,0.00,0.00),('1','113','823','182536',3582901,'2329','356',525607.97,525607.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182536',3582902,'2330','356',927605.12,930106.67,2501.55,407752.65,0.00,0.00,0.00,0.00,0.00),('1','113','823','182536',3582903,'2331','356',614017.79,614017.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182536',3582904,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182536',3582905,'2333','356',1117315.56,1119735.75,2420.19,394490.97,0.00,0.00,0.00,0.00,0.00),('1','113','823','182536',3582906,'2334','356',82781.76,84817.89,2036.13,331889.19,0.00,0.00,0.00,0.00,0.00),('1','113','823','182536',3582907,'2335','356',81160.89,81160.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182536',3582908,'2336','356',398934.37,400753.89,1819.52,296581.76,0.00,0.00,0.00,0.00,0.00),('1','113','823','182536',3582909,'2337','356',496113.88,496113.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','182536',3582910,'2338','357',1271013.33,1273916.90,2903.57,711374.65,0.00,0.00,0.00,0.00,0.00),('1','113','824','182536',3582911,'2339','357',2484559.75,2487502.01,2942.26,720853.70,0.00,0.00,0.00,0.00,0.00),('1','113','825','182536',3582912,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','182536',3582913,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182860',3589074,'2326','356',1368873.49,1370953.98,2080.49,339119.87,0.00,0.00,0.00,0.00,0.00),('1','113','823','182860',3589075,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182860',3589076,'2328','356',299177.34,301271.99,2094.65,341427.95,0.00,0.00,0.00,0.00,0.00),('1','113','823','182860',3589077,'2329','356',525607.97,525607.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182860',3589078,'2330','356',930106.67,932248.42,2141.75,349105.25,0.00,0.00,0.00,0.00,0.00),('1','113','823','182860',3589079,'2331','356',614017.79,614017.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182860',3589080,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182860',3589081,'2333','356',1119735.75,1121964.89,2229.14,363349.82,0.00,0.00,0.00,0.00,0.00),('1','113','823','182860',3589082,'2334','356',84817.89,84817.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182860',3589083,'2335','356',81160.89,83331.04,2170.15,353734.45,0.00,0.00,0.00,0.00,0.00),('1','113','823','182860',3589084,'2336','356',400753.89,400753.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182860',3589085,'2337','356',496113.88,496113.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','182860',3589086,'2338','357',1273916.90,1275762.59,1845.69,452194.05,0.00,0.00,0.00,0.00,0.00),('1','113','824','182860',3589087,'2339','357',2487502.01,2489557.73,2055.72,503651.40,0.00,0.00,0.00,0.00,0.00),('1','113','825','182860',3589088,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','182860',3589089,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182861',3589090,'2326','356',1370953.98,1373941.63,2987.65,486986.95,0.00,0.00,0.00,0.00,0.00),('1','113','823','182861',3589091,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182861',3589092,'2328','356',301271.99,301271.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182861',3589093,'2329','356',525607.97,527515.20,1907.23,310878.49,0.00,0.00,0.00,0.00,0.00),('1','113','823','182861',3589094,'2330','356',932248.42,932248.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182861',3589095,'2331','356',614017.79,616794.59,2776.80,452618.40,0.00,0.00,0.00,0.00,0.00),('1','113','823','182861',3589096,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182861',3589097,'2333','356',1121964.89,1124576.27,2611.38,425654.94,0.00,0.00,0.00,0.00,0.00),('1','113','823','182861',3589098,'2334','356',84817.89,84817.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182861',3589099,'2335','356',83331.04,85778.61,2447.57,398953.91,0.00,0.00,0.00,0.00,0.00),('1','113','823','182861',3589100,'2336','356',400753.89,402441.95,1688.06,275153.78,0.00,0.00,0.00,0.00,0.00),('1','113','823','182861',3589101,'2337','356',496113.88,496113.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','182861',3589102,'2338','357',1275762.59,1276694.34,931.75,228278.75,0.00,0.00,0.00,0.00,0.00),('1','113','824','182861',3589103,'2339','357',2489557.73,2491567.29,2009.56,492342.20,0.00,0.00,0.00,0.00,0.00),('1','113','825','182861',3589104,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','182861',3589105,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182862',3589106,'2326','356',1373941.63,1376340.67,2399.04,391043.52,0.00,0.00,0.00,0.00,0.00),('1','113','823','182862',3589107,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182862',3589108,'2328','356',301271.99,303400.45,2128.46,346938.98,0.00,0.00,0.00,0.00,0.00),('1','113','823','182862',3589109,'2329','356',527515.20,527515.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182862',3589110,'2330','356',932248.42,932248.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182862',3589111,'2331','356',616794.59,619232.25,2437.66,397338.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','182862',3589112,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182862',3589113,'2333','356',1124576.27,1124892.77,316.50,51589.50,0.00,0.00,0.00,0.00,0.00),('1','113','823','182862',3589114,'2334','356',84817.89,84817.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182862',3589115,'2335','356',85778.61,87681.00,1902.39,310089.57,0.00,0.00,0.00,0.00,0.00),('1','113','823','182862',3589116,'2336','356',402441.95,402441.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182862',3589117,'2337','356',496113.88,496113.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','182862',3589118,'2338','357',1276694.34,1278430.47,1736.13,425351.85,0.00,0.00,0.00,0.00,0.00),('1','113','824','182862',3589119,'2339','357',2491567.29,2494527.49,2960.20,725249.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','182862',3589120,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','182862',3589121,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182996',3591536,'2326','356',1376340.67,1379619.21,3278.54,534402.02,0.00,0.00,0.00,0.00,0.00),('1','113','823','182996',3591537,'2327','356',512466.86,512466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182996',3591538,'2328','356',303400.45,303421.92,21.47,3499.61,0.00,0.00,0.00,0.00,0.00),('1','113','823','182996',3591539,'2329','356',527515.20,530029.15,2513.95,409773.85,0.00,0.00,0.00,0.00,0.00),('1','113','823','182996',3591540,'2330','356',932248.42,932248.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182996',3591541,'2331','356',619232.25,621907.91,2675.66,436132.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','182996',3591542,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182996',3591543,'2333','356',1124892.77,1127002.16,2109.39,343830.57,0.00,0.00,0.00,0.00,0.00),('1','113','823','182996',3591544,'2334','356',84817.89,87588.18,2770.29,451557.27,0.00,0.00,0.00,0.00,0.00),('1','113','823','182996',3591545,'2335','356',87681.00,87681.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182996',3591546,'2336','356',402441.95,402441.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','182996',3591547,'2337','356',496113.88,498301.51,2187.63,356583.69,0.00,0.00,0.00,0.00,0.00),('1','113','824','182996',3591548,'2338','357',1278430.47,1282990.07,4559.60,1117102.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','182996',3591549,'2339','357',2494527.49,2498849.70,4322.21,1058941.45,0.00,0.00,0.00,0.00,0.00),('1','113','825','182996',3591550,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','182996',3591551,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183002',3591662,'2326','356',1379619.21,1379898.32,279.11,45494.93,0.00,0.00,0.00,0.00,0.00),('1','113','823','183002',3591663,'2327','356',512466.86,512468.26,1.40,228.20,0.00,0.00,0.00,0.00,0.00),('1','113','823','183002',3591664,'2328','356',303421.92,305972.78,2550.86,415790.18,0.00,0.00,0.00,0.00,0.00),('1','113','823','183002',3591665,'2329','356',530029.15,530029.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183002',3591666,'2330','356',932248.42,932248.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183002',3591667,'2331','356',621907.91,624047.30,2139.39,348720.57,0.00,0.00,0.00,0.00,0.00),('1','113','823','183002',3591668,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183002',3591669,'2333','356',1127002.16,1128942.24,1940.08,316233.04,0.00,0.00,0.00,0.00,0.00),('1','113','823','183002',3591670,'2334','356',87588.18,87588.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183002',3591671,'2335','356',87681.00,87681.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183002',3591672,'2336','356',402441.95,404201.49,1759.54,286805.02,0.00,0.00,0.00,0.00,0.00),('1','113','823','183002',3591673,'2337','356',498301.51,498301.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','183002',3591674,'2338','357',1282990.07,1285672.48,2682.41,657190.45,0.00,0.00,0.00,0.00,0.00),('1','113','824','183002',3591675,'2339','357',2498849.70,2500476.08,1626.38,398463.10,0.00,0.00,0.00,0.00,0.00),('1','113','825','183002',3591676,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','183002',3591677,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183006',3591751,'2326','356',1379898.32,1382791.15,2892.83,471531.29,0.00,0.00,0.00,0.00,0.00),('1','113','823','183006',3591752,'2327','356',512468.26,512468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183006',3591753,'2328','356',305972.78,306544.20,571.42,93141.46,0.00,0.00,0.00,0.00,0.00),('1','113','823','183006',3591754,'2329','356',530029.15,531397.11,1367.96,222977.48,0.00,0.00,0.00,0.00,0.00),('1','113','823','183006',3591755,'2330','356',932248.42,935260.17,3011.75,490915.25,0.00,0.00,0.00,0.00,0.00),('1','113','823','183006',3591756,'2331','356',624047.30,624047.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183006',3591757,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183006',3591758,'2333','356',1128942.24,1131059.62,2107.38,343502.94,0.00,0.00,10.00,0.00,0.00),('1','113','823','183006',3591759,'2334','356',87588.18,87588.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183006',3591760,'2335','356',87681.00,90187.18,2506.18,408507.34,0.00,0.00,0.00,0.00,0.00),('1','113','823','183006',3591761,'2336','356',404201.49,404201.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183006',3591762,'2337','356',498301.51,500765.79,2464.28,401677.64,0.00,0.00,0.00,0.00,0.00),('1','113','824','183006',3591763,'2338','357',1285672.48,1286112.42,439.94,107785.30,0.00,0.00,0.00,0.00,0.00),('1','113','824','183006',3591764,'2339','357',2500476.08,2502614.30,2138.22,523863.90,0.00,0.00,0.00,0.00,0.00),('1','113','825','183006',3591765,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','183006',3591766,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183246',3595937,'2326','356',1382791.15,1385689.03,2897.88,472354.44,0.00,0.00,0.00,0.00,0.00),('1','113','823','183246',3595938,'2327','356',512468.26,512468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183246',3595939,'2328','356',306544.20,309290.75,2746.55,447687.65,0.00,0.00,0.00,0.00,0.00),('1','113','823','183246',3595940,'2329','356',531397.11,531397.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183246',3595941,'2330','356',935260.17,935260.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183246',3595942,'2331','356',624047.30,624180.71,133.41,21745.83,0.00,0.00,0.00,0.00,0.00),('1','113','823','183246',3595943,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183246',3595944,'2333','356',1131059.62,1132984.17,1924.55,313701.65,0.00,0.00,0.00,0.00,0.00),('1','113','823','183246',3595945,'2334','356',87588.18,87588.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183246',3595946,'2335','356',90187.18,92651.30,2464.12,401651.56,0.00,0.00,0.00,0.00,0.00),('1','113','823','183246',3595947,'2336','356',404201.49,405011.42,809.93,132018.59,0.00,0.00,0.00,0.00,0.00),('1','113','823','183246',3595948,'2337','356',500765.79,500765.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','183246',3595949,'2338','357',1286112.42,1287788.87,1676.45,410730.25,0.00,0.00,0.00,0.00,0.00),('1','113','824','183246',3595950,'2339','357',2502614.30,2504749.80,2135.50,523197.50,0.00,0.00,0.00,0.00,0.00),('1','113','825','183246',3595951,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','183246',3595952,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183425',3599391,'2326','356',1385689.03,1388927.19,3238.16,527820.08,0.00,0.00,0.00,0.00,0.00),('1','113','823','183425',3599392,'2327','356',512468.26,512468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183425',3599393,'2328','356',309290.75,310655.39,1364.64,222436.32,0.00,0.00,0.00,0.00,0.00),('1','113','823','183425',3599394,'2329','356',531397.11,531397.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183425',3599395,'2330','356',935260.17,935260.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183425',3599396,'2331','356',624180.71,627622.00,3441.29,560930.27,0.00,0.00,0.00,0.00,0.00),('1','113','823','183425',3599397,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183425',3599398,'2333','356',1132984.17,1136113.64,3119.47,508473.61,0.00,0.00,10.00,0.00,0.00),('1','113','823','183425',3599399,'2334','356',87588.18,87589.41,1.23,200.49,0.00,0.00,0.00,0.00,0.00),('1','113','823','183425',3599400,'2335','356',92651.30,95673.93,3022.63,492688.69,0.00,0.00,0.00,0.00,0.00),('1','113','823','183425',3599401,'2336','356',405011.42,407356.14,2344.72,382189.36,0.00,0.00,0.00,0.00,0.00),('1','113','823','183425',3599402,'2337','356',500765.79,500765.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','183425',3599403,'2338','357',1287788.87,1290566.47,2777.60,680512.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','183425',3599404,'2339','357',2504749.80,2511277.09,6527.29,1599186.05,0.00,0.00,0.00,0.00,0.00),('1','113','825','183425',3599405,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','183425',3599406,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183429',3599411,'2326','356',1388927.19,1392108.32,3181.13,518524.19,0.00,0.00,0.00,0.00,0.00),('1','113','823','183429',3599412,'2327','356',512468.26,512468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183429',3599413,'2328','356',310655.39,310655.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183429',3599414,'2329','356',531397.11,533894.96,2497.85,407149.55,0.00,0.00,0.00,0.00,0.00),('1','113','823','183429',3599415,'2330','356',935260.17,937863.98,2603.81,424421.03,0.00,0.00,0.00,0.00,0.00),('1','113','823','183429',3599416,'2331','356',627622.00,627622.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183429',3599417,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183429',3599418,'2333','356',1136113.64,1136414.85,301.21,49097.23,0.00,0.00,0.00,0.00,0.00),('1','113','823','183429',3599419,'2334','356',87589.41,87589.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183429',3599420,'2335','356',95673.93,97982.31,2308.38,376265.94,0.00,0.00,0.00,0.00,0.00),('1','113','823','183429',3599421,'2336','356',407356.14,407356.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183429',3599422,'2337','356',500765.79,500765.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','183429',3599423,'2338','357',1290566.47,1292938.70,2372.23,581196.35,0.00,0.00,0.00,0.00,0.00),('1','113','824','183429',3599424,'2339','357',2511277.09,2514235.14,2958.05,724722.25,0.00,0.00,0.00,0.00,0.00),('1','113','825','183429',3599425,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','183429',3599426,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183641',3603270,'2326','356',1392108.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183641',3603271,'2327','356',512468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183641',3603272,'2328','356',310655.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183641',3603273,'2329','356',533894.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183641',3603274,'2330','356',937863.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183641',3603275,'2331','356',627622.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183641',3603276,'2332','356',15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183641',3603277,'2333','356',1136414.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183641',3603278,'2334','356',87589.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183641',3603279,'2335','356',97982.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183641',3603280,'2336','356',407356.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183641',3603281,'2337','356',500765.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','183641',3603282,'2338','357',1292938.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','183641',3603283,'2339','357',2514235.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','183641',3603284,'2340','358',1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','183641',3603285,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183645',3603320,'2326','356',1392108.32,1395744.61,3636.29,592715.27,0.00,0.00,0.00,0.00,0.00),('1','113','823','183645',3603321,'2327','356',512468.26,512468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183645',3603322,'2328','356',310655.39,314082.41,3427.02,558604.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','183645',3603323,'2329','356',533894.96,533894.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183645',3603324,'2330','356',937863.98,937863.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183645',3603325,'2331','356',627622.00,631301.44,3679.44,599748.72,0.00,0.00,0.00,0.00,0.00),('1','113','823','183645',3603326,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183645',3603327,'2333','356',1136414.85,1138980.84,2565.99,418256.37,0.00,0.00,0.00,0.00,0.00),('1','113','823','183645',3603328,'2334','356',87589.41,87589.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183645',3603329,'2335','356',97982.31,101174.64,3192.33,520349.79,0.00,0.00,0.00,0.00,0.00),('1','113','823','183645',3603330,'2336','356',407356.14,410715.53,3359.39,547580.57,0.00,0.00,0.00,0.00,0.00),('1','113','823','183645',3603331,'2337','356',500765.79,500765.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','183645',3603332,'2338','357',1292938.70,1296123.64,3184.94,796235.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','183645',3603333,'2339','357',2514235.14,2517626.27,3391.13,847782.50,0.00,0.00,0.00,0.00,0.00),('1','113','825','183645',3603334,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','183645',3603335,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183646',3603336,'2326','356',1395744.61,1398536.76,2792.15,455120.45,0.00,0.00,0.00,0.00,0.00),('1','113','823','183646',3603337,'2327','356',512468.26,512468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183646',3603338,'2328','356',314082.41,314082.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183646',3603339,'2329','356',533894.96,536529.45,2634.49,429421.87,0.00,0.00,0.00,0.00,0.00),('1','113','823','183646',3603340,'2330','356',937863.98,937863.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183646',3603341,'2331','356',631301.44,633906.95,2605.51,424698.13,0.00,0.00,0.00,0.00,0.00),('1','113','823','183646',3603342,'2332','356',15445.47,15445.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183646',3603343,'2333','356',1138980.84,1141553.03,2572.19,419266.97,0.00,0.00,0.00,0.00,0.00),('1','113','823','183646',3603344,'2334','356',87589.41,87589.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183646',3603345,'2335','356',101174.64,101174.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183646',3603346,'2336','356',410715.53,412554.62,1839.09,299771.67,0.00,0.00,0.00,0.00,0.00),('1','113','823','183646',3603347,'2337','356',500765.79,500765.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','183646',3603348,'2338','357',1296123.64,1298007.82,1884.18,471045.00,0.00,0.00,0.00,0.00,0.00),('1','113','824','183646',3603349,'2339','357',2517626.27,2520754.91,3128.64,782160.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','183646',3603350,'2340','358',1949996.31,1949996.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','825','183646',3603351,'2341','358',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183648',3603368,'2326','356',1398536.76,1399111.42,574.66,93669.58,0.00,0.00,0.00,0.00,0.00),('1','113','823','183648',3603369,'2327','356',512468.26,512468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183648',3603370,'2328','356',314082.41,317884.43,3802.02,619729.26,0.00,0.00,0.00,0.00,0.00),('1','113','823','183648',3603371,'2329','356',536529.45,536529.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','113','823','183648',3603372,'2