-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_19_station_199
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_19_station_199`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_19_station_199` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_19_station_199`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3885 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3861,7000,'',0,'20','19','199','SALES ACCOUNT','Sales Account for Sales made','2021-11-20 08:30:14',5,0.00,0.00,'','713','2021-11-22 16:38:21','713',0,0),(3862,500,'',0,'6.1','19','199','CASH ACCOUNT','Cash ACCOUNT','2021-11-20 08:30:48',5,0.00,0.00,'','713','2021-11-20 08:30:48','713',0,0),(3863,8000,'',0,'24','19','199','PURCHASE ACCOUNT','PURCHASE ACCOUNT','2021-11-20 08:31:22',5,0.00,0.00,'','713','2021-11-20 08:31:22','713',0,0),(3864,8001,'',0,'24','19','199','SALARY /WAGE ACCOUNT','SALARY','2021-11-20 08:31:45',5,0.00,0.00,'','713','2021-11-20 08:31:45','713',0,0),(3883,2500,'',0,'2','19','199','Katsina Sales -UBA 1024633119','Sales account for Katsina','2021-11-24 13:26:25',5,0.00,100000.99,'2021-11-20','713','2021-12-02 10:48:12','713',0,0),(3884,2501,'',0,'2','19','199',' Sales -Sterling 0085304775','Katsina Sterling Sales Account','2022-03-21 15:02:46',5,127764.00,0.00,'2022-03-20','713','2022-03-21 15:04:11','713',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4173 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (4057,'','19','199','Sandton Petroleum Nigeria Limi','Engineer Zubairu','08080545325','sandtonpetroleumnigerialimited','Katsina','Katsina State','KM 1, Ibrahim Shehu Shema Express Way, G.R.A, Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-20 08:17:07',5,'717','2022-01-11 11:49:18','717'),(4128,'','19','199','Makudu Oil And Gas Ventures','Mr. Abbas Assababullah','08133057144','abbasassababullah@gmail.com','Katsina','Katsina State','5 Sabon Gida Jibia Roadf,Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-01 11:00:35',5,'717','2022-01-01 11:00:35','717'),(4129,'','19','199','MS Radda Gas','Jamalu Abdullahi ','08062264236','abdullahijamalu007@gmail.com ','Road F, Shagari Low cost, Kats','Katsina State','Road F, Shagari Low cost, Katsina ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-03 15:43:54',5,'717','2022-09-03 15:43:54','717'),(4130,'','19','199','Arewa Gas','Musa Lawal ','07039215583','musa331@gmail.com','Katsina','Katsina ','IBB WAY, KATSINA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-04 10:22:51',5,'717','2022-09-04 10:22:51','717'),(4131,'','19','199','A A Yamel','Abubakar Alkasim','08144673740','abubakaralkasim70@gmail.com','Katsina','Katsina ','Rahamawa Roundabout, Katsina ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-04 10:25:17',5,'717','2022-09-04 10:25:17','717'),(4132,'','19','199','BBK GAS','Musa Sani','08104185656','tmusasani@gmail.com','Katsina','Katsina','Kurfi, Nasrawa Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-05 10:42:22',5,'717','2022-10-05 10:42:22','717'),(4133,'','19','199','Hamza Galadima Building Materi','Hamza Ayuba Matazu','08167522227','abbanbilal01@gmail.com','Matazu','Katsina ','Shaskawa Gamji Along Musawa Road, Matazu','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-21 14:56:52',5,'717','2022-10-21 14:56:52','717'),(4134,'','19','199','Amana Gas','Bashir Usman Lado','08127242856','bashirusman19@gmail.com','Katsina','Katsina','New Ring Road, Kwado','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-27 08:40:15',5,'717','2022-10-27 08:40:15','717'),(4135,'','19','199','Jajaye Global Ventures','Sani Jubril Usman','08067136719','sanijubril@yahoo.com','Katsina','Katsina','Kiddies Round About, Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-27 08:44:58',5,'717','2022-10-27 08:44:58','717'),(4136,'','19','199','John Gas','John Nnamani','08066053867','johnblessed@gmail.com','Katsina','Katsina','Beside Borno Kitchen, Yahaya Madaki Way, Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-27 08:47:20',5,'717','2022-10-27 08:47:20','717'),(4137,'','19','199','Usman Gas','Usman Dahiru','08036239386','usmandahiru20@gmail.com','Katsina','Katsina','Sardauna Estate, Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-27 08:50:07',5,'717','2022-10-27 08:50:07','717'),(4138,'','19','199','AL Gas','Abu Lado','08109888259','abkladokatsina@gmail.com','Katsina','Katsina','Sabon Titi Kwado','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-27 08:52:13',5,'717','2022-10-27 08:52:13','717'),(4139,'','19','199','Collins Gini Gas','Collins Elechukwu Gini','08034472201','collinsgini@gmail.com','Sokoto ','Sokoto ','Emir\'s Road Sokoto','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-27 11:24:02',5,'717','2022-10-27 11:24:02','717'),(4140,'','19','199','Alhassan Gas','Hassan Abdullahi Saulawa','08061753601','abdullahihassan35@gmail.com','Katsina','Katsina','Kofar Marusa, Sarki Mukthar Road, Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 16:38:10',5,'717','2022-10-31 16:38:10','717'),(4141,'','19','199','Safe Cooking Gas','Saffullahi Lawal','08142731877','lawalsaffullahi57@gmail.com','Katsina','Katsina','Titi Rafindadi,Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 16:40:24',5,'717','2022-10-31 16:40:24','717'),(4142,'','19','199','AUK Gas','Auwal Abubakar','07065738865','aa7765189@gmail.com','Katsina','Katsina','Umar Musa Yar\'adua Way, Modoji,Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 16:42:21',5,'717','2022-10-31 16:42:21','717'),(4143,'','19','199','AM Gas','Mubarak Shuaibu','07064208777','mubarakshuaibu@gmail.com','Katsina','Katsina','Batagarawa, by Local Govt Secretariat','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 16:44:26',5,'717','2022-10-31 16:44:26','717'),(4144,'','19','199','Kusanchi Gas','Suleiman Musa','08064828109','suleimankusanchi@gmail.com','Katsina','Katsina','Kofar Murasu,Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-14 12:36:10',5,'717','2022-11-14 12:36:10','717'),(4145,'','19','199','Saulawa Gas','Abubakar Nasir','08166909904','abubakarnaseersih@gmail.com','Katsina','Katsina','Near Abu Shahada Plaza, Batsari,Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-14 12:39:04',5,'717','2022-11-14 12:39:04','717'),(4146,'','19','199','Abba Karamchi Gas','Abubakar Abba','08188771876','abba3065@gmail.com','Katsina','Katsina','Sabon titi Kwado,Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-14 12:41:06',5,'717','2022-11-14 12:41:06','717'),(4147,'','19','199','M.U.A Gas','Ahmad Ismail Idris','08031819820','ahmadismail@gmail.com','Katsina','Katsina','Sabon-titi Kwado,Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-14 12:44:59',5,'717','2022-11-14 12:44:59','717'),(4148,'','19','199','Fashion Gas','Sunusi Bishir','07037735142','sunusibishir@gmail.com','Katsina','Katsina','Sabon Ungwar Kofar Kaura, Layout Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-14 12:46:51',5,'717','2022-11-14 12:46:51','717'),(4149,'','19','199','Fashion- Gas','Sunusi Bishir','07037735142','sunusibishir@gmail.com','Katsina','Katsina','Sabon Ungwar Kofar Kaura, Layout Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-14 12:47:13',5,'717','2022-11-14 12:47:13','717'),(4150,'','19','199','DEE Gas','Ahmad Isah Bakori','08032589595','ahmadisah17@yahoo.com','Katsina','Katsina','Umar Musa Yar\'adua University,Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-14 12:51:30',5,'717','2022-11-14 12:51:30','717'),(4151,'','19','199','Sauki Gas','Rabe Ibrahim','08065220330','ri66173@gmail.com','Katsina','Katsina','Ungwar Yari Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-14 12:54:38',5,'717','2022-11-14 12:54:38','717'),(4152,'','19','199','Hikima Gas','Muhammad Mikail','07064933226','mikakt3@gmail.com','Katsina','Katsina','Filin Polo,Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-14 12:56:36',5,'717','2022-11-14 12:56:36','717'),(4153,'','19','199','Bukata Gas','Shamsudeen Inuwa','08037166942','shamsudeeninuwa@gmail.com','Katsina','Katsina','Mudashin Yan Nono','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-14 13:00:24',5,'717','2022-11-14 13:00:24','717'),(4154,'','19','199','Abdul Gas','Abduljabar Aliyu','08163940266','abduljabaraliyu@gmail.com','Katsina','Katsina','Fillin Polo Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-14 13:02:21',5,'717','2022-11-14 13:02:21','717'),(4155,'','19','199','Bakira Gas','Bakir Usman','07015310069','bakirusman@gmail.com','Katsina','Katsina','Masalanchi Kofar Marusa','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-14 13:04:29',5,'717','2022-11-14 13:04:29','717'),(4156,'','19','199','Ahmad Gas','Ahmad Abdullahi','08037517265','ahmmadgas090@gmail.com','Katsina','Katsina','Kofar Durbi, Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-14 13:06:38',5,'717','2022-11-14 13:06:38','717'),(4157,'','19','199','MBK Gas','Mubarak Lawal','08163994299','mubaraklawal640@gmail.com','Katsina','Katsina','Mani Road, Opposite Tourist Lodge,Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-14 13:09:07',5,'717','2022-11-14 13:09:07','717'),(4158,'','19','199','Yamel Gas','Awal Aminu','09091603211','aminuauwal1529@gmail.com','Katsina','Katsina','Opposite Umee bread,Layout Katsina, Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-07 15:54:23',5,'717','2023-03-07 15:54:23','717'),(4159,'','19','199','Salama Cooking Gas','Ibrahim Mansir','07031910490','mansiribrahim276@gmail.com','Katsina','Katsina','Karofi Area, Dutsima,Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-07 15:57:29',5,'717','2023-03-07 15:57:29','717'),(4160,'','19','199','BAS GAS GLOBAL VENTURES','Bashir Abubakar','08033819474','bashsabu@gmail.com','Katsina','Katsina','Sabontiti, Kwado,Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-07 15:59:21',5,'717','2023-03-07 15:59:21','717'),(4161,'','19','199','Musa Gas','Musa Ibrahim','08074057497','musaibrahim@gmail.com','Katsina','Katsina','Opposite Polo Ground, Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-07 16:01:12',5,'717','2023-03-07 16:01:12','717'),(4162,'','19','199','Alheri Cooking Gas','Abdulsalam Mahmuda','08106047900','salamuda20@gmail.com','Rimi','Katsina','Rimi Local Govt, Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-07 16:03:06',5,'717','2023-03-07 16:03:06','717'),(4163,'','19','199','A&S Best Gas Limited','Hamza Ibrahim','07061633041','hamzaradda52@gmail.com','Katsina','Katsina','Dandagoro Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-07 16:05:17',5,'717','2023-03-07 16:05:17','717'),(4164,'','19','199','Group Page Gas','Dahiru Hassan','08035981664','dahiruhassan81@gmail.com','Katsina','Katsina','Adjacent, Kokiya Filling Station, Kofar Marusa, Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-07 16:07:08',5,'717','2023-03-07 16:07:08','717'),(4165,'','19','199','I.B Gas','Bello Taiwo Ibrahim','09067474231','tayebello9@gmail.com','Dutsinma','Katsina','University Road, Off Kankara Exp, Dutsinma, Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-07 16:09:17',5,'717','2023-03-07 16:09:17','717'),(4166,'','19','199','NYSC Katsina','Sani Tukur','08060299080','oseimora@yahoo.com','Katsina','Katsina','15, Old Mani Road, NYSC Camp,Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-07 16:12:03',5,'717','2023-03-07 16:12:03','717'),(4167,'','19','199','Albis Gas','Naziru Mohammed','09039348983','nazirumamanbabaaski@gmail.com','Batsari','Katsina','Batsari Local Govt, Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-07 16:14:06',5,'717','2023-03-07 16:14:06','717'),(4168,'','19','199','UK Cooking Gas','Tasiu Sani','08036254459','tsgas77@gmail.com','Katsina','Katsina','Opposite G.R.A Central Mosque, Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-07 16:16:02',5,'717','2023-03-07 16:16:02','717'),(4169,'','19','199','IBB Gas','Ibrahim Ibrahim','08167482631','ibrahim2631@gmail.com','Katsina','Katsina','Sardauna Estate,Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-07 16:22:11',5,'717','2023-03-07 16:22:11','717'),(4170,'','19','199','Hamza Galadima Gas','Hamza Ayuba','08167522227','abbanbilal01@gmail.com','Matazu','Katsina','Shaskawa Gamji, Along Musawa Road, Matazu,Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-07 16:24:43',5,'717','2023-03-07 16:24:43','717'),(4171,'','19','199','Waskawa Gas','Aliyu Abdullahi','08161240654','aliyuabdullahi@gmail.com','Katsina','Katsina','Opposite, Barhim Estate,Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-07 16:27:22',5,'717','2023-03-07 16:27:22','717'),(4172,'','19','199','A.A Cooking Gas','Aminu Rabiu','08037467407','aminu9136@gmail.com','Katsina','Katsina','Kofar Sauri, Katsina','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-07 16:29:06',5,'717','2023-03-07 16:29:06','717');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3036 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('19','199','1023',3026,'5','DISPENSER 1 N1',220460.87,'DISPENSER N1','41',NULL,NULL,'',5,'2021-11-20 11:44:58','713'),('19','199','1023',3027,'5','DISPENSER 1 N2',458.50,'DISPENSER 1 N2','41',NULL,NULL,'',5,'2021-11-20 11:45:59','713'),('19','199','1023',3028,'5','DISPENSER 2 N3',50.00,'DISPENSER 2 N3','42',NULL,NULL,'',5,'2021-12-07 05:31:01','717'),('19','199','1023',3029,'5','DISPENSER 2 N4',0.00,'DISPENSER 2 N4','42',NULL,NULL,'',5,'2021-11-20 11:49:13','713'),('19','199','1023',3030,'5','DISPENSER 3 N5',12.50,'DISPENSER 3 N5','43',NULL,NULL,'',5,'2021-11-20 11:50:48','713'),('19','199','1023',3031,'5','DISPENSER 3 N6',0.00,'DISPENSER 3 N6','43',NULL,NULL,'',5,'2021-11-20 11:55:04','713'),('19','199','1023',3032,'5','DISPENSER 4 N7',0.00,'DISPENSER 4 N7','44',NULL,NULL,'',5,'2021-11-20 11:55:28','713'),('19','199','1023',3033,'5','DISPENSER 5 N8',0.00,'DISPENSER 5N8','45',NULL,NULL,'',5,'2021-11-20 11:58:32','713'),('19','199','1023',3034,'5','MASS FLOW METER',6.25,'FLOW METER','46',NULL,NULL,'',5,'2021-11-20 12:03:01','713'),('19','199','1024',3035,'5','Dispenser 1 N1 on Tank 2 (40MT)',28242.25,'Dispenser 1N1 on Tank 2 (40MT)','41',NULL,NULL,'',5,'2023-02-02 09:33:29','717');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=360 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (343,'19','199','3026','1024','Bulk switch','2021-11-20 09:06:50',0,'713'),(344,'19','199','3027','1024','Bulk switch','2021-11-20 09:06:50',0,'713'),(345,'19','199','3028','1024','Bulk switch','2021-11-20 09:06:50',0,'713'),(346,'19','199','3029','1024','Bulk switch','2021-11-20 09:06:50',0,'713'),(347,'19','199','3030','1024','Bulk switch','2021-11-20 09:06:50',0,'713'),(348,'19','199','3031','1024','Bulk switch','2021-11-20 09:06:50',0,'713'),(349,'19','199','3032','1024','Bulk switch','2021-11-20 09:06:50',0,'713'),(350,'19','199','3033','1024','Bulk switch','2021-11-20 09:06:50',0,'713'),(351,'19','199','3026','1023','Bulk switch','2021-11-20 10:22:27',0,'713'),(352,'19','199','3027','1023','Bulk switch','2021-11-20 10:22:27',0,'713'),(353,'19','199','3028','1023','Bulk switch','2021-11-20 10:22:27',0,'713'),(354,'19','199','3029','1023','Bulk switch','2021-11-20 10:22:27',0,'713'),(355,'19','199','3030','1023','Bulk switch','2021-11-20 10:22:27',0,'713'),(356,'19','199','3031','1023','Bulk switch','2021-11-20 10:22:27',0,'713'),(357,'19','199','3032','1023','Bulk switch','2021-11-20 10:22:27',0,'713'),(358,'19','199','3033','1023','Bulk switch','2021-11-20 10:22:27',0,'713'),(359,'19','199','3034','1023','Bulk switch','2021-11-20 18:45:44',0,'717');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
INSERT INTO `depots_pumps` VALUES ('19','199',41,'DAESUNG MECHATRON CO. LTD','DMS 200S','DISPENSER 1','','','','713','2021-11-20 08:57:31','2021-11-20 08:57:31','713',5),('19','199',42,'DAESUNG MECHATRON CO. LTD','DMS 200S','DISPENSER 2','','','','713','2021-11-20 08:58:06','2021-11-20 08:58:06','713',5),('19','199',43,'DAESUNG MECHATRON CO. LTD','DMS 1200S','DISPENSER 3','','','','713','2021-11-20 08:58:46','2021-11-20 08:58:46','713',5),('19','199',44,'JIANGSU XIANGKANG  TECHNOLOGY CO.LTD','S-TCS-YG','DISPENSER 4','','','','713','2021-11-20 09:00:07','2021-11-20 09:00:39','713',5),('19','199',45,'JIANGSU XIANGKANG  TECHNOLOGY CO.LTD','S-TCS-YG','DISPENSER 5','','','','713','2021-11-20 09:01:03','2021-11-20 09:01:03','713',5),('19','199',46,'EUROPUMP ','R500','MASS FLOW METER','','','','713','2021-11-20 12:01:25','2021-11-20 12:01:25','713',5);
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257937 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('19','199',244292,'Retail(Work-in Customer\'s Selling price)','2021-12-07','2021-12-07 00:00:00',NULL,'717',0.00,0.00,'717','2021-12-07 19:18:46','717','2021-12-07 19:23:14',10,0),('19','199',244573,'Retail(Work-in Customer\'s Sales price)','2021-12-07','2021-12-07 00:00:00',NULL,'717',0.00,0.00,'717','2021-12-09 03:02:30','717','2021-12-09 03:08:24',10,0),('19','199',244720,'Wednesday,09 DEC,2021','2021-12-09','2021-12-09 00:00:00',NULL,'717',0.00,0.00,'717','2021-12-10 07:46:09','717','2021-12-10 07:46:50',10,0),('19','199',245024,'Friday 10th of DEC,2021','2021-12-10','2021-12-10 00:00:00',NULL,'717',0.00,0.00,'717','2021-12-11 05:05:45','717','2021-12-11 05:08:03',10,0),('19','199',245249,'Saturday,11th of December, Sales','2021-12-11','2021-12-11 00:00:00',NULL,'717',0.00,0.00,'717','2021-12-13 10:19:57','717','2021-12-13 10:21:05',10,0),('19','199',245760,'Monday,13th of December Sales','2021-12-13','2021-12-13 00:00:00',NULL,'717',0.00,0.00,'717','2021-12-14 07:14:07','717','2021-12-14 07:15:41',10,0),('19','199',245976,'Tuesday, December,14th Transactions','2021-12-14','2021-12-14 00:00:00',NULL,'717',0.00,0.00,'717','2021-12-14 17:32:45','717','2021-12-14 17:33:21',10,0),('19','199',246228,'Wednesday,15th of December,2021','2021-12-15','2021-12-15 00:00:00',NULL,'717',0.00,0.00,'717','2021-12-16 08:13:55','717','2021-12-16 08:14:39',10,0),('19','199',246511,'Thursday 16th December,2021 Sales Transaction. ','2021-12-16','2021-12-16 00:00:00',NULL,'717',0.00,0.00,'717','2021-12-16 18:14:30','717','2021-12-16 18:14:51',10,0),('19','199',246748,'Sales (Change of Price for Street Retailers)','2021-12-17','2021-12-17 00:00:00',NULL,'719',0.00,0.00,'717','2021-12-18 06:22:30','717','2021-12-18 06:22:56',10,0),('19','199',246946,'Saturday,18th of Dec,2021','2021-12-18','2021-12-18 00:00:00',NULL,'717',0.00,0.00,'717','2021-12-20 07:27:14','717','2021-12-20 07:27:35',10,0),('19','199',247442,'Monday, 20th of December 2021','2021-12-20','2021-12-20 00:00:00',NULL,'717',0.00,0.00,'717','2021-12-21 07:26:27','717','2021-12-21 07:26:55',10,0),('19','199',247697,'Tuesday, December 21st 2021','2021-12-21','2021-12-21 00:00:00',NULL,'717',0.00,0.00,'717','2021-12-22 07:24:22','717','2021-12-22 07:24:44',10,0),('19','199',247948,'Wednesday,22nd of December,2021','2021-12-22','2021-12-22 00:00:00',NULL,'717',0.00,0.00,'717','2021-12-23 07:53:35','717','2021-12-23 07:53:55',10,0),('19','199',248209,'Thursday ,December 23rd 2021 Sales ','2021-12-23','2021-12-23 00:00:00',NULL,'717',0.00,0.00,'717','2021-12-24 07:35:42','717','2021-12-24 07:36:06',10,0),('19','199',248442,'Friday 24th of December 2021','2021-12-24','2021-12-24 00:00:00',NULL,'717',0.00,0.00,'717','2021-12-25 07:18:55','717','2021-12-25 07:19:18',10,0),('19','199',248675,'Saturday 25th of December,2021','2021-12-25','2021-12-25 00:00:00',NULL,'717',0.00,0.00,'717','2021-12-26 07:39:23','717','2021-12-26 07:39:52',10,0),('19','199',248908,'Sunday 26th of December,2021','2021-12-26','2021-12-26 00:00:00',NULL,'717',0.00,0.00,'717','2021-12-27 07:22:25','717','2021-12-27 07:22:46',10,0),('19','199',249150,'Monday 27th of December 2021','2021-12-27','2021-12-27 00:00:00',NULL,'717',0.00,0.00,'717','2021-12-28 07:26:10','717','2021-12-28 07:26:57',10,0),('19','199',249389,'Tuesday 28th of December 2021','2021-12-28','2021-12-28 00:00:00',NULL,'717',0.00,0.00,'717','2021-12-29 07:30:27','717','2021-12-29 07:30:54',10,0),('19','199',249632,'Thursday 29th of December 2021','2021-12-29','2021-12-29 00:00:00',NULL,'717',0.00,0.00,'717','2021-12-30 07:21:01','717','2021-12-30 07:21:15',10,0),('19','199',249892,'Friday 30th of December, 2021','2021-12-30','2021-12-30 00:00:00',NULL,'717',0.00,0.00,'717','2021-12-31 07:24:21','717','2021-12-31 07:24:36',10,0),('19','199',250137,'Friday 31st of December, 2021..','2021-12-31','2021-12-31 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-01 07:18:15','717','2022-01-01 07:18:38',10,0),('19','199',250363,'Saturday 1st January 2022','2022-01-01','2022-01-01 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-01 15:28:12','717','2022-01-02 07:48:54',10,0),('19','199',250596,'Sunday 2nd of January 2022','2022-01-02','2022-01-02 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-02 17:51:38','717','2022-01-02 18:19:07',10,0),('19','199',250836,'Monday 3rd of January 2022','2022-01-03','2022-01-03 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-04 07:45:34','717','2022-01-04 07:46:02',10,0),('19','199',251067,'Tuesday 4th of January 2022','2022-01-04','2022-01-04 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-04 17:21:26','717','2022-01-04 17:21:54',10,0),('19','199',251309,'Wednesday 5th of January,2022','2022-01-05','2022-01-05 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-06 08:34:17','717','2022-01-06 08:38:32',10,0),('19','199',251567,'Thursday 6th of January 2022','2022-01-06','2022-01-06 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-07 08:52:18','717','2022-01-07 08:54:35',10,0),('19','199',251813,'Friday 7th of January 2022','2022-01-07','2022-01-07 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-08 09:49:09','717','2022-01-08 09:51:36',10,0),('19','199',252048,'Saturday 8th day of January 2022','2022-01-08','2022-01-08 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-09 08:51:46','717','2022-01-09 08:52:12',10,0),('19','199',252272,'Sunday 9th of January 2022','2022-01-09','2022-01-09 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-10 08:39:33','717','2022-01-10 08:40:27',10,0),('19','199',252522,'Monday 10th of January 2022','2022-01-10','2022-01-10 00:00:00',NULL,'717',0.00,0.00,'719','2022-01-11 09:26:45','717','2022-01-11 09:31:01',10,0),('19','199',252776,'Tuesday 11th of January 2022','2022-01-11','2022-01-11 00:00:00',NULL,'717',0.00,0.00,'719','2022-01-11 17:47:43','717','2022-01-12 07:43:47',10,0),('19','199',252988,'Wednesday 12th of January 2022','2022-01-12','2022-01-12 00:00:00',NULL,'717',0.00,0.00,'719','2022-01-12 20:11:18','717','2022-01-13 08:30:48',10,0),('19','199',253243,'Thursday 13th of January 2022','2022-01-13','2022-01-13 00:00:00',NULL,'717',0.00,0.00,'719','2022-01-13 19:25:13','717','2022-01-14 08:47:26',10,0),('19','199',253519,'Friday 14th of January 2022','2022-01-14','2022-01-14 00:00:00',NULL,'717',0.00,0.00,'719','2022-01-14 17:43:25','717','2022-01-15 08:19:00',10,0),('19','199',253743,'Saturday 15th of January 2022','2022-01-15','2022-01-15 00:00:00',NULL,'717',0.00,0.00,'719','2022-01-15 18:16:23','717','2022-01-16 08:03:31',10,0),('19','199',253981,'Sunday 16th of January 2022','2022-01-16','2022-01-16 00:00:00',NULL,'717',0.00,0.00,'719','2022-01-16 17:38:05','717','2022-01-17 08:40:05',10,0),('19','199',254249,'Monday 17th of January 2022','2022-01-17','2022-01-17 00:00:00',NULL,'717',0.00,0.00,'719','2022-01-17 19:18:37','717','2022-01-18 08:27:47',10,0),('19','199',254483,'Tuesday  18th of January 2022','2022-01-18','2022-01-18 00:00:00',NULL,'717',0.00,0.00,'719','2022-01-18 19:30:06','717','2022-01-19 07:26:52',10,0),('19','199',254709,'Wednesday 19th of January 2022','2022-01-19','2022-01-19 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-20 08:46:12','717','2022-01-20 08:46:34',10,0),('19','199',254997,'Thursday 20th of January 2022','2022-01-20','2022-01-20 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-21 08:29:21','717','2022-01-21 08:30:28',10,0),('19','199',255227,'Friday 21st of January 2022','2022-01-21','2022-01-21 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-22 08:50:35','717','2022-01-22 08:52:05',10,0),('19','199',255505,'Saturday 22nd of January 2022','2022-01-22','2022-01-22 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-23 08:39:05','717','2022-01-23 08:39:35',10,0),('19','199',255745,'Sunday 23rd of January 2022','2022-01-23','2022-01-23 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-24 07:33:42','717','2022-01-24 07:34:19',10,0),('19','199',255963,'Monday 24th of January 2022','2022-01-24','2022-01-24 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-25 08:26:05','717','2022-01-25 08:26:26',10,0),('19','199',256243,'Tuesday 25th of January 2022','2022-01-25','2022-01-25 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-26 08:18:45','717','2022-01-26 08:19:21',10,0),('19','199',256520,'Wednesday 26th of January 2022','2022-01-26','2022-01-26 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-27 08:31:26','717','2022-01-27 08:31:58',10,0),('19','199',256763,'Tuesday, 27th of January 2022','2022-01-27','2022-01-27 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-27 18:49:11','717','2022-01-27 18:52:12',10,0),('19','199',257003,'Friday 28th of January 2022','2022-01-28','2022-01-28 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-29 08:34:56','717','2022-01-29 08:35:31',10,0),('19','199',257272,'Saturday 29th of January 2022','2022-01-29','2022-01-29 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-30 08:51:51','717','2022-01-30 08:52:40',10,0),('19','199',257528,'Sunday 30th of January 2022','2022-01-30','2022-01-30 00:00:00',NULL,'717',0.00,0.00,'717','2022-01-31 06:07:45','717','2022-01-31 06:08:02',10,0),('19','199',257529,'Monday  31st of January 2022','2022-01-31','2022-01-31 00:00:00',NULL,'717',0.00,0.00,'717','2022-02-01 08:07:30','717','2022-02-01 08:07:48',10,0),('19','199',257530,'Tuesday  1st of February 2022','2022-02-01','2022-02-01 00:00:00',NULL,'717',0.00,0.00,'717','2022-02-02 08:21:32','717','2022-02-02 08:21:53',10,0),('19','199',257531,'Wednesday 2nd of February ,2022','2022-02-02','2022-02-02 00:00:00',NULL,'717',0.00,0.00,'717','2022-02-03 08:17:58','717','2022-02-03 08:18:15',10,0),('19','199',257532,'Thursday 3rd of February 2022','2022-02-03','2022-02-03 00:00:00',NULL,'717',0.00,0.00,'717','2022-02-04 08:32:31','717','2022-02-04 08:32:48',10,0),('19','199',257533,'Friday 4th of February 2022','2022-02-04','2022-02-04 00:00:00',NULL,'717',0.00,0.00,'717','2022-02-05 08:34:44','717','2022-02-05 08:35:02',10,0),('19','199',257534,'Saturday 5th of February 2022','2022-02-05','2022-02-05 00:00:00',NULL,'717',0.00,0.00,'717','2022-02-06 08:45:23','717','2022-02-06 08:45:35',10,0),('19','199',257535,'Sunday 6th of February 2022','2022-02-06','2022-02-06 00:00:00',NULL,'717',0.00,0.00,'717','2022-02-07 07:44:08','717','2022-02-07 07:44:23',10,0),('19','199',257536,'Monday 7th of February 2022','2022-02-07','2022-02-07 00:00:00',NULL,'717',0.00,0.00,'717','2022-02-08 07:01:05','717','2022-02-08 07:01:27',10,0),('19','199',257537,'Tuesday  8th of February 2022','2022-02-08','2022-02-08 00:00:00',NULL,'717',0.00,0.00,'717','2022-02-09 06:45:18','717','2022-02-09 06:45:32',10,0),('19','199',257538,'Wednesday 9th of February 2022','2022-02-09','2022-02-09 00:00:00',NULL,'717',0.00,0.00,'717','2022-02-10 08:20:33','717','2022-02-10 08:21:57',10,0),('19','199',257539,'Thursday 10th of February,2022','2022-02-10','2022-02-10 00:00:00',NULL,'717',0.00,0.00,'717','2022-02-11 08:29:44','717','2022-02-11 08:29:57',10,0),('19','199',257540,'Friday 11th of February 2022','2022-02-11','2022-02-11 00:00:00',NULL,'717',0.00,0.00,'717','2022-02-12 06:46:57','717','2022-02-12 06:47:22',10,0),('19','199',257541,'Saturday 12th of February 2022','2022-02-12','2022-02-12 00:00:00',NULL,'717',0.00,0.00,'717','2022-02-13 07:58:08','717','2022-02-13 07:58:26',10,0),('19','199',257542,'Sunday  13th of February 2022','2022-02-13','2022-02-13 00:00:00',NULL,'717',0.00,0.00,'717','2022-02-14 08:59:42','717','2022-02-14 09:00:03',10,0),('19','199',257543,'Monday 14th of February 2022','2022-02-14','2022-02-14 00:00:00',NULL,'717',0.00,0.00,'717','2022-02-15 08:28:03','717','2022-02-15 08:28:21',10,0),('19','199',257544,'Tuesday 15th of February 2022','2022-02-15','2022-02-15 00:00:00',NULL,'717',0.00,0.00,'717','2022-02-16 08:32:01','717','2022-02-16 08:32:15',10,0),('19','199',257545,'Wednesday 16th February 2022','2022-02-16','2022-02-16 00:00:00',NULL,'717',0.00,0.00,'717','2022-02-17 07:47:32','717','2022-02-17 07:48:11',10,0),('19','199',257546,'Thursday 17th of February 2022','2022-02-17','2022-02-17 00:00:00',NULL,'717',0.00,0.00,'717','2022-02-18 08:27:53','717','2022-02-18 08:28:09',10,0),('19','199',257547,'Friday 18th of February 2022','2022-02-18','2022-02-18 00:00:00',NULL,'717',0.00,0.00,'719','2022-02-18 18:43:24','717','2022-02-19 08:00:46',10,0),('19','199',257548,'Saturday 19th of February 2022','2022-02-19','2022-02-19 00:00:00',NULL,'717',0.00,0.00,'717','2022-02-20 08:57:43','717','2022-02-20 08:57:58',10,0),('19','199',257549,'Sunday 20th of February 2022','2022-02-20','2022-02-20 00:00:00',NULL,'717',0.00,0.00,'717','2022-02-21 08:45:20','717','2022-02-21 08:46:04',10,0),('19','199',257550,'Monday 21st of February 2022','2022-02-21','2022-02-21 00:00:00',NULL,'717',0.00,0.00,'717','2022-02-22 08:46:56','717','2022-02-22 08:47:25',10,0),('19','199',257551,'Tuesday February 22nd 2022','2022-02-22','2022-02-22 08:48:57','2022-02-23 08:48:57','717',0.00,0.00,'717','2022-02-23 08:20:02','717','2022-02-23 08:20:21',10,0),('19','199',257552,'Wednesday 23rd February 2022','2022-02-23','2022-02-23 08:21:55','2022-02-24 08:21:55','717',0.00,0.00,'717','2022-02-24 07:59:25','717','2022-02-24 07:59:44',10,0),('19','199',257553,'Thursday 24th of February 2022','2022-02-24','2022-02-24 08:00:59','2022-02-25 08:00:59','717',0.00,0.00,'717','2022-02-25 08:09:35','717','2022-02-25 08:09:53',10,0),('19','199',257554,'Friday 25th of February 2022','2022-02-25','2022-02-25 08:10:36','2022-02-26 08:10:36','717',0.00,0.00,'717','2022-02-26 08:33:41','717','2022-02-26 08:33:59',10,0),('19','199',257555,'Saturday 26th of February 2022','2022-02-26','2022-02-26 08:34:47','2022-02-27 08:34:47','717',0.00,0.00,'717','2022-02-27 08:30:56','717','2022-02-27 08:31:17',10,0),('19','199',257556,'Sunday 27th of February 2022','2022-02-27','2022-02-27 08:32:14','2022-02-28 08:32:14','717',0.00,0.00,'717','2022-02-28 08:12:50','717','2022-02-28 08:13:15',10,0),('19','199',257557,'Monday 28th of February 2022','2022-02-28','2022-02-28 08:14:17','2022-03-01 08:14:17','717',0.00,0.00,'717','2022-03-01 02:55:46','717','2022-03-01 02:56:11',10,0),('19','199',257558,'Tuesday 1st of March 2022','2022-03-01','2022-03-01 03:20:21','2022-03-02 03:20:21','717',0.00,0.00,'717','2022-03-02 09:28:07','717','2022-03-02 09:28:27',10,0),('19','199',257559,'Wednesday 2nd of March,2022','2022-03-02','2022-03-02 09:30:31','2022-03-03 09:30:31','717',0.00,0.00,'717','2022-03-03 07:51:42','717','2022-03-03 07:52:04',10,0),('19','199',257560,'Thursday 3rd of March 2022','2022-03-03','2022-03-03 07:53:19','2022-03-04 07:53:19','717',0.00,0.00,'717','2022-03-04 08:34:55','717','2022-03-04 08:35:28',10,0),('19','199',257561,'Friday 4th of March,2022','2022-03-04','2022-03-04 08:36:59','2022-03-05 08:36:59','717',0.00,0.00,'717','2022-03-04 19:18:49','717','2022-03-04 19:19:40',10,0),('19','199',257562,'Saturday 5th of March,2022 ','2022-03-05','2022-03-05 06:06:35','2022-03-06 06:06:35','717',0.00,0.00,'717','2022-03-06 06:28:58','717','2022-03-06 06:29:18',10,0),('19','199',257563,'Sunday 6th of March 2022','2022-03-06','2022-03-06 06:30:06','2022-03-07 06:30:06','717',0.00,0.00,'717','2022-03-07 16:21:00','717','2022-03-07 16:21:17',10,0),('19','199',257564,'Monday 7th of March 2022','2022-03-07','2022-03-07 16:22:06','2022-03-08 16:22:06','717',0.00,0.00,'717','2022-03-08 09:53:55','717','2022-03-08 09:54:27',10,0),('19','199',257565,'Tuesday 8th of March 2022','2022-03-08','2022-03-08 09:55:24','2022-03-09 09:55:24','717',0.00,0.00,'717','2022-03-09 06:19:08','717','2022-03-09 06:19:33',10,0),('19','199',257566,'Wednesday 9th of March,2022','2022-03-09','2022-03-09 06:20:32','2022-03-10 06:20:32','717',0.00,0.00,'717','2022-03-10 08:24:17','717','2022-03-10 08:25:00',10,0),('19','199',257567,'Thursday 10th of March,2022','2022-03-10','2022-03-10 08:26:03','2022-03-11 08:26:03','717',0.00,0.00,'717','2022-03-10 21:03:27','717','2022-03-10 21:04:08',10,0),('19','199',257568,'Friday 11th of March 2022','2022-03-11','2022-03-11 06:24:56','2022-03-12 06:24:56','717',0.00,0.00,'717','2022-03-11 19:57:54','717','2022-03-11 19:58:18',10,0),('19','199',257569,'Saturday 12th of March 2022','2022-03-12','2022-03-12 08:45:55','2022-03-13 08:45:55','717',0.00,0.00,'717','2022-03-13 03:10:23','717','2022-03-13 03:10:39',10,0),('19','199',257570,'Sunday  13th of March 2022','2022-03-13','2022-03-13 03:12:41','2022-03-14 03:12:41','717',0.00,0.00,'717','2022-03-14 08:34:53','717','2022-03-14 08:35:12',10,0),('19','199',257571,'Monday 14th of March 2022','2022-03-14','2022-03-14 08:36:02','2022-03-15 08:36:02','717',0.00,0.00,'717','2022-03-15 08:39:02','717','2022-03-15 08:39:43',10,0),('19','199',257572,'15th of March, 2022','2022-03-15','2022-03-15 08:40:44','2022-03-16 08:40:44','717',0.00,0.00,'717','2022-03-16 08:53:55','717','2022-03-16 08:54:15',10,0),('19','199',257573,'Wednesday 16th of March,2022','2022-03-16','2022-03-16 08:55:15','2022-03-17 08:55:15','717',0.00,0.00,'717','2022-03-17 07:06:13','717','2022-03-17 07:06:35',10,0),('19','199',257574,'Thursday 17th of March 2022','2022-03-17','2022-03-17 07:07:20','2022-03-18 07:07:20','717',0.00,0.00,'717','2022-03-18 07:00:41','717','2022-03-18 07:01:02',10,0),('19','199',257575,'Friday 18th of March 2022','2022-03-18','2022-03-18 07:01:59','2022-03-19 07:01:59','717',0.00,0.00,'717','2022-03-19 08:03:37','717','2022-03-19 08:03:59',10,0),('19','199',257576,'Saturday 19th of March 2022','2022-03-19','2022-03-19 08:04:42','2022-03-20 08:04:42','717',0.00,0.00,'717','2022-03-20 05:30:59','717','2022-03-20 05:31:21',10,0),('19','199',257577,'Sunday 20th of March 2022','2022-03-20','2022-03-20 05:32:03','2022-03-21 05:32:03','717',0.00,0.00,'717','2022-03-21 09:00:11','717','2022-03-21 09:00:26',10,0),('19','199',257578,'Monday 21st of March 2022','2022-03-21','2022-03-21 09:02:26','2022-03-22 09:02:26','717',0.00,0.00,'717','2022-03-22 08:14:35','717','2022-03-22 08:27:27',10,0),('19','199',257579,'Tuesday 22nd of March 2022','2022-03-22','2022-03-22 08:28:18','2022-03-23 08:28:18','717',0.00,0.00,'717','2022-03-23 07:34:06','717','2022-03-23 07:34:29',10,0),('19','199',257580,'Wednesday 23rd March 2022','2022-03-23','2022-03-23 07:35:26','2022-03-24 07:35:26','717',0.00,0.00,'717','2022-03-24 01:22:23','717','2022-03-24 01:23:47',10,0),('19','199',257581,'Thursday 24th of March 2022','2022-03-24','2022-03-24 01:52:08','2022-03-25 01:52:08','717',0.00,0.00,'717','2022-03-25 08:13:23','717','2022-03-25 08:13:53',10,0),('19','199',257582,'Friday 25th of March 2022','2022-03-25','2022-03-25 08:15:05','2022-03-26 08:15:05','717',0.00,0.00,'717','2022-03-26 07:52:35','717','2022-03-26 07:52:49',10,0),('19','199',257583,'Saturday 26th of March 2022','2022-03-26','2022-03-26 07:53:39','2022-03-27 07:53:39','717',0.00,0.00,'717','2022-03-27 07:39:56','717','2022-03-27 07:40:31',10,0),('19','199',257584,'Sunday 27th of March 2022','2022-03-27','2022-03-27 07:41:29','2022-03-28 07:41:29','717',0.00,0.00,'717','2022-03-28 08:22:46','717','2022-03-28 08:23:06',10,0),('19','199',257585,'Monday 28th of March 2022','2022-03-28','2022-03-28 08:23:49','2022-03-29 08:23:49','717',0.00,0.00,'717','2022-03-29 08:29:48','717','2022-03-29 08:30:46',10,0),('19','199',257586,'Tuesday 29th March,2022 ','2022-03-29','2022-03-29 08:32:14','2022-03-30 08:32:14','717',0.00,0.00,'717','2022-03-30 08:22:07','717','2022-03-30 08:22:31',10,0),('19','199',257587,'Wednesday 30th of March 2022','2022-03-30','2022-03-30 08:23:20','2022-03-31 08:23:20','717',0.00,0.00,'717','2022-03-31 08:15:15','717','2022-03-31 08:15:32',10,0),('19','199',257588,'Thursday 31st of March 2022','2022-03-31','2022-03-31 08:16:12','2022-04-01 08:16:12','717',0.00,0.00,'717','2022-04-01 07:46:12','717','2022-04-01 07:46:29',10,0),('19','199',257589,'Friday 1st of April 2022','2022-04-01','2022-04-01 07:47:54','2022-04-02 07:47:54','717',0.00,0.00,'717','2022-04-02 07:54:49','717','2022-04-02 07:55:13',10,0),('19','199',257590,'Saturday 2nd of April 2022','2022-04-02','2022-04-02 07:56:49','2022-04-03 07:56:49','717',0.00,0.00,'717','2022-04-03 08:26:23','717','2022-04-03 08:26:40',10,0),('19','199',257591,'Sunday 3rd of April 2022','2022-04-03','2022-04-03 08:27:23','2022-04-04 08:27:23','717',0.00,0.00,'717','2022-04-04 07:30:27','717','2022-04-04 07:30:55',10,0),('19','199',257592,'Monday 4th of March 2022','2022-04-04','2022-04-04 07:31:50','2022-04-05 07:31:50','717',0.00,0.00,'717','2022-04-05 08:38:57','717','2022-04-05 08:39:20',10,0),('19','199',257593,'Tuesday  5th of March 2022','2022-04-05','2022-04-05 08:42:03','2022-04-06 08:42:03','717',0.00,0.00,'717','2022-04-06 09:36:04','717','2022-04-06 09:36:21',10,0),('19','199',257594,'Wednesday 6t of April,2022','2022-04-06','2022-04-06 09:37:20','2022-04-07 09:37:20','717',0.00,0.00,'717','2022-04-07 08:23:20','717','2022-04-07 08:23:43',10,0),('19','199',257595,'Thursday 7th of April 2022','2022-04-07','2022-04-07 08:24:41','2022-04-08 08:24:41','717',0.00,0.00,'717','2022-04-08 09:03:07','717','2022-04-08 09:03:23',10,0),('19','199',257596,'Friday 8th of April 2022','2022-04-08','2022-04-08 09:04:16','2022-04-09 09:04:16','717',0.00,0.00,'717','2022-04-09 08:43:19','717','2022-04-09 08:43:50',10,0),('19','199',257597,'Saturday 9th of April 2022','2022-04-09','2022-04-09 08:44:42','2022-04-10 08:44:42','717',0.00,0.00,'717','2022-04-10 05:37:39','717','2022-04-10 05:38:00',10,0),('19','199',257598,'Sunday  10th of April 2022','2022-04-10','2022-04-10 05:38:49','2022-04-11 05:38:49','717',0.00,0.00,'717','2022-04-11 08:27:21','717','2022-04-11 08:27:45',10,0),('19','199',257599,'Monday 11th of April 2022','2022-04-11','2022-04-11 08:29:14','2022-04-12 08:29:14','717',0.00,0.00,'717','2022-04-12 08:28:18','717','2022-04-12 08:28:39',10,0),('19','199',257600,'Tuesday  12th of April 2022','2022-04-12','2022-04-12 08:29:34','2022-04-13 08:29:34','717',0.00,0.00,'717','2022-04-13 06:20:11','717','2022-04-13 06:20:30',10,0),('19','199',257601,'Wednesday 13th of April 2022','2022-04-13','2022-04-13 06:21:33','2022-04-14 06:21:33','717',0.00,0.00,'717','2022-04-14 08:39:26','717','2022-04-14 08:39:48',10,0),('19','199',257602,'Thursday 14h of April 2022','2022-04-14','2022-04-14 08:40:53','2022-04-15 08:40:53','717',0.00,0.00,'717','2022-04-15 09:41:02','717','2022-04-15 09:41:21',10,0),('19','199',257603,'Friday 15th of April 2022','2022-04-15','2022-04-15 09:43:16','2022-04-16 09:43:16','717',0.00,0.00,'717','2022-04-16 08:59:48','717','2022-04-16 09:00:22',10,0),('19','199',257604,'Saturday 16th of April 2022','2022-04-16','2022-04-16 09:03:16','2022-04-17 09:03:16','717',0.00,0.00,'717','2022-04-17 08:33:37','717','2022-04-17 08:34:01',10,0),('19','199',257605,'Sunday 17th of April 2022','2022-04-17','2022-04-17 08:35:20','2022-04-18 08:35:20','717',0.00,0.00,'717','2022-04-18 06:32:27','717','2022-04-18 06:33:11',10,0),('19','199',257606,'Monday 18th of April 2022','2022-04-18','2022-04-18 06:34:12','2022-04-19 06:34:12','717',0.00,0.00,'717','2022-04-19 05:15:42','717','2022-04-19 05:16:03',10,0),('19','199',257607,'Tuesday  19th of April 2022','2022-04-19','2022-04-19 05:16:57','2022-04-20 05:16:57','717',0.00,0.00,'717','2022-04-20 06:30:19','717','2022-04-20 06:30:43',10,0),('19','199',257608,'Wednesday 20th of April 2022','2022-04-20','2022-04-20 06:31:27','2022-04-21 06:31:27','717',0.00,0.00,'717','2022-04-21 07:37:45','717','2022-04-21 07:38:10',10,0),('19','199',257609,'Thursday 21st of April 2022','2022-04-21','2022-04-21 07:39:06','2022-04-22 07:39:06','717',0.00,0.00,'717','2022-04-22 06:20:05','717','2022-04-22 06:20:26',10,0),('19','199',257610,'Friday 22nd of April 2022','2022-04-22','2022-04-22 06:21:32','2022-04-23 06:21:32','717',0.00,0.00,'717','2022-04-23 07:43:31','717','2022-04-23 07:43:47',10,0),('19','199',257611,'Saturday 23rd of April 2022','2022-04-23','2022-04-23 07:44:45','2022-04-24 07:44:45','717',0.00,0.00,'717','2022-04-24 07:46:49','717','2022-04-24 07:47:16',10,0),('19','199',257612,'Sunday  24th of April 2022','2022-04-24','2022-04-24 07:48:27','2022-04-25 07:48:27','717',0.00,0.00,'717','2022-04-25 07:10:21','717','2022-04-25 07:10:40',10,0),('19','199',257613,'Monday 25th of April 2022','2022-04-25','2022-04-25 07:11:26','2022-04-26 07:11:26','717',0.00,0.00,'717','2022-04-25 20:43:22','717','2022-04-25 20:43:46',10,0),('19','199',257614,'Tuesday  26th of April 2022','2022-04-26','2022-04-26 08:30:25','2022-04-27 08:30:25','717',0.00,0.00,'717','2022-04-27 08:33:50','717','2022-04-27 08:34:21',10,0),('19','199',257615,'Wednesday 27th of April 2022','2022-04-27','2022-04-27 08:35:15','2022-04-28 08:35:15','717',0.00,0.00,'717','2022-04-28 04:34:01','717','2022-04-28 04:34:58',10,0),('19','199',257616,'Thursday 28th of April 2022','2022-04-28','2022-04-28 04:36:49','2022-04-29 04:36:49','717',0.00,0.00,'717','2022-04-29 07:09:47','717','2022-04-29 07:10:08',10,0),('19','199',257617,'Friday 29th of April 2022','2022-04-29','2022-04-29 07:10:58','2022-04-30 07:10:58','717',0.00,0.00,'717','2022-04-30 09:08:12','717','2022-04-30 09:08:26',10,0),('19','199',257618,'Saturday 30th of April 2022','2022-04-30','2022-04-30 09:09:04','2022-05-01 09:09:04','717',0.00,0.00,'717','2022-05-01 08:01:56','717','2022-05-01 08:02:15',10,0),('19','199',257619,'Sunday  1st of May 2022','2022-05-01','2022-05-01 08:03:12','2022-05-02 08:03:12','717',0.00,0.00,'717','2022-05-03 07:34:37','717','2022-05-03 07:34:57',10,0),('19','199',257620,'Tuesday  3rd of May 2022','2022-05-03','2022-05-03 07:35:52','2022-05-04 07:35:52','717',0.00,0.00,'717','2022-05-04 08:15:58','717','2022-05-04 08:16:31',10,0),('19','199',257621,'Wednesday 4th of May,2022','2022-05-04','2022-05-04 08:17:37','2022-05-05 08:17:37','717',0.00,0.00,'717','2022-05-05 08:32:19','717','2022-05-05 08:32:38',10,0),('19','199',257622,'Thursday 5th of May 2022','2022-05-05','2022-05-05 08:33:39','2022-05-06 08:33:39','717',0.00,0.00,'717','2022-05-06 06:41:16','717','2022-05-06 06:41:36',10,0),('19','199',257623,'Friday 6th of May 2022','2022-05-06','2022-05-06 06:42:41','2022-05-07 06:42:41','717',0.00,0.00,'717','2022-05-07 04:48:03','717','2022-05-07 04:48:25',10,0),('19','199',257624,'Saturday 7th of May 2022','2022-05-07','2022-05-07 04:49:32','2022-05-08 04:49:32','717',0.00,0.00,'717','2022-05-08 07:29:06','717','2022-05-08 07:29:26',10,0),('19','199',257625,'Sunday  8th of May 2022','2022-05-08','2022-05-08 07:31:02','2022-05-09 07:31:02','717',0.00,0.00,'719','2022-05-09 09:03:44','717','2022-05-09 09:10:25',10,0),('19','199',257626,'Monday 9th of May 2022','2022-05-09','2022-05-09 09:11:20','2022-05-10 09:11:20','717',0.00,0.00,'717','2022-05-10 07:33:37','717','2022-05-10 07:33:54',10,0),('19','199',257627,'Tuesday 10th of May 2022','2022-05-10','2022-05-10 07:34:44','2022-05-11 07:34:44','717',0.00,0.00,'717','2022-05-11 03:45:19','717','2022-05-11 03:45:42',10,0),('19','199',257628,'Wednesday 11th of May 2022','2022-05-11','2022-05-11 03:46:48','2022-05-12 03:46:48','717',0.00,0.00,'717','2022-05-12 06:07:08','717','2022-05-12 06:07:29',10,0),('19','199',257629,'Thursday 12th of May 2022','2022-05-12','2022-05-12 06:08:32','2022-05-13 06:08:32','717',0.00,0.00,'717','2022-05-13 08:19:03','717','2022-05-13 08:19:35',10,0),('19','199',257630,'Friday 13th of May 2022','2022-05-13','2022-05-13 08:20:28','2022-05-14 08:20:28','717',0.00,0.00,'717','2022-05-14 07:44:03','717','2022-05-14 07:44:18',10,0),('19','199',257631,'Saturday 14th of May 2022','2022-05-14','2022-05-14 07:45:28','2022-05-15 07:45:28','717',0.00,0.00,'717','2022-05-15 08:32:51','717','2022-05-15 08:33:20',10,0),('19','199',257632,'Sunday  15th of May 2022','2022-05-15','2022-05-15 08:34:21','2022-05-16 08:34:21','717',0.00,0.00,'717','2022-05-16 08:10:04','717','2022-05-16 08:10:21',10,0),('19','199',257633,'Monday 16th of May 2022','2022-05-16','2022-05-16 08:11:12','2022-05-17 08:11:12','717',0.00,0.00,'717','2022-05-17 08:20:39','717','2022-05-17 08:21:12',10,0),('19','199',257634,'Tuesday  17th of May 2022','2022-05-17','2022-05-17 08:22:04','2022-05-18 08:22:04','717',0.00,0.00,'717','2022-05-18 08:15:51','717','2022-05-18 08:16:14',10,0),('19','199',257635,'Wednesday 18th of May 2022 HQ Steel cylinders offe','2022-05-18','2022-05-18 08:17:48','2022-05-19 08:17:48','717',0.00,0.00,'717','2022-05-18 08:20:33','717','2022-05-18 08:20:50',10,0),('19','199',257636,'Wednesday 18th of May 2022','2022-05-18','2022-05-18 08:21:28','2022-05-19 08:21:28','717',0.00,0.00,'717','2022-05-19 08:16:54','717','2022-05-19 08:17:13',10,0),('19','199',257637,'Thursday 19th of May 2022','2022-05-19','2022-05-19 08:17:50','2022-05-20 08:17:50','717',0.00,0.00,'717','2022-05-20 05:54:57','717','2022-05-20 05:55:14',10,0),('19','199',257638,'Friday 20th of May 2022','2022-05-20','2022-05-20 05:56:17','2022-05-21 05:56:17','717',0.00,0.00,'717','2022-05-21 08:18:43','717','2022-05-21 08:19:09',10,0),('19','199',257639,'Saturday 21st of May 2022','2022-05-21','2022-05-21 08:20:10','2022-05-22 08:20:10','717',0.00,0.00,'717','2022-05-22 07:06:03','717','2022-05-22 07:06:21',10,0),('19','199',257640,'Sunday  22nd of May 2022','2022-05-22','2022-05-22 07:06:58','2022-05-23 07:06:58','717',0.00,0.00,'717','2022-05-23 08:24:28','717','2022-05-23 08:24:45',10,0),('19','199',257641,'Monday 23rd of May 2022','2022-05-23','2022-05-23 08:25:18','2022-05-24 08:25:18','717',0.00,0.00,'717','2022-05-24 06:37:59','717','2022-05-24 06:38:33',10,0),('19','199',257642,'Tuesday  24th of May 2022','2022-05-24','2022-05-24 06:39:14','2022-05-25 06:39:14','717',0.00,0.00,'717','2022-05-25 08:24:03','717','2022-05-25 08:24:45',10,0),('19','199',257643,'Wednesday 25th of May,2022','2022-05-25','2022-05-25 08:25:36','2022-05-26 08:25:36','717',0.00,0.00,'717','2022-05-26 04:23:10','717','2022-05-26 04:23:32',10,0),('19','199',257644,'Thursday 26th of May 2022','2022-05-26','2022-05-26 04:24:16','2022-05-27 04:24:16','717',0.00,0.00,'717','2022-05-27 08:37:46','717','2022-05-27 08:38:06',10,0),('19','199',257645,'Friday 27th of May 2022','2022-05-27','2022-05-27 08:38:52','2022-05-28 08:38:52','717',0.00,0.00,'717','2022-05-28 08:34:05','717','2022-05-28 08:34:32',10,0),('19','199',257646,'Saturday 28th of May 2022','2022-05-28','2022-05-28 08:35:18','2022-05-29 08:35:18','717',0.00,0.00,'717','2022-05-29 06:55:50','717','2022-05-29 06:56:11',10,0),('19','199',257647,'Sunday  29th of May 2022','2022-05-29','2022-05-29 06:56:56','2022-05-30 06:56:56','717',0.00,0.00,'717','2022-05-30 08:15:04','717','2022-05-30 08:15:23',10,0),('19','199',257648,'Monday 30th of May 2022','2022-05-30','2022-05-30 08:16:05','2022-05-31 08:16:05','717',0.00,0.00,'717','2022-05-31 08:14:18','717','2022-05-31 08:14:36',10,0),('19','199',257649,'Tuesday 31st of May,2022','2022-05-31','2022-05-31 08:16:26','2022-06-01 08:16:26','717',0.00,0.00,'717','2022-06-01 08:43:51','717','2022-06-01 08:44:13',10,0),('19','199',257650,'Wednesday 1st of June 2022','2022-06-01','2022-06-01 08:45:05','2022-06-02 08:45:05','717',0.00,0.00,'717','2022-06-02 08:25:46','717','2022-06-02 08:26:07',10,0),('19','199',257651,'Thursday 2nd of June 2022','2022-06-02','2022-06-02 08:27:06','2022-06-03 08:27:06','717',0.00,0.00,'717','2022-06-03 07:43:39','717','2022-06-03 07:43:55',10,0),('19','199',257652,'Friday 3rd of June,2022','2022-06-03','2022-06-03 07:45:57','2022-06-04 07:45:57','717',0.00,0.00,'717','2022-06-04 07:33:45','717','2022-06-04 07:34:05',10,0),('19','199',257653,'Saturday 4th of June 2022','2022-06-04','2022-06-04 07:35:26','2022-06-05 07:35:26','717',0.00,0.00,'717','2022-06-05 07:13:28','717','2022-06-05 07:13:48',10,0),('19','199',257654,'Sunday 5th of June 2022','2022-06-05','2022-06-05 07:14:43','2022-06-06 07:14:43','717',0.00,0.00,'717','2022-06-06 08:07:35','717','2022-06-06 08:08:11',10,0),('19','199',257655,'Monday 6th of June 2022','2022-06-06','2022-06-06 08:09:23','2022-06-07 08:09:23','717',0.00,0.00,'717','2022-06-07 08:26:35','717','2022-06-07 08:26:51',10,0),('19','199',257656,'Tuesday 7th of June 2022','2022-06-07','2022-06-07 08:28:10','2022-06-08 08:28:10','717',0.00,0.00,'717','2022-06-08 08:11:56','717','2022-06-08 08:12:13',10,0),('19','199',257657,'Wednesday 8th of June 2022','2022-06-08','2022-06-08 08:12:46','2022-06-09 08:12:46','717',0.00,0.00,'717','2022-06-09 08:07:09','717','2022-06-09 08:07:25',10,0),('19','199',257658,'Thursday 9th of June 2022','2022-06-09','2022-06-09 08:08:12','2022-06-10 08:08:12','717',0.00,0.00,'717','2022-06-10 08:30:46','717','2022-06-10 08:31:21',10,0),('19','199',257659,'Friday 10th of June 2022','2022-06-10','2022-06-10 08:32:18','2022-06-11 08:32:18','717',0.00,0.00,'717','2022-06-11 07:58:18','717','2022-06-11 07:58:49',10,0),('19','199',257660,'Saturday 11th of June 2022','2022-06-11','2022-06-11 07:59:54','2022-06-12 07:59:54','717',0.00,0.00,'717','2022-06-12 08:26:55','717','2022-06-12 08:27:12',10,0),('19','199',257661,'Sunday 12th of June 2022','2022-06-12','2022-06-12 08:27:47','2022-06-13 08:27:47','717',0.00,0.00,'717','2022-06-13 08:45:53','717','2022-06-13 08:46:11',10,0),('19','199',257662,'Monday 13th of June 2023','2022-06-13','2022-06-13 08:46:51','2022-06-14 08:46:51','717',0.00,0.00,'717','2022-06-14 08:22:22','717','2022-06-14 08:22:43',10,0),('19','199',257663,'Tuesday  14th of June 2022','2022-06-14','2022-06-14 08:23:32','2022-06-15 08:23:32','717',0.00,0.00,'717','2022-06-15 08:28:27','717','2022-06-15 08:28:45',10,0),('19','199',257664,'Wednesday 15th of June 2022','2022-06-15','2022-06-15 08:29:32','2022-06-16 08:29:32','717',0.00,0.00,'717','2022-06-16 07:12:41','717','2022-06-16 07:13:02',10,0),('19','199',257665,'Thursday 16th of June 2022','2022-06-16','2022-06-16 08:04:11','2022-06-17 08:04:11','717',0.00,0.00,'717','2022-06-17 08:23:17','717','2022-06-17 08:23:34',10,0),('19','199',257666,'Friday 17th of June 2022','2022-06-17','2022-06-17 08:24:04','2022-06-18 08:24:04','717',0.00,0.00,'717','2022-06-18 08:42:19','717','2022-06-18 08:42:38',10,0),('19','199',257667,'Saturday 18th of June 2022','2022-06-18','2022-06-18 08:43:23','2022-06-19 08:43:23','717',0.00,0.00,'717','2022-06-19 08:29:59','717','2022-06-19 08:30:23',10,0),('19','199',257668,'Sunday 19th of June 2022','2022-06-19','2022-06-19 08:31:27','2022-06-20 08:31:27','717',0.00,0.00,'717','2022-06-20 08:12:54','717','2022-06-20 08:13:13',10,0),('19','199',257669,'Monday 20th of June 2022','2022-06-20','2022-06-20 08:13:58','2022-06-21 08:13:58','717',0.00,0.00,'717','2022-06-21 07:09:23','717','2022-06-21 07:09:42',10,0),('19','199',257670,'Tuesday  21st of June 2022','2022-06-21','2022-06-21 07:10:49','2022-06-22 07:10:49','717',0.00,0.00,'717','2022-06-22 07:39:35','717','2022-06-22 07:40:11',10,0),('19','199',257671,'Wednesday 22nd of June 2022','2022-06-22','2022-06-22 07:41:10','2022-06-23 07:41:10','717',0.00,0.00,'717','2022-06-23 08:08:13','717','2022-06-23 08:08:31',10,0),('19','199',257672,'Thursday 23rd of June 2022','2022-06-23','2022-06-23 08:09:34','2022-06-24 08:09:34','717',0.00,0.00,'717','2022-06-24 08:04:10','717','2022-06-24 08:04:29',10,0),('19','199',257673,'Friday 24th of June 2022','2022-06-24','2022-06-24 08:05:14','2022-06-25 08:05:14','717',0.00,0.00,'717','2022-06-25 06:51:12','717','2022-06-25 06:51:34',10,0),('19','199',257674,'Saturday 25th of June 2022','2022-06-25','2022-06-25 06:52:18','2022-06-26 06:52:18','717',0.00,0.00,'717','2022-06-26 08:10:28','717','2022-06-26 08:10:47',10,0),('19','199',257675,'Sunday 26th of June,2022','2022-06-26','2022-06-26 08:12:39','2022-06-27 08:12:39','717',0.00,0.00,'717','2022-06-27 08:50:54','717','2022-06-27 08:51:27',10,0),('19','199',257676,'Monday 27th of June 2022','2022-06-27','2022-06-27 08:52:11','2022-06-28 08:52:11','717',0.00,0.00,'717','2022-06-28 08:28:56','717','2022-06-28 08:29:22',10,0),('19','199',257677,'Tuesday  28th of June 2022','2022-06-28','2022-06-28 08:30:12','2022-06-29 08:30:12','717',0.00,0.00,'717','2022-06-29 08:02:44','717','2022-06-29 08:03:04',10,0),('19','199',257678,'Wednesday 29th of June 2022','2022-06-29','2022-06-29 08:03:42','2022-06-30 08:03:42','717',0.00,0.00,'717','2022-06-30 08:15:31','717','2022-06-30 08:15:50',10,0),('19','199',257679,'Thursday 30th of June 2022','2022-06-30','2022-06-30 08:16:55','2022-07-01 08:16:55','717',0.00,0.00,'717','2022-07-01 08:16:17','717','2022-07-01 08:16:41',10,0),('19','199',257680,'Friday 1st of July 2022','2022-07-01','2022-07-01 08:17:25','2022-07-02 08:17:25','717',0.00,0.00,'717','2022-07-02 08:30:14','717','2022-07-02 08:30:33',10,0),('19','199',257681,'Saturday 2nd of July 2022','2022-07-02','2022-07-02 08:31:17','2022-07-03 08:31:17','717',0.00,0.00,'717','2022-07-03 08:18:29','717','2022-07-03 08:18:52',10,0),('19','199',257682,'Sunday 3rdof July 2022','2022-07-03','2022-07-03 08:20:05','2022-07-04 08:20:05','717',0.00,0.00,'717','2022-07-04 06:04:01','717','2022-07-04 06:04:27',10,0),('19','199',257683,'Monday 4th of July 2022','2022-07-04','2022-07-04 06:05:24','2022-07-05 06:05:24','717',0.00,0.00,'717','2022-07-05 08:16:27','717','2022-07-05 08:16:52',10,0),('19','199',257684,'Tuesday  5th of July 2022','2022-07-05','2022-07-05 08:19:42','2022-07-06 08:19:42','717',0.00,0.00,'717','2022-07-06 07:53:32','717','2022-07-06 07:53:59',10,0),('19','199',257685,'Wednesday 6th of July 2022','2022-07-06','2022-07-06 07:55:04','2022-07-07 07:55:04','717',0.00,0.00,'717','2022-07-07 08:57:05','717','2022-07-07 08:57:43',10,0),('19','199',257686,'Thursday 7th of July 2022','2022-07-07','2022-07-07 08:59:04','2022-07-08 08:59:04','717',0.00,0.00,'717','2022-07-08 07:59:18','717','2022-07-08 07:59:36',10,0),('19','199',257687,'Friday 8th of July 2022','2022-07-08','2022-07-08 08:00:33','2022-07-09 08:00:33','717',0.00,0.00,'717','2022-07-10 09:05:39','717','2022-07-10 09:05:57',10,0),('19','199',257688,'Sunday  10th of July 2022','2022-07-10','2022-07-10 09:06:43','2022-07-11 09:06:43','717',0.00,0.00,'717','2022-07-11 08:26:57','717','2022-07-11 08:27:15',10,0),('19','199',257689,'Monday 11th of July 2022','2022-07-11','2022-07-11 08:27:51','2022-07-12 08:27:51','717',0.00,0.00,'717','2022-07-12 03:59:00','717','2022-07-12 03:59:39',10,0),('19','199',257690,'Tuesday  12th of July 2022','2022-07-12','2022-07-12 04:01:12','2022-07-13 04:01:12','717',0.00,0.00,'717','2022-07-13 08:35:28','717','2022-07-13 08:35:54',10,0),('19','199',257691,'Wednesday 13th of July 2022','2022-07-13','2022-07-13 08:36:58','2022-07-14 08:36:58','717',0.00,0.00,'717','2022-07-14 08:29:41','717','2022-07-14 08:30:03',10,0),('19','199',257692,'Thursday 14h of July 2022','2022-07-14','2022-07-14 08:30:44','2022-07-15 08:30:44','717',0.00,0.00,'717','2022-07-15 08:14:10','717','2022-07-15 08:14:29',10,0),('19','199',257693,'Friday 15th of July 2022','2022-07-15','2022-07-15 08:15:07','2022-07-16 08:15:07','717',0.00,0.00,'717','2022-07-16 09:50:46','717','2022-07-16 09:51:08',10,0),('19','199',257694,'Saturday 16th of July 2022','2022-07-16','2022-07-16 09:51:51','2022-07-17 09:51:51','717',0.00,0.00,'717','2022-07-17 08:13:26','717','2022-07-17 08:13:50',10,0),('19','199',257695,'Sunday 17th of July 2022','2022-07-17','2022-07-17 08:14:47','2022-07-18 08:14:47','717',0.00,0.00,'717','2022-07-18 07:07:51','717','2022-07-18 07:08:10',10,0),('19','199',257696,'Monday 18th of July 2022','2022-07-18','2022-07-18 07:08:58','2022-07-19 07:08:58','717',0.00,0.00,'717','2022-07-19 08:12:35','717','2022-07-19 08:13:02',10,0),('19','199',257697,'Tuesday 19th of July 2022','2022-07-19','2022-07-19 08:16:15','2022-07-20 08:16:15','717',0.00,0.00,'717','2022-07-20 08:32:04','717','2022-07-20 08:32:23',10,0),('19','199',257698,'Wednesday 20th of July 2022','2022-07-20','2022-07-20 08:33:11','2022-07-21 08:33:11','717',0.00,0.00,'717','2022-07-21 07:11:58','717','2022-07-21 07:12:14',10,0),('19','199',257699,'Thursday 21st of July 2022','2022-07-21','2022-07-21 07:13:19','2022-07-22 07:13:19','717',0.00,0.00,'717','2022-07-22 08:31:10','717','2022-07-22 08:31:42',10,0),('19','199',257700,'Friday 22nd of July 2022','2022-07-22','2022-07-22 08:33:22','2022-07-23 08:33:22','717',0.00,0.00,'717','2022-07-23 09:28:07','717','2022-07-23 09:29:09',10,0),('19','199',257701,'Saturday 23rd of July 2022','2022-07-23','2022-07-23 09:30:28','2022-07-24 09:30:28','717',0.00,0.00,'717','2022-07-24 08:54:10','717','2022-07-24 08:54:31',10,0),('19','199',257702,'sunday 24th of July 2022','2022-07-24','2022-07-24 08:55:25','2022-07-25 08:55:25','717',0.00,0.00,'717','2022-07-25 08:38:54','717','2022-07-25 08:50:22',10,0),('19','199',257703,'Monday 25th of July 2022','2022-07-25','2022-07-25 09:22:11','2022-07-26 09:22:11','717',0.00,0.00,'717','2022-07-26 09:07:39','717','2022-07-26 09:08:14',10,0),('19','199',257704,'Tuesday 26th of July 2022','2022-07-26','2022-07-26 09:09:09','2022-07-27 09:09:09','717',0.00,0.00,'717','2022-07-27 08:30:06','717','2022-07-27 08:30:31',10,0),('19','199',257705,'Wednesday 27th of July,2022','2022-07-27','2022-07-27 08:31:26','2022-07-28 08:31:26','717',0.00,0.00,'717','2022-07-28 08:43:08','717','2022-07-28 08:43:29',10,0),('19','199',257706,'Thursday 28th of July 2022','2022-07-28','2022-07-28 08:44:30','2022-07-29 08:44:30','717',0.00,0.00,'717','2022-07-28 17:26:47','717','2022-07-28 17:27:06',10,0),('19','199',257707,'Friday 29th of July 2022','2022-07-29','2022-07-29 08:50:20','2022-07-30 08:50:20','717',0.00,0.00,'717','2022-07-30 09:10:40','717','2022-07-30 09:11:02',10,0),('19','199',257708,'Saturday 30th of July 2022','2022-07-30','2022-07-30 09:12:27','2022-07-31 09:12:27','717',0.00,0.00,'717','2022-07-31 08:55:39','717','2022-07-31 08:56:02',10,0),('19','199',257709,'Sunday 31st of July 2022','2022-07-31','2022-07-31 08:56:48','2022-08-01 08:56:48','717',0.00,0.00,'717','2022-08-01 09:56:59','717','2022-08-01 10:06:06',10,0),('19','199',257710,'Monday 1st of August 2022','2022-08-01','2022-08-01 10:13:52','2022-08-02 10:13:52','717',0.00,0.00,'717','2022-08-02 04:07:47','717','2022-08-02 04:08:23',10,0),('19','199',257711,'Tuesday 2nd of August 2022','2022-08-02','2022-08-02 04:09:26','2022-08-03 04:09:26','717',0.00,0.00,'717','2022-08-03 08:30:52','717','2022-08-03 08:31:13',10,0),('19','199',257712,'Wednesday 3rd of August 2022','2022-08-03','2022-08-03 08:32:16','2022-08-04 08:32:16','717',0.00,0.00,'717','2022-08-04 08:26:42','717','2022-08-04 08:27:01',10,0),('19','199',257713,'Thursday 4th of August 2022','2022-08-04','2022-08-04 08:27:41','2022-08-05 08:27:41','717',0.00,0.00,'717','2022-08-05 07:39:11','717','2022-08-05 07:39:32',10,0),('19','199',257714,'Friday 5th of August 2022','2022-08-05','2022-08-05 07:40:17','2022-08-06 07:40:17','717',0.00,0.00,'717','2022-08-06 06:41:16','717','2022-08-06 06:41:45',10,0),('19','199',257715,'Saturday 6th of August 2022','2022-08-06','2022-08-06 06:42:40','2022-08-07 06:42:40','717',0.00,0.00,'717','2022-08-07 09:40:02','717','2022-08-07 09:40:22',10,0),('19','199',257716,'Sunday 7th of August 2022','2022-08-07','2022-08-07 09:41:10','2022-08-08 09:41:10','717',0.00,0.00,'717','2022-08-08 08:02:38','717','2022-08-08 08:03:08',10,0),('19','199',257717,'Monday 8th of August 2022','2022-08-08','2022-08-08 08:04:19','2022-08-09 08:04:19','717',0.00,0.00,'717','2022-08-09 08:28:51','717','2022-08-09 08:29:13',10,0),('19','199',257718,'Tuesday  9th of  August 2022','2022-08-09','2022-08-09 08:30:29','2022-08-10 08:30:29','717',0.00,0.00,'717','2022-08-10 07:32:09','717','2022-08-10 07:32:37',10,0),('19','199',257719,'Wednesday 10th of August 2022','2022-08-10','2022-08-10 07:33:38','2022-08-11 07:33:38','717',0.00,0.00,'717','2022-08-11 08:58:44','717','2022-08-11 08:59:03',10,0),('19','199',257720,'Thursday 11th of August 2022','2022-08-11','2022-08-11 08:59:42','2022-08-12 08:59:42','717',0.00,0.00,'717','2022-08-12 08:22:53','717','2022-08-12 08:23:41',10,0),('19','199',257721,'Friday 12th of August 2022','2022-08-12','2022-08-12 08:25:16','2022-08-13 08:25:16','717',0.00,0.00,'717','2022-08-13 09:32:25','717','2022-08-13 09:32:45',10,0),('19','199',257722,'Saturday 13th of August 2022','2022-08-13','2022-08-13 09:34:16','2022-08-14 09:34:16','717',0.00,0.00,'717','2022-08-14 08:50:56','717','2022-08-14 08:51:21',10,0),('19','199',257723,'Sunday 14th of August 2022','2022-08-14','2022-08-14 09:00:30','2022-08-15 09:00:30','717',0.00,0.00,'717','2022-08-15 08:46:31','717','2022-08-15 08:46:54',10,0),('19','199',257724,'Monday 15th of August 2022','2022-08-15','2022-08-15 08:47:42','2022-08-16 08:47:42','717',0.00,0.00,'717','2022-08-16 08:29:34','717','2022-08-16 08:30:03',10,0),('19','199',257725,'Tuesday 16th of August 2022','2022-08-16','2022-08-16 08:31:43','2022-08-17 08:31:43','717',0.00,0.00,'717','2022-08-17 09:02:47','717','2022-08-17 09:03:05',10,0),('19','199',257726,'Wednesday 17th of August,2022','2022-08-17','2022-08-17 09:03:52','2022-08-18 09:03:52','717',0.00,0.00,'717','2022-08-18 08:43:21','717','2022-08-18 08:43:44',10,0),('19','199',257727,'Thursday 18th of August 2022','2022-08-18','2022-08-18 08:44:44','2022-08-19 08:44:44','717',0.00,0.00,'717','2022-08-19 07:32:40','717','2022-08-19 07:33:10',10,0),('19','199',257728,'Friday 19th of August 2022','2022-08-19','2022-08-19 07:34:20','2022-08-20 07:34:20','717',0.00,0.00,'717','2022-08-20 07:07:05','717','2022-08-20 07:07:47',10,0),('19','199',257729,'Saturday 20th of August 2022','2022-08-20','2022-08-20 07:08:48','2022-08-21 07:08:48','717',0.00,0.00,'717','2022-08-21 09:12:09','717','2022-08-21 09:12:42',10,0),('19','199',257730,'Sunday  21st of August 2022','2022-08-21','2022-08-21 09:13:42','2022-08-22 09:13:42','717',0.00,0.00,'717','2022-08-22 08:50:08','717','2022-08-22 08:50:26',10,0),('19','199',257731,'Monday 22nd of August 2022','2022-08-22','2022-08-22 08:51:17','2022-08-23 08:51:17','717',0.00,0.00,'717','2022-08-23 08:02:33','717','2022-08-23 08:03:01',10,0),('19','199',257732,'Tuesday  23rd of August 2022','2022-08-23','2022-08-23 08:03:53','2022-08-24 08:03:53','717',0.00,0.00,'717','2022-08-24 06:16:07','717','2022-08-24 06:16:30',10,0),('19','199',257733,'Wednesday 25th of August 2022','2022-08-24','2022-08-24 06:17:17','2022-08-25 06:17:17','717',0.00,0.00,'717','2022-08-25 08:40:16','717','2022-08-25 08:41:02',10,0),('19','199',257734,'Thursday 25th of August 2022','2022-08-25','2022-08-25 08:42:08','2022-08-26 08:42:08','717',0.00,0.00,'717','2022-08-26 08:16:34','717','2022-08-26 08:17:00',10,0),('19','199',257735,'Friday 26th of August 2022','2022-08-26','2022-08-26 08:18:24','2022-08-27 08:18:24','717',0.00,0.00,'717','2022-08-27 07:54:22','717','2022-08-27 07:54:43',10,0),('19','199',257736,'Saturday 27th of August 2022','2022-08-27','2022-08-27 07:55:45','2022-08-28 07:55:45','717',0.00,0.00,'717','2022-08-28 08:20:53','717','2022-08-28 08:21:14',10,0),('19','199',257737,'Sunday  28th of August 2022','2022-08-28','2022-08-28 08:22:15','2022-08-29 08:22:15','717',0.00,0.00,'717','2022-08-29 08:47:44','717','2022-08-29 08:48:03',10,0),('19','199',257738,'Monday 29th of August 2022','2022-08-29','2022-08-29 08:48:41','2022-08-30 08:48:41','717',0.00,0.00,'717','2022-08-30 08:23:00','717','2022-08-30 08:23:18',10,0),('19','199',257739,'Tuesday 30th of August 2022','2022-08-30','2022-08-30 08:23:55','2022-08-31 08:23:55','717',0.00,0.00,'717','2022-08-31 03:46:13','717','2022-08-31 03:46:31',10,0),('19','199',257740,'Wednesday 31st of August 2022','2022-08-31','2022-08-31 03:47:27','2022-09-01 03:47:27','717',0.00,0.00,'717','2022-09-01 07:58:08','717','2022-09-01 07:59:23',10,0),('19','199',257741,'Thursday 1st of September 2022','2022-09-01','2022-09-01 08:00:30','2022-09-02 08:00:30','717',0.00,0.00,'717','2022-09-02 08:10:13','717','2022-09-02 08:10:40',10,0),('19','199',257742,'Friday 2nd of September 2022','2022-09-02','2022-09-02 08:11:53','2022-09-03 08:11:53','717',0.00,0.00,'717','2022-09-03 06:18:04','717','2022-09-03 06:18:41',10,0),('19','199',257743,'Saturday 3rd of September 2022','2022-09-03','2022-09-03 06:20:03','2022-09-04 06:20:03','717',0.00,0.00,'717','2022-09-04 07:52:34','717','2022-09-04 07:52:58',10,0),('19','199',257744,'Sunday 4th of September 2022','2022-09-04','2022-09-04 07:54:02','2022-09-05 07:54:02','717',0.00,0.00,'717','2022-09-05 08:01:36','717','2022-09-05 08:02:40',10,0),('19','199',257745,'Monday 5th of September 2022','2022-09-05','2022-09-05 08:04:00','2022-09-06 08:04:00','717',0.00,0.00,'717','2022-09-06 07:46:33','717','2022-09-06 07:47:16',10,0),('19','199',257746,'Tuesday  7th of September 2022','2022-09-06','2022-09-06 07:48:50','2022-09-07 07:48:50','717',0.00,0.00,'717','2022-09-07 08:31:46','717','2022-09-07 08:32:11',10,0),('19','199',257747,'Wednesday 7th of September,2022','2022-09-07','2022-09-07 08:33:03','2022-09-08 08:33:03','717',0.00,0.00,'717','2022-09-08 07:37:59','717','2022-09-08 07:38:25',10,0),('19','199',257748,'Thursday 8th of September 2022','2022-09-08','2022-09-08 07:39:52','2022-09-09 07:39:52','717',0.00,0.00,'717','2022-09-09 07:30:22','717','2022-09-09 07:30:52',10,0),('19','199',257749,'Friday 9th of September 2022','2022-09-09','2022-09-09 07:32:20','2022-09-10 07:32:20','717',0.00,0.00,'717','2022-09-10 07:22:02','717','2022-09-10 07:22:21',10,0),('19','199',257750,'Saturday 10th of September 2022','2022-09-10','2022-09-10 07:23:09','2022-09-11 07:23:09','717',0.00,0.00,'717','2022-09-11 07:32:26','717','2022-09-11 07:33:43',10,0),('19','199',257751,'Sunday 11th of September 2022','2022-09-11','2022-09-11 07:34:29','2022-09-12 07:34:29','717',0.00,0.00,'717','2022-09-12 07:06:57','717','2022-09-12 07:07:21',10,0),('19','199',257752,'Monday 12th of September 2022','2022-09-12','2022-09-12 07:08:29','2022-09-13 07:08:29','717',0.00,0.00,'717','2022-09-13 09:04:51','717','2022-09-13 09:05:44',10,0),('19','199',257753,'Tuesday 13th  of September 2022','2022-09-13','2022-09-13 09:06:53','2022-09-14 09:06:53','717',0.00,0.00,'717','2022-09-15 08:51:04','717','2022-09-15 08:51:29',10,0),('19','199',257754,'Thursday 15th of September,2022','2022-09-15','2022-09-15 08:52:24','2022-09-16 08:52:24','717',0.00,0.00,'717','2022-09-16 08:09:44','717','2022-09-16 08:10:11',10,0),('19','199',257755,'Friday 16th  of September 2022','2022-09-16','2022-09-16 08:11:04','2022-09-17 08:11:04','717',0.00,0.00,'717','2022-09-17 04:12:20','717','2022-09-17 04:12:45',10,0),('19','199',257756,'Saturday 17th of September 2022','2022-09-17','2022-09-17 04:13:36','2022-09-18 04:13:36','717',0.00,0.00,'717','2022-09-18 07:30:59','717','2022-09-18 07:31:22',10,0),('19','199',257757,'Sunday 18th of September 2022','2022-09-18','2022-09-18 07:31:58','2022-09-19 07:31:58','717',0.00,0.00,'717','2022-09-19 08:19:40','717','2022-09-19 08:20:07',10,0),('19','199',257758,'Monday 19th of September 2022','2022-09-19','2022-09-19 08:21:00','2022-09-20 08:21:00','717',0.00,0.00,'717','2022-09-19 18:29:11','717','2022-09-19 18:29:40',10,0),('19','199',257759,'Tuesday 20th  of September 2022','2022-09-20','2022-09-20 08:05:53','2022-09-21 08:05:53','717',0.00,0.00,'717','2022-09-21 05:35:35','717','2022-09-21 05:35:55',10,0),('19','199',257760,'Wednesday 21st of September 2022','2022-09-21','2022-09-21 05:36:41','2022-09-22 05:36:41','717',0.00,0.00,'717','2022-09-22 05:57:06','717','2022-09-22 05:57:31',10,0),('19','199',257761,'Thursday 22nd of September 2022','2022-09-22','2022-09-22 05:58:26','2022-09-23 05:58:26','717',0.00,0.00,'717','2022-09-23 08:05:56','717','2022-09-23 08:06:20',10,0),('19','199',257762,'Friday 23rd  of September 2022','2022-09-23','2022-09-23 08:07:06','2022-09-24 08:07:06','717',0.00,0.00,'717','2022-09-24 07:41:00','717','2022-09-24 07:41:19',10,0),('19','199',257763,'Saturday 24th of September 2022','2022-09-24','2022-09-24 07:42:05','2022-09-25 07:42:05','717',0.00,0.00,'717','2022-09-25 08:35:16','717','2022-09-25 08:35:36',10,0),('19','199',257764,'Sunday 25th of September 2022','2022-09-25','2022-09-25 08:36:05','2022-09-26 08:36:05','717',0.00,0.00,'717','2022-09-25 18:09:06','717','2022-09-25 18:09:28',10,0),('19','199',257765,'Monday 26th of September 2022','2022-09-26','2022-09-26 08:09:45','2022-09-27 08:09:45','717',0.00,0.00,'717','2022-09-27 06:34:21','717','2022-09-27 06:34:41',10,0),('19','199',257766,'Tuesday 27th  of September 2022','2022-09-27','2022-09-27 06:35:24','2022-09-28 06:35:24','717',0.00,0.00,'717','2022-09-28 06:15:57','717','2022-09-28 06:16:18',10,0),('19','199',257767,'Wednesday 28th of September 2022','2022-09-28','2022-09-28 06:16:59','2022-09-29 06:16:59','717',0.00,0.00,'717','2022-09-29 08:14:36','717','2022-09-29 08:14:58',10,0),('19','199',257768,'Thursday 29th of September 2022','2022-09-29','2022-09-29 08:15:44','2022-09-30 08:15:44','717',0.00,0.00,'717','2022-09-30 07:45:17','717','2022-09-30 07:45:38',10,0),('19','199',257769,'Friday 30th  of September 2022','2022-09-30','2022-09-30 07:46:15','2022-10-01 07:46:15','717',0.00,0.00,'717','2022-10-01 07:09:45','717','2022-10-01 07:12:41',10,0),('19','199',257770,'Saturday 1st of October 2022','2022-10-01','2022-10-01 07:13:37','2022-10-02 07:13:37','717',0.00,0.00,'717','2022-10-02 07:43:13','717','2022-10-02 07:43:31',10,0),('19','199',257771,'Sunday 2nd of October 2022','2022-10-02','2022-10-02 07:44:28','2022-10-03 07:44:28','717',0.00,0.00,'717','2022-10-03 07:41:04','717','2022-10-03 07:41:19',10,0),('19','199',257772,'Monday 3rd of October 2022','2022-10-03','2022-10-03 07:42:09','2022-10-04 07:42:09','717',0.00,0.00,'717','2022-10-03 17:56:33','717','2022-10-03 17:57:07',10,0),('19','199',257773,'Tuesday 4th of October 2021','2022-10-04','2022-10-04 07:12:50','2022-10-05 07:12:50','717',0.00,0.00,'717','2022-10-05 07:50:11','717','2022-10-05 07:50:29',10,0),('19','199',257774,'Wednesday 5th of October 2022','2022-10-05','2022-10-05 07:51:34','2022-10-06 07:51:34','717',0.00,0.00,'717','2022-10-06 08:05:26','717','2022-10-06 08:05:44',10,0),('19','199',257775,'Thursday 6th of October 2022','2022-10-06','2022-10-06 08:06:50','2022-10-07 08:06:50','717',0.00,0.00,'717','2022-10-06 18:03:50','717','2022-10-06 18:04:08',10,0),('19','199',257776,'Friday 7th of October 2022','2022-10-07','2022-10-07 07:50:34','2022-10-08 07:50:34','717',0.00,0.00,'717','2022-10-07 17:47:16','717','2022-10-07 17:47:41',10,0),('19','199',257777,'Saturday 8th of October 2022','2022-10-08','2022-10-08 08:26:52','2022-10-09 08:26:52','717',0.00,0.00,'717','2022-10-09 09:13:28','717','2022-10-09 09:13:45',10,0),('19','199',257778,'Sunday 9th of October 2022','2022-10-09','2022-10-09 09:14:12','2022-10-10 09:14:12','717',0.00,0.00,'717','2022-10-10 09:05:06','717','2022-10-10 09:05:32',10,0),('19','199',257779,'Monday 10th of October 2022','2022-10-10','2022-10-10 09:06:22','2022-10-11 09:06:22','717',0.00,0.00,'717','2022-10-11 07:25:09','717','2022-10-11 07:25:27',10,0),('19','199',257780,'Tuesday 11th of October 2022','2022-10-11','2022-10-11 07:26:07','2022-10-12 07:26:07','717',0.00,0.00,'717','2022-10-11 19:14:09','717','2022-10-11 19:14:29',10,0),('19','199',257781,'Wednesday 12th of October 2022','2022-10-12','2022-10-12 08:39:54','2022-10-13 08:39:54','717',0.00,0.00,'717','2022-10-13 08:16:00','717','2022-10-13 08:16:22',10,0),('19','199',257782,'Thursday 13th of October 2022','2022-10-13','2022-10-13 08:17:06','2022-10-14 08:17:06','717',0.00,0.00,'717','2022-10-14 08:16:55','717','2022-10-14 08:17:45',10,0),('19','199',257783,'Friday 14th of October 2022','2022-10-14','2022-10-14 08:18:43','2022-10-15 08:18:43','717',0.00,0.00,'717','2022-10-15 07:44:23','717','2022-10-15 07:44:43',10,0),('19','199',257784,'Saturday 15th of October 2022','2022-10-15','2022-10-15 07:45:19','2022-10-16 07:45:19','717',0.00,0.00,'717','2022-10-16 04:43:39','717','2022-10-16 04:44:03',10,0),('19','199',257785,'Sunday 16th of October 2022','2022-10-16','2022-10-16 04:44:52','2022-10-17 04:44:52','717',0.00,0.00,'717','2022-10-17 08:38:27','717','2022-10-17 08:38:54',10,0),('19','199',257786,'Monday 17th of October 2022','2022-10-17','2022-10-17 08:39:47','2022-10-18 08:39:47','717',0.00,0.00,'717','2022-10-18 08:06:13','717','2022-10-18 08:06:30',10,0),('19','199',257787,'Tuesday 18th of October 2022','2022-10-18','2022-10-18 08:07:26','2022-10-19 08:07:26','717',0.00,0.00,'717','2022-10-19 08:09:32','717','2022-10-19 08:09:55',10,0),('19','199',257788,'Wednesday 19th of October 2022','2022-10-19','2022-10-19 08:10:35','2022-10-20 08:10:35','717',0.00,0.00,'717','2022-10-20 08:17:12','717','2022-10-20 08:17:30',10,0),('19','199',257789,'Thursday 20th of October 2022','2022-10-20','2022-10-20 08:17:59','2022-10-21 08:17:59','717',0.00,0.00,'717','2022-10-21 07:52:12','717','2022-10-21 07:52:32',10,0),('19','199',257790,'Thursday 20th of October 2022','2022-10-21','2022-10-21 07:53:09','2022-10-22 07:53:09','717',0.00,0.00,'717','2022-10-21 08:18:43','717','2022-10-21 08:18:58',10,0),('19','199',257791,'Friday 21st of October 2022','2022-10-21','2022-10-21 08:19:32','2022-10-22 08:19:32','717',0.00,0.00,'717','2022-10-22 09:01:04','717','2022-10-22 09:01:29',10,0),('19','199',257792,'Saturday 21st of October 2022','2022-10-22','2022-10-22 09:02:22','2022-10-23 09:02:22','717',0.00,0.00,'717','2022-10-23 06:13:54','717','2022-10-23 06:14:12',10,0),('19','199',257793,'Sunday 23rd of October 2022','2022-10-23','2022-10-23 06:14:58','2022-10-24 06:14:58','717',0.00,0.00,'717','2022-10-24 09:20:25','717','2022-10-24 09:20:48',10,0),('19','199',257794,'Monday 24th of October 2022','2022-10-24','2022-10-24 09:21:33','2022-10-25 09:21:33','717',0.00,0.00,'717','2022-10-25 08:03:15','717','2022-10-25 08:03:38',10,0),('19','199',257795,'Tuesday 25th of October 2022','2022-10-25','2022-10-25 08:04:12','2022-10-26 08:04:12','717',0.00,0.00,'717','2022-10-26 07:45:27','717','2022-10-26 07:45:44',10,0),('19','199',257796,'Wednesday 26th of October 2022','2022-10-26','2022-10-26 07:46:15','2022-10-27 07:46:15','717',0.00,0.00,'717','2022-10-26 21:48:56','717','2022-10-26 21:49:19',10,0),('19','199',257797,'Thursday 27th of October 2022','2022-10-27','2022-10-27 08:32:34','2022-10-28 08:32:34','717',0.00,0.00,'717','2022-10-27 19:26:52','717','2022-10-27 19:27:15',10,0),('19','199',257798,'Friday 28th of October 2022','2022-10-28','2022-10-28 07:53:20','2022-10-29 07:53:20','717',0.00,0.00,'717','2022-10-28 08:24:06','717','2022-10-28 08:24:28',10,0),('19','199',257799,'Friday 28th of October 2022','2022-10-28','2022-10-28 08:33:44','2022-10-29 08:33:44','717',0.00,0.00,'717','2022-10-28 18:33:36','717','2022-10-28 18:34:03',10,0),('19','199',257800,'Saturday 29th of October 2022','2022-10-29','2022-10-29 09:07:57','2022-10-30 09:07:57','717',0.00,0.00,'717','2022-10-30 08:58:30','717','2022-10-30 08:58:53',10,0),('19','199',257801,'Sunday 30th of October 2022','2022-10-30','2022-10-30 08:59:43','2022-10-31 08:59:43','717',0.00,0.00,'717','2022-10-30 16:11:55','717','2022-10-30 16:13:39',10,0),('19','199',257802,'Monday 31st October 2022','2022-10-31','2022-10-31 08:27:58','2022-11-01 08:27:58','717',0.00,0.00,'717','2022-11-01 08:04:03','717','2022-11-01 08:04:23',10,0),('19','199',257803,'Tuesday 1st of November 2022','2022-11-01','2022-11-01 08:05:20','2022-11-02 08:05:20','717',0.00,0.00,'717','2022-11-02 08:53:33','717','2022-11-02 08:54:02',10,0),('19','199',257804,'Wednesday 2nd of November','2022-11-02','2022-11-02 08:55:33','2022-11-03 08:55:33','717',0.00,0.00,'717','2022-11-03 08:35:40','717','2022-11-03 08:35:58',10,0),('19','199',257805,'Thursday 3rd of November 2022','2022-11-03','2022-11-03 08:36:51','2022-11-04 08:36:51','717',0.00,0.00,'717','2022-11-04 10:21:08','717','2022-11-04 10:22:27',10,0),('19','199',257806,'Friday 4th of November,2022','2022-11-04','2022-11-04 10:23:18','2022-11-05 10:23:18','717',0.00,0.00,'717','2022-11-05 09:53:11','717','2022-11-05 09:53:30',10,0),('19','199',257807,'Saturday 5th of November 2022','2022-11-05','2022-11-05 09:54:12','2022-11-06 09:54:12','717',0.00,0.00,'717','2022-11-06 08:51:46','717','2022-11-06 08:52:04',10,0),('19','199',257808,'Sunday 6th of November 2022','2022-11-06','2022-11-06 08:52:47','2022-11-07 08:52:47','717',0.00,0.00,'717','2022-11-07 08:56:42','717','2022-11-07 08:57:03',10,0),('19','199',257809,'Monday 7th of November 2022','2022-11-07','2022-11-07 08:58:44','2022-11-08 08:58:44','717',0.00,0.00,'717','2022-11-08 05:20:40','717','2022-11-08 05:21:09',10,0),('19','199',257810,'Tuesday 8th of November 2022','2022-11-08','2022-11-08 05:21:59','2022-11-09 05:21:59','717',0.00,0.00,'717','2022-11-09 06:20:21','717','2022-11-09 06:20:48',10,0),('19','199',257811,'Wednesday 9th of November 2022','2022-11-09','2022-11-09 06:22:16','2022-11-10 06:22:16','717',0.00,0.00,'717','2022-11-10 07:01:17','717','2022-11-10 07:01:37',10,0),('19','199',257812,'Thursday 10th of November 2022','2022-11-10','2022-11-10 07:02:27','2022-11-11 07:02:27','717',0.00,0.00,'717','2022-11-11 05:21:40','717','2022-11-11 05:22:06',10,0),('19','199',257813,'Friday  11th of November 2022','2022-11-11','2022-11-11 05:22:50','2022-11-12 05:22:50','717',0.00,0.00,'717','2022-11-11 21:28:20','717','2022-11-11 21:28:42',10,0),('19','199',257814,'Saturday 12th of November 2022','2022-11-12','2022-11-12 04:45:18','2022-11-13 04:45:18','717',0.00,0.00,'717','2022-11-13 06:31:50','717','2022-11-13 06:32:09',10,0),('19','199',257815,'Sunday 13th of November 2022','2022-11-13','2022-11-13 06:32:55','2022-11-14 06:32:55','717',0.00,0.00,'717','2022-11-14 08:33:39','717','2022-11-14 08:34:04',10,0),('19','199',257816,'Monday 14th of November 2022','2022-11-14','2022-11-14 08:35:09','2022-11-15 08:35:09','717',0.00,0.00,'717','2022-11-15 08:37:40','717','2022-11-15 08:38:25',10,0),('19','199',257817,'Tuesday 15th November 2022','2022-11-15','2022-11-15 08:39:30','2022-11-16 08:39:30','717',0.00,0.00,'717','2022-11-16 08:05:13','717','2022-11-16 08:05:35',10,0),('19','199',257818,'Wednesday 16th of November 2022','2022-11-16','2022-11-16 08:09:28','2022-11-17 08:09:28','717',0.00,0.00,'717','2022-11-17 06:30:06','717','2022-11-17 06:30:32',10,0),('19','199',257819,'Thursday 17th of November 2022','2022-11-17','2022-11-17 06:32:36','2022-11-18 06:32:36','717',0.00,0.00,'717','2022-11-17 22:06:18','717','2022-11-17 22:06:47',10,0),('19','199',257820,'Friday  18th of November 2022','2022-11-18','2022-11-18 03:34:54','2022-11-19 03:34:54','717',0.00,0.00,'717','2022-11-19 04:52:51','717','2022-11-19 04:53:13',10,0),('19','199',257821,'Saturday 19th of November 2022','2022-11-19','2022-11-19 04:54:00','2022-11-20 04:54:00','717',0.00,0.00,'717','2022-11-20 04:37:40','717','2022-11-20 04:38:12',10,0),('19','199',257822,'Sunday 20th of November 2022','2022-11-20','2022-11-20 04:39:12','2022-11-21 04:39:12','717',0.00,0.00,'717','2022-11-20 23:51:46','717','2022-11-20 23:52:12',10,0),('19','199',257823,'Monday  21st of November 2022','2022-11-21','2022-11-21 00:01:28','2022-11-22 00:01:28','717',0.00,0.00,'717','2022-11-22 06:20:40','717','2022-11-22 06:21:08',10,0),('19','199',257824,'Tuesday 22nd of November 2022','2022-11-22','2022-11-22 06:22:00','2022-11-23 06:22:00','717',0.00,0.00,'717','2022-11-23 08:13:18','717','2022-11-23 08:13:35',10,0),('19','199',257825,'Wednesday 23rd of November 2022','2022-11-23','2022-11-23 08:14:20','2022-11-24 08:14:20','717',0.00,0.00,'717','2022-11-24 07:58:02','717','2022-11-24 07:58:19',10,0),('19','199',257826,'Thursday 24th of November 2022','2022-11-24','2022-11-24 07:59:01','2022-11-25 07:59:01','717',0.00,0.00,'717','2022-11-25 07:59:13','717','2022-11-25 07:59:34',10,0),('19','199',257827,'Friday  25th of November 2022','2022-11-25','2022-11-25 08:00:09','2022-11-26 08:00:09','717',0.00,0.00,'717','2022-11-26 09:48:11','717','2022-11-26 09:48:31',10,0),('19','199',257828,'Saturday 26th of November 2022','2022-11-26','2022-11-26 09:49:17','2022-11-27 09:49:17','717',0.00,0.00,'717','2022-11-27 09:19:33','717','2022-11-27 09:19:48',10,0),('19','199',257829,'Sunday 27th of November 2022','2022-11-27','2022-11-27 09:20:22','2022-11-28 09:20:22','717',0.00,0.00,'717','2022-11-28 02:35:59','717','2022-11-28 02:36:19',10,0),('19','199',257830,'Monday  28th of November 2022','2022-11-28','2022-11-28 02:37:14','2022-11-29 02:37:14','717',0.00,0.00,'717','2022-11-29 08:20:50','717','2022-11-29 08:21:16',10,0),('19','199',257831,'Tuesday 29th of November 2022','2022-11-29','2022-11-29 08:22:11','2022-11-30 08:22:11','717',0.00,0.00,'717','2022-11-30 03:33:38','717','2022-11-30 03:33:57',10,0),('19','199',257832,'Wednesday 30th of November 2022','2022-11-30','2022-11-30 08:27:33','2022-12-01 08:27:33','717',0.00,0.00,'717','2022-12-01 05:28:05','717','2022-12-01 05:28:32',10,0),('19','199',257833,'Thursday 1st of December 2022','2022-12-01','2022-12-01 05:29:30','2022-12-02 05:29:30','717',0.00,0.00,'717','2022-12-02 08:28:29','717','2022-12-02 08:28:47',10,0),('19','199',257834,'Friday 2nd of December 2022','2022-12-02','2022-12-02 08:29:25','2022-12-03 08:29:25','717',0.00,0.00,'717','2022-12-02 17:49:45','717','2022-12-02 17:50:03',10,0),('19','199',257835,'Saturday 3rd of December 2022','2022-12-03','2022-12-03 09:33:28','2022-12-04 09:33:28','717',0.00,0.00,'717','2022-12-04 02:40:21','717','2022-12-04 02:40:43',10,0),('19','199',257836,'Sunday 4th of December 2022','2022-12-04','2022-12-04 02:41:29','2022-12-05 02:41:29','717',0.00,0.00,'717','2022-12-05 02:14:12','717','2022-12-05 02:14:34',10,0),('19','199',257837,'Monday 5th of December 2022','2022-12-05','2022-12-05 02:15:21','2022-12-06 02:15:21','717',0.00,0.00,'717','2022-12-06 06:31:22','717','2022-12-06 06:31:46',10,0),('19','199',257838,'Tuesday 6th of December 2022','2022-12-06','2022-12-06 06:32:33','2022-12-07 06:32:33','717',0.00,0.00,'717','2022-12-07 08:35:25','717','2022-12-07 08:35:59',10,0),('19','199',257839,'Wednesday 7th of December 2022','2022-12-07','2022-12-07 08:37:53','2022-12-08 08:37:53','717',0.00,0.00,'717','2022-12-08 06:55:30','717','2022-12-08 06:55:49',10,0),('19','199',257840,'Thursday 8th of December 2022','2022-12-08','2022-12-08 06:56:48','2022-12-09 06:56:48','717',0.00,0.00,'717','2022-12-09 06:50:26','717','2022-12-09 06:50:51',10,0),('19','199',257841,'Friday 9th of December 2022','2022-12-09','2022-12-09 06:51:50','2022-12-10 06:51:50','717',0.00,0.00,'717','2022-12-10 04:28:06','717','2022-12-10 04:28:25',10,0),('19','199',257842,'Saturday 10th of December 2022','2022-12-10','2022-12-10 06:23:21','2022-12-11 06:23:21','717',0.00,0.00,'717','2022-12-11 09:14:50','717','2022-12-11 09:15:19',10,0),('19','199',257843,'Sunday 11th of December 2022','2022-12-11','2022-12-11 09:16:24','2022-12-12 09:16:24','717',0.00,0.00,'717','2022-12-12 08:18:56','717','2022-12-12 08:20:07',10,0),('19','199',257844,'Monday 12th of December 2022','2022-12-12','2022-12-12 08:21:11','2022-12-13 08:21:11','717',0.00,0.00,'717','2022-12-12 18:36:51','717','2022-12-12 18:37:08',10,0),('19','199',257845,'Tuesday 13th  of December 2022','2022-12-13','2022-12-13 08:28:33','2022-12-14 08:28:33','717',0.00,0.00,'717','2022-12-14 08:23:41','717','2022-12-14 08:23:56',10,0),('19','199',257846,'Wednesday 14th of December 2022','2022-12-14','2022-12-14 08:24:48','2022-12-15 08:24:48','717',0.00,0.00,'717','2022-12-15 08:29:39','717','2022-12-15 08:29:59',10,0),('19','199',257847,'Thursday 15th  of December 2022','2022-12-15','2022-12-15 08:30:54','2022-12-16 08:30:54','717',0.00,0.00,'717','2022-12-16 08:33:30','717','2022-12-16 08:33:50',10,0),('19','199',257848,'Friday 16th  of December 2022','2022-12-16','2022-12-16 08:34:48','2022-12-17 08:34:48','717',0.00,0.00,'717','2022-12-17 09:14:05','717','2022-12-17 09:14:30',10,0),('19','199',257849,'Saturday 17th of December 2022','2022-12-17','2022-12-17 09:15:29','2022-12-18 09:15:29','717',0.00,0.00,'717','2022-12-18 09:00:46','717','2022-12-18 09:01:14',10,0),('19','199',257850,'Sunday 18th of December 2022','2022-12-18','2022-12-18 09:02:04','2022-12-19 09:02:04','717',0.00,0.00,'717','2022-12-19 08:47:54','717','2022-12-19 08:48:12',10,0),('19','199',257851,'Monday 19th of December 2022','2022-12-19','2022-12-19 08:48:53','2022-12-20 08:48:53','717',0.00,0.00,'717','2022-12-20 07:00:57','717','2022-12-20 07:01:16',10,0),('19','199',257852,'Monday 20th of December 2022','2022-12-20','2022-12-20 07:02:08','2022-12-21 07:02:08','717',0.00,0.00,'717','2022-12-21 07:46:31','717','2022-12-21 07:46:53',10,0),('19','199',257853,'Wednesday 21st of December 2022','2022-12-21','2022-12-21 07:47:45','2022-12-22 07:47:45','717',0.00,0.00,'717','2022-12-22 08:38:46','717','2022-12-22 08:39:05',10,0),('19','199',257854,'Thursday 22nd of December 2022','2022-12-22','2022-12-22 08:40:01','2022-12-23 08:40:01','717',0.00,0.00,'717','2022-12-23 08:53:50','717','2022-12-23 08:54:08',10,0),('19','199',257855,'Friday 23rd  of December 2022','2022-12-23','2022-12-23 08:54:45','2022-12-24 08:54:45','717',0.00,0.00,'717','2022-12-24 07:11:25','717','2022-12-24 07:11:44',10,0),('19','199',257856,'Saturday 24th of December 2022','2022-12-24','2022-12-24 07:12:32','2022-12-25 07:12:32','717',0.00,0.00,'717','2022-12-25 05:40:25','717','2022-12-25 05:40:58',10,0),('19','199',257857,'Sunday 25th of December 2022','2022-12-25','2022-12-25 05:42:02','2022-12-26 05:42:02','717',0.00,0.00,'717','2022-12-26 02:43:08','717','2022-12-26 02:43:24',10,0),('19','199',257858,'Monday  26th of December 2022','2022-12-26','2022-12-26 02:44:22','2022-12-27 02:44:22','717',0.00,0.00,'717','2022-12-27 05:30:11','717','2022-12-27 05:30:37',10,0),('19','199',257859,'Tuesday 27th  of December 2022','2022-12-27','2022-12-27 05:31:32','2022-12-28 05:31:32','717',0.00,0.00,'717','2022-12-28 05:17:59','717','2022-12-28 05:18:22',10,0),('19','199',257860,'Wednesday 28th of December 2022','2022-12-28','2022-12-28 05:19:23','2022-12-29 05:19:23','717',0.00,0.00,'717','2022-12-29 06:24:05','717','2022-12-29 06:24:26',10,0),('19','199',257861,'Thursday 29th of December 2022','2022-12-29','2022-12-29 06:25:29','2022-12-30 06:25:29','717',0.00,0.00,'717','2022-12-30 04:35:57','717','2022-12-30 04:36:31',10,0),('19','199',257862,'Friday 30th  of December 2022','2022-12-30','2022-12-30 04:37:18','2022-12-31 04:37:18','717',0.00,0.00,'717','2022-12-31 07:22:32','717','2022-12-31 07:23:11',10,0),('19','199',257863,'Saturday 31st of December 2022','2022-12-31','2022-12-31 07:24:04','2023-01-01 07:24:04','717',0.00,0.00,'717','2023-01-02 05:03:43','717','2023-01-02 05:03:58',10,0),('19','199',257864,'Monday 2nd of January 2023','2023-01-02','2023-01-02 05:04:34','2023-01-03 05:04:34','717',0.00,0.00,'717','2023-01-03 07:49:15','717','2023-01-03 07:49:35',10,0),('19','199',257865,'Tuesday 3rd of January 2023','2023-01-03','2023-01-03 07:50:27','2023-01-04 07:50:27','717',0.00,0.00,'717','2023-01-04 07:44:26','717','2023-01-04 07:44:47',10,0),('19','199',257866,'Wednesday 4th of January 2023','2023-01-04','2023-01-04 07:45:33','2023-01-05 07:45:33','717',0.00,0.00,'717','2023-01-05 07:49:56','717','2023-01-05 07:50:15',10,0),('19','199',257867,'Thursday 5th of January 2023','2023-01-05','2023-01-05 07:51:13','2023-01-06 07:51:13','717',0.00,0.00,'717','2023-01-06 07:02:24','717','2023-01-06 07:02:49',10,0),('19','199',257868,'Friday 6th of January 2023','2023-01-06','2023-01-06 07:03:43','2023-01-07 07:03:43','717',0.00,0.00,'717','2023-01-07 08:38:32','717','2023-01-07 08:38:51',10,0),('19','199',257869,'Saturday 7th of January 2023','2023-01-07','2023-01-07 08:39:39','2023-01-08 08:39:39','717',0.00,0.00,'717','2023-01-07 17:08:32','717','2023-01-07 17:08:57',10,0),('19','199',257870,'Sunday 8th of January 2023','2023-01-08','2023-01-08 08:19:27','2023-01-09 08:19:27','717',0.00,0.00,'717','2023-01-09 08:05:12','717','2023-01-09 08:05:34',10,0),('19','199',257871,'Monday 9th of January 2023','2023-01-09','2023-01-09 08:06:15','2023-01-10 08:06:15','717',0.00,0.00,'717','2023-01-10 08:30:46','717','2023-01-10 08:31:11',10,0),('19','199',257872,'Tuesday 10th of January 2023','2023-01-10','2023-01-10 08:32:35','2023-01-11 08:32:35','717',0.00,0.00,'717','2023-01-11 08:23:47','717','2023-01-11 08:24:11',10,0),('19','199',257873,'Wednesday 11th of January 2023','2023-01-11','2023-01-11 08:24:54','2023-01-12 08:24:54','717',0.00,0.00,'717','2023-01-12 08:43:32','717','2023-01-12 08:44:18',10,0),('19','199',257874,'Thursday 12th of January 2023','2023-01-12','2023-01-12 08:49:46','2023-01-13 08:49:46','717',0.00,0.00,'717','2023-01-13 08:38:55','717','2023-01-13 08:39:52',10,0),('19','199',257875,'Friday 13th of January 2023','2023-01-13','2023-01-13 08:40:50','2023-01-14 08:40:50','717',0.00,0.00,'717','2023-01-13 17:48:09','717','2023-01-13 17:49:34',10,0),('19','199',257876,'Saturday 14th of January 2023','2023-01-14','2023-01-14 09:41:10','2023-01-15 09:41:10','717',0.00,0.00,'717','2023-01-15 09:04:37','717','2023-01-15 09:04:58',10,0),('19','199',257877,'Sunday 15th of January 2023','2023-01-15','2023-01-15 09:06:02','2023-01-16 09:06:02','717',0.00,0.00,'717','2023-01-16 08:43:05','717','2023-01-16 08:43:53',10,0),('19','199',257878,'Monday 16th January 2023','2023-01-16','2023-01-16 08:48:49','2023-01-17 08:48:49','717',0.00,0.00,'717','2023-01-18 08:50:23','717','2023-01-18 08:50:42',10,0),('19','199',257879,'Wednesday 18th of January 2023','2023-01-18','2023-01-18 08:51:30','2023-01-19 08:51:30','717',0.00,0.00,'717','2023-01-19 08:27:51','717','2023-01-19 08:28:32',10,0),('19','199',257880,'Thursday 19th of January 2023','2023-01-19','2023-01-19 08:30:19','2023-01-20 08:30:19','717',0.00,0.00,'717','2023-01-20 09:02:54','717','2023-01-20 09:03:31',10,0),('19','199',257881,'Friday 20th January 2023','2023-01-20','2023-01-20 09:06:38','2023-01-21 09:06:38','717',0.00,0.00,'717','2023-01-21 09:15:25','717','2023-01-21 09:15:50',10,0),('19','199',257882,'Saturday 21st of January 2023','2023-01-21','2023-01-21 09:17:04','2023-01-22 09:17:04','717',0.00,0.00,'717','2023-01-22 09:28:17','717','2023-01-22 09:28:48',10,0),('19','199',257883,'Sunday 22nd of January 2023','2023-01-22','2023-01-22 09:29:37','2023-01-23 09:29:37','717',0.00,0.00,'717','2023-01-23 07:47:42','717','2023-01-23 07:48:04',10,0),('19','199',257884,'Monday 23rd of January 2023','2023-01-23','2023-01-23 07:49:00','2023-01-24 07:49:00','717',0.00,0.00,'717','2023-01-24 08:47:08','717','2023-01-24 08:47:28',10,0),('19','199',257885,'Tuesday 24th  of January 2023','2023-01-24','2023-01-24 08:48:26','2023-01-25 08:48:26','717',0.00,0.00,'717','2023-01-25 07:32:31','717','2023-01-25 07:32:52',10,0),('19','199',257886,'Wednesday 25th of January 2023','2023-01-25','2023-01-25 07:33:37','2023-01-26 07:33:37','717',0.00,0.00,'717','2023-01-26 08:05:12','717','2023-01-26 08:05:35',10,0),('19','199',257887,'Thursday 26th of January 2023','2023-01-26','2023-01-26 08:06:20','2023-01-27 08:06:20','717',0.00,0.00,'717','2023-01-27 08:47:36','717','2023-01-27 08:47:58',10,0),('19','199',257888,'Friday 27th of January 2023','2023-01-27','2023-01-27 08:49:02','2023-01-28 08:49:02','717',0.00,0.00,'717','2023-01-28 09:20:35','717','2023-01-28 09:20:54',10,0),('19','199',257889,'Saturday 28th of January 2023','2023-01-28','2023-01-28 09:21:57','2023-01-29 09:21:57','717',0.00,0.00,'717','2023-01-29 09:20:55','717','2023-01-29 09:21:15',10,0),('19','199',257890,'Sunday 29th of January 2023','2023-01-29','2023-01-29 09:21:46','2023-01-30 09:21:46','717',0.00,0.00,'717','2023-01-30 07:37:13','717','2023-01-30 07:37:35',10,0),('19','199',257891,'Monday 30th of January 2023','2023-01-30','2023-01-30 07:38:26','2023-01-31 07:38:26','717',0.00,0.00,'717','2023-01-31 08:27:22','717','2023-01-31 08:27:50',10,0),('19','199',257892,'Monday 31st of January 2023','2023-01-31','2023-01-31 08:28:38','2023-02-01 08:28:38','717',0.00,0.00,'717','2023-02-01 07:54:17','717','2023-02-01 07:54:39',10,0),('19','199',257893,'Wednesday 1st of February 2023','2023-02-01','2023-02-01 07:55:27','2023-02-02 07:55:27','717',0.00,0.00,'717','2023-02-02 08:50:06','717','2023-02-02 08:50:32',10,0),('19','199',257894,'Thursday 2nd January 2023','2023-02-02','2023-02-02 08:51:40','2023-02-03 08:51:40','717',0.00,0.00,'717','2023-02-02 09:32:44','717','2023-02-02 09:33:02',10,0),('19','199',257895,'Thursday 2nd January 2023','2023-02-02','2023-02-02 09:36:57','2023-02-03 09:36:57','717',0.00,0.00,'717','2023-02-03 08:16:20','717','2023-02-03 08:16:48',10,0),('19','199',257896,'Friday 3rd of February 2023','2023-02-03','2023-02-03 08:17:43','2023-02-04 08:17:43','717',0.00,0.00,'717','2023-02-04 08:45:05','717','2023-02-04 08:45:33',10,0),('19','199',257897,'Saturday 4th of February 2023','2023-02-04','2023-02-04 08:46:24','2023-02-05 08:46:24','717',0.00,0.00,'717','2023-02-05 09:12:37','717','2023-02-05 09:13:06',10,0),('19','199',257898,'Sunday 5th of February 2023','2023-02-05','2023-02-05 09:13:45','2023-02-06 09:13:45','717',0.00,0.00,'717','2023-02-06 07:04:22','717','2023-02-06 07:04:56',10,0),('19','199',257899,'Monday 6th of February 2023','2023-02-06','2023-02-06 07:05:36','2023-02-07 07:05:36','717',0.00,0.00,'717','2023-02-07 08:28:54','717','2023-02-07 08:29:11',10,0),('19','199',257900,'Monday 7th of January 2023','2023-02-07','2023-02-07 08:29:50','2023-02-08 08:29:50','717',0.00,0.00,'717','2023-02-08 05:45:03','717','2023-02-08 05:45:36',10,0),('19','199',257901,'Wednesday 8th of February 2023','2023-02-08','2023-02-08 05:47:12','2023-02-09 05:47:12','717',0.00,0.00,'717','2023-02-09 06:48:01','717','2023-02-09 06:48:28',10,0),('19','199',257902,'Thursday 9th of February 2023','2023-02-09','2023-02-09 06:49:52','2023-02-10 06:49:52','717',0.00,0.00,'717','2023-02-10 06:42:07','717','2023-02-10 06:42:43',10,0),('19','199',257903,'Friday 10th of February 2023','2023-02-10','2023-02-10 06:43:32','2023-02-11 06:43:32','717',0.00,0.00,'717','2023-02-11 07:26:50','717','2023-02-11 07:27:10',10,0),('19','199',257904,'Saturday 11th of February 2023','2023-02-11','2023-02-11 07:28:01','2023-02-12 07:28:01','717',0.00,0.00,'717','2023-02-12 08:00:46','717','2023-02-12 08:01:30',10,0),('19','199',257905,'Sunday 12th of February 2023','2023-02-12','2023-02-12 08:02:49','2023-02-13 08:02:49','717',0.00,0.00,'717','2023-02-13 09:17:30','717','2023-02-13 09:17:51',10,0),('19','199',257906,'Monday 13th of February 2023','2023-02-13','2023-02-13 09:18:56','2023-02-14 09:18:56','717',0.00,0.00,'717','2023-02-14 08:32:26','717','2023-02-14 08:32:49',10,0),('19','199',257907,'Tuesday 14th of February 2023','2023-02-14','2023-02-14 08:33:33','2023-02-15 08:33:33','717',0.00,0.00,'717','2023-02-15 07:31:43','717','2023-02-15 07:32:02',10,0),('19','199',257908,'Wednesday 15th of February 2023','2023-02-15','2023-02-15 07:32:45','2023-02-16 07:32:45','717',0.00,0.00,'717','2023-02-16 08:22:05','717','2023-02-16 08:22:24',10,0),('19','199',257909,'Thursday 16th of February 2023','2023-02-16','2023-02-16 08:23:19','2023-02-17 08:23:19','717',0.00,0.00,'717','2023-02-17 07:12:02','717','2023-02-17 07:12:27',10,0),('19','199',257910,'Friday 17th of February 2023','2023-02-17','2023-02-17 07:13:06','2023-02-18 07:13:06','717',0.00,0.00,'717','2023-02-18 09:16:26','717','2023-02-18 09:17:44',10,0),('19','199',257911,'Saturday 18th of February 2023','2023-02-18','2023-02-18 09:18:45','2023-02-19 09:18:45','717',0.00,0.00,'717','2023-02-19 09:04:58','717','2023-02-19 09:05:25',10,0),('19','199',257912,'Sunday 19th of February 2023','2023-02-19','2023-02-19 09:06:28','2023-02-20 09:06:28','717',0.00,0.00,'717','2023-02-20 08:30:51','717','2023-02-20 08:31:08',10,0),('19','199',257913,'Monday 20th of February 2023','2023-02-20','2023-02-20 08:32:00','2023-02-21 08:32:00','717',0.00,0.00,'717','2023-02-22 12:45:45','717','2023-02-22 12:46:07',10,0),('19','199',257914,'Wednesday 22nd of February 2023','2023-02-22','2023-02-22 12:46:52','2023-02-23 12:46:52','717',0.00,0.00,'717','2023-02-23 08:49:53','717','2023-02-23 08:50:19',10,0),('19','199',257915,'Thursday 23rd of February 2023','2023-02-23','2023-02-23 08:52:28','2023-02-24 08:52:28','717',0.00,0.00,'717','2023-02-24 07:47:33','717','2023-02-24 07:47:57',10,0),('19','199',257916,'Friday 24th of February 2023','2023-02-24','2023-02-24 07:48:48','2023-02-25 07:48:48','717',0.00,0.00,'717','2023-02-27 05:59:34','717','2023-02-27 05:59:52',10,0),('19','199',257917,'Monday 27th of February 2023','2023-02-27','2023-02-27 06:00:46','2023-02-28 06:00:46','717',0.00,0.00,'717','2023-02-28 07:38:40','717','2023-02-28 07:38:56',10,0),('19','199',257918,'Tuesday 28th of February 2023','2023-02-28','2023-02-28 07:39:29','2023-03-01 07:39:29','717',0.00,0.00,'717','2023-03-02 08:20:58','717','2023-03-02 08:21:30',10,0),('19','199',257919,'Wednesday 1st of March 2023','2023-03-02','2023-03-02 08:22:33','2023-03-03 08:22:33','717',0.00,0.00,'717','2023-03-02 10:59:47','717','2023-03-02 11:00:05',10,0),('19','199',257920,'Thursday 2nd of March, 2023','2023-03-02','2023-03-02 11:00:55','2023-03-03 11:00:55','717',0.00,0.00,'717','2023-03-03 08:28:38','717','2023-03-03 08:29:32',10,0),('19','199',257921,'Friday 3rd of February 2023','2023-03-03','2023-03-03 08:30:58','2023-03-04 08:30:58','717',0.00,0.00,'717','2023-03-04 09:25:55','717','2023-03-04 09:26:16',10,0),('19','199',257922,'Saturday 4th of March 2023','2023-03-04','2023-03-04 09:26:56','2023-03-05 09:26:56','717',0.00,0.00,'717','2023-03-05 09:26:45','717','2023-03-05 09:27:06',10,0),('19','199',257923,'Sunday 5th of March 2023','2023-03-05','2023-03-05 09:27:37','2023-03-06 09:27:37','717',0.00,0.00,'717','2023-03-06 08:21:59','717','2023-03-06 08:22:22',10,0),('19','199',257924,'Monday 6th of March 2023','2023-03-06','2023-03-06 08:23:04','2023-03-07 08:23:04','717',0.00,0.00,'717','2023-03-07 08:29:49','717','2023-03-07 08:30:10',10,0),('19','199',257925,'Tuesday 7th of March 2023','2023-03-07','2023-03-07 08:31:00','2023-03-08 08:31:00','717',0.00,0.00,'717','2023-03-08 07:32:18','717','2023-03-08 07:32:41',10,0),('19','199',257926,'Wednesday 8th of March 2023','2023-03-08','2023-03-08 07:33:30','2023-03-09 07:33:30','717',0.00,0.00,'717','2023-03-09 08:25:05','717','2023-03-09 08:25:25',10,0),('19','199',257927,'Thursday 9th of March 2023','2023-03-09','2023-03-09 08:26:33','2023-03-10 08:26:33','717',0.00,0.00,'717','2023-03-10 08:36:02','717','2023-03-10 08:36:25',10,0),('19','199',257928,'Friday 10th of March 2023','2023-03-10','2023-03-10 08:37:09','2023-03-11 08:37:09','717',0.00,0.00,'717','2023-03-11 08:49:33','717','2023-03-11 08:49:51',10,0),('19','199',257929,'Saturday 11th of March 2023','2023-03-11','2023-03-11 08:50:31','2023-03-12 08:50:31','717',0.00,0.00,'717','2023-03-12 09:15:24','717','2023-03-12 09:15:46',10,0),('19','199',257930,'Sunday 12th of March 2023','2023-03-12','2023-03-12 09:16:23','2023-03-13 09:16:23','717',0.00,0.00,'717','2023-03-13 06:57:05','717','2023-03-13 06:57:25',10,0),('19','199',257931,'Monday 13th of March 2023','2023-03-13','2023-03-13 06:57:56','2023-03-14 06:57:56','717',0.00,0.00,'717','2023-03-14 08:06:03','717','2023-03-14 08:06:25',10,0),('19','199',257932,'Tuesday 14th of March 2023','2023-03-14','2023-03-14 08:07:00','2023-03-15 08:07:00','717',0.00,0.00,'717','2023-03-15 07:18:40','717','2023-03-15 07:19:03',10,0),('19','199',257933,'Wednesday 15th of March 2023','2023-03-15','2023-03-15 07:19:41','2023-03-16 07:19:41','717',0.00,0.00,'717','2023-03-16 07:53:40','717','2023-03-16 07:54:02',10,0),('19','199',257934,'Thursday 16th of March 2023','2023-03-16','2023-03-16 07:54:53','2023-03-17 07:54:53','717',0.00,0.00,'717','2023-03-17 07:57:58','717','2023-03-17 07:58:17',10,0),('19','199',257935,'Friday 17th of March 2023','2023-03-17','2023-03-17 07:58:56','2023-03-18 07:58:56','717',0.00,0.00,'717','2023-03-20 07:28:29','717','2023-03-20 07:28:51',10,0),('19','199',257936,'Monday 20th of March 2023','2023-03-20','2023-03-20 07:29:23','2023-03-21 07:29:23','717',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4907668 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('19','199','1023','240272',4608607,'3026','467',0.00,12.50,0.00,0.00,12.50,7937.50,0.00,0.00,0.00),('19','199','1023','240272',4608608,'3027','467',0.00,18.50,0.00,0.00,18.50,11747.50,0.00,0.00,0.00),('19','199','1023','240272',4608609,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','240272',4608610,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','240272',4608611,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','240272',4608612,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','240272',4608613,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','240272',4608614,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','240331',4609571,'3026','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','240331',4609572,'3027','467',18.50,18.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','240331',4609573,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','240331',4609574,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','240331',4609575,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','240331',4609576,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','240331',4609577,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','240331',4609578,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','240331',4609579,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244292',4677721,'3026','467',12.50,421.25,0.00,0.00,408.75,264870.00,0.00,0.00,0.00),('19','199','1023','244292',4677722,'3027','467',18.50,18.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244292',4677723,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244292',4677724,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244292',4677725,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244292',4677726,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244292',4677727,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244292',4677728,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244292',4677729,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244573',4682470,'3026','467',421.25,1176.50,0.00,0.00,755.25,489402.00,0.00,0.00,0.00),('19','199','1023','244573',4682471,'3027','467',18.50,18.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244573',4682472,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244573',4682473,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244573',4682474,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244573',4682475,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244573',4682476,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244573',4682477,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244573',4682478,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244720',4685238,'3026','467',1176.50,1613.50,0.00,0.00,437.00,282276.00,0.00,0.00,0.00),('19','199','1023','244720',4685239,'3027','467',18.50,18.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244720',4685240,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244720',4685241,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244720',4685242,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244720',4685243,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244720',4685244,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244720',4685245,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','244720',4685246,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245024',4690237,'3026','467',1613.50,1975.25,0.00,0.00,361.75,232614.00,0.00,0.00,0.00),('19','199','1023','245024',4690238,'3027','467',18.50,18.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245024',4690239,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245024',4690240,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245024',4690241,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245024',4690242,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245024',4690243,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245024',4690244,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245024',4690245,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245249',4694279,'3026','467',1975.25,2343.75,0.00,0.00,368.50,238788.00,0.00,0.00,0.00),('19','199','1023','245249',4694280,'3027','467',18.50,18.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245249',4694281,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245249',4694282,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245249',4694283,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245249',4694284,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245249',4694285,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245249',4694286,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245249',4694287,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245760',4703358,'3026','467',2343.75,2676.50,0.00,0.00,332.75,215622.00,0.00,0.00,0.00),('19','199','1023','245760',4703359,'3027','467',18.50,18.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245760',4703360,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245760',4703361,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245760',4703362,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245760',4703363,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245760',4703364,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245760',4703365,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245760',4703366,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245976',4706315,'3026','467',2676.50,3216.00,0.00,0.00,539.50,348696.00,0.00,0.00,0.00),('19','199','1023','245976',4706316,'3027','467',18.50,18.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245976',4706317,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245976',4706318,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245976',4706319,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245976',4706320,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245976',4706321,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245976',4706322,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','245976',4706323,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246228',4710628,'3026','467',3216.00,3657.00,0.00,0.00,441.00,284418.00,0.00,0.00,0.00),('19','199','1023','246228',4710629,'3027','467',18.50,31.00,0.00,0.00,12.50,8100.00,0.00,0.00,0.00),('19','199','1023','246228',4710630,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246228',4710631,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246228',4710632,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246228',4710633,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246228',4710634,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246228',4710635,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246228',4710636,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246511',4715490,'3026','467',3657.00,4065.25,0.00,0.00,408.25,262746.00,0.00,0.00,0.00),('19','199','1023','246511',4715491,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246511',4715492,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246511',4715493,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246511',4715494,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246511',4715495,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246511',4715496,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246511',4715497,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246511',4715498,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246748',4719483,'3026','467',4065.25,4388.00,0.00,0.00,322.75,209142.00,0.00,0.00,0.00),('19','199','1023','246748',4719484,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246748',4719485,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246748',4719486,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246748',4719487,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246748',4719488,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246748',4719489,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246748',4719490,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246748',4719491,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246946',4723113,'3026','467',4388.00,4577.00,0.00,0.00,189.00,122472.00,0.00,0.00,0.00),('19','199','1023','246946',4723114,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246946',4723115,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246946',4723116,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246946',4723117,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246946',4723118,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246946',4723119,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246946',4723120,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','246946',4723121,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247442',4731643,'3026','467',4577.00,5015.00,0.00,0.00,438.00,283824.00,0.00,0.00,0.00),('19','199','1023','247442',4731644,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247442',4731645,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247442',4731646,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247442',4731647,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247442',4731648,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247442',4731649,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247442',4731650,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247442',4731651,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247697',4735919,'3026','467',5015.00,5420.75,0.00,0.00,405.75,262926.00,0.00,0.00,0.00),('19','199','1023','247697',4735920,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247697',4735921,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247697',4735922,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247697',4735923,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247697',4735924,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247697',4735925,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247697',4735926,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247697',4735927,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247948',4740048,'3026','467',5420.75,5811.00,0.00,0.00,390.25,251082.00,0.00,0.00,0.00),('19','199','1023','247948',4740049,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247948',4740050,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247948',4740051,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247948',4740052,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247948',4740053,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247948',4740054,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247948',4740055,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','247948',4740056,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248209',4744638,'3026','467',5811.00,6078.75,0.00,0.00,267.75,173502.00,0.00,0.00,0.00),('19','199','1023','248209',4744639,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248209',4744640,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248209',4744641,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248209',4744642,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248209',4744643,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248209',4744644,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248209',4744645,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248209',4744646,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248442',4748435,'3026','467',6078.75,6597.50,0.00,0.00,518.75,336150.00,0.00,0.00,0.00),('19','199','1023','248442',4748436,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248442',4748437,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248442',4748438,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248442',4748439,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248442',4748440,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248442',4748441,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248442',4748442,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248442',4748443,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248675',4752333,'3026','467',6597.50,6874.17,0.00,0.00,276.67,179282.16,0.00,0.00,0.00),('19','199','1023','248675',4752334,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248675',4752335,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248675',4752336,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248675',4752337,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248675',4752338,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248675',4752339,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248675',4752340,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248675',4752341,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248908',4756407,'3026','467',6874.17,7287.42,0.00,0.00,413.25,267786.00,0.00,0.00,0.00),('19','199','1023','248908',4756408,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248908',4756409,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248908',4756410,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248908',4756411,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248908',4756412,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248908',4756413,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248908',4756414,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','248908',4756415,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249150',4760270,'3026','467',7287.42,7623.92,0.00,0.00,336.50,218052.00,0.00,0.00,0.00),('19','199','1023','249150',4760271,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249150',4760272,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249150',4760273,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249150',4760274,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249150',4760275,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249150',4760276,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249150',4760277,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249150',4760278,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249389',4764438,'3026','467',7623.92,8157.42,0.00,0.00,533.50,342018.00,0.00,0.00,0.00),('19','199','1023','249389',4764439,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249389',4764440,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249389',4764441,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249389',4764442,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249389',4764443,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249389',4764444,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249389',4764445,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249389',4764446,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249632',4768576,'3026','467',8157.42,8502.67,0.00,0.00,345.25,223722.00,0.00,0.00,0.00),('19','199','1023','249632',4768577,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249632',4768578,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249632',4768579,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249632',4768580,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249632',4768581,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249632',4768582,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249632',4768583,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249632',4768584,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249892',4772987,'3026','467',8502.67,8979.92,0.00,0.00,477.25,309258.00,0.00,0.00,0.00),('19','199','1023','249892',4772988,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249892',4772989,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249892',4772990,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249892',4772991,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249892',4772992,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249892',4772993,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249892',4772994,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','249892',4772995,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250137',4776996,'3026','467',8979.92,9419.92,0.00,0.00,440.00,285120.00,0.00,0.00,0.00),('19','199','1023','250137',4776997,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250137',4776998,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250137',4776999,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250137',4777000,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250137',4777001,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250137',4777002,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250137',4777003,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250137',4777004,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250363',4780905,'3026','467',9419.92,9810.92,0.00,0.00,391.00,253368.00,0.00,0.00,0.00),('19','199','1023','250363',4780906,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250363',4780907,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250363',4780908,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250363',4780909,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250363',4780910,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250363',4780911,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250363',4780912,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250363',4780913,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250596',4784810,'3026','467',9810.92,10442.42,0.00,0.00,631.50,409212.00,0.00,0.00,0.00),('19','199','1023','250596',4784811,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250596',4784812,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250596',4784813,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250596',4784814,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250596',4784815,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250596',4784816,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250596',4784817,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250596',4784818,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250836',4788963,'3026','467',10442.42,11062.92,0.00,0.00,620.50,402084.00,0.00,0.00,0.00),('19','199','1023','250836',4788964,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250836',4788965,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250836',4788966,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250836',4788967,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250836',4788968,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250836',4788969,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250836',4788970,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','250836',4788971,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251067',4793125,'3026','467',11062.92,11699.92,0.00,0.00,637.00,409176.00,0.00,0.00,0.00),('19','199','1023','251067',4793126,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251067',4793127,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251067',4793128,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251067',4793129,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251067',4793130,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251067',4793131,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251067',4793132,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251067',4793133,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251309',4797350,'3026','467',11699.92,12232.67,0.00,0.00,532.75,341622.00,0.00,0.00,0.00),('19','199','1023','251309',4797351,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251309',4797352,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251309',4797353,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251309',4797354,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251309',4797355,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251309',4797356,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251309',4797357,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251309',4797358,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251567',4801595,'3026','467',12232.67,12832.17,0.00,0.00,599.50,388476.00,0.00,0.00,0.00),('19','199','1023','251567',4801596,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251567',4801597,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251567',4801598,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251567',4801599,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251567',4801600,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251567',4801601,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251567',4801602,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251567',4801603,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251813',4806073,'3026','467',12832.17,13367.92,0.00,0.00,535.75,347166.00,0.00,0.00,0.00),('19','199','1023','251813',4806074,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251813',4806075,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251813',4806076,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251813',4806077,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251813',4806078,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251813',4806079,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251813',4806080,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','251813',4806081,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252048',4810087,'3026','467',13367.92,13750.67,0.00,0.00,382.75,248022.00,0.00,0.00,0.00),('19','199','1023','252048',4810088,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252048',4810089,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252048',4810090,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252048',4810091,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252048',4810092,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252048',4810093,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252048',4810094,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252048',4810095,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252272',4814000,'3026','467',13750.67,14328.92,0.00,0.00,578.25,371106.00,0.00,0.00,0.00),('19','199','1023','252272',4814001,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252272',4814002,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252272',4814003,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252272',4814004,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252272',4814005,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252272',4814006,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252272',4814007,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252272',4814008,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252522',4818530,'3026','467',14328.92,14814.42,0.00,0.00,485.50,314604.00,0.00,0.00,0.00),('19','199','1023','252522',4818531,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252522',4818532,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252522',4818533,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252522',4818534,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252522',4818535,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252522',4818536,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252522',4818537,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252522',4818538,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252776',4822813,'3026','467',14814.42,15291.92,0.00,0.00,477.50,309420.00,0.00,0.00,0.00),('19','199','1023','252776',4822814,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252776',4822815,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252776',4822816,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252776',4822817,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252776',4822818,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252776',4822819,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252776',4822820,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252776',4822821,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252988',4826280,'3026','467',15291.92,15764.17,0.00,0.00,472.25,306018.00,0.00,0.00,0.00),('19','199','1023','252988',4826281,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252988',4826282,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252988',4826283,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252988',4826284,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252988',4826285,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252988',4826286,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252988',4826287,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','252988',4826288,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253243',4830661,'3026','467',15764.17,16188.42,0.00,0.00,424.25,270964.00,0.00,0.00,0.00),('19','199','1023','253243',4830662,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253243',4830663,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253243',4830664,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253243',4830665,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253243',4830666,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253243',4830667,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253243',4830668,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253243',4830669,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253519',4835302,'3026','467',16188.42,16507.67,0.00,0.00,319.25,205074.00,0.00,0.00,0.00),('19','199','1023','253519',4835303,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253519',4835304,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253519',4835305,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253519',4835306,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253519',4835307,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253519',4835308,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253519',4835309,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253519',4835310,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253743',4839083,'3026','467',16507.67,16869.67,0.00,0.00,362.00,234576.00,0.00,0.00,0.00),('19','199','1023','253743',4839084,'3027','467',31.00,31.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253743',4839085,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253743',4839086,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253743',4839087,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253743',4839088,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253743',4839089,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253743',4839090,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253743',4839091,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253981',4843313,'3026','467',16869.67,17336.42,0.00,0.00,466.75,297054.00,0.00,0.00,0.00),('19','199','1023','253981',4843314,'3027','467',31.00,37.00,0.00,0.00,6.00,3888.00,0.00,0.00,0.00),('19','199','1023','253981',4843315,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253981',4843316,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253981',4843317,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253981',4843318,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253981',4843319,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253981',4843320,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','253981',4843321,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254249',4848118,'3026','467',17336.42,17861.17,0.00,0.00,524.75,340038.00,0.00,0.00,0.00),('19','199','1023','254249',4848119,'3027','467',37.00,37.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254249',4848120,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254249',4848121,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254249',4848122,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254249',4848123,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254249',4848124,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254249',4848125,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254249',4848126,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254483',4852063,'3026','467',17861.17,18330.67,0.00,0.00,469.50,298311.00,0.00,0.00,0.00),('19','199','1023','254483',4852064,'3027','467',37.00,37.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254483',4852065,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254483',4852066,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254483',4852067,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254483',4852068,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254483',4852069,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254483',4852070,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254483',4852071,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254709',4856197,'3026','467',18330.67,18675.42,0.00,0.00,344.75,223398.00,0.00,0.00,0.00),('19','199','1023','254709',4856198,'3027','467',37.00,37.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254709',4856199,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254709',4856200,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254709',4856201,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254709',4856202,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254709',4856203,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254709',4856204,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254709',4856205,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254997',4860928,'3026','467',18675.42,19002.67,0.00,0.00,327.25,212058.00,0.00,0.00,0.00),('19','199','1023','254997',4860929,'3027','467',37.00,37.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254997',4860930,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254997',4860931,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254997',4860932,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254997',4860933,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254997',4860934,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254997',4860935,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','254997',4860936,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255227',4864876,'3026','467',19002.67,19444.17,0.00,0.00,441.50,286092.00,0.00,0.00,0.00),('19','199','1023','255227',4864877,'3027','467',37.00,37.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255227',4864878,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255227',4864879,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255227',4864880,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255227',4864881,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255227',4864882,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255227',4864883,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255227',4864884,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255505',4869609,'3026','467',19444.17,20041.92,0.00,0.00,597.75,375492.00,0.00,0.00,0.00),('19','199','1023','255505',4869610,'3027','467',37.00,37.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255505',4869611,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255505',4869612,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255505',4869613,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255505',4869614,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255505',4869615,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255505',4869616,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255505',4869617,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255745',4873649,'3026','467',20041.92,20649.67,0.00,0.00,607.75,389872.00,0.00,0.00,0.00),('19','199','1023','255745',4873650,'3027','467',37.00,37.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255745',4873651,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255745',4873652,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255745',4873653,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255745',4873654,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255745',4873655,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255745',4873656,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255745',4873657,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255963',4877230,'3026','467',20649.67,21046.42,0.00,0.00,396.75,257094.00,0.00,0.00,0.00),('19','199','1023','255963',4877231,'3027','467',37.00,37.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255963',4877232,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255963',4877233,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255963',4877234,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255963',4877235,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255963',4877236,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255963',4877237,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','255963',4877238,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256243',4881585,'3026','467',21046.42,21392.17,0.00,0.00,345.75,224046.00,0.00,0.00,0.00),('19','199','1023','256243',4881586,'3027','467',37.00,40.00,0.00,0.00,3.00,1944.00,0.00,0.00,0.00),('19','199','1023','256243',4881587,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256243',4881588,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256243',4881589,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256243',4881590,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256243',4881591,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256243',4881592,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256243',4881593,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256520',4886507,'3026','467',21392.17,21833.67,0.00,0.00,441.50,286092.00,0.00,0.00,0.00),('19','199','1023','256520',4886508,'3027','467',40.00,40.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256520',4886509,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256520',4886510,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256520',4886511,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256520',4886512,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256520',4886513,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256520',4886514,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256520',4886515,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256763',4890455,'3026','467',21833.67,22145.42,0.00,0.00,311.75,202014.00,0.00,0.00,0.00),('19','199','1023','256763',4890456,'3027','467',40.00,40.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256763',4890457,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256763',4890458,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256763',4890459,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256763',4890460,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256763',4890461,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256763',4890462,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','256763',4890463,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257003',4894637,'3026','467',22145.42,22636.42,0.00,0.00,491.00,318168.00,0.00,0.00,0.00),('19','199','1023','257003',4894638,'3027','467',40.00,40.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257003',4894639,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257003',4894640,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257003',4894641,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257003',4894642,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257003',4894643,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257003',4894644,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257003',4894645,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257272',4899564,'3026','467',22636.42,23243.42,0.00,0.00,607.00,393336.00,0.00,0.00,0.00),('19','199','1023','257272',4899565,'3027','467',40.00,40.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257272',4899566,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257272',4899567,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257272',4899568,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257272',4899569,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257272',4899570,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257272',4899571,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257272',4899572,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257528',4903945,'3026','467',23243.42,23879.67,0.00,0.00,636.25,412290.00,0.00,0.00,0.00),('19','199','1023','257528',4903946,'3027','467',40.00,40.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257528',4903947,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257528',4903948,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257528',4903949,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257528',4903950,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257528',4903951,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257528',4903952,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257528',4903953,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257529',4903954,'3026','467',23879.67,24492.17,0.00,0.00,612.50,396900.00,0.00,0.00,0.00),('19','199','1023','257529',4903955,'3027','467',40.00,40.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257529',4903956,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257529',4903957,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257529',4903958,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257529',4903959,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257529',4903960,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257529',4903961,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257529',4903962,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257530',4903963,'3026','467',24492.17,25041.42,0.00,0.00,549.25,355914.00,0.00,0.00,0.00),('19','199','1023','257530',4903964,'3027','467',40.00,40.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257530',4903965,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257530',4903966,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257530',4903967,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257530',4903968,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257530',4903969,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257530',4903970,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257530',4903971,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257531',4903972,'3026','467',25041.42,25519.17,0.00,0.00,477.75,309582.00,0.00,0.00,0.00),('19','199','1023','257531',4903973,'3027','467',40.00,40.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257531',4903974,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257531',4903975,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257531',4903976,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257531',4903977,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257531',4903978,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257531',4903979,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257531',4903980,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257532',4903981,'3026','467',25519.17,25944.67,0.00,0.00,425.50,275724.00,0.00,0.00,0.00),('19','199','1023','257532',4903982,'3027','467',40.00,40.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257532',4903983,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257532',4903984,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257532',4903985,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257532',4903986,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257532',4903987,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257532',4903988,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257532',4903989,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257533',4903990,'3026','467',25944.67,26432.67,0.00,0.00,488.00,316224.00,0.00,0.00,0.00),('19','199','1023','257533',4903991,'3027','467',40.00,40.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257533',4903992,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257533',4903993,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257533',4903994,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257533',4903995,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257533',4903996,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257533',4903997,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257533',4903998,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257534',4903999,'3026','467',26432.67,27063.92,0.00,0.00,631.25,404250.00,0.00,0.00,0.00),('19','199','1023','257534',4904000,'3027','467',40.00,40.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257534',4904001,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257534',4904002,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257534',4904003,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257534',4904004,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257534',4904005,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257534',4904006,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257534',4904007,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257535',4904008,'3026','467',27063.92,27640.92,0.00,0.00,577.00,366391.00,0.00,0.00,0.00),('19','199','1023','257535',4904009,'3027','467',40.00,40.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257535',4904010,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257535',4904011,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257535',4904012,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257535',4904013,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257535',4904014,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257535',4904015,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257535',4904016,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257536',4904017,'3026','467',27640.92,28111.87,0.00,0.00,470.95,305175.60,0.00,0.00,0.00),('19','199','1023','257536',4904018,'3027','467',40.00,43.00,0.00,0.00,3.00,1944.00,0.00,0.00,0.00),('19','199','1023','257536',4904019,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257536',4904020,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257536',4904021,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257536',4904022,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257536',4904023,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257536',4904024,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257536',4904025,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257537',4904026,'3026','467',28111.87,28677.87,0.00,0.00,566.00,362818.00,0.00,0.00,0.00),('19','199','1023','257537',4904027,'3027','467',43.00,43.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257537',4904028,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257537',4904029,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257537',4904030,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257537',4904031,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257537',4904032,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257537',4904033,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257537',4904034,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257538',4904035,'3026','467',28677.87,29166.12,0.00,0.00,488.25,308881.00,0.00,0.00,0.00),('19','199','1023','257538',4904036,'3027','467',43.00,43.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257538',4904037,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257538',4904038,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257538',4904039,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257538',4904040,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257538',4904041,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257538',4904042,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257538',4904043,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257539',4904044,'3026','467',29166.12,29664.62,0.00,0.00,498.50,321053.00,0.00,0.00,0.00),('19','199','1023','257539',4904045,'3027','467',43.00,43.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257539',4904046,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257539',4904047,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257539',4904048,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257539',4904049,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257539',4904050,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257539',4904051,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257539',4904052,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257540',4904053,'3026','467',29664.62,29938.37,0.00,0.00,273.75,177390.00,0.00,0.00,0.00),('19','199','1023','257540',4904054,'3027','467',43.00,43.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257540',4904055,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257540',4904056,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257540',4904057,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257540',4904058,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257540',4904059,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257540',4904060,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257540',4904061,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257541',4904062,'3026','467',29938.37,30353.12,0.00,0.00,414.75,262438.00,0.00,0.00,0.00),('19','199','1023','257541',4904063,'3027','467',43.00,43.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257541',4904064,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257541',4904065,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257541',4904066,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257541',4904067,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257541',4904068,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257541',4904069,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257541',4904070,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257542',4904071,'3026','467',30353.12,30873.62,0.00,0.00,520.50,337284.00,0.00,0.00,0.00),('19','199','1023','257542',4904072,'3027','467',43.00,43.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257542',4904073,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257542',4904074,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257542',4904075,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257542',4904076,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257542',4904077,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257542',4904078,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257542',4904079,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257543',4904080,'3026','467',30873.62,31235.87,0.00,0.00,362.25,234738.00,0.00,0.00,0.00),('19','199','1023','257543',4904081,'3027','467',43.00,43.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257543',4904082,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257543',4904083,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257543',4904084,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257543',4904085,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257543',4904086,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257543',4904087,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257543',4904088,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257544',4904089,'3026','467',31235.87,31606.12,0.00,0.00,370.25,239922.00,0.00,0.00,0.00),('19','199','1023','257544',4904090,'3027','467',43.00,43.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257544',4904091,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257544',4904092,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257544',4904093,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257544',4904094,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257544',4904095,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257544',4904096,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257544',4904097,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257545',4904098,'3026','467',31606.12,32052.37,0.00,0.00,446.25,289170.00,0.00,0.00,0.00),('19','199','1023','257545',4904099,'3027','467',43.00,43.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257545',4904100,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257545',4904101,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257545',4904102,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257545',4904103,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257545',4904104,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257545',4904105,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257545',4904106,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257546',4904107,'3026','467',32052.37,32352.37,0.00,0.00,300.00,194400.00,0.00,0.00,0.00),('19','199','1023','257546',4904108,'3027','467',43.00,46.00,0.00,0.00,3.00,1944.00,0.00,0.00,0.00),('19','199','1023','257546',4904109,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257546',4904110,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257546',4904111,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257546',4904112,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257546',4904113,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257546',4904114,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257546',4904115,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257547',4904116,'3026','467',32352.37,32592.12,0.00,0.00,239.75,155358.00,0.00,0.00,0.00),('19','199','1023','257547',4904117,'3027','467',46.00,46.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257547',4904118,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257547',4904119,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257547',4904120,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257547',4904121,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257547',4904122,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257547',4904123,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257547',4904124,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257548',4904125,'3026','467',32592.12,32863.62,0.00,0.00,271.50,175932.00,0.00,0.00,0.00),('19','199','1023','257548',4904126,'3027','467',46.00,46.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257548',4904127,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257548',4904128,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257548',4904129,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257548',4904130,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257548',4904131,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257548',4904132,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257548',4904133,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257549',4904134,'3026','467',32863.62,33382.12,0.00,0.00,518.50,335988.00,0.00,0.00,0.00),('19','199','1023','257549',4904135,'3027','467',46.00,46.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257549',4904136,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257549',4904137,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257549',4904138,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257549',4904139,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257549',4904140,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257549',4904141,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257549',4904142,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257550',4904143,'3026','467',33382.12,33637.37,0.00,0.00,255.25,165402.00,0.00,0.00,0.00),('19','199','1023','257550',4904144,'3027','467',46.00,46.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257550',4904145,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257550',4904146,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257550',4904147,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257550',4904148,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257550',4904149,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257550',4904150,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257550',4904151,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257551',4904152,'3026','467',33637.37,33875.62,0.00,0.00,238.25,154386.00,0.00,0.00,0.00),('19','199','1023','257551',4904153,'3027','467',46.00,46.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257551',4904154,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257551',4904155,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257551',4904156,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257551',4904157,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257551',4904158,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257551',4904159,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257551',4904160,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257552',4904161,'3026','467',33875.62,34124.12,0.00,0.00,248.50,161028.00,0.00,0.00,0.00),('19','199','1023','257552',4904162,'3027','467',46.00,46.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257552',4904163,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257552',4904164,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257552',4904165,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257552',4904166,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257552',4904167,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257552',4904168,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257552',4904169,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257553',4904170,'3026','467',34124.12,34346.37,0.00,0.00,222.25,144018.00,0.00,0.00,0.00),('19','199','1023','257553',4904171,'3027','467',46.00,46.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257553',4904172,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257553',4904173,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257553',4904174,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257553',4904175,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257553',4904176,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257553',4904177,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257553',4904178,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257554',4904179,'3026','467',34346.37,34590.37,0.00,0.00,244.00,158112.00,0.00,0.00,0.00),('19','199','1023','257554',4904180,'3027','467',46.00,46.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257554',4904181,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257554',4904182,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257554',4904183,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257554',4904184,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257554',4904185,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257554',4904186,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257554',4904187,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257555',4904188,'3026','467',34590.37,34909.87,0.00,0.00,319.50,207036.00,0.00,0.00,0.00),('19','199','1023','257555',4904189,'3027','467',46.00,46.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257555',4904190,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257555',4904191,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257555',4904192,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257555',4904193,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257555',4904194,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257555',4904195,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257555',4904196,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257556',4904197,'3026','467',34909.87,35302.37,0.00,0.00,392.50,254340.00,0.00,0.00,0.00),('19','199','1023','257556',4904198,'3027','467',46.00,46.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257556',4904199,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257556',4904200,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257556',4904201,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257556',4904202,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257556',4904203,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257556',4904204,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257556',4904205,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257557',4904206,'3026','467',35302.37,35799.37,0.00,0.00,497.00,322056.00,0.00,0.00,0.00),('19','199','1023','257557',4904207,'3027','467',46.00,46.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257557',4904208,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257557',4904209,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257557',4904210,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257557',4904211,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257557',4904212,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257557',4904213,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257557',4904214,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257558',4904215,'3026','467',35799.37,36141.12,0.00,0.00,341.75,201632.50,0.00,0.00,0.00),('19','199','1023','257558',4904216,'3027','467',46.00,58.50,0.00,0.00,12.50,7375.00,0.00,0.00,0.00),('19','199','1023','257558',4904217,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257558',4904218,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257558',4904219,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257558',4904220,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257558',4904221,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257558',4904222,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257558',4904223,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257559',4904224,'3026','467',36141.12,36502.37,0.00,0.00,361.25,213137.50,0.00,0.00,0.00),('19','199','1023','257559',4904225,'3027','467',58.50,58.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257559',4904226,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257559',4904227,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257559',4904228,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257559',4904229,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257559',4904230,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257559',4904231,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257559',4904232,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257560',4904233,'3026','467',36502.37,36777.62,0.00,0.00,275.25,162397.50,0.00,0.00,0.00),('19','199','1023','257560',4904234,'3027','467',58.50,58.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257560',4904235,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257560',4904236,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257560',4904237,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257560',4904238,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257560',4904239,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257560',4904240,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257560',4904241,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257561',4904242,'3026','467',36777.62,37225.62,0.00,0.00,448.00,264320.00,0.00,0.00,0.00),('19','199','1023','257561',4904243,'3027','467',58.50,58.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257561',4904244,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257561',4904245,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257561',4904246,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257561',4904247,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257561',4904248,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257561',4904249,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257561',4904250,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257562',4904251,'3026','467',37225.62,37504.12,0.00,0.00,278.50,164315.00,0.00,0.00,0.00),('19','199','1023','257562',4904252,'3027','467',58.50,58.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257562',4904253,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257562',4904254,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257562',4904255,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257562',4904256,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257562',4904257,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257562',4904258,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257562',4904259,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257563',4904260,'3026','467',37504.12,37634.12,0.00,0.00,130.00,76700.00,0.00,0.00,0.00),('19','199','1023','257563',4904261,'3027','467',58.50,58.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257563',4904262,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257563',4904263,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257563',4904264,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257563',4904265,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257563',4904266,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257563',4904267,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257563',4904268,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257564',4904269,'3026','467',37634.12,37765.62,0.00,0.00,131.50,77585.00,0.00,0.00,0.00),('19','199','1023','257564',4904270,'3027','467',58.50,58.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257564',4904271,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257564',4904272,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257564',4904273,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257564',4904274,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257564',4904275,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257564',4904276,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257564',4904277,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257565',4904278,'3026','467',37765.62,38221.37,0.00,0.00,455.75,268892.50,0.00,0.00,0.00),('19','199','1023','257565',4904279,'3027','467',58.50,58.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257565',4904280,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257565',4904281,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257565',4904282,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257565',4904283,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257565',4904284,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257565',4904285,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257565',4904286,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257566',4904287,'3026','467',38221.37,38479.62,0.00,0.00,258.25,152367.50,0.00,0.00,0.00),('19','199','1023','257566',4904288,'3027','467',58.50,58.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257566',4904289,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257566',4904290,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257566',4904291,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257566',4904292,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257566',4904293,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257566',4904294,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257566',4904295,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257567',4904296,'3026','467',38479.62,38691.12,0.00,0.00,211.50,124785.00,0.00,0.00,0.00),('19','199','1023','257567',4904297,'3027','467',58.50,58.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257567',4904298,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257567',4904299,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257567',4904300,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257567',4904301,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257567',4904302,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257567',4904303,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257567',4904304,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257568',4904305,'3026','467',38691.12,38915.12,0.00,0.00,224.00,132160.00,0.00,0.00,0.00),('19','199','1023','257568',4904306,'3027','467',58.50,58.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257568',4904307,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257568',4904308,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257568',4904309,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257568',4904310,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257568',4904311,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257568',4904312,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257568',4904313,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257569',4904314,'3026','467',38915.12,39488.62,0.00,0.00,573.50,339850.00,0.00,0.00,0.00),('19','199','1023','257569',4904315,'3027','467',58.50,58.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257569',4904316,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257569',4904317,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257569',4904318,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257569',4904319,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257569',4904320,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257569',4904321,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257569',4904322,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257570',4904323,'3026','467',39488.62,40009.62,0.00,0.00,521.00,312600.00,0.00,0.00,0.00),('19','199','1023','257570',4904324,'3027','467',58.50,58.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257570',4904325,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257570',4904326,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257570',4904327,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257570',4904328,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257570',4904329,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257570',4904330,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257570',4904331,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257571',4904332,'3026','467',40009.62,40291.12,0.00,0.00,281.50,182412.00,0.00,0.00,0.00),('19','199','1023','257571',4904333,'3027','467',58.50,58.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257571',4904334,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257571',4904335,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257571',4904336,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257571',4904337,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257571',4904338,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257571',4904339,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257571',4904340,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257572',4904341,'3026','467',40291.12,40452.87,0.00,0.00,161.75,104814.00,0.00,0.00,0.00),('19','199','1023','257572',4904342,'3027','467',58.50,58.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257572',4904343,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257572',4904344,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257572',4904345,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257572',4904346,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257572',4904347,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257572',4904348,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257572',4904349,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257573',4904350,'3026','467',40452.87,40790.87,0.00,0.00,338.00,219024.00,0.00,0.00,0.00),('19','199','1023','257573',4904351,'3027','467',58.50,58.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257573',4904352,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257573',4904353,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257573',4904354,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257573',4904355,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257573',4904356,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257573',4904357,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257573',4904358,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257574',4904359,'3026','467',40790.87,41017.87,0.00,0.00,227.00,147096.00,0.00,0.00,0.00),('19','199','1023','257574',4904360,'3027','467',58.50,58.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257574',4904361,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257574',4904362,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257574',4904363,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257574',4904364,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257574',4904365,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257574',4904366,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257574',4904367,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257575',4904368,'3026','467',41017.87,41181.12,0.00,0.00,163.25,105786.00,0.00,0.00,0.00),('19','199','1023','257575',4904369,'3027','467',58.50,58.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257575',4904370,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257575',4904371,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257575',4904372,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257575',4904373,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257575',4904374,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257575',4904375,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257575',4904376,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257576',4904377,'3026','467',41181.12,41609.12,0.00,0.00,428.00,270144.00,0.00,0.00,0.00),('19','199','1023','257576',4904378,'3027','467',58.50,64.75,0.00,0.00,6.25,4050.00,0.00,0.00,0.00),('19','199','1023','257576',4904379,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257576',4904380,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257576',4904381,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257576',4904382,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257576',4904383,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257576',4904384,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257576',4904385,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257577',4904386,'3026','467',41609.12,41911.12,0.00,0.00,302.00,195696.00,0.00,0.00,0.00),('19','199','1023','257577',4904387,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257577',4904388,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257577',4904389,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257577',4904390,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257577',4904391,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257577',4904392,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257577',4904393,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257577',4904394,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257578',4904395,'3026','467',41911.12,42226.37,0.00,0.00,315.25,204282.00,0.00,0.00,0.00),('19','199','1023','257578',4904396,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257578',4904397,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257578',4904398,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257578',4904399,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257578',4904400,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257578',4904401,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257578',4904402,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257578',4904403,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257579',4904404,'3026','467',42226.37,42568.12,0.00,0.00,341.75,221454.00,0.00,0.00,0.00),('19','199','1023','257579',4904405,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257579',4904406,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257579',4904407,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257579',4904408,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257579',4904409,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257579',4904410,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257579',4904411,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257579',4904412,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257580',4904413,'3026','467',42568.12,42842.12,0.00,0.00,274.00,177552.00,0.00,0.00,0.00),('19','199','1023','257580',4904414,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257580',4904415,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257580',4904416,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257580',4904417,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257580',4904418,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257580',4904419,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257580',4904420,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257580',4904421,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257581',4904422,'3026','467',42842.12,43059.37,0.00,0.00,217.25,145992.00,0.00,0.00,0.00),('19','199','1023','257581',4904423,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257581',4904424,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257581',4904425,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257581',4904426,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257581',4904427,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257581',4904428,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257581',4904429,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257581',4904430,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257582',4904431,'3026','467',43059.37,43262.87,0.00,0.00,203.50,136752.00,0.00,0.00,0.00),('19','199','1023','257582',4904432,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257582',4904433,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257582',4904434,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257582',4904435,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257582',4904436,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257582',4904437,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257582',4904438,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257582',4904439,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257583',4904440,'3026','467',43262.87,43508.62,0.00,0.00,245.75,165144.00,0.00,0.00,0.00),('19','199','1023','257583',4904441,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257583',4904442,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257583',4904443,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257583',4904444,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257583',4904445,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257583',4904446,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257583',4904447,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257583',4904448,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257584',4904449,'3026','467',43508.62,43874.12,0.00,0.00,365.50,245616.00,0.00,0.00,0.00),('19','199','1023','257584',4904450,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257584',4904451,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257584',4904452,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257584',4904453,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257584',4904454,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257584',4904455,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257584',4904456,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257584',4904457,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257585',4904458,'3026','467',43874.12,44266.62,0.00,0.00,392.50,263760.00,0.00,0.00,0.00),('19','199','1023','257585',4904459,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257585',4904460,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257585',4904461,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257585',4904462,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257585',4904463,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257585',4904464,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257585',4904465,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257585',4904466,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257586',4904467,'3026','467',44266.62,44768.12,0.00,0.00,501.50,337008.00,0.00,0.00,0.00),('19','199','1023','257586',4904468,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257586',4904469,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257586',4904470,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257586',4904471,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257586',4904472,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257586',4904473,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257586',4904474,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257586',4904475,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257587',4904476,'3026','467',44768.12,45171.87,0.00,0.00,403.75,271320.00,0.00,0.00,0.00),('19','199','1023','257587',4904477,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257587',4904478,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257587',4904479,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257587',4904480,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257587',4904481,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257587',4904482,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257587',4904483,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257587',4904484,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257588',4904485,'3026','467',45171.87,45610.62,0.00,0.00,438.75,294840.00,0.00,0.00,0.00),('19','199','1023','257588',4904486,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257588',4904487,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257588',4904488,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257588',4904489,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257588',4904490,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257588',4904491,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257588',4904492,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257588',4904493,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257589',4904494,'3026','467',45610.62,46124.87,0.00,0.00,514.25,345576.00,0.00,0.00,0.00),('19','199','1023','257589',4904495,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257589',4904496,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257589',4904497,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257589',4904498,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257589',4904499,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257589',4904500,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257589',4904501,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257589',4904502,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257590',4904503,'3026','467',46124.87,47120.37,0.00,0.00,995.50,668976.00,0.00,0.00,0.00),('19','199','1023','257590',4904504,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257590',4904505,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257590',4904506,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257590',4904507,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257590',4904508,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257590',4904509,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257590',4904510,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257590',4904511,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257591',4904512,'3026','467',47120.37,47847.37,0.00,0.00,727.00,487944.00,0.00,0.00,0.00),('19','199','1023','257591',4904513,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257591',4904514,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257591',4904515,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257591',4904516,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257591',4904517,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257591',4904518,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257591',4904519,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257591',4904520,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257592',4904521,'3026','467',47847.37,48382.37,0.00,0.00,535.00,359520.00,0.00,0.00,0.00),('19','199','1023','257592',4904522,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257592',4904523,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257592',4904524,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257592',4904525,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257592',4904526,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257592',4904527,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257592',4904528,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257592',4904529,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257593',4904530,'3026','467',48382.37,48655.87,0.00,0.00,273.50,183792.00,0.00,0.00,0.00),('19','199','1023','257593',4904531,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257593',4904532,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257593',4904533,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257593',4904534,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257593',4904535,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257593',4904536,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257593',4904537,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257593',4904538,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257594',4904539,'3026','467',48655.87,49171.12,0.00,0.00,515.25,346248.00,0.00,0.00,0.00),('19','199','1023','257594',4904540,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257594',4904541,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257594',4904542,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257594',4904543,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257594',4904544,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257594',4904545,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257594',4904546,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257594',4904547,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257595',4904548,'3026','467',49171.12,49557.62,0.00,0.00,386.50,259728.00,0.00,0.00,0.00),('19','199','1023','257595',4904549,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257595',4904550,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257595',4904551,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257595',4904552,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257595',4904553,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257595',4904554,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257595',4904555,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257595',4904556,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257596',4904557,'3026','467',49557.62,49869.37,0.00,0.00,311.75,209496.00,0.00,0.00,0.00),('19','199','1023','257596',4904558,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257596',4904559,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257596',4904560,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257596',4904561,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257596',4904562,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257596',4904563,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257596',4904564,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257596',4904565,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257597',4904566,'3026','467',49869.37,50185.87,0.00,0.00,316.50,212688.00,0.00,0.00,0.00),('19','199','1023','257597',4904567,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257597',4904568,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257597',4904569,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257597',4904570,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257597',4904571,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257597',4904572,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257597',4904573,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257597',4904574,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257598',4904575,'3026','467',50185.87,50704.62,0.00,0.00,518.75,348000.00,0.00,0.00,0.00),('19','199','1023','257598',4904576,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257598',4904577,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257598',4904578,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257598',4904579,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257598',4904580,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257598',4904581,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257598',4904582,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257598',4904583,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257599',4904584,'3026','467',50704.62,50725.12,0.00,0.00,20.50,13776.00,0.00,0.00,0.00),('19','199','1023','257599',4904585,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257599',4904586,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257599',4904587,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257599',4904588,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257599',4904589,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257599',4904590,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257599',4904591,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257599',4904592,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257600',4904593,'3026','467',50725.12,50965.12,0.00,0.00,240.00,161280.00,0.00,0.00,0.00),('19','199','1023','257600',4904594,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257600',4904595,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257600',4904596,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257600',4904597,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257600',4904598,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257600',4904599,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257600',4904600,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257600',4904601,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257601',4904602,'3026','467',50965.12,51262.37,0.00,0.00,297.25,199752.00,0.00,0.00,0.00),('19','199','1023','257601',4904603,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257601',4904604,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257601',4904605,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257601',4904606,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257601',4904607,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257601',4904608,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257601',4904609,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257601',4904610,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257602',4904611,'3026','467',51262.37,51557.12,0.00,0.00,294.75,198072.00,0.00,0.00,0.00),('19','199','1023','257602',4904612,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257602',4904613,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257602',4904614,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257602',4904615,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257602',4904616,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257602',4904617,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257602',4904618,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257602',4904619,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257603',4904620,'3026','467',51557.12,51809.12,0.00,0.00,252.00,169344.00,0.00,0.00,0.00),('19','199','1023','257603',4904621,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257603',4904622,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257603',4904623,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257603',4904624,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257603',4904625,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257603',4904626,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257603',4904627,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257603',4904628,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257604',4904629,'3026','467',51809.12,52149.37,0.00,0.00,340.25,228648.00,0.00,0.00,0.00),('19','199','1023','257604',4904630,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257604',4904631,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257604',4904632,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257604',4904633,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257604',4904634,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257604',4904635,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257604',4904636,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257604',4904637,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257605',4904638,'3026','467',52149.37,52778.62,0.00,0.00,629.25,422856.00,0.00,0.00,0.00),('19','199','1023','257605',4904639,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257605',4904640,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257605',4904641,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257605',4904642,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257605',4904643,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257605',4904644,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257605',4904645,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257605',4904646,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257606',4904647,'3026','467',52778.62,53189.62,0.00,0.00,411.00,276192.00,0.00,0.00,0.00),('19','199','1023','257606',4904648,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257606',4904649,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257606',4904650,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257606',4904651,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257606',4904652,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257606',4904653,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257606',4904654,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257606',4904655,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257607',4904656,'3026','467',53189.62,53448.87,0.00,0.00,259.25,174216.00,0.00,0.00,0.00),('19','199','1023','257607',4904657,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257607',4904658,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257607',4904659,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257607',4904660,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257607',4904661,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257607',4904662,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257607',4904663,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257607',4904664,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257608',4904665,'3026','467',53448.87,53727.12,0.00,0.00,278.25,186984.00,0.00,0.00,0.00),('19','199','1023','257608',4904666,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257608',4904667,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257608',4904668,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257608',4904669,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257608',4904670,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257608',4904671,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257608',4904672,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257608',4904673,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257609',4904674,'3026','467',53727.12,53945.37,0.00,0.00,218.25,146664.00,0.00,0.00,0.00),('19','199','1023','257609',4904675,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257609',4904676,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257609',4904677,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257609',4904678,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257609',4904679,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257609',4904680,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257609',4904681,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257609',4904682,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257610',4904683,'3026','467',53945.37,54147.12,0.00,0.00,201.75,135576.00,0.00,0.00,0.00),('19','199','1023','257610',4904684,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257610',4904685,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257610',4904686,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257610',4904687,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257610',4904688,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257610',4904689,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257610',4904690,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257610',4904691,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257611',4904692,'3026','467',54147.12,54365.87,0.00,0.00,218.75,147000.00,0.00,0.00,0.00),('19','199','1023','257611',4904693,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257611',4904694,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257611',4904695,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257611',4904696,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257611',4904697,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257611',4904698,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257611',4904699,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257611',4904700,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257612',4904701,'3026','467',54365.87,54665.37,0.00,0.00,299.50,201264.00,0.00,0.00,0.00),('19','199','1023','257612',4904702,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257612',4904703,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257612',4904704,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257612',4904705,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257612',4904706,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257612',4904707,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257612',4904708,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257612',4904709,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257613',4904710,'3026','467',54665.37,54981.12,0.00,0.00,315.75,212184.00,0.00,0.00,0.00),('19','199','1023','257613',4904711,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257613',4904712,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257613',4904713,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257613',4904714,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257613',4904715,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257613',4904716,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257613',4904717,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257613',4904718,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257614',4904719,'3026','467',54981.12,55281.12,0.00,0.00,300.00,191400.00,0.00,0.00,0.00),('19','199','1023','257614',4904720,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257614',4904721,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257614',4904722,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257614',4904723,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257614',4904724,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257614',4904725,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257614',4904726,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257614',4904727,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257615',4904728,'3026','467',55281.12,55671.37,0.00,0.00,390.25,248979.50,0.00,0.00,0.00),('19','199','1023','257615',4904729,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257615',4904730,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257615',4904731,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257615',4904732,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257615',4904733,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257615',4904734,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257615',4904735,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257615',4904736,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257616',4904737,'3026','467',55671.37,55895.87,0.00,0.00,224.50,143231.00,0.00,0.00,0.00),('19','199','1023','257616',4904738,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257616',4904739,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257616',4904740,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257616',4904741,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257616',4904742,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257616',4904743,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257616',4904744,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257616',4904745,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257617',4904746,'3026','467',55895.87,56204.62,0.00,0.00,308.75,196982.50,0.00,0.00,0.00),('19','199','1023','257617',4904747,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257617',4904748,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257617',4904749,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257617',4904750,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257617',4904751,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257617',4904752,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257617',4904753,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257617',4904754,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257618',4904755,'3026','467',56204.62,56737.87,0.00,0.00,533.25,337213.50,0.00,0.00,0.00),('19','199','1023','257618',4904756,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257618',4904757,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257618',4904758,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257618',4904759,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257618',4904760,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257618',4904761,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257618',4904762,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257618',4904763,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257619',4904764,'3026','467',56737.87,57660.87,0.00,0.00,923.00,583174.00,0.00,0.00,0.00),('19','199','1023','257619',4904765,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257619',4904766,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257619',4904767,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257619',4904768,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257619',4904769,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257619',4904770,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257619',4904771,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257619',4904772,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257620',4904773,'3026','467',57660.87,58154.12,0.00,0.00,493.25,311093.50,0.00,0.00,0.00),('19','199','1023','257620',4904774,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257620',4904775,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257620',4904776,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257620',4904777,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257620',4904778,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257620',4904779,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257620',4904780,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257620',4904781,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257621',4904782,'3026','467',58154.12,58430.87,0.00,0.00,276.75,176566.50,0.00,0.00,0.00),('19','199','1023','257621',4904783,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257621',4904784,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257621',4904785,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257621',4904786,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257621',4904787,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257621',4904788,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257621',4904789,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257621',4904790,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257622',4904791,'3026','467',58430.87,58704.12,0.00,0.00,273.25,174333.50,0.00,0.00,0.00),('19','199','1023','257622',4904792,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257622',4904793,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257622',4904794,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257622',4904795,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257622',4904796,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257622',4904797,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257622',4904798,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257622',4904799,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257623',4904800,'3026','467',58704.12,58903.62,0.00,0.00,199.50,127281.00,0.00,0.00,0.00),('19','199','1023','257623',4904801,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257623',4904802,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257623',4904803,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257623',4904804,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257623',4904805,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257623',4904806,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257623',4904807,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257623',4904808,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257624',4904809,'3026','467',58903.62,59181.12,0.00,0.00,277.50,175245.00,0.00,0.00,0.00),('19','199','1023','257624',4904810,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257624',4904811,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257624',4904812,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257624',4904813,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257624',4904814,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257624',4904815,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257624',4904816,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257624',4904817,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257625',4904818,'3026','467',59181.12,59622.87,0.00,0.00,441.75,281836.50,0.00,0.00,0.00),('19','199','1023','257625',4904819,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257625',4904820,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257625',4904821,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257625',4904822,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257625',4904823,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257625',4904824,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257625',4904825,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257625',4904826,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257626',4904827,'3026','467',59622.87,59997.62,0.00,0.00,374.75,239090.50,0.00,0.00,0.00),('19','199','1023','257626',4904828,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257626',4904829,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257626',4904830,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257626',4904831,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257626',4904832,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257626',4904833,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257626',4904834,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257626',4904835,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257627',4904836,'3026','467',59997.62,60274.62,0.00,0.00,277.00,176726.00,0.00,0.00,0.00),('19','199','1023','257627',4904837,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257627',4904838,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257627',4904839,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257627',4904840,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257627',4904841,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257627',4904842,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257627',4904843,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257627',4904844,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257628',4904845,'3026','467',60274.62,60845.12,0.00,0.00,570.50,363979.00,0.00,0.00,0.00),('19','199','1023','257628',4904846,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257628',4904847,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257628',4904848,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257628',4904849,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257628',4904850,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257628',4904851,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257628',4904852,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257628',4904853,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257629',4904854,'3026','467',60845.12,61095.62,0.00,0.00,250.50,159819.00,0.00,0.00,0.00),('19','199','1023','257629',4904855,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257629',4904856,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257629',4904857,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257629',4904858,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257629',4904859,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257629',4904860,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257629',4904861,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257629',4904862,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257630',4904863,'3026','467',61095.62,61364.62,0.00,0.00,269.00,171622.00,0.00,0.00,0.00),('19','199','1023','257630',4904864,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257630',4904865,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257630',4904866,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257630',4904867,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257630',4904868,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257630',4904869,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257630',4904870,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257630',4904871,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257631',4904872,'3026','467',61364.62,61582.62,0.00,0.00,218.00,139084.00,0.00,0.00,0.00),('19','199','1023','257631',4904873,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257631',4904874,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257631',4904875,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257631',4904876,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257631',4904877,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257631',4904878,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257631',4904879,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257631',4904880,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257632',4904881,'3026','467',61582.62,61926.37,0.00,0.00,343.75,219312.50,0.00,0.00,0.00),('19','199','1023','257632',4904882,'3027','467',64.75,64.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257632',4904883,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257632',4904884,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257632',4904885,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257632',4904886,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257632',4904887,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257632',4904888,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257632',4904889,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257633',4904890,'3026','467',61926.37,62291.37,0.00,0.00,365.00,232870.00,0.00,0.00,0.00),('19','199','1023','257633',4904891,'3027','467',64.75,74.75,0.00,0.00,10.00,6380.00,0.00,0.00,0.00),('19','199','1023','257633',4904892,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257633',4904893,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257633',4904894,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257633',4904895,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257633',4904896,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257633',4904897,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257633',4904898,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257634',4904899,'3026','467',62291.37,62570.12,0.00,0.00,278.75,177842.50,0.00,0.00,0.00),('19','199','1023','257634',4904900,'3027','467',74.75,74.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257634',4904901,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257634',4904902,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257634',4904903,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257634',4904904,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257634',4904905,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257634',4904906,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257634',4904907,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257635',4904908,'3026','467',62570.12,62570.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257635',4904909,'3027','467',74.75,74.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257635',4904910,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257635',4904911,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257635',4904912,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257635',4904913,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257635',4904914,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257635',4904915,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257635',4904916,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257636',4904917,'3026','467',62570.12,62782.37,0.00,0.00,212.25,135415.50,0.00,0.00,0.00),('19','199','1023','257636',4904918,'3027','467',74.75,74.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257636',4904919,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257636',4904920,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257636',4904921,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257636',4904922,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257636',4904923,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257636',4904924,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257636',4904925,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257637',4904926,'3026','467',62782.37,63077.62,0.00,0.00,295.25,188369.50,0.00,0.00,0.00),('19','199','1023','257637',4904927,'3027','467',74.75,81.00,0.00,0.00,6.25,3987.50,0.00,0.00,0.00),('19','199','1023','257637',4904928,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257637',4904929,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257637',4904930,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257637',4904931,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257637',4904932,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257637',4904933,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257637',4904934,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257638',4904935,'3026','467',63077.62,63523.12,0.00,0.00,445.50,284229.00,0.00,0.00,0.00),('19','199','1023','257638',4904936,'3027','467',81.00,81.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257638',4904937,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257638',4904938,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257638',4904939,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257638',4904940,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257638',4904941,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257638',4904942,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257638',4904943,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257639',4904944,'3026','467',63523.12,63853.62,0.00,0.00,330.50,210859.00,0.00,0.00,0.00),('19','199','1023','257639',4904945,'3027','467',81.00,81.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257639',4904946,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257639',4904947,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257639',4904948,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257639',4904949,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257639',4904950,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257639',4904951,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257639',4904952,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257640',4904953,'3026','467',63853.62,64386.87,0.00,0.00,533.25,340213.50,0.00,0.00,0.00),('19','199','1023','257640',4904954,'3027','467',81.00,81.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257640',4904955,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257640',4904956,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257640',4904957,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257640',4904958,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257640',4904959,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257640',4904960,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257640',4904961,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257641',4904962,'3026','467',64386.87,64745.87,0.00,0.00,359.00,229042.00,0.00,0.00,0.00),('19','199','1023','257641',4904963,'3027','467',81.00,87.25,0.00,0.00,6.25,3987.50,0.00,0.00,0.00),('19','199','1023','257641',4904964,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257641',4904965,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257641',4904966,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257641',4904967,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257641',4904968,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257641',4904969,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257641',4904970,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257642',4904971,'3026','467',64745.87,65008.37,0.00,0.00,262.50,167475.00,0.00,0.00,0.00),('19','199','1023','257642',4904972,'3027','467',87.25,87.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257642',4904973,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257642',4904974,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257642',4904975,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257642',4904976,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257642',4904977,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257642',4904978,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257642',4904979,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257643',4904980,'3026','467',65008.37,65361.87,0.00,0.00,353.50,225533.00,0.00,0.00,0.00),('19','199','1023','257643',4904981,'3027','467',87.25,87.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257643',4904982,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257643',4904983,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257643',4904984,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257643',4904985,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257643',4904986,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257643',4904987,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257643',4904988,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257644',4904989,'3026','467',65361.87,65756.62,0.00,0.00,394.75,249450.50,0.00,0.00,0.00),('19','199','1023','257644',4904990,'3027','467',87.25,87.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257644',4904991,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257644',4904992,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257644',4904993,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257644',4904994,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257644',4904995,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257644',4904996,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257644',4904997,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257645',4904998,'3026','467',65756.62,66059.87,0.00,0.00,303.25,193473.50,0.00,0.00,0.00),('19','199','1023','257645',4904999,'3027','467',87.25,87.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257645',4905000,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257645',4905001,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257645',4905002,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257645',4905003,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257645',4905004,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257645',4905005,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257645',4905006,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257646',4905007,'3026','467',66059.87,66489.87,0.00,0.00,430.00,274340.00,0.00,0.00,0.00),('19','199','1023','257646',4905008,'3027','467',87.25,87.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257646',4905009,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257646',4905010,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257646',4905011,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257646',4905012,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257646',4905013,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257646',4905014,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257646',4905015,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257647',4905016,'3026','467',66489.87,67153.12,0.00,0.00,663.25,420753.50,0.00,0.00,0.00),('19','199','1023','257647',4905017,'3027','467',87.25,87.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257647',4905018,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257647',4905019,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257647',4905020,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257647',4905021,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257647',4905022,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257647',4905023,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257647',4905024,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257648',4905025,'3026','467',67153.12,67620.87,0.00,0.00,467.75,297599.50,0.00,0.00,0.00),('19','199','1023','257648',4905026,'3027','467',87.25,87.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257648',4905027,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257648',4905028,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257648',4905029,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257648',4905030,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257648',4905031,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257648',4905032,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257648',4905033,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257649',4905034,'3026','467',67620.87,68139.37,0.00,0.00,518.50,326653.00,0.00,0.00,0.00),('19','199','1023','257649',4905035,'3027','467',87.25,112.25,0.00,0.00,25.00,15950.00,0.00,0.00,0.00),('19','199','1023','257649',4905036,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257649',4905037,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257649',4905038,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257649',4905039,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257649',4905040,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257649',4905041,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257649',4905042,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257650',4905043,'3026','467',68139.37,68533.87,0.00,0.00,394.50,272719.00,0.00,0.00,0.00),('19','199','1023','257650',4905044,'3027','467',112.25,112.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257650',4905045,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257650',4905046,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257650',4905047,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257650',4905048,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257650',4905049,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257650',4905050,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257650',4905051,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257651',4905052,'3026','467',68533.87,68884.12,0.00,0.00,350.25,242373.00,0.00,0.00,0.00),('19','199','1023','257651',4905053,'3027','467',112.25,112.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257651',4905054,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257651',4905055,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257651',4905056,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257651',4905057,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257651',4905058,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257651',4905059,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257651',4905060,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257652',4905061,'3026','467',68884.12,69299.62,0.00,0.00,415.50,287526.00,0.00,0.00,0.00),('19','199','1023','257652',4905062,'3027','467',112.25,112.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257652',4905063,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257652',4905064,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257652',4905065,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257652',4905066,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257652',4905067,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257652',4905068,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257652',4905069,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257653',4905070,'3026','467',69299.62,69602.37,0.00,0.00,302.75,209503.00,0.00,0.00,0.00),('19','199','1023','257653',4905071,'3027','467',112.25,112.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257653',4905072,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257653',4905073,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257653',4905074,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257653',4905075,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257653',4905076,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257653',4905077,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257653',4905078,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257654',4905079,'3026','467',69602.37,70064.37,0.00,0.00,462.00,319204.00,0.00,0.00,0.00),('19','199','1023','257654',4905080,'3027','467',112.25,112.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257654',4905081,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257654',4905082,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257654',4905083,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257654',4905084,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257654',4905085,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257654',4905086,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257654',4905087,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257655',4905088,'3026','467',70064.37,70467.37,0.00,0.00,403.00,278876.00,0.00,0.00,0.00),('19','199','1023','257655',4905089,'3027','467',112.25,124.75,0.00,0.00,12.50,8650.00,0.00,0.00,0.00),('19','199','1023','257655',4905090,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257655',4905091,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257655',4905092,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257655',4905093,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257655',4905094,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257655',4905095,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257655',4905096,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257656',4905097,'3026','467',70467.37,70815.12,0.00,0.00,347.75,240643.00,0.00,0.00,0.00),('19','199','1023','257656',4905098,'3027','467',124.75,124.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257656',4905099,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257656',4905100,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257656',4905101,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257656',4905102,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257656',4905103,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257656',4905104,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257656',4905105,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257657',4905106,'3026','467',70815.12,71054.12,0.00,0.00,239.00,165388.00,0.00,0.00,0.00),('19','199','1023','257657',4905107,'3027','467',124.75,137.25,0.00,0.00,12.50,8650.00,0.00,0.00,0.00),('19','199','1023','257657',4905108,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257657',4905109,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257657',4905110,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257657',4905111,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257657',4905112,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257657',4905113,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257657',4905114,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257658',4905115,'3026','467',71054.12,71366.37,0.00,0.00,312.25,216077.00,0.00,0.00,0.00),('19','199','1023','257658',4905116,'3027','467',137.25,137.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257658',4905117,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257658',4905118,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257658',4905119,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257658',4905120,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257658',4905121,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257658',4905122,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257658',4905123,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257659',4905124,'3026','467',71366.37,71745.62,0.00,0.00,379.25,259141.00,0.00,0.00,0.00),('19','199','1023','257659',4905125,'3027','467',137.25,137.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257659',4905126,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257659',4905127,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257659',4905128,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257659',4905129,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257659',4905130,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257659',4905131,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257659',4905132,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257660',4905133,'3026','467',71745.62,72107.37,0.00,0.00,361.75,250331.00,0.00,0.00,0.00),('19','199','1023','257660',4905134,'3027','467',137.25,137.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257660',4905135,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257660',4905136,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257660',4905137,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257660',4905138,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257660',4905139,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257660',4905140,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257660',4905141,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257661',4905142,'3026','467',72107.37,72516.12,0.00,0.00,408.75,282855.00,0.00,0.00,0.00),('19','199','1023','257661',4905143,'3027','467',137.25,137.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257661',4905144,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257661',4905145,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257661',4905146,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257661',4905147,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257661',4905148,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257661',4905149,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257661',4905150,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257662',4905151,'3026','467',72516.12,72952.87,0.00,0.00,436.75,302231.00,0.00,0.00,0.00),('19','199','1023','257662',4905152,'3027','467',137.25,143.50,0.00,0.00,6.25,4325.00,0.00,0.00,0.00),('19','199','1023','257662',4905153,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257662',4905154,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257662',4905155,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257662',4905156,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257662',4905157,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257662',4905158,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257662',4905159,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257663',4905160,'3026','467',72952.87,73397.37,0.00,0.00,444.50,305394.00,0.00,0.00,0.00),('19','199','1023','257663',4905161,'3027','467',143.50,143.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257663',4905162,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257663',4905163,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257663',4905164,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257663',4905165,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257663',4905166,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257663',4905167,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257663',4905168,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257664',4905169,'3026','467',73397.37,73705.37,0.00,0.00,308.00,213136.00,0.00,0.00,0.00),('19','199','1023','257664',4905170,'3027','467',143.50,143.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257664',4905171,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257664',4905172,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257664',4905173,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257664',4905174,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257664',4905175,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257664',4905176,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257664',4905177,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257665',4905178,'3026','467',73705.37,73973.12,0.00,0.00,267.75,195457.50,0.00,0.00,0.00),('19','199','1023','257665',4905179,'3027','467',143.50,143.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257665',4905180,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257665',4905181,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257665',4905182,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257665',4905183,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257665',4905184,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257665',4905185,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257665',4905186,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257666',4905187,'3026','467',73973.12,74304.12,0.00,0.00,331.00,241630.00,0.00,0.00,0.00),('19','199','1023','257666',4905188,'3027','467',143.50,143.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257666',4905189,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257666',4905190,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257666',4905191,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257666',4905192,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257666',4905193,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257666',4905194,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257666',4905195,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257667',4905196,'3026','467',74304.12,74530.12,0.00,0.00,226.00,164980.00,0.00,0.00,0.00),('19','199','1023','257667',4905197,'3027','467',143.50,143.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257667',4905198,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257667',4905199,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257667',4905200,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257667',4905201,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257667',4905202,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257667',4905203,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257667',4905204,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257668',4905205,'3026','467',74530.12,74850.37,0.00,0.00,320.25,233782.50,0.00,0.00,0.00),('19','199','1023','257668',4905206,'3027','467',143.50,143.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257668',4905207,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257668',4905208,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257668',4905209,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257668',4905210,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257668',4905211,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257668',4905212,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257668',4905213,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257669',4905214,'3026','467',74850.37,75062.87,0.00,0.00,212.50,155125.00,0.00,0.00,0.00),('19','199','1023','257669',4905215,'3027','467',143.50,143.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257669',4905216,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257669',4905217,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257669',4905218,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257669',4905219,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257669',4905220,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257669',4905221,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257669',4905222,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257670',4905223,'3026','467',75062.87,75384.37,0.00,0.00,321.50,234695.00,0.00,0.00,0.00),('19','199','1023','257670',4905224,'3027','467',143.50,143.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257670',4905225,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257670',4905226,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257670',4905227,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257670',4905228,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257670',4905229,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257670',4905230,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257670',4905231,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257671',4905232,'3026','467',75384.37,75609.12,0.00,0.00,224.75,164067.50,0.00,0.00,0.00),('19','199','1023','257671',4905233,'3027','467',143.50,143.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257671',4905234,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257671',4905235,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257671',4905236,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257671',4905237,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257671',4905238,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257671',4905239,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257671',4905240,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257672',4905241,'3026','467',75609.12,75792.37,0.00,0.00,183.25,133772.50,0.00,0.00,0.00),('19','199','1023','257672',4905242,'3027','467',143.50,143.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257672',4905243,'3028','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257672',4905244,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257672',4905245,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257672',4905246,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257672',4905247,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257672',4905248,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257672',4905249,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257673',4905250,'3026','467',75792.37,76096.12,0.00,0.00,303.75,221737.50,0.00,0.00,0.00),('19','199','1023','257673',4905251,'3027','467',143.50,143.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257673',4905252,'3028','467',0.00,50.00,0.00,0.00,50.00,36500.00,0.00,0.00,0.00),('19','199','1023','257673',4905253,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257673',4905254,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257673',4905255,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257673',4905256,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257673',4905257,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257673',4905258,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257674',4905259,'3026','467',76096.12,76353.12,0.00,0.00,257.00,187610.00,0.00,0.00,0.00),('19','199','1023','257674',4905260,'3027','467',143.50,143.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257674',4905261,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257674',4905262,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257674',4905263,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257674',4905264,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257674',4905265,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257674',4905266,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257674',4905267,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257675',4905268,'3026','467',76353.12,76922.62,0.00,0.00,569.50,415735.00,0.00,0.00,0.00),('19','199','1023','257675',4905269,'3027','467',143.50,143.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257675',4905270,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257675',4905271,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257675',4905272,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257675',4905273,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257675',4905274,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257675',4905275,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257675',4905276,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257676',4905277,'3026','467',76922.62,77200.37,0.00,0.00,277.75,202757.50,0.00,0.00,0.00),('19','199','1023','257676',4905278,'3027','467',143.50,149.75,0.00,0.00,6.25,4562.50,0.00,0.00,0.00),('19','199','1023','257676',4905279,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257676',4905280,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257676',4905281,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257676',4905282,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257676',4905283,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257676',4905284,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257676',4905285,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257677',4905286,'3026','467',77200.37,77513.62,0.00,0.00,313.25,228672.50,0.00,0.00,0.00),('19','199','1023','257677',4905287,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257677',4905288,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257677',4905289,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257677',4905290,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257677',4905291,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257677',4905292,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257677',4905293,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257677',4905294,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257678',4905295,'3026','467',77513.62,77862.37,0.00,0.00,348.75,254587.50,0.00,0.00,0.00),('19','199','1023','257678',4905296,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257678',4905297,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257678',4905298,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257678',4905299,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257678',4905300,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257678',4905301,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257678',4905302,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257678',4905303,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257679',4905304,'3026','467',77862.37,78073.12,0.00,0.00,210.75,153847.50,0.00,0.00,0.00),('19','199','1023','257679',4905305,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257679',4905306,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257679',4905307,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257679',4905308,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257679',4905309,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257679',4905310,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257679',4905311,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257679',4905312,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257680',4905313,'3026','467',78073.12,78447.37,0.00,0.00,374.25,273202.50,0.00,0.00,0.00),('19','199','1023','257680',4905314,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257680',4905315,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257680',4905316,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257680',4905317,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257680',4905318,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257680',4905319,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257680',4905320,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257680',4905321,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257681',4905322,'3026','467',78447.37,78688.87,0.00,0.00,241.50,176295.00,0.00,0.00,0.00),('19','199','1023','257681',4905323,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257681',4905324,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257681',4905325,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257681',4905326,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257681',4905327,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257681',4905328,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257681',4905329,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257681',4905330,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257682',4905331,'3026','467',78688.87,79047.62,0.00,0.00,358.75,261887.50,0.00,0.00,0.00),('19','199','1023','257682',4905332,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257682',4905333,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257682',4905334,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257682',4905335,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257682',4905336,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257682',4905337,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257682',4905338,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257682',4905339,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257683',4905340,'3026','467',79047.62,79417.62,0.00,0.00,370.00,270100.00,0.00,0.00,0.00),('19','199','1023','257683',4905341,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257683',4905342,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257683',4905343,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257683',4905344,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257683',4905345,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257683',4905346,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257683',4905347,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257683',4905348,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257684',4905349,'3026','467',79417.62,79871.62,0.00,0.00,454.00,331420.00,0.00,0.00,0.00),('19','199','1023','257684',4905350,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257684',4905351,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257684',4905352,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257684',4905353,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257684',4905354,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257684',4905355,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257684',4905356,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257684',4905357,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257685',4905358,'3026','467',79871.62,80304.37,0.00,0.00,432.75,315907.50,0.00,0.00,0.00),('19','199','1023','257685',4905359,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257685',4905360,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257685',4905361,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257685',4905362,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257685',4905363,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257685',4905364,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257685',4905365,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257685',4905366,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257686',4905367,'3026','467',80304.37,80730.37,0.00,0.00,426.00,310980.00,0.00,0.00,0.00),('19','199','1023','257686',4905368,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257686',4905369,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257686',4905370,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257686',4905371,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257686',4905372,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257686',4905373,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257686',4905374,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257686',4905375,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257687',4905376,'3026','467',80730.37,81126.62,0.00,0.00,396.25,289262.50,0.00,0.00,0.00),('19','199','1023','257687',4905377,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257687',4905378,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257687',4905379,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257687',4905380,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257687',4905381,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257687',4905382,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257687',4905383,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257687',4905384,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257688',4905385,'3026','467',81126.62,81364.62,0.00,0.00,238.00,173740.00,0.00,0.00,0.00),('19','199','1023','257688',4905386,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257688',4905387,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257688',4905388,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257688',4905389,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257688',4905390,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257688',4905391,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257688',4905392,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257688',4905393,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257689',4905394,'3026','467',81364.62,81795.62,0.00,0.00,431.00,314630.00,0.00,0.00,0.00),('19','199','1023','257689',4905395,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257689',4905396,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257689',4905397,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257689',4905398,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257689',4905399,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257689',4905400,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257689',4905401,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257689',4905402,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257690',4905403,'3026','467',81795.62,82228.62,0.00,0.00,433.00,316090.00,0.00,0.00,0.00),('19','199','1023','257690',4905404,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257690',4905405,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257690',4905406,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257690',4905407,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257690',4905408,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257690',4905409,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257690',4905410,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257690',4905411,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257691',4905412,'3026','467',82228.62,82609.12,0.00,0.00,380.50,277765.00,0.00,0.00,0.00),('19','199','1023','257691',4905413,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257691',4905414,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257691',4905415,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257691',4905416,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257691',4905417,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257691',4905418,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257691',4905419,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257691',4905420,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257692',4905421,'3026','467',82609.12,82945.62,0.00,0.00,336.50,245645.00,0.00,0.00,0.00),('19','199','1023','257692',4905422,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257692',4905423,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257692',4905424,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257692',4905425,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257692',4905426,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257692',4905427,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257692',4905428,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257692',4905429,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257693',4905430,'3026','467',82945.62,83211.87,0.00,0.00,266.25,194362.50,0.00,0.00,0.00),('19','199','1023','257693',4905431,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257693',4905432,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257693',4905433,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257693',4905434,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257693',4905435,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257693',4905436,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257693',4905437,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257693',4905438,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257694',4905439,'3026','467',83211.87,83309.62,0.00,0.00,97.75,71357.50,0.00,0.00,0.00),('19','199','1023','257694',4905440,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257694',4905441,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257694',4905442,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257694',4905443,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257694',4905444,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257694',4905445,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257694',4905446,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257694',4905447,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257695',4905448,'3026','467',83309.62,83706.62,0.00,0.00,397.00,289810.00,0.00,0.00,0.00),('19','199','1023','257695',4905449,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257695',4905450,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257695',4905451,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257695',4905452,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257695',4905453,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257695',4905454,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257695',4905455,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257695',4905456,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257696',4905457,'3026','467',83706.62,84002.87,0.00,0.00,296.25,216262.50,0.00,0.00,0.00),('19','199','1023','257696',4905458,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257696',4905459,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257696',4905460,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257696',4905461,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257696',4905462,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257696',4905463,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257696',4905464,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257696',4905465,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257697',4905466,'3026','467',84002.87,84288.12,0.00,0.00,285.25,207482.50,0.00,0.00,0.00),('19','199','1023','257697',4905467,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257697',4905468,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257697',4905469,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257697',4905470,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257697',4905471,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257697',4905472,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257697',4905473,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257697',4905474,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257698',4905475,'3026','467',84288.12,84612.37,0.00,0.00,324.25,236702.50,0.00,0.00,0.00),('19','199','1023','257698',4905476,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257698',4905477,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257698',4905478,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257698',4905479,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257698',4905480,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257698',4905481,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257698',4905482,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257698',4905483,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257699',4905484,'3026','467',84612.37,84953.37,0.00,0.00,341.00,248930.00,0.00,0.00,0.00),('19','199','1023','257699',4905485,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257699',4905486,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257699',4905487,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257699',4905488,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257699',4905489,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257699',4905490,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257699',4905491,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257699',4905492,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257700',4905493,'3026','467',84953.37,85236.12,0.00,0.00,282.75,206407.50,0.00,0.00,0.00),('19','199','1023','257700',4905494,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257700',4905495,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257700',4905496,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257700',4905497,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257700',4905498,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257700',4905499,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257700',4905500,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257700',4905501,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257701',4905502,'3026','467',85236.12,85629.62,0.00,0.00,393.50,287255.00,0.00,0.00,0.00),('19','199','1023','257701',4905503,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257701',4905504,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257701',4905505,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257701',4905506,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257701',4905507,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257701',4905508,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257701',4905509,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257701',4905510,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257702',4905511,'3026','467',85629.62,86092.37,0.00,0.00,462.75,337807.50,0.00,0.00,0.00),('19','199','1023','257702',4905512,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257702',4905513,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257702',4905514,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257702',4905515,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257702',4905516,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257702',4905517,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257702',4905518,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257702',4905519,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257703',4905520,'3026','467',86092.37,86411.12,0.00,0.00,318.75,232687.50,0.00,0.00,0.00),('19','199','1023','257703',4905521,'3027','467',149.75,149.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257703',4905522,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257703',4905523,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257703',4905524,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257703',4905525,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257703',4905526,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257703',4905527,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257703',4905528,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257704',4905529,'3026','467',86411.12,86629.37,0.00,0.00,218.25,159322.50,0.00,0.00,0.00),('19','199','1023','257704',4905530,'3027','467',149.75,162.25,0.00,0.00,12.50,9125.00,0.00,0.00,0.00),('19','199','1023','257704',4905531,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257704',4905532,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257704',4905533,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257704',4905534,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257704',4905535,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257704',4905536,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257704',4905537,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257705',4905538,'3026','467',86629.37,87078.37,0.00,0.00,449.00,327770.00,0.00,0.00,0.00),('19','199','1023','257705',4905539,'3027','467',162.25,162.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257705',4905540,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257705',4905541,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257705',4905542,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257705',4905543,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257705',4905544,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257705',4905545,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257705',4905546,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257706',4905547,'3026','467',87078.37,87395.87,0.00,0.00,317.50,231775.00,0.00,0.00,0.00),('19','199','1023','257706',4905548,'3027','467',162.25,162.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257706',4905549,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257706',4905550,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257706',4905551,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257706',4905552,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257706',4905553,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257706',4905554,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257706',4905555,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257707',4905556,'3026','467',87395.87,87681.12,0.00,0.00,285.25,208232.50,0.00,0.00,0.00),('19','199','1023','257707',4905557,'3027','467',162.25,162.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257707',4905558,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257707',4905559,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257707',4905560,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257707',4905561,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257707',4905562,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257707',4905563,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257707',4905564,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257708',4905565,'3026','467',87681.12,87923.87,0.00,0.00,242.75,177207.50,0.00,0.00,0.00),('19','199','1023','257708',4905566,'3027','467',162.25,162.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257708',4905567,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257708',4905568,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257708',4905569,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257708',4905570,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257708',4905571,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257708',4905572,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257708',4905573,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257709',4905574,'3026','467',87923.87,88278.12,0.00,0.00,354.25,258602.50,0.00,0.00,0.00),('19','199','1023','257709',4905575,'3027','467',162.25,162.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257709',4905576,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257709',4905577,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257709',4905578,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257709',4905579,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257709',4905580,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257709',4905581,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257709',4905582,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257710',4905583,'3026','467',88278.12,88802.12,0.00,0.00,524.00,382520.00,0.00,0.00,0.00),('19','199','1023','257710',4905584,'3027','467',162.25,162.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257710',4905585,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257710',4905586,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257710',4905587,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257710',4905588,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257710',4905589,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257710',4905590,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257710',4905591,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257711',4905592,'3026','467',88802.12,89120.12,0.00,0.00,318.00,232140.00,0.00,0.00,0.00),('19','199','1023','257711',4905593,'3027','467',162.25,162.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257711',4905594,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257711',4905595,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257711',4905596,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257711',4905597,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257711',4905598,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257711',4905599,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257711',4905600,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257712',4905601,'3026','467',89120.12,89638.37,0.00,0.00,518.25,378322.50,0.00,0.00,0.00),('19','199','1023','257712',4905602,'3027','467',162.25,162.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257712',4905603,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257712',4905604,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257712',4905605,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257712',4905606,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257712',4905607,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257712',4905608,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257712',4905609,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257713',4905610,'3026','467',89638.37,90126.12,0.00,0.00,487.75,356057.50,0.00,0.00,0.00),('19','199','1023','257713',4905611,'3027','467',162.25,162.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257713',4905612,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257713',4905613,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257713',4905614,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257713',4905615,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257713',4905616,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257713',4905617,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257713',4905618,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257714',4905619,'3026','467',90126.12,90628.62,0.00,0.00,502.50,366825.00,0.00,0.00,0.00),('19','199','1023','257714',4905620,'3027','467',162.25,162.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257714',4905621,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257714',4905622,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257714',4905623,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257714',4905624,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257714',4905625,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257714',4905626,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257714',4905627,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257715',4905628,'3026','467',90628.62,90896.87,0.00,0.00,268.25,195822.50,0.00,0.00,0.00),('19','199','1023','257715',4905629,'3027','467',162.25,165.25,0.00,0.00,3.00,2190.00,0.00,0.00,0.00),('19','199','1023','257715',4905630,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257715',4905631,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257715',4905632,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257715',4905633,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257715',4905634,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257715',4905635,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257715',4905636,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257716',4905637,'3026','467',90896.87,91335.37,0.00,0.00,438.50,320105.00,0.00,0.00,0.00),('19','199','1023','257716',4905638,'3027','467',165.25,165.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257716',4905639,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257716',4905640,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257716',4905641,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257716',4905642,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257716',4905643,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257716',4905644,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257716',4905645,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257717',4905646,'3026','467',91335.37,91565.37,0.00,0.00,230.00,167900.00,0.00,0.00,0.00),('19','199','1023','257717',4905647,'3027','467',165.25,165.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257717',4905648,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257717',4905649,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257717',4905650,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257717',4905651,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257717',4905652,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257717',4905653,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257717',4905654,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257718',4905655,'3026','467',91565.37,91876.12,0.00,0.00,310.75,226847.50,0.00,0.00,0.00),('19','199','1023','257718',4905656,'3027','467',165.25,165.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257718',4905657,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257718',4905658,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257718',4905659,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257718',4905660,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257718',4905661,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257718',4905662,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257718',4905663,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257719',4905664,'3026','467',91876.12,92125.87,0.00,0.00,249.75,182317.50,0.00,0.00,0.00),('19','199','1023','257719',4905665,'3027','467',165.25,165.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257719',4905666,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257719',4905667,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257719',4905668,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257719',4905669,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257719',4905670,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257719',4905671,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257719',4905672,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257720',4905673,'3026','467',92125.87,92442.62,0.00,0.00,316.75,231227.50,0.00,0.00,0.00),('19','199','1023','257720',4905674,'3027','467',165.25,165.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257720',4905675,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257720',4905676,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257720',4905677,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257720',4905678,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257720',4905679,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257720',4905680,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257720',4905681,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257721',4905682,'3026','467',92442.62,92679.37,0.00,0.00,236.75,172827.50,0.00,0.00,0.00),('19','199','1023','257721',4905683,'3027','467',165.25,165.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257721',4905684,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257721',4905685,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257721',4905686,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257721',4905687,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257721',4905688,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257721',4905689,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257721',4905690,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257722',4905691,'3026','467',92679.37,92919.37,0.00,0.00,240.00,175200.00,0.00,0.00,0.00),('19','199','1023','257722',4905692,'3027','467',165.25,165.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257722',4905693,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257722',4905694,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257722',4905695,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257722',4905696,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257722',4905697,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257722',4905698,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257722',4905699,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257723',4905700,'3026','467',92919.37,93169.37,0.00,0.00,250.00,182500.00,0.00,0.00,0.00),('19','199','1023','257723',4905701,'3027','467',165.25,165.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257723',4905702,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257723',4905703,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257723',4905704,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257723',4905705,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257723',4905706,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257723',4905707,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257723',4905708,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257724',4905709,'3026','467',93169.37,93499.62,0.00,0.00,330.25,241082.50,0.00,0.00,0.00),('19','199','1023','257724',4905710,'3027','467',165.25,165.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257724',4905711,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257724',4905712,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257724',4905713,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257724',4905714,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257724',4905715,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257724',4905716,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257724',4905717,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257725',4905718,'3026','467',93499.62,93819.12,0.00,0.00,319.50,233235.00,0.00,0.00,0.00),('19','199','1023','257725',4905719,'3027','467',165.25,165.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257725',4905720,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257725',4905721,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257725',4905722,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257725',4905723,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257725',4905724,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257725',4905725,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257725',4905726,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257726',4905727,'3026','467',93819.12,94184.12,0.00,0.00,365.00,266450.00,0.00,0.00,0.00),('19','199','1023','257726',4905728,'3027','467',165.25,165.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257726',4905729,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257726',4905730,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257726',4905731,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257726',4905732,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257726',4905733,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257726',4905734,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257726',4905735,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257727',4905736,'3026','467',94184.12,94525.62,0.00,0.00,341.50,249295.00,0.00,0.00,0.00),('19','199','1023','257727',4905737,'3027','467',165.25,165.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257727',4905738,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257727',4905739,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257727',4905740,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257727',4905741,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257727',4905742,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257727',4905743,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257727',4905744,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257728',4905745,'3026','467',94525.62,94746.37,0.00,0.00,220.75,161147.50,0.00,0.00,0.00),('19','199','1023','257728',4905746,'3027','467',165.25,165.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257728',4905747,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257728',4905748,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257728',4905749,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257728',4905750,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257728',4905751,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257728',4905752,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257728',4905753,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257729',4905754,'3026','467',94746.37,95045.12,0.00,0.00,298.75,218087.50,0.00,0.00,0.00),('19','199','1023','257729',4905755,'3027','467',165.25,171.50,0.00,0.00,6.25,4562.50,0.00,0.00,0.00),('19','199','1023','257729',4905756,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257729',4905757,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257729',4905758,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257729',4905759,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257729',4905760,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257729',4905761,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257729',4905762,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257730',4905763,'3026','467',95045.12,95505.62,0.00,0.00,460.50,335415.00,0.00,0.00,0.00),('19','199','1023','257730',4905764,'3027','467',171.50,171.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257730',4905765,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257730',4905766,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257730',4905767,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257730',4905768,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257730',4905769,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257730',4905770,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257730',4905771,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257731',4905772,'3026','467',95505.62,95776.37,0.00,0.00,270.75,197647.50,0.00,0.00,0.00),('19','199','1023','257731',4905773,'3027','467',171.50,171.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257731',4905774,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257731',4905775,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257731',4905776,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257731',4905777,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257731',4905778,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257731',4905779,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257731',4905780,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257732',4905781,'3026','467',95776.37,96084.87,0.00,0.00,308.50,225205.00,0.00,0.00,0.00),('19','199','1023','257732',4905782,'3027','467',171.50,171.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257732',4905783,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257732',4905784,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257732',4905785,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257732',4905786,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257732',4905787,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257732',4905788,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257732',4905789,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257733',4905790,'3026','467',96084.87,96371.87,0.00,0.00,287.00,209510.00,0.00,0.00,0.00),('19','199','1023','257733',4905791,'3027','467',171.50,171.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257733',4905792,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257733',4905793,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257733',4905794,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257733',4905795,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257733',4905796,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257733',4905797,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257733',4905798,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257734',4905799,'3026','467',96371.87,96901.62,0.00,0.00,529.75,386717.50,0.00,0.00,0.00),('19','199','1023','257734',4905800,'3027','467',171.50,184.00,0.00,0.00,12.50,9125.00,0.00,0.00,0.00),('19','199','1023','257734',4905801,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257734',4905802,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257734',4905803,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257734',4905804,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257734',4905805,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257734',4905806,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257734',4905807,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257735',4905808,'3026','467',96901.62,97373.37,0.00,0.00,471.75,344377.50,0.00,0.00,0.00),('19','199','1023','257735',4905809,'3027','467',184.00,184.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257735',4905810,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257735',4905811,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257735',4905812,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257735',4905813,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257735',4905814,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257735',4905815,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257735',4905816,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257736',4905817,'3026','467',97373.37,97844.87,0.00,0.00,471.50,344195.00,0.00,0.00,0.00),('19','199','1023','257736',4905818,'3027','467',184.00,184.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257736',4905819,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257736',4905820,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257736',4905821,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257736',4905822,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257736',4905823,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257736',4905824,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257736',4905825,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257737',4905826,'3026','467',97844.87,98698.37,0.00,0.00,853.50,620055.00,0.00,0.00,0.00),('19','199','1023','257737',4905827,'3027','467',184.00,184.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257737',4905828,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257737',4905829,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257737',4905830,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257737',4905831,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257737',4905832,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257737',4905833,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257737',4905834,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257738',4905835,'3026','467',98698.37,99138.37,0.00,0.00,440.00,321200.00,0.00,0.00,0.00),('19','199','1023','257738',4905836,'3027','467',184.00,184.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257738',4905837,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257738',4905838,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257738',4905839,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257738',4905840,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257738',4905841,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257738',4905842,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257738',4905843,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257739',4905844,'3026','467',99138.37,99489.62,0.00,0.00,351.25,256412.50,0.00,0.00,0.00),('19','199','1023','257739',4905845,'3027','467',184.00,184.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257739',4905846,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257739',4905847,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257739',4905848,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257739',4905849,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257739',4905850,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257739',4905851,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257739',4905852,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257740',4905853,'3026','467',99489.62,99892.37,0.00,0.00,402.75,292732.50,0.00,0.00,0.00),('19','199','1023','257740',4905854,'3027','467',184.00,184.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257740',4905855,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257740',4905856,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257740',4905857,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257740',4905858,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257740',4905859,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257740',4905860,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257740',4905861,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257741',4905862,'3026','467',99892.37,100251.37,0.00,0.00,359.00,262070.00,0.00,0.00,0.00),('19','199','1023','257741',4905863,'3027','467',184.00,184.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257741',4905864,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257741',4905865,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257741',4905866,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257741',4905867,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257741',4905868,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257741',4905869,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257741',4905870,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257742',4905871,'3026','467',100251.37,100769.37,0.00,0.00,518.00,378140.00,0.00,0.00,0.00),('19','199','1023','257742',4905872,'3027','467',184.00,184.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257742',4905873,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257742',4905874,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257742',4905875,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257742',4905876,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257742',4905877,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257742',4905878,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257742',4905879,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257743',4905880,'3026','467',100769.37,101208.87,0.00,0.00,439.50,320085.00,0.00,0.00,0.00),('19','199','1023','257743',4905881,'3027','467',184.00,184.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257743',4905882,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257743',4905883,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257743',4905884,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257743',4905885,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257743',4905886,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257743',4905887,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257743',4905888,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257744',4905889,'3026','467',101208.87,101810.87,0.00,0.00,602.00,439460.00,0.00,0.00,0.00),('19','199','1023','257744',4905890,'3027','467',184.00,190.25,0.00,0.00,6.25,4562.50,0.00,0.00,0.00),('19','199','1023','257744',4905891,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257744',4905892,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257744',4905893,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257744',4905894,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257744',4905895,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257744',4905896,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257744',4905897,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257745',4905898,'3026','467',101810.87,102378.37,0.00,0.00,567.50,412025.00,0.00,0.00,0.00),('19','199','1023','257745',4905899,'3027','467',190.25,190.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257745',4905900,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257745',4905901,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257745',4905902,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257745',4905903,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257745',4905904,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257745',4905905,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257745',4905906,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257746',4905907,'3026','467',102378.37,102709.87,0.00,0.00,331.50,241995.00,0.00,0.00,0.00),('19','199','1023','257746',4905908,'3027','467',190.25,190.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257746',4905909,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257746',4905910,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257746',4905911,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257746',4905912,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257746',4905913,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257746',4905914,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257746',4905915,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257747',4905916,'3026','467',102709.87,103063.62,0.00,0.00,353.75,258237.50,0.00,0.00,0.00),('19','199','1023','257747',4905917,'3027','467',190.25,190.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257747',4905918,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257747',4905919,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257747',4905920,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257747',4905921,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257747',4905922,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257747',4905923,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257747',4905924,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257748',4905925,'3026','467',103063.62,103300.87,0.00,0.00,237.25,173192.50,0.00,0.00,0.00),('19','199','1023','257748',4905926,'3027','467',190.25,190.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257748',4905927,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257748',4905928,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257748',4905929,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257748',4905930,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257748',4905931,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257748',4905932,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257748',4905933,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257749',4905934,'3026','467',103300.87,103567.62,0.00,0.00,266.75,194727.50,0.00,0.00,0.00),('19','199','1023','257749',4905935,'3027','467',190.25,190.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257749',4905936,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257749',4905937,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257749',4905938,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257749',4905939,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257749',4905940,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257749',4905941,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257749',4905942,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257750',4905943,'3026','467',103567.62,103832.87,0.00,0.00,265.25,193632.50,0.00,0.00,0.00),('19','199','1023','257750',4905944,'3027','467',190.25,190.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257750',4905945,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257750',4905946,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257750',4905947,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257750',4905948,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257750',4905949,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257750',4905950,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257750',4905951,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257751',4905952,'3026','467',103832.87,104294.62,0.00,0.00,461.75,337077.50,0.00,0.00,0.00),('19','199','1023','257751',4905953,'3027','467',190.25,190.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257751',4905954,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257751',4905955,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257751',4905956,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257751',4905957,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257751',4905958,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257751',4905959,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257751',4905960,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257752',4905961,'3026','467',104294.62,104294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257752',4905962,'3027','467',190.25,190.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257752',4905963,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257752',4905964,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257752',4905965,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257752',4905966,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257752',4905967,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257752',4905968,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257752',4905969,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257753',4905970,'3026','467',104294.62,104294.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257753',4905971,'3027','467',190.25,190.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257753',4905972,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257753',4905973,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257753',4905974,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257753',4905975,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257753',4905976,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257753',4905977,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257753',4905978,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257754',4905979,'3026','467',104294.62,104809.12,0.00,0.00,514.50,375585.00,0.00,0.00,0.00),('19','199','1023','257754',4905980,'3027','467',190.25,196.50,0.00,0.00,6.25,4562.50,0.00,0.00,0.00),('19','199','1023','257754',4905981,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257754',4905982,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257754',4905983,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257754',4905984,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257754',4905985,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257754',4905986,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257754',4905987,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257755',4905988,'3026','467',104809.12,105169.87,0.00,0.00,360.75,263347.50,0.00,0.00,0.00),('19','199','1023','257755',4905989,'3027','467',196.50,196.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257755',4905990,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257755',4905991,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257755',4905992,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257755',4905993,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257755',4905994,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257755',4905995,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257755',4905996,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257756',4905997,'3026','467',105169.87,105389.62,0.00,0.00,219.75,160417.50,0.00,0.00,0.00),('19','199','1023','257756',4905998,'3027','467',196.50,196.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257756',4905999,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257756',4906000,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257756',4906001,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257756',4906002,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257756',4906003,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257756',4906004,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257756',4906005,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257757',4906006,'3026','467',105389.62,105794.62,0.00,0.00,405.00,294900.00,0.00,0.00,0.00),('19','199','1023','257757',4906007,'3027','467',196.50,196.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257757',4906008,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257757',4906009,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257757',4906010,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257757',4906011,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257757',4906012,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257757',4906013,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257757',4906014,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257758',4906015,'3026','467',105794.62,106850.37,0.00,0.00,1055.75,769760.00,0.00,0.00,0.00),('19','199','1023','257758',4906016,'3027','467',196.50,209.00,0.00,0.00,12.50,9125.00,0.00,0.00,0.00),('19','199','1023','257758',4906017,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257758',4906018,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257758',4906019,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257758',4906020,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257758',4906021,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257758',4906022,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257758',4906023,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257759',4906024,'3026','467',106850.37,107550.87,0.00,0.00,700.50,509865.00,0.00,0.00,0.00),('19','199','1023','257759',4906025,'3027','467',209.00,209.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257759',4906026,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257759',4906027,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257759',4906028,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257759',4906029,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257759',4906030,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257759',4906031,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257759',4906032,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257760',4906033,'3026','467',107550.87,107941.12,0.00,0.00,390.25,284882.50,0.00,0.00,0.00),('19','199','1023','257760',4906034,'3027','467',209.00,209.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257760',4906035,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257760',4906036,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257760',4906037,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257760',4906038,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257760',4906039,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257760',4906040,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257760',4906041,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257761',4906042,'3026','467',107941.12,108479.37,0.00,0.00,538.25,392172.50,0.00,0.00,0.00),('19','199','1023','257761',4906043,'3027','467',209.00,209.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257761',4906044,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257761',4906045,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257761',4906046,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257761',4906047,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257761',4906048,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257761',4906049,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257761',4906050,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257762',4906051,'3026','467',108479.37,109172.12,0.00,0.00,692.75,504582.50,0.00,0.00,0.00),('19','199','1023','257762',4906052,'3027','467',209.00,214.00,0.00,0.00,5.00,3650.00,0.00,0.00,0.00),('19','199','1023','257762',4906053,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257762',4906054,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257762',4906055,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257762',4906056,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257762',4906057,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257762',4906058,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257762',4906059,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257763',4906060,'3026','467',109172.12,109465.37,0.00,0.00,293.25,214072.50,0.00,0.00,0.00),('19','199','1023','257763',4906061,'3027','467',214.00,214.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257763',4906062,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257763',4906063,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257763',4906064,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257763',4906065,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257763',4906066,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257763',4906067,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257763',4906068,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257764',4906069,'3026','467',109465.37,110209.37,0.00,0.00,744.00,542370.00,0.00,0.00,0.00),('19','199','1023','257764',4906070,'3027','467',214.00,214.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257764',4906071,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257764',4906072,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257764',4906073,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257764',4906074,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257764',4906075,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257764',4906076,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257764',4906077,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257765',4906078,'3026','467',110209.37,110840.37,0.00,0.00,631.00,458380.00,0.00,0.00,0.00),('19','199','1023','257765',4906079,'3027','467',214.00,214.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257765',4906080,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257765',4906081,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257765',4906082,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257765',4906083,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257765',4906084,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257765',4906085,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257765',4906086,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257766',4906087,'3026','467',110840.37,111344.12,0.00,0.00,503.75,367737.50,0.00,0.00,0.00),('19','199','1023','257766',4906088,'3027','467',214.00,214.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257766',4906089,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257766',4906090,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257766',4906091,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257766',4906092,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257766',4906093,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257766',4906094,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257766',4906095,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257767',4906096,'3026','467',111344.12,111642.87,0.00,0.00,298.75,218087.50,0.00,0.00,0.00),('19','199','1023','257767',4906097,'3027','467',214.00,214.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257767',4906098,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257767',4906099,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257767',4906100,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257767',4906101,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257767',4906102,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257767',4906103,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257767',4906104,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257768',4906105,'3026','467',111642.87,111925.12,0.00,0.00,282.25,206042.50,0.00,0.00,0.00),('19','199','1023','257768',4906106,'3027','467',214.00,226.50,0.00,0.00,12.50,9125.00,0.00,0.00,0.00),('19','199','1023','257768',4906107,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257768',4906108,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257768',4906109,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257768',4906110,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257768',4906111,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257768',4906112,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257768',4906113,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257769',4906114,'3026','467',111925.12,112596.87,0.00,0.00,671.75,489627.50,0.00,0.00,0.00),('19','199','1023','257769',4906115,'3027','467',226.50,226.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257769',4906116,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257769',4906117,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257769',4906118,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257769',4906119,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257769',4906120,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257769',4906121,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257769',4906122,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257770',4906123,'3026','467',112596.87,112878.37,0.00,0.00,281.50,205495.00,0.00,0.00,0.00),('19','199','1023','257770',4906124,'3027','467',226.50,226.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257770',4906125,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257770',4906126,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257770',4906127,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257770',4906128,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257770',4906129,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257770',4906130,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257770',4906131,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257771',4906132,'3026','467',112878.37,113469.12,0.00,0.00,590.75,430497.50,0.00,0.00,0.00),('19','199','1023','257771',4906133,'3027','467',226.50,226.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257771',4906134,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257771',4906135,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257771',4906136,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257771',4906137,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257771',4906138,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257771',4906139,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257771',4906140,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257772',4906141,'3026','467',113469.12,114108.87,0.00,0.00,639.75,467017.50,0.00,0.00,0.00),('19','199','1023','257772',4906142,'3027','467',226.50,226.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257772',4906143,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257772',4906144,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257772',4906145,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257772',4906146,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257772',4906147,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257772',4906148,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257772',4906149,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257773',4906150,'3026','467',114108.87,114718.37,0.00,0.00,609.50,444560.00,0.00,0.00,0.00),('19','199','1023','257773',4906151,'3027','467',226.50,239.00,0.00,0.00,12.50,9125.00,0.00,0.00,0.00),('19','199','1023','257773',4906152,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257773',4906153,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257773',4906154,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257773',4906155,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257773',4906156,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257773',4906157,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257773',4906158,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257774',4906159,'3026','467',114718.37,115503.62,0.00,0.00,785.25,571920.00,0.00,0.00,0.00),('19','199','1023','257774',4906160,'3027','467',239.00,239.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257774',4906161,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257774',4906162,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257774',4906163,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257774',4906164,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257774',4906165,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257774',4906166,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257774',4906167,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257775',4906168,'3026','467',115503.62,116556.37,0.00,0.00,1052.75,768132.50,0.00,0.00,0.00),('19','199','1023','257775',4906169,'3027','467',239.00,239.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257775',4906170,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257775',4906171,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257775',4906172,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257775',4906173,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257775',4906174,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257775',4906175,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257775',4906176,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257776',4906177,'3026','467',116556.37,117413.37,0.00,0.00,857.00,624860.00,0.00,0.00,0.00),('19','199','1023','257776',4906178,'3027','467',239.00,239.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257776',4906179,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257776',4906180,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257776',4906181,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257776',4906182,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257776',4906183,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257776',4906184,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257776',4906185,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257777',4906186,'3026','467',117413.37,117999.37,0.00,0.00,586.00,426280.00,0.00,0.00,0.00),('19','199','1023','257777',4906187,'3027','467',239.00,239.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257777',4906188,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257777',4906189,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257777',4906190,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257777',4906191,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257777',4906192,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257777',4906193,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257777',4906194,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257778',4906195,'3026','467',117999.37,118438.37,0.00,0.00,439.00,320470.00,0.00,0.00,0.00),('19','199','1023','257778',4906196,'3027','467',239.00,239.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257778',4906197,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257778',4906198,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257778',4906199,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257778',4906200,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257778',4906201,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257778',4906202,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257778',4906203,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257779',4906204,'3026','467',118438.37,118854.87,0.00,0.00,416.50,304045.00,0.00,0.00,0.00),('19','199','1023','257779',4906205,'3027','467',239.00,239.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257779',4906206,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257779',4906207,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257779',4906208,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257779',4906209,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257779',4906210,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257779',4906211,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257779',4906212,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257780',4906213,'3026','467',118854.87,119301.87,0.00,0.00,447.00,325560.00,0.00,0.00,0.00),('19','199','1023','257780',4906214,'3027','467',239.00,239.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257780',4906215,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257780',4906216,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257780',4906217,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257780',4906218,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257780',4906219,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257780',4906220,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257780',4906221,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257781',4906222,'3026','467',119301.87,119737.87,0.00,0.00,436.00,318280.00,0.00,0.00,0.00),('19','199','1023','257781',4906223,'3027','467',239.00,239.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257781',4906224,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257781',4906225,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257781',4906226,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257781',4906227,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257781',4906228,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257781',4906229,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257781',4906230,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257782',4906231,'3026','467',119737.87,120398.37,0.00,0.00,660.50,482165.00,0.00,0.00,0.00),('19','199','1023','257782',4906232,'3027','467',239.00,239.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257782',4906233,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257782',4906234,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257782',4906235,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257782',4906236,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257782',4906237,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257782',4906238,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257782',4906239,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257783',4906240,'3026','467',120398.37,120746.37,0.00,0.00,348.00,252540.00,0.00,0.00,0.00),('19','199','1023','257783',4906241,'3027','467',239.00,239.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257783',4906242,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257783',4906243,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257783',4906244,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257783',4906245,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257783',4906246,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257783',4906247,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257783',4906248,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257784',4906249,'3026','467',120746.37,121026.37,0.00,0.00,280.00,204400.00,0.00,0.00,0.00),('19','199','1023','257784',4906250,'3027','467',239.00,239.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257784',4906251,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257784',4906252,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257784',4906253,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257784',4906254,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257784',4906255,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257784',4906256,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257784',4906257,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257785',4906258,'3026','467',121026.37,121474.12,0.00,0.00,447.75,325545.00,0.00,0.00,0.00),('19','199','1023','257785',4906259,'3027','467',239.00,239.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257785',4906260,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257785',4906261,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257785',4906262,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257785',4906263,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257785',4906264,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257785',4906265,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257785',4906266,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257786',4906267,'3026','467',121474.12,121812.12,0.00,0.00,338.00,246740.00,0.00,0.00,0.00),('19','199','1023','257786',4906268,'3027','467',239.00,239.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257786',4906269,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257786',4906270,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257786',4906271,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257786',4906272,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257786',4906273,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257786',4906274,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257786',4906275,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257787',4906276,'3026','467',121812.12,122227.62,0.00,0.00,415.50,303315.00,0.00,0.00,0.00),('19','199','1023','257787',4906277,'3027','467',239.00,239.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257787',4906278,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257787',4906279,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257787',4906280,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257787',4906281,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257787',4906282,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257787',4906283,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257787',4906284,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257788',4906285,'3026','467',122227.62,122759.12,0.00,0.00,531.50,386495.00,0.00,0.00,0.00),('19','199','1023','257788',4906286,'3027','467',239.00,239.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257788',4906287,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257788',4906288,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257788',4906289,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257788',4906290,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257788',4906291,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257788',4906292,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257788',4906293,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257789',4906294,'3026','467',122759.12,123163.62,0.00,0.00,404.50,295285.00,0.00,0.00,0.00),('19','199','1023','257789',4906295,'3027','467',239.00,239.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257789',4906296,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257789',4906297,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257789',4906298,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257789',4906299,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257789',4906300,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257789',4906301,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257789',4906302,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257790',4906303,'3026','467',123163.62,123163.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257790',4906304,'3027','467',239.00,239.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257790',4906305,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257790',4906306,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257790',4906307,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257790',4906308,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257790',4906309,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257790',4906310,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257790',4906311,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257791',4906312,'3026','467',123163.62,123965.87,0.00,0.00,802.25,579717.50,0.00,0.00,0.00),('19','199','1023','257791',4906313,'3027','467',239.00,239.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257791',4906314,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257791',4906315,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257791',4906316,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257791',4906317,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257791',4906318,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257791',4906319,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257791',4906320,'3034','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257792',4906321,'3026','467',123965.87,124649.12,0.00,0.00,683.25,495022.50,0.00,0.00,0.00),('19','199','1023','257792',4906322,'3027','467',239.00,239.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257792',4906323,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257792',4906324,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257792',4906325,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257792',4906326,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257792',4906327,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257792',4906328,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257792',4906329,'3034','467',0.00,6.25,0.00,0.00,6.25,4562.50,0.00,0.00,0.00),('19','199','1023','257793',4906330,'3026','467',124649.12,125363.87,0.00,0.00,714.75,516517.50,0.00,0.00,0.00),('19','199','1023','257793',4906331,'3027','467',239.00,239.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257793',4906332,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257793',4906333,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257793',4906334,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257793',4906335,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257793',4906336,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257793',4906337,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257793',4906338,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257794',4906339,'3026','467',125363.87,125877.12,0.00,0.00,513.25,374672.50,0.00,0.00,0.00),('19','199','1023','257794',4906340,'3027','467',239.00,239.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257794',4906341,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257794',4906342,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257794',4906343,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257794',4906344,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257794',4906345,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257794',4906346,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257794',4906347,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257795',4906348,'3026','467',125877.12,126685.12,0.00,0.00,808.00,586840.00,0.00,0.00,0.00),('19','199','1023','257795',4906349,'3027','467',239.00,242.00,0.00,0.00,3.00,2190.00,0.00,0.00,0.00),('19','199','1023','257795',4906350,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257795',4906351,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257795',4906352,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257795',4906353,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257795',4906354,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257795',4906355,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257795',4906356,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257796',4906357,'3026','467',126685.12,128730.62,0.00,0.00,2045.50,1469965.00,0.00,0.00,0.00),('19','199','1023','257796',4906358,'3027','467',242.00,242.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257796',4906359,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257796',4906360,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257796',4906361,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257796',4906362,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257796',4906363,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257796',4906364,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257796',4906365,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257797',4906366,'3026','467',128730.62,136563.37,0.00,0.00,7832.75,5596532.50,0.00,0.00,0.00),('19','199','1023','257797',4906367,'3027','467',242.00,242.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257797',4906368,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257797',4906369,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257797',4906370,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257797',4906371,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257797',4906372,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257797',4906373,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257797',4906374,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257798',4906375,'3026','467',136563.37,136563.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257798',4906376,'3027','467',242.00,242.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257798',4906377,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257798',4906378,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257798',4906379,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257798',4906380,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257798',4906381,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257798',4906382,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257798',4906383,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257799',4906384,'3026','467',136563.37,138054.87,0.00,0.00,1491.50,1118625.00,0.00,0.00,0.00),('19','199','1023','257799',4906385,'3027','467',242.00,242.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257799',4906386,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257799',4906387,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257799',4906388,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257799',4906389,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257799',4906390,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257799',4906391,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257799',4906392,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257800',4906393,'3026','467',138054.87,139959.37,0.00,0.00,1904.50,1428375.00,0.00,0.00,0.00),('19','199','1023','257800',4906394,'3027','467',242.00,242.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257800',4906395,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257800',4906396,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257800',4906397,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257800',4906398,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257800',4906399,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257800',4906400,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257800',4906401,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257801',4906402,'3026','467',139959.37,143362.87,0.00,0.00,3403.50,2552625.00,0.00,0.00,0.00),('19','199','1023','257801',4906403,'3027','467',242.00,262.00,0.00,0.00,20.00,15000.00,0.00,0.00,0.00),('19','199','1023','257801',4906404,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257801',4906405,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257801',4906406,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257801',4906407,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257801',4906408,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257801',4906409,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257801',4906410,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257802',4906411,'3026','467',143362.87,145375.37,0.00,0.00,2012.50,1568250.00,0.00,0.00,0.00),('19','199','1023','257802',4906412,'3027','467',262.00,262.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257802',4906413,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257802',4906414,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257802',4906415,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257802',4906416,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257802',4906417,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257802',4906418,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257802',4906419,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257803',4906420,'3026','467',145375.37,146510.12,0.00,0.00,1134.75,885105.00,0.00,0.00,0.00),('19','199','1023','257803',4906421,'3027','467',262.00,262.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257803',4906422,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257803',4906423,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257803',4906424,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257803',4906425,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257803',4906426,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257803',4906427,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257803',4906428,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257804',4906429,'3026','467',146510.12,146880.87,0.00,0.00,370.75,289185.00,0.00,0.00,0.00),('19','199','1023','257804',4906430,'3027','467',262.00,262.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257804',4906431,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257804',4906432,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257804',4906433,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257804',4906434,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257804',4906435,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257804',4906436,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257804',4906437,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257805',4906438,'3026','467',146880.87,146940.12,0.00,0.00,59.25,46215.00,0.00,0.00,0.00),('19','199','1023','257805',4906439,'3027','467',262.00,262.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257805',4906440,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257805',4906441,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257805',4906442,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257805',4906443,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257805',4906444,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257805',4906445,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257805',4906446,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257806',4906447,'3026','467',146940.12,147068.12,0.00,0.00,128.00,99840.00,0.00,0.00,0.00),('19','199','1023','257806',4906448,'3027','467',262.00,262.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257806',4906449,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257806',4906450,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257806',4906451,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257806',4906452,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257806',4906453,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257806',4906454,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257806',4906455,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257807',4906456,'3026','467',147068.12,147118.12,0.00,0.00,50.00,39000.00,0.00,0.00,0.00),('19','199','1023','257807',4906457,'3027','467',262.00,262.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257807',4906458,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257807',4906459,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257807',4906460,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257807',4906461,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257807',4906462,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257807',4906463,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257807',4906464,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257808',4906465,'3026','467',147118.12,147118.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257808',4906466,'3027','467',262.00,262.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257808',4906467,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257808',4906468,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257808',4906469,'3030','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257808',4906470,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257808',4906471,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257808',4906472,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257808',4906473,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257809',4906474,'3026','467',147118.12,148211.37,0.00,0.00,1093.25,841518.75,0.00,0.00,0.00),('19','199','1023','257809',4906475,'3027','467',262.00,274.50,0.00,0.00,12.50,9687.50,0.00,0.00,0.00),('19','199','1023','257809',4906476,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257809',4906477,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257809',4906478,'3030','467',0.00,12.50,0.00,0.00,12.50,9687.50,0.00,0.00,0.00),('19','199','1023','257809',4906479,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257809',4906480,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257809',4906481,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257809',4906482,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257810',4906483,'3026','467',148211.37,149650.37,0.00,0.00,1439.00,1108600.00,0.00,0.00,0.00),('19','199','1023','257810',4906484,'3027','467',274.50,274.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257810',4906485,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257810',4906486,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257810',4906487,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257810',4906488,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257810',4906489,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257810',4906490,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257810',4906491,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257811',4906492,'3026','467',149650.37,151990.37,0.00,0.00,2340.00,1794970.00,0.00,0.00,0.00),('19','199','1023','257811',4906493,'3027','467',274.50,274.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257811',4906494,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257811',4906495,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257811',4906496,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257811',4906497,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257811',4906498,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257811',4906499,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257811',4906500,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257812',4906501,'3026','467',151990.37,154179.37,0.00,0.00,2189.00,1680225.00,0.00,0.00,0.00),('19','199','1023','257812',4906502,'3027','467',274.50,274.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257812',4906503,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257812',4906504,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257812',4906505,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257812',4906506,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257812',4906507,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257812',4906508,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257812',4906509,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257813',4906510,'3026','467',154179.37,156215.12,0.00,0.00,2035.75,1564206.25,0.00,0.00,0.00),('19','199','1023','257813',4906511,'3027','467',274.50,274.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257813',4906512,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257813',4906513,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257813',4906514,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257813',4906515,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257813',4906516,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257813',4906517,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257813',4906518,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257814',4906519,'3026','467',156215.12,158394.62,0.00,0.00,2179.50,1671412.50,0.00,0.00,0.00),('19','199','1023','257814',4906520,'3027','467',274.50,274.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257814',4906521,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257814',4906522,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257814',4906523,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257814',4906524,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257814',4906525,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257814',4906526,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257814',4906527,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257815',4906528,'3026','467',158394.62,160269.62,0.00,0.00,1875.00,1438625.00,0.00,0.00,0.00),('19','199','1023','257815',4906529,'3027','467',274.50,274.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257815',4906530,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257815',4906531,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257815',4906532,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257815',4906533,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257815',4906534,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257815',4906535,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257815',4906536,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257816',4906537,'3026','467',160269.62,162575.87,0.00,0.00,2306.25,1770063.75,0.00,0.00,0.00),('19','199','1023','257816',4906538,'3027','467',274.50,274.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257816',4906539,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257816',4906540,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257816',4906541,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257816',4906542,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257816',4906543,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257816',4906544,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257816',4906545,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257817',4906546,'3026','467',162575.87,164116.12,0.00,0.00,1540.25,1183383.75,0.00,0.00,0.00),('19','199','1023','257817',4906547,'3027','467',274.50,279.50,0.00,0.00,5.00,3875.00,0.00,0.00,0.00),('19','199','1023','257817',4906548,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257817',4906549,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257817',4906550,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257817',4906551,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257817',4906552,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257817',4906553,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257817',4906554,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257818',4906555,'3026','467',164116.12,165247.37,0.00,0.00,1131.25,868718.75,0.00,0.00,0.00),('19','199','1023','257818',4906556,'3027','467',279.50,385.75,0.00,0.00,106.25,81343.75,0.00,0.00,0.00),('19','199','1023','257818',4906557,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257818',4906558,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257818',4906559,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257818',4906560,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257818',4906561,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257818',4906562,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257818',4906563,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257819',4906564,'3026','467',165247.37,166524.62,0.00,0.00,1277.25,981868.75,0.00,0.00,0.00),('19','199','1023','257819',4906565,'3027','467',385.75,385.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257819',4906566,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257819',4906567,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257819',4906568,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257819',4906569,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257819',4906570,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257819',4906571,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257819',4906572,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257820',4906573,'3026','467',166524.62,167403.62,0.00,0.00,879.00,675725.00,0.00,0.00,0.00),('19','199','1023','257820',4906574,'3027','467',385.75,388.75,0.00,0.00,3.00,2325.00,0.00,0.00,0.00),('19','199','1023','257820',4906575,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257820',4906576,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257820',4906577,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257820',4906578,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257820',4906579,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257820',4906580,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257820',4906581,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257821',4906582,'3026','467',167403.62,168542.87,0.00,0.00,1139.25,874543.75,0.00,0.00,0.00),('19','199','1023','257821',4906583,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257821',4906584,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257821',4906585,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257821',4906586,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257821',4906587,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257821',4906588,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257821',4906589,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257821',4906590,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257822',4906591,'3026','467',168542.87,169697.62,0.00,0.00,1154.75,890856.25,0.00,0.00,0.00),('19','199','1023','257822',4906592,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257822',4906593,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257822',4906594,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257822',4906595,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257822',4906596,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257822',4906597,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257822',4906598,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257822',4906599,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257823',4906600,'3026','467',169697.62,170798.12,0.00,0.00,1100.50,846887.50,0.00,0.00,0.00),('19','199','1023','257823',4906601,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257823',4906602,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257823',4906603,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257823',4906604,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257823',4906605,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257823',4906606,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257823',4906607,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257823',4906608,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257824',4906609,'3026','467',170798.12,171484.37,0.00,0.00,686.25,528218.75,0.00,0.00,0.00),('19','199','1023','257824',4906610,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257824',4906611,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257824',4906612,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257824',4906613,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257824',4906614,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257824',4906615,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257824',4906616,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257824',4906617,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257825',4906618,'3026','467',171484.37,172272.87,0.00,0.00,788.50,607587.50,0.00,0.00,0.00),('19','199','1023','257825',4906619,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257825',4906620,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257825',4906621,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257825',4906622,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257825',4906623,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257825',4906624,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257825',4906625,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257825',4906626,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257826',4906627,'3026','467',172272.87,172938.37,0.00,0.00,665.50,513262.50,0.00,0.00,0.00),('19','199','1023','257826',4906628,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257826',4906629,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257826',4906630,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257826',4906631,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257826',4906632,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257826',4906633,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257826',4906634,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257826',4906635,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257827',4906636,'3026','467',172938.37,173604.37,0.00,0.00,666.00,512650.00,0.00,0.00,0.00),('19','199','1023','257827',4906637,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257827',4906638,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257827',4906639,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257827',4906640,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257827',4906641,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257827',4906642,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257827',4906643,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257827',4906644,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257828',4906645,'3026','467',173604.37,174761.62,0.00,0.00,1157.25,890868.75,0.00,0.00,0.00),('19','199','1023','257828',4906646,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257828',4906647,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257828',4906648,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257828',4906649,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257828',4906650,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257828',4906651,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257828',4906652,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257828',4906653,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257829',4906654,'3026','467',174761.62,176008.37,0.00,0.00,1246.75,959481.25,0.00,0.00,0.00),('19','199','1023','257829',4906655,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257829',4906656,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257829',4906657,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257829',4906658,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257829',4906659,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257829',4906660,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257829',4906661,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257829',4906662,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257830',4906663,'3026','467',176008.37,177042.62,0.00,0.00,1034.25,796673.75,0.00,0.00,0.00),('19','199','1023','257830',4906664,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257830',4906665,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257830',4906666,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257830',4906667,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257830',4906668,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257830',4906669,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257830',4906670,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257830',4906671,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257831',4906672,'3026','467',177042.62,177501.12,0.00,0.00,458.50,354837.50,0.00,0.00,0.00),('19','199','1023','257831',4906673,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257831',4906674,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257831',4906675,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257831',4906676,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257831',4906677,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257831',4906678,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257831',4906679,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257831',4906680,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257832',4906681,'3026','467',177501.12,178904.12,0.00,0.00,1403.00,1006008.00,0.00,0.00,0.00),('19','199','1023','257832',4906682,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257832',4906683,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257832',4906684,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257832',4906685,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257832',4906686,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257832',4906687,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257832',4906688,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257832',4906689,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257833',4906690,'3026','467',178904.12,180284.87,0.00,0.00,1380.75,991032.00,0.00,0.00,0.00),('19','199','1023','257833',4906691,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257833',4906692,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257833',4906693,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257833',4906694,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257833',4906695,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257833',4906696,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257833',4906697,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257833',4906698,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257834',4906699,'3026','467',180284.87,181662.87,0.00,0.00,1378.00,986908.00,0.00,0.00,0.00),('19','199','1023','257834',4906700,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257834',4906701,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257834',4906702,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257834',4906703,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257834',4906704,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257834',4906705,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257834',4906706,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257834',4906707,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257835',4906708,'3026','467',181662.87,182417.37,0.00,0.00,754.50,544112.00,0.00,0.00,0.00),('19','199','1023','257835',4906709,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257835',4906710,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257835',4906711,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257835',4906712,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257835',4906713,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257835',4906714,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257835',4906715,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257835',4906716,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257836',4906717,'3026','467',182417.37,183897.37,0.00,0.00,1480.00,1069120.00,0.00,0.00,0.00),('19','199','1023','257836',4906718,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257836',4906719,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257836',4906720,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257836',4906721,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257836',4906722,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257836',4906723,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257836',4906724,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257836',4906725,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257837',4906726,'3026','467',183897.37,184776.12,0.00,0.00,878.75,638360.00,0.00,0.00,0.00),('19','199','1023','257837',4906727,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257837',4906728,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257837',4906729,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257837',4906730,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257837',4906731,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257837',4906732,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257837',4906733,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257837',4906734,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257838',4906735,'3026','467',184776.12,186195.37,0.00,0.00,1419.25,1019368.00,0.00,0.00,0.00),('19','199','1023','257838',4906736,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257838',4906737,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257838',4906738,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257838',4906739,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257838',4906740,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257838',4906741,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257838',4906742,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257838',4906743,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257839',4906744,'3026','467',186195.37,187798.12,0.00,0.00,1602.75,1147424.00,0.00,0.00,0.00),('19','199','1023','257839',4906745,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257839',4906746,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257839',4906747,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257839',4906748,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257839',4906749,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257839',4906750,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257839',4906751,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257839',4906752,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257840',4906753,'3026','467',187798.12,188352.62,0.00,0.00,554.50,402512.00,0.00,0.00,0.00),('19','199','1023','257840',4906754,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257840',4906755,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257840',4906756,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257840',4906757,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257840',4906758,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257840',4906759,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257840',4906760,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257840',4906761,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257841',4906762,'3026','467',188352.62,188993.62,0.00,0.00,641.00,466176.00,0.00,0.00,0.00),('19','199','1023','257841',4906763,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257841',4906764,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257841',4906765,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257841',4906766,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257841',4906767,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257841',4906768,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257841',4906769,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257841',4906770,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257842',4906771,'3026','467',188993.62,189384.12,0.00,0.00,390.50,283208.00,0.00,0.00,0.00),('19','199','1023','257842',4906772,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257842',4906773,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257842',4906774,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257842',4906775,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257842',4906776,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257842',4906777,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257842',4906778,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257842',4906779,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257843',4906780,'3026','467',189384.12,189888.37,0.00,0.00,504.25,367124.00,0.00,0.00,0.00),('19','199','1023','257843',4906781,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257843',4906782,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257843',4906783,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257843',4906784,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257843',4906785,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257843',4906786,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257843',4906787,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257843',4906788,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257844',4906789,'3026','467',189888.37,190895.87,0.00,0.00,1007.50,723320.00,0.00,0.00,0.00),('19','199','1023','257844',4906790,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257844',4906791,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257844',4906792,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257844',4906793,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257844',4906794,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257844',4906795,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257844',4906796,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257844',4906797,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257845',4906798,'3026','467',190895.87,191328.87,0.00,0.00,433.00,318688.00,0.00,0.00,0.00),('19','199','1023','257845',4906799,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257845',4906800,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257845',4906801,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257845',4906802,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257845',4906803,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257845',4906804,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257845',4906805,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257845',4906806,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257846',4906807,'3026','467',191328.87,191785.37,0.00,0.00,456.50,333184.00,0.00,0.00,0.00),('19','199','1023','257846',4906808,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257846',4906809,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257846',4906810,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257846',4906811,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257846',4906812,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257846',4906813,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257846',4906814,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257846',4906815,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257847',4906816,'3026','467',191785.37,192215.87,0.00,0.00,430.50,316848.00,0.00,0.00,0.00),('19','199','1023','257847',4906817,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257847',4906818,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257847',4906819,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257847',4906820,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257847',4906821,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257847',4906822,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257847',4906823,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257847',4906824,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257848',4906825,'3026','467',192215.87,192813.12,0.00,0.00,597.25,435376.00,0.00,0.00,0.00),('19','199','1023','257848',4906826,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257848',4906827,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257848',4906828,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257848',4906829,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257848',4906830,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257848',4906831,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257848',4906832,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257848',4906833,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257849',4906834,'3026','467',192813.12,193095.87,0.00,0.00,282.75,208104.00,0.00,0.00,0.00),('19','199','1023','257849',4906835,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257849',4906836,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257849',4906837,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257849',4906838,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257849',4906839,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257849',4906840,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257849',4906841,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257849',4906842,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257850',4906843,'3026','467',193095.87,194049.62,0.00,0.00,953.75,687050.00,0.00,0.00,0.00),('19','199','1023','257850',4906844,'3027','467',388.75,388.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257850',4906845,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257850',4906846,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257850',4906847,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257850',4906848,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257850',4906849,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257850',4906850,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257850',4906851,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257851',4906852,'3026','467',194049.62,195084.87,0.00,0.00,1035.25,743744.00,0.00,0.00,0.00),('19','199','1023','257851',4906853,'3027','467',388.75,398.75,0.00,0.00,10.00,7360.00,0.00,0.00,0.00),('19','199','1023','257851',4906854,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257851',4906855,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257851',4906856,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257851',4906857,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257851',4906858,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257851',4906859,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257851',4906860,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257852',4906861,'3026','467',195084.87,196107.62,0.00,0.00,1022.75,735944.00,0.00,0.00,0.00),('19','199','1023','257852',4906862,'3027','467',398.75,398.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257852',4906863,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257852',4906864,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257852',4906865,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257852',4906866,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257852',4906867,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257852',4906868,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257852',4906869,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257853',4906870,'3026','467',196107.62,196539.12,0.00,0.00,431.50,317584.00,0.00,0.00,0.00),('19','199','1023','257853',4906871,'3027','467',398.75,398.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257853',4906872,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257853',4906873,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257853',4906874,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257853',4906875,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257853',4906876,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257853',4906877,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257853',4906878,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257854',4906879,'3026','467',196539.12,197062.12,0.00,0.00,523.00,382128.00,0.00,0.00,0.00),('19','199','1023','257854',4906880,'3027','467',398.75,398.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257854',4906881,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257854',4906882,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257854',4906883,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257854',4906884,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257854',4906885,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257854',4906886,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257854',4906887,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257855',4906888,'3026','467',197062.12,197589.62,0.00,0.00,527.50,386840.00,0.00,0.00,0.00),('19','199','1023','257855',4906889,'3027','467',398.75,398.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257855',4906890,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257855',4906891,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257855',4906892,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257855',4906893,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257855',4906894,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257855',4906895,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257855',4906896,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257856',4906897,'3026','467',197589.62,197944.62,0.00,0.00,355.00,261280.00,0.00,0.00,0.00),('19','199','1023','257856',4906898,'3027','467',398.75,398.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257856',4906899,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257856',4906900,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257856',4906901,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257856',4906902,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257856',4906903,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257856',4906904,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257856',4906905,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257857',4906906,'3026','467',197944.62,198427.87,0.00,0.00,483.25,355672.00,0.00,0.00,0.00),('19','199','1023','257857',4906907,'3027','467',398.75,398.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257857',4906908,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257857',4906909,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257857',4906910,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257857',4906911,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257857',4906912,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257857',4906913,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257857',4906914,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257858',4906915,'3026','467',198427.87,199760.37,0.00,0.00,1332.50,965320.00,0.00,0.00,0.00),('19','199','1023','257858',4906916,'3027','467',398.75,398.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257858',4906917,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257858',4906918,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257858',4906919,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257858',4906920,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257858',4906921,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257858',4906922,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257858',4906923,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257859',4906924,'3026','467',199760.37,201013.62,0.00,0.00,1253.25,913992.00,0.00,0.00,0.00),('19','199','1023','257859',4906925,'3027','467',398.75,398.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257859',4906926,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257859',4906927,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257859',4906928,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257859',4906929,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257859',4906930,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257859',4906931,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257859',4906932,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257860',4906933,'3026','467',201013.62,201545.87,0.00,0.00,532.25,391736.00,0.00,0.00,0.00),('19','199','1023','257860',4906934,'3027','467',398.75,398.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257860',4906935,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257860',4906936,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257860',4906937,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257860',4906938,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257860',4906939,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257860',4906940,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257860',4906941,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257861',4906942,'3026','467',201545.87,201997.37,0.00,0.00,451.50,330904.00,0.00,0.00,0.00),('19','199','1023','257861',4906943,'3027','467',398.75,398.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257861',4906944,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257861',4906945,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257861',4906946,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257861',4906947,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257861',4906948,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257861',4906949,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257861',4906950,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257862',4906951,'3026','467',201997.37,202369.62,0.00,0.00,372.25,273976.00,0.00,0.00,0.00),('19','199','1023','257862',4906952,'3027','467',398.75,398.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257862',4906953,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257862',4906954,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257862',4906955,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257862',4906956,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257862',4906957,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257862',4906958,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257862',4906959,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257863',4906960,'3026','467',202369.62,202708.37,0.00,0.00,338.75,249320.00,0.00,0.00,0.00),('19','199','1023','257863',4906961,'3027','467',398.75,398.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257863',4906962,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257863',4906963,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257863',4906964,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257863',4906965,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257863',4906966,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257863',4906967,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257863',4906968,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257864',4906969,'3026','467',202708.37,203597.37,0.00,0.00,889.00,654304.00,0.00,0.00,0.00),('19','199','1023','257864',4906970,'3027','467',398.75,398.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257864',4906971,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257864',4906972,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257864',4906973,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257864',4906974,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257864',4906975,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257864',4906976,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257864',4906977,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257865',4906978,'3026','467',203597.37,204654.37,0.00,0.00,1057.00,759752.00,0.00,0.00,0.00),('19','199','1023','257865',4906979,'3027','467',398.75,398.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257865',4906980,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257865',4906981,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257865',4906982,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257865',4906983,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257865',4906984,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257865',4906985,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257865',4906986,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257866',4906987,'3026','467',204654.37,205685.37,0.00,0.00,1031.00,744816.00,0.00,0.00,0.00),('19','199','1023','257866',4906988,'3027','467',398.75,398.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257866',4906989,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257866',4906990,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257866',4906991,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257866',4906992,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257866',4906993,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257866',4906994,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257866',4906995,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257867',4906996,'3026','467',205685.37,206266.62,0.00,0.00,581.25,427800.00,0.00,0.00,0.00),('19','199','1023','257867',4906997,'3027','467',398.75,398.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257867',4906998,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257867',4906999,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257867',4907000,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257867',4907001,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257867',4907002,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257867',4907003,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257867',4907004,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257868',4907005,'3026','467',206266.62,206675.37,0.00,0.00,408.75,299440.00,0.00,0.00,0.00),('19','199','1023','257868',4907006,'3027','467',398.75,398.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257868',4907007,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257868',4907008,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257868',4907009,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257868',4907010,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257868',4907011,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257868',4907012,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257868',4907013,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257869',4907014,'3026','467',206675.37,207049.37,0.00,0.00,374.00,275264.00,0.00,0.00,0.00),('19','199','1023','257869',4907015,'3027','467',398.75,398.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257869',4907016,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257869',4907017,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257869',4907018,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257869',4907019,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257869',4907020,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257869',4907021,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257869',4907022,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257870',4907023,'3026','467',207049.37,207788.37,0.00,0.00,739.00,541104.00,0.00,0.00,0.00),('19','199','1023','257870',4907024,'3027','467',398.75,398.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257870',4907025,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257870',4907026,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257870',4907027,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257870',4907028,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257870',4907029,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257870',4907030,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257870',4907031,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257871',4907032,'3026','467',207788.37,208608.12,0.00,0.00,819.75,593536.00,0.00,0.00,0.00),('19','199','1023','257871',4907033,'3027','467',398.75,411.25,0.00,0.00,12.50,9200.00,0.00,0.00,0.00),('19','199','1023','257871',4907034,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257871',4907035,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257871',4907036,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257871',4907037,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257871',4907038,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257871',4907039,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257871',4907040,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257872',4907041,'3026','467',208608.12,209169.12,0.00,0.00,561.00,408696.00,0.00,0.00,0.00),('19','199','1023','257872',4907042,'3027','467',411.25,411.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257872',4907043,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257872',4907044,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257872',4907045,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257872',4907046,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257872',4907047,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257872',4907048,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257872',4907049,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257873',4907050,'3026','467',209169.12,210132.87,0.00,0.00,963.75,696720.00,0.00,0.00,0.00),('19','199','1023','257873',4907051,'3027','467',411.25,411.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257873',4907052,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257873',4907053,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257873',4907054,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257873',4907055,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257873',4907056,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257873',4907057,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257873',4907058,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257874',4907059,'3026','467',210132.87,210537.87,0.00,0.00,405.00,298080.00,0.00,0.00,0.00),('19','199','1023','257874',4907060,'3027','467',411.25,411.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257874',4907061,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257874',4907062,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257874',4907063,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257874',4907064,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257874',4907065,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257874',4907066,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257874',4907067,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257875',4907068,'3026','467',210537.87,210882.37,0.00,0.00,344.50,253552.00,0.00,0.00,0.00),('19','199','1023','257875',4907069,'3027','467',411.25,426.75,0.00,0.00,15.50,11408.00,0.00,0.00,0.00),('19','199','1023','257875',4907070,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257875',4907071,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257875',4907072,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257875',4907073,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257875',4907074,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257875',4907075,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257875',4907076,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257876',4907077,'3026','467',210882.37,211309.37,0.00,0.00,427.00,314272.00,0.00,0.00,0.00),('19','199','1023','257876',4907078,'3027','467',426.75,426.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257876',4907079,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257876',4907080,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257876',4907081,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257876',4907082,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257876',4907083,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257876',4907084,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257876',4907085,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257877',4907086,'3026','467',211309.37,212073.87,0.00,0.00,764.50,561412.00,0.00,0.00,0.00),('19','199','1023','257877',4907087,'3027','467',426.75,426.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257877',4907088,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257877',4907089,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257877',4907090,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257877',4907091,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257877',4907092,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257877',4907093,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257877',4907094,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257878',4907095,'3026','467',212073.87,212497.87,0.00,0.00,424.00,312064.00,0.00,0.00,0.00),('19','199','1023','257878',4907096,'3027','467',426.75,439.25,0.00,0.00,12.50,9200.00,0.00,0.00,0.00),('19','199','1023','257878',4907097,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257878',4907098,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257878',4907099,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257878',4907100,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257878',4907101,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257878',4907102,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257878',4907103,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257879',4907104,'3026','467',212497.87,212968.12,0.00,0.00,470.25,346104.00,0.00,0.00,0.00),('19','199','1023','257879',4907105,'3027','467',439.25,449.25,0.00,0.00,10.00,7360.00,0.00,0.00,0.00),('19','199','1023','257879',4907106,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257879',4907107,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257879',4907108,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257879',4907109,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257879',4907110,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257879',4907111,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257879',4907112,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257880',4907113,'3026','467',212968.12,213567.87,0.00,0.00,599.75,433016.00,0.00,0.00,0.00),('19','199','1023','257880',4907114,'3027','467',449.25,449.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257880',4907115,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257880',4907116,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257880',4907117,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257880',4907118,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257880',4907119,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257880',4907120,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257880',4907121,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257881',4907122,'3026','467',213567.87,213888.87,0.00,0.00,321.00,236256.00,0.00,0.00,0.00),('19','199','1023','257881',4907123,'3027','467',449.25,449.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257881',4907124,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257881',4907125,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257881',4907126,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257881',4907127,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257881',4907128,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257881',4907129,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257881',4907130,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257882',4907131,'3026','467',213888.87,214096.87,0.00,0.00,208.00,153088.00,0.00,0.00,0.00),('19','199','1023','257882',4907132,'3027','467',449.25,449.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257882',4907133,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257882',4907134,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257882',4907135,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257882',4907136,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257882',4907137,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257882',4907138,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257882',4907139,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257883',4907140,'3026','467',214096.87,214719.37,0.00,0.00,622.50,455360.00,0.00,0.00,0.00),('19','199','1023','257883',4907141,'3027','467',449.25,449.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257883',4907142,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257883',4907143,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257883',4907144,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257883',4907145,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257883',4907146,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257883',4907147,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257883',4907148,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257884',4907149,'3026','467',214719.37,215263.62,0.00,0.00,544.25,400568.00,0.00,0.00,0.00),('19','199','1023','257884',4907150,'3027','467',449.25,452.25,0.00,0.00,3.00,2208.00,0.00,0.00,0.00),('19','199','1023','257884',4907151,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257884',4907152,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257884',4907153,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257884',4907154,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257884',4907155,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257884',4907156,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257884',4907157,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257885',4907158,'3026','467',215263.62,216161.87,0.00,0.00,898.25,651312.00,0.00,0.00,0.00),('19','199','1023','257885',4907159,'3027','467',452.25,458.50,0.00,0.00,6.25,4600.00,0.00,0.00,0.00),('19','199','1023','257885',4907160,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257885',4907161,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257885',4907162,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257885',4907163,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257885',4907164,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257885',4907165,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257885',4907166,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257886',4907167,'3026','467',216161.87,216918.12,0.00,0.00,756.25,546800.00,0.00,0.00,0.00),('19','199','1023','257886',4907168,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257886',4907169,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257886',4907170,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257886',4907171,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257886',4907172,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257886',4907173,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257886',4907174,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257886',4907175,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257887',4907176,'3026','467',216918.12,217391.87,0.00,0.00,473.75,346580.00,0.00,0.00,0.00),('19','199','1023','257887',4907177,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257887',4907178,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257887',4907179,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257887',4907180,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257887',4907181,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257887',4907182,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257887',4907183,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257887',4907184,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257888',4907185,'3026','467',217391.87,217806.87,0.00,0.00,415.00,305440.00,0.00,0.00,0.00),('19','199','1023','257888',4907186,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257888',4907187,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257888',4907188,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257888',4907189,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257888',4907190,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257888',4907191,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257888',4907192,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257888',4907193,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257889',4907194,'3026','467',217806.87,218191.37,0.00,0.00,384.50,282992.00,0.00,0.00,0.00),('19','199','1023','257889',4907195,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257889',4907196,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257889',4907197,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257889',4907198,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257889',4907199,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257889',4907200,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257889',4907201,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257889',4907202,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257890',4907203,'3026','467',218191.37,218947.12,0.00,0.00,755.75,554832.00,0.00,0.00,0.00),('19','199','1023','257890',4907204,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257890',4907205,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257890',4907206,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257890',4907207,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257890',4907208,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257890',4907209,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257890',4907210,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257890',4907211,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257891',4907212,'3026','467',218947.12,219570.37,0.00,0.00,623.25,458712.00,0.00,0.00,0.00),('19','199','1023','257891',4907213,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257891',4907214,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257891',4907215,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257891',4907216,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257891',4907217,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257891',4907218,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257891',4907219,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257891',4907220,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257892',4907221,'3026','467',219570.37,220060.12,0.00,0.00,489.75,360456.00,0.00,0.00,0.00),('19','199','1023','257892',4907222,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257892',4907223,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257892',4907224,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257892',4907225,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257892',4907226,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257892',4907227,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257892',4907228,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257892',4907229,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257893',4907230,'3026','467',220060.12,220457.87,0.00,0.00,397.75,289944.00,0.00,0.00,0.00),('19','199','1023','257893',4907231,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257893',4907232,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257893',4907233,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257893',4907234,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257893',4907235,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257893',4907236,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257893',4907237,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257893',4907238,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257894',4907239,'3026','467',220457.87,220457.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257894',4907240,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257894',4907241,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257894',4907242,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257894',4907243,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257894',4907244,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257894',4907245,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257894',4907246,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257894',4907247,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257895',4907248,'3026','467',220457.87,220460.87,0.00,0.00,3.00,2208.00,0.00,0.00,0.00),('19','199','1023','257895',4907249,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257895',4907250,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257895',4907251,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257895',4907252,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257895',4907253,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257895',4907254,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257895',4907255,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257895',4907256,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257895',4907257,'3035','467',0.00,960.00,0.00,0.00,960.00,699560.00,0.00,0.00,0.00),('19','199','1023','257896',4907258,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257896',4907259,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257896',4907260,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257896',4907261,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257896',4907262,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257896',4907263,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257896',4907264,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257896',4907265,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257896',4907266,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257896',4907267,'3035','467',960.00,1401.25,0.00,0.00,441.25,324760.00,0.00,0.00,0.00),('19','199','1023','257897',4907268,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257897',4907269,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257897',4907270,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257897',4907271,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257897',4907272,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257897',4907273,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257897',4907274,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257897',4907275,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257897',4907276,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257897',4907277,'3035','467',1401.25,1807.75,0.00,0.00,406.50,299184.00,0.00,0.00,0.00),('19','199','1023','257898',4907278,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257898',4907279,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257898',4907280,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257898',4907281,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257898',4907282,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257898',4907283,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257898',4907284,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257898',4907285,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257898',4907286,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257898',4907287,'3035','467',1807.75,2464.25,0.00,0.00,656.50,483184.00,0.00,0.00,0.00),('19','199','1023','257899',4907288,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257899',4907289,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257899',4907290,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257899',4907291,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257899',4907292,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257899',4907293,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257899',4907294,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257899',4907295,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257899',4907296,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257899',4907297,'3035','467',2464.25,2898.50,0.00,0.00,434.25,317648.00,0.00,0.00,0.00),('19','199','1023','257900',4907298,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257900',4907299,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257900',4907300,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257900',4907301,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257900',4907302,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257900',4907303,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257900',4907304,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257900',4907305,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257900',4907306,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257900',4907307,'3035','467',2898.50,3627.50,0.00,0.00,729.00,536544.00,0.00,0.00,0.00),('19','199','1023','257901',4907308,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257901',4907309,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257901',4907310,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257901',4907311,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257901',4907312,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257901',4907313,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257901',4907314,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257901',4907315,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257901',4907316,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257901',4907317,'3035','467',3627.50,4753.00,0.00,0.00,1125.50,814368.00,0.00,0.00,0.00),('19','199','1023','257902',4907318,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257902',4907319,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257902',4907320,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257902',4907321,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257902',4907322,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257902',4907323,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257902',4907324,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257902',4907325,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257902',4907326,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257902',4907327,'3035','467',4753.00,5415.25,0.00,0.00,662.25,487416.00,0.00,0.00,0.00),('19','199','1023','257903',4907328,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257903',4907329,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257903',4907330,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257903',4907331,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257903',4907332,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257903',4907333,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257903',4907334,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257903',4907335,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257903',4907336,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257903',4907337,'3035','467',5415.25,5997.00,0.00,0.00,581.75,423968.00,0.00,0.00,0.00),('19','199','1023','257904',4907338,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257904',4907339,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257904',4907340,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257904',4907341,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257904',4907342,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257904',4907343,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257904',4907344,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257904',4907345,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257904',4907346,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257904',4907347,'3035','467',5997.00,6383.00,0.00,0.00,386.00,284096.00,0.00,0.00,0.00),('19','199','1023','257905',4907348,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257905',4907349,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257905',4907350,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257905',4907351,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257905',4907352,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257905',4907353,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257905',4907354,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257905',4907355,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257905',4907356,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257905',4907357,'3035','467',6383.00,6929.75,0.00,0.00,546.75,402408.00,0.00,0.00,0.00),('19','199','1023','257906',4907358,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257906',4907359,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257906',4907360,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257906',4907361,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257906',4907362,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257906',4907363,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257906',4907364,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257906',4907365,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257906',4907366,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257906',4907367,'3035','467',6929.75,7504.00,0.00,0.00,574.25,422648.00,0.00,0.00,0.00),('19','199','1023','257907',4907368,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257907',4907369,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257907',4907370,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257907',4907371,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257907',4907372,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257907',4907373,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257907',4907374,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257907',4907375,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257907',4907376,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257907',4907377,'3035','467',7504.00,7990.50,0.00,0.00,486.50,358064.00,0.00,0.00,0.00),('19','199','1023','257908',4907378,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257908',4907379,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257908',4907380,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257908',4907381,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257908',4907382,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257908',4907383,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257908',4907384,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257908',4907385,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257908',4907386,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257908',4907387,'3035','467',7990.50,8477.75,0.00,0.00,487.25,358616.00,0.00,0.00,0.00),('19','199','1023','257909',4907388,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257909',4907389,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257909',4907390,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257909',4907391,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257909',4907392,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257909',4907393,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257909',4907394,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257909',4907395,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257909',4907396,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257909',4907397,'3035','467',8477.75,8856.25,0.00,0.00,378.50,278576.00,0.00,0.00,0.00),('19','199','1023','257910',4907398,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257910',4907399,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257910',4907400,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257910',4907401,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257910',4907402,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257910',4907403,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257910',4907404,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257910',4907405,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257910',4907406,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257910',4907407,'3035','467',8856.25,9321.00,0.00,0.00,464.75,342056.00,0.00,0.00,0.00),('19','199','1023','257911',4907408,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257911',4907409,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257911',4907410,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257911',4907411,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257911',4907412,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257911',4907413,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257911',4907414,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257911',4907415,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257911',4907416,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257911',4907417,'3035','467',9321.00,9627.50,0.00,0.00,306.50,224184.00,0.00,0.00,0.00),('19','199','1023','257912',4907418,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257912',4907419,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257912',4907420,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257912',4907421,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257912',4907422,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257912',4907423,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257912',4907424,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257912',4907425,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257912',4907426,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257912',4907427,'3035','467',9627.50,10213.00,0.00,0.00,585.50,430928.00,0.00,0.00,0.00),('19','199','1023','257913',4907428,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257913',4907429,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257913',4907430,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257913',4907431,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257913',4907432,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257913',4907433,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257913',4907434,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257913',4907435,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257913',4907436,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257913',4907437,'3035','467',10213.00,10372.75,0.00,0.00,159.75,117576.00,0.00,0.00,0.00),('19','199','1023','257914',4907438,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257914',4907439,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257914',4907440,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257914',4907441,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257914',4907442,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257914',4907443,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257914',4907444,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257914',4907445,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257914',4907446,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257914',4907447,'3035','467',10372.75,10804.50,0.00,0.00,431.75,317768.00,0.00,0.00,0.00),('19','199','1023','257915',4907448,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257915',4907449,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257915',4907450,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257915',4907451,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257915',4907452,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257915',4907453,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257915',4907454,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257915',4907455,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257915',4907456,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257915',4907457,'3035','467',10804.50,11498.00,0.00,0.00,693.50,510416.00,0.00,0.00,0.00),('19','199','1023','257916',4907458,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257916',4907459,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257916',4907460,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257916',4907461,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257916',4907462,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257916',4907463,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257916',4907464,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257916',4907465,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257916',4907466,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257916',4907467,'3035','467',11498.00,11662.00,0.00,0.00,164.00,120704.00,0.00,0.00,0.00),('19','199','1023','257917',4907468,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257917',4907469,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257917',4907470,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257917',4907471,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257917',4907472,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257917',4907473,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257917',4907474,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257917',4907475,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257917',4907476,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257917',4907477,'3035','467',11662.00,12520.50,0.00,0.00,858.50,631856.00,0.00,0.00,0.00),('19','199','1023','257918',4907478,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257918',4907479,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257918',4907480,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257918',4907481,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257918',4907482,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257918',4907483,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257918',4907484,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257918',4907485,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257918',4907486,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257918',4907487,'3035','467',12520.50,13608.75,0.00,0.00,1088.25,791152.00,0.00,0.00,0.00),('19','199','1023','257919',4907488,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257919',4907489,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257919',4907490,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257919',4907491,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257919',4907492,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257919',4907493,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257919',4907494,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257919',4907495,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257919',4907496,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257919',4907497,'3035','467',13608.75,14163.00,0.00,0.00,554.25,404428.00,0.00,0.00,0.00),('19','199','1023','257920',4907498,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257920',4907499,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257920',4907500,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257920',4907501,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257920',4907502,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257920',4907503,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257920',4907504,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257920',4907505,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257920',4907506,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257920',4907507,'3035','467',14163.00,14901.00,0.00,0.00,738.00,536168.00,0.00,0.00,0.00),('19','199','1023','257921',4907508,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257921',4907509,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257921',4907510,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257921',4907511,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257921',4907512,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257921',4907513,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257921',4907514,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257921',4907515,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257921',4907516,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257921',4907517,'3035','467',14901.00,15736.25,0.00,0.00,835.25,603544.00,0.00,0.00,0.00),('19','199','1023','257922',4907518,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257922',4907519,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257922',4907520,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257922',4907521,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257922',4907522,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257922',4907523,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257922',4907524,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257922',4907525,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257922',4907526,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257922',4907527,'3035','467',15736.25,16507.50,0.00,0.00,771.25,557840.00,0.00,0.00,0.00),('19','199','1023','257923',4907528,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257923',4907529,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257923',4907530,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257923',4907531,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257923',4907532,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257923',4907533,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257923',4907534,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257923',4907535,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257923',4907536,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257923',4907537,'3035','467',16507.50,17381.25,0.00,0.00,873.75,640420.00,0.00,0.00,0.00),('19','199','1023','257924',4907538,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257924',4907539,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257924',4907540,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257924',4907541,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257924',4907542,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257924',4907543,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257924',4907544,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257924',4907545,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257924',4907546,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257924',4907547,'3035','467',17381.25,18243.50,0.00,0.00,862.25,625936.00,0.00,0.00,0.00),('19','199','1023','257925',4907548,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257925',4907549,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257925',4907550,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257925',4907551,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257925',4907552,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257925',4907553,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257925',4907554,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257925',4907555,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257925',4907556,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257925',4907557,'3035','467',18243.50,19251.25,0.00,0.00,1007.75,722804.00,0.00,0.00,0.00),('19','199','1023','257926',4907558,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257926',4907559,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257926',4907560,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257926',4907561,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257926',4907562,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257926',4907563,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257926',4907564,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257926',4907565,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257926',4907566,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257926',4907567,'3035','467',19251.25,19765.75,0.00,0.00,514.50,377272.00,0.00,0.00,0.00),('19','199','1023','257927',4907568,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257927',4907569,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257927',4907570,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257927',4907571,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257927',4907572,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257927',4907573,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257927',4907574,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257927',4907575,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257927',4907576,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257927',4907577,'3035','467',19765.75,20254.50,0.00,0.00,488.75,357620.00,0.00,0.00,0.00),('19','199','1023','257928',4907578,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257928',4907579,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257928',4907580,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257928',4907581,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257928',4907582,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257928',4907583,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257928',4907584,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257928',4907585,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257928',4907586,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257928',4907587,'3035','467',20254.50,20630.00,0.00,0.00,375.50,274968.00,0.00,0.00,0.00),('19','199','1023','257929',4907588,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257929',4907589,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257929',4907590,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257929',4907591,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257929',4907592,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257929',4907593,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257929',4907594,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257929',4907595,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257929',4907596,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257929',4907597,'3035','467',20630.00,20929.50,0.00,0.00,299.50,220432.00,0.00,0.00,0.00),('19','199','1023','257930',4907598,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257930',4907599,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257930',4907600,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257930',4907601,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257930',4907602,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257930',4907603,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257930',4907604,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257930',4907605,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257930',4907606,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257930',4907607,'3035','467',20929.50,21349.75,0.00,0.00,420.25,308604.00,0.00,0.00,0.00),('19','199','1023','257931',4907608,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257931',4907609,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257931',4907610,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257931',4907611,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257931',4907612,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257931',4907613,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257931',4907614,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257931',4907615,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257931',4907616,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257931',4907617,'3035','467',21349.75,21968.75,0.00,0.00,619.00,453624.00,0.00,0.00,0.00),('19','199','1023','257932',4907618,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257932',4907619,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257932',4907620,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257932',4907621,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257932',4907622,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257932',4907623,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257932',4907624,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257932',4907625,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257932',4907626,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257932',4907627,'3035','467',21968.75,27123.00,0.00,0.00,5154.25,3695528.00,0.00,0.00,0.00),('19','199','1023','257933',4907628,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257933',4907629,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257933',4907630,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257933',4907631,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257933',4907632,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257933',4907633,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257933',4907634,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257933',4907635,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257933',4907636,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257933',4907637,'3035','467',27123.00,27606.00,0.00,0.00,483.00,354088.00,0.00,0.00,0.00),('19','199','1023','257934',4907638,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257934',4907639,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257934',4907640,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257934',4907641,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257934',4907642,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257934',4907643,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257934',4907644,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257934',4907645,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257934',4907646,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257934',4907647,'3035','467',27606.00,28001.00,0.00,0.00,395.00,290720.00,0.00,0.00,0.00),('19','199','1023','257935',4907648,'3026','467',220460.87,220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257935',4907649,'3027','467',458.50,458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257935',4907650,'3028','467',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257935',4907651,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257935',4907652,'3030','467',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257935',4907653,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257935',4907654,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257935',4907655,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257935',4907656,'3034','467',6.25,6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257935',4907657,'3035','467',28001.00,28242.25,0.00,0.00,241.25,174410.00,0.00,0.00,0.00),('19','199','1023','257936',4907658,'3026','467',220460.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257936',4907659,'3027','467',458.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257936',4907660,'3028','467',50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257936',4907661,'3029','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257936',4907662,'3030','467',12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257936',4907663,'3031','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257936',4907664,'3032','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257936',4907665,'3033','467',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1023','257936',4907666,'3034','467',6.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('19','199','1024','257936',4907667,'3035','467',28242.25,0.00,0.00,0.00,1517.00,1096212.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730118 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('19','199','240272','467',600.00,635.00,0.00,56.00,33600.00,35560.00,1960.00,685098),('19','199','240331','467',600.00,635.00,0.00,0.00,0.00,0.00,0.00,685251),('19','199','244292','467',552.50,648.00,0.00,408.75,225834.43,264870.00,39035.68,695569),('19','199','244573','467',552.50,648.00,0.00,755.25,417275.67,489402.00,72126.42,696281),('19','199','244720','467',552.50,648.00,0.00,437.00,241442.52,282276.00,40833.52,696696),('19','199','245024','467',552.50,648.00,0.00,361.75,199866.89,232614.00,32747.14,697454),('19','199','245249','467',552.50,648.00,0.00,368.50,203596.29,238788.00,35191.79,698037),('19','199','245760','467',552.50,648.00,0.00,332.75,183844.39,215622.00,31777.64,699355),('19','199','245976','467',552.50,648.00,0.00,539.50,298073.78,348696.00,50622.28,699927),('19','199','246228','467',552.50,648.00,0.00,453.50,250558.79,292518.00,41959.29,700568),('19','199','246511','467',552.50,648.00,0.00,408.25,225558.14,262746.00,37187.89,701322),('19','199','246748','467',552.50,648.00,0.00,322.75,178319.39,209142.00,30822.64,701941),('19','199','246946','467',552.50,648.00,0.00,189.00,104422.52,122472.00,18049.52,702452),('19','199','247442','467',552.50,648.00,0.00,438.00,241995.02,283824.00,41829.02,703715),('19','199','247697','467',552.50,648.00,0.00,405.75,224176.88,262926.00,38749.13,704391),('19','199','247948','467',552.50,648.00,0.00,390.25,214233.13,251082.00,36848.88,705026),('19','199','248209','467',512.50,648.00,0.00,267.75,137221.89,173502.00,36280.14,705710),('19','199','248442','467',512.50,648.00,0.00,518.75,265859.38,336150.00,70290.63,706309),('19','199','248675','467',512.50,648.00,0.00,276.67,141793.40,179282.16,37488.81,706903),('19','199','248908','467',512.50,648.00,0.00,413.25,211790.63,267786.00,55995.38,707509),('19','199','249150','467',512.50,648.00,0.00,336.50,172456.26,218052.00,45595.76,708113),('19','199','249389','467',512.50,648.00,0.00,533.50,273418.77,342018.00,68599.27,708725),('19','199','249632','467',512.50,648.00,0.00,345.25,176940.64,223722.00,46781.39,709352),('19','199','249892','467',512.50,648.00,0.00,477.25,244590.63,309258.00,64667.38,710023),('19','199','250137','467',512.50,648.00,0.00,440.00,225500.00,285120.00,59620.00,710646),('19','199','250363','467',512.50,648.00,0.00,391.00,200387.51,253368.00,52980.51,711222),('19','199','250596','467',512.50,648.00,0.00,631.50,323643.75,409212.00,85568.25,711818),('19','199','250836','467',512.50,648.00,0.00,620.50,318006.33,402084.00,84077.83,712440),('19','199','251067','467',512.50,648.00,0.00,637.00,326462.55,409176.00,82713.55,713041),('19','199','251309','467',512.50,648.00,0.00,532.75,273034.41,341622.00,68587.66,713672),('19','199','251567','467',512.50,648.00,0.00,599.50,307243.84,388476.00,81232.34,714342),('19','199','251813','467',512.50,648.00,0.00,535.75,274571.93,347166.00,72594.18,714989),('19','199','252048','467',512.50,648.00,0.00,382.75,196159.41,248022.00,51862.66,715603),('19','199','252272','467',512.50,648.00,0.00,578.25,296353.16,371106.00,74752.91,716193),('19','199','252522','467',512.50,648.00,0.00,485.50,248818.79,314604.00,65785.29,716829),('19','199','252776','467',512.50,648.00,0.00,477.50,244718.80,309420.00,64701.30,717490),('19','199','252988','467',512.50,648.00,0.00,472.25,242028.14,306018.00,63989.89,718049),('19','199','253243','467',512.50,648.00,0.00,424.25,217428.14,270964.00,53535.89,718718),('19','199','253519','467',512.50,648.00,0.00,319.25,163615.64,205074.00,41458.39,719428),('19','199','253743','467',512.50,648.00,0.00,362.00,185525.03,234576.00,49051.03,720006),('19','199','253981','467',512.50,648.00,0.00,472.75,242284.39,300942.00,58657.64,720630),('19','199','254249','467',512.50,648.00,0.00,524.75,268934.44,340038.00,71103.69,721323),('19','199','254483','467',512.50,648.00,0.00,469.50,240618.79,298311.00,57692.29,721929),('19','199','254709','467',512.50,648.00,0.00,344.75,176684.42,223398.00,46713.67,722510),('19','199','254997','467',512.50,648.00,0.00,327.25,167715.65,212058.00,44342.40,723228),('19','199','255227','467',512.50,648.00,0.00,441.50,226268.80,286092.00,59823.30,723818),('19','199','255505','467',512.50,648.00,0.00,597.75,306346.89,375492.00,69145.14,724509),('19','199','255745','467',512.50,648.00,0.00,607.75,311471.90,389872.00,78400.15,725118),('19','199','255963','467',512.50,648.00,0.00,396.75,203334.40,257094.00,53759.65,725675),('19','199','256243','467',512.50,648.00,0.00,348.75,178734.38,225990.00,47255.63,726351),('19','199','256520','467',512.50,648.00,0.00,441.50,226268.79,286092.00,59823.29,727083),('19','199','256763','467',512.50,648.00,0.00,311.75,159771.89,202014.00,42242.14,727697),('19','199','257003','467',512.50,648.00,0.00,491.00,251637.53,318168.00,66530.53,728330),('19','199','257272','467',512.50,648.00,0.00,607.00,311087.58,393336.00,82248.58,729040),('19','199','257528','467',512.50,648.00,0.00,636.25,326078.18,412290.00,86211.93,729709),('19','199','257529','467',512.50,648.00,0.00,612.50,313906.29,396900.00,82993.79,729710),('19','199','257530','467',512.50,648.00,0.00,549.25,281490.66,355914.00,74423.41,729711),('19','199','257531','467',512.50,648.00,0.00,477.75,244846.91,309582.00,64735.16,729712),('19','199','257532','467',512.50,648.00,0.00,425.50,218068.78,275724.00,57655.28,729713),('19','199','257533','467',512.50,648.00,0.00,488.00,250100.01,316224.00,66124.01,729714),('19','199','257534','467',512.50,648.00,0.00,631.25,323515.64,404250.00,80734.39,729715),('19','199','257535','467',512.50,648.00,0.00,577.00,295712.53,366391.00,70678.53,729716),('19','199','257536','467',512.50,648.00,0.00,473.95,242899.41,307119.60,64220.26,729717),('19','199','257537','467',512.50,648.00,0.00,566.00,290075.03,362818.00,72743.03,729718),('19','199','257538','467',512.50,648.00,0.00,488.25,250228.15,308881.00,58652.90,729719),('19','199','257539','467',512.50,648.00,0.00,498.50,255481.28,321053.00,65571.78,729720),('19','199','257540','467',512.50,648.00,0.00,273.75,140296.90,177390.00,37093.15,729721),('19','199','257541','467',512.50,648.00,0.00,414.75,212559.40,262438.00,49878.65,729722),('19','199','257542','467',512.50,648.00,0.00,520.50,266756.26,337284.00,70527.76,729723),('19','199','257543','467',512.50,648.00,0.00,362.25,185653.16,234738.00,49084.91,729724),('19','199','257544','467',512.50,648.00,0.00,370.25,189753.15,239922.00,50168.90,729725),('19','199','257545','467',512.50,648.00,0.00,446.25,228703.16,289170.00,60466.91,729726),('19','199','257546','467',512.50,648.00,0.00,303.00,155287.51,196344.00,41056.51,729727),('19','199','257547','467',512.50,648.00,0.00,239.75,122871.90,155358.00,32486.15,729728),('19','199','257548','467',512.50,648.00,0.00,271.50,139143.76,175932.00,36788.26,729729),('19','199','257549','467',512.50,648.00,0.00,518.50,265731.31,335988.00,70256.81,729730),('19','199','257550','467',512.50,648.00,0.00,255.25,130815.66,165402.00,34586.41,729731),('19','199','257551','467',512.50,648.00,0.00,238.25,122103.18,154386.00,32282.93,729732),('19','199','257552','467',512.50,648.00,0.00,248.50,127356.31,161028.00,33671.81,729733),('19','199','257553','467',512.50,648.00,0.00,222.25,113903.14,144018.00,30114.89,729734),('19','199','257554','467',512.50,648.00,0.00,244.00,125050.02,158112.00,33062.02,729735),('19','199','257555','467',512.50,648.00,0.00,319.50,163743.81,207036.00,43292.31,729736),('19','199','257556','467',512.50,648.00,0.00,392.50,201156.32,254340.00,53183.82,729737),('19','199','257557','467',512.50,648.00,0.00,509.50,261118.81,330156.00,69037.31,729738),('19','199','257558','467',512.50,590.00,0.00,354.25,183490.96,209007.50,25516.74,729739),('19','199','257559','467',517.97,590.00,0.00,361.25,187116.72,213137.50,26020.94,729740),('19','199','257560','467',517.97,590.00,0.00,275.25,142571.27,162397.50,19826.34,729741),('19','199','257561','467',517.97,590.00,0.00,448.00,232050.66,264320.00,32269.59,729742),('19','199','257562','467',517.97,590.00,0.00,278.50,144254.69,164315.00,20060.44,729743),('19','199','257563','467',517.97,590.00,0.00,130.00,67336.14,76700.00,9363.95,729744),('19','199','257564','467',517.97,590.00,0.00,131.50,68113.09,77585.00,9471.99,729745),('19','199','257565','467',517.97,590.00,0.00,455.75,236064.93,268892.50,32827.81,729746),('19','199','257566','467',517.97,590.00,0.00,258.25,133765.82,152367.50,18601.83,729747),('19','199','257567','467',517.97,590.00,0.00,211.50,109550.67,124785.00,15234.39,729748),('19','199','257568','467',517.97,590.00,0.00,224.00,116025.33,132160.00,16134.80,729749),('19','199','257569','467',517.97,600.00,0.00,573.50,297055.87,339850.00,42794.32,729750),('19','199','257570','467',517.97,600.00,0.00,521.00,269862.49,312600.00,42737.78,729751),('19','199','257571','467',517.97,648.00,0.00,281.50,145808.62,182412.00,36603.53,729752),('19','199','257572','467',517.97,648.00,0.00,161.75,83781.69,104814.00,21032.40,729753),('19','199','257573','467',517.97,648.00,0.00,338.00,175073.94,219024.00,43950.23,729754),('19','199','257574','467',517.97,648.00,0.00,227.00,117579.26,147096.00,29516.89,729755),('19','199','257575','467',517.97,648.00,0.00,163.25,84558.62,105786.00,21227.45,729756),('19','199','257576','467',517.97,648.00,0.00,434.25,224928.51,274194.00,49265.62,729757),('19','199','257577','467',517.97,648.00,0.00,302.00,156427.02,195696.00,39269.17,729758),('19','199','257578','467',517.97,648.00,0.00,315.25,163290.11,204282.00,40992.07,729759),('19','199','257579','467',517.97,648.00,0.00,341.75,177016.31,221454.00,44437.86,729760),('19','199','257580','467',517.97,648.00,0.00,274.00,141923.83,177552.00,35628.29,729761),('19','199','257581','467',517.97,672.00,0.00,217.25,112529.03,145992.00,33463.09,729762),('19','199','257582','467',517.97,672.00,0.00,203.50,105406.94,136752.00,31345.17,729763),('19','199','257583','467',517.97,672.00,0.00,245.75,127291.21,165144.00,37852.99,729764),('19','199','257584','467',517.97,672.00,0.00,365.50,189318.11,245616.00,56298.07,729765),('19','199','257585','467',517.97,672.00,0.00,392.50,203303.30,263760.00,60456.89,729766),('19','199','257586','467',517.97,672.00,0.00,501.50,259762.08,337008.00,77246.22,729767),('19','199','257587','467',517.97,672.00,0.00,403.75,209130.45,271320.00,62189.72,729768),('19','199','257588','467',517.97,672.00,0.00,438.75,227259.44,294840.00,67580.80,729769),('19','199','257589','467',517.97,672.00,0.00,514.25,266366.17,345576.00,79210.09,729770),('19','199','257590','467',517.97,672.00,0.00,995.50,515639.34,668976.00,153337.21,729771),('19','199','257591','467',517.97,672.00,0.00,727.00,376564.30,487944.00,111380.04,729772),('19','199','257592','467',517.97,672.00,0.00,535.00,277114.06,359520.00,82406.22,729773),('19','199','257593','467',517.97,672.00,0.00,273.50,141664.84,183792.00,42127.29,729774),('19','199','257594','467',517.97,672.00,0.00,515.25,266884.15,346248.00,79364.14,729775),('19','199','257595','467',517.97,672.00,0.00,386.50,200195.49,259728.00,59532.72,729776),('19','199','257596','467',517.97,672.00,0.00,311.75,161477.21,209496.00,48018.96,729777),('19','199','257597','467',517.97,672.00,0.00,316.50,163937.58,212688.00,48750.61,729778),('19','199','257598','467',517.97,672.00,0.00,518.75,268697.06,348000.00,79303.23,729779),('19','199','257599','467',517.97,672.00,0.00,20.50,10618.39,13776.00,3157.62,729780),('19','199','257600','467',517.97,672.00,0.00,240.00,124312.86,161280.00,36967.28,729781),('19','199','257601','467',517.97,672.00,0.00,297.25,153966.63,199752.00,45785.52,729782),('19','199','257602','467',517.97,672.00,0.00,294.75,152671.72,198072.00,45400.43,729783),('19','199','257603','467',517.97,672.00,0.00,252.00,130528.52,169344.00,38815.65,729784),('19','199','257604','467',517.97,672.00,0.00,340.25,176239.37,228648.00,52408.83,729785),('19','199','257605','467',517.97,672.00,0.00,629.25,325932.76,422856.00,96923.55,729786),('19','199','257606','467',517.97,672.00,0.00,411.00,212885.77,276192.00,63306.46,729787),('19','199','257607','467',517.97,672.00,0.00,259.25,134283.77,174216.00,39932.35,729788),('19','199','257608','467',517.97,672.00,0.00,278.25,144125.22,186984.00,42858.93,729789),('19','199','257609','467',517.97,672.00,0.00,218.25,113047.00,146664.00,33617.12,729790),('19','199','257610','467',517.97,672.00,0.00,201.75,104500.48,135576.00,31075.61,729791),('19','199','257611','467',517.97,672.00,0.00,218.75,113305.98,147000.00,33694.14,729792),('19','199','257612','467',517.97,672.00,0.00,299.50,155132.06,201264.00,46132.08,729793),('19','199','257613','467',517.97,672.00,0.00,315.75,163549.11,212184.00,48635.08,729794),('19','199','257614','467',517.97,638.00,0.00,300.00,155391.07,191400.00,36009.10,729795),('19','199','257615','467',517.97,638.00,0.00,390.25,202137.85,248979.50,46841.82,729796),('19','199','257616','467',517.97,638.00,0.00,224.50,116284.32,143231.00,26946.81,729797),('19','199','257617','467',517.97,638.00,0.00,308.75,159923.30,196982.50,37059.36,729798),('19','199','257618','467',517.97,638.00,0.00,533.25,276207.55,337213.50,61006.11,729799),('19','199','257619','467',517.97,638.00,0.00,948.00,558135.25,598524.00,40389.17,729800),('19','199','257620','467',588.75,638.00,0.00,493.25,290401.05,311093.50,20692.63,729801),('19','199','257621','467',588.75,638.00,0.00,276.75,162936.66,176566.50,13630.00,729802),('19','199','257622','467',588.75,638.00,0.00,273.25,160876.02,174333.50,13457.63,729803),('19','199','257623','467',588.75,638.00,0.00,199.50,117455.68,127281.00,9825.40,729804),('19','199','257624','467',588.75,638.00,0.00,327.50,192815.70,205945.00,13129.43,729805),('19','199','257625','467',588.75,638.00,0.00,441.75,260080.45,281836.50,21756.29,729806),('19','199','257626','467',588.75,638.00,0.00,374.75,220634.16,239090.50,18456.50,729807),('19','199','257627','467',588.75,638.00,0.00,277.00,163083.82,176726.00,13642.29,729808),('19','199','257628','467',588.75,638.00,0.00,570.50,335882.05,363979.00,28097.22,729809),('19','199','257629','467',588.75,638.00,0.00,250.50,147481.95,159819.00,12337.16,729810),('19','199','257630','467',588.75,638.00,0.00,269.00,158373.83,171622.00,13248.30,729811),('19','199','257631','467',588.75,638.00,0.00,218.00,128347.57,139084.00,10736.55,729812),('19','199','257632','467',588.75,638.00,0.00,343.75,202382.91,219312.50,16929.76,729813),('19','199','257633','467',588.75,638.00,0.00,375.00,220781.36,239250.00,18468.80,729814),('19','199','257634','467',588.75,638.00,0.00,278.75,164114.15,177842.50,13728.50,729815),('19','199','257635','467',588.75,638.00,0.00,0.00,0.00,0.00,0.00,729816),('19','199','257636','467',588.75,638.00,0.00,212.25,124962.25,135415.50,10453.36,729817),('19','199','257637','467',588.75,638.00,0.00,301.50,177508.23,192357.00,14848.92,729818),('19','199','257638','467',588.75,638.00,0.00,445.50,262288.28,284229.00,21940.98,729819),('19','199','257639','467',588.75,638.00,0.00,330.50,194581.97,210859.00,16277.19,729820),('19','199','257640','467',588.75,638.00,0.00,533.25,313951.10,340213.50,26262.68,729821),('19','199','257641','467',588.75,638.00,0.00,365.25,215041.06,233029.50,17988.62,729822),('19','199','257642','467',588.75,638.00,0.00,262.50,154546.96,167475.00,12928.19,729823),('19','199','257643','467',588.75,638.00,0.00,353.50,208123.24,225533.00,17409.92,729824),('19','199','257644','467',588.75,638.00,0.00,394.75,232409.17,249450.50,17041.52,729825),('19','199','257645','467',588.75,638.00,0.00,303.25,178538.54,193473.50,14935.14,729826),('19','199','257646','467',588.75,638.00,0.00,430.00,253162.64,274340.00,21177.60,729827),('19','199','257647','467',588.75,638.00,0.00,663.25,390488.62,420753.50,30265.17,729828),('19','199','257648','467',588.75,638.00,0.00,467.75,275387.95,297599.50,22211.79,729829),('19','199','257649','467',588.75,638.00,0.00,543.50,319985.74,342603.00,22617.45,729830),('19','199','257650','467',517.97,692.00,0.00,394.50,204339.24,272719.00,68379.94,729831),('19','199','257651','467',517.97,692.00,0.00,350.25,181419.07,242373.00,60954.12,729832),('19','199','257652','467',517.97,692.00,0.00,415.50,215216.59,287526.00,72309.58,729833),('19','199','257653','467',517.97,692.00,0.00,302.75,156815.48,209503.00,52687.68,729834),('19','199','257654','467',517.97,692.00,0.00,468.25,242539.56,323529.00,80989.70,729835),('19','199','257655','467',517.97,692.00,0.00,415.50,215216.62,287526.00,72309.58,729836),('19','199','257656','467',517.97,692.00,0.00,347.75,180124.14,240643.00,60519.05,729837),('19','199','257657','467',517.97,692.00,0.00,251.50,130269.50,174038.00,43768.63,729838),('19','199','257658','467',517.97,692.00,0.00,312.25,161736.20,216077.00,54340.97,729839),('19','199','257659','467',517.97,692.00,0.00,379.25,196440.17,259141.00,62700.95,729840),('19','199','257660','467',517.97,692.00,0.00,361.75,187375.74,250331.00,62955.48,729841),('19','199','257661','467',517.97,692.00,0.00,408.75,211720.31,282855.00,71134.88,729842),('19','199','257662','467',517.97,692.00,0.00,443.00,229460.81,306556.00,77095.43,729843),('19','199','257663','467',517.97,692.00,0.00,444.50,230237.75,305394.00,75156.45,729844),('19','199','257664','467',517.97,692.00,0.00,308.00,159534.79,213136.00,53601.33,729845),('19','199','257665','467',517.97,730.00,0.00,267.75,138686.51,195457.50,56771.09,729846),('19','199','257666','467',517.97,730.00,0.00,331.00,171448.12,241630.00,70182.02,729847),('19','199','257667','467',517.97,730.00,0.00,226.00,117061.28,164980.00,47918.85,729848),('19','199','257668','467',517.97,730.00,0.00,320.25,165879.95,233782.50,67902.69,729849),('19','199','257669','467',517.97,730.00,0.00,212.50,110068.68,155125.00,45056.45,729850),('19','199','257670','467',517.97,730.00,0.00,321.50,166527.41,234695.00,68167.74,729851),('19','199','257671','467',517.97,730.00,0.00,224.75,116413.80,164067.50,47653.82,729852),('19','199','257672','467',517.97,730.00,0.00,183.25,94918.04,133772.50,38854.56,729853),('19','199','257673','467',517.97,730.00,0.00,353.75,183231.96,258237.50,75005.72,729854),('19','199','257674','467',517.97,730.00,0.00,257.00,133118.34,187610.00,54491.79,729855),('19','199','257675','467',517.97,730.00,0.00,569.50,294984.03,415735.00,120751.25,729856),('19','199','257676','467',517.97,730.00,0.00,284.00,147103.55,207320.00,60216.62,729857),('19','199','257677','467',517.97,730.00,0.00,313.25,162254.19,228672.50,66418.51,729858),('19','199','257678','467',517.97,730.00,0.00,348.75,180642.10,254587.50,73945.58,729859),('19','199','257679','467',517.97,730.00,0.00,210.75,109162.22,153847.50,44685.39,729860),('19','199','257680','467',517.97,730.00,0.00,374.25,193850.36,273202.50,79352.35,729861),('19','199','257681','467',517.97,730.00,0.00,241.50,125089.80,176295.00,51205.32,729862),('19','199','257682','467',517.97,730.00,0.00,358.75,185821.81,261887.50,76065.87,729863),('19','199','257683','467',517.97,730.00,0.00,370.00,191648.97,270100.00,78451.22,729864),('19','199','257684','467',517.97,730.00,0.00,454.00,235158.51,331420.00,96261.78,729865),('19','199','257685','467',517.97,730.00,0.00,432.75,224151.61,315907.50,91756.11,729866),('19','199','257686','467',517.97,730.00,0.00,426.00,220655.31,310980.00,90324.92,729867),('19','199','257687','467',517.97,730.00,0.00,396.25,205245.70,289262.50,84017.02,729868),('19','199','257688','467',517.97,730.00,0.00,238.00,123276.92,173740.00,50463.21,729869),('19','199','257689','467',517.97,730.00,0.00,431.00,223245.19,314630.00,91385.08,729870),('19','199','257690','467',517.97,730.00,0.00,433.00,224281.09,316090.00,91809.13,729871),('19','199','257691','467',517.97,730.00,0.00,380.50,197087.65,277765.00,80677.51,729872),('19','199','257692','467',517.97,730.00,0.00,336.50,174296.94,245645.00,71348.17,729873),('19','199','257693','467',517.97,730.00,0.00,266.25,137909.58,194362.50,56453.07,729874),('19','199','257694','467',517.97,730.00,0.00,97.75,50631.58,71357.50,20725.96,729875),('19','199','257695','467',517.97,730.00,0.00,397.00,205634.15,289810.00,84176.02,729876),('19','199','257696','467',517.97,730.00,0.00,296.25,153448.66,216262.50,62813.97,729877),('19','199','257697','467',517.97,730.00,0.00,285.25,147750.99,207482.50,59731.64,729878),('19','199','257698','467',517.97,730.00,0.00,324.25,167951.83,236702.50,68750.83,729879),('19','199','257699','467',517.97,730.00,0.00,341.00,176627.85,248930.00,72302.34,729880),('19','199','257700','467',517.97,730.00,0.00,282.75,146456.07,206407.50,59951.56,729881),('19','199','257701','467',517.97,730.00,0.00,393.50,203821.29,287255.00,83433.92,729882),('19','199','257702','467',517.97,730.00,0.00,462.75,239690.70,337807.50,98117.00,729883),('19','199','257703','467',517.97,730.00,0.00,318.75,165103.01,232687.50,67584.65,729884),('19','199','257704','467',517.97,730.00,0.00,230.75,119521.64,168447.50,48926.00,729885),('19','199','257705','467',517.97,730.00,0.00,449.00,232568.56,327770.00,95201.53,729886),('19','199','257706','467',517.97,730.00,0.00,317.50,164455.54,231775.00,67319.63,729887),('19','199','257707','467',517.97,730.00,0.00,285.25,147751.01,208232.50,60481.65,729888),('19','199','257708','467',517.97,730.00,0.00,242.75,125737.28,177207.50,51470.36,729889),('19','199','257709','467',517.97,730.00,0.00,354.25,183490.93,258602.50,75111.73,729890),('19','199','257710','467',517.97,730.00,0.00,524.00,271416.36,382520.00,111103.83,729891),('19','199','257711','467',517.97,730.00,0.00,318.00,164714.52,232140.00,67425.64,729892),('19','199','257712','467',517.97,730.00,0.00,518.25,268438.03,378322.50,109884.65,729893),('19','199','257713','467',517.97,730.00,0.00,487.75,252639.97,356057.50,103417.78,729894),('19','199','257714','467',517.97,730.00,0.00,502.50,260280.00,366825.00,106545.23,729895),('19','199','257715','467',517.97,730.00,0.00,271.25,140499.43,198012.50,57513.23,729896),('19','199','257716','467',517.97,730.00,0.00,438.50,227129.95,320105.00,92975.28,729897),('19','199','257717','467',517.97,730.00,0.00,230.00,119133.15,167900.00,48766.98,729898),('19','199','257718','467',517.97,730.00,0.00,310.75,160959.24,226847.50,65888.40,729899),('19','199','257719','467',517.97,730.00,0.00,249.75,133208.56,182317.50,49109.04,729900),('19','199','257720','467',586.64,730.00,0.00,316.75,185818.22,231227.50,45409.28,729901),('19','199','257721','467',586.64,730.00,0.00,236.75,138887.02,172827.50,33940.48,729902),('19','199','257722','467',586.64,730.00,0.00,240.00,140793.60,175200.00,34406.40,729903),('19','199','257723','467',586.64,730.00,0.00,250.00,146660.00,182500.00,35840.00,729904),('19','199','257724','467',586.64,730.00,0.00,330.25,193737.86,241082.50,47344.64,729905),('19','199','257725','467',586.64,730.00,0.00,319.50,187431.48,233235.00,45803.52,729906),('19','199','257726','467',586.64,730.00,0.00,365.00,214123.60,266450.00,52326.40,729907),('19','199','257727','467',586.64,730.00,0.00,341.50,200337.56,249295.00,48957.44,729908),('19','199','257728','467',586.64,730.00,0.00,220.75,129500.78,161147.50,31646.72,729909),('19','199','257729','467',586.64,730.00,0.00,305.00,178925.20,222650.00,43724.80,729910),('19','199','257730','467',586.64,730.00,0.00,460.50,270147.72,335415.00,65267.28,729911),('19','199','257731','467',586.64,730.00,0.00,270.75,158832.78,197647.50,38814.72,729912),('19','199','257732','467',586.64,730.00,0.00,321.00,188311.44,234330.00,46018.56,729913),('19','199','257733','467',586.64,730.00,0.00,287.00,168365.68,209510.00,41144.32,729914),('19','199','257734','467',586.64,730.00,0.00,542.25,318105.54,395842.50,77736.96,729915),('19','199','257735','467',586.64,730.00,0.00,471.75,276747.42,344377.50,67630.08,729916),('19','199','257736','467',586.64,730.00,0.00,471.50,276600.76,344195.00,67594.24,729917),('19','199','257737','467',586.64,730.00,0.00,853.50,500697.24,620055.00,119357.76,729918),('19','199','257738','467',586.64,730.00,0.00,440.00,258121.60,321200.00,63078.40,729919),('19','199','257739','467',586.64,730.00,0.00,351.25,206057.30,256412.50,50355.20,729920),('19','199','257740','467',586.64,730.00,0.00,402.75,236269.26,292732.50,56463.24,729921),('19','199','257741','467',586.64,730.00,0.00,359.00,210603.76,262070.00,51466.24,729922),('19','199','257742','467',586.64,730.00,0.00,518.00,303879.52,378140.00,74260.48,729923),('19','199','257743','467',586.64,730.00,0.00,439.50,257828.28,320085.00,62256.72,729924),('19','199','257744','467',586.64,730.00,0.00,608.25,356823.78,444022.50,87198.72,729925),('19','199','257745','467',586.64,730.00,0.00,567.50,332918.20,412025.00,79106.80,729926),('19','199','257746','467',586.64,730.00,0.00,344.00,201804.16,251120.00,49315.84,729927),('19','199','257747','467',586.64,730.00,0.00,353.75,207523.90,258237.50,50713.60,729928),('19','199','257748','467',586.64,730.00,0.00,237.25,139180.34,173192.50,34012.16,729929),('19','199','257749','467',586.64,730.00,0.00,266.75,156486.22,194727.50,38241.28,729930),('19','199','257750','467',586.64,730.00,0.00,265.25,155606.26,193632.50,38026.24,729931),('19','199','257751','467',586.64,730.00,0.00,461.75,270881.02,337077.50,66196.48,729932),('19','199','257752','467',586.64,730.00,0.00,0.00,0.00,0.00,0.00,729933),('19','199','257753','467',586.64,730.00,0.00,0.00,0.00,0.00,0.00,729934),('19','199','257754','467',586.64,730.00,0.00,520.75,305492.78,380147.50,74654.72,729935),('19','199','257755','467',586.64,730.00,0.00,360.75,211630.38,263347.50,51717.12,729936),('19','199','257756','467',586.64,730.00,0.00,219.75,128914.14,160417.50,31503.36,729937),('19','199','257757','467',586.64,730.00,0.00,405.00,237589.20,294900.00,57310.80,729938),('19','199','257758','467',586.64,730.00,0.00,1068.25,626678.18,778885.00,152206.82,729939),('19','199','257759','467',586.64,730.00,0.00,700.50,410941.32,509865.00,98923.68,729940),('19','199','257760','467',586.64,730.00,0.00,396.50,232602.76,289445.00,56842.24,729941),('19','199','257761','467',586.64,730.00,0.00,538.25,315758.98,392172.50,76413.52,729942),('19','199','257762','467',586.64,730.00,0.00,697.75,409328.06,508232.50,98904.44,729943),('19','199','257763','467',586.64,730.00,0.00,293.25,178172.20,214072.50,35900.39,729944),('19','199','257764','467',631.87,730.00,0.00,750.00,473902.70,546750.00,72847.63,729945),('19','199','257765','467',631.87,730.00,0.00,631.00,398710.08,458380.00,59670.11,729946),('19','199','257766','467',631.87,730.00,0.00,503.75,318304.65,367737.50,49433.09,729947),('19','199','257767','467',631.87,730.00,0.00,298.75,188771.24,218087.50,29316.39,729948),('19','199','257768','467',631.87,730.00,0.00,294.75,186243.77,215167.50,28923.87,729949),('19','199','257769','467',631.87,730.00,0.00,671.75,424458.86,489627.50,65168.98,729950),('19','199','257770','467',631.87,730.00,0.00,281.50,177871.50,205495.00,27623.68,729951),('19','199','257771','467',631.87,730.00,0.00,603.25,381175.74,439622.50,58447.03,729952),('19','199','257772','467',631.87,730.00,0.00,639.75,404238.99,467017.50,62778.80,729953),('19','199','257773','467',631.87,730.00,0.00,622.00,393023.31,453685.00,60662.01,729954),('19','199','257774','467',631.87,730.00,0.00,785.25,496176.12,571920.00,75744.26,729955),('19','199','257775','467',631.87,730.00,0.00,1055.75,667097.04,770322.50,103225.99,729956),('19','199','257776','467',631.87,730.00,0.00,857.00,541512.82,624860.00,83347.58,729957),('19','199','257777','467',631.87,730.00,0.00,586.00,370275.97,426280.00,56004.29,729958),('19','199','257778','467',631.87,730.00,0.00,442.00,279286.66,322660.00,43373.55,729959),('19','199','257779','467',631.87,730.00,0.00,416.50,263173.95,304045.00,40871.20,729960),('19','199','257780','467',631.87,730.00,0.00,447.00,282446.01,325560.00,43114.18,729961),('19','199','257781','467',631.87,730.00,0.00,436.00,275495.45,318280.00,42784.78,729962),('19','199','257782','467',631.87,730.00,0.00,660.50,417350.32,482165.00,64814.99,729963),('19','199','257783','467',631.87,730.00,0.00,348.00,219890.83,252540.00,32649.28,729964),('19','199','257784','467',631.87,730.00,0.00,280.00,176923.68,204400.00,27476.45,729965),('19','199','257785','467',631.87,730.00,0.00,466.50,294767.48,339232.50,44465.23,729966),('19','199','257786','467',631.87,730.00,0.00,338.00,213572.14,246740.00,33168.00,729967),('19','199','257787','467',631.87,730.00,0.00,415.50,262542.07,303315.00,40773.07,729968),('19','199','257788','467',631.87,730.00,0.00,531.50,335839.01,386495.00,50656.17,729969),('19','199','257789','467',631.87,730.00,0.00,404.50,255591.50,295285.00,39693.63,729970),('19','199','257790','467',631.87,730.00,0.00,0.00,0.00,0.00,0.00,729971),('19','199','257791','467',631.87,730.00,0.00,802.25,506917.81,579717.50,72799.87,729972),('19','199','257792','467',631.87,730.00,0.00,689.50,435674.51,499585.00,63910.75,729973),('19','199','257793','467',631.87,730.00,0.00,714.75,451629.20,516517.50,64888.50,729974),('19','199','257794','467',631.87,730.00,0.00,513.25,324307.43,374672.50,50365.35,729975),('19','199','257795','467',631.87,730.00,0.00,811.00,512446.76,589030.00,76583.57,729976),('19','199','257796','467',631.87,730.00,0.00,2045.50,1292490.23,1469965.00,177475.02,729977),('19','199','257797','467',631.87,730.00,0.00,7832.75,4949279.89,5596532.50,647252.88,729978),('19','199','257798','467',631.87,730.00,0.00,0.00,0.00,0.00,0.00,729979),('19','199','257799','467',641.87,750.00,0.00,1491.50,957349.21,1118625.00,161275.97,729980),('19','199','257800','467',641.87,750.00,0.00,1904.50,1222441.53,1428375.00,205933.67,729981),('19','199','257801','467',641.87,750.00,0.00,3429.50,2201293.37,2572125.00,370831.99,729982),('19','199','257802','467',641.87,750.00,0.00,2012.50,1291763.52,1568250.00,276486.73,729983),('19','199','257803','467',641.87,780.00,0.00,1134.75,728362.13,885105.00,156743.13,729984),('19','199','257804','467',641.87,780.00,0.00,370.75,237973.36,289185.00,51211.74,729985),('19','199','257805','467',641.87,780.00,0.00,59.25,38030.82,46215.00,8184.22,729986),('19','199','257806','467',641.87,780.00,0.00,128.00,82159.39,99840.00,17680.67,729987),('19','199','257807','467',641.87,780.00,0.00,50.00,32093.50,39000.00,6906.50,729988),('19','199','257808','467',641.87,780.00,0.00,0.00,0.00,0.00,0.00,729989),('19','199','257809','467',682.00,775.00,0.00,1118.25,762646.50,860893.75,98247.25,729990),('19','199','257810','467',682.00,775.00,0.00,1439.00,981398.00,1108600.00,127202.00,729991),('19','199','257811','467',682.00,775.00,0.00,2340.00,1595880.00,1794970.00,199090.00,729992),('19','199','257812','467',682.00,775.00,0.00,2189.00,1492898.00,1680225.00,187327.00,729993),('19','199','257813','467',682.00,775.00,0.00,2035.75,1388381.50,1564206.25,175824.75,729994),('19','199','257814','467',682.00,775.00,0.00,2179.50,1486419.00,1671412.50,184993.50,729995),('19','199','257815','467',682.00,775.00,0.00,1875.00,1278750.00,1438625.00,159875.00,729996),('19','199','257816','467',682.00,775.00,0.00,2306.25,1572862.50,1770063.75,197201.25,729997),('19','199','257817','467',682.00,775.00,0.00,1545.25,1053860.50,1187258.75,133398.25,729998),('19','199','257818','467',682.00,775.00,0.00,1237.50,843975.00,950062.50,106087.50,729999),('19','199','257819','467',682.00,775.00,0.00,1277.25,871084.50,981868.75,110784.25,730000),('19','199','257820','467',682.00,775.00,0.00,882.00,601524.00,678050.00,76526.00,730001),('19','199','257821','467',682.00,775.00,0.00,1139.25,776968.50,874543.75,97575.25,730002),('19','199','257822','467',682.00,775.00,0.00,1154.75,787539.50,890856.25,103316.75,730003),('19','199','257823','467',682.00,775.00,0.00,1100.50,750541.00,846887.50,96346.50,730004),('19','199','257824','467',682.00,775.00,0.00,686.25,468022.50,528218.75,60196.25,730005),('19','199','257825','467',682.00,775.00,0.00,788.50,537757.00,607587.50,69830.50,730006),('19','199','257826','467',682.00,775.00,0.00,665.50,453871.00,513262.50,59391.50,730007),('19','199','257827','467',682.00,775.00,0.00,666.00,454212.00,512650.00,58438.00,730008),('19','199','257828','467',682.00,775.00,0.00,1157.25,789244.50,890868.75,101624.25,730009),('19','199','257829','467',682.00,775.00,0.00,1252.75,854375.50,964131.25,109755.75,730010),('19','199','257830','467',682.00,775.00,0.00,1034.25,705358.50,796673.75,91315.25,730011),('19','199','257831','467',682.00,775.00,0.00,458.50,312697.00,354837.50,42140.50,730012),('19','199','257832','467',680.00,736.00,0.00,1403.00,954040.00,1006008.00,51968.00,730013),('19','199','257833','467',680.00,736.00,0.00,1380.75,938910.00,991032.00,52122.00,730014),('19','199','257834','467',680.00,736.00,0.00,1378.00,937040.00,986908.00,49868.00,730015),('19','199','257835','467',680.00,736.00,0.00,754.50,513060.00,544112.00,31052.00,730016),('19','199','257836','467',680.00,736.00,0.00,1483.00,1008440.00,1071328.00,62888.00,730017),('19','199','257837','467',680.00,736.00,0.00,878.75,597550.00,638360.00,40810.00,730018),('19','199','257838','467',680.00,736.00,0.00,1419.25,965090.00,1019368.00,54278.00,730019),('19','199','257839','467',680.00,736.00,0.00,1602.75,1089870.00,1147424.00,57554.00,730020),('19','199','257840','467',680.00,736.00,0.00,554.50,377060.00,402512.00,25452.00,730021),('19','199','257841','467',680.00,736.00,0.00,641.00,435880.00,466176.00,30296.00,730022),('19','199','257842','467',680.00,736.00,0.00,390.50,265540.00,283208.00,17668.00,730023),('19','199','257843','467',680.00,736.00,0.00,504.25,342890.00,367124.00,24234.00,730024),('19','199','257844','467',680.00,736.00,0.00,1007.50,685100.00,723320.00,38220.00,730025),('19','199','257845','467',680.00,736.00,0.00,433.00,294440.00,318688.00,24248.00,730026),('19','199','257846','467',680.00,736.00,0.00,456.50,310420.00,333184.00,22764.00,730027),('19','199','257847','467',680.00,736.00,0.00,430.50,292740.00,316848.00,24108.00,730028),('19','199','257848','467',680.00,736.00,0.00,597.25,406130.00,435376.00,29246.00,730029),('19','199','257849','467',680.00,736.00,0.00,295.25,200770.00,217304.00,16534.00,730030),('19','199','257850','467',680.00,736.00,0.00,953.75,648550.00,687050.00,38500.00,730031),('19','199','257851','467',680.00,736.00,0.00,1045.25,710770.00,751104.00,40334.00,730032),('19','199','257852','467',680.00,736.00,0.00,1035.25,703970.00,745144.00,41174.00,730033),('19','199','257853','467',680.00,736.00,0.00,434.50,295460.00,319792.00,24332.00,730034),('19','199','257854','467',680.00,736.00,0.00,523.00,355640.00,382128.00,26488.00,730035),('19','199','257855','467',680.00,736.00,0.00,527.50,358700.00,386840.00,28140.00,730036),('19','199','257856','467',680.00,736.00,0.00,355.00,241400.00,261280.00,19880.00,730037),('19','199','257857','467',680.00,736.00,0.00,489.50,332860.00,360272.00,27412.00,730038),('19','199','257858','467',680.00,736.00,0.00,1341.50,912220.00,971944.00,59724.00,730039),('19','199','257859','467',680.00,736.00,0.00,1259.50,856460.00,918592.00,62132.00,730040),('19','199','257860','467',680.00,736.00,0.00,532.25,361930.00,391736.00,29806.00,730041),('19','199','257861','467',680.00,736.00,0.00,451.50,307020.00,330904.00,23884.00,730042),('19','199','257862','467',680.00,736.00,0.00,372.25,253130.00,273976.00,20846.00,730043),('19','199','257863','467',680.00,736.00,0.00,338.75,230350.00,249320.00,18970.00,730044),('19','199','257864','467',680.00,736.00,0.00,889.00,604520.00,654304.00,49784.00,730045),('19','199','257865','467',680.00,736.00,0.00,1069.50,727260.00,768952.00,41692.00,730046),('19','199','257866','467',680.00,736.00,0.00,1031.00,701080.00,744816.00,43736.00,730047),('19','199','257867','467',680.00,736.00,0.00,581.25,395250.00,427800.00,32550.00,730048),('19','199','257868','467',680.00,736.00,0.00,408.75,277950.00,299440.00,21490.00,730049),('19','199','257869','467',680.00,736.00,0.00,374.00,254320.00,275264.00,20944.00,730050),('19','199','257870','467',680.00,736.00,0.00,739.00,502520.00,541104.00,38584.00,730051),('19','199','257871','467',680.00,736.00,0.00,832.25,565930.00,602736.00,36806.00,730052),('19','199','257872','467',680.00,736.00,0.00,561.00,381480.00,408696.00,27216.00,730053),('19','199','257873','467',680.00,736.00,0.00,963.75,655350.00,696720.00,41370.00,730054),('19','199','257874','467',680.00,736.00,0.00,405.00,275400.00,298080.00,22680.00,730055),('19','199','257875','467',680.00,736.00,0.00,360.00,244800.00,264960.00,20160.00,730056),('19','199','257876','467',680.00,736.00,0.00,427.00,290360.00,314272.00,23912.00,730057),('19','199','257877','467',680.00,736.00,0.00,764.50,519860.00,561412.00,41552.00,730058),('19','199','257878','467',680.00,736.00,0.00,436.50,296820.00,321264.00,24444.00,730059),('19','199','257879','467',680.00,736.00,0.00,480.25,326570.00,353464.00,26894.00,730060),('19','199','257880','467',680.00,736.00,0.00,599.75,407830.00,433016.00,25186.00,730061),('19','199','257881','467',680.00,736.00,0.00,321.00,218280.00,236256.00,17976.00,730062),('19','199','257882','467',680.00,736.00,0.00,208.00,141440.00,153088.00,11648.00,730063),('19','199','257883','467',680.00,736.00,0.00,622.50,423300.00,455360.00,32060.00,730064),('19','199','257884','467',680.00,736.00,0.00,547.25,372130.00,402776.00,30646.00,730065),('19','199','257885','467',680.00,736.00,0.00,904.50,615060.00,655912.00,40852.00,730066),('19','199','257886','467',680.00,736.00,0.00,756.25,514250.00,546800.00,32550.00,730067),('19','199','257887','467',680.00,736.00,0.00,473.75,322150.00,346580.00,24430.00,730068),('19','199','257888','467',680.00,736.00,0.00,415.00,282200.00,305440.00,23240.00,730069),('19','199','257889','467',680.00,736.00,0.00,384.50,261460.00,282992.00,21532.00,730070),('19','199','257890','467',680.00,736.00,0.00,755.75,513910.00,554832.00,40922.00,730071),('19','199','257891','467',680.00,736.00,0.00,623.25,423810.00,458712.00,34902.00,730072),('19','199','257892','467',680.00,736.00,0.00,489.75,333030.00,360456.00,27426.00,730073),('19','199','257893','467',680.00,736.00,0.00,397.75,270470.00,289944.00,19474.00,730074),('19','199','257894','467',680.00,736.00,0.00,0.00,0.00,0.00,0.00,730075),('19','199','257895','467',680.00,736.00,0.00,963.00,654840.00,701768.00,46928.00,730076),('19','199','257896','467',680.00,736.00,0.00,441.25,300050.00,324760.00,24710.00,730077),('19','199','257897','467',680.00,736.00,0.00,406.50,276420.00,299184.00,22764.00,730078),('19','199','257898','467',680.00,736.00,0.00,656.50,446420.00,483184.00,36764.00,730079),('19','199','257899','467',680.00,736.00,0.00,434.25,295290.00,317648.00,22358.00,730080),('19','199','257900','467',680.00,736.00,0.00,729.00,495720.00,536544.00,40824.00,730081),('19','199','257901','467',680.00,736.00,0.00,1125.50,765340.00,814368.00,49028.00,730082),('19','199','257902','467',680.00,736.00,0.00,662.25,450330.00,487416.00,37086.00,730083),('19','199','257903','467',680.00,736.00,0.00,581.75,395590.00,423968.00,28378.00,730084),('19','199','257904','467',680.00,736.00,0.00,386.00,262480.00,284096.00,21616.00,730085),('19','199','257905','467',680.00,736.00,0.00,546.75,371790.00,402408.00,30618.00,730086),('19','199','257906','467',680.00,736.00,0.00,574.25,390490.00,422648.00,32158.00,730087),('19','199','257907','467',680.00,736.00,0.00,486.50,330820.00,358064.00,27244.00,730088),('19','199','257908','467',680.00,736.00,0.00,487.25,331330.00,358616.00,27286.00,730089),('19','199','257909','467',680.00,736.00,0.00,378.50,257380.00,278576.00,21196.00,730090),('19','199','257910','467',680.00,736.00,0.00,464.75,316030.00,342056.00,26026.00,730091),('19','199','257911','467',680.00,736.00,0.00,306.50,208420.00,224184.00,15764.00,730092),('19','199','257912','467',680.00,736.00,0.00,585.50,398140.00,430928.00,32788.00,730093),('19','199','257913','467',680.00,736.00,0.00,159.75,108630.00,117576.00,8946.00,730094),('19','199','257914','467',680.00,736.00,0.00,431.75,293590.00,317768.00,24178.00,730095),('19','199','257915','467',680.00,736.00,0.00,693.50,471580.00,510416.00,38836.00,730096),('19','199','257916','467',680.00,736.00,0.00,164.00,111520.00,120704.00,9184.00,730097),('19','199','257917','467',680.00,736.00,0.00,858.50,583780.00,631856.00,48076.00,730098),('19','199','257918','467',680.00,736.00,0.00,1088.25,740010.00,791152.00,51142.00,730099),('19','199','257919','467',680.00,736.00,0.00,554.25,376890.00,404428.00,27538.00,730100),('19','199','257920','467',680.00,736.00,0.00,738.00,501840.00,536168.00,34328.00,730101),('19','199','257921','467',670.00,736.00,0.00,835.25,559617.50,603544.00,43926.50,730102),('19','199','257922','467',670.00,736.00,0.00,771.25,516737.50,557840.00,41102.50,730103),('19','199','257923','467',670.00,736.00,0.00,873.75,585412.50,640420.00,55007.50,730104),('19','199','257924','467',670.00,736.00,0.00,862.25,577707.50,625936.00,48228.50,730105),('19','199','257925','467',670.00,736.00,0.00,1007.75,675192.50,722804.00,47611.50,730106),('19','199','257926','467',670.00,736.00,0.00,514.50,344715.00,377272.00,32557.00,730107),('19','199','257927','467',670.00,736.00,0.00,488.75,327462.50,357620.00,30157.50,730108),('19','199','257928','467',670.00,736.00,0.00,375.50,251585.00,274968.00,23383.00,730109),('19','199','257929','467',670.00,736.00,0.00,299.50,200665.00,220432.00,19767.00,730110),('19','199','257930','467',670.00,736.00,0.00,420.25,281567.50,308604.00,27036.50,730111),('19','199','257931','467',670.00,736.00,0.00,619.00,414730.00,453624.00,38894.00,730112),('19','199','257932','467',670.00,736.00,0.00,5154.25,3453347.50,3695528.00,242180.50,730113),('19','199','257933','467',670.00,736.00,0.00,483.00,323610.00,354088.00,30478.00,730114),('19','199','257934','467',670.00,736.00,0.00,395.00,264650.00,290720.00,26070.00,730115),('19','199','257935','467',670.00,736.00,0.00,241.25,161637.50,174410.00,12772.50,730116),('19','199','257936','467',670.00,736.00,0.00,1517.00,1016390.00,1096212.00,79822.00,730117);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=426 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('19',425,'199','KATSINA LPG TANKS','LPG TANKS');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=1025 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('19','199','425',1023,1,'467','TANK 1 (60MT)',60000.00,0.00,NULL,'LPG COOKING GAS','713','2021-11-20 08:38:23','2022-11-13 11:15:47','717',5,1),('19','199','425',1024,1,'467','TANK 2 (40MT)',40000.00,0.00,NULL,'COOKING GAS','713','2021-11-20 08:39:34','2023-02-02 09:26:05','717',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'19','199',1024,4420.75,'2023-03-20 17:18:57'),(2,'19','199',1023,1.49,'2023-03-20 17:18:58');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2669478 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2174348,'19','199',NULL,467,'Purchased from Kwale Hydrocarbon Nigeria Limi',0.00,13020000.00,24000.00,0.00,0.00,'2021-12-05 19:22:40','',''),(2179134,'19','199',NULL,467,'Purchased from Gas Terminalling',0.00,4309500.00,7800.00,0.00,0.00,'2021-12-06 10:55:57','',''),(2186985,'19','199',NULL,467,'Reception corrector for bridging 126441',0.00,0.00,0.00,23900.00,0.00,'2021-12-07 05:14:45','',''),(2186986,'19','199','1023',467,'Received from bridging 126441',0.00,0.00,23900.00,0.00,0.00,'2021-12-07 05:14:45','',''),(2188561,'19','199','1023',467,'Retail Sale Id 1291347',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 07:29:31','',''),(2188562,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:29:31','',''),(2188608,'19','199','1023',467,'Retail Sale Id 1291374',1944.00,0.00,0.00,0.00,286.50,'2021-12-07 07:31:44','',''),(2188609,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 07:31:44','',''),(2188648,'19','199','1023',467,'Retail Sale Id 1291403',1944.00,0.00,0.00,0.00,286.50,'2021-12-07 07:33:57','',''),(2188649,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 07:33:57','',''),(2188700,'19','199','1023',467,'Retail Sale Id 1291427',648.00,0.00,0.00,0.00,95.50,'2021-12-07 07:36:29','',''),(2188701,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 07:36:29','',''),(2188718,'19','199','1023',467,'Retail Sale Id 1291437',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 07:37:30','',''),(2188719,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:37:30','',''),(2188752,'19','199','1023',467,'Retail Sale Id 1291452',6480.00,0.00,0.00,0.00,955.00,'2021-12-07 07:38:53','',''),(2188753,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 07:38:53','',''),(2188778,'19','199','1023',467,'Retail Sale Id 1291465',810000.00,0.00,0.00,0.00,803093.75,'2021-12-07 07:40:15','',''),(2188779,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:40:15','',''),(2188832,'19','199','1023',467,'Retail Sale Id 1291486',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 07:43:15','',''),(2188833,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:43:15','',''),(2188886,'19','199','1023',467,'Retail Sale Id 1291537',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 07:45:44','',''),(2188887,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:45:44','',''),(2188912,'19','199','1023',467,'Retail Sale Id 1291561',7776.00,0.00,0.00,0.00,1146.00,'2021-12-07 07:47:49','',''),(2188913,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 07:47:49','',''),(2188944,'19','199','1023',467,'Retail Sale Id 1291578',648.00,0.00,0.00,0.00,95.50,'2021-12-07 07:49:35','',''),(2188945,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 07:49:35','',''),(2189012,'19','199','1023',467,'Retail Sale Id 1291604',1944.00,0.00,0.00,0.00,286.50,'2021-12-07 07:53:15','',''),(2189013,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 07:53:15','',''),(2189014,'19','199','1023',467,'Retail Sale Id 1291604',4050.00,0.00,0.00,0.00,596.88,'2021-12-07 07:53:15','',''),(2189015,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 07:53:15','',''),(2189063,'19','199','1023',467,'Retail Sale Id 1291631',1296.00,0.00,0.00,0.00,191.00,'2021-12-07 07:56:03','',''),(2189064,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 07:56:03','',''),(2189145,'19','199','1023',467,'Retail Sale Id 1291663',1296.00,0.00,0.00,0.00,191.00,'2021-12-07 07:59:49','',''),(2189146,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 07:59:49','',''),(2189171,'19','199','1023',467,'Retail Sale Id 1291679',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 08:02:10','',''),(2189172,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:02:10','',''),(2189264,'19','199','1023',467,'Retail Sale Id 1291730',1944.00,0.00,0.00,0.00,286.50,'2021-12-07 08:07:38','',''),(2189265,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 08:07:38','',''),(2189383,'19','199','1023',467,'Retail Sale Id 1291777',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 08:13:46','',''),(2189384,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:13:46','',''),(2189414,'19','199','1023',467,'Retail Sale Id 1291793',4050.00,0.00,0.00,0.00,596.88,'2021-12-07 08:15:28','',''),(2189415,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 08:15:28','',''),(2189631,'19','199','1023',467,'Retail Sale Id 1291900',4050.00,0.00,0.00,0.00,596.88,'2021-12-07 08:29:02','',''),(2189632,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 08:29:02','',''),(2189651,'19','199','1023',467,'Retail Sale Id 1291910',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 08:30:49','',''),(2189652,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:30:49','',''),(2189703,'19','199','1023',467,'Retail Sale Id 1291939',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 08:34:00','',''),(2189704,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:34:00','',''),(2189768,'19','199','1023',467,'Retail Sale Id 1291959',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 08:36:01','',''),(2189769,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:36:01','',''),(2189880,'19','199','1023',467,'Retail Sale Id 1291994',1944.00,0.00,0.00,0.00,286.50,'2021-12-07 08:41:29','',''),(2189881,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 08:41:29','',''),(2189924,'19','199','1023',467,'Retail Sale Id 1292013',1270.00,0.00,0.00,0.00,165.00,'2021-12-07 08:43:35','',''),(2189925,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 08:43:35','',''),(2189981,'19','199','1023',467,'Retail Sale Id 1292036',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 08:45:47','',''),(2189982,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:45:47','',''),(2190098,'19','199','1023',467,'Retail Sale Id 1292092',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 08:51:33','',''),(2190099,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:51:33','',''),(2190100,'19','199','1023',467,'Retail Sale Id 1292092',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 08:51:33','',''),(2190101,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:51:33','',''),(2190160,'19','199','1023',467,'Retail Sale Id 1292122',3240.00,0.00,0.00,0.00,477.50,'2021-12-07 08:55:05','',''),(2190161,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 08:55:05','',''),(2190202,'19','199','1023',467,'Retail Sale Id 1292143',3240.00,0.00,0.00,0.00,477.50,'2021-12-07 08:57:27','',''),(2190203,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 08:57:27','',''),(2190220,'19','199','1023',467,'Retail Sale Id 1292151',1944.00,0.00,0.00,0.00,286.50,'2021-12-07 08:59:20','',''),(2190221,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 08:59:20','',''),(2190279,'19','199','1023',467,'Retail Sale Id 1292182',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 09:03:45','',''),(2190280,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:03:45','',''),(2190303,'19','199','1023',467,'Retail Sale Id 1292195',1944.00,0.00,0.00,0.00,286.50,'2021-12-07 09:05:40','',''),(2190304,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:05:40','',''),(2190359,'19','199','1023',467,'Retail Sale Id 1292217',1296.00,0.00,0.00,0.00,191.00,'2021-12-07 09:08:03','',''),(2190360,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 09:08:03','',''),(2190397,'19','199','1023',467,'Retail Sale Id 1292236',4050.00,0.00,0.00,0.00,596.88,'2021-12-07 09:09:49','',''),(2190398,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 09:09:49','',''),(2190427,'19','199','1023',467,'Retail Sale Id 1292254',6480.00,0.00,0.00,0.00,955.00,'2021-12-07 09:11:36','',''),(2190428,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 09:11:36','',''),(2190479,'19','199','1023',467,'Retail Sale Id 1292280',4050.00,0.00,0.00,0.00,596.88,'2021-12-07 09:14:24','',''),(2190480,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 09:14:24','',''),(2190515,'19','199','1023',467,'Retail Sale Id 1292302',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 09:16:15','',''),(2190516,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:16:15','',''),(2190557,'19','199','1023',467,'Retail Sale Id 1292320',648.00,0.00,0.00,0.00,95.50,'2021-12-07 09:18:10','',''),(2190558,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 09:18:10','',''),(2190605,'19','199','1023',467,'Retail Sale Id 1292344',1296.00,0.00,0.00,0.00,191.00,'2021-12-07 09:21:02','',''),(2190606,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 09:21:02','',''),(2190706,'19','199','1023',467,'Return of Retail Sale Id 1291465',0.00,810000.00,12.50,0.00,-803093.75,'2021-12-07 09:26:36','',''),(2190743,'19','199','1023',467,'Return of Retail Sale Id 1292013',0.00,1270.00,2.00,0.00,-165.00,'2021-12-07 09:27:57','',''),(2190744,'19','199','1023',467,'Retail Sale Id 1292404',635.00,0.00,0.00,0.00,82.50,'2021-12-07 09:28:06','',''),(2190745,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 09:28:06','',''),(2190746,'19','199','1023',467,'Retail Sale Id 1292404',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 09:28:06','',''),(2190747,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:28:06','',''),(2190748,'19','199','1023',467,'Retail Sale Id 1292404',8424.00,0.00,0.00,0.00,1241.50,'2021-12-07 09:28:06','',''),(2190749,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-07 09:28:06','',''),(2190858,'19','199','1023',467,'Retail Sale Id 1292459',3240.00,0.00,0.00,0.00,477.50,'2021-12-07 09:32:57','',''),(2190859,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 09:32:57','',''),(2190902,'19','199','1023',467,'Retail Sale Id 1292481',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 09:34:59','',''),(2190903,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:34:59','',''),(2190962,'19','199','1023',467,'Retail Sale Id 1292513',1296.00,0.00,0.00,0.00,191.00,'2021-12-07 09:38:56','',''),(2190963,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 09:38:56','',''),(2191024,'19','199','1023',467,'Retail Sale Id 1292546',648.00,0.00,0.00,0.00,95.50,'2021-12-07 09:42:05','',''),(2191025,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 09:42:05','',''),(2191447,'19','199','1023',467,'Retail Sale Id 1292727',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 10:11:32','',''),(2191448,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:11:32','',''),(2191704,'19','199','1023',467,'Retail Sale Id 1292895',4050.00,0.00,0.00,0.00,596.88,'2021-12-07 10:30:52','',''),(2191705,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 10:30:52','',''),(2192642,'19','199','1023',467,'Retail Sale Id 1293382',648.00,0.00,0.00,0.00,95.50,'2021-12-07 11:24:04','',''),(2192643,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 11:24:04','',''),(2192666,'19','199','1023',467,'Retail Sale Id 1293395',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 11:26:11','',''),(2192667,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 11:26:11','',''),(2192686,'19','199','1023',467,'Retail Sale Id 1293408',4050.00,0.00,0.00,0.00,596.88,'2021-12-07 11:28:01','',''),(2192687,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 11:28:01','',''),(2192730,'19','199','1023',467,'Retail Sale Id 1293430',4050.00,0.00,0.00,0.00,596.88,'2021-12-07 11:30:24','',''),(2192731,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 11:30:24','',''),(2192732,'19','199','1023',467,'Retail Sale Id 1293430',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 11:30:24','',''),(2192733,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 11:30:24','',''),(2193603,'19','199','1023',467,'Return of Retail Sale Id 1292404',0.00,635.00,1.00,0.00,-82.50,'2021-12-07 12:42:24','',''),(2193604,'19','199','1023',467,'Return of Retail Sale Id 1292404',0.00,8100.00,12.50,0.00,-1193.75,'2021-12-07 12:42:24','',''),(2193605,'19','199','1023',467,'Return of Retail Sale Id 1292404',0.00,8424.00,13.00,0.00,-1241.50,'2021-12-07 12:42:24','',''),(2193650,'19','199','1023',467,'Retail Sale Id 1293926',1944.00,0.00,0.00,0.00,286.50,'2021-12-07 12:47:18','',''),(2193651,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 12:47:18','',''),(2193652,'19','199','1023',467,'Retail Sale Id 1293926',4050.00,0.00,0.00,0.00,596.88,'2021-12-07 12:47:18','',''),(2193653,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 12:47:18','',''),(2193654,'19','199','1023',467,'Retail Sale Id 1293926',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 12:47:18','',''),(2193655,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 12:47:18','',''),(2193768,'19','199','1023',467,'Return of Retail Sale Id 1293926',0.00,1944.00,3.00,0.00,-286.50,'2021-12-07 12:53:45','',''),(2193769,'19','199','1023',467,'Return of Retail Sale Id 1293926',0.00,4050.00,6.25,0.00,-596.88,'2021-12-07 12:53:45','',''),(2193770,'19','199','1023',467,'Return of Retail Sale Id 1293926',0.00,8100.00,12.50,0.00,-1193.75,'2021-12-07 12:53:45','',''),(2196943,'19','199','1023',467,'Return of Retail Sale Id 1292092',0.00,8100.00,12.50,0.00,-1193.75,'2021-12-07 15:49:52','',''),(2196944,'19','199','1023',467,'Return of Retail Sale Id 1292092',0.00,8100.00,12.50,0.00,-1193.75,'2021-12-07 15:49:52','',''),(2197221,'19','199','1023',467,'Retail Sale Id 1291940',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 16:02:48','',''),(2197222,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:02:48','',''),(2197237,'19','199','1023',467,'Retail Sale Id 1292301',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 16:03:42','',''),(2197238,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:03:42','',''),(2197671,'19','199','1023',467,'Retail Sale Id 1295967',1944.00,0.00,0.00,0.00,286.50,'2021-12-07 16:24:03','',''),(2197672,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:24:03','',''),(2197673,'19','199','1023',467,'Retail Sale Id 1295967',4050.00,0.00,0.00,0.00,596.88,'2021-12-07 16:24:03','',''),(2197674,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 16:24:03','',''),(2197675,'19','199','1023',467,'Retail Sale Id 1295967',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 16:24:03','',''),(2197676,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:24:03','',''),(2197856,'19','199','1023',467,'Retail Sale Id 1296065',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 16:32:39','',''),(2197857,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:32:39','',''),(2198047,'19','199','1023',467,'Retail Sale Id 1296170',1296.00,0.00,0.00,0.00,191.00,'2021-12-07 16:44:37','',''),(2198048,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 16:44:37','',''),(2198102,'19','199','1023',467,'Retail Sale Id 1296196',1296.00,0.00,0.00,0.00,191.00,'2021-12-07 16:47:55','',''),(2198103,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 16:47:56','',''),(2198104,'19','199','1023',467,'Retail Sale Id 1296196',8100.00,0.00,0.00,0.00,1193.75,'2021-12-07 16:47:56','',''),(2198105,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:47:56','',''),(2203257,'19','199','1023',467,'Retail Sale Id 1298362',3240.00,0.00,0.00,0.00,477.50,'2021-12-08 09:44:46','',''),(2203258,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 09:44:46','',''),(2203259,'19','199','1023',467,'Retail Sale Id 1298362',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 09:44:46','',''),(2203260,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:44:46','',''),(2203289,'19','199','1023',467,'Retail Sale Id 1298384',3240.00,0.00,0.00,0.00,477.50,'2021-12-08 09:47:15','',''),(2203290,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 09:47:15','',''),(2203314,'19','199','1023',467,'Retail Sale Id 1298394',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 09:48:44','',''),(2203315,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:48:44','',''),(2203362,'19','199','1023',467,'Retail Sale Id 1298410',1296.00,0.00,0.00,0.00,191.00,'2021-12-08 09:50:54','',''),(2203363,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 09:50:54','',''),(2203386,'19','199','1023',467,'Retail Sale Id 1298425',4050.00,0.00,0.00,0.00,596.88,'2021-12-08 09:53:40','',''),(2203387,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 09:53:40','',''),(2203414,'19','199','1023',467,'Retail Sale Id 1298438',4050.00,0.00,0.00,0.00,596.88,'2021-12-08 09:55:56','',''),(2203415,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 09:55:56','',''),(2203482,'19','199','1023',467,'Retail Sale Id 1298468',4050.00,0.00,0.00,0.00,596.88,'2021-12-08 10:00:55','',''),(2203483,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 10:00:55','',''),(2203484,'19','199','1023',467,'Retail Sale Id 1298468',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 10:00:55','',''),(2203485,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:00:55','',''),(2203576,'19','199','1023',467,'Retail Sale Id 1298509',648.00,0.00,0.00,0.00,95.50,'2021-12-08 10:07:22','',''),(2203577,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 10:07:22','',''),(2203639,'19','199','1023',467,'Retail Sale Id 1298536',5832.00,0.00,0.00,0.00,859.50,'2021-12-08 10:10:47','',''),(2203640,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-08 10:10:47','',''),(2203641,'19','199','1023',467,'Retail Sale Id 1298536',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 10:10:47','',''),(2203642,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:10:47','',''),(2203669,'19','199','1023',467,'Retail Sale Id 1298550',4050.00,0.00,0.00,0.00,596.88,'2021-12-08 10:12:57','',''),(2203670,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 10:12:57','',''),(2203697,'19','199','1023',467,'Retail Sale Id 1298564',4050.00,0.00,0.00,0.00,596.88,'2021-12-08 10:14:30','',''),(2203698,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 10:14:30','',''),(2203729,'19','199','1023',467,'Retail Sale Id 1298582',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 10:16:06','',''),(2203730,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:16:07','',''),(2203785,'19','199','1023',467,'Retail Sale Id 1298602',4050.00,0.00,0.00,0.00,596.88,'2021-12-08 10:20:03','',''),(2203786,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 10:20:03','',''),(2203807,'19','199','1023',467,'Retail Sale Id 1298620',3888.00,0.00,0.00,0.00,573.00,'2021-12-08 10:21:51','',''),(2203808,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 10:21:51','',''),(2203850,'19','199','1023',467,'Retail Sale Id 1298641',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 10:24:03','',''),(2203851,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:24:03','',''),(2203953,'19','199','1023',467,'Retail Sale Id 1298682',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 10:30:09','',''),(2203954,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:30:09','',''),(2203987,'19','199','1023',467,'Retail Sale Id 1298696',2592.00,0.00,0.00,0.00,382.00,'2021-12-08 10:31:27','',''),(2203988,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 10:31:27','',''),(2204003,'19','199','1023',467,'Retail Sale Id 1298704',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 10:33:15','',''),(2204004,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:33:15','',''),(2204041,'19','199','1023',467,'Retail Sale Id 1298723',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 10:35:00','',''),(2204042,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:35:00','',''),(2204055,'19','199','1023',467,'Retail Sale Id 1298729',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 10:36:25','',''),(2204056,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:36:25','',''),(2204060,'19','199','1023',467,'Retail Sale Id 1298732',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 10:37:16','',''),(2204061,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:37:16','',''),(2204066,'19','199','1023',467,'Retail Sale Id 1298735',4050.00,0.00,0.00,0.00,596.88,'2021-12-08 10:38:03','',''),(2204067,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 10:38:03','',''),(2204172,'19','199','1023',467,'Retail Sale Id 1298791',3888.00,0.00,0.00,0.00,573.00,'2021-12-08 10:47:48','',''),(2204173,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 10:47:48','',''),(2204180,'19','199','1023',467,'Retail Sale Id 1298795',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 10:48:33','',''),(2204181,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:48:33','',''),(2204190,'19','199','1023',467,'Retail Sale Id 1298799',7776.00,0.00,0.00,0.00,1146.00,'2021-12-08 10:49:29','',''),(2204191,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-08 10:49:29','',''),(2204202,'19','199','1023',467,'Retail Sale Id 1298808',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 10:50:34','',''),(2204203,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:50:34','',''),(2204204,'19','199','1023',467,'Retail Sale Id 1298808',4050.00,0.00,0.00,0.00,596.88,'2021-12-08 10:50:34','',''),(2204205,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 10:50:34','',''),(2204214,'19','199','1023',467,'Retail Sale Id 1298813',648.00,0.00,0.00,0.00,95.50,'2021-12-08 10:51:20','',''),(2204215,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 10:51:20','',''),(2204226,'19','199','1023',467,'Retail Sale Id 1298818',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 10:52:15','',''),(2204227,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:52:15','',''),(2204232,'19','199','1023',467,'Retail Sale Id 1298821',3240.00,0.00,0.00,0.00,477.50,'2021-12-08 10:53:08','',''),(2204233,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 10:53:08','',''),(2204242,'19','199','1023',467,'Retail Sale Id 1298826',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 10:53:57','',''),(2204243,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:53:57','',''),(2204270,'19','199','1023',467,'Retail Sale Id 1298832',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 10:55:54','',''),(2204271,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:55:55','',''),(2204282,'19','199','1023',467,'Retail Sale Id 1298846',1296.00,0.00,0.00,0.00,191.00,'2021-12-08 10:56:44','',''),(2204283,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 10:56:44','',''),(2204292,'19','199','1023',467,'Retail Sale Id 1298851',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 10:57:31','',''),(2204293,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:57:31','',''),(2204306,'19','199','1023',467,'Retail Sale Id 1298859',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 10:58:25','',''),(2204307,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:58:25','',''),(2204337,'19','199','1023',467,'Retail Sale Id 1298873',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 11:00:59','',''),(2204338,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:00:59','',''),(2204349,'19','199','1023',467,'Retail Sale Id 1298879',7776.00,0.00,0.00,0.00,1146.00,'2021-12-08 11:02:30','',''),(2204350,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-08 11:02:30','',''),(2204360,'19','199','1023',467,'Retail Sale Id 1298883',2592.00,0.00,0.00,0.00,382.00,'2021-12-08 11:03:16','',''),(2204361,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 11:03:16','',''),(2204374,'19','199','1023',467,'Retail Sale Id 1298892',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 11:04:26','',''),(2204375,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:04:26','',''),(2204382,'19','199','1023',467,'Retail Sale Id 1298896',3888.00,0.00,0.00,0.00,573.00,'2021-12-08 11:05:12','',''),(2204383,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:05:12','',''),(2204396,'19','199','1023',467,'Retail Sale Id 1298902',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 11:06:04','',''),(2204397,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:06:05','',''),(2204406,'19','199','1023',467,'Retail Sale Id 1298908',3888.00,0.00,0.00,0.00,573.00,'2021-12-08 11:07:02','',''),(2204407,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:07:02','',''),(2204430,'19','199','1023',467,'Retail Sale Id 1298920',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 11:07:55','',''),(2204431,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:07:55','',''),(2204470,'19','199','1023',467,'Retail Sale Id 1298947',3240.00,0.00,0.00,0.00,477.50,'2021-12-08 11:10:09','',''),(2204471,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 11:10:09','',''),(2204494,'19','199','1023',467,'Retail Sale Id 1298957',1296.00,0.00,0.00,0.00,191.00,'2021-12-08 11:11:08','',''),(2204495,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 11:11:08','',''),(2204502,'19','199','1023',467,'Retail Sale Id 1298962',3888.00,0.00,0.00,0.00,573.00,'2021-12-08 11:12:03','',''),(2204503,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:12:03','',''),(2204514,'19','199','1023',467,'Retail Sale Id 1298967',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 11:12:54','',''),(2204515,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:12:54','',''),(2204528,'19','199','1023',467,'Retail Sale Id 1298976',3888.00,0.00,0.00,0.00,573.00,'2021-12-08 11:13:51','',''),(2204529,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:13:51','',''),(2204548,'19','199','1023',467,'Retail Sale Id 1298986',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 11:15:13','',''),(2204549,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:15:13','',''),(2204556,'19','199','1023',467,'Retail Sale Id 1298989',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 11:16:08','',''),(2204557,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:16:08','',''),(2204632,'19','199','1023',467,'Retail Sale Id 1299026',5832.00,0.00,0.00,0.00,859.50,'2021-12-08 11:21:35','',''),(2204633,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-08 11:21:35','',''),(2204650,'19','199','1023',467,'Retail Sale Id 1299037',2592.00,0.00,0.00,0.00,382.00,'2021-12-08 11:22:49','',''),(2204651,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 11:22:49','',''),(2204664,'19','199','1023',467,'Retail Sale Id 1299043',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 11:23:48','',''),(2204665,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:23:48','',''),(2204690,'19','199','1023',467,'Retail Sale Id 1299057',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 11:25:58','',''),(2204691,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:25:58','',''),(2204698,'19','199','1023',467,'Retail Sale Id 1299062',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 11:26:57','',''),(2204699,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:26:57','',''),(2204714,'19','199','1023',467,'Retail Sale Id 1299069',3888.00,0.00,0.00,0.00,573.00,'2021-12-08 11:27:55','',''),(2204715,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:27:55','',''),(2204730,'19','199','1023',467,'Retail Sale Id 1299075',3888.00,0.00,0.00,0.00,573.00,'2021-12-08 11:28:57','',''),(2204731,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:28:57','',''),(2204760,'19','199','1023',467,'Retail Sale Id 1299094',8748.00,0.00,0.00,0.00,1289.25,'2021-12-08 11:31:38','',''),(2204761,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,13.50,0.00,'2021-12-08 11:31:38','',''),(2204780,'19','199','1023',467,'Retail Sale Id 1299105',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 11:32:57','',''),(2204781,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:32:57','',''),(2204802,'19','199','1023',467,'Retail Sale Id 1299117',3240.00,0.00,0.00,0.00,477.50,'2021-12-08 11:34:26','',''),(2204803,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 11:34:26','',''),(2204828,'19','199','1023',467,'Retail Sale Id 1299129',3888.00,0.00,0.00,0.00,573.00,'2021-12-08 11:35:39','',''),(2204829,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:35:39','',''),(2204888,'19','199','1023',467,'Retail Sale Id 1299157',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 11:38:56','',''),(2204889,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:38:56','',''),(2204948,'19','199','1023',467,'Retail Sale Id 1299192',3888.00,0.00,0.00,0.00,573.00,'2021-12-08 11:41:43','',''),(2204949,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:41:43','',''),(2204972,'19','199','1023',467,'Retail Sale Id 1299202',3888.00,0.00,0.00,0.00,573.00,'2021-12-08 11:42:52','',''),(2204973,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:42:52','',''),(2204992,'19','199','1023',467,'Retail Sale Id 1299213',2592.00,0.00,0.00,0.00,382.00,'2021-12-08 11:44:01','',''),(2204993,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 11:44:01','',''),(2205020,'19','199','1023',467,'Retail Sale Id 1299229',7776.00,0.00,0.00,0.00,1146.00,'2021-12-08 11:46:10','',''),(2205021,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-08 11:46:10','',''),(2205036,'19','199','1023',467,'Retail Sale Id 1299237',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 11:47:21','',''),(2205037,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:47:21','',''),(2205054,'19','199','1023',467,'Retail Sale Id 1299241',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 11:49:17','',''),(2205055,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:49:17','',''),(2205056,'19','199','1023',467,'Retail Sale Id 1299241',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 11:49:17','',''),(2205057,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:49:17','',''),(2205076,'19','199','1023',467,'Retail Sale Id 1299251',3888.00,0.00,0.00,0.00,573.00,'2021-12-08 11:51:14','',''),(2205077,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:51:14','',''),(2205130,'19','199','1023',467,'Retail Sale Id 1299279',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 11:55:19','',''),(2205131,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:55:19','',''),(2205188,'19','199','1023',467,'Retail Sale Id 1299309',3888.00,0.00,0.00,0.00,573.00,'2021-12-08 11:59:50','',''),(2205189,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:59:50','',''),(2205202,'19','199','1023',467,'Retail Sale Id 1299317',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 12:00:48','',''),(2205203,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:00:48','',''),(2205224,'19','199','1023',467,'Retail Sale Id 1299324',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 12:02:19','',''),(2205225,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 12:02:19','',''),(2205325,'19','199','1023',467,'Retail Sale Id 1299361',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 12:09:43','',''),(2205326,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:09:43','',''),(2205433,'19','199','1023',467,'Retail Sale Id 1299410',3888.00,0.00,0.00,0.00,573.00,'2021-12-08 12:17:49','',''),(2205434,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 12:17:49','',''),(2205568,'19','199','1023',467,'Retail Sale Id 1299483',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 12:30:05','',''),(2205569,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:30:05','',''),(2205621,'19','199','1023',467,'Retail Sale Id 1299503',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 12:33:42','',''),(2205622,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 12:33:42','',''),(2205766,'19','199','1023',467,'Retail Sale Id 1299572',4050.00,0.00,0.00,0.00,596.88,'2021-12-08 12:43:22','',''),(2205767,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 12:43:22','',''),(2205905,'19','199','1023',467,'Retail Sale Id 1299625',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 12:49:58','',''),(2205906,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:49:58','',''),(2206052,'19','199','1023',467,'Retail Sale Id 1299686',3240.00,0.00,0.00,0.00,477.50,'2021-12-08 13:01:00','',''),(2206053,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 13:01:00','',''),(2206144,'19','199','1023',467,'Retail Sale Id 1299729',3240.00,0.00,0.00,0.00,477.50,'2021-12-08 13:07:26','',''),(2206145,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 13:07:26','',''),(2206162,'19','199','1023',467,'Retail Sale Id 1299741',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 13:09:00','',''),(2206163,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:09:00','',''),(2206273,'19','199','1023',467,'Retail Sale Id 1299789',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 13:15:14','',''),(2206274,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:15:14','',''),(2206459,'19','199','1023',467,'Retail Sale Id 1299886',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 13:29:12','',''),(2206460,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:29:12','',''),(2206461,'19','199','1023',467,'Retail Sale Id 1299886',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 13:29:12','',''),(2206462,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:29:12','',''),(2207101,'19','199','1023',467,'Retail Sale Id 1300137',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 14:05:17','',''),(2207102,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:05:17','',''),(2207343,'19','199','1023',467,'Retail Sale Id 1300264',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 14:20:42','',''),(2207344,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:20:42','',''),(2207395,'19','199','1023',467,'Retail Sale Id 1300290',3240.00,0.00,0.00,0.00,477.50,'2021-12-08 14:23:52','',''),(2207396,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 14:23:52','',''),(2207512,'19','199','1023',467,'Retail Sale Id 1300338',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 14:29:15','',''),(2207513,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:29:15','',''),(2207514,'19','199','1023',467,'Retail Sale Id 1300338',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 14:29:15','',''),(2207515,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:29:15','',''),(2207768,'19','199','1023',467,'Retail Sale Id 1300449',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 14:41:17','',''),(2207769,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:41:17','',''),(2207847,'19','199','1023',467,'Retail Sale Id 1300488',3888.00,0.00,0.00,0.00,573.00,'2021-12-08 14:45:25','',''),(2207848,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 14:45:25','',''),(2207909,'19','199','1023',467,'Retail Sale Id 1300530',8100.00,0.00,0.00,0.00,1193.75,'2021-12-08 14:49:03','',''),(2207910,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:49:03','',''),(2208470,'19','199','1023',467,'Retail Sale Id 1300779',7776.00,0.00,0.00,0.00,1146.00,'2021-12-08 15:22:48','',''),(2208471,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-08 15:22:48','',''),(2208548,'19','199','1023',467,'Retail Sale Id 1300822',3888.00,0.00,0.00,0.00,573.00,'2021-12-08 15:26:58','',''),(2208549,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:26:58','',''),(2208592,'19','199','1023',467,'Retail Sale Id 1300845',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 15:29:30','',''),(2208593,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 15:29:30','',''),(2208737,'19','199','1023',467,'Retail Sale Id 1300924',3888.00,0.00,0.00,0.00,573.00,'2021-12-08 15:36:33','',''),(2208738,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:36:33','',''),(2209107,'19','199','1023',467,'Retail Sale Id 1301101',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 15:57:02','',''),(2209108,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 15:57:02','',''),(2209161,'19','199','1023',467,'Retail Sale Id 1301134',1944.00,0.00,0.00,0.00,286.50,'2021-12-08 15:59:48','',''),(2209162,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 15:59:48','',''),(2214044,'19','199','1023',467,'Retail Sale Id 1303320',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 08:00:03','',''),(2214045,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 08:00:03','',''),(2214120,'19','199','1023',467,'Retail Sale Id 1303357',8100.00,0.00,0.00,0.00,1193.75,'2021-12-09 08:04:36','',''),(2214121,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:04:36','',''),(2214158,'19','199','1023',467,'Retail Sale Id 1303380',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 08:06:42','',''),(2214159,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 08:06:42','',''),(2214324,'19','199','1023',467,'Retail Sale Id 1303470',3888.00,0.00,0.00,0.00,573.00,'2021-12-09 08:15:13','',''),(2214325,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 08:15:13','',''),(2214340,'19','199',NULL,467,'Reception corrector for bridging 126683',0.00,0.00,0.00,7800.00,0.00,'2021-12-09 08:15:58','',''),(2214341,'19','199','1023',467,'Received from bridging 126683',0.00,0.00,7800.00,0.00,0.00,'2021-12-09 08:15:58','',''),(2214418,'19','199','1023',467,'Retail Sale Id 1303510',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 08:19:24','',''),(2214419,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 08:19:24','',''),(2214714,'19','199','1023',467,'Retail Sale Id 1303620',8100.00,0.00,0.00,0.00,1193.75,'2021-12-09 08:32:05','',''),(2214715,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:32:05','',''),(2215182,'19','199','1023',467,'Retail Sale Id 1303846',8100.00,0.00,0.00,0.00,1193.75,'2021-12-09 08:57:24','',''),(2215183,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:57:24','',''),(2215305,'19','199','1023',467,'Retail Sale Id 1303917',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 09:04:09','',''),(2215306,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 09:04:09','',''),(2215336,'19','199','1023',467,'Retail Sale Id 1303930',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 09:06:08','',''),(2215337,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 09:06:08','',''),(2215861,'19','199','1023',467,'Retail Sale Id 1304185',31500.00,0.00,0.00,0.00,3875.00,'2021-12-09 09:34:53','',''),(2215862,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 09:34:53','',''),(2216635,'19','199','1023',467,'Retail Sale Id 1304528',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 10:15:20','',''),(2216636,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 10:15:20','',''),(2216721,'19','199','1023',467,'Retail Sale Id 1304576',8100.00,0.00,0.00,0.00,1193.75,'2021-12-09 10:21:41','',''),(2216722,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:21:41','',''),(2217056,'19','199','1023',467,'Retail Sale Id 1304754',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 10:42:50','',''),(2217057,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 10:42:50','',''),(2217198,'19','199','1023',467,'Retail Sale Id 1304826',3888.00,0.00,0.00,0.00,573.00,'2021-12-09 10:51:20','',''),(2217199,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 10:51:20','',''),(2217254,'19','199','1023',467,'Retail Sale Id 1304854',3240.00,0.00,0.00,0.00,477.50,'2021-12-09 10:55:38','',''),(2217255,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 10:55:38','',''),(2217256,'19','199','1023',467,'Retail Sale Id 1304854',8100.00,0.00,0.00,0.00,1193.75,'2021-12-09 10:55:38','',''),(2217257,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:55:38','',''),(2217586,'19','199','1023',467,'Retail Sale Id 1305022',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 11:19:19','',''),(2217587,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 11:19:19','',''),(2217741,'19','199','1023',467,'Retail Sale Id 1305090',3888.00,0.00,0.00,0.00,573.00,'2021-12-09 11:27:45','',''),(2217742,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 11:27:45','',''),(2217772,'19','199','1023',467,'Retail Sale Id 1305103',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 11:29:30','',''),(2217773,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 11:29:30','',''),(2217815,'19','199','1023',467,'Retail Sale Id 1305127',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 11:31:19','',''),(2217816,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 11:31:19','',''),(2217976,'19','199','1023',467,'Retail Sale Id 1305202',8100.00,0.00,0.00,0.00,1193.75,'2021-12-09 11:42:43','',''),(2217977,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:42:43','',''),(2218016,'19','199','1023',467,'Retail Sale Id 1305223',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 11:45:14','',''),(2218017,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 11:45:14','',''),(2218018,'19','199','1023',467,'Retail Sale Id 1305223',8100.00,0.00,0.00,0.00,1193.75,'2021-12-09 11:45:14','',''),(2218019,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:45:14','',''),(2218092,'19','199','1023',467,'Retail Sale Id 1305250',8100.00,0.00,0.00,0.00,1193.75,'2021-12-09 11:49:00','',''),(2218093,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:49:00','',''),(2218148,'19','199','1023',467,'Return of Retail Sale Id 1305223',0.00,1944.00,3.00,0.00,-286.50,'2021-12-09 11:52:08','',''),(2218149,'19','199','1023',467,'Return of Retail Sale Id 1305223',0.00,8100.00,12.50,0.00,-1193.75,'2021-12-09 11:52:08','',''),(2218200,'19','199','1023',467,'Retail Sale Id 1305318',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 11:55:44','',''),(2218201,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 11:55:44','',''),(2218202,'19','199','1023',467,'Retail Sale Id 1305318',8100.00,0.00,0.00,0.00,1193.75,'2021-12-09 11:55:44','',''),(2218203,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:55:44','',''),(2218518,'19','199','1023',467,'Retail Sale Id 1305475',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 12:16:23','',''),(2218519,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 12:16:23','',''),(2218558,'19','199','1023',467,'Retail Sale Id 1305495',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 12:19:10','',''),(2218559,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 12:19:10','',''),(2218714,'19','199','1023',467,'Retail Sale Id 1305588',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 12:29:39','',''),(2218715,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 12:29:39','',''),(2218816,'19','199','1023',467,'Retail Sale Id 1305645',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 12:36:20','',''),(2218817,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 12:36:20','',''),(2219101,'19','199','1023',467,'Retail Sale Id 1305777',6480.00,0.00,0.00,0.00,955.00,'2021-12-09 12:50:45','',''),(2219102,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 12:50:45','',''),(2219166,'19','199','1023',467,'Retail Sale Id 1305820',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 12:55:24','',''),(2219167,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 12:55:24','',''),(2219331,'19','199','1023',467,'Retail Sale Id 1305896',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 13:05:13','',''),(2219332,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 13:05:13','',''),(2219395,'19','199','1023',467,'Retail Sale Id 1305938',8100.00,0.00,0.00,0.00,1193.75,'2021-12-09 13:09:49','',''),(2219396,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 13:09:49','',''),(2219534,'19','199','1023',467,'Retail Sale Id 1305992',3888.00,0.00,0.00,0.00,573.00,'2021-12-09 13:19:11','',''),(2219535,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 13:19:11','',''),(2219648,'19','199','1023',467,'Retail Sale Id 1306039',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 13:27:21','',''),(2219649,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 13:27:21','',''),(2220096,'19','199','1023',467,'Retail Sale Id 1306196',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 13:49:31','',''),(2220097,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 13:49:31','',''),(2220098,'19','199','1023',467,'Retail Sale Id 1306196',4050.00,0.00,0.00,0.00,596.88,'2021-12-09 13:49:31','',''),(2220099,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 13:49:31','',''),(2220110,'19','199','1023',467,'Retail Sale Id 1306211',8100.00,0.00,0.00,0.00,1193.75,'2021-12-09 13:50:45','',''),(2220111,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 13:50:45','',''),(2220476,'19','199','1023',467,'Retail Sale Id 1306413',4050.00,0.00,0.00,0.00,596.88,'2021-12-09 14:14:30','',''),(2220477,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 14:14:30','',''),(2220494,'19','199','1023',467,'Retail Sale Id 1306422',8100.00,0.00,0.00,0.00,1193.75,'2021-12-09 14:15:42','',''),(2220495,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:15:42','',''),(2220893,'19','199','1023',467,'Retail Sale Id 1306603',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 14:35:22','',''),(2220894,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 14:35:22','',''),(2220929,'19','199','1023',467,'Retail Sale Id 1306621',8100.00,0.00,0.00,0.00,1193.75,'2021-12-09 14:36:32','',''),(2220930,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:36:32','',''),(2221424,'19','199','1023',467,'Retail Sale Id 1306817',3888.00,0.00,0.00,0.00,573.00,'2021-12-09 14:55:48','',''),(2221425,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 14:55:48','',''),(2222208,'19','199','1023',467,'Retail Sale Id 1307222',4050.00,0.00,0.00,0.00,596.88,'2021-12-09 15:36:20','',''),(2222209,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 15:36:20','',''),(2222310,'19','199','1023',467,'Retail Sale Id 1307273',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 15:41:03','',''),(2222311,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:41:03','',''),(2222354,'19','199','1023',467,'Retail Sale Id 1307296',3888.00,0.00,0.00,0.00,573.00,'2021-12-09 15:44:12','',''),(2222355,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 15:44:12','',''),(2222356,'19','199','1023',467,'Retail Sale Id 1307296',3888.00,0.00,0.00,0.00,573.00,'2021-12-09 15:44:12','',''),(2222357,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 15:44:12','',''),(2222521,'19','199','1023',467,'Retail Sale Id 1307375',8100.00,0.00,0.00,0.00,1193.75,'2021-12-09 15:53:46','',''),(2222522,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:53:46','',''),(2222668,'19','199','1023',467,'Retail Sale Id 1307448',3888.00,0.00,0.00,0.00,573.00,'2021-12-09 16:01:21','',''),(2222669,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 16:01:21','',''),(2222761,'19','199','1023',467,'Retail Sale Id 1307492',7776.00,0.00,0.00,0.00,1146.00,'2021-12-09 16:06:16','',''),(2222762,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-09 16:06:16','',''),(2222833,'19','199','1023',467,'Retail Sale Id 1307532',8100.00,0.00,0.00,0.00,1193.75,'2021-12-09 16:09:32','',''),(2222834,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:09:32','',''),(2222865,'19','199','1023',467,'Retail Sale Id 1307549',1944.00,0.00,0.00,0.00,286.50,'2021-12-09 16:11:12','',''),(2222866,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:11:12','',''),(2222909,'19','199','1023',467,'Retail Sale Id 1307568',1620.00,0.00,0.00,0.00,238.75,'2021-12-09 16:13:56','',''),(2222910,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-09 16:13:56','',''),(2222911,'19','199','1023',467,'Retail Sale Id 1307568',1620.00,0.00,0.00,0.00,238.75,'2021-12-09 16:13:56','',''),(2222912,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-09 16:13:56','',''),(2222913,'19','199','1023',467,'Retail Sale Id 1307568',6480.00,0.00,0.00,0.00,955.00,'2021-12-09 16:13:56','',''),(2222914,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 16:13:56','',''),(2222957,'19','199','1023',467,'Retail Sale Id 1307594',3888.00,0.00,0.00,0.00,573.00,'2021-12-09 16:16:15','',''),(2222958,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 16:16:15','',''),(2223045,'19','199','1023',467,'Retail Sale Id 1307634',4050.00,0.00,0.00,0.00,596.88,'2021-12-09 16:21:02','',''),(2223046,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 16:21:02','',''),(2223091,'19','199','1023',467,'Retail Sale Id 1307658',8100.00,0.00,0.00,0.00,1193.75,'2021-12-09 16:24:12','',''),(2223092,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:24:12','',''),(2223296,'19','199','1023',467,'Retail Sale Id 1307752',8100.00,0.00,0.00,0.00,1193.75,'2021-12-09 16:34:36','',''),(2223297,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:34:36','',''),(2227589,'19','199','1023',467,'Retail Sale Id 1309504',8100.00,0.00,0.00,0.00,1193.75,'2021-12-10 08:33:46','',''),(2227590,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:33:46','',''),(2227629,'19','199','1023',467,'Retail Sale Id 1309524',3888.00,0.00,0.00,0.00,573.00,'2021-12-10 08:36:00','',''),(2227630,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 08:36:00','',''),(2227653,'19','199','1023',467,'Retail Sale Id 1309540',1944.00,0.00,0.00,0.00,286.50,'2021-12-10 08:37:08','',''),(2227654,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:37:08','',''),(2227702,'19','199','1023',467,'Retail Sale Id 1309557',8100.00,0.00,0.00,0.00,1193.75,'2021-12-10 08:40:33','',''),(2227703,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:40:33','',''),(2227776,'19','199','1023',467,'Retail Sale Id 1309598',1944.00,0.00,0.00,0.00,286.50,'2021-12-10 08:44:09','',''),(2227777,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:44:09','',''),(2227832,'19','199','1023',467,'Retail Sale Id 1309625',8100.00,0.00,0.00,0.00,1193.75,'2021-12-10 08:46:27','',''),(2227833,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:46:27','',''),(2228134,'19','199','1023',467,'Retail Sale Id 1309763',8100.00,0.00,0.00,0.00,1193.75,'2021-12-10 08:58:58','',''),(2228135,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:58:58','',''),(2228294,'19','199','1023',467,'Retail Sale Id 1309840',31500.00,0.00,0.00,0.00,3875.00,'2021-12-10 09:06:15','',''),(2228295,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 09:06:15','',''),(2228296,'19','199','1023',467,'Retail Sale Id 1309840',31500.00,0.00,0.00,0.00,3875.00,'2021-12-10 09:06:15','',''),(2228297,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 09:06:15','',''),(2228447,'19','199','1023',467,'Retail Sale Id 1309910',8100.00,0.00,0.00,0.00,1193.75,'2021-12-10 09:15:06','',''),(2228448,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 09:15:06','',''),(2228449,'19','199','1023',467,'Retail Sale Id 1309910',8100.00,0.00,0.00,0.00,1193.75,'2021-12-10 09:15:06','',''),(2228450,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 09:15:06','',''),(2229045,'19','199','1023',467,'Retail Sale Id 1310196',3888.00,0.00,0.00,0.00,573.00,'2021-12-10 09:49:48','',''),(2229046,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 09:49:48','',''),(2229373,'19','199','1023',467,'Retail Sale Id 1310349',8100.00,0.00,0.00,0.00,1193.75,'2021-12-10 10:09:29','',''),(2229374,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 10:09:29','',''),(2229587,'19','199','1023',467,'Retail Sale Id 1310448',4050.00,0.00,0.00,0.00,596.88,'2021-12-10 10:20:31','',''),(2229588,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-10 10:20:31','',''),(2230027,'19','199','1023',467,'Retail Sale Id 1310650',1944.00,0.00,0.00,0.00,286.50,'2021-12-10 10:46:00','',''),(2230028,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 10:46:00','',''),(2230087,'19','199','1023',467,'Retail Sale Id 1310673',3888.00,0.00,0.00,0.00,573.00,'2021-12-10 10:48:57','',''),(2230088,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:48:57','',''),(2230277,'19','199','1023',467,'Retail Sale Id 1310762',1944.00,0.00,0.00,0.00,286.50,'2021-12-10 10:59:39','',''),(2230278,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 10:59:39','',''),(2230465,'19','199','1023',467,'Retail Sale Id 1310835',3888.00,0.00,0.00,0.00,573.00,'2021-12-10 11:08:56','',''),(2230466,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 11:08:56','',''),(2230481,'19','199','1023',467,'Retail Sale Id 1310841',8100.00,0.00,0.00,0.00,1193.75,'2021-12-10 11:09:53','',''),(2230482,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 11:09:53','',''),(2230733,'19','199','1023',467,'Retail Sale Id 1310944',1944.00,0.00,0.00,0.00,286.50,'2021-12-10 11:25:15','',''),(2230734,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 11:25:15','',''),(2232160,'19','199','1023',467,'Retail Sale Id 1311669',1944.00,0.00,0.00,0.00,286.50,'2021-12-10 13:12:41','',''),(2232161,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 13:12:41','',''),(2232389,'19','199','1023',467,'Retail Sale Id 1311770',1944.00,0.00,0.00,0.00,286.50,'2021-12-10 13:26:51','',''),(2232390,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 13:26:51','',''),(2232825,'19','199','1023',467,'Retail Sale Id 1311969',8100.00,0.00,0.00,0.00,1193.75,'2021-12-10 13:48:24','',''),(2232826,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:48:24','',''),(2232893,'19','199','1023',467,'Retail Sale Id 1312001',1944.00,0.00,0.00,0.00,286.50,'2021-12-10 13:52:32','',''),(2232894,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 13:52:32','',''),(2233775,'19','199','1023',467,'Retail Sale Id 1312375',5184.00,0.00,0.00,0.00,764.00,'2021-12-10 14:33:15','',''),(2233776,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-10 14:33:15','',''),(2233927,'19','199','1023',467,'Retail Sale Id 1312436',1944.00,0.00,0.00,0.00,286.50,'2021-12-10 14:39:40','',''),(2233928,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 14:39:40','',''),(2234153,'19','199','1023',467,'Retail Sale Id 1312538',1944.00,0.00,0.00,0.00,286.50,'2021-12-10 14:48:08','',''),(2234154,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 14:48:08','',''),(2234274,'19','199','1023',467,'Retail Sale Id 1312594',1944.00,0.00,0.00,0.00,286.50,'2021-12-10 14:53:54','',''),(2234275,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 14:53:54','',''),(2234862,'19','199','1023',467,'Retail Sale Id 1312887',3888.00,0.00,0.00,0.00,573.00,'2021-12-10 15:21:59','',''),(2234863,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:21:59','',''),(2235209,'19','199','1023',467,'Retail Sale Id 1313026',3240.00,0.00,0.00,0.00,477.50,'2021-12-10 15:34:48','',''),(2235210,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 15:34:48','',''),(2235259,'19','199','1023',467,'Retail Sale Id 1313069',1944.00,0.00,0.00,0.00,286.50,'2021-12-10 15:37:09','',''),(2235260,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 15:37:09','',''),(2235505,'19','199','1023',467,'Retail Sale Id 1313198',3888.00,0.00,0.00,0.00,573.00,'2021-12-10 15:47:55','',''),(2235506,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:47:55','',''),(2235550,'19','199','1023',467,'Retail Sale Id 1313229',1944.00,0.00,0.00,0.00,286.50,'2021-12-10 15:50:18','',''),(2235551,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 15:50:18','',''),(2235593,'19','199','1023',467,'Retail Sale Id 1313253',6480.00,0.00,0.00,0.00,955.00,'2021-12-10 15:52:38','',''),(2235594,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 15:52:38','',''),(2235646,'19','199','1023',467,'Retail Sale Id 1313282',4050.00,0.00,0.00,0.00,596.88,'2021-12-10 15:55:13','',''),(2235647,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-10 15:55:13','',''),(2235755,'19','199','1023',467,'Retail Sale Id 1313315',1944.00,0.00,0.00,0.00,286.50,'2021-12-10 15:59:53','',''),(2235756,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 15:59:53','',''),(2235757,'19','199','1023',467,'Retail Sale Id 1313315',3888.00,0.00,0.00,0.00,573.00,'2021-12-10 15:59:53','',''),(2235758,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:59:53','',''),(2235759,'19','199','1023',467,'Retail Sale Id 1313315',3888.00,0.00,0.00,0.00,573.00,'2021-12-10 15:59:53','',''),(2235760,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:59:53','',''),(2235972,'19','199','1023',467,'Retail Sale Id 1313426',8100.00,0.00,0.00,0.00,1193.75,'2021-12-10 16:09:37','',''),(2235973,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:09:37','',''),(2236055,'19','199','1023',467,'Retail Sale Id 1313474',3240.00,0.00,0.00,0.00,477.50,'2021-12-10 16:13:38','',''),(2236056,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 16:13:38','',''),(2236423,'19','199','1023',467,'Retail Sale Id 1313666',4050.00,0.00,0.00,0.00,596.88,'2021-12-10 16:29:47','',''),(2236424,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-10 16:29:47','',''),(2240018,'19','199','1023',467,'Retail Sale Id 1315214',3888.00,0.00,0.00,0.00,573.00,'2021-12-11 07:45:13','',''),(2240019,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 07:45:13','',''),(2240114,'19','199','1023',467,'Retail Sale Id 1315274',1944.00,0.00,0.00,0.00,286.50,'2021-12-11 07:48:57','',''),(2240115,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 07:48:57','',''),(2240306,'19','199','1023',467,'Retail Sale Id 1315355',6480.00,0.00,0.00,0.00,955.00,'2021-12-11 07:56:24','',''),(2240307,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 07:56:24','',''),(2240520,'19','199','1023',467,'Retail Sale Id 1315439',4050.00,0.00,0.00,0.00,596.88,'2021-12-11 08:05:16','',''),(2240521,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-11 08:05:16','',''),(2240599,'19','199','1023',467,'Retail Sale Id 1315467',2592.00,0.00,0.00,0.00,382.00,'2021-12-11 08:08:44','',''),(2240600,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 08:08:44','',''),(2240673,'19','199','1023',467,'Retail Sale Id 1315497',1944.00,0.00,0.00,0.00,286.50,'2021-12-11 08:11:57','',''),(2240674,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 08:11:57','',''),(2240723,'19','199','1023',467,'Retail Sale Id 1315520',1944.00,0.00,0.00,0.00,286.50,'2021-12-11 08:14:12','',''),(2240724,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 08:14:12','',''),(2241034,'19','199','1023',467,'Retail Sale Id 1315691',1944.00,0.00,0.00,0.00,286.50,'2021-12-11 08:30:13','',''),(2241035,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 08:30:13','',''),(2241084,'19','199','1023',467,'Retail Sale Id 1315715',8100.00,0.00,0.00,0.00,1193.75,'2021-12-11 08:32:51','',''),(2241085,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 08:32:51','',''),(2241148,'19','199','1023',467,'Retail Sale Id 1315744',1944.00,0.00,0.00,0.00,286.50,'2021-12-11 08:36:01','',''),(2241149,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 08:36:01','',''),(2241527,'19','199','1023',467,'Retail Sale Id 1315912',8100.00,0.00,0.00,0.00,1193.75,'2021-12-11 08:54:19','',''),(2241528,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 08:54:19','',''),(2241672,'19','199','1023',467,'Retail Sale Id 1315958',1944.00,0.00,0.00,0.00,286.50,'2021-12-11 08:59:17','',''),(2241673,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 08:59:17','',''),(2242148,'19','199','1023',467,'Retail Sale Id 1316198',3888.00,0.00,0.00,0.00,573.00,'2021-12-11 09:19:52','',''),(2242149,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 09:19:52','',''),(2242299,'19','199','1023',467,'Retail Sale Id 1316269',1944.00,0.00,0.00,0.00,286.50,'2021-12-11 09:28:20','',''),(2242300,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 09:28:20','',''),(2242458,'19','199','1023',467,'Retail Sale Id 1316352',1944.00,0.00,0.00,0.00,286.50,'2021-12-11 09:36:35','',''),(2242459,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 09:36:35','',''),(2242670,'19','199','1023',467,'Retail Sale Id 1316458',7776.00,0.00,0.00,0.00,1146.00,'2021-12-11 09:45:30','',''),(2242671,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-11 09:45:30','',''),(2242744,'19','199','1023',467,'Retail Sale Id 1316498',8100.00,0.00,0.00,0.00,1193.75,'2021-12-11 09:49:09','',''),(2242745,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:49:09','',''),(2242931,'19','199','1023',467,'Retail Sale Id 1316585',8100.00,0.00,0.00,0.00,1193.75,'2021-12-11 09:59:08','',''),(2242932,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:59:08','',''),(2243127,'19','199','1023',467,'Retail Sale Id 1316677',8100.00,0.00,0.00,0.00,1193.75,'2021-12-11 10:08:52','',''),(2243128,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 10:08:52','',''),(2243225,'19','199','1023',467,'Retail Sale Id 1316711',8100.00,0.00,0.00,0.00,1193.75,'2021-12-11 10:12:48','',''),(2243226,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 10:12:48','',''),(2243431,'19','199','1023',467,'Retail Sale Id 1316799',4050.00,0.00,0.00,0.00,596.88,'2021-12-11 10:21:53','',''),(2243432,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-11 10:21:53','',''),(2243673,'19','199','1023',467,'Retail Sale Id 1316917',2916.00,0.00,0.00,0.00,429.75,'2021-12-11 10:34:58','',''),(2243674,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-11 10:34:58','',''),(2243830,'19','199','1023',467,'Retail Sale Id 1316981',3240.00,0.00,0.00,0.00,477.50,'2021-12-11 10:42:58','',''),(2243831,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 10:42:58','',''),(2244361,'19','199','1023',467,'Retail Sale Id 1317245',8100.00,0.00,0.00,0.00,1193.75,'2021-12-11 11:10:09','',''),(2244362,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:10:09','',''),(2244644,'19','199','1023',467,'Retail Sale Id 1317387',2916.00,0.00,0.00,0.00,429.75,'2021-12-11 11:24:44','',''),(2244645,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-11 11:24:44','',''),(2244794,'19','199','1023',467,'Retail Sale Id 1317455',8100.00,0.00,0.00,0.00,1193.75,'2021-12-11 11:32:44','',''),(2244795,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:32:44','',''),(2244840,'19','199','1023',467,'Retail Sale Id 1317479',7776.00,0.00,0.00,0.00,1146.00,'2021-12-11 11:35:11','',''),(2244841,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-11 11:35:11','',''),(2244908,'19','199','1023',467,'Retail Sale Id 1317518',4050.00,0.00,0.00,0.00,596.88,'2021-12-11 11:39:24','',''),(2244909,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-11 11:39:24','',''),(2244953,'19','199','1023',467,'Retail Sale Id 1317548',1944.00,0.00,0.00,0.00,286.50,'2021-12-11 11:42:04','',''),(2244954,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 11:42:04','',''),(2245087,'19','199','1023',467,'Retail Sale Id 1317611',1944.00,0.00,0.00,0.00,286.50,'2021-12-11 11:50:47','',''),(2245088,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 11:50:47','',''),(2245089,'19','199','1023',467,'Retail Sale Id 1317611',3888.00,0.00,0.00,0.00,573.00,'2021-12-11 11:50:47','',''),(2245090,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 11:50:47','',''),(2245119,'19','199','1023',467,'Retail Sale Id 1317632',8100.00,0.00,0.00,0.00,1193.75,'2021-12-11 11:52:43','',''),(2245120,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:52:43','',''),(2245198,'19','199','1023',467,'Retail Sale Id 1317670',8100.00,0.00,0.00,0.00,1193.75,'2021-12-11 11:56:47','',''),(2245199,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:56:47','',''),(2245662,'19','199','1023',467,'Retail Sale Id 1317949',1944.00,0.00,0.00,0.00,286.50,'2021-12-11 12:25:52','',''),(2245663,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 12:25:52','',''),(2245979,'19','199','1023',467,'Retail Sale Id 1318108',4050.00,0.00,0.00,0.00,596.88,'2021-12-11 12:45:06','',''),(2245980,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-11 12:45:06','',''),(2245981,'19','199','1023',467,'Retail Sale Id 1318108',4050.00,0.00,0.00,0.00,596.88,'2021-12-11 12:45:06','',''),(2245982,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-11 12:45:06','',''),(2246051,'19','199','1023',467,'Retail Sale Id 1318147',4050.00,0.00,0.00,0.00,596.88,'2021-12-11 12:51:45','',''),(2246052,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-11 12:51:45','',''),(2246053,'19','199','1023',467,'Retail Sale Id 1318147',4050.00,0.00,0.00,0.00,596.88,'2021-12-11 12:51:45','',''),(2246054,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-11 12:51:45','',''),(2246250,'19','199','1023',467,'Retail Sale Id 1318254',8100.00,0.00,0.00,0.00,1193.75,'2021-12-11 13:05:51','',''),(2246251,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 13:05:51','',''),(2246322,'19','199','1023',467,'Retail Sale Id 1318291',8100.00,0.00,0.00,0.00,1193.75,'2021-12-11 13:12:29','',''),(2246323,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 13:12:29','',''),(2246373,'19','199','1023',467,'Retail Sale Id 1318315',1296.00,0.00,0.00,0.00,191.00,'2021-12-11 13:15:47','',''),(2246374,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 13:15:47','',''),(2246486,'19','199','1023',467,'Retail Sale Id 1318365',1296.00,0.00,0.00,0.00,191.00,'2021-12-11 13:22:53','',''),(2246487,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 13:22:53','',''),(2246519,'19','199','1023',467,'Retail Sale Id 1318379',3240.00,0.00,0.00,0.00,477.50,'2021-12-11 13:24:45','',''),(2246520,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 13:24:45','',''),(2246622,'19','199','1023',467,'Retail Sale Id 1318431',2592.00,0.00,0.00,0.00,382.00,'2021-12-11 13:32:12','',''),(2246623,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 13:32:12','',''),(2246941,'19','199','1023',467,'Retail Sale Id 1318538',5832.00,0.00,0.00,0.00,859.50,'2021-12-11 13:52:05','',''),(2246942,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-11 13:52:05','',''),(2246943,'19','199','1023',467,'Retail Sale Id 1318538',8100.00,0.00,0.00,0.00,1193.75,'2021-12-11 13:52:05','',''),(2246944,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 13:52:05','',''),(2247004,'19','199','1023',467,'Retail Sale Id 1318591',8100.00,0.00,0.00,0.00,1193.75,'2021-12-11 13:56:14','',''),(2247005,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 13:56:14','',''),(2247093,'19','199','1023',467,'Retail Sale Id 1318640',2592.00,0.00,0.00,0.00,382.00,'2021-12-11 14:01:44','',''),(2247094,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 14:01:44','',''),(2247286,'19','199','1023',467,'Retail Sale Id 1318731',1296.00,0.00,0.00,0.00,191.00,'2021-12-11 14:12:42','',''),(2247287,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 14:12:42','',''),(2247427,'19','199','1023',467,'Retail Sale Id 1318802',4050.00,0.00,0.00,0.00,596.88,'2021-12-11 14:22:39','',''),(2247428,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-11 14:22:39','',''),(2247472,'19','199','1023',467,'Retail Sale Id 1318822',8100.00,0.00,0.00,0.00,1193.75,'2021-12-11 14:25:23','',''),(2247473,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 14:25:23','',''),(2269335,'19','199','1023',467,'Retail Sale Id 1328661',3240.00,0.00,0.00,0.00,477.50,'2021-12-13 10:26:56','',''),(2269336,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 10:26:56','',''),(2269399,'19','199','1023',467,'Retail Sale Id 1328689',7776.00,0.00,0.00,0.00,1146.00,'2021-12-13 10:30:35','',''),(2269400,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-13 10:30:35','',''),(2269527,'19','199','1023',467,'Retail Sale Id 1328744',8100.00,0.00,0.00,0.00,1193.75,'2021-12-13 10:37:36','',''),(2269528,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 10:37:36','',''),(2269564,'19','199','1023',467,'Retail Sale Id 1328760',3240.00,0.00,0.00,0.00,477.50,'2021-12-13 10:40:04','',''),(2269565,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 10:40:04','',''),(2269665,'19','199','1023',467,'Retail Sale Id 1328803',1944.00,0.00,0.00,0.00,286.50,'2021-12-13 10:45:40','',''),(2269666,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:45:40','',''),(2269786,'19','199','1023',467,'Retail Sale Id 1328873',4536.00,0.00,0.00,0.00,668.50,'2021-12-13 10:51:55','',''),(2269787,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-13 10:51:55','',''),(2269846,'19','199','1023',467,'Retail Sale Id 1328895',8100.00,0.00,0.00,0.00,1193.75,'2021-12-13 10:56:22','',''),(2269847,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 10:56:22','',''),(2269878,'19','199','1023',467,'Retail Sale Id 1328916',1944.00,0.00,0.00,0.00,286.50,'2021-12-13 10:58:25','',''),(2269879,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:58:25','',''),(2269933,'19','199','1023',467,'Retail Sale Id 1328936',1944.00,0.00,0.00,0.00,286.50,'2021-12-13 11:00:37','',''),(2269934,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 11:00:37','',''),(2269961,'19','199','1023',467,'Retail Sale Id 1328950',8100.00,0.00,0.00,0.00,1193.75,'2021-12-13 11:02:21','',''),(2269962,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 11:02:21','',''),(2270044,'19','199','1023',467,'Retail Sale Id 1328995',7776.00,0.00,0.00,0.00,1146.00,'2021-12-13 11:09:10','',''),(2270045,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-13 11:09:10','',''),(2270069,'19','199','1023',467,'Retail Sale Id 1329006',1944.00,0.00,0.00,0.00,286.50,'2021-12-13 11:11:24','',''),(2270070,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 11:11:24','',''),(2270098,'19','199','1023',467,'Retail Sale Id 1329017',8100.00,0.00,0.00,0.00,1193.75,'2021-12-13 11:13:19','',''),(2270099,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 11:13:19','',''),(2270139,'19','199','1023',467,'Retail Sale Id 1329039',4050.00,0.00,0.00,0.00,596.88,'2021-12-13 11:16:44','',''),(2270140,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-13 11:16:44','',''),(2270205,'19','199','1023',467,'Retail Sale Id 1329075',3240.00,0.00,0.00,0.00,477.50,'2021-12-13 11:20:35','',''),(2270206,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 11:20:35','',''),(2270232,'19','199','1023',467,'Retail Sale Id 1329086',3888.00,0.00,0.00,0.00,573.00,'2021-12-13 11:22:13','',''),(2270233,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 11:22:13','',''),(2270248,'19','199','1023',467,'Retail Sale Id 1329093',1944.00,0.00,0.00,0.00,286.50,'2021-12-13 11:24:17','',''),(2270249,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 11:24:17','',''),(2270308,'19','199','1023',467,'Retail Sale Id 1329116',1296.00,0.00,0.00,0.00,191.00,'2021-12-13 11:28:49','',''),(2270309,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 11:28:49','',''),(2270332,'19','199','1023',467,'Retail Sale Id 1329129',1944.00,0.00,0.00,0.00,286.50,'2021-12-13 11:30:39','',''),(2270333,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 11:30:39','',''),(2270382,'19','199','1023',467,'Retail Sale Id 1329154',8100.00,0.00,0.00,0.00,1193.75,'2021-12-13 11:34:59','',''),(2270383,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 11:34:59','',''),(2270408,'19','199','1023',467,'Retail Sale Id 1329164',1944.00,0.00,0.00,0.00,286.50,'2021-12-13 11:37:21','',''),(2270409,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 11:37:21','',''),(2270560,'19','199','1023',467,'Retail Sale Id 1329243',3888.00,0.00,0.00,0.00,573.00,'2021-12-13 11:49:56','',''),(2270561,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 11:49:56','',''),(2270647,'19','199','1023',467,'Retail Sale Id 1329287',8100.00,0.00,0.00,0.00,1193.75,'2021-12-13 11:59:15','',''),(2270648,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 11:59:15','',''),(2270743,'19','199','1023',467,'Retail Sale Id 1329336',8100.00,0.00,0.00,0.00,1193.75,'2021-12-13 12:07:25','',''),(2270744,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:07:25','',''),(2270915,'19','199','1023',467,'Retail Sale Id 1329436',2592.00,0.00,0.00,0.00,382.00,'2021-12-13 12:19:59','',''),(2270916,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 12:19:59','',''),(2270970,'19','199','1023',467,'Retail Sale Id 1329464',1296.00,0.00,0.00,0.00,191.00,'2021-12-13 12:24:47','',''),(2270971,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 12:24:47','',''),(2271209,'19','199','1023',467,'Retail Sale Id 1329604',8100.00,0.00,0.00,0.00,1193.75,'2021-12-13 12:42:07','',''),(2271210,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:42:07','',''),(2271311,'19','199','1023',467,'Retail Sale Id 1329657',8100.00,0.00,0.00,0.00,1193.75,'2021-12-13 12:49:17','',''),(2271312,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:49:17','',''),(2271623,'19','199','1023',467,'Retail Sale Id 1329804',4050.00,0.00,0.00,0.00,596.88,'2021-12-13 13:07:32','',''),(2271624,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-13 13:07:32','',''),(2271713,'19','199','1023',467,'Retail Sale Id 1329851',6480.00,0.00,0.00,0.00,955.00,'2021-12-13 13:14:09','',''),(2271714,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-13 13:14:09','',''),(2271828,'19','199','1023',467,'Retail Sale Id 1329899',8100.00,0.00,0.00,0.00,1193.75,'2021-12-13 13:19:46','',''),(2271829,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 13:19:46','',''),(2271974,'19','199','1023',467,'Retail Sale Id 1329942',8100.00,0.00,0.00,0.00,1193.75,'2021-12-13 13:26:03','',''),(2271975,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 13:26:03','',''),(2272000,'19','199','1023',467,'Retail Sale Id 1329956',1944.00,0.00,0.00,0.00,286.50,'2021-12-13 13:27:48','',''),(2272001,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 13:27:48','',''),(2272198,'19','199','1023',467,'Retail Sale Id 1330035',8100.00,0.00,0.00,0.00,1193.75,'2021-12-13 13:39:39','',''),(2272199,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 13:39:39','',''),(2272525,'19','199','1023',467,'Retail Sale Id 1330169',1944.00,0.00,0.00,0.00,286.50,'2021-12-13 13:56:24','',''),(2272526,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 13:56:24','',''),(2272558,'19','199','1023',467,'Retail Sale Id 1330187',1944.00,0.00,0.00,0.00,286.50,'2021-12-13 13:58:16','',''),(2272559,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 13:58:16','',''),(2273034,'19','199','1023',467,'Retail Sale Id 1330484',1944.00,0.00,0.00,0.00,286.50,'2021-12-13 14:28:13','',''),(2273035,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 14:28:13','',''),(2273074,'19','199','1023',467,'Retail Sale Id 1330507',3240.00,0.00,0.00,0.00,477.50,'2021-12-13 14:30:22','',''),(2273075,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 14:30:22','',''),(2273130,'19','199','1023',467,'Retail Sale Id 1330529',8100.00,0.00,0.00,0.00,1193.75,'2021-12-13 14:33:35','',''),(2273131,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 14:33:35','',''),(2273229,'19','199','1023',467,'Retail Sale Id 1330569',1296.00,0.00,0.00,0.00,191.00,'2021-12-13 14:37:56','',''),(2273230,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 14:37:56','',''),(2273475,'19','199','1023',467,'Retail Sale Id 1330689',1296.00,0.00,0.00,0.00,191.00,'2021-12-13 14:54:13','',''),(2273476,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 14:54:13','',''),(2274139,'19','199','1023',467,'Retail Sale Id 1331001',1944.00,0.00,0.00,0.00,286.50,'2021-12-13 15:31:05','',''),(2274140,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 15:31:05','',''),(2274321,'19','199','1023',467,'Retail Sale Id 1331064',1944.00,0.00,0.00,0.00,286.50,'2021-12-13 15:38:23','',''),(2274322,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 15:38:23','',''),(2274531,'19','199','1023',467,'Retail Sale Id 1331190',4050.00,0.00,0.00,0.00,596.88,'2021-12-13 15:48:13','',''),(2274532,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-13 15:48:13','',''),(2274713,'19','199','1023',467,'Retail Sale Id 1331287',8100.00,0.00,0.00,0.00,1193.75,'2021-12-13 15:58:35','',''),(2274714,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 15:58:35','',''),(2275613,'19','199','1023',467,'Retail Sale Id 1329242',3888.00,0.00,0.00,0.00,573.00,'2021-12-13 16:49:54','',''),(2275614,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 16:49:54','',''),(2275670,'19','199','1023',467,'Retail Sale Id 1328962',1944.00,0.00,0.00,0.00,286.50,'2021-12-13 16:53:16','',''),(2275671,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 16:53:16','',''),(2275947,'19','199','1023',467,'Retail Sale Id 1328831',3888.00,0.00,0.00,0.00,573.00,'2021-12-13 17:15:56','',''),(2275948,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 17:15:56','',''),(2278522,'19','199','1023',467,'Retail Sale Id 1332965',8100.00,0.00,0.00,0.00,1193.75,'2021-12-14 07:50:10','',''),(2278523,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 07:50:10','',''),(2278540,'19','199','1023',467,'Retail Sale Id 1332975',3240.00,0.00,0.00,0.00,477.50,'2021-12-14 07:51:11','',''),(2278541,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 07:51:11','',''),(2278542,'19','199','1023',467,'Retail Sale Id 1332975',8100.00,0.00,0.00,0.00,1193.75,'2021-12-14 07:51:11','',''),(2278543,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 07:51:11','',''),(2278560,'19','199','1023',467,'Retail Sale Id 1332984',1944.00,0.00,0.00,0.00,286.50,'2021-12-14 07:52:11','',''),(2278561,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 07:52:11','',''),(2278616,'19','199','1023',467,'Retail Sale Id 1333013',4536.00,0.00,0.00,0.00,668.50,'2021-12-14 07:55:17','',''),(2278617,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-14 07:55:17','',''),(2278632,'19','199','1023',467,'Retail Sale Id 1333023',1944.00,0.00,0.00,0.00,286.50,'2021-12-14 07:56:21','',''),(2278633,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 07:56:21','',''),(2278666,'19','199','1023',467,'Retail Sale Id 1333039',8100.00,0.00,0.00,0.00,1193.75,'2021-12-14 07:57:57','',''),(2278667,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 07:57:57','',''),(2278714,'19','199','1023',467,'Retail Sale Id 1333060',8100.00,0.00,0.00,0.00,1193.75,'2021-12-14 08:00:03','',''),(2278715,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 08:00:03','',''),(2278804,'19','199','1023',467,'Retail Sale Id 1333096',7776.00,0.00,0.00,0.00,1146.00,'2021-12-14 08:03:16','',''),(2278805,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-14 08:03:16','',''),(2279227,'19','199','1023',467,'Retail Sale Id 1333334',1944.00,0.00,0.00,0.00,286.50,'2021-12-14 08:27:50','',''),(2279228,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 08:27:50','',''),(2279464,'19','199','1023',467,'Retail Sale Id 1333458',1944.00,0.00,0.00,0.00,286.50,'2021-12-14 08:39:26','',''),(2279465,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 08:39:26','',''),(2279603,'19','199','1023',467,'Retail Sale Id 1333532',8100.00,0.00,0.00,0.00,1193.75,'2021-12-14 08:47:22','',''),(2279604,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 08:47:22','',''),(2279906,'19','199','1023',467,'Retail Sale Id 1333650',1296.00,0.00,0.00,0.00,191.00,'2021-12-14 09:01:11','',''),(2279907,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-14 09:01:11','',''),(2280009,'19','199','1023',467,'Retail Sale Id 1333693',3240.00,0.00,0.00,0.00,477.50,'2021-12-14 09:05:34','',''),(2280010,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 09:05:34','',''),(2280061,'19','199','1023',467,'Retail Sale Id 1333729',8100.00,0.00,0.00,0.00,1193.75,'2021-12-14 09:08:00','',''),(2280062,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 09:08:00','',''),(2280135,'19','199','1023',467,'Retail Sale Id 1333752',1944.00,0.00,0.00,0.00,286.50,'2021-12-14 09:10:34','',''),(2280136,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 09:10:34','',''),(2280594,'19','199','1023',467,'Retail Sale Id 1333958',8100.00,0.00,0.00,0.00,1193.75,'2021-12-14 09:33:41','',''),(2280595,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 09:33:41','',''),(2280737,'19','199','1023',467,'Retail Sale Id 1334024',1944.00,0.00,0.00,0.00,286.50,'2021-12-14 09:42:02','',''),(2280738,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 09:42:02','',''),(2281045,'19','199','1023',467,'Retail Sale Id 1334184',3888.00,0.00,0.00,0.00,573.00,'2021-12-14 10:00:55','',''),(2281046,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 10:00:55','',''),(2281047,'19','199','1023',467,'Retail Sale Id 1334184',4050.00,0.00,0.00,0.00,596.88,'2021-12-14 10:00:55','',''),(2281048,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-14 10:00:55','',''),(2281167,'19','199','1023',467,'Retail Sale Id 1334251',1944.00,0.00,0.00,0.00,286.50,'2021-12-14 10:08:51','',''),(2281168,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 10:08:51','',''),(2281250,'19','199','1023',467,'Retail Sale Id 1334294',4050.00,0.00,0.00,0.00,596.88,'2021-12-14 10:12:27','',''),(2281251,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-14 10:12:27','',''),(2281334,'19','199','1023',467,'Retail Sale Id 1334338',4050.00,0.00,0.00,0.00,596.88,'2021-12-14 10:16:35','',''),(2281335,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-14 10:16:35','',''),(2281714,'19','199','1023',467,'Retail Sale Id 1334571',3888.00,0.00,0.00,0.00,573.00,'2021-12-14 10:35:28','',''),(2281715,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 10:35:28','',''),(2281758,'19','199','1023',467,'Retail Sale Id 1334600',8100.00,0.00,0.00,0.00,1193.75,'2021-12-14 10:38:05','',''),(2281759,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 10:38:05','',''),(2281886,'19','199','1023',467,'Retail Sale Id 1334665',4050.00,0.00,0.00,0.00,596.88,'2021-12-14 10:44:24','',''),(2281887,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-14 10:44:24','',''),(2282160,'19','199','1023',467,'Retail Sale Id 1334801',3888.00,0.00,0.00,0.00,573.00,'2021-12-14 11:02:52','',''),(2282161,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 11:02:52','',''),(2282208,'19','199','1023',467,'Retail Sale Id 1334830',3888.00,0.00,0.00,0.00,573.00,'2021-12-14 11:04:44','',''),(2282209,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 11:04:44','',''),(2282239,'19','199','1023',467,'Retail Sale Id 1334849',8100.00,0.00,0.00,0.00,1193.75,'2021-12-14 11:06:37','',''),(2282240,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 11:06:37','',''),(2282377,'19','199','1023',467,'Retail Sale Id 1334920',8100.00,0.00,0.00,0.00,1193.75,'2021-12-14 11:14:07','',''),(2282378,'19','199','1023',467,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 11:14:07','',''),(2282462,'19','199','1023',467,'Retail Sale Id 1335340',8100.00,0.00,0.00,12.50,1193.75,'2021-12-14 12:22:15','',''),(2282473,'19','199','1023',467,'Retail Sale Id 1335354',8100.00,0.00,0.00,12.50,1193.75,'2021-12-14 12:25:56','',''),(2282492,'19','199','1023',467,'Retail Sale Id 1335378',8100.00,0.00,0.00,12.50,1193.75,'2021-12-14 12:30:19','',''),(2282511,'19','199','1023',467,'Retail Sale Id 1335402',4050.00,0.00,0.00,6.25,596.88,'2021-12-14 12:33:35','',''),(2282553,'19','199','1023',467,'Retail Sale Id 1335432',1296.00,0.00,0.00,2.00,191.00,'2021-12-14 12:37:23','',''),(2282575,'19','199','1023',467,'Retail Sale Id 1335458',1944.00,0.00,0.00,3.00,286.50,'2021-12-14 12:40:46','',''),(2282576,'19','199','1023',467,'Retail Sale Id 1335458',8100.00,0.00,0.00,12.50,1193.75,'2021-12-14 12:40:46','',''),(2282577,'19','199','1023',467,'Retail Sale Id 1335458',8100.00,0.00,0.00,12.50,1193.75,'2021-12-14 12:40:46','',''),(2282590,'19','199','1023',467,'Retail Sale Id 1335472',4050.00,0.00,0.00,6.25,596.88,'2021-12-14 12:42:59','',''),(2282608,'19','199','1023',467,'Retail Sale Id 1335486',8100.00,0.00,0.00,12.50,1193.75,'2021-12-14 12:44:47','',''),(2282672,'19','199','1023',467,'Retail Sale Id 1335527',8100.00,0.00,0.00,12.50,1193.75,'2021-12-14 12:50:28','',''),(2282734,'19','199','1023',467,'Retail Sale Id 1335578',8100.00,0.00,0.00,12.50,1193.75,'2021-12-14 12:59:29','',''),(2282782,'19','199','1023',467,'Retail Sale Id 1335630',6480.00,0.00,0.00,10.00,955.00,'2021-12-14 13:06:02','',''),(2282810,'19','199','1023',467,'Retail Sale Id 1335653',3240.00,0.00,0.00,5.00,477.50,'2021-12-14 13:09:41','',''),(2282836,'19','199','1023',467,'Retail Sale Id 1335680',8100.00,0.00,0.00,12.50,1193.75,'2021-12-14 13:13:54','',''),(2283004,'19','199','1023',467,'Retail Sale Id 1335813',1944.00,0.00,0.00,3.00,286.50,'2021-12-14 13:34:00','',''),(2283016,'19','199','1023',467,'Retail Sale Id 1335827',8100.00,0.00,0.00,12.50,1193.75,'2021-12-14 13:35:40','',''),(2283207,'19','199','1023',467,'Retail Sale Id 1335941',1944.00,0.00,0.00,3.00,286.50,'2021-12-14 13:56:14','',''),(2283254,'19','199','1023',467,'Retail Sale Id 1335970',3240.00,0.00,0.00,5.00,477.50,'2021-12-14 13:59:53','',''),(2283314,'19','199','1023',467,'Retail Sale Id 1336017',8100.00,0.00,0.00,12.50,1193.75,'2021-12-14 14:06:31','',''),(2283377,'19','199','1023',467,'Retail Sale Id 1336042',3240.00,0.00,0.00,5.00,477.50,'2021-12-14 14:09:57','',''),(2283477,'19','199','1023',467,'Retail Sale Id 1336128',8100.00,0.00,0.00,12.50,1193.75,'2021-12-14 14:21:37','',''),(2283492,'19','199','1023',467,'Retail Sale Id 1336144',2916.00,0.00,0.00,4.50,429.75,'2021-12-14 14:24:06','',''),(2283522,'19','199','1023',467,'Retail Sale Id 1336170',8100.00,0.00,0.00,12.50,1193.75,'2021-12-14 14:27:45','',''),(2283816,'19','199','1023',467,'Retail Sale Id 1336376',31500.00,0.00,0.00,50.00,3875.00,'2021-12-14 14:58:56','',''),(2283917,'19','199','1023',467,'Retail Sale Id 1336479',3240.00,0.00,0.00,5.00,477.50,'2021-12-14 15:18:54','',''),(2284034,'19','199','1023',467,'Retail Sale Id 1336561',8100.00,0.00,0.00,12.50,1193.75,'2021-12-14 15:30:39','',''),(2284057,'19','199','1023',467,'Retail Sale Id 1336583',8100.00,0.00,0.00,12.50,1193.75,'2021-12-14 15:33:53','',''),(2284169,'19','199','1023',467,'Retail Sale Id 1336635',3888.00,0.00,0.00,6.00,573.00,'2021-12-14 15:41:28','',''),(2284304,'19','199','1023',467,'Retail Sale Id 1336729',1944.00,0.00,0.00,3.00,286.50,'2021-12-14 15:52:48','',''),(2284419,'19','199','1023',467,'Retail Sale Id 1336807',3888.00,0.00,0.00,6.00,573.00,'2021-12-14 16:03:04','',''),(2284542,'19','199','1023',467,'Retail Sale Id 1336936',1944.00,0.00,0.00,3.00,286.50,'2021-12-14 16:17:29','',''),(2286698,'19','199','1023',467,'Retail Sale Id 1338343',4050.00,0.00,0.00,6.25,596.88,'2021-12-15 07:43:37','',''),(2286720,'19','199','1023',467,'Retail Sale Id 1338363',4050.00,0.00,0.00,6.25,596.88,'2021-12-15 07:45:47','',''),(2286908,'19','199','1023',467,'Retail Sale Id 1338451',15750.00,0.00,0.00,25.00,1937.50,'2021-12-15 08:01:50','',''),(2286909,'19','199','1023',467,'Retail Sale Id 1338451',31500.00,0.00,0.00,50.00,3875.00,'2021-12-15 08:01:50','',''),(2287536,'19','199','1023',467,'Retail Sale Id 1339000',8100.00,0.00,0.00,12.50,1193.75,'2021-12-15 09:06:49','',''),(2287616,'19','199','1023',467,'Retail Sale Id 1339043',6480.00,0.00,0.00,10.00,955.00,'2021-12-15 09:11:48','',''),(2287639,'19','199','1023',467,'Retail Sale Id 1339065',2916.00,0.00,0.00,4.50,429.75,'2021-12-15 09:14:58','',''),(2287687,'19','199','1023',467,'Retail Sale Id 1339101',4050.00,0.00,0.00,6.25,596.88,'2021-12-15 09:20:08','',''),(2287794,'19','199','1023',467,'Retail Sale Id 1339201',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 09:33:28','',''),(2287828,'19','199','1023',467,'Retail Sale Id 1339224',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 09:36:15','',''),(2288204,'19','199','1023',467,'Retail Sale Id 1339541',3888.00,0.00,0.00,6.00,573.00,'2021-12-15 10:23:22','',''),(2288219,'19','199','1023',467,'Retail Sale Id 1339549',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 10:26:32','',''),(2288220,'19','199','1023',467,'Retail Sale Id 1339549',8100.00,0.00,0.00,12.50,1193.75,'2021-12-15 10:26:32','',''),(2288330,'19','199','1023',467,'Retail Sale Id 1339654',8100.00,0.00,0.00,12.50,1193.75,'2021-12-15 10:42:54','',''),(2288408,'19','199','1023',467,'Retail Sale Id 1339713',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 10:51:29','',''),(2288519,'19','199','1023',467,'Retail Sale Id 1339812',8100.00,0.00,0.00,12.50,1193.75,'2021-12-15 11:03:51','',''),(2288541,'19','199','1023',467,'Retail Sale Id 1339835',8100.00,0.00,0.00,12.50,1193.75,'2021-12-15 11:06:13','',''),(2288786,'19','199','1023',467,'Retail Sale Id 1340036',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 11:32:49','',''),(2288977,'19','199','1023',467,'Retail Sale Id 1340237',8100.00,0.00,0.00,12.50,1193.75,'2021-12-15 11:58:16','',''),(2288992,'19','199','1023',467,'Retail Sale Id 1340253',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 12:00:16','',''),(2289010,'19','199','1023',467,'Retail Sale Id 1340273',8100.00,0.00,0.00,12.50,1193.75,'2021-12-15 12:04:28','',''),(2289779,'19','199','1023',467,'Retail Sale Id 1340921',3888.00,0.00,0.00,6.00,573.00,'2021-12-15 13:43:56','',''),(2289818,'19','199','1023',467,'Retail Sale Id 1340936',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 13:47:37','',''),(2289837,'19','199','1023',467,'Retail Sale Id 1340965',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 13:49:04','',''),(2289941,'19','199','1023',467,'Retail Sale Id 1341052',2592.00,0.00,0.00,4.00,382.00,'2021-12-15 14:00:15','',''),(2289964,'19','199','1023',467,'Retail Sale Id 1341065',4050.00,0.00,0.00,6.25,596.88,'2021-12-15 14:01:48','',''),(2290054,'19','199','1023',467,'Retail Sale Id 1341089',2916.00,0.00,0.00,4.50,429.75,'2021-12-15 14:04:58','',''),(2290072,'19','199','1023',467,'Retail Sale Id 1341096',4050.00,0.00,0.00,6.25,596.88,'2021-12-15 14:07:24','',''),(2290248,'19','199','1023',467,'Retail Sale Id 1341207',3240.00,0.00,0.00,5.00,477.50,'2021-12-15 14:20:22','',''),(2290259,'19','199','1023',467,'Retail Sale Id 1341220',8100.00,0.00,0.00,12.50,1193.75,'2021-12-15 14:22:08','',''),(2290275,'19','199','1023',467,'Retail Sale Id 1341236',8100.00,0.00,0.00,12.50,1193.75,'2021-12-15 14:24:00','',''),(2290671,'19','199','1023',467,'Retail Sale Id 1341551',8100.00,0.00,0.00,12.50,1193.75,'2021-12-15 15:02:14','',''),(2290689,'19','199','1023',467,'Retail Sale Id 1341567',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 15:04:00','',''),(2290723,'19','199','1023',467,'Retail Sale Id 1341603',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 15:07:19','',''),(2290755,'19','199','1023',467,'Retail Sale Id 1341622',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 15:09:17','',''),(2290770,'19','199','1023',467,'Retail Sale Id 1341634',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 15:11:10','',''),(2291078,'19','199','1023',467,'Retail Sale Id 1341820',2592.00,0.00,0.00,4.00,382.00,'2021-12-15 15:32:26','',''),(2291105,'19','199','1023',467,'Retail Sale Id 1341839',3888.00,0.00,0.00,6.00,573.00,'2021-12-15 15:34:41','',''),(2291163,'19','199','1023',467,'Retail Sale Id 1341895',3240.00,0.00,0.00,5.00,477.50,'2021-12-15 15:39:39','',''),(2291183,'19','199','1023',467,'Retail Sale Id 1341915',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 15:42:11','',''),(2291209,'19','199','1023',467,'Retail Sale Id 1341939',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 15:45:02','',''),(2291232,'19','199','1023',467,'Retail Sale Id 1341957',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 15:47:03','',''),(2291321,'19','199','1023',467,'Retail Sale Id 1342038',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 15:55:00','',''),(2291426,'19','199','1023',467,'Retail Sale Id 1342120',8100.00,0.00,0.00,12.50,1193.75,'2021-12-15 16:03:13','',''),(2291447,'19','199','1023',467,'Retail Sale Id 1342137',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 16:05:03','',''),(2291448,'19','199','1023',467,'Retail Sale Id 1342137',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 16:05:03','',''),(2291515,'19','199','1023',467,'Retail Sale Id 1342210',8100.00,0.00,0.00,12.50,1193.75,'2021-12-15 16:12:00','',''),(2291536,'19','199','1023',467,'Retail Sale Id 1342232',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 16:14:28','',''),(2291570,'19','199','1023',467,'Retail Sale Id 1342257',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 16:17:08','',''),(2291667,'19','199','1023',467,'Retail Sale Id 1342350',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 16:25:54','',''),(2291769,'19','199','1023',467,'Retail Sale Id 1342450',1296.00,0.00,0.00,2.00,191.00,'2021-12-15 16:35:21','',''),(2291770,'19','199','1023',467,'Retail Sale Id 1342450',2916.00,0.00,0.00,4.50,429.75,'2021-12-15 16:35:21','',''),(2291817,'19','199','1023',467,'Retail Sale Id 1342481',4050.00,0.00,0.00,6.25,596.88,'2021-12-15 16:39:12','',''),(2291818,'19','199','1023',467,'Retail Sale Id 1342481',4050.00,0.00,0.00,6.25,596.88,'2021-12-15 16:39:12','',''),(2291889,'19','199','1023',467,'Retail Sale Id 1342537',4050.00,0.00,0.00,6.25,596.88,'2021-12-15 16:44:19','',''),(2292080,'19','199','1023',467,'Retail Sale Id 1342721',8100.00,0.00,0.00,12.50,1193.75,'2021-12-15 17:03:41','',''),(2292107,'19','199','1023',467,'Retail Sale Id 1342737',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 17:05:55','',''),(2292121,'19','199','1023',467,'Retail Sale Id 1342753',8100.00,0.00,0.00,12.50,1193.75,'2021-12-15 17:07:52','',''),(2292143,'19','199','1023',467,'Retail Sale Id 1342773',1944.00,0.00,0.00,3.00,286.50,'2021-12-15 17:10:56','',''),(2292144,'19','199','1023',467,'Retail Sale Id 1342773',2916.00,0.00,0.00,4.50,429.75,'2021-12-15 17:10:56','',''),(2292161,'19','199','1023',467,'Retail Sale Id 1342791',8100.00,0.00,0.00,12.50,1193.75,'2021-12-15 17:13:22','',''),(2292173,'19','199','1023',467,'Retail Sale Id 1342803',3888.00,0.00,0.00,6.00,573.00,'2021-12-15 17:15:03','',''),(2294538,'19','199','1023',467,'Retail Sale Id 1344328',8100.00,0.00,0.00,12.50,1193.75,'2021-12-16 08:18:53','',''),(2294567,'19','199','1023',467,'Retail Sale Id 1344353',1944.00,0.00,0.00,3.00,286.50,'2021-12-16 08:20:39','',''),(2294681,'19','199','1023',467,'Retail Sale Id 1344438',8100.00,0.00,0.00,12.50,1193.75,'2021-12-16 08:29:45','',''),(2294741,'19','199','1023',467,'Retail Sale Id 1344483',1944.00,0.00,0.00,3.00,286.50,'2021-12-16 08:34:41','',''),(2294770,'19','199','1023',467,'Retail Sale Id 1344507',1944.00,0.00,0.00,3.00,286.50,'2021-12-16 08:37:07','',''),(2294978,'19','199','1023',467,'Retail Sale Id 1344638',3240.00,0.00,0.00,5.00,477.50,'2021-12-16 08:51:40','',''),(2295103,'19','199','1023',467,'Retail Sale Id 1344745',6480.00,0.00,0.00,10.00,955.00,'2021-12-16 09:03:19','',''),(2295231,'19','199','1023',467,'Retail Sale Id 1344861',1944.00,0.00,0.00,3.00,286.50,'2021-12-16 09:14:14','',''),(2295327,'19','199','1023',467,'Retail Sale Id 1344955',1944.00,0.00,0.00,3.00,286.50,'2021-12-16 09:23:59','',''),(2295489,'19','199','1023',467,'Retail Sale Id 1345086',1944.00,0.00,0.00,3.00,286.50,'2021-12-16 09:38:36','',''),(2295507,'19','199','1023',467,'Retail Sale Id 1345105',1944.00,0.00,0.00,3.00,286.50,'2021-12-16 09:40:40','',''),(2295533,'19','199','1023',467,'Retail Sale Id 1345122',1944.00,0.00,0.00,3.00,286.50,'2021-12-16 09:42:52','',''),(2295534,'19','199','1023',467,'Retail Sale Id 1345122',1944.00,0.00,0.00,3.00,286.50,'2021-12-16 09:42:52','',''),(2295628,'19','199','1023',467,'Retail Sale Id 1345208',1944.00,0.00,0.00,3.00,286.50,'2021-12-16 09:52:07','',''),(2295700,'19','199','1023',467,'Retail Sale Id 1345245',4536.00,0.00,0.00,7.00,668.50,'2021-12-16 09:57:49','',''),(2295780,'19','199','1023',467,'Retail Sale Id 1345288',4050.00,0.00,0.00,6.25,596.88,'2021-12-16 10:02:32','',''),(2296131,'19','199','1023',467,'Retail Sale Id 1345604',8100.00,0.00,0.00,12.50,1193.75,'2021-12-16 10:40:48','',''),(2296196,'19','199','1023',467,'Retail Sale Id 1345674',8100.00,0.00,0.00,12.50,1193.75,'2021-12-16 10:48:51','',''),(2296281,'19','199','1023',467,'Retail Sale Id 1345750',8100.00,0.00,0.00,12.50,1193.75,'2021-12-16 10:57:50','',''),(2296302,'19','199','1023',467,'Retail Sale Id 1345779',8100.00,0.00,0.00,12.50,1193.75,'2021-12-16 11:00:03','',''),(2296343,'19','199','1023',467,'Retail Sale Id 1345815',1944.00,0.00,0.00,3.00,286.50,'2021-12-16 11:05:11','',''),(2296473,'19','199','1023',467,'Retail Sale Id 1345934',1944.00,0.00,0.00,3.00,286.50,'2021-12-16 11:19:20','',''),(2296736,'19','199','1023',467,'Retail Sale Id 1346177',8100.00,0.00,0.00,12.50,1193.75,'2021-12-16 11:50:25','',''),(2296778,'19','199','1023',467,'Retail Sale Id 1346216',8100.00,0.00,0.00,12.50,1193.75,'2021-12-16 11:55:14','',''),(2296876,'19','199','1023',467,'Retail Sale Id 1346269',3240.00,0.00,0.00,5.00,477.50,'2021-12-16 12:06:59','',''),(2296877,'19','199','1023',467,'Retail Sale Id 1346269',6480.00,0.00,0.00,10.00,955.00,'2021-12-16 12:06:59','',''),(2296878,'19','199','1023',467,'Retail Sale Id 1346269',8100.00,0.00,0.00,12.50,1193.75,'2021-12-16 12:06:59','',''),(2296890,'19','199','1023',467,'Retail Sale Id 1346309',1944.00,0.00,0.00,3.00,286.50,'2021-12-16 12:08:38','',''),(2296937,'19','199','1023',467,'Retail Sale Id 1346336',2592.00,0.00,0.00,4.00,382.00,'2021-12-16 12:11:52','',''),(2296976,'19','199','1023',467,'Retail Sale Id 1346368',30600.00,0.00,0.00,50.00,2975.00,'2021-12-16 12:16:30','',''),(2296994,'19','199','1023',467,'Retail Sale Id 1346385',1944.00,0.00,0.00,3.00,286.50,'2021-12-16 12:18:41','',''),(2297015,'19','199','1023',467,'Retail Sale Id 1346408',1944.00,0.00,0.00,3.00,286.50,'2021-12-16 12:21:42','',''),(2297042,'19','199','1023',467,'Retail Sale Id 1346431',1944.00,0.00,0.00,3.00,286.50,'2021-12-16 12:25:03','',''),(2297215,'19','199','1023',467,'Retail Sale Id 1346573',8100.00,0.00,0.00,12.50,1193.75,'2021-12-16 12:44:31','',''),(2297418,'19','199','1023',467,'Retail Sale Id 1346746',3888.00,0.00,0.00,6.00,573.00,'2021-12-16 13:08:24','',''),(2297444,'19','199','1023',467,'Retail Sale Id 1346773',3240.00,0.00,0.00,5.00,477.50,'2021-12-16 13:12:06','',''),(2297512,'19','199','1023',467,'Retail Sale Id 1346842',8100.00,0.00,0.00,12.50,1193.75,'2021-12-16 13:19:35','',''),(2297706,'19','199','1023',467,'Retail Sale Id 1346993',8100.00,0.00,0.00,12.50,1193.75,'2021-12-16 13:36:35','',''),(2297719,'19','199','1023',467,'Retail Sale Id 1347010',3888.00,0.00,0.00,6.00,573.00,'2021-12-16 13:38:17','',''),(2297772,'19','199','1023',467,'Retail Sale Id 1347055',8100.00,0.00,0.00,12.50,1193.75,'2021-12-16 13:43:22','',''),(2297976,'19','199','1023',467,'Retail Sale Id 1347208',8100.00,0.00,0.00,12.50,1193.75,'2021-12-16 14:01:32','',''),(2298115,'19','199','1023',467,'Retail Sale Id 1347306',8100.00,0.00,0.00,12.50,1193.75,'2021-12-16 14:12:43','',''),(2298235,'19','199','1023',467,'Retail Sale Id 1347413',1944.00,0.00,0.00,3.00,286.50,'2021-12-16 14:25:01','',''),(2298343,'19','199','1023',467,'Retail Sale Id 1347528',8100.00,0.00,0.00,12.50,1193.75,'2021-12-16 14:38:36','',''),(2298360,'19','199','1023',467,'Retail Sale Id 1347547',1944.00,0.00,0.00,3.00,286.50,'2021-12-16 14:40:17','',''),(2298719,'19','199','1023',467,'Retail Sale Id 1347775',4050.00,0.00,0.00,6.25,596.88,'2021-12-16 15:09:31','',''),(2298748,'19','199','1023',467,'Retail Sale Id 1347799',4050.00,0.00,0.00,6.25,596.88,'2021-12-16 15:12:15','',''),(2298801,'19','199','1023',467,'Retail Sale Id 1347847',1944.00,0.00,0.00,3.00,286.50,'2021-12-16 15:17:34','',''),(2299100,'19','199','1023',467,'Retail Sale Id 1348039',1944.00,0.00,0.00,3.00,286.50,'2021-12-16 15:37:13','',''),(2299135,'19','199','1023',467,'Retail Sale Id 1348073',2592.00,0.00,0.00,4.00,382.00,'2021-12-16 15:39:57','',''),(2299166,'19','199','1023',467,'Retail Sale Id 1348105',8100.00,0.00,0.00,12.50,1193.75,'2021-12-16 15:42:48','',''),(2299438,'19','199','1023',467,'Retail Sale Id 1348291',3240.00,0.00,0.00,5.00,477.50,'2021-12-16 16:00:26','',''),(2302513,'19','199','1023',467,'Retail Sale Id 1350410',2592.00,0.00,0.00,4.00,382.00,'2021-12-17 08:18:11','',''),(2302544,'19','199','1023',467,'Retail Sale Id 1350438',1944.00,0.00,0.00,3.00,286.50,'2021-12-17 08:20:31','',''),(2302592,'19','199','1023',467,'Retail Sale Id 1350494',3888.00,0.00,0.00,6.00,573.00,'2021-12-17 08:25:13','',''),(2302951,'19','199','1023',467,'Retail Sale Id 1350747',4050.00,0.00,0.00,6.25,596.88,'2021-12-17 08:53:27','',''),(2303079,'19','199','1023',467,'Retail Sale Id 1350837',3240.00,0.00,0.00,5.00,477.50,'2021-12-17 09:04:10','',''),(2303080,'19','199','1023',467,'Retail Sale Id 1350837',3888.00,0.00,0.00,6.00,573.00,'2021-12-17 09:04:10','',''),(2303126,'19','199','1023',467,'Retail Sale Id 1350879',3888.00,0.00,0.00,6.00,573.00,'2021-12-17 09:09:16','',''),(2303198,'19','199','1023',467,'Retail Sale Id 1350899',3240.00,0.00,0.00,5.00,477.50,'2021-12-17 09:12:34','',''),(2303238,'19','199','1023',467,'Retail Sale Id 1350919',2592.00,0.00,0.00,4.00,382.00,'2021-12-17 09:15:54','',''),(2303250,'19','199','1023',467,'Retail Sale Id 1350931',1944.00,0.00,0.00,3.00,286.50,'2021-12-17 09:17:34','',''),(2303397,'19','199','1023',467,'Retail Sale Id 1351051',1944.00,0.00,0.00,3.00,286.50,'2021-12-17 09:31:22','',''),(2303398,'19','199','1023',467,'Retail Sale Id 1351051',1944.00,0.00,0.00,3.00,286.50,'2021-12-17 09:31:22','',''),(2303399,'19','199','1023',467,'Retail Sale Id 1351051',8100.00,0.00,0.00,12.50,1193.75,'2021-12-17 09:31:22','',''),(2303668,'19','199','1023',467,'Retail Sale Id 1351241',8100.00,0.00,0.00,12.50,1193.75,'2021-12-17 09:52:07','',''),(2303859,'19','199','1023',467,'Retail Sale Id 1351459',2592.00,0.00,0.00,4.00,382.00,'2021-12-17 10:13:04','',''),(2303930,'19','199','1023',467,'Retail Sale Id 1351523',8100.00,0.00,0.00,12.50,1193.75,'2021-12-17 10:20:53','',''),(2303997,'19','199','1023',467,'Retail Sale Id 1351588',8100.00,0.00,0.00,12.50,1193.75,'2021-12-17 10:29:24','',''),(2304221,'19','199','1023',467,'Retail Sale Id 1351807',8100.00,0.00,0.00,12.50,1193.75,'2021-12-17 10:56:57','',''),(2304349,'19','199','1023',467,'Retail Sale Id 1351923',8100.00,0.00,0.00,12.50,1193.75,'2021-12-17 11:09:43','',''),(2304565,'19','199','1023',467,'Retail Sale Id 1352107',1944.00,0.00,0.00,3.00,286.50,'2021-12-17 11:27:21','',''),(2304566,'19','199','1023',467,'Retail Sale Id 1352107',1944.00,0.00,0.00,3.00,286.50,'2021-12-17 11:27:21','',''),(2304697,'19','199','1023',467,'Retail Sale Id 1352237',6480.00,0.00,0.00,10.00,955.00,'2021-12-17 11:42:01','',''),(2304727,'19','199','1023',467,'Retail Sale Id 1352268',1944.00,0.00,0.00,3.00,286.50,'2021-12-17 11:45:36','',''),(2304738,'19','199','1023',467,'Retail Sale Id 1352296',1944.00,0.00,0.00,3.00,286.50,'2021-12-17 11:47:18','',''),(2304794,'19','199','1023',467,'Retail Sale Id 1352338',4050.00,0.00,0.00,6.25,596.88,'2021-12-17 11:53:56','',''),(2304859,'19','199','1023',467,'Retail Sale Id 1352378',8100.00,0.00,0.00,12.50,1193.75,'2021-12-17 12:00:53','',''),(2304889,'19','199','1023',467,'Retail Sale Id 1352408',2592.00,0.00,0.00,4.00,382.00,'2021-12-17 12:04:25','',''),(2305576,'19','199','1023',467,'Retail Sale Id 1353067',8100.00,0.00,0.00,12.50,1193.75,'2021-12-17 13:42:03','',''),(2305614,'19','199','1023',467,'Retail Sale Id 1353087',3240.00,0.00,0.00,5.00,477.50,'2021-12-17 13:44:48','',''),(2305894,'19','199','1023',467,'Retail Sale Id 1353296',1944.00,0.00,0.00,3.00,286.50,'2021-12-17 14:12:27','',''),(2305917,'19','199','1023',467,'Retail Sale Id 1353316',5184.00,0.00,0.00,8.00,764.00,'2021-12-17 14:15:18','',''),(2305938,'19','199','1023',467,'Retail Sale Id 1353338',3888.00,0.00,0.00,6.00,573.00,'2021-12-17 14:19:08','',''),(2305950,'19','199','1023',467,'Retail Sale Id 1353351',8100.00,0.00,0.00,12.50,1193.75,'2021-12-17 14:21:02','',''),(2306006,'19','199','1023',467,'Retail Sale Id 1353394',1944.00,0.00,0.00,3.00,286.50,'2021-12-17 14:27:31','',''),(2306025,'19','199','1023',467,'Retail Sale Id 1353412',2592.00,0.00,0.00,4.00,382.00,'2021-12-17 14:30:03','',''),(2306064,'19','199','1023',467,'Retail Sale Id 1353447',8100.00,0.00,0.00,12.50,1193.75,'2021-12-17 14:33:47','',''),(2306092,'19','199','1023',467,'Retail Sale Id 1353478',2592.00,0.00,0.00,4.00,382.00,'2021-12-17 14:36:07','',''),(2306283,'19','199','1023',467,'Retail Sale Id 1353615',6480.00,0.00,0.00,10.00,955.00,'2021-12-17 14:49:50','',''),(2306395,'19','199','1023',467,'Retail Sale Id 1353671',6480.00,0.00,0.00,10.00,955.00,'2021-12-17 14:56:22','',''),(2306423,'19','199','1023',467,'Retail Sale Id 1353698',3888.00,0.00,0.00,6.00,573.00,'2021-12-17 15:00:21','',''),(2306636,'19','199','1023',467,'Retail Sale Id 1353885',8100.00,0.00,0.00,12.50,1193.75,'2021-12-17 15:20:36','',''),(2306877,'19','199','1023',467,'Retail Sale Id 1354055',1944.00,0.00,0.00,3.00,286.50,'2021-12-17 15:36:59','',''),(2306878,'19','199','1023',467,'Retail Sale Id 1354055',3888.00,0.00,0.00,6.00,573.00,'2021-12-17 15:36:59','',''),(2306919,'19','199','1023',467,'Retail Sale Id 1354078',1944.00,0.00,0.00,3.00,286.50,'2021-12-17 15:39:41','',''),(2306920,'19','199','1023',467,'Retail Sale Id 1354078',8100.00,0.00,0.00,12.50,1193.75,'2021-12-17 15:39:41','',''),(2307189,'19','199','1023',467,'Retail Sale Id 1354344',3240.00,0.00,0.00,5.00,477.50,'2021-12-17 16:00:42','',''),(2307289,'19','199','1023',467,'Retail Sale Id 1354449',4050.00,0.00,0.00,6.25,596.88,'2021-12-17 16:10:20','',''),(2310138,'19','199','1023',467,'Retail Sale Id 1356345',4050.00,0.00,0.00,6.25,596.88,'2021-12-18 07:54:08','',''),(2310316,'19','199','1023',467,'Retail Sale Id 1356495',3240.00,0.00,0.00,5.00,477.50,'2021-12-18 08:09:51','',''),(2310460,'19','199','1023',467,'Retail Sale Id 1356606',4050.00,0.00,0.00,6.25,596.88,'2021-12-18 08:22:10','',''),(2310531,'19','199','1023',467,'Retail Sale Id 1356649',8100.00,0.00,0.00,12.50,1193.75,'2021-12-18 08:25:44','',''),(2310689,'19','199','1023',467,'Retail Sale Id 1356786',2592.00,0.00,0.00,4.00,382.00,'2021-12-18 08:38:24','',''),(2310805,'19','199','1023',467,'Retail Sale Id 1356897',8100.00,0.00,0.00,12.50,1193.75,'2021-12-18 08:48:55','',''),(2310826,'19','199','1023',467,'Retail Sale Id 1356920',8100.00,0.00,0.00,12.50,1193.75,'2021-12-18 08:50:43','',''),(2310915,'19','199','1023',467,'Retail Sale Id 1356998',1944.00,0.00,0.00,3.00,286.50,'2021-12-18 08:57:37','',''),(2311226,'19','199','1023',467,'Retail Sale Id 1357234',3888.00,0.00,0.00,6.00,573.00,'2021-12-18 09:21:42','',''),(2311458,'19','199','1023',467,'Retail Sale Id 1357470',4860.00,0.00,0.00,7.50,716.25,'2021-12-18 09:45:02','',''),(2311498,'19','199','1023',467,'Retail Sale Id 1357510',4050.00,0.00,0.00,6.25,596.88,'2021-12-18 09:48:35','',''),(2311499,'19','199','1023',467,'Retail Sale Id 1357510',8100.00,0.00,0.00,12.50,1193.75,'2021-12-18 09:48:35','',''),(2311733,'19','199','1023',467,'Retail Sale Id 1357694',1944.00,0.00,0.00,3.00,286.50,'2021-12-18 10:07:38','',''),(2311758,'19','199','1023',467,'Retail Sale Id 1357715',2916.00,0.00,0.00,4.50,429.75,'2021-12-18 10:10:01','',''),(2312015,'19','199','1023',467,'Retail Sale Id 1357923',2916.00,0.00,0.00,4.50,429.75,'2021-12-18 10:30:59','',''),(2312044,'19','199','1023',467,'Retail Sale Id 1357945',2916.00,0.00,0.00,4.50,429.75,'2021-12-18 10:33:20','',''),(2312189,'19','199','1023',467,'Retail Sale Id 1358090',2592.00,0.00,0.00,4.00,382.00,'2021-12-18 10:44:31','',''),(2312228,'19','199','1023',467,'Retail Sale Id 1358131',1944.00,0.00,0.00,3.00,286.50,'2021-12-18 10:48:39','',''),(2312263,'19','199','1023',467,'Retail Sale Id 1358150',8100.00,0.00,0.00,12.50,1193.75,'2021-12-18 10:50:47','',''),(2312293,'19','199','1023',467,'Retail Sale Id 1358175',8100.00,0.00,0.00,12.50,1193.75,'2021-12-18 10:53:14','',''),(2312554,'19','199','1023',467,'Retail Sale Id 1358400',8100.00,0.00,0.00,12.50,1193.75,'2021-12-18 11:13:26','',''),(2312629,'19','199','1023',467,'Retail Sale Id 1358445',3888.00,0.00,0.00,6.00,573.00,'2021-12-18 11:17:37','',''),(2312687,'19','199','1023',467,'Retail Sale Id 1358500',8100.00,0.00,0.00,12.50,1193.75,'2021-12-18 11:22:57','',''),(2312726,'19','199','1023',467,'Retail Sale Id 1358542',1944.00,0.00,0.00,3.00,286.50,'2021-12-18 11:25:57','',''),(2312749,'19','199','1023',467,'Retail Sale Id 1358486',3888.00,0.00,0.00,6.00,573.00,'2021-12-18 11:27:49','',''),(2312917,'19','199','1023',467,'Retail Sale Id 1358726',4050.00,0.00,0.00,6.25,596.88,'2021-12-18 11:41:42','',''),(2326797,'19','199','1023',467,'Retail Sale Id 1370042',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 07:34:38','',''),(2327193,'19','199','1023',467,'Retail Sale Id 1370340',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 08:15:35','',''),(2327486,'19','199','1023',467,'Retail Sale Id 1370628',4050.00,0.00,0.00,6.25,596.88,'2021-12-20 08:53:24','',''),(2327518,'19','199','1023',467,'Retail Sale Id 1370643',3888.00,0.00,0.00,6.00,573.00,'2021-12-20 08:55:35','',''),(2327574,'19','199','1023',467,'Retail Sale Id 1370684',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 09:03:50','',''),(2327698,'19','199','1023',467,'Retail Sale Id 1370790',1944.00,0.00,0.00,3.00,286.50,'2021-12-20 09:19:07','',''),(2327699,'19','199','1023',467,'Retail Sale Id 1370790',3888.00,0.00,0.00,6.00,573.00,'2021-12-20 09:19:07','',''),(2327716,'19','199','1023',467,'Retail Sale Id 1370807',3888.00,0.00,0.00,6.00,573.00,'2021-12-20 09:21:52','',''),(2327746,'19','199','1023',467,'Retail Sale Id 1370828',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 09:26:26','',''),(2328058,'19','199','1023',467,'Retail Sale Id 1371039',3888.00,0.00,0.00,6.00,573.00,'2021-12-20 10:01:22','',''),(2328059,'19','199','1023',467,'Retail Sale Id 1371039',3888.00,0.00,0.00,6.00,573.00,'2021-12-20 10:01:22','',''),(2328114,'19','199','1023',467,'Retail Sale Id 1371095',4050.00,0.00,0.00,6.25,596.88,'2021-12-20 10:08:44','',''),(2328139,'19','199','1023',467,'Retail Sale Id 1371114',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 10:13:02','',''),(2328156,'19','199','1023',467,'Retail Sale Id 1371129',3240.00,0.00,0.00,5.00,477.50,'2021-12-20 10:15:11','',''),(2328171,'19','199','1023',467,'Retail Sale Id 1371140',3240.00,0.00,0.00,5.00,477.50,'2021-12-20 10:17:08','',''),(2328183,'19','199','1023',467,'Retail Sale Id 1371155',4050.00,0.00,0.00,6.25,596.88,'2021-12-20 10:19:10','',''),(2328244,'19','199','1023',467,'Retail Sale Id 1371214',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 10:26:50','',''),(2328540,'19','199','1023',467,'Retail Sale Id 1371487',1944.00,0.00,0.00,3.00,286.50,'2021-12-20 10:56:40','',''),(2328680,'19','199','1023',467,'Retail Sale Id 1371610',1944.00,0.00,0.00,3.00,286.50,'2021-12-20 11:09:12','',''),(2328705,'19','199','1023',467,'Retail Sale Id 1371642',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 11:11:38','',''),(2328706,'19','199','1023',467,'Retail Sale Id 1371642',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 11:11:38','',''),(2328757,'19','199','1023',467,'Retail Sale Id 1371689',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 11:16:56','',''),(2328801,'19','199','1023',467,'Retail Sale Id 1371729',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 11:21:48','',''),(2328978,'19','199','1023',467,'Retail Sale Id 1371887',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 11:41:37','',''),(2328979,'19','199','1023',467,'Retail Sale Id 1371887',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 11:41:37','',''),(2329015,'19','199','1023',467,'Retail Sale Id 1371944',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 11:44:42','',''),(2329016,'19','199','1023',467,'Retail Sale Id 1371944',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 11:44:42','',''),(2329109,'19','199','1023',467,'Retail Sale Id 1372033',3240.00,0.00,0.00,5.00,477.50,'2021-12-20 11:56:30','',''),(2329128,'19','199','1023',467,'Retail Sale Id 1372054',4050.00,0.00,0.00,6.25,596.88,'2021-12-20 11:59:29','',''),(2329400,'19','199','1023',467,'Retail Sale Id 1372293',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 12:28:55','',''),(2329605,'19','199','1023',467,'Retail Sale Id 1372423',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 12:44:10','',''),(2329815,'19','199','1023',467,'Retail Sale Id 1372565',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 13:03:14','',''),(2329841,'19','199','1023',467,'Retail Sale Id 1372585',3564.00,0.00,0.00,5.50,525.25,'2021-12-20 13:07:06','',''),(2329855,'19','199','1023',467,'Retail Sale Id 1372599',1944.00,0.00,0.00,3.00,286.50,'2021-12-20 13:09:09','',''),(2329856,'19','199','1023',467,'Retail Sale Id 1372599',1944.00,0.00,0.00,3.00,286.50,'2021-12-20 13:09:09','',''),(2329862,'19','199','1023',467,'Retail Sale Id 1372605',1944.00,0.00,0.00,3.00,286.50,'2021-12-20 13:10:38','',''),(2329894,'19','199','1023',467,'Retail Sale Id 1372633',3888.00,0.00,0.00,6.00,573.00,'2021-12-20 13:13:48','',''),(2330000,'19','199','1023',467,'Retail Sale Id 1372682',3240.00,0.00,0.00,5.00,477.50,'2021-12-20 13:22:19','',''),(2330001,'19','199','1023',467,'Retail Sale Id 1372682',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 13:22:19','',''),(2330140,'19','199','1023',467,'Retail Sale Id 1372792',1296.00,0.00,0.00,2.00,191.00,'2021-12-20 13:32:52','',''),(2330338,'19','199','1023',467,'Retail Sale Id 1372907',3888.00,0.00,0.00,6.00,573.00,'2021-12-20 13:49:50','',''),(2330561,'19','199','1023',467,'Retail Sale Id 1373059',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 14:07:08','',''),(2330605,'19','199','1023',467,'Retail Sale Id 1373105',1944.00,0.00,0.00,3.00,286.50,'2021-12-20 14:12:29','',''),(2330694,'19','199','1023',467,'Retail Sale Id 1373182',1944.00,0.00,0.00,3.00,286.50,'2021-12-20 14:22:14','',''),(2330779,'19','199','1023',467,'Retail Sale Id 1373228',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 14:28:57','',''),(2330946,'19','199','1023',467,'Retail Sale Id 1373323',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 14:41:41','',''),(2331085,'19','199','1023',467,'Retail Sale Id 1373431',3888.00,0.00,0.00,6.00,573.00,'2021-12-20 14:53:38','',''),(2331190,'19','199','1023',467,'Retail Sale Id 1373518',1944.00,0.00,0.00,3.00,286.50,'2021-12-20 15:03:29','',''),(2331384,'19','199','1023',467,'Retail Sale Id 1373696',5184.00,0.00,0.00,8.00,764.00,'2021-12-20 15:26:27','',''),(2331522,'19','199','1023',467,'Retail Sale Id 1373800',3888.00,0.00,0.00,6.00,573.00,'2021-12-20 15:36:29','',''),(2331593,'19','199','1023',467,'Retail Sale Id 1373865',1944.00,0.00,0.00,3.00,286.50,'2021-12-20 15:42:53','',''),(2331695,'19','199','1023',467,'Retail Sale Id 1373936',1944.00,0.00,0.00,3.00,286.50,'2021-12-20 15:51:37','',''),(2331696,'19','199','1023',467,'Retail Sale Id 1373936',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 15:51:37','',''),(2331719,'19','199','1023',467,'Retail Sale Id 1373961',1944.00,0.00,0.00,3.00,286.50,'2021-12-20 15:54:33','',''),(2331834,'19','199','1023',467,'Retail Sale Id 1374080',8100.00,0.00,0.00,12.50,1193.75,'2021-12-20 16:06:37','',''),(2334040,'19','199','1023',467,'Retail Sale Id 1375542',1944.00,0.00,0.00,3.00,286.50,'2021-12-21 07:37:10','',''),(2334041,'19','199','1023',467,'Retail Sale Id 1375542',8100.00,0.00,0.00,12.50,1193.75,'2021-12-21 07:37:10','',''),(2334042,'19','199','1023',467,'Retail Sale Id 1375542',8100.00,0.00,0.00,12.50,1193.75,'2021-12-21 07:37:10','',''),(2334066,'19','199','1023',467,'Retail Sale Id 1375570',1944.00,0.00,0.00,3.00,286.50,'2021-12-21 07:40:47','',''),(2334242,'19','199','1023',467,'Retail Sale Id 1375705',3888.00,0.00,0.00,6.00,573.00,'2021-12-21 07:54:57','',''),(2334350,'19','199','1023',467,'Retail Sale Id 1375816',8100.00,0.00,0.00,12.50,1193.75,'2021-12-21 08:04:07','',''),(2334468,'19','199','1023',467,'Retail Sale Id 1375898',4050.00,0.00,0.00,6.25,596.88,'2021-12-21 08:13:25','',''),(2334575,'19','199','1023',467,'Retail Sale Id 1375981',8100.00,0.00,0.00,12.50,1193.75,'2021-12-21 08:28:20','',''),(2334576,'19','199','1023',467,'Retail Sale Id 1375981',8100.00,0.00,0.00,12.50,1193.75,'2021-12-21 08:28:20','',''),(2334685,'19','199','1023',467,'Retail Sale Id 1376100',3240.00,0.00,0.00,5.00,477.50,'2021-12-21 08:47:07','',''),(2335024,'19','199','1023',467,'Retail Sale Id 1376352',1944.00,0.00,0.00,3.00,286.50,'2021-12-21 09:22:26','',''),(2335317,'19','199','1023',467,'Retail Sale Id 1376601',1944.00,0.00,0.00,3.00,286.50,'2021-12-21 09:53:28','',''),(2335318,'19','199','1023',467,'Retail Sale Id 1376601',3888.00,0.00,0.00,6.00,573.00,'2021-12-21 09:53:28','',''),(2335419,'19','199','1023',467,'Retail Sale Id 1376716',8100.00,0.00,0.00,12.50,1193.75,'2021-12-21 10:07:47','',''),(2335450,'19','199','1023',467,'Retail Sale Id 1376748',3888.00,0.00,0.00,6.00,573.00,'2021-12-21 10:11:52','',''),(2335510,'19','199','1023',467,'Retail Sale Id 1376810',1944.00,0.00,0.00,3.00,286.50,'2021-12-21 10:21:26','',''),(2335961,'19','199','1023',467,'Retail Sale Id 1377121',4536.00,0.00,0.00,7.00,668.50,'2021-12-21 11:02:37','',''),(2336290,'19','199','1023',467,'Retail Sale Id 1377405',8100.00,0.00,0.00,12.50,1193.75,'2021-12-21 11:39:17','',''),(2336291,'19','199','1023',467,'Retail Sale Id 1377405',8100.00,0.00,0.00,12.50,1193.75,'2021-12-21 11:39:17','',''),(2336311,'19','199','1023',467,'Retail Sale Id 1377423',8100.00,0.00,0.00,12.50,1193.75,'2021-12-21 11:41:56','',''),(2336391,'19','199','1023',467,'Retail Sale Id 1377492',1944.00,0.00,0.00,3.00,286.50,'2021-12-21 11:52:45','',''),(2336409,'19','199','1023',467,'Retail Sale Id 1377511',3240.00,0.00,0.00,5.00,477.50,'2021-12-21 11:55:01','',''),(2336485,'19','199','1023',467,'Retail Sale Id 1377568',3888.00,0.00,0.00,6.00,573.00,'2021-12-21 12:03:04','',''),(2336671,'19','199','1023',467,'Retail Sale Id 1377742',3240.00,0.00,0.00,5.00,477.50,'2021-12-21 12:25:57','',''),(2336686,'19','199','1023',467,'Retail Sale Id 1377756',8100.00,0.00,0.00,12.50,1193.75,'2021-12-21 12:28:02','',''),(2336706,'19','199','1023',467,'Retail Sale Id 1377773',1944.00,0.00,0.00,3.00,286.50,'2021-12-21 12:31:01','',''),(2337038,'19','199','1023',467,'Retail Sale Id 1378063',7776.00,0.00,0.00,12.00,1146.00,'2021-12-21 13:06:31','',''),(2337039,'19','199','1023',467,'Retail Sale Id 1378063',7776.00,0.00,0.00,12.00,1146.00,'2021-12-21 13:06:31','',''),(2337063,'19','199','1023',467,'Retail Sale Id 1378095',1944.00,0.00,0.00,3.00,286.50,'2021-12-21 13:08:34','',''),(2337114,'19','199','1023',467,'Retail Sale Id 1378134',8100.00,0.00,0.00,12.50,1193.75,'2021-12-21 13:12:22','',''),(2337287,'19','199','1023',467,'Retail Sale Id 1378294',3888.00,0.00,0.00,6.00,573.00,'2021-12-21 13:30:59','',''),(2337314,'19','199','1023',467,'Retail Sale Id 1378323',1944.00,0.00,0.00,3.00,286.50,'2021-12-21 13:33:38','',''),(2337608,'19','199','1023',467,'Retail Sale Id 1378488',7128.00,0.00,0.00,11.00,1050.50,'2021-12-21 13:53:16','',''),(2337716,'19','199','1023',467,'Retail Sale Id 1378600',8100.00,0.00,0.00,12.50,1193.75,'2021-12-21 14:05:24','',''),(2337782,'19','199','1023',467,'Retail Sale Id 1378669',1944.00,0.00,0.00,3.00,286.50,'2021-12-21 14:12:35','',''),(2337839,'19','199','1023',467,'Retail Sale Id 1378712',3240.00,0.00,0.00,5.00,477.50,'2021-12-21 14:17:30','',''),(2337914,'19','199','1023',467,'Retail Sale Id 1378738',8100.00,0.00,0.00,12.50,1193.75,'2021-12-21 14:20:28','',''),(2337944,'19','199','1023',467,'Retail Sale Id 1378763',8100.00,0.00,0.00,12.50,1193.75,'2021-12-21 14:23:51','',''),(2338012,'19','199','1023',467,'Retail Sale Id 1378831',8100.00,0.00,0.00,12.50,1193.75,'2021-12-21 14:28:50','',''),(2338013,'19','199','1023',467,'Retail Sale Id 1378831',8100.00,0.00,0.00,12.50,1193.75,'2021-12-21 14:28:50','',''),(2338147,'19','199','1023',467,'Retail Sale Id 1378970',1944.00,0.00,0.00,3.00,286.50,'2021-12-21 14:41:38','',''),(2338195,'19','199','1023',467,'Retail Sale Id 1379017',8100.00,0.00,0.00,12.50,1193.75,'2021-12-21 14:45:30','',''),(2338275,'19','199','1023',467,'Retail Sale Id 1379090',1944.00,0.00,0.00,3.00,286.50,'2021-12-21 14:52:36','',''),(2338485,'19','199','1023',467,'Retail Sale Id 1379263',1944.00,0.00,0.00,3.00,286.50,'2021-12-21 15:08:43','',''),(2338750,'19','199','1023',467,'Retail Sale Id 1379501',8100.00,0.00,0.00,12.50,1193.75,'2021-12-21 15:32:22','',''),(2338795,'19','199','1023',467,'Retail Sale Id 1379532',8100.00,0.00,0.00,12.50,1193.75,'2021-12-21 15:35:09','',''),(2338865,'19','199','1023',467,'Retail Sale Id 1379571',3240.00,0.00,0.00,5.00,477.50,'2021-12-21 15:37:56','',''),(2338937,'19','199','1023',467,'Retail Sale Id 1379608',1944.00,0.00,0.00,3.00,286.50,'2021-12-21 15:40:51','',''),(2339026,'19','199','1023',467,'Retail Sale Id 1379692',1944.00,0.00,0.00,3.00,286.50,'2021-12-21 15:47:00','',''),(2339219,'19','199','1023',467,'Retail Sale Id 1379862',6480.00,0.00,0.00,10.00,955.00,'2021-12-21 16:00:03','',''),(2339247,'19','199','1023',467,'Retail Sale Id 1379885',3240.00,0.00,0.00,5.00,477.50,'2021-12-21 16:01:42','',''),(2339271,'19','199','1023',467,'Retail Sale Id 1379909',3240.00,0.00,0.00,5.00,477.50,'2021-12-21 16:03:42','',''),(2341974,'19','199','1023',467,'Retail Sale Id 1381825',3888.00,0.00,0.00,6.00,573.00,'2021-12-22 07:28:54','',''),(2342161,'19','199','1023',467,'Retail Sale Id 1381967',1944.00,0.00,0.00,3.00,286.50,'2021-12-22 07:43:14','',''),(2342209,'19','199','1023',467,'Retail Sale Id 1382006',8100.00,0.00,0.00,12.50,1193.75,'2021-12-22 07:46:18','',''),(2342270,'19','199','1023',467,'Retail Sale Id 1382046',8100.00,0.00,0.00,12.50,1193.75,'2021-12-22 07:49:28','',''),(2342594,'19','199','1023',467,'Retail Sale Id 1382293',3888.00,0.00,0.00,6.00,573.00,'2021-12-22 08:09:17','',''),(2342595,'19','199','1023',467,'Retail Sale Id 1382293',3888.00,0.00,0.00,6.00,573.00,'2021-12-22 08:09:17','',''),(2342692,'19','199','1023',467,'Retail Sale Id 1382389',5184.00,0.00,0.00,8.00,764.00,'2021-12-22 08:16:30','',''),(2342977,'19','199','1023',467,'Retail Sale Id 1382600',1944.00,0.00,0.00,3.00,286.50,'2021-12-22 08:33:51','',''),(2342978,'19','199','1023',467,'Retail Sale Id 1382600',3240.00,0.00,0.00,5.00,477.50,'2021-12-22 08:33:51','',''),(2343238,'19','199','1023',467,'Retail Sale Id 1382845',8100.00,0.00,0.00,12.50,1193.75,'2021-12-22 08:58:25','',''),(2343543,'19','199','1023',467,'Retail Sale Id 1383171',5832.00,0.00,0.00,9.00,859.50,'2021-12-22 09:27:36','',''),(2343864,'19','199','1023',467,'Retail Sale Id 1383435',30600.00,0.00,0.00,50.00,2975.00,'2021-12-22 09:53:55','',''),(2343918,'19','199','1023',467,'Retail Sale Id 1383473',1944.00,0.00,0.00,3.00,286.50,'2021-12-22 09:56:48','',''),(2344140,'19','199','1023',467,'Retail Sale Id 1383696',1944.00,0.00,0.00,3.00,286.50,'2021-12-22 10:18:28','',''),(2344172,'19','199','1023',467,'Retail Sale Id 1383732',8100.00,0.00,0.00,12.50,1193.75,'2021-12-22 10:21:32','',''),(2344217,'19','199','1023',467,'Retail Sale Id 1383775',1944.00,0.00,0.00,3.00,286.50,'2021-12-22 10:27:03','',''),(2344218,'19','199','1023',467,'Retail Sale Id 1383775',1944.00,0.00,0.00,3.00,286.50,'2021-12-22 10:27:03','',''),(2344241,'19','199','1023',467,'Retail Sale Id 1383803',1944.00,0.00,0.00,3.00,286.50,'2021-12-22 10:29:11','',''),(2344322,'19','199','1023',467,'Retail Sale Id 1383884',2916.00,0.00,0.00,4.50,429.75,'2021-12-22 10:37:37','',''),(2344417,'19','199','1023',467,'Retail Sale Id 1383975',8100.00,0.00,0.00,12.50,1193.75,'2021-12-22 10:46:54','',''),(2344653,'19','199','1023',467,'Retail Sale Id 1384206',1944.00,0.00,0.00,3.00,286.50,'2021-12-22 11:08:56','',''),(2344815,'19','199','1023',467,'Retail Sale Id 1384356',8100.00,0.00,0.00,12.50,1193.75,'2021-12-22 11:24:22','',''),(2344925,'19','199','1023',467,'Retail Sale Id 1384463',5184.00,0.00,0.00,8.00,764.00,'2021-12-22 11:35:13','',''),(2344945,'19','199','1023',467,'Retail Sale Id 1384482',8100.00,0.00,0.00,12.50,1193.75,'2021-12-22 11:36:34','',''),(2344972,'19','199','1023',467,'Retail Sale Id 1384509',3240.00,0.00,0.00,5.00,477.50,'2021-12-22 11:38:42','',''),(2345009,'19','199','1023',467,'Retail Sale Id 1384537',3888.00,0.00,0.00,6.00,573.00,'2021-12-22 11:42:45','',''),(2345010,'19','199','1023',467,'Retail Sale Id 1384537',8100.00,0.00,0.00,12.50,1193.75,'2021-12-22 11:42:45','',''),(2345047,'19','199','1023',467,'Retail Sale Id 1384579',1944.00,0.00,0.00,3.00,286.50,'2021-12-22 11:46:22','',''),(2345094,'19','199','1023',467,'Retail Sale Id 1384625',8100.00,0.00,0.00,12.50,1193.75,'2021-12-22 11:52:00','',''),(2345111,'19','199','1023',467,'Retail Sale Id 1384644',8100.00,0.00,0.00,12.50,1193.75,'2021-12-22 11:53:38','',''),(2345288,'19','199','1023',467,'Retail Sale Id 1384819',6156.00,0.00,0.00,9.50,907.25,'2021-12-22 12:12:39','',''),(2345439,'19','199','1023',467,'Retail Sale Id 1384924',1944.00,0.00,0.00,3.00,286.50,'2021-12-22 12:26:00','',''),(2345552,'19','199','1023',467,'Retail Sale Id 1385037',8100.00,0.00,0.00,12.50,1193.75,'2021-12-22 12:40:44','',''),(2345639,'19','199','1023',467,'Retail Sale Id 1385114',1944.00,0.00,0.00,3.00,286.50,'2021-12-22 12:50:03','',''),(2345751,'19','199','1023',467,'Retail Sale Id 1385197',8100.00,0.00,0.00,12.50,1193.75,'2021-12-22 12:58:54','',''),(2345914,'19','199','1023',467,'Retail Sale Id 1385345',8100.00,0.00,0.00,12.50,1193.75,'2021-12-22 13:16:48','',''),(2346146,'19','199','1023',467,'Retail Sale Id 1385535',8100.00,0.00,0.00,12.50,1193.75,'2021-12-22 13:40:08','',''),(2346224,'19','199','1023',467,'Retail Sale Id 1385574',8100.00,0.00,0.00,12.50,1193.75,'2021-12-22 13:45:05','',''),(2346813,'19','199','1023',467,'Retail Sale Id 1385980',3888.00,0.00,0.00,6.00,573.00,'2021-12-22 14:37:51','',''),(2346865,'19','199','1023',467,'Retail Sale Id 1386002',4050.00,0.00,0.00,6.25,596.88,'2021-12-22 14:41:08','',''),(2347037,'19','199',NULL,467,'Purchased from Kwale Hydrocarbon Nigeria Limi',0.00,12300000.00,24000.00,0.00,0.00,'2021-12-22 14:59:23','',''),(2347596,'19','199','1023',467,'Retail Sale Id 1386584',8100.00,0.00,0.00,12.50,1693.75,'2021-12-22 15:44:07','',''),(2347657,'19','199','1023',467,'Retail Sale Id 1386651',1944.00,0.00,0.00,3.00,406.50,'2021-12-22 15:49:58','',''),(2347717,'19','199','1023',467,'Retail Sale Id 1386694',3888.00,0.00,0.00,6.00,813.00,'2021-12-22 15:54:58','',''),(2347761,'19','199','1023',467,'Retail Sale Id 1386715',6480.00,0.00,0.00,10.00,1355.00,'2021-12-22 15:57:52','',''),(2347778,'19','199','1023',467,'Retail Sale Id 1386733',1944.00,0.00,0.00,3.00,406.50,'2021-12-22 15:59:43','',''),(2351310,'19','199','1023',467,'Retail Sale Id 1389236',1944.00,0.00,0.00,3.00,406.50,'2021-12-23 08:56:51','',''),(2351336,'19','199','1023',467,'Retail Sale Id 1389259',1944.00,0.00,0.00,3.00,406.50,'2021-12-23 08:59:39','',''),(2351396,'19','199','1023',467,'Retail Sale Id 1389321',3888.00,0.00,0.00,6.00,813.00,'2021-12-23 09:06:26','',''),(2351722,'19','199','1023',467,'Retail Sale Id 1389619',8100.00,0.00,0.00,12.50,1693.75,'2021-12-23 09:35:48','',''),(2351915,'19','199','1023',467,'Retail Sale Id 1389782',3888.00,0.00,0.00,6.00,813.00,'2021-12-23 09:48:06','',''),(2352210,'19','199','1023',467,'Retail Sale Id 1389957',3888.00,0.00,0.00,6.00,813.00,'2021-12-23 10:03:40','',''),(2352229,'19','199','1023',467,'Retail Sale Id 1389979',6480.00,0.00,0.00,10.00,1355.00,'2021-12-23 10:05:44','',''),(2352330,'19','199','1023',467,'Retail Sale Id 1390087',8100.00,0.00,0.00,12.50,1693.75,'2021-12-23 10:16:54','',''),(2352464,'19','199','1023',467,'Retail Sale Id 1390213',8100.00,0.00,0.00,12.50,1693.75,'2021-12-23 10:28:57','',''),(2352737,'19','199','1023',467,'Retail Sale Id 1390493',1944.00,0.00,0.00,3.00,406.50,'2021-12-23 10:53:18','',''),(2352738,'19','199','1023',467,'Retail Sale Id 1390493',1944.00,0.00,0.00,3.00,406.50,'2021-12-23 10:53:18','',''),(2352739,'19','199','1023',467,'Retail Sale Id 1390493',1944.00,0.00,0.00,3.00,406.50,'2021-12-23 10:53:18','',''),(2352855,'19','199','1023',467,'Retail Sale Id 1390608',4050.00,0.00,0.00,6.25,846.88,'2021-12-23 11:03:54','',''),(2352888,'19','199','1023',467,'Retail Sale Id 1390641',3888.00,0.00,0.00,6.00,813.00,'2021-12-23 11:07:18','',''),(2353028,'19','199','1023',467,'Retail Sale Id 1390773',8100.00,0.00,0.00,12.50,1693.75,'2021-12-23 11:19:38','',''),(2353123,'19','199','1023',467,'Retail Sale Id 1390870',8100.00,0.00,0.00,12.50,1693.75,'2021-12-23 11:30:04','',''),(2353399,'19','199','1023',467,'Retail Sale Id 1391138',3888.00,0.00,0.00,6.00,813.00,'2021-12-23 11:57:17','',''),(2353823,'19','199','1023',467,'Retail Sale Id 1391495',3888.00,0.00,0.00,6.00,813.00,'2021-12-23 12:33:08','',''),(2353955,'19','199','1023',467,'Retail Sale Id 1391598',5184.00,0.00,0.00,8.00,1084.00,'2021-12-23 12:44:06','',''),(2354050,'19','199','1023',467,'Retail Sale Id 1391691',1944.00,0.00,0.00,3.00,406.50,'2021-12-23 12:51:51','',''),(2354161,'19','199','1023',467,'Retail Sale Id 1391796',8100.00,0.00,0.00,12.50,1693.75,'2021-12-23 13:02:15','',''),(2354245,'19','199','1023',467,'Retail Sale Id 1391879',5184.00,0.00,0.00,8.00,1084.00,'2021-12-23 13:11:05','',''),(2354386,'19','199','1023',467,'Retail Sale Id 1392023',1944.00,0.00,0.00,3.00,406.50,'2021-12-23 13:24:59','',''),(2354387,'19','199','1023',467,'Retail Sale Id 1392023',1944.00,0.00,0.00,3.00,406.50,'2021-12-23 13:24:59','',''),(2354549,'19','199','1023',467,'Retail Sale Id 1392150',8100.00,0.00,0.00,12.50,1693.75,'2021-12-23 13:37:58','',''),(2354658,'19','199','1023',467,'Retail Sale Id 1392269',1944.00,0.00,0.00,3.00,406.50,'2021-12-23 13:47:19','',''),(2355854,'19','199','1023',467,'Retail Sale Id 1393167',3240.00,0.00,0.00,5.00,677.50,'2021-12-23 15:19:16','',''),(2355872,'19','199','1023',467,'Retail Sale Id 1393187',4050.00,0.00,0.00,6.25,846.88,'2021-12-23 15:20:56','',''),(2356030,'19','199','1023',467,'Retail Sale Id 1393335',8100.00,0.00,0.00,12.50,1693.75,'2021-12-23 15:34:53','',''),(2356129,'19','199','1023',467,'Retail Sale Id 1393419',3888.00,0.00,0.00,6.00,813.00,'2021-12-23 15:43:16','',''),(2356216,'19','199','1023',467,'Retail Sale Id 1393510',1944.00,0.00,0.00,3.00,406.50,'2021-12-23 15:51:36','',''),(2356250,'19','199','1023',467,'Retail Sale Id 1393549',1944.00,0.00,0.00,3.00,406.50,'2021-12-23 15:54:41','',''),(2356280,'19','199','1023',467,'Retail Sale Id 1393578',1944.00,0.00,0.00,3.00,406.50,'2021-12-23 15:57:00','',''),(2356309,'19','199','1023',467,'Retail Sale Id 1393606',1944.00,0.00,0.00,3.00,406.50,'2021-12-23 16:00:03','',''),(2356334,'19','199','1023',467,'Retail Sale Id 1393633',4050.00,0.00,0.00,6.25,846.88,'2021-12-23 16:02:04','',''),(2356399,'19','199','1023',467,'Retail Sale Id 1393690',3888.00,0.00,0.00,6.00,813.00,'2021-12-23 16:07:17','',''),(2356400,'19','199','1023',467,'Retail Sale Id 1393690',7452.00,0.00,0.00,11.50,1558.25,'2021-12-23 16:07:17','',''),(2356424,'19','199','1023',467,'Retail Sale Id 1393716',4536.00,0.00,0.00,7.00,948.50,'2021-12-23 16:09:25','',''),(2356470,'19','199','1023',467,'Retail Sale Id 1393761',8100.00,0.00,0.00,12.50,1693.75,'2021-12-23 16:13:15','',''),(2359265,'19','199','1023',467,'Retail Sale Id 1395719',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 07:37:47','',''),(2359328,'19','199','1023',467,'Retail Sale Id 1395783',3888.00,0.00,0.00,6.00,813.00,'2021-12-24 07:44:16','',''),(2359346,'19','199','1023',467,'Retail Sale Id 1395803',2592.00,0.00,0.00,4.00,542.00,'2021-12-24 07:45:58','',''),(2359377,'19','199','1023',467,'Retail Sale Id 1395835',3888.00,0.00,0.00,6.00,813.00,'2021-12-24 07:48:38','',''),(2359403,'19','199','1023',467,'Retail Sale Id 1395858',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 07:50:02','',''),(2359434,'19','199','1023',467,'Retail Sale Id 1395887',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 07:52:24','',''),(2359516,'19','199','1023',467,'Retail Sale Id 1395954',1944.00,0.00,0.00,3.00,406.50,'2021-12-24 07:58:35','',''),(2360208,'19','199','1023',467,'Retail Sale Id 1396530',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 08:49:53','',''),(2360252,'19','199','1023',467,'Retail Sale Id 1396587',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 08:52:50','',''),(2360311,'19','199','1023',467,'Retail Sale Id 1396622',3888.00,0.00,0.00,6.00,813.00,'2021-12-24 08:55:26','',''),(2360337,'19','199','1023',467,'Retail Sale Id 1396654',3240.00,0.00,0.00,5.00,677.50,'2021-12-24 08:57:41','',''),(2360338,'19','199','1023',467,'Retail Sale Id 1396654',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 08:57:41','',''),(2360390,'19','199','1023',467,'Retail Sale Id 1396698',1944.00,0.00,0.00,3.00,406.50,'2021-12-24 09:00:39','',''),(2360437,'19','199','1023',467,'Retail Sale Id 1396731',3888.00,0.00,0.00,6.00,813.00,'2021-12-24 09:03:10','',''),(2360672,'19','199','1023',467,'Retail Sale Id 1396929',1944.00,0.00,0.00,3.00,406.50,'2021-12-24 09:22:19','',''),(2360744,'19','199','1023',467,'Retail Sale Id 1396993',1944.00,0.00,0.00,3.00,406.50,'2021-12-24 09:27:45','',''),(2360811,'19','199','1023',467,'Retail Sale Id 1397053',3240.00,0.00,0.00,5.00,677.50,'2021-12-24 09:32:00','',''),(2360940,'19','199','1023',467,'Retail Sale Id 1397188',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 09:41:30','',''),(2361186,'19','199','1023',467,'Retail Sale Id 1397342',3888.00,0.00,0.00,6.00,813.00,'2021-12-24 09:54:06','',''),(2361288,'19','199','1023',467,'Retail Sale Id 1397434',2916.00,0.00,0.00,4.50,609.75,'2021-12-24 10:00:22','',''),(2361559,'19','199','1023',467,'Retail Sale Id 1397690',3888.00,0.00,0.00,6.00,813.00,'2021-12-24 10:21:13','',''),(2361660,'19','199','1023',467,'Retail Sale Id 1397795',5184.00,0.00,0.00,8.00,1084.00,'2021-12-24 10:29:08','',''),(2361848,'19','199','1023',467,'Retail Sale Id 1397994',1944.00,0.00,0.00,3.00,406.50,'2021-12-24 10:46:45','',''),(2361919,'19','199','1023',467,'Retail Sale Id 1398076',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 10:52:55','',''),(2361977,'19','199','1023',467,'Retail Sale Id 1398129',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 10:59:22','',''),(2361999,'19','199','1023',467,'Retail Sale Id 1398149',3888.00,0.00,0.00,6.00,813.00,'2021-12-24 11:00:48','',''),(2362062,'19','199','1023',467,'Retail Sale Id 1398217',1944.00,0.00,0.00,3.00,406.50,'2021-12-24 11:07:33','',''),(2362063,'19','199','1023',467,'Retail Sale Id 1398217',3888.00,0.00,0.00,6.00,813.00,'2021-12-24 11:07:33','',''),(2362261,'19','199','1023',467,'Retail Sale Id 1398423',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 11:28:08','',''),(2362262,'19','199','1023',467,'Retail Sale Id 1398423',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 11:28:08','',''),(2362276,'19','199','1023',467,'Retail Sale Id 1398434',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 11:29:52','',''),(2362297,'19','199','1023',467,'Retail Sale Id 1398455',1944.00,0.00,0.00,3.00,406.50,'2021-12-24 11:31:41','',''),(2362540,'19','199','1023',467,'Retail Sale Id 1398665',1944.00,0.00,0.00,3.00,406.50,'2021-12-24 11:49:44','',''),(2362722,'19','199','1023',467,'Retail Sale Id 1398843',3888.00,0.00,0.00,6.00,813.00,'2021-12-24 12:07:50','',''),(2363089,'19','199','1023',467,'Retail Sale Id 1399208',3888.00,0.00,0.00,6.00,813.00,'2021-12-24 12:47:57','',''),(2363111,'19','199','1023',467,'Retail Sale Id 1399230',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 12:49:57','',''),(2363123,'19','199','1023',467,'Retail Sale Id 1399244',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 12:51:23','',''),(2363212,'19','199','1023',467,'Retail Sale Id 1399339',16200.00,0.00,0.00,25.00,3387.50,'2021-12-24 13:01:14','',''),(2363526,'19','199','1023',467,'Retail Sale Id 1399617',1944.00,0.00,0.00,3.00,406.50,'2021-12-24 13:30:37','',''),(2363564,'19','199','1023',467,'Retail Sale Id 1399651',1944.00,0.00,0.00,3.00,406.50,'2021-12-24 13:34:05','',''),(2363699,'19','199','1023',467,'Retail Sale Id 1399729',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 13:41:16','',''),(2363776,'19','199','1023',467,'Retail Sale Id 1399788',1944.00,0.00,0.00,3.00,406.50,'2021-12-24 13:46:15','',''),(2364008,'19','199','1023',467,'Retail Sale Id 1399964',2592.00,0.00,0.00,4.00,542.00,'2021-12-24 14:02:21','',''),(2364009,'19','199','1023',467,'Retail Sale Id 1399964',3240.00,0.00,0.00,5.00,677.50,'2021-12-24 14:02:21','',''),(2364407,'19','199','1023',467,'Retail Sale Id 1400300',3888.00,0.00,0.00,6.00,813.00,'2021-12-24 14:31:47','',''),(2364511,'19','199','1023',467,'Retail Sale Id 1400371',7776.00,0.00,0.00,12.00,1626.00,'2021-12-24 14:38:45','',''),(2364867,'19','199','1023',467,'Retail Sale Id 1400593',3888.00,0.00,0.00,6.00,813.00,'2021-12-24 15:00:19','',''),(2364868,'19','199','1023',467,'Retail Sale Id 1400593',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 15:00:19','',''),(2364894,'19','199','1023',467,'Retail Sale Id 1400621',4050.00,0.00,0.00,6.25,846.88,'2021-12-24 15:02:47','',''),(2364933,'19','199','1023',467,'Retail Sale Id 1400662',1944.00,0.00,0.00,3.00,406.50,'2021-12-24 15:05:57','',''),(2364958,'19','199','1023',467,'Retail Sale Id 1400684',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 15:08:33','',''),(2364997,'19','199','1023',467,'Retail Sale Id 1400728',3888.00,0.00,0.00,6.00,813.00,'2021-12-24 15:13:00','',''),(2365108,'19','199','1023',467,'Retail Sale Id 1400779',1944.00,0.00,0.00,3.00,406.50,'2021-12-24 15:18:50','',''),(2365109,'19','199','1023',467,'Retail Sale Id 1400779',6480.00,0.00,0.00,10.00,1355.00,'2021-12-24 15:18:50','',''),(2365110,'19','199','1023',467,'Retail Sale Id 1400779',7776.00,0.00,0.00,12.00,1626.00,'2021-12-24 15:18:50','',''),(2365178,'19','199','1023',467,'Retail Sale Id 1400855',1944.00,0.00,0.00,3.00,406.50,'2021-12-24 15:24:13','',''),(2365325,'19','199','1023',467,'Retail Sale Id 1401016',3888.00,0.00,0.00,6.00,813.00,'2021-12-24 15:36:33','',''),(2365345,'19','199','1023',467,'Retail Sale Id 1401035',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 15:38:53','',''),(2365370,'19','199','1023',467,'Retail Sale Id 1401070',3240.00,0.00,0.00,5.00,677.50,'2021-12-24 15:41:08','',''),(2365399,'19','199','1023',467,'Retail Sale Id 1401100',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 15:43:48','',''),(2365473,'19','199','1023',467,'Retail Sale Id 1401177',3888.00,0.00,0.00,6.00,813.00,'2021-12-24 15:50:10','',''),(2365545,'19','199','1023',467,'Retail Sale Id 1401235',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 15:55:54','',''),(2365587,'19','199','1023',467,'Retail Sale Id 1401269',3888.00,0.00,0.00,6.00,813.00,'2021-12-24 16:00:03','',''),(2365588,'19','199','1023',467,'Retail Sale Id 1401269',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 16:00:03','',''),(2366108,'19','199','1023',467,'Retail Sale Id 1401668',8100.00,0.00,0.00,12.50,1693.75,'2021-12-24 16:33:36','',''),(2369045,'19','199','1023',467,'Retail Sale Id 1403892',8100.00,0.00,0.00,12.50,1693.75,'2021-12-25 07:56:11','',''),(2369203,'19','199','1023',467,'Retail Sale Id 1404037',3240.00,0.00,0.00,5.00,677.50,'2021-12-25 08:09:50','',''),(2369594,'19','199','1023',467,'Retail Sale Id 1404394',8100.00,0.00,0.00,12.50,1693.75,'2021-12-25 08:38:16','',''),(2369659,'19','199','1023',467,'Retail Sale Id 1404427',1944.00,0.00,0.00,3.00,406.50,'2021-12-25 08:41:08','',''),(2369921,'19','199','1023',467,'Retail Sale Id 1404693',4996.08,0.00,0.00,7.71,1044.71,'2021-12-25 09:04:09','',''),(2369931,'19','199','1023',467,'Retail Sale Id 1404705',1944.00,0.00,0.00,3.00,406.50,'2021-12-25 09:05:17','',''),(2369958,'19','199','1023',467,'Retail Sale Id 1404736',2592.00,0.00,0.00,4.00,542.00,'2021-12-25 09:08:24','',''),(2370344,'19','199','1023',467,'Retail Sale Id 1405040',8100.00,0.00,0.00,12.50,1693.75,'2021-12-25 09:37:07','',''),(2370654,'19','199','1023',467,'Retail Sale Id 1405322',2916.00,0.00,0.00,4.50,609.75,'2021-12-25 10:06:58','',''),(2370702,'19','199','1023',467,'Retail Sale Id 1405358',8100.00,0.00,0.00,12.50,1693.75,'2021-12-25 10:10:45','',''),(2370812,'19','199','1023',467,'Retail Sale Id 1405462',4050.00,0.00,0.00,6.25,846.88,'2021-12-25 10:23:20','',''),(2370891,'19','199','1023',467,'Retail Sale Id 1405531',3240.00,0.00,0.00,5.00,677.50,'2021-12-25 10:31:36','',''),(2370911,'19','199','1023',467,'Retail Sale Id 1405553',3888.00,0.00,0.00,6.00,813.00,'2021-12-25 10:33:23','',''),(2371198,'19','199','1023',467,'Retail Sale Id 1405847',8100.00,0.00,0.00,12.50,1693.75,'2021-12-25 11:03:43','',''),(2371220,'19','199','1023',467,'Retail Sale Id 1405867',1944.00,0.00,0.00,3.00,406.50,'2021-12-25 11:05:16','',''),(2371297,'19','199','1023',467,'Retail Sale Id 1405946',8100.00,0.00,0.00,12.50,1693.75,'2021-12-25 11:11:37','',''),(2371298,'19','199','1023',467,'Retail Sale Id 1405946',8100.00,0.00,0.00,12.50,1693.75,'2021-12-25 11:11:37','',''),(2371323,'19','199','1023',467,'Retail Sale Id 1405972',8100.00,0.00,0.00,12.50,1693.75,'2021-12-25 11:14:25','',''),(2371342,'19','199','1023',467,'Retail Sale Id 1405992',4996.08,0.00,0.00,7.71,1044.71,'2021-12-25 11:16:12','',''),(2371456,'19','199','1023',467,'Retail Sale Id 1406194',1944.00,0.00,0.00,3.00,406.50,'2021-12-25 11:30:02','',''),(2371457,'19','199','1023',467,'Retail Sale Id 1406194',3888.00,0.00,0.00,6.00,813.00,'2021-12-25 11:30:02','',''),(2371458,'19','199','1023',467,'Retail Sale Id 1406194',8100.00,0.00,0.00,12.50,1693.75,'2021-12-25 11:30:02','',''),(2371572,'19','199','1023',467,'Retail Sale Id 1406298',2916.00,0.00,0.00,4.50,609.75,'2021-12-25 11:41:41','',''),(2371752,'19','199','1023',467,'Retail Sale Id 1406465',1944.00,0.00,0.00,3.00,406.50,'2021-12-25 12:05:22','',''),(2371801,'19','199','1023',467,'Retail Sale Id 1406513',8100.00,0.00,0.00,12.50,1693.75,'2021-12-25 12:12:18','',''),(2371920,'19','199','1023',467,'Retail Sale Id 1406627',1944.00,0.00,0.00,3.00,406.50,'2021-12-25 12:24:52','',''),(2371965,'19','199','1023',467,'Retail Sale Id 1406679',4860.00,0.00,0.00,7.50,1016.25,'2021-12-25 12:30:02','',''),(2371984,'19','199','1023',467,'Retail Sale Id 1406700',1944.00,0.00,0.00,3.00,406.50,'2021-12-25 12:31:43','',''),(2372005,'19','199','1023',467,'Retail Sale Id 1406720',4050.00,0.00,0.00,6.25,846.88,'2021-12-25 12:34:17','',''),(2372090,'19','199','1023',467,'Retail Sale Id 1406793',5184.00,0.00,0.00,8.00,1084.00,'2021-12-25 12:44:04','',''),(2372167,'19','199','1023',467,'Retail Sale Id 1406866',4050.00,0.00,0.00,6.25,846.88,'2021-12-25 12:52:03','',''),(2372223,'19','199','1023',467,'Retail Sale Id 1406911',1944.00,0.00,0.00,3.00,406.50,'2021-12-25 12:57:47','',''),(2372262,'19','199','1023',467,'Retail Sale Id 1406946',4860.00,0.00,0.00,7.50,1016.25,'2021-12-25 13:01:53','',''),(2372323,'19','199','1023',467,'Retail Sale Id 1407005',1944.00,0.00,0.00,3.00,406.50,'2021-12-25 13:08:58','',''),(2372377,'19','199','1023',467,'Retail Sale Id 1407040',6480.00,0.00,0.00,10.00,1355.00,'2021-12-25 13:12:50','',''),(2372458,'19','199','1023',467,'Retail Sale Id 1407074',3240.00,0.00,0.00,5.00,677.50,'2021-12-25 13:18:15','',''),(2372527,'19','199','1023',467,'Retail Sale Id 1407122',8100.00,0.00,0.00,12.50,1693.75,'2021-12-25 13:24:34','',''),(2372650,'19','199','1023',467,'Retail Sale Id 1407183',3240.00,0.00,0.00,5.00,677.50,'2021-12-25 13:33:44','',''),(2375455,'19','199','1023',467,'Retail Sale Id 1408881',1944.00,0.00,0.00,3.00,406.50,'2021-12-26 07:56:38','',''),(2375606,'19','199','1023',467,'Retail Sale Id 1409009',3888.00,0.00,0.00,6.00,813.00,'2021-12-26 08:08:28','',''),(2375909,'19','199','1023',467,'Retail Sale Id 1409233',3888.00,0.00,0.00,6.00,813.00,'2021-12-26 08:38:33','',''),(2376129,'19','199','1023',467,'Retail Sale Id 1409426',1944.00,0.00,0.00,3.00,406.50,'2021-12-26 09:03:51','',''),(2376390,'19','199','1023',467,'Retail Sale Id 1409596',8100.00,0.00,0.00,12.50,1693.75,'2021-12-26 09:27:28','',''),(2376400,'19','199','1023',467,'Retail Sale Id 1409604',3888.00,0.00,0.00,6.00,813.00,'2021-12-26 09:29:02','',''),(2376489,'19','199','1023',467,'Retail Sale Id 1409682',1944.00,0.00,0.00,3.00,406.50,'2021-12-26 09:39:43','',''),(2376524,'19','199','1023',467,'Retail Sale Id 1409709',3888.00,0.00,0.00,6.00,813.00,'2021-12-26 09:43:12','',''),(2376525,'19','199','1023',467,'Retail Sale Id 1409709',7776.00,0.00,0.00,12.00,1626.00,'2021-12-26 09:43:12','',''),(2376553,'19','199','1023',467,'Retail Sale Id 1409731',3888.00,0.00,0.00,6.00,813.00,'2021-12-26 09:46:31','',''),(2376784,'19','199','1023',467,'Retail Sale Id 1409960',8100.00,0.00,0.00,12.50,1693.75,'2021-12-26 10:17:53','',''),(2376795,'19','199','1023',467,'Retail Sale Id 1409974',8100.00,0.00,0.00,12.50,1693.75,'2021-12-26 10:19:57','',''),(2376890,'19','199','1023',467,'Retail Sale Id 1410061',1944.00,0.00,0.00,3.00,406.50,'2021-12-26 10:31:05','',''),(2376891,'19','199','1023',467,'Retail Sale Id 1410061',4536.00,0.00,0.00,7.00,948.50,'2021-12-26 10:31:05','',''),(2376986,'19','199','1023',467,'Retail Sale Id 1410146',3888.00,0.00,0.00,6.00,813.00,'2021-12-26 10:39:44','',''),(2377022,'19','199','1023',467,'Retail Sale Id 1410167',8100.00,0.00,0.00,12.50,1693.75,'2021-12-26 10:43:19','',''),(2377148,'19','199','1023',467,'Retail Sale Id 1410287',8100.00,0.00,0.00,12.50,1693.75,'2021-12-26 10:59:25','',''),(2377163,'19','199','1023',467,'Retail Sale Id 1410302',8100.00,0.00,0.00,12.50,1693.75,'2021-12-26 11:01:11','',''),(2377634,'19','199','1023',467,'Retail Sale Id 1410713',1944.00,0.00,0.00,3.00,406.50,'2021-12-26 11:59:27','',''),(2377720,'19','199','1023',467,'Retail Sale Id 1410769',3888.00,0.00,0.00,6.00,813.00,'2021-12-26 12:07:14','',''),(2377754,'19','199','1023',467,'Retail Sale Id 1410802',3888.00,0.00,0.00,6.00,813.00,'2021-12-26 12:11:54','',''),(2377780,'19','199','1023',467,'Retail Sale Id 1410826',8100.00,0.00,0.00,12.50,1693.75,'2021-12-26 12:15:30','',''),(2377998,'19','199','1023',467,'Retail Sale Id 1410999',1944.00,0.00,0.00,3.00,406.50,'2021-12-26 12:40:07','',''),(2378055,'19','199','1023',467,'Retail Sale Id 1411058',1944.00,0.00,0.00,3.00,406.50,'2021-12-26 12:46:52','',''),(2378114,'19','199','1023',467,'Retail Sale Id 1411120',3888.00,0.00,0.00,6.00,813.00,'2021-12-26 12:55:17','',''),(2378129,'19','199','1023',467,'Retail Sale Id 1411136',7776.00,0.00,0.00,12.00,1626.00,'2021-12-26 12:57:04','',''),(2378145,'19','199','1023',467,'Retail Sale Id 1411149',3240.00,0.00,0.00,5.00,677.50,'2021-12-26 13:00:19','',''),(2378184,'19','199','1023',467,'Retail Sale Id 1411187',8100.00,0.00,0.00,12.50,1693.75,'2021-12-26 13:08:33','',''),(2378185,'19','199','1023',467,'Retail Sale Id 1411187',8100.00,0.00,0.00,12.50,1693.75,'2021-12-26 13:08:33','',''),(2378193,'19','199','1023',467,'Retail Sale Id 1411195',1944.00,0.00,0.00,3.00,406.50,'2021-12-26 13:10:21','',''),(2378212,'19','199','1023',467,'Retail Sale Id 1411212',3888.00,0.00,0.00,6.00,813.00,'2021-12-26 13:13:47','',''),(2378213,'19','199','1023',467,'Retail Sale Id 1411212',3888.00,0.00,0.00,6.00,813.00,'2021-12-26 13:13:47','',''),(2378249,'19','199','1023',467,'Retail Sale Id 1411233',4050.00,0.00,0.00,6.25,846.88,'2021-12-26 13:16:49','',''),(2378257,'19','199','1023',467,'Retail Sale Id 1411242',8100.00,0.00,0.00,12.50,1693.75,'2021-12-26 13:18:33','',''),(2378281,'19','199','1023',467,'Retail Sale Id 1411264',5832.00,0.00,0.00,9.00,1219.50,'2021-12-26 13:21:16','',''),(2378290,'19','199','1023',467,'Retail Sale Id 1411274',1944.00,0.00,0.00,3.00,406.50,'2021-12-26 13:23:13','',''),(2378291,'19','199','1023',467,'Retail Sale Id 1411274',1944.00,0.00,0.00,3.00,406.50,'2021-12-26 13:23:13','',''),(2378295,'19','199','1023',467,'Retail Sale Id 1411279',8100.00,0.00,0.00,12.50,1693.75,'2021-12-26 13:24:39','',''),(2378306,'19','199','1023',467,'Retail Sale Id 1411291',9720.00,0.00,0.00,15.00,2032.50,'2021-12-26 13:27:44','',''),(2378328,'19','199','1023',467,'Retail Sale Id 1411301',2592.00,0.00,0.00,4.00,542.00,'2021-12-26 13:29:34','',''),(2378397,'19','199','1023',467,'Retail Sale Id 1411347',1944.00,0.00,0.00,3.00,406.50,'2021-12-26 13:38:14','',''),(2378524,'19','199','1023',467,'Retail Sale Id 1411446',8100.00,0.00,0.00,12.50,1693.75,'2021-12-26 13:58:21','',''),(2378770,'19','199','1023',467,'Retail Sale Id 1411596',8100.00,0.00,0.00,12.50,1693.75,'2021-12-26 14:24:55','',''),(2378848,'19','199','1023',467,'Retail Sale Id 1411645',1944.00,0.00,0.00,3.00,406.50,'2021-12-26 14:31:49','',''),(2378984,'19','199','1023',467,'Retail Sale Id 1411702',8100.00,0.00,0.00,12.50,1693.75,'2021-12-26 14:45:04','',''),(2379280,'19','199','1023',467,'Retail Sale Id 1411929',8100.00,0.00,0.00,12.50,1693.75,'2021-12-26 15:20:05','',''),(2379411,'19','199','1023',467,'Retail Sale Id 1412000',8100.00,0.00,0.00,12.50,1693.75,'2021-12-26 15:33:53','',''),(2379530,'19','199','1023',467,'Retail Sale Id 1412088',8100.00,0.00,0.00,12.50,1693.75,'2021-12-26 15:48:45','',''),(2379553,'19','199','1023',467,'Retail Sale Id 1412111',3240.00,0.00,0.00,5.00,677.50,'2021-12-26 15:52:51','',''),(2379608,'19','199','1023',467,'Retail Sale Id 1412153',3888.00,0.00,0.00,6.00,813.00,'2021-12-26 16:01:40','',''),(2379636,'19','199','1023',467,'Retail Sale Id 1412199',8100.00,0.00,0.00,12.50,1693.75,'2021-12-26 16:04:50','',''),(2379659,'19','199','1023',467,'Retail Sale Id 1412224',3240.00,0.00,0.00,5.00,677.50,'2021-12-26 16:08:33','',''),(2381087,'19','199','1023',467,'Retail Sale Id 1413001',6480.00,0.00,0.00,10.00,1355.00,'2021-12-27 07:44:30','',''),(2381288,'19','199','1023',467,'Retail Sale Id 1413149',2592.00,0.00,0.00,4.00,542.00,'2021-12-27 08:00:20','',''),(2381324,'19','199','1023',467,'Retail Sale Id 1413181',1944.00,0.00,0.00,3.00,406.50,'2021-12-27 08:04:26','',''),(2381380,'19','199','1023',467,'Retail Sale Id 1413228',3240.00,0.00,0.00,5.00,677.50,'2021-12-27 08:10:08','',''),(2381414,'19','199','1023',467,'Retail Sale Id 1413257',3888.00,0.00,0.00,6.00,813.00,'2021-12-27 08:13:57','',''),(2381415,'19','199','1023',467,'Retail Sale Id 1413257',3888.00,0.00,0.00,6.00,813.00,'2021-12-27 08:13:57','',''),(2381459,'19','199','1023',467,'Retail Sale Id 1413294',3888.00,0.00,0.00,6.00,813.00,'2021-12-27 08:18:10','',''),(2381516,'19','199','1023',467,'Retail Sale Id 1413351',1944.00,0.00,0.00,3.00,406.50,'2021-12-27 08:23:40','',''),(2381593,'19','199','1023',467,'Retail Sale Id 1413425',8100.00,0.00,0.00,12.50,1693.75,'2021-12-27 08:31:58','',''),(2381886,'19','199','1023',467,'Retail Sale Id 1413691',3888.00,0.00,0.00,6.00,813.00,'2021-12-27 08:55:43','',''),(2381927,'19','199','1023',467,'Retail Sale Id 1413722',8100.00,0.00,0.00,12.50,1693.75,'2021-12-27 09:00:12','',''),(2382319,'19','199','1023',467,'Retail Sale Id 1414109',8100.00,0.00,0.00,12.50,1693.75,'2021-12-27 09:37:56','',''),(2382367,'19','199','1023',467,'Retail Sale Id 1414158',3240.00,0.00,0.00,5.00,677.50,'2021-12-27 09:43:38','',''),(2382368,'19','199','1023',467,'Retail Sale Id 1414158',8100.00,0.00,0.00,12.50,1693.75,'2021-12-27 09:43:38','',''),(2382732,'19','199','1023',467,'Retail Sale Id 1414429',1944.00,0.00,0.00,3.00,406.50,'2021-12-27 10:15:08','',''),(2383099,'19','199','1023',467,'Retail Sale Id 1414740',3240.00,0.00,0.00,5.00,677.50,'2021-12-27 10:50:28','',''),(2383100,'19','199','1023',467,'Retail Sale Id 1414740',3240.00,0.00,0.00,5.00,677.50,'2021-12-27 10:50:28','',''),(2383101,'19','199','1023',467,'Retail Sale Id 1414740',3240.00,0.00,0.00,5.00,677.50,'2021-12-27 10:50:28','',''),(2383102,'19','199','1023',467,'Retail Sale Id 1414740',6480.00,0.00,0.00,10.00,1355.00,'2021-12-27 10:50:28','',''),(2383103,'19','199','1023',467,'Retail Sale Id 1414740',6480.00,0.00,0.00,10.00,1355.00,'2021-12-27 10:50:28','',''),(2383172,'19','199','1023',467,'Retail Sale Id 1414874',4536.00,0.00,0.00,7.00,948.50,'2021-12-27 10:57:33','',''),(2383290,'19','199','1023',467,'Retail Sale Id 1414983',4050.00,0.00,0.00,6.25,846.88,'2021-12-27 11:09:30','',''),(2383311,'19','199','1023',467,'Retail Sale Id 1414999',1944.00,0.00,0.00,3.00,406.50,'2021-12-27 11:11:02','',''),(2383325,'19','199','1023',467,'Retail Sale Id 1415019',8100.00,0.00,0.00,12.50,1693.75,'2021-12-27 11:12:33','',''),(2383384,'19','199','1023',467,'Retail Sale Id 1415075',1944.00,0.00,0.00,3.00,406.50,'2021-12-27 11:19:11','',''),(2383419,'19','199','1023',467,'Retail Sale Id 1415106',2916.00,0.00,0.00,4.50,609.75,'2021-12-27 11:22:52','',''),(2383580,'19','199','1023',467,'Retail Sale Id 1415265',4050.00,0.00,0.00,6.25,846.88,'2021-12-27 11:41:29','',''),(2383777,'19','199','1023',467,'Retail Sale Id 1415434',6480.00,0.00,0.00,10.00,1355.00,'2021-12-27 12:05:42','',''),(2383963,'19','199','1023',467,'Retail Sale Id 1415584',8100.00,0.00,0.00,12.50,1693.75,'2021-12-27 12:33:09','',''),(2383975,'19','199','1023',467,'Retail Sale Id 1415595',1944.00,0.00,0.00,3.00,406.50,'2021-12-27 12:35:14','',''),(2384016,'19','199','1023',467,'Retail Sale Id 1415638',8100.00,0.00,0.00,12.50,1693.75,'2021-12-27 12:42:21','',''),(2384029,'19','199','1023',467,'Retail Sale Id 1415650',1944.00,0.00,0.00,3.00,406.50,'2021-12-27 12:45:14','',''),(2384040,'19','199','1023',467,'Retail Sale Id 1415661',3888.00,0.00,0.00,6.00,813.00,'2021-12-27 12:46:45','',''),(2384268,'19','199','1023',467,'Retail Sale Id 1415820',8100.00,0.00,0.00,12.50,1693.75,'2021-12-27 13:12:49','',''),(2384377,'19','199','1023',467,'Retail Sale Id 1415905',8100.00,0.00,0.00,12.50,1693.75,'2021-12-27 13:25:25','',''),(2384519,'19','199','1023',467,'Retail Sale Id 1416013',3240.00,0.00,0.00,5.00,677.50,'2021-12-27 13:42:49','',''),(2384520,'19','199','1023',467,'Retail Sale Id 1416013',3888.00,0.00,0.00,6.00,813.00,'2021-12-27 13:42:49','',''),(2384572,'19','199','1023',467,'Retail Sale Id 1416063',8100.00,0.00,0.00,12.50,1693.75,'2021-12-27 13:50:57','',''),(2384634,'19','199','1023',467,'Retail Sale Id 1416122',1944.00,0.00,0.00,3.00,406.50,'2021-12-27 14:02:37','',''),(2384816,'19','199','1023',467,'Retail Sale Id 1416196',8100.00,0.00,0.00,12.50,1693.75,'2021-12-27 14:20:36','',''),(2384817,'19','199','1023',467,'Retail Sale Id 1416196',8100.00,0.00,0.00,12.50,1693.75,'2021-12-27 14:20:36','',''),(2384948,'19','199','1023',467,'Retail Sale Id 1416287',3240.00,0.00,0.00,5.00,677.50,'2021-12-27 14:38:10','',''),(2384949,'19','199','1023',467,'Retail Sale Id 1416287',3240.00,0.00,0.00,5.00,677.50,'2021-12-27 14:38:10','',''),(2385109,'19','199','1023',467,'Retail Sale Id 1416446',1944.00,0.00,0.00,3.00,406.50,'2021-12-27 15:06:28','',''),(2385207,'19','199','1023',467,'Retail Sale Id 1416531',8100.00,0.00,0.00,12.50,1693.75,'2021-12-27 15:24:09','',''),(2385296,'19','199','1023',467,'Retail Sale Id 1416591',1944.00,0.00,0.00,3.00,406.50,'2021-12-27 15:36:28','',''),(2387114,'19','199','1023',467,'Retail Sale Id 1417753',1944.00,0.00,0.00,3.00,406.50,'2021-12-28 07:46:49','',''),(2387317,'19','199','1023',467,'Retail Sale Id 1417934',1944.00,0.00,0.00,3.00,406.50,'2021-12-28 08:03:56','',''),(2387523,'19','199','1023',467,'Retail Sale Id 1418068',3888.00,0.00,0.00,6.00,813.00,'2021-12-28 08:17:37','',''),(2387614,'19','199','1023',467,'Retail Sale Id 1418129',3888.00,0.00,0.00,6.00,813.00,'2021-12-28 08:24:48','',''),(2387615,'19','199','1023',467,'Retail Sale Id 1418129',8100.00,0.00,0.00,12.50,1693.75,'2021-12-28 08:24:48','',''),(2387674,'19','199','1023',467,'Retail Sale Id 1418170',24480.00,0.00,0.00,40.00,3980.00,'2021-12-28 08:28:19','',''),(2387723,'19','199','1023',467,'Retail Sale Id 1418220',3888.00,0.00,0.00,6.00,813.00,'2021-12-28 08:33:45','',''),(2388152,'19','199','1023',467,'Retail Sale Id 1418574',8100.00,0.00,0.00,12.50,1693.75,'2021-12-28 09:19:44','',''),(2388226,'19','199','1023',467,'Retail Sale Id 1418660',3888.00,0.00,0.00,6.00,813.00,'2021-12-28 09:28:14','',''),(2388319,'19','199','1023',467,'Retail Sale Id 1418747',3240.00,0.00,0.00,5.00,677.50,'2021-12-28 09:39:33','',''),(2388468,'19','199','1023',467,'Retail Sale Id 1418890',1944.00,0.00,0.00,3.00,406.50,'2021-12-28 09:55:03','',''),(2388494,'19','199','1023',467,'Retail Sale Id 1418920',3888.00,0.00,0.00,6.00,813.00,'2021-12-28 09:58:39','',''),(2388530,'19','199','1023',467,'Retail Sale Id 1418958',3888.00,0.00,0.00,6.00,813.00,'2021-12-28 10:02:52','',''),(2388550,'19','199','1023',467,'Retail Sale Id 1418973',1944.00,0.00,0.00,3.00,406.50,'2021-12-28 10:04:24','',''),(2388704,'19','199','1023',467,'Retail Sale Id 1419041',3888.00,0.00,0.00,6.00,813.00,'2021-12-28 10:21:52','',''),(2388705,'19','199','1023',467,'Retail Sale Id 1419041',8100.00,0.00,0.00,12.50,1693.75,'2021-12-28 10:21:52','',''),(2388732,'19','199','1023',467,'Retail Sale Id 1419147',3888.00,0.00,0.00,6.00,813.00,'2021-12-28 10:23:53','',''),(2388823,'19','199','1023',467,'Retail Sale Id 1419208',3240.00,0.00,0.00,5.00,677.50,'2021-12-28 10:31:30','',''),(2388908,'19','199','1023',467,'Retail Sale Id 1419300',3888.00,0.00,0.00,6.00,813.00,'2021-12-28 10:40:19','',''),(2388996,'19','199','1023',467,'Retail Sale Id 1419372',3240.00,0.00,0.00,5.00,677.50,'2021-12-28 10:47:53','',''),(2388997,'19','199','1023',467,'Retail Sale Id 1419372',3888.00,0.00,0.00,6.00,813.00,'2021-12-28 10:47:53','',''),(2389079,'19','199','1023',467,'Retail Sale Id 1419458',4050.00,0.00,0.00,6.25,846.88,'2021-12-28 10:56:34','',''),(2389099,'19','199','1023',467,'Retail Sale Id 1419476',8100.00,0.00,0.00,12.50,1693.75,'2021-12-28 10:58:49','',''),(2389139,'19','199','1023',467,'Retail Sale Id 1419507',3888.00,0.00,0.00,6.00,813.00,'2021-12-28 11:03:36','',''),(2389239,'19','199','1023',467,'Retail Sale Id 1419592',8100.00,0.00,0.00,12.50,1693.75,'2021-12-28 11:13:32','',''),(2389470,'19','199','1023',467,'Retail Sale Id 1419802',8100.00,0.00,0.00,12.50,1693.75,'2021-12-28 11:39:35','',''),(2389505,'19','199','1023',467,'Retail Sale Id 1419836',1944.00,0.00,0.00,3.00,406.50,'2021-12-28 11:43:57','',''),(2389529,'19','199','1023',467,'Retail Sale Id 1419856',8100.00,0.00,0.00,12.50,1693.75,'2021-12-28 11:46:32','',''),(2389584,'19','199','1023',467,'Retail Sale Id 1419904',3240.00,0.00,0.00,5.00,677.50,'2021-12-28 11:51:03','',''),(2389736,'19','199','1023',467,'Retail Sale Id 1420004',1944.00,0.00,0.00,3.00,406.50,'2021-12-28 12:04:28','',''),(2389766,'19','199','1023',467,'Retail Sale Id 1420025',3888.00,0.00,0.00,6.00,813.00,'2021-12-28 12:06:19','',''),(2389818,'19','199','1023',467,'Retail Sale Id 1420073',3888.00,0.00,0.00,6.00,813.00,'2021-12-28 12:08:51','',''),(2389924,'19','199','1023',467,'Retail Sale Id 1420162',8100.00,0.00,0.00,12.50,1693.75,'2021-12-28 12:21:37','',''),(2390225,'19','199','1023',467,'Retail Sale Id 1420386',1944.00,0.00,0.00,3.00,406.50,'2021-12-28 12:47:06','',''),(2390240,'19','199','1023',467,'Retail Sale Id 1420401',4536.00,0.00,0.00,7.00,948.50,'2021-12-28 12:49:07','',''),(2390329,'19','199','1023',467,'Retail Sale Id 1420474',4536.00,0.00,0.00,7.00,948.50,'2021-12-28 12:57:41','',''),(2390340,'19','199','1023',467,'Retail Sale Id 1420486',1944.00,0.00,0.00,3.00,406.50,'2021-12-28 12:59:23','',''),(2390363,'19','199','1023',467,'Retail Sale Id 1420502',1944.00,0.00,0.00,3.00,406.50,'2021-12-28 13:00:53','',''),(2390448,'19','199','1023',467,'Retail Sale Id 1420560',1944.00,0.00,0.00,3.00,406.50,'2021-12-28 13:08:25','',''),(2390569,'19','199','1023',467,'Retail Sale Id 1420646',3240.00,0.00,0.00,5.00,677.50,'2021-12-28 13:20:44','',''),(2390736,'19','199','1023',467,'Retail Sale Id 1420738',3888.00,0.00,0.00,6.00,813.00,'2021-12-28 13:33:43','',''),(2390978,'19','199','1023',467,'Retail Sale Id 1420938',4050.00,0.00,0.00,6.25,846.88,'2021-12-28 14:01:32','',''),(2391027,'19','199','1023',467,'Retail Sale Id 1420972',8100.00,0.00,0.00,12.50,1693.75,'2021-12-28 14:05:49','',''),(2391079,'19','199','1023',467,'Retail Sale Id 1421002',38250.00,0.00,0.00,62.50,6218.75,'2021-12-28 14:10:27','',''),(2391132,'19','199','1023',467,'Retail Sale Id 1421023',4536.00,0.00,0.00,7.00,948.50,'2021-12-28 14:13:24','',''),(2391285,'19','199','1023',467,'Retail Sale Id 1421149',8100.00,0.00,0.00,12.50,1693.75,'2021-12-28 14:31:04','',''),(2391326,'19','199','1023',467,'Retail Sale Id 1421189',4050.00,0.00,0.00,6.25,846.88,'2021-12-28 14:37:50','',''),(2391388,'19','199','1023',467,'Retail Sale Id 1421236',2592.00,0.00,0.00,4.00,542.00,'2021-12-28 14:44:15','',''),(2391403,'19','199','1023',467,'Retail Sale Id 1421252',2592.00,0.00,0.00,4.00,542.00,'2021-12-28 14:46:59','',''),(2391420,'19','199','1023',467,'Retail Sale Id 1421270',1944.00,0.00,0.00,3.00,406.50,'2021-12-28 14:49:19','',''),(2391459,'19','199','1023',467,'Retail Sale Id 1421313',1944.00,0.00,0.00,3.00,406.50,'2021-12-28 14:55:43','',''),(2391475,'19','199','1023',467,'Retail Sale Id 1421327',6480.00,0.00,0.00,10.00,1355.00,'2021-12-28 14:57:57','',''),(2391625,'19','199','1023',467,'Retail Sale Id 1421418',8100.00,0.00,0.00,12.50,1693.75,'2021-12-28 15:13:38','',''),(2391641,'19','199','1023',467,'Retail Sale Id 1421434',1944.00,0.00,0.00,3.00,406.50,'2021-12-28 15:15:34','',''),(2391694,'19','199','1023',467,'Retail Sale Id 1421495',8100.00,0.00,0.00,12.50,1693.75,'2021-12-28 15:23:05','',''),(2391713,'19','199','1023',467,'Retail Sale Id 1421514',6480.00,0.00,0.00,10.00,1355.00,'2021-12-28 15:26:38','',''),(2391751,'19','199','1023',467,'Retail Sale Id 1421556',4050.00,0.00,0.00,6.25,846.88,'2021-12-28 15:32:24','',''),(2391875,'19','199','1023',467,'Retail Sale Id 1421659',8100.00,0.00,0.00,12.50,1693.75,'2021-12-28 15:45:00','',''),(2391876,'19','199','1023',467,'Retail Sale Id 1421659',8100.00,0.00,0.00,12.50,1693.75,'2021-12-28 15:45:00','',''),(2391893,'19','199','1023',467,'Retail Sale Id 1421673',1944.00,0.00,0.00,3.00,406.50,'2021-12-28 15:47:14','',''),(2392061,'19','199','1023',467,'Retail Sale Id 1421804',3888.00,0.00,0.00,6.00,813.00,'2021-12-28 16:01:02','',''),(2392135,'19','199','1023',467,'Retail Sale Id 1421849',8100.00,0.00,0.00,12.50,1693.75,'2021-12-28 16:07:21','',''),(2392136,'19','199','1023',467,'Retail Sale Id 1421849',8100.00,0.00,0.00,12.50,1693.75,'2021-12-28 16:07:21','',''),(2394559,'19','199','1023',467,'Retail Sale Id 1423366',8100.00,0.00,0.00,12.50,1693.75,'2021-12-29 08:35:09','',''),(2394580,'19','199','1023',467,'Retail Sale Id 1423386',2592.00,0.00,0.00,4.00,542.00,'2021-12-29 08:36:55','',''),(2394601,'19','199','1023',467,'Retail Sale Id 1423414',1944.00,0.00,0.00,3.00,406.50,'2021-12-29 08:39:01','',''),(2394618,'19','199','1023',467,'Retail Sale Id 1423429',1944.00,0.00,0.00,3.00,406.50,'2021-12-29 08:40:32','',''),(2395137,'19','199','1023',467,'Retail Sale Id 1423813',3240.00,0.00,0.00,5.00,677.50,'2021-12-29 09:31:09','',''),(2395203,'19','199','1023',467,'Retail Sale Id 1423881',6480.00,0.00,0.00,10.00,1355.00,'2021-12-29 09:38:26','',''),(2395301,'19','199','1023',467,'Retail Sale Id 1423962',1944.00,0.00,0.00,3.00,406.50,'2021-12-29 09:49:06','',''),(2395317,'19','199','1023',467,'Retail Sale Id 1423977',3240.00,0.00,0.00,5.00,677.50,'2021-12-29 09:51:01','',''),(2395342,'19','199','1023',467,'Retail Sale Id 1424002',3888.00,0.00,0.00,6.00,813.00,'2021-12-29 09:53:45','',''),(2395634,'19','199','1023',467,'Retail Sale Id 1424255',1944.00,0.00,0.00,3.00,406.50,'2021-12-29 10:23:16','',''),(2395884,'19','199','1023',467,'Retail Sale Id 1424474',8100.00,0.00,0.00,12.50,1693.75,'2021-12-29 10:52:07','',''),(2395891,'19','199','1023',467,'Retail Sale Id 1424480',3888.00,0.00,0.00,6.00,813.00,'2021-12-29 10:53:22','',''),(2395911,'19','199','1023',467,'Retail Sale Id 1424496',3888.00,0.00,0.00,6.00,813.00,'2021-12-29 10:55:12','',''),(2396044,'19','199','1023',467,'Retail Sale Id 1424617',8100.00,0.00,0.00,12.50,1693.75,'2021-12-29 11:07:10','',''),(2396071,'19','199','1023',467,'Retail Sale Id 1424643',1944.00,0.00,0.00,3.00,406.50,'2021-12-29 11:10:32','',''),(2396094,'19','199','1023',467,'Retail Sale Id 1424665',8100.00,0.00,0.00,12.50,1693.75,'2021-12-29 11:12:51','',''),(2396239,'19','199','1023',467,'Retail Sale Id 1424791',8100.00,0.00,0.00,12.50,1693.75,'2021-12-29 11:30:17','',''),(2396262,'19','199','1023',467,'Retail Sale Id 1424811',3240.00,0.00,0.00,5.00,677.50,'2021-12-29 11:32:37','',''),(2396320,'19','199','1023',467,'Retail Sale Id 1424849',3888.00,0.00,0.00,6.00,813.00,'2021-12-29 11:36:23','',''),(2396346,'19','199','1023',467,'Retail Sale Id 1424868',3888.00,0.00,0.00,6.00,813.00,'2021-12-29 11:39:52','',''),(2396367,'19','199','1023',467,'Retail Sale Id 1424887',8100.00,0.00,0.00,12.50,1693.75,'2021-12-29 11:42:24','',''),(2396383,'19','199','1023',467,'Retail Sale Id 1424907',3888.00,0.00,0.00,6.00,813.00,'2021-12-29 11:44:23','',''),(2396392,'19','199','1023',467,'Retail Sale Id 1424916',8100.00,0.00,0.00,12.50,1693.75,'2021-12-29 11:45:36','',''),(2396507,'19','199','1023',467,'Retail Sale Id 1425024',8100.00,0.00,0.00,12.50,1693.75,'2021-12-29 11:59:54','',''),(2396616,'19','199','1023',467,'Retail Sale Id 1425125',3888.00,0.00,0.00,6.00,813.00,'2021-12-29 12:17:29','',''),(2396829,'19','199','1023',467,'Retail Sale Id 1425299',1944.00,0.00,0.00,3.00,406.50,'2021-12-29 12:44:57','',''),(2396830,'19','199','1023',467,'Retail Sale Id 1425299',3240.00,0.00,0.00,5.00,677.50,'2021-12-29 12:44:57','',''),(2397020,'19','199','1023',467,'Retail Sale Id 1425445',1944.00,0.00,0.00,3.00,406.50,'2021-12-29 13:06:03','',''),(2397106,'19','199','1023',467,'Retail Sale Id 1425530',1944.00,0.00,0.00,3.00,406.50,'2021-12-29 13:18:06','',''),(2397123,'19','199','1023',467,'Retail Sale Id 1425544',3240.00,0.00,0.00,5.00,677.50,'2021-12-29 13:19:49','',''),(2397166,'19','199','1023',467,'Retail Sale Id 1425573',8100.00,0.00,0.00,12.50,1693.75,'2021-12-29 13:24:03','',''),(2397341,'19','199','1023',467,'Retail Sale Id 1425700',8100.00,0.00,0.00,12.50,1693.75,'2021-12-29 13:45:29','',''),(2397381,'19','199','1023',467,'Retail Sale Id 1425735',4050.00,0.00,0.00,6.25,846.88,'2021-12-29 13:49:40','',''),(2397403,'19','199','1023',467,'Retail Sale Id 1425758',6480.00,0.00,0.00,10.00,1355.00,'2021-12-29 13:52:19','',''),(2397457,'19','199','1023',467,'Retail Sale Id 1425805',4050.00,0.00,0.00,6.25,846.88,'2021-12-29 13:59:20','',''),(2397640,'19','199','1023',467,'Retail Sale Id 1425960',3240.00,0.00,0.00,5.00,677.50,'2021-12-29 14:18:10','',''),(2397744,'19','199','1023',467,'Retail Sale Id 1426018',1944.00,0.00,0.00,3.00,406.50,'2021-12-29 14:27:02','',''),(2397756,'19','199','1023',467,'Retail Sale Id 1426033',8100.00,0.00,0.00,12.50,1693.75,'2021-12-29 14:28:59','',''),(2397771,'19','199','1023',467,'Retail Sale Id 1426048',8100.00,0.00,0.00,12.50,1693.75,'2021-12-29 14:30:53','',''),(2397847,'19','199','1023',467,'Retail Sale Id 1426102',3240.00,0.00,0.00,5.00,677.50,'2021-12-29 14:36:25','',''),(2397928,'19','199','1023',467,'Retail Sale Id 1426152',1944.00,0.00,0.00,3.00,406.50,'2021-12-29 14:43:01','',''),(2398007,'19','199','1023',467,'Retail Sale Id 1426212',1944.00,0.00,0.00,3.00,406.50,'2021-12-29 14:49:46','',''),(2398030,'19','199','1023',467,'Retail Sale Id 1426225',1944.00,0.00,0.00,3.00,406.50,'2021-12-29 14:51:17','',''),(2398102,'19','199','1023',467,'Retail Sale Id 1426263',4050.00,0.00,0.00,6.25,846.88,'2021-12-29 14:55:32','',''),(2398103,'19','199','1023',467,'Retail Sale Id 1426263',8100.00,0.00,0.00,12.50,1693.75,'2021-12-29 14:55:32','',''),(2398496,'19','199','1023',467,'Retail Sale Id 1426509',1944.00,0.00,0.00,3.00,406.50,'2021-12-29 15:30:21','',''),(2398552,'19','199','1023',467,'Retail Sale Id 1426540',3240.00,0.00,0.00,5.00,677.50,'2021-12-29 15:34:08','',''),(2398633,'19','199','1023',467,'Retail Sale Id 1426592',3888.00,0.00,0.00,6.00,813.00,'2021-12-29 15:38:54','',''),(2398725,'19','199','1023',467,'Retail Sale Id 1426644',4536.00,0.00,0.00,7.00,948.50,'2021-12-29 15:46:02','',''),(2398790,'19','199','1023',467,'Retail Sale Id 1426699',1944.00,0.00,0.00,3.00,406.50,'2021-12-29 15:53:13','',''),(2398851,'19','199','1023',467,'Retail Sale Id 1426733',1944.00,0.00,0.00,3.00,406.50,'2021-12-29 15:58:19','',''),(2400924,'19','199','1023',467,'Retail Sale Id 1428046',8100.00,0.00,0.00,12.50,1693.75,'2021-12-30 07:59:17','',''),(2400979,'19','199','1023',467,'Retail Sale Id 1428091',1944.00,0.00,0.00,3.00,406.50,'2021-12-30 08:04:28','',''),(2400980,'19','199','1023',467,'Retail Sale Id 1428091',3888.00,0.00,0.00,6.00,813.00,'2021-12-30 08:04:28','',''),(2401123,'19','199','1023',467,'Retail Sale Id 1428210',3888.00,0.00,0.00,6.00,813.00,'2021-12-30 08:18:44','',''),(2401142,'19','199','1023',467,'Retail Sale Id 1428227',3888.00,0.00,0.00,6.00,813.00,'2021-12-30 08:21:07','',''),(2401143,'19','199','1023',467,'Retail Sale Id 1428227',8100.00,0.00,0.00,12.50,1693.75,'2021-12-30 08:21:07','',''),(2401417,'19','199','1023',467,'Retail Sale Id 1428395',3240.00,0.00,0.00,5.00,677.50,'2021-12-30 08:40:43','',''),(2401480,'19','199','1023',467,'Retail Sale Id 1428436',3888.00,0.00,0.00,6.00,813.00,'2021-12-30 08:45:10','',''),(2401572,'19','199','1023',467,'Retail Sale Id 1428498',8100.00,0.00,0.00,12.50,1693.75,'2021-12-30 08:49:57','',''),(2401591,'19','199','1023',467,'Retail Sale Id 1428518',8100.00,0.00,0.00,12.50,1693.75,'2021-12-30 08:51:49','',''),(2401693,'19','199','1023',467,'Retail Sale Id 1428585',1944.00,0.00,0.00,3.00,406.50,'2021-12-30 08:58:13','',''),(2401694,'19','199','1023',467,'Retail Sale Id 1428585',8100.00,0.00,0.00,12.50,1693.75,'2021-12-30 08:58:13','',''),(2401745,'19','199','1023',467,'Retail Sale Id 1428629',8100.00,0.00,0.00,12.50,1693.75,'2021-12-30 09:02:37','',''),(2402072,'19','199','1023',467,'Retail Sale Id 1428812',3240.00,0.00,0.00,5.00,677.50,'2021-12-30 09:34:22','',''),(2402112,'19','199','1023',467,'Retail Sale Id 1428943',1944.00,0.00,0.00,3.00,406.50,'2021-12-30 09:36:58','',''),(2402113,'19','199','1023',467,'Retail Sale Id 1428943',3240.00,0.00,0.00,5.00,677.50,'2021-12-30 09:36:58','',''),(2402266,'19','199','1023',467,'Retail Sale Id 1429079',8100.00,0.00,0.00,12.50,1693.75,'2021-12-30 09:51:45','',''),(2402284,'19','199','1023',467,'Retail Sale Id 1429097',1296.00,0.00,0.00,2.00,271.00,'2021-12-30 09:53:31','',''),(2402285,'19','199','1023',467,'Retail Sale Id 1429097',8100.00,0.00,0.00,12.50,1693.75,'2021-12-30 09:53:31','',''),(2402410,'19','199','1023',467,'Retail Sale Id 1429225',8100.00,0.00,0.00,12.50,1693.75,'2021-12-30 10:05:20','',''),(2402434,'19','199','1023',467,'Retail Sale Id 1429250',1944.00,0.00,0.00,3.00,406.50,'2021-12-30 10:07:48','',''),(2402557,'19','199','1023',467,'Retail Sale Id 1429371',3888.00,0.00,0.00,6.00,813.00,'2021-12-30 10:20:29','',''),(2402589,'19','199','1023',467,'Retail Sale Id 1429404',1944.00,0.00,0.00,3.00,406.50,'2021-12-30 10:23:54','',''),(2402629,'19','199','1023',467,'Retail Sale Id 1429440',6804.00,0.00,0.00,10.50,1422.75,'2021-12-30 10:28:12','',''),(2402765,'19','199','1023',467,'Retail Sale Id 1429535',4536.00,0.00,0.00,7.00,948.50,'2021-12-30 10:38:15','',''),(2402957,'19','199','1023',467,'Retail Sale Id 1429688',3888.00,0.00,0.00,6.00,813.00,'2021-12-30 10:56:17','',''),(2403085,'19','199','1023',467,'Retail Sale Id 1429819',8100.00,0.00,0.00,12.50,1693.75,'2021-12-30 11:11:36','',''),(2403131,'19','199','1023',467,'Retail Sale Id 1429854',8100.00,0.00,0.00,12.50,1693.75,'2021-12-30 11:16:38','',''),(2403260,'19','199','1023',467,'Retail Sale Id 1429978',1944.00,0.00,0.00,3.00,406.50,'2021-12-30 11:34:53','',''),(2403300,'19','199','1023',467,'Retail Sale Id 1430020',1944.00,0.00,0.00,3.00,406.50,'2021-12-30 11:40:08','',''),(2403376,'19','199','1023',467,'Retail Sale Id 1430093',8100.00,0.00,0.00,12.50,1693.75,'2021-12-30 11:50:30','',''),(2403598,'19','199','1023',467,'Retail Sale Id 1430323',3240.00,0.00,0.00,5.00,677.50,'2021-12-30 12:22:58','',''),(2403612,'19','199','1023',467,'Retail Sale Id 1430335',8100.00,0.00,0.00,12.50,1693.75,'2021-12-30 12:24:53','',''),(2403660,'19','199','1023',467,'Retail Sale Id 1430366',8100.00,0.00,0.00,12.50,1693.75,'2021-12-30 12:29:22','',''),(2403760,'19','199','1023',467,'Retail Sale Id 1430462',1944.00,0.00,0.00,3.00,406.50,'2021-12-30 12:41:38','',''),(2403761,'19','199','1023',467,'Retail Sale Id 1430462',8100.00,0.00,0.00,12.50,1693.75,'2021-12-30 12:41:38','',''),(2403786,'19','199','1023',467,'Retail Sale Id 1430485',8100.00,0.00,0.00,12.50,1693.75,'2021-12-30 12:45:38','',''),(2403869,'19','199','1023',467,'Retail Sale Id 1430559',4989.60,0.00,0.00,7.70,1043.35,'2021-12-30 12:56:48','',''),(2404225,'19','199','1023',467,'Retail Sale Id 1430806',972.00,0.00,0.00,1.50,203.25,'2021-12-30 13:31:01','',''),(2404226,'19','199','1023',467,'Retail Sale Id 1430806',4017.60,0.00,0.00,6.20,840.10,'2021-12-30 13:31:01','',''),(2404313,'19','199','1023',467,'Retail Sale Id 1430862',2916.00,0.00,0.00,4.50,609.75,'2021-12-30 13:37:46','',''),(2404361,'19','199','1023',467,'Retail Sale Id 1430873',1944.00,0.00,0.00,3.00,406.50,'2021-12-30 13:39:24','',''),(2404388,'19','199','1023',467,'Retail Sale Id 1430889',3240.00,0.00,0.00,5.00,677.50,'2021-12-30 13:41:15','',''),(2404456,'19','199','1023',467,'Retail Sale Id 1430913',1944.00,0.00,0.00,3.00,406.50,'2021-12-30 13:44:47','',''),(2404457,'19','199','1023',467,'Retail Sale Id 1430913',1944.00,0.00,0.00,3.00,406.50,'2021-12-30 13:44:47','',''),(2404487,'19','199','1023',467,'Retail Sale Id 1430925',3240.00,0.00,0.00,5.00,677.50,'2021-12-30 13:46:26','',''),(2404498,'19','199','1023',467,'Retail Sale Id 1430936',8100.00,0.00,0.00,12.50,1693.75,'2021-12-30 13:47:57','',''),(2404509,'19','199','1023',467,'Retail Sale Id 1430949',2980.80,0.00,0.00,4.60,623.30,'2021-12-30 13:49:57','',''),(2404517,'19','199','1023',467,'Retail Sale Id 1430955',1944.00,0.00,0.00,3.00,406.50,'2021-12-30 13:51:02','',''),(2404535,'19','199','1023',467,'Retail Sale Id 1430969',8100.00,0.00,0.00,12.50,1693.75,'2021-12-30 13:53:17','',''),(2404583,'19','199','1023',467,'Retail Sale Id 1431022',1944.00,0.00,0.00,3.00,406.50,'2021-12-30 13:59:27','',''),(2404697,'19','199','1023',467,'Retail Sale Id 1431115',4050.00,0.00,0.00,6.25,846.88,'2021-12-30 14:12:42','',''),(2404735,'19','199','1023',467,'Retail Sale Id 1431138',3888.00,0.00,0.00,6.00,813.00,'2021-12-30 14:15:43','',''),(2404794,'19','199','1023',467,'Retail Sale Id 1431191',8100.00,0.00,0.00,12.50,1693.75,'2021-12-30 14:20:50','',''),(2404924,'19','199','1023',467,'Retail Sale Id 1431325',5184.00,0.00,0.00,8.00,1084.00,'2021-12-30 14:36:19','',''),(2404973,'19','199','1023',467,'Retail Sale Id 1431374',1944.00,0.00,0.00,3.00,406.50,'2021-12-30 14:41:35','',''),(2405306,'19','199','1023',467,'Retail Sale Id 1431694',1944.00,0.00,0.00,3.00,406.50,'2021-12-30 15:20:39','',''),(2405325,'19','199','1023',467,'Retail Sale Id 1431713',8100.00,0.00,0.00,12.50,1693.75,'2021-12-30 15:23:16','',''),(2405379,'19','199','1023',467,'Retail Sale Id 1431748',3888.00,0.00,0.00,6.00,813.00,'2021-12-30 15:27:39','',''),(2405380,'19','199','1023',467,'Retail Sale Id 1431748',8100.00,0.00,0.00,12.50,1693.75,'2021-12-30 15:27:39','',''),(2405399,'19','199','1023',467,'Retail Sale Id 1431763',3240.00,0.00,0.00,5.00,677.50,'2021-12-30 15:29:55','',''),(2405441,'19','199','1023',467,'Retail Sale Id 1431805',1944.00,0.00,0.00,3.00,406.50,'2021-12-30 15:34:24','',''),(2405442,'19','199','1023',467,'Retail Sale Id 1431805',3240.00,0.00,0.00,5.00,677.50,'2021-12-30 15:34:24','',''),(2405662,'19','199','1023',467,'Retail Sale Id 1431984',6480.00,0.00,0.00,10.00,1355.00,'2021-12-30 15:54:33','',''),(2405773,'19','199','1023',467,'Retail Sale Id 1432096',6804.00,0.00,0.00,10.50,1422.75,'2021-12-30 16:05:15','',''),(2407907,'19','199','1023',467,'Retail Sale Id 1433418',3888.00,0.00,0.00,6.00,813.00,'2021-12-31 07:27:35','',''),(2408135,'19','199','1023',467,'Retail Sale Id 1433586',8100.00,0.00,0.00,12.50,1693.75,'2021-12-31 07:44:39','',''),(2408191,'19','199','1023',467,'Retail Sale Id 1433635',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 07:51:06','',''),(2408192,'19','199','1023',467,'Retail Sale Id 1433635',8100.00,0.00,0.00,12.50,1693.75,'2021-12-31 07:51:06','',''),(2408219,'19','199','1023',467,'Retail Sale Id 1433646',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 07:52:37','',''),(2408285,'19','199','1023',467,'Retail Sale Id 1433688',8100.00,0.00,0.00,12.50,1693.75,'2021-12-31 07:56:14','',''),(2408299,'19','199','1023',467,'Retail Sale Id 1433703',6480.00,0.00,0.00,10.00,1355.00,'2021-12-31 07:58:22','',''),(2408433,'19','199','1023',467,'Retail Sale Id 1433829',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 08:10:34','',''),(2408618,'19','199','1023',467,'Retail Sale Id 1433973',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 08:25:14','',''),(2408694,'19','199','1023',467,'Retail Sale Id 1434067',3240.00,0.00,0.00,5.00,677.50,'2021-12-31 08:31:57','',''),(2408820,'19','199','1023',467,'Retail Sale Id 1434170',3888.00,0.00,0.00,6.00,813.00,'2021-12-31 08:41:44','',''),(2408863,'19','199','1023',467,'Retail Sale Id 1434211',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 08:44:33','',''),(2408880,'19','199','1023',467,'Retail Sale Id 1434225',3888.00,0.00,0.00,6.00,813.00,'2021-12-31 08:45:47','',''),(2408968,'19','199','1023',467,'Retail Sale Id 1434248',8100.00,0.00,0.00,12.50,1693.75,'2021-12-31 08:52:08','',''),(2409039,'19','199','1023',467,'Retail Sale Id 1434368',3888.00,0.00,0.00,6.00,813.00,'2021-12-31 08:59:14','',''),(2409071,'19','199','1023',467,'Retail Sale Id 1434396',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 09:01:56','',''),(2409072,'19','199','1023',467,'Retail Sale Id 1434396',8100.00,0.00,0.00,12.50,1693.75,'2021-12-31 09:01:56','',''),(2409073,'19','199','1023',467,'Retail Sale Id 1434396',8100.00,0.00,0.00,12.50,1693.75,'2021-12-31 09:01:56','',''),(2409135,'19','199','1023',467,'Retail Sale Id 1434458',3240.00,0.00,0.00,5.00,677.50,'2021-12-31 09:07:23','',''),(2409136,'19','199','1023',467,'Retail Sale Id 1434458',3240.00,0.00,0.00,5.00,677.50,'2021-12-31 09:07:23','',''),(2409235,'19','199','1023',467,'Retail Sale Id 1434535',3888.00,0.00,0.00,6.00,813.00,'2021-12-31 09:16:41','',''),(2409293,'19','199','1023',467,'Retail Sale Id 1434586',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 09:22:41','',''),(2409475,'19','199','1023',467,'Retail Sale Id 1434760',8100.00,0.00,0.00,12.50,1693.75,'2021-12-31 09:45:28','',''),(2409524,'19','199','1023',467,'Retail Sale Id 1434808',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 09:51:53','',''),(2409615,'19','199','1023',467,'Retail Sale Id 1434908',8100.00,0.00,0.00,12.50,1693.75,'2021-12-31 10:05:37','',''),(2409710,'19','199','1023',467,'Retail Sale Id 1435000',3240.00,0.00,0.00,5.00,677.50,'2021-12-31 10:17:44','',''),(2409728,'19','199','1023',467,'Retail Sale Id 1435029',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 10:19:35','',''),(2409799,'19','199','1023',467,'Retail Sale Id 1435083',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 10:25:52','',''),(2409841,'19','199','1023',467,'Retail Sale Id 1435095',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 10:27:28','',''),(2409920,'19','199','1023',467,'Retail Sale Id 1435152',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 10:33:59','',''),(2410093,'19','199','1023',467,'Retail Sale Id 1435289',7776.00,0.00,0.00,12.00,1626.00,'2021-12-31 10:48:24','',''),(2410126,'19','199','1023',467,'Retail Sale Id 1435318',8100.00,0.00,0.00,12.50,1693.75,'2021-12-31 10:51:10','',''),(2410159,'19','199','1023',467,'Retail Sale Id 1435348',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 10:55:30','',''),(2410268,'19','199','1023',467,'Retail Sale Id 1435454',7776.00,0.00,0.00,12.00,1626.00,'2021-12-31 11:08:13','',''),(2410291,'19','199','1023',467,'Retail Sale Id 1435476',3888.00,0.00,0.00,6.00,813.00,'2021-12-31 11:10:51','',''),(2410426,'19','199','1023',467,'Retail Sale Id 1435599',6480.00,0.00,0.00,10.00,1355.00,'2021-12-31 11:25:49','',''),(2410659,'19','199','1023',467,'Retail Sale Id 1435805',8100.00,0.00,0.00,12.50,1693.75,'2021-12-31 11:48:46','',''),(2410705,'19','199','1023',467,'Retail Sale Id 1435854',3240.00,0.00,0.00,5.00,677.50,'2021-12-31 11:54:16','',''),(2411098,'19','199','1023',467,'Retail Sale Id 1436236',8100.00,0.00,0.00,12.50,1693.75,'2021-12-31 12:59:56','',''),(2411151,'19','199','1023',467,'Retail Sale Id 1436292',8100.00,0.00,0.00,12.50,1693.75,'2021-12-31 13:10:45','',''),(2411204,'19','199','1023',467,'Retail Sale Id 1436345',6480.00,0.00,0.00,10.00,1355.00,'2021-12-31 13:17:55','',''),(2411230,'19','199','1023',467,'Retail Sale Id 1436359',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 13:21:08','',''),(2411231,'19','199','1023',467,'Retail Sale Id 1436359',3888.00,0.00,0.00,6.00,813.00,'2021-12-31 13:21:08','',''),(2411271,'19','199','1023',467,'Retail Sale Id 1436412',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 13:26:25','',''),(2411288,'19','199','1023',467,'Retail Sale Id 1436428',3888.00,0.00,0.00,6.00,813.00,'2021-12-31 13:28:23','',''),(2411307,'19','199','1023',467,'Retail Sale Id 1436449',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 13:30:47','',''),(2411344,'19','199','1023',467,'Retail Sale Id 1436480',3888.00,0.00,0.00,6.00,813.00,'2021-12-31 13:35:41','',''),(2411466,'19','199','1023',467,'Retail Sale Id 1436615',2592.00,0.00,0.00,4.00,542.00,'2021-12-31 13:50:16','',''),(2411483,'19','199','1023',467,'Retail Sale Id 1436635',2592.00,0.00,0.00,4.00,542.00,'2021-12-31 13:51:40','',''),(2411623,'19','199','1023',467,'Retail Sale Id 1436739',8100.00,0.00,0.00,12.50,1693.75,'2021-12-31 14:02:05','',''),(2411717,'19','199','1023',467,'Retail Sale Id 1436799',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 14:08:53','',''),(2411739,'19','199','1023',467,'Retail Sale Id 1436817',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 14:10:25','',''),(2411740,'19','199','1023',467,'Retail Sale Id 1436817',3888.00,0.00,0.00,6.00,813.00,'2021-12-31 14:10:25','',''),(2411837,'19','199','1023',467,'Retail Sale Id 1436888',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 14:18:26','',''),(2411885,'19','199','1023',467,'Retail Sale Id 1436932',3240.00,0.00,0.00,5.00,677.50,'2021-12-31 14:24:13','',''),(2411910,'19','199','1023',467,'Retail Sale Id 1436958',8100.00,0.00,0.00,12.50,1693.75,'2021-12-31 14:26:42','',''),(2411979,'19','199','1023',467,'Retail Sale Id 1436988',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 14:31:27','',''),(2412006,'19','199','1023',467,'Retail Sale Id 1437018',8100.00,0.00,0.00,12.50,1693.75,'2021-12-31 14:34:44','',''),(2412145,'19','199','1023',467,'Retail Sale Id 1437131',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 14:48:25','',''),(2412234,'19','199','1023',467,'Retail Sale Id 1437190',6480.00,0.00,0.00,10.00,1355.00,'2021-12-31 14:54:45','',''),(2412252,'19','199','1023',467,'Retail Sale Id 1437209',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 14:56:54','',''),(2412311,'19','199','1023',467,'Retail Sale Id 1437261',8100.00,0.00,0.00,12.50,1693.75,'2021-12-31 15:03:45','',''),(2412689,'19','199','1023',467,'Retail Sale Id 1437580',3240.00,0.00,0.00,5.00,677.50,'2021-12-31 15:32:20','',''),(2412829,'19','199','1023',467,'Retail Sale Id 1437658',1944.00,0.00,0.00,3.00,406.50,'2021-12-31 15:40:15','',''),(2412830,'19','199','1023',467,'Retail Sale Id 1437658',2592.00,0.00,0.00,4.00,542.00,'2021-12-31 15:40:15','',''),(2415029,'19','199','1023',467,'Retail Sale Id 1439314',1944.00,0.00,0.00,3.00,406.50,'2022-01-01 07:36:41','',''),(2415242,'19','199','1023',467,'Retail Sale Id 1439447',1944.00,0.00,0.00,3.00,406.50,'2022-01-01 07:52:31','',''),(2415264,'19','199','1023',467,'Retail Sale Id 1439458',8100.00,0.00,0.00,12.50,1693.75,'2022-01-01 07:53:59','',''),(2415325,'19','199','1023',467,'Retail Sale Id 1439503',8100.00,0.00,0.00,12.50,1693.75,'2022-01-01 07:58:41','',''),(2415451,'19','199','1023',467,'Retail Sale Id 1439634',3888.00,0.00,0.00,6.00,813.00,'2022-01-01 08:11:10','',''),(2415637,'19','199','1023',467,'Retail Sale Id 1439815',3240.00,0.00,0.00,5.00,677.50,'2022-01-01 08:28:29','',''),(2415944,'19','199','1023',467,'Retail Sale Id 1440077',8100.00,0.00,0.00,12.50,1693.75,'2022-01-01 08:53:14','',''),(2416060,'19','199','1023',467,'Retail Sale Id 1440178',8100.00,0.00,0.00,12.50,1693.75,'2022-01-01 09:04:53','',''),(2416072,'19','199','1023',467,'Retail Sale Id 1440190',4050.00,0.00,0.00,6.25,846.88,'2022-01-01 09:06:01','',''),(2416221,'19','199','1023',467,'Retail Sale Id 1440337',8100.00,0.00,0.00,12.50,1693.75,'2022-01-01 09:23:36','',''),(2416245,'19','199','1023',467,'Retail Sale Id 1440358',8100.00,0.00,0.00,12.50,1693.75,'2022-01-01 09:25:31','',''),(2416291,'19','199','1023',467,'Retail Sale Id 1440386',1944.00,0.00,0.00,3.00,406.50,'2022-01-01 09:27:41','',''),(2416314,'19','199','1023',467,'Retail Sale Id 1440410',3888.00,0.00,0.00,6.00,813.00,'2022-01-01 09:30:01','',''),(2416370,'19','199','1023',467,'Retail Sale Id 1440467',12312.00,0.00,0.00,19.00,2574.50,'2022-01-01 09:35:14','',''),(2416434,'19','199','1023',467,'Retail Sale Id 1440514',3240.00,0.00,0.00,5.00,677.50,'2022-01-01 09:42:19','',''),(2416445,'19','199','1023',467,'Retail Sale Id 1440525',3240.00,0.00,0.00,5.00,677.50,'2022-01-01 09:43:40','',''),(2416518,'19','199','1023',467,'Retail Sale Id 1440589',8100.00,0.00,0.00,12.50,1693.75,'2022-01-01 09:49:52','',''),(2416613,'19','199','1023',467,'Retail Sale Id 1440667',3888.00,0.00,0.00,6.00,813.00,'2022-01-01 09:59:03','',''),(2416741,'19','199','1023',467,'Retail Sale Id 1440776',3888.00,0.00,0.00,6.00,813.00,'2022-01-01 10:12:52','',''),(2416908,'19','199','1023',467,'Retail Sale Id 1440937',8100.00,0.00,0.00,12.50,1693.75,'2022-01-01 10:30:32','',''),(2416931,'19','199','1023',467,'Retail Sale Id 1440959',1944.00,0.00,0.00,3.00,406.50,'2022-01-01 10:33:13','',''),(2416980,'19','199','1023',467,'Retail Sale Id 1440990',3240.00,0.00,0.00,5.00,677.50,'2022-01-01 10:37:56','',''),(2416981,'19','199','1023',467,'Retail Sale Id 1440990',3888.00,0.00,0.00,6.00,813.00,'2022-01-01 10:37:56','',''),(2416996,'19','199','1023',467,'Retail Sale Id 1441008',1944.00,0.00,0.00,3.00,406.50,'2022-01-01 10:40:25','',''),(2417027,'19','199','1023',467,'Retail Sale Id 1441038',8100.00,0.00,0.00,12.50,1693.75,'2022-01-01 10:43:33','',''),(2417157,'19','199','1023',467,'Retail Sale Id 1441153',8100.00,0.00,0.00,12.50,1693.75,'2022-01-01 10:56:42','',''),(2417383,'19','199','1023',467,'Retail Sale Id 1441361',8100.00,0.00,0.00,12.50,1693.75,'2022-01-01 11:20:58','',''),(2417467,'19','199','1023',467,'Retail Sale Id 1441445',1944.00,0.00,0.00,3.00,406.50,'2022-01-01 11:31:40','',''),(2417669,'19','199','1023',467,'Retail Sale Id 1441635',8100.00,0.00,0.00,12.50,1693.75,'2022-01-01 11:52:53','',''),(2417762,'19','199','1023',467,'Retail Sale Id 1441734',8100.00,0.00,0.00,12.50,1693.75,'2022-01-01 12:03:11','',''),(2417784,'19','199','1023',467,'Retail Sale Id 1441754',3888.00,0.00,0.00,6.00,813.00,'2022-01-01 12:06:02','',''),(2417827,'19','199','1023',467,'Retail Sale Id 1441794',8100.00,0.00,0.00,12.50,1693.75,'2022-01-01 12:11:41','',''),(2417848,'19','199','1023',467,'Retail Sale Id 1441817',1944.00,0.00,0.00,3.00,406.50,'2022-01-01 12:14:29','',''),(2417942,'19','199','1023',467,'Retail Sale Id 1441912',3240.00,0.00,0.00,5.00,677.50,'2022-01-01 12:25:35','',''),(2418109,'19','199','1023',467,'Retail Sale Id 1442067',1944.00,0.00,0.00,3.00,406.50,'2022-01-01 12:42:07','',''),(2418167,'19','199','1023',467,'Retail Sale Id 1442116',3888.00,0.00,0.00,6.00,813.00,'2022-01-01 12:48:48','',''),(2418177,'19','199','1023',467,'Retail Sale Id 1442129',1944.00,0.00,0.00,3.00,406.50,'2022-01-01 12:51:09','',''),(2418178,'19','199','1023',467,'Retail Sale Id 1442129',6480.00,0.00,0.00,10.00,1355.00,'2022-01-01 12:51:09','',''),(2418255,'19','199','1023',467,'Retail Sale Id 1442200',8100.00,0.00,0.00,12.50,1693.75,'2022-01-01 13:01:04','',''),(2418330,'19','199','1023',467,'Retail Sale Id 1442246',4050.00,0.00,0.00,6.25,846.88,'2022-01-01 13:09:48','',''),(2418361,'19','199','1023',467,'Retail Sale Id 1442275',1944.00,0.00,0.00,3.00,406.50,'2022-01-01 13:14:30','',''),(2418601,'19','199','1023',467,'Retail Sale Id 1442475',3888.00,0.00,0.00,6.00,813.00,'2022-01-01 13:44:11','',''),(2418654,'19','199','1023',467,'Retail Sale Id 1442519',8100.00,0.00,0.00,12.50,1693.75,'2022-01-01 13:50:50','',''),(2418672,'19','199','1023',467,'Retail Sale Id 1442529',3888.00,0.00,0.00,6.00,813.00,'2022-01-01 13:53:44','',''),(2418716,'19','199','1023',467,'Retail Sale Id 1442572',16200.00,0.00,0.00,25.00,3387.50,'2022-01-01 14:00:13','',''),(2418752,'19','199','1023',467,'Retail Sale Id 1442610',8100.00,0.00,0.00,12.50,1693.75,'2022-01-01 14:07:22','',''),(2418761,'19','199','1023',467,'Retail Sale Id 1442616',1944.00,0.00,0.00,3.00,406.50,'2022-01-01 14:08:50','',''),(2421299,'19','199','1023',467,'Retail Sale Id 1444258',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 07:52:34','',''),(2421312,'19','199','1023',467,'Retail Sale Id 1444268',3240.00,0.00,0.00,5.00,677.50,'2022-01-02 07:54:29','',''),(2421319,'19','199','1023',467,'Retail Sale Id 1444277',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 07:55:36','',''),(2421325,'19','199','1023',467,'Retail Sale Id 1444284',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 07:57:10','',''),(2421547,'19','199','1023',467,'Retail Sale Id 1444435',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 08:21:11','',''),(2421566,'19','199','1023',467,'Retail Sale Id 1444462',9072.00,0.00,0.00,14.00,1897.00,'2022-01-02 08:24:25','',''),(2421601,'19','199','1023',467,'Retail Sale Id 1444506',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 08:28:50','',''),(2421602,'19','199','1023',467,'Retail Sale Id 1444506',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 08:28:50','',''),(2421614,'19','199','1023',467,'Retail Sale Id 1444519',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 08:30:26','',''),(2421684,'19','199','1023',467,'Retail Sale Id 1444576',7452.00,0.00,0.00,11.50,1558.25,'2022-01-02 08:38:44','',''),(2421798,'19','199','1023',467,'Retail Sale Id 1444690',6804.00,0.00,0.00,10.50,1422.75,'2022-01-02 08:55:20','',''),(2421880,'19','199','1023',467,'Retail Sale Id 1444775',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 09:07:33','',''),(2421918,'19','199','1023',467,'Retail Sale Id 1444813',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 09:12:38','',''),(2421964,'19','199','1023',467,'Retail Sale Id 1444866',3888.00,0.00,0.00,6.00,813.00,'2022-01-02 09:20:04','',''),(2422003,'19','199','1023',467,'Retail Sale Id 1444910',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 09:25:01','',''),(2422131,'19','199','1023',467,'Retail Sale Id 1445002',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 09:36:55','',''),(2422198,'19','199','1023',467,'Retail Sale Id 1445046',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 09:42:00','',''),(2422222,'19','199','1023',467,'Retail Sale Id 1445071',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 09:45:09','',''),(2422349,'19','199','1023',467,'Retail Sale Id 1445193',4536.00,0.00,0.00,7.00,948.50,'2022-01-02 10:03:21','',''),(2422363,'19','199','1023',467,'Retail Sale Id 1445208',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 10:05:23','',''),(2422388,'19','199','1023',467,'Retail Sale Id 1445225',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 10:07:24','',''),(2422420,'19','199','1023',467,'Retail Sale Id 1445260',2592.00,0.00,0.00,4.00,542.00,'2022-01-02 10:10:47','',''),(2422542,'19','199','1023',467,'Retail Sale Id 1445356',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 10:23:03','',''),(2422556,'19','199','1023',467,'Retail Sale Id 1445371',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 10:24:35','',''),(2422598,'19','199','1023',467,'Retail Sale Id 1445406',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 10:29:27','',''),(2422677,'19','199','1023',467,'Retail Sale Id 1445458',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 10:35:47','',''),(2422694,'19','199','1023',467,'Retail Sale Id 1445474',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 10:37:33','',''),(2422777,'19','199','1023',467,'Retail Sale Id 1445567',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 10:46:21','',''),(2423012,'19','199','1023',467,'Retail Sale Id 1445784',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 11:11:31','',''),(2423013,'19','199','1023',467,'Retail Sale Id 1445784',6480.00,0.00,0.00,10.00,1355.00,'2022-01-02 11:11:31','',''),(2423055,'19','199','1023',467,'Retail Sale Id 1445829',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 11:16:11','',''),(2423107,'19','199','1023',467,'Retail Sale Id 1445874',3888.00,0.00,0.00,6.00,813.00,'2022-01-02 11:21:04','',''),(2423231,'19','199','1023',467,'Retail Sale Id 1446007',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 11:33:32','',''),(2423247,'19','199','1023',467,'Retail Sale Id 1446024',3888.00,0.00,0.00,6.00,813.00,'2022-01-02 11:35:41','',''),(2423358,'19','199','1023',467,'Retail Sale Id 1446136',3888.00,0.00,0.00,6.00,813.00,'2022-01-02 11:49:32','',''),(2423382,'19','199','1023',467,'Retail Sale Id 1446161',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 11:53:56','',''),(2423383,'19','199','1023',467,'Retail Sale Id 1446161',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 11:53:56','',''),(2423412,'19','199','1023',467,'Retail Sale Id 1446192',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 11:58:21','',''),(2423500,'19','199','1023',467,'Retail Sale Id 1446273',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 12:09:38','',''),(2423667,'19','199','1023',467,'Retail Sale Id 1446438',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 12:31:44','',''),(2423746,'19','199','1023',467,'Retail Sale Id 1446525',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 12:40:11','',''),(2423831,'19','199','1023',467,'Retail Sale Id 1446617',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 12:50:20','',''),(2423851,'19','199','1023',467,'Retail Sale Id 1446639',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 12:52:50','',''),(2423864,'19','199','1023',467,'Retail Sale Id 1446653',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 12:54:25','',''),(2424037,'19','199','1023',467,'Retail Sale Id 1446825',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 13:17:03','',''),(2424064,'19','199','1023',467,'Retail Sale Id 1446851',3240.00,0.00,0.00,5.00,677.50,'2022-01-02 13:21:43','',''),(2424168,'19','199','1023',467,'Retail Sale Id 1446960',3240.00,0.00,0.00,5.00,677.50,'2022-01-02 13:36:05','',''),(2424179,'19','199','1023',467,'Retail Sale Id 1446976',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 13:38:06','',''),(2424358,'19','199','1023',467,'Retail Sale Id 1447108',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 13:58:12','',''),(2424387,'19','199','1023',467,'Retail Sale Id 1447131',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 14:01:52','',''),(2424415,'19','199','1023',467,'Retail Sale Id 1447159',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 14:05:48','',''),(2424456,'19','199','1023',467,'Retail Sale Id 1447180',3888.00,0.00,0.00,6.00,813.00,'2022-01-02 14:07:46','',''),(2424541,'19','199','1023',467,'Retail Sale Id 1447227',3888.00,0.00,0.00,6.00,813.00,'2022-01-02 14:14:01','',''),(2424568,'19','199','1023',467,'Retail Sale Id 1447245',3888.00,0.00,0.00,6.00,813.00,'2022-01-02 14:16:41','',''),(2424606,'19','199','1023',467,'Retail Sale Id 1447264',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 14:19:01','',''),(2424681,'19','199','1023',467,'Retail Sale Id 1447310',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 14:24:45','',''),(2424696,'19','199','1023',467,'Retail Sale Id 1447327',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 14:27:21','',''),(2424799,'19','199','1023',467,'Retail Sale Id 1447410',3888.00,0.00,0.00,6.00,813.00,'2022-01-02 14:37:59','',''),(2424811,'19','199','1023',467,'Retail Sale Id 1447426',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 14:39:50','',''),(2424877,'19','199','1023',467,'Retail Sale Id 1447493',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 14:49:59','',''),(2424884,'19','199','1023',467,'Retail Sale Id 1447498',3240.00,0.00,0.00,5.00,677.50,'2022-01-02 14:51:35','',''),(2424893,'19','199','1023',467,'Retail Sale Id 1447507',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 14:53:35','',''),(2424894,'19','199','1023',467,'Retail Sale Id 1447507',3888.00,0.00,0.00,6.00,813.00,'2022-01-02 14:53:35','',''),(2425015,'19','199','1023',467,'Retail Sale Id 1447584',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 15:03:43','',''),(2425033,'19','199','1023',467,'Retail Sale Id 1447602',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 15:06:46','',''),(2425034,'19','199','1023',467,'Retail Sale Id 1447602',3888.00,0.00,0.00,6.00,813.00,'2022-01-02 15:06:46','',''),(2425045,'19','199','1023',467,'Retail Sale Id 1447618',1296.00,0.00,0.00,2.00,271.00,'2022-01-02 15:08:31','',''),(2425105,'19','199','1023',467,'Retail Sale Id 1447679',4536.00,0.00,0.00,7.00,948.50,'2022-01-02 15:21:37','',''),(2425116,'19','199','1023',467,'Retail Sale Id 1447690',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 15:23:58','',''),(2425139,'19','199','1023',467,'Retail Sale Id 1447716',3888.00,0.00,0.00,6.00,813.00,'2022-01-02 15:27:27','',''),(2425155,'19','199','1023',467,'Retail Sale Id 1447731',3888.00,0.00,0.00,6.00,813.00,'2022-01-02 15:29:07','',''),(2425248,'19','199','1023',467,'Retail Sale Id 1447826',3240.00,0.00,0.00,5.00,677.50,'2022-01-02 15:43:34','',''),(2425287,'19','199','1023',467,'Retail Sale Id 1447865',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 15:49:23','',''),(2425288,'19','199','1023',467,'Retail Sale Id 1447865',3240.00,0.00,0.00,5.00,677.50,'2022-01-02 15:49:23','',''),(2425301,'19','199','1023',467,'Retail Sale Id 1447875',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 15:51:00','',''),(2425317,'19','199','1023',467,'Retail Sale Id 1447885',3888.00,0.00,0.00,6.00,813.00,'2022-01-02 15:52:16','',''),(2425342,'19','199','1023',467,'Retail Sale Id 1447905',4536.00,0.00,0.00,7.00,948.50,'2022-01-02 15:54:55','',''),(2425355,'19','199','1023',467,'Retail Sale Id 1447914',3888.00,0.00,0.00,6.00,813.00,'2022-01-02 15:56:27','',''),(2425356,'19','199','1023',467,'Retail Sale Id 1447914',3888.00,0.00,0.00,6.00,813.00,'2022-01-02 15:56:27','',''),(2425374,'19','199','1023',467,'Retail Sale Id 1447932',3888.00,0.00,0.00,6.00,813.00,'2022-01-02 15:58:40','',''),(2425391,'19','199','1023',467,'Retail Sale Id 1447948',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 16:00:53','',''),(2425408,'19','199','1023',467,'Retail Sale Id 1447965',3240.00,0.00,0.00,5.00,677.50,'2022-01-02 16:04:07','',''),(2425409,'19','199','1023',467,'Retail Sale Id 1447965',6480.00,0.00,0.00,10.00,1355.00,'2022-01-02 16:04:07','',''),(2425425,'19','199','1023',467,'Retail Sale Id 1447980',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 16:06:05','',''),(2425461,'19','199','1023',467,'Retail Sale Id 1447991',8100.00,0.00,0.00,12.50,1693.75,'2022-01-02 16:07:40','',''),(2425496,'19','199','1023',467,'Retail Sale Id 1448029',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 16:11:53','',''),(2425497,'19','199','1023',467,'Retail Sale Id 1448029',2592.00,0.00,0.00,4.00,542.00,'2022-01-02 16:11:53','',''),(2425507,'19','199','1023',467,'Retail Sale Id 1448058',5184.00,0.00,0.00,8.00,1084.00,'2022-01-02 16:13:27','',''),(2425543,'19','199','1023',467,'Retail Sale Id 1448096',1944.00,0.00,0.00,3.00,406.50,'2022-01-02 16:18:27','',''),(2425544,'19','199','1023',467,'Retail Sale Id 1448096',3888.00,0.00,0.00,6.00,813.00,'2022-01-02 16:18:27','',''),(2427399,'19','199','1023',467,'Retail Sale Id 1449433',4050.00,0.00,0.00,6.25,846.88,'2022-01-03 08:47:45','',''),(2427732,'19','199','1023',467,'Retail Sale Id 1449716',3240.00,0.00,0.00,5.00,677.50,'2022-01-03 09:19:05','',''),(2427909,'19','199','1023',467,'Retail Sale Id 1449903',4050.00,0.00,0.00,6.25,846.88,'2022-01-03 09:41:11','',''),(2427979,'19','199','1023',467,'Retail Sale Id 1449971',8100.00,0.00,0.00,12.50,1693.75,'2022-01-03 09:49:50','',''),(2428011,'19','199','1023',467,'Retail Sale Id 1450005',4050.00,0.00,0.00,6.25,846.88,'2022-01-03 09:53:03','',''),(2428012,'19','199','1023',467,'Retail Sale Id 1450005',8100.00,0.00,0.00,12.50,1693.75,'2022-01-03 09:53:03','',''),(2428038,'19','199','1023',467,'Retail Sale Id 1450028',2592.00,0.00,0.00,4.00,542.00,'2022-01-03 09:56:00','',''),(2428187,'19','199','1023',467,'Retail Sale Id 1450170',6480.00,0.00,0.00,10.00,1355.00,'2022-01-03 10:13:15','',''),(2428230,'19','199','1023',467,'Retail Sale Id 1450193',3888.00,0.00,0.00,6.00,813.00,'2022-01-03 10:17:33','',''),(2428239,'19','199','1023',467,'Retail Sale Id 1450204',8100.00,0.00,0.00,12.50,1693.75,'2022-01-03 10:19:40','',''),(2428261,'19','199','1023',467,'Retail Sale Id 1450225',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 10:22:48','',''),(2428329,'19','199','1023',467,'Retail Sale Id 1450291',3240.00,0.00,0.00,5.00,677.50,'2022-01-03 10:29:43','',''),(2428348,'19','199','1023',467,'Retail Sale Id 1450310',8100.00,0.00,0.00,12.50,1693.75,'2022-01-03 10:31:41','',''),(2428359,'19','199','1023',467,'Retail Sale Id 1450323',4050.00,0.00,0.00,6.25,846.88,'2022-01-03 10:33:10','',''),(2428381,'19','199','1023',467,'Retail Sale Id 1450340',6480.00,0.00,0.00,10.00,1355.00,'2022-01-03 10:35:26','',''),(2428399,'19','199','1023',467,'Retail Sale Id 1450357',8100.00,0.00,0.00,12.50,1693.75,'2022-01-03 10:37:08','',''),(2428419,'19','199','1023',467,'Retail Sale Id 1450376',8100.00,0.00,0.00,12.50,1693.75,'2022-01-03 10:38:51','',''),(2428434,'19','199','1023',467,'Retail Sale Id 1450392',3240.00,0.00,0.00,5.00,677.50,'2022-01-03 10:40:51','',''),(2428454,'19','199','1023',467,'Retail Sale Id 1450414',8100.00,0.00,0.00,12.50,1693.75,'2022-01-03 10:43:36','',''),(2428500,'19','199','1023',467,'Retail Sale Id 1450456',3888.00,0.00,0.00,6.00,813.00,'2022-01-03 10:50:27','',''),(2428517,'19','199','1023',467,'Retail Sale Id 1450476',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 10:52:54','',''),(2428531,'19','199','1023',467,'Retail Sale Id 1450489',8100.00,0.00,0.00,12.50,1693.75,'2022-01-03 10:55:00','',''),(2428563,'19','199','1023',467,'Retail Sale Id 1450521',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 10:59:25','',''),(2428564,'19','199','1023',467,'Retail Sale Id 1450521',8100.00,0.00,0.00,12.50,1693.75,'2022-01-03 10:59:25','',''),(2428591,'19','199','1023',467,'Retail Sale Id 1450547',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 11:02:01','',''),(2428614,'19','199','1023',467,'Retail Sale Id 1450571',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 11:04:59','',''),(2428635,'19','199','1023',467,'Retail Sale Id 1450591',8100.00,0.00,0.00,12.50,1693.75,'2022-01-03 11:06:54','',''),(2428653,'19','199','1023',467,'Retail Sale Id 1450606',3888.00,0.00,0.00,6.00,813.00,'2022-01-03 11:09:37','',''),(2428663,'19','199','1023',467,'Retail Sale Id 1450617',3888.00,0.00,0.00,6.00,813.00,'2022-01-03 11:10:56','',''),(2428679,'19','199','1023',467,'Retail Sale Id 1450634',5184.00,0.00,0.00,8.00,1084.00,'2022-01-03 11:12:54','',''),(2428687,'19','199','1023',467,'Retail Sale Id 1450642',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 11:14:10','',''),(2428708,'19','199','1023',467,'Retail Sale Id 1450660',4050.00,0.00,0.00,6.25,846.88,'2022-01-03 11:16:08','',''),(2428709,'19','199','1023',467,'Retail Sale Id 1450660',8100.00,0.00,0.00,12.50,1693.75,'2022-01-03 11:16:08','',''),(2428746,'19','199','1023',467,'Retail Sale Id 1450684',4050.00,0.00,0.00,6.25,846.88,'2022-01-03 11:19:11','',''),(2428776,'19','199','1023',467,'Retail Sale Id 1450712',6480.00,0.00,0.00,10.00,1355.00,'2022-01-03 11:22:16','',''),(2428788,'19','199','1023',467,'Retail Sale Id 1450724',3240.00,0.00,0.00,5.00,677.50,'2022-01-03 11:24:10','',''),(2428861,'19','199','1023',467,'Retail Sale Id 1450789',3888.00,0.00,0.00,6.00,813.00,'2022-01-03 11:32:26','',''),(2428907,'19','199','1023',467,'Retail Sale Id 1450821',8100.00,0.00,0.00,12.50,1693.75,'2022-01-03 11:38:22','',''),(2428919,'19','199','1023',467,'Retail Sale Id 1450831',8100.00,0.00,0.00,12.50,1693.75,'2022-01-03 11:40:08','',''),(2428950,'19','199','1023',467,'Retail Sale Id 1450858',3240.00,0.00,0.00,5.00,677.50,'2022-01-03 11:44:32','',''),(2428967,'19','199','1023',467,'Retail Sale Id 1450879',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 11:47:22','',''),(2428968,'19','199','1023',467,'Retail Sale Id 1450879',8100.00,0.00,0.00,12.50,1693.75,'2022-01-03 11:47:22','',''),(2428991,'19','199','1023',467,'Retail Sale Id 1450903',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 11:50:29','',''),(2429018,'19','199','1023',467,'Retail Sale Id 1450928',3888.00,0.00,0.00,6.00,813.00,'2022-01-03 11:53:33','',''),(2429048,'19','199','1023',467,'Retail Sale Id 1450958',8100.00,0.00,0.00,12.50,1693.75,'2022-01-03 11:56:34','',''),(2429087,'19','199','1023',467,'Retail Sale Id 1450993',3240.00,0.00,0.00,5.00,677.50,'2022-01-03 12:01:11','',''),(2429101,'19','199','1023',467,'Retail Sale Id 1451011',8100.00,0.00,0.00,12.50,1693.75,'2022-01-03 12:03:36','',''),(2429165,'19','199','1023',467,'Retail Sale Id 1451070',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 12:13:34','',''),(2429286,'19','199','1023',467,'Retail Sale Id 1451187',4050.00,0.00,0.00,6.25,846.88,'2022-01-03 12:29:25','',''),(2429303,'19','199','1023',467,'Retail Sale Id 1451203',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 12:31:25','',''),(2429362,'19','199','1023',467,'Retail Sale Id 1451252',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 12:37:53','',''),(2429363,'19','199','1023',467,'Retail Sale Id 1451252',4050.00,0.00,0.00,6.25,846.88,'2022-01-03 12:37:53','',''),(2429364,'19','199','1023',467,'Retail Sale Id 1451252',4050.00,0.00,0.00,6.25,846.88,'2022-01-03 12:37:53','',''),(2429439,'19','199','1023',467,'Retail Sale Id 1451317',3240.00,0.00,0.00,5.00,677.50,'2022-01-03 12:47:54','',''),(2429462,'19','199','1023',467,'Retail Sale Id 1451334',2916.00,0.00,0.00,4.50,609.75,'2022-01-03 12:50:15','',''),(2429475,'19','199','1023',467,'Retail Sale Id 1451347',3240.00,0.00,0.00,5.00,677.50,'2022-01-03 12:52:04','',''),(2429494,'19','199','1023',467,'Retail Sale Id 1451359',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 12:54:46','',''),(2429495,'19','199','1023',467,'Retail Sale Id 1451359',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 12:54:46','',''),(2429538,'19','199','1023',467,'Retail Sale Id 1451406',3240.00,0.00,0.00,5.00,677.50,'2022-01-03 13:00:52','',''),(2429552,'19','199','1023',467,'Retail Sale Id 1451419',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 13:02:45','',''),(2429553,'19','199','1023',467,'Retail Sale Id 1451419',4050.00,0.00,0.00,6.25,846.88,'2022-01-03 13:02:45','',''),(2429783,'19','199','1023',467,'Retail Sale Id 1451616',8100.00,0.00,0.00,12.50,1693.75,'2022-01-03 13:22:52','',''),(2429803,'19','199','1023',467,'Retail Sale Id 1451636',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 13:25:04','',''),(2429820,'19','199','1023',467,'Retail Sale Id 1451652',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 13:26:46','',''),(2430117,'19','199','1023',467,'Retail Sale Id 1451867',4050.00,0.00,0.00,6.25,846.88,'2022-01-03 13:48:43','',''),(2430124,'19','199','1023',467,'Retail Sale Id 1451875',3888.00,0.00,0.00,6.00,813.00,'2022-01-03 13:49:54','',''),(2430281,'19','199','1023',467,'Retail Sale Id 1451995',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 14:00:45','',''),(2430311,'19','199','1023',467,'Retail Sale Id 1452016',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 14:03:36','',''),(2430347,'19','199','1023',467,'Retail Sale Id 1452039',3240.00,0.00,0.00,5.00,677.50,'2022-01-03 14:06:03','',''),(2430373,'19','199','1023',467,'Retail Sale Id 1452055',2592.00,0.00,0.00,4.00,542.00,'2022-01-03 14:08:36','',''),(2430570,'19','199','1023',467,'Retail Sale Id 1452186',8100.00,0.00,0.00,12.50,1693.75,'2022-01-03 14:26:13','',''),(2430732,'19','199','1023',467,'Retail Sale Id 1452325',7776.00,0.00,0.00,12.00,1626.00,'2022-01-03 14:43:02','',''),(2430814,'19','199','1023',467,'Retail Sale Id 1452357',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 14:46:55','',''),(2430815,'19','199','1023',467,'Retail Sale Id 1452357',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 14:46:55','',''),(2430816,'19','199','1023',467,'Retail Sale Id 1452357',3240.00,0.00,0.00,5.00,677.50,'2022-01-03 14:46:55','',''),(2430905,'19','199','1023',467,'Retail Sale Id 1452434',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 14:55:29','',''),(2430927,'19','199','1023',467,'Retail Sale Id 1452455',4050.00,0.00,0.00,6.25,846.88,'2022-01-03 14:57:52','',''),(2431006,'19','199','1023',467,'Retail Sale Id 1452537',4050.00,0.00,0.00,6.25,846.88,'2022-01-03 15:08:05','',''),(2431264,'19','199','1023',467,'Retail Sale Id 1452691',4050.00,0.00,0.00,6.25,846.88,'2022-01-03 15:27:32','',''),(2431278,'19','199','1023',467,'Retail Sale Id 1452704',3240.00,0.00,0.00,5.00,677.50,'2022-01-03 15:28:49','',''),(2431290,'19','199','1023',467,'Retail Sale Id 1452717',6480.00,0.00,0.00,10.00,1355.00,'2022-01-03 15:31:07','',''),(2431428,'19','199','1023',467,'Retail Sale Id 1452856',3240.00,0.00,0.00,5.00,677.50,'2022-01-03 15:44:03','',''),(2431456,'19','199','1023',467,'Retail Sale Id 1452883',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 15:46:40','',''),(2431457,'19','199','1023',467,'Retail Sale Id 1452883',4050.00,0.00,0.00,6.25,846.88,'2022-01-03 15:46:40','',''),(2431511,'19','199','1023',467,'Retail Sale Id 1452938',2592.00,0.00,0.00,4.00,542.00,'2022-01-03 15:51:59','',''),(2431559,'19','199','1023',467,'Retail Sale Id 1452984',4050.00,0.00,0.00,6.25,846.88,'2022-01-03 15:56:35','',''),(2431587,'19','199','1023',467,'Retail Sale Id 1453010',7776.00,0.00,0.00,12.00,1626.00,'2022-01-03 15:58:48','',''),(2431647,'19','199','1023',467,'Retail Sale Id 1453071',8100.00,0.00,0.00,12.50,1693.75,'2022-01-03 16:04:25','',''),(2431694,'19','199','1023',467,'Retail Sale Id 1453118',2592.00,0.00,0.00,4.00,542.00,'2022-01-03 16:08:57','',''),(2431713,'19','199','1023',467,'Retail Sale Id 1453137',1944.00,0.00,0.00,3.00,406.50,'2022-01-03 16:10:47','',''),(2431714,'19','199','1023',467,'Retail Sale Id 1453137',8100.00,0.00,0.00,12.50,1693.75,'2022-01-03 16:10:47','',''),(2431795,'19','199','1023',467,'Retail Sale Id 1453217',1296.00,0.00,0.00,2.00,271.00,'2022-01-03 16:19:04','',''),(2433610,'19','199','1023',467,'Retail Sale Id 1454308',8100.00,0.00,0.00,12.50,1693.75,'2022-01-04 07:48:14','',''),(2433632,'19','199','1023',467,'Retail Sale Id 1454325',3240.00,0.00,0.00,5.00,677.50,'2022-01-04 07:50:04','',''),(2433647,'19','199','1023',467,'Retail Sale Id 1454341',3888.00,0.00,0.00,6.00,813.00,'2022-01-04 07:51:54','',''),(2433680,'19','199','1023',467,'Retail Sale Id 1454377',7128.00,0.00,0.00,11.00,1490.50,'2022-01-04 07:55:11','',''),(2433848,'19','199','1023',467,'Retail Sale Id 1454510',30600.00,0.00,0.00,50.00,4975.00,'2022-01-04 08:11:33','',''),(2433849,'19','199','1023',467,'Retail Sale Id 1454510',30600.00,0.00,0.00,50.00,4975.00,'2022-01-04 08:11:33','',''),(2433900,'19','199','1023',467,'Retail Sale Id 1454558',3888.00,0.00,0.00,6.00,813.00,'2022-01-04 08:16:23','',''),(2434214,'19','199','1023',467,'Retail Sale Id 1454792',8100.00,0.00,0.00,12.50,1693.75,'2022-01-04 08:40:37','',''),(2434246,'19','199','1023',467,'Retail Sale Id 1454812',4536.00,0.00,0.00,7.00,948.50,'2022-01-04 08:42:39','',''),(2434275,'19','199','1023',467,'Retail Sale Id 1454828',32400.00,0.00,0.00,50.00,6775.00,'2022-01-04 08:45:57','',''),(2434507,'19','199','1023',467,'Retail Sale Id 1455075',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 09:10:12','',''),(2434508,'19','199','1023',467,'Retail Sale Id 1455075',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 09:10:12','',''),(2434524,'19','199','1023',467,'Retail Sale Id 1455098',8100.00,0.00,0.00,12.50,1693.75,'2022-01-04 09:12:03','',''),(2434539,'19','199','1023',467,'Retail Sale Id 1455114',8100.00,0.00,0.00,12.50,1693.75,'2022-01-04 09:14:04','',''),(2434556,'19','199','1023',467,'Retail Sale Id 1455129',8100.00,0.00,0.00,12.50,1693.75,'2022-01-04 09:15:58','',''),(2434585,'19','199','1023',467,'Retail Sale Id 1455152',3240.00,0.00,0.00,5.00,677.50,'2022-01-04 09:18:54','',''),(2434752,'19','199','1023',467,'Retail Sale Id 1455294',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 09:33:27','',''),(2434982,'19','199','1023',467,'Retail Sale Id 1455459',4050.00,0.00,0.00,6.25,846.88,'2022-01-04 09:53:18','',''),(2434983,'19','199','1023',467,'Retail Sale Id 1455459',4050.00,0.00,0.00,6.25,846.88,'2022-01-04 09:53:18','',''),(2434984,'19','199','1023',467,'Retail Sale Id 1455459',4050.00,0.00,0.00,6.25,846.88,'2022-01-04 09:53:18','',''),(2434985,'19','199','1023',467,'Retail Sale Id 1455459',4050.00,0.00,0.00,6.25,846.88,'2022-01-04 09:53:18','',''),(2434986,'19','199','1023',467,'Retail Sale Id 1455459',6480.00,0.00,0.00,10.00,1355.00,'2022-01-04 09:53:18','',''),(2435226,'19','199','1023',467,'Retail Sale Id 1455679',4050.00,0.00,0.00,6.25,846.88,'2022-01-04 10:18:03','',''),(2435367,'19','199','1023',467,'Retail Sale Id 1455781',3240.00,0.00,0.00,5.00,677.50,'2022-01-04 10:30:30','',''),(2435452,'19','199','1023',467,'Retail Sale Id 1455855',8100.00,0.00,0.00,12.50,1693.75,'2022-01-04 10:37:30','',''),(2435482,'19','199','1023',467,'Retail Sale Id 1455875',6480.00,0.00,0.00,10.00,1355.00,'2022-01-04 10:40:06','',''),(2435483,'19','199','1023',467,'Retail Sale Id 1455875',7452.00,0.00,0.00,11.50,1558.25,'2022-01-04 10:40:06','',''),(2435508,'19','199','1023',467,'Retail Sale Id 1455915',3888.00,0.00,0.00,6.00,813.00,'2022-01-04 10:42:22','',''),(2435550,'19','199','1023',467,'Retail Sale Id 1455957',2916.00,0.00,0.00,4.50,609.75,'2022-01-04 10:46:23','',''),(2435587,'19','199','1023',467,'Retail Sale Id 1455983',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 10:49:05','',''),(2435625,'19','199','1023',467,'Retail Sale Id 1456026',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 10:53:54','',''),(2435626,'19','199','1023',467,'Retail Sale Id 1456026',4050.00,0.00,0.00,6.25,846.88,'2022-01-04 10:53:54','',''),(2435673,'19','199','1023',467,'Retail Sale Id 1456071',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 10:57:59','',''),(2435687,'19','199','1023',467,'Retail Sale Id 1456085',8100.00,0.00,0.00,12.50,1693.75,'2022-01-04 10:59:24','',''),(2435710,'19','199','1023',467,'Retail Sale Id 1456112',2592.00,0.00,0.00,4.00,542.00,'2022-01-04 11:01:26','',''),(2435737,'19','199','1023',467,'Retail Sale Id 1456136',2592.00,0.00,0.00,4.00,542.00,'2022-01-04 11:03:40','',''),(2435798,'19','199','1023',467,'Retail Sale Id 1456204',3240.00,0.00,0.00,5.00,677.50,'2022-01-04 11:10:18','',''),(2435900,'19','199','1023',467,'Retail Sale Id 1456292',8100.00,0.00,0.00,12.50,1693.75,'2022-01-04 11:19:02','',''),(2435940,'19','199','1023',467,'Retail Sale Id 1456329',5832.00,0.00,0.00,9.00,1219.50,'2022-01-04 11:22:51','',''),(2435989,'19','199','1023',467,'Retail Sale Id 1456358',8100.00,0.00,0.00,12.50,1693.75,'2022-01-04 11:25:21','',''),(2436003,'19','199','1023',467,'Retail Sale Id 1456372',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 11:26:42','',''),(2436004,'19','199','1023',467,'Retail Sale Id 1456372',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 11:26:42','',''),(2436218,'19','199','1023',467,'Retail Sale Id 1456579',3240.00,0.00,0.00,5.00,677.50,'2022-01-04 11:48:46','',''),(2436240,'19','199','1023',467,'Retail Sale Id 1456600',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 11:50:36','',''),(2436269,'19','199','1023',467,'Retail Sale Id 1456626',3888.00,0.00,0.00,6.00,813.00,'2022-01-04 11:52:55','',''),(2436288,'19','199','1023',467,'Retail Sale Id 1456641',3240.00,0.00,0.00,5.00,677.50,'2022-01-04 11:55:08','',''),(2436421,'19','199','1023',467,'Retail Sale Id 1456786',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 12:10:07','',''),(2436529,'19','199','1023',467,'Retail Sale Id 1456904',4050.00,0.00,0.00,6.25,846.88,'2022-01-04 12:24:12','',''),(2436565,'19','199','1023',467,'Retail Sale Id 1456938',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 12:28:59','',''),(2436618,'19','199','1023',467,'Retail Sale Id 1456992',4536.00,0.00,0.00,7.00,948.50,'2022-01-04 12:33:45','',''),(2436702,'19','199','1023',467,'Retail Sale Id 1457075',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 12:41:16','',''),(2436742,'19','199','1023',467,'Retail Sale Id 1457116',6480.00,0.00,0.00,10.00,1355.00,'2022-01-04 12:45:57','',''),(2436787,'19','199','1023',467,'Retail Sale Id 1457155',8100.00,0.00,0.00,12.50,1693.75,'2022-01-04 12:51:21','',''),(2436847,'19','199','1023',467,'Retail Sale Id 1457211',3240.00,0.00,0.00,5.00,677.50,'2022-01-04 12:59:15','',''),(2436868,'19','199','1023',467,'Retail Sale Id 1457234',4050.00,0.00,0.00,6.25,846.88,'2022-01-04 13:01:26','',''),(2437009,'19','199','1023',467,'Retail Sale Id 1457348',3240.00,0.00,0.00,5.00,677.50,'2022-01-04 13:15:24','',''),(2437023,'19','199','1023',467,'Retail Sale Id 1457360',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 13:17:26','',''),(2437045,'19','199','1023',467,'Retail Sale Id 1457373',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 13:18:58','',''),(2437090,'19','199','1023',467,'Retail Sale Id 1457411',3240.00,0.00,0.00,5.00,677.50,'2022-01-04 13:23:59','',''),(2437149,'19','199','1023',467,'Retail Sale Id 1457549',8100.00,0.00,0.00,12.50,1693.75,'2022-01-04 13:31:06','',''),(2437219,'19','199','1023',467,'Retail Sale Id 1457608',3888.00,0.00,0.00,6.00,813.00,'2022-01-04 13:35:19','',''),(2437277,'19','199','1023',467,'Retail Sale Id 1457639',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 13:38:24','',''),(2437395,'19','199','1023',467,'Retail Sale Id 1457717',3888.00,0.00,0.00,6.00,813.00,'2022-01-04 13:47:16','',''),(2437408,'19','199','1023',467,'Retail Sale Id 1457732',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 13:48:55','',''),(2437891,'19','199','1023',467,'Retail Sale Id 1458086',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 14:28:33','',''),(2437905,'19','199','1023',467,'Retail Sale Id 1458099',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 14:30:01','',''),(2437939,'19','199','1023',467,'Retail Sale Id 1458126',648.00,0.00,0.00,1.00,135.50,'2022-01-04 14:33:27','',''),(2437975,'19','199','1023',467,'Retail Sale Id 1458159',7452.00,0.00,0.00,11.50,1558.25,'2022-01-04 14:37:00','',''),(2438034,'19','199','1023',467,'Retail Sale Id 1458206',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 14:41:42','',''),(2438055,'19','199','1023',467,'Retail Sale Id 1458221',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 14:43:16','',''),(2438158,'19','199','1023',467,'Retail Sale Id 1458285',4050.00,0.00,0.00,6.25,846.88,'2022-01-04 14:50:26','',''),(2438184,'19','199','1023',467,'Retail Sale Id 1458310',4536.00,0.00,0.00,7.00,948.50,'2022-01-04 14:52:42','',''),(2438208,'19','199','1023',467,'Retail Sale Id 1458333',8100.00,0.00,0.00,12.50,1693.75,'2022-01-04 14:55:23','',''),(2438235,'19','199','1023',467,'Retail Sale Id 1458359',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 14:58:35','',''),(2438488,'19','199','1023',467,'Retail Sale Id 1458542',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 15:14:59','',''),(2438557,'19','199','1023',467,'Retail Sale Id 1458608',4050.00,0.00,0.00,6.25,846.88,'2022-01-04 15:18:02','',''),(2438587,'19','199','1023',467,'Retail Sale Id 1458636',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 15:21:22','',''),(2438685,'19','199','1023',467,'Retail Sale Id 1458715',3240.00,0.00,0.00,5.00,677.50,'2022-01-04 15:30:49','',''),(2438694,'19','199','1023',467,'Retail Sale Id 1458729',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 15:32:29','',''),(2438815,'19','199','1023',467,'Retail Sale Id 1458857',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 15:44:42','',''),(2438836,'19','199','1023',467,'Retail Sale Id 1458874',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 15:46:06','',''),(2439064,'19','199','1023',467,'Retail Sale Id 1459052',1944.00,0.00,0.00,3.00,406.50,'2022-01-04 16:03:57','',''),(2439446,'19','199','1023',467,'Return of Retail Sale Id 1458159',0.00,7452.00,11.50,0.00,-1558.25,'2022-01-04 16:41:37','',''),(2439456,'19','199','1023',467,'Return of Retail Sale Id 1458126',0.00,648.00,1.00,0.00,-135.50,'2022-01-04 16:42:21','',''),(2439468,'19','199','1023',467,'Retail Sale Id 1459466',8100.00,0.00,0.00,12.50,1693.75,'2022-01-04 16:44:10','',''),(2441097,'19','199','1023',467,'Retail Sale Id 1460407',8100.00,0.00,0.00,12.50,1693.75,'2022-01-05 07:46:30','',''),(2441283,'19','199','1023',467,'Retail Sale Id 1460520',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 08:01:33','',''),(2441318,'19','199','1023',467,'Retail Sale Id 1460551',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 08:05:21','',''),(2441319,'19','199','1023',467,'Retail Sale Id 1460551',8100.00,0.00,0.00,12.50,1693.75,'2022-01-05 08:05:21','',''),(2441364,'19','199','1023',467,'Retail Sale Id 1460606',8100.00,0.00,0.00,12.50,1693.75,'2022-01-05 08:10:18','',''),(2441490,'19','199','1023',467,'Retail Sale Id 1460697',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 08:20:29','',''),(2441843,'19','199','1023',467,'Retail Sale Id 1460974',8100.00,0.00,0.00,12.50,1693.75,'2022-01-05 09:50:47','',''),(2441945,'19','199','1023',467,'Retail Sale Id 1461039',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 09:58:24','',''),(2442027,'19','199','1023',467,'Retail Sale Id 1461126',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 10:06:53','',''),(2442079,'19','199','1023',467,'Retail Sale Id 1461171',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 10:10:36','',''),(2442115,'19','199','1023',467,'Retail Sale Id 1461195',4050.00,0.00,0.00,6.25,846.88,'2022-01-05 10:13:21','',''),(2442185,'19','199','1023',467,'Retail Sale Id 1461260',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 10:20:52','',''),(2442306,'19','199','1023',467,'Retail Sale Id 1461372',3240.00,0.00,0.00,5.00,677.50,'2022-01-05 10:31:50','',''),(2442364,'19','199','1023',467,'Retail Sale Id 1461428',4050.00,0.00,0.00,6.25,846.88,'2022-01-05 10:36:52','',''),(2442388,'19','199','1023',467,'Retail Sale Id 1461453',8100.00,0.00,0.00,12.50,1693.75,'2022-01-05 10:39:42','',''),(2442389,'19','199','1023',467,'Retail Sale Id 1461453',8100.00,0.00,0.00,12.50,1693.75,'2022-01-05 10:39:42','',''),(2442555,'19','199','1023',467,'Retail Sale Id 1461611',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 10:55:33','',''),(2442620,'19','199','1023',467,'Retail Sale Id 1461671',4050.00,0.00,0.00,6.25,846.88,'2022-01-05 11:00:40','',''),(2442645,'19','199','1023',467,'Retail Sale Id 1461697',8100.00,0.00,0.00,12.50,1693.75,'2022-01-05 11:03:27','',''),(2442666,'19','199','1023',467,'Retail Sale Id 1461717',4050.00,0.00,0.00,6.25,846.88,'2022-01-05 11:05:43','',''),(2442703,'19','199','1023',467,'Retail Sale Id 1461745',7776.00,0.00,0.00,12.00,1626.00,'2022-01-05 11:08:09','',''),(2442729,'19','199','1023',467,'Retail Sale Id 1461773',8100.00,0.00,0.00,12.50,1693.75,'2022-01-05 11:10:23','',''),(2443279,'19','199','1023',467,'Retail Sale Id 1462231',14256.00,0.00,0.00,22.00,2981.00,'2022-01-05 11:56:13','',''),(2443294,'19','199','1023',467,'Retail Sale Id 1462249',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 11:58:03','',''),(2443295,'19','199','1023',467,'Retail Sale Id 1462249',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 11:58:03','',''),(2443417,'19','199','1023',467,'Retail Sale Id 1462377',8100.00,0.00,0.00,12.50,1693.75,'2022-01-05 12:10:30','',''),(2443480,'19','199','1023',467,'Retail Sale Id 1462447',8100.00,0.00,0.00,12.50,1693.75,'2022-01-05 12:16:08','',''),(2443516,'19','199','1023',467,'Retail Sale Id 1462468',7776.00,0.00,0.00,12.00,1626.00,'2022-01-05 12:19:07','',''),(2443591,'19','199','1023',467,'Retail Sale Id 1462551',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 12:25:36','',''),(2443592,'19','199','1023',467,'Retail Sale Id 1462551',4050.00,0.00,0.00,6.25,846.88,'2022-01-05 12:25:36','',''),(2443721,'19','199','1023',467,'Retail Sale Id 1462661',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 12:37:41','',''),(2443852,'19','199','1023',467,'Retail Sale Id 1462791',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 12:51:10','',''),(2443901,'19','199','1023',467,'Retail Sale Id 1462838',8100.00,0.00,0.00,12.50,1693.75,'2022-01-05 12:56:21','',''),(2443915,'19','199','1023',467,'Retail Sale Id 1462852',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 12:57:35','',''),(2443929,'19','199','1023',467,'Retail Sale Id 1462865',3240.00,0.00,0.00,5.00,677.50,'2022-01-05 12:59:33','',''),(2443947,'19','199','1023',467,'Retail Sale Id 1462881',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 13:00:52','',''),(2444155,'19','199','1023',467,'Retail Sale Id 1463088',30600.00,0.00,0.00,50.00,4975.00,'2022-01-05 13:23:23','',''),(2444156,'19','199','1023',467,'Retail Sale Id 1463088',30600.00,0.00,0.00,50.00,4975.00,'2022-01-05 13:23:23','',''),(2444227,'19','199','1023',467,'Retail Sale Id 1463150',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 13:34:13','',''),(2444228,'19','199','1023',467,'Retail Sale Id 1463150',8100.00,0.00,0.00,12.50,1693.75,'2022-01-05 13:34:13','',''),(2444229,'19','199','1023',467,'Retail Sale Id 1463150',8100.00,0.00,0.00,12.50,1693.75,'2022-01-05 13:34:13','',''),(2444604,'19','199','1023',467,'Retail Sale Id 1463458',3240.00,0.00,0.00,5.00,677.50,'2022-01-05 14:10:25','',''),(2444630,'19','199','1023',467,'Retail Sale Id 1463471',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 14:11:47','',''),(2444652,'19','199','1023',467,'Retail Sale Id 1463484',4050.00,0.00,0.00,6.25,846.88,'2022-01-05 14:13:26','',''),(2444668,'19','199','1023',467,'Retail Sale Id 1463497',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 14:15:29','',''),(2444700,'19','199','1023',467,'Retail Sale Id 1463511',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 14:18:29','',''),(2444979,'19','199','1023',467,'Retail Sale Id 1463730',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 14:49:59','',''),(2444980,'19','199','1023',467,'Retail Sale Id 1463730',8100.00,0.00,0.00,12.50,1693.75,'2022-01-05 14:49:59','',''),(2445013,'19','199','1023',467,'Retail Sale Id 1463754',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 14:54:36','',''),(2445142,'19','199','1023',467,'Retail Sale Id 1463843',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 15:07:01','',''),(2445286,'19','199','1023',467,'Retail Sale Id 1463923',3240.00,0.00,0.00,5.00,677.50,'2022-01-05 15:17:51','',''),(2445455,'19','199','1023',467,'Retail Sale Id 1464024',4050.00,0.00,0.00,6.25,846.88,'2022-01-05 15:29:29','',''),(2445533,'19','199','1023',467,'Retail Sale Id 1464058',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 15:35:15','',''),(2445534,'19','199','1023',467,'Retail Sale Id 1464058',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 15:35:15','',''),(2445588,'19','199','1023',467,'Retail Sale Id 1464101',3240.00,0.00,0.00,5.00,677.50,'2022-01-05 15:39:56','',''),(2445621,'19','199','1023',467,'Retail Sale Id 1464131',8100.00,0.00,0.00,12.50,1693.75,'2022-01-05 15:43:47','',''),(2445758,'19','199','1023',467,'Retail Sale Id 1464251',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 15:55:36','',''),(2445784,'19','199','1023',467,'Retail Sale Id 1464275',8100.00,0.00,0.00,12.50,1693.75,'2022-01-05 15:58:54','',''),(2445826,'19','199','1023',467,'Retail Sale Id 1464311',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 16:03:22','',''),(2445827,'19','199','1023',467,'Retail Sale Id 1464311',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 16:03:22','',''),(2446040,'19','199','1023',467,'Retail Sale Id 1464459',8100.00,0.00,0.00,12.50,1693.75,'2022-01-05 16:22:44','',''),(2446145,'19','199','1023',467,'Retail Sale Id 1464549',3888.00,0.00,0.00,6.00,813.00,'2022-01-05 16:31:13','',''),(2446199,'19','199','1023',467,'Retail Sale Id 1464600',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 16:37:03','',''),(2446346,'19','199','1023',467,'Retail Sale Id 1464742',1944.00,0.00,0.00,3.00,406.50,'2022-01-05 16:51:26','',''),(2446368,'19','199','1023',467,'Retail Sale Id 1464767',8100.00,0.00,0.00,12.50,1693.75,'2022-01-05 16:53:31','',''),(2448920,'19','199','1023',467,'Retail Sale Id 1466432',4050.00,0.00,0.00,6.25,846.88,'2022-01-06 08:41:15','',''),(2449273,'19','199','1023',467,'Retail Sale Id 1466701',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 09:11:57','',''),(2449326,'19','199','1023',467,'Retail Sale Id 1466758',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 09:17:57','',''),(2449413,'19','199','1023',467,'Retail Sale Id 1466833',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 09:25:24','',''),(2449466,'19','199','1023',467,'Retail Sale Id 1466866',3240.00,0.00,0.00,5.00,677.50,'2022-01-06 09:27:27','',''),(2449716,'19','199','1023',467,'Retail Sale Id 1467091',4050.00,0.00,0.00,6.25,846.88,'2022-01-06 09:50:11','',''),(2449887,'19','199','1023',467,'Retail Sale Id 1467279',4050.00,0.00,0.00,6.25,846.88,'2022-01-06 10:11:08','',''),(2449967,'19','199','1023',467,'Retail Sale Id 1467381',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 10:19:44','',''),(2450003,'19','199','1023',467,'Retail Sale Id 1467412',4050.00,0.00,0.00,6.25,846.88,'2022-01-06 10:22:46','',''),(2450004,'19','199','1023',467,'Retail Sale Id 1467412',4050.00,0.00,0.00,6.25,846.88,'2022-01-06 10:22:46','',''),(2450005,'19','199','1023',467,'Retail Sale Id 1467412',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 10:22:46','',''),(2450006,'19','199','1023',467,'Retail Sale Id 1467412',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 10:22:46','',''),(2450265,'19','199','1023',467,'Retail Sale Id 1467570',4050.00,0.00,0.00,6.25,846.88,'2022-01-06 10:38:46','',''),(2450321,'19','199','1023',467,'Retail Sale Id 1467609',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 10:42:50','',''),(2450354,'19','199','1023',467,'Retail Sale Id 1467636',3888.00,0.00,0.00,6.00,813.00,'2022-01-06 10:46:11','',''),(2450405,'19','199','1023',467,'Retail Sale Id 1467691',3888.00,0.00,0.00,6.00,813.00,'2022-01-06 10:54:25','',''),(2450440,'19','199','1023',467,'Retail Sale Id 1467723',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 10:57:34','',''),(2450441,'19','199','1023',467,'Retail Sale Id 1467723',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 10:57:34','',''),(2450518,'19','199','1023',467,'Retail Sale Id 1467803',4050.00,0.00,0.00,6.25,846.88,'2022-01-06 11:08:36','',''),(2450595,'19','199','1023',467,'Retail Sale Id 1467875',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 11:16:11','',''),(2450698,'19','199','1023',467,'Retail Sale Id 1467994',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 11:26:03','',''),(2450792,'19','199','1023',467,'Retail Sale Id 1468076',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 11:34:00','',''),(2450850,'19','199','1023',467,'Retail Sale Id 1468136',4050.00,0.00,0.00,6.25,846.88,'2022-01-06 11:38:31','',''),(2450891,'19','199','1023',467,'Retail Sale Id 1468176',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 11:42:51','',''),(2451061,'19','199','1023',467,'Retail Sale Id 1468371',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 11:58:21','',''),(2451110,'19','199','1023',467,'Retail Sale Id 1468427',3240.00,0.00,0.00,5.00,677.50,'2022-01-06 12:03:34','',''),(2451346,'19','199','1023',467,'Retail Sale Id 1468646',3888.00,0.00,0.00,6.00,813.00,'2022-01-06 12:28:23','',''),(2451364,'19','199','1023',467,'Retail Sale Id 1468668',3240.00,0.00,0.00,5.00,677.50,'2022-01-06 12:30:23','',''),(2451390,'19','199','1023',467,'Retail Sale Id 1468704',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 12:34:17','',''),(2451423,'19','199','1023',467,'Retail Sale Id 1468743',6480.00,0.00,0.00,10.00,1355.00,'2022-01-06 12:37:43','',''),(2451451,'19','199','1023',467,'Retail Sale Id 1468779',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 12:40:45','',''),(2451485,'19','199','1023',467,'Retail Sale Id 1468809',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 12:44:11','',''),(2451548,'19','199','1023',467,'Retail Sale Id 1468870',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 12:52:36','',''),(2451642,'19','199','1023',467,'Retail Sale Id 1468955',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 13:05:14','',''),(2451643,'19','199','1023',467,'Retail Sale Id 1468955',3240.00,0.00,0.00,5.00,677.50,'2022-01-06 13:05:14','',''),(2451686,'19','199','1023',467,'Retail Sale Id 1468992',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 13:11:26','',''),(2451687,'19','199','1023',467,'Retail Sale Id 1468992',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 13:11:26','',''),(2451688,'19','199','1023',467,'Retail Sale Id 1468992',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 13:11:26','',''),(2451816,'19','199','1023',467,'Retail Sale Id 1469112',3240.00,0.00,0.00,5.00,677.50,'2022-01-06 13:22:21','',''),(2451896,'19','199','1023',467,'Retail Sale Id 1469211',3240.00,0.00,0.00,5.00,677.50,'2022-01-06 13:34:15','',''),(2452030,'19','199','1023',467,'Retail Sale Id 1469359',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 13:51:21','',''),(2452111,'19','199','1023',467,'Retail Sale Id 1469450',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 14:02:08','',''),(2452135,'19','199','1023',467,'Retail Sale Id 1469477',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 14:05:15','',''),(2452140,'19','199','1023',467,'Retail Sale Id 1469484',6480.00,0.00,0.00,10.00,1355.00,'2022-01-06 14:06:19','',''),(2452154,'19','199','1023',467,'Retail Sale Id 1469497',4050.00,0.00,0.00,6.25,846.88,'2022-01-06 14:07:45','',''),(2452155,'19','199','1023',467,'Retail Sale Id 1469497',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 14:07:45','',''),(2452173,'19','199','1023',467,'Retail Sale Id 1469514',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 14:09:43','',''),(2452205,'19','199','1023',467,'Retail Sale Id 1469525',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 14:10:59','',''),(2452227,'19','199','1023',467,'Retail Sale Id 1469537',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 14:12:41','',''),(2452373,'19','199','1023',467,'Retail Sale Id 1469625',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 14:28:19','',''),(2452384,'19','199','1023',467,'Retail Sale Id 1469636',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 14:29:38','',''),(2452416,'19','199','1023',467,'Retail Sale Id 1469670',4050.00,0.00,0.00,6.25,846.88,'2022-01-06 14:34:08','',''),(2452431,'19','199','1023',467,'Retail Sale Id 1469679',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 14:36:12','',''),(2452501,'19','199','1023',467,'Retail Sale Id 1469749',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 14:44:13','',''),(2452724,'19','199','1023',467,'Retail Sale Id 1469856',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 14:56:10','',''),(2452832,'19','199','1023',467,'Retail Sale Id 1469908',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 15:01:27','',''),(2452900,'19','199','1023',467,'Retail Sale Id 1469952',4050.00,0.00,0.00,6.25,846.88,'2022-01-06 15:07:01','',''),(2452926,'19','199','1023',467,'Retail Sale Id 1469968',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 15:08:52','',''),(2453016,'19','199','1023',467,'Retail Sale Id 1470010',3888.00,0.00,0.00,6.00,813.00,'2022-01-06 15:14:09','',''),(2453046,'19','199','1023',467,'Retail Sale Id 1470044',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 15:17:19','',''),(2453056,'19','199','1023',467,'Retail Sale Id 1470053',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 15:18:28','',''),(2453128,'19','199','1023',467,'Retail Sale Id 1470115',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 15:26:03','',''),(2453153,'19','199','1023',467,'Retail Sale Id 1470140',4050.00,0.00,0.00,6.25,846.88,'2022-01-06 15:28:59','',''),(2453160,'19','199','1023',467,'Retail Sale Id 1470149',4050.00,0.00,0.00,6.25,846.88,'2022-01-06 15:30:07','',''),(2453186,'19','199','1023',467,'Retail Sale Id 1470174',3240.00,0.00,0.00,5.00,677.50,'2022-01-06 15:33:51','',''),(2453204,'19','199','1023',467,'Retail Sale Id 1470194',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 15:35:26','',''),(2453219,'19','199','1023',467,'Retail Sale Id 1470212',4050.00,0.00,0.00,6.25,846.88,'2022-01-06 15:36:35','',''),(2453261,'19','199','1023',467,'Retail Sale Id 1470246',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 15:39:44','',''),(2453278,'19','199','1023',467,'Retail Sale Id 1470265',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 15:41:06','',''),(2453339,'19','199','1023',467,'Retail Sale Id 1470309',3240.00,0.00,0.00,5.00,677.50,'2022-01-06 15:47:33','',''),(2453356,'19','199','1023',467,'Retail Sale Id 1470322',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 15:49:10','',''),(2453525,'19','199','1023',467,'Retail Sale Id 1470469',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 16:07:22','',''),(2453586,'19','199','1023',467,'Retail Sale Id 1470517',4050.00,0.00,0.00,6.25,846.88,'2022-01-06 16:11:56','',''),(2453644,'19','199','1023',467,'Retail Sale Id 1470578',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 16:18:09','',''),(2453749,'19','199','1023',467,'Retail Sale Id 1470687',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 16:30:04','',''),(2453760,'19','199','1023',467,'Retail Sale Id 1470696',4050.00,0.00,0.00,6.25,846.88,'2022-01-06 16:31:33','',''),(2453798,'19','199','1023',467,'Retail Sale Id 1470725',3240.00,0.00,0.00,5.00,677.50,'2022-01-06 16:34:37','',''),(2453822,'19','199','1023',467,'Retail Sale Id 1470749',3888.00,0.00,0.00,6.00,813.00,'2022-01-06 16:37:07','',''),(2453829,'19','199','1023',467,'Retail Sale Id 1470764',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 16:38:14','',''),(2453838,'19','199','1023',467,'Retail Sale Id 1470777',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 16:39:19','',''),(2453848,'19','199','1023',467,'Retail Sale Id 1470784',4050.00,0.00,0.00,6.25,846.88,'2022-01-06 16:40:29','',''),(2453945,'19','199','1023',467,'Retail Sale Id 1470897',3888.00,0.00,0.00,6.00,813.00,'2022-01-06 16:51:03','',''),(2453959,'19','199','1023',467,'Retail Sale Id 1470915',3240.00,0.00,0.00,5.00,677.50,'2022-01-06 16:52:17','',''),(2454053,'19','199','1023',467,'Retail Sale Id 1471005',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 16:58:54','',''),(2454082,'19','199','1023',467,'Retail Sale Id 1471037',3240.00,0.00,0.00,5.00,677.50,'2022-01-06 17:01:26','',''),(2454083,'19','199','1023',467,'Retail Sale Id 1471037',8100.00,0.00,0.00,12.50,1693.75,'2022-01-06 17:01:26','',''),(2454111,'19','199','1023',467,'Retail Sale Id 1471064',4050.00,0.00,0.00,6.25,846.88,'2022-01-06 17:03:27','',''),(2454145,'19','199','1023',467,'Retail Sale Id 1471097',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 17:06:16','',''),(2454154,'19','199','1023',467,'Retail Sale Id 1471108',1944.00,0.00,0.00,3.00,406.50,'2022-01-06 17:07:13','',''),(2454170,'19','199','1023',467,'Retail Sale Id 1471127',3888.00,0.00,0.00,6.00,813.00,'2022-01-06 17:09:30','',''),(2454191,'19','199','1023',467,'Retail Sale Id 1471148',3240.00,0.00,0.00,5.00,677.50,'2022-01-06 17:11:06','',''),(2456978,'19','199','1023',467,'Retail Sale Id 1473030',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 09:10:27','',''),(2456979,'19','199','1023',467,'Retail Sale Id 1473030',7776.00,0.00,0.00,12.00,1626.00,'2022-01-07 09:10:27','',''),(2457034,'19','199','1023',467,'Retail Sale Id 1473082',4050.00,0.00,0.00,6.25,846.88,'2022-01-07 09:14:26','',''),(2457105,'19','199','1023',467,'Retail Sale Id 1473154',4050.00,0.00,0.00,6.25,846.88,'2022-01-07 09:20:43','',''),(2457106,'19','199','1023',467,'Retail Sale Id 1473154',4050.00,0.00,0.00,6.25,846.88,'2022-01-07 09:20:43','',''),(2457115,'19','199','1023',467,'Retail Sale Id 1473172',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 09:22:20','',''),(2457134,'19','199','1023',467,'Retail Sale Id 1473190',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 09:24:08','',''),(2457158,'19','199','1023',467,'Retail Sale Id 1473215',3240.00,0.00,0.00,5.00,677.50,'2022-01-07 09:26:43','',''),(2457313,'19','199','1023',467,'Retail Sale Id 1473332',8100.00,0.00,0.00,12.50,1693.75,'2022-01-07 09:38:07','',''),(2457567,'19','199','1023',467,'Retail Sale Id 1473565',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 10:09:32','',''),(2457568,'19','199','1023',467,'Retail Sale Id 1473565',8100.00,0.00,0.00,12.50,1693.75,'2022-01-07 10:09:32','',''),(2457642,'19','199','1023',467,'Retail Sale Id 1473619',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 10:16:52','',''),(2457693,'19','199','1023',467,'Retail Sale Id 1473670',3240.00,0.00,0.00,5.00,677.50,'2022-01-07 10:20:52','',''),(2457719,'19','199','1023',467,'Retail Sale Id 1473702',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 10:24:18','',''),(2457749,'19','199','1023',467,'Retail Sale Id 1473726',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 10:27:10','',''),(2457822,'19','199','1023',467,'Retail Sale Id 1473801',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 10:34:45','',''),(2457875,'19','199','1023',467,'Retail Sale Id 1473845',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 10:40:26','',''),(2458009,'19','199','1023',467,'Retail Sale Id 1473988',4050.00,0.00,0.00,6.25,846.88,'2022-01-07 10:55:37','',''),(2458564,'19','199','1023',467,'Retail Sale Id 1474457',2592.00,0.00,0.00,4.00,542.00,'2022-01-07 11:45:04','',''),(2458582,'19','199','1023',467,'Retail Sale Id 1474466',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 11:46:26','',''),(2458599,'19','199','1023',467,'Retail Sale Id 1474482',3240.00,0.00,0.00,5.00,677.50,'2022-01-07 11:47:59','',''),(2458613,'19','199','1023',467,'Retail Sale Id 1474497',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 11:49:09','',''),(2458632,'19','199','1023',467,'Retail Sale Id 1474520',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 11:51:34','',''),(2458633,'19','199','1023',467,'Retail Sale Id 1474520',2592.00,0.00,0.00,4.00,542.00,'2022-01-07 11:51:34','',''),(2458657,'19','199','1023',467,'Retail Sale Id 1474540',3888.00,0.00,0.00,6.00,813.00,'2022-01-07 11:53:52','',''),(2458703,'19','199','1023',467,'Retail Sale Id 1474575',3240.00,0.00,0.00,5.00,677.50,'2022-01-07 11:58:33','',''),(2458723,'19','199','1023',467,'Retail Sale Id 1474594',8100.00,0.00,0.00,12.50,1693.75,'2022-01-07 11:59:48','',''),(2458743,'19','199','1023',467,'Retail Sale Id 1474616',3888.00,0.00,0.00,6.00,813.00,'2022-01-07 12:02:50','',''),(2458777,'19','199','1023',467,'Retail Sale Id 1474655',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 12:07:12','',''),(2458794,'19','199','1023',467,'Retail Sale Id 1474671',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 12:09:14','',''),(2458795,'19','199','1023',467,'Retail Sale Id 1474671',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 12:09:14','',''),(2458840,'19','199','1023',467,'Retail Sale Id 1474715',8100.00,0.00,0.00,12.50,1693.75,'2022-01-07 12:13:41','',''),(2458875,'19','199','1023',467,'Retail Sale Id 1474758',4050.00,0.00,0.00,6.25,846.88,'2022-01-07 12:18:10','',''),(2458945,'19','199','1023',467,'Retail Sale Id 1474832',8100.00,0.00,0.00,12.50,1693.75,'2022-01-07 12:27:52','',''),(2458967,'19','199','1023',467,'Retail Sale Id 1474843',2592.00,0.00,0.00,4.00,542.00,'2022-01-07 12:30:10','',''),(2459076,'19','199','1023',467,'Retail Sale Id 1474955',4536.00,0.00,0.00,7.00,948.50,'2022-01-07 12:43:59','',''),(2459227,'19','199','1023',467,'Retail Sale Id 1475100',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 13:03:38','',''),(2459707,'19','199','1023',467,'Retail Sale Id 1475559',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 14:15:31','',''),(2459724,'19','199','1023',467,'Retail Sale Id 1475576',8100.00,0.00,0.00,12.50,1693.75,'2022-01-07 14:17:27','',''),(2459734,'19','199','1023',467,'Retail Sale Id 1475586',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 14:19:39','',''),(2459735,'19','199','1023',467,'Retail Sale Id 1475586',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 14:19:39','',''),(2459745,'19','199','1023',467,'Retail Sale Id 1475597',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 14:21:13','',''),(2459761,'19','199','1023',467,'Retail Sale Id 1475611',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 14:23:00','',''),(2460309,'19','199','1023',467,'Retail Sale Id 1476042',8100.00,0.00,0.00,12.50,1693.75,'2022-01-07 15:13:24','',''),(2460325,'19','199','1023',467,'Retail Sale Id 1476054',2592.00,0.00,0.00,4.00,542.00,'2022-01-07 15:15:10','',''),(2460341,'19','199','1023',467,'Retail Sale Id 1476068',8100.00,0.00,0.00,12.50,1693.75,'2022-01-07 15:16:49','',''),(2460459,'19','199','1023',467,'Retail Sale Id 1476170',4050.00,0.00,0.00,6.25,846.88,'2022-01-07 15:27:33','',''),(2460488,'19','199','1023',467,'Retail Sale Id 1476194',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 15:29:34','',''),(2460570,'19','199','1023',467,'Retail Sale Id 1476238',8100.00,0.00,0.00,12.50,1693.75,'2022-01-07 15:33:09','',''),(2460655,'19','199','1023',467,'Retail Sale Id 1476295',6480.00,0.00,0.00,10.00,1355.00,'2022-01-07 15:40:02','',''),(2460697,'19','199','1023',467,'Retail Sale Id 1476317',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 15:42:06','',''),(2460771,'19','199','1023',467,'Retail Sale Id 1476369',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 15:47:08','',''),(2460795,'19','199','1023',467,'Retail Sale Id 1476387',3240.00,0.00,0.00,5.00,677.50,'2022-01-07 15:48:33','',''),(2460808,'19','199','1023',467,'Retail Sale Id 1476401',3888.00,0.00,0.00,6.00,813.00,'2022-01-07 15:49:48','',''),(2460823,'19','199','1023',467,'Retail Sale Id 1476417',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 15:51:16','',''),(2460841,'19','199','1023',467,'Retail Sale Id 1476435',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 15:52:45','',''),(2460850,'19','199','1023',467,'Retail Sale Id 1476443',3888.00,0.00,0.00,6.00,813.00,'2022-01-07 15:53:47','',''),(2460859,'19','199','1023',467,'Retail Sale Id 1476454',8100.00,0.00,0.00,12.50,1693.75,'2022-01-07 15:54:48','',''),(2460916,'19','199','1023',467,'Retail Sale Id 1476506',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 16:00:52','',''),(2460942,'19','199','1023',467,'Retail Sale Id 1476519',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 16:02:21','',''),(2460965,'19','199','1023',467,'Retail Sale Id 1476529',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 16:03:49','',''),(2461008,'19','199','1023',467,'Retail Sale Id 1476581',8100.00,0.00,0.00,12.50,1693.75,'2022-01-07 16:10:31','',''),(2461035,'19','199','1023',467,'Retail Sale Id 1476607',8100.00,0.00,0.00,12.50,1693.75,'2022-01-07 16:14:40','',''),(2461112,'19','199','1023',467,'Retail Sale Id 1476682',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 16:24:28','',''),(2461113,'19','199','1023',467,'Retail Sale Id 1476682',3240.00,0.00,0.00,5.00,677.50,'2022-01-07 16:24:28','',''),(2461196,'19','199','1023',467,'Retail Sale Id 1476736',4050.00,0.00,0.00,6.25,846.88,'2022-01-07 16:31:00','',''),(2461223,'19','199','1023',467,'Retail Sale Id 1476755',4050.00,0.00,0.00,6.25,846.88,'2022-01-07 16:32:47','',''),(2461266,'19','199','1023',467,'Retail Sale Id 1476780',8100.00,0.00,0.00,12.50,1693.75,'2022-01-07 16:35:06','',''),(2461294,'19','199','1023',467,'Retail Sale Id 1476797',8100.00,0.00,0.00,12.50,1693.75,'2022-01-07 16:36:55','',''),(2461407,'19','199','1023',467,'Retail Sale Id 1476901',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 16:49:09','',''),(2461424,'19','199','1023',467,'Retail Sale Id 1476918',4050.00,0.00,0.00,6.25,846.88,'2022-01-07 16:51:05','',''),(2461435,'19','199','1023',467,'Retail Sale Id 1476929',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 16:52:36','',''),(2461452,'19','199','1023',467,'Retail Sale Id 1476942',6480.00,0.00,0.00,10.00,1355.00,'2022-01-07 16:54:41','',''),(2461453,'19','199','1023',467,'Retail Sale Id 1476942',8100.00,0.00,0.00,12.50,1693.75,'2022-01-07 16:54:41','',''),(2461516,'19','199','1023',467,'Retail Sale Id 1476998',8100.00,0.00,0.00,12.50,1693.75,'2022-01-07 17:00:20','',''),(2461538,'19','199','1023',467,'Retail Sale Id 1477019',8100.00,0.00,0.00,12.50,1693.75,'2022-01-07 17:02:42','',''),(2461608,'19','199','1023',467,'Retail Sale Id 1477089',1944.00,0.00,0.00,3.00,406.50,'2022-01-07 17:10:02','',''),(2463940,'19','199','1023',467,'Retail Sale Id 1478663',3888.00,0.00,0.00,6.00,813.00,'2022-01-08 08:53:42','',''),(2464107,'19','199','1023',467,'Retail Sale Id 1478857',1944.00,0.00,0.00,3.00,406.50,'2022-01-08 09:08:40','',''),(2464163,'19','199','1023',467,'Retail Sale Id 1478924',8100.00,0.00,0.00,12.50,1693.75,'2022-01-08 09:13:49','',''),(2464247,'19','199','1023',467,'Retail Sale Id 1478985',4050.00,0.00,0.00,6.25,846.88,'2022-01-08 09:20:45','',''),(2464248,'19','199','1023',467,'Retail Sale Id 1478985',4050.00,0.00,0.00,6.25,846.88,'2022-01-08 09:20:45','',''),(2464304,'19','199','1023',467,'Retail Sale Id 1479058',8100.00,0.00,0.00,12.50,1693.75,'2022-01-08 09:27:59','',''),(2464549,'19','199','1023',467,'Retail Sale Id 1479297',8100.00,0.00,0.00,12.50,1693.75,'2022-01-08 09:48:12','',''),(2464714,'19','199','1023',467,'Retail Sale Id 1479418',8100.00,0.00,0.00,12.50,1693.75,'2022-01-08 09:59:11','',''),(2464887,'19','199','1023',467,'Retail Sale Id 1479559',1944.00,0.00,0.00,3.00,406.50,'2022-01-08 10:15:06','',''),(2465188,'19','199','1023',467,'Retail Sale Id 1479834',8100.00,0.00,0.00,12.50,1693.75,'2022-01-08 10:42:20','',''),(2465245,'19','199','1023',467,'Retail Sale Id 1479888',3240.00,0.00,0.00,5.00,677.50,'2022-01-08 10:47:06','',''),(2465423,'19','199','1023',467,'Retail Sale Id 1480017',1944.00,0.00,0.00,3.00,406.50,'2022-01-08 10:59:08','',''),(2465473,'19','199','1023',467,'Retail Sale Id 1480068',8100.00,0.00,0.00,12.50,1693.75,'2022-01-08 11:03:36','',''),(2465512,'19','199','1023',467,'Retail Sale Id 1480107',3240.00,0.00,0.00,5.00,677.50,'2022-01-08 11:06:57','',''),(2465711,'19','199','1023',467,'Retail Sale Id 1480278',8100.00,0.00,0.00,12.50,1693.75,'2022-01-08 11:21:47','',''),(2465712,'19','199','1023',467,'Retail Sale Id 1480278',8100.00,0.00,0.00,12.50,1693.75,'2022-01-08 11:21:47','',''),(2465864,'19','199','1023',467,'Retail Sale Id 1480429',8100.00,0.00,0.00,12.50,1693.75,'2022-01-08 11:35:54','',''),(2465932,'19','199','1023',467,'Retail Sale Id 1480523',8100.00,0.00,0.00,12.50,1693.75,'2022-01-08 11:43:26','',''),(2465952,'19','199','1023',467,'Retail Sale Id 1480537',8100.00,0.00,0.00,12.50,1693.75,'2022-01-08 11:45:34','',''),(2465984,'19','199','1023',467,'Retail Sale Id 1480562',1944.00,0.00,0.00,3.00,406.50,'2022-01-08 11:48:54','',''),(2466066,'19','199','1023',467,'Retail Sale Id 1480643',8100.00,0.00,0.00,12.50,1693.75,'2022-01-08 11:56:32','',''),(2466174,'19','199','1023',467,'Retail Sale Id 1480722',4050.00,0.00,0.00,6.25,846.88,'2022-01-08 12:03:52','',''),(2466665,'19','199','1023',467,'Retail Sale Id 1481152',8100.00,0.00,0.00,12.50,1693.75,'2022-01-08 12:51:45','',''),(2466666,'19','199','1023',467,'Retail Sale Id 1481152',8100.00,0.00,0.00,12.50,1693.75,'2022-01-08 12:51:45','',''),(2466697,'19','199','1023',467,'Retail Sale Id 1481184',4050.00,0.00,0.00,6.25,846.88,'2022-01-08 12:54:41','',''),(2466849,'19','199','1023',467,'Retail Sale Id 1481359',1944.00,0.00,0.00,3.00,406.50,'2022-01-08 13:11:54','',''),(2466895,'19','199','1023',467,'Retail Sale Id 1481395',8748.00,0.00,0.00,13.50,1829.25,'2022-01-08 13:18:38','',''),(2466925,'19','199','1023',467,'Retail Sale Id 1481436',8100.00,0.00,0.00,12.50,1693.75,'2022-01-08 13:21:09','',''),(2467115,'19','199','1023',467,'Retail Sale Id 1481586',3888.00,0.00,0.00,6.00,813.00,'2022-01-08 13:36:49','',''),(2467241,'19','199','1023',467,'Retail Sale Id 1481678',2592.00,0.00,0.00,4.00,542.00,'2022-01-08 13:45:53','',''),(2467275,'19','199','1023',467,'Retail Sale Id 1481696',7776.00,0.00,0.00,12.00,1626.00,'2022-01-08 13:48:03','',''),(2467298,'19','199','1023',467,'Retail Sale Id 1481714',4050.00,0.00,0.00,6.25,846.88,'2022-01-08 13:50:39','',''),(2467430,'19','199','1023',467,'Retail Sale Id 1481806',9720.00,0.00,0.00,15.00,2032.50,'2022-01-08 14:02:42','',''),(2467469,'19','199','1023',467,'Retail Sale Id 1481846',8100.00,0.00,0.00,12.50,1693.75,'2022-01-08 14:06:34','',''),(2467492,'19','199','1023',467,'Retail Sale Id 1481861',1944.00,0.00,0.00,3.00,406.50,'2022-01-08 14:08:26','',''),(2467528,'19','199','1023',467,'Retail Sale Id 1481886',8100.00,0.00,0.00,12.50,1693.75,'2022-01-08 14:11:12','',''),(2467618,'19','199','1023',467,'Retail Sale Id 1481943',1944.00,0.00,0.00,3.00,406.50,'2022-01-08 14:17:28','',''),(2467619,'19','199','1023',467,'Retail Sale Id 1481943',2592.00,0.00,0.00,4.00,542.00,'2022-01-08 14:17:28','',''),(2467678,'19','199','1023',467,'Retail Sale Id 1481984',8100.00,0.00,0.00,12.50,1693.75,'2022-01-08 14:21:50','',''),(2467705,'19','199','1023',467,'Retail Sale Id 1482003',1944.00,0.00,0.00,3.00,406.50,'2022-01-08 14:24:15','',''),(2467950,'19','199','1023',467,'Retail Sale Id 1482200',4050.00,0.00,0.00,6.25,846.88,'2022-01-08 14:45:03','',''),(2467951,'19','199','1023',467,'Retail Sale Id 1482200',8100.00,0.00,0.00,12.50,1693.75,'2022-01-08 14:45:03','',''),(2468059,'19','199','1023',467,'Retail Sale Id 1482292',6804.00,0.00,0.00,10.50,1422.75,'2022-01-08 14:53:34','',''),(2468106,'19','199','1023',467,'Retail Sale Id 1482321',1944.00,0.00,0.00,3.00,406.50,'2022-01-08 14:56:18','',''),(2468128,'19','199','1023',467,'Retail Sale Id 1482345',8100.00,0.00,0.00,12.50,1693.75,'2022-01-08 14:59:14','',''),(2468651,'19','199','1023',467,'Retail Sale Id 1482777',4050.00,0.00,0.00,6.25,846.88,'2022-01-08 15:45:59','',''),(2468652,'19','199','1023',467,'Retail Sale Id 1482777',4050.00,0.00,0.00,6.25,846.88,'2022-01-08 15:45:59','',''),(2468679,'19','199','1023',467,'Retail Sale Id 1482805',1944.00,0.00,0.00,3.00,406.50,'2022-01-08 15:48:14','',''),(2468720,'19','199','1023',467,'Retail Sale Id 1482832',4050.00,0.00,0.00,6.25,846.88,'2022-01-08 15:50:29','',''),(2468737,'19','199','1023',467,'Retail Sale Id 1482847',1944.00,0.00,0.00,3.00,406.50,'2022-01-08 15:52:11','',''),(2468778,'19','199','1023',467,'Retail Sale Id 1482867',1944.00,0.00,0.00,3.00,406.50,'2022-01-08 15:53:46','',''),(2468779,'19','199','1023',467,'Retail Sale Id 1482867',1944.00,0.00,0.00,3.00,406.50,'2022-01-08 15:53:46','',''),(2468927,'19','199','1023',467,'Retail Sale Id 1482982',8100.00,0.00,0.00,12.50,1693.75,'2022-01-08 16:02:37','',''),(2468986,'19','199','1023',467,'Retail Sale Id 1483022',1944.00,0.00,0.00,3.00,406.50,'2022-01-08 16:05:30','',''),(2472299,'19','199','1023',467,'Retail Sale Id 1485944',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 08:55:59','',''),(2472537,'19','199','1023',467,'Retail Sale Id 1486170',8100.00,0.00,0.00,12.50,1693.75,'2022-01-09 09:17:26','',''),(2472580,'19','199','1023',467,'Retail Sale Id 1486213',8100.00,0.00,0.00,12.50,1693.75,'2022-01-09 09:21:41','',''),(2472675,'19','199','1023',467,'Retail Sale Id 1486316',9396.00,0.00,0.00,14.50,1964.75,'2022-01-09 09:31:25','',''),(2472785,'19','199','1023',467,'Retail Sale Id 1486451',8100.00,0.00,0.00,12.50,1693.75,'2022-01-09 09:44:25','',''),(2472850,'19','199','1023',467,'Retail Sale Id 1486513',8100.00,0.00,0.00,12.50,1693.75,'2022-01-09 09:50:39','',''),(2472910,'19','199','1023',467,'Retail Sale Id 1486571',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 09:55:40','',''),(2472936,'19','199','1023',467,'Retail Sale Id 1486600',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 09:58:06','',''),(2473037,'19','199','1023',467,'Retail Sale Id 1486712',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 10:08:44','',''),(2473078,'19','199','1023',467,'Retail Sale Id 1486750',4050.00,0.00,0.00,6.25,846.88,'2022-01-09 10:12:42','',''),(2473108,'19','199','1023',467,'Retail Sale Id 1486784',8100.00,0.00,0.00,12.50,1693.75,'2022-01-09 10:15:01','',''),(2473509,'19','199','1023',467,'Retail Sale Id 1487108',8100.00,0.00,0.00,12.50,1693.75,'2022-01-09 10:45:07','',''),(2473715,'19','199','1023',467,'Retail Sale Id 1487259',8100.00,0.00,0.00,12.50,1693.75,'2022-01-09 10:57:50','',''),(2473800,'19','199','1023',467,'Retail Sale Id 1487349',8100.00,0.00,0.00,12.50,1693.75,'2022-01-09 11:05:21','',''),(2473810,'19','199','1023',467,'Retail Sale Id 1487363',8100.00,0.00,0.00,12.50,1693.75,'2022-01-09 11:06:45','',''),(2473876,'19','199','1023',467,'Retail Sale Id 1487426',8100.00,0.00,0.00,12.50,1693.75,'2022-01-09 11:13:02','',''),(2473957,'19','199','1023',467,'Retail Sale Id 1487508',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 11:20:46','',''),(2473995,'19','199','1023',467,'Retail Sale Id 1487552',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 11:24:39','',''),(2473996,'19','199','1023',467,'Retail Sale Id 1487552',3240.00,0.00,0.00,5.00,677.50,'2022-01-09 11:24:39','',''),(2474051,'19','199','1023',467,'Retail Sale Id 1487592',7452.00,0.00,0.00,11.50,1558.25,'2022-01-09 11:27:21','',''),(2474094,'19','199','1023',467,'Retail Sale Id 1487621',4050.00,0.00,0.00,6.25,846.88,'2022-01-09 11:29:29','',''),(2474211,'19','199','1023',467,'Retail Sale Id 1487729',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 11:37:52','',''),(2474445,'19','199','1023',467,'Retail Sale Id 1487929',3888.00,0.00,0.00,6.00,813.00,'2022-01-09 11:57:35','',''),(2474483,'19','199','1023',467,'Retail Sale Id 1487966',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 12:00:17','',''),(2474484,'19','199','1023',467,'Retail Sale Id 1487966',8100.00,0.00,0.00,12.50,1693.75,'2022-01-09 12:00:17','',''),(2474485,'19','199','1023',467,'Retail Sale Id 1487966',8100.00,0.00,0.00,12.50,1693.75,'2022-01-09 12:00:17','',''),(2474554,'19','199','1023',467,'Retail Sale Id 1488034',8100.00,0.00,0.00,12.50,1693.75,'2022-01-09 12:05:53','',''),(2474876,'19','199','1023',467,'Retail Sale Id 1488383',3240.00,0.00,0.00,5.00,677.50,'2022-01-09 12:36:54','',''),(2474907,'19','199','1023',467,'Retail Sale Id 1488415',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 12:38:51','',''),(2475064,'19','199','1023',467,'Retail Sale Id 1488528',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 12:46:38','',''),(2475087,'19','199','1023',467,'Retail Sale Id 1488554',8100.00,0.00,0.00,12.50,1693.75,'2022-01-09 12:48:28','',''),(2475255,'19','199','1023',467,'Retail Sale Id 1488723',3240.00,0.00,0.00,5.00,677.50,'2022-01-09 13:03:35','',''),(2475290,'19','199','1023',467,'Retail Sale Id 1488748',4050.00,0.00,0.00,6.25,846.88,'2022-01-09 13:05:44','',''),(2475335,'19','199','1023',467,'Retail Sale Id 1488795',2592.00,0.00,0.00,4.00,542.00,'2022-01-09 13:11:36','',''),(2475353,'19','199','1023',467,'Retail Sale Id 1488814',6480.00,0.00,0.00,10.00,1355.00,'2022-01-09 13:13:24','',''),(2475370,'19','199','1023',467,'Retail Sale Id 1488831',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 13:14:48','',''),(2475441,'19','199','1023',467,'Retail Sale Id 1488913',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 13:21:01','',''),(2475442,'19','199','1023',467,'Retail Sale Id 1488913',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 13:21:01','',''),(2475633,'19','199','1023',467,'Retail Sale Id 1489074',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 13:35:40','',''),(2475654,'19','199','1023',467,'Retail Sale Id 1489106',3888.00,0.00,0.00,6.00,813.00,'2022-01-09 13:37:35','',''),(2475977,'19','199','1023',467,'Retail Sale Id 1489459',30600.00,0.00,0.00,50.00,4975.00,'2022-01-09 14:09:43','',''),(2475978,'19','199','1023',467,'Retail Sale Id 1489459',30600.00,0.00,0.00,50.00,4975.00,'2022-01-09 14:09:43','',''),(2476003,'19','199','1023',467,'Retail Sale Id 1489489',4050.00,0.00,0.00,6.25,846.88,'2022-01-09 14:11:46','',''),(2476004,'19','199','1023',467,'Retail Sale Id 1489489',4050.00,0.00,0.00,6.25,846.88,'2022-01-09 14:11:46','',''),(2476033,'19','199','1023',467,'Retail Sale Id 1489520',8100.00,0.00,0.00,12.50,1693.75,'2022-01-09 14:14:59','',''),(2476109,'19','199','1023',467,'Retail Sale Id 1489592',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 14:23:42','',''),(2476147,'19','199','1023',467,'Retail Sale Id 1489623',8100.00,0.00,0.00,12.50,1693.75,'2022-01-09 14:26:54','',''),(2476233,'19','199','1023',467,'Retail Sale Id 1489697',4050.00,0.00,0.00,6.25,846.88,'2022-01-09 14:35:36','',''),(2476449,'19','199','1023',467,'Retail Sale Id 1489818',3240.00,0.00,0.00,5.00,677.50,'2022-01-09 14:48:53','',''),(2476450,'19','199','1023',467,'Retail Sale Id 1489818',8100.00,0.00,0.00,12.50,1693.75,'2022-01-09 14:48:53','',''),(2476492,'19','199','1023',467,'Retail Sale Id 1489853',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 14:52:36','',''),(2476514,'19','199','1023',467,'Retail Sale Id 1489874',3888.00,0.00,0.00,6.00,813.00,'2022-01-09 14:54:51','',''),(2476515,'19','199','1023',467,'Retail Sale Id 1489874',8100.00,0.00,0.00,12.50,1693.75,'2022-01-09 14:54:51','',''),(2476562,'19','199','1023',467,'Retail Sale Id 1489919',4050.00,0.00,0.00,6.25,846.88,'2022-01-09 14:58:56','',''),(2476581,'19','199','1023',467,'Retail Sale Id 1489938',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 15:01:41','',''),(2476582,'19','199','1023',467,'Retail Sale Id 1489938',3888.00,0.00,0.00,6.00,813.00,'2022-01-09 15:01:41','',''),(2476681,'19','199','1023',467,'Retail Sale Id 1490030',8100.00,0.00,0.00,12.50,1693.75,'2022-01-09 15:10:27','',''),(2476729,'19','199','1023',467,'Retail Sale Id 1490059',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 15:13:35','',''),(2476756,'19','199','1023',467,'Retail Sale Id 1490081',3240.00,0.00,0.00,5.00,677.50,'2022-01-09 15:15:19','',''),(2476774,'19','199','1023',467,'Retail Sale Id 1490096',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 15:17:10','',''),(2476791,'19','199','1023',467,'Retail Sale Id 1490109',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 15:19:15','',''),(2476792,'19','199','1023',467,'Retail Sale Id 1490109',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 15:19:15','',''),(2476854,'19','199','1023',467,'Retail Sale Id 1490172',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 15:27:07','',''),(2476885,'19','199','1023',467,'Retail Sale Id 1490210',8100.00,0.00,0.00,12.50,1693.75,'2022-01-09 15:30:15','',''),(2476963,'19','199','1023',467,'Retail Sale Id 1490279',8100.00,0.00,0.00,12.50,1693.75,'2022-01-09 15:38:51','',''),(2477200,'19','199','1023',467,'Retail Sale Id 1490462',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 15:59:22','',''),(2477386,'19','199','1023',467,'Retail Sale Id 1490617',3888.00,0.00,0.00,6.00,813.00,'2022-01-09 16:18:13','',''),(2477561,'19','199','1023',467,'Retail Sale Id 1490809',3240.00,0.00,0.00,5.00,677.50,'2022-01-09 16:36:58','',''),(2477872,'19','199','1023',467,'Retail Sale Id 1491244',1944.00,0.00,0.00,3.00,406.50,'2022-01-09 17:02:58','',''),(2480290,'19','199','1023',467,'Retail Sale Id 1492852',3240.00,0.00,0.00,5.00,677.50,'2022-01-10 08:59:32','',''),(2480291,'19','199','1023',467,'Retail Sale Id 1492852',3888.00,0.00,0.00,6.00,813.00,'2022-01-10 08:59:32','',''),(2480648,'19','199','1023',467,'Retail Sale Id 1493110',3888.00,0.00,0.00,6.00,813.00,'2022-01-10 09:28:09','',''),(2480790,'19','199','1023',467,'Retail Sale Id 1493249',6480.00,0.00,0.00,10.00,1355.00,'2022-01-10 09:43:36','',''),(2480938,'19','199','1023',467,'Retail Sale Id 1493348',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 09:57:47','',''),(2480939,'19','199','1023',467,'Retail Sale Id 1493348',8100.00,0.00,0.00,12.50,1693.75,'2022-01-10 09:57:47','',''),(2480940,'19','199','1023',467,'Retail Sale Id 1493348',8100.00,0.00,0.00,12.50,1693.75,'2022-01-10 09:57:47','',''),(2480999,'19','199','1023',467,'Retail Sale Id 1493400',8100.00,0.00,0.00,12.50,1693.75,'2022-01-10 10:05:09','',''),(2481099,'19','199','1023',467,'Retail Sale Id 1493481',4050.00,0.00,0.00,6.25,846.88,'2022-01-10 10:12:53','',''),(2481139,'19','199','1023',467,'Retail Sale Id 1493510',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 10:16:59','',''),(2481140,'19','199','1023',467,'Retail Sale Id 1493510',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 10:16:59','',''),(2481141,'19','199','1023',467,'Retail Sale Id 1493510',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 10:16:59','',''),(2481160,'19','199','1023',467,'Retail Sale Id 1493528',5184.00,0.00,0.00,8.00,1084.00,'2022-01-10 10:19:01','',''),(2481179,'19','199','1023',467,'Retail Sale Id 1493547',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 10:21:05','',''),(2481285,'19','199','1023',467,'Retail Sale Id 1493663',4050.00,0.00,0.00,6.25,846.88,'2022-01-10 10:32:10','',''),(2481318,'19','199','1023',467,'Retail Sale Id 1493704',4050.00,0.00,0.00,6.25,846.88,'2022-01-10 10:36:02','',''),(2481334,'19','199','1023',467,'Retail Sale Id 1493726',3240.00,0.00,0.00,5.00,677.50,'2022-01-10 10:38:03','',''),(2481454,'19','199','1023',467,'Retail Sale Id 1493846',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 10:55:36','',''),(2481455,'19','199','1023',467,'Retail Sale Id 1493846',3240.00,0.00,0.00,5.00,677.50,'2022-01-10 10:55:36','',''),(2481509,'19','199','1023',467,'Retail Sale Id 1493907',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 11:02:22','',''),(2481560,'19','199','1023',467,'Retail Sale Id 1493959',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 11:08:25','',''),(2481626,'19','199','1023',467,'Retail Sale Id 1494010',3240.00,0.00,0.00,5.00,677.50,'2022-01-10 11:15:56','',''),(2481632,'19','199','1023',467,'Retail Sale Id 1494016',7776.00,0.00,0.00,12.00,1626.00,'2022-01-10 11:17:13','',''),(2481809,'19','199','1023',467,'Retail Sale Id 1494187',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 11:38:58','',''),(2481826,'19','199','1023',467,'Retail Sale Id 1494207',3240.00,0.00,0.00,5.00,677.50,'2022-01-10 11:40:56','',''),(2481848,'19','199','1023',467,'Retail Sale Id 1494227',8100.00,0.00,0.00,12.50,1693.75,'2022-01-10 11:44:29','',''),(2481904,'19','199','1023',467,'Retail Sale Id 1494279',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 11:51:16','',''),(2481946,'19','199','1023',467,'Retail Sale Id 1494313',2592.00,0.00,0.00,4.00,542.00,'2022-01-10 11:55:47','',''),(2481956,'19','199','1023',467,'Retail Sale Id 1494329',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 11:57:18','',''),(2481975,'19','199','1023',467,'Retail Sale Id 1494348',4050.00,0.00,0.00,6.25,846.88,'2022-01-10 12:00:29','',''),(2481976,'19','199','1023',467,'Retail Sale Id 1494348',4050.00,0.00,0.00,6.25,846.88,'2022-01-10 12:00:29','',''),(2482004,'19','199','1023',467,'Retail Sale Id 1494374',4050.00,0.00,0.00,6.25,846.88,'2022-01-10 12:04:11','',''),(2482111,'19','199','1023',467,'Retail Sale Id 1494467',4050.00,0.00,0.00,6.25,846.88,'2022-01-10 12:16:04','',''),(2482274,'19','199','1023',467,'Retail Sale Id 1494576',2592.00,0.00,0.00,4.00,542.00,'2022-01-10 12:27:26','',''),(2482407,'19','199','1023',467,'Retail Sale Id 1494654',8100.00,0.00,0.00,12.50,1693.75,'2022-01-10 12:36:09','',''),(2482446,'19','199','1023',467,'Retail Sale Id 1494693',7776.00,0.00,0.00,12.00,1626.00,'2022-01-10 12:41:15','',''),(2482463,'19','199','1023',467,'Retail Sale Id 1494716',3888.00,0.00,0.00,6.00,813.00,'2022-01-10 12:43:43','',''),(2482477,'19','199','1023',467,'Retail Sale Id 1494736',8100.00,0.00,0.00,12.50,1693.75,'2022-01-10 12:46:10','',''),(2482613,'19','199','1023',467,'Retail Sale Id 1494884',2916.00,0.00,0.00,4.50,609.75,'2022-01-10 13:00:51','',''),(2482627,'19','199','1023',467,'Retail Sale Id 1494898',6480.00,0.00,0.00,10.00,1355.00,'2022-01-10 13:02:30','',''),(2482677,'19','199','1023',467,'Retail Sale Id 1494952',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 13:09:26','',''),(2482731,'19','199','1023',467,'Retail Sale Id 1495017',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 13:19:03','',''),(2482797,'19','199','1023',467,'Retail Sale Id 1495088',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 13:31:16','',''),(2482885,'19','199','1023',467,'Retail Sale Id 1495178',8100.00,0.00,0.00,12.50,1693.75,'2022-01-10 13:44:28','',''),(2482895,'19','199','1023',467,'Retail Sale Id 1495189',6480.00,0.00,0.00,10.00,1355.00,'2022-01-10 13:46:38','',''),(2482908,'19','199','1023',467,'Retail Sale Id 1495202',6480.00,0.00,0.00,10.00,1355.00,'2022-01-10 13:49:18','',''),(2483074,'19','199','1023',467,'Retail Sale Id 1495362',4050.00,0.00,0.00,6.25,846.88,'2022-01-10 14:10:52','',''),(2483091,'19','199','1023',467,'Retail Sale Id 1495391',8100.00,0.00,0.00,12.50,1693.75,'2022-01-10 14:13:56','',''),(2483134,'19','199','1023',467,'Retail Sale Id 1495436',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 14:18:44','',''),(2483157,'19','199','1023',467,'Retail Sale Id 1495450',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 14:20:29','',''),(2483235,'19','199','1023',467,'Retail Sale Id 1495515',8100.00,0.00,0.00,12.50,1693.75,'2022-01-10 14:27:51','',''),(2483343,'19','199','1023',467,'Retail Sale Id 1495659',8100.00,0.00,0.00,12.50,1693.75,'2022-01-10 14:41:00','',''),(2483470,'19','199','1023',467,'Retail Sale Id 1495754',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 14:53:11','',''),(2483601,'19','199','1023',467,'Retail Sale Id 1495865',3888.00,0.00,0.00,6.00,813.00,'2022-01-10 15:07:30','',''),(2483766,'19','199','1023',467,'Retail Sale Id 1496025',3240.00,0.00,0.00,5.00,677.50,'2022-01-10 15:26:21','',''),(2483799,'19','199','1023',467,'Retail Sale Id 1496061',8100.00,0.00,0.00,12.50,1693.75,'2022-01-10 15:30:31','',''),(2483869,'19','199','1023',467,'Retail Sale Id 1496122',8100.00,0.00,0.00,12.50,1693.75,'2022-01-10 15:38:15','',''),(2483897,'19','199','1023',467,'Retail Sale Id 1496145',6480.00,0.00,0.00,10.00,1355.00,'2022-01-10 15:41:20','',''),(2483898,'19','199','1023',467,'Retail Sale Id 1496145',8100.00,0.00,0.00,12.50,1693.75,'2022-01-10 15:41:20','',''),(2483937,'19','199','1023',467,'Retail Sale Id 1496189',8100.00,0.00,0.00,12.50,1693.75,'2022-01-10 15:45:26','',''),(2484042,'19','199','1023',467,'Retail Sale Id 1496283',8100.00,0.00,0.00,12.50,1693.75,'2022-01-10 15:56:53','',''),(2484209,'19','199','1023',467,'Retail Sale Id 1496445',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 16:15:09','',''),(2484232,'19','199','1023',467,'Retail Sale Id 1496467',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 16:17:12','',''),(2484288,'19','199','1023',467,'Retail Sale Id 1496505',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 16:22:22','',''),(2484289,'19','199','1023',467,'Retail Sale Id 1496505',3888.00,0.00,0.00,6.00,813.00,'2022-01-10 16:22:22','',''),(2484311,'19','199','1023',467,'Retail Sale Id 1496528',2592.00,0.00,0.00,4.00,542.00,'2022-01-10 16:25:45','',''),(2484334,'19','199','1023',467,'Retail Sale Id 1496554',3240.00,0.00,0.00,5.00,677.50,'2022-01-10 16:28:16','',''),(2484403,'19','199','1023',467,'Retail Sale Id 1496623',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 16:36:47','',''),(2484504,'19','199','1023',467,'Retail Sale Id 1496689',3888.00,0.00,0.00,6.00,813.00,'2022-01-10 16:44:10','',''),(2484551,'19','199','1023',467,'Retail Sale Id 1496721',1944.00,0.00,0.00,3.00,406.50,'2022-01-10 16:48:17','',''),(2484621,'19','199','1023',467,'Retail Sale Id 1496766',8100.00,0.00,0.00,12.50,1693.75,'2022-01-10 16:52:58','',''),(2487139,'19','199','1023',467,'Return of Retail Sale Id 1496505',0.00,1944.00,3.00,0.00,-406.50,'2022-01-11 08:38:16','',''),(2487140,'19','199','1023',467,'Return of Retail Sale Id 1496505',0.00,3888.00,6.00,0.00,-813.00,'2022-01-11 08:38:16','',''),(2487192,'19','199','1023',467,'Return of Retail Sale Id 1496145',0.00,6480.00,10.00,0.00,-1355.00,'2022-01-11 08:40:11','',''),(2487193,'19','199','1023',467,'Return of Retail Sale Id 1496145',0.00,8100.00,12.50,0.00,-1693.75,'2022-01-11 08:40:11','',''),(2487583,'19','199','1023',467,'Retail Sale Id 1499074',1944.00,0.00,0.00,3.00,406.50,'2022-01-11 09:21:23','',''),(2487584,'19','199','1023',467,'Retail Sale Id 1499074',3888.00,0.00,0.00,6.00,813.00,'2022-01-11 09:21:23','',''),(2487633,'19','199','1023',467,'Retail Sale Id 1499101',6480.00,0.00,0.00,10.00,1355.00,'2022-01-11 09:24:07','',''),(2487634,'19','199','1023',467,'Retail Sale Id 1499101',8100.00,0.00,0.00,12.50,1693.75,'2022-01-11 09:24:07','',''),(2487742,'19','199','1023',467,'Retail Sale Id 1499193',3888.00,0.00,0.00,6.00,813.00,'2022-01-11 09:34:27','',''),(2487743,'19','199','1023',467,'Retail Sale Id 1499193',8100.00,0.00,0.00,12.50,1693.75,'2022-01-11 09:34:27','',''),(2487866,'19','199','1023',467,'Retail Sale Id 1499291',1944.00,0.00,0.00,3.00,406.50,'2022-01-11 09:44:40','',''),(2487881,'19','199','1023',467,'Retail Sale Id 1499302',1944.00,0.00,0.00,3.00,406.50,'2022-01-11 09:46:25','',''),(2487910,'19','199','1023',467,'Retail Sale Id 1499319',3888.00,0.00,0.00,6.00,813.00,'2022-01-11 09:48:05','',''),(2487932,'19','199','1023',467,'Retail Sale Id 1499342',8100.00,0.00,0.00,12.50,1693.75,'2022-01-11 09:49:57','',''),(2487961,'19','199','1023',467,'Retail Sale Id 1499369',3888.00,0.00,0.00,6.00,813.00,'2022-01-11 09:53:07','',''),(2487978,'19','199','1023',467,'Retail Sale Id 1499389',7128.00,0.00,0.00,11.00,1490.50,'2022-01-11 09:55:17','',''),(2488006,'19','199','1023',467,'Retail Sale Id 1499411',1944.00,0.00,0.00,3.00,406.50,'2022-01-11 09:58:07','',''),(2488017,'19','199','1023',467,'Retail Sale Id 1499426',8100.00,0.00,0.00,12.50,1693.75,'2022-01-11 09:59:38','',''),(2488032,'19','199','1023',467,'Retail Sale Id 1499440',6480.00,0.00,0.00,10.00,1355.00,'2022-01-11 10:01:42','',''),(2488041,'19','199','1023',467,'Retail Sale Id 1499451',1944.00,0.00,0.00,3.00,406.50,'2022-01-11 10:03:03','',''),(2488142,'19','199','1023',467,'Retail Sale Id 1499510',2592.00,0.00,0.00,4.00,542.00,'2022-01-11 10:09:29','',''),(2488185,'19','199','1023',467,'Retail Sale Id 1499540',8100.00,0.00,0.00,12.50,1693.75,'2022-01-11 10:12:53','',''),(2488208,'19','199','1023',467,'Retail Sale Id 1499562',3888.00,0.00,0.00,6.00,813.00,'2022-01-11 10:15:18','',''),(2488319,'19','199','1023',467,'Retail Sale Id 1499652',1944.00,0.00,0.00,3.00,406.50,'2022-01-11 10:27:07','',''),(2488435,'19','199','1023',467,'Retail Sale Id 1499761',4050.00,0.00,0.00,6.25,846.88,'2022-01-11 10:39:45','',''),(2488452,'19','199','1023',467,'Retail Sale Id 1499778',1944.00,0.00,0.00,3.00,406.50,'2022-01-11 10:42:07','',''),(2488512,'19','199','1023',467,'Retail Sale Id 1499832',3240.00,0.00,0.00,5.00,677.50,'2022-01-11 10:48:26','',''),(2488632,'19','199','1023',467,'Retail Sale Id 1499925',4050.00,0.00,0.00,6.25,846.88,'2022-01-11 10:57:48','',''),(2488633,'19','199','1023',467,'Retail Sale Id 1499925',4050.00,0.00,0.00,6.25,846.88,'2022-01-11 10:57:48','',''),(2488634,'19','199','1023',467,'Retail Sale Id 1499925',8100.00,0.00,0.00,12.50,1693.75,'2022-01-11 10:57:48','',''),(2488669,'19','199','1023',467,'Retail Sale Id 1499957',6804.00,0.00,0.00,10.50,1422.75,'2022-01-11 11:00:38','',''),(2488721,'19','199','1023',467,'Retail Sale Id 1500020',1944.00,0.00,0.00,3.00,406.50,'2022-01-11 11:07:54','',''),(2488756,'19','199','1023',467,'Retail Sale Id 1500053',8100.00,0.00,0.00,12.50,1693.75,'2022-01-11 11:11:43','',''),(2488842,'19','199','1023',467,'Retail Sale Id 1500145',4050.00,0.00,0.00,6.25,846.88,'2022-01-11 11:21:12','',''),(2488916,'19','199','1023',467,'Retail Sale Id 1500207',1944.00,0.00,0.00,3.00,406.50,'2022-01-11 11:29:32','',''),(2488917,'19','199','1023',467,'Retail Sale Id 1500207',3888.00,0.00,0.00,6.00,813.00,'2022-01-11 11:29:32','',''),(2488944,'19','199','1023',467,'Retail Sale Id 1500243',1944.00,0.00,0.00,3.00,406.50,'2022-01-11 11:31:57','',''),(2488975,'19','199','1023',467,'Retail Sale Id 1500273',3240.00,0.00,0.00,5.00,677.50,'2022-01-11 11:35:12','',''),(2488976,'19','199','1023',467,'Retail Sale Id 1500273',6804.00,0.00,0.00,10.50,1422.75,'2022-01-11 11:35:12','',''),(2488995,'19','199','1023',467,'Retail Sale Id 1500297',8100.00,0.00,0.00,12.50,1693.75,'2022-01-11 11:37:31','',''),(2489172,'19','199','1023',467,'Retail Sale Id 1500402',4050.00,0.00,0.00,6.25,846.88,'2022-01-11 11:52:04','',''),(2489190,'19','199','1023',467,'Retail Sale Id 1500416',3240.00,0.00,0.00,5.00,677.50,'2022-01-11 11:53:55','',''),(2489232,'19','199','1023',467,'Retail Sale Id 1500451',3240.00,0.00,0.00,5.00,677.50,'2022-01-11 11:59:31','',''),(2489251,'19','199','1023',467,'Retail Sale Id 1500476',4050.00,0.00,0.00,6.25,846.88,'2022-01-11 12:03:33','',''),(2489267,'19','199','1023',467,'Retail Sale Id 1500492',1944.00,0.00,0.00,3.00,406.50,'2022-01-11 12:05:47','',''),(2489277,'19','199','1023',467,'Retail Sale Id 1500502',1944.00,0.00,0.00,3.00,406.50,'2022-01-11 12:07:30','',''),(2489278,'19','199','1023',467,'Retail Sale Id 1500502',1944.00,0.00,0.00,3.00,406.50,'2022-01-11 12:07:30','',''),(2489307,'19','199','1023',467,'Retail Sale Id 1500540',3888.00,0.00,0.00,6.00,813.00,'2022-01-11 12:12:11','',''),(2489339,'19','199','1023',467,'Retail Sale Id 1500579',4050.00,0.00,0.00,6.25,846.88,'2022-01-11 12:17:27','',''),(2489347,'19','199','1023',467,'Retail Sale Id 1500591',1944.00,0.00,0.00,3.00,406.50,'2022-01-11 12:19:32','',''),(2489549,'19','199','1023',467,'Retail Sale Id 1500812',4536.00,0.00,0.00,7.00,948.50,'2022-01-11 12:51:31','',''),(2489579,'19','199','1023',467,'Retail Sale Id 1500844',1944.00,0.00,0.00,3.00,406.50,'2022-01-11 12:56:53','',''),(2489580,'19','199','1023',467,'Retail Sale Id 1500844',3888.00,0.00,0.00,6.00,813.00,'2022-01-11 12:56:53','',''),(2489646,'19','199','1023',467,'Retail Sale Id 1500906',4050.00,0.00,0.00,6.25,846.88,'2022-01-11 13:05:54','',''),(2489866,'19','199','1023',467,'Retail Sale Id 1501112',8100.00,0.00,0.00,12.50,1693.75,'2022-01-11 13:33:15','',''),(2490013,'19','199','1023',467,'Retail Sale Id 1501249',3888.00,0.00,0.00,6.00,813.00,'2022-01-11 13:51:27','',''),(2490135,'19','199','1023',467,'Retail Sale Id 1501356',3240.00,0.00,0.00,5.00,677.50,'2022-01-11 14:03:54','',''),(2490175,'19','199','1023',467,'Retail Sale Id 1501394',1944.00,0.00,0.00,3.00,406.50,'2022-01-11 14:09:55','',''),(2490441,'19','199','1023',467,'Retail Sale Id 1501619',2592.00,0.00,0.00,4.00,542.00,'2022-01-11 14:33:10','',''),(2490493,'19','199','1023',467,'Retail Sale Id 1501639',1944.00,0.00,0.00,3.00,406.50,'2022-01-11 14:35:13','',''),(2490545,'19','199','1023',467,'Retail Sale Id 1501673',1944.00,0.00,0.00,3.00,406.50,'2022-01-11 14:40:45','',''),(2490803,'19','199','1023',467,'Retail Sale Id 1501834',8100.00,0.00,0.00,12.50,1693.75,'2022-01-11 15:01:26','',''),(2490813,'19','199','1023',467,'Retail Sale Id 1501843',8100.00,0.00,0.00,12.50,1693.75,'2022-01-11 15:03:19','',''),(2490900,'19','199','1023',467,'Retail Sale Id 1501898',8100.00,0.00,0.00,12.50,1693.75,'2022-01-11 15:09:54','',''),(2490953,'19','199','1023',467,'Retail Sale Id 1501931',3888.00,0.00,0.00,6.00,813.00,'2022-01-11 15:13:58','',''),(2491071,'19','199','1023',467,'Retail Sale Id 1501997',4050.00,0.00,0.00,6.25,846.88,'2022-01-11 15:21:22','',''),(2491072,'19','199','1023',467,'Retail Sale Id 1501997',4050.00,0.00,0.00,6.25,846.88,'2022-01-11 15:21:22','',''),(2491273,'19','199','1023',467,'Retail Sale Id 1502186',4860.00,0.00,0.00,7.50,1016.25,'2022-01-11 15:40:36','',''),(2491593,'19','199','1023',467,'Retail Sale Id 1502472',8100.00,0.00,0.00,12.50,1693.75,'2022-01-11 16:14:12','',''),(2491624,'19','199','1023',467,'Retail Sale Id 1502513',1944.00,0.00,0.00,3.00,406.50,'2022-01-11 16:17:13','',''),(2491783,'19','199','1023',467,'Retail Sale Id 1502670',8100.00,0.00,0.00,12.50,1693.75,'2022-01-11 16:35:01','',''),(2491818,'19','199','1023',467,'Retail Sale Id 1502716',8100.00,0.00,0.00,12.50,1693.75,'2022-01-11 16:37:43','',''),(2491837,'19','199','1023',467,'Retail Sale Id 1502735',3240.00,0.00,0.00,5.00,677.50,'2022-01-11 16:39:19','',''),(2491903,'19','199','1023',467,'Retail Sale Id 1502804',8100.00,0.00,0.00,12.50,1693.75,'2022-01-11 16:44:38','',''),(2491927,'19','199','1023',467,'Retail Sale Id 1502825',8100.00,0.00,0.00,12.50,1693.75,'2022-01-11 16:46:28','',''),(2492244,'19','199','1023',467,'Retail Sale Id 1503089',8100.00,0.00,0.00,12.50,1693.75,'2022-01-11 17:08:34','',''),(2494504,'19','199','1023',467,'Retail Sale Id 1504693',8100.00,0.00,0.00,12.50,1693.75,'2022-01-12 08:22:25','',''),(2494566,'19','199','1023',467,'Retail Sale Id 1504751',3240.00,0.00,0.00,5.00,677.50,'2022-01-12 08:29:18','',''),(2494616,'19','199','1023',467,'Retail Sale Id 1504796',4050.00,0.00,0.00,6.25,846.88,'2022-01-12 08:33:00','',''),(2494907,'19','199','1023',467,'Retail Sale Id 1505041',2916.00,0.00,0.00,4.50,609.75,'2022-01-12 08:55:36','',''),(2495019,'19','199','1023',467,'Retail Sale Id 1505122',3240.00,0.00,0.00,5.00,677.50,'2022-01-12 09:04:47','',''),(2495166,'19','199','1023',467,'Retail Sale Id 1505229',8100.00,0.00,0.00,12.50,1693.75,'2022-01-12 09:15:05','',''),(2495748,'19','199','1023',467,'Retail Sale Id 1505718',1944.00,0.00,0.00,3.00,406.50,'2022-01-12 10:02:17','',''),(2495749,'19','199','1023',467,'Retail Sale Id 1505718',1944.00,0.00,0.00,3.00,406.50,'2022-01-12 10:02:17','',''),(2495750,'19','199','1023',467,'Retail Sale Id 1505718',1944.00,0.00,0.00,3.00,406.50,'2022-01-12 10:02:17','',''),(2496025,'19','199','1023',467,'Retail Sale Id 1506033',1944.00,0.00,0.00,3.00,406.50,'2022-01-12 10:25:19','',''),(2496076,'19','199','1023',467,'Retail Sale Id 1506076',4050.00,0.00,0.00,6.25,846.88,'2022-01-12 10:29:32','',''),(2496199,'19','199','1023',467,'Retail Sale Id 1506219',8100.00,0.00,0.00,12.50,1693.75,'2022-01-12 10:43:45','',''),(2496222,'19','199','1023',467,'Retail Sale Id 1506252',1944.00,0.00,0.00,3.00,406.50,'2022-01-12 10:45:38','',''),(2496342,'19','199','1023',467,'Retail Sale Id 1506373',3888.00,0.00,0.00,6.00,813.00,'2022-01-12 10:57:41','',''),(2496490,'19','199','1023',467,'Retail Sale Id 1506538',3240.00,0.00,0.00,5.00,677.50,'2022-01-12 11:11:31','',''),(2496544,'19','199','1023',467,'Retail Sale Id 1506598',3240.00,0.00,0.00,5.00,677.50,'2022-01-12 11:16:40','',''),(2496887,'19','199','1023',467,'Retail Sale Id 1506837',1944.00,0.00,0.00,3.00,406.50,'2022-01-12 11:45:36','',''),(2496986,'19','199','1023',467,'Retail Sale Id 1506948',3240.00,0.00,0.00,5.00,677.50,'2022-01-12 11:58:31','',''),(2497055,'19','199','1023',467,'Retail Sale Id 1507028',1944.00,0.00,0.00,3.00,406.50,'2022-01-12 12:06:26','',''),(2497148,'19','199','1023',467,'Retail Sale Id 1507118',8100.00,0.00,0.00,12.50,1693.75,'2022-01-12 12:17:01','',''),(2497149,'19','199','1023',467,'Retail Sale Id 1507118',8100.00,0.00,0.00,12.50,1693.75,'2022-01-12 12:17:01','',''),(2497204,'19','199','1023',467,'Retail Sale Id 1507180',3240.00,0.00,0.00,5.00,677.50,'2022-01-12 12:22:38','',''),(2497243,'19','199','1023',467,'Retail Sale Id 1507218',8100.00,0.00,0.00,12.50,1693.75,'2022-01-12 12:26:13','',''),(2497273,'19','199','1023',467,'Retail Sale Id 1507248',8100.00,0.00,0.00,12.50,1693.75,'2022-01-12 12:28:48','',''),(2497303,'19','199','1023',467,'Retail Sale Id 1507280',8100.00,0.00,0.00,12.50,1693.75,'2022-01-12 12:34:08','',''),(2497336,'19','199','1023',467,'Retail Sale Id 1507313',4050.00,0.00,0.00,6.25,846.88,'2022-01-12 12:38:56','',''),(2497385,'19','199','1023',467,'Retail Sale Id 1507364',8100.00,0.00,0.00,12.50,1693.75,'2022-01-12 12:45:53','',''),(2497435,'19','199','1023',467,'Retail Sale Id 1507430',5832.00,0.00,0.00,9.00,1219.50,'2022-01-12 12:51:23','',''),(2497454,'19','199','1023',467,'Retail Sale Id 1507446',4536.00,0.00,0.00,7.00,948.50,'2022-01-12 12:53:48','',''),(2497654,'19','199','1023',467,'Retail Sale Id 1507631',6480.00,0.00,0.00,10.00,1355.00,'2022-01-12 13:18:11','',''),(2497746,'19','199','1023',467,'Retail Sale Id 1507726',1944.00,0.00,0.00,3.00,406.50,'2022-01-12 13:29:01','',''),(2497780,'19','199','1023',467,'Retail Sale Id 1507757',1944.00,0.00,0.00,3.00,406.50,'2022-01-12 13:32:39','',''),(2497781,'19','199','1023',467,'Retail Sale Id 1507757',8100.00,0.00,0.00,12.50,1693.75,'2022-01-12 13:32:39','',''),(2497918,'19','199','1023',467,'Retail Sale Id 1507885',4536.00,0.00,0.00,7.00,948.50,'2022-01-12 13:52:42','',''),(2498068,'19','199','1023',467,'Retail Sale Id 1508037',6480.00,0.00,0.00,10.00,1355.00,'2022-01-12 14:06:57','',''),(2498100,'19','199','1023',467,'Retail Sale Id 1508075',8100.00,0.00,0.00,12.50,1693.75,'2022-01-12 14:10:42','',''),(2498161,'19','199','1023',467,'Retail Sale Id 1508111',1944.00,0.00,0.00,3.00,406.50,'2022-01-12 14:15:50','',''),(2498187,'19','199','1023',467,'Retail Sale Id 1508144',3888.00,0.00,0.00,6.00,813.00,'2022-01-12 14:17:45','',''),(2498262,'19','199','1023',467,'Retail Sale Id 1508223',1944.00,0.00,0.00,3.00,406.50,'2022-01-12 14:25:36','',''),(2498382,'19','199','1023',467,'Retail Sale Id 1508320',1944.00,0.00,0.00,3.00,406.50,'2022-01-12 14:34:01','',''),(2498412,'19','199','1023',467,'Retail Sale Id 1508345',1944.00,0.00,0.00,3.00,406.50,'2022-01-12 14:37:43','',''),(2498480,'19','199','1023',467,'Retail Sale Id 1508399',8100.00,0.00,0.00,12.50,1693.75,'2022-01-12 14:45:24','',''),(2498615,'19','199','1023',467,'Retail Sale Id 1508552',3240.00,0.00,0.00,5.00,677.50,'2022-01-12 14:57:14','',''),(2498684,'19','199','1023',467,'Retail Sale Id 1508581',1944.00,0.00,0.00,3.00,406.50,'2022-01-12 15:01:03','',''),(2498729,'19','199','1023',467,'Retail Sale Id 1508608',8100.00,0.00,0.00,12.50,1693.75,'2022-01-12 15:03:00','',''),(2498764,'19','199','1023',467,'Retail Sale Id 1508639',8100.00,0.00,0.00,12.50,1693.75,'2022-01-12 15:06:09','',''),(2498842,'19','199','1023',467,'Retail Sale Id 1508664',1944.00,0.00,0.00,3.00,406.50,'2022-01-12 15:08:30','',''),(2498882,'19','199','1023',467,'Retail Sale Id 1508703',2592.00,0.00,0.00,4.00,542.00,'2022-01-12 15:12:53','',''),(2499168,'19','199','1023',467,'Retail Sale Id 1508948',8100.00,0.00,0.00,12.50,1693.75,'2022-01-12 15:38:43','',''),(2499300,'19','199','1023',467,'Retail Sale Id 1509073',3888.00,0.00,0.00,6.00,813.00,'2022-01-12 15:52:27','',''),(2499385,'19','199','1023',467,'Retail Sale Id 1509155',8100.00,0.00,0.00,12.50,1693.75,'2022-01-12 16:04:54','',''),(2499464,'19','199','1023',467,'Retail Sale Id 1509250',2592.00,0.00,0.00,4.00,542.00,'2022-01-12 16:14:37','',''),(2499465,'19','199','1023',467,'Retail Sale Id 1509250',2592.00,0.00,0.00,4.00,542.00,'2022-01-12 16:14:37','',''),(2499551,'19','199','1023',467,'Retail Sale Id 1509328',8100.00,0.00,0.00,12.50,1693.75,'2022-01-12 16:22:26','',''),(2499582,'19','199','1023',467,'Retail Sale Id 1509355',3888.00,0.00,0.00,6.00,813.00,'2022-01-12 16:25:30','',''),(2499715,'19','199','1023',467,'Retail Sale Id 1509430',8100.00,0.00,0.00,12.50,1693.75,'2022-01-12 16:35:35','',''),(2499741,'19','199','1023',467,'Retail Sale Id 1509503',1944.00,0.00,0.00,3.00,406.50,'2022-01-12 16:38:07','',''),(2499785,'19','199','1023',467,'Retail Sale Id 1509535',3240.00,0.00,0.00,5.00,677.50,'2022-01-12 16:42:10','',''),(2499947,'19','199','1023',467,'Retail Sale Id 1509683',6480.00,0.00,0.00,10.00,1355.00,'2022-01-12 16:53:11','',''),(2499957,'19','199','1023',467,'Retail Sale Id 1509696',8100.00,0.00,0.00,12.50,1693.75,'2022-01-12 16:54:21','',''),(2499975,'19','199','1023',467,'Retail Sale Id 1509713',3888.00,0.00,0.00,6.00,813.00,'2022-01-12 16:55:58','',''),(2500049,'19','199','1023',467,'Retail Sale Id 1509769',1944.00,0.00,0.00,3.00,406.50,'2022-01-12 17:02:42','',''),(2500050,'19','199','1023',467,'Retail Sale Id 1509769',1944.00,0.00,0.00,3.00,406.50,'2022-01-12 17:02:42','',''),(2500051,'19','199','1023',467,'Retail Sale Id 1509769',6480.00,0.00,0.00,10.00,1355.00,'2022-01-12 17:02:42','',''),(2500095,'19','199','1023',467,'Retail Sale Id 1509826',8100.00,0.00,0.00,12.50,1693.75,'2022-01-12 17:06:36','',''),(2501730,'19','199',NULL,467,'Reception corrector for bridging 130677',0.00,0.00,0.00,23960.00,0.00,'2022-01-13 07:31:47','',''),(2501731,'19','199','1023',467,'Received from bridging 130677',0.00,0.00,23960.00,0.00,0.00,'2022-01-13 07:31:47','',''),(2502335,'19','199','1023',467,'Retail Sale Id 1511615',8100.00,0.00,0.00,12.50,1693.75,'2022-01-13 08:33:39','',''),(2502353,'19','199','1023',467,'Retail Sale Id 1511635',3240.00,0.00,0.00,5.00,677.50,'2022-01-13 08:35:38','',''),(2502371,'19','199','1023',467,'Retail Sale Id 1511654',8100.00,0.00,0.00,12.50,1693.75,'2022-01-13 08:37:46','',''),(2502390,'19','199','1023',467,'Retail Sale Id 1511673',1944.00,0.00,0.00,3.00,406.50,'2022-01-13 08:40:12','',''),(2502470,'19','199','1023',467,'Retail Sale Id 1511723',1944.00,0.00,0.00,3.00,406.50,'2022-01-13 08:46:28','',''),(2502665,'19','199','1023',467,'Retail Sale Id 1511879',8100.00,0.00,0.00,12.50,1693.75,'2022-01-13 09:05:49','',''),(2503463,'19','199','1023',467,'Retail Sale Id 1512402',4050.00,0.00,0.00,6.25,846.88,'2022-01-13 10:13:36','',''),(2503494,'19','199','1023',467,'Retail Sale Id 1512424',3888.00,0.00,0.00,6.00,813.00,'2022-01-13 10:15:35','',''),(2503531,'19','199','1023',467,'Retail Sale Id 1512456',1944.00,0.00,0.00,3.00,406.50,'2022-01-13 10:18:48','',''),(2503548,'19','199','1023',467,'Retail Sale Id 1512476',1944.00,0.00,0.00,3.00,406.50,'2022-01-13 10:20:45','',''),(2503620,'19','199','1023',467,'Retail Sale Id 1512544',4050.00,0.00,0.00,6.25,846.88,'2022-01-13 10:27:21','',''),(2503769,'19','199','1023',467,'Retail Sale Id 1512688',3240.00,0.00,0.00,5.00,677.50,'2022-01-13 10:39:17','',''),(2503874,'19','199','1023',467,'Retail Sale Id 1512775',8100.00,0.00,0.00,12.50,1693.75,'2022-01-13 10:45:47','',''),(2504302,'19','199','1023',467,'Retail Sale Id 1513209',1944.00,0.00,0.00,3.00,406.50,'2022-01-13 11:29:53','',''),(2504506,'19','199','1023',467,'Retail Sale Id 1513396',8100.00,0.00,0.00,12.50,1693.75,'2022-01-13 11:48:48','',''),(2504555,'19','199','1023',467,'Retail Sale Id 1513443',8100.00,0.00,0.00,12.50,1693.75,'2022-01-13 11:55:23','',''),(2504667,'19','199','1023',467,'Retail Sale Id 1513569',1944.00,0.00,0.00,3.00,406.50,'2022-01-13 12:06:55','',''),(2504668,'19','199','1023',467,'Retail Sale Id 1513569',8100.00,0.00,0.00,12.50,1693.75,'2022-01-13 12:06:55','',''),(2504687,'19','199','1023',467,'Retail Sale Id 1513594',4536.00,0.00,0.00,7.00,948.50,'2022-01-13 12:09:02','',''),(2504716,'19','199','1023',467,'Retail Sale Id 1513620',1944.00,0.00,0.00,3.00,406.50,'2022-01-13 12:12:52','',''),(2504731,'19','199','1023',467,'Retail Sale Id 1513640',1944.00,0.00,0.00,3.00,406.50,'2022-01-13 12:14:48','',''),(2504785,'19','199','1023',467,'Retail Sale Id 1513707',8100.00,0.00,0.00,12.50,1693.75,'2022-01-13 12:21:03','',''),(2504816,'19','199','1023',467,'Retail Sale Id 1513737',3888.00,0.00,0.00,6.00,813.00,'2022-01-13 12:24:35','',''),(2504831,'19','199','1023',467,'Retail Sale Id 1513750',1944.00,0.00,0.00,3.00,406.50,'2022-01-13 12:26:24','',''),(2504845,'19','199','1023',467,'Retail Sale Id 1513758',1944.00,0.00,0.00,3.00,406.50,'2022-01-13 12:27:24','',''),(2504866,'19','199','1023',467,'Retail Sale Id 1513779',8100.00,0.00,0.00,12.50,1693.75,'2022-01-13 12:30:00','',''),(2504882,'19','199','1023',467,'Retail Sale Id 1513791',3240.00,0.00,0.00,5.00,677.50,'2022-01-13 12:32:00','',''),(2504925,'19','199','1023',467,'Retail Sale Id 1513837',6480.00,0.00,0.00,10.00,1355.00,'2022-01-13 12:37:39','',''),(2504951,'19','199','1023',467,'Retail Sale Id 1513862',1944.00,0.00,0.00,3.00,406.50,'2022-01-13 12:41:28','',''),(2504952,'19','199','1023',467,'Retail Sale Id 1513862',3888.00,0.00,0.00,6.00,813.00,'2022-01-13 12:41:28','',''),(2504977,'19','199','1023',467,'Retail Sale Id 1513893',1944.00,0.00,0.00,3.00,406.50,'2022-01-13 12:44:21','',''),(2505221,'19','199','1023',467,'Retail Sale Id 1514055',1944.00,0.00,0.00,3.00,406.50,'2022-01-13 13:04:28','',''),(2505281,'19','199','1023',467,'Retail Sale Id 1514122',1944.00,0.00,0.00,3.00,406.50,'2022-01-13 13:11:24','',''),(2505321,'19','199','1023',467,'Retail Sale Id 1514160',8100.00,0.00,0.00,12.50,1693.75,'2022-01-13 13:16:06','',''),(2505452,'19','199','1023',467,'Retail Sale Id 1514301',3240.00,0.00,0.00,5.00,677.50,'2022-01-13 13:32:47','',''),(2505480,'19','199','1023',467,'Retail Sale Id 1514329',1944.00,0.00,0.00,3.00,406.50,'2022-01-13 13:36:16','',''),(2505529,'19','199','1023',467,'Retail Sale Id 1514365',8100.00,0.00,0.00,12.50,1693.75,'2022-01-13 13:41:20','',''),(2505548,'19','199','1023',467,'Retail Sale Id 1514385',8100.00,0.00,0.00,12.50,1693.75,'2022-01-13 13:43:33','',''),(2505664,'19','199','1023',467,'Retail Sale Id 1514466',8100.00,0.00,0.00,12.50,1693.75,'2022-01-13 13:55:28','',''),(2505702,'19','199','1023',467,'Retail Sale Id 1514500',8100.00,0.00,0.00,12.50,1693.75,'2022-01-13 13:59:48','',''),(2505851,'19','199','1023',467,'Retail Sale Id 1514621',8100.00,0.00,0.00,12.50,1693.75,'2022-01-13 14:15:33','',''),(2505912,'19','199','1023',467,'Retail Sale Id 1514685',3888.00,0.00,0.00,6.00,813.00,'2022-01-13 14:24:29','',''),(2506163,'19','199','1023',467,'Retail Sale Id 1514851',28450.00,0.00,0.00,50.00,2825.00,'2022-01-13 14:49:14','',''),(2506175,'19','199','1023',467,'Retail Sale Id 1514867',3888.00,0.00,0.00,6.00,813.00,'2022-01-13 14:50:20','',''),(2506487,'19','199','1023',467,'Retail Sale Id 1515083',5184.00,0.00,0.00,8.00,1084.00,'2022-01-13 15:19:37','',''),(2506558,'19','199','1023',467,'Retail Sale Id 1515125',1944.00,0.00,0.00,3.00,406.50,'2022-01-13 15:24:07','',''),(2506602,'19','199','1023',467,'Retail Sale Id 1515142',1944.00,0.00,0.00,3.00,406.50,'2022-01-13 15:26:46','',''),(2506624,'19','199','1023',467,'Retail Sale Id 1515150',8100.00,0.00,0.00,12.50,1693.75,'2022-01-13 15:28:08','',''),(2506963,'19','199','1023',467,'Retail Sale Id 1515410',3240.00,0.00,0.00,5.00,677.50,'2022-01-13 15:57:04','',''),(2507462,'19','199','1023',467,'Retail Sale Id 1515877',1944.00,0.00,0.00,3.00,406.50,'2022-01-13 16:48:43','',''),(2507492,'19','199','1023',467,'Retail Sale Id 1515906',4050.00,0.00,0.00,6.25,846.88,'2022-01-13 16:51:34','',''),(2507553,'19','199','1023',467,'Retail Sale Id 1515977',8100.00,0.00,0.00,12.50,1693.75,'2022-01-13 16:58:04','',''),(2507632,'19','199','1023',467,'Retail Sale Id 1516081',3888.00,0.00,0.00,6.00,813.00,'2022-01-13 17:05:58','',''),(2507713,'19','199','1023',467,'Retail Sale Id 1516167',1944.00,0.00,0.00,3.00,406.50,'2022-01-13 17:12:43','',''),(2510398,'19','199','1023',467,'Retail Sale Id 1518252',2592.00,0.00,0.00,4.00,542.00,'2022-01-14 09:07:29','',''),(2510546,'19','199','1023',467,'Retail Sale Id 1518434',4050.00,0.00,0.00,6.25,846.88,'2022-01-14 09:21:32','',''),(2510821,'19','199','1023',467,'Retail Sale Id 1518678',3888.00,0.00,0.00,6.00,813.00,'2022-01-14 09:40:46','',''),(2510947,'19','199','1023',467,'Retail Sale Id 1518761',1944.00,0.00,0.00,3.00,406.50,'2022-01-14 09:48:55','',''),(2511177,'19','199','1023',467,'Retail Sale Id 1518952',3888.00,0.00,0.00,6.00,813.00,'2022-01-14 10:05:13','',''),(2511287,'19','199','1023',467,'Retail Sale Id 1519081',3888.00,0.00,0.00,6.00,813.00,'2022-01-14 10:17:21','',''),(2511288,'19','199','1023',467,'Retail Sale Id 1519081',8100.00,0.00,0.00,12.50,1693.75,'2022-01-14 10:17:21','',''),(2511305,'19','199','1023',467,'Retail Sale Id 1519096',3888.00,0.00,0.00,6.00,813.00,'2022-01-14 10:19:11','',''),(2511560,'19','199','1023',467,'Retail Sale Id 1519409',8100.00,0.00,0.00,12.50,1693.75,'2022-01-14 10:48:04','',''),(2511572,'19','199','1023',467,'Retail Sale Id 1519422',1944.00,0.00,0.00,3.00,406.50,'2022-01-14 10:50:13','',''),(2511584,'19','199','1023',467,'Retail Sale Id 1519435',1944.00,0.00,0.00,3.00,406.50,'2022-01-14 10:52:08','',''),(2511585,'19','199','1023',467,'Retail Sale Id 1519435',6480.00,0.00,0.00,10.00,1355.00,'2022-01-14 10:52:08','',''),(2511624,'19','199','1023',467,'Retail Sale Id 1519476',8100.00,0.00,0.00,12.50,1693.75,'2022-01-14 10:58:10','',''),(2511762,'19','199','1023',467,'Retail Sale Id 1519580',1944.00,0.00,0.00,3.00,406.50,'2022-01-14 11:10:06','',''),(2511951,'19','199','1023',467,'Retail Sale Id 1519716',1944.00,0.00,0.00,3.00,406.50,'2022-01-14 11:25:01','',''),(2511979,'19','199','1023',467,'Retail Sale Id 1519756',1944.00,0.00,0.00,3.00,406.50,'2022-01-14 11:28:20','',''),(2511980,'19','199','1023',467,'Retail Sale Id 1519756',1944.00,0.00,0.00,3.00,406.50,'2022-01-14 11:28:20','',''),(2512052,'19','199','1023',467,'Retail Sale Id 1519830',8100.00,0.00,0.00,12.50,1693.75,'2022-01-14 11:36:48','',''),(2512390,'19','199','1023',467,'Retail Sale Id 1520154',1944.00,0.00,0.00,3.00,406.50,'2022-01-14 12:19:29','',''),(2512517,'19','199','1023',467,'Retail Sale Id 1520257',3888.00,0.00,0.00,6.00,813.00,'2022-01-14 12:32:29','',''),(2512693,'19','199','1023',467,'Retail Sale Id 1520411',1944.00,0.00,0.00,3.00,406.50,'2022-01-14 12:54:22','',''),(2512718,'19','199','1023',467,'Retail Sale Id 1520430',1944.00,0.00,0.00,3.00,406.50,'2022-01-14 12:59:30','',''),(2512737,'19','199','1023',467,'Retail Sale Id 1520449',8100.00,0.00,0.00,12.50,1693.75,'2022-01-14 13:02:23','',''),(2512748,'19','199','1023',467,'Retail Sale Id 1520460',1944.00,0.00,0.00,3.00,406.50,'2022-01-14 13:04:05','',''),(2513273,'19','199','1023',467,'Retail Sale Id 1520897',3240.00,0.00,0.00,5.00,677.50,'2022-01-14 14:23:43','',''),(2513282,'19','199','1023',467,'Retail Sale Id 1520907',1944.00,0.00,0.00,3.00,406.50,'2022-01-14 14:24:49','',''),(2513607,'19','199','1023',467,'Retail Sale Id 1521122',3240.00,0.00,0.00,5.00,677.50,'2022-01-14 14:49:17','',''),(2513630,'19','199','1023',467,'Retail Sale Id 1521142',8100.00,0.00,0.00,12.50,1693.75,'2022-01-14 14:51:55','',''),(2513720,'19','199','1023',467,'Retail Sale Id 1521345',8100.00,0.00,0.00,12.50,1693.75,'2022-01-14 15:05:01','',''),(2513761,'19','199','1023',467,'Retail Sale Id 1521387',2916.00,0.00,0.00,4.50,609.75,'2022-01-14 15:08:52','',''),(2513881,'19','199','1023',467,'Retail Sale Id 1521480',4050.00,0.00,0.00,6.25,846.88,'2022-01-14 15:20:09','',''),(2513982,'19','199','1023',467,'Retail Sale Id 1521582',4050.00,0.00,0.00,6.25,846.88,'2022-01-14 15:29:57','',''),(2514113,'19','199','1023',467,'Retail Sale Id 1521743',2592.00,0.00,0.00,4.00,542.00,'2022-01-14 15:43:08','',''),(2514296,'19','199','1023',467,'Retail Sale Id 1521931',4860.00,0.00,0.00,7.50,1016.25,'2022-01-14 16:00:55','',''),(2514311,'19','199','1023',467,'Retail Sale Id 1521945',7776.00,0.00,0.00,12.00,1626.00,'2022-01-14 16:02:38','',''),(2514406,'19','199','1023',467,'Retail Sale Id 1522009',3240.00,0.00,0.00,5.00,677.50,'2022-01-14 16:09:34','',''),(2514673,'19','199','1023',467,'Retail Sale Id 1522238',1944.00,0.00,0.00,3.00,406.50,'2022-01-14 16:35:34','',''),(2514704,'19','199','1023',467,'Retail Sale Id 1522270',30600.00,0.00,0.00,50.00,4975.00,'2022-01-14 16:38:28','',''),(2514752,'19','199','1023',467,'Retail Sale Id 1522331',1944.00,0.00,0.00,3.00,406.50,'2022-01-14 16:43:24','',''),(2514762,'19','199','1023',467,'Retail Sale Id 1522342',8100.00,0.00,0.00,12.50,1693.75,'2022-01-14 16:44:35','',''),(2514789,'19','199','1023',467,'Retail Sale Id 1522373',8100.00,0.00,0.00,12.50,1693.75,'2022-01-14 16:47:02','',''),(2514808,'19','199','1023',467,'Retail Sale Id 1522392',3888.00,0.00,0.00,6.00,813.00,'2022-01-14 16:48:27','',''),(2514937,'19','199','1023',467,'Retail Sale Id 1522577',1944.00,0.00,0.00,3.00,406.50,'2022-01-14 17:00:28','',''),(2517713,'19','199','1023',467,'Retail Sale Id 1524723',1944.00,0.00,0.00,3.00,406.50,'2022-01-15 08:51:27','',''),(2517771,'19','199','1023',467,'Retail Sale Id 1524785',1944.00,0.00,0.00,3.00,406.50,'2022-01-15 08:56:40','',''),(2517850,'19','199','1023',467,'Retail Sale Id 1524855',3240.00,0.00,0.00,5.00,677.50,'2022-01-15 09:04:30','',''),(2517875,'19','199','1023',467,'Retail Sale Id 1524877',4050.00,0.00,0.00,6.25,846.88,'2022-01-15 09:06:40','',''),(2518229,'19','199','1023',467,'Retail Sale Id 1525173',1944.00,0.00,0.00,3.00,406.50,'2022-01-15 09:30:10','',''),(2518299,'19','199','1023',467,'Retail Sale Id 1525217',3888.00,0.00,0.00,6.00,813.00,'2022-01-15 09:33:13','',''),(2518416,'19','199','1023',467,'Retail Sale Id 1525304',8100.00,0.00,0.00,12.50,1693.75,'2022-01-15 09:41:15','',''),(2518642,'19','199','1023',467,'Retail Sale Id 1525539',8100.00,0.00,0.00,12.50,1693.75,'2022-01-15 10:03:09','',''),(2518666,'19','199','1023',467,'Retail Sale Id 1525564',8100.00,0.00,0.00,12.50,1693.75,'2022-01-15 10:05:03','',''),(2518684,'19','199','1023',467,'Retail Sale Id 1525586',1944.00,0.00,0.00,3.00,406.50,'2022-01-15 10:06:26','',''),(2519086,'19','199','1023',467,'Retail Sale Id 1525970',3240.00,0.00,0.00,5.00,677.50,'2022-01-15 10:37:18','',''),(2519087,'19','199','1023',467,'Retail Sale Id 1525970',3888.00,0.00,0.00,6.00,813.00,'2022-01-15 10:37:18','',''),(2519200,'19','199','1023',467,'Retail Sale Id 1526064',1944.00,0.00,0.00,3.00,406.50,'2022-01-15 10:44:32','',''),(2519292,'19','199','1023',467,'Retail Sale Id 1526143',8100.00,0.00,0.00,12.50,1693.75,'2022-01-15 10:51:33','',''),(2519303,'19','199','1023',467,'Retail Sale Id 1526153',1944.00,0.00,0.00,3.00,406.50,'2022-01-15 10:52:31','',''),(2519560,'19','199','1023',467,'Retail Sale Id 1526359',8100.00,0.00,0.00,12.50,1693.75,'2022-01-15 11:12:23','',''),(2519973,'19','199','1023',467,'Retail Sale Id 1526725',4050.00,0.00,0.00,6.25,846.88,'2022-01-15 11:45:22','',''),(2520078,'19','199','1023',467,'Retail Sale Id 1526850',1944.00,0.00,0.00,3.00,406.50,'2022-01-15 11:55:27','',''),(2520209,'19','199','1023',467,'Retail Sale Id 1526968',1944.00,0.00,0.00,3.00,406.50,'2022-01-15 12:05:16','',''),(2520210,'19','199','1023',467,'Retail Sale Id 1526968',3240.00,0.00,0.00,5.00,677.50,'2022-01-15 12:05:16','',''),(2520221,'19','199','1023',467,'Retail Sale Id 1526977',1944.00,0.00,0.00,3.00,406.50,'2022-01-15 12:06:05','',''),(2520251,'19','199','1023',467,'Retail Sale Id 1527018',1944.00,0.00,0.00,3.00,406.50,'2022-01-15 12:08:32','',''),(2520335,'19','199','1023',467,'Retail Sale Id 1527116',8100.00,0.00,0.00,12.50,1693.75,'2022-01-15 12:16:08','',''),(2520424,'19','199','1023',467,'Retail Sale Id 1527209',8100.00,0.00,0.00,12.50,1693.75,'2022-01-15 12:24:56','',''),(2520646,'19','199','1023',467,'Retail Sale Id 1527405',1944.00,0.00,0.00,3.00,406.50,'2022-01-15 12:42:10','',''),(2520713,'19','199','1023',467,'Retail Sale Id 1527456',1944.00,0.00,0.00,3.00,406.50,'2022-01-15 12:47:31','',''),(2520745,'19','199','1023',467,'Retail Sale Id 1527481',1944.00,0.00,0.00,3.00,406.50,'2022-01-15 12:50:31','',''),(2520746,'19','199','1023',467,'Retail Sale Id 1527481',3240.00,0.00,0.00,5.00,677.50,'2022-01-15 12:50:31','',''),(2520838,'19','199','1023',467,'Retail Sale Id 1527573',3240.00,0.00,0.00,5.00,677.50,'2022-01-15 13:00:09','',''),(2520974,'19','199','1023',467,'Retail Sale Id 1527676',3888.00,0.00,0.00,6.00,813.00,'2022-01-15 13:12:07','',''),(2520993,'19','199','1023',467,'Retail Sale Id 1527692',3240.00,0.00,0.00,5.00,677.50,'2022-01-15 13:13:40','',''),(2521008,'19','199','1023',467,'Retail Sale Id 1527702',3888.00,0.00,0.00,6.00,813.00,'2022-01-15 13:14:24','',''),(2521256,'19','199','1023',467,'Retail Sale Id 1527876',3240.00,0.00,0.00,5.00,677.50,'2022-01-15 13:30:35','',''),(2521404,'19','199','1023',467,'Retail Sale Id 1528033',4050.00,0.00,0.00,6.25,846.88,'2022-01-15 13:46:51','',''),(2521434,'19','199','1023',467,'Retail Sale Id 1528060',1944.00,0.00,0.00,3.00,406.50,'2022-01-15 13:49:17','',''),(2521435,'19','199','1023',467,'Retail Sale Id 1528060',3888.00,0.00,0.00,6.00,813.00,'2022-01-15 13:49:17','',''),(2521771,'19','199','1023',467,'Retail Sale Id 1528388',8100.00,0.00,0.00,12.50,1693.75,'2022-01-15 14:21:03','',''),(2522015,'19','199','1023',467,'Retail Sale Id 1528601',8100.00,0.00,0.00,12.50,1693.75,'2022-01-15 14:44:08','',''),(2522030,'19','199','1023',467,'Retail Sale Id 1528619',2592.00,0.00,0.00,4.00,542.00,'2022-01-15 14:45:27','',''),(2522344,'19','199','1023',467,'Retail Sale Id 1528841',8100.00,0.00,0.00,12.50,1693.75,'2022-01-15 15:03:59','',''),(2522519,'19','199','1023',467,'Retail Sale Id 1528937',4050.00,0.00,0.00,6.25,846.88,'2022-01-15 15:13:24','',''),(2522760,'19','199','1023',467,'Retail Sale Id 1529183',3240.00,0.00,0.00,5.00,677.50,'2022-01-15 15:37:05','',''),(2522772,'19','199','1023',467,'Retail Sale Id 1529192',1944.00,0.00,0.00,3.00,406.50,'2022-01-15 15:38:06','',''),(2522860,'19','199','1023',467,'Retail Sale Id 1529270',8100.00,0.00,0.00,12.50,1693.75,'2022-01-15 15:46:38','',''),(2523018,'19','199','1023',467,'Retail Sale Id 1529423',7128.00,0.00,0.00,11.00,1490.50,'2022-01-15 16:03:04','',''),(2523103,'19','199','1023',467,'Retail Sale Id 1529525',8100.00,0.00,0.00,12.50,1693.75,'2022-01-15 16:13:39','',''),(2523145,'19','199','1023',467,'Retail Sale Id 1529576',8100.00,0.00,0.00,12.50,1693.75,'2022-01-15 16:18:53','',''),(2523237,'19','199','1023',467,'Retail Sale Id 1529661',2592.00,0.00,0.00,4.00,542.00,'2022-01-15 16:25:38','',''),(2523329,'19','199','1023',467,'Retail Sale Id 1529740',4050.00,0.00,0.00,6.25,846.88,'2022-01-15 16:32:22','',''),(2523367,'19','199','1023',467,'Retail Sale Id 1529761',3888.00,0.00,0.00,6.00,813.00,'2022-01-15 16:33:44','',''),(2523401,'19','199','1023',467,'Retail Sale Id 1529788',1944.00,0.00,0.00,3.00,406.50,'2022-01-15 16:35:31','',''),(2523666,'19','199','1023',467,'Retail Sale Id 1530023',3888.00,0.00,0.00,6.00,813.00,'2022-01-15 16:52:58','',''),(2523740,'19','199','1023',467,'Retail Sale Id 1530079',4050.00,0.00,0.00,6.25,846.88,'2022-01-15 16:57:29','',''),(2523831,'19','199','1023',467,'Retail Sale Id 1530126',6480.00,0.00,0.00,10.00,1355.00,'2022-01-15 17:00:59','',''),(2523876,'19','199','1023',467,'Retail Sale Id 1530165',1944.00,0.00,0.00,3.00,406.50,'2022-01-15 17:03:23','',''),(2526466,'19','199','1023',467,'Retail Sale Id 1532075',30600.00,0.00,0.00,50.00,4975.00,'2022-01-16 08:30:03','',''),(2526467,'19','199','1023',467,'Retail Sale Id 1532075',30600.00,0.00,0.00,50.00,4975.00,'2022-01-16 08:30:03','',''),(2526484,'19','199','1023',467,'Retail Sale Id 1532093',2592.00,0.00,0.00,4.00,542.00,'2022-01-16 08:31:42','',''),(2526710,'19','199','1023',467,'Retail Sale Id 1532306',2592.00,0.00,0.00,4.00,542.00,'2022-01-16 08:51:46','',''),(2527133,'19','199','1023',467,'Retail Sale Id 1532704',8100.00,0.00,0.00,12.50,1693.75,'2022-01-16 09:27:14','',''),(2527280,'19','199','1023',467,'Retail Sale Id 1532833',8100.00,0.00,0.00,12.50,1693.75,'2022-01-16 09:40:13','',''),(2527306,'19','199','1023',467,'Retail Sale Id 1532863',8100.00,0.00,0.00,12.50,1693.75,'2022-01-16 09:42:31','',''),(2527418,'19','199','1023',467,'Retail Sale Id 1532971',8100.00,0.00,0.00,12.50,1693.75,'2022-01-16 09:50:47','',''),(2527419,'19','199','1023',467,'Retail Sale Id 1532971',8100.00,0.00,0.00,12.50,1693.75,'2022-01-16 09:50:47','',''),(2527557,'19','199','1023',467,'Retail Sale Id 1533131',1944.00,0.00,0.00,3.00,406.50,'2022-01-16 10:02:03','',''),(2527731,'19','199','1023',467,'Retail Sale Id 1533239',2592.00,0.00,0.00,4.00,542.00,'2022-01-16 10:11:39','',''),(2527732,'19','199','1023',467,'Retail Sale Id 1533239',4536.00,0.00,0.00,7.00,948.50,'2022-01-16 10:11:39','',''),(2527906,'19','199','1023',467,'Retail Sale Id 1533423',6480.00,0.00,0.00,10.00,1355.00,'2022-01-16 10:26:48','',''),(2528856,'19','199','1023',467,'Retail Sale Id 1534337',8100.00,0.00,0.00,12.50,1693.75,'2022-01-16 11:43:46','',''),(2528980,'19','199','1023',467,'Retail Sale Id 1534491',3888.00,0.00,0.00,6.00,813.00,'2022-01-16 11:55:19','',''),(2529439,'19','199','1023',467,'Retail Sale Id 1534965',2592.00,0.00,0.00,4.00,542.00,'2022-01-16 12:39:41','',''),(2529464,'19','199','1023',467,'Retail Sale Id 1535004',8100.00,0.00,0.00,12.50,1693.75,'2022-01-16 12:42:16','',''),(2529597,'19','199','1023',467,'Retail Sale Id 1535127',3888.00,0.00,0.00,6.00,813.00,'2022-01-16 12:53:53','',''),(2529969,'19','199','1023',467,'Retail Sale Id 1535486',8100.00,0.00,0.00,12.50,1693.75,'2022-01-16 13:28:06','',''),(2530148,'19','199','1023',467,'Retail Sale Id 1535792',1944.00,0.00,0.00,3.00,406.50,'2022-01-16 13:50:01','',''),(2530149,'19','199','1023',467,'Retail Sale Id 1535792',1944.00,0.00,0.00,3.00,406.50,'2022-01-16 13:50:01','',''),(2530242,'19','199','1023',467,'Retail Sale Id 1535861',8100.00,0.00,0.00,12.50,1693.75,'2022-01-16 13:57:40','',''),(2530322,'19','199','1023',467,'Retail Sale Id 1535960',8100.00,0.00,0.00,12.50,1693.75,'2022-01-16 14:05:51','',''),(2530323,'19','199','1023',467,'Retail Sale Id 1535960',8100.00,0.00,0.00,12.50,1693.75,'2022-01-16 14:05:51','',''),(2530546,'19','199','1023',467,'Retail Sale Id 1536119',3240.00,0.00,0.00,5.00,677.50,'2022-01-16 14:25:16','',''),(2530576,'19','199','1023',467,'Retail Sale Id 1536157',1944.00,0.00,0.00,3.00,406.50,'2022-01-16 14:28:31','',''),(2530595,'19','199','1023',467,'Retail Sale Id 1536175',3888.00,0.00,0.00,6.00,813.00,'2022-01-16 14:30:17','',''),(2530662,'19','199','1023',467,'Retail Sale Id 1536232',4050.00,0.00,0.00,6.25,846.88,'2022-01-16 14:36:38','',''),(2530977,'19','199','1023',467,'Retail Sale Id 1536463',648.00,0.00,0.00,1.00,135.50,'2022-01-16 15:00:18','',''),(2530989,'19','199','1023',467,'Retail Sale Id 1536471',2592.00,0.00,0.00,4.00,542.00,'2022-01-16 15:02:21','',''),(2531023,'19','199','1023',467,'Retail Sale Id 1536497',30600.00,0.00,0.00,50.00,4975.00,'2022-01-16 15:05:53','',''),(2531055,'19','199','1023',467,'Retail Sale Id 1536527',4536.00,0.00,0.00,7.00,948.50,'2022-01-16 15:08:27','',''),(2531079,'19','199','1023',467,'Retail Sale Id 1536551',1944.00,0.00,0.00,3.00,406.50,'2022-01-16 15:11:23','',''),(2531080,'19','199','1023',467,'Retail Sale Id 1536551',1944.00,0.00,0.00,3.00,406.50,'2022-01-16 15:11:23','',''),(2531081,'19','199','1023',467,'Retail Sale Id 1536551',1944.00,0.00,0.00,3.00,406.50,'2022-01-16 15:11:23','',''),(2531160,'19','199','1023',467,'Retail Sale Id 1536580',8100.00,0.00,0.00,12.50,1693.75,'2022-01-16 15:14:40','',''),(2531161,'19','199','1023',467,'Retail Sale Id 1536580',8100.00,0.00,0.00,12.50,1693.75,'2022-01-16 15:14:40','',''),(2531162,'19','199','1023',467,'Retail Sale Id 1536580',8100.00,0.00,0.00,12.50,1693.75,'2022-01-16 15:14:40','',''),(2531200,'19','199','1023',467,'Retail Sale Id 1536599',1944.00,0.00,0.00,3.00,406.50,'2022-01-16 15:17:10','',''),(2531250,'19','199','1023',467,'Return of Retail Sale Id 1536463',0.00,648.00,1.00,0.00,-135.50,'2022-01-16 15:22:43','',''),(2531324,'19','199','1023',467,'Retail Sale Id 1536705',1944.00,0.00,0.00,3.00,406.50,'2022-01-16 15:30:07','',''),(2531338,'19','199','1023',467,'Retail Sale Id 1536722',4050.00,0.00,0.00,6.25,846.88,'2022-01-16 15:32:09','',''),(2531410,'19','199','1023',467,'Retail Sale Id 1536795',2268.00,0.00,0.00,3.50,474.25,'2022-01-16 15:40:22','',''),(2531420,'19','199','1023',467,'Retail Sale Id 1536805',3888.00,0.00,0.00,6.00,813.00,'2022-01-16 15:41:46','',''),(2531482,'19','199','1023',467,'Retail Sale Id 1536835',4050.00,0.00,0.00,6.25,846.88,'2022-01-16 15:46:13','',''),(2531483,'19','199','1023',467,'Retail Sale Id 1536835',8100.00,0.00,0.00,12.50,1693.75,'2022-01-16 15:46:13','',''),(2531881,'19','199','1023',467,'Retail Sale Id 1537205',2592.00,0.00,0.00,4.00,542.00,'2022-01-16 16:27:42','',''),(2532257,'19','199','1023',467,'Retail Sale Id 1537514',1944.00,0.00,0.00,3.00,406.50,'2022-01-16 16:55:28','',''),(2532350,'19','199','1023',467,'Retail Sale Id 1537589',1944.00,0.00,0.00,3.00,406.50,'2022-01-16 17:02:07','',''),(2532385,'19','199','1023',467,'Retail Sale Id 1537629',1944.00,0.00,0.00,3.00,406.50,'2022-01-16 17:05:04','',''),(2534972,'19','199','1023',467,'Retail Sale Id 1539663',1944.00,0.00,0.00,3.00,406.50,'2022-01-17 09:01:59','',''),(2534973,'19','199','1023',467,'Retail Sale Id 1539663',4050.00,0.00,0.00,6.25,846.88,'2022-01-17 09:01:59','',''),(2534990,'19','199','1023',467,'Retail Sale Id 1539680',10044.00,0.00,0.00,15.50,2100.25,'2022-01-17 09:04:15','',''),(2535009,'19','199','1023',467,'Retail Sale Id 1539699',3888.00,0.00,0.00,6.00,813.00,'2022-01-17 09:06:50','',''),(2535020,'19','199','1023',467,'Retail Sale Id 1539714',3240.00,0.00,0.00,5.00,677.50,'2022-01-17 09:08:15','',''),(2535029,'19','199','1023',467,'Retail Sale Id 1539724',4050.00,0.00,0.00,6.25,846.88,'2022-01-17 09:10:15','',''),(2535375,'19','199','1023',467,'Retail Sale Id 1539968',2592.00,0.00,0.00,4.00,542.00,'2022-01-17 09:40:45','',''),(2535562,'19','199','1023',467,'Retail Sale Id 1540131',1944.00,0.00,0.00,3.00,406.50,'2022-01-17 10:03:46','',''),(2535690,'19','199','1023',467,'Retail Sale Id 1540171',4050.00,0.00,0.00,6.25,846.88,'2022-01-17 10:12:43','',''),(2535691,'19','199','1023',467,'Retail Sale Id 1540171',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 10:12:43','',''),(2535692,'19','199','1023',467,'Retail Sale Id 1540171',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 10:12:43','',''),(2535711,'19','199','1023',467,'Retail Sale Id 1540211',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 10:15:46','',''),(2535919,'19','199','1023',467,'Retail Sale Id 1540380',1944.00,0.00,0.00,3.00,406.50,'2022-01-17 10:40:51','',''),(2536168,'19','199','1023',467,'Retail Sale Id 1540568',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 11:06:45','',''),(2536187,'19','199','1023',467,'Retail Sale Id 1540598',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 11:08:57','',''),(2536214,'19','199','1023',467,'Retail Sale Id 1540633',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 11:13:12','',''),(2536297,'19','199','1023',467,'Retail Sale Id 1540698',4050.00,0.00,0.00,6.25,846.88,'2022-01-17 11:23:21','',''),(2536335,'19','199','1023',467,'Retail Sale Id 1540723',1944.00,0.00,0.00,3.00,406.50,'2022-01-17 11:26:50','',''),(2536473,'19','199','1023',467,'Retail Sale Id 1540849',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 11:43:52','',''),(2536617,'19','199','1023',467,'Retail Sale Id 1541014',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 12:02:43','',''),(2536652,'19','199','1023',467,'Retail Sale Id 1541055',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 12:08:20','',''),(2536893,'19','199','1023',467,'Retail Sale Id 1541281',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 12:39:36','',''),(2536943,'19','199','1023',467,'Retail Sale Id 1541350',2592.00,0.00,0.00,4.00,542.00,'2022-01-17 12:47:32','',''),(2537024,'19','199','1023',467,'Retail Sale Id 1541406',4050.00,0.00,0.00,6.25,846.88,'2022-01-17 12:56:37','',''),(2537093,'19','199','1023',467,'Retail Sale Id 1541478',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 13:09:34','',''),(2537130,'19','199','1023',467,'Retail Sale Id 1541516',3240.00,0.00,0.00,5.00,677.50,'2022-01-17 13:15:05','',''),(2537198,'19','199','1023',467,'Retail Sale Id 1541582',1944.00,0.00,0.00,3.00,406.50,'2022-01-17 13:24:15','',''),(2537221,'19','199','1023',467,'Retail Sale Id 1541603',1944.00,0.00,0.00,3.00,406.50,'2022-01-17 13:27:20','',''),(2537257,'19','199','1023',467,'Retail Sale Id 1541635',1944.00,0.00,0.00,3.00,406.50,'2022-01-17 13:31:28','',''),(2537276,'19','199','1023',467,'Retail Sale Id 1541653',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 13:34:21','',''),(2537293,'19','199','1023',467,'Retail Sale Id 1541684',1944.00,0.00,0.00,3.00,406.50,'2022-01-17 13:36:52','',''),(2537317,'19','199','1023',467,'Retail Sale Id 1541695',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 13:38:57','',''),(2537366,'19','199','1023',467,'Retail Sale Id 1541751',4050.00,0.00,0.00,6.25,846.88,'2022-01-17 13:46:04','',''),(2537385,'19','199','1023',467,'Retail Sale Id 1541769',1944.00,0.00,0.00,3.00,406.50,'2022-01-17 13:48:31','',''),(2537452,'19','199','1023',467,'Retail Sale Id 1541829',1944.00,0.00,0.00,3.00,406.50,'2022-01-17 13:55:50','',''),(2537519,'19','199','1023',467,'Retail Sale Id 1541902',2592.00,0.00,0.00,4.00,542.00,'2022-01-17 14:02:52','',''),(2537679,'19','199','1023',467,'Retail Sale Id 1541993',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 14:17:09','',''),(2537849,'19','199','1023',467,'Retail Sale Id 1542129',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 14:34:21','',''),(2537887,'19','199','1023',467,'Retail Sale Id 1542163',1944.00,0.00,0.00,3.00,406.50,'2022-01-17 14:39:11','',''),(2538147,'19','199','1023',467,'Retail Sale Id 1542360',1944.00,0.00,0.00,3.00,406.50,'2022-01-17 15:03:09','',''),(2538168,'19','199','1023',467,'Retail Sale Id 1542388',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 15:05:11','',''),(2538180,'19','199','1023',467,'Retail Sale Id 1542407',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 15:07:05','',''),(2538338,'19','199','1023',467,'Retail Sale Id 1542476',1944.00,0.00,0.00,3.00,406.50,'2022-01-17 15:15:46','',''),(2538405,'19','199','1023',467,'Retail Sale Id 1542556',4050.00,0.00,0.00,6.25,846.88,'2022-01-17 15:26:05','',''),(2538436,'19','199','1023',467,'Retail Sale Id 1542587',6480.00,0.00,0.00,10.00,1355.00,'2022-01-17 15:29:45','',''),(2538463,'19','199','1023',467,'Retail Sale Id 1542614',1944.00,0.00,0.00,3.00,406.50,'2022-01-17 15:32:26','',''),(2538566,'19','199','1023',467,'Retail Sale Id 1542706',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 15:42:39','',''),(2538611,'19','199','1023',467,'Retail Sale Id 1542750',4050.00,0.00,0.00,6.25,846.88,'2022-01-17 15:46:50','',''),(2538708,'19','199','1023',467,'Retail Sale Id 1542810',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 15:53:55','',''),(2538724,'19','199','1023',467,'Retail Sale Id 1542826',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 15:55:31','',''),(2538745,'19','199','1023',467,'Retail Sale Id 1542845',3888.00,0.00,0.00,6.00,813.00,'2022-01-17 15:57:50','',''),(2538892,'19','199','1023',467,'Retail Sale Id 1542963',4050.00,0.00,0.00,6.25,846.88,'2022-01-17 16:11:44','',''),(2538991,'19','199','1023',467,'Retail Sale Id 1543075',1944.00,0.00,0.00,3.00,406.50,'2022-01-17 16:24:18','',''),(2538992,'19','199','1023',467,'Retail Sale Id 1543075',1944.00,0.00,0.00,3.00,406.50,'2022-01-17 16:24:18','',''),(2539058,'19','199','1023',467,'Retail Sale Id 1543139',3240.00,0.00,0.00,5.00,677.50,'2022-01-17 16:31:37','',''),(2539085,'19','199','1023',467,'Retail Sale Id 1543166',3240.00,0.00,0.00,5.00,677.50,'2022-01-17 16:34:30','',''),(2539117,'19','199','1023',467,'Retail Sale Id 1543202',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 16:37:19','',''),(2539141,'19','199','1023',467,'Retail Sale Id 1543228',1944.00,0.00,0.00,3.00,406.50,'2022-01-17 16:39:23','',''),(2539162,'19','199','1023',467,'Retail Sale Id 1543250',1944.00,0.00,0.00,3.00,406.50,'2022-01-17 16:41:14','',''),(2539163,'19','199','1023',467,'Retail Sale Id 1543250',1944.00,0.00,0.00,3.00,406.50,'2022-01-17 16:41:14','',''),(2539185,'19','199','1023',467,'Retail Sale Id 1543268',3888.00,0.00,0.00,6.00,813.00,'2022-01-17 16:42:57','',''),(2539236,'19','199','1023',467,'Retail Sale Id 1543321',4050.00,0.00,0.00,6.25,846.88,'2022-01-17 16:46:31','',''),(2539237,'19','199','1023',467,'Retail Sale Id 1543321',4050.00,0.00,0.00,6.25,846.88,'2022-01-17 16:46:31','',''),(2539268,'19','199','1023',467,'Retail Sale Id 1543340',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 16:49:16','',''),(2539300,'19','199','1023',467,'Retail Sale Id 1543395',3240.00,0.00,0.00,5.00,677.50,'2022-01-17 16:51:41','',''),(2539350,'19','199','1023',467,'Retail Sale Id 1543443',1944.00,0.00,0.00,3.00,406.50,'2022-01-17 16:55:00','',''),(2539371,'19','199','1023',467,'Retail Sale Id 1543466',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 16:56:44','',''),(2539405,'19','199','1023',467,'Retail Sale Id 1543502',4050.00,0.00,0.00,6.25,846.88,'2022-01-17 16:59:59','',''),(2539494,'19','199','1023',467,'Retail Sale Id 1543584',1944.00,0.00,0.00,3.00,406.50,'2022-01-17 17:05:32','',''),(2539535,'19','199','1023',467,'Retail Sale Id 1543625',8100.00,0.00,0.00,12.50,1693.75,'2022-01-17 17:08:17','',''),(2539556,'19','199','1023',467,'Retail Sale Id 1543654',4050.00,0.00,0.00,6.25,846.88,'2022-01-17 17:09:33','',''),(2541540,'19','199','1023',467,'Retail Sale Id 1545375',1944.00,0.00,0.00,3.00,406.50,'2022-01-18 08:35:08','',''),(2541563,'19','199','1023',467,'Retail Sale Id 1545395',4050.00,0.00,0.00,6.25,846.88,'2022-01-18 08:37:43','',''),(2541564,'19','199','1023',467,'Retail Sale Id 1545395',8100.00,0.00,0.00,12.50,1693.75,'2022-01-18 08:37:43','',''),(2541613,'19','199','1023',467,'Retail Sale Id 1545425',3888.00,0.00,0.00,6.00,813.00,'2022-01-18 08:42:41','',''),(2541749,'19','199','1023',467,'Retail Sale Id 1545550',3888.00,0.00,0.00,6.00,813.00,'2022-01-18 08:58:47','',''),(2541833,'19','199','1023',467,'Retail Sale Id 1545605',3240.00,0.00,0.00,5.00,677.50,'2022-01-18 09:07:10','',''),(2542063,'19','199','1023',467,'Retail Sale Id 1545750',8100.00,0.00,0.00,12.50,1693.75,'2022-01-18 09:27:56','',''),(2542195,'19','199','1023',467,'Retail Sale Id 1545825',3888.00,0.00,0.00,6.00,813.00,'2022-01-18 09:39:13','',''),(2542227,'19','199','1023',467,'Retail Sale Id 1545851',4050.00,0.00,0.00,6.25,846.88,'2022-01-18 09:41:50','',''),(2542266,'19','199','1023',467,'Retail Sale Id 1545874',1944.00,0.00,0.00,3.00,406.50,'2022-01-18 09:43:59','',''),(2542283,'19','199','1023',467,'Retail Sale Id 1545887',8100.00,0.00,0.00,12.50,1693.75,'2022-01-18 09:45:41','',''),(2542318,'19','199','1023',467,'Retail Sale Id 1545913',8100.00,0.00,0.00,12.50,1693.75,'2022-01-18 09:49:34','',''),(2542330,'19','199','1023',467,'Retail Sale Id 1545926',3888.00,0.00,0.00,6.00,813.00,'2022-01-18 09:50:49','',''),(2542792,'19','199','1023',467,'Retail Sale Id 1546257',3240.00,0.00,0.00,5.00,677.50,'2022-01-18 10:29:39','',''),(2542854,'19','199','1023',467,'Retail Sale Id 1546305',1944.00,0.00,0.00,3.00,406.50,'2022-01-18 10:36:24','',''),(2542979,'19','199','1023',467,'Retail Sale Id 1546401',4860.00,0.00,0.00,7.50,1016.25,'2022-01-18 10:45:48','',''),(2543029,'19','199','1023',467,'Retail Sale Id 1546436',3888.00,0.00,0.00,6.00,813.00,'2022-01-18 10:49:15','',''),(2543233,'19','199','1023',467,'Retail Sale Id 1546629',3240.00,0.00,0.00,5.00,677.50,'2022-01-18 11:12:39','',''),(2543234,'19','199','1023',467,'Retail Sale Id 1546629',3888.00,0.00,0.00,6.00,813.00,'2022-01-18 11:12:39','',''),(2543258,'19','199','1023',467,'Retail Sale Id 1546658',4050.00,0.00,0.00,6.25,846.88,'2022-01-18 11:15:54','',''),(2543259,'19','199','1023',467,'Retail Sale Id 1546658',8100.00,0.00,0.00,12.50,1693.75,'2022-01-18 11:15:54','',''),(2543300,'19','199','1023',467,'Retail Sale Id 1546698',8100.00,0.00,0.00,12.50,1693.75,'2022-01-18 11:20:14','',''),(2543322,'19','199','1023',467,'Retail Sale Id 1546721',1944.00,0.00,0.00,3.00,406.50,'2022-01-18 11:22:41','',''),(2543608,'19','199','1023',467,'Retail Sale Id 1546958',8100.00,0.00,0.00,12.50,1693.75,'2022-01-18 11:57:23','',''),(2543675,'19','199','1023',467,'Retail Sale Id 1547029',1944.00,0.00,0.00,3.00,406.50,'2022-01-18 12:06:47','',''),(2543676,'19','199','1023',467,'Retail Sale Id 1547029',2592.00,0.00,0.00,4.00,542.00,'2022-01-18 12:06:47','',''),(2543696,'19','199','1023',467,'Retail Sale Id 1547054',1944.00,0.00,0.00,3.00,406.50,'2022-01-18 12:08:59','',''),(2543738,'19','199','1023',467,'Retail Sale Id 1547098',1944.00,0.00,0.00,3.00,406.50,'2022-01-18 12:14:27','',''),(2543931,'19','199','1023',467,'Retail Sale Id 1547285',1944.00,0.00,0.00,3.00,406.50,'2022-01-18 12:36:52','',''),(2544005,'19','199','1023',467,'Retail Sale Id 1547357',3240.00,0.00,0.00,5.00,677.50,'2022-01-18 12:44:23','',''),(2544063,'19','199','1023',467,'Retail Sale Id 1547416',1944.00,0.00,0.00,3.00,406.50,'2022-01-18 12:52:28','',''),(2544078,'19','199','1023',467,'Retail Sale Id 1547432',3240.00,0.00,0.00,5.00,677.50,'2022-01-18 12:54:12','',''),(2544198,'19','199','1023',467,'Retail Sale Id 1547560',1944.00,0.00,0.00,3.00,406.50,'2022-01-18 13:12:05','',''),(2544229,'19','199','1023',467,'Retail Sale Id 1547593',8424.00,0.00,0.00,13.00,1761.50,'2022-01-18 13:15:37','',''),(2544333,'19','199','1023',467,'Retail Sale Id 1547703',3240.00,0.00,0.00,5.00,677.50,'2022-01-18 13:28:15','',''),(2544378,'19','199','1023',467,'Retail Sale Id 1547750',3888.00,0.00,0.00,6.00,813.00,'2022-01-18 13:33:13','',''),(2544400,'19','199','1023',467,'Retail Sale Id 1547777',3888.00,0.00,0.00,6.00,813.00,'2022-01-18 13:35:21','',''),(2544479,'19','199','1023',467,'Retail Sale Id 1547839',1944.00,0.00,0.00,3.00,406.50,'2022-01-18 13:44:36','',''),(2544480,'19','199','1023',467,'Retail Sale Id 1547839',1944.00,0.00,0.00,3.00,406.50,'2022-01-18 13:44:36','',''),(2544494,'19','199','1023',467,'Retail Sale Id 1547870',8100.00,0.00,0.00,12.50,1693.75,'2022-01-18 13:46:37','',''),(2544590,'19','199','1023',467,'Retail Sale Id 1547959',4050.00,0.00,0.00,6.25,846.88,'2022-01-18 13:57:50','',''),(2544610,'19','199','1023',467,'Retail Sale Id 1547972',1944.00,0.00,0.00,3.00,406.50,'2022-01-18 13:59:44','',''),(2544631,'19','199','1023',467,'Retail Sale Id 1547993',3888.00,0.00,0.00,6.00,813.00,'2022-01-18 14:01:32','',''),(2544933,'19','199','1023',467,'Retail Sale Id 1548265',8100.00,0.00,0.00,12.50,1693.75,'2022-01-18 14:33:52','',''),(2545206,'19','199','1023',467,'Retail Sale Id 1548457',6480.00,0.00,0.00,10.00,1355.00,'2022-01-18 14:55:52','',''),(2545501,'19','199','1023',467,'Retail Sale Id 1548723',1944.00,0.00,0.00,3.00,406.50,'2022-01-18 15:23:33','',''),(2545715,'19','199','1023',467,'Retail Sale Id 1548878',3240.00,0.00,0.00,5.00,677.50,'2022-01-18 15:41:32','',''),(2545716,'19','199','1023',467,'Retail Sale Id 1548878',3888.00,0.00,0.00,6.00,813.00,'2022-01-18 15:41:32','',''),(2545812,'19','199','1023',467,'Retail Sale Id 1548960',4050.00,0.00,0.00,6.25,846.88,'2022-01-18 15:50:07','',''),(2545899,'19','199','1023',467,'Retail Sale Id 1549026',8100.00,0.00,0.00,12.50,1693.75,'2022-01-18 15:55:38','',''),(2545956,'19','199','1023',467,'Retail Sale Id 1549065',8100.00,0.00,0.00,12.50,1693.75,'2022-01-18 16:01:04','',''),(2545982,'19','199','1023',467,'Retail Sale Id 1549080',1944.00,0.00,0.00,3.00,406.50,'2022-01-18 16:02:28','',''),(2546134,'19','199','1023',467,'Retail Sale Id 1549226',1944.00,0.00,0.00,3.00,406.50,'2022-01-18 16:18:25','',''),(2546361,'19','199','1023',467,'Retail Sale Id 1549445',8100.00,0.00,0.00,12.50,1693.75,'2022-01-18 16:39:26','',''),(2546376,'19','199','1023',467,'Retail Sale Id 1549469',1944.00,0.00,0.00,3.00,406.50,'2022-01-18 16:40:50','',''),(2546407,'19','199','1023',467,'Retail Sale Id 1549500',8100.00,0.00,0.00,12.50,1693.75,'2022-01-18 16:43:30','',''),(2546471,'19','199','1023',467,'Retail Sale Id 1549562',3888.00,0.00,0.00,6.00,813.00,'2022-01-18 16:49:18','',''),(2546505,'19','199','1023',467,'Retail Sale Id 1549596',1944.00,0.00,0.00,3.00,406.50,'2022-01-18 16:52:01','',''),(2546506,'19','199','1023',467,'Retail Sale Id 1549596',4050.00,0.00,0.00,6.25,846.88,'2022-01-18 16:52:01','',''),(2546627,'19','199','1023',467,'Retail Sale Id 1549681',3556.25,0.00,0.00,6.25,353.13,'2022-01-18 17:00:06','',''),(2546628,'19','199','1023',467,'Retail Sale Id 1549681',3556.25,0.00,0.00,6.25,353.13,'2022-01-18 17:00:07','',''),(2546629,'19','199','1023',467,'Retail Sale Id 1549681',7112.50,0.00,0.00,12.50,706.25,'2022-01-18 17:00:07','',''),(2546630,'19','199','1023',467,'Retail Sale Id 1549681',28450.00,0.00,0.00,50.00,2825.00,'2022-01-18 17:00:07','',''),(2546759,'19','199','1023',467,'Retail Sale Id 1549802',3240.00,0.00,0.00,5.00,677.50,'2022-01-18 17:08:31','',''),(2549868,'19','199','1023',467,'Retail Sale Id 1552317',1944.00,0.00,0.00,3.00,406.50,'2022-01-19 09:32:58','',''),(2549869,'19','199','1023',467,'Retail Sale Id 1552317',8100.00,0.00,0.00,12.50,1693.75,'2022-01-19 09:32:58','',''),(2550051,'19','199','1023',467,'Retail Sale Id 1552512',5184.00,0.00,0.00,8.00,1084.00,'2022-01-19 09:49:40','',''),(2550095,'19','199','1023',467,'Retail Sale Id 1552551',1944.00,0.00,0.00,3.00,406.50,'2022-01-19 09:54:30','',''),(2550137,'19','199','1023',467,'Retail Sale Id 1552594',4050.00,0.00,0.00,6.25,846.88,'2022-01-19 09:58:29','',''),(2550593,'19','199','1023',467,'Retail Sale Id 1553064',3888.00,0.00,0.00,6.00,813.00,'2022-01-19 10:45:45','',''),(2550771,'19','199','1023',467,'Retail Sale Id 1553190',8100.00,0.00,0.00,12.50,1693.75,'2022-01-19 11:00:30','',''),(2550789,'19','199','1023',467,'Retail Sale Id 1553224',8100.00,0.00,0.00,12.50,1693.75,'2022-01-19 11:02:02','',''),(2550804,'19','199','1023',467,'Retail Sale Id 1553242',1944.00,0.00,0.00,3.00,406.50,'2022-01-19 11:03:52','',''),(2550919,'19','199','1023',467,'Retail Sale Id 1553344',8100.00,0.00,0.00,12.50,1693.75,'2022-01-19 11:16:47','',''),(2550966,'19','199','1023',467,'Retail Sale Id 1553400',1944.00,0.00,0.00,3.00,406.50,'2022-01-19 11:21:28','',''),(2550993,'19','199','1023',467,'Retail Sale Id 1553430',8100.00,0.00,0.00,12.50,1693.75,'2022-01-19 11:25:13','',''),(2551082,'19','199','1023',467,'Retail Sale Id 1553531',8100.00,0.00,0.00,12.50,1693.75,'2022-01-19 11:35:31','',''),(2551187,'19','199','1023',467,'Retail Sale Id 1553644',3888.00,0.00,0.00,6.00,813.00,'2022-01-19 11:46:15','',''),(2551218,'19','199','1023',467,'Retail Sale Id 1553680',8100.00,0.00,0.00,12.50,1693.75,'2022-01-19 11:49:22','',''),(2551340,'19','199','1023',467,'Retail Sale Id 1553775',3888.00,0.00,0.00,6.00,813.00,'2022-01-19 12:01:43','',''),(2551485,'19','199','1023',467,'Retail Sale Id 1553956',2592.00,0.00,0.00,4.00,542.00,'2022-01-19 12:17:55','',''),(2551566,'19','199','1023',467,'Retail Sale Id 1554018',4050.00,0.00,0.00,6.25,846.88,'2022-01-19 12:27:35','',''),(2551581,'19','199','1023',467,'Retail Sale Id 1554041',8100.00,0.00,0.00,12.50,1693.75,'2022-01-19 12:29:44','',''),(2551600,'19','199','1023',467,'Retail Sale Id 1554051',3240.00,0.00,0.00,5.00,677.50,'2022-01-19 12:32:17','',''),(2551984,'19','199','1023',467,'Retail Sale Id 1554438',4050.00,0.00,0.00,6.25,846.88,'2022-01-19 13:24:36','',''),(2552314,'19','199','1023',467,'Retail Sale Id 1554737',1944.00,0.00,0.00,3.00,406.50,'2022-01-19 14:01:32','',''),(2552338,'19','199','1023',467,'Retail Sale Id 1554768',3888.00,0.00,0.00,6.00,813.00,'2022-01-19 14:03:55','',''),(2552395,'19','199','1023',467,'Retail Sale Id 1554823',2916.00,0.00,0.00,4.50,609.75,'2022-01-19 14:09:31','',''),(2552442,'19','199','1023',467,'Retail Sale Id 1554871',4050.00,0.00,0.00,6.25,846.88,'2022-01-19 14:16:02','',''),(2552660,'19','199','1023',467,'Retail Sale Id 1555048',4050.00,0.00,0.00,6.25,846.88,'2022-01-19 14:36:08','',''),(2552690,'19','199','1023',467,'Retail Sale Id 1555079',1944.00,0.00,0.00,3.00,406.50,'2022-01-19 14:39:59','',''),(2552727,'19','199','1023',467,'Retail Sale Id 1555098',3888.00,0.00,0.00,6.00,813.00,'2022-01-19 14:41:52','',''),(2552760,'19','199','1023',467,'Retail Sale Id 1555119',8100.00,0.00,0.00,12.50,1693.75,'2022-01-19 14:44:31','',''),(2552801,'19','199','1023',467,'Retail Sale Id 1555160',1944.00,0.00,0.00,3.00,406.50,'2022-01-19 14:48:57','',''),(2552843,'19','199','1023',467,'Retail Sale Id 1555201',1944.00,0.00,0.00,3.00,406.50,'2022-01-19 14:53:22','',''),(2552933,'19','199','1023',467,'Retail Sale Id 1555292',8100.00,0.00,0.00,12.50,1693.75,'2022-01-19 15:01:51','',''),(2553104,'19','199','1023',467,'Retail Sale Id 1555450',4050.00,0.00,0.00,6.25,846.88,'2022-01-19 15:19:39','',''),(2553105,'19','199','1023',467,'Retail Sale Id 1555450',8100.00,0.00,0.00,12.50,1693.75,'2022-01-19 15:19:39','',''),(2553139,'19','199','1023',467,'Retail Sale Id 1555491',4050.00,0.00,0.00,6.25,846.88,'2022-01-19 15:22:19','',''),(2553752,'19','199','1023',467,'Retail Sale Id 1555905',3240.00,0.00,0.00,5.00,677.50,'2022-01-19 16:08:04','',''),(2553818,'19','199','1023',467,'Retail Sale Id 1555975',1944.00,0.00,0.00,3.00,406.50,'2022-01-19 16:14:32','',''),(2553841,'19','199','1023',467,'Retail Sale Id 1555998',1944.00,0.00,0.00,3.00,406.50,'2022-01-19 16:16:45','',''),(2553928,'19','199','1023',467,'Retail Sale Id 1556054',1944.00,0.00,0.00,3.00,406.50,'2022-01-19 16:22:35','',''),(2554127,'19','199','1023',467,'Retail Sale Id 1556222',1944.00,0.00,0.00,3.00,406.50,'2022-01-19 16:36:47','',''),(2554225,'19','199','1023',467,'Retail Sale Id 1556330',1944.00,0.00,0.00,3.00,406.50,'2022-01-19 16:45:57','',''),(2554278,'19','199','1023',467,'Retail Sale Id 1556387',4050.00,0.00,0.00,6.25,846.88,'2022-01-19 16:49:47','',''),(2554374,'19','199','1023',467,'Retail Sale Id 1556496',1944.00,0.00,0.00,3.00,406.50,'2022-01-19 16:56:25','',''),(2554532,'19','199','1023',467,'Retail Sale Id 1556671',2592.00,0.00,0.00,4.00,542.00,'2022-01-19 17:07:20','',''),(2554789,'19','199','1023',467,'Retail Sale Id 1556922',8100.00,0.00,0.00,12.50,1693.75,'2022-01-19 17:26:24','',''),(2554804,'19','199','1023',467,'Retail Sale Id 1556934',8100.00,0.00,0.00,12.50,1693.75,'2022-01-19 17:27:20','',''),(2554840,'19','199','1023',467,'Retail Sale Id 1556971',1944.00,0.00,0.00,3.00,406.50,'2022-01-19 17:30:14','',''),(2556755,'19','199','1023',467,'Retail Sale Id 1558395',1944.00,0.00,0.00,3.00,406.50,'2022-01-20 08:30:06','',''),(2556769,'19','199','1023',467,'Retail Sale Id 1558414',3240.00,0.00,0.00,5.00,677.50,'2022-01-20 08:31:45','',''),(2556824,'19','199','1023',467,'Retail Sale Id 1558469',4050.00,0.00,0.00,6.25,846.88,'2022-01-20 08:36:44','',''),(2556841,'19','199','1023',467,'Retail Sale Id 1558485',8100.00,0.00,0.00,12.50,1693.75,'2022-01-20 08:38:30','',''),(2557444,'19','199','1023',467,'Retail Sale Id 1558932',1944.00,0.00,0.00,3.00,406.50,'2022-01-20 09:19:40','',''),(2557793,'19','199','1023',467,'Retail Sale Id 1559310',3240.00,0.00,0.00,5.00,677.50,'2022-01-20 09:55:04','',''),(2558678,'19','199','1023',467,'Retail Sale Id 1560044',1944.00,0.00,0.00,3.00,406.50,'2022-01-20 10:59:14','',''),(2558791,'19','199','1023',467,'Retail Sale Id 1560174',4050.00,0.00,0.00,6.25,846.88,'2022-01-20 11:12:11','',''),(2559060,'19','199','1023',467,'Retail Sale Id 1560456',3240.00,0.00,0.00,5.00,677.50,'2022-01-20 11:38:24','',''),(2559154,'19','199','1023',467,'Retail Sale Id 1560555',3888.00,0.00,0.00,6.00,813.00,'2022-01-20 11:48:33','',''),(2559184,'19','199','1023',467,'Retail Sale Id 1560584',1944.00,0.00,0.00,3.00,406.50,'2022-01-20 11:50:36','',''),(2559267,'19','199','1023',467,'Retail Sale Id 1560672',1944.00,0.00,0.00,3.00,406.50,'2022-01-20 11:59:38','',''),(2559406,'19','199','1023',467,'Retail Sale Id 1560826',4050.00,0.00,0.00,6.25,846.88,'2022-01-20 12:14:36','',''),(2560391,'19','199','1023',467,'Retail Sale Id 1561888',1944.00,0.00,0.00,3.00,406.50,'2022-01-20 13:56:35','',''),(2560403,'19','199','1023',467,'Retail Sale Id 1561901',1944.00,0.00,0.00,3.00,406.50,'2022-01-20 13:57:35','',''),(2560420,'19','199','1023',467,'Retail Sale Id 1561919',1944.00,0.00,0.00,3.00,406.50,'2022-01-20 13:58:53','',''),(2560435,'19','199','1023',467,'Retail Sale Id 1561933',4050.00,0.00,0.00,6.25,846.88,'2022-01-20 14:00:05','',''),(2560449,'19','199','1023',467,'Retail Sale Id 1561945',1944.00,0.00,0.00,3.00,406.50,'2022-01-20 14:01:16','',''),(2560462,'19','199','1023',467,'Retail Sale Id 1561960',2592.00,0.00,0.00,4.00,542.00,'2022-01-20 14:02:41','',''),(2560463,'19','199','1023',467,'Retail Sale Id 1561960',2592.00,0.00,0.00,4.00,542.00,'2022-01-20 14:02:41','',''),(2560497,'19','199','1023',467,'Retail Sale Id 1561984',1944.00,0.00,0.00,3.00,406.50,'2022-01-20 14:06:54','',''),(2560557,'19','199','1023',467,'Retail Sale Id 1562034',3888.00,0.00,0.00,6.00,813.00,'2022-01-20 14:12:36','',''),(2560581,'19','199','1023',467,'Retail Sale Id 1562096',2592.00,0.00,0.00,4.00,542.00,'2022-01-20 14:15:35','',''),(2560598,'19','199','1023',467,'Retail Sale Id 1562111',1944.00,0.00,0.00,3.00,406.50,'2022-01-20 14:17:25','',''),(2560618,'19','199','1023',467,'Retail Sale Id 1562135',8100.00,0.00,0.00,12.50,1693.75,'2022-01-20 14:20:33','',''),(2560648,'19','199','1023',467,'Retail Sale Id 1562170',1944.00,0.00,0.00,3.00,406.50,'2022-01-20 14:23:25','',''),(2560670,'19','199','1023',467,'Retail Sale Id 1562189',3240.00,0.00,0.00,5.00,677.50,'2022-01-20 14:25:37','',''),(2560699,'19','199','1023',467,'Retail Sale Id 1562214',3240.00,0.00,0.00,5.00,677.50,'2022-01-20 14:27:47','',''),(2560736,'19','199','1023',467,'Retail Sale Id 1562241',3240.00,0.00,0.00,5.00,677.50,'2022-01-20 14:30:55','',''),(2561252,'19','199','1023',467,'Retail Sale Id 1562715',8100.00,0.00,0.00,12.50,1693.75,'2022-01-20 15:12:12','',''),(2561302,'19','199','1023',467,'Retail Sale Id 1562761',3240.00,0.00,0.00,5.00,677.50,'2022-01-20 15:16:34','',''),(2561303,'19','199','1023',467,'Retail Sale Id 1562761',8100.00,0.00,0.00,12.50,1693.75,'2022-01-20 15:16:34','',''),(2561480,'19','199','1023',467,'Retail Sale Id 1562915',1944.00,0.00,0.00,3.00,406.50,'2022-01-20 15:31:26','',''),(2561551,'19','199','1023',467,'Retail Sale Id 1563152',5184.00,0.00,0.00,8.00,1084.00,'2022-01-20 15:42:17','',''),(2561571,'19','199','1023',467,'Retail Sale Id 1563217',1944.00,0.00,0.00,3.00,406.50,'2022-01-20 15:44:39','',''),(2561603,'19','199','1023',467,'Retail Sale Id 1563238',8100.00,0.00,0.00,12.50,1693.75,'2022-01-20 15:47:05','',''),(2561624,'19','199','1023',467,'Retail Sale Id 1563261',8100.00,0.00,0.00,12.50,1693.75,'2022-01-20 15:48:34','',''),(2561686,'19','199','1023',467,'Retail Sale Id 1563320',1944.00,0.00,0.00,3.00,406.50,'2022-01-20 15:54:04','',''),(2561714,'19','199','1023',467,'Retail Sale Id 1563343',1944.00,0.00,0.00,3.00,406.50,'2022-01-20 15:56:35','',''),(2561863,'19','199','1023',467,'Retail Sale Id 1563513',3888.00,0.00,0.00,6.00,813.00,'2022-01-20 16:11:38','',''),(2562207,'19','199','1023',467,'Retail Sale Id 1563808',6480.00,0.00,0.00,10.00,1355.00,'2022-01-20 16:34:34','',''),(2562354,'19','199','1023',467,'Retail Sale Id 1563899',1944.00,0.00,0.00,3.00,406.50,'2022-01-20 16:42:08','',''),(2562395,'19','199','1023',467,'Retail Sale Id 1563918',8100.00,0.00,0.00,12.50,1693.75,'2022-01-20 16:43:35','',''),(2562441,'19','199','1023',467,'Retail Sale Id 1563946',1944.00,0.00,0.00,3.00,406.50,'2022-01-20 16:45:27','',''),(2562458,'19','199','1023',467,'Retail Sale Id 1563961',3888.00,0.00,0.00,6.00,813.00,'2022-01-20 16:46:58','',''),(2562476,'19','199','1023',467,'Retail Sale Id 1563985',4050.00,0.00,0.00,6.25,846.88,'2022-01-20 16:48:23','',''),(2562657,'19','199','1023',467,'Retail Sale Id 1564196',8100.00,0.00,0.00,12.50,1693.75,'2022-01-20 17:01:38','',''),(2562704,'19','199','1023',467,'Retail Sale Id 1564254',3240.00,0.00,0.00,5.00,677.50,'2022-01-20 17:04:44','',''),(2562789,'19','199','1023',467,'Retail Sale Id 1564339',8100.00,0.00,0.00,12.50,1693.75,'2022-01-20 17:09:56','',''),(2562843,'19','199','1023',467,'Retail Sale Id 1564398',1944.00,0.00,0.00,3.00,406.50,'2022-01-20 17:13:28','',''),(2562844,'19','199','1023',467,'Retail Sale Id 1564398',8100.00,0.00,0.00,12.50,1693.75,'2022-01-20 17:13:28','',''),(2562872,'19','199','1023',467,'Retail Sale Id 1564437',1944.00,0.00,0.00,3.00,406.50,'2022-01-20 17:15:26','',''),(2562927,'19','199','1023',467,'Retail Sale Id 1564503',8100.00,0.00,0.00,12.50,1693.75,'2022-01-20 17:18:31','',''),(2562987,'19','199','1023',467,'Retail Sale Id 1564570',4050.00,0.00,0.00,6.25,846.88,'2022-01-20 17:23:29','',''),(2563084,'19','199','1023',467,'Retail Sale Id 1564710',8100.00,0.00,0.00,12.50,1693.75,'2022-01-20 17:31:52','',''),(2563114,'19','199','1023',467,'Retail Sale Id 1564740',8100.00,0.00,0.00,12.50,1693.75,'2022-01-20 17:33:54','',''),(2565488,'19','199','1023',467,'Retail Sale Id 1566773',3888.00,0.00,0.00,6.00,813.00,'2022-01-21 08:54:07','',''),(2565515,'19','199','1023',467,'Retail Sale Id 1566802',3888.00,0.00,0.00,6.00,813.00,'2022-01-21 08:56:35','',''),(2565547,'19','199','1023',467,'Retail Sale Id 1566831',3888.00,0.00,0.00,6.00,813.00,'2022-01-21 08:59:47','',''),(2565548,'19','199','1023',467,'Retail Sale Id 1566831',3888.00,0.00,0.00,6.00,813.00,'2022-01-21 08:59:47','',''),(2565591,'19','199','1023',467,'Retail Sale Id 1566862',2592.00,0.00,0.00,4.00,542.00,'2022-01-21 09:02:56','',''),(2565641,'19','199','1023',467,'Retail Sale Id 1566920',8100.00,0.00,0.00,12.50,1693.75,'2022-01-21 09:08:08','',''),(2565825,'19','199','1023',467,'Retail Sale Id 1567084',8100.00,0.00,0.00,12.50,1693.75,'2022-01-21 09:23:17','',''),(2565840,'19','199','1023',467,'Retail Sale Id 1567107',8100.00,0.00,0.00,12.50,1693.75,'2022-01-21 09:24:46','',''),(2565871,'19','199','1023',467,'Retail Sale Id 1567124',8100.00,0.00,0.00,12.50,1693.75,'2022-01-21 09:26:35','',''),(2565891,'19','199','1023',467,'Retail Sale Id 1567140',1944.00,0.00,0.00,3.00,406.50,'2022-01-21 09:28:00','',''),(2565971,'19','199','1023',467,'Retail Sale Id 1567224',8100.00,0.00,0.00,12.50,1693.75,'2022-01-21 09:36:25','',''),(2565991,'19','199','1023',467,'Retail Sale Id 1567237',1944.00,0.00,0.00,3.00,406.50,'2022-01-21 09:38:09','',''),(2566191,'19','199','1023',467,'Retail Sale Id 1567416',3888.00,0.00,0.00,6.00,813.00,'2022-01-21 09:57:46','',''),(2566289,'19','199','1023',467,'Retail Sale Id 1567473',4050.00,0.00,0.00,6.25,846.88,'2022-01-21 10:03:04','',''),(2566328,'19','199','1023',467,'Retail Sale Id 1567488',4050.00,0.00,0.00,6.25,846.88,'2022-01-21 10:05:34','',''),(2566329,'19','199','1023',467,'Retail Sale Id 1567488',4050.00,0.00,0.00,6.25,846.88,'2022-01-21 10:05:34','',''),(2566330,'19','199','1023',467,'Retail Sale Id 1567488',8100.00,0.00,0.00,12.50,1693.75,'2022-01-21 10:05:34','',''),(2566353,'19','199','1023',467,'Retail Sale Id 1567523',1944.00,0.00,0.00,3.00,406.50,'2022-01-21 10:08:02','',''),(2566363,'19','199','1023',467,'Retail Sale Id 1567530',4050.00,0.00,0.00,6.25,846.88,'2022-01-21 10:09:05','',''),(2566409,'19','199','1023',467,'Retail Sale Id 1567580',1944.00,0.00,0.00,3.00,406.50,'2022-01-21 10:14:31','',''),(2566584,'19','199','1023',467,'Retail Sale Id 1567705',1944.00,0.00,0.00,3.00,406.50,'2022-01-21 10:29:36','',''),(2566615,'19','199','1023',467,'Retail Sale Id 1567733',4860.00,0.00,0.00,7.50,1016.25,'2022-01-21 10:33:30','',''),(2566667,'19','199','1023',467,'Retail Sale Id 1567755',8100.00,0.00,0.00,12.50,1693.75,'2022-01-21 10:36:07','',''),(2567384,'19','199','1023',467,'Retail Sale Id 1568379',4050.00,0.00,0.00,6.25,846.88,'2022-01-21 11:43:43','',''),(2567508,'19','199','1023',467,'Retail Sale Id 1568475',8100.00,0.00,0.00,12.50,1693.75,'2022-01-21 11:53:00','',''),(2567584,'19','199','1023',467,'Retail Sale Id 1568520',8100.00,0.00,0.00,12.50,1693.75,'2022-01-21 11:58:17','',''),(2567627,'19','199','1023',467,'Retail Sale Id 1568557',3888.00,0.00,0.00,6.00,813.00,'2022-01-21 12:02:20','',''),(2567674,'19','199','1023',467,'Retail Sale Id 1568608',8100.00,0.00,0.00,12.50,1693.75,'2022-01-21 12:07:11','',''),(2567706,'19','199','1023',467,'Retail Sale Id 1568632',8100.00,0.00,0.00,12.50,1693.75,'2022-01-21 12:09:22','',''),(2567939,'19','199','1023',467,'Retail Sale Id 1568851',3240.00,0.00,0.00,5.00,677.50,'2022-01-21 12:33:51','',''),(2567953,'19','199','1023',467,'Retail Sale Id 1568865',4050.00,0.00,0.00,6.25,846.88,'2022-01-21 12:35:36','',''),(2568044,'19','199','1023',467,'Retail Sale Id 1568958',8100.00,0.00,0.00,12.50,1693.75,'2022-01-21 12:45:58','',''),(2568058,'19','199','1023',467,'Retail Sale Id 1568976',1944.00,0.00,0.00,3.00,406.50,'2022-01-21 12:47:24','',''),(2568079,'19','199','1023',467,'Retail Sale Id 1568999',1944.00,0.00,0.00,3.00,406.50,'2022-01-21 12:49:48','',''),(2568090,'19','199','1023',467,'Retail Sale Id 1569010',1944.00,0.00,0.00,3.00,406.50,'2022-01-21 12:51:09','',''),(2568102,'19','199','1023',467,'Retail Sale Id 1569022',3888.00,0.00,0.00,6.00,813.00,'2022-01-21 12:52:45','',''),(2568123,'19','199','1023',467,'Retail Sale Id 1569039',4050.00,0.00,0.00,6.25,846.88,'2022-01-21 12:55:06','',''),(2568161,'19','199','1023',467,'Retail Sale Id 1569066',8100.00,0.00,0.00,12.50,1693.75,'2022-01-21 12:58:13','',''),(2568986,'19','199','1023',467,'Retail Sale Id 1569885',1944.00,0.00,0.00,3.00,406.50,'2022-01-21 14:32:56','',''),(2569145,'19','199','1023',467,'Retail Sale Id 1570053',1944.00,0.00,0.00,3.00,406.50,'2022-01-21 14:49:41','',''),(2569258,'19','199','1023',467,'Retail Sale Id 1570166',8100.00,0.00,0.00,12.50,1693.75,'2022-01-21 14:59:51','',''),(2569492,'19','199','1023',467,'Retail Sale Id 1570296',3240.00,0.00,0.00,5.00,677.50,'2022-01-21 15:14:33','',''),(2570011,'19','199','1023',467,'Retail Sale Id 1570977',2592.00,0.00,0.00,4.00,542.00,'2022-01-21 16:02:02','',''),(2570012,'19','199','1023',467,'Retail Sale Id 1570977',8100.00,0.00,0.00,12.50,1693.75,'2022-01-21 16:02:02','',''),(2570086,'19','199','1023',467,'Retail Sale Id 1571048',1944.00,0.00,0.00,3.00,406.50,'2022-01-21 16:08:11','',''),(2570116,'19','199','1023',467,'Retail Sale Id 1571077',1944.00,0.00,0.00,3.00,406.50,'2022-01-21 16:10:55','',''),(2570163,'19','199','1023',467,'Retail Sale Id 1571133',8100.00,0.00,0.00,12.50,1693.75,'2022-01-21 16:14:34','',''),(2570234,'19','199','1023',467,'Retail Sale Id 1571189',3240.00,0.00,0.00,5.00,677.50,'2022-01-21 16:19:45','',''),(2570235,'19','199','1023',467,'Retail Sale Id 1571189',8100.00,0.00,0.00,12.50,1693.75,'2022-01-21 16:19:45','',''),(2570357,'19','199','1023',467,'Retail Sale Id 1571296',4050.00,0.00,0.00,6.25,846.88,'2022-01-21 16:27:33','',''),(2570388,'19','199','1023',467,'Retail Sale Id 1571314',1944.00,0.00,0.00,3.00,406.50,'2022-01-21 16:29:12','',''),(2570593,'19','199','1023',467,'Retail Sale Id 1571469',8100.00,0.00,0.00,12.50,1693.75,'2022-01-21 16:42:08','',''),(2570975,'19','199','1023',467,'Retail Sale Id 1571881',4050.00,0.00,0.00,6.25,846.88,'2022-01-21 17:06:30','',''),(2571242,'19','199','1023',467,'Retail Sale Id 1572138',4050.00,0.00,0.00,6.25,846.88,'2022-01-21 17:23:43','',''),(2571270,'19','199','1023',467,'Retail Sale Id 1572165',8100.00,0.00,0.00,12.50,1693.75,'2022-01-21 17:25:36','',''),(2571284,'19','199','1023',467,'Retail Sale Id 1572183',1944.00,0.00,0.00,3.00,406.50,'2022-01-21 17:26:47','',''),(2571373,'19','199','1023',467,'Retail Sale Id 1572255',7128.00,0.00,0.00,11.00,1490.50,'2022-01-21 17:32:13','',''),(2571425,'19','199','1023',467,'Retail Sale Id 1572305',1944.00,0.00,0.00,3.00,406.50,'2022-01-21 17:34:56','',''),(2571426,'19','199','1023',467,'Retail Sale Id 1572305',1944.00,0.00,0.00,3.00,406.50,'2022-01-21 17:34:56','',''),(2571621,'19','199','1023',467,'Retail Sale Id 1572513',6480.00,0.00,0.00,10.00,1355.00,'2022-01-21 17:50:25','',''),(2573891,'19','199','1023',467,'Retail Sale Id 1574365',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 09:08:29','',''),(2573915,'19','199','1023',467,'Retail Sale Id 1574386',3888.00,0.00,0.00,6.00,813.00,'2022-01-22 09:10:49','',''),(2573978,'19','199','1023',467,'Retail Sale Id 1574449',3888.00,0.00,0.00,6.00,813.00,'2022-01-22 09:16:15','',''),(2573998,'19','199','1023',467,'Retail Sale Id 1574471',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 09:17:41','',''),(2574019,'19','199','1023',467,'Retail Sale Id 1574493',8100.00,0.00,0.00,12.50,1693.75,'2022-01-22 09:19:49','',''),(2574128,'19','199','1023',467,'Retail Sale Id 1574590',8100.00,0.00,0.00,12.50,1693.75,'2022-01-22 09:29:03','',''),(2574192,'19','199','1023',467,'Retail Sale Id 1574659',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 09:36:36','',''),(2574220,'19','199','1023',467,'Retail Sale Id 1574679',28450.00,0.00,0.00,50.00,2825.00,'2022-01-22 09:39:13','',''),(2574221,'19','199','1023',467,'Retail Sale Id 1574679',28450.00,0.00,0.00,50.00,2825.00,'2022-01-22 09:39:13','',''),(2574239,'19','199','1023',467,'Retail Sale Id 1574702',8100.00,0.00,0.00,12.50,1693.75,'2022-01-22 09:40:59','',''),(2574325,'19','199','1023',467,'Retail Sale Id 1574750',8100.00,0.00,0.00,12.50,1693.75,'2022-01-22 09:47:04','',''),(2574381,'19','199','1023',467,'Retail Sale Id 1574783',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 09:49:38','',''),(2574400,'19','199','1023',467,'Retail Sale Id 1574802',3240.00,0.00,0.00,5.00,677.50,'2022-01-22 09:51:21','',''),(2574421,'19','199','1023',467,'Retail Sale Id 1574823',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 09:53:12','',''),(2574737,'19','199','1023',467,'Retail Sale Id 1575090',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 10:17:30','',''),(2574738,'19','199','1023',467,'Retail Sale Id 1575090',4050.00,0.00,0.00,6.25,846.88,'2022-01-22 10:17:30','',''),(2574829,'19','199','1023',467,'Retail Sale Id 1575189',8100.00,0.00,0.00,12.50,1693.75,'2022-01-22 10:25:48','',''),(2574864,'19','199','1023',467,'Retail Sale Id 1575227',4050.00,0.00,0.00,6.25,846.88,'2022-01-22 10:28:53','',''),(2574865,'19','199','1023',467,'Retail Sale Id 1575227',8100.00,0.00,0.00,12.50,1693.75,'2022-01-22 10:28:53','',''),(2574899,'19','199','1023',467,'Retail Sale Id 1575262',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 10:31:35','',''),(2574914,'19','199','1023',467,'Retail Sale Id 1575277',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 10:32:55','',''),(2574968,'19','199','1023',467,'Retail Sale Id 1575325',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 10:36:43','',''),(2575045,'19','199','1023',467,'Retail Sale Id 1575394',4536.00,0.00,0.00,7.00,948.50,'2022-01-22 10:42:43','',''),(2575212,'19','199','1023',467,'Retail Sale Id 1575693',6480.00,0.00,0.00,10.00,1355.00,'2022-01-22 10:58:39','',''),(2575262,'19','199','1023',467,'Retail Sale Id 1575738',6804.00,0.00,0.00,10.50,1422.75,'2022-01-22 11:02:02','',''),(2575385,'19','199','1023',467,'Retail Sale Id 1575823',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 11:09:01','',''),(2575522,'19','199','1023',467,'Retail Sale Id 1575952',8100.00,0.00,0.00,12.50,1693.75,'2022-01-22 11:18:31','',''),(2575594,'19','199','1023',467,'Retail Sale Id 1576023',8100.00,0.00,0.00,12.50,1693.75,'2022-01-22 11:24:05','',''),(2575609,'19','199','1023',467,'Retail Sale Id 1576039',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 11:25:37','',''),(2575672,'19','199','1023',467,'Retail Sale Id 1576108',3240.00,0.00,0.00,5.00,677.50,'2022-01-22 11:30:39','',''),(2575703,'19','199','1023',467,'Retail Sale Id 1576139',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 11:33:05','',''),(2575704,'19','199','1023',467,'Retail Sale Id 1576139',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 11:33:05','',''),(2575746,'19','199','1023',467,'Retail Sale Id 1576177',3888.00,0.00,0.00,6.00,813.00,'2022-01-22 11:35:42','',''),(2575989,'19','199','1023',467,'Retail Sale Id 1576372',6480.00,0.00,0.00,10.00,1355.00,'2022-01-22 11:51:00','',''),(2576083,'19','199','1023',467,'Retail Sale Id 1576461',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 11:58:50','',''),(2576298,'19','199','1023',467,'Retail Sale Id 1576662',3888.00,0.00,0.00,6.00,813.00,'2022-01-22 12:14:01','',''),(2576326,'19','199','1023',467,'Retail Sale Id 1576690',8100.00,0.00,0.00,12.50,1693.75,'2022-01-22 12:15:55','',''),(2576357,'19','199','1023',467,'Retail Sale Id 1576718',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 12:18:07','',''),(2576397,'19','199','1023',467,'Retail Sale Id 1576760',8100.00,0.00,0.00,12.50,1693.75,'2022-01-22 12:21:12','',''),(2576749,'19','199','1023',467,'Retail Sale Id 1577080',8100.00,0.00,0.00,12.50,1693.75,'2022-01-22 12:45:21','',''),(2576796,'19','199','1023',467,'Retail Sale Id 1577113',8100.00,0.00,0.00,12.50,1693.75,'2022-01-22 12:48:06','',''),(2576910,'19','199','1023',467,'Retail Sale Id 1577278',8100.00,0.00,0.00,12.50,1693.75,'2022-01-22 12:55:59','',''),(2576962,'19','199','1023',467,'Retail Sale Id 1577329',3888.00,0.00,0.00,6.00,813.00,'2022-01-22 13:00:17','',''),(2577018,'19','199','1023',467,'Retail Sale Id 1577382',2592.00,0.00,0.00,4.00,542.00,'2022-01-22 13:04:04','',''),(2577278,'19','199','1023',467,'Retail Sale Id 1577610',3240.00,0.00,0.00,5.00,677.50,'2022-01-22 13:29:20','',''),(2577371,'19','199','1023',467,'Retail Sale Id 1577690',3240.00,0.00,0.00,5.00,677.50,'2022-01-22 13:37:46','',''),(2577506,'19','199','1023',467,'Retail Sale Id 1577807',6480.00,0.00,0.00,10.00,1355.00,'2022-01-22 13:50:27','',''),(2577577,'19','199','1023',467,'Retail Sale Id 1577883',3888.00,0.00,0.00,6.00,813.00,'2022-01-22 13:58:54','',''),(2577608,'19','199','1023',467,'Retail Sale Id 1577918',28450.00,0.00,0.00,50.00,2825.00,'2022-01-22 14:01:27','',''),(2577671,'19','199','1023',467,'Retail Sale Id 1577968',8100.00,0.00,0.00,12.50,1693.75,'2022-01-22 14:05:29','',''),(2577672,'19','199','1023',467,'Retail Sale Id 1577968',8100.00,0.00,0.00,12.50,1693.75,'2022-01-22 14:05:29','',''),(2578354,'19','199','1023',467,'Retail Sale Id 1578578',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 15:02:25','',''),(2578355,'19','199','1023',467,'Retail Sale Id 1578578',4050.00,0.00,0.00,6.25,846.88,'2022-01-22 15:02:25','',''),(2578440,'19','199','1023',467,'Retail Sale Id 1578629',8100.00,0.00,0.00,12.50,1693.75,'2022-01-22 15:06:23','',''),(2578509,'19','199','1023',467,'Retail Sale Id 1578658',3240.00,0.00,0.00,5.00,677.50,'2022-01-22 15:10:54','',''),(2578527,'19','199','1023',467,'Retail Sale Id 1578697',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 15:12:30','',''),(2578554,'19','199','1023',467,'Retail Sale Id 1578716',8100.00,0.00,0.00,12.50,1693.75,'2022-01-22 15:14:46','',''),(2578617,'19','199','1023',467,'Retail Sale Id 1578792',3240.00,0.00,0.00,5.00,677.50,'2022-01-22 15:22:11','',''),(2578749,'19','199','1023',467,'Retail Sale Id 1578863',6804.00,0.00,0.00,10.50,1422.75,'2022-01-22 15:28:55','',''),(2578934,'19','199','1023',467,'Retail Sale Id 1579045',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 15:45:51','',''),(2579372,'19','199','1023',467,'Retail Sale Id 1579487',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 16:25:00','',''),(2579486,'19','199','1023',467,'Retail Sale Id 1579591',3240.00,0.00,0.00,5.00,677.50,'2022-01-22 16:36:17','',''),(2579666,'19','199','1023',467,'Retail Sale Id 1579774',3240.00,0.00,0.00,5.00,677.50,'2022-01-22 16:49:51','',''),(2579677,'19','199','1023',467,'Retail Sale Id 1579804',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 16:51:09','',''),(2579858,'19','199','1023',467,'Retail Sale Id 1579900',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 17:03:06','',''),(2579859,'19','199','1023',467,'Retail Sale Id 1579900',8100.00,0.00,0.00,12.50,1693.75,'2022-01-22 17:03:06','',''),(2580123,'19','199','1023',467,'Retail Sale Id 1580155',1944.00,0.00,0.00,3.00,406.50,'2022-01-22 17:17:41','',''),(2582645,'19','199','1023',467,'Retail Sale Id 1582366',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 08:44:55','',''),(2582646,'19','199','1023',467,'Retail Sale Id 1582366',4050.00,0.00,0.00,6.25,846.88,'2022-01-23 08:44:55','',''),(2582675,'19','199','1023',467,'Retail Sale Id 1582394',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 08:47:35','',''),(2582771,'19','199','1023',467,'Retail Sale Id 1582476',4050.00,0.00,0.00,6.25,846.88,'2022-01-23 08:56:57','',''),(2582921,'19','199','1023',467,'Retail Sale Id 1582576',2916.00,0.00,0.00,4.50,609.75,'2022-01-23 09:05:58','',''),(2583031,'19','199','1023',467,'Retail Sale Id 1582680',3240.00,0.00,0.00,5.00,677.50,'2022-01-23 09:16:07','',''),(2583138,'19','199','1023',467,'Retail Sale Id 1582789',5832.00,0.00,0.00,9.00,1219.50,'2022-01-23 09:26:42','',''),(2583193,'19','199','1023',467,'Retail Sale Id 1582850',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 09:32:33','',''),(2583263,'19','199','1023',467,'Retail Sale Id 1582932',28450.00,0.00,0.00,50.00,2825.00,'2022-01-23 09:38:46','',''),(2583324,'19','199','1023',467,'Retail Sale Id 1582996',8100.00,0.00,0.00,12.50,1693.75,'2022-01-23 09:44:13','',''),(2583389,'19','199','1023',467,'Retail Sale Id 1583059',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 09:49:23','',''),(2583460,'19','199','1023',467,'Retail Sale Id 1583141',2592.00,0.00,0.00,4.00,542.00,'2022-01-23 09:56:07','',''),(2583755,'19','199','1023',467,'Retail Sale Id 1583428',8100.00,0.00,0.00,12.50,1693.75,'2022-01-23 10:23:56','',''),(2583788,'19','199','1023',467,'Retail Sale Id 1583475',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 10:26:17','',''),(2583898,'19','199','1023',467,'Retail Sale Id 1583579',2592.00,0.00,0.00,4.00,542.00,'2022-01-23 10:37:13','',''),(2584023,'19','199','1023',467,'Retail Sale Id 1583663',8100.00,0.00,0.00,12.50,1693.75,'2022-01-23 10:46:19','',''),(2584135,'19','199','1023',467,'Retail Sale Id 1583770',8100.00,0.00,0.00,12.50,1693.75,'2022-01-23 10:55:54','',''),(2584181,'19','199','1023',467,'Retail Sale Id 1583814',8100.00,0.00,0.00,12.50,1693.75,'2022-01-23 10:59:52','',''),(2584213,'19','199','1023',467,'Retail Sale Id 1583851',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 11:02:48','',''),(2584279,'19','199','1023',467,'Retail Sale Id 1583913',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 11:08:06','',''),(2584441,'19','199','1023',467,'Retail Sale Id 1584085',8100.00,0.00,0.00,12.50,1693.75,'2022-01-23 11:22:58','',''),(2584487,'19','199','1023',467,'Retail Sale Id 1584119',2592.00,0.00,0.00,4.00,542.00,'2022-01-23 11:27:17','',''),(2584518,'19','199','1023',467,'Retail Sale Id 1584162',8100.00,0.00,0.00,12.50,1693.75,'2022-01-23 11:30:47','',''),(2584566,'19','199','1023',467,'Retail Sale Id 1584181',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 11:36:39','',''),(2584567,'19','199','1023',467,'Retail Sale Id 1584181',3888.00,0.00,0.00,6.00,813.00,'2022-01-23 11:36:39','',''),(2584588,'19','199','1023',467,'Retail Sale Id 1584235',8100.00,0.00,0.00,12.50,1693.75,'2022-01-23 11:38:46','',''),(2584627,'19','199','1023',467,'Retail Sale Id 1584278',8100.00,0.00,0.00,12.50,1693.75,'2022-01-23 11:42:42','',''),(2584679,'19','199','1023',467,'Retail Sale Id 1584331',6480.00,0.00,0.00,10.00,1355.00,'2022-01-23 11:48:18','',''),(2584773,'19','199','1023',467,'Retail Sale Id 1584417',8100.00,0.00,0.00,12.50,1693.75,'2022-01-23 11:56:00','',''),(2584974,'19','199','1023',467,'Retail Sale Id 1584664',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 12:19:33','',''),(2585031,'19','199','1023',467,'Retail Sale Id 1584694',2592.00,0.00,0.00,4.00,542.00,'2022-01-23 12:24:47','',''),(2585157,'19','199','1023',467,'Retail Sale Id 1584851',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 12:36:43','',''),(2585335,'19','199','1023',467,'Retail Sale Id 1585016',3888.00,0.00,0.00,6.00,813.00,'2022-01-23 12:50:14','',''),(2585336,'19','199','1023',467,'Retail Sale Id 1585016',8100.00,0.00,0.00,12.50,1693.75,'2022-01-23 12:50:14','',''),(2585381,'19','199','1023',467,'Retail Sale Id 1585062',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 12:53:57','',''),(2585536,'19','199','1023',467,'Retail Sale Id 1585221',2916.00,0.00,0.00,4.50,609.75,'2022-01-23 13:08:30','',''),(2585581,'19','199','1023',467,'Retail Sale Id 1585241',8100.00,0.00,0.00,12.50,1693.75,'2022-01-23 13:12:10','',''),(2585616,'19','199','1023',467,'Retail Sale Id 1585308',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 13:14:54','',''),(2585638,'19','199','1023',467,'Retail Sale Id 1585331',3888.00,0.00,0.00,6.00,813.00,'2022-01-23 13:16:52','',''),(2585794,'19','199','1023',467,'Retail Sale Id 1585482',3240.00,0.00,0.00,5.00,677.50,'2022-01-23 13:28:15','',''),(2585870,'19','199','1023',467,'Retail Sale Id 1585561',3888.00,0.00,0.00,6.00,813.00,'2022-01-23 13:35:57','',''),(2585871,'19','199','1023',467,'Retail Sale Id 1585561',3888.00,0.00,0.00,6.00,813.00,'2022-01-23 13:35:57','',''),(2586035,'19','199','1023',467,'Retail Sale Id 1585709',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 13:46:20','',''),(2586084,'19','199','1023',467,'Retail Sale Id 1585749',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 13:49:09','',''),(2586467,'19','199','1023',467,'Retail Sale Id 1586037',4050.00,0.00,0.00,6.25,846.88,'2022-01-23 14:16:16','',''),(2586517,'19','199','1023',467,'Retail Sale Id 1586109',8100.00,0.00,0.00,12.50,1693.75,'2022-01-23 14:21:17','',''),(2586545,'19','199','1023',467,'Retail Sale Id 1586133',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 14:24:08','',''),(2586581,'19','199','1023',467,'Retail Sale Id 1586167',4050.00,0.00,0.00,6.25,846.88,'2022-01-23 14:26:53','',''),(2586616,'19','199','1023',467,'Retail Sale Id 1586246',3888.00,0.00,0.00,6.00,813.00,'2022-01-23 14:30:55','',''),(2586639,'19','199','1023',467,'Retail Sale Id 1586270',2916.00,0.00,0.00,4.50,609.75,'2022-01-23 14:33:09','',''),(2586662,'19','199','1023',467,'Retail Sale Id 1586305',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 14:35:20','',''),(2586717,'19','199','1023',467,'Retail Sale Id 1586349',8100.00,0.00,0.00,12.50,1693.75,'2022-01-23 14:39:17','',''),(2586762,'19','199','1023',467,'Retail Sale Id 1586384',8100.00,0.00,0.00,12.50,1693.75,'2022-01-23 14:42:14','',''),(2586810,'19','199','1023',467,'Retail Sale Id 1586406',9720.00,0.00,0.00,15.00,2032.50,'2022-01-23 14:45:46','',''),(2586844,'19','199','1023',467,'Retail Sale Id 1586443',2592.00,0.00,0.00,4.00,542.00,'2022-01-23 14:47:41','',''),(2586883,'19','199','1023',467,'Retail Sale Id 1586459',8100.00,0.00,0.00,12.50,1693.75,'2022-01-23 14:49:14','',''),(2586966,'19','199','1023',467,'Retail Sale Id 1586501',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 14:53:38','',''),(2587175,'19','199','1023',467,'Retail Sale Id 1586661',8100.00,0.00,0.00,12.50,1693.75,'2022-01-23 15:10:04','',''),(2587176,'19','199','1023',467,'Retail Sale Id 1586661',8100.00,0.00,0.00,12.50,1693.75,'2022-01-23 15:10:04','',''),(2587219,'19','199','1023',467,'Retail Sale Id 1586698',3888.00,0.00,0.00,6.00,813.00,'2022-01-23 15:13:30','',''),(2587389,'19','199','1023',467,'Retail Sale Id 1586851',3888.00,0.00,0.00,6.00,813.00,'2022-01-23 15:28:30','',''),(2587586,'19','199','1023',467,'Retail Sale Id 1587040',2592.00,0.00,0.00,4.00,542.00,'2022-01-23 15:48:41','',''),(2587664,'19','199','1023',467,'Retail Sale Id 1587093',7776.00,0.00,0.00,12.00,1626.00,'2022-01-23 15:54:28','',''),(2587835,'19','199','1023',467,'Retail Sale Id 1587202',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 16:13:05','',''),(2587859,'19','199','1023',467,'Retail Sale Id 1587224',3240.00,0.00,0.00,5.00,677.50,'2022-01-23 16:16:13','',''),(2587980,'19','199','1023',467,'Retail Sale Id 1587310',8100.00,0.00,0.00,12.50,1693.75,'2022-01-23 16:28:46','',''),(2588001,'19','199','1023',467,'Retail Sale Id 1587325',3888.00,0.00,0.00,6.00,813.00,'2022-01-23 16:30:37','',''),(2588108,'19','199','1023',467,'Retail Sale Id 1587392',4050.00,0.00,0.00,6.25,846.88,'2022-01-23 16:38:55','',''),(2588139,'19','199','1023',467,'Retail Sale Id 1587418',5184.00,0.00,0.00,8.00,1084.00,'2022-01-23 16:42:22','',''),(2588190,'19','199','1023',467,'Retail Sale Id 1587463',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 16:46:54','',''),(2588207,'19','199','1023',467,'Retail Sale Id 1587479',3240.00,0.00,0.00,5.00,677.50,'2022-01-23 16:49:21','',''),(2588208,'19','199','1023',467,'Retail Sale Id 1587479',3240.00,0.00,0.00,5.00,677.50,'2022-01-23 16:49:21','',''),(2588209,'19','199','1023',467,'Retail Sale Id 1587479',3240.00,0.00,0.00,5.00,677.50,'2022-01-23 16:49:21','',''),(2588234,'19','199','1023',467,'Retail Sale Id 1587506',3564.00,0.00,0.00,5.50,745.25,'2022-01-23 16:52:05','',''),(2588298,'19','199','1023',467,'Retail Sale Id 1587564',8100.00,0.00,0.00,12.50,1693.75,'2022-01-23 16:59:14','',''),(2588470,'19','199','1023',467,'Retail Sale Id 1587734',3240.00,0.00,0.00,5.00,677.50,'2022-01-23 17:15:54','',''),(2588528,'19','199','1023',467,'Retail Sale Id 1587784',3240.00,0.00,0.00,5.00,677.50,'2022-01-23 17:19:54','',''),(2588875,'19','199','1023',467,'Retail Sale Id 1588035',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 17:41:59','',''),(2588928,'19','199','1023',467,'Retail Sale Id 1588108',2592.00,0.00,0.00,4.00,542.00,'2022-01-23 17:47:18','',''),(2588950,'19','199','1023',467,'Retail Sale Id 1588137',8100.00,0.00,0.00,12.50,1693.75,'2022-01-23 17:49:07','',''),(2588978,'19','199','1023',467,'Retail Sale Id 1588165',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 17:51:35','',''),(2589089,'19','199','1023',467,'Retail Sale Id 1588275',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 18:02:54','',''),(2589090,'19','199','1023',467,'Retail Sale Id 1588275',1944.00,0.00,0.00,3.00,406.50,'2022-01-23 18:02:54','',''),(2590625,'19','199','1023',467,'Retail Sale Id 1589232',1944.00,0.00,0.00,3.00,406.50,'2022-01-24 08:36:49','',''),(2590702,'19','199','1023',467,'Retail Sale Id 1589324',1944.00,0.00,0.00,3.00,406.50,'2022-01-24 08:47:43','',''),(2590981,'19','199','1023',467,'Retail Sale Id 1589599',1944.00,0.00,0.00,3.00,406.50,'2022-01-24 09:25:36','',''),(2590990,'19','199','1023',467,'Retail Sale Id 1589608',1944.00,0.00,0.00,3.00,406.50,'2022-01-24 09:27:06','',''),(2591226,'19','199','1023',467,'Retail Sale Id 1589683',8100.00,0.00,0.00,12.50,1693.75,'2022-01-24 09:39:35','',''),(2591494,'19','199','1023',467,'Retail Sale Id 1589917',8100.00,0.00,0.00,12.50,1693.75,'2022-01-24 10:08:57','',''),(2591509,'19','199','1023',467,'Retail Sale Id 1589929',4050.00,0.00,0.00,6.25,846.88,'2022-01-24 10:11:01','',''),(2591553,'19','199','1023',467,'Retail Sale Id 1589977',8100.00,0.00,0.00,12.50,1693.75,'2022-01-24 10:17:55','',''),(2592149,'19','199','1023',467,'Retail Sale Id 1590485',1944.00,0.00,0.00,3.00,406.50,'2022-01-24 11:18:41','',''),(2592167,'19','199','1023',467,'Retail Sale Id 1590500',1944.00,0.00,0.00,3.00,406.50,'2022-01-24 11:19:44','',''),(2592316,'19','199','1023',467,'Retail Sale Id 1590650',3888.00,0.00,0.00,6.00,813.00,'2022-01-24 11:37:18','',''),(2592596,'19','199','1023',467,'Retail Sale Id 1590918',3564.00,0.00,0.00,5.50,745.25,'2022-01-24 12:09:40','',''),(2592665,'19','199','1023',467,'Retail Sale Id 1590985',8100.00,0.00,0.00,12.50,1693.75,'2022-01-24 12:17:42','',''),(2592693,'19','199','1023',467,'Retail Sale Id 1591014',8100.00,0.00,0.00,12.50,1693.75,'2022-01-24 12:20:37','',''),(2592705,'19','199','1023',467,'Retail Sale Id 1591027',1944.00,0.00,0.00,3.00,406.50,'2022-01-24 12:21:57','',''),(2592745,'19','199','1023',467,'Retail Sale Id 1591066',8100.00,0.00,0.00,12.50,1693.75,'2022-01-24 12:27:03','',''),(2592962,'19','199','1023',467,'Retail Sale Id 1591261',4050.00,0.00,0.00,6.25,846.88,'2022-01-24 12:55:21','',''),(2592975,'19','199','1023',467,'Retail Sale Id 1591274',1944.00,0.00,0.00,3.00,406.50,'2022-01-24 12:56:35','',''),(2593263,'19','199','1023',467,'Retail Sale Id 1591527',2592.00,0.00,0.00,4.00,542.00,'2022-01-24 13:27:36','',''),(2593273,'19','199','1023',467,'Retail Sale Id 1591536',1944.00,0.00,0.00,3.00,406.50,'2022-01-24 13:29:22','',''),(2593274,'19','199','1023',467,'Retail Sale Id 1591536',1944.00,0.00,0.00,3.00,406.50,'2022-01-24 13:29:22','',''),(2593285,'19','199','1023',467,'Retail Sale Id 1591547',8100.00,0.00,0.00,12.50,1693.75,'2022-01-24 13:31:23','',''),(2593423,'19','199','1023',467,'Retail Sale Id 1591665',3888.00,0.00,0.00,6.00,813.00,'2022-01-24 13:46:14','',''),(2593499,'19','199','1023',467,'Retail Sale Id 1591744',2592.00,0.00,0.00,4.00,542.00,'2022-01-24 13:54:52','',''),(2593500,'19','199','1023',467,'Retail Sale Id 1591744',8100.00,0.00,0.00,12.50,1693.75,'2022-01-24 13:54:52','',''),(2593600,'19','199','1023',467,'Retail Sale Id 1591841',4050.00,0.00,0.00,6.25,846.88,'2022-01-24 14:06:03','',''),(2593681,'19','199','1023',467,'Retail Sale Id 1591938',3240.00,0.00,0.00,5.00,677.50,'2022-01-24 14:14:28','',''),(2593704,'19','199','1023',467,'Retail Sale Id 1591957',2592.00,0.00,0.00,4.00,542.00,'2022-01-24 14:16:54','',''),(2593758,'19','199','1023',467,'Retail Sale Id 1592002',1944.00,0.00,0.00,3.00,406.50,'2022-01-24 14:24:13','',''),(2593934,'19','199','1023',467,'Retail Sale Id 1592199',3888.00,0.00,0.00,6.00,813.00,'2022-01-24 14:41:48','',''),(2594063,'19','199','1023',467,'Retail Sale Id 1592279',4050.00,0.00,0.00,6.25,846.88,'2022-01-24 14:52:38','',''),(2594235,'19','199','1023',467,'Retail Sale Id 1592388',1944.00,0.00,0.00,3.00,406.50,'2022-01-24 15:05:38','',''),(2594345,'19','199','1023',467,'Retail Sale Id 1592462',8100.00,0.00,0.00,12.50,1693.75,'2022-01-24 15:14:05','',''),(2594634,'19','199','1023',467,'Retail Sale Id 1592699',3888.00,0.00,0.00,6.00,813.00,'2022-01-24 15:36:18','',''),(2594684,'19','199','1023',467,'Retail Sale Id 1592762',3240.00,0.00,0.00,5.00,677.50,'2022-01-24 15:41:12','',''),(2594829,'19','199','1023',467,'Retail Sale Id 1592909',6480.00,0.00,0.00,10.00,1355.00,'2022-01-24 15:56:37','',''),(2594830,'19','199','1023',467,'Retail Sale Id 1592909',8100.00,0.00,0.00,12.50,1693.75,'2022-01-24 15:56:37','',''),(2594916,'19','199','1023',467,'Retail Sale Id 1593006',3240.00,0.00,0.00,5.00,677.50,'2022-01-24 16:05:38','',''),(2594938,'19','199','1023',467,'Retail Sale Id 1593029',15552.00,0.00,0.00,24.00,3252.00,'2022-01-24 16:08:25','',''),(2595070,'19','199','1023',467,'Retail Sale Id 1593182',1944.00,0.00,0.00,3.00,406.50,'2022-01-24 16:22:18','',''),(2595141,'19','199','1023',467,'Retail Sale Id 1593282',3240.00,0.00,0.00,5.00,677.50,'2022-01-24 16:30:20','',''),(2595156,'19','199','1023',467,'Retail Sale Id 1593314',1944.00,0.00,0.00,3.00,406.50,'2022-01-24 16:31:58','',''),(2595223,'19','199','1023',467,'Retail Sale Id 1593462',8100.00,0.00,0.00,12.50,1693.75,'2022-01-24 16:40:25','',''),(2595242,'19','199','1023',467,'Retail Sale Id 1593510',1944.00,0.00,0.00,3.00,406.50,'2022-01-24 16:44:29','',''),(2595268,'19','199','1023',467,'Retail Sale Id 1593579',1944.00,0.00,0.00,3.00,406.50,'2022-01-24 16:49:19','',''),(2595269,'19','199','1023',467,'Retail Sale Id 1593579',6480.00,0.00,0.00,10.00,1355.00,'2022-01-24 16:49:19','',''),(2595280,'19','199','1023',467,'Retail Sale Id 1593612',1944.00,0.00,0.00,3.00,406.50,'2022-01-24 16:51:28','',''),(2595327,'19','199','1023',467,'Retail Sale Id 1593745',3888.00,0.00,0.00,6.00,813.00,'2022-01-24 16:59:37','',''),(2595406,'19','199','1023',467,'Retail Sale Id 1593898',3888.00,0.00,0.00,6.00,813.00,'2022-01-24 17:09:45','',''),(2595407,'19','199','1023',467,'Retail Sale Id 1593898',8100.00,0.00,0.00,12.50,1693.75,'2022-01-24 17:09:45','',''),(2595420,'19','199','1023',467,'Retail Sale Id 1593928',1944.00,0.00,0.00,3.00,406.50,'2022-01-24 17:12:11','',''),(2595432,'19','199','1023',467,'Retail Sale Id 1593937',1944.00,0.00,0.00,3.00,406.50,'2022-01-24 17:13:38','',''),(2595578,'19','199','1023',467,'Retail Sale Id 1594083',3240.00,0.00,0.00,5.00,677.50,'2022-01-24 17:26:39','',''),(2595579,'19','199','1023',467,'Retail Sale Id 1594083',8100.00,0.00,0.00,12.50,1693.75,'2022-01-24 17:26:39','',''),(2595617,'19','199','1023',467,'Retail Sale Id 1594116',3240.00,0.00,0.00,5.00,677.50,'2022-01-24 17:28:59','',''),(2595792,'19','199','1023',467,'Retail Sale Id 1594260',3888.00,0.00,0.00,6.00,813.00,'2022-01-24 17:41:40','',''),(2595815,'19','199','1023',467,'Retail Sale Id 1594281',8100.00,0.00,0.00,12.50,1693.75,'2022-01-24 17:43:38','',''),(2595868,'19','199','1023',467,'Retail Sale Id 1594335',4050.00,0.00,0.00,6.25,846.88,'2022-01-24 17:48:53','',''),(2597686,'19','199','1023',467,'Retail Sale Id 1595743',3888.00,0.00,0.00,6.00,813.00,'2022-01-25 08:30:07','',''),(2597738,'19','199','1023',467,'Retail Sale Id 1595770',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 08:33:00','',''),(2597769,'19','199','1023',467,'Retail Sale Id 1595797',3888.00,0.00,0.00,6.00,813.00,'2022-01-25 08:35:37','',''),(2597807,'19','199','1023',467,'Retail Sale Id 1595823',8100.00,0.00,0.00,12.50,1693.75,'2022-01-25 08:38:13','',''),(2597980,'19','199','1023',467,'Retail Sale Id 1596051',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 08:56:05','',''),(2598301,'19','199','1023',467,'Retail Sale Id 1596341',8100.00,0.00,0.00,12.50,1693.75,'2022-01-25 09:22:05','',''),(2598538,'19','199','1023',467,'Retail Sale Id 1596594',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 09:43:43','',''),(2598888,'19','199','1023',467,'Retail Sale Id 1596898',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 10:16:05','',''),(2598916,'19','199','1023',467,'Retail Sale Id 1596936',3240.00,0.00,0.00,5.00,677.50,'2022-01-25 10:19:40','',''),(2598917,'19','199','1023',467,'Retail Sale Id 1596936',8100.00,0.00,0.00,12.50,1693.75,'2022-01-25 10:19:40','',''),(2599013,'19','199','1023',467,'Retail Sale Id 1597048',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 10:30:28','',''),(2599014,'19','199','1023',467,'Retail Sale Id 1597048',3888.00,0.00,0.00,6.00,813.00,'2022-01-25 10:30:28','',''),(2599299,'19','199','1023',467,'Retail Sale Id 1597316',3240.00,0.00,0.00,5.00,677.50,'2022-01-25 10:56:04','',''),(2599311,'19','199','1023',467,'Retail Sale Id 1597334',8100.00,0.00,0.00,12.50,1693.75,'2022-01-25 10:58:06','',''),(2599430,'19','199','1023',467,'Retail Sale Id 1597426',8100.00,0.00,0.00,12.50,1693.75,'2022-01-25 11:06:42','',''),(2599660,'19','199','1023',467,'Retail Sale Id 1597645',8100.00,0.00,0.00,12.50,1693.75,'2022-01-25 11:28:27','',''),(2599707,'19','199','1023',467,'Retail Sale Id 1597696',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 11:35:12','',''),(2599753,'19','199','1023',467,'Retail Sale Id 1597769',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 11:40:45','',''),(2599754,'19','199','1023',467,'Retail Sale Id 1597769',3888.00,0.00,0.00,6.00,813.00,'2022-01-25 11:40:45','',''),(2599831,'19','199','1023',467,'Retail Sale Id 1597812',8100.00,0.00,0.00,12.50,1693.75,'2022-01-25 11:44:18','',''),(2599984,'19','199','1023',467,'Retail Sale Id 1597924',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 11:55:25','',''),(2600002,'19','199','1023',467,'Retail Sale Id 1597941',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 11:57:32','',''),(2600038,'19','199','1023',467,'Retail Sale Id 1597977',5184.00,0.00,0.00,8.00,1084.00,'2022-01-25 12:01:46','',''),(2600254,'19','199','1023',467,'Retail Sale Id 1598221',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 12:28:26','',''),(2600444,'19','199','1023',467,'Retail Sale Id 1598441',3240.00,0.00,0.00,5.00,677.50,'2022-01-25 12:50:14','',''),(2600473,'19','199','1023',467,'Retail Sale Id 1598465',8100.00,0.00,0.00,12.50,1693.75,'2022-01-25 12:52:09','',''),(2600633,'19','199','1023',467,'Retail Sale Id 1598644',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 13:09:29','',''),(2600694,'19','199','1023',467,'Retail Sale Id 1598687',8100.00,0.00,0.00,12.50,1693.75,'2022-01-25 13:15:01','',''),(2600993,'19','199','1023',467,'Retail Sale Id 1598940',8100.00,0.00,0.00,12.50,1693.75,'2022-01-25 13:43:24','',''),(2601607,'19','199','1023',467,'Retail Sale Id 1599503',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 14:48:57','',''),(2601994,'19','199','1023',467,'Retail Sale Id 1599965',3240.00,0.00,0.00,5.00,677.50,'2022-01-25 15:21:44','',''),(2602096,'19','199','1023',467,'Retail Sale Id 1600062',7776.00,0.00,0.00,12.00,1626.00,'2022-01-25 15:30:52','',''),(2602126,'19','199','1023',467,'Retail Sale Id 1600095',8100.00,0.00,0.00,12.50,1693.75,'2022-01-25 15:33:37','',''),(2602149,'19','199','1023',467,'Retail Sale Id 1600109',8100.00,0.00,0.00,12.50,1693.75,'2022-01-25 15:35:21','',''),(2602299,'19','199','1023',467,'Retail Sale Id 1600195',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 15:43:52','',''),(2602300,'19','199','1023',467,'Retail Sale Id 1600195',8100.00,0.00,0.00,12.50,1693.75,'2022-01-25 15:43:52','',''),(2602336,'19','199','1023',467,'Retail Sale Id 1600227',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 15:46:00','',''),(2602543,'19','199','1023',467,'Retail Sale Id 1600358',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 15:57:03','',''),(2602569,'19','199','1023',467,'Retail Sale Id 1600387',3888.00,0.00,0.00,6.00,813.00,'2022-01-25 15:59:47','',''),(2602600,'19','199','1023',467,'Retail Sale Id 1600461',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 16:02:49','',''),(2602945,'19','199','1023',467,'Retail Sale Id 1600750',4050.00,0.00,0.00,6.25,846.88,'2022-01-25 16:29:37','',''),(2602975,'19','199','1023',467,'Retail Sale Id 1600788',3240.00,0.00,0.00,5.00,677.50,'2022-01-25 16:32:18','',''),(2603102,'19','199','1023',467,'Retail Sale Id 1600923',3240.00,0.00,0.00,5.00,677.50,'2022-01-25 16:41:59','',''),(2603275,'19','199','1023',467,'Retail Sale Id 1601022',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 16:50:46','',''),(2603276,'19','199','1023',467,'Retail Sale Id 1601022',8100.00,0.00,0.00,12.50,1693.75,'2022-01-25 16:50:46','',''),(2603363,'19','199','1023',467,'Retail Sale Id 1601147',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 16:57:14','',''),(2603687,'19','199','1023',467,'Retail Sale Id 1601467',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 17:21:14','',''),(2603700,'19','199','1023',467,'Retail Sale Id 1601484',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 17:22:30','',''),(2603701,'19','199','1023',467,'Retail Sale Id 1601484',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 17:22:30','',''),(2603866,'19','199','1023',467,'Retail Sale Id 1601682',8100.00,0.00,0.00,12.50,1693.75,'2022-01-25 17:36:26','',''),(2604076,'19','199','1023',467,'Retail Sale Id 1601902',3888.00,0.00,0.00,6.00,813.00,'2022-01-25 17:50:57','',''),(2604147,'19','199','1023',467,'Retail Sale Id 1601951',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 17:55:12','',''),(2604190,'19','199','1023',467,'Retail Sale Id 1601998',1944.00,0.00,0.00,3.00,406.50,'2022-01-25 17:58:40','',''),(2606313,'19','199','1023',467,'Retail Sale Id 1603512',7128.00,0.00,0.00,11.00,1490.50,'2022-01-26 08:21:47','',''),(2606424,'19','199','1023',467,'Retail Sale Id 1603614',1944.00,0.00,0.00,3.00,406.50,'2022-01-26 08:32:14','',''),(2606642,'19','199','1023',467,'Retail Sale Id 1603834',4050.00,0.00,0.00,6.25,846.88,'2022-01-26 08:56:45','',''),(2606665,'19','199','1023',467,'Retail Sale Id 1603859',2916.00,0.00,0.00,4.50,609.75,'2022-01-26 08:59:34','',''),(2606912,'19','199','1023',467,'Retail Sale Id 1604060',8100.00,0.00,0.00,12.50,1693.75,'2022-01-26 09:20:45','',''),(2607436,'19','199','1023',467,'Retail Sale Id 1604561',1944.00,0.00,0.00,3.00,406.50,'2022-01-26 10:08:07','',''),(2607480,'19','199','1023',467,'Retail Sale Id 1604625',1944.00,0.00,0.00,3.00,406.50,'2022-01-26 10:13:37','',''),(2607615,'19','199','1023',467,'Retail Sale Id 1604731',1944.00,0.00,0.00,3.00,406.50,'2022-01-26 10:24:54','',''),(2607641,'19','199','1023',467,'Retail Sale Id 1604749',2592.00,0.00,0.00,4.00,542.00,'2022-01-26 10:26:21','',''),(2607738,'19','199','1023',467,'Retail Sale Id 1604818',3888.00,0.00,0.00,6.00,813.00,'2022-01-26 10:34:16','',''),(2607739,'19','199','1023',467,'Retail Sale Id 1604818',8100.00,0.00,0.00,12.50,1693.75,'2022-01-26 10:34:16','',''),(2607792,'19','199','1023',467,'Retail Sale Id 1604858',1944.00,0.00,0.00,3.00,406.50,'2022-01-26 10:41:45','',''),(2607821,'19','199','1023',467,'Retail Sale Id 1604887',1944.00,0.00,0.00,3.00,406.50,'2022-01-26 10:46:41','',''),(2607822,'19','199','1023',467,'Retail Sale Id 1604887',8100.00,0.00,0.00,12.50,1693.75,'2022-01-26 10:46:41','',''),(2607839,'19','199','1023',467,'Retail Sale Id 1604905',4536.00,0.00,0.00,7.00,948.50,'2022-01-26 10:48:42','',''),(2607880,'19','199','1023',467,'Retail Sale Id 1604948',1944.00,0.00,0.00,3.00,406.50,'2022-01-26 10:55:16','',''),(2608131,'19','199','1023',467,'Retail Sale Id 1605236',8100.00,0.00,0.00,12.50,1693.75,'2022-01-26 11:21:49','',''),(2608178,'19','199','1023',467,'Retail Sale Id 1605287',4050.00,0.00,0.00,6.25,846.88,'2022-01-26 11:26:56','',''),(2608330,'19','199','1023',467,'Retail Sale Id 1605455',1944.00,0.00,0.00,3.00,406.50,'2022-01-26 11:41:55','',''),(2608341,'19','199','1023',467,'Retail Sale Id 1605468',1944.00,0.00,0.00,3.00,406.50,'2022-01-26 11:43:28','',''),(2608419,'19','199','1023',467,'Retail Sale Id 1605570',1944.00,0.00,0.00,3.00,406.50,'2022-01-26 11:52:44','',''),(2608468,'19','199','1023',467,'Retail Sale Id 1605625',7776.00,0.00,0.00,12.00,1626.00,'2022-01-26 11:56:40','',''),(2608500,'19','199','1023',467,'Retail Sale Id 1605676',3888.00,0.00,0.00,6.00,813.00,'2022-01-26 12:00:14','',''),(2608501,'19','199','1023',467,'Retail Sale Id 1605676',8100.00,0.00,0.00,12.50,1693.75,'2022-01-26 12:00:14','',''),(2608544,'19','199','1023',467,'Retail Sale Id 1605746',7776.00,0.00,0.00,12.00,1626.00,'2022-01-26 12:06:42','',''),(2608596,'19','199','1023',467,'Retail Sale Id 1605873',8100.00,0.00,0.00,12.50,1693.75,'2022-01-26 12:13:43','',''),(2608680,'19','199','1023',467,'Retail Sale Id 1606058',5184.00,0.00,0.00,8.00,1084.00,'2022-01-26 12:25:16','',''),(2608795,'19','199','1023',467,'Retail Sale Id 1606154',1944.00,0.00,0.00,3.00,406.50,'2022-01-26 12:36:11','',''),(2608836,'19','199','1023',467,'Retail Sale Id 1606223',8100.00,0.00,0.00,12.50,1693.75,'2022-01-26 12:43:02','',''),(2608862,'19','199','1023',467,'Retail Sale Id 1606254',1944.00,0.00,0.00,3.00,406.50,'2022-01-26 12:45:10','',''),(2608893,'19','199','1023',467,'Retail Sale Id 1606287',1944.00,0.00,0.00,3.00,406.50,'2022-01-26 12:49:42','',''),(2608935,'19','199','1023',467,'Retail Sale Id 1606417',1944.00,0.00,0.00,3.00,406.50,'2022-01-26 12:58:58','',''),(2608950,'19','199','1023',467,'Retail Sale Id 1606431',4050.00,0.00,0.00,6.25,846.88,'2022-01-26 13:01:20','',''),(2609036,'19','199','1023',467,'Retail Sale Id 1606522',1944.00,0.00,0.00,3.00,406.50,'2022-01-26 13:10:17','',''),(2609046,'19','199','1023',467,'Retail Sale Id 1606531',8100.00,0.00,0.00,12.50,1693.75,'2022-01-26 13:11:26','',''),(2609154,'19','199','1023',467,'Retail Sale Id 1606637',8100.00,0.00,0.00,12.50,1693.75,'2022-01-26 13:23:31','',''),(2609233,'19','199','1023',467,'Retail Sale Id 1606702',3888.00,0.00,0.00,6.00,813.00,'2022-01-26 13:34:11','',''),(2609278,'19','199','1023',467,'Retail Sale Id 1606740',8100.00,0.00,0.00,12.50,1693.75,'2022-01-26 13:40:14','',''),(2609458,'19','199','1023',467,'Retail Sale Id 1606912',3888.00,0.00,0.00,6.00,813.00,'2022-01-26 14:02:23','',''),(2609683,'19','199','1023',467,'Retail Sale Id 1607267',8100.00,0.00,0.00,12.50,1693.75,'2022-01-26 14:34:46','',''),(2609857,'19','199','1023',467,'Retail Sale Id 1607593',12960.00,0.00,0.00,20.00,2710.00,'2022-01-26 15:03:37','',''),(2609942,'19','199','1023',467,'Retail Sale Id 1607690',8100.00,0.00,0.00,12.50,1693.75,'2022-01-26 15:18:55','',''),(2609943,'19','199','1023',467,'Retail Sale Id 1607690',8100.00,0.00,0.00,12.50,1693.75,'2022-01-26 15:18:55','',''),(2610020,'19','199','1023',467,'Retail Sale Id 1607727',2916.00,0.00,0.00,4.50,609.75,'2022-01-26 15:23:40','',''),(2610047,'19','199','1023',467,'Retail Sale Id 1607743',2592.00,0.00,0.00,4.00,542.00,'2022-01-26 15:26:02','',''),(2610064,'19','199','1023',467,'Retail Sale Id 1607766',2592.00,0.00,0.00,4.00,542.00,'2022-01-26 15:28:36','',''),(2610077,'19','199','1023',467,'Retail Sale Id 1607823',1944.00,0.00,0.00,3.00,406.50,'2022-01-26 15:31:25','',''),(2610166,'19','199','1023',467,'Retail Sale Id 1607928',1944.00,0.00,0.00,3.00,406.50,'2022-01-26 15:44:20','',''),(2610244,'19','199','1023',467,'Retail Sale Id 1608003',8100.00,0.00,0.00,12.50,1693.75,'2022-01-26 15:51:13','',''),(2610293,'19','199','1023',467,'Retail Sale Id 1608041',4050.00,0.00,0.00,6.25,846.88,'2022-01-26 15:54:25','',''),(2610325,'19','199','1023',467,'Retail Sale Id 1608076',4536.00,0.00,0.00,7.00,948.50,'2022-01-26 15:57:13','',''),(2610424,'19','199','1023',467,'Retail Sale Id 1608181',8100.00,0.00,0.00,12.50,1693.75,'2022-01-26 16:07:37','',''),(2611022,'19','199','1023',467,'Retail Sale Id 1608794',4050.00,0.00,0.00,6.25,846.88,'2022-01-26 17:02:17','',''),(2611231,'19','199','1023',467,'Retail Sale Id 1609051',4050.00,0.00,0.00,6.25,846.88,'2022-01-26 17:18:32','',''),(2611249,'19','199','1023',467,'Retail Sale Id 1609070',1944.00,0.00,0.00,3.00,406.50,'2022-01-26 17:20:18','',''),(2611501,'19','199','1023',467,'Retail Sale Id 1609333',1944.00,0.00,0.00,3.00,406.50,'2022-01-26 17:37:23','',''),(2611502,'19','199','1023',467,'Retail Sale Id 1609333',8100.00,0.00,0.00,12.50,1693.75,'2022-01-26 17:37:23','',''),(2611536,'19','199','1023',467,'Retail Sale Id 1609369',4050.00,0.00,0.00,6.25,846.88,'2022-01-26 17:40:34','',''),(2611565,'19','199','1023',467,'Retail Sale Id 1609403',8100.00,0.00,0.00,12.50,1693.75,'2022-01-26 17:42:18','',''),(2611701,'19','199','1023',467,'Retail Sale Id 1609523',4050.00,0.00,0.00,6.25,846.88,'2022-01-26 17:52:20','',''),(2613146,'19','199',NULL,467,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613344,'19','199','1024',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613638,'19','199','1023',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2614913,'19','199','1023',467,'Retail Sale Id 1611004',3240.00,0.00,0.00,5.00,677.50,'2022-01-27 08:39:21','',''),(2614914,'19','199','1023',467,'Retail Sale Id 1611004',8100.00,0.00,0.00,12.50,1693.75,'2022-01-27 08:39:21','',''),(2615092,'19','199','1023',467,'Retail Sale Id 1611119',1944.00,0.00,0.00,3.00,406.50,'2022-01-27 08:48:42','',''),(2615142,'19','199','1023',467,'Retail Sale Id 1611156',2592.00,0.00,0.00,4.00,542.00,'2022-01-27 08:52:21','',''),(2615261,'19','199','1023',467,'Return of Retail Sale Id 1611004',0.00,3240.00,5.00,0.00,-677.50,'2022-01-27 09:04:48','',''),(2615262,'19','199','1023',467,'Return of Retail Sale Id 1611004',0.00,8100.00,12.50,0.00,-1693.75,'2022-01-27 09:04:48','',''),(2615291,'19','199','1023',467,'Retail Sale Id 1611292',3240.00,0.00,0.00,5.00,677.50,'2022-01-27 09:08:05','',''),(2615292,'19','199','1023',467,'Retail Sale Id 1611292',8100.00,0.00,0.00,12.50,1693.75,'2022-01-27 09:08:05','',''),(2615336,'19','199','1023',467,'Retail Sale Id 1611342',1944.00,0.00,0.00,3.00,406.50,'2022-01-27 09:12:18','',''),(2615868,'19','199','1023',467,'Retail Sale Id 1611795',3240.00,0.00,0.00,5.00,677.50,'2022-01-27 09:57:13','',''),(2616125,'19','199','1023',467,'Retail Sale Id 1611985',4536.00,0.00,0.00,7.00,948.50,'2022-01-27 10:15:41','',''),(2616126,'19','199','1023',467,'Retail Sale Id 1611985',4536.00,0.00,0.00,7.00,948.50,'2022-01-27 10:15:41','',''),(2616176,'19','199','1023',467,'Retail Sale Id 1612029',3888.00,0.00,0.00,6.00,813.00,'2022-01-27 10:19:16','',''),(2616194,'19','199','1023',467,'Retail Sale Id 1612049',4536.00,0.00,0.00,7.00,948.50,'2022-01-27 10:21:34','',''),(2616386,'19','199','1023',467,'Retail Sale Id 1612189',1944.00,0.00,0.00,3.00,406.50,'2022-01-27 10:34:16','',''),(2616818,'19','199','1023',467,'Retail Sale Id 1612562',1944.00,0.00,0.00,3.00,406.50,'2022-01-27 11:11:27','',''),(2617160,'19','199','1023',467,'Retail Sale Id 1612873',8100.00,0.00,0.00,12.50,1693.75,'2022-01-27 11:42:59','',''),(2617196,'19','199','1023',467,'Retail Sale Id 1612909',4050.00,0.00,0.00,6.25,846.88,'2022-01-27 11:46:51','',''),(2617214,'19','199','1023',467,'Retail Sale Id 1612927',1944.00,0.00,0.00,3.00,406.50,'2022-01-27 11:48:42','',''),(2617376,'19','199','1023',467,'Retail Sale Id 1613086',3240.00,0.00,0.00,5.00,677.50,'2022-01-27 12:05:48','',''),(2617454,'19','199','1023',467,'Retail Sale Id 1613156',1944.00,0.00,0.00,3.00,406.50,'2022-01-27 12:13:52','',''),(2617671,'19','199','1023',467,'Retail Sale Id 1613355',8100.00,0.00,0.00,12.50,1693.75,'2022-01-27 12:35:50','',''),(2617714,'19','199','1023',467,'Retail Sale Id 1613405',8100.00,0.00,0.00,12.50,1693.75,'2022-01-27 12:39:14','',''),(2617891,'19','199','1023',467,'Retail Sale Id 1613583',8100.00,0.00,0.00,12.50,1693.75,'2022-01-27 12:58:40','',''),(2617920,'19','199','1023',467,'Retail Sale Id 1613616',2916.00,0.00,0.00,4.50,609.75,'2022-01-27 13:03:17','',''),(2618021,'19','199','1023',467,'Retail Sale Id 1613710',1944.00,0.00,0.00,3.00,406.50,'2022-01-27 13:16:28','',''),(2618050,'19','199','1023',467,'Retail Sale Id 1613734',1944.00,0.00,0.00,3.00,406.50,'2022-01-27 13:19:32','',''),(2618062,'19','199','1023',467,'Retail Sale Id 1613752',8100.00,0.00,0.00,12.50,1693.75,'2022-01-27 13:21:21','',''),(2618075,'19','199','1023',467,'Retail Sale Id 1613773',1944.00,0.00,0.00,3.00,406.50,'2022-01-27 13:23:11','',''),(2618234,'19','199','1023',467,'Retail Sale Id 1613916',8100.00,0.00,0.00,12.50,1693.75,'2022-01-27 13:39:13','',''),(2619012,'19','199','1023',467,'Retail Sale Id 1614575',5184.00,0.00,0.00,8.00,1084.00,'2022-01-27 14:56:11','',''),(2619024,'19','199','1023',467,'Retail Sale Id 1614586',4212.00,0.00,0.00,6.50,880.75,'2022-01-27 14:58:23','',''),(2619101,'19','199','1023',467,'Retail Sale Id 1614658',1944.00,0.00,0.00,3.00,406.50,'2022-01-27 15:05:20','',''),(2619212,'19','199','1023',467,'Retail Sale Id 1614733',2592.00,0.00,0.00,4.00,542.00,'2022-01-27 15:18:06','',''),(2619234,'19','199','1023',467,'Retail Sale Id 1614800',8100.00,0.00,0.00,12.50,1693.75,'2022-01-27 15:20:01','',''),(2619267,'19','199','1023',467,'Retail Sale Id 1614826',1944.00,0.00,0.00,3.00,406.50,'2022-01-27 15:22:43','',''),(2619334,'19','199','1023',467,'Retail Sale Id 1614893',4050.00,0.00,0.00,6.25,846.88,'2022-01-27 15:28:17','',''),(2619924,'19','199','1023',467,'Retail Sale Id 1615416',4050.00,0.00,0.00,6.25,846.88,'2022-01-27 16:15:17','',''),(2620011,'19','199','1023',467,'Retail Sale Id 1615458',1944.00,0.00,0.00,3.00,406.50,'2022-01-27 16:19:28','',''),(2620050,'19','199','1023',467,'Retail Sale Id 1615500',8100.00,0.00,0.00,12.50,1693.75,'2022-01-27 16:23:17','',''),(2620195,'19','199','1023',467,'Retail Sale Id 1615612',1944.00,0.00,0.00,3.00,406.50,'2022-01-27 16:32:57','',''),(2620226,'19','199','1023',467,'Retail Sale Id 1615641',3240.00,0.00,0.00,5.00,677.50,'2022-01-27 16:35:10','',''),(2620347,'19','199','1023',467,'Retail Sale Id 1615742',8100.00,0.00,0.00,12.50,1693.75,'2022-01-27 16:42:35','',''),(2620428,'19','199','1023',467,'Retail Sale Id 1615815',1944.00,0.00,0.00,3.00,406.50,'2022-01-27 16:48:52','',''),(2620429,'19','199','1023',467,'Retail Sale Id 1615815',3888.00,0.00,0.00,6.00,813.00,'2022-01-27 16:48:52','',''),(2620464,'19','199','1023',467,'Retail Sale Id 1615844',2592.00,0.00,0.00,4.00,542.00,'2022-01-27 16:51:11','',''),(2620630,'19','199','1023',467,'Retail Sale Id 1615984',8100.00,0.00,0.00,12.50,1693.75,'2022-01-27 17:01:07','',''),(2620671,'19','199','1023',467,'Retail Sale Id 1616025',1944.00,0.00,0.00,3.00,406.50,'2022-01-27 17:04:24','',''),(2620742,'19','199','1023',467,'Retail Sale Id 1616096',1944.00,0.00,0.00,3.00,406.50,'2022-01-27 17:09:28','',''),(2620810,'19','199','1023',467,'Retail Sale Id 1616158',3240.00,0.00,0.00,5.00,677.50,'2022-01-27 17:13:19','',''),(2620883,'19','199','1023',467,'Retail Sale Id 1616225',8100.00,0.00,0.00,12.50,1693.75,'2022-01-27 17:18:20','',''),(2620923,'19','199','1023',467,'Retail Sale Id 1616269',1944.00,0.00,0.00,3.00,406.50,'2022-01-27 17:21:10','',''),(2621031,'19','199','1023',467,'Retail Sale Id 1616371',1944.00,0.00,0.00,3.00,406.50,'2022-01-27 17:28:25','',''),(2623664,'19','199','1023',467,'Retail Sale Id 1618142',4050.00,0.00,0.00,6.25,846.88,'2022-01-28 08:37:04','',''),(2623844,'19','199','1023',467,'Retail Sale Id 1618435',1944.00,0.00,0.00,3.00,406.50,'2022-01-28 08:54:14','',''),(2624073,'19','199','1023',467,'Retail Sale Id 1618589',8100.00,0.00,0.00,12.50,1693.75,'2022-01-28 09:09:01','',''),(2624232,'19','199','1023',467,'Retail Sale Id 1618719',1944.00,0.00,0.00,3.00,406.50,'2022-01-28 09:20:44','',''),(2624318,'19','199','1023',467,'Retail Sale Id 1618806',3240.00,0.00,0.00,5.00,677.50,'2022-01-28 09:29:58','',''),(2624338,'19','199','1023',467,'Retail Sale Id 1618824',1944.00,0.00,0.00,3.00,406.50,'2022-01-28 09:31:35','',''),(2624399,'19','199','1023',467,'Retail Sale Id 1618883',4050.00,0.00,0.00,6.25,846.88,'2022-01-28 09:36:24','',''),(2624426,'19','199','1023',467,'Retail Sale Id 1618910',32400.00,0.00,0.00,50.00,6775.00,'2022-01-28 09:38:59','',''),(2624743,'19','199','1023',467,'Retail Sale Id 1619225',4050.00,0.00,0.00,6.25,846.88,'2022-01-28 10:10:14','',''),(2624874,'19','199','1023',467,'Retail Sale Id 1619321',1944.00,0.00,0.00,3.00,406.50,'2022-01-28 10:18:20','',''),(2625018,'19','199','1023',467,'Retail Sale Id 1619474',6480.00,0.00,0.00,10.00,1355.00,'2022-01-28 10:31:53','',''),(2625305,'19','199','1023',467,'Retail Sale Id 1619734',4050.00,0.00,0.00,6.25,846.88,'2022-01-28 10:55:05','',''),(2625405,'19','199','1023',467,'Retail Sale Id 1619798',4050.00,0.00,0.00,6.25,846.88,'2022-01-28 11:01:23','',''),(2625418,'19','199','1023',467,'Retail Sale Id 1619811',1944.00,0.00,0.00,3.00,406.50,'2022-01-28 11:03:19','',''),(2625470,'19','199','1023',467,'Retail Sale Id 1619854',3888.00,0.00,0.00,6.00,813.00,'2022-01-28 11:07:22','',''),(2625471,'19','199','1023',467,'Retail Sale Id 1619854',8100.00,0.00,0.00,12.50,1693.75,'2022-01-28 11:07:22','',''),(2625659,'19','199','1023',467,'Retail Sale Id 1620057',3240.00,0.00,0.00,5.00,677.50,'2022-01-28 11:24:58','',''),(2625694,'19','199','1023',467,'Retail Sale Id 1620085',5184.00,0.00,0.00,8.00,1084.00,'2022-01-28 11:27:57','',''),(2625928,'19','199','1023',467,'Retail Sale Id 1620324',4536.00,0.00,0.00,7.00,948.50,'2022-01-28 11:46:45','',''),(2626023,'19','199','1023',467,'Retail Sale Id 1620416',8100.00,0.00,0.00,12.50,1693.75,'2022-01-28 11:54:59','',''),(2626126,'19','199','1023',467,'Retail Sale Id 1620524',8100.00,0.00,0.00,12.50,1693.75,'2022-01-28 12:06:16','',''),(2626156,'19','199','1023',467,'Retail Sale Id 1620555',3240.00,0.00,0.00,5.00,677.50,'2022-01-28 12:09:44','',''),(2626225,'19','199','1023',467,'Retail Sale Id 1620628',8100.00,0.00,0.00,12.50,1693.75,'2022-01-28 12:18:26','',''),(2626319,'19','199','1023',467,'Retail Sale Id 1620703',8100.00,0.00,0.00,12.50,1693.75,'2022-01-28 12:25:53','',''),(2626511,'19','199','1023',467,'Retail Sale Id 1620817',4050.00,0.00,0.00,6.25,846.88,'2022-01-28 12:37:02','',''),(2626595,'19','199','1023',467,'Retail Sale Id 1620901',6804.00,0.00,0.00,10.50,1422.75,'2022-01-28 12:47:13','',''),(2626617,'19','199','1023',467,'Retail Sale Id 1620927',3240.00,0.00,0.00,5.00,677.50,'2022-01-28 12:48:58','',''),(2626665,'19','199','1023',467,'Retail Sale Id 1620980',1944.00,0.00,0.00,3.00,406.50,'2022-01-28 12:53:34','',''),(2626688,'19','199','1023',467,'Retail Sale Id 1621008',5184.00,0.00,0.00,8.00,1084.00,'2022-01-28 12:56:15','',''),(2626725,'19','199','1023',467,'Retail Sale Id 1621051',3240.00,0.00,0.00,5.00,677.50,'2022-01-28 13:00:29','',''),(2626726,'19','199','1023',467,'Retail Sale Id 16210