-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_14_station_188
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_14_station_188`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_14_station_188` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_14_station_188`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=4087 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3498,500,'',0,'6.1','14','188','CASH','','2021-07-22 07:07:05',5,0.00,0.00,'','646','2021-07-22 07:07:05','646',0,1),(3499,7000,'',0,'20','14','188','SALES','','2021-07-22 07:07:23',5,0.00,0.00,'','646','2021-07-22 07:07:23','646',0,1),(3500,8000,'',0,'24','14','188','PURCHASES','','2021-07-22 07:07:39',5,0.00,0.00,'','646','2021-07-22 07:07:39','646',0,1),(3501,4000,'',0,'22','14','188','PURCHASES','','2021-07-22 07:08:09',5,0.00,0.00,'','646','2021-07-22 07:08:09','646',0,1),(3502,8001,'',0,'24','14','188','SALARIES & WAGES','','2021-07-22 07:09:38',5,0.00,0.00,'','646','2021-07-22 07:09:38','646',0,1),(4071,2500,'',0,'2','14','188','KEYSSTONE (1005470740)','','2022-01-08 12:34:11',5,0.00,0.00,'','646','2022-01-08 12:34:11','646',0,0),(4079,2504,'',0,'2','14','188','KEYSTONE POS (id: 2082KG24)','','2022-01-17 12:46:50',5,0.00,0.00,'','744','2022-01-17 12:46:50','744',0,0),(4080,2505,'',0,'2','14','188','ACCESS BANK POS( ID:2063302R)','','2022-01-17 12:47:55',5,0.00,0.00,'','744','2022-01-17 12:47:55','744',0,0),(4082,2506,'',0,'2','14','188','GT BANK POS (2058HX45)','','2022-01-17 12:52:04',5,0.00,0.00,'','744','2022-01-17 12:52:04','744',0,0),(4083,2507,'',0,'2','14','188','ZENIITH BANK( 1012422961)','','2022-01-17 12:53:27',5,0.00,0.00,'','744','2022-01-17 12:53:27','744',0,0),(4085,8004,'',0,'24','14','188','AGO CONSUMPTION','','2022-01-18 15:19:16',5,0.00,0.00,'','744','2022-01-18 15:19:16','744',0,0),(4086,2508,'',0,'2','14','188','IBTC BANK (TRANSFER ACC: 92005','','2022-01-18 17:12:16',5,0.00,0.00,'','744','2022-01-18 17:12:16','744',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4197 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (4156,'','14','188','PHCN','JOHN','0058855564','phcn@gmail.com','KADUNA','KADUNA STATE','NO.UI JHI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-08 12:58:35',5,'646','2022-01-08 12:58:35','646'),(4157,'','14','188','MULTIPRO','DAVID','0806669955','david@gmail.com','SHABA','KADUNA','NO/10 AHAMADU BELLO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-08 12:59:23',5,'646','2022-01-08 12:59:23','646'),(4158,'','14','188','CIVIL DEFENCE','amar','080555447','amar@gmail.com','ungwan dosa','kaduna','no.3 ungwan dosa jo','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-08 14:26:11',5,'744','2022-01-18 15:18:31','744'),(4189,'','14','188','AL-ITQAAN ACADEMY','AL-ITQAAN','0000000000','alitqaan@gmail.com','KADUNA STATE','KADUNA','KADUNA STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-18 15:13:35',5,'744','2022-01-18 15:13:35','744'),(4190,'','14','188','OPERATION YAKI','OPERATION YAKI','0000000000','operation@gmail.com','KADUNA STATE','KADUNA','KADUNA STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-18 15:14:18',5,'744','2022-01-18 15:14:18','744'),(4191,'','14','188','NIYYA FARM','NIYYA FARM','0000000000','niyya@gmail.com','KADUNA STATE','KADUNA','KADUNA STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-18 15:15:01',5,'744','2022-01-18 15:15:01','744'),(4192,'','14','188','ARC','ARC','0000000000','arc@gmailcom','KADUNA STATE','KADUNA','KADUNA STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-18 15:15:30',5,'744','2022-01-18 15:15:30','744'),(4193,'','14','188','GARKUWA HOSPITAL','GARKUWA HOSPITAL','0000000000','garkuwa@gmailcom','KADUNA STATE','KADUNA','KADUNA STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-18 15:16:23',5,'744','2022-01-18 15:16:23','744'),(4194,'','14','188','KASTELEA','KASTELEA','0000000000','kastelea@gmail.com','KADUNA STATE','KADUNA','KADUNA STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-18 15:16:58',5,'744','2022-01-18 15:16:58','744'),(4195,'','14','188','CBN','CBN','0000000000','cbn@gmail.com','KADUNA STATE','KADUNA','KADUNA STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-18 15:17:34',5,'744','2022-01-18 15:17:34','744'),(4196,'','14','188','HASHIRU KASU ','HASHIRU KASU','0000000000','hashiru@gmail .com','KADUNA STATE','KADUNA','KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-18 16:00:03',5,'744','2022-01-18 16:00:03','744');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18497 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('14','188',18467,'975',158.52,14800.00,'2022-01-09','','2022-01-17 12:54:50','744','744',2022,'744','2022-01-17 12:54:50',5),('14','188',18468,'976',0.00,1050.00,'2022-01-09','','2022-01-17 12:55:07','744','744',2022,'744','2022-01-17 12:55:07',5),('14','188',18469,'977',0.00,5050.00,'2022-01-09','','2022-01-17 12:55:34','744','744',2022,'744','2022-01-17 12:55:34',5),('14','188',18470,'978',591.38,14950.00,'2022-01-09','','2022-01-17 12:55:49','744','744',2022,'744','2022-01-17 12:55:49',5),('14','188',18471,'979',21496.99,25350.00,'2022-01-09','','2022-01-17 12:56:07','744','744',2022,'744','2022-01-17 12:56:07',5),('14','188',18496,'975',1183.26,9550.00,'2022-01-18','','2022-01-18 15:35:29','744','744',2022,'744','2022-01-18 15:35:29',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2894 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('14','188','975',2882,'5','PMS PUMP 4',1921258.80,'PMS DISPENSER','',NULL,NULL,'',5,'2022-01-08 13:26:15','744'),('14','188','975',2883,'5','PMS PUMP 6',346594.19,'PMS DISPENSER','',NULL,NULL,'',5,'2022-01-17 13:04:38','744'),('14','188','976',2884,'5','PMS PUMP 1',182193.37,'PMS DISPENSER','',NULL,NULL,'',5,'2022-01-17 13:05:14','744'),('14','188','976',2885,'5','PMS PUMP 5',148398.15,'PMS DISPENSER','',NULL,NULL,'',5,'2022-01-17 13:06:04','744'),('14','188','977',2886,'5','PMS PUMP 3',2100353.91,'PMS DISPENSER','',NULL,NULL,'',5,'2022-01-17 13:06:26','744'),('14','188','977',2887,'5','PMS PUMP 8',310275.69,'PMS DISPENSER','',NULL,NULL,'',5,'2022-01-17 13:06:51','744'),('14','188','978',2888,'5','PMS PUMP 2',341619.00,'PMS DISPENSER','',NULL,NULL,'',5,'2022-01-18 16:08:59','744'),('14','188','978',2889,'5','PMS PUMP 7',398451.58,'PMS DISPENSER','',NULL,NULL,'',5,'2022-01-17 13:20:42','744'),('14','188','979',2890,'5','AGO PUMP 1',601680.21,'AGO DISPENSER','',NULL,NULL,'',5,'2022-01-17 13:08:43','744'),('14','188','979',2891,'5','AGO PUMP 2',864972.90,'AGO DISPENSER','',NULL,NULL,'',5,'2022-01-17 13:21:10','744'),('14','188','980',2892,'5','DPK PUMP 1',0.00,'DPK DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('14','188','980',2893,'5','DPK PUMP 2',0.00,'DPK DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`)
) ENGINE=InnoDB AUTO_INCREMENT=254638 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('14','188',252103,'DAILY','2022-01-08','2022-01-08 00:00:00',NULL,'646',82500.00,82500.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1),('14','188',252115,'DAILY','2022-01-08','2022-01-08 00:00:00',NULL,'744',1759670.00,0.00,'744','2022-01-08 13:49:44','744','2022-01-08 13:50:08',10),('14','188',252125,'daily 2','2022-01-08','2022-01-08 00:00:00',NULL,'744',6800.00,6800.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1),('14','188',252141,'daily 3','2022-01-08','2022-01-08 00:00:00',NULL,'744',5150.00,5150.00,'744','2022-01-08 14:45:30','744','2022-01-08 14:45:55',10),('14','188',254310,'DAILY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'744',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1),('14','188',254313,'DAILY SHIFT1','2022-01-09','2022-01-09 00:00:00',NULL,'744',692001.10,692001.10,'744','2022-01-17 13:23:01','744','2022-01-17 13:37:02',10),('14','188',254323,'MORNING SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'744',2472574.60,2472574.60,'744','2022-01-17 13:50:29','744','2022-01-17 15:50:13',10),('14','188',254361,'DAILY SHIFT1','2022-01-11','2022-01-11 00:00:00',NULL,'744',1016279.85,1016279.85,'744','2022-01-17 15:59:19','744','2022-01-17 16:10:41',10),('14','188',254610,'DAILY SHIFT1','2022-01-12','2022-01-12 00:00:00',NULL,'744',1540444.30,1540444.30,'744','2022-01-18 15:38:55','744','2022-01-18 15:40:03',10),('14','188',254621,'DAILY SHIFT1','2022-01-13','2022-01-13 00:00:00',NULL,'744',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1),('14','188',254624,'DAILY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'744',1404659.95,1404659.95,'744','2022-01-18 16:50:05','744','2022-01-18 16:51:04',10),('14','188',254628,'MORNING  SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'744',612365.30,612365.30,'744','2022-01-18 17:20:43','744','2022-01-18 17:26:21',10),('14','188',254632,'AFTERNOON SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'744',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1),('14','188',254633,'daily','2022-02-09','2022-02-09 00:00:00',NULL,'744',0.00,0.00,'744','2022-06-02 08:39:18','744','2022-06-02 08:39:31',10),('14','188',254634,'ledger test','2022-06-02','2022-06-02 08:39:56','2022-06-03 08:39:56','744',1650.00,1650.00,'744','2022-06-02 08:41:07','744','2022-06-02 08:41:19',10),('14','188',254635,'UPDATE TEST 2','2022-06-03','2022-06-03 15:54:51','2022-06-04 15:54:51','744',11550.00,11550.00,'744','2022-06-03 15:56:44','744','2022-06-03 15:57:00',10),('14','188',254636,'udate test 3','2022-06-10','2022-06-10 12:04:19','2022-06-11 12:04:19','744',49500.00,49500.00,'744','2022-06-10 12:05:40','744','2022-06-10 12:05:53',10),('14','188',254637,'udate test 3.1 ','2022-06-10','2022-06-10 12:54:53','2022-06-11 12:54:53','744',33000.00,33000.00,'744','2022-06-10 12:56:48','744','2022-06-10 13:02:36',10);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4855147 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('14','188','975','252103',4811187,'2882','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','252103',4811188,'2883','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','252103',4811189,'2884','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','252103',4811190,'2885','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','252103',4811191,'2886','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','252103',4811192,'2887','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','252103',4811193,'2888','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','252103',4811194,'2889','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','252103',4811195,'2890','439',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','252103',4811196,'2891','439',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','252103',4811197,'2892','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','252103',4811198,'2893','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','252115',4811370,'2882','438',1896245.96,1899087.44,2841.48,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','252115',4811371,'2883','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','252115',4811372,'2884','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','252115',4811373,'2885','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','252115',4811374,'2886','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','252115',4811375,'2887','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','252115',4811376,'2888','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','252115',4811377,'2889','438',369949.91,375348.53,5398.62,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','252115',4811378,'2890','439',860594.27,861737.28,1143.01,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','252115',4811379,'2891','439',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','252115',4811380,'2892','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','252115',4811381,'2893','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','252125',4811570,'2882','438',1899087.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','252125',4811571,'2883','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','252125',4811572,'2884','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','252125',4811573,'2885','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','252125',4811574,'2886','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','252125',4811575,'2887','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','252125',4811576,'2888','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','252125',4811577,'2889','438',375348.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','252125',4811578,'2890','439',861737.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','252125',4811579,'2891','439',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','252125',4811580,'2892','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','252125',4811581,'2893','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','252141',4811875,'2882','438',1899087.44,1899087.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','252141',4811876,'2883','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','252141',4811877,'2884','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','252141',4811878,'2885','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','252141',4811879,'2886','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','252141',4811880,'2887','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','252141',4811881,'2888','438',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','252141',4811882,'2889','438',375348.53,375358.53,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','252141',4811883,'2890','439',861737.28,861747.28,10.00,3500.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','252141',4811884,'2891','439',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','252141',4811885,'2892','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','252141',4811886,'2893','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254310',4849370,'2882','438',1899087.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254310',4849371,'2883','438',346384.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254310',4849372,'2884','438',182183.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254310',4849373,'2885','438',148298.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254310',4849374,'2886','438',2098071.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254310',4849375,'2887','438',310275.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254310',4849376,'2888','438',234088.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254310',4849377,'2889','438',3753484.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254310',4849378,'2890','439',601680.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254310',4849379,'2891','439',861737.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254310',4849380,'2892','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254310',4849381,'2893','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254313',4849400,'2882','438',1899087.44,1903039.08,3951.64,652020.60,0.00,0.00,0.00,0.00,0.00),('14','188','975','254313',4849401,'2883','438',346384.19,346384.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254313',4849402,'2884','438',182183.37,182183.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254313',4849403,'2885','438',148298.15,148298.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254313',4849404,'2886','438',2098071.39,2098071.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254313',4849405,'2887','438',310275.69,310275.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254313',4849406,'2888','438',234088.13,234088.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254313',4849407,'2889','438',381932.49,381932.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254313',4849408,'2890','439',601680.21,601680.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254313',4849409,'2891','439',862395.60,862509.83,114.23,39980.50,0.00,0.00,0.00,0.00,0.00),('14','188','980','254313',4849410,'2892','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254313',4849411,'2893','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254323',4849546,'2882','438',1903039.08,1907408.39,4369.31,720936.15,0.00,0.00,0.00,0.00,0.00),('14','188','975','254323',4849547,'2883','438',346384.19,346384.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254323',4849548,'2884','438',182183.37,182183.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254323',4849549,'2885','438',148298.15,148298.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254323',4849550,'2886','438',2098071.39,2098071.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254323',4849551,'2887','438',310275.69,310275.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254323',4849552,'2888','438',234088.13,234088.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254323',4849553,'2889','438',381932.49,391927.22,9994.73,1649130.45,0.00,0.00,0.00,0.00,0.00),('14','188','979','254323',4849554,'2890','439',601680.21,601680.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254323',4849555,'2891','439',862509.83,862802.71,292.88,102508.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254323',4849556,'2892','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254323',4849557,'2893','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254361',4850245,'2882','438',1907408.39,1912714.18,5295.79,873805.35,0.00,0.00,10.00,0.00,0.00),('14','188','975','254361',4850246,'2883','438',346384.19,346384.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254361',4850247,'2884','438',182183.37,182183.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254361',4850248,'2885','438',148298.15,148298.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254361',4850249,'2886','438',2098071.39,2098071.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254361',4850250,'2887','438',310275.69,310275.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254361',4850251,'2888','438',234088.13,234088.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254361',4850252,'2889','438',391927.22,391927.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254361',4850253,'2890','439',601680.21,601680.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254361',4850254,'2891','439',862802.71,863209.78,407.07,142474.50,0.00,0.00,0.00,0.00,0.00),('14','188','980','254361',4850255,'2892','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254361',4850256,'2893','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254610',4854569,'2882','438',1912714.18,1921028.80,8314.62,1371912.30,0.00,0.00,0.00,0.00,0.00),('14','188','975','254610',4854570,'2883','438',346384.19,346384.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254610',4854571,'2884','438',182183.37,182183.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254610',4854572,'2885','438',148298.15,148298.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254610',4854573,'2886','438',2098071.39,2098071.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254610',4854574,'2887','438',310275.69,310275.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254610',4854575,'2888','438',234088.13,234088.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254610',4854576,'2889','438',391927.22,391927.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254610',4854577,'2890','439',601680.21,601680.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254610',4854578,'2891','439',863209.78,863691.30,481.52,168532.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254610',4854579,'2892','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254610',4854580,'2893','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254621',4854851,'2882','438',1921028.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254621',4854852,'2883','438',346384.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254621',4854853,'2884','438',182183.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254621',4854854,'2885','438',148298.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254621',4854855,'2886','438',2098071.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254621',4854856,'2887','438',310275.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254621',4854857,'2888','438',234088.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254621',4854858,'2889','438',391927.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254621',4854859,'2890','439',601680.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254621',4854860,'2891','439',863691.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254621',4854861,'2892','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254621',4854862,'2893','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254624',4854890,'2882','438',1921028.80,1921028.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254624',4854891,'2883','438',346384.19,346384.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254624',4854892,'2884','438',182183.37,182183.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254624',4854893,'2885','438',148298.15,148298.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254624',4854894,'2886','438',2098071.39,2098071.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254624',4854895,'2887','438',310275.69,310275.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254624',4854896,'2888','438',340880.03,341619.00,738.97,121930.05,0.00,0.00,0.00,0.00,0.00),('14','188','978','254624',4854897,'2889','438',391927.22,398400.38,6473.16,1068071.40,0.00,0.00,0.00,0.00,0.00),('14','188','979','254624',4854898,'2890','439',601680.21,601680.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254624',4854899,'2891','439',863691.30,864304.61,613.31,214658.50,0.00,0.00,0.00,0.00,0.00),('14','188','980','254624',4854900,'2892','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254624',4854901,'2893','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254628',4854975,'2882','438',1921028.80,1921028.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254628',4854976,'2883','438',346384.19,346384.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254628',4854977,'2884','438',182183.37,182183.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254628',4854978,'2885','438',148298.15,148298.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254628',4854979,'2886','438',2098071.39,2100323.91,2242.52,370015.80,0.00,0.00,10.00,0.00,0.00),('14','188','977','254628',4854980,'2887','438',310275.69,310275.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254628',4854981,'2888','438',341619.00,341619.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254628',4854982,'2889','438',398400.38,398451.58,51.20,8448.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254628',4854983,'2890','439',601680.21,601680.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254628',4854984,'2891','439',864304.61,864972.90,668.29,233901.50,0.00,0.00,0.00,0.00,0.00),('14','188','980','254628',4854985,'2892','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254628',4854986,'2893','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254632',4855075,'2882','438',1921028.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254632',4855076,'2883','438',346384.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254632',4855077,'2884','438',182183.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254632',4855078,'2885','438',148298.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254632',4855079,'2886','438',2100323.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254632',4855080,'2887','438',310275.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254632',4855081,'2888','438',341619.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254632',4855082,'2889','438',398451.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254632',4855083,'2890','439',601680.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254632',4855084,'2891','439',864972.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254632',4855085,'2892','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254632',4855086,'2893','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254633',4855087,'2882','438',1921028.80,1921028.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254633',4855088,'2883','438',346384.19,346384.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254633',4855089,'2884','438',182183.37,182183.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254633',4855090,'2885','438',148298.15,148298.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254633',4855091,'2886','438',2100323.91,2100323.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254633',4855092,'2887','438',310275.69,310275.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254633',4855093,'2888','438',341619.00,341619.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254633',4855094,'2889','438',398451.58,398451.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254633',4855095,'2890','439',601680.21,601680.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254633',4855096,'2891','439',864972.90,864972.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254633',4855097,'2892','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254633',4855098,'2893','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254634',4855099,'2882','438',1921028.80,1921038.80,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254634',4855100,'2883','438',346384.19,346384.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254634',4855101,'2884','438',182183.37,182183.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254634',4855102,'2885','438',148298.15,148298.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254634',4855103,'2886','438',2100323.91,2100323.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254634',4855104,'2887','438',310275.69,310275.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254634',4855105,'2888','438',341619.00,341619.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254634',4855106,'2889','438',398451.58,398451.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254634',4855107,'2890','439',601680.21,601680.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254634',4855108,'2891','439',864972.90,864972.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254634',4855109,'2892','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254634',4855110,'2893','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254635',4855111,'2882','438',1921038.80,1921058.80,20.00,3300.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254635',4855112,'2883','438',346384.19,346394.19,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254635',4855113,'2884','438',182183.37,182193.37,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254635',4855114,'2885','438',148298.15,148298.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254635',4855115,'2886','438',2100323.91,2100353.91,30.00,4950.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254635',4855116,'2887','438',310275.69,310275.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254635',4855117,'2888','438',341619.00,341619.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254635',4855118,'2889','438',398451.58,398451.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254635',4855119,'2890','439',601680.21,601680.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254635',4855120,'2891','439',864972.90,864972.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254635',4855121,'2892','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254635',4855122,'2893','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254636',4855123,'2882','438',1921058.80,1921058.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254636',4855124,'2883','438',346394.19,346594.19,200.00,33000.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254636',4855125,'2884','438',182193.37,182193.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254636',4855126,'2885','438',148298.15,148398.15,100.00,16500.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254636',4855127,'2886','438',2100353.91,2100353.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254636',4855128,'2887','438',310275.69,310275.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254636',4855129,'2888','438',341619.00,341619.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254636',4855130,'2889','438',398451.58,398451.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254636',4855131,'2890','439',601680.21,601680.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254636',4855132,'2891','439',864972.90,864972.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254636',4855133,'2892','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254636',4855134,'2893','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254637',4855135,'2882','438',1921058.80,1921258.80,200.00,33000.00,0.00,0.00,0.00,0.00,0.00),('14','188','975','254637',4855136,'2883','438',346594.19,346594.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254637',4855137,'2884','438',182193.37,182193.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','976','254637',4855138,'2885','438',148398.15,148398.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254637',4855139,'2886','438',2100353.91,2100353.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','977','254637',4855140,'2887','438',310275.69,310275.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254637',4855141,'2888','438',341619.00,341619.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','978','254637',4855142,'2889','438',398451.58,398451.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254637',4855143,'2890','439',601680.21,601680.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','979','254637',4855144,'2891','439',864972.90,864972.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254637',4855145,'2892','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('14','188','980','254637',4855146,'2893','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=722346 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('14','188','252103','438',165.00,165.00,0.00,0.00,0.00,0.00,0.00,715749),('14','188','252103','439',350.00,350.00,0.00,0.00,0.00,0.00,0.00,715750),('14','188','252103','440',0.00,225.00,0.00,0.00,0.00,0.00,0.00,715751),('14','188','252115','438',165.00,0.00,8240.10,0.00,0.00,0.00,0.00,715780),('14','188','252115','439',350.00,0.00,1143.01,0.00,0.00,0.00,0.00,715781),('14','188','252115','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715782),('14','188','252125','438',165.00,165.00,0.00,0.00,0.00,0.00,0.00,715810),('14','188','252125','439',350.00,350.00,0.00,0.00,0.00,0.00,0.00,715811),('14','188','252125','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715812),('14','188','252141','438',165.00,165.00,10.00,0.00,0.00,0.00,0.00,715854),('14','188','252141','439',350.00,350.00,10.00,0.00,0.00,0.00,0.00,715855),('14','188','252141','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715856),('14','188','254310','438',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721491),('14','188','254310','439',350.00,350.00,0.00,0.00,0.00,0.00,0.00,721492),('14','188','254310','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721493),('14','188','254313','438',165.00,165.00,3951.64,0.00,0.00,0.00,0.00,721500),('14','188','254313','439',350.00,350.00,114.23,0.00,0.00,0.00,0.00,721501),('14','188','254313','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721502),('14','188','254323','438',165.00,165.00,14364.04,0.00,0.00,0.00,0.00,721524),('14','188','254323','439',350.00,350.00,292.88,0.00,0.00,0.00,0.00,721525),('14','188','254323','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721526),('14','188','254361','438',165.00,165.00,5295.79,0.00,0.00,0.00,0.00,721627),('14','188','254361','439',350.00,350.00,407.07,0.00,0.00,0.00,0.00,721628),('14','188','254361','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721629),('14','188','254610','438',165.00,165.00,8314.62,0.00,0.00,0.00,0.00,722264),('14','188','254610','439',350.00,350.00,481.52,0.00,0.00,0.00,0.00,722265),('14','188','254610','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722266),('14','188','254621','438',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722295),('14','188','254621','439',350.00,350.00,0.00,0.00,0.00,0.00,0.00,722296),('14','188','254621','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722297),('14','188','254624','438',165.00,165.00,7212.13,0.00,0.00,0.00,0.00,722304),('14','188','254624','439',350.00,350.00,613.31,0.00,0.00,0.00,0.00,722305),('14','188','254624','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722306),('14','188','254628','438',165.00,165.00,2293.72,0.00,0.00,0.00,0.00,722316),('14','188','254628','439',350.00,350.00,668.29,0.00,0.00,0.00,0.00,722317),('14','188','254628','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722318),('14','188','254632','438',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722328),('14','188','254632','439',350.00,350.00,0.00,0.00,0.00,0.00,0.00,722329),('14','188','254632','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722330),('14','188','254633','438',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722331),('14','188','254633','439',360.00,360.00,0.00,0.00,0.00,0.00,0.00,722332),('14','188','254633','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722333),('14','188','254634','439',360.00,360.00,0.00,0.00,0.00,0.00,0.00,722334),('14','188','254634','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722335),('14','188','254634','438',165.00,165.00,10.00,0.00,0.00,0.00,0.00,722336),('14','188','254635','439',360.00,360.00,0.00,0.00,0.00,0.00,0.00,722337),('14','188','254635','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722338),('14','188','254635','438',165.00,165.00,70.00,0.00,0.00,0.00,0.00,722339),('14','188','254636','438',165.00,165.00,300.00,0.00,0.00,0.00,0.00,722340),('14','188','254636','439',360.00,360.00,0.00,0.00,0.00,0.00,0.00,722341),('14','188','254636','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722342),('14','188','254637','438',165.00,165.00,200.00,0.00,0.00,0.00,0.00,722343),('14','188','254637','439',360.00,360.00,0.00,0.00,0.00,0.00,0.00,722344),('14','188','254637','440',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722345);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=396 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('14',395,'188','PRODUCT TANKS.','TANKS CONTAINING PETROLEUM PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=981 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('14','188','395',975,0,'438','PMS TANK 1',35000.00,1.00,0.00,'TANK CONTAINING PMS.','646','2021-07-22 06:52:20','2021-07-22 06:52:20','646',5,1),('14','188','395',976,0,'438','PMS TANK 2',35000.00,1.00,0.00,'TANK CONTAINING PMS.','646','2021-07-22 06:53:57','2021-07-22 06:53:57','646',5,1),('14','188','395',977,0,'438','PMS TANK 3',34000.00,1.00,0.00,'PMS DISPENSER','646','2021-07-22 06:55:36','2021-07-22 06:55:36','646',5,1),('14','188','395',978,0,'438','PMS TANK 4',42000.00,1.00,0.00,'TANK CONTAINING PMS.','646','2021-07-22 06:57:56','2021-07-22 06:57:56','646',5,1),('14','188','395',979,0,'439','AGO TANK',35000.00,1.00,0.00,'TANK CONTAINING AGO','646','2021-07-22 07:03:06','2021-07-22 07:03:06','646',5,1),('14','188','395',980,0,'440','DPK TANK',35000.00,1.00,0.00,'TANK CONTAINING DPK','646','2021-07-22 07:05:24','2021-07-22 07:05:24','646',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2614026 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2466551,'14','188',NULL,438,'Purchased from EDI-JEN NIGERIA LIMITED',0.00,2161500.00,13100.00,0.00,0.00,'2022-01-08 12:39:58','',''),(2466583,'14','188',NULL,438,'Reception corrector for bridging 130173',0.00,0.00,0.00,6000.00,0.00,'2022-01-08 12:43:24','',''),(2466584,'14','188','978',438,'Received from bridging 130173',0.00,0.00,6000.00,0.00,0.00,'2022-01-08 12:43:24','',''),(2466585,'14','188',NULL,438,'Reception corrector for bridging 130172',0.00,0.00,0.00,3000.00,0.00,'2022-01-08 12:43:24','',''),(2466586,'14','188','975',438,'Received from bridging 130172',0.00,0.00,3000.00,0.00,0.00,'2022-01-08 12:43:24','',''),(2466591,'14','188',NULL,439,'Purchased from EDI-JEN NIGERIA LIMITED',0.00,7927500.00,22650.00,0.00,0.00,'2022-01-08 12:43:57','',''),(2466652,'14','188',NULL,439,'Reception corrector for bridging 130177',0.00,0.00,0.00,22650.00,0.00,'2022-01-08 12:51:04','',''),(2466653,'14','188','979',439,'Received from bridging 130177',0.00,0.00,22650.00,0.00,0.00,'2022-01-08 12:51:04','',''),(2467289,'14','188','975',438,'Sale Id shift 252115',0.00,0.00,0.00,2841.48,0.00,'2022-01-08 13:50:08','',''),(2467290,'14','188','978',438,'Sale Id shift 252115',0.00,0.00,0.00,5398.62,0.00,'2022-01-08 13:50:08','',''),(2467291,'14','188','979',439,'Sale Id shift 252115',0.00,0.00,0.00,1143.01,0.00,'2022-01-08 13:50:08','',''),(2467292,'14','188',NULL,438,'Sale Id shift 252115',1359616.50,0.00,0.00,0.00,0.00,'2022-01-08 13:50:08','',''),(2467293,'14','188',NULL,439,'Sale Id shift 252115',400053.50,0.00,0.00,0.00,0.00,'2022-01-08 13:50:08','',''),(2467959,'14','188','978',438,'Sale Id shift 252141',0.00,0.00,0.00,10.00,0.00,'2022-01-08 14:45:55','',''),(2467960,'14','188','979',439,'Sale Id shift 252141',0.00,0.00,0.00,10.00,0.00,'2022-01-08 14:45:55','',''),(2467961,'14','188',NULL,438,'Sale Id shift 252141',1650.00,0.00,0.00,0.00,0.00,'2022-01-08 14:45:55','',''),(2467962,'14','188',NULL,439,'Sale Id shift 252141',3500.00,0.00,0.00,0.00,0.00,'2022-01-08 14:45:55','',''),(2536999,'14','188','975',0,'Tank level zero out for dipping',0.00,0.00,0.00,158.52,0.00,'2022-01-17 12:54:50','',''),(2537000,'14','188','975',0,'Inventory adjustment from tank dipping to 14800',0.00,0.00,14800.00,0.00,0.00,'2022-01-17 12:54:50','',''),(2537002,'14','188','976',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-01-17 12:55:07','',''),(2537003,'14','188','976',0,'Inventory adjustment from tank dipping to 1050',0.00,0.00,1050.00,0.00,0.00,'2022-01-17 12:55:07','',''),(2537010,'14','188','977',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-01-17 12:55:34','',''),(2537011,'14','188','977',0,'Inventory adjustment from tank dipping to 5050',0.00,0.00,5050.00,0.00,0.00,'2022-01-17 12:55:34','',''),(2537013,'14','188','978',0,'Tank level zero out for dipping',0.00,0.00,0.00,591.38,0.00,'2022-01-17 12:55:49','',''),(2537014,'14','188','978',0,'Inventory adjustment from tank dipping to 14950',0.00,0.00,14950.00,0.00,0.00,'2022-01-17 12:55:49','',''),(2537019,'14','188','979',0,'Tank level zero out for dipping',0.00,0.00,0.00,21496.99,0.00,'2022-01-17 12:56:07','',''),(2537020,'14','188','979',0,'Inventory adjustment from tank dipping to 25350',0.00,0.00,25350.00,0.00,0.00,'2022-01-17 12:56:07','',''),(2537295,'14','188','975',438,'Sale Id shift 254313',0.00,0.00,0.00,3951.64,0.00,'2022-01-17 13:37:02','',''),(2537296,'14','188','979',439,'Sale Id shift 254313',0.00,0.00,0.00,114.23,0.00,'2022-01-17 13:37:02','',''),(2537297,'14','188',NULL,438,'Sale Id shift 254313',652020.60,0.00,0.00,0.00,0.00,'2022-01-17 13:37:02','',''),(2537298,'14','188',NULL,439,'Sale Id shift 254313',39980.50,0.00,0.00,0.00,0.00,'2022-01-17 13:37:02','',''),(2538659,'14','188','975',438,'Sale Id shift 254323',0.00,0.00,0.00,4369.31,0.00,'2022-01-17 15:50:13','',''),(2538660,'14','188','978',438,'Sale Id shift 254323',0.00,0.00,0.00,9994.73,0.00,'2022-01-17 15:50:13','',''),(2538661,'14','188','979',439,'Sale Id shift 254323',0.00,0.00,0.00,292.88,0.00,'2022-01-17 15:50:13','',''),(2538662,'14','188',NULL,438,'Sale Id shift 254323',2370066.60,0.00,0.00,0.00,0.00,'2022-01-17 15:50:13','',''),(2538663,'14','188',NULL,439,'Sale Id shift 254323',102508.00,0.00,0.00,0.00,0.00,'2022-01-17 15:50:13','',''),(2538876,'14','188','975',438,'Sale Id shift 254361',0.00,0.00,0.00,5295.79,0.00,'2022-01-17 16:10:41','',''),(2538877,'14','188','979',439,'Sale Id shift 254361',0.00,0.00,0.00,407.07,0.00,'2022-01-17 16:10:41','',''),(2538878,'14','188',NULL,438,'Sale Id shift 254361',873805.35,0.00,0.00,0.00,0.00,'2022-01-17 16:10:41','',''),(2538879,'14','188',NULL,439,'Sale Id shift 254361',142474.50,0.00,0.00,0.00,0.00,'2022-01-17 16:10:41','',''),(2545656,'14','188','975',0,'Tank level zero out for dipping',0.00,0.00,0.00,1183.26,0.00,'2022-01-18 15:35:29','',''),(2545657,'14','188','975',0,'Inventory adjustment from tank dipping to 9550',0.00,0.00,9550.00,0.00,0.00,'2022-01-18 15:35:29','',''),(2545700,'14','188','975',438,'Sale Id shift 254610',0.00,0.00,0.00,8314.62,0.00,'2022-01-18 15:40:03','',''),(2545701,'14','188','979',439,'Sale Id shift 254610',0.00,0.00,0.00,481.52,0.00,'2022-01-18 15:40:03','',''),(2545702,'14','188',NULL,438,'Sale Id shift 254610',1371912.30,0.00,0.00,0.00,0.00,'2022-01-18 15:40:03','',''),(2545703,'14','188',NULL,439,'Sale Id shift 254610',168532.00,0.00,0.00,0.00,0.00,'2022-01-18 15:40:03','',''),(2546076,'14','188',NULL,438,'Purchased from EDI-JEN NIGERIA LIMITED',0.00,2227500.00,13500.00,0.00,0.00,'2022-01-18 16:12:53','',''),(2546103,'14','188',NULL,438,'Reception corrector for bridging 131324',0.00,0.00,0.00,5250.00,0.00,'2022-01-18 16:16:04','',''),(2546104,'14','188','978',438,'Received from bridging 131324',0.00,0.00,5250.00,0.00,0.00,'2022-01-18 16:16:04','',''),(2546105,'14','188',NULL,438,'Reception corrector for bridging 131323',0.00,0.00,0.00,8250.00,0.00,'2022-01-18 16:16:04','',''),(2546106,'14','188','975',438,'Received from bridging 131323',0.00,0.00,8250.00,0.00,0.00,'2022-01-18 16:16:04','',''),(2546486,'14','188','978',438,'Sale Id shift 254624',0.00,0.00,0.00,738.97,0.00,'2022-01-18 16:51:04','',''),(2546487,'14','188','978',438,'Sale Id shift 254624',0.00,0.00,0.00,6473.16,0.00,'2022-01-18 16:51:04','',''),(2546488,'14','188','979',439,'Sale Id shift 254624',0.00,0.00,0.00,613.31,0.00,'2022-01-18 16:51:04','',''),(2546489,'14','188',NULL,438,'Sale Id shift 254624',1190001.45,0.00,0.00,0.00,0.00,'2022-01-18 16:51:04','',''),(2546490,'14','188',NULL,439,'Sale Id shift 254624',214658.50,0.00,0.00,0.00,0.00,'2022-01-18 16:51:04','',''),(2547007,'14','188','977',438,'Sale Id shift 254628',0.00,0.00,0.00,2242.52,0.00,'2022-01-18 17:26:21','',''),(2547008,'14','188','978',438,'Sale Id shift 254628',0.00,0.00,0.00,51.20,0.00,'2022-01-18 17:26:21','',''),(2547009,'14','188','979',439,'Sale Id shift 254628',0.00,0.00,0.00,668.29,0.00,'2022-01-18 17:26:21','',''),(2547010,'14','188',NULL,438,'Sale Id shift 254628',378463.80,0.00,0.00,0.00,0.00,'2022-01-18 17:26:21','',''),(2547011,'14','188',NULL,439,'Sale Id shift 254628',233901.50,0.00,0.00,0.00,0.00,'2022-01-18 17:26:21','',''),(2547049,'14','188',NULL,439,'2022-01-18 17:29:24',0.00,189196.90,0.00,0.00,0.00,'2022-01-18 17:29:24','',''),(2553173,'14','188',NULL,438,'Purchased from EDI-JEN NIGERIA LIMITED',0.00,1996500.00,12100.00,0.00,0.00,'2022-01-19 15:25:51','',''),(2553234,'14','188',NULL,438,'Reception corrector for bridging 131404',0.00,0.00,0.00,12100.00,0.00,'2022-01-19 15:31:20','',''),(2553235,'14','188','978',438,'Received from bridging 131404',0.00,0.00,12100.00,0.00,0.00,'2022-01-19 15:31:20','',''),(2612933,'14','188',NULL,440,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613057,'14','188',NULL,439,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613062,'14','188',NULL,438,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613185,'14','188','977',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613235,'14','188','976',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613346,'14','188','975',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613624,'14','188','980',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613877,'14','188','979',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2614013,'14','188','978',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2614014,'14','188','975',438,'Sale Id shift 254634',0.00,0.00,0.00,10.00,0.00,'2022-06-02 08:41:19','',''),(2614015,'14','188',NULL,438,'Sale Id shift 254634',1650.00,0.00,0.00,0.00,0.00,'2022-06-02 08:41:20','',''),(2614016,'14','188','975',438,'Sale Id shift 254635',0.00,0.00,0.00,20.00,0.00,'2022-06-03 15:57:00','',''),(2614017,'14','188','975',438,'Sale Id shift 254635',0.00,0.00,0.00,10.00,0.00,'2022-06-03 15:57:00','',''),(2614018,'14','188','976',438,'Sale Id shift 254635',0.00,0.00,0.00,10.00,0.00,'2022-06-03 15:57:00','',''),(2614019,'14','188','977',438,'Sale Id shift 254635',0.00,0.00,0.00,30.00,0.00,'2022-06-03 15:57:00','',''),(2614020,'14','188',NULL,438,'Sale Id shift 254635',11550.00,0.00,0.00,0.00,0.00,'2022-06-03 15:57:00','',''),(2614021,'14','188','975',438,'Sale Id shift 254636',0.00,0.00,0.00,200.00,0.00,'2022-06-10 12:05:53','',''),(2614022,'14','188','976',438,'Sale Id shift 254636',0.00,0.00,0.00,100.00,0.00,'2022-06-10 12:05:53','',''),(2614023,'14','188',NULL,438,'Sale Id shift 254636',49500.00,0.00,0.00,0.00,0.00,'2022-06-10 12:05:53','',''),(2614024,'14','188','975',438,'Sale Id shift 254637',0.00,0.00,0.00,200.00,0.00,'2022-06-10 13:02:36','',''),(2614025,'14','188',NULL,438,'Sale Id shift 254637',33000.00,0.00,0.00,0.00,0.00,'2022-06-10 13:02:36','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1760268 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1705385,'14','188',438,'Sale Id shift 252115',0.00,1359616.50,0.00,0.00,-1359616.50,'2022-01-08 13:50:08'),(1705386,'14','188',439,'Sale Id shift 252115',0.00,400053.50,0.00,0.00,-400053.50,'2022-01-08 13:50:08'),(1705863,'14','188',438,'Sale Id shift 252141',0.00,1650.00,165.00,1650.00,0.00,'2022-01-08 14:45:55'),(1705864,'14','188',439,'Sale Id shift 252141',0.00,3500.00,350.00,3500.00,0.00,'2022-01-08 14:45:55'),(1752395,'14','188',438,'Sale Id shift 254313',0.00,652020.60,165.00,652020.60,0.00,'2022-01-17 13:37:02'),(1752396,'14','188',439,'Sale Id shift 254313',0.00,39980.50,350.00,39980.50,0.00,'2022-01-17 13:37:02'),(1753498,'14','188',438,'Sale Id shift 254323',0.00,2370066.60,165.00,2370066.60,0.00,'2022-01-17 15:50:13'),(1753499,'14','188',439,'Sale Id shift 254323',0.00,102508.00,350.00,102508.00,0.00,'2022-01-17 15:50:13'),(1753684,'14','188',438,'Sale Id shift 254361',0.00,873805.35,165.00,873805.35,0.00,'2022-01-17 16:10:41'),(1753685,'14','188',439,'Sale Id shift 254361',0.00,142474.50,350.00,142474.50,0.00,'2022-01-17 16:10:41'),(1759225,'14','188',438,'Sale Id shift 254610',0.00,1371912.30,165.00,1371912.30,0.00,'2022-01-18 15:40:03'),(1759226,'14','188',439,'Sale Id shift 254610',0.00,168532.00,350.00,168532.00,0.00,'2022-01-18 15:40:03'),(1759852,'14','188',438,'Sale Id shift 254624',0.00,1190001.45,165.00,1190001.45,0.00,'2022-01-18 16:51:04'),(1759853,'14','188',439,'Sale Id shift 254624',0.00,214658.50,350.00,214658.50,0.00,'2022-01-18 16:51:04'),(1760262,'14','188',438,'Sale Id shift 254628',0.00,378463.80,165.00,378463.80,0.00,'2022-01-18 17:26:21'),(1760263,'14','188',439,'Sale Id shift 254628',0.00,233901.50,350.00,233901.50,0.00,'2022-01-18 17:26:21'),(1760264,'14','188',438,'Sale Id shift 254634',0.00,1650.00,165.00,1650.00,0.00,'2022-06-02 08:41:20'),(1760265,'14','188',438,'Sale Id shift 254635',0.00,11550.00,165.00,11550.00,0.00,'2022-06-03 15:57:00'),(1760266,'14','188',438,'Sale Id shift 254636',0.00,49500.00,165.00,49500.00,0.00,'2022-06-10 12:05:53'),(1760267,'14','188',438,'Sale Id shift 254637',0.00,33000.00,165.00,33000.00,0.00,'2022-06-10 13:02:36');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4795510 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('14','188',3766631,'','20','3499',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('14','188',3768889,'','24','3502',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('14','188',3768925,'','6.1','3498',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('14','188',3769041,'','22','3501',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('14','188',3770074,'','24','3500',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('14','188',4636170,'','24','3500',0.00,2161500.00,'Purchase Id 89099 for 13,100.00 litters of Petrol - PMS from EDI-JEN NIGERIA LIMITED','2022-01-08 12:39:58','',''),('14','188',4636171,'','supplier','260',2161500.00,0.00,'Purchase Id 89099 for 13,100.00 litters of Petrol - PMS from EDI-JEN NIGERIA LIMITED','2022-01-08 12:39:58','',''),('14','188',4636242,'','24','3500',0.00,7927500.00,'Purchase Id 89100 for 22,650.00 litters of Diesel - AGO from EDI-JEN NIGERIA LIMITED','2022-01-08 12:43:57','',''),('14','188',4636243,'','supplier','260',7927500.00,0.00,'Purchase Id 89100 for 22,650.00 litters of Diesel - AGO from EDI-JEN NIGERIA LIMITED','2022-01-08 12:43:57','',''),('14','188',4637491,'','customer','4157',0.00,0.00,'Credit Sales for 309.20 Litres of Petrol from shift 252115 on 2022-01-08 13:50:08 ','2022-01-08 13:50:08','',''),('14','188',4637492,'','customer','4156',0.00,0.00,'Credit Sales for 309.20 Litres of Petrol from shift 252115 on 2022-01-08 13:50:08 ','2022-01-08 13:50:08','',''),('14','188',4637493,'','20','3499',0.00,0.00,'Sales from shift 252115 on 2022-01-08 13:50:08 ','2022-01-08 13:50:08','',''),('14','188',4637494,'','6.1','3498',0.00,0.00,'Sales from shift 252115 on 2022-01-08 13:50:08 ','2022-01-08 13:50:08','',''),('14','188',4638554,'','customer','4158',0.00,330.00,'Credit Sales for 2.00 Litres of Petrol from shift 252141 on 2022-01-08 14:45:55 ','2022-01-08 14:45:55','',''),('14','188',4638555,'','customer','4157',0.00,330.00,'Credit Sales for 2.00 Litres of Petrol from shift 252141 on 2022-01-08 14:45:55 ','2022-01-08 14:45:55','',''),('14','188',4638556,'','20','3499',5150.00,0.00,'Sales from shift 252141 on 2022-01-08 14:45:55 ','2022-01-08 14:45:55','',''),('14','188',4638557,'','6.1','3498',0.00,4490.00,'Sales from shift 252141 on 2022-01-08 14:45:55 ','2022-01-08 14:45:55','',''),('14','188',4763616,'','customer','4156',0.00,11550.00,'Credit Sales for 70.00 Litres of Petrol from shift 254313 on 2022-01-17 13:37:02 ','2022-01-17 13:37:02','',''),('14','188',4763617,'','20','3499',692001.10,0.00,'Sales from shift 254313 on 2022-01-17 13:37:02 ','2022-01-17 13:37:02','',''),('14','188',4763618,'','6.1','3498',0.00,680451.10,'Sales from shift 254313 on 2022-01-17 13:37:02 ','2022-01-17 13:37:02','',''),('14','188',4763625,'','2','4080',41890.00,0.00,'Payment Id 394551 for invoice:254313, receipt:  by EDI-JEN NIGERIA LIMITED','2022-01-17 13:37:39','',''),('14','188',4763626,'','supplier','260',0.00,41890.00,'Payment Id 394551 for invoice:254313, receipt:  by EDI-JEN NIGERIA LIMITED','2022-01-17 13:37:39','',''),('14','188',4763627,'','2','4082',230448.00,0.00,'Payment Id 394550 for invoice:254313, receipt:  by EDI-JEN NIGERIA LIMITED','2022-01-17 13:37:39','',''),('14','188',4763628,'','supplier','260',0.00,230448.00,'Payment Id 394550 for invoice:254313, receipt:  by EDI-JEN NIGERIA LIMITED','2022-01-17 13:37:39','',''),('14','188',4763629,'','2','4071',408120.00,0.00,'Payment Id 394548 for invoice:254313, receipt:  by EDI-JEN NIGERIA LIMITED','2022-01-17 13:37:39','',''),('14','188',4763630,'','supplier','260',0.00,408120.00,'Payment Id 394548 for invoice:254313, receipt:  by EDI-JEN NIGERIA LIMITED','2022-01-17 13:37:39','',''),('14','188',4766378,'','customer','4157',0.00,51480.00,'Credit Sales for 312.00 Litres of Petrol from shift 254323 on 2022-01-17 15:50:13 ','2022-01-17 15:50:13','',''),('14','188',4766379,'','customer','4157',0.00,21000.00,'Credit Sales for 60.00 Litres of Diesel from shift 254323 on 2022-01-17 15:50:13 ','2022-01-17 15:50:13','',''),('14','188',4766380,'','customer','4156',0.00,28875.00,'Credit Sales for 175.00 Litres of Petrol from shift 254323 on 2022-01-17 15:50:13 ','2022-01-17 15:50:13','',''),('14','188',4766381,'','customer','4158',0.00,41258.25,'Credit Sales for 250.05 Litres of Petrol from shift 254323 on 2022-01-17 15:50:13 ','2022-01-17 15:50:13','',''),('14','188',4766382,'','20','3499',2472574.60,0.00,'Sales from shift 254323 on 2022-01-17 15:50:13 ','2022-01-17 15:50:13','',''),('14','188',4766383,'','6.1','3498',0.00,2329961.35,'Sales from shift 254323 on 2022-01-17 15:50:13 ','2022-01-17 15:50:13','',''),('14','188',4766772,'','customer','4157',0.00,49335.00,'Credit Sales for 299.00 Litres of Petrol from shift 254361 on 2022-01-17 16:10:41 ','2022-01-17 16:10:41','',''),('14','188',4766773,'','customer','4156',0.00,7000.00,'Credit Sales for 20.00 Litres of Diesel from shift 254361 on 2022-01-17 16:10:41 ','2022-01-17 16:10:41','',''),('14','188',4766774,'','customer','4157',0.00,81675.00,'Credit Sales for 495.00 Litres of Petrol from shift 254361 on 2022-01-17 16:10:41 ','2022-01-17 16:10:41','',''),('14','188',4766775,'','20','3499',1016279.85,0.00,'Sales from shift 254361 on 2022-01-17 16:10:41 ','2022-01-17 16:10:41','',''),('14','188',4766776,'','6.1','3498',0.00,878269.85,'Sales from shift 254361 on 2022-01-17 16:10:41 ','2022-01-17 16:10:41','',''),('14','188',4780652,'','customer','4191',0.00,9075.00,'Credit Sales for 55.00 Litres of Petrol from shift 254610 on 2022-01-18 15:40:03 ','2022-01-18 15:40:03','',''),('14','188',4780653,'','customer','4157',0.00,65340.00,'Credit Sales for 396.00 Litres of Petrol from shift 254610 on 2022-01-18 15:40:03 ','2022-01-18 15:40:03','',''),('14','188',4780654,'','customer','4156',0.00,18150.00,'Credit Sales for 110.00 Litres of Petrol from shift 254610 on 2022-01-18 15:40:03 ','2022-01-18 15:40:03','',''),('14','188',4780655,'','customer','4193',0.00,9999.00,'Credit Sales for 60.60 Litres of Petrol from shift 254610 on 2022-01-18 15:40:03 ','2022-01-18 15:40:03','',''),('14','188',4780656,'','20','3499',1540444.30,0.00,'Sales from shift 254610 on 2022-01-18 15:40:03 ','2022-01-18 15:40:03','',''),('14','188',4780657,'','6.1','3498',0.00,1437880.30,'Sales from shift 254610 on 2022-01-18 15:40:03 ','2022-01-18 15:40:03','',''),('14','188',4781295,'','24','3500',0.00,2227500.00,'Purchase Id 89863 for 13,500.00 litters of Petrol - PMS from EDI-JEN NIGERIA LIMITED','2022-01-18 16:12:53','',''),('14','188',4781296,'','supplier','260',2227500.00,0.00,'Purchase Id 89863 for 13,500.00 litters of Petrol - PMS from EDI-JEN NIGERIA LIMITED','2022-01-18 16:12:53','',''),('14','188',4782168,'','customer','4191',0.00,42000.00,'Credit Sales for 120.00 Litres of Diesel from shift 254624 on 2022-01-18 16:51:04 ','2022-01-18 16:51:04','',''),('14','188',4782169,'','customer','4191',0.00,32638.65,'Credit Sales for 197.81 Litres of Petrol from shift 254624 on 2022-01-18 16:51:04 ','2022-01-18 16:51:04','',''),('14','188',4782170,'','customer','4192',0.00,15050.00,'Credit Sales for 43.00 Litres of Diesel from shift 254624 on 2022-01-18 16:51:04 ','2022-01-18 16:51:04','',''),('14','188',4782171,'','customer','4157',0.00,73500.00,'Credit Sales for 210.00 Litres of Diesel from shift 254624 on 2022-01-18 16:51:04 ','2022-01-18 16:51:04','',''),('14','188',4782172,'','customer','4196',0.00,18739.00,'Credit Sales for 53.54 Litres of Diesel from shift 254624 on 2022-01-18 16:51:04 ','2022-01-18 16:51:04','',''),('14','188',4782173,'','customer','4157',0.00,34151.70,'Credit Sales for 206.98 Litres of Petrol from shift 254624 on 2022-01-18 16:51:04 ','2022-01-18 16:51:04','',''),('14','188',4782174,'','customer','4190',0.00,7487.70,'Credit Sales for 45.38 Litres of Petrol from shift 254624 on 2022-01-18 16:51:04 ','2022-01-18 16:51:04','',''),('14','188',4782175,'','20','3499',1404659.95,0.00,'Sales from shift 254624 on 2022-01-18 16:51:04 ','2022-01-18 16:51:04','',''),('14','188',4782176,'','6.1','3498',0.00,1181092.90,'Sales from shift 254624 on 2022-01-18 16:51:04 ','2022-01-18 16:51:04','',''),('14','188',4783072,'','customer','4191',0.00,49000.00,'Credit Sales for 140.00 Litres of Diesel from shift 254628 on 2022-01-18 17:26:21 ','2022-01-18 17:26:21','',''),('14','188',4783073,'','customer','4191',0.00,10725.00,'Credit Sales for 65.00 Litres of Petrol from shift 254628 on 2022-01-18 17:26:21 ','2022-01-18 17:26:21','',''),('14','188',4783074,'','customer','4157',0.00,88770.00,'Credit Sales for 538.00 Litres of Petrol from shift 254628 on 2022-01-18 17:26:21 ','2022-01-18 17:26:21','',''),('14','188',4783075,'','customer','4156',0.00,45899.70,'Credit Sales for 278.18 Litres of Petrol from shift 254628 on 2022-01-18 17:26:21 ','2022-01-18 17:26:21','',''),('14','188',4783076,'','20','3499',612365.30,0.00,'Sales from shift 254628 on 2022-01-18 17:26:21 ','2022-01-18 17:26:21','',''),('14','188',4783077,'','6.1','3498',0.00,417970.60,'Sales from shift 254628 on 2022-01-18 17:26:21 ','2022-01-18 17:26:21','',''),('14','188',4783146,'','24','3500',0.00,189196.90,'Inventory value adjustment for product Id 439 from 350.00 to 360','2022-01-18 17:29:24','',''),('14','188',4783147,'','supplier','260',189196.90,0.00,'Inventory value adjustment for product Id 439 from 350.00 to 360','2022-01-18 17:29:24','',''),('14','188',4795494,'','24','3500',0.00,1996500.00,'Purchase Id 89922 for 12,100.00 litters of Petrol - PMS from EDI-JEN NIGERIA LIMITED','2022-01-19 15:25:51','',''),('14','188',4795495,'','supplier','260',1996500.00,0.00,'Purchase Id 89922 for 12,100.00 litters of Petrol - PMS from EDI-JEN NIGERIA LIMITED','2022-01-19 15:25:51','',''),('14','188',4795496,'','20','3499',0.00,0.00,'Sales from shift 254633 on 2022-06-02 08:39:31 ','2022-06-02 08:39:31','',''),('14','188',4795497,'','6.1','3498',0.00,0.00,'Sales from shift 254633 on 2022-06-02 08:39:31 ','2022-06-02 08:39:31','',''),('14','188',4795498,'','customer','4195',0.00,7200.00,'Credit Sales for 20.00 Litres of Diesel from shift 254634 on 2022-06-02 08:41:19 (10 litres pms , 10','2022-06-02 08:41:19','',''),('14','188',4795499,'','20','3499',1650.00,0.00,'Sales from shift 254634 on 2022-06-02 08:41:19 ','2022-06-02 08:41:19','',''),('14','188',4795500,'','6.1','3498',0.00,-5550.00,'Sales from shift 254634 on 2022-06-02 08:41:19 ','2022-06-02 08:41:19','',''),('14','188',4795501,'','customer','4195',0.00,3300.00,'Credit Sales for 20.00 Litres of Petrol from shift 254635 on 2022-06-03 15:57:00 (10 litres of pms c','2022-06-03 15:57:00','',''),('14','188',4795502,'','20','3499',11550.00,0.00,'Sales from shift 254635 on 2022-06-03 15:57:00 ','2022-06-03 15:57:00','',''),('14','188',4795503,'','6.1','3498',0.00,8250.00,'Sales from shift 254635 on 2022-06-03 15:57:00 ','2022-06-03 15:57:00','',''),('14','188',4795504,'','customer','4195',0.00,8250.00,'Credit Sales for 50.00 Litres of Petrol from shift 254636 on 2022-06-10 12:05:53 (30 litres consumed, 20 liters worth cash collected by driver)','2022-06-10 12:05:53','',''),('14','188',4795505,'','20','3499',49500.00,0.00,'Sales from shift 254636 on 2022-06-10 12:05:53 ','2022-06-10 12:05:53','',''),('14','188',4795506,'','6.1','3498',0.00,41250.00,'Sales from shift 254636 on 2022-06-10 12:05:53 ','2022-06-10 12:05:53','',''),('14','188',4795507,'','customer','4195',0.00,9900.00,'Credit Sales for 60.00 Litres of Petrol from shift 254637 on 2022-06-10 13:02:36 (30 litres consumed, 20 liters worth cash collected by driver, 10 liters worth of cash collected by cbn chief accountant the following day 9/5/2022 wit)','2022-06-10 13:02:36','',''),('14','188',4795508,'','20','3499',33000.00,0.00,'Sales from shift 254637 on 2022-06-10 13:02:36 ','2022-06-10 13:02:36','',''),('14','188',4795509,'','6.1','3498',0.00,23100.00,'Sales from shift 254637 on 2022-06-10 13:02:36 ','2022-06-10 13:02:36','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=441 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (438,'14','188','PMS','Petrol','Litres',1,165.00,165.00,165.00,165.00,0.00,0,'2021-07-22 06:52:20','646','646','2021-07-22 06:52:20',1),(439,'14','188','AGO','Diesel','Litres',1,360.00,360.00,360.00,360.00,0.00,0,'2021-07-22 07:03:06','646','646','2021-07-22 07:03:06',1),(440,'14','188','DPK','Kerosene','Litres',1,0.00,0.00,0.00,0.00,0.00,0,'2021-07-22 07:05:24','646','646','2021-07-22 07:05:24',1);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB AUTO_INCREMENT=624 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
INSERT INTO `products_changevalues` VALUES ('14','188',623,'439','254632',18920,350.00,360.00,'PRICE INCREMENT','744','2022-01-18 17:29:24');
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=17651 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (17531,'14','188',438,165.00,0.00,0.00,0.00,'Cost from purchase id #89099','2022-01-08 12:39:58','646'),(17532,'14','188',439,350.00,0.00,0.00,0.00,'Cost from purchase id #89100','2022-01-08 12:43:57','646'),(17533,'14','188',438,165.00,165.00,165.00,165.00,'','2022-01-08 13:46:11','744'),(17534,'14','188',439,350.00,350.00,350.00,350.00,'','2022-01-08 13:46:38','744'),(17650,'14','188',439,360.00,360.00,360.00,360.00,'PRICE INCREMENT','2022-01-18 17:30:52','744');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=89923 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (89099,'14','188','2022-01-08',438,260,165.00,13100.00,0.00,0.00,2161500.00,0.00,'','','TRK 55 XA','','','','2022-01-08 12:36:54',10,'','646','','0000-00-00 00:00:00','646','2022-01-08 12:39:58'),(89100,'14','188','2022-01-03',439,260,350.00,22650.00,0.00,0.00,7927500.00,0.00,'','','ZAR 264 XA','','','','2022-01-08 12:38:53',15,'','646','','0000-00-00 00:00:00','646','2022-01-08 12:43:57'),(89863,'14','188','2022-01-11',438,260,165.00,13500.00,0.00,0.00,2227500.00,0.00,'','','BWR 282 YQ','','','','2022-01-18 16:12:10',15,'','744','','0000-00-00 00:00:00','744','2022-01-18 16:12:53'),(89922,'14','188','2022-01-15',438,260,165.00,12100.00,0.00,0.00,1996500.00,0.00,'','','HJA 414 XA','','','','2022-01-19 15:23:39',15,'','744','','0000-00-00 00:00:00','744','2022-01-19 15:25:51');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=395318 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (389662,'14','188','2022-01-08',260,'','','5',1000.00,'252141','','','4071','ms aliyu','22548',5150.00,'2022-01-08 14:46:54',0,'','744','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(389665,'14','188','2022-01-08',260,'','','10',1000.00,'252141','','','','ms aliyu','',0.00,'2022-01-08 14:49:09',0,'','744','744','2022-01-08 14:53:29','','0000-00-00 00:00:00'),(389670,'14','188','2022-01-08',260,'','','10',1000.00,'252141','','','','ms aliyu','',0.00,'2022-01-08 14:50:44',0,'','744','744','2022-01-08 14:54:37','','0000-00-00 00:00:00'),(389671,'14','188','2022-01-08',260,'','','5',1150.00,'252141','','','4071','ms aliyu','0000',0.00,'2022-01-08 14:52:01',0,'','744','744','2022-01-08 14:52:46','','0000-00-00 00:00:00'),(394548,'14','188','2022-01-09',260,'','','5',408120.00,'254313','','','4071','ALIYU M SAIDU','75326',692001.10,'2022-01-17 13:26:39',5,'','744','744','2022-01-17 13:34:54','744','2022-01-17 13:37:39'),(394550,'14','188','2022-01-09',260,'','','5',230448.00,'254313','','','4082','','000',0.00,'2022-01-17 13:27:47',5,'','744','744','2022-01-17 13:29:25','744','2022-01-17 13:37:39'),(394551,'14','188','2022-01-09',260,'','','5',41890.00,'254313','','','4080','','000',0.00,'2022-01-17 13:29:06',5,'','744','744','2022-01-17 13:29:40','744','2022-01-17 13:37:39'),(394566,'14','188','2022-01-10',260,'','','5',1518800.00,'254323','','','4071','ALIYU M SAIDU','58724',2472574.60,'2022-01-17 13:54:08',0,'','744','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(394568,'14','188','2022-01-10',260,'','','5',469968.00,'254323','','','4079','','000',0.00,'2022-01-17 13:56:07',0,'','744','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(394570,'14','188','2022-01-10',260,'','','5',245532.00,'254323','','','4080','','000',0.00,'2022-01-17 13:57:19',0,'','744','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(394571,'14','188','2022-01-10',260,'','','5',81906.00,'254323','','','4082','','000',0.00,'2022-01-17 13:59:06',0,'','744','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(394679,'14','188','2022-01-11',260,'','','5',556600.00,'254361','','','4071','ALIYU M SAIDU','300864379',1016279.85,'2022-01-17 16:02:57',0,'','744','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(394682,'14','188','2022-01-11',260,'','','5',257500.00,'254361','','','4079','ALIYU M SAIDU','000',0.00,'2022-01-17 16:03:52',0,'','744','744','2022-01-17 16:07:50','','0000-00-00 00:00:00'),(394683,'14','188','2022-01-11',260,'','','5',259592.00,'254361','','','4080','ALIYU M SAIDU','0000',0.00,'2022-01-17 16:04:46',0,'','744','744','2022-01-17 16:08:05','','0000-00-00 00:00:00'),(394684,'14','188','2022-01-11',260,'','','5',45000.00,'254361','','','4082','ALIYU M SAIDU','000',0.00,'2022-01-17 16:05:23',0,'','744','744','2022-01-17 16:08:19','','0000-00-00 00:00:00'),(395269,'14','188','2022-01-12',260,'','','5',839950.00,'254610','','','4071','ALIYU M SAIDU','300864379',1540444.30,'2022-01-18 15:42:26',0,'','744','744','2022-01-18 15:44:55','','0000-00-00 00:00:00'),(395272,'14','188','2022-01-12',260,'','','10',259592.00,'254610','','','4080','','000',0.00,'2022-01-18 15:47:52',0,'','744','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(395274,'14','188','2022-01-12',260,'','','10',45000.00,'254610','','','4082','','000',0.00,'2022-01-18 15:49:50',0,'','744','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(395276,'14','188','2022-01-18',260,'','','10',257500.00,'254610','','','4079','','000',0.00,'2022-01-18 15:51:38',0,'','744','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(395305,'14','188','2022-01-13',260,'','','5',202789.00,'254624','','','4079','ALIYU M SAIDU','000',0.00,'2022-01-18 16:54:13',0,'','744','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(395307,'14','188','2022-01-13',260,'','','5',186915.00,'254624','','','4082','ALIYU M SAIDU','000',0.00,'2022-01-18 16:55:06',0,'','744','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(395310,'14','188','2022-01-13',260,'','','5',839950.00,'254624','','','4071','ALIYU M SAIDU','75326',1404659.95,'2022-01-18 16:58:08',0,'','744','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(395315,'14','188','2022-01-14',260,'','','5',832700.00,'254628','','','4071','ALIYU M SAIDU','000',612365.30,'2022-01-18 17:22:31',0,'','744','744','2022-01-18 17:25:10','','0000-00-00 00:00:00'),(395316,'14','188','2022-01-14',260,'','','5',155127.00,'254628','','','4079','ALIYU M SAIDU','000',0.00,'2022-01-18 17:23:15',0,'','744','744','2022-01-18 17:25:21','','0000-00-00 00:00:00'),(395317,'14','188','2022-01-14',260,'','','5',26951.00,'254628','','','4080','ALIYU M SAIDU','000',0.00,'2022-01-18 17:23:54',0,'','744','744','2022-01-18 17:25:30','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=131405 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (130172,'14',89099,'188',438,260,'2022-01-08 00:00:00','OGERE',3000.00,3000.00,0.00,'','','975','TRK 55 XA','ATTIKU','08055544463','',5,'2022-01-08 12:42:57','646','0000-00-00 00:00:00','','2022-01-08 12:43:24','646'),(130173,'14',89099,'188',438,260,'2022-01-08 00:00:00','OGERE',6000.00,6000.00,0.00,'','','978','TRK 55 XA','ATTIKU','08055544463','',5,'2022-01-08 12:42:57','646','0000-00-00 00:00:00','','2022-01-08 12:43:24','646'),(130177,'14',89100,'188',439,260,'2022-01-08 00:00:00','OGERE',22650.00,22650.00,0.00,'','','979','ZAR 264 XA','KB','08066655874','',5,'2022-01-08 12:50:50','646','0000-00-00 00:00:00','','2022-01-08 12:51:04','646'),(131323,'14',89863,'188',438,260,'2022-01-18 00:00:00','LAGOS',8250.00,8250.00,0.00,'3','','975','BWR 282 YQ','ALI','08063488369','',5,'2022-01-18 16:15:31','744','0000-00-00 00:00:00','','2022-01-18 16:16:04','744'),(131324,'14',89863,'188',438,260,'2022-01-18 00:00:00','LAGOS',5250.00,5250.00,0.00,'3','','978','BWR 282 YQ','ALI','08063488369','',5,'2022-01-18 16:15:31','744','0000-00-00 00:00:00','','2022-01-18 16:16:04','744'),(131404,'14',89922,'188',438,260,'2022-01-19 00:00:00','LAGOS',12100.00,12100.00,0.00,'06','','978','HJA 414 XA','MUSA ABDULLAHI','08063488369','',5,'2022-01-19 15:28:45','744','0000-00-00 00:00:00','','2022-01-19 15:31:20','744');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB AUTO_INCREMENT=347267 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
INSERT INTO `sales` VALUES (344857,'14','188','252115',1,'2022-01-08',438,4157,165.00,0.00,309.20,0.00,0.00,0.00,'1641646184','2022-01-08 13:49:44',15,0,'approved by gm',NULL,'744','','0000-00-00 00:00:00','744','2022-01-08 13:50:08'),(344858,'14','188','252115',1,'2022-01-08',438,4156,165.00,0.00,309.20,0.00,0.00,0.00,'1641646184','2022-01-08 13:49:44',15,0,'approved by gm',NULL,'744','','0000-00-00 00:00:00','744','2022-01-08 13:50:08'),(344895,'14','188','252141',1,'2022-01-08',438,4158,165.00,165.00,2.00,0.00,0.00,330.00,'1641649530','2022-01-08 14:45:30',15,0,'approved by gm',NULL,'744','','0000-00-00 00:00:00','744','2022-01-08 14:45:55'),(344896,'14','188','252141',1,'2022-01-08',438,4157,165.00,165.00,2.00,0.00,0.00,330.00,'1641649530','2022-01-08 14:45:30',15,0,'approved by gm',NULL,'744','','0000-00-00 00:00:00','744','2022-01-08 14:45:55'),(346831,'14','188','254313',1,'2022-01-17',438,4156,165.00,165.00,70.00,0.00,0.00,11550.00,'1642422181','2022-01-17 13:23:01',15,0,'APPROVED BY CHAIRMAN',NULL,'744','','0000-00-00 00:00:00','744','2022-01-17 13:37:02'),(346842,'14','188','254323',1,'2022-01-17',438,4157,165.00,165.00,312.00,0.00,0.00,51480.00,'1642423829','2022-01-17 13:50:29',15,0,'APPROVED BY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-17 15:50:13'),(346843,'14','188','254323',1,'2022-01-17',439,4157,350.00,350.00,60.00,0.00,0.00,21000.00,'1642423829','2022-01-17 13:50:29',15,0,'APPROVEDBY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-17 15:50:13'),(346844,'14','188','254323',1,'2022-01-17',438,4156,165.00,165.00,175.00,0.00,0.00,28875.00,'1642423829','2022-01-17 13:50:29',15,0,'APPROVEDBY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-17 15:50:13'),(346845,'14','188','254323',1,'2022-01-17',438,4158,165.00,165.00,250.05,0.00,0.00,41258.25,'1642423829','2022-01-17 13:50:29',15,0,'APPROVBY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-17 15:50:13'),(346923,'14','188','254361',1,'2022-01-17',438,4157,165.00,165.00,299.00,0.00,0.00,49335.00,'1642431559','2022-01-17 15:59:19',15,0,'APPRVED BY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-17 16:10:41'),(346924,'14','188','254361',1,'2022-01-17',439,4156,350.00,350.00,20.00,0.00,0.00,7000.00,'1642431559','2022-01-17 15:59:19',15,0,'APPRVEDBY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-17 16:10:41'),(346925,'14','188','254361',1,'2022-01-17',438,4157,165.00,165.00,495.00,0.00,0.00,81675.00,'1642431559','2022-01-17 15:59:19',15,0,'APPROVED BY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-17 16:10:41'),(347184,'14','188','254610',1,'2022-01-18',438,4191,165.00,165.00,55.00,0.00,0.00,9075.00,'1642516735','2022-01-18 15:38:55',15,0,'APPROVED BY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-18 15:40:03'),(347185,'14','188','254610',1,'2022-01-18',438,4157,165.00,165.00,396.00,0.00,0.00,65340.00,'1642516735','2022-01-18 15:38:55',15,0,'APPROVED BY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-18 15:40:03'),(347186,'14','188','254610',1,'2022-01-18',438,4156,165.00,165.00,110.00,0.00,0.00,18150.00,'1642516735','2022-01-18 15:38:55',15,0,'APPROVED BY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-18 15:40:03'),(347187,'14','188','254610',1,'2022-01-18',438,4193,165.00,165.00,60.60,0.00,0.00,9999.00,'1642516735','2022-01-18 15:38:55',15,0,'APPROVED BY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-18 15:40:03'),(347249,'14','188','254624',1,'2022-01-18',439,4191,350.00,350.00,120.00,0.00,0.00,42000.00,'1642521005','2022-01-18 16:50:05',15,0,'APPOVED BY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-18 16:51:04'),(347250,'14','188','254624',1,'2022-01-18',438,4191,165.00,165.00,197.81,0.00,0.00,32638.65,'1642521005','2022-01-18 16:50:05',15,0,'APPROVED BY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-18 16:51:04'),(347251,'14','188','254624',1,'2022-01-18',439,4192,350.00,350.00,43.00,0.00,0.00,15050.00,'1642521005','2022-01-18 16:50:05',15,0,'APPROVED BY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-18 16:51:04'),(347252,'14','188','254624',1,'2022-01-18',439,4157,350.00,350.00,210.00,0.00,0.00,73500.00,'1642521005','2022-01-18 16:50:05',15,0,'APPROVED BY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-18 16:51:04'),(347253,'14','188','254624',1,'2022-01-18',439,4196,350.00,350.00,53.54,0.00,0.00,18739.00,'1642521005','2022-01-18 16:50:05',15,0,'APPROVED BY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-18 16:51:04'),(347254,'14','188','254624',1,'2022-01-18',438,4157,165.00,165.00,206.98,0.00,0.00,34151.70,'1642521005','2022-01-18 16:50:05',15,0,'APPROVED BY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-18 16:51:04'),(347255,'14','188','254624',1,'2022-01-18',438,4190,165.00,165.00,45.38,0.00,0.00,7487.70,'1642521005','2022-01-18 16:50:05',15,0,'APPROVED  BY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-18 16:51:04'),(347258,'14','188','254628',1,'2022-01-18',439,4191,350.00,350.00,140.00,0.00,0.00,49000.00,'1642522843','2022-01-18 17:20:43',15,0,'APPROVED BY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-18 17:26:21'),(347259,'14','188','254628',1,'2022-01-18',438,4191,165.00,165.00,65.00,0.00,0.00,10725.00,'1642522843','2022-01-18 17:20:43',15,0,'APPROVED BY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-18 17:26:21'),(347260,'14','188','254628',1,'2022-01-18',438,4157,165.00,165.00,538.00,0.00,0.00,88770.00,'1642522843','2022-01-18 17:20:43',15,0,'APPROVED BY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-18 17:26:21'),(347261,'14','188','254628',1,'2022-01-18',438,4156,165.00,165.00,278.18,0.00,0.00,45899.70,'1642522843','2022-01-18 17:20:43',15,0,'APPROVED BY GMD',NULL,'744','','0000-00-00 00:00:00','744','2022-01-18 17:26:21'),(347263,'14','188','254634',1,'2022-06-02',439,4195,360.00,360.00,20.00,0.00,0.00,7200.00,'1654155667','2022-06-02 08:41:07',15,0,'approved by supervisor','10 litres pms , 10 litres cash issued ','744','','0000-00-00 00:00:00','744','2022-06-02 08:41:19'),(347264,'14','188','254635',1,'2022-06-03',438,4195,165.00,165.00,20.00,0.00,0.00,3300.00,'1654268204','2022-06-03 15:56:44',15,0,'APPROVED BY SUPERVISOR','10 litres of pms consumed , 10 litres worth of pms collected as cash ','744','','0000-00-00 00:00:00','744','2022-06-03 15:57:00'),(347265,'14','188','254636',1,'2022-06-10',438,4195,165.00,165.00,50.00,0.00,0.00,8250.00,'1654859140','2022-06-10 12:05:40',15,0,'Approved by supervisor','30 litres consumed, 20 liters worth cash collected by driver','744','','0000-00-00 00:00:00','744','2022-06-10 12:05:53'),(347266,'14','188','254637',1,'2022-06-10',438,4195,165.00,165.00,60.00,0.00,0.00,9900.00,'1654862208','2022-06-10 12:56:48',15,0,'approved by supervisor','30 litres consumed, 20 liters worth cash collected by driver, 10 liters worth of cash collected by cbn chief accountant the following day 9/5/2022 wit','744','','0000-00-00 00:00:00','744','2022-06-10 13:02:36');
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB AUTO_INCREMENT=266393 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
INSERT INTO `sales_distributions` VALUES (264532,'14',344857,'',0,'188',438,4157,'2022-01-08',309.20,'','','','978','2889','','','Dispensed on shift # 252115',5,'2022-01-08 13:50:08','744','0000-00-00 00:00:00','','2022-01-08 13:50:08','744'),(264533,'14',344858,'',0,'188',438,4156,'2022-01-08',309.20,'','','','978','2889','','','Dispensed on shift # 252115',5,'2022-01-08 13:50:08','744','0000-00-00 00:00:00','','2022-01-08 13:50:08','744'),(264542,'14',344895,'',0,'188',438,4158,'2022-01-08',2.00,'','','','978','2889','','','Dispensed on shift # 252141',5,'2022-01-08 14:45:55','744','0000-00-00 00:00:00','','2022-01-08 14:45:55','744'),(264543,'14',344896,'',0,'188',438,4157,'2022-01-08',2.00,'','','','978','2889','','','Dispensed on shift # 252141',5,'2022-01-08 14:45:55','744','0000-00-00 00:00:00','','2022-01-08 14:45:55','744'),(266102,'14',346831,'',0,'188',438,4156,'2022-01-17',70.00,'','','','975','2882','','','Dispensed on shift # 254313',5,'2022-01-17 13:37:02','744','0000-00-00 00:00:00','','2022-01-17 13:37:02','744'),(266121,'14',346842,'',0,'188',438,4157,'2022-01-17',312.00,'','','','978','2889','','','Dispensed on shift # 254323',5,'2022-01-17 15:50:13','744','0000-00-00 00:00:00','','2022-01-17 15:50:13','744'),(266122,'14',346843,'',0,'188',439,4157,'2022-01-17',60.00,'','','','979','2891','','','Dispensed on shift # 254323',5,'2022-01-17 15:50:13','744','0000-00-00 00:00:00','','2022-01-17 15:50:13','744'),(266123,'14',346844,'',0,'188',438,4156,'2022-01-17',175.00,'','','','978','2889','','','Dispensed on shift # 254323',5,'2022-01-17 15:50:13','744','0000-00-00 00:00:00','','2022-01-17 15:50:13','744'),(266124,'14',346845,'',0,'188',438,4158,'2022-01-17',250.05,'','','','978','2889','','','Dispensed on shift # 254323',5,'2022-01-17 15:50:13','744','0000-00-00 00:00:00','','2022-01-17 15:50:13','744'),(266128,'14',346923,'',0,'188',438,4157,'2022-01-17',299.00,'','','','975','2882','','','Dispensed on shift # 254361',5,'2022-01-17 16:10:41','744','0000-00-00 00:00:00','','2022-01-17 16:10:41','744'),(266129,'14',346924,'',0,'188',439,4156,'2022-01-17',20.00,'','','','979','2891','','','Dispensed on shift # 254361',5,'2022-01-17 16:10:41','744','0000-00-00 00:00:00','','2022-01-17 16:10:41','744'),(266130,'14',346925,'',0,'188',438,4157,'2022-01-17',495.00,'','','','975','2882','','','Dispensed on shift # 254361',5,'2022-01-17 16:10:41','744','0000-00-00 00:00:00','','2022-01-17 16:10:41','744'),(266340,'14',347184,'',0,'188',438,4191,'2022-01-18',55.00,'','','','975','2882','','','Dispensed on shift # 254610',5,'2022-01-18 15:40:03','744','0000-00-00 00:00:00','','2022-01-18 15:40:03','744'),(266341,'14',347185,'',0,'188',438,4157,'2022-01-18',396.00,'','','','975','2882','','','Dispensed on shift # 254610',5,'2022-01-18 15:40:03','744','0000-00-00 00:00:00','','2022-01-18 15:40:03','744'),(266342,'14',347186,'',0,'188',438,4156,'2022-01-18',110.00,'','','','975','2882','','','Dispensed on shift # 254610',5,'2022-01-18 15:40:03','744','0000-00-00 00:00:00','','2022-01-18 15:40:03','744'),(266343,'14',347187,'',0,'188',438,4193,'2022-01-18',60.60,'','','','975','2882','','','Dispensed on shift # 254610',5,'2022-01-18 15:40:03','744','0000-00-00 00:00:00','','2022-01-18 15:40:03','744'),(266358,'14',347249,'',0,'188',439,4191,'2022-01-18',120.00,'','','','979','2891','','','Dispensed on shift # 254624',5,'2022-01-18 16:51:04','744','0000-00-00 00:00:00','','2022-01-18 16:51:04','744'),(266359,'14',347250,'',0,'188',438,4191,'2022-01-18',197.81,'','','','978','2889','','','Dispensed on shift # 254624',5,'2022-01-18 16:51:04','744','0000-00-00 00:00:00','','2022-01-18 16:51:04','744'),(266360,'14',347251,'',0,'188',439,4192,'2022-01-18',43.00,'','','','979','2891','','','Dispensed on shift # 254624',5,'2022-01-18 16:51:04','744','0000-00-00 00:00:00','','2022-01-18 16:51:04','744'),(266361,'14',347252,'',0,'188',439,4157,'2022-01-18',210.00,'','','','979','2891','','','Dispensed on shift # 254624',5,'2022-01-18 16:51:04','744','0000-00-00 00:00:00','','2022-01-18 16:51:04','744'),(266362,'14',347253,'',0,'188',439,4196,'2022-01-18',53.54,'','','','979','2891','','','Dispensed on shift # 254624',5,'2022-01-18 16:51:04','744','0000-00-00 00:00:00','','2022-01-18 16:51:04','744'),(266363,'14',347254,'',0,'188',438,4157,'2022-01-18',206.98,'','','','978','2889','','','Dispensed on shift # 254624',5,'2022-01-18 16:51:04','744','0000-00-00 00:00:00','','2022-01-18 16:51:04','744'),(266364,'14',347255,'',0,'188',438,4190,'2022-01-18',45.38,'','','','978','2889','','','Dispensed on shift # 254624',5,'2022-01-18 16:51:04','744','0000-00-00 00:00:00','','2022-01-18 16:51:04','744'),(266385,'14',347258,'',0,'188',439,4191,'2022-01-18',140.00,'','','','979','2891','','','Dispensed on shift # 254628',5,'2022-01-18 17:26:21','744','0000-00-00 00:00:00','','2022-01-18 17:26:21','744'),(266386,'14',347259,'',0,'188',438,4191,'2022-01-18',65.00,'','','','977','2886','','','Dispensed on shift # 254628',5,'2022-01-18 17:26:21','744','0000-00-00 00:00:00','','2022-01-18 17:26:21','744'),(266387,'14',347260,'',0,'188',438,4157,'2022-01-18',538.00,'','','','977','2886','','','Dispensed on shift # 254628',5,'2022-01-18 17:26:21','744','0000-00-00 00:00:00','','2022-01-18 17:26:21','744'),(266388,'14',347261,'',0,'188',438,4156,'2022-01-18',278.18,'','','','977','2886','','','Dispensed on shift # 254628',5,'2022-01-18 17:26:21','744','0000-00-00 00:00:00','','2022-01-18 17:26:21','744'),(266389,'14',347263,'',0,'188',439,4195,'2022-06-02',20.00,'','','','','','','','Dispensed on shift # 254634',5,'2022-06-02 08:41:19','744','0000-00-00 00:00:00','','2022-06-02 08:41:19','744'),(266390,'14',347264,'',0,'188',438,4195,'2022-06-03',20.00,'','','','977','2886','','','Dispensed on shift # 254635',5,'2022-06-03 15:57:00','744','0000-00-00 00:00:00','','2022-06-03 15:57:00','744'),(266391,'14',347265,'',0,'188',438,4195,'2022-06-10',50.00,'','','','975','2883','','','Dispensed on shift # 254636',5,'2022-06-10 12:05:53','744','0000-00-00 00:00:00','','2022-06-10 12:05:53','744'),(266392,'14',347266,'',0,'188',438,4195,'2022-06-10',60.00,'','','','975','2882','','','Dispensed on shift # 254637',5,'2022-06-10 13:02:36','744','0000-00-00 00:00:00','','2022-06-10 13:02:36','744');
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=371 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (260,'14','188','EDI-JEN NIGERIA LIMITED','MOHAMMED','08068958943','mohammed@edi-jengroup.com','KADUNA','KADUNA','HQ 2C Ahmadu Bello WAY KADUNA NORTH.','Nigeria',0.00,0.00,'0000-00-00','2021-07-22 06:43:53',5,'646','2021-07-22 06:43:53','646'),(370,'14','188','Omapet Gas Plant','Patience Adah','08035160095','patdav@gmail.com','Kaduna State','Kaduna ','Industrial Layout Kakuri, Kaduna','Nigeria',0.00,0.00,'0000-00-00','2022-01-24 17:00:48',5,'744','2022-01-24 17:00:48','744');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:51:03
